/*
 Copyright 2009-2013 Luc Saffre
 This file is part of the Lino project.
 Lino is free software; you can redistribute it and/or modify 
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.
 Lino is distributed in the hope that it will be useful, 
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 GNU General Public License for more details.
 You should have received a copy of the GNU General Public License
 along with Lino; if not, see <http://www.gnu.org/licenses/>.
*/

// lino.js --- generated Mon Jul 22 19:13:03 2013 by Lino version 1.6.11.
Ext.BLANK_IMAGE_URL = '/media/extjs/resources/images/default/s.gif';
LANGUAGE_CHOICES = [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ];
MEDIA_URL = "/media";

/* MonthPickerPlugin: thanks to keypoint @ sencha forum
   http://www.sencha.com/forum/showthread.php?74002-3.x-Ext.ux.MonthMenu&p=356860#post356860
*/
Ext.namespace('Ext.ux'); 

Ext.ux.MonthPickerPlugin = function() { 
    var picker; 
    var oldDateDefaults; 

    this.init = function(pk) { 
        picker = pk; 
        picker.onTriggerClick = picker.onTriggerClick.createSequence(onClick); 
        picker.getValue = picker.getValue.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
        picker.beforeBlur = picker.beforeBlur.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
    }; 

    function setDefaultMonthDay() { 
        oldDateDefaults = Date.defaults.d; 
        Date.defaults.d = 1; 
        return true; 
    } 

    function restoreDefaultMonthDay(ret) { 
        Date.defaults.d = oldDateDefaults; 
        return ret; 
    } 

    function onClick(e, el, opt) { 
        var p = picker.menu.picker; 
        p.activeDate = p.activeDate.getFirstDateOfMonth(); 
        if (p.value) { 
            p.value = p.value.getFirstDateOfMonth(); 
        } 

        p.showMonthPicker(); 
         
        if (!p.disabled) { 
            p.monthPicker.stopFx(); 
            p.monthPicker.show(); 

            p.mun(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mun(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
            p.onMonthClick = p.onMonthClick.createSequence(pickerClick); 
            p.onMonthDblClick = p.onMonthDblClick.createSequence(pickerDblclick); 
            p.mon(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mon(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
        } 
    } 

    function pickerClick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.is('button.x-date-mp-cancel')) { 
            picker.menu.hide(); 
        } else if(el.is('button.x-date-mp-ok')) { 
            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 

    function pickerDblclick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.parent() 
            && (el.parent().is('td.x-date-mp-month') 
            || el.parent().is('td.x-date-mp-year'))) { 

            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 
}; 

Ext.preg('monthPickerPlugin', Ext.ux.MonthPickerPlugin);  

//~ /* 
  //~ http://www.diloc.de/blog/2008/03/05/how-to-submit-ext-forms-the-right-way/
//~ */
//~ /**
 //~ * This submit action is basically the same as the normal submit action,
 //~ * only that it uses the fields getSubmitValue() to compose the values to submit,
 //~ * instead of looping over the input-tags in the form-tag of the form.
 //~ *
 //~ * To use it, just use the OOSubmit-plugin on either a FormPanel or a BasicForm,
 //~ * or explicitly call form.doAction('oosubmit');
 //~ *
 //~ * @param {Object} form
 //~ * @param {Object} options
 //~ */
//~ Ext.ux.OOSubmitAction = function(form, options){
    //~ Ext.ux.OOSubmitAction.superclass.constructor.call(this, form, options);
//~ };

//~ Ext.extend(Ext.ux.OOSubmitAction, Ext.form.Action.Submit, {
    //~ /**
    //~ * @cfg {boolean} clientValidation Determines whether a Form's fields are validated
    //~ * in a final call to {@link Ext.form.BasicForm#isValid isValid} prior to submission.
    //~ * Pass <tt>false</tt> in the Form's submit options to prevent this. If not defined, pre-submission field validation
    //~ * is performed.
    //~ */
    //~ type : 'oosubmit',

    //~ // private
    //~ /**
     //~ * This is nearly a copy of the original submit action run method
     //~ */
    //~ run : function(){
        //~ var o = this.options;
        //~ var method = this.getMethod();
        //~ var isPost = method == 'POST';

        //~ var params = this.options.params || {};
        //~ if (isPost) Ext.applyIf(params, this.form.baseParams);

        //~ //now add the form parameters
        //~ this.form.items.each(function(field)
        //~ {
            //~ if (!field.disabled)
            //~ {
                //~ //check if the form item provides a specialized getSubmitValue() and use that if available
                //~ if (typeof field.getSubmitValue == "function")
                    //~ params[field.getName()] = field.getSubmitValue();
                //~ else
                    //~ params[field.getName()] = field.getValue();
            //~ }
        //~ });

        //~ //convert params to get style if we are not post
        //~ if (!isPost) params=Ext.urlEncode(params);

        //~ if(o.clientValidation === false || this.form.isValid()){
            //~ Ext.Ajax.request(Ext.apply(this.createCallback(o), {
                //~ url:this.getUrl(!isPost),
                //~ method: method,
                //~ params:params, //add our values
                //~ isUpload: this.form.fileUpload
            //~ }));

        //~ }else if (o.clientValidation !== false){ // client validation failed
            //~ this.failureType = Ext.form.Action.CLIENT_INVALID;
            //~ this.form.afterAction(this, false);
        //~ }
    //~ },

//~ });
//~ //add our action to the registry of known actions
//~ Ext.form.Action.ACTION_TYPES['oosubmit'] = Ext.ux.OOSubmitAction;




/**
JC Watsons solution (adapted to ExtJS 3.3.1 by LS) is elegant and simple:
`A "fix" for unchecked checkbox submission  behaviour
<http://www.sencha.com/forum/showthread.php?28449>`_

Added special handling for checkbox inputs. 
ExtJS defines disabled checkboxes `readonly`, not `disabled` as for other inputs.

*/
Ext.lib.Ajax.serializeForm = function(form) {
    //~ console.log('20120203 linolib.js serializeForm',form);
    var fElements = form.elements || (document.forms[form] || Ext.getDom(form)).elements, 
        hasSubmit = false, 
        encoder = encodeURIComponent, 
        name, 
        data = '', 
        type, 
        hasValue;

    Ext.each(fElements, function(element){
        name = element.name;
        type = element.type;

        if (!element.disabled && name && !(type == 'checkbox' && element.readonly)) {
            if (/select-(one|multiple)/i.test(type)) {
                Ext.each(element.options, function(opt){
                    if (opt.selected) {
                        hasValue = opt.hasAttribute ? opt.hasAttribute('value') : opt.getAttributeNode('value').specified;
                        data += String.format("{0}={1}&", encoder(name), encoder(hasValue ? opt.value : opt.text));
                    }
                });
            } else if (!(/file|undefined|reset|button/i.test(type))) {
                //~ if (!(/radio|checkbox/i.test(type) && !element.checked) && !(type == 'submit' && hasSubmit)) {
                if (!(type == 'submit' && hasSubmit)) {
                    if (type == 'checkbox') {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&');
                        data += encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&';
                    } else {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + encoder(element.value) + '&');
                        data += encoder(name) + '=' + encoder(element.value) + '&';
                    }
                    hasSubmit = /submit/i.test(type);
                }
            }
        //~ } else {
            //~ console.log(name,type,element.readonly);
        }
    });
    return data.substr(0, data.length - 1);
};



/*
Set a long timeout of fifteen minutes. 
See /blog/2012/0307
*/
Ext.Ajax.timeout = 15 * 60 * 1000; 


/*
My fix for the "Cannot set QuickTips dismissDelay to 0" bug,
see http://www.sencha.com/forum/showthread.php?183515 
*/
Ext.override(Ext.QuickTip,{
  showAt : function(xy){
        var t = this.activeTarget;
        //~ console.log("20120224 QuickTip.showAt",this.title,this.dismissDelay,t.dismissDelay);
        if(t){
            if(!this.rendered){
                this.render(Ext.getBody());
                this.activeTarget = t;
            }
            if(t.width){
                this.setWidth(t.width);
                this.body.setWidth(this.adjustBodyWidth(t.width - this.getFrameWidth()));
                this.measureWidth = false;
            } else{
                this.measureWidth = true;
            }
            this.setTitle(t.title || '');
            this.body.update(t.text);
            this.autoHide = t.autoHide;
            // bugfix by Luc 20120226
            if (t.dismissDelay != undefined) this.dismissDelay = t.dismissDelay;
            //~ this.dismissDelay = t.dismissDelay || this.dismissDelay;
            if(this.lastCls){
                this.el.removeClass(this.lastCls);
                delete this.lastCls;
            }
            if(t.cls){
                this.el.addClass(t.cls);
                this.lastCls = t.cls;
            }
            if(this.anchor){
                this.constrainPosition = false;
            }else if(t.align){ 
                xy = this.el.getAlignToXY(t.el, t.align);
                this.constrainPosition = false;
            }else{
                this.constrainPosition = true;
            }
        }
        Ext.QuickTip.superclass.showAt.call(this, xy);
    }
});

/*
Another hack. See /docs/blog/2012/0228
*/
Ext.Element.addMethods(
    function() {
        var VISIBILITY      = "visibility",
            DISPLAY         = "display",
            HIDDEN          = "hidden",
            NONE            = "none",
            XMASKED         = "x-masked",
            XMASKEDRELATIVE = "x-masked-relative",
            data            = Ext.Element.data;

        return {
            
            mask : function(msg, msgCls) {
                var me  = this,
                    dom = me.dom,
                    dh  = Ext.DomHelper,
                    EXTELMASKMSG = "ext-el-mask-msg",
                    el,
                    mask;
                // removed the following lines. See /docs/blog/2012/0228
                //~ if (!(/^body/i.test(dom.tagName) && me.getStyle('position') == 'static')) {
                    //~ console.log(20120228,dom.tagName,me);
                    //~ me.addClass(XMASKEDRELATIVE); 
                //~ }
                if (el = data(dom, 'maskMsg')) {
                    el.remove();
                }
                if (el = data(dom, 'mask')) {
                    el.remove();
                }

                mask = dh.append(dom, {cls : "ext-el-mask"}, true);
                data(dom, 'mask', mask);

                me.addClass(XMASKED);
                mask.setDisplayed(true);
                
                if (typeof msg == 'string') {
                    var mm = dh.append(dom, {cls : EXTELMASKMSG, cn:{tag:'div'}}, true);
                    data(dom, 'maskMsg', mm);
                    mm.dom.className = msgCls ? EXTELMASKMSG + " " + msgCls : EXTELMASKMSG;
                    mm.dom.firstChild.innerHTML = msg;
                    mm.setDisplayed(true);
                    mm.center(me);
                }
                
                
                if (Ext.isIE && !(Ext.isIE7 && Ext.isStrict) && me.getStyle('height') == 'auto') {
                    mask.setSize(undefined, me.getHeight());
                }
                
                return mask;
            }

            
        };
    }()
);



Ext.namespace('Lino');
    
    

//~ Lino.subst_user_field = new Ext.form.ComboBox({});
//~ Lino.subst_user = null;
Lino.insert_subst_user = function(p){
    //~ console.log('20120714 insert_subst_user',Lino.subst_user,p);
    //~ if (Lino.subst_user_field.getValue()) {
    if (p.su) return;
    if (Lino.subst_user) {
        //~ p.su = Lino.subst_user_field.getValue();
        p.su = Lino.subst_user;
    //~ } else {
        //~ delete p.su;
    }
    //~ console.log('20120714 insert_subst_user -->',Lino.subst_user,p);
}

Lino.login_window = null;


Lino.show_login_window = function() {
  //~ console.log('20121103 show_login_window',arguments);
  //~ var current_window = Lino.current_window;
  if (Lino.login_window == null) {
    
      function do_login() { 
            Lino.viewport.loadMask.show()
            //~ Lino.body_loadMask.show()
            login_panel.getForm().submit({ 
                method:'POST', 
                waitTitle:'Connecting', 
                waitMsg:'Sending data...',
                success:function(){ 
                  //~ console.log('20121104 logged in',arguments);
                  Lino.login_window.hide();
                  Lino.close_all_windows();
                  Lino.viewport.loadMask.hide()
                  //~ Lino.body_loadMask.hide()
                },
                failure: function(form,action) { 
                  //~ this.loadMask.hide();
                  Lino.on_submit_failure(form,action);
                  Lino.viewport.loadMask.hide()
                  //~ Lino.body_loadMask.hide()
                  //~ if (Lino.current_window) Lino.current_window.main_item.loadMask.hide()
                }
                //~ failure:function(form, action){ 
                    //~ alert_msg
                    //~ if(action.failureType == 'server'){ 
                        //~ obj = Ext.util.JSON.decode(action.response.responseText); 
                        //~ Ext.Msg.alert('Login Failed!', obj.errors.reason); 
                    //~ }else{ 
                        //~ Ext.Msg.alert('Warning!', 'Authentication server is unreachable : ' + action.response.responseText); 
                    //~ } 
                    //~ Lino.login_panel.getForm().reset(); 
                //~ } 
            }); 
      };
    
      var login_button = new Ext.Button({ 
        text:"Log in",
        formBind: true,	 
        // Function that fires when user clicks the button 
        handler: do_login});
    
      var login_panel = new Ext.FormPanel({ 
        //~ inspired by http://www.sencha.com/learn/a-basic-login/
        autoHeight:true,
        labelWidth:90,
        url:'/auth', 
        frame:true, 
        defaultType:'textfield',
        monitorValid:true,
        items:[{ 
            fieldLabel:"Username", 
            id: 'username',
            name:'username', 
            autoHeight:true,
            allowBlank:false 
        },{ 
            fieldLabel:"Password", 
            name:'password', 
            inputType:'password', 
            autoHeight:true,
            allowBlank:false 
        }],        
        buttons:[ login_button ]});
        
      Lino.login_window = new Ext.Window({
          layout:'fit',
          defaultButton: 'username',
          width:300,
          title:"Log in", 
          autoHeight:true,
          modal: true,
          closeAction: "hide",
          keys: {
            key: Ext.EventObject.ENTER,
            fn: function() { do_login()}
          },
          //~ defaultButton: login_button,
          //~ height:'auto',
          //~ closable: false,
          //~ resizable: false,
          //~ plain: true,
          //~ border: false,
          items: [login_panel] });
  };
  Lino.login_window.show();
};

Lino.logout = function(id,name) {
    //~ console.log('20121104 gonna log out',arguments);
    //~ Lino.do_action
    Lino.call_ajax_action(Lino.viewport,'GET','/auth',{},'logout',undefined,undefined,function(){
        //~ console.log('20121104 logged out',arguments);
        //~ Lino.login_window.hide();
        Lino.close_all_windows();
    })
}

Lino.set_subst_user = function(id,name) {
    //~ console.log(20120714,'Lino.set_subst_user',id,name);
    Lino.subst_user = id;

    if(id) {
        Lino.eventStore.setBaseParam("su",id);
    } else {
      delete Lino.eventStore.baseParams['su'];
    }

    if (Lino.current_window) 
        Lino.current_window.main_item.set_base_param("su",id);
    if (Lino.viewport) Lino.permalink_handler(Lino.current_window)();
}



//~ Lino.select_subst_user = function(cmp,rec,value){
    //~ Lino.subst_user=value;
    //~ console.log(20120713,rec);
//~ }
    
Lino.current_window = null;
Lino.window_history = Array();
    
Lino.chars2width = function(cols) {  return cols * 9; }
Lino.rows2height = function(cols) {  return cols * 20; }



Lino.Viewport = Ext.extend(Ext.Viewport,{
  layout:"fit"
  ,initComponent : function(){
    Lino.Viewport.superclass.initComponent.call(this);
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.el,{msg:"Please wait..."});
      //~ console.log("20121118 Lino.viewport.loadMask",this.loadMask);
    },this);
  }
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,refresh : function() {
      var caller = this;
      console.log("20121120 Lino.Viewport.refresh()");
      if (caller.loadMask) caller.loadMask.show();
      var success = function(response) {
        if (caller.loadMask) caller.loadMask.hide();
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          //~ console.log('Lino.do_action()',action.name,'result is',result);
          if (result.html) {
              Ext.getCmp('main_area').update(result.html);
          }
          if (result.message) {
              if (result.alert) {
                  //~ Ext.MessageBox.alert('Alert',result.alert_msg);
                  Ext.MessageBox.alert('Alert',result.message);
              } else {
                  Lino.notify(result.message);
              }
          }
          
          if (result.notify_msg) Lino.notify(result.notify_msg);
          if (result.js_code) { 
            var jsr = result.js_code(caller);
            //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
          };
        }
      };
      var action = {
        url : '/api/main_html',
        waitMsg: "Please wait...",
        failure: Lino.ajax_error_handler(caller),
        success: success,
        method: 'GET',
        params: {}
      };
      Lino.insert_subst_user(action.params);
      Ext.Ajax.request(action);
    
  }
});


Lino.open_window = function(win,st,requesting_panel) {
  //~ console.log("20120918 Lino.open_window()",win,st);
  var cw = Lino.current_window;
  if (cw) {
    //~ console.log("20120918 Lino.open_window() save current status",cw.main_item.get_status());
    Lino.window_history.push({
      window:cw,
      status:cw.main_item.get_status()
    });
  }
  Lino.current_window = win;
  //~ if (st.su) 
      //~ Lino.subst_user_field.setValue(st.su);
  win.main_item.set_status(st,requesting_panel);
  win.show();
};

Lino.load_url = function(url) {
    //~ foo.bar.baz = 2; 
    //~ console.log("20121120 Lino.load_url()");
    //~ Lino.body_loadMask.show();
    Lino.viewport.loadMask.show();
    //~ location.replace(url);
    document.location = url;
}

Lino.close_window = function(status_update) {
  var cw = Lino.current_window;
  var ww = Lino.window_history.pop();
  if (ww) {
    //~ if (status_update) Ext.apply(ww.status,status_update);
    if (status_update) status_update(ww);
    ww.window.main_item.set_status(ww.status);
    Lino.current_window = ww.window;
  } else {
    Lino.current_window = null;
  }
  if (cw) cw.hide_really();
};

Lino.close_all_windows = function() {
  if (Lino.window_history.length == 0) {
      //~ Lino.viewport.refresh();
      var url =  "/"
      //~ console.log("20121120 Lino.close_all_windows() : no window_history");
      //~ if (ADMIN_URL) 
      var p = {};
      Lino.insert_subst_user(p)
      if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
      Lino.load_url(url);
  } else {
    //~ console.log("20121120 Lino.close_all_windows() with window_history");
    while (Lino.window_history.length > 0) {
      Lino.close_window();
      //~ Lino.window_history.pop().hide_really();
    }
  }
  //~ Lino.current_window = null;
  //~ Lino.close_window();
  //~ var ww = 
}

Lino.kill_current_window = function() {
  var cw = Lino.current_window;
  Lino.current_window = null;
  if (cw) cw.hide_really();
};

Lino.calling_window = function() {
    if (Lino.window_history.length) return Lino.window_history[Lino.window_history.length-1];
}

//~ Lino.WindowAction = function(mainItemClass,windowConfig,mainConfig,ppf) {
Lino.WindowAction = function(windowConfig,main_item_fn) {
    //~ if(!mainConfig) mainConfig = {};
    //~ mainConfig.is_main_window = true;
    this.windowConfig = windowConfig;
    this.main_item_fn = main_item_fn;
    //~ if (ppf) mainConfig.params_panel.fields = ppf;
    //~ this.mainConfig = mainConfig;
    //~ this.mainItemClass = mainItemClass;
};

Lino.WindowAction = Ext.extend(Lino.WindowAction,{
    window : null,
    //~ mainItemClass: null,
    get_window : function() {
      //~ if(mainConfig) Ext.apply(this.mainConfig,mainConfig);
      if (this.window == null)  {
          //~ this.windowConfig.main_item = new this.mainItemClass(this.mainConfig);
          this.windowConfig.main_item = this.main_item_fn();
          this.window = new Lino.Window(this.windowConfig);
      }
      return this.window;
    },
    run : function(requesting_panel,status) {
      //~ console.log('20120625 window_action.run()',this)
      Lino.open_window(this.get_window(),status,requesting_panel);
    }
  
});


Lino.PanelMixin = {
  get_containing_window : function (){
      if (this.containing_window) return this.containing_window;
      return this.containing_panel.get_containing_window();
  }
  ,set_window_title : function(title) {
    //~ this.setTitle(title);
    var cw = this.get_containing_window();

    //~ if (cw) {
    //~ if (cw && cw.closable) {
    if (cw && !cw.main_item.hide_window_title) {
      //~ console.log('20111202 set_window_title(',title,') for',this.containing_window);
      //~ if (! this.containing_window.rendered) console.log("WARNING: not rendered!");
      cw.setTitle(title);
    //~ } else {
      //~ document.title = title;
    }
    //~ else console.log('20111202 not set_window_title(',title,') for',this);
  }
  
};


// Lino.status_bar = new Ext.ux.StatusBar({defaultText:'Lino version 1.6.11.'});
Lino.status_bar = new Ext.ux.StatusBar({defaultText:'Lino-HWS 0.0.1.'});



Lino.edit_tinymce_text = function(panel,options) {
  // `panel` is the RichTextPanel
  //~ console.log(20111220,panel);
  //~ var rec = panel.get_current_record();
  var rec = panel.containing_panel.get_current_record();
  var value = rec ? rec.data[panel.editor.name] : '';
  var saving = false;
  var todo_after_save = false;
  var discard_changes = false;
  
  
  function save() {
    //~ if (todo_after_save) {alert('tried to save again'); return; }
    if (saving) {alert('tried to save again'); return; }
    //~ var url = panel.containing_window.main_item.get_record_url(rec.id);
    var url = panel.containing_panel.get_record_url(rec.id);
    var params = Ext.apply({},panel.containing_panel.get_base_params());
    params[panel.editor.name] = editor.getValue();
    //~ params.su = Lino.subst_user;
    //~ Lino.insert_subst_user(params);
    var a = { 
      params: params, 
      method: 'PUT',
      url: url,
      failure: function() {
          //~ if (editor.ed.getContainer()) 
          editor.ed.setProgressState(0);
          todo_after_save = false;
          saving = false;
          console.log('tinymce.save() failed. sorry.',arguments);
        },
      success: function() {
        saving = false;
        //~ if (editor.ed.getContainer()) 
        editor.ed.setProgressState(0);
        rec.data[panel.editor.name] = editor.getValue();
        if(todo_after_save) {
            var fn = todo_after_save;
            todo_after_save = false;
            fn();
        }
        //~ panel.containing_window.set_current_record(rec);
        panel.refresh();
      }
    };
    //~ if (editor.ed.getContainer()) 
    editor.ed.setProgressState(1); // Show progress
    saving = true;
    //~ console.log(a);
    Ext.Ajax.request(a);
  };
  function save_callback() {
      save();
      //~ save(function(){editor.ed.setDirty(false);})
      /* return true have the save button disabled.  
      That's not perfect because the PUT is asynchronous 
      and the response is not yet known.
      */
      return true;
  }
  //~ var actions = [
    //~ {text:"Save",handler:save}
  //~ ]; 
  //~ console.log(20110610,panel.editor.disabled);
  var settings = {};
  Ext.apply(settings,{
        readonly: panel.editor.disabled,
        //~ language: "de",
        plugins : "save,emotions,spellchecker,advhr,insertdatetime,preview,table,searchreplace,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "save,cancel,|,bold,italic,underline,|,justifyleft,justifycenter,justifyright,fontselect,fontsizeselect,formatselect,|,search,replace",
        theme_advanced_buttons2 : "cut,copy,paste,template,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,link,unlink,anchor,image,|,code,preview,|,forecolor,backcolor",
        theme_advanced_buttons3 : "insertdate,inserttime,|,spellchecker,advhr,,removeformat,|,sub,sup,|,charmap,emotions,|,tablecontrols",      
        theme_advanced_resizing : false,
        convert_urls : false,
        save_onsavecallback : save_callback,
        save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
  });
  Ext.apply(settings,options);
  var editor = new Ext.ux.TinyMCE({
      value : value,
      tinymceSettings: settings
    });
  var win = new Ext.Window({
    title: rec.title, 
    //~ bbar: actions,
    layout: 'fit',
    items: editor,
    width: 600, 
    height:500,
    minWidth: 100,
		minHeight: 100,
    modal: true,
    resizable: true,
    maximizable: true,
    //~ maximized: true,
    //~ closeAction: "close"
    closeAction: "hide"
    //~ hideMode: "offsets",
    //~ constrainHeader: true,
    //~ bodyStyle: 'padding: 10px'
  });

  //~ win.on('beforeclose',function() {
  win.on('beforehide',function() {
    if (todo_after_save) return false;
    if (discard_changes) return true;
    if (editor.isDirty()) {
        //~ var ok = false;
        //~ var allowClose = true;
        var config = {title:"Confirmation"};
        config.buttons = Ext.MessageBox.YESNOCANCEL;
        config.msg = "Save changes to text ?";
        config.modal = true;
        config.fn = function(buttonId,text,opt) {
          //~ console.log('do_when_clean',buttonId)
          if (buttonId == "yes") {
              /* we cancel this close, but save()'s onSuccess will call again.*/
              //~ allowClose = false;
              todo_after_save = function(){win.hide();}
              editor.ed.execCommand('mceSave');
              //~ editor.ed.save(function(){win.close();});
          } else if (buttonId == "no") { 
              discard_changes = true;
              win.hide()
          //~ } else if (buttonId == "cancel") { 
            //~ ok = true;
              //~ allowClose = false;
          //~ } else { 
            //~ console.log('unknwon buttonId:',buttonId);
          }
        }
        Ext.MessageBox.show(config);
        return false;
        //~ return allowClose;
    }
  });
  win.show();
}







/* 
  Originally copied from Ext JS Library 3.3.1
  Modifications by Luc Saffre : 
  - rendering of phantom records
  - fire afteredit event
  - react on dblclcik, not on single click

 */
Lino.CheckColumn = Ext.extend(Ext.grid.Column, {

    processEvent : function(name, e, grid, rowIndex, colIndex){
        //~ console.log('20110713 Lino.CheckColumn.processEvent',name)
        if (name == 'click') {
        //~ if (name == 'mousedown') {
        //~ if (name == 'dblclick') {
            return this.toggleValue(grid, rowIndex, colIndex);
        } else {
            return Ext.grid.ActionColumn.superclass.processEvent.apply(this, arguments);
        }
    },
    
    toggleValue : function (grid,rowIndex,colIndex) {
        var record = grid.store.getAt(rowIndex);
        var dataIndex = grid.colModel.getDataIndex(colIndex);
        // 20120514
        //~ if(record.data.disabled_fields && record.data.disabled_fields[dataIndex]) {
          //~ Lino.notify("This field is disabled");
          //~ return false;
        //~ }
      
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("This field is disabled.");
            //~ return false;
        //~ }
        var startValue = record.data[dataIndex];
        var value = !startValue;
        //~ record.set(this.dataIndex, value);
        var e = {
            grid: grid,
            record: record,
            field: dataIndex,
            originalValue: startValue,
            value: value,
            row: rowIndex,
            column: colIndex,
            cancel: false
        };
        if(grid.fireEvent("beforeedit", e) !== false && !e.cancel){
        //~ if(grid.fireEvent("validateedit", e) !== false && !e.cancel){
            record.set(dataIndex, value);
            delete e.cancel;
            grid.fireEvent("afteredit", e);
        }
        return false; // Cancel event propagation
    },

    renderer : function(v, p, record){
        if (record.phantom) return '';
        p.css += ' x-grid3-check-col-td'; 
        return String.format('<div class="x-grid3-check-col{0}">&#160;</div>', v ? '-on' : '');
    }

    // Deprecate use as a plugin. Remove in 4.0
    // init: Ext.emptyFn
});

// register ptype. Deprecate. Remove in 4.0
// Ext.preg('checkcolumn', Lino.CheckColumn);

// backwards compat. Remove in 4.0
// Ext.grid.CheckColumn = Lino.CheckColumn;

// register Column xtype
Ext.grid.Column.types.checkcolumn = Lino.CheckColumn;


/* 20110725 : 
Lino.on_tab_activate is necessary 
in contacts.Person.2.dtl 
(but don't ask me why...)
*/
Lino.on_tab_activate = function(item) {
  //~ console.log('activate',item); 
  if (item.rendered && item.doLayout) item.doLayout();
  //~ if (item.rendered) item.doLayout();
}

Lino.TimeField = Ext.extend(Ext.form.TimeField,{
  format: 'H:i',
  increment: 15
  });
Lino.DateField = Ext.extend(Ext.form.DateField,{
  boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  altFormats: 'd/m/Y|Y-m-d'
  });
Lino.DatePickerField = Ext.extend(Ext.DatePicker,{
  //~ boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  //~ altFormats: 'd/m/Y|Y-m-d'
  formatDate : function(date){
      console.log("20121203 formatDate",this.name,date);
      return Ext.isDate(date) ? date.dateFormat(this.format) : date;
  }
  });
Lino.DateTimeField = Ext.extend(Ext.ux.form.DateTime,{
  dateFormat: 'd.m.Y',
  timeFormat: 'H:i',
  //~ hiddenFormat: 'd.m.Y H:i'
  });
Lino.URLField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  //~ triggerClass : 'x-form-world-trigger',
  vtype: 'url',
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    window.open(this.getValue(),'_blank');
  }
});
Lino.IncompleteDateField = Ext.extend(Ext.form.TextField,{
  //~ regex: /^-?\d+-[01]\d-[0123]\d$/,
  //~ regex: /^[0123]\d\.[01]\d\.-?\d+$/,
  maxLength: 10,
  boxMinWidth: Lino.chars2width(10),
  regex: /^[0123]?\d\.[01]?\d\.-?\d+$/,
  regexText: 'Enter a date in format YYYY-MM-DD (use zeroes for unknown parts).'
  });


//~ Lino.make_dropzone = function(cmp) {
    //~ cmp.on('render', function(ct, position){
      //~ ct.el.on({
        //~ dragenter:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ return true;
        //~ }
        //~ ,dragover:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ event.stopEvent();
          //~ return true;
        //~ }
        //~ ,drop:{
          //~ scope:this
          //~ ,fn:function(event){
            //~ event.stopEvent();
            //~ console.log(20110516);
            //~ var files = event.browserEvent.dataTransfer.files;
            //~ if(files === undefined){
              //~ return true;
            //~ }
            //~ var len = files.length;
            //~ while(--len >= 0){
              //~ console.log(files[len]);
              //~ // this.processDragAndDropFileUpload(files[len]);
            //~ }
          //~ }
        //~ }
      //~ });
    //~ });
//~ };

//~ Lino.FileUploadField = Ext.ux.form.FileUploadField;

Lino.FileUploadField = Ext.extend(Ext.ux.form.FileUploadField,{
    onRender : function(ct, position){
      Lino.FileUploadField.superclass.onRender.call(this, ct, position);
      this.el.on({
        dragenter:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          return true;
        }
        ,dragover:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          event.stopEvent();
          return true;
        }
        ,drop:{
          scope:this
          ,fn:function(event){
            event.stopEvent();
            //~ console.log(20110516);
            var files = event.browserEvent.dataTransfer.files;
            if(files === undefined){
              return true;
            }
            var len = files.length;
            while(--len >= 0){
              console.log(files[len]);
              //~ this.processDragAndDropFileUpload(files[len]);
            }
          }
        }
      });
    }
});

Lino.FileField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  editable: false,
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    if (this.getValue()) window.open(MEDIA_URL + '/'+this.getValue(),'_blank');
  }
});

Lino.file_field_handler = function(panel,config) {
  //~ if (instanceof Lino.DetailWrapper) {
  if (panel.action_name == 'insert') {
  //~ if (panel.get_current_record().phantom) {
      panel.has_file_upload = true;

      var f = new Lino.FileUploadField(config);
      //~ Lino.make_dropzone(f);
      return f;
      //~ return new Ext.ux.form.FileUploadField(config);
      //~ return new Lino.FileField(config);
      
  } else {
      //~ return new Lino.URLField(config);
      return new Lino.FileField(config);
  }
}

Lino.VBorderPanel = Ext.extend(Ext.Panel,{
    constructor : function(config) {
      config.layout = 'border';
      delete config.layoutConfig;
      Lino.VBorderPanel.superclass.constructor.call(this,config);
      for(var i=0; i < this.items.length;i++) {
        var item = this.items.get(i);
        if (this.isVertical(item) && item.collapsible) {
          item.on('collapse',this.onBodyResize,this);
          item.on('expand',this.onBodyResize,this);
        }
      }
    },
    isVertical : function(item) {
       return (item.region == 'north' || item.region == 'south' || item.region == 'center');
    },
    onBodyResize: function(w, h){
        //~ console.log('VBorderPanel.onBodyResize',this.title)
      if (this.isVisible()) { // to avoid "Uncaught TypeError: Cannot call method 'getHeight' of undefined."
        var sumflex = 0;
        var availableHeight = this.getInnerHeight();
        var me = this;
        this.items.each(function(item){
          if (me.isVertical(item)) {
              if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  if (item.rendered) availableHeight -= item.getHeight();
              } else {
                  sumflex += item.flex;
              }
          } 
          
        });
        //~ for(var i=0; i < this.items.length;i++) {
          //~ var item = this.items.get(i);
          //~ // if (this.isVertical(item) && item.getResizeEl()) {
          //~ if (this.isVertical(item)) {
              //~ if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  //~ // item.syncSize()
                  //~ // item.doLayout()
                  //~ // if (item.region == "north") console.log('region north',item.getHeight(),item.id, item);
                  //~ // if (item.getHeight() == 0) console.log(20100921,'both flex and getHeight() are 0!');
                  //~ availableHeight -= item.getHeight();
              //~ } else {
                  //~ sumflex += item.flex;
                  //~ // console.log(item.flex);
              //~ }
          //~ } 
          //~ // else console.log('non-vertical item in VBoderPanel:',item)
        //~ }
        var hunit = availableHeight / sumflex;
        //~ console.log('sumflex=',sumflex,'hunit=',hunit, 'availableHeight=',availableHeight);
        for(var i=0; i < this.items.length;i++) {
          var item = this.items.get(i);
          if (this.isVertical(item)) {
              if (item.flex != 0 && ! item.collapsed) {
                  item.setHeight(hunit * item.flex);
                  //~ console.log(item.region,' : height set to',item.getHeight());
              }
          }
          //~ else console.log('non-vertical item in VBoderPanel:',item)
        }
      }
      Lino.VBorderPanel.superclass.onBodyResize.call(this, w, h);
    }
});


/*
  modifications to the standard behaviour of a CellSelectionModel:
  
*/
Ext.override(Ext.grid.CellSelectionModel, {
//~ var dummy = {

    handleKeyDown : function(e){
        /* removed because F2 wouldn't pass
        if(!e.isNavKeyPress()){
            return;
        }
        */
        //~ console.log('handleKeyDown',e)
        var k = e.getKey(),
            g = this.grid,
            s = this.selection,
            sm = this,
            walk = function(row, col, step){
                return g.walkCells(
                    row,
                    col,
                    step,
                    g.isEditor && g.editing ? sm.acceptsNav : sm.isSelectable, 
                    sm
                );
            },
            cell, newCell, r, c, ae;

        switch(k){
            case e.ESC:
            case e.PAGE_UP:
            case e.PAGE_DOWN:
                break;
            default:
                // e.stopEvent(); // removed because Browser keys like Alt-Home, Ctrl-R wouldn't work
                break;
        }

        if(!s){
            cell = walk(0, 0, 1); 
            if(cell){
                this.select(cell[0], cell[1]);
            }
            return;
        }

        cell = s.cell;  
        r = cell[0];    
        c = cell[1];    
        
        switch(k){
            case e.TAB:
                if(e.shiftKey){
                    newCell = walk(r, c - 1, -1);
                }else{
                    newCell = walk(r, c + 1, 1);
                }
                break;
            case e.HOME:
                if (! (g.isEditor && g.editing)) {
                  if (!e.hasModifier()){
                      newCell = [r, 0];
                      //~ console.log('home',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
                      if (activePage > 1) {
                          e.stopEvent();
                          t.moveFirst();
                          return;
                      }
                      newCell = [0, c];
                      break;
                  }
                }
            case e.END:
                if (! (g.isEditor && g.editing)) {
                  c = g.colModel.getColumnCount()-1;
                  if (!e.hasModifier()) {
                      newCell = [r, c];
                      //~ console.log('end',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var d = t.getPageData();
                      if (d.activePage < d.pages) {
                          e.stopEvent();
                          var self = this;
                          t.on('change',function(tb,pageData) {
                              var r = g.store.getCount()-2;
                              self.select(r, c);
                              //~ console.log('change',r,c);
                          },this,{single:true});
                          t.moveLast();
                          return;
                      } else {
                          newCell = [g.store.getCount()-1, c];
                          //~ console.log('ctrl-end',newCell);
                          break;
                      }
                  }
                }
            case e.DOWN:
                newCell = walk(r + 1, c, 1);
                break;
            case e.UP:
                newCell = walk(r - 1, c, -1);
                break;
            case e.RIGHT:
                newCell = walk(r, c + 1, 1);
                break;
            case e.LEFT:
                newCell = walk(r, c - 1, -1);
                break;
            case e.F2:
                if (!e.hasModifier()) {
                    if (g.isEditor && !g.editing) {
                        g.startEditing(r, c);
                        e.stopEvent();
                        return;
                    }
                    break;
                }
            case e.INSERT:
                if (!e.hasModifier()) {
                    if (g.ls_insert_handler && !g.editing) {
                        e.stopEvent();
                        Lino.show_insert(g);
                        return;
                    }
                    break;
                }
            case e.DELETE:
                if (!e.hasModifier()) {
                    if (!g.editing) {
                        e.stopEvent();
                        Lino.delete_selected(g);
                        return;
                    }
                    break;
                }
            case e.ENTER:
                e.stopEvent();
                g.onCellDblClick(r,c);
                break;
                
        }
        

        if(newCell){
          e.stopEvent();
          r = newCell[0];
          c = newCell[1];
          this.select(r, c); 
          if(g.isEditor && g.editing){ 
            ae = g.activeEditor;
            if(ae && ae.field.triggerBlur){
                ae.field.triggerBlur();
            }
            g.startEditing(r, c);
          }
        //~ } else if (g.isEditor && !g.editing && e.charCode) {
        //~ // } else if (!e.isSpecialKey() && g.isEditor && !g.editing) {
            //~ g.set_start_value(String.fromCharCode(e.charCode));
            //~ // g.set_start_value(String.fromCharCode(k));
            //~ // g.set_start_value(e.charCode);
            //~ g.startEditing(r, c);
            //~ // e.stopEvent();
            //~ return;
        // } else {
          // console.log('20120513',e,g);
        }
        
    }


//~ };
});

 

function PseudoConsole() {
    this.log = function() {};
};
if (typeof(console) == 'undefined') console = new PseudoConsole();

Lino.notify = function(msg) {
  if (msg == undefined) msg = ''; else console.log(msg);
  //~ Ext.getCmp('konsole').update(msg);
  Lino.status_bar.setStatus({
    text: msg,
    iconCls: 'ok-icon',
    clear: true // auto-clear after a set interval
  });
  //~ Ext.getCmp('konsole').setTitle(msg.replace(/\n/g,'<br/>'));
  //~ Ext.getCmp('konsole').update(msg.replace(/\n/g,'<br/>'));
};
Lino.alert = function(msg) {
  //~ if (msg == undefined) msg = ''; else console.log(msg);
  Ext.MessageBox.alert('Notify',msg);
};


//~ Lino.show_about = function() {
  //~ new Ext.Window({
    //~ width: 400, height: 400,
    //~ title: "About",
    //~ html: '<a href="http://www.extjs.com" target="_blank">ExtJS</a> version ' + Ext.version
  //~ }).show();
//~ };

function obj2str(o) {
  if (typeof o != 'object') return String(o);
  var s = '';
  for (var p in o) {
    s += p + ': ' + obj2str(o[p]) + '\n';
  }
  return s;
}

Lino.on_store_exception = function (store,type,action,options,response,arg) {
  //~ throw response;
  console.log("on_store_exception: store=",store,
    "type=",type,
    "action=",action,
    "options=",options,
    "response=",response,
    "arg=",arg);
  if (arg) { console.log(arg.stack)};
};

//~ Lino.on_submit_success = function(form, action) {
   //~ Lino.notify(action.result.message);
   //~ this.close();
//~ };

Lino.on_submit_failure = function(form, action) {
    //~ Lino.notify();
  // action may be undefined
    switch (action.failureType) {
        case Ext.form.Action.CLIENT_INVALID:
            Ext.Msg.alert('Client-side failure', 'Form fields may not be submitted with invalid values');
            break;
        case Ext.form.Action.CONNECT_FAILURE:
            Ext.Msg.alert('Connection failure', 'Ajax communication failed');
            break;
        case Ext.form.Action.SERVER_INVALID:
            Ext.Msg.alert('Server-side failure', action.result.message);
   }
};



/*
Lino.save_wc_handler = function(ww) {
  return function(event,toolEl,panel,tc) {
    var pos = panel.getPosition();
    var size = panel.getSize();
    wc = ww.get_window_config();
    Ext.applyIf(wc,{ 
      x:pos[0],y:pos[1],height:size.height,width:size.width,
      maximized:panel.maximized});
    Lino.do_action(ww,{url:'/window_configs/'+ww.config.permalink_name,params:wc,method:'POST'});
  }
};

*/

Lino.show_in_own_window_button = function(handler) {
  return {
    qtip: "Show this panel in own window", 
    id: "up",
    handler: function(event,toolEl,panel, tc) {
      //~ console.log('20111206 report_window_button',panel,handler);
      //~ var bp = ww.get_master_params();
      //~ panel.containing_window = ww; // for HtmlBox. see blog/2010/1022
      //~ handler(panel,{base_params:bp});
      //~ handler(panel,{base_params:panel.get_master_params()});
      handler.run(null,{base_params:panel.containing_panel.get_master_params()});
      //~ handler(panel,{master_panel:panel.containing_window.main_item});
    }
  }
}




Lino.delete_selected = function(panel) {
  //~ console.log("Lino.delete_selected",panel);
  var recs1 = panel.get_selected();
  var recs = [];
  for ( var i=0; i < recs1.length; i++ ) { if (! recs1[i].phantom) recs.push(recs1[i]); }
  if (recs.length == 0) {
    Lino.notify("Please select at least one record.");
    return;
  };
  if (recs.length == 1) {
      if (recs[0].disable_delete) {
        Lino.alert(recs[0].disable_delete);
        return;
      }
  };
  //~ console.log(recs);
  Ext.MessageBox.show({
    title: "Confirmation",
    msg: String.format("Delete {0} rows. Are you sure?",String(recs.length)),
    //~ msg: "Delete " + String(recs.length) + " rows. Are you sure?",
    //~ buttons: Ext.MessageBox.YESNOCANCEL,
    buttons: Ext.MessageBox.YESNO,
    fn: function(btn) {
      if (btn == 'yes') {
        for ( var i=0; i < recs.length; i++ ) {
          Lino.do_action(panel,{
              method:'DELETE',
              url:  '/api' + panel.ls_url + '/' + recs[i].id,
              after_success: panel.after_delete.createDelegate(panel)
          })
        }
        //~ caller.after_delete();
      }
      else Lino.notify("Dann eben nicht.");
    }
  });
};

Lino.action_handler = function (panel,on_success,on_confirm) {
  return function (response) {
    //~ console.log(20120608,panel);
    if (panel instanceof Lino.GridPanel) {
        //~ gridmode = false;
        gridmode = true;
        //~ console.log('20120608 yes');
    } else {
        gridmode = false;
        //~ console.log('20120608 no');
    }
    panel.loadMask.hide(); // 20120211
    if (!response.responseText) return ;
    var result = Ext.decode(response.responseText);
    //~ console.log('Lino.action_handler()','result is',result,'on_confirm is',on_confirm);
    
    if (result.eval_js) {
        //~ console.log(20120618,result.eval_js);
        eval(result.eval_js);
    }
    
    if (result.xcallback) {
        //~ var config = {title:"Confirmation"};
        var config = {title:result.xcallback.title};
        //~ config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        config.buttons = result.xcallback.buttons;
        config.msg = result.message;
        config.fn = function(buttonId,text,opt) {
          panel.loadMask.show(); 
          //~ Lino.insert_subst_user(p);
          Ext.Ajax.request({
            method: 'GET',
            url: '/callbacks/'+result.xcallback.id + '/' + buttonId,
            //~ params: {bi: buttonId},
            success: Lino.action_handler(panel,on_success,on_confirm)
          });
          //~ Lino.call_ajax_action(panel,'GET',)
        }
        Ext.MessageBox.show(config);
        return;
    }
    
    if (on_success && result.success) on_success(result);
    
    //~ if (on_confirm && result.confirm_message) {
        //~ var config = {title:"Confirmation"};
        //~ // config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        //~ config.msg = result.confirm_message;
        //~ config.fn = function(buttonId,text,opt) {
          //~ if (buttonId == "yes") {
              //~ on_confirm(panel,undefined,result.step);
          //~ }
        //~ }
        //~ Ext.MessageBox.show(config);
        //~ return;
    //~ }
    //~ if (result.dialog_fn) {
        //~ console.log('20120928 TODO',result.dialog_fn);
    //~ }
    if (result.message) {
        //~ if (result.alert && ! gridmode) {
        if (result.alert) { // 20120628b 
            //~ Ext.MessageBox.alert('Alert',result.alert_msg);
            if (result.alert === true) result.alert = "Alert";
            Ext.MessageBox.alert(result.alert,result.message);
        } else {
            Lino.notify(result.message);
        }
    }
    // 
    if (result.data_record && ! gridmode) {
        //~ not used
        panel.set_status({data_record:result.data_record});
    }
    else if (result.new_status && ! gridmode) {
        //~ not used
        //~ console.log('20120607 new_status');
        panel.set_status(result.new_status);
    }
    else if (result.goto_record_id != undefined && ! gridmode) {
        //~ console.log('20120607 new_status');
        panel.load_record_id(result.goto_record_id);
    }
    else if (result.refresh_all) {
        var cw = panel.get_containing_window();
        //~ console.log("20120123 refresh_all");
        if (cw) {
          cw.main_item.refresh();
        }
        else console.log("20120123 cannot refresh_all",panel);
    } else {
        //~ console.log("20121212 b gonna refresh",panel);
        if (result.refresh) panel.refresh();
    }
    
    if (result.open_davlink_url) {
       Lino.davlink_open(result.open_davlink_url);
    }
    
    if (result.open_url) {
        //~ console.log(20111126,result.open_url);
        //~ if (!result.message)
            //~ Lino.notify('Open new window <a href="'+result.open_url+'" target="_blank">'+result.open_url+'</a>');
        window.open(result.open_url,'foo',"");
        //~ document.location = result.open_url;
    }
  }
};

Lino.do_action = function(caller,action) {
  action.success = function(response) {
    if (caller.loadMask) caller.loadMask.hide();
    //~ console.log('Lino.do_action()',action,'action success',response);
    if (action.after_success) {
        //~ console.log('Lino.do_action() calling after_success');
        action.after_success();
    }
    if (response.responseText) {
      var result = Ext.decode(response.responseText);
      //~ console.log('Lino.do_action()',action.name,'result is',result);
      if (result.message) {
          if (result.alert) {
              //~ Ext.MessageBox.alert('Alert',result.alert_msg);
              Ext.MessageBox.alert('Alert',result.message);
          } else {
              Lino.notify(result.message);
          }
      }
      
      //~ if (result.alert_msg) Ext.MessageBox.alert('Alert',result.alert_msg);
      //~ if (result.message) Lino.notify(result.message);
      if (result.notify_msg) Lino.notify(result.notify_msg);
      if (result.js_code) { 
        //~ console.log('Lino.do_action()',action,'gonna call js_code in',result);
        var jsr = result.js_code(caller);
        //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
        if (action.after_js_code) {
          //~ console.log('Lino.do_action()',action,'gonna call after_js_code');
          action.after_js_code(jsr);
          //~ console.log('Lino.do_action()',action,'returned from after_js_code');
        //~ } else {
          //~ console.log('Lino.do_action()',action,' : after_js_code is false');
        }
      };
    }
  };
  Ext.applyIf(action,{
    waitMsg: "Please wait...",
    failure: Lino.ajax_error_handler(caller),
    params: {}
  });
  //~ action.params.su = Lino.subst_user;
  Lino.insert_subst_user(action.params);
  
  Ext.Ajax.request(action);
};

//~ Lino.gup = function( name )
//~ {
  //~ // Thanks to http://www.netlobo.com/url_query_string_javascript.html
  //~ name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
  //~ var regexS = "[\\?&]"+name+"=([^&#]*)";
  //~ var regex = new RegExp( regexS );
  //~ var results = regex.exec( window.location.href );
  //~ if( results == null )
    //~ return "";
  //~ else
    //~ return results[1];
//~ };

//~ Lino.refresh_handler = function (ww) {
  //~ return function() { 
      //~ console.log('refresh',ww);
      //~ ww.main_item.doLayout(false,true);
      //~ ww.main_item.syncSize();
  //~ }
//~ };

//~ Lino.tools_close_handler = function (ww) {
  //~ return function() { 
      //~ ww.close();
  //~ }
//~ };
Lino.permalink_handler = function (ww) {
  return function() { 
    //~ console.log(20100923,ww.get_permalink());
    //~ document.location = ww.main_item.get_permalink();
    
    /* Uncaught TypeError: Cannot read property 'main_item' of null  */
    if (ww) {
        Lino.load_url(ww.main_item.get_permalink());
    } else {
        Lino.load_url('/');
    }
    //~ console.log(20120715, ww.main_item.get_permalink());
    //~ document.location = "?permalink=" + ww.get_permalink();
    //~ document.location = "?permalink=" + ww.config.permalink_name +'()';
  }
};
//~ Lino.run_permalink = function() {
  //~ var plink = Lino.gup('permalink');
  //~ if(plink) { eval('Lino.'+plink); }
//~ }

Lino.MainPanel = {
  is_home_page : false,
  setting_param_values : false,
  config_containing_window : function(wincfg) { }
  ,init_containing_window : function(win) { }
  ,is_loading : function() { 
      if (!this.rendered) return true;
      //~ return (Ext.select('.x-loading-msg').elements.length > 0);
      return true; 
    } 
  ,do_when_clean : function(auto_save,todo) { todo() }
  ,get_master_params : function() {
    var p = {}
    p['mt'] = this.content_type; 
    rec = this.get_current_record()
    if (rec) {
      if (rec.phantom) {
          p['mk'] = undefined; 
      }else{
          p['mk'] = rec.id; 
      }
    } else {
      p['mk'] = undefined;
    }
    //~ console.log('get_master_params returns',p,'using record',rec);
    return p;
  }
  ,get_permalink : function() {
    //~ var p = this.main_item.get_base_params() || {};
    var p = Ext.apply({},this.get_base_params());
    delete p.fmt;
    //~ if (p.fmt) delete p.fmt;
    Ext.apply(p,this.get_permalink_params());
    
    if (this.toggle_params_panel_btn) {
        p.sp = this.toggle_params_panel_btn.pressed;
        //~ if (this.toggle_params_panel_btn.pressed == this.params_panel_hidden) {
          //~ p.sp = true;
        //~ }
    }
    
    //~ Lino.insert_subst_user(p);
     //~ p.fmt = 'html';
    //~ console.log('get_permalink',p,this.get_permalink_params());
    if (this.is_home_page)
        //~ var url = '';
        var url = '/';
    else 
        var url = this.get_permalink_url();
    if (p.su == null) 
        delete p.su;
    if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
    return url;
  }
  ,get_record_url : function(record_id) {
      var url = '/api' + this.ls_url
      //~ var url = this.containing_window.config.url_data; // ls_url;
      url += '/' + (record_id === undefined ? '-99999' : String(record_id));
      //~ if (record_id !== undefined) url += '/' + String(record_id);
      //~ url += '/' + String(record_id);
      return url;
  }
  ,get_permalink_url : function() {
      return '/api' + this.ls_url;
  }
  ,get_permalink_params : function() {
      //~ return {an:'grid'};
      var p = {};
      if (this.action_name)
          p.an = this.action_name;
      this.add_param_values(p,false)
      return p;
  }
  ,set_status : function(status) {}
  ,get_status : function() { return {}}
  ,refresh : function() {}
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,add_params_panel : function (tbar) {
      if (this.params_panel) {
        this.toggle_params_panel_btn = new Ext.Button({ scope:this, 
          //~ text: "$_("[parameters]")", // gear
          iconCls: 'x-tbar-parameters',
          tooltip:"Show or hide the table parameters panel",
          enableToggle: true,
          //~ pressed: ! this.params_panel.hidden,
          pressed: ! this.params_panel_hidden,
          toggleHandler: function(btn,state) { 
            //~ if (this.params_panel.isVisible()) 
                //~ this.params_panel.hide();
            //~ else
                //~ this.params_panel.show();
            //~ console.log("20120210 add_params_panel",state,this.params_panel);
            if (state) {
              this.params_panel.show();
              this.params_panel.doLayout();
            } else this.params_panel.hide();
            this.get_containing_window().doLayout();
          }
        });
        tbar = tbar.concat([this.toggle_params_panel_btn]);
        var t = this;
        var refresh = function() {if (!t.setting_param_values) {t._force_dirty = true; t.refresh();}}
        Ext.each(this.params_panel.fields,function(f) {
          //~ f.on('valid',function() {t.refresh()});
          if (f instanceof Ext.form.Checkbox) {
              f.on('check',refresh);
          } else if (f instanceof Ext.DatePicker) {
              f.on('select',refresh);
          } else if (f instanceof Ext.form.TriggerField) {
              f.on('select',refresh);
              //~ f.on('change',refresh);
              //~ f.on('valid',refresh);
          } else {
              if (! f.on) 
                  console.log("20121010 no method 'on'",f);
              else
                  f.on('change',refresh);
            }
          });
      }
      return tbar;
  }
  ,add_param_values : function (p,unused_force_dirty) {
    if (this.params_panel) {
      /* 
      * 20120918 add param_values to the request string 
      * *only if the params_form is dirty*.
      * Otherwise Actor.default_params() would never be used.
      *
      * 20121023 But IntegClients.params_default has non-empty default values. 
      * Users must have the possibility to make them empty.
      * 
      * 20130605 : added `force_dirty` parameter because Checkbox fields don't 
      * mark their form as dirty when check is fired.
      * 
      * 20130721 : `force_dirty` not as a parameter but as 
      * `this._force_dirty` because
      * 
      */
      if (this._force_dirty || this.params_panel.form.isDirty()) {
        p.pv = this.get_param_values();
        //~ console.log("20130605 form.isDirty",p);
      }else{
        //~ console.log("20130605 form not dirty:",this.params_panel.form);
        if (this.status_param_values) 
          p.pv = Lino.fields2array(
            this.params_panel.fields,this.status_param_values);
      }
      //~ if (!this.params_panel.form.isDirty()) return;
      //~ p.pv = this.get_param_values();
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
    }
  },
  get_param_values : function() { // similar to get_field_values()
      return Lino.fields2array(this.params_panel.fields);
  },
  set_param_values : function(pv) {
    if (this.params_panel) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_param_values = pv;
      //~ this.params_panel.form.suspendEvents(false);
      this.setting_param_values = true;
      if (pv) { 
          this.params_panel.form.my_loadRecord(pv);
      } else { 
        this.params_panel.form.reset(); 
      }
      this.setting_param_values = false;
      //~ this.params_panel.form.resumeEvents();
    }
  }
};


Lino.ajax_error_handler = function(panel) {
  return function(response,options) {
    console.log('Ajax failure:',response,options);
    if (panel.loadMask) panel.loadMask.hide();
    if (response.responseText) {
      var lines = response.responseText.split('\n');
      if (lines.length > 10) {
          line = lines.splice(5,lines.length-10,"(...)");
      }
      Ext.MessageBox.alert(
        response.statusText,
        lines.join('<br/>')
        //~ response.responseText.replace(/\n/g,'<br/>'))
      )
    } else {
      Ext.MessageBox.alert('Action failed',
        'Lino server did not respond to Ajax request');
    }
  }
}
// Ext.Ajax.on('requestexception',Lino.ajax_error_handler)
 


Ext.QuickTips.init();

/* setting QuickTips dismissDelay to 0 */
// Apply a set of config properties to the singleton
//~ Ext.apply(Ext.QuickTips.getQuickTip(), {
//~ Ext.apply(Ext.ToolTip, {
    //~ dismissDelay: 0
    //~ autoHide: false,
    //~ closable: true,
    //~ maxWidth: 200,
    //~ minWidth: 100,
    //~ showDelay: 50      // Show 50ms after entering target
    //~ ,trackMouse: true
//~ });


//~ Ext.apply(Ext.QuickTip, {
    //~ dismissDelay: 0,
//~ });
  
Lino.quicktip_renderer = function(title,body) {
  return function(c) {
    //~ if (c instanceof Ext.Panel) var t = c.bwrap; else // 20130129
    if (c instanceof Ext.Panel) var t = c.header; else // 20130129
    var t = c.getEl();
    //~ console.log(20130129,t,title,body);
    //~ t.dismissDelay = 0;
    Ext.QuickTips.register({
      target: t,
      //~ cls: 'lino-quicktip-classical',
      dismissDelay: 0,
      //~ autoHide: false,
      showDelay: 50,      // Show 50ms after entering target
      //~ title: title,
      text: body
    });
  }
};


  
Lino.help_text_editor = function() {
  //~ var bp = {
      //~ mk:this.content_type,
      //~ mt:1
    //~ };
    //~ console.log(20120202,bp);
  //~ Lino.lino.ContentTypes.detail({},{base_params:bp});
  //~ Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
  Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
}

// Path to the blank image should point to a valid location on your server
//~ Ext.BLANK_IMAGE_URL = MEDIA_URL + '/extjs/resources/images/default/s.gif'; 


// used as Ext.grid.Column.renderer for id columns in order to hide the special id value -99999
Lino.id_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  return value;
}

Lino.raw_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  return value;
}

Lino.text_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return "not implemented"; 
  return value;
}

Lino.NullNumberColumn = Ext.extend(Ext.grid.Column, {
    align : 'right', 
    format : '0,00/i', 
    renderer : function(value, metaData, record, rowIndex, colIndex, store) {
        //~ console.log(20130128,"NullNumberColumn.renderer",value);
        if (value === null) return '';
        return Ext.util.Format.number(value, this.format);
    }
});

//~ Lino.NullNumberColumn = Ext.extend(Ext.grid.NumberColumn, {
    //~ align : 'right', 
    //~ constructor: function(cfg){
        //~ Ext.grid.NumberColumn.superclass.constructor.call(this, cfg);
        //~ var t = this;
        //~ this.renderer = function(value, metaData, record, rowIndex, colIndex, store) {
          //~ console.log(20130128,"NullNumberColumn.renderer",value);
          //~ if (value === null) return '';
          //~ return Ext.util.Format.number(value, t.format);
      //~ };
    //~ }
//~ });




//~ Lino.cell_button_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return '<input type="button" onclick="alert(value)" value=" ? ">' ;
//~ }


//~ Lino.default_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  //~ return value;
//~ }

Lino.fk_renderer = function(fkname,handlername) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    //~ if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '.run(null,{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

Lino.lfk_renderer = function(panel,fkname) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  var handlername = 'console.log';
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '({},{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

//~ Lino.gfk_renderer = function() {
  //~ return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ if (record.phantom) return '';
    //~ console.log('Lino.gfk_renderer',value,colIndex,record,metaData,store);
    //~ return value;
  //~ }
//~ };


Lino.build_buttons = function(panel,actions) {
  //~ console.log("20121006 Lino.build_buttons",actions);
  if (actions) {
    var buttons = Array(actions.length);
    var cmenu = Array(actions.length);
    for (var i=0; i < actions.length; i++) { 
      buttons[i] = new Ext.Toolbar.Button(actions[i]);
      cmenu[i] = actions[i]
      cmenu[i].text = actions[i].menu_item_text;
      if (actions[i].panel_btn_handler) {
          var h = actions[i].panel_btn_handler.createCallback(panel,buttons[i]);
          //~ if (actions[i].must_save) {
          if (actions[i].auto_save == true) {
              buttons[i].on('click',panel.do_when_clean.createDelegate(panel,[true,h]));
          } else if (actions[i].auto_save == null) {
              buttons[i].on('click',panel.do_when_clean.createDelegate(panel,[false,h]));
          } else if (actions[i].auto_save == false) {
              buttons[i].on('click',h);
          } else {
              console.log("20120703 unhandled auto_save value",actions[i])
          }
          cmenu[i].handler = actions[i].panel_btn_handler.createCallback(panel,cmenu[i]);
      }
    }
    return {bbar:buttons, cmenu:new Ext.menu.Menu(cmenu)};
  }
}

Lino.do_when_visible = function(cmp,todo) {
  //~ if (cmp.el && cmp.el.dom) 
  if (cmp.isVisible()) { 
    // 'visible' means 'rendered and not hidden'
    //~ console.log(cmp.title,'-> cmp is visible now');
    todo(); 
  //~ } else {
      //~ cmp.on('resize',todo,cmp,{single:true});
  //~ }
  //~ if (false) { // 20120213
  } else { 
    //~ console.log('Lino.do_when_visible() must defer because not isVisible()',todo,cmp);
    if (cmp.rendered) {
      //~ console.log(cmp,'-> cmp is rendered but not visible: and now?');
      //~ console.log(cmp.title,'-> cmp is rendered but not visible: try again in a moment...');
      //~ var fn = function() {Lino.do_when_visible(cmp,todo)};
      //~ fn.defer(100);
      
      Lino.do_when_visible.defer(50,this,[cmp,todo]);
      //~ Lino.do_when_visible.defer(100,this,[cmp,todo]);
      
    } else {
      //~ console.log(cmp.title,'-> after render');
      cmp.on('afterrender',todo,cmp,{single:true});
    }
  }
  
};    

/*
*/
Lino.do_on_current_record = function(panel,fn,phantom_fn) {
  var rec = panel.get_current_record();
  if (rec == undefined) {
    Lino.notify("There's no selected record.");
    return;
  }
  // 20120307 A VirtualTable with a Detail (lino.Models) has only "phantom" records.
  if (rec.phantom) {
    //~ if (!panel.editable) { console.log("20120312 not editable:",panel)}
    if (phantom_fn) {
      phantom_fn(panel);
    } else {
      Lino.notify("Action not available on phantom record.");
    }
    return;
  }
  return fn(rec);
};






Lino.call_ajax_action = function(panel,method,url,p,actionName,step,on_confirm,on_success) {
  p.an = actionName;
  if (!panel) panel = Lino.viewport;
  Ext.apply(p,panel.get_base_params());
  //~ console.log("20121212 Lino.call_ajax_action",panel);
  panel.loadMask.show(); 
  //~ p.$ext_requests.URL_PARAM_SUBST_USER = Lino.subst_user;
  //~ Lino.insert_subst_user(p);
    
  //~ if (step) p['$ext_requests.URL_PARAM_ACTION_STEP'] = step;
  //~ if (pp) pp(p); // "parameter processor" : first used for read beid card
  Ext.Ajax.request({
    method: method,
    url: url,
    params: p,
    success: Lino.action_handler(panel,on_success,on_confirm)
  });
};

Lino.row_action_handler = function(actionName,hm,pp) {
  var p = {};
  var fn = function(panel,btn,step) {
      if (pp) { p = pp(); if (! p) return; }
      Lino.do_on_current_record(panel,function(rec) {
          //~ console.log(panel);
          //~ 20120723 Lino.call_ajax_action(panel,rec.id,actionName,step,fn);
          Lino.call_ajax_action(panel,hm,panel.get_record_url(rec.id),p,actionName,step,fn);
      });
  };
  return fn;
};

Lino.list_action_handler = function(ls_url,actionName,hm,pp) {
  var p = {};
  var url = '/api' + ls_url
  var fn = function(panel,btn,step) {
      //~ console.log("20121210 Lino.list_action_handler",arguments);
      //~ var url = ADMIN_URL + '/api' + panel.ls_url
      if (pp) { p = pp();  if (! p) return; }
      Lino.call_ajax_action(panel,hm,url,p,actionName,step,fn);
  };
  return fn;
};

Lino.param_action_handler = function(window_action) { // 20121012
  var fn = function(panel,btn,step) {
    Lino.do_on_current_record(panel,function(rec) {
      //~ console.log(panel);
      //~ 20120723 Lino.call_ajax_action(panel,rec.id,actionName,step,fn);
      window_action.run(panel.getId(),{}); 
    });
  };
  return fn;
};


Lino.run_row_action = function(requesting_panel,url,pk,actionName,pp) {
  //~ var panel = action.get_window().main_item;
  url = '/api' + url  + '/' + pk;
  var panel = Ext.getCmp(requesting_panel);
  if (pp) var p = pp(); else var p = {};
  var fn = function(panel,btn,step) {
    //~ 20120723 Lino.call_ajax_action(panel,pk,actionName,step,fn);
    Lino.call_ajax_action(panel,'GET',url,p,actionName,step,fn);
  }
  fn(panel,null,null);
}



Lino.show_detail = function(panel,btn) {
  Lino.do_on_current_record(panel, 
    function(rec) {
      //~ panel.loadMask.show();
      var bp = panel.get_base_params();
      //~ var bp = {};
      panel.add_param_values(bp); // 20120918
      var status = {
        record_id:rec.id,
        base_params:bp
        //~ param_values: pv.$ext_requests.URL_PARAM_PARAM_VALUES
      }
      //~ console.log("20120918 Lino.show_detail",status);
      panel.ls_detail_handler.run(null,status);
      //~ panel.loadMask.hide();
      //~ panel.containing_window.window.hideMask();
      //~ panel.el.unmask();
    },
    Lino.show_insert
  );
};

Lino.show_fk_detail = function(combo,detail_action) {
    //~ console.log("Lino.show_fk_detail",combo,handler);
    pk = combo.getValue();
    if (pk) {
        detail_action.run(null,{record_id: pk})
      } else {
        Lino.notify("Cannot show detail for empty foreign key.");
      }
};

Lino.show_insert = function(panel,btn) {
  var bp = panel.get_base_params();
  //~ console.log('20120125 Lino.show_insert',bp)
  //~ panel.ls_insert_handler.run(null,{record_id:-99999,base_params:bp});
  panel.ls_insert_handler.run(panel.getId(),{record_id:-99999,base_params:bp});
};

Lino.show_insert_duplicate = function(panel,btn) {
  Lino.do_on_current_record(panel,
    function(rec) {
      var newRec = {};
      Ext.apply(newRec,rec);
      newRec.id = -99999;
      panel.ls_insert_handler.run(null,{data_record:rec});
    });
};

//~ Lino.update_row_handler = function(action_name) {
  //~ return function(panel,btn) {
    //~ Lino.notify("Sorry, " + action_name + " is not implemented.");
  //~ }
//~ };




if (Ext.ux.grid !== undefined) {
    Lino.GridFilters = Ext.extend(Ext.ux.grid.GridFilters,{
      encode:true,
      local:false
    });
} else {
    Lino.GridFilters = function() {}; // dummy
    Ext.override(Lino.GridFilters,{
      init : function() {}
    });
};



//~ Lino.ButtonField = Ext.extend(Ext.form.TextField,{
//~ Lino.ButtonField = Ext.extend(Ext.form.Field,{
    //~ editable : false,
    //~ constructor : function(ww,config,params){
      //~ this.containing_window = ww;
      //~ if (params) Ext.apply(config,params);
      //~ Lino.ButtonField.superclass.constructor.call(this, config);
    //~ },
    //~ setButtons : function(buttons){
      //~ console.log('setButtons',buttons);
    //~ },
    //~ onRender : function(ct, position){
        //~ if(!this.el){
            //~ this.panel = new Ext.Container({items:[
              //~ {xtype:'button',text:'upload'},
              //~ {xtype:'button',text:'show'},
              //~ {xtype:'button',text:'edit'}
            //~ ]});
            //~ this.panel.ownerCt = this;
            //~ this.el = this.panel.getEl();

        //~ }
        //~ Lino.ButtonField.superclass.onRender.call(this, ct, position);
    //~ },

  
//~ });

Lino.FieldBoxMixin = {
  before_init : function(config,params) {
    if (params) Ext.apply(config,params);
    var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    if (actions) config.bbar = actions.bbar;
  },
  //~ constructor : function(ww,config,params){
    //~ this.containing_window = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  do_when_clean : function(auto_save,todo) { todo() },
  //~ format_data : function(html) { return '<div class="htmlText">' + html + '</div>' },
  format_data : function(html) { return html },
  get_base_params : function() {
    // needed for insert action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
  },
  set_base_params : function(p) {
    this.base_params = Ext.apply({},p);
    //~ if (p.param_values) this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  },
  set_base_param : function(k,v) {
    this.base_params[k] = v;
  }
};



Lino.HtmlBoxPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,{
  disabled_in_insert_window : true,
  constructor : function(config,params) {
    this.before_init(config,params);
    Lino.HtmlBoxPanel.superclass.constructor.call(this, config);
  },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.constructor.call(this, ww,config,params);
  //~ },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  //~ disable : function() { var tb = this.getBottomToolbar(); if(tb) tb.disable()},
  //~ enable : function() { var tb = this.getBottomToolbar(); if(tb) tb.enable()},
  onRender : function(ct, position){
    Lino.HtmlBoxPanel.superclass.onRender.call(this, ct, position);
    //~ console.log(20111125,this.containing_window);
    if (this.containing_panel) {
      this.containing_panel.on('enable',this.enable,this);
      this.containing_panel.on('disable',this.disable,this);
    }
    this.el.on({
      dragenter:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        return true;
      }
      ,dragover:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        event.stopEvent();
        return true;
      }
      ,drop:{
        scope:this
        ,fn:function(event){
          event.stopEvent();
          //~ console.log(20110516);
          var files = event.browserEvent.dataTransfer.files;
          if(files === undefined){
            return true;
          }
          var len = files.length;
          while(--len >= 0){
            console.log(files[len]);
            //~ this.processDragAndDropFileUpload(files[len]);
          }
          Lino.show_insert(this);
        }
      }
    });
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    //~ if (this.master_panel) {
      var record = this.containing_panel.get_current_record();
      //~ console.log('HtmlBox.refresh()',this.title,record,record.title);
      var box = this.items.get(0);
      var todo = function() {
        if (this.disabled) return;
        //~ this.set_base_params(this.containing_window.get_base_params());
        this.set_base_params(this.containing_panel.get_master_params());
        var el = box.getEl();
        if (el) {
          el.update(record ? this.format_data(record.data[this.name]) : '');
          //~ console.log('HtmlBox.refresh()',this.name);
        //~ } else {
          //~ console.log('HtmlBox.refresh() failed for',this.name);
        }
      };
      Lino.do_when_visible(box,todo.createDelegate(this));
    //~ }
  }
});
//~ Ext.override(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);



Lino.RichTextPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,Lino.FieldBoxMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,{
    
  //~ initComponent : function(){
    //~ Lino.RichTextPanel.superclass.initComponent.call(this);
  //~ },
  constructor : function(config,params) {
    //~ console.log('Lino.RichTextPanel.initComponent',this);
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + String(rec.id) + "/" + config.name;
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + config.name;
    var t = this;
    var tinymce_options = {
        theme : "advanced",
        content_css: '/media/lino/extjs/lino.css',
        language: 'en',
        //~ template_external_list_url : url,
        theme_advanced_toolbar_location : "top",
        theme_advanced_toolbar_align : "left",
        theme_advanced_statusbar_location : "bottom",
        template_popup_width : 700,
        template_popup_height : 500,
        template_replace_values : { 
            data_field : function(element){ 
                //~ console.log(20110722,fieldName,t.containing_window.get_current_record()); 
                var fieldName = element.innerHTML;
                element.innerHTML = t.containing_panel.get_current_record().data[fieldName];
            } 
        }
      };
      
    var editorConfig = {
      tinymceSettings: {
        plugins : "noneditable,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "bold,italic,underline,|,justifyleft,justifycenter,justifyright,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,removeformat,template",
        theme_advanced_buttons2 : "",
        theme_advanced_buttons3 : "", // ,|,sub,sup,|,charmap",      
        theme_advanced_resizing : false
        //~ save_onsavecallback : save_callback,
        //~ save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
        
    }};
    Ext.apply(editorConfig.tinymceSettings,tinymce_options);
    //~ editorConfig.name = config.action_name;
    editorConfig.name = config.name;
    delete config.name;
    //~ config.title = config.label;
    //~ delete config.label;
    this.before_init(config,params);
    
    this.editor = new Ext.ux.TinyMCE(editorConfig);
    var t = this;
    config.tools = [{
                      qtip: "Edit text in own window", 
                      id: "up",
                      handler: function(){
                        if(t.editor.isDirty()) {
                            var record = t.containing_panel.get_current_record();
                            record.data[t.editor.name] = t.editor.getValue();
                        }
                        Lino.edit_tinymce_text(t,tinymce_options)
                      }
                    }];
    
    config.items = this.editor;
    config.layout = "fit";
    Lino.RichTextPanel.superclass.constructor.call(this, config);
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    var record = this.containing_panel.get_current_record();
    //~ console.log('RichTextPanel.refresh()',this.title,record.title,record);
    var todo = function() {
      //~ this.set_base_params(this.containing_window.get_base_params());
      if (record) {
        var url = '/templates' + this.containing_panel.ls_url + "/" 
            + String(record.id) + "/" + this.editor.name;
        //~ console.log('RichTextPanel.refresh()',url);
        if (this.editor.ed) this.editor.ed.settings.template_external_list_url = url;
        this.set_base_params(this.containing_panel.get_master_params());
        //~ var v = record ? this.format_data(record.data[this.editor.name]) : ''
        var v = this.format_data(record.data[this.editor.name])
        this.editor.setValue(v);
      } else {
        this.editor.setValue('(no data)');
      }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
//~ Ext.override(Lino.RichTextPanel,Lino.FieldBoxMixin);



Lino.ActionFormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,Lino.PanelMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,Lino.FieldBoxMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  //~ layout:'fit'
  //~ ,autoHeight: true
  //~ ,frame: true
  window_title: "Action Parameters",
  constructor : function(config){
    config.bbar = [
        {text:'OK',handler:this.on_ok,scope:this},
        {text:'Cancel',handler:this.on_cancel,scope:this}
    ];
    //~ config.items = config.params_panel;
    Lino.ActionFormPanel.superclass.constructor.call(this, config);
  }
  //~ ,initComponent : function(){
    //~ Lino.ActionFormPanel.superclass.initComponent.call(this);
  //~ }
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
    //~ var rp = this.requesting_panel;
    //~ console.log("on_ok",this.requesting_panel,arguments);
    //~ Lino.row_action_handler()
    var panel = this.requesting_panel;
    var actionName = this.action_name;
    var rec = panel.get_current_record();
    var self = this;
    function on_success() { self.get_containing_window().close(); };
    var fn = function(panel,btn,step) {
      var p = {};
      self.add_field_values(p)
      Lino.call_ajax_action(panel,'GET',panel.get_record_url(rec.id),p,actionName,step,fn,on_success);
    }
    fn(panel,null,null);
    
    
  }
  ,set_status : function(status,rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 ActionFormPanel.set_status()',status,rp,this.requesting_panel);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_field_values(status.field_values);
    if (status.base_params) this.set_base_params(status.base_params);
  }
  
  ,add_field_values : function (p) { // similar to add_param_values()
      //~ 20121023 
      if (this.form.isDirty()) {
        p.fv = this.get_field_values();
      }else{
        if (this.status_field_values) 
          p.fv = Lino.fields2array(this.fields,this.status_field_values);
      }
      //~ if (!this.form.isDirty()) return;
      //~ p.$ext_requests.URL_PARAM_FIELD_VALUES = this.get_field_values();
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
  }
  ,get_field_values : function() {
      return Lino.fields2array(this.fields);
  }
  ,set_field_values : function(pv) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_field_values = pv;
      if (pv) this.form.my_loadRecord(pv);
      else this.form.reset(); 
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.title = this.window_title;
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok }
      ]
  }
});

//~ Lino.add_blank = function(oa) {
    //~ return [].concat(oa)
    //~ return 
    //~ }
    
Lino.fields2array = function(fields,values) {
    //~ console.log('20130605 fields2array gonna loop on', fields,values);
    var pv = Array(fields.length);
    for(var i=0; i < fields.length;i++) {
        var f = fields[i]
        if (values) 
          var v = values[f.name];
        else 
          var v = f.getValue();
        if (f.formatDate) {
            pv[i] = f.formatDate(v); 
        } else {
            pv[i] = v; // f.getValue(); 
        }
    }
    return pv;
}


Lino.FormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.FormPanel = Ext.extend(Lino.FormPanel,Lino.PanelMixin);
Lino.FormPanel = Ext.extend(Lino.FormPanel,{
  params_panel_hidden : false,
  //~ base_params : {},
  //~ trackResetOnLoad : true,
  //~ query_params : {},
  //~ 20110119b quick_search_text : '',
  constructor : function(config,params){
    if (params) Ext.apply(config,params);
    this.base_params = {};
    //~ ww.config.base_params.query = ''; // 20111018
    //~ console.log(config);
    //~ console.log('FormPanel.constructor() 1',config)
    //~ Ext.applyIf(config,{base_params:{}});
    //~ console.log('FormPanel.constructor() 2',config)
      
    config.trackResetOnLoad = true;
    
    Lino.FormPanel.superclass.constructor.call(this, config);
      
    //~ this.set_base_param('$URL_PARAM_FILTER',null); // 20111018
    //~ this.set_base_param('$URL_PARAM_FILTER',''); // 20111018
      
  },
  initComponent : function(){
    
    //~ console.log("20111201 containing_window",this.containing_window,this);
    
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    if (actions) {
        this.bbar = actions.bbar;
    //~ } else {
        //~ this.bbar = [];
    }
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ var config = this;
    
    //~ if (this.containing_window instanceof Lino.DetailWrapper) {
    
    //~ console.log('20120121 initComponent', this.action_name);
    //~ if (this.action_name == 'detail' | this.action_name == 'show') {
    //~ if (this.action_name != 'insert') {
    if (! this.hide_top_toolbar) {
      this.tbar = [];
      // 20111015    
      if (! this.hide_navigator) {
        this.record_selector = new Lino.RemoteComboFieldElement({
          store: new Lino.ComplexRemoteComboStore({
            //~ baseParams: this.containing_window.config.base_params,
            baseParams: this.get_base_params(),
            //~ value: this.containing_window.config.base_params.query,
            proxy: new Ext.data.HttpProxy({
              url: '/choices' + this.ls_url,
              method:'GET'
            })
          }),
          pageSize:25,
          listeners: { 
            scope:this, 
            select:function(combo,record,index) {
              //~ console.log('jumpto_select',arguments);
              this.goto_record_id(record.id);
            }
          },
          emptyText: "Go to record"
        })
        this.tbar = this.tbar.concat([this.record_selector]);
        
        this.tbar = this.tbar.concat([
          this.first = new Ext.Toolbar.Button({
            tooltip:"First",disabled:true,handler:this.moveFirst,scope:this,iconCls:'x-tbar-page-first'}),
          this.prev = new Ext.Toolbar.Button({
            tooltip:"Previous",disabled:true,handler:this.movePrev,scope:this,iconCls:'x-tbar-page-prev'}),
          this.next = new Ext.Toolbar.Button({
            tooltip:"Next",disabled:true,handler:this.moveNext,scope:this,iconCls:'x-tbar-page-next'}),
          this.last = new Ext.Toolbar.Button({
            tooltip:"Last",disabled:true,handler:this.moveLast,scope:this,iconCls:'x-tbar-page-last'})
        ]);
      }
      this.tbar = this.add_params_panel(this.tbar);
      
      //~ console.log(20101117,this.containing_window.refresh);
      this.tbar = this.tbar.concat([
        {
          //~ text:'Refresh',
          handler:function(){ this.do_when_clean(true,this.refresh.createDelegate(this)) },
          iconCls: 'x-tbar-loading',
          tooltip:"Reload current record",
          scope:this}
      ]);
          
      if (this.bbar) { // since 20121016
        if (this.tbar) {
            this.tbar = this.tbar.concat(['-']) ;
        } else {
          this.tbar = [];
        }
        this.tbar = this.tbar.concat(this.bbar) ;
        this.bbar = undefined;
      }
    
      this.tbar = this.tbar.concat([
          '->',
          this.displayItem = new Ext.Toolbar.TextItem({})
      ]);
          
    }
    //~ if (this.content_type && this.action_name != 'insert') {
      //~ this.bbar = this.bbar.concat([
        //~ '->',
        //~ { text: "[$_('Help Text Editor')]",
          //~ handler: Lino.help_text_editor,
          //~ qtip: "$_('Edit help texts for fields on this model.')",
          //~ scope: this}
      //~ ])
    //~ }
    //~ this.before_row_edit = config.before_row_edit.createDelegate(this);
      
    //~ if (this.master_panel) {
        //~ this.set_base_params(this.master_panel.get_master_params());
    //~ }
      
    Lino.FormPanel.superclass.initComponent.call(this);
    
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.bwrap,{msg:"Please wait..."});
    },this);
    
    
    //~ var this_ = this;
    //~ this.cascade(function(cmp){
      //~ // var active_field = false;
      //~ for (i = 0; i < this_.active_fields.length; i++) {
        //~ if (cmp.name == this_.active_fields[i]) {
            //~ // active_field = true; break;
            //~ cmp.on("change",function() {this_.save()});
        //~ }
      //~ };
      //~ if (active_field) {
      // if (cmp instanceof Lino.GridPanel) {
          //~ cmp.on("change",function() {this_.save()});
      //~ }
    //~ });
    
    if (this.action_name == 'insert') {
      this.cascade(function(cmp){
        // console.log('20110613 cascade',cmp);
        if (cmp.disabled_in_insert_window) {
            //~ cmp.disable();
            cmp.hide();
        }
      });
      
    }
    
  },
  
  unused_is_loading : function() { 
    if (this.current_record == null) {
        //~ console.log("20130515 current_record is null");
        return true; 
    }
    
    if (! this.loadMask) return true; // not even rendered: 
    if (! this.loadMask.el) return true; // not even rendered: 
    // thanks to Marco Pegoraro http://movableapp.com/2011/09/sencha-touch-loadmask-isvisible/
    var loading = (this.loadMask.el.select('.x-loading-msg').elements.length > 0);
    //~ console.log('20130515 GridPanel.is_loading() returns',loading);
    return loading;

    
    var loading = false;
    this.cascade(function(cmp){
        if (cmp instanceof Lino.GridPanel && cmp.is_loading()) {
            //~ console.log(20130515, cmp.title,'is loading');
            loading = true;
            return false;
        }
      });
    return loading;
    //~ var a = this.findByType(Lino.GridPanel);
    //~ for (i=0;i<a.length;i++) {
        //~ if (a[i].is_loading()) return true;
    //~ }
    //~ return false;
  },
  
  get_status : function(){
      var st = {
        base_params: this.get_base_params(),
        data_record : this.get_current_record()
        }
      var tp = this.items.get(0);
      if (tp instanceof Ext.TabPanel) {
        st.active_tab = tp.getActiveTab();
      }
      st.param_values = this.status_param_values;
      return st;
  },
  /* FormPanel */
  set_status : function(status,rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 FormPanel.set_status()',status);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_param_values(status.param_values);
    if (status.base_params) this.set_base_params(status.base_params);
    var tp = this.items.get(0);
    if (tp instanceof Ext.TabPanel) {
      if (status.active_tab) {
        //~ console.log('20111201 active_tab',this.active_tab,this.items.get(0));
        //~ tp.activeTab = status.active_tab;
        tp.setActiveTab(status.active_tab);
        //~ this.main_item.items.get(0).activate(status.active_tab);
      } else {
        tp.setActiveTab(0);
      }
      }
    
    if (status.data_record) {
      //~ console.log('20111201 Lino.FormPanel with data_record',this.data_record.title,this.containing_window);
      //~ this.main_item.on_master_changed.defer(2000,this.main_item,[status.data_record]);
      //~ Lino.do_when_visible(this.main_item,function(){this.on_master_changed(status.data_record)});
      //~ this.main_item.on('afterrender',function(){
      //~   this.main_item.on_master_changed(status.data_record)},this,{single:true});
      /* must defer because because set_window_title() didn't work otherwise */
      this.set_current_record.createDelegate(this,[status.data_record]).defer(100);
      //~ this.set_current_record(this.data_record);
      //~ return;
    } else if (status.record_id != undefined) { 
      /* possible values include 0 and null, 0 being a valid record id, 
      null the equivalent of undefined
      */
      //~ this.main_item.goto_record_id(this.status.record_id);
      this.load_record_id(status.record_id);
    } else {
      this.set_current_record(undefined);
    }
  },
    
  get_base_params : function() {
    // needed for insert_action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
    //~ return this.base_params;
  },
  set_base_params : function(p) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    delete p['query'] // 20120725
    Ext.apply(this.base_params,p);
    if (this.record_selector) {
        var store = this.record_selector.getStore();
        for (k in p) store.setBaseParam(k,p[k]);
        delete this.record_selector.lastQuery;
        //~ console.log("20120725 record_selector.setBaseParam",p)
    }
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
        
      //~ if (this.record_selector) {
          //~ var store = this.record_selector.getStore();
          //~ for (k in store.baseParams) store.setBaseParam(k,undefined);
          //~ delete this.record_selector.lastQuery;
          //~ console.log("20120725 record_selector.getBaseParams() -->",store.baseParams)
      //~ }
  },
  set_base_param : function(k,v) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    this.base_params[k] = v;
    //~ if (this.record_selector) {
        //~ this.record_selector.getStore().setBaseParam(k,v);
        //~ delete this.record_selector.lastQuery;
    //~ }
  },
  
  after_delete : function() {
    if (this.current_record.navinfo.next)
      this.moveNext();
    else if (this.current_record.navinfo.prev)
      this.movePrev();
    else 
      this.abandon();
  },
  moveFirst : function() {this.goto_record_id(this.current_record.navinfo.first)},
  movePrev : function() {this.goto_record_id(this.current_record.navinfo.prev)},
  moveNext : function() {this.goto_record_id(this.current_record.navinfo.next)},
  moveLast : function() {this.goto_record_id(this.current_record.navinfo.last)},
  
  
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ console.log('20120121 Lino.FormPanel.refresh()',this);
    if (this.current_record) {
        this.load_record_id(this.current_record.id,after);
    } else {
        this.set_current_record(undefined,after);
    }
  },
  
  do_when_clean : function(auto_save,todo) {
    var this_ = this;
    if (this.form.isDirty()) {
        if (auto_save) {
            this_.save(todo);
        } else {
          //~ console.log('20111217 do_when_clean() form is dirty',this.form);
          var config = {title:"Confirmation"};
          config.buttons = Ext.MessageBox.YESNOCANCEL;
          config.msg = "Save changes to current record ?";
          config.fn = function(buttonId,text,opt) {
            //~ console.log('do_when_clean',buttonId)
            if (buttonId == "yes") {
                //~ Lino.submit_detail(this_,undefined,todo);
                //~ this_.containing_window.save(todo);
                this_.save(todo);
            } else if (buttonId == "no") { 
              todo();
            }
          }
        }
        Ext.MessageBox.show(config);
    }else{
      //~ console.log('do_when_clean : now!')
      todo();
    }
  },
  
  goto_record_id : function(record_id) {
    //~ console.log('20110701 Lino.FormPanel.goto_record_id()',record_id);
    //~ var this_ = this;
    //~ this.do_when_clean(function() { this_.load_record_id(record_id) }
    this.do_when_clean(true,this.load_record_id.createDelegate(this,[record_id]));
  },
  
  load_record_id : function(record_id,after) {
    var this_ = this;
    //~ var p = { fmt: this.containing_window.config.action_name};
    //~ var p = Ext.apply({},this.containing_window.config.base_params);
    var p = Ext.apply({},this.get_base_params());
    //~ Lino.insert_subst_user(p);
    //~ console.log('20110713 action_name=',this.containing_window.config.action_name,
      //~ 'base_params=',this.containing_window.config.base_params);
    if (this.action_name)
        p.an = this.action_name;
    //~ p.an = this.action_name;
    //~ p.an = this.containing_window.config.action_name;
    //~ p.fmt = 'json';
    //~ p.fmt = '$ext_requests.URL_FORMAT_JSON';
    p.rp = this.getId();
    //~ p.$ext_requests.URL_PARAM_SUBST_USER = Lino.subst_user;
    p.fmt = 'json';
    //~ 20110119b p['$URL_PARAM_FILTER'] = this.quick_search_text;
    //~ Ext.apply(p,this.query_params);
    this.add_param_values(p);
    //~ console.log('20121120 FormPanel.load_record_id',record_id,p);
    if (this.loadMask) this.loadMask.show();
    Ext.Ajax.request({ 
      waitMsg: 'Loading record...',
      method: 'GET',
      params: p,
      scope: this,
      url: this.get_record_url(record_id),
      success: function(response) {   
        // todo: convert to Lino.action_handler.... but result 
        if (this.loadMask) this.loadMask.hide();
        if (response.responseText) {
          var rec = Ext.decode(response.responseText);
          //~ console.log('20120918 goto_record_id success',rec);
          this.set_param_values(rec.param_values);
          this.set_current_record(rec,after);
        }
      },
      failure: Lino.ajax_error_handler(this)
    });
  },

  abandon : function () {
    Ext.MessageBox.alert('Note',
      "No more records to display. Detail window has been closed.");
    Lino.close_window();
    //~ if (this.containing_window) {
        //~ this.containing_window.hide();
    //~ }
  },
  
  set_current_record : function(record,after) {
    //~ console.log('20120722 Lino.FormPanel.set_current_record',record.title,record);
    if (this.record_selector) {
        this.record_selector.clearValue();
        // e.g. InsertWrapper FormPanel doesn't have a record_selector
    }
    this.current_record = record;
    //~ if (record) 
        //~ console.log('Lino.FormPanel.set_current_record',record.title,record);
    //~ else
        //~ console.log('Lino.FormPanel.set_current_record',record);
    //~ this.config.main_panel.form.load(record);    
    if (record) {
      this.enable();
      this.form.my_loadRecord(record.data);
      this.set_window_title(record.title);
      //~ this.getBottomToolbar().enable();
      var da = record.data.disabled_actions;
      if (da) {
          //~ console.log('20120528 disabled_actions =',da,this.getBottomToolbar());
          //~ 20121016 this.getBottomToolbar().items.each(function(item,index,length){
          var tb = this.getTopToolbar();
          if (tb) tb.items.each(function(item,index,length){
              //~ console.log('20120528 ',item.itemId,'-->',da[item.itemId]);
              if (da[item.itemId]) item.disable(); else item.enable();
          });
      };
      if (this.disable_editing | record.data.disable_editing) {
          //~ console.log("20120202 disable_editing",record.title);
          this.form.items.each(function(cmp){
            if (!cmp.always_enabled) cmp.disable();
          },this);
      } else {
          this.form.items.each(function(cmp){
            //~ console.log("20120202",cmp);
            if (record.data.disabled_fields[cmp.name]) cmp.disable();
            else cmp.enable();
          },this);
        
          //~ if (record.data.disabled_fields) {
              //~ for (i = 0; i < record.data.disabled_fields.length; i++) {
                  //~ var flds = this.find('name',record.data.disabled_fields[i]);
                  //~ if (flds.length == 1) { 
                    //~ flds[0].disable(); 
                  //~ }
              //~ }
          //~ }
      };
      
      if (record.navinfo && ! this.hide_top_toolbar && ! this.hide_navigator) {
        this.first.setDisabled(!record.navinfo.first);
        this.prev.setDisabled(!record.navinfo.prev);
        this.next.setDisabled(!record.navinfo.next);
        this.last.setDisabled(!record.navinfo.last);
        this.displayItem.setText(record.navinfo.message);
      } else {
        this.first.setDisabled(true);
        this.prev.setDisabled(true);
        this.next.setDisabled(true);
        this.last.setDisabled(true);
      }
    } else {
      if (this.form.rendered) 
        this.form.reset(); /* FileUploadField would fail when resetting a non-rendered form */
      //~ this.disable();
      //~ this.getBottomToolbar().disable();
      this.form.items.each(function(cmp){
        cmp.disable();
      },this);
      this.set_window_title(this.empty_title);
      //~ this.containing_window.window.setTitle(this.empty_title);
      if (!this.hide_navigator) {
        this.first.disable();
        this.prev.disable();
        this.next.disable();
        this.last.disable();
      }
    }
    //~ console.log('20100531 Lino.DetailMixin.on_load_master_record',this.main_form);
    this.before_row_edit(record);
    if (after) after();
  },
  
  before_row_edit : function(record) {},
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.refresh();
  },
  
  get_selected : function() { return [ this.current_record ] },
  get_current_record : function() {  
    //~ console.log(20100714,this.current_record);
    return this.current_record 
  },
  
  get_permalink_url : function() {
      var rec = this.get_current_record();
      if (rec && ! rec.phantom && rec.id != -99998)
          return '/api' + this.ls_url + '/' + rec.id;
      return '/api' + this.ls_url;
    
  },
  get_permalink_params : function() {
    var p = {};
    //~ var p = {an:'detail'};
    if (this.action_name)
        p.an = this.action_name;
    //~ var p = {an:this.action_name};
    var main = this.items.get(0);
    if (main.activeTab) {
      var tab = main.items.indexOf(main.activeTab);
      //~ console.log('main.activeTab',tab,main.activeTab);
      if (tab) p.tab = tab;
    }
    this.add_param_values(p)
    return p;
  },
  
  /* 
  Lino.FormPanel.save() 
  */
  save : function(after,switch_to_detail,action_name) {
    //~ var panel = this;
    //~ console.log('20121120 FormPanel.save');
    this.loadMask.show();
    var rec = this.get_current_record();
    if (this.has_file_upload) this.form.fileUpload = true;
    //~ console.log('FormPanel.save()',rec);
    if (!action_name) action_name = this.action_name;
    if (rec) {
      var p = {};
      Ext.apply(p,this.get_base_params());
      p.rp = this.getId();
      //~ if (this.action_name) 
          //~ p.$ext_requests.URL_PARAM_ACTION_NAME = this.action_name;
      p.an = action_name;
      if (rec.phantom) {
        //~ if (this.action_name != 'insert') 
            //~ console.log("Warning: phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: '/api' + this.ls_url,
          method: 'POST',
          params: p, 
          scope: this,
          success: function(form, action) {
            this.loadMask.hide();
            Lino.notify(action.result.message);
            /***
            Close this window, but update the status of the 
            calling window.
            If the calling window is a detail on the same table,
            then it should skip to the new record. But only then.
            A successful response usually has a data_record,
            except if it is a fileupload form where some mysterious 
            decoding problems (20120209) force us to return a record_id 
            which will lead to an additional GET.
            ***/
            var url = this.ls_url;
            var ww = Lino.calling_window();
            if (ww && ww.window.main_item instanceof Lino.FormPanel 
                   && ww.window.main_item.ls_url == this.ls_url) {
                //~ console.log("20120217 case 1");
                ww.status.record_id = action.result.record_id;
                ww.status.data_record = action.result.data_record;
                Lino.close_window();
            } else if (this.ls_detail_handler && switch_to_detail) {
                //~ console.log("20120217 case 2");
                Lino.kill_current_window();
                this.ls_detail_handler.run(null,{
                    record_id:action.result.record_id,
                    data_record: action.result.data_record,
                    base_params:this.get_base_params()
                });
            } else {
                //~ console.log("20120217 case 3");
                Lino.close_window();
            }
            //~ Lino.close_window(function(ww){
                //~ if (ww.window.main_item instanceof Lino.FormPanel 
                    //~ && ww.window.main_item.ls_url == url) {
                  //~ ww.status.record_id = action.result.record_id,
                  //~ ww.status.data_record = action.result.data_record
                //~ }
            //~ });
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action);
          },
          clientValidation: true
        })
      } else {
        //~ if (this.action_name != 'detail') 
            //~ console.log("Warning: non-phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: '/api' + this.ls_url + '/' + rec.id,
          method: 'PUT',
          //~ headers: { 'HTTP_X_REQUESTED_WITH' : 'XMLHttpRequest'},
          scope: this,
          params: p, 
          success: function(form, action) {
            //~ panel.form.setValues(rec.data);
            //~ 20110701 panel.form.my_loadRecord(rec);
            this.loadMask.hide();
            Lino.notify(action.result.message);
            if (action.result.data_record)
                this.set_current_record(action.result.data_record,after);
            else
                console.log("Warning: no data_record in response to FormPanel.PUT")
            //~ this.refresh_with_after(after);
            //~ if (after) after(); else panel.refresh();
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action)},
          clientValidation: true
        })
      }
    } else Lino.notify("Sorry, no current record.");
  }
  
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
      this.save(null,true);
      //~ var rec = this.get_current_record();
      //~ if (rec && rec.phantom)
          //~ this.do_when_clean(true,function() { Lino.close_window(); });
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok, scope:this }
        ,{ key: Ext.EventObject.ESCAPE, fn: this.on_cancel, scope:this }
      ]
  }
  
  
  /* not used (no longer possible without .dtl files)
  , edit_detail_config : function () {
    var active_tab = {};
    var main = this.items.get(0);
    if (main.getActiveTab !== undefined) {
      var tabitem = main.getActiveTab();
      Ext.apply(active_tab,{$ext_requests.URL_PARAM_TAB : main.items.indexOf(tabitem)});
    }
    var editor = new Ext.form.TextArea();
    var close = function() { win.close(); }
    var _this = this;
    var save = function() { 
      //~ console.log(20110609,arguments); 
      var params = {desc: editor.getValue()};
      Ext.apply(params,active_tab);
      var a = { 
        params: params, 
        method: 'PUT',
        url: ADMIN_URL + '/detail_config' + _this.ls_url,
        failure : Lino.ajax_error_handler(this),
        success: Lino.action_handler( _this, function(result) {
          //~ console.log('detail_config/save success',result);
          win.close();
          document.location = _this.get_permalink();
        })
      };
      //~ console.log('detail_config/save sent',a);
      _this.loadMask.show(); // 20120211
      Ext.Ajax.request(a);
    }
    var save_btn = new Ext.Button({text:'Save',handler:save,disabled:true});
    var win = new Ext.Window({title:'Detail Layout',
      items:editor, layout:'fit',
      width:500,height:500,
      bbar:[{text:'Cancel',handler:close},save_btn]});
    var a = { 
      params:active_tab, 
      method:'GET',
      url:ADMIN_URL+'/detail_config'+_this.ls_url,
      success : function(response) {
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          if (result.success) {
            editor.setValue(result.desc);
            save_btn.enable();
          }
        }
      }
    };
    Ext.Ajax.request(a);
    win.show();
  }
  */
});


Lino.getRowClass = function(record, rowIndex, rowParams, store) {
  if (record.phantom) {
    //~ console.log(20101009,record);
    //~ rowParams.bodyStyle = "color:red;background-color:blue";
    return 'lino-phantom-row';
    }
  //~ console.log('20101009 not a phantom:',record);
  return '';
}

//~ FOO = 0;



Lino.GridStore = Ext.extend(Ext.data.ArrayStore,{ 
  autoLoad: false
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
    if (!options) options = {};
    if (!options.params) options.params = {};
    options.params.fmt = 'json';
    options.params.rp = this.grid_panel.getId();
    Lino.insert_subst_user(options.params); // since 20121016
      
    if (this.grid_panel.hide_top_toolbar) {
        //~ console.log("20120206 GridStore.load() toolbar is hidden");
        options.params.start = 0;
        if (this.grid_panel.preview_limit) {
          options.params.limit = this.grid_panel.preview_limit;
        }
    } else {
        var ps = this.grid_panel.calculatePageSize();
        if (!ps) {
            //~ this.gridpanel.on('render',this.load())
          //~ console.log("20120814 GridStore.load() failed to calculate pagesize");
          return false;
            //~ params.$URL_PARAM_LIMIT = 1;
            //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
            //~ return;
        } 
        options.params.limit = ps;
      
        //~ options.params.start = this.grid_panel.getTopToolbar().cursor;
        //~ if (this.grid_panel.getTopToolbar().pageSize !=  ps) {
          //~ console.log("20120206 abort load because toolbar says pagesize",
            //~ this.grid_panel.getTopToolbar().pageSize,
            //~ "while actual pagesize is",ps);
            //~ return;
        //~ }
        
        this.grid_panel.getTopToolbar().pageSize =  ps;
        if (options.params.start == undefined)
            options.params.start = this.grid_panel.getTopToolbar().cursor;
      
    }
      
    this.grid_panel.add_param_values(options.params,true);
    //~ Lino.insert_subst_user(options.params);
    //~ console.log("20120814 GridStore.load()",options.params,this.baseParams);
    //~ if (FOO > 0) {
        //~ foo.bar = baz;
    //~ } else FOO += 1;
    return Lino.GridStore.superclass.load.call(this,options);
  }
});

    
Lino.GridPanel = Ext.extend(Ext.grid.EditorGridPanel,Lino.MainPanel);
Lino.GridPanel = Ext.extend(Lino.GridPanel,Lino.PanelMixin);
Lino.GridPanel = Ext.extend(Lino.GridPanel,{
  quick_search_text : '',
  is_searching : false,
  disabled_in_insert_window : true,
  clicksToEdit:2,
  enableColLock: false,
  autoHeight: false,
  params_panel_hidden : false,
  preview_limit : undefined, 
  //~ loadMask: true,
  //~ viewConfig: {
          //~ getRowClass: Lino.getRowClass,
          //~ emptyText:"$_('No data to display.')"
        //~ },
  loadMask: {msg:"Please wait..."},
  
  constructor : function(config){

    config.plugins = [new Lino.GridFilters()];
    
    
    Lino.GridPanel.superclass.constructor.call(this,config);
    
    //~ if (this.containing_window) {
        //~ console.log("20111206 install refresh");
        //~ this.containing_window.on('show',this.refresh,this);
    //~ }
    
  },
  
  unused_is_loading : function() { 
    if (! this.loadMask.el) return true; // not even rendered: 
    // thanks to Marco Pegoraro http://movableapp.com/2011/09/sencha-touch-loadmask-isvisible/
    var loading = (this.loadMask.el.select('.x-loading-msg').elements.length > 0);
    //~ console.log('20130515 GridPanel.is_loading() returns',loading);
    return loading;
    //~ return this.store.getCount() > 0; 
    //~ return (this.loadMask.el.select('.x-loading-msg').elements.length)
    //~ return !this.viewReady; 
    //~ return this.loadMask.isVisible(); 
    //~ return !this.loadMask.disabled; 
  },
  
  unused_config_containing_window : function(wincfg) { 
      //~ temporarily remove save_grid_config button (see /blog(2012/1107)
      if (wincfg.tools != undefined) 
        wincfg.tools = [
          //~ {handler:this.save_grid_data,
            //~ qtip:"$_("Save Grid Data")",
            //~ scope:this, id:"save_data"}, // 20120814
          {handler:this.save_grid_config,
            qtip:"Save Grid Configuration",
            scope:this, id:"save"}
        ].concat(wincfg.tools);
      //~ wincfg.listeners = { show: ... };
  },
  init_containing_window : function(win) { 
    //~ console.log("20111206 install refresh");
    //~ win.on('show',this.refresh,this);
  },
  
  initComponent : function(){
    
    /* 
    Problem 20111206:
    When a GridPanel is the main item of the window, then it doesn't 
    have it's own header but uses the window's header bar.
    We must do this in initComponent because e.g. in beforerender 
    it's already to late: a header element has been created because 
    there was a title.
    But Lino.Window adds itself as `this.containing_window` 
    only after the GridPanel has been initialized.
    Workaround is to generate a line "params.containing_window = true;" 
    in the handler function.
    */ 
    //~ if (this.containing_window) {
    if (this.is_main_window) {
        //~ console.log(20111206, 'delete title',this.title,'from',this);
        //~ delete this.title;
        this.tools = undefined;  
        this.title = undefined;  /* simply deleting it 
          isn't enough because that would only 
          unhide the title defined in some base class. */
    } 
    //~ else console.log(20111206, 'dont delete title',this.title,'from',this);
    
    /* e.g. when slave gridwindow called from a permalink */
    //~ if (this.base_params) Ext.apply(bp,this.base_params);  
    //~ bp['fmt'] = 'json';
    
    //~ function on_proxy_write( proxy, action,data, response,rs,options) {
      //~ console.log('20120814 on_proxy_write',action,data,response)
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
    //~ }
    //~ function on_proxy_load( proxy, transactionObject, callbackOptions ) {
      //~ console.log('on_proxy_load',transactionObject)
    //~ }
    var proxy = new Ext.data.HttpProxy({ 
      // 20120814 
      url: '/api' + this.ls_url
      ,method: "GET"
      //~ ,url: ADMIN_URL + '/restful' + this.ls_url
      //~ ,restful: true 
      //~ ,listeners: {load:on_proxy_load} 
      //~ ,listeners: {write:on_proxy_write} 
    });
    //~ config.store = new Ext.data.JsonStore({ 
    //~ this.store = new Ext.data.ArrayStore({ 
    this.store = new Lino.GridStore({ 
      grid_panel: this
      ,listeners: { exception: Lino.on_store_exception }
      ,remoteSort: true
      ,totalProperty: "count"
      ,root: "rows"
      //~ ,id: "id" 
      ,proxy: proxy
      //~ autoLoad: this.containing_window ? true : false
      ,idIndex: this.pk_index
      //~ ,baseParams: bp
      ,fields: this.ls_store_fields
      ,idProperty: this.ls_id_property 
      // 20120814
      //~ ,writer : new Ext.data.JsonWriter({
        //~ writeAllFields: false
        //~ ,listful: true
      //~ })
      //~ ,restful : true
    });
      
    //~ console.log('config.pk_index',config.pk_index,config.store),
    delete this.ls_store_fields;
      
    var this_ = this;
    //~ var grid = this;
    this.store.on('load', function() {
        //~ console.log('20120814 GridStore.on(load)',this_.store);
        //~ var da = this_.store.reader.arrayData.disabled_actions;
        //~ if (da) {
            //~ this.cmenu.cascade(function(item){ 
              //~ console.log(20120531, item.itemId, da[item.itemId]);
              //~ if (da[item.itemId]) item.disable(); else item.enable();
            //~ });
        //~ };
        this_.set_param_values(this_.store.reader.arrayData.param_values);
        //~ this_.set_status(this_.store.reader.arrayData.status);
        //~ 20120918
        if (this_.store.reader.arrayData.no_data_text) {
            //~ this.viewConfig.emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().refresh();
        }
        if (this_.containing_window)
            this_.set_window_title(this_.store.reader.arrayData.title);
            //~ this_.containing_window.setTitle(this_.store.reader.arrayData.title);
        if (!this.is_searching) { // disabled 20121025: quick_search_field may not lose focus
          this.is_searching = false;
          if (this_.selModel.getSelectedCell){
              if (this_.getStore().getCount()) // there may be no data
                  this_.selModel.select(0,0); 
          } else {
              this_.selModel.selectFirstRow();
              this_.getView().focusEl.focus();
          }
        } 
        //~ else console.log("is_searching -> no focussing");
        //~ var t = this.getTopToolbar();
        //~ var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
        //~ this.quick_search_field.focus(); // 20121024
      }, this
    );
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar, this.cmenu = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ this.cmenu = new Ext.menu.Menu({items: config.bbar});
    delete this.ls_bbar_actions
    if (actions) {
        this.cmenu = actions.cmenu;
    }
    
    if (!this.hide_top_toolbar) {  
      var tbar = [ 
        this.quick_search_field = new Ext.form.TextField({ 
          //~ fieldLabel: "Search"
          listeners: { 
            scope:this_
            //~ ,change:this_.search_change
            
            ,render: Lino.quicktip_renderer("Quick Search","Enter a text to use as quick search filter")
            
            //~ ,keypress: this.search_keypress 
            ,blur: function() { this.is_searching = false}
          }
          ,validator:function(value) { return this_.search_validate(value) }
          //~ ,tooltip: "Enter a quick search text, then press TAB"
          //~ value: text
          //~ scope:this, 
          //~ ,enableKeyEvents: true
          //~ listeners: { keypress: this.search_keypress }, 
          //~ id: "seachString" 
      })];
      tbar = this.add_params_panel(tbar);
      tbar = tbar.concat([
        { scope:this, 
          //~ text: "[csv]", 
          tooltip: "Export this table to a .csv file", 
          iconCls: 'x-tbar-csv',
          handler: function() { 
            //~ 20130116 var p = Ext.apply({},this.get_base_params());
            //~ 20130116 p.fmt = 'csv';
            //~ url += "?" + Ext.urlEncode(p);
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            p.fmt = "csv";
            this.add_param_values(p,true);
            
            window.open('/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } },
        //~ { scope:this, 
          //~ text: "[html]", 
          //~ handler: function() { 
            //~ var p = this.get_current_grid_config();
            //~ Ext.apply(p,this.get_base_params());
            //~ p.$ext_requests.URL_PARAM_FORMAT = "$ext_requests.URL_FORMAT_PRINTER";
            //~ this.add_param_values(p);
            //~ window.open(ADMIN_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          //~ } },
        { scope:this, 
          //~ text: "[html]", 
          tooltip: "Show this table in plain html", 
          iconCls: 'x-tbar-html',
          handler: function() { 
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            //~ since 20121226 p.$ext_requests.URL_PARAM_FORMAT = "$ext_requests.URL_FORMAT_PLAIN";
            this.add_param_values(p,true);
            //~ since 20121226 window.open(ADMIN_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
            window.open('/plain'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } },
        { scope:this, 
          //~ text: "[pdf]", 
          tooltip: "Show this table as a pdf document", 
          iconCls: 'x-tbar-pdf',
          handler: function() { 
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            p.fmt = "pdf";
            this.add_param_values(p,true);
            window.open('/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } }
      ]);
    
    
      var menu = [];
      var set_gc = function(index) {
        return function() {
          //~ console.log('set_gc() 20100812');
          this.getColumnModel().setConfig(
              this.apply_grid_config(index,this.ls_grid_configs,this.ls_columns));
        }
      }
      for (var i = 0; i < this.ls_grid_configs.length;i++) {
        var gc = this.ls_grid_configs[i];
        menu.push({text:gc.label,handler:set_gc(i),scope:this})
      }
      if(menu.length > 1) {
        tbar = tbar.concat([
          { text:"View",
            menu: menu,
            tooltip:"Select another view of this report"
          }
        ]);
      }
      
      if (actions) {
        tbar = tbar.concat(actions.bbar);
          //~ this.bbar = actions.bbar;
      }
      
      this.tbar = new Ext.PagingToolbar({ 
        store: this.store, 
        prependButtons: true, 
        //~ pageSize: this.page_length, 
        pageSize: 1, 
        displayInfo: true, 
        beforePageText: "Page",
        afterPageText: "of {0}",
        displayMsg: "Displaying {0} - {1} of {2}",
        firstText: "First page",
        lastText: "Last page",
        prevText: "Previous page",
        nextText: "Next page",
        items: tbar
      });
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ var ps = this.calculatePageSize();
          //~ if (ps && ps != this.getTopToolbar().pageSize) {
              //~ // console.log('20120203 resize : pageSize',this.getTopToolbar().pageSize,'->',ps);
              //~ // this.getTopToolbar().pageSize =  ps;
              //~ cmp.refresh();
              //~ // this.getTopToolbar().doRefresh();
          //~ }
        //~ }, this);
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ cmp.getTopToolbar().pageSize = this.calculatePageSize(aw,ah,rw,rh) || 10;
          //~ cmp.refresh();
        //~ }, this, {delay:500});
    }
    
    //~ delete this.page_length
    
    
      
    if (this.ls_quick_edit) {
      this.selModel = new Ext.grid.CellSelectionModel()
      this.get_selected = function() {
        //~ console.log(this.getSelectionModel().selection);
        if (this.selModel.selection)
            return [ this.selModel.selection.record ];
        return [this.store.getAt(0)];
      };
      this.get_current_record = function() { 
        if (this.getSelectionModel().selection) 
          return this.selModel.selection.record;
        return this.store.getAt(0);
      };
    } else { 
      this.selModel = new Ext.grid.RowSelectionModel() 
      this.get_selected = function() {
        var sels = this.selModel.getSelections();
        if (sels.length == 0) sels = [this.store.getAt(0)];
        return sels
        //~ var sels = this.getSelectionModel().getSelections();
        //~ return Ext.pluck(sels,'id');
      };
      this.get_current_record = function() { 
        var rec = this.selModel.getSelected();
        if (rec == undefined) rec = this.store.getAt(0);
        return rec
      };
    };
    delete this.ls_quick_edit;
    
    this.columns  = this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns);
    
    //~ var grid = this;
    //~ this.colModel = new Ext.grid.ColumnModel({
      //~ columns: this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns),
      //~ isCellEditable: function(col, row) {
        //~ var record = grid.store.getAt(row);
        //~ console.log('20120514',col,record); // dataIndex
        //~ var dataIndex = grid.colModel.getDataIndex(col);
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("$_("This field is disabled")");
            //~ return false;
        //~ }
        //~ return Ext.grid.ColumnModel.prototype.isCellEditable.call(this, col, row);
      //~ }
    //~ });    
    
    
    Lino.GridPanel.superclass.initComponent.call(this);
    
    //~ if (this.containing_window) 
        //~ this.on('afterlayout', this.refresh, this);
        //~ this.on('afterrender', this.refresh,this);
    //~ else
        //~ this.on('show', this.refresh,this);
    //~ this.on('afterlayout', function() {
      //~ if (this.id == "ext-comp-1157") 
        //~ console.log("20120213 afterlayout",this); 
      //~ // this.refresh();
      //~ },this);
    //~ this.on('afterrender', this.refresh);
    //~ this.on('resize', this.refresh,this,{delay:500});
    //~ this.on('resize', function(){console.log("20120213 resize",arguments)},this);
    this.on('resize', function(){
      //~ console.log("20120213 resize",arguments)
      this.refresh();
      },this);
    this.on('viewready', function(){
      //~ console.log("20120213 resize",arguments);
      this.view_is_ready = true;
      this.refresh();
      },this);
    this.on('afteredit', this.on_afteredit); // 20120814
    //~ this.on('afteredit', this.new_on_afteredit);
    this.on('beforeedit', this.on_beforeedit);
    this.on('beforeedit',function(e) { this.before_row_edit(e.record)},this);
    this.on('cellcontextmenu', Lino.cell_context_menu, this);
    //~ this.on('contextmenu', Lino.grid_context_menu, this);
    
    
    //~ if (this.id == "ext-comp-1157") captureEvents(this);    
    
  },
  
  //~ onResize : function(){
      //~ console.log("20120206 GridPanel.onResize",arguments);
      //~ Lino.GridPanel.superclass.onResize.apply(this, arguments);
      //~ this.refresh();
  //~ },
  
  
  get_status : function(){
    var st = { base_params : this.get_base_params()};
    if (!this.hide_top_toolbar) {
        st.current_page = this.getTopToolbar().current;
    }
    st.param_values = this.status_param_values;
    //~ console.log("20120213 GridPanel.get_status",st);
    return st;
  },
  
  /* 
  Lino.GridPanel.set_status() 
  */
  set_status : function(status){
    //~ console.log("20130605 GridPanel.set_status",status);
    this.clear_base_params();
    if (status == undefined) status = {};
    this.set_param_values(status.param_values);
    if (status.base_params) { 
      this.set_base_params(status.base_params);
    }
    if (status.show_params_panel != undefined) {
        if (this.toggle_params_panel_btn) {
            //~ this.toggle_params_panel_btn.toggle(status.show_params_panel=='true');
            this.toggle_params_panel_btn.toggle(status.show_params_panel);
        }
    }
    if (!this.hide_top_toolbar) {
      //~ console.log("20120213 GridPanel.getTopToolbar().changePage",
          //~ status.current_page || 1);
      this.getTopToolbar().changePage(status.current_page || 1);
    }
    //~ this.fireEvent('resize');
    //~ this.refresh.defer(100,this); 
    //~ this.onResize.defer(100,this); 
    //~ this.refresh(); 
    //~ this.doLayout(); 
    //~ this.onResize(); 
    //~ this.store.load();
  },
  
  refresh : function(unused) { 
    this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ Lino.notify('20120204 Lino.GridPanel.refresh');
    //~ Lino.notify('Lino.GridPanel.refresh '+this.store.proxy.url);
    //~ var bp = { fmt:'json' }
    if (this.containing_panel) {
        //~ Ext.apply(p,this.master_panel.get_master_params());
        //~ Ext.apply(options.params,this.containing_panel.get_master_params());
        this.set_base_params(this.containing_panel.get_master_params());
    }
    
    if (! this.view_is_ready) return;
    
    var options = {};
    if (after) {
        options.callback = function(r,options,success) {if(success) after()}
    }
      
    //~ if (!this.rendered) {
        //~ console.log("20120206 GridPanel.refresh() must wait until rendered",options);
        //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
        //~ return;
    //~ }
    
    this.store.load(options);
  },
  
  /* pageSize depends on grid height (Trying to remove scrollbar)
  Thanks to 
  - Christophe Badoit on http://www.sencha.com/forum/showthread.php?82647
  - http://www.sencha.com/forum/archive/index.php/t-37231.html
  */
  calculatePageSize : function(second_attempt) {
    //~ if (!this.rendered) { 
    if (!this.view_is_ready) { 
      //~ console.log('Cannot calculatePageSize() : not rendered');
      return false; }
    //~ if (!this.isVisible()) { 
      //~ console.log('calculatePageSize : not visible');
      //~ return false; }
      
    //~ console.log('getFrameHeight() is',this.getFrameHeight());
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('mainBody.getHeight() is',this.getView().mainBody.getHeight());
    //~ console.log('getInnerHeight() is',this.getInnerHeight());
    //~ console.log('getHeight() is',this.getHeight());
    //~ console.log('el.getHeight() is',this.getEl().getHeight());
    //~ console.log('getGridEl().getHeight() is',this.getGridEl().getHeight());
    //~ console.log('getOuterSize().height is',this.getOuterSize().height);
    //~ console.log('getBox().height is',this.getBox().height);
    //~ console.log('getResizeEl.getHeight() is',this.getResizeEl().getHeight());
    //~ console.log('getLayoutTarget().getHeight() is',this.getLayoutTarget().getHeight());
      
    var rowHeight = this.getFrameHeight();
    //~ var rowHeight = 52; // experimental value
    var row = this.view.getRow(0);
    if (row) {
      //~ console.log('20120213 yes');
      rowHeight = Ext.get(row).getHeight();
    }
    //~ console.log('rowHeight is ',rowHeight,this,caller);
    //~ this.getView().syncScroll();
    //~ this.getView().initTemplates();
    var height = this.getView().scroller.getHeight();
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('getInnerHeight() - getFrameHeight() is',
      //~ this.getInnerHeight(), '-',
      //~ this.getFrameHeight(), '=',
      //~ this.getInnerHeight() - this.getFrameHeight());
    //~ var height = this.getView().mainBody.getHeight();
    //~ var height = this.getView().mainWrap.getHeight();
    //~ var height = this.getView().resizeMarker.getHeight();
    //~ this.syncSize();
    //~ var height = this.getInnerHeight() - this.getFrameHeight();
    //~ var height = this.getHeight() - this.getFrameHeight();
    height -= Ext.getScrollBarWidth(); // leave room for a possible horizontal scrollbar... 
    //~ height -= this.getView().scrollOffset;
    var ps = Math.floor(height / rowHeight);
    //~ console.log('20120203 calculatePageSize():',height,'/',rowHeight,'->',ps);
    ps -= 1; // leave room for a possible phantom row
    //~ return (ps > 1 ? ps : false);
    if (ps > 1) return ps;
    //~ console.log('calculatePageSize() found less than 1 row:',height,'/',rowHeight,'->',ps);
    //~ foo.bar = baz; // 20120213
    return 5; // preview_limit
    //~ if (second_attempt) {
        //~ console.log('calculatePageSize() abandons after second attempt:',
          //~ height,'/',rowHeight,'->',ps);
      //~ return 5;
    //~ }
    //~ return this.calculatePageSize.defer(500,this,[true]);
  },
  
  onCellDblClick : function(grid, row, col){
      //~ console.log("20120307 onCellDblClick",this,grid, row, col);
      if (this.ls_detail_handler) {
          //~ Lino.notify('show detail');
          Lino.show_detail(this);
          return false;
      }else{
        //~ console.log('startEditing');
        this.startEditing(row,col);
      }
  },
  
  get_base_params : function() {
    //~ return this.containing_window.config.base_params;
    //~ console.log(20120717,this.store.baseParams);
    var p = Ext.apply({},this.store.baseParams);
    Lino.insert_subst_user(p);
    //~ console.log("20120717 GRidPanel.get_base_params() returns",p);
    return p;
    //~ return this.store.baseParams;
  },
  set_base_params : function(p) {
    //~ console.log('GridPanel.set_base_params',p)
    for (k in p) this.store.setBaseParam(k,p[k]);
    //~ this.store.baseParams = p;
    if (p.query) 
        this.quick_search_field.setValue(p.query);
    //~ if (p.param_values) 
        //~ this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.store.baseParams = {};
      Lino.insert_subst_user(this.store.baseParams);
  },
  set_base_param : function(k,v) {
    this.store.setBaseParam(k,v);
  },
  
  //~ get_permalink_params : function() {
    //~ var p = {};
    //~ return p;
  //~ },
  
  before_row_edit : function(record) {},
    
  //~ search_keypress : function(){
    //~ console.log("2012124 search_keypress",arguments);
  //~ },
  search_validate : function(value) {
    if (value == this.quick_search_text) return true;
    this.is_searching = true;
    //~ console.log('search_validate',value)
    this.quick_search_text = value;
    this.set_base_param('query',value); 
    //~ this.getTopToolbar().changePage(1);
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
    return true;
  },
  
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
  },
  
  apply_grid_config : function(index,grid_configs,rpt_columns) {
    //~ var rpt_columns = this.ls_columns;
    var gc = grid_configs[index];    
    //~ console.log('apply_grid_config() 20100812',name,gc);
    this.gc_name = index;
    if (gc == undefined) {
      return rpt_columns;
      //~ config.columns = config.ls_columns;
      //~ return;
    } 
    //~ delete config.ls_filters
    
    //~ console.log(20100805,config.ls_columns);
    var columns = Array(gc.columns.length);
    for (var j = 0; j < rpt_columns.length;j++) {
      var col = rpt_columns[j];
      for (var i = 0; i < gc.columns.length; i++) {
        if (col.dataIndex == gc.ci[i]) {
          col.width = gc.cw[i];
          col.hidden = gc.ch[i];
          columns[i] = col;
          break;
        }
      }
    }
    
    //~ var columns = Array(rpt_columns.length);
    //~ for (var i = 0; i < rpt_columns.length; i++) {
      //~ columns[i] = rpt_columns[gc.columns[i]];
      //~ columns[i].width = gc.widths[i];
    //~ }
    
    //~ if (gc.hidden_cols) {
      //~ for (var i = 0; i < gc.hidden_cols.length; i++) {
        //~ var hc = gc.hidden_cols[i];
        //~ for (var j = 0; j < columns.length;j++) {
          //~ var col = columns[j];
          //~ if (col.dataIndex == hc) {
            //~ col.hidden = true;
            //~ break
          //~ }
        //~ }
      //~ }
    //~ }
    if (gc.filters) {
      //~ console.log(20100811,'config.ls_filters',config.ls_filters);
      //~ console.log(20100811,'config.ls_grid_config.filters',config.ls_grid_config.filters);
      for (var i = 0; i < gc.filters.length; i++) {
        var fv = gc.filters[i];
        for (var j = 0; j < columns.length;j++) {
          var col = columns[j];
          if (col.dataIndex == fv.field) {
            //~ console.log(20100811, f,' == ',fv);
            if (fv.type == 'string') {
              col.filter.value = fv.value;
              //~ if (fv.comparison !== undefined) f.comparison = fv.comparison;
            } else {
              //~ console.log(20100811, fv);
              col.filter.value = {};
              col.filter.value[fv.comparison] = fv.value;
            }
            break;
          }
        };
      }
    }
    
    return columns;
    //~ config.columns = cols;
    //~ delete config.ls_columns
  },
  
  get_current_grid_config : function () {
    var cm = this.getColumnModel();
    var widths = Array(cm.config.length);
    var hiddens = Array(cm.config.length);
    //~ var hiddens = Array(cm.config.length);
    var columns = Array(cm.config.length);
    //~ var columns = Array(cm.config.length);
    //~ var hidden_cols = [];
    //~ var filters = this.filters.getFilterValues();
    var p = this.filters.buildQuery(this.filters.getFilterData())
    for (var i = 0; i < cm.config.length; i++) {
      var col = cm.config[i];
      columns[i] = col.dataIndex;
      //~ hiddens[i] = col.hidden;
      widths[i] = col.width;
      hiddens[i] = col.hidden;
      //~ if (col.hidden) hidden_cols.push(col.dataIndex);
    }
    //~ p['hidden_cols'] = hidden_cols;
    p.cw = widths;
    p.ch = hiddens;
    p.ci = columns;
    //~ p['widths'] = widths;
    //~ p['hiddens'] = hiddens;
    //~ p['columns'] = columns;
    p['name'] = this.gc_name;
    //~ var gc = this.ls_grid_configs[this.gc_name];
    //~ if (gc !== undefined) 
        //~ p['label'] = gc.label
    //~ console.log('20100810 save_grid_config',p);
    return p;
  },
  
  unused_manage_grid_configs : function() {
    var data = [];
    for (k in this.ls_grid_configs) {
      var v = this.ls_grid_configs[k];
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i)
    }
    if (this.ls_grid_configs[this.gc_name] == undefined) {
      var v = this.get_current_grid_config();
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i);
    }
    //~ console.log(20100811, data);
    var main = new Ext.grid.GridPanel({
      store: new Ext.data.ArrayStore({
        idIndex:0,
        fields:['name','columns','hidden_cols','filters'],
        autoDestroy:true,
        data: data}),
      //~ autoHeight:true,
      selModel: new Ext.grid.RowSelectionModel(),
      listeners: { 
        rowdblclick: function(grid,rowIndex,e) {
          console.log('row doubleclicked',grid, rowIndex,e);
        },
        rowclick: function(grid,rowIndex,e) {
          console.log('row clicked',grid, rowIndex,e);
        }
      },
      columns: [ 
        {dataIndex:'name',header:'Name'}, 
        {dataIndex:'columns',header:'columns'}, 
        {dataIndex:'hidden_cols',header:'hidden columns'}, 
        {dataIndex:'filters',header:'filters'} 
      ]
    });
    var win = new Ext.Window({title:'GridConfigs Manager',layout:'fit',items:main,height:200});
    win.show();
  },
  
  unused_edit_grid_config : function(name) {
    gc = this.ls_grid_configs[name];
    var win = new Ext.Window({
      title:'Edit Grid Config',layout:'vbox', 
      //~ layoutConfig:'stretch'
      items:[
        {xtype:'text', value: gc.name},
        {xtype:'text', value: gc.columns},
        {xtype:'text', value: gc.hidden_cols},
        {xtype:'text', value: gc.filters}
      ]
    });
    win.show();
  },
  
  save_grid_config : function () {
    //~ console.log('TODO: save_grid_config',this);
    //~ p.column_widths = Ext.pluck(this.colModel.columns,'width');
    var a = { 
      params:this.get_current_grid_config(), 
      method:'PUT',
      url:'/grid_config' + this.ls_url,
      success: Lino.action_handler(this),
      scope: this,
      failure: Lino.ajax_error_handler(this)
    };
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(a);
    //~ Lino.do_action(this,a);
  },
  
  on_beforeedit : function(e) {
    //~ console.log('20130128 GridPanel.on_beforeedit()',e,e.record.data.disable_editing);
    if(this.disable_editing | e.record.data.disable_editing) {
      e.cancel = true;
      Lino.notify("This record is disabled");
      return;
    }
    if(e.record.data.disabled_fields && e.record.data.disabled_fields[e.field]) {
      e.cancel = true;
      Lino.notify("This field is disabled");
      return;
    }
    //~ if (e.record.data.disabled_fields) {
      //~ for (i in e.record.data.disabled_fields) {
        //~ if(e.record.data.disabled_fields[i] == e.field) {
          //~ e.cancel = true;
          //~ Lino.notify(String.format('Field "{0}" is disabled for this record',e.field));
          //~ return
        //~ }
      //~ }
    //~ }
  },
  save_grid_data : function() {
      //~ console.log("20120814 save_grid_data");
      this.getStore().commitChanges();
  },
  new_on_afteredit : function(e) {
      //~ this.getStore().commitChanges();
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
      console.log("20120814 new_on_afteredit",e);
  },
  on_afteredit : function(e) {
    /*
    e.grid - The grid that fired the event
    e.record - The record being edited
    e.field - The field name being edited
    e.value - The value being set
    e.originalValue - The original value for the field, before the edit.
    e.row - The grid row index
    e.column - The grid column index
    */
    var p = {};
    //~ console.log('20101130 modified: ',e.record.modified);
    //~ console.log('20101130 value: ',e.value);
    //~ var p = e.record.getChanges();
    //~ console.log('20101130 getChanges: ',e.record.getChanges());
    //~ this.before_row_edit(e.record);
    for(k in e.record.getChanges()) {
        var v = e.record.get(k);
    //~ for(k in e.record.modified) {
        //~ console.log('20101130',k,'=',v);
        //~ var cm = e.grid.getColumnModel();
        //~ var di = cm.getDataIndex(k);
        var f = e.record.fields.get(k);
        //~ console.log('20101130 f = ',f);
        //~ var v = e.record.get(di);
        if (f.type.type == 'date') {
            p[k] = Ext.util.Format.date(v, f.dateFormat);
        }else{
            p[k] = v;
            var v = e.record.get(k+'Hidden');
            if (v !== undefined) {
              p[k+'Hidden'] = v;
            }
        }
        //~ var i = cm.findColumnIndex(k);
        //~ var r = cm.getRenderer(i);
        //~ var editor = cm.getCellEditor(i,e.row);
        //~ var col = e.grid.getColumnModel().getColumnById(k);
        //~ console.log('20101130 r = ',r(v));
        //~ var f = e.record.fields[k];
        //~ console.log('20101130 f = ',f);
        //~ console.log('20101130 editor = ',editor);
        //~ p[k] = f.getValue();
        //~ p[k] = r(v);
    }
    //~ console.log('20101130 p:',p);
    //~ var cm = e.grid.getColumnModel();
    //~ var di = cm.getDataIndex(e.column);
    //~ var f = e.record.fields.get(di);
    //~ console.log('20101130 f = ',f);
    //~ if (f.type.type == 'date') e.record.set(di,Ext.util.Format.date(e.value, f.dateFormat));
    
    
    //~ var p = e.record.data;
    
    // var p = {};
    //~ p['grid_afteredit_colname'] = e.field;
    //~ p[e.field] = e.value;
    //~ console.log('20100723 GridPanel.on_afteredit()',e);
    // add value used by ForeignKeyStoreField CHOICES_HIDDEN_SUFFIX
    // not sure whether this is still needed:
    p[e.field+'Hidden'] = e.value;
    //~ p.su = Lino.subst_user;
    Lino.insert_subst_user(p);
    // this one is needed so that this field can serve as choice context:
    e.record.data[e.field+'Hidden'] = e.value;
    // p[pk] = e.record.data[pk];
    // console.log("grid_afteredit:",e.field,'=',e.value);
    Ext.apply(p,this.get_base_params()); // needed for POST, ignored for PUT
    //~ Ext.apply(p,this.containing_window.config.base_params);
    //~ 20121109 p['$ext_requests.URL_PARAM_ACTION_NAME'] = 'grid';
    var self = this;
    var req = {
        params:p,
        waitMsg: 'Saving your data...',
        success: Lino.action_handler( this, function(result) {
          //~ if (result.data_record) {
          if (result.refresh_all) {
              var cw = self.get_containing_window();
              if (cw) {
                  cw.main_item.refresh();
              }
              else console.log("20120123 cannot refresh_all",self);
          } else if (result.rows) {
              //~ self.getStore().loadData(result,true);
              var r = self.getStore().reader.readRecords(result);
              if (e.record.phantom) {
                  //~ console.log("20120816 afteredit.success POST",r);
                  self.getStore().insert(e.row,r.records);
              }else{
                  //~ console.log("20120816 afteredit.success PUT",r);
                  self.getStore().doUpdate(r.records[0]);
              }
              self.getStore().rejectChanges(); /* 
              get rid of the red triangles without saving the record again
              */
              //~ self.getStore().commitChanges(); // get rid of the red triangles
          } else {
              self.getStore().commitChanges(); // get rid of the red triangles
              self.getStore().reload();        // reload our datastore.
          }
          }),
        scope: this,
        failure: Lino.ajax_error_handler(this)
    };
    if (e.record.phantom) {
      req.params.an = 'post'; // SubmitInsert.action_name
      Ext.apply(req,{
        method: 'POST',
        url: '/api' + this.ls_url
      });
    } else {
      req.params.an = 'put'; // SubmitDetail.action_name
      Ext.apply(req,{
        method: 'PUT',
        url: '/api' + this.ls_url + '/' + e.record.id
      });
    }
    //~ console.log('20110406 on_afteredit',req);
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(req);
  },

  afterRender : function() {
    Lino.GridPanel.superclass.afterRender.call(this);
    // this.getView().mainBody.focus();
    // console.log(20100114,this.getView().getRows());
    // if (this.getView().getRows().length > 0) {
    //  this.getView().focusRow(1);
    // }
    //~ this.my_load_mask = new Ext.LoadMask(this.getEl(), {
        //~ msg:'$_("Please wait...")',
        //~ store:this.store});
      
    var tbar = this.getTopToolbar();
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    // tbar.on('change',function() {this.getSelectionModel().selectFirstRow();this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    this.nav = new Ext.KeyNav(this.getEl(),{
      pageUp: function() {tbar.movePrevious(); },
      pageDown: function() {tbar.moveNext(); },
      home: function() {tbar.moveFirst(); },
      end: function() {tbar.moveLast(); },
      scope: this
    });
  },
  after_delete : function() {
    //~ console.log('Lino.GridPanel.after_delete');
    this.refresh();
  },
  add_row_listener : function(fn,scope) {
    this.getSelectionModel().addListener('rowselect',fn,scope);
  },
  postEditValue : function(value, originalValue, r, field){
    value = Lino.GridPanel.superclass.postEditValue.call(this,value,originalValue,r,field);
    //~ console.log('GridPanel.postEdit()',value, originalValue, r, field);
    return value;
  },
  
  set_start_value : function(v) {
      this.start_value = v;
  },
  preEditValue : function(r, field){
      if (this.start_value) {
        var v = this.start_value;
        delete this.start_value;
        this.activeEditor.selectOnFocus = false;
        return v;
      }
      var value = r.data[field];
      return this.autoEncode && Ext.isString(value) ? Ext.util.Format.htmlDecode(value) : value;
  },
  
  on_master_changed : function() {
    //~ if (! this.enabled) return;
    //~ cmp = this;
    //~ console.log('Lino.GridPanel.on_master_changed()',this.title);
    if (! this.rendered) return; // 20120213
    var todo = function() {
      if (this.disabled) return;
      //~ if (this.disabled) return;
      //~ if (this.enabled) {
          //~ var src = caller.config.url_data + "/" + record.id + ".jpg"
          //~ console.log(20111125, this.containing_window);
          //~ for (k in p) this.getStore().setBaseParam(k,p[k]);
          //~ console.log('Lino.GridPanel.on_master_changed()',this.title,p);
          this.refresh();
          //~ this.set_base_params(this.master_panel.get_master_params());
          //~ this.getStore().load(); 
      //~ }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
  

//~ Lino.MainPanelMixin = {
  //~ tbar_items : function() {
      //~ return ;
  //~ }
//~ };

//~ Ext.override(Lino.GridPanel,Lino.MainPanelMixin);
//~ Ext.override(Lino.FormPanel,Lino.MainPanelMixin);

//~ Lino.grid_context_menu = function(e) {
  //~ console.log('contextmenu',arguments);
//~ }

Lino.cell_context_menu = function(grid,row,col,e) {
  //~ console.log('20120531 cellcontextmenu',grid,row,col,e,grid.store.reader.arrayData.rows[row]);
  e.stopEvent();
  //~ grid.getView().focusCell(row,col);
  grid.getSelectionModel().select(row,col);
  //~ console.log(grid.store.getAt(row));
  //~ grid.getView().focusRow(row);
  //~ return;
  if(!grid.cmenu.el){grid.cmenu.render(); }
  //~ if(e.record.data.disabled_fields) {
  
  var da = grid.store.reader.arrayData.rows[row][grid.disabled_actions_index];
  if (da) {
      this.cmenu.cascade(function(item){ 
        //~ console.log(20120531, item.itemId, da[item.itemId]);
        if (da[item.itemId]) item.disable(); else item.enable();
      });
  };
  
  var xy = e.getXY();
  xy[1] -= grid.cmenu.el.getHeight();
  grid.cmenu.showAt(xy);
}


//~ Lino.load_main_menu = function() {
  //~ Ext.Ajax.request({
    //~ waitMsg: 'Loading main menu...',
    //~ method: 'GET',
    //~ url: '/menu',
    //~ success: Lino.on_load_menu,
    //~ failure: Lino.ajax_error_handler
  //~ });
//~ };



//~ Lino.SlavePlugin = function(caller) {
  //~ this.caller = caller;
//~ };

Lino.chooser_handler = function(combo,name) {
  return function(cmp,newValue,oldValue) {
    //~ console.log('Lino.chooser_handler()',cmp,oldValue,newValue);
    combo.setContextValue(name,newValue);
  }
};



Lino.ComboBox = Ext.extend(Ext.form.ComboBox,{
  forceSelection: true,
  triggerAction: 'all',
  minListWidth:230,
  autoSelect: false,
  selectOnFocus: true, // select any existing text in the field immediately on focus.
  submitValue: true,
  displayField: 'text', // 'text', 
  valueField: 'value', // 'value',
  
  //~ initComponent : Ext.form.ComboBox.prototype.initComponent.createSequence(function() {
  initComponent : function(){
      this.contextParams = {};
      //~ Ext.form.ComboBox.initComponent(this);
      Lino.ComboBox.superclass.initComponent.call(this);
  },
  setValue : function(v,record_data){
      /*
      Based on feature request developed in http://extjs.net/forum/showthread.php?t=75751
      */
      /* `record_data` is used to get the text corresponding to this value */
      //~ if(this.name == 'city') 
      //~ console.log('20120203', this.name,'.setValue(', v ,') this=', this,'record_data=',record_data);
      var text = v;
      if(this.valueField){
        if(v == null || v == '') { 
            //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,'no lookup needed, value is empty');
            //~ v = undefined;
            v = '';
            //~ text = '';
        } else if (Ext.isDefined(record_data)) {
          text = record_data[this.name];
          //~ if (this.name == 'birth_country') 
            //~ console.log(this.name,'.setValue',v,'got text ',text,' from record ',record);
        } else {
          // if(this.mode == 'remote' && !Ext.isDefined(this.store.totalLength)){
          if(this.mode == 'remote' && ( this.lastQuery === null || (!Ext.isDefined(this.store.totalLength)))){
              //~ if (this.name == 'birth_country') console.log(this.name,'.setValue',v,'store not yet loaded');
              this.store.on('load', this.setValue.createDelegate(this, arguments), null, {single: true});
              if(this.store.lastOptions === null || this.lastQuery === null){
                  var params;
                  if(this.valueParam){
                      params = {};
                      params[this.valueParam] = v;
                  }else{
                      var q = this.allQuery;
                      this.lastQuery = q;
                      this.store.setBaseParam(this.queryParam, q);
                      params = this.getParams(q);
                  }
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : call load() with params ',params);
                  this.store.load({params: params});
              //~ }else{
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : but store is loading',this.store.lastOptions);
              }
              return;
          //~ }else{
              //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,' : store is loaded, lastQuery is "',this.lastQuery,'"');
          }
          var r = this.findRecord(this.valueField, v);
          if(r){
              text = r.data[this.displayField];
          }else if(this.valueNotFoundText !== undefined){
              text = this.valueNotFoundText;
          }
        }
      }
      this.lastSelectionText = text;
      //~ this.lastSelectionText = v;
      if(this.hiddenField){
          //~ this.hiddenField.originalValue = v;
          this.hiddenField.value = v;
      }
      Ext.form.ComboBox.superclass.setValue.call(this, text);
      this.value = v; // needed for grid.afteredit
  },
  
  getParams : function(q){
    // p = Ext.form.ComboBox.superclass.getParams.call(this, q);
    // causes "Ext.form.ComboBox.superclass.getParams is undefined"
    var p = {};
    //p[this.queryParam] = q;
    if(this.pageSize){
        //~ p.start = 0;
        //~ p.limit = this.pageSize;
        p['start'] = 0;
        p['limit'] = this.pageSize;
    }
    // now my code:
    if(this.contextParams) Ext.apply(p,this.contextParams);
    //~ if(this.contextParams && this.contextValues) {
      //~ for(i = 0; i <= this.contextParams.length; i++)
        //~ p[this.contextParams[i]] = this.contextValues[i];
    //~ }
    return p;
  },
  setContextValue : function(name,value) {
    //~ console.log('setContextValue',this,this.name,':',name,'=',value);
    //~ if (this.contextValues === undefined) {
        //~ this.contextValues = Array(); // this.contextParams.length);
    //~ }
    if (this.contextParams[name] != value) {
      //~ console.log('setContextValue 1',this.contextParams);
      this.contextParams[name] = value;
      this.lastQuery = null;
      //~ console.log('setContextValue 2',this.contextParams);
    }
  }
});

Lino.ChoicesFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'local'
});


Lino.SimpleRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  forceSelection: true,
  constructor: function(config){
      Lino.SimpleRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value' ], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.ComplexRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  constructor: function(config){
      Lino.ComplexRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value','text'], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.RemoteComboFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'remote',
  //~ forceSelection:false,
  minChars: 2, // default 4 is too much
  queryDelay: 300, // default 500 is maybe slow
  queryParam: 'query', 
  //~ typeAhead: true,
  //~ selectOnFocus: true, // select any existing text in the field immediately on focus.
  resizable: true
});

/*
Thanks to Animal for posting the basic idea:
http://www.sencha.com/forum/showthread.php?15842-2.0-SOLVED-Combobox-twintrigger-clear&p=76130&viewfull=1#post76130

*/
Lino.TwinCombo = Ext.extend(Lino.RemoteComboFieldElement,{
    trigger2Class : 'x-form-search-trigger',
    //~ trigger2Class : 'x-tbar-detail',
    initComponent : function() {
        //~ Lino.TwinCombo.superclass.initComponent.call(this);
        Lino.ComboBox.prototype.initComponent.call(this);
        Ext.form.TwinTriggerField.prototype.initComponent.call(this);
    },
    onTrigger2Click : function() {
        //~ console.log('onTrigger2Click',this,arguments);
    }
  });
//~ Lino.TwinCombo.prototype.initComponent = Ext.form.TwinTriggerField.prototype.initComponent;
Lino.TwinCombo.prototype.getTrigger = Ext.form.TwinTriggerField.prototype.getTrigger;
Lino.TwinCombo.prototype.getOuterSize = Ext.form.TwinTriggerField.prototype.getOuterSize;
Lino.TwinCombo.prototype.initTrigger = Ext.form.TwinTriggerField.prototype.initTrigger;
Lino.TwinCombo.prototype.onTrigger1Click = Ext.form.ComboBox.prototype.onTriggerClick;
//~ Lino.TwinCombo.prototype.onTrigger2Click = function() {
    //~ console.log('onTrigger2Click',arguments);
//~ };



Lino.SimpleRemoteComboFieldElement = Ext.extend(Lino.RemoteComboFieldElement,{
  displayField: 'value', 
  valueField: null,
  forceSelection: false
});




Lino.Window = Ext.extend(Ext.Window,{
  //~ layout: "fit", 
  closeAction : 'hide',
  renderTo: 'main_area', 
  constrain: true,
  maximized: true,
  draggable: false,
  width: 700,
  height: 500,
  maximizable: false,
  constructor : function (config) {
    if (config.main_item.params_panel) {
        config.layout = 'border';
        config.main_item.region = 'center';
        config.main_item.params_panel.region = 'north';
        config.main_item.params_panel.hidden = config.main_item.params_panel_hidden;
        config.items = [config.main_item.params_panel, config.main_item];
    } else {
        config.layout = 'fit';
        config.items = config.main_item;
    }
    this.main_item = config.main_item; 
    
    delete config.main_item;
    //~ delete config.params_item;
    
    //~ this.main_item = config.items.get(0);
    this.main_item.containing_window = this;
    
    //~ console.log('20120110 Lino.Window.constructor() 1');
    //~ if (Lino.current_window) { // all windows except the top are closable
    if (this.main_item.hide_window_title) { 
      config.closable = false;
      config.frame = false;
      config.shadow = false;
      //~ config.border = true;
      //~ config.title = undefined;
      //~ config.tools = null;
      delete config.title;
      delete config.tools;
    } else {
      config.title = this.main_item.empty_title;
      config.closable = true;
      config.tools = [ 
        { qtip: 'permalink', handler: Lino.permalink_handler(this), id: "pin" }
      ];
      if (this.main_item.content_type && this.main_item.action_name != 'insert') {
        config.tools = [ {
          handler: Lino.help_text_editor,
          qtip: "Edit help texts for fields on this model.",
          scope: this.main_item,
          id: "gear"
        }].concat(config.tools);
      }
        
    //~ { qtip: '', handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: this.config.qtip, handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: 'Call doLayout() on main Container.', handler: Lino.refresh_handler(this), id: "refresh" },
    //~ if (this.main_item.params_panel) {
        //~ config.tools = config.tools.concat([ 
          //~ { qtip: 'Show/hide parameter panel', handler: this.toggle_params_panel, id: "gear", scope:this } 
        //~ ]);
    //~ }
    //~ if (config.closable !== false) {
      // if undefined, will take default behaviour
      //~ config.tools = config.tools.concat([ 
        //~ { qtip: 'close', handler: this.hide, id: "close", scope:this } 
      //~ ]);
    }
    
    this.main_item.config_containing_window(config);
    
    //~ console.log('20120110 Lino.Window.constructor() 2');
    Lino.Window.superclass.constructor.call(this,config);
    
    //~ console.log('20120110 Lino.Window.constructor() 3');
    
  },
  initComponent : function() {
    this.main_item.init_containing_window(this);
    Lino.Window.superclass.initComponent.call(this);
  
  },
  hide : function() { 
      this.main_item.do_when_clean(false,function() { 
        Lino.close_window(); });
  },
  hide_really : function() { 
    Lino.Window.superclass.hide.call(this);
  },
  onRender : function(ct, position){
    //~ console.log('20120110 Lino.Window.onRender() 1');
    Lino.Window.superclass.onRender.call(this, ct, position);
    var main_area = Ext.getCmp('main_area')
    //~ console.log('20120110 Lino.Window.onRender() 2');
  
    this.on('show', function(win) {
        //~ console.log('20120110 Lino.Window.on show 1');
        main_area.on('resize', win.onWindowResize, win);
    });
    this.on('hide', function(win) {
        main_area.un('resize', win.onWindowResize, win);
    });
    //~ console.log('20120110 Lino.Window.onRender() 3');
  }
});


Lino.unused_ParamWindow = Ext.extend(Lino.Window,{
  //~ layout: "border", 
  constructor : function (config) {
    Lino.ParamWindow.superclass.constructor.call(this,config);
    this.main_item = config.items; // `items` must be a single component
    config.layout = 'border';
    this.main_item.region = 'center';
    config.params.region = 'north';
    config.items = [config.params, config.items];
    //~ delete config.params;
  }
});




(function(){
    var ns = Ext.ns('Ext.ux.plugins');

    /**
     * @class Ext.ux.plugins.DefaultButton
     * @extends Object
     *
     * Plugin for Button that will click() the button if the user presses ENTER while
     * a component in the button's form has focus.
     *
     * @author Stephen Friedrich
     * @date 09-DEC-2009
     * @version 0.1
     *
     */
    ns.DefaultButton =  Ext.extend(Object, {
        init: function(button) {
            button.on('afterRender', setupKeyListener, button);
        }
    });

    function setupKeyListener() {
        var formPanel = this.findParentByType('form');
        new Ext.KeyMap(formPanel.el, {
            key: Ext.EventObject.ENTER,
            shift: false,
            alt: false,
            fn: function(keyCode, e){
                if(e.target.type === 'textarea' && !e.ctrlKey) {
                    return true;
                }

                this.el.select('button').item(0).dom.click();
                return false;
            },
            scope: this
        });
    }

    Ext.ComponentMgr.registerPlugin('defaultButton', ns.DefaultButton);

})(); 

Ext.override(Ext.form.BasicForm,{
    my_loadRecord : function(values){
    //~ loadRecord : function(record){
        /* Same as ExtJS's loadRecord() (setValues()), except that we 
        forward also the record to field.setValue() so that Lino.Combobox 
        can use it. 
        */
        //~ console.log('20120918 my_loadRecord',values)
        if(Ext.isArray(values)){ 
            for(var i = 0, len = values.length; i < len; i++){
                var v = values[i];
                var f = this.findField(v.id);
                if(f){
                    f.setValue(v.value,values);
                    if(this.trackResetOnLoad){
                        f.originalValue = f.getValue();
                    }
                }
            }
        }else{ 
            var field, id;
            for(id in values){
                if(!Ext.isFunction(values[id]) && (field = this.findField(id))){
                    field.setValue(values[id],values);
                    if(this.trackResetOnLoad){
                        field.originalValue = field.getValue();
                        //~ if (field.hiddenField) {
                          //~ field.hiddenField.originalValue = field.hiddenField.value;
                        //~ }
                    }
                }
            }
        }
        return this;
    }
});




function initializeFooBarDropZone(cmp) {
    //~ console.log('initializeFooBarDropZone',cmp);
    cmp.dropTarget = new Ext.dd.DropTarget(cmp.bwrap, {
      //~ ddGroup     : 'gridDDGroup',
      notifyEnter : function(ddSource, e, data) {
        console.log('notifyEnter',ddSource,e,data);
        //Add some flare to invite drop.
        cmp.body.stopFx();
        cmp.body.highlight();
      },
      notifyDrop  : function(ddSource, e, data){
        console.log('notifyDrop',ddSource,e,data);
        // Reference the record (single selection) for readability
        //~ var selectedRecord = ddSource.dragData.selections[0];


        // Load the record into the form
        //~ formPanel.getForm().my_loadRecord(selectedRecord);


        // Delete record from the grid.  not really required.
        //~ ddSource.grid.store.remove(selectedRecord);

        return(true);
      }
    })
}



Lino.show_mti_child = function(fieldname,detail_handler) {
  //~ console.log('show_mti_child',this);
  //~ console.log('show_mti_child',panel.find("main_area"));
  rec = Lino.current_window.main_item.get_current_record();
  //~ rec = panel.get_current_record();
  if (rec) {
    //~ console.log('show_mti_child',Lino.current_window,rec);
    if (rec.phantom) {
      Lino.notify('Not allowed on phantom record.');
    }else if (rec.data[fieldname]) {
      //~ console.log('show_mti_child',rec.id);
      //~ detail_handler(Lino.current_window.main_item,{},{record_id:rec.id});
      detail_handler.run(null,{record_id:rec.id});
      //~ window.open(urlroot + '/' + rec.id);
      //~ document.location = urlroot + '/' + rec.id;
      //~ window.open(urlroot + '/' + rec.id,'_blank');
    } else {
      Lino.alert("Cannot show MTI child if checkbox is off.");
    }
  } else {
    Lino.notify('No current record.');
  }
};



Lino.davlink_open = function(webdavURL) {
  /* Calls lino.applets.davlink.DavLink.open()
  */
  //~ console.log('Going to call document.applets.DavLink.open(',webdavURL,')');
  var rv = document.applets.DavLink.open(webdavURL);
  if (rv) window.alert(rv);
}






/*
Mappings towards lino.modlib.cal.models.PanelCalendars
*/
// Sset SS = Ssite.modules.cal.PanelCalendars.get_handle(Sui).store
Ext.ensible.cal.CalendarMappings = {
    CalendarId:   {name:'ID',       mapping: 'id', type: 'int'},
    Title:        {name:'CalTitle', mapping: 'babel_name', type: 'string'},
    Description:  {name:'Desc',     mapping: 'description', type: 'string'},
    ColorId:      {name:'Color',    mapping: 'color', type: 'int'},
    IsHidden:     {name:'Hidden',   mapping: 'is_hidden', type: 'boolean'},    
};
Ext.ensible.cal.CalendarRecord.reconfigure();  


/*
Mappings towards lino.modlib.cal.models.PanelEvents 
*/
// Sset SS = Ssite.modules.cal.PanelEvents.get_handle(Sui).store
Ext.ensible.cal.EventMappings = {
    EventId:     {name: 'ID',        mapping: 'id', type:'int'},
    CalendarId:  {name: 'CalID',     mapping: 'calendarHidden', type: 'int'},
    Title:       {name: 'EvtTitle',  mapping: 'summary'},
    StartDate:   {name: 'StartDt',   mapping: 'start_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s" },
    EndDate:     {name: 'EndDt',     mapping: 'end_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s"},
    RRule:       {name: 'RecurRule', mapping: 'rsetHidden'},
    Location:    {name: 'Location',  mapping: 'placeHidden'},
    Notes:       {name: 'Desc',      mapping: 'description'},
    Url:         {name: 'LinkUrl',   mapping: 'url'},
    IsAllDay:    {name: 'AllDay',    mapping: 'all_day', type: 'boolean'},
    Reminder:    {name: 'Reminder',  mapping: 'reminder'}
    
};
Ext.ensible.cal.EventRecord.reconfigure();


Lino.on_eventclick = function(cp,rec,el) {
  //~ console.log("Lino.on_eventclick",arguments);
  //~ Lino.cal.Events.detail_action.run({record_id:rec.data.ID});
  Lino.cal.PanelEvents.detail.run(null,{record_id:rec.data.ID,base_params:Lino.eventStore.baseParams});
  return false;
}
    
Lino.on_editdetails = function(cp,rec,el) {
  //~ console.log("Lino.on_editdetails",arguments);
  if (rec.data.ID)
      //~ Lino.cal.Events.detail_action.run({record_id:rec.data.ID});
      Lino.cal.PanelEvents.detail.run(null,{record_id:rec.data.ID,base_params:Lino.eventStore.baseParams});
  return false;
}

Lino.format_time = function(dt) {
    return dt.getHours() + ':' + dt.getMinutes();
}
    
Lino.on_eventdelete = function() {
  //~ console.log("Lino.on_eventdelete",arguments);
};

Lino.on_eventadd  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventadd ",arguments);
  return false;
}
    
Lino.on_eventresize  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventresize ",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    
Lino.on_eventupdate  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventupdate",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    

//~ Lino.eventStore = new Ext.ensible.cal.EventStore({ 
//~ Lino.eventStore = new Ext.data.ArrayStore({ 
Lino.eventStore = new Ext.data.JsonStore({ 
  listeners: { exception: Lino.on_store_exception }
  ,url: '/restful/cal/PanelEvents'
  ,restful : true
  ,proxy: new Ext.data.HttpProxy({ 
      url: '/restful/cal/PanelEvents', 
      disableCaching: false // no need for cache busting when loading via Ajax
      //~ disableCaching:true,
  })
  ,fields: Ext.ensible.cal.EventRecord.prototype.fields.getRange()
  ,totalProperty: "count"
  ,root: "rows"
  ,idProperty: Ext.ensible.cal.EventMappings.EventId.mapping
  ,writer : new Ext.data.JsonWriter({
    writeAllFields: false
  })
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
      if (!options) options = {};
      if (!options.params) options.params = {};
      //~ options.params.$ext_requests.URL_PARAM_TEAM_VIEW = Lino.calendar_app.team_view_button.pressed;
      
      var view = this.cal_panel.getActiveView();
      var bounds = view.getViewBounds();
      //~ var p = {sd:'05.02.2012',ed:'11.02.2012'};
      //~ var p = {};
      options.params[view.dateParamStart] = bounds.start.format(view.dateParamFormat);
      options.params[view.dateParamEnd] = bounds.end.format(view.dateParamFormat);
      Lino.insert_subst_user(options.params);
      //~ Ext.apply(options.params,p)
      //~ console.log('20120710 eventStore.load()',this.baseParams,options);
    
    return Ext.data.JsonStore.prototype.load.call(this,options);
  }
});

//~ Lino.calendarStore = new Ext.data.ArrayStore({ 
Lino.calendarStore = new Ext.data.JsonStore({ 
      listeners: { exception: Lino.on_store_exception }
      ,restful : true
      ,proxy: new Ext.data.HttpProxy({ 
          url: '/restful/cal/PanelCalendars?fmt=json', 
          disableCaching: false // no need for cache busting when loading via Ajax
          //~ restful : true
          //~ method: "GET"
      })
      //~ ,autoLoad: true
      //~ ,remoteSort: true
      //~ ,baseParams: bp
      ,totalProperty: "count"
      ,root: "rows"
      ,fields: Ext.ensible.cal.CalendarRecord.prototype.fields.getRange()
      ,idProperty: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
      //~ ,idIndex: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
    });


Lino.CalendarCfg = {
    dateParamFormat: 'd.m.Y',
    dateParamStart:'sd',
    dateParamEnd:'ed'
};
//~ 20120704 Lino.CalendarPanel = Ext.extend(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
//~ Lino.CalendarPanel = Ext.extend(Lino.CalendarPanel,{
Ext.override(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
Ext.override(Ext.ensible.cal.CalendarPanel,{
  //~ empty_title : "\$ui.get_actor('cal.Panel').report.label",
  empty_title : "Calendar"
  ,activeItem: 1 // 0: day, 1: week
  ,ls_url: '/cal/CalendarPanel'
  //~ ,disableCaching:true
  ,eventStore: Lino.eventStore
  ,calendarStore: Lino.calendarStore
  ,listeners: { 
    editdetails: Lino.on_editdetails
    ,eventclick: Lino.on_eventclick
    //~ ,eventadd: Lino.on_eventadd
    //~ ,eventdelete: Lino.on_eventdelete
    //~ ,eventresize: Lino.on_eventresize
    ,afterrender : function(config) {
      //~ console.log("20120704 afterrender");
      Lino.calendarStore.load();
      //~ console.log("20120704 afterrender calls eventStore.load()",p);
      Lino.eventStore.cal_panel = this;
      //~ Lino.eventStore.load({params:p});
      Lino.eventStore.load();
      //~ Lino.CalendarPanel.superclass.constructor.call(this, config);
      //~ console.log(20120118, config,this);
    }
    }
  ,enableEditDetails: false
  //~ ,monthViewCfg: Lino.CalendarCfg
  //~ ,weekViewCfg: Lino.CalendarCfg
  //~ ,multiDayViewCfg: Lino.CalendarCfg
  //~ ,multiWeekViewCfg: Lino.CalendarCfg
  //~ ,dayViewCfg: Lino.CalendarCfg
  //~ ,initComponent : function() {
    //~ // this.on('eventadd',Lino.on_eventadd);
    //~ Lino.CalendarPanel.superclass.initComponent.call(this);
  //~ }
});




Lino.CalendarAppPanel = Ext.extend(Ext.Panel,Lino.MainPanel);
Lino.CalendarAppPanel = Ext.extend(Lino.CalendarAppPanel,{
  //~ empty_title : "\$ui.get_actor('cal.Panel').report.label",
  empty_title : "Calendar"
  ,ls_url: '/cal/CalendarPanel'
  ,set_status : function(status) { this.refresh();}
  ,refresh : function() {Lino.eventStore.reload();}
  ,layout: 'fit'
  ,unused_is_loading : function() { 
      var loading = Lino.calendarStore.getCount() == 0 | Lino.eventStore.getCount() == 0
      //~ console.log("CalendarPanel loading:",loading);
      return loading; 
  }
  ,get_base_params : function() {
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
  }
  ,set_base_params : function(p) {
    this.base_params = Ext.apply({},p);
  }
  ,clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  }
  ,set_base_param : function(k,v) {
      if (!this.base_params) this.base_params = {};
      this.base_params[k] = v;
  }
});

Lino.calendar_app = function() { return {
  get_main_panel : function() {
      return new Lino.CalendarAppPanel({ items : 
        //~ [{
          //~ id: 'app-header',
          //~ region: 'north',
          //~ height: 35,
          //~ border: false,
          // contentEl: 'app-header-content'
        //~ },
      {
          id: 'app-center',
          title: '...', // will be updated to the current view's date range
          region: 'center',
          layout: 'border',
          listeners: {
              'afterrender': function(){
                  Ext.getCmp('app-center').header.addClass('app-center-header');
              }
          },
          items: [{
              id:'app-west',
              region: 'west',
              width: 176,
              border: false,
              items: [{
                  xtype: 'datepicker',
                  id: 'app-nav-picker',
                  cls: 'ext-cal-nav-picker',
                  listeners: {
                      'select': {
                          fn: function(dp, dt){
                              Lino.calendarPanel.setStartDate(dt);
                          },
                          scope: this
                      }
                  }
              //~ },{ 
                //~ layout:'fit',
                //~ items: [
                  //~ new Ext.form.Checkbox({
                    //~ boxLabel:"$_('Team view')",
                    //~ hideLabel:true
                    //~ listeners: { click: }
                  //~ })
                //~ ]
              },{ 
                layout:'form',
                items: [
                  this.team_view_button = new Ext.Button({
                    text:"Team view",
                    enableToggle:true,
                    pressed:false,
                    toggleHandler: function(btn,state) { 
                      //~ console.log('20120716 teamView.toggle()');
                      Lino.eventStore.setBaseParam('tv',state);
                      Lino.eventStore.load();
                      //~ Lino.eventStore.load({params:{$ext_requests.URL_PARAM_TEAM_VIEW:state}});
                      //~ console.log("team view",state);
                    }
                  })
                ]
              },{
                  xtype: 'extensible.calendarlist',
                  store: Lino.calendarStore,
                  border: false,
                  width: 175
              }]
          },{
              xtype: 'extensible.calendarpanel',
              eventStore: Lino.eventStore,
              calendarStore: Lino.calendarStore,
              border: false,
              id:'app-calendar',
              region: 'center',
              //~ activeItem: 3, // month view
              
              // Any generic view options that should be applied to all sub views:
              viewConfig: {
                  // Lino.CalendarCfg
                  dateParamFormat: 'd.m.Y',
                  dateParamStart:'sd',
                  dateParamEnd:'ed',
                
                  //enableFx: false,
                  //ddIncrement: 10, //only applies to DayView and subclasses, but convenient to put it here
                  viewStartHour: 8,
                  viewEndHour: 18
                  //minEventDisplayMinutes: 15
              },
              
              // View options specific to a certain view (if the same options exist in viewConfig
              // they will be overridden by the view-specific config):
              monthViewCfg: {
                  showHeader: true,
                  showWeekLinks: true,
                  showWeekNumbers: true,
                  eventBodyMarkup: ['{Title}',
                    //~ '<tpl if="url">',
                        //~ '<a href="{url}">XX</a>',
                    //~ '</tpl>',
                    '<tpl if="_isReminder">',
                        '<i class="ext-cal-ic ext-cal-ic-rem">&#160;</i>',
                    '</tpl>',
                    '<tpl if="_isRecurring">',
                        '<i class="ext-cal-ic ext-cal-ic-rcr">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanLeft">',
                        '<i class="ext-cal-spl">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanRight">',
                        '<i class="ext-cal-spr">&#160;</i>',
                    '</tpl>'
                ].join('')
              },
              
              multiWeekViewCfg: {
                  //weekCount: 3
              },
              
              // Some optional CalendarPanel configs to experiment with:
              //readOnly: true,
              //showDayView: false,
              //showMultiDayView: true,
              //showWeekView: false,
              //showMultiWeekView: false,
              //showMonthView: false,
              //showNavBar: false,
              //showTodayText: false,
              //showTime: false,
              //editModal: true,
              //enableEditDetails: false,
              //title: 'My Calendar', // the header of the calendar, could be a subtitle for the app
              
              // Once this component inits it will set a reference to itself as an application
              // member property for easy reference in other functions within App.
              initComponent: function() {
                  Lino.calendarPanel = this;
                  this.constructor.prototype.initComponent.apply(this, arguments);
              },
              
              listeners: {
                  //~ 'eventclick': {
                      //~ fn: function(vw, rec, el){
                          //~ this.clearMsg();
                      //~ },
                      //~ scope: this
                  //~ },
                  'eventover': function(vw, rec, el){
                      //console.log('Entered evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]', view='+ vw.id +', el='+el.id);
                  },
                  'eventout': function(vw, rec, el){
                      //console.log('Leaving evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]+', view='+ vw.id +', el='+el.id);
                  },
                  'eventadd': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was added');
                      },
                      scope: this
                  },
                  'eventupdate': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(cp, rec){
                          //this.eventStore.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'eventcancel': {
                      fn: function(cp, rec){
                          // edit canceled
                      },
                      scope: this
                  },
                  'viewchange': {
                      fn: function(p, vw, dateInfo){
                          if(this.editWin){
                              this.editWin.hide();
                          };
                          if(dateInfo !== null){
                              // will be null when switching to the event edit form so ignore
                              Ext.getCmp('app-nav-picker').setValue(dateInfo.activeDate);
                              this.updateTitle(dateInfo.viewStart, dateInfo.viewEnd);
                          }
                      },
                      scope: this
                  },
                  'dayclick': {
                      fn: function(vw, dt, ad, el){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'rangeselect': {
                      fn: function(vw, dates, onComplete){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'eventmove': {
                      fn: function(vw, rec){
                          rec.commit();
                          var time = rec.data[Ext.ensible.cal.EventMappings.IsAllDay.name] ? '' : ' \\a\\t g:i a';
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was moved to '+
                              rec.data[Ext.ensible.cal.EventMappings.StartDate.name].format('F jS'+time));
                      },
                      scope: this
                  },
                  'eventresize': {
                      fn: function(vw, rec){
                          rec.commit();
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(win, rec){
                          Lino.eventStore.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'initdrag': {
                      fn: function(vw){
                          if(this.editWin && this.editWin.isVisible()){
                              this.editWin.hide();
                          }
                      },
                      scope: this
                  }
              }
          }]
        }
        //~ ]
        
      });
      
  }
  ,updateTitle: function(startDt, endDt){
      var p = Ext.getCmp('app-center');
      
      if(startDt.clearTime().getTime() == endDt.clearTime().getTime()){
          p.setTitle(startDt.format('F j, Y'));
      }
      else if(startDt.getFullYear() == endDt.getFullYear()){
          if(startDt.getMonth() == endDt.getMonth()){
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('j, Y'));
          }
          else{
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('F j, Y'));
          }
      }
      else{
          p.setTitle(startDt.format('F j, Y') + ' - ' + endDt.format('F j, Y'));
      }
  }
  // This is an application-specific way to communicate CalendarPanel event messages back to the user.
  // This could be replaced with a function to do "toast" style messages, growl messages, etc. This will
  // vary based on application requirements, which is why it's not baked into the CalendarPanel.
  ,showMsg: function(msg){
      Lino.notify(msg);
      //~ Ext.fly('app-msg').update(msg).removeClass('x-hidden');
  }
  
  ,clearMsg: function(){
      Lino.notify('');
      //~ Ext.fly('app-msg').update('').addClass('x-hidden');
  }
}
}();




/*
captureEvents utility by Aaron Conran
<http://www.sencha.com/learn/grid-faq/>

Ext.onReady(function(){
    var grid = new Ext.grid.GridPanel({
        ... 
    });
    captureEvents(grid);
});
*/
function captureEvents(observable) {
    Ext.util.Observable.capture(
        observable,
        function(eventName) {
            console.info(eventName);
        },
        this
    );		
}
 




var cardReader = new be.belgium.eid.CardReader();

function noCardPresentHandler() {
  window.alert("No card present!");
}
cardReader.setNoCardPresentHandler(noCardPresentHandler);

function noReaderDetectedHandler() {
  window.alert("No reader detected!");
}
cardReader.setNoReaderDetectedHandler(noReaderDetectedHandler);

function appletNotFoundHandler() {
  window.alert("Applet not found!");
}
cardReader.setAppletNotFoundHandler(appletNotFoundHandler);

function appletExceptionHandler(e) {
  window.alert("Error reading card!\r\nException: " + e + "\r\nPlease try again.");
}
cardReader.setAppletExceptionHandler(appletExceptionHandler);

//~ function clearPicture() {
  //~ document.getElementById("encoded_picture").src = "data:image/jpeg;base64,";
//~ }

Lino.beid_read_card_processor = function() {
    var card = cardReader.read();
    if (!card) {
        //~ Lino.alert("No card returned.");
        return null;
    } 
    return {
      cardNumber: card.cardNumber,
      validityBeginDate:card.validityBeginDate.format("d.m.Y"),
      validityEndDate: card.validityEndDate.format("d.m.Y"),
      chipNumber:card.chipNumber,
      issuingMunicipality:card.issuingMunicipality,
      nationalNumber:card.nationalNumber,
      surname:card.surname,
      firstName1:card.firstName1,
      firstName2:card.firstName2,
      firstName3:card.firstName3,
      nationality:card.nationality,
      birthLocation:card.birthLocation,
      birthDate: card.birthDate.format("d.m.Y"),
      sex:card.sex,
      nobleCondition:card.nobleCondition,
      documentType:card.documentType,
      specialStatus:card.specialStatus,
      whiteCane:card.whiteCane,
      yellowCane:card.yellowCane,
      extendedMinority:card.extendedMinority,
      street:card.street,
      streetNumber:card.streetNumber,
      boxNumber:card.boxNumber,
      zipCode:card.zipCode,
      municipality:card.municipality,
      country:card.country
      //~ comment the following line out to test whether the picture takes a lot of time
      //~ test 20121214 on my machine revealed no perceivable gain
      ,picture:base64.encode(card.getPicture())
    };
}





Lino.main_menu = [ { "menu": { "items": [ { "text": "Persons", "handler": function() {Lino.contacts.Persons.grid.run(null)} }, { "text": "Companies", "handler": function() {Lino.contacts.Companies.grid.run(null)} }, { "text": "Partners", "handler": function() {Lino.contacts.Partners.grid.run(null)} }, { "text": "Households", "handler": function() {Lino.households.Households.grid.run(null)} }, { "text": "Schools", "handler": function() {Lino.homeworkschool.Schools.grid.run(null)} }, { "text": "Teachers", "handler": function() {Lino.courses.Teachers.grid.run(null)} }, { "text": "Pupils", "handler": function() {Lino.courses.Pupils.grid.run(null)} } ] }, "text": "Contacts" }, { "menu": { "items": [ { "text": "My notes", "handler": function() {Lino.notes.MyNotes.grid.run(null)} }, { "text": "My Outbox", "handler": function() {Lino.outbox.MyOutbox.grid.run(null)} } ] }, "text": "Office" }, { "menu": { "items": [ { "text": "Calendar", "iconCls": "x-tbar-calendar", "handler": function() {Lino.cal.CalendarPanel.grid.run(null)} }, { "text": "Events", "listeners": { "render": Lino.quicktip_renderer("Foo","Table of all my calendar events.") }, "handler": function() {Lino.cal.MyEvents.grid.run(null)} }, "-", { "text": "My Tasks", "listeners": { "render": Lino.quicktip_renderer("Foo","Table of all my tasks.") }, "handler": function() {Lino.cal.MyTasks.grid.run(null)} }, { "text": "To-do list", "listeners": { "render": Lino.quicktip_renderer("Foo","Table of my tasks marked 'to do'.") }, "handler": function() {Lino.cal.MyTasksToDo.grid.run(null)} }, "-", { "text": "My presences", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows all my presences in calendar events, independently of their state.") }, "handler": function() {Lino.cal.MyPresences.grid.run(null)} }, { "text": "My received invitations", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows received invitations which I must accept or reject.") }, "handler": function() {Lino.cal.MyPendingInvitations.grid.run(null)} } ] }, "text": "Calendar" }, { "menu": { "items": [ { "text": "Invoiceable partners", "listeners": { "render": Lino.quicktip_renderer("Foo","Table of all partners who have at least one invoiceable item.") }, "handler": function() {Lino.sales.InvoiceablePartners.grid.run(null)} } ] }, "text": "Sales" }, { "menu": { "items": [ { "text": "Products", "handler": function() {Lino.products.Products.grid.run(null)} }, { "text": "Product Categories", "handler": function() {Lino.products.ProductCats.grid.run(null)} } ] }, "text": "Products" }, { "menu": { "items": [ { "text": "Courses", "handler": function() {Lino.courses.Courses.grid.run(null)} }, { "text": "Pending requested enrolments", "handler": function() {Lino.courses.PendingRequestedEnrolments.grid.run(null)} }, { "text": "Pending confirmed enrolments", "handler": function() {Lino.courses.PendingConfirmedEnrolments.grid.run(null)} } ] }, "text": "School" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "My Text Field Templates", "handler": function() {Lino.system.MyTextFieldTemplates.grid.run(null)} }, { "text": "Note Types", "handler": function() {Lino.notes.NoteTypes.grid.run(null)} }, { "text": "Event Types", "handler": function() {Lino.notes.EventTypes.grid.run(null)} }, { "text": "Upload Types", "handler": function() {Lino.uploads.UploadTypes.grid.run(null)} }, { "text": "Nodes", "handler": function() {Lino.pages.Pages.grid.run(null)} } ] }, "text": "Office" }, { "menu": { "items": [ { "text": "Site Parameters", "iconCls": "x-tbar-detail", "handler": function() {Lino.system.SiteConfigs.detail.run(null,{ "record_id": 1 })} }, { "text": "Users", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    Shows the list of all users on this site.\n    \n    A User is somebody who can log into the application.\n    \n    ") }, "handler": function() {Lino.users.Users.grid.run(null)} }, { "text": "Teams", "handler": function() {Lino.users.Teams.grid.run(null)} }, { "text": "content types", "handler": function() {Lino.system.ContentTypes.grid.run(null)} }, { "text": "Help Texts", "handler": function() {Lino.system.HelpTexts.grid.run(null)} } ] }, "text": "System" }, { "menu": { "items": [ { "text": "Countries", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    A country is a geographic entity considered a \"nation\".\n    ") }, "handler": function() {Lino.countries.Countries.grid.run(null)} }, { "text": "Places", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    The table of known geographical places.\n    A geographical place can be a city, a town, a suburb, \n    a province, a lake... any named geographic entity,\n    except for countries because these have their own table.\n    ") }, "handler": function() {Lino.countries.Cities.grid.run(null)} }, { "text": "Languages", "handler": function() {Lino.countries.Languages.grid.run(null)} }, { "text": "company types", "handler": function() {Lino.contacts.CompanyTypes.grid.run(null)} }, { "text": "Functions", "handler": function() {Lino.contacts.RoleTypes.grid.run(null)} } ] }, "text": "Contacts" }, { "menu": { "items": [ { "text": "Household Roles", "handler": function() {Lino.households.Roles.grid.run(null)} }, { "text": "Household Types", "handler": function() {Lino.households.Types.grid.run(null)} } ] }, "text": "Households" }, { "menu": { "items": [ { "text": "Rooms", "listeners": { "render": Lino.quicktip_renderer("Foo","List of rooms where calendar events can happen.") }, "handler": function() {Lino.cal.Rooms.grid.run(null)} }, { "text": "Priorities", "listeners": { "render": Lino.quicktip_renderer("Foo","List of possible priorities of calendar events.") }, "handler": function() {Lino.cal.Priorities.grid.run(null)} }, { "text": "Guest Roles", "listeners": { "render": Lino.quicktip_renderer("Foo","The role of a guest expresses what the \n    partner is going to do there.") }, "handler": function() {Lino.cal.GuestRoles.grid.run(null)} }, { "text": "Calendars", "listeners": { "render": Lino.quicktip_renderer("Foo","The list of calendars defined on this system.\n    A calendar is a list of events which have certain things in common,\n    especially they are displayed in the same colour in the calendar panel") }, "handler": function() {Lino.cal.Calendars.grid.run(null)} } ] }, "text": "Calendar" }, { "menu": { "items": [ { "text": "Account Charts", "handler": function() {Lino.accounts.Charts.grid.run(null)} }, { "text": "Account Groups", "handler": function() {Lino.accounts.Groups.grid.run(null)} }, { "text": "Accounts", "handler": function() {Lino.accounts.Accounts.grid.run(null)} }, { "text": "Journals", "handler": function() {Lino.ledger.Journals.grid.run(null)} } ] }, "text": "Accounting" }, { "menu": { "items": [ { "text": "Invoicing Modes", "handler": function() {Lino.sales.InvoicingModes.grid.run(null)} }, { "text": "Shipping Modes", "handler": function() {Lino.sales.ShippingModes.grid.run(null)} }, { "text": "Payment Terms", "handler": function() {Lino.sales.PaymentTerms.grid.run(null)} } ] }, "text": "Sales" }, { "menu": { "items": [ { "text": "Teacher types", "handler": function() {Lino.courses.TeacherTypes.grid.run(null)} }, { "text": "Pupil types", "handler": function() {Lino.courses.PupilTypes.grid.run(null)} }, { "text": "Topics", "handler": function() {Lino.courses.Topics.grid.run(null)} }, { "text": "Course Lines", "handler": function() {Lino.courses.Lines.grid.run(null)} }, { "text": "Timetable Slots", "handler": function() {Lino.courses.Slots.grid.run(null)} } ] }, "text": "School" } ] }, "text": "Configure" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "Text Field Templates", "handler": function() {Lino.system.TextFieldTemplates.grid.run(null)} }, { "text": "Uploads", "handler": function() {Lino.uploads.Uploads.grid.run(null)} }, { "text": "Outgoing Mails", "handler": function() {Lino.outbox.Mails.grid.run(null)} }, { "text": "Attachments", "handler": function() {Lino.outbox.Attachments.grid.run(null)} } ] }, "text": "Office" }, { "menu": { "items": [ { "text": "Authorities", "handler": function() {Lino.users.Authorities.grid.run(null)} }, { "text": "User Groups", "handler": function() {Lino.lino.UserGroups.grid.run(null)} }, { "text": "User Levels", "handler": function() {Lino.lino.UserLevels.grid.run(null)} }, { "text": "User Profiles", "handler": function() {Lino.lino.UserProfiles.grid.run(null)} } ] }, "text": "System" }, { "menu": { "items": [ { "text": "Contact Persons", "handler": function() {Lino.contacts.Roles.grid.run(null)} } ] }, "text": "Contacts" }, { "menu": { "items": [ { "text": "Household Members", "handler": function() {Lino.households.Members.grid.run(null)} } ] }, "text": "Households" }, { "text": "Events/Notes", "handler": function() {Lino.notes.Notes.grid.run(null)} }, { "menu": { "items": [ { "text": "Tasks", "listeners": { "render": Lino.quicktip_renderer("Foo","A calendar task is something you need to do.\n    ") }, "handler": function() {Lino.cal.Tasks.grid.run(null)} }, { "text": "Guests", "listeners": { "render": Lino.quicktip_renderer("Foo","A guest is a partner invited to an event.\n    ") }, "handler": function() {Lino.cal.Guests.grid.run(null)} }, { "text": "Subscriptions", "handler": function() {Lino.cal.Subscriptions.grid.run(null)} }, { "text": "States", "listeners": { "render": Lino.quicktip_renderer("Foo","List of the possible states of a calendar event.") }, "handler": function() {Lino.cal.EventStates.grid.run(null)} }, { "text": "States", "handler": function() {Lino.cal.GuestStates.grid.run(null)} }, { "text": "States", "handler": function() {Lino.cal.TaskStates.grid.run(null)} } ] }, "text": "Calendar" }, { "menu": { "items": [ { "text": "Invoices", "handler": function() {Lino.ledger.Invoices.grid.run(null)} }, { "text": "Vouchers", "handler": function() {Lino.ledger.Vouchers.grid.run(null)} }, { "text": "VoucherTypes", "handler": function() {Lino.ledger.VoucherTypes.grid.run(null)} }, { "text": "Movements", "handler": function() {Lino.ledger.Movements.grid.run(null)} }, { "text": "Fiscal Years", "handler": function() {Lino.ledger.FiscalYears.grid.run(null)} } ] }, "text": "Accounting" }, { "menu": { "items": [ { "text": "VatRegimes", "handler": function() {Lino.vat.VatRegimes.grid.run(null)} }, { "text": "TradeTypes", "handler": function() {Lino.vat.TradeTypes.grid.run(null)} }, { "text": "VatClasses", "handler": function() {Lino.vat.VatClasses.grid.run(null)} } ] }, "text": "VAT" }, { "menu": { "items": [ { "text": "Enrolments", "handler": function() {Lino.courses.Enrolments.grid.run(null)} } ] }, "text": "School" } ] }, "text": "Explorer" }, { "menu": { "items": [ { "text": "About", "listeners": { "render": Lino.quicktip_renderer("Foo","Show information about this site.") }, "handler": function() {Lino.about.About.show.run(null,{ "record_id": -99998 })} } ] }, "text": "Site" }, { "text": "Home", "handler": function() {Lino.close_all_windows()} } ];
Ext.namespace('Lino.system.SiteConfigs')
Ext.namespace('Lino.system.ContentTypes')
Ext.namespace('Lino.system.HelpTexts')
Ext.namespace('Lino.system.TextFieldTemplates')
Ext.namespace('Lino.users.Users')
Ext.namespace('Lino.users.MySettings')
Ext.namespace('Lino.users.UsersOverview')
Ext.namespace('Lino.users.Teams')
Ext.namespace('Lino.users.Memberships')
Ext.namespace('Lino.users.Authorities')
Ext.namespace('Lino.countries.Languages')
Ext.namespace('Lino.countries.Countries')
Ext.namespace('Lino.countries.Cities')
Ext.namespace('Lino.contacts.CompanyTypes')
Ext.namespace('Lino.contacts.Partners')
Ext.namespace('Lino.contacts.Persons')
Ext.namespace('Lino.contacts.Companies')
Ext.namespace('Lino.contacts.RoleTypes')
Ext.namespace('Lino.contacts.Roles')
Ext.namespace('Lino.households.Types')
Ext.namespace('Lino.households.Households')
Ext.namespace('Lino.households.Roles')
Ext.namespace('Lino.households.Members')
Ext.namespace('Lino.outbox.Recipients')
Ext.namespace('Lino.outbox.Mails')
Ext.namespace('Lino.outbox.Attachments')
Ext.namespace('Lino.notes.NoteTypes')
Ext.namespace('Lino.notes.EventTypes')
Ext.namespace('Lino.notes.Notes')
Ext.namespace('Lino.cal.Calendars')
Ext.namespace('Lino.cal.Subscriptions')
Ext.namespace('Lino.cal.Rooms')
Ext.namespace('Lino.cal.Priorities')
Ext.namespace('Lino.cal.Events')
Ext.namespace('Lino.cal.MyEvents')
Ext.namespace('Lino.cal.MyUnclearEvents')
Ext.namespace('Lino.cal.EventsAssignedToMe')
Ext.namespace('Lino.cal.MyEventsToday')
Ext.namespace('Lino.cal.Tasks')
Ext.namespace('Lino.cal.GuestRoles')
Ext.namespace('Lino.cal.Guests')
Ext.namespace('Lino.cal.PanelCalendars')
Ext.namespace('Lino.cal.PanelEvents')
Ext.namespace('Lino.uploads.UploadTypes')
Ext.namespace('Lino.uploads.Uploads')
Ext.namespace('Lino.pages.Pages')
Ext.namespace('Lino.accounts.Charts')
Ext.namespace('Lino.accounts.Groups')
Ext.namespace('Lino.accounts.Accounts')
Ext.namespace('Lino.ledger.Journals')
Ext.namespace('Lino.ledger.Vouchers')
Ext.namespace('Lino.ledger.Movements')
Ext.namespace('Lino.ledger.Invoices')
Ext.namespace('Lino.products.ProductCats')
Ext.namespace('Lino.products.Products')
Ext.namespace('Lino.sales.PaymentTerms')
Ext.namespace('Lino.sales.InvoicingModes')
Ext.namespace('Lino.sales.ShippingModes')
Ext.namespace('Lino.sales.Invoices')
Ext.namespace('Lino.sales.DocumentsToSign')
Ext.namespace('Lino.sales.InvoiceablePartners')
Ext.namespace('Lino.homeworkschool.Schools')
Ext.namespace('Lino.courses.Slots')
Ext.namespace('Lino.courses.Topics')
Ext.namespace('Lino.courses.Lines')
Ext.namespace('Lino.courses.TeacherTypes')
Ext.namespace('Lino.courses.Teachers')
Ext.namespace('Lino.courses.PupilTypes')
Ext.namespace('Lino.courses.Pupils')
Ext.namespace('Lino.courses.Courses')
Ext.namespace('Lino.courses.ActiveCourses')
Ext.namespace('Lino.courses.Enrolments')
Ext.namespace('Lino.courses.PendingRequestedEnrolments')
Ext.namespace('Lino.courses.PendingConfirmedEnrolments')
Ext.namespace('Lino.sales.SalesRuleTable')
Ext.namespace('Lino.sales.ProductDocItemTable')
Ext.namespace('Lino.sales.InvoiceItemTable')
Ext.namespace('Lino.sessions.SessionTable')
Ext.namespace('Lino.ledger.InvoiceItemTable')
Ext.namespace('Lino.system.MyTextFieldTemplates')
Ext.namespace('Lino.users.MembershipsByUser')
Ext.namespace('Lino.users.AuthoritiesGiven')
Ext.namespace('Lino.users.AuthoritiesTaken')
Ext.namespace('Lino.countries.CitiesByCity')
Ext.namespace('Lino.countries.CitiesByCountry')
Ext.namespace('Lino.contacts.PartnersByCity')
Ext.namespace('Lino.contacts.PartnersByCountry')
Ext.namespace('Lino.contacts.RolesByCompany')
Ext.namespace('Lino.contacts.RolesByPerson')
Ext.namespace('Lino.households.HouseholdsByType')
Ext.namespace('Lino.households.MembersByHousehold')
Ext.namespace('Lino.households.MembersByPerson')
Ext.namespace('Lino.households.MembersByRole')
Ext.namespace('Lino.outbox.RecipientsByMail')
Ext.namespace('Lino.outbox.MyOutbox')
Ext.namespace('Lino.outbox.MailsByUser')
Ext.namespace('Lino.outbox.MailsByProject')
Ext.namespace('Lino.outbox.SentByPartner')
Ext.namespace('Lino.outbox.AttachmentsByMail')
Ext.namespace('Lino.notes.MyNotes')
Ext.namespace('Lino.notes.NotesByType')
Ext.namespace('Lino.notes.NotesByEventType')
Ext.namespace('Lino.notes.NotesByProject')
Ext.namespace('Lino.cal.SubscriptionsByCalendar')
Ext.namespace('Lino.cal.SubscriptionsByUser')
Ext.namespace('Lino.cal.EventsByCalendar')
Ext.namespace('Lino.cal.EventsByRoom')
Ext.namespace('Lino.cal.EventsByProject')
Ext.namespace('Lino.cal.TasksByUser')
Ext.namespace('Lino.cal.MyTasks')
Ext.namespace('Lino.cal.MyTasksToDo')
Ext.namespace('Lino.cal.TasksByProject')
Ext.namespace('Lino.cal.GuestsByEvent')
Ext.namespace('Lino.cal.GuestsByRole')
Ext.namespace('Lino.cal.GuestsByPartner')
Ext.namespace('Lino.cal.MyPresences')
Ext.namespace('Lino.cal.MyPendingInvitations')
Ext.namespace('Lino.uploads.MyUploads')
Ext.namespace('Lino.accounts.GroupsByChart')
Ext.namespace('Lino.accounts.AccountsByGroup')
Ext.namespace('Lino.ledger.MovementsByVoucher')
Ext.namespace('Lino.ledger.MovementsByPartner')
Ext.namespace('Lino.ledger.InvoicesByJournal')
Ext.namespace('Lino.ledger.InvoicesByPartner')
Ext.namespace('Lino.ledger.ItemsByInvoice')
Ext.namespace('Lino.products.ProductsByCategory')
Ext.namespace('Lino.sales.InvoiceItemsByProduct')
Ext.namespace('Lino.sales.InvoicesByJournal')
Ext.namespace('Lino.sales.InvoicesByPartner')
Ext.namespace('Lino.sales.ItemsByInvoice')
Ext.namespace('Lino.courses.LinesByTopic')
Ext.namespace('Lino.courses.TeachersByType')
Ext.namespace('Lino.courses.PupilsByType')
Ext.namespace('Lino.courses.EventsByTeacher')
Ext.namespace('Lino.courses.CoursesByTeacher')
Ext.namespace('Lino.courses.CoursesByLine')
Ext.namespace('Lino.courses.CoursesByTopic')
Ext.namespace('Lino.courses.CoursesBySlot')
Ext.namespace('Lino.courses.CoursesByCompany')
Ext.namespace('Lino.courses.EnrolmentsByPupil')
Ext.namespace('Lino.courses.EnrolmentsByCourse')
Ext.namespace('Lino.uploads.UploadsByController')
Ext.namespace('Lino.sales.InvoicingsByInvoiceable')
Ext.namespace('Lino.system.HelpTextsByModel')
Ext.namespace('Lino.cal.TasksByController')
Ext.namespace('Lino.outbox.MailsByController')
Ext.namespace('Lino.outbox.AttachmentsByController')
Ext.namespace('Lino.cal.EventsByController')
Ext.namespace('Lino.about.Models')
Ext.namespace('Lino.about.FieldsByModel')
Ext.namespace('Lino.about.Inspector')
Ext.namespace('Lino.about.SourceFiles')
Ext.namespace('Lino.sales.InvoiceablesByPartner')
Ext.namespace('Lino.lino.Report')
Ext.namespace('Lino.about.About')
Ext.namespace('Lino.system.Home')
Ext.namespace('Lino.cal.CalendarPanel')
Ext.namespace('Lino.lino.Home')
Ext.namespace('Lino.vat.VatClasses')
Ext.namespace('Lino.vat.TradeTypes')
Ext.namespace('Lino.cal.DurationUnits')
Ext.namespace('Lino.cal.TaskStates')
Ext.namespace('Lino.cal.Weekdays')
Ext.namespace('Lino.ledger.InvoiceStates')
Ext.namespace('Lino.accounts.AccountTypes')
Ext.namespace('Lino.lino.UserLevels')
Ext.namespace('Lino.lino.YesNo')
Ext.namespace('Lino.cal.EventStates')
Ext.namespace('Lino.ledger.FiscalYears')
Ext.namespace('Lino.cal.Recurrencies')
Ext.namespace('Lino.courses.EnrolmentStates')
Ext.namespace('Lino.outbox.RecipientType')
Ext.namespace('Lino.cal.GuestStates')
Ext.namespace('Lino.countries.CityTypes')
Ext.namespace('Lino.vat.VatRegimes')
Ext.namespace('Lino.ledger.VoucherTypes')
Ext.namespace('Lino.lino.UserGroups')
Ext.namespace('Lino.cal.AccessClasses')
Ext.namespace('Lino.lino.Genders')
Ext.namespace('Lino.lino.UserProfiles')
Ext.namespace('Lino.sales.InvoiceStates')
Ext.namespace('Lino.courses.CourseStates')

// ChoiceLists: 
Lino.vat.VatClasses = [ [ "0", "Exempt" ], [ "1", "Reduced" ], [ "2", "Normal" ] ];
Lino.vat.TradeTypes = [ [ "S", "Sales" ], [ "P", "Purchases" ] ];
Lino.cal.DurationUnits = [ [ "s", "seconds" ], [ "m", "minutes" ], [ "h", "hours" ], [ "D", "days" ], [ "W", "weeks" ], [ "M", "months" ], [ "Y", "years" ] ];
Lino.cal.TaskStates = [ [ "10", "To do" ], [ "20", "Started" ], [ "30", "Done" ], [ "50", "Cancelled" ] ];
Lino.cal.Weekdays = [ [ "1", "Monday" ], [ "2", "Tuesday" ], [ "3", "Wednesday" ], [ "4", "Thursday" ], [ "5", "Friday" ], [ "6", "Saturday" ], [ "7", "Sunday" ] ];
Lino.ledger.InvoiceStates = [ [ "10", "Draft" ], [ "20", "Registered" ], [ "40", "Paid" ] ];
Lino.accounts.AccountTypes = [ [ "A", "Assets" ], [ "L", "Liabilities" ], [ "I", "Incomes" ], [ "E", "Expenses" ], [ "C", "Capital" ], [ "B", "Bank accounts" ] ];
Lino.lino.UserLevels = [ [ "10", "Guest" ], [ "20", "Secretary" ], [ "30", "User" ], [ "40", "Manager" ], [ "50", "Administrator" ], [ "90", "Expert" ] ];
Lino.lino.YesNo = [ [ "y", "Yes" ], [ "n", "No" ] ];
Lino.cal.EventStates = [ [ "10", "Suggested" ], [ "20", "Draft" ], [ "40", "Scheduled" ], [ "50", "Took place" ], [ "60", "Rescheduled" ], [ "70", "Cancelled" ] ];
Lino.ledger.FiscalYears = [ [ "13", "2013" ], [ "14", "2014" ], [ "15", "2015" ], [ "16", "2016" ], [ "17", "2017" ] ];
Lino.cal.Recurrencies = [ [ "D", "daily" ], [ "W", "weekly" ], [ "M", "monthly" ], [ "Y", "yearly" ], [ "P", "per weekday" ] ];
Lino.courses.EnrolmentStates = [ [ "10", "Requested" ], [ "20", "Confirmed" ], [ "30", "Cancelled" ], [ "40", "Certified" ] ];
Lino.outbox.RecipientType = [ [ "to", "to" ], [ "cc", "cc" ], [ "bcc", "bcc" ] ];
Lino.cal.GuestStates = [ [ "10", "Invited" ], [ "20", "Accepted" ], [ "30", "Rejected" ], [ "40", "Present" ], [ "50", "Absent" ] ];
Lino.countries.CityTypes = [ [ "10", "Member State" ], [ "11", "Division" ], [ "12", "Region" ], [ "13", "Community" ], [ "14", "Territory" ], [ "20", "County" ], [ "21", "Province" ], [ "22", "Shire" ], [ "23", "Subregion" ], [ "24", "Department" ], [ "25", "Arrondissement" ], [ "26", "Prefecture" ], [ "27", "District" ], [ "28", "Sector" ], [ "50", "City" ], [ "51", "Town" ], [ "52", "Municipality" ], [ "54", "Parish" ], [ "55", "Township" ], [ "56", "Quarter" ], [ "61", "Borough" ], [ "62", "Small borough" ], [ "70", "Village" ] ];
Lino.vat.VatRegimes = [ [ "10", "Private person" ], [ "20", "Subject to VAT" ], [ "25", "Co-contractor" ], [ "30", "Intra-community" ], [ "40", "Outside EU" ], [ "50", "Exempt" ] ];
Lino.ledger.VoucherTypes = [ [ "ledger.AccountInvoice", "Invoice (lino.modlib.ledger.models.AccountInvoice)" ], [ "sales.Invoice", "Invoice (lino.modlib.auto.sales.models.Invoice)" ] ];
Lino.lino.UserGroups = [ [ "office", "office (Office)" ], [ "accounting", "accounting (Accounting)" ] ];
Lino.cal.AccessClasses = [ [ "10", "Private" ], [ "20", "Show busy" ], [ "30", "Public" ] ];
Lino.lino.Genders = [ [ "M", "Male" ], [ "F", "Female" ] ];
Lino.lino.UserProfiles = [ [ "000", "000 (Anonymous)" ], [ "100", "100 (User)" ], [ "900", "900 (Administrator)" ] ];
Lino.sales.InvoiceStates = [ [ "10", "Draft" ], [ "20", "Registered" ], [ "30", "Signed" ], [ "40", "Sent" ], [ "50", "Paid" ] ];
Lino.courses.CourseStates = [ [ "10", "Draft" ], [ "20", "Scheduled" ], [ "30", "Started" ], [ "40", "Ended" ], [ "50", "Cancelled" ] ];

Lino.ledger.Invoices.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  layout: "hbox",
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 108,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var pjournal1338 = new Lino.TwinCombo({ "fieldLabel": "Journal", "name": "pjournal", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail)}, "emptyText": "Select a Journal...", "listeners": { "render": Lino.quicktip_renderer("Journal","(ledger.Invoices.pjournal) ") }, "selectOnFocus": true, "hiddenName": "pjournalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/pjournal", "method": "GET" }) }) });
    var pyear1339 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "pyear", "hiddenName": "pyearHidden", "listeners": { "render": Lino.quicktip_renderer("Fiscal Year","(ledger.Invoices.pyear) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var ppartner1340 = new Lino.TwinCombo({ "fieldLabel": "Partner", "name": "ppartner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Select a Partner...", "listeners": { "render": Lino.quicktip_renderer("Partner","(ledger.Invoices.ppartner) ") }, "selectOnFocus": true, "hiddenName": "ppartnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/ppartner", "method": "GET" }) }) });
    this.items = [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pjournal1338, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pyear1339, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ppartner1340, "labelAlign": "top" } ];
    this.fields = [ pjournal1338, pyear1339, ppartner1340 ];
    Lino.ledger.Invoices.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.Enrolments.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  layout: "hbox",
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 162,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var start_date1508 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Period from","(courses.Enrolments.start_date) Start date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Period from</span>", "anchor": "-20", "name": "start_date" });
    var end_date1509 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("until","(courses.Enrolments.end_date) End date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">until</span>", "anchor": "-20", "name": "end_date" });
    var author1510 = new Lino.TwinCombo({ "fieldLabel": "User", "name": "author", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Select a User...", "listeners": { "render": Lino.quicktip_renderer("User","(courses.Enrolments.author) ") }, "selectOnFocus": true, "hiddenName": "authorHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/Enrolments/author", "method": "GET" }) }) });
    var state1511 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "State", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("State","(courses.Enrolments.state) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.courses.EnrolmentStates) });
    var course_state1512 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Course state", "name": "course_state", "hiddenName": "course_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Course state","(courses.Enrolments.course_state) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.courses.CourseStates) });
    var participants_only1513 = new Ext.form.Checkbox({ "boxLabel": "Participants only", "listeners": { "render": Lino.quicktip_renderer("Participants only","(courses.Enrolments.participants_only) Hide cancelled enrolments. Ignored if you specify an explicit enrolment state.") }, "hideLabel": true, "checked": true, "name": "participants_only", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1508, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1509, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": author1510, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state1511, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": course_state1512, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": participants_only1513, "labelAlign": "top" } ];
    this.fields = [ start_date1508, end_date1509, author1510, state1511, course_state1512, participants_only1513 ];
    Lino.courses.Enrolments.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  layout: "hbox",
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 153,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var start_date990 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Period from","(cal.Guests.start_date) Start date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Period from</span>", "anchor": "-20", "name": "start_date" });
    var end_date991 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("until","(cal.Guests.end_date) End date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">until</span>", "anchor": "-20", "name": "end_date" });
    var user992 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Responsible user</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Select a User...", "listeners": { "render": Lino.quicktip_renderer("Responsible user","(cal.Guests.user) Only events managed by this user.") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/user", "method": "GET" }) }) });
    var event_state993 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Event state</span>", "name": "event_state", "hiddenName": "event_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Event state","(cal.Guests.event_state) Only events having this state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.EventStates) });
    var guest_state994 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Guest state</span>", "name": "guest_state", "hiddenName": "guest_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Guest state","(cal.Guests.guest_state) Only guests having this state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.GuestStates) });
    var project995 = new Lino.TwinCombo({ "fieldLabel": "Course", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.Courses.detail)}, "emptyText": "Select a Course...", "listeners": { "render": Lino.quicktip_renderer("Course","(cal.Guests.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/project", "method": "GET" }) }) });
    this.items = [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date990, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date991, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user992, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_state993, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": guest_state994, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project995, "labelAlign": "top" } ];
    this.fields = [ start_date990, end_date991, user992, event_state993, guest_state994, project995 ];
    Lino.cal.Guests.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.Courses.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  layout: "hbox",
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 108,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var topic1437 = new Lino.TwinCombo({ "fieldLabel": "Topic", "name": "topic", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.Topics.detail)}, "emptyText": "Select a Topic...", "listeners": { "render": Lino.quicktip_renderer("Topic","(courses.Courses.topic) ") }, "selectOnFocus": true, "hiddenName": "topicHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/Courses/topic", "method": "GET" }) }) });
    var line1438 = new Lino.TwinCombo({ "fieldLabel": "Course Line", "name": "line", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.Lines.detail)}, "emptyText": "Select a Course Line...", "listeners": { "render": Lino.quicktip_renderer("Course Line","(courses.Courses.line) ") }, "selectOnFocus": true, "hiddenName": "lineHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/Courses/line", "method": "GET" }) }) });
    var company1439 = new Lino.TwinCombo({ "fieldLabel": "Company", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "emptyText": "Select a Company...", "listeners": { "render": Lino.quicktip_renderer("Company","(courses.Courses.company) ") }, "selectOnFocus": true, "hiddenName": "companyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/Courses/company", "method": "GET" }) }) });
    var teacher1440 = new Lino.TwinCombo({ "fieldLabel": "Teacher", "name": "teacher", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.Teachers.detail)}, "emptyText": "Select a Teacher...", "listeners": { "render": Lino.quicktip_renderer("Teacher","(courses.Courses.teacher) ") }, "selectOnFocus": true, "hiddenName": "teacherHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/Courses/teacher", "method": "GET" }) }) });
    var state1441 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "State", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("State","(courses.Courses.state) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.courses.CourseStates) });
    this.items = [ { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": topic1437, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": line1438, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company1439, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": teacher1440, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state1441, "labelAlign": "top" } ];
    this.fields = [ topic1437, line1438, company1439, teacher1440, state1441 ];
    Lino.courses.Courses.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.about.Inspector.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  layout: "hbox",
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 153,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var inspected1710 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Inspected object","(about.Inspector.inspected) ") }, "fieldLabel": "Inspected object", "name": "inspected", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var show_callables1711 = new Ext.form.Checkbox({ "boxLabel": "show callables", "listeners": { "render": Lino.quicktip_renderer("show callables","(about.Inspector.show_callables) ") }, "hideLabel": true, "checked": false, "name": "show_callables", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "flex": 67, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inspected1710, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_callables1711, "labelAlign": "top" } ];
    this.fields = [ inspected1710, show_callables1711 ];
    Lino.about.Inspector.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Events.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var start_date934 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Period from","(cal.Events.start_date) Start date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Period from</span>", "anchor": "-20", "name": "start_date" });
    var end_date935 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("until","(cal.Events.end_date) End date of observed period") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">until</span>", "anchor": "-20", "name": "end_date" });
    var user936 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Responsible user</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Select a User...", "listeners": { "render": Lino.quicktip_renderer("Responsible user","(cal.Events.user) Only events managed by this user.") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }) });
    var assigned_to937 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Assigned to</span>", "name": "assigned_to", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Select a User...", "listeners": { "render": Lino.quicktip_renderer("Assigned to","(cal.Events.assigned_to) Only events assigned to this user.") }, "selectOnFocus": true, "hiddenName": "assigned_toHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/assigned_to", "method": "GET" }) }) });
    var state938 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">State</span>", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("State","(cal.Events.state) Only events having this state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.EventStates) });
    var main_1_panel939 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date934, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date935, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user936, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": assigned_to937, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state938, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var unclear945 = new Ext.form.Checkbox({ "boxLabel": "Unclear events", "listeners": { "render": Lino.quicktip_renderer("Unclear events","(cal.Events.unclear) ") }, "hideLabel": true, "checked": false, "name": "unclear", "selectOnFocus": true, "anchor": "-20" });
    var project946 = new Lino.TwinCombo({ "fieldLabel": "Course", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.Courses.detail)}, "emptyText": "Select a Course...", "listeners": { "render": Lino.quicktip_renderer("Course","(cal.Events.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }) });
    var main_2_panel947 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": unclear945, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project946, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel939, main_2_panel947 ];
    this.fields = [ start_date934, end_date935, user936, assigned_to937, state938, unclear945, project946 ];
    Lino.cal.Events.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.sales.Invoices.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  layout: "hbox",
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 108,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var journal380 = new Lino.TwinCombo({ "fieldLabel": "Journal", "name": "journal", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail)}, "emptyText": "Select a Journal...", "listeners": { "render": Lino.quicktip_renderer("Journal","(sales.Invoices.journal) ") }, "selectOnFocus": true, "hiddenName": "journalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/journal", "method": "GET" }) }) });
    var year381 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "year", "hiddenName": "yearHidden", "listeners": { "render": Lino.quicktip_renderer("Fiscal Year","(sales.Invoices.year) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    this.items = [ { "flex": 74, "autoHeight": true, "layout": "form", "xtype": "panel", "items": journal380, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": year381, "labelAlign": "top" } ];
    this.fields = [ journal380, year381 ];
    Lino.sales.Invoices.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 22,
  initComponent : function() {
    var containing_panel = this;
    var name471 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Partners.name) ") }, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language472 = new Lino.ChoicesFieldElement({ "fieldLabel": "Language", "allowBlank": false, "value": "en", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(contacts.Partners.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var email473 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Partners.email) ") }, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel474 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language472, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email473, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel477 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name471, "anchor": "-20", "labelAlign": "top" }, main_2_panel474 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel477;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Partners.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 36,
  initComponent : function() {
    var containing_panel = this;
    var event1019 = new Lino.TwinCombo({ "fieldLabel": "Event", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Events.detail)}, "emptyText": "Select a Event...", "listeners": { "render": Lino.quicktip_renderer("Event","(cal.Guests.event) ") }, "selectOnFocus": true, "hiddenName": "eventHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/event", "method": "GET" }) }), "name": "event" });
    var partner1020 = new Lino.TwinCombo({ "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Select a Partner...", "listeners": { "render": Lino.quicktip_renderer("Partner","(cal.Guests.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }), "name": "partner" });
    var role1021 = new Lino.TwinCombo({ "fieldLabel": "Role", "name": "role", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.GuestRoles.detail)}, "emptyText": "Select a Guest Role...", "listeners": { "render": Lino.quicktip_renderer("Role","(cal.Guests.role) ") }, "selectOnFocus": true, "hiddenName": "roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/role", "method": "GET" }) }) });
    var main_panel1022 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": event1019, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1020, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": role1021, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1022;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Guests.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Calendars.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 38,
  initComponent : function() {
    var containing_panel = this;
    var name1066 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation","(cal.Calendars.name) ") }, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1067 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(cal.Calendars.name_de) ") }, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_fr1068 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(cal.Calendars.name_fr) ") }, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1069 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1066, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1067, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1068, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type1073 = new Lino.ChoicesFieldElement({ "fieldLabel": "Type", "allowBlank": false, "value": "local", "hiddenName": "typeHidden", "listeners": { "render": Lino.quicktip_renderer("Type","(cal.Calendars.type) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "local", "Local Calendar" ], [ "google", "Google Calendar" ] ], "name": "type" });
    var color1074 = new Ext.form.NumberField({ "listeners": { "render": Lino.quicktip_renderer("color","(cal.Calendars.color) ") }, "fieldLabel": "color", "name": "color", "selectOnFocus": true, "anchor": "-20", "value": 1, "allowBlank": false });
    var main_2_panel1075 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1073, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": color1074, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 54, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1078 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1069, main_2_panel1075 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1078;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Calendars.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.Report.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var body_htmlbox1715 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "body", "containing_panel": this, "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "bodyStyle": "overflow-x:hidden", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer(null,"(lino.Report.body) ") } });
    var main_panel1716 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ body_htmlbox1715 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1716;
    this.before_row_edit = function(record) {
      body_htmlbox1715.refresh();
    }
    Lino.lino.Report.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 36,
  initComponent : function() {
    var containing_panel = this;
    var event1003 = new Lino.TwinCombo({ "fieldLabel": "Event", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Events.detail)}, "emptyText": "Select a Event...", "listeners": { "render": Lino.quicktip_renderer("Event","(cal.Guests.event) ") }, "selectOnFocus": true, "hiddenName": "eventHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/event", "method": "GET" }) }), "name": "event" });
    var partner1004 = new Lino.TwinCombo({ "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Select a Partner...", "listeners": { "render": Lino.quicktip_renderer("Partner","(cal.Guests.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }), "name": "partner" });
    var role1005 = new Lino.TwinCombo({ "fieldLabel": "Role", "name": "role", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.GuestRoles.detail)}, "emptyText": "Select a Guest Role...", "listeners": { "render": Lino.quicktip_renderer("Role","(cal.Guests.role) ") }, "selectOnFocus": true, "hiddenName": "roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/role", "method": "GET" }) }) });
    var main_1_panel1006 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event1003, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1004, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": role1005, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var state1010 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "State", "allowBlank": false, "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("State","(cal.Guests.state) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.GuestStates, "name": "state" });
    var remark1011 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Remark","(cal.Guests.remark) ") }, "fieldLabel": "Remark", "name": "remark", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var workflow_buttons_disp1012 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Workflow","(cal.Guests.workflow_buttons) ") }, "fieldLabel": "Workflow", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_2_panel1013 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state1010, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": remark1011, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp1012, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var outbox_MailsByController_grid1017 = new Lino.outbox.MailsByController.GridPanel({ "flex": 55, "listeners": { "render": Lino.quicktip_renderer("Outgoing Mails","(outbox.outbox.MailsByController) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ], "master_panel": this });
    var main_panel1018 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1006, main_2_panel1013, outbox_MailsByController_grid1017 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1018;
    this.before_row_edit = function(record) {
      outbox_MailsByController_grid1017.on_master_changed();
    }
    Lino.cal.Guests.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.Lines.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 70,
  initComponent : function() {
    var containing_panel = this;
    var id1579 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(courses.Lines.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1580 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation","(courses.Lines.name) ") }, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1581 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(courses.Lines.name_de) ") }, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_fr1582 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(courses.Lines.name_fr) ") }, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1583 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1579, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1580, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1581, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1582, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 153, "border": false, "frame": false, "labelAlign": "top" });
    var description1588 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(courses.Lines.description) ") }, "fieldLabel": "Description", "name": "description", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var courses_CoursesByLine_grid1598 = new Lino.courses.CoursesByLine.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Courses","(courses.courses.CoursesByLine) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.courses.CoursesByLine.grid) ] });
    var main_panel1599 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ main_1_panel1583, { "flex": 5, "layout": "form", "xtype": "panel", "items": description1588, "region": "center", "labelAlign": "top", "split": true }, courses_CoursesByLine_grid1598 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1599;
    this.before_row_edit = function(record) {
      courses_CoursesByLine_grid1598.on_master_changed();
    }
    Lino.courses.Lines.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 19,
  initComponent : function() {
    var containing_panel = this;
    var name626 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Companies.name) ") }, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language627 = new Lino.ChoicesFieldElement({ "fieldLabel": "Language", "allowBlank": false, "value": "en", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(contacts.Companies.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var email628 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Companies.email) ") }, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel629 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language627, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email628, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type632 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Company type", "name": "type", "pageSize": 20, "emptyText": "Select a company type...", "listeners": { "render": Lino.quicktip_renderer("Company type","(contacts.Companies.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var id633 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Companies.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_3_panel634 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type632, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id633, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel637 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name626, "anchor": "-20", "labelAlign": "top" }, main_2_panel629, main_3_panel634 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel637;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Companies.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Rooms.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 34,
  initComponent : function() {
    var containing_panel = this;
    var id1079 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.Rooms.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1080 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation","(cal.Rooms.name) ") }, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1081 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(cal.Rooms.name_de) ") }, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_fr1082 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(cal.Rooms.name_fr) ") }, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1083 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1079, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1080, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1081, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1082, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_EventsByRoom_grid1114 = new Lino.cal.EventsByRoom.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Events","(cal.cal.EventsByRoom) ") }, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByRoom.grid) ], "master_panel": this });
    var main_panel1115 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1083, cal_EventsByRoom_grid1114 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1115;
    this.before_row_edit = function(record) {
      cal_EventsByRoom_grid1114.on_master_changed();
    }
    Lino.cal.Rooms.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Invoices.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 50,
  initComponent : function() {
    var containing_panel = this;
    var id1280 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(ledger.Invoices.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var date1281 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Date","(ledger.Invoices.date) ") }, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var partner1282 = new Lino.TwinCombo({ "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Select a Partner...", "listeners": { "render": Lino.quicktip_renderer("Partner","(ledger.Invoices.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/partner", "method": "GET" }) }), "name": "partner" });
    var user1283 = new Lino.TwinCombo({ "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Select a User...", "listeners": { "render": Lino.quicktip_renderer("Author","(ledger.Invoices.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/user", "method": "GET" }) }) });
    var general_1_panel1284 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1280, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date1281, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1282, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1283, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var due_date1289 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Due date","(ledger.Invoices.due_date) ") }, "fieldLabel": "Due date", "anchor": "-20", "name": "due_date" });
    var your_ref1290 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Your reference","(ledger.Invoices.your_ref) ") }, "fieldLabel": "Your reference", "name": "your_ref", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var vat_regime1291 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "VAT Regime", "name": "vat_regime", "hiddenName": "vat_regimeHidden", "listeners": { "render": Lino.quicktip_renderer("VAT Regime","(ledger.Invoices.vat_regime) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var item_vat1292 = new Ext.form.Checkbox({ "boxLabel": "Prices include VAT", "listeners": { "render": Lino.quicktip_renderer("Prices include VAT","(ledger.Invoices.item_vat) Whether prices includes VAT or not.") }, "hideLabel": true, "checked": false, "name": "item_vat", "selectOnFocus": true, "anchor": "-20" });
    var general_2_panel1293 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": due_date1289, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": your_ref1290, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_regime1291, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": item_vat1292, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 171, "border": false, "anchor": "-20", "labelAlign": "top" });
    var ItemsByInvoice_grid1306 = new Lino.ledger.ItemsByInvoice.GridPanel({ "flex": 75, "listeners": { "render": Lino.quicktip_renderer("Voucher items","(ledger.ledger.ItemsByInvoice) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.ledger.ItemsByInvoice.grid) ], "master_panel": this });
    var total_base1307 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Total excl. VAT", "name": "total_base", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Total excl. VAT","(ledger.Invoices.total_base) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var total_vat1308 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "VAT", "name": "total_vat", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("VAT","(ledger.Invoices.total_vat) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var total_incl1309 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Total incl. VAT", "name": "total_incl", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Total incl. VAT","(ledger.Invoices.total_incl) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var workflow_buttons_disp1310 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Workflow","(ledger.Invoices.workflow_buttons) ") }, "fieldLabel": "Workflow", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var totals_panel1311 = new Ext.Panel({ "flex": 25, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_base1307, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_vat1308, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_incl1309, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp1310, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 144, "border": false, "labelAlign": "top" });
    var general_3_panel1316 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ ItemsByInvoice_grid1306, totals_panel1311 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "anchor": "-20", "labelAlign": "top" });
    var general_panel1317 = new Ext.Panel({ "autoHeight": true, "layout": "form", "title": "General", "items": [ general_1_panel1284, general_2_panel1293, general_3_panel1316 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "labelAlign": "top" });
    var journal1318 = new Lino.TwinCombo({ "fieldLabel": "Journal", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail)}, "emptyText": "Select a Journal...", "listeners": { "render": Lino.quicktip_renderer("Journal","(ledger.Invoices.journal) ") }, "selectOnFocus": true, "hiddenName": "journalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/journal", "method": "GET" }) }), "name": "journal" });
    var year1319 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "year", "hiddenName": "yearHidden", "listeners": { "render": Lino.quicktip_renderer("Fiscal Year","(ledger.Invoices.year) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var number1320 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("number","(ledger.Invoices.number) ") }, "fieldLabel": "number", "anchor": "-20", "name": "number" });
    var narration1321 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Narration","(ledger.Invoices.narration) ") }, "fieldLabel": "Narration", "name": "narration", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var ledger_1_panel1322 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": journal1318, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": year1319, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": number1320, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": narration1321, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var MovementsByVoucher_grid1327 = new Lino.ledger.MovementsByVoucher.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Movements","(ledger.ledger.MovementsByVoucher) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.ledger.MovementsByVoucher.grid) ], "master_panel": this });
    var ledger_panel1328 = new Ext.Panel({ "layout": "vbox", "title": "Ledger", "items": [ ledger_1_panel1322, MovementsByVoucher_grid1327 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel1329 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1317, ledger_panel1328 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1329;
    this.before_row_edit = function(record) {
      ItemsByInvoice_grid1306.on_master_changed();
      MovementsByVoucher_grid1327.on_master_changed();
    }
    Lino.ledger.Invoices.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.GuestRoles.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 37,
  initComponent : function() {
    var containing_panel = this;
    var id1116 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.GuestRoles.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1117 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation","(cal.GuestRoles.name) ") }, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1118 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(cal.GuestRoles.name_de) ") }, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_fr1119 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(cal.GuestRoles.name_fr) ") }, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1120 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1116, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1117, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1118, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1119, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var build_method1125 = new Lino.ChoicesFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Build method","(cal.GuestRoles.build_method) ") }, "fieldLabel": "Build method", "name": "build_method", "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "hiddenName": "build_methodHidden" });
    var template1126 = new Lino.SimpleRemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Template","(cal.GuestRoles.template) ") }, "fieldLabel": "Template", "name": "template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestRoles/template", "method": "GET" }) }) });
    var email_template1127 = new Lino.SimpleRemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Email template","(cal.GuestRoles.email_template) The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Email template</span>", "name": "email_template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestRoles/email_template", "method": "GET" }) }) });
    var attach_to_email1128 = new Ext.form.Checkbox({ "boxLabel": "Attach to email", "listeners": { "render": Lino.quicktip_renderer("Attach to email","(cal.GuestRoles.attach_to_email) Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "hideLabel": true, "checked": false, "name": "attach_to_email", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel1129 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method1125, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template1126, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template1127, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email1128, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_GuestsByRole_grid1143 = new Lino.cal.GuestsByRole.GridPanel({ "flex": 71, "listeners": { "render": Lino.quicktip_renderer("Guests","(cal.cal.GuestsByRole) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.GuestsByRole.grid) ], "master_panel": this });
    var main_panel1144 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1120, main_2_panel1129, cal_GuestsByRole_grid1143 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1144;
    this.before_row_edit = function(record) {
      template1126.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      cal_GuestsByRole_grid1143.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method1125.on('change',Lino.chooser_handler(template1126,'build_method'));
      Lino.cal.GuestRoles.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.cal.GuestRoles.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.About.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var main_panel127 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "hideCheckBoxLabels": true, "items": [ { "html": "<div class=\"htmlText\"><span>This is <a href=\"http://www.lino-framework.org/autodoc/lino.projects.homeworkschool\" target=\"_blank\">Lino-HWS</a> 0.0.1 using <a href=\"http://site.lino-framework.org\" target=\"_blank\">djangosite</a> 0.1.5, <a href=\"http://www.python.org/\" target=\"_blank\">Python</a> 2.7.3, <a href=\"http://www.djangoproject.com\" target=\"_blank\">Django</a> 1.5.1, <a href=\"http://babel.edgewall.org/\" target=\"_blank\">Babel</a> 1.0dev-r661, <a href=\"http://www.lino-framework.org\" target=\"_blank\">Lino</a> 1.6.11, <a href=\"http://jinja.pocoo.org/\" target=\"_blank\">Jinja</a> 2.6, <a href=\"http://sphinx-doc.org/\" target=\"_blank\">Sphinx</a> 1.2b1, <a href=\"http://labix.org/python-dateutil\" target=\"_blank\">python-dateutil</a> 2.1, <a href=\"http://pypi.python.org/pypi/odfpy\" target=\"_blank\">OdfPy</a> ODFPY/0.9.6, <a href=\"http://docutils.sourceforge.net/\" target=\"_blank\">docutils</a> 0.8.1, <a href=\"https://fedorahosted.org/suds/\" target=\"_blank\">suds</a> 0.4, <a href=\"http://pyyaml.org/\" target=\"_blank\">PyYaml</a> 3.10, <a href=\"http://appyframework.org/pod.html\" target=\"_blank\">Appy</a> 0.8.3 (2013/02/22 15:29)</span><p>Server uptime : <b>Monday, July 22, 2013 at 19:13:01.537531</b></p><p>Source timestamps:</p><ul><li>lino : <b>Monday, July 22, 2013 at 14:49:46.383996</b></li><li>atelier : <b>Monday, July 22, 2013 at 04:37:46.130460</b></li><li>north : <b>Saturday, July 20, 2013 at 03:55:07.862412</b></li><li>django : <b>Tuesday, July 9, 2013 at 10:54:45</b></li><li>djangosite : <b>Tuesday, July 9, 2013 at 10:31:38.549456</b></li></ul></div>", "xtype": "label" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel127;
    this.before_row_edit = function(record) {
    }
    Lino.about.About.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 33,
  initComponent : function() {
    var containing_panel = this;
    var summary97 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Summary","(cal.Tasks.summary) ") }, "fieldLabel": "Summary", "name": "summary", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var user98 = new Lino.TwinCombo({ "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Select a User...", "listeners": { "render": Lino.quicktip_renderer("Author","(cal.Tasks.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var project99 = new Lino.TwinCombo({ "fieldLabel": "Course", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.Courses.detail)}, "emptyText": "Select a Course...", "listeners": { "render": Lino.quicktip_renderer("Course","(cal.Tasks.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_2_panel100 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user98, "labelAlign": "top" }, { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project99, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel103 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary97, "anchor": "-20", "labelAlign": "top" }, main_2_panel100 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel103;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Tasks.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Types.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 27,
  initComponent : function() {
    var containing_panel = this;
    var name639 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation","(households.Types.name) ") }, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de640 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(households.Types.name_de) ") }, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_fr641 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(households.Types.name_fr) ") }, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel642 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name639, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de640, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr641, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var HouseholdsByType_grid723 = new Lino.households.HouseholdsByType.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Households","(households.households.HouseholdsByType) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.HouseholdsByType.grid) ], "master_panel": this });
    var main_panel724 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel642, HouseholdsByType_grid723 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel724;
    this.before_row_edit = function(record) {
      HouseholdsByType_grid723.on_master_changed();
    }
    Lino.households.Types.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.products.ProductCats.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 53,
  initComponent : function() {
    var containing_panel = this;
    var id1345 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(products.ProductCats.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1346 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation","(products.ProductCats.name) ") }, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1347 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(products.ProductCats.name_de) ") }, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_fr1348 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(products.ProductCats.name_fr) ") }, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1349 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1345, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1346, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1347, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1348, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 153, "border": false, "frame": false, "labelAlign": "top" });
    var description1354 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("description","(products.ProductCats.description) ") }, "fieldLabel": "description", "name": "description", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var ProductsByCategory_grid1398 = new Lino.products.ProductsByCategory.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Products","(products.products.ProductsByCategory) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.products.ProductsByCategory.grid) ] });
    var main_panel1399 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ main_1_panel1349, { "flex": 5, "layout": "form", "xtype": "panel", "items": description1354, "region": "center", "labelAlign": "top", "split": true }, ProductsByCategory_grid1398 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1399;
    this.before_row_edit = function(record) {
      ProductsByCategory_grid1398.on_master_changed();
    }
    Lino.products.ProductCats.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.Notes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 28,
  initComponent : function() {
    var containing_panel = this;
    var date808 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Date","(notes.Notes.date) ") }, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var event_type809 = new Lino.TwinCombo({ "fieldLabel": "Event Type (Form)", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.EventTypes.detail)}, "emptyText": "Select a Event Type...", "listeners": { "render": Lino.quicktip_renderer("Event Type (Form)","(notes.Notes.event_type) ") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/event_type", "method": "GET" }) }) });
    var type810 = new Lino.TwinCombo({ "fieldLabel": "Note Type (Content)", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.NoteTypes.detail)}, "emptyText": "Select a Note Type...", "listeners": { "render": Lino.quicktip_renderer("Note Type (Content)","(notes.Notes.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/type", "method": "GET" }) }) });
    var main_1_panel811 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 180, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date808, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type809, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type810, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var subject815 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Subject","(notes.Notes.subject) ") }, "fieldLabel": "Subject", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var project816 = new Lino.TwinCombo({ "fieldLabel": "Course", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.Courses.detail)}, "emptyText": "Select a Course...", "listeners": { "render": Lino.quicktip_renderer("Course","(notes.Notes.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/project", "method": "GET" }) }) });
    var main_2_panel817 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject815, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project816, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var id820 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(notes.Notes.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var user821 = new Lino.TwinCombo({ "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Select a User...", "listeners": { "render": Lino.quicktip_renderer("Author","(notes.Notes.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/user", "method": "GET" }) }) });
    var language822 = new Lino.ChoicesFieldElement({ "fieldLabel": "Language", "allowBlank": false, "value": "en", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(notes.Notes.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var build_time823 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("build time","(notes.Notes.build_time) ") }, "fieldLabel": "build time", "name": "build_time", "anchor": "-20", "value": "<br>" });
    var main_3_panel824 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id820, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user821, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language822, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_time823, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var body829 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 33, "containing_panel": this, "name": "body", "title": "Body" });
    var outbox_MailsByController_grid841 = new Lino.outbox.MailsByController.GridPanel({ "flex": 66, "listeners": { "render": Lino.quicktip_renderer("Outgoing Mails","(outbox.outbox.MailsByController) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ], "master_panel": this });
    var main_4_panel842 = new Ext.Panel({ "flex": 62, "border": false, "layout": "hbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ body829, outbox_MailsByController_grid841 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel843 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel811, main_2_panel817, main_3_panel824, main_4_panel842 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel843;
    this.before_row_edit = function(record) {
      body829.refresh();
      outbox_MailsByController_grid841.on_master_changed();
    }
    Lino.notes.Notes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.NoteTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 30,
  initComponent : function() {
    var containing_panel = this;
    var id776 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(notes.NoteTypes.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name777 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation","(notes.NoteTypes.name) ") }, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de778 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(notes.NoteTypes.name_de) ") }, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_fr779 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(notes.NoteTypes.name_fr) ") }, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel780 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id776, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name777, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de778, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr779, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var build_method785 = new Lino.ChoicesFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Build method","(notes.NoteTypes.build_method) ") }, "fieldLabel": "Build method", "name": "build_method", "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "hiddenName": "build_methodHidden" });
    var template786 = new Lino.SimpleRemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Template","(notes.NoteTypes.template) ") }, "fieldLabel": "Template", "name": "template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NoteTypes/template", "method": "GET" }) }) });
    var email_template787 = new Lino.SimpleRemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Email template","(notes.NoteTypes.email_template) The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Email template</span>", "name": "email_template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NoteTypes/email_template", "method": "GET" }) }) });
    var attach_to_email788 = new Ext.form.Checkbox({ "boxLabel": "Attach to email", "listeners": { "render": Lino.quicktip_renderer("Attach to email","(notes.NoteTypes.attach_to_email) Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "hideLabel": true, "checked": false, "name": "attach_to_email", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel789 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method785, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template786, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template787, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email788, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark794 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remark","(notes.NoteTypes.remark) ") }, "fieldLabel": "Remark", "name": "remark", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var notes_NotesByType_grid844 = new Lino.notes.NotesByType.GridPanel({ "flex": 41, "listeners": { "render": Lino.quicktip_renderer("Events/Notes","(notes.notes.NotesByType) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.notes.NotesByType.grid) ], "master_panel": this });
    var main_panel845 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 63, "hideCheckBoxLabels": true, "items": [ main_1_panel780, main_2_panel789, { "items": remark794, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 41 }, notes_NotesByType_grid844 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel845;
    this.before_row_edit = function(record) {
      template786.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      notes_NotesByType_grid844.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method785.on('change',Lino.chooser_handler(template786,'build_method'));
      Lino.notes.NoteTypes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.notes.NoteTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.Slots.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 63,
  initComponent : function() {
    var containing_panel = this;
    var name1401 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Name","(courses.Slots.name) ") }, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var start_time1402 = new Lino.TimeField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start Time","(courses.Slots.start_time) ") }, "fieldLabel": "Start Time", "anchor": "-20", "name": "start_time" });
    var end_time1403 = new Lino.TimeField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("End Time","(courses.Slots.end_time) ") }, "fieldLabel": "End Time", "anchor": "-20", "name": "end_time" });
    var main_1_panel1404 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 56, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1401, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time1402, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time1403, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var courses_CoursesBySlot_grid1554 = new Lino.courses.CoursesBySlot.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Courses","(courses.courses.CoursesBySlot) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.courses.CoursesBySlot.grid) ], "master_panel": this });
    var main_panel1555 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1404, courses_CoursesBySlot_grid1554 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1555;
    this.before_row_edit = function(record) {
      courses_CoursesBySlot_grid1554.on_master_changed();
    }
    Lino.courses.Slots.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Charts.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 47,
  initComponent : function() {
    var containing_panel = this;
    var id1191 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(accounts.Charts.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1192 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation","(accounts.Charts.name) ") }, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1193 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(accounts.Charts.name_de) ") }, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_fr1194 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(accounts.Charts.name_fr) ") }, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1195 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1191, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1192, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1193, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1194, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var GroupsByChart_grid1237 = new Lino.accounts.GroupsByChart.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Account Groups","(accounts.accounts.GroupsByChart) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.accounts.GroupsByChart.grid) ], "master_panel": this });
    var main_panel1238 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1195, GroupsByChart_grid1237 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1238;
    this.before_row_edit = function(record) {
      GroupsByChart_grid1237.on_master_changed();
    }
    Lino.accounts.Charts.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.products.Products.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 54,
  initComponent : function() {
    var containing_panel = this;
    var id1366 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(products.Products.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var cat1367 = new Lino.TwinCombo({ "fieldLabel": "Category", "name": "cat", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.products.ProductCats.detail)}, "emptyText": "Select a Product Category...", "listeners": { "render": Lino.quicktip_renderer("Category","(products.Products.cat) ") }, "selectOnFocus": true, "hiddenName": "catHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/products/Products/cat", "method": "GET" }) }) });
    var price1368 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Price", "name": "price", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Price","(products.Products.price) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var vatExempt1369 = new Ext.form.Checkbox({ "boxLabel": "VAT exempt", "listeners": { "render": Lino.quicktip_renderer("VAT exempt","(products.Products.vatExempt) ") }, "hideLabel": true, "checked": false, "name": "vatExempt", "selectOnFocus": true, "anchor": "-20" });
    var general_1_panel1370 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1366, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cat1367, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": price1368, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vatExempt1369, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var name1375 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation","(products.Products.name) ") }, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1376 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(products.Products.name_de) ") }, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_fr1377 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(products.Products.name_fr) ") }, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var general_2_panel1378 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1375, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1376, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1377, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description1382 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Long description","(products.Products.description) ") }, "fieldLabel": "Long description", "name": "description", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var general_panel1383 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel1370, general_2_panel1378, { "items": description1382, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "labelWidth": 153, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var sales_InvoiceItemsByProduct_grid1396 = new Lino.sales.InvoiceItemsByProduct.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Sales", "tools": [ Lino.show_in_own_window_button(Lino.sales.InvoiceItemsByProduct.grid) ], "master_panel": this });
    var main_panel1397 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1383, sales_InvoiceItemsByProduct_grid1396 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1397;
    this.before_row_edit = function(record) {
      sales_InvoiceItemsByProduct_grid1396.on_master_changed();
    }
    Lino.products.Products.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.Home.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var quick_links_htmlbox1720 = new Lino.HtmlBoxPanel({ "flex": 1, "layout": "fit", "name": "quick_links", "containing_panel": this, "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "north", "bodyStyle": "overflow-x:hidden", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer(null,"(lino.Home.quick_links) ") }, "split": true });
    var welcome_htmlbox1721 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "welcome", "containing_panel": this, "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "center", "title": "Welcome", "bodyStyle": "overflow-x:hidden", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Welcome","(lino.Home.welcome) ") }, "split": true });
    var coming_reminders_htmlbox1722 = new Lino.HtmlBoxPanel({ "flex": 50, "layout": "fit", "name": "coming_reminders", "containing_panel": this, "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Upcoming reminders", "bodyStyle": "overflow-x:hidden", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Upcoming reminders","(lino.Home.coming_reminders) ") } });
    var missed_reminders_htmlbox1723 = new Lino.HtmlBoxPanel({ "flex": 50, "layout": "fit", "name": "missed_reminders", "containing_panel": this, "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Missed reminders", "bodyStyle": "overflow-x:hidden", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Missed reminders","(lino.Home.missed_reminders) ") } });
    var main_3_panel1724 = new Ext.Panel({ "flex": 16, "layout": "hbox", "items": [ coming_reminders_htmlbox1722, missed_reminders_htmlbox1723 ], "region": "south", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 171, "border": false, "frame": false, "labelAlign": "top" });
    var main_panel1725 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ quick_links_htmlbox1720, welcome_htmlbox1721, main_3_panel1724 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1725;
    this.before_row_edit = function(record) {
      quick_links_htmlbox1720.refresh();
      welcome_htmlbox1721.refresh();
      coming_reminders_htmlbox1722.refresh();
      missed_reminders_htmlbox1723.refresh();
    }
    Lino.lino.Home.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.EventTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 29,
  initComponent : function() {
    var containing_panel = this;
    var id847 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(notes.EventTypes.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name848 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation","(notes.EventTypes.name) ") }, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de849 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(notes.EventTypes.name_de) ") }, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_fr850 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(notes.EventTypes.name_fr) ") }, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel851 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id847, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name848, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de849, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr850, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 153, "border": false, "frame": false, "labelAlign": "top" });
    var remark856 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remark","(notes.EventTypes.remark) ") }, "fieldLabel": "Remark", "name": "remark", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var notes_NotesByEventType_grid870 = new Lino.notes.NotesByEventType.GridPanel({ "flex": 6, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Events/Notes","(notes.notes.NotesByEventType) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.notes.NotesByEventType.grid) ] });
    var main_panel871 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 63, "hideCheckBoxLabels": true, "items": [ main_1_panel851, { "flex": 3, "layout": "form", "xtype": "panel", "items": remark856, "region": "center", "labelAlign": "top", "split": true }, notes_NotesByEventType_grid870 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel871;
    this.before_row_edit = function(record) {
      notes_NotesByEventType_grid870.on_master_changed();
    }
    Lino.notes.EventTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Cities.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 17,
  initComponent : function() {
    var containing_panel = this;
    var name227 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation","(countries.Cities.name) ") }, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de228 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(countries.Cities.name_de) ") }, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_fr229 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(countries.Cities.name_fr) ") }, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var country230 = new Lino.TwinCombo({ "fieldLabel": "Country", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Country","(countries.Cities.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/country", "method": "GET" }) }), "name": "country" });
    var main_1_panel231 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name227, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de228, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr229, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country230, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var type236 = new Lino.RemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Place Type","(countries.Cities.type) ") }, "fieldLabel": "Place Type", "name": "type", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/type", "method": "GET" }) }), "hiddenName": "typeHidden" });
    var parent237 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Part of</span>", "name": "parent", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Part of","(countries.Cities.parent) The superordinate geographic place of which this place is a part.") }, "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/parent", "method": "GET" }) }) });
    var zip_code238 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("zip code","(countries.Cities.zip_code) ") }, "fieldLabel": "zip code", "name": "zip_code", "maxLength": 8, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "anchor": "-20" });
    var id239 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(countries.Cities.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_2_panel240 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type236, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent237, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code238, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id239, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var CitiesByCity_grid481 = new Lino.countries.CitiesByCity.GridPanel({ "flex": 41, "listeners": { "render": Lino.quicktip_renderer("Subdivisions","(countries.countries.CitiesByCity) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.countries.CitiesByCity.grid) ], "master_panel": this });
    var contacts_PartnersByCity_grid482 = new Lino.contacts.PartnersByCity.GridPanel({ "flex": 41, "listeners": { "render": Lino.quicktip_renderer("Partners","(contacts.contacts.PartnersByCity) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.PartnersByCity.grid) ], "master_panel": this });
    var main_panel483 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel231, main_2_panel240, CitiesByCity_grid481, contacts_PartnersByCity_grid482 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel483;
    this.before_row_edit = function(record) {
      type236.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      CitiesByCity_grid481.on_master_changed();
      contacts_PartnersByCity_grid482.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country230.on('change',Lino.chooser_handler(type236,'country'));
      Lino.countries.Cities.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.countries.Cities.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.PupilTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 64,
  initComponent : function() {
    var containing_panel = this;
    var id1652 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(courses.PupilTypes.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1653 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation","(courses.PupilTypes.name) ") }, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1654 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(courses.PupilTypes.name_de) ") }, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_fr1655 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(courses.PupilTypes.name_fr) ") }, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1656 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1652, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1653, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1654, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1655, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var courses_PupilsByType_grid1693 = new Lino.courses.PupilsByType.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Pupils","(courses.courses.PupilsByType) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.courses.PupilsByType.grid) ], "master_panel": this });
    var main_panel1694 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1656, courses_PupilsByType_grid1693 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1694;
    this.before_row_edit = function(record) {
      courses_PupilsByType_grid1693.on_master_changed();
    }
    Lino.courses.PupilTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pages.Pages.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 44,
  initComponent : function() {
    var containing_panel = this;
    var ref1174 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Reference","(pages.Pages.ref) ") }, "fieldLabel": "Reference", "name": "ref", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var parent1175 = new Lino.TwinCombo({ "fieldLabel": "Parent", "name": "parent", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pages.Pages.detail)}, "emptyText": "Select a Node...", "listeners": { "render": Lino.quicktip_renderer("Parent","(pages.Pages.parent) ") }, "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pages/Pages/parent", "method": "GET" }) }) });
    var seqno1176 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Seq.No.","(pages.Pages.seqno) ") }, "fieldLabel": "Seq.No.", "anchor": "-20", "name": "seqno" });
    var main_1_panel1177 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1174, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent1175, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": seqno1176, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var title1181 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Title","(pages.Pages.title) ") }, "fieldLabel": "Title", "name": "title", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var title_de1182 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Title (de)","(pages.Pages.title_de) ") }, "fieldLabel": "Title (de)", "name": "title_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var title_fr1183 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Title (fr)","(pages.Pages.title_fr) ") }, "fieldLabel": "Title (fr)", "name": "title_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel1184 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title1181, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title_de1182, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title_fr1183, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var body1188 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Body","(pages.Pages.body) ") }, "fieldLabel": "Body", "name": "body", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var main_panel1189 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 45, "hideCheckBoxLabels": true, "items": [ main_1_panel1177, main_2_panel1184, { "items": body1188, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1189;
    this.before_row_edit = function(record) {
    }
    Lino.pages.Pages.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.SiteConfigs.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 8,
  initComponent : function() {
    var containing_panel = this;
    var default_build_method165 = new Lino.ChoicesFieldElement({ "fieldLabel": "Default build method", "name": "default_build_method", "value": "appyodt", "hiddenName": "default_build_methodHidden", "listeners": { "render": Lino.quicktip_renderer("Default build method","(system.SiteConfigs.default_build_method) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var main_panel166 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "items": default_build_method165, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel166;
    this.before_row_edit = function(record) {
    }
    Lino.system.SiteConfigs.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Journals.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 48,
  initComponent : function() {
    var containing_panel = this;
    var seqno1239 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Seq.No.","(ledger.Journals.seqno) ") }, "fieldLabel": "Seq.No.", "anchor": "-20", "name": "seqno" });
    var id1240 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(ledger.Journals.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var trade_type1241 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Trade Type", "name": "trade_type", "hiddenName": "trade_typeHidden", "listeners": { "render": Lino.quicktip_renderer("Trade Type","(ledger.Journals.trade_type) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.vat.TradeTypes) });
    var voucher_type1242 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "voucher type", "allowBlank": false, "hiddenName": "voucher_typeHidden", "listeners": { "render": Lino.quicktip_renderer("voucher type","(ledger.Journals.voucher_type) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.ledger.VoucherTypes, "name": "voucher_type" });
    var main_1_panel1243 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": seqno1239, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1240, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": trade_type1241, "labelAlign": "top" }, { "flex": 70, "autoHeight": true, "layout": "form", "xtype": "panel", "items": voucher_type1242, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var force_sequence1248 = new Ext.form.Checkbox({ "boxLabel": "force sequence", "listeners": { "render": Lino.quicktip_renderer("force sequence","(ledger.Journals.force_sequence) ") }, "hideLabel": true, "checked": false, "name": "force_sequence", "selectOnFocus": true, "anchor": "-20" });
    var account1249 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Account", "name": "account", "pageSize": 20, "emptyText": "Select a Account...", "listeners": { "render": Lino.quicktip_renderer("Account","(ledger.Journals.account) ") }, "selectOnFocus": true, "hiddenName": "accountHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Journals/account", "method": "GET" }) }) });
    var main_2_panel1250 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": force_sequence1248, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": account1249, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var name1253 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation","(ledger.Journals.name) ") }, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1254 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(ledger.Journals.name_de) ") }, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_fr1255 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(ledger.Journals.name_fr) ") }, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel1256 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1253, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1254, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1255, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var printed_name1260 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("printed name","(ledger.Journals.printed_name) ") }, "fieldLabel": "printed name", "name": "printed_name", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var printed_name_de1261 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("printed name (de)","(ledger.Journals.printed_name_de) ") }, "fieldLabel": "printed name (de)", "name": "printed_name_de", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var printed_name_fr1262 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("printed name (fr)","(ledger.Journals.printed_name_fr) ") }, "fieldLabel": "printed name (fr)", "name": "printed_name_fr", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var main_4_panel1263 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": printed_name1260, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": printed_name_de1261, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": printed_name_fr1262, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1267 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1243, main_2_panel1250, main_3_panel1256, main_4_panel1263 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1267;
    this.before_row_edit = function(record) {
      account1249.setContextValue('chart',record ? record.data['chartHidden'] : undefined);
    }
    Lino.ledger.Journals.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.Mails.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 41,
  initComponent : function() {
    var containing_panel = this;
    var project770 = new Lino.TwinCombo({ "fieldLabel": "Course", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.Courses.detail)}, "emptyText": "Select a Course...", "listeners": { "render": Lino.quicktip_renderer("Course","(outbox.Mails.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var subject771 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Subject","(outbox.Mails.subject) ") }, "fieldLabel": "Subject", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var body772 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 71, "containing_panel": this, "name": "body", "title": "Body" });
    var main_panel773 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": project770, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": subject771, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, body772 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel773;
    this.before_row_edit = function(record) {
      body772.refresh();
    }
    Lino.outbox.Mails.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.Enrolments.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 66,
  initComponent : function() {
    var containing_panel = this;
    var course1521 = new Lino.TwinCombo({ "fieldLabel": "Course", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.Courses.detail)}, "emptyText": "Select a Course...", "listeners": { "render": Lino.quicktip_renderer("Course","(courses.Enrolments.course) ") }, "selectOnFocus": true, "hiddenName": "courseHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/Enrolments/course", "method": "GET" }) }), "name": "course" });
    var pupil1522 = new Lino.TwinCombo({ "fieldLabel": "Pupil", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.Pupils.detail)}, "emptyText": "Select a Pupil...", "listeners": { "render": Lino.quicktip_renderer("Pupil","(courses.Enrolments.pupil) ") }, "selectOnFocus": true, "hiddenName": "pupilHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/Enrolments/pupil", "method": "GET" }) }), "name": "pupil" });
    var user1523 = new Lino.TwinCombo({ "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Select a User...", "listeners": { "render": Lino.quicktip_renderer("Author","(courses.Enrolments.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/Enrolments/user", "method": "GET" }) }) });
    var request_date1524 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Date of request","(courses.Enrolments.request_date) ") }, "fieldLabel": "Date of request", "name": "request_date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var state1525 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "State", "allowBlank": false, "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("State","(courses.Enrolments.state) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.courses.EnrolmentStates, "name": "state" });
    var main_1_panel1526 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": course1521, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pupil1522, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1523, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": request_date1524, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state1525, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var sales_InvoicingsByInvoiceable_grid1543 = new Lino.sales.InvoicingsByInvoiceable.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Voucher items","(sales.sales.InvoicingsByInvoiceable) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.sales.InvoicingsByInvoiceable.grid) ], "master_panel": this });
    var main_panel1544 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1526, sales_InvoicingsByInvoiceable_grid1543 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1544;
    this.before_row_edit = function(record) {
      sales_InvoicingsByInvoiceable_grid1543.on_master_changed();
    }
    Lino.courses.Enrolments.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Groups.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 46,
  initComponent : function() {
    var containing_panel = this;
    var ref1208 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("ref","(accounts.Groups.ref) ") }, "fieldLabel": "ref", "name": "ref", "maxLength": 20, "selectOnFocus": true, "anchor": "-20" });
    var name1209 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation","(accounts.Groups.name) ") }, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1210 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(accounts.Groups.name_de) ") }, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_fr1211 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(accounts.Groups.name_fr) ") }, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1212 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1208, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1209, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1210, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1211, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var account_type1217 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Account Type", "name": "account_type", "hiddenName": "account_typeHidden", "listeners": { "render": Lino.quicktip_renderer("Account Type","(accounts.Groups.account_type) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.accounts.AccountTypes) });
    var id1218 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(accounts.Groups.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_2_panel1219 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 76, "autoHeight": true, "layout": "form", "xtype": "panel", "items": account_type1217, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1218, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var help_text1222 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 41, "containing_panel": this, "name": "help_text", "title": "Introduction" });
    var AccountsByGroup_grid1235 = new Lino.accounts.AccountsByGroup.GridPanel({ "flex": 41, "listeners": { "render": Lino.quicktip_renderer("Accounts","(accounts.accounts.AccountsByGroup) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.accounts.AccountsByGroup.grid) ], "master_panel": this });
    var main_panel1236 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel1212, main_2_panel1219, help_text1222, AccountsByGroup_grid1235 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1236;
    this.before_row_edit = function(record) {
      help_text1222.refresh();
      AccountsByGroup_grid1235.on_master_changed();
    }
    Lino.accounts.Groups.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.Slots.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 63,
  initComponent : function() {
    var containing_panel = this;
    var start_time1556 = new Lino.TimeField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start Time","(courses.Slots.start_time) ") }, "fieldLabel": "Start Time", "anchor": "-20", "name": "start_time" });
    var end_time1557 = new Lino.TimeField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("End Time","(courses.Slots.end_time) ") }, "fieldLabel": "End Time", "anchor": "-20", "name": "end_time" });
    var main_1_panel1558 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time1556, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time1557, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var name1561 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Name","(courses.Slots.name) ") }, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_panel1562 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ main_1_panel1558, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1561, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1562;
    this.before_row_edit = function(record) {
    }
    Lino.courses.Slots.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.Users.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 12,
  initComponent : function() {
    var containing_panel = this;
    var username1 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Username","(users.Users.username) \n        Required. Must be unique. \n        ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Username</span>", "name": "username", "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id2 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(users.Users.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var profile3 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "User Profile", "name": "profile", "hiddenName": "profileHidden", "listeners": { "render": Lino.quicktip_renderer("User Profile","(users.Users.profile) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var box1_1_panel4 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username1, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile3, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name8 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("First name","(users.Users.first_name) ") }, "fieldLabel": "First name", "name": "first_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var last_name9 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Last name","(users.Users.last_name) ") }, "fieldLabel": "Last name", "name": "last_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var partner10 = new Lino.TwinCombo({ "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Select a Partner...", "listeners": { "render": Lino.quicktip_renderer("Partner","(users.Users.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var box1_2_panel11 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name8, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name9, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner10, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email15 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("e-mail address","(users.Users.email) ") }, "fieldLabel": "e-mail address", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var language16 = new Lino.ChoicesFieldElement({ "fieldLabel": "Language", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(users.Users.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var box1_3_panel17 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email15, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language16, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var created20 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Created","(users.Users.created) ") }, "fieldLabel": "Created", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified21 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Modified","(users.Users.modified) ") }, "fieldLabel": "Modified", "name": "modified", "anchor": "-20", "value": "<br>" });
    var box1_4_panel22 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created20, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified21, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box1_panel25 = new Ext.Panel({ "flex": 66, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ box1_1_panel4, box1_2_panel11, box1_3_panel17, box1_4_panel22 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var MembershipsByUser_grid28 = new Lino.users.MembershipsByUser.GridPanel({ "flex": 33, "listeners": { "render": Lino.quicktip_renderer("My Memberships","(users.users.MembershipsByUser) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.users.MembershipsByUser.grid) ], "master_panel": this });
    var general_1_panel29 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box1_panel25, MembershipsByUser_grid28 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks30 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remarks","(users.Users.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var AuthoritiesGiven_grid33 = new Lino.users.AuthoritiesGiven.GridPanel({ "flex": 33, "listeners": { "render": Lino.quicktip_renderer("Authorities given","(users.users.AuthoritiesGiven) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.users.AuthoritiesGiven.grid) ], "master_panel": this });
    var general_2_panel34 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": remarks30, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 66 }, AuthoritiesGiven_grid33 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel36 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel29, general_2_panel34 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var calendar37 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Default calendar</span>", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Select a Calendar...", "listeners": { "render": Lino.quicktip_renderer("Default calendar","(users.Users.calendar) The default calendar for your events and tasks.") }, "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/calendar", "method": "GET" }) }) });
    var access_class38 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Default access class</span>", "allowBlank": false, "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Default access class","(users.Users.access_class) The default access class for your calendar events and tasks.") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.AccessClasses, "name": "access_class" });
    var cal_left_1_panel39 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar37, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class38, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_SubscriptionsByUser_grid46 = new Lino.cal.SubscriptionsByUser.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Subscriptions","(cal.cal.SubscriptionsByUser) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.SubscriptionsByUser.grid) ], "master_panel": this });
    var cal_left_panel47 = new Ext.Panel({ "flex": 33, "border": false, "layout": "vbox", "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ cal_left_1_panel39, cal_SubscriptionsByUser_grid46 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": true, "labelAlign": "top" });
    var cal_TasksByUser_grid105 = new Lino.cal.TasksByUser.GridPanel({ "flex": 66, "listeners": { "render": Lino.quicktip_renderer("Tasks","(cal.cal.TasksByUser) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByUser.grid) ], "master_panel": this });
    var cal_1_panel106 = new Ext.Panel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "layout": "hbox", "title": "Calendar", "hideCheckBoxLabels": true, "items": [ cal_left_panel47, cal_TasksByUser_grid105 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel107 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel36, cal_1_panel106 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel107;
    this.before_row_edit = function(record) {
      MembershipsByUser_grid28.on_master_changed();
      AuthoritiesGiven_grid33.on_master_changed();
      cal_SubscriptionsByUser_grid46.on_master_changed();
      cal_TasksByUser_grid105.on_master_changed();
    }
    Lino.users.Users.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.ContentTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 3,
  initComponent : function() {
    var containing_panel = this;
    var id168 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(system.ContentTypes.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name169 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("name","(system.ContentTypes.name) ") }, "fieldLabel": "name", "name": "name", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var app_label170 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("app label","(system.ContentTypes.app_label) ") }, "fieldLabel": "app label", "name": "app_label", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var model171 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("python model class name","(system.ContentTypes.model) ") }, "fieldLabel": "python model class name", "name": "model", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var base_classes_disp172 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Base classes","(system.ContentTypes.base_classes) ") }, "fieldLabel": "Base classes", "name": "base_classes", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel173 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id168, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name169, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_label170, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": model171, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": base_classes_disp172, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var system_HelpTextsByModel_grid185 = new Lino.system.HelpTextsByModel.GridPanel({ "flex": 62, "listeners": { "render": Lino.quicktip_renderer("Help Texts","(system.system.HelpTextsByModel) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.system.HelpTextsByModel.grid) ], "master_panel": this });
    var main_panel186 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel173, system_HelpTextsByModel_grid185 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel186;
    this.before_row_edit = function(record) {
      system_HelpTextsByModel_grid185.on_master_changed();
    }
    Lino.system.ContentTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Households.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 26,
  initComponent : function() {
    var containing_panel = this;
    var type671 = new Lino.TwinCombo({ "fieldLabel": "Household Type", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.households.Types.detail)}, "emptyText": "Select a Household Type...", "listeners": { "render": Lino.quicktip_renderer("Household Type","(households.Households.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/type", "method": "GET" }) }) });
    var name672 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Name","(households.Households.name) ") }, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language673 = new Lino.ChoicesFieldElement({ "fieldLabel": "Language", "allowBlank": false, "value": "en", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(households.Households.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var id674 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(households.Households.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var intro_box_1_panel675 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type671, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name672, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language673, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id674, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var country680 = new Lino.TwinCombo({ "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Country","(households.Households.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/country", "method": "GET" }) }) });
    var region681 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Region","(households.Households.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/region", "method": "GET" }) }) });
    var box3_1_panel682 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country680, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region681, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city685 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Place","(households.Households.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/city", "method": "GET" }) }) });
    var zip_code686 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Zip code","(households.Households.zip_code) ") }, "fieldLabel": "Zip code", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_2_panel687 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city685, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code686, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix690 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Street prefix","(households.Households.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street prefix</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street691 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Street","(households.Households.street) Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no692 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("No.","(households.Households.street_no) House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box693 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","(households.Households.street_box) Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_3_panel694 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix690, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street691, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no692, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box693, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2699 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Address line after street","(households.Households.addr2) Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line after street</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box3_panel700 = new Ext.Panel({ "flex": 62, "autoHeight": true, "layout": "form", "items": [ box3_1_panel682, box3_2_panel687, box3_3_panel694, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2699, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 234, "border": false, "labelAlign": "top" });
    var email702 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("E-Mail","(households.Households.email) ") }, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var url703 = new Lino.URLField({ "listeners": { "render": Lino.quicktip_renderer("URL","(households.Households.url) ") }, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var phone704 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Phone","(households.Households.phone) ") }, "fieldLabel": "Phone", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gsm705 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("GSM","(households.Households.gsm) ") }, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box4_panel706 = new Ext.Panel({ "flex": 37, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email702, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url703, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone704, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm705, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var address_box_panel711 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box3_panel700, box4_panel706 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks712 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remarks","(households.Households.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var households_MembersByHousehold_grid719 = new Lino.households.MembersByHousehold.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("Household Members","(households.households.MembersByHousehold) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByHousehold.grid) ], "master_panel": this });
    var bottom_box_panel720 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": remarks712, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 49 }, households_MembersByHousehold_grid719 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel722 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ intro_box_1_panel675, address_box_panel711, bottom_box_panel720 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel722;
    this.before_row_edit = function(record) {
      region681.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city685.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city685.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      households_MembersByHousehold_grid719.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country680.on('change',Lino.chooser_handler(region681,'country'));
      country680.on('change',Lino.chooser_handler(city685,'country'));
      region681.on('change',Lino.chooser_handler(city685,'region'));
      Lino.households.Households.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.households.Households.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.sales.Invoices.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 59,
  initComponent : function() {
    var containing_panel = this;
    var date385 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Date","(sales.Invoices.date) ") }, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var partner386 = new Lino.TwinCombo({ "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Select a Partner...", "listeners": { "render": Lino.quicktip_renderer("Partner","(sales.Invoices.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/partner", "method": "GET" }) }), "name": "partner" });
    var vat_regime387 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "VAT Regime", "name": "vat_regime", "hiddenName": "vat_regimeHidden", "listeners": { "render": Lino.quicktip_renderer("VAT Regime","(sales.Invoices.vat_regime) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var invoice_header_1_panel388 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date385, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner386, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_regime387, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var subject392 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Subject line","(sales.Invoices.subject) ") }, "fieldLabel": "Subject line", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var your_ref393 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Your reference","(sales.Invoices.your_ref) ") }, "fieldLabel": "Your reference", "name": "your_ref", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var invoice_header_2_panel394 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject392, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": your_ref393, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var payment_term397 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Payment Term", "name": "payment_term", "pageSize": 20, "emptyText": "Select a Payment Term...", "listeners": { "render": Lino.quicktip_renderer("Payment Term","(sales.Invoices.payment_term) ") }, "selectOnFocus": true, "hiddenName": "payment_termHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/payment_term", "method": "GET" }) }) });
    var due_date398 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date of payment","(sales.Invoices.due_date) ") }, "fieldLabel": "Date of payment", "anchor": "-20", "name": "due_date" });
    var invoice_header_3_panel399 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": payment_term397, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": due_date398, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 144, "border": false, "anchor": "-20", "labelAlign": "top" });
    var imode402 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Invoicing Mode", "name": "imode", "pageSize": 20, "emptyText": "Select a Invoicing Mode...", "listeners": { "render": Lino.quicktip_renderer("Invoicing Mode","(sales.Invoices.imode) ") }, "selectOnFocus": true, "hiddenName": "imodeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/imode", "method": "GET" }) }) });
    var shipping_mode403 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Shipping Mode", "name": "shipping_mode", "pageSize": 20, "emptyText": "Select a Shipping Mode...", "listeners": { "render": Lino.quicktip_renderer("Shipping Mode","(sales.Invoices.shipping_mode) ") }, "selectOnFocus": true, "hiddenName": "shipping_modeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/shipping_mode", "method": "GET" }) }) });
    var invoice_header_4_panel404 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": imode402, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": shipping_mode403, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var invoice_header_panel407 = new Ext.form.FieldSet({ "flex": 75, "autoHeight": true, "layout": "form", "title": "Header", "items": [ invoice_header_1_panel388, invoice_header_2_panel394, invoice_header_3_panel399, invoice_header_4_panel404 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var total_base408 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Total excl. VAT", "name": "total_base", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Total excl. VAT","(sales.Invoices.total_base) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var total_vat409 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "VAT", "name": "total_vat", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("VAT","(sales.Invoices.total_vat) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var total_incl410 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Total incl. VAT", "name": "total_incl", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Total incl. VAT","(sales.Invoices.total_incl) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var workflow_buttons_disp411 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Workflow","(sales.Invoices.workflow_buttons) ") }, "fieldLabel": "Workflow", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var totals_panel412 = new Ext.form.FieldSet({ "flex": 25, "autoHeight": true, "layout": "form", "title": "Totals", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_base408, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_vat409, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_incl410, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp411, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 144, "border": false, "labelAlign": "top" });
    var general_1_panel417 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ invoice_header_panel407, totals_panel412 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ItemsByInvoice_grid429 = new Lino.sales.ItemsByInvoice.GridPanel({ "flex": 45, "listeners": { "render": Lino.quicktip_renderer("Voucher items","(sales.sales.ItemsByInvoice) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.sales.ItemsByInvoice.grid) ], "master_panel": this });
    var general_panel430 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel417, ItemsByInvoice_grid429 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var id431 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(sales.Invoices.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var user432 = new Lino.TwinCombo({ "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Select a User...", "listeners": { "render": Lino.quicktip_renderer("Author","(sales.Invoices.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/user", "method": "GET" }) }) });
    var language433 = new Lino.ChoicesFieldElement({ "fieldLabel": "Language", "allowBlank": false, "value": "en", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(sales.Invoices.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var item_vat434 = new Ext.form.Checkbox({ "boxLabel": "Prices include VAT", "listeners": { "render": Lino.quicktip_renderer("Prices include VAT","(sales.Invoices.item_vat) Whether prices includes VAT or not.") }, "hideLabel": true, "checked": false, "name": "item_vat", "selectOnFocus": true, "anchor": "-20" });
    var more_1_panel435 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 171, "hideCheckBoxLabels": true, "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id431, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user432, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language433, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": item_vat434, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var intro440 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Introductive Text","(sales.Invoices.intro) ") }, "fieldLabel": "Introductive Text", "name": "intro", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var more_panel441 = new Ext.Panel({ "layout": "vbox", "title": "More", "items": [ more_1_panel435, { "items": intro440, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "labelWidth": 162, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var journal443 = new Lino.TwinCombo({ "fieldLabel": "Journal", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail)}, "emptyText": "Select a Journal...", "listeners": { "render": Lino.quicktip_renderer("Journal","(sales.Invoices.journal) ") }, "selectOnFocus": true, "hiddenName": "journalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/journal", "method": "GET" }) }), "name": "journal" });
    var year444 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "year", "hiddenName": "yearHidden", "listeners": { "render": Lino.quicktip_renderer("Fiscal Year","(sales.Invoices.year) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var number445 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("number","(sales.Invoices.number) ") }, "fieldLabel": "number", "anchor": "-20", "name": "number" });
    var narration446 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Narration","(sales.Invoices.narration) ") }, "fieldLabel": "Narration", "name": "narration", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var ledger_1_panel447 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": journal443, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": year444, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": number445, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": narration446, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ledger_MovementsByVoucher_grid457 = new Lino.ledger.MovementsByVoucher.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Movements","(ledger.ledger.MovementsByVoucher) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.ledger.MovementsByVoucher.grid) ], "master_panel": this });
    var ledger_panel458 = new Ext.Panel({ "layout": "vbox", "title": "Ledger", "items": [ ledger_1_panel447, ledger_MovementsByVoucher_grid457 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel459 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel430, more_panel441, ledger_panel458 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel459;
    this.before_row_edit = function(record) {
      ItemsByInvoice_grid429.on_master_changed();
      ledger_MovementsByVoucher_grid457.on_master_changed();
    }
    Lino.sales.Invoices.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.TextFieldTemplates.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 10,
  initComponent : function() {
    var containing_panel = this;
    var id187 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(system.TextFieldTemplates.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name188 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation","(system.TextFieldTemplates.name) ") }, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user189 = new Lino.TwinCombo({ "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Select a User...", "listeners": { "render": Lino.quicktip_renderer("Author","(system.TextFieldTemplates.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/user", "method": "GET" }) }) });
    var team190 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Team</span>", "name": "team", "pageSize": 20, "emptyText": "Select a Team...", "listeners": { "render": Lino.quicktip_renderer("Team","(system.TextFieldTemplates.team) If not empty, then this template is reserved to members of this team.") }, "selectOnFocus": true, "hiddenName": "teamHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/team", "method": "GET" }) }) });
    var main_1_panel191 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id187, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name188, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user189, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": team190, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 108, "border": false, "frame": false, "labelAlign": "top" });
    var description196 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(system.TextFieldTemplates.description) ") }, "fieldLabel": "Description", "name": "description", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var text197 = new Lino.RichTextPanel({ "flex": 5, "split": true, "containing_panel": this, "selectOnFocus": true, "region": "south", "title": "Template Text", "name": "text" });
    var main_panel198 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ main_1_panel191, { "flex": 5, "layout": "form", "xtype": "panel", "items": description196, "region": "center", "labelAlign": "top", "split": true }, text197 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel198;
    this.before_row_edit = function(record) {
      text197.refresh();
    }
    Lino.system.TextFieldTemplates.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.TeacherTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 68,
  initComponent : function() {
    var containing_panel = this;
    var id1610 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(courses.TeacherTypes.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1611 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation","(courses.TeacherTypes.name) ") }, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1612 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(courses.TeacherTypes.name_de) ") }, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_fr1613 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(courses.TeacherTypes.name_fr) ") }, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1614 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1610, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1611, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1612, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1613, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var courses_TeachersByType_grid1650 = new Lino.courses.TeachersByType.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Teachers","(courses.courses.TeachersByType) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.courses.TeachersByType.grid) ], "master_panel": this });
    var main_panel1651 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1614, courses_TeachersByType_grid1650 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1651;
    this.before_row_edit = function(record) {
      courses_TeachersByType_grid1650.on_master_changed();
    }
    Lino.courses.TeacherTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Journals.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 48,
  initComponent : function() {
    var containing_panel = this;
    var name1268 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation","(ledger.Journals.name) ") }, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1269 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(ledger.Journals.name_de) ") }, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_fr1270 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(ledger.Journals.name_fr) ") }, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1271 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1268, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1269, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1270, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var trade_type1275 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Trade Type", "name": "trade_type", "hiddenName": "trade_typeHidden", "listeners": { "render": Lino.quicktip_renderer("Trade Type","(ledger.Journals.trade_type) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.vat.TradeTypes) });
    var voucher_type1276 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "voucher type", "allowBlank": false, "hiddenName": "voucher_typeHidden", "listeners": { "render": Lino.quicktip_renderer("voucher type","(ledger.Journals.voucher_type) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.ledger.VoucherTypes, "name": "voucher_type" });
    var main_panel1277 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 117, "autoScroll": false, "items": [ main_1_panel1271, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": trade_type1275, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": voucher_type1276, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1277;
    this.before_row_edit = function(record) {
    }
    Lino.ledger.Journals.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.Uploads.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 32,
  initComponent : function() {
    var containing_panel = this;
    var file1145 = Lino.file_field_handler(this,{ "listeners": { "render": Lino.quicktip_renderer("File","(uploads.Uploads.file) ") }, "fieldLabel": "File", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user1146 = new Lino.TwinCombo({ "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Select a User...", "listeners": { "render": Lino.quicktip_renderer("Author","(uploads.Uploads.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel1147 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file1145, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1146, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type1150 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Upload Type", "name": "type", "pageSize": 20, "emptyText": "Select a Upload Type...", "listeners": { "render": Lino.quicktip_renderer("Upload Type","(uploads.Uploads.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var description1151 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Description","(uploads.Uploads.description) ") }, "fieldLabel": "Description", "name": "description", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel1152 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1150, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": description1151, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var modified1155 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Modified","(uploads.Uploads.modified) ") }, "fieldLabel": "Modified", "name": "modified", "anchor": "-20", "value": "<br>" });
    var created1156 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Created","(uploads.Uploads.created) ") }, "fieldLabel": "Created", "name": "created", "anchor": "-20", "value": "<br>" });
    var owner_disp1157 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Controlled by", "anchor": "-20", "name": "owner" });
    var main_3_panel1158 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1155, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1156, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp1157, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1162 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1147, main_2_panel1152, main_3_panel1158 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1162;
    this.before_row_edit = function(record) {
    }
    Lino.uploads.Uploads.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.sales.Invoices.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 59,
  initComponent : function() {
    var containing_panel = this;
    var partner460 = new Lino.TwinCombo({ "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Select a Partner...", "listeners": { "render": Lino.quicktip_renderer("Partner","(sales.Invoices.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/partner", "method": "GET" }) }), "name": "partner" });
    var date461 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Date","(sales.Invoices.date) ") }, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel462 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner460, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date461, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var subject465 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Subject line","(sales.Invoices.subject) ") }, "fieldLabel": "Subject line", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_panel466 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 117, "autoScroll": false, "items": [ main_1_panel462, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject465, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel466;
    this.before_row_edit = function(record) {
    }
    Lino.sales.Invoices.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.Mails.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 41,
  initComponent : function() {
    var containing_panel = this;
    var subject742 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Subject","(outbox.Mails.subject) ") }, "fieldLabel": "Subject", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var project743 = new Lino.TwinCombo({ "fieldLabel": "Course", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.Courses.detail)}, "emptyText": "Select a Course...", "listeners": { "render": Lino.quicktip_renderer("Course","(outbox.Mails.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var date744 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Date","(outbox.Mails.date) \n        The official date to be printed on the document.\n        ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Date</span>", "name": "date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel745 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject742, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project743, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date744, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user749 = new Lino.TwinCombo({ "fieldLabel": "Sender", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Select a User...", "listeners": { "render": Lino.quicktip_renderer("Sender","(outbox.Mails.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/user", "method": "GET" }) }) });
    var sent750 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("sent","(outbox.Mails.sent) ") }, "fieldLabel": "sent", "name": "sent", "anchor": "-20", "value": "<br>" });
    var id751 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(outbox.Mails.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var owner_disp752 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Controlled by", "anchor": "-20", "name": "owner" });
    var main_2_panel753 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user749, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent750, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id751, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp752, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var RecipientsByMail_grid764 = new Lino.outbox.RecipientsByMail.GridPanel({ "flex": 55, "listeners": { "render": Lino.quicktip_renderer("Recipients","(outbox.outbox.RecipientsByMail) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.RecipientsByMail.grid) ], "master_panel": this });
    var AttachmentsByMail_htmlbox765 = new Lino.HtmlBoxPanel({ "flex": 22, "layout": "fit", "name": "AttachmentsByMail", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Attachments", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Attachments","(outbox.Mails.AttachmentsByMail) ") }, "bodyStyle": "overflow-x:hidden", "tools": [ Lino.show_in_own_window_button(Lino.outbox.AttachmentsByMail.grid) ] });
    var UploadsByController_htmlbox766 = new Lino.HtmlBoxPanel({ "flex": 22, "ls_bbar_actions": [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Uploads","(outbox.Mails.UploadsByController) ") }, "bodyStyle": "overflow-x:hidden", "ls_insert_handler": Lino.uploads.UploadsByController.insert, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var main_3_panel767 = new Ext.Panel({ "flex": 29, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ RecipientsByMail_grid764, AttachmentsByMail_htmlbox765, UploadsByController_htmlbox766 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var body768 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 58, "containing_panel": this, "name": "body", "title": "Body" });
    var main_panel769 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel745, main_2_panel753, main_3_panel767, body768 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel769;
    this.before_row_edit = function(record) {
      RecipientsByMail_grid764.on_master_changed();
      AttachmentsByMail_htmlbox765.refresh();
      UploadsByController_htmlbox766.refresh();
      body768.refresh();
    }
    Lino.outbox.Mails.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.Home.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var quick_links_htmlbox1717 = new Lino.HtmlBoxPanel({ "flex": 1, "layout": "fit", "name": "quick_links", "containing_panel": this, "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "north", "bodyStyle": "overflow-x:hidden", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer(null,"(system.Home.quick_links) ") }, "split": true });
    var welcome_htmlbox1718 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "welcome", "containing_panel": this, "master_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "center", "title": "Welcome", "bodyStyle": "overflow-x:hidden", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Welcome","(system.Home.welcome) ") }, "split": true });
    var main_panel1719 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ quick_links_htmlbox1717, welcome_htmlbox1718 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1719;
    this.before_row_edit = function(record) {
      quick_links_htmlbox1717.refresh();
      welcome_htmlbox1718.refresh();
    }
    Lino.system.Home.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Events.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 39,
  initComponent : function() {
    var containing_panel = this;
    var calendar951 = new Lino.TwinCombo({ "fieldLabel": "Calendar", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Select a Calendar...", "listeners": { "render": Lino.quicktip_renderer("Calendar","(cal.Events.calendar) ") }, "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/calendar", "method": "GET" }) }) });
    var summary952 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Summary","(cal.Events.summary) ") }, "fieldLabel": "Summary", "name": "summary", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var user953 = new Lino.TwinCombo({ "fieldLabel": "Responsible user", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Select a User...", "listeners": { "render": Lino.quicktip_renderer("Responsible user","(cal.Events.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }) });
    var project954 = new Lino.TwinCombo({ "fieldLabel": "Course", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.Courses.detail)}, "emptyText": "Select a Course...", "listeners": { "render": Lino.quicktip_renderer("Course","(cal.Events.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }) });
    var general_1_panel955 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar951, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary952, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user953, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project954, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var start_date960 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start date","(cal.Events.start_date) ") }, "fieldLabel": "Start date", "anchor": "-20", "name": "start_date" });
    var start_time961 = new Lino.TimeField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start time","(cal.Events.start_time) ") }, "fieldLabel": "Start time", "anchor": "-20", "name": "start_time" });
    var start_panel962 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date960, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time961, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var end_date965 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("End Date","(cal.Events.end_date) ") }, "fieldLabel": "End Date", "anchor": "-20", "name": "end_date" });
    var end_time966 = new Lino.TimeField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("End Time","(cal.Events.end_time) ") }, "fieldLabel": "End Time", "anchor": "-20", "name": "end_time" });
    var end_panel967 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date965, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time966, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var general_2_panel970 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ start_panel962, end_panel967 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var room971 = new Lino.TwinCombo({ "fieldLabel": "Room", "name": "room", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Rooms.detail)}, "emptyText": "Select a Room...", "listeners": { "render": Lino.quicktip_renderer("Room","(cal.Events.room) ") }, "selectOnFocus": true, "hiddenName": "roomHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/room", "method": "GET" }) }) });
    var priority972 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Priority", "name": "priority", "pageSize": 20, "emptyText": "Select a Priority...", "listeners": { "render": Lino.quicktip_renderer("Priority","(cal.Events.priority) ") }, "selectOnFocus": true, "hiddenName": "priorityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/priority", "method": "GET" }) }) });
    var access_class973 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Access Class</span>", "name": "access_class", "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Access Class","(cal.Events.access_class) Whether this is private, public or between.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var transparent974 = new Ext.form.Checkbox({ "boxLabel": "Transparent", "listeners": { "render": Lino.quicktip_renderer("Transparent","(cal.Events.transparent) Indicates that this Event shouldn't prevent other Events at the same time.") }, "hideLabel": true, "checked": false, "name": "transparent", "selectOnFocus": true, "anchor": "-20" });
    var general_3_panel975 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": room971, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": priority972, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class973, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": transparent974, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var owner_disp980 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Controlled by", "anchor": "-20", "name": "owner" });
    var workflow_buttons_disp981 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Workflow","(cal.Events.workflow_buttons) ") }, "fieldLabel": "Workflow", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var general_4_panel982 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp980, "labelAlign": "top" }, { "flex": 75, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp981, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description985 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 46, "containing_panel": this, "name": "description", "title": "Description" });
    var cal_GuestsByEvent_grid1026 = new Lino.cal.GuestsByEvent.GridPanel({ "flex": 53, "listeners": { "render": Lino.quicktip_renderer("Guests","(cal.cal.GuestsByEvent) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.GuestsByEvent.grid) ], "master_panel": this });
    var general_5_panel1027 = new Ext.Panel({ "flex": 45, "border": false, "layout": "hbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ description985, cal_GuestsByEvent_grid1026 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel1028 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel955, general_2_panel970, general_3_panel975, general_4_panel982, general_5_panel1027 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var id1029 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.Events.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var created1030 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Created","(cal.Events.created) ") }, "fieldLabel": "Created", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified1031 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Modified","(cal.Events.modified) ") }, "fieldLabel": "Modified", "name": "modified", "anchor": "-20", "value": "<br>" });
    var more_1_panel1032 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1029, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1030, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1031, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var outbox_MailsByController_grid1036 = new Lino.outbox.MailsByController.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Outgoing Mails","(outbox.outbox.MailsByController) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ], "master_panel": this });
    var more_panel1037 = new Ext.Panel({ "layout": "vbox", "title": "More", "items": [ more_1_panel1032, outbox_MailsByController_grid1036 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel1038 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1028, more_panel1037 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1038;
    this.before_row_edit = function(record) {
      description985.refresh();
      cal_GuestsByEvent_grid1026.on_master_changed();
      outbox_MailsByController_grid1036.on_master_changed();
    }
    Lino.cal.Events.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Events.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 39,
  initComponent : function() {
    var containing_panel = this;
    var summary1039 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Summary","(cal.Events.summary) ") }, "fieldLabel": "Summary", "name": "summary", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var start_date1040 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start date","(cal.Events.start_date) ") }, "fieldLabel": "Start date", "anchor": "-20", "name": "start_date" });
    var start_time1041 = new Lino.TimeField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start time","(cal.Events.start_time) ") }, "fieldLabel": "Start time", "anchor": "-20", "name": "start_time" });
    var start_panel1042 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1040, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time1041, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var end_date1045 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("End Date","(cal.Events.end_date) ") }, "fieldLabel": "End Date", "anchor": "-20", "name": "end_date" });
    var end_time1046 = new Lino.TimeField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("End Time","(cal.Events.end_time) ") }, "fieldLabel": "End Time", "anchor": "-20", "name": "end_time" });
    var end_panel1047 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1045, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time1046, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var main_2_panel1050 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ start_panel1042, end_panel1047 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "anchor": "-20", "labelAlign": "top" });
    var calendar1051 = new Lino.TwinCombo({ "fieldLabel": "Calendar", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Select a Calendar...", "listeners": { "render": Lino.quicktip_renderer("Calendar","(cal.Events.calendar) ") }, "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/calendar", "method": "GET" }) }) });
    var project1052 = new Lino.TwinCombo({ "fieldLabel": "Course", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.Courses.detail)}, "emptyText": "Select a Course...", "listeners": { "render": Lino.quicktip_renderer("Course","(cal.Events.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }) });
    var main_3_panel1053 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar1051, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1052, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1056 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary1039, "anchor": "-20", "labelAlign": "top" }, main_2_panel1050, main_3_panel1053 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1056;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Events.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.Users.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 12,
  initComponent : function() {
    var containing_panel = this;
    var username108 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Username","(users.Users.username) \n        Required. Must be unique. \n        ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Username</span>", "name": "username", "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var email109 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("e-mail address","(users.Users.email) ") }, "fieldLabel": "e-mail address", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel110 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username108, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email109, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name113 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("First name","(users.Users.first_name) ") }, "fieldLabel": "First name", "name": "first_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var last_name114 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Last name","(users.Users.last_name) ") }, "fieldLabel": "Last name", "name": "last_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel115 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name113, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name114, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var partner118 = new Lino.TwinCombo({ "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Select a Partner...", "listeners": { "render": Lino.quicktip_renderer("Partner","(users.Users.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var language119 = new Lino.ChoicesFieldElement({ "fieldLabel": "Language", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(users.Users.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var profile120 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "User Profile", "name": "profile", "hiddenName": "profileHidden", "listeners": { "render": Lino.quicktip_renderer("User Profile","(users.Users.profile) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var main_4_panel121 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 47, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language119, "labelAlign": "top" }, { "flex": 52, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile120, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel124 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ main_1_panel110, main_2_panel115, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner118, "anchor": "-20", "labelAlign": "top" }, main_4_panel121 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel124;
    this.before_row_edit = function(record) {
    }
    Lino.users.Users.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.Courses.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 65,
  initComponent : function() {
    var containing_panel = this;
    var line1448 = new Lino.TwinCombo({ "fieldLabel": "Course Line", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.Lines.detail)}, "emptyText": "Select a Course Line...", "listeners": { "render": Lino.quicktip_renderer("Course Line","(courses.Courses.line) ") }, "selectOnFocus": true, "hiddenName": "lineHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/Courses/line", "method": "GET" }) }), "name": "line" });
    var teacher1449 = new Lino.TwinCombo({ "fieldLabel": "Teacher", "name": "teacher", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.Teachers.detail)}, "emptyText": "Select a Teacher...", "listeners": { "render": Lino.quicktip_renderer("Teacher","(courses.Courses.teacher) ") }, "selectOnFocus": true, "hiddenName": "teacherHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/Courses/teacher", "method": "GET" }) }) });
    var start_date1450 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start date","(courses.Courses.start_date) ") }, "fieldLabel": "Start date", "anchor": "-20", "name": "start_date" });
    var start_time1451 = new Lino.TimeField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start time","(courses.Courses.start_time) ") }, "fieldLabel": "Start time", "anchor": "-20", "name": "start_time" });
    var room1452 = new Lino.TwinCombo({ "fieldLabel": "Room", "name": "room", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Rooms.detail)}, "emptyText": "Select a Room...", "listeners": { "render": Lino.quicktip_renderer("Room","(courses.Courses.room) ") }, "selectOnFocus": true, "hiddenName": "roomHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/Courses/room", "method": "GET" }) }) });
    var state1453 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "State", "allowBlank": false, "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("State","(courses.Courses.state) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.courses.CourseStates, "name": "state" });
    var id1454 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(courses.Courses.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var general_1_panel1455 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": line1448, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": teacher1449, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1450, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time1451, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": room1452, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state1453, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1454, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var max_places1463 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Places","(courses.Courses.max_places) Maximal number of participants") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Places</span>", "anchor": "-20", "name": "max_places" });
    var max_events1464 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Number of events","(courses.Courses.max_events) ") }, "fieldLabel": "Number of events", "anchor": "-20", "name": "max_events" });
    var end_date1465 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("End Date","(courses.Courses.end_date) ") }, "fieldLabel": "End Date", "anchor": "-20", "name": "end_date" });
    var end_time1466 = new Lino.TimeField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("End Time","(courses.Courses.end_time) ") }, "fieldLabel": "End Time", "anchor": "-20", "name": "end_time" });
    var every_unit1467 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Recurrency", "name": "every_unit", "hiddenName": "every_unitHidden", "listeners": { "render": Lino.quicktip_renderer("Recurrency","(courses.Courses.every_unit) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.Recurrencies) });
    var every1468 = new Ext.form.NumberField({ "listeners": { "render": Lino.quicktip_renderer("Repeat every","(courses.Courses.every) ") }, "fieldLabel": "Repeat every", "name": "every", "selectOnFocus": true, "anchor": "-20", "value": 0, "allowBlank": false });
    var general_2_panel1469 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": max_places1463, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": max_events1464, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1465, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time1466, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": every_unit1467, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": every1468, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var monday1476 = new Ext.form.Checkbox({ "boxLabel": "Monday", "listeners": { "render": Lino.quicktip_renderer("Monday","(courses.Courses.monday) ") }, "hideLabel": true, "checked": false, "name": "monday", "selectOnFocus": true, "anchor": "-20" });
    var tuesday1477 = new Ext.form.Checkbox({ "boxLabel": "Tuesday", "listeners": { "render": Lino.quicktip_renderer("Tuesday","(courses.Courses.tuesday) ") }, "hideLabel": true, "checked": false, "name": "tuesday", "selectOnFocus": true, "anchor": "-20" });
    var wednesday1478 = new Ext.form.Checkbox({ "boxLabel": "Wednesday", "listeners": { "render": Lino.quicktip_renderer("Wednesday","(courses.Courses.wednesday) ") }, "hideLabel": true, "checked": false, "name": "wednesday", "selectOnFocus": true, "anchor": "-20" });
    var thursday1479 = new Ext.form.Checkbox({ "boxLabel": "Thursday", "listeners": { "render": Lino.quicktip_renderer("Thursday","(courses.Courses.thursday) ") }, "hideLabel": true, "checked": false, "name": "thursday", "selectOnFocus": true, "anchor": "-20" });
    var friday1480 = new Ext.form.Checkbox({ "boxLabel": "Friday", "listeners": { "render": Lino.quicktip_renderer("Friday","(courses.Courses.friday) ") }, "hideLabel": true, "checked": false, "name": "friday", "selectOnFocus": true, "anchor": "-20" });
    var saturday1481 = new Ext.form.Checkbox({ "boxLabel": "Saturday", "listeners": { "render": Lino.quicktip_renderer("Saturday","(courses.Courses.saturday) ") }, "hideLabel": true, "checked": false, "name": "saturday", "selectOnFocus": true, "anchor": "-20" });
    var sunday1482 = new Ext.form.Checkbox({ "boxLabel": "Sunday", "listeners": { "render": Lino.quicktip_renderer("Sunday","(courses.Courses.sunday) ") }, "hideLabel": true, "checked": false, "name": "sunday", "selectOnFocus": true, "anchor": "-20" });
    var general_3_panel1483 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": monday1476, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": tuesday1477, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": wednesday1478, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": thursday1479, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": friday1480, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": saturday1481, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sunday1482, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var company1491 = new Lino.TwinCombo({ "fieldLabel": "Organizer", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "emptyText": "Select a Company...", "listeners": { "render": Lino.quicktip_renderer("Organizer","(courses.Courses.company) ") }, "selectOnFocus": true, "hiddenName": "companyHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/Courses/company", "method": "GET" }) }) });
    var contact_person1492 = new Lino.TwinCombo({ "fieldLabel": "Contact person", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail)}, "emptyText": "Select a Person...", "listeners": { "render": Lino.quicktip_renderer("Contact person","(courses.Courses.contact_person) ") }, "selectOnFocus": true, "hiddenName": "contact_personHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/Courses/contact_person", "method": "GET" }) }) });
    var user1493 = new Lino.TwinCombo({ "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Select a User...", "listeners": { "render": Lino.quicktip_renderer("Author","(courses.Courses.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/Courses/user", "method": "GET" }) }) });
    var calendar1494 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Calendar</span>", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Select a Calendar...", "listeners": { "render": Lino.quicktip_renderer("Calendar","(courses.Courses.calendar) The calendar to which events will be generated.") }, "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/courses/Courses/calendar", "method": "GET" }) }) });
    var general_4_panel1495 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company1491, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person1492, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1493, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar1494, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var courses_EnrolmentsByCourse_grid1545 = new Lino.courses.EnrolmentsByCourse.GridPanel({ "flex": 55, "listeners": { "render": Lino.quicktip_renderer("Enrolments","(courses.courses.EnrolmentsByCourse) ") }, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.courses.EnrolmentsByCourse.grid) ], "master_panel": this });
    var general_panel1546 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel1455, general_2_panel1469, general_3_panel1483, general_4_panel1495, courses_EnrolmentsByCourse_grid1545 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var cal_EventsByController_grid1552 = new Lino.cal.EventsByController.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "params_panel_hidden": true, "hide_top_toolbar": true, "containing_panel": this, "title": "Events", "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByController.grid) ], "master_panel": this });
    var main_panel1553 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1546, cal_EventsByController_grid1552 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1553;
    this.before_row_edit = function(record) {
      contact_person1492.setContextValue('company',record ? record.data['companyHidden'] : undefined);
      courses_EnrolmentsByCourse_grid1545.on_master_changed();
      cal_EventsByController_grid1552.on_master_changed();
    }
    this.onRender = function(ct, position) {
      company1491.on('change',Lino.chooser_handler(contact_person1492,'company'));
      Lino.courses.Courses.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.courses.Courses.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Invoices.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 50,
  initComponent : function() {
    var containing_panel = this;
    var partner1330 = new Lino.TwinCombo({ "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Select a Partner...", "listeners": { "render": Lino.quicktip_renderer("Partner","(ledger.Invoices.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/partner", "method": "GET" }) }), "name": "partner" });
    var date1331 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Date","(ledger.Invoices.date) ") }, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var total_incl1332 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Total incl. VAT", "name": "total_incl", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Total incl. VAT","(ledger.Invoices.total_incl) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var main_2_panel1333 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date1331, "labelAlign": "top" }, { "flex": 60, "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_incl1332, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 144, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1336 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1330, "anchor": "-20", "labelAlign": "top" }, main_2_panel1333 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1336;
    this.before_row_edit = function(record) {
    }
    Lino.ledger.Invoices.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.Uploads.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 32,
  initComponent : function() {
    var containing_panel = this;
    var file1163 = Lino.file_field_handler(this,{ "listeners": { "render": Lino.quicktip_renderer("File","(uploads.Uploads.file) ") }, "fieldLabel": "File", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user1164 = new Lino.TwinCombo({ "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Select a User...", "listeners": { "render": Lino.quicktip_renderer("Author","(uploads.Uploads.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel1165 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file1163, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1164, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type1168 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Upload Type", "name": "type", "pageSize": 20, "emptyText": "Select a Upload Type...", "listeners": { "render": Lino.quicktip_renderer("Upload Type","(uploads.Uploads.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var description1169 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Description","(uploads.Uploads.description) ") }, "fieldLabel": "Description", "name": "description", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel1170 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1168, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": description1169, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1173 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1165, main_2_panel1170 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1173;
    this.before_row_edit = function(record) {
    }
    Lino.uploads.Uploads.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.courses.Topics.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 67,
  initComponent : function() {
    var containing_panel = this;
    var id1564 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(courses.Topics.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1565 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation","(courses.Topics.name) ") }, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1566 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(courses.Topics.name_de) ") }, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_fr1567 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(courses.Topics.name_fr) ") }, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1568 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1564, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1565, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1566, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1567, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 153, "border": false, "frame": false, "labelAlign": "top" });
    var courses_LinesByTopic_grid1601 = new Lino.courses.LinesByTopic.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Course Lines","(courses.courses.LinesByTopic) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.courses.LinesByTopic.grid) ] });
    var courses_CoursesByTopic_grid1608 = new Lino.courses.CoursesByTopic.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Courses","(courses.courses.CoursesByTopic) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.courses.CoursesByTopic.grid) ] });
    var main_panel1609 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "hideCheckBoxLabels": true, "items": [ main_1_panel1568, courses_LinesByTopic_grid1601, courses_CoursesByTopic_grid1608 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1609;
    this.before_row_edit = function(record) {
      courses_LinesByTopic_grid1601.on_master_changed();
      courses_CoursesByTopic_grid1608.on_master_changed();
    }
    Lino.courses.Topics.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.Models.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var app_disp1695 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("app_label","(about.Models.app) ") }, "fieldLabel": "app_label", "name": "app", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var name_disp1696 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("name","(about.Models.name) ") }, "fieldLabel": "name", "name": "name", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var docstring_disp1697 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("docstring","(about.Models.docstring) ") }, "fieldLabel": "docstring", "name": "docstring", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var rows1698 = new Ext.form.NumberField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Rows","(about.Models.rows) ") }, "fieldLabel": "Rows", "anchor": "-20", "name": "rows" });
    var main_1_panel1699 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_disp1695, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_disp1696, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": docstring_disp1697, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": rows1698, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var about_FieldsByModel_grid1708 = new Lino.about.FieldsByModel.GridPanel({ "flex": 62, "listeners": { "render": Lino.quicktip_renderer("Fields","(about.about.FieldsByModel) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.about.FieldsByModel.grid) ], "master_panel": this });
    var main_panel1709 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1699, about_FieldsByModel_grid1708 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1709;
    this.before_row_edit = function(record) {
      about_FieldsByModel_grid1708.on_master_changed();
    }
    Lino.about.Models.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 20,
  initComponent : function() {
    var containing_panel = this;
    var last_name486 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Last name","(contacts.Persons.last_name) ") }, "fieldLabel": "Last name", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var first_name487 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("First name","(contacts.Persons.first_name) ") }, "fieldLabel": "First name", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box1_1_panel488 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name486, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name487, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var country491 = new Lino.TwinCombo({ "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Country","(contacts.Persons.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/country", "method": "GET" }) }) });
    var city492 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Place","(contacts.Persons.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/city", "method": "GET" }) }) });
    var zip_code493 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Zip code","(contacts.Persons.zip_code) ") }, "fieldLabel": "Zip code", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box1_2_panel494 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country491, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city492, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code493, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street498 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Street","(contacts.Persons.street) Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no499 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("No.","(contacts.Persons.street_no) House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box500 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","(contacts.Persons.street_box) Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box1_3_panel501 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 53, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street498, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no499, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box500, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2505 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Address line after street","(contacts.Persons.addr2) Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line after street</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var is_pupil506 = new Ext.form.Checkbox({ "boxLabel": "is a pupil (<a href=\"javascript:Lino.show_mti_child('is_pupil',Lino.courses.Pupils.detail)\">show</a>)", "listeners": { "render": Lino.quicktip_renderer("is a pupil","(contacts.Persons.is_pupil) ") }, "hideLabel": true, "name": "is_pupil", "selectOnFocus": true, "anchor": "-20" });
    var is_teacher507 = new Ext.form.Checkbox({ "boxLabel": "is a teacher (<a href=\"javascript:Lino.show_mti_child('is_teacher',Lino.courses.Teachers.detail)\">show</a>)", "listeners": { "render": Lino.quicktip_renderer("is a teacher","(contacts.Persons.is_teacher) ") }, "hideLabel": true, "name": "is_teacher", "selectOnFocus": true, "anchor": "-20" });
    var box1_5_panel508 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_pupil506, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_teacher507, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box1_panel511 = new Ext.Panel({ "flex": 54, "autoHeight": true, "layout": "form", "items": [ box1_1_panel488, box1_2_panel494, box1_3_panel501, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2505, "anchor": "-20", "labelAlign": "top" }, box1_5_panel508 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 234, "border": false, "labelAlign": "top" });
    var id513 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Persons.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language514 = new Lino.ChoicesFieldElement({ "fieldLabel": "Language", "allowBlank": false, "value": "en", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(contacts.Persons.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var box2_1_panel515 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id513, "labelAlign": "top" }, { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language514, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email518 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Persons.email) ") }, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var phone519 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Phone","(contacts.Persons.phone) ") }, "fieldLabel": "Phone", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var fax520 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Fax","(contacts.Persons.fax) ") }, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box2_3_panel521 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone519, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax520, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 54, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gsm524 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("GSM","(contacts.Persons.gsm) ") }, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gender525 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Gender", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Gender","(contacts.Persons.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var birth_date526 = new Lino.IncompleteDateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Birth date","(contacts.Persons.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Birth date</span>", "anchor": "-20", "name": "birth_date" });
    var age_disp527 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Age","(contacts.Persons.age) ") }, "fieldLabel": "Age", "name": "age", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var box2_5_panel528 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender525, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date526, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": age_disp527, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box2_panel532 = new Ext.Panel({ "flex": 45, "autoHeight": true, "layout": "form", "items": [ box2_1_panel515, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email518, "anchor": "-20", "labelAlign": "top" }, box2_3_panel521, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm524, "anchor": "-20", "labelAlign": "top" }, box2_5_panel528 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var main_1_panel535 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box1_panel511, box2_panel532 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks536 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remarks","(contacts.Persons.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var contacts_RolesByPerson_grid541 = new Lino.contacts.RolesByPerson.GridPanel({ "flex": 27, "listeners": { "render": Lino.quicktip_renderer("Contact for","(contacts.contacts.RolesByPerson) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByPerson.grid) ], "master_panel": this });
    var households_MembersByPerson_grid548 = new Lino.households.MembersByPerson.GridPanel({ "flex": 36, "listeners": { "render": Lino.quicktip_renderer("Member of","(households.households.MembersByPerson) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByPerson.grid) ], "master_panel": this });
    var main_2_panel549 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": remarks536, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 36 }, contacts_RolesByPerson_grid541, households_MembersByPerson_grid548 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel551 = new Ext.form.FieldSet({ "layout": "vbox", "title": "Contact", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ main_1_panel535, main_2_panel549 ], "autoScroll": false, "border": false, "labelAlign": "top" });
    this.items = main_panel551;
    this.before_row_edit = function(record) {
      city492.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city492.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByPerson_grid541.on_master_changed();
      households_MembersByPerson_grid548.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country491.on('change',Lino.chooser_handler(city492,'country'));
      Lino.contacts.Persons.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Persons.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.TextFieldTemplates.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 10,
  initComponent : function() {
    var containing_panel = this;
    var name200 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation","(system.TextFieldTemplates.name) ") }, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user201 = new Lino.TwinCombo({ "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Select a User...", "listeners": { "render": Lino.quicktip_renderer("Author","(system.TextFieldTemplates.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/user", "method": "GET" }) }) });
    var team202 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Team</span>", "name": "team", "pageSize": 20, "emptyText": "Select a Team...", "listeners": { "render": Lino.quicktip_renderer("Team","(system.TextFieldTemplates.team) If not empty, then this template is reserved to members of this team.") }, "selectOnFocus": true, "hiddenName": "teamHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/team", "method": "GET" }) }) });
    var main_2_panel203 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user201, "labelAlign": "top" }, { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": team202, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel206 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 108, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name200, "anchor": "-20", "labelAlign": "top" }, main_2_panel203 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel206;
    this.before_row_edit = function(record) {
    }
    Lino.system.TextFieldTemplates.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Calendars.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 38,
  initComponent : function() {
    var containing_panel = this;
    var type873 = new Lino.ChoicesFieldElement({ "fieldLabel": "Type", "allowBlank": false, "value": "local", "hiddenName": "typeHidden", "listeners": { "render": Lino.quicktip_renderer("Type","(cal.Calendars.type) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "local", "Local Calendar" ], [ "google", "Google Calendar" ] ], "name": "type" });
    var name874 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation","(cal.Calendars.name) ") }, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de875 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(cal.Calendars.name_de) ") }, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_fr876 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(cal.Calendars.name_fr) ") }, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var id877 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.Calendars.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_1_panel878 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type873, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name874, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de875, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr876, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id877, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var url_template884 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("URL template","(cal.Calendars.url_template) ") }, "fieldLabel": "URL template", "name": "url_template", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var username885 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Username","(cal.Calendars.username) ") }, "fieldLabel": "Username", "name": "username", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var password886 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Password","(cal.Calendars.password) ") }, "fieldLabel": "Password", "name": "password", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "inputType": "password" });
    var main_2_panel887 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": url_template884, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username885, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": password886, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var readonly891 = new Ext.form.Checkbox({ "boxLabel": "read-only", "listeners": { "render": Lino.quicktip_renderer("read-only","(cal.Calendars.readonly) ") }, "hideLabel": true, "checked": false, "name": "readonly", "selectOnFocus": true, "anchor": "-20" });
    var color892 = new Ext.form.NumberField({ "listeners": { "render": Lino.quicktip_renderer("color","(cal.Calendars.color) ") }, "fieldLabel": "color", "name": "color", "selectOnFocus": true, "anchor": "-20", "value": 1, "allowBlank": false });
    var start_date893 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start date","(cal.Calendars.start_date) ") }, "fieldLabel": "Start date", "anchor": "-20", "name": "start_date" });
    var main_3_panel894 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": readonly891, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": color892, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date893, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var build_method898 = new Lino.ChoicesFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Build method","(cal.Calendars.build_method) ") }, "fieldLabel": "Build method", "name": "build_method", "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "hiddenName": "build_methodHidden" });
    var template899 = new Lino.SimpleRemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Template","(cal.Calendars.template) ") }, "fieldLabel": "Template", "name": "template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/template", "method": "GET" }) }) });
    var email_template900 = new Lino.SimpleRemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Email template","(cal.Calendars.email_template) The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Email template</span>", "name": "email_template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/email_template", "method": "GET" }) }) });
    var attach_to_email901 = new Ext.form.Checkbox({ "boxLabel": "Attach to email", "listeners": { "render": Lino.quicktip_renderer("Attach to email","(cal.Calendars.attach_to_email) Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "hideLabel": true, "checked": false, "name": "attach_to_email", "selectOnFocus": true, "anchor": "-20" });
    var main_4_panel902 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method898, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template899, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template900, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email901, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var EventsByCalendar_grid1058 = new Lino.cal.EventsByCalendar.GridPanel({ "flex": 80, "listeners": { "render": Lino.quicktip_renderer("Events","(cal.cal.EventsByCalendar) ") }, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByCalendar.grid) ], "master_panel": this });
    var SubscriptionsByCalendar_grid1063 = new Lino.cal.SubscriptionsByCalendar.GridPanel({ "flex": 20, "listeners": { "render": Lino.quicktip_renderer("Subscriptions","(cal.cal.SubscriptionsByCalendar) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.SubscriptionsByCalendar.grid) ], "master_panel": this });
    var main_5_panel1064 = new Ext.Panel({ "flex": 55, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ EventsByCalendar_grid1058, SubscriptionsByCalendar_grid1063 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel1065 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel878, main_2_panel887, main_3_panel894, main_4_panel902, main_5_panel1064 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1065;
    this.before_row_edit = function(record) {
      template899.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      EventsByCalendar_grid1058.on_master_changed();
      SubscriptionsByCalendar_grid1063.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method898.on('change',Lino.chooser_handler(template899,'build_method'));
      Lino.cal.Calendars.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.cal.Calendars.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 20,
  initComponent : function() {
    var containing_panel = this;
    var title552 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Title","(contacts.Persons.title) ") }, "fieldLabel": "Title", "name": "title", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var first_name553 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("First name","(contacts.Persons.first_name) ") }, "fieldLabel": "First name", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var last_name554 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Last name","(contacts.Persons.last_name) ") }, "fieldLabel": "Last name", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel555 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title552, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name553, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name554, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gender559 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Gender", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Gender","(contacts.Persons.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var language560 = new Lino.ChoicesFieldElement({ "fieldLabel": "Language", "allowBlank": false, "value": "en", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(contacts.Persons.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var main_2_panel561 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender559, "labelAlign": "top" }, { "flex": 68, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language560, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel564 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel555, main_2_panel561 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel564;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Persons.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 33,
  initComponent : function() {
    var containing_panel = this;
    var start_date70 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start date","(cal.Tasks.start_date) ") }, "fieldLabel": "Start date", "anchor": "-20", "name": "start_date" });
    var due_date71 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Due date","(cal.Tasks.due_date) ") }, "fieldLabel": "Due date", "anchor": "-20", "name": "due_date" });
    var id72 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.Tasks.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var workflow_buttons_disp73 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Workflow","(cal.Tasks.workflow_buttons) ") }, "fieldLabel": "Workflow", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel74 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date70, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": due_date71, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id72, "labelAlign": "top" }, { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp73, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var summary79 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Summary","(cal.Tasks.summary) ") }, "fieldLabel": "Summary", "name": "summary", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var user80 = new Lino.TwinCombo({ "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Select a User...", "listeners": { "render": Lino.quicktip_renderer("Author","(cal.Tasks.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var project81 = new Lino.TwinCombo({ "fieldLabel": "Course", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.courses.Courses.detail)}, "emptyText": "Select a Course...", "listeners": { "render": Lino.quicktip_renderer("Course","(cal.Tasks.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_3_panel82 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 63, "hideCheckBoxLabels": true, "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user80, "labelAlign": "top" }, { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project81, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var calendar85 = new Lino.TwinCombo({ "fieldLabel": "Calendar", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Select a Calendar...", "listeners": { "render": Lino.quicktip_renderer("Calendar","(cal.Tasks.calendar) ") }, "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/calendar", "method": "GET" }) }) });
    var owner_disp86 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Controlled by", "anchor": "-20", "name": "owner" });
    var created87 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Created","(cal.Tasks.created) ") }, "fieldLabel": "Created", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified88 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Modified","(cal.Tasks.modified) ") }, "fieldLabel": "Modified", "name": "modified", "anchor": "-20", "value": "<br>" });
    var main_4_panel89 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar85, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp86, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created87, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified88, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description94 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 45, "containing_panel": this, "name": "description", "title": "Description" });
    var main_panel95 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ main_1_panel74, { "items": summary79, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, main_3_panel82, main_4_panel89, description94 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel95;
    this.before_row_edit = function(record) {
      description94.refresh();
    }
    Lino.cal.Tasks.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Countries.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 15,
  initComponent : function() {
    var containing_panel = this;
    var isocode208 = new Ext.form.TextField({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">ISO code</span>", "name": "isocode", "boxMinWidth": Lino.chars2width(4), "listeners": { "render": Lino.quicktip_renderer("ISO code","(countries.Countries.isocode)         The two-letter code for this country as defined by ISO 3166-1. \n        For countries that no longer exist it may be a 4-letter code.") }, "maxLength": 4, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name209 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation","(countries.Countries.name) ") }, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de210 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(countries.Countries.name_de) ") }, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_fr211 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(countries.Countries.name_fr) ") }, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var short_code212 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Short code","(countries.Countries.short_code) A short abbreviation for regional usage. Obsolete.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Short code</span>", "name": "short_code", "maxLength": 4, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var main_1_panel213 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": isocode208, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name209, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de210, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr211, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": short_code212, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var countries_CitiesByCountry_grid484 = new Lino.countries.CitiesByCountry.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Places","(countries.countries.CitiesByCountry) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.countries.CitiesByCountry.grid) ], "master_panel": this });
    var main_panel485 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel213, countries_CitiesByCountry_grid484 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel485;
    this.before_row_edit = function(record) {
      countries_CitiesByCountry_grid484.on_master_changed();
    }
    Lino.countries.Countries.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 19,
  initComponent : function() {
    var containing_panel = this;
    var prefix565 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("prefix","(contacts.Companies.prefix) ") }, "fieldLabel": "prefix", "name": "prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name566 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Companies.name) ") }, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_box_panel567 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix565, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name566, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var country570 = new Lino.TwinCombo({ "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Country","(contacts.Companies.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/country", "method": "GET" }) }) });
    var region571 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Region","(contacts.Companies.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/region", "method": "GET" }) }) });
    var city572 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Place","(contacts.Companies.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/city", "method": "GET" }) }) });
    var zip_code573 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Zip code","(contacts.Companies.zip_code) ") }, "fieldLabel": "Zip code", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_2_panel574 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country570, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region571, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city572, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code573, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr1579 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Address line before street","(contacts.Companies.addr1) Address line before street") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line before street</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_prefix580 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Street prefix","(contacts.Companies.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street prefix</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street581 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Street","(contacts.Companies.street) Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no582 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("No.","(contacts.Companies.street_no) House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box583 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","(contacts.Companies.street_box) Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_4_panel584 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix580, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street581, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no582, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box583, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2589 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Address line after street","(contacts.Companies.addr2) Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line after street</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var address_box_panel590 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "layout": "form", "title": "Address", "items": [ name_box_panel567, address_box_2_panel574, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1579, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel584, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2589, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 243, "border": false, "labelAlign": "top" });
    var id593 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Companies.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language594 = new Lino.ChoicesFieldElement({ "fieldLabel": "Language", "allowBlank": false, "value": "en", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(contacts.Companies.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var info_box_panel595 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id593, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language594, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email598 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Companies.email) ") }, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var url599 = new Lino.URLField({ "listeners": { "render": Lino.quicktip_renderer("URL","(contacts.Companies.url) ") }, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var phone600 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Phone","(contacts.Companies.phone) ") }, "fieldLabel": "Phone", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gsm601 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("GSM","(contacts.Companies.gsm) ") }, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var fax602 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Fax","(contacts.Companies.fax) ") }, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var contact_box_5_panel603 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm601, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax602, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel606 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "layout": "form", "title": "Contact", "items": [ info_box_panel595, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email598, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url599, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone600, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel603 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var main_1_panel610 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ address_box_panel590, contact_box_panel606 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var type611 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Company type", "name": "type", "pageSize": 20, "emptyText": "Select a company type...", "listeners": { "render": Lino.quicktip_renderer("Company type","(contacts.Companies.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var vat_id612 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("VAT id","(contacts.Companies.vat_id) ") }, "fieldLabel": "VAT id", "name": "vat_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var bottom_box_1_panel613 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type611, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id612, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks616 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remarks","(contacts.Companies.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var contacts_RolesByCompany_grid621 = new Lino.contacts.RolesByCompany.GridPanel({ "flex": 42, "listeners": { "render": Lino.quicktip_renderer("Contact persons","(contacts.contacts.RolesByCompany) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.grid) ], "master_panel": this });
    var bottom_box_2_panel622 = new Ext.Panel({ "flex": 83, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": remarks616, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 57 }, contacts_RolesByCompany_grid621 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var bottom_box_panel624 = new Ext.Panel({ "flex": 54, "border": false, "layout": "vbox", "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ bottom_box_1_panel613, bottom_box_2_panel622 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": true, "labelAlign": "top" });
    var main_panel625 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel610, bottom_box_panel624 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel625;
    this.before_row_edit = function(record) {
      region571.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city572.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city572.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByCompany_grid621.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country570.on('change',Lino.chooser_handler(region571,'country'));
      country570.on('change',Lino.chooser_handler(city572,'country'));
      region571.on('change',Lino.chooser_handler(city572,'region'));
      Lino.contacts.Companies.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Companies.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Roles.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 25,
  initComponent : function() {
    var containing_panel = this;
    var name725 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation","(households.Roles.name) ") }, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de726 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(households.Roles.name_de) ") }, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_fr727 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(households.Roles.name_fr) ") }, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_giving728 = new Ext.form.Checkbox({ "boxLabel": "name-giving", "listeners": { "render": Lino.quicktip_renderer("name-giving","(households.Roles.name_giving) When the `name` field of a Household is empty, \nits value is computed by joining the `Last Name` \nof all name-giving members with a dash (\"-\").\n      ") }, "hideLabel": true, "checked": false, "name": "name_giving", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel729 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name725, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de726, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr727, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_giving728, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var MembersByRole_grid740 = new Lino.households.MembersByRole.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Household Members","(households.households.MembersByRole) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByRole.grid) ], "master_panel": this });
    var main_panel741 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel729, MembersByRole_grid740 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel741;
    this.before_row_edit = function(record) {
      MembersByRole_grid740.on_master_changed();
    }
    Lino.households.Roles.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 22,
  initComponent : function() {
    var containing_panel = this;
    var name295 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Partners.name) ") }, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var country296 = new Lino.TwinCombo({ "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Country","(contacts.Partners.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }) });
    var region297 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Region","(contacts.Partners.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }) });
    var city298 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Place","(contacts.Partners.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }) });
    var zip_code299 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Zip code","(contacts.Partners.zip_code) ") }, "fieldLabel": "Zip code", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_2_panel300 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country296, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region297, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city298, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code299, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr1305 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Address line before street","(contacts.Partners.addr1) Address line before street") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line before street</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_prefix306 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Street prefix","(contacts.Partners.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street prefix</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street307 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Street","(contacts.Partners.street) Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no308 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("No.","(contacts.Partners.street_no) House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box309 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","(contacts.Partners.street_box) Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_4_panel310 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix306, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street307, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no308, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box309, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2315 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Address line after street","(contacts.Partners.addr2) Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line after street</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var address_box_panel316 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "layout": "form", "title": "Address", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name295, "anchor": "-20", "labelAlign": "top" }, address_box_2_panel300, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1305, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel310, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2315, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 243, "border": false, "labelAlign": "top" });
    var id320 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Partners.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language321 = new Lino.ChoicesFieldElement({ "fieldLabel": "Language", "allowBlank": false, "value": "en", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(contacts.Partners.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var info_box_panel322 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id320, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language321, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email325 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Partners.email) ") }, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var url326 = new Lino.URLField({ "listeners": { "render": Lino.quicktip_renderer("URL","(contacts.Partners.url) ") }, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var phone327 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Phone","(contacts.Partners.phone) ") }, "fieldLabel": "Phone", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gsm328 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("GSM","(contacts.Partners.gsm) ") }, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var fax329 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Fax","(contacts.Partners.fax) ") }, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var contact_box_5_panel330 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm328, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax329, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel333 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "layout": "form", "title": "Contact", "items": [ info_box_panel322, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email325, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url326, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone327, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel330 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var general_1_panel337 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ address_box_panel316, contact_box_panel333 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks338 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remarks","(contacts.Partners.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var is_person339 = new Ext.form.Checkbox({ "boxLabel": "is Person (<a href=\"javascript:Lino.show_mti_child('is_person',Lino.contacts.Persons.detail)\">show</a>)", "listeners": { "render": Lino.quicktip_renderer("is Person","(contacts.Partners.is_person) Whether this Partner is a Person.") }, "hideLabel": true, "name": "is_person", "selectOnFocus": true, "anchor": "-20" });
    var is_company340 = new Ext.form.Checkbox({ "boxLabel": "is Company (<a href=\"javascript:Lino.show_mti_child('is_company',Lino.contacts.Companies.detail)\">show</a>)", "listeners": { "render": Lino.quicktip_renderer("is Company","(contacts.Partners.is_company) Whether this Partner is a Company.") }, "hideLabel": true, "name": "is_company", "selectOnFocus": true, "anchor": "-20" });
    var bottom_box_2_panel341 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_person339, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_company340, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var bottom_box_panel344 = new Ext.Panel({ "flex": 54, "layout": "vbox", "items": [ { "items": remarks338, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 }, bottom_box_2_panel341 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var general_panel346 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel337, bottom_box_panel344 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var payment_term347 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Payment Term</span>", "name": "payment_term", "pageSize": 20, "emptyText": "Select a Payment Term...", "listeners": { "render": Lino.quicktip_renderer("Payment Term","(contacts.Partners.payment_term) The default payment term for sales invoices to this customer.") }, "selectOnFocus": true, "hiddenName": "payment_termHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/payment_term", "method": "GET" }) }) });
    var vat_regime348 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">VAT Regime</span>", "name": "vat_regime", "hiddenName": "vat_regimeHidden", "listeners": { "render": Lino.quicktip_renderer("VAT Regime","(contacts.Partners.vat_regime) The default VAT regime for sales to this customer.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var item_vat349 = new Ext.form.Checkbox({ "boxLabel": "item vat", "listeners": { "render": Lino.quicktip_renderer("item vat","(contacts.Partners.item_vat) The default item VAT setting for sales to this customer.") }, "hideLabel": true, "checked": false, "name": "item_vat", "selectOnFocus": true, "anchor": "-20" });
    var imode350 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Invoicing Mode", "name": "imode", "pageSize": 20, "emptyText": "Select a Invoicing Mode...", "listeners": { "render": Lino.quicktip_renderer("Invoicing Mode","(contacts.Partners.imode) ") }, "selectOnFocus": true, "hiddenName": "imodeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/imode", "method": "GET" }) }) });
    var sales_1_panel351 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": payment_term347, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_regime348, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": item_vat349, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": imode350, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var sales_InvoicesByPartner_grid468 = new Lino.sales.InvoicesByPartner.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Invoices","(sales.sales.InvoicesByPartner) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.sales.InvoicesByPartner.grid) ], "master_panel": this });
    var sales_panel469 = new Ext.Panel({ "layout": "vbox", "title": "Sales", "items": [ sales_1_panel351, sales_InvoicesByPartner_grid468 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel470 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel346, sales_panel469 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel470;
    this.before_row_edit = function(record) {
      region297.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city298.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city298.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      sales_InvoicesByPartner_grid468.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country296.on('change',Lino.chooser_handler(region297,'country'));
      country296.on('change',Lino.chooser_handler(city298,'country'));
      region297.on('change',Lino.chooser_handler(city298,'region'));
      Lino.contacts.Partners.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Partners.DetailFormPanel.superclass.initComponent.call(this);
  }
});


// js_render_GridPanel_class system.SiteConfigs
Lino.system.SiteConfigs.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/system/SiteConfigs",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": "do_build", "menu_item_text": "Rebuild site cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('do_build','GET'), "text": "Rebuild site cache", "overflowText": "Rebuild site cache", "auto_save": true } ],
  title : "site configs",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "default_build_method" }, 'default_build_methodHidden', { "type": "int", "name": "next_partner_id" }, { "name": "site_company" }, 'site_companyHidden', { "name": "system_note_type" }, 'system_note_typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 8,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    this.ls_detail_handler = Lino.system.SiteConfigs.detail;
    var ww = this.containing_window;
    var id1726 = new Ext.form.NumberField({ "selectOnFocus": true });
    var default_build_method1727 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "value": "appyodt" });
    var next_partner_id1728 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 100 });
    var site_company1729 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/site_company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Company..." });
    var system_note_type1730 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/system_note_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Event Type..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.SiteConfigs.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1726, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Default build method", "editable": true, "tooltip": "(system.SiteConfigs.default_build_method) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "default_build_method", "editor": default_build_method1727 }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.SiteConfigs.next_partner_id) ", "filter": { "type": "numeric" }, "header": "The next automatic id for a manually created partner.", "dataIndex": "next_partner_id", "width": Lino.chars2width(6), "editor": next_partner_id1728 }), { "colIndex": 3, "sortable": true, "header": "The company that runs this site", "editable": true, "tooltip": "(system.SiteConfigs.site_company) The Company to be used as sender in documents.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('site_companyHidden','Lino.contacts.Companies.detail'), "editor": site_company1729, "dataIndex": "site_company" }, { "colIndex": 4, "sortable": true, "header": "Default system note type", "editable": true, "tooltip": "(system.SiteConfigs.system_note_type) Note Type used by system notes.\nIf this is empty, then system notes won't create any entry to the Notes table.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('system_note_typeHidden','Lino.notes.EventTypes.detail'), "editor": system_note_type1730, "dataIndex": "system_note_type" } ];
    Lino.system.SiteConfigs.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.system.SiteConfigs.detailPanel = Ext.extend(Lino.system.SiteConfigs.DetailFormPanel,{
  empty_title: "Detail site configs",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "do_build", "menu_item_text": "Rebuild site cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('do_build','GET'), "text": "Rebuild site cache", "overflowText": "Rebuild site cache", "auto_save": true } ],
  ls_url: "/system/SiteConfigs",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.SiteConfigs.detail;
    Lino.system.SiteConfigs.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.system.SiteConfigs.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.system.SiteConfigs.detailPanel(p);
});
Lino.system.SiteConfigs.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.system.SiteConfigs.GridPanel(p);
});

// js_render_GridPanel_class system.ContentTypes
Lino.system.ContentTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/system/ContentTypes",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "content types",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "app_label" }, { "name": "model" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 3,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.system.ContentTypes.detail;
    this.ls_insert_handler = Lino.system.ContentTypes.insert;
    var ww = this.containing_window;
    var id1732 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1733 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var app_label1734 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var model1735 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.ContentTypes.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1732, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "name", "editable": true, "tooltip": "(system.ContentTypes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1733 }, { "colIndex": 2, "sortable": true, "header": "app label", "editable": true, "tooltip": "(system.ContentTypes.app_label) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "app_label", "editor": app_label1734 }, { "colIndex": 3, "sortable": true, "header": "python model class name", "editable": true, "tooltip": "(system.ContentTypes.model) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "model", "editor": model1735 } ];
    Lino.system.ContentTypes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.system.ContentTypes.insertPanel = Ext.extend(Lino.system.ContentTypes.DetailFormPanel,{
  empty_title: "New content types",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/system/ContentTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.ContentTypes.detail;
    this.ls_insert_handler = Lino.system.ContentTypes.insert;
    Lino.system.ContentTypes.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.system.ContentTypes.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.system.ContentTypes.insertPanel(p);
});

Lino.system.ContentTypes.detailPanel = Ext.extend(Lino.system.ContentTypes.DetailFormPanel,{
  empty_title: "Detail content types",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/system/ContentTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.ContentTypes.detail;
    this.ls_insert_handler = Lino.system.ContentTypes.insert;
    Lino.system.ContentTypes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.system.ContentTypes.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.system.ContentTypes.detailPanel(p);
});
Lino.system.ContentTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.system.ContentTypes.GridPanel(p);
});

// js_render_GridPanel_class system.HelpTexts
Lino.system.HelpTexts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/system/HelpTexts",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Help Texts",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "field" }, { "name": "verbose_name" }, { "name": "help_text" }, { "type": "int", "name": "id" }, { "name": "content_type" }, 'content_typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 9,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    var ww = this.containing_window;
    var field1737 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/HelpTexts/field", "method": "GET" }) }) });
    var verbose_name1738 = new Ext.form.TextField({ "disabled": true, "maxLength": 200 });
    var help_text1739 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var id1740 = new Ext.form.NumberField({ "selectOnFocus": true });
    var content_type1741 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/HelpTexts/content_type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a content type..." });
    this.before_row_edit = function(record) {
      field1737.setContextValue('content_type',record ? record.data['content_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      content_type1741.on('change',Lino.chooser_handler(field1737,'content_type'));
      Lino.system.HelpTexts.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Field", "editable": true, "tooltip": "(system.HelpTexts.field) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "field", "editor": field1737 }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "verbose_name", "header": "Verbose name", "editable": false, "tooltip": "(system.HelpTexts.verbose_name) " }, { "colIndex": 2, "sortable": false, "header": "HelpText", "editable": true, "tooltip": "(system.HelpTexts.help_text) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": help_text1739, "dataIndex": "help_text" }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.HelpTexts.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1740, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Model", "editable": true, "tooltip": "(system.HelpTexts.content_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('content_typeHidden','Lino.system.ContentTypes.detail'), "editor": content_type1741, "dataIndex": "content_type" } ];
    Lino.system.HelpTexts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.system.HelpTexts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.system.HelpTexts.GridPanel(p);
});

// js_render_GridPanel_class system.TextFieldTemplates
Lino.system.TextFieldTemplates.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/system/TextFieldTemplates",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Text Field Templates",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "name" }, { "name": "description" }, { "name": "team" }, 'teamHidden', { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 10,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    this.ls_detail_handler = Lino.system.TextFieldTemplates.detail;
    this.ls_insert_handler = Lino.system.TextFieldTemplates.insert;
    var ww = this.containing_window;
    var id1743 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1744 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var name1745 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var description1746 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var team1747 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/team", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Team..." });
    var text1748 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Template Text" });
    this.before_row_edit = function(record) {
      text1748.refresh();
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.TextFieldTemplates.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1743, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Author", "editable": true, "tooltip": "(system.TextFieldTemplates.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1744, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(system.TextFieldTemplates.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1745 }, { "colIndex": 3, "sortable": false, "header": "Description", "editable": true, "tooltip": "(system.TextFieldTemplates.description) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": description1746, "dataIndex": "description" }, { "colIndex": 4, "sortable": true, "header": "Team", "editable": true, "tooltip": "(system.TextFieldTemplates.team) If not empty, then this template is reserved to members of this team.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "team", "editor": team1747 }, { "colIndex": 5, "sortable": false, "header": "text", "editable": true, "tooltip": "(system.TextFieldTemplates.text) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": text1748, "dataIndex": "text" } ];
    Lino.system.TextFieldTemplates.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.system.TextFieldTemplates.insertPanel = Ext.extend(Lino.system.TextFieldTemplates.InsertFormPanel,{
  empty_title: "New Text Field Templates",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/system/TextFieldTemplates",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.TextFieldTemplates.detail;
    this.ls_insert_handler = Lino.system.TextFieldTemplates.insert;
    Lino.system.TextFieldTemplates.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.system.TextFieldTemplates.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.system.TextFieldTemplates.insertPanel(p);
});

Lino.system.TextFieldTemplates.detailPanel = Ext.extend(Lino.system.TextFieldTemplates.DetailFormPanel,{
  empty_title: "Detail Text Field Templates",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/system/TextFieldTemplates",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.TextFieldTemplates.detail;
    this.ls_insert_handler = Lino.system.TextFieldTemplates.insert;
    Lino.system.TextFieldTemplates.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.system.TextFieldTemplates.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.system.TextFieldTemplates.detailPanel(p);
});
Lino.system.TextFieldTemplates.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.system.TextFieldTemplates.GridPanel(p);
});

// js_render_GridPanel_class users.Users
Lino.users.Users.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/Users",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Reminders", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET'), "text": "Update Reminders", "overflowText": "Update Reminders", "auto_save": true } ],
  title : "Users",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "first_name" }, { "name": "last_name" }, { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "password" }, { "name": "email" }, { "name": "remarks" }, { "name": "language" }, 'languageHidden', { "name": "partner" }, 'partnerHidden', { "name": "access_class" }, 'access_classHidden', { "name": "calendar" }, 'calendarHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 12,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 20,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    var ww = this.containing_window;
    var username1750 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile1751 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var first_name1752 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var last_name1753 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var id1754 = new Ext.form.NumberField({ "selectOnFocus": true });
    var created1755 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified1756 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var password1757 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 128 });
    var email1758 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var remarks1759 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var language1760 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ] });
    var partner1761 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var access_class1762 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.AccessClasses });
    var calendar1763 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Username", "editable": true, "tooltip": "(users.Users.username) \n        Required. Must be unique. \n        ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "username", "editor": username1750 }, { "colIndex": 1, "sortable": true, "header": "User Profile", "editable": true, "tooltip": "(users.Users.profile) ", "filter": { "type": "string" }, "width": Lino.chars2width(23), "dataIndex": "profile", "editor": profile1751 }, { "colIndex": 2, "sortable": true, "header": "First name", "editable": true, "tooltip": "(users.Users.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name1752 }, { "colIndex": 3, "sortable": true, "header": "Last name", "editable": true, "tooltip": "(users.Users.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name1753 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.Users.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1754, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(17), "colIndex": 5, "sortable": true, "dataIndex": "created", "header": "Created", "editable": false, "tooltip": "(users.Users.created) " }, { "width": Lino.chars2width(17), "colIndex": 6, "sortable": true, "dataIndex": "modified", "header": "Modified", "editable": false, "tooltip": "(users.Users.modified) " }, { "colIndex": 7, "sortable": true, "header": "Password", "editable": true, "tooltip": "(users.Users.password) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "password", "hidden": true, "editor": password1757 }, { "colIndex": 8, "sortable": true, "header": "e-mail address", "editable": true, "tooltip": "(users.Users.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email1758 }, { "colIndex": 9, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(users.Users.remarks) ", "filter": { "type": "string" }, "header": "Remarks", "renderer": Lino.text_renderer, "hidden": true, "editor": remarks1759, "dataIndex": "remarks" }, { "colIndex": 10, "sortable": true, "header": "Language", "editable": true, "tooltip": "(users.Users.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language1760 }, { "colIndex": 11, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(users.Users.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner1761, "dataIndex": "partner" }, { "colIndex": 12, "sortable": true, "header": "Default access class", "editable": true, "tooltip": "(users.Users.access_class) The default access class for your calendar events and tasks.", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "access_class", "editor": access_class1762 }, { "colIndex": 13, "sortable": true, "header": "Default calendar", "editable": true, "tooltip": "(users.Users.calendar) The default calendar for your events and tasks.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.Calendars.detail'), "editor": calendar1763, "dataIndex": "calendar" } ];
    Lino.users.Users.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.users.Users.insertPanel = Ext.extend(Lino.users.Users.InsertFormPanel,{
  empty_title: "New Users",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/users/Users",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.Users.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Users.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.Users.insertPanel(p);
});

Lino.users.Users.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Detail Users",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Reminders", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET'), "text": "Update Reminders", "overflowText": "Update Reminders", "auto_save": true } ],
  ls_url: "/users/Users",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.Users.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Users.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Users.detailPanel(p);
});
Lino.users.Users.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Users.GridPanel(p);
});

// js_render_GridPanel_class users.MySettings
Lino.users.MySettings.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/MySettings",
  ls_bbar_actions : [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Reminders", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET'), "text": "Update Reminders", "overflowText": "Update Reminders", "auto_save": true } ],
  title : "Users",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "first_name" }, { "name": "last_name" }, { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "password" }, { "name": "email" }, { "name": "remarks" }, { "name": "language" }, 'languageHidden', { "name": "partner" }, 'partnerHidden', { "name": "access_class" }, 'access_classHidden', { "name": "calendar" }, 'calendarHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 12,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 20,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    var ww = this.containing_window;
    var username128 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile129 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var first_name130 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var last_name131 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var id132 = new Ext.form.NumberField({ "selectOnFocus": true });
    var created133 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified134 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var password135 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 128 });
    var email136 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var remarks137 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var language138 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ] });
    var partner139 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var access_class140 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.AccessClasses });
    var calendar141 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Username", "editable": true, "tooltip": "(users.MySettings.username) \n        Required. Must be unique. \n        ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "username", "editor": username128 }, { "colIndex": 1, "sortable": true, "header": "User Profile", "editable": true, "tooltip": "(users.MySettings.profile) ", "filter": { "type": "string" }, "width": Lino.chars2width(23), "dataIndex": "profile", "editor": profile129 }, { "colIndex": 2, "sortable": true, "header": "First name", "editable": true, "tooltip": "(users.MySettings.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name130 }, { "colIndex": 3, "sortable": true, "header": "Last name", "editable": true, "tooltip": "(users.MySettings.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name131 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.MySettings.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id132, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(17), "colIndex": 5, "sortable": true, "dataIndex": "created", "header": "Created", "editable": false, "tooltip": "(users.MySettings.created) " }, { "width": Lino.chars2width(17), "colIndex": 6, "sortable": true, "dataIndex": "modified", "header": "Modified", "editable": false, "tooltip": "(users.MySettings.modified) " }, { "colIndex": 7, "sortable": true, "header": "Password", "editable": true, "tooltip": "(users.MySettings.password) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "password", "hidden": true, "editor": password135 }, { "colIndex": 8, "sortable": true, "header": "e-mail address", "editable": true, "tooltip": "(users.MySettings.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email136 }, { "colIndex": 9, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(users.MySettings.remarks) ", "filter": { "type": "string" }, "header": "Remarks", "renderer": Lino.text_renderer, "hidden": true, "editor": remarks137, "dataIndex": "remarks" }, { "colIndex": 10, "sortable": true, "header": "Language", "editable": true, "tooltip": "(users.MySettings.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language138 }, { "colIndex": 11, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(users.MySettings.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner139, "dataIndex": "partner" }, { "colIndex": 12, "sortable": true, "header": "Default access class", "editable": true, "tooltip": "(users.MySettings.access_class) The default access class for your calendar events and tasks.", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "access_class", "editor": access_class140 }, { "colIndex": 13, "sortable": true, "header": "Default calendar", "editable": true, "tooltip": "(users.MySettings.calendar) The default calendar for your events and tasks.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.Calendars.detail'), "editor": calendar141, "dataIndex": "calendar" } ];
    Lino.users.MySettings.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Users",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Reminders", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET'), "text": "Update Reminders", "overflowText": "Update Reminders", "auto_save": true } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});

Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Users",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Reminders", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET'), "text": "Update Reminders", "overflowText": "Update Reminders", "auto_save": true } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});

// js_render_GridPanel_class users.UsersOverview
Lino.users.UsersOverview.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/UsersOverview",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Reminders", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET'), "text": "Update Reminders", "overflowText": "Update Reminders", "auto_save": true } ],
  title : "Users",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "language" }, 'languageHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 12,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.UsersOverview.detail;
    this.ls_insert_handler = Lino.users.UsersOverview.insert;
    var ww = this.containing_window;
    var username161 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile162 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var language163 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ] });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Username", "editable": true, "tooltip": "(users.UsersOverview.username) \n        Required. Must be unique. \n        ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "username", "editor": username161 }, { "colIndex": 1, "sortable": true, "header": "User Profile", "editable": true, "tooltip": "(users.UsersOverview.profile) ", "filter": { "type": "string" }, "width": Lino.chars2width(23), "dataIndex": "profile", "editor": profile162 }, { "colIndex": 2, "sortable": true, "header": "Language", "editable": true, "tooltip": "(users.UsersOverview.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language163 } ];
    Lino.users.UsersOverview.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.users.UsersOverview.insertPanel = Ext.extend(Lino.users.Users.InsertFormPanel,{
  empty_title: "New Users",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/users/UsersOverview",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.UsersOverview.detail;
    this.ls_insert_handler = Lino.users.UsersOverview.insert;
    Lino.users.UsersOverview.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.users.UsersOverview.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.UsersOverview.insertPanel(p);
});

Lino.users.UsersOverview.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Detail Users",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Reminders", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET'), "text": "Update Reminders", "overflowText": "Update Reminders", "auto_save": true } ],
  ls_url: "/users/UsersOverview",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.UsersOverview.detail;
    this.ls_insert_handler = Lino.users.UsersOverview.insert;
    Lino.users.UsersOverview.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.UsersOverview.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.UsersOverview.detailPanel(p);
});
Lino.users.UsersOverview.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.UsersOverview.GridPanel(p);
});

// js_render_GridPanel_class users.Teams
Lino.users.Teams.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/Teams",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Teams",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 14,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    var ww = this.containing_window;
    var id1765 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1766 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1767 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1768 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.Teams.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1765, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(users.Teams.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1766 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(users.Teams.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de1767 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(users.Teams.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1768 } ];
    Lino.users.Teams.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Teams.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Teams.GridPanel(p);
});

// js_render_GridPanel_class users.Memberships
Lino.users.Memberships.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/Memberships",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Memberships",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "team" }, 'teamHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 11,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var id1770 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1771 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Memberships/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var team1772 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Memberships/team", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Team..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.Memberships.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1770, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Author", "editable": true, "tooltip": "(users.Memberships.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1771, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "Team", "editable": true, "tooltip": "(users.Memberships.team) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "team", "editor": team1772 } ];
    Lino.users.Memberships.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Memberships.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Memberships.GridPanel(p);
});

// js_render_GridPanel_class users.Authorities
Lino.users.Authorities.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/Authorities",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Authorities",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "authorized" }, 'authorizedHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 13,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var id1774 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1775 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Authorities/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var authorized1776 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Authorities/authorized", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a User..." });
    this.before_row_edit = function(record) {
      authorized1776.setContextValue('user',record ? record.data['userHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      user1775.on('change',Lino.chooser_handler(authorized1776,'user'));
      Lino.users.Authorities.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.Authorities.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1774, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Author", "editable": true, "tooltip": "(users.Authorities.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1775, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "User", "editable": true, "tooltip": "(users.Authorities.authorized) The user who gets authority to act in your name.", "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('authorizedHidden','Lino.users.Users.detail'), "editor": authorized1776, "dataIndex": "authorized" } ];
    Lino.users.Authorities.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Authorities.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Authorities.GridPanel(p);
});

// js_render_GridPanel_class countries.Languages
Lino.countries.Languages.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/countries/Languages",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Languages",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "id" }, { "name": "iso2" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 16,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var name1778 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1779 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1780 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1781 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "allowBlank": false, "maxLength": 3 });
    var iso21782 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(2), "maxLength": 2 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(countries.Languages.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1778 }, { "colIndex": 1, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(countries.Languages.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de1779 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(countries.Languages.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1780 }, { "colIndex": 3, "sortable": true, "header": "id", "editable": true, "tooltip": "(countries.Languages.id) ", "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "id", "editor": id1781 }, { "colIndex": 4, "sortable": true, "header": "iso2", "editable": true, "tooltip": "(countries.Languages.iso2) ", "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "iso2", "editor": iso21782 } ];
    Lino.countries.Languages.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Languages.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Languages.GridPanel(p);
});

// js_render_GridPanel_class countries.Countries
Lino.countries.Countries.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/countries/Countries",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Countries",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "isocode" }, { "name": "short_code" }, { "name": "iso3" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 15,
  ls_id_property : "isocode",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    var ww = this.containing_window;
    var name1784 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1785 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1786 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var isocode1787 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "allowBlank": false, "maxLength": 4 });
    var short_code1788 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    var iso31789 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "maxLength": 3 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(countries.Countries.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1784 }, { "colIndex": 1, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(countries.Countries.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de1785 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(countries.Countries.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1786 }, { "colIndex": 3, "sortable": true, "header": "ISO code", "editable": true, "tooltip": "(countries.Countries.isocode)         The two-letter code for this country as defined by ISO 3166-1. \n        For countries that no longer exist it may be a 4-letter code.", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "isocode", "editor": isocode1787 }, { "colIndex": 4, "sortable": true, "header": "Short code", "editable": true, "tooltip": "(countries.Countries.short_code) A short abbreviation for regional usage. Obsolete.", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "short_code", "editor": short_code1788 }, { "colIndex": 5, "sortable": true, "header": "ISO-3 code", "editable": true, "tooltip": "(countries.Countries.iso3) The three-letter code for this country as defined by ISO 3166-1.", "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "iso3", "editor": iso31789 } ];
    Lino.countries.Countries.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Countries.insertPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "New Countries",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/countries/Countries",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    Lino.countries.Countries.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Countries.insertPanel(p);
});

Lino.countries.Countries.detailPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "Detail Countries",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/countries/Countries",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    Lino.countries.Countries.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.detailPanel(p);
});
Lino.countries.Countries.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.GridPanel(p);
});

// js_render_GridPanel_class countries.Cities
Lino.countries.Cities.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/countries/Cities",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Places",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "country" }, 'countryHidden', { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "type" }, 'typeHidden', { "name": "zip_code" }, { "type": "int", "name": "id" }, { "name": "parent" }, 'parentHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 8,
  ls_grid_configs : [  ],
  content_type : 17,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 12,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Cities.detail;
    this.ls_insert_handler = Lino.countries.Cities.insert;
    var ww = this.containing_window;
    var country1791 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/country", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Country..." });
    var name1792 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1793 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1794 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type1795 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/type", "method": "GET" }) }) });
    var zip_code1796 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "maxLength": 8 });
    var id1797 = new Ext.form.NumberField({ "selectOnFocus": true });
    var parent1798 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/parent", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    this.before_row_edit = function(record) {
      type1795.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country1791.on('change',Lino.chooser_handler(type1795,'country'));
      Lino.countries.Cities.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Country", "editable": true, "tooltip": "(countries.Cities.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country1791, "dataIndex": "country" }, { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(countries.Cities.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1792 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(countries.Cities.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de1793 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(countries.Cities.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1794 }, { "colIndex": 4, "sortable": true, "header": "Place Type", "editable": true, "tooltip": "(countries.Cities.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "type", "editor": type1795 }, { "colIndex": 5, "sortable": true, "header": "zip code", "editable": true, "tooltip": "(countries.Cities.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "zip_code", "editor": zip_code1796 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(countries.Cities.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1797, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 7, "sortable": true, "header": "Part of", "editable": true, "tooltip": "(countries.Cities.parent) The superordinate geographic place of which this place is a part.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('parentHidden','Lino.countries.Cities.detail'), "editor": parent1798, "dataIndex": "parent" } ];
    Lino.countries.Cities.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Cities.insertPanel = Ext.extend(Lino.countries.Cities.DetailFormPanel,{
  empty_title: "New Places",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/countries/Cities",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Cities.detail;
    this.ls_insert_handler = Lino.countries.Cities.insert;
    Lino.countries.Cities.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Cities.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Cities.insertPanel(p);
});

Lino.countries.Cities.detailPanel = Ext.extend(Lino.countries.Cities.DetailFormPanel,{
  empty_title: "Detail Places",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/countries/Cities",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Cities.detail;
    this.ls_insert_handler = Lino.countries.Cities.insert;
    Lino.countries.Cities.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Cities.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Cities.detailPanel(p);
});
Lino.countries.Cities.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Cities.GridPanel(p);
});

// js_render_GridPanel_class contacts.CompanyTypes
Lino.contacts.CompanyTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/CompanyTypes",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "company types",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "type": "int", "name": "id" }, { "name": "abbr" }, { "name": "abbr_de" }, { "name": "abbr_fr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 23,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var name1800 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1801 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1802 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1803 = new Ext.form.NumberField({ "selectOnFocus": true });
    var abbr1804 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var abbr_de1805 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var abbr_fr1806 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(contacts.CompanyTypes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1800 }, { "colIndex": 1, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(contacts.CompanyTypes.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de1801 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(contacts.CompanyTypes.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1802 }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.CompanyTypes.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1803, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Abbreviation", "editable": true, "tooltip": "(contacts.CompanyTypes.abbr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "abbr", "editor": abbr1804 }, { "colIndex": 5, "sortable": true, "header": "Abbreviation (de)", "editable": true, "tooltip": "(contacts.CompanyTypes.abbr_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "abbr_de", "editor": abbr_de1805 }, { "colIndex": 6, "sortable": true, "header": "Abbreviation (fr)", "editable": true, "tooltip": "(contacts.CompanyTypes.abbr_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "abbr_fr", "editor": abbr_fr1806 } ];
    Lino.contacts.CompanyTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.CompanyTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.CompanyTypes.GridPanel(p);
});

// js_render_GridPanel_class contacts.Partners
Lino.contacts.Partners.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Partners",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Partners",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "name": "payment_term" }, 'payment_termHidden', { "name": "vat_regime" }, 'vat_regimeHidden', { "type": "boolean", "name": "item_vat" }, { "name": "imode" }, 'imodeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 29,
  ls_grid_configs : [  ],
  content_type : 22,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 31,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    var ww = this.containing_window;
    var name1808 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email1809 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var country1810 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Country..." });
    var city1811 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var region1812 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var zip_code1813 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr11814 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix1815 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street1816 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no1817 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box1818 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr21819 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language1820 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "allowBlank": false, "value": "en" });
    var url1821 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone1822 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm1823 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax1824 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks1825 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var payment_term1826 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Payment Term..." });
    var vat_regime1827 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var item_vat1828 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var imode1829 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Invoicing Mode..." });
    var id1830 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city1811.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1811.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region1812.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country1810.on('change',Lino.chooser_handler(city1811,'country'));
      region1812.on('change',Lino.chooser_handler(city1811,'region'));
      country1810.on('change',Lino.chooser_handler(region1812,'country'));
      Lino.contacts.Partners.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.Partners.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1808 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.Partners.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email1809 }, { "colIndex": 2, "sortable": true, "header": "Country", "editable": true, "tooltip": "(contacts.Partners.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country1810, "dataIndex": "country" }, { "colIndex": 3, "sortable": true, "header": "Place", "editable": true, "tooltip": "(contacts.Partners.city) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail'), "editor": city1811, "dataIndex": "city" }, { "colIndex": 4, "sortable": true, "header": "Region", "editable": true, "tooltip": "(contacts.Partners.region) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail'), "editor": region1812, "dataIndex": "region" }, { "colIndex": 5, "sortable": true, "header": "Zip code", "editable": true, "tooltip": "(contacts.Partners.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code1813 }, { "colIndex": 6, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "(contacts.Partners.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr11814 }, { "colIndex": 7, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "(contacts.Partners.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix1815 }, { "colIndex": 8, "sortable": true, "header": "Street", "editable": true, "tooltip": "(contacts.Partners.street) Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street1816 }, { "colIndex": 9, "sortable": true, "header": "No.", "editable": true, "tooltip": "(contacts.Partners.street_no) House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no1817 }, { "colIndex": 10, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.Partners.street_box) Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box1818 }, { "colIndex": 11, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "(contacts.Partners.addr2) Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr21819 }, { "colIndex": 12, "sortable": true, "header": "Language", "editable": true, "tooltip": "(contacts.Partners.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language1820 }, { "colIndex": 13, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.Partners.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url1821 }, { "colIndex": 14, "sortable": true, "header": "Phone", "editable": true, "tooltip": "(contacts.Partners.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone1822 }, { "colIndex": 15, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.Partners.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm1823 }, { "colIndex": 16, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.Partners.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax1824 }, { "colIndex": 17, "sortable": false, "header": "Remarks", "editable": true, "tooltip": "(contacts.Partners.remarks) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks1825, "dataIndex": "remarks" }, { "colIndex": 18, "sortable": true, "header": "Payment Term", "editable": true, "tooltip": "(contacts.Partners.payment_term) The default payment term for sales invoices to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "payment_term", "editor": payment_term1826 }, { "colIndex": 19, "sortable": true, "header": "VAT Regime", "editable": true, "tooltip": "(contacts.Partners.vat_regime) The default VAT regime for sales to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "vat_regime", "editor": vat_regime1827 }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "item vat", "editable": true, "tooltip": "(contacts.Partners.item_vat) The default item VAT setting for sales to this customer.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "item_vat" }, { "colIndex": 21, "sortable": true, "header": "Invoicing Mode", "editable": true, "tooltip": "(contacts.Partners.imode) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "imode", "editor": imode1829 }, new Lino.NullNumberColumn({ "colIndex": 22, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.Partners.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1830, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.Partners.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.insertPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "New Partners",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/contacts/Partners",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    Lino.contacts.Partners.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Partners.insertPanel(p);
});

Lino.contacts.Partners.detailPanel = Ext.extend(Lino.contacts.Partners.DetailFormPanel,{
  empty_title: "Detail Partners",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/contacts/Partners",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    Lino.contacts.Partners.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Partners.detailPanel(p);
});
Lino.contacts.Partners.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Partners.GridPanel(p);
});

// js_render_GridPanel_class contacts.Persons
Lino.contacts.Persons.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Persons",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Persons",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name_column" }, { "name": "address_column" }, { "name": "email" }, { "name": "phone" }, { "name": "gsm" }, { "type": "int", "name": "id" }, { "name": "language" }, 'languageHidden', { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "name" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "url" }, { "name": "fax" }, { "name": "remarks" }, { "name": "payment_term" }, 'payment_termHidden', { "name": "vat_regime" }, 'vat_regimeHidden', { "type": "boolean", "name": "item_vat" }, { "name": "imode" }, 'imodeHidden', { "name": "first_name" }, { "name": "last_name" }, { "name": "gender" }, 'genderHidden', { "name": "birth_date" }, { "name": "title" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 20,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 39,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    var ww = this.containing_window;
    var name_column_disp1832 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var address_column_disp1833 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var email1834 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone1835 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm1836 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1837 = new Ext.form.NumberField({ "selectOnFocus": true });
    var language1838 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "allowBlank": false, "value": "en" });
    var country1839 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Country..." });
    var city1840 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var region1841 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var zip_code1842 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var name1843 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var addr11844 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix1845 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street1846 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no1847 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box1848 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr21849 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var url1850 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var fax1851 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks1852 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var payment_term1853 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Payment Term..." });
    var vat_regime1854 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var item_vat1855 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var imode1856 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Invoicing Mode..." });
    var first_name1857 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var last_name1858 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gender1859 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.Genders) });
    var birth_date1860 = new Lino.IncompleteDateField({ "selectOnFocus": true });
    var title1861 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
      city1840.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1840.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region1841.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country1839.on('change',Lino.chooser_handler(city1840,'country'));
      region1841.on('change',Lino.chooser_handler(city1840,'region'));
      country1839.on('change',Lino.chooser_handler(region1841,'country'));
      Lino.contacts.Persons.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "name_column", "header": "Name", "editable": false, "tooltip": "(contacts.Persons.name_column) " }, { "width": Lino.chars2width(31), "colIndex": 1, "sortable": false, "dataIndex": "address_column", "header": "Address", "editable": false, "tooltip": "(contacts.Persons.address_column) " }, { "colIndex": 2, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.Persons.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email1834 }, { "colIndex": 3, "sortable": true, "header": "Phone", "editable": true, "tooltip": "(contacts.Persons.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "phone", "editor": phone1835 }, { "colIndex": 4, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.Persons.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "gsm", "editor": gsm1836 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.Persons.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1837, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Language", "editable": true, "tooltip": "(contacts.Persons.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "language", "editor": language1838 }, { "colIndex": 7, "sortable": true, "header": "Country", "editable": true, "tooltip": "(contacts.Persons.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country1839, "dataIndex": "country" }, { "colIndex": 8, "sortable": true, "header": "Place", "editable": true, "tooltip": "(contacts.Persons.city) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail'), "editor": city1840, "dataIndex": "city" }, { "colIndex": 9, "sortable": true, "header": "Region", "editable": true, "tooltip": "(contacts.Persons.region) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail'), "editor": region1841, "dataIndex": "region" }, { "colIndex": 10, "sortable": true, "header": "Zip code", "editable": true, "tooltip": "(contacts.Persons.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code1842 }, { "colIndex": 11, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.Persons.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1843 }, { "colIndex": 12, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "(contacts.Persons.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr11844 }, { "colIndex": 13, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "(contacts.Persons.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix1845 }, { "colIndex": 14, "sortable": true, "header": "Street", "editable": true, "tooltip": "(contacts.Persons.street) Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street1846 }, { "colIndex": 15, "sortable": true, "header": "No.", "editable": true, "tooltip": "(contacts.Persons.street_no) House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no1847 }, { "colIndex": 16, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.Persons.street_box) Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box1848 }, { "colIndex": 17, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "(contacts.Persons.addr2) Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr21849 }, { "colIndex": 18, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.Persons.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url1850 }, { "colIndex": 19, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.Persons.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax1851 }, { "colIndex": 20, "sortable": false, "header": "Remarks", "editable": true, "tooltip": "(contacts.Persons.remarks) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks1852, "dataIndex": "remarks" }, { "colIndex": 21, "sortable": true, "header": "Payment Term", "editable": true, "tooltip": "(contacts.Persons.payment_term) The default payment term for sales invoices to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "payment_term", "editor": payment_term1853 }, { "colIndex": 22, "sortable": true, "header": "VAT Regime", "editable": true, "tooltip": "(contacts.Persons.vat_regime) The default VAT regime for sales to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "vat_regime", "editor": vat_regime1854 }, { "colIndex": 23, "sortable": false, "xtype": "checkcolumn", "header": "item vat", "editable": true, "tooltip": "(contacts.Persons.item_vat) The default item VAT setting for sales to this customer.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "item_vat" }, { "colIndex": 24, "sortable": true, "header": "Invoicing Mode", "editable": true, "tooltip": "(contacts.Persons.imode) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "imode", "editor": imode1856 }, { "colIndex": 25, "sortable": true, "header": "First name", "editable": true, "tooltip": "(contacts.Persons.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name1857 }, { "colIndex": 26, "sortable": true, "header": "Last name", "editable": true, "tooltip": "(contacts.Persons.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name1858 }, { "colIndex": 27, "sortable": true, "header": "Gender", "editable": true, "tooltip": "(contacts.Persons.gender) ", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "gender", "editor": gender1859 }, { "colIndex": 28, "sortable": true, "header": "Birth date", "editable": true, "tooltip": "(contacts.Persons.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "birth_date", "editor": birth_date1860 }, { "colIndex": 29, "sortable": true, "header": "Title", "editable": true, "tooltip": "(contacts.Persons.title) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "title", "editor": title1861 } ];
    Lino.contacts.Persons.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.insertPanel = Ext.extend(Lino.contacts.Persons.InsertFormPanel,{
  empty_title: "New Persons",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/contacts/Persons",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    Lino.contacts.Persons.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Persons.insertPanel(p);
});

Lino.contacts.Persons.detailPanel = Ext.extend(Lino.contacts.Persons.DetailFormPanel,{
  empty_title: "Detail Persons",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/contacts/Persons",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    Lino.contacts.Persons.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Persons.detailPanel(p);
});
Lino.contacts.Persons.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Persons.GridPanel(p);
});

// js_render_GridPanel_class contacts.Companies
Lino.contacts.Companies.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Companies",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Companies",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "name": "payment_term" }, 'payment_termHidden', { "name": "vat_regime" }, 'vat_regimeHidden', { "type": "boolean", "name": "item_vat" }, { "name": "imode" }, 'imodeHidden', { "name": "prefix" }, { "name": "vat_id" }, { "name": "type" }, 'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 33,
  ls_grid_configs : [  ],
  content_type : 19,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 35,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    var ww = this.containing_window;
    var name1863 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email1864 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var country1865 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Country..." });
    var city1866 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var region1867 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var zip_code1868 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr11869 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix1870 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street1871 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no1872 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box1873 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr21874 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language1875 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "allowBlank": false, "value": "en" });
    var url1876 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone1877 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm1878 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax1879 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks1880 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var payment_term1881 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Payment Term..." });
    var vat_regime1882 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var item_vat1883 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var imode1884 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Invoicing Mode..." });
    var prefix1885 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var vat_id1886 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type1887 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a company type..." });
    var id1888 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city1866.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1866.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region1867.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country1865.on('change',Lino.chooser_handler(city1866,'country'));
      region1867.on('change',Lino.chooser_handler(city1866,'region'));
      country1865.on('change',Lino.chooser_handler(region1867,'country'));
      Lino.contacts.Companies.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.Companies.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1863 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.Companies.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email1864 }, { "colIndex": 2, "sortable": true, "header": "Country", "editable": true, "tooltip": "(contacts.Companies.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country1865, "dataIndex": "country" }, { "colIndex": 3, "sortable": true, "header": "Place", "editable": true, "tooltip": "(contacts.Companies.city) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail'), "editor": city1866, "dataIndex": "city" }, { "colIndex": 4, "sortable": true, "header": "Region", "editable": true, "tooltip": "(contacts.Companies.region) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail'), "editor": region1867, "dataIndex": "region" }, { "colIndex": 5, "sortable": true, "header": "Zip code", "editable": true, "tooltip": "(contacts.Companies.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code1868 }, { "colIndex": 6, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "(contacts.Companies.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr11869 }, { "colIndex": 7, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "(contacts.Companies.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix1870 }, { "colIndex": 8, "sortable": true, "header": "Street", "editable": true, "tooltip": "(contacts.Companies.street) Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street1871 }, { "colIndex": 9, "sortable": true, "header": "No.", "editable": true, "tooltip": "(contacts.Companies.street_no) House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no1872 }, { "colIndex": 10, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.Companies.street_box) Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box1873 }, { "colIndex": 11, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "(contacts.Companies.addr2) Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr21874 }, { "colIndex": 12, "sortable": true, "header": "Language", "editable": true, "tooltip": "(contacts.Companies.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language1875 }, { "colIndex": 13, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.Companies.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url1876 }, { "colIndex": 14, "sortable": true, "header": "Phone", "editable": true, "tooltip": "(contacts.Companies.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone1877 }, { "colIndex": 15, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.Companies.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm1878 }, { "colIndex": 16, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.Companies.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax1879 }, { "colIndex": 17, "sortable": false, "header": "Remarks", "editable": true, "tooltip": "(contacts.Companies.remarks) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks1880, "dataIndex": "remarks" }, { "colIndex": 18, "sortable": true, "header": "Payment Term", "editable": true, "tooltip": "(contacts.Companies.payment_term) The default payment term for sales invoices to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "payment_term", "editor": payment_term1881 }, { "colIndex": 19, "sortable": true, "header": "VAT Regime", "editable": true, "tooltip": "(contacts.Companies.vat_regime) The default VAT regime for sales to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "vat_regime", "editor": vat_regime1882 }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "item vat", "editable": true, "tooltip": "(contacts.Companies.item_vat) The default item VAT setting for sales to this customer.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "item_vat" }, { "colIndex": 21, "sortable": true, "header": "Invoicing Mode", "editable": true, "tooltip": "(contacts.Companies.imode) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "imode", "editor": imode1884 }, { "colIndex": 22, "sortable": true, "header": "prefix", "editable": true, "tooltip": "(contacts.Companies.prefix) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "prefix", "editor": prefix1885 }, { "colIndex": 23, "sortable": true, "header": "VAT id", "editable": true, "tooltip": "(contacts.Companies.vat_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "vat_id", "editor": vat_id1886 }, { "colIndex": 24, "sortable": true, "header": "Company type", "editable": true, "tooltip": "(contacts.Companies.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type1887 }, new Lino.NullNumberColumn({ "colIndex": 25, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.Companies.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1888, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.Companies.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.insertPanel = Ext.extend(Lino.contacts.Companies.InsertFormPanel,{
  empty_title: "New Companies",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/contacts/Companies",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    Lino.contacts.Companies.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Companies.insertPanel(p);
});

Lino.contacts.Companies.detailPanel = Ext.extend(Lino.contacts.Companies.DetailFormPanel,{
  empty_title: "Detail Companies",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/contacts/Companies",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    Lino.contacts.Companies.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Companies.detailPanel(p);
});
Lino.contacts.Companies.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Companies.GridPanel(p);
});

// js_render_GridPanel_class contacts.RoleTypes
Lino.contacts.RoleTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/RoleTypes",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Functions",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 18,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    var ww = this.containing_window;
    var id1890 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1891 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1892 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1893 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.RoleTypes.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1890, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(contacts.RoleTypes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1891 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(contacts.RoleTypes.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de1892 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(contacts.RoleTypes.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1893 } ];
    Lino.contacts.RoleTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.RoleTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.RoleTypes.GridPanel(p);
});

// js_render_GridPanel_class contacts.Roles
Lino.contacts.Roles.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Roles",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Contact Persons",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "type" }, 'typeHidden', { "name": "person" }, 'personHidden', { "name": "company" }, 'companyHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 21,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var id1895 = new Ext.form.NumberField({ "selectOnFocus": true });
    var type1896 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Roles/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Function..." });
    var person1897 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Roles/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Person..." });
    var company1898 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Roles/company", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Company..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.Roles.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1895, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Contact Role", "editable": true, "tooltip": "(contacts.Roles.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type1896 }, { "colIndex": 2, "sortable": true, "header": "Person", "editable": true, "tooltip": "(contacts.Roles.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('personHidden','Lino.contacts.Persons.detail'), "editor": person1897, "dataIndex": "person" }, { "colIndex": 3, "sortable": true, "header": "Company", "editable": true, "tooltip": "(contacts.Roles.company) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('companyHidden','Lino.contacts.Companies.detail'), "editor": company1898, "dataIndex": "company" } ];
    Lino.contacts.Roles.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Roles.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Roles.GridPanel(p);
});

// js_render_GridPanel_class households.Types
Lino.households.Types.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/households/Types",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Household Types",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 27,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Types.detail;
    this.ls_insert_handler = Lino.households.Types.insert;
    var ww = this.containing_window;
    var id1900 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1901 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1902 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1903 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(households.Types.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1900, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(households.Types.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1901 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(households.Types.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de1902 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(households.Types.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1903 } ];
    Lino.households.Types.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Types.insertPanel = Ext.extend(Lino.households.Types.DetailFormPanel,{
  empty_title: "New Household Types",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/households/Types",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Types.detail;
    this.ls_insert_handler = Lino.households.Types.insert;
    Lino.households.Types.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Types.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.households.Types.insertPanel(p);
});

Lino.households.Types.detailPanel = Ext.extend(Lino.households.Types.DetailFormPanel,{
  empty_title: "Detail Household Types",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/households/Types",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Types.detail;
    this.ls_insert_handler = Lino.households.Types.insert;
    Lino.households.Types.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Types.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Types.detailPanel(p);
});
Lino.households.Types.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Types.GridPanel(p);
});

// js_render_GridPanel_class households.Households
Lino.households.Households.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/households/Households",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Households",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "name": "payment_term" }, 'payment_termHidden', { "name": "vat_regime" }, 'vat_regimeHidden', { "type": "boolean", "name": "item_vat" }, { "name": "imode" }, 'imodeHidden', { "name": "prefix" }, { "name": "type" }, 'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 32,
  ls_grid_configs : [  ],
  content_type : 26,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 34,
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Households.detail;
    this.ls_insert_handler = Lino.households.Households.insert;
    var ww = this.containing_window;
    var name1905 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email1906 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var country1907 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Country..." });
    var city1908 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var region1909 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var zip_code1910 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr11911 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix1912 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street1913 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no1914 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box1915 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr21916 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language1917 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "allowBlank": false, "value": "en" });
    var url1918 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone1919 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm1920 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax1921 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks1922 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var payment_term1923 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Payment Term..." });
    var vat_regime1924 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var item_vat1925 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var imode1926 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Invoicing Mode..." });
    var prefix1927 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type1928 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Household Type..." });
    var id1929 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city1908.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1908.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region1909.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country1907.on('change',Lino.chooser_handler(city1908,'country'));
      region1909.on('change',Lino.chooser_handler(city1908,'region'));
      country1907.on('change',Lino.chooser_handler(region1909,'country'));
      Lino.households.Households.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "tooltip": "(households.Households.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1905 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(households.Households.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email1906 }, { "colIndex": 2, "sortable": true, "header": "Country", "editable": true, "tooltip": "(households.Households.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country1907, "dataIndex": "country" }, { "colIndex": 3, "sortable": true, "header": "Place", "editable": true, "tooltip": "(households.Households.city) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail'), "editor": city1908, "dataIndex": "city" }, { "colIndex": 4, "sortable": true, "header": "Region", "editable": true, "tooltip": "(households.Households.region) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail'), "editor": region1909, "dataIndex": "region" }, { "colIndex": 5, "sortable": true, "header": "Zip code", "editable": true, "tooltip": "(households.Households.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code1910 }, { "colIndex": 6, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "(households.Households.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr11911 }, { "colIndex": 7, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "(households.Households.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix1912 }, { "colIndex": 8, "sortable": true, "header": "Street", "editable": true, "tooltip": "(households.Households.street) Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street1913 }, { "colIndex": 9, "sortable": true, "header": "No.", "editable": true, "tooltip": "(households.Households.street_no) House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no1914 }, { "colIndex": 10, "sortable": true, "header": "Box", "editable": true, "tooltip": "(households.Households.street_box) Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box1915 }, { "colIndex": 11, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "(households.Households.addr2) Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr21916 }, { "colIndex": 12, "sortable": true, "header": "Language", "editable": true, "tooltip": "(households.Households.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language1917 }, { "colIndex": 13, "sortable": true, "header": "URL", "editable": true, "tooltip": "(households.Households.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url1918 }, { "colIndex": 14, "sortable": true, "header": "Phone", "editable": true, "tooltip": "(households.Households.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone1919 }, { "colIndex": 15, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(households.Households.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm1920 }, { "colIndex": 16, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(households.Households.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax1921 }, { "colIndex": 17, "sortable": false, "header": "Remarks", "editable": true, "tooltip": "(households.Households.remarks) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks1922, "dataIndex": "remarks" }, { "colIndex": 18, "sortable": true, "header": "Payment Term", "editable": true, "tooltip": "(households.Households.payment_term) The default payment term for sales invoices to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "payment_term", "editor": payment_term1923 }, { "colIndex": 19, "sortable": true, "header": "VAT Regime", "editable": true, "tooltip": "(households.Households.vat_regime) The default VAT regime for sales to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "vat_regime", "editor": vat_regime1924 }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "item vat", "editable": true, "tooltip": "(households.Households.item_vat) The default item VAT setting for sales to this customer.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "item_vat" }, { "colIndex": 21, "sortable": true, "header": "Invoicing Mode", "editable": true, "tooltip": "(households.Households.imode) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "imode", "editor": imode1926 }, { "colIndex": 22, "sortable": true, "header": "prefix", "editable": true, "tooltip": "(households.Households.prefix) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "prefix", "editor": prefix1927 }, { "colIndex": 23, "sortable": true, "header": "Household Type", "editable": true, "tooltip": "(households.Households.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('typeHidden','Lino.households.Types.detail'), "editor": type1928, "dataIndex": "type" }, new Lino.NullNumberColumn({ "colIndex": 24, "sortable": true, "format": "0", "editable": true, "tooltip": "(households.Households.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1929, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.households.Households.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Households.insertPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "New Households",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/households/Households",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Households.detail;
    this.ls_insert_handler = Lino.households.Households.insert;
    Lino.households.Households.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Households.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.households.Households.insertPanel(p);
});

Lino.households.Households.detailPanel = Ext.extend(Lino.households.Households.DetailFormPanel,{
  empty_title: "Detail Households",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/households/Households",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Households.detail;
    this.ls_insert_handler = Lino.households.Households.insert;
    Lino.households.Households.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Households.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Households.detailPanel(p);
});
Lino.households.Households.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Households.GridPanel(p);
});

// js_render_GridPanel_class households.Roles
Lino.households.Roles.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/households/Roles",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Household Roles",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "type": "boolean", "name": "name_giving" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 25,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Roles.detail;
    this.ls_insert_handler = Lino.households.Roles.insert;
    var ww = this.containing_window;
    var id1931 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1932 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1933 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1934 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_giving1935 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(households.Roles.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1931, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(households.Roles.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1932 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(households.Roles.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de1933 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(households.Roles.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1934 }, { "colIndex": 4, "sortable": false, "xtype": "checkcolumn", "header": "name-giving", "editable": true, "tooltip": "(households.Roles.name_giving) When the `name` field of a Household is empty, \nits value is computed by joining the `Last Name` \nof all name-giving members with a dash (\"-\").\n      ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "name_giving" } ];
    Lino.households.Roles.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Roles.insertPanel = Ext.extend(Lino.households.Roles.DetailFormPanel,{
  empty_title: "New Household Roles",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/households/Roles",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Roles.detail;
    this.ls_insert_handler = Lino.households.Roles.insert;
    Lino.households.Roles.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Roles.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.households.Roles.insertPanel(p);
});

Lino.households.Roles.detailPanel = Ext.extend(Lino.households.Roles.DetailFormPanel,{
  empty_title: "Detail Household Roles",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/households/Roles",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Roles.detail;
    this.ls_insert_handler = Lino.households.Roles.insert;
    Lino.households.Roles.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Roles.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Roles.detailPanel(p);
});
Lino.households.Roles.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Roles.GridPanel(p);
});

// js_render_GridPanel_class households.Members
Lino.households.Members.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/households/Members",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Household Members",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "role" }, 'roleHidden', { "name": "household" }, 'householdHidden', { "name": "person" }, 'personHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 24,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 10,
  initComponent : function() {
    var ww = this.containing_window;
    var id1937 = new Ext.form.NumberField({ "selectOnFocus": true });
    var role1938 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Members/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Household Role..." });
    var household1939 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Members/household", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Household..." });
    var person1940 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Members/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Person..." });
    var start_date1941 = new Lino.DateField({ "selectOnFocus": true });
    var end_date1942 = new Lino.DateField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(households.Members.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1937, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Household Role", "editable": true, "tooltip": "(households.Members.role) The Role of this Person in this Household.\nList of choices is configured in `Configure --> Households --> Roles`.\n", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('roleHidden','Lino.households.Roles.detail'), "editor": role1938, "dataIndex": "role" }, { "colIndex": 2, "sortable": true, "header": "Household", "editable": true, "tooltip": "(households.Members.household) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('householdHidden','Lino.households.Households.detail'), "editor": household1939, "dataIndex": "household" }, { "colIndex": 3, "sortable": true, "header": "Person", "editable": true, "tooltip": "(households.Members.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('personHidden','Lino.contacts.Persons.detail'), "editor": person1940, "dataIndex": "person" }, { "colIndex": 4, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(households.Members.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "From", "dataIndex": "start_date", "width": Lino.chars2width(9), "editor": start_date1941 }, { "colIndex": 5, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(households.Members.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Until", "dataIndex": "end_date", "width": Lino.chars2width(9), "editor": end_date1942 } ];
    Lino.households.Members.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Members.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Members.GridPanel(p);
});

// js_render_GridPanel_class outbox.Recipients
Lino.outbox.Recipients.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/outbox/Recipients",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Recipients",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "mail" }, 'mailHidden', { "name": "partner" }, 'partnerHidden', { "name": "type" }, 'typeHidden', { "name": "address" }, { "name": "name" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 42,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 10,
  initComponent : function() {
    var ww = this.containing_window;
    var id1944 = new Ext.form.NumberField({ "selectOnFocus": true });
    var mail1945 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Recipients/mail", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Outgoing Mail..." });
    var partner1946 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Recipients/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var type1947 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.outbox.RecipientType });
    var address1948 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var name1949 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(outbox.Recipients.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1944, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Outgoing Mail", "editable": true, "tooltip": "(outbox.Recipients.mail) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('mailHidden','Lino.outbox.Mails.detail'), "editor": mail1945, "dataIndex": "mail" }, { "colIndex": 2, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(outbox.Recipients.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner1946, "dataIndex": "partner" }, { "colIndex": 3, "sortable": true, "header": "Recipient Type", "editable": true, "tooltip": "(outbox.Recipients.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "type", "editor": type1947 }, { "colIndex": 4, "sortable": true, "header": "Address", "editable": true, "tooltip": "(outbox.Recipients.address) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "address", "editor": address1948 }, { "colIndex": 5, "sortable": true, "header": "Name", "editable": true, "tooltip": "(outbox.Recipients.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1949 } ];
    Lino.outbox.Recipients.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.Recipients.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.Recipients.GridPanel(p);
});

// js_render_GridPanel_class outbox.Mails
Lino.outbox.Mails.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/outbox/Mails",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Print", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Edit Print Template", "must_save": true, "panel_btn_handler": Lino.row_action_handler('edit_template','GET'), "text": "Edit Print Template", "overflowText": "Edit Print Template", "auto_save": true }, { "itemId": "send_mail", "menu_item_text": "Send email", "must_save": true, "tooltip": "Send email", "panel_btn_handler": Lino.row_action_handler('send_mail','GET'), "iconCls": "x-tbar-email_send", "overflowText": "Send email", "auto_save": true } ],
  title : "Outgoing Mails",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "sent" }, { "name": "recipients" }, { "name": "subject" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "user" }, 'userHidden', { "name": "project" }, 'projectHidden', { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "owner" }, { "name": "body" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 41,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 16,
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.Mails.detail;
    this.ls_insert_handler = Lino.outbox.Mails.insert;
    var ww = this.containing_window;
    var sent1951 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var recipients_htmlbox1952 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "recipients", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Recipients", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden" });
    var subject1953 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1954 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type1955 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id1956 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/owner_id", "method": "GET" }) }) });
    var user1957 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var project1958 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Course..." });
    var date1959 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var owner_disp1960 = new Ext.form.DisplayField({ "disabled": true });
    var body1961 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Body" });
    this.before_row_edit = function(record) {
      recipients_htmlbox1952.refresh();
      owner_id1956.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      body1961.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type1955.on('change',Lino.chooser_handler(owner_id1956,'owner_type'));
      Lino.outbox.Mails.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(17), "colIndex": 0, "sortable": true, "dataIndex": "sent", "header": "sent", "editable": false, "tooltip": "(outbox.Mails.sent) " }, { "width": Lino.chars2width(31), "colIndex": 1, "sortable": false, "dataIndex": "recipients", "header": "Recipients", "editable": false, "tooltip": "(outbox.Mails.recipients) " }, { "colIndex": 2, "sortable": true, "header": "Subject", "editable": true, "tooltip": "(outbox.Mails.subject) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "subject", "editor": subject1953 }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(outbox.Mails.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1954, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Controlled by (type)", "editable": true, "tooltip": "(outbox.Mails.owner_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.system.ContentTypes.detail'), "editor": owner_type1955, "dataIndex": "owner_type" }, { "colIndex": 5, "sortable": true, "header": "Controlled by (object)", "editable": true, "tooltip": "(outbox.Mails.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id1956 }, { "colIndex": 6, "sortable": true, "header": "Sender", "editable": true, "tooltip": "(outbox.Mails.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1957, "dataIndex": "user" }, { "colIndex": 7, "sortable": true, "header": "Course", "editable": true, "tooltip": "(outbox.Mails.project) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.courses.Courses.detail'), "editor": project1958, "dataIndex": "project" }, { "colIndex": 8, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(outbox.Mails.date) \n        The official date to be printed on the document.\n        ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "date", "width": Lino.chars2width(9), "editor": date1959 }, { "width": Lino.chars2width(11), "colIndex": 9, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "editable": false, "tooltip": "(outbox.Mails.owner) " }, { "colIndex": 10, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(outbox.Mails.body) ", "filter": { "type": "string" }, "header": "body", "renderer": Lino.text_renderer, "hidden": true, "editor": body1961, "dataIndex": "body" } ];
    Lino.outbox.Mails.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.Mails.insertPanel = Ext.extend(Lino.outbox.Mails.InsertFormPanel,{
  empty_title: "New Outgoing Mails",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/outbox/Mails",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.Mails.detail;
    this.ls_insert_handler = Lino.outbox.Mails.insert;
    Lino.outbox.Mails.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.Mails.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(20) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.outbox.Mails.insertPanel(p);
});

Lino.outbox.Mails.detailPanel = Ext.extend(Lino.outbox.Mails.DetailFormPanel,{
  empty_title: "Detail Outgoing Mails",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Print", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Edit Print Template", "must_save": true, "panel_btn_handler": Lino.row_action_handler('edit_template','GET'), "text": "Edit Print Template", "overflowText": "Edit Print Template", "auto_save": true }, { "itemId": "send_mail", "menu_item_text": "Send email", "must_save": true, "tooltip": "Send email", "panel_btn_handler": Lino.row_action_handler('send_mail','GET'), "iconCls": "x-tbar-email_send", "overflowText": "Send email", "auto_save": true } ],
  ls_url: "/outbox/Mails",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.Mails.detail;
    this.ls_insert_handler = Lino.outbox.Mails.insert;
    Lino.outbox.Mails.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.Mails.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.Mails.detailPanel(p);
});
Lino.outbox.Mails.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.Mails.GridPanel(p);
});

// js_render_GridPanel_class outbox.Attachments
Lino.outbox.Attachments.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/outbox/Attachments",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Attachments",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "mail" }, 'mailHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 43,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    var ww = this.containing_window;
    var id1963 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type1964 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Attachments/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id1965 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Attachments/owner_id", "method": "GET" }) }) });
    var mail1966 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Attachments/mail", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Outgoing Mail..." });
    var owner_disp1967 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id1965.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type1964.on('change',Lino.chooser_handler(owner_id1965,'owner_type'));
      Lino.outbox.Attachments.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(outbox.Attachments.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1963, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Controlled by (type)", "editable": true, "tooltip": "(outbox.Attachments.owner_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.system.ContentTypes.detail'), "editor": owner_type1964, "dataIndex": "owner_type" }, { "colIndex": 2, "sortable": true, "header": "Controlled by (object)", "editable": true, "tooltip": "(outbox.Attachments.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id1965 }, { "colIndex": 3, "sortable": true, "header": "Outgoing Mail", "editable": true, "tooltip": "(outbox.Attachments.mail) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('mailHidden','Lino.outbox.Mails.detail'), "editor": mail1966, "dataIndex": "mail" }, { "width": Lino.chars2width(11), "colIndex": 4, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "editable": false, "tooltip": "(outbox.Attachments.owner) " } ];
    Lino.outbox.Attachments.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.Attachments.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.Attachments.GridPanel(p);
});

// js_render_GridPanel_class notes.NoteTypes
Lino.notes.NoteTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/notes/NoteTypes",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Note Types",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "build_method" }, 'build_methodHidden', { "name": "template" }, { "type": "int", "name": "id" }, { "type": "boolean", "name": "attach_to_email" }, { "name": "email_template" }, { "type": "boolean", "name": "important" }, { "name": "remark" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 30,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 12,
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.NoteTypes.detail;
    this.ls_insert_handler = Lino.notes.NoteTypes.insert;
    var ww = this.containing_window;
    var name1969 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1970 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1971 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var build_method1972 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template1973 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NoteTypes/template", "method": "GET" }) }) });
    var id1974 = new Ext.form.NumberField({ "selectOnFocus": true });
    var attach_to_email1975 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var email_template1976 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NoteTypes/email_template", "method": "GET" }) }) });
    var important1977 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var remark1978 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
      template1973.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      build_method1972.on('change',Lino.chooser_handler(template1973,'build_method'));
      Lino.notes.NoteTypes.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(notes.NoteTypes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1969 }, { "colIndex": 1, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(notes.NoteTypes.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de1970 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(notes.NoteTypes.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1971 }, { "colIndex": 3, "sortable": true, "header": "Build method", "editable": true, "tooltip": "(notes.NoteTypes.build_method) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "build_method", "editor": build_method1972 }, { "colIndex": 4, "sortable": true, "header": "Template", "editable": true, "tooltip": "(notes.NoteTypes.template) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "template", "editor": template1973 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(notes.NoteTypes.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1974, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "Attach to email", "editable": true, "tooltip": "(notes.NoteTypes.attach_to_email) Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "attach_to_email" }, { "colIndex": 7, "sortable": true, "header": "Email template", "editable": true, "tooltip": "(notes.NoteTypes.email_template) The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "email_template", "editor": email_template1976 }, { "colIndex": 8, "sortable": false, "xtype": "checkcolumn", "header": "important", "editable": true, "tooltip": "(notes.NoteTypes.important) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "important" }, { "colIndex": 9, "sortable": false, "header": "Remark", "editable": true, "tooltip": "(notes.NoteTypes.remark) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remark1978, "dataIndex": "remark" } ];
    Lino.notes.NoteTypes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.NoteTypes.insertPanel = Ext.extend(Lino.notes.NoteTypes.DetailFormPanel,{
  empty_title: "New Note Types",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/notes/NoteTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.NoteTypes.detail;
    this.ls_insert_handler = Lino.notes.NoteTypes.insert;
    Lino.notes.NoteTypes.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.NoteTypes.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.notes.NoteTypes.insertPanel(p);
});

Lino.notes.NoteTypes.detailPanel = Ext.extend(Lino.notes.NoteTypes.DetailFormPanel,{
  empty_title: "Detail Note Types",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/notes/NoteTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.NoteTypes.detail;
    this.ls_insert_handler = Lino.notes.NoteTypes.insert;
    Lino.notes.NoteTypes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.NoteTypes.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.NoteTypes.detailPanel(p);
});
Lino.notes.NoteTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.NoteTypes.GridPanel(p);
});

// js_render_GridPanel_class notes.EventTypes
Lino.notes.EventTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/notes/EventTypes",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Event Types",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "type": "int", "name": "id" }, { "name": "remark" }, { "name": "body" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 29,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.EventTypes.detail;
    this.ls_insert_handler = Lino.notes.EventTypes.insert;
    var ww = this.containing_window;
    var name1980 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1981 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1982 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1983 = new Ext.form.NumberField({ "selectOnFocus": true });
    var remark1984 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var body1985 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Body" });
    this.before_row_edit = function(record) {
      body1985.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(notes.EventTypes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1980 }, { "colIndex": 1, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(notes.EventTypes.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de1981 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(notes.EventTypes.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1982 }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(notes.EventTypes.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1983, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": false, "header": "Remark", "editable": true, "tooltip": "(notes.EventTypes.remark) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remark1984, "dataIndex": "remark" }, { "colIndex": 5, "sortable": false, "header": "body", "editable": true, "tooltip": "(notes.EventTypes.body) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": body1985, "dataIndex": "body" } ];
    Lino.notes.EventTypes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.EventTypes.insertPanel = Ext.extend(Lino.notes.EventTypes.DetailFormPanel,{
  empty_title: "New Event Types",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/notes/EventTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.EventTypes.detail;
    this.ls_insert_handler = Lino.notes.EventTypes.insert;
    Lino.notes.EventTypes.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.EventTypes.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.notes.EventTypes.insertPanel(p);
});

Lino.notes.EventTypes.detailPanel = Ext.extend(Lino.notes.EventTypes.DetailFormPanel,{
  empty_title: "Detail Event Types",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/notes/EventTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.EventTypes.detail;
    this.ls_insert_handler = Lino.notes.EventTypes.insert;
    Lino.notes.EventTypes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.EventTypes.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.EventTypes.detailPanel(p);
});
Lino.notes.EventTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.EventTypes.GridPanel(p);
});

// js_render_GridPanel_class notes.Notes
Lino.notes.Notes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/notes/Notes",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Clear cache", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "Create email", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET'), "iconCls": "x-tbar-email_add", "overflowText": "Create email", "auto_save": true } ],
  title : "Events/Notes",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "user" }, 'userHidden', { "name": "event_type" }, 'event_typeHidden', { "name": "type" }, 'typeHidden', { "name": "project" }, 'projectHidden', { "name": "subject" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "build_time" }, { "name": "language" }, 'languageHidden', { "name": "owner" }, { "name": "body" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 28,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 21,
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.Notes.detail;
    this.ls_insert_handler = Lino.notes.Notes.insert;
    var ww = this.containing_window;
    var id1987 = new Ext.form.NumberField({ "selectOnFocus": true });
    var date1988 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var user1989 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var event_type1990 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Event Type..." });
    var type1991 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Note Type..." });
    var project1992 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Course..." });
    var subject1993 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var owner_type1994 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id1995 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/owner_id", "method": "GET" }) }) });
    var build_time1996 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var language1997 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "allowBlank": false, "value": "en" });
    var owner_disp1998 = new Ext.form.DisplayField({ "disabled": true });
    var body1999 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Body" });
    this.before_row_edit = function(record) {
      owner_id1995.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      body1999.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type1994.on('change',Lino.chooser_handler(owner_id1995,'owner_type'));
      Lino.notes.Notes.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(notes.Notes.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1987, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(notes.Notes.date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "date", "width": Lino.chars2width(9), "editor": date1988 }, { "colIndex": 2, "sortable": true, "header": "Author", "editable": true, "tooltip": "(notes.Notes.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1989, "dataIndex": "user" }, { "colIndex": 3, "sortable": true, "header": "Event Type (Form)", "editable": true, "tooltip": "(notes.Notes.event_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('event_typeHidden','Lino.notes.EventTypes.detail'), "editor": event_type1990, "dataIndex": "event_type" }, { "colIndex": 4, "sortable": true, "header": "Note Type (Content)", "editable": true, "tooltip": "(notes.Notes.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('typeHidden','Lino.notes.NoteTypes.detail'), "editor": type1991, "dataIndex": "type" }, { "colIndex": 5, "sortable": true, "header": "Course", "editable": true, "tooltip": "(notes.Notes.project) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.courses.Courses.detail'), "editor": project1992, "dataIndex": "project" }, { "colIndex": 6, "sortable": true, "header": "Subject", "editable": true, "tooltip": "(notes.Notes.subject) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "subject", "editor": subject1993 }, { "colIndex": 7, "sortable": true, "header": "Controlled by (type)", "editable": true, "tooltip": "(notes.Notes.owner_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.system.ContentTypes.detail'), "editor": owner_type1994, "dataIndex": "owner_type" }, { "colIndex": 8, "sortable": true, "header": "Controlled by (object)", "editable": true, "tooltip": "(notes.Notes.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id1995 }, { "width": Lino.chars2width(17), "colIndex": 9, "sortable": true, "dataIndex": "build_time", "header": "build time", "editable": false, "tooltip": "(notes.Notes.build_time) " }, { "colIndex": 10, "sortable": true, "header": "Language", "editable": true, "tooltip": "(notes.Notes.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language1997 }, { "width": Lino.chars2width(11), "colIndex": 11, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "editable": false, "tooltip": "(notes.Notes.owner) " }, { "colIndex": 12, "sortable": false, "header": "body", "editable": true, "tooltip": "(notes.Notes.body) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": body1999, "dataIndex": "body" } ];
    Lino.notes.Notes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.Notes.insertPanel = Ext.extend(Lino.notes.Notes.DetailFormPanel,{
  empty_title: "New Events/Notes",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/notes/Notes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.Notes.detail;
    this.ls_insert_handler = Lino.notes.Notes.insert;
    Lino.notes.Notes.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.Notes.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.notes.Notes.insertPanel(p);
});

Lino.notes.Notes.detailPanel = Ext.extend(Lino.notes.Notes.DetailFormPanel,{
  empty_title: "Detail Events/Notes",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Clear cache", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "Create email", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET'), "iconCls": "x-tbar-email_add", "overflowText": "Create email", "auto_save": true } ],
  ls_url: "/notes/Notes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.notes.Notes.detail;
    this.ls_insert_handler = Lino.notes.Notes.insert;
    Lino.notes.Notes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.notes.Notes.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.Notes.detailPanel(p);
});
Lino.notes.Notes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.notes.Notes.GridPanel(p);
});

// js_render_GridPanel_class cal.Calendars
Lino.cal.Calendars.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/Calendars",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Calendars",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "type" }, 'typeHidden', { "type": "int", "name": "color" }, { "type": "boolean", "name": "readonly" }, { "name": "build_method" }, 'build_methodHidden', { "name": "template" }, { "type": "int", "name": "id" }, { "type": "boolean", "name": "attach_to_email" }, { "name": "email_template" }, { "name": "description" }, { "name": "url_template" }, { "name": "username" }, { "name": "password" }, { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 10,
  ls_grid_configs : [  ],
  content_type : 38,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 19,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Calendars.detail;
    this.ls_insert_handler = Lino.cal.Calendars.insert;
    var ww = this.containing_window;
    var name2001 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de2002 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr2003 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type2004 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "local", "Local Calendar" ], [ "google", "Google Calendar" ] ], "allowBlank": false, "value": "local" });
    var color2005 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 1 });
    var readonly2006 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var build_method2007 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template2008 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/template", "method": "GET" }) }) });
    var id2009 = new Ext.form.NumberField({ "selectOnFocus": true });
    var attach_to_email2010 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var email_template2011 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/email_template", "method": "GET" }) }) });
    var description2012 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Description" });
    var url_template2013 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var username2014 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var password2015 = new Ext.form.TextField({ "selectOnFocus": true, "inputType": "password", "maxLength": 200 });
    var start_date2016 = new Lino.DateField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      template2008.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      description2012.refresh();
    };
    this.onRender = function(ct, position) {
      build_method2007.on('change',Lino.chooser_handler(template2008,'build_method'));
      Lino.cal.Calendars.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(cal.Calendars.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2001 }, { "colIndex": 1, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(cal.Calendars.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de2002 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(cal.Calendars.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2003 }, { "colIndex": 3, "sortable": true, "header": "Type", "editable": true, "tooltip": "(cal.Calendars.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type2004 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Calendars.color) ", "filter": { "type": "numeric" }, "header": "color", "dataIndex": "color", "width": Lino.chars2width(6), "editor": color2005 }), { "colIndex": 5, "sortable": false, "xtype": "checkcolumn", "header": "read-only", "editable": true, "tooltip": "(cal.Calendars.readonly) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "readonly" }, { "colIndex": 6, "sortable": true, "header": "Build method", "editable": true, "tooltip": "(cal.Calendars.build_method) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "build_method", "editor": build_method2007 }, { "colIndex": 7, "sortable": true, "header": "Template", "editable": true, "tooltip": "(cal.Calendars.template) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "template", "editor": template2008 }, new Lino.NullNumberColumn({ "colIndex": 8, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Calendars.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2009, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 9, "sortable": false, "xtype": "checkcolumn", "header": "Attach to email", "editable": true, "tooltip": "(cal.Calendars.attach_to_email) Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "attach_to_email" }, { "colIndex": 10, "sortable": true, "header": "Email template", "editable": true, "tooltip": "(cal.Calendars.email_template) The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "email_template", "editor": email_template2011 }, { "colIndex": 11, "sortable": false, "header": "description", "editable": true, "tooltip": "(cal.Calendars.description) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": description2012, "dataIndex": "description" }, { "colIndex": 12, "sortable": true, "header": "URL template", "editable": true, "tooltip": "(cal.Calendars.url_template) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url_template", "editor": url_template2013 }, { "colIndex": 13, "sortable": true, "header": "Username", "editable": true, "tooltip": "(cal.Calendars.username) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "username", "editor": username2014 }, { "colIndex": 14, "sortable": true, "header": "Password", "editable": true, "tooltip": "(cal.Calendars.password) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "password", "editor": password2015 }, { "colIndex": 15, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.Calendars.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Start date", "dataIndex": "start_date", "width": Lino.chars2width(9), "editor": start_date2016 } ];
    Lino.cal.Calendars.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Calendars.insertPanel = Ext.extend(Lino.cal.Calendars.InsertFormPanel,{
  empty_title: "New Calendars",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/cal/Calendars",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Calendars.detail;
    this.ls_insert_handler = Lino.cal.Calendars.insert;
    Lino.cal.Calendars.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Calendars.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Calendars.insertPanel(p);
});

Lino.cal.Calendars.detailPanel = Ext.extend(Lino.cal.Calendars.DetailFormPanel,{
  empty_title: "Detail Calendars",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/cal/Calendars",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Calendars.detail;
    this.ls_insert_handler = Lino.cal.Calendars.insert;
    Lino.cal.Calendars.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Calendars.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Calendars.detailPanel(p);
});
Lino.cal.Calendars.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Calendars.GridPanel(p);
});

// js_render_GridPanel_class cal.Subscriptions
Lino.cal.Subscriptions.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/Subscriptions",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Subscriptions",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "calendar" }, 'calendarHidden', { "type": "boolean", "name": "is_hidden" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 40,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    var ww = this.containing_window;
    var id2018 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user2019 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Subscriptions/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var calendar2020 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Subscriptions/calendar", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Calendar..." });
    var is_hidden2021 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Subscriptions.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2018, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Author", "editable": true, "tooltip": "(cal.Subscriptions.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2019, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "Calendar", "editable": true, "tooltip": "(cal.Subscriptions.calendar) The calendar you want to subscribe to.\nYou can subscribe to *non-private* calendars of *other* users.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.Calendars.detail'), "editor": calendar2020, "dataIndex": "calendar" }, { "colIndex": 3, "sortable": false, "xtype": "checkcolumn", "header": "hidden", "editable": true, "tooltip": "(cal.Subscriptions.is_hidden) Whether this subscription should initially be hidden in your calendar panel.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_hidden" } ];
    Lino.cal.Subscriptions.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Subscriptions.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Subscriptions.GridPanel(p);
});

// js_render_GridPanel_class cal.Rooms
Lino.cal.Rooms.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/Rooms",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Rooms",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 34,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Rooms.detail;
    this.ls_insert_handler = Lino.cal.Rooms.insert;
    var ww = this.containing_window;
    var id2023 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2024 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de2025 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr2026 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Rooms.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2023, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(cal.Rooms.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2024 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(cal.Rooms.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de2025 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(cal.Rooms.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2026 } ];
    Lino.cal.Rooms.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Rooms.insertPanel = Ext.extend(Lino.cal.Rooms.DetailFormPanel,{
  empty_title: "New Rooms",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/cal/Rooms",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Rooms.detail;
    this.ls_insert_handler = Lino.cal.Rooms.insert;
    Lino.cal.Rooms.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Rooms.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Rooms.insertPanel(p);
});

Lino.cal.Rooms.detailPanel = Ext.extend(Lino.cal.Rooms.DetailFormPanel,{
  empty_title: "Detail Rooms",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/cal/Rooms",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Rooms.detail;
    this.ls_insert_handler = Lino.cal.Rooms.insert;
    Lino.cal.Rooms.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Rooms.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Rooms.detailPanel(p);
});
Lino.cal.Rooms.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Rooms.GridPanel(p);
});

// js_render_GridPanel_class cal.Priorities
Lino.cal.Priorities.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/Priorities",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Priorities",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "type": "int", "name": "id" }, { "name": "ref" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 35,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var name2028 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de2029 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr2030 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id2031 = new Ext.form.NumberField({ "selectOnFocus": true });
    var ref2032 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": "1" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(cal.Priorities.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2028 }, { "colIndex": 1, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(cal.Priorities.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de2029 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(cal.Priorities.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2030 }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Priorities.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2031, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "ref", "editable": true, "tooltip": "(cal.Priorities.ref) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ref", "editor": ref2032 } ];
    Lino.cal.Priorities.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Priorities.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Priorities.GridPanel(p);
});

// js_render_GridPanel_class cal.Events
Lino.cal.Events.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/Events",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Clear cache", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "Create email", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET'), "iconCls": "x-tbar-email_add", "overflowText": "Create email", "auto_save": true } ],
  title : "Events",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "when_text" }, { "name": "user" }, 'userHidden', { "name": "summary" }, { "name": "calendar" }, 'calendarHidden', { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "created" }, { "name": "modified" }, { "name": "project" }, 'projectHidden', { "name": "build_time" }, { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "description" }, { "name": "uid" }, { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "room" }, 'roomHidden', { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 39,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 37,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Events.detail;
    this.ls_insert_handler = Lino.cal.Events.insert;
    var ww = this.containing_window;
    var when_text_disp2034 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var user2035 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var summary2036 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var calendar2037 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    var id2038 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2039 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id2040 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/owner_id", "method": "GET" }) }) });
    var created2041 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2042 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var project2043 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Course..." });
    var build_time2044 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var start_date2045 = new Lino.DateField({ "selectOnFocus": true });
    var start_time2046 = new Lino.TimeField({ "selectOnFocus": true });
    var end_date2047 = new Lino.DateField({ "selectOnFocus": true });
    var end_time2048 = new Lino.TimeField({ "selectOnFocus": true });
    var description2049 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Description" });
    var uid2050 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var access_class2051 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var sequence2052 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type2053 = new Ext.form.NumberField({ "disabled": true });
    var transparent2054 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var room2055 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/room", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Room..." });
    var priority2056 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Priority..." });
    var state2057 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var assigned_to2058 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var owner_disp2059 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id2040.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description2049.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2039.on('change',Lino.chooser_handler(owner_id2040,'owner_type'));
      Lino.cal.Events.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "when_text", "header": "When", "editable": false, "tooltip": "(cal.Events.when_text) " }, { "colIndex": 1, "sortable": true, "header": "Responsible user", "editable": true, "tooltip": "(cal.Events.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2035, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "Summary", "editable": true, "tooltip": "(cal.Events.summary) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary2036 }, { "colIndex": 3, "sortable": true, "header": "Calendar", "editable": true, "tooltip": "(cal.Events.calendar) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.Calendars.detail'), "editor": calendar2037, "dataIndex": "calendar" }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Events.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2038, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.Events.owner_type) ", "filter": { "type": "string" }, "header": "Controlled by (type)", "renderer": Lino.fk_renderer('owner_typeHidden','Lino.system.ContentTypes.detail'), "hidden": true, "editor": owner_type2039, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Controlled by (object)", "editable": true, "tooltip": "(cal.Events.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "hidden": true, "editor": owner_id2040 }, { "colIndex": 7, "sortable": true, "header": "Created", "editable": false, "tooltip": "(cal.Events.created) ", "width": Lino.chars2width(17), "dataIndex": "created", "hidden": true }, { "colIndex": 8, "sortable": true, "header": "Modified", "editable": false, "tooltip": "(cal.Events.modified) ", "width": Lino.chars2width(17), "dataIndex": "modified", "hidden": true }, { "colIndex": 9, "sortable": true, "header": "Course", "editable": true, "tooltip": "(cal.Events.project) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.courses.Courses.detail'), "editor": project2043, "dataIndex": "project" }, { "colIndex": 10, "sortable": true, "header": "build time", "editable": false, "tooltip": "(cal.Events.build_time) ", "width": Lino.chars2width(17), "dataIndex": "build_time", "hidden": true }, { "colIndex": 11, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.Events.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Start date", "dataIndex": "start_date", "width": Lino.chars2width(9), "editor": start_date2045 }, { "colIndex": 12, "sortable": true, "header": "Start time", "editable": true, "tooltip": "(cal.Events.start_time) ", "width": Lino.chars2width(9), "dataIndex": "start_time", "editor": start_time2046 }, { "colIndex": 13, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.Events.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "End Date", "dataIndex": "end_date", "hidden": true, "width": Lino.chars2width(9), "editor": end_date2047 }, { "colIndex": 14, "sortable": true, "header": "End Time", "editable": true, "tooltip": "(cal.Events.end_time) ", "width": Lino.chars2width(9), "dataIndex": "end_time", "hidden": true, "editor": end_time2048 }, { "colIndex": 15, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(cal.Events.description) ", "filter": { "type": "string" }, "header": "description", "renderer": Lino.text_renderer, "hidden": true, "editor": description2049, "dataIndex": "description" }, { "colIndex": 16, "sortable": true, "header": "UID", "editable": true, "tooltip": "(cal.Events.uid) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "uid", "hidden": true, "editor": uid2050 }, { "colIndex": 17, "sortable": true, "header": "Access Class", "editable": true, "tooltip": "(cal.Events.access_class) Whether this is private, public or between.", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "access_class", "hidden": true, "editor": access_class2051 }, new Lino.NullNumberColumn({ "colIndex": 18, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Events.sequence) ", "filter": { "type": "numeric" }, "header": "Revision", "dataIndex": "sequence", "hidden": true, "width": Lino.chars2width(6), "editor": sequence2052 }), new Lino.NullNumberColumn({ "colIndex": 19, "sortable": true, "format": "0", "editable": false, "tooltip": "(cal.Events.auto_type) ", "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "Transparent", "editable": true, "tooltip": "(cal.Events.transparent) Indicates that this Event shouldn't prevent other Events at the same time.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "transparent", "hidden": true }, { "colIndex": 21, "sortable": true, "header": "Room", "editable": true, "tooltip": "(cal.Events.room) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('roomHidden','Lino.cal.Rooms.detail'), "editor": room2055, "dataIndex": "room" }, { "colIndex": 22, "sortable": true, "header": "Priority", "editable": true, "tooltip": "(cal.Events.priority) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "priority", "hidden": true, "editor": priority2056 }, { "colIndex": 23, "sortable": true, "header": "State", "editable": true, "tooltip": "(cal.Events.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "state", "editor": state2057 }, { "colIndex": 24, "sortable": true, "header": "Assigned to", "editable": true, "tooltip": "(cal.Events.assigned_to) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('assigned_toHidden','Lino.users.Users.detail'), "editor": assigned_to2058, "dataIndex": "assigned_to" }, { "colIndex": 25, "sortable": false, "header": "Controlled by", "editable": false, "tooltip": "(cal.Events.owner) ", "width": Lino.chars2width(11), "dataIndex": "owner", "hidden": true } ];
    Lino.cal.Events.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Events.insertPanel = Ext.extend(Lino.cal.Events.InsertFormPanel,{
  empty_title: "New Events",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/cal/Events",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Events.detail;
    this.ls_insert_handler = Lino.cal.Events.insert;
    Lino.cal.Events.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Events.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Events.insertPanel(p);
});

Lino.cal.Events.detailPanel = Ext.extend(Lino.cal.Events.DetailFormPanel,{
  empty_title: "Detail Events",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Clear cache", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "Create email", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET'), "iconCls": "x-tbar-email_add", "overflowText": "Create email", "auto_save": true } ],
  ls_url: "/cal/Events",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Events.detail;
    this.ls_insert_handler = Lino.cal.Events.insert;
    Lino.cal.Events.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Events.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Events.detailPanel(p);
});
Lino.cal.Events.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Events.ParamsPanel({});
  return new Lino.cal.Events.GridPanel(p);
});

// js_render_GridPanel_class cal.MyEvents
Lino.cal.MyEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/MyEvents",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Clear cache", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "Create email", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET'), "iconCls": "x-tbar-email_add", "overflowText": "Create email", "auto_save": true } ],
  title : "Events",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "when_text" }, { "name": "calendar" }, 'calendarHidden', { "name": "project" }, 'projectHidden', { "name": "summary" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "user" }, 'userHidden', { "name": "created" }, { "name": "modified" }, { "name": "build_time" }, { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "description" }, { "name": "uid" }, { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "room" }, 'roomHidden', { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 39,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 37,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEvents.detail;
    this.ls_insert_handler = Lino.cal.MyEvents.insert;
    var ww = this.containing_window;
    var when_text_disp2061 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var calendar2062 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    var project2063 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Course..." });
    var summary2064 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id2065 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2066 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id2067 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/owner_id", "method": "GET" }) }) });
    var user2068 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var created2069 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2070 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_time2071 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var start_date2072 = new Lino.DateField({ "selectOnFocus": true });
    var start_time2073 = new Lino.TimeField({ "selectOnFocus": true });
    var end_date2074 = new Lino.DateField({ "selectOnFocus": true });
    var end_time2075 = new Lino.TimeField({ "selectOnFocus": true });
    var description2076 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Description" });
    var uid2077 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var access_class2078 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var sequence2079 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type2080 = new Ext.form.NumberField({ "disabled": true });
    var transparent2081 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var room2082 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/room", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Room..." });
    var priority2083 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Priority..." });
    var state2084 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var assigned_to2085 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var owner_disp2086 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id2067.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description2076.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2066.on('change',Lino.chooser_handler(owner_id2067,'owner_type'));
      Lino.cal.MyEvents.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "when_text", "header": "When", "editable": false, "tooltip": "(cal.MyEvents.when_text) " }, { "colIndex": 1, "sortable": true, "header": "Calendar", "editable": true, "tooltip": "(cal.MyEvents.calendar) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.Calendars.detail'), "editor": calendar2062, "dataIndex": "calendar" }, { "colIndex": 2, "sortable": true, "header": "Course", "editable": true, "tooltip": "(cal.MyEvents.project) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.courses.Courses.detail'), "editor": project2063, "dataIndex": "project" }, { "colIndex": 3, "sortable": true, "header": "Summary", "editable": true, "tooltip": "(cal.MyEvents.summary) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary2064 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.MyEvents.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2065, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.MyEvents.owner_type) ", "filter": { "type": "string" }, "header": "Controlled by (type)", "renderer": Lino.fk_renderer('owner_typeHidden','Lino.system.ContentTypes.detail'), "hidden": true, "editor": owner_type2066, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Controlled by (object)", "editable": true, "tooltip": "(cal.MyEvents.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "hidden": true, "editor": owner_id2067 }, { "colIndex": 7, "sortable": true, "header": "Responsible user", "editable": true, "tooltip": "(cal.MyEvents.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2068, "dataIndex": "user" }, { "colIndex": 8, "sortable": true, "header": "Created", "editable": false, "tooltip": "(cal.MyEvents.created) ", "width": Lino.chars2width(17), "dataIndex": "created", "hidden": true }, { "colIndex": 9, "sortable": true, "header": "Modified", "editable": false, "tooltip": "(cal.MyEvents.modified) ", "width": Lino.chars2width(17), "dataIndex": "modified", "hidden": true }, { "colIndex": 10, "sortable": true, "header": "build time", "editable": false, "tooltip": "(cal.MyEvents.build_time) ", "width": Lino.chars2width(17), "dataIndex": "build_time", "hidden": true }, { "colIndex": 11, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.MyEvents.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Start date", "dataIndex": "start_date", "width": Lino.chars2width(9), "editor": start_date2072 }, { "colIndex": 12, "sortable": true, "header": "Start time", "editable": true, "tooltip": "(cal.MyEvents.start_time) ", "width": Lino.chars2width(9), "dataIndex": "start_time", "editor": start_time2073 }, { "colIndex": 13, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.MyEvents.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "End Date", "dataIndex": "end_date", "hidden": true, "width": Lino.chars2width(9), "editor": end_date2074 }, { "colIndex": 14, "sortable": true, "header": "End Time", "editable": true, "tooltip": "(cal.MyEvents.end_time) ", "width": Lino.chars2width(9), "dataIndex": "end_time", "hidden": true, "editor": end_time2075 }, { "colIndex": 15, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(cal.MyEvents.description) ", "filter": { "type": "string" }, "header": "description", "renderer": Lino.text_renderer, "hidden": true, "editor": description2076, "dataIndex": "description" }, { "colIndex": 16, "sortable": true, "header": "UID", "editable": true, "tooltip": "(cal.MyEvents.uid) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "uid", "hidden": true, "editor": uid2077 }, { "colIndex": 17, "sortable": true, "header": "Access Class", "editable": true, "tooltip": "(cal.MyEvents.access_class) Whether this is private, public or between.", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "access_class", "hidden": true, "editor": access_class2078 }, new Lino.NullNumberColumn({ "colIndex": 18, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.MyEvents.sequence) ", "filter": { "type": "numeric" }, "header": "Revision", "dataIndex": "sequence", "hidden": true, "width": Lino.chars2width(6), "editor": sequence2079 }), new Lino.NullNumberColumn({ "colIndex": 19, "sortable": true, "format": "0", "editable": false, "tooltip": "(cal.MyEvents.auto_type) ", "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "Transparent", "editable": true, "tooltip": "(cal.MyEvents.transparent) Indicates that this Event shouldn't prevent other Events at the same time.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "transparent", "hidden": true }, { "colIndex": 21, "sortable": true, "header": "Room", "editable": true, "tooltip": "(cal.MyEvents.room) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('roomHidden','Lino.cal.Rooms.detail'), "editor": room2082, "dataIndex": "room" }, { "colIndex": 22, "sortable": true, "header": "Priority", "editable": true, "tooltip": "(cal.MyEvents.priority) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "priority", "hidden": true, "editor": priority2083 }, { "colIndex": 23, "sortable": true, "header": "State", "editable": true, "tooltip": "(cal.MyEvents.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "state", "editor": state2084 }, { "colIndex": 24, "sortable": true, "header": "Assigned to", "editable": true, "tooltip": "(cal.MyEvents.assigned_to) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('assigned_toHidden','Lino.users.Users.detail'), "editor": assigned_to2085, "dataIndex": "assigned_to" }, { "colIndex": 25, "sortable": false, "header": "Controlled by", "editable": false, "tooltip": "(cal.MyEvents.owner) ", "width": Lino.chars2width(11), "dataIndex": "owner", "hidden": true } ];
    Lino.cal.MyEvents.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyEvents.insertPanel = Ext.extend(Lino.cal.Events.InsertFormPanel,{
  empty_title: "New Events",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/cal/MyEvents",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEvents.detail;
    this.ls_insert_handler = Lino.cal.MyEvents.insert;
    Lino.cal.MyEvents.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEvents.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyEvents.insertPanel(p);
});

Lino.cal.MyEvents.detailPanel = Ext.extend(Lino.cal.Events.DetailFormPanel,{
  empty_title: "Detail Events",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Clear cache", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "Create email", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET'), "iconCls": "x-tbar-email_add", "overflowText": "Create email", "auto_save": true } ],
  ls_url: "/cal/MyEvents",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEvents.detail;
    this.ls_insert_handler = Lino.cal.MyEvents.insert;
    Lino.cal.MyEvents.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEvents.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyEvents.detailPanel(p);
});
Lino.cal.MyEvents.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Events.ParamsPanel({});
  return new Lino.cal.MyEvents.GridPanel(p);
});

// js_render_GridPanel_class cal.MyUnclearEvents
Lino.cal.MyUnclearEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/MyUnclearEvents",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Clear cache", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "Create email", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET'), "iconCls": "x-tbar-email_add", "overflowText": "Create email", "auto_save": true } ],
  title : "My unclear events",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "when_text" }, { "name": "project" }, 'projectHidden', { "name": "summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "user" }, 'userHidden', { "name": "created" }, { "name": "modified" }, { "name": "build_time" }, { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "description" }, { "name": "uid" }, { "name": "calendar" }, 'calendarHidden', { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "room" }, 'roomHidden', { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 39,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 38,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyUnclearEvents.detail;
    this.ls_insert_handler = Lino.cal.MyUnclearEvents.insert;
    var ww = this.containing_window;
    var when_text_disp2088 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var project2089 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyUnclearEvents/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Course..." });
    var summary2090 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp2091 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id2092 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2093 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyUnclearEvents/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id2094 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyUnclearEvents/owner_id", "method": "GET" }) }) });
    var user2095 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyUnclearEvents/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var created2096 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2097 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_time2098 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var start_date2099 = new Lino.DateField({ "selectOnFocus": true });
    var start_time2100 = new Lino.TimeField({ "selectOnFocus": true });
    var end_date2101 = new Lino.DateField({ "selectOnFocus": true });
    var end_time2102 = new Lino.TimeField({ "selectOnFocus": true });
    var description2103 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Description" });
    var uid2104 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var calendar2105 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyUnclearEvents/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    var access_class2106 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var sequence2107 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type2108 = new Ext.form.NumberField({ "disabled": true });
    var transparent2109 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var room2110 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyUnclearEvents/room", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Room..." });
    var priority2111 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyUnclearEvents/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Priority..." });
    var state2112 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var assigned_to2113 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyUnclearEvents/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var owner_disp2114 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id2094.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description2103.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2093.on('change',Lino.chooser_handler(owner_id2094,'owner_type'));
      Lino.cal.MyUnclearEvents.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "when_text", "header": "When", "editable": false, "tooltip": "(cal.MyUnclearEvents.when_text) " }, { "colIndex": 1, "sortable": true, "header": "Course", "editable": true, "tooltip": "(cal.MyUnclearEvents.project) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.courses.Courses.detail'), "editor": project2089, "dataIndex": "project" }, { "colIndex": 2, "sortable": true, "header": "Summary", "editable": true, "tooltip": "(cal.MyUnclearEvents.summary) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary2090 }, { "width": Lino.chars2width(31), "colIndex": 3, "sortable": false, "dataIndex": "workflow_buttons", "header": "Workflow", "editable": false, "tooltip": "(cal.MyUnclearEvents.workflow_buttons) " }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.MyUnclearEvents.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2092, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.MyUnclearEvents.owner_type) ", "filter": { "type": "string" }, "header": "Controlled by (type)", "renderer": Lino.fk_renderer('owner_typeHidden','Lino.system.ContentTypes.detail'), "hidden": true, "editor": owner_type2093, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Controlled by (object)", "editable": true, "tooltip": "(cal.MyUnclearEvents.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "hidden": true, "editor": owner_id2094 }, { "colIndex": 7, "sortable": true, "header": "Responsible user", "editable": true, "tooltip": "(cal.MyUnclearEvents.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2095, "dataIndex": "user" }, { "colIndex": 8, "sortable": true, "header": "Created", "editable": false, "tooltip": "(cal.MyUnclearEvents.created) ", "width": Lino.chars2width(17), "dataIndex": "created", "hidden": true }, { "colIndex": 9, "sortable": true, "header": "Modified", "editable": false, "tooltip": "(cal.MyUnclearEvents.modified) ", "width": Lino.chars2width(17), "dataIndex": "modified", "hidden": true }, { "colIndex": 10, "sortable": true, "header": "build time", "editable": false, "tooltip": "(cal.MyUnclearEvents.build_time) ", "width": Lino.chars2width(17), "dataIndex": "build_time", "hidden": true }, { "colIndex": 11, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.MyUnclearEvents.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Start date", "dataIndex": "start_date", "width": Lino.chars2width(9), "editor": start_date2099 }, { "colIndex": 12, "sortable": true, "header": "Start time", "editable": true, "tooltip": "(cal.MyUnclearEvents.start_time) ", "width": Lino.chars2width(9), "dataIndex": "start_time", "editor": start_time2100 }, { "colIndex": 13, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.MyUnclearEvents.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "End Date", "dataIndex": "end_date", "hidden": true, "width": Lino.chars2width(9), "editor": end_date2101 }, { "colIndex": 14, "sortable": true, "header": "End Time", "editable": true, "tooltip": "(cal.MyUnclearEvents.end_time) ", "width": Lino.chars2width(9), "dataIndex": "end_time", "hidden": true, "editor": end_time2102 }, { "colIndex": 15, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(cal.MyUnclearEvents.description) ", "filter": { "type": "string" }, "header": "description", "renderer": Lino.text_renderer, "hidden": true, "editor": description2103, "dataIndex": "description" }, { "colIndex": 16, "sortable": true, "header": "UID", "editable": true, "tooltip": "(cal.MyUnclearEvents.uid) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "uid", "hidden": true, "editor": uid2104 }, { "colIndex": 17, "sortable": true, "header": "Calendar", "editable": true, "tooltip": "(cal.MyUnclearEvents.calendar) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.Calendars.detail'), "editor": calendar2105, "dataIndex": "calendar" }, { "colIndex": 18, "sortable": true, "header": "Access Class", "editable": true, "tooltip": "(cal.MyUnclearEvents.access_class) Whether this is private, public or between.", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "access_class", "hidden": true, "editor": access_class2106 }, new Lino.NullNumberColumn({ "colIndex": 19, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.MyUnclearEvents.sequence) ", "filter": { "type": "numeric" }, "header": "Revision", "dataIndex": "sequence", "hidden": true, "width": Lino.chars2width(6), "editor": sequence2107 }), new Lino.NullNumberColumn({ "colIndex": 20, "sortable": true, "format": "0", "editable": false, "tooltip": "(cal.MyUnclearEvents.auto_type) ", "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 21, "sortable": false, "xtype": "checkcolumn", "header": "Transparent", "editable": true, "tooltip": "(cal.MyUnclearEvents.transparent) Indicates that this Event shouldn't prevent other Events at the same time.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "transparent", "hidden": true }, { "colIndex": 22, "sortable": true, "header": "Room", "editable": true, "tooltip": "(cal.MyUnclearEvents.room) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('roomHidden','Lino.cal.Rooms.detail'), "editor": room2110, "dataIndex": "room" }, { "colIndex": 23, "sortable": true, "header": "Priority", "editable": true, "tooltip": "(cal.MyUnclearEvents.priority) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "priority", "hidden": true, "editor": priority2111 }, { "colIndex": 24, "sortable": true, "header": "State", "editable": true, "tooltip": "(cal.MyUnclearEvents.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "state", "editor": state2112 }, { "colIndex": 25, "sortable": true, "header": "Assigned to", "editable": true, "tooltip": "(cal.MyUnclearEvents.assigned_to) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('assigned_toHidden','Lino.users.Users.detail'), "editor": assigned_to2113, "dataIndex": "assigned_to" }, { "colIndex": 26, "sortable": false, "header": "Controlled by", "editable": false, "tooltip": "(cal.MyUnclearEvents.owner) ", "width": Lino.chars2width(11), "dataIndex": "owner", "hidden": true } ];
    Lino.cal.MyUnclearEvents.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyUnclearEvents.insertPanel = Ext.extend(Lino.cal.Events.InsertFormPanel,{
  empty_title: "New My unclear events",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/cal/MyUnclearEvents",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyUnclearEvents.detail;
    this.ls_insert_handler = Lino.cal.MyUnclearEvents.insert;
    Lino.cal.MyUnclearEvents.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyUnclearEvents.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyUnclearEvents.insertPanel(p);
});

Lino.cal.MyUnclearEvents.detailPanel = Ext.extend(Lino.cal.Events.DetailFormPanel,{
  empty_title: "Detail My unclear events",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Clear cache", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "Create email", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET'), "iconCls": "x-tbar-email_add", "overflowText": "Create email", "auto_save": true } ],
  ls_url: "/cal/MyUnclearEvents",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyUnclearEvents.detail;
    this.ls_insert_handler = Lino.cal.MyUnclearEvents.insert;
    Lino.cal.MyUnclearEvents.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyUnclearEvents.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyUnclearEvents.detailPanel(p);
});
Lino.cal.MyUnclearEvents.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Events.ParamsPanel({});
  return new Lino.cal.MyUnclearEvents.GridPanel(p);
});

// js_render_GridPanel_class cal.EventsAssignedToMe
Lino.cal.EventsAssignedToMe.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/EventsAssignedToMe",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Clear cache", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "Create email", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET'), "iconCls": "x-tbar-email_add", "overflowText": "Create email", "auto_save": true } ],
  title : "Events",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "when_text" }, { "name": "project" }, 'projectHidden', { "name": "summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "user" }, 'userHidden', { "name": "created" }, { "name": "modified" }, { "name": "build_time" }, { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "description" }, { "name": "uid" }, { "name": "calendar" }, 'calendarHidden', { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "room" }, 'roomHidden', { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 39,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 38,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsAssignedToMe.detail;
    this.ls_insert_handler = Lino.cal.EventsAssignedToMe.insert;
    var ww = this.containing_window;
    var when_text_disp2116 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var project2117 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsAssignedToMe/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Course..." });
    var summary2118 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp2119 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id2120 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2121 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsAssignedToMe/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id2122 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsAssignedToMe/owner_id", "method": "GET" }) }) });
    var user2123 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsAssignedToMe/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var created2124 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2125 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_time2126 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var start_date2127 = new Lino.DateField({ "selectOnFocus": true });
    var start_time2128 = new Lino.TimeField({ "selectOnFocus": true });
    var end_date2129 = new Lino.DateField({ "selectOnFocus": true });
    var end_time2130 = new Lino.TimeField({ "selectOnFocus": true });
    var description2131 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Description" });
    var uid2132 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var calendar2133 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsAssignedToMe/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    var access_class2134 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var sequence2135 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type2136 = new Ext.form.NumberField({ "disabled": true });
    var transparent2137 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var room2138 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsAssignedToMe/room", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Room..." });
    var priority2139 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsAssignedToMe/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Priority..." });
    var state2140 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var assigned_to2141 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsAssignedToMe/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var owner_disp2142 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id2122.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description2131.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2121.on('change',Lino.chooser_handler(owner_id2122,'owner_type'));
      Lino.cal.EventsAssignedToMe.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "when_text", "header": "When", "editable": false, "tooltip": "(cal.EventsAssignedToMe.when_text) " }, { "colIndex": 1, "sortable": true, "header": "Course", "editable": true, "tooltip": "(cal.EventsAssignedToMe.project) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.courses.Courses.detail'), "editor": project2117, "dataIndex": "project" }, { "colIndex": 2, "sortable": true, "header": "Summary", "editable": true, "tooltip": "(cal.EventsAssignedToMe.summary) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary2118 }, { "width": Lino.chars2width(31), "colIndex": 3, "sortable": false, "dataIndex": "workflow_buttons", "header": "Workflow", "editable": false, "tooltip": "(cal.EventsAssignedToMe.workflow_buttons) " }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.EventsAssignedToMe.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2120, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.EventsAssignedToMe.owner_type) ", "filter": { "type": "string" }, "header": "Controlled by (type)", "renderer": Lino.fk_renderer('owner_typeHidden','Lino.system.ContentTypes.detail'), "hidden": true, "editor": owner_type2121, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Controlled by (object)", "editable": true, "tooltip": "(cal.EventsAssignedToMe.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "hidden": true, "editor": owner_id2122 }, { "colIndex": 7, "sortable": true, "header": "Responsible user", "editable": true, "tooltip": "(cal.EventsAssignedToMe.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2123, "dataIndex": "user" }, { "colIndex": 8, "sortable": true, "header": "Created", "editable": false, "tooltip": "(cal.EventsAssignedToMe.created) ", "width": Lino.chars2width(17), "dataIndex": "created", "hidden": true }, { "colIndex": 9, "sortable": true, "header": "Modified", "editable": false, "tooltip": "(cal.EventsAssignedToMe.modified) ", "width": Lino.chars2width(17), "dataIndex": "modified", "hidden": true }, { "colIndex": 10, "sortable": true, "header": "build time", "editable": false, "tooltip": "(cal.EventsAssignedToMe.build_time) ", "width": Lino.chars2width(17), "dataIndex": "build_time", "hidden": true }, { "colIndex": 11, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.EventsAssignedToMe.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Start date", "dataIndex": "start_date", "width": Lino.chars2width(9), "editor": start_date2127 }, { "colIndex": 12, "sortable": true, "header": "Start time", "editable": true, "tooltip": "(cal.EventsAssignedToMe.start_time) ", "width": Lino.chars2width(9), "dataIndex": "start_time", "editor": start_time2128 }, { "colIndex": 13, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.EventsAssignedToMe.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "End Date", "dataIndex": "end_date", "hidden": true, "width": Lino.chars2width(9), "editor": end_date2129 }, { "colIndex": 14, "sortable": true, "header": "End Time", "editable": true, "tooltip": "(cal.EventsAssignedToMe.end_time) ", "width": Lino.chars2width(9), "dataIndex": "end_time", "hidden": true, "editor": end_time2130 }, { "colIndex": 15, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(cal.EventsAssignedToMe.description) ", "filter": { "type": "string" }, "header": "description", "renderer": Lino.text_renderer, "hidden": true, "editor": description2131, "dataIndex": "description" }, { "colIndex": 16, "sortable": true, "header": "UID", "editable": true, "tooltip": "(cal.EventsAssignedToMe.uid) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "uid", "hidden": true, "editor": uid2132 }, { "colIndex": 17, "sortable": true, "header": "Calendar", "editable": true, "tooltip": "(cal.EventsAssignedToMe.calendar) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.Calendars.detail'), "editor": calendar2133, "dataIndex": "calendar" }, { "colIndex": 18, "sortable": true, "header": "Access Class", "editable": true, "tooltip": "(cal.EventsAssignedToMe.access_class) Whether this is private, public or between.", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "access_class", "hidden": true, "editor": access_class2134 }, new Lino.NullNumberColumn({ "colIndex": 19, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.EventsAssignedToMe.sequence) ", "filter": { "type": "numeric" }, "header": "Revision", "dataIndex": "sequence", "hidden": true, "width": Lino.chars2width(6), "editor": sequence2135 }), new Lino.NullNumberColumn({ "colIndex": 20, "sortable": true, "format": "0", "editable": false, "tooltip": "(cal.EventsAssignedToMe.auto_type) ", "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 21, "sortable": false, "xtype": "checkcolumn", "header": "Transparent", "editable": true, "tooltip": "(cal.EventsAssignedToMe.transparent) Indicates that this Event shouldn't prevent other Events at the same time.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "transparent", "hidden": true }, { "colIndex": 22, "sortable": true, "header": "Room", "editable": true, "tooltip": "(cal.EventsAssignedToMe.room) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('roomHidden','Lino.cal.Rooms.detail'), "editor": room2138, "dataIndex": "room" }, { "colIndex": 23, "sortable": true, "header": "Priority", "editable": true, "tooltip": "(cal.EventsAssignedToMe.priority) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "priority", "hidden": true, "editor": priority2139 }, { "colIndex": 24, "sortable": true, "header": "State", "editable": true, "tooltip": "(cal.EventsAssignedToMe.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "state", "editor": state2140 }, { "colIndex": 25, "sortable": true, "header": "Assigned to", "editable": true, "tooltip": "(cal.EventsAssignedToMe.assigned_to) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('assigned_toHidden','Lino.users.Users.detail'), "editor": assigned_to2141, "dataIndex": "assigned_to" }, { "colIndex": 26, "sortable": false, "header": "Controlled by", "editable": false, "tooltip": "(cal.EventsAssignedToMe.owner) ", "width": Lino.chars2width(11), "dataIndex": "owner", "hidden": true } ];
    Lino.cal.EventsAssignedToMe.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.EventsAssignedToMe.insertPanel = Ext.extend(Lino.cal.Events.InsertFormPanel,{
  empty_title: "New Events",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/cal/EventsAssignedToMe",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsAssignedToMe.detail;
    this.ls_insert_handler = Lino.cal.EventsAssignedToMe.insert;
    Lino.cal.EventsAssignedToMe.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsAssignedToMe.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.EventsAssignedToMe.insertPanel(p);
});

Lino.cal.EventsAssignedToMe.detailPanel = Ext.extend(Lino.cal.Events.DetailFormPanel,{
  empty_title: "Detail Events",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Clear cache", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "Create email", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET'), "iconCls": "x-tbar-email_add", "overflowText": "Create email", "auto_save": true } ],
  ls_url: "/cal/EventsAssignedToMe",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsAssignedToMe.detail;
    this.ls_insert_handler = Lino.cal.EventsAssignedToMe.insert;
    Lino.cal.EventsAssignedToMe.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsAssignedToMe.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.EventsAssignedToMe.detailPanel(p);
});
Lino.cal.EventsAssignedToMe.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Events.ParamsPanel({});
  return new Lino.cal.EventsAssignedToMe.GridPanel(p);
});

// js_render_GridPanel_class cal.MyEventsToday
Lino.cal.MyEventsToday.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/MyEventsToday",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Clear cache", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "Create email", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET'), "iconCls": "x-tbar-email_add", "overflowText": "Create email", "auto_save": true } ],
  title : "My events today",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "start_time" }, { "name": "summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "user" }, 'userHidden', { "name": "created" }, { "name": "modified" }, { "name": "project" }, 'projectHidden', { "name": "build_time" }, { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "description" }, { "name": "uid" }, { "name": "calendar" }, 'calendarHidden', { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "room" }, 'roomHidden', { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 39,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 37,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEventsToday.detail;
    this.ls_insert_handler = Lino.cal.MyEventsToday.insert;
    var ww = this.containing_window;
    var start_time2144 = new Lino.TimeField({ "selectOnFocus": true });
    var summary2145 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp2146 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id2147 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2148 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id2149 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/owner_id", "method": "GET" }) }) });
    var user2150 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var created2151 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2152 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var project2153 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Course..." });
    var build_time2154 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var start_date2155 = new Lino.DateField({ "selectOnFocus": true });
    var end_date2156 = new Lino.DateField({ "selectOnFocus": true });
    var end_time2157 = new Lino.TimeField({ "selectOnFocus": true });
    var description2158 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Description" });
    var uid2159 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var calendar2160 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    var access_class2161 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var sequence2162 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type2163 = new Ext.form.NumberField({ "disabled": true });
    var transparent2164 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var room2165 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/room", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Room..." });
    var priority2166 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Priority..." });
    var state2167 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var assigned_to2168 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var owner_disp2169 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id2149.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description2158.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2148.on('change',Lino.chooser_handler(owner_id2149,'owner_type'));
      Lino.cal.MyEventsToday.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Start time", "editable": true, "tooltip": "(cal.MyEventsToday.start_time) ", "width": Lino.chars2width(9), "dataIndex": "start_time", "editor": start_time2144 }, { "colIndex": 1, "sortable": true, "header": "Summary", "editable": true, "tooltip": "(cal.MyEventsToday.summary) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary2145 }, { "width": Lino.chars2width(31), "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "header": "Workflow", "editable": false, "tooltip": "(cal.MyEventsToday.workflow_buttons) " }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.MyEventsToday.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2147, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.MyEventsToday.owner_type) ", "filter": { "type": "string" }, "header": "Controlled by (type)", "renderer": Lino.fk_renderer('owner_typeHidden','Lino.system.ContentTypes.detail'), "hidden": true, "editor": owner_type2148, "dataIndex": "owner_type" }, { "colIndex": 5, "sortable": true, "header": "Controlled by (object)", "editable": true, "tooltip": "(cal.MyEventsToday.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "hidden": true, "editor": owner_id2149 }, { "colIndex": 6, "sortable": true, "header": "Responsible user", "editable": true, "tooltip": "(cal.MyEventsToday.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2150, "dataIndex": "user" }, { "colIndex": 7, "sortable": true, "header": "Created", "editable": false, "tooltip": "(cal.MyEventsToday.created) ", "width": Lino.chars2width(17), "dataIndex": "created", "hidden": true }, { "colIndex": 8, "sortable": true, "header": "Modified", "editable": false, "tooltip": "(cal.MyEventsToday.modified) ", "width": Lino.chars2width(17), "dataIndex": "modified", "hidden": true }, { "colIndex": 9, "sortable": true, "header": "Course", "editable": true, "tooltip": "(cal.MyEventsToday.project) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.courses.Courses.detail'), "editor": project2153, "dataIndex": "project" }, { "colIndex": 10, "sortable": true, "header": "build time", "editable": false, "tooltip": "(cal.MyEventsToday.build_time) ", "width": Lino.chars2width(17), "dataIndex": "build_time", "hidden": true }, { "colIndex": 11, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.MyEventsToday.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Start date", "dataIndex": "start_date", "width": Lino.chars2width(9), "editor": start_date2155 }, { "colIndex": 12, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.MyEventsToday.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "End Date", "dataIndex": "end_date", "hidden": true, "width": Lino.chars2width(9), "editor": end_date2156 }, { "colIndex": 13, "sortable": true, "header": "End Time", "editable": true, "tooltip": "(cal.MyEventsToday.end_time) ", "width": Lino.chars2width(9), "dataIndex": "end_time", "hidden": true, "editor": end_time2157 }, { "colIndex": 14, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(cal.MyEventsToday.description) ", "filter": { "type": "string" }, "header": "description", "renderer": Lino.text_renderer, "hidden": true, "editor": description2158, "dataIndex": "description" }, { "colIndex": 15, "sortable": true, "header": "UID", "editable": true, "tooltip": "(cal.MyEventsToday.uid) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "uid", "hidden": true, "editor": uid2159 }, { "colIndex": 16, "sortable": true, "header": "Calendar", "editable": true, "tooltip": "(cal.MyEventsToday.calendar) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.Calendars.detail'), "editor": calendar2160, "dataIndex": "calendar" }, { "colIndex": 17, "sortable": true, "header": "Access Class", "editable": true, "tooltip": "(cal.MyEventsToday.access_class) Whether this is private, public or between.", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "access_class", "hidden": true, "editor": access_class2161 }, new Lino.NullNumberColumn({ "colIndex": 18, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.MyEventsToday.sequence) ", "filter": { "type": "numeric" }, "header": "Revision", "dataIndex": "sequence", "hidden": true, "width": Lino.chars2width(6), "editor": sequence2162 }), new Lino.NullNumberColumn({ "colIndex": 19, "sortable": true, "format": "0", "editable": false, "tooltip": "(cal.MyEventsToday.auto_type) ", "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "Transparent", "editable": true, "tooltip": "(cal.MyEventsToday.transparent) Indicates that this Event shouldn't prevent other Events at the same time.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "transparent", "hidden": true }, { "colIndex": 21, "sortable": true, "header": "Room", "editable": true, "tooltip": "(cal.MyEventsToday.room) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('roomHidden','Lino.cal.Rooms.detail'), "editor": room2165, "dataIndex": "room" }, { "colIndex": 22, "sortable": true, "header": "Priority", "editable": true, "tooltip": "(cal.MyEventsToday.priority) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "priority", "hidden": true, "editor": priority2166 }, { "colIndex": 23, "sortable": true, "header": "State", "editable": true, "tooltip": "(cal.MyEventsToday.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(15), "dataIndex": "state", "editor": state2167 }, { "colIndex": 24, "sortable": true, "header": "Assigned to", "editable": true, "tooltip": "(cal.MyEventsToday.assigned_to) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('assigned_toHidden','Lino.users.Users.detail'), "editor": assigned_to2168, "dataIndex": "assigned_to" }, { "colIndex": 25, "sortable": false, "header": "Controlled by", "editable": false, "tooltip": "(cal.MyEventsToday.owner) ", "width": Lino.chars2width(11), "dataIndex": "owner", "hidden": true } ];
    Lino.cal.MyEventsToday.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyEventsToday.insertPanel = Ext.extend(Lino.cal.Events.InsertFormPanel,{
  empty_title: "New My events today",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/cal/MyEventsToday",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEventsToday.detail;
    this.ls_insert_handler = Lino.cal.MyEventsToday.insert;
    Lino.cal.MyEventsToday.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEventsToday.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyEventsToday.insertPanel(p);
});

Lino.cal.MyEventsToday.detailPanel = Ext.extend(Lino.cal.Events.DetailFormPanel,{
  empty_title: "Detail My events today",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Clear cache", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "Create email", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET'), "iconCls": "x-tbar-email_add", "overflowText": "Create email", "auto_save": true } ],
  ls_url: "/cal/MyEventsToday",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEventsToday.detail;
    this.ls_insert_handler = Lino.cal.MyEventsToday.insert;
    Lino.cal.MyEventsToday.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEventsToday.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyEventsToday.detailPanel(p);
});
Lino.cal.MyEventsToday.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Events.ParamsPanel({});
  return new Lino.cal.MyEventsToday.GridPanel(p);
});

// js_render_GridPanel_class cal.Tasks
Lino.cal.Tasks.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/Tasks",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Tasks",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "user" }, 'userHidden', { "name": "created" }, { "name": "modified" }, { "name": "project" }, 'projectHidden', { "name": "start_time" }, { "name": "description" }, { "name": "uid" }, { "name": "calendar" }, 'calendarHidden', { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "date", "name": "due_date", "dateFormat": "d.m.Y" }, { "name": "due_time" }, { "type": "int", "name": "percent" }, { "name": "state" }, 'stateHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 33,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 30,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Tasks.detail;
    this.ls_insert_handler = Lino.cal.Tasks.insert;
    var ww = this.containing_window;
    var start_date2171 = new Lino.DateField({ "selectOnFocus": true });
    var summary2172 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp2173 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id2174 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2175 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id2176 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/owner_id", "method": "GET" }) }) });
    var user2177 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var created2178 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2179 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var project2180 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Course..." });
    var start_time2181 = new Lino.TimeField({ "selectOnFocus": true });
    var description2182 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Description" });
    var uid2183 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var calendar2184 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    var access_class2185 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var sequence2186 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type2187 = new Ext.form.NumberField({ "disabled": true });
    var due_date2188 = new Lino.DateField({ "selectOnFocus": true });
    var due_time2189 = new Lino.TimeField({ "selectOnFocus": true });
    var percent2190 = new Ext.form.NumberField({ "selectOnFocus": true });
    var state2191 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.TaskStates });
    var owner_disp2192 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id2176.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description2182.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2175.on('change',Lino.chooser_handler(owner_id2176,'owner_type'));
      Lino.cal.Tasks.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.Tasks.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Start date", "dataIndex": "start_date", "width": Lino.chars2width(9), "editor": start_date2171 }, { "colIndex": 1, "sortable": true, "header": "Summary", "editable": true, "tooltip": "(cal.Tasks.summary) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary2172 }, { "width": Lino.chars2width(31), "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "header": "Workflow", "editable": false, "tooltip": "(cal.Tasks.workflow_buttons) " }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Tasks.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2174, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Controlled by (type)", "editable": true, "tooltip": "(cal.Tasks.owner_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.system.ContentTypes.detail'), "editor": owner_type2175, "dataIndex": "owner_type" }, { "colIndex": 5, "sortable": true, "header": "Controlled by (object)", "editable": true, "tooltip": "(cal.Tasks.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id2176 }, { "colIndex": 6, "sortable": true, "header": "Author", "editable": true, "tooltip": "(cal.Tasks.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2177, "dataIndex": "user" }, { "width": Lino.chars2width(17), "colIndex": 7, "sortable": true, "dataIndex": "created", "header": "Created", "editable": false, "tooltip": "(cal.Tasks.created) " }, { "width": Lino.chars2width(17), "colIndex": 8, "sortable": true, "dataIndex": "modified", "header": "Modified", "editable": false, "tooltip": "(cal.Tasks.modified) " }, { "colIndex": 9, "sortable": true, "header": "Course", "editable": true, "tooltip": "(cal.Tasks.project) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.courses.Courses.detail'), "editor": project2180, "dataIndex": "project" }, { "colIndex": 10, "sortable": true, "header": "Start time", "editable": true, "tooltip": "(cal.Tasks.start_time) ", "width": Lino.chars2width(9), "dataIndex": "start_time", "editor": start_time2181 }, { "colIndex": 11, "sortable": false, "header": "description", "editable": true, "tooltip": "(cal.Tasks.description) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": description2182, "dataIndex": "description" }, { "colIndex": 12, "sortable": true, "header": "UID", "editable": true, "tooltip": "(cal.Tasks.uid) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "uid", "editor": uid2183 }, { "colIndex": 13, "sortable": true, "header": "Calendar", "editable": true, "tooltip": "(cal.Tasks.calendar) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.Calendars.detail'), "editor": calendar2184, "dataIndex": "calendar" }, { "colIndex": 14, "sortable": true, "header": "Access Class", "editable": true, "tooltip": "(cal.Tasks.access_class) Whether this is private, public or between.", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "access_class", "editor": access_class2185 }, new Lino.NullNumberColumn({ "colIndex": 15, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Tasks.sequence) ", "filter": { "type": "numeric" }, "header": "Revision", "dataIndex": "sequence", "width": Lino.chars2width(6), "editor": sequence2186 }), new Lino.NullNumberColumn({ "colIndex": 16, "sortable": true, "format": "0", "editable": false, "tooltip": "(cal.Tasks.auto_type) ", "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "width": Lino.chars2width(6) }), { "colIndex": 17, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.Tasks.due_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Due date", "dataIndex": "due_date", "width": Lino.chars2width(9), "editor": due_date2188 }, { "colIndex": 18, "sortable": true, "header": "Due time", "editable": true, "tooltip": "(cal.Tasks.due_time) ", "width": Lino.chars2width(9), "dataIndex": "due_time", "editor": due_time2189 }, new Lino.NullNumberColumn({ "colIndex": 19, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Tasks.percent) ", "filter": { "type": "numeric" }, "header": "Duration value", "dataIndex": "percent", "width": Lino.chars2width(6), "editor": percent2190 }), { "colIndex": 20, "sortable": true, "header": "State", "editable": true, "tooltip": "(cal.Tasks.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "state", "editor": state2191 }, { "width": Lino.chars2width(11), "colIndex": 21, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "editable": false, "tooltip": "(cal.Tasks.owner) " } ];
    Lino.cal.Tasks.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.insertPanel = Ext.extend(Lino.cal.Tasks.InsertFormPanel,{
  empty_title: "New Tasks",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/cal/Tasks",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Tasks.detail;
    this.ls_insert_handler = Lino.cal.Tasks.insert;
    Lino.cal.Tasks.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Tasks.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Tasks.insertPanel(p);
});

Lino.cal.Tasks.detailPanel = Ext.extend(Lino.cal.Tasks.DetailFormPanel,{
  empty_title: "Detail Tasks",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/cal/Tasks",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Tasks.detail;
    this.ls_insert_handler = Lino.cal.Tasks.insert;
    Lino.cal.Tasks.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Tasks.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Tasks.detailPanel(p);
});
Lino.cal.Tasks.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Tasks.GridPanel(p);
});

// js_render_GridPanel_class cal.GuestRoles
Lino.cal.GuestRoles.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/GuestRoles",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Guest Roles",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "build_method" }, 'build_methodHidden', { "name": "template" }, { "type": "boolean", "name": "attach_to_email" }, { "name": "email_template" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 37,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 10,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.GuestRoles.detail;
    this.ls_insert_handler = Lino.cal.GuestRoles.insert;
    var ww = this.containing_window;
    var id2194 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2195 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de2196 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr2197 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var build_method2198 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template2199 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestRoles/template", "method": "GET" }) }) });
    var attach_to_email2200 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var email_template2201 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestRoles/email_template", "method": "GET" }) }) });
    this.before_row_edit = function(record) {
      template2199.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      build_method2198.on('change',Lino.chooser_handler(template2199,'build_method'));
      Lino.cal.GuestRoles.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.GuestRoles.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2194, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(cal.GuestRoles.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2195 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(cal.GuestRoles.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de2196 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(cal.GuestRoles.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2197 }, { "colIndex": 4, "sortable": true, "header": "Build method", "editable": true, "tooltip": "(cal.GuestRoles.build_method) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "build_method", "editor": build_method2198 }, { "colIndex": 5, "sortable": true, "header": "Template", "editable": true, "tooltip": "(cal.GuestRoles.template) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "template", "editor": template2199 }, { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "Attach to email", "editable": true, "tooltip": "(cal.GuestRoles.attach_to_email) Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "attach_to_email" }, { "colIndex": 7, "sortable": true, "header": "Email template", "editable": true, "tooltip": "(cal.GuestRoles.email_template) The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "email_template", "editor": email_template2201 } ];
    Lino.cal.GuestRoles.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.GuestRoles.insertPanel = Ext.extend(Lino.cal.GuestRoles.DetailFormPanel,{
  empty_title: "New Guest Roles",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/cal/GuestRoles",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.GuestRoles.detail;
    this.ls_insert_handler = Lino.cal.GuestRoles.insert;
    Lino.cal.GuestRoles.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.GuestRoles.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.GuestRoles.insertPanel(p);
});

Lino.cal.GuestRoles.detailPanel = Ext.extend(Lino.cal.GuestRoles.DetailFormPanel,{
  empty_title: "Detail Guest Roles",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/cal/GuestRoles",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.GuestRoles.detail;
    this.ls_insert_handler = Lino.cal.GuestRoles.insert;
    Lino.cal.GuestRoles.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.GuestRoles.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.GuestRoles.detailPanel(p);
});
Lino.cal.GuestRoles.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.GuestRoles.GridPanel(p);
});

// js_render_GridPanel_class cal.Guests
Lino.cal.Guests.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/Guests",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Clear cache", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "Create email", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET'), "iconCls": "x-tbar-email_add", "overflowText": "Create email", "auto_save": true } ],
  title : "Guests",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "partner" }, 'partnerHidden', { "name": "role" }, 'roleHidden', { "name": "workflow_buttons" }, { "name": "remark" }, { "name": "event" }, 'eventHidden', { "type": "int", "name": "id" }, { "name": "build_time" }, { "name": "state" }, 'stateHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 8,
  ls_grid_configs : [  ],
  content_type : 36,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 13,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Guests.detail;
    this.ls_insert_handler = Lino.cal.Guests.insert;
    var ww = this.containing_window;
    var partner2203 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Partner..." });
    var role2204 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Guest Role..." });
    var workflow_buttons_disp2205 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var remark2206 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var event2207 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/event", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Event..." });
    var id2208 = new Ext.form.NumberField({ "selectOnFocus": true });
    var build_time2209 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var state2210 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.GuestStates });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(cal.Guests.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2203, "dataIndex": "partner" }, { "colIndex": 1, "sortable": true, "header": "Role", "editable": true, "tooltip": "(cal.Guests.role) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('roleHidden','Lino.cal.GuestRoles.detail'), "editor": role2204, "dataIndex": "role" }, { "width": Lino.chars2width(31), "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "header": "Workflow", "editable": false, "tooltip": "(cal.Guests.workflow_buttons) " }, { "colIndex": 3, "sortable": true, "header": "Remark", "editable": true, "tooltip": "(cal.Guests.remark) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "remark", "editor": remark2206 }, { "colIndex": 4, "sortable": true, "header": "Event", "editable": true, "tooltip": "(cal.Guests.event) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('eventHidden','Lino.cal.Events.detail'), "editor": event2207, "dataIndex": "event" }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Guests.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2208, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(17), "colIndex": 6, "sortable": true, "dataIndex": "build_time", "header": "build time", "editable": false, "tooltip": "(cal.Guests.build_time) " }, { "colIndex": 7, "sortable": true, "header": "State", "editable": true, "tooltip": "(cal.Guests.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "state", "editor": state2210 } ];
    Lino.cal.Guests.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.insertPanel = Ext.extend(Lino.cal.Guests.InsertFormPanel,{
  empty_title: "New Guests",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/cal/Guests",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Guests.detail;
    this.ls_insert_handler = Lino.cal.Guests.insert;
    Lino.cal.Guests.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Guests.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Guests.insertPanel(p);
});

Lino.cal.Guests.detailPanel = Ext.extend(Lino.cal.Guests.DetailFormPanel,{
  empty_title: "Detail Guests",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Clear cache", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "Create email", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET'), "iconCls": "x-tbar-email_add", "overflowText": "Create email", "auto_save": true } ],
  ls_url: "/cal/Guests",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Guests.detail;
    this.ls_insert_handler = Lino.cal.Guests.insert;
    Lino.cal.Guests.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Guests.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Guests.detailPanel(p);
});
Lino.cal.Guests.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Guests.ParamsPanel({});
  return new Lino.cal.Guests.GridPanel(p);
});

// js_render_GridPanel_class cal.PanelCalendars
Lino.cal.PanelCalendars.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/PanelCalendars",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Calendars",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "babel_name" }, { "name": "description" }, { "type": "int", "name": "color" }, { "type": "boolean", "name": "is_hidden" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 38,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelCalendars.detail;
    this.ls_insert_handler = Lino.cal.PanelCalendars.insert;
    var ww = this.containing_window;
    var id2212 = new Ext.form.NumberField({ "selectOnFocus": true });
    var babel_name_disp2213 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var description2214 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Description" });
    var color2215 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 1 });
    var is_hidden_disp2216 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
      description2214.refresh();
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.PanelCalendars.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2212, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(31), "colIndex": 1, "sortable": false, "dataIndex": "babel_name", "header": "babel_name", "editable": false, "tooltip": "(cal.PanelCalendars.babel_name) " }, { "colIndex": 2, "sortable": false, "header": "description", "editable": true, "tooltip": "(cal.PanelCalendars.description) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": description2214, "dataIndex": "description" }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.PanelCalendars.color) ", "filter": { "type": "numeric" }, "header": "color", "dataIndex": "color", "width": Lino.chars2width(6), "editor": color2215 }), { "width": Lino.chars2width(31), "colIndex": 4, "sortable": false, "dataIndex": "is_hidden", "header": "Hidden", "editable": false, "tooltip": "(cal.PanelCalendars.is_hidden) " } ];
    Lino.cal.PanelCalendars.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.PanelCalendars.insertPanel = Ext.extend(Lino.cal.Calendars.InsertFormPanel,{
  empty_title: "New Calendars",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/cal/PanelCalendars",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelCalendars.detail;
    this.ls_insert_handler = Lino.cal.PanelCalendars.insert;
    Lino.cal.PanelCalendars.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.PanelCalendars.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.PanelCalendars.insertPanel(p);
});

Lino.cal.PanelCalendars.detailPanel = Ext.extend(Lino.cal.Calendars.DetailFormPanel,{
  empty_title: "Detail Calendars",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/cal/PanelCalendars",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelCalendars.detail;
    this.ls_insert_handler = Lino.cal.PanelCalendars.insert;
    Lino.cal.PanelCalendars.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.PanelCalendars.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.PanelCalendars.detailPanel(p);
});
Lino.cal.PanelCalendars.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.PanelCalendars.GridPanel(p);
});

// js_render_GridPanel_class cal.PanelEvents
Lino.cal.PanelEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/PanelEvents",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Clear cache", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "Create email", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET'), "iconCls": "x-tbar-email_add", "overflowText": "Create email", "auto_save": true } ],
  title : "Events",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "start_dt" }, { "name": "end_dt" }, { "name": "summary" }, { "name": "description" }, { "name": "user" }, 'userHidden', { "name": "room" }, 'roomHidden', { "name": "calendar" }, 'calendarHidden', { "name": "url" }, { "type": "boolean", "name": "all_day" }, { "name": "reminder" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 39,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelEvents.detail;
    this.ls_insert_handler = Lino.cal.PanelEvents.insert;
    var ww = this.containing_window;
    var id2218 = new Ext.form.NumberField({ "selectOnFocus": true });
    var start_dt2219 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var end_dt2220 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var summary2221 = new Ext.form.TextField({ "disabled": true, "maxLength": null });
    var description2222 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Description" });
    var user2223 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/PanelEvents/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var room2224 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/PanelEvents/room", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Room..." });
    var calendar2225 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/PanelEvents/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    var url_disp2226 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var all_day2227 = new Ext.form.Checkbox({ "disabled": true });
    var reminder_disp2228 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
      description2222.refresh();
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.PanelEvents.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2218, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(17), "colIndex": 1, "sortable": false, "dataIndex": "start_dt", "header": "Start", "editable": false, "tooltip": "(cal.PanelEvents.start_dt) " }, { "width": Lino.chars2width(17), "colIndex": 2, "sortable": false, "dataIndex": "end_dt", "header": "End", "editable": false, "tooltip": "(cal.PanelEvents.end_dt) " }, { "width": Lino.chars2width(5), "colIndex": 3, "sortable": false, "dataIndex": "summary", "header": "Summary", "editable": false, "tooltip": "(cal.PanelEvents.summary) " }, { "colIndex": 4, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(cal.PanelEvents.description) ", "filter": { "type": "string" }, "header": "description", "renderer": Lino.text_renderer, "hidden": true, "editor": description2222, "dataIndex": "description" }, { "colIndex": 5, "sortable": true, "header": "Responsible user", "editable": true, "tooltip": "(cal.PanelEvents.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2223, "dataIndex": "user" }, { "colIndex": 6, "sortable": true, "header": "Room", "editable": true, "tooltip": "(cal.PanelEvents.room) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('roomHidden','Lino.cal.Rooms.detail'), "editor": room2224, "dataIndex": "room" }, { "colIndex": 7, "sortable": true, "header": "Calendar", "editable": true, "tooltip": "(cal.PanelEvents.calendar) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.Calendars.detail'), "editor": calendar2225, "dataIndex": "calendar" }, { "width": Lino.chars2width(31), "colIndex": 8, "sortable": false, "dataIndex": "url", "header": "Link URL", "editable": false, "tooltip": "(cal.PanelEvents.url) " }, { "colIndex": 9, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": false, "tooltip": "(cal.PanelEvents.all_day) ", "header": "all day", "dataIndex": "all_day" }, { "width": Lino.chars2width(31), "colIndex": 10, "sortable": false, "dataIndex": "reminder", "header": "Reminder", "editable": false, "tooltip": "(cal.PanelEvents.reminder) " } ];
    Lino.cal.PanelEvents.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.PanelEvents.insertPanel = Ext.extend(Lino.cal.Events.InsertFormPanel,{
  empty_title: "New Events",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/cal/PanelEvents",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelEvents.detail;
    this.ls_insert_handler = Lino.cal.PanelEvents.insert;
    Lino.cal.PanelEvents.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.PanelEvents.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.PanelEvents.insertPanel(p);
});

Lino.cal.PanelEvents.detailPanel = Ext.extend(Lino.cal.Events.DetailFormPanel,{
  empty_title: "Detail Events",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Clear cache", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "Create email", "must_save": true, "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET'), "iconCls": "x-tbar-email_add", "overflowText": "Create email", "auto_save": true } ],
  ls_url: "/cal/PanelEvents",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelEvents.detail;
    this.ls_insert_handler = Lino.cal.PanelEvents.insert;
    Lino.cal.PanelEvents.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.PanelEvents.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.PanelEvents.detailPanel(p);
});
Lino.cal.PanelEvents.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Events.ParamsPanel({});
  return new Lino.cal.PanelEvents.GridPanel(p);
});

// js_render_GridPanel_class uploads.UploadTypes
Lino.uploads.UploadTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/uploads/UploadTypes",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Upload Types",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 1,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 3,
  initComponent : function() {
    var ww = this.containing_window;
    var name2230 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var id2231 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "tooltip": "(uploads.UploadTypes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2230 }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "format": "0", "editable": true, "tooltip": "(uploads.UploadTypes.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2231, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.uploads.UploadTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.UploadTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.UploadTypes.GridPanel(p);
});

// js_render_GridPanel_class uploads.Uploads
Lino.uploads.Uploads.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/uploads/Uploads",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Uploads",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "file" }, { "name": "user" }, 'userHidden', { "name": "created" }, { "name": "modified" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "mimetype" }, { "name": "type" }, 'typeHidden', { "type": "date", "name": "valid_until", "dateFormat": "d.m.Y" }, { "name": "description" }, { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 32,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 17,
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.Uploads.detail;
    this.ls_insert_handler = Lino.uploads.Uploads.insert;
    var ww = this.containing_window;
    var file2233 = Lino.file_field_handler(this,{ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var user2234 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var created2235 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2236 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var id2237 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2238 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id2239 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/owner_id", "method": "GET" }) }) });
    var mimetype2240 = new Ext.form.TextField({ "disabled": true, "maxLength": 64 });
    var type2241 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Upload Type..." });
    var valid_until2242 = new Lino.DateField({ "selectOnFocus": true });
    var description2243 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var owner_disp2244 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id2239.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type2238.on('change',Lino.chooser_handler(owner_id2239,'owner_type'));
      Lino.uploads.Uploads.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "File", "editable": true, "tooltip": "(uploads.Uploads.file) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "file", "editor": file2233 }, { "colIndex": 1, "sortable": true, "header": "Author", "editable": true, "tooltip": "(uploads.Uploads.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2234, "dataIndex": "user" }, { "width": Lino.chars2width(17), "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "Created", "editable": false, "tooltip": "(uploads.Uploads.created) " }, { "width": Lino.chars2width(17), "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "Modified", "editable": false, "tooltip": "(uploads.Uploads.modified) " }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(uploads.Uploads.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2237, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Controlled by (type)", "editable": true, "tooltip": "(uploads.Uploads.owner_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.system.ContentTypes.detail'), "editor": owner_type2238, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Controlled by (object)", "editable": true, "tooltip": "(uploads.Uploads.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id2239 }, { "colIndex": 7, "sortable": true, "header": "MIME type", "editable": false, "tooltip": "(uploads.Uploads.mimetype) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "mimetype" }, { "colIndex": 8, "sortable": true, "header": "Upload Type", "editable": true, "tooltip": "(uploads.Uploads.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type2241 }, { "colIndex": 9, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(uploads.Uploads.valid_until) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "valid until", "dataIndex": "valid_until", "width": Lino.chars2width(9), "editor": valid_until2242 }, { "colIndex": 10, "sortable": true, "header": "Description", "editable": true, "tooltip": "(uploads.Uploads.description) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "description", "editor": description2243 }, { "width": Lino.chars2width(11), "colIndex": 11, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "editable": false, "tooltip": "(uploads.Uploads.owner) " } ];
    Lino.uploads.Uploads.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.Uploads.insertPanel = Ext.extend(Lino.uploads.Uploads.InsertFormPanel,{
  empty_title: "New Uploads",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/uploads/Uploads",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.Uploads.detail;
    this.ls_insert_handler = Lino.uploads.Uploads.insert;
    Lino.uploads.Uploads.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.Uploads.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.uploads.Uploads.insertPanel(p);
});

Lino.uploads.Uploads.detailPanel = Ext.extend(Lino.uploads.Uploads.DetailFormPanel,{
  empty_title: "Detail Uploads",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/uploads/Uploads",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.Uploads.detail;
    this.ls_insert_handler = Lino.uploads.Uploads.insert;
    Lino.uploads.Uploads.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.Uploads.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.Uploads.detailPanel(p);
});
Lino.uploads.Uploads.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.Uploads.GridPanel(p);
});

// js_render_GridPanel_class pages.Pages
Lino.pages.Pages.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/pages/Pages",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET'), "iconCls": "x-tbar-moveup", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET'), "iconCls": "x-tbar-movedown", "overflowText": "Down", "auto_save": true } ],
  title : "Nodes",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "ref" }, { "name": "title" }, { "name": "title_de" }, { "name": "title_fr" }, { "type": "int", "name": "id" }, { "type": "int", "name": "seqno" }, { "name": "parent" }, 'parentHidden', { "name": "body" }, { "type": "boolean", "name": "raw_html" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 44,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    this.ls_detail_handler = Lino.pages.Pages.detail;
    this.ls_insert_handler = Lino.pages.Pages.insert;
    var ww = this.containing_window;
    var ref2246 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var title2247 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var title_de2248 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var title_fr2249 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id2250 = new Ext.form.NumberField({ "selectOnFocus": true });
    var seqno2251 = new Ext.form.NumberField({ "selectOnFocus": true });
    var parent2252 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pages/Pages/parent", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Node..." });
    var body2253 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var raw_html2254 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Reference", "editable": true, "tooltip": "(pages.Pages.ref) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ref", "editor": ref2246 }, { "colIndex": 1, "sortable": true, "header": "Title", "editable": true, "tooltip": "(pages.Pages.title) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "title", "editor": title2247 }, { "colIndex": 2, "sortable": true, "header": "Title (de)", "editable": true, "tooltip": "(pages.Pages.title_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "title_de", "editor": title_de2248 }, { "colIndex": 3, "sortable": true, "header": "Title (fr)", "editable": true, "tooltip": "(pages.Pages.title_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "title_fr", "editor": title_fr2249 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(pages.Pages.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2250, "width": Lino.chars2width(6), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(pages.Pages.seqno) ", "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "width": Lino.chars2width(6), "editor": seqno2251 }), { "colIndex": 6, "sortable": true, "header": "Parent", "editable": true, "tooltip": "(pages.Pages.parent) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('parentHidden','Lino.pages.Pages.detail'), "editor": parent2252, "dataIndex": "parent" }, { "colIndex": 7, "sortable": false, "header": "Body", "editable": true, "tooltip": "(pages.Pages.body) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": body2253, "dataIndex": "body" }, { "colIndex": 8, "sortable": false, "xtype": "checkcolumn", "header": "raw html", "editable": true, "tooltip": "(pages.Pages.raw_html) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "raw_html" } ];
    Lino.pages.Pages.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.pages.Pages.insertPanel = Ext.extend(Lino.pages.Pages.DetailFormPanel,{
  empty_title: "New Nodes",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/pages/Pages",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.pages.Pages.detail;
    this.ls_insert_handler = Lino.pages.Pages.insert;
    Lino.pages.Pages.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.pages.Pages.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pages.Pages.insertPanel(p);
});

Lino.pages.Pages.detailPanel = Ext.extend(Lino.pages.Pages.DetailFormPanel,{
  empty_title: "Detail Nodes",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET'), "iconCls": "x-tbar-moveup", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET'), "iconCls": "x-tbar-movedown", "overflowText": "Down", "auto_save": true } ],
  ls_url: "/pages/Pages",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.pages.Pages.detail;
    this.ls_insert_handler = Lino.pages.Pages.insert;
    Lino.pages.Pages.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.pages.Pages.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pages.Pages.detailPanel(p);
});
Lino.pages.Pages.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pages.Pages.GridPanel(p);
});
Lino.pages.Pages.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/pages/Pages",pk,"move_up");
};
Lino.pages.Pages.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/pages/Pages",pk,"move_down");
};

// js_render_GridPanel_class accounts.Charts
Lino.accounts.Charts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/accounts/Charts",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Account Charts",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 47,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Charts.detail;
    this.ls_insert_handler = Lino.accounts.Charts.insert;
    var ww = this.containing_window;
    var id2256 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2257 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de2258 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr2259 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(accounts.Charts.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2256, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(accounts.Charts.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2257 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(accounts.Charts.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de2258 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(accounts.Charts.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2259 } ];
    Lino.accounts.Charts.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Charts.insertPanel = Ext.extend(Lino.accounts.Charts.DetailFormPanel,{
  empty_title: "New Account Charts",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/accounts/Charts",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Charts.detail;
    this.ls_insert_handler = Lino.accounts.Charts.insert;
    Lino.accounts.Charts.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Charts.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.accounts.Charts.insertPanel(p);
});

Lino.accounts.Charts.detailPanel = Ext.extend(Lino.accounts.Charts.DetailFormPanel,{
  empty_title: "Detail Account Charts",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/accounts/Charts",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Charts.detail;
    this.ls_insert_handler = Lino.accounts.Charts.insert;
    Lino.accounts.Charts.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Charts.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Charts.detailPanel(p);
});
Lino.accounts.Charts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Charts.GridPanel(p);
});

// js_render_GridPanel_class accounts.Groups
Lino.accounts.Groups.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/accounts/Groups",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Account Groups",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "chart" }, 'chartHidden', { "name": "ref" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "account_type" }, 'account_typeHidden', { "type": "int", "name": "id" }, { "name": "help_text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 8,
  ls_grid_configs : [  ],
  content_type : 46,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Groups.detail;
    this.ls_insert_handler = Lino.accounts.Groups.insert;
    var ww = this.containing_window;
    var chart2261 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Groups/chart", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account Chart..." });
    var ref2262 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var name2263 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de2264 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr2265 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var account_type2266 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.accounts.AccountTypes) });
    var id2267 = new Ext.form.NumberField({ "selectOnFocus": true });
    var help_text2268 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Introduction" });
    this.before_row_edit = function(record) {
      help_text2268.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Account Chart", "editable": true, "tooltip": "(accounts.Groups.chart) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('chartHidden','Lino.accounts.Charts.detail'), "editor": chart2261, "dataIndex": "chart" }, { "colIndex": 1, "sortable": true, "header": "ref", "editable": true, "tooltip": "(accounts.Groups.ref) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ref", "editor": ref2262 }, { "colIndex": 2, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(accounts.Groups.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2263 }, { "colIndex": 3, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(accounts.Groups.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de2264 }, { "colIndex": 4, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(accounts.Groups.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2265 }, { "colIndex": 5, "sortable": true, "header": "Account Type", "editable": true, "tooltip": "(accounts.Groups.account_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(17), "dataIndex": "account_type", "editor": account_type2266 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(accounts.Groups.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2267, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 7, "sortable": false, "header": "help_text", "editable": true, "tooltip": "(accounts.Groups.help_text) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": help_text2268, "dataIndex": "help_text" } ];
    Lino.accounts.Groups.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Groups.insertPanel = Ext.extend(Lino.accounts.Groups.DetailFormPanel,{
  empty_title: "New Account Groups",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/accounts/Groups",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Groups.detail;
    this.ls_insert_handler = Lino.accounts.Groups.insert;
    Lino.accounts.Groups.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Groups.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.accounts.Groups.insertPanel(p);
});

Lino.accounts.Groups.detailPanel = Ext.extend(Lino.accounts.Groups.DetailFormPanel,{
  empty_title: "Detail Account Groups",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/accounts/Groups",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Groups.detail;
    this.ls_insert_handler = Lino.accounts.Groups.insert;
    Lino.accounts.Groups.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Groups.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Groups.detailPanel(p);
});
Lino.accounts.Groups.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Groups.GridPanel(p);
});

// js_render_GridPanel_class accounts.Accounts
Lino.accounts.Accounts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/accounts/Accounts",
  ls_bbar_actions : [ { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET'), "iconCls": "x-tbar-moveup", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET'), "iconCls": "x-tbar-movedown", "overflowText": "Down", "auto_save": true } ],
  title : "Accounts",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "ref" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "group" }, 'groupHidden', { "type": "int", "name": "id" }, { "type": "int", "name": "seqno" }, { "name": "chart" }, 'chartHidden', { "name": "type" }, 'typeHidden', { "name": "help_text" }, { "type": "boolean", "name": "sales_allowed" }, { "type": "boolean", "name": "purchases_allowed" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 45,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 16,
  initComponent : function() {
    var ww = this.containing_window;
    var ref2270 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var name2271 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de2272 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr2273 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var group2274 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Accounts/group", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account Group..." });
    var id2275 = new Ext.form.NumberField({ "selectOnFocus": true });
    var seqno2276 = new Ext.form.NumberField({ "selectOnFocus": true });
    var chart2277 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Accounts/chart", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account Chart..." });
    var type2278 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.accounts.AccountTypes });
    var help_text2279 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Introduction" });
    var sales_allowed2280 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var purchases_allowed2281 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
      help_text2279.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ref", "editable": true, "tooltip": "(accounts.Accounts.ref) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ref", "editor": ref2270 }, { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(accounts.Accounts.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2271 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(accounts.Accounts.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de2272 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(accounts.Accounts.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2273 }, { "colIndex": 4, "sortable": true, "header": "Account Group", "editable": true, "tooltip": "(accounts.Accounts.group) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('groupHidden','Lino.accounts.Groups.detail'), "editor": group2274, "dataIndex": "group" }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(accounts.Accounts.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2275, "width": Lino.chars2width(6), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(accounts.Accounts.seqno) ", "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "width": Lino.chars2width(6), "editor": seqno2276 }), { "colIndex": 7, "sortable": true, "header": "Account Chart", "editable": true, "tooltip": "(accounts.Accounts.chart) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('chartHidden','Lino.accounts.Charts.detail'), "editor": chart2277, "dataIndex": "chart" }, { "colIndex": 8, "sortable": true, "header": "Account Type", "editable": true, "tooltip": "(accounts.Accounts.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(17), "dataIndex": "type", "editor": type2278 }, { "colIndex": 9, "sortable": false, "header": "help_text", "editable": true, "tooltip": "(accounts.Accounts.help_text) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": help_text2279, "dataIndex": "help_text" }, { "colIndex": 10, "sortable": false, "xtype": "checkcolumn", "header": "Sales", "editable": true, "tooltip": "(accounts.Accounts.sales_allowed) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "sales_allowed" }, { "colIndex": 11, "sortable": false, "xtype": "checkcolumn", "header": "Purchases", "editable": true, "tooltip": "(accounts.Accounts.purchases_allowed) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "purchases_allowed" } ];
    Lino.accounts.Accounts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Accounts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Accounts.GridPanel(p);
});
Lino.accounts.Accounts.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Accounts",pk,"move_up");
};
Lino.accounts.Accounts.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Accounts",pk,"move_down");
};

// js_render_GridPanel_class ledger.Journals
Lino.ledger.Journals.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/ledger/Journals",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET'), "iconCls": "x-tbar-moveup", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET'), "iconCls": "x-tbar-movedown", "overflowText": "Down", "auto_save": true } ],
  title : "Journals",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "seqno" }, { "type": "int", "name": "id" }, { "name": "trade_type" }, 'trade_typeHidden', { "name": "voucher_type" }, 'voucher_typeHidden', { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "type": "boolean", "name": "force_sequence" }, { "name": "ref" }, { "name": "chart" }, 'chartHidden', { "name": "account" }, 'accountHidden', { "name": "printed_name" }, { "name": "printed_name_de" }, { "name": "printed_name_fr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 1,
  ls_grid_configs : [  ],
  content_type : 48,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 19,
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Journals.detail;
    this.ls_insert_handler = Lino.ledger.Journals.insert;
    var ww = this.containing_window;
    var seqno2283 = new Ext.form.NumberField({ "selectOnFocus": true });
    var id2284 = new Ext.form.NumberField({ "selectOnFocus": true });
    var trade_type2285 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.vat.TradeTypes) });
    var voucher_type2286 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.ledger.VoucherTypes });
    var name2287 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de2288 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr2289 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var force_sequence2290 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var ref2291 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var chart2292 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Journals/chart", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account Chart..." });
    var account2293 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Journals/account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var printed_name2294 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var printed_name_de2295 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var printed_name_fr2296 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    this.before_row_edit = function(record) {
      account2293.setContextValue('chart',record ? record.data['chartHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      chart2292.on('change',Lino.chooser_handler(account2293,'chart'));
      Lino.ledger.Journals.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(ledger.Journals.seqno) ", "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "width": Lino.chars2width(6), "editor": seqno2283 }), new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "format": "0", "editable": true, "tooltip": "(ledger.Journals.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2284, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 2, "sortable": true, "header": "Trade Type", "editable": true, "tooltip": "(ledger.Journals.trade_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "trade_type", "editor": trade_type2285 }, { "colIndex": 3, "sortable": true, "header": "voucher type", "editable": true, "tooltip": "(ledger.Journals.voucher_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(54), "dataIndex": "voucher_type", "editor": voucher_type2286 }, { "colIndex": 4, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(ledger.Journals.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2287 }, { "colIndex": 5, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(ledger.Journals.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de2288 }, { "colIndex": 6, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(ledger.Journals.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2289 }, { "colIndex": 7, "sortable": false, "xtype": "checkcolumn", "header": "force sequence", "editable": true, "tooltip": "(ledger.Journals.force_sequence) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "force_sequence" }, { "colIndex": 8, "sortable": true, "header": "ref", "editable": true, "tooltip": "(ledger.Journals.ref) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ref", "editor": ref2291 }, { "colIndex": 9, "sortable": true, "header": "Account Chart", "editable": true, "tooltip": "(ledger.Journals.chart) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('chartHidden','Lino.accounts.Charts.detail'), "editor": chart2292, "dataIndex": "chart" }, { "colIndex": 10, "sortable": true, "header": "Account", "editable": true, "tooltip": "(ledger.Journals.account) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "account", "editor": account2293 }, { "colIndex": 11, "sortable": true, "header": "printed name", "editable": true, "tooltip": "(ledger.Journals.printed_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "printed_name", "editor": printed_name2294 }, { "colIndex": 12, "sortable": true, "header": "printed name (de)", "editable": true, "tooltip": "(ledger.Journals.printed_name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "printed_name_de", "editor": printed_name_de2295 }, { "colIndex": 13, "sortable": true, "header": "printed name (fr)", "editable": true, "tooltip": "(ledger.Journals.printed_name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "printed_name_fr", "editor": printed_name_fr2296 } ];
    Lino.ledger.Journals.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Journals.insertPanel = Ext.extend(Lino.ledger.Journals.InsertFormPanel,{
  empty_title: "New Journals",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/ledger/Journals",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Journals.detail;
    this.ls_insert_handler = Lino.ledger.Journals.insert;
    Lino.ledger.Journals.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Journals.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.ledger.Journals.insertPanel(p);
});

Lino.ledger.Journals.detailPanel = Ext.extend(Lino.ledger.Journals.DetailFormPanel,{
  empty_title: "Detail Journals",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET'), "iconCls": "x-tbar-moveup", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET'), "iconCls": "x-tbar-movedown", "overflowText": "Down", "auto_save": true } ],
  ls_url: "/ledger/Journals",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Journals.detail;
    this.ls_insert_handler = Lino.ledger.Journals.insert;
    Lino.ledger.Journals.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Journals.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.Journals.detailPanel(p);
});
Lino.ledger.Journals.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.Journals.GridPanel(p);
});
Lino.ledger.Journals.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Journals",pk,"move_up");
};
Lino.ledger.Journals.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Journals",pk,"move_down");
};

// js_render_GridPanel_class ledger.Vouchers
Lino.ledger.Vouchers.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "emptyText": "No data to display." },
  ls_url : "/ledger/Vouchers",
  ls_bbar_actions : [  ],
  title : "Vouchers",
  page_length : 20,
  stripeRows : true,
  disable_editing : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "type": "int", "name": "number" }, { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "journal" }, 'journalHidden', { "name": "year" }, 'yearHidden', { "name": "narration" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 51,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    var ww = this.containing_window;
    var date2298 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var number2299 = new Ext.form.NumberField({ "selectOnFocus": true });
    var id2300 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user2301 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Vouchers/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var journal2302 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Vouchers/journal", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Journal..." });
    var year2303 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var narration2304 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(ledger.Vouchers.date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "date", "width": Lino.chars2width(9), "editor": date2298 }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "format": "0", "editable": true, "tooltip": "(ledger.Vouchers.number) ", "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(6), "editor": number2299 }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(ledger.Vouchers.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2300, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 3, "sortable": true, "header": "Author", "editable": true, "tooltip": "(ledger.Vouchers.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2301, "dataIndex": "user" }, { "colIndex": 4, "sortable": true, "header": "Journal", "editable": true, "tooltip": "(ledger.Vouchers.journal) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('journalHidden','Lino.ledger.Journals.detail'), "editor": journal2302, "dataIndex": "journal" }, { "colIndex": 5, "sortable": true, "header": "Fiscal Year", "editable": true, "tooltip": "(ledger.Vouchers.year) ", "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "year", "editor": year2303 }, { "colIndex": 6, "sortable": true, "header": "Narration", "editable": true, "tooltip": "(ledger.Vouchers.narration) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "narration", "editor": narration2304 } ];
    Lino.ledger.Vouchers.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Vouchers.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.Vouchers.GridPanel(p);
});

// js_render_GridPanel_class ledger.Movements
Lino.ledger.Movements.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "emptyText": "No data to display." },
  ls_url : "/ledger/Movements",
  ls_bbar_actions : [ { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET'), "iconCls": "x-tbar-moveup", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET'), "iconCls": "x-tbar-movedown", "overflowText": "Down", "auto_save": true } ],
  title : "Movements",
  page_length : 20,
  stripeRows : true,
  disable_editing : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "voucher_link" }, { "name": "account" }, 'accountHidden', { "name": "debit" }, { "name": "credit" }, { "type": "int", "name": "id" }, { "type": "int", "name": "seqno" }, { "name": "voucher" }, 'voucherHidden', { "name": "partner" }, 'partnerHidden', { "name": "amount" }, { "type": "boolean", "name": "dc" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 52,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 14,
  initComponent : function() {
    var ww = this.containing_window;
    var voucher_link_disp2306 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var account2307 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Movements/account", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account..." });
    var debit2308 = new Ext.form.NumberField({ "disabled": true, "decimalPrecision": 2, "decimalSeparator": "," });
    var credit2309 = new Ext.form.NumberField({ "disabled": true, "decimalPrecision": 2, "decimalSeparator": "," });
    var id2310 = new Ext.form.NumberField({ "selectOnFocus": true });
    var seqno2311 = new Ext.form.NumberField({ "selectOnFocus": true });
    var voucher2312 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Movements/voucher", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Voucher..." });
    var partner2313 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Movements/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var amount2314 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalSeparator": ",", "decimalPrecision": 2, "allowBlank": false, "value": 0 });
    var dc2315 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(31), "colIndex": 0, "sortable": false, "dataIndex": "voucher_link", "header": "Voucher", "editable": false, "tooltip": "(ledger.Movements.voucher_link) " }, { "colIndex": 1, "sortable": true, "header": "Account", "editable": true, "tooltip": "(ledger.Movements.account) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "account", "editor": account2307 }, new Lino.NullNumberColumn({ "width": Lino.chars2width(13), "colIndex": 2, "sortable": false, "dataIndex": "debit", "header": "Debit", "editable": false, "tooltip": "(ledger.Movements.debit) " }), new Lino.NullNumberColumn({ "width": Lino.chars2width(13), "colIndex": 3, "sortable": false, "dataIndex": "credit", "header": "Credit", "editable": false, "tooltip": "(ledger.Movements.credit) " }), new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(ledger.Movements.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2310, "width": Lino.chars2width(6), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(ledger.Movements.seqno) ", "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "width": Lino.chars2width(6), "editor": seqno2311 }), { "colIndex": 6, "sortable": true, "header": "Voucher", "editable": true, "tooltip": "(ledger.Movements.voucher) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "voucher", "editor": voucher2312 }, { "colIndex": 7, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(ledger.Movements.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2313, "dataIndex": "partner" }, new Lino.NullNumberColumn({ "colIndex": 8, "sortable": true, "header": "amount", "editable": true, "tooltip": "(ledger.Movements.amount) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "amount", "editor": amount2314 }), { "colIndex": 9, "sortable": false, "xtype": "checkcolumn", "header": "dc", "editable": true, "tooltip": "(ledger.Movements.dc) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "dc" } ];
    Lino.ledger.Movements.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Movements.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.Movements.GridPanel(p);
});
Lino.ledger.Movements.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Movements",pk,"move_up");
};
Lino.ledger.Movements.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Movements",pk,"move_down");
};

// js_render_GridPanel_class ledger.Invoices
Lino.ledger.Invoices.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/ledger/Invoices",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Invoices",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "type": "int", "name": "id" }, { "type": "int", "name": "number" }, { "name": "partner" }, 'partnerHidden', { "name": "total_incl" }, { "name": "user" }, 'userHidden', { "name": "journal" }, 'journalHidden', { "name": "year" }, 'yearHidden', { "name": "narration" }, { "name": "total_base" }, { "name": "total_vat" }, { "type": "boolean", "name": "item_vat" }, { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "your_ref" }, { "type": "date", "name": "due_date", "dateFormat": "d.m.Y" }, { "name": "state" }, 'stateHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 1,
  ls_grid_configs : [  ],
  content_type : 50,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 23,
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Invoices.detail;
    this.ls_insert_handler = Lino.ledger.Invoices.insert;
    var ww = this.containing_window;
    var date2317 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var id2318 = new Ext.form.NumberField({ "selectOnFocus": true });
    var number2319 = new Ext.form.NumberField({ "selectOnFocus": true });
    var partner2320 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/partner", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Partner..." });
    var total_incl2321 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var user2322 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var journal2323 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/journal", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Journal..." });
    var year2324 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var narration2325 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var total_base2326 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat2327 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var item_vat2328 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var vat_regime2329 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var your_ref2330 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var due_date2331 = new Lino.DateField({ "selectOnFocus": true });
    var state2332 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.ledger.InvoiceStates });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(ledger.Invoices.date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "date", "width": Lino.chars2width(9), "editor": date2317 }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "format": "0", "editable": true, "tooltip": "(ledger.Invoices.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2318, "width": Lino.chars2width(6), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(ledger.Invoices.number) ", "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(6), "editor": number2319 }), { "colIndex": 3, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(ledger.Invoices.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2320, "dataIndex": "partner" }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "header": "Total incl. VAT", "editable": true, "tooltip": "(ledger.Invoices.total_incl) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_incl", "editor": total_incl2321 }), { "colIndex": 5, "sortable": true, "header": "Author", "editable": true, "tooltip": "(ledger.Invoices.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2322, "dataIndex": "user" }, { "colIndex": 6, "sortable": true, "header": "Journal", "editable": true, "tooltip": "(ledger.Invoices.journal) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('journalHidden','Lino.ledger.Journals.detail'), "editor": journal2323, "dataIndex": "journal" }, { "colIndex": 7, "sortable": true, "header": "Fiscal Year", "editable": true, "tooltip": "(ledger.Invoices.year) ", "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "year", "editor": year2324 }, { "colIndex": 8, "sortable": true, "header": "Narration", "editable": true, "tooltip": "(ledger.Invoices.narration) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "narration", "editor": narration2325 }, new Lino.NullNumberColumn({ "colIndex": 9, "sortable": true, "header": "Total excl. VAT", "editable": true, "tooltip": "(ledger.Invoices.total_base) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_base", "editor": total_base2326 }), new Lino.NullNumberColumn({ "colIndex": 10, "sortable": true, "header": "VAT", "editable": true, "tooltip": "(ledger.Invoices.total_vat) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_vat", "editor": total_vat2327 }), { "colIndex": 11, "sortable": false, "xtype": "checkcolumn", "header": "Prices include VAT", "editable": true, "tooltip": "(ledger.Invoices.item_vat) Whether prices includes VAT or not.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "item_vat" }, { "colIndex": 12, "sortable": true, "header": "VAT Regime", "editable": true, "tooltip": "(ledger.Invoices.vat_regime) ", "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "vat_regime", "editor": vat_regime2329 }, { "colIndex": 13, "sortable": true, "header": "Your reference", "editable": true, "tooltip": "(ledger.Invoices.your_ref) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "your_ref", "editor": your_ref2330 }, { "colIndex": 14, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(ledger.Invoices.due_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Due date", "dataIndex": "due_date", "width": Lino.chars2width(9), "editor": due_date2331 }, { "colIndex": 15, "sortable": true, "header": "State", "editable": true, "tooltip": "(ledger.Invoices.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(14), "dataIndex": "state", "editor": state2332 } ];
    Lino.ledger.Invoices.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Invoices.insertPanel = Ext.extend(Lino.ledger.Invoices.InsertFormPanel,{
  empty_title: "New Invoices",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/ledger/Invoices",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Invoices.detail;
    this.ls_insert_handler = Lino.ledger.Invoices.insert;
    Lino.ledger.Invoices.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Invoices.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.ledger.Invoices.insertPanel(p);
});

Lino.ledger.Invoices.detailPanel = Ext.extend(Lino.ledger.Invoices.DetailFormPanel,{
  empty_title: "Detail Invoices",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/ledger/Invoices",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Invoices.detail;
    this.ls_insert_handler = Lino.ledger.Invoices.insert;
    Lino.ledger.Invoices.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Invoices.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.Invoices.detailPanel(p);
});
Lino.ledger.Invoices.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.ledger.Invoices.ParamsPanel({});
  return new Lino.ledger.Invoices.GridPanel(p);
});
Lino.ledger.Invoices.deregister_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Invoices",pk,"deregister_action");
};
Lino.ledger.Invoices.register_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Invoices",pk,"register_action");
};

// js_render_GridPanel_class products.ProductCats
Lino.products.ProductCats.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/products/ProductCats",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Product Categories",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "description" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 53,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    this.ls_detail_handler = Lino.products.ProductCats.detail;
    this.ls_insert_handler = Lino.products.ProductCats.insert;
    var ww = this.containing_window;
    var id2334 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2335 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de2336 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr2337 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var description2338 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(products.ProductCats.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2334, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(products.ProductCats.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2335 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(products.ProductCats.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de2336 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(products.ProductCats.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2337 }, { "colIndex": 4, "sortable": false, "header": "description", "editable": true, "tooltip": "(products.ProductCats.description) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": description2338, "dataIndex": "description" } ];
    Lino.products.ProductCats.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.products.ProductCats.insertPanel = Ext.extend(Lino.products.ProductCats.DetailFormPanel,{
  empty_title: "New Product Categories",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/products/ProductCats",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.products.ProductCats.detail;
    this.ls_insert_handler = Lino.products.ProductCats.insert;
    Lino.products.ProductCats.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.products.ProductCats.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.products.ProductCats.insertPanel(p);
});

Lino.products.ProductCats.detailPanel = Ext.extend(Lino.products.ProductCats.DetailFormPanel,{
  empty_title: "Detail Product Categories",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/products/ProductCats",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.products.ProductCats.detail;
    this.ls_insert_handler = Lino.products.ProductCats.insert;
    Lino.products.ProductCats.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.products.ProductCats.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.products.ProductCats.detailPanel(p);
});
Lino.products.ProductCats.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.products.ProductCats.GridPanel(p);
});

// js_render_GridPanel_class products.Products
Lino.products.Products.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/products/Products",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Products",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "cat" }, 'catHidden', { "type": "boolean", "name": "vatExempt" }, { "name": "price" }, { "name": "sales_account" }, 'sales_accountHidden', { "name": "purchases_account" }, 'purchases_accountHidden', { "name": "description" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 54,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 14,
  initComponent : function() {
    this.ls_detail_handler = Lino.products.Products.detail;
    this.ls_insert_handler = Lino.products.Products.insert;
    var ww = this.containing_window;
    var id2340 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2341 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de2342 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr2343 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var cat2344 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/products/Products/cat", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Product Category..." });
    var vatExempt2345 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var price2346 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var sales_account2347 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/products/Products/sales_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var purchases_account2348 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/products/Products/purchases_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var description2349 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(products.Products.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2340, "width": Lino.chars2width(4), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(products.Products.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2341 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(products.Products.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de2342 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(products.Products.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2343 }, { "colIndex": 4, "sortable": true, "header": "Category", "editable": true, "tooltip": "(products.Products.cat) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('catHidden','Lino.products.ProductCats.detail'), "editor": cat2344, "dataIndex": "cat" }, { "colIndex": 5, "sortable": false, "xtype": "checkcolumn", "header": "VAT exempt", "editable": true, "tooltip": "(products.Products.vatExempt) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "vatExempt" }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "header": "Price", "editable": true, "tooltip": "(products.Products.price) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(7), "dataIndex": "price", "editor": price2346 }), { "colIndex": 7, "sortable": true, "header": "Sales account", "editable": true, "tooltip": "(products.Products.sales_account) The account to move when this product is used in a sales invoice.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "sales_account", "editor": sales_account2347 }, { "colIndex": 8, "sortable": true, "header": "Purchases account", "editable": true, "tooltip": "(products.Products.purchases_account) The account to move when this product is used in a purchases invoice.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "purchases_account", "editor": purchases_account2348 }, { "colIndex": 9, "sortable": false, "header": "Long description", "editable": true, "tooltip": "(products.Products.description) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": description2349, "dataIndex": "description" } ];
    Lino.products.Products.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.products.Products.insertPanel = Ext.extend(Lino.products.Products.DetailFormPanel,{
  empty_title: "New Products",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/products/Products",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.products.Products.detail;
    this.ls_insert_handler = Lino.products.Products.insert;
    Lino.products.Products.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.products.Products.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.products.Products.insertPanel(p);
});

Lino.products.Products.detailPanel = Ext.extend(Lino.products.Products.DetailFormPanel,{
  empty_title: "Detail Products",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save