/*
 Copyright 2009-2013 Luc Saffre
 This file is part of the Lino project.
 Lino is free software; you can redistribute it and/or modify 
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.
 Lino is distributed in the hope that it will be useful, 
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 GNU General Public License for more details.
 You should have received a copy of the GNU General Public License
 along with Lino; if not, see <http://www.gnu.org/licenses/>.
*/

// lino.js --- generated Mon Sep 23 20:34:21 2013 by Lino version 1.6.12.
Ext.BLANK_IMAGE_URL = '/media/extjs/resources/images/default/s.gif';
LANGUAGE_CHOICES = [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ];
MEDIA_URL = "/media";

/* MonthPickerPlugin: thanks to keypoint @ sencha forum
   http://www.sencha.com/forum/showthread.php?74002-3.x-Ext.ux.MonthMenu&p=356860#post356860
*/
Ext.namespace('Ext.ux'); 

Ext.ux.MonthPickerPlugin = function() { 
    var picker; 
    var oldDateDefaults; 

    this.init = function(pk) { 
        picker = pk; 
        picker.onTriggerClick = picker.onTriggerClick.createSequence(onClick); 
        picker.getValue = picker.getValue.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
        picker.beforeBlur = picker.beforeBlur.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
    }; 

    function setDefaultMonthDay() { 
        oldDateDefaults = Date.defaults.d; 
        Date.defaults.d = 1; 
        return true; 
    } 

    function restoreDefaultMonthDay(ret) { 
        Date.defaults.d = oldDateDefaults; 
        return ret; 
    } 

    function onClick(e, el, opt) { 
        var p = picker.menu.picker; 
        p.activeDate = p.activeDate.getFirstDateOfMonth(); 
        if (p.value) { 
            p.value = p.value.getFirstDateOfMonth(); 
        } 

        p.showMonthPicker(); 
         
        if (!p.disabled) { 
            p.monthPicker.stopFx(); 
            p.monthPicker.show(); 

            p.mun(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mun(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
            p.onMonthClick = p.onMonthClick.createSequence(pickerClick); 
            p.onMonthDblClick = p.onMonthDblClick.createSequence(pickerDblclick); 
            p.mon(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mon(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
        } 
    } 

    function pickerClick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.is('button.x-date-mp-cancel')) { 
            picker.menu.hide(); 
        } else if(el.is('button.x-date-mp-ok')) { 
            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 

    function pickerDblclick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.parent() 
            && (el.parent().is('td.x-date-mp-month') 
            || el.parent().is('td.x-date-mp-year'))) { 

            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 
}; 

Ext.preg('monthPickerPlugin', Ext.ux.MonthPickerPlugin);  

//~ /* 
  //~ http://www.diloc.de/blog/2008/03/05/how-to-submit-ext-forms-the-right-way/
//~ */
//~ /**
 //~ * This submit action is basically the same as the normal submit action,
 //~ * only that it uses the fields getSubmitValue() to compose the values to submit,
 //~ * instead of looping over the input-tags in the form-tag of the form.
 //~ *
 //~ * To use it, just use the OOSubmit-plugin on either a FormPanel or a BasicForm,
 //~ * or explicitly call form.doAction('oosubmit');
 //~ *
 //~ * @param {Object} form
 //~ * @param {Object} options
 //~ */
//~ Ext.ux.OOSubmitAction = function(form, options){
    //~ Ext.ux.OOSubmitAction.superclass.constructor.call(this, form, options);
//~ };

//~ Ext.extend(Ext.ux.OOSubmitAction, Ext.form.Action.Submit, {
    //~ /**
    //~ * @cfg {boolean} clientValidation Determines whether a Form's fields are validated
    //~ * in a final call to {@link Ext.form.BasicForm#isValid isValid} prior to submission.
    //~ * Pass <tt>false</tt> in the Form's submit options to prevent this. If not defined, pre-submission field validation
    //~ * is performed.
    //~ */
    //~ type : 'oosubmit',

    //~ // private
    //~ /**
     //~ * This is nearly a copy of the original submit action run method
     //~ */
    //~ run : function(){
        //~ var o = this.options;
        //~ var method = this.getMethod();
        //~ var isPost = method == 'POST';

        //~ var params = this.options.params || {};
        //~ if (isPost) Ext.applyIf(params, this.form.baseParams);

        //~ //now add the form parameters
        //~ this.form.items.each(function(field)
        //~ {
            //~ if (!field.disabled)
            //~ {
                //~ //check if the form item provides a specialized getSubmitValue() and use that if available
                //~ if (typeof field.getSubmitValue == "function")
                    //~ params[field.getName()] = field.getSubmitValue();
                //~ else
                    //~ params[field.getName()] = field.getValue();
            //~ }
        //~ });

        //~ //convert params to get style if we are not post
        //~ if (!isPost) params=Ext.urlEncode(params);

        //~ if(o.clientValidation === false || this.form.isValid()){
            //~ Ext.Ajax.request(Ext.apply(this.createCallback(o), {
                //~ url:this.getUrl(!isPost),
                //~ method: method,
                //~ params:params, //add our values
                //~ isUpload: this.form.fileUpload
            //~ }));

        //~ }else if (o.clientValidation !== false){ // client validation failed
            //~ this.failureType = Ext.form.Action.CLIENT_INVALID;
            //~ this.form.afterAction(this, false);
        //~ }
    //~ },

//~ });
//~ //add our action to the registry of known actions
//~ Ext.form.Action.ACTION_TYPES['oosubmit'] = Ext.ux.OOSubmitAction;




/**
JC Watsons solution (adapted to ExtJS 3.3.1 by LS) is elegant and simple:
`A "fix" for unchecked checkbox submission  behaviour
<http://www.sencha.com/forum/showthread.php?28449>`_

Added special handling for checkbox inputs. 
ExtJS defines disabled checkboxes `readonly`, not `disabled` as for other inputs.

*/
Ext.lib.Ajax.serializeForm = function(form) {
    //~ console.log('20120203 linolib.js serializeForm',form);
    var fElements = form.elements || (document.forms[form] || Ext.getDom(form)).elements, 
        hasSubmit = false, 
        encoder = encodeURIComponent, 
        name, 
        data = '', 
        type, 
        hasValue;

    Ext.each(fElements, function(element){
        name = element.name;
        type = element.type;

        if (!element.disabled && name && !(type == 'checkbox' && element.readonly)) {
            if (/select-(one|multiple)/i.test(type)) {
                Ext.each(element.options, function(opt){
                    if (opt.selected) {
                        hasValue = opt.hasAttribute ? opt.hasAttribute('value') : opt.getAttributeNode('value').specified;
                        data += String.format("{0}={1}&", encoder(name), encoder(hasValue ? opt.value : opt.text));
                    }
                });
            } else if (!(/file|undefined|reset|button/i.test(type))) {
                //~ if (!(/radio|checkbox/i.test(type) && !element.checked) && !(type == 'submit' && hasSubmit)) {
                if (!(type == 'submit' && hasSubmit)) {
                    if (type == 'checkbox') {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&');
                        data += encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&';
                    } else {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + encoder(element.value) + '&');
                        data += encoder(name) + '=' + encoder(element.value) + '&';
                    }
                    hasSubmit = /submit/i.test(type);
                }
            }
        //~ } else {
            //~ console.log(name,type,element.readonly);
        }
    });
    return data.substr(0, data.length - 1);
};



/*
Set a long timeout of fifteen minutes. 
See /blog/2012/0307
*/
Ext.Ajax.timeout = 15 * 60 * 1000; 

/*
 * Thanks to 
 * `huuze <http://stackoverflow.com/users/10040/huuuze>`_ for the question
 * and to 
 * `chrisv <http://stackoverflow.com/users/683808/chrisv>`_
 * for the answer on
 * http://stackoverflow.com/questions/3764589/how-do-i-include-django-1-2s-csrf-token-in-a-javascript-generated-html-form/5485616#5485616
 * 
 * */
 
Ext.Ajax.on('beforerequest', function (conn, options) {
   if (!(/^http:.*/.test(options.url) || /^https:.*/.test(options.url))) {
     if (typeof(options.headers) == "undefined") {
       options.headers = {'X-CSRFToken': Ext.util.Cookies.get('csrftoken')};
     } else {
       options.headers.extend({'X-CSRFToken': Ext.util.Cookies.get('csrftoken')});
     }                        
   }
}, this);


/*
My fix for the "Cannot set QuickTips dismissDelay to 0" bug,
see http://www.sencha.com/forum/showthread.php?183515 
*/
Ext.override(Ext.QuickTip,{
  showAt : function(xy){
        var t = this.activeTarget;
        //~ console.log("20120224 QuickTip.showAt",this.title,this.dismissDelay,t.dismissDelay);
        if(t){
            if(!this.rendered){
                this.render(Ext.getBody());
                this.activeTarget = t;
            }
            if(t.width){
                this.setWidth(t.width);
                this.body.setWidth(this.adjustBodyWidth(t.width - this.getFrameWidth()));
                this.measureWidth = false;
            } else{
                this.measureWidth = true;
            }
            this.setTitle(t.title || '');
            this.body.update(t.text);
            this.autoHide = t.autoHide;
            // bugfix by Luc 20120226
            if (t.dismissDelay != undefined) this.dismissDelay = t.dismissDelay;
            //~ this.dismissDelay = t.dismissDelay || this.dismissDelay;
            if(this.lastCls){
                this.el.removeClass(this.lastCls);
                delete this.lastCls;
            }
            if(t.cls){
                this.el.addClass(t.cls);
                this.lastCls = t.cls;
            }
            if(this.anchor){
                this.constrainPosition = false;
            }else if(t.align){ 
                xy = this.el.getAlignToXY(t.el, t.align);
                this.constrainPosition = false;
            }else{
                this.constrainPosition = true;
            }
        }
        Ext.QuickTip.superclass.showAt.call(this, xy);
    }
});

/*
Another hack. See /docs/blog/2012/0228
*/
Ext.Element.addMethods(
    function() {
        var VISIBILITY      = "visibility",
            DISPLAY         = "display",
            HIDDEN          = "hidden",
            NONE            = "none",
            XMASKED         = "x-masked",
            XMASKEDRELATIVE = "x-masked-relative",
            data            = Ext.Element.data;

        return {
            
            mask : function(msg, msgCls) {
                var me  = this,
                    dom = me.dom,
                    dh  = Ext.DomHelper,
                    EXTELMASKMSG = "ext-el-mask-msg",
                    el,
                    mask;
                // removed the following lines. See /docs/blog/2012/0228
                //~ if (!(/^body/i.test(dom.tagName) && me.getStyle('position') == 'static')) {
                    //~ console.log(20120228,dom.tagName,me);
                    //~ me.addClass(XMASKEDRELATIVE); 
                //~ }
                if (el = data(dom, 'maskMsg')) {
                    el.remove();
                }
                if (el = data(dom, 'mask')) {
                    el.remove();
                }

                mask = dh.append(dom, {cls : "ext-el-mask"}, true);
                data(dom, 'mask', mask);

                me.addClass(XMASKED);
                mask.setDisplayed(true);
                
                if (typeof msg == 'string') {
                    var mm = dh.append(dom, {cls : EXTELMASKMSG, cn:{tag:'div'}}, true);
                    data(dom, 'maskMsg', mm);
                    mm.dom.className = msgCls ? EXTELMASKMSG + " " + msgCls : EXTELMASKMSG;
                    mm.dom.firstChild.innerHTML = msg;
                    mm.setDisplayed(true);
                    mm.center(me);
                }
                
                
                if (Ext.isIE && !(Ext.isIE7 && Ext.isStrict) && me.getStyle('height') == 'auto') {
                    mask.setSize(undefined, me.getHeight());
                }
                
                return mask;
            }

            
        };
    }()
);



Ext.namespace('Lino');
    
    

//~ Lino.subst_user_field = new Ext.form.ComboBox({});
//~ Lino.subst_user = null;
Lino.insert_subst_user = function(p){
    //~ console.log('20120714 insert_subst_user',Lino.subst_user,p);
    //~ if (Lino.subst_user_field.getValue()) {
    if (p.su) return;
    if (Lino.subst_user) {
        //~ p.su = Lino.subst_user_field.getValue();
        p.su = Lino.subst_user;
    //~ } else {
        //~ delete p.su;
    }
    //~ console.log('20120714 insert_subst_user -->',Lino.subst_user,p);
}

Lino.login_window = null;


Lino.show_login_window = function(on_login) {
  //~ console.log('20121103 show_login_window',arguments);
  //~ var current_window = Lino.current_window;
  if (Lino.login_window == null) {
    
      function do_login() { 
            //~ alert("20130923 do_login() started");
            Lino.viewport.loadMask.show()
            //~ Lino.body_loadMask.show()
            login_panel.getForm().submit({ 
                method:'POST', 
                waitTitle:'Connecting', 
                waitMsg:'Sending data...',
                success:function(){ 
                  //~ console.log('20130923 logged in',arguments);
                  //~ alert("20130923 do_login() success");
                  Lino.login_window.hide();
                  Lino.close_all_windows();
                  Lino.viewport.loadMask.hide();
                  if (typeof on_login == 'string') {
                      //~ console.log("20130829 on_login",on_login);
                      //~ alert("20130923 on_login gonna load_url");
                      Lino.load_url(on_login);
                      //~ eval(on_login);
                  } 
                  //~ else Lino.load_url(/);
                  //~ Lino.body_loadMask.hide();
                },
                failure: function(form,action) { 
                  //~ this.loadMask.hide();
                  //~ alert("20130923 do_login() failure");
                  Lino.on_submit_failure(form,action);
                  Lino.viewport.loadMask.hide()
                  //~ Lino.body_loadMask.hide()
                  //~ if (Lino.current_window) Lino.current_window.main_item.loadMask.hide()
                }
                //~ failure:function(form, action){ 
                    //~ alert_msg
                    //~ if(action.failureType == 'server'){ 
                        //~ obj = Ext.util.JSON.decode(action.response.responseText); 
                        //~ Ext.Msg.alert('Login Failed!', obj.errors.reason); 
                    //~ }else{ 
                        //~ Ext.Msg.alert('Warning!', 'Authentication server is unreachable : ' + action.response.responseText); 
                    //~ } 
                    //~ Lino.login_panel.getForm().reset(); 
                //~ } 
            }); 
      };
    
      var login_button = new Ext.Button({ 
        text:"Log in",
        formBind: true,	 
        // Function that fires when user clicks the button 
        handler: do_login});
    
      var login_panel = new Ext.FormPanel({ 
        //~ inspired by http://www.sencha.com/learn/a-basic-login/
        autoHeight:true,
        labelWidth:90,
        url:'/auth', 
        frame:true, 
        defaultType:'textfield',
        monitorValid:true,
        items:[{ 
            fieldLabel:"Username", 
            id: 'username',
            name:'username', 
            autoHeight:true,
            allowBlank:false 
        },{ 
            fieldLabel:"Password", 
            name:'password', 
            inputType:'password', 
            autoHeight:true,
            allowBlank:false 
        }],        
        buttons:[ login_button ]});
        
      Lino.login_window = new Ext.Window({
          layout:'fit',
          defaultButton: 'username',
          width:300,
          title:"Log in", 
          autoHeight:true,
          modal: true,
          closeAction: "hide",
          keys: {
            key: Ext.EventObject.ENTER,
            fn: function() { do_login()}
          },
          //~ defaultButton: login_button,
          //~ height:'auto',
          //~ closable: false,
          //~ resizable: false,
          //~ plain: true,
          //~ border: false,
          items: [login_panel] });
  };
  Lino.login_window.show();
};

Lino.logout = function(id,name) {
    //~ console.log('20121104 gonna log out',arguments);
    //~ Lino.do_action
    Lino.call_ajax_action(Lino.viewport,'GET','/auth',{},'logout',undefined,undefined,function(){
        //~ console.log('20121104 logged out',arguments);
        //~ Lino.login_window.hide();
        Lino.close_all_windows();
    })
}

Lino.set_subst_user = function(id,name) {
    //~ console.log(20130723,'Lino.set_subst_user',id,name,Lino.current_window,Lino.viewport);
    Lino.subst_user = id;
//~ 
    if (Lino.current_window) 
        Lino.current_window.main_item.set_base_param("su",id);
    if (Lino.viewport) 
        Lino.permalink_handler(Lino.current_window)();
}



//~ Lino.select_subst_user = function(cmp,rec,value){
    //~ Lino.subst_user=value;
    //~ console.log(20120713,rec);
//~ }
    
Lino.current_window = null;
Lino.window_history = Array();
    
Lino.chars2width = function(cols) {  return cols * 9; }
Lino.rows2height = function(cols) {  return cols * 20; }



Lino.MainPanel = {
  is_home_page : false,
  setting_param_values : false,
  config_containing_window : function(wincfg) { }
  ,init_containing_window : function(win) { }
  ,is_loading : function() { 
      if (!this.rendered) return true;
      //~ return (Ext.select('.x-loading-msg').elements.length > 0);
      return true; 
    } 
  ,do_when_clean : function(auto_save,todo) { todo() }
  ,get_master_params : function() {
    var p = {}
    p['mt'] = this.content_type; 
    rec = this.get_current_record()
    if (rec) {
      if (rec.phantom) {
          p['mk'] = undefined; 
      }else{
          p['mk'] = rec.id; 
      }
    } else {
      p['mk'] = undefined;
    }
    //~ console.log('get_master_params returns',p,'using record',rec);
    return p;
  }
  ,get_permalink : function() {
    //~ var p = this.main_item.get_base_params() || {};
    var p = Ext.apply({},this.get_base_params());
    delete p.fmt;
    //~ if (p.fmt) delete p.fmt;
    Ext.apply(p,this.get_permalink_params());
    
    if (this.toggle_params_panel_btn) {
        p.sp = this.toggle_params_panel_btn.pressed;
        //~ if (this.toggle_params_panel_btn.pressed == this.params_panel_hidden) {
          //~ p.sp = true;
        //~ }
    }
    
    //~ Lino.insert_subst_user(p);
     //~ p.fmt = 'html';
    //~ console.log('get_permalink',p,this.get_permalink_params());
    if (this.is_home_page)
        //~ var url = '';
        var url = '/';
    else 
        var url = this.get_permalink_url();
    if (p.su == null) 
        delete p.su;
    if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
    return url;
  }
  ,get_record_url : function(record_id) {
      var url = '/api' + this.ls_url
      //~ var url = this.containing_window.config.url_data; // ls_url;
      url += '/' + (record_id === undefined ? '-99999' : String(record_id));
      //~ if (record_id !== undefined) url += '/' + String(record_id);
      //~ url += '/' + String(record_id);
      return url;
  }
  ,get_permalink_url : function() {
      return '/api' + this.ls_url;
  }
  ,get_permalink_params : function() {
      //~ return {an:'grid'};
      var p = {};
      if (this.action_name)
          p.an = this.action_name;
      this.add_param_values(p,false)
      return p;
  }
  ,set_status : function(status) {}
  ,get_status : function() { return {}}
  ,refresh : function() {}
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,add_params_panel : function (tbar) {
      if (this.params_panel) {
        var t = this;
        // 20130918 do_when_visible
        //~ this.params_panel.on('render',
        this.params_panel.on('afterlayout',function() {
            //~ console.log("20130918 afterlayout");
            Lino.do_when_visible(t.get_containing_window(), function() {
                t.get_containing_window().doLayout(true);
            });
        });
        //~ this.params_panel.on('bodyresize',function() {
            //~ console.log("20130918 bodyresize");
            //~ Lino.do_when_visible(t.get_containing_window(), function() {
                //~ t.get_containing_window().doLayout(true);
            //~ });
        //~ });
        //~ Lino.do_when_visible(this.params_panel, function() {
            //~ t.params_panel.doLayout();
            //~ t.get_containing_window().doLayout();
            //~ });
        this.toggle_params_panel_btn = new Ext.Button({ scope:this, 
          //~ text: "$_("[parameters]")", // gear
          iconCls: 'x-tbar-parameters',
          tooltip:"Show or hide the table parameters panel",
          enableToggle: true,
          //~ pressed: ! this.params_panel.hidden,
          pressed: ! this.params_panel_hidden,
          toggleHandler: function(btn,state) { 
            //~ console.log("20120210 add_params_panel",state,this.params_panel);
            if (state) {
                this.params_panel.show();
            } else {
                this.params_panel.hide();
            }
            t.get_containing_window().doLayout();
          }
        }); 
        tbar = tbar.concat([this.toggle_params_panel_btn]);
        var refresh = function() {
            if (!t.setting_param_values) {
                t._force_dirty = true; 
                t.refresh();
            }
        }
        Ext.each(this.params_panel.fields,function(f) {
          //~ f.on('valid',function() {t.refresh()});
          if (f instanceof Ext.form.Checkbox) {
              f.on('check',refresh);
          } else if (f instanceof Ext.DatePicker) {
              f.on('select',refresh);
          } else if (f instanceof Ext.form.TriggerField) {
              f.on('select',refresh);
              //~ f.on('change',refresh);
              //~ f.on('valid',refresh);
          } else {
              if (! f.on) 
                  console.log("20121010 no method 'on'",f);
              else
                  f.on('change',refresh);
            }
          });
      }
      return tbar;
  }
  ,add_param_values : function (p,force_dirty) {
    if (this.params_panel) {
      /* 
      * 20120918 add param_values to the request string 
      * *only if the params_form is dirty*.
      * Otherwise Actor.default_params() would never be used.
      *
      * 20121023 But IntegClients.params_default has non-empty default values. 
      * Users must have the possibility to make them empty.
      * 
      * 20130605 : added `force_dirty` parameter because Checkbox fields don't 
      * mark their form as dirty when check is fired.
      * 
      * 20130721 : `force_dirty` not as a parameter but as 
      * `this._force_dirty` because
      * 
      * 20130915 : both _force_dirty and force_dirty parameter are needed.
      * 
      */
      if (force_dirty || this._force_dirty || this.params_panel.form.isDirty()) {
      //~ if (this._force_dirty || this.params_panel.form.isDirty()) {
        p.pv = this.get_param_values();
        //~ console.log("20130605 form is dirty",p);
      }else{
        //~ console.log("20130605 form not dirty:",this.params_panel.form);
        if (this.status_param_values) 
          p.pv = Lino.fields2array(
            this.params_panel.fields,this.status_param_values);
      }
      //~ if (!this.params_panel.form.isDirty()) return;
      //~ p.pv = this.get_param_values();
      //~ console.log("20120203 add_param_values added pv",p.pv,"to",p);
    }
  },
  get_param_values : function() { // similar to get_field_values()
      return Lino.fields2array(this.params_panel.fields);
  },
  set_param_values : function(pv) {
    if (this.params_panel) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_param_values = pv;
      //~ this.params_panel.form.suspendEvents(false);
      this.setting_param_values = true;
      if (pv) { 
          this.params_panel.form.my_loadRecord(pv);
      } else { 
        this.params_panel.form.reset(); 
      }
      this.setting_param_values = false;
      this._force_dirty = false; 
      //~ this.params_panel.form.resumeEvents();
    }
  }
};




Lino.Viewport = Ext.extend(Ext.Viewport,Lino.MainPanel);
Lino.Viewport = Ext.extend(Lino.Viewport,{
  layout : "fit"
  ,is_home_page : true
  ,initComponent : function(){
    Lino.Viewport.superclass.initComponent.call(this);
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.el,{msg:"Please wait..."});
      //~ console.log("20121118 Lino.viewport.loadMask",this.loadMask);
    },this);
  }
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,refresh : function() {
      var caller = this;
      //~ console.log("20121120 Lino.Viewport.refresh()");
      if (caller.loadMask) caller.loadMask.show();
      var success = function(response) {
        if (caller.loadMask) caller.loadMask.hide();
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          //~ console.log('Lino.do_action()',action.name,'result is',result);
          if (result.html) {
              Ext.getCmp('main_area').update(result.html);
          }
          if (result.message) {
              if (result.alert) {
                  //~ Ext.MessageBox.alert('Alert',result.alert_msg);
                  Ext.MessageBox.alert('Alert',result.message);
              } else {
                  Lino.notify(result.message);
              }
          }
          
          if (result.notify_msg) Lino.notify(result.notify_msg);
          if (result.js_code) { 
            var jsr = result.js_code(caller);
            //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
          };
        }
      };
      var action = {
        url : '/api/main_html',
        waitMsg: "Please wait...",
        failure: Lino.ajax_error_handler(caller),
        success: success,
        method: 'GET',
        params: {}
      };
      Lino.insert_subst_user(action.params);
      Ext.Ajax.request(action);
    
  }
});




Lino.open_window = function(win,st,requesting_panel) {
  //~ console.log("20120918 Lino.open_window()",win,st);
  var cw = Lino.current_window;
  if (cw) {
    //~ console.log("20120918 Lino.open_window() save current status",cw.main_item.get_status());
    Lino.window_history.push({
      window:cw,
      status:cw.main_item.get_status()
    });
  }
  Lino.current_window = win;
  //~ if (st.su) 
      //~ Lino.subst_user_field.setValue(st.su);
  win.main_item.set_status(st,requesting_panel);
  win.show();
};

Lino.load_url = function(url) {
    //~ foo.bar.baz = 2; 
    //~ console.log("20121120 Lino.load_url()");
    //~ Lino.body_loadMask.show();
    Lino.viewport.loadMask.show();
    //~ location.replace(url);
    document.location = url;
}

Lino.close_window = function(status_update) {
  var cw = Lino.current_window;
  var ww = Lino.window_history.pop();
  if (ww) {
    //~ if (status_update) Ext.apply(ww.status,status_update);
    if (status_update) status_update(ww);
    ww.window.main_item.set_status(ww.status);
    Lino.current_window = ww.window;
  } else {
    Lino.current_window = null;
  }
  if (cw) cw.hide_really();
};

Lino.close_all_windows = function() {
  if (Lino.window_history.length == 0) {
      //~ Lino.viewport.refresh();
      var url =  "/auth"
      //~ console.log("20121120 Lino.close_all_windows() : no window_history");
      //~ if (ADMIN_URL) 
      var p = {};
      Lino.insert_subst_user(p)
      if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
      Lino.load_url(url);
  } else {
    //~ console.log("20121120 Lino.close_all_windows() with window_history");
    while (Lino.window_history.length > 0) {
      Lino.close_window();
      //~ Lino.window_history.pop().hide_really();
    }
  }
  //~ Lino.current_window = null;
  //~ Lino.close_window();
  //~ var ww = 
}

Lino.kill_current_window = function() {
  var cw = Lino.current_window;
  Lino.current_window = null;
  if (cw) cw.hide_really();
};

Lino.calling_window = function() {
    if (Lino.window_history.length) return Lino.window_history[Lino.window_history.length-1];
}

//~ Lino.WindowAction = function(mainItemClass,windowConfig,mainConfig,ppf) {
Lino.WindowAction = function(windowConfig,main_item_fn) {
    //~ if(!mainConfig) mainConfig = {};
    //~ mainConfig.is_main_window = true;
    this.windowConfig = windowConfig;
    this.main_item_fn = main_item_fn;
    //~ if (ppf) mainConfig.params_panel.fields = ppf;
    //~ this.mainConfig = mainConfig;
    //~ this.mainItemClass = mainItemClass;
};

Lino.WindowAction = Ext.extend(Lino.WindowAction,{
    window : null,
    //~ mainItemClass: null,
    get_window : function() {
      //~ if(mainConfig) Ext.apply(this.mainConfig,mainConfig);
      if (this.window == null)  {
          //~ this.windowConfig.main_item = new this.mainItemClass(this.mainConfig);
          this.windowConfig.main_item = this.main_item_fn();
          this.window = new Lino.Window(this.windowConfig);
      }
      return this.window;
    },
    run : function(requesting_panel,status) {
      //~ console.log('20120625 window_action.run()',this)
      Lino.open_window(this.get_window(),status,requesting_panel);
    }
  
});


Lino.PanelMixin = {
  get_containing_window : function (){
      if (this.containing_window) return this.containing_window;
      return this.containing_panel.get_containing_window();
  }
  ,set_window_title : function(title) {
    //~ this.setTitle(title);
    var cw = this.get_containing_window();

    //~ if (cw) {
    //~ if (cw && cw.closable) {
    if (cw && !cw.main_item.hide_window_title) {
      //~ console.log('20111202 set_window_title(',title,') for',this.containing_window);
      //~ if (! this.containing_window.rendered) console.log("WARNING: not rendered!");
      cw.setTitle(title);
    //~ } else {
      //~ document.title = title;
    }
    //~ else console.log('20111202 not set_window_title(',title,') for',this);
  }
  
};


// Lino.status_bar = new Ext.ux.StatusBar({defaultText:'Lino version 1.6.12.'});
Lino.status_bar = new Ext.ux.StatusBar({
    autoClear: 10000, // 10 seconds
    defaultText:'Lino Così 0.1.'
    });



Lino.edit_tinymce_text = function(panel,options) {
  // `panel` is the RichTextPanel
  //~ console.log(20111220,panel);
  //~ var rec = panel.get_current_record();
  var rec = panel.containing_panel.get_current_record();
  var value = rec ? rec.data[panel.editor.name] : '';
  var saving = false;
  var todo_after_save = false;
  var discard_changes = false;
  
  
  function save() {
    //~ if (todo_after_save) {alert('tried to save again'); return; }
    if (saving) {alert('tried to save again'); return; }
    //~ var url = panel.containing_window.main_item.get_record_url(rec.id);
    var url = panel.containing_panel.get_record_url(rec.id);
    var params = Ext.apply({},panel.containing_panel.get_base_params());
    params[panel.editor.name] = editor.getValue();
    //~ params.su = Lino.subst_user;
    //~ Lino.insert_subst_user(params);
    var a = { 
      params: params, 
      method: 'PUT',
      url: url,
      failure: function() {
          //~ if (editor.ed.getContainer()) 
          editor.ed.setProgressState(0);
          todo_after_save = false;
          saving = false;
          console.log('tinymce.save() failed. sorry.',arguments);
        },
      success: function() {
        saving = false;
        //~ if (editor.ed.getContainer()) 
        editor.ed.setProgressState(0);
        rec.data[panel.editor.name] = editor.getValue();
        if(todo_after_save) {
            var fn = todo_after_save;
            todo_after_save = false;
            fn();
        }
        //~ panel.containing_window.set_current_record(rec);
        panel.refresh();
      }
    };
    //~ if (editor.ed.getContainer()) 
    editor.ed.setProgressState(1); // Show progress
    saving = true;
    //~ console.log(a);
    Ext.Ajax.request(a);
  };
  function save_callback() {
      save();
      //~ save(function(){editor.ed.setDirty(false);})
      /* return true have the save button disabled.  
      That's not perfect because the PUT is asynchronous 
      and the response is not yet known.
      */
      return true;
  }
  //~ var actions = [
    //~ {text:"Save",handler:save}
  //~ ]; 
  //~ console.log(20110610,panel.editor.disabled);
  var settings = {};
  Ext.apply(settings,{
        readonly: panel.editor.disabled,
        //~ language: "de",
        plugins : "save,emotions,spellchecker,advhr,insertdatetime,preview,table,searchreplace,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "save,cancel,|,bold,italic,underline,|,justifyleft,justifycenter,justifyright,fontselect,fontsizeselect,formatselect,|,search,replace",
        theme_advanced_buttons2 : "cut,copy,paste,template,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,link,unlink,anchor,image,|,code,preview,|,forecolor,backcolor",
        theme_advanced_buttons3 : "insertdate,inserttime,|,spellchecker,advhr,,removeformat,|,sub,sup,|,charmap,emotions,|,tablecontrols",      
        theme_advanced_resizing : false,
        convert_urls : false,
        save_onsavecallback : save_callback,
        save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
  });
  Ext.apply(settings,options);
  var editor = new Ext.ux.TinyMCE({
      value : value,
      tinymceSettings: settings
    });
  var win = new Ext.Window({
    title: rec.title, 
    //~ bbar: actions,
    layout: 'fit',
    items: editor,
    width: 600, 
    height:500,
    minWidth: 100,
		minHeight: 100,
    modal: true,
    resizable: true,
    maximizable: true,
    //~ maximized: true,
    //~ closeAction: "close"
    closeAction: "hide"
    //~ hideMode: "offsets",
    //~ constrainHeader: true,
    //~ bodyStyle: 'padding: 10px'
  });

  //~ win.on('beforeclose',function() {
  win.on('beforehide',function() {
    if (todo_after_save) return false;
    if (discard_changes) return true;
    if (editor.isDirty()) {
        //~ var ok = false;
        //~ var allowClose = true;
        var config = {title:"Confirmation"};
        config.buttons = Ext.MessageBox.YESNOCANCEL;
        config.msg = "Save changes to text ?";
        config.modal = true;
        config.fn = function(buttonId,text,opt) {
          //~ console.log('do_when_clean',buttonId)
          if (buttonId == "yes") {
              /* we cancel this close, but save()'s onSuccess will call again.*/
              //~ allowClose = false;
              todo_after_save = function(){win.hide();}
              editor.ed.execCommand('mceSave');
              //~ editor.ed.save(function(){win.close();});
          } else if (buttonId == "no") { 
              discard_changes = true;
              win.hide()
          //~ } else if (buttonId == "cancel") { 
            //~ ok = true;
              //~ allowClose = false;
          //~ } else { 
            //~ console.log('unknwon buttonId:',buttonId);
          }
        }
        Ext.MessageBox.show(config);
        return false;
        //~ return allowClose;
    }
  });
  win.show();
}







/* 
  Originally copied from Ext JS Library 3.3.1
  Modifications by Luc Saffre : 
  - rendering of phantom records
  - fire afteredit event
  - react on dblclcik, not on single click

 */
Lino.CheckColumn = Ext.extend(Ext.grid.Column, {

    processEvent : function(name, e, grid, rowIndex, colIndex){
        //~ console.log('20110713 Lino.CheckColumn.processEvent',name)
        if (name == 'click') {
        //~ if (name == 'mousedown') {
        //~ if (name == 'dblclick') {
            return this.toggleValue(grid, rowIndex, colIndex);
        } else {
            return Ext.grid.ActionColumn.superclass.processEvent.apply(this, arguments);
        }
    },
    
    toggleValue : function (grid,rowIndex,colIndex) {
        var record = grid.store.getAt(rowIndex);
        var dataIndex = grid.colModel.getDataIndex(colIndex);
        // 20120514
        //~ if(record.data.disabled_fields && record.data.disabled_fields[dataIndex]) {
          //~ Lino.notify("This field is disabled");
          //~ return false;
        //~ }
      
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("This field is disabled.");
            //~ return false;
        //~ }
        var startValue = record.data[dataIndex];
        var value = !startValue;
        //~ record.set(this.dataIndex, value);
        var e = {
            grid: grid,
            record: record,
            field: dataIndex,
            originalValue: startValue,
            value: value,
            row: rowIndex,
            column: colIndex,
            cancel: false
        };
        if(grid.fireEvent("beforeedit", e) !== false && !e.cancel){
        //~ if(grid.fireEvent("validateedit", e) !== false && !e.cancel){
            record.set(dataIndex, value);
            delete e.cancel;
            grid.fireEvent("afteredit", e);
        }
        return false; // Cancel event propagation
    },

    renderer : function(v, p, record){
        if (record.phantom) return '';
        p.css += ' x-grid3-check-col-td'; 
        return String.format('<div class="x-grid3-check-col{0}">&#160;</div>', v ? '-on' : '');
    }

    // Deprecate use as a plugin. Remove in 4.0
    // init: Ext.emptyFn
});

// register ptype. Deprecate. Remove in 4.0
// Ext.preg('checkcolumn', Lino.CheckColumn);

// backwards compat. Remove in 4.0
// Ext.grid.CheckColumn = Lino.CheckColumn;

// register Column xtype
Ext.grid.Column.types.checkcolumn = Lino.CheckColumn;


/* 20110725 : 
Lino.on_tab_activate is necessary 
in contacts.Person.2.dtl 
(but don't ask me why...)
*/
Lino.on_tab_activate = function(item) {
  //~ console.log('activate',item); 
  if (item.rendered && item.doLayout) item.doLayout();
  //~ if (item.rendered) item.doLayout();
}

Lino.TimeField = Ext.extend(Ext.form.TimeField,{
  format: 'H:i',
  increment: 15
  });
Lino.DateField = Ext.extend(Ext.form.DateField,{
  boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  altFormats: 'd/m/Y|Y-m-d'
  });
Lino.DatePickerField = Ext.extend(Ext.DatePicker,{
  //~ boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  //~ altFormats: 'd/m/Y|Y-m-d'
  formatDate : function(date){
      //~ console.log("20121203 formatDate",this.name,date);
      return Ext.isDate(date) ? date.dateFormat(this.format) : date;
  }
  });
Lino.DateTimeField = Ext.extend(Ext.ux.form.DateTime,{
  dateFormat: 'd.m.Y',
  timeFormat: 'H:i'
  //~ ,hiddenFormat: 'd.m.Y H:i'
  });
Lino.URLField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  //~ triggerClass : 'x-form-world-trigger',
  vtype: 'url',
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    window.open(this.getValue(),'_blank');
  }
});
Lino.IncompleteDateField = Ext.extend(Ext.form.TextField,{
  //~ regex: /^-?\d+-[01]\d-[0123]\d$/,
  //~ regex: /^[0123]\d\.[01]\d\.-?\d+$/,
  maxLength: 10,
  boxMinWidth: Lino.chars2width(10),
  regex: /^[0123]?\d\.[01]?\d\.-?\d+$/,
  regexText: 'Enter a date in format YYYY-MM-DD (use zeroes for unknown parts).'
  });


//~ Lino.make_dropzone = function(cmp) {
    //~ cmp.on('render', function(ct, position){
      //~ ct.el.on({
        //~ dragenter:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ return true;
        //~ }
        //~ ,dragover:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ event.stopEvent();
          //~ return true;
        //~ }
        //~ ,drop:{
          //~ scope:this
          //~ ,fn:function(event){
            //~ event.stopEvent();
            //~ console.log(20110516);
            //~ var files = event.browserEvent.dataTransfer.files;
            //~ if(files === undefined){
              //~ return true;
            //~ }
            //~ var len = files.length;
            //~ while(--len >= 0){
              //~ console.log(files[len]);
              //~ // this.processDragAndDropFileUpload(files[len]);
            //~ }
          //~ }
        //~ }
      //~ });
    //~ });
//~ };

//~ Lino.FileUploadField = Ext.ux.form.FileUploadField;

Lino.FileUploadField = Ext.extend(Ext.ux.form.FileUploadField,{
    onRender : function(ct, position){
      Lino.FileUploadField.superclass.onRender.call(this, ct, position);
      this.el.on({
        dragenter:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          return true;
        }
        ,dragover:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          event.stopEvent();
          return true;
        }
        ,drop:{
          scope:this
          ,fn:function(event){
            event.stopEvent();
            //~ console.log(20110516);
            var files = event.browserEvent.dataTransfer.files;
            if(files === undefined){
              return true;
            }
            var len = files.length;
            while(--len >= 0){
              console.log(files[len]);
              //~ this.processDragAndDropFileUpload(files[len]);
            }
          }
        }
      });
    }
});

Lino.FileField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  editable: false,
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    if (this.getValue()) window.open(MEDIA_URL + '/'+this.getValue(),'_blank');
  }
});

Lino.file_field_handler = function(panel,config) {
  //~ if (instanceof Lino.DetailWrapper) {
  if (panel.action_name == 'insert') {
  //~ if (panel.get_current_record().phantom) {
      panel.has_file_upload = true;

      var f = new Lino.FileUploadField(config);
      //~ Lino.make_dropzone(f);
      return f;
      //~ return new Ext.ux.form.FileUploadField(config);
      //~ return new Lino.FileField(config);
      
  } else {
      //~ return new Lino.URLField(config);
      return new Lino.FileField(config);
  }
}

Lino.VBorderPanel = Ext.extend(Ext.Panel,{
    constructor : function(config) {
      config.layout = 'border';
      delete config.layoutConfig;
      Lino.VBorderPanel.superclass.constructor.call(this,config);
      for(var i=0; i < this.items.length;i++) {
        var item = this.items.get(i);
        if (this.isVertical(item) && item.collapsible) {
          item.on('collapse',this.onBodyResize,this);
          item.on('expand',this.onBodyResize,this);
        }
      }
    },
    isVertical : function(item) {
       return (item.region == 'north' || item.region == 'south' || item.region == 'center');
    },
    onBodyResize: function(w, h){
        //~ console.log('VBorderPanel.onBodyResize',this.title)
      if (this.isVisible()) { // to avoid "Uncaught TypeError: Cannot call method 'getHeight' of undefined."
        var sumflex = 0;
        var availableHeight = this.getInnerHeight();
        var me = this;
        this.items.each(function(item){
          if (me.isVertical(item)) {
              if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  if (item.rendered) availableHeight -= item.getHeight();
              } else {
                  sumflex += item.flex;
              }
          } 
          
        });
        //~ for(var i=0; i < this.items.length;i++) {
          //~ var item = this.items.get(i);
          //~ // if (this.isVertical(item) && item.getResizeEl()) {
          //~ if (this.isVertical(item)) {
              //~ if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  //~ // item.syncSize()
                  //~ // item.doLayout()
                  //~ // if (item.region == "north") console.log('region north',item.getHeight(),item.id, item);
                  //~ // if (item.getHeight() == 0) console.log(20100921,'both flex and getHeight() are 0!');
                  //~ availableHeight -= item.getHeight();
              //~ } else {
                  //~ sumflex += item.flex;
                  //~ // console.log(item.flex);
              //~ }
          //~ } 
          //~ // else console.log('non-vertical item in VBoderPanel:',item)
        //~ }
        var hunit = availableHeight / sumflex;
        //~ console.log('sumflex=',sumflex,'hunit=',hunit, 'availableHeight=',availableHeight);
        for(var i=0; i < this.items.length;i++) {
          var item = this.items.get(i);
          if (this.isVertical(item)) {
              if (item.flex != 0 && ! item.collapsed) {
                  item.setHeight(hunit * item.flex);
                  //~ console.log(item.region,' : height set to',item.getHeight());
              }
          }
          //~ else console.log('non-vertical item in VBoderPanel:',item)
        }
      }
      Lino.VBorderPanel.superclass.onBodyResize.call(this, w, h);
    }
});


/*
  modifications to the standard behaviour of a CellSelectionModel:
  
*/
Ext.override(Ext.grid.CellSelectionModel, {
//~ var dummy = {

    handleKeyDown : function(e){
        /* removed because F2 wouldn't pass
        if(!e.isNavKeyPress()){
            return;
        }
        */
        //~ console.log('handleKeyDown',e)
        var k = e.getKey(),
            g = this.grid,
            s = this.selection,
            sm = this,
            walk = function(row, col, step){
                return g.walkCells(
                    row,
                    col,
                    step,
                    g.isEditor && g.editing ? sm.acceptsNav : sm.isSelectable, 
                    sm
                );
            },
            cell, newCell, r, c, ae;

        switch(k){
            case e.ESC:
            case e.PAGE_UP:
            case e.PAGE_DOWN:
                break;
            default:
                // e.stopEvent(); // removed because Browser keys like Alt-Home, Ctrl-R wouldn't work
                break;
        }

        if(!s){
            cell = walk(0, 0, 1); 
            if(cell){
                this.select(cell[0], cell[1]);
            }
            return;
        }

        cell = s.cell;  
        r = cell[0];    
        c = cell[1];    
        
        switch(k){
            case e.TAB:
                if(e.shiftKey){
                    newCell = walk(r, c - 1, -1);
                }else{
                    newCell = walk(r, c + 1, 1);
                }
                break;
            case e.HOME:
                if (! (g.isEditor && g.editing)) {
                  if (!e.hasModifier()){
                      newCell = [r, 0];
                      //~ console.log('home',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
                      if (activePage > 1) {
                          e.stopEvent();
                          t.moveFirst();
                          return;
                      }
                      newCell = [0, c];
                      break;
                  }
                }
            case e.END:
                if (! (g.isEditor && g.editing)) {
                  c = g.colModel.getColumnCount()-1;
                  if (!e.hasModifier()) {
                      newCell = [r, c];
                      //~ console.log('end',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var d = t.getPageData();
                      if (d.activePage < d.pages) {
                          e.stopEvent();
                          var self = this;
                          t.on('change',function(tb,pageData) {
                              var r = g.store.getCount()-2;
                              self.select(r, c);
                              //~ console.log('change',r,c);
                          },this,{single:true});
                          t.moveLast();
                          return;
                      } else {
                          newCell = [g.store.getCount()-1, c];
                          //~ console.log('ctrl-end',newCell);
                          break;
                      }
                  }
                }
            case e.DOWN:
                newCell = walk(r + 1, c, 1);
                break;
            case e.UP:
                newCell = walk(r - 1, c, -1);
                break;
            case e.RIGHT:
                newCell = walk(r, c + 1, 1);
                break;
            case e.LEFT:
                newCell = walk(r, c - 1, -1);
                break;
            case e.F2:
                if (!e.hasModifier()) {
                    if (g.isEditor && !g.editing) {
                        g.startEditing(r, c);
                        e.stopEvent();
                        return;
                    }
                    break;
                }
            case e.INSERT:
                if (!e.hasModifier()) {
                    if (g.ls_insert_handler && !g.editing) {
                        e.stopEvent();
                        Lino.show_insert(g);
                        return;
                    }
                    break;
                }
            case e.DELETE:
                if (!e.hasModifier()) {
                    if (!g.editing) {
                        e.stopEvent();
                        Lino.delete_selected(g);
                        return;
                    }
                    break;
                }
            case e.ENTER:
                e.stopEvent();
                g.onCellDblClick(r,c);
                break;
                
        }
        

        if(newCell){
          e.stopEvent();
          r = newCell[0];
          c = newCell[1];
          this.select(r, c); 
          if(g.isEditor && g.editing){ 
            ae = g.activeEditor;
            if(ae && ae.field.triggerBlur){
                ae.field.triggerBlur();
            }
            g.startEditing(r, c);
          }
        //~ } else if (g.isEditor && !g.editing && e.charCode) {
        //~ // } else if (!e.isSpecialKey() && g.isEditor && !g.editing) {
            //~ g.set_start_value(String.fromCharCode(e.charCode));
            //~ // g.set_start_value(String.fromCharCode(k));
            //~ // g.set_start_value(e.charCode);
            //~ g.startEditing(r, c);
            //~ // e.stopEvent();
            //~ return;
        // } else {
          // console.log('20120513',e,g);
        }
        
    }


//~ };
});

 

function PseudoConsole() {
    this.log = function() {};
};
if (typeof(console) == 'undefined') console = new PseudoConsole();

Lino.notify = function(msg) {
  if (msg == undefined) msg = ''; else console.log(msg);
  //~ Ext.getCmp('konsole').update(msg);
  Lino.status_bar.setStatus({
    text: msg,
    iconCls: 'ok-icon',
    clear: true // auto-clear after a set interval
  });
  //~ Ext.getCmp('konsole').setTitle(msg.replace(/\n/g,'<br/>'));
  //~ Ext.getCmp('konsole').update(msg.replace(/\n/g,'<br/>'));
};
Lino.alert = function(msg) {
  //~ if (msg == undefined) msg = ''; else console.log(msg);
  Ext.MessageBox.alert('Notify',msg);
};


//~ Lino.show_about = function() {
  //~ new Ext.Window({
    //~ width: 400, height: 400,
    //~ title: "About",
    //~ html: '<a href="http://www.extjs.com" target="_blank">ExtJS</a> version ' + Ext.version
  //~ }).show();
//~ };

function obj2str(o) {
  if (typeof o != 'object') return String(o);
  var s = '';
  for (var p in o) {
    s += p + ': ' + obj2str(o[p]) + '\n';
  }
  return s;
}

Lino.on_store_exception = function (store,type,action,options,response,arg) {
  //~ throw response;
  console.log("on_store_exception: store=",store,
    "type=",type,
    "action=",action,
    "options=",options,
    "response=",response,
    "arg=",arg);
  if (arg) { console.log(arg.stack)};
};

//~ Lino.on_submit_success = function(form, action) {
   //~ Lino.notify(action.result.message);
   //~ this.close();
//~ };

Lino.on_submit_failure = function(form, action) {
    //~ Lino.notify();
  // action may be undefined
    switch (action.failureType) {
        case Ext.form.Action.CLIENT_INVALID:
            Ext.Msg.alert('Client-side failure', 'Form fields may not be submitted with invalid values');
            break;
        case Ext.form.Action.CONNECT_FAILURE:
            Ext.Msg.alert('Connection failure', 'Ajax communication failed');
            break;
        case Ext.form.Action.SERVER_INVALID:
            Ext.Msg.alert('Server-side failure', action.result.message);
   }
};



/*
Lino.save_wc_handler = function(ww) {
  return function(event,toolEl,panel,tc) {
    var pos = panel.getPosition();
    var size = panel.getSize();
    wc = ww.get_window_config();
    Ext.applyIf(wc,{ 
      x:pos[0],y:pos[1],height:size.height,width:size.width,
      maximized:panel.maximized});
    Lino.do_action(ww,{url:'/window_configs/'+ww.config.permalink_name,params:wc,method:'POST'});
  }
};

*/

Lino.show_in_own_window_button = function(handler) {
  return {
    qtip: "Show this panel in own window", 
    id: "up",
    handler: function(event,toolEl,panel, tc) {
      //~ console.log('20111206 report_window_button',panel,handler);
      handler.run(null,{base_params:panel.containing_panel.get_master_params()});
    }
  }
}




Lino.delete_selected = function(panel) {
  //~ console.log("Lino.delete_selected",panel);
  var recs1 = panel.get_selected();
  var recs = [];
  for ( var i=0; i < recs1.length; i++ ) { if (! recs1[i].phantom) recs.push(recs1[i]); }
  if (recs.length == 0) {
    Lino.notify("Please select at least one record.");
    return;
  };
  if (recs.length == 1) {
      if (recs[0].disable_delete) {
        Lino.alert(recs[0].disable_delete);
        return;
      }
  };
  //~ console.log(recs);
  Ext.MessageBox.show({
    title: "Confirmation",
    msg: String.format("Delete {0} rows. Are you sure?",String(recs.length)),
    //~ msg: "Delete " + String(recs.length) + " rows. Are you sure?",
    //~ buttons: Ext.MessageBox.YESNOCANCEL,
    buttons: Ext.MessageBox.YESNO,
    fn: function(btn) {
      if (btn == 'yes') {
        for ( var i=0; i < recs.length; i++ ) {
          Lino.do_action(panel,{
              method:'DELETE',
              url:  '/api' + panel.ls_url + '/' + recs[i].id,
              after_success: panel.after_delete.createDelegate(panel)
          })
        }
        //~ caller.after_delete();
      }
      else Lino.notify("Dann eben nicht.");
    }
  });
};

Lino.action_handler = function (panel,on_success,on_confirm) {
  return function (response) {
    //~ console.log(20120608,panel);
    if (panel instanceof Lino.GridPanel) {
        //~ gridmode = false;
        gridmode = true;
        //~ console.log('20120608 yes');
    } else {
        gridmode = false;
        //~ console.log('20120608 no');
    }
    if (panel.loadMask) panel.loadMask.hide(); // 20120211
    if (!response.responseText) return ;
    var result = Ext.decode(response.responseText);
    //~ console.log('Lino.action_handler()','result is',result,'on_confirm is',on_confirm);
    
    if (result.eval_js) {
        //~ console.log(20120618,result.eval_js);
        eval(result.eval_js);
    }
    
    //~ if (result.goto_record) {
        //~ var js = "Lino." + result.goto_record[0] + '.detail.run';
        //~ var h = eval(js);
        //~ h(panel,{record_id:result.goto_record[1]});
    //~ }
    
    if (result.xcallback) {
        //~ var config = {title:"Confirmation"};
        var config = {title:result.xcallback.title};
        //~ config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        config.buttons = result.xcallback.buttons;
        config.msg = result.message;
        config.fn = function(buttonId,text,opt) {
          panel.loadMask.show(); 
          //~ Lino.insert_subst_user(p);
          Ext.Ajax.request({
            method: 'GET',
            url: '/callbacks'+result.xcallback.id + '/' + buttonId,
            //~ params: {bi: buttonId},
            success: Lino.action_handler(panel,on_success,on_confirm)
          });
          //~ Lino.call_ajax_action(panel,'GET',)
        }
        Ext.MessageBox.show(config);
        return;
    }
    
    if (on_success && result.success) on_success(result);
    
    //~ if (on_confirm && result.confirm_message) {
        //~ var config = {title:"Confirmation"};
        //~ // config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        //~ config.msg = result.confirm_message;
        //~ config.fn = function(buttonId,text,opt) {
          //~ if (buttonId == "yes") {
              //~ on_confirm(panel,undefined,result.step);
          //~ }
        //~ }
        //~ Ext.MessageBox.show(config);
        //~ return;
    //~ }
    //~ if (result.dialog_fn) {
        //~ console.log('20120928 TODO',result.dialog_fn);
    //~ }
    if (result.data_record && ! gridmode) {
        //~ not used
        panel.set_status({data_record:result.data_record});
    }  else if (result.new_status && ! gridmode) {
        //~ not used
        //~ console.log('20120607 new_status');
        panel.set_status(result.new_status);
    } else if (result.goto_record_id != undefined && ! gridmode) {
        //~ Uncaught TypeError: Cannot call method 'run' of undefined 
        panel.load_record_id(result.goto_record_id);
    } 
    
    if (result.message) {
        //~ if (result.alert && ! gridmode) {
        if (result.alert) { // 20120628b 
            //~ Ext.MessageBox.alert('Alert',result.alert_msg);
            if (result.alert === true) result.alert = "Alert";
            Ext.MessageBox.alert(result.alert,result.message);
        } else {
            Lino.notify(result.message);
        }
    }
     
    if (result.refresh_all) {
        var cw = panel.get_containing_window();
        //~ console.log("20120123 refresh_all");
        if (cw) {
          cw.main_item.refresh();
        }
        //~ else console.log("20120123 cannot refresh_all",panel);
    } else {
        //~ console.log("20121212 b gonna refresh",panel);
        if (result.refresh) panel.refresh();
    }
    
    if (result.open_url) {
        //~ console.log(20111126,result.open_url);
        //~ if (!result.message)
            //~ Lino.notify('Open new window <a href="'+result.open_url+'" target="_blank">'+result.open_url+'</a>');
        window.open(result.open_url,'foo',"");
        //~ document.location = result.open_url;
    }
  }
};

Lino.do_action = function(caller,action) {
  action.success = function(response) {
    if (caller.loadMask) caller.loadMask.hide();
    //~ console.log('Lino.do_action()',action,'action success',response);
    if (action.after_success) {
        //~ console.log('Lino.do_action() calling after_success');
        action.after_success();
    }
    if (response.responseText) {
      var result = Ext.decode(response.responseText);
      //~ console.log('Lino.do_action()',action.name,'result is',result);
      if (result.message) {
          if (result.alert) {
              //~ Ext.MessageBox.alert('Alert',result.alert_msg);
              Ext.MessageBox.alert('Alert',result.message);
          } else {
              Lino.notify(result.message);
          }
      }
      
      //~ if (result.alert_msg) Ext.MessageBox.alert('Alert',result.alert_msg);
      //~ if (result.message) Lino.notify(result.message);
      if (result.notify_msg) Lino.notify(result.notify_msg);
      if (result.js_code) { 
        //~ console.log('Lino.do_action()',action,'gonna call js_code in',result);
        var jsr = result.js_code(caller);
        //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
        if (action.after_js_code) {
          //~ console.log('Lino.do_action()',action,'gonna call after_js_code');
          action.after_js_code(jsr);
          //~ console.log('Lino.do_action()',action,'returned from after_js_code');
        //~ } else {
          //~ console.log('Lino.do_action()',action,' : after_js_code is false');
        }
      };
    }
  };
  Ext.applyIf(action,{
    waitMsg: "Please wait...",
    failure: Lino.ajax_error_handler(caller),
    params: {}
  });
  //~ action.params.su = Lino.subst_user;
  Lino.insert_subst_user(action.params);
  
  Ext.Ajax.request(action);
};

//~ Lino.gup = function( name )
//~ {
  //~ // Thanks to http://www.netlobo.com/url_query_string_javascript.html
  //~ name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
  //~ var regexS = "[\\?&]"+name+"=([^&#]*)";
  //~ var regex = new RegExp( regexS );
  //~ var results = regex.exec( window.location.href );
  //~ if( results == null )
    //~ return "";
  //~ else
    //~ return results[1];
//~ };

//~ Lino.refresh_handler = function (ww) {
  //~ return function() { 
      //~ console.log('refresh',ww);
      //~ ww.main_item.doLayout(false,true);
      //~ ww.main_item.syncSize();
  //~ }
//~ };

//~ Lino.tools_close_handler = function (ww) {
  //~ return function() { 
      //~ ww.close();
  //~ }
//~ };
Lino.permalink_handler = function (ww) {
  return function() { 
    //~ document.location = ww.main_item.get_permalink();
    //~ console.log('20130723 Lino.permalink_handler',ww);
    
    /* Uncaught TypeError: Cannot read property 'main_item' of null  */
    if (ww) {
        var url = ww.main_item.get_permalink();
    } else {
        var url = Lino.viewport.get_permalink();
    }
    Lino.load_url(url);
  }
};
//~ Lino.run_permalink = function() {
  //~ var plink = Lino.gup('permalink');
  //~ if(plink) { eval('Lino.'+plink); }
//~ }

Lino.ajax_error_handler = function(panel) {
  return function(response,options) {
    console.log('Ajax failure:',response,options);
    if (panel.loadMask) panel.loadMask.hide();
    if (response.responseText) {
      var lines = response.responseText.split('\n');
      if (lines.length > 10) {
          line = lines.splice(5,lines.length-10,"(...)");
      }
      Ext.MessageBox.alert(
        response.statusText,
        lines.join('<br/>')
        //~ response.responseText.replace(/\n/g,'<br/>'))
      )
    } else {
      Ext.MessageBox.alert('Action failed',
        'Lino server did not respond to Ajax request');
    }
  }
}
// Ext.Ajax.on('requestexception',Lino.ajax_error_handler)
 


Ext.QuickTips.init();

/* setting QuickTips dismissDelay to 0 */
// Apply a set of config properties to the singleton
//~ Ext.apply(Ext.QuickTips.getQuickTip(), {
//~ Ext.apply(Ext.ToolTip, {
    //~ dismissDelay: 0
    //~ autoHide: false,
    //~ closable: true,
    //~ maxWidth: 200,
    //~ minWidth: 100,
    //~ showDelay: 50      // Show 50ms after entering target
    //~ ,trackMouse: true
//~ });


//~ Ext.apply(Ext.QuickTip, {
    //~ dismissDelay: 0,
//~ });
  
Lino.quicktip_renderer = function(title,body) {
  return function(c) {
    //~ if (c instanceof Ext.Panel) var t = c.bwrap; else // 20130129
    if (c instanceof Ext.Panel) var t = c.header; else // 20130129
    var t = c.getEl();
    //~ console.log(20130129,t,title,body);
    //~ t.dismissDelay = 0;
    Ext.QuickTips.register({
      target: t,
      //~ cls: 'lino-quicktip-classical',
      dismissDelay: 0,
      //~ autoHide: false,
      showDelay: 50,      // Show 50ms after entering target
      //~ title: title,
      text: body
    });
  }
};


  
Lino.help_text_editor = function() {
  //~ var bp = {
      //~ mk:this.content_type,
      //~ mt:1
    //~ };
    //~ console.log(20120202,bp);
  //~ Lino.lino.ContentTypes.detail({},{base_params:bp});
  //~ Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
  Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
}

// Path to the blank image should point to a valid location on your server
//~ Ext.BLANK_IMAGE_URL = MEDIA_URL + '/extjs/resources/images/default/s.gif'; 


// used as Ext.grid.Column.renderer for id columns in order to hide the special id value -99999
Lino.id_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  return value;
}

Lino.raw_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  return value;
}

Lino.text_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return "not implemented"; 
  return value;
}

Lino.NullNumberColumn = Ext.extend(Ext.grid.Column, {
    align : 'right', 
    format : '0,00/i', 
    renderer : function(value, metaData, record, rowIndex, colIndex, store) {
        //~ console.log(20130128,"NullNumberColumn.renderer",value);
        if (value === null) return '';
        return Ext.util.Format.number(value, this.format);
    }
});

//~ Lino.NullNumberColumn = Ext.extend(Ext.grid.NumberColumn, {
    //~ align : 'right', 
    //~ constructor: function(cfg){
        //~ Ext.grid.NumberColumn.superclass.constructor.call(this, cfg);
        //~ var t = this;
        //~ this.renderer = function(value, metaData, record, rowIndex, colIndex, store) {
          //~ console.log(20130128,"NullNumberColumn.renderer",value);
          //~ if (value === null) return '';
          //~ return Ext.util.Format.number(value, t.format);
      //~ };
    //~ }
//~ });




//~ Lino.cell_button_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return '<input type="button" onclick="alert(value)" value=" ? ">' ;
//~ }


//~ Lino.default_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  //~ return value;
//~ }

Lino.fk_renderer = function(fkname,handlername) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    //~ if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '.run(null,{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

Lino.lfk_renderer = function(panel,fkname) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  var handlername = 'console.log';
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '({},{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

//~ Lino.gfk_renderer = function() {
  //~ return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ if (record.phantom) return '';
    //~ console.log('Lino.gfk_renderer',value,colIndex,record,metaData,store);
    //~ return value;
  //~ }
//~ };


Lino.build_buttons = function(panel,actions) {
  //~ console.log("20121006 Lino.build_buttons",actions);
  if (actions) {
    var buttons = Array(actions.length);
    var cmenu = Array(actions.length);
    for (var i=0; i < actions.length; i++) { 
      var a = actions[i];
      //~ buttons[i] = new Ext.Toolbar.Button(a);
      if (a.menu) a.menu = Lino.build_buttons(panel,a.menu).bbar;
      buttons[i] = a;
      cmenu[i] = {
            text : a.menu_item_text,
            iconCls : a.iconCls,
            menu : a.menu
          };
      if (a.panel_btn_handler) {
          var h = a.panel_btn_handler.createCallback(panel);
          if (a.auto_save == true) {
              h = panel.do_when_clean.createDelegate(panel,[true,h]);
          } else if (a.auto_save == null) {
              h = panel.do_when_clean.createDelegate(panel,[false,h]);
          } else if (a.auto_save == false) {
              // h = h;
          } else {
              console.log("20120703 unhandled auto_save value",a)
          }
          buttons[i].handler = h;
          cmenu[i].handler = h;
          //~ if (buttons[i].xtype == 'splitbutton') {
              //~ cmenu[i].menu = a.menu;
          //~ } else {
              //~ cmenu[i].handler = h;
          //~ }
      } else {
          cmenu[i].handler = a.handler;
      }
    }
    return {bbar:buttons, cmenu:new Ext.menu.Menu(cmenu)};
  }
}

Lino.do_when_visible = function(cmp,todo) {
  //~ if (cmp.el && cmp.el.dom) 
  if (cmp.isVisible()) { 
    // 'visible' means 'rendered and not hidden'
    console.log(cmp.title,'-> cmp is visible now');
    todo(); 
  //~ } else {
      //~ cmp.on('resize',todo,cmp,{single:true});
  //~ }
  //~ if (false) { // 20120213
  } else { 
    //~ console.log('Lino.do_when_visible() must defer because not isVisible()',todo,cmp);
    if (cmp.rendered) {
      //~ console.log(cmp,'-> cmp is rendered but not visible: and now?');
      console.log(cmp.title,'-> cmp is rendered but not visible: try again in a moment...');
      //~ var fn = function() {Lino.do_when_visible(cmp,todo)};
      //~ fn.defer(100);
      
      Lino.do_when_visible.defer(50,this,[cmp,todo]);
      //~ Lino.do_when_visible.defer(100,this,[cmp,todo]);
      
    } else {
      console.log(cmp.title,'-> after render');
      cmp.on('afterrender',todo,cmp,{single:true});
    }
  }
  
};    

/*
*/
Lino.do_on_current_record = function(panel,fn,phantom_fn) {
  var rec = panel.get_current_record();
  if (rec == undefined) {
    Lino.notify("There's no selected record.");
    return;
  }
  // 20120307 A VirtualTable with a Detail (lino.Models) has only "phantom" records.
  if (rec.phantom) {
    //~ if (!panel.editable) { console.log("20120312 not editable:",panel)}
    if (phantom_fn) {
      phantom_fn(panel);
    } else {
      Lino.notify("Action not available on phantom record.");
    }
    return;
  }
  return fn(rec);
};






Lino.call_ajax_action = function(panel,method,url,p,actionName,step,on_confirm,on_success) {
  p.an = actionName;
  if (!panel) {
      if (Lino.current_window) 
          panel = Lino.current_window.main_item;
      else panel = Lino.viewport;
  }
  //~ console.log("20130809 Lino.call_ajax_action",panel);
  Ext.apply(p,panel.get_base_params());
  
  if (panel.get_selected) {
      var selected_recs = panel.get_selected();
      //~ console.log("20130831",selected_recs);
      var rs = Array(selected_recs.length);
      for(var i=0; i < selected_recs.length;i++) {
          rs[i] = selected_recs[i].data.id;
      };
      p.sr = rs;
  }
  
  if (panel.loadMask) panel.loadMask.show(); 
  //~ p.$ext_requests.URL_PARAM_SUBST_USER = Lino.subst_user;
  //~ Lino.insert_subst_user(p);
    
  //~ if (step) p['$ext_requests.URL_PARAM_ACTION_STEP'] = step;
  //~ if (pp) pp(p); // "parameter processor" : first used for read beid card
  Ext.Ajax.request({
    method: method,
    url: url,
    params: p,
    success: Lino.action_handler(panel,on_success,on_confirm)
  });
};

Lino.row_action_handler = function(actionName,hm,pp) {
  var p = {};
  var fn = function(panel,btn,step) {
      if (pp) { p = pp(panel); if (! p) return; }
      
      if (panel.get_current_record == undefined) { // AFTER_20130725
        panel = Ext.getCmp(panel);
        if (panel == undefined) {
          Lino.notify("Invalid panel spec.");
          return;
        }
      }
      
      Lino.do_on_current_record(panel,function(rec) {
          //~ console.log(panel);
          //~ 20120723 Lino.call_ajax_action(panel,rec.id,actionName,step,fn);
          panel.add_param_values(p,true); // 20130915
          Lino.call_ajax_action(panel,hm,panel.get_record_url(rec.id),p,actionName,step,fn);
      });
  };
  return fn;
};

Lino.list_action_handler = function(ls_url,actionName,hm,pp) {
  var p = {};
  var url = '/api' + ls_url
  var fn = function(panel,btn,step) {
      //~ console.log("20121210 Lino.list_action_handler",arguments);
      //~ var url = ADMIN_URL + '/api' + panel.ls_url
      if (pp) { p = pp(panel);  if (! p) return; }
      panel.add_param_values(p,true); // 20130915
      Lino.call_ajax_action(panel,hm,url,p,actionName,step,fn);
  };
  return fn;
};

Lino.param_action_handler = function(window_action) { // 20121012
  var fn = function(panel,btn,step) {
    Lino.do_on_current_record(panel,function(rec) {
      //~ console.log(panel);
      //~ 20120723 Lino.call_ajax_action(panel,rec.id,actionName,step,fn);
      window_action.run(panel.getId(),{}); 
    });
  };
  return fn;
};


//~ 20130726 Lino.run_row_action = function(requesting_panel,url,pk,actionName,pp) {
Lino.run_row_action = function(requesting_panel,url,meth,pk,actionName,preprocessor) {
  //~ var panel = action.get_window().main_item;
  url = '/api' + url  + '/' + pk;
  var panel = Ext.getCmp(requesting_panel);
  if (preprocessor) var p = preprocessor(); else var p = {};
  var fn = function(panel,btn,step) {
    //~ 20120723 Lino.call_ajax_action(panel,pk,actionName,step,fn);
    //~ 20130726 Lino.call_ajax_action(panel,'GET',url,p,actionName,step,fn);
    Lino.call_ajax_action(panel,meth,url,p,actionName,step,fn);
  }
  fn(panel,null,null);
}



Lino.show_detail = function(panel,btn) {
  Lino.do_on_current_record(panel, 
    function(rec) {
      //~ panel.loadMask.show();
      Lino.run_detail_handler(panel,rec.id);
    },
    Lino.show_insert
  );
};

Lino.run_detail_handler = function(panel,pk) {
  var bp = panel.get_base_params();
  //~ var bp = {};
  panel.add_param_values(bp); // 20120918
  var status = {
    record_id:pk,
    base_params:bp
    //~ param_values: pv.$ext_requests.URL_PARAM_PARAM_VALUES
  }
  //~ console.log("20120918 Lino.show_detail",status);
  panel.ls_detail_handler.run(null,status);
  //~ panel.loadMask.hide();
  //~ panel.containing_window.window.hideMask();
  //~ panel.el.unmask();
}

Lino.show_fk_detail = function(combo,detail_action) {
    //~ console.log("Lino.show_fk_detail",combo,handler);
    pk = combo.getValue();
    if (pk) {
        detail_action.run(null,{record_id: pk})
      } else {
        Lino.notify("Cannot show detail for empty foreign key.");
      }
};

Lino.show_insert = function(panel,btn) {
  var bp = panel.get_base_params();
  //~ console.log('20120125 Lino.show_insert',bp)
  //~ panel.ls_insert_handler.run(null,{record_id:-99999,base_params:bp});
  panel.ls_insert_handler.run(panel.getId(),{record_id:-99999,base_params:bp});
};

//~ Lino.show_insert_duplicate = function(panel,btn) {
  //~ Lino.do_on_current_record(panel,
    //~ function(rec) {
      //~ var newRec = {};
      //~ Ext.apply(newRec,rec);
      //~ newRec.id = -99999;
      //~ panel.ls_insert_handler.run(null,{data_record:rec});
    //~ });
//~ };

//~ Lino.update_row_handler = function(action_name) {
  //~ return function(panel,btn) {
    //~ Lino.notify("Sorry, " + action_name + " is not implemented.");
  //~ }
//~ };




if (Ext.ux.grid !== undefined) {
    Lino.GridFilters = Ext.extend(Ext.ux.grid.GridFilters,{
      encode:true,
      local:false
    });
} else {
    Lino.GridFilters = function() {}; // dummy
    Ext.override(Lino.GridFilters,{
      init : function() {}
    });
};



//~ Lino.ButtonField = Ext.extend(Ext.form.TextField,{
//~ Lino.ButtonField = Ext.extend(Ext.form.Field,{
    //~ editable : false,
    //~ constructor : function(ww,config,params){
      //~ this.containing_window = ww;
      //~ if (params) Ext.apply(config,params);
      //~ Lino.ButtonField.superclass.constructor.call(this, config);
    //~ },
    //~ setButtons : function(buttons){
      //~ console.log('setButtons',buttons);
    //~ },
    //~ onRender : function(ct, position){
        //~ if(!this.el){
            //~ this.panel = new Ext.Container({items:[
              //~ {xtype:'button',text:'upload'},
              //~ {xtype:'button',text:'show'},
              //~ {xtype:'button',text:'edit'}
            //~ ]});
            //~ this.panel.ownerCt = this;
            //~ this.el = this.panel.getEl();

        //~ }
        //~ Lino.ButtonField.superclass.onRender.call(this, ct, position);
    //~ },

  
//~ });

Lino.FieldBoxMixin = {
  before_init : function(config,params) {
    if (params) Ext.apply(config,params);
    var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    if (actions) config.bbar = actions.bbar;
  },
  //~ constructor : function(ww,config,params){
    //~ this.containing_window = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  do_when_clean : function(auto_save,todo) { todo() },
  //~ format_data : function(html) { return '<div class="htmlText">' + html + '</div>' },
  format_data : function(html) { return html },
  get_base_params : function() {
    // needed for insert action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
  },
  set_base_params : function(p) {
    this.base_params = Ext.apply({},p);
    //~ if (p.param_values) this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  },
  set_base_param : function(k,v) {
    this.base_params[k] = v;
  }
};



Lino.HtmlBoxPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,{
  disabled_in_insert_window : true,
  constructor : function(config,params) {
    this.before_init(config,params);
    Lino.HtmlBoxPanel.superclass.constructor.call(this, config);
  },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.constructor.call(this, ww,config,params);
  //~ },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  //~ disable : function() { var tb = this.getBottomToolbar(); if(tb) tb.disable()},
  //~ enable : function() { var tb = this.getBottomToolbar(); if(tb) tb.enable()},
  onRender : function(ct, position){
    Lino.HtmlBoxPanel.superclass.onRender.call(this, ct, position);
    //~ console.log(20111125,this.containing_window);
    if (this.containing_panel) {
      this.containing_panel.on('enable',this.enable,this);
      this.containing_panel.on('disable',this.disable,this);
    }
    this.el.on({
      dragenter:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        return true;
      }
      ,dragover:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        event.stopEvent();
        return true;
      }
      ,drop:{
        scope:this
        ,fn:function(event){
          event.stopEvent();
          //~ console.log(20110516);
          var files = event.browserEvent.dataTransfer.files;
          if(files === undefined){
            return true;
          }
          var len = files.length;
          while(--len >= 0){
            console.log(files[len]);
            //~ this.processDragAndDropFileUpload(files[len]);
          }
          Lino.show_insert(this);
        }
      }
    });
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    //~ if (this.master_panel) {
      var record = this.containing_panel.get_current_record();
      //~ console.log('HtmlBox.refresh()',this.title,record,record.title);
      var box = this.items.get(0);
      var todo = function() {
        if (this.disabled) return;
        //~ this.set_base_params(this.containing_window.get_base_params());
        this.set_base_params(this.containing_panel.get_master_params());
        var el = box.getEl();
        if (el) {
          el.update(record ? this.format_data(record.data[this.name]) : '');
          //~ console.log('20130723 HtmlBox.refresh()',this.name);
        //~ } else {
          //~ console.log('HtmlBox.refresh() failed for',this.name);
        }
      };
      Lino.do_when_visible(box,todo.createDelegate(this));
    //~ }
  }
});
//~ Ext.override(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);



Lino.RichTextPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,Lino.FieldBoxMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,{
    
  //~ initComponent : function(){
    //~ Lino.RichTextPanel.superclass.initComponent.call(this);
  //~ },
  constructor : function(config,params) {
    //~ console.log('Lino.RichTextPanel.initComponent',this);
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + String(rec.id) + "/" + config.name;
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + config.name;
    var t = this;
    var tinymce_options = {
        theme : "advanced",
        content_css: '/media/lino/extjs/lino.css',
        language: 'en',
        //~ template_external_list_url : url,
        theme_advanced_toolbar_location : "top",
        theme_advanced_toolbar_align : "left",
        theme_advanced_statusbar_location : "bottom",
        template_popup_width : 700,
        template_popup_height : 500,
        template_replace_values : { 
            data_field : function(element){ 
                //~ console.log(20110722,fieldName,t.containing_window.get_current_record()); 
                var fieldName = element.innerHTML;
                element.innerHTML = t.containing_panel.get_current_record().data[fieldName];
            } 
        }
      };
      
    var editorConfig = {
      tinymceSettings: {
        plugins : "noneditable,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "bold,italic,underline,|,justifyleft,justifycenter,justifyright,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,removeformat,template",
        theme_advanced_buttons2 : "",
        theme_advanced_buttons3 : "", // ,|,sub,sup,|,charmap",      
        theme_advanced_resizing : false
        //~ save_onsavecallback : save_callback,
        //~ save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
        
    }};
    Ext.apply(editorConfig.tinymceSettings,tinymce_options);
    //~ editorConfig.name = config.action_name;
    editorConfig.name = config.name;
    delete config.name;
    //~ config.title = config.label;
    //~ delete config.label;
    this.before_init(config,params);
    
    this.editor = new Ext.ux.TinyMCE(editorConfig);
    var t = this;
    config.tools = [{
                      qtip: "Edit text in own window", 
                      id: "up",
                      handler: function(){
                        if(t.editor.isDirty()) {
                            var record = t.containing_panel.get_current_record();
                            record.data[t.editor.name] = t.editor.getValue();
                        }
                        Lino.edit_tinymce_text(t,tinymce_options)
                      }
                    }];
    
    config.items = this.editor;
    config.layout = "fit";
    Lino.RichTextPanel.superclass.constructor.call(this, config);
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    var record = this.containing_panel.get_current_record();
    //~ console.log('RichTextPanel.refresh()',this.title,record.title,record);
    var todo = function() {
      //~ this.set_base_params(this.containing_window.get_base_params());
      if (record) {
        var url = '/templates' + this.containing_panel.ls_url + "/" 
            + String(record.id) + "/" + this.editor.name;
        //~ console.log('RichTextPanel.refresh()',url);
        if (this.editor.ed) this.editor.ed.settings.template_external_list_url = url;
        this.set_base_params(this.containing_panel.get_master_params());
        //~ var v = record ? this.format_data(record.data[this.editor.name]) : ''
        var v = this.format_data(record.data[this.editor.name])
        this.editor.setValue(v);
      } else {
        this.editor.setValue('(no data)');
      }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
//~ Ext.override(Lino.RichTextPanel,Lino.FieldBoxMixin);



Lino.ActionFormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,Lino.PanelMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,Lino.FieldBoxMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  //~ layout:'fit'
  //~ ,autoHeight: true
  //~ ,frame: true
  window_title: "Action Parameters",
  constructor : function(config){
    config.bbar = [
        {text:'OK',handler:this.on_ok,scope:this},
        {text:'Cancel',handler:this.on_cancel,scope:this}
    ];
    //~ config.items = config.params_panel;
    Lino.ActionFormPanel.superclass.constructor.call(this, config);
  }
  //~ ,initComponent : function(){
    //~ Lino.ActionFormPanel.superclass.initComponent.call(this);
  //~ }
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
    //~ var rp = this.requesting_panel;
    //~ console.log("on_ok",this.requesting_panel,arguments);
    var panel = this.requesting_panel;
    //~ if (panel == undefined) {
        //~ Lino.alert("Sorry, dialog actions don't work without a requesting_panel");
        //~ return;
    //~ }
    //~ var rec = panel.get_current_record();
    var actionName = this.action_name;
    var pk = this.base_params.mk;
    if (pk == undefined && panel) {
        pk = panel.get_current_record().id;
    }
    if (pk == undefined) {
        Lino.alert("Sorry, dialog action without base_params.mk");
        return;
    }
    var self = this;
    function on_success() { self.get_containing_window().close(); };
    var url = '/api' + this.ls_url + '/' + pk;
    var fn = function(panel,btn,step) {
      var p = {};
      self.add_field_values(p)
      //~ Lino.call_ajax_action(panel,'GET',panel.get_record_url(rec.id),p,actionName,step,fn,on_success);
      Lino.call_ajax_action(panel,'GET',url,p,actionName,step,fn,on_success);
    }
    fn(panel,null,null);
    
    
  }
  ,set_status : function(status,rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 ActionFormPanel.set_status()',status,rp,this.requesting_panel);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_field_values(status.field_values);
    if (status.base_params) this.set_base_params(status.base_params);
  }
  
  ,add_field_values : function (p) { // similar to add_param_values()
      //~ 20121023 
      if (this.form.isDirty()) {
        p.fv = this.get_field_values();
      }else{
        if (this.status_field_values) 
          p.fv = Lino.fields2array(this.fields,this.status_field_values);
      }
      //~ if (!this.form.isDirty()) return;
      //~ p.$ext_requests.URL_PARAM_FIELD_VALUES = this.get_field_values();
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
  }
  ,get_field_values : function() {
      return Lino.fields2array(this.fields);
  }
  ,set_field_values : function(pv) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_field_values = pv;
      if (pv) this.form.my_loadRecord(pv);
      else this.form.reset(); 
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.title = this.window_title;
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok }
      ]
  }
});

//~ Lino.add_blank = function(oa) {
    //~ return [].concat(oa)
    //~ return 
    //~ }
    
Lino.fields2array = function(fields,values) {
    //~ console.log('20130605 fields2array gonna loop on', fields,values);
    var pv = Array(fields.length);
    for(var i=0; i < fields.length;i++) {
        var f = fields[i]
        if (values) 
          var v = values[f.name];
        else 
          var v = f.getValue();
        if (f.formatDate) {
            pv[i] = f.formatDate(v); 
        } else {
            pv[i] = v; // f.getValue(); 
        }
    }
    return pv;
}


Lino.FormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.FormPanel = Ext.extend(Lino.FormPanel,Lino.PanelMixin);
Lino.FormPanel = Ext.extend(Lino.FormPanel,{
  params_panel_hidden : false,
  //~ base_params : {},
  //~ trackResetOnLoad : true,
  //~ query_params : {},
  //~ 20110119b quick_search_text : '',
  constructor : function(config,params){
    if (params) Ext.apply(config,params);
    this.base_params = {};
    //~ ww.config.base_params.query = ''; // 20111018
    //~ console.log(config);
    //~ console.log('FormPanel.constructor() 1',config)
    //~ Ext.applyIf(config,{base_params:{}});
    //~ console.log('FormPanel.constructor() 2',config)
      
    config.trackResetOnLoad = true;
    
    Lino.FormPanel.superclass.constructor.call(this, config);
      
    //~ this.set_base_param('$URL_PARAM_FILTER',null); // 20111018
    //~ this.set_base_param('$URL_PARAM_FILTER',''); // 20111018
      
  },
  initComponent : function(){
    
    //~ console.log("20111201 containing_window",this.containing_window,this);
    
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    if (actions) {
        this.bbar = actions.bbar;
    //~ } else {
        //~ this.bbar = [];
    }
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ var config = this;
    
    //~ if (this.containing_window instanceof Lino.DetailWrapper) {
    
    //~ console.log('20120121 initComponent', this.action_name);
    //~ if (this.action_name == 'detail' | this.action_name == 'show') {
    //~ if (this.action_name != 'insert') {
    if (! this.hide_top_toolbar) {
      this.tbar = [];
      // 20111015    
      if (! this.hide_navigator) {
        this.record_selector = new Lino.RemoteComboFieldElement({
          store: new Lino.ComplexRemoteComboStore({
            //~ baseParams: this.containing_window.config.base_params,
            baseParams: this.get_base_params(),
            //~ value: this.containing_window.config.base_params.query,
            proxy: new Ext.data.HttpProxy({
              url: '/choices' + this.ls_url,
              method:'GET'
            })
          }),
          pageSize:25,
          listeners: { 
            scope:this, 
            select:function(combo,record,index) {
              //~ console.log('jumpto_select',arguments);
              this.goto_record_id(record.id);
            }
          },
          emptyText: "Go to record"
        })
        this.tbar = this.tbar.concat([this.record_selector]);
        
        this.tbar = this.tbar.concat([
          this.first = new Ext.Toolbar.Button({
            tooltip:"First",disabled:true,handler:this.moveFirst,scope:this,iconCls:'x-tbar-page-first'}),
          this.prev = new Ext.Toolbar.Button({
            tooltip:"Previous",disabled:true,handler:this.movePrev,scope:this,iconCls:'x-tbar-page-prev'}),
          this.next = new Ext.Toolbar.Button({
            tooltip:"Next",disabled:true,handler:this.moveNext,scope:this,iconCls:'x-tbar-page-next'}),
          this.last = new Ext.Toolbar.Button({
            tooltip:"Last",disabled:true,handler:this.moveLast,scope:this,iconCls:'x-tbar-page-last'})
        ]);
      }
      this.tbar = this.add_params_panel(this.tbar);
      
      //~ console.log(20101117,this.containing_window.refresh);
      this.tbar = this.tbar.concat([
        {
          //~ text:'Refresh',
          handler:function(){ this.do_when_clean(true,this.refresh.createDelegate(this)) },
          iconCls: 'x-tbar-loading',
          tooltip:"Reload current record",
          scope:this}
      ]);
          
      if (this.bbar) { // since 20121016
        if (this.tbar) {
            this.tbar = this.tbar.concat(['-']) ;
        } else {
          this.tbar = [];
        }
        this.tbar = this.tbar.concat(this.bbar) ;
        this.bbar = undefined;
      }
    
      this.tbar = this.tbar.concat([
          '->',
          this.displayItem = new Ext.Toolbar.TextItem({})
      ]);
          
    }
    //~ if (this.content_type && this.action_name != 'insert') {
      //~ this.bbar = this.bbar.concat([
        //~ '->',
        //~ { text: "[$_('Help Text Editor')]",
          //~ handler: Lino.help_text_editor,
          //~ qtip: "$_('Edit help texts for fields on this model.')",
          //~ scope: this}
      //~ ])
    //~ }
    //~ this.before_row_edit = config.before_row_edit.createDelegate(this);
      
    //~ if (this.master_panel) {
        //~ this.set_base_params(this.master_panel.get_master_params());
    //~ }
      
    Lino.FormPanel.superclass.initComponent.call(this);
    
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.bwrap,{msg:"Please wait..."});
    },this);
    
    
    //~ var this_ = this;
    //~ this.cascade(function(cmp){
      //~ // var active_field = false;
      //~ for (i = 0; i < this_.active_fields.length; i++) {
        //~ if (cmp.name == this_.active_fields[i]) {
            //~ // active_field = true; break;
            //~ cmp.on("change",function() {this_.save()});
        //~ }
      //~ };
      //~ if (active_field) {
      // if (cmp instanceof Lino.GridPanel) {
          //~ cmp.on("change",function() {this_.save()});
      //~ }
    //~ });
    
    if (this.action_name == 'insert') {
      this.cascade(function(cmp){
        // console.log('20110613 cascade',cmp);
        if (cmp.disabled_in_insert_window) {
            //~ cmp.disable();
            cmp.hide();
        }
      });
      
    }
    
  },
  
  unused_is_loading : function() { 
    if (this.current_record == null) {
        //~ console.log("20130515 current_record is null");
        return true; 
    }
    
    if (! this.loadMask) return true; // not even rendered: 
    if (! this.loadMask.el) return true; // not even rendered: 
    // thanks to Marco Pegoraro http://movableapp.com/2011/09/sencha-touch-loadmask-isvisible/
    var loading = (this.loadMask.el.select('.x-loading-msg').elements.length > 0);
    //~ console.log('20130515 GridPanel.is_loading() returns',loading);
    return loading;

    
    var loading = false;
    this.cascade(function(cmp){
        if (cmp instanceof Lino.GridPanel && cmp.is_loading()) {
            //~ console.log(20130515, cmp.title,'is loading');
            loading = true;
            return false;
        }
      });
    return loading;
    //~ var a = this.findByType(Lino.GridPanel);
    //~ for (i=0;i<a.length;i++) {
        //~ if (a[i].is_loading()) return true;
    //~ }
    //~ return false;
  },
  
  get_status : function(){
      var st = {
        base_params: this.get_base_params(),
        data_record : this.get_current_record()
        }
      var tp = this.items.get(0);
      if (tp instanceof Ext.TabPanel) {
        st.active_tab = tp.getActiveTab();
      }
      st.param_values = this.status_param_values;
      return st;
  },
  /* FormPanel */
  set_status : function(status,rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 FormPanel.set_status()',status);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_param_values(status.param_values);
    if (status.base_params) this.set_base_params(status.base_params);
    var tp = this.items.get(0);
    if (tp instanceof Ext.TabPanel) {
      if (status.active_tab) {
        //~ console.log('20111201 active_tab',this.active_tab,this.items.get(0));
        //~ tp.activeTab = status.active_tab;
        tp.setActiveTab(status.active_tab);
        //~ this.main_item.items.get(0).activate(status.active_tab);
      } else {
        tp.setActiveTab(0);
      }
      }
    
    if (status.data_record) {
      //~ console.log('20111201 Lino.FormPanel with data_record',this.data_record.title,this.containing_window);
      //~ this.main_item.on_master_changed.defer(2000,this.main_item,[status.data_record]);
      //~ Lino.do_when_visible(this.main_item,function(){this.on_master_changed(status.data_record)});
      //~ this.main_item.on('afterrender',function(){
      //~   this.main_item.on_master_changed(status.data_record)},this,{single:true});
      /* must defer because because set_window_title() didn't work otherwise */
      this.set_current_record.createDelegate(this,[status.data_record]).defer(100);
      //~ this.set_current_record(this.data_record);
      //~ return;
    } else if (status.record_id != undefined) { 
      /* possible values include 0 and null, 0 being a valid record id, 
      null the equivalent of undefined
      */
      //~ this.main_item.goto_record_id(this.status.record_id);
      this.load_record_id(status.record_id);
    } else {
      this.set_current_record(undefined);
    }
  },
    
  get_base_params : function() {
    // needed for insert_action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
    //~ return this.base_params;
  },
  set_base_params : function(p) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    delete p['query'] // 20120725
    Ext.apply(this.base_params,p);
    if (this.record_selector) {
        var store = this.record_selector.getStore();
        for (k in p) store.setBaseParam(k,p[k]);
        delete this.record_selector.lastQuery;
        //~ console.log("20120725 record_selector.setBaseParam",p)
    }
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
        
      //~ if (this.record_selector) {
          //~ var store = this.record_selector.getStore();
          //~ for (k in store.baseParams) store.setBaseParam(k,undefined);
          //~ delete this.record_selector.lastQuery;
          //~ console.log("20120725 record_selector.getBaseParams() -->",store.baseParams)
      //~ }
  },
  set_base_param : function(k,v) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    this.base_params[k] = v;
    //~ if (this.record_selector) {
        //~ this.record_selector.getStore().setBaseParam(k,v);
        //~ delete this.record_selector.lastQuery;
    //~ }
  },
  
  after_delete : function() {
    if (this.current_record.navinfo.next)
      this.moveNext();
    else if (this.current_record.navinfo.prev)
      this.movePrev();
    else 
      this.abandon();
  },
  moveFirst : function() {this.goto_record_id(this.current_record.navinfo.first)},
  movePrev : function() {this.goto_record_id(this.current_record.navinfo.prev)},
  moveNext : function() {this.goto_record_id(this.current_record.navinfo.next)},
  moveLast : function() {this.goto_record_id(this.current_record.navinfo.last)},
  
  
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ console.log('20120121 Lino.FormPanel.refresh()',this);
    if (this.current_record) {
        this.load_record_id(this.current_record.id,after);
    } else {
        this.set_current_record(undefined,after);
    }
  },
  
  do_when_clean : function(auto_save,todo) {
    var this_ = this;
    if (this.form.isDirty()) {
        if (auto_save) {
            this_.save(todo);
        } else {
          //~ console.log('20111217 do_when_clean() form is dirty',this.form);
          var config = {title:"Confirmation"};
          config.buttons = Ext.MessageBox.YESNOCANCEL;
          config.msg = "Save changes to current record ?";
          config.fn = function(buttonId,text,opt) {
            //~ console.log('do_when_clean',buttonId)
            if (buttonId == "yes") {
                //~ Lino.submit_detail(this_,undefined,todo);
                //~ this_.containing_window.save(todo);
                this_.save(todo);
            } else if (buttonId == "no") { 
              todo();
            }
          }
        }
        Ext.MessageBox.show(config);
    }else{
      //~ console.log('do_when_clean : now!')
      todo();
    }
  },
  
  goto_record_id : function(record_id) {
    //~ console.log('20110701 Lino.FormPanel.goto_record_id()',record_id);
    //~ var this_ = this;
    //~ this.do_when_clean(function() { this_.load_record_id(record_id) }
    this.do_when_clean(true,this.load_record_id.createDelegate(this,[record_id]));
  },
  
  load_record_id : function(record_id,after) {
    var this_ = this;
    //~ var p = { fmt: this.containing_window.config.action_name};
    //~ var p = Ext.apply({},this.containing_window.config.base_params);
    var p = Ext.apply({},this.get_base_params());
    //~ Lino.insert_subst_user(p);
    //~ console.log('20110713 action_name=',this.containing_window.config.action_name,
      //~ 'base_params=',this.containing_window.config.base_params);
    if (this.action_name)
        p.an = this.action_name;
    //~ p.an = this.action_name;
    //~ p.an = this.containing_window.config.action_name;
    //~ p.fmt = 'json';
    //~ p.fmt = '$ext_requests.URL_FORMAT_JSON';
    p.rp = this.getId();
    //~ p.$ext_requests.URL_PARAM_SUBST_USER = Lino.subst_user;
    p.fmt = 'json';
    //~ 20110119b p['$URL_PARAM_FILTER'] = this.quick_search_text;
    //~ Ext.apply(p,this.query_params);
    this.add_param_values(p);
    //~ console.log('20121120 FormPanel.load_record_id',record_id,p);
    if (this.loadMask) this.loadMask.show();
    Ext.Ajax.request({ 
      waitMsg: 'Loading record...',
      method: 'GET',
      params: p,
      scope: this,
      url: this.get_record_url(record_id),
      success: function(response) {   
        // todo: convert to Lino.action_handler.... but result 
        if (this.loadMask) this.loadMask.hide();
        if (response.responseText) {
          var rec = Ext.decode(response.responseText);
          //~ console.log('20120918 goto_record_id success',rec);
          this.set_param_values(rec.param_values);
          this.set_current_record(rec,after);
        }
      },
      failure: Lino.ajax_error_handler(this)
    });
  },

  abandon : function () {
    Ext.MessageBox.alert('Note',
      "No more records to display. Detail window has been closed.");
    Lino.close_window();
    //~ if (this.containing_window) {
        //~ this.containing_window.hide();
    //~ }
  },
  
  set_current_record : function(record,after) {
    //~ console.log('20120722 Lino.FormPanel.set_current_record',record.title,record);
    if (this.record_selector) {
        this.record_selector.clearValue();
        // e.g. InsertWrapper FormPanel doesn't have a record_selector
    }
    this.current_record = record;
    //~ if (record) 
        //~ console.log('Lino.FormPanel.set_current_record',record.title,record);
    //~ else
        //~ console.log('Lino.FormPanel.set_current_record',record);
    //~ this.config.main_panel.form.load(record);    
    if (record) {
      this.enable();
      this.form.my_loadRecord(record.data);
      this.set_window_title(record.title);
      //~ this.getBottomToolbar().enable();
      var da = record.data.disabled_actions;
      if (da) {
          //~ console.log('20120528 disabled_actions =',da,this.getBottomToolbar());
          //~ 20121016 this.getBottomToolbar().items.each(function(item,index,length){
          var tb = this.getTopToolbar();
          if (tb) tb.items.each(function(item,index,length){
              //~ console.log('20120528 ',item.itemId,'-->',da[item.itemId]);
              if (da[item.itemId]) item.disable(); else item.enable();
          });
      };
      if (this.disable_editing | record.data.disable_editing) {
          //~ console.log("20120202 disable_editing",record.title);
          this.form.items.each(function(cmp){
            if (!cmp.always_enabled) cmp.disable();
          },this);
      } else {
          this.form.items.each(function(cmp){
            //~ console.log("20120202",cmp);
            if (record.data.disabled_fields[cmp.name]) cmp.disable();
            else cmp.enable();
          },this);
        
          //~ if (record.data.disabled_fields) {
              //~ for (i = 0; i < record.data.disabled_fields.length; i++) {
                  //~ var flds = this.find('name',record.data.disabled_fields[i]);
                  //~ if (flds.length == 1) { 
                    //~ flds[0].disable(); 
                  //~ }
              //~ }
          //~ }
      };
      if (this.first) {
        if (record.navinfo  && ! this.hide_navigator) {
          this.first.setDisabled(!record.navinfo.first);
          this.prev.setDisabled(!record.navinfo.prev);
          this.next.setDisabled(!record.navinfo.next);
          this.last.setDisabled(!record.navinfo.last);
          this.displayItem.setText(record.navinfo.message);
        } else {
          this.first.setDisabled(true);
          this.prev.setDisabled(true);
          this.next.setDisabled(true);
          this.last.setDisabled(true);
        }
      }
    } else {
      if (this.form.rendered) 
        this.form.reset(); /* FileUploadField would fail when resetting a non-rendered form */
      //~ this.disable();
      //~ this.getBottomToolbar().disable();
      this.form.items.each(function(cmp){
        cmp.disable();
      },this);
      this.set_window_title(this.empty_title);
      //~ this.containing_window.window.setTitle(this.empty_title);
      if (!this.hide_navigator) {
        this.first.disable();
        this.prev.disable();
        this.next.disable();
        this.last.disable();
      }
    }
    //~ console.log('20100531 Lino.DetailMixin.on_load_master_record',this.main_form);
    this.before_row_edit(record);
    if (after) after();
  },
  
  before_row_edit : function(record) {},
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.refresh();
  },
  
  get_selected : function() { return [ this.current_record ] },
  get_current_record : function() {  
    //~ console.log(20100714,this.current_record);
    return this.current_record 
  },
  
  get_permalink_url : function() {
      var rec = this.get_current_record();
      if (rec && ! rec.phantom && rec.id != -99998)
          return '/api' + this.ls_url + '/' + rec.id;
      return '/api' + this.ls_url;
    
  },
  get_permalink_params : function() {
    var p = {};
    //~ var p = {an:'detail'};
    if (this.action_name)
        p.an = this.action_name;
    //~ var p = {an:this.action_name};
    var main = this.items.get(0);
    if (main.activeTab) {
      var tab = main.items.indexOf(main.activeTab);
      //~ console.log('main.activeTab',tab,main.activeTab);
      if (tab) p.tab = tab;
    }
    this.add_param_values(p)
    return p;
  },
  
  /* 
  Lino.FormPanel.save() 
  */
  save : function(after,switch_to_detail,action_name) {
    //~ var panel = this;
    //~ console.log('20121120 FormPanel.save');
    this.loadMask.show();
    var rec = this.get_current_record();
    if (this.has_file_upload) this.form.fileUpload = true;
    //~ console.log('FormPanel.save()',rec);
    if (!action_name) action_name = this.action_name;
    if (rec) {
      var p = {};
      Ext.apply(p,this.get_base_params());
      p.rp = this.getId();
      //~ if (this.action_name) 
          //~ p.$ext_requests.URL_PARAM_ACTION_NAME = this.action_name;
      p.an = action_name;
      if (rec.phantom) {
        //~ if (this.action_name != 'insert') 
            //~ console.log("Warning: phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: '/api' + this.ls_url,
          method: 'POST',
          params: p, 
          scope: this,
          success: function(form, action) {
            this.loadMask.hide();
            Lino.notify(action.result.message);
            /***
            Close this window, but update the status of the 
            calling window.
            If the calling window is a detail on the same table,
            then it should skip to the new record. But only then.
            A successful response usually has a data_record,
            except if it is a fileupload form where some mysterious 
            decoding problems (20120209) force us to return a record_id 
            which will lead to an additional GET.
            ***/
            var url = this.ls_url;
            var ww = Lino.calling_window();
            if (ww && ww.window.main_item instanceof Lino.FormPanel 
                   && ww.window.main_item.ls_url == this.ls_url) {
                //~ console.log("20120217 case 1");
                ww.status.record_id = action.result.record_id;
                ww.status.data_record = action.result.data_record;
                Lino.close_window();
            } else if (this.ls_detail_handler && switch_to_detail) {
                //~ console.log("20120217 case 2");
                Lino.kill_current_window();
                this.ls_detail_handler.run(null,{
                    record_id:action.result.record_id,
                    data_record: action.result.data_record,
                    base_params:this.get_base_params()
                });
            } else {
                //~ console.log("20120217 case 3");
                Lino.close_window();
            }
            //~ Lino.close_window(function(ww){
                //~ if (ww.window.main_item instanceof Lino.FormPanel 
                    //~ && ww.window.main_item.ls_url == url) {
                  //~ ww.status.record_id = action.result.record_id,
                  //~ ww.status.data_record = action.result.data_record
                //~ }
            //~ });
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action);
          },
          clientValidation: true
        })
      } else {
        //~ if (this.action_name != 'detail') 
            //~ console.log("Warning: non-phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: '/api' + this.ls_url + '/' + rec.id,
          method: 'PUT',
          //~ headers: { 'HTTP_X_REQUESTED_WITH' : 'XMLHttpRequest'},
          scope: this,
          params: p, 
          success: function(form, action) {
            //~ panel.form.setValues(rec.data);
            //~ 20110701 panel.form.my_loadRecord(rec);
            this.loadMask.hide();
            Lino.notify(action.result.message);
            if (action.result.data_record)
                this.set_current_record(action.result.data_record,after);
            else
                console.log("Warning: no data_record in response to FormPanel.PUT")
            //~ this.refresh_with_after(after);
            //~ if (after) after(); else panel.refresh();
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action)},
          clientValidation: true
        })
      }
    } else Lino.notify("Sorry, no current record.");
  }
  
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
      this.save(null,true);
      //~ var rec = this.get_current_record();
      //~ if (rec && rec.phantom)
          //~ this.do_when_clean(true,function() { Lino.close_window(); });
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok, scope:this }
        ,{ key: Ext.EventObject.ESCAPE, fn: this.on_cancel, scope:this }
      ]
  }
  
  
  /* not used (no longer possible without .dtl files)
  , edit_detail_config : function () {
    var active_tab = {};
    var main = this.items.get(0);
    if (main.getActiveTab !== undefined) {
      var tabitem = main.getActiveTab();
      Ext.apply(active_tab,{$ext_requests.URL_PARAM_TAB : main.items.indexOf(tabitem)});
    }
    var editor = new Ext.form.TextArea();
    var close = function() { win.close(); }
    var _this = this;
    var save = function() { 
      //~ console.log(20110609,arguments); 
      var params = {desc: editor.getValue()};
      Ext.apply(params,active_tab);
      var a = { 
        params: params, 
        method: 'PUT',
        url: ADMIN_URL + '/detail_config' + _this.ls_url,
        failure : Lino.ajax_error_handler(this),
        success: Lino.action_handler( _this, function(result) {
          //~ console.log('detail_config/save success',result);
          win.close();
          document.location = _this.get_permalink();
        })
      };
      //~ console.log('detail_config/save sent',a);
      _this.loadMask.show(); // 20120211
      Ext.Ajax.request(a);
    }
    var save_btn = new Ext.Button({text:'Save',handler:save,disabled:true});
    var win = new Ext.Window({title:'Detail Layout',
      items:editor, layout:'fit',
      width:500,height:500,
      bbar:[{text:'Cancel',handler:close},save_btn]});
    var a = { 
      params:active_tab, 
      method:'GET',
      url:ADMIN_URL+'/detail_config'+_this.ls_url,
      success : function(response) {
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          if (result.success) {
            editor.setValue(result.desc);
            save_btn.enable();
          }
        }
      }
    };
    Ext.Ajax.request(a);
    win.show();
  }
  */
});



Lino.getRowClass = function(record, rowIndex, rowParams, store) {
    //~ console.log(20130816,record);
    //~ return 'x-grid3-row-green';
    return record.data.row_class;
  //~ if (true) {
      //~ return 'x-grid3-row-red';
  //~ }
  //~ if (record.phantom) {
    //~ console.log(20101009,record);
    //~ rowParams.bodyStyle = "color:red;background-color:blue";
    //~ return 'lino-phantom-row';
    //~ }
  //~ console.log('20101009 not a phantom:',record);
  //~ return '';
}

//~ FOO = 0;



Lino.GridStore = Ext.extend(Ext.data.ArrayStore,{ 
  autoLoad: false
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
    if (!options) options = {};
    if (!options.params) options.params = {};
    options.params.fmt = 'json';
    options.params.rp = this.grid_panel.getId();
    Lino.insert_subst_user(options.params); // since 20121016
      
    if (this.grid_panel.hide_top_toolbar) {
        //~ console.log("20120206 GridStore.load() toolbar is hidden");
        options.params.start = 0;
        if (this.grid_panel.preview_limit) {
          options.params.limit = this.grid_panel.preview_limit;
        }
    } else {
        var ps = this.grid_panel.calculatePageSize();
        if (!ps) {
            //~ this.gridpanel.on('render',this.load())
          //~ console.log("20120814 GridStore.load() failed to calculate pagesize");
          return false;
            //~ params.$URL_PARAM_LIMIT = 1;
            //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
            //~ return;
        } 
        options.params.limit = ps;
      
        //~ options.params.start = this.grid_panel.getTopToolbar().cursor;
        //~ if (this.grid_panel.getTopToolbar().pageSize !=  ps) {
          //~ console.log("20120206 abort load because toolbar says pagesize",
            //~ this.grid_panel.getTopToolbar().pageSize,
            //~ "while actual pagesize is",ps);
            //~ return;
        //~ }
        
        this.grid_panel.getTopToolbar().pageSize =  ps;
        if (options.params.start == undefined)
            options.params.start = this.grid_panel.getTopToolbar().cursor;
      
    }
      
    this.grid_panel.add_param_values(options.params,true);
    //~ Lino.insert_subst_user(options.params);
    //~ console.log("20120814 GridStore.load()",options.params,this.baseParams);
    //~ if (FOO > 0) {
        //~ foo.bar = baz;
    //~ } else FOO += 1;
    return Lino.GridStore.superclass.load.call(this,options);
  }
});

Lino.get_current_grid_config = function(panel) {
    return panel.get_current_grid_config();
}

Lino.GridPanel = Ext.extend(Ext.grid.EditorGridPanel,Lino.MainPanel);
Lino.GridPanel = Ext.extend(Lino.GridPanel,Lino.PanelMixin);
Lino.GridPanel = Ext.extend(Lino.GridPanel,{
  quick_search_text : '',
  is_searching : false,
  disabled_in_insert_window : true,
  clicksToEdit:2,
  enableColLock: false,
  autoHeight: false,
  params_panel_hidden : false,
  preview_limit : undefined, 
  //~ loadMask: true,
  //~ viewConfig: {
          //~ getRowClass: Lino.getRowClass,
          //~ emptyText:"$_('No data to display.')"
        //~ },
  loadMask: {msg:"Please wait..."},
  
  constructor : function(config){

    config.plugins = [new Lino.GridFilters()];
    
    
    Lino.GridPanel.superclass.constructor.call(this,config);
    
    //~ if (this.containing_window) {
        //~ console.log("20111206 install refresh");
        //~ this.containing_window.on('show',this.refresh,this);
    //~ }
    
  },
  
  unused_is_loading : function() { 
    if (! this.loadMask.el) return true; // not even rendered: 
    // thanks to Marco Pegoraro http://movableapp.com/2011/09/sencha-touch-loadmask-isvisible/
    var loading = (this.loadMask.el.select('.x-loading-msg').elements.length > 0);
    //~ console.log('20130515 GridPanel.is_loading() returns',loading);
    return loading;
    //~ return this.store.getCount() > 0; 
    //~ return (this.loadMask.el.select('.x-loading-msg').elements.length)
    //~ return !this.viewReady; 
    //~ return this.loadMask.isVisible(); 
    //~ return !this.loadMask.disabled; 
  },
  
  unused_config_containing_window : function(wincfg) { 
      //~ temporarily remove save_grid_config button (see /blog(2012/1107)
      if (wincfg.tools != undefined) 
        wincfg.tools = [
          //~ {handler:this.save_grid_data,
            //~ qtip:"$_("Save Grid Data")",
            //~ scope:this, id:"save_data"}, // 20120814
          {handler:this.save_grid_config,
            qtip:"Save Grid Configuration",
            scope:this, id:"save"}
        ].concat(wincfg.tools);
      //~ wincfg.listeners = { show: ... };
  },
  init_containing_window : function(win) { 
    //~ console.log("20111206 install refresh");
    //~ win.on('show',this.refresh,this);
  },
  
  initComponent : function(){
    
    /* 
    Problem 20111206:
    When a GridPanel is the main item of the window, then it doesn't 
    have it's own header but uses the window's header bar.
    We must do this in initComponent because e.g. in beforerender 
    it's already to late: a header element has been created because 
    there was a title.
    But Lino.Window adds itself as `this.containing_window` 
    only after the GridPanel has been initialized.
    Workaround is to generate a line "params.containing_window = true;" 
    in the handler function.
    */ 
    //~ if (this.containing_window) {
    if (this.is_main_window) {
        //~ console.log(20111206, 'delete title',this.title,'from',this);
        //~ delete this.title;
        this.tools = undefined;  
        this.title = undefined;  /* simply deleting it 
          isn't enough because that would only 
          unhide the title defined in some base class. */
    } 
    //~ else console.log(20111206, 'dont delete title',this.title,'from',this);
    
    /* e.g. when slave gridwindow called from a permalink */
    //~ if (this.base_params) Ext.apply(bp,this.base_params);  
    //~ bp['fmt'] = 'json';
    
    //~ function on_proxy_write( proxy, action,data, response,rs,options) {
      //~ console.log('20120814 on_proxy_write',action,data,response)
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
    //~ }
    //~ function on_proxy_load( proxy, transactionObject, callbackOptions ) {
      //~ console.log('on_proxy_load',transactionObject)
    //~ }
    var proxy = new Ext.data.HttpProxy({ 
      // 20120814 
      url: '/api' + this.ls_url
      ,method: "GET"
      //~ ,url: ADMIN_URL + '/restful' + this.ls_url
      //~ ,restful: true 
      //~ ,listeners: {load:on_proxy_load} 
      //~ ,listeners: {write:on_proxy_write} 
    });
    //~ config.store = new Ext.data.JsonStore({ 
    //~ this.store = new Ext.data.ArrayStore({ 
    this.store = new Lino.GridStore({ 
      grid_panel: this
      ,listeners: { exception: Lino.on_store_exception }
      ,remoteSort: true
      ,totalProperty: "count"
      ,root: "rows"
      //~ ,id: "id" 
      ,proxy: proxy
      //~ autoLoad: this.containing_window ? true : false
      ,idIndex: this.pk_index
      //~ ,baseParams: bp
      ,fields: this.ls_store_fields
      ,idProperty: this.ls_id_property 
      // 20120814
      //~ ,writer : new Ext.data.JsonWriter({
        //~ writeAllFields: false
        //~ ,listful: true
      //~ })
      //~ ,restful : true
    });
      
    //~ console.log('config.pk_index',config.pk_index,config.store),
    delete this.ls_store_fields;
      
    var this_ = this;
    //~ var grid = this;
    this.store.on('load', function() {
        //~ console.log('20120814 GridStore.on(load)',this_.store);
        //~ var da = this_.store.reader.arrayData.disabled_actions;
        //~ if (da) {
            //~ this.cmenu.cascade(function(item){ 
              //~ console.log(20120531, item.itemId, da[item.itemId]);
              //~ if (da[item.itemId]) item.disable(); else item.enable();
            //~ });
        //~ };
        this_.set_param_values(this_.store.reader.arrayData.param_values);
        //~ this_.set_status(this_.store.reader.arrayData.status);
        //~ 20120918
        this.getView().getRowClass = Lino.getRowClass;
        if (this_.store.reader.arrayData.no_data_text) {
            //~ this.viewConfig.emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().refresh();
        }
        if (this_.containing_window)
            this_.set_window_title(this_.store.reader.arrayData.title);
            //~ this_.containing_window.setTitle(this_.store.reader.arrayData.title);
        if (!this.is_searching) { // disabled 20121025: quick_search_field may not lose focus
          this.is_searching = false;
          if (this_.selModel.getSelectedCell){
              if (this_.getStore().getCount()) // there may be no data
                  this_.selModel.select(0,0); 
          } else {
              this_.selModel.selectFirstRow();
              this_.getView().focusEl.focus();
          }
        } 
        //~ else console.log("is_searching -> no focussing");
        //~ var t = this.getTopToolbar();
        //~ var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
        //~ this.quick_search_field.focus(); // 20121024
      }, this
    );
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar, this.cmenu = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ this.cmenu = new Ext.menu.Menu({items: config.bbar});
    delete this.ls_bbar_actions
    if (actions) {
        this.cmenu = actions.cmenu;
    }
    
    if (!this.hide_top_toolbar) {  
      var tbar = [ 
        this.quick_search_field = new Ext.form.TextField({ 
          //~ fieldLabel: "Search"
          listeners: { 
            scope:this_
            //~ ,change:this_.search_change
            
            ,render: Lino.quicktip_renderer("Quick Search","Enter a text to use as quick search filter")
            
            //~ ,keypress: this.search_keypress 
            ,blur: function() { this.is_searching = false}
          }
          ,validator:function(value) { return this_.search_validate(value) }
          //~ ,tooltip: "Enter a quick search text, then press TAB"
          //~ value: text
          //~ scope:this, 
          //~ ,enableKeyEvents: true
          //~ listeners: { keypress: this.search_keypress }, 
          //~ id: "seachString" 
      })];
      tbar = this.add_params_panel(tbar);
      tbar = tbar.concat([
        { scope:this, 
          //~ text: "[csv]", 
          tooltip: "Export this table to a .csv file", 
          iconCls: 'x-tbar-csv',
          handler: function() { 
            //~ 20130116 var p = Ext.apply({},this.get_base_params());
            //~ 20130116 p.fmt = 'csv';
            //~ url += "?" + Ext.urlEncode(p);
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            p.fmt = "csv";
            this.add_param_values(p,true);
            
            window.open('/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } },
        //~ { scope:this, 
          //~ text: "[html]", 
          //~ handler: function() { 
            //~ var p = this.get_current_grid_config();
            //~ Ext.apply(p,this.get_base_params());
            //~ p.$ext_requests.URL_PARAM_FORMAT = "$ext_requests.URL_FORMAT_PRINTER";
            //~ this.add_param_values(p);
            //~ window.open(ADMIN_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          //~ } },
        { scope:this, 
          //~ text: "[html]", 
          tooltip: "Show this table in plain html", 
          iconCls: 'x-tbar-html',
          handler: function() { 
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            //~ since 20121226 p.$ext_requests.URL_PARAM_FORMAT = "$ext_requests.URL_FORMAT_PLAIN";
            this.add_param_values(p,true);
            //~ since 20121226 window.open(ADMIN_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
            window.open('plain'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } }
        
      ]);
    
    
      var menu = [];
      var set_gc = function(index) {
        return function() {
          //~ console.log('set_gc() 20100812');
          this.getColumnModel().setConfig(
              this.apply_grid_config(index,this.ls_grid_configs,this.ls_columns));
        }
      }
      for (var i = 0; i < this.ls_grid_configs.length;i++) {
        var gc = this.ls_grid_configs[i];
        menu.push({text:gc.label,handler:set_gc(i),scope:this})
      }
      if(menu.length > 1) {
        tbar = tbar.concat([
          { text:"View",
            menu: menu,
            tooltip:"Select another view of this report"
          }
        ]);
      }
      
      if (actions) {
        tbar = tbar.concat(actions.bbar);
          //~ this.bbar = actions.bbar;
      }
      
      this.tbar = new Ext.PagingToolbar({ 
        store: this.store, 
        prependButtons: true, 
        //~ pageSize: this.page_length, 
        pageSize: 1, 
        displayInfo: true, 
        beforePageText: "Page",
        afterPageText: "of {0}",
        displayMsg: "Displaying {0} - {1} of {2}",
        firstText: "First page",
        lastText: "Last page",
        prevText: "Previous page",
        nextText: "Next page",
        items: tbar
      });
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ var ps = this.calculatePageSize();
          //~ if (ps && ps != this.getTopToolbar().pageSize) {
              //~ // console.log('20120203 resize : pageSize',this.getTopToolbar().pageSize,'->',ps);
              //~ // this.getTopToolbar().pageSize =  ps;
              //~ cmp.refresh();
              //~ // this.getTopToolbar().doRefresh();
          //~ }
        //~ }, this);
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ cmp.getTopToolbar().pageSize = this.calculatePageSize(aw,ah,rw,rh) || 10;
          //~ cmp.refresh();
        //~ }, this, {delay:500});
    }
    
    //~ delete this.page_length
    
    
      
    if (this.cell_edit) {
      this.selModel = new Ext.grid.CellSelectionModel()
      this.get_selected = function() {
        //~ console.log(this.getSelectionModel().selection);
        if (this.selModel.selection)
            return [ this.selModel.selection.record ];
        return [this.store.getAt(0)];
      };
      this.get_current_record = function() { 
        if (this.getSelectionModel().selection) 
          return this.selModel.selection.record;
        return this.store.getAt(0);
      };
    } else { 
      this.selModel = new Ext.grid.RowSelectionModel() 
      this.get_selected = function() {
        var sels = this.selModel.getSelections();
        if (sels.length == 0) sels = [this.store.getAt(0)];
        return sels
        //~ var sels = this.getSelectionModel().getSelections();
        //~ return Ext.pluck(sels,'id');
      };
      this.get_current_record = function() { 
        var rec = this.selModel.getSelected();
        if (rec == undefined) rec = this.store.getAt(0);
        return rec
      };
    };
    delete this.cell_edit;
    
    this.columns  = this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns);
    
    //~ var grid = this;
    //~ this.colModel = new Ext.grid.ColumnModel({
      //~ columns: this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns),
      //~ isCellEditable: function(col, row) {
        //~ var record = grid.store.getAt(row);
        //~ console.log('20120514',col,record); // dataIndex
        //~ var dataIndex = grid.colModel.getDataIndex(col);
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("$_("This field is disabled")");
            //~ return false;
        //~ }
        //~ return Ext.grid.ColumnModel.prototype.isCellEditable.call(this, col, row);
      //~ }
    //~ });    
    
    
    Lino.GridPanel.superclass.initComponent.call(this);
    
    //~ if (this.containing_window) 
        //~ this.on('afterlayout', this.refresh, this);
        //~ this.on('afterrender', this.refresh,this);
    //~ else
        //~ this.on('show', this.refresh,this);
    //~ this.on('afterlayout', function() {
      //~ if (this.id == "ext-comp-1157") 
        //~ console.log("20120213 afterlayout",this); 
      //~ // this.refresh();
      //~ },this);
    //~ this.on('afterrender', this.refresh);
    //~ this.on('resize', this.refresh,this,{delay:500});
    //~ this.on('resize', function(){console.log("20120213 resize",arguments)},this);
    this.on('resize', function(){
      //~ console.log("20120213 resize",arguments)
      this.refresh();
      },this);
    this.on('viewready', function(){
      //~ console.log("20120213 resize",arguments);
      this.view_is_ready = true;
      this.refresh(); // removed 20130911
      },this);
    this.on('afteredit', this.on_afteredit); // 20120814
    //~ this.on('afteredit', this.new_on_afteredit);
    this.on('beforeedit', this.on_beforeedit);
    this.on('beforeedit',function(e) { this.before_row_edit(e.record)},this);
    this.on('cellcontextmenu', Lino.cell_context_menu, this);
    //~ this.on('contextmenu', Lino.grid_context_menu, this);
    
    
    //~ if (this.id == "ext-comp-1157") captureEvents(this);    
    
  },
  
  //~ onResize : function(){
      //~ console.log("20120206 GridPanel.onResize",arguments);
      //~ Lino.GridPanel.superclass.onResize.apply(this, arguments);
      //~ this.refresh();
  //~ },
  
  
  get_status : function(){
    var st = { base_params : this.get_base_params()};
    if (!this.hide_top_toolbar) {
        st.current_page = this.getTopToolbar().current;
    }
    st.param_values = this.status_param_values;
    //~ console.log("20120213 GridPanel.get_status",st);
    return st;
  },
  
  /* 
  Lino.GridPanel.set_status() 
  */
  set_status : function(status){
    //~ console.log("20130605 GridPanel.set_status",status);
    this.clear_base_params();
    if (status == undefined) status = {};
    this.set_param_values(status.param_values);
    if (status.base_params) { 
      this.set_base_params(status.base_params);
    }
    if (status.show_params_panel != undefined) {
        if (this.toggle_params_panel_btn) {
            //~ this.toggle_params_panel_btn.toggle(status.show_params_panel=='true');
            this.toggle_params_panel_btn.toggle(status.show_params_panel);
        }
    }
    if (!this.hide_top_toolbar) {
      //~ console.log("20120213 GridPanel.getTopToolbar().changePage",
          //~ status.current_page || 1);
      this.getTopToolbar().changePage(status.current_page || 1);
    }
    //~ this.fireEvent('resize');
    //~ this.refresh.defer(100,this); 
    //~ this.onResize.defer(100,this); 
    //~ this.refresh(); 
    //~ this.doLayout(); 
    //~ this.onResize(); 
    //~ this.store.load();
  },
  
  refresh : function(unused) { 
    this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ Lino.notify('Lino.GridPanel.refresh '+this.store.proxy.url);
    //~ var bp = { fmt:'json' }
    if (! this.view_is_ready) return;
    
    if (this.containing_panel) {
        //~ Ext.apply(p,this.master_panel.get_master_params());
        //~ Ext.apply(options.params,this.containing_panel.get_master_params());
        this.set_base_params(this.containing_panel.get_master_params());
        // 20130911
        if (!this.store.baseParams.mk) {  
            return;
        }
    }
    
    
    //~ console.log('20130911 Lino.GridPanel.refresh_with_after',this.containing_panel.get_master_params());
    
    var options = {};
    if (after) {
        options.callback = function(r,options,success) {if(success) after()}
    }
      
    //~ if (!this.rendered) {
        //~ console.log("20120206 GridPanel.refresh() must wait until rendered",options);
        //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
        //~ return;
    //~ }
    
    this.store.load(options);
  },
  
  /* pageSize depends on grid height (Trying to remove scrollbar)
  Thanks to 
  - Christophe Badoit on http://www.sencha.com/forum/showthread.php?82647
  - http://www.sencha.com/forum/archive/index.php/t-37231.html
  */
  calculatePageSize : function(second_attempt) {
    //~ if (!this.rendered) { 
    if (!this.view_is_ready) { 
      //~ console.log('Cannot calculatePageSize() : not rendered');
      return false; }
    //~ if (!this.isVisible()) { 
      //~ console.log('calculatePageSize : not visible');
      //~ return false; }
      
    //~ console.log('getFrameHeight() is',this.getFrameHeight());
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('mainBody.getHeight() is',this.getView().mainBody.getHeight());
    //~ console.log('getInnerHeight() is',this.getInnerHeight());
    //~ console.log('getHeight() is',this.getHeight());
    //~ console.log('el.getHeight() is',this.getEl().getHeight());
    //~ console.log('getGridEl().getHeight() is',this.getGridEl().getHeight());
    //~ console.log('getOuterSize().height is',this.getOuterSize().height);
    //~ console.log('getBox().height is',this.getBox().height);
    //~ console.log('getResizeEl.getHeight() is',this.getResizeEl().getHeight());
    //~ console.log('getLayoutTarget().getHeight() is',this.getLayoutTarget().getHeight());
      
    //~ var rowHeight = 52; // experimental value
    var row = this.view.getRow(0);
    if (row) {
      //~ console.log('20120213 yes');
      var rowHeight = Ext.get(row).getHeight();
    } else {
        //~ var rowHeight = this.getFrameHeight();
        //~ var rowHeight = 10; // reasonably smallest approximative value
        //~ There is no data yet. Construct a fake row and get its height
        var Element = Ext.Element;
        var gv = this.view;
        var fakeBody = new Element(Element.fly(gv.scroller).child('div.x-grid3-body'));
        var rowTemplate = gv.templates.row;
        var cellTemplate = gv.templates.cell;
        var tstyle  = 'width:' + gv.getGridInnerWidth() + 'px;';
        var cells = cellTemplate.apply({value:'&#160;'});
        var markup = rowTemplate.apply({
                tstyle: tstyle,
                cols  : 1,
                cells : cells,
                alt   : ''
            });        
        fakeBody.dom.innerHTML = gv.templates.body.apply({rows: markup});
        var row = fakeBody.dom.childNodes[0];
        var rowHeight = Ext.get(row).getHeight();
    }
    //~ console.log('rowHeight is ',rowHeight,this,caller);
    //~ this.getView().syncScroll();
    //~ this.getView().initTemplates();
    var height = this.getView().scroller.getHeight();
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('getInnerHeight() - getFrameHeight() is',
      //~ this.getInnerHeight(), '-',
      //~ this.getFrameHeight(), '=',
      //~ this.getInnerHeight() - this.getFrameHeight());
    //~ var height = this.getView().mainBody.getHeight();
    //~ var height = this.getView().mainWrap.getHeight();
    //~ var height = this.getView().resizeMarker.getHeight();
    //~ this.syncSize();
    //~ var height = this.getInnerHeight() - this.getFrameHeight();
    //~ var height = this.getHeight() - this.getFrameHeight();
    height -= Ext.getScrollBarWidth(); // leave room for a possible horizontal scrollbar... 
    //~ height -= this.getView().scrollOffset;
    var ps = Math.floor(height / rowHeight);
    //~ console.log('20130816 calculatePageSize():',height,'/',rowHeight,'->',ps);
    ps -= 1; // leave room for a possible phantom row
    //~ return (ps > 1 ? ps : false);
    if (ps > 1) return ps;
    //~ console.log('calculatePageSize() found less than 1 row:',height,'/',rowHeight,'->',ps);
    //~ foo.bar = baz; // 20120213
    return 5; // preview_limit
    //~ if (second_attempt) {
        //~ console.log('calculatePageSize() abandons after second attempt:',
          //~ height,'/',rowHeight,'->',ps);
      //~ return 5;
    //~ }
    //~ return this.calculatePageSize.defer(500,this,[true]);
  },
  
  onCellDblClick : function(grid, row, col){
      //~ console.log("20120307 onCellDblClick",this,grid, row, col);
      if (this.ls_detail_handler) {
          //~ Lino.notify('show detail');
          Lino.show_detail(this);
          return false;
      }else{
        //~ console.log('startEditing');
        this.startEditing(row,col);
      }
  },
  
  get_base_params : function() {
    //~ return this.containing_window.config.base_params;
    //~ console.log(20120717,this.store.baseParams);
    var p = Ext.apply({},this.store.baseParams);
    Lino.insert_subst_user(p);
    //~ console.log("20120717 GRidPanel.get_base_params() returns",p);
    return p;
    //~ return this.store.baseParams;
  },
  set_base_params : function(p) {
    //~ console.log('20130911 GridPanel.set_base_params',p)
    for (k in p) this.store.setBaseParam(k,p[k]);
    //~ this.store.baseParams = p;
    if (p.query) 
        this.quick_search_field.setValue(p.query);
    //~ if (p.param_values) 
        //~ this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.store.baseParams = {};
      Lino.insert_subst_user(this.store.baseParams);
  },
  set_base_param : function(k,v) {
    this.store.setBaseParam(k,v);
  },
  
  //~ get_permalink_params : function() {
    //~ var p = {};
    //~ return p;
  //~ },
  
  before_row_edit : function(record) {},
    
  //~ search_keypress : function(){
    //~ console.log("2012124 search_keypress",arguments);
  //~ },
  search_validate : function(value) {
    if (value == this.quick_search_text) return true;
    this.is_searching = true;
    //~ console.log('search_validate',value)
    this.quick_search_text = value;
    this.set_base_param('query',value); 
    //~ this.getTopToolbar().changePage(1);
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
    return true;
  },
  
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
  },
  
  apply_grid_config : function(index,grid_configs,rpt_columns) {
    //~ var rpt_columns = this.ls_columns;
    var gc = grid_configs[index];    
    //~ console.log('apply_grid_config() 20100812',name,gc);
    this.gc_name = index;
    if (gc == undefined) {
      return rpt_columns;
      //~ config.columns = config.ls_columns;
      //~ return;
    } 
    //~ delete config.ls_filters
    
    //~ console.log(20100805,config.ls_columns);
    var columns = Array(gc.columns.length);
    for (var j = 0; j < rpt_columns.length;j++) {
      var col = rpt_columns[j];
      for (var i = 0; i < gc.columns.length; i++) {
        if (col.dataIndex == gc.ci[i]) {
          col.width = gc.cw[i];
          col.hidden = gc.ch[i];
          columns[i] = col;
          break;
        }
      }
    }
    
    //~ var columns = Array(rpt_columns.length);
    //~ for (var i = 0; i < rpt_columns.length; i++) {
      //~ columns[i] = rpt_columns[gc.columns[i]];
      //~ columns[i].width = gc.widths[i];
    //~ }
    
    //~ if (gc.hidden_cols) {
      //~ for (var i = 0; i < gc.hidden_cols.length; i++) {
        //~ var hc = gc.hidden_cols[i];
        //~ for (var j = 0; j < columns.length;j++) {
          //~ var col = columns[j];
          //~ if (col.dataIndex == hc) {
            //~ col.hidden = true;
            //~ break
          //~ }
        //~ }
      //~ }
    //~ }
    if (gc.filters) {
      //~ console.log(20100811,'config.ls_filters',config.ls_filters);
      //~ console.log(20100811,'config.ls_grid_config.filters',config.ls_grid_config.filters);
      for (var i = 0; i < gc.filters.length; i++) {
        var fv = gc.filters[i];
        for (var j = 0; j < columns.length;j++) {
          var col = columns[j];
          if (col.dataIndex == fv.field) {
            //~ console.log(20100811, f,' == ',fv);
            if (fv.type == 'string') {
              col.filter.value = fv.value;
              //~ if (fv.comparison !== undefined) f.comparison = fv.comparison;
            } else {
              //~ console.log(20100811, fv);
              col.filter.value = {};
              col.filter.value[fv.comparison] = fv.value;
            }
            break;
          }
        };
      }
    }
    
    return columns;
    //~ config.columns = cols;
    //~ delete config.ls_columns
  },
  
  get_current_grid_config : function () {
    var cm = this.getColumnModel();
    var widths = Array(cm.config.length);
    var hiddens = Array(cm.config.length);
    //~ var hiddens = Array(cm.config.length);
    var columns = Array(cm.config.length);
    //~ var columns = Array(cm.config.length);
    //~ var hidden_cols = [];
    //~ var filters = this.filters.getFilterValues();
    var p = this.filters.buildQuery(this.filters.getFilterData())
    for (var i = 0; i < cm.config.length; i++) {
      var col = cm.config[i];
      columns[i] = col.dataIndex;
      //~ hiddens[i] = col.hidden;
      widths[i] = col.width;
      hiddens[i] = col.hidden;
      //~ if (col.hidden) hidden_cols.push(col.dataIndex);
    }
    //~ p['hidden_cols'] = hidden_cols;
    p.cw = widths;
    p.ch = hiddens;
    p.ci = columns;
    //~ p['widths'] = widths;
    //~ p['hiddens'] = hiddens;
    //~ p['columns'] = columns;
    p['name'] = this.gc_name;
    //~ var gc = this.ls_grid_configs[this.gc_name];
    //~ if (gc !== undefined) 
        //~ p['label'] = gc.label
    //~ console.log('20100810 save_grid_config',p);
    return p;
  },
  
  unused_manage_grid_configs : function() {
    var data = [];
    for (k in this.ls_grid_configs) {
      var v = this.ls_grid_configs[k];
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i)
    }
    if (this.ls_grid_configs[this.gc_name] == undefined) {
      var v = this.get_current_grid_config();
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i);
    }
    //~ console.log(20100811, data);
    var main = new Ext.grid.GridPanel({
      store: new Ext.data.ArrayStore({
        idIndex:0,
        fields:['name','columns','hidden_cols','filters'],
        autoDestroy:true,
        data: data}),
      //~ autoHeight:true,
      selModel: new Ext.grid.RowSelectionModel(),
      listeners: { 
        rowdblclick: function(grid,rowIndex,e) {
          console.log('row doubleclicked',grid, rowIndex,e);
        },
        rowclick: function(grid,rowIndex,e) {
          console.log('row clicked',grid, rowIndex,e);
        }
      },
      columns: [ 
        {dataIndex:'name',header:'Name'}, 
        {dataIndex:'columns',header:'columns'}, 
        {dataIndex:'hidden_cols',header:'hidden columns'}, 
        {dataIndex:'filters',header:'filters'} 
      ]
    });
    var win = new Ext.Window({title:'GridConfigs Manager',layout:'fit',items:main,height:200});
    win.show();
  },
  
  unused_edit_grid_config : function(name) {
    gc = this.ls_grid_configs[name];
    var win = new Ext.Window({
      title:'Edit Grid Config',layout:'vbox', 
      //~ layoutConfig:'stretch'
      items:[
        {xtype:'text', value: gc.name},
        {xtype:'text', value: gc.columns},
        {xtype:'text', value: gc.hidden_cols},
        {xtype:'text', value: gc.filters}
      ]
    });
    win.show();
  },
  
  save_grid_config : function () {
    //~ console.log('TODO: save_grid_config',this);
    //~ p.column_widths = Ext.pluck(this.colModel.columns,'width');
    var a = { 
      params:this.get_current_grid_config(), 
      method:'PUT',
      url:'/grid_config' + this.ls_url,
      success: Lino.action_handler(this),
      scope: this,
      failure: Lino.ajax_error_handler(this)
    };
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(a);
    //~ Lino.do_action(this,a);
  },
  
  on_beforeedit : function(e) {
    //~ console.log('20130128 GridPanel.on_beforeedit()',e,e.record.data.disable_editing);
    if(this.disable_editing | e.record.data.disable_editing) {
      e.cancel = true;
      Lino.notify("This record is disabled");
      return;
    }
    if(e.record.data.disabled_fields && e.record.data.disabled_fields[e.field]) {
      e.cancel = true;
      Lino.notify("This field is disabled");
      return;
    }
    //~ if (e.record.data.disabled_fields) {
      //~ for (i in e.record.data.disabled_fields) {
        //~ if(e.record.data.disabled_fields[i] == e.field) {
          //~ e.cancel = true;
          //~ Lino.notify(String.format('Field "{0}" is disabled for this record',e.field));
          //~ return
        //~ }
      //~ }
    //~ }
  },
  save_grid_data : function() {
      //~ console.log("20120814 save_grid_data");
      this.getStore().commitChanges();
  },
  new_on_afteredit : function(e) {
      //~ this.getStore().commitChanges();
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
      console.log("20120814 new_on_afteredit",e);
  },
  on_afteredit : function(e) {
    /*
    e.grid - The grid that fired the event
    e.record - The record being edited
    e.field - The field name being edited
    e.value - The value being set
    e.originalValue - The original value for the field, before the edit.
    e.row - The grid row index
    e.column - The grid column index
    */
    var p = {};
    //~ console.log('20101130 modified: ',e.record.modified);
    //~ console.log('20101130 value: ',e.value);
    //~ var p = e.record.getChanges();
    //~ console.log('20101130 getChanges: ',e.record.getChanges());
    //~ this.before_row_edit(e.record);
    for(k in e.record.getChanges()) {
        var v = e.record.get(k);
    //~ for(k in e.record.modified) {
        //~ console.log('20101130',k,'=',v);
        //~ var cm = e.grid.getColumnModel();
        //~ var di = cm.getDataIndex(k);
        var f = e.record.fields.get(k);
        //~ console.log('20101130 f = ',f);
        //~ var v = e.record.get(di);
        if (f.type.type == 'date') {
            p[k] = Ext.util.Format.date(v, f.dateFormat);
        }else{
            p[k] = v;
            var v = e.record.get(k+'Hidden');
            if (v !== undefined) {
              p[k+'Hidden'] = v;
            }
        }
        //~ var i = cm.findColumnIndex(k);
        //~ var r = cm.getRenderer(i);
        //~ var editor = cm.getCellEditor(i,e.row);
        //~ var col = e.grid.getColumnModel().getColumnById(k);
        //~ console.log('20101130 r = ',r(v));
        //~ var f = e.record.fields[k];
        //~ console.log('20101130 f = ',f);
        //~ console.log('20101130 editor = ',editor);
        //~ p[k] = f.getValue();
        //~ p[k] = r(v);
    }
    //~ console.log('20101130 p:',p);
    //~ var cm = e.grid.getColumnModel();
    //~ var di = cm.getDataIndex(e.column);
    //~ var f = e.record.fields.get(di);
    //~ console.log('20101130 f = ',f);
    //~ if (f.type.type == 'date') e.record.set(di,Ext.util.Format.date(e.value, f.dateFormat));
    
    
    //~ var p = e.record.data;
    
    // var p = {};
    //~ p['grid_afteredit_colname'] = e.field;
    //~ p[e.field] = e.value;
    //~ console.log('20100723 GridPanel.on_afteredit()',e);
    // add value used by ForeignKeyStoreField CHOICES_HIDDEN_SUFFIX
    // not sure whether this is still needed:
    p[e.field+'Hidden'] = e.value;
    //~ p.su = Lino.subst_user;
    Lino.insert_subst_user(p);
    // this one is needed so that this field can serve as choice context:
    e.record.data[e.field+'Hidden'] = e.value;
    // p[pk] = e.record.data[pk];
    // console.log("grid_afteredit:",e.field,'=',e.value);
    Ext.apply(p,this.get_base_params()); // needed for POST, ignored for PUT
    //~ Ext.apply(p,this.containing_window.config.base_params);
    //~ 20121109 p['$ext_requests.URL_PARAM_ACTION_NAME'] = 'grid';
    var self = this;
    var req = {
        params:p,
        waitMsg: 'Saving your data...',
        success: Lino.action_handler( this, function(result) {
          //~ if (result.data_record) {
          if (result.refresh_all) {
              var cw = self.get_containing_window();
              if (cw) {
                  cw.main_item.refresh();
              }
              else console.log("20120123 cannot refresh_all",self);
          } else if (result.rows) {
              //~ self.getStore().loadData(result,true);
              var r = self.getStore().reader.readRecords(result);
              if (e.record.phantom) {
                  //~ console.log("20120816 afteredit.success POST",r);
                  self.getStore().insert(e.row,r.records);
              }else{
                  //~ console.log("20120816 afteredit.success PUT",r);
                  self.getStore().doUpdate(r.records[0]);
              }
              self.getStore().rejectChanges(); /* 
              get rid of the red triangles without saving the record again
              */
              //~ self.getStore().commitChanges(); // get rid of the red triangles
          } else {
              self.getStore().commitChanges(); // get rid of the red triangles
              self.getStore().reload();        // reload our datastore.
          }
          }),
        scope: this,
        failure: Lino.ajax_error_handler(this)
    };
    if (e.record.phantom) {
      req.params.an = 'post'; // SubmitInsert.action_name
      Ext.apply(req,{
        method: 'POST',
        url: '/api' + this.ls_url
      });
    } else {
      req.params.an = 'put'; // SubmitDetail.action_name
      Ext.apply(req,{
        method: 'PUT',
        url: '/api' + this.ls_url + '/' + e.record.id
      });
    }
    //~ console.log('20110406 on_afteredit',req);
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(req);
  },

  afterRender : function() {
    Lino.GridPanel.superclass.afterRender.call(this);
    // this.getView().mainBody.focus();
    // console.log(20100114,this.getView().getRows());
    // if (this.getView().getRows().length > 0) {
    //  this.getView().focusRow(1);
    // }
    //~ this.my_load_mask = new Ext.LoadMask(this.getEl(), {
        //~ msg:'$_("Please wait...")',
        //~ store:this.store});
      
    var tbar = this.getTopToolbar();
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    // tbar.on('change',function() {this.getSelectionModel().selectFirstRow();this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    this.nav = new Ext.KeyNav(this.getEl(),{
      pageUp: function() {tbar.movePrevious(); },
      pageDown: function() {tbar.moveNext(); },
      home: function() {tbar.moveFirst(); },
      end: function() {tbar.moveLast(); },
      scope: this
    });
  },
  after_delete : function() {
    //~ console.log('Lino.GridPanel.after_delete');
    this.refresh();
  },
  add_row_listener : function(fn,scope) {
    this.getSelectionModel().addListener('rowselect',fn,scope);
  },
  postEditValue : function(value, originalValue, r, field){
    value = Lino.GridPanel.superclass.postEditValue.call(this,value,originalValue,r,field);
    //~ console.log('GridPanel.postEdit()',value, originalValue, r, field);
    return value;
  },
  
  set_start_value : function(v) {
      this.start_value = v;
  },
  preEditValue : function(r, field){
      if (this.start_value) {
        var v = this.start_value;
        delete this.start_value;
        this.activeEditor.selectOnFocus = false;
        return v;
      }
      var value = r.data[field];
      return this.autoEncode && Ext.isString(value) ? Ext.util.Format.htmlDecode(value) : value;
  },
  
  on_master_changed : function() {
    //~ if (! this.enabled) return;
    //~ cmp = this;
    //~ console.log('20130911 Lino.GridPanel.on_master_changed()',this.title,this.rendered);
    if (! this.rendered) return; // 20120213
    var todo = function() {
      if (this.disabled) return;
      //~ if (this.disabled) return;
      //~ if (this.enabled) {
          //~ var src = caller.config.url_data + "/" + record.id + ".jpg"
          //~ console.log(20111125, this.containing_window);
          //~ for (k in p) this.getStore().setBaseParam(k,p[k]);
          //~ console.log('Lino.GridPanel.on_master_changed()',this.title,p);
          this.refresh();
          //~ this.set_base_params(this.master_panel.get_master_params());
          //~ this.getStore().load(); 
      //~ }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  },
  load_record_id : function(record_id,after) {
      Lino.run_detail_handler(this,record_id)
  }
  
});
  

//~ Lino.MainPanelMixin = {
  //~ tbar_items : function() {
      //~ return ;
  //~ }
//~ };

//~ Ext.override(Lino.GridPanel,Lino.MainPanelMixin);
//~ Ext.override(Lino.FormPanel,Lino.MainPanelMixin);

//~ Lino.grid_context_menu = function(e) {
  //~ console.log('contextmenu',arguments);
//~ }

Lino.cell_context_menu = function(grid,row,col,e) {
  //~ console.log('20120531 cellcontextmenu',grid,row,col,e,grid.store.reader.arrayData.rows[row]);
  e.stopEvent();
  //~ grid.getView().focusCell(row,col);
  grid.getSelectionModel().select(row,col);
  //~ console.log(grid.store.getAt(row));
  //~ grid.getView().focusRow(row);
  //~ return;
  if(!grid.cmenu.el){grid.cmenu.render(); }
  //~ if(e.record.data.disabled_fields) {
  
  var da = grid.store.reader.arrayData.rows[row][grid.disabled_actions_index];
  if (da) {
      this.cmenu.cascade(function(item){ 
        //~ console.log(20120531, item.itemId, da[item.itemId]);
        if (da[item.itemId]) item.disable(); else item.enable();
      });
  };
  
  var xy = e.getXY();
  xy[1] -= grid.cmenu.el.getHeight();
  grid.cmenu.showAt(xy);
}


//~ Lino.load_main_menu = function() {
  //~ Ext.Ajax.request({
    //~ waitMsg: 'Loading main menu...',
    //~ method: 'GET',
    //~ url: '/menu',
    //~ success: Lino.on_load_menu,
    //~ failure: Lino.ajax_error_handler
  //~ });
//~ };



//~ Lino.SlavePlugin = function(caller) {
  //~ this.caller = caller;
//~ };

Lino.chooser_handler = function(combo,name) {
  return function(cmp,newValue,oldValue) {
    //~ console.log('Lino.chooser_handler()',cmp,oldValue,newValue);
    combo.setContextValue(name,newValue);
  }
};



Lino.ComboBox = Ext.extend(Ext.form.ComboBox,{
  forceSelection: true,
  triggerAction: 'all',
  minListWidth:230,
  autoSelect: false,
  selectOnFocus: true, // select any existing text in the field immediately on focus.
  submitValue: true,
  displayField: 'text', // 'text', 
  valueField: 'value', // 'value',
  
  //~ initComponent : Ext.form.ComboBox.prototype.initComponent.createSequence(function() {
  initComponent : function(){
      this.contextParams = {};
      //~ Ext.form.ComboBox.initComponent(this);
      Lino.ComboBox.superclass.initComponent.call(this);
  },
  setValue : function(v,record_data){
      /*
      Based on feature request developed in http://extjs.net/forum/showthread.php?t=75751
      */
      /* `record_data` is used to get the text corresponding to this value */
      //~ if(this.name == 'city') 
      //~ console.log('20120203', this.name,'.setValue(', v ,') this=', this,'record_data=',record_data);
      var text = v;
      if(this.valueField){
        if(v == null || v == '') { 
            //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,'no lookup needed, value is empty');
            //~ v = undefined;
            v = '';
            //~ text = '';
        } else if (Ext.isDefined(record_data)) {
          text = record_data[this.name];
          //~ if (this.name == 'birth_country') 
            //~ console.log(this.name,'.setValue',v,'got text ',text,' from record ',record);
        } else {
          // if(this.mode == 'remote' && !Ext.isDefined(this.store.totalLength)){
          if(this.mode == 'remote' && ( this.lastQuery === null || (!Ext.isDefined(this.store.totalLength)))){
              //~ if (this.name == 'birth_country') console.log(this.name,'.setValue',v,'store not yet loaded');
              this.store.on('load', this.setValue.createDelegate(this, arguments), null, {single: true});
              if(this.store.lastOptions === null || this.lastQuery === null){
                  var params;
                  if(this.valueParam){
                      params = {};
                      params[this.valueParam] = v;
                  }else{
                      var q = this.allQuery;
                      this.lastQuery = q;
                      this.store.setBaseParam(this.queryParam, q);
                      params = this.getParams(q);
                  }
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : call load() with params ',params);
                  this.store.load({params: params});
              //~ }else{
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : but store is loading',this.store.lastOptions);
              }
              return;
          //~ }else{
              //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,' : store is loaded, lastQuery is "',this.lastQuery,'"');
          }
          var r = this.findRecord(this.valueField, v);
          if(r){
              text = r.data[this.displayField];
          }else if(this.valueNotFoundText !== undefined){
              text = this.valueNotFoundText;
          }
        }
      }
      this.lastSelectionText = text;
      //~ this.lastSelectionText = v;
      if(this.hiddenField){
          //~ this.hiddenField.originalValue = v;
          this.hiddenField.value = v;
      }
      Ext.form.ComboBox.superclass.setValue.call(this, text);
      this.value = v; // needed for grid.afteredit
  },
  
  getParams : function(q){
    // p = Ext.form.ComboBox.superclass.getParams.call(this, q);
    // causes "Ext.form.ComboBox.superclass.getParams is undefined"
    var p = {};
    //p[this.queryParam] = q;
    if(this.pageSize){
        //~ p.start = 0;
        //~ p.limit = this.pageSize;
        p['start'] = 0;
        p['limit'] = this.pageSize;
    }
    // now my code:
    if(this.contextParams) Ext.apply(p,this.contextParams);
    //~ if(this.contextParams && this.contextValues) {
      //~ for(i = 0; i <= this.contextParams.length; i++)
        //~ p[this.contextParams[i]] = this.contextValues[i];
    //~ }
    return p;
  },
  setContextValue : function(name,value) {
    //~ console.log('setContextValue',this,this.name,':',name,'=',value);
    //~ if (this.contextValues === undefined) {
        //~ this.contextValues = Array(); // this.contextParams.length);
    //~ }
    if (this.contextParams[name] != value) {
      //~ console.log('setContextValue 1',this.contextParams);
      this.contextParams[name] = value;
      this.lastQuery = null;
      //~ console.log('setContextValue 2',this.contextParams);
    }
  }
});

Lino.ChoicesFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'local'
});


Lino.SimpleRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  forceSelection: true,
  constructor: function(config){
      Lino.SimpleRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value' ], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.ComplexRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  constructor: function(config){
      Lino.ComplexRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value','text'], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.RemoteComboFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'remote',
  //~ forceSelection:false,
  minChars: 2, // default 4 is too much
  queryDelay: 300, // default 500 is maybe slow
  queryParam: 'query', 
  //~ typeAhead: true,
  //~ selectOnFocus: true, // select any existing text in the field immediately on focus.
  resizable: true
});

/*
Thanks to Animal for posting the basic idea:
http://www.sencha.com/forum/showthread.php?15842-2.0-SOLVED-Combobox-twintrigger-clear&p=76130&viewfull=1#post76130

*/
Lino.TwinCombo = Ext.extend(Lino.RemoteComboFieldElement,{
    trigger2Class : 'x-form-search-trigger',
    //~ trigger2Class : 'x-tbar-detail',
    initComponent : function() {
        //~ Lino.TwinCombo.superclass.initComponent.call(this);
        Lino.ComboBox.prototype.initComponent.call(this);
        Ext.form.TwinTriggerField.prototype.initComponent.call(this);
    },
    onTrigger2Click : function() {
        //~ console.log('onTrigger2Click',this,arguments);
    }
  });
//~ Lino.TwinCombo.prototype.initComponent = Ext.form.TwinTriggerField.prototype.initComponent;
Lino.TwinCombo.prototype.getTrigger = Ext.form.TwinTriggerField.prototype.getTrigger;
Lino.TwinCombo.prototype.getOuterSize = Ext.form.TwinTriggerField.prototype.getOuterSize;
Lino.TwinCombo.prototype.initTrigger = Ext.form.TwinTriggerField.prototype.initTrigger;
Lino.TwinCombo.prototype.onTrigger1Click = Ext.form.ComboBox.prototype.onTriggerClick;
//~ Lino.TwinCombo.prototype.onTrigger2Click = function() {
    //~ console.log('onTrigger2Click',arguments);
//~ };



Lino.SimpleRemoteComboFieldElement = Ext.extend(Lino.RemoteComboFieldElement,{
  displayField: 'value', 
  valueField: null,
  forceSelection: false
});




Lino.Window = Ext.extend(Ext.Window,{
  //~ layout: "fit", 
  closeAction : 'hide',
  renderTo: 'main_area', 
  constrain: true,
  maximized: true,
  draggable: false,
  width: 700,
  height: 500,
  maximizable: false,
  constructor : function (config) {
    if (config.main_item.params_panel) {
        config.layout = 'border';
        config.main_item.region = 'center';
        config.main_item.params_panel.region = 'north';
        config.main_item.params_panel.hidden = config.main_item.params_panel_hidden;
        config.items = [config.main_item.params_panel, config.main_item];
    } else {
        config.layout = 'fit';
        config.items = config.main_item;
    }
    this.main_item = config.main_item; 
    
    delete config.main_item;
    //~ delete config.params_item;
    
    //~ this.main_item = config.items.get(0);
    this.main_item.containing_window = this;
    
    //~ console.log('20120110 Lino.Window.constructor() 1');
    //~ if (Lino.current_window) { // all windows except the top are closable
    if (this.main_item.hide_window_title) { 
      config.closable = false;
      config.frame = false;
      config.shadow = false;
      //~ config.border = true;
      //~ config.title = undefined;
      //~ config.tools = null;
      delete config.title;
      delete config.tools;
    } else {
      config.title = this.main_item.empty_title;
      config.closable = true;
      config.tools = [ 
        { qtip: 'permalink', handler: Lino.permalink_handler(this), id: "pin" }
      ];
      if (this.main_item.content_type && this.main_item.action_name != 'insert') {
        config.tools = [ {
          handler: Lino.help_text_editor,
          qtip: "Edit help texts for fields on this model.",
          scope: this.main_item,
          id: "gear"
        }].concat(config.tools);
      }
        
    //~ { qtip: '', handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: this.config.qtip, handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: 'Call doLayout() on main Container.', handler: Lino.refresh_handler(this), id: "refresh" },
    //~ if (this.main_item.params_panel) {
        //~ config.tools = config.tools.concat([ 
          //~ { qtip: 'Show/hide parameter panel', handler: this.toggle_params_panel, id: "gear", scope:this } 
        //~ ]);
    //~ }
    //~ if (config.closable !== false) {
      // if undefined, will take default behaviour
      //~ config.tools = config.tools.concat([ 
        //~ { qtip: 'close', handler: this.hide, id: "close", scope:this } 
      //~ ]);
    }
    
    this.main_item.config_containing_window(config);
    
    //~ console.log('20120110 Lino.Window.constructor() 2');
    Lino.Window.superclass.constructor.call(this,config);
    
    //~ console.log('20120110 Lino.Window.constructor() 3');
    
  },
  initComponent : function() {
    this.main_item.init_containing_window(this);
    Lino.Window.superclass.initComponent.call(this);
  
  },
  hide : function() { 
      this.main_item.do_when_clean(false,function() { 
        Lino.close_window(); });
  },
  hide_really : function() { 
    Lino.Window.superclass.hide.call(this);
  },
  onRender : function(ct, position){
    //~ console.log('20120110 Lino.Window.onRender() 1');
    Lino.Window.superclass.onRender.call(this, ct, position);
    var main_area = Ext.getCmp('main_area')
    //~ console.log('20120110 Lino.Window.onRender() 2');
  
    this.on('show', function(win) {
        //~ console.log('20120110 Lino.Window.on show 1');
        main_area.on('resize', win.onWindowResize, win);
    });
    this.on('hide', function(win) {
        main_area.un('resize', win.onWindowResize, win);
    });
    //~ console.log('20120110 Lino.Window.onRender() 3');
  }
});


Lino.unused_ParamWindow = Ext.extend(Lino.Window,{
  //~ layout: "border", 
  constructor : function (config) {
    Lino.ParamWindow.superclass.constructor.call(this,config);
    this.main_item = config.items; // `items` must be a single component
    config.layout = 'border';
    this.main_item.region = 'center';
    config.params.region = 'north';
    config.items = [config.params, config.items];
    //~ delete config.params;
  }
});




(function(){
    var ns = Ext.ns('Ext.ux.plugins');

    /**
     * @class Ext.ux.plugins.DefaultButton
     * @extends Object
     *
     * Plugin for Button that will click() the button if the user presses ENTER while
     * a component in the button's form has focus.
     *
     * @author Stephen Friedrich
     * @date 09-DEC-2009
     * @version 0.1
     *
     */
    ns.DefaultButton =  Ext.extend(Object, {
        init: function(button) {
            button.on('afterRender', setupKeyListener, button);
        }
    });

    function setupKeyListener() {
        var formPanel = this.findParentByType('form');
        new Ext.KeyMap(formPanel.el, {
            key: Ext.EventObject.ENTER,
            shift: false,
            alt: false,
            fn: function(keyCode, e){
                if(e.target.type === 'textarea' && !e.ctrlKey) {
                    return true;
                }

                this.el.select('button').item(0).dom.click();
                return false;
            },
            scope: this
        });
    }

    Ext.ComponentMgr.registerPlugin('defaultButton', ns.DefaultButton);

})(); 

Ext.override(Ext.form.BasicForm,{
    my_loadRecord : function(values){
    //~ loadRecord : function(record){
        /* Same as ExtJS's loadRecord() (setValues()), except that we 
        forward also the record to field.setValue() so that Lino.Combobox 
        can use it. 
        */
        //~ console.log('20120918 my_loadRecord',values)
        if(Ext.isArray(values)){ 
            for(var i = 0, len = values.length; i < len; i++){
                var v = values[i];
                var f = this.findField(v.id);
                if(f){
                    f.setValue(v.value,values);
                    if(this.trackResetOnLoad){
                        f.originalValue = f.getValue();
                    }
                }
            }
        }else{ 
            var field, id;
            for(id in values){
                if(!Ext.isFunction(values[id]) && (field = this.findField(id))){
                    field.setValue(values[id],values);
                    if(this.trackResetOnLoad){
                        field.originalValue = field.getValue();
                        //~ if (field.hiddenField) {
                          //~ field.hiddenField.originalValue = field.hiddenField.value;
                        //~ }
                    }
                }
            }
        }
        return this;
    }
});




function initializeFooBarDropZone(cmp) {
    //~ console.log('initializeFooBarDropZone',cmp);
    cmp.dropTarget = new Ext.dd.DropTarget(cmp.bwrap, {
      //~ ddGroup     : 'gridDDGroup',
      notifyEnter : function(ddSource, e, data) {
        console.log('notifyEnter',ddSource,e,data);
        //Add some flare to invite drop.
        cmp.body.stopFx();
        cmp.body.highlight();
      },
      notifyDrop  : function(ddSource, e, data){
        console.log('notifyDrop',ddSource,e,data);
        // Reference the record (single selection) for readability
        //~ var selectedRecord = ddSource.dragData.selections[0];


        // Load the record into the form
        //~ formPanel.getForm().my_loadRecord(selectedRecord);


        // Delete record from the grid.  not really required.
        //~ ddSource.grid.store.remove(selectedRecord);

        return(true);
      }
    })
}



Lino.show_mti_child = function(fieldname,detail_handler) {
  //~ console.log('show_mti_child',this);
  //~ console.log('show_mti_child',panel.find("main_area"));
  rec = Lino.current_window.main_item.get_current_record();
  //~ rec = panel.get_current_record();
  if (rec) {
    //~ console.log('show_mti_child',Lino.current_window,rec);
    if (rec.phantom) {
      Lino.notify('Not allowed on phantom record.');
    }else if (rec.data[fieldname]) {
      //~ console.log('show_mti_child',rec.id);
      //~ detail_handler(Lino.current_window.main_item,{},{record_id:rec.id});
      detail_handler.run(null,{record_id:rec.id});
      //~ window.open(urlroot + '/' + rec.id);
      //~ document.location = urlroot + '/' + rec.id;
      //~ window.open(urlroot + '/' + rec.id,'_blank');
    } else {
      Lino.alert("Cannot show MTI child if checkbox is off.");
    }
  } else {
    Lino.notify('No current record.');
  }
};





/*
captureEvents utility by Aaron Conran
<http://www.sencha.com/learn/grid-faq/>

Ext.onReady(function(){
    var grid = new Ext.grid.GridPanel({
        ... 
    });
    captureEvents(grid);
});
*/
function captureEvents(observable) {
    Ext.util.Observable.capture(
        observable,
        function(eventName) {
            console.info(eventName);
        },
        this
    );		
}
 






Lino.main_menu = [ { "menu": { "items": [ { "text": "Persons", "handler": function() {Lino.contacts.Persons.grid.run(null)} }, { "text": "Companies", "handler": function() {Lino.contacts.Companies.grid.run(null)} }, { "text": "Partners", "handler": function() {Lino.contacts.Partners.grid.run(null)} } ] }, "text": "Contacts" }, { "menu": { "items": [ { "text": "Products", "handler": function() {Lino.products.Products.grid.run(null)} }, { "text": "Product Categories", "handler": function() {Lino.products.ProductCats.grid.run(null)} } ] }, "text": "Products" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "My Text Field Templates", "handler": function() {Lino.system.MyTextFieldTemplates.grid.run(null)} }, { "text": "Nodes", "handler": function() {Lino.pages.Pages.grid.run(null)} } ] }, "text": "Office" }, { "menu": { "items": [ { "text": "Site Parameters", "iconCls": "x-tbar-application_form", "handler": function() {Lino.system.SiteConfigs.detail.run(null,{ "record_id": 1 })} }, { "text": "Users", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows the list of all users on this site.") }, "handler": function() {Lino.users.Users.grid.run(null)} }, { "text": "Teams", "handler": function() {Lino.users.Teams.grid.run(null)} }, { "text": "content types", "handler": function() {Lino.system.ContentTypes.grid.run(null)} }, { "text": "Help Texts", "handler": function() {Lino.system.HelpTexts.grid.run(null)} } ] }, "text": "System" }, { "menu": { "items": [ { "text": "Countries", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    A country is a geographic entity considered a \"nation\".\n    ") }, "handler": function() {Lino.countries.Countries.grid.run(null)} }, { "text": "Places", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    The table of known geographical places.\n    A geographical place can be a city, a town, a suburb, \n    a province, a lake... any named geographic entity,\n    except for countries because these have their own table.\n    ") }, "handler": function() {Lino.countries.Cities.grid.run(null)} }, { "text": "company types", "handler": function() {Lino.contacts.CompanyTypes.grid.run(null)} }, { "text": "Functions", "handler": function() {Lino.contacts.RoleTypes.grid.run(null)} } ] }, "text": "Contacts" }, { "menu": { "items": [ { "text": "Account Charts", "handler": function() {Lino.accounts.Charts.grid.run(null)} }, { "text": "Account Groups", "handler": function() {Lino.accounts.Groups.grid.run(null)} }, { "text": "Accounts", "handler": function() {Lino.accounts.Accounts.grid.run(null)} }, { "text": "Journals", "handler": function() {Lino.ledger.Journals.grid.run(null)} } ] }, "text": "Accounting" }, { "menu": { "items": [ { "text": "Invoicing Modes", "handler": function() {Lino.sales.InvoicingModes.grid.run(null)} }, { "text": "Shipping Modes", "handler": function() {Lino.sales.ShippingModes.grid.run(null)} }, { "text": "Payment Terms", "handler": function() {Lino.sales.PaymentTerms.grid.run(null)} } ] }, "text": "Sales" } ] }, "text": "Configure" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "Text Field Templates", "handler": function() {Lino.system.TextFieldTemplates.grid.run(null)} } ] }, "text": "Office" }, { "menu": { "items": [ { "text": "Authorities", "handler": function() {Lino.users.Authorities.grid.run(null)} }, { "text": "User Groups", "handler": function() {Lino.lino.UserGroups.grid.run(null)} }, { "text": "User Levels", "handler": function() {Lino.lino.UserLevels.grid.run(null)} }, { "text": "User Profiles", "handler": function() {Lino.lino.UserProfiles.grid.run(null)} } ] }, "text": "System" }, { "menu": { "items": [ { "text": "Contact Persons", "handler": function() {Lino.contacts.Roles.grid.run(null)} } ] }, "text": "Contacts" }, { "menu": { "items": [ { "text": "Invoices", "handler": function() {Lino.ledger.Invoices.grid.run(null)} }, { "text": "Vouchers", "handler": function() {Lino.ledger.Vouchers.grid.run(null)} }, { "text": "VoucherTypes", "handler": function() {Lino.ledger.VoucherTypes.grid.run(null)} }, { "text": "Movements", "handler": function() {Lino.ledger.Movements.grid.run(null)} }, { "text": "Fiscal Years", "handler": function() {Lino.ledger.FiscalYears.grid.run(null)} } ] }, "text": "Accounting" }, { "menu": { "items": [ { "text": "VatRegimes", "listeners": { "render": Lino.quicktip_renderer("Foo","Determines how the VAT is being handled, i.e. whether and how it is to be paid.") }, "handler": function() {Lino.vat.VatRegimes.grid.run(null)} }, { "text": "TradeTypes", "listeners": { "render": Lino.quicktip_renderer("Foo","The type of trade: usually either `sales` or `purchases`.") }, "handler": function() {Lino.vat.TradeTypes.grid.run(null)} }, { "text": "VatClasses", "handler": function() {Lino.vat.VatClasses.grid.run(null)} }, { "text": "VAT declarations", "handler": function() {Lino.declarations.Declarations.grid.run(null)} } ] }, "text": "VAT" } ] }, "text": "Explorer" }, { "menu": { "items": [ { "text": "About", "listeners": { "render": Lino.quicktip_renderer("Foo","Show information about this site.") }, "handler": function() {Lino.about.About.show.run(null,{ "record_id": -99998 })} } ] }, "text": "Site" }, { "text": "Home", "handler": function() {Lino.close_all_windows()} } ];
Ext.namespace('Lino.system.SiteConfigs')
Ext.namespace('Lino.system.ContentTypes')
Ext.namespace('Lino.system.HelpTexts')
Ext.namespace('Lino.system.TextFieldTemplates')
Ext.namespace('Lino.users.Users')
Ext.namespace('Lino.users.MySettings')
Ext.namespace('Lino.users.UsersOverview')
Ext.namespace('Lino.users.Teams')
Ext.namespace('Lino.users.Memberships')
Ext.namespace('Lino.users.Authorities')
Ext.namespace('Lino.countries.Countries')
Ext.namespace('Lino.countries.Cities')
Ext.namespace('Lino.contacts.CompanyTypes')
Ext.namespace('Lino.contacts.Partners')
Ext.namespace('Lino.contacts.Persons')
Ext.namespace('Lino.contacts.Companies')
Ext.namespace('Lino.contacts.RoleTypes')
Ext.namespace('Lino.contacts.Roles')
Ext.namespace('Lino.accounts.Charts')
Ext.namespace('Lino.accounts.Groups')
Ext.namespace('Lino.accounts.Accounts')
Ext.namespace('Lino.products.ProductCats')
Ext.namespace('Lino.products.Products')
Ext.namespace('Lino.ledger.Journals')
Ext.namespace('Lino.ledger.Vouchers')
Ext.namespace('Lino.ledger.Movements')
Ext.namespace('Lino.ledger.Invoices')
Ext.namespace('Lino.declarations.Declarations')
Ext.namespace('Lino.sales.PaymentTerms')
Ext.namespace('Lino.sales.InvoicingModes')
Ext.namespace('Lino.sales.ShippingModes')
Ext.namespace('Lino.sales.Invoices')
Ext.namespace('Lino.sales.DocumentsToSign')
Ext.namespace('Lino.finan.BankStatements')
Ext.namespace('Lino.finan.DocItems')
Ext.namespace('Lino.pages.Pages')
Ext.namespace('Lino.sales.SalesRuleTable')
Ext.namespace('Lino.sales.InvoiceItemTable')
Ext.namespace('Lino.sessions.SessionTable')
Ext.namespace('Lino.ledger.InvoiceItemTable')
Ext.namespace('Lino.finan.JournalEntryTable')
Ext.namespace('Lino.finan.PaymentOrderTable')
Ext.namespace('Lino.system.MyTextFieldTemplates')
Ext.namespace('Lino.users.MembershipsByUser')
Ext.namespace('Lino.users.AuthoritiesGiven')
Ext.namespace('Lino.users.AuthoritiesTaken')
Ext.namespace('Lino.countries.CitiesByCity')
Ext.namespace('Lino.countries.CitiesByCountry')
Ext.namespace('Lino.contacts.PartnersByCity')
Ext.namespace('Lino.contacts.PartnersByCountry')
Ext.namespace('Lino.contacts.RolesByCompany')
Ext.namespace('Lino.contacts.RolesByPerson')
Ext.namespace('Lino.accounts.GroupsByChart')
Ext.namespace('Lino.accounts.AccountsByGroup')
Ext.namespace('Lino.products.ProductsByCategory')
Ext.namespace('Lino.ledger.MovementsByVoucher')
Ext.namespace('Lino.ledger.MovementsByPartner')
Ext.namespace('Lino.ledger.InvoicesByJournal')
Ext.namespace('Lino.ledger.InvoicesByPartner')
Ext.namespace('Lino.ledger.ItemsByInvoice')
Ext.namespace('Lino.declarations.VouchersByDeclaration')
Ext.namespace('Lino.declarations.DeclarationsByJournal')
Ext.namespace('Lino.sales.ItemsByInvoice')
Ext.namespace('Lino.sales.ItemsByInvoicePrint')
Ext.namespace('Lino.sales.InvoiceItemsByProduct')
Ext.namespace('Lino.sales.InvoicesByJournal')
Ext.namespace('Lino.sales.InvoicesByPartner')
Ext.namespace('Lino.finan.BankStatementsByJournal')
Ext.namespace('Lino.finan.ItemsByStatement')
Ext.namespace('Lino.system.HelpTextsByModel')
Ext.namespace('Lino.about.Models')
Ext.namespace('Lino.about.FieldsByModel')
Ext.namespace('Lino.about.Inspector')
Ext.namespace('Lino.about.SourceFiles')
Ext.namespace('Lino.ledger.DuePaymentsByPartner')
Ext.namespace('Lino.lino.Report')
Ext.namespace('Lino.about.About')
Ext.namespace('Lino.system.Home')
Ext.namespace('Lino.vat.VatClasses')
Ext.namespace('Lino.vat.TradeTypes')
Ext.namespace('Lino.declarations.DeclarationFields')
Ext.namespace('Lino.ledger.InvoiceStates')
Ext.namespace('Lino.accounts.AccountTypes')
Ext.namespace('Lino.lino.UserLevels')
Ext.namespace('Lino.lino.YesNo')
Ext.namespace('Lino.ledger.FiscalYears')
Ext.namespace('Lino.declarations.DeclarationPeriods')
Ext.namespace('Lino.declarations.DeclarationStates')
Ext.namespace('Lino.countries.CityTypes')
Ext.namespace('Lino.vat.VatRegimes')
Ext.namespace('Lino.ledger.VoucherTypes')
Ext.namespace('Lino.finan.VoucherStates')
Ext.namespace('Lino.lino.UserGroups')
Ext.namespace('Lino.lino.Genders')
Ext.namespace('Lino.lino.UserProfiles')
Ext.namespace('Lino.sales.InvoiceStates')

// ChoiceLists: 
Lino.vat.VatClasses = [ [ "0", "Exempt" ], [ "1", "Reduced" ], [ "2", "Normal" ] ];
Lino.vat.TradeTypes = [ [ "S", "Sales" ], [ "P", "Purchases" ], [ "W", "Wages" ] ];
Lino.declarations.DeclarationFields = [ [ "00", "Sales base" ], [ "10", "Sales VAT" ], [ "20", "Purchases base" ], [ "30", "Purchases VAT" ], [ "80", "Investments" ], [ "81", "Ware" ], [ "82", "Services" ] ];
Lino.ledger.InvoiceStates = [ [ "10", "Draft" ], [ "20", "Registered" ], [ "40", "Paid" ] ];
Lino.accounts.AccountTypes = [ [ "A", "Assets" ], [ "L", "Liabilities" ], [ "I", "Incomes" ], [ "E", "Expenses" ], [ "C", "Capital" ], [ "B", "Bank accounts" ] ];
Lino.lino.UserLevels = [ [ "10", "Guest" ], [ "30", "User" ], [ "40", "Manager" ], [ "50", "Administrator" ] ];
Lino.lino.YesNo = [ [ "y", "Yes" ], [ "n", "No" ] ];
Lino.ledger.FiscalYears = [ [ "13", "2013" ], [ "14", "2014" ], [ "15", "2015" ], [ "16", "2016" ], [ "17", "2017" ] ];
Lino.declarations.DeclarationPeriods = [ [ "01", "January" ], [ "02", "February" ], [ "03", "March" ], [ "04", "April" ], [ "05", "May" ], [ "06", "June" ], [ "07", "July" ], [ "08", "August" ], [ "09", "September" ], [ "10", "October" ], [ "11", "November" ], [ "12", "December" ] ];
Lino.declarations.DeclarationStates = [ [ "00", "Draft" ], [ "10", "Registered" ], [ "20", "Submitted" ] ];
Lino.countries.CityTypes = [ [ "10", "Member State" ], [ "11", "Division" ], [ "12", "Region" ], [ "13", "Community" ], [ "14", "Territory" ], [ "20", "County" ], [ "21", "Province" ], [ "22", "Shire" ], [ "23", "Subregion" ], [ "24", "Department" ], [ "25", "Arrondissement" ], [ "26", "Prefecture" ], [ "27", "District" ], [ "28", "Sector" ], [ "50", "City" ], [ "51", "Town" ], [ "52", "Municipality" ], [ "54", "Parish" ], [ "55", "Township" ], [ "56", "Quarter" ], [ "61", "Borough" ], [ "62", "Small borough" ], [ "70", "Village" ] ];
Lino.vat.VatRegimes = [ [ "10", "Private person" ], [ "20", "Subject to VAT" ], [ "25", "Co-contractor" ], [ "30", "Intra-community" ], [ "40", "Outside EU" ], [ "50", "Exempt" ] ];
Lino.ledger.VoucherTypes = [ [ "ledger.AccountInvoice", "Invoice (lino.modlib.ledger.models.AccountInvoice)" ], [ "declarations.Declaration", "VAT declaration (lino.modlib.declarations.models.Declaration)" ], [ "finan.BankStatement", "Bank Statement (lino.modlib.finan.models.BankStatement)" ], [ "sales.Invoice", "Invoice (lino.modlib.sales.models.Invoice)" ] ];
Lino.finan.VoucherStates = [ [ "10", "Draft" ], [ "20", "Registered" ] ];
Lino.lino.UserGroups = [ [ "office", "office (Office)" ], [ "accounting", "accounting (Accounting)" ] ];
Lino.lino.Genders = [ [ "M", "Male" ], [ "F", "Female" ] ];
Lino.lino.UserProfiles = [ [ "000", "000 (Anonymous)" ], [ "100", "100 (User)" ], [ "900", "900 (Administrator)" ] ];
Lino.sales.InvoiceStates = [ [ "10", "Draft" ], [ "20", "Registered" ], [ "30", "Signed" ], [ "40", "Sent" ], [ "50", "Paid" ] ];

Lino.ledger.Invoices.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  layout: "hbox",
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 108,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var pjournal803 = new Lino.TwinCombo({ "fieldLabel": "Journal", "name": "pjournal", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail)}, "emptyText": "Select a Journal...", "listeners": { "render": Lino.quicktip_renderer("Journal","(ledger.Invoices.pjournal) ") }, "selectOnFocus": true, "hiddenName": "pjournalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/pjournal", "method": "GET" }) }) });
    var pyear804 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "pyear", "hiddenName": "pyearHidden", "listeners": { "render": Lino.quicktip_renderer("Fiscal Year","(ledger.Invoices.pyear) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var ppartner805 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Partner", "name": "ppartner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "hiddenName": "ppartnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(ledger.Invoices.ppartner) ") }, "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/ppartner", "method": "GET" }) }) });
    this.items = [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pjournal803, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pyear804, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ppartner805, "labelAlign": "top" } ];
    this.fields = [ pjournal803, pyear804, ppartner805 ];
    Lino.ledger.Invoices.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.about.Inspector.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  layout: "hbox",
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 153,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var inspected940 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Inspected object","(about.Inspector.inspected) ") }, "fieldLabel": "Inspected object", "name": "inspected", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var show_callables941 = new Ext.form.Checkbox({ "boxLabel": "show callables", "listeners": { "render": Lino.quicktip_renderer("show callables","(about.Inspector.show_callables) ") }, "hideLabel": true, "checked": false, "name": "show_callables", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "flex": 67, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inspected940, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_callables941, "labelAlign": "top" } ];
    this.fields = [ inspected940, show_callables941 ];
    Lino.about.Inspector.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.sales.Invoices.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  layout: "hbox",
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 108,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var journal322 = new Lino.TwinCombo({ "fieldLabel": "Journal", "name": "journal", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail)}, "emptyText": "Select a Journal...", "listeners": { "render": Lino.quicktip_renderer("Journal","(sales.Invoices.journal) ") }, "selectOnFocus": true, "hiddenName": "journalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/journal", "method": "GET" }) }) });
    var year323 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "year", "hiddenName": "yearHidden", "listeners": { "render": Lino.quicktip_renderer("Fiscal Year","(sales.Invoices.year) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    this.items = [ { "flex": 74, "autoHeight": true, "layout": "form", "xtype": "panel", "items": journal322, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": year323, "labelAlign": "top" } ];
    this.fields = [ journal322, year323 ];
    Lino.sales.Invoices.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.finan.BankStatements.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  layout: "hbox",
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 108,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var pjournal903 = new Lino.TwinCombo({ "fieldLabel": "Journal", "name": "pjournal", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail)}, "emptyText": "Select a Journal...", "listeners": { "render": Lino.quicktip_renderer("Journal","(finan.BankStatements.pjournal) ") }, "selectOnFocus": true, "hiddenName": "pjournalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/BankStatements/pjournal", "method": "GET" }) }) });
    var pyear904 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "pyear", "hiddenName": "pyearHidden", "listeners": { "render": Lino.quicktip_renderer("Fiscal Year","(finan.BankStatements.pyear) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    this.items = [ { "flex": 74, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pjournal903, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pyear904, "labelAlign": "top" } ];
    this.fields = [ pjournal903, pyear904 ];
    Lino.finan.BankStatements.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.merge_row_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 72,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'merge_row',
  ls_url: "/contacts/Persons",
  window_title: "Merge",
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var merge_to1 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "into...", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail)}, "emptyText": "Select a Person...", "listeners": { "render": Lino.quicktip_renderer("into...","(<MergeAction merge_row (u'Merge')>.merge_to) ") }, "selectOnFocus": true, "hiddenName": "merge_toHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/contacts/Persons/merge_row/merge_to", "method": "GET" }) }), "name": "merge_to" });
    var reason2 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Reason","(<MergeAction merge_row (u'Merge')>.reason) ") }, "fieldLabel": "Reason", "name": "reason", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": merge_to1, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": reason2, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ merge_to1, reason2 ];
    Lino.contacts.Persons.merge_row_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.merge_row_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 72,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'merge_row',
  ls_url: "/contacts/Companies",
  window_title: "Merge",
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var merge_to6 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "into...", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "emptyText": "Select a Company...", "listeners": { "render": Lino.quicktip_renderer("into...","(<MergeAction merge_row (u'Merge')>.merge_to) ") }, "selectOnFocus": true, "hiddenName": "merge_toHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/contacts/Companies/merge_row/merge_to", "method": "GET" }) }), "name": "merge_to" });
    var reason7 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Reason","(<MergeAction merge_row (u'Merge')>.reason) ") }, "fieldLabel": "Reason", "name": "reason", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": merge_to6, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": reason7, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ merge_to6, reason7 ];
    Lino.contacts.Companies.merge_row_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Journals.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 28,
  initComponent : function() {
    var containing_panel = this;
    var ref733 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("ref","(ledger.Journals.ref) ") }, "fieldLabel": "ref", "name": "ref", "maxLength": 20, "selectOnFocus": true, "anchor": "-20" });
    var name734 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation","(ledger.Journals.name) ") }, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de735 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(ledger.Journals.name_de) ") }, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_fr736 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(ledger.Journals.name_fr) ") }, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel737 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref733, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name734, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de735, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr736, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var trade_type742 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Trade Type", "name": "trade_type", "hiddenName": "trade_typeHidden", "listeners": { "render": Lino.quicktip_renderer("Trade Type","(ledger.Journals.trade_type) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.vat.TradeTypes) });
    var voucher_type743 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "voucher type", "allowBlank": false, "hiddenName": "voucher_typeHidden", "listeners": { "render": Lino.quicktip_renderer("voucher type","(ledger.Journals.voucher_type) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.ledger.VoucherTypes, "name": "voucher_type" });
    var main_panel744 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 117, "autoScroll": false, "items": [ main_1_panel737, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": trade_type742, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": voucher_type743, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel744;
    this.before_row_edit = function(record) {
    }
    Lino.ledger.Journals.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.sales.Invoices.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 37,
  initComponent : function() {
    var containing_panel = this;
    var date327 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Date","(sales.Invoices.date) ") }, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var partner328 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Select a Partner...", "listeners": { "render": Lino.quicktip_renderer("Partner","(sales.Invoices.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/partner", "method": "GET" }) }), "name": "partner" });
    var vat_regime329 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "VAT Regime", "allowBlank": false, "hiddenName": "vat_regimeHidden", "listeners": { "render": Lino.quicktip_renderer("VAT Regime","(sales.Invoices.vat_regime) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.vat.VatRegimes, "name": "vat_regime" });
    var invoice_header_1_panel330 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date327, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner328, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_regime329, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var subject334 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Subject line","(sales.Invoices.subject) ") }, "fieldLabel": "Subject line", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var your_ref335 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Your reference","(sales.Invoices.your_ref) ") }, "fieldLabel": "Your reference", "name": "your_ref", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var invoice_header_2_panel336 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject334, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": your_ref335, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var payment_term339 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Payment Term", "name": "payment_term", "pageSize": 20, "emptyText": "Select a Payment Term...", "listeners": { "render": Lino.quicktip_renderer("Payment Term","(sales.Invoices.payment_term) ") }, "selectOnFocus": true, "hiddenName": "payment_termHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/payment_term", "method": "GET" }) }) });
    var due_date340 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date of payment","(sales.Invoices.due_date) ") }, "fieldLabel": "Date of payment", "anchor": "-20", "name": "due_date" });
    var invoice_header_3_panel341 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": payment_term339, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": due_date340, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 144, "border": false, "anchor": "-20", "labelAlign": "top" });
    var imode344 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Invoicing Mode", "name": "imode", "pageSize": 20, "emptyText": "Select a Invoicing Mode...", "listeners": { "render": Lino.quicktip_renderer("Invoicing Mode","(sales.Invoices.imode) ") }, "selectOnFocus": true, "hiddenName": "imodeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/imode", "method": "GET" }) }) });
    var shipping_mode345 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Shipping Mode", "name": "shipping_mode", "pageSize": 20, "emptyText": "Select a Shipping Mode...", "listeners": { "render": Lino.quicktip_renderer("Shipping Mode","(sales.Invoices.shipping_mode) ") }, "selectOnFocus": true, "hiddenName": "shipping_modeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/shipping_mode", "method": "GET" }) }) });
    var invoice_header_4_panel346 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": imode344, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": shipping_mode345, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var invoice_header_panel349 = new Ext.form.FieldSet({ "flex": 75, "autoHeight": true, "layout": "form", "title": "Header", "items": [ invoice_header_1_panel330, invoice_header_2_panel336, invoice_header_3_panel341, invoice_header_4_panel346 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var total_base350 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Total excl. VAT", "name": "total_base", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Total excl. VAT","(sales.Invoices.total_base) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var total_vat351 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "VAT", "name": "total_vat", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("VAT","(sales.Invoices.total_vat) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var total_incl352 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Total incl. VAT", "name": "total_incl", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Total incl. VAT","(sales.Invoices.total_incl) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var workflow_buttons_disp353 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Workflow","(sales.Invoices.workflow_buttons) ") }, "fieldLabel": "Workflow", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var totals_panel354 = new Ext.form.FieldSet({ "flex": 25, "autoHeight": true, "layout": "form", "title": "Totals", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_base350, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_vat351, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_incl352, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp353, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 144, "border": false, "labelAlign": "top" });
    var general_1_panel359 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ invoice_header_panel349, totals_panel354 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ItemsByInvoice_grid371 = new Lino.sales.ItemsByInvoice.GridPanel({ "flex": 45, "listeners": { "render": Lino.quicktip_renderer("invoice items","(sales.sales.ItemsByInvoice) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.sales.ItemsByInvoice.grid) ], "preview_limit": 15, "master_panel": this });
    var general_panel372 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel359, ItemsByInvoice_grid371 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var id373 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(sales.Invoices.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var user374 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(sales.Invoices.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/user", "method": "GET" }) }) });
    var language375 = new Lino.ChoicesFieldElement({ "fieldLabel": "Language", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(sales.Invoices.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var more_1_panel376 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id373, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user374, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language375, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var intro380 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Introductive Text","(sales.Invoices.intro) ") }, "fieldLabel": "Introductive Text", "name": "intro", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var more_panel381 = new Ext.Panel({ "layout": "vbox", "title": "More", "items": [ more_1_panel376, { "items": intro380, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "labelWidth": 162, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var journal383 = new Lino.TwinCombo({ "fieldLabel": "Journal", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail)}, "emptyText": "Select a Journal...", "listeners": { "render": Lino.quicktip_renderer("Journal","(sales.Invoices.journal) ") }, "selectOnFocus": true, "hiddenName": "journalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/journal", "method": "GET" }) }), "name": "journal" });
    var year384 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "year", "hiddenName": "yearHidden", "listeners": { "render": Lino.quicktip_renderer("Fiscal Year","(sales.Invoices.year) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var number385 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("number","(sales.Invoices.number) ") }, "fieldLabel": "number", "anchor": "-20", "name": "number" });
    var narration386 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Narration","(sales.Invoices.narration) ") }, "fieldLabel": "Narration", "name": "narration", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var ledger_1_panel387 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": journal383, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": year384, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": number385, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": narration386, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ledger_MovementsByVoucher_grid399 = new Lino.ledger.MovementsByVoucher.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Movements","(ledger.ledger.MovementsByVoucher) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.ledger.MovementsByVoucher.grid) ], "preview_limit": 15, "master_panel": this });
    var ledger_panel400 = new Ext.Panel({ "layout": "vbox", "title": "Ledger", "items": [ ledger_1_panel387, ledger_MovementsByVoucher_grid399 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel401 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel372, more_panel381, ledger_panel400 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel401;
    this.before_row_edit = function(record) {
      ItemsByInvoice_grid371.on_master_changed();
      ledger_MovementsByVoucher_grid399.on_master_changed();
    }
    Lino.sales.Invoices.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pages.Pages.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 44,
  initComponent : function() {
    var containing_panel = this;
    var ref908 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Reference","(pages.Pages.ref) ") }, "fieldLabel": "Reference", "name": "ref", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var parent909 = new Lino.TwinCombo({ "fieldLabel": "Parent", "name": "parent", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pages.Pages.detail)}, "emptyText": "Select a Node...", "listeners": { "render": Lino.quicktip_renderer("Parent","(pages.Pages.parent) ") }, "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pages/Pages/parent", "method": "GET" }) }) });
    var seqno910 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Seq.No.","(pages.Pages.seqno) ") }, "fieldLabel": "Seq.No.", "anchor": "-20", "name": "seqno" });
    var main_1_panel911 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref908, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent909, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": seqno910, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var title915 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Title","(pages.Pages.title) ") }, "fieldLabel": "Title", "name": "title", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var title_de916 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Title (de)","(pages.Pages.title_de) ") }, "fieldLabel": "Title (de)", "name": "title_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var title_fr917 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Title (fr)","(pages.Pages.title_fr) ") }, "fieldLabel": "Title (fr)", "name": "title_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel918 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title915, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title_de916, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title_fr917, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var body922 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Body","(pages.Pages.body) ") }, "fieldLabel": "Body", "name": "body", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var main_panel923 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 45, "hideCheckBoxLabels": true, "items": [ main_1_panel911, main_2_panel918, { "items": body922, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel923;
    this.before_row_edit = function(record) {
    }
    Lino.pages.Pages.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Journals.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 28,
  initComponent : function() {
    var containing_panel = this;
    var ref700 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("ref","(ledger.Journals.ref) ") }, "fieldLabel": "ref", "name": "ref", "maxLength": 20, "selectOnFocus": true, "anchor": "-20" });
    var trade_type701 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Trade Type", "name": "trade_type", "hiddenName": "trade_typeHidden", "listeners": { "render": Lino.quicktip_renderer("Trade Type","(ledger.Journals.trade_type) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.vat.TradeTypes) });
    var voucher_type702 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "voucher type", "allowBlank": false, "hiddenName": "voucher_typeHidden", "listeners": { "render": Lino.quicktip_renderer("voucher type","(ledger.Journals.voucher_type) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.ledger.VoucherTypes, "name": "voucher_type" });
    var main_1_panel703 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref700, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": trade_type701, "labelAlign": "top" }, { "flex": 65, "autoHeight": true, "layout": "form", "xtype": "panel", "items": voucher_type702, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var force_sequence707 = new Ext.form.Checkbox({ "boxLabel": "force sequence", "listeners": { "render": Lino.quicktip_renderer("force sequence","(ledger.Journals.force_sequence) ") }, "hideLabel": true, "checked": false, "name": "force_sequence", "selectOnFocus": true, "anchor": "-20" });
    var account708 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Account", "name": "account", "pageSize": 20, "emptyText": "Select a Account...", "listeners": { "render": Lino.quicktip_renderer("Account","(ledger.Journals.account) ") }, "selectOnFocus": true, "hiddenName": "accountHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Journals/account", "method": "GET" }) }) });
    var seqno709 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Seq.No.","(ledger.Journals.seqno) ") }, "fieldLabel": "Seq.No.", "anchor": "-20", "name": "seqno" });
    var id710 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(ledger.Journals.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_2_panel711 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": force_sequence707, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": account708, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": seqno709, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id710, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var name716 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation","(ledger.Journals.name) ") }, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de717 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(ledger.Journals.name_de) ") }, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_fr718 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(ledger.Journals.name_fr) ") }, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel719 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name716, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de717, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr718, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var build_method723 = new Lino.ChoicesFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Build method","(ledger.Journals.build_method) ") }, "fieldLabel": "Build method", "name": "build_method", "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "hiddenName": "build_methodHidden" });
    var printed_name724 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("printed name","(ledger.Journals.printed_name) ") }, "fieldLabel": "printed name", "name": "printed_name", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var printed_name_de725 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("printed name (de)","(ledger.Journals.printed_name_de) ") }, "fieldLabel": "printed name (de)", "name": "printed_name_de", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var printed_name_fr726 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("printed name (fr)","(ledger.Journals.printed_name_fr) ") }, "fieldLabel": "printed name (fr)", "name": "printed_name_fr", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var main_4_panel727 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method723, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": printed_name724, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": printed_name_de725, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": printed_name_fr726, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel732 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel703, main_2_panel711, main_3_panel719, main_4_panel727 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel732;
    this.before_row_edit = function(record) {
      account708.setContextValue('chart',record ? record.data['chartHidden'] : undefined);
    }
    Lino.ledger.Journals.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.Models.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var app_disp925 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("app_label","(about.Models.app) ") }, "fieldLabel": "app_label", "name": "app", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var name_disp926 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("name","(about.Models.name) ") }, "fieldLabel": "name", "name": "name", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var docstring_disp927 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("docstring","(about.Models.docstring) ") }, "fieldLabel": "docstring", "name": "docstring", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var rows928 = new Ext.form.NumberField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Rows","(about.Models.rows) ") }, "fieldLabel": "Rows", "anchor": "-20", "name": "rows" });
    var main_1_panel929 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_disp925, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_disp926, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": docstring_disp927, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": rows928, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var about_FieldsByModel_grid938 = new Lino.about.FieldsByModel.GridPanel({ "flex": 62, "listeners": { "render": Lino.quicktip_renderer("Fields","(about.about.FieldsByModel) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.about.FieldsByModel.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel939 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel929, about_FieldsByModel_grid938 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel939;
    this.before_row_edit = function(record) {
      about_FieldsByModel_grid938.on_master_changed();
    }
    Lino.about.Models.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.Users.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 12,
  initComponent : function() {
    var containing_panel = this;
    var username11 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Username","(users.Users.username) Required. Must be unique.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Username</span>", "name": "username", "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var profile12 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">User Profile</span>", "name": "profile", "hiddenName": "profileHidden", "listeners": { "render": Lino.quicktip_renderer("User Profile","(users.Users.profile) Users with an empty `profile` field are considered inactive and cannot log in.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var partner13 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "hiddenName": "partnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(users.Users.partner) ") }, "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var box1_1_panel14 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username11, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile12, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner13, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name18 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("First name","(users.Users.first_name) ") }, "fieldLabel": "First name", "name": "first_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var last_name19 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Last name","(users.Users.last_name) ") }, "fieldLabel": "Last name", "name": "last_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var initials20 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Initials","(users.Users.initials) ") }, "fieldLabel": "Initials", "name": "initials", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box1_2_panel21 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name18, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name19, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": initials20, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email25 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("e-mail address","(users.Users.email) ") }, "fieldLabel": "e-mail address", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var language26 = new Lino.ChoicesFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Language","(users.Users.language) ") }, "fieldLabel": "Language", "name": "language", "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "hiddenName": "languageHidden" });
    var box1_3_panel27 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email25, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language26, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var id30 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(users.Users.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var created31 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Created","(users.Users.created) ") }, "fieldLabel": "Created", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified32 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Modified","(users.Users.modified) ") }, "fieldLabel": "Modified", "name": "modified", "anchor": "-20", "value": "<br>" });
    var box1_4_panel33 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id30, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created31, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified32, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box1_panel37 = new Ext.Panel({ "flex": 66, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ box1_1_panel14, box1_2_panel21, box1_3_panel27, box1_4_panel33 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var MembershipsByUser_grid40 = new Lino.users.MembershipsByUser.GridPanel({ "flex": 33, "hide_top_toolbar": true, "containing_panel": this, "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("My Memberships","(users.users.MembershipsByUser) ") }, "tools": [ Lino.show_in_own_window_button(Lino.users.MembershipsByUser.grid) ], "hideHeaders": true });
    var main_1_panel41 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box1_panel37, MembershipsByUser_grid40 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks42 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remarks","(users.Users.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var AuthoritiesGiven_grid45 = new Lino.users.AuthoritiesGiven.GridPanel({ "flex": 33, "hide_top_toolbar": true, "containing_panel": this, "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Authorities given","(users.users.AuthoritiesGiven) ") }, "tools": [ Lino.show_in_own_window_button(Lino.users.AuthoritiesGiven.grid) ], "hideHeaders": true });
    var main_2_panel46 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": remarks42, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 66 }, AuthoritiesGiven_grid45 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel48 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel41, main_2_panel46 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel48;
    this.before_row_edit = function(record) {
      MembershipsByUser_grid40.on_master_changed();
      AuthoritiesGiven_grid45.on_master_changed();
    }
    Lino.users.Users.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    partner13.on("change",function(){this.save()},this);
  }
});


Lino.users.Users.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 12,
  initComponent : function() {
    var containing_panel = this;
    var username49 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Username","(users.Users.username) Required. Must be unique.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Username</span>", "name": "username", "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var email50 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("e-mail address","(users.Users.email) ") }, "fieldLabel": "e-mail address", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel51 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username49, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email50, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name54 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("First name","(users.Users.first_name) ") }, "fieldLabel": "First name", "name": "first_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var last_name55 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Last name","(users.Users.last_name) ") }, "fieldLabel": "Last name", "name": "last_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel56 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name54, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name55, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var partner59 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "hiddenName": "partnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(users.Users.partner) ") }, "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var language60 = new Lino.ChoicesFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Language","(users.Users.language) ") }, "fieldLabel": "Language", "name": "language", "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "hiddenName": "languageHidden" });
    var profile61 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">User Profile</span>", "name": "profile", "hiddenName": "profileHidden", "listeners": { "render": Lino.quicktip_renderer("User Profile","(users.Users.profile) Users with an empty `profile` field are considered inactive and cannot log in.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var main_4_panel62 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 47, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language60, "labelAlign": "top" }, { "flex": 52, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile61, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel65 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ main_1_panel51, main_2_panel56, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner59, "anchor": "-20", "labelAlign": "top" }, main_4_panel62 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel65;
    this.before_row_edit = function(record) {
    }
    Lino.users.Users.InsertFormPanel.superclass.initComponent.call(this);
    // active_fields:
    partner59.on("change",function(){this.save()},this);
  }
});


Lino.system.SiteConfigs.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 8,
  initComponent : function() {
    var containing_panel = this;
    var default_build_method106 = new Lino.ChoicesFieldElement({ "fieldLabel": "Default build method", "name": "default_build_method", "value": "appyodt", "hiddenName": "default_build_methodHidden", "listeners": { "render": Lino.quicktip_renderer("Default build method","(system.SiteConfigs.default_build_method) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var main_panel107 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "items": default_build_method106, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel107;
    this.before_row_edit = function(record) {
    }
    Lino.system.SiteConfigs.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 19,
  initComponent : function() {
    var containing_panel = this;
    var title499 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Title","(contacts.Persons.title) Text to print before first_name as part of the first address line.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Title</span>", "name": "title", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var first_name500 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("First name","(contacts.Persons.first_name) ") }, "fieldLabel": "First name", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var last_name501 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Last name","(contacts.Persons.last_name) ") }, "fieldLabel": "Last name", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel502 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title499, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name500, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name501, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gender506 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Gender", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Gender","(contacts.Persons.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var language507 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(contacts.Persons.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var main_2_panel508 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender506, "labelAlign": "top" }, { "flex": 68, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language507, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel511 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel502, main_2_panel508 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel511;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Persons.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 21,
  initComponent : function() {
    var containing_panel = this;
    var name236 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Partners.name) ") }, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var country237 = new Lino.TwinCombo({ "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Country","(contacts.Partners.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }) });
    var region238 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Region","(contacts.Partners.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }) });
    var city239 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Place","(contacts.Partners.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }) });
    var zip_code240 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Zip code","(contacts.Partners.zip_code) ") }, "fieldLabel": "Zip code", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_2_panel241 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country237, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region238, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city239, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code240, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr1246 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Address line before street","(contacts.Partners.addr1) Address line before street") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line before street</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_prefix247 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Street prefix","(contacts.Partners.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street prefix</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street248 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Street","(contacts.Partners.street) Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no249 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("No.","(contacts.Partners.street_no) House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box250 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","(contacts.Partners.street_box) Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_4_panel251 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix247, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street248, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no249, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box250, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2256 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Address line after street","(contacts.Partners.addr2) Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line after street</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var address_box_panel257 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "layout": "form", "title": "Address", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name236, "anchor": "-20", "labelAlign": "top" }, address_box_2_panel241, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1246, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel251, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2256, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 243, "border": false, "labelAlign": "top" });
    var id261 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Partners.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language262 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(contacts.Partners.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var info_box_panel263 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id261, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language262, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email266 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Partners.email) ") }, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var url267 = new Lino.URLField({ "listeners": { "render": Lino.quicktip_renderer("URL","(contacts.Partners.url) ") }, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var phone268 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Phone","(contacts.Partners.phone) ") }, "fieldLabel": "Phone", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gsm269 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("GSM","(contacts.Partners.gsm) ") }, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var fax270 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Fax","(contacts.Partners.fax) ") }, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var contact_box_5_panel271 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm269, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax270, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel274 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "layout": "form", "title": "Contact", "items": [ info_box_panel263, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email266, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url267, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone268, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel271 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var general_1_panel278 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ address_box_panel257, contact_box_panel274 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks279 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remarks","(contacts.Partners.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var is_person280 = new Ext.form.Checkbox({ "boxLabel": "is Person (<a href=\"javascript:Lino.show_mti_child('is_person',Lino.contacts.Persons.detail)\">show</a>)", "listeners": { "render": Lino.quicktip_renderer("is Person","(contacts.Partners.is_person) Whether this Partner is a Person.") }, "hideLabel": true, "name": "is_person", "selectOnFocus": true, "anchor": "-20" });
    var is_company281 = new Ext.form.Checkbox({ "boxLabel": "is Company (<a href=\"javascript:Lino.show_mti_child('is_company',Lino.contacts.Companies.detail)\">show</a>)", "listeners": { "render": Lino.quicktip_renderer("is Company","(contacts.Partners.is_company) Whether this Partner is a Company.") }, "hideLabel": true, "name": "is_company", "selectOnFocus": true, "anchor": "-20" });
    var bottom_box_2_panel282 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_person280, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_company281, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var bottom_box_panel285 = new Ext.Panel({ "flex": 54, "layout": "vbox", "items": [ { "items": remarks279, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 }, bottom_box_2_panel282 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var general_panel287 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel278, bottom_box_panel285 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var invoicing_address288 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Invoicing address", "name": "invoicing_address", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "hiddenName": "invoicing_addressHidden", "listeners": { "render": Lino.quicktip_renderer("Invoicing address","(contacts.Partners.invoicing_address) ") }, "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/invoicing_address", "method": "GET" }) }) });
    var vat_regime289 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">VAT Regime</span>", "name": "vat_regime", "hiddenName": "vat_regimeHidden", "listeners": { "render": Lino.quicktip_renderer("VAT Regime","(contacts.Partners.vat_regime) The default VAT regime for sales to this customer.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var imode290 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Invoicing Mode", "name": "imode", "pageSize": 20, "emptyText": "Select a Invoicing Mode...", "listeners": { "render": Lino.quicktip_renderer("Invoicing Mode","(contacts.Partners.imode) ") }, "selectOnFocus": true, "hiddenName": "imodeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/imode", "method": "GET" }) }) });
    var payment_term291 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Payment Term</span>", "name": "payment_term", "pageSize": 20, "emptyText": "Select a Payment Term...", "listeners": { "render": Lino.quicktip_renderer("Payment Term","(contacts.Partners.payment_term) The default payment term for sales invoices to this customer.") }, "selectOnFocus": true, "hiddenName": "payment_termHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/payment_term", "method": "GET" }) }) });
    var sales_1_panel292 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 162, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invoicing_address288, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_regime289, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": imode290, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": payment_term291, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var sales_InvoicesByPartner_grid410 = new Lino.sales.InvoicesByPartner.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Invoices","(sales.sales.InvoicesByPartner) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.sales.InvoicesByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var sales_panel411 = new Ext.Panel({ "layout": "vbox", "title": "Sales", "items": [ sales_1_panel292, sales_InvoicesByPartner_grid410 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel412 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel287, sales_panel411 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel412;
    this.before_row_edit = function(record) {
      region238.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city239.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city239.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      sales_InvoicesByPartner_grid410.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country237.on('change',Lino.chooser_handler(region238,'country'));
      country237.on('change',Lino.chooser_handler(city239,'country'));
      region238.on('change',Lino.chooser_handler(city239,'region'));
      Lino.contacts.Partners.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Partners.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 21,
  initComponent : function() {
    var containing_panel = this;
    var name413 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Partners.name) ") }, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language414 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(contacts.Partners.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var email415 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Partners.email) ") }, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel416 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language414, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email415, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel419 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name413, "anchor": "-20", "labelAlign": "top" }, main_2_panel416 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel419;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Partners.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.ContentTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 3,
  initComponent : function() {
    var containing_panel = this;
    var id109 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(system.ContentTypes.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name110 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("name","(system.ContentTypes.name) ") }, "fieldLabel": "name", "name": "name", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var app_label111 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("app label","(system.ContentTypes.app_label) ") }, "fieldLabel": "app label", "name": "app_label", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var model112 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("python model class name","(system.ContentTypes.model) ") }, "fieldLabel": "python model class name", "name": "model", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var base_classes_disp113 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Base classes","(system.ContentTypes.base_classes) ") }, "fieldLabel": "Base classes", "name": "base_classes", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel114 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id109, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name110, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_label111, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": model112, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": base_classes_disp113, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var system_HelpTextsByModel_grid126 = new Lino.system.HelpTextsByModel.GridPanel({ "flex": 62, "listeners": { "render": Lino.quicktip_renderer("Help Texts","(system.system.HelpTextsByModel) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.system.HelpTextsByModel.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel127 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel114, system_HelpTextsByModel_grid126 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel127;
    this.before_row_edit = function(record) {
      system_HelpTextsByModel_grid126.on_master_changed();
    }
    Lino.system.ContentTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Invoices.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 30,
  initComponent : function() {
    var containing_panel = this;
    var id747 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(ledger.Invoices.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var date748 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Date","(ledger.Invoices.date) ") }, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var partner749 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Select a Partner...", "listeners": { "render": Lino.quicktip_renderer("Partner","(ledger.Invoices.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/partner", "method": "GET" }) }), "name": "partner" });
    var user750 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(ledger.Invoices.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/user", "method": "GET" }) }) });
    var general_1_panel751 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id747, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date748, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner749, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user750, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var due_date756 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Due date","(ledger.Invoices.due_date) ") }, "fieldLabel": "Due date", "anchor": "-20", "name": "due_date" });
    var your_ref757 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Your reference","(ledger.Invoices.your_ref) ") }, "fieldLabel": "Your reference", "name": "your_ref", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var vat_regime758 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "VAT Regime", "allowBlank": false, "hiddenName": "vat_regimeHidden", "listeners": { "render": Lino.quicktip_renderer("VAT Regime","(ledger.Invoices.vat_regime) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.vat.VatRegimes, "name": "vat_regime" });
    var general_2_panel759 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": due_date756, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": your_ref757, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_regime758, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var ItemsByInvoice_grid771 = new Lino.ledger.ItemsByInvoice.GridPanel({ "flex": 75, "listeners": { "render": Lino.quicktip_renderer("Voucher items","(ledger.ledger.ItemsByInvoice) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.ledger.ItemsByInvoice.grid) ], "preview_limit": 15, "master_panel": this });
    var total_base772 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Total excl. VAT", "name": "total_base", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Total excl. VAT","(ledger.Invoices.total_base) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var total_vat773 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "VAT", "name": "total_vat", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("VAT","(ledger.Invoices.total_vat) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var total_incl774 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Total incl. VAT", "name": "total_incl", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Total incl. VAT","(ledger.Invoices.total_incl) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var workflow_buttons_disp775 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Workflow","(ledger.Invoices.workflow_buttons) ") }, "fieldLabel": "Workflow", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var totals_panel776 = new Ext.Panel({ "flex": 25, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_base772, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_vat773, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_incl774, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp775, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 144, "border": false, "labelAlign": "top" });
    var general_3_panel781 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ ItemsByInvoice_grid771, totals_panel776 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "anchor": "-20", "labelAlign": "top" });
    var general_panel782 = new Ext.Panel({ "autoHeight": true, "layout": "form", "title": "General", "items": [ general_1_panel751, general_2_panel759, general_3_panel781 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "labelAlign": "top" });
    var journal783 = new Lino.TwinCombo({ "fieldLabel": "Journal", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail)}, "emptyText": "Select a Journal...", "listeners": { "render": Lino.quicktip_renderer("Journal","(ledger.Invoices.journal) ") }, "selectOnFocus": true, "hiddenName": "journalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/journal", "method": "GET" }) }), "name": "journal" });
    var year784 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "year", "hiddenName": "yearHidden", "listeners": { "render": Lino.quicktip_renderer("Fiscal Year","(ledger.Invoices.year) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var number785 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("number","(ledger.Invoices.number) ") }, "fieldLabel": "number", "anchor": "-20", "name": "number" });
    var narration786 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Narration","(ledger.Invoices.narration) ") }, "fieldLabel": "Narration", "name": "narration", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var ledger_1_panel787 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": journal783, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": year784, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": number785, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": narration786, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var MovementsByVoucher_grid792 = new Lino.ledger.MovementsByVoucher.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Movements","(ledger.ledger.MovementsByVoucher) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.ledger.MovementsByVoucher.grid) ], "preview_limit": 15, "master_panel": this });
    var ledger_panel793 = new Ext.Panel({ "layout": "vbox", "title": "Ledger", "items": [ ledger_1_panel787, MovementsByVoucher_grid792 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel794 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel782, ledger_panel793 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel794;
    this.before_row_edit = function(record) {
      ItemsByInvoice_grid771.on_master_changed();
      MovementsByVoucher_grid792.on_master_changed();
    }
    Lino.ledger.Invoices.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Invoices.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 30,
  initComponent : function() {
    var containing_panel = this;
    var partner795 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Select a Partner...", "listeners": { "render": Lino.quicktip_renderer("Partner","(ledger.Invoices.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/partner", "method": "GET" }) }), "name": "partner" });
    var date796 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Date","(ledger.Invoices.date) ") }, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var total_incl797 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Total incl. VAT", "name": "total_incl", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Total incl. VAT","(ledger.Invoices.total_incl) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var main_2_panel798 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date796, "labelAlign": "top" }, { "flex": 60, "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_incl797, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 144, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel801 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner795, "anchor": "-20", "labelAlign": "top" }, main_2_panel798 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel801;
    this.before_row_edit = function(record) {
    }
    Lino.ledger.Invoices.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.TextFieldTemplates.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 10,
  initComponent : function() {
    var containing_panel = this;
    var name141 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation","(system.TextFieldTemplates.name) ") }, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user142 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(system.TextFieldTemplates.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/user", "method": "GET" }) }) });
    var team143 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Team</span>", "name": "team", "pageSize": 20, "emptyText": "Select a Team...", "listeners": { "render": Lino.quicktip_renderer("Team","(system.TextFieldTemplates.team) If not empty, then this template is reserved to members of this team.") }, "selectOnFocus": true, "hiddenName": "teamHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/team", "method": "GET" }) }) });
    var main_2_panel144 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user142, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": team143, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel147 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 108, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name141, "anchor": "-20", "labelAlign": "top" }, main_2_panel144 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel147;
    this.before_row_edit = function(record) {
    }
    Lino.system.TextFieldTemplates.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.TextFieldTemplates.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 10,
  initComponent : function() {
    var containing_panel = this;
    var id128 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(system.TextFieldTemplates.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name129 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation","(system.TextFieldTemplates.name) ") }, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user130 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(system.TextFieldTemplates.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/user", "method": "GET" }) }) });
    var team131 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Team</span>", "name": "team", "pageSize": 20, "emptyText": "Select a Team...", "listeners": { "render": Lino.quicktip_renderer("Team","(system.TextFieldTemplates.team) If not empty, then this template is reserved to members of this team.") }, "selectOnFocus": true, "hiddenName": "teamHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/team", "method": "GET" }) }) });
    var main_1_panel132 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id128, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name129, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user130, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": team131, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 108, "border": false, "frame": false, "labelAlign": "top" });
    var description137 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(system.TextFieldTemplates.description) ") }, "fieldLabel": "Description", "name": "description", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var text138 = new Lino.RichTextPanel({ "flex": 5, "split": true, "containing_panel": this, "selectOnFocus": true, "region": "south", "title": "Template Text", "name": "text" });
    var main_panel139 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ main_1_panel132, { "flex": 5, "layout": "form", "xtype": "panel", "items": description137, "region": "center", "labelAlign": "top", "split": true }, text138 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel139;
    this.before_row_edit = function(record) {
      text138.refresh();
    }
    Lino.system.TextFieldTemplates.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.Home.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var quick_links_htmlbox947 = new Lino.HtmlBoxPanel({ "flex": 1, "layout": "fit", "name": "quick_links", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "north", "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer(null,"(system.Home.quick_links) ") }, "split": true });
    var welcome_htmlbox948 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "welcome", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "center", "title": "Welcome", "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Welcome","(system.Home.welcome) ") }, "split": true });
    var main_panel949 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ quick_links_htmlbox947, welcome_htmlbox948 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel949;
    this.before_row_edit = function(record) {
      quick_links_htmlbox947.refresh();
      welcome_htmlbox948.refresh();
    }
    Lino.system.Home.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Groups.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 26,
  initComponent : function() {
    var containing_panel = this;
    var ref614 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("ref","(accounts.Groups.ref) ") }, "fieldLabel": "ref", "name": "ref", "maxLength": 20, "selectOnFocus": true, "anchor": "-20" });
    var name615 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation","(accounts.Groups.name) ") }, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de616 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(accounts.Groups.name_de) ") }, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_fr617 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(accounts.Groups.name_fr) ") }, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel618 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref614, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name615, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de616, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr617, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var account_type623 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Account Type", "name": "account_type", "hiddenName": "account_typeHidden", "listeners": { "render": Lino.quicktip_renderer("Account Type","(accounts.Groups.account_type) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.accounts.AccountTypes) });
    var id624 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(accounts.Groups.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_2_panel625 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 76, "autoHeight": true, "layout": "form", "xtype": "panel", "items": account_type623, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id624, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var help_text628 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 41, "containing_panel": this, "name": "help_text", "title": "Introduction" });
    var AccountsByGroup_grid641 = new Lino.accounts.AccountsByGroup.GridPanel({ "flex": 41, "listeners": { "render": Lino.quicktip_renderer("Accounts","(accounts.accounts.AccountsByGroup) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.accounts.AccountsByGroup.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel642 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel618, main_2_panel625, help_text628, AccountsByGroup_grid641 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel642;
    this.before_row_edit = function(record) {
      help_text628.refresh();
      AccountsByGroup_grid641.on_master_changed();
    }
    Lino.accounts.Groups.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Charts.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 27,
  initComponent : function() {
    var containing_panel = this;
    var id598 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(accounts.Charts.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name599 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation","(accounts.Charts.name) ") }, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de600 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(accounts.Charts.name_de) ") }, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_fr601 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(accounts.Charts.name_fr) ") }, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel602 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id598, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name599, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de600, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr601, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var GroupsByChart_grid643 = new Lino.accounts.GroupsByChart.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Account Groups","(accounts.accounts.GroupsByChart) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.accounts.GroupsByChart.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel644 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel602, GroupsByChart_grid643 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel644;
    this.before_row_edit = function(record) {
      GroupsByChart_grid643.on_master_changed();
    }
    Lino.accounts.Charts.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.products.Products.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 24,
  initComponent : function() {
    var containing_panel = this;
    var id665 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(products.Products.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var cat666 = new Lino.TwinCombo({ "fieldLabel": "Category", "name": "cat", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.products.ProductCats.detail)}, "emptyText": "Select a Product Category...", "listeners": { "render": Lino.quicktip_renderer("Category","(products.Products.cat) ") }, "selectOnFocus": true, "hiddenName": "catHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/products/Products/cat", "method": "GET" }) }) });
    var sales_price667 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Sales price", "name": "sales_price", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Sales price","(products.Products.sales_price) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var vat_class668 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "VAT Class", "name": "vat_class", "hiddenName": "vat_classHidden", "listeners": { "render": Lino.quicktip_renderer("VAT Class","(products.Products.vat_class) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.vat.VatClasses) });
    var general_1_panel669 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id665, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cat666, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sales_price667, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_class668, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var name674 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation","(products.Products.name) ") }, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de675 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(products.Products.name_de) ") }, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_fr676 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(products.Products.name_fr) ") }, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var general_2_panel677 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name674, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de675, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr676, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description681 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Long description","(products.Products.description) ") }, "fieldLabel": "Long description", "name": "description", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var general_panel682 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel669, general_2_panel677, { "items": description681, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "labelWidth": 153, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var sales_InvoiceItemsByProduct_grid695 = new Lino.sales.InvoiceItemsByProduct.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Sales", "tools": [ Lino.show_in_own_window_button(Lino.sales.InvoiceItemsByProduct.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel696 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel682, sales_InvoiceItemsByProduct_grid695 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel696;
    this.before_row_edit = function(record) {
      sales_InvoiceItemsByProduct_grid695.on_master_changed();
    }
    Lino.products.Products.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 19,
  initComponent : function() {
    var containing_panel = this;
    var last_name428 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Last name","(contacts.Persons.last_name) ") }, "fieldLabel": "Last name", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var first_name429 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("First name","(contacts.Persons.first_name) ") }, "fieldLabel": "First name", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gender430 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Gender", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Gender","(contacts.Persons.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var title431 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Title","(contacts.Persons.title) Text to print before first_name as part of the first address line.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Title</span>", "name": "title", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_box_panel432 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name428, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name429, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender430, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title431, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var country437 = new Lino.TwinCombo({ "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Country","(contacts.Persons.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/country", "method": "GET" }) }) });
    var region438 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Region","(contacts.Persons.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/region", "method": "GET" }) }) });
    var city439 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Place","(contacts.Persons.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/city", "method": "GET" }) }) });
    var zip_code440 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Zip code","(contacts.Persons.zip_code) ") }, "fieldLabel": "Zip code", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_2_panel441 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country437, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region438, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city439, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code440, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr1446 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Address line before street","(contacts.Persons.addr1) Address line before street") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line before street</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_prefix447 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Street prefix","(contacts.Persons.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street prefix</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street448 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Street","(contacts.Persons.street) Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no449 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("No.","(contacts.Persons.street_no) House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box450 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","(contacts.Persons.street_box) Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_4_panel451 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix447, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street448, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no449, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box450, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2456 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Address line after street","(contacts.Persons.addr2) Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line after street</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var address_box_panel457 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "layout": "form", "title": "Address", "items": [ name_box_panel432, address_box_2_panel441, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1446, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel451, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2456, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 243, "border": false, "labelAlign": "top" });
    var id460 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Persons.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language461 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(contacts.Persons.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var info_box_panel462 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id460, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language461, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email465 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Persons.email) ") }, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var url466 = new Lino.URLField({ "listeners": { "render": Lino.quicktip_renderer("URL","(contacts.Persons.url) ") }, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var phone467 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Phone","(contacts.Persons.phone) ") }, "fieldLabel": "Phone", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gsm468 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("GSM","(contacts.Persons.gsm) ") }, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var fax469 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Fax","(contacts.Persons.fax) ") }, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var contact_box_5_panel470 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm468, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax469, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel473 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "layout": "form", "title": "Contact", "items": [ info_box_panel462, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email465, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url466, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone467, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel470 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var general_1_panel477 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ address_box_panel457, contact_box_panel473 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks478 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remarks","(contacts.Persons.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var contacts_RolesByPerson_grid483 = new Lino.contacts.RolesByPerson.GridPanel({ "flex": 42, "listeners": { "render": Lino.quicktip_renderer("Contact for","(contacts.contacts.RolesByPerson) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByPerson.grid) ], "preview_limit": 15, "master_panel": this });
    var bottom_box_panel484 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": remarks478, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 57 }, contacts_RolesByPerson_grid483 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel486 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel477, bottom_box_panel484 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var invoicing_address487 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Invoicing address", "name": "invoicing_address", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "hiddenName": "invoicing_addressHidden", "listeners": { "render": Lino.quicktip_renderer("Invoicing address","(contacts.Persons.invoicing_address) ") }, "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/invoicing_address", "method": "GET" }) }) });
    var vat_regime488 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">VAT Regime</span>", "name": "vat_regime", "hiddenName": "vat_regimeHidden", "listeners": { "render": Lino.quicktip_renderer("VAT Regime","(contacts.Persons.vat_regime) The default VAT regime for sales to this customer.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var imode489 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Invoicing Mode", "name": "imode", "pageSize": 20, "emptyText": "Select a Invoicing Mode...", "listeners": { "render": Lino.quicktip_renderer("Invoicing Mode","(contacts.Persons.imode) ") }, "selectOnFocus": true, "hiddenName": "imodeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/imode", "method": "GET" }) }) });
    var payment_term490 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Payment Term</span>", "name": "payment_term", "pageSize": 20, "emptyText": "Select a Payment Term...", "listeners": { "render": Lino.quicktip_renderer("Payment Term","(contacts.Persons.payment_term) The default payment term for sales invoices to this customer.") }, "selectOnFocus": true, "hiddenName": "payment_termHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/payment_term", "method": "GET" }) }) });
    var sales_1_panel491 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 162, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invoicing_address487, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_regime488, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": imode489, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": payment_term490, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var sales_InvoicesByPartner_grid496 = new Lino.sales.InvoicesByPartner.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Invoices","(sales.sales.InvoicesByPartner) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.sales.InvoicesByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var sales_panel497 = new Ext.Panel({ "layout": "vbox", "title": "Sales", "items": [ sales_1_panel491, sales_InvoicesByPartner_grid496 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel498 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel486, sales_panel497 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel498;
    this.before_row_edit = function(record) {
      region438.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city439.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city439.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByPerson_grid483.on_master_changed();
      sales_InvoicesByPartner_grid496.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country437.on('change',Lino.chooser_handler(region438,'country'));
      country437.on('change',Lino.chooser_handler(city439,'country'));
      region438.on('change',Lino.chooser_handler(city439,'region'));
      Lino.contacts.Persons.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Persons.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.products.ProductCats.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 23,
  initComponent : function() {
    var containing_panel = this;
    var id645 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(products.ProductCats.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name646 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation","(products.ProductCats.name) ") }, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de647 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(products.ProductCats.name_de) ") }, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_fr648 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(products.ProductCats.name_fr) ") }, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel649 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id645, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name646, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de647, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr648, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 153, "border": false, "frame": false, "labelAlign": "top" });
    var description654 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("description","(products.ProductCats.description) ") }, "fieldLabel": "description", "name": "description", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var ProductsByCategory_grid697 = new Lino.products.ProductsByCategory.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Products","(products.products.ProductsByCategory) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.products.ProductsByCategory.grid) ] });
    var main_panel698 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ main_1_panel649, { "flex": 5, "layout": "form", "xtype": "panel", "items": description654, "region": "center", "labelAlign": "top", "split": true }, ProductsByCategory_grid697 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel698;
    this.before_row_edit = function(record) {
      ProductsByCategory_grid697.on_master_changed();
    }
    Lino.products.ProductCats.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 18,
  initComponent : function() {
    var containing_panel = this;
    var prefix512 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("prefix","(contacts.Companies.prefix) ") }, "fieldLabel": "prefix", "name": "prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name513 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Companies.name) ") }, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_box_panel514 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix512, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name513, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var country517 = new Lino.TwinCombo({ "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Country","(contacts.Companies.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/country", "method": "GET" }) }) });
    var region518 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Region","(contacts.Companies.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/region", "method": "GET" }) }) });
    var city519 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Place","(contacts.Companies.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/city", "method": "GET" }) }) });
    var zip_code520 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Zip code","(contacts.Companies.zip_code) ") }, "fieldLabel": "Zip code", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_2_panel521 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country517, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region518, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city519, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code520, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr1526 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Address line before street","(contacts.Companies.addr1) Address line before street") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line before street</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_prefix527 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Street prefix","(contacts.Companies.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street prefix</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street528 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Street","(contacts.Companies.street) Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no529 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("No.","(contacts.Companies.street_no) House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box530 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","(contacts.Companies.street_box) Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_4_panel531 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix527, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street528, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no529, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box530, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2536 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Address line after street","(contacts.Companies.addr2) Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line after street</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var address_box_panel537 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "layout": "form", "title": "Address", "items": [ name_box_panel514, address_box_2_panel521, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1526, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel531, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2536, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 243, "border": false, "labelAlign": "top" });
    var id540 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Companies.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language541 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(contacts.Companies.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var info_box_panel542 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id540, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language541, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email545 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Companies.email) ") }, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var url546 = new Lino.URLField({ "listeners": { "render": Lino.quicktip_renderer("URL","(contacts.Companies.url) ") }, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var phone547 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Phone","(contacts.Companies.phone) ") }, "fieldLabel": "Phone", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gsm548 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("GSM","(contacts.Companies.gsm) ") }, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var fax549 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Fax","(contacts.Companies.fax) ") }, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var contact_box_5_panel550 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm548, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax549, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel553 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "layout": "form", "title": "Contact", "items": [ info_box_panel542, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email545, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url546, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone547, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel550 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var general_1_panel557 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ address_box_panel537, contact_box_panel553 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var type558 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Company type", "name": "type", "pageSize": 20, "emptyText": "Select a company type...", "listeners": { "render": Lino.quicktip_renderer("Company type","(contacts.Companies.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var vat_id559 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("VAT id","(contacts.Companies.vat_id) ") }, "fieldLabel": "VAT id", "name": "vat_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var bottom_box_1_panel560 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type558, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id559, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks563 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remarks","(contacts.Companies.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var contacts_RolesByCompany_grid568 = new Lino.contacts.RolesByCompany.GridPanel({ "flex": 42, "listeners": { "render": Lino.quicktip_renderer("Contact persons","(contacts.contacts.RolesByCompany) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.grid) ], "preview_limit": 15, "master_panel": this });
    var bottom_box_2_panel569 = new Ext.Panel({ "flex": 83, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": remarks563, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 57 }, contacts_RolesByCompany_grid568 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var bottom_box_panel571 = new Ext.Panel({ "flex": 54, "border": false, "layout": "vbox", "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ bottom_box_1_panel560, bottom_box_2_panel569 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": true, "labelAlign": "top" });
    var general_panel572 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel557, bottom_box_panel571 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var invoicing_address573 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Invoicing address", "name": "invoicing_address", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "hiddenName": "invoicing_addressHidden", "listeners": { "render": Lino.quicktip_renderer("Invoicing address","(contacts.Companies.invoicing_address) ") }, "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/invoicing_address", "method": "GET" }) }) });
    var vat_regime574 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">VAT Regime</span>", "name": "vat_regime", "hiddenName": "vat_regimeHidden", "listeners": { "render": Lino.quicktip_renderer("VAT Regime","(contacts.Companies.vat_regime) The default VAT regime for sales to this customer.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var imode575 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Invoicing Mode", "name": "imode", "pageSize": 20, "emptyText": "Select a Invoicing Mode...", "listeners": { "render": Lino.quicktip_renderer("Invoicing Mode","(contacts.Companies.imode) ") }, "selectOnFocus": true, "hiddenName": "imodeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/imode", "method": "GET" }) }) });
    var payment_term576 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Payment Term</span>", "name": "payment_term", "pageSize": 20, "emptyText": "Select a Payment Term...", "listeners": { "render": Lino.quicktip_renderer("Payment Term","(contacts.Companies.payment_term) The default payment term for sales invoices to this customer.") }, "selectOnFocus": true, "hiddenName": "payment_termHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/payment_term", "method": "GET" }) }) });
    var sales_1_panel577 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 162, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invoicing_address573, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_regime574, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": imode575, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": payment_term576, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var sales_InvoicesByPartner_grid582 = new Lino.sales.InvoicesByPartner.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Invoices","(sales.sales.InvoicesByPartner) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.sales.InvoicesByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var sales_panel583 = new Ext.Panel({ "layout": "vbox", "title": "Sales", "items": [ sales_1_panel577, sales_InvoicesByPartner_grid582 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel584 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel572, sales_panel583 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel584;
    this.before_row_edit = function(record) {
      region518.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city519.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city519.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByCompany_grid568.on_master_changed();
      sales_InvoicesByPartner_grid582.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country517.on('change',Lino.chooser_handler(region518,'country'));
      country517.on('change',Lino.chooser_handler(city519,'country'));
      region518.on('change',Lino.chooser_handler(city519,'region'));
      Lino.contacts.Companies.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Companies.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Countries.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 15,
  initComponent : function() {
    var containing_panel = this;
    var isocode149 = new Ext.form.TextField({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">ISO code</span>", "name": "isocode", "boxMinWidth": Lino.chars2width(4), "listeners": { "render": Lino.quicktip_renderer("ISO code","(countries.Countries.isocode)         The two-letter code for this country as defined by ISO 3166-1. \n        For countries that no longer exist it may be a 4-letter code.") }, "maxLength": 4, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name150 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation","(countries.Countries.name) ") }, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de151 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(countries.Countries.name_de) ") }, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_fr152 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(countries.Countries.name_fr) ") }, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var short_code153 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Short code","(countries.Countries.short_code) A short abbreviation for regional usage. Obsolete.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Short code</span>", "name": "short_code", "maxLength": 4, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var main_1_panel154 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": isocode149, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name150, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de151, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr152, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": short_code153, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var countries_CitiesByCountry_grid426 = new Lino.countries.CitiesByCountry.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Places","(countries.countries.CitiesByCountry) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.countries.CitiesByCountry.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel427 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel154, countries_CitiesByCountry_grid426 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel427;
    this.before_row_edit = function(record) {
      countries_CitiesByCountry_grid426.on_master_changed();
    }
    Lino.countries.Countries.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Cities.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 16,
  initComponent : function() {
    var containing_panel = this;
    var name168 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation","(countries.Cities.name) ") }, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de169 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(countries.Cities.name_de) ") }, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_fr170 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(countries.Cities.name_fr) ") }, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var country171 = new Lino.TwinCombo({ "fieldLabel": "Country", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Country","(countries.Cities.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/country", "method": "GET" }) }), "name": "country" });
    var main_1_panel172 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name168, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de169, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr170, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country171, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var type177 = new Lino.RemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Place Type","(countries.Cities.type) ") }, "fieldLabel": "Place Type", "name": "type", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/type", "method": "GET" }) }), "hiddenName": "typeHidden" });
    var parent178 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Part of</span>", "name": "parent", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Part of","(countries.Cities.parent) The superordinate geographic place of which this place is a part.") }, "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/parent", "method": "GET" }) }) });
    var zip_code179 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("zip code","(countries.Cities.zip_code) ") }, "fieldLabel": "zip code", "name": "zip_code", "maxLength": 8, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "anchor": "-20" });
    var id180 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(countries.Cities.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_2_panel181 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type177, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent178, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code179, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id180, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var CitiesByCity_grid423 = new Lino.countries.CitiesByCity.GridPanel({ "flex": 41, "listeners": { "render": Lino.quicktip_renderer("Subdivisions","(countries.countries.CitiesByCity) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.countries.CitiesByCity.grid) ], "preview_limit": 15, "master_panel": this });
    var contacts_PartnersByCity_grid424 = new Lino.contacts.PartnersByCity.GridPanel({ "flex": 41, "listeners": { "render": Lino.quicktip_renderer("Partners","(contacts.contacts.PartnersByCity) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.PartnersByCity.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel425 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel172, main_2_panel181, CitiesByCity_grid423, contacts_PartnersByCity_grid424 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel425;
    this.before_row_edit = function(record) {
      type177.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      CitiesByCity_grid423.on_master_changed();
      contacts_PartnersByCity_grid424.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country171.on('change',Lino.chooser_handler(type177,'country'));
      Lino.countries.Cities.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.countries.Cities.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.declarations.Declarations.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 33,
  initComponent : function() {
    var containing_panel = this;
    var date849 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Date","(declarations.Declarations.date) ") }, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var year850 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "year", "hiddenName": "yearHidden", "listeners": { "render": Lino.quicktip_renderer("Fiscal Year","(declarations.Declarations.year) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var period851 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "VAT Period", "allowBlank": false, "hiddenName": "periodHidden", "listeners": { "render": Lino.quicktip_renderer("VAT Period","(declarations.Declarations.period) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.declarations.DeclarationPeriods, "name": "period" });
    var main_panel852 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 108, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": date849, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": year850, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": period851, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel852;
    this.before_row_edit = function(record) {
    }
    Lino.declarations.Declarations.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.finan.BankStatements.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 40,
  initComponent : function() {
    var containing_panel = this;
    var date896 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Date","(finan.BankStatements.date) ") }, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var balance1897 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Old balance", "name": "balance1", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Old balance","(finan.BankStatements.balance1) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var balance2898 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "New balance", "name": "balance2", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("New balance","(finan.BankStatements.balance2) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var main_panel899 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 108, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": date896, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": balance1897, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": balance2898, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel899;
    this.before_row_edit = function(record) {
    }
    Lino.finan.BankStatements.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 18,
  initComponent : function() {
    var containing_panel = this;
    var name585 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Companies.name) ") }, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language586 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(contacts.Companies.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var email587 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Companies.email) ") }, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel588 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language586, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email587, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type591 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Company type", "name": "type", "pageSize": 20, "emptyText": "Select a company type...", "listeners": { "render": Lino.quicktip_renderer("Company type","(contacts.Companies.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var id592 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Companies.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_3_panel593 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type591, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id592, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel596 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name585, "anchor": "-20", "labelAlign": "top" }, main_2_panel588, main_3_panel593 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel596;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Companies.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.sales.Invoices.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 37,
  initComponent : function() {
    var containing_panel = this;
    var partner402 = new Lino.TwinCombo({ "preferred_width": 20, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Select a Partner...", "listeners": { "render": Lino.quicktip_renderer("Partner","(sales.Invoices.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/partner", "method": "GET" }) }), "name": "partner" });
    var date403 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Date","(sales.Invoices.date) ") }, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel404 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner402, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date403, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var subject407 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Subject line","(sales.Invoices.subject) ") }, "fieldLabel": "Subject line", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_panel408 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 117, "autoScroll": false, "items": [ main_1_panel404, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject407, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel408;
    this.before_row_edit = function(record) {
    }
    Lino.sales.Invoices.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.About.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var server_status_disp68 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Server status","(about.About.server_status) ") }, "fieldLabel": "Server status", "name": "server_status", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_panel69 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "html": "<div class=\"htmlText\"><span>This is <a href=\"http://www.lino-framework.org/autodoc/lino.projects.cosi\" target=\"_blank\">Lino Cos&#236;</a> 0.1 using <a href=\"http://www.lino-framework.org\" target=\"_blank\">Lino</a> 1.6.12, <a href=\"http://north.lino-framework.org\" target=\"_blank\">North</a> 0.1.7, <a href=\"http://site.lino-framework.org\" target=\"_blank\">djangosite</a> 0.1.8, <a href=\"http://www.djangoproject.com\" target=\"_blank\">Django</a> 1.5.1, <a href=\"http://www.python.org/\" target=\"_blank\">Python</a> 2.7.3, <a href=\"http://babel.edgewall.org/\" target=\"_blank\">Babel</a> 1.0, <a href=\"http://jinja.pocoo.org/\" target=\"_blank\">Jinja</a> 2.6, <a href=\"http://sphinx-doc.org/\" target=\"_blank\">Sphinx</a> 1.2b1, <a href=\"http://labix.org/python-dateutil\" target=\"_blank\">python-dateutil</a> 2.1, <a href=\"http://pypi.python.org/pypi/odfpy\" target=\"_blank\">OdfPy</a> ODFPY/0.9.6, <a href=\"http://docutils.sourceforge.net/\" target=\"_blank\">docutils</a> 0.8.1, <a href=\"https://fedorahosted.org/suds/\" target=\"_blank\">suds</a> 0.4, <a href=\"http://pyyaml.org/\" target=\"_blank\">PyYaml</a> 3.10, <a href=\"http://appyframework.org/pod.html\" target=\"_blank\">Appy</a> 0.8.3 (2013/02/22 15:29), <a href=\"http://www.sencha.com\" target=\"_blank\">ExtJS</a> <a href=\"#\" onclick=\"alert('ExtJS client version is ' + Ext.version);\" title=\"Click to see ExtJS client version\">(version)</a>, <a href=\"http://ext.ensible.com/products/calendar/\" target=\"_blank\">Extensible</a> <a href=\"#\" onclick=\"alert('Extensible Calendar version is ' + Ext.ensible.version);\" title=\"Click to see Extensible Calendar version\">(version)</a>, <a href=\"http://www.famfamfam.com/lab/icons/silk/\" target=\"_blank\">Silk Icons</a> 1.3</span><p>Server uptime : <b>Monday, September 23, 2013 at 20:34:19.500765</b></p><p>Source timestamps:</p><ul><li>lino : <b>Monday, September 23, 2013 at 17:36:59.048568</b></li><li>djangosite : <b>Sunday, September 15, 2013 at 15:07:52.398691</b></li><li>atelier : <b>Sunday, September 8, 2013 at 18:48:36.565282</b></li><li>django : <b>Friday, August 30, 2013 at 13:02:10.834631</b></li><li>north : <b>Wednesday, August 28, 2013 at 11:25:41.253661</b></li></ul></div>", "xtype": "label" }, { "items": server_status_disp68, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel69;
    this.before_row_edit = function(record) {
    }
    Lino.about.About.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.declarations.Declarations.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 33,
  initComponent : function() {
    var containing_panel = this;
    var date810 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Date","(declarations.Declarations.date) ") }, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var year811 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "year", "hiddenName": "yearHidden", "listeners": { "render": Lino.quicktip_renderer("Fiscal Year","(declarations.Declarations.year) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var period812 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "VAT Period", "allowBlank": false, "hiddenName": "periodHidden", "listeners": { "render": Lino.quicktip_renderer("VAT Period","(declarations.Declarations.period) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.declarations.DeclarationPeriods, "name": "period" });
    var user813 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(declarations.Declarations.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/declarations/Declarations/user", "method": "GET" }) }) });
    var workflow_buttons_disp814 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Workflow","(declarations.Declarations.workflow_buttons) ") }, "fieldLabel": "Workflow", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel815 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date810, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": year811, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": period812, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user813, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp814, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var sales_base821 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Sales base", "name": "sales_base", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Sales base","(declarations.Declarations.sales_base) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var sales_vat822 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Sales VAT", "name": "sales_vat", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Sales VAT","(declarations.Declarations.sales_vat) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var fields_1_panel823 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sales_base821, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sales_vat822, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var purchases_base826 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Purchases base", "name": "purchases_base", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Purchases base","(declarations.Declarations.purchases_base) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var purchases_vat827 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Purchases VAT", "name": "purchases_vat", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Purchases VAT","(declarations.Declarations.purchases_vat) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var fields_2_panel828 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": purchases_base826, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": purchases_vat827, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var purchases_investments831 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Investments", "name": "purchases_investments", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Investments","(declarations.Declarations.purchases_investments) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var purchases_ware832 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Ware", "name": "purchases_ware", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Ware","(declarations.Declarations.purchases_ware) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var purchases_services833 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Services", "name": "purchases_services", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Services","(declarations.Declarations.purchases_services) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var fields_3_panel834 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": purchases_investments831, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": purchases_ware832, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": purchases_services833, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var fields_panel838 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ fields_1_panel823, fields_2_panel828, fields_3_panel834 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var VouchersByDeclaration_grid847 = new Lino.declarations.VouchersByDeclaration.GridPanel({ "flex": 45, "listeners": { "render": Lino.quicktip_renderer("Vouchers","(declarations.declarations.VouchersByDeclaration) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.declarations.VouchersByDeclaration.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel848 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel815, fields_panel838, VouchersByDeclaration_grid847 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel848;
    this.before_row_edit = function(record) {
      VouchersByDeclaration_grid847.on_master_changed();
    }
    Lino.declarations.Declarations.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.Report.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var body_htmlbox945 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "body", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer(null,"(lino.Report.body) ") } });
    var main_panel946 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ body_htmlbox945 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel946;
    this.before_row_edit = function(record) {
      body_htmlbox945.refresh();
    }
    Lino.lino.Report.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.finan.BankStatements.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 40,
  initComponent : function() {
    var containing_panel = this;
    var date856 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Date","(finan.BankStatements.date) ") }, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var balance1857 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Old balance", "name": "balance1", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Old balance","(finan.BankStatements.balance1) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var balance2858 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "New balance", "name": "balance2", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("New balance","(finan.BankStatements.balance2) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var user859 = new Lino.TwinCombo({ "preferred_width": 15, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(finan.BankStatements.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/BankStatements/user", "method": "GET" }) }) });
    var workflow_buttons_disp860 = new Ext.form.DisplayField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Workflow","(finan.BankStatements.workflow_buttons) ") }, "fieldLabel": "Workflow", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var general_1_panel861 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date856, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": balance1857, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": balance2858, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user859, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp860, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var finan_ItemsByStatement_grid880 = new Lino.finan.ItemsByStatement.GridPanel({ "flex": 62, "listeners": { "render": Lino.quicktip_renderer("Items","(finan.finan.ItemsByStatement) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.finan.ItemsByStatement.grid) ], "preview_limit": 15, "master_panel": this });
    var general_panel881 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel861, finan_ItemsByStatement_grid880 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var id882 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(finan.BankStatements.id) ") }, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var journal883 = new Lino.TwinCombo({ "fieldLabel": "Journal", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail)}, "emptyText": "Select a Journal...", "listeners": { "render": Lino.quicktip_renderer("Journal","(finan.BankStatements.journal) ") }, "selectOnFocus": true, "hiddenName": "journalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/BankStatements/journal", "method": "GET" }) }), "name": "journal" });
    var year884 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "year", "hiddenName": "yearHidden", "listeners": { "render": Lino.quicktip_renderer("Fiscal Year","(finan.BankStatements.year) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var number885 = new Ext.form.NumberField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("number","(finan.BankStatements.number) ") }, "fieldLabel": "number", "anchor": "-20", "name": "number" });
    var narration886 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Narration","(finan.BankStatements.narration) ") }, "fieldLabel": "Narration", "name": "narration", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var ledger_1_panel887 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id882, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": journal883, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": year884, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": number885, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": narration886, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ledger_MovementsByVoucher_grid893 = new Lino.ledger.MovementsByVoucher.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Movements","(ledger.ledger.MovementsByVoucher) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.ledger.MovementsByVoucher.grid) ], "preview_limit": 15, "master_panel": this });
    var ledger_panel894 = new Ext.Panel({ "layout": "vbox", "title": "Ledger", "items": [ ledger_1_panel887, ledger_MovementsByVoucher_grid893 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel895 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel881, ledger_panel894 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel895;
    this.before_row_edit = function(record) {
      finan_ItemsByStatement_grid880.on_master_changed();
      ledger_MovementsByVoucher_grid893.on_master_changed();
    }
    Lino.finan.BankStatements.DetailFormPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.merge_row = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Persons.merge_row_ActionFormPanel({});
});
Lino.contacts.Companies.merge_row = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Companies.merge_row_ActionFormPanel({});
});

// js_render_GridPanel_class system.SiteConfigs
Lino.system.SiteConfigs.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/system/SiteConfigs",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/system/SiteConfigs','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/SiteConfigs','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/SiteConfigs','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "do_build", "menu_item_text": "Rebuild site cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('do_build','GET',null), "text": "Rebuild site cache", "overflowText": "Rebuild site cache", "auto_save": true } ],
  cell_edit : true,
  title : "site configs",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 19,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "default_build_method" }, 'default_build_methodHidden', { "type": "int", "name": "next_partner_id" }, { "name": "site_company" }, 'site_companyHidden', { "name": "clients_account" }, 'clients_accountHidden', { "name": "sales_vat_account" }, 'sales_vat_accountHidden', { "name": "sales_account" }, 'sales_accountHidden', { "name": "suppliers_account" }, 'suppliers_accountHidden', { "name": "purchases_vat_account" }, 'purchases_vat_accountHidden', { "name": "purchases_account" }, 'purchases_accountHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 8,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.system.SiteConfigs.detail;
    var ww = this.containing_window;
    var id950 = new Ext.form.NumberField({ "selectOnFocus": true });
    var default_build_method951 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "value": "appyodt" });
    var next_partner_id952 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 100 });
    var site_company953 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/site_company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Company..." });
    var clients_account954 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/clients_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var sales_vat_account955 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/sales_vat_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var sales_account956 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/sales_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var suppliers_account957 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/suppliers_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var purchases_vat_account958 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/purchases_vat_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var purchases_account959 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/purchases_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.SiteConfigs.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id950, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Default build method", "editable": true, "tooltip": "(system.SiteConfigs.default_build_method) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "default_build_method", "editor": default_build_method951 }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.SiteConfigs.next_partner_id) The next automatic id for any new partner.", "filter": { "type": "numeric" }, "header": "Next partner id", "dataIndex": "next_partner_id", "width": Lino.chars2width(6), "editor": next_partner_id952 }), { "colIndex": 3, "sortable": true, "header": "The company that runs this site", "editable": true, "tooltip": "(system.SiteConfigs.site_company) The Company to be used as sender in documents.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('site_companyHidden','Lino.contacts.Companies.detail'), "editor": site_company953, "dataIndex": "site_company" }, { "colIndex": 4, "sortable": true, "header": "Clients account", "editable": true, "tooltip": "(system.SiteConfigs.clients_account) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "clients_account", "editor": clients_account954 }, { "colIndex": 5, "sortable": true, "header": "Sales VAT account", "editable": true, "tooltip": "(system.SiteConfigs.sales_vat_account) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "sales_vat_account", "editor": sales_vat_account955 }, { "colIndex": 6, "sortable": true, "header": "Sales Base account", "editable": true, "tooltip": "(system.SiteConfigs.sales_account) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "sales_account", "editor": sales_account956 }, { "colIndex": 7, "sortable": true, "header": "Suppliers account", "editable": true, "tooltip": "(system.SiteConfigs.suppliers_account) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "suppliers_account", "editor": suppliers_account957 }, { "colIndex": 8, "sortable": true, "header": "Purchases VAT account", "editable": true, "tooltip": "(system.SiteConfigs.purchases_vat_account) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "purchases_vat_account", "editor": purchases_vat_account958 }, { "colIndex": 9, "sortable": true, "header": "Purchases Base account", "editable": true, "tooltip": "(system.SiteConfigs.purchases_account) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "purchases_account", "editor": purchases_account959 } ];
    Lino.system.SiteConfigs.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.system.SiteConfigs.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/SiteConfigs","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.system.SiteConfigs.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/SiteConfigs","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.system.SiteConfigs.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/SiteConfigs","GET",pk,"put",null);
};
Lino.system.SiteConfigs.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/SiteConfigs","GET",pk,"post",null);
};

Lino.system.SiteConfigs.detailPanel = Ext.extend(Lino.system.SiteConfigs.DetailFormPanel,{
  empty_title: "Detail site configs",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "do_build", "menu_item_text": "Rebuild site cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('do_build','GET',null), "text": "Rebuild site cache", "overflowText": "Rebuild site cache", "auto_save": true } ],
  ls_url: "/system/SiteConfigs",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.SiteConfigs.detail;
    Lino.system.SiteConfigs.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.system.SiteConfigs.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.system.SiteConfigs.detailPanel(p);
});
Lino.system.SiteConfigs.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.system.SiteConfigs.GridPanel(p);
});
Lino.system.SiteConfigs.do_build = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/SiteConfigs","GET",pk,"do_build",null);
};

// js_render_GridPanel_class system.ContentTypes
Lino.system.ContentTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/system/ContentTypes",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/system/ContentTypes','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/ContentTypes','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/ContentTypes','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "content types",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 5,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "app_label" }, { "name": "model" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 3,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.system.ContentTypes.detail;
    this.ls_insert_handler = Lino.system.ContentTypes.insert;
    var ww = this.containing_window;
    var id961 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name962 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var app_label963 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var model964 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.ContentTypes.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id961, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "name", "editable": true, "tooltip": "(system.ContentTypes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name962 }, { "colIndex": 2, "sortable": true, "header": "app label", "editable": true, "tooltip": "(system.ContentTypes.app_label) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "app_label", "editor": app_label963 }, { "colIndex": 3, "sortable": true, "header": "python model class name", "editable": true, "tooltip": "(system.ContentTypes.model) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "model", "editor": model964 } ];
    Lino.system.ContentTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.system.ContentTypes.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/ContentTypes","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.system.ContentTypes.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/ContentTypes","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.system.ContentTypes.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/ContentTypes","GET",pk,"put",null);
};
Lino.system.ContentTypes.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/ContentTypes","GET",pk,"post",null);
};

Lino.system.ContentTypes.insertPanel = Ext.extend(Lino.system.ContentTypes.DetailFormPanel,{
  empty_title: "New content types",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/system/ContentTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.ContentTypes.detail;
    this.ls_insert_handler = Lino.system.ContentTypes.insert;
    Lino.system.ContentTypes.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.system.ContentTypes.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.system.ContentTypes.insertPanel(p);
});
Lino.system.ContentTypes.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/ContentTypes","GET",pk,"poststay",null);
};

Lino.system.ContentTypes.detailPanel = Ext.extend(Lino.system.ContentTypes.DetailFormPanel,{
  empty_title: "Detail content types",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/system/ContentTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.ContentTypes.detail;
    this.ls_insert_handler = Lino.system.ContentTypes.insert;
    Lino.system.ContentTypes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.system.ContentTypes.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.system.ContentTypes.detailPanel(p);
});
Lino.system.ContentTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.system.ContentTypes.GridPanel(p);
});

// js_render_GridPanel_class system.HelpTexts
Lino.system.HelpTexts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/system/HelpTexts",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/system/HelpTexts','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/HelpTexts','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/HelpTexts','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Help Texts",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "name": "field" }, { "name": "verbose_name" }, { "name": "help_text" }, { "type": "int", "name": "id" }, { "name": "content_type" }, 'content_typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 9,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var field966 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/HelpTexts/field", "method": "GET" }) }) });
    var verbose_name967 = new Ext.form.TextField({ "disabled": true, "maxLength": 200 });
    var help_text968 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var id969 = new Ext.form.NumberField({ "selectOnFocus": true });
    var content_type970 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/HelpTexts/content_type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a content type..." });
    this.before_row_edit = function(record) {
      field966.setContextValue('content_type',record ? record.data['content_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      content_type970.on('change',Lino.chooser_handler(field966,'content_type'));
      Lino.system.HelpTexts.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Field", "editable": true, "tooltip": "(system.HelpTexts.field) The name of the field.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "field", "editor": field966 }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "verbose_name", "header": "Verbose name", "editable": false, "tooltip": "(system.HelpTexts.verbose_name) " }, { "colIndex": 2, "sortable": false, "header": "HelpText", "editable": true, "tooltip": "(system.HelpTexts.help_text) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": help_text968, "dataIndex": "help_text" }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.HelpTexts.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id969, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Model", "editable": true, "tooltip": "(system.HelpTexts.content_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('content_typeHidden','Lino.system.ContentTypes.detail'), "editor": content_type970, "dataIndex": "content_type" } ];
    Lino.system.HelpTexts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.system.HelpTexts.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/HelpTexts","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.system.HelpTexts.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/HelpTexts","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.system.HelpTexts.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/HelpTexts","GET",pk,"put",null);
};
Lino.system.HelpTexts.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/HelpTexts","GET",pk,"post",null);
};
Lino.system.HelpTexts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.system.HelpTexts.GridPanel(p);
});

// js_render_GridPanel_class system.TextFieldTemplates
Lino.system.TextFieldTemplates.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/system/TextFieldTemplates",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/system/TextFieldTemplates','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/TextFieldTemplates','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/TextFieldTemplates','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Text Field Templates",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "name" }, { "name": "team" }, 'teamHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 10,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.system.TextFieldTemplates.detail;
    this.ls_insert_handler = Lino.system.TextFieldTemplates.insert;
    var ww = this.containing_window;
    var id972 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user973 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var name974 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var team975 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/team", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Team..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.TextFieldTemplates.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id972, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Author", "editable": true, "tooltip": "(system.TextFieldTemplates.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user973, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(system.TextFieldTemplates.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name974 }, { "colIndex": 3, "sortable": true, "header": "Team", "editable": true, "tooltip": "(system.TextFieldTemplates.team) If not empty, then this template is reserved to members of this team.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "team", "editor": team975 } ];
    Lino.system.TextFieldTemplates.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.system.TextFieldTemplates.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/TextFieldTemplates","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.system.TextFieldTemplates.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/TextFieldTemplates","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.system.TextFieldTemplates.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/TextFieldTemplates","GET",pk,"put",null);
};
Lino.system.TextFieldTemplates.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/TextFieldTemplates","GET",pk,"post",null);
};

Lino.system.TextFieldTemplates.insertPanel = Ext.extend(Lino.system.TextFieldTemplates.InsertFormPanel,{
  empty_title: "New Text Field Templates",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/system/TextFieldTemplates",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.TextFieldTemplates.detail;
    this.ls_insert_handler = Lino.system.TextFieldTemplates.insert;
    Lino.system.TextFieldTemplates.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.system.TextFieldTemplates.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.system.TextFieldTemplates.insertPanel(p);
});
Lino.system.TextFieldTemplates.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/TextFieldTemplates","GET",pk,"poststay",null);
};

Lino.system.TextFieldTemplates.detailPanel = Ext.extend(Lino.system.TextFieldTemplates.DetailFormPanel,{
  empty_title: "Detail Text Field Templates",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/system/TextFieldTemplates",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.TextFieldTemplates.detail;
    this.ls_insert_handler = Lino.system.TextFieldTemplates.insert;
    Lino.system.TextFieldTemplates.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.system.TextFieldTemplates.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.system.TextFieldTemplates.detailPanel(p);
});
Lino.system.TextFieldTemplates.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.system.TextFieldTemplates.GridPanel(p);
});

// js_render_GridPanel_class users.Users
Lino.users.Users.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/Users",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/users/Users','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Users','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Users','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Users",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 17,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "first_name" }, { "name": "last_name" }, { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "password" }, { "name": "initials" }, { "name": "email" }, { "name": "remarks" }, { "name": "language" }, 'languageHidden', { "name": "partner" }, 'partnerHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 12,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    var ww = this.containing_window;
    var username977 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile978 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var first_name979 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var last_name980 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var id981 = new Ext.form.NumberField({ "selectOnFocus": true });
    var created982 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified983 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var password984 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 128 });
    var initials985 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var email986 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var remarks987 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var language988 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ] });
    var partner989 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Username", "editable": true, "tooltip": "(users.Users.username) Required. Must be unique.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "username", "editor": username977 }, { "colIndex": 1, "sortable": true, "header": "User Profile", "editable": true, "tooltip": "(users.Users.profile) Users with an empty `profile` field are considered inactive and cannot log in.", "filter": { "type": "string" }, "width": Lino.chars2width(23), "dataIndex": "profile", "editor": profile978 }, { "colIndex": 2, "sortable": true, "header": "First name", "editable": true, "tooltip": "(users.Users.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name979 }, { "colIndex": 3, "sortable": true, "header": "Last name", "editable": true, "tooltip": "(users.Users.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name980 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.Users.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id981, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(17), "colIndex": 5, "sortable": true, "dataIndex": "created", "header": "Created", "editable": false, "tooltip": "(users.Users.created) " }, { "width": Lino.chars2width(17), "colIndex": 6, "sortable": true, "dataIndex": "modified", "header": "Modified", "editable": false, "tooltip": "(users.Users.modified) " }, { "colIndex": 7, "sortable": true, "header": "Password", "editable": true, "tooltip": "(users.Users.password) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "password", "hidden": true, "editor": password984 }, { "colIndex": 8, "sortable": true, "header": "Initials", "editable": true, "tooltip": "(users.Users.initials) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "initials", "editor": initials985 }, { "colIndex": 9, "sortable": true, "header": "e-mail address", "editable": true, "tooltip": "(users.Users.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email986 }, { "colIndex": 10, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(users.Users.remarks) ", "filter": { "type": "string" }, "header": "Remarks", "renderer": Lino.text_renderer, "hidden": true, "editor": remarks987, "dataIndex": "remarks" }, { "colIndex": 11, "sortable": true, "header": "Language", "editable": true, "tooltip": "(users.Users.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language988 }, { "colIndex": 12, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(users.Users.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner989, "dataIndex": "partner" } ];
    Lino.users.Users.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Users.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Users","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.users.Users.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Users","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.users.Users.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Users","GET",pk,"put",null);
};
Lino.users.Users.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Users","GET",pk,"post",null);
};

Lino.users.Users.insertPanel = Ext.extend(Lino.users.Users.InsertFormPanel,{
  empty_title: "New Users",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/users/Users",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.Users.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Users.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.Users.insertPanel(p);
});
Lino.users.Users.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Users","GET",pk,"poststay",null);
};

Lino.users.Users.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Detail Users",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/users/Users",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.Users.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Users.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Users.detailPanel(p);
});
Lino.users.Users.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Users.GridPanel(p);
});

// js_render_GridPanel_class users.MySettings
Lino.users.MySettings.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/MySettings",
  ls_bbar_actions : [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false } ],
  cell_edit : true,
  title : "Users",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 17,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "first_name" }, { "name": "last_name" }, { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "password" }, { "name": "initials" }, { "name": "email" }, { "name": "remarks" }, { "name": "language" }, 'languageHidden', { "name": "partner" }, 'partnerHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 12,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    var ww = this.containing_window;
    var username71 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile72 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var first_name73 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var last_name74 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var id75 = new Ext.form.NumberField({ "selectOnFocus": true });
    var created76 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified77 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var password78 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 128 });
    var initials79 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var email80 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var remarks81 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var language82 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ] });
    var partner83 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Username", "editable": true, "tooltip": "(users.MySettings.username) Required. Must be unique.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "username", "editor": username71 }, { "colIndex": 1, "sortable": true, "header": "User Profile", "editable": true, "tooltip": "(users.MySettings.profile) Users with an empty `profile` field are considered inactive and cannot log in.", "filter": { "type": "string" }, "width": Lino.chars2width(23), "dataIndex": "profile", "editor": profile72 }, { "colIndex": 2, "sortable": true, "header": "First name", "editable": true, "tooltip": "(users.MySettings.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name73 }, { "colIndex": 3, "sortable": true, "header": "Last name", "editable": true, "tooltip": "(users.MySettings.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name74 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.MySettings.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id75, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(17), "colIndex": 5, "sortable": true, "dataIndex": "created", "header": "Created", "editable": false, "tooltip": "(users.MySettings.created) " }, { "width": Lino.chars2width(17), "colIndex": 6, "sortable": true, "dataIndex": "modified", "header": "Modified", "editable": false, "tooltip": "(users.MySettings.modified) " }, { "colIndex": 7, "sortable": true, "header": "Password", "editable": true, "tooltip": "(users.MySettings.password) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "password", "hidden": true, "editor": password78 }, { "colIndex": 8, "sortable": true, "header": "Initials", "editable": true, "tooltip": "(users.MySettings.initials) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "initials", "editor": initials79 }, { "colIndex": 9, "sortable": true, "header": "e-mail address", "editable": true, "tooltip": "(users.MySettings.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email80 }, { "colIndex": 10, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(users.MySettings.remarks) ", "filter": { "type": "string" }, "header": "Remarks", "renderer": Lino.text_renderer, "hidden": true, "editor": remarks81, "dataIndex": "remarks" }, { "colIndex": 11, "sortable": true, "header": "Language", "editable": true, "tooltip": "(users.MySettings.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language82 }, { "colIndex": 12, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(users.MySettings.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner83, "dataIndex": "partner" } ];
    Lino.users.MySettings.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MySettings","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.users.MySettings.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MySettings","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.users.MySettings.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MySettings","GET",pk,"put",null);
};
Lino.users.MySettings.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MySettings","GET",pk,"post",null);
};

Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Users",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});

Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Users",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});

// js_render_GridPanel_class users.UsersOverview
Lino.users.UsersOverview.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/UsersOverview",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/users/UsersOverview','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/UsersOverview','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/UsersOverview','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Users",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "language" }, 'languageHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 12,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.UsersOverview.detail;
    this.ls_insert_handler = Lino.users.UsersOverview.insert;
    var ww = this.containing_window;
    var username102 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile103 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var language104 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ] });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Username", "editable": true, "tooltip": "(users.UsersOverview.username) Required. Must be unique.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "username", "editor": username102 }, { "colIndex": 1, "sortable": true, "header": "User Profile", "editable": true, "tooltip": "(users.UsersOverview.profile) Users with an empty `profile` field are considered inactive and cannot log in.", "filter": { "type": "string" }, "width": Lino.chars2width(23), "dataIndex": "profile", "editor": profile103 }, { "colIndex": 2, "sortable": true, "header": "Language", "editable": true, "tooltip": "(users.UsersOverview.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language104 } ];
    Lino.users.UsersOverview.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.UsersOverview.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/UsersOverview","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.users.UsersOverview.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/UsersOverview","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.users.UsersOverview.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/UsersOverview","GET",pk,"put",null);
};
Lino.users.UsersOverview.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/UsersOverview","GET",pk,"post",null);
};

Lino.users.UsersOverview.insertPanel = Ext.extend(Lino.users.Users.InsertFormPanel,{
  empty_title: "New Users",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/users/UsersOverview",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.UsersOverview.detail;
    this.ls_insert_handler = Lino.users.UsersOverview.insert;
    Lino.users.UsersOverview.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.users.UsersOverview.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.UsersOverview.insertPanel(p);
});
Lino.users.UsersOverview.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/UsersOverview","GET",pk,"poststay",null);
};

Lino.users.UsersOverview.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Detail Users",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/users/UsersOverview",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.UsersOverview.detail;
    this.ls_insert_handler = Lino.users.UsersOverview.insert;
    Lino.users.UsersOverview.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.UsersOverview.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.UsersOverview.detailPanel(p);
});
Lino.users.UsersOverview.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.UsersOverview.GridPanel(p);
});

// js_render_GridPanel_class users.Teams
Lino.users.Teams.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/Teams",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/users/Teams','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Teams','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Teams','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Teams",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 5,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 14,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id991 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name992 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de993 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr994 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.Teams.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id991, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(users.Teams.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name992 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(users.Teams.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de993 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(users.Teams.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr994 } ];
    Lino.users.Teams.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Teams.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Teams","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.users.Teams.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Teams","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.users.Teams.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Teams","GET",pk,"put",null);
};
Lino.users.Teams.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Teams","GET",pk,"post",null);
};
Lino.users.Teams.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Teams.GridPanel(p);
});

// js_render_GridPanel_class users.Memberships
Lino.users.Memberships.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/Memberships",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/users/Memberships','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Memberships','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Memberships','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Memberships",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "team" }, 'teamHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 11,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id996 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user997 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Memberships/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var team998 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Memberships/team", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Team..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.Memberships.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id996, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Author", "editable": true, "tooltip": "(users.Memberships.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user997, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "Team", "editable": true, "tooltip": "(users.Memberships.team) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "team", "editor": team998 } ];
    Lino.users.Memberships.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Memberships.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Memberships","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.users.Memberships.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Memberships","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.users.Memberships.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Memberships","GET",pk,"put",null);
};
Lino.users.Memberships.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Memberships","GET",pk,"post",null);
};
Lino.users.Memberships.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Memberships.GridPanel(p);
});

// js_render_GridPanel_class users.Authorities
Lino.users.Authorities.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/Authorities",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/users/Authorities','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Authorities','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Authorities','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Authorities",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "authorized" }, 'authorizedHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 13,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id1000 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1001 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Authorities/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var authorized1002 = new Lino.RemoteComboFieldElement({ "preferred_width": 15, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Authorities/authorized", "method": "GET" }) }), "emptyText": "Select a User..." });
    this.before_row_edit = function(record) {
      authorized1002.setContextValue('user',record ? record.data['userHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      user1001.on('change',Lino.chooser_handler(authorized1002,'user'));
      Lino.users.Authorities.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.Authorities.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1000, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Author", "editable": true, "tooltip": "(users.Authorities.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1001, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "User", "editable": true, "tooltip": "(users.Authorities.authorized) The user who gets authority to act in your name.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('authorizedHidden','Lino.users.Users.detail'), "editor": authorized1002, "dataIndex": "authorized" } ];
    Lino.users.Authorities.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Authorities.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Authorities","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.users.Authorities.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Authorities","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.users.Authorities.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Authorities","GET",pk,"put",null);
};
Lino.users.Authorities.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Authorities","GET",pk,"post",null);
};
Lino.users.Authorities.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Authorities.GridPanel(p);
});

// js_render_GridPanel_class countries.Countries
Lino.countries.Countries.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/countries/Countries",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/countries/Countries','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/countries/Countries','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/countries/Countries','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Countries",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "isocode" }, { "name": "short_code" }, { "name": "iso3" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 15,
  ls_id_property : "isocode",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    var ww = this.containing_window;
    var name1004 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1005 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1006 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var isocode1007 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "allowBlank": false, "maxLength": 4 });
    var short_code1008 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    var iso31009 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "maxLength": 3 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(countries.Countries.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1004 }, { "colIndex": 1, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(countries.Countries.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de1005 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(countries.Countries.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1006 }, { "colIndex": 3, "sortable": true, "header": "ISO code", "editable": true, "tooltip": "(countries.Countries.isocode)         The two-letter code for this country as defined by ISO 3166-1. \n        For countries that no longer exist it may be a 4-letter code.", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "isocode", "editor": isocode1007 }, { "colIndex": 4, "sortable": true, "header": "Short code", "editable": true, "tooltip": "(countries.Countries.short_code) A short abbreviation for regional usage. Obsolete.", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "short_code", "editor": short_code1008 }, { "colIndex": 5, "sortable": true, "header": "ISO-3 code", "editable": true, "tooltip": "(countries.Countries.iso3) The three-letter code for this country as defined by ISO 3166-1.", "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "iso3", "editor": iso31009 } ];
    Lino.countries.Countries.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Countries","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.countries.Countries.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Countries","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.countries.Countries.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Countries","GET",pk,"put",null);
};
Lino.countries.Countries.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Countries","GET",pk,"post",null);
};

Lino.countries.Countries.insertPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "New Countries",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/countries/Countries",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    Lino.countries.Countries.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Countries.insertPanel(p);
});
Lino.countries.Countries.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Countries","GET",pk,"poststay",null);
};

Lino.countries.Countries.detailPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "Detail Countries",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/countries/Countries",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    Lino.countries.Countries.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.detailPanel(p);
});
Lino.countries.Countries.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.GridPanel(p);
});

// js_render_GridPanel_class countries.Cities
Lino.countries.Cities.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/countries/Cities",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/countries/Cities','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/countries/Cities','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/countries/Cities','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Places",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 12,
  ls_store_fields : [ { "name": "country" }, 'countryHidden', { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "type" }, 'typeHidden', { "name": "zip_code" }, { "type": "int", "name": "id" }, { "name": "parent" }, 'parentHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 8,
  ls_grid_configs : [  ],
  content_type : 16,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Cities.detail;
    this.ls_insert_handler = Lino.countries.Cities.insert;
    var ww = this.containing_window;
    var country1011 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/country", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Country..." });
    var name1012 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1013 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1014 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type1015 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/type", "method": "GET" }) }) });
    var zip_code1016 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "maxLength": 8 });
    var id1017 = new Ext.form.NumberField({ "selectOnFocus": true });
    var parent1018 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/parent", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    this.before_row_edit = function(record) {
      type1015.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country1011.on('change',Lino.chooser_handler(type1015,'country'));
      Lino.countries.Cities.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Country", "editable": true, "tooltip": "(countries.Cities.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country1011, "dataIndex": "country" }, { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(countries.Cities.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1012 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(countries.Cities.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de1013 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(countries.Cities.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1014 }, { "colIndex": 4, "sortable": true, "header": "Place Type", "editable": true, "tooltip": "(countries.Cities.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "type", "editor": type1015 }, { "colIndex": 5, "sortable": true, "header": "zip code", "editable": true, "tooltip": "(countries.Cities.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "zip_code", "editor": zip_code1016 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(countries.Cities.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1017, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 7, "sortable": true, "header": "Part of", "editable": true, "tooltip": "(countries.Cities.parent) The superordinate geographic place of which this place is a part.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('parentHidden','Lino.countries.Cities.detail'), "editor": parent1018, "dataIndex": "parent" } ];
    Lino.countries.Cities.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Cities.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Cities","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.countries.Cities.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Cities","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.countries.Cities.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Cities","GET",pk,"put",null);
};
Lino.countries.Cities.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Cities","GET",pk,"post",null);
};

Lino.countries.Cities.insertPanel = Ext.extend(Lino.countries.Cities.DetailFormPanel,{
  empty_title: "New Places",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/countries/Cities",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Cities.detail;
    this.ls_insert_handler = Lino.countries.Cities.insert;
    Lino.countries.Cities.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Cities.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Cities.insertPanel(p);
});
Lino.countries.Cities.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Cities","GET",pk,"poststay",null);
};

Lino.countries.Cities.detailPanel = Ext.extend(Lino.countries.Cities.DetailFormPanel,{
  empty_title: "Detail Places",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/countries/Cities",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Cities.detail;
    this.ls_insert_handler = Lino.countries.Cities.insert;
    Lino.countries.Cities.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Cities.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Cities.detailPanel(p);
});
Lino.countries.Cities.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Cities.GridPanel(p);
});

// js_render_GridPanel_class contacts.CompanyTypes
Lino.contacts.CompanyTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/CompanyTypes",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/contacts/CompanyTypes','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/CompanyTypes','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/CompanyTypes','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "company types",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 8,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "type": "int", "name": "id" }, { "name": "abbr" }, { "name": "abbr_de" }, { "name": "abbr_fr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 22,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var name1020 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1021 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1022 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1023 = new Ext.form.NumberField({ "selectOnFocus": true });
    var abbr1024 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var abbr_de1025 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var abbr_fr1026 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(contacts.CompanyTypes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1020 }, { "colIndex": 1, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(contacts.CompanyTypes.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de1021 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(contacts.CompanyTypes.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1022 }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.CompanyTypes.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1023, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Abbreviation", "editable": true, "tooltip": "(contacts.CompanyTypes.abbr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "abbr", "editor": abbr1024 }, { "colIndex": 5, "sortable": true, "header": "Abbreviation (de)", "editable": true, "tooltip": "(contacts.CompanyTypes.abbr_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "abbr_de", "editor": abbr_de1025 }, { "colIndex": 6, "sortable": true, "header": "Abbreviation (fr)", "editable": true, "tooltip": "(contacts.CompanyTypes.abbr_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "abbr_fr", "editor": abbr_fr1026 } ];
    Lino.contacts.CompanyTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.CompanyTypes.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/CompanyTypes","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.contacts.CompanyTypes.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/CompanyTypes","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.contacts.CompanyTypes.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/CompanyTypes","GET",pk,"put",null);
};
Lino.contacts.CompanyTypes.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/CompanyTypes","GET",pk,"post",null);
};
Lino.contacts.CompanyTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.CompanyTypes.GridPanel(p);
});

// js_render_GridPanel_class contacts.Partners
Lino.contacts.Partners.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Partners",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/contacts/Partners','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/Partners','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/Partners','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true }, { "itemId": "print_labels", "menu_item_text": "Labels", "must_save": true, "tooltip": "Generate mailing labels for these recipients", "panel_btn_handler": Lino.list_action_handler('/contacts/Partners','print_labels','GET',Lino.get_current_grid_config), "text": "Labels", "overflowText": "Labels", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Partners",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 32,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "name": "invoicing_address" }, 'invoicing_addressHidden', { "name": "payment_term" }, 'payment_termHidden', { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "imode" }, 'imodeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 30,
  ls_grid_configs : [  ],
  content_type : 21,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    var ww = this.containing_window;
    var name1028 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email1029 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var country1030 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Country..." });
    var city1031 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var region1032 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var zip_code1033 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr11034 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix1035 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street1036 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no1037 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box1038 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr21039 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language1040 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ] });
    var url1041 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone1042 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm1043 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax1044 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks1045 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var invoicing_address1046 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/invoicing_address", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var payment_term1047 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Payment Term..." });
    var vat_regime1048 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var imode1049 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Invoicing Mode..." });
    var id1050 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city1031.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1031.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region1032.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country1030.on('change',Lino.chooser_handler(city1031,'country'));
      region1032.on('change',Lino.chooser_handler(city1031,'region'));
      country1030.on('change',Lino.chooser_handler(region1032,'country'));
      Lino.contacts.Partners.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.Partners.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1028 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.Partners.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email1029 }, { "colIndex": 2, "sortable": true, "header": "Country", "editable": true, "tooltip": "(contacts.Partners.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country1030, "dataIndex": "country" }, { "colIndex": 3, "sortable": true, "header": "Place", "editable": true, "tooltip": "(contacts.Partners.city) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail'), "editor": city1031, "dataIndex": "city" }, { "colIndex": 4, "sortable": true, "header": "Region", "editable": true, "tooltip": "(contacts.Partners.region) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail'), "editor": region1032, "dataIndex": "region" }, { "colIndex": 5, "sortable": true, "header": "Zip code", "editable": true, "tooltip": "(contacts.Partners.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code1033 }, { "colIndex": 6, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "(contacts.Partners.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr11034 }, { "colIndex": 7, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "(contacts.Partners.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix1035 }, { "colIndex": 8, "sortable": true, "header": "Street", "editable": true, "tooltip": "(contacts.Partners.street) Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street1036 }, { "colIndex": 9, "sortable": true, "header": "No.", "editable": true, "tooltip": "(contacts.Partners.street_no) House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no1037 }, { "colIndex": 10, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.Partners.street_box) Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box1038 }, { "colIndex": 11, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "(contacts.Partners.addr2) Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr21039 }, { "colIndex": 12, "sortable": true, "header": "Language", "editable": true, "tooltip": "(contacts.Partners.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language1040 }, { "colIndex": 13, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.Partners.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url1041 }, { "colIndex": 14, "sortable": true, "header": "Phone", "editable": true, "tooltip": "(contacts.Partners.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone1042 }, { "colIndex": 15, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.Partners.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm1043 }, { "colIndex": 16, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.Partners.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax1044 }, { "colIndex": 17, "sortable": false, "header": "Remarks", "editable": true, "tooltip": "(contacts.Partners.remarks) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks1045, "dataIndex": "remarks" }, { "colIndex": 18, "sortable": true, "header": "Invoicing address", "editable": true, "tooltip": "(contacts.Partners.invoicing_address) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('invoicing_addressHidden','Lino.contacts.Partners.detail'), "editor": invoicing_address1046, "dataIndex": "invoicing_address" }, { "colIndex": 19, "sortable": true, "header": "Payment Term", "editable": true, "tooltip": "(contacts.Partners.payment_term) The default payment term for sales invoices to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "payment_term", "editor": payment_term1047 }, { "colIndex": 20, "sortable": true, "header": "VAT Regime", "editable": true, "tooltip": "(contacts.Partners.vat_regime) The default VAT regime for sales to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "vat_regime", "editor": vat_regime1048 }, { "colIndex": 21, "sortable": true, "header": "Invoicing Mode", "editable": true, "tooltip": "(contacts.Partners.imode) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "imode", "editor": imode1049 }, new Lino.NullNumberColumn({ "colIndex": 22, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.Partners.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1050, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.Partners.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Partners","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.contacts.Partners.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Partners","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.contacts.Partners.print_labels = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Partners","GET",pk,"print_labels",Lino.get_current_grid_config);
};
Lino.contacts.Partners.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Partners","GET",pk,"put",null);
};
Lino.contacts.Partners.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Partners","GET",pk,"post",null);
};

Lino.contacts.Partners.insertPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "New Partners",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/contacts/Partners",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    Lino.contacts.Partners.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Partners.insertPanel(p);
});
Lino.contacts.Partners.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Partners","GET",pk,"poststay",null);
};

Lino.contacts.Partners.detailPanel = Ext.extend(Lino.contacts.Partners.DetailFormPanel,{
  empty_title: "Detail Partners",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/contacts/Partners",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    Lino.contacts.Partners.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Partners.detailPanel(p);
});
Lino.contacts.Partners.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Partners.GridPanel(p);
});

// js_render_GridPanel_class contacts.Persons
Lino.contacts.Persons.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Persons",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/contacts/Persons','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/Persons','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/Persons','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true }, { "itemId": "print_labels", "menu_item_text": "Labels", "must_save": true, "tooltip": "Generate mailing labels for these recipients", "panel_btn_handler": Lino.list_action_handler('/contacts/Persons','print_labels','GET',Lino.get_current_grid_config), "text": "Labels", "overflowText": "Labels", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "merge_row", "menu_item_text": "Merge", "tooltip": "Merge this object into another object of same class.", "panel_btn_handler": Lino.param_action_handler(Lino.contacts.Persons.merge_row), "text": "Merge", "overflowText": "Merge", "auto_save": true } ],
  cell_edit : true,
  title : "Persons",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 39,
  ls_store_fields : [ { "name": "name_column" }, { "name": "address_column" }, { "name": "email" }, { "name": "phone" }, { "name": "gsm" }, { "type": "int", "name": "id" }, { "name": "language" }, 'languageHidden', { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "name" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "url" }, { "name": "fax" }, { "name": "remarks" }, { "name": "invoicing_address" }, 'invoicing_addressHidden', { "name": "payment_term" }, 'payment_termHidden', { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "imode" }, 'imodeHidden', { "name": "first_name" }, { "name": "last_name" }, { "name": "gender" }, 'genderHidden', { "name": "title" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 21,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    var ww = this.containing_window;
    var name_column_disp1052 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var address_column_disp1053 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var email1054 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone1055 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm1056 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1057 = new Ext.form.NumberField({ "selectOnFocus": true });
    var language1058 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ] });
    var country1059 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Country..." });
    var city1060 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var region1061 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var zip_code1062 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var name1063 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var addr11064 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix1065 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street1066 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no1067 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box1068 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr21069 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var url1070 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var fax1071 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks1072 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var invoicing_address1073 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/invoicing_address", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var payment_term1074 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Payment Term..." });
    var vat_regime1075 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var imode1076 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Invoicing Mode..." });
    var first_name1077 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var last_name1078 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gender1079 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.Genders) });
    var title1080 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
      city1060.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1060.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region1061.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country1059.on('change',Lino.chooser_handler(city1060,'country'));
      region1061.on('change',Lino.chooser_handler(city1060,'region'));
      country1059.on('change',Lino.chooser_handler(region1061,'country'));
      Lino.contacts.Persons.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "name_column", "header": "Name", "editable": false, "tooltip": "(contacts.Persons.name_column) " }, { "width": Lino.chars2width(31), "colIndex": 1, "sortable": false, "dataIndex": "address_column", "header": "Address", "editable": false, "tooltip": "(contacts.Persons.address_column) " }, { "colIndex": 2, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.Persons.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email1054 }, { "colIndex": 3, "sortable": true, "header": "Phone", "editable": true, "tooltip": "(contacts.Persons.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "phone", "editor": phone1055 }, { "colIndex": 4, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.Persons.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "gsm", "editor": gsm1056 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.Persons.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1057, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Language", "editable": true, "tooltip": "(contacts.Persons.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "language", "editor": language1058 }, { "colIndex": 7, "sortable": true, "header": "Country", "editable": true, "tooltip": "(contacts.Persons.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country1059, "dataIndex": "country" }, { "colIndex": 8, "sortable": true, "header": "Place", "editable": true, "tooltip": "(contacts.Persons.city) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail'), "editor": city1060, "dataIndex": "city" }, { "colIndex": 9, "sortable": true, "header": "Region", "editable": true, "tooltip": "(contacts.Persons.region) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail'), "editor": region1061, "dataIndex": "region" }, { "colIndex": 10, "sortable": true, "header": "Zip code", "editable": true, "tooltip": "(contacts.Persons.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code1062 }, { "colIndex": 11, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.Persons.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1063 }, { "colIndex": 12, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "(contacts.Persons.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr11064 }, { "colIndex": 13, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "(contacts.Persons.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix1065 }, { "colIndex": 14, "sortable": true, "header": "Street", "editable": true, "tooltip": "(contacts.Persons.street) Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street1066 }, { "colIndex": 15, "sortable": true, "header": "No.", "editable": true, "tooltip": "(contacts.Persons.street_no) House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no1067 }, { "colIndex": 16, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.Persons.street_box) Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box1068 }, { "colIndex": 17, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "(contacts.Persons.addr2) Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr21069 }, { "colIndex": 18, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.Persons.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url1070 }, { "colIndex": 19, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.Persons.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax1071 }, { "colIndex": 20, "sortable": false, "header": "Remarks", "editable": true, "tooltip": "(contacts.Persons.remarks) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks1072, "dataIndex": "remarks" }, { "colIndex": 21, "sortable": true, "header": "Invoicing address", "editable": true, "tooltip": "(contacts.Persons.invoicing_address) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('invoicing_addressHidden','Lino.contacts.Partners.detail'), "editor": invoicing_address1073, "dataIndex": "invoicing_address" }, { "colIndex": 22, "sortable": true, "header": "Payment Term", "editable": true, "tooltip": "(contacts.Persons.payment_term) The default payment term for sales invoices to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "payment_term", "editor": payment_term1074 }, { "colIndex": 23, "sortable": true, "header": "VAT Regime", "editable": true, "tooltip": "(contacts.Persons.vat_regime) The default VAT regime for sales to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "vat_regime", "editor": vat_regime1075 }, { "colIndex": 24, "sortable": true, "header": "Invoicing Mode", "editable": true, "tooltip": "(contacts.Persons.imode) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "imode", "editor": imode1076 }, { "colIndex": 25, "sortable": true, "header": "First name", "editable": true, "tooltip": "(contacts.Persons.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name1077 }, { "colIndex": 26, "sortable": true, "header": "Last name", "editable": true, "tooltip": "(contacts.Persons.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name1078 }, { "colIndex": 27, "sortable": true, "header": "Gender", "editable": true, "tooltip": "(contacts.Persons.gender) ", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "gender", "editor": gender1079 }, { "colIndex": 28, "sortable": true, "header": "Title", "editable": true, "tooltip": "(contacts.Persons.title) Text to print before first_name as part of the first address line.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "title", "editor": title1080 } ];
    Lino.contacts.Persons.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Persons","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.contacts.Persons.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Persons","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.contacts.Persons.print_labels = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Persons","GET",pk,"print_labels",Lino.get_current_grid_config);
};
Lino.contacts.Persons.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Persons","GET",pk,"put",null);
};
Lino.contacts.Persons.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Persons","GET",pk,"post",null);
};

Lino.contacts.Persons.insertPanel = Ext.extend(Lino.contacts.Persons.InsertFormPanel,{
  empty_title: "New Persons",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/contacts/Persons",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    Lino.contacts.Persons.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Persons.insertPanel(p);
});
Lino.contacts.Persons.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Persons","GET",pk,"poststay",null);
};

Lino.contacts.Persons.detailPanel = Ext.extend(Lino.contacts.Persons.DetailFormPanel,{
  empty_title: "Detail Persons",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "merge_row", "menu_item_text": "Merge", "tooltip": "Merge this object into another object of same class.", "panel_btn_handler": Lino.param_action_handler(Lino.contacts.Persons.merge_row), "text": "Merge", "overflowText": "Merge", "auto_save": true } ],
  ls_url: "/contacts/Persons",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    Lino.contacts.Persons.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Persons.detailPanel(p);
});
Lino.contacts.Persons.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Persons.GridPanel(p);
});

// js_render_GridPanel_class contacts.Companies
Lino.contacts.Companies.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Companies",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/contacts/Companies','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/Companies','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/Companies','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true }, { "itemId": "print_labels", "menu_item_text": "Labels", "must_save": true, "tooltip": "Generate mailing labels for these recipients", "panel_btn_handler": Lino.list_action_handler('/contacts/Companies','print_labels','GET',Lino.get_current_grid_config), "text": "Labels", "overflowText": "Labels", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "merge_row", "menu_item_text": "Merge", "tooltip": "Merge this object into another object of same class.", "panel_btn_handler": Lino.param_action_handler(Lino.contacts.Companies.merge_row), "text": "Merge", "overflowText": "Merge", "auto_save": true } ],
  cell_edit : true,
  title : "Companies",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 36,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "name": "invoicing_address" }, 'invoicing_addressHidden', { "name": "payment_term" }, 'payment_termHidden', { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "imode" }, 'imodeHidden', { "name": "prefix" }, { "name": "vat_id" }, { "name": "type" }, 'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 34,
  ls_grid_configs : [  ],
  content_type : 21,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    var ww = this.containing_window;
    var name1082 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email1083 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var country1084 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Country..." });
    var city1085 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var region1086 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var zip_code1087 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr11088 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix1089 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street1090 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no1091 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box1092 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr21093 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language1094 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ] });
    var url1095 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone1096 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm1097 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax1098 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks1099 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var invoicing_address1100 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/invoicing_address", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var payment_term1101 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Payment Term..." });
    var vat_regime1102 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var imode1103 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Invoicing Mode..." });
    var prefix1104 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var vat_id1105 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type1106 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a company type..." });
    var id1107 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city1085.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1085.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region1086.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country1084.on('change',Lino.chooser_handler(city1085,'country'));
      region1086.on('change',Lino.chooser_handler(city1085,'region'));
      country1084.on('change',Lino.chooser_handler(region1086,'country'));
      Lino.contacts.Companies.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.Companies.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1082 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.Companies.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email1083 }, { "colIndex": 2, "sortable": true, "header": "Country", "editable": true, "tooltip": "(contacts.Companies.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country1084, "dataIndex": "country" }, { "colIndex": 3, "sortable": true, "header": "Place", "editable": true, "tooltip": "(contacts.Companies.city) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail'), "editor": city1085, "dataIndex": "city" }, { "colIndex": 4, "sortable": true, "header": "Region", "editable": true, "tooltip": "(contacts.Companies.region) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail'), "editor": region1086, "dataIndex": "region" }, { "colIndex": 5, "sortable": true, "header": "Zip code", "editable": true, "tooltip": "(contacts.Companies.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code1087 }, { "colIndex": 6, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "(contacts.Companies.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr11088 }, { "colIndex": 7, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "(contacts.Companies.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix1089 }, { "colIndex": 8, "sortable": true, "header": "Street", "editable": true, "tooltip": "(contacts.Companies.street) Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street1090 }, { "colIndex": 9, "sortable": true, "header": "No.", "editable": true, "tooltip": "(contacts.Companies.street_no) House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no1091 }, { "colIndex": 10, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.Companies.street_box) Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box1092 }, { "colIndex": 11, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "(contacts.Companies.addr2) Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr21093 }, { "colIndex": 12, "sortable": true, "header": "Language", "editable": true, "tooltip": "(contacts.Companies.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language1094 }, { "colIndex": 13, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.Companies.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url1095 }, { "colIndex": 14, "sortable": true, "header": "Phone", "editable": true, "tooltip": "(contacts.Companies.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone1096 }, { "colIndex": 15, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.Companies.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm1097 }, { "colIndex": 16, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.Companies.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax1098 }, { "colIndex": 17, "sortable": false, "header": "Remarks", "editable": true, "tooltip": "(contacts.Companies.remarks) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks1099, "dataIndex": "remarks" }, { "colIndex": 18, "sortable": true, "header": "Invoicing address", "editable": true, "tooltip": "(contacts.Companies.invoicing_address) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('invoicing_addressHidden','Lino.contacts.Partners.detail'), "editor": invoicing_address1100, "dataIndex": "invoicing_address" }, { "colIndex": 19, "sortable": true, "header": "Payment Term", "editable": true, "tooltip": "(contacts.Companies.payment_term) The default payment term for sales invoices to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "payment_term", "editor": payment_term1101 }, { "colIndex": 20, "sortable": true, "header": "VAT Regime", "editable": true, "tooltip": "(contacts.Companies.vat_regime) The default VAT regime for sales to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "vat_regime", "editor": vat_regime1102 }, { "colIndex": 21, "sortable": true, "header": "Invoicing Mode", "editable": true, "tooltip": "(contacts.Companies.imode) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "imode", "editor": imode1103 }, { "colIndex": 22, "sortable": true, "header": "prefix", "editable": true, "tooltip": "(contacts.Companies.prefix) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "prefix", "editor": prefix1104 }, { "colIndex": 23, "sortable": true, "header": "VAT id", "editable": true, "tooltip": "(contacts.Companies.vat_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "vat_id", "editor": vat_id1105 }, { "colIndex": 24, "sortable": true, "header": "Company type", "editable": true, "tooltip": "(contacts.Companies.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type1106 }, new Lino.NullNumberColumn({ "colIndex": 25, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.Companies.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1107, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.Companies.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Companies","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.contacts.Companies.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Companies","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.contacts.Companies.print_labels = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Companies","GET",pk,"print_labels",Lino.get_current_grid_config);
};
Lino.contacts.Companies.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Companies","GET",pk,"put",null);
};
Lino.contacts.Companies.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Companies","GET",pk,"post",null);
};

Lino.contacts.Companies.insertPanel = Ext.extend(Lino.contacts.Companies.InsertFormPanel,{
  empty_title: "New Companies",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/contacts/Companies",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    Lino.contacts.Companies.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Companies.insertPanel(p);
});
Lino.contacts.Companies.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Companies","GET",pk,"poststay",null);
};

Lino.contacts.Companies.detailPanel = Ext.extend(Lino.contacts.Companies.DetailFormPanel,{
  empty_title: "Detail Companies",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "merge_row", "menu_item_text": "Merge", "tooltip": "Merge this object into another object of same class.", "panel_btn_handler": Lino.param_action_handler(Lino.contacts.Companies.merge_row), "text": "Merge", "overflowText": "Merge", "auto_save": true } ],
  ls_url: "/contacts/Companies",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    Lino.contacts.Companies.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Companies.detailPanel(p);
});
Lino.contacts.Companies.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Companies.GridPanel(p);
});

// js_render_GridPanel_class contacts.RoleTypes
Lino.contacts.RoleTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/RoleTypes",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/contacts/RoleTypes','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/RoleTypes','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/RoleTypes','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Functions",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 5,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 17,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id1109 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1110 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1111 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1112 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.RoleTypes.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1109, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(contacts.RoleTypes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1110 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(contacts.RoleTypes.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de1111 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(contacts.RoleTypes.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1112 } ];
    Lino.contacts.RoleTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.RoleTypes.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RoleTypes","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.contacts.RoleTypes.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RoleTypes","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.contacts.RoleTypes.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RoleTypes","GET",pk,"put",null);
};
Lino.contacts.RoleTypes.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RoleTypes","GET",pk,"post",null);
};
Lino.contacts.RoleTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.RoleTypes.GridPanel(p);
});

// js_render_GridPanel_class contacts.Roles
Lino.contacts.Roles.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Roles",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/contacts/Roles','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/Roles','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/Roles','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Contact Persons",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 8,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "type" }, 'typeHidden', { "name": "person" }, 'personHidden', { "name": "company" }, 'companyHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 20,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id1114 = new Ext.form.NumberField({ "selectOnFocus": true });
    var type1115 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Roles/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Function..." });
    var person1116 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Roles/person", "method": "GET" }) }), "emptyText": "Select a Person..." });
    var company1117 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Roles/company", "method": "GET" }) }), "emptyText": "Select a Company..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.Roles.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1114, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Contact Role", "editable": true, "tooltip": "(contacts.Roles.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type1115 }, { "colIndex": 2, "sortable": true, "header": "Person", "editable": true, "tooltip": "(contacts.Roles.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('personHidden','Lino.contacts.Persons.detail'), "editor": person1116, "dataIndex": "person" }, { "colIndex": 3, "sortable": true, "header": "Company", "editable": true, "tooltip": "(contacts.Roles.company) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('companyHidden','Lino.contacts.Companies.detail'), "editor": company1117, "dataIndex": "company" } ];
    Lino.contacts.Roles.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Roles.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Roles","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.contacts.Roles.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Roles","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.contacts.Roles.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Roles","GET",pk,"put",null);
};
Lino.contacts.Roles.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Roles","GET",pk,"post",null);
};
Lino.contacts.Roles.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Roles.GridPanel(p);
});

// js_render_GridPanel_class accounts.Charts
Lino.accounts.Charts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/accounts/Charts",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/accounts/Charts','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/accounts/Charts','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/accounts/Charts','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Account Charts",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 5,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 27,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Charts.detail;
    this.ls_insert_handler = Lino.accounts.Charts.insert;
    var ww = this.containing_window;
    var id1119 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1120 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1121 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1122 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(accounts.Charts.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1119, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(accounts.Charts.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1120 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(accounts.Charts.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de1121 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(accounts.Charts.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1122 } ];
    Lino.accounts.Charts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Charts.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Charts","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.accounts.Charts.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Charts","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.accounts.Charts.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Charts","GET",pk,"put",null);
};
Lino.accounts.Charts.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Charts","GET",pk,"post",null);
};

Lino.accounts.Charts.insertPanel = Ext.extend(Lino.accounts.Charts.DetailFormPanel,{
  empty_title: "New Account Charts",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/accounts/Charts",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Charts.detail;
    this.ls_insert_handler = Lino.accounts.Charts.insert;
    Lino.accounts.Charts.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Charts.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.accounts.Charts.insertPanel(p);
});
Lino.accounts.Charts.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Charts","GET",pk,"poststay",null);
};

Lino.accounts.Charts.detailPanel = Ext.extend(Lino.accounts.Charts.DetailFormPanel,{
  empty_title: "Detail Account Charts",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/accounts/Charts",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Charts.detail;
    this.ls_insert_handler = Lino.accounts.Charts.insert;
    Lino.accounts.Charts.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Charts.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Charts.detailPanel(p);
});
Lino.accounts.Charts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Charts.GridPanel(p);
});

// js_render_GridPanel_class accounts.Groups
Lino.accounts.Groups.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/accounts/Groups",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/accounts/Groups','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/accounts/Groups','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/accounts/Groups','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Account Groups",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 10,
  ls_store_fields : [ { "name": "chart" }, 'chartHidden', { "name": "ref" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "account_type" }, 'account_typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 8,
  ls_grid_configs : [  ],
  content_type : 26,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Groups.detail;
    this.ls_insert_handler = Lino.accounts.Groups.insert;
    var ww = this.containing_window;
    var chart1124 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Groups/chart", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account Chart..." });
    var ref1125 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var name1126 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1127 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1128 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var account_type1129 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.accounts.AccountTypes) });
    var id1130 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Account Chart", "editable": true, "tooltip": "(accounts.Groups.chart) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('chartHidden','Lino.accounts.Charts.detail'), "editor": chart1124, "dataIndex": "chart" }, { "colIndex": 1, "sortable": true, "header": "ref", "editable": true, "tooltip": "(accounts.Groups.ref) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ref", "editor": ref1125 }, { "colIndex": 2, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(accounts.Groups.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1126 }, { "colIndex": 3, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(accounts.Groups.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de1127 }, { "colIndex": 4, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(accounts.Groups.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1128 }, { "colIndex": 5, "sortable": true, "header": "Account Type", "editable": true, "tooltip": "(accounts.Groups.account_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(17), "dataIndex": "account_type", "editor": account_type1129 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(accounts.Groups.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1130, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.accounts.Groups.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Groups.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Groups","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.accounts.Groups.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Groups","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.accounts.Groups.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Groups","GET",pk,"put",null);
};
Lino.accounts.Groups.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Groups","GET",pk,"post",null);
};

Lino.accounts.Groups.insertPanel = Ext.extend(Lino.accounts.Groups.DetailFormPanel,{
  empty_title: "New Account Groups",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/accounts/Groups",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Groups.detail;
    this.ls_insert_handler = Lino.accounts.Groups.insert;
    Lino.accounts.Groups.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Groups.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.accounts.Groups.insertPanel(p);
});
Lino.accounts.Groups.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Groups","GET",pk,"poststay",null);
};

Lino.accounts.Groups.detailPanel = Ext.extend(Lino.accounts.Groups.DetailFormPanel,{
  empty_title: "Detail Account Groups",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/accounts/Groups",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Groups.detail;
    this.ls_insert_handler = Lino.accounts.Groups.insert;
    Lino.accounts.Groups.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Groups.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Groups.detailPanel(p);
});
Lino.accounts.Groups.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Groups.GridPanel(p);
});

// js_render_GridPanel_class accounts.Accounts
Lino.accounts.Accounts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/accounts/Accounts",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/accounts/Accounts','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/accounts/Accounts','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/accounts/Accounts','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-arrow_up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-arrow_down", "overflowText": "Down", "auto_save": true } ],
  cell_edit : true,
  title : "Accounts",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 16,
  ls_store_fields : [ { "name": "ref" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "group" }, 'groupHidden', { "type": "int", "name": "id" }, { "type": "int", "name": "seqno" }, { "name": "chart" }, 'chartHidden', { "name": "type" }, 'typeHidden', { "type": "boolean", "name": "sales_allowed" }, { "type": "boolean", "name": "purchases_allowed" }, { "type": "boolean", "name": "wages_allowed" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 25,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var ref1132 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var name1133 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1134 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1135 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var group1136 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Accounts/group", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account Group..." });
    var id1137 = new Ext.form.NumberField({ "selectOnFocus": true });
    var seqno1138 = new Ext.form.NumberField({ "selectOnFocus": true });
    var chart1139 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Accounts/chart", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account Chart..." });
    var type1140 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.accounts.AccountTypes });
    var sales_allowed1141 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var purchases_allowed1142 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var wages_allowed1143 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ref", "editable": true, "tooltip": "(accounts.Accounts.ref) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ref", "editor": ref1132 }, { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(accounts.Accounts.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1133 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(accounts.Accounts.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de1134 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(accounts.Accounts.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1135 }, { "colIndex": 4, "sortable": true, "header": "Account Group", "editable": true, "tooltip": "(accounts.Accounts.group) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('groupHidden','Lino.accounts.Groups.detail'), "editor": group1136, "dataIndex": "group" }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(accounts.Accounts.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1137, "width": Lino.chars2width(6), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(accounts.Accounts.seqno) ", "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "width": Lino.chars2width(6), "editor": seqno1138 }), { "colIndex": 7, "sortable": true, "header": "Account Chart", "editable": true, "tooltip": "(accounts.Accounts.chart) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('chartHidden','Lino.accounts.Charts.detail'), "editor": chart1139, "dataIndex": "chart" }, { "colIndex": 8, "sortable": true, "header": "Account Type", "editable": true, "tooltip": "(accounts.Accounts.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(17), "dataIndex": "type", "editor": type1140 }, { "colIndex": 9, "sortable": false, "xtype": "checkcolumn", "header": "Sales", "editable": true, "tooltip": "(accounts.Accounts.sales_allowed) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "sales_allowed" }, { "colIndex": 10, "sortable": false, "xtype": "checkcolumn", "header": "Purchases", "editable": true, "tooltip": "(accounts.Accounts.purchases_allowed) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "purchases_allowed" }, { "colIndex": 11, "sortable": false, "xtype": "checkcolumn", "header": "Wages", "editable": true, "tooltip": "(accounts.Accounts.wages_allowed) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "wages_allowed" } ];
    Lino.accounts.Accounts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Accounts.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Accounts","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.accounts.Accounts.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Accounts","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.accounts.Accounts.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Accounts","GET",pk,"put",null);
};
Lino.accounts.Accounts.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Accounts","GET",pk,"post",null);
};
Lino.accounts.Accounts.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Accounts","GET",pk,"duplicate",null);
};
Lino.accounts.Accounts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Accounts.GridPanel(p);
});
Lino.accounts.Accounts.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Accounts","GET",pk,"move_up",null);
};
Lino.accounts.Accounts.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Accounts","GET",pk,"move_down",null);
};

// js_render_GridPanel_class products.ProductCats
Lino.products.ProductCats.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/products/ProductCats",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/products/ProductCats','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/products/ProductCats','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/products/ProductCats','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Product Categories",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "description" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 23,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.products.ProductCats.detail;
    this.ls_insert_handler = Lino.products.ProductCats.insert;
    var ww = this.containing_window;
    var id1145 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1146 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1147 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1148 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var description1149 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(products.ProductCats.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1145, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(products.ProductCats.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1146 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(products.ProductCats.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de1147 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(products.ProductCats.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1148 }, { "colIndex": 4, "sortable": false, "header": "description", "editable": true, "tooltip": "(products.ProductCats.description) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": description1149, "dataIndex": "description" } ];
    Lino.products.ProductCats.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.products.ProductCats.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/ProductCats","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.products.ProductCats.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/ProductCats","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.products.ProductCats.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/ProductCats","GET",pk,"put",null);
};
Lino.products.ProductCats.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/ProductCats","GET",pk,"post",null);
};

Lino.products.ProductCats.insertPanel = Ext.extend(Lino.products.ProductCats.DetailFormPanel,{
  empty_title: "New Product Categories",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/products/ProductCats",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.products.ProductCats.detail;
    this.ls_insert_handler = Lino.products.ProductCats.insert;
    Lino.products.ProductCats.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.products.ProductCats.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.products.ProductCats.insertPanel(p);
});
Lino.products.ProductCats.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/ProductCats","GET",pk,"poststay",null);
};

Lino.products.ProductCats.detailPanel = Ext.extend(Lino.products.ProductCats.DetailFormPanel,{
  empty_title: "Detail Product Categories",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/products/ProductCats",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.products.ProductCats.detail;
    this.ls_insert_handler = Lino.products.ProductCats.insert;
    Lino.products.ProductCats.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.products.ProductCats.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.products.ProductCats.detailPanel(p);
});
Lino.products.ProductCats.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.products.ProductCats.GridPanel(p);
});

// js_render_GridPanel_class products.Products
Lino.products.Products.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/products/Products",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/products/Products','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/products/Products','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/products/Products','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Products",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 14,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "cat" }, 'catHidden', { "name": "vat_class" }, 'vat_classHidden', { "name": "sales_price" }, { "name": "sales_account" }, 'sales_accountHidden', { "name": "purchases_account" }, 'purchases_accountHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 24,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.products.Products.detail;
    this.ls_insert_handler = Lino.products.Products.insert;
    var ww = this.containing_window;
    var id1151 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1152 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1153 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1154 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var cat1155 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/products/Products/cat", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Product Category..." });
    var vat_class1156 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.vat.VatClasses) });
    var sales_price1157 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var sales_account1158 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/products/Products/sales_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var purchases_account1159 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/products/Products/purchases_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(products.Products.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1151, "width": Lino.chars2width(4), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(products.Products.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1152 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(products.Products.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de1153 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(products.Products.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1154 }, { "colIndex": 4, "sortable": true, "header": "Category", "editable": true, "tooltip": "(products.Products.cat) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('catHidden','Lino.products.ProductCats.detail'), "editor": cat1155, "dataIndex": "cat" }, { "colIndex": 5, "sortable": true, "header": "VAT Class", "editable": true, "tooltip": "(products.Products.vat_class) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "vat_class", "editor": vat_class1156 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "header": "Sales price", "editable": true, "tooltip": "(products.Products.sales_price) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(7), "dataIndex": "sales_price", "editor": sales_price1157 }), { "colIndex": 7, "sortable": true, "header": "Sales Base account", "editable": true, "tooltip": "(products.Products.sales_account) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "sales_account", "editor": sales_account1158 }, { "colIndex": 8, "sortable": true, "header": "Purchases Base account", "editable": true, "tooltip": "(products.Products.purchases_account) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "purchases_account", "editor": purchases_account1159 } ];
    Lino.products.Products.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.products.Products.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/Products","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.products.Products.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/Products","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.products.Products.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/Products","GET",pk,"put",null);
};
Lino.products.Products.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/Products","GET",pk,"post",null);
};

Lino.products.Products.insertPanel = Ext.extend(Lino.products.Products.DetailFormPanel,{
  empty_title: "New Products",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/products/Products",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.products.Products.detail;
    this.ls_insert_handler = Lino.products.Products.insert;
    Lino.products.Products.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.products.Products.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.products.Products.insertPanel(p);
});
Lino.products.Products.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/Products","GET",pk,"poststay",null);
};

Lino.products.Products.detailPanel = Ext.extend(Lino.products.Products.DetailFormPanel,{
  empty_title: "Detail Products",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/products/Products",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.products.Products.detail;
    this.ls_insert_handler = Lino.products.Products.insert;
    Lino.products.Products.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.products.Products.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.products.Products.detailPanel(p);
});
Lino.products.Products.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.products.Products.GridPanel(p);
});

// js_render_GridPanel_class ledger.Journals
Lino.ledger.Journals.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/ledger/Journals",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/ledger/Journals','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/Journals','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/Journals','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-arrow_up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-arrow_down", "overflowText": "Down", "auto_save": true } ],
  cell_edit : true,
  title : "Journals",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 23,
  ls_store_fields : [ { "name": "ref" }, { "name": "trade_type" }, 'trade_typeHidden', { "name": "voucher_type" }, 'voucher_typeHidden', { "type": "boolean", "name": "force_sequence" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "build_method" }, 'build_methodHidden', { "name": "template" }, { "name": "chart" }, 'chartHidden', { "name": "account" }, 'accountHidden', { "name": "printed_name" }, { "name": "printed_name_de" }, { "name": "printed_name_fr" }, { "type": "boolean", "name": "dc" }, { "type": "int", "name": "seqno" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 21,
  ls_grid_configs : [  ],
  content_type : 28,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Journals.detail;
    this.ls_insert_handler = Lino.ledger.Journals.insert;
    var ww = this.containing_window;
    var ref1161 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var trade_type1162 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.vat.TradeTypes) });
    var voucher_type1163 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.ledger.VoucherTypes });
    var force_sequence1164 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var name1165 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1166 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1167 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var build_method1168 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template1169 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Journals/template", "method": "GET" }) }) });
    var chart1170 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Journals/chart", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account Chart..." });
    var account1171 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Journals/account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var printed_name1172 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var printed_name_de1173 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var printed_name_fr1174 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var dc1175 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": null });
    var seqno1176 = new Ext.form.NumberField({ "selectOnFocus": true });
    var id1177 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      template1169.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      account1171.setContextValue('chart',record ? record.data['chartHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      build_method1168.on('change',Lino.chooser_handler(template1169,'build_method'));
      chart1170.on('change',Lino.chooser_handler(account1171,'chart'));
      Lino.ledger.Journals.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ref", "editable": true, "tooltip": "(ledger.Journals.ref) ", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "ref", "editor": ref1161 }, { "colIndex": 1, "sortable": true, "header": "Trade Type", "editable": true, "tooltip": "(ledger.Journals.trade_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "trade_type", "editor": trade_type1162 }, { "colIndex": 2, "sortable": true, "header": "voucher type", "editable": true, "tooltip": "(ledger.Journals.voucher_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(65), "dataIndex": "voucher_type", "editor": voucher_type1163 }, { "colIndex": 3, "sortable": false, "xtype": "checkcolumn", "header": "force sequence", "editable": true, "tooltip": "(ledger.Journals.force_sequence) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "force_sequence" }, { "colIndex": 4, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(ledger.Journals.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1165 }, { "colIndex": 5, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(ledger.Journals.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de1166 }, { "colIndex": 6, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(ledger.Journals.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1167 }, { "colIndex": 7, "sortable": true, "header": "Build method", "editable": true, "tooltip": "(ledger.Journals.build_method) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "build_method", "editor": build_method1168 }, { "colIndex": 8, "sortable": true, "header": "Template", "editable": true, "tooltip": "(ledger.Journals.template) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "template", "editor": template1169 }, { "colIndex": 9, "sortable": true, "header": "Account Chart", "editable": true, "tooltip": "(ledger.Journals.chart) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('chartHidden','Lino.accounts.Charts.detail'), "editor": chart1170, "dataIndex": "chart" }, { "colIndex": 10, "sortable": true, "header": "Account", "editable": true, "tooltip": "(ledger.Journals.account) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "account", "editor": account1171 }, { "colIndex": 11, "sortable": true, "header": "printed name", "editable": true, "tooltip": "(ledger.Journals.printed_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "printed_name", "editor": printed_name1172 }, { "colIndex": 12, "sortable": true, "header": "printed name (de)", "editable": true, "tooltip": "(ledger.Journals.printed_name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "printed_name_de", "editor": printed_name_de1173 }, { "colIndex": 13, "sortable": true, "header": "printed name (fr)", "editable": true, "tooltip": "(ledger.Journals.printed_name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "printed_name_fr", "editor": printed_name_fr1174 }, { "colIndex": 14, "sortable": false, "xtype": "checkcolumn", "header": "dc", "editable": true, "tooltip": "(ledger.Journals.dc) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "dc" }, new Lino.NullNumberColumn({ "colIndex": 15, "sortable": true, "format": "0", "editable": true, "tooltip": "(ledger.Journals.seqno) ", "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "width": Lino.chars2width(6), "editor": seqno1176 }), new Lino.NullNumberColumn({ "colIndex": 16, "sortable": true, "format": "0", "editable": true, "tooltip": "(ledger.Journals.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1177, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.ledger.Journals.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Journals.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Journals","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.ledger.Journals.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Journals","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.ledger.Journals.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Journals","GET",pk,"put",null);
};
Lino.ledger.Journals.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Journals","GET",pk,"post",null);
};

Lino.ledger.Journals.insertPanel = Ext.extend(Lino.ledger.Journals.InsertFormPanel,{
  empty_title: "New Journals",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true } ],
  ls_url: "/ledger/Journals",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Journals.detail;
    this.ls_insert_handler = Lino.ledger.Journals.insert;
    Lino.ledger.Journals.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Journals.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.ledger.Journals.insertPanel(p);
});
Lino.ledger.Journals.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Journals","GET",pk,"poststay",null);
};
Lino.ledger.Journals.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Journals","GET",pk,"duplicate",null);
};

Lino.ledger.Journals.detailPanel = Ext.extend(Lino.ledger.Journals.DetailFormPanel,{
  empty_title: "Detail Journals",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-arrow_up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-arrow_down", "overflowText": "Down", "auto_save": true } ],
  ls_url: "/ledger/Journals",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Journals.detail;
    this.ls_insert_handler = Lino.ledger.Journals.insert;
    Lino.ledger.Journals.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Journals.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.Journals.detailPanel(p);
});
Lino.ledger.Journals.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.Journals.GridPanel(p);
});
Lino.ledger.Journals.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Journals","GET",pk,"move_up",null);
};
Lino.ledger.Journals.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Journals","GET",pk,"move_down",null);
};

// js_render_GridPanel_class ledger.Vouchers
Lino.ledger.Vouchers.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "emptyText": "No data to display." },
  ls_url : "/ledger/Vouchers",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/ledger/Vouchers','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/Vouchers','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/Vouchers','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" } ],
  cell_edit : true,
  title : "Vouchers",
  page_length : 20,
  stripeRows : true,
  disable_editing : true,
  disabled_actions_index : 13,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "type": "int", "name": "number" }, { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "journal" }, 'journalHidden', { "name": "year" }, 'yearHidden', { "name": "narration" }, { "name": "declared_in" }, 'declared_inHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var date1179 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var number1180 = new Ext.form.NumberField({ "selectOnFocus": true });
    var id1181 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1182 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Vouchers/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var journal1183 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Vouchers/journal", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Journal..." });
    var year1184 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var narration1185 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var declared_in1186 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Vouchers/declared_in", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a VAT declaration..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(ledger.Vouchers.date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "date", "width": Lino.chars2width(9), "editor": date1179 }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "format": "0", "editable": true, "tooltip": "(ledger.Vouchers.number) ", "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(6), "editor": number1180 }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(ledger.Vouchers.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1181, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 3, "sortable": true, "header": "Author", "editable": true, "tooltip": "(ledger.Vouchers.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1182, "dataIndex": "user" }, { "colIndex": 4, "sortable": true, "header": "Journal", "editable": true, "tooltip": "(ledger.Vouchers.journal) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('journalHidden','Lino.ledger.Journals.detail'), "editor": journal1183, "dataIndex": "journal" }, { "colIndex": 5, "sortable": true, "header": "Fiscal Year", "editable": true, "tooltip": "(ledger.Vouchers.year) ", "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "year", "editor": year1184 }, { "colIndex": 6, "sortable": true, "header": "Narration", "editable": true, "tooltip": "(ledger.Vouchers.narration) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "narration", "editor": narration1185 }, { "colIndex": 7, "sortable": true, "header": "VAT declaration", "editable": true, "tooltip": "(ledger.Vouchers.declared_in) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('declared_inHidden','Lino.declarations.Declarations.detail'), "editor": declared_in1186, "dataIndex": "declared_in" } ];
    Lino.ledger.Vouchers.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Vouchers.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Vouchers","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.ledger.Vouchers.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Vouchers","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.ledger.Vouchers.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.Vouchers.GridPanel(p);
});

// js_render_GridPanel_class ledger.Movements
Lino.ledger.Movements.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "emptyText": "No data to display." },
  ls_url : "/ledger/Movements",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/ledger/Movements','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/Movements','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/Movements','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-arrow_up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-arrow_down", "overflowText": "Down", "auto_save": true } ],
  cell_edit : true,
  title : "Movements",
  page_length : 20,
  stripeRows : true,
  disable_editing : true,
  disabled_actions_index : 16,
  ls_store_fields : [ { "name": "voucher_link" }, { "name": "account" }, 'accountHidden', { "name": "debit" }, { "name": "credit" }, { "type": "int", "name": "id" }, { "type": "int", "name": "seqno" }, { "name": "match" }, { "name": "voucher" }, 'voucherHidden', { "name": "partner" }, 'partnerHidden', { "name": "amount" }, { "type": "boolean", "name": "dc" }, { "type": "boolean", "name": "satisfied" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 32,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var voucher_link_disp1188 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var account1189 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Movements/account", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account..." });
    var debit1190 = new Ext.form.NumberField({ "disabled": true, "decimalPrecision": 2, "decimalSeparator": "," });
    var credit1191 = new Ext.form.NumberField({ "disabled": true, "decimalPrecision": 2, "decimalSeparator": "," });
    var id1192 = new Ext.form.NumberField({ "selectOnFocus": true });
    var seqno1193 = new Ext.form.NumberField({ "selectOnFocus": true });
    var match1194 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Movements/match", "method": "GET" }) }) });
    var voucher1195 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Movements/voucher", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Voucher..." });
    var partner1196 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Movements/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var amount1197 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalSeparator": ",", "decimalPrecision": 2, "allowBlank": false, "value": 0 });
    var dc1198 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var satisfied1199 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
      match1194.setContextValue('partner',record ? record.data['partnerHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      partner1196.on('change',Lino.chooser_handler(match1194,'partner'));
      Lino.ledger.Movements.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(31), "colIndex": 0, "sortable": false, "dataIndex": "voucher_link", "header": "Voucher", "editable": false, "tooltip": "(ledger.Movements.voucher_link) " }, { "colIndex": 1, "sortable": true, "header": "Account", "editable": true, "tooltip": "(ledger.Movements.account) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "account", "editor": account1189 }, new Lino.NullNumberColumn({ "width": Lino.chars2width(13), "colIndex": 2, "sortable": false, "dataIndex": "debit", "header": "Debit", "editable": false, "tooltip": "(ledger.Movements.debit) " }), new Lino.NullNumberColumn({ "width": Lino.chars2width(13), "colIndex": 3, "sortable": false, "dataIndex": "credit", "header": "Credit", "editable": false, "tooltip": "(ledger.Movements.credit) " }), new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(ledger.Movements.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1192, "width": Lino.chars2width(6), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(ledger.Movements.seqno) ", "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "width": Lino.chars2width(6), "editor": seqno1193 }), { "colIndex": 6, "sortable": true, "header": "Match", "editable": true, "tooltip": "(ledger.Movements.match) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "match", "editor": match1194 }, { "colIndex": 7, "sortable": true, "header": "Voucher", "editable": true, "tooltip": "(ledger.Movements.voucher) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "voucher", "editor": voucher1195 }, { "colIndex": 8, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(ledger.Movements.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner1196, "dataIndex": "partner" }, new Lino.NullNumberColumn({ "colIndex": 9, "sortable": true, "header": "amount", "editable": true, "tooltip": "(ledger.Movements.amount) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "amount", "editor": amount1197 }), { "colIndex": 10, "sortable": false, "xtype": "checkcolumn", "header": "dc", "editable": true, "tooltip": "(ledger.Movements.dc) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "dc" }, { "colIndex": 11, "sortable": false, "xtype": "checkcolumn", "header": "Satisfied", "editable": true, "tooltip": "(ledger.Movements.satisfied) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "satisfied" } ];
    Lino.ledger.Movements.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Movements.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Movements","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.ledger.Movements.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Movements","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.ledger.Movements.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Movements","GET",pk,"duplicate",null);
};
Lino.ledger.Movements.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.Movements.GridPanel(p);
});
Lino.ledger.Movements.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Movements","GET",pk,"move_up",null);
};
Lino.ledger.Movements.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Movements","GET",pk,"move_down",null);
};

// js_render_GridPanel_class ledger.Invoices
Lino.ledger.Invoices.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/ledger/Invoices",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/ledger/Invoices','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/Invoices','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/Invoices','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Invoices",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 25,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "type": "int", "name": "id" }, { "type": "int", "name": "number" }, { "name": "partner" }, 'partnerHidden', { "name": "total_incl" }, { "name": "user" }, 'userHidden', { "name": "journal" }, 'journalHidden', { "name": "year" }, 'yearHidden', { "name": "narration" }, { "name": "declared_in" }, 'declared_inHidden', { "name": "total_base" }, { "name": "total_vat" }, { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "match" }, { "name": "your_ref" }, { "type": "date", "name": "due_date", "dateFormat": "d.m.Y" }, { "name": "state" }, 'stateHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 1,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Invoices.detail;
    this.ls_insert_handler = Lino.ledger.Invoices.insert;
    var ww = this.containing_window;
    var date1201 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var id1202 = new Ext.form.NumberField({ "selectOnFocus": true });
    var number1203 = new Ext.form.NumberField({ "selectOnFocus": true });
    var partner1204 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/partner", "method": "GET" }) }), "emptyText": "Select a Partner..." });
    var total_incl1205 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var user1206 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var journal1207 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/journal", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Journal..." });
    var year1208 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var narration1209 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var declared_in1210 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/declared_in", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a VAT declaration..." });
    var total_base1211 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat1212 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var vat_regime1213 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.vat.VatRegimes });
    var match1214 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/match", "method": "GET" }) }) });
    var your_ref1215 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var due_date1216 = new Lino.DateField({ "selectOnFocus": true });
    var state1217 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.ledger.InvoiceStates });
    this.before_row_edit = function(record) {
      match1214.setContextValue('partner',record ? record.data['partnerHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      partner1204.on('change',Lino.chooser_handler(match1214,'partner'));
      Lino.ledger.Invoices.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(ledger.Invoices.date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "date", "width": Lino.chars2width(9), "editor": date1201 }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "format": "0", "editable": true, "tooltip": "(ledger.Invoices.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1202, "width": Lino.chars2width(6), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(ledger.Invoices.number) ", "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(6), "editor": number1203 }), { "colIndex": 3, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(ledger.Invoices.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner1204, "dataIndex": "partner" }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "header": "Total incl. VAT", "editable": true, "tooltip": "(ledger.Invoices.total_incl) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_incl", "editor": total_incl1205 }), { "colIndex": 5, "sortable": true, "header": "Author", "editable": true, "tooltip": "(ledger.Invoices.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1206, "dataIndex": "user" }, { "colIndex": 6, "sortable": true, "header": "Journal", "editable": true, "tooltip": "(ledger.Invoices.journal) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('journalHidden','Lino.ledger.Journals.detail'), "editor": journal1207, "dataIndex": "journal" }, { "colIndex": 7, "sortable": true, "header": "Fiscal Year", "editable": true, "tooltip": "(ledger.Invoices.year) ", "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "year", "editor": year1208 }, { "colIndex": 8, "sortable": true, "header": "Narration", "editable": true, "tooltip": "(ledger.Invoices.narration) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "narration", "editor": narration1209 }, { "colIndex": 9, "sortable": true, "header": "VAT declaration", "editable": true, "tooltip": "(ledger.Invoices.declared_in) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('declared_inHidden','Lino.declarations.Declarations.detail'), "editor": declared_in1210, "dataIndex": "declared_in" }, new Lino.NullNumberColumn({ "colIndex": 10, "sortable": true, "header": "Total excl. VAT", "editable": true, "tooltip": "(ledger.Invoices.total_base) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_base", "editor": total_base1211 }), new Lino.NullNumberColumn({ "colIndex": 11, "sortable": true, "header": "VAT", "editable": true, "tooltip": "(ledger.Invoices.total_vat) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_vat", "editor": total_vat1212 }), { "colIndex": 12, "sortable": true, "header": "VAT Regime", "editable": true, "tooltip": "(ledger.Invoices.vat_regime) ", "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "vat_regime", "editor": vat_regime1213 }, { "colIndex": 13, "sortable": true, "header": "Match", "editable": true, "tooltip": "(ledger.Invoices.match) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "match", "editor": match1214 }, { "colIndex": 14, "sortable": true, "header": "Your reference", "editable": true, "tooltip": "(ledger.Invoices.your_ref) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "your_ref", "editor": your_ref1215 }, { "colIndex": 15, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(ledger.Invoices.due_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Due date", "dataIndex": "due_date", "width": Lino.chars2width(9), "editor": due_date1216 }, { "colIndex": 16, "sortable": true, "header": "State", "editable": true, "tooltip": "(ledger.Invoices.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(14), "dataIndex": "state", "editor": state1217 } ];
    Lino.ledger.Invoices.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Invoices.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Invoices","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.ledger.Invoices.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Invoices","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.ledger.Invoices.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Invoices","GET",pk,"put",null);
};
Lino.ledger.Invoices.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Invoices","GET",pk,"post",null);
};

Lino.ledger.Invoices.insertPanel = Ext.extend(Lino.ledger.Invoices.InsertFormPanel,{
  empty_title: "New Invoices",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/ledger/Invoices",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Invoices.detail;
    this.ls_insert_handler = Lino.ledger.Invoices.insert;
    Lino.ledger.Invoices.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Invoices.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.ledger.Invoices.insertPanel(p);
});
Lino.ledger.Invoices.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Invoices","GET",pk,"poststay",null);
};

Lino.ledger.Invoices.detailPanel = Ext.extend(Lino.ledger.Invoices.DetailFormPanel,{
  empty_title: "Detail Invoices",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/ledger/Invoices",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Invoices.detail;
    this.ls_insert_handler = Lino.ledger.Invoices.insert;
    Lino.ledger.Invoices.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Invoices.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.Invoices.detailPanel(p);
});
Lino.ledger.Invoices.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.ledger.Invoices.ParamsPanel({});
  return new Lino.ledger.Invoices.GridPanel(p);
});
Lino.ledger.Invoices.deregister_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Invoices","GET",pk,"deregister_action",null);
};
Lino.ledger.Invoices.register_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Invoices","GET",pk,"register_action",null);
};

// js_render_GridPanel_class declarations.Declarations
Lino.declarations.Declarations.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/declarations/Declarations",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/declarations/Declarations','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/declarations/Declarations','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/declarations/Declarations','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "VAT declarations",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 25,
  ls_store_fields : [ { "name": "year" }, 'yearHidden', { "name": "period" }, 'periodHidden', { "name": "workflow_buttons" }, { "name": "user" }, 'userHidden', { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "journal" }, 'journalHidden', { "type": "int", "name": "number" }, { "name": "narration" }, { "name": "declared_in" }, 'declared_inHidden', { "name": "sales_base" }, { "name": "sales_vat" }, { "name": "purchases_base" }, { "name": "purchases_vat" }, { "name": "purchases_investments" }, { "name": "purchases_ware" }, { "name": "purchases_services" }, { "name": "state" }, 'stateHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 23,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.declarations.Declarations.detail;
    this.ls_insert_handler = Lino.declarations.Declarations.insert;
    var ww = this.containing_window;
    var year1219 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var period1220 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.declarations.DeclarationPeriods });
    var workflow_buttons_disp1221 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var user1222 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/declarations/Declarations/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var date1223 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var journal1224 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/declarations/Declarations/journal", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Journal..." });
    var number1225 = new Ext.form.NumberField({ "selectOnFocus": true });
    var narration1226 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var declared_in1227 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/declarations/Declarations/declared_in", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a VAT declaration..." });
    var sales_base1228 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": false, "decimalSeparator": "," });
    var sales_vat1229 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": false, "decimalSeparator": "," });
    var purchases_base1230 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": false, "decimalSeparator": "," });
    var purchases_vat1231 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": false, "decimalSeparator": "," });
    var purchases_investments1232 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": false, "decimalSeparator": "," });
    var purchases_ware1233 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": false, "decimalSeparator": "," });
    var purchases_services1234 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": false, "decimalSeparator": "," });
    var state1235 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.declarations.DeclarationStates });
    var id1236 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Fiscal Year", "editable": true, "tooltip": "(declarations.Declarations.year) ", "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "year", "editor": year1219 }, { "colIndex": 1, "sortable": true, "header": "VAT Period", "editable": true, "tooltip": "(declarations.Declarations.period) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "period", "editor": period1220 }, { "width": Lino.chars2width(31), "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "header": "Workflow", "editable": false, "tooltip": "(declarations.Declarations.workflow_buttons) " }, { "colIndex": 3, "sortable": true, "header": "Author", "editable": true, "tooltip": "(declarations.Declarations.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1222, "dataIndex": "user" }, { "colIndex": 4, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(declarations.Declarations.date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "date", "width": Lino.chars2width(9), "editor": date1223 }, { "colIndex": 5, "sortable": true, "header": "Journal", "editable": true, "tooltip": "(declarations.Declarations.journal) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('journalHidden','Lino.ledger.Journals.detail'), "editor": journal1224, "dataIndex": "journal" }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(declarations.Declarations.number) ", "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(6), "editor": number1225 }), { "colIndex": 7, "sortable": true, "header": "Narration", "editable": true, "tooltip": "(declarations.Declarations.narration) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "narration", "editor": narration1226 }, { "colIndex": 8, "sortable": true, "header": "VAT declaration", "editable": true, "tooltip": "(declarations.Declarations.declared_in) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('declared_inHidden','Lino.declarations.Declarations.detail'), "editor": declared_in1227, "dataIndex": "declared_in" }, new Lino.NullNumberColumn({ "colIndex": 9, "sortable": true, "header": "Sales base", "editable": true, "tooltip": "(declarations.Declarations.sales_base) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "sales_base", "editor": sales_base1228 }), new Lino.NullNumberColumn({ "colIndex": 10, "sortable": true, "header": "Sales VAT", "editable": true, "tooltip": "(declarations.Declarations.sales_vat) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "sales_vat", "editor": sales_vat1229 }), new Lino.NullNumberColumn({ "colIndex": 11, "sortable": true, "header": "Purchases base", "editable": true, "tooltip": "(declarations.Declarations.purchases_base) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "purchases_base", "editor": purchases_base1230 }), new Lino.NullNumberColumn({ "colIndex": 12, "sortable": true, "header": "Purchases VAT", "editable": true, "tooltip": "(declarations.Declarations.purchases_vat) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "purchases_vat", "editor": purchases_vat1231 }), new Lino.NullNumberColumn({ "colIndex": 13, "sortable": true, "header": "Investments", "editable": true, "tooltip": "(declarations.Declarations.purchases_investments) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "purchases_investments", "editor": purchases_investments1232 }), new Lino.NullNumberColumn({ "colIndex": 14, "sortable": true, "header": "Ware", "editable": true, "tooltip": "(declarations.Declarations.purchases_ware) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "purchases_ware", "editor": purchases_ware1233 }), new Lino.NullNumberColumn({ "colIndex": 15, "sortable": true, "header": "Services", "editable": true, "tooltip": "(declarations.Declarations.purchases_services) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "purchases_services", "editor": purchases_services1234 }), { "colIndex": 16, "sortable": true, "header": "State", "editable": true, "tooltip": "(declarations.Declarations.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(14), "dataIndex": "state", "editor": state1235 }, new Lino.NullNumberColumn({ "colIndex": 17, "sortable": true, "format": "0", "editable": true, "tooltip": "(declarations.Declarations.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1236, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.declarations.Declarations.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.declarations.Declarations.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/declarations/Declarations","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.declarations.Declarations.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/declarations/Declarations","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.declarations.Declarations.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/declarations/Declarations","GET",pk,"put",null);
};
Lino.declarations.Declarations.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/declarations/Declarations","GET",pk,"post",null);
};

Lino.declarations.Declarations.insertPanel = Ext.extend(Lino.declarations.Declarations.InsertFormPanel,{
  empty_title: "New VAT declarations",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/declarations/Declarations",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.declarations.Declarations.detail;
    this.ls_insert_handler = Lino.declarations.Declarations.insert;
    Lino.declarations.Declarations.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.declarations.Declarations.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.declarations.Declarations.insertPanel(p);
});
Lino.declarations.Declarations.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/declarations/Declarations","GET",pk,"poststay",null);
};

Lino.declarations.Declarations.detailPanel = Ext.extend(Lino.declarations.Declarations.DetailFormPanel,{
  empty_title: "Detail VAT declarations",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/declarations/Declarations",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.declarations.Declarations.detail;
    this.ls_insert_handler = Lino.declarations.Declarations.insert;
    Lino.declarations.Declarations.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.declarations.Declarations.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.declarations.Declarations.detailPanel(p);
});
Lino.declarations.Declarations.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.declarations.Declarations.GridPanel(p);
});
Lino.declarations.Declarations.deregister_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/declarations/Declarations","GET",pk,"deregister_action",null);
};
Lino.declarations.Declarations.register_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/declarations/Declarations","GET",pk,"register_action",null);
};

// js_render_GridPanel_class sales.PaymentTerms
Lino.sales.PaymentTerms.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/sales/PaymentTerms",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/sales/PaymentTerms','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/PaymentTerms','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/PaymentTerms','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Payment Terms",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 8,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "type": "int", "name": "days" }, { "type": "int", "name": "months" }, { "type": "boolean", "name": "end_of_month" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 38,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id1238 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1239 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1240 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1241 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var days1242 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var months1243 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var end_of_month1244 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(sales.PaymentTerms.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1238, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(sales.PaymentTerms.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1239 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(sales.PaymentTerms.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de1240 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(sales.PaymentTerms.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1241 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(sales.PaymentTerms.days) ", "filter": { "type": "numeric" }, "header": "days", "dataIndex": "days", "width": Lino.chars2width(6), "editor": days1242 }), new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(sales.PaymentTerms.months) ", "filter": { "type": "numeric" }, "header": "months", "dataIndex": "months", "width": Lino.chars2width(6), "editor": months1243 }), { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "end of month", "editable": true, "tooltip": "(sales.PaymentTerms.end_of_month) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "end_of_month" } ];
    Lino.sales.PaymentTerms.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.PaymentTerms.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/PaymentTerms","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.sales.PaymentTerms.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/PaymentTerms","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.sales.PaymentTerms.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/PaymentTerms","GET",pk,"put",null);
};
Lino.sales.PaymentTerms.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/PaymentTerms","GET",pk,"post",null);
};
Lino.sales.PaymentTerms.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.PaymentTerms.GridPanel(p);
});

// js_render_GridPanel_class sales.InvoicingModes
Lino.sales.InvoicingModes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/sales/InvoicingModes",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/sales/InvoicingModes','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/InvoicingModes','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/InvoicingModes','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Invoicing Modes",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 10,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "build_method" }, 'build_methodHidden', { "name": "template" }, { "name": "price" }, { "type": "int", "name": "advance_days" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 34,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id1246 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1247 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1248 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1249 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var build_method1250 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template1251 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoicingModes/template", "method": "GET" }) }) });
    var price1252 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var advance_days1253 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    this.before_row_edit = function(record) {
      template1251.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      build_method1250.on('change',Lino.chooser_handler(template1251,'build_method'));
      Lino.sales.InvoicingModes.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(sales.InvoicingModes.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1246, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(sales.InvoicingModes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1247 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(sales.InvoicingModes.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de1248 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(sales.InvoicingModes.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1249 }, { "colIndex": 4, "sortable": true, "header": "Build method", "editable": true, "tooltip": "(sales.InvoicingModes.build_method) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "build_method", "editor": build_method1250 }, { "colIndex": 5, "sortable": true, "header": "Template", "editable": true, "tooltip": "(sales.InvoicingModes.template) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "template", "editor": template1251 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "header": "price", "editable": true, "tooltip": "(sales.InvoicingModes.price) Additional fee charged when using this invoicing mode.", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "price", "editor": price1252 }), new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "format": "0", "editable": true, "tooltip": "(sales.InvoicingModes.advance_days) \nHow many days in advance invoices should be posted so that the customer\nhas a chance to pay them in time.", "filter": { "type": "numeric" }, "header": "advance days", "dataIndex": "advance_days", "width": Lino.chars2width(6), "editor": advance_days1253 }) ];
    Lino.sales.InvoicingModes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.InvoicingModes.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoicingModes","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.sales.InvoicingModes.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoicingModes","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.sales.InvoicingModes.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoicingModes","GET",pk,"put",null);
};
Lino.sales.InvoicingModes.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoicingModes","GET",pk,"post",null);
};
Lino.sales.InvoicingModes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.InvoicingModes.GridPanel(p);
});

// js_render_GridPanel_class sales.ShippingModes
Lino.sales.ShippingModes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/sales/ShippingModes",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/sales/ShippingModes','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/ShippingModes','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/ShippingModes','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Shipping Modes",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "price" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 39,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id1255 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1256 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1257 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1258 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var price1259 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(sales.ShippingModes.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1255, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(sales.ShippingModes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1256 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(sales.ShippingModes.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de1257 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(sales.ShippingModes.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1258 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "header": "price", "editable": true, "tooltip": "(sales.ShippingModes.price) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "price", "editor": price1259 }) ];
    Lino.sales.ShippingModes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.ShippingModes.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/ShippingModes","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.sales.ShippingModes.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/ShippingModes","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.sales.ShippingModes.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/ShippingModes","GET",pk,"put",null);
};
Lino.sales.ShippingModes.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/ShippingModes","GET",pk,"post",null);
};
Lino.sales.ShippingModes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.ShippingModes.GridPanel(p);
});

// js_render_GridPanel_class sales.Invoices
Lino.sales.Invoices.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/sales/Invoices",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/sales/Invoices','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/Invoices','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/Invoices','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.list_action_handler('/sales/Invoices','do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Clear cache", "auto_save": true } ],
  cell_edit : true,
  title : "Invoices",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 37,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "partner" }, 'partnerHidden', { "name": "total_incl" }, { "name": "user" }, 'userHidden', { "name": "journal" }, 'journalHidden', { "name": "year" }, 'yearHidden', { "type": "int", "name": "number" }, { "name": "narration" }, { "name": "declared_in" }, 'declared_inHidden', { "name": "build_time" }, { "name": "total_base" }, { "name": "total_vat" }, { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "match" }, { "name": "language" }, 'languageHidden', { "name": "your_ref" }, { "name": "imode" }, 'imodeHidden', { "name": "shipping_mode" }, 'shipping_modeHidden', { "name": "payment_term" }, 'payment_termHidden', { "name": "subject" }, { "name": "intro" }, { "name": "discount" }, { "type": "date", "name": "due_date", "dateFormat": "d.m.Y" }, { "name": "state" }, 'stateHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.Invoices.detail;
    this.ls_insert_handler = Lino.sales.Invoices.insert;
    var ww = this.containing_window;
    var id1261 = new Ext.form.NumberField({ "selectOnFocus": true });
    var date1262 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var partner1263 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/partner", "method": "GET" }) }), "emptyText": "Select a Partner..." });
    var total_incl1264 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var user1265 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var journal1266 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/journal", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Journal..." });
    var year1267 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var number1268 = new Ext.form.NumberField({ "selectOnFocus": true });
    var narration1269 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var declared_in1270 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/declared_in", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a VAT declaration..." });
    var build_time1271 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var total_base1272 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat1273 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var vat_regime1274 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.vat.VatRegimes });
    var match1275 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/match", "method": "GET" }) }) });
    var language1276 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ] });
    var your_ref1277 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var imode1278 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Invoicing Mode..." });
    var shipping_mode1279 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/shipping_mode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Shipping Mode..." });
    var payment_term1280 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Payment Term..." });
    var subject1281 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var intro1282 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var discount1283 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var due_date1284 = new Lino.DateField({ "selectOnFocus": true });
    var state1285 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.sales.InvoiceStates });
    this.before_row_edit = function(record) {
      match1275.setContextValue('partner',record ? record.data['partnerHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      partner1263.on('change',Lino.chooser_handler(match1275,'partner'));
      Lino.sales.Invoices.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(sales.Invoices.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1261, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(sales.Invoices.date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "date", "width": Lino.chars2width(9), "editor": date1262 }, { "colIndex": 2, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(sales.Invoices.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner1263, "dataIndex": "partner" }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "header": "Total incl. VAT", "editable": true, "tooltip": "(sales.Invoices.total_incl) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_incl", "editor": total_incl1264 }), { "colIndex": 4, "sortable": true, "header": "Author", "editable": true, "tooltip": "(sales.Invoices.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1265, "dataIndex": "user" }, { "colIndex": 5, "sortable": true, "header": "Journal", "editable": true, "tooltip": "(sales.Invoices.journal) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('journalHidden','Lino.ledger.Journals.detail'), "editor": journal1266, "dataIndex": "journal" }, { "colIndex": 6, "sortable": true, "header": "Fiscal Year", "editable": true, "tooltip": "(sales.Invoices.year) ", "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "year", "editor": year1267 }, new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "format": "0", "editable": true, "tooltip": "(sales.Invoices.number) ", "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(6), "editor": number1268 }), { "colIndex": 8, "sortable": true, "header": "Narration", "editable": true, "tooltip": "(sales.Invoices.narration) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "narration", "editor": narration1269 }, { "colIndex": 9, "sortable": true, "header": "VAT declaration", "editable": true, "tooltip": "(sales.Invoices.declared_in) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('declared_inHidden','Lino.declarations.Declarations.detail'), "editor": declared_in1270, "dataIndex": "declared_in" }, { "width": Lino.chars2width(17), "colIndex": 10, "sortable": true, "dataIndex": "build_time", "header": "build time", "editable": false, "tooltip": "(sales.Invoices.build_time) " }, new Lino.NullNumberColumn({ "colIndex": 11, "sortable": true, "header": "Total excl. VAT", "editable": true, "tooltip": "(sales.Invoices.total_base) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_base", "editor": total_base1272 }), new Lino.NullNumberColumn({ "colIndex": 12, "sortable": true, "header": "VAT", "editable": true, "tooltip": "(sales.Invoices.total_vat) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_vat", "editor": total_vat1273 }), { "colIndex": 13, "sortable": true, "header": "VAT Regime", "editable": true, "tooltip": "(sales.Invoices.vat_regime) ", "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "vat_regime", "editor": vat_regime1274 }, { "colIndex": 14, "sortable": true, "header": "Match", "editable": true, "tooltip": "(sales.Invoices.match) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "match", "editor": match1275 }, { "colIndex": 15, "sortable": true, "header": "Language", "editable": true, "tooltip": "(sales.Invoices.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language1276 }, { "colIndex": 16, "sortable": true, "header": "Your reference", "editable": true, "tooltip": "(sales.Invoices.your_ref) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "your_ref", "editor": your_ref1277 }, { "colIndex": 17, "sortable": true, "header": "Invoicing Mode", "editable": true, "tooltip": "(sales.Invoices.imode) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "imode", "editor": imode1278 }, { "colIndex": 18, "sortable": true, "header": "Shipping Mode", "editable": true, "tooltip": "(sales.Invoices.shipping_mode) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "shipping_mode", "editor": shipping_mode1279 }, { "colIndex": 19, "sortable": true, "header": "Payment Term", "editable": true, "tooltip": "(sales.Invoices.payment_term) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "payment_term", "editor": payment_term1280 }, { "colIndex": 20, "sortable": true, "header": "Subject line", "editable": true, "tooltip": "(sales.Invoices.subject) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "subject", "editor": subject1281 }, { "colIndex": 21, "sortable": false, "header": "Introductive Text", "editable": true, "tooltip": "(sales.Invoices.intro) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": intro1282, "dataIndex": "intro" }, new Lino.NullNumberColumn({ "colIndex": 22, "sortable": true, "header": "Discount", "editable": true, "tooltip": "(sales.Invoices.discount) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(8), "dataIndex": "discount", "editor": discount1283 }), { "colIndex": 23, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(sales.Invoices.due_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date of payment", "dataIndex": "due_date", "width": Lino.chars2width(9), "editor": due_date1284 }, { "colIndex": 24, "sortable": true, "header": "State", "editable": true, "tooltip": "(sales.Invoices.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(14), "dataIndex": "state", "editor": state1285 } ];
    Lino.sales.Invoices.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.Invoices.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/Invoices","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.sales.Invoices.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/Invoices","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.sales.Invoices.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/Invoices","GET",pk,"put",null);
};
Lino.sales.Invoices.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/Invoices","GET",pk,"post",null);
};

Lino.sales.Invoices.insertPanel = Ext.extend(Lino.sales.Invoices.InsertFormPanel,{
  empty_title: "New Invoices",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true } ],
  ls_url: "/sales/Invoices",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.Invoices.detail;
    this.ls_insert_handler = Lino.sales.Invoices.insert;
    Lino.sales.Invoices.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.Invoices.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.sales.Invoices.insertPanel(p);
});
Lino.sales.Invoices.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/Invoices","GET",pk,"poststay",null);
};
Lino.sales.Invoices.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/Invoices","GET",pk,"duplicate",null);
};

Lino.sales.Invoices.detailPanel = Ext.extend(Lino.sales.Invoices.DetailFormPanel,{
  empty_title: "Detail Invoices",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.list_action_handler('/sales/Invoices','do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Clear cache", "auto_save": true } ],
  ls_url: "/sales/Invoices",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.Invoices.detail;
    this.ls_insert_handler = Lino.sales.Invoices.insert;
    Lino.sales.Invoices.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.Invoices.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.Invoices.detailPanel(p);
});
Lino.sales.Invoices.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/Invoices","POST",pk,"do_print",null);
};
Lino.sales.Invoices.do_clear_cache = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/Invoices","GET",pk,"do_clear_cache",null);
};
Lino.sales.Invoices.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.sales.Invoices.ParamsPanel({});
  return new Lino.sales.Invoices.GridPanel(p);
});
Lino.sales.Invoices.deregister_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/Invoices","GET",pk,"deregister_action",null);
};
Lino.sales.Invoices.register_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/Invoices","GET",pk,"register_action",null);
};

// js_render_GridPanel_class sales.DocumentsToSign
Lino.sales.DocumentsToSign.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/sales/DocumentsToSign",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/sales/DocumentsToSign','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/DocumentsToSign','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/DocumentsToSign','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.list_action_handler('/sales/DocumentsToSign','do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Clear cache", "auto_save": true } ],
  cell_edit : true,
  title : "Invoices",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 12,
  ls_store_fields : [ { "type": "int", "name": "number" }, { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "partner" }, 'partnerHidden', { "name": "imode" }, 'imodeHidden', { "name": "subject" }, { "name": "total_incl" }, { "name": "total_base" }, { "name": "total_vat" }, { "name": "voucher_ptr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 10,
  ls_grid_configs : [  ],
  content_type : 37,
  ls_id_property : "voucher_ptr",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.DocumentsToSign.detail;
    this.ls_insert_handler = Lino.sales.DocumentsToSign.insert;
    var ww = this.containing_window;
    var number1287 = new Ext.form.NumberField({ "selectOnFocus": true });
    var date1288 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var partner1289 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/DocumentsToSign/partner", "method": "GET" }) }), "emptyText": "Select a Partner..." });
    var imode1290 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/DocumentsToSign/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Invoicing Mode..." });
    var subject1291 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var total_incl1292 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_base1293 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat1294 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(sales.DocumentsToSign.number) ", "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(5), "editor": number1287 }), { "colIndex": 1, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(sales.DocumentsToSign.date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "date", "width": Lino.chars2width(9), "editor": date1288 }, { "colIndex": 2, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(sales.DocumentsToSign.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner1289, "dataIndex": "partner" }, { "colIndex": 3, "sortable": true, "header": "Invoicing Mode", "editable": true, "tooltip": "(sales.DocumentsToSign.imode) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "imode", "editor": imode1290 }, { "colIndex": 4, "sortable": true, "header": "Subject line", "editable": true, "tooltip": "(sales.DocumentsToSign.subject) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "subject", "editor": subject1291 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "header": "Total incl. VAT", "editable": true, "tooltip": "(sales.DocumentsToSign.total_incl) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_incl", "editor": total_incl1292 }), new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "header": "Total excl. VAT", "editable": true, "tooltip": "(sales.DocumentsToSign.total_base) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_base", "editor": total_base1293 }), new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "header": "VAT", "editable": true, "tooltip": "(sales.DocumentsToSign.total_vat) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_vat", "editor": total_vat1294 }) ];
    Lino.sales.DocumentsToSign.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.DocumentsToSign.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/DocumentsToSign","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.sales.DocumentsToSign.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/DocumentsToSign","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.sales.DocumentsToSign.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/DocumentsToSign","GET",pk,"put",null);
};
Lino.sales.DocumentsToSign.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/DocumentsToSign","GET",pk,"post",null);
};

Lino.sales.DocumentsToSign.insertPanel = Ext.extend(Lino.sales.Invoices.InsertFormPanel,{
  empty_title: "New Invoices",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true } ],
  ls_url: "/sales/DocumentsToSign",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.DocumentsToSign.detail;
    this.ls_insert_handler = Lino.sales.DocumentsToSign.insert;
    Lino.sales.DocumentsToSign.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.DocumentsToSign.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.sales.DocumentsToSign.insertPanel(p);
});
Lino.sales.DocumentsToSign.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/DocumentsToSign","GET",pk,"poststay",null);
};
Lino.sales.DocumentsToSign.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/DocumentsToSign","GET",pk,"duplicate",null);
};

Lino.sales.DocumentsToSign.detailPanel = Ext.extend(Lino.sales.Invoices.DetailFormPanel,{
  empty_title: "Detail Invoices",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.list_action_handler('/sales/DocumentsToSign','do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Clear cache", "auto_save": true } ],
  ls_url: "/sales/DocumentsToSign",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.DocumentsToSign.detail;
    this.ls_insert_handler = Lino.sales.DocumentsToSign.insert;
    Lino.sales.DocumentsToSign.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.DocumentsToSign.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.DocumentsToSign.detailPanel(p);
});
Lino.sales.DocumentsToSign.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/DocumentsToSign","POST",pk,"do_print",null);
};
Lino.sales.DocumentsToSign.do_clear_cache = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/DocumentsToSign","GET",pk,"do_clear_cache",null);
};
Lino.sales.DocumentsToSign.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.sales.Invoices.ParamsPanel({});
  return new Lino.sales.DocumentsToSign.GridPanel(p);
});
Lino.sales.DocumentsToSign.deregister_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/DocumentsToSign","GET",pk,"deregister_action",null);
};
Lino.sales.DocumentsToSign.register_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/DocumentsToSign","GET",pk,"register_action",null);
};

// js_render_GridPanel_class finan.BankStatements
Lino.finan.BankStatements.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/finan/BankStatements",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/finan/BankStatements','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/finan/BankStatements','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/finan/BankStatements','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Bank Statements",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 17,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "type": "int", "name": "id" }, { "type": "int", "name": "number" }, { "name": "balance1" }, { "name": "balance2" }, { "name": "user" }, 'userHidden', { "name": "journal" }, 'journalHidden', { "name": "year" }, 'yearHidden', { "name": "narration" }, { "name": "declared_in" }, 'declared_inHidden', { "name": "state" }, 'stateHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 1,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.finan.BankStatements.detail;
    this.ls_insert_handler = Lino.finan.BankStatements.insert;
    var ww = this.containing_window;
    var date1296 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var id1297 = new Ext.form.NumberField({ "selectOnFocus": true });
    var number1298 = new Ext.form.NumberField({ "selectOnFocus": true });
    var balance11299 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var balance21300 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var user1301 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/BankStatements/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var journal1302 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/BankStatements/journal", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Journal..." });
    var year1303 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var narration1304 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var declared_in1305 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/BankStatements/declared_in", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a VAT declaration..." });
    var state1306 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.finan.VoucherStates });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(finan.BankStatements.date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "date", "width": Lino.chars2width(9), "editor": date1296 }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "format": "0", "editable": true, "tooltip": "(finan.BankStatements.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1297, "width": Lino.chars2width(6), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(finan.BankStatements.number) ", "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(6), "editor": number1298 }), new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "header": "Old balance", "editable": true, "tooltip": "(finan.BankStatements.balance1) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "balance1", "editor": balance11299 }), new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "header": "New balance", "editable": true, "tooltip": "(finan.BankStatements.balance2) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "balance2", "editor": balance21300 }), { "colIndex": 5, "sortable": true, "header": "Author", "editable": true, "tooltip": "(finan.BankStatements.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1301, "dataIndex": "user" }, { "colIndex": 6, "sortable": true, "header": "Journal", "editable": true, "tooltip": "(finan.BankStatements.journal) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('journalHidden','Lino.ledger.Journals.detail'), "editor": journal1302, "dataIndex": "journal" }, { "colIndex": 7, "sortable": true, "header": "Fiscal Year", "editable": true, "tooltip": "(finan.BankStatements.year) ", "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "year", "editor": year1303 }, { "colIndex": 8, "sortable": true, "header": "Narration", "editable": true, "tooltip": "(finan.BankStatements.narration) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "narration", "editor": narration1304 }, { "colIndex": 9, "sortable": true, "header": "VAT declaration", "editable": true, "tooltip": "(finan.BankStatements.declared_in) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('declared_inHidden','Lino.declarations.Declarations.detail'), "editor": declared_in1305, "dataIndex": "declared_in" }, { "colIndex": 10, "sortable": true, "header": "State", "editable": true, "tooltip": "(finan.BankStatements.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(14), "dataIndex": "state", "editor": state1306 } ];
    Lino.finan.BankStatements.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.finan.BankStatements.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/finan/BankStatements","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.finan.BankStatements.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/finan/BankStatements","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.finan.BankStatements.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/finan/BankStatements","GET",pk,"put",null);
};
Lino.finan.BankStatements.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/finan/BankStatements","GET",pk,"post",null);
};

Lino.finan.BankStatements.insertPanel = Ext.extend(Lino.finan.BankStatements.InsertFormPanel,{
  empty_title: "New Bank Statements",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/finan/BankStatements",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.finan.BankStatements.detail;
    this.ls_insert_handler = Lino.finan.BankStatements.insert;
    Lino.finan.BankStatements.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.finan.BankStatements.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.finan.BankStatements.insertPanel(p);
});
Lino.finan.BankStatements.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/finan/BankStatements","GET",pk,"poststay",null);
};

Lino.finan.BankStatements.detailPanel = Ext.extend(Lino.finan.BankStatements.DetailFormPanel,{
  empty_title: "Detail Bank Statements",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/finan/BankStatements",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.finan.BankStatements.detail;
    this.ls_insert_handler = Lino.finan.BankStatements.insert;
    Lino.finan.BankStatements.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.finan.BankStatements.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.finan.BankStatements.detailPanel(p);
});
Lino.finan.BankStatements.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.finan.BankStatements.ParamsPanel({});
  return new Lino.finan.BankStatements.GridPanel(p);
});
Lino.finan.BankStatements.deregister_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/finan/BankStatements","GET",pk,"deregister_action",null);
};
Lino.finan.BankStatements.register_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/finan/BankStatements","GET",pk,"register_action",null);
};

// js_render_GridPanel_class finan.DocItems
Lino.finan.DocItems.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/finan/DocItems",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/finan/DocItems','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/finan/DocItems','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/finan/DocItems','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-arrow_up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-arrow_down", "overflowText": "Down", "auto_save": true } ],
  cell_edit : true,
  title : "Items",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 17,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "account" }, 'accountHidden', { "name": "partner" }, 'partnerHidden', { "name": "match" }, { "name": "remark" }, { "name": "debit" }, { "name": "credit" }, { "type": "int", "name": "seqno" }, { "type": "int", "name": "id" }, { "name": "title" }, { "name": "voucher" }, 'voucherHidden', { "name": "amount" }, { "type": "boolean", "name": "dc" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 10,
  ls_grid_configs : [  ],
  content_type : 41,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var date1308 = new Lino.DateField({ "selectOnFocus": true });
    var account1309 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/DocItems/account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var partner1310 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/DocItems/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var match1311 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/DocItems/match", "method": "GET" }) }) });
    var remark1312 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var debit1313 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": false, "decimalSeparator": "," });
    var credit1314 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": false, "decimalSeparator": "," });
    var seqno1315 = new Ext.form.NumberField({ "selectOnFocus": true });
    var id1316 = new Ext.form.NumberField({ "selectOnFocus": true });
    var title1317 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var voucher1318 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/DocItems/voucher", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Bank Statement..." });
    var amount1319 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalSeparator": ",", "decimalPrecision": 2, "allowBlank": false, "value": 0 });
    var dc1320 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
      match1311.setContextValue('partner',record ? record.data['partnerHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      partner1310.on('change',Lino.chooser_handler(match1311,'partner'));
      Lino.finan.DocItems.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(finan.DocItems.date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "date", "dataIndex": "date", "width": Lino.chars2width(9), "editor": date1308 }, { "colIndex": 1, "sortable": true, "header": "Account", "editable": true, "tooltip": "(finan.DocItems.account) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "account", "editor": account1309 }, { "colIndex": 2, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(finan.DocItems.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner1310, "dataIndex": "partner" }, { "colIndex": 3, "sortable": true, "header": "Match", "editable": true, "tooltip": "(finan.DocItems.match) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "match", "editor": match1311 }, { "colIndex": 4, "sortable": true, "header": "Remark", "editable": true, "tooltip": "(finan.DocItems.remark) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "remark", "editor": remark1312 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": false, "header": "Income", "editable": true, "tooltip": "(finan.DocItems.debit) ", "width": Lino.chars2width(13), "dataIndex": "debit", "editor": debit1313 }), new Lino.NullNumberColumn({ "colIndex": 6, "sortable": false, "header": "Expense", "editable": true, "tooltip": "(finan.DocItems.credit) ", "width": Lino.chars2width(13), "dataIndex": "credit", "editor": credit1314 }), new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "format": "0", "editable": true, "tooltip": "(finan.DocItems.seqno) ", "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "width": Lino.chars2width(6), "editor": seqno1315 }), new Lino.NullNumberColumn({ "colIndex": 8, "sortable": true, "format": "0", "editable": true, "tooltip": "(finan.DocItems.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1316, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 9, "sortable": true, "header": "Description", "editable": true, "tooltip": "(finan.DocItems.title) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "title", "editor": title1317 }, { "colIndex": 10, "sortable": true, "header": "Bank Statement", "editable": true, "tooltip": "(finan.DocItems.voucher) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('voucherHidden','Lino.finan.BankStatements.detail'), "editor": voucher1318, "dataIndex": "voucher" }, new Lino.NullNumberColumn({ "colIndex": 11, "sortable": true, "header": "amount", "editable": true, "tooltip": "(finan.DocItems.amount) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "amount", "editor": amount1319 }), { "colIndex": 12, "sortable": false, "xtype": "checkcolumn", "header": "dc", "editable": true, "tooltip": "(finan.DocItems.dc) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "dc" } ];
    Lino.finan.DocItems.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.finan.DocItems.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/finan/DocItems","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.finan.DocItems.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/finan/DocItems","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.finan.DocItems.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/finan/DocItems","GET",pk,"put",null);
};
Lino.finan.DocItems.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/finan/DocItems","GET",pk,"post",null);
};
Lino.finan.DocItems.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/finan/DocItems","GET",pk,"duplicate",null);
};
Lino.finan.DocItems.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.finan.DocItems.GridPanel(p);
});
Lino.finan.DocItems.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/finan/DocItems","GET",pk,"move_up",null);
};
Lino.finan.DocItems.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/finan/DocItems","GET",pk,"move_down",null);
};

// js_render_GridPanel_class pages.Pages
Lino.pages.Pages.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/pages/Pages",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/pages/Pages','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/pages/Pages','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/pages/Pages','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-arrow_up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-arrow_down", "overflowText": "Down", "auto_save": true } ],
  cell_edit : true,
  title : "Nodes",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 10,
  ls_store_fields : [ { "name": "ref" }, { "name": "title" }, { "name": "title_de" }, { "name": "title_fr" }, { "type": "int", "name": "id" }, { "type": "int", "name": "seqno" }, { "name": "parent" }, 'parentHidden', { "type": "boolean", "name": "raw_html" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 44,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.pages.Pages.detail;
    this.ls_insert_handler = Lino.pages.Pages.insert;
    var ww = this.containing_window;
    var ref1322 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var title1323 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var title_de1324 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var title_fr1325 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1326 = new Ext.form.NumberField({ "selectOnFocus": true });
    var seqno1327 = new Ext.form.NumberField({ "selectOnFocus": true });
    var parent1328 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pages/Pages/parent", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Node..." });
    var raw_html1329 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Reference", "editable": true, "tooltip": "(pages.Pages.ref) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ref", "editor": ref1322 }, { "colIndex": 1, "sortable": true, "header": "Title", "editable": true, "tooltip": "(pages.Pages.title) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "title", "editor": title1323 }, { "colIndex": 2, "sortable": true, "header": "Title (de)", "editable": true, "tooltip": "(pages.Pages.title_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "title_de", "editor": title_de1324 }, { "colIndex": 3, "sortable": true, "header": "Title (fr)", "editable": true, "tooltip": "(pages.Pages.title_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "title_fr", "editor": title_fr1325 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(pages.Pages.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1326, "width": Lino.chars2width(6), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(pages.Pages.seqno) ", "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "width": Lino.chars2width(6), "editor": seqno1327 }), { "colIndex": 6, "sortable": true, "header": "Parent", "editable": true, "tooltip": "(pages.Pages.parent) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('parentHidden','Lino.pages.Pages.detail'), "editor": parent1328, "dataIndex": "parent" }, { "colIndex": 7, "sortable": false, "xtype": "checkcolumn", "header": "raw html", "editable": true, "tooltip": "(pages.Pages.raw_html) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "raw_html" } ];
    Lino.pages.Pages.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pages.Pages.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/pages/Pages","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.pages.Pages.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/pages/Pages","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.pages.Pages.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/pages/Pages","GET",pk,"put",null);
};
Lino.pages.Pages.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/pages/Pages","GET",pk,"post",null);
};

Lino.pages.Pages.insertPanel = Ext.extend(Lino.pages.Pages.DetailFormPanel,{
  empty_title: "New Nodes",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true } ],
  ls_url: "/pages/Pages",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.pages.Pages.detail;
    this.ls_insert_handler = Lino.pages.Pages.insert;
    Lino.pages.Pages.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.pages.Pages.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pages.Pages.insertPanel(p);
});
Lino.pages.Pages.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/pages/Pages","GET",pk,"poststay",null);
};
Lino.pages.Pages.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/pages/Pages","GET",pk,"duplicate",null);
};

Lino.pages.Pages.detailPanel = Ext.extend(Lino.pages.Pages.DetailFormPanel,{
  empty_title: "Detail Nodes",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-arrow_up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-arrow_down", "overflowText": "Down", "auto_save": true } ],
  ls_url: "/pages/Pages",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.pages.Pages.detail;
    this.ls_insert_handler = Lino.pages.Pages.insert;
    Lino.pages.Pages.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.pages.Pages.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pages.Pages.detailPanel(p);
});
Lino.pages.Pages.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pages.Pages.GridPanel(p);
});
Lino.pages.Pages.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/pages/Pages","GET",pk,"move_up",null);
};
Lino.pages.Pages.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/pages/Pages","GET",pk,"move_down",null);
};

// js_render_GridPanel_class sales.SalesRuleTable
Lino.sales.SalesRuleTable.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/sales/SalesRuleTable",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/sales/SalesRuleTable','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/SalesRuleTable','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/SalesRuleTable','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Sales Rules",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 8,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "imode" }, 'imodeHidden', { "name": "shipping_mode" }, 'shipping_modeHidden', { "name": "payment_term" }, 'payment_termHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 36,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id1331 = new Ext.form.NumberField({ "selectOnFocus": true });
    var imode1332 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/SalesRuleTable/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Invoicing Mode..." });
    var shipping_mode1333 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/SalesRuleTable/shipping_mode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Shipping Mode..." });
    var payment_term1334 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/SalesRuleTable/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Payment Term..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(sales.SalesRuleTable.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1331, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Invoicing Mode", "editable": true, "tooltip": "(sales.SalesRuleTable.imode) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "imode", "editor": imode1332 }, { "colIndex": 2, "sortable": true, "header": "Shipping Mode", "editable": true, "tooltip": "(sales.SalesRuleTable.shipping_mode) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "shipping_mode", "editor": shipping_mode1333 }, { "colIndex": 3, "sortable": true, "header": "Payment Term", "editable": true, "tooltip": "(sales.SalesRuleTable.payment_term) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "payment_term", "editor": payment_term1334 } ];
    Lino.sales.SalesRuleTable.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.SalesRuleTable.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/SalesRuleTable","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.sales.SalesRuleTable.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/SalesRuleTable","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.sales.SalesRuleTable.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/SalesRuleTable","GET",pk,"put",null);
};
Lino.sales.SalesRuleTable.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/SalesRuleTable","GET",pk,"post",null);
};
Lino.sales.SalesRuleTable.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.SalesRuleTable.GridPanel(p);
});

// js_render_GridPanel_class sales.InvoiceItemTable
Lino.sales.InvoiceItemTable.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/sales/InvoiceItemTable",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/sales/InvoiceItemTable','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/InvoiceItemTable','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/InvoiceItemTable','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-arrow_up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-arrow_down", "overflowText": "Down", "auto_save": true } ],
  cell_edit : true,
  title : "invoice items",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 16,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "type": "int", "name": "seqno" }, { "name": "total_incl" }, { "name": "total_base" }, { "name": "total_vat" }, { "name": "vat_class" }, 'vat_classHidden', { "name": "unit_price" }, { "name": "qty" }, { "name": "title" }, { "name": "product" }, 'productHidden', { "name": "discount" }, { "name": "voucher" }, 'voucherHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 35,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id1336 = new Ext.form.NumberField({ "selectOnFocus": true });
    var seqno1337 = new Ext.form.NumberField({ "selectOnFocus": true });
    var total_incl1338 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_base1339 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat1340 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var vat_class1341 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.vat.VatClasses) });
    var unit_price1342 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var qty1343 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(6), "maxLength": 6 });
    var title1344 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var product1345 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoiceItemTable/product", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Product..." });
    var discount1346 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var voucher1347 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoiceItemTable/voucher", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Invoice..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(sales.InvoiceItemTable.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1336, "width": Lino.chars2width(6), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "format": "0", "editable": true, "tooltip": "(sales.InvoiceItemTable.seqno) ", "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "width": Lino.chars2width(6), "editor": seqno1337 }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "header": "Total incl. VAT", "editable": true, "tooltip": "(sales.InvoiceItemTable.total_incl) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_incl", "editor": total_incl1338 }), new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "header": "Total excl. VAT", "editable": true, "tooltip": "(sales.InvoiceItemTable.total_base) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_base", "editor": total_base1339 }), new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "header": "VAT", "editable": true, "tooltip": "(sales.InvoiceItemTable.total_vat) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_vat", "editor": total_vat1340 }), { "colIndex": 5, "sortable": true, "header": "VAT Class", "editable": true, "tooltip": "(sales.InvoiceItemTable.vat_class) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "vat_class", "editor": vat_class1341 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "header": "Unit price", "editable": true, "tooltip": "(sales.InvoiceItemTable.unit_price) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "unit_price", "editor": unit_price1342 }), { "colIndex": 7, "sortable": true, "format": "", "align": "right", "editable": true, "tooltip": "(sales.InvoiceItemTable.qty) ", "filter": { "type": "string" }, "header": "Quantity", "dataIndex": "qty", "width": Lino.chars2width(8), "editor": qty1343 }, { "colIndex": 8, "sortable": true, "header": "Description", "editable": true, "tooltip": "(sales.InvoiceItemTable.title) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "title", "editor": title1344 }, { "colIndex": 9, "sortable": true, "header": "Product", "editable": true, "tooltip": "(sales.InvoiceItemTable.product) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('productHidden','Lino.products.Products.detail'), "editor": product1345, "dataIndex": "product" }, new Lino.NullNumberColumn({ "colIndex": 10, "sortable": true, "header": "Discount", "editable": true, "tooltip": "(sales.InvoiceItemTable.discount) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(8), "dataIndex": "discount", "editor": discount1346 }), { "colIndex": 11, "sortable": true, "header": "Invoice", "editable": true, "tooltip": "(sales.InvoiceItemTable.voucher) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('voucherHidden','Lino.sales.Invoices.detail'), "editor": voucher1347, "dataIndex": "voucher" } ];
    Lino.sales.InvoiceItemTable.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.InvoiceItemTable.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoiceItemTable","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.sales.InvoiceItemTable.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoiceItemTable","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.sales.InvoiceItemTable.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoiceItemTable","GET",pk,"put",null);
};
Lino.sales.InvoiceItemTable.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoiceItemTable","GET",pk,"post",null);
};
Lino.sales.InvoiceItemTable.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoiceItemTable","GET",pk,"duplicate",null);
};
Lino.sales.InvoiceItemTable.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.InvoiceItemTable.GridPanel(p);
});
Lino.sales.InvoiceItemTable.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoiceItemTable","GET",pk,"move_up",null);
};
Lino.sales.InvoiceItemTable.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoiceItemTable","GET",pk,"move_down",null);
};

// js_render_GridPanel_class sessions.SessionTable
Lino.sessions.SessionTable.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/sessions/SessionTable",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/sessions/SessionTable','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sessions/SessionTable','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sessions/SessionTable','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "sessions",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 4,
  ls_store_fields : [ { "name": "session_key" }, { "name": "session_data" }, { "name": "expire_date" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 1,
  ls_id_property : "session_key",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var session_key1349 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 40 });
    var session_data1350 = new Ext.form.TextArea({ "selectOnFocus": true, "allowBlank": false, "growMax": 2000 });
    var expire_date1351 = new Ext.form.DisplayField({ "selectOnFocus": true, "allowBlank": false, "value": "<br>" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "session key", "editable": true, "tooltip": "(sessions.SessionTable.session_key) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "session_key", "editor": session_key1349 }, { "colIndex": 1, "sortable": false, "header": "session data", "editable": true, "tooltip": "(sessions.SessionTable.session_data) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": session_data1350, "dataIndex": "session_data" }, { "colIndex": 2, "sortable": true, "header": "expire date", "editable": true, "tooltip": "(sessions.SessionTable.expire_date) ", "width": Lino.chars2width(17), "dataIndex": "expire_date", "editor": expire_date1351 } ];
    Lino.sessions.SessionTable.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sessions.SessionTable.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/sessions/SessionTable","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.sessions.SessionTable.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/sessions/SessionTable","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.sessions.SessionTable.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/sessions/SessionTable","GET",pk,"put",null);
};
Lino.sessions.SessionTable.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/sessions/SessionTable","GET",pk,"post",null);
};
Lino.sessions.SessionTable.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sessions.SessionTable.GridPanel(p);
});

// js_render_GridPanel_class ledger.InvoiceItemTable
Lino.ledger.InvoiceItemTable.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/ledger/InvoiceItemTable",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/ledger/InvoiceItemTable','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/InvoiceItemTable','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/InvoiceItemTable','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-arrow_up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-arrow_down", "overflowText": "Down", "auto_save": true } ],
  cell_edit : true,
  title : "Voucher items",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 13,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "type": "int", "name": "seqno" }, { "name": "total_incl" }, { "name": "total_base" }, { "name": "total_vat" }, { "name": "vat_class" }, 'vat_classHidden', { "name": "title" }, { "name": "voucher" }, 'voucherHidden', { "name": "account" }, 'accountHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 29,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id1353 = new Ext.form.NumberField({ "selectOnFocus": true });
    var seqno1354 = new Ext.form.NumberField({ "selectOnFocus": true });
    var total_incl1355 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_base1356 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat1357 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var vat_class1358 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.vat.VatClasses) });
    var title1359 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var voucher1360 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/InvoiceItemTable/voucher", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Invoice..." });
    var account1361 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/InvoiceItemTable/account", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account..." });
    this.before_row_edit = function(record) {
      account1361.setContextValue('voucher',record ? record.data['voucherHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      voucher1360.on('change',Lino.chooser_handler(account1361,'voucher'));
      Lino.ledger.InvoiceItemTable.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(ledger.InvoiceItemTable.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1353, "width": Lino.chars2width(6), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "format": "0", "editable": true, "tooltip": "(ledger.InvoiceItemTable.seqno) ", "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "width": Lino.chars2width(6), "editor": seqno1354 }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "header": "Total incl. VAT", "editable": true, "tooltip": "(ledger.InvoiceItemTable.total_incl) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_incl", "editor": total_incl1355 }), new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "header": "Total excl. VAT", "editable": true, "tooltip": "(ledger.InvoiceItemTable.total_base) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_base", "editor": total_base1356 }), new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "header": "VAT", "editable": true, "tooltip": "(ledger.InvoiceItemTable.total_vat) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_vat", "editor": total_vat1357 }), { "colIndex": 5, "sortable": true, "header": "VAT Class", "editable": true, "tooltip": "(ledger.InvoiceItemTable.vat_class) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "vat_class", "editor": vat_class1358 }, { "colIndex": 6, "sortable": true, "header": "Description", "editable": true, "tooltip": "(ledger.InvoiceItemTable.title) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "title", "editor": title1359 }, { "colIndex": 7, "sortable": true, "header": "Invoice", "editable": true, "tooltip": "(ledger.InvoiceItemTable.voucher) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('voucherHidden','Lino.ledger.Invoices.detail'), "editor": voucher1360, "dataIndex": "voucher" }, { "colIndex": 8, "sortable": true, "header": "Account", "editable": true, "tooltip": "(ledger.InvoiceItemTable.account) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "account", "editor": account1361 } ];
    Lino.ledger.InvoiceItemTable.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.InvoiceItemTable.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/InvoiceItemTable","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.ledger.InvoiceItemTable.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/InvoiceItemTable","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.ledger.InvoiceItemTable.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/InvoiceItemTable","GET",pk,"put",null);
};
Lino.ledger.InvoiceItemTable.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/InvoiceItemTable","GET",pk,"post",null);
};
Lino.ledger.InvoiceItemTable.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/InvoiceItemTable","GET",pk,"duplicate",null);
};
Lino.ledger.InvoiceItemTable.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.InvoiceItemTable.GridPanel(p);
});
Lino.ledger.InvoiceItemTable.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/InvoiceItemTable","GET",pk,"move_up",null);
};
Lino.ledger.InvoiceItemTable.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/InvoiceItemTable","GET",pk,"move_down",null);
};

// js_render_GridPanel_class finan.JournalEntryTable
Lino.finan.JournalEntryTable.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "emptyText": "No data to display." },
  ls_url : "/finan/JournalEntryTable",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/finan/JournalEntryTable','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/finan/JournalEntryTable','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/finan/JournalEntryTable','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" } ],
  cell_edit : true,
  title : "Journal Entries",
  page_length : 20,
  stripeRows : true,
  disable_editing : true,
  disabled_actions_index : 15,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "type": "int", "name": "number" }, { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "journal" }, 'journalHidden', { "name": "year" }, 'yearHidden', { "name": "narration" }, { "name": "declared_in" }, 'declared_inHidden', { "name": "state" }, 'stateHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var date1363 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var number1364 = new Ext.form.NumberField({ "selectOnFocus": true });
    var id1365 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1366 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/JournalEntryTable/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var journal1367 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/JournalEntryTable/journal", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Journal..." });
    var year1368 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var narration1369 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var declared_in1370 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/JournalEntryTable/declared_in", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a VAT declaration..." });
    var state1371 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.finan.VoucherStates });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(finan.JournalEntryTable.date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "date", "width": Lino.chars2width(9), "editor": date1363 }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "format": "0", "editable": true, "tooltip": "(finan.JournalEntryTable.number) ", "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(6), "editor": number1364 }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(finan.JournalEntryTable.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1365, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 3, "sortable": true, "header": "Author", "editable": true, "tooltip": "(finan.JournalEntryTable.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1366, "dataIndex": "user" }, { "colIndex": 4, "sortable": true, "header": "Journal", "editable": true, "tooltip": "(finan.JournalEntryTable.journal) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('journalHidden','Lino.ledger.Journals.detail'), "editor": journal1367, "dataIndex": "journal" }, { "colIndex": 5, "sortable": true, "header": "Fiscal Year", "editable": true, "tooltip": "(finan.JournalEntryTable.year) ", "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "year", "editor": year1368 }, { "colIndex": 6, "sortable": true, "header": "Narration", "editable": true, "tooltip": "(finan.JournalEntryTable.narration) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "narration", "editor": narration1369 }, { "colIndex": 7, "sortable": true, "header": "VAT declaration", "editable": true, "tooltip": "(finan.JournalEntryTable.declared_in) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('declared_inHidden','Lino.declarations.Declarations.detail'), "editor": declared_in1370, "dataIndex": "declared_in" }, { "colIndex": 8, "sortable": true, "header": "State", "editable": true, "tooltip": "(finan.JournalEntryTable.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(14), "dataIndex": "state", "editor": state1371 } ];
    Lino.finan.JournalEntryTable.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.finan.JournalEntryTable.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/finan/JournalEntryTable","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.finan.JournalEntryTable.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/finan/JournalEntryTable","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.finan.JournalEntryTable.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.finan.JournalEntryTable.GridPanel(p);
});

// js_render_GridPanel_class finan.PaymentOrderTable
Lino.finan.PaymentOrderTable.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "emptyText": "No data to display." },
  ls_url : "/finan/PaymentOrderTable",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/finan/PaymentOrderTable','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/finan/PaymentOrderTable','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/finan/PaymentOrderTable','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" } ],
  cell_edit : true,
  title : "Payment Orders",
  page_length : 20,
  stripeRows : true,
  disable_editing : true,
  disabled_actions_index : 16,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "type": "int", "name": "number" }, { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "journal" }, 'journalHidden', { "name": "year" }, 'yearHidden', { "name": "narration" }, { "name": "declared_in" }, 'declared_inHidden', { "name": "state" }, 'stateHidden', { "name": "total" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var date1373 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var number1374 = new Ext.form.NumberField({ "selectOnFocus": true });
    var id1375 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1376 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/PaymentOrderTable/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var journal1377 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/PaymentOrderTable/journal", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Journal..." });
    var year1378 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var narration1379 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var declared_in1380 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/PaymentOrderTable/declared_in", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a VAT declaration..." });
    var state1381 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.finan.VoucherStates });
    var total1382 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(finan.PaymentOrderTable.date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "date", "width": Lino.chars2width(9), "editor": date1373 }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "format": "0", "editable": true, "tooltip": "(finan.PaymentOrderTable.number) ", "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(6), "editor": number1374 }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(finan.PaymentOrderTable.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1375, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 3, "sortable": true, "header": "Author", "editable": true, "tooltip": "(finan.PaymentOrderTable.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1376, "dataIndex": "user" }, { "colIndex": 4, "sortable": true, "header": "Journal", "editable": true, "tooltip": "(finan.PaymentOrderTable.journal) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('journalHidden','Lino.ledger.Journals.detail'), "editor": journal1377, "dataIndex": "journal" }, { "colIndex": 5, "sortable": true, "header": "Fiscal Year", "editable": true, "tooltip": "(finan.PaymentOrderTable.year) ", "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "year", "editor": year1378 }, { "colIndex": 6, "sortable": true, "header": "Narration", "editable": true, "tooltip": "(finan.PaymentOrderTable.narration) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "narration", "editor": narration1379 }, { "colIndex": 7, "sortable": true, "header": "VAT declaration", "editable": true, "tooltip": "(finan.PaymentOrderTable.declared_in) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('declared_inHidden','Lino.declarations.Declarations.detail'), "editor": declared_in1380, "dataIndex": "declared_in" }, { "colIndex": 8, "sortable": true, "header": "State", "editable": true, "tooltip": "(finan.PaymentOrderTable.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(14), "dataIndex": "state", "editor": state1381 }, new Lino.NullNumberColumn({ "colIndex": 9, "sortable": true, "header": "Total", "editable": true, "tooltip": "(finan.PaymentOrderTable.total) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total", "editor": total1382 }) ];
    Lino.finan.PaymentOrderTable.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.finan.PaymentOrderTable.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/finan/PaymentOrderTable","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.finan.PaymentOrderTable.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/finan/PaymentOrderTable","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.finan.PaymentOrderTable.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.finan.PaymentOrderTable.GridPanel(p);
});

// js_render_GridPanel_class system.MyTextFieldTemplates
Lino.system.MyTextFieldTemplates.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/system/MyTextFieldTemplates",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/system/MyTextFieldTemplates','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/MyTextFieldTemplates','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/MyTextFieldTemplates','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "My Text Field Templates",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 5,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "team" }, 'teamHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 10,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.system.MyTextFieldTemplates.detail;
    this.ls_insert_handler = Lino.system.MyTextFieldTemplates.insert;
    var ww = this.containing_window;
    var id1384 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1385 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var team1386 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/MyTextFieldTemplates/team", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Team..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.MyTextFieldTemplates.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1384, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(system.MyTextFieldTemplates.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1385 }, { "colIndex": 2, "sortable": true, "header": "Team", "editable": true, "tooltip": "(system.MyTextFieldTemplates.team) If not empty, then this template is reserved to members of this team.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "team", "editor": team1386 } ];
    Lino.system.MyTextFieldTemplates.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.system.MyTextFieldTemplates.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/MyTextFieldTemplates","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.system.MyTextFieldTemplates.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/MyTextFieldTemplates","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.system.MyTextFieldTemplates.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/MyTextFieldTemplates","GET",pk,"put",null);
};
Lino.system.MyTextFieldTemplates.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/MyTextFieldTemplates","GET",pk,"post",null);
};

Lino.system.MyTextFieldTemplates.insertPanel = Ext.extend(Lino.system.TextFieldTemplates.InsertFormPanel,{
  empty_title: "New My Text Field Templates",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/system/MyTextFieldTemplates",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.MyTextFieldTemplates.detail;
    this.ls_insert_handler = Lino.system.MyTextFieldTemplates.insert;
    Lino.system.MyTextFieldTemplates.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.system.MyTextFieldTemplates.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.system.MyTextFieldTemplates.insertPanel(p);
});
Lino.system.MyTextFieldTemplates.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/MyTextFieldTemplates","GET",pk,"poststay",null);
};

Lino.system.MyTextFieldTemplates.detailPanel = Ext.extend(Lino.system.TextFieldTemplates.DetailFormPanel,{
  empty_title: "Detail My Text Field Templates",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/system/MyTextFieldTemplates",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.MyTextFieldTemplates.detail;
    this.ls_insert_handler = Lino.system.MyTextFieldTemplates.insert;
    Lino.system.MyTextFieldTemplates.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.system.MyTextFieldTemplates.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.system.MyTextFieldTemplates.detailPanel(p);
});
Lino.system.MyTextFieldTemplates.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.system.MyTextFieldTemplates.GridPanel(p);
});

// js_render_GridPanel_class users.MembershipsByUser
Lino.users.MembershipsByUser.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "No data to display." },
  ls_url : "/users/MembershipsByUser",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/users/MembershipsByUser','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/MembershipsByUser','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/MembershipsByUser','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "My Memberships",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 4,
  ls_store_fields : [ { "name": "team" }, 'teamHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 11,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var team38 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MembershipsByUser/team", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Team..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Team", "editable": true, "tooltip": "(users.MembershipsByUser.team) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "team", "editor": team38 } ];
    Lino.users.MembershipsByUser.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MembershipsByUser.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MembershipsByUser","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.users.MembershipsByUser.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MembershipsByUser","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.users.MembershipsByUser.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MembershipsByUser","GET",pk,"put",null);
};
Lino.users.MembershipsByUser.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MembershipsByUser","GET",pk,"post",null);
};
Lino.users.MembershipsByUser.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.MembershipsByUser.GridPanel(p);
});

// js_render_GridPanel_class users.AuthoritiesGiven
Lino.users.AuthoritiesGiven.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "No data to display." },
  ls_url : "/users/AuthoritiesGiven",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/users/AuthoritiesGiven','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/AuthoritiesGiven','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/AuthoritiesGiven','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Authorities given",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 4,
  ls_store_fields : [ { "name": "authorized" }, 'authorizedHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 13,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var authorized43 = new Lino.RemoteComboFieldElement({ "preferred_width": 15, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/AuthoritiesGiven/authorized", "method": "GET" }) }), "emptyText": "Select a User..." });
    this.before_row_edit = function(record) {
      var bp = this.get_base_params();
      authorized43.setContextValue('mk',bp['mk']);
      authorized43.setContextValue('mt',bp['mt']);
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "User", "editable": true, "tooltip": "(users.AuthoritiesGiven.authorized) The user who gets authority to act in your name.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('authorizedHidden','Lino.users.Users.detail'), "editor": authorized43, "dataIndex": "authorized" } ];
    Lino.users.AuthoritiesGiven.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.AuthoritiesGiven.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/AuthoritiesGiven","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.users.AuthoritiesGiven.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/AuthoritiesGiven","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.users.AuthoritiesGiven.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/AuthoritiesGiven","GET",pk,"put",null);
};
Lino.users.AuthoritiesGiven.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/AuthoritiesGiven","GET",pk,"post",null);
};
Lino.users.AuthoritiesGiven.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.AuthoritiesGiven.GridPanel(p);
});

// js_render_GridPanel_class users.AuthoritiesTaken
Lino.users.AuthoritiesTaken.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "No data to display." },
  ls_url : "/users/AuthoritiesTaken",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/users/AuthoritiesTaken','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/AuthoritiesTaken','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/AuthoritiesTaken','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Authorities taken",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 4,
  ls_store_fields : [ { "name": "user" }, 'userHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 13,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var user85 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/AuthoritiesTaken/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Author", "editable": true, "tooltip": "(users.AuthoritiesTaken.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user85, "dataIndex": "user" } ];
    Lino.users.AuthoritiesTaken.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.AuthoritiesTaken.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/AuthoritiesTaken","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.users.AuthoritiesTaken.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/AuthoritiesTaken","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.users.AuthoritiesTaken.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/AuthoritiesTaken","GET",pk,"put",null);
};
Lino.users.AuthoritiesTaken.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/AuthoritiesTaken","GET",pk,"post",null);
};
Lino.users.AuthoritiesTaken.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.AuthoritiesTaken.GridPanel(p);
});

// js_render_GridPanel_class countries.CitiesByCity
Lino.countries.CitiesByCity.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/countries/CitiesByCity",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/countries/CitiesByCity','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/countries/CitiesByCity','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/countries/CitiesByCity','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Subdivisions",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 10,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "type" }, 'typeHidden', { "name": "zip_code" }, { "type": "int", "name": "id" }, { "name": "country" }, 'countryHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 16,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.CitiesByCity.detail;
    this.ls_insert_handler = Lino.countries.CitiesByCity.insert;
    var ww = this.containing_window;
    var name186 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de187 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr188 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type189 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/CitiesByCity/type", "method": "GET" }) }) });
    var zip_code190 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "maxLength": 8 });
    var id191 = new Ext.form.NumberField({ "selectOnFocus": true });
    var country192 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/CitiesByCity/country", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Country..." });
    this.before_row_edit = function(record) {
      type189.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country192.on('change',Lino.chooser_handler(type189,'country'));
      Lino.countries.CitiesByCity.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(countries.CitiesByCity.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name186 }, { "colIndex": 1, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(countries.CitiesByCity.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de187 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(countries.CitiesByCity.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr188 }, { "colIndex": 3, "sortable": true, "header": "Place Type", "editable": true, "tooltip": "(countries.CitiesByCity.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "type", "editor": type189 }, { "colIndex": 4, "sortable": true, "header": "zip code", "editable": true, "tooltip": "(countries.CitiesByCity.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "zip_code", "editor": zip_code190 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(countries.CitiesByCity.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id191, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Country", "editable": true, "tooltip": "(countries.CitiesByCity.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country192, "dataIndex": "country" } ];
    Lino.countries.CitiesByCity.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.CitiesByCity.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/CitiesByCity","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.countries.CitiesByCity.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/CitiesByCity","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.countries.CitiesByCity.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/CitiesByCity","GET",pk,"put",null);
};
Lino.countries.CitiesByCity.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/CitiesByCity","GET",pk,"post",null);
};

Lino.countries.CitiesByCity.insertPanel = Ext.extend(Lino.countries.Cities.DetailFormPanel,{
  empty_title: "New Subdivisions",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/countries/CitiesByCity",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.CitiesByCity.detail;
    this.ls_insert_handler = Lino.countries.CitiesByCity.insert;
    Lino.countries.CitiesByCity.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.CitiesByCity.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.CitiesByCity.insertPanel(p);
});
Lino.countries.CitiesByCity.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/CitiesByCity","GET",pk,"poststay",null);
};

Lino.countries.CitiesByCity.detailPanel = Ext.extend(Lino.countries.Cities.DetailFormPanel,{
  empty_title: "Detail Subdivisions",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/countries/CitiesByCity",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.CitiesByCity.detail;
    this.ls_insert_handler = Lino.countries.CitiesByCity.insert;
    Lino.countries.CitiesByCity.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.CitiesByCity.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.CitiesByCity.detailPanel(p);
});
Lino.countries.CitiesByCity.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.CitiesByCity.GridPanel(p);
});

// js_render_GridPanel_class countries.CitiesByCountry
Lino.countries.CitiesByCountry.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/countries/CitiesByCountry",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/countries/CitiesByCountry','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/countries/CitiesByCountry','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/countries/CitiesByCountry','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Places",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 10,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "type" }, 'typeHidden', { "name": "zip_code" }, { "type": "int", "name": "id" }, { "name": "parent" }, 'parentHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 16,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.CitiesByCountry.detail;
    this.ls_insert_handler = Lino.countries.CitiesByCountry.insert;
    var ww = this.containing_window;
    var name160 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de161 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr162 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type163 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/CitiesByCountry/type", "method": "GET" }) }) });
    var zip_code164 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "maxLength": 8 });
    var id165 = new Ext.form.NumberField({ "selectOnFocus": true });
    var parent166 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/CitiesByCountry/parent", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    this.before_row_edit = function(record) {
      var bp = this.get_base_params();
      type163.setContextValue('mk',bp['mk']);
      type163.setContextValue('mt',bp['mt']);
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(countries.CitiesByCountry.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name160 }, { "colIndex": 1, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(countries.CitiesByCountry.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de161 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(countries.CitiesByCountry.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr162 }, { "colIndex": 3, "sortable": true, "header": "Place Type", "editable": true, "tooltip": "(countries.CitiesByCountry.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "type", "editor": type163 }, { "colIndex": 4, "sortable": true, "header": "zip code", "editable": true, "tooltip": "(countries.CitiesByCountry.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "zip_code", "editor": zip_code164 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(countries.CitiesByCountry.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id165, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Part of", "editable": true, "tooltip": "(countries.CitiesByCountry.parent) The superordinate geographic place of which this place is a part.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('parentHidden','Lino.countries.Cities.detail'), "editor": parent166, "dataIndex": "parent" } ];
    Lino.countries.CitiesByCountry.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.CitiesByCountry.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/CitiesByCountry","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.countries.CitiesByCountry.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/CitiesByCountry","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.countries.CitiesByCountry.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/CitiesByCountry","GET",pk,"put",null);
};
Lino.countries.CitiesByCountry.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/CitiesByCountry","GET",pk,"post",null);
};

Lino.countries.CitiesByCountry.insertPanel = Ext.extend(Lino.countries.Cities.DetailFormPanel,{
  empty_title: "New Places",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/countries/CitiesByCountry",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.CitiesByCountry.detail;
    this.ls_insert_handler = Lino.countries.CitiesByCountry.insert;
    Lino.countries.CitiesByCountry.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.CitiesByCountry.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.CitiesByCountry.insertPanel(p);
});
Lino.countries.CitiesByCountry.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/CitiesByCountry","GET",pk,"poststay",null);
};

Lino.countries.CitiesByCountry.detailPanel = Ext.extend(Lino.countries.Cities.DetailFormPanel,{
  empty_title: "Detail Places",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/countries/CitiesByCountry",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.CitiesByCountry.detail;
    this.ls_insert_handler = Lino.countries.CitiesByCountry.insert;
    Lino.countries.CitiesByCountry.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.CitiesByCountry.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.CitiesByCountry.detailPanel(p);
});
Lino.countries.CitiesByCountry.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.CitiesByCountry.GridPanel(p);
});

// js_render_GridPanel_class contacts.PartnersByCity
Lino.contacts.PartnersByCity.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/PartnersByCity",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/contacts/PartnersByCity','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/PartnersByCity','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/PartnersByCity','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true }, { "itemId": "print_labels", "menu_item_text": "Labels", "must_save": true, "tooltip": "Generate mailing labels for these recipients", "panel_btn_handler": Lino.list_action_handler('/contacts/PartnersByCity','print_labels','GET',Lino.get_current_grid_config), "text": "Labels", "overflowText": "Labels", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Partners",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 30,
  ls_store_fields : [ { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "name" }, { "name": "language" }, 'languageHidden', { "type": "int", "name": "id" }, { "name": "country" }, 'countryHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "email" }, { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "name": "invoicing_address" }, 'invoicing_addressHidden', { "name": "payment_term" }, 'payment_termHidden', { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "imode" }, 'imodeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 21,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.PartnersByCity.detail;
    this.ls_insert_handler = Lino.contacts.PartnersByCity.insert;
    var ww = this.containing_window;
    var street213 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no214 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box215 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr2216 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name217 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var language218 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ] });
    var id219 = new Ext.form.NumberField({ "selectOnFocus": true });
    var country220 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/PartnersByCity/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Country..." });
    var region221 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/PartnersByCity/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var zip_code222 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr1223 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix224 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var email225 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var url226 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone227 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm228 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax229 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks230 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var invoicing_address231 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/PartnersByCity/invoicing_address", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var payment_term232 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/PartnersByCity/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Payment Term..." });
    var vat_regime233 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var imode234 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/PartnersByCity/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Invoicing Mode..." });
    this.before_row_edit = function(record) {
      region221.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country220.on('change',Lino.chooser_handler(region221,'country'));
      Lino.contacts.PartnersByCity.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Street", "editable": true, "tooltip": "(contacts.PartnersByCity.street) Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street213 }, { "colIndex": 1, "sortable": true, "header": "No.", "editable": true, "tooltip": "(contacts.PartnersByCity.street_no) House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no214 }, { "colIndex": 2, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.PartnersByCity.street_box) Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box215 }, { "colIndex": 3, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "(contacts.PartnersByCity.addr2) Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr2216 }, { "colIndex": 4, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.PartnersByCity.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name217 }, { "colIndex": 5, "sortable": true, "header": "Language", "editable": true, "tooltip": "(contacts.PartnersByCity.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language218 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.PartnersByCity.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id219, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 7, "sortable": true, "header": "Country", "editable": true, "tooltip": "(contacts.PartnersByCity.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country220, "dataIndex": "country" }, { "colIndex": 8, "sortable": true, "header": "Region", "editable": true, "tooltip": "(contacts.PartnersByCity.region) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail'), "editor": region221, "dataIndex": "region" }, { "colIndex": 9, "sortable": true, "header": "Zip code", "editable": true, "tooltip": "(contacts.PartnersByCity.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code222 }, { "colIndex": 10, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "(contacts.PartnersByCity.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr1223 }, { "colIndex": 11, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "(contacts.PartnersByCity.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix224 }, { "colIndex": 12, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.PartnersByCity.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email225 }, { "colIndex": 13, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.PartnersByCity.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url226 }, { "colIndex": 14, "sortable": true, "header": "Phone", "editable": true, "tooltip": "(contacts.PartnersByCity.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone227 }, { "colIndex": 15, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.PartnersByCity.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm228 }, { "colIndex": 16, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.PartnersByCity.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax229 }, { "colIndex": 17, "sortable": false, "header": "Remarks", "editable": true, "tooltip": "(contacts.PartnersByCity.remarks) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks230, "dataIndex": "remarks" }, { "colIndex": 18, "sortable": true, "header": "Invoicing address", "editable": true, "tooltip": "(contacts.PartnersByCity.invoicing_address) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('invoicing_addressHidden','Lino.contacts.Partners.detail'), "editor": invoicing_address231, "dataIndex": "invoicing_address" }, { "colIndex": 19, "sortable": true, "header": "Payment Term", "editable": true, "tooltip": "(contacts.PartnersByCity.payment_term) The default payment term for sales invoices to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "payment_term", "editor": payment_term232 }, { "colIndex": 20, "sortable": true, "header": "VAT Regime", "editable": true, "tooltip": "(contacts.PartnersByCity.vat_regime) The default VAT regime for sales to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "vat_regime", "editor": vat_regime233 }, { "colIndex": 21, "sortable": true, "header": "Invoicing Mode", "editable": true, "tooltip": "(contacts.PartnersByCity.imode) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "imode", "editor": imode234 } ];
    Lino.contacts.PartnersByCity.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.PartnersByCity.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/PartnersByCity","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.contacts.PartnersByCity.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/PartnersByCity","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.contacts.PartnersByCity.print_labels = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/PartnersByCity","GET",pk,"print_labels",Lino.get_current_grid_config);
};
Lino.contacts.PartnersByCity.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/PartnersByCity","GET",pk,"put",null);
};
Lino.contacts.PartnersByCity.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/PartnersByCity","GET",pk,"post",null);
};

Lino.contacts.PartnersByCity.insertPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "New Partners",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/contacts/PartnersByCity",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.PartnersByCity.detail;
    this.ls_insert_handler = Lino.contacts.PartnersByCity.insert;
    Lino.contacts.PartnersByCity.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.PartnersByCity.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.PartnersByCity.insertPanel(p);
});
Lino.contacts.PartnersByCity.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/PartnersByCity","GET",pk,"poststay",null);
};

Lino.contacts.PartnersByCity.detailPanel = Ext.extend(Lino.contacts.Partners.DetailFormPanel,{
  empty_title: "Detail Partners",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/contacts/PartnersByCity",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.PartnersByCity.detail;
    this.ls_insert_handler = Lino.contacts.PartnersByCity.insert;
    Lino.contacts.PartnersByCity.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.PartnersByCity.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.PartnersByCity.detailPanel(p);
});
Lino.contacts.PartnersByCity.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.PartnersByCity.GridPanel(p);
});

// js_render_GridPanel_class contacts.PartnersByCountry
Lino.contacts.PartnersByCountry.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/PartnersByCountry",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/contacts/PartnersByCountry','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/PartnersByCountry','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/PartnersByCountry','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true }, { "itemId": "print_labels", "menu_item_text": "Labels", "must_save": true, "tooltip": "Generate mailing labels for these recipients", "panel_btn_handler": Lino.list_action_handler('/contacts/PartnersByCountry','print_labels','GET',Lino.get_current_grid_config), "text": "Labels", "overflowText": "Labels", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Partners",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 30,
  ls_store_fields : [ { "name": "city" }, 'cityHidden', { "name": "street" }, { "name": "street_no" }, { "name": "name" }, { "name": "language" }, 'languageHidden', { "type": "int", "name": "id" }, { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "email" }, { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "name": "invoicing_address" }, 'invoicing_addressHidden', { "name": "payment_term" }, 'payment_termHidden', { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "imode" }, 'imodeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 21,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.PartnersByCountry.detail;
    this.ls_insert_handler = Lino.contacts.PartnersByCountry.insert;
    var ww = this.containing_window;
    var city1388 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/PartnersByCountry/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var street1389 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no1390 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var name1391 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var language1392 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ] });
    var id1393 = new Ext.form.NumberField({ "selectOnFocus": true });
    var region1394 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/PartnersByCountry/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var zip_code1395 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr11396 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix1397 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_box1398 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr21399 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var email1400 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var url1401 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone1402 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm1403 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax1404 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks1405 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var invoicing_address1406 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/PartnersByCountry/invoicing_address", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var payment_term1407 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/PartnersByCountry/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Payment Term..." });
    var vat_regime1408 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var imode1409 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/PartnersByCountry/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Invoicing Mode..." });
    this.before_row_edit = function(record) {
      var bp = this.get_base_params();
      city1388.setContextValue('mk',bp['mk']);
      city1388.setContextValue('mt',bp['mt']);
      city1388.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      var bp = this.get_base_params();
      region1394.setContextValue('mk',bp['mk']);
      region1394.setContextValue('mt',bp['mt']);
    };
    this.onRender = function(ct, position) {
      region1394.on('change',Lino.chooser_handler(city1388,'region'));
      Lino.contacts.PartnersByCountry.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Place", "editable": true, "tooltip": "(contacts.PartnersByCountry.city) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail'), "editor": city1388, "dataIndex": "city" }, { "colIndex": 1, "sortable": true, "header": "Street", "editable": true, "tooltip": "(contacts.PartnersByCountry.street) Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street1389 }, { "colIndex": 2, "sortable": true, "header": "No.", "editable": true, "tooltip": "(contacts.PartnersByCountry.street_no) House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no1390 }, { "colIndex": 3, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.PartnersByCountry.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1391 }, { "colIndex": 4, "sortable": true, "header": "Language", "editable": true, "tooltip": "(contacts.PartnersByCountry.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language1392 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.PartnersByCountry.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1393, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Region", "editable": true, "tooltip": "(contacts.PartnersByCountry.region) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail'), "editor": region1394, "dataIndex": "region" }, { "colIndex": 7, "sortable": true, "header": "Zip code", "editable": true, "tooltip": "(contacts.PartnersByCountry.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code1395 }, { "colIndex": 8, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "(contacts.PartnersByCountry.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr11396 }, { "colIndex": 9, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "(contacts.PartnersByCountry.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix1397 }, { "colIndex": 10, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.PartnersByCountry.street_box) Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box1398 }, { "colIndex": 11, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "(contacts.PartnersByCountry.addr2) Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr21399 }, { "colIndex": 12, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.PartnersByCountry.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email1400 }, { "colIndex": 13, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.PartnersByCountry.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url1401 }, { "colIndex": 14, "sortable": true, "header": "Phone", "editable": true, "tooltip": "(contacts.PartnersByCountry.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone1402 }, { "colIndex": 15, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.PartnersByCountry.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm1403 }, { "colIndex": 16, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.PartnersByCountry.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax1404 }, { "colIndex": 17, "sortable": false, "header": "Remarks", "editable": true, "tooltip": "(contacts.PartnersByCountry.remarks) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks1405, "dataIndex": "remarks" }, { "colIndex": 18, "sortable": true, "header": "Invoicing address", "editable": true, "tooltip": "(contacts.PartnersByCountry.invoicing_address) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('invoicing_addressHidden','Lino.contacts.Partners.detail'), "editor": invoicing_address1406, "dataIndex": "invoicing_address" }, { "colIndex": 19, "sortable": true, "header": "Payment Term", "editable": true, "tooltip": "(contacts.PartnersByCountry.payment_term) The default payment term for sales invoices to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "payment_term", "editor": payment_term1407 }, { "colIndex": 20, "sortable": true, "header": "VAT Regime", "editable": true, "tooltip": "(contacts.PartnersByCountry.vat_regime) The default VAT regime for sales to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "vat_regime", "editor": vat_regime1408 }, { "colIndex": 21, "sortable": true, "header": "Invoicing Mode", "editable": true, "tooltip": "(contacts.PartnersByCountry.imode) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "imode", "editor": imode1409 } ];
    Lino.contacts.PartnersByCountry.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.PartnersByCountry.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/PartnersByCountry","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.contacts.PartnersByCountry.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/PartnersByCountry","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.contacts.PartnersByCountry.print_labels = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/PartnersByCountry","GET",pk,"print_labels",Lino.get_current_grid_config);
};
Lino.contacts.PartnersByCountry.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/PartnersByCountry","GET",pk,"put",null);
};
Lino.contacts.PartnersByCountry.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/PartnersByCountry","GET",pk,"post",null);
};

Lino.contacts.PartnersByCountry.insertPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "New Partners",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/contacts/PartnersByCountry",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.PartnersByCountry.detail;
    this.ls_insert_handler = Lino.contacts.PartnersByCountry.insert;
    Lino.contacts.PartnersByCountry.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.PartnersByCountry.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.PartnersByCountry.insertPanel(p);
});
Lino.contacts.PartnersByCountry.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/PartnersByCountry","GET",pk,"poststay",null);
};

Lino.contacts.PartnersByCountry.detailPanel = Ext.extend(Lino.contacts.Partners.DetailFormPanel,{
  empty_title: "Detail Partners",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/contacts/PartnersByCountry",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.PartnersByCountry.detail;
    this.ls_insert_handler = Lino.contacts.PartnersByCountry.insert;
    Lino.contacts.PartnersByCountry.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.PartnersByCountry.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.PartnersByCountry.detailPanel(p);
});
Lino.contacts.PartnersByCountry.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.PartnersByCountry.GridPanel(p);
});

// js_render_GridPanel_class contacts.RolesByCompany
Lino.contacts.RolesByCompany.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "No data to display." },
  ls_url : "/contacts/RolesByCompany",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/contacts/RolesByCompany','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/RolesByCompany','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/RolesByCompany','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Contact persons",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "name": "person" }, 'personHidden', { "name": "type" }, 'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 20,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var person564 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/RolesByCompany/person", "method": "GET" }) }), "emptyText": "Select a Person..." });
    var type565 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/RolesByCompany/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Function..." });
    var id566 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Person", "editable": true, "tooltip": "(contacts.RolesByCompany.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('personHidden','Lino.contacts.Persons.detail'), "editor": person564, "dataIndex": "person" }, { "colIndex": 1, "sortable": true, "header": "Contact Role", "editable": true, "tooltip": "(contacts.RolesByCompany.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type565 }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.RolesByCompany.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "hidden": true, "editor": id566, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.RolesByCompany.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.RolesByCompany.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RolesByCompany","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.contacts.RolesByCompany.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RolesByCompany","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.contacts.RolesByCompany.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RolesByCompany","GET",pk,"put",null);
};
Lino.contacts.RolesByCompany.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RolesByCompany","GET",pk,"post",null);
};
Lino.contacts.RolesByCompany.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.RolesByCompany.GridPanel(p);
});

// js_render_GridPanel_class contacts.RolesByPerson
Lino.contacts.RolesByPerson.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "No data to display." },
  ls_url : "/contacts/RolesByPerson",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/contacts/RolesByPerson','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/RolesByPerson','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/RolesByPerson','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Contact for",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "name": "company" }, 'companyHidden', { "name": "type" }, 'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 20,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var company479 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/RolesByPerson/company", "method": "GET" }) }), "emptyText": "Select a Company..." });
    var type480 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/RolesByPerson/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Function..." });
    var id481 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Company", "editable": true, "tooltip": "(contacts.RolesByPerson.company) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('companyHidden','Lino.contacts.Companies.detail'), "editor": company479, "dataIndex": "company" }, { "colIndex": 1, "sortable": true, "header": "Contact Role", "editable": true, "tooltip": "(contacts.RolesByPerson.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type480 }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.RolesByPerson.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "hidden": true, "editor": id481, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.RolesByPerson.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.RolesByPerson.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RolesByPerson","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.contacts.RolesByPerson.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RolesByPerson","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.contacts.RolesByPerson.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RolesByPerson","GET",pk,"put",null);
};
Lino.contacts.RolesByPerson.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RolesByPerson","GET",pk,"post",null);
};
Lino.contacts.RolesByPerson.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.RolesByPerson.GridPanel(p);
});

// js_render_GridPanel_class accounts.GroupsByChart
Lino.accounts.GroupsByChart.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/accounts/GroupsByChart",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/accounts/GroupsByChart','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/accounts/GroupsByChart','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/accounts/GroupsByChart','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Account Groups",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 8,
  ls_store_fields : [ { "name": "ref" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "account_type" }, 'account_typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 26,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.GroupsByChart.detail;
    this.ls_insert_handler = Lino.accounts.GroupsByChart.insert;
    var ww = this.containing_window;
    var ref607 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var name608 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de609 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr610 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var account_type611 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.accounts.AccountTypes) });
    var id612 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ref", "editable": true, "tooltip": "(accounts.GroupsByChart.ref) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ref", "editor": ref607 }, { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(accounts.GroupsByChart.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name608 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(accounts.GroupsByChart.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de609 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(accounts.GroupsByChart.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr610 }, { "colIndex": 4, "sortable": true, "header": "Account Type", "editable": true, "tooltip": "(accounts.GroupsByChart.account_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(17), "dataIndex": "account_type", "editor": account_type611 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(accounts.GroupsByChart.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id612, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.accounts.GroupsByChart.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.GroupsByChart.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/GroupsByChart","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.accounts.GroupsByChart.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/GroupsByChart","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.accounts.GroupsByChart.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/GroupsByChart","GET",pk,"put",null);
};
Lino.accounts.GroupsByChart.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/GroupsByChart","GET",pk,"post",null);
};

Lino.accounts.GroupsByChart.insertPanel = Ext.extend(Lino.accounts.Groups.DetailFormPanel,{
  empty_title: "New Account Groups",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/accounts/GroupsByChart",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.GroupsByChart.detail;
    this.ls_insert_handler = Lino.accounts.GroupsByChart.insert;
    Lino.accounts.GroupsByChart.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.GroupsByChart.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.accounts.GroupsByChart.insertPanel(p);
});
Lino.accounts.GroupsByChart.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/GroupsByChart","GET",pk,"poststay",null);
};

Lino.accounts.GroupsByChart.detailPanel = Ext.extend(Lino.accounts.Groups.DetailFormPanel,{
  empty_title: "Detail Account Groups",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/accounts/GroupsByChart",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.GroupsByChart.detail;
    this.ls_insert_handler = Lino.accounts.GroupsByChart.insert;
    Lino.accounts.GroupsByChart.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.GroupsByChart.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.GroupsByChart.detailPanel(p);
});
Lino.accounts.GroupsByChart.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.GroupsByChart.GridPanel(p);
});

// js_render_GridPanel_class accounts.AccountsByGroup
Lino.accounts.AccountsByGroup.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/accounts/AccountsByGroup",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/accounts/AccountsByGroup','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/accounts/AccountsByGroup','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/accounts/AccountsByGroup','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-arrow_up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-arrow_down", "overflowText": "Down", "auto_save": true } ],
  cell_edit : true,
  title : "Accounts",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 14,
  ls_store_fields : [ { "name": "ref" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "type": "int", "name": "id" }, { "type": "int", "name": "seqno" }, { "name": "chart" }, 'chartHidden', { "name": "type" }, 'typeHidden', { "type": "boolean", "name": "sales_allowed" }, { "type": "boolean", "name": "purchases_allowed" }, { "type": "boolean", "name": "wages_allowed" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 25,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var ref629 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var name630 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de631 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr632 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id633 = new Ext.form.NumberField({ "selectOnFocus": true });
    var seqno634 = new Ext.form.NumberField({ "selectOnFocus": true });
    var chart635 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/AccountsByGroup/chart", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account Chart..." });
    var type636 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.accounts.AccountTypes });
    var sales_allowed637 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var purchases_allowed638 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var wages_allowed639 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ref", "editable": true, "tooltip": "(accounts.AccountsByGroup.ref) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ref", "editor": ref629 }, { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(accounts.AccountsByGroup.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name630 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(accounts.AccountsByGroup.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de631 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(accounts.AccountsByGroup.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr632 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(accounts.AccountsByGroup.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id633, "width": Lino.chars2width(6), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(accounts.AccountsByGroup.seqno) ", "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "width": Lino.chars2width(6), "editor": seqno634 }), { "colIndex": 6, "sortable": true, "header": "Account Chart", "editable": true, "tooltip": "(accounts.AccountsByGroup.chart) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('chartHidden','Lino.accounts.Charts.detail'), "editor": chart635, "dataIndex": "chart" }, { "colIndex": 7, "sortable": true, "header": "Account Type", "editable": true, "tooltip": "(accounts.AccountsByGroup.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(17), "dataIndex": "type", "editor": type636 }, { "colIndex": 8, "sortable": false, "xtype": "checkcolumn", "header": "Sales", "editable": true, "tooltip": "(accounts.AccountsByGroup.sales_allowed) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "sales_allowed" }, { "colIndex": 9, "sortable": false, "xtype": "checkcolumn", "header": "Purchases", "editable": true, "tooltip": "(accounts.AccountsByGroup.purchases_allowed) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "purchases_allowed" }, { "colIndex": 10, "sortable": false, "xtype": "checkcolumn", "header": "Wages", "editable": true, "tooltip": "(accounts.AccountsByGroup.wages_allowed) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "wages_allowed" } ];
    Lino.accounts.AccountsByGroup.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.AccountsByGroup.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/AccountsByGroup","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.accounts.AccountsByGroup.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/AccountsByGroup","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.accounts.AccountsByGroup.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/AccountsByGroup","GET",pk,"put",null);
};
Lino.accounts.AccountsByGroup.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/AccountsByGroup","GET",pk,"post",null);
};
Lino.accounts.AccountsByGroup.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/AccountsByGroup","GET",pk,"duplicate",null);
};
Lino.accounts.AccountsByGroup.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.AccountsByGroup.GridPanel(p);
});
Lino.accounts.AccountsByGroup.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/AccountsByGroup","GET",pk,"move_up",null);
};
Lino.accounts.AccountsByGroup.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/AccountsByGroup","GET",pk,"move_down",null);
};

// js_render_GridPanel_class products.ProductsByCategory
Lino.products.ProductsByCategory.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/products/ProductsByCategory",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/products/ProductsByCategory','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/products/ProductsByCategory','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/products/ProductsByCategory','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Products",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 14,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "cat" }, 'catHidden', { "name": "vat_class" }, 'vat_classHidden', { "name": "sales_price" }, { "name": "sales_account" }, 'sales_accountHidden', { "name": "purchases_account" }, 'purchases_accountHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 24,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.products.ProductsByCategory.detail;
    this.ls_insert_handler = Lino.products.ProductsByCategory.insert;
    var ww = this.containing_window;
    var id655 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name656 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de657 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr658 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var cat659 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/products/ProductsByCategory/cat", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Product Category..." });
    var vat_class660 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.vat.VatClasses) });
    var sales_price661 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var sales_account662 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/products/ProductsByCategory/sales_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var purchases_account663 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/products/ProductsByCategory/purchases_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(products.ProductsByCategory.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id655, "width": Lino.chars2width(4), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(products.ProductsByCategory.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name656 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(products.ProductsByCategory.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de657 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(products.ProductsByCategory.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr658 }, { "colIndex": 4, "sortable": true, "header": "Category", "editable": true, "tooltip": "(products.ProductsByCategory.cat) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('catHidden','Lino.products.ProductCats.detail'), "editor": cat659, "dataIndex": "cat" }, { "colIndex": 5, "sortable": true, "header": "VAT Class", "editable": true, "tooltip": "(products.ProductsByCategory.vat_class) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "vat_class", "editor": vat_class660 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "header": "Sales price", "editable": true, "tooltip": "(products.ProductsByCategory.sales_price) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(7), "dataIndex": "sales_price", "editor": sales_price661 }), { "colIndex": 7, "sortable": true, "header": "Sales Base account", "editable": true, "tooltip": "(products.ProductsByCategory.sales_account) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "sales_account", "editor": sales_account662 }, { "colIndex": 8, "sortable": true, "header": "Purchases Base account", "editable": true, "tooltip": "(products.ProductsByCategory.purchases_account) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "purchases_account", "editor": purchases_account663 } ];
    Lino.products.ProductsByCategory.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.products.ProductsByCategory.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/ProductsByCategory","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.products.ProductsByCategory.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/ProductsByCategory","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.products.ProductsByCategory.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/ProductsByCategory","GET",pk,"put",null);
};
Lino.products.ProductsByCategory.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/ProductsByCategory","GET",pk,"post",null);
};

Lino.products.ProductsByCategory.insertPanel = Ext.extend(Lino.products.Products.DetailFormPanel,{
  empty_title: "New Products",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/products/ProductsByCategory",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.products.ProductsByCategory.detail;
    this.ls_insert_handler = Lino.products.ProductsByCategory.insert;
    Lino.products.ProductsByCategory.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.products.ProductsByCategory.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.products.ProductsByCategory.insertPanel(p);
});
Lino.products.ProductsByCategory.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/ProductsByCategory","GET",pk,"poststay",null);
};

Lino.products.ProductsByCategory.detailPanel = Ext.extend(Lino.products.Products.DetailFormPanel,{
  empty_title: "Detail Products",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/products/ProductsByCategory",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.products.ProductsByCategory.detail;
    this.ls_insert_handler = Lino.products.ProductsByCategory.insert;
    Lino.products.ProductsByCategory.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.products.ProductsByCategory.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.products.ProductsByCategory.detailPanel(p);
});
Lino.products.ProductsByCategory.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.products.ProductsByCategory.GridPanel(p);
});

// js_render_GridPanel_class ledger.MovementsByVoucher
Lino.ledger.MovementsByVoucher.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "forceFit": true, "emptyText": "No data to display." },
  ls_url : "/ledger/MovementsByVoucher",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/ledger/MovementsByVoucher','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/MovementsByVoucher','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/MovementsByVoucher','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-arrow_up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-arrow_down", "overflowText": "Down", "auto_save": true } ],
  cell_edit : true,
  title : "Movements",
  page_length : 20,
  stripeRows : true,
  disable_editing : true,
  disabled_actions_index : 9,
  ls_store_fields : [ { "type": "int", "name": "seqno" }, { "name": "account" }, 'accountHidden', { "name": "debit" }, { "name": "credit" }, { "name": "match" }, { "type": "boolean", "name": "satisfied" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 32,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var seqno392 = new Ext.form.NumberField({ "selectOnFocus": true });
    var account393 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/MovementsByVoucher/account", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account..." });
    var debit394 = new Ext.form.NumberField({ "disabled": true, "decimalPrecision": 2, "decimalSeparator": "," });
    var credit395 = new Ext.form.NumberField({ "disabled": true, "decimalPrecision": 2, "decimalSeparator": "," });
    var match396 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/MovementsByVoucher/match", "method": "GET" }) }) });
    var satisfied397 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
      match396.setContextValue('partner',record ? record.data['partnerHidden'] : undefined);
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(ledger.MovementsByVoucher.seqno) ", "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "width": Lino.chars2width(6), "editor": seqno392 }), { "colIndex": 1, "sortable": true, "header": "Account", "editable": true, "tooltip": "(ledger.MovementsByVoucher.account) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "account", "editor": account393 }, new Lino.NullNumberColumn({ "width": Lino.chars2width(13), "colIndex": 2, "sortable": false, "dataIndex": "debit", "header": "Debit", "editable": false, "tooltip": "(ledger.MovementsByVoucher.debit) " }), new Lino.NullNumberColumn({ "width": Lino.chars2width(13), "colIndex": 3, "sortable": false, "dataIndex": "credit", "header": "Credit", "editable": false, "tooltip": "(ledger.MovementsByVoucher.credit) " }), { "colIndex": 4, "sortable": true, "header": "Match", "editable": true, "tooltip": "(ledger.MovementsByVoucher.match) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "match", "editor": match396 }, { "colIndex": 5, "sortable": false, "xtype": "checkcolumn", "header": "Satisfied", "editable": true, "tooltip": "(ledger.MovementsByVoucher.satisfied) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "satisfied" } ];
    Lino.ledger.MovementsByVoucher.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.MovementsByVoucher.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/MovementsByVoucher","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.ledger.MovementsByVoucher.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/MovementsByVoucher","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.ledger.MovementsByVoucher.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/MovementsByVoucher","GET",pk,"duplicate",null);
};
Lino.ledger.MovementsByVoucher.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.MovementsByVoucher.GridPanel(p);
});
Lino.ledger.MovementsByVoucher.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/MovementsByVoucher","GET",pk,"move_up",null);
};
Lino.ledger.MovementsByVoucher.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/MovementsByVoucher","GET",pk,"move_down",null);
};

// js_render_GridPanel_class ledger.MovementsByPartner
Lino.ledger.MovementsByPartner.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "forceFit": true, "emptyText": "No data to display." },
  ls_url : "/ledger/MovementsByPartner",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/ledger/MovementsByPartner','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/MovementsByPartner','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/MovementsByPartner','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-arrow_up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-arrow_down", "overflowText": "Down", "auto_save": true } ],
  cell_edit : true,
  title : "Movements",
  page_length : 20,
  stripeRows : true,
  disable_editing : true,
  disabled_actions_index : 10,
  ls_store_fields : [ { "type": "date", "name": "voucher__date", "dateFormat": "d.m.Y" }, { "name": "voucher_link" }, { "name": "debit" }, { "name": "credit" }, { "name": "account" }, 'accountHidden', { "name": "match" }, { "type": "boolean", "name": "satisfied" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  pk_index : 8,
  ls_grid_configs : [  ],
  content_type : 32,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var voucher__date1411 = new Lino.DateField({ "disabled": true });
    var voucher_link_disp1412 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var debit1413 = new Ext.form.NumberField({ "disabled": true, "decimalPrecision": 2, "decimalSeparator": "," });
    var credit1414 = new Ext.form.NumberField({ "disabled": true, "decimalPrecision": 2, "decimalSeparator": "," });
    var account1415 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/MovementsByPartner/account", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account..." });
    var match1416 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/MovementsByPartner/match", "method": "GET" }) }) });
    var satisfied1417 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
      var bp = this.get_base_params();
      match1416.setContextValue('mk',bp['mk']);
      match1416.setContextValue('mt',bp['mt']);
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": false, "tooltip": "(ledger.MovementsByPartner.voucher__date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "voucher__date", "width": Lino.chars2width(9) }, { "width": Lino.chars2width(31), "colIndex": 1, "sortable": false, "dataIndex": "voucher_link", "header": "Voucher", "editable": false, "tooltip": "(ledger.MovementsByPartner.voucher_link) " }, new Lino.NullNumberColumn({ "width": Lino.chars2width(13), "colIndex": 2, "sortable": false, "dataIndex": "debit", "header": "Debit", "editable": false, "tooltip": "(ledger.MovementsByPartner.debit) " }), new Lino.NullNumberColumn({ "width": Lino.chars2width(13), "colIndex": 3, "sortable": false, "dataIndex": "credit", "header": "Credit", "editable": false, "tooltip": "(ledger.MovementsByPartner.credit) " }), { "colIndex": 4, "sortable": true, "header": "Account", "editable": true, "tooltip": "(ledger.MovementsByPartner.account) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "account", "editor": account1415 }, { "colIndex": 5, "sortable": true, "header": "Match", "editable": true, "tooltip": "(ledger.MovementsByPartner.match) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "match", "editor": match1416 }, { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "Satisfied", "editable": true, "tooltip": "(ledger.MovementsByPartner.satisfied) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "satisfied" } ];
    Lino.ledger.MovementsByPartner.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.MovementsByPartner.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/MovementsByPartner","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.ledger.MovementsByPartner.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/MovementsByPartner","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.ledger.MovementsByPartner.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/MovementsByPartner","GET",pk,"duplicate",null);
};
Lino.ledger.MovementsByPartner.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.MovementsByPartner.GridPanel(p);
});
Lino.ledger.MovementsByPartner.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/MovementsByPartner","GET",pk,"move_up",null);
};
Lino.ledger.MovementsByPartner.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/MovementsByPartner","GET",pk,"move_down",null);
};

// js_render_GridPanel_class ledger.InvoicesByJournal
Lino.ledger.InvoicesByJournal.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/ledger/InvoicesByJournal",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/ledger/InvoicesByJournal','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/InvoicesByJournal','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/InvoicesByJournal','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Invoices",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 24,
  ls_store_fields : [ { "type": "int", "name": "number" }, { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "due_date", "dateFormat": "d.m.Y" }, { "name": "partner" }, 'partnerHidden', { "name": "total_incl" }, { "name": "total_base" }, { "name": "total_vat" }, { "name": "user" }, 'userHidden', { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "year" }, 'yearHidden', { "name": "narration" }, { "name": "declared_in" }, 'declared_inHidden', { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "match" }, { "name": "your_ref" }, { "name": "state" }, 'stateHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 11,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.InvoicesByJournal.detail;
    this.ls_insert_handler = Lino.ledger.InvoicesByJournal.insert;
    var ww = this.containing_window;
    var number1419 = new Ext.form.NumberField({ "selectOnFocus": true });
    var date1420 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var due_date1421 = new Lino.DateField({ "selectOnFocus": true });
    var partner1422 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/InvoicesByJournal/partner", "method": "GET" }) }), "emptyText": "Select a Partner..." });
    var total_incl1423 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_base1424 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat1425 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var user1426 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/InvoicesByJournal/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var workflow_buttons_disp1427 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id1428 = new Ext.form.NumberField({ "selectOnFocus": true });
    var year1429 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var narration1430 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var declared_in1431 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/InvoicesByJournal/declared_in", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a VAT declaration..." });
    var vat_regime1432 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.vat.VatRegimes });
    var match1433 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/InvoicesByJournal/match", "method": "GET" }) }) });
    var your_ref1434 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var state1435 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.ledger.InvoiceStates });
    this.before_row_edit = function(record) {
      match1433.setContextValue('partner',record ? record.data['partnerHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      partner1422.on('change',Lino.chooser_handler(match1433,'partner'));
      Lino.ledger.InvoicesByJournal.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(ledger.InvoicesByJournal.number) ", "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(6), "editor": number1419 }), { "colIndex": 1, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(ledger.InvoicesByJournal.date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "date", "width": Lino.chars2width(9), "editor": date1420 }, { "colIndex": 2, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(ledger.InvoicesByJournal.due_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Due date", "dataIndex": "due_date", "width": Lino.chars2width(9), "editor": due_date1421 }, { "colIndex": 3, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(ledger.InvoicesByJournal.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner1422, "dataIndex": "partner" }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "header": "Total incl. VAT", "editable": true, "tooltip": "(ledger.InvoicesByJournal.total_incl) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_incl", "editor": total_incl1423 }), new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "header": "Total excl. VAT", "editable": true, "tooltip": "(ledger.InvoicesByJournal.total_base) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_base", "editor": total_base1424 }), new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "header": "VAT", "editable": true, "tooltip": "(ledger.InvoicesByJournal.total_vat) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_vat", "editor": total_vat1425 }), { "colIndex": 7, "sortable": true, "header": "Author", "editable": true, "tooltip": "(ledger.InvoicesByJournal.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1426, "dataIndex": "user" }, { "width": Lino.chars2width(31), "colIndex": 8, "sortable": false, "dataIndex": "workflow_buttons", "header": "Workflow", "editable": false, "tooltip": "(ledger.InvoicesByJournal.workflow_buttons) " }, new Lino.NullNumberColumn({ "colIndex": 9, "sortable": true, "format": "0", "editable": true, "tooltip": "(ledger.InvoicesByJournal.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1428, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 10, "sortable": true, "header": "Fiscal Year", "editable": true, "tooltip": "(ledger.InvoicesByJournal.year) ", "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "year", "editor": year1429 }, { "colIndex": 11, "sortable": true, "header": "Narration", "editable": true, "tooltip": "(ledger.InvoicesByJournal.narration) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "narration", "editor": narration1430 }, { "colIndex": 12, "sortable": true, "header": "VAT declaration", "editable": true, "tooltip": "(ledger.InvoicesByJournal.declared_in) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('declared_inHidden','Lino.declarations.Declarations.detail'), "editor": declared_in1431, "dataIndex": "declared_in" }, { "colIndex": 13, "sortable": true, "header": "VAT Regime", "editable": true, "tooltip": "(ledger.InvoicesByJournal.vat_regime) ", "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "vat_regime", "editor": vat_regime1432 }, { "colIndex": 14, "sortable": true, "header": "Match", "editable": true, "tooltip": "(ledger.InvoicesByJournal.match) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "match", "editor": match1433 }, { "colIndex": 15, "sortable": true, "header": "Your reference", "editable": true, "tooltip": "(ledger.InvoicesByJournal.your_ref) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "your_ref", "editor": your_ref1434 }, { "colIndex": 16, "sortable": true, "header": "State", "editable": true, "tooltip": "(ledger.InvoicesByJournal.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(14), "dataIndex": "state", "editor": state1435 } ];
    Lino.ledger.InvoicesByJournal.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.InvoicesByJournal.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/InvoicesByJournal","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.ledger.InvoicesByJournal.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/InvoicesByJournal","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.ledger.InvoicesByJournal.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/InvoicesByJournal","GET",pk,"put",null);
};
Lino.ledger.InvoicesByJournal.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/InvoicesByJournal","GET",pk,"post",null);
};

Lino.ledger.InvoicesByJournal.insertPanel = Ext.extend(Lino.ledger.Invoices.InsertFormPanel,{
  empty_title: "New Invoices",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/ledger/InvoicesByJournal",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.InvoicesByJournal.detail;
    this.ls_insert_handler = Lino.ledger.InvoicesByJournal.insert;
    Lino.ledger.InvoicesByJournal.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.InvoicesByJournal.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.ledger.InvoicesByJournal.insertPanel(p);
});
Lino.ledger.InvoicesByJournal.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/InvoicesByJournal","GET",pk,"poststay",null);
};

Lino.ledger.InvoicesByJournal.detailPanel = Ext.extend(Lino.ledger.Invoices.DetailFormPanel,{
  empty_title: "Detail Invoices",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/ledger/InvoicesByJournal",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.InvoicesByJournal.detail;
    this.ls_insert_handler = Lino.ledger.InvoicesByJournal.insert;
    Lino.ledger.InvoicesByJournal.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.InvoicesByJournal.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.InvoicesByJournal.detailPanel(p);
});
Lino.ledger.InvoicesByJournal.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.ledger.Invoices.ParamsPanel({});
  return new Lino.ledger.InvoicesByJournal.GridPanel(p);
});
Lino.ledger.InvoicesByJournal.deregister_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/InvoicesByJournal","GET",pk,"deregister_action",null);
};
Lino.ledger.InvoicesByJournal.register_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/InvoicesByJournal","GET",pk,"register_action",null);
};

// js_render_GridPanel_class ledger.InvoicesByPartner
Lino.ledger.InvoicesByPartner.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/ledger/InvoicesByPartner",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/ledger/InvoicesByPartner','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/InvoicesByPartner','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/InvoicesByPartner','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Unregistered invoices",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 23,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "total_incl" }, { "name": "total_base" }, { "name": "total_vat" }, { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "journal" }, 'journalHidden', { "name": "year" }, 'yearHidden', { "type": "int", "name": "number" }, { "name": "narration" }, { "name": "declared_in" }, 'declared_inHidden', { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "match" }, { "name": "your_ref" }, { "type": "date", "name": "due_date", "dateFormat": "d.m.Y" }, { "name": "state" }, 'stateHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.InvoicesByPartner.detail;
    this.ls_insert_handler = Lino.ledger.InvoicesByPartner.insert;
    var ww = this.containing_window;
    var date1437 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var total_incl1438 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_base1439 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat1440 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var id1441 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1442 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/InvoicesByPartner/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var journal1443 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/InvoicesByPartner/journal", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Journal..." });
    var year1444 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var number1445 = new Ext.form.NumberField({ "selectOnFocus": true });
    var narration1446 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var declared_in1447 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/InvoicesByPartner/declared_in", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a VAT declaration..." });
    var vat_regime1448 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.vat.VatRegimes });
    var match1449 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/InvoicesByPartner/match", "method": "GET" }) }) });
    var your_ref1450 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var due_date1451 = new Lino.DateField({ "selectOnFocus": true });
    var state1452 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.ledger.InvoiceStates });
    this.before_row_edit = function(record) {
      var bp = this.get_base_params();
      match1449.setContextValue('mk',bp['mk']);
      match1449.setContextValue('mt',bp['mt']);
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(ledger.InvoicesByPartner.date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "date", "width": Lino.chars2width(9), "editor": date1437 }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "header": "Total incl. VAT", "editable": true, "tooltip": "(ledger.InvoicesByPartner.total_incl) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_incl", "editor": total_incl1438 }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "header": "Total excl. VAT", "editable": true, "tooltip": "(ledger.InvoicesByPartner.total_base) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_base", "editor": total_base1439 }), new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "header": "VAT", "editable": true, "tooltip": "(ledger.InvoicesByPartner.total_vat) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_vat", "editor": total_vat1440 }), new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(ledger.InvoicesByPartner.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1441, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Author", "editable": true, "tooltip": "(ledger.InvoicesByPartner.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1442, "dataIndex": "user" }, { "colIndex": 6, "sortable": true, "header": "Journal", "editable": true, "tooltip": "(ledger.InvoicesByPartner.journal) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('journalHidden','Lino.ledger.Journals.detail'), "editor": journal1443, "dataIndex": "journal" }, { "colIndex": 7, "sortable": true, "header": "Fiscal Year", "editable": true, "tooltip": "(ledger.InvoicesByPartner.year) ", "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "year", "editor": year1444 }, new Lino.NullNumberColumn({ "colIndex": 8, "sortable": true, "format": "0", "editable": true, "tooltip": "(ledger.InvoicesByPartner.number) ", "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(6), "editor": number1445 }), { "colIndex": 9, "sortable": true, "header": "Narration", "editable": true, "tooltip": "(ledger.InvoicesByPartner.narration) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "narration", "editor": narration1446 }, { "colIndex": 10, "sortable": true, "header": "VAT declaration", "editable": true, "tooltip": "(ledger.InvoicesByPartner.declared_in) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('declared_inHidden','Lino.declarations.Declarations.detail'), "editor": declared_in1447, "dataIndex": "declared_in" }, { "colIndex": 11, "sortable": true, "header": "VAT Regime", "editable": true, "tooltip": "(ledger.InvoicesByPartner.vat_regime) ", "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "vat_regime", "editor": vat_regime1448 }, { "colIndex": 12, "sortable": true, "header": "Match", "editable": true, "tooltip": "(ledger.InvoicesByPartner.match) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "match", "editor": match1449 }, { "colIndex": 13, "sortable": true, "header": "Your reference", "editable": true, "tooltip": "(ledger.InvoicesByPartner.your_ref) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "your_ref", "editor": your_ref1450 }, { "colIndex": 14, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(ledger.InvoicesByPartner.due_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Due date", "dataIndex": "due_date", "width": Lino.chars2width(9), "editor": due_date1451 }, { "colIndex": 15, "sortable": true, "header": "State", "editable": true, "tooltip": "(ledger.InvoicesByPartner.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(14), "dataIndex": "state", "editor": state1452 } ];
    Lino.ledger.InvoicesByPartner.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.InvoicesByPartner.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/InvoicesByPartner","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.ledger.InvoicesByPartner.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/InvoicesByPartner","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.ledger.InvoicesByPartner.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/InvoicesByPartner","GET",pk,"put",null);
};
Lino.ledger.InvoicesByPartner.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/InvoicesByPartner","GET",pk,"post",null);
};

Lino.ledger.InvoicesByPartner.insertPanel = Ext.extend(Lino.ledger.Invoices.InsertFormPanel,{
  empty_title: "New Unregistered invoices",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/ledger/InvoicesByPartner",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.InvoicesByPartner.detail;
    this.ls_insert_handler = Lino.ledger.InvoicesByPartner.insert;
    Lino.ledger.InvoicesByPartner.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.InvoicesByPartner.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.ledger.InvoicesByPartner.insertPanel(p);
});
Lino.ledger.InvoicesByPartner.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/InvoicesByPartner","GET",pk,"poststay",null);
};

Lino.ledger.InvoicesByPartner.detailPanel = Ext.extend(Lino.ledger.Invoices.DetailFormPanel,{
  empty_title: "Detail Unregistered invoices",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/ledger/InvoicesByPartner",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.InvoicesByPartner.detail;
    this.ls_insert_handler = Lino.ledger.InvoicesByPartner.insert;
    Lino.ledger.InvoicesByPartner.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.InvoicesByPartner.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.InvoicesByPartner.detailPanel(p);
});
Lino.ledger.InvoicesByPartner.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.ledger.Invoices.ParamsPanel({});
  return new Lino.ledger.InvoicesByPartner.GridPanel(p);
});
Lino.ledger.InvoicesByPartner.deregister_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/InvoicesByPartner","GET",pk,"deregister_action",null);
};
Lino.ledger.InvoicesByPartner.register_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/InvoicesByPartner","GET",pk,"register_action",null);
};

// js_render_GridPanel_class ledger.ItemsByInvoice
Lino.ledger.ItemsByInvoice.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/ledger/ItemsByInvoice",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/ledger/ItemsByInvoice','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/ItemsByInvoice','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/ItemsByInvoice','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-arrow_up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-arrow_down", "overflowText": "Down", "auto_save": true } ],
  cell_edit : true,
  title : "Voucher items",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 11,
  ls_store_fields : [ { "name": "account" }, 'accountHidden', { "name": "title" }, { "name": "vat_class" }, 'vat_classHidden', { "name": "total_base" }, { "name": "total_vat" }, { "name": "total_incl" }, { "type": "int", "name": "seqno" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 9,
  ls_grid_configs : [  ],
  content_type : 29,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var account763 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/ItemsByInvoice/account", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account..." });
    var title764 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var vat_class765 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.vat.VatClasses) });
    var total_base766 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat767 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_incl768 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var seqno769 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      var bp = this.get_base_params();
      account763.setContextValue('mk',bp['mk']);
      account763.setContextValue('mt',bp['mt']);
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Account", "editable": true, "tooltip": "(ledger.ItemsByInvoice.account) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "account", "editor": account763 }, { "colIndex": 1, "sortable": true, "header": "Description", "editable": true, "tooltip": "(ledger.ItemsByInvoice.title) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "title", "editor": title764 }, { "colIndex": 2, "sortable": true, "header": "VAT Class", "editable": true, "tooltip": "(ledger.ItemsByInvoice.vat_class) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "vat_class", "editor": vat_class765 }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "header": "Total excl. VAT", "editable": true, "tooltip": "(ledger.ItemsByInvoice.total_base) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_base", "editor": total_base766 }), new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "header": "VAT", "editable": true, "tooltip": "(ledger.ItemsByInvoice.total_vat) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_vat", "editor": total_vat767 }), new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "header": "Total incl. VAT", "editable": true, "tooltip": "(ledger.ItemsByInvoice.total_incl) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_incl", "editor": total_incl768 }), new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(ledger.ItemsByInvoice.seqno) ", "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "width": Lino.chars2width(6), "editor": seqno769 }) ];
    Lino.ledger.ItemsByInvoice.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.ItemsByInvoice.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/ItemsByInvoice","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.ledger.ItemsByInvoice.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/ItemsByInvoice","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.ledger.ItemsByInvoice.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/ItemsByInvoice","GET",pk,"put",null);
};
Lino.ledger.ItemsByInvoice.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/ItemsByInvoice","GET",pk,"post",null);
};
Lino.ledger.ItemsByInvoice.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/ItemsByInvoice","GET",pk,"duplicate",null);
};
Lino.ledger.ItemsByInvoice.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.ItemsByInvoice.GridPanel(p);
});
Lino.ledger.ItemsByInvoice.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/ItemsByInvoice","GET",pk,"move_up",null);
};
Lino.ledger.ItemsByInvoice.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/ItemsByInvoice","GET",pk,"move_down",null);
};

// js_render_GridPanel_class declarations.VouchersByDeclaration
Lino.declarations.VouchersByDeclaration.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "emptyText": "No data to display." },
  ls_url : "/declarations/VouchersByDeclaration",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/declarations/VouchersByDeclaration','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/declarations/VouchersByDeclaration','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/declarations/VouchersByDeclaration','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" } ],
  cell_edit : true,
  title : "Vouchers",
  page_length : 20,
  stripeRows : true,
  disable_editing : true,
  disabled_actions_index : 11,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "type": "int", "name": "number" }, { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "journal" }, 'journalHidden', { "name": "year" }, 'yearHidden', { "name": "narration" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var date839 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var number840 = new Ext.form.NumberField({ "selectOnFocus": true });
    var id841 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user842 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/declarations/VouchersByDeclaration/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var journal843 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/declarations/VouchersByDeclaration/journal", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Journal..." });
    var year844 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var narration845 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(declarations.VouchersByDeclaration.date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "date", "width": Lino.chars2width(9), "editor": date839 }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "format": "0", "editable": true, "tooltip": "(declarations.VouchersByDeclaration.number) ", "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(6), "editor": number840 }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(declarations.VouchersByDeclaration.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id841, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 3, "sortable": true, "header": "Author", "editable": true, "tooltip": "(declarations.VouchersByDeclaration.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user842, "dataIndex": "user" }, { "colIndex": 4, "sortable": true, "header": "Journal", "editable": true, "tooltip": "(declarations.VouchersByDeclaration.journal) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('journalHidden','Lino.ledger.Journals.detail'), "editor": journal843, "dataIndex": "journal" }, { "colIndex": 5, "sortable": true, "header": "Fiscal Year", "editable": true, "tooltip": "(declarations.VouchersByDeclaration.year) ", "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "year", "editor": year844 }, { "colIndex": 6, "sortable": true, "header": "Narration", "editable": true, "tooltip": "(declarations.VouchersByDeclaration.narration) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "narration", "editor": narration845 } ];
    Lino.declarations.VouchersByDeclaration.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.declarations.VouchersByDeclaration.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/declarations/VouchersByDeclaration","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.declarations.VouchersByDeclaration.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/declarations/VouchersByDeclaration","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.declarations.VouchersByDeclaration.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.declarations.VouchersByDeclaration.GridPanel(p);
});

// js_render_GridPanel_class declarations.DeclarationsByJournal
Lino.declarations.DeclarationsByJournal.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/declarations/DeclarationsByJournal",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/declarations/DeclarationsByJournal','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/declarations/DeclarationsByJournal','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/declarations/DeclarationsByJournal','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "VAT declarations",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 22,
  ls_store_fields : [ { "type": "int", "name": "number" }, { "name": "period" }, 'periodHidden', { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "user" }, 'userHidden', { "type": "int", "name": "id" }, { "name": "year" }, 'yearHidden', { "name": "narration" }, { "name": "declared_in" }, 'declared_inHidden', { "name": "state" }, 'stateHidden', { "name": "sales_base" }, { "name": "sales_vat" }, { "name": "purchases_base" }, { "name": "purchases_vat" }, { "name": "purchases_investments" }, { "name": "purchases_ware" }, { "name": "purchases_services" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.declarations.DeclarationsByJournal.detail;
    this.ls_insert_handler = Lino.declarations.DeclarationsByJournal.insert;
    var ww = this.containing_window;
    var number1454 = new Ext.form.NumberField({ "selectOnFocus": true });
    var period1455 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.declarations.DeclarationPeriods });
    var date1456 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var user1457 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/declarations/DeclarationsByJournal/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var id1458 = new Ext.form.NumberField({ "selectOnFocus": true });
    var year1459 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var narration1460 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var declared_in1461 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/declarations/DeclarationsByJournal/declared_in", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a VAT declaration..." });
    var state1462 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.declarations.DeclarationStates });
    var sales_base1463 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": false, "decimalSeparator": "," });
    var sales_vat1464 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": false, "decimalSeparator": "," });
    var purchases_base1465 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": false, "decimalSeparator": "," });
    var purchases_vat1466 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": false, "decimalSeparator": "," });
    var purchases_investments1467 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": false, "decimalSeparator": "," });
    var purchases_ware1468 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": false, "decimalSeparator": "," });
    var purchases_services1469 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": false, "decimalSeparator": "," });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(declarations.DeclarationsByJournal.number) ", "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(6), "editor": number1454 }), { "colIndex": 1, "sortable": true, "header": "VAT Period", "editable": true, "tooltip": "(declarations.DeclarationsByJournal.period) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "period", "editor": period1455 }, { "colIndex": 2, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(declarations.DeclarationsByJournal.date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "date", "width": Lino.chars2width(9), "editor": date1456 }, { "colIndex": 3, "sortable": true, "header": "Author", "editable": true, "tooltip": "(declarations.DeclarationsByJournal.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1457, "dataIndex": "user" }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(declarations.DeclarationsByJournal.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1458, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Fiscal Year", "editable": true, "tooltip": "(declarations.DeclarationsByJournal.year) ", "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "year", "editor": year1459 }, { "colIndex": 6, "sortable": true, "header": "Narration", "editable": true, "tooltip": "(declarations.DeclarationsByJournal.narration) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "narration", "editor": narration1460 }, { "colIndex": 7, "sortable": true, "header": "VAT declaration", "editable": true, "tooltip": "(declarations.DeclarationsByJournal.declared_in) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('declared_inHidden','Lino.declarations.Declarations.detail'), "editor": declared_in1461, "dataIndex": "declared_in" }, { "colIndex": 8, "sortable": true, "header": "State", "editable": true, "tooltip": "(declarations.DeclarationsByJournal.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(14), "dataIndex": "state", "editor": state1462 }, new Lino.NullNumberColumn({ "colIndex": 9, "sortable": true, "header": "Sales base", "editable": true, "tooltip": "(declarations.DeclarationsByJournal.sales_base) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "sales_base", "editor": sales_base1463 }), new Lino.NullNumberColumn({ "colIndex": 10, "sortable": true, "header": "Sales VAT", "editable": true, "tooltip": "(declarations.DeclarationsByJournal.sales_vat) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "sales_vat", "editor": sales_vat1464 }), new Lino.NullNumberColumn({ "colIndex": 11, "sortable": true, "header": "Purchases base", "editable": true, "tooltip": "(declarations.DeclarationsByJournal.purchases_base) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "purchases_base", "editor": purchases_base1465 }), new Lino.NullNumberColumn({ "colIndex": 12, "sortable": true, "header": "Purchases VAT", "editable": true, "tooltip": "(declarations.DeclarationsByJournal.purchases_vat) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "purchases_vat", "editor": purchases_vat1466 }), new Lino.NullNumberColumn({ "colIndex": 13, "sortable": true, "header": "Investments", "editable": true, "tooltip": "(declarations.DeclarationsByJournal.purchases_investments) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "purchases_investments", "editor": purchases_investments1467 }), new Lino.NullNumberColumn({ "colIndex": 14, "sortable": true, "header": "Ware", "editable": true, "tooltip": "(declarations.DeclarationsByJournal.purchases_ware) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "purchases_ware", "editor": purchases_ware1468 }), new Lino.NullNumberColumn({ "colIndex": 15, "sortable": true, "header": "Services", "editable": true, "tooltip": "(declarations.DeclarationsByJournal.purchases_services) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "purchases_services", "editor": purchases_services1469 }) ];
    Lino.declarations.DeclarationsByJournal.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.declarations.DeclarationsByJournal.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/declarations/DeclarationsByJournal","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.declarations.DeclarationsByJournal.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/declarations/DeclarationsByJournal","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.declarations.DeclarationsByJournal.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/declarations/DeclarationsByJournal","GET",pk,"put",null);
};
Lino.declarations.DeclarationsByJournal.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/declarations/DeclarationsByJournal","GET",pk,"post",null);
};

Lino.declarations.DeclarationsByJournal.insertPanel = Ext.extend(Lino.declarations.Declarations.InsertFormPanel,{
  empty_title: "New VAT declarations",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/declarations/DeclarationsByJournal",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.declarations.DeclarationsByJournal.detail;
    this.ls_insert_handler = Lino.declarations.DeclarationsByJournal.insert;
    Lino.declarations.DeclarationsByJournal.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.declarations.DeclarationsByJournal.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.declarations.DeclarationsByJournal.insertPanel(p);
});
Lino.declarations.DeclarationsByJournal.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/declarations/DeclarationsByJournal","GET",pk,"poststay",null);
};

Lino.declarations.DeclarationsByJournal.detailPanel = Ext.extend(Lino.declarations.Declarations.DetailFormPanel,{
  empty_title: "Detail VAT declarations",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/declarations/DeclarationsByJournal",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.declarations.DeclarationsByJournal.detail;
    this.ls_insert_handler = Lino.declarations.DeclarationsByJournal.insert;
    Lino.declarations.DeclarationsByJournal.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.declarations.DeclarationsByJournal.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.declarations.DeclarationsByJournal.detailPanel(p);
});
Lino.declarations.DeclarationsByJournal.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.declarations.DeclarationsByJournal.GridPanel(p);
});
Lino.declarations.DeclarationsByJournal.deregister_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/declarations/DeclarationsByJournal","GET",pk,"deregister_action",null);
};
Lino.declarations.DeclarationsByJournal.register_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/declarations/DeclarationsByJournal","GET",pk,"register_action",null);
};

// js_render_GridPanel_class sales.ItemsByInvoice
Lino.sales.ItemsByInvoice.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "No data to display." },
  ls_url : "/sales/ItemsByInvoice",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/sales/ItemsByInvoice','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/ItemsByInvoice','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/ItemsByInvoice','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-arrow_up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-arrow_down", "overflowText": "Down", "auto_save": true } ],
  cell_edit : true,
  title : "invoice items",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 13,
  ls_store_fields : [ { "type": "int", "name": "seqno" }, { "name": "product" }, 'productHidden', { "name": "title" }, { "name": "description" }, { "name": "discount" }, { "name": "unit_price" }, { "name": "qty" }, { "name": "total_incl" }, { "name": "total_base" }, { "name": "total_vat" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 11,
  ls_grid_configs : [  ],
  content_type : 35,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var seqno360 = new Ext.form.NumberField({ "selectOnFocus": true });
    var product361 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/ItemsByInvoice/product", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Product..." });
    var title362 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var description363 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var discount364 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var unit_price365 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var qty366 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(6), "maxLength": 6 });
    var total_incl367 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_base368 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat369 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(sales.ItemsByInvoice.seqno) ", "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "hidden": true, "width": Lino.chars2width(4), "editor": seqno360 }), { "colIndex": 1, "sortable": true, "header": "Product", "editable": true, "tooltip": "(sales.ItemsByInvoice.product) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('productHidden','Lino.products.Products.detail'), "editor": product361, "dataIndex": "product" }, { "colIndex": 2, "sortable": true, "header": "Description", "editable": true, "tooltip": "(sales.ItemsByInvoice.title) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "title", "editor": title362 }, { "colIndex": 3, "sortable": false, "width": Lino.chars2width(21), "editable": true, "tooltip": "(sales.ItemsByInvoice.description) ", "filter": { "type": "string" }, "header": "Description", "renderer": Lino.text_renderer, "hidden": true, "editor": description363, "dataIndex": "description" }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "header": "Discount", "editable": true, "tooltip": "(sales.ItemsByInvoice.discount) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(8), "dataIndex": "discount", "editor": discount364 }), new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "header": "Unit price", "editable": true, "tooltip": "(sales.ItemsByInvoice.unit_price) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "unit_price", "editor": unit_price365 }), { "colIndex": 6, "sortable": true, "format": "", "align": "right", "editable": true, "tooltip": "(sales.ItemsByInvoice.qty) ", "filter": { "type": "string" }, "header": "Quantity", "dataIndex": "qty", "width": Lino.chars2width(8), "editor": qty366 }, new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "header": "Total incl. VAT", "editable": true, "tooltip": "(sales.ItemsByInvoice.total_incl) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_incl", "editor": total_incl367 }), new Lino.NullNumberColumn({ "colIndex": 8, "sortable": true, "header": "Total excl. VAT", "editable": true, "tooltip": "(sales.ItemsByInvoice.total_base) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_base", "hidden": true, "editor": total_base368 }), new Lino.NullNumberColumn({ "colIndex": 9, "sortable": true, "header": "VAT", "editable": true, "tooltip": "(sales.ItemsByInvoice.total_vat) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_vat", "hidden": true, "editor": total_vat369 }) ];
    Lino.sales.ItemsByInvoice.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.ItemsByInvoice.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/ItemsByInvoice","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.sales.ItemsByInvoice.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/ItemsByInvoice","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.sales.ItemsByInvoice.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/ItemsByInvoice","GET",pk,"put",null);
};
Lino.sales.ItemsByInvoice.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/ItemsByInvoice","GET",pk,"post",null);
};
Lino.sales.ItemsByInvoice.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/ItemsByInvoice","GET",pk,"duplicate",null);
};
Lino.sales.ItemsByInvoice.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.ItemsByInvoice.GridPanel(p);
});
Lino.sales.ItemsByInvoice.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/ItemsByInvoice","GET",pk,"move_up",null);
};
Lino.sales.ItemsByInvoice.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/ItemsByInvoice","GET",pk,"move_down",null);
};

// js_render_GridPanel_class sales.ItemsByInvoicePrint
Lino.sales.ItemsByInvoicePrint.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "No data to display." },
  ls_url : "/sales/ItemsByInvoicePrint",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/sales/ItemsByInvoicePrint','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/ItemsByInvoicePrint','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/ItemsByInvoicePrint','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-arrow_up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-arrow_down", "overflowText": "Down", "auto_save": true } ],
  cell_edit : true,
  title : "invoice items",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "name": "title" }, { "name": "unit_price" }, { "name": "qty" }, { "name": "total_incl" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 35,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var title1471 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var unit_price1472 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var qty1473 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(6), "maxLength": 6 });
    var total_incl1474 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Description", "editable": true, "tooltip": "(sales.ItemsByInvoicePrint.title) ", "filter": { "type": "string" }, "width": Lino.chars2width(41), "dataIndex": "title", "editor": title1471 }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "header": "Unit price", "editable": true, "tooltip": "(sales.ItemsByInvoicePrint.unit_price) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(11), "dataIndex": "unit_price", "editor": unit_price1472 }), { "colIndex": 2, "sortable": true, "format": "", "align": "right", "editable": true, "tooltip": "(sales.ItemsByInvoicePrint.qty) ", "filter": { "type": "string" }, "header": "Quantity", "dataIndex": "qty", "width": Lino.chars2width(6), "editor": qty1473 }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "header": "Total incl. VAT", "editable": true, "tooltip": "(sales.ItemsByInvoicePrint.total_incl) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(11), "dataIndex": "total_incl", "editor": total_incl1474 }) ];
    Lino.sales.ItemsByInvoicePrint.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.ItemsByInvoicePrint.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/ItemsByInvoicePrint","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.sales.ItemsByInvoicePrint.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/ItemsByInvoicePrint","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.sales.ItemsByInvoicePrint.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/ItemsByInvoicePrint","GET",pk,"put",null);
};
Lino.sales.ItemsByInvoicePrint.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/ItemsByInvoicePrint","GET",pk,"post",null);
};
Lino.sales.ItemsByInvoicePrint.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/ItemsByInvoicePrint","GET",pk,"duplicate",null);
};
Lino.sales.ItemsByInvoicePrint.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.ItemsByInvoicePrint.GridPanel(p);
});
Lino.sales.ItemsByInvoicePrint.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/ItemsByInvoicePrint","GET",pk,"move_up",null);
};
Lino.sales.ItemsByInvoicePrint.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/ItemsByInvoicePrint","GET",pk,"move_down",null);
};

// js_render_GridPanel_class sales.InvoiceItemsByProduct
Lino.sales.InvoiceItemsByProduct.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "forceFit": true, "emptyText": "No data to display." },
  ls_url : "/sales/InvoiceItemsByProduct",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/sales/InvoiceItemsByProduct','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/InvoiceItemsByProduct','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/InvoiceItemsByProduct','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-arrow_up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-arrow_down", "overflowText": "Down", "auto_save": true } ],
  cell_edit : true,
  title : "invoice items",
  page_length : 20,
  stripeRows : true,
  disable_editing : true,
  disabled_actions_index : 14,
  ls_store_fields : [ { "name": "voucher" }, 'voucherHidden', { "name": "voucher__partner" }, 'voucher__partnerHidden', { "name": "qty" }, { "name": "title" }, { "name": "description" }, { "name": "discount" }, { "name": "unit_price" }, { "name": "total_incl" }, { "name": "total_base" }, { "name": "total_vat" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  pk_index : 12,
  ls_grid_configs : [  ],
  content_type : 35,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var voucher684 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoiceItemsByProduct/voucher", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Invoice..." });
    var voucher__partner685 = new Lino.RemoteComboFieldElement({ "disabled": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({  }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var qty686 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(6), "maxLength": 6 });
    var title687 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var description688 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var discount689 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var unit_price690 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_incl691 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_base692 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat693 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Invoice", "editable": true, "tooltip": "(sales.InvoiceItemsByProduct.voucher) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('voucherHidden','Lino.sales.Invoices.detail'), "editor": voucher684, "dataIndex": "voucher" }, { "colIndex": 1, "sortable": true, "header": "Partner", "editable": false, "tooltip": "(sales.InvoiceItemsByProduct.voucher__partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "voucher__partner" }, { "colIndex": 2, "sortable": true, "format": "", "align": "right", "editable": true, "tooltip": "(sales.InvoiceItemsByProduct.qty) ", "filter": { "type": "string" }, "header": "Quantity", "dataIndex": "qty", "width": Lino.chars2width(8), "editor": qty686 }, { "colIndex": 3, "sortable": true, "header": "Description", "editable": true, "tooltip": "(sales.InvoiceItemsByProduct.title) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "title", "editor": title687 }, { "colIndex": 4, "sortable": false, "width": Lino.chars2width(21), "editable": true, "tooltip": "(sales.InvoiceItemsByProduct.description) ", "filter": { "type": "string" }, "header": "Description", "renderer": Lino.text_renderer, "hidden": true, "editor": description688, "dataIndex": "description" }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "header": "Discount", "editable": true, "tooltip": "(sales.InvoiceItemsByProduct.discount) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(8), "dataIndex": "discount", "editor": discount689 }), new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "header": "Unit price", "editable": true, "tooltip": "(sales.InvoiceItemsByProduct.unit_price) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "unit_price", "editor": unit_price690 }), new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "header": "Total incl. VAT", "editable": true, "tooltip": "(sales.InvoiceItemsByProduct.total_incl) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_incl", "editor": total_incl691 }), new Lino.NullNumberColumn({ "colIndex": 8, "sortable": true, "header": "Total excl. VAT", "editable": true, "tooltip": "(sales.InvoiceItemsByProduct.total_base) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_base", "hidden": true, "editor": total_base692 }), new Lino.NullNumberColumn({ "colIndex": 9, "sortable": true, "header": "VAT", "editable": true, "tooltip": "(sales.InvoiceItemsByProduct.total_vat) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_vat", "hidden": true, "editor": total_vat693 }) ];
    Lino.sales.InvoiceItemsByProduct.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.InvoiceItemsByProduct.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoiceItemsByProduct","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.sales.InvoiceItemsByProduct.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoiceItemsByProduct","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.sales.InvoiceItemsByProduct.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoiceItemsByProduct","GET",pk,"duplicate",null);
};
Lino.sales.InvoiceItemsByProduct.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.InvoiceItemsByProduct.GridPanel(p);
});
Lino.sales.InvoiceItemsByProduct.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoiceItemsByProduct","GET",pk,"move_up",null);
};
Lino.sales.InvoiceItemsByProduct.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoiceItemsByProduct","GET",pk,"move_down",null);
};

// js_render_GridPanel_class sales.InvoicesByJournal
Lino.sales.InvoicesByJournal.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/sales/InvoicesByJournal",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/sales/InvoicesByJournal','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/InvoicesByJournal','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/InvoicesByJournal','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.list_action_handler('/sales/InvoicesByJournal','do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Clear cache", "auto_save": true } ],
  cell_edit : true,
  title : "Invoices",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 35,
  ls_store_fields : [ { "type": "int", "name": "number" }, { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "due_date", "dateFormat": "d.m.Y" }, { "name": "partner" }, 'partnerHidden', { "name": "total_incl" }, { "name": "subject" }, { "name": "total_base" }, { "name": "total_vat" }, { "name": "user" }, 'userHidden', { "type": "int", "name": "id" }, { "name": "year" }, 'yearHidden', { "name": "narration" }, { "name": "declared_in" }, 'declared_inHidden', { "name": "build_time" }, { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "match" }, { "name": "language" }, 'languageHidden', { "name": "your_ref" }, { "name": "imode" }, 'imodeHidden', { "name": "shipping_mode" }, 'shipping_modeHidden', { "name": "payment_term" }, 'payment_termHidden', { "name": "intro" }, { "name": "discount" }, { "name": "state" }, 'stateHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 11,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.InvoicesByJournal.detail;
    this.ls_insert_handler = Lino.sales.InvoicesByJournal.insert;
    var ww = this.containing_window;
    var number1476 = new Ext.form.NumberField({ "selectOnFocus": true });
    var date1477 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var due_date1478 = new Lino.DateField({ "selectOnFocus": true });
    var partner1479 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoicesByJournal/partner", "method": "GET" }) }), "emptyText": "Select a Partner..." });
    var total_incl1480 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var subject1481 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var total_base1482 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat1483 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var user1484 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoicesByJournal/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var id1485 = new Ext.form.NumberField({ "selectOnFocus": true });
    var year1486 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var narration1487 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var declared_in1488 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoicesByJournal/declared_in", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a VAT declaration..." });
    var build_time1489 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var vat_regime1490 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.vat.VatRegimes });
    var match1491 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoicesByJournal/match", "method": "GET" }) }) });
    var language1492 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ] });
    var your_ref1493 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var imode1494 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoicesByJournal/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Invoicing Mode..." });
    var shipping_mode1495 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoicesByJournal/shipping_mode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Shipping Mode..." });
    var payment_term1496 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoicesByJournal/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Payment Term..." });
    var intro1497 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var discount1498 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var state1499 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.sales.InvoiceStates });
    this.before_row_edit = function(record) {
      match1491.setContextValue('partner',record ? record.data['partnerHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      partner1479.on('change',Lino.chooser_handler(match1491,'partner'));
      Lino.sales.InvoicesByJournal.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(sales.InvoicesByJournal.number) ", "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(6), "editor": number1476 }), { "colIndex": 1, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(sales.InvoicesByJournal.date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "date", "width": Lino.chars2width(9), "editor": date1477 }, { "colIndex": 2, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(sales.InvoicesByJournal.due_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date of payment", "dataIndex": "due_date", "width": Lino.chars2width(9), "editor": due_date1478 }, { "colIndex": 3, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(sales.InvoicesByJournal.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner1479, "dataIndex": "partner" }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "header": "Total incl. VAT", "editable": true, "tooltip": "(sales.InvoicesByJournal.total_incl) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_incl", "editor": total_incl1480 }), { "colIndex": 5, "sortable": true, "header": "Subject line", "editable": true, "tooltip": "(sales.InvoicesByJournal.subject) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "subject", "editor": subject1481 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "header": "Total excl. VAT", "editable": true, "tooltip": "(sales.InvoicesByJournal.total_base) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_base", "editor": total_base1482 }), new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "header": "VAT", "editable": true, "tooltip": "(sales.InvoicesByJournal.total_vat) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_vat", "editor": total_vat1483 }), { "colIndex": 8, "sortable": true, "header": "Author", "editable": true, "tooltip": "(sales.InvoicesByJournal.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1484, "dataIndex": "user" }, new Lino.NullNumberColumn({ "colIndex": 9, "sortable": true, "format": "0", "editable": true, "tooltip": "(sales.InvoicesByJournal.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1485, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 10, "sortable": true, "header": "Fiscal Year", "editable": true, "tooltip": "(sales.InvoicesByJournal.year) ", "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "year", "editor": year1486 }, { "colIndex": 11, "sortable": true, "header": "Narration", "editable": true, "tooltip": "(sales.InvoicesByJournal.narration) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "narration", "editor": narration1487 }, { "colIndex": 12, "sortable": true, "header": "VAT declaration", "editable": true, "tooltip": "(sales.InvoicesByJournal.declared_in) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('declared_inHidden','Lino.declarations.Declarations.detail'), "editor": declared_in1488, "dataIndex": "declared_in" }, { "width": Lino.chars2width(17), "colIndex": 13, "sortable": true, "dataIndex": "build_time", "header": "build time", "editable": false, "tooltip": "(sales.InvoicesByJournal.build_time) " }, { "colIndex": 14, "sortable": true, "header": "VAT Regime", "editable": true, "tooltip": "(sales.InvoicesByJournal.vat_regime) ", "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "vat_regime", "editor": vat_regime1490 }, { "colIndex": 15, "sortable": true, "header": "Match", "editable": true, "tooltip": "(sales.InvoicesByJournal.match) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "match", "editor": match1491 }, { "colIndex": 16, "sortable": true, "header": "Language", "editable": true, "tooltip": "(sales.InvoicesByJournal.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language1492 }, { "colIndex": 17, "sortable": true, "header": "Your reference", "editable": true, "tooltip": "(sales.InvoicesByJournal.your_ref) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "your_ref", "editor": your_ref1493 }, { "colIndex": 18, "sortable": true, "header": "Invoicing Mode", "editable": true, "tooltip": "(sales.InvoicesByJournal.imode) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "imode", "editor": imode1494 }, { "colIndex": 19, "sortable": true, "header": "Shipping Mode", "editable": true, "tooltip": "(sales.InvoicesByJournal.shipping_mode) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "shipping_mode", "editor": shipping_mode1495 }, { "colIndex": 20, "sortable": true, "header": "Payment Term", "editable": true, "tooltip": "(sales.InvoicesByJournal.payment_term) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "payment_term", "editor": payment_term1496 }, { "colIndex": 21, "sortable": false, "header": "Introductive Text", "editable": true, "tooltip": "(sales.InvoicesByJournal.intro) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": intro1497, "dataIndex": "intro" }, new Lino.NullNumberColumn({ "colIndex": 22, "sortable": true, "header": "Discount", "editable": true, "tooltip": "(sales.InvoicesByJournal.discount) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(8), "dataIndex": "discount", "editor": discount1498 }), { "colIndex": 23, "sortable": true, "header": "State", "editable": true, "tooltip": "(sales.InvoicesByJournal.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(14), "dataIndex": "state", "editor": state1499 } ];
    Lino.sales.InvoicesByJournal.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.InvoicesByJournal.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoicesByJournal","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.sales.InvoicesByJournal.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoicesByJournal","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.sales.InvoicesByJournal.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoicesByJournal","GET",pk,"put",null);
};
Lino.sales.InvoicesByJournal.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoicesByJournal","GET",pk,"post",null);
};

Lino.sales.InvoicesByJournal.insertPanel = Ext.extend(Lino.sales.Invoices.InsertFormPanel,{
  empty_title: "New Invoices",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true } ],
  ls_url: "/sales/InvoicesByJournal",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.InvoicesByJournal.detail;
    this.ls_insert_handler = Lino.sales.InvoicesByJournal.insert;
    Lino.sales.InvoicesByJournal.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.InvoicesByJournal.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.sales.InvoicesByJournal.insertPanel(p);
});
Lino.sales.InvoicesByJournal.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoicesByJournal","GET",pk,"poststay",null);
};
Lino.sales.InvoicesByJournal.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoicesByJournal","GET",pk,"duplicate",null);
};

Lino.sales.InvoicesByJournal.detailPanel = Ext.extend(Lino.sales.Invoices.DetailFormPanel,{
  empty_title: "Detail Invoices",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.list_action_handler('/sales/InvoicesByJournal','do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Clear cache", "auto_save": true } ],
  ls_url: "/sales/InvoicesByJournal",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.InvoicesByJournal.detail;
    this.ls_insert_handler = Lino.sales.InvoicesByJournal.insert;
    Lino.sales.InvoicesByJournal.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.InvoicesByJournal.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.InvoicesByJournal.detailPanel(p);
});
Lino.sales.InvoicesByJournal.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoicesByJournal","POST",pk,"do_print",null);
};
Lino.sales.InvoicesByJournal.do_clear_cache = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoicesByJournal","GET",pk,"do_clear_cache",null);
};
Lino.sales.InvoicesByJournal.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.sales.Invoices.ParamsPanel({});
  return new Lino.sales.InvoicesByJournal.GridPanel(p);
});
Lino.sales.InvoicesByJournal.deregister_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoicesByJournal","GET",pk,"deregister_action",null);
};
Lino.sales.InvoicesByJournal.register_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoicesByJournal","GET",pk,"register_action",null);
};

// js_render_GridPanel_class sales.InvoicesByPartner
Lino.sales.InvoicesByPartner.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/sales/InvoicesByPartner",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/sales/InvoicesByPartner','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/InvoicesByPartner','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/InvoicesByPartner','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.list_action_handler('/sales/InvoicesByPartner','do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Clear cache", "auto_save": true } ],
  cell_edit : true,
  title : "Invoices",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 35,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "total_incl" }, { "name": "total_base" }, { "name": "total_vat" }, { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "journal" }, 'journalHidden', { "name": "year" }, 'yearHidden', { "type": "int", "name": "number" }, { "name": "narration" }, { "name": "declared_in" }, 'declared_inHidden', { "name": "build_time" }, { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "match" }, { "name": "language" }, 'languageHidden', { "name": "your_ref" }, { "name": "imode" }, 'imodeHidden', { "name": "shipping_mode" }, 'shipping_modeHidden', { "name": "payment_term" }, 'payment_termHidden', { "name": "subject" }, { "name": "intro" }, { "name": "discount" }, { "type": "date", "name": "due_date", "dateFormat": "d.m.Y" }, { "name": "state" }, 'stateHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.InvoicesByPartner.detail;
    this.ls_insert_handler = Lino.sales.InvoicesByPartner.insert;
    var ww = this.containing_window;
    var date297 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var total_incl298 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_base299 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat300 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var id301 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user302 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoicesByPartner/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var journal303 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoicesByPartner/journal", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Journal..." });
    var year304 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var number305 = new Ext.form.NumberField({ "selectOnFocus": true });
    var narration306 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var declared_in307 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoicesByPartner/declared_in", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a VAT declaration..." });
    var build_time308 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var vat_regime309 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.vat.VatRegimes });
    var match310 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoicesByPartner/match", "method": "GET" }) }) });
    var language311 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ] });
    var your_ref312 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var imode313 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoicesByPartner/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Invoicing Mode..." });
    var shipping_mode314 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoicesByPartner/shipping_mode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Shipping Mode..." });
    var payment_term315 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoicesByPartner/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Payment Term..." });
    var subject316 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var intro317 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var discount318 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var due_date319 = new Lino.DateField({ "selectOnFocus": true });
    var state320 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.sales.InvoiceStates });
    this.before_row_edit = function(record) {
      var bp = this.get_base_params();
      match310.setContextValue('mk',bp['mk']);
      match310.setContextValue('mt',bp['mt']);
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(sales.InvoicesByPartner.date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "date", "width": Lino.chars2width(9), "editor": date297 }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "header": "Total incl. VAT", "editable": true, "tooltip": "(sales.InvoicesByPartner.total_incl) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_incl", "editor": total_incl298 }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "header": "Total excl. VAT", "editable": true, "tooltip": "(sales.InvoicesByPartner.total_base) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_base", "editor": total_base299 }), new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "header": "VAT", "editable": true, "tooltip": "(sales.InvoicesByPartner.total_vat) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_vat", "editor": total_vat300 }), new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(sales.InvoicesByPartner.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id301, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Author", "editable": true, "tooltip": "(sales.InvoicesByPartner.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user302, "dataIndex": "user" }, { "colIndex": 6, "sortable": true, "header": "Journal", "editable": true, "tooltip": "(sales.InvoicesByPartner.journal) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('journalHidden','Lino.ledger.Journals.detail'), "editor": journal303, "dataIndex": "journal" }, { "colIndex": 7, "sortable": true, "header": "Fiscal Year", "editable": true, "tooltip": "(sales.InvoicesByPartner.year) ", "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "year", "editor": year304 }, new Lino.NullNumberColumn({ "colIndex": 8, "sortable": true, "format": "0", "editable": true, "tooltip": "(sales.InvoicesByPartner.number) ", "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(6), "editor": number305 }), { "colIndex": 9, "sortable": true, "header": "Narration", "editable": true, "tooltip": "(sales.InvoicesByPartner.narration) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "narration", "editor": narration306 }, { "colIndex": 10, "sortable": true, "header": "VAT declaration", "editable": true, "tooltip": "(sales.InvoicesByPartner.declared_in) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('declared_inHidden','Lino.declarations.Declarations.detail'), "editor": declared_in307, "dataIndex": "declared_in" }, { "width": Lino.chars2width(17), "colIndex": 11, "sortable": true, "dataIndex": "build_time", "header": "build time", "editable": false, "tooltip": "(sales.InvoicesByPartner.build_time) " }, { "colIndex": 12, "sortable": true, "header": "VAT Regime", "editable": true, "tooltip": "(sales.InvoicesByPartner.vat_regime) ", "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "vat_regime", "editor": vat_regime309 }, { "colIndex": 13, "sortable": true, "header": "Match", "editable": true, "tooltip": "(sales.InvoicesByPartner.match) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "match", "editor": match310 }, { "colIndex": 14, "sortable": true, "header": "Language", "editable": true, "tooltip": "(sales.InvoicesByPartner.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language311 }, { "colIndex": 15, "sortable": true, "header": "Your reference", "editable": true, "tooltip": "(sales.InvoicesByPartner.your_ref) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "your_ref", "editor": your_ref312 }, { "colIndex": 16, "sortable": true, "header": "Invoicing Mode", "editable": true, "tooltip": "(sales.InvoicesByPartner.imode) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "imode", "editor": imode313 }, { "colIndex": 17, "sortable": true, "header": "Shipping Mode", "editable": true, "tooltip": "(sales.InvoicesByPartner.shipping_mode) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "shipping_mode", "editor": shipping_mode314 }, { "colIndex": 18, "sortable": true, "header": "Payment Term", "editable": true, "tooltip": "(sales.InvoicesByPartner.payment_term) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "payment_term", "editor": payment_term315 }, { "colIndex": 19, "sortable": true, "header": "Subject line", "editable": true, "tooltip": "(sales.InvoicesByPartner.subject) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "subject", "editor": subject316 }, { "colIndex": 20, "sortable": false, "header": "Introductive Text", "editable": true, "tooltip": "(sales.InvoicesByPartner.intro) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": intro317, "dataIndex": "intro" }, new Lino.NullNumberColumn({ "colIndex": 21, "sortable": true, "header": "Discount", "editable": true, "tooltip": "(sales.InvoicesByPartner.discount) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(8), "dataIndex": "discount", "editor": discount318 }), { "colIndex": 22, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(sales.InvoicesByPartner.due_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date of payment", "dataIndex": "due_date", "width": Lino.chars2width(9), "editor": due_date319 }, { "colIndex": 23, "sortable": true, "header": "State", "editable": true, "tooltip": "(sales.InvoicesByPartner.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(14), "dataIndex": "state", "editor": state320 } ];
    Lino.sales.InvoicesByPartner.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.InvoicesByPartner.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoicesByPartner","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.sales.InvoicesByPartner.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoicesByPartner","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.sales.InvoicesByPartner.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoicesByPartner","GET",pk,"put",null);
};
Lino.sales.InvoicesByPartner.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoicesByPartner","GET",pk,"post",null);
};

Lino.sales.InvoicesByPartner.insertPanel = Ext.extend(Lino.sales.Invoices.InsertFormPanel,{
  empty_title: "New Invoices",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true } ],
  ls_url: "/sales/InvoicesByPartner",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.InvoicesByPartner.detail;
    this.ls_insert_handler = Lino.sales.InvoicesByPartner.insert;
    Lino.sales.InvoicesByPartner.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.InvoicesByPartner.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.sales.InvoicesByPartner.insertPanel(p);
});
Lino.sales.InvoicesByPartner.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoicesByPartner","GET",pk,"poststay",null);
};
Lino.sales.InvoicesByPartner.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoicesByPartner","GET",pk,"duplicate",null);
};

Lino.sales.InvoicesByPartner.detailPanel = Ext.extend(Lino.sales.Invoices.DetailFormPanel,{
  empty_title: "Detail Invoices",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel)