/*
 Copyright 2009-2013 Luc Saffre
 This file is part of the Lino project.
 Lino is free software; you can redistribute it and/or modify 
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.
 Lino is distributed in the hope that it will be useful, 
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 GNU General Public License for more details.
 You should have received a copy of the GNU General Public License
 along with Lino; if not, see <http://www.gnu.org/licenses/>.
*/

// lino.js --- generated Mon Oct  7 02:17:53 2013 by Lino version 1.6.12.
Ext.BLANK_IMAGE_URL = '/media/extjs/resources/images/default/s.gif';
LANGUAGE_CHOICES = [ [ "en", "English" ], [ "et", "Estonian" ] ];
MEDIA_URL = "/media";

// hack to add a toCamel function, inspired by
// http://jamesroberts.name/blog/2010/02/22/string-functions-for-javascript-trim-to-camel-case-to-dashed-and-to-underscore/
String.prototype.toCamel = function(){
  //~ return this.replace(/(\-[a-z])/g, function($1){return $1.toUpperCase().replace('-','');});
  //~ return this;
  return this.replace(/([A-Z])([A-Z]+)/g, function(match,p1,p2,offset,string){
      //~ console.log("20131005 got ",arguments);
      return p1 + p2.toLowerCase();});
};



/* MonthPickerPlugin: thanks to keypoint @ sencha forum
   http://www.sencha.com/forum/showthread.php?74002-3.x-Ext.ux.MonthMenu&p=356860#post356860
*/
Ext.namespace('Ext.ux'); 

Ext.ux.MonthPickerPlugin = function() { 
    var picker; 
    var oldDateDefaults; 

    this.init = function(pk) { 
        picker = pk; 
        picker.onTriggerClick = picker.onTriggerClick.createSequence(onClick); 
        picker.getValue = picker.getValue.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
        picker.beforeBlur = picker.beforeBlur.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
    }; 

    function setDefaultMonthDay() { 
        oldDateDefaults = Date.defaults.d; 
        Date.defaults.d = 1; 
        return true; 
    } 

    function restoreDefaultMonthDay(ret) { 
        Date.defaults.d = oldDateDefaults; 
        return ret; 
    } 

    function onClick(e, el, opt) { 
        var p = picker.menu.picker; 
        p.activeDate = p.activeDate.getFirstDateOfMonth(); 
        if (p.value) { 
            p.value = p.value.getFirstDateOfMonth(); 
        } 

        p.showMonthPicker(); 
         
        if (!p.disabled) { 
            p.monthPicker.stopFx(); 
            p.monthPicker.show(); 

            p.mun(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mun(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
            p.onMonthClick = p.onMonthClick.createSequence(pickerClick); 
            p.onMonthDblClick = p.onMonthDblClick.createSequence(pickerDblclick); 
            p.mon(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mon(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
        } 
    } 

    function pickerClick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.is('button.x-date-mp-cancel')) { 
            picker.menu.hide(); 
        } else if(el.is('button.x-date-mp-ok')) { 
            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 

    function pickerDblclick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.parent() 
            && (el.parent().is('td.x-date-mp-month') 
            || el.parent().is('td.x-date-mp-year'))) { 

            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 
}; 

Ext.preg('monthPickerPlugin', Ext.ux.MonthPickerPlugin);  

//~ /* 
  //~ http://www.diloc.de/blog/2008/03/05/how-to-submit-ext-forms-the-right-way/
//~ */
//~ /**
 //~ * This submit action is basically the same as the normal submit action,
 //~ * only that it uses the fields getSubmitValue() to compose the values to submit,
 //~ * instead of looping over the input-tags in the form-tag of the form.
 //~ *
 //~ * To use it, just use the OOSubmit-plugin on either a FormPanel or a BasicForm,
 //~ * or explicitly call form.doAction('oosubmit');
 //~ *
 //~ * @param {Object} form
 //~ * @param {Object} options
 //~ */
//~ Ext.ux.OOSubmitAction = function(form, options){
    //~ Ext.ux.OOSubmitAction.superclass.constructor.call(this, form, options);
//~ };

//~ Ext.extend(Ext.ux.OOSubmitAction, Ext.form.Action.Submit, {
    //~ /**
    //~ * @cfg {boolean} clientValidation Determines whether a Form's fields are validated
    //~ * in a final call to {@link Ext.form.BasicForm#isValid isValid} prior to submission.
    //~ * Pass <tt>false</tt> in the Form's submit options to prevent this. If not defined, pre-submission field validation
    //~ * is performed.
    //~ */
    //~ type : 'oosubmit',

    //~ // private
    //~ /**
     //~ * This is nearly a copy of the original submit action run method
     //~ */
    //~ run : function(){
        //~ var o = this.options;
        //~ var method = this.getMethod();
        //~ var isPost = method == 'POST';

        //~ var params = this.options.params || {};
        //~ if (isPost) Ext.applyIf(params, this.form.baseParams);

        //~ //now add the form parameters
        //~ this.form.items.each(function(field)
        //~ {
            //~ if (!field.disabled)
            //~ {
                //~ //check if the form item provides a specialized getSubmitValue() and use that if available
                //~ if (typeof field.getSubmitValue == "function")
                    //~ params[field.getName()] = field.getSubmitValue();
                //~ else
                    //~ params[field.getName()] = field.getValue();
            //~ }
        //~ });

        //~ //convert params to get style if we are not post
        //~ if (!isPost) params=Ext.urlEncode(params);

        //~ if(o.clientValidation === false || this.form.isValid()){
            //~ Ext.Ajax.request(Ext.apply(this.createCallback(o), {
                //~ url:this.getUrl(!isPost),
                //~ method: method,
                //~ params:params, //add our values
                //~ isUpload: this.form.fileUpload
            //~ }));

        //~ }else if (o.clientValidation !== false){ // client validation failed
            //~ this.failureType = Ext.form.Action.CLIENT_INVALID;
            //~ this.form.afterAction(this, false);
        //~ }
    //~ },

//~ });
//~ //add our action to the registry of known actions
//~ Ext.form.Action.ACTION_TYPES['oosubmit'] = Ext.ux.OOSubmitAction;




/**
JC Watsons solution (adapted to ExtJS 3.3.1 by LS) is elegant and simple:
`A "fix" for unchecked checkbox submission  behaviour
<http://www.sencha.com/forum/showthread.php?28449>`_

Added special handling for checkbox inputs. 
ExtJS defines disabled checkboxes `readonly`, not `disabled` as for other inputs.

*/
Ext.lib.Ajax.serializeForm = function(form) {
    //~ console.log('20120203 linolib.js serializeForm',form);
    var fElements = form.elements || (document.forms[form] || Ext.getDom(form)).elements, 
        hasSubmit = false, 
        encoder = encodeURIComponent, 
        name, 
        data = '', 
        type, 
        hasValue;

    Ext.each(fElements, function(element){
        name = element.name;
        type = element.type;

        if (!element.disabled && name && !(type == 'checkbox' && element.readonly)) {
            if (/select-(one|multiple)/i.test(type)) {
                Ext.each(element.options, function(opt){
                    if (opt.selected) {
                        hasValue = opt.hasAttribute ? opt.hasAttribute('value') : opt.getAttributeNode('value').specified;
                        data += String.format("{0}={1}&", encoder(name), encoder(hasValue ? opt.value : opt.text));
                    }
                });
            } else if (!(/file|undefined|reset|button/i.test(type))) {
                //~ if (!(/radio|checkbox/i.test(type) && !element.checked) && !(type == 'submit' && hasSubmit)) {
                if (!(type == 'submit' && hasSubmit)) {
                    if (type == 'checkbox') {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&');
                        data += encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&';
                    } else {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + encoder(element.value) + '&');
                        data += encoder(name) + '=' + encoder(element.value) + '&';
                    }
                    hasSubmit = /submit/i.test(type);
                }
            }
        //~ } else {
            //~ console.log(name,type,element.readonly);
        }
    });
    return data.substr(0, data.length - 1);
};



/*
Set a long timeout of fifteen minutes. 
See /blog/2012/0307
*/
Ext.Ajax.timeout = 15 * 60 * 1000; 

/*
 * Thanks to 
 * `huuze <http://stackoverflow.com/users/10040/huuuze>`_ for the question
 * and to 
 * `chrisv <http://stackoverflow.com/users/683808/chrisv>`_
 * for the answer on
 * http://stackoverflow.com/questions/3764589/how-do-i-include-django-1-2s-csrf-token-in-a-javascript-generated-html-form/5485616#5485616
 * 
 * */
 
Ext.Ajax.on('beforerequest', function (conn, options) {
   if (!(/^http:.*/.test(options.url) || /^https:.*/.test(options.url))) {
     if (typeof(options.headers) == "undefined") {
       options.headers = {'X-CSRFToken': Ext.util.Cookies.get('csrftoken')};
     } else {
       options.headers.extend({'X-CSRFToken': Ext.util.Cookies.get('csrftoken')});
     }                        
   }
}, this);


/*
My fix for the "Cannot set QuickTips dismissDelay to 0" bug,
see http://www.sencha.com/forum/showthread.php?183515 
*/
Ext.override(Ext.QuickTip,{
  showAt : function(xy){
        var t = this.activeTarget;
        //~ console.log("20120224 QuickTip.showAt",this.title,this.dismissDelay,t.dismissDelay);
        if(t){
            if(!this.rendered){
                this.render(Ext.getBody());
                this.activeTarget = t;
            }
            if(t.width){
                this.setWidth(t.width);
                this.body.setWidth(this.adjustBodyWidth(t.width - this.getFrameWidth()));
                this.measureWidth = false;
            } else{
                this.measureWidth = true;
            }
            this.setTitle(t.title || '');
            this.body.update(t.text);
            this.autoHide = t.autoHide;
            // bugfix by Luc 20120226
            if (t.dismissDelay != undefined) this.dismissDelay = t.dismissDelay;
            //~ this.dismissDelay = t.dismissDelay || this.dismissDelay;
            if(this.lastCls){
                this.el.removeClass(this.lastCls);
                delete this.lastCls;
            }
            if(t.cls){
                this.el.addClass(t.cls);
                this.lastCls = t.cls;
            }
            if(this.anchor){
                this.constrainPosition = false;
            }else if(t.align){ 
                xy = this.el.getAlignToXY(t.el, t.align);
                this.constrainPosition = false;
            }else{
                this.constrainPosition = true;
            }
        }
        Ext.QuickTip.superclass.showAt.call(this, xy);
    }
});

/*
Another hack. See /docs/blog/2012/0228
*/
Ext.Element.addMethods(
    function() {
        var VISIBILITY      = "visibility",
            DISPLAY         = "display",
            HIDDEN          = "hidden",
            NONE            = "none",
            XMASKED         = "x-masked",
            XMASKEDRELATIVE = "x-masked-relative",
            data            = Ext.Element.data;

        return {
            
            mask : function(msg, msgCls) {
                var me  = this,
                    dom = me.dom,
                    dh  = Ext.DomHelper,
                    EXTELMASKMSG = "ext-el-mask-msg",
                    el,
                    mask;
                // removed the following lines. See /docs/blog/2012/0228
                //~ if (!(/^body/i.test(dom.tagName) && me.getStyle('position') == 'static')) {
                    //~ console.log(20120228,dom.tagName,me);
                    //~ me.addClass(XMASKEDRELATIVE); 
                //~ }
                if (el = data(dom, 'maskMsg')) {
                    el.remove();
                }
                if (el = data(dom, 'mask')) {
                    el.remove();
                }

                mask = dh.append(dom, {cls : "ext-el-mask"}, true);
                data(dom, 'mask', mask);

                me.addClass(XMASKED);
                mask.setDisplayed(true);
                
                if (typeof msg == 'string') {
                    var mm = dh.append(dom, {cls : EXTELMASKMSG, cn:{tag:'div'}}, true);
                    data(dom, 'maskMsg', mm);
                    mm.dom.className = msgCls ? EXTELMASKMSG + " " + msgCls : EXTELMASKMSG;
                    mm.dom.firstChild.innerHTML = msg;
                    mm.setDisplayed(true);
                    mm.center(me);
                }
                
                
                if (Ext.isIE && !(Ext.isIE7 && Ext.isStrict) && me.getStyle('height') == 'auto') {
                    mask.setSize(undefined, me.getHeight());
                }
                
                return mask;
            }

            
        };
    }()
);



Ext.namespace('Lino');
    
    

//~ Lino.subst_user_field = new Ext.form.ComboBox({});
//~ Lino.subst_user = null;
Lino.insert_subst_user = function(p){
    //~ console.log('20120714 insert_subst_user',Lino.subst_user,p);
    //~ if (Lino.subst_user_field.getValue()) {
    if (p.su) return;
    if (Lino.subst_user) {
        //~ p.su = Lino.subst_user_field.getValue();
        p.su = Lino.subst_user;
    //~ } else {
        //~ delete p.su;
    }
    //~ console.log('20120714 insert_subst_user -->',Lino.subst_user,p);
}

Lino.login_window = null;


Lino.show_login_window = function(on_login) {
  //~ console.log('20121103 show_login_window',arguments);
  //~ var current_window = Lino.current_window;
  if (Lino.login_window == null) {
    
      function do_login() { 
            //~ alert("20130923 do_login() started");
            Lino.viewport.loadMask.show()
            //~ Lino.body_loadMask.show()
            login_panel.getForm().submit({ 
                method:'POST', 
                waitTitle:'Connecting', 
                waitMsg:'Sending data...',
                success:function(){ 
                  //~ console.log('20130923 logged in',arguments);
                  //~ alert("20130923 do_login() success");
                  Lino.login_window.hide();
                  Lino.close_all_windows();
                  Lino.viewport.loadMask.hide();
                  if (typeof on_login == 'string') {
                      //~ console.log("20130829 on_login",on_login);
                      //~ alert("20130923 on_login gonna load_url");
                      Lino.load_url(on_login);
                      //~ eval(on_login);
                  } 
                  //~ else Lino.load_url(/);
                  //~ Lino.body_loadMask.hide();
                },
                failure: function(form,action) { 
                  //~ this.loadMask.hide();
                  //~ alert("20130923 do_login() failure");
                  Lino.on_submit_failure(form,action);
                  Lino.viewport.loadMask.hide()
                  //~ Lino.body_loadMask.hide()
                  //~ if (Lino.current_window) Lino.current_window.main_item.loadMask.hide()
                }
                //~ failure:function(form, action){ 
                    //~ alert_msg
                    //~ if(action.failureType == 'server'){ 
                        //~ obj = Ext.util.JSON.decode(action.response.responseText); 
                        //~ Ext.Msg.alert('Login Failed!', obj.errors.reason); 
                    //~ }else{ 
                        //~ Ext.Msg.alert('Warning!', 'Authentication server is unreachable : ' + action.response.responseText); 
                    //~ } 
                    //~ Lino.login_panel.getForm().reset(); 
                //~ } 
            }); 
      };
    
      var login_button = new Ext.Button({ 
        text:"Log in",
        formBind: true,	 
        // Function that fires when user clicks the button 
        handler: do_login});
    
      var login_panel = new Ext.FormPanel({ 
        //~ inspired by http://www.sencha.com/learn/a-basic-login/
        autoHeight:true,
        labelWidth:90,
        url:'/auth', 
        frame:true, 
        defaultType:'textfield',
        monitorValid:true,
        items:[{ 
            fieldLabel:"Username", 
            id: 'username',
            name:'username', 
            autoHeight:true,
            allowBlank:false 
        },{ 
            fieldLabel:"Password", 
            name:'password', 
            inputType:'password', 
            autoHeight:true,
            allowBlank:false 
        }],        
        buttons:[ login_button ]});
        
      Lino.login_window = new Ext.Window({
          layout:'fit',
          defaultButton: 'username',
          width:300,
          title:"Log in", 
          autoHeight:true,
          modal: true,
          closeAction: "hide",
          keys: {
            key: Ext.EventObject.ENTER,
            fn: function() { do_login()}
          },
          //~ defaultButton: login_button,
          //~ height:'auto',
          //~ closable: false,
          //~ resizable: false,
          //~ plain: true,
          //~ border: false,
          items: [login_panel] });
  };
  Lino.login_window.show();
};

Lino.logout = function(id,name) {
    //~ console.log('20121104 gonna log out',arguments);
    //~ Lino.do_action
    Lino.call_ajax_action(Lino.viewport,'GET',
        '/auth',{},'logout',undefined,undefined,function(){
        //~ console.log('20121104 logged out',arguments);
        //~ Lino.login_window.hide();
        Lino.close_all_windows();
    })
}

Lino.set_subst_user = function(id,name) {
    //~ console.log(20130723,'Lino.set_subst_user',id,name,Lino.current_window,Lino.viewport);
    Lino.subst_user = id;
//~ 
    //~ if(id) {
        //~ Lino.eventStore.setBaseParam("su",id);
    //~ } else {
      //~ delete Lino.eventStore.baseParams['su'];
    //~ }
//~ 
    if (Lino.current_window) 
        Lino.current_window.main_item.set_base_param("su",id);
    if (Lino.viewport) 
        Lino.permalink_handler(Lino.current_window)();
}



//~ Lino.select_subst_user = function(cmp,rec,value){
    //~ Lino.subst_user=value;
    //~ console.log(20120713,rec);
//~ }
    
Lino.current_window = null;
Lino.window_history = Array();
    
Lino.chars2width = function(cols) {  return cols * 9; }
Lino.rows2height = function(cols) {  return cols * 20; }



Lino.MainPanel = {
  is_home_page : false,
  setting_param_values : false,
  config_containing_window : function(wincfg) { }
  ,init_containing_window : function(win) { }
  ,is_loading : function() { 
      if (!this.rendered) return true;
      //~ return (Ext.select('.x-loading-msg').elements.length > 0);
      return true; 
    } 
  ,do_when_clean : function(auto_save,todo) { todo() }
  ,get_master_params : function() {
    var p = {}
    p['mt'] = this.content_type; 
    rec = this.get_current_record()
    if (rec) {
      if (rec.phantom) {
          p['mk'] = undefined; 
      }else{
          p['mk'] = rec.id; 
      }
    } else {
      p['mk'] = undefined;
    }
    //~ console.log('get_master_params returns',p,'using record',rec);
    return p;
  }
  ,get_permalink : function() {
    //~ var p = this.main_item.get_base_params() || {};
    var p = Ext.apply({},this.get_base_params());
    delete p.fmt;
    //~ if (p.fmt) delete p.fmt;
    Ext.apply(p,this.get_permalink_params());
    
    if (this.toggle_params_panel_btn) {
        p.sp = this.toggle_params_panel_btn.pressed;
        //~ if (this.toggle_params_panel_btn.pressed == this.params_panel_hidden) {
          //~ p.sp = true;
        //~ }
    }
    
    //~ Lino.insert_subst_user(p);
     //~ p.fmt = 'html';
    //~ console.log('get_permalink',p,this.get_permalink_params());
    if (this.is_home_page)
        //~ var url = '';
        var url = '/';
    else 
        var url = this.get_permalink_url();
    if (p.su == null) 
        delete p.su;
    if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
    return url;
  }
  ,get_record_url : function(record_id) {
      var url = '/api' + this.ls_url
      //~ var url = this.containing_window.config.url_data; // ls_url;
      url += '/' + (record_id === undefined ? '-99999' : String(record_id));
      //~ if (record_id !== undefined) url += '/' + String(record_id);
      //~ url += '/' + String(record_id);
      return url;
  }
  ,get_permalink_url : function() {
      return '/api' + this.ls_url;
  }
  ,get_permalink_params : function() {
      //~ return {an:'grid'};
      var p = {};
      if (this.action_name)
          p.an = this.action_name;
      this.add_param_values(p,false)
      return p;
  }
  ,set_status : function(status) {}
  ,get_status : function() { return {}}
  ,refresh : function() {}
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,add_params_panel : function (tbar) {
      if (this.params_panel) {
        //~  20130923b
        //~ this.params_panel.autoHeight = true; // 20130924
        var t = this;
        var update = function() {
            var p = t.params_panel;
            //~ console.log("update", p.getSize().height,p.forceLayout,p.autoHeight);
            var w = t.get_containing_window();
            Lino.do_when_visible(w, function() {
                //~ p.doLayout(true); // doLayout(shallow, force)
                w.doLayout(true); // doLayout(shallow, force)
                //~ t.params_panel.on('afterlayout',update,t,{single:true});
            });
        };
        Lino.do_when_visible(this.params_panel, update);
        this.params_panel.on('show',update);
        this.params_panel.on('hide',update);
        //~ this.params_panel.on('bodyresize',update);
        this.params_panel.on('afterlayout',update);
        //~ this.params_panel.on('afterlayout',update,this,{single:true});
        //~ this.params_panel.on('bodyresize',update,this,{single:true});
        //~ this.params_panel.on('resize',update,this,{single:true});
        //~ this.params_panel.on('render',update,this,{single:true});
        
        // this.params_panel.on('render',
        //~ this.params_panel.on('afterlayout',update,this,{single:true,delay:200});
        //~ this.params_panel.on('bodyresize',update,this,{single:true,delay:200});
        this.toggle_params_panel_btn = new Ext.Button({ scope:this, 
          //~ text: "$_("[parameters]")", // gear
          iconCls: 'x-tbar-parameters',
          tooltip:"Show or hide the table parameters panel",
          enableToggle: true,
          //~ pressed: ! this.params_panel.hidden,
          pressed: ! this.params_panel_hidden,
          toggleHandler: function(btn,state) { 
            //~ console.log("20120210 add_params_panel",state,this.params_panel);
            if (state) {
                this.params_panel.show();
            } else {
                this.params_panel.hide();
            }
            //~ this.params_panel.on('afterlayout',update,this,{single:true});
            //~ t.get_containing_window().doLayout();
            //~ this.params_panel.on('afterlayout',function() {
                //~ console.log("20130918 afterlayout");
                //~ t.get_containing_window().doLayout(); // doLayout(shallow, force)
            //~ },this,{single:true});
          }
        }); 
        tbar = tbar.concat([this.toggle_params_panel_btn]);
        var refresh = function() {
            if (!t.setting_param_values) {
                t._force_dirty = true; 
                t.refresh();
            }
        }
        Ext.each(this.params_panel.fields,function(f) {
          //~ f.on('valid',function() {t.refresh()});
          if (f instanceof Ext.form.Checkbox) {
              f.on('check',refresh);
          } else if (f instanceof Ext.DatePicker) {
              f.on('select',refresh);
          } else if (f instanceof Ext.form.TriggerField) {
              f.on('select',refresh);
              //~ f.on('change',refresh);
              //~ f.on('valid',refresh);
          } else {
              if (! f.on) 
                  console.log("20121010 no method 'on'",f);
              else
                  f.on('change',refresh);
            }
          });
      }
      return tbar;
  }
  ,add_param_values : function (p,force_dirty) {
    if (this.params_panel) {
      /* 
      * 20120918 add param_values to the request string 
      * *only if the params_form is dirty*.
      * Otherwise Actor.default_params() would never be used.
      *
      * 20121023 But IntegClients.params_default has non-empty default values. 
      * Users must have the possibility to make them empty.
      * 
      * 20130605 : added `force_dirty` parameter because Checkbox fields don't 
      * mark their form as dirty when check is fired.
      * 
      * 20130721 : `force_dirty` not as a parameter but as 
      * `this._force_dirty` because
      * 
      * 20130915 : both _force_dirty and force_dirty parameter are needed.
      * 
      */
      if (force_dirty || this._force_dirty || this.params_panel.form.isDirty()) {
      //~ if (this._force_dirty || this.params_panel.form.isDirty()) {
        p.pv = this.get_param_values();
        //~ console.log("20130923 form is dirty (",force_dirty,this._force_dirty,this.params_panel.form.isDirty(),")");
        //~ console.log("20130923 form is dirty",p);
      }else{
        //~ console.log("20130923 form not dirty:",this.params_panel.form);
        if (this.status_param_values) 
          p.pv = Lino.fields2array(
            this.params_panel.fields,this.status_param_values);
      }
      //~ if (!this.params_panel.form.isDirty()) return;
      //~ p.pv = this.get_param_values();
      //~ console.log("20120203 add_param_values added pv",p.pv,"to",p);
    }
  },
  get_param_values : function() { // similar to get_field_values()
      return Lino.fields2array(this.params_panel.fields);
  },
  set_param_values : function(pv) {
    if (this.params_panel) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_param_values = pv;
      //~ this.params_panel.form.suspendEvents(false);
      this.setting_param_values = true;
      if (pv) { 
          this.params_panel.form.my_loadRecord(pv);
      } else { 
        this.params_panel.form.reset(); 
      }
      this.setting_param_values = false;
      this._force_dirty = false; 
      //~ this.params_panel.form.resumeEvents();
    }
  }
};




Lino.Viewport = Ext.extend(Ext.Viewport,Lino.MainPanel);
Lino.Viewport = Ext.extend(Lino.Viewport,{
  layout : "fit"
  ,is_home_page : true
  ,initComponent : function(){
    Lino.Viewport.superclass.initComponent.call(this);
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.el,{msg:"Please wait..."});
      //~ console.log("20121118 Lino.viewport.loadMask",this.loadMask);
    },this);
  }
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,refresh : function() {
      var caller = this;
      //~ console.log("20121120 Lino.Viewport.refresh()");
      if (caller.loadMask) caller.loadMask.show();
      var success = function(response) {
        if (caller.loadMask) caller.loadMask.hide();
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          //~ console.log('Lino.do_action()',action.name,'result is',result);
          if (result.html) {
              Ext.getCmp('main_area').update(result.html);
          }
          if (result.message) {
              if (result.alert) {
                  //~ Ext.MessageBox.alert('Alert',result.alert_msg);
                  Ext.MessageBox.alert('Alert',result.message);
              } else {
                  Lino.notify(result.message);
              }
          }
          
          if (result.notify_msg) Lino.notify(result.notify_msg);
          if (result.js_code) { 
            var jsr = result.js_code(caller);
            //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
          };
        }
      };
      var action = {
        url : '/api/main_html',
        waitMsg: "Please wait...",
        failure: Lino.ajax_error_handler(caller),
        success: success,
        method: 'GET',
        params: {}
      };
      Lino.insert_subst_user(action.params);
      Ext.Ajax.request(action);
    
  }
});




Lino.open_window = function(win,st,requesting_panel) {
  //~ console.log("20120918 Lino.open_window()",win,st);
  var cw = Lino.current_window;
  if (cw) {
    //~ console.log("20120918 Lino.open_window() save current status",cw.main_item.get_status());
    Lino.window_history.push({
      window:cw,
      status:cw.main_item.get_status()
    });
  }
  Lino.current_window = win;
  //~ if (st.su) 
      //~ Lino.subst_user_field.setValue(st.su);
  win.main_item.set_status(st,requesting_panel);
  win.show();
};

Lino.load_url = function(url) {
    //~ foo.bar.baz = 2; 
    //~ console.log("20121120 Lino.load_url()");
    //~ Lino.body_loadMask.show();
    Lino.viewport.loadMask.show();
    //~ location.replace(url);
    document.location = url;
}

Lino.close_window = function(status_update) {
  var cw = Lino.current_window;
  var ww = Lino.window_history.pop();
  if (ww) {
    //~ if (status_update) Ext.apply(ww.status,status_update);
    if (status_update) status_update(ww);
    ww.window.main_item.set_status(ww.status);
    Lino.current_window = ww.window;
  } else {
    Lino.current_window = null;
  }
  if (cw) cw.hide_really();
};

Lino.close_all_windows = function() {
  if (Lino.window_history.length == 0) {
      //~ Lino.viewport.refresh();
      var url =  "/"
      //~ console.log("20121120 Lino.close_all_windows() : no window_history");
      //~ if (ADMIN_URL) 
      var p = {};
      Lino.insert_subst_user(p)
      if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
      Lino.load_url(url);
  } else {
    //~ console.log("20121120 Lino.close_all_windows() with window_history");
    while (Lino.window_history.length > 0) {
      Lino.close_window();
      //~ Lino.window_history.pop().hide_really();
    }
  }
  //~ Lino.current_window = null;
  //~ Lino.close_window();
  //~ var ww = 
}

Lino.kill_current_window = function() {
  var cw = Lino.current_window;
  Lino.current_window = null;
  if (cw) cw.hide_really();
};

Lino.calling_window = function() {
    if (Lino.window_history.length) return Lino.window_history[Lino.window_history.length-1];
}

//~ Lino.WindowAction = function(mainItemClass,windowConfig,mainConfig,ppf) {
Lino.WindowAction = function(windowConfig,main_item_fn) {
    //~ if(!mainConfig) mainConfig = {};
    //~ mainConfig.is_main_window = true;
    this.windowConfig = windowConfig;
    this.main_item_fn = main_item_fn;
    //~ if (ppf) mainConfig.params_panel.fields = ppf;
    //~ this.mainConfig = mainConfig;
    //~ this.mainItemClass = mainItemClass;
};

Lino.WindowAction = Ext.extend(Lino.WindowAction,{
    window : null,
    //~ mainItemClass: null,
    get_window : function() {
      //~ if(mainConfig) Ext.apply(this.mainConfig,mainConfig);
      if (this.window == null)  {
          //~ this.windowConfig.main_item = new this.mainItemClass(this.mainConfig);
          this.windowConfig.main_item = this.main_item_fn();
          this.window = new Lino.Window(this.windowConfig);
      }
      return this.window;
    },
    run : function(requesting_panel,status) {
      //~ console.log('20120625 window_action.run()',this)
      Lino.open_window(this.get_window(),status,requesting_panel);
    }
  
});


Lino.PanelMixin = {
  get_containing_window : function (){
      if (this.containing_window) return this.containing_window;
      return this.containing_panel.get_containing_window();
  }
  ,set_window_title : function(title) {
    //~ this.setTitle(title);
    var cw = this.get_containing_window();

    //~ if (cw) {
    //~ if (cw && cw.closable) {
    if (cw && !cw.main_item.hide_window_title) {
      //~ console.log('20111202 set_window_title(',title,') for',this.containing_window);
      //~ if (! this.containing_window.rendered) console.log("WARNING: not rendered!");
      cw.setTitle(title);
    //~ } else {
      //~ document.title = title;
    }
    //~ else console.log('20111202 not set_window_title(',title,') for',this);
  }
  
};


// Lino.status_bar = new Ext.ux.StatusBar({defaultText:'Lino version 1.6.12.'});
Lino.status_bar = new Ext.ux.StatusBar({
    autoClear: 10000, // 10 seconds
    defaultText:'None.'
    });



Lino.edit_tinymce_text = function(panel,options) {
  // `panel` is the RichTextPanel
  //~ console.log(20111220,panel);
  //~ var rec = panel.get_current_record();
  var rec = panel.containing_panel.get_current_record();
  var value = rec ? rec.data[panel.editor.name] : '';
  var saving = false;
  var todo_after_save = false;
  var discard_changes = false;
  
  
  function save() {
    //~ if (todo_after_save) {alert('tried to save again'); return; }
    if (saving) {alert('tried to save again'); return; }
    //~ var url = panel.containing_window.main_item.get_record_url(rec.id);
    var url = panel.containing_panel.get_record_url(rec.id);
    var params = Ext.apply({},panel.containing_panel.get_base_params());
    params[panel.editor.name] = editor.getValue();
    //~ params.su = Lino.subst_user;
    //~ Lino.insert_subst_user(params);
    var a = { 
      params: params, 
      method: 'PUT',
      url: url,
      failure: function() {
          //~ if (editor.ed.getContainer()) 
          editor.ed.setProgressState(0);
          todo_after_save = false;
          saving = false;
          console.log('tinymce.save() failed. sorry.',arguments);
        },
      success: function() {
        saving = false;
        //~ if (editor.ed.getContainer()) 
        editor.ed.setProgressState(0);
        rec.data[panel.editor.name] = editor.getValue();
        if(todo_after_save) {
            var fn = todo_after_save;
            todo_after_save = false;
            fn();
        }
        //~ panel.containing_window.set_current_record(rec);
        panel.refresh();
      }
    };
    //~ if (editor.ed.getContainer()) 
    editor.ed.setProgressState(1); // Show progress
    saving = true;
    //~ console.log(a);
    Ext.Ajax.request(a);
  };
  function save_callback() {
      save();
      //~ save(function(){editor.ed.setDirty(false);})
      /* return true have the save button disabled.  
      That's not perfect because the PUT is asynchronous 
      and the response is not yet known.
      */
      return true;
  }
  //~ var actions = [
    //~ {text:"Save",handler:save}
  //~ ]; 
  //~ console.log(20110610,panel.editor.disabled);
  var settings = {};
  Ext.apply(settings,{
        readonly: panel.editor.disabled,
        //~ language: "de",
        plugins : "save,emotions,spellchecker,advhr,insertdatetime,preview,table,searchreplace,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "save,cancel,|,bold,italic,underline,|,justifyleft,justifycenter,justifyright,fontselect,fontsizeselect,formatselect,|,search,replace",
        theme_advanced_buttons2 : "cut,copy,paste,template,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,link,unlink,anchor,image,|,code,preview,|,forecolor,backcolor",
        theme_advanced_buttons3 : "insertdate,inserttime,|,spellchecker,advhr,,removeformat,|,sub,sup,|,charmap,emotions,|,tablecontrols",      
        theme_advanced_resizing : false,
        convert_urls : false,
        save_onsavecallback : save_callback,
        save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
  });
  Ext.apply(settings,options);
  var editor = new Ext.ux.TinyMCE({
      value : value,
      tinymceSettings: settings
    });
  var win = new Ext.Window({
    title: rec.title, 
    //~ bbar: actions,
    layout: 'fit',
    items: editor,
    width: 600, 
    height:500,
    minWidth: 100,
		minHeight: 100,
    modal: true,
    resizable: true,
    maximizable: true,
    //~ maximized: true,
    //~ closeAction: "close"
    closeAction: "hide"
    //~ hideMode: "offsets",
    //~ constrainHeader: true,
    //~ bodyStyle: 'padding: 10px'
  });

  //~ win.on('beforeclose',function() {
  win.on('beforehide',function() {
    if (todo_after_save) return false;
    if (discard_changes) return true;
    if (editor.isDirty()) {
        //~ var ok = false;
        //~ var allowClose = true;
        var config = {title:"Confirmation"};
        config.buttons = Ext.MessageBox.YESNOCANCEL;
        config.msg = "Save changes to text ?";
        config.modal = true;
        config.fn = function(buttonId,text,opt) {
          //~ console.log('do_when_clean',buttonId)
          if (buttonId == "yes") {
              /* we cancel this close, but save()'s onSuccess will call again.*/
              //~ allowClose = false;
              todo_after_save = function(){win.hide();}
              editor.ed.execCommand('mceSave');
              //~ editor.ed.save(function(){win.close();});
          } else if (buttonId == "no") { 
              discard_changes = true;
              win.hide()
          //~ } else if (buttonId == "cancel") { 
            //~ ok = true;
              //~ allowClose = false;
          //~ } else { 
            //~ console.log('unknwon buttonId:',buttonId);
          }
        }
        Ext.MessageBox.show(config);
        return false;
        //~ return allowClose;
    }
  });
  win.show();
}







/* 
  Originally copied from Ext JS Library 3.3.1
  Modifications by Luc Saffre : 
  - rendering of phantom records
  - fire afteredit event
  - react on dblclcik, not on single click

 */
Lino.CheckColumn = Ext.extend(Ext.grid.Column, {

    processEvent : function(name, e, grid, rowIndex, colIndex){
        //~ console.log('20110713 Lino.CheckColumn.processEvent',name)
        if (name == 'click') {
        //~ if (name == 'mousedown') {
        //~ if (name == 'dblclick') {
            return this.toggleValue(grid, rowIndex, colIndex);
        } else {
            return Ext.grid.ActionColumn.superclass.processEvent.apply(this, arguments);
        }
    },
    
    toggleValue : function (grid,rowIndex,colIndex) {
        var record = grid.store.getAt(rowIndex);
        var dataIndex = grid.colModel.getDataIndex(colIndex);
        // 20120514
        //~ if(record.data.disabled_fields && record.data.disabled_fields[dataIndex]) {
          //~ Lino.notify("This field is disabled");
          //~ return false;
        //~ }
      
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("This field is disabled.");
            //~ return false;
        //~ }
        var startValue = record.data[dataIndex];
        var value = !startValue;
        //~ record.set(this.dataIndex, value);
        var e = {
            grid: grid,
            record: record,
            field: dataIndex,
            originalValue: startValue,
            value: value,
            row: rowIndex,
            column: colIndex,
            cancel: false
        };
        if(grid.fireEvent("beforeedit", e) !== false && !e.cancel){
        //~ if(grid.fireEvent("validateedit", e) !== false && !e.cancel){
            record.set(dataIndex, value);
            delete e.cancel;
            grid.fireEvent("afteredit", e);
        }
        return false; // Cancel event propagation
    },

    renderer : function(v, p, record){
        if (record.phantom) return '';
        p.css += ' x-grid3-check-col-td'; 
        return String.format('<div class="x-grid3-check-col{0}">&#160;</div>', v ? '-on' : '');
    }

    // Deprecate use as a plugin. Remove in 4.0
    // init: Ext.emptyFn
});

// register ptype. Deprecate. Remove in 4.0
// Ext.preg('checkcolumn', Lino.CheckColumn);

// backwards compat. Remove in 4.0
// Ext.grid.CheckColumn = Lino.CheckColumn;

// register Column xtype
Ext.grid.Column.types.checkcolumn = Lino.CheckColumn;


/* 20110725 : 
Lino.on_tab_activate is necessary 
in contacts.Person.2.dtl 
(but don't ask me why...)
*/
Lino.on_tab_activate = function(item) {
  //~ console.log('activate',item); 
  if (item.rendered && item.doLayout) item.doLayout();
  //~ if (item.rendered) item.doLayout();
}

Lino.TimeField = Ext.extend(Ext.form.TimeField,{
  format: 'H:i',
  increment: 15
  });
Lino.DateField = Ext.extend(Ext.form.DateField,{
  boxMinWidth: Lino.chars2width(15), // 20131005 changed from 11 to 15
  format: 'd.m.Y',
  altFormats: 'd/m/Y|Y-m-d'
  });
Lino.DatePickerField = Ext.extend(Ext.DatePicker,{
  //~ boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  //~ altFormats: 'd/m/Y|Y-m-d'
  formatDate : function(date){
      //~ console.log("20121203 formatDate",this.name,date);
      return Ext.isDate(date) ? date.dateFormat(this.format) : date;
  }
  });
Lino.DateTimeField = Ext.extend(Ext.ux.form.DateTime,{
  dateFormat: 'd.m.Y',
  timeFormat: 'H:i'
  //~ ,hiddenFormat: 'd.m.Y H:i'
  });
Lino.URLField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  //~ triggerClass : 'x-form-world-trigger',
  vtype: 'url',
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    window.open(this.getValue(),'_blank');
  }
});
Lino.IncompleteDateField = Ext.extend(Ext.form.TextField,{
  //~ regex: /^-?\d+-[01]\d-[0123]\d$/,
  //~ regex: /^[0123]\d\.[01]\d\.-?\d+$/,
  maxLength: 10,
  boxMinWidth: Lino.chars2width(10),
  regex: /^[0123]?\d\.[01]?\d\.-?\d+$/,
  regexText: 'Enter a date in format YYYY-MM-DD (use zeroes for unknown parts).'
  });


//~ Lino.make_dropzone = function(cmp) {
    //~ cmp.on('render', function(ct, position){
      //~ ct.el.on({
        //~ dragenter:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ return true;
        //~ }
        //~ ,dragover:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ event.stopEvent();
          //~ return true;
        //~ }
        //~ ,drop:{
          //~ scope:this
          //~ ,fn:function(event){
            //~ event.stopEvent();
            //~ console.log(20110516);
            //~ var files = event.browserEvent.dataTransfer.files;
            //~ if(files === undefined){
              //~ return true;
            //~ }
            //~ var len = files.length;
            //~ while(--len >= 0){
              //~ console.log(files[len]);
              //~ // this.processDragAndDropFileUpload(files[len]);
            //~ }
          //~ }
        //~ }
      //~ });
    //~ });
//~ };

//~ Lino.FileUploadField = Ext.ux.form.FileUploadField;

Lino.FileUploadField = Ext.extend(Ext.ux.form.FileUploadField,{
    onRender : function(ct, position){
      Lino.FileUploadField.superclass.onRender.call(this, ct, position);
      this.el.on({
        dragenter:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          return true;
        }
        ,dragover:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          event.stopEvent();
          return true;
        }
        ,drop:{
          scope:this
          ,fn:function(event){
            event.stopEvent();
            //~ console.log(20110516);
            var files = event.browserEvent.dataTransfer.files;
            if(files === undefined){
              return true;
            }
            var len = files.length;
            while(--len >= 0){
              console.log(files[len]);
              //~ this.processDragAndDropFileUpload(files[len]);
            }
          }
        }
      });
    }
});

Lino.FileField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  editable: false,
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    if (this.getValue()) window.open(MEDIA_URL + '/'+this.getValue(),'_blank');
  }
});

Lino.file_field_handler = function(panel,config) {
  //~ if (instanceof Lino.DetailWrapper) {
  if (panel.action_name == 'insert') {
  //~ if (panel.get_current_record().phantom) {
      panel.has_file_upload = true;

      var f = new Lino.FileUploadField(config);
      //~ Lino.make_dropzone(f);
      return f;
      //~ return new Ext.ux.form.FileUploadField(config);
      //~ return new Lino.FileField(config);
      
  } else {
      //~ return new Lino.URLField(config);
      return new Lino.FileField(config);
  }
}

Lino.VBorderPanel = Ext.extend(Ext.Panel,{
    constructor : function(config) {
      config.layout = 'border';
      delete config.layoutConfig;
      Lino.VBorderPanel.superclass.constructor.call(this,config);
      for(var i=0; i < this.items.length;i++) {
        var item = this.items.get(i);
        if (this.isVertical(item) && item.collapsible) {
          item.on('collapse',this.onBodyResize,this);
          item.on('expand',this.onBodyResize,this);
        }
      }
    },
    isVertical : function(item) {
       return (item.region == 'north' || item.region == 'south' || item.region == 'center');
    },
    onBodyResize: function(w, h){
        //~ console.log('VBorderPanel.onBodyResize',this.title)
      if (this.isVisible()) { // to avoid "Uncaught TypeError: Cannot call method 'getHeight' of undefined."
        var sumflex = 0;
        var availableHeight = this.getInnerHeight();
        var me = this;
        this.items.each(function(item){
          if (me.isVertical(item)) {
              if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  if (item.rendered) availableHeight -= item.getHeight();
              } else {
                  sumflex += item.flex;
              }
          } 
          
        });
        //~ for(var i=0; i < this.items.length;i++) {
          //~ var item = this.items.get(i);
          //~ // if (this.isVertical(item) && item.getResizeEl()) {
          //~ if (this.isVertical(item)) {
              //~ if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  //~ // item.syncSize()
                  //~ // item.doLayout()
                  //~ // if (item.region == "north") console.log('region north',item.getHeight(),item.id, item);
                  //~ // if (item.getHeight() == 0) console.log(20100921,'both flex and getHeight() are 0!');
                  //~ availableHeight -= item.getHeight();
              //~ } else {
                  //~ sumflex += item.flex;
                  //~ // console.log(item.flex);
              //~ }
          //~ } 
          //~ // else console.log('non-vertical item in VBoderPanel:',item)
        //~ }
        var hunit = availableHeight / sumflex;
        //~ console.log('sumflex=',sumflex,'hunit=',hunit, 'availableHeight=',availableHeight);
        for(var i=0; i < this.items.length;i++) {
          var item = this.items.get(i);
          if (this.isVertical(item)) {
              if (item.flex != 0 && ! item.collapsed) {
                  item.setHeight(hunit * item.flex);
                  //~ console.log(item.region,' : height set to',item.getHeight());
              }
          }
          //~ else console.log('non-vertical item in VBoderPanel:',item)
        }
      }
      Lino.VBorderPanel.superclass.onBodyResize.call(this, w, h);
    }
});


/*
  modifications to the standard behaviour of a CellSelectionModel:
  
*/
Ext.override(Ext.grid.CellSelectionModel, {
//~ var dummy = {

    handleKeyDown : function(e){
        /* removed because F2 wouldn't pass
        if(!e.isNavKeyPress()){
            return;
        }
        */
        //~ console.log('handleKeyDown',e)
        var k = e.getKey(),
            g = this.grid,
            s = this.selection,
            sm = this,
            walk = function(row, col, step){
                return g.walkCells(
                    row,
                    col,
                    step,
                    g.isEditor && g.editing ? sm.acceptsNav : sm.isSelectable, 
                    sm
                );
            },
            cell, newCell, r, c, ae;

        switch(k){
            case e.ESC:
            case e.PAGE_UP:
            case e.PAGE_DOWN:
                break;
            default:
                // e.stopEvent(); // removed because Browser keys like Alt-Home, Ctrl-R wouldn't work
                break;
        }

        if(!s){
            cell = walk(0, 0, 1); 
            if(cell){
                this.select(cell[0], cell[1]);
            }
            return;
        }

        cell = s.cell;  
        r = cell[0];    
        c = cell[1];    
        
        switch(k){
            case e.TAB:
                if(e.shiftKey){
                    newCell = walk(r, c - 1, -1);
                }else{
                    newCell = walk(r, c + 1, 1);
                }
                break;
            case e.HOME:
                if (! (g.isEditor && g.editing)) {
                  if (!e.hasModifier()){
                      newCell = [r, 0];
                      //~ console.log('home',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
                      if (activePage > 1) {
                          e.stopEvent();
                          t.moveFirst();
                          return;
                      }
                      newCell = [0, c];
                      break;
                  }
                }
            case e.END:
                if (! (g.isEditor && g.editing)) {
                  c = g.colModel.getColumnCount()-1;
                  if (!e.hasModifier()) {
                      newCell = [r, c];
                      //~ console.log('end',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var d = t.getPageData();
                      if (d.activePage < d.pages) {
                          e.stopEvent();
                          var self = this;
                          t.on('change',function(tb,pageData) {
                              var r = g.store.getCount()-2;
                              self.select(r, c);
                              //~ console.log('change',r,c);
                          },this,{single:true});
                          t.moveLast();
                          return;
                      } else {
                          newCell = [g.store.getCount()-1, c];
                          //~ console.log('ctrl-end',newCell);
                          break;
                      }
                  }
                }
            case e.DOWN:
                newCell = walk(r + 1, c, 1);
                break;
            case e.UP:
                newCell = walk(r - 1, c, -1);
                break;
            case e.RIGHT:
                newCell = walk(r, c + 1, 1);
                break;
            case e.LEFT:
                newCell = walk(r, c - 1, -1);
                break;
            case e.F2:
                if (!e.hasModifier()) {
                    if (g.isEditor && !g.editing) {
                        g.startEditing(r, c);
                        e.stopEvent();
                        return;
                    }
                    break;
                }
            case e.INSERT:
                if (!e.hasModifier()) {
                    if (g.ls_insert_handler && !g.editing) {
                        e.stopEvent();
                        Lino.show_insert(g);
                        return;
                    }
                    break;
                }
            case e.DELETE:
                if (!e.hasModifier()) {
                    if (!g.editing) {
                        e.stopEvent();
                        Lino.delete_selected(g);
                        return;
                    }
                    break;
                }
            case e.ENTER:
                e.stopEvent();
                g.onCellDblClick(r,c);
                break;
                
        }
        

        if(newCell){
          e.stopEvent();
          r = newCell[0];
          c = newCell[1];
          this.select(r, c); 
          if(g.isEditor && g.editing){ 
            ae = g.activeEditor;
            if(ae && ae.field.triggerBlur){
                ae.field.triggerBlur();
            }
            g.startEditing(r, c);
          }
        //~ } else if (g.isEditor && !g.editing && e.charCode) {
        //~ // } else if (!e.isSpecialKey() && g.isEditor && !g.editing) {
            //~ g.set_start_value(String.fromCharCode(e.charCode));
            //~ // g.set_start_value(String.fromCharCode(k));
            //~ // g.set_start_value(e.charCode);
            //~ g.startEditing(r, c);
            //~ // e.stopEvent();
            //~ return;
        // } else {
          // console.log('20120513',e,g);
        }
        
    }


//~ };
});

 

function PseudoConsole() {
    this.log = function() {};
};
if (typeof(console) == 'undefined') console = new PseudoConsole();

Lino.notify = function(msg) {
  if (msg == undefined) msg = ''; else console.log(msg);
  //~ Ext.getCmp('konsole').update(msg);
  Lino.status_bar.setStatus({
    text: msg,
    iconCls: 'ok-icon',
    clear: true // auto-clear after a set interval
  });
  //~ Ext.getCmp('konsole').setTitle(msg.replace(/\n/g,'<br/>'));
  //~ Ext.getCmp('konsole').update(msg.replace(/\n/g,'<br/>'));
};
Lino.alert = function(msg) {
  //~ if (msg == undefined) msg = ''; else console.log(msg);
  Ext.MessageBox.alert('Notify',msg);
};


//~ Lino.show_about = function() {
  //~ new Ext.Window({
    //~ width: 400, height: 400,
    //~ title: "About",
    //~ html: '<a href="http://www.extjs.com" target="_blank">ExtJS</a> version ' + Ext.version
  //~ }).show();
//~ };

function obj2str(o) {
  if (typeof o != 'object') return String(o);
  var s = '';
  for (var p in o) {
    s += p + ': ' + obj2str(o[p]) + '\n';
  }
  return s;
}

Lino.on_store_exception = function (store,type,action,options,response,arg) {
  //~ throw response;
  console.log("on_store_exception: store=",store,
    "type=",type,
    "action=",action,
    "options=",options,
    "response=",response,
    "arg=",arg);
  if (arg) { console.log(arg.stack)};
};

//~ Lino.on_submit_success = function(form, action) {
   //~ Lino.notify(action.result.message);
   //~ this.close();
//~ };

Lino.on_submit_failure = function(form, action) {
    //~ Lino.notify();
  // action may be undefined
    switch (action.failureType) {
        case Ext.form.Action.CLIENT_INVALID:
            Ext.Msg.alert('Client-side failure', 'Form fields may not be submitted with invalid values');
            break;
        case Ext.form.Action.CONNECT_FAILURE:
            Ext.Msg.alert('Connection failure', 'Ajax communication failed');
            break;
        case Ext.form.Action.SERVER_INVALID:
            Ext.Msg.alert('Server-side failure', action.result.message);
   }
};



/*
Lino.save_wc_handler = function(ww) {
  return function(event,toolEl,panel,tc) {
    var pos = panel.getPosition();
    var size = panel.getSize();
    wc = ww.get_window_config();
    Ext.applyIf(wc,{ 
      x:pos[0],y:pos[1],height:size.height,width:size.width,
      maximized:panel.maximized});
    Lino.do_action(ww,{url:'/window_configs/'+ww.config.permalink_name,params:wc,method:'POST'});
  }
};

*/

Lino.show_in_own_window_button = function(handler) {
  return {
    qtip: "Show this panel in own window", 
    id: "up",
    handler: function(event,toolEl,panel, tc) {
      //~ console.log('20111206 report_window_button',panel,handler);
      handler.run(null,{base_params:panel.containing_panel.get_master_params()});
    }
  }
}




Lino.delete_selected = function(panel) {
  //~ console.log("Lino.delete_selected",panel);
  var recs1 = panel.get_selected();
  var recs = [];
  for ( var i=0; i < recs1.length; i++ ) { if (! recs1[i].phantom) recs.push(recs1[i]); }
  if (recs.length == 0) {
    Lino.notify("Please select at least one record.");
    return;
  };
  if (recs.length == 1) {
      if (recs[0].disable_delete) {
        Lino.alert(recs[0].disable_delete);
        return;
      }
  };
  //~ console.log(recs);
  Ext.MessageBox.show({
    title: "Confirmation",
    msg: String.format("Delete {0} rows. Are you sure?",String(recs.length)),
    //~ msg: "Delete " + String(recs.length) + " rows. Are you sure?",
    //~ buttons: Ext.MessageBox.YESNOCANCEL,
    buttons: Ext.MessageBox.YESNO,
    fn: function(btn) {
      if (btn == 'yes') {
        for ( var i=0; i < recs.length; i++ ) {
          Lino.do_action(panel,{
              method:'DELETE',
              url:  '/api' + panel.ls_url + '/' + recs[i].id,
              after_success: panel.after_delete.createDelegate(panel)
          })
        }
        //~ caller.after_delete();
      }
      else Lino.notify("Dann eben nicht.");
    }
  });
};

Lino.action_handler = function (panel,on_success,on_confirm) {
  return function (response) {
    //~ console.log(20120608,panel);
    if (panel instanceof Lino.GridPanel) {
        //~ gridmode = false;
        gridmode = true;
        //~ console.log('20120608 yes');
    } else {
        gridmode = false;
        //~ console.log('20120608 no');
    }
    if (panel.loadMask) panel.loadMask.hide(); // 20120211
    if (!response.responseText) return ;
    var result = Ext.decode(response.responseText);
    //~ console.log('Lino.action_handler()','result is',result,'on_confirm is',on_confirm);
    
    if (result.eval_js) {
        //~ console.log(20120618,result.eval_js);
        eval(result.eval_js);
    }
    
    //~ if (result.goto_record) {
        //~ var js = "Lino." + result.goto_record[0] + '.detail.run';
        //~ var h = eval(js);
        //~ h(panel,{record_id:result.goto_record[1]});
    //~ }
    
    if (result.xcallback) {
        //~ var config = {title:"Confirmation"};
        var config = {title:result.xcallback.title};
        //~ config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        config.buttons = result.xcallback.buttons;
        config.msg = result.message;
        config.fn = function(buttonId,text,opt) {
          panel.loadMask.show(); 
          //~ Lino.insert_subst_user(p);
          Ext.Ajax.request({
            method: 'GET',
            url: '/callbacks/'+result.xcallback.id + '/' + buttonId,
            //~ params: {bi: buttonId},
            success: Lino.action_handler(panel,on_success,on_confirm)
          });
          //~ Lino.call_ajax_action(panel,'GET',)
        }
        Ext.MessageBox.show(config);
        return;
    }
    
    if (on_success && result.success) on_success(result);
    
    //~ if (on_confirm && result.confirm_message) {
        //~ var config = {title:"Confirmation"};
        //~ // config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        //~ config.msg = result.confirm_message;
        //~ config.fn = function(buttonId,text,opt) {
          //~ if (buttonId == "yes") {
              //~ on_confirm(panel,undefined,result.step);
          //~ }
        //~ }
        //~ Ext.MessageBox.show(config);
        //~ return;
    //~ }
    //~ if (result.dialog_fn) {
        //~ console.log('20120928 TODO',result.dialog_fn);
    //~ }
    if (result.data_record && ! gridmode) {
        //~ not used
        panel.set_status({data_record:result.data_record});
    }  else if (result.new_status && ! gridmode) {
        //~ not used
        //~ console.log('20120607 new_status');
        panel.set_status(result.new_status);
    } else if (result.goto_record_id != undefined && ! gridmode) {
        //~ Uncaught TypeError: Cannot call method 'run' of undefined 
        panel.load_record_id(result.goto_record_id);
    } 
    
    if (result.message) {
        //~ if (result.alert && ! gridmode) {
        if (result.alert) { // 20120628b 
            //~ Ext.MessageBox.alert('Alert',result.alert_msg);
            if (result.alert === true) result.alert = "Alert";
            Ext.MessageBox.alert(result.alert,result.message);
        } else {
            Lino.notify(result.message);
        }
    }
     
    if (result.close_window) {
        Lino.close_window();
    }
    
    if (result.refresh_all) {
        var cw = panel.get_containing_window();
        //~ console.log("20120123 refresh_all");
        if (cw) {
          cw.main_item.refresh();
        }
        //~ else console.log("20120123 cannot refresh_all",panel);
    } else {
        //~ console.log("20121212 b gonna refresh",panel);
        if (result.refresh) panel.refresh();
    }
    
    if (result.open_url) {
        //~ console.log(20111126,result.open_url);
        //~ if (!result.message)
            //~ Lino.notify('Open new window <a href="'+result.open_url+'" target="_blank">'+result.open_url+'</a>');
        window.open(result.open_url,'foo',"");
        //~ document.location = result.open_url;
    }
  }
};

Lino.do_action = function(caller,action) {
  action.success = function(response) {
    if (caller.loadMask) caller.loadMask.hide();
    //~ console.log('Lino.do_action()',action,'action success',response);
    if (action.after_success) {
        //~ console.log('Lino.do_action() calling after_success');
        action.after_success();
    }
    if (response.responseText) {
      var result = Ext.decode(response.responseText);
      //~ console.log('Lino.do_action()',action.name,'result is',result);
      if (result.message) {
          if (result.alert) {
              //~ Ext.MessageBox.alert('Alert',result.alert_msg);
              Ext.MessageBox.alert('Alert',result.message);
          } else {
              Lino.notify(result.message);
          }
      }
      
      //~ if (result.alert_msg) Ext.MessageBox.alert('Alert',result.alert_msg);
      //~ if (result.message) Lino.notify(result.message);
      if (result.notify_msg) Lino.notify(result.notify_msg);
      if (result.js_code) { 
        //~ console.log('Lino.do_action()',action,'gonna call js_code in',result);
        var jsr = result.js_code(caller);
        //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
        if (action.after_js_code) {
          //~ console.log('Lino.do_action()',action,'gonna call after_js_code');
          action.after_js_code(jsr);
          //~ console.log('Lino.do_action()',action,'returned from after_js_code');
        //~ } else {
          //~ console.log('Lino.do_action()',action,' : after_js_code is false');
        }
      };
    }
  };
  Ext.applyIf(action,{
    waitMsg: "Please wait...",
    failure: Lino.ajax_error_handler(caller),
    params: {}
  });
  //~ action.params.su = Lino.subst_user;
  Lino.insert_subst_user(action.params);
  
  Ext.Ajax.request(action);
};

//~ Lino.gup = function( name )
//~ {
  //~ // Thanks to http://www.netlobo.com/url_query_string_javascript.html
  //~ name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
  //~ var regexS = "[\\?&]"+name+"=([^&#]*)";
  //~ var regex = new RegExp( regexS );
  //~ var results = regex.exec( window.location.href );
  //~ if( results == null )
    //~ return "";
  //~ else
    //~ return results[1];
//~ };

//~ Lino.refresh_handler = function (ww) {
  //~ return function() { 
      //~ console.log('refresh',ww);
      //~ ww.main_item.doLayout(false,true);
      //~ ww.main_item.syncSize();
  //~ }
//~ };

//~ Lino.tools_close_handler = function (ww) {
  //~ return function() { 
      //~ ww.close();
  //~ }
//~ };
Lino.permalink_handler = function (ww) {
  return function() { 
    //~ document.location = ww.main_item.get_permalink();
    //~ console.log('20130723 Lino.permalink_handler',ww);
    
    /* Uncaught TypeError: Cannot read property 'main_item' of null  */
    if (ww) {
        var url = ww.main_item.get_permalink();
    } else {
        var url = Lino.viewport.get_permalink();
    }
    Lino.load_url(url);
  }
};
//~ Lino.run_permalink = function() {
  //~ var plink = Lino.gup('permalink');
  //~ if(plink) { eval('Lino.'+plink); }
//~ }


Lino.ajax_error_handler = function(panel) {
  return function(response,options) {
    console.log('Ajax failure:',response,options);
    if (panel.loadMask) panel.loadMask.hide();
    if (response.responseText) {
      var lines = response.responseText.split('\n');
      if (lines.length > 10) {
          line = lines.splice(5,lines.length-10,"(...)");
      }
      //~ console.log(20131005, response.statusText.toCamel());
      Ext.MessageBox.alert(
        response.statusText.toCamel(),
        lines.join('<br/>')
        //~ response.responseText.replace(/\n/g,'<br/>'))
      )
    } else {
      Ext.MessageBox.alert('Action failed',
        'Lino server did not respond to Ajax request');
    }
  }
}
// Ext.Ajax.on('requestexception',Lino.ajax_error_handler)
 


Ext.QuickTips.init();

/* setting QuickTips dismissDelay to 0 */
// Apply a set of config properties to the singleton
//~ Ext.apply(Ext.QuickTips.getQuickTip(), {
//~ Ext.apply(Ext.ToolTip, {
    //~ dismissDelay: 0
    //~ autoHide: false,
    //~ closable: true,
    //~ maxWidth: 200,
    //~ minWidth: 100,
    //~ showDelay: 50      // Show 50ms after entering target
    //~ ,trackMouse: true
//~ });


//~ Ext.apply(Ext.QuickTip, {
    //~ dismissDelay: 0,
//~ });
  
Lino.quicktip_renderer = function(title,body) {
  return function(c) {
    //~ if (c instanceof Ext.Panel) var t = c.bwrap; else // 20130129
    if (c instanceof Ext.Panel) var t = c.header; else // 20130129
    var t = c.getEl();
    //~ console.log(20130129,t,title,body);
    //~ t.dismissDelay = 0;
    Ext.QuickTips.register({
      target: t,
      //~ cls: 'lino-quicktip-classical',
      dismissDelay: 0,
      //~ autoHide: false,
      showDelay: 50,      // Show 50ms after entering target
      //~ title: title,
      text: body
    });
  }
};


  
Lino.help_text_editor = function() {
  //~ var bp = {
      //~ mk:this.content_type,
      //~ mt:1
    //~ };
    //~ console.log(20120202,bp);
  //~ Lino.lino.ContentTypes.detail({},{base_params:bp});
  //~ Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
  Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
}

// Path to the blank image should point to a valid location on your server
//~ Ext.BLANK_IMAGE_URL = MEDIA_URL + '/extjs/resources/images/default/s.gif'; 


// used as Ext.grid.Column.renderer for id columns in order to hide the special id value -99999
Lino.id_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  return value;
}

Lino.raw_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  return value;
}

Lino.text_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return "not implemented"; 
  return value;
}

Lino.NullNumberColumn = Ext.extend(Ext.grid.Column, {
    align : 'right', 
    format : '0,00/i', 
    renderer : function(value, metaData, record, rowIndex, colIndex, store) {
        //~ console.log(20130128,"NullNumberColumn.renderer",value);
        if (value === null) return '';
        return Ext.util.Format.number(value, this.format);
    }
});

//~ Lino.NullNumberColumn = Ext.extend(Ext.grid.NumberColumn, {
    //~ align : 'right', 
    //~ constructor: function(cfg){
        //~ Ext.grid.NumberColumn.superclass.constructor.call(this, cfg);
        //~ var t = this;
        //~ this.renderer = function(value, metaData, record, rowIndex, colIndex, store) {
          //~ console.log(20130128,"NullNumberColumn.renderer",value);
          //~ if (value === null) return '';
          //~ return Ext.util.Format.number(value, t.format);
      //~ };
    //~ }
//~ });




//~ Lino.cell_button_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return '<input type="button" onclick="alert(value)" value=" ? ">' ;
//~ }


//~ Lino.default_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  //~ return value;
//~ }

Lino.fk_renderer = function(fkname,handlername) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    //~ if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '.run(null,{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

Lino.lfk_renderer = function(panel,fkname) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  var handlername = 'console.log';
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '({},{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

//~ Lino.gfk_renderer = function() {
  //~ return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ if (record.phantom) return '';
    //~ console.log('Lino.gfk_renderer',value,colIndex,record,metaData,store);
    //~ return value;
  //~ }
//~ };


Lino.build_buttons = function(panel,actions) {
  //~ console.log("20121006 Lino.build_buttons",actions);
  if (actions) {
    var buttons = Array(actions.length);
    var cmenu = Array(actions.length);
    for (var i=0; i < actions.length; i++) { 
      var a = actions[i];
      //~ buttons[i] = new Ext.Toolbar.Button(a);
      if (a.menu) a.menu = Lino.build_buttons(panel,a.menu).bbar;
      buttons[i] = a;
      cmenu[i] = {
            text : a.menu_item_text,
            iconCls : a.iconCls,
            menu : a.menu
          };
      if (a.panel_btn_handler) {
          var h = a.panel_btn_handler.createCallback(panel);
          if (a.auto_save == true) {
              h = panel.do_when_clean.createDelegate(panel,[true,h]);
          } else if (a.auto_save == null) {
              h = panel.do_when_clean.createDelegate(panel,[false,h]);
          } else if (a.auto_save == false) {
              // h = h;
          } else {
              console.log("20120703 unhandled auto_save value",a)
          }
          buttons[i].handler = h;
          cmenu[i].handler = h;
          //~ if (buttons[i].xtype == 'splitbutton') {
              //~ cmenu[i].menu = a.menu;
          //~ } else {
              //~ cmenu[i].handler = h;
          //~ }
      } else {
          cmenu[i].handler = a.handler;
      }
    }
    return {bbar:buttons, cmenu:new Ext.menu.Menu(cmenu)};
  }
}

Lino.do_when_visible = function(cmp,todo) {
  //~ if (cmp.el && cmp.el.dom) 
  if (cmp.isVisible()) { 
    // 'visible' means 'rendered and not hidden'
    //~ console.log(cmp.title,'-> cmp is visible now');
    todo(); 
  //~ } else {
      //~ cmp.on('resize',todo,cmp,{single:true});
  //~ }
  //~ if (false) { // 20120213
  } else { 
    //~ console.log('Lino.do_when_visible() must defer because not isVisible()',todo,cmp);
    if (cmp.rendered) {
      //~ console.log(cmp,'-> cmp is rendered but not visible: and now?');
      //~ console.log(cmp.title,'-> cmp is rendered but not visible: try again in a moment...');
      //~ var fn = function() {Lino.do_when_visible(cmp,todo)};
      //~ fn.defer(100);
      
      Lino.do_when_visible.defer(50,this,[cmp,todo]);
      //~ Lino.do_when_visible.defer(100,this,[cmp,todo]);
      
    } else {
      //~ console.log(cmp.title,'-> after render');
      cmp.on('afterrender',todo,cmp,{single:true});
    }
  }
  
};    

/*
*/
Lino.do_on_current_record = function(panel,fn,phantom_fn) {
  var rec = panel.get_current_record();
  if (rec == undefined) {
    Lino.notify("There's no selected record.");
    return;
  }
  // 20120307 A VirtualTable with a Detail (lino.Models) has only "phantom" records.
  if (rec.phantom) {
    //~ if (!panel.editable) { console.log("20120312 not editable:",panel)}
    if (phantom_fn) {
      phantom_fn(panel);
    } else {
      Lino.notify("Action not available on phantom record.");
    }
    return;
  }
  return fn(rec);
};






Lino.call_ajax_action = function(panel,method,url,p,actionName,step,on_confirm,on_success) {
  p.an = actionName;
  if (!panel) {
      if (Lino.current_window) 
          panel = Lino.current_window.main_item;
      else panel = Lino.viewport;
  }
  //~ console.log("20130809 Lino.call_ajax_action",panel);
  Ext.apply(p,panel.get_base_params());
  
  if (panel.get_selected) {
      var selected_recs = panel.get_selected();
      //~ console.log("20130831",selected_recs);
      var rs = Array(selected_recs.length);
      for(var i=0; i < selected_recs.length;i++) {
          rs[i] = selected_recs[i].data.id;
      };
      p.sr = rs;
  }
  
  if (panel.loadMask) panel.loadMask.show(); 
  //~ p.$ext_requests.URL_PARAM_SUBST_USER = Lino.subst_user;
  //~ Lino.insert_subst_user(p);
    
  //~ if (step) p['$ext_requests.URL_PARAM_ACTION_STEP'] = step;
  //~ if (pp) pp(p); // "parameter processor" : first used for read beid card
  Ext.Ajax.request({
    method: method
    ,url: url
    ,params: p
    ,success: Lino.action_handler(panel,on_success,on_confirm)
    ,failure: Lino.ajax_error_handler(panel)
  });
};

Lino.row_action_handler = function(actionName,hm,pp) {
  var p = {};
  var fn = function(panel,btn,step) {
      if (pp) { p = pp(panel); if (! p) return; }
      
      if (panel.get_current_record == undefined) { // AFTER_20130725
        panel = Ext.getCmp(panel);
        if (panel == undefined) {
          Lino.notify("Invalid panel spec.");
          return;
        }
      }
      
      Lino.do_on_current_record(panel,function(rec) {
          //~ console.log(panel);
          //~ 20120723 Lino.call_ajax_action(panel,rec.id,actionName,step,fn);
          panel.add_param_values(p,true); // 20130915
          Lino.call_ajax_action(panel,hm,panel.get_record_url(rec.id),p,actionName,step,fn);
      });
  };
  return fn;
};

Lino.list_action_handler = function(ls_url,actionName,hm,pp) {
  var p = {};
  var url = '/api' + ls_url
  var fn = function(panel,btn,step) {
      //~ console.log("20121210 Lino.list_action_handler",arguments);
      //~ var url = ADMIN_URL + '/api' + panel.ls_url
      if (pp) { p = pp(panel);  if (! p) return; }
      panel.add_param_values(p,true); // 20130915
      Lino.call_ajax_action(panel,hm,url,p,actionName,step,fn);
  };
  return fn;
};

Lino.param_action_handler = function(window_action) { // 20121012
  var fn = function(panel,btn,step) {
    Lino.do_on_current_record(panel,function(rec) {
      //~ console.log(panel);
      //~ 20120723 Lino.call_ajax_action(panel,rec.id,actionName,step,fn);
      window_action.run(panel.getId(),{}); 
    });
  };
  return fn;
};


//~ 20130726 Lino.run_row_action = function(requesting_panel,url,pk,actionName,pp) {
Lino.run_row_action = function(requesting_panel,url,meth,pk,actionName,preprocessor) {
  //~ var panel = action.get_window().main_item;
  url = '/api' + url  + '/' + pk;
  var panel = Ext.getCmp(requesting_panel);
  if (preprocessor) var p = preprocessor(); else var p = {};
  var fn = function(panel,btn,step) {
    //~ 20120723 Lino.call_ajax_action(panel,pk,actionName,step,fn);
    //~ 20130726 Lino.call_ajax_action(panel,'GET',url,p,actionName,step,fn);
    Lino.call_ajax_action(panel,meth,url,p,actionName,step,fn);
  }
  fn(panel,null,null);
}



Lino.show_detail = function(panel,btn) {
  Lino.do_on_current_record(panel, 
    function(rec) {
      //~ panel.loadMask.show();
      Lino.run_detail_handler(panel,rec.id);
    },
    Lino.show_insert
  );
};

Lino.run_detail_handler = function(panel,pk) {
  var bp = panel.get_base_params();
  //~ var bp = {};
  panel.add_param_values(bp); // 20120918
  var status = {
    record_id:pk,
    base_params:bp
    //~ param_values: pv.$ext_requests.URL_PARAM_PARAM_VALUES
  }
  //~ console.log("20120918 Lino.show_detail",status);
  panel.ls_detail_handler.run(null,status);
  //~ panel.loadMask.hide();
  //~ panel.containing_window.window.hideMask();
  //~ panel.el.unmask();
}

Lino.show_fk_detail = function(combo,detail_action) {
    //~ console.log("Lino.show_fk_detail",combo,handler);
    pk = combo.getValue();
    if (pk) {
        detail_action.run(null,{record_id: pk})
      } else {
        Lino.notify("Cannot show detail for empty foreign key.");
      }
};

Lino.show_insert = function(panel,btn) {
  var bp = panel.get_base_params();
  //~ console.log('20120125 Lino.show_insert',bp)
  //~ panel.ls_insert_handler.run(null,{record_id:-99999,base_params:bp});
  panel.ls_insert_handler.run(panel.getId(),{record_id:-99999,base_params:bp});
};

//~ Lino.show_insert_duplicate = function(panel,btn) {
  //~ Lino.do_on_current_record(panel,
    //~ function(rec) {
      //~ var newRec = {};
      //~ Ext.apply(newRec,rec);
      //~ newRec.id = -99999;
      //~ panel.ls_insert_handler.run(null,{data_record:rec});
    //~ });
//~ };

//~ Lino.update_row_handler = function(action_name) {
  //~ return function(panel,btn) {
    //~ Lino.notify("Sorry, " + action_name + " is not implemented.");
  //~ }
//~ };




if (Ext.ux.grid !== undefined) {
    Lino.GridFilters = Ext.extend(Ext.ux.grid.GridFilters,{
      encode:true,
      local:false
    });
} else {
    Lino.GridFilters = function() {}; // dummy
    Ext.override(Lino.GridFilters,{
      init : function() {}
    });
};



//~ Lino.ButtonField = Ext.extend(Ext.form.TextField,{
//~ Lino.ButtonField = Ext.extend(Ext.form.Field,{
    //~ editable : false,
    //~ constructor : function(ww,config,params){
      //~ this.containing_window = ww;
      //~ if (params) Ext.apply(config,params);
      //~ Lino.ButtonField.superclass.constructor.call(this, config);
    //~ },
    //~ setButtons : function(buttons){
      //~ console.log('setButtons',buttons);
    //~ },
    //~ onRender : function(ct, position){
        //~ if(!this.el){
            //~ this.panel = new Ext.Container({items:[
              //~ {xtype:'button',text:'upload'},
              //~ {xtype:'button',text:'show'},
              //~ {xtype:'button',text:'edit'}
            //~ ]});
            //~ this.panel.ownerCt = this;
            //~ this.el = this.panel.getEl();

        //~ }
        //~ Lino.ButtonField.superclass.onRender.call(this, ct, position);
    //~ },

  
//~ });

Lino.FieldBoxMixin = {
  before_init : function(config,params) {
    if (params) Ext.apply(config,params);
    var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    if (actions) config.bbar = actions.bbar;
  },
  //~ constructor : function(ww,config,params){
    //~ this.containing_window = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  do_when_clean : function(auto_save,todo) { todo() },
  //~ format_data : function(html) { return '<div class="htmlText">' + html + '</div>' },
  format_data : function(html) { return html },
  get_base_params : function() {
    // needed for insert action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
  },
  set_base_params : function(p) {
    this.base_params = Ext.apply({},p);
    //~ if (p.param_values) this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  },
  set_base_param : function(k,v) {
    this.base_params[k] = v;
  }
};



Lino.HtmlBoxPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,{
  disabled_in_insert_window : true,
  constructor : function(config,params) {
    this.before_init(config,params);
    Lino.HtmlBoxPanel.superclass.constructor.call(this, config);
  },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.constructor.call(this, ww,config,params);
  //~ },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  //~ disable : function() { var tb = this.getBottomToolbar(); if(tb) tb.disable()},
  //~ enable : function() { var tb = this.getBottomToolbar(); if(tb) tb.enable()},
  onRender : function(ct, position){
    Lino.HtmlBoxPanel.superclass.onRender.call(this, ct, position);
    //~ console.log(20111125,this.containing_window);
    if (this.containing_panel) {
      this.containing_panel.on('enable',this.enable,this);
      this.containing_panel.on('disable',this.disable,this);
    }
    this.el.on({
      dragenter:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        return true;
      }
      ,dragover:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        event.stopEvent();
        return true;
      }
      ,drop:{
        scope:this
        ,fn:function(event){
          event.stopEvent();
          //~ console.log(20110516);
          var files = event.browserEvent.dataTransfer.files;
          if(files === undefined){
            return true;
          }
          var len = files.length;
          while(--len >= 0){
            console.log(files[len]);
            //~ this.processDragAndDropFileUpload(files[len]);
          }
          Lino.show_insert(this);
        }
      }
    });
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    //~ if (this.master_panel) {
      var record = this.containing_panel.get_current_record();
      //~ console.log('HtmlBox.refresh()',this.title,record,record.title);
      var box = this.items.get(0);
      var todo = function() {
        if (this.disabled) return;
        //~ this.set_base_params(this.containing_window.get_base_params());
        this.set_base_params(this.containing_panel.get_master_params());
        var el = box.getEl();
        if (el) {
          el.update(record ? this.format_data(record.data[this.name]) : '');
          //~ console.log('20130723 HtmlBox.refresh()',this.name);
        //~ } else {
          //~ console.log('HtmlBox.refresh() failed for',this.name);
        }
      };
      Lino.do_when_visible(box,todo.createDelegate(this));
    //~ }
  }
});
//~ Ext.override(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);



Lino.RichTextPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,Lino.FieldBoxMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,{
    
  //~ initComponent : function(){
    //~ Lino.RichTextPanel.superclass.initComponent.call(this);
  //~ },
  constructor : function(config,params) {
    //~ console.log('Lino.RichTextPanel.initComponent',this);
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + String(rec.id) + "/" + config.name;
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + config.name;
    var t = this;
    var tinymce_options = {
        theme : "advanced",
        content_css: '/media/lino/extjs/lino.css',
        language: 'en',
        //~ template_external_list_url : url,
        theme_advanced_toolbar_location : "top",
        theme_advanced_toolbar_align : "left",
        theme_advanced_statusbar_location : "bottom",
        template_popup_width : 700,
        template_popup_height : 500,
        template_replace_values : { 
            data_field : function(element){ 
                //~ console.log(20110722,fieldName,t.containing_window.get_current_record()); 
                var fieldName = element.innerHTML;
                element.innerHTML = t.containing_panel.get_current_record().data[fieldName];
            } 
        }
      };
      
    var editorConfig = {
      tinymceSettings: {
        plugins : "noneditable,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "bold,italic,underline,|,justifyleft,justifycenter,justifyright,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,removeformat,template",
        theme_advanced_buttons2 : "",
        theme_advanced_buttons3 : "", // ,|,sub,sup,|,charmap",      
        theme_advanced_resizing : false
        //~ save_onsavecallback : save_callback,
        //~ save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
        
    }};
    Ext.apply(editorConfig.tinymceSettings,tinymce_options);
    //~ editorConfig.name = config.action_name;
    editorConfig.name = config.name;
    delete config.name;
    //~ config.title = config.label;
    //~ delete config.label;
    this.before_init(config,params);
    
    this.editor = new Ext.ux.TinyMCE(editorConfig);
    var t = this;
    config.tools = [{
                      qtip: "Edit text in own window", 
                      id: "up",
                      handler: function(){
                        if(t.editor.isDirty()) {
                            var record = t.containing_panel.get_current_record();
                            record.data[t.editor.name] = t.editor.getValue();
                        }
                        Lino.edit_tinymce_text(t,tinymce_options)
                      }
                    }];
    
    config.items = this.editor;
    config.layout = "fit";
    Lino.RichTextPanel.superclass.constructor.call(this, config);
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    var record = this.containing_panel.get_current_record();
    //~ console.log('RichTextPanel.refresh()',this.title,record.title,record);
    var todo = function() {
      //~ this.set_base_params(this.containing_window.get_base_params());
      if (record) {
        var url = '/templates' + this.containing_panel.ls_url + "/" 
            + String(record.id) + "/" + this.editor.name;
        //~ console.log('RichTextPanel.refresh()',url);
        if (this.editor.ed) this.editor.ed.settings.template_external_list_url = url;
        this.set_base_params(this.containing_panel.get_master_params());
        //~ var v = record ? this.format_data(record.data[this.editor.name]) : ''
        var v = this.format_data(record.data[this.editor.name])
        this.editor.setValue(v);
      } else {
        this.editor.setValue('(no data)');
      }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
//~ Ext.override(Lino.RichTextPanel,Lino.FieldBoxMixin);



Lino.ActionFormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,Lino.PanelMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,Lino.FieldBoxMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  //~ layout:'fit'
  //~ ,autoHeight: true
  //~ ,frame: true
  window_title: "Action Parameters",
  constructor : function(config){
    config.bbar = [
        {text:'OK',handler:this.on_ok,scope:this},
        {text:'Cancel',handler:this.on_cancel,scope:this}
    ];
    //~ config.items = config.params_panel;
    Lino.ActionFormPanel.superclass.constructor.call(this, config);
  }
  //~ ,initComponent : function(){
    //~ Lino.ActionFormPanel.superclass.initComponent.call(this);
  //~ }
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
    //~ var rp = this.requesting_panel;
    var panel = this.requesting_panel;
    //~ console.log("20131004 on_ok",this,panel,arguments);
    //~ if (panel == undefined) {
        //~ Lino.alert("Sorry, dialog actions don't work without a requesting_panel");
        //~ return;
    //~ }
    //~ var rec = panel.get_current_record();
    var actionName = this.action_name;
    var pk = this.base_params.mk;
    if (pk == undefined && panel) {
        pk = panel.get_current_record().id;
    }
    if (pk == undefined) {
        Lino.alert("Sorry, dialog action without base_params.mk");
        return;
    }
    var self = this;
    function on_success() { self.get_containing_window().close(); };
    // 20131004
    //~ var url = '/api' + this.ls_url + '/' + pk;
    var url = '/api' + panel.ls_url + '/' + pk;
    var fn = function(panel,btn,step) {
      var p = {};
      self.add_field_values(p)
      //~ Lino.call_ajax_action(panel,'GET',panel.get_record_url(rec.id),p,actionName,step,fn,on_success);
      Lino.call_ajax_action(panel,'GET',url,p,actionName,step,fn,on_success);
    }
    fn(panel,null,null);
    
    
  }
  ,set_status : function(status,rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 ActionFormPanel.set_status()',status,rp,this.requesting_panel);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_field_values(status.field_values);
    if (status.base_params) this.set_base_params(status.base_params);
  }
  
  ,add_field_values : function (p) { // similar to add_param_values()
      //~ 20121023 
      if (this.form.isDirty()) {
        p.fv = this.get_field_values();
      }else{
        if (this.status_field_values) 
          p.fv = Lino.fields2array(this.fields,this.status_field_values);
      }
      //~ if (!this.form.isDirty()) return;
      //~ p.$ext_requests.URL_PARAM_FIELD_VALUES = this.get_field_values();
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
  }
  ,get_field_values : function() {
      return Lino.fields2array(this.fields);
  }
  ,set_field_values : function(pv) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_field_values = pv;
      if (pv) this.form.my_loadRecord(pv);
      else this.form.reset(); 
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.title = this.window_title;
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok }
      ]
  }
});

//~ Lino.add_blank = function(oa) {
    //~ return [].concat(oa)
    //~ return 
    //~ }
    
Lino.fields2array = function(fields,values) {
    //~ console.log('20130605 fields2array gonna loop on', fields,values);
    var pv = Array(fields.length);
    for(var i=0; i < fields.length;i++) {
        var f = fields[i]
        if (values) 
          var v = values[f.name];
        else 
          var v = f.getValue();
        if (f.formatDate) {
            pv[i] = f.formatDate(v); 
        } else {
            pv[i] = v; // f.getValue(); 
        }
    }
    return pv;
}


Lino.FormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.FormPanel = Ext.extend(Lino.FormPanel,Lino.PanelMixin);
Lino.FormPanel = Ext.extend(Lino.FormPanel,{
  params_panel_hidden : false,
  //~ base_params : {},
  //~ trackResetOnLoad : true,
  //~ query_params : {},
  //~ 20110119b quick_search_text : '',
  constructor : function(config,params){
    if (params) Ext.apply(config,params);
    this.base_params = {};
    //~ ww.config.base_params.query = ''; // 20111018
    //~ console.log(config);
    //~ console.log('FormPanel.constructor() 1',config)
    //~ Ext.applyIf(config,{base_params:{}});
    //~ console.log('FormPanel.constructor() 2',config)
      
    config.trackResetOnLoad = true;
    
    Lino.FormPanel.superclass.constructor.call(this, config);
      
    //~ this.set_base_param('$URL_PARAM_FILTER',null); // 20111018
    //~ this.set_base_param('$URL_PARAM_FILTER',''); // 20111018
      
  },
  initComponent : function(){
    
    //~ console.log("20111201 containing_window",this.containing_window,this);
    
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    if (actions) {
        this.bbar = actions.bbar;
    //~ } else {
        //~ this.bbar = [];
    }
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ var config = this;
    
    //~ if (this.containing_window instanceof Lino.DetailWrapper) {
    
    //~ console.log('20120121 initComponent', this.action_name);
    //~ if (this.action_name == 'detail' | this.action_name == 'show') {
    //~ if (this.action_name != 'insert') {
    if (! this.hide_top_toolbar) {
      this.tbar = [];
      // 20111015    
      if (! this.hide_navigator) {
        this.record_selector = new Lino.RemoteComboFieldElement({
          store: new Lino.ComplexRemoteComboStore({
            //~ baseParams: this.containing_window.config.base_params,
            baseParams: this.get_base_params(),
            //~ value: this.containing_window.config.base_params.query,
            proxy: new Ext.data.HttpProxy({
              url: '/choices' + this.ls_url,
              method:'GET'
            })
          }),
          pageSize:25,
          listeners: { 
            scope:this, 
            select:function(combo,record,index) {
              //~ console.log('jumpto_select',arguments);
              this.goto_record_id(record.id);
            }
          },
          emptyText: "Go to record"
        })
        this.tbar = this.tbar.concat([this.record_selector]);
        
        this.tbar = this.tbar.concat([
          this.first = new Ext.Toolbar.Button({
            tooltip:"First",disabled:true,handler:this.moveFirst,scope:this,iconCls:'x-tbar-page-first'}),
          this.prev = new Ext.Toolbar.Button({
            tooltip:"Previous",disabled:true,handler:this.movePrev,scope:this,iconCls:'x-tbar-page-prev'}),
          this.next = new Ext.Toolbar.Button({
            tooltip:"Next",disabled:true,handler:this.moveNext,scope:this,iconCls:'x-tbar-page-next'}),
          this.last = new Ext.Toolbar.Button({
            tooltip:"Last",disabled:true,handler:this.moveLast,scope:this,iconCls:'x-tbar-page-last'})
        ]);
      }
      this.tbar = this.add_params_panel(this.tbar);
      
      //~ console.log(20101117,this.containing_window.refresh);
      this.tbar = this.tbar.concat([
        {
          //~ text:'Refresh',
          handler:function(){ this.do_when_clean(true,this.refresh.createDelegate(this)) },
          iconCls: 'x-tbar-loading',
          tooltip:"Reload current record",
          scope:this}
      ]);
          
      if (this.bbar) { // since 20121016
        if (this.tbar) {
            this.tbar = this.tbar.concat(['-']) ;
        } else {
          this.tbar = [];
        }
        this.tbar = this.tbar.concat(this.bbar) ;
        this.bbar = undefined;
      }
    
      this.tbar = this.tbar.concat([
          '->',
          this.displayItem = new Ext.Toolbar.TextItem({})
      ]);
          
    }
    //~ if (this.content_type && this.action_name != 'insert') {
      //~ this.bbar = this.bbar.concat([
        //~ '->',
        //~ { text: "[$_('Help Text Editor')]",
          //~ handler: Lino.help_text_editor,
          //~ qtip: "$_('Edit help texts for fields on this model.')",
          //~ scope: this}
      //~ ])
    //~ }
    //~ this.before_row_edit = config.before_row_edit.createDelegate(this);
      
    //~ if (this.master_panel) {
        //~ this.set_base_params(this.master_panel.get_master_params());
    //~ }
      
    Lino.FormPanel.superclass.initComponent.call(this);
    
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.bwrap,{msg:"Please wait..."});
    },this);
    
    
    //~ var this_ = this;
    //~ this.cascade(function(cmp){
      //~ // var active_field = false;
      //~ for (i = 0; i < this_.active_fields.length; i++) {
        //~ if (cmp.name == this_.active_fields[i]) {
            //~ // active_field = true; break;
            //~ cmp.on("change",function() {this_.save()});
        //~ }
      //~ };
      //~ if (active_field) {
      // if (cmp instanceof Lino.GridPanel) {
          //~ cmp.on("change",function() {this_.save()});
      //~ }
    //~ });
    
    if (this.action_name == 'insert') {
      this.cascade(function(cmp){
        // console.log('20110613 cascade',cmp);
        if (cmp.disabled_in_insert_window) {
            //~ cmp.disable();
            cmp.hide();
        }
      });
      
    }
    
  },
  
  unused_is_loading : function() { 
    if (this.current_record == null) {
        //~ console.log("20130515 current_record is null");
        return true; 
    }
    
    if (! this.loadMask) return true; // not even rendered: 
    if (! this.loadMask.el) return true; // not even rendered: 
    // thanks to Marco Pegoraro http://movableapp.com/2011/09/sencha-touch-loadmask-isvisible/
    var loading = (this.loadMask.el.select('.x-loading-msg').elements.length > 0);
    //~ console.log('20130515 GridPanel.is_loading() returns',loading);
    return loading;

    
    var loading = false;
    this.cascade(function(cmp){
        if (cmp instanceof Lino.GridPanel && cmp.is_loading()) {
            //~ console.log(20130515, cmp.title,'is loading');
            loading = true;
            return false;
        }
      });
    return loading;
    //~ var a = this.findByType(Lino.GridPanel);
    //~ for (i=0;i<a.length;i++) {
        //~ if (a[i].is_loading()) return true;
    //~ }
    //~ return false;
  },
  
  get_status : function(){
      var st = {
        base_params: this.get_base_params(),
        data_record : this.get_current_record()
        }
      var tp = this.items.get(0);
      if (tp instanceof Ext.TabPanel) {
        st.active_tab = tp.getActiveTab();
      }
      st.param_values = this.status_param_values;
      return st;
  },
  /* FormPanel */
  set_status : function(status,rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 FormPanel.set_status()',status);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_param_values(status.param_values);
    if (status.base_params) this.set_base_params(status.base_params);
    var tp = this.items.get(0);
    if (tp instanceof Ext.TabPanel) {
      if (status.active_tab) {
        //~ console.log('20111201 active_tab',this.active_tab,this.items.get(0));
        //~ tp.activeTab = status.active_tab;
        tp.setActiveTab(status.active_tab);
        //~ this.main_item.items.get(0).activate(status.active_tab);
      } else {
        tp.setActiveTab(0);
      }
      }
    
    if (status.data_record) {
      //~ console.log('20111201 Lino.FormPanel with data_record',this.data_record.title,this.containing_window);
      //~ this.main_item.on_master_changed.defer(2000,this.main_item,[status.data_record]);
      //~ Lino.do_when_visible(this.main_item,function(){this.on_master_changed(status.data_record)});
      //~ this.main_item.on('afterrender',function(){
      //~   this.main_item.on_master_changed(status.data_record)},this,{single:true});
      /* must defer because because set_window_title() didn't work otherwise */
      this.set_current_record.createDelegate(this,[status.data_record]).defer(100);
      //~ this.set_current_record(this.data_record);
      //~ return;
    } else if (status.record_id != undefined) { 
      /* possible values include 0 and null, 0 being a valid record id, 
      null the equivalent of undefined
      */
      //~ this.main_item.goto_record_id(this.status.record_id);
      this.load_record_id(status.record_id);
    } else {
      this.set_current_record(undefined);
    }
  },
    
  get_base_params : function() {
    // needed for insert_action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
    //~ return this.base_params;
  },
  set_base_params : function(p) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    delete p['query'] // 20120725
    Ext.apply(this.base_params,p);
    if (this.record_selector) {
        var store = this.record_selector.getStore();
        for (k in p) store.setBaseParam(k,p[k]);
        delete this.record_selector.lastQuery;
        //~ console.log("20120725 record_selector.setBaseParam",p)
    }
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
        
      //~ if (this.record_selector) {
          //~ var store = this.record_selector.getStore();
          //~ for (k in store.baseParams) store.setBaseParam(k,undefined);
          //~ delete this.record_selector.lastQuery;
          //~ console.log("20120725 record_selector.getBaseParams() -->",store.baseParams)
      //~ }
  },
  set_base_param : function(k,v) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    this.base_params[k] = v;
    //~ if (this.record_selector) {
        //~ this.record_selector.getStore().setBaseParam(k,v);
        //~ delete this.record_selector.lastQuery;
    //~ }
  },
  
  after_delete : function() {
    if (this.current_record.navinfo.next)
      this.moveNext();
    else if (this.current_record.navinfo.prev)
      this.movePrev();
    else 
      this.abandon();
  },
  moveFirst : function() {this.goto_record_id(this.current_record.navinfo.first)},
  movePrev : function() {this.goto_record_id(this.current_record.navinfo.prev)},
  moveNext : function() {this.goto_record_id(this.current_record.navinfo.next)},
  moveLast : function() {this.goto_record_id(this.current_record.navinfo.last)},
  
  
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ console.log('20120121 Lino.FormPanel.refresh()',this);
    if (this.current_record) {
        this.load_record_id(this.current_record.id,after);
    } else {
        this.set_current_record(undefined,after);
    }
  },
  
  do_when_clean : function(auto_save,todo) {
    var this_ = this;
    if (this.form.isDirty()) {
        if (auto_save) {
            this_.save(todo);
        } else {
          //~ console.log('20111217 do_when_clean() form is dirty',this.form);
          var config = {title:"Confirmation"};
          config.buttons = Ext.MessageBox.YESNOCANCEL;
          config.msg = "Save changes to current record ?";
          config.fn = function(buttonId,text,opt) {
            //~ console.log('do_when_clean',buttonId)
            if (buttonId == "yes") {
                //~ Lino.submit_detail(this_,undefined,todo);
                //~ this_.containing_window.save(todo);
                this_.save(todo);
            } else if (buttonId == "no") { 
              todo();
            }
          }
        }
        Ext.MessageBox.show(config);
    }else{
      //~ console.log('do_when_clean : now!')
      todo();
    }
  },
  
  goto_record_id : function(record_id) {
    //~ console.log('20110701 Lino.FormPanel.goto_record_id()',record_id);
    //~ var this_ = this;
    //~ this.do_when_clean(function() { this_.load_record_id(record_id) }
    this.do_when_clean(true,this.load_record_id.createDelegate(this,[record_id]));
  },
  
  load_record_id : function(record_id,after) {
    var this_ = this;
    //~ var p = { fmt: this.containing_window.config.action_name};
    //~ var p = Ext.apply({},this.containing_window.config.base_params);
    var p = Ext.apply({},this.get_base_params());
    //~ Lino.insert_subst_user(p);
    //~ console.log('20110713 action_name=',this.containing_window.config.action_name,
      //~ 'base_params=',this.containing_window.config.base_params);
    if (this.action_name)
        p.an = this.action_name;
    //~ p.an = this.action_name;
    //~ p.an = this.containing_window.config.action_name;
    //~ p.fmt = 'json';
    //~ p.fmt = '$ext_requests.URL_FORMAT_JSON';
    p.rp = this.getId();
    //~ p.$ext_requests.URL_PARAM_SUBST_USER = Lino.subst_user;
    p.fmt = 'json';
    //~ 20110119b p['$URL_PARAM_FILTER'] = this.quick_search_text;
    //~ Ext.apply(p,this.query_params);
    this.add_param_values(p);
    //~ console.log('20121120 FormPanel.load_record_id',record_id,p);
    if (this.loadMask) this.loadMask.show();
    Ext.Ajax.request({ 
      waitMsg: 'Loading record...',
      method: 'GET',
      params: p,
      scope: this,
      url: this.get_record_url(record_id),
      success: function(response) {   
        // todo: convert to Lino.action_handler.... but result 
        if (this.loadMask) this.loadMask.hide();
        if (response.responseText) {
          var rec = Ext.decode(response.responseText);
          //~ console.log('20120918 goto_record_id success',rec);
          this.set_param_values(rec.param_values);
          this.set_current_record(rec,after);
        }
      },
      failure: Lino.ajax_error_handler(this)
    });
  },

  abandon : function () {
    Ext.MessageBox.alert('Note',
      "No more records to display. Detail window has been closed.");
    Lino.close_window();
    //~ if (this.containing_window) {
        //~ this.containing_window.hide();
    //~ }
  },
  
  set_current_record : function(record,after) {
    //~ console.log('20120722 Lino.FormPanel.set_current_record',record.title,record);
    if (this.record_selector) {
        this.record_selector.clearValue();
        // e.g. InsertWrapper FormPanel doesn't have a record_selector
    }
    this.current_record = record;
    //~ if (record) 
        //~ console.log('Lino.FormPanel.set_current_record',record.title,record);
    //~ else
        //~ console.log('Lino.FormPanel.set_current_record',record);
    //~ this.config.main_panel.form.load(record);    
    if (record) {
      this.enable();
      this.form.my_loadRecord(record.data);
      this.set_window_title(record.title);
      //~ this.getBottomToolbar().enable();
      var da = record.data.disabled_actions;
      if (da) {
          //~ console.log('20120528 disabled_actions =',da,this.getBottomToolbar());
          //~ 20121016 this.getBottomToolbar().items.each(function(item,index,length){
          var tb = this.getTopToolbar();
          if (tb) tb.items.each(function(item,index,length){
              //~ console.log('20120528 ',item.itemId,'-->',da[item.itemId]);
              if (da[item.itemId]) item.disable(); else item.enable();
          });
      };
      if (this.disable_editing | record.data.disable_editing) {
          //~ console.log("20120202 disable_editing",record.title);
          this.form.items.each(function(cmp){
            if (!cmp.always_enabled) cmp.disable();
          },this);
      } else {
          this.form.items.each(function(cmp){
            //~ console.log("20120202",cmp);
            if (record.data.disabled_fields[cmp.name]) cmp.disable();
            else cmp.enable();
          },this);
        
          //~ if (record.data.disabled_fields) {
              //~ for (i = 0; i < record.data.disabled_fields.length; i++) {
                  //~ var flds = this.find('name',record.data.disabled_fields[i]);
                  //~ if (flds.length == 1) { 
                    //~ flds[0].disable(); 
                  //~ }
              //~ }
          //~ }
      };
      if (this.first) {
        if (record.navinfo  && ! this.hide_navigator) {
          this.first.setDisabled(!record.navinfo.first);
          this.prev.setDisabled(!record.navinfo.prev);
          this.next.setDisabled(!record.navinfo.next);
          this.last.setDisabled(!record.navinfo.last);
          this.displayItem.setText(record.navinfo.message);
        } else {
          this.first.setDisabled(true);
          this.prev.setDisabled(true);
          this.next.setDisabled(true);
          this.last.setDisabled(true);
        }
      }
    } else {
      if (this.form.rendered) 
        this.form.reset(); /* FileUploadField would fail when resetting a non-rendered form */
      //~ this.disable();
      //~ this.getBottomToolbar().disable();
      this.form.items.each(function(cmp){
        cmp.disable();
      },this);
      this.set_window_title(this.empty_title);
      //~ this.containing_window.window.setTitle(this.empty_title);
      if (!this.hide_navigator) {
        this.first.disable();
        this.prev.disable();
        this.next.disable();
        this.last.disable();
      }
    }
    //~ console.log('20100531 Lino.DetailMixin.on_load_master_record',this.main_form);
    this.before_row_edit(record);
    if (after) after();
  },
  
  before_row_edit : function(record) {},
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.refresh();
  },
  
  get_selected : function() { return [ this.current_record ] },
  get_current_record : function() {  
    //~ console.log(20100714,this.current_record);
    return this.current_record 
  },
  
  get_permalink_url : function() {
      var rec = this.get_current_record();
      if (rec && ! rec.phantom && rec.id != -99998)
          return '/api' + this.ls_url + '/' + rec.id;
      return '/api' + this.ls_url;
    
  },
  get_permalink_params : function() {
    var p = {};
    //~ var p = {an:'detail'};
    if (this.action_name)
        p.an = this.action_name;
    //~ var p = {an:this.action_name};
    var main = this.items.get(0);
    if (main.activeTab) {
      var tab = main.items.indexOf(main.activeTab);
      //~ console.log('main.activeTab',tab,main.activeTab);
      if (tab) p.tab = tab;
    }
    this.add_param_values(p)
    return p;
  },
  
  /* 
  Lino.FormPanel.save() 
  */
  save : function(after,switch_to_detail,action_name) {
    //~ var panel = this;
    //~ console.log('20121120 FormPanel.save');
    this.loadMask.show();
    var rec = this.get_current_record();
    if (this.has_file_upload) this.form.fileUpload = true;
    //~ console.log('FormPanel.save()',rec);
    if (!action_name) action_name = this.action_name;
    if (rec) {
      var p = {};
      Ext.apply(p,this.get_base_params());
      p.rp = this.getId();
      //~ if (this.action_name) 
          //~ p.$ext_requests.URL_PARAM_ACTION_NAME = this.action_name;
      p.an = action_name;
      if (rec.phantom) {
        //~ if (this.action_name != 'insert') 
            //~ console.log("Warning: phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: '/api' + this.ls_url,
          method: 'POST',
          params: p, 
          scope: this,
          success: function(form, action) {
            this.loadMask.hide();
            Lino.notify(action.result.message);
            /***
            Close this window, but update the status of the 
            calling window.
            If the calling window is a detail on the same table,
            then it should skip to the new record. But only then.
            A successful response usually has a data_record,
            except if it is a fileupload form where some mysterious 
            decoding problems (20120209) force us to return a record_id 
            which will lead to an additional GET.
            ***/
            var url = this.ls_url;
            var ww = Lino.calling_window();
            if (ww && ww.window.main_item instanceof Lino.FormPanel 
                   && ww.window.main_item.ls_url == this.ls_url) {
                //~ console.log("20120217 case 1");
                ww.status.record_id = action.result.record_id;
                ww.status.data_record = action.result.data_record;
                Lino.close_window();
            } else if (this.ls_detail_handler && switch_to_detail) {
                //~ console.log("20120217 case 2");
                Lino.kill_current_window();
                this.ls_detail_handler.run(null,{
                    record_id:action.result.record_id,
                    data_record: action.result.data_record,
                    base_params:this.get_base_params()
                });
            } else {
                //~ console.log("20120217 case 3");
                Lino.close_window();
            }
            //~ Lino.close_window(function(ww){
                //~ if (ww.window.main_item instanceof Lino.FormPanel 
                    //~ && ww.window.main_item.ls_url == url) {
                  //~ ww.status.record_id = action.result.record_id,
                  //~ ww.status.data_record = action.result.data_record
                //~ }
            //~ });
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action);
          },
          clientValidation: true
        })
      } else {
        //~ if (this.action_name != 'detail') 
            //~ console.log("Warning: non-phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: '/api' + this.ls_url + '/' + rec.id,
          method: 'PUT',
          //~ headers: { 'HTTP_X_REQUESTED_WITH' : 'XMLHttpRequest'},
          scope: this,
          params: p, 
          success: function(form, action) {
            //~ panel.form.setValues(rec.data);
            //~ 20110701 panel.form.my_loadRecord(rec);
            this.loadMask.hide();
            Lino.notify(action.result.message);
            if (action.result.data_record)
                this.set_current_record(action.result.data_record,after);
            else
                console.log("Warning: no data_record in response to FormPanel.PUT")
            //~ this.refresh_with_after(after);
            //~ if (after) after(); else panel.refresh();
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action)},
          clientValidation: true
        })
      }
    } else Lino.notify("Sorry, no current record.");
  }
  
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
      this.save(null,true);
      //~ var rec = this.get_current_record();
      //~ if (rec && rec.phantom)
          //~ this.do_when_clean(true,function() { Lino.close_window(); });
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok, scope:this }
        ,{ key: Ext.EventObject.ESCAPE, fn: this.on_cancel, scope:this }
      ]
  }
  
  
  /* not used (no longer possible without .dtl files)
  , edit_detail_config : function () {
    var active_tab = {};
    var main = this.items.get(0);
    if (main.getActiveTab !== undefined) {
      var tabitem = main.getActiveTab();
      Ext.apply(active_tab,{$ext_requests.URL_PARAM_TAB : main.items.indexOf(tabitem)});
    }
    var editor = new Ext.form.TextArea();
    var close = function() { win.close(); }
    var _this = this;
    var save = function() { 
      //~ console.log(20110609,arguments); 
      var params = {desc: editor.getValue()};
      Ext.apply(params,active_tab);
      var a = { 
        params: params, 
        method: 'PUT',
        url: ADMIN_URL + '/detail_config' + _this.ls_url,
        failure : Lino.ajax_error_handler(this),
        success: Lino.action_handler( _this, function(result) {
          //~ console.log('detail_config/save success',result);
          win.close();
          document.location = _this.get_permalink();
        })
      };
      //~ console.log('detail_config/save sent',a);
      _this.loadMask.show(); // 20120211
      Ext.Ajax.request(a);
    }
    var save_btn = new Ext.Button({text:'Save',handler:save,disabled:true});
    var win = new Ext.Window({title:'Detail Layout',
      items:editor, layout:'fit',
      width:500,height:500,
      bbar:[{text:'Cancel',handler:close},save_btn]});
    var a = { 
      params:active_tab, 
      method:'GET',
      url:ADMIN_URL+'/detail_config'+_this.ls_url,
      success : function(response) {
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          if (result.success) {
            editor.setValue(result.desc);
            save_btn.enable();
          }
        }
      }
    };
    Ext.Ajax.request(a);
    win.show();
  }
  */
});



Lino.getRowClass = function(record, rowIndex, rowParams, store) {
    //~ console.log(20130816,record);
    //~ return 'x-grid3-row-green';
    return record.data.row_class;
  //~ if (true) {
      //~ return 'x-grid3-row-red';
  //~ }
  //~ if (record.phantom) {
    //~ console.log(20101009,record);
    //~ rowParams.bodyStyle = "color:red;background-color:blue";
    //~ return 'lino-phantom-row';
    //~ }
  //~ console.log('20101009 not a phantom:',record);
  //~ return '';
}

//~ FOO = 0;



Lino.GridStore = Ext.extend(Ext.data.ArrayStore,{ 
  autoLoad: false
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
    if (!options) options = {};
    if (!options.params) options.params = {};
    options.params.fmt = 'json';
    options.params.rp = this.grid_panel.getId();
    Lino.insert_subst_user(options.params); // since 20121016
      
    if (this.grid_panel.hide_top_toolbar) {
        //~ console.log("20120206 GridStore.load() toolbar is hidden");
        options.params.start = 0;
        if (this.grid_panel.preview_limit) {
          options.params.limit = this.grid_panel.preview_limit;
        }
    } else {
        var ps = this.grid_panel.calculatePageSize();
        if (!ps) {
            //~ this.gridpanel.on('render',this.load())
          //~ console.log("20120814 GridStore.load() failed to calculate pagesize");
          return false;
            //~ params.$URL_PARAM_LIMIT = 1;
            //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
            //~ return;
        } 
        options.params.limit = ps;
      
        //~ options.params.start = this.grid_panel.getTopToolbar().cursor;
        //~ if (this.grid_panel.getTopToolbar().pageSize !=  ps) {
          //~ console.log("20120206 abort load because toolbar says pagesize",
            //~ this.grid_panel.getTopToolbar().pageSize,
            //~ "while actual pagesize is",ps);
            //~ return;
        //~ }
        
        this.grid_panel.getTopToolbar().pageSize =  ps;
        if (options.params.start == undefined)
            options.params.start = this.grid_panel.getTopToolbar().cursor;
      
    }
      
    this.grid_panel.add_param_values(options.params);
    //~ Lino.insert_subst_user(options.params);
    //~ console.log("20120814 GridStore.load()",options.params,this.baseParams);
    //~ if (FOO > 0) {
        //~ foo.bar = baz;
    //~ } else FOO += 1;
    return Lino.GridStore.superclass.load.call(this,options);
  }
});

Lino.get_current_grid_config = function(panel) {
    return panel.get_current_grid_config();
}

Lino.GridPanel = Ext.extend(Ext.grid.EditorGridPanel,Lino.MainPanel);
Lino.GridPanel = Ext.extend(Lino.GridPanel,Lino.PanelMixin);
Lino.GridPanel = Ext.extend(Lino.GridPanel,{
  quick_search_text : '',
  is_searching : false,
  disabled_in_insert_window : true,
  clicksToEdit:2,
  enableColLock: false,
  autoHeight: false,
  params_panel_hidden : false,
  preview_limit : undefined, 
  //~ loadMask: true,
  //~ viewConfig: {
          //~ getRowClass: Lino.getRowClass,
          //~ emptyText:"$_('No data to display.')"
        //~ },
  loadMask: {msg:"Please wait..."},
  
  constructor : function(config){

    config.plugins = [new Lino.GridFilters()];
    
    
    Lino.GridPanel.superclass.constructor.call(this,config);
    
    //~ if (this.containing_window) {
        //~ console.log("20111206 install refresh");
        //~ this.containing_window.on('show',this.refresh,this);
    //~ }
    
  },
  
  unused_is_loading : function() { 
    if (! this.loadMask.el) return true; // not even rendered: 
    // thanks to Marco Pegoraro http://movableapp.com/2011/09/sencha-touch-loadmask-isvisible/
    var loading = (this.loadMask.el.select('.x-loading-msg').elements.length > 0);
    //~ console.log('20130515 GridPanel.is_loading() returns',loading);
    return loading;
    //~ return this.store.getCount() > 0; 
    //~ return (this.loadMask.el.select('.x-loading-msg').elements.length)
    //~ return !this.viewReady; 
    //~ return this.loadMask.isVisible(); 
    //~ return !this.loadMask.disabled; 
  },
  
  unused_config_containing_window : function(wincfg) { 
      //~ temporarily remove save_grid_config button (see /blog(2012/1107)
      if (wincfg.tools != undefined) 
        wincfg.tools = [
          //~ {handler:this.save_grid_data,
            //~ qtip:"$_("Save Grid Data")",
            //~ scope:this, id:"save_data"}, // 20120814
          {handler:this.save_grid_config,
            qtip:"Save Grid Configuration",
            scope:this, id:"save"}
        ].concat(wincfg.tools);
      //~ wincfg.listeners = { show: ... };
  },
  init_containing_window : function(win) { 
    //~ console.log("20111206 install refresh");
    //~ win.on('show',this.refresh,this);
  },
  
  initComponent : function(){
    
    /* 
    Problem 20111206:
    When a GridPanel is the main item of the window, then it doesn't 
    have it's own header but uses the window's header bar.
    We must do this in initComponent because e.g. in beforerender 
    it's already to late: a header element has been created because 
    there was a title.
    But Lino.Window adds itself as `this.containing_window` 
    only after the GridPanel has been initialized.
    Workaround is to generate a line "params.containing_window = true;" 
    in the handler function.
    */ 
    //~ if (this.containing_window) {
    if (this.is_main_window) {
        //~ console.log(20111206, 'delete title',this.title,'from',this);
        //~ delete this.title;
        this.tools = undefined;  
        this.title = undefined;  /* simply deleting it 
          isn't enough because that would only 
          unhide the title defined in some base class. */
    } 
    //~ else console.log(20111206, 'dont delete title',this.title,'from',this);
    
    /* e.g. when slave gridwindow called from a permalink */
    //~ if (this.base_params) Ext.apply(bp,this.base_params);  
    //~ bp['fmt'] = 'json';
    
    //~ function on_proxy_write( proxy, action,data, response,rs,options) {
      //~ console.log('20120814 on_proxy_write',action,data,response)
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
    //~ }
    //~ function on_proxy_load( proxy, transactionObject, callbackOptions ) {
      //~ console.log('on_proxy_load',transactionObject)
    //~ }
    var proxy = new Ext.data.HttpProxy({ 
      // 20120814 
      url: '/api' + this.ls_url
      ,method: "GET"
      //~ ,url: ADMIN_URL + '/restful' + this.ls_url
      //~ ,restful: true 
      //~ ,listeners: {load:on_proxy_load} 
      //~ ,listeners: {write:on_proxy_write} 
    });
    //~ config.store = new Ext.data.JsonStore({ 
    //~ this.store = new Ext.data.ArrayStore({ 
    this.store = new Lino.GridStore({ 
      grid_panel: this
      ,listeners: { exception: Lino.on_store_exception }
      ,remoteSort: true
      ,totalProperty: "count"
      ,root: "rows"
      //~ ,id: "id" 
      ,proxy: proxy
      //~ autoLoad: this.containing_window ? true : false
      ,idIndex: this.pk_index
      //~ ,baseParams: bp
      ,fields: this.ls_store_fields
      ,idProperty: this.ls_id_property 
      // 20120814
      //~ ,writer : new Ext.data.JsonWriter({
        //~ writeAllFields: false
        //~ ,listful: true
      //~ })
      //~ ,restful : true
    });
      
    //~ console.log('config.pk_index',config.pk_index,config.store),
    delete this.ls_store_fields;
      
    var this_ = this;
    //~ var grid = this;
    this.store.on('load', function() {
        //~ console.log('20120814 GridStore.on(load)',this_.store);
        //~ var da = this_.store.reader.arrayData.disabled_actions;
        //~ if (da) {
            //~ this.cmenu.cascade(function(item){ 
              //~ console.log(20120531, item.itemId, da[item.itemId]);
              //~ if (da[item.itemId]) item.disable(); else item.enable();
            //~ });
        //~ };
        this_.set_param_values(this_.store.reader.arrayData.param_values);
        //~ this_.set_status(this_.store.reader.arrayData.status);
        //~ 20120918
        this.getView().getRowClass = Lino.getRowClass;
        if (this_.store.reader.arrayData.no_data_text) {
            //~ this.viewConfig.emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().refresh();
        }
        if (this_.containing_window)
            this_.set_window_title(this_.store.reader.arrayData.title);
            //~ this_.containing_window.setTitle(this_.store.reader.arrayData.title);
        if (!this.is_searching) { // disabled 20121025: quick_search_field may not lose focus
          this.is_searching = false;
          if (this_.selModel.getSelectedCell){
              if (this_.getStore().getCount()) // there may be no data
                  this_.selModel.select(0,0); 
          } else {
              this_.selModel.selectFirstRow();
              this_.getView().focusEl.focus();
          }
        } 
        //~ else console.log("is_searching -> no focussing");
        //~ var t = this.getTopToolbar();
        //~ var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
        //~ this.quick_search_field.focus(); // 20121024
      }, this
    );
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar, this.cmenu = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ this.cmenu = new Ext.menu.Menu({items: config.bbar});
    delete this.ls_bbar_actions
    if (actions) {
        this.cmenu = actions.cmenu;
    }
    
    if (!this.hide_top_toolbar) {  
      var tbar = [ 
        this.quick_search_field = new Ext.form.TextField({ 
          //~ fieldLabel: "Search"
          listeners: { 
            scope:this_
            //~ ,change:this_.search_change
            
            ,render: Lino.quicktip_renderer("Quick Search","Enter a text to use as quick search filter")
            
            //~ ,keypress: this.search_keypress 
            ,blur: function() { this.is_searching = false}
          }
          ,validator:function(value) { return this_.search_validate(value) }
          //~ ,tooltip: "Enter a quick search text, then press TAB"
          //~ value: text
          //~ scope:this, 
          //~ ,enableKeyEvents: true
          //~ listeners: { keypress: this.search_keypress }, 
          //~ id: "seachString" 
      })];
      tbar = this.add_params_panel(tbar);
      tbar = tbar.concat([
        { scope:this, 
          //~ text: "[csv]", 
          tooltip: "Export this table to a .csv file", 
          iconCls: 'x-tbar-csv',
          handler: function() { 
            //~ 20130116 var p = Ext.apply({},this.get_base_params());
            //~ 20130116 p.fmt = 'csv';
            //~ url += "?" + Ext.urlEncode(p);
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            p.fmt = "csv";
            this.add_param_values(p,true);
            
            window.open('/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } },
        //~ { scope:this, 
          //~ text: "[html]", 
          //~ handler: function() { 
            //~ var p = this.get_current_grid_config();
            //~ Ext.apply(p,this.get_base_params());
            //~ p.$ext_requests.URL_PARAM_FORMAT = "$ext_requests.URL_FORMAT_PRINTER";
            //~ this.add_param_values(p);
            //~ window.open(ADMIN_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          //~ } },
        { scope:this, 
          //~ text: "[html]", 
          tooltip: "Show this table in plain html", 
          iconCls: 'x-tbar-html',
          handler: function() { 
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            //~ since 20121226 p.$ext_requests.URL_PARAM_FORMAT = "$ext_requests.URL_FORMAT_PLAIN";
            this.add_param_values(p,true);
            //~ since 20121226 window.open(ADMIN_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
            window.open('/plain'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } }
        
      ]);
    
    
      var menu = [];
      var set_gc = function(index) {
        return function() {
          //~ console.log('set_gc() 20100812');
          this.getColumnModel().setConfig(
              this.apply_grid_config(index,this.ls_grid_configs,this.ls_columns));
        }
      }
      for (var i = 0; i < this.ls_grid_configs.length;i++) {
        var gc = this.ls_grid_configs[i];
        menu.push({text:gc.label,handler:set_gc(i),scope:this})
      }
      if(menu.length > 1) {
        tbar = tbar.concat([
          { text:"View",
            menu: menu,
            tooltip:"Select another view of this report"
          }
        ]);
      }
      
      if (actions) {
        tbar = tbar.concat(actions.bbar);
          //~ this.bbar = actions.bbar;
      }
      
      this.tbar = new Ext.PagingToolbar({ 
        store: this.store, 
        prependButtons: true, 
        //~ pageSize: this.page_length, 
        pageSize: 1, 
        displayInfo: true, 
        beforePageText: "Page",
        afterPageText: "of {0}",
        displayMsg: "Displaying {0} - {1} of {2}",
        firstText: "First page",
        lastText: "Last page",
        prevText: "Previous page",
        nextText: "Next page",
        items: tbar
      });
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ var ps = this.calculatePageSize();
          //~ if (ps && ps != this.getTopToolbar().pageSize) {
              //~ // console.log('20120203 resize : pageSize',this.getTopToolbar().pageSize,'->',ps);
              //~ // this.getTopToolbar().pageSize =  ps;
              //~ cmp.refresh();
              //~ // this.getTopToolbar().doRefresh();
          //~ }
        //~ }, this);
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ cmp.getTopToolbar().pageSize = this.calculatePageSize(aw,ah,rw,rh) || 10;
          //~ cmp.refresh();
        //~ }, this, {delay:500});
    }
    
    //~ delete this.page_length
    
    
      
    if (this.cell_edit) {
      this.selModel = new Ext.grid.CellSelectionModel()
      this.get_selected = function() {
        //~ console.log(this.getSelectionModel().selection);
        if (this.selModel.selection)
            return [ this.selModel.selection.record ];
        return [this.store.getAt(0)];
      };
      this.get_current_record = function() { 
        if (this.getSelectionModel().selection) 
          return this.selModel.selection.record;
        return this.store.getAt(0);
      };
    } else { 
      this.selModel = new Ext.grid.RowSelectionModel() 
      this.get_selected = function() {
        var sels = this.selModel.getSelections();
        if (sels.length == 0) sels = [this.store.getAt(0)];
        return sels
        //~ var sels = this.getSelectionModel().getSelections();
        //~ return Ext.pluck(sels,'id');
      };
      this.get_current_record = function() { 
        var rec = this.selModel.getSelected();
        if (rec == undefined) rec = this.store.getAt(0);
        return rec
      };
    };
    this.columns  = this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns);
    
    //~ var grid = this;
    //~ this.colModel = new Ext.grid.ColumnModel({
      //~ columns: this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns),
      //~ isCellEditable: function(col, row) {
        //~ var record = grid.store.getAt(row);
        //~ console.log('20120514',col,record); // dataIndex
        //~ var dataIndex = grid.colModel.getDataIndex(col);
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("$_("This field is disabled")");
            //~ return false;
        //~ }
        //~ return Ext.grid.ColumnModel.prototype.isCellEditable.call(this, col, row);
      //~ }
    //~ });    
    
    
    Lino.GridPanel.superclass.initComponent.call(this);
    
    //~ if (this.containing_window) 
        //~ this.on('afterlayout', this.refresh, this);
        //~ this.on('afterrender', this.refresh,this);
    //~ else
        //~ this.on('show', this.refresh,this);
    //~ this.on('afterlayout', function() {
      //~ if (this.id == "ext-comp-1157") 
        //~ console.log("20120213 afterlayout",this); 
      //~ // this.refresh();
      //~ },this);
    //~ this.on('afterrender', this.refresh);
    //~ this.on('resize', this.refresh,this,{delay:500});
    //~ this.on('resize', function(){console.log("20120213 resize",arguments)},this);
    this.on('resize', function(){
      //~ console.log("20120213 resize",arguments)
      this.refresh();
      },this);
    this.on('viewready', function(){
      //~ console.log("20120213 resize",arguments);
      this.view_is_ready = true;
      this.refresh(); // removed 20130911
      },this);
    this.on('afteredit', this.on_afteredit); // 20120814
    //~ this.on('afteredit', this.new_on_afteredit);
    this.on('beforeedit', this.on_beforeedit);
    this.on('beforeedit',function(e) { this.before_row_edit(e.record)},this);
    if (this.cell_edit) {
        this.on('cellcontextmenu', Lino.cell_context_menu, this);
    } else {
        this.on('rowcontextmenu', Lino.row_context_menu, this);
    }
    //~ this.on('contextmenu', Lino.grid_context_menu, this);
    
    
    //~ if (this.id == "ext-comp-1157") captureEvents(this);    
    
    delete this.cell_edit;
    
  },
  
  //~ onResize : function(){
      //~ console.log("20120206 GridPanel.onResize",arguments);
      //~ Lino.GridPanel.superclass.onResize.apply(this, arguments);
      //~ this.refresh();
  //~ },
  
  
  get_status : function(){
    var st = { base_params : this.get_base_params()};
    if (!this.hide_top_toolbar) {
        st.current_page = this.getTopToolbar().current;
    }
    st.param_values = this.status_param_values;
    //~ console.log("20120213 GridPanel.get_status",st);
    return st;
  },
  
  /* 
  Lino.GridPanel.set_status() 
  */
  set_status : function(status){
    //~ console.log("20130605 GridPanel.set_status",status);
    this.clear_base_params();
    if (status == undefined) status = {};
    this.set_param_values(status.param_values);
    if (status.base_params) { 
      this.set_base_params(status.base_params);
    }
    if (status.show_params_panel != undefined) {
        if (this.toggle_params_panel_btn) {
            //~ this.toggle_params_panel_btn.toggle(status.show_params_panel=='true');
            this.toggle_params_panel_btn.toggle(status.show_params_panel);
        }
    }
    if (!this.hide_top_toolbar) {
      //~ console.log("20120213 GridPanel.getTopToolbar().changePage",
          //~ status.current_page || 1);
      this.getTopToolbar().changePage(status.current_page || 1);
    }
    //~ this.fireEvent('resize');
    //~ this.refresh.defer(100,this); 
    //~ this.onResize.defer(100,this); 
    //~ this.refresh(); 
    //~ this.doLayout(); 
    //~ this.onResize(); 
    //~ this.store.load();
  },
  
  refresh : function(unused) { 
    this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ Lino.notify('Lino.GridPanel.refresh '+this.store.proxy.url);
    //~ var bp = { fmt:'json' }
    if (! this.view_is_ready) return;
    
    if (this.containing_panel) {
        //~ Ext.apply(p,this.master_panel.get_master_params());
        //~ Ext.apply(options.params,this.containing_panel.get_master_params());
        this.set_base_params(this.containing_panel.get_master_params());
        // 20130911
        if (!this.store.baseParams.mk) {  
            return;
        }
    }
    
    
    //~ console.log('20130911 Lino.GridPanel.refresh_with_after',this.containing_panel.get_master_params());
    
    var options = {};
    if (after) {
        options.callback = function(r,options,success) {if(success) after()}
    }
      
    //~ if (!this.rendered) {
        //~ console.log("20120206 GridPanel.refresh() must wait until rendered",options);
        //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
        //~ return;
    //~ }
    
    this.store.load(options);
  },
  
  /* pageSize depends on grid height (Trying to remove scrollbar)
  Thanks to 
  - Christophe Badoit on http://www.sencha.com/forum/showthread.php?82647
  - http://www.sencha.com/forum/archive/index.php/t-37231.html
  */
  calculatePageSize : function(second_attempt) {
    //~ if (!this.rendered) { 
    if (!this.view_is_ready) { 
      //~ console.log('Cannot calculatePageSize() : not rendered');
      return false; }
    //~ if (!this.isVisible()) { 
      //~ console.log('calculatePageSize : not visible');
      //~ return false; }
      
    //~ console.log('getFrameHeight() is',this.getFrameHeight());
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('mainBody.getHeight() is',this.getView().mainBody.getHeight());
    //~ console.log('getInnerHeight() is',this.getInnerHeight());
    //~ console.log('getHeight() is',this.getHeight());
    //~ console.log('el.getHeight() is',this.getEl().getHeight());
    //~ console.log('getGridEl().getHeight() is',this.getGridEl().getHeight());
    //~ console.log('getOuterSize().height is',this.getOuterSize().height);
    //~ console.log('getBox().height is',this.getBox().height);
    //~ console.log('getResizeEl.getHeight() is',this.getResizeEl().getHeight());
    //~ console.log('getLayoutTarget().getHeight() is',this.getLayoutTarget().getHeight());
      
    //~ var rowHeight = 52; // experimental value
    var row = this.view.getRow(0);
    if (row) {
      //~ console.log('20120213 yes');
      var rowHeight = Ext.get(row).getHeight();
    } else {
        //~ var rowHeight = this.getFrameHeight();
        //~ var rowHeight = 10; // reasonably smallest approximative value
        //~ There is no data yet. Construct a fake row and get its height
        var Element = Ext.Element;
        var gv = this.view;
        var fakeBody = new Element(Element.fly(gv.scroller).child('div.x-grid3-body'));
        var rowTemplate = gv.templates.row;
        var cellTemplate = gv.templates.cell;
        var tstyle  = 'width:' + gv.getGridInnerWidth() + 'px;';
        var cells = cellTemplate.apply({value:'&#160;'});
        var markup = rowTemplate.apply({
                tstyle: tstyle,
                cols  : 1,
                cells : cells,
                alt   : ''
            });        
        fakeBody.dom.innerHTML = gv.templates.body.apply({rows: markup});
        var row = fakeBody.dom.childNodes[0];
        var rowHeight = Ext.get(row).getHeight();
    }
    //~ console.log('rowHeight is ',rowHeight,this,caller);
    //~ this.getView().syncScroll();
    //~ this.getView().initTemplates();
    var height = this.getView().scroller.getHeight();
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('getInnerHeight() - getFrameHeight() is',
      //~ this.getInnerHeight(), '-',
      //~ this.getFrameHeight(), '=',
      //~ this.getInnerHeight() - this.getFrameHeight());
    //~ var height = this.getView().mainBody.getHeight();
    //~ var height = this.getView().mainWrap.getHeight();
    //~ var height = this.getView().resizeMarker.getHeight();
    //~ this.syncSize();
    //~ var height = this.getInnerHeight() - this.getFrameHeight();
    //~ var height = this.getHeight() - this.getFrameHeight();
    height -= Ext.getScrollBarWidth(); // leave room for a possible horizontal scrollbar... 
    //~ height -= this.getView().scrollOffset;
    var ps = Math.floor(height / rowHeight);
    //~ console.log('20130816 calculatePageSize():',height,'/',rowHeight,'->',ps);
    ps -= 1; // leave room for a possible phantom row
    //~ return (ps > 1 ? ps : false);
    if (ps > 1) return ps;
    //~ console.log('calculatePageSize() found less than 1 row:',height,'/',rowHeight,'->',ps);
    //~ foo.bar = baz; // 20120213
    return 5; // preview_limit
    //~ if (second_attempt) {
        //~ console.log('calculatePageSize() abandons after second attempt:',
          //~ height,'/',rowHeight,'->',ps);
      //~ return 5;
    //~ }
    //~ return this.calculatePageSize.defer(500,this,[true]);
  },
  
  onCellDblClick : function(grid, row, col){
      //~ console.log("20120307 onCellDblClick",this,grid, row, col);
      if (this.ls_detail_handler) {
          //~ Lino.notify('show detail');
          Lino.show_detail(this);
          return false;
      }else{
        //~ console.log('startEditing');
        this.startEditing(row,col);
      }
  },
  
  get_base_params : function() {
    //~ return this.containing_window.config.base_params;
    //~ console.log(20120717,this.store.baseParams);
    var p = Ext.apply({},this.store.baseParams);
    Lino.insert_subst_user(p);
    //~ console.log("20120717 GRidPanel.get_base_params() returns",p);
    return p;
    //~ return this.store.baseParams;
  },
  set_base_params : function(p) {
    //~ console.log('20130911 GridPanel.set_base_params',p)
    for (k in p) this.store.setBaseParam(k,p[k]);
    //~ this.store.baseParams = p;
    if (p.query) 
        this.quick_search_field.setValue(p.query);
    //~ if (p.param_values) 
        //~ this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.store.baseParams = {};
      Lino.insert_subst_user(this.store.baseParams);
  },
  set_base_param : function(k,v) {
    this.store.setBaseParam(k,v);
  },
  
  //~ get_permalink_params : function() {
    //~ var p = {};
    //~ return p;
  //~ },
  
  before_row_edit : function(record) {},
    
  //~ search_keypress : function(){
    //~ console.log("2012124 search_keypress",arguments);
  //~ },
  search_validate : function(value) {
    if (value == this.quick_search_text) return true;
    this.is_searching = true;
    //~ console.log('search_validate',value)
    this.quick_search_text = value;
    this.set_base_param('query',value); 
    //~ this.getTopToolbar().changePage(1);
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
    return true;
  },
  
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
  },
  
  apply_grid_config : function(index,grid_configs,rpt_columns) {
    //~ var rpt_columns = this.ls_columns;
    var gc = grid_configs[index];    
    //~ console.log('apply_grid_config() 20100812',name,gc);
    this.gc_name = index;
    if (gc == undefined) {
      return rpt_columns;
      //~ config.columns = config.ls_columns;
      //~ return;
    } 
    //~ delete config.ls_filters
    
    //~ console.log(20100805,config.ls_columns);
    var columns = Array(gc.columns.length);
    for (var j = 0; j < rpt_columns.length;j++) {
      var col = rpt_columns[j];
      for (var i = 0; i < gc.columns.length; i++) {
        if (col.dataIndex == gc.ci[i]) {
          col.width = gc.cw[i];
          col.hidden = gc.ch[i];
          columns[i] = col;
          break;
        }
      }
    }
    
    //~ var columns = Array(rpt_columns.length);
    //~ for (var i = 0; i < rpt_columns.length; i++) {
      //~ columns[i] = rpt_columns[gc.columns[i]];
      //~ columns[i].width = gc.widths[i];
    //~ }
    
    //~ if (gc.hidden_cols) {
      //~ for (var i = 0; i < gc.hidden_cols.length; i++) {
        //~ var hc = gc.hidden_cols[i];
        //~ for (var j = 0; j < columns.length;j++) {
          //~ var col = columns[j];
          //~ if (col.dataIndex == hc) {
            //~ col.hidden = true;
            //~ break
          //~ }
        //~ }
      //~ }
    //~ }
    if (gc.filters) {
      //~ console.log(20100811,'config.ls_filters',config.ls_filters);
      //~ console.log(20100811,'config.ls_grid_config.filters',config.ls_grid_config.filters);
      for (var i = 0; i < gc.filters.length; i++) {
        var fv = gc.filters[i];
        for (var j = 0; j < columns.length;j++) {
          var col = columns[j];
          if (col.dataIndex == fv.field) {
            //~ console.log(20100811, f,' == ',fv);
            if (fv.type == 'string') {
              col.filter.value = fv.value;
              //~ if (fv.comparison !== undefined) f.comparison = fv.comparison;
            } else {
              //~ console.log(20100811, fv);
              col.filter.value = {};
              col.filter.value[fv.comparison] = fv.value;
            }
            break;
          }
        };
      }
    }
    
    return columns;
    //~ config.columns = cols;
    //~ delete config.ls_columns
  },
  
  get_current_grid_config : function () {
    var cm = this.getColumnModel();
    var widths = Array(cm.config.length);
    var hiddens = Array(cm.config.length);
    //~ var hiddens = Array(cm.config.length);
    var columns = Array(cm.config.length);
    //~ var columns = Array(cm.config.length);
    //~ var hidden_cols = [];
    //~ var filters = this.filters.getFilterValues();
    var p = this.filters.buildQuery(this.filters.getFilterData())
    for (var i = 0; i < cm.config.length; i++) {
      var col = cm.config[i];
      columns[i] = col.dataIndex;
      //~ hiddens[i] = col.hidden;
      widths[i] = col.width;
      hiddens[i] = col.hidden;
      //~ if (col.hidden) hidden_cols.push(col.dataIndex);
    }
    //~ p['hidden_cols'] = hidden_cols;
    p.cw = widths;
    p.ch = hiddens;
    p.ci = columns;
    //~ p['widths'] = widths;
    //~ p['hiddens'] = hiddens;
    //~ p['columns'] = columns;
    p['name'] = this.gc_name;
    //~ var gc = this.ls_grid_configs[this.gc_name];
    //~ if (gc !== undefined) 
        //~ p['label'] = gc.label
    //~ console.log('20100810 save_grid_config',p);
    return p;
  },
  
  unused_manage_grid_configs : function() {
    var data = [];
    for (k in this.ls_grid_configs) {
      var v = this.ls_grid_configs[k];
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i)
    }
    if (this.ls_grid_configs[this.gc_name] == undefined) {
      var v = this.get_current_grid_config();
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i);
    }
    //~ console.log(20100811, data);
    var main = new Ext.grid.GridPanel({
      store: new Ext.data.ArrayStore({
        idIndex:0,
        fields:['name','columns','hidden_cols','filters'],
        autoDestroy:true,
        data: data}),
      //~ autoHeight:true,
      selModel: new Ext.grid.RowSelectionModel(),
      listeners: { 
        rowdblclick: function(grid,rowIndex,e) {
          console.log('row doubleclicked',grid, rowIndex,e);
        },
        rowclick: function(grid,rowIndex,e) {
          console.log('row clicked',grid, rowIndex,e);
        }
      },
      columns: [ 
        {dataIndex:'name',header:'Name'}, 
        {dataIndex:'columns',header:'columns'}, 
        {dataIndex:'hidden_cols',header:'hidden columns'}, 
        {dataIndex:'filters',header:'filters'} 
      ]
    });
    var win = new Ext.Window({title:'GridConfigs Manager',layout:'fit',items:main,height:200});
    win.show();
  },
  
  unused_edit_grid_config : function(name) {
    gc = this.ls_grid_configs[name];
    var win = new Ext.Window({
      title:'Edit Grid Config',layout:'vbox', 
      //~ layoutConfig:'stretch'
      items:[
        {xtype:'text', value: gc.name},
        {xtype:'text', value: gc.columns},
        {xtype:'text', value: gc.hidden_cols},
        {xtype:'text', value: gc.filters}
      ]
    });
    win.show();
  },
  
  save_grid_config : function () {
    //~ console.log('TODO: save_grid_config',this);
    //~ p.column_widths = Ext.pluck(this.colModel.columns,'width');
    var a = { 
      params:this.get_current_grid_config(), 
      method:'PUT',
      url:'/grid_config' + this.ls_url,
      success: Lino.action_handler(this),
      scope: this,
      failure: Lino.ajax_error_handler(this)
    };
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(a);
    //~ Lino.do_action(this,a);
  },
  
  on_beforeedit : function(e) {
    //~ console.log('20130128 GridPanel.on_beforeedit()',e,e.record.data.disable_editing);
    if(this.disable_editing | e.record.data.disable_editing) {
      e.cancel = true;
      Lino.notify("This record is disabled");
      return;
    }
    if(e.record.data.disabled_fields && e.record.data.disabled_fields[e.field]) {
      e.cancel = true;
      Lino.notify("This field is disabled");
      return;
    }
    //~ if (e.record.data.disabled_fields) {
      //~ for (i in e.record.data.disabled_fields) {
        //~ if(e.record.data.disabled_fields[i] == e.field) {
          //~ e.cancel = true;
          //~ Lino.notify(String.format('Field "{0}" is disabled for this record',e.field));
          //~ return
        //~ }
      //~ }
    //~ }
  },
  save_grid_data : function() {
      //~ console.log("20120814 save_grid_data");
      this.getStore().commitChanges();
  },
  new_on_afteredit : function(e) {
      //~ this.getStore().commitChanges();
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
      console.log("20120814 new_on_afteredit",e);
  },
  on_afteredit : function(e) {
    /*
    e.grid - The grid that fired the event
    e.record - The record being edited
    e.field - The field name being edited
    e.value - The value being set
    e.originalValue - The original value for the field, before the edit.
    e.row - The grid row index
    e.column - The grid column index
    */
    var p = {};
    //~ console.log('20101130 modified: ',e.record.modified);
    //~ console.log('20101130 value: ',e.value);
    //~ var p = e.record.getChanges();
    //~ console.log('20101130 getChanges: ',e.record.getChanges());
    //~ this.before_row_edit(e.record);
    for(k in e.record.getChanges()) {
        var v = e.record.get(k);
    //~ for(k in e.record.modified) {
        //~ console.log('20101130',k,'=',v);
        //~ var cm = e.grid.getColumnModel();
        //~ var di = cm.getDataIndex(k);
        var f = e.record.fields.get(k);
        //~ console.log('20101130 f = ',f);
        //~ var v = e.record.get(di);
        if (f.type.type == 'date') {
            p[k] = Ext.util.Format.date(v, f.dateFormat);
        }else{
            p[k] = v;
            var v = e.record.get(k+'Hidden');
            if (v !== undefined) {
              p[k+'Hidden'] = v;
            }
        }
        //~ var i = cm.findColumnIndex(k);
        //~ var r = cm.getRenderer(i);
        //~ var editor = cm.getCellEditor(i,e.row);
        //~ var col = e.grid.getColumnModel().getColumnById(k);
        //~ console.log('20101130 r = ',r(v));
        //~ var f = e.record.fields[k];
        //~ console.log('20101130 f = ',f);
        //~ console.log('20101130 editor = ',editor);
        //~ p[k] = f.getValue();
        //~ p[k] = r(v);
    }
    //~ console.log('20101130 p:',p);
    //~ var cm = e.grid.getColumnModel();
    //~ var di = cm.getDataIndex(e.column);
    //~ var f = e.record.fields.get(di);
    //~ console.log('20101130 f = ',f);
    //~ if (f.type.type == 'date') e.record.set(di,Ext.util.Format.date(e.value, f.dateFormat));
    
    
    //~ var p = e.record.data;
    
    // var p = {};
    //~ p['grid_afteredit_colname'] = e.field;
    //~ p[e.field] = e.value;
    //~ console.log('20100723 GridPanel.on_afteredit()',e);
    // add value used by ForeignKeyStoreField CHOICES_HIDDEN_SUFFIX
    // not sure whether this is still needed:
    p[e.field+'Hidden'] = e.value;
    //~ p.su = Lino.subst_user;
    Lino.insert_subst_user(p);
    // this one is needed so that this field can serve as choice context:
    e.record.data[e.field+'Hidden'] = e.value;
    // p[pk] = e.record.data[pk];
    // console.log("grid_afteredit:",e.field,'=',e.value);
    Ext.apply(p,this.get_base_params()); // needed for POST, ignored for PUT
    //~ Ext.apply(p,this.containing_window.config.base_params);
    //~ 20121109 p['$ext_requests.URL_PARAM_ACTION_NAME'] = 'grid';
    var self = this;
    var req = {
        params:p,
        waitMsg: 'Saving your data...',
        success: Lino.action_handler( this, function(result) {
          //~ if (result.data_record) {
          if (result.refresh_all) {
              var cw = self.get_containing_window();
              if (cw) {
                  cw.main_item.refresh();
              }
              else console.log("20120123 cannot refresh_all",self);
          } else if (result.rows) {
              //~ self.getStore().loadData(result,true);
              var r = self.getStore().reader.readRecords(result);
              if (e.record.phantom) {
                  //~ console.log("20120816 afteredit.success POST",r);
                  self.getStore().insert(e.row,r.records);
              }else{
                  //~ console.log("20120816 afteredit.success PUT",r);
                  self.getStore().doUpdate(r.records[0]);
              }
              self.getStore().rejectChanges(); /* 
              get rid of the red triangles without saving the record again
              */
              //~ self.getStore().commitChanges(); // get rid of the red triangles
          } else {
              self.getStore().commitChanges(); // get rid of the red triangles
              self.getStore().reload();        // reload our datastore.
          }
          }),
        scope: this,
        failure: Lino.ajax_error_handler(this)
    };
    if (e.record.phantom) {
      req.params.an = 'post'; // SubmitInsert.action_name
      Ext.apply(req,{
        method: 'POST',
        url: '/api' + this.ls_url
      });
    } else {
      req.params.an = 'put'; // SubmitDetail.action_name
      Ext.apply(req,{
        method: 'PUT',
        url: '/api' + this.ls_url + '/' + e.record.id
      });
    }
    //~ console.log('20110406 on_afteredit',req);
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(req);
  },

  afterRender : function() {
    Lino.GridPanel.superclass.afterRender.call(this);
    // this.getView().mainBody.focus();
    // console.log(20100114,this.getView().getRows());
    // if (this.getView().getRows().length > 0) {
    //  this.getView().focusRow(1);
    // }
    //~ this.my_load_mask = new Ext.LoadMask(this.getEl(), {
        //~ msg:'$_("Please wait...")',
        //~ store:this.store});
      
    var tbar = this.getTopToolbar();
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    // tbar.on('change',function() {this.getSelectionModel().selectFirstRow();this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    this.nav = new Ext.KeyNav(this.getEl(),{
      pageUp: function() {tbar.movePrevious(); },
      pageDown: function() {tbar.moveNext(); },
      home: function() {tbar.moveFirst(); },
      end: function() {tbar.moveLast(); },
      scope: this
    });
  },
  after_delete : function() {
    //~ console.log('Lino.GridPanel.after_delete');
    this.refresh();
  },
  add_row_listener : function(fn,scope) {
    this.getSelectionModel().addListener('rowselect',fn,scope);
  },
  postEditValue : function(value, originalValue, r, field){
    value = Lino.GridPanel.superclass.postEditValue.call(this,value,originalValue,r,field);
    //~ console.log('GridPanel.postEdit()',value, originalValue, r, field);
    return value;
  },
  
  set_start_value : function(v) {
      this.start_value = v;
  },
  preEditValue : function(r, field){
      if (this.start_value) {
        var v = this.start_value;
        delete this.start_value;
        this.activeEditor.selectOnFocus = false;
        return v;
      }
      var value = r.data[field];
      return this.autoEncode && Ext.isString(value) ? Ext.util.Format.htmlDecode(value) : value;
  },
  
  on_master_changed : function() {
    //~ if (! this.enabled) return;
    //~ cmp = this;
    //~ console.log('20130911 Lino.GridPanel.on_master_changed()',this.title,this.rendered);
    if (! this.rendered) return; // 20120213
    var todo = function() {
      if (this.disabled) return;
      //~ if (this.disabled) return;
      //~ if (this.enabled) {
          //~ var src = caller.config.url_data + "/" + record.id + ".jpg"
          //~ console.log(20111125, this.containing_window);
          //~ for (k in p) this.getStore().setBaseParam(k,p[k]);
          //~ console.log('Lino.GridPanel.on_master_changed()',this.title,p);
          this.refresh();
          //~ this.set_base_params(this.master_panel.get_master_params());
          //~ this.getStore().load(); 
      //~ }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  },
  load_record_id : function(record_id,after) {
      Lino.run_detail_handler(this,record_id)
  }
  
});
  

//~ Lino.MainPanelMixin = {
  //~ tbar_items : function() {
      //~ return ;
  //~ }
//~ };

//~ Ext.override(Lino.GridPanel,Lino.MainPanelMixin);
//~ Ext.override(Lino.FormPanel,Lino.MainPanelMixin);

//~ Lino.grid_context_menu = function(e) {
  //~ console.log('contextmenu',arguments);
//~ }

Lino.row_context_menu = function(grid,row,col,e) {
  console.log('20130927 rowcontextmenu',grid,row,col,e,grid.store.reader.arrayData.rows[row]);
}

Lino.cell_context_menu = function(grid,row,col,e) {
  //~ console.log('20120531 cellcontextmenu',grid,row,col,e,grid.store.reader.arrayData.rows[row]);
  e.stopEvent();
  //~ grid.getView().focusCell(row,col);
  grid.getSelectionModel().select(row,col);
  //~ console.log(grid.store.getAt(row));
  //~ grid.getView().focusRow(row);
  //~ return;
  if(!grid.cmenu.el){grid.cmenu.render(); }
  //~ if(e.record.data.disabled_fields) {
  
  var da = grid.store.reader.arrayData.rows[row][grid.disabled_actions_index];
  if (da) {
      this.cmenu.cascade(function(item){ 
        //~ console.log(20120531, item.itemId, da[item.itemId]);
        if (da[item.itemId]) item.disable(); else item.enable();
      });
  };
  
  var xy = e.getXY();
  xy[1] -= grid.cmenu.el.getHeight();
  grid.cmenu.showAt(xy);
}


//~ Lino.load_main_menu = function() {
  //~ Ext.Ajax.request({
    //~ waitMsg: 'Loading main menu...',
    //~ method: 'GET',
    //~ url: '/menu',
    //~ success: Lino.on_load_menu,
    //~ failure: Lino.ajax_error_handler
  //~ });
//~ };



//~ Lino.SlavePlugin = function(caller) {
  //~ this.caller = caller;
//~ };

Lino.chooser_handler = function(combo,name) {
  return function(cmp,newValue,oldValue) {
    //~ console.log('Lino.chooser_handler()',cmp,oldValue,newValue);
    combo.setContextValue(name,newValue);
  }
};



Lino.ComboBox = Ext.extend(Ext.form.ComboBox,{
  forceSelection: true,
  triggerAction: 'all',
  minListWidth:230,
  autoSelect: false,
  selectOnFocus: true, // select any existing text in the field immediately on focus.
  submitValue: true,
  displayField: 'text', // 'text', 
  valueField: 'value', // 'value',
  
  //~ initComponent : Ext.form.ComboBox.prototype.initComponent.createSequence(function() {
  initComponent : function(){
      this.contextParams = {};
      //~ Ext.form.ComboBox.initComponent(this);
      Lino.ComboBox.superclass.initComponent.call(this);
  },
  setValue : function(v,record_data){
      /*
      Based on feature request developed in http://extjs.net/forum/showthread.php?t=75751
      */
      /* `record_data` is used to get the text corresponding to this value */
      //~ if(this.name == 'city') 
      //~ console.log('20120203', this.name,'.setValue(', v ,') this=', this,'record_data=',record_data);
      var text = v;
      if(this.valueField){
        if(v == null || v == '') { 
            //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,'no lookup needed, value is empty');
            //~ v = undefined;
            v = '';
            //~ text = '';
        } else if (Ext.isDefined(record_data)) {
          text = record_data[this.name];
          //~ if (this.name == 'birth_country') 
            //~ console.log(this.name,'.setValue',v,'got text ',text,' from record ',record);
        } else {
          // if(this.mode == 'remote' && !Ext.isDefined(this.store.totalLength)){
          if(this.mode == 'remote' && ( this.lastQuery === null || (!Ext.isDefined(this.store.totalLength)))){
              //~ if (this.name == 'birth_country') console.log(this.name,'.setValue',v,'store not yet loaded');
              this.store.on('load', this.setValue.createDelegate(this, arguments), null, {single: true});
              if(this.store.lastOptions === null || this.lastQuery === null){
                  var params;
                  if(this.valueParam){
                      params = {};
                      params[this.valueParam] = v;
                  }else{
                      var q = this.allQuery;
                      this.lastQuery = q;
                      this.store.setBaseParam(this.queryParam, q);
                      params = this.getParams(q);
                  }
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : call load() with params ',params);
                  this.store.load({params: params});
              //~ }else{
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : but store is loading',this.store.lastOptions);
              }
              return;
          //~ }else{
              //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,' : store is loaded, lastQuery is "',this.lastQuery,'"');
          }
          var r = this.findRecord(this.valueField, v);
          if(r){
              text = r.data[this.displayField];
          }else if(this.valueNotFoundText !== undefined){
              text = this.valueNotFoundText;
          }
        }
      }
      this.lastSelectionText = text;
      //~ this.lastSelectionText = v;
      if(this.hiddenField){
          //~ this.hiddenField.originalValue = v;
          this.hiddenField.value = v;
      }
      Ext.form.ComboBox.superclass.setValue.call(this, text);
      this.value = v; // needed for grid.afteredit
  },
  
  getParams : function(q){
    // p = Ext.form.ComboBox.superclass.getParams.call(this, q);
    // causes "Ext.form.ComboBox.superclass.getParams is undefined"
    var p = {};
    //p[this.queryParam] = q;
    if(this.pageSize){
        //~ p.start = 0;
        //~ p.limit = this.pageSize;
        p['start'] = 0;
        p['limit'] = this.pageSize;
    }
    // now my code:
    if(this.contextParams) Ext.apply(p,this.contextParams);
    //~ if(this.contextParams && this.contextValues) {
      //~ for(i = 0; i <= this.contextParams.length; i++)
        //~ p[this.contextParams[i]] = this.contextValues[i];
    //~ }
    return p;
  },
  setContextValue : function(name,value) {
    //~ console.log('setContextValue',this,this.name,':',name,'=',value);
    //~ if (this.contextValues === undefined) {
        //~ this.contextValues = Array(); // this.contextParams.length);
    //~ }
    if (this.contextParams[name] != value) {
      //~ console.log('setContextValue 1',this.contextParams);
      this.contextParams[name] = value;
      this.lastQuery = null;
      //~ console.log('setContextValue 2',this.contextParams);
    }
  }
});

Lino.ChoicesFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'local'
});


Lino.SimpleRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  forceSelection: true,
  constructor: function(config){
      Lino.SimpleRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value' ], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.ComplexRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  constructor: function(config){
      Lino.ComplexRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value','text'], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.RemoteComboFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'remote',
  //~ forceSelection:false,
  minChars: 2, // default 4 is too much
  queryDelay: 300, // default 500 is maybe slow
  queryParam: 'query', 
  //~ typeAhead: true,
  //~ selectOnFocus: true, // select any existing text in the field immediately on focus.
  resizable: true
});

/*
Thanks to Animal for posting the basic idea:
http://www.sencha.com/forum/showthread.php?15842-2.0-SOLVED-Combobox-twintrigger-clear&p=76130&viewfull=1#post76130

*/
Lino.TwinCombo = Ext.extend(Lino.RemoteComboFieldElement,{
    trigger2Class : 'x-form-search-trigger',
    //~ trigger2Class : 'x-tbar-detail',
    initComponent : function() {
        //~ Lino.TwinCombo.superclass.initComponent.call(this);
        Lino.ComboBox.prototype.initComponent.call(this);
        Ext.form.TwinTriggerField.prototype.initComponent.call(this);
    },
    onTrigger2Click : function() {
        //~ console.log('onTrigger2Click',this,arguments);
    }
  });
//~ Lino.TwinCombo.prototype.initComponent = Ext.form.TwinTriggerField.prototype.initComponent;
Lino.TwinCombo.prototype.getTrigger = Ext.form.TwinTriggerField.prototype.getTrigger;
Lino.TwinCombo.prototype.getOuterSize = Ext.form.TwinTriggerField.prototype.getOuterSize;
Lino.TwinCombo.prototype.initTrigger = Ext.form.TwinTriggerField.prototype.initTrigger;
Lino.TwinCombo.prototype.onTrigger1Click = Ext.form.ComboBox.prototype.onTriggerClick;
//~ Lino.TwinCombo.prototype.onTrigger2Click = function() {
    //~ console.log('onTrigger2Click',arguments);
//~ };



Lino.SimpleRemoteComboFieldElement = Ext.extend(Lino.RemoteComboFieldElement,{
  displayField: 'value', 
  valueField: null,
  forceSelection: false
});




Lino.Window = Ext.extend(Ext.Window,{
  //~ layout: "fit", 
  closeAction : 'hide',
  renderTo: 'main_area', 
  constrain: true,
  maximized: true,
  draggable: false,
  width: 700,
  height: 500,
  maximizable: false,
  constructor : function (config) {
    if (config.main_item.params_panel) {
        config.layout = 'border';
        config.main_item.region = 'center';
        config.main_item.params_panel.region = 'north';
        //~ config.main_item.params_panel.autoHeight = false; // 20130924
        config.main_item.params_panel.hidden = config.main_item.params_panel_hidden;
        config.items = [config.main_item.params_panel, config.main_item];
        //~ 20130923b
    } else {
        config.layout = 'fit';
        config.items = config.main_item;
    }
    this.main_item = config.main_item; 
    
    delete config.main_item;
    //~ delete config.params_item;
    
    //~ this.main_item = config.items.get(0);
    this.main_item.containing_window = this;
    
    //~ console.log('20120110 Lino.Window.constructor() 1');
    //~ if (Lino.current_window) { // all windows except the top are closable
    if (this.main_item.hide_window_title) { 
      config.closable = false;
      config.frame = false;
      config.shadow = false;
      //~ config.border = true;
      //~ config.title = undefined;
      //~ config.tools = null;
      delete config.title;
      delete config.tools;
    } else {
      config.title = this.main_item.empty_title;
      config.closable = true;
      config.tools = [ 
        { qtip: 'permalink', handler: Lino.permalink_handler(this), id: "pin" }
      ];
      if (this.main_item.content_type && this.main_item.action_name != 'insert') {
        config.tools = [ {
          handler: Lino.help_text_editor,
          qtip: "Edit help texts for fields on this model.",
          scope: this.main_item,
          id: "gear"
        }].concat(config.tools);
      }
        
    //~ { qtip: '', handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: this.config.qtip, handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: 'Call doLayout() on main Container.', handler: Lino.refresh_handler(this), id: "refresh" },
    //~ if (this.main_item.params_panel) {
        //~ config.tools = config.tools.concat([ 
          //~ { qtip: 'Show/hide parameter panel', handler: this.toggle_params_panel, id: "gear", scope:this } 
        //~ ]);
    //~ }
    //~ if (config.closable !== false) {
      // if undefined, will take default behaviour
      //~ config.tools = config.tools.concat([ 
        //~ { qtip: 'close', handler: this.hide, id: "close", scope:this } 
      //~ ]);
    }
    
    this.main_item.config_containing_window(config);
    
    //~ console.log('20120110 Lino.Window.constructor() 2');
    Lino.Window.superclass.constructor.call(this,config);
    
    //~ console.log('20120110 Lino.Window.constructor() 3');
    
  },
  initComponent : function() {
    this.main_item.init_containing_window(this);
    Lino.Window.superclass.initComponent.call(this);
  
  },
  hide : function() { 
      this.main_item.do_when_clean(false,function() { 
        Lino.close_window(); });
  },
  hide_really : function() { 
    Lino.Window.superclass.hide.call(this);
  },
  onRender : function(ct, position){
    //~ console.log('20120110 Lino.Window.onRender() 1');
    Lino.Window.superclass.onRender.call(this, ct, position);
    var main_area = Ext.getCmp('main_area')
    //~ console.log('20120110 Lino.Window.onRender() 2');
  
    this.on('show', function(win) {
        //~ console.log('20120110 Lino.Window.on show 1');
        main_area.on('resize', win.onWindowResize, win);
    });
    this.on('hide', function(win) {
        main_area.un('resize', win.onWindowResize, win);
    });
    //~ console.log('20120110 Lino.Window.onRender() 3');
  }
});


Lino.unused_ParamWindow = Ext.extend(Lino.Window,{
  //~ layout: "border", 
  constructor : function (config) {
    Lino.ParamWindow.superclass.constructor.call(this,config);
    this.main_item = config.items; // `items` must be a single component
    config.layout = 'border';
    this.main_item.region = 'center';
    config.params.region = 'north';
    config.items = [config.params, config.items];
    //~ delete config.params;
  }
});




(function(){
    var ns = Ext.ns('Ext.ux.plugins');

    /**
     * @class Ext.ux.plugins.DefaultButton
     * @extends Object
     *
     * Plugin for Button that will click() the button if the user presses ENTER while
     * a component in the button's form has focus.
     *
     * @author Stephen Friedrich
     * @date 09-DEC-2009
     * @version 0.1
     *
     */
    ns.DefaultButton =  Ext.extend(Object, {
        init: function(button) {
            button.on('afterRender', setupKeyListener, button);
        }
    });

    function setupKeyListener() {
        var formPanel = this.findParentByType('form');
        new Ext.KeyMap(formPanel.el, {
            key: Ext.EventObject.ENTER,
            shift: false,
            alt: false,
            fn: function(keyCode, e){
                if(e.target.type === 'textarea' && !e.ctrlKey) {
                    return true;
                }

                this.el.select('button').item(0).dom.click();
                return false;
            },
            scope: this
        });
    }

    Ext.ComponentMgr.registerPlugin('defaultButton', ns.DefaultButton);

})(); 

Ext.override(Ext.form.BasicForm,{
    my_loadRecord : function(values){
    //~ loadRecord : function(record){
        /* Same as ExtJS's loadRecord() (setValues()), except that we 
        forward also the record to field.setValue() so that Lino.Combobox 
        can use it. 
        */
        //~ console.log('20120918 my_loadRecord',values)
        if(Ext.isArray(values)){ 
            for(var i = 0, len = values.length; i < len; i++){
                var v = values[i];
                var f = this.findField(v.id);
                if(f){
                    f.setValue(v.value,values);
                    if(this.trackResetOnLoad){
                        f.originalValue = f.getValue();
                    }
                }
            }
        }else{ 
            var field, id;
            for(id in values){
                if(!Ext.isFunction(values[id]) && (field = this.findField(id))){
                    field.setValue(values[id],values);
                    if(this.trackResetOnLoad){
                        field.originalValue = field.getValue();
                        //~ if (field.hiddenField) {
                          //~ field.hiddenField.originalValue = field.hiddenField.value;
                        //~ }
                    }
                }
            }
        }
        return this;
    }
});




function initializeFooBarDropZone(cmp) {
    //~ console.log('initializeFooBarDropZone',cmp);
    cmp.dropTarget = new Ext.dd.DropTarget(cmp.bwrap, {
      //~ ddGroup     : 'gridDDGroup',
      notifyEnter : function(ddSource, e, data) {
        console.log('notifyEnter',ddSource,e,data);
        //Add some flare to invite drop.
        cmp.body.stopFx();
        cmp.body.highlight();
      },
      notifyDrop  : function(ddSource, e, data){
        console.log('notifyDrop',ddSource,e,data);
        // Reference the record (single selection) for readability
        //~ var selectedRecord = ddSource.dragData.selections[0];


        // Load the record into the form
        //~ formPanel.getForm().my_loadRecord(selectedRecord);


        // Delete record from the grid.  not really required.
        //~ ddSource.grid.store.remove(selectedRecord);

        return(true);
      }
    })
}



Lino.show_mti_child = function(fieldname,detail_handler) {
  //~ console.log('show_mti_child',this);
  //~ console.log('show_mti_child',panel.find("main_area"));
  rec = Lino.current_window.main_item.get_current_record();
  //~ rec = panel.get_current_record();
  if (rec) {
    //~ console.log('show_mti_child',Lino.current_window,rec);
    if (rec.phantom) {
      Lino.notify('Not allowed on phantom record.');
    }else if (rec.data[fieldname]) {
      //~ console.log('show_mti_child',rec.id);
      //~ detail_handler(Lino.current_window.main_item,{},{record_id:rec.id});
      detail_handler.run(null,{record_id:rec.id});
      //~ window.open(urlroot + '/' + rec.id);
      //~ document.location = urlroot + '/' + rec.id;
      //~ window.open(urlroot + '/' + rec.id,'_blank');
    } else {
      Lino.alert("Cannot show MTI child if checkbox is off.");
    }
  } else {
    Lino.notify('No current record.');
  }
};






/*
Mappings towards lino.modlib.cal.models.PanelCalendars
*/
// Sset SS = Ssite.modules.cal.PanelCalendars.get_handle(Sui).store
Ext.ensible.cal.CalendarMappings = {
    CalendarId:   {name:'ID',       mapping: 'id', type: 'int'},
    Title:        {name:'CalTitle', mapping: 'babel_name', type: 'string'},
    Description:  {name:'Desc',     mapping: 'description', type: 'string'},
    ColorId:      {name:'Color',    mapping: 'color', type: 'int'},
    IsHidden:     {name:'Hidden',   mapping: 'is_hidden', type: 'boolean'},    
};
Ext.ensible.cal.CalendarRecord.reconfigure();  


/*
Mappings towards lino.modlib.cal.models.PanelEvents 
*/
// Sset SS = Ssite.modules.cal.PanelEvents.get_handle(Sui).store
Ext.ensible.cal.EventMappings = {
    EventId:     {name: 'ID',        mapping: 'id', type:'int'},
    CalendarId:  {name: 'CalID',     mapping: 'calendarHidden', type: 'int'},
    Title:       {name: 'EvtTitle',  mapping: 'summary'},
    StartDate:   {name: 'StartDt',   mapping: 'start_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s" },
    EndDate:     {name: 'EndDt',     mapping: 'end_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s"},
    RRule:       {name: 'RecurRule', mapping: 'rsetHidden'},
    Location:    {name: 'Location',  mapping: 'placeHidden'},
    Notes:       {name: 'Desc',      mapping: 'description'},
    Url:         {name: 'LinkUrl',   mapping: 'url'},
    IsAllDay:    {name: 'AllDay',    mapping: 'all_day', type: 'boolean'},
    Reminder:    {name: 'Reminder',  mapping: 'reminder'}
    
};
Ext.ensible.cal.EventRecord.reconfigure();


//~ Lino.on_eventclick = 
    
Lino.on_editdetails = 

Lino.format_time = function(dt) {
    return dt.getHours() + ':' + dt.getMinutes();
}
    
Lino.on_eventdelete = function() {
  //~ console.log("Lino.on_eventdelete",arguments);
};

Lino.on_eventadd  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventadd ",arguments);
  return false;
}
    
Lino.on_eventresize  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventresize ",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    
Lino.on_eventupdate  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventupdate",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    

//~ Lino.eventStore = new Ext.ensible.cal.EventStore({ 
//~ Lino.eventStore = new Ext.data.ArrayStore({ 
Lino.unused_eventStore = new Ext.data.JsonStore({ 
  listeners: { exception: Lino.on_store_exception }
  ,url: '/restful/cal/PanelEvents'
  ,restful : true
  ,proxy: new Ext.data.HttpProxy({ 
      //~ url: '/restful/cal/PanelEvents', 
      url: '/restful/cal/PanelEvents', 
      disableCaching: false // no need for cache busting when loading via Ajax
      //~ disableCaching:true,
  })
  ,fields: Ext.ensible.cal.EventRecord.prototype.fields.getRange()
  ,totalProperty: "count"
  ,root: "rows"
  ,idProperty: Ext.ensible.cal.EventMappings.EventId.mapping
  ,writer : new Ext.data.JsonWriter({
    writeAllFields: false
  })
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
      if (!options) options = {};
      if (!options.params) options.params = {};
      //~ options.params.$ext_requests.URL_PARAM_TEAM_VIEW = Lino.calendar_app.team_view_button.pressed;
      
      var view = this.cal_panel.getActiveView();
      var bounds = view.getViewBounds();
      //~ var p = {sd:'05.02.2012',ed:'11.02.2012'};
      //~ var p = {};
      options.params[view.dateParamStart] = bounds.start.format(view.dateParamFormat);
      options.params[view.dateParamEnd] = bounds.end.format(view.dateParamFormat);
      Lino.insert_subst_user(options.params);
      //~ Ext.apply(options.params,p)
      //~ console.log('20120710 eventStore.load()',this.baseParams,options);
    
    return Ext.data.JsonStore.prototype.load.call(this,options);
  }
});

//~ Lino.eventStore.on('load', function() {
//~ });


    //~ Lino.subst_user = id;


//~ Lino.calendarStore = new Ext.data.ArrayStore({ 
Lino.unused_calendarStore = new Ext.data.JsonStore({ 
      listeners: { exception: Lino.on_store_exception }
      ,restful : true
      ,proxy: new Ext.data.HttpProxy({ 
          //~ url: '/restful/cal/PanelCalendars?fmt=json', 
          url: '/restful/cal/PanelCalendars?fmt=%7B%7Bext_requests.URL_FORMAT_JSON%7D%7D', 
          disableCaching: false // no need for cache busting when loading via Ajax
          //~ restful : true
          //~ method: "GET"
      })
      //~ ,autoLoad: true
      //~ ,remoteSort: true
      //~ ,baseParams: bp
      ,totalProperty: "count"
      ,root: "rows"
      ,fields: Ext.ensible.cal.CalendarRecord.prototype.fields.getRange()
      ,idProperty: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
      //~ ,idIndex: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
    });


Lino.CalendarCfg = {
    dateParamFormat: 'd.m.Y',
    dateParamStart:'sd',
    dateParamEnd:'ed'
};
//~ 20120704 Lino.CalendarPanel = Ext.extend(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
//~ Lino.CalendarPanel = Ext.extend(Lino.CalendarPanel,{
Ext.override(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
Ext.override(Ext.ensible.cal.CalendarPanel,{
  //~ empty_title : "\$ui.get_actor('cal.Panel').report.label",
  empty_title : "Calendar"
  ,activeItem: 1 // 0: day, 1: week
  ,ls_url: '/cal/CalendarPanel'
  //~ ,disableCaching:true
  //~ ,eventStore: Lino.eventStore
  //~ ,calendarStore: Lino.calendarStore
  //~ ,initComponent : function(){
    //~ Ext.ensible.cal.CalendarPanel.superclass.initComponent.call(this);
    //~ this.eventStore.on('load',function(){
      //~ console.log("20130808",Lino.eventStore);
      //~ if (this.eventStore.reader.jsonData) {
        //~ console.log("20130808 b",this.eventStore.reader.jsonData.title);
        //~ this.set_window_title(this.eventStore.reader.jsonData.title);
      //~ }
    //~ },this);
  //~ }
  ,listeners: { 
    editdetails: function(cp,rec,el) {
      //~ console.log("Lino.on_editdetails",arguments);
      if (rec.data.ID)
          Lino.cal.PanelEvents.detail.run(null,{
              record_id:rec.data.ID,
              base_params:this.app_instance.event_store.baseParams});
      return false;
    }
    ,eventclick: function(cp,rec,el) {
      //~ console.log("Lino.on_eventclick",arguments);
      //~ Lino.cal.Events.detail_action.run({record_id:rec.data.ID});
      Lino.cal.PanelEvents.detail.run(null,{
            record_id:rec.data.ID,
                base_params:this.app_instance.event_store.baseParams});
      return false;
    }
    //~ ,eventadd: Lino.on_eventadd
    //~ ,eventdelete: Lino.on_eventdelete
    //~ ,eventresize: Lino.on_eventresize
    ,afterrender : function(config) {
      //~ console.log("20120704 afterrender");
      this.app_instance.calendar_store.load();
      //~ console.log("20120704 afterrender calls eventStore.load()",p);
      this.app_instance.event_store.cal_panel = this;
      //~ Lino.eventStore.load({params:p});
      //~ 20130905 removed: this.app_instance.event_store.load();
      //~ Lino.CalendarPanel.superclass.constructor.call(this, config);
      //~ console.log(20120118, config,this);
    }
    }
  ,enableEditDetails: false
  //~ ,monthViewCfg: Lino.CalendarCfg
  //~ ,weekViewCfg: Lino.CalendarCfg
  //~ ,multiDayViewCfg: Lino.CalendarCfg
  //~ ,multiWeekViewCfg: Lino.CalendarCfg
  //~ ,dayViewCfg: Lino.CalendarCfg
  //~ ,initComponent : function() {
    //~ // this.on('eventadd',Lino.on_eventadd);
    //~ Lino.CalendarPanel.superclass.initComponent.call(this);
  //~ }
});




Lino.CalendarAppPanel = Ext.extend(Ext.Panel,Lino.MainPanel);
Lino.CalendarAppPanel = Ext.extend(Lino.CalendarAppPanel,Lino.PanelMixin);
Lino.CalendarAppPanel = Ext.extend(Lino.CalendarAppPanel,{
  app_instance : null
  //~ empty_title : "\$ui.get_actor('cal.Panel').report.label",
  ,empty_title : "Calendar"
  ,ls_url: '/cal/CalendarPanel'
  ,set_status : function(status,rp) { 
      this.requesting_panel = Ext.getCmp(rp);
      //~ console.log('20120918 CalendarAppPanel.set_status()',status,rp,this.requesting_panel);
      this.clear_base_params();
      if (status == undefined) status = {};
      //~ if (status.param_values) 
      //~ this.set_field_values(status.field_values);
      if (status.base_params) this.set_base_params(status.base_params);
      this.refresh();
      }
  ,refresh : function() {
      //~ this.app_instance.event_store.reload(); 20130905
      this.app_instance.event_store.load();
  }
  ,layout: 'fit'
  ,get_base_params : function() {
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
  }
  ,set_base_params : function(p) {
    this.base_params = Ext.apply(this.app_instance.event_store.baseParams,p);
    this.app_instance.event_store.baseParams = this.base_params;
  }
  ,clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  }
  ,set_base_param : function(k,v) {
      if (!this.base_params) this.base_params = {};
      this.base_params[k] = v;
  }
});

Lino.CalendarApp = function() { return {
  team_view_button : null 
  ,get_main_panel : function() {
      var cap = null;
      this.event_store = new Ext.data.JsonStore({ 
          listeners: { exception: Lino.on_store_exception }
          //~ ,url: '/restful/cal/PanelEvents'
          ,url: '//restful/cal/PanelEvents'
          ,restful : true
          ,proxy: new Ext.data.HttpProxy({ 
              //~ url: '/restful/cal/PanelEvents', 
              url: '//restful/cal/PanelEvents', 
              disableCaching: false // no need for cache busting when loading via Ajax
              //~ disableCaching:true,
          })
          ,fields: Ext.ensible.cal.EventRecord.prototype.fields.getRange()
          ,totalProperty: "count"
          ,root: "rows"
          ,idProperty: Ext.ensible.cal.EventMappings.EventId.mapping
          ,writer : new Ext.data.JsonWriter({
            writeAllFields: false
          })
          ,load: function(options) {
            //~ foo.bar = baz; // 20120213
              if (!options) options = {};
              if (!options.params) options.params = {};
              //~ options.params.$ext_requests.URL_PARAM_TEAM_VIEW = Lino.calendar_app.team_view_button.pressed;
              
              var view = this.cal_panel.getActiveView();
              var bounds = view.getViewBounds();
              //~ var p = {sd:'05.02.2012',ed:'11.02.2012'};
              //~ var p = {};
              options.params[view.dateParamStart] = bounds.start.format(view.dateParamFormat);
              options.params[view.dateParamEnd] = bounds.end.format(view.dateParamFormat);
              Lino.insert_subst_user(options.params);
              //~ this.cal_panel.base_params.su.toString();
              //~ if (this.cal_panel) {
                  Ext.apply(options.params,this.cal_panel.base_params);
              //~ }
              //~ Ext.apply(options.params,p)
              //~ console.log('20130905 eventStore.load()',this.cal_panel,this.baseParams,options.params);
            
            return Ext.data.JsonStore.prototype.load.call(this,options);
          }
      });

      //~ Lino.calendarStore
      this.calendar_store = new Ext.data.JsonStore({ 
          listeners: { exception: Lino.on_store_exception }
          ,restful : true
          ,proxy: new Ext.data.HttpProxy({ 
              //~ url: '/restful/cal/PanelCalendars?fmt=json', 
              url: '/restful/cal/PanelCalendars?fmt=%7B%7Bext_requests.URL_FORMAT_JSON%7D%7D', 
              disableCaching: false // no need for cache busting when loading via Ajax
              //~ restful : true
              //~ method: "GET"
          })
          //~ ,autoLoad: true
          //~ ,remoteSort: true
          //~ ,baseParams: bp
          ,totalProperty: "count"
          ,root: "rows"
          ,fields: Ext.ensible.cal.CalendarRecord.prototype.fields.getRange()
          ,idProperty: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
          //~ ,idIndex: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
      });
      
      cap = new Lino.CalendarAppPanel({ 
          app_instance: this, 
          items : 
        //~ [{
          //~ id: 'app-header',
          //~ region: 'north',
          //~ height: 35,
          //~ border: false,
          // contentEl: 'app-header-content'
        //~ },
      {
          id: 'app-center',
          title: '...', // will be updated to the current view's date range
          region: 'center',
          layout: 'border',
          listeners: {
              'afterrender': function(){
                  Ext.getCmp('app-center').header.addClass('app-center-header');
              }
          },
          items: [{
              id:'app-west',
              region: 'west',
              width: 176,
              border: false,
              items: [{
                  xtype: 'datepicker',
                  id: 'app-nav-picker',
                  cls: 'ext-cal-nav-picker',
                  listeners: {
                      'select': {
                          fn: function(dp, dt){
                              //~ Lino.calendarPanel.setStartDate(dt);
                              this.setStartDate(dt);
                          },
                          scope: this
                      }
                  }
              //~ },{ 
                //~ layout:'fit',
                //~ items: [
                  //~ new Ext.form.Checkbox({
                    //~ boxLabel:"$_('Team view')",
                    //~ hideLabel:true
                    //~ listeners: { click: }
                  //~ })
                //~ ]
              },{ 
                layout:'form',
                items: [
                  this.team_view_button = new Ext.Button({
                    text:"Team view",
                    enableToggle:true,
                    pressed:false,
                    toggleHandler: function(btn,state) { 
                      //~ console.log('20120716 teamView.toggle()');
                      this.event_store.setBaseParam('tv',state);
                      this.event_store.load();
                      //~ Lino.eventStore.load({params:{$ext_requests.URL_PARAM_TEAM_VIEW:state}});
                      //~ console.log("team view",state);
                    }
                  })
                ]
              },{
                  xtype: 'extensible.calendarlist',
                  store: this.calendar_store,
                  border: false,
                  width: 175
              }]
          },{
              xtype: 'extensible.calendarpanel', // Ext.ensible.cal.CalendarPanel
              eventStore: this.event_store,
              app_instance: this,
              calendarStore: this.calendar_store,
              border: false,
              id:'app-calendar',
              region: 'center',
              //~ activeItem: 3, // month view
              
              // Any generic view options that should be applied to all sub views:
              viewConfig: {
                  // Lino.CalendarCfg
                  dateParamFormat: 'd.m.Y',
                  dateParamStart:'sd',
                  dateParamEnd:'ed',
                
                  //enableFx: false,
                  //ddIncrement: 10, //only applies to DayView and subclasses, but convenient to put it here
                  viewStartHour: 8,
                  viewEndHour: 18
                  //minEventDisplayMinutes: 15
              },
              
              // View options specific to a certain view (if the same options exist in viewConfig
              // they will be overridden by the view-specific config):
              monthViewCfg: {
                  showHeader: true,
                  showWeekLinks: true,
                  showWeekNumbers: true,
                  eventBodyMarkup: ['{Title}',
                    //~ '<tpl if="url">',
                        //~ '<a href="{url}">XX</a>',
                    //~ '</tpl>',
                    '<tpl if="_isReminder">',
                        '<i class="ext-cal-ic ext-cal-ic-rem">&#160;</i>',
                    '</tpl>',
                    '<tpl if="_isRecurring">',
                        '<i class="ext-cal-ic ext-cal-ic-rcr">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanLeft">',
                        '<i class="ext-cal-spl">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanRight">',
                        '<i class="ext-cal-spr">&#160;</i>',
                    '</tpl>'
                ].join('')
              },
              
              multiWeekViewCfg: {
                  //weekCount: 3
              },
              
              // Some optional CalendarPanel configs to experiment with:
              //readOnly: true,
              //showDayView: false,
              //showMultiDayView: true,
              //showWeekView: false,
              //showMultiWeekView: false,
              //showMonthView: false,
              //showNavBar: false,
              //showTodayText: false,
              //showTime: false,
              //editModal: true,
              //enableEditDetails: false,
              //title: 'My Calendar', // the header of the calendar, could be a subtitle for the app
              
              // Once this component inits it will set a reference to itself as an application
              // member property for easy reference in other functions within App.
              //~ initComponent: function() {
                  //~ Lino.calendarPanel = this;
                  //~ this.constructor.prototype.initComponent.apply(this, arguments);
              //~ },
              
              listeners: {
                  //~ 'eventclick': {
                      //~ fn: function(vw, rec, el){
                          //~ this.clearMsg();
                      //~ },
                      //~ scope: this
                  //~ },
                  'eventover': function(vw, rec, el){
                      //console.log('Entered evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]', view='+ vw.id +', el='+el.id);
                  },
                  'eventout': function(vw, rec, el){
                      //console.log('Leaving evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]+', view='+ vw.id +', el='+el.id);
                  },
                  'eventadd': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was added');
                      },
                      scope: this
                  },
                  'eventupdate': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(cp, rec){
                          //this.eventStore.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'eventcancel': {
                      fn: function(cp, rec){
                          // edit canceled
                      },
                      scope: this
                  },
                  'viewchange': {
                      fn: function(p, vw, dateInfo){
                          if(this.editWin){
                              this.editWin.hide();
                          };
                          if(dateInfo !== null){
                              // will be null when switching to the event edit form so ignore
                              Ext.getCmp('app-nav-picker').setValue(dateInfo.activeDate);
                              this.updateTitle(dateInfo.viewStart, dateInfo.viewEnd);
                          }
                          
                      },
                      scope: this
                  },
                  'dayclick': {
                      fn: function(vw, dt, ad, el){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'rangeselect': {
                      fn: function(vw, dates, onComplete){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'eventmove': {
                      fn: function(vw, rec){
                          rec.commit();
                          var time = rec.data[Ext.ensible.cal.EventMappings.IsAllDay.name] ? '' : ' \\a\\t g:i a';
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was moved to '+
                              rec.data[Ext.ensible.cal.EventMappings.StartDate.name].format('F jS'+time));
                      },
                      scope: this
                  },
                  'eventresize': {
                      fn: function(vw, rec){
                          rec.commit();
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(win, rec){
                          this.event_store.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'initdrag': {
                      fn: function(vw){
                          if(this.editWin && this.editWin.isVisible()){
                              this.editWin.hide();
                          }
                      },
                      scope: this
                  }
              }
          }]
        }
        //~ ]
        
      });
      
      this.event_store.on('load',function(){
        //~ console.log("20130905 on event_store load",this.event_store.reader.jsonData);
        if (this.event_store.reader.jsonData) {
          //~ console.log("20130808 b",this.event_store.reader.jsonData.title);
          //~ console.log("20130808 c",this);
          cap.set_window_title(this.event_store.reader.jsonData.title);
        }
      },this);
      
      //~ cap.app_instance = this;
      return cap;
      
  }
  ,updateTitle: function(startDt, endDt){
      var p = Ext.getCmp('app-center');
      
      if(startDt.clearTime().getTime() == endDt.clearTime().getTime()){
          p.setTitle(startDt.format('F j, Y'));
      }
      else if(startDt.getFullYear() == endDt.getFullYear()){
          if(startDt.getMonth() == endDt.getMonth()){
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('j, Y'));
          }
          else{
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('F j, Y'));
          }
      }
      else{
          p.setTitle(startDt.format('F j, Y') + ' - ' + endDt.format('F j, Y'));
      }
  }
  // This is an application-specific way to communicate CalendarPanel event messages back to the user.
  // This could be replaced with a function to do "toast" style messages, growl messages, etc. This will
  // vary based on application requirements, which is why it's not baked into the CalendarPanel.
  ,showMsg: function(msg){
      Lino.notify(msg);
      //~ Ext.fly('app-msg').update(msg).removeClass('x-hidden');
  }
  
  ,clearMsg: function(){
      Lino.notify('');
      //~ Ext.fly('app-msg').update('').addClass('x-hidden');
  }
}
};




/*
captureEvents utility by Aaron Conran
<http://www.sencha.com/learn/grid-faq/>

Ext.onReady(function(){
    var grid = new Ext.grid.GridPanel({
        ... 
    });
    captureEvents(grid);
});
*/
function captureEvents(observable) {
    Ext.util.Observable.capture(
        observable,
        function(eventName) {
            console.info(eventName);
        },
        this
    );		
}
 






Lino.main_menu = [ { "menu": { "items": [ { "text": "My Projects", "handler": function() {Lino.projects.MyProjects.grid.run(null)} } ] }, "text": "Projects" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "Upload Types", "handler": function() {Lino.uploads.UploadTypes.grid.run(null)} }, { "text": "Nodes", "handler": function() {Lino.pages.Pages.grid.run(null)} } ] }, "text": "Office" }, { "menu": { "items": [ { "text": "Site Parameters", "iconCls": "x-tbar-application_form", "handler": function() {Lino.system.SiteConfigs.detail.run(null,{ "record_id": 1 })} }, { "text": "Users", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows the list of all users on this site.") }, "handler": function() {Lino.users.Users.grid.run(null)} }, { "text": "Teams", "handler": function() {Lino.users.Teams.grid.run(null)} }, { "text": "content types", "handler": function() {Lino.system.ContentTypes.grid.run(null)} }, { "text": "Help Texts", "handler": function() {Lino.system.HelpTexts.grid.run(null)} } ] }, "text": "System" }, { "menu": { "items": [ { "text": "company types", "handler": function() {Lino.contacts.CompanyTypes.grid.run(null)} }, { "text": "Functions", "handler": function() {Lino.contacts.RoleTypes.grid.run(null)} } ] }, "text": "Contacts" }, { "menu": { "items": [ { "text": "Project Types", "handler": function() {Lino.projects.ProjectTypes.grid.run(null)} } ] }, "text": "Projects" } ] }, "text": "Configure" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "Uploads", "handler": function() {Lino.uploads.Uploads.grid.run(null)} } ] }, "text": "Office" }, { "menu": { "items": [ { "text": "Authorities", "handler": function() {Lino.users.Authorities.grid.run(null)} }, { "text": "User Groups", "handler": function() {Lino.lino.UserGroups.grid.run(null)} }, { "text": "User Levels", "handler": function() {Lino.lino.UserLevels.grid.run(null)} }, { "text": "User Profiles", "handler": function() {Lino.lino.UserProfiles.grid.run(null)} } ] }, "text": "System" }, { "menu": { "items": [ { "text": "Contact Persons", "handler": function() {Lino.contacts.Roles.grid.run(null)} } ] }, "text": "Contacts" }, { "menu": { "items": [ { "text": "Projects", "handler": function() {Lino.projects.Projects.grid.run(null)} } ] }, "text": "Projects" }, { "menu": { "items": [ { "text": "Event states", "listeners": { "render": Lino.quicktip_renderer("Foo","The possible states of a calendar event.") }, "handler": function() {Lino.cal.EventStates.grid.run(null)} }, { "text": "Guest states", "handler": function() {Lino.cal.GuestStates.grid.run(null)} }, { "text": "Task states", "handler": function() {Lino.cal.TaskStates.grid.run(null)} } ] }, "text": "Calendar" } ] }, "text": "Explorer" }, { "menu": { "items": [ { "text": "About", "listeners": { "render": Lino.quicktip_renderer("Foo","Show information about this site.") }, "handler": function() {Lino.about.About.show.run(null,{ "record_id": -99998 })} } ] }, "text": "Site" }, { "text": "Home", "handler": function() {Lino.close_all_windows()} } ];
Ext.namespace('Lino.system.SiteConfigs')
Ext.namespace('Lino.system.ContentTypes')
Ext.namespace('Lino.system.HelpTexts')
Ext.namespace('Lino.system.TextFieldTemplates')
Ext.namespace('Lino.users.Users')
Ext.namespace('Lino.users.MySettings')
Ext.namespace('Lino.users.UsersOverview')
Ext.namespace('Lino.users.Teams')
Ext.namespace('Lino.users.Memberships')
Ext.namespace('Lino.users.Authorities')
Ext.namespace('Lino.countries.Countries')
Ext.namespace('Lino.countries.Cities')
Ext.namespace('Lino.contacts.CompanyTypes')
Ext.namespace('Lino.contacts.Partners')
Ext.namespace('Lino.contacts.Persons')
Ext.namespace('Lino.contacts.Companies')
Ext.namespace('Lino.contacts.RoleTypes')
Ext.namespace('Lino.contacts.Roles')
Ext.namespace('Lino.projects.ProjectTypes')
Ext.namespace('Lino.projects.Projects')
Ext.namespace('Lino.outbox.Recipients')
Ext.namespace('Lino.outbox.Mails')
Ext.namespace('Lino.outbox.Attachments')
Ext.namespace('Lino.cal.Calendars')
Ext.namespace('Lino.cal.Subscriptions')
Ext.namespace('Lino.cal.Rooms')
Ext.namespace('Lino.cal.Priorities')
Ext.namespace('Lino.cal.Events')
Ext.namespace('Lino.cal.OneEvent')
Ext.namespace('Lino.cal.MyEvents')
Ext.namespace('Lino.cal.MyAssignedEvents')
Ext.namespace('Lino.cal.Tasks')
Ext.namespace('Lino.cal.MyTasks')
Ext.namespace('Lino.cal.GuestRoles')
Ext.namespace('Lino.cal.Guests')
Ext.namespace('Lino.cal.MyPresences')
Ext.namespace('Lino.cal.MyPendingPresences')
Ext.namespace('Lino.cal.MyGuests')
Ext.namespace('Lino.cal.PanelCalendars')
Ext.namespace('Lino.cal.PanelEvents')
Ext.namespace('Lino.uploads.UploadTypes')
Ext.namespace('Lino.uploads.Uploads')
Ext.namespace('Lino.pages.Pages')
Ext.namespace('Lino.sessions.SessionTable')
Ext.namespace('Lino.system.MyTextFieldTemplates')
Ext.namespace('Lino.users.MembershipsByUser')
Ext.namespace('Lino.users.AuthoritiesGiven')
Ext.namespace('Lino.users.AuthoritiesTaken')
Ext.namespace('Lino.countries.CitiesByCity')
Ext.namespace('Lino.countries.CitiesByCountry')
Ext.namespace('Lino.contacts.PartnersByCity')
Ext.namespace('Lino.contacts.PartnersByCountry')
Ext.namespace('Lino.contacts.RolesByCompany')
Ext.namespace('Lino.contacts.RolesByPerson')
Ext.namespace('Lino.projects.MyProjects')
Ext.namespace('Lino.outbox.RecipientsByMail')
Ext.namespace('Lino.outbox.MyOutbox')
Ext.namespace('Lino.outbox.MailsByUser')
Ext.namespace('Lino.outbox.MailsByProject')
Ext.namespace('Lino.outbox.SentByPartner')
Ext.namespace('Lino.outbox.AttachmentsByMail')
Ext.namespace('Lino.cal.SubscriptionsByCalendar')
Ext.namespace('Lino.cal.SubscriptionsByUser')
Ext.namespace('Lino.cal.EventsByCalendar')
Ext.namespace('Lino.cal.EventsByRoom')
Ext.namespace('Lino.cal.EventsByProject')
Ext.namespace('Lino.cal.TasksByUser')
Ext.namespace('Lino.cal.TasksByProject')
Ext.namespace('Lino.cal.GuestsByEvent')
Ext.namespace('Lino.cal.GuestsByRole')
Ext.namespace('Lino.cal.GuestsByPartner')
Ext.namespace('Lino.uploads.MyUploads')
Ext.namespace('Lino.uploads.UploadsByController')
Ext.namespace('Lino.system.HelpTextsByModel')
Ext.namespace('Lino.cal.TasksByController')
Ext.namespace('Lino.outbox.MailsByController')
Ext.namespace('Lino.outbox.AttachmentsByController')
Ext.namespace('Lino.cal.EventsByController')
Ext.namespace('Lino.about.Models')
Ext.namespace('Lino.about.FieldsByModel')
Ext.namespace('Lino.about.Inspector')
Ext.namespace('Lino.about.SourceFiles')
Ext.namespace('Lino.lino.Report')
Ext.namespace('Lino.about.About')
Ext.namespace('Lino.system.Home')
Ext.namespace('Lino.cal.CalendarPanel')
Ext.namespace('Lino.outbox.RecipientType')
Ext.namespace('Lino.cal.EventEvents')
Ext.namespace('Lino.cal.EventStates')
Ext.namespace('Lino.cal.AccessClasses')
Ext.namespace('Lino.cal.TaskStates')
Ext.namespace('Lino.lino.YesNo')
Ext.namespace('Lino.countries.CityTypes')
Ext.namespace('Lino.cal.DurationUnits')
Ext.namespace('Lino.lino.UserProfiles')
Ext.namespace('Lino.lino.Genders')
Ext.namespace('Lino.cal.Recurrencies')
Ext.namespace('Lino.cal.Weekdays')
Ext.namespace('Lino.lino.UserGroups')
Ext.namespace('Lino.lino.UserLevels')
Ext.namespace('Lino.cal.GuestStates')

// ChoiceLists: 
Lino.outbox.RecipientType = [ [ "to", "to" ], [ "cc", "cc" ], [ "bcc", "bcc" ] ];
Lino.cal.EventEvents = [ [ "10", "Okay" ], [ "20", "Pending" ] ];
Lino.cal.EventStates = [ [ "10", "Suggested" ], [ "20", "Draft" ], [ "50", "Took place" ], [ "70", "Cancelled" ] ];
Lino.cal.AccessClasses = [ [ "10", "Private" ], [ "20", "Show busy" ], [ "30", "Public" ] ];
Lino.cal.TaskStates = [ [ "10", "To do" ], [ "20", "Started" ], [ "30", "Done" ], [ "50", "Cancelled" ] ];
Lino.lino.YesNo = [ [ "y", "Yes" ], [ "n", "No" ] ];
Lino.countries.CityTypes = [ [ "10", "Member State" ], [ "11", "Division" ], [ "12", "Region" ], [ "13", "Community" ], [ "14", "Territory" ], [ "20", "County" ], [ "21", "Province" ], [ "22", "Shire" ], [ "23", "Subregion" ], [ "24", "Department" ], [ "25", "Arrondissement" ], [ "26", "Prefecture" ], [ "27", "District" ], [ "28", "Sector" ], [ "50", "City" ], [ "51", "Town" ], [ "52", "Municipality" ], [ "54", "Parish" ], [ "55", "Township" ], [ "56", "Quarter" ], [ "61", "Borough" ], [ "62", "Small borough" ], [ "70", "Village" ] ];
Lino.cal.DurationUnits = [ [ "s", "seconds" ], [ "m", "minutes" ], [ "h", "hours" ], [ "D", "days" ], [ "W", "weeks" ], [ "M", "months" ], [ "Y", "years" ] ];
Lino.lino.UserProfiles = [ [ "000", "000 (Anonymous)" ], [ "100", "100 (User)" ], [ "900", "900 (Administrator)" ] ];
Lino.lino.Genders = [ [ "M", "Male" ], [ "F", "Female" ] ];
Lino.cal.Recurrencies = [ [ "D", "daily" ], [ "W", "weekly" ], [ "M", "monthly" ], [ "Y", "yearly" ], [ "P", "per weekday" ] ];
Lino.cal.Weekdays = [ [ "1", "Monday" ], [ "2", "Tuesday" ], [ "3", "Wednesday" ], [ "4", "Thursday" ], [ "5", "Friday" ], [ "6", "Saturday" ], [ "7", "Sunday" ] ];
Lino.lino.UserGroups = [ [ "office", "office (Office)" ] ];
Lino.lino.UserLevels = [ [ "10", "Guest" ], [ "30", "User" ], [ "40", "Manager" ], [ "50", "Administrator" ] ];
Lino.cal.GuestStates = [ [ "10", "Invited" ] ];

Lino.about.Inspector.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 153,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'hbox',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var inspected312 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Inspected object", "name": "inspected", "maxLength": 100, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Inspected object","(about.Inspector.inspected) ") }, "anchor": "-20" });
    var show_callables313 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "show_callables", "listeners": { "render": Lino.quicktip_renderer("show callables","(about.Inspector.show_callables) ") }, "boxLabel": "show callables", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "flex": 67, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inspected312, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_callables313, "labelAlign": "top" } ];
    this.fields = [ inspected312, show_callables313 ];
    Lino.about.Inspector.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.Uploads.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 26,
  initComponent : function() {
    var containing_panel = this;
    var file237 = Lino.file_field_handler(this,{ "autoHeight": true, "fieldLabel": "File", "name": "file", "listeners": { "render": Lino.quicktip_renderer("File","(uploads.Uploads.file) ") }, "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user238 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(uploads.Uploads.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel239 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file237, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user238, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type242 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Upload Type", "name": "type", "pageSize": 20, "emptyText": "Select a Upload Type...", "listeners": { "render": Lino.quicktip_renderer("Upload Type","(uploads.Uploads.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var description243 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Description", "name": "description", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Description","(uploads.Uploads.description) ") }, "anchor": "-20" });
    var main_2_panel244 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type242, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": description243, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel247 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel239, main_2_panel244 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel247;
    this.before_row_edit = function(record) {
    }
    Lino.uploads.Uploads.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.Users.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 12,
  initComponent : function() {
    var containing_panel = this;
    var username1 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Username</span>", "name": "username", "listeners": { "render": Lino.quicktip_renderer("Username","(users.Users.username) Required. Must be unique.") }, "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var profile2 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">User Profile</span>", "name": "profile", "hiddenName": "profileHidden", "listeners": { "render": Lino.quicktip_renderer("User Profile","(users.Users.profile) Users with an empty `profile` field are considered inactive and cannot log in.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var partner3 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "hiddenName": "partnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(users.Users.partner) ") }, "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var box1_1_panel4 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username1, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile2, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner3, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name8 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "First name", "name": "first_name", "maxLength": 30, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("First name","(users.Users.first_name) ") }, "anchor": "-20" });
    var last_name9 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Last name", "name": "last_name", "maxLength": 30, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Last name","(users.Users.last_name) ") }, "anchor": "-20" });
    var initials10 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Initials", "name": "initials", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Initials","(users.Users.initials) ") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var box1_2_panel11 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name8, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name9, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": initials10, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email15 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "e-mail address", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("e-mail address","(users.Users.email) ") }, "anchor": "-20" });
    var language16 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Language", "name": "language", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(users.Users.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "et", "Estonian" ] ] });
    var box1_3_panel17 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email15, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language16, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var id20 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(users.Users.id) ") }, "anchor": "-20" });
    var created21 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "listeners": { "render": Lino.quicktip_renderer("Created","(users.Users.created) ") }, "value": "<br>", "anchor": "-20" });
    var modified22 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "listeners": { "render": Lino.quicktip_renderer("Modified","(users.Users.modified) ") }, "value": "<br>", "anchor": "-20" });
    var box1_4_panel23 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id20, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created21, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified22, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box1_panel27 = new Ext.Panel({ "flex": 66, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ box1_1_panel4, box1_2_panel11, box1_3_panel17, box1_4_panel23 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var MembershipsByUser_grid30 = new Lino.users.MembershipsByUser.GridPanel({ "flex": 33, "hide_top_toolbar": true, "containing_panel": this, "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("My Memberships","(users.users.MembershipsByUser) ") }, "tools": [ Lino.show_in_own_window_button(Lino.users.MembershipsByUser.grid) ], "hideHeaders": true });
    var general_1_panel31 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box1_panel27, MembershipsByUser_grid30 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks32 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remarks","(users.Users.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var AuthoritiesGiven_grid35 = new Lino.users.AuthoritiesGiven.GridPanel({ "flex": 33, "hide_top_toolbar": true, "containing_panel": this, "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Authorities given","(users.users.AuthoritiesGiven) ") }, "tools": [ Lino.show_in_own_window_button(Lino.users.AuthoritiesGiven.grid) ], "hideHeaders": true });
    var general_2_panel36 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": remarks32, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 66 }, AuthoritiesGiven_grid35 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel38 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel31, general_2_panel36 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var calendar39 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Default calendar</span>", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Select a Calendar...", "listeners": { "render": Lino.quicktip_renderer("Default calendar","(users.Users.calendar) The default calendar for your events and tasks.") }, "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/calendar", "method": "GET" }) }) });
    var access_class40 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Default access class</span>", "allowBlank": false, "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Default access class","(users.Users.access_class) The default access class for your calendar events and tasks.") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.AccessClasses, "name": "access_class" });
    var cal_left_1_panel41 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar39, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class40, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_left_panel49 = new Ext.Panel({ "flex": 33, "border": false, "layout": "vbox", "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ cal_left_1_panel41 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": true, "labelAlign": "top" });
    var cal_1_panel119 = new Ext.Panel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "layout": "hbox", "title": "Calendar", "hideCheckBoxLabels": true, "items": [ cal_left_panel49 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel120 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel38, cal_1_panel119 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel120;
    this.before_row_edit = function(record) {
      MembershipsByUser_grid30.on_master_changed();
      AuthoritiesGiven_grid35.on_master_changed();
    }
    Lino.users.Users.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    partner3.on("change",function(){this.save()},this);
  }
});


Lino.uploads.Uploads.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 26,
  initComponent : function() {
    var containing_panel = this;
    var file219 = Lino.file_field_handler(this,{ "autoHeight": true, "fieldLabel": "File", "name": "file", "listeners": { "render": Lino.quicktip_renderer("File","(uploads.Uploads.file) ") }, "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user220 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(uploads.Uploads.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel221 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file219, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user220, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type224 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Upload Type", "name": "type", "pageSize": 20, "emptyText": "Select a Upload Type...", "listeners": { "render": Lino.quicktip_renderer("Upload Type","(uploads.Uploads.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var description225 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Description", "name": "description", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Description","(uploads.Uploads.description) ") }, "anchor": "-20" });
    var main_2_panel226 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type224, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": description225, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var modified229 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "listeners": { "render": Lino.quicktip_renderer("Modified","(uploads.Uploads.modified) ") }, "value": "<br>", "anchor": "-20" });
    var created230 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "listeners": { "render": Lino.quicktip_renderer("Created","(uploads.Uploads.created) ") }, "value": "<br>", "anchor": "-20" });
    var owner_disp231 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Controlled by", "anchor": "-20", "name": "owner" });
    var main_3_panel232 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified229, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created230, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp231, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel236 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel221, main_2_panel226, main_3_panel232 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel236;
    this.before_row_edit = function(record) {
    }
    Lino.uploads.Uploads.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pages.Pages.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 38,
  initComponent : function() {
    var containing_panel = this;
    var ref248 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Reference", "name": "ref", "maxLength": 40, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Reference","(pages.Pages.ref) ") }, "anchor": "-20" });
    var parent249 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Parent", "name": "parent", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pages.Pages.detail)}, "emptyText": "Select a Node...", "listeners": { "render": Lino.quicktip_renderer("Parent","(pages.Pages.parent) ") }, "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pages/Pages/parent", "method": "GET" }) }) });
    var seqno250 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "Seq.No.", "name": "seqno", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Seq.No.","(pages.Pages.seqno) ") }, "anchor": "-20" });
    var main_1_panel251 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref248, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent249, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": seqno250, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var title255 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Title", "name": "title", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Title","(pages.Pages.title) ") }, "anchor": "-20" });
    var title_et256 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Title (et)", "name": "title_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Title (et)","(pages.Pages.title_et) ") }, "anchor": "-20" });
    var main_2_panel257 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title255, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title_et256, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var body260 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Body","(pages.Pages.body) ") }, "fieldLabel": "Body", "name": "body", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var main_panel261 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 45, "hideCheckBoxLabels": true, "items": [ main_1_panel251, main_2_panel257, { "items": body260, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel261;
    this.before_row_edit = function(record) {
    }
    Lino.pages.Pages.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.MailsByUser.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 35,
  initComponent : function() {
    var containing_panel = this;
    var subject263 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Subject", "name": "subject", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Subject","(outbox.Mails.subject) ") }, "anchor": "-20" });
    var project264 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.projects.Projects.detail)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(outbox.Mails.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var date265 = new Lino.DateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Date</span>", "name": "date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date","(outbox.Mails.date) \n        The official date to be printed on the document.\n        ") }, "anchor": "-20" });
    var main_1_panel266 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject263, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project264, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date265, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user270 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Sender", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Sender","(outbox.Mails.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/user", "method": "GET" }) }) });
    var sent271 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "sent", "name": "sent", "listeners": { "render": Lino.quicktip_renderer("sent","(outbox.Mails.sent) ") }, "value": "<br>", "anchor": "-20" });
    var id272 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(outbox.Mails.id) ") }, "anchor": "-20" });
    var owner_disp273 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Controlled by", "anchor": "-20", "name": "owner" });
    var main_2_panel274 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user270, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent271, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id272, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp273, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var RecipientsByMail_grid285 = new Lino.outbox.RecipientsByMail.GridPanel({ "flex": 55, "listeners": { "render": Lino.quicktip_renderer("Recipients","(outbox.outbox.RecipientsByMail) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.RecipientsByMail.grid) ], "preview_limit": 15, "master_panel": this });
    var AttachmentsByMail_htmlbox286 = new Lino.HtmlBoxPanel({ "flex": 22, "layout": "fit", "name": "AttachmentsByMail", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Attachments", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Attachments","(outbox.Mails.AttachmentsByMail) ") }, "bodyStyle": "overflow-x:hidden;", "tools": [ Lino.show_in_own_window_button(Lino.outbox.AttachmentsByMail.grid) ] });
    var UploadsByController_htmlbox287 = new Lino.HtmlBoxPanel({ "flex": 22, "ls_bbar_actions": [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Uploads","(outbox.Mails.UploadsByController) ") }, "bodyStyle": "overflow-x:hidden;", "ls_insert_handler": Lino.uploads.UploadsByController.insert, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var main_3_panel288 = new Ext.Panel({ "flex": 29, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ RecipientsByMail_grid285, AttachmentsByMail_htmlbox286, UploadsByController_htmlbox287 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var body289 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 58, "containing_panel": this, "name": "body", "title": "Body" });
    var main_panel290 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel266, main_2_panel274, main_3_panel288, body289 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel290;
    this.before_row_edit = function(record) {
      RecipientsByMail_grid285.on_master_changed();
      AttachmentsByMail_htmlbox286.refresh();
      UploadsByController_htmlbox287.refresh();
      body289.refresh();
    }
    Lino.outbox.MailsByUser.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.MailsByUser.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 35,
  initComponent : function() {
    var containing_panel = this;
    var project291 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.projects.Projects.detail)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(outbox.Mails.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var subject292 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Subject", "name": "subject", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Subject","(outbox.Mails.subject) ") }, "anchor": "-20" });
    var body293 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 71, "containing_panel": this, "name": "body", "title": "Body" });
    var main_panel294 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": project291, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": subject292, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, body293 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel294;
    this.before_row_edit = function(record) {
      body293.refresh();
    }
    Lino.outbox.MailsByUser.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.Report.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var body_htmlbox317 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "body", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer(null,"(lino.Report.body) ") } });
    var main_panel318 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ body_htmlbox317 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel318;
    this.before_row_edit = function(record) {
      body_htmlbox317.refresh();
    }
    Lino.lino.Report.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.projects.Projects.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 23,
  initComponent : function() {
    var containing_panel = this;
    var name204 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("name","(projects.Projects.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var type205 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Project Type", "name": "type", "pageSize": 20, "emptyText": "Select a Project Type...", "listeners": { "render": Lino.quicktip_renderer("Project Type","(projects.Projects.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/projects/Projects/type", "method": "GET" }) }) });
    var user206 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(projects.Projects.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/projects/Projects/user", "method": "GET" }) }) });
    var main_1_panel207 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name204, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type205, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user206, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var started211 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "started", "name": "started", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("started","(projects.Projects.started) ") }, "anchor": "-20" });
    var stopped212 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "stopped", "name": "stopped", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("stopped","(projects.Projects.stopped) ") }, "anchor": "-20" });
    var main_2_panel213 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": started211, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": stopped212, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var text216 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("text","(projects.Projects.text) ") }, "fieldLabel": "text", "name": "text", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var main_panel217 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 45, "hideCheckBoxLabels": true, "items": [ main_1_panel207, main_2_panel213, { "items": text216, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel217;
    this.before_row_edit = function(record) {
    }
    Lino.projects.Projects.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.Home.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var quick_links_htmlbox319 = new Lino.HtmlBoxPanel({ "flex": 1, "layout": "fit", "name": "quick_links", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "north", "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer(null,"(system.Home.quick_links) ") }, "split": true });
    var welcome_htmlbox320 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "welcome", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "center", "title": "Welcome", "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Welcome","(system.Home.welcome) ") }, "split": true });
    var main_panel321 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ quick_links_htmlbox319, welcome_htmlbox320 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel321;
    this.before_row_edit = function(record) {
      quick_links_htmlbox319.refresh();
      welcome_htmlbox320.refresh();
    }
    Lino.system.Home.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.Models.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var app_disp297 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "app_label", "name": "app", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("app_label","(about.Models.app) ") }, "anchor": "-20" });
    var name_disp298 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "name", "name": "name", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("name","(about.Models.name) ") }, "anchor": "-20" });
    var docstring_disp299 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "docstring", "name": "docstring", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("docstring","(about.Models.docstring) ") }, "anchor": "-20" });
    var rows300 = new Ext.form.NumberField({ "disabled": true, "autoHeight": true, "fieldLabel": "Rows", "name": "rows", "listeners": { "render": Lino.quicktip_renderer("Rows","(about.Models.rows) ") }, "anchor": "-20" });
    var main_1_panel301 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_disp297, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_disp298, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": docstring_disp299, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": rows300, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var about_FieldsByModel_grid310 = new Lino.about.FieldsByModel.GridPanel({ "flex": 62, "listeners": { "render": Lino.quicktip_renderer("Fields","(about.about.FieldsByModel) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.about.FieldsByModel.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel311 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel301, about_FieldsByModel_grid310 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel311;
    this.before_row_edit = function(record) {
      about_FieldsByModel_grid310.on_master_changed();
    }
    Lino.about.Models.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.SiteConfigs.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 8,
  initComponent : function() {
    var containing_panel = this;
    var default_build_method182 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Default build method", "name": "default_build_method", "value": "appyodt", "hiddenName": "default_build_methodHidden", "listeners": { "render": Lino.quicktip_renderer("Default build method","(system.SiteConfigs.default_build_method) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var main_panel183 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "items": default_build_method182, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel183;
    this.before_row_edit = function(record) {
    }
    Lino.system.SiteConfigs.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.Users.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 12,
  initComponent : function() {
    var containing_panel = this;
    var username121 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Username</span>", "name": "username", "listeners": { "render": Lino.quicktip_renderer("Username","(users.Users.username) Required. Must be unique.") }, "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var email122 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "e-mail address", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("e-mail address","(users.Users.email) ") }, "anchor": "-20" });
    var main_1_panel123 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username121, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email122, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name126 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "First name", "name": "first_name", "maxLength": 30, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("First name","(users.Users.first_name) ") }, "anchor": "-20" });
    var last_name127 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Last name", "name": "last_name", "maxLength": 30, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Last name","(users.Users.last_name) ") }, "anchor": "-20" });
    var main_2_panel128 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name126, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name127, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var partner131 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "hiddenName": "partnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(users.Users.partner) ") }, "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var language132 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Language", "name": "language", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(users.Users.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "et", "Estonian" ] ] });
    var profile133 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">User Profile</span>", "name": "profile", "hiddenName": "profileHidden", "listeners": { "render": Lino.quicktip_renderer("User Profile","(users.Users.profile) Users with an empty `profile` field are considered inactive and cannot log in.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var main_4_panel134 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 47, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language132, "labelAlign": "top" }, { "flex": 52, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile133, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel137 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ main_1_panel123, main_2_panel128, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner131, "anchor": "-20", "labelAlign": "top" }, main_4_panel134 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel137;
    this.before_row_edit = function(record) {
    }
    Lino.users.Users.InsertFormPanel.superclass.initComponent.call(this);
    // active_fields:
    partner131.on("change",function(){this.save()},this);
  }
});


Lino.about.About.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var server_status_disp140 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Server status", "name": "server_status", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Server status","(about.About.server_status) ") }, "anchor": "-20" });
    var main_panel141 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "html": "<div class=\"htmlText\"><span><a href=\"http://www.lino-framework.org\" target=\"_blank\">Lino</a> 1.6.12, <a href=\"http://north.lino-framework.org\" target=\"_blank\">North</a> 0.1.7, <a href=\"http://site.lino-framework.org\" target=\"_blank\">djangosite</a> 0.1.8, <a href=\"http://www.djangoproject.com\" target=\"_blank\">Django</a> 1.5.1, <a href=\"http://www.python.org/\" target=\"_blank\">Python</a> 2.7.3, <a href=\"http://babel.edgewall.org/\" target=\"_blank\">Babel</a> 1.0, <a href=\"http://jinja.pocoo.org/\" target=\"_blank\">Jinja</a> 2.6, <a href=\"http://sphinx-doc.org/\" target=\"_blank\">Sphinx</a> 1.2b1, <a href=\"http://labix.org/python-dateutil\" target=\"_blank\">python-dateutil</a> 2.1, <a href=\"http://pypi.python.org/pypi/odfpy\" target=\"_blank\">OdfPy</a> ODFPY/0.9.6, <a href=\"http://docutils.sourceforge.net/\" target=\"_blank\">docutils</a> 0.8.1, <a href=\"https://fedorahosted.org/suds/\" target=\"_blank\">suds</a> 0.4, <a href=\"http://pyyaml.org/\" target=\"_blank\">PyYaml</a> 3.10, <a href=\"http://appyframework.org/pod.html\" target=\"_blank\">Appy</a> 0.8.3 (2013/02/22 15:29), <a href=\"http://www.sencha.com\" target=\"_blank\">ExtJS</a> <a href=\"#\" onclick=\"alert('ExtJS client version is ' + Ext.version);\" title=\"Click to see ExtJS client version\">(version)</a>, <a href=\"http://ext.ensible.com/products/calendar/\" target=\"_blank\">Extensible</a> <a href=\"#\" onclick=\"alert('Extensible Calendar version is ' + Ext.ensible.version);\" title=\"Click to see Extensible Calendar version\">(version)</a>, <a href=\"http://www.famfamfam.com/lab/icons/silk/\" target=\"_blank\">Silk Icons</a> 1.3</span><p>Server uptime : <b>Monday, October 7, 2013 at 02:17:52.430853</b></p><p>Source timestamps:</p><ul><li>lino : <b>Monday, October 7, 2013 at 02:17:20.707048</b></li><li>atelier : <b>Friday, October 4, 2013 at 21:27:04.068617</b></li><li>north : <b>Tuesday, October 1, 2013 at 17:02:09.178944</b></li><li>djangosite : <b>Sunday, September 15, 2013 at 15:07:52.398691</b></li><li>django : <b>Friday, August 30, 2013 at 13:02:10.834631</b></li></ul></div>", "xtype": "label" }, { "items": server_status_disp140, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel141;
    this.before_row_edit = function(record) {
    }
    Lino.about.About.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.ContentTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 3,
  initComponent : function() {
    var containing_panel = this;
    var id185 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(system.ContentTypes.id) ") }, "anchor": "-20" });
    var name186 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("name","(system.ContentTypes.name) ") }, "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var app_label187 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "app label", "name": "app_label", "listeners": { "render": Lino.quicktip_renderer("app label","(system.ContentTypes.app_label) ") }, "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var model188 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "python model class name", "name": "model", "listeners": { "render": Lino.quicktip_renderer("python model class name","(system.ContentTypes.model) ") }, "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var base_classes_disp189 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Base classes", "name": "base_classes", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Base classes","(system.ContentTypes.base_classes) ") }, "anchor": "-20" });
    var main_1_panel190 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id185, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name186, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_label187, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": model188, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": base_classes_disp189, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var system_HelpTextsByModel_grid202 = new Lino.system.HelpTextsByModel.GridPanel({ "flex": 62, "listeners": { "render": Lino.quicktip_renderer("Help Texts","(system.system.HelpTextsByModel) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.system.HelpTextsByModel.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel203 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel190, system_HelpTextsByModel_grid202 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel203;
    this.before_row_edit = function(record) {
      system_HelpTextsByModel_grid202.on_master_changed();
    }
    Lino.system.ContentTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


// js_render_GridPanel_class system.SiteConfigs
Lino.system.SiteConfigs.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/system/SiteConfigs",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/system/SiteConfigs','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/SiteConfigs','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/SiteConfigs','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "do_build", "menu_item_text": "Rebuild site cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('do_build','GET',null), "text": "Rebuild site cache", "overflowText": "Rebuild site cache", "auto_save": true } ],
  cell_edit : true,
  title : "site configs",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "default_build_method" }, 'default_build_methodHidden', { "type": "int", "name": "next_partner_id" }, { "name": "site_company" }, 'site_companyHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 8,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.system.SiteConfigs.detail;
    var ww = this.containing_window;
    var id322 = new Ext.form.NumberField({ "selectOnFocus": true });
    var default_build_method323 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "value": "appyodt" });
    var next_partner_id324 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 100 });
    var site_company325 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/site_company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Company..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.SiteConfigs.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id322, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Default build method", "editable": true, "tooltip": "(system.SiteConfigs.default_build_method) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "default_build_method", "editor": default_build_method323 }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.SiteConfigs.next_partner_id) The next automatic id for any new partner.", "filter": { "type": "numeric" }, "header": "Next partner id", "dataIndex": "next_partner_id", "width": Lino.chars2width(6), "editor": next_partner_id324 }), { "colIndex": 3, "sortable": true, "header": "The company that runs this site", "editable": true, "tooltip": "(system.SiteConfigs.site_company) The Company to be used as sender in documents.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "site_company", "editor": site_company325 } ];
    Lino.system.SiteConfigs.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.system.SiteConfigs.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/SiteConfigs","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.system.SiteConfigs.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/SiteConfigs","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.system.SiteConfigs.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/SiteConfigs","GET",pk,"put",null);
};
Lino.system.SiteConfigs.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/SiteConfigs","GET",pk,"post",null);
};

Lino.system.SiteConfigs.detailPanel = Ext.extend(Lino.system.SiteConfigs.DetailFormPanel,{
  empty_title: "Detail site configs",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "do_build", "menu_item_text": "Rebuild site cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('do_build','GET',null), "text": "Rebuild site cache", "overflowText": "Rebuild site cache", "auto_save": true } ],
  ls_url: "/system/SiteConfigs",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.SiteConfigs.detail;
    Lino.system.SiteConfigs.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.system.SiteConfigs.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.system.SiteConfigs.detailPanel(p);
});
Lino.system.SiteConfigs.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.system.SiteConfigs.GridPanel(p);
});
Lino.system.SiteConfigs.do_build = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/SiteConfigs","GET",pk,"do_build",null);
};

// js_render_GridPanel_class system.ContentTypes
Lino.system.ContentTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/system/ContentTypes",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/system/ContentTypes','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/ContentTypes','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/ContentTypes','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "content types",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 5,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "app_label" }, { "name": "model" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 3,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.system.ContentTypes.detail;
    this.ls_insert_handler = Lino.system.ContentTypes.insert;
    var ww = this.containing_window;
    var id327 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name328 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var app_label329 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var model330 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.ContentTypes.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id327, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "name", "editable": true, "tooltip": "(system.ContentTypes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name328 }, { "colIndex": 2, "sortable": true, "header": "app label", "editable": true, "tooltip": "(system.ContentTypes.app_label) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "app_label", "editor": app_label329 }, { "colIndex": 3, "sortable": true, "header": "python model class name", "editable": true, "tooltip": "(system.ContentTypes.model) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "model", "editor": model330 } ];
    Lino.system.ContentTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.system.ContentTypes.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/ContentTypes","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.system.ContentTypes.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/ContentTypes","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.system.ContentTypes.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/ContentTypes","GET",pk,"put",null);
};
Lino.system.ContentTypes.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/ContentTypes","GET",pk,"post",null);
};

Lino.system.ContentTypes.insertPanel = Ext.extend(Lino.system.ContentTypes.DetailFormPanel,{
  empty_title: "New content types",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/system/ContentTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.ContentTypes.detail;
    this.ls_insert_handler = Lino.system.ContentTypes.insert;
    Lino.system.ContentTypes.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.system.ContentTypes.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.system.ContentTypes.insertPanel(p);
});
Lino.system.ContentTypes.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/ContentTypes","GET",pk,"poststay",null);
};

Lino.system.ContentTypes.detailPanel = Ext.extend(Lino.system.ContentTypes.DetailFormPanel,{
  empty_title: "Detail content types",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/system/ContentTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.ContentTypes.detail;
    this.ls_insert_handler = Lino.system.ContentTypes.insert;
    Lino.system.ContentTypes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.system.ContentTypes.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.system.ContentTypes.detailPanel(p);
});
Lino.system.ContentTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.system.ContentTypes.GridPanel(p);
});

// js_render_GridPanel_class system.HelpTexts
Lino.system.HelpTexts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/system/HelpTexts",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/system/HelpTexts','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/HelpTexts','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/HelpTexts','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Help Texts",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "name": "field" }, { "name": "verbose_name" }, { "name": "help_text" }, { "type": "int", "name": "id" }, { "name": "content_type" }, 'content_typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 9,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var field332 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/HelpTexts/field", "method": "GET" }) }) });
    var verbose_name333 = new Ext.form.TextField({ "disabled": true, "maxLength": 200 });
    var help_text334 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var id335 = new Ext.form.NumberField({ "selectOnFocus": true });
    var content_type336 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/HelpTexts/content_type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a content type..." });
    this.before_row_edit = function(record) {
      field332.setContextValue('content_type',record ? record.data['content_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      content_type336.on('change',Lino.chooser_handler(field332,'content_type'));
      Lino.system.HelpTexts.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Field", "editable": true, "tooltip": "(system.HelpTexts.field) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "field", "editor": field332 }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "verbose_name", "header": "Verbose name", "editable": false, "tooltip": "(system.HelpTexts.verbose_name) " }, { "colIndex": 2, "sortable": false, "header": "HelpText", "editable": true, "tooltip": "(system.HelpTexts.help_text) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": help_text334, "dataIndex": "help_text" }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.HelpTexts.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id335, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Model", "editable": true, "tooltip": "(system.HelpTexts.content_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('content_typeHidden','Lino.system.ContentTypes.detail'), "editor": content_type336, "dataIndex": "content_type" } ];
    Lino.system.HelpTexts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.system.HelpTexts.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/HelpTexts","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.system.HelpTexts.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/HelpTexts","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.system.HelpTexts.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/HelpTexts","GET",pk,"put",null);
};
Lino.system.HelpTexts.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/HelpTexts","GET",pk,"post",null);
};
Lino.system.HelpTexts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.system.HelpTexts.GridPanel(p);
});

// js_render_GridPanel_class users.Users
Lino.users.Users.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/Users",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/users/Users','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Users','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Users','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "must_save": true, "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true } ],
  cell_edit : true,
  title : "Users",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 21,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "first_name" }, { "name": "last_name" }, { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "password" }, { "name": "initials" }, { "name": "email" }, { "name": "remarks" }, { "name": "language" }, 'languageHidden', { "name": "partner" }, 'partnerHidden', { "name": "access_class" }, 'access_classHidden', { "name": "calendar" }, 'calendarHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 12,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    var ww = this.containing_window;
    var username338 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile339 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var first_name340 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var last_name341 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var id342 = new Ext.form.NumberField({ "selectOnFocus": true });
    var created343 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified344 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var password345 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 128 });
    var initials346 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var email347 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var remarks348 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var language349 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "et", "Estonian" ] ] });
    var partner350 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var access_class351 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.AccessClasses });
    var calendar352 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Username", "editable": true, "tooltip": "(users.Users.username) Required. Must be unique.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "username", "editor": username338 }, { "colIndex": 1, "sortable": true, "header": "User Profile", "editable": true, "tooltip": "(users.Users.profile) Users with an empty `profile` field are considered inactive and cannot log in.", "filter": { "type": "string" }, "width": Lino.chars2width(23), "dataIndex": "profile", "editor": profile339 }, { "colIndex": 2, "sortable": true, "header": "First name", "editable": true, "tooltip": "(users.Users.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name340 }, { "colIndex": 3, "sortable": true, "header": "Last name", "editable": true, "tooltip": "(users.Users.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name341 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.Users.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id342, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(17), "colIndex": 5, "sortable": true, "dataIndex": "created", "header": "Created", "editable": false, "tooltip": "(users.Users.created) " }, { "width": Lino.chars2width(17), "colIndex": 6, "sortable": true, "dataIndex": "modified", "header": "Modified", "editable": false, "tooltip": "(users.Users.modified) " }, { "colIndex": 7, "sortable": true, "header": "Password", "editable": true, "tooltip": "(users.Users.password) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "password", "hidden": true, "editor": password345 }, { "colIndex": 8, "sortable": true, "header": "Initials", "editable": true, "tooltip": "(users.Users.initials) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "initials", "editor": initials346 }, { "colIndex": 9, "sortable": true, "header": "e-mail address", "editable": true, "tooltip": "(users.Users.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email347 }, { "colIndex": 10, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(users.Users.remarks) ", "filter": { "type": "string" }, "header": "Remarks", "renderer": Lino.text_renderer, "hidden": true, "editor": remarks348, "dataIndex": "remarks" }, { "colIndex": 11, "sortable": true, "header": "Language", "editable": true, "tooltip": "(users.Users.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language349 }, { "colIndex": 12, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(users.Users.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "partner", "editor": partner350 }, { "colIndex": 13, "sortable": true, "header": "Default access class", "editable": true, "tooltip": "(users.Users.access_class) The default access class for your calendar events and tasks.", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "access_class", "editor": access_class351 }, { "colIndex": 14, "sortable": true, "header": "Default calendar", "editable": true, "tooltip": "(users.Users.calendar) The default calendar for your events and tasks.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "calendar", "editor": calendar352 } ];
    Lino.users.Users.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Users.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Users","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.users.Users.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Users","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.users.Users.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Users","GET",pk,"put",null);
};
Lino.users.Users.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Users","GET",pk,"post",null);
};

Lino.users.Users.insertPanel = Ext.extend(Lino.users.Users.InsertFormPanel,{
  empty_title: "New Users",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/users/Users",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.Users.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Users.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.Users.insertPanel(p);
});
Lino.users.Users.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Users","GET",pk,"poststay",null);
};

Lino.users.Users.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Detail Users",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "must_save": true, "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true } ],
  ls_url: "/users/Users",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.Users.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Users.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Users.detailPanel(p);
});
Lino.users.Users.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Users.GridPanel(p);
});
Lino.users.Users.update_reminders = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Users","GET",pk,"update_reminders",null);
};

// js_render_GridPanel_class users.MySettings
Lino.users.MySettings.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/MySettings",
  ls_bbar_actions : [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "must_save": true, "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true } ],
  cell_edit : true,
  title : "Users",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 21,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "first_name" }, { "name": "last_name" }, { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "password" }, { "name": "initials" }, { "name": "email" }, { "name": "remarks" }, { "name": "language" }, 'languageHidden', { "name": "partner" }, 'partnerHidden', { "name": "access_class" }, 'access_classHidden', { "name": "calendar" }, 'calendarHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 12,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    var ww = this.containing_window;
    var username143 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile144 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var first_name145 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var last_name146 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var id147 = new Ext.form.NumberField({ "selectOnFocus": true });
    var created148 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified149 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var password150 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 128 });
    var initials151 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var email152 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var remarks153 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var language154 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "et", "Estonian" ] ] });
    var partner155 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var access_class156 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.AccessClasses });
    var calendar157 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Username", "editable": true, "tooltip": "(users.MySettings.username) Required. Must be unique.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "username", "editor": username143 }, { "colIndex": 1, "sortable": true, "header": "User Profile", "editable": true, "tooltip": "(users.MySettings.profile) Users with an empty `profile` field are considered inactive and cannot log in.", "filter": { "type": "string" }, "width": Lino.chars2width(23), "dataIndex": "profile", "editor": profile144 }, { "colIndex": 2, "sortable": true, "header": "First name", "editable": true, "tooltip": "(users.MySettings.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name145 }, { "colIndex": 3, "sortable": true, "header": "Last name", "editable": true, "tooltip": "(users.MySettings.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name146 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.MySettings.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id147, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(17), "colIndex": 5, "sortable": true, "dataIndex": "created", "header": "Created", "editable": false, "tooltip": "(users.MySettings.created) " }, { "width": Lino.chars2width(17), "colIndex": 6, "sortable": true, "dataIndex": "modified", "header": "Modified", "editable": false, "tooltip": "(users.MySettings.modified) " }, { "colIndex": 7, "sortable": true, "header": "Password", "editable": true, "tooltip": "(users.MySettings.password) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "password", "hidden": true, "editor": password150 }, { "colIndex": 8, "sortable": true, "header": "Initials", "editable": true, "tooltip": "(users.MySettings.initials) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "initials", "editor": initials151 }, { "colIndex": 9, "sortable": true, "header": "e-mail address", "editable": true, "tooltip": "(users.MySettings.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email152 }, { "colIndex": 10, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(users.MySettings.remarks) ", "filter": { "type": "string" }, "header": "Remarks", "renderer": Lino.text_renderer, "hidden": true, "editor": remarks153, "dataIndex": "remarks" }, { "colIndex": 11, "sortable": true, "header": "Language", "editable": true, "tooltip": "(users.MySettings.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language154 }, { "colIndex": 12, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(users.MySettings.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "partner", "editor": partner155 }, { "colIndex": 13, "sortable": true, "header": "Default access class", "editable": true, "tooltip": "(users.MySettings.access_class) The default access class for your calendar events and tasks.", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "access_class", "editor": access_class156 }, { "colIndex": 14, "sortable": true, "header": "Default calendar", "editable": true, "tooltip": "(users.MySettings.calendar) The default calendar for your events and tasks.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "calendar", "editor": calendar157 } ];
    Lino.users.MySettings.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MySettings","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.users.MySettings.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MySettings","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.users.MySettings.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MySettings","GET",pk,"put",null);
};
Lino.users.MySettings.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MySettings","GET",pk,"post",null);
};

Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Users",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "must_save": true, "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});

Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Users",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "must_save": true, "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});
Lino.users.MySettings.update_reminders = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MySettings","GET",pk,"update_reminders",null);
};

// js_render_GridPanel_class users.UsersOverview
Lino.users.UsersOverview.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/UsersOverview",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/users/UsersOverview','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/UsersOverview','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/UsersOverview','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "must_save": true, "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true } ],
  cell_edit : true,
  title : "Users",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "language" }, 'languageHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 12,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.UsersOverview.detail;
    this.ls_insert_handler = Lino.users.UsersOverview.insert;
    var ww = this.containing_window;
    var username178 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile179 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var language180 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "et", "Estonian" ] ] });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Username", "editable": true, "tooltip": "(users.UsersOverview.username) Required. Must be unique.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "username", "editor": username178 }, { "colIndex": 1, "sortable": true, "header": "User Profile", "editable": true, "tooltip": "(users.UsersOverview.profile) Users with an empty `profile` field are considered inactive and cannot log in.", "filter": { "type": "string" }, "width": Lino.chars2width(23), "dataIndex": "profile", "editor": profile179 }, { "colIndex": 2, "sortable": true, "header": "Language", "editable": true, "tooltip": "(users.UsersOverview.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language180 } ];
    Lino.users.UsersOverview.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.UsersOverview.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/UsersOverview","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.users.UsersOverview.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/UsersOverview","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.users.UsersOverview.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/UsersOverview","GET",pk,"put",null);
};
Lino.users.UsersOverview.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/UsersOverview","GET",pk,"post",null);
};

Lino.users.UsersOverview.insertPanel = Ext.extend(Lino.users.Users.InsertFormPanel,{
  empty_title: "New Users",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/users/UsersOverview",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.UsersOverview.detail;
    this.ls_insert_handler = Lino.users.UsersOverview.insert;
    Lino.users.UsersOverview.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.users.UsersOverview.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.UsersOverview.insertPanel(p);
});
Lino.users.UsersOverview.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/UsersOverview","GET",pk,"poststay",null);
};

Lino.users.UsersOverview.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Detail Users",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "must_save": true, "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true } ],
  ls_url: "/users/UsersOverview",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.UsersOverview.detail;
    this.ls_insert_handler = Lino.users.UsersOverview.insert;
    Lino.users.UsersOverview.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.UsersOverview.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.UsersOverview.detailPanel(p);
});
Lino.users.UsersOverview.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.UsersOverview.GridPanel(p);
});
Lino.users.UsersOverview.update_reminders = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/UsersOverview","GET",pk,"update_reminders",null);
};

// js_render_GridPanel_class users.Teams
Lino.users.Teams.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/Teams",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/users/Teams','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Teams','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Teams','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Teams",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 4,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_et" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 14,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id354 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name355 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_et356 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.Teams.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id354, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(users.Teams.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name355 }, { "colIndex": 2, "sortable": true, "header": "Designation (et)", "editable": true, "tooltip": "(users.Teams.name_et) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et356 } ];
    Lino.users.Teams.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Teams.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Teams","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.users.Teams.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Teams","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.users.Teams.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Teams","GET",pk,"put",null);
};
Lino.users.Teams.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Teams","GET",pk,"post",null);
};
Lino.users.Teams.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Teams.GridPanel(p);
});

// js_render_GridPanel_class users.Memberships
Lino.users.Memberships.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/Memberships",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/users/Memberships','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Memberships','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Memberships','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Memberships",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "team" }, 'teamHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 11,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id358 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user359 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Memberships/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var team360 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Memberships/team", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Team..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.Memberships.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id358, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Author", "editable": true, "tooltip": "(users.Memberships.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user359, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "Team", "editable": true, "tooltip": "(users.Memberships.team) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "team", "editor": team360 } ];
    Lino.users.Memberships.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Memberships.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Memberships","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.users.Memberships.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Memberships","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.users.Memberships.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Memberships","GET",pk,"put",null);
};
Lino.users.Memberships.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Memberships","GET",pk,"post",null);
};
Lino.users.Memberships.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Memberships.GridPanel(p);
});

// js_render_GridPanel_class users.Authorities
Lino.users.Authorities.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/Authorities",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/users/Authorities','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Authorities','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Authorities','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Authorities",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "authorized" }, 'authorizedHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 13,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id362 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user363 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Authorities/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var authorized364 = new Lino.RemoteComboFieldElement({ "preferred_width": 15, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Authorities/authorized", "method": "GET" }) }), "emptyText": "Select a User..." });
    this.before_row_edit = function(record) {
      authorized364.setContextValue('user',record ? record.data['userHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      user363.on('change',Lino.chooser_handler(authorized364,'user'));
      Lino.users.Authorities.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.Authorities.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id362, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Author", "editable": true, "tooltip": "(users.Authorities.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user363, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "User", "editable": true, "tooltip": "(users.Authorities.authorized) The user who gets authority to act in your name.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('authorizedHidden','Lino.users.Users.detail'), "editor": authorized364, "dataIndex": "authorized" } ];
    Lino.users.Authorities.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Authorities.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Authorities","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.users.Authorities.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Authorities","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.users.Authorities.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Authorities","GET",pk,"put",null);
};
Lino.users.Authorities.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Authorities","GET",pk,"post",null);
};
Lino.users.Authorities.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Authorities.GridPanel(p);
});

// js_render_GridPanel_class contacts.CompanyTypes
Lino.contacts.CompanyTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/CompanyTypes",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/contacts/CompanyTypes','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/CompanyTypes','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/CompanyTypes','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "company types",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "name": "name" }, { "name": "name_et" }, { "type": "int", "name": "id" }, { "name": "abbr" }, { "name": "abbr_et" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 22,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var name366 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_et367 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id368 = new Ext.form.NumberField({ "selectOnFocus": true });
    var abbr369 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var abbr_et370 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(contacts.CompanyTypes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name366 }, { "colIndex": 1, "sortable": true, "header": "Designation (et)", "editable": true, "tooltip": "(contacts.CompanyTypes.name_et) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et367 }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.CompanyTypes.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id368, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 3, "sortable": true, "header": "Abbreviation", "editable": true, "tooltip": "(contacts.CompanyTypes.abbr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "abbr", "editor": abbr369 }, { "colIndex": 4, "sortable": true, "header": "Abbreviation (et)", "editable": true, "tooltip": "(contacts.CompanyTypes.abbr_et) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "abbr_et", "editor": abbr_et370 } ];
    Lino.contacts.CompanyTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.CompanyTypes.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/CompanyTypes","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.contacts.CompanyTypes.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/CompanyTypes","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.contacts.CompanyTypes.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/CompanyTypes","GET",pk,"put",null);
};
Lino.contacts.CompanyTypes.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/CompanyTypes","GET",pk,"post",null);
};
Lino.contacts.CompanyTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.CompanyTypes.GridPanel(p);
});

// js_render_GridPanel_class contacts.RoleTypes
Lino.contacts.RoleTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/RoleTypes",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/contacts/RoleTypes','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/RoleTypes','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/RoleTypes','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Functions",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 4,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_et" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 17,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id372 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name373 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_et374 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.RoleTypes.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id372, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(contacts.RoleTypes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name373 }, { "colIndex": 2, "sortable": true, "header": "Designation (et)", "editable": true, "tooltip": "(contacts.RoleTypes.name_et) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et374 } ];
    Lino.contacts.RoleTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.RoleTypes.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RoleTypes","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.contacts.RoleTypes.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RoleTypes","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.contacts.RoleTypes.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RoleTypes","GET",pk,"put",null);
};
Lino.contacts.RoleTypes.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RoleTypes","GET",pk,"post",null);
};
Lino.contacts.RoleTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.RoleTypes.GridPanel(p);
});

// js_render_GridPanel_class contacts.Roles
Lino.contacts.Roles.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Roles",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/contacts/Roles','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/Roles','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/Roles','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Contact Persons",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 8,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "type" }, 'typeHidden', { "name": "person" }, 'personHidden', { "name": "company" }, 'companyHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 20,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id376 = new Ext.form.NumberField({ "selectOnFocus": true });
    var type377 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Roles/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Function..." });
    var person378 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Roles/person", "method": "GET" }) }), "emptyText": "Select a Person..." });
    var company379 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Roles/company", "method": "GET" }) }), "emptyText": "Select a Company..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.Roles.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id376, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Contact Role", "editable": true, "tooltip": "(contacts.Roles.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type377 }, { "colIndex": 2, "sortable": true, "header": "Person", "editable": true, "tooltip": "(contacts.Roles.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "person", "editor": person378 }, { "colIndex": 3, "sortable": true, "header": "Company", "editable": true, "tooltip": "(contacts.Roles.company) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "company", "editor": company379 } ];
    Lino.contacts.Roles.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Roles.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Roles","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.contacts.Roles.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Roles","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.contacts.Roles.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Roles","GET",pk,"put",null);
};
Lino.contacts.Roles.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Roles","GET",pk,"post",null);
};
Lino.contacts.Roles.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Roles.GridPanel(p);
});

// js_render_GridPanel_class projects.ProjectTypes
Lino.projects.ProjectTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/projects/ProjectTypes",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/projects/ProjectTypes','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/projects/ProjectTypes','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/projects/ProjectTypes','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Project Types",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 4,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_et" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 24,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id381 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name382 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_et383 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(projects.ProjectTypes.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id381, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(projects.ProjectTypes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name382 }, { "colIndex": 2, "sortable": true, "header": "Designation (et)", "editable": true, "tooltip": "(projects.ProjectTypes.name_et) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et383 } ];
    Lino.projects.ProjectTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.projects.ProjectTypes.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/projects/ProjectTypes","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.projects.ProjectTypes.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/projects/ProjectTypes","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.projects.ProjectTypes.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/projects/ProjectTypes","GET",pk,"put",null);
};
Lino.projects.ProjectTypes.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/projects/ProjectTypes","GET",pk,"post",null);
};
Lino.projects.ProjectTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.projects.ProjectTypes.GridPanel(p);
});

// js_render_GridPanel_class projects.Projects
Lino.projects.Projects.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/projects/Projects",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/projects/Projects','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/projects/Projects','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/projects/Projects','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.list_action_handler('/projects/Projects','do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Clear cache", "auto_save": true } ],
  cell_edit : true,
  title : "Projects",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 11,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "build_time" }, { "name": "name" }, { "name": "type" }, 'typeHidden', { "type": "date", "name": "started", "dateFormat": "d.m.Y" }, { "type": "date", "name": "stopped", "dateFormat": "d.m.Y" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 23,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.projects.Projects.detail;
    this.ls_insert_handler = Lino.projects.Projects.insert;
    var ww = this.containing_window;
    var id385 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user386 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/projects/Projects/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var build_time387 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var name388 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var type389 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/projects/Projects/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project Type..." });
    var started390 = new Lino.DateField({ "selectOnFocus": true });
    var stopped391 = new Lino.DateField({ "selectOnFocus": true });
    var text392 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(projects.Projects.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id385, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Author", "editable": true, "tooltip": "(projects.Projects.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user386, "dataIndex": "user" }, { "width": Lino.chars2width(17), "colIndex": 2, "sortable": true, "dataIndex": "build_time", "header": "build time", "editable": false, "tooltip": "(projects.Projects.build_time) " }, { "colIndex": 3, "sortable": true, "header": "name", "editable": true, "tooltip": "(projects.Projects.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name388 }, { "colIndex": 4, "sortable": true, "header": "Project Type", "editable": true, "tooltip": "(projects.Projects.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type389 }, { "colIndex": 5, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(projects.Projects.started) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "started", "dataIndex": "started", "width": Lino.chars2width(9), "editor": started390 }, { "colIndex": 6, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(projects.Projects.stopped) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "stopped", "dataIndex": "stopped", "width": Lino.chars2width(9), "editor": stopped391 }, { "colIndex": 7, "sortable": false, "header": "text", "editable": true, "tooltip": "(projects.Projects.text) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": text392, "dataIndex": "text" } ];
    Lino.projects.Projects.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.projects.Projects.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/projects/Projects","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.projects.Projects.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/projects/Projects","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.projects.Projects.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/projects/Projects","GET",pk,"put",null);
};
Lino.projects.Projects.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/projects/Projects","GET",pk,"post",null);
};

Lino.projects.Projects.insertPanel = Ext.extend(Lino.projects.Projects.DetailFormPanel,{
  empty_title: "New Projects",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true } ],
  ls_url: "/projects/Projects",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.projects.Projects.detail;
    this.ls_insert_handler = Lino.projects.Projects.insert;
    Lino.projects.Projects.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.projects.Projects.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.projects.Projects.insertPanel(p);
});
Lino.projects.Projects.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/projects/Projects","GET",pk,"poststay",null);
};
Lino.projects.Projects.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/projects/Projects","GET",pk,"duplicate",null);
};

Lino.projects.Projects.detailPanel = Ext.extend(Lino.projects.Projects.DetailFormPanel,{
  empty_title: "Detail Projects",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.list_action_handler('/projects/Projects','do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Clear cache", "auto_save": true } ],
  ls_url: "/projects/Projects",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.projects.Projects.detail;
    this.ls_insert_handler = Lino.projects.Projects.insert;
    Lino.projects.Projects.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.projects.Projects.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.projects.Projects.detailPanel(p);
});
Lino.projects.Projects.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/projects/Projects","POST",pk,"do_print",null);
};
Lino.projects.Projects.do_clear_cache = function(rp,pk) { 
  Lino.run_row_action(rp,"/projects/Projects","GET",pk,"do_clear_cache",null);
};
Lino.projects.Projects.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.projects.Projects.GridPanel(p);
});

// js_render_GridPanel_class uploads.UploadTypes
Lino.uploads.UploadTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/uploads/UploadTypes",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/uploads/UploadTypes','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/uploads/UploadTypes','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/uploads/UploadTypes','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Upload Types",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 3,
  ls_store_fields : [ { "name": "name" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 1,
  ls_grid_configs : [  ],
  content_type : 25,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var name394 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var id395 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "tooltip": "(uploads.UploadTypes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name394 }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "format": "0", "editable": true, "tooltip": "(uploads.UploadTypes.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id395, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.uploads.UploadTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.UploadTypes.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/uploads/UploadTypes","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.uploads.UploadTypes.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/uploads/UploadTypes","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.uploads.UploadTypes.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/uploads/UploadTypes","GET",pk,"put",null);
};
Lino.uploads.UploadTypes.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/uploads/UploadTypes","GET",pk,"post",null);
};
Lino.uploads.UploadTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.UploadTypes.GridPanel(p);
});

// js_render_GridPanel_class uploads.Uploads
Lino.uploads.Uploads.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/uploads/Uploads",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/uploads/Uploads','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/uploads/Uploads','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/uploads/Uploads','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Uploads",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 17,
  ls_store_fields : [ { "name": "file" }, { "name": "user" }, 'userHidden', { "name": "created" }, { "name": "modified" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "mimetype" }, { "name": "type" }, 'typeHidden', { "type": "date", "name": "valid_until", "dateFormat": "d.m.Y" }, { "name": "description" }, { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 26,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.Uploads.detail;
    this.ls_insert_handler = Lino.uploads.Uploads.insert;
    var ww = this.containing_window;
    var file397 = Lino.file_field_handler(this,{ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var user398 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var created399 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified400 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var id401 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type402 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id403 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/owner_id", "method": "GET" }) }) });
    var mimetype404 = new Ext.form.TextField({ "disabled": true, "maxLength": 64 });
    var type405 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Upload Type..." });
    var valid_until406 = new Lino.DateField({ "selectOnFocus": true });
    var description407 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var owner_disp408 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id403.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type402.on('change',Lino.chooser_handler(owner_id403,'owner_type'));
      Lino.uploads.Uploads.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "File", "editable": true, "tooltip": "(uploads.Uploads.file) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "file", "editor": file397 }, { "colIndex": 1, "sortable": true, "header": "Author", "editable": true, "tooltip": "(uploads.Uploads.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user398, "dataIndex": "user" }, { "width": Lino.chars2width(17), "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "Created", "editable": false, "tooltip": "(uploads.Uploads.created) " }, { "width": Lino.chars2width(17), "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "Modified", "editable": false, "tooltip": "(uploads.Uploads.modified) " }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(uploads.Uploads.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id401, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Controlled by (type)", "editable": true, "tooltip": "(uploads.Uploads.owner_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.system.ContentTypes.detail'), "editor": owner_type402, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Controlled by (object)", "editable": true, "tooltip": "(uploads.Uploads.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id403 }, { "colIndex": 7, "sortable": true, "header": "MIME type", "editable": false, "tooltip": "(uploads.Uploads.mimetype) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "mimetype" }, { "colIndex": 8, "sortable": true, "header": "Upload Type", "editable": true, "tooltip": "(uploads.Uploads.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type405 }, { "colIndex": 9, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(uploads.Uploads.valid_until) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "valid until", "dataIndex": "valid_until", "width": Lino.chars2width(9), "editor": valid_until406 }, { "colIndex": 10, "sortable": true, "header": "Description", "editable": true, "tooltip": "(uploads.Uploads.description) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "description", "editor": description407 }, { "width": Lino.chars2width(11), "colIndex": 11, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "editable": false, "tooltip": "(uploads.Uploads.owner) " } ];
    Lino.uploads.Uploads.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.Uploads.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/uploads/Uploads","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.uploads.Uploads.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/uploads/Uploads","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.uploads.Uploads.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/uploads/Uploads","GET",pk,"put",null);
};
Lino.uploads.Uploads.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/uploads/Uploads","GET",pk,"post",null);
};

Lino.uploads.Uploads.insertPanel = Ext.extend(Lino.uploads.Uploads.InsertFormPanel,{
  empty_title: "New Uploads",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/uploads/Uploads",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.Uploads.detail;
    this.ls_insert_handler = Lino.uploads.Uploads.insert;
    Lino.uploads.Uploads.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.Uploads.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.uploads.Uploads.insertPanel(p);
});
Lino.uploads.Uploads.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/uploads/Uploads","GET",pk,"poststay",null);
};

Lino.uploads.Uploads.detailPanel = Ext.extend(Lino.uploads.Uploads.DetailFormPanel,{
  empty_title: "Detail Uploads",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/uploads/Uploads",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.Uploads.detail;
    this.ls_insert_handler = Lino.uploads.Uploads.insert;
    Lino.uploads.Uploads.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.Uploads.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.Uploads.detailPanel(p);
});
Lino.uploads.Uploads.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.Uploads.GridPanel(p);
});

// js_render_GridPanel_class pages.Pages
Lino.pages.Pages.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/pages/Pages",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/pages/Pages','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/pages/Pages','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/pages/Pages','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-arrow_up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-arrow_down", "overflowText": "Down", "auto_save": true } ],
  cell_edit : true,
  title : "Nodes",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 9,
  ls_store_fields : [ { "name": "ref" }, { "name": "title" }, { "name": "title_et" }, { "type": "int", "name": "id" }, { "type": "int", "name": "seqno" }, { "name": "parent" }, 'parentHidden', { "type": "boolean", "name": "raw_html" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 38,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.pages.Pages.detail;
    this.ls_insert_handler = Lino.pages.Pages.insert;
    var ww = this.containing_window;
    var ref410 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var title411 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var title_et412 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id413 = new Ext.form.NumberField({ "selectOnFocus": true });
    var seqno414 = new Ext.form.NumberField({ "selectOnFocus": true });
    var parent415 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pages/Pages/parent", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Node..." });
    var raw_html416 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Reference", "editable": true, "tooltip": "(pages.Pages.ref) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ref", "editor": ref410 }, { "colIndex": 1, "sortable": true, "header": "Title", "editable": true, "tooltip": "(pages.Pages.title) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "title", "editor": title411 }, { "colIndex": 2, "sortable": true, "header": "Title (et)", "editable": true, "tooltip": "(pages.Pages.title_et) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "title_et", "editor": title_et412 }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(pages.Pages.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id413, "width": Lino.chars2width(6), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(pages.Pages.seqno) ", "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "width": Lino.chars2width(6), "editor": seqno414 }), { "colIndex": 5, "sortable": true, "header": "Parent", "editable": true, "tooltip": "(pages.Pages.parent) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('parentHidden','Lino.pages.Pages.detail'), "editor": parent415, "dataIndex": "parent" }, { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "raw html", "editable": true, "tooltip": "(pages.Pages.raw_html) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "raw_html" } ];
    Lino.pages.Pages.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.pages.Pages.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/pages/Pages","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.pages.Pages.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/pages/Pages","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.pages.Pages.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/pages/Pages","GET",pk,"put",null);
};
Lino.pages.Pages.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/pages/Pages","GET",pk,"post",null);
};

Lino.pages.Pages.insertPanel = Ext.extend(Lino.pages.Pages.DetailFormPanel,{
  empty_title: "New Nodes",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true } ],
  ls_url: "/pages/Pages",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.pages.Pages.detail;
    this.ls_insert_handler = Lino.pages.Pages.insert;
    Lino.pages.Pages.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.pages.Pages.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pages.Pages.insertPanel(p);
});
Lino.pages.Pages.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/pages/Pages","GET",pk,"poststay",null);
};
Lino.pages.Pages.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/pages/Pages","GET",pk,"duplicate",null);
};

Lino.pages.Pages.detailPanel = Ext.extend(Lino.pages.Pages.DetailFormPanel,{
  empty_title: "Detail Nodes",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-arrow_up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-arrow_down", "overflowText": "Down", "auto_save": true } ],
  ls_url: "/pages/Pages",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.pages.Pages.detail;
    this.ls_insert_handler = Lino.pages.Pages.insert;
    Lino.pages.Pages.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.pages.Pages.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pages.Pages.detailPanel(p);
});
Lino.pages.Pages.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pages.Pages.GridPanel(p);
});
Lino.pages.Pages.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/pages/Pages","GET",pk,"move_up",null);
};
Lino.pages.Pages.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/pages/Pages","GET",pk,"move_down",null);
};

// js_render_GridPanel_class sessions.SessionTable
Lino.sessions.SessionTable.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/sessions/SessionTable",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/sessions/SessionTable','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sessions/SessionTable','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sessions/SessionTable','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "sessions",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 4,
  ls_store_fields : [ { "name": "session_key" }, { "name": "session_data" }, { "name": "expire_date" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 1,
  ls_id_property : "session_key",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var session_key418 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 40 });
    var session_data419 = new Ext.form.TextArea({ "selectOnFocus": true, "allowBlank": false, "growMax": 2000 });
    var expire_date420 = new Ext.form.DisplayField({ "selectOnFocus": true, "allowBlank": false, "value": "<br>" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "session key", "editable": true, "tooltip": "(sessions.SessionTable.session_key) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "session_key", "editor": session_key418 }, { "colIndex": 1, "sortable": false, "header": "session data", "editable": true, "tooltip": "(sessions.SessionTable.session_data) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": session_data419, "dataIndex": "session_data" }, { "colIndex": 2, "sortable": true, "header": "expire date", "editable": true, "tooltip": "(sessions.SessionTable.expire_date) ", "width": Lino.chars2width(17), "dataIndex": "expire_date", "editor": expire_date420 } ];
    Lino.sessions.SessionTable.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sessions.SessionTable.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/sessions/SessionTable","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.sessions.SessionTable.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/sessions/SessionTable","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.sessions.SessionTable.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/sessions/SessionTable","GET",pk,"put",null);
};
Lino.sessions.SessionTable.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/sessions/SessionTable","GET",pk,"post",null);
};
Lino.sessions.SessionTable.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sessions.SessionTable.GridPanel(p);
});

// js_render_GridPanel_class users.MembershipsByUser
Lino.users.MembershipsByUser.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "No data to display." },
  ls_url : "/users/MembershipsByUser",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/users/MembershipsByUser','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/MembershipsByUser','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/MembershipsByUser','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "My Memberships",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 4,
  ls_store_fields : [ { "name": "team" }, 'teamHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 11,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var team28 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MembershipsByUser/team", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Team..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Team", "editable": true, "tooltip": "(users.MembershipsByUser.team) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "team", "editor": team28 } ];
    Lino.users.MembershipsByUser.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MembershipsByUser.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MembershipsByUser","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.users.MembershipsByUser.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MembershipsByUser","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.users.MembershipsByUser.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MembershipsByUser","GET",pk,"put",null);
};
Lino.users.MembershipsByUser.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MembershipsByUser","GET",pk,"post",null);
};
Lino.users.MembershipsByUser.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.MembershipsByUser.GridPanel(p);
});

// js_render_GridPanel_class users.AuthoritiesGiven
Lino.users.AuthoritiesGiven.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "No data to display." },
  ls_url : "/users/AuthoritiesGiven",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/users/AuthoritiesGiven','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/AuthoritiesGiven','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/AuthoritiesGiven','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Authorities given",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 4,
  ls_store_fields : [ { "name": "authorized" }, 'authorizedHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 13,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var authorized33 = new Lino.RemoteComboFieldElement({ "preferred_width": 15, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/AuthoritiesGiven/authorized", "method": "GET" }) }), "emptyText": "Select a User..." });
    this.before_row_edit = function(record) {
      var bp = this.get_base_params();
      authorized33.setContextValue('mk',bp['mk']);
      authorized33.setContextValue('mt',bp['mt']);
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "User", "editable": true, "tooltip": "(users.AuthoritiesGiven.authorized) The user who gets authority to act in your name.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('authorizedHidden','Lino.users.Users.detail'), "editor": authorized33, "dataIndex": "authorized" } ];
    Lino.users.AuthoritiesGiven.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.AuthoritiesGiven.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/AuthoritiesGiven","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.users.AuthoritiesGiven.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/AuthoritiesGiven","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.users.AuthoritiesGiven.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/AuthoritiesGiven","GET",pk,"put",null);
};
Lino.users.AuthoritiesGiven.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/AuthoritiesGiven","GET",pk,"post",null);
};
Lino.users.AuthoritiesGiven.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.AuthoritiesGiven.GridPanel(p);
});

// js_render_GridPanel_class users.AuthoritiesTaken
Lino.users.AuthoritiesTaken.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "No data to display." },
  ls_url : "/users/AuthoritiesTaken",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/users/AuthoritiesTaken','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/AuthoritiesTaken','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/AuthoritiesTaken','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Authorities taken",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 4,
  ls_store_fields : [ { "name": "user" }, 'userHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 13,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var user159 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/AuthoritiesTaken/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Author", "editable": true, "tooltip": "(users.AuthoritiesTaken.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user159, "dataIndex": "user" } ];
    Lino.users.AuthoritiesTaken.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.AuthoritiesTaken.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/AuthoritiesTaken","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.users.AuthoritiesTaken.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/AuthoritiesTaken","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.users.AuthoritiesTaken.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/AuthoritiesTaken","GET",pk,"put",null);
};
Lino.users.AuthoritiesTaken.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/AuthoritiesTaken","GET",pk,"post",null);
};
Lino.users.AuthoritiesTaken.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.AuthoritiesTaken.GridPanel(p);
});

// js_render_GridPanel_class contacts.RolesByCompany
Lino.contacts.RolesByCompany.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "No data to display." },
  ls_url : "/contacts/RolesByCompany",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/contacts/RolesByCompany','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/RolesByCompany','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/RolesByCompany','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Contact persons",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "name": "person" }, 'personHidden', { "name": "type" }, 'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 20,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var person422 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/RolesByCompany/person", "method": "GET" }) }), "emptyText": "Select a Person..." });
    var type423 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/RolesByCompany/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Function..." });
    var id424 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Person", "editable": true, "tooltip": "(contacts.RolesByCompany.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "person", "editor": person422 }, { "colIndex": 1, "sortable": true, "header": "Contact Role", "editable": true, "tooltip": "(contacts.RolesByCompany.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type423 }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.RolesByCompany.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "hidden": true, "editor": id424, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.RolesByCompany.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.RolesByCompany.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RolesByCompany","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.contacts.RolesByCompany.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RolesByCompany","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.contacts.RolesByCompany.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RolesByCompany","GET",pk,"put",null);
};
Lino.contacts.RolesByCompany.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RolesByCompany","GET",pk,"post",null);
};
Lino.contacts.RolesByCompany.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.RolesByCompany.GridPanel(p);
});

// js_render_GridPanel_class contacts.RolesByPerson
Lino.contacts.RolesByPerson.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "No data to display." },
  ls_url : "/contacts/RolesByPerson",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/contacts/RolesByPerson','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/RolesByPerson','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/RolesByPerson','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Contact for",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "name": "company" }, 'companyHidden', { "name": "type" }, 'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 20,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var company426 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/RolesByPerson/company", "method": "GET" }) }), "emptyText": "Select a Company..." });
    var type427 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/RolesByPerson/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Function..." });
    var id428 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Company", "editable": true, "tooltip": "(contacts.RolesByPerson.company) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "company", "editor": company426 }, { "colIndex": 1, "sortable": true, "header": "Contact Role", "editable": true, "tooltip": "(contacts.RolesByPerson.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type427 }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.RolesByPerson.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "hidden": true, "editor": id428, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.RolesByPerson.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.RolesByPerson.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RolesByPerson","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.contacts.RolesByPerson.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RolesByPerson","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.contacts.RolesByPerson.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RolesByPerson","GET",pk,"put",null);
};
Lino.contacts.RolesByPerson.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RolesByPerson","GET",pk,"post",null);
};
Lino.contacts.RolesByPerson.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.RolesByPerson.GridPanel(p);
});

// js_render_GridPanel_class projects.MyProjects
Lino.projects.MyProjects.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/projects/MyProjects",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/projects/MyProjects','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/projects/MyProjects','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/projects/MyProjects','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.list_action_handler('/projects/MyProjects','do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Clear cache", "auto_save": true } ],
  cell_edit : true,
  title : "My Projects",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 9,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "build_time" }, { "name": "name" }, { "name": "type" }, 'typeHidden', { "type": "date", "name": "started", "dateFormat": "d.m.Y" }, { "type": "date", "name": "stopped", "dateFormat": "d.m.Y" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 23,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.projects.MyProjects.detail;
    this.ls_insert_handler = Lino.projects.MyProjects.insert;
    var ww = this.containing_window;
    var id430 = new Ext.form.NumberField({ "selectOnFocus": true });
    var build_time431 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var name432 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var type433 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/projects/MyProjects/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project Type..." });
    var started434 = new Lino.DateField({ "selectOnFocus": true });
    var stopped435 = new Lino.DateField({ "selectOnFocus": true });
    var text436 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(projects.MyProjects.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id430, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(17), "colIndex": 1, "sortable": true, "dataIndex": "build_time", "header": "build time", "editable": false, "tooltip": "(projects.MyProjects.build_time) " }, { "colIndex": 2, "sortable": true, "header": "name", "editable": true, "tooltip": "(projects.MyProjects.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name432 }, { "colIndex": 3, "sortable": true, "header": "Project Type", "editable": true, "tooltip": "(projects.MyProjects.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type433 }, { "colIndex": 4, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(projects.MyProjects.started) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "started", "dataIndex": "started", "width": Lino.chars2width(9), "editor": started434 }, { "colIndex": 5, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(projects.MyProjects.stopped) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "stopped", "dataIndex": "stopped", "width": Lino.chars2width(9), "editor": stopped435 }, { "colIndex": 6, "sortable": false, "header": "text", "editable": true, "tooltip": "(projects.MyProjects.text) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": text436, "dataIndex": "text" } ];
    Lino.projects.MyProjects.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.projects.MyProjects.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/projects/MyProjects","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.projects.MyProjects.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/projects/MyProjects","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.projects.MyProjects.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/projects/MyProjects","GET",pk,"put",null);
};
Lino.projects.MyProjects.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/projects/MyProjects","GET",pk,"post",null);
};

Lino.projects.MyProjects.insertPanel = Ext.extend(Lino.projects.Projects.DetailFormPanel,{
  empty_title: "New My Projects",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true } ],
  ls_url: "/projects/MyProjects",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.projects.MyProjects.detail;
    this.ls_insert_handler = Lino.projects.MyProjects.insert;
    Lino.projects.MyProjects.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.projects.MyProjects.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.projects.MyProjects.insertPanel(p);
});
Lino.projects.MyProjects.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/projects/MyProjects","GET",pk,"poststay",null);
};
Lino.projects.MyProjects.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/projects/MyProjects","GET",pk,"duplicate",null);
};

Lino.projects.MyProjects.detailPanel = Ext.extend(Lino.projects.Projects.DetailFormPanel,{
  empty_title: "Detail My Projects",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.list_action_handler('/projects/MyProjects','do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Clear cache", "auto_save": true } ],
  ls_url: "/projects/MyProjects",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.projects.MyProjects.detail;
    this.ls_insert_handler = Lino.projects.MyProjects.insert;
    Lino.projects.MyProjects.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.projects.MyProjects.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.projects.MyProjects.detailPanel(p);
});
Lino.projects.MyProjects.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/projects/MyProjects","POST",pk,"do_print",null);
};
Lino.projects.MyProjects.do_clear_cache = function(rp,pk) { 
  Lino.run_row_action(rp,"/projects/MyProjects","GET",pk,"do_clear_cache",null);
};
Lino.projects.MyProjects.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.projects.MyProjects.GridPanel(p);
});

// js_render_GridPanel_class outbox.RecipientsByMail
Lino.outbox.RecipientsByMail.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/outbox/RecipientsByMail",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/outbox/RecipientsByMail','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/outbox/RecipientsByMail','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/outbox/RecipientsByMail','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Recipients",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 8,
  ls_store_fields : [ { "name": "partner" }, 'partnerHidden', { "name": "address" }, { "name": "name" }, { "name": "type" }, 'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 36,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var partner279 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/RecipientsByMail/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var address280 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var name281 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var type282 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.outbox.RecipientType });
    var id283 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(outbox.RecipientsByMail.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "partner", "editor": partner279 }, { "colIndex": 1, "sortable": true, "header": "Address", "editable": true, "tooltip": "(outbox.RecipientsByMail.address) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "address", "editor": address280 }, { "colIndex": 2, "sortable": true, "header": "Name", "editable": true, "tooltip": "(outbox.RecipientsByMail.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "editor": name281 }, { "colIndex": 3, "sortable": true, "header": "Recipient Type", "editable": true, "tooltip": "(outbox.RecipientsByMail.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "type", "editor": type282 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(outbox.RecipientsByMail.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id283, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.outbox.RecipientsByMail.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.RecipientsByMail.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/RecipientsByMail","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.outbox.RecipientsByMail.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/RecipientsByMail","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.outbox.RecipientsByMail.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/RecipientsByMail","GET",pk,"put",null);
};
Lino.outbox.RecipientsByMail.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/RecipientsByMail","GET",pk,"post",null);
};
Lino.outbox.RecipientsByMail.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.RecipientsByMail.GridPanel(p);
});

// js_render_GridPanel_class outbox.MailsByUser
Lino.outbox.MailsByUser.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/outbox/MailsByUser",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/outbox/MailsByUser','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/outbox/MailsByUser','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/outbox/MailsByUser','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Edit Print Template", "must_save": true, "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Edit Print Template", "overflowText": "Edit Print Template", "auto_save": true }, { "itemId": "send_mail", "menu_item_text": "Send email", "must_save": true, "tooltip": "Send email", "panel_btn_handler": Lino.row_action_handler('send_mail','GET',null), "iconCls": "x-tbar-email_go", "overflowText": "Send email", "auto_save": true } ],
  cell_edit : true,
  title : "Outbox",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 5,
  ls_store_fields : [ { "name": "sent" }, { "name": "subject" }, { "name": "recipients" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 35,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByUser.detail;
    this.ls_insert_handler = Lino.outbox.MailsByUser.insert;
    var ww = this.containing_window;
    var sent438 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var subject439 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var recipients_htmlbox440 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "recipients", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Recipients", "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;" });
    this.before_row_edit = function(record) {
      recipients_htmlbox440.refresh();
    };
    this.ls_columns = [ { "width": Lino.chars2width(17), "colIndex": 0, "sortable": true, "dataIndex": "sent", "header": "sent", "editable": false, "tooltip": "(outbox.MailsByUser.sent) " }, { "colIndex": 1, "sortable": true, "header": "Subject", "editable": true, "tooltip": "(outbox.MailsByUser.subject) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "subject", "editor": subject439 }, { "width": Lino.chars2width(31), "colIndex": 2, "sortable": false, "dataIndex": "recipients", "header": "Recipients", "editable": false, "tooltip": "(outbox.MailsByUser.recipients) " } ];
    Lino.outbox.MailsByUser.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MailsByUser.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByUser","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.outbox.MailsByUser.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByUser","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.outbox.MailsByUser.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByUser","GET",pk,"put",null);
};
Lino.outbox.MailsByUser.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByUser","GET",pk,"post",null);
};

Lino.outbox.MailsByUser.insertPanel = Ext.extend(Lino.outbox.MailsByUser.InsertFormPanel,{
  empty_title: "New Outbox",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/outbox/MailsByUser",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByUser.detail;
    this.ls_insert_handler = Lino.outbox.MailsByUser.insert;
    Lino.outbox.MailsByUser.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MailsByUser.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(20) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.outbox.MailsByUser.insertPanel(p);
});
Lino.outbox.MailsByUser.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByUser","GET",pk,"poststay",null);
};

Lino.outbox.MailsByUser.detailPanel = Ext.extend(Lino.outbox.MailsByUser.DetailFormPanel,{
  empty_title: "Detail Outbox",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Edit Print Template", "must_save": true, "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Edit Print Template", "overflowText": "Edit Print Template", "auto_save": true }, { "itemId": "send_mail", "menu_item_text": "Send email", "must_save": true, "tooltip": "Send email", "panel_btn_handler": Lino.row_action_handler('send_mail','GET',null), "iconCls": "x-tbar-email_go", "overflowText": "Send email", "auto_save": true } ],
  ls_url: "/outbox/MailsByUser",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByUser.detail;
    this.ls_insert_handler = Lino.outbox.MailsByUser.insert;
    Lino.outbox.MailsByUser.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MailsByUser.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.MailsByUser.detailPanel(p);
});
Lino.outbox.MailsByUser.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByUser","GET",pk,"do_print",null);
};
Lino.outbox.MailsByUser.edit_template = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByUser","GET",pk,"edit_template",null);
};
Lino.outbox.MailsByUser.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.MailsByUser.GridPanel(p);
});
Lino.outbox.MailsByUser.send_mail = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByUser","GET",pk,"send_mail",null);
};

// js_render_GridPanel_class outbox.MailsByProject
Lino.outbox.MailsByProject.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/outbox/MailsByProject",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/outbox/MailsByProject','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/outbox/MailsByProject','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/outbox/MailsByProject','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Edit Print Template", "must_save": true, "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Edit Print Template", "overflowText": "Edit Print Template", "auto_save": true }, { "itemId": "send_mail", "menu_item_text": "Send email", "must_save": true, "tooltip": "Send email", "panel_btn_handler": Lino.row_action_handler('send_mail','GET',null), "iconCls": "x-tbar-email_go", "overflowText": "Send email", "auto_save": true } ],
  cell_edit : true,
  title : "Outbox",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 13,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "subject" }, { "name": "recipients" }, { "name": "user" }, 'userHidden', { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "sent" }, { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 35,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByProject.detail;
    this.ls_insert_handler = Lino.outbox.MailsByProject.insert;
    var ww = this.containing_window;
    var date442 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var subject443 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var recipients_htmlbox444 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "recipients", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Recipients", "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;" });
    var user445 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/MailsByProject/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var id446 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type447 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/MailsByProject/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id448 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/MailsByProject/owner_id", "method": "GET" }) }) });
    var sent449 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var owner_disp450 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      recipients_htmlbox444.refresh();
      owner_id448.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type447.on('change',Lino.chooser_handler(owner_id448,'owner_type'));
      Lino.outbox.MailsByProject.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(outbox.MailsByProject.date) \n        The official date to be printed on the document.\n        ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "date", "width": Lino.chars2width(9), "editor": date442 }, { "colIndex": 1, "sortable": true, "header": "Subject", "editable": true, "tooltip": "(outbox.MailsByProject.subject) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "subject", "editor": subject443 }, { "width": Lino.chars2width(31), "colIndex": 2, "sortable": false, "dataIndex": "recipients", "header": "Recipients", "editable": false, "tooltip": "(outbox.MailsByProject.recipients) " }, { "colIndex": 3, "sortable": true, "header": "Sender", "editable": true, "tooltip": "(outbox.MailsByProject.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user445, "dataIndex": "user" }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(outbox.MailsByProject.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id446, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Controlled by (type)", "editable": true, "tooltip": "(outbox.MailsByProject.owner_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.system.ContentTypes.detail'), "editor": owner_type447, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Controlled by (object)", "editable": true, "tooltip": "(outbox.MailsByProject.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id448 }, { "width": Lino.chars2width(17), "colIndex": 7, "sortable": true, "dataIndex": "sent", "header": "sent", "editable": false, "tooltip": "(outbox.MailsByProject.sent) " }, { "width": Lino.chars2width(11), "colIndex": 8, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "editable": false, "tooltip": "(outbox.MailsByProject.owner) " } ];
    Lino.outbox.MailsByProject.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MailsByProject.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByProject","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.outbox.MailsByProject.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByProject","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.outbox.MailsByProject.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByProject","GET",pk,"put",null);
};
Lino.outbox.MailsByProject.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByProject","GET",pk,"post",null);
};

Lino.outbox.MailsByProject.insertPanel = Ext.extend(Lino.outbox.MailsByUser.InsertFormPanel,{
  empty_title: "New Outbox",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/outbox/MailsByProject",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByProject.detail;
    this.ls_insert_handler = Lino.outbox.MailsByProject.insert;
    Lino.outbox.MailsByProject.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MailsByProject.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(20) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.outbox.MailsByProject.insertPanel(p);
});
Lino.outbox.MailsByProject.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByProject","GET",pk,"poststay",null);
};

Lino.outbox.MailsByProject.detailPanel = Ext.extend(Lino.outbox.MailsByUser.DetailFormPanel,{
  empty_title: "Detail Outbox",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Edit Print Template", "must_save": true, "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Edit Print Template", "overflowText": "Edit Print Template", "auto_save": true }, { "itemId": "send_mail", "menu_item_text": "Send email", "must_save": true, "tooltip": "Send email", "panel_btn_handler": Lino.row_action_handler('send_mail','GET',null), "iconCls": "x-tbar-email_go", "overflowText": "Send email", "auto_save": true } ],
  ls_url: "/outbox/MailsByProject",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByProject.detail;
    this.ls_insert_handler = Lino.outbox.MailsByProject.insert;
    Lino.outbox.MailsByProject.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MailsByProject.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.MailsByProject.detailPanel(p);
});
Lino.outbox.MailsByProject.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByProject","GET",pk,"do_print",null);
};
Lino.outbox.MailsByProject.edit_template = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByProject","GET",pk,"edit_template",null);
};
Lino.outbox.MailsByProject.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.MailsByProject.GridPanel(p);
});
Lino.outbox.MailsByProject.send_mail = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByProject","GET",pk,"send_mail",null);
};

// js_render_GridPanel_class outbox.SentByPartner
Lino.outbox.SentByPartner.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/outbox/SentByPartner",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/outbox/SentByPartner','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/outbox/SentByPartner','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/outbox/SentByPartner','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Edit Print Template", "must_save": true, "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Edit Print Template", "overflowText": "Edit Print Template", "auto_save": true }, { "itemId": "send_mail", "menu_item_text": "Send email", "must_save": true, "tooltip": "Send email", "panel_btn_handler": Lino.row_action_handler('send_mail','GET',null), "iconCls": "x-tbar-email_go", "overflowText": "Send email", "auto_save": true } ],
  cell_edit : true,
  title : "Outbox",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "name": "sent" }, { "name": "subject" }, { "name": "user" }, 'userHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 35,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.SentByPartner.detail;
    this.ls_insert_handler = Lino.outbox.SentByPartner.insert;
    var ww = this.containing_window;
    var sent452 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var subject453 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var user454 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/SentByPartner/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(17), "colIndex": 0, "sortable": true, "dataIndex": "sent", "header": "sent", "editable": false, "tooltip": "(outbox.SentByPartner.sent) " }, { "colIndex": 1, "sortable": true, "header": "Subject", "editable": true, "tooltip": "(outbox.SentByPartner.subject) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "subject", "editor": subject453 }, { "colIndex": 2, "sortable": true, "header": "Sender", "editable": true, "tooltip": "(outbox.SentByPartner.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user454, "dataIndex": "user" } ];
    Lino.outbox.SentByPartner.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.SentByPartner.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/SentByPartner","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.outbox.SentByPartner.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/SentByPartner","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.outbox.SentByPartner.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/SentByPartner","GET",pk,"put",null);
};
Lino.outbox.SentByPartner.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/SentByPartner","GET",pk,"post",null);
};

Lino.outbox.SentByPartner.insertPanel = Ext.extend(Lino.outbox.MailsByUser.InsertFormPanel,{
  empty_title: "New Outbox",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/outbox/SentByPartner",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.SentByPartner.detail;
    this.ls_insert_handler = Lino.outbox.SentByPartner.insert;
    Lino.outbox.SentByPartner.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.SentByPartner.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(20) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.outbox.SentByPartner.insertPanel(p);
});
Lino.outbox.SentByPartner.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/SentByPartner","GET",pk,"poststay",null);
};

Lino.outbox.SentByPartner.detailPanel = Ext.extend(Lino.outbox.MailsByUser.DetailFormPanel,{
  empty_title: "Detail Outbox",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Edit Print Template", "must_save": true, "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Edit Print Template", "overflowText": "Edit Print Template", "auto_save": true }, { "itemId": "send_mail", "menu_item_text": "Send email", "must_save": true, "tooltip": "Send email", "panel_btn_handler": Lino.row_action_handler('send_mail','GET',null), "iconCls": "x-tbar-email_go", "overflowText": "Send email", "auto_save": true } ],
  ls_url: "/outbox/SentByPartner",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.SentByPartner.detail;
    this.ls_insert_handler = Lino.outbox.SentByPartner.insert;
    Lino.outbox.SentByPartner.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.SentByPartner.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.SentByPartner.detailPanel(p);
});
Lino.outbox.SentByPartner.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/SentByPartner","GET",pk,"do_print",null);
};
Lino.outbox.SentByPartner.edit_template = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/SentByPartner","GET",pk,"edit_template",null);
};
Lino.outbox.SentByPartner.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.SentByPartner.GridPanel(p);
});
Lino.outbox.SentByPartner.send_mail = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/SentByPartner","GET",pk,"send_mail",null);
};

// js_render_GridPanel_class uploads.MyUploads
Lino.uploads.MyUploads.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/uploads/MyUploads",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/uploads/MyUploads','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/uploads/MyUploads','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/uploads/MyUploads','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "My Uploads",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 17,
  ls_store_fields : [ { "name": "file" }, { "name": "description" }, { "name": "user" }, 'userHidden', { "name": "owner" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "created" }, { "name": "modified" }, { "name": "mimetype" }, { "name": "type" }, 'typeHidden', { "type": "date", "name": "valid_until", "dateFormat": "d.m.Y" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 26,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.MyUploads.detail;
    this.ls_insert_handler = Lino.uploads.MyUploads.insert;
    var ww = this.containing_window;
    var file456 = Lino.file_field_handler(this,{ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var description457 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var user458 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/MyUploads/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var owner_disp459 = new Ext.form.DisplayField({ "disabled": true });
    var id460 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type461 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/MyUploads/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id462 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/MyUploads/owner_id", "method": "GET" }) }) });
    var created463 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified464 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var mimetype465 = new Ext.form.TextField({ "disabled": true, "maxLength": 64 });
    var type466 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/MyUploads/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Upload Type..." });
    var valid_until467 = new Lino.DateField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      owner_id462.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type461.on('change',Lino.chooser_handler(owner_id462,'owner_type'));
      Lino.uploads.MyUploads.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "File", "editable": true, "tooltip": "(uploads.MyUploads.file) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "file", "editor": file456 }, { "colIndex": 1, "sortable": true, "header": "Description", "editable": true, "tooltip": "(uploads.MyUploads.description) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "description", "editor": description457 }, { "colIndex": 2, "sortable": true, "header": "Author", "editable": true, "tooltip": "(uploads.MyUploads.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user458, "dataIndex": "user" }, { "width": Lino.chars2width(11), "colIndex": 3, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "editable": false, "tooltip": "(uploads.MyUploads.owner) " }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(uploads.MyUploads.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id460, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Controlled by (type)", "editable": true, "tooltip": "(uploads.MyUploads.owner_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.system.ContentTypes.detail'), "editor": owner_type461, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Controlled by (object)", "editable": true, "tooltip": "(uploads.MyUploads.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id462 }, { "width": Lino.chars2width(17), "colIndex": 7, "sortable": true, "dataIndex": "created", "header": "Created", "editable": false, "tooltip": "(uploads.MyUploads.created) " }, { "width": Lino.chars2width(17), "colIndex": 8, "sortable": true, "dataIndex": "modified", "header": "Modified", "editable": false, "tooltip": "(uploads.MyUploads.modified) " }, { "colIndex": 9, "sortable": true, "header": "MIME type", "editable": false, "tooltip": "(uploads.MyUploads.mimetype) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "mimetype" }, { "colIndex": 10, "sortable": true, "header": "Upload Type", "editable": true, "tooltip": "(uploads.MyUploads.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type466 }, { "colIndex": 11, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(uploads.MyUploads.valid_until) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "valid until", "dataIndex": "valid_until", "width": Lino.chars2width(9), "editor": valid_until467 } ];
    Lino.uploads.MyUploads.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.MyUploads.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/uploads/MyUploads","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.uploads.MyUploads.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/uploads/MyUploads","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.uploads.MyUploads.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/uploads/MyUploads","GET",pk,"put",null);
};
Lino.uploads.MyUploads.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/uploads/MyUploads","GET",pk,"post",null);
};

Lino.uploads.MyUploads.insertPanel = Ext.extend(Lino.uploads.Uploads.InsertFormPanel,{
  empty_title: "New My Uploads",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/uploads/MyUploads",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.MyUploads.detail;
    this.ls_insert_handler = Lino.uploads.MyUploads.insert;
    Lino.uploads.MyUploads.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.MyUploads.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.uploads.MyUploads.insertPanel(p);
});
Lino.uploads.MyUploads.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/uploads/MyUploads","GET",pk,"poststay",null);
};

Lino.uploads.MyUploads.detailPanel = Ext.extend(Lino.uploads.Uploads.DetailFormPanel,{
  empty_title: "Detail My Uploads",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/uploads/MyUploads",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.MyUploads.detail;
    this.ls_insert_handler = Lino.uploads.MyUploads.insert;
    Lino.uploads.MyUploads.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.MyUploads.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.MyUploads.detailPanel(p);
});
Lino.uploads.MyUploads.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.MyUploads.GridPanel(p);
});

// js_render_GridPanel_class uploads.UploadsByController
Lino.uploads.UploadsByController.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/uploads/UploadsByController",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/uploads/UploadsByController','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/uploads/UploadsByController','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/uploads/UploadsByController','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Uploads",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 16,
  ls_store_fields : [ { "name": "file" }, { "name": "type" }, 'typeHidden', { "name": "description" }, { "name": "user" }, 'userHidden', { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "created" }, { "name": "modified" }, { "name": "mimetype" }, { "type": "date", "name": "valid_until", "dateFormat": "d.m.Y" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 26,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.UploadsByController.detail;
    this.ls_insert_handler = Lino.uploads.UploadsByController.insert;
    var ww = this.containing_window;
    var file469 = Lino.file_field_handler(this,{ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var type470 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/UploadsByController/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Upload Type..." });
    var description471 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var user472 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/UploadsByController/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var id473 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type474 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/UploadsByController/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id475 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/UploadsByController/owner_id", "method": "GET" }) }) });
    var created476 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified477 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var mimetype478 = new Ext.form.TextField({ "disabled": true, "maxLength": 64 });
    var valid_until479 = new Lino.DateField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      owner_id475.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type474.on('change',Lino.chooser_handler(owner_id475,'owner_type'));
      Lino.uploads.UploadsByController.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "File", "editable": true, "tooltip": "(uploads.UploadsByController.file) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "file", "editor": file469 }, { "colIndex": 1, "sortable": true, "header": "Upload Type", "editable": true, "tooltip": "(uploads.UploadsByController.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type470 }, { "colIndex": 2, "sortable": true, "header": "Description", "editable": true, "tooltip": "(uploads.UploadsByController.description) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "description", "editor": description471 }, { "colIndex": 3, "sortable": true, "header": "Author", "editable": true, "tooltip": "(uploads.UploadsByController.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user472, "dataIndex": "user" }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(uploads.UploadsByController.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id473, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Controlled by (type)", "editable": true, "tooltip": "(uploads.UploadsByController.owner_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.system.ContentTypes.detail'), "editor": owner_type474, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Controlled by (object)", "editable": true, "tooltip": "(uploads.UploadsByController.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id475 }, { "width": Lino.chars2width(17), "colIndex": 7, "sortable": true, "dataIndex": "created", "header": "Created", "editable": false, "tooltip": "(uploads.UploadsByController.created) " }, { "width": Lino.chars2width(17), "colIndex": 8, "sortable": true, "dataIndex": "modified", "header": "Modified", "editable": false, "tooltip": "(uploads.UploadsByController.modified) " }, { "colIndex": 9, "sortable": true, "header": "MIME type", "editable": false, "tooltip": "(uploads.UploadsByController.mimetype) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "mimetype" }, { "colIndex": 10, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(uploads.UploadsByController.valid_until) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "valid until", "dataIndex": "valid_until", "width": Lino.chars2width(9), "editor": valid_until479 } ];
    Lino.uploads.UploadsByController.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.UploadsByController.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/uploads/UploadsByController","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.uploads.UploadsByController.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/uploads/UploadsByController","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.uploads.UploadsByController.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/uploads/UploadsByController","GET",pk,"put",null);
};
Lino.uploads.UploadsByController.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/uploads/UploadsByController","GET",pk,"post",null);
};

Lino.uploads.UploadsByController.insertPanel = Ext.extend(Lino.uploads.Uploads.InsertFormPanel,{
  empty_title: "New Uploads",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/uploads/UploadsByController",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.UploadsByController.detail;
    this.ls_insert_handler = Lino.uploads.UploadsByController.insert;
    Lino.uploads.UploadsByController.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.UploadsByController.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.uploads.UploadsByController.insertPanel(p);
});
Lino.uploads.UploadsByController.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/uploads/UploadsByController","GET",pk,"poststay",null);
};

Lino.uploads.UploadsByController.detailPanel = Ext.extend(Lino.uploads.Uploads.DetailFormPanel,{
  empty_title: "Detail Uploads",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/uploads/UploadsByController",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.UploadsByController.detail;
    this.ls_insert_handler = Lino.uploads.UploadsByController.insert;
    Lino.uploads.UploadsByController.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.UploadsByController.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.UploadsByController.detailPanel(p);
});
Lino.uploads.UploadsByController.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.UploadsByController.GridPanel(p);
});

// js_render_GridPanel_class system.HelpTextsByModel
Lino.system.HelpTextsByModel.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/system/HelpTextsByModel",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/system/HelpTextsByModel','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/HelpTextsByModel','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/HelpTextsByModel','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Help Texts",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "name": "field" }, { "name": "verbose_name" }, { "name": "help_text" }, { "type": "int", "name": "id" }, { "name": "content_type" }, 'content_typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 9,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var field196 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/HelpTextsByModel/field", "method": "GET" }) }) });
    var verbose_name197 = new Ext.form.TextField({ "disabled": true, "maxLength": 200 });
    var help_text198 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var id199 = new Ext.form.NumberField({ "selectOnFocus": true });
    var content_type200 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/HelpTextsByModel/content_type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a content type..." });
    this.before_row_edit = function(record) {
      var bp = this.get_base_params();
      field196.setContextValue('mk',bp['mk']);
      field196.setContextValue('mt',bp['mt']);
    };
    this.onRender = function(ct, position) {
      content_type200.on('change',Lino.chooser_handler(field196,'content_type'));
      Lino.system.HelpTextsByModel.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Field", "editable": true, "tooltip": "(system.HelpTextsByModel.field) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "field", "editor": field196 }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "verbose_name", "header": "Verbose name", "editable": false, "tooltip": "(system.HelpTextsByModel.verbose_name) " }, { "colIndex": 2, "sortable": false, "header": "HelpText", "editable": true, "tooltip": "(system.HelpTextsByModel.help_text) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": help_text198, "dataIndex": "help_text" }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.HelpTextsByModel.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id199, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Model", "editable": true, "tooltip": "(system.HelpTextsByModel.content_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('content_typeHidden','Lino.system.ContentTypes.detail'), "editor": content_type200, "dataIndex": "content_type" } ];
    Lino.system.HelpTextsByModel.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.system.HelpTextsByModel.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/HelpTextsByModel","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.system.HelpTextsByModel.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/HelpTextsByModel","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.system.HelpTextsByModel.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/HelpTextsByModel","GET",pk,"put",null);
};
Lino.system.HelpTextsByModel.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/HelpTextsByModel","GET",pk,"post",null);
};
Lino.system.HelpTextsByModel.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.system.HelpTextsByModel.GridPanel(p);
});

// js_render_GridPanel_class outbox.MailsByController
Lino.outbox.MailsByController.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/outbox/MailsByController",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/outbox/MailsByController','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/outbox/MailsByController','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/outbox/MailsByController','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Edit Print Template", "must_save": true, "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Edit Print Template", "overflowText": "Edit Print Template", "auto_save": true }, { "itemId": "send_mail", "menu_item_text": "Send email", "must_save": true, "tooltip": "Send email", "panel_btn_handler": Lino.row_action_handler('send_mail','GET',null), "iconCls": "x-tbar-email_go", "overflowText": "Send email", "auto_save": true } ],
  cell_edit : true,
  title : "Outgoing Mails",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 15,
  ls_store_fields : [ { "name": "sent" }, { "name": "recipients" }, { "name": "subject" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "user" }, 'userHidden', { "name": "project" }, 'projectHidden', { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "body" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 35,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByController.detail;
    this.ls_insert_handler = Lino.outbox.MailsByController.insert;
    var ww = this.containing_window;
    var sent481 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var recipients_htmlbox482 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "recipients", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Recipients", "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;" });
    var subject483 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id484 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type485 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/MailsByController/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id486 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/MailsByController/owner_id", "method": "GET" }) }) });
    var user487 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/MailsByController/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var project488 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/MailsByController/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var date489 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var body490 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Body" });
    this.before_row_edit = function(record) {
      recipients_htmlbox482.refresh();
      owner_id486.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      body490.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type485.on('change',Lino.chooser_handler(owner_id486,'owner_type'));
      Lino.outbox.MailsByController.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(17), "colIndex": 0, "sortable": true, "dataIndex": "sent", "header": "sent", "editable": false, "tooltip": "(outbox.MailsByController.sent) " }, { "width": Lino.chars2width(31), "colIndex": 1, "sortable": false, "dataIndex": "recipients", "header": "Recipients", "editable": false, "tooltip": "(outbox.MailsByController.recipients) " }, { "colIndex": 2, "sortable": true, "header": "Subject", "editable": true, "tooltip": "(outbox.MailsByController.subject) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "subject", "editor": subject483 }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(outbox.MailsByController.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id484, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Controlled by (type)", "editable": true, "tooltip": "(outbox.MailsByController.owner_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.system.ContentTypes.detail'), "editor": owner_type485, "dataIndex": "owner_type" }, { "colIndex": 5, "sortable": true, "header": "Controlled by (object)", "editable": true, "tooltip": "(outbox.MailsByController.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id486 }, { "colIndex": 6, "sortable": true, "header": "Sender", "editable": true, "tooltip": "(outbox.MailsByController.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user487, "dataIndex": "user" }, { "colIndex": 7, "sortable": true, "header": "Project", "editable": true, "tooltip": "(outbox.MailsByController.project) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.projects.Projects.detail'), "editor": project488, "dataIndex": "project" }, { "colIndex": 8, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(outbox.MailsByController.date) \n        The official date to be printed on the document.\n        ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "date", "width": Lino.chars2width(9), "editor": date489 }, { "colIndex": 9, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(outbox.MailsByController.body) ", "filter": { "type": "string" }, "header": "body", "renderer": Lino.text_renderer, "hidden": true, "editor": body490, "dataIndex": "body" } ];
    Lino.outbox.MailsByController.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MailsByController.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByController","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.outbox.MailsByController.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByController","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.outbox.MailsByController.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByController","GET",pk,"put",null);
};
Lino.outbox.MailsByController.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByController","GET",pk,"post",null);
};

Lino.outbox.MailsByController.insertPanel = Ext.extend(Lino.outbox.MailsByUser.InsertFormPanel,{
  empty_title: "New Outgoing Mails",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/outbox/MailsByController",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByController.detail;
    this.ls_insert_handler = Lino.outbox.MailsByController.insert;
    Lino.outbox.MailsByController.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MailsByController.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(20) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.outbox.MailsByController.insertPanel(p);
});
Lino.outbox.MailsByController.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByController","GET",pk,"poststay",null);
};

Lino.outbox.MailsByController.detailPanel = Ext.extend(Lino.outbox.MailsByUser.DetailFormPanel,{
  empty_title: "Detail Outgoing Mails",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Edit Print Template", "must_save": true, "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Edit Print Template", "overflowText": "Edit Print Template", "auto_save": true }, { "itemId": "send_mail", "menu_item_text": "Send email", "must_save": true, "tooltip": "Send email", "panel_btn_handler": Lino.row_action_handler('send_mail','GET',null), "iconCls": "x-tbar-email_go", "overflowText": "Send email", "auto_save": true } ],
  ls_url: "/outbox/MailsByController",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByController.detail;
    this.ls_insert_handler = Lino.outbox.MailsByController.insert;
    Lino.outbox.MailsByController.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MailsByController.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.MailsByController.detailPanel(p);
});
Lino.outbox.MailsByController.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByController","GET",pk,"do_print",null);
};
Lino.outbox.MailsByController.edit_template = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByController","GET",pk,"edit_template",null);
};
Lino.outbox.MailsByController.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.MailsByController.GridPanel(p);
});
Lino.outbox.MailsByController.send_mail = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/MailsByController","GET",pk,"send_mail",null);
};

// js_render_GridPanel_class about.Models
Lino.about.Models.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/about/Models",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/about/Models','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/about/Models','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/about/Models','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true } ],
  cell_edit : true,
  title : "Models",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "name": "app" }, { "name": "name" }, { "name": "docstring" }, { "name": "rows" }, { "name": "detail_action" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "No data to display." },
  disable_editing : true,
  initComponent : function() {
    this.ls_detail_handler = Lino.about.Models.detail;
    var ww = this.containing_window;
    var app_disp492 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var name_disp493 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var docstring_disp494 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var rows495 = new Ext.form.NumberField({ "disabled": true });
    var detail_action_disp496 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(31), "colIndex": 0, "sortable": false, "dataIndex": "app", "header": "app_label", "editable": false, "tooltip": "(about.Models.app) " }, { "width": Lino.chars2width(31), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(about.Models.name) " }, { "width": Lino.chars2width(31), "colIndex": 2, "sortable": false, "dataIndex": "docstring", "header": "docstring", "editable": false, "tooltip": "(about.Models.docstring) " }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": false, "format": "0", "editable": false, "tooltip": "(about.Models.rows) ", "header": "Rows", "dataIndex": "rows", "width": Lino.chars2width(6) }), { "width": Lino.chars2width(31), "colIndex": 4, "sortable": false, "dataIndex": "detail_action", "header": "detail_action", "editable": false, "tooltip": "(about.Models.detail_action) " } ];
    Lino.about.Models.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.about.Models.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/about/Models","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.about.Models.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/about/Models","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};

Lino.about.Models.detailPanel = Ext.extend(Lino.about.Models.DetailFormPanel,{
  empty_title: "Detail Models",
  ls_bbar_actions: [  ],
  ls_url: "/about/Models",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.about.Models.detail;
    Lino.about.Models.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.about.Models.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.about.Models.detailPanel(p);
});
Lino.about.Models.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.about.Models.GridPanel(p);
});

// js_render_GridPanel_class about.FieldsByModel
Lino.about.FieldsByModel.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/about/FieldsByModel",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/about/FieldsByModel','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/about/FieldsByModel','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/about/FieldsByModel','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" } ],
  cell_edit : true,
  title : "Fields",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  disabled_actions_index : 4,
  ls_store_fields : [ { "name": "name" }, { "name": "verbose_name" }, { "name": "help_text_column" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "No data to display." },
  disable_editing : true,
  initComponent : function() {
    var ww = this.containing_window;
    var name_disp306 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var verbose_name_disp307 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var help_text_column_disp308 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(31), "colIndex": 0, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(about.FieldsByModel.name) " }, { "width": Lino.chars2width(31), "colIndex": 1, "sortable": false, "dataIndex": "verbose_name", "header": "verbose name", "editable": false, "tooltip": "(about.FieldsByModel.verbose_name) " }, { "width": Lino.chars2width(31), "colIndex": 2, "sortable": false, "dataIndex": "help_text_column", "header": "help text", "editable": false, "tooltip": "(about.FieldsByModel.help_text_column) " } ];
    Lino.about.FieldsByModel.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.about.FieldsByModel.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/about/FieldsByModel","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.about.FieldsByModel.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/about/FieldsByModel","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.about.FieldsByModel.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.about.FieldsByModel.GridPanel(p);
});

// js_render_GridPanel_class about.Inspector
Lino.about.Inspector.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/about/Inspector",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/about/Inspector','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/about/Inspector','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/about/Inspector','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" } ],
  cell_edit : true,
  title : "Inspector",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  disabled_actions_index : 4,
  ls_store_fields : [ { "name": "i_name" }, { "name": "i_type" }, { "name": "i_value" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "No data to display." },
  disable_editing : true,
  initComponent : function() {
    var ww = this.containing_window;
    var i_name_disp498 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var i_type_disp499 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var i_value_disp500 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(31), "colIndex": 0, "sortable": false, "dataIndex": "i_name", "header": "Name", "editable": false, "tooltip": "(about.Inspector.i_name) " }, { "width": Lino.chars2width(31), "colIndex": 1, "sortable": false, "dataIndex": "i_type", "header": "Type", "editable": false, "tooltip": "(about.Inspector.i_type) " }, { "width": Lino.chars2width(31), "colIndex": 2, "sortable": false, "dataIndex": "i_value", "header": "Value", "editable": false, "tooltip": "(about.Inspector.i_value) " } ];
    Lino.about.Inspector.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.about.Inspector.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/about/Inspector","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.about.Inspector.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/about/Inspector","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.about.Inspector.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.about.Inspector.ParamsPanel({});
  return new Lino.about.Inspector.GridPanel(p);
});

// js_render_GridPanel_class about.SourceFiles
Lino.about.SourceFiles.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/about/SourceFiles",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/about/SourceFiles','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/about/SourceFiles','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/about/SourceFiles','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" } ],
  cell_edit : true,
  title : "Source files",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  disabled_actions_index : 4,
  ls_store_fields : [ { "name": "module_name" }, { "type": "int", "name": "code_lines" }, { "type": "int", "name": "doc_lines" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "No data to display." },
  disable_editing : true,
  initComponent : function() {
    var ww = this.containing_window;
    var module_name502 = new Ext.form.TextField({ "disabled": true, "maxLength": null });
    var code_lines503 = new Ext.form.NumberField({ "disabled": true });
    var doc_lines504 = new Ext.form.NumberField({ "disabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(5), "colIndex": 0, "sortable": false, "dataIndex": "module_name", "header": "module name", "editable": false, "tooltip": "(about.SourceFiles.module_name) " }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": false, "format": "0", "editable": false, "tooltip": "(about.SourceFiles.code_lines) ", "header": "Code", "dataIndex": "code_lines", "width": Lino.chars2width(6) }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": false, "format": "0", "editable": false, "tooltip": "(about.SourceFiles.doc_lines) ", "header": "doc", "dataIndex": "doc_lines", "width": Lino.chars2width(6) }) ];
    Lino.about.SourceFiles.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.about.SourceFiles.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/about/SourceFiles","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.about.SourceFiles.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/about/SourceFiles","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.about.SourceFiles.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.about.SourceFiles.GridPanel(p);
});

Lino.lino.Report.showPanel = Ext.extend(Lino.lino.Report.DetailFormPanel,{
  empty_title: "Detail",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true } ],
  ls_url: "/lino/Report",
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.Report.show;
    Lino.lino.Report.showPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.Report.show = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.Report.showPanel(p);
});

Lino.lino.Report.showPanel = Ext.extend(Lino.lino.Report.DetailFormPanel,{
  empty_title: "Detail",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true } ],
  ls_url: "/lino/Report",
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.Report.show;
    Lino.lino.Report.showPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.Report.show = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.Report.showPanel(p);
});
Lino.lino.Report.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/lino/Report","GET",pk,"do_print",null);
};

Lino.about.About.showPanel = Ext.extend(Lino.about.About.DetailFormPanel,{
  empty_title: "About",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true } ],
  ls_url: "/about/About",
  initComponent : function() {
    this.ls_detail_handler = Lino.about.About.show;
    Lino.about.About.showPanel.superclass.initComponent.call(this);
  }
});

Lino.about.About.show = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(20) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.about.About.showPanel(p);
});

Lino.about.About.showPanel = Ext.extend(Lino.about.About.DetailFormPanel,{
  empty_title: "About",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true } ],
  ls_url: "/about/About",
  initComponent : function() {
    this.ls_detail_handler = Lino.about.About.show;
    Lino.about.About.showPanel.superclass.initComponent.call(this);
  }
});

Lino.about.About.show = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(20) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.about.About.showPanel(p);
});
Lino.about.About.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/about/About","GET",pk,"do_print",null);
};

Lino.system.Home.showPanel = Ext.extend(Lino.system.Home.DetailFormPanel,{
  empty_title: "Home",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true } ],
  ls_url: "/system/Home",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.Home.show;
    Lino.system.Home.showPanel.superclass.initComponent.call(this);
  }
});

Lino.system.Home.show = new Lino.WindowAction({  },function(){
  var p = { "hide_window_title": true, "hide_top_toolbar": true, "is_main_window": true };
  return new Lino.system.Home.showPanel(p);
});

Lino.system.Home.showPanel = Ext.extend(Lino.system.Home.DetailFormPanel,{
  empty_title: "Home",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true } ],
  ls_url: "/system/Home",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.Home.show;
    Lino.system.Home.showPanel.superclass.initComponent.call(this);
  }
});

Lino.system.Home.show = new Lino.WindowAction({  },function(){
  var p = { "hide_window_title": true, "hide_top_toolbar": true, "is_main_window": true };
  return new Lino.system.Home.showPanel(p);
});
Lino.system.Home.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/Home","GET",pk,"do_print",null);
};

// js_render_GridPanel_class outbox.RecipientType
Lino.outbox.RecipientType.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/outbox/RecipientType",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/outbox/RecipientType','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/outbox/RecipientType','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/outbox/RecipientType','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" } ],
  cell_edit : true,
  title : "RecipientType",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "remark" }, { "name": "workflow_buttons" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "forceFit": true, "emptyText": "No data to display." },
  disable_editing : true,
  initComponent : function() {
    var ww = this.containing_window;
    var value506 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name507 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text508 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    var remark_disp509 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var workflow_buttons_disp510 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "value", "editable": false, "tooltip": "(outbox.RecipientType.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(outbox.RecipientType.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "text", "editable": false, "tooltip": "(outbox.RecipientType.text) " }, { "width": Lino.chars2width(31), "colIndex": 3, "sortable": false, "dataIndex": "remark", "header": "Remark", "editable": false, "tooltip": "(outbox.RecipientType.remark) " }, { "colIndex": 4, "sortable": false, "header": "Workflow", "editable": false, "tooltip": "(outbox.RecipientType.workflow_buttons) ", "width": Lino.chars2width(31), "dataIndex": "workflow_buttons", "hidden": true } ];
    Lino.outbox.RecipientType.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.RecipientType.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/RecipientType","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.outbox.RecipientType.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/RecipientType","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.outbox.RecipientType.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.RecipientType.GridPanel(p);
});

// js_render_GridPanel_class cal.EventEvents
Lino.cal.EventEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/cal/EventEvents",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/cal/EventEvents','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/cal/EventEvents','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/cal/EventEvents','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" } ],
  cell_edit : true,
  title : "Observed events",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "remark" }, { "name": "workflow_buttons" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "forceFit": true, "emptyText": "No data to display." },
  disable_editing : true,
  initComponent : function() {
    var ww = this.containing_window;
    var value512 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name513 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text514 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    var remark_disp515 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var workflow_buttons_disp516 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "value", "editable": false, "tooltip": "(cal.EventEvents.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(cal.EventEvents.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "text", "editable": false, "tooltip": "(cal.EventEvents.text) " }, { "width": Lino.chars2width(31), "colIndex": 3, "sortable": false, "dataIndex": "remark", "header": "Remark", "editable": false, "tooltip": "(cal.EventEvents.remark) " }, { "colIndex": 4, "sortable": false, "header": "Workflow", "editable": false, "tooltip": "(cal.EventEvents.workflow_buttons) ", "width": Lino.chars2width(31), "dataIndex": "workflow_buttons", "hidden": true } ];
    Lino.cal.EventEvents.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventEvents.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/EventEvents","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.cal.EventEvents.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/EventEvents","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.cal.EventEvents.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.EventEvents.GridPanel(p);
});

// js_render_GridPanel_class cal.EventStates
Lino.cal.EventStates.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/cal/EventStates",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/cal/EventStates','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/cal/EventStates','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/cal/EventStates','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" } ],
  cell_edit : true,
  title : "Event states",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "type": "boolean", "name": "edit_guests" }, { "type": "boolean", "name": "fixed" }, { "name": "remark" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "forceFit": true, "emptyText": "No data to display." },
  disable_editing : true,
  initComponent : function() {
    var ww = this.containing_window;
    var value518 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name519 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text520 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    var edit_guests_disp521 = new Ext.form.DisplayField({ "disabled": true });
    var fixed_disp522 = new Ext.form.DisplayField({ "disabled": true });
    var remark_disp523 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "value", "editable": false, "tooltip": "(cal.EventStates.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(cal.EventStates.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "text", "editable": false, "tooltip": "(cal.EventStates.text) " }, { "width": Lino.chars2width(21), "colIndex": 3, "sortable": false, "dataIndex": "edit_guests", "header": "Edit guests list", "editable": false, "tooltip": "(cal.EventStates.edit_guests) " }, { "width": Lino.chars2width(21), "colIndex": 4, "sortable": false, "dataIndex": "fixed", "header": "Fixed", "editable": false, "tooltip": "(cal.EventStates.fixed) " }, { "width": Lino.chars2width(31), "colIndex": 5, "sortable": false, "dataIndex": "remark", "header": "Remark", "editable": false, "tooltip": "(cal.EventStates.remark) " } ];
    Lino.cal.EventStates.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventStates.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/EventStates","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.cal.EventStates.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/EventStates","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.cal.EventStates.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.EventStates.GridPanel(p);
});

// js_render_GridPanel_class cal.AccessClasses
Lino.cal.AccessClasses.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/cal/AccessClasses",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/cal/AccessClasses','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/cal/AccessClasses','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/cal/AccessClasses','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" } ],
  cell_edit : true,
  title : "AccessClasses",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "remark" }, { "name": "workflow_buttons" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "forceFit": true, "emptyText": "No data to display." },
  disable_editing : true,
  initComponent : function() {
    var ww = this.containing_window;
    var value525 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name526 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text527 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    var remark_disp528 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var workflow_buttons_disp529 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "value", "editable": false, "tooltip": "(cal.AccessClasses.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(cal.AccessClasses.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "text", "editable": false, "tooltip": "(cal.AccessClasses.text) " }, { "width": Lino.chars2width(31), "colIndex": 3, "sortable": false, "dataIndex": "remark", "header": "Remark", "editable": false, "tooltip": "(cal.AccessClasses.remark) " }, { "colIndex": 4, "sortable": false, "header": "Workflow", "editable": false, "tooltip": "(cal.AccessClasses.workflow_buttons) ", "width": Lino.chars2width(31), "dataIndex": "workflow_buttons", "hidden": true } ];
    Lino.cal.AccessClasses.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.AccessClasses.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/AccessClasses","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.cal.AccessClasses.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/AccessClasses","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.cal.AccessClasses.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.AccessClasses.GridPanel(p);
});

// js_render_GridPanel_class cal.TaskStates
Lino.cal.TaskStates.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/cal/TaskStates",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/cal/TaskStates','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/cal/TaskStates','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/cal/TaskStates','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" } ],
  cell_edit : true,
  title : "Task states",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "remark" }, { "name": "workflow_buttons" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "forceFit": true, "emptyText": "No data to display." },
  disable_editing : true,
  initComponent : function() {
    var ww = this.containing_window;
    var value531 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name532 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text533 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    var remark_disp534 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var workflow_buttons_disp535 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "value", "editable": false, "tooltip": "(cal.TaskStates.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(cal.TaskStates.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "text", "editable": false, "tooltip": "(cal.TaskStates.text) " }, { "width": Lino.chars2width(31), "colIndex": 3, "sortable": false, "dataIndex": "remark", "header": "Remark", "editable": false, "tooltip": "(cal.TaskStates.remark) " }, { "colIndex": 4, "sortable": false, "header": "Workflow", "editable": false, "tooltip": "(cal.TaskStates.workflow_buttons) ", "width": Lino.chars2width(31), "dataIndex": "workflow_buttons", "hidden": true } ];
    Lino.cal.TaskStates.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.TaskStates.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/TaskStates","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.cal.TaskStates.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/TaskStates","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.cal.TaskStates.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.TaskStates.GridPanel(p);
});

// js_render_GridPanel_class lino.YesNo
Lino.lino.YesNo.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/lino/YesNo",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/lino/YesNo','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/lino/YesNo','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/lino/YesNo','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" } ],
  cell_edit : true,
  title : "Yes or no",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "remark" }, { "name": "workflow_buttons" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "forceFit": true, "emptyText": "No data to display." },
  disable_editing : true,
  initComponent : function() {
    var ww = this.containing_window;
    var value537 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name538 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text539 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    var remark_disp540 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var workflow_buttons_disp541 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "value", "editable": false, "tooltip": "(lino.YesNo.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(lino.YesNo.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "text", "editable": false, "tooltip": "(lino.YesNo.text) " }, { "width": Lino.chars2width(31), "colIndex": 3, "sortable": false, "dataIndex": "remark", "header": "Remark", "editable": false, "tooltip": "(lino.YesNo.remark) " }, { "colIndex": 4, "sortable": false, "header": "Workflow", "editable": false, "tooltip": "(lino.YesNo.workflow_buttons) ", "width": Lino.chars2width(31), "dataIndex": "workflow_buttons", "hidden": true } ];
    Lino.lino.YesNo.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.YesNo.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/lino/YesNo","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.lino.YesNo.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/lino/YesNo","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.lino.YesNo.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.YesNo.GridPanel(p);
});

// js_render_GridPanel_class countries.CityTypes
Lino.countries.CityTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/countries/CityTypes",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/countries/CityTypes','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/countries/CityTypes','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/countries/CityTypes','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" } ],
  cell_edit : true,
  title : "CityTypes",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "remark" }, { "name": "workflow_buttons" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "forceFit": true, "emptyText": "No data to display." },
  disable_editing : true,
  initComponent : function() {
    var ww = this.containing_window;
    var value543 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name544 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text545 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    var remark_disp546 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var workflow_buttons_disp547 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "value", "editable": false, "tooltip": "(countries.CityTypes.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(countries.CityTypes.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "text", "editable": false, "tooltip": "(countries.CityTypes.text) " }, { "width": Lino.chars2width(31), "colIndex": 3, "sortable": false, "dataIndex": "remark", "header": "Remark", "editable": false, "tooltip": "(countries.CityTypes.remark) " }, { "colIndex": 4, "sortable": false, "header": "Workflow", "editable": false, "tooltip": "(countries.CityTypes.workflow_buttons) ", "width": Lino.chars2width(31), "dataIndex": "workflow_buttons", "hidden": true } ];
    Lino.countries.CityTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.CityTypes.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/CityTypes","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.countries.CityTypes.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/CityTypes","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.countries.CityTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.CityTypes.GridPanel(p);
});

// js_render_GridPanel_class cal.DurationUnits
Lino.cal.DurationUnits.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/cal/DurationUnits",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/cal/DurationUnits','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/cal/DurationUnits','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/cal/DurationUnits','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" } ],
  cell_edit : true,
  title : "DurationUnits",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "remark" }, { "name": "workflow_buttons" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "forceFit": true, "emptyText": "No data to display." },
  disable_editing : true,
  initComponent : function() {
    var ww = this.containing_window;
    var value549 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name550 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text551 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    var remark_disp552 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var workflow_buttons_disp553 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "value", "editable": false, "tooltip": "(cal.DurationUnits.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(cal.DurationUnits.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "text", "editable": false, "tooltip": "(cal.DurationUnits.text) " }, { "width": Lino.chars2width(31), "colIndex": 3, "sortable": false, "dataIndex": "remark", "header": "Remark", "editable": false, "tooltip": "(cal.DurationUnits.remark) " }, { "colIndex": 4, "sortable": false, "header": "Workflow", "editable": false, "tooltip": "(cal.DurationUnits.workflow_buttons) ", "width": Lino.chars2width(31), "dataIndex": "workflow_buttons", "hidden": true } ];
    Lino.cal.DurationUnits.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.DurationUnits.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/DurationUnits","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.cal.DurationUnits.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/DurationUnits","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.cal.DurationUnits.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.DurationUnits.GridPanel(p);
});

// js_render_GridPanel_class lino.UserProfiles
Lino.lino.UserProfiles.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/lino/UserProfiles",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/lino/UserProfiles','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/lino/UserProfiles','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/lino/UserProfiles','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" } ],
  cell_edit : true,
  title : "User Profiles",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  disabled_actions_index : 10,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "remark" }, { "name": "workflow_buttons" }, { "name": "level" }, 'levelHidden', { "name": "office_level" }, 'office_levelHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "forceFit": true, "emptyText": "No data to display." },
  disable_editing : true,
  initComponent : function() {
    var ww = this.containing_window;
    var value555 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name556 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text557 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    var remark_disp558 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var workflow_buttons_disp559 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var level560 = new Lino.ChoicesFieldElement({ "disabled": true, "store": [ [ "10", "Guest" ], [ "30", "User" ], [ "40", "Manager" ], [ "50", "Administrator" ] ] });
    var office_level561 = new Lino.ChoicesFieldElement({ "disabled": true, "store": [ [ "10", "Guest" ], [ "30", "User" ], [ "40", "Manager" ], [ "50", "Administrator" ] ] });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "value", "editable": false, "tooltip": "(lino.UserProfiles.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(lino.UserProfiles.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "text", "editable": false, "tooltip": "(lino.UserProfiles.text) " }, { "width": Lino.chars2width(31), "colIndex": 3, "sortable": false, "dataIndex": "remark", "header": "Remark", "editable": false, "tooltip": "(lino.UserProfiles.remark) " }, { "colIndex": 4, "sortable": false, "header": "Workflow", "editable": false, "tooltip": "(lino.UserProfiles.workflow_buttons) ", "width": Lino.chars2width(31), "dataIndex": "workflow_buttons", "hidden": true }, { "width": Lino.chars2width(21), "colIndex": 5, "sortable": false, "dataIndex": "level", "header": "User Level (System)", "editable": false, "tooltip": "(lino.UserProfiles.level) " }, { "width": Lino.chars2width(21), "colIndex": 6, "sortable": false, "dataIndex": "office_level", "header": "User Level (Office)", "editable": false, "tooltip": "(lino.UserProfiles.office_level) " } ];
    Lino.lino.UserProfiles.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.UserProfiles.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/lino/UserProfiles","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.lino.UserProfiles.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/lino/UserProfiles","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.lino.UserProfiles.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.UserProfiles.GridPanel(p);
});

// js_render_GridPanel_class lino.Genders
Lino.lino.Genders.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/lino/Genders",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/lino/Genders','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/lino/Genders','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/lino/Genders','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" } ],
  cell_edit : true,
  title : "Genders",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "remark" }, { "name": "workflow_buttons" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "forceFit": true, "emptyText": "No data to display." },
  disable_editing : true,
  initComponent : function() {
    var ww = this.containing_window;
    var value563 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name564 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text565 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    var remark_disp566 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var workflow_buttons_disp567 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "value", "editable": false, "tooltip": "(lino.Genders.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(lino.Genders.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "text", "editable": false, "tooltip": "(lino.Genders.text) " }, { "width": Lino.chars2width(31), "colIndex": 3, "sortable": false, "dataIndex": "remark", "header": "Remark", "editable": false, "tooltip": "(lino.Genders.remark) " }, { "colIndex": 4, "sortable": false, "header": "Workflow", "editable": false, "tooltip": "(lino.Genders.workflow_buttons) ", "width": Lino.chars2width(31), "dataIndex": "workflow_buttons", "hidden": true } ];
    Lino.lino.Genders.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.Genders.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/lino/Genders","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.lino.Genders.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/lino/Genders","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.lino.Genders.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.Genders.GridPanel(p);
});

// js_render_GridPanel_class cal.Recurrencies
Lino.cal.Recurrencies.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/cal/Recurrencies",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/cal/Recurrencies','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/cal/Recurrencies','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/cal/Recurrencies','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" } ],
  cell_edit : true,
  title : "Recurrencies",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "remark" }, { "name": "workflow_buttons" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "forceFit": true, "emptyText": "No data to display." },
  disable_editing : true,
  initComponent : function() {
    var ww = this.containing_window;
    var value569 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name570 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text571 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    var remark_disp572 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var workflow_buttons_disp573 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "value", "editable": false, "tooltip": "(cal.Recurrencies.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(cal.Recurrencies.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "text", "editable": false, "tooltip": "(cal.Recurrencies.text) " }, { "width": Lino.chars2width(31), "colIndex": 3, "sortable": false, "dataIndex": "remark", "header": "Remark", "editable": false, "tooltip": "(cal.Recurrencies.remark) " }, { "colIndex": 4, "sortable": false, "header": "Workflow", "editable": false, "tooltip": "(cal.Recurrencies.workflow_buttons) ", "width": Lino.chars2width(31), "dataIndex": "workflow_buttons", "hidden": true } ];
    Lino.cal.Recurrencies.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Recurrencies.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Recurrencies","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.cal.Recurrencies.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Recurrencies","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.cal.Recurrencies.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Recurrencies.GridPanel(p);
});

// js_render_GridPanel_class cal.Weekdays
Lino.cal.Weekdays.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/cal/Weekdays",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/cal/Weekdays','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/cal/Weekdays','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/cal/Weekdays','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" } ],
  cell_edit : true,
  title : "Weekdays",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "remark" }, { "name": "workflow_buttons" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "forceFit": true, "emptyText": "No data to display." },
  disable_editing : true,
  initComponent : function() {
    var ww = this.containing_window;
    var value575 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name576 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text577 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    var remark_disp578 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var workflow_buttons_disp579 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "value", "editable": false, "tooltip": "(cal.Weekdays.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(cal.Weekdays.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "text", "editable": false, "tooltip": "(cal.Weekdays.text) " }, { "width": Lino.chars2width(31), "colIndex": 3, "sortable": false, "dataIndex": "remark", "header": "Remark", "editable": false, "tooltip": "(cal.Weekdays.remark) " }, { "colIndex": 4, "sortable": false, "header": "Workflow", "editable": false, "tooltip": "(cal.Weekdays.workflow_buttons) ", "width": Lino.chars2width(31), "dataIndex": "workflow_buttons", "hidden": true } ];
    Lino.cal.Weekdays.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Weekdays.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Weekdays","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.cal.Weekdays.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Weekdays","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.cal.Weekdays.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Weekdays.GridPanel(p);
});

// js_render_GridPanel_class lino.UserGroups
Lino.lino.UserGroups.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/lino/UserGroups",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/lino/UserGroups','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/lino/UserGroups','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/lino/UserGroups','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" } ],
  cell_edit : true,
  title : "User Groups",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "remark" }, { "name": "workflow_buttons" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "forceFit": true, "emptyText": "No data to display." },
  disable_editing : true,
  initComponent : function() {
    var ww = this.containing_window;
    var value581 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name582 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text583 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    var remark_disp584 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var workflow_buttons_disp585 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "value", "editable": false, "tooltip": "(lino.UserGroups.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(lino.UserGroups.name) " }, { "width": Lino.chars2width(22), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "text", "editable": false, "tooltip": "(lino.UserGroups.text) " }, { "width": Lino.chars2width(31), "colIndex": 3, "sortable": false, "dataIndex": "remark", "header": "Remark", "editable": false, "tooltip": "(lino.UserGroups.remark) " }, { "colIndex": 4, "sortable": false, "header": "Workflow", "editable": false, "tooltip": "(lino.UserGroups.workflow_buttons) ", "width": Lino.chars2width(31), "dataIndex": "workflow_buttons", "hidden": true } ];
    Lino.lino.UserGroups.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.UserGroups.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/lino/UserGroups","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.lino.UserGroups.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/lino/UserGroups","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.lino.UserGroups.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.UserGroups.GridPanel(p);
});

// js_render_GridPanel_class lino.UserLevels
Lino.lino.UserLevels.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/lino/UserLevels",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/lino/UserLevels','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/lino/UserLevels','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/lino/UserLevels','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" } ],
  cell_edit : true,
  title : "User Levels",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "short_name" }, { "name": "text" }, { "name": "remark" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "forceFit": true, "emptyText": "No data to display." },
  disable_editing : true,
  initComponent : function() {
    var ww = this.containing_window;
    var value587 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name588 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var short_name589 = new Ext.form.TextField({ "disabled": true, "boxMinWidth": Lino.chars2width(2), "maxLength": 2 });
    var text590 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    var remark_disp591 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "value", "editable": false, "tooltip": "(lino.UserLevels.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(lino.UserLevels.name) " }, { "width": Lino.chars2width(5), "colIndex": 2, "sortable": false, "dataIndex": "short_name", "header": "Short name", "editable": false, "tooltip": "(lino.UserLevels.short_name) Used when defining UserProfiles" }, { "width": Lino.chars2width(22), "colIndex": 3, "sortable": false, "dataIndex": "text", "header": "text", "editable": false, "tooltip": "(lino.UserLevels.text) " }, { "width": Lino.chars2width(31), "colIndex": 4, "sortable": false, "dataIndex": "remark", "header": "Remark", "editable": false, "tooltip": "(lino.UserLevels.remark) " } ];
    Lino.lino.UserLevels.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.UserLevels.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/lino/UserLevels","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.lino.UserLevels.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/lino/UserLevels","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.lino.UserLevels.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.UserLevels.GridPanel(p);
});

// js_render_GridPanel_class cal.GuestStates
Lino.cal.GuestStates.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/cal/GuestStates",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/cal/GuestStates','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/cal/GuestStates','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/cal/GuestStates','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" } ],
  cell_edit : true,
  title : "Guest states",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "type": "boolean", "name": "afterwards" }, { "name": "text" }, { "name": "remark" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "forceFit": true, "emptyText": "No data to display." },
  disable_editing : true,
  initComponent : function() {
    var ww = this.containing_window;
    var value593 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name594 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var afterwards_disp595 = new Ext.form.DisplayField({ "disabled": true });
    var text596 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    var remark_disp597 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(22), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "value", "editable": false, "tooltip": "(cal.GuestStates.value) " }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false, "tooltip": "(cal.GuestStates.name) " }, { "width": Lino.chars2width(21), "colIndex": 2, "sortable": false, "dataIndex": "afterwards", "header": "Afterwards", "editable": false, "tooltip": "(cal.GuestStates.afterwards) " }, { "width": Lino.chars2width(22), "colIndex": 3, "sortable": false, "dataIndex": "text", "header": "text", "editable": false, "tooltip": "(cal.GuestStates.text) " }, { "width": Lino.chars2width(31), "colIndex": 4, "sortable": false, "dataIndex": "remark", "header": "Remark", "editable": false, "tooltip": "(cal.GuestStates.remark) " } ];
    Lino.cal.GuestStates.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.GuestStates.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/GuestStates","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.cal.GuestStates.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/GuestStates","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.cal.GuestStates.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.GuestStates.GridPanel(p);
});
