/*
 Copyright 2009-2013 Luc Saffre
 This file is part of the Lino project.
 Lino is free software; you can redistribute it and/or modify 
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.
 Lino is distributed in the hope that it will be useful, 
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 GNU General Public License for more details.
 You should have received a copy of the GNU General Public License
 along with Lino; if not, see <http://www.gnu.org/licenses/>.
*/

// lino.js --- generated Wed May  8 21:21:17 2013 by Lino version 1.6.7.
Ext.BLANK_IMAGE_URL = '/media/extjs/resources/images/default/s.gif';
LANGUAGE_CHOICES = [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "et", "Estnisch" ], [ "en", "Englisch" ] ];
MEDIA_URL = "/media";

/* MonthPickerPlugin: thanks to keypoint @ sencha forum
   http://www.sencha.com/forum/showthread.php?74002-3.x-Ext.ux.MonthMenu&p=356860#post356860
*/
Ext.namespace('Ext.ux'); 

Ext.ux.MonthPickerPlugin = function() { 
    var picker; 
    var oldDateDefaults; 

    this.init = function(pk) { 
        picker = pk; 
        picker.onTriggerClick = picker.onTriggerClick.createSequence(onClick); 
        picker.getValue = picker.getValue.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
        picker.beforeBlur = picker.beforeBlur.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
    }; 

    function setDefaultMonthDay() { 
        oldDateDefaults = Date.defaults.d; 
        Date.defaults.d = 1; 
        return true; 
    } 

    function restoreDefaultMonthDay(ret) { 
        Date.defaults.d = oldDateDefaults; 
        return ret; 
    } 

    function onClick(e, el, opt) { 
        var p = picker.menu.picker; 
        p.activeDate = p.activeDate.getFirstDateOfMonth(); 
        if (p.value) { 
            p.value = p.value.getFirstDateOfMonth(); 
        } 

        p.showMonthPicker(); 
         
        if (!p.disabled) { 
            p.monthPicker.stopFx(); 
            p.monthPicker.show(); 

            p.mun(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mun(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
            p.onMonthClick = p.onMonthClick.createSequence(pickerClick); 
            p.onMonthDblClick = p.onMonthDblClick.createSequence(pickerDblclick); 
            p.mon(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mon(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
        } 
    } 

    function pickerClick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.is('button.x-date-mp-cancel')) { 
            picker.menu.hide(); 
        } else if(el.is('button.x-date-mp-ok')) { 
            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 

    function pickerDblclick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.parent() 
            && (el.parent().is('td.x-date-mp-month') 
            || el.parent().is('td.x-date-mp-year'))) { 

            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 
}; 

Ext.preg('monthPickerPlugin', Ext.ux.MonthPickerPlugin);  

//~ /* 
  //~ http://www.diloc.de/blog/2008/03/05/how-to-submit-ext-forms-the-right-way/
//~ */
//~ /**
 //~ * This submit action is basically the same as the normal submit action,
 //~ * only that it uses the fields getSubmitValue() to compose the values to submit,
 //~ * instead of looping over the input-tags in the form-tag of the form.
 //~ *
 //~ * To use it, just use the OOSubmit-plugin on either a FormPanel or a BasicForm,
 //~ * or explicitly call form.doAction('oosubmit');
 //~ *
 //~ * @param {Object} form
 //~ * @param {Object} options
 //~ */
//~ Ext.ux.OOSubmitAction = function(form, options){
    //~ Ext.ux.OOSubmitAction.superclass.constructor.call(this, form, options);
//~ };

//~ Ext.extend(Ext.ux.OOSubmitAction, Ext.form.Action.Submit, {
    //~ /**
    //~ * @cfg {boolean} clientValidation Determines whether a Form's fields are validated
    //~ * in a final call to {@link Ext.form.BasicForm#isValid isValid} prior to submission.
    //~ * Pass <tt>false</tt> in the Form's submit options to prevent this. If not defined, pre-submission field validation
    //~ * is performed.
    //~ */
    //~ type : 'oosubmit',

    //~ // private
    //~ /**
     //~ * This is nearly a copy of the original submit action run method
     //~ */
    //~ run : function(){
        //~ var o = this.options;
        //~ var method = this.getMethod();
        //~ var isPost = method == 'POST';

        //~ var params = this.options.params || {};
        //~ if (isPost) Ext.applyIf(params, this.form.baseParams);

        //~ //now add the form parameters
        //~ this.form.items.each(function(field)
        //~ {
            //~ if (!field.disabled)
            //~ {
                //~ //check if the form item provides a specialized getSubmitValue() and use that if available
                //~ if (typeof field.getSubmitValue == "function")
                    //~ params[field.getName()] = field.getSubmitValue();
                //~ else
                    //~ params[field.getName()] = field.getValue();
            //~ }
        //~ });

        //~ //convert params to get style if we are not post
        //~ if (!isPost) params=Ext.urlEncode(params);

        //~ if(o.clientValidation === false || this.form.isValid()){
            //~ Ext.Ajax.request(Ext.apply(this.createCallback(o), {
                //~ url:this.getUrl(!isPost),
                //~ method: method,
                //~ params:params, //add our values
                //~ isUpload: this.form.fileUpload
            //~ }));

        //~ }else if (o.clientValidation !== false){ // client validation failed
            //~ this.failureType = Ext.form.Action.CLIENT_INVALID;
            //~ this.form.afterAction(this, false);
        //~ }
    //~ },

//~ });
//~ //add our action to the registry of known actions
//~ Ext.form.Action.ACTION_TYPES['oosubmit'] = Ext.ux.OOSubmitAction;




/**
JC Watsons solution (adapted to ExtJS 3.3.1 by LS) is elegant and simple:
`A "fix" for unchecked checkbox submission  behaviour
<http://www.sencha.com/forum/showthread.php?28449>`_

Added special handling for checkbox inputs. 
ExtJS defines disabled checkboxes `readonly`, not `disabled` as for other inputs.

*/
Ext.lib.Ajax.serializeForm = function(form) {
    //~ console.log('20120203 linolib.js serializeForm',form);
    var fElements = form.elements || (document.forms[form] || Ext.getDom(form)).elements, 
        hasSubmit = false, 
        encoder = encodeURIComponent, 
        name, 
        data = '', 
        type, 
        hasValue;

    Ext.each(fElements, function(element){
        name = element.name;
        type = element.type;

        if (!element.disabled && name && !(type == 'checkbox' && element.readonly)) {
            if (/select-(one|multiple)/i.test(type)) {
                Ext.each(element.options, function(opt){
                    if (opt.selected) {
                        hasValue = opt.hasAttribute ? opt.hasAttribute('value') : opt.getAttributeNode('value').specified;
                        data += String.format("{0}={1}&", encoder(name), encoder(hasValue ? opt.value : opt.text));
                    }
                });
            } else if (!(/file|undefined|reset|button/i.test(type))) {
                //~ if (!(/radio|checkbox/i.test(type) && !element.checked) && !(type == 'submit' && hasSubmit)) {
                if (!(type == 'submit' && hasSubmit)) {
                    if (type == 'checkbox') {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&');
                        data += encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&';
                    } else {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + encoder(element.value) + '&');
                        data += encoder(name) + '=' + encoder(element.value) + '&';
                    }
                    hasSubmit = /submit/i.test(type);
                }
            }
        //~ } else {
            //~ console.log(name,type,element.readonly);
        }
    });
    return data.substr(0, data.length - 1);
};



/*
Set a long timeout of fifteen minutes. 
See /blog/2012/0307
*/
Ext.Ajax.timeout = 15 * 60 * 1000; 


/*
My fix for the "Cannot set QuickTips dismissDelay to 0" bug,
see http://www.sencha.com/forum/showthread.php?183515 
*/
Ext.override(Ext.QuickTip,{
  showAt : function(xy){
        var t = this.activeTarget;
        //~ console.log("20120224 QuickTip.showAt",this.title,this.dismissDelay,t.dismissDelay);
        if(t){
            if(!this.rendered){
                this.render(Ext.getBody());
                this.activeTarget = t;
            }
            if(t.width){
                this.setWidth(t.width);
                this.body.setWidth(this.adjustBodyWidth(t.width - this.getFrameWidth()));
                this.measureWidth = false;
            } else{
                this.measureWidth = true;
            }
            this.setTitle(t.title || '');
            this.body.update(t.text);
            this.autoHide = t.autoHide;
            // bugfix by Luc 20120226
            if (t.dismissDelay != undefined) this.dismissDelay = t.dismissDelay;
            //~ this.dismissDelay = t.dismissDelay || this.dismissDelay;
            if(this.lastCls){
                this.el.removeClass(this.lastCls);
                delete this.lastCls;
            }
            if(t.cls){
                this.el.addClass(t.cls);
                this.lastCls = t.cls;
            }
            if(this.anchor){
                this.constrainPosition = false;
            }else if(t.align){ 
                xy = this.el.getAlignToXY(t.el, t.align);
                this.constrainPosition = false;
            }else{
                this.constrainPosition = true;
            }
        }
        Ext.QuickTip.superclass.showAt.call(this, xy);
    }
});

/*
Another hack. See /docs/blog/2012/0228
*/
Ext.Element.addMethods(
    function() {
        var VISIBILITY      = "visibility",
            DISPLAY         = "display",
            HIDDEN          = "hidden",
            NONE            = "none",
            XMASKED         = "x-masked",
            XMASKEDRELATIVE = "x-masked-relative",
            data            = Ext.Element.data;

        return {
            
            mask : function(msg, msgCls) {
                var me  = this,
                    dom = me.dom,
                    dh  = Ext.DomHelper,
                    EXTELMASKMSG = "ext-el-mask-msg",
                    el,
                    mask;
                // removed the following lines. See /docs/blog/2012/0228
                //~ if (!(/^body/i.test(dom.tagName) && me.getStyle('position') == 'static')) {
                    //~ console.log(20120228,dom.tagName,me);
                    //~ me.addClass(XMASKEDRELATIVE); 
                //~ }
                if (el = data(dom, 'maskMsg')) {
                    el.remove();
                }
                if (el = data(dom, 'mask')) {
                    el.remove();
                }

                mask = dh.append(dom, {cls : "ext-el-mask"}, true);
                data(dom, 'mask', mask);

                me.addClass(XMASKED);
                mask.setDisplayed(true);
                
                if (typeof msg == 'string') {
                    var mm = dh.append(dom, {cls : EXTELMASKMSG, cn:{tag:'div'}}, true);
                    data(dom, 'maskMsg', mm);
                    mm.dom.className = msgCls ? EXTELMASKMSG + " " + msgCls : EXTELMASKMSG;
                    mm.dom.firstChild.innerHTML = msg;
                    mm.setDisplayed(true);
                    mm.center(me);
                }
                
                
                if (Ext.isIE && !(Ext.isIE7 && Ext.isStrict) && me.getStyle('height') == 'auto') {
                    mask.setSize(undefined, me.getHeight());
                }
                
                return mask;
            }

            
        };
    }()
);



Ext.namespace('Lino');
    
    

//~ Lino.subst_user_field = new Ext.form.ComboBox({});
//~ Lino.subst_user = null;
Lino.insert_subst_user = function(p){
    //~ console.log('20120714 insert_subst_user',Lino.subst_user,p);
    //~ if (Lino.subst_user_field.getValue()) {
    if (p.su) return;
    if (Lino.subst_user) {
        //~ p.su = Lino.subst_user_field.getValue();
        p.su = Lino.subst_user;
    //~ } else {
        //~ delete p.su;
    }
    //~ console.log('20120714 insert_subst_user -->',Lino.subst_user,p);
}

Lino.login_window = null;


Lino.show_login_window = function() {
  //~ console.log('20121103 show_login_window',arguments);
  //~ var current_window = Lino.current_window;
  if (Lino.login_window == null) {
    
      function do_login() { 
            Lino.viewport.loadMask.show()
            //~ Lino.body_loadMask.show()
            login_panel.getForm().submit({ 
                method:'POST', 
                waitTitle:'Connecting', 
                waitMsg:'Sending data...',
                success:function(){ 
                  //~ console.log('20121104 logged in',arguments);
                  Lino.login_window.hide();
                  Lino.close_all_windows();
                  Lino.viewport.loadMask.hide()
                  //~ Lino.body_loadMask.hide()
                },
                failure: function(form,action) { 
                  //~ this.loadMask.hide();
                  Lino.on_submit_failure(form,action);
                  Lino.viewport.loadMask.hide()
                  //~ Lino.body_loadMask.hide()
                  //~ if (Lino.current_window) Lino.current_window.main_item.loadMask.hide()
                }
                //~ failure:function(form, action){ 
                    //~ alert_msg
                    //~ if(action.failureType == 'server'){ 
                        //~ obj = Ext.util.JSON.decode(action.response.responseText); 
                        //~ Ext.Msg.alert('Login Failed!', obj.errors.reason); 
                    //~ }else{ 
                        //~ Ext.Msg.alert('Warning!', 'Authentication server is unreachable : ' + action.response.responseText); 
                    //~ } 
                    //~ Lino.login_panel.getForm().reset(); 
                //~ } 
            }); 
      };
    
      var login_button = new Ext.Button({ 
        text:"Anmelden",
        formBind: true,	 
        // Function that fires when user clicks the button 
        handler: do_login});
    
      var login_panel = new Ext.FormPanel({ 
        //~ inspired by http://www.sencha.com/learn/a-basic-login/
        autoHeight:true,
        labelWidth:90,
        url:'/auth', 
        frame:true, 
        defaultType:'textfield',
        monitorValid:true,
        items:[{ 
            fieldLabel:"Benutzername", 
            id: 'username',
            name:'username', 
            autoHeight:true,
            allowBlank:false 
        },{ 
            fieldLabel:"Passwort", 
            name:'password', 
            inputType:'password', 
            autoHeight:true,
            allowBlank:false 
        }],        
        buttons:[ login_button ]});
        
      Lino.login_window = new Ext.Window({
          layout:'fit',
          defaultButton: 'username',
          width:300,
          title:"Anmelden", 
          autoHeight:true,
          modal: true,
          closeAction: "hide",
          keys: {
            key: Ext.EventObject.ENTER,
            fn: function() { do_login()}
          },
          //~ defaultButton: login_button,
          //~ height:'auto',
          //~ closable: false,
          //~ resizable: false,
          //~ plain: true,
          //~ border: false,
          items: [login_panel] });
  };
  Lino.login_window.show();
};

Lino.logout = function(id,name) {
    //~ console.log('20121104 gonna log out',arguments);
    //~ Lino.do_action
    Lino.call_ajax_action(Lino.viewport,'GET','/auth',{},'logout',undefined,undefined,function(){
        //~ console.log('20121104 logged out',arguments);
        //~ Lino.login_window.hide();
        Lino.close_all_windows();
    })
}

Lino.set_subst_user = function(id,name) {
    //~ console.log(20120714,'Lino.set_subst_user',id,name);
    Lino.subst_user = id;

    if(id) {
        Lino.eventStore.setBaseParam("su",id);
    } else {
      delete Lino.eventStore.baseParams['su'];
    }

    if (Lino.current_window) 
        Lino.current_window.main_item.set_base_param("su",id);
    if (Lino.viewport) Lino.permalink_handler(Lino.current_window)();
}



//~ Lino.select_subst_user = function(cmp,rec,value){
    //~ Lino.subst_user=value;
    //~ console.log(20120713,rec);
//~ }
    
Lino.current_window = null;
Lino.window_history = Array();
    
Lino.chars2width = function(cols) {  return cols * 9; }
Lino.rows2height = function(cols) {  return cols * 20; }



Lino.Viewport = Ext.extend(Ext.Viewport,{
  layout:"fit"
  ,initComponent : function(){
    Lino.Viewport.superclass.initComponent.call(this);
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.el,{msg:"Bitte warten..."});
      //~ console.log("20121118 Lino.viewport.loadMask",this.loadMask);
    },this);
  }
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,refresh : function() {
      var caller = this;
      console.log("20121120 Lino.Viewport.refresh()");
      if (caller.loadMask) caller.loadMask.show();
      var success = function(response) {
        if (caller.loadMask) caller.loadMask.hide();
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          //~ console.log('Lino.do_action()',action.name,'result is',result);
          if (result.html) {
              Ext.getCmp('main_area').update(result.html);
          }
          if (result.message) {
              if (result.alert) {
                  //~ Ext.MessageBox.alert('Alert',result.alert_msg);
                  Ext.MessageBox.alert('Alert',result.message);
              } else {
                  Lino.notify(result.message);
              }
          }
          
          if (result.notify_msg) Lino.notify(result.notify_msg);
          if (result.js_code) { 
            var jsr = result.js_code(caller);
            //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
          };
        }
      };
      var action = {
        url : '/api/main_html',
        waitMsg: "Bitte warten...",
        failure: Lino.ajax_error_handler(caller),
        success: success,
        method: 'GET',
        params: {}
      };
      Lino.insert_subst_user(action.params);
      Ext.Ajax.request(action);
    
  }
});


Lino.open_window = function(win,st,requesting_panel) {
  //~ console.log("20120918 Lino.open_window()",win,st);
  var cw = Lino.current_window;
  if (cw) {
    //~ console.log("20120918 Lino.open_window() save current status",cw.main_item.get_status());
    Lino.window_history.push({
      window:cw,
      status:cw.main_item.get_status()
    });
  }
  Lino.current_window = win;
  //~ if (st.su) 
      //~ Lino.subst_user_field.setValue(st.su);
  win.main_item.set_status(st,requesting_panel);
  win.show();
};

Lino.load_url = function(url) {
    //~ foo.bar.baz = 2; 
    //~ console.log("20121120 Lino.load_url()");
    //~ Lino.body_loadMask.show();
    Lino.viewport.loadMask.show();
    //~ location.replace(url);
    document.location = url;
}

Lino.close_window = function(status_update) {
  var cw = Lino.current_window;
  var ww = Lino.window_history.pop();
  if (ww) {
    //~ if (status_update) Ext.apply(ww.status,status_update);
    if (status_update) status_update(ww);
    ww.window.main_item.set_status(ww.status);
    Lino.current_window = ww.window;
  } else {
    Lino.current_window = null;
  }
  if (cw) cw.hide_really();
};

Lino.close_all_windows = function() {
  if (Lino.window_history.length == 0) {
      //~ Lino.viewport.refresh();
      var url =  "/"
      //~ console.log("20121120 Lino.close_all_windows() : no window_history");
      //~ if (ADMIN_URL) 
      var p = {};
      Lino.insert_subst_user(p)
      if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
      Lino.load_url(url);
  } else {
    //~ console.log("20121120 Lino.close_all_windows() with window_history");
    while (Lino.window_history.length > 0) {
      Lino.close_window();
      //~ Lino.window_history.pop().hide_really();
    }
  }
  //~ Lino.current_window = null;
  //~ Lino.close_window();
  //~ var ww = 
}

Lino.kill_current_window = function() {
  var cw = Lino.current_window;
  Lino.current_window = null;
  if (cw) cw.hide_really();
};

Lino.calling_window = function() {
    if (Lino.window_history.length) return Lino.window_history[Lino.window_history.length-1];
}

//~ Lino.WindowAction = function(mainItemClass,windowConfig,mainConfig,ppf) {
Lino.WindowAction = function(windowConfig,main_item_fn) {
    //~ if(!mainConfig) mainConfig = {};
    //~ mainConfig.is_main_window = true;
    this.windowConfig = windowConfig;
    this.main_item_fn = main_item_fn;
    //~ if (ppf) mainConfig.params_panel.fields = ppf;
    //~ this.mainConfig = mainConfig;
    //~ this.mainItemClass = mainItemClass;
};

Lino.WindowAction = Ext.extend(Lino.WindowAction,{
    window : null,
    //~ mainItemClass: null,
    get_window : function() {
      //~ if(mainConfig) Ext.apply(this.mainConfig,mainConfig);
      if (this.window == null)  {
          //~ this.windowConfig.main_item = new this.mainItemClass(this.mainConfig);
          this.windowConfig.main_item = this.main_item_fn();
          this.window = new Lino.Window(this.windowConfig);
      }
      return this.window;
    },
    run : function(requesting_panel,status) {
      //~ console.log('20120625 window_action.run()',this)
      Lino.open_window(this.get_window(),status,requesting_panel);
    }
  
});


Lino.PanelMixin = {
  get_containing_window : function (){
      if (this.containing_window) return this.containing_window;
      return this.containing_panel.get_containing_window();
  }
  ,set_window_title : function(title) {
    //~ this.setTitle(title);
    var cw = this.get_containing_window();

    //~ if (cw) {
    //~ if (cw && cw.closable) {
    if (cw && !cw.main_item.hide_window_title) {
      //~ console.log('20111202 set_window_title(',title,') for',this.containing_window);
      //~ if (! this.containing_window.rendered) console.log("WARNING: not rendered!");
      cw.setTitle(title);
    //~ } else {
      //~ document.title = title;
    }
    //~ else console.log('20111202 not set_window_title(',title,') for',this);
  }
  
};


Lino.status_bar = new Ext.ux.StatusBar({defaultText:'Lino version 1.6.7.'});



Lino.edit_tinymce_text = function(panel,options) {
  // `panel` is the RichTextPanel
  //~ console.log(20111220,panel);
  //~ var rec = panel.get_current_record();
  var rec = panel.containing_panel.get_current_record();
  var value = rec ? rec.data[panel.editor.name] : '';
  var saving = false;
  var todo_after_save = false;
  var discard_changes = false;
  
  
  function save() {
    //~ if (todo_after_save) {alert('tried to save again'); return; }
    if (saving) {alert('tried to save again'); return; }
    //~ var url = panel.containing_window.main_item.get_record_url(rec.id);
    var url = panel.containing_panel.get_record_url(rec.id);
    var params = Ext.apply({},panel.containing_panel.get_base_params());
    params[panel.editor.name] = editor.getValue();
    //~ params.su = Lino.subst_user;
    //~ Lino.insert_subst_user(params);
    var a = { 
      params: params, 
      method: 'PUT',
      url: url,
      failure: function() {
          //~ if (editor.ed.getContainer()) 
          editor.ed.setProgressState(0);
          todo_after_save = false;
          saving = false;
          console.log('tinymce.save() failed. sorry.',arguments);
        },
      success: function() {
        saving = false;
        //~ if (editor.ed.getContainer()) 
        editor.ed.setProgressState(0);
        rec.data[panel.editor.name] = editor.getValue();
        if(todo_after_save) {
            var fn = todo_after_save;
            todo_after_save = false;
            fn();
        }
        //~ panel.containing_window.set_current_record(rec);
        panel.refresh();
      }
    };
    //~ if (editor.ed.getContainer()) 
    editor.ed.setProgressState(1); // Show progress
    saving = true;
    //~ console.log(a);
    Ext.Ajax.request(a);
  };
  function save_callback() {
      save();
      //~ save(function(){editor.ed.setDirty(false);})
      /* return true have the save button disabled.  
      That's not perfect because the PUT is asynchronous 
      and the response is not yet known.
      */
      return true;
  }
  //~ var actions = [
    //~ {text:"Save",handler:save}
  //~ ]; 
  //~ console.log(20110610,panel.editor.disabled);
  var settings = {};
  Ext.apply(settings,{
        readonly: panel.editor.disabled,
        //~ language: "de",
        plugins : "save,emotions,spellchecker,advhr,insertdatetime,preview,table,searchreplace,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "save,cancel,|,bold,italic,underline,|,justifyleft,justifycenter,justifyright,fontselect,fontsizeselect,formatselect,|,search,replace",
        theme_advanced_buttons2 : "cut,copy,paste,template,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,link,unlink,anchor,image,|,code,preview,|,forecolor,backcolor",
        theme_advanced_buttons3 : "insertdate,inserttime,|,spellchecker,advhr,,removeformat,|,sub,sup,|,charmap,emotions,|,tablecontrols",      
        theme_advanced_resizing : false,
        convert_urls : false,
        save_onsavecallback : save_callback,
        save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
  });
  Ext.apply(settings,options);
  var editor = new Ext.ux.TinyMCE({
      value : value,
      tinymceSettings: settings
    });
  var win = new Ext.Window({
    title: rec.title, 
    //~ bbar: actions,
    layout: 'fit',
    items: editor,
    width: 600, 
    height:500,
    minWidth: 100,
		minHeight: 100,
    modal: true,
    resizable: true,
    maximizable: true,
    //~ maximized: true,
    //~ closeAction: "close"
    closeAction: "hide"
    //~ hideMode: "offsets",
    //~ constrainHeader: true,
    //~ bodyStyle: 'padding: 10px'
  });

  //~ win.on('beforeclose',function() {
  win.on('beforehide',function() {
    if (todo_after_save) return false;
    if (discard_changes) return true;
    if (editor.isDirty()) {
        //~ var ok = false;
        //~ var allowClose = true;
        var config = {title:"Bestätigung"};
        config.buttons = Ext.MessageBox.YESNOCANCEL;
        config.msg = "Änderungen im Text speichern?";
        config.modal = true;
        config.fn = function(buttonId,text,opt) {
          //~ console.log('do_when_clean',buttonId)
          if (buttonId == "yes") {
              /* we cancel this close, but save()'s onSuccess will call again.*/
              //~ allowClose = false;
              todo_after_save = function(){win.hide();}
              editor.ed.execCommand('mceSave');
              //~ editor.ed.save(function(){win.close();});
          } else if (buttonId == "no") { 
              discard_changes = true;
              win.hide()
          //~ } else if (buttonId == "cancel") { 
            //~ ok = true;
              //~ allowClose = false;
          //~ } else { 
            //~ console.log('unknwon buttonId:',buttonId);
          }
        }
        Ext.MessageBox.show(config);
        return false;
        //~ return allowClose;
    }
  });
  win.show();
}







/* 
  Originally copied from Ext JS Library 3.3.1
  Modifications by Luc Saffre : 
  - rendering of phantom records
  - fire afteredit event
  - react on dblclcik, not on single click

 */
Lino.CheckColumn = Ext.extend(Ext.grid.Column, {

    processEvent : function(name, e, grid, rowIndex, colIndex){
        //~ console.log('20110713 Lino.CheckColumn.processEvent',name)
        if (name == 'click') {
        //~ if (name == 'mousedown') {
        //~ if (name == 'dblclick') {
            return this.toggleValue(grid, rowIndex, colIndex);
        } else {
            return Ext.grid.ActionColumn.superclass.processEvent.apply(this, arguments);
        }
    },
    
    toggleValue : function (grid,rowIndex,colIndex) {
        var record = grid.store.getAt(rowIndex);
        var dataIndex = grid.colModel.getDataIndex(colIndex);
        // 20120514
        //~ if(record.data.disabled_fields && record.data.disabled_fields[dataIndex]) {
          //~ Lino.notify("Dieses Feld ist deaktiviert");
          //~ return false;
        //~ }
      
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("This field is disabled.");
            //~ return false;
        //~ }
        var startValue = record.data[dataIndex];
        var value = !startValue;
        //~ record.set(this.dataIndex, value);
        var e = {
            grid: grid,
            record: record,
            field: dataIndex,
            originalValue: startValue,
            value: value,
            row: rowIndex,
            column: colIndex,
            cancel: false
        };
        if(grid.fireEvent("beforeedit", e) !== false && !e.cancel){
        //~ if(grid.fireEvent("validateedit", e) !== false && !e.cancel){
            record.set(dataIndex, value);
            delete e.cancel;
            grid.fireEvent("afteredit", e);
        }
        return false; // Cancel event propagation
    },

    renderer : function(v, p, record){
        if (record.phantom) return '';
        p.css += ' x-grid3-check-col-td'; 
        return String.format('<div class="x-grid3-check-col{0}">&#160;</div>', v ? '-on' : '');
    }

    // Deprecate use as a plugin. Remove in 4.0
    // init: Ext.emptyFn
});

// register ptype. Deprecate. Remove in 4.0
// Ext.preg('checkcolumn', Lino.CheckColumn);

// backwards compat. Remove in 4.0
// Ext.grid.CheckColumn = Lino.CheckColumn;

// register Column xtype
Ext.grid.Column.types.checkcolumn = Lino.CheckColumn;


/* 20110725 : 
Lino.on_tab_activate is necessary 
in contacts.Person.2.dtl 
(but don't ask me why...)
*/
Lino.on_tab_activate = function(item) {
  //~ console.log('activate',item); 
  if (item.rendered && item.doLayout) item.doLayout();
  //~ if (item.rendered) item.doLayout();
}

Lino.TimeField = Ext.extend(Ext.form.TimeField,{
  format: 'H:i',
  increment: 15
  });
Lino.DateField = Ext.extend(Ext.form.DateField,{
  boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  altFormats: 'd/m/Y|Y-m-d'
  });
Lino.DatePickerField = Ext.extend(Ext.DatePicker,{
  //~ boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  //~ altFormats: 'd/m/Y|Y-m-d'
  formatDate : function(date){
      console.log("20121203 formatDate",this.name,date);
      return Ext.isDate(date) ? date.dateFormat(this.format) : date;
  }
  });
Lino.DateTimeField = Ext.extend(Ext.ux.form.DateTime,{
  dateFormat: 'd.m.Y',
  timeFormat: 'H:i',
  //~ hiddenFormat: 'd.m.Y H:i'
  });
Lino.URLField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  //~ triggerClass : 'x-form-world-trigger',
  vtype: 'url',
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    window.open(this.getValue(),'_blank');
  }
});
Lino.IncompleteDateField = Ext.extend(Ext.form.TextField,{
  //~ regex: /^-?\d+-[01]\d-[0123]\d$/,
  //~ regex: /^[0123]\d\.[01]\d\.-?\d+$/,
  maxLength: 10,
  boxMinWidth: Lino.chars2width(10),
  regex: /^[0123]?\d\.[01]?\d\.-?\d+$/,
  regexText: 'Datum im Format JJJJ-MM-TT eingeben (Nullen für unbekannte Teile)'
  });


//~ Lino.make_dropzone = function(cmp) {
    //~ cmp.on('render', function(ct, position){
      //~ ct.el.on({
        //~ dragenter:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ return true;
        //~ }
        //~ ,dragover:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ event.stopEvent();
          //~ return true;
        //~ }
        //~ ,drop:{
          //~ scope:this
          //~ ,fn:function(event){
            //~ event.stopEvent();
            //~ console.log(20110516);
            //~ var files = event.browserEvent.dataTransfer.files;
            //~ if(files === undefined){
              //~ return true;
            //~ }
            //~ var len = files.length;
            //~ while(--len >= 0){
              //~ console.log(files[len]);
              //~ // this.processDragAndDropFileUpload(files[len]);
            //~ }
          //~ }
        //~ }
      //~ });
    //~ });
//~ };

//~ Lino.FileUploadField = Ext.ux.form.FileUploadField;

Lino.FileUploadField = Ext.extend(Ext.ux.form.FileUploadField,{
    onRender : function(ct, position){
      Lino.FileUploadField.superclass.onRender.call(this, ct, position);
      this.el.on({
        dragenter:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          return true;
        }
        ,dragover:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          event.stopEvent();
          return true;
        }
        ,drop:{
          scope:this
          ,fn:function(event){
            event.stopEvent();
            //~ console.log(20110516);
            var files = event.browserEvent.dataTransfer.files;
            if(files === undefined){
              return true;
            }
            var len = files.length;
            while(--len >= 0){
              console.log(files[len]);
              //~ this.processDragAndDropFileUpload(files[len]);
            }
          }
        }
      });
    }
});

Lino.FileField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  editable: false,
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    if (this.getValue()) window.open(MEDIA_URL + '/'+this.getValue(),'_blank');
  }
});

Lino.file_field_handler = function(panel,config) {
  //~ if (instanceof Lino.DetailWrapper) {
  if (panel.action_name == 'insert') {
  //~ if (panel.get_current_record().phantom) {
      panel.has_file_upload = true;

      var f = new Lino.FileUploadField(config);
      //~ Lino.make_dropzone(f);
      return f;
      //~ return new Ext.ux.form.FileUploadField(config);
      //~ return new Lino.FileField(config);
      
  } else {
      //~ return new Lino.URLField(config);
      return new Lino.FileField(config);
  }
}

Lino.VBorderPanel = Ext.extend(Ext.Panel,{
    constructor : function(config) {
      config.layout = 'border';
      delete config.layoutConfig;
      Lino.VBorderPanel.superclass.constructor.call(this,config);
      for(var i=0; i < this.items.length;i++) {
        var item = this.items.get(i);
        if (this.isVertical(item) && item.collapsible) {
          item.on('collapse',this.onBodyResize,this);
          item.on('expand',this.onBodyResize,this);
        }
      }
    },
    isVertical : function(item) {
       return (item.region == 'north' || item.region == 'south' || item.region == 'center');
    },
    onBodyResize: function(w, h){
        //~ console.log('VBorderPanel.onBodyResize',this.title)
      if (this.isVisible()) { // to avoid "Uncaught TypeError: Cannot call method 'getHeight' of undefined."
        var sumflex = 0;
        var availableHeight = this.getInnerHeight();
        var me = this;
        this.items.each(function(item){
          if (me.isVertical(item)) {
              if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  if (item.rendered) availableHeight -= item.getHeight();
              } else {
                  sumflex += item.flex;
              }
          } 
          
        });
        //~ for(var i=0; i < this.items.length;i++) {
          //~ var item = this.items.get(i);
          //~ // if (this.isVertical(item) && item.getResizeEl()) {
          //~ if (this.isVertical(item)) {
              //~ if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  //~ // item.syncSize()
                  //~ // item.doLayout()
                  //~ // if (item.region == "north") console.log('region north',item.getHeight(),item.id, item);
                  //~ // if (item.getHeight() == 0) console.log(20100921,'both flex and getHeight() are 0!');
                  //~ availableHeight -= item.getHeight();
              //~ } else {
                  //~ sumflex += item.flex;
                  //~ // console.log(item.flex);
              //~ }
          //~ } 
          //~ // else console.log('non-vertical item in VBoderPanel:',item)
        //~ }
        var hunit = availableHeight / sumflex;
        //~ console.log('sumflex=',sumflex,'hunit=',hunit, 'availableHeight=',availableHeight);
        for(var i=0; i < this.items.length;i++) {
          var item = this.items.get(i);
          if (this.isVertical(item)) {
              if (item.flex != 0 && ! item.collapsed) {
                  item.setHeight(hunit * item.flex);
                  //~ console.log(item.region,' : height set to',item.getHeight());
              }
          }
          //~ else console.log('non-vertical item in VBoderPanel:',item)
        }
      }
      Lino.VBorderPanel.superclass.onBodyResize.call(this, w, h);
    }
});


/*
  modifications to the standard behaviour of a CellSelectionModel:
  
*/
Ext.override(Ext.grid.CellSelectionModel, {
//~ var dummy = {

    handleKeyDown : function(e){
        /* removed because F2 wouldn't pass
        if(!e.isNavKeyPress()){
            return;
        }
        */
        //~ console.log('handleKeyDown',e)
        var k = e.getKey(),
            g = this.grid,
            s = this.selection,
            sm = this,
            walk = function(row, col, step){
                return g.walkCells(
                    row,
                    col,
                    step,
                    g.isEditor && g.editing ? sm.acceptsNav : sm.isSelectable, 
                    sm
                );
            },
            cell, newCell, r, c, ae;

        switch(k){
            case e.ESC:
            case e.PAGE_UP:
            case e.PAGE_DOWN:
                break;
            default:
                // e.stopEvent(); // removed because Browser keys like Alt-Home, Ctrl-R wouldn't work
                break;
        }

        if(!s){
            cell = walk(0, 0, 1); 
            if(cell){
                this.select(cell[0], cell[1]);
            }
            return;
        }

        cell = s.cell;  
        r = cell[0];    
        c = cell[1];    
        
        switch(k){
            case e.TAB:
                if(e.shiftKey){
                    newCell = walk(r, c - 1, -1);
                }else{
                    newCell = walk(r, c + 1, 1);
                }
                break;
            case e.HOME:
                if (! (g.isEditor && g.editing)) {
                  if (!e.hasModifier()){
                      newCell = [r, 0];
                      //~ console.log('home',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
                      if (activePage > 1) {
                          e.stopEvent();
                          t.moveFirst();
                          return;
                      }
                      newCell = [0, c];
                      break;
                  }
                }
            case e.END:
                if (! (g.isEditor && g.editing)) {
                  c = g.colModel.getColumnCount()-1;
                  if (!e.hasModifier()) {
                      newCell = [r, c];
                      //~ console.log('end',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var d = t.getPageData();
                      if (d.activePage < d.pages) {
                          e.stopEvent();
                          var self = this;
                          t.on('change',function(tb,pageData) {
                              var r = g.store.getCount()-2;
                              self.select(r, c);
                              //~ console.log('change',r,c);
                          },this,{single:true});
                          t.moveLast();
                          return;
                      } else {
                          newCell = [g.store.getCount()-1, c];
                          //~ console.log('ctrl-end',newCell);
                          break;
                      }
                  }
                }
            case e.DOWN:
                newCell = walk(r + 1, c, 1);
                break;
            case e.UP:
                newCell = walk(r - 1, c, -1);
                break;
            case e.RIGHT:
                newCell = walk(r, c + 1, 1);
                break;
            case e.LEFT:
                newCell = walk(r, c - 1, -1);
                break;
            case e.F2:
                if (!e.hasModifier()) {
                    if (g.isEditor && !g.editing) {
                        g.startEditing(r, c);
                        e.stopEvent();
                        return;
                    }
                    break;
                }
            case e.INSERT:
                if (!e.hasModifier()) {
                    if (g.ls_insert_handler && !g.editing) {
                        e.stopEvent();
                        Lino.show_insert(g);
                        return;
                    }
                    break;
                }
            case e.DELETE:
                if (!e.hasModifier()) {
                    if (!g.editing) {
                        e.stopEvent();
                        Lino.delete_selected(g);
                        return;
                    }
                    break;
                }
            case e.ENTER:
                e.stopEvent();
                g.onCellDblClick(r,c);
                break;
                
        }
        

        if(newCell){
          e.stopEvent();
          r = newCell[0];
          c = newCell[1];
          this.select(r, c); 
          if(g.isEditor && g.editing){ 
            ae = g.activeEditor;
            if(ae && ae.field.triggerBlur){
                ae.field.triggerBlur();
            }
            g.startEditing(r, c);
          }
        //~ } else if (g.isEditor && !g.editing && e.charCode) {
        //~ // } else if (!e.isSpecialKey() && g.isEditor && !g.editing) {
            //~ g.set_start_value(String.fromCharCode(e.charCode));
            //~ // g.set_start_value(String.fromCharCode(k));
            //~ // g.set_start_value(e.charCode);
            //~ g.startEditing(r, c);
            //~ // e.stopEvent();
            //~ return;
        // } else {
          // console.log('20120513',e,g);
        }
        
    }


//~ };
});

 

function PseudoConsole() {
    this.log = function() {};
};
if (typeof(console) == 'undefined') console = new PseudoConsole();

Lino.notify = function(msg) {
  if (msg == undefined) msg = ''; else console.log(msg);
  //~ Ext.getCmp('konsole').update(msg);
  Lino.status_bar.setStatus({
    text: msg,
    iconCls: 'ok-icon',
    clear: true // auto-clear after a set interval
  });
  //~ Ext.getCmp('konsole').setTitle(msg.replace(/\n/g,'<br/>'));
  //~ Ext.getCmp('konsole').update(msg.replace(/\n/g,'<br/>'));
};
Lino.alert = function(msg) {
  //~ if (msg == undefined) msg = ''; else console.log(msg);
  Ext.MessageBox.alert('Notify',msg);
};


//~ Lino.show_about = function() {
  //~ new Ext.Window({
    //~ width: 400, height: 400,
    //~ title: "About",
    //~ html: '<a href="http://www.extjs.com" target="_blank">ExtJS</a> version ' + Ext.version
  //~ }).show();
//~ };

function obj2str(o) {
  if (typeof o != 'object') return String(o);
  var s = '';
  for (var p in o) {
    s += p + ': ' + obj2str(o[p]) + '\n';
  }
  return s;
}

Lino.on_store_exception = function (store,type,action,options,response,arg) {
  //~ throw response;
  console.log("on_store_exception: store=",store,
    "type=",type,
    "action=",action,
    "options=",options,
    "response=",response,
    "arg=",arg);
  if (arg) { console.log(arg.stack)};
};

//~ Lino.on_submit_success = function(form, action) {
   //~ Lino.notify(action.result.message);
   //~ this.close();
//~ };

Lino.on_submit_failure = function(form, action) {
    //~ Lino.notify();
  // action may be undefined
    switch (action.failureType) {
        case Ext.form.Action.CLIENT_INVALID:
            Ext.Msg.alert('Client-side failure', 'Form fields may not be submitted with invalid values');
            break;
        case Ext.form.Action.CONNECT_FAILURE:
            Ext.Msg.alert('Connection failure', 'Ajax communication failed');
            break;
        case Ext.form.Action.SERVER_INVALID:
            Ext.Msg.alert('Server-side failure', action.result.message);
   }
};



/*
Lino.save_wc_handler = function(ww) {
  return function(event,toolEl,panel,tc) {
    var pos = panel.getPosition();
    var size = panel.getSize();
    wc = ww.get_window_config();
    Ext.applyIf(wc,{ 
      x:pos[0],y:pos[1],height:size.height,width:size.width,
      maximized:panel.maximized});
    Lino.do_action(ww,{url:'/window_configs/'+ww.config.permalink_name,params:wc,method:'POST'});
  }
};

*/

Lino.show_in_own_window_button = function(handler) {
  return {
    qtip: "Dieses Panel in eigenem Fenster öffnen", 
    id: "up",
    handler: function(event,toolEl,panel, tc) {
      //~ console.log('20111206 report_window_button',panel,handler);
      //~ var bp = ww.get_master_params();
      //~ panel.containing_window = ww; // for HtmlBox. see blog/2010/1022
      //~ handler(panel,{base_params:bp});
      //~ handler(panel,{base_params:panel.get_master_params()});
      handler.run(null,{base_params:panel.containing_panel.get_master_params()});
      //~ handler(panel,{master_panel:panel.containing_window.main_item});
    }
  }
}




Lino.delete_selected = function(panel) {
  //~ console.log("Lino.delete_selected",panel);
  var recs1 = panel.get_selected();
  var recs = [];
  for ( var i=0; i < recs1.length; i++ ) { if (! recs1[i].phantom) recs.push(recs1[i]); }
  if (recs.length == 0) {
    Lino.notify("Please select at least one record.");
    return;
  };
  if (recs.length == 1) {
      if (recs[0].disable_delete) {
        Lino.alert(recs[0].disable_delete);
        return;
      }
  };
  //~ console.log(recs);
  Ext.MessageBox.show({
    title: "Bestätigung",
    msg: String.format("Es werden {0} Datensätze gelöscht. Sind Sie sicher?",String(recs.length)),
    //~ msg: "Delete " + String(recs.length) + " rows. Are you sure?",
    //~ buttons: Ext.MessageBox.YESNOCANCEL,
    buttons: Ext.MessageBox.YESNO,
    fn: function(btn) {
      if (btn == 'yes') {
        for ( var i=0; i < recs.length; i++ ) {
          Lino.do_action(panel,{
              method:'DELETE',
              url:  '/api' + panel.ls_url + '/' + recs[i].id,
              after_success: panel.after_delete.createDelegate(panel)
          })
        }
        //~ caller.after_delete();
      }
      else Lino.notify("Dann eben nicht.");
    }
  });
};

Lino.action_handler = function (panel,on_success,on_confirm) {
  return function (response) {
    //~ console.log(20120608,panel);
    if (panel instanceof Lino.GridPanel) {
        //~ gridmode = false;
        gridmode = true;
        //~ console.log('20120608 yes');
    } else {
        gridmode = false;
        //~ console.log('20120608 no');
    }
    panel.loadMask.hide(); // 20120211
    if (!response.responseText) return ;
    var result = Ext.decode(response.responseText);
    //~ console.log('Lino.action_handler()','result is',result,'on_confirm is',on_confirm);
    
    if (result.eval_js) {
        //~ console.log(20120618,result.eval_js);
        eval(result.eval_js);
    }
    
    if (result.xcallback) {
        //~ var config = {title:"Bestätigung"};
        var config = {title:result.xcallback.title};
        //~ config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        config.buttons = result.xcallback.buttons;
        config.msg = result.message;
        config.fn = function(buttonId,text,opt) {
          panel.loadMask.show(); 
          //~ Lino.insert_subst_user(p);
          Ext.Ajax.request({
            method: 'GET',
            url: '/callbacks/'+result.xcallback.id + '/' + buttonId,
            //~ params: {bi: buttonId},
            success: Lino.action_handler(panel,on_success,on_confirm)
          });
          //~ Lino.call_ajax_action(panel,'GET',)
        }
        Ext.MessageBox.show(config);
        return;
    }
    
    if (on_success && result.success) on_success(result);
    
    //~ if (on_confirm && result.confirm_message) {
        //~ var config = {title:"Bestätigung"};
        //~ // config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        //~ config.msg = result.confirm_message;
        //~ config.fn = function(buttonId,text,opt) {
          //~ if (buttonId == "yes") {
              //~ on_confirm(panel,undefined,result.step);
          //~ }
        //~ }
        //~ Ext.MessageBox.show(config);
        //~ return;
    //~ }
    //~ if (result.dialog_fn) {
        //~ console.log('20120928 TODO',result.dialog_fn);
    //~ }
    if (result.message) {
        //~ if (result.alert && ! gridmode) {
        if (result.alert) { // 20120628b 
            //~ Ext.MessageBox.alert('Alert',result.alert_msg);
            if (result.alert === true) result.alert = "Alarm";
            Ext.MessageBox.alert(result.alert,result.message);
        } else {
            Lino.notify(result.message);
        }
    }
    // 
    if (result.data_record && ! gridmode) {
        //~ not used
        panel.set_status({data_record:result.data_record});
    }
    else if (result.new_status && ! gridmode) {
        //~ not used
        //~ console.log('20120607 new_status');
        panel.set_status(result.new_status);
    }
    else if (result.goto_record_id != undefined && ! gridmode) {
        //~ console.log('20120607 new_status');
        panel.load_record_id(result.goto_record_id);
    }
    else if (result.refresh_all) {
        var cw = panel.get_containing_window();
        //~ console.log("20120123 refresh_all");
        if (cw) {
          cw.main_item.refresh();
        }
        else console.log("20120123 cannot refresh_all",panel);
    } else {
        //~ console.log("20121212 b gonna refresh",panel);
        if (result.refresh) panel.refresh();
    }
    
    if (result.open_url) {
        //~ console.log(20111126,result.open_url);
        //~ if (!result.message)
            //~ Lino.notify('Open new window <a href="'+result.open_url+'" target="_blank">'+result.open_url+'</a>');
        window.open(result.open_url,'foo',"");
        //~ document.location = result.open_url;
    }
  }
};

Lino.do_action = function(caller,action) {
  action.success = function(response) {
    if (caller.loadMask) caller.loadMask.hide();
    //~ console.log('Lino.do_action()',action,'action success',response);
    if (action.after_success) {
        //~ console.log('Lino.do_action() calling after_success');
        action.after_success();
    }
    if (response.responseText) {
      var result = Ext.decode(response.responseText);
      //~ console.log('Lino.do_action()',action.name,'result is',result);
      if (result.message) {
          if (result.alert) {
              //~ Ext.MessageBox.alert('Alert',result.alert_msg);
              Ext.MessageBox.alert('Alert',result.message);
          } else {
              Lino.notify(result.message);
          }
      }
      
      //~ if (result.alert_msg) Ext.MessageBox.alert('Alert',result.alert_msg);
      //~ if (result.message) Lino.notify(result.message);
      if (result.notify_msg) Lino.notify(result.notify_msg);
      if (result.js_code) { 
        //~ console.log('Lino.do_action()',action,'gonna call js_code in',result);
        var jsr = result.js_code(caller);
        //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
        if (action.after_js_code) {
          //~ console.log('Lino.do_action()',action,'gonna call after_js_code');
          action.after_js_code(jsr);
          //~ console.log('Lino.do_action()',action,'returned from after_js_code');
        //~ } else {
          //~ console.log('Lino.do_action()',action,' : after_js_code is false');
        }
      };
    }
  };
  Ext.applyIf(action,{
    waitMsg: "Bitte warten...",
    failure: Lino.ajax_error_handler(caller),
    params: {}
  });
  //~ action.params.su = Lino.subst_user;
  Lino.insert_subst_user(action.params);
  
  Ext.Ajax.request(action);
};

//~ Lino.gup = function( name )
//~ {
  //~ // Thanks to http://www.netlobo.com/url_query_string_javascript.html
  //~ name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
  //~ var regexS = "[\\?&]"+name+"=([^&#]*)";
  //~ var regex = new RegExp( regexS );
  //~ var results = regex.exec( window.location.href );
  //~ if( results == null )
    //~ return "";
  //~ else
    //~ return results[1];
//~ };

//~ Lino.refresh_handler = function (ww) {
  //~ return function() { 
      //~ console.log('refresh',ww);
      //~ ww.main_item.doLayout(false,true);
      //~ ww.main_item.syncSize();
  //~ }
//~ };

//~ Lino.tools_close_handler = function (ww) {
  //~ return function() { 
      //~ ww.close();
  //~ }
//~ };
Lino.permalink_handler = function (ww) {
  return function() { 
    //~ console.log(20100923,ww.get_permalink());
    //~ document.location = ww.main_item.get_permalink();
    Lino.load_url(ww.main_item.get_permalink());
    //~ console.log(20120715, ww.main_item.get_permalink());
    //~ document.location = "?permalink=" + ww.get_permalink();
    //~ document.location = "?permalink=" + ww.config.permalink_name +'()';
  }
};
//~ Lino.run_permalink = function() {
  //~ var plink = Lino.gup('permalink');
  //~ if(plink) { eval('Lino.'+plink); }
//~ }

Lino.MainPanel = {
  is_home_page : false,
  setting_param_values : false,
  config_containing_window : function(wincfg) { }
  ,init_containing_window : function(win) { }
  ,is_loading : function() { return true; } // overridden by subclasses
  ,do_when_clean : function(auto_save,todo) { todo() }
  ,get_master_params : function() {
    var p = {}
    p['mt'] = this.content_type; 
    rec = this.get_current_record()
    if (rec) {
      if (rec.phantom) {
          p['mk'] = undefined; 
      }else{
          p['mk'] = rec.id; 
      }
    } else {
      p['mk'] = undefined;
    }
    //~ console.log('get_master_params returns',p,'using record',rec);
    return p;
  }
  ,get_permalink : function() {
    //~ var p = this.main_item.get_base_params() || {};
    var p = Ext.apply({},this.get_base_params());
    delete p.fmt;
    //~ if (p.fmt) delete p.fmt;
    Ext.apply(p,this.get_permalink_params());
    //~ Lino.insert_subst_user(p);
     //~ p.fmt = 'html';
    //~ console.log('get_permalink',p,this.get_permalink_params());
    if (this.is_home_page)
        //~ var url = '';
        var url = '/';
    else 
        var url = this.get_permalink_url();
    if (p.su == null) 
        delete p.su;
    if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
    return url;
  }
  ,get_record_url : function(record_id) {
      var url = '/api' + this.ls_url
      //~ var url = this.containing_window.config.url_data; // ls_url;
      url += '/' + (record_id === undefined ? '-99999' : String(record_id));
      //~ if (record_id !== undefined) url += '/' + String(record_id);
      //~ url += '/' + String(record_id);
      return url;
  }
  ,get_permalink_url : function() {
      return '/api' + this.ls_url;
  }
  ,get_permalink_params : function() {
      //~ return {an:'grid'};
      var p = {};
      if (this.action_name)
          p.an = this.action_name;
      this.add_param_values(p)
      return p;
  }
  ,set_status : function(status) {}
  ,get_status : function() { return {}}
  ,refresh : function() {}
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,add_params_panel : function (tbar) {
      if (this.params_panel) {
        tbar = tbar.concat([{ scope:this, 
          //~ text: "$_("[parameters]")", // gear
          iconCls: 'x-tbar-parameters',
          tooltip:"Parameter-Panel ein- bzw. ausblenden",
          enableToggle: true,
          //~ pressed: ! this.params_panel.hidden,
          pressed: ! this.params_panel_hidden,
          toggleHandler: function(btn,state) { 
            //~ if (this.params_panel.isVisible()) 
                //~ this.params_panel.hide();
            //~ else
                //~ this.params_panel.show();
            //~ console.log("20120210 add_params_panel",state,this.params_panel);
            if (state) {
              this.params_panel.show();
              this.params_panel.doLayout();
            } else this.params_panel.hide();
            this.get_containing_window().doLayout();
          }
        }]);
        var t = this;
        var refresh = function() {if (!t.setting_param_values) t.refresh();}
        Ext.each(this.params_panel.fields,function(f) {
          //~ f.on('valid',function() {t.refresh()});
          if (f instanceof Ext.form.Checkbox) {
              f.on('check',refresh);
          } else if (f instanceof Ext.DatePicker) {
              f.on('select',refresh);
          } else if (f instanceof Ext.form.TriggerField) {
              f.on('select',refresh);
              //~ f.on('change',refresh);
              //~ f.on('valid',refresh);
          } else {
              if (! f.on) 
                  console.log("20121010 no method 'on'",f);
              else
                  f.on('change',refresh);
            }
          });
      }
      return tbar;
  }
  ,add_param_values : function (p) {
    if (this.params_panel) {
      /* 
      20120918 add param_values to the request string 
      *only if the params_form is dirty*.
      Otherwise Actor.default_params() would never be used.
      
      20121023 But IntegClients.params_default has non-empty default values. 
      Users must have the possibility to make them empty.
      */
      if (this.params_panel.form.isDirty()) {
        p.pv = this.get_param_values();
      }else{
        if (this.status_param_values) 
          p.pv = Lino.fields2array(
            this.params_panel.fields,this.status_param_values);
      }
      //~ if (!this.params_panel.form.isDirty()) return;
      //~ p.pv = this.get_param_values();
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
    }
  },
  get_param_values : function() { // similar to get_field_values()
      return Lino.fields2array(this.params_panel.fields);
  },
  set_param_values : function(pv) {
    if (this.params_panel) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_param_values = pv;
      //~ this.params_panel.form.suspendEvents(false);
      this.setting_param_values = true;
      if (pv) { 
          this.params_panel.form.my_loadRecord(pv);
      } else { 
        this.params_panel.form.reset(); 
      }
      this.setting_param_values = false;
      //~ this.params_panel.form.resumeEvents();
    }
  }
};


Lino.ajax_error_handler = function(panel) {
  return function(response,options) {
    console.log('Ajax failure:',response,options);
    if (panel.loadMask) panel.loadMask.hide();
    if (response.responseText) {
      var lines = response.responseText.split('\n');
      if (lines.length > 10) {
          line = lines.splice(5,lines.length-10,"(...)");
      }
      Ext.MessageBox.alert(
        response.statusText,
        lines.join('<br/>')
        //~ response.responseText.replace(/\n/g,'<br/>'))
      )
    } else {
      Ext.MessageBox.alert('Action failed',
        'Lino server did not respond to Ajax request');
    }
  }
}
// Ext.Ajax.on('requestexception',Lino.ajax_error_handler)
 


Ext.QuickTips.init();

/* setting QuickTips dismissDelay to 0 */
// Apply a set of config properties to the singleton
//~ Ext.apply(Ext.QuickTips.getQuickTip(), {
//~ Ext.apply(Ext.ToolTip, {
    //~ dismissDelay: 0
    //~ autoHide: false,
    //~ closable: true,
    //~ maxWidth: 200,
    //~ minWidth: 100,
    //~ showDelay: 50      // Show 50ms after entering target
    //~ ,trackMouse: true
//~ });


//~ Ext.apply(Ext.QuickTip, {
    //~ dismissDelay: 0,
//~ });
  
Lino.quicktip_renderer = function(title,body) {
  return function(c) {
    //~ if (c instanceof Ext.Panel) var t = c.bwrap; else // 20130129
    if (c instanceof Ext.Panel) var t = c.header; else // 20130129
    var t = c.getEl();
    //~ console.log(20130129,t,title,body);
    //~ t.dismissDelay = 0;
    Ext.QuickTips.register({
      target: t,
      //~ cls: 'lino-quicktip-classical',
      dismissDelay: 0,
      //~ autoHide: false,
      showDelay: 50,      // Show 50ms after entering target
      //~ title: title,
      text: body
    });
  }
};


  
Lino.help_text_editor = function() {
  //~ var bp = {
      //~ mk:this.content_type,
      //~ mt:1
    //~ };
    //~ console.log(20120202,bp);
  //~ Lino.lino.ContentTypes.detail({},{base_params:bp});
  //~ Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
  Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
}

// Path to the blank image should point to a valid location on your server
//~ Ext.BLANK_IMAGE_URL = MEDIA_URL + '/extjs/resources/images/default/s.gif'; 


// used as Ext.grid.Column.renderer for id columns in order to hide the special id value -99999
Lino.id_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  return value;
}

Lino.raw_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  return value;
}

Lino.text_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return "not implemented"; 
  return value;
}

Lino.NullNumberColumn = Ext.extend(Ext.grid.Column, {
    align : 'right', 
    format : '0,00/i', 
    renderer : function(value, metaData, record, rowIndex, colIndex, store) {
        //~ console.log(20130128,"NullNumberColumn.renderer",value);
        if (value === null) return '';
        return Ext.util.Format.number(value, this.format);
    }
});

//~ Lino.NullNumberColumn = Ext.extend(Ext.grid.NumberColumn, {
    //~ align : 'right', 
    //~ constructor: function(cfg){
        //~ Ext.grid.NumberColumn.superclass.constructor.call(this, cfg);
        //~ var t = this;
        //~ this.renderer = function(value, metaData, record, rowIndex, colIndex, store) {
          //~ console.log(20130128,"NullNumberColumn.renderer",value);
          //~ if (value === null) return '';
          //~ return Ext.util.Format.number(value, t.format);
      //~ };
    //~ }
//~ });




//~ Lino.cell_button_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return '<input type="button" onclick="alert(value)" value=" ? ">' ;
//~ }


//~ Lino.default_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  //~ return value;
//~ }

Lino.fk_renderer = function(fkname,handlername) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    //~ if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '.run(null,{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

Lino.lfk_renderer = function(panel,fkname) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  var handlername = 'console.log';
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '({},{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

//~ Lino.gfk_renderer = function() {
  //~ return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ if (record.phantom) return '';
    //~ console.log('Lino.gfk_renderer',value,colIndex,record,metaData,store);
    //~ return value;
  //~ }
//~ };


Lino.build_buttons = function(panel,actions) {
  //~ console.log("20121006 Lino.build_buttons",actions);
  if (actions) {
    var buttons = Array(actions.length);
    var cmenu = Array(actions.length);
    for (var i=0; i < actions.length; i++) { 
      buttons[i] = new Ext.Toolbar.Button(actions[i]);
      cmenu[i] = actions[i]
      cmenu[i].text = actions[i].menu_item_text;
      if (actions[i].panel_btn_handler) {
          var h = actions[i].panel_btn_handler.createCallback(panel,buttons[i]);
          //~ if (actions[i].must_save) {
          if (actions[i].auto_save == true) {
              buttons[i].on('click',panel.do_when_clean.createDelegate(panel,[true,h]));
          } else if (actions[i].auto_save == null) {
              buttons[i].on('click',panel.do_when_clean.createDelegate(panel,[false,h]));
          } else if (actions[i].auto_save == false) {
              buttons[i].on('click',h);
          } else {
              console.log("20120703 unhandled auto_save value",actions[i])
          }
          cmenu[i].handler = actions[i].panel_btn_handler.createCallback(panel,cmenu[i]);
      }
    }
    return {bbar:buttons, cmenu:new Ext.menu.Menu(cmenu)};
  }
}

Lino.do_when_visible = function(cmp,todo) {
  //~ if (cmp.el && cmp.el.dom) 
  if (cmp.isVisible()) { 
    // 'visible' means 'rendered and not hidden'
    //~ console.log(cmp.title,'-> cmp is visible now');
    todo(); 
  //~ } else {
      //~ cmp.on('resize',todo,cmp,{single:true});
  //~ }
  //~ if (false) { // 20120213
  } else { 
    //~ console.log('Lino.do_when_visible() must defer because not isVisible()',todo,cmp);
    if (cmp.rendered) {
      //~ console.log(cmp,'-> cmp is rendered but not visible: and now?');
      //~ console.log(cmp.title,'-> cmp is rendered but not visible: try again in a moment...');
      //~ var fn = function() {Lino.do_when_visible(cmp,todo)};
      //~ fn.defer(100);
      
      Lino.do_when_visible.defer(50,this,[cmp,todo]);
      //~ Lino.do_when_visible.defer(100,this,[cmp,todo]);
      
    } else {
      //~ console.log(cmp.title,'-> after render');
      cmp.on('afterrender',todo,cmp,{single:true});
    }
  }
  
};    

/*
*/
Lino.do_on_current_record = function(panel,fn,phantom_fn) {
  var rec = panel.get_current_record();
  if (rec == undefined) {
    Lino.notify("There's no selected record.");
    return;
  }
  // 20120307 A VirtualTable with a Detail (lino.Models) has only "phantom" records.
  if (rec.phantom) {
    //~ if (!panel.editable) { console.log("20120312 not editable:",panel)}
    if (phantom_fn) {
      phantom_fn(panel);
    } else {
      Lino.notify("Aktion nicht verfügbar auf dem Phantom-Record.");
    }
    return;
  }
  return fn(rec);
};






Lino.call_ajax_action = function(panel,method,url,p,actionName,step,on_confirm,on_success) {
  p.an = actionName;
  if (!panel) panel = Lino.viewport;
  Ext.apply(p,panel.get_base_params());
  //~ console.log("20121212 Lino.call_ajax_action",panel);
  panel.loadMask.show(); 
  //~ p.$ext_requests.URL_PARAM_SUBST_USER = Lino.subst_user;
  //~ Lino.insert_subst_user(p);
    
  //~ if (step) p['$ext_requests.URL_PARAM_ACTION_STEP'] = step;
  //~ if (pp) pp(p); // "parameter processor" : first used for read beid card
  Ext.Ajax.request({
    method: method,
    url: url,
    params: p,
    success: Lino.action_handler(panel,on_success,on_confirm)
  });
};

Lino.row_action_handler = function(actionName,hm,pp) {
  var p = {};
  var fn = function(panel,btn,step) {
      if (pp) { p = pp(); if (! p) return; }
      Lino.do_on_current_record(panel,function(rec) {
          //~ console.log(panel);
          //~ 20120723 Lino.call_ajax_action(panel,rec.id,actionName,step,fn);
          Lino.call_ajax_action(panel,hm,panel.get_record_url(rec.id),p,actionName,step,fn);
      });
  };
  return fn;
};

Lino.list_action_handler = function(ls_url,actionName,hm,pp) {
  var p = {};
  var url = '/api' + ls_url
  var fn = function(panel,btn,step) {
      //~ console.log("20121210 Lino.list_action_handler",arguments);
      //~ var url = ADMIN_URL + '/api' + panel.ls_url
      if (pp) { p = pp();  if (! p) return; }
      Lino.call_ajax_action(panel,hm,url,p,actionName,step,fn);
  };
  return fn;
};

Lino.param_action_handler = function(window_action) { // 20121012
  var fn = function(panel,btn,step) {
    Lino.do_on_current_record(panel,function(rec) {
      //~ console.log(panel);
      //~ 20120723 Lino.call_ajax_action(panel,rec.id,actionName,step,fn);
      window_action.run(panel.getId(),{}); 
    });
  };
  return fn;
};


Lino.run_row_action = function(requesting_panel,url,pk,actionName,pp) {
  //~ var panel = action.get_window().main_item;
  url = '/api' + url  + '/' + pk;
  var panel = Ext.getCmp(requesting_panel);
  if (pp) var p = pp(); else var p = {};
  var fn = function(panel,btn,step) {
    //~ 20120723 Lino.call_ajax_action(panel,pk,actionName,step,fn);
    Lino.call_ajax_action(panel,'GET',url,p,actionName,step,fn);
  }
  fn(panel,null,null);
}



Lino.show_detail = function(panel,btn) {
  Lino.do_on_current_record(panel, 
    function(rec) {
      //~ panel.loadMask.show();
      var bp = panel.get_base_params();
      //~ var bp = {};
      panel.add_param_values(bp); // 20120918
      var status = {
        record_id:rec.id,
        base_params:bp
        //~ param_values: pv.$ext_requests.URL_PARAM_PARAM_VALUES
      }
      //~ console.log("20120918 Lino.show_detail",status);
      panel.ls_detail_handler.run(null,status);
      //~ panel.loadMask.hide();
      //~ panel.containing_window.window.hideMask();
      //~ panel.el.unmask();
    },
    Lino.show_insert
  );
};

Lino.show_fk_detail = function(combo,detail_action) {
    //~ console.log("Lino.show_fk_detail",combo,handler);
    pk = combo.getValue();
    if (pk) {
        detail_action.run(null,{record_id: pk})
      } else {
        Lino.notify("Cannot show detail for empty foreign key.");
      }
};

Lino.show_insert = function(panel,btn) {
  var bp = panel.get_base_params();
  //~ console.log('20120125 Lino.show_insert',bp)
  //~ panel.ls_insert_handler.run(null,{record_id:-99999,base_params:bp});
  panel.ls_insert_handler.run(panel.getId(),{record_id:-99999,base_params:bp});
};

Lino.show_insert_duplicate = function(panel,btn) {
  Lino.do_on_current_record(panel,
    function(rec) {
      var newRec = {};
      Ext.apply(newRec,rec);
      newRec.id = -99999;
      panel.ls_insert_handler.run(null,{data_record:rec});
    });
};

//~ Lino.update_row_handler = function(action_name) {
  //~ return function(panel,btn) {
    //~ Lino.notify("Sorry, " + action_name + " is not implemented.");
  //~ }
//~ };




if (Ext.ux.grid !== undefined) {
    Lino.GridFilters = Ext.extend(Ext.ux.grid.GridFilters,{
      encode:true,
      local:false
    });
} else {
    Lino.GridFilters = function() {}; // dummy
    Ext.override(Lino.GridFilters,{
      init : function() {}
    });
};



//~ Lino.ButtonField = Ext.extend(Ext.form.TextField,{
//~ Lino.ButtonField = Ext.extend(Ext.form.Field,{
    //~ editable : false,
    //~ constructor : function(ww,config,params){
      //~ this.containing_window = ww;
      //~ if (params) Ext.apply(config,params);
      //~ Lino.ButtonField.superclass.constructor.call(this, config);
    //~ },
    //~ setButtons : function(buttons){
      //~ console.log('setButtons',buttons);
    //~ },
    //~ onRender : function(ct, position){
        //~ if(!this.el){
            //~ this.panel = new Ext.Container({items:[
              //~ {xtype:'button',text:'upload'},
              //~ {xtype:'button',text:'show'},
              //~ {xtype:'button',text:'edit'}
            //~ ]});
            //~ this.panel.ownerCt = this;
            //~ this.el = this.panel.getEl();

        //~ }
        //~ Lino.ButtonField.superclass.onRender.call(this, ct, position);
    //~ },

  
//~ });

Lino.FieldBoxMixin = {
  before_init : function(config,params) {
    if (params) Ext.apply(config,params);
    var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    if (actions) config.bbar = actions.bbar;
  },
  //~ constructor : function(ww,config,params){
    //~ this.containing_window = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  do_when_clean : function(auto_save,todo) { todo() },
  //~ format_data : function(html) { return '<div class="htmlText">' + html + '</div>' },
  format_data : function(html) { return html },
  get_base_params : function() {
    // needed for insert action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
  },
  set_base_params : function(p) {
    this.base_params = Ext.apply({},p);
    //~ if (p.param_values) this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  },
  set_base_param : function(k,v) {
    this.base_params[k] = v;
  }
};



Lino.HtmlBoxPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,{
  disabled_in_insert_window : true,
  constructor : function(config,params) {
    this.before_init(config,params);
    Lino.HtmlBoxPanel.superclass.constructor.call(this, config);
  },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.constructor.call(this, ww,config,params);
  //~ },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  //~ disable : function() { var tb = this.getBottomToolbar(); if(tb) tb.disable()},
  //~ enable : function() { var tb = this.getBottomToolbar(); if(tb) tb.enable()},
  onRender : function(ct, position){
    Lino.HtmlBoxPanel.superclass.onRender.call(this, ct, position);
    //~ console.log(20111125,this.containing_window);
    if (this.containing_panel) {
      this.containing_panel.on('enable',this.enable,this);
      this.containing_panel.on('disable',this.disable,this);
    }
    this.el.on({
      dragenter:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        return true;
      }
      ,dragover:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        event.stopEvent();
        return true;
      }
      ,drop:{
        scope:this
        ,fn:function(event){
          event.stopEvent();
          //~ console.log(20110516);
          var files = event.browserEvent.dataTransfer.files;
          if(files === undefined){
            return true;
          }
          var len = files.length;
          while(--len >= 0){
            console.log(files[len]);
            //~ this.processDragAndDropFileUpload(files[len]);
          }
          Lino.show_insert(this);
        }
      }
    });
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    //~ if (this.master_panel) {
      var record = this.containing_panel.get_current_record();
      //~ console.log('HtmlBox.refresh()',this.title,record,record.title);
      var box = this.items.get(0);
      var todo = function() {
        if (this.disabled) return;
        //~ this.set_base_params(this.containing_window.get_base_params());
        this.set_base_params(this.containing_panel.get_master_params());
        var el = box.getEl();
        if (el) {
          el.update(record ? this.format_data(record.data[this.name]) : '');
          //~ console.log('HtmlBox.refresh()',this.name);
        //~ } else {
          //~ console.log('HtmlBox.refresh() failed for',this.name);
        }
      };
      Lino.do_when_visible(box,todo.createDelegate(this));
    //~ }
  }
});
//~ Ext.override(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);



Lino.RichTextPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,Lino.FieldBoxMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,{
    
  //~ initComponent : function(){
    //~ Lino.RichTextPanel.superclass.initComponent.call(this);
  //~ },
  constructor : function(config,params) {
    //~ console.log('Lino.RichTextPanel.initComponent',this);
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + String(rec.id) + "/" + config.name;
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + config.name;
    var t = this;
    var tinymce_options = {
        theme : "advanced",
        content_css: '/media/lino/extjs/lino.css',
        language: 'de',
        //~ template_external_list_url : url,
        theme_advanced_toolbar_location : "top",
        theme_advanced_toolbar_align : "left",
        theme_advanced_statusbar_location : "bottom",
        template_popup_width : 700,
        template_popup_height : 500,
        template_replace_values : { 
            data_field : function(element){ 
                //~ console.log(20110722,fieldName,t.containing_window.get_current_record()); 
                var fieldName = element.innerHTML;
                element.innerHTML = t.containing_panel.get_current_record().data[fieldName];
            } 
        }
      };
      
    var editorConfig = {
      tinymceSettings: {
        plugins : "noneditable,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "bold,italic,underline,|,justifyleft,justifycenter,justifyright,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,removeformat,template",
        theme_advanced_buttons2 : "",
        theme_advanced_buttons3 : "", // ,|,sub,sup,|,charmap",      
        theme_advanced_resizing : false
        //~ save_onsavecallback : save_callback,
        //~ save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
        
    }};
    Ext.apply(editorConfig.tinymceSettings,tinymce_options);
    //~ editorConfig.name = config.action_name;
    editorConfig.name = config.name;
    delete config.name;
    //~ config.title = config.label;
    //~ delete config.label;
    this.before_init(config,params);
    
    this.editor = new Ext.ux.TinyMCE(editorConfig);
    var t = this;
    config.tools = [{
                      qtip: "Edit text in own window", 
                      id: "up",
                      handler: function(){
                        if(t.editor.isDirty()) {
                            var record = t.containing_panel.get_current_record();
                            record.data[t.editor.name] = t.editor.getValue();
                        }
                        Lino.edit_tinymce_text(t,tinymce_options)
                      }
                    }];
    
    config.items = this.editor;
    config.layout = "fit";
    Lino.RichTextPanel.superclass.constructor.call(this, config);
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    var record = this.containing_panel.get_current_record();
    //~ console.log('RichTextPanel.refresh()',this.title,record.title,record);
    var todo = function() {
      //~ this.set_base_params(this.containing_window.get_base_params());
      if (record) {
        var url = '/templates' + this.containing_panel.ls_url + "/" 
            + String(record.id) + "/" + this.editor.name;
        //~ console.log('RichTextPanel.refresh()',url);
        if (this.editor.ed) this.editor.ed.settings.template_external_list_url = url;
        this.set_base_params(this.containing_panel.get_master_params());
        //~ var v = record ? this.format_data(record.data[this.editor.name]) : ''
        var v = this.format_data(record.data[this.editor.name])
        this.editor.setValue(v);
      } else {
        this.editor.setValue('(no data)');
      }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
//~ Ext.override(Lino.RichTextPanel,Lino.FieldBoxMixin);



Lino.ActionFormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,Lino.PanelMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,Lino.FieldBoxMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  //~ layout:'fit'
  //~ ,autoHeight: true
  //~ ,frame: true
  window_title: "Action Parameters",
  constructor : function(config){
    config.bbar = [
        {text:'OK',handler:this.on_ok,scope:this},
        {text:'Cancel',handler:this.on_cancel,scope:this}
    ];
    //~ config.items = config.params_panel;
    Lino.ActionFormPanel.superclass.constructor.call(this, config);
  }
  //~ ,initComponent : function(){
    //~ Lino.ActionFormPanel.superclass.initComponent.call(this);
  //~ }
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
    //~ var rp = this.requesting_panel;
    //~ console.log("on_ok",this.requesting_panel,arguments);
    //~ Lino.row_action_handler()
    var panel = this.requesting_panel;
    var actionName = this.action_name;
    var rec = panel.get_current_record();
    var self = this;
    function on_success() { self.get_containing_window().close(); };
    var fn = function(panel,btn,step) {
      var p = {};
      self.add_field_values(p)
      Lino.call_ajax_action(panel,'GET',panel.get_record_url(rec.id),p,actionName,step,fn,on_success);
    }
    fn(panel,null,null);
    
    
  }
  ,set_status : function(status,rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 ActionFormPanel.set_status()',status,rp,this.requesting_panel);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_field_values(status.field_values);
    if (status.base_params) this.set_base_params(status.base_params);
  }
  
  ,add_field_values : function (p) { // similar to add_param_values()
      //~ 20121023 
      if (this.form.isDirty()) {
        p.fv = this.get_field_values();
      }else{
        if (this.status_field_values) 
          p.fv = Lino.fields2array(this.fields,this.status_field_values);
      }
      //~ if (!this.form.isDirty()) return;
      //~ p.$ext_requests.URL_PARAM_FIELD_VALUES = this.get_field_values();
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
  }
  ,get_field_values : function() {
      return Lino.fields2array(this.fields);
  }
  ,set_field_values : function(pv) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_field_values = pv;
      if (pv) this.form.my_loadRecord(pv);
      else this.form.reset(); 
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.title = this.window_title;
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok }
      ]
  }
});

Lino.fields2array = function(fields,values) {
    //~ console.log('20120116 gonna loop on', fields);
    var pv = Array(fields.length);
    for(var i=0; i < fields.length;i++) {
        var f = fields[i]
        if (values) 
          var v = values[f.name];
        else 
          var v = f.getValue();
        if (f.formatDate) {
            pv[i] = f.formatDate(v); 
        } else {
            pv[i] = v; // f.getValue(); 
        }
    }
    return pv;
}


Lino.FormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.FormPanel = Ext.extend(Lino.FormPanel,Lino.PanelMixin);
Lino.FormPanel = Ext.extend(Lino.FormPanel,{
  params_panel_hidden : false,
  //~ base_params : {},
  //~ trackResetOnLoad : true,
  //~ query_params : {},
  //~ 20110119b quick_search_text : '',
  constructor : function(config,params){
    if (params) Ext.apply(config,params);
    this.base_params = {};
    //~ ww.config.base_params.query = ''; // 20111018
    //~ console.log(config);
    //~ console.log('FormPanel.constructor() 1',config)
    //~ Ext.applyIf(config,{base_params:{}});
    //~ console.log('FormPanel.constructor() 2',config)
      
    config.trackResetOnLoad = true;
    
    Lino.FormPanel.superclass.constructor.call(this, config);
      
    //~ this.set_base_param('$URL_PARAM_FILTER',null); // 20111018
    //~ this.set_base_param('$URL_PARAM_FILTER',''); // 20111018
      
  },
  initComponent : function(){
    
    //~ console.log("20111201 containing_window",this.containing_window,this);
    
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    if (actions) {
        this.bbar = actions.bbar;
    //~ } else {
        //~ this.bbar = [];
    }
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ var config = this;
    
    //~ if (this.containing_window instanceof Lino.DetailWrapper) {
    
    //~ console.log('20120121 initComponent', this.action_name);
    //~ if (this.action_name == 'detail' | this.action_name == 'show') {
    //~ if (this.action_name != 'insert') {
    if (! this.hide_top_toolbar) {
      this.tbar = [];
      // 20111015    
      if (! this.hide_navigator) {
        this.record_selector = new Lino.RemoteComboFieldElement({
          store: new Lino.ComplexRemoteComboStore({
            //~ baseParams: this.containing_window.config.base_params,
            baseParams: this.get_base_params(),
            //~ value: this.containing_window.config.base_params.query,
            proxy: new Ext.data.HttpProxy({
              url: '/choices' + this.ls_url,
              method:'GET'
            })
          }),
          pageSize:25,
          listeners: { 
            scope:this, 
            select:function(combo,record,index) {
              //~ console.log('jumpto_select',arguments);
              this.goto_record_id(record.id);
            }
          },
          emptyText: "Gehe zu Datensatz"
        })
        this.tbar = this.tbar.concat([this.record_selector]);
        
        this.tbar = this.tbar.concat([
          this.first = new Ext.Toolbar.Button({
            tooltip:"Erster",disabled:true,handler:this.moveFirst,scope:this,iconCls:'x-tbar-page-first'}),
          this.prev = new Ext.Toolbar.Button({
            tooltip:"Voriger",disabled:true,handler:this.movePrev,scope:this,iconCls:'x-tbar-page-prev'}),
          this.next = new Ext.Toolbar.Button({
            tooltip:"Nächster",disabled:true,handler:this.moveNext,scope:this,iconCls:'x-tbar-page-next'}),
          this.last = new Ext.Toolbar.Button({
            tooltip:"Letzter",disabled:true,handler:this.moveLast,scope:this,iconCls:'x-tbar-page-last'})
        ]);
      }
      this.tbar = this.add_params_panel(this.tbar);
      
      //~ console.log(20101117,this.containing_window.refresh);
      this.tbar = this.tbar.concat([
        {
          //~ text:'Refresh',
          handler:function(){ this.do_when_clean(true,this.refresh.createDelegate(this)) },
          iconCls: 'x-tbar-loading',
          tooltip:"Datensatz neu laden",
          scope:this}
      ]);
          
      if (this.bbar) { // since 20121016
        if (this.tbar) {
            this.tbar = this.tbar.concat(['-']) ;
        } else {
          this.tbar = [];
        }
        this.tbar = this.tbar.concat(this.bbar) ;
        this.bbar = undefined;
      }
    
      this.tbar = this.tbar.concat([
          '->',
          this.displayItem = new Ext.Toolbar.TextItem({})
      ]);
          
    }
    //~ if (this.content_type && this.action_name != 'insert') {
      //~ this.bbar = this.bbar.concat([
        //~ '->',
        //~ { text: "[$_('Help Text Editor')]",
          //~ handler: Lino.help_text_editor,
          //~ qtip: "$_('Edit help texts for fields on this model.')",
          //~ scope: this}
      //~ ])
    //~ }
    //~ this.before_row_edit = config.before_row_edit.createDelegate(this);
      
    //~ if (this.master_panel) {
        //~ this.set_base_params(this.master_panel.get_master_params());
    //~ }
      
    Lino.FormPanel.superclass.initComponent.call(this);
    
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.bwrap,{msg:"Bitte warten..."});
    },this);
    
    
    //~ var this_ = this;
    //~ this.cascade(function(cmp){
      //~ // var active_field = false;
      //~ for (i = 0; i < this_.active_fields.length; i++) {
        //~ if (cmp.name == this_.active_fields[i]) {
            //~ // active_field = true; break;
            //~ cmp.on("change",function() {this_.save()});
        //~ }
      //~ };
      //~ if (active_field) {
      // if (cmp instanceof Lino.GridPanel) {
          //~ cmp.on("change",function() {this_.save()});
      //~ }
    //~ });
    
    if (this.action_name == 'insert') {
      this.cascade(function(cmp){
        // console.log('20110613 cascade',cmp);
        if (cmp.disabled_in_insert_window) {
            //~ cmp.disable();
            cmp.hide();
        }
      });
      
    }
    
  },
  
  is_loading : function() { 
    if (this.current_record == null) return true; 
    var loading = false;
    this.cascade(function(cmp){
        if (cmp instanceof Lino.GridPanel && cmp.is_loading()) {
            //~ console.log(cmp.title,'is loading');
            loading = true;
            return false;
        }
      });
    return loading;
    //~ var a = this.findByType(Lino.GridPanel);
    //~ for (i=0;i<a.length;i++) {
        //~ if (a[i].is_loading()) return true;
    //~ }
    //~ return false;
  },
  
  get_status : function(){
      var st = {
        base_params: this.get_base_params(),
        data_record : this.get_current_record()
        }
      var tp = this.items.get(0);
      if (tp instanceof Ext.TabPanel) {
        st.active_tab = tp.getActiveTab();
      }
      st.param_values = this.status_param_values;
      return st;
  },
  set_status : function(status,rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 FormPanel.set_status()',status);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_param_values(status.param_values);
    if (status.base_params) this.set_base_params(status.base_params);
    var tp = this.items.get(0);
    if (tp instanceof Ext.TabPanel) {
      if (status.active_tab) {
        //~ console.log('20111201 active_tab',this.active_tab,this.items.get(0));
        //~ tp.activeTab = status.active_tab;
        tp.setActiveTab(status.active_tab);
        //~ this.main_item.items.get(0).activate(status.active_tab);
      } else {
        tp.setActiveTab(0);
      }
      }
    
    if (status.data_record) {
      //~ console.log('20111201 Lino.FormPanel with data_record',this.data_record.title,this.containing_window);
      //~ this.main_item.on_master_changed.defer(2000,this.main_item,[status.data_record]);
      //~ Lino.do_when_visible(this.main_item,function(){this.on_master_changed(status.data_record)});
      //~ this.main_item.on('afterrender',function(){
      //~   this.main_item.on_master_changed(status.data_record)},this,{single:true});
      /* must defer because because set_window_title() didn't work otherwise */
      this.set_current_record.createDelegate(this,[status.data_record]).defer(100);
      //~ this.set_current_record(this.data_record);
      //~ return;
    } else if (status.record_id != undefined) { 
      /* possible values include 0 and null, 0 being a valid record id, 
      null the equivalent of undefined
      */
      //~ this.main_item.goto_record_id(this.status.record_id);
      this.load_record_id(status.record_id);
    } else {
      this.set_current_record(undefined);
    }
  },
    
  get_base_params : function() {
    // needed for insert_action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
    //~ return this.base_params;
  },
  set_base_params : function(p) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    delete p['query'] // 20120725
    Ext.apply(this.base_params,p);
    if (this.record_selector) {
        var store = this.record_selector.getStore();
        for (k in p) store.setBaseParam(k,p[k]);
        delete this.record_selector.lastQuery;
        //~ console.log("20120725 record_selector.setBaseParam",p)
    }
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
        
      //~ if (this.record_selector) {
          //~ var store = this.record_selector.getStore();
          //~ for (k in store.baseParams) store.setBaseParam(k,undefined);
          //~ delete this.record_selector.lastQuery;
          //~ console.log("20120725 record_selector.getBaseParams() -->",store.baseParams)
      //~ }
  },
  set_base_param : function(k,v) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    this.base_params[k] = v;
    //~ if (this.record_selector) {
        //~ this.record_selector.getStore().setBaseParam(k,v);
        //~ delete this.record_selector.lastQuery;
    //~ }
  },
  
  after_delete : function() {
    if (this.current_record.navinfo.next)
      this.moveNext();
    else if (this.current_record.navinfo.prev)
      this.movePrev();
    else 
      this.abandon();
  },
  moveFirst : function() {this.goto_record_id(this.current_record.navinfo.first)},
  movePrev : function() {this.goto_record_id(this.current_record.navinfo.prev)},
  moveNext : function() {this.goto_record_id(this.current_record.navinfo.next)},
  moveLast : function() {this.goto_record_id(this.current_record.navinfo.last)},
  
  
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ console.log('20120121 Lino.FormPanel.refresh()',this);
    if (this.current_record) {
        this.load_record_id(this.current_record.id,after);
    } else {
        this.set_current_record(undefined,after);
    }
  },
  
  do_when_clean : function(auto_save,todo) {
    var this_ = this;
    if (this.form.isDirty()) {
        if (auto_save) {
            this_.save(todo);
        } else {
          //~ console.log('20111217 do_when_clean() form is dirty',this.form);
          var config = {title:"Bestätigung"};
          config.buttons = Ext.MessageBox.YESNOCANCEL;
          config.msg = "Änderungen in diesem Datensatz speichern?";
          config.fn = function(buttonId,text,opt) {
            //~ console.log('do_when_clean',buttonId)
            if (buttonId == "yes") {
                //~ Lino.submit_detail(this_,undefined,todo);
                //~ this_.containing_window.save(todo);
                this_.save(todo);
            } else if (buttonId == "no") { 
              todo();
            }
          }
        }
        Ext.MessageBox.show(config);
    }else{
      //~ console.log('do_when_clean : now!')
      todo();
    }
  },
  
  goto_record_id : function(record_id) {
    //~ console.log('20110701 Lino.FormPanel.goto_record_id()',record_id);
    //~ var this_ = this;
    //~ this.do_when_clean(function() { this_.load_record_id(record_id) }
    this.do_when_clean(true,this.load_record_id.createDelegate(this,[record_id]));
  },
  
  load_record_id : function(record_id,after) {
    var this_ = this;
    //~ var p = { fmt: this.containing_window.config.action_name};
    //~ var p = Ext.apply({},this.containing_window.config.base_params);
    var p = Ext.apply({},this.get_base_params());
    //~ Lino.insert_subst_user(p);
    //~ console.log('20110713 action_name=',this.containing_window.config.action_name,
      //~ 'base_params=',this.containing_window.config.base_params);
    if (this.action_name)
        p.an = this.action_name;
    //~ p.an = this.action_name;
    //~ p.an = this.containing_window.config.action_name;
    //~ p.fmt = 'json';
    //~ p.fmt = '$ext_requests.URL_FORMAT_JSON';
    p.rp = this.getId();
    //~ p.$ext_requests.URL_PARAM_SUBST_USER = Lino.subst_user;
    p.fmt = 'json';
    //~ 20110119b p['$URL_PARAM_FILTER'] = this.quick_search_text;
    //~ Ext.apply(p,this.query_params);
    this.add_param_values(p);
    //~ console.log('20121120 FormPanel.load_record_id',record_id,p);
    if (this.loadMask) this.loadMask.show();
    Ext.Ajax.request({ 
      waitMsg: 'Loading record...',
      method: 'GET',
      params: p,
      scope: this,
      url: this.get_record_url(record_id),
      success: function(response) {   
        // todo: convert to Lino.action_handler.... but result 
        if (this.loadMask) this.loadMask.hide();
        if (response.responseText) {
          var rec = Ext.decode(response.responseText);
          //~ console.log('20120918 goto_record_id success',rec);
          this.set_param_values(rec.param_values);
          this.set_current_record(rec,after);
        }
      },
      failure: Lino.ajax_error_handler(this)
    });
  },

  abandon : function () {
    Ext.MessageBox.alert('Note',
      "Keine weiteren Datensätze zu sehen. Detail-Fenster wird geschlossen.");
    Lino.close_window();
    //~ if (this.containing_window) {
        //~ this.containing_window.hide();
    //~ }
  },
  
  set_current_record : function(record,after) {
    //~ console.log('20120722 Lino.FormPanel.set_current_record',record.title,record);
    if (this.record_selector) {
        this.record_selector.clearValue();
        // e.g. InsertWrapper FormPanel doesn't have a record_selector
    }
    this.current_record = record;
    //~ if (record) 
        //~ console.log('Lino.FormPanel.set_current_record',record.title,record);
    //~ else
        //~ console.log('Lino.FormPanel.set_current_record',record);
    //~ this.config.main_panel.form.load(record);    
    if (record) {
      this.enable();
      this.form.my_loadRecord(record.data);
      this.set_window_title(record.title);
      //~ this.getBottomToolbar().enable();
      var da = record.data.disabled_actions;
      if (da) {
          //~ console.log('20120528 disabled_actions =',da,this.getBottomToolbar());
          //~ 20121016 this.getBottomToolbar().items.each(function(item,index,length){
          var tb = this.getTopToolbar();
          if (tb) tb.items.each(function(item,index,length){
              //~ console.log('20120528 ',item.itemId,'-->',da[item.itemId]);
              if (da[item.itemId]) item.disable(); else item.enable();
          });
      };
      if (this.disable_editing | record.data.disable_editing) {
          //~ console.log("20120202 disable_editing",record.title);
          this.form.items.each(function(cmp){
            if (!cmp.always_enabled) cmp.disable();
          },this);
      } else {
          this.form.items.each(function(cmp){
            //~ console.log("20120202",cmp);
            if (record.data.disabled_fields[cmp.name]) cmp.disable();
            else cmp.enable();
          },this);
        
          //~ if (record.data.disabled_fields) {
              //~ for (i = 0; i < record.data.disabled_fields.length; i++) {
                  //~ var flds = this.find('name',record.data.disabled_fields[i]);
                  //~ if (flds.length == 1) { 
                    //~ flds[0].disable(); 
                  //~ }
              //~ }
          //~ }
      };
      
      if (record.navinfo && ! this.hide_top_toolbar && ! this.hide_navigator) {
        //~ if (record.navinfo.recno == 0) {
            //~ this.first.setDisabled(true);
            //~ this.prev.setDisabled(true);
            //~ this.next.setDisabled(true);
            //~ this.last.setDisabled(true);
        //~ } else {
            this.first.setDisabled(!record.navinfo.first);
            this.prev.setDisabled(!record.navinfo.prev);
            this.next.setDisabled(!record.navinfo.next);
            this.last.setDisabled(!record.navinfo.last);
        //~ }
        this.displayItem.setText(record.navinfo.message);
      }
    } else {
      if (this.form.rendered) 
        this.form.reset(); /* FileUploadField would fail when resetting a non-rendered form */
      //~ this.disable();
      //~ this.getBottomToolbar().disable();
      this.form.items.each(function(cmp){
        cmp.disable();
      },this);
      this.set_window_title(this.empty_title);
      //~ this.containing_window.window.setTitle(this.empty_title);
      if (!this.hide_navigator) {
        this.first.disable();
        this.prev.disable();
        this.next.disable();
        this.last.disable();
      }
    }
    //~ console.log('20100531 Lino.DetailMixin.on_load_master_record',this.main_form);
    this.before_row_edit(record);
    if (after) after();
  },
  
  before_row_edit : function(record) {},
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.refresh();
  },
  
  get_selected : function() { return [ this.current_record ] },
  get_current_record : function() {  
    //~ console.log(20100714,this.current_record);
    return this.current_record 
  },
  
  get_permalink_url : function() {
      var rec = this.get_current_record();
      if (rec && ! rec.phantom && rec.id != -99998)
          return '/api' + this.ls_url + '/' + rec.id;
      return '/api' + this.ls_url;
    
  },
  get_permalink_params : function() {
    var p = {};
    //~ var p = {an:'detail'};
    if (this.action_name)
        p.an = this.action_name;
    //~ var p = {an:this.action_name};
    var main = this.items.get(0);
    if (main.activeTab) {
      var tab = main.items.indexOf(main.activeTab);
      //~ console.log('main.activeTab',tab,main.activeTab);
      if (tab) p.tab = tab;
    }
    this.add_param_values(p)
    return p;
  },
  
  /* 
  Lino.FormPanel.save() 
  */
  save : function(after,switch_to_detail,action_name) {
    //~ var panel = this;
    //~ console.log('20121120 FormPanel.save');
    this.loadMask.show();
    var rec = this.get_current_record();
    if (this.has_file_upload) this.form.fileUpload = true;
    //~ console.log('FormPanel.save()',rec);
    if (!action_name) action_name = this.action_name;
    if (rec) {
      var p = {};
      Ext.apply(p,this.get_base_params());
      p.rp = this.getId();
      //~ if (this.action_name) 
          //~ p.$ext_requests.URL_PARAM_ACTION_NAME = this.action_name;
      p.an = action_name;
      if (rec.phantom) {
        //~ if (this.action_name != 'insert') 
            //~ console.log("Warning: phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: '/api' + this.ls_url,
          method: 'POST',
          params: p, 
          scope: this,
          success: function(form, action) {
            this.loadMask.hide();
            Lino.notify(action.result.message);
            /***
            Close this window, but update the status of the 
            calling window.
            If the calling window is a detail on the same table,
            then it should skip to the new record. But only then.
            A successful response usually has a data_record,
            except if it is a fileupload form where some mysterious 
            decoding problems (20120209) force us to return a record_id 
            which will lead to an additional GET.
            ***/
            var url = this.ls_url;
            var ww = Lino.calling_window();
            if (ww && ww.window.main_item instanceof Lino.FormPanel 
                   && ww.window.main_item.ls_url == this.ls_url) {
                //~ console.log("20120217 case 1");
                ww.status.record_id = action.result.record_id;
                ww.status.data_record = action.result.data_record;
                Lino.close_window();
            } else if (this.ls_detail_handler && switch_to_detail) {
                //~ console.log("20120217 case 2");
                Lino.kill_current_window();
                this.ls_detail_handler.run(null,{
                    record_id:action.result.record_id,
                    data_record: action.result.data_record,
                    base_params:this.get_base_params()
                });
            } else {
                //~ console.log("20120217 case 3");
                Lino.close_window();
            }
            //~ Lino.close_window(function(ww){
                //~ if (ww.window.main_item instanceof Lino.FormPanel 
                    //~ && ww.window.main_item.ls_url == url) {
                  //~ ww.status.record_id = action.result.record_id,
                  //~ ww.status.data_record = action.result.data_record
                //~ }
            //~ });
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action);
          },
          clientValidation: true
        })
      } else {
        //~ if (this.action_name != 'detail') 
            //~ console.log("Warning: non-phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: '/api' + this.ls_url + '/' + rec.id,
          method: 'PUT',
          //~ headers: { 'HTTP_X_REQUESTED_WITH' : 'XMLHttpRequest'},
          scope: this,
          params: p, 
          success: function(form, action) {
            //~ panel.form.setValues(rec.data);
            //~ 20110701 panel.form.my_loadRecord(rec);
            this.loadMask.hide();
            Lino.notify(action.result.message);
            if (action.result.data_record)
                this.set_current_record(action.result.data_record,after);
            else
                console.log("Warning: no data_record in response to FormPanel.PUT")
            //~ this.refresh_with_after(after);
            //~ if (after) after(); else panel.refresh();
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action)},
          clientValidation: true
        })
      }
    } else Lino.notify("Sorry, no current record.");
  }
  
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
      this.save(null,true);
      //~ var rec = this.get_current_record();
      //~ if (rec && rec.phantom)
          //~ this.do_when_clean(true,function() { Lino.close_window(); });
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok, scope:this }
        ,{ key: Ext.EventObject.ESCAPE, fn: this.on_cancel, scope:this }
      ]
  }
  
  
  /* not used (no longer possible without .dtl files)
  , edit_detail_config : function () {
    var active_tab = {};
    var main = this.items.get(0);
    if (main.getActiveTab !== undefined) {
      var tabitem = main.getActiveTab();
      Ext.apply(active_tab,{$ext_requests.URL_PARAM_TAB : main.items.indexOf(tabitem)});
    }
    var editor = new Ext.form.TextArea();
    var close = function() { win.close(); }
    var _this = this;
    var save = function() { 
      //~ console.log(20110609,arguments); 
      var params = {desc: editor.getValue()};
      Ext.apply(params,active_tab);
      var a = { 
        params: params, 
        method: 'PUT',
        url: ADMIN_URL + '/detail_config' + _this.ls_url,
        failure : Lino.ajax_error_handler(this),
        success: Lino.action_handler( _this, function(result) {
          //~ console.log('detail_config/save success',result);
          win.close();
          document.location = _this.get_permalink();
        })
      };
      //~ console.log('detail_config/save sent',a);
      _this.loadMask.show(); // 20120211
      Ext.Ajax.request(a);
    }
    var save_btn = new Ext.Button({text:'Save',handler:save,disabled:true});
    var win = new Ext.Window({title:'Detail Layout',
      items:editor, layout:'fit',
      width:500,height:500,
      bbar:[{text:'Cancel',handler:close},save_btn]});
    var a = { 
      params:active_tab, 
      method:'GET',
      url:ADMIN_URL+'/detail_config'+_this.ls_url,
      success : function(response) {
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          if (result.success) {
            editor.setValue(result.desc);
            save_btn.enable();
          }
        }
      }
    };
    Ext.Ajax.request(a);
    win.show();
  }
  */
});


Lino.getRowClass = function(record, rowIndex, rowParams, store) {
  if (record.phantom) {
    //~ console.log(20101009,record);
    //~ rowParams.bodyStyle = "color:red;background-color:blue";
    return 'lino-phantom-row';
    }
  //~ console.log('20101009 not a phantom:',record);
  return '';
}

//~ FOO = 0;



Lino.GridStore = Ext.extend(Ext.data.ArrayStore,{ 
  autoLoad: false
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
    if (!options) options = {};
    if (!options.params) options.params = {};
    options.params.fmt = 'json';
    options.params.rp = this.grid_panel.getId();
    Lino.insert_subst_user(options.params); // since 20121016
      
    
    if (this.grid_panel.hide_top_toolbar) {
        //~ console.log("20120206 GridStore.load() toolbar is hidden");
        options.params.start = 0;
        if (this.grid_panel.preview_limit) {
          options.params.limit = this.grid_panel.preview_limit;
        }
    } else {
        var ps = this.grid_panel.calculatePageSize();
        if (!ps) {
            //~ this.gridpanel.on('render',this.load())
          //~ console.log("20120814 GridStore.load() failed to calculate pagesize");
          return false;
            //~ params.$URL_PARAM_LIMIT = 1;
            //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
            //~ return;
        } 
        options.params.limit = ps;
      
        //~ options.params.start = this.grid_panel.getTopToolbar().cursor;
        //~ if (this.grid_panel.getTopToolbar().pageSize !=  ps) {
          //~ console.log("20120206 abort load because toolbar says pagesize",
            //~ this.grid_panel.getTopToolbar().pageSize,
            //~ "while actual pagesize is",ps);
            //~ return;
        //~ }
        
        this.grid_panel.getTopToolbar().pageSize =  ps;
        if (options.params.start == undefined)
            options.params.start = this.grid_panel.getTopToolbar().cursor;
      
    }
      
    this.grid_panel.add_param_values(options.params);
    //~ Lino.insert_subst_user(options.params);
    //~ console.log("20120814 GridStore.load()",options.params,this.baseParams);
    //~ if (FOO > 0) {
        //~ foo.bar = baz;
    //~ } else FOO += 1;
    return Lino.GridStore.superclass.load.call(this,options);
  }
});

    
Lino.GridPanel = Ext.extend(Ext.grid.EditorGridPanel,Lino.MainPanel);
Lino.GridPanel = Ext.extend(Lino.GridPanel,Lino.PanelMixin);
Lino.GridPanel = Ext.extend(Lino.GridPanel,{
  quick_search_text : '',
  is_searching : false,
  disabled_in_insert_window : true,
  clicksToEdit:2,
  enableColLock: false,
  autoHeight: false,
  params_panel_hidden : false,
  preview_limit : undefined, 
  //~ loadMask: true,
  //~ viewConfig: {
          //~ getRowClass: Lino.getRowClass,
          //~ emptyText:"$_('No data to display.')"
        //~ },
  loadMask: {msg:"Bitte warten..."},
  
  constructor : function(config){

    config.plugins = [new Lino.GridFilters()];
    
    
    Lino.GridPanel.superclass.constructor.call(this,config);
    
    //~ if (this.containing_window) {
        //~ console.log("20111206 install refresh");
        //~ this.containing_window.on('show',this.refresh,this);
    //~ }
    
  },
  
  is_loading : function() { 
    //~ return this.store.getCount() > 0; 
    return !this.loadMask.disabled; 
  },
  
  unused_config_containing_window : function(wincfg) { 
      //~ temporarily remove save_grid_config button (see /blog(2012/1107)
      if (wincfg.tools != undefined) 
        wincfg.tools = [
          //~ {handler:this.save_grid_data,
            //~ qtip:"$_("Save Grid Data")",
            //~ scope:this, id:"save_data"}, // 20120814
          {handler:this.save_grid_config,
            qtip:"Tabellenkonfiguration speichern",
            scope:this, id:"save"}
        ].concat(wincfg.tools);
      //~ wincfg.listeners = { show: ... };
  },
  init_containing_window : function(win) { 
    //~ console.log("20111206 install refresh");
    //~ win.on('show',this.refresh,this);
  },
  
  initComponent : function(){
    
    /* 
    Problem 20111206:
    When a GridPanel is the main item of the window, then it doesn't 
    have it's own header but uses the window's header bar.
    We must do this in initComponent because e.g. in beforerender 
    it's already to late: a header element has been created because 
    there was a title.
    But Lino.Window adds itself as `this.containing_window` 
    only after the GridPanel has been initialized.
    Workaround is to generate a line "params.containing_window = true;" 
    in the handler function.
    */ 
    //~ if (this.containing_window) {
    if (this.is_main_window) {
        //~ console.log(20111206, 'delete title',this.title,'from',this);
        //~ delete this.title;
        this.tools = undefined;  
        this.title = undefined;  /* simply deleting it 
          isn't enough because that would only 
          unhide the title defined in some base class. */
    } 
    //~ else console.log(20111206, 'dont delete title',this.title,'from',this);
    
    /* e.g. when slave gridwindow called from a permalink */
    //~ if (this.base_params) Ext.apply(bp,this.base_params);  
    //~ bp['fmt'] = 'json';
    
    //~ function on_proxy_write( proxy, action,data, response,rs,options) {
      //~ console.log('20120814 on_proxy_write',action,data,response)
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
    //~ }
    //~ function on_proxy_load( proxy, transactionObject, callbackOptions ) {
      //~ console.log('on_proxy_load',transactionObject)
    //~ }
    var proxy = new Ext.data.HttpProxy({ 
      // 20120814 
      url: '/api' + this.ls_url
      ,method: "GET"
      //~ ,url: ADMIN_URL + '/restful' + this.ls_url
      //~ ,restful: true 
      //~ ,listeners: {load:on_proxy_load} 
      //~ ,listeners: {write:on_proxy_write} 
    });
    //~ config.store = new Ext.data.JsonStore({ 
    //~ this.store = new Ext.data.ArrayStore({ 
    this.store = new Lino.GridStore({ 
      grid_panel: this
      ,listeners: { exception: Lino.on_store_exception }
      ,remoteSort: true
      ,totalProperty: "count"
      ,root: "rows"
      //~ ,id: "id" 
      ,proxy: proxy
      //~ autoLoad: this.containing_window ? true : false
      ,idIndex: this.pk_index
      //~ ,baseParams: bp
      ,fields: this.ls_store_fields
      ,idProperty: this.ls_id_property 
      // 20120814
      //~ ,writer : new Ext.data.JsonWriter({
        //~ writeAllFields: false
        //~ ,listful: true
      //~ })
      //~ ,restful : true
    });
      
    //~ console.log('config.pk_index',config.pk_index,config.store),
    delete this.ls_store_fields;
      
    var this_ = this;
    //~ var grid = this;
    this.store.on('load', function() {
        //~ console.log('20120814 GridStore.on(load)',this_.store);
        //~ var da = this_.store.reader.arrayData.disabled_actions;
        //~ if (da) {
            //~ this.cmenu.cascade(function(item){ 
              //~ console.log(20120531, item.itemId, da[item.itemId]);
              //~ if (da[item.itemId]) item.disable(); else item.enable();
            //~ });
        //~ };
        this_.set_param_values(this_.store.reader.arrayData.param_values);
        //~ this_.set_status(this_.store.reader.arrayData.status);
        //~ 20120918
        if (this_.store.reader.arrayData.no_data_text) {
            //~ this.viewConfig.emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().refresh();
        }
        if (this_.containing_window)
            this_.set_window_title(this_.store.reader.arrayData.title);
            //~ this_.containing_window.setTitle(this_.store.reader.arrayData.title);
        if (!this.is_searching) { // disabled 20121025: quick_search_field may not lose focus
          this.is_searching = false;
          if (this_.selModel.getSelectedCell){
              if (this_.getStore().getCount()) // there may be no data
                  this_.selModel.select(0,0); 
          } else {
              this_.selModel.selectFirstRow();
              this_.getView().focusEl.focus();
          }
        } 
        //~ else console.log("is_searching -> no focussing");
        //~ var t = this.getTopToolbar();
        //~ var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
        //~ this.quick_search_field.focus(); // 20121024
      }, this
    );
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar, this.cmenu = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ this.cmenu = new Ext.menu.Menu({items: config.bbar});
    delete this.ls_bbar_actions
    if (actions) {
        this.cmenu = actions.cmenu;
    }
    
    if (!this.hide_top_toolbar) {  
      var tbar = [ 
        this.quick_search_field = new Ext.form.TextField({ 
          //~ fieldLabel: "Search"
          listeners: { 
            scope:this_
            //~ ,change:this_.search_change
            
            ,render: Lino.quicktip_renderer("Schnellsuche","Hier Text eingeben für Schnellsuche.")
            
            //~ ,keypress: this.search_keypress 
            ,blur: function() { this.is_searching = false}
          }
          ,validator:function(value) { return this_.search_validate(value) }
          //~ ,tooltip: "Enter a quick search text, then press TAB"
          //~ value: text
          //~ scope:this, 
          //~ ,enableKeyEvents: true
          //~ listeners: { keypress: this.search_keypress }, 
          //~ id: "seachString" 
      })];
      tbar = this.add_params_panel(tbar);
      tbar = tbar.concat([
        { scope:this, 
          //~ text: "[csv]", 
          tooltip: "Diese Tabelle in eine .csv-Datei exportieren", 
          iconCls: 'x-tbar-csv',
          handler: function() { 
            //~ 20130116 var p = Ext.apply({},this.get_base_params());
            //~ 20130116 p.fmt = 'csv';
            //~ url += "?" + Ext.urlEncode(p);
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            p.fmt = "csv";
            this.add_param_values(p);
            
            window.open('/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } },
        //~ { scope:this, 
          //~ text: "[html]", 
          //~ handler: function() { 
            //~ var p = this.get_current_grid_config();
            //~ Ext.apply(p,this.get_base_params());
            //~ p.$ext_requests.URL_PARAM_FORMAT = "$ext_requests.URL_FORMAT_PRINTER";
            //~ this.add_param_values(p);
            //~ window.open(ADMIN_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          //~ } },
        { scope:this, 
          //~ text: "[html]", 
          tooltip: "Tabelle als HTML anzeigen", 
          iconCls: 'x-tbar-html',
          handler: function() { 
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            //~ since 20121226 p.$ext_requests.URL_PARAM_FORMAT = "$ext_requests.URL_FORMAT_PLAIN";
            this.add_param_values(p);
            //~ since 20121226 window.open(ADMIN_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
            window.open('/plain'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } },
        { scope:this, 
          //~ text: "[pdf]", 
          tooltip: "Diese Tabelle in eine .pdf-Datei exportieren", 
          iconCls: 'x-tbar-pdf',
          handler: function() { 
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            p.fmt = "pdf";
            this.add_param_values(p);
            window.open('/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } }
      ]);
    
    
      var menu = [];
      var set_gc = function(index) {
        return function() {
          //~ console.log('set_gc() 20100812');
          this.getColumnModel().setConfig(
              this.apply_grid_config(index,this.ls_grid_configs,this.ls_columns));
        }
      }
      for (var i = 0; i < this.ls_grid_configs.length;i++) {
        var gc = this.ls_grid_configs[i];
        menu.push({text:gc.label,handler:set_gc(i),scope:this})
      }
      if(menu.length > 1) {
        tbar = tbar.concat([
          { text:"Ansicht",
            menu: menu,
            tooltip:"Andere Ansicht auswählen"
          }
        ]);
      }
      
      if (actions) {
        tbar = tbar.concat(actions.bbar);
          //~ this.bbar = actions.bbar;
      }
      
      this.tbar = new Ext.PagingToolbar({ 
        store: this.store, 
        prependButtons: true, 
        //~ pageSize: this.page_length, 
        pageSize: 1, 
        displayInfo: true, 
        beforePageText: "Seite",
        afterPageText: "von {0}",
        displayMsg: "Zeilen {0} bis {1} von {2}",
        firstText: "Erste Seite",
        lastText: "Letzte Seite",
        prevText: "Vorige Seite",
        nextText: "Nächste Seite",
        items: tbar
      });
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ var ps = this.calculatePageSize();
          //~ if (ps && ps != this.getTopToolbar().pageSize) {
              //~ // console.log('20120203 resize : pageSize',this.getTopToolbar().pageSize,'->',ps);
              //~ // this.getTopToolbar().pageSize =  ps;
              //~ cmp.refresh();
              //~ // this.getTopToolbar().doRefresh();
          //~ }
        //~ }, this);
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ cmp.getTopToolbar().pageSize = this.calculatePageSize(aw,ah,rw,rh) || 10;
          //~ cmp.refresh();
        //~ }, this, {delay:500});
    }
    
    //~ delete this.page_length
    
    
      
    if (this.ls_quick_edit) {
      this.selModel = new Ext.grid.CellSelectionModel()
      this.get_selected = function() {
        //~ console.log(this.getSelectionModel().selection);
        if (this.selModel.selection)
            return [ this.selModel.selection.record ];
        return [this.store.getAt(0)];
      };
      this.get_current_record = function() { 
        if (this.getSelectionModel().selection) 
          return this.selModel.selection.record;
        return this.store.getAt(0);
      };
    } else { 
      this.selModel = new Ext.grid.RowSelectionModel() 
      this.get_selected = function() {
        var sels = this.selModel.getSelections();
        if (sels.length == 0) sels = [this.store.getAt(0)];
        return sels
        //~ var sels = this.getSelectionModel().getSelections();
        //~ return Ext.pluck(sels,'id');
      };
      this.get_current_record = function() { 
        var rec = this.selModel.getSelected();
        if (rec == undefined) rec = this.store.getAt(0);
        return rec
      };
    };
    delete this.ls_quick_edit;
    
    this.columns  = this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns);
    
    //~ var grid = this;
    //~ this.colModel = new Ext.grid.ColumnModel({
      //~ columns: this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns),
      //~ isCellEditable: function(col, row) {
        //~ var record = grid.store.getAt(row);
        //~ console.log('20120514',col,record); // dataIndex
        //~ var dataIndex = grid.colModel.getDataIndex(col);
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("$_("This field is disabled")");
            //~ return false;
        //~ }
        //~ return Ext.grid.ColumnModel.prototype.isCellEditable.call(this, col, row);
      //~ }
    //~ });    
    
    
    Lino.GridPanel.superclass.initComponent.call(this);
    
    //~ if (this.containing_window) 
        //~ this.on('afterlayout', this.refresh, this);
        //~ this.on('afterrender', this.refresh,this);
    //~ else
        //~ this.on('show', this.refresh,this);
    //~ this.on('afterlayout', function() {
      //~ if (this.id == "ext-comp-1157") 
        //~ console.log("20120213 afterlayout",this); 
      //~ // this.refresh();
      //~ },this);
    //~ this.on('afterrender', this.refresh);
    //~ this.on('resize', this.refresh,this,{delay:500});
    //~ this.on('resize', function(){console.log("20120213 resize",arguments)},this);
    this.on('resize', function(){
      //~ console.log("20120213 resize",arguments)
      this.refresh();
      },this);
    this.on('viewready', function(){
      //~ console.log("20120213 resize",arguments);
      this.view_is_ready = true;
      this.refresh();
      },this);
    this.on('afteredit', this.on_afteredit); // 20120814
    //~ this.on('afteredit', this.new_on_afteredit);
    this.on('beforeedit', this.on_beforeedit);
    this.on('beforeedit',function(e) { this.before_row_edit(e.record)},this);
    this.on('cellcontextmenu', Lino.cell_context_menu, this);
    //~ this.on('contextmenu', Lino.grid_context_menu, this);
    
    
    //~ if (this.id == "ext-comp-1157") captureEvents(this);    
    
  },
  
  //~ onResize : function(){
      //~ console.log("20120206 GridPanel.onResize",arguments);
      //~ Lino.GridPanel.superclass.onResize.apply(this, arguments);
      //~ this.refresh();
  //~ },
  
  
  get_status : function(){
    var st = { base_params : this.get_base_params()};
    if (!this.hide_top_toolbar) {
        st.current_page = this.getTopToolbar().current;
    }
    st.param_values = this.status_param_values;
    //~ console.log("20120213 GridPanel.get_status",st);
    return st;
  },
  
  /* 
  Lino.GridPanel.set_status() 
  */
  set_status : function(status){
    //~ console.log("20120918 GridPanel.set_status",status);
    this.clear_base_params();
    if (status == undefined) status = {};
    this.set_param_values(status.param_values);
    if (status.base_params) { 
      this.set_base_params(status.base_params);
    }
    if (!this.hide_top_toolbar) {
      //~ console.log("20120213 GridPanel.getTopToolbar().changePage",
          //~ status.current_page || 1);
      this.getTopToolbar().changePage(status.current_page || 1);
    }
    //~ this.fireEvent('resize');
    //~ this.refresh.defer(100,this); 
    //~ this.onResize.defer(100,this); 
    //~ this.refresh(); 
    //~ this.doLayout(); 
    //~ this.onResize(); 
    //~ this.store.load();
  },
  
  refresh : function(unused) { 
    this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ Lino.notify('20120204 Lino.GridPanel.refresh');
    //~ Lino.notify('Lino.GridPanel.refresh '+this.store.proxy.url);
    //~ var bp = { fmt:'json' }
    if (this.containing_panel) {
        //~ Ext.apply(p,this.master_panel.get_master_params());
        //~ Ext.apply(options.params,this.containing_panel.get_master_params());
        this.set_base_params(this.containing_panel.get_master_params());
    }
    
    if (! this.view_is_ready) return;
    
    var options = {};
    if (after) {
        options.callback = function(r,options,success) {if(success) after()}
    }
      
    //~ if (!this.rendered) {
        //~ console.log("20120206 GridPanel.refresh() must wait until rendered",options);
        //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
        //~ return;
    //~ }
    
    this.store.load(options);
  },
  
  /* pageSize depends on grid height (Trying to remove scrollbar)
  Thanks to 
  - Christophe Badoit on http://www.sencha.com/forum/showthread.php?82647
  - http://www.sencha.com/forum/archive/index.php/t-37231.html
  */
  calculatePageSize : function(second_attempt) {
    //~ if (!this.rendered) { 
    if (!this.view_is_ready) { 
      //~ console.log('Cannot calculatePageSize() : not rendered');
      return false; }
    //~ if (!this.isVisible()) { 
      //~ console.log('calculatePageSize : not visible');
      //~ return false; }
      
    //~ console.log('getFrameHeight() is',this.getFrameHeight());
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('mainBody.getHeight() is',this.getView().mainBody.getHeight());
    //~ console.log('getInnerHeight() is',this.getInnerHeight());
    //~ console.log('getHeight() is',this.getHeight());
    //~ console.log('el.getHeight() is',this.getEl().getHeight());
    //~ console.log('getGridEl().getHeight() is',this.getGridEl().getHeight());
    //~ console.log('getOuterSize().height is',this.getOuterSize().height);
    //~ console.log('getBox().height is',this.getBox().height);
    //~ console.log('getResizeEl.getHeight() is',this.getResizeEl().getHeight());
    //~ console.log('getLayoutTarget().getHeight() is',this.getLayoutTarget().getHeight());
      
    var rowHeight = this.getFrameHeight();
    //~ var rowHeight = 52; // experimental value
    var row = this.view.getRow(0);
    if (row) {
      //~ console.log('20120213 yes');
      rowHeight = Ext.get(row).getHeight();
    }
    //~ console.log('rowHeight is ',rowHeight,this,caller);
    //~ this.getView().syncScroll();
    //~ this.getView().initTemplates();
    var height = this.getView().scroller.getHeight();
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('getInnerHeight() - getFrameHeight() is',
      //~ this.getInnerHeight(), '-',
      //~ this.getFrameHeight(), '=',
      //~ this.getInnerHeight() - this.getFrameHeight());
    //~ var height = this.getView().mainBody.getHeight();
    //~ var height = this.getView().mainWrap.getHeight();
    //~ var height = this.getView().resizeMarker.getHeight();
    //~ this.syncSize();
    //~ var height = this.getInnerHeight() - this.getFrameHeight();
    //~ var height = this.getHeight() - this.getFrameHeight();
    height -= Ext.getScrollBarWidth(); // leave room for a possible horizontal scrollbar... 
    //~ height -= this.getView().scrollOffset;
    var ps = Math.floor(height / rowHeight);
    //~ console.log('20120203 calculatePageSize():',height,'/',rowHeight,'->',ps);
    ps -= 1; // leave room for a possible phantom row
    //~ return (ps > 1 ? ps : false);
    if (ps > 1) return ps;
    //~ console.log('calculatePageSize() found less than 1 row:',height,'/',rowHeight,'->',ps);
    //~ foo.bar = baz; // 20120213
    return 5; // preview_limit
    //~ if (second_attempt) {
        //~ console.log('calculatePageSize() abandons after second attempt:',
          //~ height,'/',rowHeight,'->',ps);
      //~ return 5;
    //~ }
    //~ return this.calculatePageSize.defer(500,this,[true]);
  },
  
  onCellDblClick : function(grid, row, col){
      //~ console.log("20120307 onCellDblClick",this,grid, row, col);
      if (this.ls_detail_handler) {
          //~ Lino.notify('show detail');
          Lino.show_detail(this);
          return false;
      }else{
        //~ console.log('startEditing');
        this.startEditing(row,col);
      }
  },
  
  get_base_params : function() {
    //~ return this.containing_window.config.base_params;
    //~ console.log(20120717,this.store.baseParams);
    var p = Ext.apply({},this.store.baseParams);
    Lino.insert_subst_user(p);
    //~ console.log("20120717 GRidPanel.get_base_params() returns",p);
    return p;
    //~ return this.store.baseParams;
  },
  set_base_params : function(p) {
    //~ console.log('GridPanel.set_base_params',p)
    for (k in p) this.store.setBaseParam(k,p[k]);
    //~ this.store.baseParams = p;
    if (p.query) 
        this.quick_search_field.setValue(p.query);
    //~ if (p.param_values) 
        //~ this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.store.baseParams = {};
      Lino.insert_subst_user(this.store.baseParams);
  },
  set_base_param : function(k,v) {
    this.store.setBaseParam(k,v);
  },
  
  //~ get_permalink_params : function() {
    //~ var p = {};
    //~ return p;
  //~ },
  
  before_row_edit : function(record) {},
    
  //~ search_keypress : function(){
    //~ console.log("2012124 search_keypress",arguments);
  //~ },
  search_validate : function(value) {
    if (value == this.quick_search_text) return true;
    this.is_searching = true;
    //~ console.log('search_validate',value)
    this.quick_search_text = value;
    this.set_base_param('query',value); 
    //~ this.getTopToolbar().changePage(1);
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
    return true;
  },
  
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
  },
  
  apply_grid_config : function(index,grid_configs,rpt_columns) {
    //~ var rpt_columns = this.ls_columns;
    var gc = grid_configs[index];    
    //~ console.log('apply_grid_config() 20100812',name,gc);
    this.gc_name = index;
    if (gc == undefined) {
      return rpt_columns;
      //~ config.columns = config.ls_columns;
      //~ return;
    } 
    //~ delete config.ls_filters
    
    //~ console.log(20100805,config.ls_columns);
    var columns = Array(gc.columns.length);
    for (var j = 0; j < rpt_columns.length;j++) {
      var col = rpt_columns[j];
      for (var i = 0; i < gc.columns.length; i++) {
        if (col.dataIndex == gc.ci[i]) {
          col.width = gc.cw[i];
          col.hidden = gc.ch[i];
          columns[i] = col;
          break;
        }
      }
    }
    
    //~ var columns = Array(rpt_columns.length);
    //~ for (var i = 0; i < rpt_columns.length; i++) {
      //~ columns[i] = rpt_columns[gc.columns[i]];
      //~ columns[i].width = gc.widths[i];
    //~ }
    
    //~ if (gc.hidden_cols) {
      //~ for (var i = 0; i < gc.hidden_cols.length; i++) {
        //~ var hc = gc.hidden_cols[i];
        //~ for (var j = 0; j < columns.length;j++) {
          //~ var col = columns[j];
          //~ if (col.dataIndex == hc) {
            //~ col.hidden = true;
            //~ break
          //~ }
        //~ }
      //~ }
    //~ }
    if (gc.filters) {
      //~ console.log(20100811,'config.ls_filters',config.ls_filters);
      //~ console.log(20100811,'config.ls_grid_config.filters',config.ls_grid_config.filters);
      for (var i = 0; i < gc.filters.length; i++) {
        var fv = gc.filters[i];
        for (var j = 0; j < columns.length;j++) {
          var col = columns[j];
          if (col.dataIndex == fv.field) {
            //~ console.log(20100811, f,' == ',fv);
            if (fv.type == 'string') {
              col.filter.value = fv.value;
              //~ if (fv.comparison !== undefined) f.comparison = fv.comparison;
            } else {
              //~ console.log(20100811, fv);
              col.filter.value = {};
              col.filter.value[fv.comparison] = fv.value;
            }
            break;
          }
        };
      }
    }
    
    return columns;
    //~ config.columns = cols;
    //~ delete config.ls_columns
  },
  
  get_current_grid_config : function () {
    var cm = this.getColumnModel();
    var widths = Array(cm.config.length);
    var hiddens = Array(cm.config.length);
    //~ var hiddens = Array(cm.config.length);
    var columns = Array(cm.config.length);
    //~ var columns = Array(cm.config.length);
    //~ var hidden_cols = [];
    //~ var filters = this.filters.getFilterValues();
    var p = this.filters.buildQuery(this.filters.getFilterData())
    for (var i = 0; i < cm.config.length; i++) {
      var col = cm.config[i];
      columns[i] = col.dataIndex;
      //~ hiddens[i] = col.hidden;
      widths[i] = col.width;
      hiddens[i] = col.hidden;
      //~ if (col.hidden) hidden_cols.push(col.dataIndex);
    }
    //~ p['hidden_cols'] = hidden_cols;
    p.cw = widths;
    p.ch = hiddens;
    p.ci = columns;
    //~ p['widths'] = widths;
    //~ p['hiddens'] = hiddens;
    //~ p['columns'] = columns;
    p['name'] = this.gc_name;
    //~ var gc = this.ls_grid_configs[this.gc_name];
    //~ if (gc !== undefined) 
        //~ p['label'] = gc.label
    //~ console.log('20100810 save_grid_config',p);
    return p;
  },
  
  unused_manage_grid_configs : function() {
    var data = [];
    for (k in this.ls_grid_configs) {
      var v = this.ls_grid_configs[k];
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i)
    }
    if (this.ls_grid_configs[this.gc_name] == undefined) {
      var v = this.get_current_grid_config();
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i);
    }
    //~ console.log(20100811, data);
    var main = new Ext.grid.GridPanel({
      store: new Ext.data.ArrayStore({
        idIndex:0,
        fields:['name','columns','hidden_cols','filters'],
        autoDestroy:true,
        data: data}),
      //~ autoHeight:true,
      selModel: new Ext.grid.RowSelectionModel(),
      listeners: { 
        rowdblclick: function(grid,rowIndex,e) {
          console.log('row doubleclicked',grid, rowIndex,e);
        },
        rowclick: function(grid,rowIndex,e) {
          console.log('row clicked',grid, rowIndex,e);
        }
      },
      columns: [ 
        {dataIndex:'name',header:'Name'}, 
        {dataIndex:'columns',header:'columns'}, 
        {dataIndex:'hidden_cols',header:'hidden columns'}, 
        {dataIndex:'filters',header:'filters'} 
      ]
    });
    var win = new Ext.Window({title:'GridConfigs Manager',layout:'fit',items:main,height:200});
    win.show();
  },
  
  unused_edit_grid_config : function(name) {
    gc = this.ls_grid_configs[name];
    var win = new Ext.Window({
      title:'Edit Grid Config',layout:'vbox', 
      //~ layoutConfig:'stretch'
      items:[
        {xtype:'text', value: gc.name},
        {xtype:'text', value: gc.columns},
        {xtype:'text', value: gc.hidden_cols},
        {xtype:'text', value: gc.filters}
      ]
    });
    win.show();
  },
  
  save_grid_config : function () {
    //~ console.log('TODO: save_grid_config',this);
    //~ p.column_widths = Ext.pluck(this.colModel.columns,'width');
    var a = { 
      params:this.get_current_grid_config(), 
      method:'PUT',
      url:'/grid_config' + this.ls_url,
      success: Lino.action_handler(this),
      scope: this,
      failure: Lino.ajax_error_handler(this)
    };
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(a);
    //~ Lino.do_action(this,a);
  },
  
  on_beforeedit : function(e) {
    //~ console.log('20130128 GridPanel.on_beforeedit()',e,e.record.data.disable_editing);
    if(this.disable_editing | e.record.data.disable_editing) {
      e.cancel = true;
      Lino.notify("Dieser Datensatz ist deaktiviert");
      return;
    }
    if(e.record.data.disabled_fields && e.record.data.disabled_fields[e.field]) {
      e.cancel = true;
      Lino.notify("Dieses Feld ist deaktiviert");
      return;
    }
    //~ if (e.record.data.disabled_fields) {
      //~ for (i in e.record.data.disabled_fields) {
        //~ if(e.record.data.disabled_fields[i] == e.field) {
          //~ e.cancel = true;
          //~ Lino.notify(String.format('Field "{0}" is disabled for this record',e.field));
          //~ return
        //~ }
      //~ }
    //~ }
  },
  save_grid_data : function() {
      //~ console.log("20120814 save_grid_data");
      this.getStore().commitChanges();
  },
  new_on_afteredit : function(e) {
      //~ this.getStore().commitChanges();
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
      console.log("20120814 new_on_afteredit",e);
  },
  on_afteredit : function(e) {
    /*
    e.grid - The grid that fired the event
    e.record - The record being edited
    e.field - The field name being edited
    e.value - The value being set
    e.originalValue - The original value for the field, before the edit.
    e.row - The grid row index
    e.column - The grid column index
    */
    var p = {};
    //~ console.log('20101130 modified: ',e.record.modified);
    //~ console.log('20101130 value: ',e.value);
    //~ var p = e.record.getChanges();
    //~ console.log('20101130 getChanges: ',e.record.getChanges());
    //~ this.before_row_edit(e.record);
    for(k in e.record.getChanges()) {
        var v = e.record.get(k);
    //~ for(k in e.record.modified) {
        //~ console.log('20101130',k,'=',v);
        //~ var cm = e.grid.getColumnModel();
        //~ var di = cm.getDataIndex(k);
        var f = e.record.fields.get(k);
        //~ console.log('20101130 f = ',f);
        //~ var v = e.record.get(di);
        if (f.type.type == 'date') {
            p[k] = Ext.util.Format.date(v, f.dateFormat);
        }else{
            p[k] = v;
            var v = e.record.get(k+'Hidden');
            if (v !== undefined) {
              p[k+'Hidden'] = v;
            }
        }
        //~ var i = cm.findColumnIndex(k);
        //~ var r = cm.getRenderer(i);
        //~ var editor = cm.getCellEditor(i,e.row);
        //~ var col = e.grid.getColumnModel().getColumnById(k);
        //~ console.log('20101130 r = ',r(v));
        //~ var f = e.record.fields[k];
        //~ console.log('20101130 f = ',f);
        //~ console.log('20101130 editor = ',editor);
        //~ p[k] = f.getValue();
        //~ p[k] = r(v);
    }
    //~ console.log('20101130 p:',p);
    //~ var cm = e.grid.getColumnModel();
    //~ var di = cm.getDataIndex(e.column);
    //~ var f = e.record.fields.get(di);
    //~ console.log('20101130 f = ',f);
    //~ if (f.type.type == 'date') e.record.set(di,Ext.util.Format.date(e.value, f.dateFormat));
    
    
    //~ var p = e.record.data;
    
    // var p = {};
    //~ p['grid_afteredit_colname'] = e.field;
    //~ p[e.field] = e.value;
    //~ console.log('20100723 GridPanel.on_afteredit()',e);
    // add value used by ForeignKeyStoreField CHOICES_HIDDEN_SUFFIX
    // not sure whether this is still needed:
    p[e.field+'Hidden'] = e.value;
    //~ p.su = Lino.subst_user;
    Lino.insert_subst_user(p);
    // this one is needed so that this field can serve as choice context:
    e.record.data[e.field+'Hidden'] = e.value;
    // p[pk] = e.record.data[pk];
    // console.log("grid_afteredit:",e.field,'=',e.value);
    Ext.apply(p,this.get_base_params()); // needed for POST, ignored for PUT
    //~ Ext.apply(p,this.containing_window.config.base_params);
    //~ 20121109 p['$ext_requests.URL_PARAM_ACTION_NAME'] = 'grid';
    var self = this;
    var req = {
        params:p,
        waitMsg: 'Saving your data...',
        success: Lino.action_handler( this, function(result) {
          //~ if (result.data_record) {
          if (result.refresh_all) {
              var cw = self.get_containing_window();
              if (cw) {
                  cw.main_item.refresh();
              }
              else console.log("20120123 cannot refresh_all",self);
          } else if (result.rows) {
              //~ self.getStore().loadData(result,true);
              var r = self.getStore().reader.readRecords(result);
              if (e.record.phantom) {
                  //~ console.log("20120816 afteredit.success POST",r);
                  self.getStore().insert(e.row,r.records);
              }else{
                  //~ console.log("20120816 afteredit.success PUT",r);
                  self.getStore().doUpdate(r.records[0]);
              }
              self.getStore().rejectChanges(); /* 
              get rid of the red triangles without saving the record again
              */
              //~ self.getStore().commitChanges(); // get rid of the red triangles
          } else {
              self.getStore().commitChanges(); // get rid of the red triangles
              self.getStore().reload();        // reload our datastore.
          }
          }),
        scope: this,
        failure: Lino.ajax_error_handler(this)
    };
    if (e.record.phantom) {
      req.params.an = 'post'; // SubmitInsert.action_name
      Ext.apply(req,{
        method: 'POST',
        url: '/api' + this.ls_url
      });
    } else {
      req.params.an = 'put'; // SubmitDetail.action_name
      Ext.apply(req,{
        method: 'PUT',
        url: '/api' + this.ls_url + '/' + e.record.id
      });
    }
    //~ console.log('20110406 on_afteredit',req);
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(req);
  },

  afterRender : function() {
    Lino.GridPanel.superclass.afterRender.call(this);
    // this.getView().mainBody.focus();
    // console.log(20100114,this.getView().getRows());
    // if (this.getView().getRows().length > 0) {
    //  this.getView().focusRow(1);
    // }
    //~ this.my_load_mask = new Ext.LoadMask(this.getEl(), {
        //~ msg:'$_("Please wait...")',
        //~ store:this.store});
      
    var tbar = this.getTopToolbar();
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    // tbar.on('change',function() {this.getSelectionModel().selectFirstRow();this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    this.nav = new Ext.KeyNav(this.getEl(),{
      pageUp: function() {tbar.movePrevious(); },
      pageDown: function() {tbar.moveNext(); },
      home: function() {tbar.moveFirst(); },
      end: function() {tbar.moveLast(); },
      scope: this
    });
  },
  after_delete : function() {
    //~ console.log('Lino.GridPanel.after_delete');
    this.refresh();
  },
  add_row_listener : function(fn,scope) {
    this.getSelectionModel().addListener('rowselect',fn,scope);
  },
  postEditValue : function(value, originalValue, r, field){
    value = Lino.GridPanel.superclass.postEditValue.call(this,value,originalValue,r,field);
    //~ console.log('GridPanel.postEdit()',value, originalValue, r, field);
    return value;
  },
  
  set_start_value : function(v) {
      this.start_value = v;
  },
  preEditValue : function(r, field){
      if (this.start_value) {
        var v = this.start_value;
        delete this.start_value;
        this.activeEditor.selectOnFocus = false;
        return v;
      }
      var value = r.data[field];
      return this.autoEncode && Ext.isString(value) ? Ext.util.Format.htmlDecode(value) : value;
  },
  
  on_master_changed : function() {
    //~ if (! this.enabled) return;
    //~ cmp = this;
    //~ console.log('Lino.GridPanel.on_master_changed()',this.title);
    if (! this.rendered) return; // 20120213
    var todo = function() {
      if (this.disabled) return;
      //~ if (this.disabled) return;
      //~ if (this.enabled) {
          //~ var src = caller.config.url_data + "/" + record.id + ".jpg"
          //~ console.log(20111125, this.containing_window);
          //~ for (k in p) this.getStore().setBaseParam(k,p[k]);
          //~ console.log('Lino.GridPanel.on_master_changed()',this.title,p);
          this.refresh();
          //~ this.set_base_params(this.master_panel.get_master_params());
          //~ this.getStore().load(); 
      //~ }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
  

//~ Lino.MainPanelMixin = {
  //~ tbar_items : function() {
      //~ return ;
  //~ }
//~ };

//~ Ext.override(Lino.GridPanel,Lino.MainPanelMixin);
//~ Ext.override(Lino.FormPanel,Lino.MainPanelMixin);

//~ Lino.grid_context_menu = function(e) {
  //~ console.log('contextmenu',arguments);
//~ }

Lino.cell_context_menu = function(grid,row,col,e) {
  //~ console.log('20120531 cellcontextmenu',grid,row,col,e,grid.store.reader.arrayData.rows[row]);
  e.stopEvent();
  //~ grid.getView().focusCell(row,col);
  grid.getSelectionModel().select(row,col);
  //~ console.log(grid.store.getAt(row));
  //~ grid.getView().focusRow(row);
  //~ return;
  if(!grid.cmenu.el){grid.cmenu.render(); }
  //~ if(e.record.data.disabled_fields) {
  
  var da = grid.store.reader.arrayData.rows[row][grid.disabled_actions_index];
  if (da) {
      this.cmenu.cascade(function(item){ 
        //~ console.log(20120531, item.itemId, da[item.itemId]);
        if (da[item.itemId]) item.disable(); else item.enable();
      });
  };
  
  var xy = e.getXY();
  xy[1] -= grid.cmenu.el.getHeight();
  grid.cmenu.showAt(xy);
}


//~ Lino.load_main_menu = function() {
  //~ Ext.Ajax.request({
    //~ waitMsg: 'Loading main menu...',
    //~ method: 'GET',
    //~ url: '/menu',
    //~ success: Lino.on_load_menu,
    //~ failure: Lino.ajax_error_handler
  //~ });
//~ };



//~ Lino.SlavePlugin = function(caller) {
  //~ this.caller = caller;
//~ };

Lino.chooser_handler = function(combo,name) {
  return function(cmp,newValue,oldValue) {
    //~ console.log('Lino.chooser_handler()',cmp,oldValue,newValue);
    combo.setContextValue(name,newValue);
  }
};



Lino.ComboBox = Ext.extend(Ext.form.ComboBox,{
  forceSelection: true,
  triggerAction: 'all',
  minListWidth:230,
  autoSelect: false,
  selectOnFocus: true, // select any existing text in the field immediately on focus.
  submitValue: true,
  displayField: 'text', // 'text', 
  valueField: 'value', // 'value',
  
  //~ initComponent : Ext.form.ComboBox.prototype.initComponent.createSequence(function() {
  initComponent : function(){
      this.contextParams = {};
      //~ Ext.form.ComboBox.initComponent(this);
      Lino.ComboBox.superclass.initComponent.call(this);
  },
  setValue : function(v,record_data){
      /*
      Based on feature request developed in http://extjs.net/forum/showthread.php?t=75751
      */
      /* `record_data` is used to get the text corresponding to this value */
      //~ if(this.name == 'city') 
      //~ console.log('20120203', this.name,'.setValue(', v ,') this=', this,'record_data=',record_data);
      var text = v;
      if(this.valueField){
        if(v == null || v == '') { 
            //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,'no lookup needed, value is empty');
            //~ v = undefined;
            v = '';
            //~ text = '';
        } else if (Ext.isDefined(record_data)) {
          text = record_data[this.name];
          //~ if (this.name == 'birth_country') 
            //~ console.log(this.name,'.setValue',v,'got text ',text,' from record ',record);
        } else {
          // if(this.mode == 'remote' && !Ext.isDefined(this.store.totalLength)){
          if(this.mode == 'remote' && ( this.lastQuery === null || (!Ext.isDefined(this.store.totalLength)))){
              //~ if (this.name == 'birth_country') console.log(this.name,'.setValue',v,'store not yet loaded');
              this.store.on('load', this.setValue.createDelegate(this, arguments), null, {single: true});
              if(this.store.lastOptions === null || this.lastQuery === null){
                  var params;
                  if(this.valueParam){
                      params = {};
                      params[this.valueParam] = v;
                  }else{
                      var q = this.allQuery;
                      this.lastQuery = q;
                      this.store.setBaseParam(this.queryParam, q);
                      params = this.getParams(q);
                  }
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : call load() with params ',params);
                  this.store.load({params: params});
              //~ }else{
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : but store is loading',this.store.lastOptions);
              }
              return;
          //~ }else{
              //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,' : store is loaded, lastQuery is "',this.lastQuery,'"');
          }
          var r = this.findRecord(this.valueField, v);
          if(r){
              text = r.data[this.displayField];
          }else if(this.valueNotFoundText !== undefined){
              text = this.valueNotFoundText;
          }
        }
      }
      this.lastSelectionText = text;
      //~ this.lastSelectionText = v;
      if(this.hiddenField){
          //~ this.hiddenField.originalValue = v;
          this.hiddenField.value = v;
      }
      Ext.form.ComboBox.superclass.setValue.call(this, text);
      this.value = v; // needed for grid.afteredit
  },
  
  getParams : function(q){
    // p = Ext.form.ComboBox.superclass.getParams.call(this, q);
    // causes "Ext.form.ComboBox.superclass.getParams is undefined"
    var p = {};
    //p[this.queryParam] = q;
    if(this.pageSize){
        //~ p.start = 0;
        //~ p.limit = this.pageSize;
        p['start'] = 0;
        p['limit'] = this.pageSize;
    }
    // now my code:
    if(this.contextParams) Ext.apply(p,this.contextParams);
    //~ if(this.contextParams && this.contextValues) {
      //~ for(i = 0; i <= this.contextParams.length; i++)
        //~ p[this.contextParams[i]] = this.contextValues[i];
    //~ }
    return p;
  },
  setContextValue : function(name,value) {
    //~ console.log('setContextValue',this,this.name,':',name,'=',value);
    //~ if (this.contextValues === undefined) {
        //~ this.contextValues = Array(); // this.contextParams.length);
    //~ }
    if (this.contextParams[name] != value) {
      //~ console.log('setContextValue 1',this.contextParams);
      this.contextParams[name] = value;
      this.lastQuery = null;
      //~ console.log('setContextValue 2',this.contextParams);
    }
  }
});

Lino.ChoicesFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'local'
});


Lino.SimpleRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  forceSelection: true,
  constructor: function(config){
      Lino.SimpleRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value' ], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.ComplexRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  constructor: function(config){
      Lino.ComplexRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value','text'], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.RemoteComboFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'remote',
  //~ forceSelection:false,
  minChars: 2, // default 4 is too much
  queryDelay: 300, // default 500 is maybe slow
  queryParam: 'query', 
  //~ typeAhead: true,
  //~ selectOnFocus: true, // select any existing text in the field immediately on focus.
  resizable: true
});

/*
Thanks to Animal for posting the basic idea:
http://www.sencha.com/forum/showthread.php?15842-2.0-SOLVED-Combobox-twintrigger-clear&p=76130&viewfull=1#post76130

*/
Lino.TwinCombo = Ext.extend(Lino.RemoteComboFieldElement,{
    trigger2Class : 'x-form-search-trigger',
    //~ trigger2Class : 'x-tbar-detail',
    initComponent : function() {
        //~ Lino.TwinCombo.superclass.initComponent.call(this);
        Lino.ComboBox.prototype.initComponent.call(this);
        Ext.form.TwinTriggerField.prototype.initComponent.call(this);
    },
    onTrigger2Click : function() {
        //~ console.log('onTrigger2Click',this,arguments);
    }
  });
//~ Lino.TwinCombo.prototype.initComponent = Ext.form.TwinTriggerField.prototype.initComponent;
Lino.TwinCombo.prototype.getTrigger = Ext.form.TwinTriggerField.prototype.getTrigger;
Lino.TwinCombo.prototype.getOuterSize = Ext.form.TwinTriggerField.prototype.getOuterSize;
Lino.TwinCombo.prototype.initTrigger = Ext.form.TwinTriggerField.prototype.initTrigger;
Lino.TwinCombo.prototype.onTrigger1Click = Ext.form.ComboBox.prototype.onTriggerClick;
//~ Lino.TwinCombo.prototype.onTrigger2Click = function() {
    //~ console.log('onTrigger2Click',arguments);
//~ };



Lino.SimpleRemoteComboFieldElement = Ext.extend(Lino.RemoteComboFieldElement,{
  displayField: 'value', 
  valueField: null,
  forceSelection: false
});




Lino.Window = Ext.extend(Ext.Window,{
  //~ layout: "fit", 
  closeAction : 'hide',
  renderTo: 'main_area', 
  constrain: true,
  maximized: true,
  draggable: false,
  width: 700,
  height: 500,
  maximizable: false,
  constructor : function (config) {
    if (config.main_item.params_panel) {
        config.layout = 'border';
        config.main_item.region = 'center';
        config.main_item.params_panel.region = 'north';
        config.main_item.params_panel.hidden = config.main_item.params_panel_hidden;
        config.items = [config.main_item.params_panel, config.main_item];
    } else {
        config.layout = 'fit';
        config.items = config.main_item;
    }
    this.main_item = config.main_item; 
    
    delete config.main_item;
    //~ delete config.params_item;
    
    //~ this.main_item = config.items.get(0);
    this.main_item.containing_window = this;
    
    //~ console.log('20120110 Lino.Window.constructor() 1');
    //~ if (Lino.current_window) { // all windows except the top are closable
    if (this.main_item.hide_window_title) { 
      config.closable = false;
      config.frame = false;
      config.shadow = false;
      //~ config.border = true;
      //~ config.title = undefined;
      //~ config.tools = null;
      delete config.title;
      delete config.tools;
    } else {
      config.title = this.main_item.empty_title;
      config.closable = true;
      config.tools = [ 
        { qtip: 'permalink', handler: Lino.permalink_handler(this), id: "pin" }
      ];
      if (this.main_item.content_type && this.main_item.action_name != 'insert') {
        config.tools = [ {
          handler: Lino.help_text_editor,
          qtip: "Hilfetexte der Eingabefelder dieser Tabelle bearbeiten",
          scope: this.main_item,
          id: "gear"
        }].concat(config.tools);
      }
        
    //~ { qtip: '', handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: this.config.qtip, handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: 'Call doLayout() on main Container.', handler: Lino.refresh_handler(this), id: "refresh" },
    //~ if (this.main_item.params_panel) {
        //~ config.tools = config.tools.concat([ 
          //~ { qtip: 'Show/hide parameter panel', handler: this.toggle_params_panel, id: "gear", scope:this } 
        //~ ]);
    //~ }
    //~ if (config.closable !== false) {
      // if undefined, will take default behaviour
      //~ config.tools = config.tools.concat([ 
        //~ { qtip: 'close', handler: this.hide, id: "close", scope:this } 
      //~ ]);
    }
    
    this.main_item.config_containing_window(config);
    
    //~ console.log('20120110 Lino.Window.constructor() 2');
    Lino.Window.superclass.constructor.call(this,config);
    
    //~ console.log('20120110 Lino.Window.constructor() 3');
    
  },
  initComponent : function() {
    this.main_item.init_containing_window(this);
    Lino.Window.superclass.initComponent.call(this);
  
  },
  hide : function() { 
      this.main_item.do_when_clean(false,function() { 
        Lino.close_window(); });
  },
  hide_really : function() { 
    Lino.Window.superclass.hide.call(this);
  },
  onRender : function(ct, position){
    //~ console.log('20120110 Lino.Window.onRender() 1');
    Lino.Window.superclass.onRender.call(this, ct, position);
    var main_area = Ext.getCmp('main_area')
    //~ console.log('20120110 Lino.Window.onRender() 2');
  
    this.on('show', function(win) {
        //~ console.log('20120110 Lino.Window.on show 1');
        main_area.on('resize', win.onWindowResize, win);
    });
    this.on('hide', function(win) {
        main_area.un('resize', win.onWindowResize, win);
    });
    //~ console.log('20120110 Lino.Window.onRender() 3');
  }
});


Lino.unused_ParamWindow = Ext.extend(Lino.Window,{
  //~ layout: "border", 
  constructor : function (config) {
    Lino.ParamWindow.superclass.constructor.call(this,config);
    this.main_item = config.items; // `items` must be a single component
    config.layout = 'border';
    this.main_item.region = 'center';
    config.params.region = 'north';
    config.items = [config.params, config.items];
    //~ delete config.params;
  }
});




(function(){
    var ns = Ext.ns('Ext.ux.plugins');

    /**
     * @class Ext.ux.plugins.DefaultButton
     * @extends Object
     *
     * Plugin for Button that will click() the button if the user presses ENTER while
     * a component in the button's form has focus.
     *
     * @author Stephen Friedrich
     * @date 09-DEC-2009
     * @version 0.1
     *
     */
    ns.DefaultButton =  Ext.extend(Object, {
        init: function(button) {
            button.on('afterRender', setupKeyListener, button);
        }
    });

    function setupKeyListener() {
        var formPanel = this.findParentByType('form');
        new Ext.KeyMap(formPanel.el, {
            key: Ext.EventObject.ENTER,
            shift: false,
            alt: false,
            fn: function(keyCode, e){
                if(e.target.type === 'textarea' && !e.ctrlKey) {
                    return true;
                }

                this.el.select('button').item(0).dom.click();
                return false;
            },
            scope: this
        });
    }

    Ext.ComponentMgr.registerPlugin('defaultButton', ns.DefaultButton);

})(); 

Ext.override(Ext.form.BasicForm,{
    my_loadRecord : function(values){
    //~ loadRecord : function(record){
        /* Same as ExtJS's loadRecord() (setValues()), except that we 
        forward also the record to field.setValue() so that Lino.Combobox 
        can use it. 
        */
        //~ console.log('20120918 my_loadRecord',values)
        if(Ext.isArray(values)){ 
            for(var i = 0, len = values.length; i < len; i++){
                var v = values[i];
                var f = this.findField(v.id);
                if(f){
                    f.setValue(v.value,values);
                    if(this.trackResetOnLoad){
                        f.originalValue = f.getValue();
                    }
                }
            }
        }else{ 
            var field, id;
            for(id in values){
                if(!Ext.isFunction(values[id]) && (field = this.findField(id))){
                    field.setValue(values[id],values);
                    if(this.trackResetOnLoad){
                        field.originalValue = field.getValue();
                        //~ if (field.hiddenField) {
                          //~ field.hiddenField.originalValue = field.hiddenField.value;
                        //~ }
                    }
                }
            }
        }
        return this;
    }
});




function initializeFooBarDropZone(cmp) {
    //~ console.log('initializeFooBarDropZone',cmp);
    cmp.dropTarget = new Ext.dd.DropTarget(cmp.bwrap, {
      //~ ddGroup     : 'gridDDGroup',
      notifyEnter : function(ddSource, e, data) {
        console.log('notifyEnter',ddSource,e,data);
        //Add some flare to invite drop.
        cmp.body.stopFx();
        cmp.body.highlight();
      },
      notifyDrop  : function(ddSource, e, data){
        console.log('notifyDrop',ddSource,e,data);
        // Reference the record (single selection) for readability
        //~ var selectedRecord = ddSource.dragData.selections[0];


        // Load the record into the form
        //~ formPanel.getForm().my_loadRecord(selectedRecord);


        // Delete record from the grid.  not really required.
        //~ ddSource.grid.store.remove(selectedRecord);

        return(true);
      }
    })
}



Lino.show_mti_child = function(fieldname,detail_handler) {
  //~ console.log('show_mti_child',this);
  //~ console.log('show_mti_child',panel.find("main_area"));
  rec = Lino.current_window.main_item.get_current_record();
  //~ rec = panel.get_current_record();
  if (rec) {
    //~ console.log('show_mti_child',Lino.current_window,rec);
    if (rec.phantom) {
      Lino.notify('Not allowed on phantom record.');
    }else if (rec.data[fieldname]) {
      //~ console.log('show_mti_child',rec.id);
      //~ detail_handler(Lino.current_window.main_item,{},{record_id:rec.id});
      detail_handler.run(null,{record_id:rec.id});
      //~ window.open(urlroot + '/' + rec.id);
      //~ document.location = urlroot + '/' + rec.id;
      //~ window.open(urlroot + '/' + rec.id,'_blank');
    } else {
      Lino.alert("Kann MTI-Kind nicht anzeigen wenn Checkbox abgeschlatet ist.");
    }
  } else {
    Lino.notify('No current record.');
  }
};






/*
Mappings towards lino.modlib.cal.models.PanelCalendars
*/
// Sset SS = Ssite.modules.cal.PanelCalendars.get_handle(Sui).store
Ext.ensible.cal.CalendarMappings = {
    CalendarId:   {name:'ID',       mapping: 'id', type: 'int'},
    Title:        {name:'CalTitle', mapping: 'babel_name', type: 'string'},
    Description:  {name:'Desc',     mapping: 'description', type: 'string'},
    ColorId:      {name:'Color',    mapping: 'color', type: 'int'},
    IsHidden:     {name:'Hidden',   mapping: 'is_hidden', type: 'boolean'},    
};
Ext.ensible.cal.CalendarRecord.reconfigure();  


/*
Mappings towards lino.modlib.cal.models.PanelEvents 
*/
// Sset SS = Ssite.modules.cal.PanelEvents.get_handle(Sui).store
Ext.ensible.cal.EventMappings = {
    EventId:     {name: 'ID',        mapping: 'id', type:'int'},
    CalendarId:  {name: 'CalID',     mapping: 'calendarHidden', type: 'int'},
    Title:       {name: 'EvtTitle',  mapping: 'summary'},
    StartDate:   {name: 'StartDt',   mapping: 'start_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s" },
    EndDate:     {name: 'EndDt',     mapping: 'end_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s"},
    RRule:       {name: 'RecurRule', mapping: 'rsetHidden'},
    Location:    {name: 'Location',  mapping: 'placeHidden'},
    Notes:       {name: 'Desc',      mapping: 'description'},
    Url:         {name: 'LinkUrl',   mapping: 'url'},
    IsAllDay:    {name: 'AllDay',    mapping: 'all_day', type: 'boolean'},
    Reminder:    {name: 'Reminder',  mapping: 'reminder'}
    
};
Ext.ensible.cal.EventRecord.reconfigure();


Lino.on_eventclick = function(cp,rec,el) {
  //~ console.log("Lino.on_eventclick",arguments);
  //~ Lino.cal.Events.detail_action.run({record_id:rec.data.ID});
  Lino.cal.PanelEvents.detail.run(null,{record_id:rec.data.ID,base_params:Lino.eventStore.baseParams});
  return false;
}
    
Lino.on_editdetails = function(cp,rec,el) {
  //~ console.log("Lino.on_editdetails",arguments);
  if (rec.data.ID)
      //~ Lino.cal.Events.detail_action.run({record_id:rec.data.ID});
      Lino.cal.PanelEvents.detail.run(null,{record_id:rec.data.ID,base_params:Lino.eventStore.baseParams});
  return false;
}

Lino.format_time = function(dt) {
    return dt.getHours() + ':' + dt.getMinutes();
}
    
Lino.on_eventdelete = function() {
  //~ console.log("Lino.on_eventdelete",arguments);
};

Lino.on_eventadd  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventadd ",arguments);
  return false;
}
    
Lino.on_eventresize  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventresize ",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    
Lino.on_eventupdate  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventupdate",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    

//~ Lino.eventStore = new Ext.ensible.cal.EventStore({ 
//~ Lino.eventStore = new Ext.data.ArrayStore({ 
Lino.eventStore = new Ext.data.JsonStore({ 
  listeners: { exception: Lino.on_store_exception }
  ,url: '/restful/cal/PanelEvents'
  ,restful : true
  ,proxy: new Ext.data.HttpProxy({ 
      url: '/restful/cal/PanelEvents', 
      disableCaching: false // no need for cache busting when loading via Ajax
      //~ disableCaching:true,
  })
  ,fields: Ext.ensible.cal.EventRecord.prototype.fields.getRange()
  ,totalProperty: "count"
  ,root: "rows"
  ,idProperty: Ext.ensible.cal.EventMappings.EventId.mapping
  ,writer : new Ext.data.JsonWriter({
    writeAllFields: false
  })
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
      if (!options) options = {};
      if (!options.params) options.params = {};
      //~ options.params.$ext_requests.URL_PARAM_TEAM_VIEW = Lino.calendar_app.team_view_button.pressed;
      
      var view = this.cal_panel.getActiveView();
      var bounds = view.getViewBounds();
      //~ var p = {sd:'05.02.2012',ed:'11.02.2012'};
      //~ var p = {};
      options.params[view.dateParamStart] = bounds.start.format(view.dateParamFormat);
      options.params[view.dateParamEnd] = bounds.end.format(view.dateParamFormat);
      Lino.insert_subst_user(options.params);
      //~ Ext.apply(options.params,p)
      //~ console.log('20120710 eventStore.load()',this.baseParams,options);
    
    return Ext.data.JsonStore.prototype.load.call(this,options);
  }
});

//~ Lino.calendarStore = new Ext.data.ArrayStore({ 
Lino.calendarStore = new Ext.data.JsonStore({ 
      listeners: { exception: Lino.on_store_exception }
      ,restful : true
      ,proxy: new Ext.data.HttpProxy({ 
          url: '/restful/cal/PanelCalendars?fmt=json', 
          disableCaching: false // no need for cache busting when loading via Ajax
          //~ restful : true
          //~ method: "GET"
      })
      //~ ,autoLoad: true
      //~ ,remoteSort: true
      //~ ,baseParams: bp
      ,totalProperty: "count"
      ,root: "rows"
      ,fields: Ext.ensible.cal.CalendarRecord.prototype.fields.getRange()
      ,idProperty: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
      //~ ,idIndex: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
    });


Lino.CalendarCfg = {
    dateParamFormat: 'd.m.Y',
    dateParamStart:'sd',
    dateParamEnd:'ed'
};
//~ 20120704 Lino.CalendarPanel = Ext.extend(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
//~ Lino.CalendarPanel = Ext.extend(Lino.CalendarPanel,{
Ext.override(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
Ext.override(Ext.ensible.cal.CalendarPanel,{
  //~ empty_title : "\$ui.get_actor('cal.Panel').report.label",
  empty_title : "Kalender"
  ,activeItem: 1 // 0: day, 1: week
  ,ls_url: '/cal/CalendarPanel'
  //~ ,disableCaching:true
  ,eventStore: Lino.eventStore
  ,calendarStore: Lino.calendarStore
  ,listeners: { 
    editdetails: Lino.on_editdetails
    ,eventclick: Lino.on_eventclick
    //~ ,eventadd: Lino.on_eventadd
    //~ ,eventdelete: Lino.on_eventdelete
    //~ ,eventresize: Lino.on_eventresize
    ,afterrender : function(config) {
      //~ console.log("20120704 afterrender");
      Lino.calendarStore.load();
      //~ console.log("20120704 afterrender calls eventStore.load()",p);
      Lino.eventStore.cal_panel = this;
      //~ Lino.eventStore.load({params:p});
      Lino.eventStore.load();
      //~ Lino.CalendarPanel.superclass.constructor.call(this, config);
      //~ console.log(20120118, config,this);
    }
    }
  ,enableEditDetails: false
  //~ ,monthViewCfg: Lino.CalendarCfg
  //~ ,weekViewCfg: Lino.CalendarCfg
  //~ ,multiDayViewCfg: Lino.CalendarCfg
  //~ ,multiWeekViewCfg: Lino.CalendarCfg
  //~ ,dayViewCfg: Lino.CalendarCfg
  //~ ,initComponent : function() {
    //~ // this.on('eventadd',Lino.on_eventadd);
    //~ Lino.CalendarPanel.superclass.initComponent.call(this);
  //~ }
});




Lino.CalendarAppPanel = Ext.extend(Ext.Panel,Lino.MainPanel);
Lino.CalendarAppPanel = Ext.extend(Lino.CalendarAppPanel,{
  //~ empty_title : "\$ui.get_actor('cal.Panel').report.label",
  empty_title : "Kalender"
  ,ls_url: '/cal/CalendarPanel'
  ,set_status : function(status) { this.refresh();}
  ,refresh : function() {Lino.eventStore.reload();}
  ,layout: 'fit'
  ,is_loading : function() { 
      var loading = Lino.calendarStore.getCount() == 0 | Lino.eventStore.getCount() == 0
      //~ console.log("CalendarPanel loading:",loading);
      return loading; 
  }
  ,get_base_params : function() {
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
  }
  ,set_base_params : function(p) {
    this.base_params = Ext.apply({},p);
  }
  ,clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  }
  ,set_base_param : function(k,v) {
      if (!this.base_params) this.base_params = {};
      this.base_params[k] = v;
  }
});

Lino.calendar_app = function() { return {
  get_main_panel : function() {
      return new Lino.CalendarAppPanel({ items : 
        //~ [{
          //~ id: 'app-header',
          //~ region: 'north',
          //~ height: 35,
          //~ border: false,
          // contentEl: 'app-header-content'
        //~ },
      {
          id: 'app-center',
          title: '...', // will be updated to the current view's date range
          region: 'center',
          layout: 'border',
          listeners: {
              'afterrender': function(){
                  Ext.getCmp('app-center').header.addClass('app-center-header');
              }
          },
          items: [{
              id:'app-west',
              region: 'west',
              width: 176,
              border: false,
              items: [{
                  xtype: 'datepicker',
                  id: 'app-nav-picker',
                  cls: 'ext-cal-nav-picker',
                  listeners: {
                      'select': {
                          fn: function(dp, dt){
                              Lino.calendarPanel.setStartDate(dt);
                          },
                          scope: this
                      }
                  }
              //~ },{ 
                //~ layout:'fit',
                //~ items: [
                  //~ new Ext.form.Checkbox({
                    //~ boxLabel:"$_('Team view')",
                    //~ hideLabel:true
                    //~ listeners: { click: }
                  //~ })
                //~ ]
              },{ 
                layout:'form',
                items: [
                  this.team_view_button = new Ext.Button({
                    text:"Team-Ansicht",
                    enableToggle:true,
                    pressed:false,
                    toggleHandler: function(btn,state) { 
                      //~ console.log('20120716 teamView.toggle()');
                      Lino.eventStore.setBaseParam('tv',state);
                      Lino.eventStore.load();
                      //~ Lino.eventStore.load({params:{$ext_requests.URL_PARAM_TEAM_VIEW:state}});
                      //~ console.log("team view",state);
                    }
                  })
                ]
              },{
                  xtype: 'extensible.calendarlist',
                  store: Lino.calendarStore,
                  border: false,
                  width: 175
              }]
          },{
              xtype: 'extensible.calendarpanel',
              eventStore: Lino.eventStore,
              calendarStore: Lino.calendarStore,
              border: false,
              id:'app-calendar',
              region: 'center',
              //~ activeItem: 3, // month view
              
              // Any generic view options that should be applied to all sub views:
              viewConfig: {
                  // Lino.CalendarCfg
                  dateParamFormat: 'd.m.Y',
                  dateParamStart:'sd',
                  dateParamEnd:'ed',
                
                  //enableFx: false,
                  //ddIncrement: 10, //only applies to DayView and subclasses, but convenient to put it here
                  viewStartHour: 8,
                  viewEndHour: 18
                  //minEventDisplayMinutes: 15
              },
              
              // View options specific to a certain view (if the same options exist in viewConfig
              // they will be overridden by the view-specific config):
              monthViewCfg: {
                  showHeader: true,
                  showWeekLinks: true,
                  showWeekNumbers: true,
                  eventBodyMarkup: ['{Title}',
                    //~ '<tpl if="url">',
                        //~ '<a href="{url}">XX</a>',
                    //~ '</tpl>',
                    '<tpl if="_isReminder">',
                        '<i class="ext-cal-ic ext-cal-ic-rem">&#160;</i>',
                    '</tpl>',
                    '<tpl if="_isRecurring">',
                        '<i class="ext-cal-ic ext-cal-ic-rcr">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanLeft">',
                        '<i class="ext-cal-spl">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanRight">',
                        '<i class="ext-cal-spr">&#160;</i>',
                    '</tpl>'
                ].join('')
              },
              
              multiWeekViewCfg: {
                  //weekCount: 3
              },
              
              // Some optional CalendarPanel configs to experiment with:
              //readOnly: true,
              //showDayView: false,
              //showMultiDayView: true,
              //showWeekView: false,
              //showMultiWeekView: false,
              //showMonthView: false,
              //showNavBar: false,
              //showTodayText: false,
              //showTime: false,
              //editModal: true,
              //enableEditDetails: false,
              //title: 'My Calendar', // the header of the calendar, could be a subtitle for the app
              
              // Once this component inits it will set a reference to itself as an application
              // member property for easy reference in other functions within App.
              initComponent: function() {
                  Lino.calendarPanel = this;
                  this.constructor.prototype.initComponent.apply(this, arguments);
              },
              
              listeners: {
                  //~ 'eventclick': {
                      //~ fn: function(vw, rec, el){
                          //~ this.clearMsg();
                      //~ },
                      //~ scope: this
                  //~ },
                  'eventover': function(vw, rec, el){
                      //console.log('Entered evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]', view='+ vw.id +', el='+el.id);
                  },
                  'eventout': function(vw, rec, el){
                      //console.log('Leaving evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]+', view='+ vw.id +', el='+el.id);
                  },
                  'eventadd': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was added');
                      },
                      scope: this
                  },
                  'eventupdate': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(cp, rec){
                          //this.eventStore.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'eventcancel': {
                      fn: function(cp, rec){
                          // edit canceled
                      },
                      scope: this
                  },
                  'viewchange': {
                      fn: function(p, vw, dateInfo){
                          if(this.editWin){
                              this.editWin.hide();
                          };
                          if(dateInfo !== null){
                              // will be null when switching to the event edit form so ignore
                              Ext.getCmp('app-nav-picker').setValue(dateInfo.activeDate);
                              this.updateTitle(dateInfo.viewStart, dateInfo.viewEnd);
                          }
                      },
                      scope: this
                  },
                  'dayclick': {
                      fn: function(vw, dt, ad, el){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'rangeselect': {
                      fn: function(vw, dates, onComplete){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'eventmove': {
                      fn: function(vw, rec){
                          rec.commit();
                          var time = rec.data[Ext.ensible.cal.EventMappings.IsAllDay.name] ? '' : ' \\a\\t g:i a';
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was moved to '+
                              rec.data[Ext.ensible.cal.EventMappings.StartDate.name].format('F jS'+time));
                      },
                      scope: this
                  },
                  'eventresize': {
                      fn: function(vw, rec){
                          rec.commit();
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(win, rec){
                          Lino.eventStore.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'initdrag': {
                      fn: function(vw){
                          if(this.editWin && this.editWin.isVisible()){
                              this.editWin.hide();
                          }
                      },
                      scope: this
                  }
              }
          }]
        }
        //~ ]
        
      });
      
  }
  ,updateTitle: function(startDt, endDt){
      var p = Ext.getCmp('app-center');
      
      if(startDt.clearTime().getTime() == endDt.clearTime().getTime()){
          p.setTitle(startDt.format('F j, Y'));
      }
      else if(startDt.getFullYear() == endDt.getFullYear()){
          if(startDt.getMonth() == endDt.getMonth()){
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('j, Y'));
          }
          else{
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('F j, Y'));
          }
      }
      else{
          p.setTitle(startDt.format('F j, Y') + ' - ' + endDt.format('F j, Y'));
      }
  }
  // This is an application-specific way to communicate CalendarPanel event messages back to the user.
  // This could be replaced with a function to do "toast" style messages, growl messages, etc. This will
  // vary based on application requirements, which is why it's not baked into the CalendarPanel.
  ,showMsg: function(msg){
      Lino.notify(msg);
      //~ Ext.fly('app-msg').update(msg).removeClass('x-hidden');
  }
  
  ,clearMsg: function(){
      Lino.notify('');
      //~ Ext.fly('app-msg').update('').addClass('x-hidden');
  }
}
}();




/*
captureEvents utility by Aaron Conran
<http://www.sencha.com/learn/grid-faq/>

Ext.onReady(function(){
    var grid = new Ext.grid.GridPanel({
        ... 
    });
    captureEvents(grid);
});
*/
function captureEvents(observable) {
    Ext.util.Observable.capture(
        observable,
        function(eventName) {
            console.info(eventName);
        },
        this
    );		
}
 






Lino.main_menu = [ { "menu": { "items": [ { "text": "Personen", "handler": function() {Lino.contacts.Persons.grid.run(null)} }, { "text": "Organisationen", "handler": function() {Lino.contacts.Companies.grid.run(null)} }, { "text": "Partner", "handler": function() {Lino.contacts.Partners.grid.run(null)} }, { "text": "Haushalte", "handler": function() {Lino.households.Households.grid.run(null)} } ] }, "text": "Kontakte" }, { "menu": { "items": [ { "text": "Produkte", "handler": function() {Lino.products.Products.grid.run(null)} }, { "text": "Produktkategorien", "handler": function() {Lino.products.ProductCats.grid.run(null)} } ] }, "text": "Produkte" }, { "menu": { "items": [ { "text": "Verkaufsrechnungen", "handler": function() {Lino.sales.InvoicesByJournal.grid.run(null,{ "param_values": { "journalHidden": 1, "journal": "Verkaufsrechnungen", "yearHidden": "13", "year": "2013" }, "base_params": { "mt": 32, "mk": 1 } })} } ] }, "text": "Verkauf" }, { "menu": { "items": [ { "text": "Einkaufsrechnungen", "handler": function() {Lino.ledger.InvoicesByJournal.grid.run(null,{ "param_values": { "pjournalHidden": null, "pyear": "2013", "ppartner": null, "ppartnerHidden": null, "pyearHidden": "13", "pjournal": null }, "base_params": { "mt": 32, "mk": 2 } })} } ] }, "text": "Einkauf" }, { "menu": { "items": [ { "text": "Meine Blog-Eintr\u00e4ge", "handler": function() {Lino.blogs.MyEntries.grid.run(null)} } ] }, "text": "Blog" }, { "menu": { "items": [ { "text": "Meine Projects", "handler": function() {Lino.tickets.MyProjects.grid.run(null)} }, { "text": "Meine Tickets", "handler": function() {Lino.tickets.MyOpenTickets.grid.run(null)} }, { "text": "Meine Tickets", "handler": function() {Lino.tickets.MyTickets.grid.run(null)} }, { "text": "Meine Sessions", "handler": function() {Lino.tickets.MySessions.grid.run(null)} }, { "text": "My sessions by date", "handler": function() {Lino.tickets.MySessionsByDate.grid.run(null)} } ] }, "text": "Tickets" }, { "menu": { "items": [ { "text": "Kalender", "iconCls": "x-tbar-calendar", "handler": function() {Lino.cal.CalendarPanel.grid.run(null)} }, { "text": "Termine", "listeners": { "render": Lino.quicktip_renderer("Foo","Alle meine Termine") }, "handler": function() {Lino.cal.MyEvents.grid.run(null)} }, "-", { "text": "Meine Aufgaben", "listeners": { "render": Lino.quicktip_renderer("Foo","Alle meine Aufgaben") }, "handler": function() {Lino.cal.MyTasks.grid.run(null)} }, { "text": "To-Do-Liste", "listeners": { "render": Lino.quicktip_renderer("Foo","Meine zu erledigenden Aufgaben.") }, "handler": function() {Lino.cal.MyTasksToDo.grid.run(null)} }, "-", { "text": "Meine Anwesenheiten", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows all my presences in calendar events, independently of their state.") }, "handler": function() {Lino.cal.MyPresences.grid.run(null)} }, { "text": "Meine erhaltenen Einladungen", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows received invitations which I must accept or reject.") }, "handler": function() {Lino.cal.MyPendingInvitations.grid.run(null)} } ] }, "text": "Kalender" }, { "menu": { "items": [ { "text": "Mein E-Mail-Ausgang", "handler": function() {Lino.outbox.MyOutbox.grid.run(null)} } ] }, "text": "Office" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "Meine Einf\u00fcgetexte", "handler": function() {Lino.ui.MyTextFieldTemplates.grid.run(null)} }, { "text": "Upload-Arten", "handler": function() {Lino.uploads.UploadTypes.grid.run(null)} } ] }, "text": "Office" }, { "menu": { "items": [ { "text": "Site-Parameter", "handler": function() {Lino.ui.SiteConfigs.detail.run(null,{ "record_id": 1 })} }, { "text": "Benutzer", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    Shows the list of all users on this site.\n    \n    A User is somebody who can log into the application.\n    \n    ") }, "handler": function() {Lino.users.Users.grid.run(null)} }, { "text": "Teams", "handler": function() {Lino.users.Teams.grid.run(null)} }, { "text": "Inhaltstypen", "handler": function() {Lino.ui.ContentTypes.grid.run(null)} }, { "text": "Hilfetexte", "handler": function() {Lino.ui.HelpTexts.grid.run(null)} } ] }, "text": "System" }, { "menu": { "items": [ { "text": "L\u00e4nder", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    A country is a geographic entity considered a \"nation\".\n    ") }, "handler": function() {Lino.countries.Countries.grid.run(null)} }, { "text": "Orte", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    The table of known geographical places.\n    A geographical place can be a city, a town, a suburb, \n    a province, a lake... any named geographic entity,\n    except for countries because these have their own table.\n    ") }, "handler": function() {Lino.countries.Cities.grid.run(null)} }, { "text": "Sprachen", "handler": function() {Lino.countries.Languages.grid.run(null)} }, { "text": "Organisationsarten", "handler": function() {Lino.contacts.CompanyTypes.grid.run(null)} }, { "text": "Funktionen", "handler": function() {Lino.contacts.RoleTypes.grid.run(null)} } ] }, "text": "Kontakte" }, { "menu": { "items": [ { "text": "Eigenschaftsgruppen", "handler": function() {Lino.properties.PropGroups.grid.run(null)} }, { "text": "Eigenschafts-Datentypen", "handler": function() {Lino.properties.PropTypes.grid.run(null)} } ] }, "text": "Eigenschaften" }, { "menu": { "items": [ { "text": "Rollen in Haushalt", "handler": function() {Lino.households.Roles.grid.run(null)} }, { "text": "Haushaltsarten", "handler": function() {Lino.households.Types.grid.run(null)} } ] }, "text": "Haushalte" }, { "menu": { "items": [ { "text": "Kontenpl\u00e4ne", "handler": function() {Lino.accounts.Charts.grid.run(null)} }, { "text": "Kontengruppen", "handler": function() {Lino.accounts.Groups.grid.run(null)} }, { "text": "Konten", "handler": function() {Lino.accounts.Accounts.grid.run(null)} }, { "text": "Journals", "handler": function() {Lino.ledger.Journals.grid.run(null)} } ] }, "text": "Buchhaltung" }, { "menu": { "items": [ { "text": "Fakturationsmodi", "handler": function() {Lino.sales.InvoicingModes.grid.run(null)} }, { "text": "Lieferarten", "handler": function() {Lino.sales.ShippingModes.grid.run(null)} }, { "text": "Zahlungsbedingungen", "handler": function() {Lino.sales.PaymentTerms.grid.run(null)} } ] }, "text": "Verkauf" }, { "text": "Blog-Eintrags-Arten", "handler": function() {Lino.blogs.EntryTypes.grid.run(null)} }, { "menu": { "items": [ { "text": "Project Types", "handler": function() {Lino.tickets.ProjectTypes.grid.run(null)} }, { "text": "Session Types", "handler": function() {Lino.tickets.SessionTypes.grid.run(null)} } ] }, "text": "Tickets" }, { "menu": { "items": [ { "text": "Orte", "listeners": { "render": Lino.quicktip_renderer("Foo","List of places where calendar events can happen.") }, "handler": function() {Lino.cal.Places.grid.run(null)} }, { "text": "Priorit\u00e4ten", "listeners": { "render": Lino.quicktip_renderer("Foo","List of possible priorities of calendar events.") }, "handler": function() {Lino.cal.Priorities.grid.run(null)} }, { "text": "Gastrollen", "listeners": { "render": Lino.quicktip_renderer("Foo","The role of a guest expresses what the \n    partner is going to do there.") }, "handler": function() {Lino.cal.GuestRoles.grid.run(null)} }, { "text": "Kalenderliste", "listeners": { "render": Lino.quicktip_renderer("Foo","The list of calendars defined on this system.\n    A calendar is a list of events which have certain things in common,\n    especially they are displayed in the same colour in the calendar panel") }, "handler": function() {Lino.cal.Calendars.grid.run(null)} } ] }, "text": "Kalender" } ] }, "text": "Konfigurierung" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "Einf\u00fcgetexte", "handler": function() {Lino.ui.TextFieldTemplates.grid.run(null)} }, { "text": "Uploads", "handler": function() {Lino.uploads.Uploads.grid.run(null)} }, { "text": "E-Mail-Ausg\u00e4nge", "handler": function() {Lino.outbox.Mails.grid.run(null)} }, { "text": "Anh\u00e4nge", "handler": function() {Lino.outbox.Attachments.grid.run(null)} } ] }, "text": "Office" }, { "menu": { "items": [ { "text": "Vollmachten", "handler": function() {Lino.users.Authorities.grid.run(null)} }, { "text": "User Groups", "handler": function() {Lino.lino.UserGroups.grid.run(null)} }, { "text": "Benutzer-Levels", "handler": function() {Lino.lino.UserLevels.grid.run(null)} }, { "text": "Benutzerprofile", "handler": function() {Lino.lino.UserProfiles.grid.run(null)} } ] }, "text": "System" }, { "text": "Kontaktpersonen", "handler": function() {Lino.contacts.Roles.grid.run(null)} }, { "text": "Mitglieder", "handler": function() {Lino.households.Members.grid.run(null)} }, { "menu": { "items": [ { "text": "AccountTypes", "handler": function() {Lino.accounts.AccountTypes.grid.run(null)} }, { "text": "Rechnungen", "handler": function() {Lino.ledger.Invoices.grid.run(null)} }, { "text": "Vouchers", "handler": function() {Lino.ledger.Vouchers.grid.run(null)} }, { "text": "VoucherTypes", "handler": function() {Lino.ledger.VoucherTypes.grid.run(null)} }, { "text": "Movements", "handler": function() {Lino.ledger.Movements.grid.run(null)} }, { "text": "Gesch\u00e4ftsjahre", "handler": function() {Lino.ledger.FiscalYears.grid.run(null)} } ] }, "text": "Buchhaltung" }, { "menu": { "items": [ { "text": "VatRegimes", "handler": function() {Lino.vat.VatRegimes.grid.run(null)} }, { "text": "TradeTypes", "handler": function() {Lino.vat.TradeTypes.grid.run(null)} }, { "text": "VatClasses", "handler": function() {Lino.vat.VatClasses.grid.run(null)} } ] }, "text": "MWSt." }, { "text": "Blog-Eintr\u00e4ge", "handler": function() {Lino.blogs.Entries.grid.run(null)} }, { "menu": { "items": [ { "text": "Projects", "handler": function() {Lino.tickets.Projects.grid.run(null)} }, { "text": "Tickets", "handler": function() {Lino.tickets.Tickets.grid.run(null)} }, { "text": "Sessions", "handler": function() {Lino.tickets.Sessions.grid.run(null)} }, { "text": "Milestones", "handler": function() {Lino.tickets.Milestones.grid.run(null)} } ] }, "text": "Tickets" }, { "menu": { "items": [ { "text": "Aufgaben", "listeners": { "render": Lino.quicktip_renderer("Foo","A calendar task is something you need to do.\n    ") }, "handler": function() {Lino.cal.Tasks.grid.run(null)} }, { "text": "G\u00e4ste", "listeners": { "render": Lino.quicktip_renderer("Foo","A guest is a partner invited to an event.\n    ") }, "handler": function() {Lino.cal.Guests.grid.run(null)} }, { "text": "Abonnements", "handler": function() {Lino.cal.Subscriptions.grid.run(null)} }, { "text": "Zust\u00e4nde", "listeners": { "render": Lino.quicktip_renderer("Foo","List of the possible states of a calendar event.") }, "handler": function() {Lino.cal.EventStates.grid.run(null)} }, { "text": "Zust\u00e4nde", "handler": function() {Lino.cal.GuestStates.grid.run(null)} }, { "text": "Zust\u00e4nde", "handler": function() {Lino.cal.TaskStates.grid.run(null)} } ] }, "text": "Kalender" } ] }, "text": "Explorer" }, { "menu": { "items": [ { "text": "Info", "listeners": { "render": Lino.quicktip_renderer("Foo","Zeigt Informationen \u00fcber diese Site an.") }, "handler": function() {Lino.about.About.show.run(null,{ "record_id": -99998 })} } ] }, "text": "Site" }, { "text": "Startseite", "handler": function() {Lino.close_all_windows()} } ];
Ext.namespace('Lino.ui.SiteConfigs')
Ext.namespace('Lino.ui.ContentTypes')
Ext.namespace('Lino.ui.HelpTexts')
Ext.namespace('Lino.ui.TextFieldTemplates')
Ext.namespace('Lino.users.Users')
Ext.namespace('Lino.users.MySettings')
Ext.namespace('Lino.users.UsersOverview')
Ext.namespace('Lino.users.Teams')
Ext.namespace('Lino.users.Memberships')
Ext.namespace('Lino.users.Authorities')
Ext.namespace('Lino.countries.Languages')
Ext.namespace('Lino.countries.Countries')
Ext.namespace('Lino.countries.Cities')
Ext.namespace('Lino.properties.PropGroups')
Ext.namespace('Lino.properties.PropTypes')
Ext.namespace('Lino.properties.Properties')
Ext.namespace('Lino.properties.PropChoices')
Ext.namespace('Lino.contacts.CompanyTypes')
Ext.namespace('Lino.contacts.Partners')
Ext.namespace('Lino.contacts.Persons')
Ext.namespace('Lino.contacts.Companies')
Ext.namespace('Lino.contacts.RoleTypes')
Ext.namespace('Lino.contacts.Roles')
Ext.namespace('Lino.households.Types')
Ext.namespace('Lino.households.Households')
Ext.namespace('Lino.households.Roles')
Ext.namespace('Lino.households.Members')
Ext.namespace('Lino.products.ProductCats')
Ext.namespace('Lino.products.Products')
Ext.namespace('Lino.accounts.Charts')
Ext.namespace('Lino.accounts.Groups')
Ext.namespace('Lino.accounts.Accounts')
Ext.namespace('Lino.ledger.Journals')
Ext.namespace('Lino.ledger.Vouchers')
Ext.namespace('Lino.ledger.Movements')
Ext.namespace('Lino.ledger.Invoices')
Ext.namespace('Lino.sales.PaymentTerms')
Ext.namespace('Lino.sales.InvoicingModes')
Ext.namespace('Lino.sales.ShippingModes')
Ext.namespace('Lino.sales.Invoices')
Ext.namespace('Lino.sales.DocumentsToSign')
Ext.namespace('Lino.blogs.EntryTypes')
Ext.namespace('Lino.blogs.Entries')
Ext.namespace('Lino.tickets.ProjectTypes')
Ext.namespace('Lino.tickets.SessionTypes')
Ext.namespace('Lino.tickets.Projects')
Ext.namespace('Lino.tickets.Milestones')
Ext.namespace('Lino.tickets.Tickets')
Ext.namespace('Lino.tickets.UnassignedTickets')
Ext.namespace('Lino.tickets.Sessions')
Ext.namespace('Lino.outbox.Recipients')
Ext.namespace('Lino.outbox.Mails')
Ext.namespace('Lino.outbox.Attachments')
Ext.namespace('Lino.cal.Calendars')
Ext.namespace('Lino.cal.Subscriptions')
Ext.namespace('Lino.cal.Places')
Ext.namespace('Lino.cal.Priorities')
Ext.namespace('Lino.cal.Events')
Ext.namespace('Lino.cal.MyEvents')
Ext.namespace('Lino.cal.MyUnclearEvents')
Ext.namespace('Lino.cal.EventsAssignedToMe')
Ext.namespace('Lino.cal.MyEventsToday')
Ext.namespace('Lino.cal.Tasks')
Ext.namespace('Lino.cal.GuestRoles')
Ext.namespace('Lino.cal.Guests')
Ext.namespace('Lino.cal.PanelCalendars')
Ext.namespace('Lino.cal.PanelEvents')
Ext.namespace('Lino.uploads.UploadTypes')
Ext.namespace('Lino.uploads.Uploads')
Ext.namespace('Lino.sales.SalesRuleTable')
Ext.namespace('Lino.sales.ProductDocItemTable')
Ext.namespace('Lino.sales.InvoiceItemTable')
Ext.namespace('Lino.sessions.SessionTable')
Ext.namespace('Lino.ledger.InvoiceItemTable')
Ext.namespace('Lino.ui.MyTextFieldTemplates')
Ext.namespace('Lino.users.MembershipsByUser')
Ext.namespace('Lino.users.AuthoritiesGiven')
Ext.namespace('Lino.users.AuthoritiesTaken')
Ext.namespace('Lino.countries.CitiesByCity')
Ext.namespace('Lino.countries.CitiesByCountry')
Ext.namespace('Lino.properties.PropsByGroup')
Ext.namespace('Lino.properties.PropsByType')
Ext.namespace('Lino.properties.ChoicesByType')
Ext.namespace('Lino.contacts.PartnersByCity')
Ext.namespace('Lino.contacts.PartnersByCountry')
Ext.namespace('Lino.contacts.RolesByCompany')
Ext.namespace('Lino.contacts.RolesByPerson')
Ext.namespace('Lino.households.HouseholdsByType')
Ext.namespace('Lino.households.MembersByHousehold')
Ext.namespace('Lino.households.MembersByPerson')
Ext.namespace('Lino.households.MembersByRole')
Ext.namespace('Lino.products.ProductsByCategory')
Ext.namespace('Lino.accounts.GroupsByChart')
Ext.namespace('Lino.accounts.AccountsByGroup')
Ext.namespace('Lino.ledger.MovementsByVoucher')
Ext.namespace('Lino.ledger.MovementsByPartner')
Ext.namespace('Lino.ledger.InvoicesByJournal')
Ext.namespace('Lino.ledger.InvoicesByPartner')
Ext.namespace('Lino.ledger.ItemsByInvoice')
Ext.namespace('Lino.sales.InvoicesByJournal')
Ext.namespace('Lino.sales.InvoicesByProject')
Ext.namespace('Lino.sales.ItemsByInvoice')
Ext.namespace('Lino.sales.InvoiceItemsByProduct')
Ext.namespace('Lino.sales.InvoicesByPartner')
Ext.namespace('Lino.blogs.MyEntries')
Ext.namespace('Lino.blogs.EntriesByType')
Ext.namespace('Lino.tickets.ProjectsByProject')
Ext.namespace('Lino.tickets.ProjectsByPartner')
Ext.namespace('Lino.tickets.MilestonesByProject')
Ext.namespace('Lino.tickets.TicketsByProject')
Ext.namespace('Lino.tickets.TicketsByPartner')
Ext.namespace('Lino.tickets.TicketsFixed')
Ext.namespace('Lino.tickets.TicketsReported')
Ext.namespace('Lino.tickets.SessionsByTicket')
Ext.namespace('Lino.tickets.SessionsByProject')
Ext.namespace('Lino.tickets.MySessions')
Ext.namespace('Lino.tickets.MySessionsByDate')
Ext.namespace('Lino.tickets.EntriesByTicket')
Ext.namespace('Lino.tickets.EntriesBySession')
Ext.namespace('Lino.tickets.MyProjects')
Ext.namespace('Lino.tickets.MyTickets')
Ext.namespace('Lino.tickets.MyOpenTickets')
Ext.namespace('Lino.outbox.RecipientsByMail')
Ext.namespace('Lino.outbox.MyOutbox')
Ext.namespace('Lino.outbox.MailsByUser')
Ext.namespace('Lino.outbox.MailsByProject')
Ext.namespace('Lino.outbox.SentByPartner')
Ext.namespace('Lino.outbox.AttachmentsByMail')
Ext.namespace('Lino.cal.SubscriptionsByCalendar')
Ext.namespace('Lino.cal.SubscriptionsByUser')
Ext.namespace('Lino.cal.EventsByCalendar')
Ext.namespace('Lino.cal.EventsByPlace')
Ext.namespace('Lino.cal.EventsByProject')
Ext.namespace('Lino.cal.TasksByUser')
Ext.namespace('Lino.cal.MyTasks')
Ext.namespace('Lino.cal.MyTasksToDo')
Ext.namespace('Lino.cal.TasksByProject')
Ext.namespace('Lino.cal.GuestsByEvent')
Ext.namespace('Lino.cal.GuestsByRole')
Ext.namespace('Lino.cal.GuestsByPartner')
Ext.namespace('Lino.cal.MyPresences')
Ext.namespace('Lino.cal.MyPendingInvitations')
Ext.namespace('Lino.uploads.MyUploads')
Ext.namespace('Lino.uploads.UploadsByController')
Ext.namespace('Lino.cal.TasksByController')
Ext.namespace('Lino.outbox.MailsByController')
Ext.namespace('Lino.ui.HelpTextsByModel')
Ext.namespace('Lino.outbox.AttachmentsByController')
Ext.namespace('Lino.cal.EventsByController')
Ext.namespace('Lino.blogs.EntriesByController')
Ext.namespace('Lino.about.Models')
Ext.namespace('Lino.about.FieldsByModel')
Ext.namespace('Lino.about.Inspector')
Ext.namespace('Lino.about.SourceFiles')
Ext.namespace('Lino.ui.Home')
Ext.namespace('Lino.about.About')
Ext.namespace('Lino.cal.CalendarPanel')
Ext.namespace('Lino.lino.Home')
Ext.namespace('Lino.vat.VatClasses')
Ext.namespace('Lino.vat.TradeTypes')
Ext.namespace('Lino.cal.DurationUnits')
Ext.namespace('Lino.cal.TaskStates')
Ext.namespace('Lino.cal.Weekdays')
Ext.namespace('Lino.ledger.InvoiceStates')
Ext.namespace('Lino.ledger.FiscalYears')
Ext.namespace('Lino.lino.UserLevels')
Ext.namespace('Lino.lino.UserProfiles')
Ext.namespace('Lino.cal.EventStates')
Ext.namespace('Lino.accounts.AccountTypes')
Ext.namespace('Lino.properties.HowWell')
Ext.namespace('Lino.outbox.RecipientType')
Ext.namespace('Lino.countries.CityTypes')
Ext.namespace('Lino.cal.GuestStates')
Ext.namespace('Lino.properties.DoYouLike')
Ext.namespace('Lino.vat.VatRegimes')
Ext.namespace('Lino.ledger.VoucherTypes')
Ext.namespace('Lino.lino.UserGroups')
Ext.namespace('Lino.cal.AccessClasses')
Ext.namespace('Lino.lino.Genders')
Ext.namespace('Lino.sales.InvoiceStates')
Ext.namespace('Lino.tickets.TicketStates')

// ChoiceLists: 
Lino.vat.VatClasses = [ [ "0", "Befreit von MWSt." ], [ "1", "Erm\u00e4\u00dfigter MWSt-Satz" ], [ "2", "Normaler MWSt-Satz" ] ];
Lino.vat.TradeTypes = [ [ "S", "Verkauf" ], [ "P", "Einkauf" ] ];
Lino.cal.DurationUnits = [ [ "s", "Sekunden" ], [ "m", "Minuten" ], [ "h", "Stunden" ], [ "D", "Tage" ], [ "W", "Wochen" ], [ "M", "Monate" ], [ "Y", "Jahre" ] ];
Lino.cal.TaskStates = [ [ "10", "Zu tun" ], [ "20", "Begonnen" ], [ "30", "Erledigt" ], [ "50", "Storniert" ] ];
Lino.cal.Weekdays = [ [ "1", "Montag" ], [ "2", "Dienstag" ], [ "3", "Mittwoch" ], [ "4", "Donnerstag" ], [ "5", "Freitag" ], [ "6", "Samstag" ], [ "7", "Sonntag" ] ];
Lino.ledger.InvoiceStates = [ [ "10", "Draft" ], [ "20", "Registered" ], [ "40", "Bezahlt" ] ];
Lino.ledger.FiscalYears = [ [ "13", "2013" ], [ "14", "2014" ], [ "15", "2015" ], [ "16", "2016" ], [ "17", "2017" ] ];
Lino.lino.UserLevels = [ [ "10", "Gast" ], [ "20", "Sekret\u00e4r" ], [ "30", "Benutzer" ], [ "40", "Manager" ], [ "50", "Administrator" ], [ "90", "Experte" ] ];
Lino.lino.UserProfiles = [ [ "000", "000 (Anonymous)" ], [ "100", "100 (Benutzer)" ], [ "900", "900 (Administrator)" ] ];
Lino.cal.EventStates = [ [ "10", "Vorgeschlagen" ], [ "20", "Draft" ], [ "30", "Mitgeteilt" ], [ "40", "Geplant" ], [ "50", "Stattgefunden" ], [ "60", "Verschoben" ], [ "70", "Storniert" ], [ "80", "Abwesend" ] ];
Lino.accounts.AccountTypes = [ [ "A", "Verm\u00f6gen" ], [ "L", "Verpflichtungen" ], [ "I", "Eink\u00fcnfte" ], [ "E", "Ausgaben" ], [ "C", "Kapital" ], [ "B", "Bankkonten" ] ];
Lino.properties.HowWell = [ [ "0", "gar nicht" ], [ "1", "ein bisschen" ], [ "2", "mittelm\u00e4\u00dfig" ], [ "3", "gut" ], [ "4", "sehr gut" ] ];
Lino.outbox.RecipientType = [ [ "to", "Empf\u00e4nger" ], [ "cc", "Kopie an" ], [ "bcc", "Blindkopie an" ] ];
Lino.countries.CityTypes = [ [ "10", "Bundesland" ], [ "11", "Division" ], [ "12", "Region" ], [ "13", "Gemeinschaft" ], [ "14", "Territorium" ], [ "20", "Regierungsbezirk" ], [ "21", "Provinz" ], [ "22", "Grafschaft" ], [ "23", "Unterregion" ], [ "24", "Departement" ], [ "25", "Arrondissement" ], [ "26", "Pr\u00e4fektur" ], [ "27", "Distrikt" ], [ "28", "Sector" ], [ "50", "Stadt" ], [ "51", "Kleinstadt" ], [ "52", "Gemeinde" ], [ "54", "Pfarre" ], [ "55", "Stadtteil" ], [ "56", "Viertel" ], [ "61", "Ortschaft" ], [ "62", "Kleine Ortschaft" ], [ "70", "Dorf" ] ];
Lino.cal.GuestStates = [ [ "10", "Eingeladen" ], [ "20", "Zugesagt" ], [ "30", "Abgesagt" ], [ "40", "Anwesend" ], [ "50", "Abwesend" ] ];
Lino.properties.DoYouLike = [ [ "0", "blo\u00df nicht" ], [ "1", "eher nicht" ], [ "2", "normal" ], [ "3", "gerne" ], [ "4", "sehr gerne" ] ];
Lino.vat.VatRegimes = [ [ "10", "Privatperson" ], [ "20", "MWSt-pflichtig" ], [ "25", "Vertragspartner" ], [ "30", "Innergemeinschaftlich" ], [ "40", "Au\u00dferhalb EU" ], [ "50", "Befreit von MWSt." ] ];
Lino.ledger.VoucherTypes = [ [ "ledger.AccountInvoice", "Rechnung (lino.modlib.ledger.models.AccountInvoice)" ], [ "sales.Invoice", "Rechnung (lino.modlib.sales.models.Invoice)" ] ];
Lino.lino.UserGroups = [ [ "office", "office (Office)" ], [ "accounting", "accounting (Buchhaltung)" ] ];
Lino.cal.AccessClasses = [ [ "10", "Privat" ], [ "20", "halb \u00f6ffentlich (\"Besch\u00e4ftigt\")" ], [ "30", "\u00d6ffentlich" ] ];
Lino.lino.Genders = [ [ "M", "M\u00e4nnlich" ], [ "F", "Weiblich" ] ];
Lino.sales.InvoiceStates = [ [ "10", "Draft" ], [ "20", "Registered" ], [ "30", "Unterschrieben" ], [ "40", "Versendet" ], [ "50", "Bezahlt" ] ];
Lino.tickets.TicketStates = [ [ "10", "Zugesagt" ], [ "20", "Working" ], [ "30", "Waiting" ], [ "40", "Fixed" ], [ "50", "Tested" ], [ "60", "Closed" ], [ "90", "Storniert" ] ];

Lino.tickets.MySessionsByDate.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  layout: "fit",
  labelWidth: 54,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var today1741 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Datum", "anchor": "-20", "name": "today" });
    this.items = [ { "items": today1741, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ today1741 ];
    Lino.tickets.MySessionsByDate.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Events.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  layout: "fit",
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var dates_from1515 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Datum von","Nur Termine ab diesem Datum.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Datum von</span>", "anchor": "-20", "name": "dates_from" });
    var dates_to1516 = new Lino.DateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","Nur Termine bis zu diesem Datum.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "anchor": "-20", "name": "dates_to" });
    var user1517 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Verantwortlicher</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Verantwortlicher","Nur Termine dieses Benutzers.") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }) });
    var assigned_to1518 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zugewiesen zu</span>", "name": "assigned_to", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Zugewiesen zu","Nur Termine, die diesem Benutzer zugewiesen sind.") }, "selectOnFocus": true, "hiddenName": "assigned_toHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/assigned_to", "method": "GET" }) }) });
    var state1519 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand</span>", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","Nur Termine in diesem Bearbeitungszustand.") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.EventStates });
    var unclear1520 = new Ext.form.Checkbox({ "boxLabel": "Unklare Termine", "hideLabel": true, "checked": false, "name": "unclear", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1521 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": dates_from1515, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": dates_to1516, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1517, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": assigned_to1518, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state1519, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": unclear1520, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    this.items = [ main_1_panel1521 ];
    this.fields = [ dates_from1515, dates_to1516, user1517, assigned_to1518, state1519, unclear1520 ];
    Lino.cal.Events.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.sales.Invoices.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  layout: "hbox",
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 126,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var journal197 = new Lino.TwinCombo({ "fieldLabel": "Journal", "name": "journal", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail)}, "emptyText": "Journal ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "journalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/journal", "method": "GET" }) }) });
    var year198 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Gesch\u00e4ftsjahr", "name": "year", "selectOnFocus": true, "anchor": "-20", "store": Lino.ledger.FiscalYears, "hiddenName": "yearHidden" });
    this.items = [ { "flex": 74, "autoHeight": true, "layout": "form", "xtype": "panel", "items": journal197, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": year198, "labelAlign": "top" } ];
    this.fields = [ journal197, year198 ];
    Lino.sales.Invoices.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Invoices.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  layout: "hbox",
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 126,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var pjournal305 = new Lino.TwinCombo({ "fieldLabel": "Journal", "name": "pjournal", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail)}, "emptyText": "Journal ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "pjournalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/pjournal", "method": "GET" }) }) });
    var pyear306 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Gesch\u00e4ftsjahr", "name": "pyear", "selectOnFocus": true, "anchor": "-20", "store": Lino.ledger.FiscalYears, "hiddenName": "pyearHidden" });
    var ppartner307 = new Lino.TwinCombo({ "fieldLabel": "Partner", "name": "ppartner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Partner ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "ppartnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/ppartner", "method": "GET" }) }) });
    this.items = [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pjournal305, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pyear306, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ppartner307, "labelAlign": "top" } ];
    this.fields = [ pjournal305, pyear306, ppartner307 ];
    Lino.ledger.Invoices.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.TicketsByProject.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  layout: "fit",
  labelWidth: 54,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var today1344 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Datum", "anchor": "-20", "name": "today" });
    this.items = [ { "items": today1344, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ today1344 ];
    Lino.tickets.TicketsByProject.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.about.Inspector.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  layout: "hbox",
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 153,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var inspected1759 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100, "fieldLabel": "Inspected object", "anchor": "-20", "name": "inspected" });
    var show_callables1760 = new Ext.form.Checkbox({ "boxLabel": "show callables", "hideLabel": true, "checked": false, "name": "show_callables", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "flex": 67, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inspected1759, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_callables1760, "labelAlign": "top" } ];
    this.fields = [ inspected1759, show_callables1760 ];
    Lino.about.Inspector.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.wf2_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 387,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'wf2',
  window_title: "Absagen",
  initComponent : function() {
    var containing_panel = this;
    var notify_subject1 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Kurzbeschreibung", "anchor": "-20", "name": "notify_subject" });
    var notify_body2 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Beschreibung", "anchor": "-20 -10", "growMax": 2000, "name": "notify_body" });
    var notify_silent3 = new Ext.form.Checkbox({ "boxLabel": "Keine Benachrichtigung per E-Mail schicken", "hideLabel": true, "checked": false, "name": "notify_silent", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": notify_subject1, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": notify_body2, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": notify_silent3, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ notify_subject1, notify_body2, notify_silent3 ];
    Lino.cal.Guests.wf2_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.Uploads.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 53,
  initComponent : function() {
    var containing_panel = this;
    var file1730 = Lino.file_field_handler(this,{ "fieldLabel": "Datei", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user1731 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel1732 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file1730, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1731, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 54, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type1735 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Upload-Art", "name": "type", "pageSize": 20, "emptyText": "Upload-Art ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var description1736 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Beschreibung", "anchor": "-20", "name": "description" });
    var main_2_panel1737 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1735, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": description1736, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1740 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1732, main_2_panel1737 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1740;
    this.before_row_edit = function(record) {
    }
    Lino.uploads.Uploads.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.GuestRoles.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 58,
  initComponent : function() {
    var containing_panel = this;
    var id1681 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1682 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1683 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_et1684 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (et)", "anchor": "-20", "name": "name_et" });
    var name_en1685 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel1686 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1681, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1682, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1683, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1684, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1685, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var build_method1692 = new Lino.ChoicesFieldElement({ "fieldLabel": "Konstruktionsmethode", "name": "build_method", "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "hiddenName": "build_methodHidden" });
    var template1693 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "fieldLabel": "Vorlage", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestRoles/template", "method": "GET" }) }), "name": "template" });
    var email_template1694 = new Lino.SimpleRemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("E-Mail-Vorlage","The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">E-Mail-Vorlage</span>", "name": "email_template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestRoles/email_template", "method": "GET" }) }) });
    var attach_to_email1695 = new Ext.form.Checkbox({ "boxLabel": "als Anhang per E-Mail", "listeners": { "render": Lino.quicktip_renderer("als Anhang per E-Mail","Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "hideLabel": true, "checked": false, "name": "attach_to_email", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel1696 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 198, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method1692, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template1693, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template1694, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email1695, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_GuestsByRole_grid1710 = new Lino.cal.GuestsByRole.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cal.GuestsByRole.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 71 });
    var main_panel1711 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1686, main_2_panel1696, cal_GuestsByRole_grid1710 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1711;
    this.before_row_edit = function(record) {
      template1693.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      cal_GuestsByRole_grid1710.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method1692.on('change',Lino.chooser_handler(template1693,'build_method'));
      Lino.cal.GuestRoles.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.cal.GuestRoles.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.Milestones.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 50,
  initComponent : function() {
    var containing_panel = this;
    var project1411 = new Lino.TwinCombo({ "fieldLabel": "Projekt", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail)}, "emptyText": "Projekt ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Milestones/project", "method": "GET" }) }) });
    var ref1412 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Referenz", "anchor": "-20", "name": "ref" });
    var main_1_panel1413 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1411, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1412, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var main_panel1416 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "hideCheckBoxLabels": true, "items": [ main_1_panel1413 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1416;
    this.before_row_edit = function(record) {
    }
    Lino.tickets.Milestones.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.sales.Invoices.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 41,
  initComponent : function() {
    var containing_panel = this;
    var partner279 = new Lino.TwinCombo({ "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Partner ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/partner", "method": "GET" }) }), "name": "partner" });
    var date280 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "Datum", "anchor": "-20", "name": "date" });
    var main_1_panel281 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner279, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date280, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var subject284 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Betreff", "anchor": "-20", "name": "subject" });
    var main_panel285 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ main_1_panel281, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject284, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel285;
    this.before_row_edit = function(record) {
    }
    Lino.sales.Invoices.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 19,
  initComponent : function() {
    var containing_panel = this;
    var title896 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Anrede", "anchor": "-20", "name": "title" });
    var first_name897 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Vorname", "anchor": "-20", "name": "first_name" });
    var last_name898 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Familienname", "anchor": "-20", "name": "last_name" });
    var main_1_panel899 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title896, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name897, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name898, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gender903 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.Genders, "hiddenName": "genderHidden" });
    var language904 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "et", "Estnisch" ], [ "en", "Englisch" ] ], "name": "language" });
    var main_2_panel905 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender903, "labelAlign": "top" }, { "flex": 64, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language904, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel908 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel899, main_2_panel905 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel908;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Persons.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.Projects.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 48,
  initComponent : function() {
    var containing_panel = this;
    var ref1291 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Referenz", "anchor": "-20", "name": "ref" });
    var name1292 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var parent1293 = new Lino.TwinCombo({ "fieldLabel": "Parent", "name": "parent", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail)}, "emptyText": "Projekt ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Projects/parent", "method": "GET" }) }) });
    var general_1_panel1294 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1291, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1292, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent1293, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var type1298 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Project Type", "name": "type", "pageSize": 20, "emptyText": "Project Type ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Projects/type", "method": "GET" }) }) });
    var user1299 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Projects/user", "method": "GET" }) }) });
    var general_2_panel1300 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1298, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1299, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description1303 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Beschreibung", "anchor": "-20 -10", "growMax": 2000, "name": "description" });
    var ProjectsByProject_grid1364 = new Lino.tickets.ProjectsByProject.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.tickets.ProjectsByProject.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 66 });
    var general_3_panel1365 = new Ext.Panel({ "flex": 71, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "items": description1303, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 33 }, ProjectsByProject_grid1364 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel1367 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel1294, general_2_panel1300, general_3_panel1365 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var TicketsByProject_grid1368 = new Lino.tickets.TicketsByProject.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.tickets.TicketsByProject.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 50 });
    var SessionsByProject_grid1369 = new Lino.tickets.SessionsByProject.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.tickets.SessionsByProject.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 50 });
    var tickets_1_panel1370 = new Ext.Panel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "layout": "hbox", "title": "Tickets", "hideCheckBoxLabels": true, "items": [ TicketsByProject_grid1368, SessionsByProject_grid1369 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel1371 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1367, tickets_1_panel1370 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1371;
    this.before_row_edit = function(record) {
      ProjectsByProject_grid1364.on_master_changed();
      TicketsByProject_grid1368.on_master_changed();
      SessionsByProject_grid1369.on_master_changed();
    }
    Lino.tickets.Projects.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 19,
  initComponent : function() {
    var containing_panel = this;
    var last_name825 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Familienname", "anchor": "-20", "name": "last_name" });
    var first_name826 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Vorname", "anchor": "-20", "name": "first_name" });
    var name_box_1_panel827 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name825, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name826, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gender830 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.Genders, "hiddenName": "genderHidden" });
    var title831 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Anrede", "anchor": "-20", "name": "title" });
    var birth_date832 = new Lino.IncompleteDateField({ "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Geburtsdatum","Unkomplette Datumsangaben sind erlaubt, z.B. \"00.00.1980\" hei\u00dft \"irgendwann im Jahr 1980\", \"00.07.1980\" hei\u00dft \"im Juli 1980\"oder \"23.07.0000\" hei\u00dft \"an einem 23. Juli\".") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Geburtsdatum</span>", "anchor": "-20", "name": "birth_date" });
    var name_box_2_panel833 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender830, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title831, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date832, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var name_box_panel837 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ name_box_1_panel827, name_box_2_panel833 ], "frame": true, "bodyBorder": false, "anchor": "-20", "labelAlign": "top" });
    var country838 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/country", "method": "GET" }) }) });
    var region839 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/region", "method": "GET" }) }) });
    var city840 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/city", "method": "GET" }) }) });
    var zip_code841 = new Ext.form.TextField({ "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_2_panel842 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country838, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region839, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city840, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code841, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr1847 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile vor Stra\u00dfe","Address line before street") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile vor Stra\u00dfe</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_prefix848 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street849 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no850 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box851 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_4_panel852 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix848, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street849, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no850, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box851, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2857 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var address_box_panel858 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "layout": "form", "title": "Adresse", "items": [ name_box_panel837, address_box_2_panel842, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1847, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel852, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2857, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var id861 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language862 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "et", "Estnisch" ], [ "en", "Englisch" ] ], "name": "language" });
    var info_box_1_panel863 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id861, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language862, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var age_disp866 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Alter", "name": "age", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var info_box_panel867 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ info_box_1_panel863, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": age_disp866, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 54, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email869 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-Mail", "anchor": "-20", "name": "email" });
    var url870 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone871 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Telefon", "anchor": "-20", "name": "phone" });
    var gsm872 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var fax873 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Fax", "anchor": "-20", "name": "fax" });
    var contact_box_5_panel874 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm872, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax873, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel877 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "layout": "form", "title": "Kontakt", "items": [ info_box_panel867, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email869, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url870, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone871, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel874 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var general_1_panel881 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ address_box_panel858, contact_box_panel877 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks882 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var contacts_RolesByPerson_grid887 = new Lino.contacts.RolesByPerson.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByPerson.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 42 });
    var bottom_box_panel888 = new Ext.Panel({ "flex": 38, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": remarks882, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 57 }, contacts_RolesByPerson_grid887 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel890 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel881, bottom_box_panel888 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var ledger_InvoicesByPartner_grid891 = new Lino.ledger.InvoicesByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "north", "tools": [ Lino.show_in_own_window_button(Lino.ledger.InvoicesByPartner.grid) ], "master_panel": this });
    var ledger_MovementsByPartner_grid892 = new Lino.ledger.MovementsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "center", "tools": [ Lino.show_in_own_window_button(Lino.ledger.MovementsByPartner.grid) ], "master_panel": this });
    var ledger_panel893 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Buchhaltung", "hideCheckBoxLabels": true, "items": [ ledger_InvoicesByPartner_grid891, ledger_MovementsByPartner_grid892 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var tickets_TicketsByPartner_grid894 = new Lino.tickets.TicketsByPartner.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "title": "Tickets", "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.tickets.TicketsByPartner.grid) ], "master_panel": this });
    var main_panel895 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel890, ledger_panel893, tickets_TicketsByPartner_grid894 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel895;
    this.before_row_edit = function(record) {
      region839.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city840.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city840.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByPerson_grid887.on_master_changed();
      ledger_InvoicesByPartner_grid891.on_master_changed();
      ledger_MovementsByPartner_grid892.on_master_changed();
      tickets_TicketsByPartner_grid894.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country838.on('change',Lino.chooser_handler(region839,'country'));
      country838.on('change',Lino.chooser_handler(city840,'country'));
      region839.on('change',Lino.chooser_handler(city840,'region'));
      Lino.contacts.Persons.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Persons.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.Home.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var quick_links_htmlbox1767 = new Lino.HtmlBoxPanel({ "flex": 1, "layout": "fit", "name": "quick_links", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "north", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden", "split": true });
    var welcome_htmlbox1768 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "welcome", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "center", "title": "Willkommen", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden", "split": true });
    var coming_reminders_htmlbox1769 = new Lino.HtmlBoxPanel({ "flex": 50, "layout": "fit", "name": "coming_reminders", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Ausblick", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden" });
    var missed_reminders_htmlbox1770 = new Lino.HtmlBoxPanel({ "flex": 50, "layout": "fit", "name": "missed_reminders", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Verpasste Erinnerungen", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden" });
    var main_3_panel1771 = new Ext.Panel({ "flex": 16, "layout": "hbox", "items": [ coming_reminders_htmlbox1769, missed_reminders_htmlbox1770 ], "region": "south", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 207, "border": false, "frame": false, "labelAlign": "top" });
    var main_panel1772 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ quick_links_htmlbox1767, welcome_htmlbox1768, main_3_panel1771 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1772;
    this.before_row_edit = function(record) {
      quick_links_htmlbox1767.refresh();
      welcome_htmlbox1768.refresh();
      coming_reminders_htmlbox1769.refresh();
      missed_reminders_htmlbox1770.refresh();
    }
    Lino.lino.Home.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Places.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 57,
  initComponent : function() {
    var containing_panel = this;
    var id1643 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1644 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1645 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_et1646 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (et)", "anchor": "-20", "name": "name_et" });
    var name_en1647 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel1648 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1643, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1644, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1645, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1646, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1647, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_EventsByPlace_grid1679 = new Lino.cal.EventsByPlace.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByPlace.grid) ], "master_panel": this });
    var main_panel1680 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1648, cal_EventsByPlace_grid1679 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1680;
    this.before_row_edit = function(record) {
      cal_EventsByPlace_grid1679.on_master_changed();
    }
    Lino.cal.Places.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.Users.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 7,
  initComponent : function() {
    var containing_panel = this;
    var username8 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Username","\n        Required. Must be unique. \n        ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Benutzername</span>", "name": "username", "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id9 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var profile10 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Benutzerprofil", "name": "profile", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.UserProfiles, "hiddenName": "profileHidden" });
    var box1_1_panel11 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username8, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id9, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile10, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name15 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30, "fieldLabel": "Vorname", "anchor": "-20", "name": "first_name" });
    var last_name16 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30, "fieldLabel": "Familienname", "anchor": "-20", "name": "last_name" });
    var partner17 = new Lino.TwinCombo({ "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Partner ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var box1_2_panel18 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name15, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name16, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner17, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email22 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "e-mail address", "anchor": "-20", "name": "email" });
    var language23 = new Lino.ChoicesFieldElement({ "fieldLabel": "Sprache", "allowBlank": false, "selectOnFocus": true, "hiddenName": "languageHidden", "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "et", "Estnisch" ], [ "en", "Englisch" ] ], "name": "language" });
    var box1_3_panel24 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email22, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language23, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var created27 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Erstellt", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified28 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Bearbeitet", "anchor": "-20", "value": "<br>", "name": "modified" });
    var box1_4_panel29 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created27, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified28, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box1_panel32 = new Ext.Panel({ "flex": 66, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ box1_1_panel11, box1_2_panel18, box1_3_panel24, box1_4_panel29 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var MembershipsByUser_grid35 = new Lino.users.MembershipsByUser.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.users.MembershipsByUser.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 33 });
    var general_1_panel36 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box1_panel32, MembershipsByUser_grid35 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks37 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var AuthoritiesGiven_grid40 = new Lino.users.AuthoritiesGiven.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.users.AuthoritiesGiven.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 33 });
    var general_2_panel41 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": remarks37, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 66 }, AuthoritiesGiven_grid40 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel43 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel36, general_2_panel41 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var calendar44 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Standard-Kalender</span>", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Kalender ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Default calendar","The default calendar for your events and tasks.") }, "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/calendar", "method": "GET" }) }) });
    var access_class45 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Standardm\u00e4\u00dfige Zugriffsklasse</span>", "allowBlank": false, "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Default access class","The default access class for your calendar events and tasks.") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.AccessClasses, "name": "access_class" });
    var cal_left_1_panel46 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar44, "labelAlign": "top" }, { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class45, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_SubscriptionsByUser_grid53 = new Lino.cal.SubscriptionsByUser.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cal.SubscriptionsByUser.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 83 });
    var cal_left_panel54 = new Ext.Panel({ "flex": 33, "border": false, "layout": "vbox", "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ cal_left_1_panel46, cal_SubscriptionsByUser_grid53 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": true, "labelAlign": "top" });
    var cal_TasksByUser_grid112 = new Lino.cal.TasksByUser.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByUser.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 66 });
    var cal_1_panel113 = new Ext.Panel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "layout": "hbox", "title": "Kalender", "hideCheckBoxLabels": true, "items": [ cal_left_panel54, cal_TasksByUser_grid112 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel114 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel43, cal_1_panel113 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel114;
    this.before_row_edit = function(record) {
      MembershipsByUser_grid35.on_master_changed();
      AuthoritiesGiven_grid40.on_master_changed();
      cal_SubscriptionsByUser_grid53.on_master_changed();
      cal_TasksByUser_grid112.on_master_changed();
    }
    Lino.users.Users.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.Users.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 7,
  initComponent : function() {
    var containing_panel = this;
    var username115 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Username","\n        Required. Must be unique. \n        ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Benutzername</span>", "name": "username", "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var email116 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "e-mail address", "anchor": "-20", "name": "email" });
    var main_1_panel117 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username115, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email116, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name120 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30, "fieldLabel": "Vorname", "anchor": "-20", "name": "first_name" });
    var last_name121 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30, "fieldLabel": "Familienname", "anchor": "-20", "name": "last_name" });
    var main_2_panel122 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name120, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name121, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var partner125 = new Lino.TwinCombo({ "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Partner ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var language126 = new Lino.ChoicesFieldElement({ "fieldLabel": "Sprache", "allowBlank": false, "selectOnFocus": true, "hiddenName": "languageHidden", "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "et", "Estnisch" ], [ "en", "Englisch" ] ], "name": "language" });
    var profile127 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Benutzerprofil", "name": "profile", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.UserProfiles, "hiddenName": "profileHidden" });
    var main_4_panel128 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 47, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language126, "labelAlign": "top" }, { "flex": 52, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile127, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel131 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ main_1_panel117, main_2_panel122, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner125, "anchor": "-20", "labelAlign": "top" }, main_4_panel128 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel131;
    this.before_row_edit = function(record) {
    }
    Lino.users.Users.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Calendars.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 59,
  initComponent : function() {
    var containing_panel = this;
    var type1451 = new Lino.ChoicesFieldElement({ "fieldLabel": "Art", "allowBlank": false, "value": "local", "hiddenName": "typeHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "local", "Local Calendar" ], [ "google", "Google Calendar" ] ], "name": "type" });
    var name1452 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1453 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_et1454 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (et)", "anchor": "-20", "name": "name_et" });
    var name_en1455 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var id1456 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_1_panel1457 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1451, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1452, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1453, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1454, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1455, "labelAlign": "top" }, { "flex": 4, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1456, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var url_template1464 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL-Vorlage", "anchor": "-20", "name": "url_template" });
    var username1465 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Benutzername", "anchor": "-20", "name": "username" });
    var password1466 = new Ext.form.TextField({ "fieldLabel": "Passwort", "name": "password", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "inputType": "password" });
    var main_2_panel1467 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": url_template1464, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username1465, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": password1466, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var readonly1471 = new Ext.form.Checkbox({ "boxLabel": "schreibgesch\u00fctzt", "hideLabel": true, "checked": false, "name": "readonly", "selectOnFocus": true, "anchor": "-20" });
    var invite_team_members1472 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Team", "name": "invite_team_members", "pageSize": 20, "emptyText": "Team ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "invite_team_membersHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/invite_team_members", "method": "GET" }) }) });
    var color1473 = new Ext.form.NumberField({ "fieldLabel": "Farbe", "name": "color", "selectOnFocus": true, "anchor": "-20", "value": 1, "allowBlank": false });
    var start_date1474 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Beginnt am", "anchor": "-20", "name": "start_date" });
    var main_3_panel1475 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": readonly1471, "labelAlign": "top" }, { "flex": 46, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invite_team_members1472, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": color1473, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1474, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var build_method1480 = new Lino.ChoicesFieldElement({ "fieldLabel": "Konstruktionsmethode", "name": "build_method", "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "hiddenName": "build_methodHidden" });
    var template1481 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "fieldLabel": "Vorlage", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/template", "method": "GET" }) }), "name": "template" });
    var email_template1482 = new Lino.SimpleRemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("E-Mail-Vorlage","The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">E-Mail-Vorlage</span>", "name": "email_template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/email_template", "method": "GET" }) }) });
    var attach_to_email1483 = new Ext.form.Checkbox({ "boxLabel": "als Anhang per E-Mail", "listeners": { "render": Lino.quicktip_renderer("als Anhang per E-Mail","Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "hideLabel": true, "checked": false, "name": "attach_to_email", "selectOnFocus": true, "anchor": "-20" });
    var main_4_panel1484 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 198, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method1480, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template1481, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template1482, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email1483, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var EventsByCalendar_grid1618 = new Lino.cal.EventsByCalendar.GridPanel({ "flex": 80, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByCalendar.grid) ], "master_panel": this });
    var SubscriptionsByCalendar_grid1623 = new Lino.cal.SubscriptionsByCalendar.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cal.SubscriptionsByCalendar.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 20 });
    var main_5_panel1624 = new Ext.Panel({ "flex": 55, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ EventsByCalendar_grid1618, SubscriptionsByCalendar_grid1623 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel1625 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1457, main_2_panel1467, main_3_panel1475, main_4_panel1484, main_5_panel1624 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1625;
    this.before_row_edit = function(record) {
      template1481.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      EventsByCalendar_grid1618.on_master_changed();
      SubscriptionsByCalendar_grid1623.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method1480.on('change',Lino.chooser_handler(template1481,'build_method'));
      Lino.cal.Calendars.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.cal.Calendars.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Countries.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 10,
  initComponent : function() {
    var containing_panel = this;
    var isocode413 = new Ext.form.TextField({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">ISO-Code</span>", "name": "isocode", "boxMinWidth": Lino.chars2width(4), "listeners": { "render": Lino.quicktip_renderer("ISO-Code","        The two-letter code for this country as defined by ISO 3166-1. \n        For countries that no longer exist it may be a 4-letter code.") }, "maxLength": 4, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name414 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr415 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_et416 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (et)", "anchor": "-20", "name": "name_et" });
    var name_en417 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var short_code418 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Short code","A short abbreviation for regional usage. Obsolete.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Short code</span>", "name": "short_code", "maxLength": 4, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var main_1_panel419 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": isocode413, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name414, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr415, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et416, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en417, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": short_code418, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var countries_CitiesByCountry_grid771 = new Lino.countries.CitiesByCountry.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.countries.CitiesByCountry.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 83 });
    var main_panel772 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel419, countries_CitiesByCountry_grid771 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel772;
    this.before_row_edit = function(record) {
      countries_CitiesByCountry_grid771.on_master_changed();
    }
    Lino.countries.Countries.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Cities.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 12,
  initComponent : function() {
    var containing_panel = this;
    var name435 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr436 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_et437 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (et)", "anchor": "-20", "name": "name_et" });
    var name_en438 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var country439 = new Lino.TwinCombo({ "fieldLabel": "Land", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/country", "method": "GET" }) }), "name": "country" });
    var main_1_panel440 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name435, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr436, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et437, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en438, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country439, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var type446 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Ortsart", "name": "type", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/type", "method": "GET" }) }), "hiddenName": "typeHidden" });
    var parent447 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Teil von</span>", "name": "parent", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Teil von","The superordinate geographic place of which this place is a part.") }, "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/parent", "method": "GET" }) }) });
    var zip_code448 = new Ext.form.TextField({ "fieldLabel": "zip code", "name": "zip_code", "maxLength": 8, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "anchor": "-20" });
    var id449 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_2_panel450 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type446, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent447, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code448, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id449, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var CitiesByCity_grid768 = new Lino.countries.CitiesByCity.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.countries.CitiesByCity.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 41 });
    var contacts_PartnersByCity_grid769 = new Lino.contacts.PartnersByCity.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.contacts.PartnersByCity.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 41 });
    var main_panel770 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel440, main_2_panel450, CitiesByCity_grid768, contacts_PartnersByCity_grid769 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel770;
    this.before_row_edit = function(record) {
      type446.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      CitiesByCity_grid768.on_master_changed();
      contacts_PartnersByCity_grid769.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country439.on('change',Lino.chooser_handler(type446,'country'));
      Lino.countries.Cities.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.countries.Cities.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Households.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 25,
  initComponent : function() {
    var containing_panel = this;
    var type1023 = new Lino.TwinCombo({ "fieldLabel": "Haushaltsart", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.households.Types.detail)}, "emptyText": "Haushaltsart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/type", "method": "GET" }) }) });
    var name1024 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language1025 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "et", "Estnisch" ], [ "en", "Englisch" ] ], "name": "language" });
    var id1026 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var intro_box_1_panel1027 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1023, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1024, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1025, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1026, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var country1032 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/country", "method": "GET" }) }) });
    var region1033 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/region", "method": "GET" }) }) });
    var box3_1_panel1034 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1032, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region1033, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city1037 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/city", "method": "GET" }) }) });
    var zip_code1038 = new Ext.form.TextField({ "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_2_panel1039 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city1037, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code1038, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix1042 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street1043 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no1044 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box1045 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_3_panel1046 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix1042, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street1043, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no1044, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box1045, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr21051 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box3_panel1052 = new Ext.Panel({ "flex": 62, "autoHeight": true, "layout": "form", "items": [ box3_1_panel1034, box3_2_panel1039, box3_3_panel1046, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr21051, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var email1054 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-Mail", "anchor": "-20", "name": "email" });
    var url1055 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone1056 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Telefon", "anchor": "-20", "name": "phone" });
    var gsm1057 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var box4_panel1058 = new Ext.Panel({ "flex": 37, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1054, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url1055, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone1056, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm1057, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var address_box_panel1063 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box3_panel1052, box4_panel1058 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks1064 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var households_MembersByHousehold_grid1071 = new Lino.households.MembersByHousehold.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByHousehold.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 50 });
    var bottom_box_panel1072 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": remarks1064, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 49 }, households_MembersByHousehold_grid1071 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel1074 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ intro_box_1_panel1027, address_box_panel1063, bottom_box_panel1072 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1074;
    this.before_row_edit = function(record) {
      region1033.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1037.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1037.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      households_MembersByHousehold_grid1071.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country1032.on('change',Lino.chooser_handler(region1033,'country'));
      country1032.on('change',Lino.chooser_handler(city1037,'country'));
      region1033.on('change',Lino.chooser_handler(city1037,'region'));
      Lino.households.Households.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.households.Households.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Events.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 60,
  initComponent : function() {
    var containing_panel = this;
    var calendar1529 = new Lino.TwinCombo({ "fieldLabel": "Kalender", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Kalender ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/calendar", "method": "GET" }) }) });
    var summary1530 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Kurzbeschreibung", "anchor": "-20", "name": "summary" });
    var user1531 = new Lino.TwinCombo({ "fieldLabel": "Verantwortlicher", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }) });
    var assigned_to1532 = new Lino.TwinCombo({ "fieldLabel": "Zugewiesen zu", "name": "assigned_to", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "assigned_toHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/assigned_to", "method": "GET" }) }) });
    var main_1_panel1533 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar1529, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary1530, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1531, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": assigned_to1532, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var start_date1538 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Beginnt am", "anchor": "-20", "name": "start_date" });
    var start_time1539 = new Lino.TimeField({ "selectOnFocus": true, "fieldLabel": "Beginnt um", "anchor": "-20", "name": "start_time" });
    var start_panel1540 = new Ext.Panel({ "flex": 33, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1538, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time1539, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var end_date1543 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Endet am", "anchor": "-20", "name": "end_date" });
    var end_time1544 = new Lino.TimeField({ "selectOnFocus": true, "fieldLabel": "Endet um", "anchor": "-20", "name": "end_time" });
    var end_panel1545 = new Ext.Panel({ "flex": 33, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1543, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time1544, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var state1548 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Zustand", "allowBlank": false, "hiddenName": "stateHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.EventStates, "name": "state" });
    var main_2_panel1549 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ start_panel1540, end_panel1545, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state1548, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var place1551 = new Lino.TwinCombo({ "fieldLabel": "Ort", "name": "place", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Places.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "placeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/place", "method": "GET" }) }) });
    var priority1552 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Priorit\u00e4t", "name": "priority", "pageSize": 20, "emptyText": "Priorit\u00e4t ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "priorityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/priority", "method": "GET" }) }) });
    var access_class1553 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zugriffsklasse</span>", "name": "access_class", "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Zugriffsklasse","Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.AccessClasses });
    var transparent1554 = new Ext.form.Checkbox({ "boxLabel": "nicht blockierend", "listeners": { "render": Lino.quicktip_renderer("nicht blockierend","Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.") }, "hideLabel": true, "checked": false, "name": "transparent", "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel1555 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 162, "hideCheckBoxLabels": true, "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": place1551, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": priority1552, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class1553, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": transparent1554, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var owner_disp1560 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var created1561 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Erstellt", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified1562 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Bearbeitet", "anchor": "-20", "value": "<br>", "name": "modified" });
    var main_4_panel1563 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp1560, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1561, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1562, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description1567 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 35, "containing_panel": this, "name": "description", "title": "Beschreibung" });
    var GuestsByEvent_grid1577 = new Lino.cal.GuestsByEvent.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.cal.GuestsByEvent.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 50 });
    var outbox_MailsByController_grid1589 = new Lino.outbox.MailsByController.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 50 });
    var main_6_panel1590 = new Ext.Panel({ "flex": 35, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ GuestsByEvent_grid1577, outbox_MailsByController_grid1589 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel1591 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel1533, main_2_panel1549, main_3_panel1555, main_4_panel1563, description1567, main_6_panel1590 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1591;
    this.before_row_edit = function(record) {
      description1567.refresh();
      GuestsByEvent_grid1577.on_master_changed();
      outbox_MailsByController_grid1589.on_master_changed();
    }
    Lino.cal.Events.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Events.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 60,
  initComponent : function() {
    var containing_panel = this;
    var calendar1592 = new Lino.TwinCombo({ "fieldLabel": "Kalender", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Kalender ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/calendar", "method": "GET" }) }) });
    var summary1593 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Kurzbeschreibung", "anchor": "-20", "name": "summary" });
    var main_1_panel1594 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar1592, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary1593, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var start_date1597 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Beginnt am", "anchor": "-20", "name": "start_date" });
    var start_time1598 = new Lino.TimeField({ "selectOnFocus": true, "fieldLabel": "Beginnt um", "anchor": "-20", "name": "start_time" });
    var start_panel1599 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1597, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time1598, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var end_date1602 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Endet am", "anchor": "-20", "name": "end_date" });
    var end_time1603 = new Lino.TimeField({ "selectOnFocus": true, "fieldLabel": "Endet um", "anchor": "-20", "name": "end_time" });
    var end_panel1604 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1602, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time1603, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var main_2_panel1607 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ start_panel1599, end_panel1604 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "anchor": "-20", "labelAlign": "top" });
    var place1608 = new Lino.TwinCombo({ "fieldLabel": "Ort", "name": "place", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Places.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "placeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/place", "method": "GET" }) }) });
    var priority1609 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Priorit\u00e4t", "name": "priority", "pageSize": 20, "emptyText": "Priorit\u00e4t ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "priorityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/priority", "method": "GET" }) }) });
    var access_class1610 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zugriffsklasse</span>", "name": "access_class", "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Zugriffsklasse","Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.AccessClasses });
    var transparent1611 = new Ext.form.Checkbox({ "boxLabel": "nicht blockierend", "listeners": { "render": Lino.quicktip_renderer("nicht blockierend","Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.") }, "hideLabel": true, "checked": false, "name": "transparent", "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel1612 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": place1608, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": priority1609, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class1610, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": transparent1611, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1617 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1594, main_2_panel1607, main_3_panel1612 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1617;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Events.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.Milestones.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 50,
  initComponent : function() {
    var containing_panel = this;
    var project1372 = new Lino.TwinCombo({ "fieldLabel": "Projekt", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail)}, "emptyText": "Projekt ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Milestones/project", "method": "GET" }) }) });
    var ref1373 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Referenz", "anchor": "-20", "name": "ref" });
    var expected1374 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Expected for", "anchor": "-20", "name": "expected" });
    var reached1375 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Reached", "anchor": "-20", "name": "reached" });
    var id1376 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_1_panel1377 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1372, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1373, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": expected1374, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": reached1375, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1376, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var TicketsFixed_grid1395 = new Lino.tickets.TicketsFixed.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.tickets.TicketsFixed.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 50 });
    var TicketsReported_grid1408 = new Lino.tickets.TicketsReported.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.tickets.TicketsReported.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 50 });
    var main_2_panel1409 = new Ext.Panel({ "flex": 83, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ TicketsFixed_grid1395, TicketsReported_grid1408 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel1410 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1377, main_2_panel1409 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1410;
    this.before_row_edit = function(record) {
      TicketsFixed_grid1395.on_master_changed();
      TicketsReported_grid1408.on_master_changed();
    }
    Lino.tickets.Milestones.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Charts.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 31,
  initComponent : function() {
    var containing_panel = this;
    var id1157 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1158 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1159 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_et1160 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (et)", "anchor": "-20", "name": "name_et" });
    var name_en1161 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel1162 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1157, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1158, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1159, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1160, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1161, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var GroupsByChart_grid1209 = new Lino.accounts.GroupsByChart.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.accounts.GroupsByChart.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 83 });
    var main_panel1210 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1162, GroupsByChart_grid1209 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1210;
    this.before_row_edit = function(record) {
      GroupsByChart_grid1209.on_master_changed();
    }
    Lino.accounts.Charts.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 54,
  initComponent : function() {
    var containing_panel = this;
    var summary104 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Kurzbeschreibung", "anchor": "-20", "name": "summary" });
    var user105 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var project106 = new Lino.TwinCombo({ "fieldLabel": "Projekt", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail)}, "emptyText": "Projekt ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_2_panel107 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user105, "labelAlign": "top" }, { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project106, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel110 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary104, "anchor": "-20", "labelAlign": "top" }, main_2_panel107 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel110;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Tasks.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.blogs.Entries.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 44,
  initComponent : function() {
    var containing_panel = this;
    var title706 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "\u00dcberschrift", "anchor": "-20", "name": "title" });
    var type707 = new Lino.TwinCombo({ "fieldLabel": "Blog Entry Type", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.blogs.EntryTypes.detail)}, "emptyText": "Blog Entry Type ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/Entries/type", "method": "GET" }) }) });
    var user708 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/Entries/user", "method": "GET" }) }) });
    var id709 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_1_panel710 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title706, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type707, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user708, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id709, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var language715 = new Lino.ChoicesFieldElement({ "fieldLabel": "Sprache", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "et", "Estnisch" ], [ "en", "Englisch" ] ], "name": "language" });
    var created716 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Erstellt", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified717 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Bearbeitet", "anchor": "-20", "value": "<br>", "name": "modified" });
    var owner_disp718 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var build_time719 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Druckdatum", "anchor": "-20", "value": "<br>", "name": "build_time" });
    var main_2_panel720 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language715, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created716, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified717, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp718, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_time719, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var body726 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 71, "containing_panel": this, "name": "body", "title": "Inhalt" });
    var main_panel727 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel710, main_2_panel720, body726 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel727;
    this.before_row_edit = function(record) {
      body726.refresh();
    }
    Lino.blogs.Entries.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 15,
  initComponent : function() {
    var containing_panel = this;
    var id793 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name794 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr795 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_et796 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (et)", "anchor": "-20", "name": "name_et" });
    var name_en797 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var choicelist798 = new Lino.ChoicesFieldElement({ "fieldLabel": "Auswahliste", "name": "choicelist", "selectOnFocus": true, "anchor": "-20", "store": [ [ "countries.CityTypes", "CityTypes" ], [ "lino.Genders", "Genders" ], [ "lino.UserGroups", "User Groups" ], [ "lino.UserLevels", "Benutzer-Levels" ], [ "lino.UserProfiles", "Benutzerprofile" ], [ "properties.DoYouLike", "DoYouLike" ], [ "properties.HowWell", "HowWell" ] ], "hiddenName": "choicelistHidden" });
    var default_value799 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Standardwert", "name": "default_value", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropTypes/default_value", "method": "GET" }) }), "hiddenName": "default_valueHidden" });
    var main_1_panel800 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 4, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id793, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name794, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr795, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et796, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en797, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": choicelist798, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": default_value799, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 153, "border": false, "frame": false, "labelAlign": "top" });
    var ChoicesByType_grid815 = new Lino.properties.ChoicesByType.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "center", "tools": [ Lino.show_in_own_window_button(Lino.properties.ChoicesByType.grid) ], "master_panel": this });
    var PropsByType_grid823 = new Lino.properties.PropsByType.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "south", "tools": [ Lino.show_in_own_window_button(Lino.properties.PropsByType.grid) ], "master_panel": this });
    var main_panel824 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "hideCheckBoxLabels": true, "items": [ main_1_panel800, ChoicesByType_grid815, PropsByType_grid823 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel824;
    this.before_row_edit = function(record) {
      default_value799.setContextValue('choicelist',record ? record.data['choicelistHidden'] : undefined);
      ChoicesByType_grid815.on_master_changed();
      PropsByType_grid823.on_master_changed();
    }
    this.onRender = function(ct, position) {
      choicelist798.on('change',Lino.chooser_handler(default_value799,'choicelist'));
      Lino.properties.PropTypes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.properties.PropTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Roles.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 24,
  initComponent : function() {
    var containing_panel = this;
    var name1077 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1078 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_et1079 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (et)", "anchor": "-20", "name": "name_et" });
    var name_en1080 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var name_giving1081 = new Ext.form.Checkbox({ "boxLabel": "namensgebend", "listeners": { "render": Lino.quicktip_renderer("namensgebend","When the `name` field of a Household is empty, \nits value is computed by joining the `Last Name` \nof all name-giving members with a dash (\"-\").\n      ") }, "hideLabel": true, "checked": false, "name": "name_giving", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1082 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1077, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1078, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1079, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1080, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_giving1081, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var MembersByRole_grid1094 = new Lino.households.MembersByRole.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByRole.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 83 });
    var main_panel1095 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1082, MembersByRole_grid1094 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1095;
    this.before_row_edit = function(record) {
      MembersByRole_grid1094.on_master_changed();
    }
    Lino.households.Roles.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropGroups.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 14,
  initComponent : function() {
    var containing_panel = this;
    var id773 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name774 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr775 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_et776 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (et)", "anchor": "-20", "name": "name_et" });
    var name_en777 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel778 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id773, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name774, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr775, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et776, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en777, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var PropsByGroup_grid791 = new Lino.properties.PropsByGroup.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.properties.PropsByGroup.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 83 });
    var main_panel792 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel778, PropsByGroup_grid791 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel792;
    this.before_row_edit = function(record) {
      PropsByGroup_grid791.on_master_changed();
    }
    Lino.properties.PropGroups.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 54,
  initComponent : function() {
    var containing_panel = this;
    var start_date77 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Beginnt am", "anchor": "-20", "name": "start_date" });
    var due_date78 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Zahlungsziel", "anchor": "-20", "name": "due_date" });
    var id79 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var workflow_buttons_disp80 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel81 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date77, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": due_date78, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id79, "labelAlign": "top" }, { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp80, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var summary86 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Kurzbeschreibung", "anchor": "-20", "name": "summary" });
    var user87 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var project88 = new Lino.TwinCombo({ "fieldLabel": "Projekt", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail)}, "emptyText": "Projekt ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_3_panel89 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user87, "labelAlign": "top" }, { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project88, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var calendar92 = new Lino.TwinCombo({ "fieldLabel": "Kalender", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Kalender ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/calendar", "method": "GET" }) }) });
    var owner_disp93 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var created94 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Erstellt", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified95 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Bearbeitet", "anchor": "-20", "value": "<br>", "name": "modified" });
    var main_4_panel96 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar92, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp93, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created94, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified95, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description101 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 45, "containing_panel": this, "name": "description", "title": "Beschreibung" });
    var main_panel102 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ main_1_panel81, { "items": summary86, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, main_3_panel89, main_4_panel96, description101 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel102;
    this.before_row_edit = function(record) {
      description101.refresh();
    }
    Lino.cal.Tasks.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Types.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 26,
  initComponent : function() {
    var containing_panel = this;
    var name985 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr986 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_et987 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (et)", "anchor": "-20", "name": "name_et" });
    var name_en988 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel989 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name985, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr986, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et987, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en988, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var HouseholdsByType_grid1075 = new Lino.households.HouseholdsByType.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.households.HouseholdsByType.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 83 });
    var main_panel1076 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel989, HouseholdsByType_grid1075 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1076;
    this.before_row_edit = function(record) {
      HouseholdsByType_grid1075.on_master_changed();
    }
    Lino.households.Types.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 21,
  initComponent : function() {
    var containing_panel = this;
    var name758 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language759 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "et", "Estnisch" ], [ "en", "Englisch" ] ], "name": "language" });
    var email760 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-Mail", "anchor": "-20", "name": "email" });
    var main_2_panel761 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language759, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email760, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel764 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name758, "anchor": "-20", "labelAlign": "top" }, main_2_panel761 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel764;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Partners.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Groups.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 30,
  initComponent : function() {
    var containing_panel = this;
    var ref1177 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20, "fieldLabel": "ref", "anchor": "-20", "name": "ref" });
    var name1178 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1179 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_et1180 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (et)", "anchor": "-20", "name": "name_et" });
    var name_en1181 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel1182 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1177, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1178, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1179, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1180, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1181, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var account_type1188 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Kontenart", "name": "account_type", "selectOnFocus": true, "anchor": "-20", "store": Lino.accounts.AccountTypes, "hiddenName": "account_typeHidden" });
    var id1189 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_2_panel1190 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 78, "autoHeight": true, "layout": "form", "xtype": "panel", "items": account_type1188, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1189, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var help_text1193 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 41, "containing_panel": this, "name": "help_text", "title": "Einleitung" });
    var AccountsByGroup_grid1207 = new Lino.accounts.AccountsByGroup.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.accounts.AccountsByGroup.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 41 });
    var main_panel1208 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel1182, main_2_panel1190, help_text1193, AccountsByGroup_grid1207 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1208;
    this.before_row_edit = function(record) {
      help_text1193.refresh();
      AccountsByGroup_grid1207.on_master_changed();
    }
    Lino.accounts.Groups.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.Mails.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 62,
  initComponent : function() {
    var containing_panel = this;
    var project1445 = new Lino.TwinCombo({ "fieldLabel": "Projekt", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail)}, "emptyText": "Projekt ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var subject1446 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Betreff", "anchor": "-20", "name": "subject" });
    var body1447 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 71, "containing_panel": this, "name": "body", "title": "Inhalt" });
    var main_panel1448 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": project1445, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": subject1446, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, body1447 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1448;
    this.before_row_edit = function(record) {
      body1447.refresh();
    }
    Lino.outbox.Mails.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.Tickets.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 51,
  initComponent : function() {
    var containing_panel = this;
    var summary636 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Kurzbeschreibung","Short summary of the problem.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Kurzbeschreibung</span>", "name": "summary", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var partner637 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Partner</span>", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Partner ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Partner","The partner who reported this ticket.") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/partner", "method": "GET" }) }) });
    var project638 = new Lino.TwinCombo({ "fieldLabel": "Projekt", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail)}, "emptyText": "Projekt ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/project", "method": "GET" }) }) });
    var reported639 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Reported for</span>", "name": "reported", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Milestones.detail)}, "emptyText": "Milestone ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Reported for","Milestone for which this ticket has been reported.") }, "selectOnFocus": true, "hiddenName": "reportedHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/reported", "method": "GET" }) }) });
    var id640 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_1_panel641 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary636, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner637, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project638, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": reported639, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id640, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user647 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/user", "method": "GET" }) }) });
    var created648 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Erstellt", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified649 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Bearbeitet", "anchor": "-20", "value": "<br>", "name": "modified" });
    var state650 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Zustand", "name": "state", "selectOnFocus": true, "anchor": "-20", "store": Lino.tickets.TicketStates, "hiddenName": "stateHidden" });
    var workflow_buttons_disp651 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var fixed652 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Fixed for</span>", "name": "fixed", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Milestones.detail)}, "emptyText": "Milestone ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Fixed for","The milestone for which this ticket has been fixed.") }, "selectOnFocus": true, "hiddenName": "fixedHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/fixed", "method": "GET" }) }) });
    var main_2_panel653 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user647, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created648, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified649, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state650, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp651, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fixed652, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description660 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Beschreibung", "anchor": "-20 -10", "growMax": 2000, "name": "description" });
    var SessionsByTicket_grid731 = new Lino.tickets.SessionsByTicket.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.tickets.SessionsByTicket.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 50 });
    var EntriesByTicket_grid745 = new Lino.tickets.EntriesByTicket.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.tickets.EntriesByTicket.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 50 });
    var main_4_panel746 = new Ext.Panel({ "flex": 35, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ SessionsByTicket_grid731, EntriesByTicket_grid745 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel747 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ main_1_panel641, main_2_panel653, { "items": description660, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 35 }, main_4_panel746 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel747;
    this.before_row_edit = function(record) {
      reported639.setContextValue('project',record ? record.data['projectHidden'] : undefined);
      fixed652.setContextValue('project',record ? record.data['projectHidden'] : undefined);
      SessionsByTicket_grid731.on_master_changed();
      EntriesByTicket_grid745.on_master_changed();
    }
    this.onRender = function(ct, position) {
      project638.on('change',Lino.chooser_handler(reported639,'project'));
      project638.on('change',Lino.chooser_handler(fixed652,'project'));
      Lino.tickets.Tickets.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.tickets.Tickets.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.Mails.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 62,
  initComponent : function() {
    var containing_panel = this;
    var subject1417 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Betreff", "anchor": "-20", "name": "subject" });
    var project1418 = new Lino.TwinCombo({ "fieldLabel": "Projekt", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail)}, "emptyText": "Projekt ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var date1419 = new Lino.DateField({ "listeners": { "render": Lino.quicktip_renderer("Datum","\n        The official date to be printed on the document.\n        ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Datum</span>", "name": "date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel1420 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject1417, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1418, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date1419, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user1424 = new Lino.TwinCombo({ "fieldLabel": "Absender", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/user", "method": "GET" }) }) });
    var sent1425 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "sent", "anchor": "-20", "value": "<br>", "name": "sent" });
    var id1426 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var owner_disp1427 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var main_2_panel1428 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1424, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent1425, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1426, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp1427, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var RecipientsByMail_grid1439 = new Lino.outbox.RecipientsByMail.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.outbox.RecipientsByMail.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 55 });
    var AttachmentsByMail_htmlbox1440 = new Lino.HtmlBoxPanel({ "flex": 22, "layout": "fit", "name": "AttachmentsByMail", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Anh\u00e4nge", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden", "tools": [ Lino.show_in_own_window_button(Lino.outbox.AttachmentsByMail.grid) ] });
    var UploadsByController_htmlbox1441 = new Lino.HtmlBoxPanel({ "flex": 22, "ls_bbar_actions": [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden", "ls_insert_handler": Lino.uploads.UploadsByController.insert, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var main_3_panel1442 = new Ext.Panel({ "flex": 29, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ RecipientsByMail_grid1439, AttachmentsByMail_htmlbox1440, UploadsByController_htmlbox1441 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var body1443 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 58, "containing_panel": this, "name": "body", "title": "Inhalt" });
    var main_panel1444 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel1420, main_2_panel1428, main_3_panel1442, body1443 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1444;
    this.before_row_edit = function(record) {
      RecipientsByMail_grid1439.on_master_changed();
      AttachmentsByMail_htmlbox1440.refresh();
      UploadsByController_htmlbox1441.refresh();
      body1443.refresh();
    }
    Lino.outbox.Mails.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.products.Products.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 28,
  initComponent : function() {
    var containing_panel = this;
    var id1120 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var cat1121 = new Lino.TwinCombo({ "fieldLabel": "Kategorie", "name": "cat", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.products.ProductCats.detail)}, "emptyText": "Produktkategorie ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "catHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/products/Products/cat", "method": "GET" }) }) });
    var price1122 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Preis", "name": "price", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var vatExempt1123 = new Ext.form.Checkbox({ "boxLabel": "Befreit von MWSt.", "hideLabel": true, "checked": false, "name": "vatExempt", "selectOnFocus": true, "anchor": "-20" });
    var general_1_panel1124 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 162, "hideCheckBoxLabels": true, "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1120, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cat1121, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": price1122, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vatExempt1123, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var name1129 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1130 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_et1131 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (et)", "anchor": "-20", "name": "name_et" });
    var name_en1132 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var general_2_panel1133 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1129, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1130, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1131, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1132, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description1138 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Long description", "anchor": "-20 -10", "growMax": 2000, "name": "description" });
    var general_panel1139 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel1124, general_2_panel1133, { "items": description1138, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "labelWidth": 153, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var sales_InvoiceItemsByProduct_grid1152 = new Lino.sales.InvoiceItemsByProduct.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "title": "Verkauf", "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.sales.InvoiceItemsByProduct.grid) ], "master_panel": this });
    var main_panel1153 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1139, sales_InvoiceItemsByProduct_grid1152 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1153;
    this.before_row_edit = function(record) {
      sales_InvoiceItemsByProduct_grid1152.on_master_changed();
    }
    Lino.products.Products.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ui.TextFieldTemplates.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 3,
  initComponent : function() {
    var containing_panel = this;
    var name405 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user406 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/TextFieldTemplates/user", "method": "GET" }) }) });
    var team407 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Team</span>", "name": "team", "pageSize": 20, "emptyText": "Team ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Team","If not empty, then this template is reserved to members of this team.") }, "selectOnFocus": true, "hiddenName": "teamHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/TextFieldTemplates/team", "method": "GET" }) }) });
    var main_2_panel408 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user406, "labelAlign": "top" }, { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": team407, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 54, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel411 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 108, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name405, "anchor": "-20", "labelAlign": "top" }, main_2_panel408 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel411;
    this.before_row_edit = function(record) {
    }
    Lino.ui.TextFieldTemplates.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.products.ProductCats.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 27,
  initComponent : function() {
    var containing_panel = this;
    var id1096 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1097 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1098 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_et1099 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (et)", "anchor": "-20", "name": "name_et" });
    var name_en1100 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel1101 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1096, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1097, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1098, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1099, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1100, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 153, "border": false, "frame": false, "labelAlign": "top" });
    var description1107 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "description", "anchor": "-20 -10", "growMax": 2000, "name": "description" });
    var ProductsByCategory_grid1154 = new Lino.products.ProductsByCategory.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "south", "tools": [ Lino.show_in_own_window_button(Lino.products.ProductsByCategory.grid) ], "master_panel": this });
    var main_panel1155 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ main_1_panel1101, { "flex": 5, "layout": "form", "xtype": "panel", "items": description1107, "region": "center", "labelAlign": "top", "split": true }, ProductsByCategory_grid1154 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1155;
    this.before_row_edit = function(record) {
      ProductsByCategory_grid1154.on_master_changed();
    }
    Lino.products.ProductCats.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.blogs.EntryTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 45,
  initComponent : function() {
    var containing_panel = this;
    var id1258 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1259 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1260 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_et1261 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (et)", "anchor": "-20", "name": "name_et" });
    var name_en1262 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel1263 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1258, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1259, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1260, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1261, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1262, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var build_method1269 = new Lino.ChoicesFieldElement({ "fieldLabel": "Konstruktionsmethode", "name": "build_method", "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "hiddenName": "build_methodHidden" });
    var template1270 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "fieldLabel": "Vorlage", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/EntryTypes/template", "method": "GET" }) }), "name": "template" });
    var main_2_panel1271 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method1269, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template1270, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark1274 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkung", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    var blogs_EntriesByType_grid1288 = new Lino.blogs.EntriesByType.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.blogs.EntriesByType.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 41 });
    var main_panel1289 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ main_1_panel1263, main_2_panel1271, { "items": remark1274, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 41 }, blogs_EntriesByType_grid1288 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1289;
    this.before_row_edit = function(record) {
      template1270.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      blogs_EntriesByType_grid1288.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method1269.on('change',Lino.chooser_handler(template1270,'build_method'));
      Lino.blogs.EntryTypes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.blogs.EntryTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.Uploads.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 53,
  initComponent : function() {
    var containing_panel = this;
    var file1712 = Lino.file_field_handler(this,{ "fieldLabel": "Datei", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user1713 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel1714 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file1712, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1713, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 54, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type1717 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Upload-Art", "name": "type", "pageSize": 20, "emptyText": "Upload-Art ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var description1718 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Beschreibung", "anchor": "-20", "name": "description" });
    var main_2_panel1719 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1717, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": description1718, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var modified1722 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Bearbeitet", "anchor": "-20", "value": "<br>", "name": "modified" });
    var created1723 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Erstellt", "anchor": "-20", "value": "<br>", "name": "created" });
    var owner_disp1724 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var main_3_panel1725 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1722, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1723, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp1724, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1729 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1714, main_2_panel1719, main_3_panel1725 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1729;
    this.before_row_edit = function(record) {
    }
    Lino.uploads.Uploads.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.Tickets.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 51,
  initComponent : function() {
    var containing_panel = this;
    var summary749 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Kurzbeschreibung","Short summary of the problem.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Kurzbeschreibung</span>", "name": "summary", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var partner750 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Partner</span>", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Partner ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Partner","The partner who reported this ticket.") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/partner", "method": "GET" }) }) });
    var project751 = new Lino.TwinCombo({ "fieldLabel": "Projekt", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail)}, "emptyText": "Projekt ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/project", "method": "GET" }) }) });
    var main_panel752 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 153, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary749, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner750, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": project751, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel752;
    this.before_row_edit = function(record) {
    }
    Lino.tickets.Tickets.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Journals.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 32,
  initComponent : function() {
    var containing_panel = this;
    var seqno1211 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "Seq.-Nr.", "anchor": "-20", "name": "seqno" });
    var id1212 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var trade_type1213 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Handelsart", "name": "trade_type", "selectOnFocus": true, "anchor": "-20", "store": Lino.vat.TradeTypes, "hiddenName": "trade_typeHidden" });
    var voucher_type1214 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "voucher type", "allowBlank": false, "hiddenName": "voucher_typeHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.ledger.VoucherTypes, "name": "voucher_type" });
    var main_1_panel1215 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": seqno1211, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1212, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": trade_type1213, "labelAlign": "top" }, { "flex": 72, "autoHeight": true, "layout": "form", "xtype": "panel", "items": voucher_type1214, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var force_sequence1220 = new Ext.form.Checkbox({ "boxLabel": "force sequence", "hideLabel": true, "checked": false, "name": "force_sequence", "selectOnFocus": true, "anchor": "-20" });
    var account1221 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Konto", "name": "account", "pageSize": 20, "emptyText": "Konto ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "accountHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Journals/account", "method": "GET" }) }) });
    var main_2_panel1222 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": force_sequence1220, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": account1221, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var name1225 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1226 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_et1227 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (et)", "anchor": "-20", "name": "name_et" });
    var name_en1228 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var main_3_panel1229 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1225, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1226, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1227, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1228, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var printed_name1234 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100, "fieldLabel": "printed name", "anchor": "-20", "name": "printed_name" });
    var printed_name_fr1235 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100, "fieldLabel": "printed name (fr)", "anchor": "-20", "name": "printed_name_fr" });
    var printed_name_et1236 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100, "fieldLabel": "printed name (et)", "anchor": "-20", "name": "printed_name_et" });
    var printed_name_en1237 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100, "fieldLabel": "printed name (en)", "anchor": "-20", "name": "printed_name_en" });
    var main_4_panel1238 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": printed_name1234, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": printed_name_fr1235, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": printed_name_et1236, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": printed_name_en1237, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1243 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1215, main_2_panel1222, main_3_panel1229, main_4_panel1238 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1243;
    this.before_row_edit = function(record) {
      account1221.setContextValue('chart',record ? record.data['chartHidden'] : undefined);
    }
    Lino.ledger.Journals.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ui.SiteConfigs.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 1,
  initComponent : function() {
    var containing_panel = this;
    var default_build_method370 = new Lino.ChoicesFieldElement({ "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "fieldLabel": "Standard-Konstruktionsmethode", "name": "default_build_method", "selectOnFocus": true, "anchor": "-20", "value": "appyodt", "hiddenName": "default_build_methodHidden" });
    var main_panel371 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "labelWidth": 270, "hideCheckBoxLabels": true, "items": [ { "items": default_build_method370, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel371;
    this.before_row_edit = function(record) {
    }
    Lino.ui.SiteConfigs.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ui.ContentTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 5,
  initComponent : function() {
    var containing_panel = this;
    var id373 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name374 = new Ext.form.TextField({ "fieldLabel": "name", "name": "name", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var app_label375 = new Ext.form.TextField({ "fieldLabel": "app label", "name": "app_label", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var model376 = new Ext.form.TextField({ "fieldLabel": "Python Modell-Klassenname", "name": "model", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var base_classes_disp377 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Base classes", "name": "base_classes", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel378 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 234, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id373, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name374, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_label375, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": model376, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": base_classes_disp377, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ui_HelpTextsByModel_grid390 = new Lino.ui.HelpTextsByModel.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.ui.HelpTextsByModel.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 62 });
    var main_panel391 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel378, ui_HelpTextsByModel_grid390 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel391;
    this.before_row_edit = function(record) {
      ui_HelpTextsByModel_grid390.on_master_changed();
    }
    Lino.ui.ContentTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Invoices.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 34,
  initComponent : function() {
    var containing_panel = this;
    var partner362 = new Lino.TwinCombo({ "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Partner ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/partner", "method": "GET" }) }), "name": "partner" });
    var date363 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "Datum", "anchor": "-20", "name": "date" });
    var total_incl364 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Total inkl. MWSt.", "name": "total_incl", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var main_2_panel365 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date363, "labelAlign": "top" }, { "flex": 60, "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_incl364, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel368 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner362, "anchor": "-20", "labelAlign": "top" }, main_2_panel365 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel368;
    this.before_row_edit = function(record) {
    }
    Lino.ledger.Invoices.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Calendars.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 59,
  initComponent : function() {
    var containing_panel = this;
    var name1626 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1627 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_et1628 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (et)", "anchor": "-20", "name": "name_et" });
    var name_en1629 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel1630 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1626, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1627, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1628, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1629, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type1635 = new Lino.ChoicesFieldElement({ "fieldLabel": "Art", "allowBlank": false, "value": "local", "hiddenName": "typeHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "local", "Local Calendar" ], [ "google", "Google Calendar" ] ], "name": "type" });
    var invite_team_members1636 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Team", "name": "invite_team_members", "pageSize": 20, "emptyText": "Team ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "invite_team_membersHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/invite_team_members", "method": "GET" }) }) });
    var color1637 = new Ext.form.NumberField({ "fieldLabel": "Farbe", "name": "color", "selectOnFocus": true, "anchor": "-20", "value": 1, "allowBlank": false });
    var main_2_panel1638 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1635, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invite_team_members1636, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": color1637, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 54, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1642 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1630, main_2_panel1638 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1642;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Calendars.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ui.TextFieldTemplates.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 3,
  initComponent : function() {
    var containing_panel = this;
    var id392 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name393 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user394 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/TextFieldTemplates/user", "method": "GET" }) }) });
    var team395 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Team</span>", "name": "team", "pageSize": 20, "emptyText": "Team ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Team","If not empty, then this template is reserved to members of this team.") }, "selectOnFocus": true, "hiddenName": "teamHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/TextFieldTemplates/team", "method": "GET" }) }) });
    var main_1_panel396 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id392, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name393, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user394, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": team395, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 108, "border": false, "frame": false, "labelAlign": "top" });
    var description401 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Beschreibung", "anchor": "-20 -10", "growMax": 2000, "name": "description" });
    var text402 = new Lino.RichTextPanel({ "flex": 5, "split": true, "containing_panel": this, "selectOnFocus": true, "region": "south", "title": "Vorlagentext", "name": "text" });
    var main_panel403 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ main_1_panel396, { "flex": 5, "layout": "form", "xtype": "panel", "items": description401, "region": "center", "labelAlign": "top", "split": true }, text402 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel403;
    this.before_row_edit = function(record) {
      text402.refresh();
    }
    Lino.ui.TextFieldTemplates.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.Sessions.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 49,
  initComponent : function() {
    var containing_panel = this;
    var date674 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "Datum", "anchor": "-20", "name": "date" });
    var start_time675 = new Lino.TimeField({ "selectOnFocus": true, "fieldLabel": "Beginnt um", "anchor": "-20", "name": "start_time" });
    var end_time676 = new Lino.TimeField({ "selectOnFocus": true, "fieldLabel": "Endet um", "anchor": "-20", "name": "end_time" });
    var break_time677 = new Lino.TimeField({ "selectOnFocus": true, "fieldLabel": "Break Time", "anchor": "-20", "name": "break_time" });
    var project678 = new Lino.TwinCombo({ "fieldLabel": "Projekt", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail)}, "emptyText": "Projekt ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Sessions/project", "method": "GET" }) }) });
    var ticket679 = new Lino.TwinCombo({ "fieldLabel": "Ticket", "name": "ticket", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Tickets.detail)}, "emptyText": "Ticket ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "ticketHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Sessions/ticket", "method": "GET" }) }) });
    var main_1_panel680 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date674, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time675, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time676, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": break_time677, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project678, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ticket679, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user687 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Sessions/user", "method": "GET" }) }) });
    var id688 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_2_panel689 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 54, "hideCheckBoxLabels": true, "items": [ { "flex": 75, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user687, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id688, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description692 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Beschreibung", "anchor": "-20 -10", "growMax": 2000, "name": "description" });
    var EntriesBySession_grid728 = new Lino.tickets.EntriesBySession.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.tickets.EntriesBySession.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 41 });
    var main_panel729 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ main_1_panel680, main_2_panel689, { "items": description692, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 41 }, EntriesBySession_grid728 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel729;
    this.before_row_edit = function(record) {
      EntriesBySession_grid728.on_master_changed();
    }
    Lino.tickets.Sessions.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Invoices.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 34,
  initComponent : function() {
    var containing_panel = this;
    var id312 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var date313 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "Datum", "anchor": "-20", "name": "date" });
    var partner314 = new Lino.TwinCombo({ "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Partner ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/partner", "method": "GET" }) }), "name": "partner" });
    var user315 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/user", "method": "GET" }) }) });
    var general_1_panel316 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id312, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date313, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner314, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user315, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var due_date321 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Zahlungsziel", "anchor": "-20", "name": "due_date" });
    var your_ref322 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Ihr Zeichen", "anchor": "-20", "name": "your_ref" });
    var vat_regime323 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "MWSt.-Regime", "name": "vat_regime", "selectOnFocus": true, "anchor": "-20", "store": Lino.vat.VatRegimes, "hiddenName": "vat_regimeHidden" });
    var item_vat324 = new Ext.form.Checkbox({ "boxLabel": "Preis inkl. MWSt.", "listeners": { "render": Lino.quicktip_renderer("Preis inkl. MWSt.","Ob St\u00fcckpreise sich inkl. MWSt. verstehen.") }, "hideLabel": true, "checked": false, "name": "item_vat", "selectOnFocus": true, "anchor": "-20" });
    var general_2_panel325 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": due_date321, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": your_ref322, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_regime323, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": item_vat324, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var ItemsByInvoice_grid338 = new Lino.ledger.ItemsByInvoice.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.ledger.ItemsByInvoice.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 75 });
    var total_base339 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Total zzgl. MWSt.", "name": "total_base", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var total_vat340 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "MWSt.", "name": "total_vat", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var total_incl341 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Total inkl. MWSt.", "name": "total_incl", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var workflow_buttons_disp342 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var totals_panel343 = new Ext.Panel({ "flex": 25, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_base339, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_vat340, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_incl341, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp342, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 162, "border": false, "labelAlign": "top" });
    var general_3_panel348 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ ItemsByInvoice_grid338, totals_panel343 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "anchor": "-20", "labelAlign": "top" });
    var general_panel349 = new Ext.Panel({ "autoHeight": true, "layout": "form", "title": "Allgemein", "items": [ general_1_panel316, general_2_panel325, general_3_panel348 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "labelAlign": "top" });
    var journal350 = new Lino.TwinCombo({ "fieldLabel": "Journal", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail)}, "emptyText": "Journal ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "journalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/journal", "method": "GET" }) }), "name": "journal" });
    var year351 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Gesch\u00e4ftsjahr", "name": "year", "selectOnFocus": true, "anchor": "-20", "store": Lino.ledger.FiscalYears, "hiddenName": "yearHidden" });
    var number352 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "number", "anchor": "-20", "name": "number" });
    var narration353 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Narration", "anchor": "-20", "name": "narration" });
    var ledger_1_panel354 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": journal350, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": year351, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": number352, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": narration353, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var MovementsByVoucher_grid359 = new Lino.ledger.MovementsByVoucher.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.ledger.MovementsByVoucher.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 83 });
    var ledger_panel360 = new Ext.Panel({ "layout": "vbox", "title": "Buchhaltung", "items": [ ledger_1_panel354, MovementsByVoucher_grid359 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel361 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel349, ledger_panel360 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel361;
    this.before_row_edit = function(record) {
      ItemsByInvoice_grid338.on_master_changed();
      MovementsByVoucher_grid359.on_master_changed();
    }
    Lino.ledger.Invoices.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ui.Home.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var quick_links_htmlbox1764 = new Lino.HtmlBoxPanel({ "flex": 1, "layout": "fit", "name": "quick_links", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "north", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden", "split": true });
    var welcome_htmlbox1765 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "welcome", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "center", "title": "Willkommen", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden", "split": true });
    var main_panel1766 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ quick_links_htmlbox1764, welcome_htmlbox1765 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1766;
    this.before_row_edit = function(record) {
      quick_links_htmlbox1764.refresh();
      welcome_htmlbox1765.refresh();
    }
    Lino.ui.Home.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Journals.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 32,
  initComponent : function() {
    var containing_panel = this;
    var name1244 = new Ext.form.TextField({ "fieldLabel": "Bezeichnung", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1245 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (fr)", "anchor": "-20", "name": "name_fr" });
    var name_et1246 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (et)", "anchor": "-20", "name": "name_et" });
    var name_en1247 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Bezeichnung (en)", "anchor": "-20", "name": "name_en" });
    var main_1_panel1248 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1244, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1245, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1246, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1247, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var trade_type1253 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Handelsart", "name": "trade_type", "selectOnFocus": true, "anchor": "-20", "store": Lino.vat.TradeTypes, "hiddenName": "trade_typeHidden" });
    var voucher_type1254 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "voucher type", "allowBlank": false, "hiddenName": "voucher_typeHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.ledger.VoucherTypes, "name": "voucher_type" });
    var main_panel1255 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 117, "autoScroll": false, "items": [ main_1_panel1248, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": trade_type1253, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": voucher_type1254, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1255;
    this.before_row_edit = function(record) {
    }
    Lino.ledger.Journals.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 21,
  initComponent : function() {
    var containing_panel = this;
    var name510 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var country511 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }) });
    var region512 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }) });
    var city513 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }) });
    var zip_code514 = new Ext.form.TextField({ "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_2_panel515 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country511, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region512, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city513, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code514, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr1520 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile vor Stra\u00dfe","Address line before street") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile vor Stra\u00dfe</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_prefix521 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street522 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no523 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box524 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_4_panel525 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix521, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street522, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no523, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box524, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2530 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var address_box_panel531 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "layout": "form", "title": "Adresse", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name510, "anchor": "-20", "labelAlign": "top" }, address_box_2_panel515, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1520, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel525, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2530, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var id535 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language536 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "et", "Estnisch" ], [ "en", "Englisch" ] ], "name": "language" });
    var info_box_panel537 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id535, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language536, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email540 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-Mail", "anchor": "-20", "name": "email" });
    var url541 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone542 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Telefon", "anchor": "-20", "name": "phone" });
    var gsm543 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var fax544 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Fax", "anchor": "-20", "name": "fax" });
    var contact_box_5_panel545 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm543, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax544, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel548 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "layout": "form", "title": "Kontakt", "items": [ info_box_panel537, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email540, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url541, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone542, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel545 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var general_1_panel552 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ address_box_panel531, contact_box_panel548 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks553 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var is_person554 = new Ext.form.Checkbox({ "boxLabel": "ist eine Person (<a href=\"javascript:Lino.show_mti_child('is_person',Lino.contacts.Persons.detail)\">zeigen</a>)", "listeners": { "render": Lino.quicktip_renderer("ist eine Person","Ob dieser Partner auch eine Person ist.") }, "hideLabel": true, "name": "is_person", "selectOnFocus": true, "anchor": "-20" });
    var is_company555 = new Ext.form.Checkbox({ "boxLabel": "ist eine Organisation (<a href=\"javascript:Lino.show_mti_child('is_company',Lino.contacts.Companies.detail)\">zeigen</a>)", "listeners": { "render": Lino.quicktip_renderer("ist eine Organisation","Ob dieser Partner auch eine Organisation ist.") }, "hideLabel": true, "name": "is_company", "selectOnFocus": true, "anchor": "-20" });
    var bottom_box_2_panel556 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 198, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_person554, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_company555, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var bottom_box_panel559 = new Ext.Panel({ "flex": 54, "layout": "vbox", "items": [ { "items": remarks553, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 }, bottom_box_2_panel556 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var general_panel561 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel552, bottom_box_panel559 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var ledger_InvoicesByPartner_grid579 = new Lino.ledger.InvoicesByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "north", "tools": [ Lino.show_in_own_window_button(Lino.ledger.InvoicesByPartner.grid) ], "master_panel": this });
    var ledger_MovementsByPartner_grid586 = new Lino.ledger.MovementsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "center", "tools": [ Lino.show_in_own_window_button(Lino.ledger.MovementsByPartner.grid) ], "master_panel": this });
    var ledger_panel587 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Buchhaltung", "hideCheckBoxLabels": true, "items": [ ledger_InvoicesByPartner_grid579, ledger_MovementsByPartner_grid586 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var payment_term588 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zahlungsbedingung</span>", "name": "payment_term", "pageSize": 20, "emptyText": "Zahlungsbedingung ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Zahlungsbedingung","The default payment term for sales invoices to this customer.") }, "selectOnFocus": true, "hiddenName": "payment_termHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/payment_term", "method": "GET" }) }) });
    var vat_regime589 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">MWSt.-Regime</span>", "name": "vat_regime", "hiddenName": "vat_regimeHidden", "listeners": { "render": Lino.quicktip_renderer("MWSt.-Regime","The default VAT regime for sales to this customer.") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.vat.VatRegimes });
    var item_vat590 = new Ext.form.Checkbox({ "boxLabel": "item vat", "listeners": { "render": Lino.quicktip_renderer("item vat","The default item VAT setting for sales to this customer.") }, "hideLabel": true, "checked": false, "name": "item_vat", "selectOnFocus": true, "anchor": "-20" });
    var imode591 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Fakturationsmodus", "name": "imode", "pageSize": 20, "emptyText": "Fakturationsmodus ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "imodeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/imode", "method": "GET" }) }) });
    var sales_1_panel592 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 162, "hideCheckBoxLabels": true, "items": [ { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": payment_term588, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_regime589, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": item_vat590, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": imode591, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var sales_InvoicesByPartner_grid622 = new Lino.sales.InvoicesByPartner.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.sales.InvoicesByPartner.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 83 });
    var sales_panel623 = new Ext.Panel({ "layout": "vbox", "title": "Verkauf", "items": [ sales_1_panel592, sales_InvoicesByPartner_grid622 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var tickets_TicketsByPartner_grid756 = new Lino.tickets.TicketsByPartner.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "title": "Tickets", "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.tickets.TicketsByPartner.grid) ], "master_panel": this });
    var main_panel757 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel561, ledger_panel587, sales_panel623, tickets_TicketsByPartner_grid756 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel757;
    this.before_row_edit = function(record) {
      region512.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city513.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city513.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      ledger_InvoicesByPartner_grid579.on_master_changed();
      ledger_MovementsByPartner_grid586.on_master_changed();
      sales_InvoicesByPartner_grid622.on_master_changed();
      tickets_TicketsByPartner_grid756.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country511.on('change',Lino.chooser_handler(region512,'country'));
      country511.on('change',Lino.chooser_handler(city513,'country'));
      region512.on('change',Lino.chooser_handler(city513,'region'));
      Lino.contacts.Partners.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Partners.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.About.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var main_panel134 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "hideCheckBoxLabels": true, "items": [ { "html": "<div class=\"htmlText\"><span>This is <a href=\"http://www.lino-framework.org/autodoc/lino.projects.presto\" target=\"_blank\">Lino Presto</a> 0.1 using <a href=\"http://site.lino-framework.org\" target=\"_blank\">djangosite</a> 0.1.4, <a href=\"http://www.python.org/\" target=\"_blank\">Python</a> 2.7.3, <a href=\"http://www.djangoproject.com\" target=\"_blank\">Django</a> 1.5.1, <a href=\"http://babel.edgewall.org/\" target=\"_blank\">Babel</a> 1.0dev-r661, <a href=\"http://www.lino-framework.org\" target=\"_blank\">Lino</a> 1.6.7, <a href=\"http://jinja.pocoo.org/\" target=\"_blank\">Jinja</a> 2.6, <a href=\"http://sphinx-doc.org/\" target=\"_blank\">Sphinx</a> 1.2b1, <a href=\"http://labix.org/python-dateutil\" target=\"_blank\">python-dateutil</a> 2.1, <a href=\"http://pypi.python.org/pypi/odfpy\" target=\"_blank\">OdfPy</a> ODFPY/0.9.6, <a href=\"http://docutils.sourceforge.net/\" target=\"_blank\">docutils</a> 0.10, <a href=\"https://fedorahosted.org/suds/\" target=\"_blank\">suds</a> 0.4, <a href=\"http://pyyaml.org/\" target=\"_blank\">PyYaml</a> 3.10, <a href=\"http://appyframework.org/pod.html\" target=\"_blank\">Appy</a> 0.8.3 (2013/02/22 15:29)</span><p>Server uptime : <b>Wednesday, May 8, 2013 at 21:20:57.947368</b></p><p>Source timestamps:</p><ul><li>lino : <b>Wednesday, May 8, 2013 at 10:30:20.816304</b></li><li>django : <b>Wednesday, May 8, 2013 at 10:18:59.384324</b></li><li>djangosite : <b>Wednesday, May 8, 2013 at 09:47:36.552380</b></li><li>north : <b>Sunday, May 5, 2013 at 22:52:00.438131</b></li><li>atelier : <b>Thursday, April 25, 2013 at 11:30:28.335334</b></li></ul></div>", "xtype": "label" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel134;
    this.before_row_edit = function(record) {
    }
    Lino.about.About.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 18,
  initComponent : function() {
    var containing_panel = this;
    var name972 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language973 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "et", "Estnisch" ], [ "en", "Englisch" ] ], "name": "language" });
    var email974 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-Mail", "anchor": "-20", "name": "email" });
    var main_2_panel975 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language973, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email974, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type978 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Organisationsart", "name": "type", "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var id979 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_3_panel980 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type978, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id979, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel983 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name972, "anchor": "-20", "labelAlign": "top" }, main_2_panel975, main_3_panel980 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel983;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Companies.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 18,
  initComponent : function() {
    var containing_panel = this;
    var name909 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var country910 = new Lino.TwinCombo({ "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Land ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/country", "method": "GET" }) }) });
    var region911 = new Lino.TwinCombo({ "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/region", "method": "GET" }) }) });
    var city912 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Ort", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Ort ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/city", "method": "GET" }) }) });
    var zip_code913 = new Ext.form.TextField({ "fieldLabel": "Postleitzahl", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_2_panel914 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country910, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region911, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city912, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code913, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr1919 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile vor Stra\u00dfe","Address line before street") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile vor Stra\u00dfe</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_prefix920 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street921 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no922 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Nr.","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box923 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_4_panel924 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix920, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street921, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no922, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box923, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2929 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var address_box_panel930 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "layout": "form", "title": "Adresse", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name909, "anchor": "-20", "labelAlign": "top" }, address_box_2_panel914, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1919, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel924, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2929, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var id934 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language935 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "et", "Estnisch" ], [ "en", "Englisch" ] ], "name": "language" });
    var info_box_panel936 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id934, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language935, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email939 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-Mail", "anchor": "-20", "name": "email" });
    var url940 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone941 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Telefon", "anchor": "-20", "name": "phone" });
    var gsm942 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var fax943 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Fax", "anchor": "-20", "name": "fax" });
    var contact_box_5_panel944 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm942, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax943, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel947 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "layout": "form", "title": "Kontakt", "items": [ info_box_panel936, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email939, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url940, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone941, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel944 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var general_1_panel951 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ address_box_panel930, contact_box_panel947 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var type952 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Organisationsart", "name": "type", "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var vat_id953 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "MWSt.-Nr.", "anchor": "-20", "name": "vat_id" });
    var bottom_box_1_panel954 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type952, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id953, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks957 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Bemerkungen", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var contacts_RolesByCompany_grid962 = new Lino.contacts.RolesByCompany.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 42 });
    var bottom_box_2_panel963 = new Ext.Panel({ "flex": 83, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": remarks957, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 57 }, contacts_RolesByCompany_grid962 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var bottom_box_panel965 = new Ext.Panel({ "flex": 54, "border": false, "layout": "vbox", "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ bottom_box_1_panel954, bottom_box_2_panel963 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": true, "labelAlign": "top" });
    var general_panel966 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel951, bottom_box_panel965 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var ledger_InvoicesByPartner_grid967 = new Lino.ledger.InvoicesByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "north", "tools": [ Lino.show_in_own_window_button(Lino.ledger.InvoicesByPartner.grid) ], "master_panel": this });
    var ledger_MovementsByPartner_grid968 = new Lino.ledger.MovementsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "split": true, "containing_panel": this, "region": "center", "tools": [ Lino.show_in_own_window_button(Lino.ledger.MovementsByPartner.grid) ], "master_panel": this });
    var ledger_panel969 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Buchhaltung", "hideCheckBoxLabels": true, "items": [ ledger_InvoicesByPartner_grid967, ledger_MovementsByPartner_grid968 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var tickets_TicketsByPartner_grid970 = new Lino.tickets.TicketsByPartner.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "title": "Tickets", "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.tickets.TicketsByPartner.grid) ], "master_panel": this });
    var main_panel971 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel966, ledger_panel969, tickets_TicketsByPartner_grid970 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel971;
    this.before_row_edit = function(record) {
      region911.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city912.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city912.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByCompany_grid962.on_master_changed();
      ledger_InvoicesByPartner_grid967.on_master_changed();
      ledger_MovementsByPartner_grid968.on_master_changed();
      tickets_TicketsByPartner_grid970.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country910.on('change',Lino.chooser_handler(region911,'country'));
      country910.on('change',Lino.chooser_handler(city912,'country'));
      region911.on('change',Lino.chooser_handler(city912,'region'));
      Lino.contacts.Companies.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Companies.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.Models.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var app_disp1744 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "app_label", "name": "app", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var name_disp1745 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "name", "name": "name", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var docstring_disp1746 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "docstring", "name": "docstring", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var rows1747 = new Ext.form.NumberField({ "disabled": true, "fieldLabel": "Rows", "anchor": "-20", "name": "rows" });
    var main_1_panel1748 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_disp1744, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_disp1745, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": docstring_disp1746, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": rows1747, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var about_FieldsByModel_grid1757 = new Lino.about.FieldsByModel.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.about.FieldsByModel.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 62 });
    var main_panel1758 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1748, about_FieldsByModel_grid1757 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1758;
    this.before_row_edit = function(record) {
      about_FieldsByModel_grid1757.on_master_changed();
    }
    Lino.about.Models.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.sales.Invoices.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 41,
  initComponent : function() {
    var containing_panel = this;
    var date202 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "Datum", "anchor": "-20", "name": "date" });
    var partner203 = new Lino.TwinCombo({ "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Partner ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/partner", "method": "GET" }) }), "name": "partner" });
    var vat_regime204 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "MWSt.-Regime", "name": "vat_regime", "selectOnFocus": true, "anchor": "-20", "store": Lino.vat.VatRegimes, "hiddenName": "vat_regimeHidden" });
    var invoice_header_1_panel205 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date202, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner203, "labelAlign": "top" }, { "flex": 46, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_regime204, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var subject209 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Betreff", "anchor": "-20", "name": "subject" });
    var your_ref210 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Ihr Zeichen", "anchor": "-20", "name": "your_ref" });
    var invoice_header_2_panel211 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject209, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": your_ref210, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var payment_term214 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Zahlungsbedingung", "name": "payment_term", "pageSize": 20, "emptyText": "Zahlungsbedingung ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "payment_termHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/payment_term", "method": "GET" }) }) });
    var due_date215 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Zahlungsziel", "anchor": "-20", "name": "due_date" });
    var invoice_header_3_panel216 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": payment_term214, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": due_date215, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var imode219 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Fakturationsmodus", "name": "imode", "pageSize": 20, "emptyText": "Fakturationsmodus ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "imodeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/imode", "method": "GET" }) }) });
    var shipping_mode220 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Lieferart", "name": "shipping_mode", "pageSize": 20, "emptyText": "Lieferart ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "shipping_modeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/shipping_mode", "method": "GET" }) }) });
    var invoice_header_4_panel221 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": imode219, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": shipping_mode220, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var invoice_header_panel224 = new Ext.form.FieldSet({ "flex": 75, "autoHeight": true, "layout": "form", "title": "Kopfdaten", "items": [ invoice_header_1_panel205, invoice_header_2_panel211, invoice_header_3_panel216, invoice_header_4_panel221 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var total_base225 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Total zzgl. MWSt.", "name": "total_base", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var total_vat226 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "MWSt.", "name": "total_vat", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var total_incl227 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Total inkl. MWSt.", "name": "total_incl", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var workflow_buttons_disp228 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var totals_panel229 = new Ext.form.FieldSet({ "flex": 25, "autoHeight": true, "layout": "form", "title": "Summen", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_base225, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_vat226, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_incl227, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp228, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 162, "border": false, "labelAlign": "top" });
    var general_1_panel234 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ invoice_header_panel224, totals_panel229 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ItemsByInvoice_grid246 = new Lino.sales.ItemsByInvoice.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.sales.ItemsByInvoice.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 45 });
    var general_panel247 = new Ext.Panel({ "layout": "vbox", "title": "Allgemein", "items": [ general_1_panel234, ItemsByInvoice_grid246 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var id248 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var user249 = new Lino.TwinCombo({ "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Benutzer ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/user", "method": "GET" }) }) });
    var language250 = new Lino.ChoicesFieldElement({ "fieldLabel": "Sprache", "allowBlank": false, "value": "de", "hiddenName": "languageHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "et", "Estnisch" ], [ "en", "Englisch" ] ], "name": "language" });
    var project251 = new Lino.TwinCombo({ "fieldLabel": "Projekt", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail)}, "emptyText": "Projekt ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/project", "method": "GET" }) }) });
    var item_vat252 = new Ext.form.Checkbox({ "boxLabel": "Preis inkl. MWSt.", "listeners": { "render": Lino.quicktip_renderer("Preis inkl. MWSt.","Ob St\u00fcckpreise sich inkl. MWSt. verstehen.") }, "hideLabel": true, "checked": false, "name": "item_vat", "selectOnFocus": true, "anchor": "-20" });
    var more_1_panel253 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 162, "hideCheckBoxLabels": true, "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id248, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user249, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language250, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project251, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": item_vat252, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var intro259 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Introductive Text", "anchor": "-20 -10", "growMax": 2000, "name": "intro" });
    var more_panel260 = new Ext.Panel({ "layout": "vbox", "title": "Mehr", "items": [ more_1_panel253, { "items": intro259, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "labelWidth": 162, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var journal262 = new Lino.TwinCombo({ "fieldLabel": "Journal", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail)}, "emptyText": "Journal ausw\u00e4hlen...", "selectOnFocus": true, "hiddenName": "journalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/journal", "method": "GET" }) }), "name": "journal" });
    var year263 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Gesch\u00e4ftsjahr", "name": "year", "selectOnFocus": true, "anchor": "-20", "store": Lino.ledger.FiscalYears, "hiddenName": "yearHidden" });
    var number264 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "number", "anchor": "-20", "name": "number" });
    var narration265 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Narration", "anchor": "-20", "name": "narration" });
    var ledger_1_panel266 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": journal262, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": year263, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": number264, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": narration265, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ledger_MovementsByVoucher_grid276 = new Lino.ledger.MovementsByVoucher.GridPanel({ "tools": [ Lino.show_in_own_window_button(Lino.ledger.MovementsByVoucher.grid) ], "containing_panel": this, "hide_top_toolbar": true, "master_panel": this, "flex": 83 });
    var ledger_panel277 = new Ext.Panel({ "layout": "vbox", "title": "Buchhaltung", "items": [ ledger_1_panel266, ledger_MovementsByVoucher_grid276 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel278 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel247, more_panel260, ledger_panel277 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel278;
    this.before_row_edit = function(record) {
      ItemsByInvoice_grid246.on_master_changed();
      ledger_MovementsByVoucher_grid276.on_master_changed();
    }
    Lino.sales.Invoices.DetailFormPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.GuestStates.wf2 = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Guests.wf2_ActionFormPanel({});
});

// js_render_GridPanel_class ui.SiteConfigs
Lino.ui.SiteConfigs.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/ui/SiteConfigs",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": "do_build", "menu_item_text": "Site-Cache rekonstruieren", "must_save": true, "panel_btn_handler": Lino.row_action_handler('do_build','GET'), "text": "Site-Cache rekonstruieren", "overflowText": "Site-Cache rekonstruieren", "auto_save": true } ],
  title : "site configs",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "default_build_method" }, 'default_build_methodHidden', { "type": "int", "name": "next_partner_id" }, { "name": "site_company" }, 'site_companyHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 1,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.SiteConfigs.detail;
    var ww = this.containing_window;
    var id1773 = new Ext.form.NumberField({ "selectOnFocus": true });
    var default_build_method1774 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "value": "appyodt" });
    var next_partner_id1775 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 100 });
    var site_company1776 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/SiteConfigs/site_company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisation ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1773, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Standard-Konstruktionsmethode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "default_build_method", "editor": default_build_method1774 }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "The next automatic id for a manually created partner.", "dataIndex": "next_partner_id", "width": Lino.chars2width(6), "editor": next_partner_id1775 }), { "colIndex": 3, "sortable": true, "header": "Firma, die diesen Site betreibt", "editable": true, "tooltip": "The Company to be used as sender in documents.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('site_companyHidden','Lino.contacts.Companies.detail'), "editor": site_company1776, "dataIndex": "site_company" } ];
    Lino.ui.SiteConfigs.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.ui.SiteConfigs.detailPanel = Ext.extend(Lino.ui.SiteConfigs.DetailFormPanel,{
  empty_title: "Detail site configs",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "do_build", "menu_item_text": "Site-Cache rekonstruieren", "must_save": true, "panel_btn_handler": Lino.row_action_handler('do_build','GET'), "text": "Site-Cache rekonstruieren", "overflowText": "Site-Cache rekonstruieren", "auto_save": true } ],
  ls_url: "/ui/SiteConfigs",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.SiteConfigs.detail;
    Lino.ui.SiteConfigs.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.ui.SiteConfigs.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.ui.SiteConfigs.detailPanel(p);
});
Lino.ui.SiteConfigs.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.ui.SiteConfigs.GridPanel(p);
});

// js_render_GridPanel_class ui.ContentTypes
Lino.ui.ContentTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/ui/ContentTypes",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Inhaltstypen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "app_label" }, { "name": "model" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 5,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.ContentTypes.detail;
    this.ls_insert_handler = Lino.ui.ContentTypes.insert;
    var ww = this.containing_window;
    var id1778 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1779 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var app_label1780 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var model1781 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1778, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1779 }, { "colIndex": 2, "sortable": true, "header": "app label", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "app_label", "editor": app_label1780 }, { "colIndex": 3, "sortable": true, "header": "Python Modell-Klassenname", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "model", "editor": model1781 } ];
    Lino.ui.ContentTypes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.ui.ContentTypes.insertPanel = Ext.extend(Lino.ui.ContentTypes.DetailFormPanel,{
  empty_title: "Neu Inhaltstypen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/ui/ContentTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.ContentTypes.detail;
    this.ls_insert_handler = Lino.ui.ContentTypes.insert;
    Lino.ui.ContentTypes.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.ui.ContentTypes.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.ui.ContentTypes.insertPanel(p);
});

Lino.ui.ContentTypes.detailPanel = Ext.extend(Lino.ui.ContentTypes.DetailFormPanel,{
  empty_title: "Detail Inhaltstypen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/ui/ContentTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.ContentTypes.detail;
    this.ls_insert_handler = Lino.ui.ContentTypes.insert;
    Lino.ui.ContentTypes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.ui.ContentTypes.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ui.ContentTypes.detailPanel(p);
});
Lino.ui.ContentTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ui.ContentTypes.GridPanel(p);
});

// js_render_GridPanel_class ui.HelpTexts
Lino.ui.HelpTexts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/ui/HelpTexts",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Hilfetexte",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "field" }, { "name": "verbose_name" }, { "name": "help_text" }, { "type": "int", "name": "id" }, { "name": "content_type" }, 'content_typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 2,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    var ww = this.containing_window;
    var field1783 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/HelpTexts/field", "method": "GET" }) }) });
    var verbose_name1784 = new Ext.form.TextField({ "disabled": true, "maxLength": 200 });
    var help_text1785 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var id1786 = new Ext.form.NumberField({ "selectOnFocus": true });
    var content_type1787 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/HelpTexts/content_type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
      field1783.setContextValue('content_type',record ? record.data['content_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      content_type1787.on('change',Lino.chooser_handler(field1783,'content_type'));
      Lino.ui.HelpTexts.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Feld", "editable": true, "tooltip": "The name of the field.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "field", "editor": field1783 }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "verbose_name", "header": "Feldbezeichnung", "editable": false }, { "colIndex": 2, "sortable": false, "header": "Hilfetext", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": help_text1785, "dataIndex": "help_text" }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1786, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Modell", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('content_typeHidden','Lino.ui.ContentTypes.detail'), "editor": content_type1787, "dataIndex": "content_type" } ];
    Lino.ui.HelpTexts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ui.HelpTexts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ui.HelpTexts.GridPanel(p);
});

// js_render_GridPanel_class ui.TextFieldTemplates
Lino.ui.TextFieldTemplates.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/ui/TextFieldTemplates",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Einf\u00fcgetexte",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "name" }, { "name": "description" }, { "name": "team" }, 'teamHidden', { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 3,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.TextFieldTemplates.detail;
    this.ls_insert_handler = Lino.ui.TextFieldTemplates.insert;
    var ww = this.containing_window;
    var id1789 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1790 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/TextFieldTemplates/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var name1791 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var description1792 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var team1793 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/TextFieldTemplates/team", "method": "GET" }) }), "pageSize": 20, "emptyText": "Team ausw\u00e4hlen..." });
    var text1794 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Vorlagentext" });
    this.before_row_edit = function(record) {
      text1794.refresh();
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1789, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1790, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1791 }, { "colIndex": 3, "sortable": false, "header": "Beschreibung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": description1792, "dataIndex": "description" }, { "colIndex": 4, "sortable": true, "header": "Team", "editable": true, "tooltip": "If not empty, then this template is reserved to members of this team.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "team", "editor": team1793 }, { "colIndex": 5, "sortable": false, "header": "text", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": text1794, "dataIndex": "text" } ];
    Lino.ui.TextFieldTemplates.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.ui.TextFieldTemplates.insertPanel = Ext.extend(Lino.ui.TextFieldTemplates.InsertFormPanel,{
  empty_title: "Neu Einf\u00fcgetexte",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/ui/TextFieldTemplates",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.TextFieldTemplates.detail;
    this.ls_insert_handler = Lino.ui.TextFieldTemplates.insert;
    Lino.ui.TextFieldTemplates.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.ui.TextFieldTemplates.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.ui.TextFieldTemplates.insertPanel(p);
});

Lino.ui.TextFieldTemplates.detailPanel = Ext.extend(Lino.ui.TextFieldTemplates.DetailFormPanel,{
  empty_title: "Detail Einf\u00fcgetexte",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/ui/TextFieldTemplates",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.TextFieldTemplates.detail;
    this.ls_insert_handler = Lino.ui.TextFieldTemplates.insert;
    Lino.ui.TextFieldTemplates.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.ui.TextFieldTemplates.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ui.TextFieldTemplates.detailPanel(p);
});
Lino.ui.TextFieldTemplates.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ui.TextFieldTemplates.GridPanel(p);
});

// js_render_GridPanel_class users.Users
Lino.users.Users.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/users/Users",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Erinnerungen aktualisieren", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET'), "text": "Erinnerungen aktualisieren", "overflowText": "Erinnerungen aktualisieren", "auto_save": true } ],
  title : "Benutzer",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "first_name" }, { "name": "last_name" }, { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "password" }, { "name": "email" }, { "name": "remarks" }, { "name": "language" }, 'languageHidden', { "name": "partner" }, 'partnerHidden', { "name": "access_class" }, 'access_classHidden', { "name": "calendar" }, 'calendarHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 7,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 20,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    var ww = this.containing_window;
    var username1796 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile1797 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.lino.UserProfiles });
    var first_name1798 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var last_name1799 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var id1800 = new Ext.form.NumberField({ "selectOnFocus": true });
    var created1801 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified1802 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var password1803 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 128 });
    var email1804 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var remarks1805 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var language1806 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "et", "Estnisch" ], [ "en", "Englisch" ] ] });
    var partner1807 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var access_class1808 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.AccessClasses });
    var calendar1809 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Benutzername", "editable": true, "tooltip": "\n        Required. Must be unique. \n        ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "username", "editor": username1796 }, { "colIndex": 1, "sortable": true, "header": "Benutzerprofil", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(23), "dataIndex": "profile", "editor": profile1797 }, { "colIndex": 2, "sortable": true, "header": "Vorname", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name1798 }, { "colIndex": 3, "sortable": true, "header": "Familienname", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name1799 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1800, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(17), "colIndex": 5, "sortable": true, "dataIndex": "created", "header": "Erstellt", "editable": false }, { "width": Lino.chars2width(17), "colIndex": 6, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "editable": false }, { "colIndex": 7, "sortable": true, "header": "Passwort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "password", "hidden": true, "editor": password1803 }, { "colIndex": 8, "sortable": true, "header": "e-mail address", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email1804 }, { "colIndex": 9, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": remarks1805, "dataIndex": "remarks" }, { "colIndex": 10, "sortable": true, "header": "Sprache", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language1806 }, { "colIndex": 11, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner1807, "dataIndex": "partner" }, { "colIndex": 12, "sortable": true, "header": "Standardm\u00e4\u00dfige Zugriffsklasse", "editable": true, "tooltip": "Die standardm\u00e4\u00dfige Zugriffsklasse f\u00fcr Ihre Termine und Aufgaben", "filter": { "type": "string" }, "width": Lino.chars2width(35), "dataIndex": "access_class", "editor": access_class1808 }, { "colIndex": 13, "sortable": true, "header": "Standard-Kalender", "editable": true, "tooltip": "The default calendar for your events and tasks.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.Calendars.detail'), "editor": calendar1809, "dataIndex": "calendar" } ];
    Lino.users.Users.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.users.Users.insertPanel = Ext.extend(Lino.users.Users.InsertFormPanel,{
  empty_title: "Neu Benutzer",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/users/Users",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.Users.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Users.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.Users.insertPanel(p);
});

Lino.users.Users.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Detail Benutzer",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Erinnerungen aktualisieren", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET'), "text": "Erinnerungen aktualisieren", "overflowText": "Erinnerungen aktualisieren", "auto_save": true } ],
  ls_url: "/users/Users",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.Users.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Users.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Users.detailPanel(p);
});
Lino.users.Users.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Users.GridPanel(p);
});

// js_render_GridPanel_class users.MySettings
Lino.users.MySettings.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/users/MySettings",
  ls_bbar_actions : [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Erinnerungen aktualisieren", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET'), "text": "Erinnerungen aktualisieren", "overflowText": "Erinnerungen aktualisieren", "auto_save": true } ],
  title : "Benutzer",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "first_name" }, { "name": "last_name" }, { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "password" }, { "name": "email" }, { "name": "remarks" }, { "name": "language" }, 'languageHidden', { "name": "partner" }, 'partnerHidden', { "name": "access_class" }, 'access_classHidden', { "name": "calendar" }, 'calendarHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 7,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 20,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    var ww = this.containing_window;
    var username135 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile136 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.lino.UserProfiles });
    var first_name137 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var last_name138 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var id139 = new Ext.form.NumberField({ "selectOnFocus": true });
    var created140 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified141 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var password142 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 128 });
    var email143 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var remarks144 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var language145 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "et", "Estnisch" ], [ "en", "Englisch" ] ] });
    var partner146 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var access_class147 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.AccessClasses });
    var calendar148 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Benutzername", "editable": true, "tooltip": "\n        Required. Must be unique. \n        ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "username", "editor": username135 }, { "colIndex": 1, "sortable": true, "header": "Benutzerprofil", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(23), "dataIndex": "profile", "editor": profile136 }, { "colIndex": 2, "sortable": true, "header": "Vorname", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name137 }, { "colIndex": 3, "sortable": true, "header": "Familienname", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name138 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id139, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(17), "colIndex": 5, "sortable": true, "dataIndex": "created", "header": "Erstellt", "editable": false }, { "width": Lino.chars2width(17), "colIndex": 6, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "editable": false }, { "colIndex": 7, "sortable": true, "header": "Passwort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "password", "hidden": true, "editor": password142 }, { "colIndex": 8, "sortable": true, "header": "e-mail address", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email143 }, { "colIndex": 9, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": remarks144, "dataIndex": "remarks" }, { "colIndex": 10, "sortable": true, "header": "Sprache", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language145 }, { "colIndex": 11, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner146, "dataIndex": "partner" }, { "colIndex": 12, "sortable": true, "header": "Standardm\u00e4\u00dfige Zugriffsklasse", "editable": true, "tooltip": "Die standardm\u00e4\u00dfige Zugriffsklasse f\u00fcr Ihre Termine und Aufgaben", "filter": { "type": "string" }, "width": Lino.chars2width(35), "dataIndex": "access_class", "editor": access_class147 }, { "colIndex": 13, "sortable": true, "header": "Standard-Kalender", "editable": true, "tooltip": "The default calendar for your events and tasks.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.Calendars.detail'), "editor": calendar148, "dataIndex": "calendar" } ];
    Lino.users.MySettings.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Benutzer",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Erinnerungen aktualisieren", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET'), "text": "Erinnerungen aktualisieren", "overflowText": "Erinnerungen aktualisieren", "auto_save": true } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});

Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Benutzer",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Erinnerungen aktualisieren", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET'), "text": "Erinnerungen aktualisieren", "overflowText": "Erinnerungen aktualisieren", "auto_save": true } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});

// js_render_GridPanel_class users.UsersOverview
Lino.users.UsersOverview.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/users/UsersOverview",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Erinnerungen aktualisieren", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET'), "text": "Erinnerungen aktualisieren", "overflowText": "Erinnerungen aktualisieren", "auto_save": true } ],
  title : "Benutzer",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "language" }, 'languageHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 7,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.UsersOverview.detail;
    this.ls_insert_handler = Lino.users.UsersOverview.insert;
    var ww = this.containing_window;
    var username168 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile169 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.lino.UserProfiles });
    var language170 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "et", "Estnisch" ], [ "en", "Englisch" ] ] });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Benutzername", "editable": true, "tooltip": "\n        Required. Must be unique. \n        ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "username", "editor": username168 }, { "colIndex": 1, "sortable": true, "header": "Benutzerprofil", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(23), "dataIndex": "profile", "editor": profile169 }, { "colIndex": 2, "sortable": true, "header": "Sprache", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language170 } ];
    Lino.users.UsersOverview.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.users.UsersOverview.insertPanel = Ext.extend(Lino.users.Users.InsertFormPanel,{
  empty_title: "Neu Benutzer",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/users/UsersOverview",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.UsersOverview.detail;
    this.ls_insert_handler = Lino.users.UsersOverview.insert;
    Lino.users.UsersOverview.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.users.UsersOverview.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.UsersOverview.insertPanel(p);
});

Lino.users.UsersOverview.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Detail Benutzer",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Erinnerungen aktualisieren", "must_save": true, "panel_btn_handler": Lino.row_action_handler('update_reminders','GET'), "text": "Erinnerungen aktualisieren", "overflowText": "Erinnerungen aktualisieren", "auto_save": true } ],
  ls_url: "/users/UsersOverview",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.UsersOverview.detail;
    this.ls_insert_handler = Lino.users.UsersOverview.insert;
    Lino.users.UsersOverview.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.UsersOverview.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.UsersOverview.detailPanel(p);
});
Lino.users.UsersOverview.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.UsersOverview.GridPanel(p);
});

// js_render_GridPanel_class users.Teams
Lino.users.Teams.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/users/Teams",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Teams",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 9,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var id1811 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1812 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr1813 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et1814 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en1815 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1811, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1812 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1813 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et1814 }, { "colIndex": 4, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en1815 } ];
    Lino.users.Teams.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Teams.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Teams.GridPanel(p);
});

// js_render_GridPanel_class users.Memberships
Lino.users.Memberships.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/users/Memberships",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Team-Mitglieder",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "team" }, 'teamHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 6,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var id1817 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1818 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Memberships/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var team1819 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Memberships/team", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Team ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1817, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1818, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "Team", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "team", "editor": team1819 } ];
    Lino.users.Memberships.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Memberships.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Memberships.GridPanel(p);
});

// js_render_GridPanel_class users.Authorities
Lino.users.Authorities.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/users/Authorities",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Vollmachten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "authorized" }, 'authorizedHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 8,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var id1821 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1822 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Authorities/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var authorized1823 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Authorities/authorized", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
      authorized1823.setContextValue('user',record ? record.data['userHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      user1822.on('change',Lino.chooser_handler(authorized1823,'user'));
      Lino.users.Authorities.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1821, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1822, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "Benutzer", "editable": true, "tooltip": "The user who gets authority to act in your name.", "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('authorizedHidden','Lino.users.Users.detail'), "editor": authorized1823, "dataIndex": "authorized" } ];
    Lino.users.Authorities.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Authorities.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Authorities.GridPanel(p);
});

// js_render_GridPanel_class countries.Languages
Lino.countries.Languages.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/countries/Languages",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Sprachen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "id" }, { "name": "iso2" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 11,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    var ww = this.containing_window;
    var name1825 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr1826 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et1827 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en1828 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1829 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "allowBlank": false, "maxLength": 3 });
    var iso21830 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(2), "maxLength": 2 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1825 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1826 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et1827 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en1828 }, { "colIndex": 4, "sortable": true, "header": "id", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "id", "editor": id1829 }, { "colIndex": 5, "sortable": true, "header": "iso2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "iso2", "editor": iso21830 } ];
    Lino.countries.Languages.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Languages.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Languages.GridPanel(p);
});

// js_render_GridPanel_class countries.Countries
Lino.countries.Countries.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/countries/Countries",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "L\u00e4nder",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "isocode" }, { "name": "short_code" }, { "name": "iso3" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 10,
  ls_id_property : "isocode",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    var ww = this.containing_window;
    var name1832 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr1833 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et1834 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en1835 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var isocode1836 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "allowBlank": false, "maxLength": 4 });
    var short_code1837 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    var iso31838 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "maxLength": 3 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1832 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1833 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et1834 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en1835 }, { "colIndex": 4, "sortable": true, "header": "ISO-Code", "editable": true, "tooltip": "        The two-letter code for this country as defined by ISO 3166-1. \n        For countries that no longer exist it may be a 4-letter code.", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "isocode", "editor": isocode1836 }, { "colIndex": 5, "sortable": true, "header": "Short code", "editable": true, "tooltip": "A short abbreviation for regional usage. Obsolete.", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "short_code", "editor": short_code1837 }, { "colIndex": 6, "sortable": true, "header": "ISO3-Code", "editable": true, "tooltip": "The three-letter code for this country as defined by ISO 3166-1.", "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "iso3", "editor": iso31838 } ];
    Lino.countries.Countries.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Countries.insertPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "Neu L\u00e4nder",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/countries/Countries",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    Lino.countries.Countries.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Countries.insertPanel(p);
});

Lino.countries.Countries.detailPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "Detail L\u00e4nder",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/countries/Countries",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    Lino.countries.Countries.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.detailPanel(p);
});
Lino.countries.Countries.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.GridPanel(p);
});

// js_render_GridPanel_class countries.Cities
Lino.countries.Cities.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/countries/Cities",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Orte",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "country" }, 'countryHidden', { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "type" }, 'typeHidden', { "name": "zip_code" }, { "type": "int", "name": "id" }, { "name": "parent" }, 'parentHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 9,
  ls_grid_configs : [  ],
  content_type : 12,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 13,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Cities.detail;
    this.ls_insert_handler = Lino.countries.Cities.insert;
    var ww = this.containing_window;
    var country1840 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/country", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var name1841 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr1842 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et1843 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en1844 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type1845 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/type", "method": "GET" }) }) });
    var zip_code1846 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "maxLength": 8 });
    var id1847 = new Ext.form.NumberField({ "selectOnFocus": true });
    var parent1848 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/parent", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
      type1845.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country1840.on('change',Lino.chooser_handler(type1845,'country'));
      Lino.countries.Cities.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Land", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country1840, "dataIndex": "country" }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1841 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1842 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et1843 }, { "colIndex": 4, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en1844 }, { "colIndex": 5, "sortable": true, "header": "Ortsart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "type", "editor": type1845 }, { "colIndex": 6, "sortable": true, "header": "zip code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "zip_code", "editor": zip_code1846 }, new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1847, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 8, "sortable": true, "header": "Teil von", "editable": true, "tooltip": "The superordinate geographic place of which this place is a part.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('parentHidden','Lino.countries.Cities.detail'), "editor": parent1848, "dataIndex": "parent" } ];
    Lino.countries.Cities.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Cities.insertPanel = Ext.extend(Lino.countries.Cities.DetailFormPanel,{
  empty_title: "Neu Orte",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/countries/Cities",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Cities.detail;
    this.ls_insert_handler = Lino.countries.Cities.insert;
    Lino.countries.Cities.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Cities.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Cities.insertPanel(p);
});

Lino.countries.Cities.detailPanel = Ext.extend(Lino.countries.Cities.DetailFormPanel,{
  empty_title: "Detail Orte",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/countries/Cities",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Cities.detail;
    this.ls_insert_handler = Lino.countries.Cities.insert;
    Lino.countries.Cities.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Cities.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Cities.detailPanel(p);
});
Lino.countries.Cities.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Cities.GridPanel(p);
});

// js_render_GridPanel_class properties.PropGroups
Lino.properties.PropGroups.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/properties/PropGroups",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Eigenschaftsgruppen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 14,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropGroups.detail;
    this.ls_insert_handler = Lino.properties.PropGroups.insert;
    var ww = this.containing_window;
    var id1850 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1851 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr1852 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et1853 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en1854 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1850, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1851 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1852 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et1853 }, { "colIndex": 4, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en1854 } ];
    Lino.properties.PropGroups.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropGroups.insertPanel = Ext.extend(Lino.properties.PropGroups.DetailFormPanel,{
  empty_title: "Neu Eigenschaftsgruppen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/properties/PropGroups",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropGroups.detail;
    this.ls_insert_handler = Lino.properties.PropGroups.insert;
    Lino.properties.PropGroups.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropGroups.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.properties.PropGroups.insertPanel(p);
});

Lino.properties.PropGroups.detailPanel = Ext.extend(Lino.properties.PropGroups.DetailFormPanel,{
  empty_title: "Detail Eigenschaftsgruppen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/properties/PropGroups",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropGroups.detail;
    this.ls_insert_handler = Lino.properties.PropGroups.insert;
    Lino.properties.PropGroups.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropGroups.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropGroups.detailPanel(p);
});
Lino.properties.PropGroups.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropGroups.GridPanel(p);
});

// js_render_GridPanel_class properties.PropTypes
Lino.properties.PropTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/properties/PropTypes",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Eigenschafts-Datentypen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "choicelist" }, 'choicelistHidden', { "name": "default_value" }, 'default_valueHidden', { "type": "boolean", "name": "limit_to_choices" }, { "type": "boolean", "name": "multiple_choices" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 15,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 12,
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropTypes.detail;
    this.ls_insert_handler = Lino.properties.PropTypes.insert;
    var ww = this.containing_window;
    var id1856 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1857 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr1858 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et1859 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en1860 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var choicelist1861 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "countries.CityTypes", "CityTypes" ], [ "lino.Genders", "Genders" ], [ "lino.UserGroups", "User Groups" ], [ "lino.UserLevels", "Benutzer-Levels" ], [ "lino.UserProfiles", "Benutzerprofile" ], [ "properties.DoYouLike", "DoYouLike" ], [ "properties.HowWell", "HowWell" ] ] });
    var default_value1862 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropTypes/default_value", "method": "GET" }) }) });
    var limit_to_choices1863 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var multiple_choices1864 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
      default_value1862.setContextValue('choicelist',record ? record.data['choicelistHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      choicelist1861.on('change',Lino.chooser_handler(default_value1862,'choicelist'));
      Lino.properties.PropTypes.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1856, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1857 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1858 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et1859 }, { "colIndex": 4, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en1860 }, { "colIndex": 5, "sortable": true, "header": "Auswahliste", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "choicelist", "editor": choicelist1861 }, { "colIndex": 6, "sortable": true, "header": "Standardwert", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "default_value", "editor": default_value1862 }, { "colIndex": 7, "sortable": false, "xtype": "checkcolumn", "header": "Beschr\u00e4nken auf Auswahl", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "limit_to_choices" }, { "colIndex": 8, "sortable": false, "xtype": "checkcolumn", "header": "Mehrfachauswahl", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "multiple_choices" } ];
    Lino.properties.PropTypes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropTypes.insertPanel = Ext.extend(Lino.properties.PropTypes.DetailFormPanel,{
  empty_title: "Neu Eigenschafts-Datentypen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/properties/PropTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropTypes.detail;
    this.ls_insert_handler = Lino.properties.PropTypes.insert;
    Lino.properties.PropTypes.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropTypes.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.properties.PropTypes.insertPanel(p);
});

Lino.properties.PropTypes.detailPanel = Ext.extend(Lino.properties.PropTypes.DetailFormPanel,{
  empty_title: "Detail Eigenschafts-Datentypen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/properties/PropTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropTypes.detail;
    this.ls_insert_handler = Lino.properties.PropTypes.insert;
    Lino.properties.PropTypes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropTypes.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropTypes.detailPanel(p);
});
Lino.properties.PropTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropTypes.GridPanel(p);
});

// js_render_GridPanel_class properties.Properties
Lino.properties.Properties.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/properties/Properties",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Eigenschaften",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "group" }, 'groupHidden', { "name": "type" }, 'typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 13,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 10,
  initComponent : function() {
    var ww = this.containing_window;
    var id1866 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1867 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr1868 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et1869 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en1870 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var group1871 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/Properties/group", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschaftsgruppe ausw\u00e4hlen..." });
    var type1872 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/Properties/type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschafts-Datentyp ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1866, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1867 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1868 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et1869 }, { "colIndex": 4, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en1870 }, { "colIndex": 5, "sortable": true, "header": "Eigenschaftsgruppe", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('groupHidden','Lino.properties.PropGroups.detail'), "editor": group1871, "dataIndex": "group" }, { "colIndex": 6, "sortable": true, "header": "Eigenschafts-Datentyp", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('typeHidden','Lino.properties.PropTypes.detail'), "editor": type1872, "dataIndex": "type" } ];
    Lino.properties.Properties.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.Properties.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.Properties.GridPanel(p);
});

// js_render_GridPanel_class properties.PropChoices
Lino.properties.PropChoices.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/properties/PropChoices",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Auswahlm\u00f6glichkeiten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "type" }, 'typeHidden', { "name": "value" }, { "name": "text" }, { "name": "text_fr" }, { "name": "text_et" }, { "name": "text_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 16,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    var ww = this.containing_window;
    var id1874 = new Ext.form.NumberField({ "selectOnFocus": true });
    var type1875 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropChoices/type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Eigenschafts-Datentyp ausw\u00e4hlen..." });
    var value1876 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var text1877 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_fr1878 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_et1879 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_en1880 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1874, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Eigenschafts-Datentyp", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('typeHidden','Lino.properties.PropTypes.detail'), "editor": type1875, "dataIndex": "type" }, { "colIndex": 2, "sortable": true, "header": "Wert", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "value", "editor": value1876 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text", "editor": text1877 }, { "colIndex": 4, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text_fr", "editor": text_fr1878 }, { "colIndex": 5, "sortable": true, "header": "Bezeichnung (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text_et", "editor": text_et1879 }, { "colIndex": 6, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text_en", "editor": text_en1880 } ];
    Lino.properties.PropChoices.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropChoices.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropChoices.GridPanel(p);
});

// js_render_GridPanel_class contacts.CompanyTypes
Lino.contacts.CompanyTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/CompanyTypes",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Organisationsarten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "type": "int", "name": "id" }, { "name": "abbr" }, { "name": "abbr_fr" }, { "name": "abbr_et" }, { "name": "abbr_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 22,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 10,
  initComponent : function() {
    var ww = this.containing_window;
    var name1882 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr1883 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et1884 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en1885 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1886 = new Ext.form.NumberField({ "selectOnFocus": true });
    var abbr1887 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var abbr_fr1888 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var abbr_et1889 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var abbr_en1890 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1882 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1883 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et1884 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en1885 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1886, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Abk\u00fcrzung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "abbr", "editor": abbr1887 }, { "colIndex": 6, "sortable": true, "header": "Abk\u00fcrzung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "abbr_fr", "editor": abbr_fr1888 }, { "colIndex": 7, "sortable": true, "header": "Abk\u00fcrzung (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "abbr_et", "editor": abbr_et1889 }, { "colIndex": 8, "sortable": true, "header": "Abk\u00fcrzung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "abbr_en", "editor": abbr_en1890 } ];
    Lino.contacts.CompanyTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.CompanyTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.CompanyTypes.GridPanel(p);
});

// js_render_GridPanel_class contacts.Partners
Lino.contacts.Partners.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/Partners",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Partner",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "name": "payment_term" }, 'payment_termHidden', { "name": "vat_regime" }, 'vat_regimeHidden', { "type": "boolean", "name": "item_vat" }, { "name": "imode" }, 'imodeHidden', { "name": "national_id_et" }, { "name": "bank_account1" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 31,
  ls_grid_configs : [  ],
  content_type : 21,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 33,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    var ww = this.containing_window;
    var name1892 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email1893 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var country1894 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city1895 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var region1896 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code1897 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr11898 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix1899 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street1900 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no1901 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box1902 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr21903 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language1904 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "et", "Estnisch" ], [ "en", "Englisch" ] ], "allowBlank": false, "value": "de" });
    var url1905 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone1906 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm1907 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax1908 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks1909 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var payment_term1910 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Zahlungsbedingung ausw\u00e4hlen..." });
    var vat_regime1911 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.vat.VatRegimes });
    var item_vat1912 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var imode1913 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Fakturationsmodus ausw\u00e4hlen..." });
    var national_id_et1914 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var bank_account11915 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var id1916 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city1895.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1895.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region1896.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country1894.on('change',Lino.chooser_handler(city1895,'country'));
      region1896.on('change',Lino.chooser_handler(city1895,'region'));
      country1894.on('change',Lino.chooser_handler(region1896,'country'));
      Lino.contacts.Partners.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1892 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email1893 }, { "colIndex": 2, "sortable": true, "header": "Land", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country1894, "dataIndex": "country" }, { "colIndex": 3, "sortable": true, "header": "Ort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail'), "editor": city1895, "dataIndex": "city" }, { "colIndex": 4, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail'), "editor": region1896, "dataIndex": "region" }, { "colIndex": 5, "sortable": true, "header": "Postleitzahl", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code1897 }, { "colIndex": 6, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr11898 }, { "colIndex": 7, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix1899 }, { "colIndex": 8, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street1900 }, { "colIndex": 9, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no1901 }, { "colIndex": 10, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box1902 }, { "colIndex": 11, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr21903 }, { "colIndex": 12, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language1904 }, { "colIndex": 13, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url1905 }, { "colIndex": 14, "sortable": true, "header": "Telefon", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone1906 }, { "colIndex": 15, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm1907 }, { "colIndex": 16, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax1908 }, { "colIndex": 17, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks1909, "dataIndex": "remarks" }, { "colIndex": 18, "sortable": true, "header": "Zahlungsbedingung", "editable": true, "tooltip": "The default payment term for sales invoices to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "payment_term", "editor": payment_term1910 }, { "colIndex": 19, "sortable": true, "header": "MWSt.-Regime", "editable": true, "tooltip": "The default VAT regime for sales to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(25), "dataIndex": "vat_regime", "editor": vat_regime1911 }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "item vat", "editable": true, "tooltip": "The default item VAT setting for sales to this customer.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "item_vat" }, { "colIndex": 21, "sortable": true, "header": "Fakturationsmodus", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "imode", "editor": imode1913 }, { "colIndex": 22, "sortable": true, "header": "National ID", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "national_id_et", "editor": national_id_et1914 }, { "colIndex": 23, "sortable": true, "header": "Bank account", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "editor": bank_account11915 }, new Lino.NullNumberColumn({ "colIndex": 24, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1916, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.Partners.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.insertPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Neu Partner",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/contacts/Partners",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    Lino.contacts.Partners.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Partners.insertPanel(p);
});

Lino.contacts.Partners.detailPanel = Ext.extend(Lino.contacts.Partners.DetailFormPanel,{
  empty_title: "Detail Partner",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/contacts/Partners",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    Lino.contacts.Partners.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Partners.detailPanel(p);
});
Lino.contacts.Partners.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Partners.GridPanel(p);
});

// js_render_GridPanel_class contacts.Persons
Lino.contacts.Persons.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/Persons",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Personen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name_column" }, { "name": "address_column" }, { "name": "email" }, { "name": "phone" }, { "name": "gsm" }, { "type": "int", "name": "id" }, { "name": "language" }, 'languageHidden', { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "name" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "url" }, { "name": "fax" }, { "name": "remarks" }, { "name": "payment_term" }, 'payment_termHidden', { "name": "vat_regime" }, 'vat_regimeHidden', { "type": "boolean", "name": "item_vat" }, { "name": "imode" }, 'imodeHidden', { "name": "national_id_et" }, { "name": "bank_account1" }, { "name": "created" }, { "name": "modified" }, { "name": "first_name" }, { "name": "last_name" }, { "name": "gender" }, 'genderHidden', { "name": "birth_date" }, { "name": "title" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 19,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 43,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    var ww = this.containing_window;
    var name_column_disp1918 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var address_column_disp1919 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var email1920 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone1921 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm1922 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1923 = new Ext.form.NumberField({ "selectOnFocus": true });
    var language1924 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "et", "Estnisch" ], [ "en", "Englisch" ] ], "allowBlank": false, "value": "de" });
    var country1925 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city1926 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var region1927 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code1928 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var name1929 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var addr11930 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix1931 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street1932 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no1933 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box1934 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr21935 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var url1936 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var fax1937 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks1938 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var payment_term1939 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Zahlungsbedingung ausw\u00e4hlen..." });
    var vat_regime1940 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.vat.VatRegimes });
    var item_vat1941 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var imode1942 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Fakturationsmodus ausw\u00e4hlen..." });
    var national_id_et1943 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var bank_account11944 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var created1945 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified1946 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var first_name1947 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var last_name1948 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gender1949 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.lino.Genders });
    var birth_date1950 = new Lino.IncompleteDateField({ "selectOnFocus": true });
    var title1951 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
      city1926.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1926.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region1927.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country1925.on('change',Lino.chooser_handler(city1926,'country'));
      region1927.on('change',Lino.chooser_handler(city1926,'region'));
      country1925.on('change',Lino.chooser_handler(region1927,'country'));
      Lino.contacts.Persons.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "name_column", "header": "Name", "editable": false }, { "width": Lino.chars2width(31), "colIndex": 1, "sortable": false, "dataIndex": "address_column", "header": "Adresse", "editable": false }, { "colIndex": 2, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email1920 }, { "colIndex": 3, "sortable": true, "header": "Telefon", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "phone", "editor": phone1921 }, { "colIndex": 4, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "gsm", "editor": gsm1922 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1923, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "language", "editor": language1924 }, { "colIndex": 7, "sortable": true, "header": "Land", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country1925, "dataIndex": "country" }, { "colIndex": 8, "sortable": true, "header": "Ort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail'), "editor": city1926, "dataIndex": "city" }, { "colIndex": 9, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail'), "editor": region1927, "dataIndex": "region" }, { "colIndex": 10, "sortable": true, "header": "Postleitzahl", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code1928 }, { "colIndex": 11, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1929 }, { "colIndex": 12, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr11930 }, { "colIndex": 13, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix1931 }, { "colIndex": 14, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street1932 }, { "colIndex": 15, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no1933 }, { "colIndex": 16, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box1934 }, { "colIndex": 17, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr21935 }, { "colIndex": 18, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url1936 }, { "colIndex": 19, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax1937 }, { "colIndex": 20, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks1938, "dataIndex": "remarks" }, { "colIndex": 21, "sortable": true, "header": "Zahlungsbedingung", "editable": true, "tooltip": "The default payment term for sales invoices to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "payment_term", "editor": payment_term1939 }, { "colIndex": 22, "sortable": true, "header": "MWSt.-Regime", "editable": true, "tooltip": "The default VAT regime for sales to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(25), "dataIndex": "vat_regime", "editor": vat_regime1940 }, { "colIndex": 23, "sortable": false, "xtype": "checkcolumn", "header": "item vat", "editable": true, "tooltip": "The default item VAT setting for sales to this customer.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "item_vat" }, { "colIndex": 24, "sortable": true, "header": "Fakturationsmodus", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "imode", "editor": imode1942 }, { "colIndex": 25, "sortable": true, "header": "National ID", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "national_id_et", "editor": national_id_et1943 }, { "colIndex": 26, "sortable": true, "header": "Bank account", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "editor": bank_account11944 }, { "width": Lino.chars2width(17), "colIndex": 27, "sortable": true, "dataIndex": "created", "header": "Erstellt", "editable": false }, { "width": Lino.chars2width(17), "colIndex": 28, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "editable": false }, { "colIndex": 29, "sortable": true, "header": "Vorname", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name1947 }, { "colIndex": 30, "sortable": true, "header": "Familienname", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name1948 }, { "colIndex": 31, "sortable": true, "header": "Geschlecht", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "gender", "editor": gender1949 }, { "colIndex": 32, "sortable": true, "header": "Geburtsdatum", "editable": true, "tooltip": "Unkomplette Datumsangaben sind erlaubt, z.B. \"00.00.1980\" hei\u00dft \"irgendwann im Jahr 1980\", \"00.07.1980\" hei\u00dft \"im Juli 1980\"oder \"23.07.0000\" hei\u00dft \"an einem 23. Juli\".", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "birth_date", "editor": birth_date1950 }, { "colIndex": 33, "sortable": true, "header": "Anrede", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "title", "editor": title1951 } ];
    Lino.contacts.Persons.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.insertPanel = Ext.extend(Lino.contacts.Persons.InsertFormPanel,{
  empty_title: "Neu Personen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/contacts/Persons",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    Lino.contacts.Persons.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Persons.insertPanel(p);
});

Lino.contacts.Persons.detailPanel = Ext.extend(Lino.contacts.Persons.DetailFormPanel,{
  empty_title: "Detail Personen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/contacts/Persons",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    Lino.contacts.Persons.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Persons.detailPanel(p);
});
Lino.contacts.Persons.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Persons.GridPanel(p);
});

// js_render_GridPanel_class contacts.Companies
Lino.contacts.Companies.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/Companies",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Organisationen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "name": "payment_term" }, 'payment_termHidden', { "name": "vat_regime" }, 'vat_regimeHidden', { "type": "boolean", "name": "item_vat" }, { "name": "imode" }, 'imodeHidden', { "name": "national_id_et" }, { "name": "bank_account1" }, { "name": "created" }, { "name": "modified" }, { "name": "prefix" }, { "name": "vat_id" }, { "name": "type" }, 'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 37,
  ls_grid_configs : [  ],
  content_type : 18,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 39,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    var ww = this.containing_window;
    var name1953 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email1954 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var country1955 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city1956 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var region1957 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code1958 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr11959 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix1960 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street1961 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no1962 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box1963 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr21964 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language1965 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "et", "Estnisch" ], [ "en", "Englisch" ] ], "allowBlank": false, "value": "de" });
    var url1966 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone1967 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm1968 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax1969 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks1970 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var payment_term1971 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Zahlungsbedingung ausw\u00e4hlen..." });
    var vat_regime1972 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.vat.VatRegimes });
    var item_vat1973 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var imode1974 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Fakturationsmodus ausw\u00e4hlen..." });
    var national_id_et1975 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var bank_account11976 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var created1977 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified1978 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var prefix1979 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var vat_id1980 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type1981 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen..." });
    var id1982 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city1956.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1956.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region1957.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country1955.on('change',Lino.chooser_handler(city1956,'country'));
      region1957.on('change',Lino.chooser_handler(city1956,'region'));
      country1955.on('change',Lino.chooser_handler(region1957,'country'));
      Lino.contacts.Companies.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1953 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email1954 }, { "colIndex": 2, "sortable": true, "header": "Land", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country1955, "dataIndex": "country" }, { "colIndex": 3, "sortable": true, "header": "Ort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail'), "editor": city1956, "dataIndex": "city" }, { "colIndex": 4, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail'), "editor": region1957, "dataIndex": "region" }, { "colIndex": 5, "sortable": true, "header": "Postleitzahl", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code1958 }, { "colIndex": 6, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr11959 }, { "colIndex": 7, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix1960 }, { "colIndex": 8, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street1961 }, { "colIndex": 9, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no1962 }, { "colIndex": 10, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box1963 }, { "colIndex": 11, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr21964 }, { "colIndex": 12, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language1965 }, { "colIndex": 13, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url1966 }, { "colIndex": 14, "sortable": true, "header": "Telefon", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone1967 }, { "colIndex": 15, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm1968 }, { "colIndex": 16, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax1969 }, { "colIndex": 17, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks1970, "dataIndex": "remarks" }, { "colIndex": 18, "sortable": true, "header": "Zahlungsbedingung", "editable": true, "tooltip": "The default payment term for sales invoices to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "payment_term", "editor": payment_term1971 }, { "colIndex": 19, "sortable": true, "header": "MWSt.-Regime", "editable": true, "tooltip": "The default VAT regime for sales to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(25), "dataIndex": "vat_regime", "editor": vat_regime1972 }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "item vat", "editable": true, "tooltip": "The default item VAT setting for sales to this customer.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "item_vat" }, { "colIndex": 21, "sortable": true, "header": "Fakturationsmodus", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "imode", "editor": imode1974 }, { "colIndex": 22, "sortable": true, "header": "National ID", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "national_id_et", "editor": national_id_et1975 }, { "colIndex": 23, "sortable": true, "header": "Bank account", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "editor": bank_account11976 }, { "width": Lino.chars2width(17), "colIndex": 24, "sortable": true, "dataIndex": "created", "header": "Erstellt", "editable": false }, { "width": Lino.chars2width(17), "colIndex": 25, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "editable": false }, { "colIndex": 26, "sortable": true, "header": "prefix", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "prefix", "editor": prefix1979 }, { "colIndex": 27, "sortable": true, "header": "MWSt.-Nr.", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "vat_id", "editor": vat_id1980 }, { "colIndex": 28, "sortable": true, "header": "Organisationsart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type1981 }, new Lino.NullNumberColumn({ "colIndex": 29, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1982, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.Companies.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.insertPanel = Ext.extend(Lino.contacts.Companies.InsertFormPanel,{
  empty_title: "Neu Organisationen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/contacts/Companies",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    Lino.contacts.Companies.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Companies.insertPanel(p);
});

Lino.contacts.Companies.detailPanel = Ext.extend(Lino.contacts.Companies.DetailFormPanel,{
  empty_title: "Detail Organisationen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/contacts/Companies",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    Lino.contacts.Companies.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Companies.detailPanel(p);
});
Lino.contacts.Companies.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Companies.GridPanel(p);
});

// js_render_GridPanel_class contacts.RoleTypes
Lino.contacts.RoleTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/RoleTypes",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Funktionen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 17,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var id1984 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1985 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr1986 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et1987 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en1988 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1984, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1985 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1986 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et1987 }, { "colIndex": 4, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en1988 } ];
    Lino.contacts.RoleTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.RoleTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.RoleTypes.GridPanel(p);
});

// js_render_GridPanel_class contacts.Roles
Lino.contacts.Roles.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/Roles",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Kontaktpersonen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "type" }, 'typeHidden', { "name": "person" }, 'personHidden', { "name": "company" }, 'companyHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 20,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var id1990 = new Ext.form.NumberField({ "selectOnFocus": true });
    var type1991 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Roles/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Funktion ausw\u00e4hlen..." });
    var person1992 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Roles/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Person ausw\u00e4hlen..." });
    var company1993 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Roles/company", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Organisation ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1990, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Funktion", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type1991 }, { "colIndex": 2, "sortable": true, "header": "Person", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('personHidden','Lino.contacts.Persons.detail'), "editor": person1992, "dataIndex": "person" }, { "colIndex": 3, "sortable": true, "header": "Organisation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('companyHidden','Lino.contacts.Companies.detail'), "editor": company1993, "dataIndex": "company" } ];
    Lino.contacts.Roles.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Roles.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Roles.GridPanel(p);
});

// js_render_GridPanel_class households.Types
Lino.households.Types.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/households/Types",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Haushaltsarten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 26,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Types.detail;
    this.ls_insert_handler = Lino.households.Types.insert;
    var ww = this.containing_window;
    var id1995 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1996 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr1997 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et1998 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en1999 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1995, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1996 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1997 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et1998 }, { "colIndex": 4, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en1999 } ];
    Lino.households.Types.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Types.insertPanel = Ext.extend(Lino.households.Types.DetailFormPanel,{
  empty_title: "Neu Haushaltsarten",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/households/Types",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Types.detail;
    this.ls_insert_handler = Lino.households.Types.insert;
    Lino.households.Types.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Types.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.households.Types.insertPanel(p);
});

Lino.households.Types.detailPanel = Ext.extend(Lino.households.Types.DetailFormPanel,{
  empty_title: "Detail Haushaltsarten",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/households/Types",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Types.detail;
    this.ls_insert_handler = Lino.households.Types.insert;
    Lino.households.Types.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Types.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Types.detailPanel(p);
});
Lino.households.Types.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Types.GridPanel(p);
});

// js_render_GridPanel_class households.Households
Lino.households.Households.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/households/Households",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Haushalte",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "name": "payment_term" }, 'payment_termHidden', { "name": "vat_regime" }, 'vat_regimeHidden', { "type": "boolean", "name": "item_vat" }, { "name": "imode" }, 'imodeHidden', { "name": "national_id_et" }, { "name": "bank_account1" }, { "name": "created" }, { "name": "modified" }, { "name": "prefix" }, { "name": "type" }, 'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 36,
  ls_grid_configs : [  ],
  content_type : 25,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 38,
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Households.detail;
    this.ls_insert_handler = Lino.households.Households.insert;
    var ww = this.containing_window;
    var name2001 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email2002 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var country2003 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city2004 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var region2005 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code2006 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr12007 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix2008 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street2009 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no2010 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box2011 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr22012 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language2013 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "et", "Estnisch" ], [ "en", "Englisch" ] ], "allowBlank": false, "value": "de" });
    var url2014 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone2015 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm2016 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax2017 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks2018 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var payment_term2019 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Zahlungsbedingung ausw\u00e4hlen..." });
    var vat_regime2020 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.vat.VatRegimes });
    var item_vat2021 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var imode2022 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Fakturationsmodus ausw\u00e4hlen..." });
    var national_id_et2023 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var bank_account12024 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var created2025 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2026 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var prefix2027 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type2028 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Haushaltsart ausw\u00e4hlen..." });
    var id2029 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city2004.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2004.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region2005.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country2003.on('change',Lino.chooser_handler(city2004,'country'));
      region2005.on('change',Lino.chooser_handler(city2004,'region'));
      country2003.on('change',Lino.chooser_handler(region2005,'country'));
      Lino.households.Households.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2001 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email2002 }, { "colIndex": 2, "sortable": true, "header": "Land", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country2003, "dataIndex": "country" }, { "colIndex": 3, "sortable": true, "header": "Ort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail'), "editor": city2004, "dataIndex": "city" }, { "colIndex": 4, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail'), "editor": region2005, "dataIndex": "region" }, { "colIndex": 5, "sortable": true, "header": "Postleitzahl", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code2006 }, { "colIndex": 6, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr12007 }, { "colIndex": 7, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix2008 }, { "colIndex": 8, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street2009 }, { "colIndex": 9, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no2010 }, { "colIndex": 10, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box2011 }, { "colIndex": 11, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr22012 }, { "colIndex": 12, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language2013 }, { "colIndex": 13, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url2014 }, { "colIndex": 14, "sortable": true, "header": "Telefon", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone2015 }, { "colIndex": 15, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm2016 }, { "colIndex": 16, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax2017 }, { "colIndex": 17, "sortable": false, "header": "Bemerkungen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks2018, "dataIndex": "remarks" }, { "colIndex": 18, "sortable": true, "header": "Zahlungsbedingung", "editable": true, "tooltip": "The default payment term for sales invoices to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "payment_term", "editor": payment_term2019 }, { "colIndex": 19, "sortable": true, "header": "MWSt.-Regime", "editable": true, "tooltip": "The default VAT regime for sales to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(25), "dataIndex": "vat_regime", "editor": vat_regime2020 }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "item vat", "editable": true, "tooltip": "The default item VAT setting for sales to this customer.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "item_vat" }, { "colIndex": 21, "sortable": true, "header": "Fakturationsmodus", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "imode", "editor": imode2022 }, { "colIndex": 22, "sortable": true, "header": "National ID", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "national_id_et", "editor": national_id_et2023 }, { "colIndex": 23, "sortable": true, "header": "Bank account", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "editor": bank_account12024 }, { "width": Lino.chars2width(17), "colIndex": 24, "sortable": true, "dataIndex": "created", "header": "Erstellt", "editable": false }, { "width": Lino.chars2width(17), "colIndex": 25, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "editable": false }, { "colIndex": 26, "sortable": true, "header": "prefix", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "prefix", "editor": prefix2027 }, { "colIndex": 27, "sortable": true, "header": "Haushaltsart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('typeHidden','Lino.households.Types.detail'), "editor": type2028, "dataIndex": "type" }, new Lino.NullNumberColumn({ "colIndex": 28, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2029, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.households.Households.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Households.insertPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Neu Haushalte",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/households/Households",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Households.detail;
    this.ls_insert_handler = Lino.households.Households.insert;
    Lino.households.Households.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Households.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.households.Households.insertPanel(p);
});

Lino.households.Households.detailPanel = Ext.extend(Lino.households.Households.DetailFormPanel,{
  empty_title: "Detail Haushalte",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/households/Households",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Households.detail;
    this.ls_insert_handler = Lino.households.Households.insert;
    Lino.households.Households.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Households.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Households.detailPanel(p);
});
Lino.households.Households.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Households.GridPanel(p);
});

// js_render_GridPanel_class households.Roles
Lino.households.Roles.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/households/Roles",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Rollen in Haushalt",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "type": "boolean", "name": "name_giving" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 24,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Roles.detail;
    this.ls_insert_handler = Lino.households.Roles.insert;
    var ww = this.containing_window;
    var id2031 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2032 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2033 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2034 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en2035 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_giving2036 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2031, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2032 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2033 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et2034 }, { "colIndex": 4, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en2035 }, { "colIndex": 5, "sortable": false, "xtype": "checkcolumn", "header": "namensgebend", "editable": true, "tooltip": "When the `name` field of a Household is empty, \nits value is computed by joining the `Last Name` \nof all name-giving members with a dash (\"-\").\n      ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "name_giving" } ];
    Lino.households.Roles.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Roles.insertPanel = Ext.extend(Lino.households.Roles.DetailFormPanel,{
  empty_title: "Neu Rollen in Haushalt",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/households/Roles",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Roles.detail;
    this.ls_insert_handler = Lino.households.Roles.insert;
    Lino.households.Roles.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Roles.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.households.Roles.insertPanel(p);
});

Lino.households.Roles.detailPanel = Ext.extend(Lino.households.Roles.DetailFormPanel,{
  empty_title: "Detail Rollen in Haushalt",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/households/Roles",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Roles.detail;
    this.ls_insert_handler = Lino.households.Roles.insert;
    Lino.households.Roles.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Roles.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Roles.detailPanel(p);
});
Lino.households.Roles.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Roles.GridPanel(p);
});

// js_render_GridPanel_class households.Members
Lino.households.Members.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/households/Members",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Mitglieder",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "role" }, 'roleHidden', { "name": "household" }, 'householdHidden', { "name": "person" }, 'personHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 23,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 10,
  initComponent : function() {
    var ww = this.containing_window;
    var id2038 = new Ext.form.NumberField({ "selectOnFocus": true });
    var role2039 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Members/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Rolle in Haushalt ausw\u00e4hlen..." });
    var household2040 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Members/household", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Haushalt ausw\u00e4hlen..." });
    var person2041 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Members/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Person ausw\u00e4hlen..." });
    var start_date2042 = new Lino.DateField({ "selectOnFocus": true });
    var end_date2043 = new Lino.DateField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2038, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Rolle in Haushalt", "editable": true, "tooltip": "The Role of this Person in this Household.\nList of choices is configured in `Configure --> Households --> Roles`.\n", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('roleHidden','Lino.households.Roles.detail'), "editor": role2039, "dataIndex": "role" }, { "colIndex": 2, "sortable": true, "header": "Haushalt", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('householdHidden','Lino.households.Households.detail'), "editor": household2040, "dataIndex": "household" }, { "colIndex": 3, "sortable": true, "header": "Person", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('personHidden','Lino.contacts.Persons.detail'), "editor": person2041, "dataIndex": "person" }, { "colIndex": 4, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "From", "editor": start_date2042, "width": Lino.chars2width(9), "dataIndex": "start_date" }, { "colIndex": 5, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Until", "editor": end_date2043, "width": Lino.chars2width(9), "dataIndex": "end_date" } ];
    Lino.households.Members.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Members.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Members.GridPanel(p);
});

// js_render_GridPanel_class products.ProductCats
Lino.products.ProductCats.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/products/ProductCats",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Produktkategorien",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "description" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 27,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    this.ls_detail_handler = Lino.products.ProductCats.detail;
    this.ls_insert_handler = Lino.products.ProductCats.insert;
    var ww = this.containing_window;
    var id2045 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2046 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2047 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2048 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en2049 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var description2050 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2045, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2046 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2047 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et2048 }, { "colIndex": 4, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en2049 }, { "colIndex": 5, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": description2050, "dataIndex": "description" } ];
    Lino.products.ProductCats.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.products.ProductCats.insertPanel = Ext.extend(Lino.products.ProductCats.DetailFormPanel,{
  empty_title: "Neu Produktkategorien",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/products/ProductCats",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.products.ProductCats.detail;
    this.ls_insert_handler = Lino.products.ProductCats.insert;
    Lino.products.ProductCats.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.products.ProductCats.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.products.ProductCats.insertPanel(p);
});

Lino.products.ProductCats.detailPanel = Ext.extend(Lino.products.ProductCats.DetailFormPanel,{
  empty_title: "Detail Produktkategorien",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/products/ProductCats",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.products.ProductCats.detail;
    this.ls_insert_handler = Lino.products.ProductCats.insert;
    Lino.products.ProductCats.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.products.ProductCats.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.products.ProductCats.detailPanel(p);
});
Lino.products.ProductCats.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.products.ProductCats.GridPanel(p);
});

// js_render_GridPanel_class products.Products
Lino.products.Products.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/products/Products",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Produkte",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "cat" }, 'catHidden', { "type": "boolean", "name": "vatExempt" }, { "name": "price" }, { "name": "description" }, { "name": "sales_account" }, 'sales_accountHidden', { "name": "purchases_account" }, 'purchases_accountHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 28,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    this.ls_detail_handler = Lino.products.Products.detail;
    this.ls_insert_handler = Lino.products.Products.insert;
    var ww = this.containing_window;
    var id2052 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2053 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2054 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2055 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en2056 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var cat2057 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/products/Products/cat", "method": "GET" }) }), "pageSize": 20, "emptyText": "Produktkategorie ausw\u00e4hlen..." });
    var vatExempt2058 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var price2059 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var description2060 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var sales_account2061 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/products/Products/sales_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Konto ausw\u00e4hlen..." });
    var purchases_account2062 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/products/Products/purchases_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Konto ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2052, "width": Lino.chars2width(4), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2053 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2054 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et2055 }, { "colIndex": 4, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en2056 }, { "colIndex": 5, "sortable": true, "header": "Kategorie", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('catHidden','Lino.products.ProductCats.detail'), "editor": cat2057, "dataIndex": "cat" }, { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "Befreit von MWSt.", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "vatExempt" }, new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "header": "Preis", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(7), "dataIndex": "price", "editor": price2059 }), { "colIndex": 8, "sortable": false, "header": "Long description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": description2060, "dataIndex": "description" }, { "colIndex": 9, "sortable": true, "header": "Konto f\u00fcr Verk\u00e4ufe", "editable": true, "tooltip": "The account to move when this product is used in a sales invoice.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "sales_account", "editor": sales_account2061 }, { "colIndex": 10, "sortable": true, "header": "Konto f\u00fcr Eink\u00e4ufe", "editable": true, "tooltip": "The account to move when this product is used in a purchases invoice.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "purchases_account", "editor": purchases_account2062 } ];
    Lino.products.Products.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.products.Products.insertPanel = Ext.extend(Lino.products.Products.DetailFormPanel,{
  empty_title: "Neu Produkte",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/products/Products",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.products.Products.detail;
    this.ls_insert_handler = Lino.products.Products.insert;
    Lino.products.Products.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.products.Products.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.products.Products.insertPanel(p);
});

Lino.products.Products.detailPanel = Ext.extend(Lino.products.Products.DetailFormPanel,{
  empty_title: "Detail Produkte",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/products/Products",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.products.Products.detail;
    this.ls_insert_handler = Lino.products.Products.insert;
    Lino.products.Products.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.products.Products.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.products.Products.detailPanel(p);
});
Lino.products.Products.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.products.Products.GridPanel(p);
});

// js_render_GridPanel_class accounts.Charts
Lino.accounts.Charts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/accounts/Charts",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Kontenpl\u00e4ne",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Charts.detail;
    this.ls_insert_handler = Lino.accounts.Charts.insert;
    var ww = this.containing_window;
    var id2064 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2065 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2066 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2067 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en2068 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2064, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2065 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2066 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et2067 }, { "colIndex": 4, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en2068 } ];
    Lino.accounts.Charts.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Charts.insertPanel = Ext.extend(Lino.accounts.Charts.DetailFormPanel,{
  empty_title: "Neu Kontenpl\u00e4ne",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/accounts/Charts",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Charts.detail;
    this.ls_insert_handler = Lino.accounts.Charts.insert;
    Lino.accounts.Charts.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Charts.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.accounts.Charts.insertPanel(p);
});

Lino.accounts.Charts.detailPanel = Ext.extend(Lino.accounts.Charts.DetailFormPanel,{
  empty_title: "Detail Kontenpl\u00e4ne",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/accounts/Charts",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Charts.detail;
    this.ls_insert_handler = Lino.accounts.Charts.insert;
    Lino.accounts.Charts.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Charts.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Charts.detailPanel(p);
});
Lino.accounts.Charts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Charts.GridPanel(p);
});

// js_render_GridPanel_class accounts.Groups
Lino.accounts.Groups.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/accounts/Groups",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Kontengruppen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "chart" }, 'chartHidden', { "name": "ref" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "account_type" }, 'account_typeHidden', { "type": "int", "name": "id" }, { "name": "help_text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 9,
  ls_grid_configs : [  ],
  content_type : 30,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 12,
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Groups.detail;
    this.ls_insert_handler = Lino.accounts.Groups.insert;
    var ww = this.containing_window;
    var chart2070 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Groups/chart", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Kontenplan ausw\u00e4hlen..." });
    var ref2071 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var name2072 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2073 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2074 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en2075 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var account_type2076 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.accounts.AccountTypes });
    var id2077 = new Ext.form.NumberField({ "selectOnFocus": true });
    var help_text2078 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Einleitung" });
    this.before_row_edit = function(record) {
      help_text2078.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Kontenplan", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('chartHidden','Lino.accounts.Charts.detail'), "editor": chart2070, "dataIndex": "chart" }, { "colIndex": 1, "sortable": true, "header": "ref", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ref", "editor": ref2071 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2072 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2073 }, { "colIndex": 4, "sortable": true, "header": "Bezeichnung (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et2074 }, { "colIndex": 5, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en2075 }, { "colIndex": 6, "sortable": true, "header": "Kontenart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "account_type", "editor": account_type2076 }, new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2077, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 8, "sortable": false, "header": "help_text", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": help_text2078, "dataIndex": "help_text" } ];
    Lino.accounts.Groups.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Groups.insertPanel = Ext.extend(Lino.accounts.Groups.DetailFormPanel,{
  empty_title: "Neu Kontengruppen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/accounts/Groups",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Groups.detail;
    this.ls_insert_handler = Lino.accounts.Groups.insert;
    Lino.accounts.Groups.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Groups.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.accounts.Groups.insertPanel(p);
});

Lino.accounts.Groups.detailPanel = Ext.extend(Lino.accounts.Groups.DetailFormPanel,{
  empty_title: "Detail Kontengruppen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/accounts/Groups",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Groups.detail;
    this.ls_insert_handler = Lino.accounts.Groups.insert;
    Lino.accounts.Groups.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Groups.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Groups.detailPanel(p);
});
Lino.accounts.Groups.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Groups.GridPanel(p);
});

// js_render_GridPanel_class accounts.Accounts
Lino.accounts.Accounts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/accounts/Accounts",
  ls_bbar_actions : [ { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "panel_btn_handler": Lino.row_action_handler('move_up','GET'), "text": "Up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "panel_btn_handler": Lino.row_action_handler('move_down','GET'), "text": "Down", "overflowText": "Down", "auto_save": true } ],
  title : "Konten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "ref" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "group" }, 'groupHidden', { "type": "int", "name": "id" }, { "type": "int", "name": "seqno" }, { "name": "chart" }, 'chartHidden', { "name": "type" }, 'typeHidden', { "name": "help_text" }, { "type": "boolean", "name": "sales_allowed" }, { "type": "boolean", "name": "purchases_allowed" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 29,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 17,
  initComponent : function() {
    var ww = this.containing_window;
    var ref2080 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var name2081 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2082 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2083 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en2084 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var group2085 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Accounts/group", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Kontengruppe ausw\u00e4hlen..." });
    var id2086 = new Ext.form.NumberField({ "selectOnFocus": true });
    var seqno2087 = new Ext.form.NumberField({ "selectOnFocus": true });
    var chart2088 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Accounts/chart", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Kontenplan ausw\u00e4hlen..." });
    var type2089 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.accounts.AccountTypes });
    var help_text2090 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Einleitung" });
    var sales_allowed2091 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var purchases_allowed2092 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
      help_text2090.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ref", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ref", "editor": ref2080 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2081 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2082 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et2083 }, { "colIndex": 4, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en2084 }, { "colIndex": 5, "sortable": true, "header": "Kontengruppe", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('groupHidden','Lino.accounts.Groups.detail'), "editor": group2085, "dataIndex": "group" }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2086, "width": Lino.chars2width(6), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Seq.-Nr.", "dataIndex": "seqno", "width": Lino.chars2width(6), "editor": seqno2087 }), { "colIndex": 8, "sortable": true, "header": "Kontenplan", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('chartHidden','Lino.accounts.Charts.detail'), "editor": chart2088, "dataIndex": "chart" }, { "colIndex": 9, "sortable": true, "header": "Kontenart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "type", "editor": type2089 }, { "colIndex": 10, "sortable": false, "header": "help_text", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": help_text2090, "dataIndex": "help_text" }, { "colIndex": 11, "sortable": false, "xtype": "checkcolumn", "header": "Verkauf", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "sales_allowed" }, { "colIndex": 12, "sortable": false, "xtype": "checkcolumn", "header": "Einkauf", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "purchases_allowed" } ];
    Lino.accounts.Accounts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Accounts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Accounts.GridPanel(p);
});
Lino.accounts.Accounts.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Accounts",pk,"move_up");
};
Lino.accounts.Accounts.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Accounts",pk,"move_down");
};

// js_render_GridPanel_class ledger.Journals
Lino.ledger.Journals.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/ledger/Journals",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "panel_btn_handler": Lino.row_action_handler('move_up','GET'), "text": "Up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "panel_btn_handler": Lino.row_action_handler('move_down','GET'), "text": "Down", "overflowText": "Down", "auto_save": true } ],
  title : "Journals",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "seqno" }, { "type": "int", "name": "id" }, { "name": "trade_type" }, 'trade_typeHidden', { "name": "voucher_type" }, 'voucher_typeHidden', { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "type": "boolean", "name": "force_sequence" }, { "name": "ref" }, { "name": "chart" }, 'chartHidden', { "name": "account" }, 'accountHidden', { "name": "printed_name" }, { "name": "printed_name_fr" }, { "name": "printed_name_et" }, { "name": "printed_name_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 1,
  ls_grid_configs : [  ],
  content_type : 32,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 21,
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Journals.detail;
    this.ls_insert_handler = Lino.ledger.Journals.insert;
    var ww = this.containing_window;
    var seqno2094 = new Ext.form.NumberField({ "selectOnFocus": true });
    var id2095 = new Ext.form.NumberField({ "selectOnFocus": true });
    var trade_type2096 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.vat.TradeTypes });
    var voucher_type2097 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.ledger.VoucherTypes });
    var name2098 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2099 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2100 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en2101 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var force_sequence2102 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var ref2103 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var chart2104 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Journals/chart", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Kontenplan ausw\u00e4hlen..." });
    var account2105 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Journals/account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Konto ausw\u00e4hlen..." });
    var printed_name2106 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var printed_name_fr2107 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var printed_name_et2108 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var printed_name_en2109 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    this.before_row_edit = function(record) {
      account2105.setContextValue('chart',record ? record.data['chartHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      chart2104.on('change',Lino.chooser_handler(account2105,'chart'));
      Lino.ledger.Journals.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Seq.-Nr.", "dataIndex": "seqno", "width": Lino.chars2width(6), "editor": seqno2094 }), new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2095, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 2, "sortable": true, "header": "Handelsart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "trade_type", "editor": trade_type2096 }, { "colIndex": 3, "sortable": true, "header": "voucher type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(55), "dataIndex": "voucher_type", "editor": voucher_type2097 }, { "colIndex": 4, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2098 }, { "colIndex": 5, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2099 }, { "colIndex": 6, "sortable": true, "header": "Bezeichnung (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et2100 }, { "colIndex": 7, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en2101 }, { "colIndex": 8, "sortable": false, "xtype": "checkcolumn", "header": "force sequence", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "force_sequence" }, { "colIndex": 9, "sortable": true, "header": "ref", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ref", "editor": ref2103 }, { "colIndex": 10, "sortable": true, "header": "Kontenplan", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('chartHidden','Lino.accounts.Charts.detail'), "editor": chart2104, "dataIndex": "chart" }, { "colIndex": 11, "sortable": true, "header": "Konto", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "account", "editor": account2105 }, { "colIndex": 12, "sortable": true, "header": "printed name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "printed_name", "editor": printed_name2106 }, { "colIndex": 13, "sortable": true, "header": "printed name (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "printed_name_fr", "editor": printed_name_fr2107 }, { "colIndex": 14, "sortable": true, "header": "printed name (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "printed_name_et", "editor": printed_name_et2108 }, { "colIndex": 15, "sortable": true, "header": "printed name (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "printed_name_en", "editor": printed_name_en2109 } ];
    Lino.ledger.Journals.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Journals.insertPanel = Ext.extend(Lino.ledger.Journals.InsertFormPanel,{
  empty_title: "Neu Journals",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/ledger/Journals",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Journals.detail;
    this.ls_insert_handler = Lino.ledger.Journals.insert;
    Lino.ledger.Journals.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Journals.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.ledger.Journals.insertPanel(p);
});

Lino.ledger.Journals.detailPanel = Ext.extend(Lino.ledger.Journals.DetailFormPanel,{
  empty_title: "Detail Journals",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "panel_btn_handler": Lino.row_action_handler('move_up','GET'), "text": "Up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "panel_btn_handler": Lino.row_action_handler('move_down','GET'), "text": "Down", "overflowText": "Down", "auto_save": true } ],
  ls_url: "/ledger/Journals",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Journals.detail;
    this.ls_insert_handler = Lino.ledger.Journals.insert;
    Lino.ledger.Journals.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Journals.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.Journals.detailPanel(p);
});
Lino.ledger.Journals.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.Journals.GridPanel(p);
});
Lino.ledger.Journals.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Journals",pk,"move_up");
};
Lino.ledger.Journals.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Journals",pk,"move_down");
};

// js_render_GridPanel_class ledger.Vouchers
Lino.ledger.Vouchers.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/ledger/Vouchers",
  ls_bbar_actions : [  ],
  title : "Vouchers",
  page_length : 20,
  stripeRows : true,
  disable_editing : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "type": "int", "name": "number" }, { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "project" }, 'projectHidden', { "name": "journal" }, 'journalHidden', { "name": "year" }, 'yearHidden', { "name": "narration" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 35,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 13,
  initComponent : function() {
    var ww = this.containing_window;
    var date2111 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var number2112 = new Ext.form.NumberField({ "selectOnFocus": true });
    var id2113 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user2114 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Vouchers/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var project2115 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Vouchers/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Projekt ausw\u00e4hlen..." });
    var journal2116 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Vouchers/journal", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Journal ausw\u00e4hlen..." });
    var year2117 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.ledger.FiscalYears });
    var narration2118 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Datum", "editor": date2111, "width": Lino.chars2width(9), "dataIndex": "date" }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(6), "editor": number2112 }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2113, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 3, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2114, "dataIndex": "user" }, { "colIndex": 4, "sortable": true, "header": "Projekt", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail'), "editor": project2115, "dataIndex": "project" }, { "colIndex": 5, "sortable": true, "header": "Journal", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('journalHidden','Lino.ledger.Journals.detail'), "editor": journal2116, "dataIndex": "journal" }, { "colIndex": 6, "sortable": true, "header": "Gesch\u00e4ftsjahr", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "year", "editor": year2117 }, { "colIndex": 7, "sortable": true, "header": "Narration", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "narration", "editor": narration2118 } ];
    Lino.ledger.Vouchers.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Vouchers.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.Vouchers.GridPanel(p);
});

// js_render_GridPanel_class ledger.Movements
Lino.ledger.Movements.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/ledger/Movements",
  ls_bbar_actions : [ { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "panel_btn_handler": Lino.row_action_handler('move_up','GET'), "text": "Up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "panel_btn_handler": Lino.row_action_handler('move_down','GET'), "text": "Down", "overflowText": "Down", "auto_save": true } ],
  title : "Movements",
  page_length : 20,
  stripeRows : true,
  disable_editing : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "voucher_link" }, { "name": "account" }, 'accountHidden', { "name": "debit" }, { "name": "credit" }, { "type": "int", "name": "id" }, { "type": "int", "name": "seqno" }, { "name": "voucher" }, 'voucherHidden', { "name": "partner" }, 'partnerHidden', { "name": "amount" }, { "type": "boolean", "name": "dc" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 36,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 14,
  initComponent : function() {
    var ww = this.containing_window;
    var voucher_link_disp2120 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var account2121 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Movements/account", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Konto ausw\u00e4hlen..." });
    var debit2122 = new Ext.form.NumberField({ "disabled": true, "decimalPrecision": 2, "decimalSeparator": "," });
    var credit2123 = new Ext.form.NumberField({ "disabled": true, "decimalPrecision": 2, "decimalSeparator": "," });
    var id2124 = new Ext.form.NumberField({ "selectOnFocus": true });
    var seqno2125 = new Ext.form.NumberField({ "selectOnFocus": true });
    var voucher2126 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Movements/voucher", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Voucher ausw\u00e4hlen..." });
    var partner2127 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Movements/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var amount2128 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalSeparator": ",", "decimalPrecision": 2, "allowBlank": false, "value": 0 });
    var dc2129 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(31), "colIndex": 0, "sortable": false, "dataIndex": "voucher_link", "header": "Voucher", "editable": false }, { "colIndex": 1, "sortable": true, "header": "Konto", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "account", "editor": account2121 }, new Lino.NullNumberColumn({ "width": Lino.chars2width(13), "colIndex": 2, "sortable": false, "dataIndex": "debit", "header": "Debit", "editable": false }), new Lino.NullNumberColumn({ "width": Lino.chars2width(13), "colIndex": 3, "sortable": false, "dataIndex": "credit", "header": "Kredit", "editable": false }), new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2124, "width": Lino.chars2width(6), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Seq.-Nr.", "dataIndex": "seqno", "width": Lino.chars2width(6), "editor": seqno2125 }), { "colIndex": 6, "sortable": true, "header": "Voucher", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "voucher", "editor": voucher2126 }, { "colIndex": 7, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2127, "dataIndex": "partner" }, new Lino.NullNumberColumn({ "colIndex": 8, "sortable": true, "header": "amount", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "amount", "editor": amount2128 }), { "colIndex": 9, "sortable": false, "xtype": "checkcolumn", "header": "dc", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "dc" } ];
    Lino.ledger.Movements.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Movements.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.Movements.GridPanel(p);
});
Lino.ledger.Movements.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Movements",pk,"move_up");
};
Lino.ledger.Movements.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Movements",pk,"move_down");
};

// js_render_GridPanel_class ledger.Invoices
Lino.ledger.Invoices.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/ledger/Invoices",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Rechnungen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "type": "int", "name": "id" }, { "type": "int", "name": "number" }, { "name": "partner" }, 'partnerHidden', { "name": "total_incl" }, { "name": "user" }, 'userHidden', { "name": "project" }, 'projectHidden', { "name": "journal" }, 'journalHidden', { "name": "year" }, 'yearHidden', { "name": "narration" }, { "name": "total_base" }, { "name": "total_vat" }, { "type": "boolean", "name": "item_vat" }, { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "your_ref" }, { "type": "date", "name": "due_date", "dateFormat": "d.m.Y" }, { "name": "state" }, 'stateHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 1,
  ls_grid_configs : [  ],
  content_type : 34,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 25,
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Invoices.detail;
    this.ls_insert_handler = Lino.ledger.Invoices.insert;
    var ww = this.containing_window;
    var date2131 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var id2132 = new Ext.form.NumberField({ "selectOnFocus": true });
    var number2133 = new Ext.form.NumberField({ "selectOnFocus": true });
    var partner2134 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/partner", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var total_incl2135 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var user2136 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var project2137 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Projekt ausw\u00e4hlen..." });
    var journal2138 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/journal", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Journal ausw\u00e4hlen..." });
    var year2139 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.ledger.FiscalYears });
    var narration2140 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var total_base2141 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat2142 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var item_vat2143 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var vat_regime2144 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.vat.VatRegimes });
    var your_ref2145 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var due_date2146 = new Lino.DateField({ "selectOnFocus": true });
    var state2147 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.ledger.InvoiceStates });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Datum", "editor": date2131, "width": Lino.chars2width(9), "dataIndex": "date" }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2132, "width": Lino.chars2width(6), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(6), "editor": number2133 }), { "colIndex": 3, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2134, "dataIndex": "partner" }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "header": "Total inkl. MWSt.", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_incl", "editor": total_incl2135 }), { "colIndex": 5, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2136, "dataIndex": "user" }, { "colIndex": 6, "sortable": true, "header": "Projekt", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail'), "editor": project2137, "dataIndex": "project" }, { "colIndex": 7, "sortable": true, "header": "Journal", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('journalHidden','Lino.ledger.Journals.detail'), "editor": journal2138, "dataIndex": "journal" }, { "colIndex": 8, "sortable": true, "header": "Gesch\u00e4ftsjahr", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "year", "editor": year2139 }, { "colIndex": 9, "sortable": true, "header": "Narration", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "narration", "editor": narration2140 }, new Lino.NullNumberColumn({ "colIndex": 10, "sortable": true, "header": "Total zzgl. MWSt.", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_base", "editor": total_base2141 }), new Lino.NullNumberColumn({ "colIndex": 11, "sortable": true, "header": "MWSt.", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_vat", "editor": total_vat2142 }), { "colIndex": 12, "sortable": false, "xtype": "checkcolumn", "header": "Preis inkl. MWSt.", "editable": true, "tooltip": "Ob St\u00fcckpreise sich inkl. MWSt. verstehen.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "item_vat" }, { "colIndex": 13, "sortable": true, "header": "MWSt.-Regime", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(25), "dataIndex": "vat_regime", "editor": vat_regime2144 }, { "colIndex": 14, "sortable": true, "header": "Ihr Zeichen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "your_ref", "editor": your_ref2145 }, { "colIndex": 15, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Zahlungsziel", "editor": due_date2146, "width": Lino.chars2width(9), "dataIndex": "due_date" }, { "colIndex": 16, "sortable": true, "header": "Zustand", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(14), "dataIndex": "state", "editor": state2147 } ];
    Lino.ledger.Invoices.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Invoices.insertPanel = Ext.extend(Lino.ledger.Invoices.InsertFormPanel,{
  empty_title: "Neu Rechnungen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/ledger/Invoices",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Invoices.detail;
    this.ls_insert_handler = Lino.ledger.Invoices.insert;
    Lino.ledger.Invoices.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Invoices.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.ledger.Invoices.insertPanel(p);
});

Lino.ledger.Invoices.detailPanel = Ext.extend(Lino.ledger.Invoices.DetailFormPanel,{
  empty_title: "Detail Rechnungen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/ledger/Invoices",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Invoices.detail;
    this.ls_insert_handler = Lino.ledger.Invoices.insert;
    Lino.ledger.Invoices.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Invoices.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.Invoices.detailPanel(p);
});
Lino.ledger.Invoices.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.ledger.Invoices.ParamsPanel({});
  return new Lino.ledger.Invoices.GridPanel(p);
});
Lino.ledger.Invoices.deregister_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Invoices",pk,"deregister_action");
};
Lino.ledger.Invoices.register_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Invoices",pk,"register_action");
};

// js_render_GridPanel_class sales.PaymentTerms
Lino.sales.PaymentTerms.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/sales/PaymentTerms",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Zahlungsbedingungen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "type": "int", "name": "days" }, { "type": "int", "name": "months" }, { "type": "boolean", "name": "end_of_month" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 42,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    var ww = this.containing_window;
    var id2149 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2150 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2151 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2152 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en2153 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var days2154 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var months2155 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var end_of_month2156 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2149, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2150 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2151 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et2152 }, { "colIndex": 4, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en2153 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "days", "dataIndex": "days", "width": Lino.chars2width(6), "editor": days2154 }), new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "months", "dataIndex": "months", "width": Lino.chars2width(6), "editor": months2155 }), { "colIndex": 7, "sortable": false, "xtype": "checkcolumn", "header": "end of month", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "end_of_month" } ];
    Lino.sales.PaymentTerms.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.PaymentTerms.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.PaymentTerms.GridPanel(p);
});

// js_render_GridPanel_class sales.InvoicingModes
Lino.sales.InvoicingModes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/sales/InvoicingModes",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Fakturationsmodi",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "build_method" }, 'build_methodHidden', { "name": "template" }, { "name": "price" }, { "type": "int", "name": "advance_days" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 37,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    var ww = this.containing_window;
    var id2158 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2159 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2160 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2161 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en2162 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var build_method2163 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template2164 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoicingModes/template", "method": "GET" }) }) });
    var price2165 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var advance_days2166 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    this.before_row_edit = function(record) {
      template2164.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      build_method2163.on('change',Lino.chooser_handler(template2164,'build_method'));
      Lino.sales.InvoicingModes.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2158, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2159 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2160 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et2161 }, { "colIndex": 4, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en2162 }, { "colIndex": 5, "sortable": true, "header": "Konstruktionsmethode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "build_method", "editor": build_method2163 }, { "colIndex": 6, "sortable": true, "header": "Vorlage", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "template", "editor": template2164 }, new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "header": "price", "editable": true, "tooltip": "Additional fee charged when using this invoicing mode.", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "price", "editor": price2165 }), new Lino.NullNumberColumn({ "colIndex": 8, "sortable": true, "format": "0", "editable": true, "tooltip": "\nHow many days in advance invoices should be posted so that the customer\nhas a chance to pay them in time.", "filter": { "type": "numeric" }, "header": "advance days", "dataIndex": "advance_days", "width": Lino.chars2width(6), "editor": advance_days2166 }) ];
    Lino.sales.InvoicingModes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.InvoicingModes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.InvoicingModes.GridPanel(p);
});

// js_render_GridPanel_class sales.ShippingModes
Lino.sales.ShippingModes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/sales/ShippingModes",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Lieferarten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "price" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 43,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    var ww = this.containing_window;
    var id2168 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2169 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2170 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2171 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en2172 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var price2173 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2168, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2169 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2170 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et2171 }, { "colIndex": 4, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en2172 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "header": "price", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "price", "editor": price2173 }) ];
    Lino.sales.ShippingModes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.ShippingModes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.ShippingModes.GridPanel(p);
});

// js_render_GridPanel_class sales.Invoices
Lino.sales.Invoices.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/sales/Invoices",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true } ],
  title : "Rechnungen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "partner" }, 'partnerHidden', { "name": "total_incl" }, { "name": "user" }, 'userHidden', { "name": "project" }, 'projectHidden', { "name": "journal" }, 'journalHidden', { "name": "year" }, 'yearHidden', { "type": "int", "name": "number" }, { "name": "narration" }, { "name": "build_time" }, { "name": "total_base" }, { "name": "total_vat" }, { "type": "boolean", "name": "item_vat" }, { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "language" }, 'languageHidden', { "name": "your_ref" }, { "name": "imode" }, 'imodeHidden', { "name": "shipping_mode" }, 'shipping_modeHidden', { "name": "payment_term" }, 'payment_termHidden', { "name": "subject" }, { "name": "intro" }, { "name": "discount" }, { "type": "date", "name": "due_date", "dateFormat": "d.m.Y" }, { "name": "state" }, 'stateHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 41,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 37,
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.Invoices.detail;
    this.ls_insert_handler = Lino.sales.Invoices.insert;
    var ww = this.containing_window;
    var id2175 = new Ext.form.NumberField({ "selectOnFocus": true });
    var date2176 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var partner2177 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/partner", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var total_incl2178 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var user2179 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var project2180 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Projekt ausw\u00e4hlen..." });
    var journal2181 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/journal", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Journal ausw\u00e4hlen..." });
    var year2182 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.ledger.FiscalYears });
    var number2183 = new Ext.form.NumberField({ "selectOnFocus": true });
    var narration2184 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var build_time2185 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var total_base2186 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat2187 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var item_vat2188 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var vat_regime2189 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.vat.VatRegimes });
    var language2190 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "et", "Estnisch" ], [ "en", "Englisch" ] ], "allowBlank": false, "value": "de" });
    var your_ref2191 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var imode2192 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Fakturationsmodus ausw\u00e4hlen..." });
    var shipping_mode2193 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/shipping_mode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Lieferart ausw\u00e4hlen..." });
    var payment_term2194 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Zahlungsbedingung ausw\u00e4hlen..." });
    var subject2195 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var intro2196 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var discount2197 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var due_date2198 = new Lino.DateField({ "selectOnFocus": true });
    var state2199 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.sales.InvoiceStates });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2175, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Datum", "editor": date2176, "width": Lino.chars2width(9), "dataIndex": "date" }, { "colIndex": 2, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2177, "dataIndex": "partner" }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "header": "Total inkl. MWSt.", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_incl", "editor": total_incl2178 }), { "colIndex": 4, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2179, "dataIndex": "user" }, { "colIndex": 5, "sortable": true, "header": "Projekt", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail'), "editor": project2180, "dataIndex": "project" }, { "colIndex": 6, "sortable": true, "header": "Journal", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('journalHidden','Lino.ledger.Journals.detail'), "editor": journal2181, "dataIndex": "journal" }, { "colIndex": 7, "sortable": true, "header": "Gesch\u00e4ftsjahr", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "year", "editor": year2182 }, new Lino.NullNumberColumn({ "colIndex": 8, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(6), "editor": number2183 }), { "colIndex": 9, "sortable": true, "header": "Narration", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "narration", "editor": narration2184 }, { "width": Lino.chars2width(17), "colIndex": 10, "sortable": true, "dataIndex": "build_time", "header": "Druckdatum", "editable": false }, new Lino.NullNumberColumn({ "colIndex": 11, "sortable": true, "header": "Total zzgl. MWSt.", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_base", "editor": total_base2186 }), new Lino.NullNumberColumn({ "colIndex": 12, "sortable": true, "header": "MWSt.", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_vat", "editor": total_vat2187 }), { "colIndex": 13, "sortable": false, "xtype": "checkcolumn", "header": "Preis inkl. MWSt.", "editable": true, "tooltip": "Ob St\u00fcckpreise sich inkl. MWSt. verstehen.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "item_vat" }, { "colIndex": 14, "sortable": true, "header": "MWSt.-Regime", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(25), "dataIndex": "vat_regime", "editor": vat_regime2189 }, { "colIndex": 15, "sortable": true, "header": "Sprache", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language2190 }, { "colIndex": 16, "sortable": true, "header": "Ihr Zeichen", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "your_ref", "editor": your_ref2191 }, { "colIndex": 17, "sortable": true, "header": "Fakturationsmodus", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "imode", "editor": imode2192 }, { "colIndex": 18, "sortable": true, "header": "Lieferart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "shipping_mode", "editor": shipping_mode2193 }, { "colIndex": 19, "sortable": true, "header": "Zahlungsbedingung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "payment_term", "editor": payment_term2194 }, { "colIndex": 20, "sortable": true, "header": "Betreff", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "subject", "editor": subject2195 }, { "colIndex": 21, "sortable": false, "header": "Introductive Text", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": intro2196, "dataIndex": "intro" }, new Lino.NullNumberColumn({ "colIndex": 22, "sortable": true, "header": "Erm\u00e4\u00dfigung", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(8), "dataIndex": "discount", "editor": discount2197 }), { "colIndex": 23, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Zahlungsziel", "editor": due_date2198, "width": Lino.chars2width(9), "dataIndex": "due_date" }, { "colIndex": 24, "sortable": true, "header": "Zustand", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(18), "dataIndex": "state", "editor": state2199 } ];
    Lino.sales.Invoices.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.sales.Invoices.insertPanel = Ext.extend(Lino.sales.Invoices.InsertFormPanel,{
  empty_title: "Neu Rechnungen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/sales/Invoices",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.Invoices.detail;
    this.ls_insert_handler = Lino.sales.Invoices.insert;
    Lino.sales.Invoices.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.Invoices.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.sales.Invoices.insertPanel(p);
});

Lino.sales.Invoices.detailPanel = Ext.extend(Lino.sales.Invoices.DetailFormPanel,{
  empty_title: "Detail Rechnungen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true } ],
  ls_url: "/sales/Invoices",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.Invoices.detail;
    this.ls_insert_handler = Lino.sales.Invoices.insert;
    Lino.sales.Invoices.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.Invoices.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.Invoices.detailPanel(p);
});
Lino.sales.Invoices.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.sales.Invoices.ParamsPanel({});
  return new Lino.sales.Invoices.GridPanel(p);
});
Lino.sales.Invoices.deregister_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/Invoices",pk,"deregister_action");
};
Lino.sales.Invoices.register_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/Invoices",pk,"register_action");
};

// js_render_GridPanel_class sales.DocumentsToSign
Lino.sales.DocumentsToSign.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/sales/DocumentsToSign",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true } ],
  title : "Rechnungen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "number" }, { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "partner" }, 'partnerHidden', { "name": "imode" }, 'imodeHidden', { "name": "subject" }, { "name": "total_incl" }, { "name": "total_base" }, { "name": "total_vat" }, { "name": "voucher_ptr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 10,
  ls_grid_configs : [  ],
  content_type : 41,
  ls_id_property : "voucher_ptr",
  gc_name : 0,
  disabled_actions_index : 12,
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.DocumentsToSign.detail;
    this.ls_insert_handler = Lino.sales.DocumentsToSign.insert;
    var ww = this.containing_window;
    var number2201 = new Ext.form.NumberField({ "selectOnFocus": true });
    var date2202 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var partner2203 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/DocumentsToSign/partner", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var imode2204 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/DocumentsToSign/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Fakturationsmodus ausw\u00e4hlen..." });
    var subject2205 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var total_incl2206 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_base2207 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat2208 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(5), "editor": number2201 }), { "colIndex": 1, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Datum", "editor": date2202, "width": Lino.chars2width(9), "dataIndex": "date" }, { "colIndex": 2, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2203, "dataIndex": "partner" }, { "colIndex": 3, "sortable": true, "header": "Fakturationsmodus", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "imode", "editor": imode2204 }, { "colIndex": 4, "sortable": true, "header": "Betreff", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "subject", "editor": subject2205 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "header": "Total inkl. MWSt.", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_incl", "editor": total_incl2206 }), new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "header": "Total zzgl. MWSt.", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_base", "editor": total_base2207 }), new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "header": "MWSt.", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_vat", "editor": total_vat2208 }) ];
    Lino.sales.DocumentsToSign.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.sales.DocumentsToSign.insertPanel = Ext.extend(Lino.sales.Invoices.InsertFormPanel,{
  empty_title: "Neu Rechnungen",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/sales/DocumentsToSign",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.DocumentsToSign.detail;
    this.ls_insert_handler = Lino.sales.DocumentsToSign.insert;
    Lino.sales.DocumentsToSign.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.DocumentsToSign.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.sales.DocumentsToSign.insertPanel(p);
});

Lino.sales.DocumentsToSign.detailPanel = Ext.extend(Lino.sales.Invoices.DetailFormPanel,{
  empty_title: "Detail Rechnungen",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true } ],
  ls_url: "/sales/DocumentsToSign",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.DocumentsToSign.detail;
    this.ls_insert_handler = Lino.sales.DocumentsToSign.insert;
    Lino.sales.DocumentsToSign.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.DocumentsToSign.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.DocumentsToSign.detailPanel(p);
});
Lino.sales.DocumentsToSign.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.sales.Invoices.ParamsPanel({});
  return new Lino.sales.DocumentsToSign.GridPanel(p);
});
Lino.sales.DocumentsToSign.deregister_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/DocumentsToSign",pk,"deregister_action");
};
Lino.sales.DocumentsToSign.register_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/DocumentsToSign",pk,"register_action");
};

// js_render_GridPanel_class blogs.EntryTypes
Lino.blogs.EntryTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/blogs/EntryTypes",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Blog-Eintrags-Arten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "build_method" }, 'build_methodHidden', { "name": "template" }, { "type": "int", "name": "id" }, { "type": "boolean", "name": "important" }, { "name": "remark" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 45,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    this.ls_detail_handler = Lino.blogs.EntryTypes.detail;
    this.ls_insert_handler = Lino.blogs.EntryTypes.insert;
    var ww = this.containing_window;
    var name2210 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2211 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2212 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en2213 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var build_method2214 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template2215 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/EntryTypes/template", "method": "GET" }) }) });
    var id2216 = new Ext.form.NumberField({ "selectOnFocus": true });
    var important2217 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var remark2218 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
      template2215.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      build_method2214.on('change',Lino.chooser_handler(template2215,'build_method'));
      Lino.blogs.EntryTypes.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2210 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2211 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et2212 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en2213 }, { "colIndex": 4, "sortable": true, "header": "Konstruktionsmethode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "build_method", "editor": build_method2214 }, { "colIndex": 5, "sortable": true, "header": "Vorlage", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "template", "editor": template2215 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2216, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 7, "sortable": false, "xtype": "checkcolumn", "header": "wichtig", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "important" }, { "colIndex": 8, "sortable": false, "header": "Bemerkung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remark2218, "dataIndex": "remark" } ];
    Lino.blogs.EntryTypes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.blogs.EntryTypes.insertPanel = Ext.extend(Lino.blogs.EntryTypes.DetailFormPanel,{
  empty_title: "Neu Blog-Eintrags-Arten",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/blogs/EntryTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.blogs.EntryTypes.detail;
    this.ls_insert_handler = Lino.blogs.EntryTypes.insert;
    Lino.blogs.EntryTypes.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.blogs.EntryTypes.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.blogs.EntryTypes.insertPanel(p);
});

Lino.blogs.EntryTypes.detailPanel = Ext.extend(Lino.blogs.EntryTypes.DetailFormPanel,{
  empty_title: "Detail Blog-Eintrags-Arten",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/blogs/EntryTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.blogs.EntryTypes.detail;
    this.ls_insert_handler = Lino.blogs.EntryTypes.insert;
    Lino.blogs.EntryTypes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.blogs.EntryTypes.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.blogs.EntryTypes.detailPanel(p);
});
Lino.blogs.EntryTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.blogs.EntryTypes.GridPanel(p);
});

// js_render_GridPanel_class blogs.Entries
Lino.blogs.Entries.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/blogs/Entries",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true } ],
  title : "Blog-Eintr\u00e4ge",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "modified" }, { "name": "user" }, 'userHidden', { "name": "type" }, 'typeHidden', { "name": "title" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "created" }, { "name": "build_time" }, { "name": "language" }, 'languageHidden', { "name": "ticket" }, 'ticketHidden', { "name": "owner" }, { "name": "body" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 44,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 20,
  initComponent : function() {
    this.ls_detail_handler = Lino.blogs.Entries.detail;
    this.ls_insert_handler = Lino.blogs.Entries.insert;
    var ww = this.containing_window;
    var id2220 = new Ext.form.NumberField({ "selectOnFocus": true });
    var modified2221 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var user2222 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/Entries/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var type2223 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/Entries/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Blog Entry Type ausw\u00e4hlen..." });
    var title2224 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var owner_type2225 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/Entries/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id2226 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/Entries/owner_id", "method": "GET" }) }) });
    var created2227 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_time2228 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var language2229 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "Deutsch" ], [ "fr", "Franz\u00f6sisch" ], [ "et", "Estnisch" ], [ "en", "Englisch" ] ], "allowBlank": false, "value": "de" });
    var ticket2230 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/Entries/ticket", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ticket ausw\u00e4hlen..." });
    var owner_disp2231 = new Ext.form.DisplayField({ "disabled": true });
    var body2232 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Inhalt" });
    this.before_row_edit = function(record) {
      owner_id2226.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      body2232.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2225.on('change',Lino.chooser_handler(owner_id2226,'owner_type'));
      Lino.blogs.Entries.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2220, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(17), "colIndex": 1, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "editable": false }, { "colIndex": 2, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2222, "dataIndex": "user" }, { "colIndex": 3, "sortable": true, "header": "Blog Entry Type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('typeHidden','Lino.blogs.EntryTypes.detail'), "editor": type2223, "dataIndex": "type" }, { "colIndex": 4, "sortable": true, "header": "\u00dcberschrift", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "title", "editor": title2224 }, { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.ui.ContentTypes.detail'), "editor": owner_type2225, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id2226 }, { "width": Lino.chars2width(17), "colIndex": 7, "sortable": true, "dataIndex": "created", "header": "Erstellt", "editable": false }, { "width": Lino.chars2width(17), "colIndex": 8, "sortable": true, "dataIndex": "build_time", "header": "Druckdatum", "editable": false }, { "colIndex": 9, "sortable": true, "header": "Sprache", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language2229 }, { "colIndex": 10, "sortable": true, "header": "Ticket", "editable": true, "tooltip": "The Ticket attributed to this Entry.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('ticketHidden','Lino.tickets.Tickets.detail'), "editor": ticket2230, "dataIndex": "ticket" }, { "width": Lino.chars2width(11), "colIndex": 11, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "editable": false }, { "colIndex": 12, "sortable": false, "header": "body", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": body2232, "dataIndex": "body" } ];
    Lino.blogs.Entries.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.blogs.Entries.insertPanel = Ext.extend(Lino.blogs.Entries.DetailFormPanel,{
  empty_title: "Neu Blog-Eintr\u00e4ge",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/blogs/Entries",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.blogs.Entries.detail;
    this.ls_insert_handler = Lino.blogs.Entries.insert;
    Lino.blogs.Entries.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.blogs.Entries.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.blogs.Entries.insertPanel(p);
});

Lino.blogs.Entries.detailPanel = Ext.extend(Lino.blogs.Entries.DetailFormPanel,{
  empty_title: "Detail Blog-Eintr\u00e4ge",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true } ],
  ls_url: "/blogs/Entries",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.blogs.Entries.detail;
    this.ls_insert_handler = Lino.blogs.Entries.insert;
    Lino.blogs.Entries.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.blogs.Entries.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.blogs.Entries.detailPanel(p);
});
Lino.blogs.Entries.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.blogs.Entries.GridPanel(p);
});

// js_render_GridPanel_class tickets.ProjectTypes
Lino.tickets.ProjectTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/tickets/ProjectTypes",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Project Types",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "build_method" }, 'build_methodHidden', { "name": "template" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 46,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    var ww = this.containing_window;
    var name2234 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2235 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2236 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en2237 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var build_method2238 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template2239 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/ProjectTypes/template", "method": "GET" }) }) });
    var id2240 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      template2239.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      build_method2238.on('change',Lino.chooser_handler(template2239,'build_method'));
      Lino.tickets.ProjectTypes.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2234 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2235 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et2236 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en2237 }, { "colIndex": 4, "sortable": true, "header": "Konstruktionsmethode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "build_method", "editor": build_method2238 }, { "colIndex": 5, "sortable": true, "header": "Vorlage", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "template", "editor": template2239 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2240, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.tickets.ProjectTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.ProjectTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.tickets.ProjectTypes.GridPanel(p);
});

// js_render_GridPanel_class tickets.SessionTypes
Lino.tickets.SessionTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/tickets/SessionTypes",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Session Types",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 47,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var name2242 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2243 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2244 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en2245 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id2246 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2242 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2243 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et2244 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en2245 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2246, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.tickets.SessionTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.SessionTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.tickets.SessionTypes.GridPanel(p);
});

// js_render_GridPanel_class tickets.Projects
Lino.tickets.Projects.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/tickets/Projects",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Projects",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "ref" }, { "name": "name" }, { "name": "parent" }, 'parentHidden', { "name": "type" }, 'typeHidden', { "name": "partner" }, 'partnerHidden', { "name": "description" }, { "name": "srcref_url_template" }, { "name": "changeset_url_template" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 48,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.Projects.detail;
    this.ls_insert_handler = Lino.tickets.Projects.insert;
    var ww = this.containing_window;
    var id2248 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user2249 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Projects/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var ref2250 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var name2251 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var parent2252 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Projects/parent", "method": "GET" }) }), "pageSize": 20, "emptyText": "Projekt ausw\u00e4hlen..." });
    var type2253 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Projects/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Project Type ausw\u00e4hlen..." });
    var partner2254 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Projects/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var description2255 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var srcref_url_template2256 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var changeset_url_template2257 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2248, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2249, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "Referenz", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ref", "editor": ref2250 }, { "colIndex": 3, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2251 }, { "colIndex": 4, "sortable": true, "header": "Parent", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('parentHidden','Lino.tickets.Projects.detail'), "editor": parent2252, "dataIndex": "parent" }, { "colIndex": 5, "sortable": true, "header": "Project Type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type2253 }, { "colIndex": 6, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2254, "dataIndex": "partner" }, { "colIndex": 7, "sortable": false, "header": "Beschreibung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": description2255, "dataIndex": "description" }, { "colIndex": 8, "sortable": true, "header": "srcref url template", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "srcref_url_template", "editor": srcref_url_template2256 }, { "colIndex": 9, "sortable": true, "header": "changeset url template", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "changeset_url_template", "editor": changeset_url_template2257 } ];
    Lino.tickets.Projects.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.Projects.insertPanel = Ext.extend(Lino.tickets.Projects.DetailFormPanel,{
  empty_title: "Neu Projects",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/tickets/Projects",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.Projects.detail;
    this.ls_insert_handler = Lino.tickets.Projects.insert;
    Lino.tickets.Projects.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.Projects.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.tickets.Projects.insertPanel(p);
});

Lino.tickets.Projects.detailPanel = Ext.extend(Lino.tickets.Projects.DetailFormPanel,{
  empty_title: "Detail Projects",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/tickets/Projects",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.Projects.detail;
    this.ls_insert_handler = Lino.tickets.Projects.insert;
    Lino.tickets.Projects.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.Projects.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.tickets.Projects.detailPanel(p);
});
Lino.tickets.Projects.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.tickets.Projects.GridPanel(p);
});

// js_render_GridPanel_class tickets.Milestones
Lino.tickets.Milestones.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/tickets/Milestones",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Milestones",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "project" }, 'projectHidden', { "name": "ref" }, { "type": "date", "name": "expected", "dateFormat": "d.m.Y" }, { "type": "date", "name": "reached", "dateFormat": "d.m.Y" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 50,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.Milestones.detail;
    this.ls_insert_handler = Lino.tickets.Milestones.insert;
    var ww = this.containing_window;
    var id2259 = new Ext.form.NumberField({ "selectOnFocus": true });
    var project2260 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Milestones/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Projekt ausw\u00e4hlen..." });
    var ref2261 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var expected2262 = new Lino.DateField({ "selectOnFocus": true });
    var reached2263 = new Lino.DateField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2259, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Projekt", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail'), "editor": project2260, "dataIndex": "project" }, { "colIndex": 2, "sortable": true, "header": "Referenz", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ref", "editor": ref2261 }, { "colIndex": 3, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Expected for", "editor": expected2262, "width": Lino.chars2width(9), "dataIndex": "expected" }, { "colIndex": 4, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Reached", "editor": reached2263, "width": Lino.chars2width(9), "dataIndex": "reached" } ];
    Lino.tickets.Milestones.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.Milestones.insertPanel = Ext.extend(Lino.tickets.Milestones.InsertFormPanel,{
  empty_title: "Neu Milestones",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/tickets/Milestones",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.Milestones.detail;
    this.ls_insert_handler = Lino.tickets.Milestones.insert;
    Lino.tickets.Milestones.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.Milestones.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.tickets.Milestones.insertPanel(p);
});

Lino.tickets.Milestones.detailPanel = Ext.extend(Lino.tickets.Milestones.DetailFormPanel,{
  empty_title: "Detail Milestones",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/tickets/Milestones",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.Milestones.detail;
    this.ls_insert_handler = Lino.tickets.Milestones.insert;
    Lino.tickets.Milestones.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.Milestones.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.tickets.Milestones.detailPanel(p);
});
Lino.tickets.Milestones.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.tickets.Milestones.GridPanel(p);
});

// js_render_GridPanel_class tickets.Tickets
Lino.tickets.Tickets.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/tickets/Tickets",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Tickets",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "created" }, { "name": "modified" }, { "name": "project" }, 'projectHidden', { "name": "reported" }, 'reportedHidden', { "name": "fixed" }, 'fixedHidden', { "name": "partner" }, 'partnerHidden', { "name": "summary" }, { "name": "state" }, 'stateHidden', { "name": "closed" }, { "name": "description" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 51,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 19,
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.Tickets.detail;
    this.ls_insert_handler = Lino.tickets.Tickets.insert;
    var ww = this.containing_window;
    var id2265 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user2266 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var created2267 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2268 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var project2269 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Projekt ausw\u00e4hlen..." });
    var reported2270 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/reported", "method": "GET" }) }), "pageSize": 20, "emptyText": "Milestone ausw\u00e4hlen..." });
    var fixed2271 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/fixed", "method": "GET" }) }), "pageSize": 20, "emptyText": "Milestone ausw\u00e4hlen..." });
    var partner2272 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var summary2273 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var state2274 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.tickets.TicketStates });
    var closed2275 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var description2276 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
      reported2270.setContextValue('project',record ? record.data['projectHidden'] : undefined);
      fixed2271.setContextValue('project',record ? record.data['projectHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      project2269.on('change',Lino.chooser_handler(reported2270,'project'));
      project2269.on('change',Lino.chooser_handler(fixed2271,'project'));
      Lino.tickets.Tickets.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2265, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2266, "dataIndex": "user" }, { "width": Lino.chars2width(17), "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "Erstellt", "editable": false }, { "width": Lino.chars2width(17), "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "editable": false }, { "colIndex": 4, "sortable": true, "header": "Projekt", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail'), "editor": project2269, "dataIndex": "project" }, { "colIndex": 5, "sortable": true, "header": "Reported for", "editable": true, "tooltip": "Milestone for which this ticket has been reported.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('reportedHidden','Lino.tickets.Milestones.detail'), "editor": reported2270, "dataIndex": "reported" }, { "colIndex": 6, "sortable": true, "header": "Fixed for", "editable": true, "tooltip": "The milestone for which this ticket has been fixed.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('fixedHidden','Lino.tickets.Milestones.detail'), "editor": fixed2271, "dataIndex": "fixed" }, { "colIndex": 7, "sortable": true, "header": "Partner", "editable": true, "tooltip": "The partner who reported this ticket.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2272, "dataIndex": "partner" }, { "colIndex": 8, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "tooltip": "Short summary of the problem.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary2273 }, { "colIndex": 9, "sortable": true, "header": "Zustand", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "state", "editor": state2274 }, { "width": Lino.chars2width(17), "colIndex": 10, "sortable": true, "dataIndex": "closed", "header": "Closed since", "editable": false }, { "colIndex": 11, "sortable": false, "header": "Beschreibung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": description2276, "dataIndex": "description" } ];
    Lino.tickets.Tickets.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.Tickets.insertPanel = Ext.extend(Lino.tickets.Tickets.InsertFormPanel,{
  empty_title: "Neu Tickets",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/tickets/Tickets",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.Tickets.detail;
    this.ls_insert_handler = Lino.tickets.Tickets.insert;
    Lino.tickets.Tickets.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.Tickets.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.tickets.Tickets.insertPanel(p);
});

Lino.tickets.Tickets.detailPanel = Ext.extend(Lino.tickets.Tickets.DetailFormPanel,{
  empty_title: "Detail Tickets",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/tickets/Tickets",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.Tickets.detail;
    this.ls_insert_handler = Lino.tickets.Tickets.insert;
    Lino.tickets.Tickets.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.Tickets.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.tickets.Tickets.detailPanel(p);
});
Lino.tickets.Tickets.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.tickets.Tickets.GridPanel(p);
});

// js_render_GridPanel_class tickets.UnassignedTickets
Lino.tickets.UnassignedTickets.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/tickets/UnassignedTickets",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Tickets",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "summary" }, { "name": "project" }, 'projectHidden', { "name": "partner" }, 'partnerHidden', { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "created" }, { "name": "modified" }, { "name": "reported" }, 'reportedHidden', { "name": "fixed" }, 'fixedHidden', { "name": "state" }, 'stateHidden', { "name": "closed" }, { "name": "description" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 51,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 19,
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.UnassignedTickets.detail;
    this.ls_insert_handler = Lino.tickets.UnassignedTickets.insert;
    var ww = this.containing_window;
    var summary2278 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var project2279 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/UnassignedTickets/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Projekt ausw\u00e4hlen..." });
    var partner2280 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/UnassignedTickets/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var id2281 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user2282 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/UnassignedTickets/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var created2283 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2284 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var reported2285 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/UnassignedTickets/reported", "method": "GET" }) }), "pageSize": 20, "emptyText": "Milestone ausw\u00e4hlen..." });
    var fixed2286 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/UnassignedTickets/fixed", "method": "GET" }) }), "pageSize": 20, "emptyText": "Milestone ausw\u00e4hlen..." });
    var state2287 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.tickets.TicketStates });
    var closed2288 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var description2289 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
      reported2285.setContextValue('project',record ? record.data['projectHidden'] : undefined);
      fixed2286.setContextValue('project',record ? record.data['projectHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      project2279.on('change',Lino.chooser_handler(reported2285,'project'));
      project2279.on('change',Lino.chooser_handler(fixed2286,'project'));
      Lino.tickets.UnassignedTickets.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "tooltip": "Short summary of the problem.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary2278 }, { "colIndex": 1, "sortable": true, "header": "Projekt", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail'), "editor": project2279, "dataIndex": "project" }, { "colIndex": 2, "sortable": true, "header": "Partner", "editable": true, "tooltip": "The partner who reported this ticket.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2280, "dataIndex": "partner" }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2281, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2282, "dataIndex": "user" }, { "width": Lino.chars2width(17), "colIndex": 5, "sortable": true, "dataIndex": "created", "header": "Erstellt", "editable": false }, { "width": Lino.chars2width(17), "colIndex": 6, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "editable": false }, { "colIndex": 7, "sortable": true, "header": "Reported for", "editable": true, "tooltip": "Milestone for which this ticket has been reported.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('reportedHidden','Lino.tickets.Milestones.detail'), "editor": reported2285, "dataIndex": "reported" }, { "colIndex": 8, "sortable": true, "header": "Fixed for", "editable": true, "tooltip": "The milestone for which this ticket has been fixed.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('fixedHidden','Lino.tickets.Milestones.detail'), "editor": fixed2286, "dataIndex": "fixed" }, { "colIndex": 9, "sortable": true, "header": "Zustand", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "state", "editor": state2287 }, { "width": Lino.chars2width(17), "colIndex": 10, "sortable": true, "dataIndex": "closed", "header": "Closed since", "editable": false }, { "colIndex": 11, "sortable": false, "header": "Beschreibung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": description2289, "dataIndex": "description" } ];
    Lino.tickets.UnassignedTickets.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.UnassignedTickets.insertPanel = Ext.extend(Lino.tickets.Tickets.InsertFormPanel,{
  empty_title: "Neu Tickets",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/tickets/UnassignedTickets",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.UnassignedTickets.detail;
    this.ls_insert_handler = Lino.tickets.UnassignedTickets.insert;
    Lino.tickets.UnassignedTickets.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.UnassignedTickets.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.tickets.UnassignedTickets.insertPanel(p);
});

Lino.tickets.UnassignedTickets.detailPanel = Ext.extend(Lino.tickets.Tickets.DetailFormPanel,{
  empty_title: "Detail Tickets",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/tickets/UnassignedTickets",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.UnassignedTickets.detail;
    this.ls_insert_handler = Lino.tickets.UnassignedTickets.insert;
    Lino.tickets.UnassignedTickets.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.UnassignedTickets.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.tickets.UnassignedTickets.detailPanel(p);
});
Lino.tickets.UnassignedTickets.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.tickets.UnassignedTickets.GridPanel(p);
});

// js_render_GridPanel_class tickets.Sessions
Lino.tickets.Sessions.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/tickets/Sessions",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Sessions",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "name": "end_time" }, { "name": "break_time" }, { "name": "summary" }, { "name": "user" }, 'userHidden', { "type": "int", "name": "id" }, { "name": "project" }, 'projectHidden', { "name": "partner" }, 'partnerHidden', { "name": "ticket" }, 'ticketHidden', { "name": "description" }, { "name": "time" }, { "type": "boolean", "name": "is_private" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 49,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 18,
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.Sessions.detail;
    this.ls_insert_handler = Lino.tickets.Sessions.insert;
    var ww = this.containing_window;
    var date2291 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var start_time2292 = new Lino.TimeField({ "selectOnFocus": true });
    var end_time2293 = new Lino.TimeField({ "selectOnFocus": true });
    var break_time2294 = new Lino.TimeField({ "selectOnFocus": true });
    var summary2295 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var user2296 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Sessions/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var id2297 = new Ext.form.NumberField({ "selectOnFocus": true });
    var project2298 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Sessions/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Projekt ausw\u00e4hlen..." });
    var partner2299 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Sessions/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var ticket2300 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Sessions/ticket", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ticket ausw\u00e4hlen..." });
    var description2301 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var time2302 = new Lino.TimeField({ "selectOnFocus": true });
    var is_private2303 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Datum", "editor": date2291, "width": Lino.chars2width(9), "dataIndex": "date" }, { "width": Lino.chars2width(9), "colIndex": 1, "sortable": true, "dataIndex": "start_time", "header": "Beginnt um", "editable": true, "editor": start_time2292 }, { "width": Lino.chars2width(9), "colIndex": 2, "sortable": true, "dataIndex": "end_time", "header": "Endet um", "editable": true, "editor": end_time2293 }, { "width": Lino.chars2width(9), "colIndex": 3, "sortable": true, "dataIndex": "break_time", "header": "Break Time", "editable": true, "editor": break_time2294 }, { "colIndex": 4, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "tooltip": "Short summary of the session.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary2295 }, { "colIndex": 5, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2296, "dataIndex": "user" }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2297, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 7, "sortable": true, "header": "Projekt", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail'), "editor": project2298, "dataIndex": "project" }, { "colIndex": 8, "sortable": true, "header": "Partner", "editable": true, "tooltip": "The partner to be invoiced for this session.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2299, "dataIndex": "partner" }, { "colIndex": 9, "sortable": true, "header": "Ticket", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('ticketHidden','Lino.tickets.Tickets.detail'), "editor": ticket2300, "dataIndex": "ticket" }, { "colIndex": 10, "sortable": false, "header": "Beschreibung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": description2301, "dataIndex": "description" }, { "width": Lino.chars2width(9), "colIndex": 11, "sortable": true, "dataIndex": "time", "header": "Zeit", "editable": true, "editor": time2302 }, { "colIndex": 12, "sortable": false, "xtype": "checkcolumn", "header": "is private", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_private" } ];
    Lino.tickets.Sessions.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.Sessions.insertPanel = Ext.extend(Lino.tickets.Sessions.DetailFormPanel,{
  empty_title: "Neu Sessions",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/tickets/Sessions",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.Sessions.detail;
    this.ls_insert_handler = Lino.tickets.Sessions.insert;
    Lino.tickets.Sessions.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.Sessions.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.tickets.Sessions.insertPanel(p);
});

Lino.tickets.Sessions.detailPanel = Ext.extend(Lino.tickets.Sessions.DetailFormPanel,{
  empty_title: "Detail Sessions",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/tickets/Sessions",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.Sessions.detail;
    this.ls_insert_handler = Lino.tickets.Sessions.insert;
    Lino.tickets.Sessions.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.Sessions.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.tickets.Sessions.detailPanel(p);
});
Lino.tickets.Sessions.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.tickets.Sessions.GridPanel(p);
});

// js_render_GridPanel_class outbox.Recipients
Lino.outbox.Recipients.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/outbox/Recipients",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Empf\u00e4nger",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "mail" }, 'mailHidden', { "name": "partner" }, 'partnerHidden', { "name": "type" }, 'typeHidden', { "name": "address" }, { "name": "name" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 63,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 10,
  initComponent : function() {
    var ww = this.containing_window;
    var id2305 = new Ext.form.NumberField({ "selectOnFocus": true });
    var mail2306 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Recipients/mail", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "E-Mail-Ausgang ausw\u00e4hlen..." });
    var partner2307 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Recipients/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var type2308 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.outbox.RecipientType });
    var address2309 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var name2310 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2305, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "E-Mail-Ausgang", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('mailHidden','Lino.outbox.Mails.detail'), "editor": mail2306, "dataIndex": "mail" }, { "colIndex": 2, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2307, "dataIndex": "partner" }, { "colIndex": 3, "sortable": true, "header": "Empf\u00e4ngerart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(17), "dataIndex": "type", "editor": type2308 }, { "colIndex": 4, "sortable": true, "header": "Adresse", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "address", "editor": address2309 }, { "colIndex": 5, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2310 } ];
    Lino.outbox.Recipients.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.Recipients.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.Recipients.GridPanel(p);
});

// js_render_GridPanel_class outbox.Mails
Lino.outbox.Mails.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/outbox/Mails",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "send_mail", "menu_item_text": "E-Mail senden", "must_save": true, "tooltip": "E-Mail senden", "panel_btn_handler": Lino.row_action_handler('send_mail','GET'), "iconCls": "x-tbar-email_send", "overflowText": "E-Mail senden", "auto_save": true } ],
  title : "E-Mail-Ausg\u00e4nge",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "sent" }, { "name": "recipients" }, { "name": "subject" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "user" }, 'userHidden', { "name": "project" }, 'projectHidden', { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "owner" }, { "name": "body" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 62,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 16,
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.Mails.detail;
    this.ls_insert_handler = Lino.outbox.Mails.insert;
    var ww = this.containing_window;
    var sent2312 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var recipients_htmlbox2313 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "recipients", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Empf\u00e4nger", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden" });
    var subject2314 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id2315 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2316 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id2317 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/owner_id", "method": "GET" }) }) });
    var user2318 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var project2319 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Projekt ausw\u00e4hlen..." });
    var date2320 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var owner_disp2321 = new Ext.form.DisplayField({ "disabled": true });
    var body2322 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Inhalt" });
    this.before_row_edit = function(record) {
      recipients_htmlbox2313.refresh();
      owner_id2317.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      body2322.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2316.on('change',Lino.chooser_handler(owner_id2317,'owner_type'));
      Lino.outbox.Mails.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(17), "colIndex": 0, "sortable": true, "dataIndex": "sent", "header": "sent", "editable": false }, { "width": Lino.chars2width(31), "colIndex": 1, "sortable": false, "dataIndex": "recipients", "header": "Empf\u00e4nger", "editable": false }, { "colIndex": 2, "sortable": true, "header": "Betreff", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "subject", "editor": subject2314 }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2315, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.ui.ContentTypes.detail'), "editor": owner_type2316, "dataIndex": "owner_type" }, { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id2317 }, { "colIndex": 6, "sortable": true, "header": "Absender", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2318, "dataIndex": "user" }, { "colIndex": 7, "sortable": true, "header": "Projekt", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail'), "editor": project2319, "dataIndex": "project" }, { "colIndex": 8, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "\n        The official date to be printed on the document.\n        ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Datum", "dataIndex": "date", "width": Lino.chars2width(9), "editor": date2320 }, { "width": Lino.chars2width(11), "colIndex": 9, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "editable": false }, { "colIndex": 10, "sortable": false, "header": "body", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": body2322, "dataIndex": "body" } ];
    Lino.outbox.Mails.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.Mails.insertPanel = Ext.extend(Lino.outbox.Mails.InsertFormPanel,{
  empty_title: "Neu E-Mail-Ausg\u00e4nge",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/outbox/Mails",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.Mails.detail;
    this.ls_insert_handler = Lino.outbox.Mails.insert;
    Lino.outbox.Mails.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.Mails.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(20) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.outbox.Mails.insertPanel(p);
});

Lino.outbox.Mails.detailPanel = Ext.extend(Lino.outbox.Mails.DetailFormPanel,{
  empty_title: "Detail E-Mail-Ausg\u00e4nge",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "send_mail", "menu_item_text": "E-Mail senden", "must_save": true, "tooltip": "E-Mail senden", "panel_btn_handler": Lino.row_action_handler('send_mail','GET'), "iconCls": "x-tbar-email_send", "overflowText": "E-Mail senden", "auto_save": true } ],
  ls_url: "/outbox/Mails",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.Mails.detail;
    this.ls_insert_handler = Lino.outbox.Mails.insert;
    Lino.outbox.Mails.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.Mails.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.Mails.detailPanel(p);
});
Lino.outbox.Mails.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.Mails.GridPanel(p);
});

// js_render_GridPanel_class outbox.Attachments
Lino.outbox.Attachments.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/outbox/Attachments",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Anh\u00e4nge",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "mail" }, 'mailHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 64,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    var ww = this.containing_window;
    var id2324 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2325 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Attachments/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id2326 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Attachments/owner_id", "method": "GET" }) }) });
    var mail2327 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Attachments/mail", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "E-Mail-Ausgang ausw\u00e4hlen..." });
    var owner_disp2328 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id2326.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type2325.on('change',Lino.chooser_handler(owner_id2326,'owner_type'));
      Lino.outbox.Attachments.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2324, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.ui.ContentTypes.detail'), "editor": owner_type2325, "dataIndex": "owner_type" }, { "colIndex": 2, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id2326 }, { "colIndex": 3, "sortable": true, "header": "E-Mail-Ausgang", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('mailHidden','Lino.outbox.Mails.detail'), "editor": mail2327, "dataIndex": "mail" }, { "width": Lino.chars2width(11), "colIndex": 4, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "editable": false } ];
    Lino.outbox.Attachments.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.Attachments.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.Attachments.GridPanel(p);
});

// js_render_GridPanel_class cal.Calendars
Lino.cal.Calendars.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/Calendars",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Kalenderliste",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "type" }, 'typeHidden', { "type": "int", "name": "color" }, { "type": "boolean", "name": "readonly" }, { "name": "build_method" }, 'build_methodHidden', { "name": "template" }, { "type": "int", "name": "id" }, { "type": "boolean", "name": "attach_to_email" }, { "name": "email_template" }, { "name": "description" }, { "name": "url_template" }, { "name": "username" }, { "name": "password" }, { "name": "invite_team_members" }, 'invite_team_membersHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 11,
  ls_grid_configs : [  ],
  content_type : 59,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 22,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Calendars.detail;
    this.ls_insert_handler = Lino.cal.Calendars.insert;
    var ww = this.containing_window;
    var name2330 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2331 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2332 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en2333 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type2334 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "local", "Local Calendar" ], [ "google", "Google Calendar" ] ], "allowBlank": false, "value": "local" });
    var color2335 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 1 });
    var readonly2336 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var build_method2337 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template2338 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/template", "method": "GET" }) }) });
    var id2339 = new Ext.form.NumberField({ "selectOnFocus": true });
    var attach_to_email2340 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var email_template2341 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/email_template", "method": "GET" }) }) });
    var description2342 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Beschreibung" });
    var url_template2343 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var username2344 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var password2345 = new Ext.form.TextField({ "selectOnFocus": true, "inputType": "password", "maxLength": 200 });
    var invite_team_members2346 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/invite_team_members", "method": "GET" }) }), "pageSize": 20, "emptyText": "Team ausw\u00e4hlen..." });
    var start_date2347 = new Lino.DateField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      template2338.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      description2342.refresh();
    };
    this.onRender = function(ct, position) {
      build_method2337.on('change',Lino.chooser_handler(template2338,'build_method'));
      Lino.cal.Calendars.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2330 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2331 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et2332 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en2333 }, { "colIndex": 4, "sortable": true, "header": "Art", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type2334 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Farbe", "dataIndex": "color", "width": Lino.chars2width(6), "editor": color2335 }), { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "schreibgesch\u00fctzt", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "readonly" }, { "colIndex": 7, "sortable": true, "header": "Konstruktionsmethode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "build_method", "editor": build_method2337 }, { "colIndex": 8, "sortable": true, "header": "Vorlage", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "template", "editor": template2338 }, new Lino.NullNumberColumn({ "colIndex": 9, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2339, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 10, "sortable": false, "xtype": "checkcolumn", "header": "als Anhang per E-Mail", "editable": true, "tooltip": "Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "attach_to_email" }, { "colIndex": 11, "sortable": true, "header": "E-Mail-Vorlage", "editable": true, "tooltip": "The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "email_template", "editor": email_template2341 }, { "colIndex": 12, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": description2342, "dataIndex": "description" }, { "colIndex": 13, "sortable": true, "header": "URL-Vorlage", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url_template", "editor": url_template2343 }, { "colIndex": 14, "sortable": true, "header": "Benutzername", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "username", "editor": username2344 }, { "colIndex": 15, "sortable": true, "header": "Passwort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "password", "editor": password2345 }, { "colIndex": 16, "sortable": true, "header": "Team", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "invite_team_members", "editor": invite_team_members2346 }, { "colIndex": 17, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "editor": start_date2347, "width": Lino.chars2width(9), "dataIndex": "start_date" } ];
    Lino.cal.Calendars.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Calendars.insertPanel = Ext.extend(Lino.cal.Calendars.InsertFormPanel,{
  empty_title: "Neu Kalenderliste",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cal/Calendars",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Calendars.detail;
    this.ls_insert_handler = Lino.cal.Calendars.insert;
    Lino.cal.Calendars.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Calendars.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Calendars.insertPanel(p);
});

Lino.cal.Calendars.detailPanel = Ext.extend(Lino.cal.Calendars.DetailFormPanel,{
  empty_title: "Detail Kalenderliste",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/cal/Calendars",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Calendars.detail;
    this.ls_insert_handler = Lino.cal.Calendars.insert;
    Lino.cal.Calendars.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Calendars.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Calendars.detailPanel(p);
});
Lino.cal.Calendars.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Calendars.GridPanel(p);
});

// js_render_GridPanel_class cal.Subscriptions
Lino.cal.Subscriptions.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/Subscriptions",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Abonnements",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "calendar" }, 'calendarHidden', { "type": "boolean", "name": "is_hidden" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 61,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    var ww = this.containing_window;
    var id2349 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user2350 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Subscriptions/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var calendar2351 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Subscriptions/calendar", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    var is_hidden2352 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2349, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2350, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "Kalender", "editable": true, "tooltip": "The calendar you want to subscribe to.\nYou can subscribe to *non-private* calendars of *other* users.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.Calendars.detail'), "editor": calendar2351, "dataIndex": "calendar" }, { "colIndex": 3, "sortable": false, "xtype": "checkcolumn", "header": "versteckt", "editable": true, "tooltip": "Ob dieser Kalender im Kalender-Fenster anfangs deaktiviert sein sol.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_hidden" } ];
    Lino.cal.Subscriptions.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Subscriptions.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Subscriptions.GridPanel(p);
});

// js_render_GridPanel_class cal.Places
Lino.cal.Places.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/Places",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Orte",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 57,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Places.detail;
    this.ls_insert_handler = Lino.cal.Places.insert;
    var ww = this.containing_window;
    var id2354 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2355 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2356 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2357 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en2358 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2354, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2355 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2356 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et2357 }, { "colIndex": 4, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en2358 } ];
    Lino.cal.Places.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Places.insertPanel = Ext.extend(Lino.cal.Places.DetailFormPanel,{
  empty_title: "Neu Orte",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cal/Places",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Places.detail;
    this.ls_insert_handler = Lino.cal.Places.insert;
    Lino.cal.Places.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Places.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Places.insertPanel(p);
});

Lino.cal.Places.detailPanel = Ext.extend(Lino.cal.Places.DetailFormPanel,{
  empty_title: "Detail Orte",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/cal/Places",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Places.detail;
    this.ls_insert_handler = Lino.cal.Places.insert;
    Lino.cal.Places.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Places.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Places.detailPanel(p);
});
Lino.cal.Places.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Places.GridPanel(p);
});

// js_render_GridPanel_class cal.Priorities
Lino.cal.Priorities.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/Priorities",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Priorit\u00e4ten",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "type": "int", "name": "id" }, { "name": "ref" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 56,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    var ww = this.containing_window;
    var name2360 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2361 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2362 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en2363 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id2364 = new Ext.form.NumberField({ "selectOnFocus": true });
    var ref2365 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": "1" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2360 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2361 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et2362 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en2363 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2364, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "ref", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ref", "editor": ref2365 } ];
    Lino.cal.Priorities.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Priorities.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Priorities.GridPanel(p);
});

// js_render_GridPanel_class cal.Events
Lino.cal.Events.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/Events",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true } ],
  title : "Termine",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "name": "user" }, 'userHidden', { "name": "summary" }, { "name": "calendar" }, 'calendarHidden', { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "created" }, { "name": "modified" }, { "name": "project" }, 'projectHidden', { "name": "build_time" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "description" }, { "name": "uid" }, { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "place" }, 'placeHidden', { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 60,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 36,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Events.detail;
    this.ls_insert_handler = Lino.cal.Events.insert;
    var ww = this.containing_window;
    var start_date2367 = new Lino.DateField({ "selectOnFocus": true });
    var start_time2368 = new Lino.TimeField({ "selectOnFocus": true });
    var user2369 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var summary2370 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var calendar2371 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    var id2372 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2373 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id2374 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/owner_id", "method": "GET" }) }) });
    var created2375 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2376 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var project2377 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Projekt ausw\u00e4hlen..." });
    var build_time2378 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var end_date2379 = new Lino.DateField({ "selectOnFocus": true });
    var end_time2380 = new Lino.TimeField({ "selectOnFocus": true });
    var description2381 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Beschreibung" });
    var uid2382 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var access_class2383 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.cal.AccessClasses });
    var sequence2384 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type2385 = new Ext.form.NumberField({ "disabled": true });
    var transparent2386 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var place2387 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/place", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var priority2388 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Priorit\u00e4t ausw\u00e4hlen..." });
    var state2389 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var assigned_to2390 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var owner_disp2391 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id2374.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description2381.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2373.on('change',Lino.chooser_handler(owner_id2374,'owner_type'));
      Lino.cal.Events.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "editor": start_date2367, "width": Lino.chars2width(9), "dataIndex": "start_date" }, { "width": Lino.chars2width(9), "colIndex": 1, "sortable": true, "dataIndex": "start_time", "header": "Beginnt um", "editable": true, "editor": start_time2368 }, { "colIndex": 2, "sortable": true, "header": "Verantwortlicher", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2369, "dataIndex": "user" }, { "colIndex": 3, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary2370 }, { "colIndex": 4, "sortable": true, "header": "Kalender", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.Calendars.detail'), "editor": calendar2371, "dataIndex": "calendar" }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2372, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.ui.ContentTypes.detail'), "hidden": true, "editor": owner_type2373, "dataIndex": "owner_type" }, { "colIndex": 7, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "hidden": true, "editor": owner_id2374 }, { "width": Lino.chars2width(17), "colIndex": 8, "sortable": true, "dataIndex": "created", "header": "Erstellt", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 9, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "hidden": true, "editable": false }, { "colIndex": 10, "sortable": true, "header": "Projekt", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail'), "editor": project2377, "dataIndex": "project" }, { "width": Lino.chars2width(17), "colIndex": 11, "sortable": true, "dataIndex": "build_time", "header": "Druckdatum", "hidden": true, "editable": false }, { "colIndex": 12, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Endet am", "dataIndex": "end_date", "hidden": true, "width": Lino.chars2width(9), "editor": end_date2379 }, { "colIndex": 13, "sortable": true, "header": "Endet um", "editable": true, "width": Lino.chars2width(9), "dataIndex": "end_time", "hidden": true, "editor": end_time2380 }, { "colIndex": 14, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": description2381, "dataIndex": "description" }, { "colIndex": 15, "sortable": true, "header": "UID", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "uid", "hidden": true, "editor": uid2382 }, { "colIndex": 16, "sortable": true, "header": "Zugriffsklasse", "editable": true, "tooltip": "Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist", "filter": { "type": "string" }, "width": Lino.chars2width(35), "dataIndex": "access_class", "hidden": true, "editor": access_class2383 }, new Lino.NullNumberColumn({ "colIndex": 17, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Revisionsnummer", "dataIndex": "sequence", "hidden": true, "width": Lino.chars2width(6), "editor": sequence2384 }), new Lino.NullNumberColumn({ "colIndex": 18, "sortable": true, "format": "0", "editable": false, "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 19, "sortable": false, "xtype": "checkcolumn", "header": "nicht blockierend", "editable": true, "tooltip": "Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "transparent", "hidden": true }, { "colIndex": 20, "sortable": true, "header": "Ort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('placeHidden','Lino.cal.Places.detail'), "hidden": true, "editor": place2387, "dataIndex": "place" }, { "colIndex": 21, "sortable": true, "header": "Priorit\u00e4t", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "priority", "hidden": true, "editor": priority2388 }, { "colIndex": 22, "sortable": true, "header": "Zustand", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(17), "dataIndex": "state", "editor": state2389 }, { "colIndex": 23, "sortable": true, "header": "Zugewiesen zu", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('assigned_toHidden','Lino.users.Users.detail'), "editor": assigned_to2390, "dataIndex": "assigned_to" }, { "width": Lino.chars2width(11), "colIndex": 24, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "hidden": true, "editable": false } ];
    Lino.cal.Events.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Events.insertPanel = Ext.extend(Lino.cal.Events.InsertFormPanel,{
  empty_title: "Neu Termine",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cal/Events",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Events.detail;
    this.ls_insert_handler = Lino.cal.Events.insert;
    Lino.cal.Events.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Events.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Events.insertPanel(p);
});
Lino.cal.Events.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Events",pk,"wf1");
};
Lino.cal.Events.wf2 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Events",pk,"wf2");
};
Lino.cal.Events.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Events",pk,"wf3");
};
Lino.cal.Events.wf4 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Events",pk,"wf4");
};
Lino.cal.Events.wf5 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Events",pk,"wf5");
};
Lino.cal.Events.wf6 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Events",pk,"wf6");
};
Lino.cal.Events.wf7 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Events",pk,"wf7");
};
Lino.cal.Events.wf8 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Events",pk,"wf8");
};

Lino.cal.Events.detailPanel = Ext.extend(Lino.cal.Events.DetailFormPanel,{
  empty_title: "Detail Termine",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true } ],
  ls_url: "/cal/Events",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Events.detail;
    this.ls_insert_handler = Lino.cal.Events.insert;
    Lino.cal.Events.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Events.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Events.detailPanel(p);
});
Lino.cal.Events.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Events.ParamsPanel({});
  return new Lino.cal.Events.GridPanel(p);
});

// js_render_GridPanel_class cal.MyEvents
Lino.cal.MyEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/MyEvents",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true } ],
  title : "Termine",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "name": "calendar" }, 'calendarHidden', { "name": "project" }, 'projectHidden', { "name": "summary" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "user" }, 'userHidden', { "name": "created" }, { "name": "modified" }, { "name": "build_time" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "description" }, { "name": "uid" }, { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "place" }, 'placeHidden', { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 60,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 36,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEvents.detail;
    this.ls_insert_handler = Lino.cal.MyEvents.insert;
    var ww = this.containing_window;
    var start_date2393 = new Lino.DateField({ "selectOnFocus": true });
    var start_time2394 = new Lino.TimeField({ "selectOnFocus": true });
    var calendar2395 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    var project2396 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Projekt ausw\u00e4hlen..." });
    var summary2397 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id2398 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2399 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id2400 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/owner_id", "method": "GET" }) }) });
    var user2401 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var created2402 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2403 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_time2404 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var end_date2405 = new Lino.DateField({ "selectOnFocus": true });
    var end_time2406 = new Lino.TimeField({ "selectOnFocus": true });
    var description2407 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Beschreibung" });
    var uid2408 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var access_class2409 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.cal.AccessClasses });
    var sequence2410 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type2411 = new Ext.form.NumberField({ "disabled": true });
    var transparent2412 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var place2413 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/place", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var priority2414 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Priorit\u00e4t ausw\u00e4hlen..." });
    var state2415 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var assigned_to2416 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var owner_disp2417 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id2400.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description2407.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2399.on('change',Lino.chooser_handler(owner_id2400,'owner_type'));
      Lino.cal.MyEvents.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "editor": start_date2393, "width": Lino.chars2width(9), "dataIndex": "start_date" }, { "width": Lino.chars2width(9), "colIndex": 1, "sortable": true, "dataIndex": "start_time", "header": "Beginnt um", "editable": true, "editor": start_time2394 }, { "colIndex": 2, "sortable": true, "header": "Kalender", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.Calendars.detail'), "editor": calendar2395, "dataIndex": "calendar" }, { "colIndex": 3, "sortable": true, "header": "Projekt", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail'), "editor": project2396, "dataIndex": "project" }, { "colIndex": 4, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary2397 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2398, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.ui.ContentTypes.detail'), "hidden": true, "editor": owner_type2399, "dataIndex": "owner_type" }, { "colIndex": 7, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "hidden": true, "editor": owner_id2400 }, { "colIndex": 8, "sortable": true, "header": "Verantwortlicher", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2401, "dataIndex": "user" }, { "width": Lino.chars2width(17), "colIndex": 9, "sortable": true, "dataIndex": "created", "header": "Erstellt", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 10, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 11, "sortable": true, "dataIndex": "build_time", "header": "Druckdatum", "hidden": true, "editable": false }, { "colIndex": 12, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Endet am", "dataIndex": "end_date", "hidden": true, "width": Lino.chars2width(9), "editor": end_date2405 }, { "colIndex": 13, "sortable": true, "header": "Endet um", "editable": true, "width": Lino.chars2width(9), "dataIndex": "end_time", "hidden": true, "editor": end_time2406 }, { "colIndex": 14, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": description2407, "dataIndex": "description" }, { "colIndex": 15, "sortable": true, "header": "UID", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "uid", "hidden": true, "editor": uid2408 }, { "colIndex": 16, "sortable": true, "header": "Zugriffsklasse", "editable": true, "tooltip": "Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist", "filter": { "type": "string" }, "width": Lino.chars2width(35), "dataIndex": "access_class", "hidden": true, "editor": access_class2409 }, new Lino.NullNumberColumn({ "colIndex": 17, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Revisionsnummer", "dataIndex": "sequence", "hidden": true, "width": Lino.chars2width(6), "editor": sequence2410 }), new Lino.NullNumberColumn({ "colIndex": 18, "sortable": true, "format": "0", "editable": false, "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 19, "sortable": false, "xtype": "checkcolumn", "header": "nicht blockierend", "editable": true, "tooltip": "Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "transparent", "hidden": true }, { "colIndex": 20, "sortable": true, "header": "Ort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('placeHidden','Lino.cal.Places.detail'), "hidden": true, "editor": place2413, "dataIndex": "place" }, { "colIndex": 21, "sortable": true, "header": "Priorit\u00e4t", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "priority", "hidden": true, "editor": priority2414 }, { "colIndex": 22, "sortable": true, "header": "Zustand", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(17), "dataIndex": "state", "editor": state2415 }, { "colIndex": 23, "sortable": true, "header": "Zugewiesen zu", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('assigned_toHidden','Lino.users.Users.detail'), "editor": assigned_to2416, "dataIndex": "assigned_to" }, { "width": Lino.chars2width(11), "colIndex": 24, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "hidden": true, "editable": false } ];
    Lino.cal.MyEvents.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyEvents.insertPanel = Ext.extend(Lino.cal.Events.InsertFormPanel,{
  empty_title: "Neu Termine",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cal/MyEvents",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEvents.detail;
    this.ls_insert_handler = Lino.cal.MyEvents.insert;
    Lino.cal.MyEvents.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEvents.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyEvents.insertPanel(p);
});
Lino.cal.MyEvents.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents",pk,"wf1");
};
Lino.cal.MyEvents.wf2 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents",pk,"wf2");
};
Lino.cal.MyEvents.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents",pk,"wf3");
};
Lino.cal.MyEvents.wf4 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents",pk,"wf4");
};
Lino.cal.MyEvents.wf5 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents",pk,"wf5");
};
Lino.cal.MyEvents.wf6 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents",pk,"wf6");
};
Lino.cal.MyEvents.wf7 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents",pk,"wf7");
};
Lino.cal.MyEvents.wf8 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEvents",pk,"wf8");
};

Lino.cal.MyEvents.detailPanel = Ext.extend(Lino.cal.Events.DetailFormPanel,{
  empty_title: "Detail Termine",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true } ],
  ls_url: "/cal/MyEvents",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEvents.detail;
    this.ls_insert_handler = Lino.cal.MyEvents.insert;
    Lino.cal.MyEvents.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEvents.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyEvents.detailPanel(p);
});
Lino.cal.MyEvents.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Events.ParamsPanel({});
  return new Lino.cal.MyEvents.GridPanel(p);
});

// js_render_GridPanel_class cal.MyUnclearEvents
Lino.cal.MyUnclearEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/MyUnclearEvents",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true } ],
  title : "Meine unklaren Termine",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "name": "project" }, 'projectHidden', { "name": "summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "user" }, 'userHidden', { "name": "created" }, { "name": "modified" }, { "name": "build_time" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "description" }, { "name": "uid" }, { "name": "calendar" }, 'calendarHidden', { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "place" }, 'placeHidden', { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 60,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 37,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyUnclearEvents.detail;
    this.ls_insert_handler = Lino.cal.MyUnclearEvents.insert;
    var ww = this.containing_window;
    var start_date2419 = new Lino.DateField({ "selectOnFocus": true });
    var start_time2420 = new Lino.TimeField({ "selectOnFocus": true });
    var project2421 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyUnclearEvents/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Projekt ausw\u00e4hlen..." });
    var summary2422 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp2423 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id2424 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2425 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyUnclearEvents/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id2426 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyUnclearEvents/owner_id", "method": "GET" }) }) });
    var user2427 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyUnclearEvents/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var created2428 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2429 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_time2430 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var end_date2431 = new Lino.DateField({ "selectOnFocus": true });
    var end_time2432 = new Lino.TimeField({ "selectOnFocus": true });
    var description2433 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Beschreibung" });
    var uid2434 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var calendar2435 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyUnclearEvents/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    var access_class2436 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.cal.AccessClasses });
    var sequence2437 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type2438 = new Ext.form.NumberField({ "disabled": true });
    var transparent2439 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var place2440 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyUnclearEvents/place", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var priority2441 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyUnclearEvents/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Priorit\u00e4t ausw\u00e4hlen..." });
    var state2442 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var assigned_to2443 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyUnclearEvents/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var owner_disp2444 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id2426.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description2433.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2425.on('change',Lino.chooser_handler(owner_id2426,'owner_type'));
      Lino.cal.MyUnclearEvents.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "editor": start_date2419, "width": Lino.chars2width(9), "dataIndex": "start_date" }, { "width": Lino.chars2width(9), "colIndex": 1, "sortable": true, "dataIndex": "start_time", "header": "Beginnt um", "editable": true, "editor": start_time2420 }, { "colIndex": 2, "sortable": true, "header": "Projekt", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail'), "editor": project2421, "dataIndex": "project" }, { "colIndex": 3, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary2422 }, { "width": Lino.chars2width(31), "colIndex": 4, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2424, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.ui.ContentTypes.detail'), "hidden": true, "editor": owner_type2425, "dataIndex": "owner_type" }, { "colIndex": 7, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "hidden": true, "editor": owner_id2426 }, { "colIndex": 8, "sortable": true, "header": "Verantwortlicher", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2427, "dataIndex": "user" }, { "width": Lino.chars2width(17), "colIndex": 9, "sortable": true, "dataIndex": "created", "header": "Erstellt", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 10, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 11, "sortable": true, "dataIndex": "build_time", "header": "Druckdatum", "hidden": true, "editable": false }, { "colIndex": 12, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Endet am", "dataIndex": "end_date", "hidden": true, "width": Lino.chars2width(9), "editor": end_date2431 }, { "colIndex": 13, "sortable": true, "header": "Endet um", "editable": true, "width": Lino.chars2width(9), "dataIndex": "end_time", "hidden": true, "editor": end_time2432 }, { "colIndex": 14, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": description2433, "dataIndex": "description" }, { "colIndex": 15, "sortable": true, "header": "UID", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "uid", "hidden": true, "editor": uid2434 }, { "colIndex": 16, "sortable": true, "header": "Kalender", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.Calendars.detail'), "editor": calendar2435, "dataIndex": "calendar" }, { "colIndex": 17, "sortable": true, "header": "Zugriffsklasse", "editable": true, "tooltip": "Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist", "filter": { "type": "string" }, "width": Lino.chars2width(35), "dataIndex": "access_class", "hidden": true, "editor": access_class2436 }, new Lino.NullNumberColumn({ "colIndex": 18, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Revisionsnummer", "dataIndex": "sequence", "hidden": true, "width": Lino.chars2width(6), "editor": sequence2437 }), new Lino.NullNumberColumn({ "colIndex": 19, "sortable": true, "format": "0", "editable": false, "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "nicht blockierend", "editable": true, "tooltip": "Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "transparent", "hidden": true }, { "colIndex": 21, "sortable": true, "header": "Ort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('placeHidden','Lino.cal.Places.detail'), "hidden": true, "editor": place2440, "dataIndex": "place" }, { "colIndex": 22, "sortable": true, "header": "Priorit\u00e4t", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "priority", "hidden": true, "editor": priority2441 }, { "colIndex": 23, "sortable": true, "header": "Zustand", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(17), "dataIndex": "state", "editor": state2442 }, { "colIndex": 24, "sortable": true, "header": "Zugewiesen zu", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('assigned_toHidden','Lino.users.Users.detail'), "editor": assigned_to2443, "dataIndex": "assigned_to" }, { "width": Lino.chars2width(11), "colIndex": 25, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "hidden": true, "editable": false } ];
    Lino.cal.MyUnclearEvents.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyUnclearEvents.insertPanel = Ext.extend(Lino.cal.Events.InsertFormPanel,{
  empty_title: "Neu Meine unklaren Termine",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cal/MyUnclearEvents",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyUnclearEvents.detail;
    this.ls_insert_handler = Lino.cal.MyUnclearEvents.insert;
    Lino.cal.MyUnclearEvents.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyUnclearEvents.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyUnclearEvents.insertPanel(p);
});
Lino.cal.MyUnclearEvents.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyUnclearEvents",pk,"wf1");
};
Lino.cal.MyUnclearEvents.wf2 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyUnclearEvents",pk,"wf2");
};
Lino.cal.MyUnclearEvents.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyUnclearEvents",pk,"wf3");
};
Lino.cal.MyUnclearEvents.wf4 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyUnclearEvents",pk,"wf4");
};
Lino.cal.MyUnclearEvents.wf5 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyUnclearEvents",pk,"wf5");
};
Lino.cal.MyUnclearEvents.wf6 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyUnclearEvents",pk,"wf6");
};
Lino.cal.MyUnclearEvents.wf7 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyUnclearEvents",pk,"wf7");
};
Lino.cal.MyUnclearEvents.wf8 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyUnclearEvents",pk,"wf8");
};

Lino.cal.MyUnclearEvents.detailPanel = Ext.extend(Lino.cal.Events.DetailFormPanel,{
  empty_title: "Detail Meine unklaren Termine",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true } ],
  ls_url: "/cal/MyUnclearEvents",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyUnclearEvents.detail;
    this.ls_insert_handler = Lino.cal.MyUnclearEvents.insert;
    Lino.cal.MyUnclearEvents.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyUnclearEvents.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyUnclearEvents.detailPanel(p);
});
Lino.cal.MyUnclearEvents.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Events.ParamsPanel({});
  return new Lino.cal.MyUnclearEvents.GridPanel(p);
});

// js_render_GridPanel_class cal.EventsAssignedToMe
Lino.cal.EventsAssignedToMe.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/EventsAssignedToMe",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true } ],
  title : "Termine",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "name": "project" }, 'projectHidden', { "name": "summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "user" }, 'userHidden', { "name": "created" }, { "name": "modified" }, { "name": "build_time" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "description" }, { "name": "uid" }, { "name": "calendar" }, 'calendarHidden', { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "place" }, 'placeHidden', { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 60,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 37,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsAssignedToMe.detail;
    this.ls_insert_handler = Lino.cal.EventsAssignedToMe.insert;
    var ww = this.containing_window;
    var start_date2446 = new Lino.DateField({ "selectOnFocus": true });
    var start_time2447 = new Lino.TimeField({ "selectOnFocus": true });
    var project2448 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsAssignedToMe/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Projekt ausw\u00e4hlen..." });
    var summary2449 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp2450 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id2451 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2452 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsAssignedToMe/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id2453 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsAssignedToMe/owner_id", "method": "GET" }) }) });
    var user2454 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsAssignedToMe/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var created2455 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2456 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_time2457 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var end_date2458 = new Lino.DateField({ "selectOnFocus": true });
    var end_time2459 = new Lino.TimeField({ "selectOnFocus": true });
    var description2460 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Beschreibung" });
    var uid2461 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var calendar2462 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsAssignedToMe/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    var access_class2463 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.cal.AccessClasses });
    var sequence2464 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type2465 = new Ext.form.NumberField({ "disabled": true });
    var transparent2466 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var place2467 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsAssignedToMe/place", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var priority2468 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsAssignedToMe/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Priorit\u00e4t ausw\u00e4hlen..." });
    var state2469 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var assigned_to2470 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsAssignedToMe/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var owner_disp2471 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id2453.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description2460.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2452.on('change',Lino.chooser_handler(owner_id2453,'owner_type'));
      Lino.cal.EventsAssignedToMe.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "editor": start_date2446, "width": Lino.chars2width(9), "dataIndex": "start_date" }, { "width": Lino.chars2width(9), "colIndex": 1, "sortable": true, "dataIndex": "start_time", "header": "Beginnt um", "editable": true, "editor": start_time2447 }, { "colIndex": 2, "sortable": true, "header": "Projekt", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail'), "editor": project2448, "dataIndex": "project" }, { "colIndex": 3, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary2449 }, { "width": Lino.chars2width(31), "colIndex": 4, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2451, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.ui.ContentTypes.detail'), "hidden": true, "editor": owner_type2452, "dataIndex": "owner_type" }, { "colIndex": 7, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "hidden": true, "editor": owner_id2453 }, { "colIndex": 8, "sortable": true, "header": "Verantwortlicher", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2454, "dataIndex": "user" }, { "width": Lino.chars2width(17), "colIndex": 9, "sortable": true, "dataIndex": "created", "header": "Erstellt", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 10, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 11, "sortable": true, "dataIndex": "build_time", "header": "Druckdatum", "hidden": true, "editable": false }, { "colIndex": 12, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Endet am", "dataIndex": "end_date", "hidden": true, "width": Lino.chars2width(9), "editor": end_date2458 }, { "colIndex": 13, "sortable": true, "header": "Endet um", "editable": true, "width": Lino.chars2width(9), "dataIndex": "end_time", "hidden": true, "editor": end_time2459 }, { "colIndex": 14, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": description2460, "dataIndex": "description" }, { "colIndex": 15, "sortable": true, "header": "UID", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "uid", "hidden": true, "editor": uid2461 }, { "colIndex": 16, "sortable": true, "header": "Kalender", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.Calendars.detail'), "editor": calendar2462, "dataIndex": "calendar" }, { "colIndex": 17, "sortable": true, "header": "Zugriffsklasse", "editable": true, "tooltip": "Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist", "filter": { "type": "string" }, "width": Lino.chars2width(35), "dataIndex": "access_class", "hidden": true, "editor": access_class2463 }, new Lino.NullNumberColumn({ "colIndex": 18, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Revisionsnummer", "dataIndex": "sequence", "hidden": true, "width": Lino.chars2width(6), "editor": sequence2464 }), new Lino.NullNumberColumn({ "colIndex": 19, "sortable": true, "format": "0", "editable": false, "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "nicht blockierend", "editable": true, "tooltip": "Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "transparent", "hidden": true }, { "colIndex": 21, "sortable": true, "header": "Ort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('placeHidden','Lino.cal.Places.detail'), "hidden": true, "editor": place2467, "dataIndex": "place" }, { "colIndex": 22, "sortable": true, "header": "Priorit\u00e4t", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "priority", "hidden": true, "editor": priority2468 }, { "colIndex": 23, "sortable": true, "header": "Zustand", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(17), "dataIndex": "state", "editor": state2469 }, { "colIndex": 24, "sortable": true, "header": "Zugewiesen zu", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('assigned_toHidden','Lino.users.Users.detail'), "editor": assigned_to2470, "dataIndex": "assigned_to" }, { "width": Lino.chars2width(11), "colIndex": 25, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "hidden": true, "editable": false } ];
    Lino.cal.EventsAssignedToMe.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.EventsAssignedToMe.insertPanel = Ext.extend(Lino.cal.Events.InsertFormPanel,{
  empty_title: "Neu Termine",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cal/EventsAssignedToMe",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsAssignedToMe.detail;
    this.ls_insert_handler = Lino.cal.EventsAssignedToMe.insert;
    Lino.cal.EventsAssignedToMe.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsAssignedToMe.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.EventsAssignedToMe.insertPanel(p);
});
Lino.cal.EventsAssignedToMe.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/EventsAssignedToMe",pk,"wf1");
};
Lino.cal.EventsAssignedToMe.wf2 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/EventsAssignedToMe",pk,"wf2");
};
Lino.cal.EventsAssignedToMe.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/EventsAssignedToMe",pk,"wf3");
};
Lino.cal.EventsAssignedToMe.wf4 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/EventsAssignedToMe",pk,"wf4");
};
Lino.cal.EventsAssignedToMe.wf5 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/EventsAssignedToMe",pk,"wf5");
};
Lino.cal.EventsAssignedToMe.wf6 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/EventsAssignedToMe",pk,"wf6");
};
Lino.cal.EventsAssignedToMe.wf7 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/EventsAssignedToMe",pk,"wf7");
};
Lino.cal.EventsAssignedToMe.wf8 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/EventsAssignedToMe",pk,"wf8");
};

Lino.cal.EventsAssignedToMe.detailPanel = Ext.extend(Lino.cal.Events.DetailFormPanel,{
  empty_title: "Detail Termine",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true } ],
  ls_url: "/cal/EventsAssignedToMe",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsAssignedToMe.detail;
    this.ls_insert_handler = Lino.cal.EventsAssignedToMe.insert;
    Lino.cal.EventsAssignedToMe.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsAssignedToMe.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.EventsAssignedToMe.detailPanel(p);
});
Lino.cal.EventsAssignedToMe.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Events.ParamsPanel({});
  return new Lino.cal.EventsAssignedToMe.GridPanel(p);
});

// js_render_GridPanel_class cal.MyEventsToday
Lino.cal.MyEventsToday.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/MyEventsToday",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true } ],
  title : "Meine Termine heute",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "start_time" }, { "name": "summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "user" }, 'userHidden', { "name": "created" }, { "name": "modified" }, { "name": "project" }, 'projectHidden', { "name": "build_time" }, { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "description" }, { "name": "uid" }, { "name": "calendar" }, 'calendarHidden', { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "place" }, 'placeHidden', { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 60,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 37,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEventsToday.detail;
    this.ls_insert_handler = Lino.cal.MyEventsToday.insert;
    var ww = this.containing_window;
    var start_time2473 = new Lino.TimeField({ "selectOnFocus": true });
    var summary2474 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp2475 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id2476 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2477 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id2478 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/owner_id", "method": "GET" }) }) });
    var user2479 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var created2480 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2481 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var project2482 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Projekt ausw\u00e4hlen..." });
    var build_time2483 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var start_date2484 = new Lino.DateField({ "selectOnFocus": true });
    var end_date2485 = new Lino.DateField({ "selectOnFocus": true });
    var end_time2486 = new Lino.TimeField({ "selectOnFocus": true });
    var description2487 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Beschreibung" });
    var uid2488 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var calendar2489 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    var access_class2490 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.cal.AccessClasses });
    var sequence2491 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type2492 = new Ext.form.NumberField({ "disabled": true });
    var transparent2493 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var place2494 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/place", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var priority2495 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Priorit\u00e4t ausw\u00e4hlen..." });
    var state2496 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var assigned_to2497 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var owner_disp2498 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id2478.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description2487.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2477.on('change',Lino.chooser_handler(owner_id2478,'owner_type'));
      Lino.cal.MyEventsToday.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(9), "colIndex": 0, "sortable": true, "dataIndex": "start_time", "header": "Beginnt um", "editable": true, "editor": start_time2473 }, { "colIndex": 1, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary2474 }, { "width": Lino.chars2width(31), "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2476, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.ui.ContentTypes.detail'), "hidden": true, "editor": owner_type2477, "dataIndex": "owner_type" }, { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "hidden": true, "editor": owner_id2478 }, { "colIndex": 6, "sortable": true, "header": "Verantwortlicher", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2479, "dataIndex": "user" }, { "width": Lino.chars2width(17), "colIndex": 7, "sortable": true, "dataIndex": "created", "header": "Erstellt", "hidden": true, "editable": false }, { "width": Lino.chars2width(17), "colIndex": 8, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "hidden": true, "editable": false }, { "colIndex": 9, "sortable": true, "header": "Projekt", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail'), "editor": project2482, "dataIndex": "project" }, { "width": Lino.chars2width(17), "colIndex": 10, "sortable": true, "dataIndex": "build_time", "header": "Druckdatum", "hidden": true, "editable": false }, { "colIndex": 11, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "editor": start_date2484, "width": Lino.chars2width(9), "dataIndex": "start_date" }, { "colIndex": 12, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Endet am", "dataIndex": "end_date", "hidden": true, "width": Lino.chars2width(9), "editor": end_date2485 }, { "colIndex": 13, "sortable": true, "header": "Endet um", "editable": true, "width": Lino.chars2width(9), "dataIndex": "end_time", "hidden": true, "editor": end_time2486 }, { "colIndex": 14, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": description2487, "dataIndex": "description" }, { "colIndex": 15, "sortable": true, "header": "UID", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "uid", "hidden": true, "editor": uid2488 }, { "colIndex": 16, "sortable": true, "header": "Kalender", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.Calendars.detail'), "editor": calendar2489, "dataIndex": "calendar" }, { "colIndex": 17, "sortable": true, "header": "Zugriffsklasse", "editable": true, "tooltip": "Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist", "filter": { "type": "string" }, "width": Lino.chars2width(35), "dataIndex": "access_class", "hidden": true, "editor": access_class2490 }, new Lino.NullNumberColumn({ "colIndex": 18, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Revisionsnummer", "dataIndex": "sequence", "hidden": true, "width": Lino.chars2width(6), "editor": sequence2491 }), new Lino.NullNumberColumn({ "colIndex": 19, "sortable": true, "format": "0", "editable": false, "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "nicht blockierend", "editable": true, "tooltip": "Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "transparent", "hidden": true }, { "colIndex": 21, "sortable": true, "header": "Ort", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('placeHidden','Lino.cal.Places.detail'), "hidden": true, "editor": place2494, "dataIndex": "place" }, { "colIndex": 22, "sortable": true, "header": "Priorit\u00e4t", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "priority", "hidden": true, "editor": priority2495 }, { "colIndex": 23, "sortable": true, "header": "Zustand", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(17), "dataIndex": "state", "editor": state2496 }, { "colIndex": 24, "sortable": true, "header": "Zugewiesen zu", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('assigned_toHidden','Lino.users.Users.detail'), "editor": assigned_to2497, "dataIndex": "assigned_to" }, { "width": Lino.chars2width(11), "colIndex": 25, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "hidden": true, "editable": false } ];
    Lino.cal.MyEventsToday.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyEventsToday.insertPanel = Ext.extend(Lino.cal.Events.InsertFormPanel,{
  empty_title: "Neu Meine Termine heute",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cal/MyEventsToday",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEventsToday.detail;
    this.ls_insert_handler = Lino.cal.MyEventsToday.insert;
    Lino.cal.MyEventsToday.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEventsToday.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyEventsToday.insertPanel(p);
});
Lino.cal.MyEventsToday.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEventsToday",pk,"wf1");
};
Lino.cal.MyEventsToday.wf2 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEventsToday",pk,"wf2");
};
Lino.cal.MyEventsToday.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEventsToday",pk,"wf3");
};
Lino.cal.MyEventsToday.wf4 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEventsToday",pk,"wf4");
};
Lino.cal.MyEventsToday.wf5 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEventsToday",pk,"wf5");
};
Lino.cal.MyEventsToday.wf6 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEventsToday",pk,"wf6");
};
Lino.cal.MyEventsToday.wf7 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEventsToday",pk,"wf7");
};
Lino.cal.MyEventsToday.wf8 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/MyEventsToday",pk,"wf8");
};

Lino.cal.MyEventsToday.detailPanel = Ext.extend(Lino.cal.Events.DetailFormPanel,{
  empty_title: "Detail Meine Termine heute",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "must_save": true, "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "must_save": true, "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "must_save": true, "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Cache l\u00f6schen", "auto_save": true } ],
  ls_url: "/cal/MyEventsToday",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEventsToday.detail;
    this.ls_insert_handler = Lino.cal.MyEventsToday.insert;
    Lino.cal.MyEventsToday.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEventsToday.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyEventsToday.detailPanel(p);
});
Lino.cal.MyEventsToday.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Events.ParamsPanel({});
  return new Lino.cal.MyEventsToday.GridPanel(p);
});

// js_render_GridPanel_class cal.Tasks
Lino.cal.Tasks.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/Tasks",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Aufgaben",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "user" }, 'userHidden', { "name": "created" }, { "name": "modified" }, { "name": "project" }, 'projectHidden', { "name": "start_time" }, { "name": "description" }, { "name": "uid" }, { "name": "calendar" }, 'calendarHidden', { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "date", "name": "due_date", "dateFormat": "d.m.Y" }, { "name": "due_time" }, { "type": "int", "name": "percent" }, { "name": "state" }, 'stateHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 54,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 30,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Tasks.detail;
    this.ls_insert_handler = Lino.cal.Tasks.insert;
    var ww = this.containing_window;
    var start_date2500 = new Lino.DateField({ "selectOnFocus": true });
    var summary2501 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp2502 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id2503 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type2504 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Inhaltstyp ausw\u00e4hlen..." });
    var owner_id2505 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/owner_id", "method": "GET" }) }) });
    var user2506 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var created2507 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2508 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var project2509 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Projekt ausw\u00e4hlen..." });
    var start_time2510 = new Lino.TimeField({ "selectOnFocus": true });
    var description2511 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Beschreibung" });
    var uid2512 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var calendar2513 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    var access_class2514 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.cal.AccessClasses });
    var sequence2515 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type2516 = new Ext.form.NumberField({ "disabled": true });
    var due_date2517 = new Lino.DateField({ "selectOnFocus": true });
    var due_time2518 = new Lino.TimeField({ "selectOnFocus": true });
    var percent2519 = new Ext.form.NumberField({ "selectOnFocus": true });
    var state2520 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.TaskStates });
    var owner_disp2521 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
      owner_id2505.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description2511.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2504.on('change',Lino.chooser_handler(owner_id2505,'owner_type'));
      Lino.cal.Tasks.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "editor": start_date2500, "width": Lino.chars2width(9), "dataIndex": "start_date" }, { "colIndex": 1, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary2501 }, { "width": Lino.chars2width(31), "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "header": "Arbeitsablauf", "editable": false }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2503, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Verkn\u00fcpft mit (Modell)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.ui.ContentTypes.detail'), "editor": owner_type2504, "dataIndex": "owner_type" }, { "colIndex": 5, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id2505 }, { "colIndex": 6, "sortable": true, "header": "Autor", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2506, "dataIndex": "user" }, { "width": Lino.chars2width(17), "colIndex": 7, "sortable": true, "dataIndex": "created", "header": "Erstellt", "editable": false }, { "width": Lino.chars2width(17), "colIndex": 8, "sortable": true, "dataIndex": "modified", "header": "Bearbeitet", "editable": false }, { "colIndex": 9, "sortable": true, "header": "Projekt", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail'), "editor": project2509, "dataIndex": "project" }, { "width": Lino.chars2width(9), "colIndex": 10, "sortable": true, "dataIndex": "start_time", "header": "Beginnt um", "editable": true, "editor": start_time2510 }, { "colIndex": 11, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": description2511, "dataIndex": "description" }, { "colIndex": 12, "sortable": true, "header": "UID", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "uid", "editor": uid2512 }, { "colIndex": 13, "sortable": true, "header": "Kalender", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.Calendars.detail'), "editor": calendar2513, "dataIndex": "calendar" }, { "colIndex": 14, "sortable": true, "header": "Zugriffsklasse", "editable": true, "tooltip": "Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist", "filter": { "type": "string" }, "width": Lino.chars2width(35), "dataIndex": "access_class", "editor": access_class2514 }, new Lino.NullNumberColumn({ "colIndex": 15, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Revisionsnummer", "dataIndex": "sequence", "width": Lino.chars2width(6), "editor": sequence2515 }), new Lino.NullNumberColumn({ "colIndex": 16, "sortable": true, "format": "0", "editable": false, "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "width": Lino.chars2width(6) }), { "colIndex": 17, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Zahlungsziel", "editor": due_date2517, "width": Lino.chars2width(9), "dataIndex": "due_date" }, { "width": Lino.chars2width(9), "colIndex": 18, "sortable": true, "dataIndex": "due_time", "header": "F\u00e4llig um", "editable": true, "editor": due_time2518 }, new Lino.NullNumberColumn({ "colIndex": 19, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Dauer (Anzahl)", "dataIndex": "percent", "width": Lino.chars2width(6), "editor": percent2519 }), { "colIndex": 20, "sortable": true, "header": "Zustand", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "state", "editor": state2520 }, { "width": Lino.chars2width(11), "colIndex": 21, "sortable": false, "dataIndex": "owner", "header": "Verkn\u00fcpft mit", "editable": false } ];
    Lino.cal.Tasks.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.insertPanel = Ext.extend(Lino.cal.Tasks.InsertFormPanel,{
  empty_title: "Neu Aufgaben",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Erstellen ohne Detail", "tooltip": "Nach Erstellen des Datensatzes kein Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Erstellen ohne Detail", "overflowText": "Erstellen ohne Detail", "auto_save": false } ],
  ls_url: "/cal/Tasks",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Tasks.detail;
    this.ls_insert_handler = Lino.cal.Tasks.insert;
    Lino.cal.Tasks.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Tasks.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Tasks.insertPanel(p);
});
Lino.cal.Tasks.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Tasks",pk,"wf1");
};
Lino.cal.Tasks.wf2 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Tasks",pk,"wf2");
};
Lino.cal.Tasks.wf3 = function(rp,pk) { 
  Lino.run_row_action(rp,"/cal/Tasks",pk,"wf3");
};

Lino.cal.Tasks.detailPanel = Ext.extend(Lino.cal.Tasks.DetailFormPanel,{
  empty_title: "Detail Aufgaben",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  ls_url: "/cal/Tasks",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Tasks.detail;
    this.ls_insert_handler = Lino.cal.Tasks.insert;
    Lino.cal.Tasks.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Tasks.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Tasks.detailPanel(p);
});
Lino.cal.Tasks.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Tasks.GridPanel(p);
});

// js_render_GridPanel_class cal.GuestRoles
Lino.cal.GuestRoles.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/GuestRoles",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "Neu", "must_save": true, "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "Neu", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "auto_save": false } ],
  title : "Gastrollen",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "build_method" }, 'build_methodHidden', { "name": "template" }, { "type": "boolean", "name": "attach_to_email" }, { "name": "email_template" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 58,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.GuestRoles.detail;
    this.ls_insert_handler = Lino.cal.GuestRoles.insert;
    var ww = this.containing_window;
    var id2523 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2524 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2525 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2526 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en2527 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var build_method2528 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template2529 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestRoles/template", "method": "GET" }) }) });
    var attach_to_email2530 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var email_template2531 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestRoles/email_template", "method": "GET" }) }) });
    this.before_row_edit = function(record) {
      template2529.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      build_method2528.on('change',Lino.chooser_handler(template2529,'build_method'));
      Lino.cal.GuestRoles.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2523, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2524 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2525 }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et2526 }, { "colIndex": 4, "sortable": true, "header": "Bezeichnung (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en2527 }, { "colIndex": 5, "sortable": true, "header": "Konstruktionsmethode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "build_method", "editor": build_method2528 }, { "colIndex": 6, "sortable": true, "header": "Vorlage", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "template", "editor": template2529 }, { "colIndex": 7, "sortable": false, "xtype": "checkcolumn", "header": "als Anhang per E-Mail", "editable": true, "tooltip": "Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "attach_to_email" }, { "colIndex": 8, "sortable": true, "header": "E-Mail-Vorlage", "editable": true, "tooltip": "The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dat