/*
 Copyright 2009-2013 Luc Saffre
 This file is part of the Lino project.
 Lino is free software; you can redistribute it and/or modify 
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.
 Lino is distributed in the hope that it will be useful, 
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 GNU General Public License for more details.
 You should have received a copy of the GNU General Public License
 along with Lino; if not, see <http://www.gnu.org/licenses/>.
*/

// lino.js --- generated Mon Oct  7 02:17:55 2013 by Lino version 1.6.12.
Ext.BLANK_IMAGE_URL = 'http://extjs-public.googlecode.com/svn/tags/extjs-3.3.1/release/resources/images/default/s.gif';
LANGUAGE_CHOICES = [ [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ], [ "en", "English" ] ];
MEDIA_URL = "/media";

// hack to add a toCamel function, inspired by
// http://jamesroberts.name/blog/2010/02/22/string-functions-for-javascript-trim-to-camel-case-to-dashed-and-to-underscore/
String.prototype.toCamel = function(){
  //~ return this.replace(/(\-[a-z])/g, function($1){return $1.toUpperCase().replace('-','');});
  //~ return this;
  return this.replace(/([A-Z])([A-Z]+)/g, function(match,p1,p2,offset,string){
      //~ console.log("20131005 got ",arguments);
      return p1 + p2.toLowerCase();});
};



/* MonthPickerPlugin: thanks to keypoint @ sencha forum
   http://www.sencha.com/forum/showthread.php?74002-3.x-Ext.ux.MonthMenu&p=356860#post356860
*/
Ext.namespace('Ext.ux'); 

Ext.ux.MonthPickerPlugin = function() { 
    var picker; 
    var oldDateDefaults; 

    this.init = function(pk) { 
        picker = pk; 
        picker.onTriggerClick = picker.onTriggerClick.createSequence(onClick); 
        picker.getValue = picker.getValue.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
        picker.beforeBlur = picker.beforeBlur.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
    }; 

    function setDefaultMonthDay() { 
        oldDateDefaults = Date.defaults.d; 
        Date.defaults.d = 1; 
        return true; 
    } 

    function restoreDefaultMonthDay(ret) { 
        Date.defaults.d = oldDateDefaults; 
        return ret; 
    } 

    function onClick(e, el, opt) { 
        var p = picker.menu.picker; 
        p.activeDate = p.activeDate.getFirstDateOfMonth(); 
        if (p.value) { 
            p.value = p.value.getFirstDateOfMonth(); 
        } 

        p.showMonthPicker(); 
         
        if (!p.disabled) { 
            p.monthPicker.stopFx(); 
            p.monthPicker.show(); 

            p.mun(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mun(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
            p.onMonthClick = p.onMonthClick.createSequence(pickerClick); 
            p.onMonthDblClick = p.onMonthDblClick.createSequence(pickerDblclick); 
            p.mon(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mon(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
        } 
    } 

    function pickerClick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.is('button.x-date-mp-cancel')) { 
            picker.menu.hide(); 
        } else if(el.is('button.x-date-mp-ok')) { 
            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 

    function pickerDblclick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.parent() 
            && (el.parent().is('td.x-date-mp-month') 
            || el.parent().is('td.x-date-mp-year'))) { 

            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 
}; 

Ext.preg('monthPickerPlugin', Ext.ux.MonthPickerPlugin);  

//~ /* 
  //~ http://www.diloc.de/blog/2008/03/05/how-to-submit-ext-forms-the-right-way/
//~ */
//~ /**
 //~ * This submit action is basically the same as the normal submit action,
 //~ * only that it uses the fields getSubmitValue() to compose the values to submit,
 //~ * instead of looping over the input-tags in the form-tag of the form.
 //~ *
 //~ * To use it, just use the OOSubmit-plugin on either a FormPanel or a BasicForm,
 //~ * or explicitly call form.doAction('oosubmit');
 //~ *
 //~ * @param {Object} form
 //~ * @param {Object} options
 //~ */
//~ Ext.ux.OOSubmitAction = function(form, options){
    //~ Ext.ux.OOSubmitAction.superclass.constructor.call(this, form, options);
//~ };

//~ Ext.extend(Ext.ux.OOSubmitAction, Ext.form.Action.Submit, {
    //~ /**
    //~ * @cfg {boolean} clientValidation Determines whether a Form's fields are validated
    //~ * in a final call to {@link Ext.form.BasicForm#isValid isValid} prior to submission.
    //~ * Pass <tt>false</tt> in the Form's submit options to prevent this. If not defined, pre-submission field validation
    //~ * is performed.
    //~ */
    //~ type : 'oosubmit',

    //~ // private
    //~ /**
     //~ * This is nearly a copy of the original submit action run method
     //~ */
    //~ run : function(){
        //~ var o = this.options;
        //~ var method = this.getMethod();
        //~ var isPost = method == 'POST';

        //~ var params = this.options.params || {};
        //~ if (isPost) Ext.applyIf(params, this.form.baseParams);

        //~ //now add the form parameters
        //~ this.form.items.each(function(field)
        //~ {
            //~ if (!field.disabled)
            //~ {
                //~ //check if the form item provides a specialized getSubmitValue() and use that if available
                //~ if (typeof field.getSubmitValue == "function")
                    //~ params[field.getName()] = field.getSubmitValue();
                //~ else
                    //~ params[field.getName()] = field.getValue();
            //~ }
        //~ });

        //~ //convert params to get style if we are not post
        //~ if (!isPost) params=Ext.urlEncode(params);

        //~ if(o.clientValidation === false || this.form.isValid()){
            //~ Ext.Ajax.request(Ext.apply(this.createCallback(o), {
                //~ url:this.getUrl(!isPost),
                //~ method: method,
                //~ params:params, //add our values
                //~ isUpload: this.form.fileUpload
            //~ }));

        //~ }else if (o.clientValidation !== false){ // client validation failed
            //~ this.failureType = Ext.form.Action.CLIENT_INVALID;
            //~ this.form.afterAction(this, false);
        //~ }
    //~ },

//~ });
//~ //add our action to the registry of known actions
//~ Ext.form.Action.ACTION_TYPES['oosubmit'] = Ext.ux.OOSubmitAction;




/**
JC Watsons solution (adapted to ExtJS 3.3.1 by LS) is elegant and simple:
`A "fix" for unchecked checkbox submission  behaviour
<http://www.sencha.com/forum/showthread.php?28449>`_

Added special handling for checkbox inputs. 
ExtJS defines disabled checkboxes `readonly`, not `disabled` as for other inputs.

*/
Ext.lib.Ajax.serializeForm = function(form) {
    //~ console.log('20120203 linolib.js serializeForm',form);
    var fElements = form.elements || (document.forms[form] || Ext.getDom(form)).elements, 
        hasSubmit = false, 
        encoder = encodeURIComponent, 
        name, 
        data = '', 
        type, 
        hasValue;

    Ext.each(fElements, function(element){
        name = element.name;
        type = element.type;

        if (!element.disabled && name && !(type == 'checkbox' && element.readonly)) {
            if (/select-(one|multiple)/i.test(type)) {
                Ext.each(element.options, function(opt){
                    if (opt.selected) {
                        hasValue = opt.hasAttribute ? opt.hasAttribute('value') : opt.getAttributeNode('value').specified;
                        data += String.format("{0}={1}&", encoder(name), encoder(hasValue ? opt.value : opt.text));
                    }
                });
            } else if (!(/file|undefined|reset|button/i.test(type))) {
                //~ if (!(/radio|checkbox/i.test(type) && !element.checked) && !(type == 'submit' && hasSubmit)) {
                if (!(type == 'submit' && hasSubmit)) {
                    if (type == 'checkbox') {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&');
                        data += encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&';
                    } else {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + encoder(element.value) + '&');
                        data += encoder(name) + '=' + encoder(element.value) + '&';
                    }
                    hasSubmit = /submit/i.test(type);
                }
            }
        //~ } else {
            //~ console.log(name,type,element.readonly);
        }
    });
    return data.substr(0, data.length - 1);
};



/*
Set a long timeout of fifteen minutes. 
See /blog/2012/0307
*/
Ext.Ajax.timeout = 15 * 60 * 1000; 

/*
 * Thanks to 
 * `huuze <http://stackoverflow.com/users/10040/huuuze>`_ for the question
 * and to 
 * `chrisv <http://stackoverflow.com/users/683808/chrisv>`_
 * for the answer on
 * http://stackoverflow.com/questions/3764589/how-do-i-include-django-1-2s-csrf-token-in-a-javascript-generated-html-form/5485616#5485616
 * 
 * */
 
Ext.Ajax.on('beforerequest', function (conn, options) {
   if (!(/^http:.*/.test(options.url) || /^https:.*/.test(options.url))) {
     if (typeof(options.headers) == "undefined") {
       options.headers = {'X-CSRFToken': Ext.util.Cookies.get('csrftoken')};
     } else {
       options.headers.extend({'X-CSRFToken': Ext.util.Cookies.get('csrftoken')});
     }                        
   }
}, this);


/*
My fix for the "Cannot set QuickTips dismissDelay to 0" bug,
see http://www.sencha.com/forum/showthread.php?183515 
*/
Ext.override(Ext.QuickTip,{
  showAt : function(xy){
        var t = this.activeTarget;
        //~ console.log("20120224 QuickTip.showAt",this.title,this.dismissDelay,t.dismissDelay);
        if(t){
            if(!this.rendered){
                this.render(Ext.getBody());
                this.activeTarget = t;
            }
            if(t.width){
                this.setWidth(t.width);
                this.body.setWidth(this.adjustBodyWidth(t.width - this.getFrameWidth()));
                this.measureWidth = false;
            } else{
                this.measureWidth = true;
            }
            this.setTitle(t.title || '');
            this.body.update(t.text);
            this.autoHide = t.autoHide;
            // bugfix by Luc 20120226
            if (t.dismissDelay != undefined) this.dismissDelay = t.dismissDelay;
            //~ this.dismissDelay = t.dismissDelay || this.dismissDelay;
            if(this.lastCls){
                this.el.removeClass(this.lastCls);
                delete this.lastCls;
            }
            if(t.cls){
                this.el.addClass(t.cls);
                this.lastCls = t.cls;
            }
            if(this.anchor){
                this.constrainPosition = false;
            }else if(t.align){ 
                xy = this.el.getAlignToXY(t.el, t.align);
                this.constrainPosition = false;
            }else{
                this.constrainPosition = true;
            }
        }
        Ext.QuickTip.superclass.showAt.call(this, xy);
    }
});

/*
Another hack. See /docs/blog/2012/0228
*/
Ext.Element.addMethods(
    function() {
        var VISIBILITY      = "visibility",
            DISPLAY         = "display",
            HIDDEN          = "hidden",
            NONE            = "none",
            XMASKED         = "x-masked",
            XMASKEDRELATIVE = "x-masked-relative",
            data            = Ext.Element.data;

        return {
            
            mask : function(msg, msgCls) {
                var me  = this,
                    dom = me.dom,
                    dh  = Ext.DomHelper,
                    EXTELMASKMSG = "ext-el-mask-msg",
                    el,
                    mask;
                // removed the following lines. See /docs/blog/2012/0228
                //~ if (!(/^body/i.test(dom.tagName) && me.getStyle('position') == 'static')) {
                    //~ console.log(20120228,dom.tagName,me);
                    //~ me.addClass(XMASKEDRELATIVE); 
                //~ }
                if (el = data(dom, 'maskMsg')) {
                    el.remove();
                }
                if (el = data(dom, 'mask')) {
                    el.remove();
                }

                mask = dh.append(dom, {cls : "ext-el-mask"}, true);
                data(dom, 'mask', mask);

                me.addClass(XMASKED);
                mask.setDisplayed(true);
                
                if (typeof msg == 'string') {
                    var mm = dh.append(dom, {cls : EXTELMASKMSG, cn:{tag:'div'}}, true);
                    data(dom, 'maskMsg', mm);
                    mm.dom.className = msgCls ? EXTELMASKMSG + " " + msgCls : EXTELMASKMSG;
                    mm.dom.firstChild.innerHTML = msg;
                    mm.setDisplayed(true);
                    mm.center(me);
                }
                
                
                if (Ext.isIE && !(Ext.isIE7 && Ext.isStrict) && me.getStyle('height') == 'auto') {
                    mask.setSize(undefined, me.getHeight());
                }
                
                return mask;
            }

            
        };
    }()
);



Ext.namespace('Lino');
    
    

//~ Lino.subst_user_field = new Ext.form.ComboBox({});
//~ Lino.subst_user = null;
Lino.insert_subst_user = function(p){
    //~ console.log('20120714 insert_subst_user',Lino.subst_user,p);
    //~ if (Lino.subst_user_field.getValue()) {
    if (p.su) return;
    if (Lino.subst_user) {
        //~ p.su = Lino.subst_user_field.getValue();
        p.su = Lino.subst_user;
    //~ } else {
        //~ delete p.su;
    }
    //~ console.log('20120714 insert_subst_user -->',Lino.subst_user,p);
}

Lino.login_window = null;


Lino.show_login_window = function(on_login) {
  //~ console.log('20121103 show_login_window',arguments);
  //~ var current_window = Lino.current_window;
  if (Lino.login_window == null) {
    
      function do_login() { 
            //~ alert("20130923 do_login() started");
            Lino.viewport.loadMask.show()
            //~ Lino.body_loadMask.show()
            login_panel.getForm().submit({ 
                method:'POST', 
                waitTitle:'Connecting', 
                waitMsg:'Sending data...',
                success:function(){ 
                  //~ console.log('20130923 logged in',arguments);
                  //~ alert("20130923 do_login() success");
                  Lino.login_window.hide();
                  Lino.close_all_windows();
                  Lino.viewport.loadMask.hide();
                  if (typeof on_login == 'string') {
                      //~ console.log("20130829 on_login",on_login);
                      //~ alert("20130923 on_login gonna load_url");
                      Lino.load_url(on_login);
                      //~ eval(on_login);
                  } 
                  //~ else Lino.load_url(/);
                  //~ Lino.body_loadMask.hide();
                },
                failure: function(form,action) { 
                  //~ this.loadMask.hide();
                  //~ alert("20130923 do_login() failure");
                  Lino.on_submit_failure(form,action);
                  Lino.viewport.loadMask.hide()
                  //~ Lino.body_loadMask.hide()
                  //~ if (Lino.current_window) Lino.current_window.main_item.loadMask.hide()
                }
                //~ failure:function(form, action){ 
                    //~ alert_msg
                    //~ if(action.failureType == 'server'){ 
                        //~ obj = Ext.util.JSON.decode(action.response.responseText); 
                        //~ Ext.Msg.alert('Login Failed!', obj.errors.reason); 
                    //~ }else{ 
                        //~ Ext.Msg.alert('Warning!', 'Authentication server is unreachable : ' + action.response.responseText); 
                    //~ } 
                    //~ Lino.login_panel.getForm().reset(); 
                //~ } 
            }); 
      };
    
      var login_button = new Ext.Button({ 
        text:"Log in",
        formBind: true,	 
        // Function that fires when user clicks the button 
        handler: do_login});
    
      var login_panel = new Ext.FormPanel({ 
        //~ inspired by http://www.sencha.com/learn/a-basic-login/
        autoHeight:true,
        labelWidth:90,
        url:'/auth', 
        frame:true, 
        defaultType:'textfield',
        monitorValid:true,
        items:[{ 
            fieldLabel:"Username", 
            id: 'username',
            name:'username', 
            autoHeight:true,
            allowBlank:false 
        },{ 
            fieldLabel:"Password", 
            name:'password', 
            inputType:'password', 
            autoHeight:true,
            allowBlank:false 
        }],        
        buttons:[ login_button ]});
        
      Lino.login_window = new Ext.Window({
          layout:'fit',
          defaultButton: 'username',
          width:300,
          title:"Log in", 
          autoHeight:true,
          modal: true,
          closeAction: "hide",
          keys: {
            key: Ext.EventObject.ENTER,
            fn: function() { do_login()}
          },
          //~ defaultButton: login_button,
          //~ height:'auto',
          //~ closable: false,
          //~ resizable: false,
          //~ plain: true,
          //~ border: false,
          items: [login_panel] });
  };
  Lino.login_window.show();
};

Lino.logout = function(id,name) {
    //~ console.log('20121104 gonna log out',arguments);
    //~ Lino.do_action
    Lino.call_ajax_action(Lino.viewport,'GET',
        '/auth',{},'logout',undefined,undefined,function(){
        //~ console.log('20121104 logged out',arguments);
        //~ Lino.login_window.hide();
        Lino.close_all_windows();
    })
}

Lino.set_subst_user = function(id,name) {
    //~ console.log(20130723,'Lino.set_subst_user',id,name,Lino.current_window,Lino.viewport);
    Lino.subst_user = id;
//~ 
    //~ if(id) {
        //~ Lino.eventStore.setBaseParam("su",id);
    //~ } else {
      //~ delete Lino.eventStore.baseParams['su'];
    //~ }
//~ 
    if (Lino.current_window) 
        Lino.current_window.main_item.set_base_param("su",id);
    if (Lino.viewport) 
        Lino.permalink_handler(Lino.current_window)();
}



//~ Lino.select_subst_user = function(cmp,rec,value){
    //~ Lino.subst_user=value;
    //~ console.log(20120713,rec);
//~ }
    
Lino.current_window = null;
Lino.window_history = Array();
    
Lino.chars2width = function(cols) {  return cols * 9; }
Lino.rows2height = function(cols) {  return cols * 20; }



Lino.MainPanel = {
  is_home_page : false,
  setting_param_values : false,
  config_containing_window : function(wincfg) { }
  ,init_containing_window : function(win) { }
  ,is_loading : function() { 
      if (!this.rendered) return true;
      //~ return (Ext.select('.x-loading-msg').elements.length > 0);
      return true; 
    } 
  ,do_when_clean : function(auto_save,todo) { todo() }
  ,get_master_params : function() {
    var p = {}
    p['mt'] = this.content_type; 
    rec = this.get_current_record()
    if (rec) {
      if (rec.phantom) {
          p['mk'] = undefined; 
      }else{
          p['mk'] = rec.id; 
      }
    } else {
      p['mk'] = undefined;
    }
    //~ console.log('get_master_params returns',p,'using record',rec);
    return p;
  }
  ,get_permalink : function() {
    //~ var p = this.main_item.get_base_params() || {};
    var p = Ext.apply({},this.get_base_params());
    delete p.fmt;
    //~ if (p.fmt) delete p.fmt;
    Ext.apply(p,this.get_permalink_params());
    
    if (this.toggle_params_panel_btn) {
        p.sp = this.toggle_params_panel_btn.pressed;
        //~ if (this.toggle_params_panel_btn.pressed == this.params_panel_hidden) {
          //~ p.sp = true;
        //~ }
    }
    
    //~ Lino.insert_subst_user(p);
     //~ p.fmt = 'html';
    //~ console.log('get_permalink',p,this.get_permalink_params());
    if (this.is_home_page)
        //~ var url = '';
        var url = '/';
    else 
        var url = this.get_permalink_url();
    if (p.su == null) 
        delete p.su;
    if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
    return url;
  }
  ,get_record_url : function(record_id) {
      var url = '/api' + this.ls_url
      //~ var url = this.containing_window.config.url_data; // ls_url;
      url += '/' + (record_id === undefined ? '-99999' : String(record_id));
      //~ if (record_id !== undefined) url += '/' + String(record_id);
      //~ url += '/' + String(record_id);
      return url;
  }
  ,get_permalink_url : function() {
      return '/api' + this.ls_url;
  }
  ,get_permalink_params : function() {
      //~ return {an:'grid'};
      var p = {};
      if (this.action_name)
          p.an = this.action_name;
      this.add_param_values(p,false)
      return p;
  }
  ,set_status : function(status) {}
  ,get_status : function() { return {}}
  ,refresh : function() {}
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,add_params_panel : function (tbar) {
      if (this.params_panel) {
        //~  20130923b
        //~ this.params_panel.autoHeight = true; // 20130924
        var t = this;
        var update = function() {
            var p = t.params_panel;
            //~ console.log("update", p.getSize().height,p.forceLayout,p.autoHeight);
            var w = t.get_containing_window();
            Lino.do_when_visible(w, function() {
                //~ p.doLayout(true); // doLayout(shallow, force)
                w.doLayout(true); // doLayout(shallow, force)
                //~ t.params_panel.on('afterlayout',update,t,{single:true});
            });
        };
        Lino.do_when_visible(this.params_panel, update);
        this.params_panel.on('show',update);
        this.params_panel.on('hide',update);
        //~ this.params_panel.on('bodyresize',update);
        this.params_panel.on('afterlayout',update);
        //~ this.params_panel.on('afterlayout',update,this,{single:true});
        //~ this.params_panel.on('bodyresize',update,this,{single:true});
        //~ this.params_panel.on('resize',update,this,{single:true});
        //~ this.params_panel.on('render',update,this,{single:true});
        
        // this.params_panel.on('render',
        //~ this.params_panel.on('afterlayout',update,this,{single:true,delay:200});
        //~ this.params_panel.on('bodyresize',update,this,{single:true,delay:200});
        this.toggle_params_panel_btn = new Ext.Button({ scope:this, 
          //~ text: "$_("[parameters]")", // gear
          iconCls: 'x-tbar-parameters',
          tooltip:"Show or hide the table parameters panel",
          enableToggle: true,
          //~ pressed: ! this.params_panel.hidden,
          pressed: ! this.params_panel_hidden,
          toggleHandler: function(btn,state) { 
            //~ console.log("20120210 add_params_panel",state,this.params_panel);
            if (state) {
                this.params_panel.show();
            } else {
                this.params_panel.hide();
            }
            //~ this.params_panel.on('afterlayout',update,this,{single:true});
            //~ t.get_containing_window().doLayout();
            //~ this.params_panel.on('afterlayout',function() {
                //~ console.log("20130918 afterlayout");
                //~ t.get_containing_window().doLayout(); // doLayout(shallow, force)
            //~ },this,{single:true});
          }
        }); 
        tbar = tbar.concat([this.toggle_params_panel_btn]);
        var refresh = function() {
            if (!t.setting_param_values) {
                t._force_dirty = true; 
                t.refresh();
            }
        }
        Ext.each(this.params_panel.fields,function(f) {
          //~ f.on('valid',function() {t.refresh()});
          if (f instanceof Ext.form.Checkbox) {
              f.on('check',refresh);
          } else if (f instanceof Ext.DatePicker) {
              f.on('select',refresh);
          } else if (f instanceof Ext.form.TriggerField) {
              f.on('select',refresh);
              //~ f.on('change',refresh);
              //~ f.on('valid',refresh);
          } else {
              if (! f.on) 
                  console.log("20121010 no method 'on'",f);
              else
                  f.on('change',refresh);
            }
          });
      }
      return tbar;
  }
  ,add_param_values : function (p,force_dirty) {
    if (this.params_panel) {
      /* 
      * 20120918 add param_values to the request string 
      * *only if the params_form is dirty*.
      * Otherwise Actor.default_params() would never be used.
      *
      * 20121023 But IntegClients.params_default has non-empty default values. 
      * Users must have the possibility to make them empty.
      * 
      * 20130605 : added `force_dirty` parameter because Checkbox fields don't 
      * mark their form as dirty when check is fired.
      * 
      * 20130721 : `force_dirty` not as a parameter but as 
      * `this._force_dirty` because
      * 
      * 20130915 : both _force_dirty and force_dirty parameter are needed.
      * 
      */
      if (force_dirty || this._force_dirty || this.params_panel.form.isDirty()) {
      //~ if (this._force_dirty || this.params_panel.form.isDirty()) {
        p.pv = this.get_param_values();
        //~ console.log("20130923 form is dirty (",force_dirty,this._force_dirty,this.params_panel.form.isDirty(),")");
        //~ console.log("20130923 form is dirty",p);
      }else{
        //~ console.log("20130923 form not dirty:",this.params_panel.form);
        if (this.status_param_values) 
          p.pv = Lino.fields2array(
            this.params_panel.fields,this.status_param_values);
      }
      //~ if (!this.params_panel.form.isDirty()) return;
      //~ p.pv = this.get_param_values();
      //~ console.log("20120203 add_param_values added pv",p.pv,"to",p);
    }
  },
  get_param_values : function() { // similar to get_field_values()
      return Lino.fields2array(this.params_panel.fields);
  },
  set_param_values : function(pv) {
    if (this.params_panel) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_param_values = pv;
      //~ this.params_panel.form.suspendEvents(false);
      this.setting_param_values = true;
      if (pv) { 
          this.params_panel.form.my_loadRecord(pv);
      } else { 
        this.params_panel.form.reset(); 
      }
      this.setting_param_values = false;
      this._force_dirty = false; 
      //~ this.params_panel.form.resumeEvents();
    }
  }
};




Lino.Viewport = Ext.extend(Ext.Viewport,Lino.MainPanel);
Lino.Viewport = Ext.extend(Lino.Viewport,{
  layout : "fit"
  ,is_home_page : true
  ,initComponent : function(){
    Lino.Viewport.superclass.initComponent.call(this);
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.el,{msg:"Please wait..."});
      //~ console.log("20121118 Lino.viewport.loadMask",this.loadMask);
    },this);
  }
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,refresh : function() {
      var caller = this;
      //~ console.log("20121120 Lino.Viewport.refresh()");
      if (caller.loadMask) caller.loadMask.show();
      var success = function(response) {
        if (caller.loadMask) caller.loadMask.hide();
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          //~ console.log('Lino.do_action()',action.name,'result is',result);
          if (result.html) {
              Ext.getCmp('main_area').update(result.html);
          }
          if (result.message) {
              if (result.alert) {
                  //~ Ext.MessageBox.alert('Alert',result.alert_msg);
                  Ext.MessageBox.alert('Alert',result.message);
              } else {
                  Lino.notify(result.message);
              }
          }
          
          if (result.notify_msg) Lino.notify(result.notify_msg);
          if (result.js_code) { 
            var jsr = result.js_code(caller);
            //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
          };
        }
      };
      var action = {
        url : '/api/main_html',
        waitMsg: "Please wait...",
        failure: Lino.ajax_error_handler(caller),
        success: success,
        method: 'GET',
        params: {}
      };
      Lino.insert_subst_user(action.params);
      Ext.Ajax.request(action);
    
  }
});




Lino.open_window = function(win,st,requesting_panel) {
  //~ console.log("20120918 Lino.open_window()",win,st);
  var cw = Lino.current_window;
  if (cw) {
    //~ console.log("20120918 Lino.open_window() save current status",cw.main_item.get_status());
    Lino.window_history.push({
      window:cw,
      status:cw.main_item.get_status()
    });
  }
  Lino.current_window = win;
  //~ if (st.su) 
      //~ Lino.subst_user_field.setValue(st.su);
  win.main_item.set_status(st,requesting_panel);
  win.show();
};

Lino.load_url = function(url) {
    //~ foo.bar.baz = 2; 
    //~ console.log("20121120 Lino.load_url()");
    //~ Lino.body_loadMask.show();
    Lino.viewport.loadMask.show();
    //~ location.replace(url);
    document.location = url;
}

Lino.close_window = function(status_update) {
  var cw = Lino.current_window;
  var ww = Lino.window_history.pop();
  if (ww) {
    //~ if (status_update) Ext.apply(ww.status,status_update);
    if (status_update) status_update(ww);
    ww.window.main_item.set_status(ww.status);
    Lino.current_window = ww.window;
  } else {
    Lino.current_window = null;
  }
  if (cw) cw.hide_really();
};

Lino.close_all_windows = function() {
  if (Lino.window_history.length == 0) {
      //~ Lino.viewport.refresh();
      var url =  "/"
      //~ console.log("20121120 Lino.close_all_windows() : no window_history");
      //~ if (ADMIN_URL) 
      var p = {};
      Lino.insert_subst_user(p)
      if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
      Lino.load_url(url);
  } else {
    //~ console.log("20121120 Lino.close_all_windows() with window_history");
    while (Lino.window_history.length > 0) {
      Lino.close_window();
      //~ Lino.window_history.pop().hide_really();
    }
  }
  //~ Lino.current_window = null;
  //~ Lino.close_window();
  //~ var ww = 
}

Lino.kill_current_window = function() {
  var cw = Lino.current_window;
  Lino.current_window = null;
  if (cw) cw.hide_really();
};

Lino.calling_window = function() {
    if (Lino.window_history.length) return Lino.window_history[Lino.window_history.length-1];
}

//~ Lino.WindowAction = function(mainItemClass,windowConfig,mainConfig,ppf) {
Lino.WindowAction = function(windowConfig,main_item_fn) {
    //~ if(!mainConfig) mainConfig = {};
    //~ mainConfig.is_main_window = true;
    this.windowConfig = windowConfig;
    this.main_item_fn = main_item_fn;
    //~ if (ppf) mainConfig.params_panel.fields = ppf;
    //~ this.mainConfig = mainConfig;
    //~ this.mainItemClass = mainItemClass;
};

Lino.WindowAction = Ext.extend(Lino.WindowAction,{
    window : null,
    //~ mainItemClass: null,
    get_window : function() {
      //~ if(mainConfig) Ext.apply(this.mainConfig,mainConfig);
      if (this.window == null)  {
          //~ this.windowConfig.main_item = new this.mainItemClass(this.mainConfig);
          this.windowConfig.main_item = this.main_item_fn();
          this.window = new Lino.Window(this.windowConfig);
      }
      return this.window;
    },
    run : function(requesting_panel,status) {
      //~ console.log('20120625 window_action.run()',this)
      Lino.open_window(this.get_window(),status,requesting_panel);
    }
  
});


Lino.PanelMixin = {
  get_containing_window : function (){
      if (this.containing_window) return this.containing_window;
      return this.containing_panel.get_containing_window();
  }
  ,set_window_title : function(title) {
    //~ this.setTitle(title);
    var cw = this.get_containing_window();

    //~ if (cw) {
    //~ if (cw && cw.closable) {
    if (cw && !cw.main_item.hide_window_title) {
      //~ console.log('20111202 set_window_title(',title,') for',this.containing_window);
      //~ if (! this.containing_window.rendered) console.log("WARNING: not rendered!");
      cw.setTitle(title);
    //~ } else {
      //~ document.title = title;
    }
    //~ else console.log('20111202 not set_window_title(',title,') for',this);
  }
  
};


// Lino.status_bar = new Ext.ux.StatusBar({defaultText:'Lino version 1.6.12.'});
Lino.status_bar = new Ext.ux.StatusBar({
    autoClear: 10000, // 10 seconds
    defaultText:'Lino Presto 0.1.'
    });



Lino.edit_tinymce_text = function(panel,options) {
  // `panel` is the RichTextPanel
  //~ console.log(20111220,panel);
  //~ var rec = panel.get_current_record();
  var rec = panel.containing_panel.get_current_record();
  var value = rec ? rec.data[panel.editor.name] : '';
  var saving = false;
  var todo_after_save = false;
  var discard_changes = false;
  
  
  function save() {
    //~ if (todo_after_save) {alert('tried to save again'); return; }
    if (saving) {alert('tried to save again'); return; }
    //~ var url = panel.containing_window.main_item.get_record_url(rec.id);
    var url = panel.containing_panel.get_record_url(rec.id);
    var params = Ext.apply({},panel.containing_panel.get_base_params());
    params[panel.editor.name] = editor.getValue();
    //~ params.su = Lino.subst_user;
    //~ Lino.insert_subst_user(params);
    var a = { 
      params: params, 
      method: 'PUT',
      url: url,
      failure: function() {
          //~ if (editor.ed.getContainer()) 
          editor.ed.setProgressState(0);
          todo_after_save = false;
          saving = false;
          console.log('tinymce.save() failed. sorry.',arguments);
        },
      success: function() {
        saving = false;
        //~ if (editor.ed.getContainer()) 
        editor.ed.setProgressState(0);
        rec.data[panel.editor.name] = editor.getValue();
        if(todo_after_save) {
            var fn = todo_after_save;
            todo_after_save = false;
            fn();
        }
        //~ panel.containing_window.set_current_record(rec);
        panel.refresh();
      }
    };
    //~ if (editor.ed.getContainer()) 
    editor.ed.setProgressState(1); // Show progress
    saving = true;
    //~ console.log(a);
    Ext.Ajax.request(a);
  };
  function save_callback() {
      save();
      //~ save(function(){editor.ed.setDirty(false);})
      /* return true have the save button disabled.  
      That's not perfect because the PUT is asynchronous 
      and the response is not yet known.
      */
      return true;
  }
  //~ var actions = [
    //~ {text:"Save",handler:save}
  //~ ]; 
  //~ console.log(20110610,panel.editor.disabled);
  var settings = {};
  Ext.apply(settings,{
        readonly: panel.editor.disabled,
        //~ language: "de",
        plugins : "save,emotions,spellchecker,advhr,insertdatetime,preview,table,searchreplace,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "save,cancel,|,bold,italic,underline,|,justifyleft,justifycenter,justifyright,fontselect,fontsizeselect,formatselect,|,search,replace",
        theme_advanced_buttons2 : "cut,copy,paste,template,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,link,unlink,anchor,image,|,code,preview,|,forecolor,backcolor",
        theme_advanced_buttons3 : "insertdate,inserttime,|,spellchecker,advhr,,removeformat,|,sub,sup,|,charmap,emotions,|,tablecontrols",      
        theme_advanced_resizing : false,
        convert_urls : false,
        save_onsavecallback : save_callback,
        save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
  });
  Ext.apply(settings,options);
  var editor = new Ext.ux.TinyMCE({
      value : value,
      tinymceSettings: settings
    });
  var win = new Ext.Window({
    title: rec.title, 
    //~ bbar: actions,
    layout: 'fit',
    items: editor,
    width: 600, 
    height:500,
    minWidth: 100,
		minHeight: 100,
    modal: true,
    resizable: true,
    maximizable: true,
    //~ maximized: true,
    //~ closeAction: "close"
    closeAction: "hide"
    //~ hideMode: "offsets",
    //~ constrainHeader: true,
    //~ bodyStyle: 'padding: 10px'
  });

  //~ win.on('beforeclose',function() {
  win.on('beforehide',function() {
    if (todo_after_save) return false;
    if (discard_changes) return true;
    if (editor.isDirty()) {
        //~ var ok = false;
        //~ var allowClose = true;
        var config = {title:"Confirmation"};
        config.buttons = Ext.MessageBox.YESNOCANCEL;
        config.msg = "Save changes to text ?";
        config.modal = true;
        config.fn = function(buttonId,text,opt) {
          //~ console.log('do_when_clean',buttonId)
          if (buttonId == "yes") {
              /* we cancel this close, but save()'s onSuccess will call again.*/
              //~ allowClose = false;
              todo_after_save = function(){win.hide();}
              editor.ed.execCommand('mceSave');
              //~ editor.ed.save(function(){win.close();});
          } else if (buttonId == "no") { 
              discard_changes = true;
              win.hide()
          //~ } else if (buttonId == "cancel") { 
            //~ ok = true;
              //~ allowClose = false;
          //~ } else { 
            //~ console.log('unknwon buttonId:',buttonId);
          }
        }
        Ext.MessageBox.show(config);
        return false;
        //~ return allowClose;
    }
  });
  win.show();
}







/* 
  Originally copied from Ext JS Library 3.3.1
  Modifications by Luc Saffre : 
  - rendering of phantom records
  - fire afteredit event
  - react on dblclcik, not on single click

 */
Lino.CheckColumn = Ext.extend(Ext.grid.Column, {

    processEvent : function(name, e, grid, rowIndex, colIndex){
        //~ console.log('20110713 Lino.CheckColumn.processEvent',name)
        if (name == 'click') {
        //~ if (name == 'mousedown') {
        //~ if (name == 'dblclick') {
            return this.toggleValue(grid, rowIndex, colIndex);
        } else {
            return Ext.grid.ActionColumn.superclass.processEvent.apply(this, arguments);
        }
    },
    
    toggleValue : function (grid,rowIndex,colIndex) {
        var record = grid.store.getAt(rowIndex);
        var dataIndex = grid.colModel.getDataIndex(colIndex);
        // 20120514
        //~ if(record.data.disabled_fields && record.data.disabled_fields[dataIndex]) {
          //~ Lino.notify("This field is disabled");
          //~ return false;
        //~ }
      
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("This field is disabled.");
            //~ return false;
        //~ }
        var startValue = record.data[dataIndex];
        var value = !startValue;
        //~ record.set(this.dataIndex, value);
        var e = {
            grid: grid,
            record: record,
            field: dataIndex,
            originalValue: startValue,
            value: value,
            row: rowIndex,
            column: colIndex,
            cancel: false
        };
        if(grid.fireEvent("beforeedit", e) !== false && !e.cancel){
        //~ if(grid.fireEvent("validateedit", e) !== false && !e.cancel){
            record.set(dataIndex, value);
            delete e.cancel;
            grid.fireEvent("afteredit", e);
        }
        return false; // Cancel event propagation
    },

    renderer : function(v, p, record){
        if (record.phantom) return '';
        p.css += ' x-grid3-check-col-td'; 
        return String.format('<div class="x-grid3-check-col{0}">&#160;</div>', v ? '-on' : '');
    }

    // Deprecate use as a plugin. Remove in 4.0
    // init: Ext.emptyFn
});

// register ptype. Deprecate. Remove in 4.0
// Ext.preg('checkcolumn', Lino.CheckColumn);

// backwards compat. Remove in 4.0
// Ext.grid.CheckColumn = Lino.CheckColumn;

// register Column xtype
Ext.grid.Column.types.checkcolumn = Lino.CheckColumn;


/* 20110725 : 
Lino.on_tab_activate is necessary 
in contacts.Person.2.dtl 
(but don't ask me why...)
*/
Lino.on_tab_activate = function(item) {
  //~ console.log('activate',item); 
  if (item.rendered && item.doLayout) item.doLayout();
  //~ if (item.rendered) item.doLayout();
}

Lino.TimeField = Ext.extend(Ext.form.TimeField,{
  format: 'H:i',
  increment: 15
  });
Lino.DateField = Ext.extend(Ext.form.DateField,{
  boxMinWidth: Lino.chars2width(15), // 20131005 changed from 11 to 15
  format: 'd.m.Y',
  altFormats: 'd/m/Y|Y-m-d'
  });
Lino.DatePickerField = Ext.extend(Ext.DatePicker,{
  //~ boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  //~ altFormats: 'd/m/Y|Y-m-d'
  formatDate : function(date){
      //~ console.log("20121203 formatDate",this.name,date);
      return Ext.isDate(date) ? date.dateFormat(this.format) : date;
  }
  });
Lino.DateTimeField = Ext.extend(Ext.ux.form.DateTime,{
  dateFormat: 'd.m.Y',
  timeFormat: 'H:i'
  //~ ,hiddenFormat: 'd.m.Y H:i'
  });
Lino.URLField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  //~ triggerClass : 'x-form-world-trigger',
  vtype: 'url',
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    window.open(this.getValue(),'_blank');
  }
});
Lino.IncompleteDateField = Ext.extend(Ext.form.TextField,{
  //~ regex: /^-?\d+-[01]\d-[0123]\d$/,
  //~ regex: /^[0123]\d\.[01]\d\.-?\d+$/,
  maxLength: 10,
  boxMinWidth: Lino.chars2width(10),
  regex: /^[0123]?\d\.[01]?\d\.-?\d+$/,
  regexText: 'Enter a date in format YYYY-MM-DD (use zeroes for unknown parts).'
  });


//~ Lino.make_dropzone = function(cmp) {
    //~ cmp.on('render', function(ct, position){
      //~ ct.el.on({
        //~ dragenter:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ return true;
        //~ }
        //~ ,dragover:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ event.stopEvent();
          //~ return true;
        //~ }
        //~ ,drop:{
          //~ scope:this
          //~ ,fn:function(event){
            //~ event.stopEvent();
            //~ console.log(20110516);
            //~ var files = event.browserEvent.dataTransfer.files;
            //~ if(files === undefined){
              //~ return true;
            //~ }
            //~ var len = files.length;
            //~ while(--len >= 0){
              //~ console.log(files[len]);
              //~ // this.processDragAndDropFileUpload(files[len]);
            //~ }
          //~ }
        //~ }
      //~ });
    //~ });
//~ };

//~ Lino.FileUploadField = Ext.ux.form.FileUploadField;

Lino.FileUploadField = Ext.extend(Ext.ux.form.FileUploadField,{
    onRender : function(ct, position){
      Lino.FileUploadField.superclass.onRender.call(this, ct, position);
      this.el.on({
        dragenter:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          return true;
        }
        ,dragover:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          event.stopEvent();
          return true;
        }
        ,drop:{
          scope:this
          ,fn:function(event){
            event.stopEvent();
            //~ console.log(20110516);
            var files = event.browserEvent.dataTransfer.files;
            if(files === undefined){
              return true;
            }
            var len = files.length;
            while(--len >= 0){
              console.log(files[len]);
              //~ this.processDragAndDropFileUpload(files[len]);
            }
          }
        }
      });
    }
});

Lino.FileField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  editable: false,
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    if (this.getValue()) window.open(MEDIA_URL + '/'+this.getValue(),'_blank');
  }
});

Lino.file_field_handler = function(panel,config) {
  //~ if (instanceof Lino.DetailWrapper) {
  if (panel.action_name == 'insert') {
  //~ if (panel.get_current_record().phantom) {
      panel.has_file_upload = true;

      var f = new Lino.FileUploadField(config);
      //~ Lino.make_dropzone(f);
      return f;
      //~ return new Ext.ux.form.FileUploadField(config);
      //~ return new Lino.FileField(config);
      
  } else {
      //~ return new Lino.URLField(config);
      return new Lino.FileField(config);
  }
}

Lino.VBorderPanel = Ext.extend(Ext.Panel,{
    constructor : function(config) {
      config.layout = 'border';
      delete config.layoutConfig;
      Lino.VBorderPanel.superclass.constructor.call(this,config);
      for(var i=0; i < this.items.length;i++) {
        var item = this.items.get(i);
        if (this.isVertical(item) && item.collapsible) {
          item.on('collapse',this.onBodyResize,this);
          item.on('expand',this.onBodyResize,this);
        }
      }
    },
    isVertical : function(item) {
       return (item.region == 'north' || item.region == 'south' || item.region == 'center');
    },
    onBodyResize: function(w, h){
        //~ console.log('VBorderPanel.onBodyResize',this.title)
      if (this.isVisible()) { // to avoid "Uncaught TypeError: Cannot call method 'getHeight' of undefined."
        var sumflex = 0;
        var availableHeight = this.getInnerHeight();
        var me = this;
        this.items.each(function(item){
          if (me.isVertical(item)) {
              if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  if (item.rendered) availableHeight -= item.getHeight();
              } else {
                  sumflex += item.flex;
              }
          } 
          
        });
        //~ for(var i=0; i < this.items.length;i++) {
          //~ var item = this.items.get(i);
          //~ // if (this.isVertical(item) && item.getResizeEl()) {
          //~ if (this.isVertical(item)) {
              //~ if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  //~ // item.syncSize()
                  //~ // item.doLayout()
                  //~ // if (item.region == "north") console.log('region north',item.getHeight(),item.id, item);
                  //~ // if (item.getHeight() == 0) console.log(20100921,'both flex and getHeight() are 0!');
                  //~ availableHeight -= item.getHeight();
              //~ } else {
                  //~ sumflex += item.flex;
                  //~ // console.log(item.flex);
              //~ }
          //~ } 
          //~ // else console.log('non-vertical item in VBoderPanel:',item)
        //~ }
        var hunit = availableHeight / sumflex;
        //~ console.log('sumflex=',sumflex,'hunit=',hunit, 'availableHeight=',availableHeight);
        for(var i=0; i < this.items.length;i++) {
          var item = this.items.get(i);
          if (this.isVertical(item)) {
              if (item.flex != 0 && ! item.collapsed) {
                  item.setHeight(hunit * item.flex);
                  //~ console.log(item.region,' : height set to',item.getHeight());
              }
          }
          //~ else console.log('non-vertical item in VBoderPanel:',item)
        }
      }
      Lino.VBorderPanel.superclass.onBodyResize.call(this, w, h);
    }
});


/*
  modifications to the standard behaviour of a CellSelectionModel:
  
*/
Ext.override(Ext.grid.CellSelectionModel, {
//~ var dummy = {

    handleKeyDown : function(e){
        /* removed because F2 wouldn't pass
        if(!e.isNavKeyPress()){
            return;
        }
        */
        //~ console.log('handleKeyDown',e)
        var k = e.getKey(),
            g = this.grid,
            s = this.selection,
            sm = this,
            walk = function(row, col, step){
                return g.walkCells(
                    row,
                    col,
                    step,
                    g.isEditor && g.editing ? sm.acceptsNav : sm.isSelectable, 
                    sm
                );
            },
            cell, newCell, r, c, ae;

        switch(k){
            case e.ESC:
            case e.PAGE_UP:
            case e.PAGE_DOWN:
                break;
            default:
                // e.stopEvent(); // removed because Browser keys like Alt-Home, Ctrl-R wouldn't work
                break;
        }

        if(!s){
            cell = walk(0, 0, 1); 
            if(cell){
                this.select(cell[0], cell[1]);
            }
            return;
        }

        cell = s.cell;  
        r = cell[0];    
        c = cell[1];    
        
        switch(k){
            case e.TAB:
                if(e.shiftKey){
                    newCell = walk(r, c - 1, -1);
                }else{
                    newCell = walk(r, c + 1, 1);
                }
                break;
            case e.HOME:
                if (! (g.isEditor && g.editing)) {
                  if (!e.hasModifier()){
                      newCell = [r, 0];
                      //~ console.log('home',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
                      if (activePage > 1) {
                          e.stopEvent();
                          t.moveFirst();
                          return;
                      }
                      newCell = [0, c];
                      break;
                  }
                }
            case e.END:
                if (! (g.isEditor && g.editing)) {
                  c = g.colModel.getColumnCount()-1;
                  if (!e.hasModifier()) {
                      newCell = [r, c];
                      //~ console.log('end',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var d = t.getPageData();
                      if (d.activePage < d.pages) {
                          e.stopEvent();
                          var self = this;
                          t.on('change',function(tb,pageData) {
                              var r = g.store.getCount()-2;
                              self.select(r, c);
                              //~ console.log('change',r,c);
                          },this,{single:true});
                          t.moveLast();
                          return;
                      } else {
                          newCell = [g.store.getCount()-1, c];
                          //~ console.log('ctrl-end',newCell);
                          break;
                      }
                  }
                }
            case e.DOWN:
                newCell = walk(r + 1, c, 1);
                break;
            case e.UP:
                newCell = walk(r - 1, c, -1);
                break;
            case e.RIGHT:
                newCell = walk(r, c + 1, 1);
                break;
            case e.LEFT:
                newCell = walk(r, c - 1, -1);
                break;
            case e.F2:
                if (!e.hasModifier()) {
                    if (g.isEditor && !g.editing) {
                        g.startEditing(r, c);
                        e.stopEvent();
                        return;
                    }
                    break;
                }
            case e.INSERT:
                if (!e.hasModifier()) {
                    if (g.ls_insert_handler && !g.editing) {
                        e.stopEvent();
                        Lino.show_insert(g);
                        return;
                    }
                    break;
                }
            case e.DELETE:
                if (!e.hasModifier()) {
                    if (!g.editing) {
                        e.stopEvent();
                        Lino.delete_selected(g);
                        return;
                    }
                    break;
                }
            case e.ENTER:
                e.stopEvent();
                g.onCellDblClick(r,c);
                break;
                
        }
        

        if(newCell){
          e.stopEvent();
          r = newCell[0];
          c = newCell[1];
          this.select(r, c); 
          if(g.isEditor && g.editing){ 
            ae = g.activeEditor;
            if(ae && ae.field.triggerBlur){
                ae.field.triggerBlur();
            }
            g.startEditing(r, c);
          }
        //~ } else if (g.isEditor && !g.editing && e.charCode) {
        //~ // } else if (!e.isSpecialKey() && g.isEditor && !g.editing) {
            //~ g.set_start_value(String.fromCharCode(e.charCode));
            //~ // g.set_start_value(String.fromCharCode(k));
            //~ // g.set_start_value(e.charCode);
            //~ g.startEditing(r, c);
            //~ // e.stopEvent();
            //~ return;
        // } else {
          // console.log('20120513',e,g);
        }
        
    }


//~ };
});

 

function PseudoConsole() {
    this.log = function() {};
};
if (typeof(console) == 'undefined') console = new PseudoConsole();

Lino.notify = function(msg) {
  if (msg == undefined) msg = ''; else console.log(msg);
  //~ Ext.getCmp('konsole').update(msg);
  Lino.status_bar.setStatus({
    text: msg,
    iconCls: 'ok-icon',
    clear: true // auto-clear after a set interval
  });
  //~ Ext.getCmp('konsole').setTitle(msg.replace(/\n/g,'<br/>'));
  //~ Ext.getCmp('konsole').update(msg.replace(/\n/g,'<br/>'));
};
Lino.alert = function(msg) {
  //~ if (msg == undefined) msg = ''; else console.log(msg);
  Ext.MessageBox.alert('Notify',msg);
};


//~ Lino.show_about = function() {
  //~ new Ext.Window({
    //~ width: 400, height: 400,
    //~ title: "About",
    //~ html: '<a href="http://www.extjs.com" target="_blank">ExtJS</a> version ' + Ext.version
  //~ }).show();
//~ };

function obj2str(o) {
  if (typeof o != 'object') return String(o);
  var s = '';
  for (var p in o) {
    s += p + ': ' + obj2str(o[p]) + '\n';
  }
  return s;
}

Lino.on_store_exception = function (store,type,action,options,response,arg) {
  //~ throw response;
  console.log("on_store_exception: store=",store,
    "type=",type,
    "action=",action,
    "options=",options,
    "response=",response,
    "arg=",arg);
  if (arg) { console.log(arg.stack)};
};

//~ Lino.on_submit_success = function(form, action) {
   //~ Lino.notify(action.result.message);
   //~ this.close();
//~ };

Lino.on_submit_failure = function(form, action) {
    //~ Lino.notify();
  // action may be undefined
    switch (action.failureType) {
        case Ext.form.Action.CLIENT_INVALID:
            Ext.Msg.alert('Client-side failure', 'Form fields may not be submitted with invalid values');
            break;
        case Ext.form.Action.CONNECT_FAILURE:
            Ext.Msg.alert('Connection failure', 'Ajax communication failed');
            break;
        case Ext.form.Action.SERVER_INVALID:
            Ext.Msg.alert('Server-side failure', action.result.message);
   }
};



/*
Lino.save_wc_handler = function(ww) {
  return function(event,toolEl,panel,tc) {
    var pos = panel.getPosition();
    var size = panel.getSize();
    wc = ww.get_window_config();
    Ext.applyIf(wc,{ 
      x:pos[0],y:pos[1],height:size.height,width:size.width,
      maximized:panel.maximized});
    Lino.do_action(ww,{url:'/window_configs/'+ww.config.permalink_name,params:wc,method:'POST'});
  }
};

*/

Lino.show_in_own_window_button = function(handler) {
  return {
    qtip: "Show this panel in own window", 
    id: "up",
    handler: function(event,toolEl,panel, tc) {
      //~ console.log('20111206 report_window_button',panel,handler);
      handler.run(null,{base_params:panel.containing_panel.get_master_params()});
    }
  }
}




Lino.delete_selected = function(panel) {
  //~ console.log("Lino.delete_selected",panel);
  var recs1 = panel.get_selected();
  var recs = [];
  for ( var i=0; i < recs1.length; i++ ) { if (! recs1[i].phantom) recs.push(recs1[i]); }
  if (recs.length == 0) {
    Lino.notify("Please select at least one record.");
    return;
  };
  if (recs.length == 1) {
      if (recs[0].disable_delete) {
        Lino.alert(recs[0].disable_delete);
        return;
      }
  };
  //~ console.log(recs);
  Ext.MessageBox.show({
    title: "Confirmation",
    msg: String.format("Delete {0} rows. Are you sure?",String(recs.length)),
    //~ msg: "Delete " + String(recs.length) + " rows. Are you sure?",
    //~ buttons: Ext.MessageBox.YESNOCANCEL,
    buttons: Ext.MessageBox.YESNO,
    fn: function(btn) {
      if (btn == 'yes') {
        for ( var i=0; i < recs.length; i++ ) {
          Lino.do_action(panel,{
              method:'DELETE',
              url:  '/api' + panel.ls_url + '/' + recs[i].id,
              after_success: panel.after_delete.createDelegate(panel)
          })
        }
        //~ caller.after_delete();
      }
      else Lino.notify("Dann eben nicht.");
    }
  });
};

Lino.action_handler = function (panel,on_success,on_confirm) {
  return function (response) {
    //~ console.log(20120608,panel);
    if (panel instanceof Lino.GridPanel) {
        //~ gridmode = false;
        gridmode = true;
        //~ console.log('20120608 yes');
    } else {
        gridmode = false;
        //~ console.log('20120608 no');
    }
    if (panel.loadMask) panel.loadMask.hide(); // 20120211
    if (!response.responseText) return ;
    var result = Ext.decode(response.responseText);
    //~ console.log('Lino.action_handler()','result is',result,'on_confirm is',on_confirm);
    
    if (result.eval_js) {
        //~ console.log(20120618,result.eval_js);
        eval(result.eval_js);
    }
    
    //~ if (result.goto_record) {
        //~ var js = "Lino." + result.goto_record[0] + '.detail.run';
        //~ var h = eval(js);
        //~ h(panel,{record_id:result.goto_record[1]});
    //~ }
    
    if (result.xcallback) {
        //~ var config = {title:"Confirmation"};
        var config = {title:result.xcallback.title};
        //~ config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        config.buttons = result.xcallback.buttons;
        config.msg = result.message;
        config.fn = function(buttonId,text,opt) {
          panel.loadMask.show(); 
          //~ Lino.insert_subst_user(p);
          Ext.Ajax.request({
            method: 'GET',
            url: '/callbacks/'+result.xcallback.id + '/' + buttonId,
            //~ params: {bi: buttonId},
            success: Lino.action_handler(panel,on_success,on_confirm)
          });
          //~ Lino.call_ajax_action(panel,'GET',)
        }
        Ext.MessageBox.show(config);
        return;
    }
    
    if (on_success && result.success) on_success(result);
    
    //~ if (on_confirm && result.confirm_message) {
        //~ var config = {title:"Confirmation"};
        //~ // config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        //~ config.msg = result.confirm_message;
        //~ config.fn = function(buttonId,text,opt) {
          //~ if (buttonId == "yes") {
              //~ on_confirm(panel,undefined,result.step);
          //~ }
        //~ }
        //~ Ext.MessageBox.show(config);
        //~ return;
    //~ }
    //~ if (result.dialog_fn) {
        //~ console.log('20120928 TODO',result.dialog_fn);
    //~ }
    if (result.data_record && ! gridmode) {
        //~ not used
        panel.set_status({data_record:result.data_record});
    }  else if (result.new_status && ! gridmode) {
        //~ not used
        //~ console.log('20120607 new_status');
        panel.set_status(result.new_status);
    } else if (result.goto_record_id != undefined && ! gridmode) {
        //~ Uncaught TypeError: Cannot call method 'run' of undefined 
        panel.load_record_id(result.goto_record_id);
    } 
    
    if (result.message) {
        //~ if (result.alert && ! gridmode) {
        if (result.alert) { // 20120628b 
            //~ Ext.MessageBox.alert('Alert',result.alert_msg);
            if (result.alert === true) result.alert = "Alert";
            Ext.MessageBox.alert(result.alert,result.message);
        } else {
            Lino.notify(result.message);
        }
    }
     
    if (result.close_window) {
        Lino.close_window();
    }
    
    if (result.refresh_all) {
        var cw = panel.get_containing_window();
        //~ console.log("20120123 refresh_all");
        if (cw) {
          cw.main_item.refresh();
        }
        //~ else console.log("20120123 cannot refresh_all",panel);
    } else {
        //~ console.log("20121212 b gonna refresh",panel);
        if (result.refresh) panel.refresh();
    }
    
    if (result.open_url) {
        //~ console.log(20111126,result.open_url);
        //~ if (!result.message)
            //~ Lino.notify('Open new window <a href="'+result.open_url+'" target="_blank">'+result.open_url+'</a>');
        window.open(result.open_url,'foo',"");
        //~ document.location = result.open_url;
    }
  }
};

Lino.do_action = function(caller,action) {
  action.success = function(response) {
    if (caller.loadMask) caller.loadMask.hide();
    //~ console.log('Lino.do_action()',action,'action success',response);
    if (action.after_success) {
        //~ console.log('Lino.do_action() calling after_success');
        action.after_success();
    }
    if (response.responseText) {
      var result = Ext.decode(response.responseText);
      //~ console.log('Lino.do_action()',action.name,'result is',result);
      if (result.message) {
          if (result.alert) {
              //~ Ext.MessageBox.alert('Alert',result.alert_msg);
              Ext.MessageBox.alert('Alert',result.message);
          } else {
              Lino.notify(result.message);
          }
      }
      
      //~ if (result.alert_msg) Ext.MessageBox.alert('Alert',result.alert_msg);
      //~ if (result.message) Lino.notify(result.message);
      if (result.notify_msg) Lino.notify(result.notify_msg);
      if (result.js_code) { 
        //~ console.log('Lino.do_action()',action,'gonna call js_code in',result);
        var jsr = result.js_code(caller);
        //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
        if (action.after_js_code) {
          //~ console.log('Lino.do_action()',action,'gonna call after_js_code');
          action.after_js_code(jsr);
          //~ console.log('Lino.do_action()',action,'returned from after_js_code');
        //~ } else {
          //~ console.log('Lino.do_action()',action,' : after_js_code is false');
        }
      };
    }
  };
  Ext.applyIf(action,{
    waitMsg: "Please wait...",
    failure: Lino.ajax_error_handler(caller),
    params: {}
  });
  //~ action.params.su = Lino.subst_user;
  Lino.insert_subst_user(action.params);
  
  Ext.Ajax.request(action);
};

//~ Lino.gup = function( name )
//~ {
  //~ // Thanks to http://www.netlobo.com/url_query_string_javascript.html
  //~ name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
  //~ var regexS = "[\\?&]"+name+"=([^&#]*)";
  //~ var regex = new RegExp( regexS );
  //~ var results = regex.exec( window.location.href );
  //~ if( results == null )
    //~ return "";
  //~ else
    //~ return results[1];
//~ };

//~ Lino.refresh_handler = function (ww) {
  //~ return function() { 
      //~ console.log('refresh',ww);
      //~ ww.main_item.doLayout(false,true);
      //~ ww.main_item.syncSize();
  //~ }
//~ };

//~ Lino.tools_close_handler = function (ww) {
  //~ return function() { 
      //~ ww.close();
  //~ }
//~ };
Lino.permalink_handler = function (ww) {
  return function() { 
    //~ document.location = ww.main_item.get_permalink();
    //~ console.log('20130723 Lino.permalink_handler',ww);
    
    /* Uncaught TypeError: Cannot read property 'main_item' of null  */
    if (ww) {
        var url = ww.main_item.get_permalink();
    } else {
        var url = Lino.viewport.get_permalink();
    }
    Lino.load_url(url);
  }
};
//~ Lino.run_permalink = function() {
  //~ var plink = Lino.gup('permalink');
  //~ if(plink) { eval('Lino.'+plink); }
//~ }


Lino.ajax_error_handler = function(panel) {
  return function(response,options) {
    console.log('Ajax failure:',response,options);
    if (panel.loadMask) panel.loadMask.hide();
    if (response.responseText) {
      var lines = response.responseText.split('\n');
      if (lines.length > 10) {
          line = lines.splice(5,lines.length-10,"(...)");
      }
      //~ console.log(20131005, response.statusText.toCamel());
      Ext.MessageBox.alert(
        response.statusText.toCamel(),
        lines.join('<br/>')
        //~ response.responseText.replace(/\n/g,'<br/>'))
      )
    } else {
      Ext.MessageBox.alert('Action failed',
        'Lino server did not respond to Ajax request');
    }
  }
}
// Ext.Ajax.on('requestexception',Lino.ajax_error_handler)
 


Ext.QuickTips.init();

/* setting QuickTips dismissDelay to 0 */
// Apply a set of config properties to the singleton
//~ Ext.apply(Ext.QuickTips.getQuickTip(), {
//~ Ext.apply(Ext.ToolTip, {
    //~ dismissDelay: 0
    //~ autoHide: false,
    //~ closable: true,
    //~ maxWidth: 200,
    //~ minWidth: 100,
    //~ showDelay: 50      // Show 50ms after entering target
    //~ ,trackMouse: true
//~ });


//~ Ext.apply(Ext.QuickTip, {
    //~ dismissDelay: 0,
//~ });
  
Lino.quicktip_renderer = function(title,body) {
  return function(c) {
    //~ if (c instanceof Ext.Panel) var t = c.bwrap; else // 20130129
    if (c instanceof Ext.Panel) var t = c.header; else // 20130129
    var t = c.getEl();
    //~ console.log(20130129,t,title,body);
    //~ t.dismissDelay = 0;
    Ext.QuickTips.register({
      target: t,
      //~ cls: 'lino-quicktip-classical',
      dismissDelay: 0,
      //~ autoHide: false,
      showDelay: 50,      // Show 50ms after entering target
      //~ title: title,
      text: body
    });
  }
};


  
Lino.help_text_editor = function() {
  //~ var bp = {
      //~ mk:this.content_type,
      //~ mt:1
    //~ };
    //~ console.log(20120202,bp);
  //~ Lino.lino.ContentTypes.detail({},{base_params:bp});
  //~ Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
  Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
}

// Path to the blank image should point to a valid location on your server
//~ Ext.BLANK_IMAGE_URL = MEDIA_URL + '/extjs/resources/images/default/s.gif'; 


// used as Ext.grid.Column.renderer for id columns in order to hide the special id value -99999
Lino.id_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  return value;
}

Lino.raw_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  return value;
}

Lino.text_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return "not implemented"; 
  return value;
}

Lino.NullNumberColumn = Ext.extend(Ext.grid.Column, {
    align : 'right', 
    format : '0,00/i', 
    renderer : function(value, metaData, record, rowIndex, colIndex, store) {
        //~ console.log(20130128,"NullNumberColumn.renderer",value);
        if (value === null) return '';
        return Ext.util.Format.number(value, this.format);
    }
});

//~ Lino.NullNumberColumn = Ext.extend(Ext.grid.NumberColumn, {
    //~ align : 'right', 
    //~ constructor: function(cfg){
        //~ Ext.grid.NumberColumn.superclass.constructor.call(this, cfg);
        //~ var t = this;
        //~ this.renderer = function(value, metaData, record, rowIndex, colIndex, store) {
          //~ console.log(20130128,"NullNumberColumn.renderer",value);
          //~ if (value === null) return '';
          //~ return Ext.util.Format.number(value, t.format);
      //~ };
    //~ }
//~ });




//~ Lino.cell_button_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return '<input type="button" onclick="alert(value)" value=" ? ">' ;
//~ }


//~ Lino.default_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  //~ return value;
//~ }

Lino.fk_renderer = function(fkname,handlername) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    //~ if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '.run(null,{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

Lino.lfk_renderer = function(panel,fkname) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  var handlername = 'console.log';
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '({},{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

//~ Lino.gfk_renderer = function() {
  //~ return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ if (record.phantom) return '';
    //~ console.log('Lino.gfk_renderer',value,colIndex,record,metaData,store);
    //~ return value;
  //~ }
//~ };


Lino.build_buttons = function(panel,actions) {
  //~ console.log("20121006 Lino.build_buttons",actions);
  if (actions) {
    var buttons = Array(actions.length);
    var cmenu = Array(actions.length);
    for (var i=0; i < actions.length; i++) { 
      var a = actions[i];
      //~ buttons[i] = new Ext.Toolbar.Button(a);
      if (a.menu) a.menu = Lino.build_buttons(panel,a.menu).bbar;
      buttons[i] = a;
      cmenu[i] = {
            text : a.menu_item_text,
            iconCls : a.iconCls,
            menu : a.menu
          };
      if (a.panel_btn_handler) {
          var h = a.panel_btn_handler.createCallback(panel);
          if (a.auto_save == true) {
              h = panel.do_when_clean.createDelegate(panel,[true,h]);
          } else if (a.auto_save == null) {
              h = panel.do_when_clean.createDelegate(panel,[false,h]);
          } else if (a.auto_save == false) {
              // h = h;
          } else {
              console.log("20120703 unhandled auto_save value",a)
          }
          buttons[i].handler = h;
          cmenu[i].handler = h;
          //~ if (buttons[i].xtype == 'splitbutton') {
              //~ cmenu[i].menu = a.menu;
          //~ } else {
              //~ cmenu[i].handler = h;
          //~ }
      } else {
          cmenu[i].handler = a.handler;
      }
    }
    return {bbar:buttons, cmenu:new Ext.menu.Menu(cmenu)};
  }
}

Lino.do_when_visible = function(cmp,todo) {
  //~ if (cmp.el && cmp.el.dom) 
  if (cmp.isVisible()) { 
    // 'visible' means 'rendered and not hidden'
    //~ console.log(cmp.title,'-> cmp is visible now');
    todo(); 
  //~ } else {
      //~ cmp.on('resize',todo,cmp,{single:true});
  //~ }
  //~ if (false) { // 20120213
  } else { 
    //~ console.log('Lino.do_when_visible() must defer because not isVisible()',todo,cmp);
    if (cmp.rendered) {
      //~ console.log(cmp,'-> cmp is rendered but not visible: and now?');
      //~ console.log(cmp.title,'-> cmp is rendered but not visible: try again in a moment...');
      //~ var fn = function() {Lino.do_when_visible(cmp,todo)};
      //~ fn.defer(100);
      
      Lino.do_when_visible.defer(50,this,[cmp,todo]);
      //~ Lino.do_when_visible.defer(100,this,[cmp,todo]);
      
    } else {
      //~ console.log(cmp.title,'-> after render');
      cmp.on('afterrender',todo,cmp,{single:true});
    }
  }
  
};    

/*
*/
Lino.do_on_current_record = function(panel,fn,phantom_fn) {
  var rec = panel.get_current_record();
  if (rec == undefined) {
    Lino.notify("There's no selected record.");
    return;
  }
  // 20120307 A VirtualTable with a Detail (lino.Models) has only "phantom" records.
  if (rec.phantom) {
    //~ if (!panel.editable) { console.log("20120312 not editable:",panel)}
    if (phantom_fn) {
      phantom_fn(panel);
    } else {
      Lino.notify("Action not available on phantom record.");
    }
    return;
  }
  return fn(rec);
};






Lino.call_ajax_action = function(panel,method,url,p,actionName,step,on_confirm,on_success) {
  p.an = actionName;
  if (!panel) {
      if (Lino.current_window) 
          panel = Lino.current_window.main_item;
      else panel = Lino.viewport;
  }
  //~ console.log("20130809 Lino.call_ajax_action",panel);
  Ext.apply(p,panel.get_base_params());
  
  if (panel.get_selected) {
      var selected_recs = panel.get_selected();
      //~ console.log("20130831",selected_recs);
      var rs = Array(selected_recs.length);
      for(var i=0; i < selected_recs.length;i++) {
          rs[i] = selected_recs[i].data.id;
      };
      p.sr = rs;
  }
  
  if (panel.loadMask) panel.loadMask.show(); 
  //~ p.$ext_requests.URL_PARAM_SUBST_USER = Lino.subst_user;
  //~ Lino.insert_subst_user(p);
    
  //~ if (step) p['$ext_requests.URL_PARAM_ACTION_STEP'] = step;
  //~ if (pp) pp(p); // "parameter processor" : first used for read beid card
  Ext.Ajax.request({
    method: method
    ,url: url
    ,params: p
    ,success: Lino.action_handler(panel,on_success,on_confirm)
    ,failure: Lino.ajax_error_handler(panel)
  });
};

Lino.row_action_handler = function(actionName,hm,pp) {
  var p = {};
  var fn = function(panel,btn,step) {
      if (pp) { p = pp(panel); if (! p) return; }
      
      if (panel.get_current_record == undefined) { // AFTER_20130725
        panel = Ext.getCmp(panel);
        if (panel == undefined) {
          Lino.notify("Invalid panel spec.");
          return;
        }
      }
      
      Lino.do_on_current_record(panel,function(rec) {
          //~ console.log(panel);
          //~ 20120723 Lino.call_ajax_action(panel,rec.id,actionName,step,fn);
          panel.add_param_values(p,true); // 20130915
          Lino.call_ajax_action(panel,hm,panel.get_record_url(rec.id),p,actionName,step,fn);
      });
  };
  return fn;
};

Lino.list_action_handler = function(ls_url,actionName,hm,pp) {
  var p = {};
  var url = '/api' + ls_url
  var fn = function(panel,btn,step) {
      //~ console.log("20121210 Lino.list_action_handler",arguments);
      //~ var url = ADMIN_URL + '/api' + panel.ls_url
      if (pp) { p = pp(panel);  if (! p) return; }
      panel.add_param_values(p,true); // 20130915
      Lino.call_ajax_action(panel,hm,url,p,actionName,step,fn);
  };
  return fn;
};

Lino.param_action_handler = function(window_action) { // 20121012
  var fn = function(panel,btn,step) {
    Lino.do_on_current_record(panel,function(rec) {
      //~ console.log(panel);
      //~ 20120723 Lino.call_ajax_action(panel,rec.id,actionName,step,fn);
      window_action.run(panel.getId(),{}); 
    });
  };
  return fn;
};


//~ 20130726 Lino.run_row_action = function(requesting_panel,url,pk,actionName,pp) {
Lino.run_row_action = function(requesting_panel,url,meth,pk,actionName,preprocessor) {
  //~ var panel = action.get_window().main_item;
  url = '/api' + url  + '/' + pk;
  var panel = Ext.getCmp(requesting_panel);
  if (preprocessor) var p = preprocessor(); else var p = {};
  var fn = function(panel,btn,step) {
    //~ 20120723 Lino.call_ajax_action(panel,pk,actionName,step,fn);
    //~ 20130726 Lino.call_ajax_action(panel,'GET',url,p,actionName,step,fn);
    Lino.call_ajax_action(panel,meth,url,p,actionName,step,fn);
  }
  fn(panel,null,null);
}



Lino.show_detail = function(panel,btn) {
  Lino.do_on_current_record(panel, 
    function(rec) {
      //~ panel.loadMask.show();
      Lino.run_detail_handler(panel,rec.id);
    },
    Lino.show_insert
  );
};

Lino.run_detail_handler = function(panel,pk) {
  var bp = panel.get_base_params();
  //~ var bp = {};
  panel.add_param_values(bp); // 20120918
  var status = {
    record_id:pk,
    base_params:bp
    //~ param_values: pv.$ext_requests.URL_PARAM_PARAM_VALUES
  }
  //~ console.log("20120918 Lino.show_detail",status);
  panel.ls_detail_handler.run(null,status);
  //~ panel.loadMask.hide();
  //~ panel.containing_window.window.hideMask();
  //~ panel.el.unmask();
}

Lino.show_fk_detail = function(combo,detail_action) {
    //~ console.log("Lino.show_fk_detail",combo,handler);
    pk = combo.getValue();
    if (pk) {
        detail_action.run(null,{record_id: pk})
      } else {
        Lino.notify("Cannot show detail for empty foreign key.");
      }
};

Lino.show_insert = function(panel,btn) {
  var bp = panel.get_base_params();
  //~ console.log('20120125 Lino.show_insert',bp)
  //~ panel.ls_insert_handler.run(null,{record_id:-99999,base_params:bp});
  panel.ls_insert_handler.run(panel.getId(),{record_id:-99999,base_params:bp});
};

//~ Lino.show_insert_duplicate = function(panel,btn) {
  //~ Lino.do_on_current_record(panel,
    //~ function(rec) {
      //~ var newRec = {};
      //~ Ext.apply(newRec,rec);
      //~ newRec.id = -99999;
      //~ panel.ls_insert_handler.run(null,{data_record:rec});
    //~ });
//~ };

//~ Lino.update_row_handler = function(action_name) {
  //~ return function(panel,btn) {
    //~ Lino.notify("Sorry, " + action_name + " is not implemented.");
  //~ }
//~ };




if (Ext.ux.grid !== undefined) {
    Lino.GridFilters = Ext.extend(Ext.ux.grid.GridFilters,{
      encode:true,
      local:false
    });
} else {
    Lino.GridFilters = function() {}; // dummy
    Ext.override(Lino.GridFilters,{
      init : function() {}
    });
};



//~ Lino.ButtonField = Ext.extend(Ext.form.TextField,{
//~ Lino.ButtonField = Ext.extend(Ext.form.Field,{
    //~ editable : false,
    //~ constructor : function(ww,config,params){
      //~ this.containing_window = ww;
      //~ if (params) Ext.apply(config,params);
      //~ Lino.ButtonField.superclass.constructor.call(this, config);
    //~ },
    //~ setButtons : function(buttons){
      //~ console.log('setButtons',buttons);
    //~ },
    //~ onRender : function(ct, position){
        //~ if(!this.el){
            //~ this.panel = new Ext.Container({items:[
              //~ {xtype:'button',text:'upload'},
              //~ {xtype:'button',text:'show'},
              //~ {xtype:'button',text:'edit'}
            //~ ]});
            //~ this.panel.ownerCt = this;
            //~ this.el = this.panel.getEl();

        //~ }
        //~ Lino.ButtonField.superclass.onRender.call(this, ct, position);
    //~ },

  
//~ });

Lino.FieldBoxMixin = {
  before_init : function(config,params) {
    if (params) Ext.apply(config,params);
    var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    if (actions) config.bbar = actions.bbar;
  },
  //~ constructor : function(ww,config,params){
    //~ this.containing_window = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  do_when_clean : function(auto_save,todo) { todo() },
  //~ format_data : function(html) { return '<div class="htmlText">' + html + '</div>' },
  format_data : function(html) { return html },
  get_base_params : function() {
    // needed for insert action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
  },
  set_base_params : function(p) {
    this.base_params = Ext.apply({},p);
    //~ if (p.param_values) this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  },
  set_base_param : function(k,v) {
    this.base_params[k] = v;
  }
};



Lino.HtmlBoxPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,{
  disabled_in_insert_window : true,
  constructor : function(config,params) {
    this.before_init(config,params);
    Lino.HtmlBoxPanel.superclass.constructor.call(this, config);
  },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.constructor.call(this, ww,config,params);
  //~ },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  //~ disable : function() { var tb = this.getBottomToolbar(); if(tb) tb.disable()},
  //~ enable : function() { var tb = this.getBottomToolbar(); if(tb) tb.enable()},
  onRender : function(ct, position){
    Lino.HtmlBoxPanel.superclass.onRender.call(this, ct, position);
    //~ console.log(20111125,this.containing_window);
    if (this.containing_panel) {
      this.containing_panel.on('enable',this.enable,this);
      this.containing_panel.on('disable',this.disable,this);
    }
    this.el.on({
      dragenter:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        return true;
      }
      ,dragover:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        event.stopEvent();
        return true;
      }
      ,drop:{
        scope:this
        ,fn:function(event){
          event.stopEvent();
          //~ console.log(20110516);
          var files = event.browserEvent.dataTransfer.files;
          if(files === undefined){
            return true;
          }
          var len = files.length;
          while(--len >= 0){
            console.log(files[len]);
            //~ this.processDragAndDropFileUpload(files[len]);
          }
          Lino.show_insert(this);
        }
      }
    });
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    //~ if (this.master_panel) {
      var record = this.containing_panel.get_current_record();
      //~ console.log('HtmlBox.refresh()',this.title,record,record.title);
      var box = this.items.get(0);
      var todo = function() {
        if (this.disabled) return;
        //~ this.set_base_params(this.containing_window.get_base_params());
        this.set_base_params(this.containing_panel.get_master_params());
        var el = box.getEl();
        if (el) {
          el.update(record ? this.format_data(record.data[this.name]) : '');
          //~ console.log('20130723 HtmlBox.refresh()',this.name);
        //~ } else {
          //~ console.log('HtmlBox.refresh() failed for',this.name);
        }
      };
      Lino.do_when_visible(box,todo.createDelegate(this));
    //~ }
  }
});
//~ Ext.override(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);



Lino.RichTextPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,Lino.FieldBoxMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,{
    
  //~ initComponent : function(){
    //~ Lino.RichTextPanel.superclass.initComponent.call(this);
  //~ },
  constructor : function(config,params) {
    //~ console.log('Lino.RichTextPanel.initComponent',this);
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + String(rec.id) + "/" + config.name;
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + config.name;
    var t = this;
    var tinymce_options = {
        theme : "advanced",
        content_css: '/media/lino/extjs/lino.css',
        language: 'de',
        //~ template_external_list_url : url,
        theme_advanced_toolbar_location : "top",
        theme_advanced_toolbar_align : "left",
        theme_advanced_statusbar_location : "bottom",
        template_popup_width : 700,
        template_popup_height : 500,
        template_replace_values : { 
            data_field : function(element){ 
                //~ console.log(20110722,fieldName,t.containing_window.get_current_record()); 
                var fieldName = element.innerHTML;
                element.innerHTML = t.containing_panel.get_current_record().data[fieldName];
            } 
        }
      };
      
    var editorConfig = {
      tinymceSettings: {
        plugins : "noneditable,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "bold,italic,underline,|,justifyleft,justifycenter,justifyright,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,removeformat,template",
        theme_advanced_buttons2 : "",
        theme_advanced_buttons3 : "", // ,|,sub,sup,|,charmap",      
        theme_advanced_resizing : false
        //~ save_onsavecallback : save_callback,
        //~ save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
        
    }};
    Ext.apply(editorConfig.tinymceSettings,tinymce_options);
    //~ editorConfig.name = config.action_name;
    editorConfig.name = config.name;
    delete config.name;
    //~ config.title = config.label;
    //~ delete config.label;
    this.before_init(config,params);
    
    this.editor = new Ext.ux.TinyMCE(editorConfig);
    var t = this;
    config.tools = [{
                      qtip: "Edit text in own window", 
                      id: "up",
                      handler: function(){
                        if(t.editor.isDirty()) {
                            var record = t.containing_panel.get_current_record();
                            record.data[t.editor.name] = t.editor.getValue();
                        }
                        Lino.edit_tinymce_text(t,tinymce_options)
                      }
                    }];
    
    config.items = this.editor;
    config.layout = "fit";
    Lino.RichTextPanel.superclass.constructor.call(this, config);
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    var record = this.containing_panel.get_current_record();
    //~ console.log('RichTextPanel.refresh()',this.title,record.title,record);
    var todo = function() {
      //~ this.set_base_params(this.containing_window.get_base_params());
      if (record) {
        var url = '/templates' + this.containing_panel.ls_url + "/" 
            + String(record.id) + "/" + this.editor.name;
        //~ console.log('RichTextPanel.refresh()',url);
        if (this.editor.ed) this.editor.ed.settings.template_external_list_url = url;
        this.set_base_params(this.containing_panel.get_master_params());
        //~ var v = record ? this.format_data(record.data[this.editor.name]) : ''
        var v = this.format_data(record.data[this.editor.name])
        this.editor.setValue(v);
      } else {
        this.editor.setValue('(no data)');
      }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
//~ Ext.override(Lino.RichTextPanel,Lino.FieldBoxMixin);



Lino.ActionFormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,Lino.PanelMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,Lino.FieldBoxMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  //~ layout:'fit'
  //~ ,autoHeight: true
  //~ ,frame: true
  window_title: "Action Parameters",
  constructor : function(config){
    config.bbar = [
        {text:'OK',handler:this.on_ok,scope:this},
        {text:'Cancel',handler:this.on_cancel,scope:this}
    ];
    //~ config.items = config.params_panel;
    Lino.ActionFormPanel.superclass.constructor.call(this, config);
  }
  //~ ,initComponent : function(){
    //~ Lino.ActionFormPanel.superclass.initComponent.call(this);
  //~ }
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
    //~ var rp = this.requesting_panel;
    var panel = this.requesting_panel;
    //~ console.log("20131004 on_ok",this,panel,arguments);
    //~ if (panel == undefined) {
        //~ Lino.alert("Sorry, dialog actions don't work without a requesting_panel");
        //~ return;
    //~ }
    //~ var rec = panel.get_current_record();
    var actionName = this.action_name;
    var pk = this.base_params.mk;
    if (pk == undefined && panel) {
        pk = panel.get_current_record().id;
    }
    if (pk == undefined) {
        Lino.alert("Sorry, dialog action without base_params.mk");
        return;
    }
    var self = this;
    function on_success() { self.get_containing_window().close(); };
    // 20131004
    //~ var url = '/api' + this.ls_url + '/' + pk;
    var url = '/api' + panel.ls_url + '/' + pk;
    var fn = function(panel,btn,step) {
      var p = {};
      self.add_field_values(p)
      //~ Lino.call_ajax_action(panel,'GET',panel.get_record_url(rec.id),p,actionName,step,fn,on_success);
      Lino.call_ajax_action(panel,'GET',url,p,actionName,step,fn,on_success);
    }
    fn(panel,null,null);
    
    
  }
  ,set_status : function(status,rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 ActionFormPanel.set_status()',status,rp,this.requesting_panel);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_field_values(status.field_values);
    if (status.base_params) this.set_base_params(status.base_params);
  }
  
  ,add_field_values : function (p) { // similar to add_param_values()
      //~ 20121023 
      if (this.form.isDirty()) {
        p.fv = this.get_field_values();
      }else{
        if (this.status_field_values) 
          p.fv = Lino.fields2array(this.fields,this.status_field_values);
      }
      //~ if (!this.form.isDirty()) return;
      //~ p.$ext_requests.URL_PARAM_FIELD_VALUES = this.get_field_values();
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
  }
  ,get_field_values : function() {
      return Lino.fields2array(this.fields);
  }
  ,set_field_values : function(pv) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_field_values = pv;
      if (pv) this.form.my_loadRecord(pv);
      else this.form.reset(); 
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.title = this.window_title;
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok }
      ]
  }
});

//~ Lino.add_blank = function(oa) {
    //~ return [].concat(oa)
    //~ return 
    //~ }
    
Lino.fields2array = function(fields,values) {
    //~ console.log('20130605 fields2array gonna loop on', fields,values);
    var pv = Array(fields.length);
    for(var i=0; i < fields.length;i++) {
        var f = fields[i]
        if (values) 
          var v = values[f.name];
        else 
          var v = f.getValue();
        if (f.formatDate) {
            pv[i] = f.formatDate(v); 
        } else {
            pv[i] = v; // f.getValue(); 
        }
    }
    return pv;
}


Lino.FormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.FormPanel = Ext.extend(Lino.FormPanel,Lino.PanelMixin);
Lino.FormPanel = Ext.extend(Lino.FormPanel,{
  params_panel_hidden : false,
  //~ base_params : {},
  //~ trackResetOnLoad : true,
  //~ query_params : {},
  //~ 20110119b quick_search_text : '',
  constructor : function(config,params){
    if (params) Ext.apply(config,params);
    this.base_params = {};
    //~ ww.config.base_params.query = ''; // 20111018
    //~ console.log(config);
    //~ console.log('FormPanel.constructor() 1',config)
    //~ Ext.applyIf(config,{base_params:{}});
    //~ console.log('FormPanel.constructor() 2',config)
      
    config.trackResetOnLoad = true;
    
    Lino.FormPanel.superclass.constructor.call(this, config);
      
    //~ this.set_base_param('$URL_PARAM_FILTER',null); // 20111018
    //~ this.set_base_param('$URL_PARAM_FILTER',''); // 20111018
      
  },
  initComponent : function(){
    
    //~ console.log("20111201 containing_window",this.containing_window,this);
    
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    if (actions) {
        this.bbar = actions.bbar;
    //~ } else {
        //~ this.bbar = [];
    }
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ var config = this;
    
    //~ if (this.containing_window instanceof Lino.DetailWrapper) {
    
    //~ console.log('20120121 initComponent', this.action_name);
    //~ if (this.action_name == 'detail' | this.action_name == 'show') {
    //~ if (this.action_name != 'insert') {
    if (! this.hide_top_toolbar) {
      this.tbar = [];
      // 20111015    
      if (! this.hide_navigator) {
        this.record_selector = new Lino.RemoteComboFieldElement({
          store: new Lino.ComplexRemoteComboStore({
            //~ baseParams: this.containing_window.config.base_params,
            baseParams: this.get_base_params(),
            //~ value: this.containing_window.config.base_params.query,
            proxy: new Ext.data.HttpProxy({
              url: '/choices' + this.ls_url,
              method:'GET'
            })
          }),
          pageSize:25,
          listeners: { 
            scope:this, 
            select:function(combo,record,index) {
              //~ console.log('jumpto_select',arguments);
              this.goto_record_id(record.id);
            }
          },
          emptyText: "Go to record"
        })
        this.tbar = this.tbar.concat([this.record_selector]);
        
        this.tbar = this.tbar.concat([
          this.first = new Ext.Toolbar.Button({
            tooltip:"First",disabled:true,handler:this.moveFirst,scope:this,iconCls:'x-tbar-page-first'}),
          this.prev = new Ext.Toolbar.Button({
            tooltip:"Previous",disabled:true,handler:this.movePrev,scope:this,iconCls:'x-tbar-page-prev'}),
          this.next = new Ext.Toolbar.Button({
            tooltip:"Next",disabled:true,handler:this.moveNext,scope:this,iconCls:'x-tbar-page-next'}),
          this.last = new Ext.Toolbar.Button({
            tooltip:"Last",disabled:true,handler:this.moveLast,scope:this,iconCls:'x-tbar-page-last'})
        ]);
      }
      this.tbar = this.add_params_panel(this.tbar);
      
      //~ console.log(20101117,this.containing_window.refresh);
      this.tbar = this.tbar.concat([
        {
          //~ text:'Refresh',
          handler:function(){ this.do_when_clean(true,this.refresh.createDelegate(this)) },
          iconCls: 'x-tbar-loading',
          tooltip:"Reload current record",
          scope:this}
      ]);
          
      if (this.bbar) { // since 20121016
        if (this.tbar) {
            this.tbar = this.tbar.concat(['-']) ;
        } else {
          this.tbar = [];
        }
        this.tbar = this.tbar.concat(this.bbar) ;
        this.bbar = undefined;
      }
    
      this.tbar = this.tbar.concat([
          '->',
          this.displayItem = new Ext.Toolbar.TextItem({})
      ]);
          
    }
    //~ if (this.content_type && this.action_name != 'insert') {
      //~ this.bbar = this.bbar.concat([
        //~ '->',
        //~ { text: "[$_('Help Text Editor')]",
          //~ handler: Lino.help_text_editor,
          //~ qtip: "$_('Edit help texts for fields on this model.')",
          //~ scope: this}
      //~ ])
    //~ }
    //~ this.before_row_edit = config.before_row_edit.createDelegate(this);
      
    //~ if (this.master_panel) {
        //~ this.set_base_params(this.master_panel.get_master_params());
    //~ }
      
    Lino.FormPanel.superclass.initComponent.call(this);
    
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.bwrap,{msg:"Please wait..."});
    },this);
    
    
    //~ var this_ = this;
    //~ this.cascade(function(cmp){
      //~ // var active_field = false;
      //~ for (i = 0; i < this_.active_fields.length; i++) {
        //~ if (cmp.name == this_.active_fields[i]) {
            //~ // active_field = true; break;
            //~ cmp.on("change",function() {this_.save()});
        //~ }
      //~ };
      //~ if (active_field) {
      // if (cmp instanceof Lino.GridPanel) {
          //~ cmp.on("change",function() {this_.save()});
      //~ }
    //~ });
    
    if (this.action_name == 'insert') {
      this.cascade(function(cmp){
        // console.log('20110613 cascade',cmp);
        if (cmp.disabled_in_insert_window) {
            //~ cmp.disable();
            cmp.hide();
        }
      });
      
    }
    
  },
  
  unused_is_loading : function() { 
    if (this.current_record == null) {
        //~ console.log("20130515 current_record is null");
        return true; 
    }
    
    if (! this.loadMask) return true; // not even rendered: 
    if (! this.loadMask.el) return true; // not even rendered: 
    // thanks to Marco Pegoraro http://movableapp.com/2011/09/sencha-touch-loadmask-isvisible/
    var loading = (this.loadMask.el.select('.x-loading-msg').elements.length > 0);
    //~ console.log('20130515 GridPanel.is_loading() returns',loading);
    return loading;

    
    var loading = false;
    this.cascade(function(cmp){
        if (cmp instanceof Lino.GridPanel && cmp.is_loading()) {
            //~ console.log(20130515, cmp.title,'is loading');
            loading = true;
            return false;
        }
      });
    return loading;
    //~ var a = this.findByType(Lino.GridPanel);
    //~ for (i=0;i<a.length;i++) {
        //~ if (a[i].is_loading()) return true;
    //~ }
    //~ return false;
  },
  
  get_status : function(){
      var st = {
        base_params: this.get_base_params(),
        data_record : this.get_current_record()
        }
      var tp = this.items.get(0);
      if (tp instanceof Ext.TabPanel) {
        st.active_tab = tp.getActiveTab();
      }
      st.param_values = this.status_param_values;
      return st;
  },
  /* FormPanel */
  set_status : function(status,rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 FormPanel.set_status()',status);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_param_values(status.param_values);
    if (status.base_params) this.set_base_params(status.base_params);
    var tp = this.items.get(0);
    if (tp instanceof Ext.TabPanel) {
      if (status.active_tab) {
        //~ console.log('20111201 active_tab',this.active_tab,this.items.get(0));
        //~ tp.activeTab = status.active_tab;
        tp.setActiveTab(status.active_tab);
        //~ this.main_item.items.get(0).activate(status.active_tab);
      } else {
        tp.setActiveTab(0);
      }
      }
    
    if (status.data_record) {
      //~ console.log('20111201 Lino.FormPanel with data_record',this.data_record.title,this.containing_window);
      //~ this.main_item.on_master_changed.defer(2000,this.main_item,[status.data_record]);
      //~ Lino.do_when_visible(this.main_item,function(){this.on_master_changed(status.data_record)});
      //~ this.main_item.on('afterrender',function(){
      //~   this.main_item.on_master_changed(status.data_record)},this,{single:true});
      /* must defer because because set_window_title() didn't work otherwise */
      this.set_current_record.createDelegate(this,[status.data_record]).defer(100);
      //~ this.set_current_record(this.data_record);
      //~ return;
    } else if (status.record_id != undefined) { 
      /* possible values include 0 and null, 0 being a valid record id, 
      null the equivalent of undefined
      */
      //~ this.main_item.goto_record_id(this.status.record_id);
      this.load_record_id(status.record_id);
    } else {
      this.set_current_record(undefined);
    }
  },
    
  get_base_params : function() {
    // needed for insert_action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
    //~ return this.base_params;
  },
  set_base_params : function(p) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    delete p['query'] // 20120725
    Ext.apply(this.base_params,p);
    if (this.record_selector) {
        var store = this.record_selector.getStore();
        for (k in p) store.setBaseParam(k,p[k]);
        delete this.record_selector.lastQuery;
        //~ console.log("20120725 record_selector.setBaseParam",p)
    }
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
        
      //~ if (this.record_selector) {
          //~ var store = this.record_selector.getStore();
          //~ for (k in store.baseParams) store.setBaseParam(k,undefined);
          //~ delete this.record_selector.lastQuery;
          //~ console.log("20120725 record_selector.getBaseParams() -->",store.baseParams)
      //~ }
  },
  set_base_param : function(k,v) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    this.base_params[k] = v;
    //~ if (this.record_selector) {
        //~ this.record_selector.getStore().setBaseParam(k,v);
        //~ delete this.record_selector.lastQuery;
    //~ }
  },
  
  after_delete : function() {
    if (this.current_record.navinfo.next)
      this.moveNext();
    else if (this.current_record.navinfo.prev)
      this.movePrev();
    else 
      this.abandon();
  },
  moveFirst : function() {this.goto_record_id(this.current_record.navinfo.first)},
  movePrev : function() {this.goto_record_id(this.current_record.navinfo.prev)},
  moveNext : function() {this.goto_record_id(this.current_record.navinfo.next)},
  moveLast : function() {this.goto_record_id(this.current_record.navinfo.last)},
  
  
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ console.log('20120121 Lino.FormPanel.refresh()',this);
    if (this.current_record) {
        this.load_record_id(this.current_record.id,after);
    } else {
        this.set_current_record(undefined,after);
    }
  },
  
  do_when_clean : function(auto_save,todo) {
    var this_ = this;
    if (this.form.isDirty()) {
        if (auto_save) {
            this_.save(todo);
        } else {
          //~ console.log('20111217 do_when_clean() form is dirty',this.form);
          var config = {title:"Confirmation"};
          config.buttons = Ext.MessageBox.YESNOCANCEL;
          config.msg = "Save changes to current record ?";
          config.fn = function(buttonId,text,opt) {
            //~ console.log('do_when_clean',buttonId)
            if (buttonId == "yes") {
                //~ Lino.submit_detail(this_,undefined,todo);
                //~ this_.containing_window.save(todo);
                this_.save(todo);
            } else if (buttonId == "no") { 
              todo();
            }
          }
        }
        Ext.MessageBox.show(config);
    }else{
      //~ console.log('do_when_clean : now!')
      todo();
    }
  },
  
  goto_record_id : function(record_id) {
    //~ console.log('20110701 Lino.FormPanel.goto_record_id()',record_id);
    //~ var this_ = this;
    //~ this.do_when_clean(function() { this_.load_record_id(record_id) }
    this.do_when_clean(true,this.load_record_id.createDelegate(this,[record_id]));
  },
  
  load_record_id : function(record_id,after) {
    var this_ = this;
    //~ var p = { fmt: this.containing_window.config.action_name};
    //~ var p = Ext.apply({},this.containing_window.config.base_params);
    var p = Ext.apply({},this.get_base_params());
    //~ Lino.insert_subst_user(p);
    //~ console.log('20110713 action_name=',this.containing_window.config.action_name,
      //~ 'base_params=',this.containing_window.config.base_params);
    if (this.action_name)
        p.an = this.action_name;
    //~ p.an = this.action_name;
    //~ p.an = this.containing_window.config.action_name;
    //~ p.fmt = 'json';
    //~ p.fmt = '$ext_requests.URL_FORMAT_JSON';
    p.rp = this.getId();
    //~ p.$ext_requests.URL_PARAM_SUBST_USER = Lino.subst_user;
    p.fmt = 'json';
    //~ 20110119b p['$URL_PARAM_FILTER'] = this.quick_search_text;
    //~ Ext.apply(p,this.query_params);
    this.add_param_values(p);
    //~ console.log('20121120 FormPanel.load_record_id',record_id,p);
    if (this.loadMask) this.loadMask.show();
    Ext.Ajax.request({ 
      waitMsg: 'Loading record...',
      method: 'GET',
      params: p,
      scope: this,
      url: this.get_record_url(record_id),
      success: function(response) {   
        // todo: convert to Lino.action_handler.... but result 
        if (this.loadMask) this.loadMask.hide();
        if (response.responseText) {
          var rec = Ext.decode(response.responseText);
          //~ console.log('20120918 goto_record_id success',rec);
          this.set_param_values(rec.param_values);
          this.set_current_record(rec,after);
        }
      },
      failure: Lino.ajax_error_handler(this)
    });
  },

  abandon : function () {
    Ext.MessageBox.alert('Note',
      "No more records to display. Detail window has been closed.");
    Lino.close_window();
    //~ if (this.containing_window) {
        //~ this.containing_window.hide();
    //~ }
  },
  
  set_current_record : function(record,after) {
    //~ console.log('20120722 Lino.FormPanel.set_current_record',record.title,record);
    if (this.record_selector) {
        this.record_selector.clearValue();
        // e.g. InsertWrapper FormPanel doesn't have a record_selector
    }
    this.current_record = record;
    //~ if (record) 
        //~ console.log('Lino.FormPanel.set_current_record',record.title,record);
    //~ else
        //~ console.log('Lino.FormPanel.set_current_record',record);
    //~ this.config.main_panel.form.load(record);    
    if (record) {
      this.enable();
      this.form.my_loadRecord(record.data);
      this.set_window_title(record.title);
      //~ this.getBottomToolbar().enable();
      var da = record.data.disabled_actions;
      if (da) {
          //~ console.log('20120528 disabled_actions =',da,this.getBottomToolbar());
          //~ 20121016 this.getBottomToolbar().items.each(function(item,index,length){
          var tb = this.getTopToolbar();
          if (tb) tb.items.each(function(item,index,length){
              //~ console.log('20120528 ',item.itemId,'-->',da[item.itemId]);
              if (da[item.itemId]) item.disable(); else item.enable();
          });
      };
      if (this.disable_editing | record.data.disable_editing) {
          //~ console.log("20120202 disable_editing",record.title);
          this.form.items.each(function(cmp){
            if (!cmp.always_enabled) cmp.disable();
          },this);
      } else {
          this.form.items.each(function(cmp){
            //~ console.log("20120202",cmp);
            if (record.data.disabled_fields[cmp.name]) cmp.disable();
            else cmp.enable();
          },this);
        
          //~ if (record.data.disabled_fields) {
              //~ for (i = 0; i < record.data.disabled_fields.length; i++) {
                  //~ var flds = this.find('name',record.data.disabled_fields[i]);
                  //~ if (flds.length == 1) { 
                    //~ flds[0].disable(); 
                  //~ }
              //~ }
          //~ }
      };
      if (this.first) {
        if (record.navinfo  && ! this.hide_navigator) {
          this.first.setDisabled(!record.navinfo.first);
          this.prev.setDisabled(!record.navinfo.prev);
          this.next.setDisabled(!record.navinfo.next);
          this.last.setDisabled(!record.navinfo.last);
          this.displayItem.setText(record.navinfo.message);
        } else {
          this.first.setDisabled(true);
          this.prev.setDisabled(true);
          this.next.setDisabled(true);
          this.last.setDisabled(true);
        }
      }
    } else {
      if (this.form.rendered) 
        this.form.reset(); /* FileUploadField would fail when resetting a non-rendered form */
      //~ this.disable();
      //~ this.getBottomToolbar().disable();
      this.form.items.each(function(cmp){
        cmp.disable();
      },this);
      this.set_window_title(this.empty_title);
      //~ this.containing_window.window.setTitle(this.empty_title);
      if (!this.hide_navigator) {
        this.first.disable();
        this.prev.disable();
        this.next.disable();
        this.last.disable();
      }
    }
    //~ console.log('20100531 Lino.DetailMixin.on_load_master_record',this.main_form);
    this.before_row_edit(record);
    if (after) after();
  },
  
  before_row_edit : function(record) {},
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.refresh();
  },
  
  get_selected : function() { return [ this.current_record ] },
  get_current_record : function() {  
    //~ console.log(20100714,this.current_record);
    return this.current_record 
  },
  
  get_permalink_url : function() {
      var rec = this.get_current_record();
      if (rec && ! rec.phantom && rec.id != -99998)
          return '/api' + this.ls_url + '/' + rec.id;
      return '/api' + this.ls_url;
    
  },
  get_permalink_params : function() {
    var p = {};
    //~ var p = {an:'detail'};
    if (this.action_name)
        p.an = this.action_name;
    //~ var p = {an:this.action_name};
    var main = this.items.get(0);
    if (main.activeTab) {
      var tab = main.items.indexOf(main.activeTab);
      //~ console.log('main.activeTab',tab,main.activeTab);
      if (tab) p.tab = tab;
    }
    this.add_param_values(p)
    return p;
  },
  
  /* 
  Lino.FormPanel.save() 
  */
  save : function(after,switch_to_detail,action_name) {
    //~ var panel = this;
    //~ console.log('20121120 FormPanel.save');
    this.loadMask.show();
    var rec = this.get_current_record();
    if (this.has_file_upload) this.form.fileUpload = true;
    //~ console.log('FormPanel.save()',rec);
    if (!action_name) action_name = this.action_name;
    if (rec) {
      var p = {};
      Ext.apply(p,this.get_base_params());
      p.rp = this.getId();
      //~ if (this.action_name) 
          //~ p.$ext_requests.URL_PARAM_ACTION_NAME = this.action_name;
      p.an = action_name;
      if (rec.phantom) {
        //~ if (this.action_name != 'insert') 
            //~ console.log("Warning: phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: '/api' + this.ls_url,
          method: 'POST',
          params: p, 
          scope: this,
          success: function(form, action) {
            this.loadMask.hide();
            Lino.notify(action.result.message);
            /***
            Close this window, but update the status of the 
            calling window.
            If the calling window is a detail on the same table,
            then it should skip to the new record. But only then.
            A successful response usually has a data_record,
            except if it is a fileupload form where some mysterious 
            decoding problems (20120209) force us to return a record_id 
            which will lead to an additional GET.
            ***/
            var url = this.ls_url;
            var ww = Lino.calling_window();
            if (ww && ww.window.main_item instanceof Lino.FormPanel 
                   && ww.window.main_item.ls_url == this.ls_url) {
                //~ console.log("20120217 case 1");
                ww.status.record_id = action.result.record_id;
                ww.status.data_record = action.result.data_record;
                Lino.close_window();
            } else if (this.ls_detail_handler && switch_to_detail) {
                //~ console.log("20120217 case 2");
                Lino.kill_current_window();
                this.ls_detail_handler.run(null,{
                    record_id:action.result.record_id,
                    data_record: action.result.data_record,
                    base_params:this.get_base_params()
                });
            } else {
                //~ console.log("20120217 case 3");
                Lino.close_window();
            }
            //~ Lino.close_window(function(ww){
                //~ if (ww.window.main_item instanceof Lino.FormPanel 
                    //~ && ww.window.main_item.ls_url == url) {
                  //~ ww.status.record_id = action.result.record_id,
                  //~ ww.status.data_record = action.result.data_record
                //~ }
            //~ });
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action);
          },
          clientValidation: true
        })
      } else {
        //~ if (this.action_name != 'detail') 
            //~ console.log("Warning: non-phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: '/api' + this.ls_url + '/' + rec.id,
          method: 'PUT',
          //~ headers: { 'HTTP_X_REQUESTED_WITH' : 'XMLHttpRequest'},
          scope: this,
          params: p, 
          success: function(form, action) {
            //~ panel.form.setValues(rec.data);
            //~ 20110701 panel.form.my_loadRecord(rec);
            this.loadMask.hide();
            Lino.notify(action.result.message);
            if (action.result.data_record)
                this.set_current_record(action.result.data_record,after);
            else
                console.log("Warning: no data_record in response to FormPanel.PUT")
            //~ this.refresh_with_after(after);
            //~ if (after) after(); else panel.refresh();
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action)},
          clientValidation: true
        })
      }
    } else Lino.notify("Sorry, no current record.");
  }
  
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
      this.save(null,true);
      //~ var rec = this.get_current_record();
      //~ if (rec && rec.phantom)
          //~ this.do_when_clean(true,function() { Lino.close_window(); });
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok, scope:this }
        ,{ key: Ext.EventObject.ESCAPE, fn: this.on_cancel, scope:this }
      ]
  }
  
  
  /* not used (no longer possible without .dtl files)
  , edit_detail_config : function () {
    var active_tab = {};
    var main = this.items.get(0);
    if (main.getActiveTab !== undefined) {
      var tabitem = main.getActiveTab();
      Ext.apply(active_tab,{$ext_requests.URL_PARAM_TAB : main.items.indexOf(tabitem)});
    }
    var editor = new Ext.form.TextArea();
    var close = function() { win.close(); }
    var _this = this;
    var save = function() { 
      //~ console.log(20110609,arguments); 
      var params = {desc: editor.getValue()};
      Ext.apply(params,active_tab);
      var a = { 
        params: params, 
        method: 'PUT',
        url: ADMIN_URL + '/detail_config' + _this.ls_url,
        failure : Lino.ajax_error_handler(this),
        success: Lino.action_handler( _this, function(result) {
          //~ console.log('detail_config/save success',result);
          win.close();
          document.location = _this.get_permalink();
        })
      };
      //~ console.log('detail_config/save sent',a);
      _this.loadMask.show(); // 20120211
      Ext.Ajax.request(a);
    }
    var save_btn = new Ext.Button({text:'Save',handler:save,disabled:true});
    var win = new Ext.Window({title:'Detail Layout',
      items:editor, layout:'fit',
      width:500,height:500,
      bbar:[{text:'Cancel',handler:close},save_btn]});
    var a = { 
      params:active_tab, 
      method:'GET',
      url:ADMIN_URL+'/detail_config'+_this.ls_url,
      success : function(response) {
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          if (result.success) {
            editor.setValue(result.desc);
            save_btn.enable();
          }
        }
      }
    };
    Ext.Ajax.request(a);
    win.show();
  }
  */
});



Lino.getRowClass = function(record, rowIndex, rowParams, store) {
    //~ console.log(20130816,record);
    //~ return 'x-grid3-row-green';
    return record.data.row_class;
  //~ if (true) {
      //~ return 'x-grid3-row-red';
  //~ }
  //~ if (record.phantom) {
    //~ console.log(20101009,record);
    //~ rowParams.bodyStyle = "color:red;background-color:blue";
    //~ return 'lino-phantom-row';
    //~ }
  //~ console.log('20101009 not a phantom:',record);
  //~ return '';
}

//~ FOO = 0;



Lino.GridStore = Ext.extend(Ext.data.ArrayStore,{ 
  autoLoad: false
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
    if (!options) options = {};
    if (!options.params) options.params = {};
    options.params.fmt = 'json';
    options.params.rp = this.grid_panel.getId();
    Lino.insert_subst_user(options.params); // since 20121016
      
    if (this.grid_panel.hide_top_toolbar) {
        //~ console.log("20120206 GridStore.load() toolbar is hidden");
        options.params.start = 0;
        if (this.grid_panel.preview_limit) {
          options.params.limit = this.grid_panel.preview_limit;
        }
    } else {
        var ps = this.grid_panel.calculatePageSize();
        if (!ps) {
            //~ this.gridpanel.on('render',this.load())
          //~ console.log("20120814 GridStore.load() failed to calculate pagesize");
          return false;
            //~ params.$URL_PARAM_LIMIT = 1;
            //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
            //~ return;
        } 
        options.params.limit = ps;
      
        //~ options.params.start = this.grid_panel.getTopToolbar().cursor;
        //~ if (this.grid_panel.getTopToolbar().pageSize !=  ps) {
          //~ console.log("20120206 abort load because toolbar says pagesize",
            //~ this.grid_panel.getTopToolbar().pageSize,
            //~ "while actual pagesize is",ps);
            //~ return;
        //~ }
        
        this.grid_panel.getTopToolbar().pageSize =  ps;
        if (options.params.start == undefined)
            options.params.start = this.grid_panel.getTopToolbar().cursor;
      
    }
      
    this.grid_panel.add_param_values(options.params);
    //~ Lino.insert_subst_user(options.params);
    //~ console.log("20120814 GridStore.load()",options.params,this.baseParams);
    //~ if (FOO > 0) {
        //~ foo.bar = baz;
    //~ } else FOO += 1;
    return Lino.GridStore.superclass.load.call(this,options);
  }
});

Lino.get_current_grid_config = function(panel) {
    return panel.get_current_grid_config();
}

Lino.GridPanel = Ext.extend(Ext.grid.EditorGridPanel,Lino.MainPanel);
Lino.GridPanel = Ext.extend(Lino.GridPanel,Lino.PanelMixin);
Lino.GridPanel = Ext.extend(Lino.GridPanel,{
  quick_search_text : '',
  is_searching : false,
  disabled_in_insert_window : true,
  clicksToEdit:2,
  enableColLock: false,
  autoHeight: false,
  params_panel_hidden : false,
  preview_limit : undefined, 
  //~ loadMask: true,
  //~ viewConfig: {
          //~ getRowClass: Lino.getRowClass,
          //~ emptyText:"$_('No data to display.')"
        //~ },
  loadMask: {msg:"Please wait..."},
  
  constructor : function(config){

    config.plugins = [new Lino.GridFilters()];
    
    
    Lino.GridPanel.superclass.constructor.call(this,config);
    
    //~ if (this.containing_window) {
        //~ console.log("20111206 install refresh");
        //~ this.containing_window.on('show',this.refresh,this);
    //~ }
    
  },
  
  unused_is_loading : function() { 
    if (! this.loadMask.el) return true; // not even rendered: 
    // thanks to Marco Pegoraro http://movableapp.com/2011/09/sencha-touch-loadmask-isvisible/
    var loading = (this.loadMask.el.select('.x-loading-msg').elements.length > 0);
    //~ console.log('20130515 GridPanel.is_loading() returns',loading);
    return loading;
    //~ return this.store.getCount() > 0; 
    //~ return (this.loadMask.el.select('.x-loading-msg').elements.length)
    //~ return !this.viewReady; 
    //~ return this.loadMask.isVisible(); 
    //~ return !this.loadMask.disabled; 
  },
  
  unused_config_containing_window : function(wincfg) { 
      //~ temporarily remove save_grid_config button (see /blog(2012/1107)
      if (wincfg.tools != undefined) 
        wincfg.tools = [
          //~ {handler:this.save_grid_data,
            //~ qtip:"$_("Save Grid Data")",
            //~ scope:this, id:"save_data"}, // 20120814
          {handler:this.save_grid_config,
            qtip:"Save Grid Configuration",
            scope:this, id:"save"}
        ].concat(wincfg.tools);
      //~ wincfg.listeners = { show: ... };
  },
  init_containing_window : function(win) { 
    //~ console.log("20111206 install refresh");
    //~ win.on('show',this.refresh,this);
  },
  
  initComponent : function(){
    
    /* 
    Problem 20111206:
    When a GridPanel is the main item of the window, then it doesn't 
    have it's own header but uses the window's header bar.
    We must do this in initComponent because e.g. in beforerender 
    it's already to late: a header element has been created because 
    there was a title.
    But Lino.Window adds itself as `this.containing_window` 
    only after the GridPanel has been initialized.
    Workaround is to generate a line "params.containing_window = true;" 
    in the handler function.
    */ 
    //~ if (this.containing_window) {
    if (this.is_main_window) {
        //~ console.log(20111206, 'delete title',this.title,'from',this);
        //~ delete this.title;
        this.tools = undefined;  
        this.title = undefined;  /* simply deleting it 
          isn't enough because that would only 
          unhide the title defined in some base class. */
    } 
    //~ else console.log(20111206, 'dont delete title',this.title,'from',this);
    
    /* e.g. when slave gridwindow called from a permalink */
    //~ if (this.base_params) Ext.apply(bp,this.base_params);  
    //~ bp['fmt'] = 'json';
    
    //~ function on_proxy_write( proxy, action,data, response,rs,options) {
      //~ console.log('20120814 on_proxy_write',action,data,response)
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
    //~ }
    //~ function on_proxy_load( proxy, transactionObject, callbackOptions ) {
      //~ console.log('on_proxy_load',transactionObject)
    //~ }
    var proxy = new Ext.data.HttpProxy({ 
      // 20120814 
      url: '/api' + this.ls_url
      ,method: "GET"
      //~ ,url: ADMIN_URL + '/restful' + this.ls_url
      //~ ,restful: true 
      //~ ,listeners: {load:on_proxy_load} 
      //~ ,listeners: {write:on_proxy_write} 
    });
    //~ config.store = new Ext.data.JsonStore({ 
    //~ this.store = new Ext.data.ArrayStore({ 
    this.store = new Lino.GridStore({ 
      grid_panel: this
      ,listeners: { exception: Lino.on_store_exception }
      ,remoteSort: true
      ,totalProperty: "count"
      ,root: "rows"
      //~ ,id: "id" 
      ,proxy: proxy
      //~ autoLoad: this.containing_window ? true : false
      ,idIndex: this.pk_index
      //~ ,baseParams: bp
      ,fields: this.ls_store_fields
      ,idProperty: this.ls_id_property 
      // 20120814
      //~ ,writer : new Ext.data.JsonWriter({
        //~ writeAllFields: false
        //~ ,listful: true
      //~ })
      //~ ,restful : true
    });
      
    //~ console.log('config.pk_index',config.pk_index,config.store),
    delete this.ls_store_fields;
      
    var this_ = this;
    //~ var grid = this;
    this.store.on('load', function() {
        //~ console.log('20120814 GridStore.on(load)',this_.store);
        //~ var da = this_.store.reader.arrayData.disabled_actions;
        //~ if (da) {
            //~ this.cmenu.cascade(function(item){ 
              //~ console.log(20120531, item.itemId, da[item.itemId]);
              //~ if (da[item.itemId]) item.disable(); else item.enable();
            //~ });
        //~ };
        this_.set_param_values(this_.store.reader.arrayData.param_values);
        //~ this_.set_status(this_.store.reader.arrayData.status);
        //~ 20120918
        this.getView().getRowClass = Lino.getRowClass;
        if (this_.store.reader.arrayData.no_data_text) {
            //~ this.viewConfig.emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().refresh();
        }
        if (this_.containing_window)
            this_.set_window_title(this_.store.reader.arrayData.title);
            //~ this_.containing_window.setTitle(this_.store.reader.arrayData.title);
        if (!this.is_searching) { // disabled 20121025: quick_search_field may not lose focus
          this.is_searching = false;
          if (this_.selModel.getSelectedCell){
              if (this_.getStore().getCount()) // there may be no data
                  this_.selModel.select(0,0); 
          } else {
              this_.selModel.selectFirstRow();
              this_.getView().focusEl.focus();
          }
        } 
        //~ else console.log("is_searching -> no focussing");
        //~ var t = this.getTopToolbar();
        //~ var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
        //~ this.quick_search_field.focus(); // 20121024
      }, this
    );
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar, this.cmenu = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ this.cmenu = new Ext.menu.Menu({items: config.bbar});
    delete this.ls_bbar_actions
    if (actions) {
        this.cmenu = actions.cmenu;
    }
    
    if (!this.hide_top_toolbar) {  
      var tbar = [ 
        this.quick_search_field = new Ext.form.TextField({ 
          //~ fieldLabel: "Search"
          listeners: { 
            scope:this_
            //~ ,change:this_.search_change
            
            ,render: Lino.quicktip_renderer("Quick Search","Enter a text to use as quick search filter")
            
            //~ ,keypress: this.search_keypress 
            ,blur: function() { this.is_searching = false}
          }
          ,validator:function(value) { return this_.search_validate(value) }
          //~ ,tooltip: "Enter a quick search text, then press TAB"
          //~ value: text
          //~ scope:this, 
          //~ ,enableKeyEvents: true
          //~ listeners: { keypress: this.search_keypress }, 
          //~ id: "seachString" 
      })];
      tbar = this.add_params_panel(tbar);
      tbar = tbar.concat([
        { scope:this, 
          //~ text: "[csv]", 
          tooltip: "Export this table to a .csv file", 
          iconCls: 'x-tbar-csv',
          handler: function() { 
            //~ 20130116 var p = Ext.apply({},this.get_base_params());
            //~ 20130116 p.fmt = 'csv';
            //~ url += "?" + Ext.urlEncode(p);
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            p.fmt = "csv";
            this.add_param_values(p,true);
            
            window.open('/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } },
        //~ { scope:this, 
          //~ text: "[html]", 
          //~ handler: function() { 
            //~ var p = this.get_current_grid_config();
            //~ Ext.apply(p,this.get_base_params());
            //~ p.$ext_requests.URL_PARAM_FORMAT = "$ext_requests.URL_FORMAT_PRINTER";
            //~ this.add_param_values(p);
            //~ window.open(ADMIN_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          //~ } },
        { scope:this, 
          //~ text: "[html]", 
          tooltip: "Show this table in plain html", 
          iconCls: 'x-tbar-html',
          handler: function() { 
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            //~ since 20121226 p.$ext_requests.URL_PARAM_FORMAT = "$ext_requests.URL_FORMAT_PLAIN";
            this.add_param_values(p,true);
            //~ since 20121226 window.open(ADMIN_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
            window.open('/plain'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } }
        
      ]);
    
    
      var menu = [];
      var set_gc = function(index) {
        return function() {
          //~ console.log('set_gc() 20100812');
          this.getColumnModel().setConfig(
              this.apply_grid_config(index,this.ls_grid_configs,this.ls_columns));
        }
      }
      for (var i = 0; i < this.ls_grid_configs.length;i++) {
        var gc = this.ls_grid_configs[i];
        menu.push({text:gc.label,handler:set_gc(i),scope:this})
      }
      if(menu.length > 1) {
        tbar = tbar.concat([
          { text:"View",
            menu: menu,
            tooltip:"Select another view of this report"
          }
        ]);
      }
      
      if (actions) {
        tbar = tbar.concat(actions.bbar);
          //~ this.bbar = actions.bbar;
      }
      
      this.tbar = new Ext.PagingToolbar({ 
        store: this.store, 
        prependButtons: true, 
        //~ pageSize: this.page_length, 
        pageSize: 1, 
        displayInfo: true, 
        beforePageText: "Page",
        afterPageText: "of {0}",
        displayMsg: "Displaying {0} - {1} of {2}",
        firstText: "First page",
        lastText: "Last page",
        prevText: "Previous page",
        nextText: "Next page",
        items: tbar
      });
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ var ps = this.calculatePageSize();
          //~ if (ps && ps != this.getTopToolbar().pageSize) {
              //~ // console.log('20120203 resize : pageSize',this.getTopToolbar().pageSize,'->',ps);
              //~ // this.getTopToolbar().pageSize =  ps;
              //~ cmp.refresh();
              //~ // this.getTopToolbar().doRefresh();
          //~ }
        //~ }, this);
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ cmp.getTopToolbar().pageSize = this.calculatePageSize(aw,ah,rw,rh) || 10;
          //~ cmp.refresh();
        //~ }, this, {delay:500});
    }
    
    //~ delete this.page_length
    
    
      
    if (this.cell_edit) {
      this.selModel = new Ext.grid.CellSelectionModel()
      this.get_selected = function() {
        //~ console.log(this.getSelectionModel().selection);
        if (this.selModel.selection)
            return [ this.selModel.selection.record ];
        return [this.store.getAt(0)];
      };
      this.get_current_record = function() { 
        if (this.getSelectionModel().selection) 
          return this.selModel.selection.record;
        return this.store.getAt(0);
      };
    } else { 
      this.selModel = new Ext.grid.RowSelectionModel() 
      this.get_selected = function() {
        var sels = this.selModel.getSelections();
        if (sels.length == 0) sels = [this.store.getAt(0)];
        return sels
        //~ var sels = this.getSelectionModel().getSelections();
        //~ return Ext.pluck(sels,'id');
      };
      this.get_current_record = function() { 
        var rec = this.selModel.getSelected();
        if (rec == undefined) rec = this.store.getAt(0);
        return rec
      };
    };
    this.columns  = this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns);
    
    //~ var grid = this;
    //~ this.colModel = new Ext.grid.ColumnModel({
      //~ columns: this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns),
      //~ isCellEditable: function(col, row) {
        //~ var record = grid.store.getAt(row);
        //~ console.log('20120514',col,record); // dataIndex
        //~ var dataIndex = grid.colModel.getDataIndex(col);
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("$_("This field is disabled")");
            //~ return false;
        //~ }
        //~ return Ext.grid.ColumnModel.prototype.isCellEditable.call(this, col, row);
      //~ }
    //~ });    
    
    
    Lino.GridPanel.superclass.initComponent.call(this);
    
    //~ if (this.containing_window) 
        //~ this.on('afterlayout', this.refresh, this);
        //~ this.on('afterrender', this.refresh,this);
    //~ else
        //~ this.on('show', this.refresh,this);
    //~ this.on('afterlayout', function() {
      //~ if (this.id == "ext-comp-1157") 
        //~ console.log("20120213 afterlayout",this); 
      //~ // this.refresh();
      //~ },this);
    //~ this.on('afterrender', this.refresh);
    //~ this.on('resize', this.refresh,this,{delay:500});
    //~ this.on('resize', function(){console.log("20120213 resize",arguments)},this);
    this.on('resize', function(){
      //~ console.log("20120213 resize",arguments)
      this.refresh();
      },this);
    this.on('viewready', function(){
      //~ console.log("20120213 resize",arguments);
      this.view_is_ready = true;
      this.refresh(); // removed 20130911
      },this);
    this.on('afteredit', this.on_afteredit); // 20120814
    //~ this.on('afteredit', this.new_on_afteredit);
    this.on('beforeedit', this.on_beforeedit);
    this.on('beforeedit',function(e) { this.before_row_edit(e.record)},this);
    if (this.cell_edit) {
        this.on('cellcontextmenu', Lino.cell_context_menu, this);
    } else {
        this.on('rowcontextmenu', Lino.row_context_menu, this);
    }
    //~ this.on('contextmenu', Lino.grid_context_menu, this);
    
    
    //~ if (this.id == "ext-comp-1157") captureEvents(this);    
    
    delete this.cell_edit;
    
  },
  
  //~ onResize : function(){
      //~ console.log("20120206 GridPanel.onResize",arguments);
      //~ Lino.GridPanel.superclass.onResize.apply(this, arguments);
      //~ this.refresh();
  //~ },
  
  
  get_status : function(){
    var st = { base_params : this.get_base_params()};
    if (!this.hide_top_toolbar) {
        st.current_page = this.getTopToolbar().current;
    }
    st.param_values = this.status_param_values;
    //~ console.log("20120213 GridPanel.get_status",st);
    return st;
  },
  
  /* 
  Lino.GridPanel.set_status() 
  */
  set_status : function(status){
    //~ console.log("20130605 GridPanel.set_status",status);
    this.clear_base_params();
    if (status == undefined) status = {};
    this.set_param_values(status.param_values);
    if (status.base_params) { 
      this.set_base_params(status.base_params);
    }
    if (status.show_params_panel != undefined) {
        if (this.toggle_params_panel_btn) {
            //~ this.toggle_params_panel_btn.toggle(status.show_params_panel=='true');
            this.toggle_params_panel_btn.toggle(status.show_params_panel);
        }
    }
    if (!this.hide_top_toolbar) {
      //~ console.log("20120213 GridPanel.getTopToolbar().changePage",
          //~ status.current_page || 1);
      this.getTopToolbar().changePage(status.current_page || 1);
    }
    //~ this.fireEvent('resize');
    //~ this.refresh.defer(100,this); 
    //~ this.onResize.defer(100,this); 
    //~ this.refresh(); 
    //~ this.doLayout(); 
    //~ this.onResize(); 
    //~ this.store.load();
  },
  
  refresh : function(unused) { 
    this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ Lino.notify('Lino.GridPanel.refresh '+this.store.proxy.url);
    //~ var bp = { fmt:'json' }
    if (! this.view_is_ready) return;
    
    if (this.containing_panel) {
        //~ Ext.apply(p,this.master_panel.get_master_params());
        //~ Ext.apply(options.params,this.containing_panel.get_master_params());
        this.set_base_params(this.containing_panel.get_master_params());
        // 20130911
        if (!this.store.baseParams.mk) {  
            return;
        }
    }
    
    
    //~ console.log('20130911 Lino.GridPanel.refresh_with_after',this.containing_panel.get_master_params());
    
    var options = {};
    if (after) {
        options.callback = function(r,options,success) {if(success) after()}
    }
      
    //~ if (!this.rendered) {
        //~ console.log("20120206 GridPanel.refresh() must wait until rendered",options);
        //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
        //~ return;
    //~ }
    
    this.store.load(options);
  },
  
  /* pageSize depends on grid height (Trying to remove scrollbar)
  Thanks to 
  - Christophe Badoit on http://www.sencha.com/forum/showthread.php?82647
  - http://www.sencha.com/forum/archive/index.php/t-37231.html
  */
  calculatePageSize : function(second_attempt) {
    //~ if (!this.rendered) { 
    if (!this.view_is_ready) { 
      //~ console.log('Cannot calculatePageSize() : not rendered');
      return false; }
    //~ if (!this.isVisible()) { 
      //~ console.log('calculatePageSize : not visible');
      //~ return false; }
      
    //~ console.log('getFrameHeight() is',this.getFrameHeight());
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('mainBody.getHeight() is',this.getView().mainBody.getHeight());
    //~ console.log('getInnerHeight() is',this.getInnerHeight());
    //~ console.log('getHeight() is',this.getHeight());
    //~ console.log('el.getHeight() is',this.getEl().getHeight());
    //~ console.log('getGridEl().getHeight() is',this.getGridEl().getHeight());
    //~ console.log('getOuterSize().height is',this.getOuterSize().height);
    //~ console.log('getBox().height is',this.getBox().height);
    //~ console.log('getResizeEl.getHeight() is',this.getResizeEl().getHeight());
    //~ console.log('getLayoutTarget().getHeight() is',this.getLayoutTarget().getHeight());
      
    //~ var rowHeight = 52; // experimental value
    var row = this.view.getRow(0);
    if (row) {
      //~ console.log('20120213 yes');
      var rowHeight = Ext.get(row).getHeight();
    } else {
        //~ var rowHeight = this.getFrameHeight();
        //~ var rowHeight = 10; // reasonably smallest approximative value
        //~ There is no data yet. Construct a fake row and get its height
        var Element = Ext.Element;
        var gv = this.view;
        var fakeBody = new Element(Element.fly(gv.scroller).child('div.x-grid3-body'));
        var rowTemplate = gv.templates.row;
        var cellTemplate = gv.templates.cell;
        var tstyle  = 'width:' + gv.getGridInnerWidth() + 'px;';
        var cells = cellTemplate.apply({value:'&#160;'});
        var markup = rowTemplate.apply({
                tstyle: tstyle,
                cols  : 1,
                cells : cells,
                alt   : ''
            });        
        fakeBody.dom.innerHTML = gv.templates.body.apply({rows: markup});
        var row = fakeBody.dom.childNodes[0];
        var rowHeight = Ext.get(row).getHeight();
    }
    //~ console.log('rowHeight is ',rowHeight,this,caller);
    //~ this.getView().syncScroll();
    //~ this.getView().initTemplates();
    var height = this.getView().scroller.getHeight();
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('getInnerHeight() - getFrameHeight() is',
      //~ this.getInnerHeight(), '-',
      //~ this.getFrameHeight(), '=',
      //~ this.getInnerHeight() - this.getFrameHeight());
    //~ var height = this.getView().mainBody.getHeight();
    //~ var height = this.getView().mainWrap.getHeight();
    //~ var height = this.getView().resizeMarker.getHeight();
    //~ this.syncSize();
    //~ var height = this.getInnerHeight() - this.getFrameHeight();
    //~ var height = this.getHeight() - this.getFrameHeight();
    height -= Ext.getScrollBarWidth(); // leave room for a possible horizontal scrollbar... 
    //~ height -= this.getView().scrollOffset;
    var ps = Math.floor(height / rowHeight);
    //~ console.log('20130816 calculatePageSize():',height,'/',rowHeight,'->',ps);
    ps -= 1; // leave room for a possible phantom row
    //~ return (ps > 1 ? ps : false);
    if (ps > 1) return ps;
    //~ console.log('calculatePageSize() found less than 1 row:',height,'/',rowHeight,'->',ps);
    //~ foo.bar = baz; // 20120213
    return 5; // preview_limit
    //~ if (second_attempt) {
        //~ console.log('calculatePageSize() abandons after second attempt:',
          //~ height,'/',rowHeight,'->',ps);
      //~ return 5;
    //~ }
    //~ return this.calculatePageSize.defer(500,this,[true]);
  },
  
  onCellDblClick : function(grid, row, col){
      //~ console.log("20120307 onCellDblClick",this,grid, row, col);
      if (this.ls_detail_handler) {
          //~ Lino.notify('show detail');
          Lino.show_detail(this);
          return false;
      }else{
        //~ console.log('startEditing');
        this.startEditing(row,col);
      }
  },
  
  get_base_params : function() {
    //~ return this.containing_window.config.base_params;
    //~ console.log(20120717,this.store.baseParams);
    var p = Ext.apply({},this.store.baseParams);
    Lino.insert_subst_user(p);
    //~ console.log("20120717 GRidPanel.get_base_params() returns",p);
    return p;
    //~ return this.store.baseParams;
  },
  set_base_params : function(p) {
    //~ console.log('20130911 GridPanel.set_base_params',p)
    for (k in p) this.store.setBaseParam(k,p[k]);
    //~ this.store.baseParams = p;
    if (p.query) 
        this.quick_search_field.setValue(p.query);
    //~ if (p.param_values) 
        //~ this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.store.baseParams = {};
      Lino.insert_subst_user(this.store.baseParams);
  },
  set_base_param : function(k,v) {
    this.store.setBaseParam(k,v);
  },
  
  //~ get_permalink_params : function() {
    //~ var p = {};
    //~ return p;
  //~ },
  
  before_row_edit : function(record) {},
    
  //~ search_keypress : function(){
    //~ console.log("2012124 search_keypress",arguments);
  //~ },
  search_validate : function(value) {
    if (value == this.quick_search_text) return true;
    this.is_searching = true;
    //~ console.log('search_validate',value)
    this.quick_search_text = value;
    this.set_base_param('query',value); 
    //~ this.getTopToolbar().changePage(1);
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
    return true;
  },
  
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
  },
  
  apply_grid_config : function(index,grid_configs,rpt_columns) {
    //~ var rpt_columns = this.ls_columns;
    var gc = grid_configs[index];    
    //~ console.log('apply_grid_config() 20100812',name,gc);
    this.gc_name = index;
    if (gc == undefined) {
      return rpt_columns;
      //~ config.columns = config.ls_columns;
      //~ return;
    } 
    //~ delete config.ls_filters
    
    //~ console.log(20100805,config.ls_columns);
    var columns = Array(gc.columns.length);
    for (var j = 0; j < rpt_columns.length;j++) {
      var col = rpt_columns[j];
      for (var i = 0; i < gc.columns.length; i++) {
        if (col.dataIndex == gc.ci[i]) {
          col.width = gc.cw[i];
          col.hidden = gc.ch[i];
          columns[i] = col;
          break;
        }
      }
    }
    
    //~ var columns = Array(rpt_columns.length);
    //~ for (var i = 0; i < rpt_columns.length; i++) {
      //~ columns[i] = rpt_columns[gc.columns[i]];
      //~ columns[i].width = gc.widths[i];
    //~ }
    
    //~ if (gc.hidden_cols) {
      //~ for (var i = 0; i < gc.hidden_cols.length; i++) {
        //~ var hc = gc.hidden_cols[i];
        //~ for (var j = 0; j < columns.length;j++) {
          //~ var col = columns[j];
          //~ if (col.dataIndex == hc) {
            //~ col.hidden = true;
            //~ break
          //~ }
        //~ }
      //~ }
    //~ }
    if (gc.filters) {
      //~ console.log(20100811,'config.ls_filters',config.ls_filters);
      //~ console.log(20100811,'config.ls_grid_config.filters',config.ls_grid_config.filters);
      for (var i = 0; i < gc.filters.length; i++) {
        var fv = gc.filters[i];
        for (var j = 0; j < columns.length;j++) {
          var col = columns[j];
          if (col.dataIndex == fv.field) {
            //~ console.log(20100811, f,' == ',fv);
            if (fv.type == 'string') {
              col.filter.value = fv.value;
              //~ if (fv.comparison !== undefined) f.comparison = fv.comparison;
            } else {
              //~ console.log(20100811, fv);
              col.filter.value = {};
              col.filter.value[fv.comparison] = fv.value;
            }
            break;
          }
        };
      }
    }
    
    return columns;
    //~ config.columns = cols;
    //~ delete config.ls_columns
  },
  
  get_current_grid_config : function () {
    var cm = this.getColumnModel();
    var widths = Array(cm.config.length);
    var hiddens = Array(cm.config.length);
    //~ var hiddens = Array(cm.config.length);
    var columns = Array(cm.config.length);
    //~ var columns = Array(cm.config.length);
    //~ var hidden_cols = [];
    //~ var filters = this.filters.getFilterValues();
    var p = this.filters.buildQuery(this.filters.getFilterData())
    for (var i = 0; i < cm.config.length; i++) {
      var col = cm.config[i];
      columns[i] = col.dataIndex;
      //~ hiddens[i] = col.hidden;
      widths[i] = col.width;
      hiddens[i] = col.hidden;
      //~ if (col.hidden) hidden_cols.push(col.dataIndex);
    }
    //~ p['hidden_cols'] = hidden_cols;
    p.cw = widths;
    p.ch = hiddens;
    p.ci = columns;
    //~ p['widths'] = widths;
    //~ p['hiddens'] = hiddens;
    //~ p['columns'] = columns;
    p['name'] = this.gc_name;
    //~ var gc = this.ls_grid_configs[this.gc_name];
    //~ if (gc !== undefined) 
        //~ p['label'] = gc.label
    //~ console.log('20100810 save_grid_config',p);
    return p;
  },
  
  unused_manage_grid_configs : function() {
    var data = [];
    for (k in this.ls_grid_configs) {
      var v = this.ls_grid_configs[k];
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i)
    }
    if (this.ls_grid_configs[this.gc_name] == undefined) {
      var v = this.get_current_grid_config();
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i);
    }
    //~ console.log(20100811, data);
    var main = new Ext.grid.GridPanel({
      store: new Ext.data.ArrayStore({
        idIndex:0,
        fields:['name','columns','hidden_cols','filters'],
        autoDestroy:true,
        data: data}),
      //~ autoHeight:true,
      selModel: new Ext.grid.RowSelectionModel(),
      listeners: { 
        rowdblclick: function(grid,rowIndex,e) {
          console.log('row doubleclicked',grid, rowIndex,e);
        },
        rowclick: function(grid,rowIndex,e) {
          console.log('row clicked',grid, rowIndex,e);
        }
      },
      columns: [ 
        {dataIndex:'name',header:'Name'}, 
        {dataIndex:'columns',header:'columns'}, 
        {dataIndex:'hidden_cols',header:'hidden columns'}, 
        {dataIndex:'filters',header:'filters'} 
      ]
    });
    var win = new Ext.Window({title:'GridConfigs Manager',layout:'fit',items:main,height:200});
    win.show();
  },
  
  unused_edit_grid_config : function(name) {
    gc = this.ls_grid_configs[name];
    var win = new Ext.Window({
      title:'Edit Grid Config',layout:'vbox', 
      //~ layoutConfig:'stretch'
      items:[
        {xtype:'text', value: gc.name},
        {xtype:'text', value: gc.columns},
        {xtype:'text', value: gc.hidden_cols},
        {xtype:'text', value: gc.filters}
      ]
    });
    win.show();
  },
  
  save_grid_config : function () {
    //~ console.log('TODO: save_grid_config',this);
    //~ p.column_widths = Ext.pluck(this.colModel.columns,'width');
    var a = { 
      params:this.get_current_grid_config(), 
      method:'PUT',
      url:'/grid_config' + this.ls_url,
      success: Lino.action_handler(this),
      scope: this,
      failure: Lino.ajax_error_handler(this)
    };
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(a);
    //~ Lino.do_action(this,a);
  },
  
  on_beforeedit : function(e) {
    //~ console.log('20130128 GridPanel.on_beforeedit()',e,e.record.data.disable_editing);
    if(this.disable_editing | e.record.data.disable_editing) {
      e.cancel = true;
      Lino.notify("This record is disabled");
      return;
    }
    if(e.record.data.disabled_fields && e.record.data.disabled_fields[e.field]) {
      e.cancel = true;
      Lino.notify("This field is disabled");
      return;
    }
    //~ if (e.record.data.disabled_fields) {
      //~ for (i in e.record.data.disabled_fields) {
        //~ if(e.record.data.disabled_fields[i] == e.field) {
          //~ e.cancel = true;
          //~ Lino.notify(String.format('Field "{0}" is disabled for this record',e.field));
          //~ return
        //~ }
      //~ }
    //~ }
  },
  save_grid_data : function() {
      //~ console.log("20120814 save_grid_data");
      this.getStore().commitChanges();
  },
  new_on_afteredit : function(e) {
      //~ this.getStore().commitChanges();
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
      console.log("20120814 new_on_afteredit",e);
  },
  on_afteredit : function(e) {
    /*
    e.grid - The grid that fired the event
    e.record - The record being edited
    e.field - The field name being edited
    e.value - The value being set
    e.originalValue - The original value for the field, before the edit.
    e.row - The grid row index
    e.column - The grid column index
    */
    var p = {};
    //~ console.log('20101130 modified: ',e.record.modified);
    //~ console.log('20101130 value: ',e.value);
    //~ var p = e.record.getChanges();
    //~ console.log('20101130 getChanges: ',e.record.getChanges());
    //~ this.before_row_edit(e.record);
    for(k in e.record.getChanges()) {
        var v = e.record.get(k);
    //~ for(k in e.record.modified) {
        //~ console.log('20101130',k,'=',v);
        //~ var cm = e.grid.getColumnModel();
        //~ var di = cm.getDataIndex(k);
        var f = e.record.fields.get(k);
        //~ console.log('20101130 f = ',f);
        //~ var v = e.record.get(di);
        if (f.type.type == 'date') {
            p[k] = Ext.util.Format.date(v, f.dateFormat);
        }else{
            p[k] = v;
            var v = e.record.get(k+'Hidden');
            if (v !== undefined) {
              p[k+'Hidden'] = v;
            }
        }
        //~ var i = cm.findColumnIndex(k);
        //~ var r = cm.getRenderer(i);
        //~ var editor = cm.getCellEditor(i,e.row);
        //~ var col = e.grid.getColumnModel().getColumnById(k);
        //~ console.log('20101130 r = ',r(v));
        //~ var f = e.record.fields[k];
        //~ console.log('20101130 f = ',f);
        //~ console.log('20101130 editor = ',editor);
        //~ p[k] = f.getValue();
        //~ p[k] = r(v);
    }
    //~ console.log('20101130 p:',p);
    //~ var cm = e.grid.getColumnModel();
    //~ var di = cm.getDataIndex(e.column);
    //~ var f = e.record.fields.get(di);
    //~ console.log('20101130 f = ',f);
    //~ if (f.type.type == 'date') e.record.set(di,Ext.util.Format.date(e.value, f.dateFormat));
    
    
    //~ var p = e.record.data;
    
    // var p = {};
    //~ p['grid_afteredit_colname'] = e.field;
    //~ p[e.field] = e.value;
    //~ console.log('20100723 GridPanel.on_afteredit()',e);
    // add value used by ForeignKeyStoreField CHOICES_HIDDEN_SUFFIX
    // not sure whether this is still needed:
    p[e.field+'Hidden'] = e.value;
    //~ p.su = Lino.subst_user;
    Lino.insert_subst_user(p);
    // this one is needed so that this field can serve as choice context:
    e.record.data[e.field+'Hidden'] = e.value;
    // p[pk] = e.record.data[pk];
    // console.log("grid_afteredit:",e.field,'=',e.value);
    Ext.apply(p,this.get_base_params()); // needed for POST, ignored for PUT
    //~ Ext.apply(p,this.containing_window.config.base_params);
    //~ 20121109 p['$ext_requests.URL_PARAM_ACTION_NAME'] = 'grid';
    var self = this;
    var req = {
        params:p,
        waitMsg: 'Saving your data...',
        success: Lino.action_handler( this, function(result) {
          //~ if (result.data_record) {
          if (result.refresh_all) {
              var cw = self.get_containing_window();
              if (cw) {
                  cw.main_item.refresh();
              }
              else console.log("20120123 cannot refresh_all",self);
          } else if (result.rows) {
              //~ self.getStore().loadData(result,true);
              var r = self.getStore().reader.readRecords(result);
              if (e.record.phantom) {
                  //~ console.log("20120816 afteredit.success POST",r);
                  self.getStore().insert(e.row,r.records);
              }else{
                  //~ console.log("20120816 afteredit.success PUT",r);
                  self.getStore().doUpdate(r.records[0]);
              }
              self.getStore().rejectChanges(); /* 
              get rid of the red triangles without saving the record again
              */
              //~ self.getStore().commitChanges(); // get rid of the red triangles
          } else {
              self.getStore().commitChanges(); // get rid of the red triangles
              self.getStore().reload();        // reload our datastore.
          }
          }),
        scope: this,
        failure: Lino.ajax_error_handler(this)
    };
    if (e.record.phantom) {
      req.params.an = 'post'; // SubmitInsert.action_name
      Ext.apply(req,{
        method: 'POST',
        url: '/api' + this.ls_url
      });
    } else {
      req.params.an = 'put'; // SubmitDetail.action_name
      Ext.apply(req,{
        method: 'PUT',
        url: '/api' + this.ls_url + '/' + e.record.id
      });
    }
    //~ console.log('20110406 on_afteredit',req);
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(req);
  },

  afterRender : function() {
    Lino.GridPanel.superclass.afterRender.call(this);
    // this.getView().mainBody.focus();
    // console.log(20100114,this.getView().getRows());
    // if (this.getView().getRows().length > 0) {
    //  this.getView().focusRow(1);
    // }
    //~ this.my_load_mask = new Ext.LoadMask(this.getEl(), {
        //~ msg:'$_("Please wait...")',
        //~ store:this.store});
      
    var tbar = this.getTopToolbar();
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    // tbar.on('change',function() {this.getSelectionModel().selectFirstRow();this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    this.nav = new Ext.KeyNav(this.getEl(),{
      pageUp: function() {tbar.movePrevious(); },
      pageDown: function() {tbar.moveNext(); },
      home: function() {tbar.moveFirst(); },
      end: function() {tbar.moveLast(); },
      scope: this
    });
  },
  after_delete : function() {
    //~ console.log('Lino.GridPanel.after_delete');
    this.refresh();
  },
  add_row_listener : function(fn,scope) {
    this.getSelectionModel().addListener('rowselect',fn,scope);
  },
  postEditValue : function(value, originalValue, r, field){
    value = Lino.GridPanel.superclass.postEditValue.call(this,value,originalValue,r,field);
    //~ console.log('GridPanel.postEdit()',value, originalValue, r, field);
    return value;
  },
  
  set_start_value : function(v) {
      this.start_value = v;
  },
  preEditValue : function(r, field){
      if (this.start_value) {
        var v = this.start_value;
        delete this.start_value;
        this.activeEditor.selectOnFocus = false;
        return v;
      }
      var value = r.data[field];
      return this.autoEncode && Ext.isString(value) ? Ext.util.Format.htmlDecode(value) : value;
  },
  
  on_master_changed : function() {
    //~ if (! this.enabled) return;
    //~ cmp = this;
    //~ console.log('20130911 Lino.GridPanel.on_master_changed()',this.title,this.rendered);
    if (! this.rendered) return; // 20120213
    var todo = function() {
      if (this.disabled) return;
      //~ if (this.disabled) return;
      //~ if (this.enabled) {
          //~ var src = caller.config.url_data + "/" + record.id + ".jpg"
          //~ console.log(20111125, this.containing_window);
          //~ for (k in p) this.getStore().setBaseParam(k,p[k]);
          //~ console.log('Lino.GridPanel.on_master_changed()',this.title,p);
          this.refresh();
          //~ this.set_base_params(this.master_panel.get_master_params());
          //~ this.getStore().load(); 
      //~ }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  },
  load_record_id : function(record_id,after) {
      Lino.run_detail_handler(this,record_id)
  }
  
});
  

//~ Lino.MainPanelMixin = {
  //~ tbar_items : function() {
      //~ return ;
  //~ }
//~ };

//~ Ext.override(Lino.GridPanel,Lino.MainPanelMixin);
//~ Ext.override(Lino.FormPanel,Lino.MainPanelMixin);

//~ Lino.grid_context_menu = function(e) {
  //~ console.log('contextmenu',arguments);
//~ }

Lino.row_context_menu = function(grid,row,col,e) {
  console.log('20130927 rowcontextmenu',grid,row,col,e,grid.store.reader.arrayData.rows[row]);
}

Lino.cell_context_menu = function(grid,row,col,e) {
  //~ console.log('20120531 cellcontextmenu',grid,row,col,e,grid.store.reader.arrayData.rows[row]);
  e.stopEvent();
  //~ grid.getView().focusCell(row,col);
  grid.getSelectionModel().select(row,col);
  //~ console.log(grid.store.getAt(row));
  //~ grid.getView().focusRow(row);
  //~ return;
  if(!grid.cmenu.el){grid.cmenu.render(); }
  //~ if(e.record.data.disabled_fields) {
  
  var da = grid.store.reader.arrayData.rows[row][grid.disabled_actions_index];
  if (da) {
      this.cmenu.cascade(function(item){ 
        //~ console.log(20120531, item.itemId, da[item.itemId]);
        if (da[item.itemId]) item.disable(); else item.enable();
      });
  };
  
  var xy = e.getXY();
  xy[1] -= grid.cmenu.el.getHeight();
  grid.cmenu.showAt(xy);
}


//~ Lino.load_main_menu = function() {
  //~ Ext.Ajax.request({
    //~ waitMsg: 'Loading main menu...',
    //~ method: 'GET',
    //~ url: '/menu',
    //~ success: Lino.on_load_menu,
    //~ failure: Lino.ajax_error_handler
  //~ });
//~ };



//~ Lino.SlavePlugin = function(caller) {
  //~ this.caller = caller;
//~ };

Lino.chooser_handler = function(combo,name) {
  return function(cmp,newValue,oldValue) {
    //~ console.log('Lino.chooser_handler()',cmp,oldValue,newValue);
    combo.setContextValue(name,newValue);
  }
};



Lino.ComboBox = Ext.extend(Ext.form.ComboBox,{
  forceSelection: true,
  triggerAction: 'all',
  minListWidth:230,
  autoSelect: false,
  selectOnFocus: true, // select any existing text in the field immediately on focus.
  submitValue: true,
  displayField: 'text', // 'text', 
  valueField: 'value', // 'value',
  
  //~ initComponent : Ext.form.ComboBox.prototype.initComponent.createSequence(function() {
  initComponent : function(){
      this.contextParams = {};
      //~ Ext.form.ComboBox.initComponent(this);
      Lino.ComboBox.superclass.initComponent.call(this);
  },
  setValue : function(v,record_data){
      /*
      Based on feature request developed in http://extjs.net/forum/showthread.php?t=75751
      */
      /* `record_data` is used to get the text corresponding to this value */
      //~ if(this.name == 'city') 
      //~ console.log('20120203', this.name,'.setValue(', v ,') this=', this,'record_data=',record_data);
      var text = v;
      if(this.valueField){
        if(v == null || v == '') { 
            //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,'no lookup needed, value is empty');
            //~ v = undefined;
            v = '';
            //~ text = '';
        } else if (Ext.isDefined(record_data)) {
          text = record_data[this.name];
          //~ if (this.name == 'birth_country') 
            //~ console.log(this.name,'.setValue',v,'got text ',text,' from record ',record);
        } else {
          // if(this.mode == 'remote' && !Ext.isDefined(this.store.totalLength)){
          if(this.mode == 'remote' && ( this.lastQuery === null || (!Ext.isDefined(this.store.totalLength)))){
              //~ if (this.name == 'birth_country') console.log(this.name,'.setValue',v,'store not yet loaded');
              this.store.on('load', this.setValue.createDelegate(this, arguments), null, {single: true});
              if(this.store.lastOptions === null || this.lastQuery === null){
                  var params;
                  if(this.valueParam){
                      params = {};
                      params[this.valueParam] = v;
                  }else{
                      var q = this.allQuery;
                      this.lastQuery = q;
                      this.store.setBaseParam(this.queryParam, q);
                      params = this.getParams(q);
                  }
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : call load() with params ',params);
                  this.store.load({params: params});
              //~ }else{
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : but store is loading',this.store.lastOptions);
              }
              return;
          //~ }else{
              //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,' : store is loaded, lastQuery is "',this.lastQuery,'"');
          }
          var r = this.findRecord(this.valueField, v);
          if(r){
              text = r.data[this.displayField];
          }else if(this.valueNotFoundText !== undefined){
              text = this.valueNotFoundText;
          }
        }
      }
      this.lastSelectionText = text;
      //~ this.lastSelectionText = v;
      if(this.hiddenField){
          //~ this.hiddenField.originalValue = v;
          this.hiddenField.value = v;
      }
      Ext.form.ComboBox.superclass.setValue.call(this, text);
      this.value = v; // needed for grid.afteredit
  },
  
  getParams : function(q){
    // p = Ext.form.ComboBox.superclass.getParams.call(this, q);
    // causes "Ext.form.ComboBox.superclass.getParams is undefined"
    var p = {};
    //p[this.queryParam] = q;
    if(this.pageSize){
        //~ p.start = 0;
        //~ p.limit = this.pageSize;
        p['start'] = 0;
        p['limit'] = this.pageSize;
    }
    // now my code:
    if(this.contextParams) Ext.apply(p,this.contextParams);
    //~ if(this.contextParams && this.contextValues) {
      //~ for(i = 0; i <= this.contextParams.length; i++)
        //~ p[this.contextParams[i]] = this.contextValues[i];
    //~ }
    return p;
  },
  setContextValue : function(name,value) {
    //~ console.log('setContextValue',this,this.name,':',name,'=',value);
    //~ if (this.contextValues === undefined) {
        //~ this.contextValues = Array(); // this.contextParams.length);
    //~ }
    if (this.contextParams[name] != value) {
      //~ console.log('setContextValue 1',this.contextParams);
      this.contextParams[name] = value;
      this.lastQuery = null;
      //~ console.log('setContextValue 2',this.contextParams);
    }
  }
});

Lino.ChoicesFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'local'
});


Lino.SimpleRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  forceSelection: true,
  constructor: function(config){
      Lino.SimpleRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value' ], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.ComplexRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  constructor: function(config){
      Lino.ComplexRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value','text'], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.RemoteComboFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'remote',
  //~ forceSelection:false,
  minChars: 2, // default 4 is too much
  queryDelay: 300, // default 500 is maybe slow
  queryParam: 'query', 
  //~ typeAhead: true,
  //~ selectOnFocus: true, // select any existing text in the field immediately on focus.
  resizable: true
});

/*
Thanks to Animal for posting the basic idea:
http://www.sencha.com/forum/showthread.php?15842-2.0-SOLVED-Combobox-twintrigger-clear&p=76130&viewfull=1#post76130

*/
Lino.TwinCombo = Ext.extend(Lino.RemoteComboFieldElement,{
    trigger2Class : 'x-form-search-trigger',
    //~ trigger2Class : 'x-tbar-detail',
    initComponent : function() {
        //~ Lino.TwinCombo.superclass.initComponent.call(this);
        Lino.ComboBox.prototype.initComponent.call(this);
        Ext.form.TwinTriggerField.prototype.initComponent.call(this);
    },
    onTrigger2Click : function() {
        //~ console.log('onTrigger2Click',this,arguments);
    }
  });
//~ Lino.TwinCombo.prototype.initComponent = Ext.form.TwinTriggerField.prototype.initComponent;
Lino.TwinCombo.prototype.getTrigger = Ext.form.TwinTriggerField.prototype.getTrigger;
Lino.TwinCombo.prototype.getOuterSize = Ext.form.TwinTriggerField.prototype.getOuterSize;
Lino.TwinCombo.prototype.initTrigger = Ext.form.TwinTriggerField.prototype.initTrigger;
Lino.TwinCombo.prototype.onTrigger1Click = Ext.form.ComboBox.prototype.onTriggerClick;
//~ Lino.TwinCombo.prototype.onTrigger2Click = function() {
    //~ console.log('onTrigger2Click',arguments);
//~ };



Lino.SimpleRemoteComboFieldElement = Ext.extend(Lino.RemoteComboFieldElement,{
  displayField: 'value', 
  valueField: null,
  forceSelection: false
});




Lino.Window = Ext.extend(Ext.Window,{
  //~ layout: "fit", 
  closeAction : 'hide',
  renderTo: 'main_area', 
  constrain: true,
  maximized: true,
  draggable: false,
  width: 700,
  height: 500,
  maximizable: false,
  constructor : function (config) {
    if (config.main_item.params_panel) {
        config.layout = 'border';
        config.main_item.region = 'center';
        config.main_item.params_panel.region = 'north';
        //~ config.main_item.params_panel.autoHeight = false; // 20130924
        config.main_item.params_panel.hidden = config.main_item.params_panel_hidden;
        config.items = [config.main_item.params_panel, config.main_item];
        //~ 20130923b
    } else {
        config.layout = 'fit';
        config.items = config.main_item;
    }
    this.main_item = config.main_item; 
    
    delete config.main_item;
    //~ delete config.params_item;
    
    //~ this.main_item = config.items.get(0);
    this.main_item.containing_window = this;
    
    //~ console.log('20120110 Lino.Window.constructor() 1');
    //~ if (Lino.current_window) { // all windows except the top are closable
    if (this.main_item.hide_window_title) { 
      config.closable = false;
      config.frame = false;
      config.shadow = false;
      //~ config.border = true;
      //~ config.title = undefined;
      //~ config.tools = null;
      delete config.title;
      delete config.tools;
    } else {
      config.title = this.main_item.empty_title;
      config.closable = true;
      config.tools = [ 
        { qtip: 'permalink', handler: Lino.permalink_handler(this), id: "pin" }
      ];
      if (this.main_item.content_type && this.main_item.action_name != 'insert') {
        config.tools = [ {
          handler: Lino.help_text_editor,
          qtip: "Edit help texts for fields on this model.",
          scope: this.main_item,
          id: "gear"
        }].concat(config.tools);
      }
        
    //~ { qtip: '', handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: this.config.qtip, handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: 'Call doLayout() on main Container.', handler: Lino.refresh_handler(this), id: "refresh" },
    //~ if (this.main_item.params_panel) {
        //~ config.tools = config.tools.concat([ 
          //~ { qtip: 'Show/hide parameter panel', handler: this.toggle_params_panel, id: "gear", scope:this } 
        //~ ]);
    //~ }
    //~ if (config.closable !== false) {
      // if undefined, will take default behaviour
      //~ config.tools = config.tools.concat([ 
        //~ { qtip: 'close', handler: this.hide, id: "close", scope:this } 
      //~ ]);
    }
    
    this.main_item.config_containing_window(config);
    
    //~ console.log('20120110 Lino.Window.constructor() 2');
    Lino.Window.superclass.constructor.call(this,config);
    
    //~ console.log('20120110 Lino.Window.constructor() 3');
    
  },
  initComponent : function() {
    this.main_item.init_containing_window(this);
    Lino.Window.superclass.initComponent.call(this);
  
  },
  hide : function() { 
      this.main_item.do_when_clean(false,function() { 
        Lino.close_window(); });
  },
  hide_really : function() { 
    Lino.Window.superclass.hide.call(this);
  },
  onRender : function(ct, position){
    //~ console.log('20120110 Lino.Window.onRender() 1');
    Lino.Window.superclass.onRender.call(this, ct, position);
    var main_area = Ext.getCmp('main_area')
    //~ console.log('20120110 Lino.Window.onRender() 2');
  
    this.on('show', function(win) {
        //~ console.log('20120110 Lino.Window.on show 1');
        main_area.on('resize', win.onWindowResize, win);
    });
    this.on('hide', function(win) {
        main_area.un('resize', win.onWindowResize, win);
    });
    //~ console.log('20120110 Lino.Window.onRender() 3');
  }
});


Lino.unused_ParamWindow = Ext.extend(Lino.Window,{
  //~ layout: "border", 
  constructor : function (config) {
    Lino.ParamWindow.superclass.constructor.call(this,config);
    this.main_item = config.items; // `items` must be a single component
    config.layout = 'border';
    this.main_item.region = 'center';
    config.params.region = 'north';
    config.items = [config.params, config.items];
    //~ delete config.params;
  }
});




(function(){
    var ns = Ext.ns('Ext.ux.plugins');

    /**
     * @class Ext.ux.plugins.DefaultButton
     * @extends Object
     *
     * Plugin for Button that will click() the button if the user presses ENTER while
     * a component in the button's form has focus.
     *
     * @author Stephen Friedrich
     * @date 09-DEC-2009
     * @version 0.1
     *
     */
    ns.DefaultButton =  Ext.extend(Object, {
        init: function(button) {
            button.on('afterRender', setupKeyListener, button);
        }
    });

    function setupKeyListener() {
        var formPanel = this.findParentByType('form');
        new Ext.KeyMap(formPanel.el, {
            key: Ext.EventObject.ENTER,
            shift: false,
            alt: false,
            fn: function(keyCode, e){
                if(e.target.type === 'textarea' && !e.ctrlKey) {
                    return true;
                }

                this.el.select('button').item(0).dom.click();
                return false;
            },
            scope: this
        });
    }

    Ext.ComponentMgr.registerPlugin('defaultButton', ns.DefaultButton);

})(); 

Ext.override(Ext.form.BasicForm,{
    my_loadRecord : function(values){
    //~ loadRecord : function(record){
        /* Same as ExtJS's loadRecord() (setValues()), except that we 
        forward also the record to field.setValue() so that Lino.Combobox 
        can use it. 
        */
        //~ console.log('20120918 my_loadRecord',values)
        if(Ext.isArray(values)){ 
            for(var i = 0, len = values.length; i < len; i++){
                var v = values[i];
                var f = this.findField(v.id);
                if(f){
                    f.setValue(v.value,values);
                    if(this.trackResetOnLoad){
                        f.originalValue = f.getValue();
                    }
                }
            }
        }else{ 
            var field, id;
            for(id in values){
                if(!Ext.isFunction(values[id]) && (field = this.findField(id))){
                    field.setValue(values[id],values);
                    if(this.trackResetOnLoad){
                        field.originalValue = field.getValue();
                        //~ if (field.hiddenField) {
                          //~ field.hiddenField.originalValue = field.hiddenField.value;
                        //~ }
                    }
                }
            }
        }
        return this;
    }
});




function initializeFooBarDropZone(cmp) {
    //~ console.log('initializeFooBarDropZone',cmp);
    cmp.dropTarget = new Ext.dd.DropTarget(cmp.bwrap, {
      //~ ddGroup     : 'gridDDGroup',
      notifyEnter : function(ddSource, e, data) {
        console.log('notifyEnter',ddSource,e,data);
        //Add some flare to invite drop.
        cmp.body.stopFx();
        cmp.body.highlight();
      },
      notifyDrop  : function(ddSource, e, data){
        console.log('notifyDrop',ddSource,e,data);
        // Reference the record (single selection) for readability
        //~ var selectedRecord = ddSource.dragData.selections[0];


        // Load the record into the form
        //~ formPanel.getForm().my_loadRecord(selectedRecord);


        // Delete record from the grid.  not really required.
        //~ ddSource.grid.store.remove(selectedRecord);

        return(true);
      }
    })
}



Lino.show_mti_child = function(fieldname,detail_handler) {
  //~ console.log('show_mti_child',this);
  //~ console.log('show_mti_child',panel.find("main_area"));
  rec = Lino.current_window.main_item.get_current_record();
  //~ rec = panel.get_current_record();
  if (rec) {
    //~ console.log('show_mti_child',Lino.current_window,rec);
    if (rec.phantom) {
      Lino.notify('Not allowed on phantom record.');
    }else if (rec.data[fieldname]) {
      //~ console.log('show_mti_child',rec.id);
      //~ detail_handler(Lino.current_window.main_item,{},{record_id:rec.id});
      detail_handler.run(null,{record_id:rec.id});
      //~ window.open(urlroot + '/' + rec.id);
      //~ document.location = urlroot + '/' + rec.id;
      //~ window.open(urlroot + '/' + rec.id,'_blank');
    } else {
      Lino.alert("Cannot show MTI child if checkbox is off.");
    }
  } else {
    Lino.notify('No current record.');
  }
};






/*
Mappings towards lino.modlib.cal.models.PanelCalendars
*/
// Sset SS = Ssite.modules.cal.PanelCalendars.get_handle(Sui).store
Ext.ensible.cal.CalendarMappings = {
    CalendarId:   {name:'ID',       mapping: 'id', type: 'int'},
    Title:        {name:'CalTitle', mapping: 'babel_name', type: 'string'},
    Description:  {name:'Desc',     mapping: 'description', type: 'string'},
    ColorId:      {name:'Color',    mapping: 'color', type: 'int'},
    IsHidden:     {name:'Hidden',   mapping: 'is_hidden', type: 'boolean'},    
};
Ext.ensible.cal.CalendarRecord.reconfigure();  


/*
Mappings towards lino.modlib.cal.models.PanelEvents 
*/
// Sset SS = Ssite.modules.cal.PanelEvents.get_handle(Sui).store
Ext.ensible.cal.EventMappings = {
    EventId:     {name: 'ID',        mapping: 'id', type:'int'},
    CalendarId:  {name: 'CalID',     mapping: 'calendarHidden', type: 'int'},
    Title:       {name: 'EvtTitle',  mapping: 'summary'},
    StartDate:   {name: 'StartDt',   mapping: 'start_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s" },
    EndDate:     {name: 'EndDt',     mapping: 'end_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s"},
    RRule:       {name: 'RecurRule', mapping: 'rsetHidden'},
    Location:    {name: 'Location',  mapping: 'placeHidden'},
    Notes:       {name: 'Desc',      mapping: 'description'},
    Url:         {name: 'LinkUrl',   mapping: 'url'},
    IsAllDay:    {name: 'AllDay',    mapping: 'all_day', type: 'boolean'},
    Reminder:    {name: 'Reminder',  mapping: 'reminder'}
    
};
Ext.ensible.cal.EventRecord.reconfigure();


//~ Lino.on_eventclick = 
    
Lino.on_editdetails = 

Lino.format_time = function(dt) {
    return dt.getHours() + ':' + dt.getMinutes();
}
    
Lino.on_eventdelete = function() {
  //~ console.log("Lino.on_eventdelete",arguments);
};

Lino.on_eventadd  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventadd ",arguments);
  return false;
}
    
Lino.on_eventresize  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventresize ",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    
Lino.on_eventupdate  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventupdate",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    

//~ Lino.eventStore = new Ext.ensible.cal.EventStore({ 
//~ Lino.eventStore = new Ext.data.ArrayStore({ 
Lino.unused_eventStore = new Ext.data.JsonStore({ 
  listeners: { exception: Lino.on_store_exception }
  ,url: '/restful/cal/PanelEvents'
  ,restful : true
  ,proxy: new Ext.data.HttpProxy({ 
      //~ url: '/restful/cal/PanelEvents', 
      url: '/restful/cal/PanelEvents', 
      disableCaching: false // no need for cache busting when loading via Ajax
      //~ disableCaching:true,
  })
  ,fields: Ext.ensible.cal.EventRecord.prototype.fields.getRange()
  ,totalProperty: "count"
  ,root: "rows"
  ,idProperty: Ext.ensible.cal.EventMappings.EventId.mapping
  ,writer : new Ext.data.JsonWriter({
    writeAllFields: false
  })
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
      if (!options) options = {};
      if (!options.params) options.params = {};
      //~ options.params.$ext_requests.URL_PARAM_TEAM_VIEW = Lino.calendar_app.team_view_button.pressed;
      
      var view = this.cal_panel.getActiveView();
      var bounds = view.getViewBounds();
      //~ var p = {sd:'05.02.2012',ed:'11.02.2012'};
      //~ var p = {};
      options.params[view.dateParamStart] = bounds.start.format(view.dateParamFormat);
      options.params[view.dateParamEnd] = bounds.end.format(view.dateParamFormat);
      Lino.insert_subst_user(options.params);
      //~ Ext.apply(options.params,p)
      //~ console.log('20120710 eventStore.load()',this.baseParams,options);
    
    return Ext.data.JsonStore.prototype.load.call(this,options);
  }
});

//~ Lino.eventStore.on('load', function() {
//~ });


    //~ Lino.subst_user = id;


//~ Lino.calendarStore = new Ext.data.ArrayStore({ 
Lino.unused_calendarStore = new Ext.data.JsonStore({ 
      listeners: { exception: Lino.on_store_exception }
      ,restful : true
      ,proxy: new Ext.data.HttpProxy({ 
          //~ url: '/restful/cal/PanelCalendars?fmt=json', 
          url: '/restful/cal/PanelCalendars?fmt=%7B%7Bext_requests.URL_FORMAT_JSON%7D%7D', 
          disableCaching: false // no need for cache busting when loading via Ajax
          //~ restful : true
          //~ method: "GET"
      })
      //~ ,autoLoad: true
      //~ ,remoteSort: true
      //~ ,baseParams: bp
      ,totalProperty: "count"
      ,root: "rows"
      ,fields: Ext.ensible.cal.CalendarRecord.prototype.fields.getRange()
      ,idProperty: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
      //~ ,idIndex: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
    });


Lino.CalendarCfg = {
    dateParamFormat: 'd.m.Y',
    dateParamStart:'sd',
    dateParamEnd:'ed'
};
//~ 20120704 Lino.CalendarPanel = Ext.extend(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
//~ Lino.CalendarPanel = Ext.extend(Lino.CalendarPanel,{
Ext.override(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
Ext.override(Ext.ensible.cal.CalendarPanel,{
  //~ empty_title : "\$ui.get_actor('cal.Panel').report.label",
  empty_title : "Calendar"
  ,activeItem: 1 // 0: day, 1: week
  ,ls_url: '/cal/CalendarPanel'
  //~ ,disableCaching:true
  //~ ,eventStore: Lino.eventStore
  //~ ,calendarStore: Lino.calendarStore
  //~ ,initComponent : function(){
    //~ Ext.ensible.cal.CalendarPanel.superclass.initComponent.call(this);
    //~ this.eventStore.on('load',function(){
      //~ console.log("20130808",Lino.eventStore);
      //~ if (this.eventStore.reader.jsonData) {
        //~ console.log("20130808 b",this.eventStore.reader.jsonData.title);
        //~ this.set_window_title(this.eventStore.reader.jsonData.title);
      //~ }
    //~ },this);
  //~ }
  ,listeners: { 
    editdetails: function(cp,rec,el) {
      //~ console.log("Lino.on_editdetails",arguments);
      if (rec.data.ID)
          Lino.cal.PanelEvents.detail.run(null,{
              record_id:rec.data.ID,
              base_params:this.app_instance.event_store.baseParams});
      return false;
    }
    ,eventclick: function(cp,rec,el) {
      //~ console.log("Lino.on_eventclick",arguments);
      //~ Lino.cal.Events.detail_action.run({record_id:rec.data.ID});
      Lino.cal.PanelEvents.detail.run(null,{
            record_id:rec.data.ID,
                base_params:this.app_instance.event_store.baseParams});
      return false;
    }
    //~ ,eventadd: Lino.on_eventadd
    //~ ,eventdelete: Lino.on_eventdelete
    //~ ,eventresize: Lino.on_eventresize
    ,afterrender : function(config) {
      //~ console.log("20120704 afterrender");
      this.app_instance.calendar_store.load();
      //~ console.log("20120704 afterrender calls eventStore.load()",p);
      this.app_instance.event_store.cal_panel = this;
      //~ Lino.eventStore.load({params:p});
      //~ 20130905 removed: this.app_instance.event_store.load();
      //~ Lino.CalendarPanel.superclass.constructor.call(this, config);
      //~ console.log(20120118, config,this);
    }
    }
  ,enableEditDetails: false
  //~ ,monthViewCfg: Lino.CalendarCfg
  //~ ,weekViewCfg: Lino.CalendarCfg
  //~ ,multiDayViewCfg: Lino.CalendarCfg
  //~ ,multiWeekViewCfg: Lino.CalendarCfg
  //~ ,dayViewCfg: Lino.CalendarCfg
  //~ ,initComponent : function() {
    //~ // this.on('eventadd',Lino.on_eventadd);
    //~ Lino.CalendarPanel.superclass.initComponent.call(this);
  //~ }
});




Lino.CalendarAppPanel = Ext.extend(Ext.Panel,Lino.MainPanel);
Lino.CalendarAppPanel = Ext.extend(Lino.CalendarAppPanel,Lino.PanelMixin);
Lino.CalendarAppPanel = Ext.extend(Lino.CalendarAppPanel,{
  app_instance : null
  //~ empty_title : "\$ui.get_actor('cal.Panel').report.label",
  ,empty_title : "Calendar"
  ,ls_url: '/cal/CalendarPanel'
  ,set_status : function(status,rp) { 
      this.requesting_panel = Ext.getCmp(rp);
      //~ console.log('20120918 CalendarAppPanel.set_status()',status,rp,this.requesting_panel);
      this.clear_base_params();
      if (status == undefined) status = {};
      //~ if (status.param_values) 
      //~ this.set_field_values(status.field_values);
      if (status.base_params) this.set_base_params(status.base_params);
      this.refresh();
      }
  ,refresh : function() {
      //~ this.app_instance.event_store.reload(); 20130905
      this.app_instance.event_store.load();
  }
  ,layout: 'fit'
  ,get_base_params : function() {
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
  }
  ,set_base_params : function(p) {
    this.base_params = Ext.apply(this.app_instance.event_store.baseParams,p);
    this.app_instance.event_store.baseParams = this.base_params;
  }
  ,clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  }
  ,set_base_param : function(k,v) {
      if (!this.base_params) this.base_params = {};
      this.base_params[k] = v;
  }
});

Lino.CalendarApp = function() { return {
  team_view_button : null 
  ,get_main_panel : function() {
      var cap = null;
      this.event_store = new Ext.data.JsonStore({ 
          listeners: { exception: Lino.on_store_exception }
          //~ ,url: '/restful/cal/PanelEvents'
          ,url: '//restful/cal/PanelEvents'
          ,restful : true
          ,proxy: new Ext.data.HttpProxy({ 
              //~ url: '/restful/cal/PanelEvents', 
              url: '//restful/cal/PanelEvents', 
              disableCaching: false // no need for cache busting when loading via Ajax
              //~ disableCaching:true,
          })
          ,fields: Ext.ensible.cal.EventRecord.prototype.fields.getRange()
          ,totalProperty: "count"
          ,root: "rows"
          ,idProperty: Ext.ensible.cal.EventMappings.EventId.mapping
          ,writer : new Ext.data.JsonWriter({
            writeAllFields: false
          })
          ,load: function(options) {
            //~ foo.bar = baz; // 20120213
              if (!options) options = {};
              if (!options.params) options.params = {};
              //~ options.params.$ext_requests.URL_PARAM_TEAM_VIEW = Lino.calendar_app.team_view_button.pressed;
              
              var view = this.cal_panel.getActiveView();
              var bounds = view.getViewBounds();
              //~ var p = {sd:'05.02.2012',ed:'11.02.2012'};
              //~ var p = {};
              options.params[view.dateParamStart] = bounds.start.format(view.dateParamFormat);
              options.params[view.dateParamEnd] = bounds.end.format(view.dateParamFormat);
              Lino.insert_subst_user(options.params);
              //~ this.cal_panel.base_params.su.toString();
              //~ if (this.cal_panel) {
                  Ext.apply(options.params,this.cal_panel.base_params);
              //~ }
              //~ Ext.apply(options.params,p)
              //~ console.log('20130905 eventStore.load()',this.cal_panel,this.baseParams,options.params);
            
            return Ext.data.JsonStore.prototype.load.call(this,options);
          }
      });

      //~ Lino.calendarStore
      this.calendar_store = new Ext.data.JsonStore({ 
          listeners: { exception: Lino.on_store_exception }
          ,restful : true
          ,proxy: new Ext.data.HttpProxy({ 
              //~ url: '/restful/cal/PanelCalendars?fmt=json', 
              url: '/restful/cal/PanelCalendars?fmt=%7B%7Bext_requests.URL_FORMAT_JSON%7D%7D', 
              disableCaching: false // no need for cache busting when loading via Ajax
              //~ restful : true
              //~ method: "GET"
          })
          //~ ,autoLoad: true
          //~ ,remoteSort: true
          //~ ,baseParams: bp
          ,totalProperty: "count"
          ,root: "rows"
          ,fields: Ext.ensible.cal.CalendarRecord.prototype.fields.getRange()
          ,idProperty: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
          //~ ,idIndex: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
      });
      
      cap = new Lino.CalendarAppPanel({ 
          app_instance: this, 
          items : 
        //~ [{
          //~ id: 'app-header',
          //~ region: 'north',
          //~ height: 35,
          //~ border: false,
          // contentEl: 'app-header-content'
        //~ },
      {
          id: 'app-center',
          title: '...', // will be updated to the current view's date range
          region: 'center',
          layout: 'border',
          listeners: {
              'afterrender': function(){
                  Ext.getCmp('app-center').header.addClass('app-center-header');
              }
          },
          items: [{
              id:'app-west',
              region: 'west',
              width: 176,
              border: false,
              items: [{
                  xtype: 'datepicker',
                  id: 'app-nav-picker',
                  cls: 'ext-cal-nav-picker',
                  listeners: {
                      'select': {
                          fn: function(dp, dt){
                              //~ Lino.calendarPanel.setStartDate(dt);
                              this.setStartDate(dt);
                          },
                          scope: this
                      }
                  }
              //~ },{ 
                //~ layout:'fit',
                //~ items: [
                  //~ new Ext.form.Checkbox({
                    //~ boxLabel:"$_('Team view')",
                    //~ hideLabel:true
                    //~ listeners: { click: }
                  //~ })
                //~ ]
              },{ 
                layout:'form',
                items: [
                  this.team_view_button = new Ext.Button({
                    text:"Team view",
                    enableToggle:true,
                    pressed:false,
                    toggleHandler: function(btn,state) { 
                      //~ console.log('20120716 teamView.toggle()');
                      this.event_store.setBaseParam('tv',state);
                      this.event_store.load();
                      //~ Lino.eventStore.load({params:{$ext_requests.URL_PARAM_TEAM_VIEW:state}});
                      //~ console.log("team view",state);
                    }
                  })
                ]
              },{
                  xtype: 'extensible.calendarlist',
                  store: this.calendar_store,
                  border: false,
                  width: 175
              }]
          },{
              xtype: 'extensible.calendarpanel', // Ext.ensible.cal.CalendarPanel
              eventStore: this.event_store,
              app_instance: this,
              calendarStore: this.calendar_store,
              border: false,
              id:'app-calendar',
              region: 'center',
              //~ activeItem: 3, // month view
              
              // Any generic view options that should be applied to all sub views:
              viewConfig: {
                  // Lino.CalendarCfg
                  dateParamFormat: 'd.m.Y',
                  dateParamStart:'sd',
                  dateParamEnd:'ed',
                
                  //enableFx: false,
                  //ddIncrement: 10, //only applies to DayView and subclasses, but convenient to put it here
                  viewStartHour: 8,
                  viewEndHour: 18
                  //minEventDisplayMinutes: 15
              },
              
              // View options specific to a certain view (if the same options exist in viewConfig
              // they will be overridden by the view-specific config):
              monthViewCfg: {
                  showHeader: true,
                  showWeekLinks: true,
                  showWeekNumbers: true,
                  eventBodyMarkup: ['{Title}',
                    //~ '<tpl if="url">',
                        //~ '<a href="{url}">XX</a>',
                    //~ '</tpl>',
                    '<tpl if="_isReminder">',
                        '<i class="ext-cal-ic ext-cal-ic-rem">&#160;</i>',
                    '</tpl>',
                    '<tpl if="_isRecurring">',
                        '<i class="ext-cal-ic ext-cal-ic-rcr">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanLeft">',
                        '<i class="ext-cal-spl">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanRight">',
                        '<i class="ext-cal-spr">&#160;</i>',
                    '</tpl>'
                ].join('')
              },
              
              multiWeekViewCfg: {
                  //weekCount: 3
              },
              
              // Some optional CalendarPanel configs to experiment with:
              //readOnly: true,
              //showDayView: false,
              //showMultiDayView: true,
              //showWeekView: false,
              //showMultiWeekView: false,
              //showMonthView: false,
              //showNavBar: false,
              //showTodayText: false,
              //showTime: false,
              //editModal: true,
              //enableEditDetails: false,
              //title: 'My Calendar', // the header of the calendar, could be a subtitle for the app
              
              // Once this component inits it will set a reference to itself as an application
              // member property for easy reference in other functions within App.
              //~ initComponent: function() {
                  //~ Lino.calendarPanel = this;
                  //~ this.constructor.prototype.initComponent.apply(this, arguments);
              //~ },
              
              listeners: {
                  //~ 'eventclick': {
                      //~ fn: function(vw, rec, el){
                          //~ this.clearMsg();
                      //~ },
                      //~ scope: this
                  //~ },
                  'eventover': function(vw, rec, el){
                      //console.log('Entered evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]', view='+ vw.id +', el='+el.id);
                  },
                  'eventout': function(vw, rec, el){
                      //console.log('Leaving evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]+', view='+ vw.id +', el='+el.id);
                  },
                  'eventadd': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was added');
                      },
                      scope: this
                  },
                  'eventupdate': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(cp, rec){
                          //this.eventStore.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'eventcancel': {
                      fn: function(cp, rec){
                          // edit canceled
                      },
                      scope: this
                  },
                  'viewchange': {
                      fn: function(p, vw, dateInfo){
                          if(this.editWin){
                              this.editWin.hide();
                          };
                          if(dateInfo !== null){
                              // will be null when switching to the event edit form so ignore
                              Ext.getCmp('app-nav-picker').setValue(dateInfo.activeDate);
                              this.updateTitle(dateInfo.viewStart, dateInfo.viewEnd);
                          }
                          
                      },
                      scope: this
                  },
                  'dayclick': {
                      fn: function(vw, dt, ad, el){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'rangeselect': {
                      fn: function(vw, dates, onComplete){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'eventmove': {
                      fn: function(vw, rec){
                          rec.commit();
                          var time = rec.data[Ext.ensible.cal.EventMappings.IsAllDay.name] ? '' : ' \\a\\t g:i a';
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was moved to '+
                              rec.data[Ext.ensible.cal.EventMappings.StartDate.name].format('F jS'+time));
                      },
                      scope: this
                  },
                  'eventresize': {
                      fn: function(vw, rec){
                          rec.commit();
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(win, rec){
                          this.event_store.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'initdrag': {
                      fn: function(vw){
                          if(this.editWin && this.editWin.isVisible()){
                              this.editWin.hide();
                          }
                      },
                      scope: this
                  }
              }
          }]
        }
        //~ ]
        
      });
      
      this.event_store.on('load',function(){
        //~ console.log("20130905 on event_store load",this.event_store.reader.jsonData);
        if (this.event_store.reader.jsonData) {
          //~ console.log("20130808 b",this.event_store.reader.jsonData.title);
          //~ console.log("20130808 c",this);
          cap.set_window_title(this.event_store.reader.jsonData.title);
        }
      },this);
      
      //~ cap.app_instance = this;
      return cap;
      
  }
  ,updateTitle: function(startDt, endDt){
      var p = Ext.getCmp('app-center');
      
      if(startDt.clearTime().getTime() == endDt.clearTime().getTime()){
          p.setTitle(startDt.format('F j, Y'));
      }
      else if(startDt.getFullYear() == endDt.getFullYear()){
          if(startDt.getMonth() == endDt.getMonth()){
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('j, Y'));
          }
          else{
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('F j, Y'));
          }
      }
      else{
          p.setTitle(startDt.format('F j, Y') + ' - ' + endDt.format('F j, Y'));
      }
  }
  // This is an application-specific way to communicate CalendarPanel event messages back to the user.
  // This could be replaced with a function to do "toast" style messages, growl messages, etc. This will
  // vary based on application requirements, which is why it's not baked into the CalendarPanel.
  ,showMsg: function(msg){
      Lino.notify(msg);
      //~ Ext.fly('app-msg').update(msg).removeClass('x-hidden');
  }
  
  ,clearMsg: function(){
      Lino.notify('');
      //~ Ext.fly('app-msg').update('').addClass('x-hidden');
  }
}
};




/*
captureEvents utility by Aaron Conran
<http://www.sencha.com/learn/grid-faq/>

Ext.onReady(function(){
    var grid = new Ext.grid.GridPanel({
        ... 
    });
    captureEvents(grid);
});
*/
function captureEvents(observable) {
    Ext.util.Observable.capture(
        observable,
        function(eventName) {
            console.info(eventName);
        },
        this
    );		
}
 






Lino.main_menu = [ { "menu": { "items": [ { "text": "Persons", "handler": function() {Lino.contacts.Persons.grid.run(null)} }, { "text": "Companies", "handler": function() {Lino.contacts.Companies.grid.run(null)} }, { "text": "Partners", "handler": function() {Lino.contacts.Partners.grid.run(null)} }, { "text": "Households", "handler": function() {Lino.households.Households.grid.run(null)} } ] }, "text": "Contacts" }, { "menu": { "items": [ { "text": "Products", "handler": function() {Lino.products.Products.grid.run(null)} }, { "text": "Product Categories", "handler": function() {Lino.products.ProductCats.grid.run(null)} } ] }, "text": "Products" }, { "menu": { "items": [ { "text": "Invoices to create", "listeners": { "render": Lino.quicktip_renderer("Foo","Table of all partners who should receive an invoice.") }, "handler": function() {Lino.sales.InvoicesToCreate.grid.run(null)} } ] }, "text": "Sales" }, { "menu": { "items": [ { "text": "My Blog Entries", "handler": function() {Lino.blogs.MyEntries.grid.run(null)} } ] }, "text": "Blog" }, { "menu": { "items": [ { "text": "My Projects", "handler": function() {Lino.tickets.MyProjects.grid.run(null)} }, { "text": "My Tickets", "handler": function() {Lino.tickets.MyOpenTickets.grid.run(null)} }, { "text": "My Tickets", "handler": function() {Lino.tickets.MyTickets.grid.run(null)} }, { "text": "My Sessions", "handler": function() {Lino.tickets.MySessions.grid.run(null)} }, { "text": "My sessions by date", "handler": function() {Lino.tickets.MySessionsByDate.grid.run(null)} } ] }, "text": "Tickets" }, { "menu": { "items": [ { "text": "Calendar", "iconCls": "x-tbar-calendar", "handler": function() {Lino.cal.CalendarPanel.grid.run(null)}, "listeners": { "render": Lino.quicktip_renderer("Foo","Displays your events in a classical \"calendar view\", \nwith the possibility to switch between daily, weekly, monthly view.") } }, { "text": "My events", "listeners": { "render": Lino.quicktip_renderer("Foo","Table of all my calendar events.") }, "handler": function() {Lino.cal.MyEvents.grid.run(null)} }, { "text": "My tasks", "listeners": { "render": Lino.quicktip_renderer("Foo","Table of all my tasks.") }, "handler": function() {Lino.cal.MyTasks.grid.run(null)} }, { "text": "My guests", "handler": function() {Lino.cal.MyGuests.grid.run(null)} }, { "text": "My presences", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows all my presences in calendar events, independently of their state.") }, "handler": function() {Lino.cal.MyPresences.grid.run(null)} } ] }, "text": "Calendar" }, { "menu": { "items": [ { "text": "My Outbox", "handler": function() {Lino.outbox.MyOutbox.grid.run(null)} } ] }, "text": "Office" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "My Text Field Templates", "handler": function() {Lino.system.MyTextFieldTemplates.grid.run(null)} }, { "text": "Upload Types", "handler": function() {Lino.uploads.UploadTypes.grid.run(null)} } ] }, "text": "Office" }, { "menu": { "items": [ { "text": "Site Parameters", "iconCls": "x-tbar-application_form", "handler": function() {Lino.system.SiteConfigs.detail.run(null,{ "record_id": 1 })} }, { "text": "Users", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows the list of all users on this site.") }, "handler": function() {Lino.users.Users.grid.run(null)} }, { "text": "Teams", "handler": function() {Lino.users.Teams.grid.run(null)} }, { "text": "content types", "handler": function() {Lino.system.ContentTypes.grid.run(null)} }, { "text": "Help Texts", "handler": function() {Lino.system.HelpTexts.grid.run(null)} } ] }, "text": "System" }, { "menu": { "items": [ { "text": "Countries", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    A country is a geographic entity considered a \"nation\".\n    ") }, "handler": function() {Lino.countries.Countries.grid.run(null)} }, { "text": "Places", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    The table of known geographical places.\n    A geographical place can be a city, a town, a suburb, \n    a province, a lake... any named geographic entity,\n    except for countries because these have their own table.\n    ") }, "handler": function() {Lino.countries.Cities.grid.run(null)} }, { "text": "company types", "handler": function() {Lino.contacts.CompanyTypes.grid.run(null)} }, { "text": "Functions", "handler": function() {Lino.contacts.RoleTypes.grid.run(null)} } ] }, "text": "Contacts" }, { "menu": { "items": [ { "text": "Property Groups", "handler": function() {Lino.properties.PropGroups.grid.run(null)} }, { "text": "Property Types", "handler": function() {Lino.properties.PropTypes.grid.run(null)} } ] }, "text": "Properties" }, { "menu": { "items": [ { "text": "Household Roles", "handler": function() {Lino.households.Roles.grid.run(null)} }, { "text": "Household Types", "handler": function() {Lino.households.Types.grid.run(null)} } ] }, "text": "Households" }, { "menu": { "items": [ { "text": "Account Charts", "handler": function() {Lino.accounts.Charts.grid.run(null)} }, { "text": "Account Groups", "handler": function() {Lino.accounts.Groups.grid.run(null)} }, { "text": "Accounts", "handler": function() {Lino.accounts.Accounts.grid.run(null)} }, { "text": "Journals", "handler": function() {Lino.ledger.Journals.grid.run(null)} } ] }, "text": "Accounting" }, { "menu": { "items": [ { "text": "Invoicing Modes", "handler": function() {Lino.sales.InvoicingModes.grid.run(null)} }, { "text": "Shipping Modes", "handler": function() {Lino.sales.ShippingModes.grid.run(null)} }, { "text": "Payment Terms", "handler": function() {Lino.sales.PaymentTerms.grid.run(null)} } ] }, "text": "Sales" }, { "menu": { "items": [ { "text": "Blog Entry Types", "handler": function() {Lino.blogs.EntryTypes.grid.run(null)} } ] }, "text": "Blog" }, { "menu": { "items": [ { "text": "Project Types", "handler": function() {Lino.tickets.ProjectTypes.grid.run(null)} }, { "text": "Session Types", "handler": function() {Lino.tickets.SessionTypes.grid.run(null)} } ] }, "text": "Tickets" }, { "menu": { "items": [ { "text": "Rooms", "listeners": { "render": Lino.quicktip_renderer("Foo","List of rooms where calendar events can happen.") }, "handler": function() {Lino.cal.Rooms.grid.run(null)} }, { "text": "Priorities", "listeners": { "render": Lino.quicktip_renderer("Foo","List of possible priorities of calendar events.") }, "handler": function() {Lino.cal.Priorities.grid.run(null)} }, { "text": "Guest Roles", "listeners": { "render": Lino.quicktip_renderer("Foo","The role of a guest expresses what the \n    partner is going to do there.") }, "handler": function() {Lino.cal.GuestRoles.grid.run(null)} }, { "text": "Calendars", "listeners": { "render": Lino.quicktip_renderer("Foo","The list of calendars defined on this system.\n    A calendar is a list of events which have certain things in common,\n    especially they are displayed in the same colour in the calendar panel") }, "handler": function() {Lino.cal.Calendars.grid.run(null)} } ] }, "text": "Calendar" } ] }, "text": "Configure" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "Text Field Templates", "handler": function() {Lino.system.TextFieldTemplates.grid.run(null)} }, { "text": "Uploads", "handler": function() {Lino.uploads.Uploads.grid.run(null)} }, { "text": "Outgoing Mails", "handler": function() {Lino.outbox.Mails.grid.run(null)} }, { "text": "Attachments", "handler": function() {Lino.outbox.Attachments.grid.run(null)} } ] }, "text": "Office" }, { "menu": { "items": [ { "text": "Authorities", "handler": function() {Lino.users.Authorities.grid.run(null)} }, { "text": "User Groups", "handler": function() {Lino.lino.UserGroups.grid.run(null)} }, { "text": "User Levels", "handler": function() {Lino.lino.UserLevels.grid.run(null)} }, { "text": "User Profiles", "handler": function() {Lino.lino.UserProfiles.grid.run(null)} } ] }, "text": "System" }, { "menu": { "items": [ { "text": "Contact Persons", "handler": function() {Lino.contacts.Roles.grid.run(null)} } ] }, "text": "Contacts" }, { "menu": { "items": [ { "text": "Household Members", "handler": function() {Lino.households.Members.grid.run(null)} } ] }, "text": "Households" }, { "menu": { "items": [ { "text": "Invoices", "handler": function() {Lino.ledger.Invoices.grid.run(null)} }, { "text": "Vouchers", "handler": function() {Lino.ledger.Vouchers.grid.run(null)} }, { "text": "VoucherTypes", "handler": function() {Lino.ledger.VoucherTypes.grid.run(null)} }, { "text": "Movements", "handler": function() {Lino.ledger.Movements.grid.run(null)} }, { "text": "Fiscal Years", "handler": function() {Lino.ledger.FiscalYears.grid.run(null)} } ] }, "text": "Accounting" }, { "menu": { "items": [ { "text": "VatRegimes", "listeners": { "render": Lino.quicktip_renderer("Foo","Determines how the VAT is being handled, i.e. whether and how it is to be paid.") }, "handler": function() {Lino.vat.VatRegimes.grid.run(null)} }, { "text": "TradeTypes", "listeners": { "render": Lino.quicktip_renderer("Foo","The type of trade: usually either `sales` or `purchases`.") }, "handler": function() {Lino.vat.TradeTypes.grid.run(null)} }, { "text": "VatClasses", "handler": function() {Lino.vat.VatClasses.grid.run(null)} } ] }, "text": "VAT" }, { "menu": { "items": [ { "text": "Blog Entries", "handler": function() {Lino.blogs.Entries.grid.run(null)} } ] }, "text": "Blog" }, { "menu": { "items": [ { "text": "Projects", "handler": function() {Lino.tickets.Projects.grid.run(null)} }, { "text": "Tickets", "handler": function() {Lino.tickets.Tickets.grid.run(null)} }, { "text": "Sessions", "handler": function() {Lino.tickets.Sessions.grid.run(null)} }, { "text": "Milestones", "handler": function() {Lino.tickets.Milestones.grid.run(null)} } ] }, "text": "Tickets" }, { "menu": { "items": [ { "text": "Tasks", "listeners": { "render": Lino.quicktip_renderer("Foo","A calendar task is something you need to do.\n    ") }, "handler": function() {Lino.cal.Tasks.grid.run(null)} }, { "text": "Guests", "listeners": { "render": Lino.quicktip_renderer("Foo","A guest is a partner invited to an event.\n    ") }, "handler": function() {Lino.cal.Guests.grid.run(null)} }, { "text": "Subscriptions", "handler": function() {Lino.cal.Subscriptions.grid.run(null)} }, { "text": "Event states", "listeners": { "render": Lino.quicktip_renderer("Foo","The possible states of a calendar event.") }, "handler": function() {Lino.cal.EventStates.grid.run(null)} }, { "text": "Guest states", "handler": function() {Lino.cal.GuestStates.grid.run(null)} }, { "text": "Task states", "handler": function() {Lino.cal.TaskStates.grid.run(null)} } ] }, "text": "Calendar" } ] }, "text": "Explorer" }, { "menu": { "items": [ { "text": "About", "listeners": { "render": Lino.quicktip_renderer("Foo","Show information about this site.") }, "handler": function() {Lino.about.About.show.run(null,{ "record_id": -99998 })} } ] }, "text": "Site" }, { "text": "Home", "handler": function() {Lino.close_all_windows()} } ];
Ext.namespace('Lino.system.SiteConfigs')
Ext.namespace('Lino.system.ContentTypes')
Ext.namespace('Lino.system.HelpTexts')
Ext.namespace('Lino.system.TextFieldTemplates')
Ext.namespace('Lino.users.Users')
Ext.namespace('Lino.users.MySettings')
Ext.namespace('Lino.users.UsersOverview')
Ext.namespace('Lino.users.Teams')
Ext.namespace('Lino.users.Memberships')
Ext.namespace('Lino.users.Authorities')
Ext.namespace('Lino.countries.Countries')
Ext.namespace('Lino.countries.Cities')
Ext.namespace('Lino.properties.PropGroups')
Ext.namespace('Lino.properties.PropTypes')
Ext.namespace('Lino.properties.Properties')
Ext.namespace('Lino.properties.PropChoices')
Ext.namespace('Lino.contacts.CompanyTypes')
Ext.namespace('Lino.contacts.Partners')
Ext.namespace('Lino.contacts.Persons')
Ext.namespace('Lino.contacts.Companies')
Ext.namespace('Lino.contacts.RoleTypes')
Ext.namespace('Lino.contacts.Roles')
Ext.namespace('Lino.households.Types')
Ext.namespace('Lino.households.Households')
Ext.namespace('Lino.households.Roles')
Ext.namespace('Lino.households.Members')
Ext.namespace('Lino.accounts.Charts')
Ext.namespace('Lino.accounts.Groups')
Ext.namespace('Lino.accounts.Accounts')
Ext.namespace('Lino.products.ProductCats')
Ext.namespace('Lino.products.Products')
Ext.namespace('Lino.ledger.Journals')
Ext.namespace('Lino.ledger.Vouchers')
Ext.namespace('Lino.ledger.Movements')
Ext.namespace('Lino.ledger.Invoices')
Ext.namespace('Lino.sales.PaymentTerms')
Ext.namespace('Lino.sales.InvoicingModes')
Ext.namespace('Lino.sales.ShippingModes')
Ext.namespace('Lino.sales.Invoices')
Ext.namespace('Lino.sales.DocumentsToSign')
Ext.namespace('Lino.blogs.EntryTypes')
Ext.namespace('Lino.blogs.Entries')
Ext.namespace('Lino.tickets.ProjectTypes')
Ext.namespace('Lino.tickets.SessionTypes')
Ext.namespace('Lino.tickets.Projects')
Ext.namespace('Lino.tickets.Milestones')
Ext.namespace('Lino.tickets.Tickets')
Ext.namespace('Lino.tickets.UnassignedTickets')
Ext.namespace('Lino.tickets.Sessions')
Ext.namespace('Lino.outbox.Recipients')
Ext.namespace('Lino.outbox.Mails')
Ext.namespace('Lino.outbox.Attachments')
Ext.namespace('Lino.cal.Calendars')
Ext.namespace('Lino.cal.Subscriptions')
Ext.namespace('Lino.cal.Rooms')
Ext.namespace('Lino.cal.Priorities')
Ext.namespace('Lino.cal.Events')
Ext.namespace('Lino.cal.OneEvent')
Ext.namespace('Lino.cal.MyEvents')
Ext.namespace('Lino.cal.MyAssignedEvents')
Ext.namespace('Lino.cal.Tasks')
Ext.namespace('Lino.cal.MyTasks')
Ext.namespace('Lino.cal.GuestRoles')
Ext.namespace('Lino.cal.Guests')
Ext.namespace('Lino.cal.MyPresences')
Ext.namespace('Lino.cal.MyPendingPresences')
Ext.namespace('Lino.cal.MyGuests')
Ext.namespace('Lino.cal.PanelCalendars')
Ext.namespace('Lino.cal.PanelEvents')
Ext.namespace('Lino.uploads.UploadTypes')
Ext.namespace('Lino.uploads.Uploads')
Ext.namespace('Lino.sales.SalesRuleTable')
Ext.namespace('Lino.sales.InvoiceItemTable')
Ext.namespace('Lino.ledger.InvoiceItemTable')
Ext.namespace('Lino.system.MyTextFieldTemplates')
Ext.namespace('Lino.users.MembershipsByUser')
Ext.namespace('Lino.users.AuthoritiesGiven')
Ext.namespace('Lino.users.AuthoritiesTaken')
Ext.namespace('Lino.countries.CitiesByCity')
Ext.namespace('Lino.countries.CitiesByCountry')
Ext.namespace('Lino.properties.PropsByGroup')
Ext.namespace('Lino.properties.PropsByType')
Ext.namespace('Lino.properties.ChoicesByType')
Ext.namespace('Lino.contacts.PartnersByCity')
Ext.namespace('Lino.contacts.PartnersByCountry')
Ext.namespace('Lino.contacts.RolesByCompany')
Ext.namespace('Lino.contacts.RolesByPerson')
Ext.namespace('Lino.households.HouseholdsByType')
Ext.namespace('Lino.households.MembersByHousehold')
Ext.namespace('Lino.households.MembersByPerson')
Ext.namespace('Lino.households.MembersByRole')
Ext.namespace('Lino.accounts.GroupsByChart')
Ext.namespace('Lino.accounts.AccountsByGroup')
Ext.namespace('Lino.products.ProductsByCategory')
Ext.namespace('Lino.ledger.MovementsByVoucher')
Ext.namespace('Lino.ledger.MovementsByPartner')
Ext.namespace('Lino.ledger.MovementsByAccount')
Ext.namespace('Lino.ledger.InvoicesByJournal')
Ext.namespace('Lino.ledger.InvoicesByPartner')
Ext.namespace('Lino.ledger.ItemsByInvoice')
Ext.namespace('Lino.sales.ItemsByInvoicePrint')
Ext.namespace('Lino.sales.InvoiceItemsByProduct')
Ext.namespace('Lino.sales.InvoicesByJournal')
Ext.namespace('Lino.sales.InvoicesByPartner')
Ext.namespace('Lino.sales.ItemsByInvoice')
Ext.namespace('Lino.blogs.MyEntries')
Ext.namespace('Lino.blogs.EntriesByType')
Ext.namespace('Lino.tickets.ProjectsByProject')
Ext.namespace('Lino.tickets.ProjectsByPartner')
Ext.namespace('Lino.tickets.MilestonesByProject')
Ext.namespace('Lino.tickets.TicketsByProject')
Ext.namespace('Lino.tickets.TicketsByPartner')
Ext.namespace('Lino.tickets.TicketsFixed')
Ext.namespace('Lino.tickets.TicketsReported')
Ext.namespace('Lino.tickets.SessionsByTicket')
Ext.namespace('Lino.tickets.SessionsByProject')
Ext.namespace('Lino.tickets.MySessions')
Ext.namespace('Lino.tickets.MySessionsByDate')
Ext.namespace('Lino.tickets.EntriesByTicket')
Ext.namespace('Lino.tickets.EntriesBySession')
Ext.namespace('Lino.tickets.MyProjects')
Ext.namespace('Lino.tickets.MyTickets')
Ext.namespace('Lino.tickets.MyOpenTickets')
Ext.namespace('Lino.outbox.RecipientsByMail')
Ext.namespace('Lino.outbox.MyOutbox')
Ext.namespace('Lino.outbox.MailsByUser')
Ext.namespace('Lino.outbox.MailsByProject')
Ext.namespace('Lino.outbox.SentByPartner')
Ext.namespace('Lino.outbox.AttachmentsByMail')
Ext.namespace('Lino.cal.SubscriptionsByCalendar')
Ext.namespace('Lino.cal.SubscriptionsByUser')
Ext.namespace('Lino.cal.EventsByCalendar')
Ext.namespace('Lino.cal.EventsByRoom')
Ext.namespace('Lino.cal.EventsByProject')
Ext.namespace('Lino.cal.TasksByUser')
Ext.namespace('Lino.cal.TasksByProject')
Ext.namespace('Lino.cal.GuestsByEvent')
Ext.namespace('Lino.cal.GuestsByRole')
Ext.namespace('Lino.cal.GuestsByPartner')
Ext.namespace('Lino.uploads.MyUploads')
Ext.namespace('Lino.uploads.UploadsByController')
Ext.namespace('Lino.sales.InvoicingsByInvoiceable')
Ext.namespace('Lino.system.HelpTextsByModel')
Ext.namespace('Lino.cal.TasksByController')
Ext.namespace('Lino.outbox.MailsByController')
Ext.namespace('Lino.outbox.AttachmentsByController')
Ext.namespace('Lino.cal.EventsByController')
Ext.namespace('Lino.blogs.EntriesByController')
Ext.namespace('Lino.about.Models')
Ext.namespace('Lino.about.FieldsByModel')
Ext.namespace('Lino.about.Inspector')
Ext.namespace('Lino.about.SourceFiles')
Ext.namespace('Lino.ledger.ExpectedMovements')
Ext.namespace('Lino.ledger.DuePaymentsByAccount')
Ext.namespace('Lino.ledger.DuePaymentsByPartner')
Ext.namespace('Lino.sales.InvoicesToCreate')
Ext.namespace('Lino.sales.InvoiceablesByPartner')
Ext.namespace('Lino.lino.Report')
Ext.namespace('Lino.about.About')
Ext.namespace('Lino.system.Home')
Ext.namespace('Lino.cal.CalendarPanel')
Ext.namespace('Lino.vat.VatClasses')
Ext.namespace('Lino.vat.TradeTypes')
Ext.namespace('Lino.cal.DurationUnits')
Ext.namespace('Lino.cal.TaskStates')
Ext.namespace('Lino.cal.Weekdays')
Ext.namespace('Lino.ledger.InvoiceStates')
Ext.namespace('Lino.accounts.AccountTypes')
Ext.namespace('Lino.lino.UserLevels')
Ext.namespace('Lino.lino.YesNo')
Ext.namespace('Lino.cal.EventStates')
Ext.namespace('Lino.ledger.FiscalYears')
Ext.namespace('Lino.cal.Recurrencies')
Ext.namespace('Lino.properties.HowWell')
Ext.namespace('Lino.outbox.RecipientType')
Ext.namespace('Lino.cal.EventEvents')
Ext.namespace('Lino.cal.GuestStates')
Ext.namespace('Lino.countries.CityTypes')
Ext.namespace('Lino.properties.DoYouLike')
Ext.namespace('Lino.vat.VatRegimes')
Ext.namespace('Lino.ledger.VoucherTypes')
Ext.namespace('Lino.lino.UserGroups')
Ext.namespace('Lino.cal.AccessClasses')
Ext.namespace('Lino.lino.Genders')
Ext.namespace('Lino.lino.UserProfiles')
Ext.namespace('Lino.sales.InvoiceStates')
Ext.namespace('Lino.tickets.TicketStates')

// ChoiceLists: 
Lino.vat.VatClasses = [ [ "0", "Exempt" ], [ "1", "Reduced" ], [ "2", "Normal" ] ];
Lino.vat.TradeTypes = [ [ "S", "Sales" ], [ "P", "Purchases" ], [ "W", "Wages" ] ];
Lino.cal.DurationUnits = [ [ "s", "seconds" ], [ "m", "minutes" ], [ "h", "hours" ], [ "D", "days" ], [ "W", "weeks" ], [ "M", "months" ], [ "Y", "years" ] ];
Lino.cal.TaskStates = [ [ "10", "To do" ], [ "20", "Started" ], [ "30", "Done" ], [ "50", "Cancelled" ] ];
Lino.cal.Weekdays = [ [ "1", "Monday" ], [ "2", "Tuesday" ], [ "3", "Wednesday" ], [ "4", "Thursday" ], [ "5", "Friday" ], [ "6", "Saturday" ], [ "7", "Sunday" ] ];
Lino.ledger.InvoiceStates = [ [ "10", "Draft" ], [ "20", "Registered" ], [ "40", "Paid" ] ];
Lino.accounts.AccountTypes = [ [ "A", "Assets" ], [ "L", "Liabilities" ], [ "I", "Incomes" ], [ "E", "Expenses" ], [ "C", "Capital" ], [ "B", "Bank accounts" ] ];
Lino.lino.UserLevels = [ [ "10", "Guest" ], [ "30", "User" ], [ "40", "Manager" ], [ "50", "Administrator" ] ];
Lino.lino.YesNo = [ [ "y", "Yes" ], [ "n", "No" ] ];
Lino.cal.EventStates = [ [ "10", "Suggested" ], [ "20", "Draft" ], [ "50", "Took place" ], [ "70", "Cancelled" ] ];
Lino.ledger.FiscalYears = [ [ "11", "2011" ], [ "12", "2012" ], [ "13", "2013" ], [ "14", "2014" ], [ "15", "2015" ], [ "16", "2016" ], [ "17", "2017" ] ];
Lino.cal.Recurrencies = [ [ "D", "daily" ], [ "W", "weekly" ], [ "M", "monthly" ], [ "Y", "yearly" ], [ "P", "per weekday" ] ];
Lino.properties.HowWell = [ [ "0", "not at all" ], [ "1", "a bit" ], [ "2", "moderate" ], [ "3", "quite well" ], [ "4", "very well" ] ];
Lino.outbox.RecipientType = [ [ "to", "to" ], [ "cc", "cc" ], [ "bcc", "bcc" ] ];
Lino.cal.EventEvents = [ [ "10", "Okay" ], [ "20", "Pending" ] ];
Lino.cal.GuestStates = [ [ "10", "Invited" ] ];
Lino.countries.CityTypes = [ [ "10", "Member State" ], [ "11", "Division" ], [ "12", "Region" ], [ "13", "Community" ], [ "14", "Territory" ], [ "20", "County" ], [ "21", "Province" ], [ "22", "Shire" ], [ "23", "Subregion" ], [ "24", "Department" ], [ "25", "Arrondissement" ], [ "26", "Prefecture" ], [ "27", "District" ], [ "28", "Sector" ], [ "50", "City" ], [ "51", "Town" ], [ "52", "Municipality" ], [ "54", "Parish" ], [ "55", "Township" ], [ "56", "Quarter" ], [ "61", "Borough" ], [ "62", "Small borough" ], [ "70", "Village" ] ];
Lino.properties.DoYouLike = [ [ "0", "certainly not" ], [ "1", "rather not" ], [ "2", "normally" ], [ "3", "quite much" ], [ "4", "very much" ] ];
Lino.vat.VatRegimes = [ [ "10", "Private person" ], [ "20", "Subject to VAT" ], [ "25", "Co-contractor" ], [ "30", "Intra-community" ], [ "40", "Outside EU" ], [ "50", "Exempt" ] ];
Lino.ledger.VoucherTypes = [ [ "ledger.AccountInvoice", "Rechnung (ledger.AccountInvoice)" ], [ "sales.Invoice", "Rechnung (sales.Invoice)" ] ];
Lino.lino.UserGroups = [ [ "office", "office (Office)" ], [ "accounting", "accounting (Accounting)" ] ];
Lino.cal.AccessClasses = [ [ "10", "Private" ], [ "20", "Show busy" ], [ "30", "Public" ] ];
Lino.lino.Genders = [ [ "M", "Male" ], [ "F", "Female" ] ];
Lino.lino.UserProfiles = [ [ "000", "000 (Anonymous)" ], [ "100", "100 (User)" ], [ "900", "900 (Administrator)" ] ];
Lino.sales.InvoiceStates = [ [ "10", "Draft" ], [ "20", "Registered" ], [ "30", "Signed" ], [ "40", "Sent" ], [ "50", "Paid" ] ];
Lino.tickets.TicketStates = [ [ "10", "Accepted" ], [ "20", "Working" ], [ "30", "Waiting" ], [ "40", "Fixed" ], [ "50", "Tested" ], [ "60", "Closed" ], [ "90", "Cancelled" ] ];

Lino.ledger.Movements.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var start_date503 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Period from</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Period from","Start date of observed period") }, "anchor": "-20" });
    var end_date504 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">until</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("until","End date of observed period") }, "anchor": "-20" });
    var cleared505 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Show cleared movements", "name": "cleared", "hiddenName": "clearedHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.YesNo) });
    var main_1_panel506 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date503, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date504, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cleared505, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 207, "border": false, "anchor": "-20", "labelAlign": "top" });
    var pjournal510 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Journal", "name": "pjournal", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail)}, "emptyText": "Select a Journal...", "selectOnFocus": true, "hiddenName": "pjournalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Movements/pjournal", "method": "GET" }) }) });
    var pyear511 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "pyear", "hiddenName": "pyearHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var ppartner512 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "ppartner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "hiddenName": "ppartnerHidden", "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Movements/ppartner", "method": "GET" }) }) });
    var paccount513 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Account", "name": "paccount", "pageSize": 20, "emptyText": "Select a Account...", "selectOnFocus": true, "hiddenName": "paccountHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Movements/paccount", "method": "GET" }) }) });
    var main_2_panel514 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pjournal510, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pyear511, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ppartner512, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": paccount513, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel506, main_2_panel514 ];
    this.fields = [ start_date503, end_date504, cleared505, pjournal510, pyear511, ppartner512, paccount513 ];
    Lino.ledger.Movements.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.TicketsByProject.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  labelWidth: 45,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var today1351 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Date", "anchor": "-20", "name": "today" });
    this.items = [ { "items": today1351, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ today1351 ];
    Lino.tickets.TicketsByProject.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Invoices.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 108,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'hbox',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var pjournal1261 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Journal", "name": "pjournal", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail)}, "emptyText": "Select a Journal...", "selectOnFocus": true, "hiddenName": "pjournalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/pjournal", "method": "GET" }) }) });
    var pyear1262 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "pyear", "hiddenName": "pyearHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var ppartner1263 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "ppartner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "hiddenName": "ppartnerHidden", "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/ppartner", "method": "GET" }) }) });
    this.items = [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pjournal1261, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pyear1262, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ppartner1263, "labelAlign": "top" } ];
    this.fields = [ pjournal1261, pyear1262, ppartner1263 ];
    Lino.ledger.Invoices.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var start_date1590 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Period from</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Period from","Start date of observed period") }, "anchor": "-20" });
    var end_date1591 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">until</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("until","End date of observed period") }, "anchor": "-20" });
    var user1592 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Responsible user</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Responsible user","Only rows managed by this user.") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/user", "method": "GET" }) }) });
    var event_state1593 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Event state</span>", "name": "event_state", "hiddenName": "event_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Event state","Only rows having this event state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.EventStates) });
    var guest_state1594 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Guest state</span>", "name": "guest_state", "hiddenName": "guest_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Guest state","Only rows having this guest state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.GuestStates) });
    var main_1_panel1595 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1590, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1591, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1592, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_state1593, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": guest_state1594, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var project1601 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail)}, "emptyText": "Select a Project...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/project", "method": "GET" }) }) });
    var partner1602 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "hiddenName": "partnerHidden", "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }) });
    var main_2_panel1603 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1601, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1602, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel1595, main_2_panel1603 ];
    this.fields = [ start_date1590, end_date1591, user1592, event_state1593, guest_state1594, project1601, partner1602 ];
    Lino.cal.Guests.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.MySessionsByDate.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  labelWidth: 45,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var today1792 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Date", "anchor": "-20", "name": "today" });
    this.items = [ { "items": today1792, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ today1792 ];
    Lino.tickets.MySessionsByDate.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var start_date71 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Period from</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","Start date of observed period") }, "anchor": "-20" });
    var end_date72 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">until</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","End date of observed period") }, "anchor": "-20" });
    var user73 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Managed by</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Verwaltet durch","Only rows managed by this user.") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var state74 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">State</span>", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","Only rows having this state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.TaskStates) });
    var project75 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail)}, "emptyText": "Select a Project...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_1_panel76 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date71, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date72, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user73, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state74, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project75, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    this.items = [ main_1_panel76 ];
    this.fields = [ start_date71, end_date72, user73, state74, project75 ];
    Lino.cal.Tasks.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.about.Inspector.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 153,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'hbox',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var inspected1810 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Inspected object", "name": "inspected", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var show_callables1811 = new Ext.form.Checkbox({ "boxLabel": "show callables", "autoHeight": true, "hideLabel": true, "checked": false, "name": "show_callables", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "flex": 67, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inspected1810, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_callables1811, "labelAlign": "top" } ];
    this.fields = [ inspected1810, show_callables1811 ];
    Lino.about.Inspector.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Events.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var start_date1526 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Period from</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Period from","Start date of observed period") }, "anchor": "-20" });
    var end_date1527 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">until</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("until","End date of observed period") }, "anchor": "-20" });
    var observed_event1528 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Observed event", "name": "observed_event", "hiddenName": "observed_eventHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.EventEvents) });
    var state1529 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">State</span>", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("State","Only rows having this state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.EventStates) });
    var main_1_panel1530 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1526, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1527, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event1528, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state1529, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var user1535 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Managed by</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Managed by","Only rows managed by this user.") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }) });
    var assigned_to1536 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Assigned to</span>", "name": "assigned_to", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "assigned_toHidden", "listeners": { "render": Lino.quicktip_renderer("Assigned to","Only events assigned to this user.") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/assigned_to", "method": "GET" }) }) });
    var project1537 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail)}, "emptyText": "Select a Project...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }) });
    var calendar1538 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Calendar", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Select a Calendar...", "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/calendar", "method": "GET" }) }) });
    var show_appointments1539 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Appointments", "name": "show_appointments", "hiddenName": "show_appointmentsHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.YesNo) });
    var main_2_panel1540 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1535, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": assigned_to1536, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1537, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar1538, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_appointments1539, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel1530, main_2_panel1540 ];
    this.fields = [ start_date1526, end_date1527, observed_event1528, state1529, user1535, assigned_to1536, project1537, calendar1538, show_appointments1539 ];
    Lino.cal.Events.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.ExpectedMovements.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 99,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'hbox',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var trade_type1815 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Trade Type", "name": "trade_type", "hiddenName": "trade_typeHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.vat.TradeTypes) });
    var date_until1816 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Date until", "anchor": "-20", "name": "date_until" });
    this.items = [ { "flex": 72, "autoHeight": true, "layout": "form", "xtype": "panel", "items": trade_type1815, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_until1816, "labelAlign": "top" } ];
    this.fields = [ trade_type1815, date_until1816 ];
    Lino.ledger.ExpectedMovements.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.sales.Invoices.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 108,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'hbox',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var journal426 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Journal", "name": "journal", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail)}, "emptyText": "Select a Journal...", "selectOnFocus": true, "hiddenName": "journalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/journal", "method": "GET" }) }) });
    var year427 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "year", "hiddenName": "yearHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    this.items = [ { "flex": 74, "autoHeight": true, "layout": "form", "xtype": "panel", "items": journal426, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": year427, "labelAlign": "top" } ];
    this.fields = [ journal426, year427 ];
    Lino.sales.Invoices.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.Uploads.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 55,
  initComponent : function() {
    var containing_panel = this;
    var file1781 = Lino.file_field_handler(this,{ "autoHeight": true, "fieldLabel": "Datei", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user1782 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel1783 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file1781, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1782, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type1786 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Upload Type", "name": "type", "pageSize": 20, "emptyText": "Select a Upload Type...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var description1787 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Description", "name": "description", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel1788 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1786, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": description1787, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1791 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1783, main_2_panel1788 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1791;
    this.before_row_edit = function(record) {
    }
    Lino.uploads.Uploads.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Groups.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 33,
  initComponent : function() {
    var containing_panel = this;
    var ref1053 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "ref", "name": "ref", "maxLength": 20, "selectOnFocus": true, "anchor": "-20" });
    var name1054 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1055 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_et1056 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_en1057 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (en)", "name": "name_en", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1058 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1053, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1054, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1055, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1056, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1057, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var account_type1064 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Account Type", "name": "account_type", "hiddenName": "account_typeHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.accounts.AccountTypes) });
    var id1065 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_2_panel1066 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 78, "autoHeight": true, "layout": "form", "xtype": "panel", "items": account_type1064, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1065, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var help_text1069 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 41, "containing_panel": this, "name": "help_text", "title": "Introduction" });
    var AccountsByGroup_grid1084 = new Lino.accounts.AccountsByGroup.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.accounts.AccountsByGroup.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1085 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel1058, main_2_panel1066, help_text1069, AccountsByGroup_grid1084 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1085;
    this.before_row_edit = function(record) {
      help_text1069.refresh();
      AccountsByGroup_grid1084.on_master_changed();
    }
    Lino.accounts.Groups.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Households.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 28,
  initComponent : function() {
    var containing_panel = this;
    var type949 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Household Type", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.households.Types.detail)}, "emptyText": "Select a Household Type...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/type", "method": "GET" }) }) });
    var name950 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language951 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ], [ "en", "English" ] ], "name": "language" });
    var id952 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var intro_box_1_panel953 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type949, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name950, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language951, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id952, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var country958 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Select a Country...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/country", "method": "GET" }) }) });
    var region959 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/region", "method": "GET" }) }) });
    var box3_1_panel960 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country958, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region959, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city963 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/city", "method": "GET" }) }) });
    var zip_code964 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Zip code", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box3_2_panel965 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city963, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code964, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix968 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street prefix</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Street prefix","Text to print before name of street, but to ignore for sorting.") }, "anchor": "-20" });
    var street969 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Street","Name of street. Without house number.") }, "anchor": "-20" });
    var street_no970 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("No.","House number") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var street_box971 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var box3_3_panel972 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix968, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street969, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no970, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box971, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2977 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line after street</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Address line after street","Address line to print below street line") }, "anchor": "-20" });
    var box3_panel978 = new Ext.Panel({ "flex": 62, "autoHeight": true, "layout": "form", "items": [ box3_1_panel960, box3_2_panel965, box3_3_panel972, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2977, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 234, "border": false, "labelAlign": "top" });
    var email980 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var url981 = new Lino.URLField({ "autoHeight": true, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var phone982 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Phone", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gsm983 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var box4_panel984 = new Ext.Panel({ "flex": 37, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email980, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url981, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone982, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm983, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var address_box_panel989 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box3_panel978, box4_panel984 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks990 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarks", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var households_MembersByHousehold_grid997 = new Lino.households.MembersByHousehold.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByHousehold.grid) ], "preview_limit": 15, "master_panel": this });
    var bottom_box_panel998 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": remarks990, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 49 }, households_MembersByHousehold_grid997 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel1000 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ intro_box_1_panel953, address_box_panel989, bottom_box_panel998 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var invoicing_address1001 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Invoicing address", "name": "invoicing_address", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "hiddenName": "invoicing_addressHidden", "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/invoicing_address", "method": "GET" }) }) });
    var vat_regime1002 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">VAT Regime</span>", "name": "vat_regime", "hiddenName": "vat_regimeHidden", "listeners": { "render": Lino.quicktip_renderer("VAT Regime","The default VAT regime for sales to this customer.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var imode1003 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Invoicing Mode", "name": "imode", "pageSize": 20, "emptyText": "Select a Invoicing Mode...", "selectOnFocus": true, "hiddenName": "imodeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/imode", "method": "GET" }) }) });
    var payment_term1004 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Payment Term</span>", "name": "payment_term", "pageSize": 20, "emptyText": "Select a Payment Term...", "listeners": { "render": Lino.quicktip_renderer("Payment Term","The default payment term for sales invoices to this customer.") }, "selectOnFocus": true, "hiddenName": "payment_termHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/payment_term", "method": "GET" }) }) });
    var sales_1_panel1005 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 162, "hideCheckBoxLabels": true, "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invoicing_address1001, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_regime1002, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": imode1003, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": payment_term1004, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var sales_InvoicesByPartner_grid1010 = new Lino.sales.InvoicesByPartner.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.sales.InvoicesByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var sales_panel1011 = new Ext.Panel({ "layout": "vbox", "title": "Sales", "items": [ sales_1_panel1005, sales_InvoicesByPartner_grid1010 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel1012 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1000, sales_panel1011 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1012;
    this.before_row_edit = function(record) {
      region959.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city963.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city963.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      households_MembersByHousehold_grid997.on_master_changed();
      sales_InvoicesByPartner_grid1010.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country958.on('change',Lino.chooser_handler(region959,'country'));
      country958.on('change',Lino.chooser_handler(city963,'country'));
      region959.on('change',Lino.chooser_handler(city963,'region'));
      Lino.households.Households.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.households.Households.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Journals.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 35,
  initComponent : function() {
    var containing_panel = this;
    var ref1148 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "ref", "name": "ref", "maxLength": 20, "selectOnFocus": true, "anchor": "-20" });
    var trade_type1149 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Trade Type", "name": "trade_type", "hiddenName": "trade_typeHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.vat.TradeTypes) });
    var seqno1150 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Seq.No.", "anchor": "-20", "name": "seqno" });
    var id1151 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var voucher_type1152 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "voucher type", "allowBlank": false, "hiddenName": "voucher_typeHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.ledger.VoucherTypes, "name": "voucher_type" });
    var main_1_panel1153 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1148, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": trade_type1149, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": seqno1150, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1151, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": voucher_type1152, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var force_sequence1159 = new Ext.form.Checkbox({ "boxLabel": "Force chronological sequence", "autoHeight": true, "hideLabel": true, "checked": false, "name": "force_sequence", "selectOnFocus": true, "anchor": "-20" });
    var account1160 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Account", "name": "account", "pageSize": 20, "emptyText": "Select a Account...", "selectOnFocus": true, "hiddenName": "accountHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Journals/account", "method": "GET" }) }) });
    var dc1161 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": null, "name": "dc", "listeners": { "render": Lino.quicktip_renderer("dc","Debit (checked) or Credit (not checked)") }, "boxLabel": "dc", "selectOnFocus": true, "anchor": "-20" });
    var build_method1162 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Build method", "name": "build_method", "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "hiddenName": "build_methodHidden" });
    var template1163 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Template", "name": "template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Journals/template", "method": "GET" }) }) });
    var main_2_panel1164 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": force_sequence1159, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": account1160, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": dc1161, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method1162, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template1163, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 261, "border": false, "anchor": "-20", "labelAlign": "top" });
    var name1170 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1171 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_et1172 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_en1173 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (en)", "name": "name_en", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel1174 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1170, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1171, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1172, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1173, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var printed_name1179 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "printed name", "name": "printed_name", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var printed_name_fr1180 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "printed name (fr)", "name": "printed_name_fr", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var printed_name_et1181 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "printed name (et)", "name": "printed_name_et", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var printed_name_en1182 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "printed name (en)", "name": "printed_name_en", "maxLength": 100, "selectOnFocus": true, "anchor": "-20" });
    var main_4_panel1183 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": printed_name1179, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": printed_name_fr1180, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": printed_name_et1181, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": printed_name_en1182, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1188 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1153, main_2_panel1164, main_3_panel1174, main_4_panel1183 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1188;
    this.before_row_edit = function(record) {
      account1160.setContextValue('chart',record ? record.data['chartHidden'] : undefined);
      template1163.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      template1163.setContextValue('voucher_type',record ? record.data['voucher_typeHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      build_method1162.on('change',Lino.chooser_handler(template1163,'build_method'));
      voucher_type1152.on('change',Lino.chooser_handler(template1163,'voucher_type'));
      Lino.ledger.Journals.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.ledger.Journals.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.Milestones.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 52,
  initComponent : function() {
    var containing_panel = this;
    var project1378 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail)}, "emptyText": "Select a Project...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Milestones/project", "method": "GET" }) }) });
    var ref1379 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Reference", "name": "ref", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var expected1380 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Expected for", "anchor": "-20", "name": "expected" });
    var reached1381 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Reached", "anchor": "-20", "name": "reached" });
    var id1382 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_1_panel1383 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1378, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1379, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": expected1380, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": reached1381, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1382, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var TicketsFixed_grid1400 = new Lino.tickets.TicketsFixed.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.tickets.TicketsFixed.grid) ], "preview_limit": 15, "master_panel": this });
    var TicketsReported_grid1412 = new Lino.tickets.TicketsReported.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.tickets.TicketsReported.grid) ], "preview_limit": 15, "master_panel": this });
    var main_2_panel1413 = new Ext.Panel({ "flex": 83, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ TicketsFixed_grid1400, TicketsReported_grid1412 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel1414 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1383, main_2_panel1413 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1414;
    this.before_row_edit = function(record) {
      TicketsFixed_grid1400.on_master_changed();
      TicketsReported_grid1412.on_master_changed();
    }
    Lino.tickets.Milestones.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.blogs.Entries.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 46,
  initComponent : function() {
    var containing_panel = this;
    var title613 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Heading", "name": "title", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var type614 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Blog Entry Type", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.blogs.EntryTypes.detail)}, "emptyText": "Select a Blog Entry Type...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/Entries/type", "method": "GET" }) }) });
    var user615 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/Entries/user", "method": "GET" }) }) });
    var id616 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_1_panel617 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title613, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type614, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user615, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id616, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var language622 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Language", "allowBlank": false, "hiddenName": "languageHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ], [ "en", "English" ] ], "name": "language" });
    var created623 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified624 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "anchor": "-20", "value": "<br>" });
    var owner_disp625 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Controlled by", "anchor": "-20", "name": "owner" });
    var build_time626 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "build time", "name": "build_time", "anchor": "-20", "value": "<br>" });
    var main_2_panel627 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language622, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created623, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified624, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp625, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_time626, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var body633 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 71, "containing_panel": this, "name": "body", "title": "Body" });
    var main_panel634 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel617, main_2_panel627, body633 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel634;
    this.before_row_edit = function(record) {
      body633.refresh();
    }
    Lino.blogs.Entries.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 59,
  initComponent : function() {
    var containing_panel = this;
    var event1634 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Event", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.OneEvent.detail)}, "emptyText": "Select a Event...", "selectOnFocus": true, "hiddenName": "eventHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/event", "method": "GET" }) }), "name": "event" });
    var partner1635 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Select a Partner...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }), "name": "partner" });
    var role1636 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Role", "name": "role", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.GuestRoles.detail)}, "emptyText": "Select a Guest Role...", "selectOnFocus": true, "hiddenName": "roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/role", "method": "GET" }) }) });
    var main_panel1637 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": event1634, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1635, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": role1636, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1637;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Guests.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.GuestRoles.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 60,
  initComponent : function() {
    var containing_panel = this;
    var id1732 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1733 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1734 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_et1735 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_en1736 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (en)", "name": "name_en", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1737 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1732, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1733, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1734, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1735, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1736, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var build_method1743 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Build method", "name": "build_method", "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "hiddenName": "build_methodHidden" });
    var template1744 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Template", "name": "template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestRoles/template", "method": "GET" }) }) });
    var email_template1745 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Email template</span>", "name": "email_template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Email template","The name of the file to be used as \ntemplate when creating an email from a mailable of this type.") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestRoles/email_template", "method": "GET" }) }), "anchor": "-20" });
    var attach_to_email1746 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "attach_to_email", "listeners": { "render": Lino.quicktip_renderer("Attach to email","Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "boxLabel": "Attach to email", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel1747 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method1743, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template1744, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template1745, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email1746, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_GuestsByRole_grid1761 = new Lino.cal.GuestsByRole.GridPanel({ "flex": 71, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.GuestsByRole.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1762 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1737, main_2_panel1747, cal_GuestsByRole_grid1761 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1762;
    this.before_row_edit = function(record) {
      template1744.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      cal_GuestsByRole_grid1761.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method1743.on('change',Lino.chooser_handler(template1744,'build_method'));
      Lino.cal.GuestRoles.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.cal.GuestRoles.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Cities.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 15,
  initComponent : function() {
    var containing_panel = this;
    var name266 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr267 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_et268 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_en269 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (en)", "name": "name_en", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var country270 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Country", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Select a Country...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/country", "method": "GET" }) }), "name": "country" });
    var main_1_panel271 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name266, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr267, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et268, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en269, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country270, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var type277 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Place Type", "name": "type", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/type", "method": "GET" }) }), "hiddenName": "typeHidden" });
    var parent278 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Part of</span>", "name": "parent", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Part of","The superordinate geographic place of which this place is a part.") }, "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/parent", "method": "GET" }) }) });
    var zip_code279 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "zip code", "name": "zip_code", "maxLength": 8, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "anchor": "-20" });
    var id280 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_2_panel281 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type277, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent278, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code279, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id280, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var CitiesByCity_grid675 = new Lino.countries.CitiesByCity.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.countries.CitiesByCity.grid) ], "preview_limit": 15, "master_panel": this });
    var contacts_PartnersByCity_grid676 = new Lino.contacts.PartnersByCity.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.PartnersByCity.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel677 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel271, main_2_panel281, CitiesByCity_grid675, contacts_PartnersByCity_grid676 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel677;
    this.before_row_edit = function(record) {
      type277.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      CitiesByCity_grid675.on_master_changed();
      contacts_PartnersByCity_grid676.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country270.on('change',Lino.chooser_handler(type277,'country'));
      Lino.countries.Cities.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.countries.Cities.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.SiteConfigs.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 7,
  initComponent : function() {
    var containing_panel = this;
    var site_company182 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">The company that runs this site</span>", "name": "site_company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail)}, "hiddenName": "site_companyHidden", "listeners": { "render": Lino.quicktip_renderer("The company that runs this site","The Company to be used as sender in documents.") }, "selectOnFocus": true, "emptyText": "Select a Company...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/site_company", "method": "GET" }) }) });
    var next_partner_id183 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Next partner id</span>", "name": "next_partner_id", "value": 100, "listeners": { "render": Lino.quicktip_renderer("Next partner id","The next automatic id for any new partner.") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel184 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": site_company182, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": next_partner_id183, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 288, "border": false, "anchor": "-20", "labelAlign": "top" });
    var default_build_method187 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Default build method", "name": "default_build_method", "value": "appyodt", "hiddenName": "default_build_methodHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var clients_account188 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Clients account", "name": "clients_account", "pageSize": 20, "emptyText": "Select a Account...", "selectOnFocus": true, "hiddenName": "clients_accountHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/clients_account", "method": "GET" }) }) });
    var sales_account189 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Sales Base account", "name": "sales_account", "pageSize": 20, "emptyText": "Select a Account...", "selectOnFocus": true, "hiddenName": "sales_accountHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/sales_account", "method": "GET" }) }) });
    var sales_vat_account190 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Sales VAT account", "name": "sales_vat_account", "pageSize": 20, "emptyText": "Select a Account...", "selectOnFocus": true, "hiddenName": "sales_vat_accountHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/sales_vat_account", "method": "GET" }) }) });
    var main_3_panel191 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": clients_account188, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sales_account189, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sales_vat_account190, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 171, "border": false, "anchor": "-20", "labelAlign": "top" });
    var suppliers_account195 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Suppliers account", "name": "suppliers_account", "pageSize": 20, "emptyText": "Select a Account...", "selectOnFocus": true, "hiddenName": "suppliers_accountHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/suppliers_account", "method": "GET" }) }) });
    var purchases_account196 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Purchases Base account", "name": "purchases_account", "pageSize": 20, "emptyText": "Select a Account...", "selectOnFocus": true, "hiddenName": "purchases_accountHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/purchases_account", "method": "GET" }) }) });
    var purchases_vat_account197 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Purchases VAT account", "name": "purchases_vat_account", "pageSize": 20, "emptyText": "Select a Account...", "selectOnFocus": true, "hiddenName": "purchases_vat_accountHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/purchases_vat_account", "method": "GET" }) }) });
    var main_4_panel198 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": suppliers_account195, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": purchases_account196, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": purchases_vat_account197, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 207, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel202 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 189, "autoScroll": false, "items": [ main_1_panel184, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": default_build_method187, "anchor": "-20", "labelAlign": "top" }, main_3_panel191, main_4_panel198 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel202;
    this.before_row_edit = function(record) {
    }
    Lino.system.SiteConfigs.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.Models.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var app_disp1795 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "app_label", "name": "app", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var name_disp1796 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "name", "name": "name", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var docstring_disp1797 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "docstring", "name": "docstring", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var rows1798 = new Ext.form.NumberField({ "disabled": true, "autoHeight": true, "fieldLabel": "Rows", "anchor": "-20", "name": "rows" });
    var main_1_panel1799 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_disp1795, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_disp1796, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": docstring_disp1797, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": rows1798, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var about_FieldsByModel_grid1808 = new Lino.about.FieldsByModel.GridPanel({ "flex": 62, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.about.FieldsByModel.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1809 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1799, about_FieldsByModel_grid1808 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1809;
    this.before_row_edit = function(record) {
      about_FieldsByModel_grid1808.on_master_changed();
    }
    Lino.about.Models.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.ContentTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 2,
  initComponent : function() {
    var containing_panel = this;
    var id204 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name205 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "name", "name": "name", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var app_label206 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "app label", "name": "app_label", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var model207 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "python model class name", "name": "model", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var base_classes_disp208 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Base classes", "name": "base_classes", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel209 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id204, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name205, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_label206, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": model207, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": base_classes_disp208, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var system_HelpTextsByModel_grid221 = new Lino.system.HelpTextsByModel.GridPanel({ "flex": 62, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.system.HelpTextsByModel.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel222 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel209, system_HelpTextsByModel_grid221 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel222;
    this.before_row_edit = function(record) {
      system_HelpTextsByModel_grid221.on_master_changed();
    }
    Lino.system.ContentTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Calendars.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 61,
  initComponent : function() {
    var containing_panel = this;
    var name1455 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1456 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_et1457 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_en1458 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (en)", "name": "name_en", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1459 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1455, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1456, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1457, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1458, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var event_label1464 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Event label", "name": "event_label", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "value": "Appointment" });
    var event_label_fr1465 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Event label (fr)", "name": "event_label_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var event_label_et1466 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Event label (et)", "name": "event_label_et", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var event_label_en1467 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Event label (en)", "name": "event_label_en", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel1468 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label1464, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label_fr1465, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label_et1466, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label_en1467, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var readonly1473 = new Ext.form.Checkbox({ "boxLabel": "read-only", "autoHeight": true, "hideLabel": true, "checked": false, "name": "readonly", "selectOnFocus": true, "anchor": "-20" });
    var color1474 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "color", "name": "color", "selectOnFocus": true, "anchor": "-20", "value": 1, "allowBlank": false });
    var start_date1475 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Start date", "anchor": "-20", "name": "start_date" });
    var id1476 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_3_panel1477 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": readonly1473, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": color1474, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1475, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1476, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var type1482 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Type", "allowBlank": false, "value": "local", "hiddenName": "typeHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "local", "Local Calendar" ], [ "google", "Google Calendar" ] ], "name": "type" });
    var url_template1483 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "URL template", "name": "url_template", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var username1484 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Username", "name": "username", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var password1485 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Password", "name": "password", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "inputType": "password" });
    var main_4_panel1486 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1482, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": url_template1483, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username1484, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": password1485, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var build_method1491 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Build method", "name": "build_method", "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "hiddenName": "build_methodHidden" });
    var template1492 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Template", "name": "template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/template", "method": "GET" }) }) });
    var email_template1493 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Email template</span>", "name": "email_template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Email template","The name of the file to be used as \ntemplate when creating an email from a mailable of this type.") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/email_template", "method": "GET" }) }), "anchor": "-20" });
    var attach_to_email1494 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "attach_to_email", "listeners": { "render": Lino.quicktip_renderer("Attach to email","Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "boxLabel": "Attach to email", "selectOnFocus": true, "anchor": "-20" });
    var main_5_panel1495 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method1491, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template1492, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template1493, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email1494, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var EventsByCalendar_grid1671 = new Lino.cal.EventsByCalendar.GridPanel({ "flex": 77, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByCalendar.grid) ], "master_panel": this, "preview_limit": 15 });
    var SubscriptionsByCalendar_grid1676 = new Lino.cal.SubscriptionsByCalendar.GridPanel({ "flex": 22, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.SubscriptionsByCalendar.grid) ], "preview_limit": 15, "master_panel": this });
    var main_6_panel1677 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ EventsByCalendar_grid1671, SubscriptionsByCalendar_grid1676 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel1678 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1459, main_2_panel1468, main_3_panel1477, main_4_panel1486, main_5_panel1495, main_6_panel1677 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1678;
    this.before_row_edit = function(record) {
      template1492.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      EventsByCalendar_grid1671.on_master_changed();
      SubscriptionsByCalendar_grid1676.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method1491.on('change',Lino.chooser_handler(template1492,'build_method'));
      Lino.cal.Calendars.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.cal.Calendars.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Invoices.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 37,
  initComponent : function() {
    var containing_panel = this;
    var id1205 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var date1206 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var partner1207 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Select a Partner...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/partner", "method": "GET" }) }), "name": "partner" });
    var user1208 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/user", "method": "GET" }) }) });
    var general_1_panel1209 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1205, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date1206, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1207, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1208, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var due_date1214 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Due date", "anchor": "-20", "name": "due_date" });
    var your_ref1215 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Your reference", "name": "your_ref", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var vat_regime1216 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "VAT Regime", "allowBlank": false, "hiddenName": "vat_regimeHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.vat.VatRegimes, "name": "vat_regime" });
    var general_2_panel1217 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": due_date1214, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": your_ref1215, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_regime1216, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var ItemsByInvoice_grid1229 = new Lino.ledger.ItemsByInvoice.GridPanel({ "flex": 75, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.ledger.ItemsByInvoice.grid) ], "preview_limit": 15, "master_panel": this });
    var total_base1230 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "Total excl. VAT", "name": "total_base", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var total_vat1231 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "VAT", "name": "total_vat", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var total_incl1232 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "Total incl. VAT", "name": "total_incl", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var workflow_buttons_disp1233 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Workflow", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var totals_panel1234 = new Ext.Panel({ "flex": 25, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_base1230, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_vat1231, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_incl1232, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp1233, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 144, "border": false, "labelAlign": "top" });
    var general_3_panel1239 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ ItemsByInvoice_grid1229, totals_panel1234 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "anchor": "-20", "labelAlign": "top" });
    var general_panel1240 = new Ext.Panel({ "autoHeight": true, "layout": "form", "title": "General", "items": [ general_1_panel1209, general_2_panel1217, general_3_panel1239 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "labelAlign": "top" });
    var journal1241 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Journal", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail)}, "emptyText": "Select a Journal...", "selectOnFocus": true, "hiddenName": "journalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/journal", "method": "GET" }) }), "name": "journal" });
    var year1242 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "year", "hiddenName": "yearHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var number1243 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "number", "anchor": "-20", "name": "number" });
    var narration1244 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Narration", "name": "narration", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var ledger_1_panel1245 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": journal1241, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": year1242, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": number1243, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": narration1244, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var MovementsByVoucher_grid1250 = new Lino.ledger.MovementsByVoucher.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.ledger.MovementsByVoucher.grid) ], "preview_limit": 15, "master_panel": this });
    var ledger_panel1251 = new Ext.Panel({ "layout": "vbox", "title": "Ledger", "items": [ ledger_1_panel1245, MovementsByVoucher_grid1250 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel1252 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1240, ledger_panel1251 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1252;
    this.before_row_edit = function(record) {
      ItemsByInvoice_grid1229.on_master_changed();
      MovementsByVoucher_grid1250.on_master_changed();
    }
    Lino.ledger.Invoices.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 56,
  initComponent : function() {
    var containing_panel = this;
    var summary110 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Summary", "name": "summary", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var user111 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var project112 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail)}, "emptyText": "Select a Project...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_2_panel113 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user111, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project112, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel116 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 153, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary110, "anchor": "-20", "labelAlign": "top" }, main_2_panel113 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel116;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Tasks.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.TextFieldTemplates.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 9,
  initComponent : function() {
    var containing_panel = this;
    var id223 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name224 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user225 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/user", "method": "GET" }) }) });
    var team226 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Team</span>", "name": "team", "pageSize": 20, "emptyText": "Select a Team...", "listeners": { "render": Lino.quicktip_renderer("Team","If not empty, then this template is reserved to members of this team.") }, "selectOnFocus": true, "hiddenName": "teamHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/team", "method": "GET" }) }) });
    var main_1_panel227 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id223, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name224, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user225, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": team226, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 108, "border": false, "frame": false, "labelAlign": "top" });
    var description232 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Description", "anchor": "-20 -10", "growMax": 2000, "name": "description" });
    var text233 = new Lino.RichTextPanel({ "flex": 5, "split": true, "containing_panel": this, "selectOnFocus": true, "region": "south", "title": "Template Text", "name": "text" });
    var main_panel234 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ main_1_panel227, { "flex": 5, "layout": "form", "xtype": "panel", "items": description232, "region": "center", "labelAlign": "top", "split": true }, text233 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel234;
    this.before_row_edit = function(record) {
      text233.refresh();
    }
    Lino.system.TextFieldTemplates.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.Mails.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 64,
  initComponent : function() {
    var containing_panel = this;
    var project1449 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail)}, "emptyText": "Select a Project...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var subject1450 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Subject", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var body1451 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 71, "containing_panel": this, "name": "body", "title": "Body" });
    var main_panel1452 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": project1449, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": subject1450, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, body1451 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1452;
    this.before_row_edit = function(record) {
      body1451.refresh();
    }
    Lino.outbox.Mails.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Invoices.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 37,
  initComponent : function() {
    var containing_panel = this;
    var partner1253 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Select a Partner...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/partner", "method": "GET" }) }), "name": "partner" });
    var date1254 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var total_incl1255 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "Total incl. VAT", "name": "total_incl", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var main_2_panel1256 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date1254, "labelAlign": "top" }, { "flex": 60, "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_incl1255, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 144, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1259 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1253, "anchor": "-20", "labelAlign": "top" }, main_2_panel1256 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1259;
    this.before_row_edit = function(record) {
    }
    Lino.ledger.Invoices.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.Sessions.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 51,
  initComponent : function() {
    var containing_panel = this;
    var date581 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var start_time582 = new Lino.TimeField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Start time", "anchor": "-20", "name": "start_time" });
    var end_time583 = new Lino.TimeField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "End Time", "anchor": "-20", "name": "end_time" });
    var break_time584 = new Lino.TimeField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Break Time", "anchor": "-20", "name": "break_time" });
    var project585 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail)}, "emptyText": "Select a Project...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Sessions/project", "method": "GET" }) }) });
    var ticket586 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Ticket", "name": "ticket", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Tickets.detail)}, "emptyText": "Select a Ticket...", "selectOnFocus": true, "hiddenName": "ticketHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Sessions/ticket", "method": "GET" }) }) });
    var main_1_panel587 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date581, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time582, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time583, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": break_time584, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project585, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ticket586, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user594 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Sessions/user", "method": "GET" }) }) });
    var id595 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_2_panel596 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 63, "hideCheckBoxLabels": true, "items": [ { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user594, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id595, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description599 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Description", "anchor": "-20 -10", "growMax": 2000, "name": "description" });
    var EntriesBySession_grid635 = new Lino.tickets.EntriesBySession.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.tickets.EntriesBySession.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel636 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ main_1_panel587, main_2_panel596, { "items": description599, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 41 }, EntriesBySession_grid635 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel636;
    this.before_row_edit = function(record) {
      EntriesBySession_grid635.on_master_changed();
    }
    Lino.tickets.Sessions.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 18,
  initComponent : function() {
    var containing_panel = this;
    var id700 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name701 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr702 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_et703 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_en704 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (en)", "name": "name_en", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var choicelist705 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Choices List", "name": "choicelist", "selectOnFocus": true, "anchor": "-20", "store": [ [ "countries.CityTypes", "CityTypes" ], [ "lino.Genders", "Genders" ], [ "lino.UserGroups", "User Groups" ], [ "lino.UserLevels", "User Levels" ], [ "lino.UserProfiles", "User Profiles" ], [ "lino.YesNo", "Yes or no" ], [ "properties.DoYouLike", "DoYouLike" ], [ "properties.HowWell", "HowWell" ] ], "hiddenName": "choicelistHidden" });
    var default_value706 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "default value", "name": "default_value", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropTypes/default_value", "method": "GET" }) }), "hiddenName": "default_valueHidden" });
    var main_1_panel707 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 4, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id700, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name701, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr702, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et703, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en704, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": choicelist705, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": default_value706, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 153, "border": false, "frame": false, "labelAlign": "top" });
    var ChoicesByType_grid722 = new Lino.properties.ChoicesByType.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.properties.ChoicesByType.grid) ] });
    var PropsByType_grid730 = new Lino.properties.PropsByType.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.properties.PropsByType.grid) ] });
    var main_panel731 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "hideCheckBoxLabels": true, "items": [ main_1_panel707, ChoicesByType_grid722, PropsByType_grid730 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel731;
    this.before_row_edit = function(record) {
      default_value706.setContextValue('choicelist',record ? record.data['choicelistHidden'] : undefined);
      ChoicesByType_grid722.on_master_changed();
      PropsByType_grid730.on_master_changed();
    }
    this.onRender = function(ct, position) {
      choicelist705.on('change',Lino.chooser_handler(default_value706,'choicelist'));
      Lino.properties.PropTypes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.properties.PropTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.Mails.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 64,
  initComponent : function() {
    var containing_panel = this;
    var subject1421 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Subject", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var project1422 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail)}, "emptyText": "Select a Project...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var date1423 = new Lino.DateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Date</span>", "name": "date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date","\n        The official date to be printed on the document.\n        ") }, "anchor": "-20" });
    var main_1_panel1424 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject1421, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1422, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date1423, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user1428 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Sender", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/user", "method": "GET" }) }) });
    var sent1429 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "sent", "name": "sent", "anchor": "-20", "value": "<br>" });
    var id1430 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var owner_disp1431 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Controlled by", "anchor": "-20", "name": "owner" });
    var main_2_panel1432 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1428, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent1429, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1430, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp1431, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var RecipientsByMail_grid1443 = new Lino.outbox.RecipientsByMail.GridPanel({ "flex": 55, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.RecipientsByMail.grid) ], "preview_limit": 15, "master_panel": this });
    var AttachmentsByMail_htmlbox1444 = new Lino.HtmlBoxPanel({ "flex": 22, "layout": "fit", "name": "AttachmentsByMail", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Attachments", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;", "tools": [ Lino.show_in_own_window_button(Lino.outbox.AttachmentsByMail.grid) ] });
    var UploadsByController_htmlbox1445 = new Lino.HtmlBoxPanel({ "flex": 22, "ls_bbar_actions": [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;", "ls_insert_handler": Lino.uploads.UploadsByController.insert, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var main_3_panel1446 = new Ext.Panel({ "flex": 29, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ RecipientsByMail_grid1443, AttachmentsByMail_htmlbox1444, UploadsByController_htmlbox1445 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var body1447 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 58, "containing_panel": this, "name": "body", "title": "Body" });
    var main_panel1448 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel1424, main_2_panel1432, main_3_panel1446, body1447 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1448;
    this.before_row_edit = function(record) {
      RecipientsByMail_grid1443.on_master_changed();
      AttachmentsByMail_htmlbox1444.refresh();
      UploadsByController_htmlbox1445.refresh();
      body1447.refresh();
    }
    Lino.outbox.Mails.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.Home.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var quick_links_htmlbox1822 = new Lino.HtmlBoxPanel({ "flex": 1, "layout": "fit", "name": "quick_links", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "north", "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;", "split": true });
    var welcome_htmlbox1823 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "welcome", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "center", "title": "Welcome", "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;", "split": true });
    var main_panel1824 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ quick_links_htmlbox1822, welcome_htmlbox1823 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1824;
    this.before_row_edit = function(record) {
      quick_links_htmlbox1822.refresh();
      welcome_htmlbox1823.refresh();
    }
    Lino.system.Home.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.products.ProductCats.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 30,
  initComponent : function() {
    var containing_panel = this;
    var id1088 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1089 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1090 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_et1091 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_en1092 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (en)", "name": "name_en", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1093 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1088, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1089, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1090, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1091, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1092, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 153, "border": false, "frame": false, "labelAlign": "top" });
    var description1099 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "description", "anchor": "-20 -10", "growMax": 2000, "name": "description" });
    var ProductsByCategory_grid1145 = new Lino.products.ProductsByCategory.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "preview_limit": 15, "master_panel": this, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.products.ProductsByCategory.grid) ] });
    var main_panel1146 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ main_1_panel1093, { "flex": 5, "layout": "form", "xtype": "panel", "items": description1099, "region": "center", "labelAlign": "top", "split": true }, ProductsByCategory_grid1145 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1146;
    this.before_row_edit = function(record) {
      ProductsByCategory_grid1145.on_master_changed();
    }
    Lino.products.ProductCats.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Countries.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 14,
  initComponent : function() {
    var containing_panel = this;
    var isocode244 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">ISO code</span>", "name": "isocode", "boxMinWidth": Lino.chars2width(4), "listeners": { "render": Lino.quicktip_renderer("ISO code","        The two-letter code for this country as defined by ISO 3166-1. \n        For countries that no longer exist it may be a 4-letter code.") }, "maxLength": 4, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name245 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr246 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_et247 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_en248 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (en)", "name": "name_en", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var short_code249 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Short code</span>", "name": "short_code", "boxMinWidth": Lino.chars2width(4), "listeners": { "render": Lino.quicktip_renderer("Short code","A short abbreviation for regional usage. Obsolete.") }, "maxLength": 4, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel250 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": isocode244, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name245, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr246, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et247, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en248, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": short_code249, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var countries_CitiesByCountry_grid678 = new Lino.countries.CitiesByCountry.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.countries.CitiesByCountry.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel679 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel250, countries_CitiesByCountry_grid678 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel679;
    this.before_row_edit = function(record) {
      countries_CitiesByCountry_grid678.on_master_changed();
    }
    Lino.countries.Countries.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 24,
  initComponent : function() {
    var containing_panel = this;
    var name341 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var country342 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Select a Country...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }) });
    var region343 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }) });
    var city344 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }) });
    var zip_code345 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Zip code", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_2_panel346 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country342, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region343, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city344, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code345, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr1351 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line before street</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Address line before street","Address line before street") }, "anchor": "-20" });
    var street_prefix352 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street prefix</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Street prefix","Text to print before name of street, but to ignore for sorting.") }, "anchor": "-20" });
    var street353 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Street","Name of street. Without house number.") }, "anchor": "-20" });
    var street_no354 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("No.","House number") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var street_box355 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var address_box_4_panel356 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix352, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street353, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no354, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box355, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2361 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line after street</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Address line after street","Address line to print below street line") }, "anchor": "-20" });
    var address_box_panel362 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "layout": "form", "title": "Address", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name341, "anchor": "-20", "labelAlign": "top" }, address_box_2_panel346, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1351, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel356, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2361, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 243, "border": false, "labelAlign": "top" });
    var id366 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language367 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ], [ "en", "English" ] ], "name": "language" });
    var info_box_panel368 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id366, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language367, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email371 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var url372 = new Lino.URLField({ "autoHeight": true, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var phone373 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Phone", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gsm374 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var fax375 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var contact_box_5_panel376 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm374, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax375, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel379 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "layout": "form", "title": "Contact", "items": [ info_box_panel368, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email371, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url372, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone373, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel376 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var general_1_panel383 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ address_box_panel362, contact_box_panel379 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks384 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarks", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var is_person385 = new Ext.form.Checkbox({ "boxLabel": "is Person (<a href=\"javascript:Lino.show_mti_child('is_person',Lino.contacts.Persons.detail)\">show</a>)", "autoHeight": true, "hideLabel": true, "name": "is_person", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("is Person","Whether this Partner is a Person.") }, "anchor": "-20" });
    var is_company386 = new Ext.form.Checkbox({ "boxLabel": "is Company (<a href=\"javascript:Lino.show_mti_child('is_company',Lino.contacts.Companies.detail)\">show</a>)", "autoHeight": true, "hideLabel": true, "name": "is_company", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("is Company","Whether this Partner is a Company.") }, "anchor": "-20" });
    var bottom_box_2_panel387 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_person385, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_company386, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var bottom_box_panel390 = new Ext.Panel({ "flex": 54, "layout": "vbox", "items": [ { "items": remarks384, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 }, bottom_box_2_panel387 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var general_panel392 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel383, bottom_box_panel390 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var invoicing_address393 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Invoicing address", "name": "invoicing_address", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "hiddenName": "invoicing_addressHidden", "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/invoicing_address", "method": "GET" }) }) });
    var vat_regime394 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">VAT Regime</span>", "name": "vat_regime", "hiddenName": "vat_regimeHidden", "listeners": { "render": Lino.quicktip_renderer("VAT Regime","The default VAT regime for sales to this customer.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var imode395 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Invoicing Mode", "name": "imode", "pageSize": 20, "emptyText": "Select a Invoicing Mode...", "selectOnFocus": true, "hiddenName": "imodeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/imode", "method": "GET" }) }) });
    var payment_term396 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Payment Term</span>", "name": "payment_term", "pageSize": 20, "emptyText": "Select a Payment Term...", "listeners": { "render": Lino.quicktip_renderer("Payment Term","The default payment term for sales invoices to this customer.") }, "selectOnFocus": true, "hiddenName": "payment_termHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/payment_term", "method": "GET" }) }) });
    var sales_1_panel397 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 162, "hideCheckBoxLabels": true, "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invoicing_address393, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_regime394, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": imode395, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": payment_term396, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var sales_InvoicesByPartner_grid531 = new Lino.sales.InvoicesByPartner.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.sales.InvoicesByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var sales_panel532 = new Ext.Panel({ "layout": "vbox", "title": "Sales", "items": [ sales_1_panel397, sales_InvoicesByPartner_grid531 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var tickets_TicketsByPartner_grid663 = new Lino.tickets.TicketsByPartner.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Tickets", "tools": [ Lino.show_in_own_window_button(Lino.tickets.TicketsByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel664 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel392, sales_panel532, tickets_TicketsByPartner_grid663 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel664;
    this.before_row_edit = function(record) {
      region343.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city344.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city344.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      sales_InvoicesByPartner_grid531.on_master_changed();
      tickets_TicketsByPartner_grid663.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country342.on('change',Lino.chooser_handler(region343,'country'));
      country342.on('change',Lino.chooser_handler(city344,'country'));
      region343.on('change',Lino.chooser_handler(city344,'region'));
      Lino.contacts.Partners.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Partners.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.Tickets.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 53,
  initComponent : function() {
    var containing_panel = this;
    var summary656 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Summary</span>", "name": "summary", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Summary","Short summary of the problem.") }, "anchor": "-20" });
    var partner657 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Partner</span>", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "hiddenName": "partnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","The partner who reported this ticket.") }, "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/partner", "method": "GET" }) }) });
    var project658 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail)}, "emptyText": "Select a Project...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/project", "method": "GET" }) }) });
    var main_panel659 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary656, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner657, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": project658, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel659;
    this.before_row_edit = function(record) {
    }
    Lino.tickets.Tickets.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 24,
  initComponent : function() {
    var containing_panel = this;
    var name665 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language666 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ], [ "en", "English" ] ], "name": "language" });
    var email667 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel668 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language666, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email667, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel671 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name665, "anchor": "-20", "labelAlign": "top" }, main_2_panel668 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel671;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Partners.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Rooms.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 57,
  initComponent : function() {
    var containing_panel = this;
    var id1694 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1695 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1696 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_et1697 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_en1698 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (en)", "name": "name_en", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1699 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1694, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1695, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1696, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1697, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1698, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_EventsByRoom_grid1730 = new Lino.cal.EventsByRoom.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByRoom.grid) ], "master_panel": this, "preview_limit": 15 });
    var main_panel1731 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1699, cal_EventsByRoom_grid1730 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1731;
    this.before_row_edit = function(record) {
      cal_EventsByRoom_grid1730.on_master_changed();
    }
    Lino.cal.Rooms.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 56,
  initComponent : function() {
    var containing_panel = this;
    var start_date83 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Start date", "anchor": "-20", "name": "start_date" });
    var due_date84 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Due date", "anchor": "-20", "name": "due_date" });
    var id85 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var workflow_buttons_disp86 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Workflow", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel87 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date83, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": due_date84, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id85, "labelAlign": "top" }, { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp86, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var summary92 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Summary", "name": "summary", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var user93 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var project94 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail)}, "emptyText": "Select a Project...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_3_panel95 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user93, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project94, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var calendar98 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Calendar", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Select a Calendar...", "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/calendar", "method": "GET" }) }) });
    var owner_disp99 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Controlled by", "anchor": "-20", "name": "owner" });
    var created100 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified101 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "anchor": "-20", "value": "<br>" });
    var main_4_panel102 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar98, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp99, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created100, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified101, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description107 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 45, "containing_panel": this, "name": "description", "title": "Description" });
    var main_panel108 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ main_1_panel87, { "items": summary92, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, main_3_panel95, main_4_panel102, description107 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel108;
    this.before_row_edit = function(record) {
      description107.refresh();
    }
    Lino.cal.Tasks.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 21,
  initComponent : function() {
    var containing_panel = this;
    var name898 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language899 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ], [ "en", "English" ] ], "name": "language" });
    var email900 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel901 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language899, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email900, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type904 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Company type", "name": "type", "pageSize": 20, "emptyText": "Select a company type...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var id905 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_3_panel906 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type904, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id905, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel909 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name898, "anchor": "-20", "labelAlign": "top" }, main_2_panel901, main_3_panel906 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel909;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Companies.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 21,
  initComponent : function() {
    var containing_panel = this;
    var prefix824 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "prefix", "name": "prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name825 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_box_panel826 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix824, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name825, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var country829 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Select a Country...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/country", "method": "GET" }) }) });
    var region830 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/region", "method": "GET" }) }) });
    var city831 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/city", "method": "GET" }) }) });
    var zip_code832 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Zip code", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_2_panel833 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country829, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region830, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city831, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code832, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr1838 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line before street</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Address line before street","Address line before street") }, "anchor": "-20" });
    var street_prefix839 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street prefix</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Street prefix","Text to print before name of street, but to ignore for sorting.") }, "anchor": "-20" });
    var street840 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Street","Name of street. Without house number.") }, "anchor": "-20" });
    var street_no841 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("No.","House number") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var street_box842 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var address_box_4_panel843 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix839, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street840, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no841, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box842, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2848 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line after street</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Address line after street","Address line to print below street line") }, "anchor": "-20" });
    var address_box_panel849 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "layout": "form", "title": "Address", "items": [ name_box_panel826, address_box_2_panel833, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1838, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel843, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2848, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 243, "border": false, "labelAlign": "top" });
    var id852 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language853 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ], [ "en", "English" ] ], "name": "language" });
    var info_box_panel854 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id852, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language853, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email857 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var url858 = new Lino.URLField({ "autoHeight": true, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var phone859 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Phone", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gsm860 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var fax861 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var contact_box_5_panel862 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm860, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax861, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel865 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "layout": "form", "title": "Contact", "items": [ info_box_panel854, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email857, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url858, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone859, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel862 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var general_1_panel869 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ address_box_panel849, contact_box_panel865 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var type870 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Company type", "name": "type", "pageSize": 20, "emptyText": "Select a company type...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var vat_id871 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "VAT id", "name": "vat_id", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var bottom_box_1_panel872 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type870, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id871, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks875 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarks", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var contacts_RolesByCompany_grid880 = new Lino.contacts.RolesByCompany.GridPanel({ "flex": 42, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.grid) ], "preview_limit": 15, "master_panel": this });
    var bottom_box_2_panel881 = new Ext.Panel({ "flex": 83, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": remarks875, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 57 }, contacts_RolesByCompany_grid880 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var bottom_box_panel883 = new Ext.Panel({ "flex": 54, "border": false, "layout": "vbox", "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ bottom_box_1_panel872, bottom_box_2_panel881 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": true, "labelAlign": "top" });
    var general_panel884 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel869, bottom_box_panel883 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var invoicing_address885 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Invoicing address", "name": "invoicing_address", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "hiddenName": "invoicing_addressHidden", "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/invoicing_address", "method": "GET" }) }) });
    var vat_regime886 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">VAT Regime</span>", "name": "vat_regime", "hiddenName": "vat_regimeHidden", "listeners": { "render": Lino.quicktip_renderer("VAT Regime","The default VAT regime for sales to this customer.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var imode887 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Invoicing Mode", "name": "imode", "pageSize": 20, "emptyText": "Select a Invoicing Mode...", "selectOnFocus": true, "hiddenName": "imodeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/imode", "method": "GET" }) }) });
    var payment_term888 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Payment Term</span>", "name": "payment_term", "pageSize": 20, "emptyText": "Select a Payment Term...", "listeners": { "render": Lino.quicktip_renderer("Payment Term","The default payment term for sales invoices to this customer.") }, "selectOnFocus": true, "hiddenName": "payment_termHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/payment_term", "method": "GET" }) }) });
    var sales_1_panel889 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 162, "hideCheckBoxLabels": true, "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invoicing_address885, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_regime886, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": imode887, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": payment_term888, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var sales_InvoicesByPartner_grid894 = new Lino.sales.InvoicesByPartner.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.sales.InvoicesByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var sales_panel895 = new Ext.Panel({ "layout": "vbox", "title": "Sales", "items": [ sales_1_panel889, sales_InvoicesByPartner_grid894 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var tickets_TicketsByPartner_grid896 = new Lino.tickets.TicketsByPartner.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Tickets", "tools": [ Lino.show_in_own_window_button(Lino.tickets.TicketsByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel897 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel884, sales_panel895, tickets_TicketsByPartner_grid896 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel897;
    this.before_row_edit = function(record) {
      region830.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city831.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city831.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByCompany_grid880.on_master_changed();
      sales_InvoicesByPartner_grid894.on_master_changed();
      tickets_TicketsByPartner_grid896.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country829.on('change',Lino.chooser_handler(region830,'country'));
      country829.on('change',Lino.chooser_handler(city831,'country'));
      region830.on('change',Lino.chooser_handler(city831,'region'));
      Lino.contacts.Companies.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Companies.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.Report.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var body_htmlbox1820 = new Lino.HtmlBoxPanel({ "bodyStyle": "overflow-x:hidden;", "layout": "fit", "name": "body", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "value": "<br/>", "always_enabled": true });
    var main_panel1821 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ body_htmlbox1820 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1821;
    this.before_row_edit = function(record) {
      body_htmlbox1820.refresh();
    }
    Lino.lino.Report.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Journals.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 35,
  initComponent : function() {
    var containing_panel = this;
    var ref1189 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "ref", "name": "ref", "maxLength": 20, "selectOnFocus": true, "anchor": "-20" });
    var name1190 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1191 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_et1192 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_en1193 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (en)", "name": "name_en", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1194 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1189, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1190, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1191, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1192, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1193, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var trade_type1200 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Trade Type", "name": "trade_type", "hiddenName": "trade_typeHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.vat.TradeTypes) });
    var voucher_type1201 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "voucher type", "allowBlank": false, "hiddenName": "voucher_typeHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.ledger.VoucherTypes, "name": "voucher_type" });
    var main_panel1202 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 117, "autoScroll": false, "items": [ main_1_panel1194, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": trade_type1200, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": voucher_type1201, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1202;
    this.before_row_edit = function(record) {
    }
    Lino.ledger.Journals.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.sales.Invoices.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 43,
  initComponent : function() {
    var containing_panel = this;
    var partner523 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Select a Partner...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/partner", "method": "GET" }) }), "name": "partner" });
    var date524 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel525 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner523, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date524, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var subject528 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Subject line", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_panel529 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 117, "autoScroll": false, "items": [ main_1_panel525, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject528, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel529;
    this.before_row_edit = function(record) {
    }
    Lino.sales.Invoices.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.Users.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 11,
  initComponent : function() {
    var containing_panel = this;
    var username1 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Username</span>", "name": "username", "listeners": { "render": Lino.quicktip_renderer("Benutzername","Required. Must be unique.") }, "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var profile2 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">User Profile</span>", "name": "profile", "hiddenName": "profileHidden", "listeners": { "render": Lino.quicktip_renderer("Benutzerprofil","Users with an empty `profile` field are considered inactive and cannot log in.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var partner3 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "hiddenName": "partnerHidden", "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var box1_1_panel4 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username1, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile2, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner3, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name8 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "First name", "name": "first_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var last_name9 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Last name", "name": "last_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var initials10 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Initials", "name": "initials", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var box1_2_panel11 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name8, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name9, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": initials10, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email15 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "e-mail address", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var language16 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Language", "name": "language", "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ], [ "en", "English" ] ], "hiddenName": "languageHidden" });
    var box1_3_panel17 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email15, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language16, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var id20 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var created21 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified22 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "anchor": "-20", "value": "<br>" });
    var box1_4_panel23 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id20, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created21, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified22, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box1_panel27 = new Ext.Panel({ "flex": 66, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ box1_1_panel4, box1_2_panel11, box1_3_panel17, box1_4_panel23 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var MembershipsByUser_grid30 = new Lino.users.MembershipsByUser.GridPanel({ "flex": 33, "hide_top_toolbar": true, "containing_panel": this, "master_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.users.MembershipsByUser.grid) ], "hideHeaders": true, "preview_limit": 15 });
    var general_1_panel31 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box1_panel27, MembershipsByUser_grid30 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks32 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarks", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var AuthoritiesGiven_grid35 = new Lino.users.AuthoritiesGiven.GridPanel({ "flex": 33, "hide_top_toolbar": true, "containing_panel": this, "master_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.users.AuthoritiesGiven.grid) ], "hideHeaders": true, "preview_limit": 15 });
    var general_2_panel36 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": remarks32, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 66 }, AuthoritiesGiven_grid35 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel38 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel31, general_2_panel36 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var calendar39 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Default calendar</span>", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Select a Calendar...", "listeners": { "render": Lino.quicktip_renderer("Standard-Kalender","The default calendar for your events and tasks.") }, "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/calendar", "method": "GET" }) }) });
    var access_class40 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Default access class</span>", "allowBlank": false, "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Standardm\u00e4\u00dfige Zugriffsklasse","Die standardm\u00e4\u00dfige Zugriffsklasse f\u00fcr Ihre Termine und Aufgaben") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.AccessClasses, "name": "access_class" });
    var cal_left_1_panel41 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 270, "hideCheckBoxLabels": true, "items": [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar39, "labelAlign": "top" }, { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class40, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_SubscriptionsByUser_grid48 = new Lino.cal.SubscriptionsByUser.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.SubscriptionsByUser.grid) ], "preview_limit": 15, "master_panel": this });
    var cal_left_panel49 = new Ext.Panel({ "flex": 33, "border": false, "layout": "vbox", "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ cal_left_1_panel41, cal_SubscriptionsByUser_grid48 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": true, "labelAlign": "top" });
    var cal_TasksByUser_grid118 = new Lino.cal.TasksByUser.GridPanel({ "flex": 66, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByUser.grid) ], "preview_limit": 15, "master_panel": this });
    var cal_1_panel119 = new Ext.Panel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "layout": "hbox", "title": "Calendar", "hideCheckBoxLabels": true, "items": [ cal_left_panel49, cal_TasksByUser_grid118 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel120 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel38, cal_1_panel119 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel120;
    this.before_row_edit = function(record) {
      MembershipsByUser_grid30.on_master_changed();
      AuthoritiesGiven_grid35.on_master_changed();
      cal_SubscriptionsByUser_grid48.on_master_changed();
      cal_TasksByUser_grid118.on_master_changed();
    }
    Lino.users.Users.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    partner3.on("change",function(){this.save()},this);
  }
});


Lino.cal.Events.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 62,
  initComponent : function() {
    var containing_panel = this;
    var calendar1645 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Calendar", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Select a Calendar...", "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/calendar", "method": "GET" }) }) });
    var summary1646 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Summary", "name": "summary", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1647 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar1645, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary1646, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var start_date1650 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Start date", "anchor": "-20", "name": "start_date" });
    var start_time1651 = new Lino.TimeField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Start time", "anchor": "-20", "name": "start_time" });
    var start_panel1652 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1650, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time1651, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var end_date1655 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "End Date", "anchor": "-20", "name": "end_date" });
    var end_time1656 = new Lino.TimeField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "End Time", "anchor": "-20", "name": "end_time" });
    var end_panel1657 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1655, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time1656, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var main_2_panel1660 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ start_panel1652, end_panel1657 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "anchor": "-20", "labelAlign": "top" });
    var room1661 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Room", "name": "room", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Rooms.detail)}, "emptyText": "Select a Room...", "selectOnFocus": true, "hiddenName": "roomHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/room", "method": "GET" }) }) });
    var priority1662 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Priority", "name": "priority", "pageSize": 20, "emptyText": "Select a Priority...", "selectOnFocus": true, "hiddenName": "priorityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/priority", "method": "GET" }) }) });
    var access_class1663 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Access Class</span>", "name": "access_class", "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Access Class","Whether this is private, public or between.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var transparent1664 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "transparent", "listeners": { "render": Lino.quicktip_renderer("Transparent","Indicates that this Event shouldn't prevent other Events at the same time.") }, "boxLabel": "Transparent", "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel1665 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": room1661, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": priority1662, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class1663, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": transparent1664, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1670 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1647, main_2_panel1660, main_3_panel1665 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1670;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Events.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.TextFieldTemplates.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 9,
  initComponent : function() {
    var containing_panel = this;
    var name236 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user237 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/user", "method": "GET" }) }) });
    var team238 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Team</span>", "name": "team", "pageSize": 20, "emptyText": "Select a Team...", "listeners": { "render": Lino.quicktip_renderer("Team","If not empty, then this template is reserved to members of this team.") }, "selectOnFocus": true, "hiddenName": "teamHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/team", "method": "GET" }) }) });
    var main_2_panel239 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user237, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": team238, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel242 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 108, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name236, "anchor": "-20", "labelAlign": "top" }, main_2_panel239 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel242;
    this.before_row_edit = function(record) {
    }
    Lino.system.TextFieldTemplates.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Calendars.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 61,
  initComponent : function() {
    var containing_panel = this;
    var name1679 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1680 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_et1681 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_en1682 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (en)", "name": "name_en", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1683 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1679, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1680, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1681, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1682, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type1688 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Type", "allowBlank": false, "value": "local", "hiddenName": "typeHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "local", "Local Calendar" ], [ "google", "Google Calendar" ] ], "name": "type" });
    var color1689 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "color", "name": "color", "selectOnFocus": true, "anchor": "-20", "value": 1, "allowBlank": false });
    var main_2_panel1690 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1688, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": color1689, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 54, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1693 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1683, main_2_panel1690 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1693;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Calendars.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 22,
  initComponent : function() {
    var containing_panel = this;
    var title811 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Title</span>", "name": "title", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Title","Text to print before first_name as part of the first address line.") }, "anchor": "-20" });
    var first_name812 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "First name", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var last_name813 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Last name", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel814 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title811, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name812, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name813, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gender818 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Gender", "name": "gender", "hiddenName": "genderHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var language819 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ], [ "en", "English" ] ], "name": "language" });
    var main_2_panel820 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender818, "labelAlign": "top" }, { "flex": 64, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language819, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel823 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel814, main_2_panel820 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel823;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Persons.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 22,
  initComponent : function() {
    var containing_panel = this;
    var last_name732 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Last name", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var first_name733 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "First name", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_box_1_panel734 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name732, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name733, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gender737 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Gender", "name": "gender", "hiddenName": "genderHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var title738 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Title</span>", "name": "title", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Title","Text to print before first_name as part of the first address line.") }, "anchor": "-20" });
    var birth_date739 = new Lino.IncompleteDateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Birth date</span>", "name": "birth_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Birth date","Unkomplette Datumsangaben sind erlaubt, z.B. \"00.00.1980\" hei\u00dft \"irgendwann im Jahr 1980\", \"00.07.1980\" hei\u00dft \"im Juli 1980\"oder \"23.07.0000\" hei\u00dft \"an einem 23. Juli\".") }, "anchor": "-20" });
    var name_box_2_panel740 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender737, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title738, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date739, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var name_box_panel744 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ name_box_1_panel734, name_box_2_panel740 ], "frame": true, "bodyBorder": false, "anchor": "-20", "labelAlign": "top" });
    var country745 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Select a Country...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/country", "method": "GET" }) }) });
    var region746 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/region", "method": "GET" }) }) });
    var city747 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/city", "method": "GET" }) }) });
    var zip_code748 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Zip code", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_2_panel749 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country745, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region746, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city747, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code748, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr1754 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line before street</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Address line before street","Address line before street") }, "anchor": "-20" });
    var street_prefix755 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street prefix</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Street prefix","Text to print before name of street, but to ignore for sorting.") }, "anchor": "-20" });
    var street756 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Street","Name of street. Without house number.") }, "anchor": "-20" });
    var street_no757 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("No.","House number") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var street_box758 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var address_box_4_panel759 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix755, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street756, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no757, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box758, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2764 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line after street</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Address line after street","Address line to print below street line") }, "anchor": "-20" });
    var address_box_panel765 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "layout": "form", "title": "Address", "items": [ name_box_panel744, address_box_2_panel749, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1754, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel759, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2764, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 243, "border": false, "labelAlign": "top" });
    var id768 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language769 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ], [ "en", "English" ] ], "name": "language" });
    var info_box_1_panel770 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id768, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language769, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var age_disp773 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Age", "name": "age", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var info_box_panel774 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ info_box_1_panel770, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": age_disp773, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email776 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var url777 = new Lino.URLField({ "autoHeight": true, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var phone778 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Phone", "name": "phone", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var gsm779 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var fax780 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var contact_box_5_panel781 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm779, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax780, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel784 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "layout": "form", "title": "Contact", "items": [ info_box_panel774, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email776, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url777, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone778, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel781 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var general_1_panel788 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ address_box_panel765, contact_box_panel784 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks789 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarks", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var contacts_RolesByPerson_grid794 = new Lino.contacts.RolesByPerson.GridPanel({ "flex": 42, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByPerson.grid) ], "preview_limit": 15, "master_panel": this });
    var bottom_box_panel795 = new Ext.Panel({ "flex": 38, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": remarks789, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 57 }, contacts_RolesByPerson_grid794 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel797 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel788, bottom_box_panel795 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var invoicing_address798 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Invoicing address", "name": "invoicing_address", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "hiddenName": "invoicing_addressHidden", "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/invoicing_address", "method": "GET" }) }) });
    var vat_regime799 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">VAT Regime</span>", "name": "vat_regime", "hiddenName": "vat_regimeHidden", "listeners": { "render": Lino.quicktip_renderer("VAT Regime","The default VAT regime for sales to this customer.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var imode800 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Invoicing Mode", "name": "imode", "pageSize": 20, "emptyText": "Select a Invoicing Mode...", "selectOnFocus": true, "hiddenName": "imodeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/imode", "method": "GET" }) }) });
    var payment_term801 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Payment Term</span>", "name": "payment_term", "pageSize": 20, "emptyText": "Select a Payment Term...", "listeners": { "render": Lino.quicktip_renderer("Payment Term","The default payment term for sales invoices to this customer.") }, "selectOnFocus": true, "hiddenName": "payment_termHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/payment_term", "method": "GET" }) }) });
    var sales_1_panel802 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 162, "hideCheckBoxLabels": true, "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invoicing_address798, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_regime799, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": imode800, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": payment_term801, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var sales_InvoicesByPartner_grid807 = new Lino.sales.InvoicesByPartner.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.sales.InvoicesByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var sales_panel808 = new Ext.Panel({ "layout": "vbox", "title": "Sales", "items": [ sales_1_panel802, sales_InvoicesByPartner_grid807 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var tickets_TicketsByPartner_grid809 = new Lino.tickets.TicketsByPartner.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Tickets", "tools": [ Lino.show_in_own_window_button(Lino.tickets.TicketsByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel810 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel797, sales_panel808, tickets_TicketsByPartner_grid809 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel810;
    this.before_row_edit = function(record) {
      region746.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city747.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city747.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByPerson_grid794.on_master_changed();
      sales_InvoicesByPartner_grid807.on_master_changed();
      tickets_TicketsByPartner_grid809.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country745.on('change',Lino.chooser_handler(region746,'country'));
      country745.on('change',Lino.chooser_handler(city747,'country'));
      region746.on('change',Lino.chooser_handler(city747,'region'));
      Lino.contacts.Persons.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Persons.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropGroups.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 17,
  initComponent : function() {
    var containing_panel = this;
    var id680 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name681 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr682 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_et683 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_en684 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (en)", "name": "name_en", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel685 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id680, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name681, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr682, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et683, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en684, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var PropsByGroup_grid698 = new Lino.properties.PropsByGroup.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.properties.PropsByGroup.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel699 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel685, PropsByGroup_grid698 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel699;
    this.before_row_edit = function(record) {
      PropsByGroup_grid698.on_master_changed();
    }
    Lino.properties.PropGroups.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.Tickets.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 53,
  initComponent : function() {
    var containing_panel = this;
    var summary544 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Summary</span>", "name": "summary", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Summary","Short summary of the problem.") }, "anchor": "-20" });
    var partner545 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Partner</span>", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "hiddenName": "partnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","The partner who reported this ticket.") }, "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/partner", "method": "GET" }) }) });
    var project546 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail)}, "emptyText": "Select a Project...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/project", "method": "GET" }) }) });
    var reported547 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Reported for</span>", "name": "reported", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Milestones.detail)}, "emptyText": "Select a Milestone...", "listeners": { "render": Lino.quicktip_renderer("Reported for","Milestone for which this ticket has been reported.") }, "selectOnFocus": true, "hiddenName": "reportedHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/reported", "method": "GET" }) }) });
    var id548 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_1_panel549 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary544, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner545, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project546, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": reported547, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id548, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user555 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/user", "method": "GET" }) }) });
    var created556 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified557 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "anchor": "-20", "value": "<br>" });
    var state558 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "State", "name": "state", "hiddenName": "stateHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.tickets.TicketStates) });
    var workflow_buttons_disp559 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Workflow", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var fixed560 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Fixed for</span>", "name": "fixed", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Milestones.detail)}, "emptyText": "Select a Milestone...", "listeners": { "render": Lino.quicktip_renderer("Fixed for","The milestone for which this ticket has been fixed.") }, "selectOnFocus": true, "hiddenName": "fixedHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/fixed", "method": "GET" }) }) });
    var main_2_panel561 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user555, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created556, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified557, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state558, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp559, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fixed560, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description568 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Description", "anchor": "-20 -10", "growMax": 2000, "name": "description" });
    var SessionsByTicket_grid638 = new Lino.tickets.SessionsByTicket.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.tickets.SessionsByTicket.grid) ], "preview_limit": 15, "master_panel": this });
    var EntriesByTicket_grid652 = new Lino.tickets.EntriesByTicket.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.tickets.EntriesByTicket.grid) ], "preview_limit": 15, "master_panel": this });
    var main_4_panel653 = new Ext.Panel({ "flex": 35, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ SessionsByTicket_grid638, EntriesByTicket_grid652 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel654 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ main_1_panel549, main_2_panel561, { "items": description568, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 35 }, main_4_panel653 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel654;
    this.before_row_edit = function(record) {
      reported547.setContextValue('project',record ? record.data['projectHidden'] : undefined);
      fixed560.setContextValue('project',record ? record.data['projectHidden'] : undefined);
      SessionsByTicket_grid638.on_master_changed();
      EntriesByTicket_grid652.on_master_changed();
    }
    this.onRender = function(ct, position) {
      project546.on('change',Lino.chooser_handler(reported547,'project'));
      project546.on('change',Lino.chooser_handler(fixed560,'project'));
      Lino.tickets.Tickets.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.tickets.Tickets.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.About.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var server_status_disp140 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Server status", "name": "server_status", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_panel141 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "html": "<div class=\"htmlText\"><span>Dies ist <a href=\"http://www.lino-framework.org/autodoc/lino.projects.presto\" target=\"_blank\">Lino Presto</a> 0.1 unter <a href=\"http://www.lino-framework.org\" target=\"_blank\">Lino</a> 1.6.12, <a href=\"http://north.lino-framework.org\" target=\"_blank\">North</a> 0.1.7, <a href=\"http://site.lino-framework.org\" target=\"_blank\">djangosite</a> 0.1.8, <a href=\"http://www.djangoproject.com\" target=\"_blank\">Django</a> 1.5.1, <a href=\"http://www.python.org/\" target=\"_blank\">Python</a> 2.7.3, <a href=\"http://babel.edgewall.org/\" target=\"_blank\">Babel</a> 1.0, <a href=\"http://jinja.pocoo.org/\" target=\"_blank\">Jinja</a> 2.6, <a href=\"http://sphinx-doc.org/\" target=\"_blank\">Sphinx</a> 1.2b1, <a href=\"http://labix.org/python-dateutil\" target=\"_blank\">python-dateutil</a> 2.1, <a href=\"http://pypi.python.org/pypi/odfpy\" target=\"_blank\">OdfPy</a> ODFPY/0.9.6, <a href=\"http://docutils.sourceforge.net/\" target=\"_blank\">docutils</a> 0.8.1, <a href=\"https://fedorahosted.org/suds/\" target=\"_blank\">suds</a> 0.4, <a href=\"http://pyyaml.org/\" target=\"_blank\">PyYaml</a> 3.10, <a href=\"http://appyframework.org/pod.html\" target=\"_blank\">Appy</a> 0.8.3 (2013/02/22 15:29), <a href=\"http://www.sencha.com\" target=\"_blank\">ExtJS</a> <a href=\"#\" onclick=\"alert('ExtJS client version is ' + Ext.version);\" title=\"Click to see ExtJS client version\">(version)</a>, <a href=\"http://ext.ensible.com/products/calendar/\" target=\"_blank\">Extensible</a> <a href=\"#\" onclick=\"alert('Extensible Calendar version is ' + Ext.ensible.version);\" title=\"Click to see Extensible Calendar version\">(version)</a>, <a href=\"http://www.famfamfam.com/lab/icons/silk/\" target=\"_blank\">Silk Icons</a> 1.3</span><p>Server l&#228;uft seit : <b>Montag, 7. Oktober 2013 um 02:17:54.510425</b></p><p>Source timestamps:</p><ul><li>lino : <b>Montag, 7. Oktober 2013 um 02:17:20.707048</b></li><li>atelier : <b>Freitag, 4. Oktober 2013 um 21:27:04.068617</b></li><li>north : <b>Dienstag, 1. Oktober 2013 um 17:02:09.178944</b></li><li>djangosite : <b>Sonntag, 15. September 2013 um 15:07:52.398691</b></li><li>django : <b>Freitag, 30. August 2013 um 13:02:10.834631</b></li></ul></div>", "xtype": "label" }, { "items": server_status_disp140, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel141;
    this.before_row_edit = function(record) {
    }
    Lino.about.About.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.Projects.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 50,
  initComponent : function() {
    var containing_panel = this;
    var ref1300 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Reference", "name": "ref", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var name1301 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var parent1302 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Parent", "name": "parent", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail)}, "emptyText": "Select a Project...", "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Projects/parent", "method": "GET" }) }) });
    var general_1_panel1303 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1300, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1301, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent1302, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var type1307 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Project Type", "name": "type", "pageSize": 20, "emptyText": "Select a Project Type...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Projects/type", "method": "GET" }) }) });
    var user1308 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Projects/user", "method": "GET" }) }) });
    var general_2_panel1309 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1307, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1308, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description1312 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Description", "anchor": "-20 -10", "growMax": 2000, "name": "description" });
    var ProjectsByProject_grid1370 = new Lino.tickets.ProjectsByProject.GridPanel({ "flex": 66, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.tickets.ProjectsByProject.grid) ], "preview_limit": 15, "master_panel": this });
    var general_3_panel1371 = new Ext.Panel({ "flex": 71, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": description1312, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 33 }, ProjectsByProject_grid1370 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel1373 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel1303, general_2_panel1309, general_3_panel1371 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var TicketsByProject_grid1374 = new Lino.tickets.TicketsByProject.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.tickets.TicketsByProject.grid) ], "preview_limit": 15, "master_panel": this });
    var SessionsByProject_grid1375 = new Lino.tickets.SessionsByProject.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.tickets.SessionsByProject.grid) ], "preview_limit": 15, "master_panel": this });
    var tickets_1_panel1376 = new Ext.Panel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "layout": "hbox", "title": "Tickets", "hideCheckBoxLabels": true, "items": [ TicketsByProject_grid1374, SessionsByProject_grid1375 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel1377 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1373, tickets_1_panel1376 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1377;
    this.before_row_edit = function(record) {
      ProjectsByProject_grid1370.on_master_changed();
      TicketsByProject_grid1374.on_master_changed();
      SessionsByProject_grid1375.on_master_changed();
    }
    Lino.tickets.Projects.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.Users.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 11,
  initComponent : function() {
    var containing_panel = this;
    var username121 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Username</span>", "name": "username", "listeners": { "render": Lino.quicktip_renderer("Benutzername","Required. Must be unique.") }, "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var email122 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "e-mail address", "name": "email", "maxLength": 75, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel123 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username121, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email122, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name126 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "First name", "name": "first_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var last_name127 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Last name", "name": "last_name", "maxLength": 30, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel128 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name126, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name127, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var partner131 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "hiddenName": "partnerHidden", "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var language132 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Language", "name": "language", "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ], [ "en", "English" ] ], "hiddenName": "languageHidden" });
    var profile133 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">User Profile</span>", "name": "profile", "hiddenName": "profileHidden", "listeners": { "render": Lino.quicktip_renderer("Benutzerprofil","Users with an empty `profile` field are considered inactive and cannot log in.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var main_4_panel134 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 52, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language132, "labelAlign": "top" }, { "flex": 47, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile133, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel137 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ main_1_panel123, main_2_panel128, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner131, "anchor": "-20", "labelAlign": "top" }, main_4_panel134 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel137;
    this.before_row_edit = function(record) {
    }
    Lino.users.Users.InsertFormPanel.superclass.initComponent.call(this);
    // active_fields:
    partner131.on("change",function(){this.save()},this);
  }
});


Lino.households.Types.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 29,
  initComponent : function() {
    var containing_panel = this;
    var name911 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr912 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_et913 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_en914 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (en)", "name": "name_en", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel915 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name911, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr912, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et913, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en914, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var HouseholdsByType_grid1013 = new Lino.households.HouseholdsByType.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.HouseholdsByType.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1014 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel915, HouseholdsByType_grid1013 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1014;
    this.before_row_edit = function(record) {
      HouseholdsByType_grid1013.on_master_changed();
    }
    Lino.households.Types.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Events.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 62,
  initComponent : function() {
    var containing_panel = this;
    var calendar1547 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Calendar", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail)}, "emptyText": "Select a Calendar...", "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/calendar", "method": "GET" }) }) });
    var summary1548 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Summary", "name": "summary", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var user1549 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Responsible user", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }) });
    var assigned_to1550 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Assigned to", "name": "assigned_to", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "assigned_toHidden", "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/assigned_to", "method": "GET" }) }) });
    var main_1_panel1551 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar1547, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary1548, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1549, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": assigned_to1550, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var start_date1556 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Start date", "anchor": "-20", "name": "start_date" });
    var start_time1557 = new Lino.TimeField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Start time", "anchor": "-20", "name": "start_time" });
    var start_panel1558 = new Ext.Panel({ "flex": 33, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1556, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time1557, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var end_date1561 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "End Date", "anchor": "-20", "name": "end_date" });
    var end_time1562 = new Lino.TimeField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "End Time", "anchor": "-20", "name": "end_time" });
    var end_panel1563 = new Ext.Panel({ "flex": 33, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1561, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time1562, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var state1566 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "State", "allowBlank": false, "hiddenName": "stateHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.EventStates, "name": "state" });
    var main_2_panel1567 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 54, "hideCheckBoxLabels": true, "items": [ start_panel1558, end_panel1563, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state1566, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var room1569 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Room", "name": "room", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Rooms.detail)}, "emptyText": "Select a Room...", "selectOnFocus": true, "hiddenName": "roomHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/room", "method": "GET" }) }) });
    var priority1570 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Priority", "name": "priority", "pageSize": 20, "emptyText": "Select a Priority...", "selectOnFocus": true, "hiddenName": "priorityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/priority", "method": "GET" }) }) });
    var access_class1571 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Access Class</span>", "name": "access_class", "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Access Class","Whether this is private, public or between.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var transparent1572 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "transparent", "listeners": { "render": Lino.quicktip_renderer("Transparent","Indicates that this Event shouldn't prevent other Events at the same time.") }, "boxLabel": "Transparent", "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel1573 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": room1569, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": priority1570, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class1571, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": transparent1572, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var owner_disp1578 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Controlled by", "anchor": "-20", "name": "owner" });
    var created1579 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "anchor": "-20", "value": "<br>" });
    var modified1580 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "anchor": "-20", "value": "<br>" });
    var main_4_panel1581 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp1578, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1579, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1580, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description1585 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 35, "containing_panel": this, "name": "description", "title": "Description" });
    var GuestsByEvent_grid1641 = new Lino.cal.GuestsByEvent.GridPanel({ "flex": 36, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.GuestsByEvent.grid) ], "preview_limit": 15, "master_panel": this });
    var outbox_MailsByController_grid1642 = new Lino.outbox.MailsByController.GridPanel({ "flex": 63, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ], "preview_limit": 15, "master_panel": this });
    var main_6_panel1643 = new Ext.Panel({ "flex": 35, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ GuestsByEvent_grid1641, outbox_MailsByController_grid1642 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel1644 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel1551, main_2_panel1567, main_3_panel1573, main_4_panel1581, description1585, main_6_panel1643 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1644;
    this.before_row_edit = function(record) {
      description1585.refresh();
      GuestsByEvent_grid1641.on_master_changed();
      outbox_MailsByController_grid1642.on_master_changed();
    }
    Lino.cal.Events.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.sales.Invoices.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 43,
  initComponent : function() {
    var containing_panel = this;
    var date431 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var partner432 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Select a Partner...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/partner", "method": "GET" }) }), "name": "partner" });
    var vat_regime433 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "VAT Regime", "allowBlank": false, "hiddenName": "vat_regimeHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.vat.VatRegimes, "name": "vat_regime" });
    var invoice_header_1_panel434 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date431, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner432, "labelAlign": "top" }, { "flex": 46, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_regime433, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var subject438 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Subject line", "name": "subject", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var your_ref439 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Your reference", "name": "your_ref", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var invoice_header_2_panel440 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject438, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": your_ref439, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var payment_term443 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Payment Term", "name": "payment_term", "pageSize": 20, "emptyText": "Select a Payment Term...", "selectOnFocus": true, "hiddenName": "payment_termHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/payment_term", "method": "GET" }) }) });
    var due_date444 = new Lino.DateField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "Date of payment", "anchor": "-20", "name": "due_date" });
    var invoice_header_3_panel445 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": payment_term443, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": due_date444, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 144, "border": false, "anchor": "-20", "labelAlign": "top" });
    var imode448 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Invoicing Mode", "name": "imode", "pageSize": 20, "emptyText": "Select a Invoicing Mode...", "selectOnFocus": true, "hiddenName": "imodeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/imode", "method": "GET" }) }) });
    var shipping_mode449 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Shipping Mode", "name": "shipping_mode", "pageSize": 20, "emptyText": "Select a Shipping Mode...", "selectOnFocus": true, "hiddenName": "shipping_modeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/shipping_mode", "method": "GET" }) }) });
    var invoice_header_4_panel450 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": imode448, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": shipping_mode449, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var invoice_header_panel453 = new Ext.form.FieldSet({ "flex": 75, "autoHeight": true, "layout": "form", "title": "Header", "items": [ invoice_header_1_panel434, invoice_header_2_panel440, invoice_header_3_panel445, invoice_header_4_panel450 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var total_base454 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "Total excl. VAT", "name": "total_base", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var total_vat455 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "VAT", "name": "total_vat", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var total_incl456 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "Total incl. VAT", "name": "total_incl", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var workflow_buttons_disp457 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Workflow", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var totals_panel458 = new Ext.form.FieldSet({ "flex": 25, "autoHeight": true, "layout": "form", "title": "Totals", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_base454, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_vat455, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_incl456, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp457, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 144, "border": false, "labelAlign": "top" });
    var general_1_panel463 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ invoice_header_panel453, totals_panel458 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ItemsByInvoice_grid475 = new Lino.sales.ItemsByInvoice.GridPanel({ "flex": 45, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.sales.ItemsByInvoice.grid) ], "preview_limit": 15, "master_panel": this });
    var general_panel476 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel463, ItemsByInvoice_grid475 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var id477 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var user478 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/user", "method": "GET" }) }) });
    var language479 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Language", "allowBlank": false, "hiddenName": "languageHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ], [ "en", "English" ] ], "name": "language" });
    var more_1_panel480 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id477, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user478, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language479, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var intro484 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Introductive Text", "anchor": "-20 -10", "growMax": 2000, "name": "intro" });
    var more_panel485 = new Ext.Panel({ "layout": "vbox", "title": "More", "items": [ more_1_panel480, { "items": intro484, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "labelWidth": 162, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var journal487 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Journal", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail)}, "emptyText": "Select a Journal...", "selectOnFocus": true, "hiddenName": "journalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/journal", "method": "GET" }) }), "name": "journal" });
    var year488 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "year", "hiddenName": "yearHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var number489 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "number", "anchor": "-20", "name": "number" });
    var narration490 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Narration", "name": "narration", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var ledger_1_panel491 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": journal487, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": year488, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": number489, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": narration490, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ledger_MovementsByVoucher_grid520 = new Lino.ledger.MovementsByVoucher.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.ledger.MovementsByVoucher.grid) ], "preview_limit": 15, "master_panel": this });
    var ledger_panel521 = new Ext.Panel({ "layout": "vbox", "title": "Ledger", "items": [ ledger_1_panel491, ledger_MovementsByVoucher_grid520 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel522 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel476, more_panel485, ledger_panel521 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel522;
    this.before_row_edit = function(record) {
      ItemsByInvoice_grid475.on_master_changed();
      ledger_MovementsByVoucher_grid520.on_master_changed();
    }
    Lino.sales.Invoices.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Charts.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 34,
  initComponent : function() {
    var containing_panel = this;
    var id1034 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1035 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1036 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_et1037 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_en1038 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (en)", "name": "name_en", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1039 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1034, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1035, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1036, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1037, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1038, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var GroupsByChart_grid1086 = new Lino.accounts.GroupsByChart.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.accounts.GroupsByChart.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1087 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1039, GroupsByChart_grid1086 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1087;
    this.before_row_edit = function(record) {
      GroupsByChart_grid1086.on_master_changed();
    }
    Lino.accounts.Charts.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.products.Products.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 31,
  initComponent : function() {
    var containing_panel = this;
    var id1111 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var cat1112 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Category", "name": "cat", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.products.ProductCats.detail)}, "emptyText": "Select a Product Category...", "selectOnFocus": true, "hiddenName": "catHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/products/Products/cat", "method": "GET" }) }) });
    var sales_price1113 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "Sales price", "name": "sales_price", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var vat_class1114 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "VAT Class", "name": "vat_class", "hiddenName": "vat_classHidden", "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.vat.VatClasses) });
    var general_1_panel1115 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1111, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cat1112, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sales_price1113, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_class1114, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var name1120 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1121 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_et1122 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_en1123 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (en)", "name": "name_en", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var general_2_panel1124 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1120, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1121, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1122, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1123, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description1129 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Long description", "anchor": "-20 -10", "growMax": 2000, "name": "description" });
    var general_panel1130 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel1115, general_2_panel1124, { "items": description1129, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "labelWidth": 153, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var sales_InvoiceItemsByProduct_grid1143 = new Lino.sales.InvoiceItemsByProduct.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Sales", "tools": [ Lino.show_in_own_window_button(Lino.sales.InvoiceItemsByProduct.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1144 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1130, sales_InvoiceItemsByProduct_grid1143 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1144;
    this.before_row_edit = function(record) {
      sales_InvoiceItemsByProduct_grid1143.on_master_changed();
    }
    Lino.products.Products.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 59,
  initComponent : function() {
    var containing_panel = this;
    var event1607 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Event", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.OneEvent.detail)}, "emptyText": "Select a Event...", "selectOnFocus": true, "hiddenName": "eventHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/event", "method": "GET" }) }), "name": "event" });
    var partner1608 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail)}, "emptyText": "Select a Partner...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }), "name": "partner" });
    var role1609 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Role", "name": "role", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.GuestRoles.detail)}, "emptyText": "Select a Guest Role...", "selectOnFocus": true, "hiddenName": "roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/role", "method": "GET" }) }) });
    var main_1_panel1610 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event1607, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1608, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": role1609, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var state1614 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "State", "allowBlank": false, "hiddenName": "stateHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.GuestStates, "name": "state" });
    var remark1615 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Remark", "name": "remark", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var workflow_buttons_disp1616 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Workflow", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_2_panel1617 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state1614, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": remark1615, "labelAlign": "top" }, { "flex": 46, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp1616, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var outbox_MailsByController_grid1632 = new Lino.outbox.MailsByController.GridPanel({ "flex": 55, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1633 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1610, main_2_panel1617, outbox_MailsByController_grid1632 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1633;
    this.before_row_edit = function(record) {
      outbox_MailsByController_grid1632.on_master_changed();
    }
    Lino.cal.Guests.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.Milestones.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 52,
  initComponent : function() {
    var containing_panel = this;
    var project1415 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail)}, "emptyText": "Select a Project...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Milestones/project", "method": "GET" }) }) });
    var ref1416 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Reference", "name": "ref", "maxLength": 40, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1417 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1415, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1416, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var main_panel1420 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "hideCheckBoxLabels": true, "items": [ main_1_panel1417 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1420;
    this.before_row_edit = function(record) {
    }
    Lino.tickets.Milestones.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.blogs.EntryTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 47,
  initComponent : function() {
    var containing_panel = this;
    var id1268 = new Ext.form.NumberField({ "selectOnFocus": true, "autoHeight": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name1269 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1270 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_et1271 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_en1272 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (en)", "name": "name_en", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1273 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1268, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1269, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1270, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1271, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1272, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var build_method1279 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Build method", "name": "build_method", "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "hiddenName": "build_methodHidden" });
    var template1280 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Template", "name": "template", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/EntryTypes/template", "method": "GET" }) }) });
    var main_2_panel1281 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method1279, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template1280, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark1284 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remark", "anchor": "-20 -10", "growMax": 2000, "name": "remark" });
    var blogs_EntriesByType_grid1297 = new Lino.blogs.EntriesByType.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.blogs.EntriesByType.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1298 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 63, "hideCheckBoxLabels": true, "items": [ main_1_panel1273, main_2_panel1281, { "items": remark1284, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 41 }, blogs_EntriesByType_grid1297 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1298;
    this.before_row_edit = function(record) {
      template1280.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      blogs_EntriesByType_grid1297.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method1279.on('change',Lino.chooser_handler(template1280,'build_method'));
      Lino.blogs.EntryTypes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.blogs.EntryTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.Uploads.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 55,
  initComponent : function() {
    var containing_panel = this;
    var file1763 = Lino.file_field_handler(this,{ "autoHeight": true, "fieldLabel": "Datei", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user1764 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "hiddenName": "userHidden", "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel1765 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file1763, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1764, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type1768 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Upload Type", "name": "type", "pageSize": 20, "emptyText": "Select a Upload Type...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var description1769 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Description", "name": "description", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel1770 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1768, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": description1769, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var modified1773 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "anchor": "-20", "value": "<br>" });
    var created1774 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "anchor": "-20", "value": "<br>" });
    var owner_disp1775 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Controlled by", "anchor": "-20", "name": "owner" });
    var main_3_panel1776 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1773, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1774, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp1775, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1780 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1765, main_2_panel1770, main_3_panel1776 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1780;
    this.before_row_edit = function(record) {
    }
    Lino.uploads.Uploads.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Roles.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 27,
  initComponent : function() {
    var containing_panel = this;
    var name1015 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_fr1016 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_et1017 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_en1018 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (en)", "name": "name_en", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var name_giving1019 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "name_giving", "listeners": { "render": Lino.quicktip_renderer("name-giving","When the `name` field of a Household is empty, \nits value is computed by joining the `Last Name` \nof all name-giving members with a dash (\"-\").\n      ") }, "boxLabel": "name-giving", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel1020 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1015, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1016, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1017, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_en1018, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_giving1019, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var MembersByRole_grid1032 = new Lino.households.MembersByRole.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByRole.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1033 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1020, MembersByRole_grid1032 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1033;
    this.before_row_edit = function(record) {
      MembersByRole_grid1032.on_master_changed();
    }
    Lino.households.Roles.DetailFormPanel.superclass.initComponent.call(this);
  }
});


// js_render_GridPanel_class system.SiteConfigs
Lino.system.SiteConfigs.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/system/SiteConfigs",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/system/SiteConfigs','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/SiteConfigs','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/SiteConfigs','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "do_build", "menu_item_text": "Rebuild site cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('do_build','GET',null), "text": "Rebuild site cache", "overflowText": "Rebuild site cache", "auto_save": true } ],
  cell_edit : true,
  title : "site configs",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 19,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "default_build_method" }, 'default_build_methodHidden', { "type": "int", "name": "next_partner_id" }, { "name": "site_company" }, 'site_companyHidden', { "name": "clients_account" }, 'clients_accountHidden', { "name": "sales_vat_account" }, 'sales_vat_accountHidden', { "name": "sales_account" }, 'sales_accountHidden', { "name": "suppliers_account" }, 'suppliers_accountHidden', { "name": "purchases_vat_account" }, 'purchases_vat_accountHidden', { "name": "purchases_account" }, 'purchases_accountHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 7,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.system.SiteConfigs.detail;
    var ww = this.containing_window;
    var id1825 = new Ext.form.NumberField({ "selectOnFocus": true });
    var default_build_method1826 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "value": "appyodt" });
    var next_partner_id1827 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 100 });
    var site_company1828 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/site_company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Company..." });
    var clients_account1829 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/clients_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var sales_vat_account1830 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/sales_vat_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var sales_account1831 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/sales_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var suppliers_account1832 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/suppliers_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var purchases_vat_account1833 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/purchases_vat_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var purchases_account1834 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/purchases_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1825, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Default build method", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "default_build_method", "editor": default_build_method1826 }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "The next automatic id for any new partner.", "filter": { "type": "numeric" }, "header": "Next partner id", "dataIndex": "next_partner_id", "width": Lino.chars2width(6), "editor": next_partner_id1827 }), { "colIndex": 3, "sortable": true, "header": "The company that runs this site", "editable": true, "tooltip": "The Company to be used as sender in documents.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('site_companyHidden','Lino.contacts.Companies.detail'), "editor": site_company1828, "dataIndex": "site_company" }, { "colIndex": 4, "sortable": true, "header": "Clients account", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "clients_account", "editor": clients_account1829 }, { "colIndex": 5, "sortable": true, "header": "Sales VAT account", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "sales_vat_account", "editor": sales_vat_account1830 }, { "colIndex": 6, "sortable": true, "header": "Sales Base account", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "sales_account", "editor": sales_account1831 }, { "colIndex": 7, "sortable": true, "header": "Suppliers account", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "suppliers_account", "editor": suppliers_account1832 }, { "colIndex": 8, "sortable": true, "header": "Purchases VAT account", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "purchases_vat_account", "editor": purchases_vat_account1833 }, { "colIndex": 9, "sortable": true, "header": "Purchases Base account", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "purchases_account", "editor": purchases_account1834 } ];
    Lino.system.SiteConfigs.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.system.SiteConfigs.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/SiteConfigs","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.system.SiteConfigs.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/SiteConfigs","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.system.SiteConfigs.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/SiteConfigs","GET",pk,"put",null);
};
Lino.system.SiteConfigs.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/SiteConfigs","GET",pk,"post",null);
};

Lino.system.SiteConfigs.detailPanel = Ext.extend(Lino.system.SiteConfigs.DetailFormPanel,{
  empty_title: "Detail site configs",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "do_build", "menu_item_text": "Rebuild site cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('do_build','GET',null), "text": "Rebuild site cache", "overflowText": "Rebuild site cache", "auto_save": true } ],
  ls_url: "/system/SiteConfigs",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.SiteConfigs.detail;
    Lino.system.SiteConfigs.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.system.SiteConfigs.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.system.SiteConfigs.detailPanel(p);
});
Lino.system.SiteConfigs.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.system.SiteConfigs.GridPanel(p);
});
Lino.system.SiteConfigs.do_build = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/SiteConfigs","GET",pk,"do_build",null);
};

// js_render_GridPanel_class system.ContentTypes
Lino.system.ContentTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/system/ContentTypes",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/system/ContentTypes','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/ContentTypes','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/ContentTypes','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "content types",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 5,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "app_label" }, { "name": "model" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 2,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.system.ContentTypes.detail;
    this.ls_insert_handler = Lino.system.ContentTypes.insert;
    var ww = this.containing_window;
    var id1836 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1837 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var app_label1838 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var model1839 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1836, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1837 }, { "colIndex": 2, "sortable": true, "header": "app label", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "app_label", "editor": app_label1838 }, { "colIndex": 3, "sortable": true, "header": "python model class name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "model", "editor": model1839 } ];
    Lino.system.ContentTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.system.ContentTypes.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/ContentTypes","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.system.ContentTypes.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/ContentTypes","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.system.ContentTypes.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/ContentTypes","GET",pk,"put",null);
};
Lino.system.ContentTypes.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/ContentTypes","GET",pk,"post",null);
};

Lino.system.ContentTypes.insertPanel = Ext.extend(Lino.system.ContentTypes.DetailFormPanel,{
  empty_title: "New content types",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/system/ContentTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.ContentTypes.detail;
    this.ls_insert_handler = Lino.system.ContentTypes.insert;
    Lino.system.ContentTypes.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.system.ContentTypes.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.system.ContentTypes.insertPanel(p);
});
Lino.system.ContentTypes.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/ContentTypes","GET",pk,"poststay",null);
};

Lino.system.ContentTypes.detailPanel = Ext.extend(Lino.system.ContentTypes.DetailFormPanel,{
  empty_title: "Detail content types",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/system/ContentTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.ContentTypes.detail;
    this.ls_insert_handler = Lino.system.ContentTypes.insert;
    Lino.system.ContentTypes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.system.ContentTypes.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.system.ContentTypes.detailPanel(p);
});
Lino.system.ContentTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.system.ContentTypes.GridPanel(p);
});

// js_render_GridPanel_class system.HelpTexts
Lino.system.HelpTexts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/system/HelpTexts",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/system/HelpTexts','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/HelpTexts','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/HelpTexts','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Help Texts",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "name": "field" }, { "name": "verbose_name" }, { "name": "help_text" }, { "type": "int", "name": "id" }, { "name": "content_type" }, 'content_typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 8,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var field1841 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/HelpTexts/field", "method": "GET" }) }) });
    var verbose_name1842 = new Ext.form.TextField({ "disabled": true, "maxLength": 200 });
    var help_text1843 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var id1844 = new Ext.form.NumberField({ "selectOnFocus": true });
    var content_type1845 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/HelpTexts/content_type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a content type..." });
    this.before_row_edit = function(record) {
      field1841.setContextValue('content_type',record ? record.data['content_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      content_type1845.on('change',Lino.chooser_handler(field1841,'content_type'));
      Lino.system.HelpTexts.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Field", "editable": true, "tooltip": "The name of the field.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "field", "editor": field1841 }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "verbose_name", "header": "Verbose name", "editable": false }, { "colIndex": 2, "sortable": false, "header": "HelpText", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": help_text1843, "dataIndex": "help_text" }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1844, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Model", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('content_typeHidden','Lino.system.ContentTypes.detail'), "editor": content_type1845, "dataIndex": "content_type" } ];
    Lino.system.HelpTexts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.system.HelpTexts.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/HelpTexts","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.system.HelpTexts.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/HelpTexts","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.system.HelpTexts.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/HelpTexts","GET",pk,"put",null);
};
Lino.system.HelpTexts.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/HelpTexts","GET",pk,"post",null);
};
Lino.system.HelpTexts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.system.HelpTexts.GridPanel(p);
});

// js_render_GridPanel_class system.TextFieldTemplates
Lino.system.TextFieldTemplates.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/system/TextFieldTemplates",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/system/TextFieldTemplates','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/TextFieldTemplates','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/TextFieldTemplates','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Text Field Templates",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "name" }, { "name": "team" }, 'teamHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 9,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.system.TextFieldTemplates.detail;
    this.ls_insert_handler = Lino.system.TextFieldTemplates.insert;
    var ww = this.containing_window;
    var id1847 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1848 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var name1849 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var team1850 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/team", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Team..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1847, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1848, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1849 }, { "colIndex": 3, "sortable": true, "header": "Team", "editable": true, "tooltip": "If not empty, then this template is reserved to members of this team.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "team", "editor": team1850 } ];
    Lino.system.TextFieldTemplates.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.system.TextFieldTemplates.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/TextFieldTemplates","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.system.TextFieldTemplates.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/TextFieldTemplates","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.system.TextFieldTemplates.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/TextFieldTemplates","GET",pk,"put",null);
};
Lino.system.TextFieldTemplates.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/TextFieldTemplates","GET",pk,"post",null);
};

Lino.system.TextFieldTemplates.insertPanel = Ext.extend(Lino.system.TextFieldTemplates.InsertFormPanel,{
  empty_title: "New Text Field Templates",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/system/TextFieldTemplates",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.TextFieldTemplates.detail;
    this.ls_insert_handler = Lino.system.TextFieldTemplates.insert;
    Lino.system.TextFieldTemplates.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.system.TextFieldTemplates.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.system.TextFieldTemplates.insertPanel(p);
});
Lino.system.TextFieldTemplates.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/TextFieldTemplates","GET",pk,"poststay",null);
};

Lino.system.TextFieldTemplates.detailPanel = Ext.extend(Lino.system.TextFieldTemplates.DetailFormPanel,{
  empty_title: "Detail Text Field Templates",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/system/TextFieldTemplates",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.TextFieldTemplates.detail;
    this.ls_insert_handler = Lino.system.TextFieldTemplates.insert;
    Lino.system.TextFieldTemplates.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.system.TextFieldTemplates.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.system.TextFieldTemplates.detailPanel(p);
});
Lino.system.TextFieldTemplates.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.system.TextFieldTemplates.GridPanel(p);
});

// js_render_GridPanel_class users.Users
Lino.users.Users.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/Users",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/users/Users','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Users','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Users','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "must_save": true, "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true } ],
  cell_edit : true,
  title : "Users",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 21,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "first_name" }, { "name": "last_name" }, { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "password" }, { "name": "initials" }, { "name": "email" }, { "name": "remarks" }, { "name": "language" }, 'languageHidden', { "name": "partner" }, 'partnerHidden', { "name": "access_class" }, 'access_classHidden', { "name": "calendar" }, 'calendarHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 11,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    var ww = this.containing_window;
    var username1852 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile1853 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var first_name1854 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var last_name1855 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var id1856 = new Ext.form.NumberField({ "selectOnFocus": true });
    var created1857 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified1858 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var password1859 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 128 });
    var initials1860 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var email1861 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var remarks1862 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var language1863 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ], [ "en", "English" ] ] });
    var partner1864 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var access_class1865 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.AccessClasses });
    var calendar1866 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Username", "editable": true, "tooltip": "Required. Must be unique.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "username", "editor": username1852 }, { "colIndex": 1, "sortable": true, "header": "User Profile", "editable": true, "tooltip": "Users with an empty `profile` field are considered inactive and cannot log in.", "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "profile", "editor": profile1853 }, { "colIndex": 2, "sortable": true, "header": "First name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name1854 }, { "colIndex": 3, "sortable": true, "header": "Last name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name1855 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1856, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(17), "colIndex": 5, "sortable": true, "dataIndex": "created", "header": "Created", "editable": false }, { "width": Lino.chars2width(17), "colIndex": 6, "sortable": true, "dataIndex": "modified", "header": "Modified", "editable": false }, { "colIndex": 7, "sortable": true, "header": "Password", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "password", "hidden": true, "editor": password1859 }, { "colIndex": 8, "sortable": true, "header": "Initials", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "initials", "editor": initials1860 }, { "colIndex": 9, "sortable": true, "header": "e-mail address", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email1861 }, { "colIndex": 10, "sortable": false, "header": "Remarks", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": remarks1862, "dataIndex": "remarks" }, { "colIndex": 11, "sortable": true, "header": "Language", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language1863 }, { "colIndex": 12, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner1864, "dataIndex": "partner" }, { "colIndex": 13, "sortable": true, "header": "Default access class", "editable": true, "tooltip": "The default access class for your calendar events and tasks.", "filter": { "type": "string" }, "width": Lino.chars2width(35), "dataIndex": "access_class", "editor": access_class1865 }, { "colIndex": 14, "sortable": true, "header": "Default calendar", "editable": true, "tooltip": "The default calendar for your events and tasks.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.Calendars.detail'), "editor": calendar1866, "dataIndex": "calendar" } ];
    Lino.users.Users.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Users.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Users","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.users.Users.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Users","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.users.Users.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Users","GET",pk,"put",null);
};
Lino.users.Users.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Users","GET",pk,"post",null);
};

Lino.users.Users.insertPanel = Ext.extend(Lino.users.Users.InsertFormPanel,{
  empty_title: "New Users",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/users/Users",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.Users.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Users.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.Users.insertPanel(p);
});
Lino.users.Users.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Users","GET",pk,"poststay",null);
};

Lino.users.Users.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Detail Users",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "must_save": true, "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true } ],
  ls_url: "/users/Users",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.Users.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Users.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Users.detailPanel(p);
});
Lino.users.Users.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Users.GridPanel(p);
});
Lino.users.Users.update_reminders = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Users","GET",pk,"update_reminders",null);
};

// js_render_GridPanel_class users.MySettings
Lino.users.MySettings.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/MySettings",
  ls_bbar_actions : [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "must_save": true, "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true } ],
  cell_edit : true,
  title : "Users",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 21,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "first_name" }, { "name": "last_name" }, { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "password" }, { "name": "initials" }, { "name": "email" }, { "name": "remarks" }, { "name": "language" }, 'languageHidden', { "name": "partner" }, 'partnerHidden', { "name": "access_class" }, 'access_classHidden', { "name": "calendar" }, 'calendarHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 11,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    var ww = this.containing_window;
    var username143 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile144 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var first_name145 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var last_name146 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var id147 = new Ext.form.NumberField({ "selectOnFocus": true });
    var created148 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified149 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var password150 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 128 });
    var initials151 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var email152 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var remarks153 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var language154 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ], [ "en", "English" ] ] });
    var partner155 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var access_class156 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.AccessClasses });
    var calendar157 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Username", "editable": true, "tooltip": "Required. Must be unique.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "username", "editor": username143 }, { "colIndex": 1, "sortable": true, "header": "User Profile", "editable": true, "tooltip": "Users with an empty `profile` field are considered inactive and cannot log in.", "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "profile", "editor": profile144 }, { "colIndex": 2, "sortable": true, "header": "First name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name145 }, { "colIndex": 3, "sortable": true, "header": "Last name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name146 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id147, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(17), "colIndex": 5, "sortable": true, "dataIndex": "created", "header": "Created", "editable": false }, { "width": Lino.chars2width(17), "colIndex": 6, "sortable": true, "dataIndex": "modified", "header": "Modified", "editable": false }, { "colIndex": 7, "sortable": true, "header": "Password", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "password", "hidden": true, "editor": password150 }, { "colIndex": 8, "sortable": true, "header": "Initials", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "initials", "editor": initials151 }, { "colIndex": 9, "sortable": true, "header": "e-mail address", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email152 }, { "colIndex": 10, "sortable": false, "header": "Remarks", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "hidden": true, "editor": remarks153, "dataIndex": "remarks" }, { "colIndex": 11, "sortable": true, "header": "Language", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language154 }, { "colIndex": 12, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner155, "dataIndex": "partner" }, { "colIndex": 13, "sortable": true, "header": "Default access class", "editable": true, "tooltip": "The default access class for your calendar events and tasks.", "filter": { "type": "string" }, "width": Lino.chars2width(35), "dataIndex": "access_class", "editor": access_class156 }, { "colIndex": 14, "sortable": true, "header": "Default calendar", "editable": true, "tooltip": "The default calendar for your events and tasks.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.Calendars.detail'), "editor": calendar157, "dataIndex": "calendar" } ];
    Lino.users.MySettings.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MySettings","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.users.MySettings.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MySettings","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.users.MySettings.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MySettings","GET",pk,"put",null);
};
Lino.users.MySettings.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MySettings","GET",pk,"post",null);
};

Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Users",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "must_save": true, "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});

Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Users",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "must_save": true, "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});
Lino.users.MySettings.update_reminders = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MySettings","GET",pk,"update_reminders",null);
};

// js_render_GridPanel_class users.UsersOverview
Lino.users.UsersOverview.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/UsersOverview",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/users/UsersOverview','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/UsersOverview','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/UsersOverview','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "must_save": true, "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true } ],
  cell_edit : true,
  title : "Users",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "language" }, 'languageHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 11,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.UsersOverview.detail;
    this.ls_insert_handler = Lino.users.UsersOverview.insert;
    var ww = this.containing_window;
    var username178 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile179 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var language180 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ], [ "en", "English" ] ] });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Username", "editable": true, "tooltip": "Required. Must be unique.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "username", "editor": username178 }, { "colIndex": 1, "sortable": true, "header": "User Profile", "editable": true, "tooltip": "Users with an empty `profile` field are considered inactive and cannot log in.", "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "profile", "editor": profile179 }, { "colIndex": 2, "sortable": true, "header": "Language", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language180 } ];
    Lino.users.UsersOverview.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.UsersOverview.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/UsersOverview","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.users.UsersOverview.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/UsersOverview","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.users.UsersOverview.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/UsersOverview","GET",pk,"put",null);
};
Lino.users.UsersOverview.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/UsersOverview","GET",pk,"post",null);
};

Lino.users.UsersOverview.insertPanel = Ext.extend(Lino.users.Users.InsertFormPanel,{
  empty_title: "New Users",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/users/UsersOverview",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.UsersOverview.detail;
    this.ls_insert_handler = Lino.users.UsersOverview.insert;
    Lino.users.UsersOverview.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.users.UsersOverview.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.UsersOverview.insertPanel(p);
});
Lino.users.UsersOverview.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/UsersOverview","GET",pk,"poststay",null);
};

Lino.users.UsersOverview.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Detail Users",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "must_save": true, "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true } ],
  ls_url: "/users/UsersOverview",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.UsersOverview.detail;
    this.ls_insert_handler = Lino.users.UsersOverview.insert;
    Lino.users.UsersOverview.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.UsersOverview.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.UsersOverview.detailPanel(p);
});
Lino.users.UsersOverview.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.UsersOverview.GridPanel(p);
});
Lino.users.UsersOverview.update_reminders = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/UsersOverview","GET",pk,"update_reminders",null);
};

// js_render_GridPanel_class users.Teams
Lino.users.Teams.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/Teams",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/users/Teams','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Teams','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Teams','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Teams",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 13,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id1868 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1869 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr1870 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et1871 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en1872 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1868, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1869 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1870 }, { "colIndex": 3, "sortable": true, "header": "Designation (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et1871 }, { "colIndex": 4, "sortable": true, "header": "Designation (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en1872 } ];
    Lino.users.Teams.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Teams.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Teams","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.users.Teams.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Teams","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.users.Teams.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Teams","GET",pk,"put",null);
};
Lino.users.Teams.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Teams","GET",pk,"post",null);
};
Lino.users.Teams.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Teams.GridPanel(p);
});

// js_render_GridPanel_class users.Memberships
Lino.users.Memberships.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/Memberships",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/users/Memberships','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Memberships','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Memberships','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Memberships",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "team" }, 'teamHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 10,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id1874 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1875 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Memberships/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var team1876 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Memberships/team", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Team..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1874, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1875, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "Team", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "team", "editor": team1876 } ];
    Lino.users.Memberships.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Memberships.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Memberships","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.users.Memberships.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Memberships","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.users.Memberships.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Memberships","GET",pk,"put",null);
};
Lino.users.Memberships.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Memberships","GET",pk,"post",null);
};
Lino.users.Memberships.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Memberships.GridPanel(p);
});

// js_render_GridPanel_class users.Authorities
Lino.users.Authorities.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/Authorities",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/users/Authorities','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Authorities','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Authorities','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Authorities",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "authorized" }, 'authorizedHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 12,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id1878 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1879 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Authorities/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var authorized1880 = new Lino.RemoteComboFieldElement({ "preferred_width": 15, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Authorities/authorized", "method": "GET" }) }), "emptyText": "Select a User..." });
    this.before_row_edit = function(record) {
      authorized1880.setContextValue('user',record ? record.data['userHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      user1879.on('change',Lino.chooser_handler(authorized1880,'user'));
      Lino.users.Authorities.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1878, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1879, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "User", "editable": true, "tooltip": "The user who gets authority to act in your name.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('authorizedHidden','Lino.users.Users.detail'), "editor": authorized1880, "dataIndex": "authorized" } ];
    Lino.users.Authorities.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Authorities.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Authorities","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.users.Authorities.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Authorities","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.users.Authorities.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Authorities","GET",pk,"put",null);
};
Lino.users.Authorities.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Authorities","GET",pk,"post",null);
};
Lino.users.Authorities.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Authorities.GridPanel(p);
});

// js_render_GridPanel_class countries.Countries
Lino.countries.Countries.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/countries/Countries",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/countries/Countries','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/countries/Countries','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/countries/Countries','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Countries",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 8,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "isocode" }, { "name": "short_code" }, { "name": "iso3" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 14,
  ls_id_property : "isocode",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    var ww = this.containing_window;
    var name1882 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr1883 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et1884 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en1885 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var isocode1886 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "allowBlank": false, "maxLength": 4 });
    var short_code1887 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    var iso31888 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "maxLength": 3 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1882 }, { "colIndex": 1, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1883 }, { "colIndex": 2, "sortable": true, "header": "Designation (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et1884 }, { "colIndex": 3, "sortable": true, "header": "Designation (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en1885 }, { "colIndex": 4, "sortable": true, "header": "ISO code", "editable": true, "tooltip": "        The two-letter code for this country as defined by ISO 3166-1. \n        For countries that no longer exist it may be a 4-letter code.", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "isocode", "editor": isocode1886 }, { "colIndex": 5, "sortable": true, "header": "Short code", "editable": true, "tooltip": "A short abbreviation for regional usage. Obsolete.", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "short_code", "editor": short_code1887 }, { "colIndex": 6, "sortable": true, "header": "ISO-3 code", "editable": true, "tooltip": "The three-letter code for this country as defined by ISO 3166-1.", "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "iso3", "editor": iso31888 } ];
    Lino.countries.Countries.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Countries","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.countries.Countries.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Countries","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.countries.Countries.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Countries","GET",pk,"put",null);
};
Lino.countries.Countries.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Countries","GET",pk,"post",null);
};

Lino.countries.Countries.insertPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "New Countries",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/countries/Countries",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    Lino.countries.Countries.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Countries.insertPanel(p);
});
Lino.countries.Countries.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Countries","GET",pk,"poststay",null);
};

Lino.countries.Countries.detailPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "Detail Countries",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/countries/Countries",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    Lino.countries.Countries.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.detailPanel(p);
});
Lino.countries.Countries.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.GridPanel(p);
});

// js_render_GridPanel_class countries.Cities
Lino.countries.Cities.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/countries/Cities",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/countries/Cities','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/countries/Cities','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/countries/Cities','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Places",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 13,
  ls_store_fields : [ { "name": "country" }, 'countryHidden', { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "type" }, 'typeHidden', { "name": "zip_code" }, { "type": "int", "name": "id" }, { "name": "parent" }, 'parentHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 9,
  ls_grid_configs : [  ],
  content_type : 15,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Cities.detail;
    this.ls_insert_handler = Lino.countries.Cities.insert;
    var ww = this.containing_window;
    var country1890 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/country", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Country..." });
    var name1891 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr1892 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et1893 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en1894 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type1895 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/type", "method": "GET" }) }) });
    var zip_code1896 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "maxLength": 8 });
    var id1897 = new Ext.form.NumberField({ "selectOnFocus": true });
    var parent1898 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/parent", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    this.before_row_edit = function(record) {
      type1895.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country1890.on('change',Lino.chooser_handler(type1895,'country'));
      Lino.countries.Cities.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Country", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country1890, "dataIndex": "country" }, { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1891 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1892 }, { "colIndex": 3, "sortable": true, "header": "Designation (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et1893 }, { "colIndex": 4, "sortable": true, "header": "Designation (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en1894 }, { "colIndex": 5, "sortable": true, "header": "Place Type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "type", "editor": type1895 }, { "colIndex": 6, "sortable": true, "header": "zip code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "zip_code", "editor": zip_code1896 }, new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1897, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 8, "sortable": true, "header": "Part of", "editable": true, "tooltip": "The superordinate geographic place of which this place is a part.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('parentHidden','Lino.countries.Cities.detail'), "editor": parent1898, "dataIndex": "parent" } ];
    Lino.countries.Cities.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Cities.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Cities","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.countries.Cities.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Cities","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.countries.Cities.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Cities","GET",pk,"put",null);
};
Lino.countries.Cities.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Cities","GET",pk,"post",null);
};

Lino.countries.Cities.insertPanel = Ext.extend(Lino.countries.Cities.DetailFormPanel,{
  empty_title: "New Places",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/countries/Cities",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Cities.detail;
    this.ls_insert_handler = Lino.countries.Cities.insert;
    Lino.countries.Cities.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Cities.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Cities.insertPanel(p);
});
Lino.countries.Cities.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Cities","GET",pk,"poststay",null);
};

Lino.countries.Cities.detailPanel = Ext.extend(Lino.countries.Cities.DetailFormPanel,{
  empty_title: "Detail Places",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/countries/Cities",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Cities.detail;
    this.ls_insert_handler = Lino.countries.Cities.insert;
    Lino.countries.Cities.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Cities.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Cities.detailPanel(p);
});
Lino.countries.Cities.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Cities.GridPanel(p);
});

// js_render_GridPanel_class properties.PropGroups
Lino.properties.PropGroups.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/properties/PropGroups",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/properties/PropGroups','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/properties/PropGroups','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/properties/PropGroups','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Property Groups",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 17,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropGroups.detail;
    this.ls_insert_handler = Lino.properties.PropGroups.insert;
    var ww = this.containing_window;
    var id1900 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1901 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr1902 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et1903 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en1904 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1900, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1901 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1902 }, { "colIndex": 3, "sortable": true, "header": "Designation (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et1903 }, { "colIndex": 4, "sortable": true, "header": "Designation (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en1904 } ];
    Lino.properties.PropGroups.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropGroups.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/PropGroups","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.properties.PropGroups.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/PropGroups","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.properties.PropGroups.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/PropGroups","GET",pk,"put",null);
};
Lino.properties.PropGroups.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/PropGroups","GET",pk,"post",null);
};

Lino.properties.PropGroups.insertPanel = Ext.extend(Lino.properties.PropGroups.DetailFormPanel,{
  empty_title: "New Property Groups",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/properties/PropGroups",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropGroups.detail;
    this.ls_insert_handler = Lino.properties.PropGroups.insert;
    Lino.properties.PropGroups.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropGroups.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.properties.PropGroups.insertPanel(p);
});
Lino.properties.PropGroups.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/PropGroups","GET",pk,"poststay",null);
};

Lino.properties.PropGroups.detailPanel = Ext.extend(Lino.properties.PropGroups.DetailFormPanel,{
  empty_title: "Detail Property Groups",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/properties/PropGroups",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropGroups.detail;
    this.ls_insert_handler = Lino.properties.PropGroups.insert;
    Lino.properties.PropGroups.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropGroups.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropGroups.detailPanel(p);
});
Lino.properties.PropGroups.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropGroups.GridPanel(p);
});

// js_render_GridPanel_class properties.PropTypes
Lino.properties.PropTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/properties/PropTypes",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/properties/PropTypes','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/properties/PropTypes','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/properties/PropTypes','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Property Types",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 12,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "choicelist" }, 'choicelistHidden', { "name": "default_value" }, 'default_valueHidden', { "type": "boolean", "name": "limit_to_choices" }, { "type": "boolean", "name": "multiple_choices" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 18,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropTypes.detail;
    this.ls_insert_handler = Lino.properties.PropTypes.insert;
    var ww = this.containing_window;
    var id1906 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1907 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr1908 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et1909 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en1910 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var choicelist1911 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "countries.CityTypes", "CityTypes" ], [ "lino.Genders", "Genders" ], [ "lino.UserGroups", "User Groups" ], [ "lino.UserLevels", "User Levels" ], [ "lino.UserProfiles", "User Profiles" ], [ "lino.YesNo", "Yes or no" ], [ "properties.DoYouLike", "DoYouLike" ], [ "properties.HowWell", "HowWell" ] ] });
    var default_value1912 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropTypes/default_value", "method": "GET" }) }) });
    var limit_to_choices1913 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var multiple_choices1914 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
      default_value1912.setContextValue('choicelist',record ? record.data['choicelistHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      choicelist1911.on('change',Lino.chooser_handler(default_value1912,'choicelist'));
      Lino.properties.PropTypes.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1906, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1907 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1908 }, { "colIndex": 3, "sortable": true, "header": "Designation (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et1909 }, { "colIndex": 4, "sortable": true, "header": "Designation (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en1910 }, { "colIndex": 5, "sortable": true, "header": "Choices List", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "choicelist", "editor": choicelist1911 }, { "colIndex": 6, "sortable": true, "header": "default value", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "default_value", "editor": default_value1912 }, { "colIndex": 7, "sortable": false, "xtype": "checkcolumn", "header": "Limit to choices", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "limit_to_choices" }, { "colIndex": 8, "sortable": false, "xtype": "checkcolumn", "header": "Multiple choices", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "multiple_choices" } ];
    Lino.properties.PropTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropTypes.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/PropTypes","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.properties.PropTypes.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/PropTypes","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.properties.PropTypes.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/PropTypes","GET",pk,"put",null);
};
Lino.properties.PropTypes.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/PropTypes","GET",pk,"post",null);
};

Lino.properties.PropTypes.insertPanel = Ext.extend(Lino.properties.PropTypes.DetailFormPanel,{
  empty_title: "New Property Types",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/properties/PropTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropTypes.detail;
    this.ls_insert_handler = Lino.properties.PropTypes.insert;
    Lino.properties.PropTypes.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropTypes.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.properties.PropTypes.insertPanel(p);
});
Lino.properties.PropTypes.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/PropTypes","GET",pk,"poststay",null);
};

Lino.properties.PropTypes.detailPanel = Ext.extend(Lino.properties.PropTypes.DetailFormPanel,{
  empty_title: "Detail Property Types",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/properties/PropTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropTypes.detail;
    this.ls_insert_handler = Lino.properties.PropTypes.insert;
    Lino.properties.PropTypes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropTypes.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropTypes.detailPanel(p);
});
Lino.properties.PropTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropTypes.GridPanel(p);
});

// js_render_GridPanel_class properties.Properties
Lino.properties.Properties.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/properties/Properties",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/properties/Properties','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/properties/Properties','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/properties/Properties','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Properties",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 10,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "group" }, 'groupHidden', { "name": "type" }, 'typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 16,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id1916 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1917 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr1918 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et1919 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en1920 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var group1921 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/Properties/group", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Property Group..." });
    var type1922 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/Properties/type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Property Type..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1916, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1917 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1918 }, { "colIndex": 3, "sortable": true, "header": "Designation (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et1919 }, { "colIndex": 4, "sortable": true, "header": "Designation (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en1920 }, { "colIndex": 5, "sortable": true, "header": "Property Group", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('groupHidden','Lino.properties.PropGroups.detail'), "editor": group1921, "dataIndex": "group" }, { "colIndex": 6, "sortable": true, "header": "Property Type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('typeHidden','Lino.properties.PropTypes.detail'), "editor": type1922, "dataIndex": "type" } ];
    Lino.properties.Properties.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.Properties.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/Properties","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.properties.Properties.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/Properties","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.properties.Properties.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/Properties","GET",pk,"put",null);
};
Lino.properties.Properties.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/Properties","GET",pk,"post",null);
};
Lino.properties.Properties.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.Properties.GridPanel(p);
});

// js_render_GridPanel_class properties.PropChoices
Lino.properties.PropChoices.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/properties/PropChoices",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/properties/PropChoices','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/properties/PropChoices','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/properties/PropChoices','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Property Choices",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 9,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "type" }, 'typeHidden', { "name": "value" }, { "name": "text" }, { "name": "text_fr" }, { "name": "text_et" }, { "name": "text_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 19,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id1924 = new Ext.form.NumberField({ "selectOnFocus": true });
    var type1925 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropChoices/type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Property Type..." });
    var value1926 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var text1927 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_fr1928 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_et1929 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_en1930 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1924, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Property Type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('typeHidden','Lino.properties.PropTypes.detail'), "editor": type1925, "dataIndex": "type" }, { "colIndex": 2, "sortable": true, "header": "Value", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "value", "editor": value1926 }, { "colIndex": 3, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text", "editor": text1927 }, { "colIndex": 4, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text_fr", "editor": text_fr1928 }, { "colIndex": 5, "sortable": true, "header": "Designation (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text_et", "editor": text_et1929 }, { "colIndex": 6, "sortable": true, "header": "Designation (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text_en", "editor": text_en1930 } ];
    Lino.properties.PropChoices.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropChoices.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/PropChoices","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.properties.PropChoices.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/PropChoices","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.properties.PropChoices.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/PropChoices","GET",pk,"put",null);
};
Lino.properties.PropChoices.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/PropChoices","GET",pk,"post",null);
};
Lino.properties.PropChoices.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropChoices.GridPanel(p);
});

// js_render_GridPanel_class contacts.CompanyTypes
Lino.contacts.CompanyTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/CompanyTypes",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/contacts/CompanyTypes','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/CompanyTypes','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/CompanyTypes','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "company types",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 10,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "type": "int", "name": "id" }, { "name": "abbr" }, { "name": "abbr_fr" }, { "name": "abbr_et" }, { "name": "abbr_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 25,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var name1932 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr1933 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et1934 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en1935 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1936 = new Ext.form.NumberField({ "selectOnFocus": true });
    var abbr1937 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var abbr_fr1938 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var abbr_et1939 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var abbr_en1940 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1932 }, { "colIndex": 1, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1933 }, { "colIndex": 2, "sortable": true, "header": "Designation (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et1934 }, { "colIndex": 3, "sortable": true, "header": "Designation (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en1935 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1936, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Abbreviation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "abbr", "editor": abbr1937 }, { "colIndex": 6, "sortable": true, "header": "Abbreviation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "abbr_fr", "editor": abbr_fr1938 }, { "colIndex": 7, "sortable": true, "header": "Abbreviation (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "abbr_et", "editor": abbr_et1939 }, { "colIndex": 8, "sortable": true, "header": "Abbreviation (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "abbr_en", "editor": abbr_en1940 } ];
    Lino.contacts.CompanyTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.CompanyTypes.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/CompanyTypes","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.contacts.CompanyTypes.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/CompanyTypes","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.contacts.CompanyTypes.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/CompanyTypes","GET",pk,"put",null);
};
Lino.contacts.CompanyTypes.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/CompanyTypes","GET",pk,"post",null);
};
Lino.contacts.CompanyTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.CompanyTypes.GridPanel(p);
});

// js_render_GridPanel_class contacts.Partners
Lino.contacts.Partners.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Partners",
  ls_bbar_actions : [ { "itemId": "due", "menu_item_text": "Due", "must_save": true, "panel_btn_handler": Lino.row_action_handler('due','GET',null), "text": "Due", "overflowText": "Due", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/contacts/Partners','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/Partners','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/Partners','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true }, { "itemId": "print_labels", "menu_item_text": "Labels", "must_save": true, "tooltip": "Generate mailing labels for these recipients", "panel_btn_handler": Lino.list_action_handler('/contacts/Partners','print_labels','GET',Lino.get_current_grid_config), "text": "Labels", "overflowText": "Labels", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "show_invoiceables", "menu_item_text": "Invoices to create", "must_save": true, "tooltip": "List of invoiceable items for this partner", "panel_btn_handler": Lino.row_action_handler('show_invoiceables','GET',null), "iconCls": "x-tbar-money", "overflowText": "Invoices to create", "auto_save": true } ],
  cell_edit : true,
  title : "Partners",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 34,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "name": "invoicing_address" }, 'invoicing_addressHidden', { "name": "payment_term" }, 'payment_termHidden', { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "imode" }, 'imodeHidden', { "name": "national_id_et" }, { "name": "bank_account1" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 32,
  ls_grid_configs : [  ],
  content_type : 24,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    var ww = this.containing_window;
    var name1942 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email1943 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var country1944 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Country..." });
    var city1945 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var region1946 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var zip_code1947 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr11948 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix1949 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street1950 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no1951 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box1952 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr21953 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language1954 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ], [ "en", "English" ] ] });
    var url1955 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone1956 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm1957 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax1958 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks1959 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var invoicing_address1960 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/invoicing_address", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var payment_term1961 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Payment Term..." });
    var vat_regime1962 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var imode1963 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Invoicing Mode..." });
    var national_id_et1964 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var bank_account11965 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var id1966 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city1945.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1945.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region1946.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country1944.on('change',Lino.chooser_handler(city1945,'country'));
      region1946.on('change',Lino.chooser_handler(city1945,'region'));
      country1944.on('change',Lino.chooser_handler(region1946,'country'));
      Lino.contacts.Partners.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1942 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email1943 }, { "colIndex": 2, "sortable": true, "header": "Country", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country1944, "dataIndex": "country" }, { "colIndex": 3, "sortable": true, "header": "Place", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail'), "editor": city1945, "dataIndex": "city" }, { "colIndex": 4, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail'), "editor": region1946, "dataIndex": "region" }, { "colIndex": 5, "sortable": true, "header": "Zip code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code1947 }, { "colIndex": 6, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr11948 }, { "colIndex": 7, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix1949 }, { "colIndex": 8, "sortable": true, "header": "Street", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street1950 }, { "colIndex": 9, "sortable": true, "header": "No.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no1951 }, { "colIndex": 10, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box1952 }, { "colIndex": 11, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr21953 }, { "colIndex": 12, "sortable": true, "header": "Language", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language1954 }, { "colIndex": 13, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url1955 }, { "colIndex": 14, "sortable": true, "header": "Phone", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone1956 }, { "colIndex": 15, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm1957 }, { "colIndex": 16, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax1958 }, { "colIndex": 17, "sortable": false, "header": "Remarks", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks1959, "dataIndex": "remarks" }, { "colIndex": 18, "sortable": true, "header": "Invoicing address", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('invoicing_addressHidden','Lino.contacts.Partners.detail'), "editor": invoicing_address1960, "dataIndex": "invoicing_address" }, { "colIndex": 19, "sortable": true, "header": "Payment Term", "editable": true, "tooltip": "The default payment term for sales invoices to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "payment_term", "editor": payment_term1961 }, { "colIndex": 20, "sortable": true, "header": "VAT Regime", "editable": true, "tooltip": "The default VAT regime for sales to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(25), "dataIndex": "vat_regime", "editor": vat_regime1962 }, { "colIndex": 21, "sortable": true, "header": "Invoicing Mode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "imode", "editor": imode1963 }, { "colIndex": 22, "sortable": true, "header": "National ID", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "national_id_et", "editor": national_id_et1964 }, { "colIndex": 23, "sortable": true, "header": "Bank account", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "editor": bank_account11965 }, new Lino.NullNumberColumn({ "colIndex": 24, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1966, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.Partners.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.due = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Partners","GET",pk,"due",null);
};
Lino.contacts.Partners.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Partners","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.contacts.Partners.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Partners","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.contacts.Partners.print_labels = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Partners","GET",pk,"print_labels",Lino.get_current_grid_config);
};
Lino.contacts.Partners.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Partners","GET",pk,"put",null);
};
Lino.contacts.Partners.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Partners","GET",pk,"post",null);
};

Lino.contacts.Partners.insertPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "New Partners",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/contacts/Partners",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    Lino.contacts.Partners.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Partners.insertPanel(p);
});
Lino.contacts.Partners.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Partners","GET",pk,"poststay",null);
};

Lino.contacts.Partners.detailPanel = Ext.extend(Lino.contacts.Partners.DetailFormPanel,{
  empty_title: "Detail Partners",
  ls_bbar_actions: [ { "itemId": "due", "menu_item_text": "Due", "must_save": true, "panel_btn_handler": Lino.row_action_handler('due','GET',null), "text": "Due", "overflowText": "Due", "auto_save": true }, { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "show_invoiceables", "menu_item_text": "Invoices to create", "must_save": true, "tooltip": "List of invoiceable items for this partner", "panel_btn_handler": Lino.row_action_handler('show_invoiceables','GET',null), "iconCls": "x-tbar-money", "overflowText": "Invoices to create", "auto_save": true } ],
  ls_url: "/contacts/Partners",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    Lino.contacts.Partners.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Partners.detailPanel(p);
});
Lino.contacts.Partners.create_invoice = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Partners","GET",pk,"create_invoice",null);
};
Lino.contacts.Partners.show_invoiceables = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Partners","GET",pk,"show_invoiceables",null);
};
Lino.contacts.Partners.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Partners.GridPanel(p);
});

// js_render_GridPanel_class contacts.Persons
Lino.contacts.Persons.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Persons",
  ls_bbar_actions : [ { "itemId": "due", "menu_item_text": "Due", "must_save": true, "panel_btn_handler": Lino.row_action_handler('due','GET',null), "text": "Due", "overflowText": "Due", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/contacts/Persons','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/Persons','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/Persons','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true }, { "itemId": "print_labels", "menu_item_text": "Labels", "must_save": true, "tooltip": "Generate mailing labels for these recipients", "panel_btn_handler": Lino.list_action_handler('/contacts/Persons','print_labels','GET',Lino.get_current_grid_config), "text": "Labels", "overflowText": "Labels", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "show_invoiceables", "menu_item_text": "Invoices to create", "must_save": true, "tooltip": "List of invoiceable items for this partner", "panel_btn_handler": Lino.row_action_handler('show_invoiceables','GET',null), "iconCls": "x-tbar-money", "overflowText": "Invoices to create", "auto_save": true }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Edit Print Template", "must_save": true, "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Edit Print Template", "overflowText": "Edit Print Template", "auto_save": true } ],
  cell_edit : true,
  title : "Persons",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 44,
  ls_store_fields : [ { "name": "name_column" }, { "name": "address_column" }, { "name": "email" }, { "name": "phone" }, { "name": "gsm" }, { "type": "int", "name": "id" }, { "name": "language" }, 'languageHidden', { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "name" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "url" }, { "name": "fax" }, { "name": "remarks" }, { "name": "invoicing_address" }, 'invoicing_addressHidden', { "name": "payment_term" }, 'payment_termHidden', { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "imode" }, 'imodeHidden', { "name": "national_id_et" }, { "name": "bank_account1" }, { "name": "created" }, { "name": "modified" }, { "name": "first_name" }, { "name": "last_name" }, { "name": "gender" }, 'genderHidden', { "name": "birth_date" }, { "name": "title" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 24,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    var ww = this.containing_window;
    var name_column_disp1968 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var address_column_disp1969 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var email1970 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone1971 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm1972 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1973 = new Ext.form.NumberField({ "selectOnFocus": true });
    var language1974 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ], [ "en", "English" ] ] });
    var country1975 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Country..." });
    var city1976 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var region1977 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var zip_code1978 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var name1979 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var addr11980 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix1981 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street1982 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no1983 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box1984 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr21985 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var url1986 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var fax1987 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks1988 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var invoicing_address1989 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/invoicing_address", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var payment_term1990 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Payment Term..." });
    var vat_regime1991 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var imode1992 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Invoicing Mode..." });
    var national_id_et1993 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var bank_account11994 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var created1995 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified1996 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var first_name1997 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var last_name1998 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gender1999 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.Genders) });
    var birth_date2000 = new Lino.IncompleteDateField({ "selectOnFocus": true });
    var title2001 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
      city1976.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1976.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region1977.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country1975.on('change',Lino.chooser_handler(city1976,'country'));
      region1977.on('change',Lino.chooser_handler(city1976,'region'));
      country1975.on('change',Lino.chooser_handler(region1977,'country'));
      Lino.contacts.Persons.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "name_column", "header": "Name", "editable": false }, { "width": Lino.chars2width(31), "colIndex": 1, "sortable": false, "dataIndex": "address_column", "header": "Address", "editable": false }, { "colIndex": 2, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email1970 }, { "colIndex": 3, "sortable": true, "header": "Phone", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "phone", "editor": phone1971 }, { "colIndex": 4, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "gsm", "editor": gsm1972 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1973, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Language", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "language", "editor": language1974 }, { "colIndex": 7, "sortable": true, "header": "Country", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country1975, "dataIndex": "country" }, { "colIndex": 8, "sortable": true, "header": "Place", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail'), "editor": city1976, "dataIndex": "city" }, { "colIndex": 9, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail'), "editor": region1977, "dataIndex": "region" }, { "colIndex": 10, "sortable": true, "header": "Zip code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code1978 }, { "colIndex": 11, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1979 }, { "colIndex": 12, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr11980 }, { "colIndex": 13, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix1981 }, { "colIndex": 14, "sortable": true, "header": "Street", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street1982 }, { "colIndex": 15, "sortable": true, "header": "No.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no1983 }, { "colIndex": 16, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box1984 }, { "colIndex": 17, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr21985 }, { "colIndex": 18, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url1986 }, { "colIndex": 19, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax1987 }, { "colIndex": 20, "sortable": false, "header": "Remarks", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks1988, "dataIndex": "remarks" }, { "colIndex": 21, "sortable": true, "header": "Invoicing address", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('invoicing_addressHidden','Lino.contacts.Partners.detail'), "editor": invoicing_address1989, "dataIndex": "invoicing_address" }, { "colIndex": 22, "sortable": true, "header": "Payment Term", "editable": true, "tooltip": "The default payment term for sales invoices to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "payment_term", "editor": payment_term1990 }, { "colIndex": 23, "sortable": true, "header": "VAT Regime", "editable": true, "tooltip": "The default VAT regime for sales to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(25), "dataIndex": "vat_regime", "editor": vat_regime1991 }, { "colIndex": 24, "sortable": true, "header": "Invoicing Mode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "imode", "editor": imode1992 }, { "colIndex": 25, "sortable": true, "header": "National ID", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "national_id_et", "editor": national_id_et1993 }, { "colIndex": 26, "sortable": true, "header": "Bank account", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "editor": bank_account11994 }, { "width": Lino.chars2width(17), "colIndex": 27, "sortable": true, "dataIndex": "created", "header": "Created", "editable": false }, { "width": Lino.chars2width(17), "colIndex": 28, "sortable": true, "dataIndex": "modified", "header": "Modified", "editable": false }, { "colIndex": 29, "sortable": true, "header": "First name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name1997 }, { "colIndex": 30, "sortable": true, "header": "Last name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name1998 }, { "colIndex": 31, "sortable": true, "header": "Gender", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "gender", "editor": gender1999 }, { "colIndex": 32, "sortable": true, "header": "Birth date", "editable": true, "tooltip": "Unkomplette Datumsangaben sind erlaubt, z.B. \"00.00.1980\" hei\u00dft \"irgendwann im Jahr 1980\", \"00.07.1980\" hei\u00dft \"im Juli 1980\"oder \"23.07.0000\" hei\u00dft \"an einem 23. Juli\".", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "birth_date", "editor": birth_date2000 }, { "colIndex": 33, "sortable": true, "header": "Title", "editable": true, "tooltip": "Text to print before first_name as part of the first address line.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "title", "editor": title2001 } ];
    Lino.contacts.Persons.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.due = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Persons","GET",pk,"due",null);
};
Lino.contacts.Persons.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Persons","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.contacts.Persons.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Persons","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.contacts.Persons.print_labels = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Persons","GET",pk,"print_labels",Lino.get_current_grid_config);
};
Lino.contacts.Persons.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Persons","GET",pk,"put",null);
};
Lino.contacts.Persons.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Persons","GET",pk,"post",null);
};

Lino.contacts.Persons.insertPanel = Ext.extend(Lino.contacts.Persons.InsertFormPanel,{
  empty_title: "New Persons",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/contacts/Persons",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    Lino.contacts.Persons.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Persons.insertPanel(p);
});
Lino.contacts.Persons.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Persons","GET",pk,"poststay",null);
};

Lino.contacts.Persons.detailPanel = Ext.extend(Lino.contacts.Persons.DetailFormPanel,{
  empty_title: "Detail Persons",
  ls_bbar_actions: [ { "itemId": "due", "menu_item_text": "Due", "must_save": true, "panel_btn_handler": Lino.row_action_handler('due','GET',null), "text": "Due", "overflowText": "Due", "auto_save": true }, { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "show_invoiceables", "menu_item_text": "Invoices to create", "must_save": true, "tooltip": "List of invoiceable items for this partner", "panel_btn_handler": Lino.row_action_handler('show_invoiceables','GET',null), "iconCls": "x-tbar-money", "overflowText": "Invoices to create", "auto_save": true }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Edit Print Template", "must_save": true, "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Edit Print Template", "overflowText": "Edit Print Template", "auto_save": true } ],
  ls_url: "/contacts/Persons",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    Lino.contacts.Persons.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Persons.detailPanel(p);
});
Lino.contacts.Persons.create_invoice = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Persons","GET",pk,"create_invoice",null);
};
Lino.contacts.Persons.show_invoiceables = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Persons","GET",pk,"show_invoiceables",null);
};
Lino.contacts.Persons.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Persons","GET",pk,"do_print",null);
};
Lino.contacts.Persons.edit_template = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Persons","GET",pk,"edit_template",null);
};
Lino.contacts.Persons.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Persons.GridPanel(p);
});

// js_render_GridPanel_class contacts.Companies
Lino.contacts.Companies.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Companies",
  ls_bbar_actions : [ { "itemId": "due", "menu_item_text": "Due", "must_save": true, "panel_btn_handler": Lino.row_action_handler('due','GET',null), "text": "Due", "overflowText": "Due", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/contacts/Companies','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/Companies','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/Companies','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true }, { "itemId": "print_labels", "menu_item_text": "Labels", "must_save": true, "tooltip": "Generate mailing labels for these recipients", "panel_btn_handler": Lino.list_action_handler('/contacts/Companies','print_labels','GET',Lino.get_current_grid_config), "text": "Labels", "overflowText": "Labels", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "show_invoiceables", "menu_item_text": "Invoices to create", "must_save": true, "tooltip": "List of invoiceable items for this partner", "panel_btn_handler": Lino.row_action_handler('show_invoiceables','GET',null), "iconCls": "x-tbar-money", "overflowText": "Invoices to create", "auto_save": true } ],
  cell_edit : true,
  title : "Companies",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 40,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "name": "invoicing_address" }, 'invoicing_addressHidden', { "name": "payment_term" }, 'payment_termHidden', { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "imode" }, 'imodeHidden', { "name": "national_id_et" }, { "name": "bank_account1" }, { "name": "created" }, { "name": "modified" }, { "name": "prefix" }, { "name": "vat_id" }, { "name": "type" }, 'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 38,
  ls_grid_configs : [  ],
  content_type : 24,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    var ww = this.containing_window;
    var name2003 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email2004 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var country2005 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Country..." });
    var city2006 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var region2007 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var zip_code2008 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr12009 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix2010 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street2011 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no2012 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box2013 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr22014 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language2015 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ], [ "en", "English" ] ] });
    var url2016 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone2017 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm2018 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax2019 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks2020 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var invoicing_address2021 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/invoicing_address", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var payment_term2022 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Payment Term..." });
    var vat_regime2023 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var imode2024 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Invoicing Mode..." });
    var national_id_et2025 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var bank_account12026 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var created2027 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2028 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var prefix2029 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var vat_id2030 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type2031 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a company type..." });
    var id2032 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city2006.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2006.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region2007.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country2005.on('change',Lino.chooser_handler(city2006,'country'));
      region2007.on('change',Lino.chooser_handler(city2006,'region'));
      country2005.on('change',Lino.chooser_handler(region2007,'country'));
      Lino.contacts.Companies.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2003 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email2004 }, { "colIndex": 2, "sortable": true, "header": "Country", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country2005, "dataIndex": "country" }, { "colIndex": 3, "sortable": true, "header": "Place", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail'), "editor": city2006, "dataIndex": "city" }, { "colIndex": 4, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail'), "editor": region2007, "dataIndex": "region" }, { "colIndex": 5, "sortable": true, "header": "Zip code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code2008 }, { "colIndex": 6, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr12009 }, { "colIndex": 7, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix2010 }, { "colIndex": 8, "sortable": true, "header": "Street", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street2011 }, { "colIndex": 9, "sortable": true, "header": "No.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no2012 }, { "colIndex": 10, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box2013 }, { "colIndex": 11, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr22014 }, { "colIndex": 12, "sortable": true, "header": "Language", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language2015 }, { "colIndex": 13, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url2016 }, { "colIndex": 14, "sortable": true, "header": "Phone", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone2017 }, { "colIndex": 15, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm2018 }, { "colIndex": 16, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax2019 }, { "colIndex": 17, "sortable": false, "header": "Remarks", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks2020, "dataIndex": "remarks" }, { "colIndex": 18, "sortable": true, "header": "Invoicing address", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('invoicing_addressHidden','Lino.contacts.Partners.detail'), "editor": invoicing_address2021, "dataIndex": "invoicing_address" }, { "colIndex": 19, "sortable": true, "header": "Payment Term", "editable": true, "tooltip": "The default payment term for sales invoices to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "payment_term", "editor": payment_term2022 }, { "colIndex": 20, "sortable": true, "header": "VAT Regime", "editable": true, "tooltip": "The default VAT regime for sales to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(25), "dataIndex": "vat_regime", "editor": vat_regime2023 }, { "colIndex": 21, "sortable": true, "header": "Invoicing Mode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "imode", "editor": imode2024 }, { "colIndex": 22, "sortable": true, "header": "National ID", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "national_id_et", "editor": national_id_et2025 }, { "colIndex": 23, "sortable": true, "header": "Bank account", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "editor": bank_account12026 }, { "width": Lino.chars2width(17), "colIndex": 24, "sortable": true, "dataIndex": "created", "header": "Created", "editable": false }, { "width": Lino.chars2width(17), "colIndex": 25, "sortable": true, "dataIndex": "modified", "header": "Modified", "editable": false }, { "colIndex": 26, "sortable": true, "header": "prefix", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "prefix", "editor": prefix2029 }, { "colIndex": 27, "sortable": true, "header": "VAT id", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "vat_id", "editor": vat_id2030 }, { "colIndex": 28, "sortable": true, "header": "Company type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type2031 }, new Lino.NullNumberColumn({ "colIndex": 29, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2032, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.Companies.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.due = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Companies","GET",pk,"due",null);
};
Lino.contacts.Companies.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Companies","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.contacts.Companies.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Companies","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.contacts.Companies.print_labels = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Companies","GET",pk,"print_labels",Lino.get_current_grid_config);
};
Lino.contacts.Companies.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Companies","GET",pk,"put",null);
};
Lino.contacts.Companies.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Companies","GET",pk,"post",null);
};

Lino.contacts.Companies.insertPanel = Ext.extend(Lino.contacts.Companies.InsertFormPanel,{
  empty_title: "New Companies",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/contacts/Companies",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    Lino.contacts.Companies.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Companies.insertPanel(p);
});
Lino.contacts.Companies.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Companies","GET",pk,"poststay",null);
};

Lino.contacts.Companies.detailPanel = Ext.extend(Lino.contacts.Companies.DetailFormPanel,{
  empty_title: "Detail Companies",
  ls_bbar_actions: [ { "itemId": "due", "menu_item_text": "Due", "must_save": true, "panel_btn_handler": Lino.row_action_handler('due','GET',null), "text": "Due", "overflowText": "Due", "auto_save": true }, { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "show_invoiceables", "menu_item_text": "Invoices to create", "must_save": true, "tooltip": "List of invoiceable items for this partner", "panel_btn_handler": Lino.row_action_handler('show_invoiceables','GET',null), "iconCls": "x-tbar-money", "overflowText": "Invoices to create", "auto_save": true } ],
  ls_url: "/contacts/Companies",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    Lino.contacts.Companies.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Companies.detailPanel(p);
});
Lino.contacts.Companies.create_invoice = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Companies","GET",pk,"create_invoice",null);
};
Lino.contacts.Companies.show_invoiceables = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Companies","GET",pk,"show_invoiceables",null);
};
Lino.contacts.Companies.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Companies.GridPanel(p);
});

// js_render_GridPanel_class contacts.RoleTypes
Lino.contacts.RoleTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/RoleTypes",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/contacts/RoleTypes','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/RoleTypes','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/RoleTypes','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Functions",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 20,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id2034 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2035 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2036 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2037 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en2038 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2034, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2035 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2036 }, { "colIndex": 3, "sortable": true, "header": "Designation (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et2037 }, { "colIndex": 4, "sortable": true, "header": "Designation (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en2038 } ];
    Lino.contacts.RoleTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.RoleTypes.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RoleTypes","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.contacts.RoleTypes.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RoleTypes","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.contacts.RoleTypes.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RoleTypes","GET",pk,"put",null);
};
Lino.contacts.RoleTypes.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RoleTypes","GET",pk,"post",null);
};
Lino.contacts.RoleTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.RoleTypes.GridPanel(p);
});

// js_render_GridPanel_class contacts.Roles
Lino.contacts.Roles.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Roles",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/contacts/Roles','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/Roles','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/Roles','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Contact Persons",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 8,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "type" }, 'typeHidden', { "name": "person" }, 'personHidden', { "name": "company" }, 'companyHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 23,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id2040 = new Ext.form.NumberField({ "selectOnFocus": true });
    var type2041 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Roles/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Function..." });
    var person2042 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Roles/person", "method": "GET" }) }), "emptyText": "Select a Person..." });
    var company2043 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Roles/company", "method": "GET" }) }), "emptyText": "Select a Company..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2040, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Contact Role", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type2041 }, { "colIndex": 2, "sortable": true, "header": "Person", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('personHidden','Lino.contacts.Persons.detail'), "editor": person2042, "dataIndex": "person" }, { "colIndex": 3, "sortable": true, "header": "Company", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('companyHidden','Lino.contacts.Companies.detail'), "editor": company2043, "dataIndex": "company" } ];
    Lino.contacts.Roles.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Roles.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Roles","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.contacts.Roles.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Roles","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.contacts.Roles.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Roles","GET",pk,"put",null);
};
Lino.contacts.Roles.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Roles","GET",pk,"post",null);
};
Lino.contacts.Roles.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Roles.GridPanel(p);
});

// js_render_GridPanel_class households.Types
Lino.households.Types.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/households/Types",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/households/Types','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/households/Types','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/households/Types','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Household Types",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 29,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Types.detail;
    this.ls_insert_handler = Lino.households.Types.insert;
    var ww = this.containing_window;
    var id2045 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2046 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2047 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2048 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en2049 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2045, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2046 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2047 }, { "colIndex": 3, "sortable": true, "header": "Designation (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et2048 }, { "colIndex": 4, "sortable": true, "header": "Designation (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en2049 } ];
    Lino.households.Types.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Types.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Types","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.households.Types.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Types","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.households.Types.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Types","GET",pk,"put",null);
};
Lino.households.Types.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Types","GET",pk,"post",null);
};

Lino.households.Types.insertPanel = Ext.extend(Lino.households.Types.DetailFormPanel,{
  empty_title: "New Household Types",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/households/Types",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Types.detail;
    this.ls_insert_handler = Lino.households.Types.insert;
    Lino.households.Types.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Types.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.households.Types.insertPanel(p);
});
Lino.households.Types.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Types","GET",pk,"poststay",null);
};

Lino.households.Types.detailPanel = Ext.extend(Lino.households.Types.DetailFormPanel,{
  empty_title: "Detail Household Types",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/households/Types",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Types.detail;
    this.ls_insert_handler = Lino.households.Types.insert;
    Lino.households.Types.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Types.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Types.detailPanel(p);
});
Lino.households.Types.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Types.GridPanel(p);
});

// js_render_GridPanel_class households.Households
Lino.households.Households.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/households/Households",
  ls_bbar_actions : [ { "itemId": "due", "menu_item_text": "Due", "must_save": true, "panel_btn_handler": Lino.row_action_handler('due','GET',null), "text": "Due", "overflowText": "Due", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/households/Households','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/households/Households','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/households/Households','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true }, { "itemId": "print_labels", "menu_item_text": "Labels", "must_save": true, "tooltip": "Generate mailing labels for these recipients", "panel_btn_handler": Lino.list_action_handler('/households/Households','print_labels','GET',Lino.get_current_grid_config), "text": "Labels", "overflowText": "Labels", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "show_invoiceables", "menu_item_text": "Invoices to create", "must_save": true, "tooltip": "List of invoiceable items for this partner", "panel_btn_handler": Lino.row_action_handler('show_invoiceables','GET',null), "iconCls": "x-tbar-money", "overflowText": "Invoices to create", "auto_save": true } ],
  cell_edit : true,
  title : "Households",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 39,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "name": "invoicing_address" }, 'invoicing_addressHidden', { "name": "payment_term" }, 'payment_termHidden', { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "imode" }, 'imodeHidden', { "name": "national_id_et" }, { "name": "bank_account1" }, { "name": "created" }, { "name": "modified" }, { "name": "prefix" }, { "name": "type" }, 'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 37,
  ls_grid_configs : [  ],
  content_type : 24,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Households.detail;
    this.ls_insert_handler = Lino.households.Households.insert;
    var ww = this.containing_window;
    var name2051 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email2052 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var country2053 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Country..." });
    var city2054 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var region2055 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var zip_code2056 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr12057 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix2058 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street2059 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no2060 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box2061 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr22062 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language2063 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ], [ "en", "English" ] ] });
    var url2064 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone2065 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm2066 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax2067 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks2068 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var invoicing_address2069 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/invoicing_address", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var payment_term2070 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Payment Term..." });
    var vat_regime2071 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var imode2072 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Invoicing Mode..." });
    var national_id_et2073 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var bank_account12074 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var created2075 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2076 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var prefix2077 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type2078 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Household Type..." });
    var id2079 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city2054.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2054.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region2055.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country2053.on('change',Lino.chooser_handler(city2054,'country'));
      region2055.on('change',Lino.chooser_handler(city2054,'region'));
      country2053.on('change',Lino.chooser_handler(region2055,'country'));
      Lino.households.Households.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2051 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email2052 }, { "colIndex": 2, "sortable": true, "header": "Country", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country2053, "dataIndex": "country" }, { "colIndex": 3, "sortable": true, "header": "Place", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail'), "editor": city2054, "dataIndex": "city" }, { "colIndex": 4, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail'), "editor": region2055, "dataIndex": "region" }, { "colIndex": 5, "sortable": true, "header": "Zip code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "editor": zip_code2056 }, { "colIndex": 6, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "editor": addr12057 }, { "colIndex": 7, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "editor": street_prefix2058 }, { "colIndex": 8, "sortable": true, "header": "Street", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "editor": street2059 }, { "colIndex": 9, "sortable": true, "header": "No.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "editor": street_no2060 }, { "colIndex": 10, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "editor": street_box2061 }, { "colIndex": 11, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "editor": addr22062 }, { "colIndex": 12, "sortable": true, "header": "Language", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language2063 }, { "colIndex": 13, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "editor": url2064 }, { "colIndex": 14, "sortable": true, "header": "Phone", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "editor": phone2065 }, { "colIndex": 15, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "editor": gsm2066 }, { "colIndex": 16, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "editor": fax2067 }, { "colIndex": 17, "sortable": false, "header": "Remarks", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remarks2068, "dataIndex": "remarks" }, { "colIndex": 18, "sortable": true, "header": "Invoicing address", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('invoicing_addressHidden','Lino.contacts.Partners.detail'), "editor": invoicing_address2069, "dataIndex": "invoicing_address" }, { "colIndex": 19, "sortable": true, "header": "Payment Term", "editable": true, "tooltip": "The default payment term for sales invoices to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "payment_term", "editor": payment_term2070 }, { "colIndex": 20, "sortable": true, "header": "VAT Regime", "editable": true, "tooltip": "The default VAT regime for sales to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(25), "dataIndex": "vat_regime", "editor": vat_regime2071 }, { "colIndex": 21, "sortable": true, "header": "Invoicing Mode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "imode", "editor": imode2072 }, { "colIndex": 22, "sortable": true, "header": "National ID", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "national_id_et", "editor": national_id_et2073 }, { "colIndex": 23, "sortable": true, "header": "Bank account", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "editor": bank_account12074 }, { "width": Lino.chars2width(17), "colIndex": 24, "sortable": true, "dataIndex": "created", "header": "Created", "editable": false }, { "width": Lino.chars2width(17), "colIndex": 25, "sortable": true, "dataIndex": "modified", "header": "Modified", "editable": false }, { "colIndex": 26, "sortable": true, "header": "prefix", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "prefix", "editor": prefix2077 }, { "colIndex": 27, "sortable": true, "header": "Household Type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('typeHidden','Lino.households.Types.detail'), "editor": type2078, "dataIndex": "type" }, new Lino.NullNumberColumn({ "colIndex": 28, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2079, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.households.Households.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Households.due = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Households","GET",pk,"due",null);
};
Lino.households.Households.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Households","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.households.Households.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Households","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.households.Households.print_labels = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Households","GET",pk,"print_labels",Lino.get_current_grid_config);
};
Lino.households.Households.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Households","GET",pk,"put",null);
};
Lino.households.Households.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Households","GET",pk,"post",null);
};

Lino.households.Households.insertPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "New Households",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/households/Households",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Households.detail;
    this.ls_insert_handler = Lino.households.Households.insert;
    Lino.households.Households.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Households.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.households.Households.insertPanel(p);
});
Lino.households.Households.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Households","GET",pk,"poststay",null);
};

Lino.households.Households.detailPanel = Ext.extend(Lino.households.Households.DetailFormPanel,{
  empty_title: "Detail Households",
  ls_bbar_actions: [ { "itemId": "due", "menu_item_text": "Due", "must_save": true, "panel_btn_handler": Lino.row_action_handler('due','GET',null), "text": "Due", "overflowText": "Due", "auto_save": true }, { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "show_invoiceables", "menu_item_text": "Invoices to create", "must_save": true, "tooltip": "List of invoiceable items for this partner", "panel_btn_handler": Lino.row_action_handler('show_invoiceables','GET',null), "iconCls": "x-tbar-money", "overflowText": "Invoices to create", "auto_save": true } ],
  ls_url: "/households/Households",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Households.detail;
    this.ls_insert_handler = Lino.households.Households.insert;
    Lino.households.Households.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Households.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Households.detailPanel(p);
});
Lino.households.Households.create_invoice = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Households","GET",pk,"create_invoice",null);
};
Lino.households.Households.show_invoiceables = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Households","GET",pk,"show_invoiceables",null);
};
Lino.households.Households.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Households.GridPanel(p);
});

// js_render_GridPanel_class households.Roles
Lino.households.Roles.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/households/Roles",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/households/Roles','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/households/Roles','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/households/Roles','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Household Roles",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "type": "boolean", "name": "name_giving" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 27,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Roles.detail;
    this.ls_insert_handler = Lino.households.Roles.insert;
    var ww = this.containing_window;
    var id2081 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2082 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2083 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2084 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en2085 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_giving2086 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2081, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2082 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2083 }, { "colIndex": 3, "sortable": true, "header": "Designation (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et2084 }, { "colIndex": 4, "sortable": true, "header": "Designation (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en2085 }, { "colIndex": 5, "sortable": false, "xtype": "checkcolumn", "header": "name-giving", "editable": true, "tooltip": "When the `name` field of a Household is empty, \nits value is computed by joining the `Last Name` \nof all name-giving members with a dash (\"-\").\n      ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "name_giving" } ];
    Lino.households.Roles.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Roles.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Roles","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.households.Roles.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Roles","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.households.Roles.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Roles","GET",pk,"put",null);
};
Lino.households.Roles.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Roles","GET",pk,"post",null);
};

Lino.households.Roles.insertPanel = Ext.extend(Lino.households.Roles.DetailFormPanel,{
  empty_title: "New Household Roles",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/households/Roles",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Roles.detail;
    this.ls_insert_handler = Lino.households.Roles.insert;
    Lino.households.Roles.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Roles.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.households.Roles.insertPanel(p);
});
Lino.households.Roles.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Roles","GET",pk,"poststay",null);
};

Lino.households.Roles.detailPanel = Ext.extend(Lino.households.Roles.DetailFormPanel,{
  empty_title: "Detail Household Roles",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/households/Roles",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Roles.detail;
    this.ls_insert_handler = Lino.households.Roles.insert;
    Lino.households.Roles.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Roles.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Roles.detailPanel(p);
});
Lino.households.Roles.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Roles.GridPanel(p);
});

// js_render_GridPanel_class households.Members
Lino.households.Members.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/households/Members",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/households/Members','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/households/Members','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/households/Members','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Household Members",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 10,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "role" }, 'roleHidden', { "name": "household" }, 'householdHidden', { "name": "person" }, 'personHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 26,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id2088 = new Ext.form.NumberField({ "selectOnFocus": true });
    var role2089 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Members/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Household Role..." });
    var household2090 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Members/household", "method": "GET" }) }), "emptyText": "Select a Household..." });
    var person2091 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Members/person", "method": "GET" }) }), "emptyText": "Select a Person..." });
    var start_date2092 = new Lino.DateField({ "selectOnFocus": true });
    var end_date2093 = new Lino.DateField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2088, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Household Role", "editable": true, "tooltip": "The Role of this Person in this Household.\nList of choices is configured in `Configure --> Households --> Roles`.\n", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('roleHidden','Lino.households.Roles.detail'), "editor": role2089, "dataIndex": "role" }, { "colIndex": 2, "sortable": true, "header": "Household", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('householdHidden','Lino.households.Households.detail'), "editor": household2090, "dataIndex": "household" }, { "colIndex": 3, "sortable": true, "header": "Person", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('personHidden','Lino.contacts.Persons.detail'), "editor": person2091, "dataIndex": "person" }, { "colIndex": 4, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "From", "editor": start_date2092, "width": Lino.chars2width(9), "dataIndex": "start_date" }, { "colIndex": 5, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Until", "editor": end_date2093, "width": Lino.chars2width(9), "dataIndex": "end_date" } ];
    Lino.households.Members.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Members.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Members","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.households.Members.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Members","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.households.Members.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Members","GET",pk,"put",null);
};
Lino.households.Members.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Members","GET",pk,"post",null);
};
Lino.households.Members.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Members.GridPanel(p);
});

// js_render_GridPanel_class accounts.Charts
Lino.accounts.Charts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/accounts/Charts",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/accounts/Charts','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/accounts/Charts','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/accounts/Charts','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Account Charts",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 34,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Charts.detail;
    this.ls_insert_handler = Lino.accounts.Charts.insert;
    var ww = this.containing_window;
    var id2095 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2096 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2097 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2098 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en2099 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2095, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2096 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2097 }, { "colIndex": 3, "sortable": true, "header": "Designation (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et2098 }, { "colIndex": 4, "sortable": true, "header": "Designation (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en2099 } ];
    Lino.accounts.Charts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Charts.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Charts","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.accounts.Charts.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Charts","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.accounts.Charts.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Charts","GET",pk,"put",null);
};
Lino.accounts.Charts.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Charts","GET",pk,"post",null);
};

Lino.accounts.Charts.insertPanel = Ext.extend(Lino.accounts.Charts.DetailFormPanel,{
  empty_title: "New Account Charts",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/accounts/Charts",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Charts.detail;
    this.ls_insert_handler = Lino.accounts.Charts.insert;
    Lino.accounts.Charts.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Charts.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.accounts.Charts.insertPanel(p);
});
Lino.accounts.Charts.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Charts","GET",pk,"poststay",null);
};

Lino.accounts.Charts.detailPanel = Ext.extend(Lino.accounts.Charts.DetailFormPanel,{
  empty_title: "Detail Account Charts",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/accounts/Charts",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Charts.detail;
    this.ls_insert_handler = Lino.accounts.Charts.insert;
    Lino.accounts.Charts.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Charts.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Charts.detailPanel(p);
});
Lino.accounts.Charts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Charts.GridPanel(p);
});

// js_render_GridPanel_class accounts.Groups
Lino.accounts.Groups.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/accounts/Groups",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/accounts/Groups','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/accounts/Groups','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/accounts/Groups','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Account Groups",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 11,
  ls_store_fields : [ { "name": "chart" }, 'chartHidden', { "name": "ref" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "account_type" }, 'account_typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 9,
  ls_grid_configs : [  ],
  content_type : 33,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Groups.detail;
    this.ls_insert_handler = Lino.accounts.Groups.insert;
    var ww = this.containing_window;
    var chart2101 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Groups/chart", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account Chart..." });
    var ref2102 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var name2103 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2104 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2105 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en2106 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var account_type2107 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.accounts.AccountTypes) });
    var id2108 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Account Chart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('chartHidden','Lino.accounts.Charts.detail'), "editor": chart2101, "dataIndex": "chart" }, { "colIndex": 1, "sortable": true, "header": "ref", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ref", "editor": ref2102 }, { "colIndex": 2, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2103 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2104 }, { "colIndex": 4, "sortable": true, "header": "Designation (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et2105 }, { "colIndex": 5, "sortable": true, "header": "Designation (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en2106 }, { "colIndex": 6, "sortable": true, "header": "Account Type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "account_type", "editor": account_type2107 }, new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2108, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.accounts.Groups.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Groups.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Groups","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.accounts.Groups.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Groups","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.accounts.Groups.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Groups","GET",pk,"put",null);
};
Lino.accounts.Groups.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Groups","GET",pk,"post",null);
};

Lino.accounts.Groups.insertPanel = Ext.extend(Lino.accounts.Groups.DetailFormPanel,{
  empty_title: "New Account Groups",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/accounts/Groups",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Groups.detail;
    this.ls_insert_handler = Lino.accounts.Groups.insert;
    Lino.accounts.Groups.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Groups.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.accounts.Groups.insertPanel(p);
});
Lino.accounts.Groups.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Groups","GET",pk,"poststay",null);
};

Lino.accounts.Groups.detailPanel = Ext.extend(Lino.accounts.Groups.DetailFormPanel,{
  empty_title: "Detail Account Groups",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/accounts/Groups",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Groups.detail;
    this.ls_insert_handler = Lino.accounts.Groups.insert;
    Lino.accounts.Groups.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Groups.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Groups.detailPanel(p);
});
Lino.accounts.Groups.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Groups.GridPanel(p);
});

// js_render_GridPanel_class accounts.Accounts
Lino.accounts.Accounts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/accounts/Accounts",
  ls_bbar_actions : [ { "itemId": "due", "menu_item_text": "Due", "must_save": true, "panel_btn_handler": Lino.row_action_handler('due','GET',null), "text": "Due", "overflowText": "Due", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/accounts/Accounts','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/accounts/Accounts','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/accounts/Accounts','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-arrow_up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-arrow_down", "overflowText": "Down", "auto_save": true } ],
  cell_edit : true,
  title : "Accounts",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 18,
  ls_store_fields : [ { "name": "ref" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "group" }, 'groupHidden', { "type": "int", "name": "id" }, { "type": "int", "name": "seqno" }, { "name": "chart" }, 'chartHidden', { "name": "type" }, 'typeHidden', { "type": "boolean", "name": "sales_allowed" }, { "type": "boolean", "name": "purchases_allowed" }, { "type": "boolean", "name": "wages_allowed" }, { "type": "boolean", "name": "clearable" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 32,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var ref2110 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var name2111 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2112 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2113 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en2114 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var group2115 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Accounts/group", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account Group..." });
    var id2116 = new Ext.form.NumberField({ "selectOnFocus": true });
    var seqno2117 = new Ext.form.NumberField({ "selectOnFocus": true });
    var chart2118 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Accounts/chart", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account Chart..." });
    var type2119 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.accounts.AccountTypes });
    var sales_allowed2120 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var purchases_allowed2121 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var wages_allowed2122 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var clearable2123 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ref", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ref", "editor": ref2110 }, { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2111 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2112 }, { "colIndex": 3, "sortable": true, "header": "Designation (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et2113 }, { "colIndex": 4, "sortable": true, "header": "Designation (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en2114 }, { "colIndex": 5, "sortable": true, "header": "Account Group", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('groupHidden','Lino.accounts.Groups.detail'), "editor": group2115, "dataIndex": "group" }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2116, "width": Lino.chars2width(6), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "width": Lino.chars2width(6), "editor": seqno2117 }), { "colIndex": 8, "sortable": true, "header": "Account Chart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('chartHidden','Lino.accounts.Charts.detail'), "editor": chart2118, "dataIndex": "chart" }, { "colIndex": 9, "sortable": true, "header": "Account Type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "type", "editor": type2119 }, { "colIndex": 10, "sortable": false, "xtype": "checkcolumn", "header": "Sales", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "sales_allowed" }, { "colIndex": 11, "sortable": false, "xtype": "checkcolumn", "header": "Purchases", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "purchases_allowed" }, { "colIndex": 12, "sortable": false, "xtype": "checkcolumn", "header": "Wages", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "wages_allowed" }, { "colIndex": 13, "sortable": false, "xtype": "checkcolumn", "header": "Clearable", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "clearable" } ];
    Lino.accounts.Accounts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Accounts.due = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Accounts","GET",pk,"due",null);
};
Lino.accounts.Accounts.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Accounts","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.accounts.Accounts.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Accounts","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.accounts.Accounts.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Accounts","GET",pk,"put",null);
};
Lino.accounts.Accounts.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Accounts","GET",pk,"post",null);
};
Lino.accounts.Accounts.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Accounts","GET",pk,"duplicate",null);
};
Lino.accounts.Accounts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Accounts.GridPanel(p);
});
Lino.accounts.Accounts.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Accounts","GET",pk,"move_up",null);
};
Lino.accounts.Accounts.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Accounts","GET",pk,"move_down",null);
};

// js_render_GridPanel_class products.ProductCats
Lino.products.ProductCats.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/products/ProductCats",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/products/ProductCats','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/products/ProductCats','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/products/ProductCats','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Product Categories",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "description" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 30,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.products.ProductCats.detail;
    this.ls_insert_handler = Lino.products.ProductCats.insert;
    var ww = this.containing_window;
    var id2125 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2126 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2127 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2128 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en2129 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var description2130 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2125, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2126 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2127 }, { "colIndex": 3, "sortable": true, "header": "Designation (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et2128 }, { "colIndex": 4, "sortable": true, "header": "Designation (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en2129 }, { "colIndex": 5, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": description2130, "dataIndex": "description" } ];
    Lino.products.ProductCats.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.products.ProductCats.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/ProductCats","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.products.ProductCats.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/ProductCats","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.products.ProductCats.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/ProductCats","GET",pk,"put",null);
};
Lino.products.ProductCats.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/ProductCats","GET",pk,"post",null);
};

Lino.products.ProductCats.insertPanel = Ext.extend(Lino.products.ProductCats.DetailFormPanel,{
  empty_title: "New Product Categories",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/products/ProductCats",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.products.ProductCats.detail;
    this.ls_insert_handler = Lino.products.ProductCats.insert;
    Lino.products.ProductCats.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.products.ProductCats.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.products.ProductCats.insertPanel(p);
});
Lino.products.ProductCats.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/ProductCats","GET",pk,"poststay",null);
};

Lino.products.ProductCats.detailPanel = Ext.extend(Lino.products.ProductCats.DetailFormPanel,{
  empty_title: "Detail Product Categories",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/products/ProductCats",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.products.ProductCats.detail;
    this.ls_insert_handler = Lino.products.ProductCats.insert;
    Lino.products.ProductCats.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.products.ProductCats.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.products.ProductCats.detailPanel(p);
});
Lino.products.ProductCats.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.products.ProductCats.GridPanel(p);
});

// js_render_GridPanel_class products.Products
Lino.products.Products.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/products/Products",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/products/Products','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/products/Products','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/products/Products','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Products",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 15,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "cat" }, 'catHidden', { "name": "vat_class" }, 'vat_classHidden', { "name": "sales_price" }, { "name": "sales_account" }, 'sales_accountHidden', { "name": "purchases_account" }, 'purchases_accountHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.products.Products.detail;
    this.ls_insert_handler = Lino.products.Products.insert;
    var ww = this.containing_window;
    var id2132 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2133 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2134 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2135 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en2136 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var cat2137 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/products/Products/cat", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Product Category..." });
    var vat_class2138 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.vat.VatClasses) });
    var sales_price2139 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var sales_account2140 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/products/Products/sales_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var purchases_account2141 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/products/Products/purchases_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2132, "width": Lino.chars2width(4), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2133 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2134 }, { "colIndex": 3, "sortable": true, "header": "Designation (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et2135 }, { "colIndex": 4, "sortable": true, "header": "Designation (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en2136 }, { "colIndex": 5, "sortable": true, "header": "Category", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('catHidden','Lino.products.ProductCats.detail'), "editor": cat2137, "dataIndex": "cat" }, { "colIndex": 6, "sortable": true, "header": "VAT Class", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(24), "dataIndex": "vat_class", "editor": vat_class2138 }, new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "header": "Sales price", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(7), "dataIndex": "sales_price", "editor": sales_price2139 }), { "colIndex": 8, "sortable": true, "header": "Sales Base account", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "sales_account", "editor": sales_account2140 }, { "colIndex": 9, "sortable": true, "header": "Purchases Base account", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "purchases_account", "editor": purchases_account2141 } ];
    Lino.products.Products.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.products.Products.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/Products","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.products.Products.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/Products","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.products.Products.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/Products","GET",pk,"put",null);
};
Lino.products.Products.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/Products","GET",pk,"post",null);
};

Lino.products.Products.insertPanel = Ext.extend(Lino.products.Products.DetailFormPanel,{
  empty_title: "New Products",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/products/Products",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.products.Products.detail;
    this.ls_insert_handler = Lino.products.Products.insert;
    Lino.products.Products.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.products.Products.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.products.Products.insertPanel(p);
});
Lino.products.Products.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/Products","GET",pk,"poststay",null);
};

Lino.products.Products.detailPanel = Ext.extend(Lino.products.Products.DetailFormPanel,{
  empty_title: "Detail Products",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/products/Products",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.products.Products.detail;
    this.ls_insert_handler = Lino.products.Products.insert;
    Lino.products.Products.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.products.Products.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.products.Products.detailPanel(p);
});
Lino.products.Products.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.products.Products.GridPanel(p);
});

// js_render_GridPanel_class ledger.Journals
Lino.ledger.Journals.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/ledger/Journals",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/ledger/Journals','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/Journals','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/Journals','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-arrow_up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-arrow_down", "overflowText": "Down", "auto_save": true } ],
  cell_edit : true,
  title : "Journals",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 25,
  ls_store_fields : [ { "name": "ref" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "trade_type" }, 'trade_typeHidden', { "name": "voucher_type" }, 'voucher_typeHidden', { "type": "boolean", "name": "force_sequence" }, { "name": "build_method" }, 'build_methodHidden', { "name": "template" }, { "name": "chart" }, 'chartHidden', { "name": "account" }, 'accountHidden', { "name": "printed_name" }, { "name": "printed_name_fr" }, { "name": "printed_name_et" }, { "name": "printed_name_en" }, { "type": "boolean", "name": "dc" }, { "type": "int", "name": "seqno" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 23,
  ls_grid_configs : [  ],
  content_type : 35,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Journals.detail;
    this.ls_insert_handler = Lino.ledger.Journals.insert;
    var ww = this.containing_window;
    var ref2143 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var name2144 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2145 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2146 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en2147 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var trade_type2148 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.vat.TradeTypes) });
    var voucher_type2149 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.ledger.VoucherTypes });
    var force_sequence2150 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var build_method2151 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template2152 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Journals/template", "method": "GET" }) }) });
    var chart2153 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Journals/chart", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account Chart..." });
    var account2154 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Journals/account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var printed_name2155 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var printed_name_fr2156 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var printed_name_et2157 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var printed_name_en2158 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var dc2159 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": null });
    var seqno2160 = new Ext.form.NumberField({ "selectOnFocus": true });
    var id2161 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      template2152.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      template2152.setContextValue('voucher_type',record ? record.data['voucher_typeHidden'] : undefined);
      account2154.setContextValue('chart',record ? record.data['chartHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      build_method2151.on('change',Lino.chooser_handler(template2152,'build_method'));
      voucher_type2149.on('change',Lino.chooser_handler(template2152,'voucher_type'));
      chart2153.on('change',Lino.chooser_handler(account2154,'chart'));
      Lino.ledger.Journals.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ref", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "ref", "editor": ref2143 }, { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2144 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2145 }, { "colIndex": 3, "sortable": true, "header": "Designation (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et2146 }, { "colIndex": 4, "sortable": true, "header": "Designation (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en2147 }, { "colIndex": 5, "sortable": true, "header": "Trade Type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "trade_type", "editor": trade_type2148 }, { "colIndex": 6, "sortable": true, "header": "voucher type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(36), "dataIndex": "voucher_type", "editor": voucher_type2149 }, { "colIndex": 7, "sortable": false, "xtype": "checkcolumn", "header": "Force chronological sequence", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "force_sequence" }, { "colIndex": 8, "sortable": true, "header": "Build method", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "build_method", "editor": build_method2151 }, { "colIndex": 9, "sortable": true, "header": "Template", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "template", "editor": template2152 }, { "colIndex": 10, "sortable": true, "header": "Account Chart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('chartHidden','Lino.accounts.Charts.detail'), "editor": chart2153, "dataIndex": "chart" }, { "colIndex": 11, "sortable": true, "header": "Account", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "account", "editor": account2154 }, { "colIndex": 12, "sortable": true, "header": "printed name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "printed_name", "editor": printed_name2155 }, { "colIndex": 13, "sortable": true, "header": "printed name (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "printed_name_fr", "editor": printed_name_fr2156 }, { "colIndex": 14, "sortable": true, "header": "printed name (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "printed_name_et", "editor": printed_name_et2157 }, { "colIndex": 15, "sortable": true, "header": "printed name (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "printed_name_en", "editor": printed_name_en2158 }, { "colIndex": 16, "sortable": false, "xtype": "checkcolumn", "header": "dc", "editable": true, "tooltip": "Debit (checked) or Credit (not checked)", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "dc" }, new Lino.NullNumberColumn({ "colIndex": 17, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "width": Lino.chars2width(6), "editor": seqno2160 }), new Lino.NullNumberColumn({ "colIndex": 18, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2161, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.ledger.Journals.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Journals.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Journals","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.ledger.Journals.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Journals","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.ledger.Journals.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Journals","GET",pk,"put",null);
};
Lino.ledger.Journals.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Journals","GET",pk,"post",null);
};

Lino.ledger.Journals.insertPanel = Ext.extend(Lino.ledger.Journals.InsertFormPanel,{
  empty_title: "New Journals",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true } ],
  ls_url: "/ledger/Journals",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Journals.detail;
    this.ls_insert_handler = Lino.ledger.Journals.insert;
    Lino.ledger.Journals.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Journals.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.ledger.Journals.insertPanel(p);
});
Lino.ledger.Journals.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Journals","GET",pk,"poststay",null);
};
Lino.ledger.Journals.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Journals","GET",pk,"duplicate",null);
};

Lino.ledger.Journals.detailPanel = Ext.extend(Lino.ledger.Journals.DetailFormPanel,{
  empty_title: "Detail Journals",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-arrow_up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-arrow_down", "overflowText": "Down", "auto_save": true } ],
  ls_url: "/ledger/Journals",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Journals.detail;
    this.ls_insert_handler = Lino.ledger.Journals.insert;
    Lino.ledger.Journals.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Journals.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.Journals.detailPanel(p);
});
Lino.ledger.Journals.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.Journals.GridPanel(p);
});
Lino.ledger.Journals.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Journals","GET",pk,"move_up",null);
};
Lino.ledger.Journals.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Journals","GET",pk,"move_down",null);
};

// js_render_GridPanel_class ledger.Vouchers
Lino.ledger.Vouchers.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "emptyText": "No data to display." },
  ls_url : "/ledger/Vouchers",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/ledger/Vouchers','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/Vouchers','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/Vouchers','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" } ],
  cell_edit : true,
  title : "Vouchers",
  page_length : 20,
  stripeRows : true,
  disable_editing : true,
  disabled_actions_index : 11,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "type": "int", "name": "number" }, { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "journal" }, 'journalHidden', { "name": "year" }, 'yearHidden', { "name": "narration" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 38,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var date2163 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var number2164 = new Ext.form.NumberField({ "selectOnFocus": true });
    var id2165 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user2166 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Vouchers/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var journal2167 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Vouchers/journal", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Journal..." });
    var year2168 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var narration2169 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "editor": date2163, "width": Lino.chars2width(9), "dataIndex": "date" }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(6), "editor": number2164 }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2165, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 3, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2166, "dataIndex": "user" }, { "colIndex": 4, "sortable": true, "header": "Journal", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('journalHidden','Lino.ledger.Journals.detail'), "editor": journal2167, "dataIndex": "journal" }, { "colIndex": 5, "sortable": true, "header": "Fiscal Year", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "year", "editor": year2168 }, { "colIndex": 6, "sortable": true, "header": "Narration", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "narration", "editor": narration2169 } ];
    Lino.ledger.Vouchers.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Vouchers.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Vouchers","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.ledger.Vouchers.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Vouchers","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.ledger.Vouchers.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.Vouchers.GridPanel(p);
});

// js_render_GridPanel_class ledger.Movements
Lino.ledger.Movements.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "emptyText": "No data to display." },
  ls_url : "/ledger/Movements",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/ledger/Movements','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/Movements','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/Movements','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" } ],
  cell_edit : true,
  title : "Movements",
  page_length : 20,
  stripeRows : true,
  disable_editing : true,
  disabled_actions_index : 16,
  ls_store_fields : [ { "name": "voucher_link" }, { "name": "account" }, 'accountHidden', { "name": "debit" }, { "name": "credit" }, { "type": "int", "name": "id" }, { "name": "voucher" }, 'voucherHidden', { "type": "int", "name": "seqno" }, { "name": "partner" }, 'partnerHidden', { "name": "amount" }, { "type": "boolean", "name": "dc" }, { "name": "match" }, { "type": "boolean", "name": "satisfied" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 39,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var voucher_link_disp2171 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var account2172 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Movements/account", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account..." });
    var debit2173 = new Ext.form.NumberField({ "disabled": true, "decimalPrecision": 2, "decimalSeparator": "," });
    var credit2174 = new Ext.form.NumberField({ "disabled": true, "decimalPrecision": 2, "decimalSeparator": "," });
    var id2175 = new Ext.form.NumberField({ "selectOnFocus": true });
    var voucher2176 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Movements/voucher", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Voucher..." });
    var seqno2177 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false });
    var partner2178 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Movements/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var amount2179 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalSeparator": ",", "decimalPrecision": 2, "allowBlank": false, "value": 0 });
    var dc2180 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": null });
    var match2181 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Movements/match", "method": "GET" }) }) });
    var satisfied2182 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
      match2181.setContextValue('partner',record ? record.data['partnerHidden'] : undefined);
      match2181.setContextValue('account',record ? record.data['accountHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      partner2178.on('change',Lino.chooser_handler(match2181,'partner'));
      account2172.on('change',Lino.chooser_handler(match2181,'account'));
      Lino.ledger.Movements.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(31), "colIndex": 0, "sortable": false, "dataIndex": "voucher_link", "header": "Voucher", "editable": false }, { "colIndex": 1, "sortable": true, "header": "Account", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "account", "editor": account2172 }, new Lino.NullNumberColumn({ "width": Lino.chars2width(13), "colIndex": 2, "sortable": false, "dataIndex": "debit", "header": "Debit", "editable": false }), new Lino.NullNumberColumn({ "width": Lino.chars2width(13), "colIndex": 3, "sortable": false, "dataIndex": "credit", "header": "Credit", "editable": false }), new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2175, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Voucher", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "voucher", "editor": voucher2176 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "width": Lino.chars2width(6), "editor": seqno2177 }), { "colIndex": 7, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2178, "dataIndex": "partner" }, new Lino.NullNumberColumn({ "colIndex": 8, "sortable": true, "header": "amount", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "amount", "editor": amount2179 }), { "colIndex": 9, "sortable": false, "xtype": "checkcolumn", "header": "dc", "editable": true, "tooltip": "Debit (checked) or Credit (not checked)", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "dc" }, { "colIndex": 10, "sortable": true, "header": "Match", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "match", "editor": match2181 }, { "colIndex": 11, "sortable": false, "xtype": "checkcolumn", "header": "Satisfied", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "satisfied" } ];
    Lino.ledger.Movements.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Movements.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Movements","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.ledger.Movements.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Movements","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.ledger.Movements.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.ledger.Movements.ParamsPanel({});
  return new Lino.ledger.Movements.GridPanel(p);
});

// js_render_GridPanel_class ledger.Invoices
Lino.ledger.Invoices.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/ledger/Invoices",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/ledger/Invoices','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/Invoices','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/Invoices','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Invoices",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 23,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "type": "int", "name": "id" }, { "type": "int", "name": "number" }, { "name": "partner" }, 'partnerHidden', { "name": "total_incl" }, { "name": "user" }, 'userHidden', { "name": "journal" }, 'journalHidden', { "name": "year" }, 'yearHidden', { "name": "narration" }, { "name": "total_base" }, { "name": "total_vat" }, { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "match" }, { "name": "your_ref" }, { "type": "date", "name": "due_date", "dateFormat": "d.m.Y" }, { "name": "state" }, 'stateHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 1,
  ls_grid_configs : [  ],
  content_type : 38,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Invoices.detail;
    this.ls_insert_handler = Lino.ledger.Invoices.insert;
    var ww = this.containing_window;
    var date2184 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var id2185 = new Ext.form.NumberField({ "selectOnFocus": true });
    var number2186 = new Ext.form.NumberField({ "selectOnFocus": true });
    var partner2187 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/partner", "method": "GET" }) }), "emptyText": "Select a Partner..." });
    var total_incl2188 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var user2189 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var journal2190 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/journal", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Journal..." });
    var year2191 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var narration2192 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var total_base2193 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat2194 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var vat_regime2195 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.vat.VatRegimes });
    var match2196 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/match", "method": "GET" }) }) });
    var your_ref2197 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var due_date2198 = new Lino.DateField({ "selectOnFocus": true });
    var state2199 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.ledger.InvoiceStates });
    this.before_row_edit = function(record) {
      match2196.setContextValue('partner',record ? record.data['partnerHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      partner2187.on('change',Lino.chooser_handler(match2196,'partner'));
      Lino.ledger.Invoices.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "editor": date2184, "width": Lino.chars2width(9), "dataIndex": "date" }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2185, "width": Lino.chars2width(6), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(6), "editor": number2186 }), { "colIndex": 3, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2187, "dataIndex": "partner" }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "header": "Total incl. VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_incl", "editor": total_incl2188 }), { "colIndex": 5, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2189, "dataIndex": "user" }, { "colIndex": 6, "sortable": true, "header": "Journal", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('journalHidden','Lino.ledger.Journals.detail'), "editor": journal2190, "dataIndex": "journal" }, { "colIndex": 7, "sortable": true, "header": "Fiscal Year", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "year", "editor": year2191 }, { "colIndex": 8, "sortable": true, "header": "Narration", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "narration", "editor": narration2192 }, new Lino.NullNumberColumn({ "colIndex": 9, "sortable": true, "header": "Total excl. VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_base", "editor": total_base2193 }), new Lino.NullNumberColumn({ "colIndex": 10, "sortable": true, "header": "VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_vat", "editor": total_vat2194 }), { "colIndex": 11, "sortable": true, "header": "VAT Regime", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(25), "dataIndex": "vat_regime", "editor": vat_regime2195 }, { "colIndex": 12, "sortable": true, "header": "Match", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "match", "editor": match2196 }, { "colIndex": 13, "sortable": true, "header": "Your reference", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "your_ref", "editor": your_ref2197 }, { "colIndex": 14, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Due date", "editor": due_date2198, "width": Lino.chars2width(9), "dataIndex": "due_date" }, { "colIndex": 15, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(14), "dataIndex": "state", "editor": state2199 } ];
    Lino.ledger.Invoices.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Invoices.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Invoices","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.ledger.Invoices.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Invoices","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.ledger.Invoices.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Invoices","GET",pk,"put",null);
};
Lino.ledger.Invoices.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Invoices","GET",pk,"post",null);
};

Lino.ledger.Invoices.insertPanel = Ext.extend(Lino.ledger.Invoices.InsertFormPanel,{
  empty_title: "New Invoices",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/ledger/Invoices",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Invoices.detail;
    this.ls_insert_handler = Lino.ledger.Invoices.insert;
    Lino.ledger.Invoices.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Invoices.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.ledger.Invoices.insertPanel(p);
});
Lino.ledger.Invoices.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Invoices","GET",pk,"poststay",null);
};

Lino.ledger.Invoices.detailPanel = Ext.extend(Lino.ledger.Invoices.DetailFormPanel,{
  empty_title: "Detail Invoices",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/ledger/Invoices",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Invoices.detail;
    this.ls_insert_handler = Lino.ledger.Invoices.insert;
    Lino.ledger.Invoices.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Invoices.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.Invoices.detailPanel(p);
});
Lino.ledger.Invoices.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.ledger.Invoices.ParamsPanel({});
  return new Lino.ledger.Invoices.GridPanel(p);
});
Lino.ledger.Invoices.deregister_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Invoices","GET",pk,"deregister_action",null);
};
Lino.ledger.Invoices.register_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Invoices","GET",pk,"register_action",null);
};

// js_render_GridPanel_class sales.PaymentTerms
Lino.sales.PaymentTerms.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/sales/PaymentTerms",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/sales/PaymentTerms','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/PaymentTerms','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/PaymentTerms','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Payment Terms",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 9,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "type": "int", "name": "days" }, { "type": "int", "name": "months" }, { "type": "boolean", "name": "end_of_month" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 44,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id2201 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2202 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2203 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2204 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en2205 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var days2206 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var months2207 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var end_of_month2208 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2201, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2202 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2203 }, { "colIndex": 3, "sortable": true, "header": "Designation (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et2204 }, { "colIndex": 4, "sortable": true, "header": "Designation (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en2205 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "days", "dataIndex": "days", "width": Lino.chars2width(6), "editor": days2206 }), new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "months", "dataIndex": "months", "width": Lino.chars2width(6), "editor": months2207 }), { "colIndex": 7, "sortable": false, "xtype": "checkcolumn", "header": "end of month", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "end_of_month" } ];
    Lino.sales.PaymentTerms.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.PaymentTerms.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/PaymentTerms","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.sales.PaymentTerms.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/PaymentTerms","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.sales.PaymentTerms.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/PaymentTerms","GET",pk,"put",null);
};
Lino.sales.PaymentTerms.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/PaymentTerms","GET",pk,"post",null);
};
Lino.sales.PaymentTerms.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.PaymentTerms.GridPanel(p);
});

// js_render_GridPanel_class sales.InvoicingModes
Lino.sales.InvoicingModes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/sales/InvoicingModes",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/sales/InvoicingModes','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/InvoicingModes','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/InvoicingModes','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Invoicing Modes",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 11,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "build_method" }, 'build_methodHidden', { "name": "template" }, { "name": "price" }, { "type": "int", "name": "advance_days" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 40,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id2210 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2211 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2212 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2213 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en2214 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var build_method2215 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template2216 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoicingModes/template", "method": "GET" }) }) });
    var price2217 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var advance_days2218 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    this.before_row_edit = function(record) {
      template2216.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      build_method2215.on('change',Lino.chooser_handler(template2216,'build_method'));
      Lino.sales.InvoicingModes.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2210, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2211 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2212 }, { "colIndex": 3, "sortable": true, "header": "Designation (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et2213 }, { "colIndex": 4, "sortable": true, "header": "Designation (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en2214 }, { "colIndex": 5, "sortable": true, "header": "Build method", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "build_method", "editor": build_method2215 }, { "colIndex": 6, "sortable": true, "header": "Template", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "template", "editor": template2216 }, new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "header": "price", "editable": true, "tooltip": "Additional fee charged when using this invoicing mode.", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "price", "editor": price2217 }), new Lino.NullNumberColumn({ "colIndex": 8, "sortable": true, "format": "0", "editable": true, "tooltip": "\nHow many days in advance invoices should be posted so that the customer\nhas a chance to pay them in time.", "filter": { "type": "numeric" }, "header": "advance days", "dataIndex": "advance_days", "width": Lino.chars2width(6), "editor": advance_days2218 }) ];
    Lino.sales.InvoicingModes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.InvoicingModes.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoicingModes","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.sales.InvoicingModes.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoicingModes","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.sales.InvoicingModes.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoicingModes","GET",pk,"put",null);
};
Lino.sales.InvoicingModes.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoicingModes","GET",pk,"post",null);
};
Lino.sales.InvoicingModes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.InvoicingModes.GridPanel(p);
});

// js_render_GridPanel_class sales.ShippingModes
Lino.sales.ShippingModes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/sales/ShippingModes",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/sales/ShippingModes','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/ShippingModes','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/ShippingModes','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Shipping Modes",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "price" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 45,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id2220 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2221 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2222 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2223 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en2224 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var price2225 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2220, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2221 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2222 }, { "colIndex": 3, "sortable": true, "header": "Designation (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et2223 }, { "colIndex": 4, "sortable": true, "header": "Designation (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en2224 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "header": "price", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "price", "editor": price2225 }) ];
    Lino.sales.ShippingModes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.ShippingModes.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/ShippingModes","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.sales.ShippingModes.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/ShippingModes","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.sales.ShippingModes.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/ShippingModes","GET",pk,"put",null);
};
Lino.sales.ShippingModes.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/ShippingModes","GET",pk,"post",null);
};
Lino.sales.ShippingModes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.ShippingModes.GridPanel(p);
});

// js_render_GridPanel_class sales.Invoices
Lino.sales.Invoices.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/sales/Invoices",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/sales/Invoices','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/Invoices','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/Invoices','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.list_action_handler('/sales/Invoices','do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Clear cache", "auto_save": true } ],
  cell_edit : true,
  title : "Invoices",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 35,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "partner" }, 'partnerHidden', { "name": "total_incl" }, { "name": "user" }, 'userHidden', { "name": "journal" }, 'journalHidden', { "name": "year" }, 'yearHidden', { "type": "int", "name": "number" }, { "name": "narration" }, { "name": "build_time" }, { "name": "total_base" }, { "name": "total_vat" }, { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "match" }, { "name": "language" }, 'languageHidden', { "name": "your_ref" }, { "name": "imode" }, 'imodeHidden', { "name": "shipping_mode" }, 'shipping_modeHidden', { "name": "payment_term" }, 'payment_termHidden', { "name": "subject" }, { "name": "intro" }, { "name": "discount" }, { "type": "date", "name": "due_date", "dateFormat": "d.m.Y" }, { "name": "state" }, 'stateHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 38,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.Invoices.detail;
    this.ls_insert_handler = Lino.sales.Invoices.insert;
    var ww = this.containing_window;
    var id2227 = new Ext.form.NumberField({ "selectOnFocus": true });
    var date2228 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var partner2229 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/partner", "method": "GET" }) }), "emptyText": "Select a Partner..." });
    var total_incl2230 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var user2231 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var journal2232 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/journal", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Journal..." });
    var year2233 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var number2234 = new Ext.form.NumberField({ "selectOnFocus": true });
    var narration2235 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var build_time2236 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var total_base2237 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat2238 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var vat_regime2239 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.vat.VatRegimes });
    var match2240 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/match", "method": "GET" }) }) });
    var language2241 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ], [ "en", "English" ] ] });
    var your_ref2242 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var imode2243 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Invoicing Mode..." });
    var shipping_mode2244 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/shipping_mode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Shipping Mode..." });
    var payment_term2245 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Payment Term..." });
    var subject2246 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var intro2247 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var discount2248 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var due_date2249 = new Lino.DateField({ "selectOnFocus": true });
    var state2250 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.sales.InvoiceStates });
    this.before_row_edit = function(record) {
      match2240.setContextValue('partner',record ? record.data['partnerHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      partner2229.on('change',Lino.chooser_handler(match2240,'partner'));
      Lino.sales.Invoices.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2227, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "editor": date2228, "width": Lino.chars2width(9), "dataIndex": "date" }, { "colIndex": 2, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2229, "dataIndex": "partner" }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "header": "Total incl. VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_incl", "editor": total_incl2230 }), { "colIndex": 4, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2231, "dataIndex": "user" }, { "colIndex": 5, "sortable": true, "header": "Journal", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('journalHidden','Lino.ledger.Journals.detail'), "editor": journal2232, "dataIndex": "journal" }, { "colIndex": 6, "sortable": true, "header": "Fiscal Year", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "year", "editor": year2233 }, new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(6), "editor": number2234 }), { "colIndex": 8, "sortable": true, "header": "Narration", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "narration", "editor": narration2235 }, { "width": Lino.chars2width(17), "colIndex": 9, "sortable": true, "dataIndex": "build_time", "header": "build time", "editable": false }, new Lino.NullNumberColumn({ "colIndex": 10, "sortable": true, "header": "Total excl. VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_base", "editor": total_base2237 }), new Lino.NullNumberColumn({ "colIndex": 11, "sortable": true, "header": "VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_vat", "editor": total_vat2238 }), { "colIndex": 12, "sortable": true, "header": "VAT Regime", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(25), "dataIndex": "vat_regime", "editor": vat_regime2239 }, { "colIndex": 13, "sortable": true, "header": "Match", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "match", "editor": match2240 }, { "colIndex": 14, "sortable": true, "header": "Language", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language2241 }, { "colIndex": 15, "sortable": true, "header": "Your reference", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "your_ref", "editor": your_ref2242 }, { "colIndex": 16, "sortable": true, "header": "Invoicing Mode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "imode", "editor": imode2243 }, { "colIndex": 17, "sortable": true, "header": "Shipping Mode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "shipping_mode", "editor": shipping_mode2244 }, { "colIndex": 18, "sortable": true, "header": "Payment Term", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "payment_term", "editor": payment_term2245 }, { "colIndex": 19, "sortable": true, "header": "Subject line", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "subject", "editor": subject2246 }, { "colIndex": 20, "sortable": false, "header": "Introductive Text", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": intro2247, "dataIndex": "intro" }, new Lino.NullNumberColumn({ "colIndex": 21, "sortable": true, "header": "Discount", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(8), "dataIndex": "discount", "editor": discount2248 }), { "colIndex": 22, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date of payment", "editor": due_date2249, "width": Lino.chars2width(9), "dataIndex": "due_date" }, { "colIndex": 23, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(18), "dataIndex": "state", "editor": state2250 } ];
    Lino.sales.Invoices.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.Invoices.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/Invoices","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.sales.Invoices.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/Invoices","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.sales.Invoices.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/Invoices","GET",pk,"put",null);
};
Lino.sales.Invoices.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/Invoices","GET",pk,"post",null);
};

Lino.sales.Invoices.insertPanel = Ext.extend(Lino.sales.Invoices.InsertFormPanel,{
  empty_title: "New Invoices",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true } ],
  ls_url: "/sales/Invoices",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.Invoices.detail;
    this.ls_insert_handler = Lino.sales.Invoices.insert;
    Lino.sales.Invoices.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.Invoices.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.sales.Invoices.insertPanel(p);
});
Lino.sales.Invoices.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/Invoices","GET",pk,"poststay",null);
};
Lino.sales.Invoices.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/Invoices","GET",pk,"duplicate",null);
};

Lino.sales.Invoices.detailPanel = Ext.extend(Lino.sales.Invoices.DetailFormPanel,{
  empty_title: "Detail Invoices",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.list_action_handler('/sales/Invoices','do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Clear cache", "auto_save": true } ],
  ls_url: "/sales/Invoices",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.Invoices.detail;
    this.ls_insert_handler = Lino.sales.Invoices.insert;
    Lino.sales.Invoices.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.Invoices.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.Invoices.detailPanel(p);
});
Lino.sales.Invoices.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/Invoices","POST",pk,"do_print",null);
};
Lino.sales.Invoices.do_clear_cache = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/Invoices","GET",pk,"do_clear_cache",null);
};
Lino.sales.Invoices.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.sales.Invoices.ParamsPanel({});
  return new Lino.sales.Invoices.GridPanel(p);
});
Lino.sales.Invoices.deregister_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/Invoices","GET",pk,"deregister_action",null);
};
Lino.sales.Invoices.register_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/Invoices","GET",pk,"register_action",null);
};

// js_render_GridPanel_class sales.DocumentsToSign
Lino.sales.DocumentsToSign.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/sales/DocumentsToSign",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/sales/DocumentsToSign','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/DocumentsToSign','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/DocumentsToSign','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.list_action_handler('/sales/DocumentsToSign','do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Clear cache", "auto_save": true } ],
  cell_edit : true,
  title : "Invoices",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 12,
  ls_store_fields : [ { "type": "int", "name": "number" }, { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "partner" }, 'partnerHidden', { "name": "imode" }, 'imodeHidden', { "name": "subject" }, { "name": "total_incl" }, { "name": "total_base" }, { "name": "total_vat" }, { "name": "voucher_ptr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 10,
  ls_grid_configs : [  ],
  content_type : 43,
  ls_id_property : "voucher_ptr",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.DocumentsToSign.detail;
    this.ls_insert_handler = Lino.sales.DocumentsToSign.insert;
    var ww = this.containing_window;
    var number2252 = new Ext.form.NumberField({ "selectOnFocus": true });
    var date2253 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var partner2254 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/DocumentsToSign/partner", "method": "GET" }) }), "emptyText": "Select a Partner..." });
    var imode2255 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/DocumentsToSign/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Invoicing Mode..." });
    var subject2256 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var total_incl2257 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_base2258 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat2259 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(5), "editor": number2252 }), { "colIndex": 1, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "editor": date2253, "width": Lino.chars2width(9), "dataIndex": "date" }, { "colIndex": 2, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2254, "dataIndex": "partner" }, { "colIndex": 3, "sortable": true, "header": "Invoicing Mode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "imode", "editor": imode2255 }, { "colIndex": 4, "sortable": true, "header": "Subject line", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "subject", "editor": subject2256 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "header": "Total incl. VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_incl", "editor": total_incl2257 }), new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "header": "Total excl. VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_base", "editor": total_base2258 }), new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "header": "VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_vat", "editor": total_vat2259 }) ];
    Lino.sales.DocumentsToSign.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.DocumentsToSign.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/DocumentsToSign","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.sales.DocumentsToSign.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/DocumentsToSign","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.sales.DocumentsToSign.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/DocumentsToSign","GET",pk,"put",null);
};
Lino.sales.DocumentsToSign.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/DocumentsToSign","GET",pk,"post",null);
};

Lino.sales.DocumentsToSign.insertPanel = Ext.extend(Lino.sales.Invoices.InsertFormPanel,{
  empty_title: "New Invoices",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true } ],
  ls_url: "/sales/DocumentsToSign",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.DocumentsToSign.detail;
    this.ls_insert_handler = Lino.sales.DocumentsToSign.insert;
    Lino.sales.DocumentsToSign.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.DocumentsToSign.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.sales.DocumentsToSign.insertPanel(p);
});
Lino.sales.DocumentsToSign.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/DocumentsToSign","GET",pk,"poststay",null);
};
Lino.sales.DocumentsToSign.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/DocumentsToSign","GET",pk,"duplicate",null);
};

Lino.sales.DocumentsToSign.detailPanel = Ext.extend(Lino.sales.Invoices.DetailFormPanel,{
  empty_title: "Detail Invoices",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.list_action_handler('/sales/DocumentsToSign','do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Clear cache", "auto_save": true } ],
  ls_url: "/sales/DocumentsToSign",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.DocumentsToSign.detail;
    this.ls_insert_handler = Lino.sales.DocumentsToSign.insert;
    Lino.sales.DocumentsToSign.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.DocumentsToSign.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.DocumentsToSign.detailPanel(p);
});
Lino.sales.DocumentsToSign.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/DocumentsToSign","POST",pk,"do_print",null);
};
Lino.sales.DocumentsToSign.do_clear_cache = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/DocumentsToSign","GET",pk,"do_clear_cache",null);
};
Lino.sales.DocumentsToSign.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.sales.Invoices.ParamsPanel({});
  return new Lino.sales.DocumentsToSign.GridPanel(p);
});
Lino.sales.DocumentsToSign.deregister_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/DocumentsToSign","GET",pk,"deregister_action",null);
};
Lino.sales.DocumentsToSign.register_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/DocumentsToSign","GET",pk,"register_action",null);
};

// js_render_GridPanel_class blogs.EntryTypes
Lino.blogs.EntryTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/blogs/EntryTypes",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/blogs/EntryTypes','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/blogs/EntryTypes','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/blogs/EntryTypes','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Blog Entry Types",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 11,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "build_method" }, 'build_methodHidden', { "name": "template" }, { "type": "int", "name": "id" }, { "type": "boolean", "name": "important" }, { "name": "remark" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 47,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.blogs.EntryTypes.detail;
    this.ls_insert_handler = Lino.blogs.EntryTypes.insert;
    var ww = this.containing_window;
    var name2261 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2262 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2263 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en2264 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var build_method2265 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template2266 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/EntryTypes/template", "method": "GET" }) }) });
    var id2267 = new Ext.form.NumberField({ "selectOnFocus": true });
    var important2268 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var remark2269 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
      template2266.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      build_method2265.on('change',Lino.chooser_handler(template2266,'build_method'));
      Lino.blogs.EntryTypes.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2261 }, { "colIndex": 1, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2262 }, { "colIndex": 2, "sortable": true, "header": "Designation (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et2263 }, { "colIndex": 3, "sortable": true, "header": "Designation (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en2264 }, { "colIndex": 4, "sortable": true, "header": "Build method", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "build_method", "editor": build_method2265 }, { "colIndex": 5, "sortable": true, "header": "Template", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "template", "editor": template2266 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2267, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 7, "sortable": false, "xtype": "checkcolumn", "header": "important", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "important" }, { "colIndex": 8, "sortable": false, "header": "Remark", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": remark2269, "dataIndex": "remark" } ];
    Lino.blogs.EntryTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.blogs.EntryTypes.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/blogs/EntryTypes","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.blogs.EntryTypes.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/blogs/EntryTypes","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.blogs.EntryTypes.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/blogs/EntryTypes","GET",pk,"put",null);
};
Lino.blogs.EntryTypes.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/blogs/EntryTypes","GET",pk,"post",null);
};

Lino.blogs.EntryTypes.insertPanel = Ext.extend(Lino.blogs.EntryTypes.DetailFormPanel,{
  empty_title: "New Blog Entry Types",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/blogs/EntryTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.blogs.EntryTypes.detail;
    this.ls_insert_handler = Lino.blogs.EntryTypes.insert;
    Lino.blogs.EntryTypes.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.blogs.EntryTypes.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.blogs.EntryTypes.insertPanel(p);
});
Lino.blogs.EntryTypes.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/blogs/EntryTypes","GET",pk,"poststay",null);
};

Lino.blogs.EntryTypes.detailPanel = Ext.extend(Lino.blogs.EntryTypes.DetailFormPanel,{
  empty_title: "Detail Blog Entry Types",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/blogs/EntryTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.blogs.EntryTypes.detail;
    this.ls_insert_handler = Lino.blogs.EntryTypes.insert;
    Lino.blogs.EntryTypes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.blogs.EntryTypes.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.blogs.EntryTypes.detailPanel(p);
});
Lino.blogs.EntryTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.blogs.EntryTypes.GridPanel(p);
});

// js_render_GridPanel_class blogs.Entries
Lino.blogs.Entries.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/blogs/Entries",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/blogs/Entries','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/blogs/Entries','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/blogs/Entries','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.list_action_handler('/blogs/Entries','do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Clear cache", "auto_save": true } ],
  cell_edit : true,
  title : "Blog Entries",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 20,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "modified" }, { "name": "user" }, 'userHidden', { "name": "type" }, 'typeHidden', { "name": "title" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "created" }, { "name": "build_time" }, { "name": "language" }, 'languageHidden', { "name": "ticket" }, 'ticketHidden', { "name": "owner" }, { "name": "body" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 46,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.blogs.Entries.detail;
    this.ls_insert_handler = Lino.blogs.Entries.insert;
    var ww = this.containing_window;
    var id2271 = new Ext.form.NumberField({ "selectOnFocus": true });
    var modified2272 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var user2273 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/Entries/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var type2274 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/Entries/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Blog Entry Type..." });
    var title2275 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var owner_type2276 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/Entries/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id2277 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/Entries/owner_id", "method": "GET" }) }) });
    var created2278 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_time2279 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var language2280 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ], [ "en", "English" ] ] });
    var ticket2281 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/Entries/ticket", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Ticket..." });
    var owner_disp2282 = new Ext.form.DisplayField({ "disabled": true });
    var body2283 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Body" });
    this.before_row_edit = function(record) {
      owner_id2277.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      body2283.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2276.on('change',Lino.chooser_handler(owner_id2277,'owner_type'));
      Lino.blogs.Entries.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2271, "width": Lino.chars2width(6), "dataIndex": "id" }), { "width": Lino.chars2width(17), "colIndex": 1, "sortable": true, "dataIndex": "modified", "header": "Modified", "editable": false }, { "colIndex": 2, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2273, "dataIndex": "user" }, { "colIndex": 3, "sortable": true, "header": "Blog Entry Type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('typeHidden','Lino.blogs.EntryTypes.detail'), "editor": type2274, "dataIndex": "type" }, { "colIndex": 4, "sortable": true, "header": "Heading", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "title", "editor": title2275 }, { "colIndex": 5, "sortable": true, "header": "Controlled by (type)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.system.ContentTypes.detail'), "editor": owner_type2276, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Controlled by (object)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "owner_id", "editor": owner_id2277 }, { "width": Lino.chars2width(17), "colIndex": 7, "sortable": true, "dataIndex": "created", "header": "Created", "editable": false }, { "width": Lino.chars2width(17), "colIndex": 8, "sortable": true, "dataIndex": "build_time", "header": "build time", "editable": false }, { "colIndex": 9, "sortable": true, "header": "Language", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language2280 }, { "colIndex": 10, "sortable": true, "header": "Ticket", "editable": true, "tooltip": "The Ticket attributed to this Entry.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('ticketHidden','Lino.tickets.Tickets.detail'), "editor": ticket2281, "dataIndex": "ticket" }, { "width": Lino.chars2width(11), "colIndex": 11, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "editable": false }, { "colIndex": 12, "sortable": false, "header": "body", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": body2283, "dataIndex": "body" } ];
    Lino.blogs.Entries.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.blogs.Entries.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/blogs/Entries","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.blogs.Entries.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/blogs/Entries","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.blogs.Entries.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/blogs/Entries","GET",pk,"put",null);
};
Lino.blogs.Entries.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/blogs/Entries","GET",pk,"post",null);
};

Lino.blogs.Entries.insertPanel = Ext.extend(Lino.blogs.Entries.DetailFormPanel,{
  empty_title: "New Blog Entries",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true } ],
  ls_url: "/blogs/Entries",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.blogs.Entries.detail;
    this.ls_insert_handler = Lino.blogs.Entries.insert;
    Lino.blogs.Entries.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.blogs.Entries.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.blogs.Entries.insertPanel(p);
});
Lino.blogs.Entries.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/blogs/Entries","GET",pk,"poststay",null);
};
Lino.blogs.Entries.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/blogs/Entries","GET",pk,"duplicate",null);
};

Lino.blogs.Entries.detailPanel = Ext.extend(Lino.blogs.Entries.DetailFormPanel,{
  empty_title: "Detail Blog Entries",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.list_action_handler('/blogs/Entries','do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Clear cache", "auto_save": true } ],
  ls_url: "/blogs/Entries",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.blogs.Entries.detail;
    this.ls_insert_handler = Lino.blogs.Entries.insert;
    Lino.blogs.Entries.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.blogs.Entries.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.blogs.Entries.detailPanel(p);
});
Lino.blogs.Entries.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/blogs/Entries","POST",pk,"do_print",null);
};
Lino.blogs.Entries.do_clear_cache = function(rp,pk) { 
  Lino.run_row_action(rp,"/blogs/Entries","GET",pk,"do_clear_cache",null);
};
Lino.blogs.Entries.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.blogs.Entries.GridPanel(p);
});

// js_render_GridPanel_class tickets.ProjectTypes
Lino.tickets.ProjectTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/tickets/ProjectTypes",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/tickets/ProjectTypes','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/tickets/ProjectTypes','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/tickets/ProjectTypes','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Project Types",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 9,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "name": "build_method" }, 'build_methodHidden', { "name": "template" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 48,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var name2285 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2286 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2287 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en2288 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var build_method2289 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template2290 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/ProjectTypes/template", "method": "GET" }) }) });
    var id2291 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      template2290.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      build_method2289.on('change',Lino.chooser_handler(template2290,'build_method'));
      Lino.tickets.ProjectTypes.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2285 }, { "colIndex": 1, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2286 }, { "colIndex": 2, "sortable": true, "header": "Designation (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et2287 }, { "colIndex": 3, "sortable": true, "header": "Designation (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en2288 }, { "colIndex": 4, "sortable": true, "header": "Build method", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "build_method", "editor": build_method2289 }, { "colIndex": 5, "sortable": true, "header": "Template", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "template", "editor": template2290 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2291, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.tickets.ProjectTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.ProjectTypes.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/ProjectTypes","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.tickets.ProjectTypes.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/ProjectTypes","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.tickets.ProjectTypes.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/ProjectTypes","GET",pk,"put",null);
};
Lino.tickets.ProjectTypes.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/ProjectTypes","GET",pk,"post",null);
};
Lino.tickets.ProjectTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.tickets.ProjectTypes.GridPanel(p);
});

// js_render_GridPanel_class tickets.SessionTypes
Lino.tickets.SessionTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/tickets/SessionTypes",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/tickets/SessionTypes','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/tickets/SessionTypes','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/tickets/SessionTypes','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Session Types",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "name": "name" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "name_en" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 49,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var name2293 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_fr2294 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2295 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_en2296 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id2297 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2293 }, { "colIndex": 1, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2294 }, { "colIndex": 2, "sortable": true, "header": "Designation (et)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_et", "editor": name_et2295 }, { "colIndex": 3, "sortable": true, "header": "Designation (en)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_en", "editor": name_en2296 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2297, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.tickets.SessionTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.SessionTypes.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/SessionTypes","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.tickets.SessionTypes.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/SessionTypes","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.tickets.SessionTypes.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/SessionTypes","GET",pk,"put",null);
};
Lino.tickets.SessionTypes.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/SessionTypes","GET",pk,"post",null);
};
Lino.tickets.SessionTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.tickets.SessionTypes.GridPanel(p);
});

// js_render_GridPanel_class tickets.Projects
Lino.tickets.Projects.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/tickets/Projects",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/tickets/Projects','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/tickets/Projects','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/tickets/Projects','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Edit Print Template", "must_save": true, "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Edit Print Template", "overflowText": "Edit Print Template", "auto_save": true } ],
  cell_edit : true,
  title : "Projects",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 14,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "ref" }, { "name": "name" }, { "name": "parent" }, 'parentHidden', { "name": "type" }, 'typeHidden', { "name": "partner" }, 'partnerHidden', { "name": "srcref_url_template" }, { "name": "changeset_url_template" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 50,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.Projects.detail;
    this.ls_insert_handler = Lino.tickets.Projects.insert;
    var ww = this.containing_window;
    var id2299 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user2300 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Projects/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var ref2301 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var name2302 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var parent2303 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Projects/parent", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var type2304 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Projects/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project Type..." });
    var partner2305 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Projects/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var srcref_url_template2306 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var changeset_url_template2307 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2299, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2300, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "Reference", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ref", "editor": ref2301 }, { "colIndex": 3, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2302 }, { "colIndex": 4, "sortable": true, "header": "Parent", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('parentHidden','Lino.tickets.Projects.detail'), "editor": parent2303, "dataIndex": "parent" }, { "colIndex": 5, "sortable": true, "header": "Project Type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type2304 }, { "colIndex": 6, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2305, "dataIndex": "partner" }, { "colIndex": 7, "sortable": true, "header": "srcref url template", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "srcref_url_template", "editor": srcref_url_template2306 }, { "colIndex": 8, "sortable": true, "header": "changeset url template", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "changeset_url_template", "editor": changeset_url_template2307 } ];
    Lino.tickets.Projects.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.Projects.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/Projects","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.tickets.Projects.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/Projects","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.tickets.Projects.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/Projects","GET",pk,"put",null);
};
Lino.tickets.Projects.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/Projects","GET",pk,"post",null);
};

Lino.tickets.Projects.insertPanel = Ext.extend(Lino.tickets.Projects.DetailFormPanel,{
  empty_title: "New Projects",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/tickets/Projects",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.Projects.detail;
    this.ls_insert_handler = Lino.tickets.Projects.insert;
    Lino.tickets.Projects.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.Projects.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.tickets.Projects.insertPanel(p);
});
Lino.tickets.Projects.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/Projects","GET",pk,"poststay",null);
};

Lino.tickets.Projects.detailPanel = Ext.extend(Lino.tickets.Projects.DetailFormPanel,{
  empty_title: "Detail Projects",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Edit Print Template", "must_save": true, "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Edit Print Template", "overflowText": "Edit Print Template", "auto_save": true } ],
  ls_url: "/tickets/Projects",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.Projects.detail;
    this.ls_insert_handler = Lino.tickets.Projects.insert;
    Lino.tickets.Projects.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.Projects.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.tickets.Projects.detailPanel(p);
});
Lino.tickets.Projects.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/Projects","GET",pk,"do_print",null);
};
Lino.tickets.Projects.edit_template = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/Projects","GET",pk,"edit_template",null);
};
Lino.tickets.Projects.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.tickets.Projects.GridPanel(p);
});

// js_render_GridPanel_class tickets.Milestones
Lino.tickets.Milestones.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/tickets/Milestones",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/tickets/Milestones','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/tickets/Milestones','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/tickets/Milestones','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Milestones",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "project" }, 'projectHidden', { "name": "ref" }, { "type": "date", "name": "expected", "dateFormat": "d.m.Y" }, { "type": "date", "name": "reached", "dateFormat": "d.m.Y" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 52,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.Milestones.detail;
    this.ls_insert_handler = Lino.tickets.Milestones.insert;
    var ww = this.containing_window;
    var id2309 = new Ext.form.NumberField({ "selectOnFocus": true });
    var project2310 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Milestones/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var ref2311 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var expected2312 = new Lino.DateField({ "selectOnFocus": true });
    var reached2313 = new Lino.DateField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2309, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Project", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail'), "editor": project2310, "dataIndex": "project" }, { "colIndex": 2, "sortable": true, "header": "Reference", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ref", "editor": ref2311 }, { "colIndex": 3, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Expected for", "editor": expected2312, "width": Lino.chars2width(9), "dataIndex": "expected" }, { "colIndex": 4, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Reached", "editor": reached2313, "width": Lino.chars2width(9), "dataIndex": "reached" } ];
    Lino.tickets.Milestones.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.Milestones.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/Milestones","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.tickets.Milestones.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/Milestones","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.tickets.Milestones.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/Milestones","GET",pk,"put",null);
};
Lino.tickets.Milestones.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/Milestones","GET",pk,"post",null);
};

Lino.tickets.Milestones.insertPanel = Ext.extend(Lino.tickets.Milestones.InsertFormPanel,{
  empty_title: "New Milestones",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/tickets/Milestones",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.Milestones.detail;
    this.ls_insert_handler = Lino.tickets.Milestones.insert;
    Lino.tickets.Milestones.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.Milestones.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.tickets.Milestones.insertPanel(p);
});
Lino.tickets.Milestones.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/Milestones","GET",pk,"poststay",null);
};

Lino.tickets.Milestones.detailPanel = Ext.extend(Lino.tickets.Milestones.DetailFormPanel,{
  empty_title: "Detail Milestones",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/tickets/Milestones",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.Milestones.detail;
    this.ls_insert_handler = Lino.tickets.Milestones.insert;
    Lino.tickets.Milestones.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.Milestones.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.tickets.Milestones.detailPanel(p);
});
Lino.tickets.Milestones.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.tickets.Milestones.GridPanel(p);
});

// js_render_GridPanel_class tickets.Tickets
Lino.tickets.Tickets.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/tickets/Tickets",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/tickets/Tickets','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/tickets/Tickets','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/tickets/Tickets','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Tickets",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 18,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "created" }, { "name": "modified" }, { "name": "project" }, 'projectHidden', { "name": "reported" }, 'reportedHidden', { "name": "fixed" }, 'fixedHidden', { "name": "partner" }, 'partnerHidden', { "name": "summary" }, { "name": "state" }, 'stateHidden', { "name": "closed" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 53,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.Tickets.detail;
    this.ls_insert_handler = Lino.tickets.Tickets.insert;
    var ww = this.containing_window;
    var id2315 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user2316 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var created2317 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2318 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var project2319 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var reported2320 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/reported", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Milestone..." });
    var fixed2321 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/fixed", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Milestone..." });
    var partner2322 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var summary2323 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var state2324 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.tickets.TicketStates) });
    var closed2325 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    this.before_row_edit = function(record) {
      reported2320.setContextValue('project',record ? record.data['projectHidden'] : undefined);
      fixed2321.setContextValue('project',record ? record.data['projectHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      project2319.on('change',Lino.chooser_handler(reported2320,'project'));
      project2319.on('change',Lino.chooser_handler(fixed2321,'project'));
      Lino.tickets.Tickets.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2315, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2316, "dataIndex": "user" }, { "width": Lino.chars2width(17), "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "Created", "editable": false }, { "width": Lino.chars2width(17), "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "Modified", "editable": false }, { "colIndex": 4, "sortable": true, "header": "Project", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail'), "editor": project2319, "dataIndex": "project" }, { "colIndex": 5, "sortable": true, "header": "Reported for", "editable": true, "tooltip": "Milestone for which this ticket has been reported.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('reportedHidden','Lino.tickets.Milestones.detail'), "editor": reported2320, "dataIndex": "reported" }, { "colIndex": 6, "sortable": true, "header": "Fixed for", "editable": true, "tooltip": "The milestone for which this ticket has been fixed.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('fixedHidden','Lino.tickets.Milestones.detail'), "editor": fixed2321, "dataIndex": "fixed" }, { "colIndex": 7, "sortable": true, "header": "Partner", "editable": true, "tooltip": "The partner who reported this ticket.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2322, "dataIndex": "partner" }, { "colIndex": 8, "sortable": true, "header": "Summary", "editable": true, "tooltip": "Short summary of the problem.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary2323 }, { "colIndex": 9, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "state", "editor": state2324 }, { "width": Lino.chars2width(17), "colIndex": 10, "sortable": true, "dataIndex": "closed", "header": "Closed since", "editable": false } ];
    Lino.tickets.Tickets.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.Tickets.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/Tickets","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.tickets.Tickets.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/Tickets","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.tickets.Tickets.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/Tickets","GET",pk,"put",null);
};
Lino.tickets.Tickets.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/Tickets","GET",pk,"post",null);
};

Lino.tickets.Tickets.insertPanel = Ext.extend(Lino.tickets.Tickets.InsertFormPanel,{
  empty_title: "New Tickets",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/tickets/Tickets",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.Tickets.detail;
    this.ls_insert_handler = Lino.tickets.Tickets.insert;
    Lino.tickets.Tickets.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.Tickets.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.tickets.Tickets.insertPanel(p);
});
Lino.tickets.Tickets.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/Tickets","GET",pk,"poststay",null);
};

Lino.tickets.Tickets.detailPanel = Ext.extend(Lino.tickets.Tickets.DetailFormPanel,{
  empty_title: "Detail Tickets",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/tickets/Tickets",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.Tickets.detail;
    this.ls_insert_handler = Lino.tickets.Tickets.insert;
    Lino.tickets.Tickets.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.Tickets.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.tickets.Tickets.detailPanel(p);
});
Lino.tickets.Tickets.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.tickets.Tickets.GridPanel(p);
});

// js_render_GridPanel_class tickets.UnassignedTickets
Lino.tickets.UnassignedTickets.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/tickets/UnassignedTickets",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/tickets/UnassignedTickets','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/tickets/UnassignedTickets','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/tickets/UnassignedTickets','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Tickets",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 18,
  ls_store_fields : [ { "name": "summary" }, { "name": "project" }, 'projectHidden', { "name": "partner" }, 'partnerHidden', { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "created" }, { "name": "modified" }, { "name": "reported" }, 'reportedHidden', { "name": "fixed" }, 'fixedHidden', { "name": "state" }, 'stateHidden', { "name": "closed" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 53,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.UnassignedTickets.detail;
    this.ls_insert_handler = Lino.tickets.UnassignedTickets.insert;
    var ww = this.containing_window;
    var summary2327 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var project2328 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/UnassignedTickets/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var partner2329 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/UnassignedTickets/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var id2330 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user2331 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/UnassignedTickets/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var created2332 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2333 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var reported2334 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/UnassignedTickets/reported", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Milestone..." });
    var fixed2335 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/UnassignedTickets/fixed", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Milestone..." });
    var state2336 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.tickets.TicketStates) });
    var closed2337 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    this.before_row_edit = function(record) {
      reported2334.setContextValue('project',record ? record.data['projectHidden'] : undefined);
      fixed2335.setContextValue('project',record ? record.data['projectHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      project2328.on('change',Lino.chooser_handler(reported2334,'project'));
      project2328.on('change',Lino.chooser_handler(fixed2335,'project'));
      Lino.tickets.UnassignedTickets.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Summary", "editable": true, "tooltip": "Short summary of the problem.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary2327 }, { "colIndex": 1, "sortable": true, "header": "Project", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail'), "editor": project2328, "dataIndex": "project" }, { "colIndex": 2, "sortable": true, "header": "Partner", "editable": true, "tooltip": "The partner who reported this ticket.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2329, "dataIndex": "partner" }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2330, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2331, "dataIndex": "user" }, { "width": Lino.chars2width(17), "colIndex": 5, "sortable": true, "dataIndex": "created", "header": "Created", "editable": false }, { "width": Lino.chars2width(17), "colIndex": 6, "sortable": true, "dataIndex": "modified", "header": "Modified", "editable": false }, { "colIndex": 7, "sortable": true, "header": "Reported for", "editable": true, "tooltip": "Milestone for which this ticket has been reported.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('reportedHidden','Lino.tickets.Milestones.detail'), "editor": reported2334, "dataIndex": "reported" }, { "colIndex": 8, "sortable": true, "header": "Fixed for", "editable": true, "tooltip": "The milestone for which this ticket has been fixed.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('fixedHidden','Lino.tickets.Milestones.detail'), "editor": fixed2335, "dataIndex": "fixed" }, { "colIndex": 9, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "state", "editor": state2336 }, { "width": Lino.chars2width(17), "colIndex": 10, "sortable": true, "dataIndex": "closed", "header": "Closed since", "editable": false } ];
    Lino.tickets.UnassignedTickets.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.UnassignedTickets.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/UnassignedTickets","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.tickets.UnassignedTickets.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/UnassignedTickets","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.tickets.UnassignedTickets.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/UnassignedTickets","GET",pk,"put",null);
};
Lino.tickets.UnassignedTickets.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/UnassignedTickets","GET",pk,"post",null);
};

Lino.tickets.UnassignedTickets.insertPanel = Ext.extend(Lino.tickets.Tickets.InsertFormPanel,{
  empty_title: "New Tickets",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/tickets/UnassignedTickets",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.UnassignedTickets.detail;
    this.ls_insert_handler = Lino.tickets.UnassignedTickets.insert;
    Lino.tickets.UnassignedTickets.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.UnassignedTickets.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.tickets.UnassignedTickets.insertPanel(p);
});
Lino.tickets.UnassignedTickets.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/UnassignedTickets","GET",pk,"poststay",null);
};

Lino.tickets.UnassignedTickets.detailPanel = Ext.extend(Lino.tickets.Tickets.DetailFormPanel,{
  empty_title: "Detail Tickets",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/tickets/UnassignedTickets",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.UnassignedTickets.detail;
    this.ls_insert_handler = Lino.tickets.UnassignedTickets.insert;
    Lino.tickets.UnassignedTickets.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.UnassignedTickets.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.tickets.UnassignedTickets.detailPanel(p);
});
Lino.tickets.UnassignedTickets.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.tickets.UnassignedTickets.GridPanel(p);
});

// js_render_GridPanel_class tickets.Sessions
Lino.tickets.Sessions.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/tickets/Sessions",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/tickets/Sessions','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/tickets/Sessions','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/tickets/Sessions','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Sessions",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 17,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "name": "end_time" }, { "name": "break_time" }, { "name": "summary" }, { "name": "user" }, 'userHidden', { "type": "int", "name": "id" }, { "name": "project" }, 'projectHidden', { "name": "partner" }, 'partnerHidden', { "name": "ticket" }, 'ticketHidden', { "name": "time" }, { "type": "boolean", "name": "is_private" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 51,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.Sessions.detail;
    this.ls_insert_handler = Lino.tickets.Sessions.insert;
    var ww = this.containing_window;
    var date2339 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var start_time2340 = new Lino.TimeField({ "selectOnFocus": true });
    var end_time2341 = new Lino.TimeField({ "selectOnFocus": true });
    var break_time2342 = new Lino.TimeField({ "selectOnFocus": true });
    var summary2343 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var user2344 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Sessions/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var id2345 = new Ext.form.NumberField({ "selectOnFocus": true });
    var project2346 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Sessions/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var partner2347 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Sessions/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var ticket2348 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Sessions/ticket", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Ticket..." });
    var time2349 = new Lino.TimeField({ "selectOnFocus": true });
    var is_private2350 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "editor": date2339, "width": Lino.chars2width(9), "dataIndex": "date" }, { "width": Lino.chars2width(9), "colIndex": 1, "sortable": true, "dataIndex": "start_time", "header": "Start time", "editable": true, "editor": start_time2340 }, { "width": Lino.chars2width(9), "colIndex": 2, "sortable": true, "dataIndex": "end_time", "header": "End Time", "editable": true, "editor": end_time2341 }, { "width": Lino.chars2width(9), "colIndex": 3, "sortable": true, "dataIndex": "break_time", "header": "Break Time", "editable": true, "editor": break_time2342 }, { "colIndex": 4, "sortable": true, "header": "Summary", "editable": true, "tooltip": "Short summary of the session.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "summary", "editor": summary2343 }, { "colIndex": 5, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2344, "dataIndex": "user" }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2345, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 7, "sortable": true, "header": "Project", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail'), "editor": project2346, "dataIndex": "project" }, { "colIndex": 8, "sortable": true, "header": "Partner", "editable": true, "tooltip": "The partner to be invoiced for this session.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2347, "dataIndex": "partner" }, { "colIndex": 9, "sortable": true, "header": "Ticket", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('ticketHidden','Lino.tickets.Tickets.detail'), "editor": ticket2348, "dataIndex": "ticket" }, { "width": Lino.chars2width(9), "colIndex": 10, "sortable": true, "dataIndex": "time", "header": "Time", "editable": true, "editor": time2349 }, { "colIndex": 11, "sortable": false, "xtype": "checkcolumn", "header": "is private", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "is_private" } ];
    Lino.tickets.Sessions.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.Sessions.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/Sessions","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.tickets.Sessions.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/Sessions","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.tickets.Sessions.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/Sessions","GET",pk,"put",null);
};
Lino.tickets.Sessions.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/Sessions","GET",pk,"post",null);
};

Lino.tickets.Sessions.insertPanel = Ext.extend(Lino.tickets.Sessions.DetailFormPanel,{
  empty_title: "New Sessions",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/tickets/Sessions",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.Sessions.detail;
    this.ls_insert_handler = Lino.tickets.Sessions.insert;
    Lino.tickets.Sessions.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.Sessions.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.tickets.Sessions.insertPanel(p);
});
Lino.tickets.Sessions.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/tickets/Sessions","GET",pk,"poststay",null);
};

Lino.tickets.Sessions.detailPanel = Ext.extend(Lino.tickets.Sessions.DetailFormPanel,{
  empty_title: "Detail Sessions",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/tickets/Sessions",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.Sessions.detail;
    this.ls_insert_handler = Lino.tickets.Sessions.insert;
    Lino.tickets.Sessions.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.Sessions.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.tickets.Sessions.detailPanel(p);
});
Lino.tickets.Sessions.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.tickets.Sessions.GridPanel(p);
});

// js_render_GridPanel_class outbox.Recipients
Lino.outbox.Recipients.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/outbox/Recipients",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/outbox/Recipients','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/outbox/Recipients','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/outbox/Recipients','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Recipients",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 10,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "mail" }, 'mailHidden', { "name": "partner" }, 'partnerHidden', { "name": "type" }, 'typeHidden', { "name": "address" }, { "name": "name" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 65,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id2352 = new Ext.form.NumberField({ "selectOnFocus": true });
    var mail2353 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Recipients/mail", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Outgoing Mail..." });
    var partner2354 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Recipients/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var type2355 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.outbox.RecipientType });
    var address2356 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var name2357 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2352, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Outgoing Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('mailHidden','Lino.outbox.Mails.detail'), "editor": mail2353, "dataIndex": "mail" }, { "colIndex": 2, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2354, "dataIndex": "partner" }, { "colIndex": 3, "sortable": true, "header": "Recipient Type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(17), "dataIndex": "type", "editor": type2355 }, { "colIndex": 4, "sortable": true, "header": "Address", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "address", "editor": address2356 }, { "colIndex": 5, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2357 } ];
    Lino.outbox.Recipients.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.Recipients.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/Recipients","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.outbox.Recipients.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/Recipients","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.outbox.Recipients.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/Recipients","GET",pk,"put",null);
};
Lino.outbox.Recipients.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/outbox/Recipients","GET",pk,"post",null);
};
Lino.outbox.Recipients.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.Recipients.GridPanel(p);
});

// js_render_GridPanel_class outbox.Mails
Lino.outbox.Mails.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/outbox/Mails",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/outbox/Mails','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/outbox/Mails','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf