/*
 Copyright 2009-2014 Luc Saffre
 License: BSD (see file COPYING for details)
*/

// lino.js --- generated Mon Dec  8 05:55:27 2014 by Lino version 1.6.14.
Ext.BLANK_IMAGE_URL = '/media/extjs/resources/images/default/s.gif';
LANGUAGE_CHOICES = [ [ "en", "English" ], [ "et", "Estonian" ] ];
MEDIA_URL = "/media";

// hack to add a toCamel function, inspired by
// http://jamesroberts.name/blog/2010/02/22/string-functions-for-javascript-trim-to-camel-case-to-dashed-and-to-underscore/
String.prototype.toCamel = function(){
  //~ return this.replace(/(\-[a-z])/g, function($1){return $1.toUpperCase().replace('-','');});
  //~ return this;
  return this.replace(/([A-Z])([A-Z]+)/g, function(match,p1,p2,offset,string){
      //~ console.log("20131005 got ",arguments);
      return p1 + p2.toLowerCase();});
};



/* MonthPickerPlugin: thanks to keypoint @ sencha forum
   http://www.sencha.com/forum/showthread.php?74002-3.x-Ext.ux.MonthMenu&p=356860#post356860
*/
Ext.namespace('Ext.ux'); 

Ext.ux.MonthPickerPlugin = function() { 
    var picker; 
    var oldDateDefaults; 

    this.init = function(pk) { 
        picker = pk; 
        picker.onTriggerClick = picker.onTriggerClick.createSequence(onClick); 
        picker.getValue = picker.getValue.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
        picker.beforeBlur = picker.beforeBlur.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
    }; 

    function setDefaultMonthDay() { 
        oldDateDefaults = Date.defaults.d; 
        Date.defaults.d = 1; 
        return true; 
    } 

    function restoreDefaultMonthDay(ret) { 
        Date.defaults.d = oldDateDefaults; 
        return ret; 
    } 

    function onClick(e, el, opt) { 
        var p = picker.menu.picker; 
        p.activeDate = p.activeDate.getFirstDateOfMonth(); 
        if (p.value) { 
            p.value = p.value.getFirstDateOfMonth(); 
        } 

        p.showMonthPicker(); 
         
        if (!p.disabled) { 
            p.monthPicker.stopFx(); 
            p.monthPicker.show(); 

            p.mun(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mun(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
            p.onMonthClick = p.onMonthClick.createSequence(pickerClick); 
            p.onMonthDblClick = p.onMonthDblClick.createSequence(pickerDblclick); 
            p.mon(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mon(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
        } 
    } 

    function pickerClick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.is('button.x-date-mp-cancel')) { 
            picker.menu.hide(); 
        } else if(el.is('button.x-date-mp-ok')) { 
            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 

    function pickerDblclick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.parent() 
            && (el.parent().is('td.x-date-mp-month') 
            || el.parent().is('td.x-date-mp-year'))) { 

            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 
}; 

Ext.preg('monthPickerPlugin', Ext.ux.MonthPickerPlugin);  


/**
JC Watsons solution (adapted to ExtJS 3.3.1 by LS) is elegant and simple:
`A "fix" for unchecked checkbox submission  behaviour
<http://www.sencha.com/forum/showthread.php?28449>`_

Added special handling for checkbox inputs. 
ExtJS defines disabled checkboxes `readonly`, not `disabled` as for other inputs.

*/
Ext.lib.Ajax.serializeForm = function(form) {
    //~ console.log('20120203 linolib.js serializeForm',form);
    var fElements = form.elements || (document.forms[form] || Ext.getDom(form)).elements, 
        hasSubmit = false, 
        encoder = encodeURIComponent, 
        name, 
        data = '', 
        type, 
        hasValue;

    Ext.each(fElements, function(element){
        name = element.name;
        type = element.type;

        if (!element.disabled && name && !(type == 'checkbox' && element.readonly)) {
            if (/select-(one|multiple)/i.test(type)) {
                Ext.each(element.options, function(opt){
                    if (opt.selected) {
                        hasValue = opt.hasAttribute ? opt.hasAttribute('value') : opt.getAttributeNode('value').specified;
                        data += String.format("{0}={1}&", encoder(name), encoder(hasValue ? opt.value : opt.text));
                    }
                });
            } else if (!(/file|undefined|reset|button/i.test(type))) {
                //~ if (!(/radio|checkbox/i.test(type) && !element.checked) && !(type == 'submit' && hasSubmit)) {
                if (!(type == 'submit' && hasSubmit)) {
                    if (type == 'checkbox') {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&');
                        data += encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&';
                    } else {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + encoder(element.value) + '&');
                        data += encoder(name) + '=' + encoder(element.value) + '&';
                    }
                    hasSubmit = /submit/i.test(type);
                }
            }
        //~ } else {
            //~ console.log(name,type,element.readonly);
        }
    });
    return data.substr(0, data.length - 1);
};



/*
Set a long timeout of fifteen minutes. 
See /blog/2012/0307
*/
Ext.Ajax.timeout = 15 * 60 * 1000; 

/*
 * Thanks to 
 * `huuze <http://stackoverflow.com/users/10040/huuuze>`_ for the question
 * and to 
 * `chrisv <http://stackoverflow.com/users/683808/chrisv>`_
 * for the answer on
 * http://stackoverflow.com/questions/3764589/how-do-i-include-django-1-2s-csrf-token-in-a-javascript-generated-html-form/5485616#5485616
 * 
 * */
 
Ext.Ajax.on('beforerequest', function (conn, options) {
   if (!(/^http:.*/.test(options.url) || /^https:.*/.test(options.url))) {
     if (typeof(options.headers) == "undefined") {
       options.headers = {'X-CSRFToken': Ext.util.Cookies.get('csrftoken')};
     } else {
       options.headers.extend({'X-CSRFToken': Ext.util.Cookies.get('csrftoken')});
     }                        
   }
}, this);


/*
My fix for the "Cannot set QuickTips dismissDelay to 0" bug,
see http://www.sencha.com/forum/showthread.php?183515 
*/
Ext.override(Ext.QuickTip,{
  showAt : function(xy){
        var t = this.activeTarget;
        //~ console.log("20120224 QuickTip.showAt",this.title,this.dismissDelay,t.dismissDelay);
        if(t){
            if(!this.rendered){
                this.render(Ext.getBody());
                this.activeTarget = t;
            }
            if(t.width){
                this.setWidth(t.width);
                this.body.setWidth(this.adjustBodyWidth(t.width - this.getFrameWidth()));
                this.measureWidth = false;
            } else{
                this.measureWidth = true;
            }
            this.setTitle(t.title || '');
            this.body.update(t.text);
            this.autoHide = t.autoHide;
            // bugfix by Luc 20120226
            if (t.dismissDelay != undefined) this.dismissDelay = t.dismissDelay;
            //~ this.dismissDelay = t.dismissDelay || this.dismissDelay;
            if(this.lastCls){
                this.el.removeClass(this.lastCls);
                delete this.lastCls;
            }
            if(t.cls){
                this.el.addClass(t.cls);
                this.lastCls = t.cls;
            }
            if(this.anchor){
                this.constrainPosition = false;
            }else if(t.align){ 
                xy = this.el.getAlignToXY(t.el, t.align);
                this.constrainPosition = false;
            }else{
                this.constrainPosition = true;
            }
        }
        Ext.QuickTip.superclass.showAt.call(this, xy);
    }
});

/*
Another hack. See /docs/blog/2012/0228
*/
Ext.Element.addMethods(
    function() {
        var VISIBILITY      = "visibility",
            DISPLAY         = "display",
            HIDDEN          = "hidden",
            NONE            = "none",
            XMASKED         = "x-masked",
            XMASKEDRELATIVE = "x-masked-relative",
            data            = Ext.Element.data;

        return {
            
            mask : function(msg, msgCls) {
                var me  = this,
                    dom = me.dom,
                    dh  = Ext.DomHelper,
                    EXTELMASKMSG = "ext-el-mask-msg",
                    el,
                    mask;
                // removed the following lines. See /docs/blog/2012/0228
                //~ if (!(/^body/i.test(dom.tagName) && me.getStyle('position') == 'static')) {
                    //~ console.log(20120228,dom.tagName,me);
                    //~ me.addClass(XMASKEDRELATIVE); 
                //~ }
                if (el = data(dom, 'maskMsg')) {
                    el.remove();
                }
                if (el = data(dom, 'mask')) {
                    el.remove();
                }

                mask = dh.append(dom, {cls : "ext-el-mask"}, true);
                data(dom, 'mask', mask);

                me.addClass(XMASKED);
                mask.setDisplayed(true);
                
                if (typeof msg == 'string') {
                    var mm = dh.append(dom, {cls : EXTELMASKMSG, cn:{tag:'div'}}, true);
                    data(dom, 'maskMsg', mm);
                    mm.dom.className = msgCls ? EXTELMASKMSG + " " + msgCls : EXTELMASKMSG;
                    mm.dom.firstChild.innerHTML = msg;
                    mm.setDisplayed(true);
                    mm.center(me);
                }
                
                
                if (Ext.isIE && !(Ext.isIE7 && Ext.isStrict) && me.getStyle('height') == 'auto') {
                    mask.setSize(undefined, me.getHeight());
                }
                
                return mask;
            }

            
        };
    }()
);



Ext.namespace('Lino');
    
    

//~ Lino.subst_user_field = new Ext.form.ComboBox({});
//~ Lino.subst_user = null;
Lino.insert_subst_user = function(p){
    //~ console.log('20120714 insert_subst_user',Lino.subst_user,p);
    //~ if (Lino.subst_user_field.getValue()) {
    if (p.su) return;
    if (Lino.subst_user) {
        //~ p.su = Lino.subst_user_field.getValue();
        p.su = Lino.subst_user;
    //~ } else {
        //~ delete p.su;
    }
    //~ console.log('20120714 insert_subst_user -->',Lino.subst_user,p);
}

Lino.login_window = null;

Lino.autorefresh = function() {
  if (Lino.current_window == null) {
      Lino.viewport.refresh();
      Lino.autorefresh.defer(10000);
  }
}

Lino.show_login_window = function(on_login) {
  //~ console.log('20121103 show_login_window',arguments);
  //~ var current_window = Lino.current_window;
  if (Lino.login_window == null) {
    
      function do_login() { 
            Lino.viewport.loadMask.show()
            login_panel.getForm().submit({ 
                method:'POST', 
                waitTitle:'Connecting', 
                waitMsg:'Sending data...',
                success:function(){ 
                  Lino.login_window.hide();
                  Lino.handle_home_button();
                  Lino.viewport.loadMask.hide();
                  if (typeof on_login == 'string') {
                      Lino.load_url(on_login);
                  } 
                },
                failure: function(form,action) { 
                  Lino.on_submit_failure(form, action);
                  Lino.viewport.loadMask.hide()
                }
            }); 
      };
    
      var login_button = new Ext.Button({ 
        text:"Log in",
        formBind: true,	 
        // Function that fires when user clicks the button 
        handler: do_login});
    
      var login_panel = new Ext.FormPanel({ 
        //~ inspired by http://www.sencha.com/learn/a-basic-login/
        autoHeight:true,
        labelWidth:90,
        url:'/auth', 
        frame:true, 
        defaultType:'textfield',
        monitorValid:true,
        items:[{ 
            fieldLabel:"Username", 
            id: 'username',
            name:'username', 
            autoHeight:true,
            allowBlank:false 
        },{ 
            fieldLabel:"Password", 
            name:'password', 
            inputType:'password', 
            autoHeight:true,
            allowBlank:false 
        }],        
        buttons:[ login_button ]});
        
      Lino.login_window = new Ext.Window({
          layout:'fit',
          defaultButton: 'username',
          width:300,
          title:"Log in", 
          autoHeight:true,
          modal: true,
          closeAction: "hide",
          keys: {
            key: Ext.EventObject.ENTER,
            fn: function() { do_login()}
          },
          items: [login_panel] });
  };
  Lino.login_window.show();
};

Lino.logout = function(id,name) {
    Lino.call_ajax_action(
        Lino.viewport, 'GET', 
        '/auth',
        {}, 'logout', undefined, undefined,
        function(){Lino.reload();})
}

Lino.set_subst_user = function(id, name) {
    //~ console.log(20130723,'Lino.set_subst_user',id,name,Lino.current_window,Lino.viewport);
    Lino.subst_user = id;
    if (Lino.current_window) 
        Lino.current_window.main_item.set_base_param("su",id);
    if (Lino.viewport) 
        Lino.permalink_handler(Lino.current_window)();
}



//~ Lino.select_subst_user = function(cmp,rec,value){
    //~ Lino.subst_user=value;
    //~ console.log(20120713,rec);
//~ }
    
Lino.current_window = null;
Lino.window_history = Array();
    
Lino.chars2width = function(cols) {  return cols * 9; }
Lino.rows2height = function(cols) {  return cols * 20; }



Lino.MainPanel = {
  is_home_page : false,
  setting_param_values : false,
  config_containing_window : function(wincfg) { }
  ,init_containing_window : function(win) { }
  ,is_loading : function() { 
      if (!this.rendered) return true;
      //~ return (Ext.select('.x-loading-msg').elements.length > 0);
      return true; 
    } 
  ,do_when_clean : function(auto_save,todo) { todo() }
  ,get_master_params : function() {
    var p = {}
    p['mt'] = this.content_type; 
    rec = this.get_current_record()
    if (rec) {
      if (rec.phantom) {
          p['mk'] = undefined; 
      }else{
          p['mk'] = rec.id; 
      }
    } else {
      p['mk'] = undefined;
    }
    //~ console.log('get_master_params returns',p,'using record',rec);
    return p;
  }
  ,get_permalink : function() {
    var p = Ext.apply({}, this.get_base_params());
    delete p.fmt;
    Ext.apply(p, this.get_permalink_params());
    
    if (this.toggle_params_panel_btn) {
        p.sp = this.toggle_params_panel_btn.pressed;
        //~ if (this.toggle_params_panel_btn.pressed == this.params_panel_hidden) {
          //~ p.sp = true;
        //~ }
    }
    
    //~ Lino.insert_subst_user(p);
     //~ p.fmt = 'html';
    //~ console.log('get_permalink',p,this.get_permalink_params());
    if (this.is_home_page)
        //~ var url = '';
        var url = '/';
    else 
        var url = this.get_permalink_url();
    if (p.su == null) 
        delete p.su;
    if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
    return url;
  }
  ,get_record_url : function(record_id) {
      var url = '/api' + this.ls_url
      //~ var url = this.containing_window.config.url_data; // ls_url;
      url += '/' + (record_id === undefined ? '-99999' : String(record_id));
      //~ if (record_id !== undefined) url += '/' + String(record_id);
      //~ url += '/' + String(record_id);
      return url;
  }
  ,get_permalink_url : function() {
      return '/api' + this.ls_url;
  }
  ,get_permalink_params : function() {
      //~ return {an:'grid'};
      var p = {};
      if (this.action_name)
          p.an = this.action_name;
      this.add_param_values(p,false)
      return p;
  }
  /*

  Lino.MainPanel.set_status() : the status can have the following keys:

  - field_values
  - param_values
  - base_params
  - record_id
  - active_tab
  - data_record
  - show_params_panel
  - current_page

   */
  ,set_status : function(status, requesting_panel) {}
  ,get_status : function() { return {}}
  ,refresh : function() {}
  ,get_base_params : function() {  // Lino.MainPanel
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,add_params_panel : function (tbar) {
      if (this.params_panel) {
        //~  20130923b
        //~ this.params_panel.autoHeight = true; // 20130924
        var t = this;
        var update = function() {
            var p = t.params_panel;
            //~ console.log("update", p.getSize().height,p.forceLayout,p.autoHeight);
            var w = t.get_containing_window();
            Lino.do_when_visible(w, function() {
                //~ p.doLayout(true); // doLayout(shallow, force)
                w.doLayout(true); // doLayout(shallow, force)
                //~ t.params_panel.on('afterlayout',update,t,{single:true});
            });
        };
        Lino.do_when_visible(this.params_panel, update);
        this.params_panel.on('show',update);
        this.params_panel.on('hide',update);
        //~ this.params_panel.on('bodyresize',update);
        this.params_panel.on('afterlayout',update);
        //~ this.params_panel.on('afterlayout',update,this,{single:true});
        //~ this.params_panel.on('bodyresize',update,this,{single:true});
        //~ this.params_panel.on('resize',update,this,{single:true});
        //~ this.params_panel.on('render',update,this,{single:true});
        
        // this.params_panel.on('render',
        //~ this.params_panel.on('afterlayout',update,this,{single:true,delay:200});
        //~ this.params_panel.on('bodyresize',update,this,{single:true,delay:200});
        this.toggle_params_panel_btn = new Ext.Button({ scope:this, 
          //~ text: "$_("[parameters]")", // gear
          iconCls: 'x-tbar-parameters',
          tooltip:"Show or hide the table parameters panel",
          enableToggle: true,
          //~ pressed: ! this.params_panel.hidden,
          pressed: ! this.params_panel_hidden,
          toggleHandler: function(btn,state) { 
            //~ console.log("20120210 add_params_panel",state,this.params_panel);
            if (state) {
                this.params_panel.show();
            } else {
                this.params_panel.hide();
            }
            //~ this.params_panel.on('afterlayout',update,this,{single:true});
            //~ t.get_containing_window().doLayout();
            //~ this.params_panel.on('afterlayout',function() {
                //~ console.log("20130918 afterlayout");
                //~ t.get_containing_window().doLayout(); // doLayout(shallow, force)
            //~ },this,{single:true});
          }
        }); 
        tbar = tbar.concat([this.toggle_params_panel_btn]);
        var refresh = function() {
            if (!t.setting_param_values) {
                t._force_dirty = true; 
                t.refresh();
            }
        }
        Ext.each(this.params_panel.fields,function(f) {
          //~ f.on('valid',function() {t.refresh()});
          if (f instanceof Ext.form.Checkbox) {
              f.on('check',refresh);
          } else if (f instanceof Ext.DatePicker) {
              f.on('select',refresh);
          } else if (f instanceof Ext.form.TriggerField) {
              f.on('select',refresh);
              //~ f.on('change',refresh);
              //~ f.on('valid',refresh);
          } else {
              if (! f.on) 
                  console.log("20121010 no method 'on'",f);
              else
                  f.on('change',refresh);
            }
          });
      }
      return tbar;
  }
  ,add_param_values : function (p,force_dirty) {
    if (this.params_panel) {
      /* 
      * 20120918 add param_values to the request string 
      * *only if the params_form is dirty*.
      * Otherwise Actor.default_params() would never be used.
      *
      * 20121023 But IntegClients.params_default has non-empty default values. 
      * Users must have the possibility to make them empty.
      * 
      * 20130605 : added `force_dirty` parameter because Checkbox fields don't 
      * mark their form as dirty when check is fired.
      * 
      * 20130721 : `force_dirty` not as a parameter but as 
      * `this._force_dirty` because
      * 
      * 20130915 : both _force_dirty and force_dirty parameter are needed.
      * 
      */
      if (force_dirty || this._force_dirty || this.params_panel.form.isDirty()) {
      //~ if (this._force_dirty || this.params_panel.form.isDirty()) {
        p.pv = this.get_param_values();
        //~ console.log("20130923 form is dirty (",force_dirty,this._force_dirty,this.params_panel.form.isDirty(),")");
        //~ console.log("20130923 form is dirty",p);
      }else{
        //~ console.log("20130923 form not dirty:",this.params_panel.form);
        if (this.status_param_values) 
          p.pv = Lino.fields2array(
            this.params_panel.fields,this.status_param_values);
      }
      //~ if (!this.params_panel.form.isDirty()) return;
      //~ p.pv = this.get_param_values();
      //~ console.log("20120203 add_param_values added pv",p.pv,"to",p);
    }
  },
  get_param_values : function() { // similar to get_field_values()
      return Lino.fields2array(this.params_panel.fields);
  },
  set_param_values : function(pv) {
    if (this.params_panel) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_param_values = pv;
      //~ this.params_panel.form.suspendEvents(false);
      this.setting_param_values = true;
      if (pv) { 
          this.params_panel.form.my_loadRecord(pv);
      } else { 
        this.params_panel.form.reset(); 
      }
      this.setting_param_values = false;
      this._force_dirty = false; 
      //~ this.params_panel.form.resumeEvents();
    }
  }
};




Lino.Viewport = Ext.extend(Ext.Viewport, Lino.MainPanel);
Lino.Viewport = Ext.extend(Lino.Viewport, {
  layout : "fit"
  ,is_home_page : true
  ,initComponent : function(){
    Lino.Viewport.superclass.initComponent.call(this);
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.el,{msg:"Please wait..."});
      //~ console.log("20121118 Lino.viewport.loadMask",this.loadMask);
    },this);
  }
  ,refresh : function() {
      var caller = this;
      // console.log("20140829 Lino.Viewport.refresh()");
      if (caller.loadMask) caller.loadMask.show();
      var success = function(response) {
        if (caller.loadMask) caller.loadMask.hide();
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          //~ console.log('Lino.do_action()',action.name,'result is',result);
          if (result.html) {
              var cmp = Ext.getCmp('dashboard');
              // cmp.removeAll(true);  // 20140829
              cmp.update(result.html, true);
          }
          if (result.message) {
              if (result.alert) {
                  //~ Ext.MessageBox.alert('Alert',result.alert_msg);
                  Ext.MessageBox.alert('Alert',result.message);
              } else {
                  Lino.notify(result.message);
              }
          }
          
          if (result.notify_msg) Lino.notify(result.notify_msg);
          if (result.js_code) { 
            var jsr = result.js_code(caller);
            //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
          };
        }
      };
      var action = {
        url : '/api/main_html',
        waitMsg: "Please wait...",
        failure: Lino.ajax_error_handler(caller),
        success: success,
        method: 'GET',
        params: {}
      };
      Lino.insert_subst_user(action.params);
      Ext.Ajax.request(action);
    
  }
});




Lino.open_window = function(win, st, requesting_panel) {
  // console.log("20140831 Lino.open_window()", win, win.el.getBox());
  var cw = Lino.current_window;
  if (cw) {
    // console.log("20140829 Lino.open_window() save current status",
    //             cw.main_item.get_status());
    Lino.window_history.push({
      window:cw,
      status:cw.main_item.get_status()
    });
  }
  Lino.current_window = win;
  //~ if (st.su) 
      //~ Lino.subst_user_field.setValue(st.su);
  win.main_item.set_status(st, requesting_panel);
  // win.toFront();
  win.show();
};

Lino.load_url = function(url) {
    //~ foo.bar.baz = 2; 
    //~ console.log("20121120 Lino.load_url()");
    //~ Lino.body_loadMask.show();
    Lino.viewport.loadMask.show();
    //~ location.replace(url);
    document.location = url;
}

Lino.close_window = function(status_update, norestore) {
  // norestore is used when called by handle_action_result() who 
  // will call set_status itself later
  var cw = Lino.current_window;
  var ww = Lino.window_history.pop();
  var retval = cw.main_item.requesting_panel;
  // console.log(
  //     "20140917 Lino.close_window() going to close", cw.title,
  //     "previous is", ww, 
  //     "norestore is", norestore,
  //     "retval is", retval);
  if (ww) {
    //~ if (status_update) Ext.apply(ww.status,status_update);
    if(!norestore) {
        if (status_update) status_update(ww);
        ww.window.main_item.set_status(ww.status);
    }
    Lino.current_window = ww.window;
  } else {
      Lino.current_window = null;
      // new since 20140829:
      if(!norestore) { Lino.viewport.refresh(); }
  }
  if (cw) cw.hide_really();
  return retval;
};

Lino.kill_current_window = function() {
  // console.log("20140418 Lino.kill_current_window()");
  var cw = Lino.current_window;
  Lino.current_window = null;
  if (cw) cw.hide_really();
};

Lino.reload = function() {
    // First close all windows to ensure all changes are saved
    Lino.close_all_windows();

    // Then reload current view
    var url =  "/"

    var p = {};
    Lino.insert_subst_user(p)
    if (Ext.urlEncode(p))
        url = url + "?" + Ext.urlEncode(p);

    Lino.load_url(url);
}

Lino.handle_home_button = function() {
  if (Lino.window_history.length == 0)
      Lino.reload();
  else
      Lino.close_all_windows();
}

Lino.close_all_windows = function() {
    while (Lino.window_history.length > 0) {
        Lino.close_window();
    }
}

Lino.calling_window = function() {
    if (Lino.window_history.length) 
        return Lino.window_history[Lino.window_history.length-1];
}

//~ Lino.WindowAction = function(mainItemClass,windowConfig,mainConfig,ppf) {
Lino.WindowAction = function(windowConfig,main_item_fn) {
    //~ if(!mainConfig) mainConfig = {};
    //~ mainConfig.is_main_window = true;
    this.windowConfig = windowConfig;
    this.main_item_fn = main_item_fn;
    //~ if (ppf) mainConfig.params_panel.fields = ppf;
    //~ this.mainConfig = mainConfig;
    //~ this.mainItemClass = mainItemClass;
};

Lino.WindowAction = Ext.extend(Lino.WindowAction,{
    window : null,
    //~ mainItemClass: null,
    get_window : function() {
      //~ if(mainConfig) Ext.apply(this.mainConfig,mainConfig);
      // if (this.window == null || this.window.isDestroyed)  { // 20140829
      // if (this.window == null || this.window.getBox().width == 0)  { // 20140829
      if (this.window == null)  {
      // if (true)  {
          //~ this.windowConfig.main_item = new this.mainItemClass(this.mainConfig);
          this.windowConfig.main_item = this.main_item_fn();
          this.window = new Lino.Window(this.windowConfig);
      }
      return this.window;
    },
    run : function(requesting_panel, status) {
      // console.log('20140829 window_action.run()', this)
      Lino.open_window(this.get_window(), status, requesting_panel);
    }
  
});


Lino.PanelMixin = {
  get_containing_window : function (){
      if (this.containing_window) return this.containing_window;
      return this.containing_panel.get_containing_window();
  }
  ,set_window_title : function(title) {
    //~ this.setTitle(title);
    var cw = this.get_containing_window();

    //~ if (cw) {
    //~ if (cw && cw.closable) {
    if (cw && !cw.main_item.hide_window_title) {
      //~ console.log('20111202 set_window_title(',title,') for',this.containing_window);
      //~ if (! this.containing_window.rendered) console.log("WARNING: not rendered!");
      cw.setTitle(title);
    //~ } else {
      //~ document.title = title;
    }
    //~ else console.log('20111202 not set_window_title(',title,') for',this);
  }
  
};


// Lino.status_bar = new Ext.ux.StatusBar({defaultText:'Lino version 1.6.14.'});




Lino.edit_tinymce_text = function(panel, options) {
  // `panel` is the RichTextPanel
  //~ console.log(20111220,panel);
  //~ var rec = panel.get_current_record();
  var rec = panel.containing_panel.get_current_record();
  var value = rec ? rec.data[panel.editor.name] : '';
  var saving = false;
  var todo_after_save = false;
  var discard_changes = false;
  
  
  function save() {
    //~ if (todo_after_save) {alert('tried to save again'); return; }
    if (saving) {alert('tried to save again'); return; }
    //~ var url = panel.containing_window.main_item.get_record_url(rec.id);
    var url = panel.containing_panel.get_record_url(rec.id);
    var params = Ext.apply({}, panel.containing_panel.get_base_params());
    params[panel.editor.name] = editor.getValue();
    //~ params.su = Lino.subst_user;
    //~ Lino.insert_subst_user(params);
    var a = { 
      params: params, 
      method: 'PUT',
      url: url,
      failure: function() {
          //~ if (editor.ed.getContainer()) 
          editor.ed.setProgressState(0);
          todo_after_save = false;
          saving = false;
          console.log('tinymce.save() failed. sorry.',arguments);
        },
      success: function() {
        saving = false;
        //~ if (editor.ed.getContainer()) 
        editor.ed.setProgressState(0);
        rec.data[panel.editor.name] = editor.getValue();
        if(todo_after_save) {
            var fn = todo_after_save;
            todo_after_save = false;
            fn();
        }
        //~ panel.containing_window.set_current_record(rec);
        panel.refresh();
      }
    };
    //~ if (editor.ed.getContainer()) 
    editor.ed.setProgressState(1); // Show progress
    saving = true;
    //~ console.log(a);
    Ext.Ajax.request(a);
  };
  function save_callback() {
      save();
      //~ save(function(){editor.ed.setDirty(false);})
      /* return true have the save button disabled.  
      That's not perfect because the PUT is asynchronous 
      and the response is not yet known.
      */
      return true;
  }
  //~ var actions = [
    //~ {text:"Save",handler:save}
  //~ ]; 
  //~ console.log(20110610,panel.editor.disabled);
  var settings = {};
  Ext.apply(settings,{
        readonly: panel.editor.disabled,
        //~ language: "de",
        plugins : "save,emotions,spellchecker,advhr,insertdatetime,preview,table,searchreplace,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "save,cancel,|,bold,italic,underline,|,justifyleft,justifycenter,justifyright,fontselect,fontsizeselect,formatselect,|,search,replace",
        theme_advanced_buttons2 : "cut,copy,paste,template,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,link,unlink,anchor,image,|,code,preview,|,forecolor,backcolor",
        theme_advanced_buttons3 : "insertdate,inserttime,|,spellchecker,advhr,,removeformat,|,sub,sup,|,charmap,emotions,|,tablecontrols",      
        theme_advanced_resizing : false,
        convert_urls : false,
        save_onsavecallback : save_callback,
        save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
  });
  Ext.apply(settings,options);
  var editor = new Ext.ux.TinyMCE({
      value : value,
      tinymceSettings: settings
    });
  var win = new Ext.Window({
    title: rec.title, 
    //~ bbar: actions,
    layout: 'fit',
    items: editor,
    width: 600, 
    height:500,
    minWidth: 100,
		minHeight: 100,
    modal: true,
    resizable: true,
    maximizable: true,
    //~ maximized: true,
    //~ closeAction: "close"
    closeAction: "hide"
    //~ hideMode: "offsets",
    //~ constrainHeader: true,
    //~ bodyStyle: 'padding: 10px'
  });

  //~ win.on('beforeclose',function() {
  win.on('beforehide',function() {
    if (todo_after_save) return false;
    if (discard_changes) return true;
    if (editor.isDirty()) {
        //~ var ok = false;
        //~ var allowClose = true;
        var config = {title:"Confirmation"};
        config.buttons = Ext.MessageBox.YESNOCANCEL;
        config.msg = "Save changes to text ?";
        config.modal = true;
        config.fn = function(buttonId,text,opt) {
          //~ console.log('do_when_clean',buttonId)
          if (buttonId == "yes") {
              /* we cancel this close, but save()'s onSuccess will call again.*/
              //~ allowClose = false;
              todo_after_save = function(){win.hide();}
              editor.ed.execCommand('mceSave');
              //~ editor.ed.save(function(){win.close();});
          } else if (buttonId == "no") { 
              discard_changes = true;
              win.hide()
          //~ } else if (buttonId == "cancel") { 
            //~ ok = true;
              //~ allowClose = false;
          //~ } else { 
            //~ console.log('unknwon buttonId:',buttonId);
          }
        }
        Ext.MessageBox.show(config);
        return false;
        //~ return allowClose;
    }
  });
  win.show();
}







/* 
  Originally copied from Ext JS Library 3.3.1
  Modifications by Luc Saffre : 
  - rendering of phantom records
  - fire afteredit event
  - react on dblclcik, not on single click

 */
Lino.CheckColumn = Ext.extend(Ext.grid.Column, {

    processEvent : function(name, e, grid, rowIndex, colIndex){
        //~ console.log('20110713 Lino.CheckColumn.processEvent',name)
        if (name == 'click') {
        //~ if (name == 'mousedown') {
        //~ if (name == 'dblclick') {
            return this.toggleValue(grid, rowIndex, colIndex);
        } else {
            return Ext.grid.ActionColumn.superclass.processEvent.apply(this, arguments);
        }
    },
    
    toggleValue : function (grid,rowIndex,colIndex) {
        var record = grid.store.getAt(rowIndex);
        var dataIndex = grid.colModel.getDataIndex(colIndex);
        // 20120514
        //~ if(record.data.disabled_fields && record.data.disabled_fields[dataIndex]) {
          //~ Lino.notify("This field is disabled");
          //~ return false;
        //~ }
      
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("This field is disabled.");
            //~ return false;
        //~ }
        var startValue = record.data[dataIndex];
        var value = !startValue;
        //~ record.set(this.dataIndex, value);
        var e = {
            grid: grid,
            record: record,
            field: dataIndex,
            originalValue: startValue,
            value: value,
            row: rowIndex,
            column: colIndex,
            cancel: false
        };
        if(grid.fireEvent("beforeedit", e) !== false && !e.cancel){
        //~ if(grid.fireEvent("validateedit", e) !== false && !e.cancel){
            record.set(dataIndex, value);
            delete e.cancel;
            grid.fireEvent("afteredit", e);
        }
        return false; // Cancel event propagation
    },

    renderer : function(v, p, record){
        if (record.phantom) return '';
        p.css += ' x-grid3-check-col-td'; 
        return String.format('<div class="x-grid3-check-col{0}">&#160;</div>', v ? '-on' : '');
    }

    // Deprecate use as a plugin. Remove in 4.0
    // init: Ext.emptyFn
});

// register ptype. Deprecate. Remove in 4.0
// Ext.preg('checkcolumn', Lino.CheckColumn);

// backwards compat. Remove in 4.0
// Ext.grid.CheckColumn = Lino.CheckColumn;

// register Column xtype
Ext.grid.Column.types.checkcolumn = Lino.CheckColumn;


/* 20110725 : 
Lino.on_tab_activate is necessary 
in contacts.Person.2.dtl 
(but don't ask me why...)
*/
Lino.on_tab_activate = function(item) {
  //~ console.log('activate',item); 
  if (item.rendered && item.doLayout) item.doLayout();
  //~ if (item.rendered) item.doLayout();
}

Lino.TimeField = Ext.extend(Ext.form.TimeField,{
  format: 'H:i',
  increment: 15
  });
Lino.DateField = Ext.extend(Ext.form.DateField,{
  //~ boxMinWidth: Lino.chars2width(15), // 20131005 changed from 11 to 15
  format: 'd.m.Y',
  altFormats: 'd/m/Y|Y-m-d'
  });
Lino.DatePickerField = Ext.extend(Ext.DatePicker,{
  //~ boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  //~ altFormats: 'd/m/Y|Y-m-d'
  formatDate : function(date){
      //~ console.log("20121203 formatDate",this.name,date);
      return Ext.isDate(date) ? date.dateFormat(this.format) : date;
  }
  });
Lino.DateTimeField = Ext.extend(Ext.ux.form.DateTime,{
  dateFormat: 'd.m.Y',
  timeFormat: 'H:i'
  //~ ,hiddenFormat: 'd.m.Y H:i'
  });
Lino.URLField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  //~ triggerClass : 'x-form-world-trigger',
  vtype: 'url',
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    window.open(this.getValue(),'_blank');
  }
});
Lino.IncompleteDateField = Ext.extend(Ext.form.TextField,{
  //~ regex: /^-?\d+-[01]\d-[0123]\d$/,
  //~ regex: /^[0123]\d\.[01]\d\.-?\d+$/,
  maxLength: 10,
  boxMinWidth: Lino.chars2width(10),
  regex: /^[0123]?\d\.[01]?\d\.-?\d+$/,
  regexText: 'Enter a date in format YYYY-MM-DD (use zeroes for unknown parts).'
  });


//~ Lino.make_dropzone = function(cmp) {
    //~ cmp.on('render', function(ct, position){
      //~ ct.el.on({
        //~ dragenter:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ return true;
        //~ }
        //~ ,dragover:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ event.stopEvent();
          //~ return true;
        //~ }
        //~ ,drop:{
          //~ scope:this
          //~ ,fn:function(event){
            //~ event.stopEvent();
            //~ console.log(20110516);
            //~ var files = event.browserEvent.dataTransfer.files;
            //~ if(files === undefined){
              //~ return true;
            //~ }
            //~ var len = files.length;
            //~ while(--len >= 0){
              //~ console.log(files[len]);
              //~ // this.processDragAndDropFileUpload(files[len]);
            //~ }
          //~ }
        //~ }
      //~ });
    //~ });
//~ };

//~ Lino.FileUploadField = Ext.ux.form.FileUploadField;

Lino.FileUploadField = Ext.extend(Ext.ux.form.FileUploadField,{
    unused_onRender : function(ct, position){
      Lino.FileUploadField.superclass.onRender.call(this, ct, position);
      this.el.on({
        dragenter:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          return true;
        }
        ,dragover:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          event.stopEvent();
          return true;
        }
        ,drop:{
          scope:this
          ,fn:function(event){
            event.stopEvent();
            //~ console.log(20110516);
            var files = event.browserEvent.dataTransfer.files;
            if(files === undefined){
              return true;
            }
            var len = files.length;
            while(--len >= 0){
              console.log(files[len]);
              //~ this.processDragAndDropFileUpload(files[len]);
            }
          }
        }
      });
    }
});

Lino.FileField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  editable: false,
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    if (this.getValue()) window.open(MEDIA_URL + '/'+this.getValue(),'_blank');
  }
});

Lino.file_field_handler = function(panel,config) {
  if (panel.action_name == 'insert') {
      panel.has_file_upload = true;


      // config.value = '<br/><br/>';

      var f = new Lino.FileUploadField(config);
      //~ Lino.make_dropzone(f);
      return f;
      //~ return new Ext.ux.form.FileUploadField(config);
      //~ return new Lino.FileField(config);
      
  } else {
      //~ return new Lino.URLField(config);
      return new Lino.FileField(config);
  }
}

Lino.VBorderPanel = Ext.extend(Ext.Panel,{
    constructor : function(config) {
      config.layout = 'border';
      delete config.layoutConfig;
      Lino.VBorderPanel.superclass.constructor.call(this,config);
      for(var i=0; i < this.items.length;i++) {
        var item = this.items.get(i);
        if (this.isVertical(item) && item.collapsible) {
          item.on('collapse',this.onBodyResize,this);
          item.on('expand',this.onBodyResize,this);
        }
      }
    },
    isVertical : function(item) {
       return (item.region == 'north' || item.region == 'south' || item.region == 'center');
    },
    onBodyResize: function(w, h){
        //~ console.log('VBorderPanel.onBodyResize',this.title)
      if (this.isVisible()) { // to avoid "Uncaught TypeError: Cannot call method 'getHeight' of undefined."
        var sumflex = 0;
        var availableHeight = this.getInnerHeight();
        var me = this;
        this.items.each(function(item){
          if (me.isVertical(item)) {
              if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  if (item.rendered) availableHeight -= item.getHeight();
              } else {
                  sumflex += item.flex;
              }
          } 
          
        });
        //~ for(var i=0; i < this.items.length;i++) {
          //~ var item = this.items.get(i);
          //~ // if (this.isVertical(item) && item.getResizeEl()) {
          //~ if (this.isVertical(item)) {
              //~ if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  //~ // item.syncSize()
                  //~ // item.doLayout()
                  //~ // if (item.region == "north") console.log('region north',item.getHeight(),item.id, item);
                  //~ // if (item.getHeight() == 0) console.log(20100921,'both flex and getHeight() are 0!');
                  //~ availableHeight -= item.getHeight();
              //~ } else {
                  //~ sumflex += item.flex;
                  //~ // console.log(item.flex);
              //~ }
          //~ } 
          //~ // else console.log('non-vertical item in VBoderPanel:',item)
        //~ }
        var hunit = availableHeight / sumflex;
        //~ console.log('sumflex=',sumflex,'hunit=',hunit, 'availableHeight=',availableHeight);
        for(var i=0; i < this.items.length;i++) {
          var item = this.items.get(i);
          if (this.isVertical(item)) {
              if (item.flex != 0 && ! item.collapsed) {
                  item.setHeight(hunit * item.flex);
                  //~ console.log(item.region,' : height set to',item.getHeight());
              }
          }
          //~ else console.log('non-vertical item in VBoderPanel:',item)
        }
      }
      Lino.VBorderPanel.superclass.onBodyResize.call(this, w, h);
    }
});


/*
  modifications to the standard behaviour of a CellSelectionModel:
  
*/
Ext.override(Ext.grid.CellSelectionModel, {
//~ var dummy = {

    handleKeyDown : function(e){
        /* removed because F2 wouldn't pass
        if(!e.isNavKeyPress()){
            return;
        }
        */
        //~ console.log('handleKeyDown',e)
        var k = e.getKey(),
            g = this.grid,
            s = this.selection,
            sm = this,
            walk = function(row, col, step){
                return g.walkCells(
                    row,
                    col,
                    step,
                    g.isEditor && g.editing ? sm.acceptsNav : sm.isSelectable, 
                    sm
                );
            },
            cell, newCell, r, c, ae;

        switch(k){
            case e.ESC:
            case e.PAGE_UP:
            case e.PAGE_DOWN:
                break;
            default:
                // e.stopEvent(); // removed because Browser keys like Alt-Home, Ctrl-R wouldn't work
                break;
        }

        if(!s){
            cell = walk(0, 0, 1); 
            if(cell){
                this.select(cell[0], cell[1]);
            }
            return;
        }

        cell = s.cell;  
        r = cell[0];    
        c = cell[1];    
        
        switch(k){
            case e.TAB:
                if(e.shiftKey){
                    newCell = walk(r, c - 1, -1);
                }else{
                    newCell = walk(r, c + 1, 1);
                }
                break;
            case e.HOME:
                if (! (g.isEditor && g.editing)) {
                  if (!e.hasModifier()){
                      newCell = [r, 0];
                      //~ console.log('home',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
                      if (activePage > 1) {
                          e.stopEvent();
                          t.moveFirst();
                          return;
                      }
                      newCell = [0, c];
                      break;
                  }
                }
            case e.END:
                if (! (g.isEditor && g.editing)) {
                  c = g.colModel.getColumnCount()-1;
                  if (!e.hasModifier()) {
                      newCell = [r, c];
                      //~ console.log('end',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var d = t.getPageData();
                      if (d.activePage < d.pages) {
                          e.stopEvent();
                          var self = this;
                          t.on('change',function(tb,pageData) {
                              var r = g.store.getCount()-2;
                              self.select(r, c);
                              //~ console.log('change',r,c);
                          },this,{single:true});
                          t.moveLast();
                          return;
                      } else {
                          newCell = [g.store.getCount()-1, c];
                          //~ console.log('ctrl-end',newCell);
                          break;
                      }
                  }
                }
            case e.DOWN:
                newCell = walk(r + 1, c, 1);
                break;
            case e.UP:
                newCell = walk(r - 1, c, -1);
                break;
            case e.RIGHT:
                newCell = walk(r, c + 1, 1);
                break;
            case e.LEFT:
                newCell = walk(r, c - 1, -1);
                break;
            case e.F2:
                if (!e.hasModifier()) {
                    if (g.isEditor && !g.editing) {
                        g.startEditing(r, c);
                        e.stopEvent();
                        return;
                    }
                    break;
                }
            case e.INSERT:
                if (!e.hasModifier()) {
                    if (g.ls_insert_handler && !g.editing) {
                        e.stopEvent();
                        Lino.show_insert(g);
                        return;
                    }
                    break;
                }
            // case e.DELETE:
            //     if (!e.hasModifier()) {
            //         if (!g.editing) {
            //             e.stopEvent();
            //             Lino.delete_selected(g);
            //             return;
            //         }
            //         break;
            //     }

            case e.ENTER:
                e.stopEvent();
                g.onCellDblClick(r,c);
                break;

            default:
                g.handle_key_event(e);
                
        }
        

        if(newCell){
          e.stopEvent();
          r = newCell[0];
          c = newCell[1];
          this.select(r, c); 
          if(g.isEditor && g.editing){ 
            ae = g.activeEditor;
            if(ae && ae.field.triggerBlur){
                ae.field.triggerBlur();
            }
            g.startEditing(r, c);
          }
        //~ } else if (g.isEditor && !g.editing && e.charCode) {
        //~ // } else if (!e.isSpecialKey() && g.isEditor && !g.editing) {
            //~ g.set_start_value(String.fromCharCode(e.charCode));
            //~ // g.set_start_value(String.fromCharCode(k));
            //~ // g.set_start_value(e.charCode);
            //~ g.startEditing(r, c);
            //~ // e.stopEvent();
            //~ return;
        // } else {
          // console.log('20120513',e,g);
        }
        
    }


//~ };
});

 

function PseudoConsole() {
    this.log = function() {};
};
if (typeof(console) == 'undefined') console = new PseudoConsole();

Lino.notify = function(msg) {
  if (msg == undefined) msg = ''; else console.log(msg);
  
    if (msg == undefined) return;
    // Lino.alert(msg);
  
};

Lino.alert = function(msg) {
  Ext.MessageBox.alert('Notify',msg);
};


//~ Lino.show_about = function() {
  //~ new Ext.Window({
    //~ width: 400, height: 400,
    //~ title: "About",
    //~ html: '<a href="http://www.extjs.com" target="_blank">ExtJS</a> version ' + Ext.version
  //~ }).show();
//~ };

function obj2str(o) {
  if (typeof o != 'object') return String(o);
  var s = '';
  for (var p in o) {
    s += p + ': ' + obj2str(o[p]) + '\n';
  }
  return s;
}

Lino.on_store_exception = function (store,type,action,options,response,arg) {
  //~ throw response;
  console.log("on_store_exception: store=",store,
    "type=",type,
    "action=",action,
    "options=",options,
    "response=",response,
    "arg=",arg);
  if (arg) { console.log(arg.stack)};
};

//~ Lino.on_submit_success = function(form, action) {
   //~ Lino.notify(action.result.message);
   //~ this.close();
//~ };

Lino.on_submit_failure = function(form, action) {
    //~ Lino.notify();
  // action may be undefined
    switch (action.failureType) {
        case Ext.form.Action.CLIENT_INVALID:
            Ext.Msg.alert('Client-side failure', 'Form fields may not be submitted with invalid values');
            break;
        case Ext.form.Action.CONNECT_FAILURE:
            Ext.Msg.alert('Connection failure', 'Ajax communication failed');
            break;
        case Ext.form.Action.SERVER_INVALID:
            Ext.Msg.alert('Server-side failure', action.result.message);
   }
};



/*
Lino.save_wc_handler = function(ww) {
  return function(event,toolEl,panel,tc) {
    var pos = panel.getPosition();
    var size = panel.getSize();
    wc = ww.get_window_config();
    Ext.applyIf(wc,{ 
      x:pos[0],y:pos[1],height:size.height,width:size.width,
      maximized:panel.maximized});
    Lino.do_action(ww,{url:'/window_configs/'+ww.config.permalink_name,params:wc,method:'POST'});
  }
};

*/

Lino.show_in_own_window_button = function(handler) {
  return {
    qtip: "Show this panel in own window", 
    id: "up",
    handler: function(event,toolEl,panel, tc) {
      //~ console.log('20111206 report_window_button',panel,handler);
      handler.run(null,{base_params:panel.containing_panel.get_master_params()});
    }
  }
}

Lino.action_handler = function (panel, on_success, on_confirm) {
  return function (response) {
      if (!panel) { 
          if (Lino.current_window) 
              panel = Lino.current_window.main_item;
          else panel = Lino.viewport;
      }
      
    if (panel.loadMask) panel.loadMask.hide(); // 20120211
    if (!response.responseText) return ;
    var result = Ext.decode(response.responseText);
    Lino.handle_action_result(panel, result, on_success, on_confirm);
  }
};

Lino.handle_action_result = function (panel, result, on_success, on_confirm) {

    // console.log('20141127 Lino.handle_action_result()', result);
    
    // if (panel instanceof Lino.GridPanel) {
    //     gridmode = true;
    // } else {
    //     gridmode = false;
    // }

    //~ if (result.goto_record) {
        //~ var js = "Lino." + result.goto_record[0] + '.detail.run';
        //~ var h = eval(js);
        //~ h(panel,{record_id:result.goto_record[1]});
    //~ }
    
    if (result.xcallback) {
        //~ var config = {title:"Confirmation"};
        var config = {title:result.xcallback.title};
        //~ config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        var p = {};
        Lino.insert_subst_user(p);
        config.buttons = result.xcallback.buttons;
        config.msg = result.message;
        config.fn = function(buttonId, text, opt) {
          panel.loadMask.show(); 
          //~ Lino.insert_subst_user(p);
          Ext.Ajax.request({
            method: 'GET',
            url: '/callbacks/'
                  + result.xcallback.id + '/' + buttonId,
            params: p,
            success: Lino.action_handler(panel, on_success, on_confirm)
          });
        }
        Ext.MessageBox.show(config);
        return;
    }

    // `record_id` and/or `data_record` both mean "display the detail
    // of this record". 
    
    if(result.detail_handler_name) {
        // TODO: make sure that result.detail_handler_name is secure
        var detail_handler = eval("Lino." + result.detail_handler_name);
    }
    var ns = {};  // new status
    if (result.close_window) {
        
        if(result.record_id || result.data_record) {
            var ww = Lino.calling_window();
            if (ww && ww.window.main_item instanceof Lino.FormPanel) {
                if (ww.window.main_item.ls_detail_handler == detail_handler) {
                    ns.record_id = result.record_id;
                    ns.data_record = result.data_record;
                    console.log("20140630 use new status.");
                }
            }
        }

        // Subsequent processing expects that `panel` is "the current
        // panel". Since we close the window, `panel` should now point
        // to the previous window. Note the case of an insert window
        // that has been invoked by double-clicking on the phantom row
        // of a slave table in a detail window. In that case we want
        // `panel` to become the grid panel of the slave table who
        // called the insert window, not the master's detail form
        // panel.  When the insert window has been called by an action
        // link (e.g. generated using ar.insert_button), then
        // Lino.close_window can return `undefined`.

        panel = Lino.close_window(function(st) {Ext.apply(st, ns)}); 
        if (!panel) 
            panel = Lino.current_window.main_item;

    }

    if(result.record_id || result.data_record) {
        if (! (ns.record_id || ns.data_record)) {
          if (panel instanceof Lino.FormPanel 
              && panel.ls_detail_handler == detail_handler) 
            {
              // console.log("20140630 use panel.set_status().");
              panel.set_status({
                  record_id: result.record_id,
                  data_record: result.data_record});
          } else {
              // console.log("20140630 run detail_handler.");
              detail_handler.run(null, {
                  record_id: result.record_id,
                  data_record: result.data_record,
                  base_params: panel.get_base_params()});
          }

          // if (panel instanceof Lino.FormPanel 
          //     && panel.ls_url == result.actor_url) {
          //     // console.log("20140506 case 2 it's a FormPanel:", panel);
          //     panel.set_status({
          //         record_id: result.record_id,
          //         data_record: result.data_record});
          // } else if (panel.ls_detail_handler 
          //            && panel.ls_url == result.actor_url) {
          //     // console.log("20140506 case 4");
          //     panel.ls_detail_handler.run(null, {
          //         record_id: result.record_id,
          //         data_record: result.data_record,
          //         base_params: panel.get_base_params()});
          // } else {
          //     result.refresh_all = true;
          //     console.log("20140604 case 6", result.actor_url);
          // }
        }
    }

    // `eval_js` must get handled after `close_window` because it
    // might ask to open a new window (and we don't want to close that
    // new window).  It must execute *before* any MessageBox,
    // otherwise the box would get hidden by a window that opens
    // afterwards.

    if (result.eval_js) {
        //~ console.log(20120618,result.eval_js);
        eval(result.eval_js);
    }
    
    if (on_success && result.success) {
        // console.log("20140430 handle_action_result calls on_success", 
        //             on_success);
        on_success(result);
    }
    
    if (result.info_message) {
        console.log(result.info_message);
    }
    
    if (result.warning_message) {
        if (!result.alert) result.alert = "Warning";
        Ext.MessageBox.alert(result.alert, result.warning_message);
    }
    
    if (result.message) {
        //~ if (result.alert && ! gridmode) {
        if (result.alert) { // 20120628b 
            //~ Ext.MessageBox.alert('Alert',result.alert_msg);
            if (result.alert === true) result.alert = "Alert";
            Ext.MessageBox.alert(result.alert, result.message);
        } else {
            Lino.notify(result.message);
        }
    }

    if(result.record_deleted && panel.ls_detail_handler == detail_handler) {
        panel.after_delete();
    }
    
    if (result.refresh_all) {
        var cw = Lino.current_window;
        // var cw = panel.get_containing_window();
        if (cw) {
            // console.log("20140917 refresh_all calls refresh on", cw.main_item);
            cw.main_item.refresh();
        }
        // else console.log("20140917 cannot refresh_all because ",
        //                  "there is no current_window");
    } else {
        if (result.refresh) {
            // console.log("20140917 Gonna call panel.refresh()", panel);
            panel.refresh();
        }
    }if (result.open_url) {
        //~ console.log(20111126,result.open_url);
        //~ if (!result.message)
            //~ Lino.notify('Open new window <a href="'+result.open_url+'" target="_blank">'+result.open_url+'</a>');
        window.open(result.open_url,'foo',"");
        //~ document.location = result.open_url;
    }
};

// obsolete but still used for deleting records.
Lino.do_action = function(caller,action) { 
  action.success = function(response) {
    if (caller.loadMask) caller.loadMask.hide();
    //~ console.log('Lino.do_action()',action,'action success',response);
    if (action.after_success) {
        //~ console.log('Lino.do_action() calling after_success');
        action.after_success();
    }
    if (response.responseText) {
      var result = Ext.decode(response.responseText);
      //~ console.log('Lino.do_action()',action.name,'result is',result);
      if (result.message) {
          if (result.alert) {
              //~ Ext.MessageBox.alert('Alert',result.alert_msg);
              Ext.MessageBox.alert('Alert',result.message);
          } else {
              Lino.notify(result.message);
          }
      }
      
      //~ if (result.alert_msg) Ext.MessageBox.alert('Alert',result.alert_msg);
      //~ if (result.message) Lino.notify(result.message);
      if (result.notify_msg) Lino.notify(result.notify_msg);
      if (result.js_code) { 
        //~ console.log('Lino.do_action()',action,'gonna call js_code in',result);
        var jsr = result.js_code(caller);
        //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
        if (action.after_js_code) {
          //~ console.log('Lino.do_action()',action,'gonna call after_js_code');
          action.after_js_code(jsr);
          //~ console.log('Lino.do_action()',action,'returned from after_js_code');
        //~ } else {
          //~ console.log('Lino.do_action()',action,' : after_js_code is false');
        }
      };
    }
  };
  Ext.applyIf(action,{
    waitMsg: "Please wait...",
    failure: Lino.ajax_error_handler(caller),
    params: {}
  });
  //~ action.params.su = Lino.subst_user;
  Lino.insert_subst_user(action.params);
  
  Ext.Ajax.request(action);
};

//~ Lino.gup = function( name )
//~ {
  //~ // Thanks to http://www.netlobo.com/url_query_string_javascript.html
  //~ name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
  //~ var regexS = "[\\?&]"+name+"=([^&#]*)";
  //~ var regex = new RegExp( regexS );
  //~ var results = regex.exec( window.location.href );
  //~ if( results == null )
    //~ return "";
  //~ else
    //~ return results[1];
//~ };

//~ Lino.refresh_handler = function (ww) {
  //~ return function() { 
      //~ console.log('refresh',ww);
      //~ ww.main_item.doLayout(false,true);
      //~ ww.main_item.syncSize();
  //~ }
//~ };

//~ Lino.tools_close_handler = function (ww) {
  //~ return function() { 
      //~ ww.close();
  //~ }
//~ };
Lino.permalink_handler = function (ww) {
  return function() { 
    //~ document.location = ww.main_item.get_permalink();
    //~ console.log('20130723 Lino.permalink_handler',ww);
    
    /* Uncaught TypeError: Cannot read property 'main_item' of null  */
    if (ww) {
        var url = ww.main_item.get_permalink();
    } else {
        var url = Lino.viewport.get_permalink();
    }
    Lino.load_url(url);
  }
};
//~ Lino.run_permalink = function() {
  //~ var plink = Lino.gup('permalink');
  //~ if(plink) { eval('Lino.'+plink); }
//~ }


Lino.ajax_error_handler = function(panel) {
  return function(response,options) {
    console.log('Ajax failure:', response, options);
    if (panel.loadMask) panel.loadMask.hide();
    if (response.responseText) {
      var lines = response.responseText.split('\n');
      if (lines.length > 10) {
          line = lines.splice(5, lines.length-10, "(...)");
      }
      //~ console.log(20131005, response.statusText.toCamel());
      Ext.MessageBox.alert(
        response.statusText.toCamel(),
        lines.join('<br/>')
        //~ response.responseText.replace(/\n/g,'<br/>'))
      )
    } else {
      Ext.MessageBox.alert('Action failed',
        'Lino server did not respond to Ajax request');
    }
  }
}
// Ext.Ajax.on('requestexception',Lino.ajax_error_handler)
 


Ext.QuickTips.init();

/* setting QuickTips dismissDelay to 0 */
// Apply a set of config properties to the singleton
//~ Ext.apply(Ext.QuickTips.getQuickTip(), {
//~ Ext.apply(Ext.ToolTip, {
    //~ dismissDelay: 0
    //~ autoHide: false,
    //~ closable: true,
    //~ maxWidth: 200,
    //~ minWidth: 100,
    //~ showDelay: 50      // Show 50ms after entering target
    //~ ,trackMouse: true
//~ });


//~ Ext.apply(Ext.QuickTip, {
    //~ dismissDelay: 0,
//~ });
  
Lino.quicktip_renderer = function(title,body) {
  return function(c) {
    //~ if (c instanceof Ext.Panel) var t = c.bwrap; else // 20130129
    if (c instanceof Ext.Panel) var t = c.header; else // 20130129
    var t = c.getEl();
    //~ console.log(20130129,t,title,body);
    //~ t.dismissDelay = 0;
    Ext.QuickTips.register({
      target: t,
      //~ cls: 'lino-quicktip-classical',
      dismissDelay: 0,
      //~ autoHide: false,
      showDelay: 50,      // Show 50ms after entering target
      //~ title: title,
      text: body
    });
  }
};


  
Lino.help_text_editor = function() {
  //~ var bp = {
      //~ mk:this.content_type,
      //~ mt:1
    //~ };
    //~ console.log(20120202,bp);
  //~ Lino.lino.ContentTypes.detail({},{base_params:bp});
  //~ Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
  Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
}

// Path to the blank image should point to a valid location on your server
//~ Ext.BLANK_IMAGE_URL = MEDIA_URL + '/extjs/resources/images/default/s.gif'; 


// used as Ext.grid.Column.renderer for id columns in order to hide the special id value -99999
Lino.id_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  return value;
}

Lino.raw_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  return value;
}

Lino.text_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return "not implemented"; 
  return value;
}

Lino.NullNumberColumn = Ext.extend(Ext.grid.Column, {
    align : 'right', 
    format : '0,00/i', 
    renderer : function(value, metaData, record, rowIndex, colIndex, store) {
        //~ console.log(20130128,"NullNumberColumn.renderer",value);
        if (value === null) return '';
        return Ext.util.Format.number(value, this.format);
    }
});


Lino.link_button = function(url) {
    // return '<a href="' + url + '"><img src="/media/lino/extjs/images/xsite/link.png" alt="link_button"></a>'
    return '<a href="' + url + '" style="text-decoration:none;">&#10138;</a>'
}

Lino.fk_renderer = function(fkname,handlername) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    //~ if (record.phantom) return '';
    if (value) {
        return Lino.link_button('javascript:'+handlername + '.run(null,{record_id:\'' + String(record.data[fkname]) + '\'})")') + value;
        // until 20140822 (clickable foreign keys):
        // var s = '<a href="javascript:' ;
        // s += handlername + '.run(null,{record_id:\'' + String(record.data[fkname]) + '\'})">';
        // s += value + '</a>';
        // return s
    }
    return '';
  }
};

Lino.lfk_renderer = function(panel,fkname) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  var handlername = 'console.log';
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '({},{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

//~ Lino.gfk_renderer = function() {
  //~ return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ if (record.phantom) return '';
    //~ console.log('Lino.gfk_renderer',value,colIndex,record,metaData,store);
    //~ return value;
  //~ }
//~ };


Lino.build_buttons = function(panel,actions) {
  //~ console.log("20121006 Lino.build_buttons",actions);
  if (actions) {
    var buttons = Array(actions.length);
    var cmenu = Array(actions.length);
    var keyhandlers = {};
    for (var i=0; i < actions.length; i++) { 
      var a = actions[i];
      if (a.menu) a.menu = Lino.build_buttons(panel,a.menu).bbar;
      buttons[i] = a;
      cmenu[i] = {
            text : a.menu_item_text,
            iconCls : a.iconCls,
            menu : a.menu
          };
      if (a.panel_btn_handler) {
          var h = a.panel_btn_handler.createCallback(panel);
          if (a.auto_save == true) {
              h = panel.do_when_clean.createDelegate(panel,[true,h]);
          } else if (a.auto_save == null) {
              h = panel.do_when_clean.createDelegate(panel,[false,h]);
          } else if (a.auto_save == false) {
              // h = h;
          } else {
              console.log("20120703 unhandled auto_save value",a)
          }
          buttons[i].handler = h;
          cmenu[i].handler = h;
          if (a.keycode) {
              keyhandlers[a.keycode] = h;
          }
          //~ if (buttons[i].xtype == 'splitbutton') {
              //~ cmenu[i].menu = a.menu;
          //~ } else {
              //~ cmenu[i].handler = h;
          //~ }
      } else {
          console.log("action without panel_btn_handler",a)
          // cmenu[i].handler = a.handler;
      }
    }
    return {
        bbar:buttons, 
        cmenu:new Ext.menu.Menu(cmenu),
        keyhandlers: keyhandlers
    };
  }
}

Lino.do_when_visible = function(cmp,todo) {
  //~ if (cmp.el && cmp.el.dom) 
  if (cmp.isVisible()) { 
    // 'visible' means 'rendered and not hidden'
    //~ console.log(cmp.title,'-> cmp is visible now');
    todo(); 
  //~ } else {
      //~ cmp.on('resize',todo,cmp,{single:true});
  //~ }
  //~ if (false) { // 20120213
  } else { 
    //~ console.log('Lino.do_when_visible() must defer because not isVisible()',todo,cmp);
    if (cmp.rendered) {
      //~ console.log(cmp,'-> cmp is rendered but not visible: and now?');
      //~ console.log(cmp.title,'-> cmp is rendered but not visible: try again in a moment...');
      //~ var fn = function() {Lino.do_when_visible(cmp,todo)};
      //~ fn.defer(100);
      
      Lino.do_when_visible.defer(50,this,[cmp,todo]);
      //~ Lino.do_when_visible.defer(100,this,[cmp,todo]);
      
    } else {
      //~ console.log(cmp.title,'-> after render');
      cmp.on('afterrender',todo,cmp,{single:true});
    }
  }
  
};    

/*
*/
Lino.do_on_current_record = function(panel, fn, phantom_fn) {
  // console.log('20140930 do_on_current_record', arguments);
  var rec = panel.get_current_record();
  if (rec == undefined) {
    Lino.notify("There's no selected record.");
    return;
  }
  // 20120307 A VirtualTable with a Detail (lino.Models) has only "phantom" records.
  if (rec.phantom) {
    //~ if (!panel.editable) { console.log("20120312 not editable:",panel)}
    if (phantom_fn) {
      phantom_fn(panel);
    } else {
      Lino.notify("Action not available on phantom record.");
    }
    return;
  }
  return fn(rec);
};


Lino.call_ajax_action = function(
    panel, method, url, p, actionName, step, on_confirm, on_success) {
  p.an = actionName;
  if (!panel || !panel.isVisible()) {
  //~ if (true) { // 20131026 : workflow_actions of a newly created record detail executed but did't refresh the screen because their requesting panel was the insert (not the detail) formpanel.
      if (Lino.current_window) 
          panel = Lino.current_window.main_item;
      else panel = Lino.viewport;
  }
  Ext.apply(p, panel.get_base_params());

  if (panel.get_selected) {
      var selected_recs = panel.get_selected();
      //~ console.log("20130831",selected_recs);
      var rs = Array(selected_recs.length);
      for(var i=0; i < selected_recs.length;i++) {
          rs[i] = selected_recs[i].data.id;
      };
      p.sr = rs;
  }
  
  // console.log("20140516 Lino.call_ajax_action", p, actionName, step);
  
  if (panel.loadMask) panel.loadMask.show(); 
    
  Ext.Ajax.request({
    method: method
    ,url: url
    ,params: p
    ,success: Lino.action_handler(panel, on_success, on_confirm)
    ,failure: Lino.ajax_error_handler(panel)
  });
};




Lino.row_action_handler = function(actionName, hm, pp) {
  var p = {};
  var fn = function(panel, btn, step) {
      // console.log('20140930 row_action_handler');
      if (pp) { p = pp(panel); if (! p) return; }
      
      if (!panel || panel.get_current_record == undefined) { // AFTER_20130725
        // console.log('20140930 row_action_handler 2', panel);
        panel = Ext.getCmp(panel);
        if (panel == undefined) {
          Lino.notify("Invalid panel spec.");
          return;
        }
      }
      
      Lino.do_on_current_record(panel, function(rec) {
          //~ console.log(panel);
          panel.add_param_values(p, true);
          Lino.call_ajax_action(
              panel, hm, panel.get_record_url(rec.id), 
              p, actionName, step, fn);
      });
  };
  return fn;
};

Lino.list_action_handler = function(ls_url,actionName,hm,pp) {
  var p = {};
  var url = '/api' + ls_url
  var fn = function(panel,btn,step) {
      //~ console.log("20121210 Lino.list_action_handler",arguments);
      if (pp) { p = pp(panel);  if (! p) return; }
      if (panel)  // may be undefined when called e.g. from quicklink
          panel.add_param_values(p,true);
      Lino.call_ajax_action(panel, hm,url, p, actionName, step, fn);
  };
  return fn;
};

Lino.param_action_handler = function(window_action) { // 20121012
  var fn = function(panel,btn,step) {
    Lino.do_on_current_record(panel,function(rec) {
      window_action.run(panel.getId(),{}); 
    });
  };
  return fn;
};


Lino.run_row_action = function(
    requesting_panel, url, meth, pk, actionName, params, preprocessor) {
  //~ var panel = action.get_window().main_item;
    console.log("20140930 Lino.run_row_action", params);
  url = '/api' + url  + '/' + pk;
  var panel = Ext.getCmp(requesting_panel);
  if (!params) params = {};
  if (preprocessor) {
      var p = preprocessor(); 
      Ext.apply(params, p);
  }
  var fn = function(panel, btn, step) {
    Lino.call_ajax_action(panel, meth, url, params, actionName, step, fn);
  }
  fn(panel, null, null);
}

Lino.put = function(requesting_panel, pk, data) {
    var panel = Ext.getCmp(requesting_panel);
    //~ var panel = null; // 20131026
    var p = {};
    p.an = 'put'; // SubmitDetail.action_name

    Ext.apply(p,data);
    var req = {
        params:p
        ,waitMsg: 'Saving your data...'
        ,scope: panel
        ,success: Lino.action_handler( panel, function(result) { 
            panel.refresh();
        })
        ,failure: Lino.ajax_error_handler(panel)
    };
    req.method = 'PUT';
    req.url = '/api' + panel.ls_url + '/' + pk;
    if (panel.loadMask) panel.loadMask.show(); 
    Ext.Ajax.request(req);
}



Lino.show_detail = function(panel, btn) {
  Lino.do_on_current_record(panel, 
    function(rec) {
      //~ panel.loadMask.show();
      Lino.run_detail_handler(panel, rec.id);
    },
    Lino.show_insert
  );
};

Lino.run_detail_handler = function(panel,pk) {
  var bp = panel.get_base_params();
  panel.add_param_values(bp); // 20120918
  var status = {
    record_id:pk,
    base_params:bp
  }
  //~ console.log("20120918 Lino.show_detail",status);
  panel.ls_detail_handler.run(null,status);
}

Lino.show_fk_detail = function(combo,detail_action,insert_action) {
    //~ console.log("Lino.show_fk_detail",combo,handler);
    pk = combo.getValue();
    if (pk) {
        detail_action.run(null,{record_id: pk})
      } else {
        insert_action.run(null,{record_id:-99999});
        //~ Lino.notify("Cannot show detail for empty foreign key.");
      }
};

Lino.show_insert = function(panel,btn) {
  var bp = panel.get_base_params();
  //~ console.log('20120125 Lino.show_insert',bp)
  //~ panel.ls_insert_handler.run(null,{record_id:-99999,base_params:bp});
  panel.ls_insert_handler.run(panel.getId(),{record_id:-99999,base_params:bp});
};



if (Ext.ux.grid !== undefined) {
    Lino.GridFilters = Ext.extend(Ext.ux.grid.GridFilters,{
      encode:true,
      local:false
    });
} else {
    Lino.GridFilters = function() {}; // dummy
    Ext.override(Lino.GridFilters,{
      init : function() {}
    });
};



Lino.FieldBoxMixin = {
  before_init : function(config,params) {
    if (params) Ext.apply(config,params);
    var actions = Lino.build_buttons(this, config.ls_bbar_actions);
    if (actions) config.bbar = actions.bbar;
  },
  //~ constructor : function(ww,config,params){
    //~ this.containing_window = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  do_when_clean : function(auto_save,todo) { todo() },
  //~ format_data : function(html) { return '<div class="htmlText">' + html + '</div>' },
  format_data : function(html) { return html },
  get_base_params : function() {
    // needed for insert action
    var p = Ext.apply({}, this.base_params);
    Lino.insert_subst_user(p);
    return p;
  },
  set_base_params : function(p) {
    this.base_params = Ext.apply({},p);
    //~ if (p.param_values) this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  },
  set_base_param : function(k,v) {
    this.base_params[k] = v;
  }
};



Lino.HtmlBoxPanel = Ext.extend(Ext.Panel, Lino.PanelMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel, Lino.FieldBoxMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel, {
  disabled_in_insert_window : true,
  constructor : function(config,params) {
    this.before_init(config,params);
    Lino.HtmlBoxPanel.superclass.constructor.call(this, config);
  },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.constructor.call(this, ww,config,params);
  //~ },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  //~ disable : function() { var tb = this.getBottomToolbar(); if(tb) tb.disable()},
  //~ enable : function() { var tb = this.getBottomToolbar(); if(tb) tb.enable()},
  onRender : function(ct, position){
    Lino.HtmlBoxPanel.superclass.onRender.call(this, ct, position);
    //~ console.log(20111125,this.containing_window);
    if (this.containing_panel) {
      this.containing_panel.on('enable',this.enable,this);
      this.containing_panel.on('disable',this.disable,this);
    }
    this.el.on({
      dragenter:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        return true;
      }
      ,dragover:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        event.stopEvent();
        return true;
      }
      ,drop:{
        scope:this
        ,fn:function(event){
          event.stopEvent();
          //~ console.log(20110516);
          var files = event.browserEvent.dataTransfer.files;
          if(files === undefined){
            return true;
          }
          var len = files.length;
          while(--len >= 0){
            console.log(files[len]);
            //~ this.processDragAndDropFileUpload(files[len]);
          }
          Lino.show_insert(this);
        }
      }
    });
  },
  refresh : function(unused) { 
      // this.containing_panel.refresh();
      this.refresh_with_after();
  },
  /* HtmlBoxPanel */
  refresh_with_after : function(after) {
      // var todo = this.containing_panel.refresh();
      var box = this.items.get(0);
      var todo = function() {
        if (this.disabled) { return; }
        this.set_base_params(this.containing_panel.get_master_params());

        var el = box.getEl();
        if (el) {
            var record = this.containing_panel.get_current_record();
            var newcontent = record ? 
                this.format_data(record.data[this.name]) : '';
            // console.log('20140917 HtmlBox.refresh()',
            //             this.name, record.data.LinksByHuman);
            el.update(newcontent, true);
        // } else {
        //     console.log('20140502 cannot HtmlBox.refresh()',this.name);
        }
      };

      Lino.do_when_visible(box, todo.createDelegate(this));
  }
});
//~ Ext.override(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);



Lino.RichTextPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,Lino.FieldBoxMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,{
    
  //~ initComponent : function(){
    //~ Lino.RichTextPanel.superclass.initComponent.call(this);
  //~ },
  constructor : function(config,params) {
    //~ console.log('Lino.RichTextPanel.initComponent',this);
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + String(rec.id) + "/" + config.name;
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + config.name;
    var t = this;
    var tinymce_options = {
        theme : "advanced",
        content_css: '/media/lino/extjs/lino.css',
        language: 'en',
        //~ template_external_list_url : url,
        theme_advanced_toolbar_location : "top",
        theme_advanced_toolbar_align : "left",
        theme_advanced_statusbar_location : "bottom",
        template_popup_width : 700,
        template_popup_height : 500,
        template_replace_values : { 
            data_field : function(element){ 
                //~ console.log(20110722,fieldName,t.containing_window.get_current_record()); 
                var fieldName = element.innerHTML;
                element.innerHTML = t.containing_panel.get_current_record().data[fieldName];
            } 
        }
      };
      
    var editorConfig = {
      tinymceSettings: {
        plugins : "noneditable,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "bold,italic,underline,|,justifyleft,justifycenter,justifyright,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,removeformat,template",
        theme_advanced_buttons2 : "",
        theme_advanced_buttons3 : "", // ,|,sub,sup,|,charmap",      
        theme_advanced_resizing : false
        //~ save_onsavecallback : save_callback,
        //~ save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
        
    }};
    Ext.apply(editorConfig.tinymceSettings,tinymce_options);
    //~ editorConfig.name = config.action_name;
    editorConfig.name = config.name;
    delete config.name;
    //~ config.title = config.label;
    //~ delete config.label;
    this.before_init(config,params);
    
    this.editor = new Ext.ux.TinyMCE(editorConfig);
    var t = this;
    config.tools = [{
                      qtip: "Edit text in own window", 
                      id: "up",
                      handler: function(){
                        if(t.editor.isDirty()) {
                            var record = t.containing_panel.get_current_record();
                            record.data[t.editor.name] = t.editor.getValue();
                        }
                        Lino.edit_tinymce_text(t, tinymce_options)
                      }
                    }];
    
    config.items = this.editor;
    config.layout = "fit";
    Lino.RichTextPanel.superclass.constructor.call(this, config);
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  /* RichTextPanel */
  refresh_with_after : function(after) {
    var record = this.containing_panel.get_current_record();
    // console.log('20140504 RichTextPanel.refresh()',
    //             this.title,record.title, record);
    var todo = function() {
      if (record) {
        var url = '/templates' 
              + this.containing_panel.ls_url + "/" 
              + String(record.id) + "/" + this.editor.name;
        //~ console.log('RichTextPanel.refresh()',url);
        if (this.editor.ed) this.editor.ed.settings.template_external_list_url = url;
        this.set_base_params(this.containing_panel.get_master_params());
        //~ var v = record ? this.format_data(record.data[this.editor.name]) : ''
        var v = this.format_data(record.data[this.editor.name])
        this.editor.setValue(v);
      } else {
        this.editor.setValue('(no data)');
      }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
//~ Ext.override(Lino.RichTextPanel,Lino.FieldBoxMixin);



Lino.ActionFormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel, Lino.PanelMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel, Lino.FieldBoxMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel, {
  //~ layout:'fit'
  //~ ,autoHeight: true
  //~ ,frame: true
  window_title : "Action Parameters",
  constructor : function(config){
    config.bbar = [
        {text: 'OK', handler: this.on_ok, scope: this},
        {text: 'Cancel', handler: this.on_cancel, scope: this}
    ];
    Lino.ActionFormPanel.superclass.constructor.call(this, config);
  }
  //~ ,initComponent : function(){
    //~ Lino.ActionFormPanel.superclass.initComponent.call(this);
  //~ }
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
    var panel = this.requesting_panel;
    // var panel = this.get_containing_window().main_item;
    // console.log("20131004 on_ok",this,panel,arguments);
    var actionName = this.action_name;
    var pk = this.record_id;
    if (pk == undefined && this.base_params) { pk = this.base_params.mk; }
    if (pk == undefined && panel) {
        pk = panel.get_current_record().id;
    }
    if (pk == undefined) {
        Lino.alert("Sorry, dialog action without base_params.mk");
        return;
    }
    var self = this;
    // function on_success() { self.get_containing_window().close(); };
    // see 20131004 and 20140430
    var url = '/api';
    if (panel) 
        url += panel.ls_url;
    else 
        url += this.ls_url;
    url += '/' + pk;
    // prepare possible recursive call
    var fn = function(panel, btn, step) {
      var p = {};
      self.add_field_values(p)
      Lino.call_ajax_action(
          panel, 'GET', url, p, actionName, step, fn); //  , on_success);
    }
    fn(panel, null, null);
    
    
  }
  /* ActionFormPanel*/
  ,set_status : function(status, rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 ActionFormPanel.set_status()',status,rp,this.requesting_panel);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_field_values(status.field_values);
    if (status.base_params) this.set_base_params(status.base_params);
    this.record_id = status.record_id;
  }
  
  ,before_row_edit : function(record) {}
  ,add_field_values : function (p) { // similar to add_param_values()
      //~ 20121023 
      if (this.form.isDirty()) {
        p.fv = this.get_field_values();
      }else{
        if (this.status_field_values) 
          p.fv = Lino.fields2array(this.fields,this.status_field_values);
      }
      //~ if (!this.form.isDirty()) return;
      //~ p.$ext_requests.URL_PARAM_FIELD_VALUES = this.get_field_values();
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
  }
  ,get_field_values : function() {
      return Lino.fields2array(this.fields);
  }
  ,set_field_values : function(pv) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_field_values = pv;
      if (pv) {
          this.form.my_loadRecord(pv);
          var record = { data: pv };
          this.before_row_edit(record);
      } else {
          this.form.reset(); 
          this.before_row_edit();
      }
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.title = this.window_title;
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok }
      ]
      
      if (!wincfg.defaultButton) this.getForm().items.each(function(f){
          if(f.isFormField){ 
              wincfg.defaultButton = f;
              return false;
          }
      });

  }
});

    
Lino.fields2array = function(fields,values) {
    //~ console.log('20130605 fields2array gonna loop on', fields,values);
    var pv = Array(fields.length);
    for(var i=0; i < fields.length;i++) {
        var f = fields[i]
        if (values) 
          var v = values[f.name];
        else 
          var v = f.getValue();
        if (f.formatDate) {
            pv[i] = f.formatDate(v); 
        } else {
            pv[i] = v; // f.getValue(); 
        }
    }
    return pv;
}


Lino.FormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.FormPanel = Ext.extend(Lino.FormPanel,Lino.PanelMixin);
Lino.FormPanel = Ext.extend(Lino.FormPanel,{
  params_panel_hidden : false,
  save_action_name : null, 
  //~ base_params : {},
  //~ trackResetOnLoad : true,
  //~ query_params : {},
  //~ 20110119b quick_search_text : '',
  constructor : function(config,params){
    if (params) Ext.apply(config,params);
    this.base_params = {};
    //~ ww.config.base_params.query = ''; // 20111018
    //~ console.log(config);
    //~ console.log('FormPanel.constructor() 1',config)
    //~ Ext.applyIf(config,{base_params:{}});
    //~ console.log('FormPanel.constructor() 2',config)
      
    config.trackResetOnLoad = true;
    
    Lino.FormPanel.superclass.constructor.call(this, config);
      
    //~ this.set_base_param('$URL_PARAM_FILTER',null); // 20111018
    //~ this.set_base_param('$URL_PARAM_FILTER',''); // 20111018
      
  },
  initComponent : function(){
    
    this.containing_panel = this;

    //~ console.log("20111201 containing_window",this.containing_window,this);


    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    if (actions) {
        this.bbar = actions.bbar;
    //~ } else {
        //~ this.bbar = [];
    }
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ var config = this;
    
    //~ if (this.containing_window instanceof Lino.DetailWrapper) {
    
    //~ console.log('20120121 initComponent', this.action_name);
    //~ if (this.action_name == 'detail' | this.action_name == 'show') {
    //~ if (this.action_name != 'insert') {
    if (! this.hide_top_toolbar) {
      this.tbar = [];
      // 20111015    
      if (! this.hide_navigator) {
        this.record_selector = new Lino.RemoteComboFieldElement({
          store: new Lino.ComplexRemoteComboStore({
            //~ baseParams: this.containing_window.config.base_params,
            baseParams: this.get_base_params(),
            //~ value: this.containing_window.config.base_params.query,
            proxy: new Ext.data.HttpProxy({
              url: '/choices' + this.ls_url,
              method:'GET'
            })
          }),
          pageSize:25,
          listeners: { 
            scope:this, 
            select:function(combo,record,index) {
              //~ console.log('jumpto_select',arguments);
              this.goto_record_id(record.id);
            }
          },
          emptyText: "Go to record"
        })
        this.tbar = this.tbar.concat([this.record_selector]);
        
        this.tbar = this.tbar.concat([
          this.first = new Ext.Toolbar.Button({
              tooltip:"First",disabled:true,
              handler:this.moveFirst,scope:this,iconCls:'x-tbar-page-first'}),
          this.prev = new Ext.Toolbar.Button({
              tooltip:"Previous",disabled:true,
              handler:this.movePrev,scope:this,iconCls:'x-tbar-page-prev'}),
          this.next = new Ext.Toolbar.Button({
              tooltip:"Next",disabled:true,
              handler:this.moveNext,scope:this,iconCls:'x-tbar-page-next'}),
          this.last = new Ext.Toolbar.Button({
              tooltip:"Last",disabled:true,
              handler:this.moveLast,scope:this,iconCls:'x-tbar-page-last'})
        ]);
      }
      this.tbar = this.add_params_panel(this.tbar);
      
      //~ console.log(20101117,this.containing_window.refresh);
      this.tbar = this.tbar.concat([
        {
          //~ text:'Refresh',
          handler:function(){ this.do_when_clean(false,this.refresh.createDelegate(this)) },
          iconCls: 'x-tbar-loading',
          tooltip:"Reload current record",
          scope:this}
      ]);
          
      if (this.bbar) { // since 20121016
        if (this.tbar) {
            this.tbar = this.tbar.concat(['-']) ;
        } else {
          this.tbar = [];
        }
        this.tbar = this.tbar.concat(this.bbar) ;
        this.bbar = undefined;
      }
    
      this.tbar = this.tbar.concat([
          '->',
          this.displayItem = new Ext.Toolbar.TextItem({})
      ]);
          
    }
    //~ if (this.content_type && this.action_name != 'insert') {
      //~ this.bbar = this.bbar.concat([
        //~ '->',
        //~ { text: "[$_('Help Text Editor')]",
          //~ handler: Lino.help_text_editor,
          //~ qtip: "$_('Edit help texts for fields on this model.')",
          //~ scope: this}
      //~ ])
    //~ }
    //~ this.before_row_edit = config.before_row_edit.createDelegate(this);
      
    //~ if (this.master_panel) {
        //~ this.set_base_params(this.master_panel.get_master_params());
    //~ }
      
    Lino.FormPanel.superclass.initComponent.call(this);

    // this.on('show',
    //         function(){ this.init_focus();}, 
    //         this);
    
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.bwrap,{msg:"Please wait..."});
    },this);
    
    
    if (this.action_name == 'insert') {
      this.cascade(function(cmp){
        // console.log('20110613 cascade',cmp);
        if (cmp.disabled_in_insert_window) {
            //~ cmp.disable();
            cmp.hide();
        }
      });
      
    }
    
  },
  
  unused_init_focus : function(){ 
    // set focus to the first field
    console.log("20140205 Lino.FormPanel.init_focus");
    // Lino.FormPanel.superclass.focus.call(this);
    this.getForm().items.each(function(f){
        if(f.isFormField && f.rendered){ 
            f.focus();
            console.log("20140205 focus", f);
            return false;
        }
    });
  },

  /* FormPanel */
  get_status : function(){
      var st = {
        base_params: this.get_base_params(),
        // data_record : this.get_current_record()
        }
      st.record_id = this.get_current_record().id;
      // 20140917 : get_status must not store the whole data_record
      // because that would prevent the form to actually reload
      // when set_status is called after a child window closed.
      
      var tp = this.items.get(0);
      if (tp instanceof Ext.TabPanel) {
        st.active_tab = tp.getActiveTab();
      }
      st.param_values = this.status_param_values;
      return st;
  },

  /* FormPanel */
  set_status : function(status, rp){
    this.requesting_panel = Ext.getCmp(rp);
    // console.log('20140917 FormPanel.set_status()', status);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_param_values(status.param_values);
    if (status.base_params) this.set_base_params(status.base_params);
    var tp = this.items.get(0);
    if (tp instanceof Ext.TabPanel) {
      if (status.active_tab) {
        //~ console.log('20111201 active_tab',this.active_tab,this.items.get(0));
        //~ tp.activeTab = status.active_tab;
        tp.setActiveTab(status.active_tab);
        //~ this.main_item.items.get(0).activate(status.active_tab);
      } else {
        if (! status.data_record) {  // 20141206
            tp.setActiveTab(0);
        }
      }
    }
    
    if (status.data_record) {
      /* defer because set_window_title() didn't work otherwise */
      // 20140421 removed defer for bughunting to simplify side effects
      // this.set_current_record.createDelegate(
      //     this, [status.data_record]).defer(100);
      this.set_current_record(status.data_record);
      //~ return;
    } else if (status.record_id != undefined) { 
      /* possible values include 0 and null, 0 being a valid record id, 
      null the equivalent of undefined
      */
      this.load_record_id(status.record_id);
    } else {
      this.set_current_record(undefined);
    }
    // this.init_focus()
  }
  ,get_base_params : function() {  /* FormPanel */
    // needed for insert_action
    var p = Ext.apply({}, this.base_params);
    Lino.insert_subst_user(p);
    return p;
  }
  ,set_base_params : function(p) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    delete p['query'] // 20120725
    Ext.apply(this.base_params,p);
    if (this.record_selector) {
        var store = this.record_selector.getStore();
        for (k in p) store.setBaseParam(k,p[k]);
        delete this.record_selector.lastQuery;
        //~ console.log("20120725 record_selector.setBaseParam",p)
    }
  }
  ,clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  }
  ,set_base_param : function(k,v) {
    this.base_params[k] = v;
  }
  ,after_delete : function() {
    if (this.current_record.navinfo.next)
      this.moveNext();
    else if (this.current_record.navinfo.prev)
      this.movePrev();
    else 
      this.abandon();
  }
  ,moveFirst : function() {this.goto_record_id(
      this.current_record.navinfo.first)}
  ,movePrev : function() {this.goto_record_id(
      this.current_record.navinfo.prev)}
  ,moveNext : function() {this.goto_record_id(
      this.current_record.navinfo.next)}
  ,moveLast : function() {this.goto_record_id(
      this.current_record.navinfo.last)}
  
  ,refresh : function(unused) { 
      this.refresh_with_after();
  }
  /* FormPanel */
  ,refresh_with_after : function(after) { 
    // console.log('20140917 Lino.FormPanel.refresh_with_after()',this);
    if (this.current_record) {
        this.load_record_id(this.current_record.id, after);
    } else {
        this.set_current_record(undefined, after);
    }
  }
  
  ,do_when_clean : function(auto_save, todo) {
    var this_ = this;
    if (this.form.isDirty()) {
        // console.log('20140421 do_when_clean : form is dirty')
        if (auto_save) {
            this_.save(todo);
        } else {
          //~ console.log('20111217 do_when_clean() form is dirty',this.form);
          var config = {title:"Confirmation"};
          config.buttons = Ext.MessageBox.YESNOCANCEL;
          config.msg = "Save changes to current record ?";
          config.fn = function(buttonId,text,opt) {
            //~ console.log('do_when_clean',buttonId)
            if (buttonId == "yes") {
                //~ Lino.submit_detail(this_,undefined,todo);
                //~ this_.containing_window.save(todo);
                this_.save(todo);
            } else if (buttonId == "no") { 
              todo();
            }
          }
        }
        Ext.MessageBox.show(config);
    }else{
      // console.log('20140421 do_when_clean : now!')
      todo();
    }
  }
  
  ,goto_record_id : function(record_id) {
    // console.log('20140917 Lino.FormPanel.goto_record_id()',record_id);
    //~ var this_ = this;
    //~ this.do_when_clean(function() { this_.load_record_id(record_id) }
    this.do_when_clean(
        true, this.load_record_id.createDelegate(this, [record_id]));
  }
  
  ,load_record_id : function(record_id, after) {
    var this_ = this;
    var p = Ext.apply({}, this.get_base_params());
    if (this.action_name)
        p.an = this.action_name;
    p.rp = this.getId();
    p.fmt = 'json';
    this.add_param_values(p);
    if (this.loadMask) this.loadMask.show();
    Ext.Ajax.request({ 
      waitMsg: 'Loading record...',
      method: 'GET',
      params: p,
      scope: this,
      url: this.get_record_url(record_id),
      success: function(response) {   
        // todo: convert to Lino.action_handler.... but result 
        if (this.loadMask) this.loadMask.hide();
        if (response.responseText) {
          var rec = Ext.decode(response.responseText);
          // console.log('20140917 load_record_id success', rec);
          this.set_param_values(rec.param_values);
          this.set_current_record(rec, after);
        }
      },
      failure: Lino.ajax_error_handler(this)
    });
  }

  ,abandon : function () {
    Ext.MessageBox.alert('Note',
      "No more records to display. Detail window has been closed.");
    Lino.close_window();
  }
  
  ,set_current_record : function(record, after) {
    if (this.record_selector) {
        this.record_selector.clearValue();
        // e.g. InsertWrapper FormPanel doesn't have a record_selector
    }
    this.current_record = record;
    if (record) {
      this.enable();
      this.form.my_loadRecord(record.data);
      this.set_window_title(record.title);
      //~ this.getBottomToolbar().enable();
      var da = record.data.disabled_actions;
      if (da) {
          //~ console.log('20120528 disabled_actions =',da,this.getBottomToolbar());
          //~ 20121016 this.getBottomToolbar().items.each(function(item,index,length){
          var tb = this.getTopToolbar();
          if (tb) tb.items.each(function(item,index,length){
              //~ console.log('20120528 ',item.itemId,'-->',da[item.itemId]);
              if (da[item.itemId]) item.disable(); else item.enable();
          });
      };
      if (this.disable_editing | record.data.disable_editing) {
          //~ console.log("20120202 disable_editing",record.title);
          this.form.items.each(function(cmp){
            if (!cmp.always_enabled) cmp.disable();
          },this);
      } else {
          this.form.items.each(function(cmp){
            //~ console.log("20120202",cmp);
            if (record.data.disabled_fields[cmp.name]) cmp.disable();
            else cmp.enable();
          },this);
        
          //~ if (record.data.disabled_fields) {
              //~ for (i = 0; i < record.data.disabled_fields.length; i++) {
                  //~ var flds = this.find('name',record.data.disabled_fields[i]);
                  //~ if (flds.length == 1) { 
                    //~ flds[0].disable(); 
                  //~ }
              //~ }
          //~ }
      };
      if (this.first) {
        if (record.navinfo  && ! this.hide_navigator) {
          this.first.setDisabled(!record.navinfo.first);
          this.prev.setDisabled(!record.navinfo.prev);
          this.next.setDisabled(!record.navinfo.next);
          this.last.setDisabled(!record.navinfo.last);
          this.displayItem.setText(record.navinfo.message);
        } else {
          this.first.setDisabled(true);
          this.prev.setDisabled(true);
          this.next.setDisabled(true);
          this.last.setDisabled(true);
        }
      }
    } else {
      if (this.form.rendered) 
        this.form.reset(); /* FileUploadField would fail when resetting a non-rendered form */
      //~ this.disable();
      //~ this.getBottomToolbar().disable();
      this.form.items.each(function(cmp){
        cmp.disable();
      },this);
      this.set_window_title(this.empty_title);
      //~ this.containing_window.window.setTitle(this.empty_title);
      if (!this.hide_navigator) {
        this.first.disable();
        this.prev.disable();
        this.next.disable();
        this.last.disable();
      }
    }
    // console.log('20140917 gonna call before_row_edit', record);
    this.before_row_edit(record);
    // console.log('20140917 gonna call after', after);
    if (after) after();
  },
  
  /* FormPanel */
  before_row_edit : function(record) {},
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.refresh();
  },
  
  get_selected : function() { return [ this.current_record ] },
  get_current_record : function() {  
    //~ console.log(20100714,this.current_record);
    return this.current_record 
  },
  
  get_permalink_url : function() {
      var rec = this.get_current_record();
      if (rec && ! rec.phantom && rec.id != -99998)
          return '/api' 
              + this.ls_url + '/' + rec.id;
      return '/api' + this.ls_url;
    
  },
  add_param_tab : function(p) {
    var main = this.items.get(0);
    if (main.activeTab) {
      var tab = main.items.indexOf(main.activeTab);
      //~ console.log('main.activeTab',tab,main.activeTab);
      if (tab) p.tab = tab;
    }
  },
  get_permalink_params : function() {
    var p = {};
    //~ var p = {an:'detail'};
    if (this.action_name)
        p.an = this.action_name;
    this.add_param_tab(p)
    this.add_param_values(p)
    return p;
  }
  
  ,validate_form : function() {  // not used. see actions.ValidateForm
      // var ov = {};
      // this.form.items.each(function(f){
      //     ov[f.name] = f.originalValue
      // });

      // console.log('20140509 FormPanel.validate_form', ov);
      // var after = function() { 
      //     this.form.items.each(function(f){
      //         f.originalValue = ov[f.name];
      //     });
      // }
      // this.save2(null, 'validate', after);
      this.save2(null, 'validate');
  }

  /* Lino.FormPanel */
  ,save : function(after) {
    var action_name = this.save_action_name;
    if (!action_name) 
        action_name = this.action_name;
    // console.log('20140503 FormPanel.save', action_name);
    this.save2(after, action_name);
  }

  ,save2 : function(after, action_name) {
    var rec = this.get_current_record();
    if (!rec) { 
        Lino.notify("Sorry, no current record."); 
        return; 
    }
    var panel = this;
    if (this.has_file_upload) this.form.fileUpload = true;
    //~ console.log('FormPanel.save()',rec);
    this.loadMask.show();
    var p = {};
    Ext.apply(p, this.get_base_params());
    p.rp = this.getId();
    p.an = action_name;
    this.add_param_tab(p)
    var submit_config = {
        params: p, 
        scope: this,
        success: function(form, action) {
          this.loadMask.hide();
          Lino.notify(action.result.message);
          Lino.handle_action_result(this, action.result, after);
        },
        failure: function(form,action) { 
          this.loadMask.hide();
          Lino.on_submit_failure(form, action);
        },
        clientValidation: true
    };
    if (rec.phantom) {  // it's a new record
      Ext.apply(submit_config, {
        url: '/api' + this.ls_url,
        method: 'POST'
      });
    } else {  // submit on existing row
      Ext.apply(submit_config, {
        url: '/api' 
              + this.ls_url + '/' + rec.id,
        method: 'PUT'
      })
    }
    this.form.submit(submit_config);
  }
  
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
      // console.log("20140424");
      // this.save(null, true, this.save_action_name);
      this.save();
  }
  ,config_containing_window : function(wincfg) { 

      // Note that defaultButton means: which component should receive
      // focus when Window is focussed.  If no defaultButton set,
      // specify the first form field.

      if (!wincfg.defaultButton) this.getForm().items.each(function(f){
          if(f.isFormField){ 
              wincfg.defaultButton = f;
              // console.log("20140205 defaultButton", f);
              return false;
          }
      });

      wincfg.keys = [
          {
              key: Ext.EventObject.ENTER,
              scope:this,
              fn: function(k, e) {
                  if(e.target.type === 'textarea' && !e.ctrlKey) {
                      return true;
                  }
                  this.on_ok();
              }
          },
          { key: Ext.EventObject.ESCAPE, fn: this.on_cancel, scope:this }
          // ,{ key: 's', ctrl: true, 
          //    stopEvent: true,
          //    fn: this.on_ctrl_s, scope:this }
      ]
  }
  
});



Lino.getRowClass = function(record, rowIndex, rowParams, store) {
    //~ console.log(20130816,record);
    //~ return 'x-grid3-row-green';
    //~ return record.data.row_class + ' auto-height';
    return record.data.row_class;
  //~ if (true) {
      //~ return 'x-grid3-row-red';
  //~ }
  //~ if (record.phantom) {
    //~ console.log(20101009,record);
    //~ rowParams.bodyStyle = "color:red;background-color:blue";
    //~ return 'lino-phantom-row';
    //~ }
  //~ console.log('20101009 not a phantom:',record);
  //~ return '';
}

//~ FOO = 0;



Lino.GridStore = Ext.extend(Ext.data.ArrayStore,{ 
  autoLoad: false
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
    if (!options) options = {};
    if (!options.params) options.params = {};
    options.params.fmt = 'json';
    options.params.rp = this.grid_panel.getId();
    Lino.insert_subst_user(options.params); // since 20121016
      
    var start = this.grid_panel.start_at_bottom ? -1 : 0;
    if (this.grid_panel.hide_top_toolbar) {
        //~ console.log("20120206 GridStore.load() toolbar is hidden");
        options.params.start = start;
        if (this.grid_panel.preview_limit) {
          options.params.limit = this.grid_panel.preview_limit;
        }
    } else {
        var ps = this.grid_panel.calculatePageSize();
        if (!ps) {
          // console.log("GridStore.load() failed to calculate pagesize");
          return false;
        } 
        options.params.limit = ps;
      
        this.grid_panel.getTopToolbar().pageSize =  ps;
        if (options.params.start == undefined)
            // if (start != -1) 
            //     start = this.grid_panel.getTopToolbar().cursor
            options.params.start = start;
      
        // console.log("20141108 GridStore.load() ", options.params);
    }
      
    this.grid_panel.add_param_values(options.params);
    //~ Lino.insert_subst_user(options.params);
    //~ console.log("20120814 GridStore.load()",options.params,this.baseParams);
    return Lino.GridStore.superclass.load.call(this, options);
  }
  // ,insert : function(index, records) {
  //   return Ext.data.Store.prototype.insert.call(this, index, records)
    // return Lino.GridStore.superclass.insert.call(this, index, records);
  // }
});

Lino.get_current_grid_config = function(panel) {
    return panel.get_current_grid_config();
}


// Like the default value for GridView.cellTpl but adds a class "lino-auto-height"
Lino.auto_height_cell_template = new Ext.Template(
'<td class="x-grid3-col x-grid3-cell x-grid3-td-{id} {css}" style="{style}" tabIndex="0" {cellAttr}>',
    '<div class="lino-auto-height x-grid3-cell-inner x-grid3-col-{id}" unselectable="on" {attr}>{value}</div>',
'</td>'
);

Lino.GridPanel = Ext.extend(Ext.grid.EditorGridPanel, Lino.MainPanel);
Lino.GridPanel = Ext.extend(Lino.GridPanel, Lino.PanelMixin);
Lino.GridPanel = Ext.extend(Lino.GridPanel, {
  quick_search_text : '',
  start_at_bottom : false,
  is_searching : false,
  disabled_in_insert_window : true,
  clicksToEdit:2,
  enableColLock: false,
  autoHeight: false,
  params_panel_hidden : false,
  preview_limit : undefined, 
  //~ loadMask: true,
  //~ viewConfig: {
          //~ getRowClass: Lino.getRowClass,
          //~ emptyText:"$_('No data to display.')"
        //~ },
        
        
  loadMask: {msg:"Please wait..."},
  
  constructor : function(config){

    config.plugins = [new Lino.GridFilters()];
    
    
    Lino.GridPanel.superclass.constructor.call(this,config);
    
    //~ if (this.containing_window) {
        //~ console.log("20111206 install refresh");
        //~ this.containing_window.on('show',this.refresh,this);
    //~ }
    
  },
  
  init_containing_window : function(win) { 
    //~ console.log("20111206 install refresh");
    //~ win.on('show',this.refresh,this);
  }

  ,handle_key_event : function(e) { 
    // console.log("20140514 handle_key_event", e, this.keyhandlers);
    var h = this.keyhandlers[e.keyCode];
    if (h) {
      h(this);
      e.stopEvent();
    }
  }
  
  ,initComponent : function(){
    
    /* 
    Problem 20111206:
    When a GridPanel is the main item of the window, then it doesn't 
    have it's own header but uses the window's header bar.
    We must do this in initComponent because e.g. in beforerender 
    it's already to late: a header element has been created because 
    there was a title.
    But Lino.Window adds itself as `this.containing_window` 
    only after the GridPanel has been initialized.
    Workaround is to generate a line "params.containing_window = true;" 
    in the handler function.
    */ 
    if (this.is_main_window) {
        //~ console.log(20111206, 'delete title',this.title,'from',this);
        this.tools = undefined;  
        this.title = undefined;  /* simply deleting it 
          isn't enough because that would only 
          unhide the title defined in some base class. */
    } 
    //~ else console.log(20111206, 'dont delete title',this.title,'from',this);
    
    /* e.g. when slave gridwindow called from a permalink */
    //~ if (this.base_params) Ext.apply(bp,this.base_params);  
    
    var proxy = new Ext.data.HttpProxy({ 
      // 20120814 
      url: '/api' + this.ls_url
      ,method: "GET"
      //~ ,url: ADMIN_URL + '/restful' + this.ls_url
      //~ ,restful: true 
      //~ ,listeners: {load:on_proxy_load} 
      //~ ,listeners: {write:on_proxy_write} 
    });
    //~ config.store = new Ext.data.JsonStore({ 
    //~ this.store = new Ext.data.ArrayStore({ 
    this.store = new Lino.GridStore({ 
      grid_panel: this
      ,listeners: { exception: Lino.on_store_exception }
      ,remoteSort: true
      ,totalProperty: "count"
      ,root: "rows"
      //~ ,id: "id" 
      ,proxy: proxy
      //~ autoLoad: this.containing_window ? true : false
      ,idIndex: this.pk_index
      //~ ,baseParams: bp
      ,fields: this.ls_store_fields
      ,idProperty: this.ls_id_property 
      // 20120814
      //~ ,writer : new Ext.data.JsonWriter({
        //~ writeAllFields: false
        //~ ,listful: true
      //~ })
      //~ ,restful : true
    });
      
    //~ console.log('config.pk_index',config.pk_index,config.store),
    delete this.ls_store_fields;
      
    var this_ = this;
    //~ var grid = this;
    this.store.on('load', function() {
        //~ console.log('20120814 GridStore.on(load)',this_.store);
        this_.set_param_values(this_.store.reader.arrayData.param_values);
        //~ this_.set_status(this_.store.reader.arrayData.status);
        //~ 20120918
        this.getView().getRowClass = Lino.getRowClass;
        
        if (this_.store.reader.arrayData.no_data_text) {
            //~ this.viewConfig.emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().refresh();
        }
        if (this_.containing_window)
            this_.set_window_title(this_.store.reader.arrayData.title);
            //~ this_.containing_window.setTitle(this_.store.reader.arrayData.title);
        if (!this.is_searching) { // disabled 20121025: quick_search_field may not lose focus
          this.is_searching = false;
          if (this_.selModel.getSelectedCell){
              if (this_.getStore().getCount()) // there may be no data
                  this_.selModel.select(0,0); 
          } else {
              this_.selModel.selectFirstRow();
              this_.getView().focusEl.focus();
          }
        } 
        //~ else console.log("is_searching -> no focussing");
        //~ var t = this.getTopToolbar();
        //~ var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
        //~ this.quick_search_field.focus(); // 20121024
      }, this
    );
    var actions = Lino.build_buttons(this, this.ls_bbar_actions);
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar, this.cmenu = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ this.cmenu = new Ext.menu.Menu({items: config.bbar});
    delete this.ls_bbar_actions
    if (actions) {
        this.cmenu = actions.cmenu;
        this.keyhandlers = actions.keyhandlers;
    }
    
    if (!this.hide_top_toolbar) {  
      var tbar = [ 
        this.quick_search_field = new Ext.form.TextField({ 
          //~ fieldLabel: "Search"
          listeners: { 
            scope:this_
            //~ ,change:this_.search_change
            
            ,render: Lino.quicktip_renderer("Quick Search","Enter a text to use as quick search filter")
            
            //~ ,keypress: this.search_keypress 
            ,blur: function() { this.is_searching = false}
          }
          ,validator:function(value) { return this_.search_validate(value) }
          //~ ,tooltip: "Enter a quick search text, then press TAB"
          //~ value: text
          //~ scope:this, 
          //~ ,enableKeyEvents: true
          //~ listeners: { keypress: this.search_keypress }, 
          //~ id: "seachString" 
      })];
      tbar = this.add_params_panel(tbar);
      var menu = [];
      var set_gc = function(index) {
        return function() {
          //~ console.log('set_gc() 20100812');
          this.getColumnModel().setConfig(
              this.apply_grid_config(index,this.ls_grid_configs,this.ls_columns));
        }
      }
      for (var i = 0; i < this.ls_grid_configs.length;i++) {
        var gc = this.ls_grid_configs[i];
        menu.push({text:gc.label,handler:set_gc(i),scope:this})
      }
      if(menu.length > 1) {
        tbar = tbar.concat([
          { text:"View",
            menu: menu,
            tooltip:"Select another view of this report"
          }
        ]);
      }
      
      if (actions) {
        tbar = tbar.concat(actions.bbar);
          //~ this.bbar = actions.bbar;
      }
      
      this.tbar = new Ext.PagingToolbar({ 
        store: this.store, 
        prependButtons: true, 
        //~ pageSize: this.page_length, 
        pageSize: 1, 
        displayInfo: true, 
        beforePageText: "Page",
        afterPageText: "of {0}",
        displayMsg: "Displaying {0} - {1} of {2}",
        firstText: "First page",
        lastText: "Last page",
        prevText: "Previous page",
        nextText: "Next page",
        items: tbar
      });
    }
      
    if (this.cell_edit) {
      this.selModel = new Ext.grid.CellSelectionModel()
      this.get_selected = function() {
        //~ console.log(this.getSelectionModel().selection);
        if (this.selModel.selection)
            return [ this.selModel.selection.record ];
        return [this.store.getAt(0)];
      };
      this.get_current_record = function() { 
        if (this.getSelectionModel().selection) 
          return this.selModel.selection.record;
        return this.store.getAt(0);
      };
    } else { 
      this.selModel = new Ext.grid.RowSelectionModel() 
      this.get_selected = function() {
        var sels = this.selModel.getSelections();
        if (sels.length == 0) sels = [this.store.getAt(0)];
        return sels
      };
      this.get_current_record = function() { 
        var rec = this.selModel.getSelected();
        if (rec == undefined) rec = this.store.getAt(0);
        return rec
      };
    };
    this.columns  = this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns);
    
    Lino.GridPanel.superclass.initComponent.call(this);
    
    this.on('resize', function(){
      //~ console.log("20120213 resize",arguments)
      this.refresh();
      },this);
    this.on('viewready', function(){
      //~ console.log("20120213 resize",arguments);
      this.view_is_ready = true;
      this.refresh(); // removed 20130911
      },this);
    this.on('afteredit', this.on_afteredit); // 20120814
    this.on('beforeedit', this.on_beforeedit);
    this.on('beforeedit',function(e) { this.before_row_edit(e.record)},this);
    if (this.cell_edit) {
        this.on('cellcontextmenu', Lino.cell_context_menu, this);
    } else {
        this.on('rowcontextmenu', Lino.row_context_menu, this);
    }
    //~ this.on('contextmenu', Lino.grid_context_menu, this);
    
    delete this.cell_edit;
    
  },
  
  //~ onResize : function(){
      //~ console.log("20120206 GridPanel.onResize",arguments);
      //~ Lino.GridPanel.superclass.onResize.apply(this, arguments);
      //~ this.refresh();
  //~ },
  
  
  get_status : function(){
    var st = { base_params : this.get_base_params()};
    if (!this.hide_top_toolbar) {
        st.current_page = this.getTopToolbar().current;
    }
    st.param_values = this.status_param_values;
    //~ console.log("20120213 GridPanel.get_status",st);
    return st;
  },
  
  /* 
  Lino.GridPanel.set_status() 
  */
  set_status : function(status, rp){
    this.requesting_panel = Ext.getCmp(rp);
    // console.log("20140527 GridPanel.set_status", status);
    this.clear_base_params();
    if (status == undefined) status = {base_params:{}};
    this.set_param_values(status.param_values);
    if (status.base_params) { 
      this.set_base_params(status.base_params);
    }
    if (status.show_params_panel != undefined) {
        if (this.toggle_params_panel_btn) {
            //~ this.toggle_params_panel_btn.toggle(status.show_params_panel=='true');
            this.toggle_params_panel_btn.toggle(status.show_params_panel);
        }
    }
    if (!this.hide_top_toolbar) {
      //~ console.log("20120213 GridPanel.getTopToolbar().changePage",
          //~ status.current_page || 1);
      this.getTopToolbar().changePage(status.current_page || 1);
    }
    //~ this.fireEvent('resize');
    //~ this.refresh.defer(100,this); 
    //~ this.onResize.defer(100,this); 
    //~ this.refresh(); 
    //~ this.doLayout(); 
    //~ this.onResize(); 
    //~ this.store.load();
  },
  
  refresh : function(unused) { 
    this.refresh_with_after();
  },
  /* GridPanel */
  refresh_with_after : function(after) { 
    // console.log('20140504 Lino.GridPanel.refresh '+ this.store.proxy.url);
    //~ var bp = { fmt:'json' }
    if (! this.view_is_ready) return;
    
    if (this.containing_panel) {
        //~ Ext.apply(p,this.master_panel.get_master_params());
        //~ Ext.apply(options.params,this.containing_panel.get_master_params());
        this.set_base_params(this.containing_panel.get_master_params());
        // 20130911
        if (!this.store.baseParams.mk) {  
            return;
        }
    }
    
    //~ console.log('20130911 Lino.GridPanel.refresh_with_after',this.containing_panel.get_master_params());
    
    var options = {};
    if (after) {
        options.callback = function(r,options,success) {if(success) after()}
    }
      
    //~ if (!this.rendered) {
        //~ console.log("20120206 GridPanel.refresh() must wait until rendered",options);
        //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
        //~ return;
    //~ }
    
    this.store.load(options);
  },
  
  /* pageSize depends on grid height (Trying to remove scrollbar)
  Thanks to 
  - Christophe Badoit on http://www.sencha.com/forum/showthread.php?82647
  - http://www.sencha.com/forum/archive/index.php/t-37231.html
  */
  calculatePageSize : function(second_attempt) {
    //~ if (!this.rendered) { 
    if (!this.view_is_ready) { 
      //~ console.log('Cannot calculatePageSize() : not rendered');
      return false; }
    //~ if (!this.isVisible()) { 
      //~ console.log('calculatePageSize : not visible');
      //~ return false; }
      
    //~ console.log('getFrameHeight() is',this.getFrameHeight());
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('mainBody.getHeight() is',this.getView().mainBody.getHeight());
    //~ console.log('getInnerHeight() is',this.getInnerHeight());
    //~ console.log('getHeight() is',this.getHeight());
    //~ console.log('el.getHeight() is',this.getEl().getHeight());
    //~ console.log('getGridEl().getHeight() is',this.getGridEl().getHeight());
    //~ console.log('getOuterSize().height is',this.getOuterSize().height);
    //~ console.log('getBox().height is',this.getBox().height);
    //~ console.log('getResizeEl.getHeight() is',this.getResizeEl().getHeight());
    //~ console.log('getLayoutTarget().getHeight() is',this.getLayoutTarget().getHeight());
      
    //~ var rowHeight = 52; // experimental value
    var row = this.view.getRow(0);
    if (row) {
      //~ console.log('20120213 yes');
      var rowHeight = Ext.get(row).getHeight();
    } else {
        //~ var rowHeight = this.getFrameHeight();
        //~ var rowHeight = 10; // reasonably smallest approximative value
        //~ There is no data yet. Construct a fake row and get its height
        var Element = Ext.Element;
        var gv = this.view;
        var fakeBody = new Element(Element.fly(gv.scroller).child('div.x-grid3-body'));
        var rowTemplate = gv.templates.row;
        var cellTemplate = gv.templates.cell;
        var tstyle  = 'width:' + gv.getGridInnerWidth() + 'px;';
        var cells = cellTemplate.apply({value:'&#160;'});
        var markup = rowTemplate.apply({
                tstyle: tstyle,
                cols  : 1,
                cells : cells,
                alt   : ''
            });        
        fakeBody.dom.innerHTML = gv.templates.body.apply({rows: markup});
        var row = fakeBody.dom.childNodes[0];
        var rowHeight = Ext.get(row).getHeight();
    }
    //~ console.log('rowHeight is ',rowHeight,this,caller);
    //~ this.getView().syncScroll();
    //~ this.getView().initTemplates();
    var height = this.getView().scroller.getHeight();
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('getInnerHeight() - getFrameHeight() is',
      //~ this.getInnerHeight(), '-',
      //~ this.getFrameHeight(), '=',
      //~ this.getInnerHeight() - this.getFrameHeight());
    //~ var height = this.getView().mainBody.getHeight();
    //~ var height = this.getView().mainWrap.getHeight();
    //~ var height = this.getView().resizeMarker.getHeight();
    //~ this.syncSize();
    //~ var height = this.getInnerHeight() - this.getFrameHeight();
    //~ var height = this.getHeight() - this.getFrameHeight();
    height -= Ext.getScrollBarWidth(); // leave room for a possible horizontal scrollbar... 
    //~ height -= this.getView().scrollOffset;
    var ps = Math.floor(height / rowHeight);
    //~ console.log('20130816 calculatePageSize():',height,'/',rowHeight,'->',ps);
    ps -= 1; // leave room for a possible phantom row
    //~ return (ps > 1 ? ps : false);
    if (ps > 1) return ps;
    //~ console.log('calculatePageSize() found less than 1 row:',height,'/',rowHeight,'->',ps);
    //~ foo.bar = baz; // 20120213
    return 5; // preview_limit
    //~ if (second_attempt) {
        //~ console.log('calculatePageSize() abandons after second attempt:',
          //~ height,'/',rowHeight,'->',ps);
      //~ return 5;
    //~ }
    //~ return this.calculatePageSize.defer(500,this,[true]);
  },
  
  onCellDblClick : function(grid, row, col){
      //~ console.log("20120307 onCellDblClick",this,grid, row, col);
      if (this.ls_detail_handler) {
          //~ Lino.notify('show detail');
          Lino.show_detail(this);
          return false;
      }else{
        //~ console.log('startEditing');
        this.startEditing(row,col);
      }
  }
  ,get_base_params : function() {  /* Lino.GridPanel */
    var p = Ext.apply({}, this.store.baseParams);
    Lino.insert_subst_user(p);
    return p;
  },
  set_base_params : function(p) {
    //~ console.log('20130911 GridPanel.set_base_params',p)
    for (k in p) this.store.setBaseParam(k,p[k]);
    //~ this.store.baseParams = p;
    if (this.quick_search_field)
      this.quick_search_field.setValue(p.query || "");
    //~ if (p.param_values) 
        //~ this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.store.baseParams = {};
      Lino.insert_subst_user(this.store.baseParams);
  },
  set_base_param : function(k,v) {
    this.store.setBaseParam(k,v);
  },
  
  //~ get_permalink_params : function() {
    //~ var p = {};
    //~ return p;
  //~ },
  
  before_row_edit : function(record) {},
    
  //~ search_keypress : function(){
    //~ console.log("2012124 search_keypress",arguments);
  //~ },
  search_validate : function(value) {
    if (value == this.quick_search_text) return true;
    this.is_searching = true;
    //~ console.log('search_validate',value)
    this.quick_search_text = value;
    this.set_base_param('query',value); 
    //~ this.getTopToolbar().changePage(1);
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
    return true;
  },
  
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
  },
  
  apply_grid_config : function(index,grid_configs,rpt_columns) {
    //~ var rpt_columns = this.ls_columns;
    var gc = grid_configs[index];    
    //~ console.log('apply_grid_config() 20100812',name,gc);
    this.gc_name = index;
    if (gc == undefined) {
      return rpt_columns;
      //~ config.columns = config.ls_columns;
      //~ return;
    } 
    //~ delete config.ls_filters
    
    //~ console.log(20100805,config.ls_columns);
    var columns = Array(gc.columns.length);
    for (var j = 0; j < rpt_columns.length;j++) {
      var col = rpt_columns[j];
      for (var i = 0; i < gc.columns.length; i++) {
        if (col.dataIndex == gc.ci[i]) {
          col.width = gc.cw[i];
          col.hidden = gc.ch[i];
          columns[i] = col;
          break;
        }
      }
    }
    
    //~ var columns = Array(rpt_columns.length);
    //~ for (var i = 0; i < rpt_columns.length; i++) {
      //~ columns[i] = rpt_columns[gc.columns[i]];
      //~ columns[i].width = gc.widths[i];
    //~ }
    
    //~ if (gc.hidden_cols) {
      //~ for (var i = 0; i < gc.hidden_cols.length; i++) {
        //~ var hc = gc.hidden_cols[i];
        //~ for (var j = 0; j < columns.length;j++) {
          //~ var col = columns[j];
          //~ if (col.dataIndex == hc) {
            //~ col.hidden = true;
            //~ break
          //~ }
        //~ }
      //~ }
    //~ }
    if (gc.filters) {
      //~ console.log(20100811,'config.ls_filters',config.ls_filters);
      //~ console.log(20100811,'config.ls_grid_config.filters',config.ls_grid_config.filters);
      for (var i = 0; i < gc.filters.length; i++) {
        var fv = gc.filters[i];
        for (var j = 0; j < columns.length;j++) {
          var col = columns[j];
          if (col.dataIndex == fv.field) {
            //~ console.log(20100811, f,' == ',fv);
            if (fv.type == 'string') {
              col.filter.value = fv.value;
              //~ if (fv.comparison !== undefined) f.comparison = fv.comparison;
            } else {
              //~ console.log(20100811, fv);
              col.filter.value = {};
              col.filter.value[fv.comparison] = fv.value;
            }
            break;
          }
        };
      }
    }
    
    return columns;
    //~ config.columns = cols;
    //~ delete config.ls_columns
  },
  
  get_current_grid_config : function () {
    var cm = this.getColumnModel();
    var widths = Array(cm.config.length);
    var hiddens = Array(cm.config.length);
    //~ var hiddens = Array(cm.config.length);
    var columns = Array(cm.config.length);
    //~ var columns = Array(cm.config.length);
    //~ var hidden_cols = [];
    //~ var filters = this.filters.getFilterValues();
    var p = this.filters.buildQuery(this.filters.getFilterData())
    for (var i = 0; i < cm.config.length; i++) {
      var col = cm.config[i];
      columns[i] = col.dataIndex;
      //~ hiddens[i] = col.hidden;
      widths[i] = col.width;
      hiddens[i] = col.hidden;
      //~ if (col.hidden) hidden_cols.push(col.dataIndex);
    }
    //~ p['hidden_cols'] = hidden_cols;
    p.cw = widths;
    p.ch = hiddens;
    p.ci = columns;
    //~ p['widths'] = widths;
    //~ p['hiddens'] = hiddens;
    //~ p['columns'] = columns;
    p['name'] = this.gc_name;
    //~ var gc = this.ls_grid_configs[this.gc_name];
    //~ if (gc !== undefined) 
        //~ p['label'] = gc.label
    //~ console.log('20100810 save_grid_config',p);
    return p;
  },
  
  unused_manage_grid_configs : function() {
    var data = [];
    for (k in this.ls_grid_configs) {
      var v = this.ls_grid_configs[k];
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i)
    }
    if (this.ls_grid_configs[this.gc_name] == undefined) {
      var v = this.get_current_grid_config();
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i);
    }
    //~ console.log(20100811, data);
    var main = new Ext.grid.GridPanel({
      store: new Ext.data.ArrayStore({
        idIndex:0,
        fields:['name','columns','hidden_cols','filters'],
        autoDestroy:true,
        data: data}),
      //~ autoHeight:true,
      selModel: new Ext.grid.RowSelectionModel(),
      listeners: { 
        rowdblclick: function(grid,rowIndex,e) {
          console.log('row doubleclicked',grid, rowIndex,e);
        },
        rowclick: function(grid,rowIndex,e) {
          console.log('row clicked',grid, rowIndex,e);
        }
      },
      columns: [ 
        {dataIndex:'name',header:'Name'}, 
        {dataIndex:'columns',header:'columns'}, 
        {dataIndex:'hidden_cols',header:'hidden columns'}, 
        {dataIndex:'filters',header:'filters'} 
      ]
    });
    var win = new Ext.Window({title:'GridConfigs Manager',layout:'fit',items:main,height:200});
    win.show();
  },
  
  unused_edit_grid_config : function(name) {
    gc = this.ls_grid_configs[name];
    var win = new Ext.Window({
      title:'Edit Grid Config',layout:'vbox', 
      //~ layoutConfig:'stretch'
      items:[
        {xtype:'text', value: gc.name},
        {xtype:'text', value: gc.columns},
        {xtype:'text', value: gc.hidden_cols},
        {xtype:'text', value: gc.filters}
      ]
    });
    win.show();
  },
  
  unused_save_grid_config : function () {
    //~ console.log('TODO: save_grid_config',this);
    //~ p.column_widths = Ext.pluck(this.colModel.columns,'width');
    var a = { 
      params:this.get_current_grid_config(), 
      method:'PUT',
      url:'/grid_config' + this.ls_url,
      success: Lino.action_handler(this),
      scope: this,
      failure: Lino.ajax_error_handler(this)
    };
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(a);
    //~ Lino.do_action(this,a);
  },
  
  on_beforeedit : function(e) {
    //~ console.log('20130128 GridPanel.on_beforeedit()',e,e.record.data.disable_editing);
    if(this.disable_editing | e.record.data.disable_editing) {
      e.cancel = true;
      Lino.notify("This record is disabled");
      return;
    }
    if(e.record.data.disabled_fields && e.record.data.disabled_fields[e.field]) {
      e.cancel = true;
      Lino.notify("This field is disabled");
      return;
    }
    //~ if (e.record.data.disabled_fields) {
      //~ for (i in e.record.data.disabled_fields) {
        //~ if(e.record.data.disabled_fields[i] == e.field) {
          //~ e.cancel = true;
          //~ Lino.notify(String.format('Field "{0}" is disabled for this record',e.field));
          //~ return
        //~ }
      //~ }
    //~ }
  },
  save_grid_data : function() {
      //~ console.log("20120814 save_grid_data");
      this.getStore().commitChanges();
  },
  on_afteredit : function(e) {
    /*
    e.grid - The grid that fired the event
    e.record - The record being edited
    e.field - The field name being edited
    e.value - The value being set
    e.originalValue - The original value for the field, before the edit.
    e.row - The grid row index
    e.column - The grid column index
    */
    var p = {};
    // console.log('20140403 afteredit: ',e.record);
    //~ console.log('20101130 value: ',e.value);
    //~ var p = e.record.getChanges();
    //~ console.log('20101130 getChanges: ',e.record.getChanges());
    //~ this.before_row_edit(e.record);

    for(k in e.record.getChanges()) {
        var v = e.record.get(k);
    //~ for(k in e.record.modified) {
        //~ console.log('20101130',k,'=',v);
        //~ var cm = e.grid.getColumnModel();
        //~ var di = cm.getDataIndex(k);
        var f = e.record.fields.get(k);
        //~ console.log('20101130 f = ',f);
        //~ var v = e.record.get(di);
        if (f.type.type == 'date') {
            p[k] = Ext.util.Format.date(v, f.dateFormat);
        }else{
            p[k] = v;
            var v = e.record.get(k+'Hidden');
            if (v !== undefined) {
              p[k+'Hidden'] = v;
            }
        }
    }
    // add value used by ForeignKeyStoreField CHOICES_HIDDEN_SUFFIX
    // not sure whether this is still needed:
    p[e.field+'Hidden'] = e.value;
    //~ p.su = Lino.subst_user;
    Lino.insert_subst_user(p);
    // this one is needed so that this field can serve as choice context:
    e.record.data[e.field+'Hidden'] = e.value;
    // p[pk] = e.record.data[pk];
    // console.log("grid_afteredit:",e.field,'=',e.value);
    Ext.apply(p, this.get_base_params()); // needed for POST, ignored for PUT
    //~ Ext.apply(p,this.containing_window.config.base_params);
    //~ 20121109 p['$ext_requests.URL_PARAM_ACTION_NAME'] = 'grid';
    var self = this;
    var req = {
        params:p,
        waitMsg: 'Saving your data...',
        success: Lino.action_handler( this, function(result) {
          // console.log("20140728 afteredit.success got ", result);
          //~ if (result.data_record) {
          if (result.refresh_all) {
              var cw = self.get_containing_window();
              if (cw) {
                  cw.main_item.refresh();
              }
              else console.log("20120123 cannot refresh_all",self);
          } else if (result.rows) {
              //~ self.getStore().loadData(result,true);
              var r = self.getStore().reader.readRecords(result);
              if (e.record.phantom) {
                  // console.log("20140728 gonna call Store.insert()", self.getStore(), e.row, r.records);
                  self.getStore().insert(e.row, r.records);
              }else{
                  // console.log("20140728 afteredit.success doUpdate", r.records[0]);
                  self.getStore().doUpdate(r.records[0]);
              }
              self.getStore().rejectChanges(); 
              /* 
              get rid of the red triangles without saving the record again
              */
              //~ self.getStore().commitChanges(); // get rid of the red triangles
          } else {
              self.getStore().commitChanges(); // get rid of the red triangles
              self.getStore().reload();        // reload our datastore.
          }
          }),
        scope: this,
        failure: Lino.ajax_error_handler(this)
    };
    if (e.record.phantom) {
      req.params.an = 'grid_post'; // CreateRow.action_name
      Ext.apply(req,{
        method: 'POST',
        url: '/api' + this.ls_url
      });
    } else {
      req.params.an = 'grid_put'; // SaveRow.action_name
      Ext.apply(req,{
        method: 'PUT',
        url: '/api' + this.ls_url + '/' + e.record.id
      });
    }
    //~ console.log('20110406 on_afteredit',req);
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(req);
  },

  afterRender : function() {
    Lino.GridPanel.superclass.afterRender.call(this);
    // this.getView().mainBody.focus();
    // console.log(20100114,this.getView().getRows());
    // if (this.getView().getRows().length > 0) {
    //  this.getView().focusRow(1);
    // }
    //~ this.my_load_mask = new Ext.LoadMask(this.getEl(), {
        //~ msg:'$_("Please wait...")',
        //~ store:this.store});
      
    var tbar = this.getTopToolbar();
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    // tbar.on('change',function() {this.getSelectionModel().selectFirstRow();this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    this.nav = new Ext.KeyNav(this.getEl(),{
      pageUp: function() {tbar.movePrevious(); },
      pageDown: function() {tbar.moveNext(); },
      home: function() {tbar.moveFirst(); },
      end: function() {tbar.moveLast(); },
      scope: this
    });

  },
  after_delete : function() {
    //~ console.log('Lino.GridPanel.after_delete');
    this.refresh();
  },
  add_row_listener : function(fn,scope) {
    this.getSelectionModel().addListener('rowselect',fn,scope);
  },
  postEditValue : function(value, originalValue, r, field){
    value = Lino.GridPanel.superclass.postEditValue.call(this,value,originalValue,r,field);
    //~ console.log('GridPanel.postEdit()',value, originalValue, r, field);
    return value;
  },
  
  set_start_value : function(v) {
      this.start_value = v;
  },
  preEditValue : function(r, field){
      if (this.start_value) {
        var v = this.start_value;
        delete this.start_value;
        this.activeEditor.selectOnFocus = false;
        return v;
      }
      var value = r.data[field];
      return this.autoEncode && Ext.isString(value) ? Ext.util.Format.htmlDecode(value) : value;
  },
  
  on_master_changed : function() {
    //~ if (! this.enabled) return;
    //~ cmp = this;
    //~ console.log('20130911 Lino.GridPanel.on_master_changed()',this.title,this.rendered);
    if (! this.rendered) return; // 20120213
    var todo = function() {
      if (this.disabled) return;
      //~ if (this.disabled) return;
      //~ if (this.enabled) {
          //~ var src = caller.config.url_data + "/" + record.id + ".jpg"
          //~ console.log(20111125, this.containing_window);
          //~ for (k in p) this.getStore().setBaseParam(k,p[k]);
          //~ console.log('Lino.GridPanel.on_master_changed()',this.title,p);
          this.refresh();
          //~ this.set_base_params(this.master_panel.get_master_params());
          //~ this.getStore().load(); 
      //~ }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  },
  load_record_id : function(record_id,after) {
      Lino.run_detail_handler(this,record_id)
  }
  
});
  

//~ Lino.MainPanelMixin = {
  //~ tbar_items : function() {
      //~ return ;
  //~ }
//~ };

//~ Ext.override(Lino.GridPanel,Lino.MainPanelMixin);
//~ Ext.override(Lino.FormPanel,Lino.MainPanelMixin);

//~ Lino.grid_context_menu = function(e) {
  //~ console.log('contextmenu',arguments);
//~ }

Lino.row_context_menu = function(grid,row,col,e) {
  console.log('20130927 rowcontextmenu',grid,row,col,e,grid.store.reader.arrayData.rows[row]);
}

Lino.cell_context_menu = function(grid,row,col,e) {
  //~ console.log('20120531 cellcontextmenu',grid,row,col,e,grid.store.reader.arrayData.rows[row]);
  e.stopEvent();
  //~ grid.getView().focusCell(row,col);
  grid.getSelectionModel().select(row,col);
  //~ console.log(grid.store.getAt(row));
  //~ grid.getView().focusRow(row);
  //~ return;
  if(!grid.cmenu.el){grid.cmenu.render(); }
  //~ if(e.record.data.disabled_fields) {
  
  var da = grid.store.reader.arrayData.rows[row][grid.disabled_actions_index];
  if (da) {
      this.cmenu.cascade(function(item){ 
        //~ console.log(20120531, item.itemId, da[item.itemId]);
        if (da[item.itemId]) item.disable(); else item.enable();
      });
  };
  
  var xy = e.getXY();
  xy[1] -= grid.cmenu.el.getHeight();
  grid.cmenu.showAt(xy);
}


Lino.chooser_handler = function(combo,name) {
  return function(cmp,newValue,oldValue) {
    //~ console.log('Lino.chooser_handler()',cmp,oldValue,newValue);
    combo.setContextValue(name,newValue);
  }
};



Lino.ComboBox = Ext.extend(Ext.form.ComboBox,{
  forceSelection: "yes but select on tab",
  // forceSelection: true,
  triggerAction: 'all',
  minListWidth:280, // 20131022
  autoSelect: false,
  selectOnFocus: true, // select any existing text in the field immediately on focus.
  submitValue: true,
  displayField: 'text', // 'text', 
  valueField: 'value', // 'value',
  
  //~ initComponent : Ext.form.ComboBox.prototype.initComponent.createSequence(function() {
  initComponent : function(){
      this.contextParams = {};
      //~ Ext.form.ComboBox.initComponent(this);
      Lino.ComboBox.superclass.initComponent.call(this);
  },
  setValue : function(v,record_data){
      /*
      Based on feature request developed in http://extjs.net/forum/showthread.php?t=75751
      */
      /* `record_data` is used to get the text corresponding to this value */
      //~ if(this.name == 'city') 
      //~ console.log('20120203', this.name,'.setValue(', v ,') this=', this,'record_data=',record_data);
      var text = v;
      if(this.valueField){
        if(v == null || v == '') { 
            //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,'no lookup needed, value is empty');
            //~ v = undefined;
            v = '';
            //~ text = '';
        } else if (Ext.isDefined(record_data)) {
          text = record_data[this.name];
          //~ if (this.name == 'birth_country') 
            //~ console.log(this.name,'.setValue',v,'got text ',text,' from record ',record);
        } else {
          // if(this.mode == 'remote' && !Ext.isDefined(this.store.totalLength)){
          if(this.mode == 'remote' && ( this.lastQuery === null || (!Ext.isDefined(this.store.totalLength)))){
              //~ if (this.name == 'birth_country') console.log(this.name,'.setValue',v,'store not yet loaded');
              this.store.on('load', this.setValue.createDelegate(this, arguments), null, {single: true});
              if(this.store.lastOptions === null || this.lastQuery === null){
                  var params;
                  if(this.valueParam){
                      params = {};
                      params[this.valueParam] = v;
                  }else{
                      var q = this.allQuery;
                      this.lastQuery = q;
                      this.store.setBaseParam(this.queryParam, q);
                      params = this.getParams(q);
                  }
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : call load() with params ',params);
                  this.store.load({params: params});
              //~ }else{
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : but store is loading',this.store.lastOptions);
              }
              return;
          //~ }else{
              //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,' : store is loaded, lastQuery is "',this.lastQuery,'"');
          }
          var r = this.findRecord(this.valueField, v);
          if(r){
              text = r.data[this.displayField];
          }else if(this.valueNotFoundText !== undefined){
              text = this.valueNotFoundText;
          }
        }
      }
      this.lastSelectionText = text;
      //~ this.lastSelectionText = v;
      if(this.hiddenField){
          //~ this.hiddenField.originalValue = v;
          this.hiddenField.value = v;
      }
      Ext.form.ComboBox.superclass.setValue.call(this, text);
      this.value = v; // needed for grid.afteredit
  },
  
  getParams : function(q){
    // p = Ext.form.ComboBox.superclass.getParams.call(this, q);
    // causes "Ext.form.ComboBox.superclass.getParams is undefined"
    var p = {};
    if(this.pageSize){
        p['start'] = 0;
        p['limit'] = this.pageSize;
    }
    // now my code:
    if(this.contextParams) Ext.apply(p, this.contextParams);
    return p;
  },
  setContextValue : function(name,value) {
    //~ console.log('setContextValue',this,this.name,':',name,'=',value);
    //~ if (this.contextValues === undefined) {
        //~ this.contextValues = Array(); // this.contextParams.length);
    //~ }
    if (this.contextParams[name] != value) {
      //~ console.log('setContextValue 1',this.contextParams);
      this.contextParams[name] = value;
      this.lastQuery = null;
      //~ console.log('setContextValue 2',this.contextParams);
    }
  }
});

Lino.ChoicesFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'local'
});


Lino.SimpleRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  // forceSelection: true,  20140206 why was this here?
  constructor: function(config){
      Lino.SimpleRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value' ], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.ComplexRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  constructor: function(config){
      Lino.ComplexRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value','text'], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.RemoteComboFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'remote',
  //~ forceSelection:false,
  minChars: 2, // default 4 is too much
  queryDelay: 300, // default 500 is maybe slow
  queryParam: 'query', 
  //~ typeAhead: true,
  //~ selectOnFocus: true, // select any existing text in the field immediately on focus.
  resizable: true
  ,initList : function() {
      Lino.RemoteComboFieldElement.superclass.initList.call(this);
      if (this.pageTb) {
          
          var me = this;
          this.pageTb.on("beforechange", function(toolbar, o){
              if(me.contextParams)
                  Ext.apply(o, me.contextParams);
          });
          
          //~ 
          //~ var btn = ls_buttons
          //~ this.pageTb.items = this.pageTb.items.concat([btn]);
          //~ console.log("20131022 pageTb.items is", this.pageTb.items)
      }
  }
});

/*
Thanks to Animal for posting the basic idea:
http://www.sencha.com/forum/showthread.php?15842-2.0-SOLVED-Combobox-twintrigger-clear&p=76130&viewfull=1#post76130

*/
Lino.TwinCombo = Ext.extend(Lino.RemoteComboFieldElement,{
    trigger2Class : 'x-form-search-trigger',
    //~ trigger2Class : 'x-tbar-detail',
    initComponent : function() {
        //~ Lino.TwinCombo.superclass.initComponent.call(this);
        Lino.ComboBox.prototype.initComponent.call(this);
        Ext.form.TwinTriggerField.prototype.initComponent.call(this);
    },
    onTrigger2Click : function() {
        //~ console.log('onTrigger2Click',this,arguments);
    }
  });
//~ Lino.TwinCombo.prototype.initComponent = Ext.form.TwinTriggerField.prototype.initComponent;
Lino.TwinCombo.prototype.getTrigger = Ext.form.TwinTriggerField.prototype.getTrigger;
Lino.TwinCombo.prototype.getOuterSize = Ext.form.TwinTriggerField.prototype.getOuterSize;
Lino.TwinCombo.prototype.initTrigger = Ext.form.TwinTriggerField.prototype.initTrigger;
Lino.TwinCombo.prototype.onTrigger1Click = Ext.form.ComboBox.prototype.onTriggerClick;
//~ Lino.TwinCombo.prototype.onTrigger2Click = function() {
    //~ console.log('onTrigger2Click',arguments);
//~ };



Lino.SimpleRemoteComboFieldElement = Ext.extend(Lino.RemoteComboFieldElement,{
  displayField: 'value', 
  valueField: null,
  forceSelection: false
});




Lino.Window = Ext.extend(Ext.Window,{
  //~ layout: "fit", 
  closeAction : 'hide',
  renderTo: 'main_area', 
  constrain: true,
  maximized: true,
  draggable: false,
  width: 700,
  height: 500,
  maximizable: false,
  constructor : function (config) {
    if (config.main_item.params_panel) {
        config.layout = 'border';
        config.main_item.region = 'center';
        config.main_item.params_panel.region = 'north';
        //~ config.main_item.params_panel.autoHeight = false; // 20130924
        config.main_item.params_panel.hidden = config.main_item.params_panel_hidden;
        config.items = [config.main_item.params_panel, config.main_item];
        //~ 20130923b
    } else {
        config.layout = 'fit';
        config.items = config.main_item;
    }
    this.main_item = config.main_item; 
    
    delete config.main_item;
    //~ delete config.params_item;
    
    //~ this.main_item = config.items.get(0);
    this.main_item.containing_window = this;
    
    //~ console.log('20120110 Lino.Window.constructor() 1');
    //~ if (Lino.current_window) { // all windows except the top are closable
    if (this.main_item.hide_window_title) { 
      config.closable = false;
      config.frame = false;
      config.shadow = false;
      //~ config.border = true;
      //~ config.title = undefined;
      //~ config.tools = null;
      delete config.title;
      delete config.tools;
    } else {
      config.title = this.main_item.empty_title;
      config.closable = true;
      config.tools = [ 
        { qtip: 'permalink', handler: Lino.permalink_handler(this), id: "pin" }
      ];
      if (this.main_item.content_type && this.main_item.action_name != 'insert') {
        config.tools = [ {
          handler: Lino.help_text_editor,
          qtip: "Edit help texts for fields on this model.",
          scope: this.main_item,
          id: "gear"
        }].concat(config.tools);
      }
        
    //~ { qtip: '', handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: this.config.qtip, handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: 'Call doLayout() on main Container.', handler: Lino.refresh_handler(this), id: "refresh" },
    //~ if (this.main_item.params_panel) {
        //~ config.tools = config.tools.concat([ 
          //~ { qtip: 'Show/hide parameter panel', handler: this.toggle_params_panel, id: "gear", scope:this } 
        //~ ]);
    //~ }
    //~ if (config.closable !== false) {
      // if undefined, will take default behaviour
      //~ config.tools = config.tools.concat([ 
        //~ { qtip: 'close', handler: this.hide, id: "close", scope:this } 
      //~ ]);
    }
    
    this.main_item.config_containing_window(config);
    
    //~ console.log('20120110 Lino.Window.constructor() 2');
    Lino.Window.superclass.constructor.call(this,config);
    
    //~ console.log('20120110 Lino.Window.constructor() 3');
    
  },
  initComponent : function() {
    this.main_item.init_containing_window(this);
    Lino.Window.superclass.initComponent.call(this);
  
  },
  hide : function() { 
      this.main_item.do_when_clean(false,function() { 
        Lino.close_window(); });
  },
  hide_really : function() { 
    Lino.Window.superclass.hide.call(this);
  },
  onRender : function(ct, position){
    // console.log('20140829 Lino.Window.onRender() 1');
    Lino.Window.superclass.onRender.call(this, ct, position);
    var main_area = Ext.getCmp('main_area')
    //~ console.log('20120110 Lino.Window.onRender() 2');
  
    this.on('show', function(win) {
        // console.log('20140829 Lino.Window.on(show) : add resize handler');
        main_area.on('resize', win.onWindowResize, win);
    });
    this.on('hide', function(win) {
        // console.log('20140829 Lino.Window.on(hide) : remove resize handler');
        main_area.un('resize', win.onWindowResize, win);
    });
    // console.log('20140829 Lino.Window.onRender() 3');
  }
});


Ext.override(Ext.form.BasicForm,{
    my_loadRecord : function(values){
    //~ loadRecord : function(record){
        /* Same as ExtJS's loadRecord() (setValues()), except that we 
        forward also the record to field.setValue() so that Lino.Combobox 
        can use it. 
        */
        //~ console.log('20120918 my_loadRecord',values)
        if(Ext.isArray(values)){ 
            for(var i = 0, len = values.length; i < len; i++){
                var v = values[i];
                var f = this.findField(v.id);
                if(f){
                    f.setValue(v.value,values);
                    if(this.trackResetOnLoad){
                        f.originalValue = f.getValue();
                    }
                }
            }
        }else{ 
            var field, id;
            for(id in values){
                if(!Ext.isFunction(values[id]) && (field = this.findField(id))){
                    field.setValue(values[id],values);
                    if(this.trackResetOnLoad){
                        field.originalValue = field.getValue();
                        //~ if (field.hiddenField) {
                          //~ field.hiddenField.originalValue = field.hiddenField.value;
                        //~ }
                    }
                }
            }
        }
        return this;
    }
});




function initializeFooBarDropZone(cmp) {
    //~ console.log('initializeFooBarDropZone',cmp);
    cmp.dropTarget = new Ext.dd.DropTarget(cmp.bwrap, {
      //~ ddGroup     : 'gridDDGroup',
      notifyEnter : function(ddSource, e, data) {
        console.log('notifyEnter',ddSource,e,data);
        //Add some flare to invite drop.
        cmp.body.stopFx();
        cmp.body.highlight();
      },
      notifyDrop  : function(ddSource, e, data){
        console.log('notifyDrop',ddSource,e,data);
        // Reference the record (single selection) for readability
        //~ var selectedRecord = ddSource.dragData.selections[0];


        // Load the record into the form
        //~ formPanel.getForm().my_loadRecord(selectedRecord);


        // Delete record from the grid.  not really required.
        //~ ddSource.grid.store.remove(selectedRecord);

        return(true);
      }
    })
}



Lino.show_mti_child = function(fieldname,detail_handler) {
  //~ console.log('show_mti_child',this);
  //~ console.log('show_mti_child',panel.find("main_area"));
  rec = Lino.current_window.main_item.get_current_record();
  //~ rec = panel.get_current_record();
  if (rec) {
    //~ console.log('show_mti_child',Lino.current_window,rec);
    if (rec.phantom) {
      Lino.notify('Not allowed on phantom record.');
    }else if (rec.data[fieldname]) {
      //~ console.log('show_mti_child',rec.id);
      //~ detail_handler(Lino.current_window.main_item,{},{record_id:rec.id});
      detail_handler.run(null,{record_id:rec.id});
      //~ window.open(urlroot + '/' + rec.id);
      //~ document.location = urlroot + '/' + rec.id;
      //~ window.open(urlroot + '/' + rec.id,'_blank');
    } else {
      Lino.alert("Cannot show MTI child if checkbox is off.");
    }
  } else {
    Lino.notify('No current record.');
  }
};


/*
captureEvents utility by Aaron Conran
<http://www.sencha.com/learn/grid-faq/>

Ext.onReady(function(){
    var grid = new Ext.grid.GridPanel({
        ... 
    });
    captureEvents(grid);
});
*/
function captureEvents(observable) {
    Ext.util.Observable.capture(
        observable,
        function(eventName) {
            console.info(eventName);
        },
        this
    );		
}

// settings.SITE.get_plugin_snippets()




// from lino.modlib.iban:iban/uppercasetextfield.js

Lino.UppercaseTextField = Ext.extend(Ext.form.TextField,{
  style: 'text-transform:uppercase;',
  listeners:{
    change: function(field, newValue, oldValue){
      // console.log("20140403 UppercaseTextField",newValue, newValue.toUpperCase());
      field.setRawValue(newValue.toUpperCase());
    }
  }
});


Lino.iban_renderer = function(
    value, metaData, record, rowIndex, colIndex, store) 
{
    var reg = new RegExp(".{4}", "g");
    if(value) {
        return value.replace(reg, function (a) { return a + ' '; });
    }
    return value;
}



Lino.main_menu = [ { "menu": { "items": [ { "text": "My Excerpts", "handler": function() {Lino.excerpts.MyExcerpts.grid.run(null)} }, { "text": "My Outbox", "handler": function() {Lino.outbox.MyOutbox.grid.run(null)} }, { "text": "My Uploads", "handler": function() {Lino.uploads.MyUploads.grid.run(null)} }, { "text": "My Notes", "handler": function() {Lino.notes.MyNotes.grid.run(null)} } ] }, "text": "Office" }, { "menu": { "items": [ { "text": "Persons", "handler": function() {Lino.contacts.Persons.grid.run(null)} }, { "text": "Organisations", "handler": function() {Lino.contacts.Companies.grid.run(null)} }, { "text": "Partners", "handler": function() {Lino.contacts.Partners.grid.run(null)} }, { "text": "Households", "handler": function() {Lino.households.Households.grid.run(null)} } ] }, "text": "Contacts" }, { "menu": { "items": [ { "text": "Appointments today", "handler": function() {Lino.cal.EventsByDay.grid.run(null)} }, { "text": "Waiting visitors", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows the visitors in the waiting room.") }, "handler": function() {Lino.reception.WaitingVisitors.grid.run(null)} }, { "text": "Busy visitors", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows the visitors who are busy with some agent.") }, "handler": function() {Lino.reception.BusyVisitors.grid.run(null)} }, { "text": "Gone visitors", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows the visitors who have gone.") }, "handler": function() {Lino.reception.GoneVisitors.grid.run(null)} }, { "text": "Visitors waiting for me", "handler": function() {Lino.reception.MyWaitingVisitors.grid.run(null)} } ] }, "text": "Reception" }, { "menu": { "items": [ { "text": "My Projects", "handler": function() {Lino.projects.MyProjects.grid.run(null)} } ] }, "text": "Projects" }, { "menu": { "items": [ { "text": "My events", "listeners": { "render": Lino.quicktip_renderer("Foo","Table of all my calendar events.") }, "handler": function() {Lino.cal.MyEvents.grid.run(null)} }, { "text": "My tasks", "listeners": { "render": Lino.quicktip_renderer("Foo","Table of all my tasks.") }, "handler": function() {Lino.cal.MyTasks.grid.run(null)} }, { "text": "My guests", "handler": function() {Lino.cal.MyGuests.grid.run(null)} }, { "text": "My presences", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows all my presences in calendar events, independently of their state.") }, "handler": function() {Lino.cal.MyPresences.grid.run(null)} } ] }, "text": "Calendar" }, { "menu": { "items": [ { "text": "Nodes", "handler": function() {Lino.pages.Pages.grid.run(null)} } ] }, "text": "Pages" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "Stale Controllables", "handler": function() {Lino.contenttypes.StaleControllables.grid.run(null)} } ] }, "text": "System" } ] }, "text": "Reports" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "Help Texts", "handler": function() {Lino.contenttypes.HelpTexts.grid.run(null)} }, { "text": "Site Parameters", "iconCls": "x-tbar-application_form", "handler": function() {Lino.system.SiteConfigs.detail.run(null,{ "record_id": 1 })} }, { "text": "Users", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows the list of all users on this site.") }, "handler": function() {Lino.users.Users.grid.run(null)} } ] }, "text": "System" }, { "menu": { "items": [ { "text": "My Text Field Templates", "handler": function() {Lino.system.MyTextFieldTemplates.grid.run(null)} }, { "text": "Excerpt Types", "handler": function() {Lino.excerpts.ExcerptTypes.grid.run(null)} }, { "text": "Upload Types", "handler": function() {Lino.uploads.UploadTypes.grid.run(null)} }, { "text": "Note Types", "handler": function() {Lino.notes.NoteTypes.grid.run(null)} }, { "text": "Event Types", "handler": function() {Lino.notes.EventTypes.grid.run(null)} } ] }, "text": "Office" }, { "menu": { "items": [ { "text": "Countries", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    A country is a geographic entity considered a \"nation\".\n    ") }, "handler": function() {Lino.countries.Countries.grid.run(null)} }, { "text": "Places", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    The table of known geographical places.\n    A geographical place can be a city, a town, a suburb,\n    a province, a lake... any named geographic entity,\n    except for countries because these have their own table.\n    ") }, "handler": function() {Lino.countries.Places.grid.run(null)} } ] }, "text": "Places" }, { "menu": { "items": [ { "text": "Organization types", "handler": function() {Lino.contacts.CompanyTypes.grid.run(null)} }, { "text": "Functions", "handler": function() {Lino.contacts.RoleTypes.grid.run(null)} }, { "text": "Household Types", "handler": function() {Lino.households.Types.grid.run(null)} } ] }, "text": "Contacts" }, { "menu": { "items": [ { "text": "Project Types", "handler": function() {Lino.projects.ProjectTypes.grid.run(null)} } ] }, "text": "Projects" }, { "menu": { "items": [ { "text": "Calendars", "handler": function() {Lino.cal.Calendars.grid.run(null)} }, { "text": "Rooms", "listeners": { "render": Lino.quicktip_renderer("Foo","List of rooms where calendar events can happen.") }, "handler": function() {Lino.cal.Rooms.grid.run(null)} }, { "text": "Priorities", "listeners": { "render": Lino.quicktip_renderer("Foo","List of possible priorities of calendar events.") }, "handler": function() {Lino.cal.Priorities.grid.run(null)} }, { "text": "Recurrent Events", "handler": function() {Lino.cal.RecurrentEvents.grid.run(null)} }, { "text": "Guest Roles", "listeners": { "render": Lino.quicktip_renderer("Foo","The role of a guest expresses what the partner is going to do there.") }, "handler": function() {Lino.cal.GuestRoles.grid.run(null)} }, { "text": "Event Types", "listeners": { "render": Lino.quicktip_renderer("Foo","The list of Event Types defined on this system.\n    An EventType is a list of events which have certain things in common,\n    especially they are displayed in the same colour in the calendar panel") }, "handler": function() {Lino.cal.EventTypes.grid.run(null)} }, { "text": "Remote Calendars", "handler": function() {Lino.cal.RemoteCalendars.grid.run(null)} } ] }, "text": "Calendar" } ] }, "text": "Configure" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "content types", "handler": function() {Lino.contenttypes.ContentTypes.grid.run(null)} }, { "text": "Authorities", "handler": function() {Lino.users.Authorities.grid.run(null)} }, { "text": "User Groups", "handler": function() {Lino.users.UserGroups.grid.run(null)} }, { "text": "User Levels", "handler": function() {Lino.users.UserLevels.grid.run(null)} }, { "text": "User Profiles", "handler": function() {Lino.users.UserProfiles.grid.run(null)} }, { "text": "Changes", "handler": function() {Lino.changes.Changes.grid.run(null)} } ] }, "text": "System" }, { "menu": { "items": [ { "text": "Text Field Templates", "handler": function() {Lino.system.TextFieldTemplates.grid.run(null)} }, { "text": "Excerpts", "handler": function() {Lino.excerpts.Excerpts.grid.run(null)} }, { "text": "Outgoing Mails", "handler": function() {Lino.outbox.Mails.grid.run(null)} }, { "text": "Attachments", "handler": function() {Lino.outbox.Attachments.grid.run(null)} }, { "text": "Uploads", "handler": function() {Lino.uploads.Uploads.grid.run(null)} }, { "text": "Upload Areas", "handler": function() {Lino.uploads.UploadAreas.grid.run(null)} }, { "text": "Notes", "handler": function() {Lino.notes.Notes.grid.run(null)} } ] }, "text": "Office" }, { "menu": { "items": [ { "text": "Contact Persons", "handler": function() {Lino.contacts.Roles.grid.run(null)} }, { "text": "Address types", "handler": function() {Lino.addresses.AddressTypes.grid.run(null)} }, { "text": "Addresses", "handler": function() {Lino.addresses.Addresses.grid.run(null)} }, { "text": "Personal Links", "handler": function() {Lino.humanlinks.Links.grid.run(null)} }, { "text": "Parency types", "handler": function() {Lino.humanlinks.LinkTypes.grid.run(null)} }, { "text": "Roles", "handler": function() {Lino.households.MemberRoles.grid.run(null)} }, { "text": "Household Members", "handler": function() {Lino.households.Members.grid.run(null)} } ] }, "text": "Contacts" }, { "menu": { "items": [ { "text": "Accounts", "handler": function() {Lino.sepa.Accounts.grid.run(null)} } ] }, "text": "SEPA" }, { "menu": { "items": [ { "text": "Projects", "handler": function() {Lino.projects.Projects.grid.run(null)} } ] }, "text": "Projects" }, { "menu": { "items": [ { "text": "Tasks", "listeners": { "render": Lino.quicktip_renderer("Foo","A calendar task is something you need to do.\n    ") }, "handler": function() {Lino.cal.Tasks.grid.run(null)} }, { "text": "Participants", "listeners": { "render": Lino.quicktip_renderer("Foo","A guest is a partner invited to an event. ") }, "handler": function() {Lino.cal.Guests.grid.run(null)} }, { "text": "Subscriptions", "handler": function() {Lino.cal.Subscriptions.grid.run(null)} }, { "text": "Event states", "listeners": { "render": Lino.quicktip_renderer("Foo","The possible states of a calendar event.") }, "handler": function() {Lino.cal.EventStates.grid.run(null)} }, { "text": "Guest states", "handler": function() {Lino.cal.GuestStates.grid.run(null)} }, { "text": "Task states", "handler": function() {Lino.cal.TaskStates.grid.run(null)} } ] }, "text": "Calendar" } ] }, "text": "Explorer" }, { "menu": { "items": [ { "text": "About", "listeners": { "render": Lino.quicktip_renderer("Foo","Show information about this site.") }, "handler": function() {Lino.about.About.show.run(null,{ "record_id": -99998 })} } ] }, "text": "Site" }, { "text": "Home", "handler": function() {Lino.handle_home_button()} } ];
Ext.namespace('Lino.contenttypes.ContentTypes')
Ext.namespace('Lino.contenttypes.HelpTexts')
Ext.namespace('Lino.system.SiteConfigs')
Ext.namespace('Lino.system.TextFieldTemplates')
Ext.namespace('Lino.changes.Changes')
Ext.namespace('Lino.users.Users')
Ext.namespace('Lino.users.MySettings')
Ext.namespace('Lino.users.UsersOverview')
Ext.namespace('Lino.users.Authorities')
Ext.namespace('Lino.countries.Countries')
Ext.namespace('Lino.countries.Places')
Ext.namespace('Lino.outbox.Recipients')
Ext.namespace('Lino.outbox.Mails')
Ext.namespace('Lino.outbox.Attachments')
Ext.namespace('Lino.excerpts.ExcerptTypes')
Ext.namespace('Lino.excerpts.Excerpts')
Ext.namespace('Lino.excerpts.ExcerptsByX')
Ext.namespace('Lino.uploads.UploadTypes')
Ext.namespace('Lino.uploads.Uploads')
Ext.namespace('Lino.uploads.AreaUploads')
Ext.namespace('Lino.contacts.CompanyTypes')
Ext.namespace('Lino.contacts.Partners')
Ext.namespace('Lino.contacts.RoleTypes')
Ext.namespace('Lino.contacts.Roles')
Ext.namespace('Lino.addresses.Addresses')
Ext.namespace('Lino.contacts.Persons')
Ext.namespace('Lino.contacts.Companies')
Ext.namespace('Lino.cal.RemoteCalendars')
Ext.namespace('Lino.cal.Rooms')
Ext.namespace('Lino.cal.Priorities')
Ext.namespace('Lino.cal.Calendars')
Ext.namespace('Lino.cal.Subscriptions')
Ext.namespace('Lino.cal.Tasks')
Ext.namespace('Lino.cal.MyTasks')
Ext.namespace('Lino.cal.GuestRoles')
Ext.namespace('Lino.cal.Guests')
Ext.namespace('Lino.cal.MyPresences')
Ext.namespace('Lino.cal.MyPendingPresences')
Ext.namespace('Lino.cal.MyGuests')
Ext.namespace('Lino.cal.EventTypes')
Ext.namespace('Lino.cal.RecurrentEvents')
Ext.namespace('Lino.cal.Events')
Ext.namespace('Lino.cal.EventsByDay')
Ext.namespace('Lino.cal.OneEvent')
Ext.namespace('Lino.cal.MyEvents')
Ext.namespace('Lino.cal.MyAssignedEvents')
Ext.namespace('Lino.reception.ExpectedGuests')
Ext.namespace('Lino.reception.BusyVisitors')
Ext.namespace('Lino.reception.WaitingVisitors')
Ext.namespace('Lino.reception.GoneVisitors')
Ext.namespace('Lino.reception.MyWaitingVisitors')
Ext.namespace('Lino.reception.MyBusyVisitors')
Ext.namespace('Lino.reception.MyGoneVisitors')
Ext.namespace('Lino.sepa.Accounts')
Ext.namespace('Lino.notes.NoteTypes')
Ext.namespace('Lino.notes.EventTypes')
Ext.namespace('Lino.notes.Notes')
Ext.namespace('Lino.notes.NotesByX')
Ext.namespace('Lino.projects.ProjectTypes')
Ext.namespace('Lino.projects.Projects')
Ext.namespace('Lino.humanlinks.Links')
Ext.namespace('Lino.households.Types')
Ext.namespace('Lino.households.Households')
Ext.namespace('Lino.households.Members')
Ext.namespace('Lino.pages.Pages')
Ext.namespace('Lino.sessions.SessionTable')
Ext.namespace('Lino.system.MyTextFieldTemplates')
Ext.namespace('Lino.users.AuthoritiesGiven')
Ext.namespace('Lino.users.AuthoritiesTaken')
Ext.namespace('Lino.countries.PlacesByPlace')
Ext.namespace('Lino.countries.PlacesByCountry')
Ext.namespace('Lino.outbox.RecipientsByMail')
Ext.namespace('Lino.outbox.MyOutbox')
Ext.namespace('Lino.outbox.MailsByUser')
Ext.namespace('Lino.outbox.MailsByProject')
Ext.namespace('Lino.outbox.SentByPartner')
Ext.namespace('Lino.outbox.AttachmentsByMail')
Ext.namespace('Lino.excerpts.MyExcerpts')
Ext.namespace('Lino.excerpts.ExcerptsByType')
Ext.namespace('Lino.excerpts.ExcerptsByProject')
Ext.namespace('Lino.uploads.UploadsByType')
Ext.namespace('Lino.uploads.MyUploads')
Ext.namespace('Lino.contacts.PartnersByCity')
Ext.namespace('Lino.contacts.PartnersByCountry')
Ext.namespace('Lino.contacts.RolesByCompany')
Ext.namespace('Lino.contacts.RolesByPerson')
Ext.namespace('Lino.addresses.AddressesByPartner')
Ext.namespace('Lino.cal.SubscriptionsByUser')
Ext.namespace('Lino.cal.SubscriptionsByCalendar')
Ext.namespace('Lino.cal.TasksByUser')
Ext.namespace('Lino.cal.TasksByProject')
Ext.namespace('Lino.cal.GuestsByEvent')
Ext.namespace('Lino.cal.GuestsByRole')
Ext.namespace('Lino.cal.GuestsByPartner')
Ext.namespace('Lino.cal.EventsByType')
Ext.namespace('Lino.cal.EventsByRoom')
Ext.namespace('Lino.cal.EventsByProject')
Ext.namespace('Lino.reception.AppointmentsByPartner')
Ext.namespace('Lino.sepa.AccountsByPartner')
Ext.namespace('Lino.notes.MyNotes')
Ext.namespace('Lino.notes.NotesByType')
Ext.namespace('Lino.notes.NotesByEventType')
Ext.namespace('Lino.notes.NotesByProject')
Ext.namespace('Lino.notes.NotesByCompany')
Ext.namespace('Lino.notes.NotesByPerson')
Ext.namespace('Lino.projects.MyProjects')
Ext.namespace('Lino.humanlinks.LinksByHuman')
Ext.namespace('Lino.households.HouseholdsByType')
Ext.namespace('Lino.households.MembersByHousehold')
Ext.namespace('Lino.households.SiblingsByPerson')
Ext.namespace('Lino.households.MembersByPerson')
Ext.namespace('Lino.contenttypes.HelpTextsByModel')
Ext.namespace('Lino.notes.NotesByOwner')
Ext.namespace('Lino.uploads.UploadsByController')
Ext.namespace('Lino.cal.TasksByController')
Ext.namespace('Lino.outbox.MailsByController')
Ext.namespace('Lino.changes.ChangesByMaster')
Ext.namespace('Lino.outbox.AttachmentsByController')
Ext.namespace('Lino.cal.EventsByController')
Ext.namespace('Lino.excerpts.ExcerptsByOwner')
Ext.namespace('Lino.about.Models')
Ext.namespace('Lino.about.FieldsByModel')
Ext.namespace('Lino.about.Inspector')
Ext.namespace('Lino.about.SourceFiles')
Ext.namespace('Lino.contenttypes.StaleControllables')
Ext.namespace('Lino.contenttypes.StaleControllablesByModel')
Ext.namespace('Lino.lino.Report')
Ext.namespace('Lino.about.About')
Ext.namespace('Lino.cal.DurationUnits')
Ext.namespace('Lino.uploads.UploadAreas')
Ext.namespace('Lino.cal.TaskStates')
Ext.namespace('Lino.addresses.DataSources')
Ext.namespace('Lino.users.UserLevels')
Ext.namespace('Lino.cal.Weekdays')
Ext.namespace('Lino.outbox.RecipientTypes')
Ext.namespace('Lino.excerpts.Shortcuts')
Ext.namespace('Lino.lino.YesNo')
Ext.namespace('Lino.cal.EventStates')
Ext.namespace('Lino.cal.Recurrencies')
Ext.namespace('Lino.lino.BuildMethods')
Ext.namespace('Lino.cal.EventEvents')
Ext.namespace('Lino.households.MemberRoles')
Ext.namespace('Lino.cal.GuestStates')
Ext.namespace('Lino.addresses.AddressTypes')
Ext.namespace('Lino.users.UserGroups')
Ext.namespace('Lino.lino.ChangeTypes')
Ext.namespace('Lino.humanlinks.LinkTypes')
Ext.namespace('Lino.cal.AccessClasses')
Ext.namespace('Lino.users.UserProfiles')
Ext.namespace('Lino.lino.Genders')
Ext.namespace('Lino.countries.PlaceTypes')
Ext.namespace('Lino.lino.PeriodEvents')

// ChoiceLists: 
Lino.cal.DurationUnits = [ [ "s", "seconds" ], [ "m", "minutes" ], [ "h", "hours" ], [ "D", "days" ], [ "W", "weeks" ], [ "M", "months" ], [ "Y", "years" ] ];
Lino.uploads.UploadAreas = [ [ "90", "Uploads" ] ];
Lino.cal.TaskStates = [ [ "10", "To do" ], [ "20", "Started" ], [ "30", "Done" ], [ "50", "Cancelled" ] ];
Lino.addresses.DataSources = [ [ "01", "Manually entered" ], [ "02", "Read from eID" ] ];
Lino.users.UserLevels = [ [ "10", "Guest" ], [ "30", "User" ], [ "40", "Manager" ], [ "50", "Administrator" ] ];
Lino.cal.Weekdays = [ [ "1", "Monday" ], [ "2", "Tuesday" ], [ "3", "Wednesday" ], [ "4", "Thursday" ], [ "5", "Friday" ], [ "6", "Saturday" ], [ "7", "Sunday" ] ];
Lino.outbox.RecipientTypes = [ [ "to", "to" ], [ "cc", "cc" ], [ "bcc", "bcc" ] ];
Lino.excerpts.Shortcuts = [  ];
Lino.lino.YesNo = [ [ "y", "Yes" ], [ "n", "No" ] ];
Lino.cal.EventStates = [ [ "10", "Suggested" ], [ "20", "Draft" ], [ "50", "Took place" ], [ "70", "Cancelled" ], [ "75", "Omitted" ], [ "40", "Published" ] ];
Lino.cal.Recurrencies = [ [ "O", "once" ], [ "D", "daily" ], [ "W", "weekly" ], [ "M", "monthly" ], [ "Y", "yearly" ], [ "P", "per weekday" ] ];
Lino.lino.BuildMethods = [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appydoc", "AppyDocBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ];
Lino.cal.EventEvents = [ [ "10", "Okay" ], [ "20", "Pending" ] ];
Lino.households.MemberRoles = [ [ "01", "Head of household" ], [ "02", "Spouse" ], [ "03", "Partner" ], [ "04", "Cohabitant" ], [ "05", "Child" ], [ "07", "Adopted child" ], [ "06", "Relative" ] ];
Lino.cal.GuestStates = [ [ "10", "Invited" ], [ "20", "Accepted" ], [ "30", "Rejected" ], [ "40", "Present" ], [ "50", "Absent" ], [ "60", "Excused" ], [ "44", "Waiting" ], [ "45", "Busy" ], [ "46", "Gone" ] ];
Lino.addresses.AddressTypes = [ [ "01", "Official address" ], [ "02", "Unverified address" ], [ "03", "Declared address" ], [ "04", "Reference address" ] ];
Lino.users.UserGroups = [ [ "office", "office (Office)" ], [ "reception", "reception (Reception)" ] ];
Lino.lino.ChangeTypes = [ [ "C", "Create" ], [ "U", "Update" ], [ "D", "Delete" ], [ "R", "Remove child" ], [ "A", "Add child" ], [ "M", "Merge" ] ];
Lino.humanlinks.LinkTypes = [ [ "01", "Son (Daughter)" ], [ "02", "Adopted son (Adopted daughter)" ], [ "03", "Grandson (Granddaughter)" ], [ "05", "Husband (Wife)" ], [ "06", "Friend (Friend)" ], [ "07", "Partner (Partner)" ], [ "08", "Stepson (Stepdaughter)" ], [ "10", "Brother (Sister)" ], [ "11", "Cousin (Cousin)" ], [ "12", "Nephew (Niece)" ], [ "80", "Relative (Relative)" ], [ "90", "Other (Other)" ] ];
Lino.cal.AccessClasses = [ [ "10", "Private" ], [ "20", "Show busy" ], [ "30", "Public" ] ];
Lino.users.UserProfiles = [ [ "000", "000 (Anonymous)" ], [ "100", "100 (User)" ], [ "900", "900 (Administrator)" ] ];
Lino.lino.Genders = [ [ "M", "Male" ], [ "F", "Female" ] ];
Lino.countries.PlaceTypes = [ [ "10", "Member State" ], [ "11", "Division" ], [ "12", "Region" ], [ "13", "Community" ], [ "14", "Territory" ], [ "20", "County" ], [ "21", "Province" ], [ "22", "Shire" ], [ "23", "Subregion" ], [ "24", "Department" ], [ "25", "Arrondissement" ], [ "26", "Prefecture" ], [ "27", "District" ], [ "28", "Sector" ], [ "50", "City" ], [ "51", "Town" ], [ "52", "Municipality" ], [ "54", "Parish" ], [ "55", "Township" ], [ "56", "Quarter" ], [ "61", "Borough" ], [ "62", "Small borough" ], [ "70", "Village" ] ];
Lino.lino.PeriodEvents = [ [ "10", "Started" ], [ "20", "Active" ], [ "30", "Ended" ] ];

Lino.cal.Guests.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var start_date889 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Period from</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Period from","(cal.Guests.start_date) Start date of observed period") }, "value": null, "anchor": "-20" });
    var end_date890 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">until</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("until","(cal.Guests.end_date) End date of observed period") }, "value": null, "anchor": "-20" });
    var user891 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Responsible user</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Responsible user","(cal.Guests.user) Only rows managed by this user.") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/user", "method": "GET" }) }) });
    var event_state892 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Event state</span>", "name": "event_state", "hiddenName": "event_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Event state","(cal.Guests.event_state) Only rows having this event state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.EventStates) });
    var guest_state893 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Guest state</span>", "name": "guest_state", "hiddenName": "guest_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Guest state","(cal.Guests.guest_state) Only rows having this guest state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.GuestStates) });
    var main_1_panel894 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date889, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date890, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user891, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_state892, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": guest_state893, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var project900 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.projects.Projects.detail,Lino.projects.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(cal.Guests.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/project", "method": "GET" }) }) });
    var partner901 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "hiddenName": "partnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(cal.Guests.partner) ") }, "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }) });
    var main_2_panel902 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project900, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner901, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel894, main_2_panel902 ];
    this.fields = [ start_date889, end_date890, user891, event_state892, guest_state893, project900, partner901 ];
    Lino.cal.Guests.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Events.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var start_date823 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Period from</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Period from","(cal.Events.start_date) Start date of observed period") }, "value": null, "anchor": "-20" });
    var end_date824 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">until</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("until","(cal.Events.end_date) End date of observed period") }, "value": null, "anchor": "-20" });
    var observed_event825 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Observed event", "name": "observed_event", "hiddenName": "observed_eventHidden", "listeners": { "render": Lino.quicktip_renderer("Observed event","(cal.Events.observed_event) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.EventEvents) });
    var state826 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">State</span>", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("State","(cal.Events.state) Only rows having this state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.EventStates) });
    var main_1_panel827 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date823, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date824, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event825, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state826, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var user832 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Managed by</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Managed by","(cal.Events.user) Only rows managed by this user.") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }) });
    var assigned_to833 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Assigned to</span>", "name": "assigned_to", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "assigned_toHidden", "listeners": { "render": Lino.quicktip_renderer("Assigned to","(cal.Events.assigned_to) Only events assigned to this user.") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/assigned_to", "method": "GET" }) }) });
    var project834 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.projects.Projects.detail,Lino.projects.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(cal.Events.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }) });
    var event_type835 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Event Type", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail,Lino.cal.EventTypes.insert)}, "emptyText": "Select a Event Type...", "listeners": { "render": Lino.quicktip_renderer("Event Type","(cal.Events.event_type) ") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/event_type", "method": "GET" }) }) });
    var room836 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Room", "name": "room", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Rooms.detail,Lino.cal.Rooms.insert)}, "emptyText": "Select a Room...", "listeners": { "render": Lino.quicktip_renderer("Room","(cal.Events.room) ") }, "selectOnFocus": true, "hiddenName": "roomHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/room", "method": "GET" }) }) });
    var show_appointments837 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Appointments", "name": "show_appointments", "hiddenName": "show_appointmentsHidden", "listeners": { "render": Lino.quicktip_renderer("Appointments","(cal.Events.show_appointments) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.YesNo) });
    var main_2_panel838 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user832, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": assigned_to833, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project834, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type835, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": room836, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_appointments837, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel827, main_2_panel838 ];
    this.fields = [ start_date823, end_date824, observed_event825, state826, user832, assigned_to833, project834, event_type835, room836, show_appointments837 ];
    Lino.cal.Events.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.excerpts.Excerpts.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var start_date415 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Period from</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Period from","(excerpts.Excerpts.start_date) Start date of observed period") }, "value": null, "anchor": "-20" });
    var end_date416 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">until</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("until","(excerpts.Excerpts.end_date) End date of observed period") }, "value": null, "anchor": "-20" });
    var pcertifying417 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Certifying excerpts", "name": "pcertifying", "hiddenName": "pcertifyingHidden", "listeners": { "render": Lino.quicktip_renderer("Certifying excerpts","(excerpts.Excerpts.pcertifying) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.YesNo) });
    var main_1_panel418 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date415, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date416, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pcertifying417, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 180, "border": false, "anchor": "-20", "labelAlign": "top" });
    var puser422 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "User", "name": "puser", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "puserHidden", "listeners": { "render": Lino.quicktip_renderer("User","(excerpts.Excerpts.puser) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/puser", "method": "GET" }) }) });
    var pexcerpt_type423 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Excerpt Type", "name": "pexcerpt_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.excerpts.ExcerptTypes.detail,Lino.excerpts.ExcerptTypes.insert)}, "emptyText": "Select a Excerpt Type...", "listeners": { "render": Lino.quicktip_renderer("Excerpt Type","(excerpts.Excerpts.pexcerpt_type) ") }, "selectOnFocus": true, "hiddenName": "pexcerpt_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/pexcerpt_type", "method": "GET" }) }) });
    var main_2_panel424 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": puser422, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pexcerpt_type423, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel418, main_2_panel424 ];
    this.fields = [ start_date415, end_date416, pcertifying417, puser422, pexcerpt_type423 ];
    Lino.excerpts.Excerpts.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var start_date1018 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Period from</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Period from","(cal.Tasks.start_date) Start date of observed period") }, "value": null, "anchor": "-20" });
    var end_date1019 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">until</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("until","(cal.Tasks.end_date) End date of observed period") }, "value": null, "anchor": "-20" });
    var user1020 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Managed by</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Managed by","(cal.Tasks.user) Only rows managed by this user.") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var state1021 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">State</span>", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("State","(cal.Tasks.state) Only rows having this state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.TaskStates) });
    var project1022 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.projects.Projects.detail,Lino.projects.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(cal.Tasks.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_1_panel1023 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1018, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1019, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1020, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state1021, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1022, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    this.items = [ main_1_panel1023 ];
    this.fields = [ start_date1018, end_date1019, user1020, state1021, project1022 ];
    Lino.cal.Tasks.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.changes.Changes.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var date150 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Only changes from", "name": "date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Only changes from","(changes.Changes.date) ") }, "anchor": "-20" });
    var user151 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "User", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("User","(changes.Changes.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/user", "method": "GET" }) }) });
    var change_type152 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": false, "fieldLabel": "Change Type", "name": "change_type", "hiddenName": "change_typeHidden", "listeners": { "render": Lino.quicktip_renderer("Change Type","(changes.Changes.change_type) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.ChangeTypes) });
    var object_type153 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Object type", "name": "object_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contenttypes.ContentTypes.detail,Lino.contenttypes.ContentTypes.insert)}, "emptyText": "Select a content type...", "listeners": { "render": Lino.quicktip_renderer("Object type","(changes.Changes.object_type) ") }, "selectOnFocus": true, "hiddenName": "object_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/object_type", "method": "GET" }) }) });
    var object_id154 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Object ID", "name": "object_id", "hiddenName": "object_idHidden", "listeners": { "render": Lino.quicktip_renderer("Object ID","(changes.Changes.object_id) ") }, "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/object_id", "method": "GET" }) }) });
    var main_1_panel155 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 162, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date150, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user151, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": change_type152, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": object_type153, "labelAlign": "top" }, { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": object_id154, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    this.items = [ main_1_panel155 ];
    this.fields = [ date150, user151, change_type152, object_type153, object_id154 ];
    Lino.changes.Changes.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.about.Inspector.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 153,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'hbox',
  autoHeight: true,
  initComponent : function() {
    var inspected1426 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Inspected object", "name": "inspected", "maxLength": 100, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Inspected object","(about.Inspector.inspected) ") }, "anchor": "-20" });
    var show_callables1427 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "show_callables", "listeners": { "render": Lino.quicktip_renderer("show callables","(about.Inspector.show_callables) ") }, "boxLabel": "show callables", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "flex": 67, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inspected1426, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_callables1427, "labelAlign": "top" } ];
    this.fields = [ inspected1426, show_callables1427 ];
    Lino.about.Inspector.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.users.Users.change_password_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 171,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'change_password',
  ls_url: "/users/Users",
  window_title: "Change password",
  before_row_edit : function(record) {
  },
  autoHeight: true,
  initComponent : function() {
    this.current1 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Current password", "name": "current", "inputType": "password", "listeners": { "render": Lino.quicktip_renderer("Current password","(<ChangePassword change_password (u'Change password')>.current) ") }, "maxLength": null, "selectOnFocus": true, "anchor": "-20" });
    this.new12 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "New password", "name": "new1", "inputType": "password", "listeners": { "render": Lino.quicktip_renderer("New password","(<ChangePassword change_password (u'Change password')>.new1) ") }, "maxLength": null, "selectOnFocus": true, "anchor": "-20" });
    this.new23 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "New password again", "name": "new2", "inputType": "password", "listeners": { "render": Lino.quicktip_renderer("New password again","(<ChangePassword change_password (u'Change password')>.new2) ") }, "maxLength": null, "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.current1, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.new12, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.new23, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ this.current1, this.new12, this.new23 ];
    Lino.users.Users.change_password_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.create_household_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 162,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'create_household',
  ls_url: "/contacts/Persons",
  window_title: "Create Household",
  before_row_edit : function(record) {
  },
  autoHeight: true,
  initComponent : function() {
    this.partner8 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "partnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(<CreateHousehold create_household (u'Create Household')>.partner) ") }, "selectOnFocus": true, "emptyText": "Select a Person...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/contacts/Persons/create_household/partner", "method": "GET" }) }) });
    this.type9 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Household Type", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.households.Types.detail,Lino.households.Types.insert)}, "emptyText": "Select a Household Type...", "listeners": { "render": Lino.quicktip_renderer("Household Type","(<CreateHousehold create_household (u'Create Household')>.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/contacts/Persons/create_household/type", "method": "GET" }) }), "name": "type" });
    this.head10 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Head of household", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "emptyText": "Select a Person...", "listeners": { "render": Lino.quicktip_renderer("Head of household","(<CreateHousehold create_household (u'Create Household')>.head) ") }, "selectOnFocus": true, "hiddenName": "headHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/contacts/Persons/create_household/head", "method": "GET" }) }), "name": "head" });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.partner8, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.type9, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.head10, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ this.partner8, this.type9, this.head10 ];
    Lino.contacts.Persons.create_household_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.wf1_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 270,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'wf1',
  ls_url: "/cal/Guests",
  window_title: "Accept",
  before_row_edit : function(record) {
  },
  initComponent : function() {
    this.notify_subject15 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Summary", "name": "notify_subject", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Summary","(<AcceptInvitation wf1 (u'Accept')>.notify_subject) ") }, "anchor": "-20" });
    this.notify_body16 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(<AcceptInvitation wf1 (u'Accept')>.notify_body) ") }, "fieldLabel": "Description", "name": "notify_body", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    this.notify_silent17 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "notify_silent", "listeners": { "render": Lino.quicktip_renderer("Don't send email notification","(<AcceptInvitation wf1 (u'Accept')>.notify_silent) ") }, "boxLabel": "Don't send email notification", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": this.notify_subject15, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": this.notify_body16, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": this.notify_silent17, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ this.notify_subject15, this.notify_body16, this.notify_silent17 ];
    Lino.cal.Guests.wf1_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.checkin_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 270,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'checkin',
  ls_url: "/cal/Guests",
  window_title: "Checkin",
  before_row_edit : function(record) {
  },
  initComponent : function() {
    this.notify_subject29 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Summary", "name": "notify_subject", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Summary","(<CheckinVisitor checkin (u'Checkin')>.notify_subject) ") }, "anchor": "-20" });
    this.notify_body30 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(<CheckinVisitor checkin (u'Checkin')>.notify_body) ") }, "fieldLabel": "Description", "name": "notify_body", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    this.notify_silent31 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "notify_silent", "listeners": { "render": Lino.quicktip_renderer("Don't send email notification","(<CheckinVisitor checkin (u'Checkin')>.notify_silent) ") }, "boxLabel": "Don't send email notification", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": this.notify_subject29, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": this.notify_body30, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": this.notify_silent31, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ this.notify_subject29, this.notify_body30, this.notify_silent31 ];
    Lino.cal.Guests.checkin_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.wf2_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 270,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'wf2',
  ls_url: "/cal/Guests",
  window_title: "Reject",
  before_row_edit : function(record) {
  },
  initComponent : function() {
    this.notify_subject22 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Summary", "name": "notify_subject", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Summary","(<RejectInvitation wf2 (u'Reject')>.notify_subject) ") }, "anchor": "-20" });
    this.notify_body23 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(<RejectInvitation wf2 (u'Reject')>.notify_body) ") }, "fieldLabel": "Description", "name": "notify_body", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    this.notify_silent24 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "notify_silent", "listeners": { "render": Lino.quicktip_renderer("Don't send email notification","(<RejectInvitation wf2 (u'Reject')>.notify_silent) ") }, "boxLabel": "Don't send email notification", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": this.notify_subject22, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": this.notify_body23, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": this.notify_silent24, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ this.notify_subject22, this.notify_body23, this.notify_silent24 ];
    Lino.cal.Guests.wf2_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 20,
  initComponent : function() {
    var first_name666 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">First name</span>", "name": "first_name", "listeners": { "render": Lino.quicktip_renderer("First name","(contacts.Persons.first_name) First or given name.") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var last_name667 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Last name</span>", "name": "last_name", "listeners": { "render": Lino.quicktip_renderer("Last name","(contacts.Persons.last_name) Last name (family name).") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel668 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name666, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name667, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gender671 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Gender", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Gender","(contacts.Persons.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var language672 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(contacts.Persons.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "et", "Estonian" ] ], "name": "language" });
    var main_2_panel673 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender671, "labelAlign": "top" }, { "flex": 68, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language672, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel676 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel668, main_2_panel673 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel676;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Persons.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.Mails.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 13,
  initComponent : function() {
    var subject335 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Subject", "name": "subject", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Subject","(outbox.Mails.subject) ") }, "anchor": "-20" });
    var project336 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.projects.Projects.detail,Lino.projects.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(outbox.Mails.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var date337 = new Lino.DateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Date</span>", "name": "date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date","(outbox.Mails.date) \n        The official date to be printed on the document.\n        ") }, "anchor": "-20" });
    var main_1_panel338 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject335, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project336, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date337, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user342 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Sender", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Sender","(outbox.Mails.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/user", "method": "GET" }) }) });
    var sent343 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "sent", "name": "sent", "listeners": { "render": Lino.quicktip_renderer("sent","(outbox.Mails.sent) ") }, "value": "<br>", "anchor": "-20" });
    var id344 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(outbox.Mails.id) ") }, "anchor": "-20" });
    var owner_disp345 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Controlled by", "anchor": "-20", "name": "owner" });
    var main_2_panel346 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user342, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent343, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id344, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp345, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var RecipientsByMail_grid357 = new Lino.outbox.RecipientsByMail.GridPanel({ "flex": 55, "listeners": { "render": Lino.quicktip_renderer("Recipients","(outbox.outbox.RecipientsByMail) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.RecipientsByMail.grid) ], "preview_limit": 15, "master_panel": this });
    var AttachmentsByMail_htmlbox358 = new Lino.HtmlBoxPanel({ "flex": 22, "layout": "fit", "name": "AttachmentsByMail", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Attachments", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Attachments","(outbox.Mails.AttachmentsByMail) ") }, "bodyStyle": "overflow-x:hidden;", "tools": [ Lino.show_in_own_window_button(Lino.outbox.AttachmentsByMail.grid) ] });
    var UploadsByController_htmlbox359 = new Lino.HtmlBoxPanel({ "flex": 22, "layout": "fit", "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Uploads","(outbox.Mails.UploadsByController) ") }, "bodyStyle": "overflow-x:hidden;", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var main_3_panel360 = new Ext.Panel({ "flex": 29, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ RecipientsByMail_grid357, AttachmentsByMail_htmlbox358, UploadsByController_htmlbox359 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var body361 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 58, "containing_panel": this, "name": "body", "title": "Body" });
    var main_panel362 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel338, main_2_panel346, main_3_panel360, body361 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel362;
    this.before_row_edit = function(record) {
      RecipientsByMail_grid357.on_master_changed();
      AttachmentsByMail_htmlbox358.refresh();
      UploadsByController_htmlbox359.refresh();
      body361.refresh();
    }
    Lino.outbox.Mails.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.excerpts.ExcerptTypes.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 11,
  initComponent : function() {
    var name478 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(excerpts.ExcerptTypes.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_et479 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(excerpts.ExcerptTypes.name_et) ") }, "anchor": "-20" });
    var main_1_panel480 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name478, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et479, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var content_type483 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Model</span>", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contenttypes.ContentTypes.detail,Lino.contenttypes.ContentTypes.insert)}, "emptyText": "Select a content type...", "listeners": { "render": Lino.quicktip_renderer("Model","(excerpts.ExcerptTypes.content_type) The model that can issue printouts of this type.") }, "selectOnFocus": true, "hiddenName": "content_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/ExcerptTypes/content_type", "method": "GET" }) }), "name": "content_type" });
    var primary484 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "primary", "listeners": { "render": Lino.quicktip_renderer("Primary","(excerpts.ExcerptTypes.primary) There's at most one primary type per model.         Enabling this field will automatically make the other         types non-primary.") }, "boxLabel": "Primary", "selectOnFocus": true, "anchor": "-20" });
    var certifying485 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "certifying", "listeners": { "render": Lino.quicktip_renderer("Certifying","(excerpts.ExcerptTypes.certifying) Whether an excerpt of this type is a unique printout.") }, "boxLabel": "Certifying", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel486 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": content_type483, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": primary484, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": certifying485, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var build_method490 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Build method", "name": "build_method", "hiddenName": "build_methodHidden", "listeners": { "render": Lino.quicktip_renderer("Build method","(excerpts.ExcerptTypes.build_method) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.BuildMethods) });
    var template491 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Template", "name": "template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Template","(excerpts.ExcerptTypes.template) ") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/ExcerptTypes/template", "method": "GET" }) }), "anchor": "-20" });
    var body_template492 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Body template</span>", "name": "body_template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Body template","(excerpts.ExcerptTypes.body_template) The body template to be used when         rendering a printable of this type. This is a list of files         with extension `.body.html`.") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/ExcerptTypes/body_template", "method": "GET" }) }), "anchor": "-20" });
    var main_3_panel493 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method490, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template491, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": body_template492, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel497 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel480, main_2_panel486, main_3_panel493 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel497;
    this.before_row_edit = function(record) {
      template491.setContextValue('build_method', record ? record.data['build_methodHidden'] : undefined);
      template491.setContextValue('content_type', record ? record.data['content_typeHidden'] : undefined);
      body_template492.setContextValue('content_type', record ? record.data['content_typeHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      build_method490.on('change',Lino.chooser_handler(template491,'build_method'));
      content_type483.on('change',Lino.chooser_handler(template491,'content_type'));
      content_type483.on('change',Lino.chooser_handler(body_template492,'content_type'));
      Lino.excerpts.ExcerptTypes.InsertFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.excerpts.ExcerptTypes.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.excerpts.ExcerptTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 11,
  initComponent : function() {
    var id369 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(excerpts.ExcerptTypes.id) ") }, "anchor": "-20" });
    var name370 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(excerpts.ExcerptTypes.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_et371 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(excerpts.ExcerptTypes.name_et) ") }, "anchor": "-20" });
    var main_1_panel372 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id369, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name370, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et371, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var content_type376 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Model</span>", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contenttypes.ContentTypes.detail,Lino.contenttypes.ContentTypes.insert)}, "emptyText": "Select a content type...", "listeners": { "render": Lino.quicktip_renderer("Model","(excerpts.ExcerptTypes.content_type) The model that can issue printouts of this type.") }, "selectOnFocus": true, "hiddenName": "content_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/ExcerptTypes/content_type", "method": "GET" }) }), "name": "content_type" });
    var build_method377 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Build method", "name": "build_method", "hiddenName": "build_methodHidden", "listeners": { "render": Lino.quicktip_renderer("Build method","(excerpts.ExcerptTypes.build_method) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.BuildMethods) });
    var template378 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Template", "name": "template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Template","(excerpts.ExcerptTypes.template) ") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/ExcerptTypes/template", "method": "GET" }) }), "anchor": "-20" });
    var body_template379 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Body template</span>", "name": "body_template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Body template","(excerpts.ExcerptTypes.body_template) The body template to be used when         rendering a printable of this type. This is a list of files         with extension `.body.html`.") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/ExcerptTypes/body_template", "method": "GET" }) }), "anchor": "-20" });
    var email_template380 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Email template</span>", "name": "email_template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Email template","(excerpts.ExcerptTypes.email_template) The name of the file to be used as template when creating an email from a mailable of this type.") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/ExcerptTypes/email_template", "method": "GET" }) }), "anchor": "-20" });
    var shortcut381 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Excerpt shortcut", "name": "shortcut", "boxMinWidth": Lino.chars2width(1), "listeners": { "render": Lino.quicktip_renderer("Excerpt shortcut","(excerpts.ExcerptTypes.shortcut) ") }, "maxLength": 1, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel382 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": content_type376, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method377, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template378, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": body_template379, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template380, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": shortcut381, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var primary389 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "primary", "listeners": { "render": Lino.quicktip_renderer("Primary","(excerpts.ExcerptTypes.primary) There's at most one primary type per model.         Enabling this field will automatically make the other         types non-primary.") }, "boxLabel": "Primary", "selectOnFocus": true, "anchor": "-20" });
    var print_directly390 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": true, "name": "print_directly", "listeners": { "render": Lino.quicktip_renderer("Print directly","(excerpts.ExcerptTypes.print_directly) ") }, "boxLabel": "Print directly", "selectOnFocus": true, "anchor": "-20" });
    var certifying391 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "certifying", "listeners": { "render": Lino.quicktip_renderer("Certifying","(excerpts.ExcerptTypes.certifying) Whether an excerpt of this type is a unique printout.") }, "boxLabel": "Certifying", "selectOnFocus": true, "anchor": "-20" });
    var print_recipient392 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": true, "name": "print_recipient", "listeners": { "render": Lino.quicktip_renderer("Print recipient","(excerpts.ExcerptTypes.print_recipient) Whether to print a recipient field in document.") }, "boxLabel": "Print recipient", "selectOnFocus": true, "anchor": "-20" });
    var backward_compat393 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "backward_compat", "listeners": { "render": Lino.quicktip_renderer("Backward compatible","(excerpts.ExcerptTypes.backward_compat) Check this to have `this` in template context point to owner instead of excerpt.") }, "boxLabel": "Backward compatible", "selectOnFocus": true, "anchor": "-20" });
    var attach_to_email394 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "attach_to_email", "listeners": { "render": Lino.quicktip_renderer("Attach to email","(excerpts.ExcerptTypes.attach_to_email) Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "boxLabel": "Attach to email", "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel395 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 180, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": primary389, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": print_directly390, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": certifying391, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": print_recipient392, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": backward_compat393, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email394, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var excerpts_ExcerptsByType_grid476 = new Lino.excerpts.ExcerptsByType.GridPanel({ "flex": 62, "listeners": { "render": Lino.quicktip_renderer("Excerpts","(excerpts.excerpts.ExcerptsByType) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.excerpts.ExcerptsByType.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel477 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel372, main_2_panel382, main_3_panel395, excerpts_ExcerptsByType_grid476 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel477;
    this.before_row_edit = function(record) {
      template378.setContextValue('build_method', record ? record.data['build_methodHidden'] : undefined);
      template378.setContextValue('content_type', record ? record.data['content_typeHidden'] : undefined);
      body_template379.setContextValue('content_type', record ? record.data['content_typeHidden'] : undefined);
      email_template380.setContextValue('content_type', record ? record.data['content_typeHidden'] : undefined);
      excerpts_ExcerptsByType_grid476.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method377.on('change',Lino.chooser_handler(template378,'build_method'));
      content_type376.on('change',Lino.chooser_handler(template378,'content_type'));
      content_type376.on('change',Lino.chooser_handler(body_template379,'content_type'));
      content_type376.on('change',Lino.chooser_handler(email_template380,'content_type'));
      Lino.excerpts.ExcerptTypes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.excerpts.ExcerptTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.excerpts.Excerpts.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 12,
  initComponent : function() {
    var excerpt_type465 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Excerpt Type", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.excerpts.ExcerptTypes.detail,Lino.excerpts.ExcerptTypes.insert)}, "emptyText": "Select a Excerpt Type...", "listeners": { "render": Lino.quicktip_renderer("Excerpt Type","(excerpts.Excerpts.excerpt_type) ") }, "selectOnFocus": true, "hiddenName": "excerpt_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/excerpt_type", "method": "GET" }) }), "name": "excerpt_type" });
    var project466 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.projects.Projects.detail,Lino.projects.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(excerpts.Excerpts.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/project", "method": "GET" }) }) });
    var main_1_panel467 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": excerpt_type465, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project466, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var company470 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Recipient (Organization)", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "companyHidden", "listeners": { "render": Lino.quicktip_renderer("Recipient (Organization)","(excerpts.Excerpts.company) ") }, "selectOnFocus": true, "emptyText": "Select a Organisation...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/company", "method": "GET" }) }) });
    var contact_person471 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Recipient (Person)", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "contact_personHidden", "listeners": { "render": Lino.quicktip_renderer("Recipient (Person)","(excerpts.Excerpts.contact_person) ") }, "selectOnFocus": true, "emptyText": "Select a Person...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/contact_person", "method": "GET" }) }) });
    var main_2_panel472 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company470, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person471, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 225, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel475 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel467, main_2_panel472 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel475;
    this.before_row_edit = function(record) {
      excerpt_type465.setContextValue('owner', record ? record.data['owner'] : undefined);
      contact_person471.setContextValue('company', record ? record.data['companyHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      company470.on('change',Lino.chooser_handler(contact_person471,'company'));
      Lino.excerpts.Excerpts.InsertFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.excerpts.Excerpts.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Types.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 34,
  initComponent : function() {
    var name1301 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(households.Types.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_et1302 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(households.Types.name_et) ") }, "anchor": "-20" });
    var main_1_panel1303 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1301, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1302, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var HouseholdsByType_grid1384 = new Lino.households.HouseholdsByType.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Households","(households.households.HouseholdsByType) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.HouseholdsByType.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1385 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1303, HouseholdsByType_grid1384 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1385;
    this.before_row_edit = function(record) {
      HouseholdsByType_grid1384.on_master_changed();
    }
    Lino.households.Types.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.Uploads.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 17,
  initComponent : function() {
    var type537 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Upload Type", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.uploads.UploadTypes.detail,Lino.uploads.UploadTypes.insert)}, "emptyText": "Select a Upload Type...", "listeners": { "render": Lino.quicktip_renderer("Upload Type","(uploads.Uploads.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var description538 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Description", "name": "description", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Description","(uploads.Uploads.description) ") }, "anchor": "-20" });
    var file539 = Lino.file_field_handler(this,{ "autoHeight": true, "fieldLabel": "File", "name": "file", "maxLength": 100, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("File","(uploads.Uploads.file) ") }, "anchor": "-20" });
    var user540 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(uploads.Uploads.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_panel541 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 108, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": type537, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": description538, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": file539, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": user540, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel541;
    this.before_row_edit = function(record) {
      type537.setContextValue('upload_area', record ? record.data['upload_areaHidden'] : undefined);
    }
    Lino.uploads.Uploads.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.Models.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var app_disp1411 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "app_label", "name": "app", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("app_label","(about.Models.app) ") }, "anchor": "-20" });
    var name_disp1412 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "name", "name": "name", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("name","(about.Models.name) ") }, "anchor": "-20" });
    var docstring_disp1413 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "docstring", "name": "docstring", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("docstring","(about.Models.docstring) ") }, "anchor": "-20" });
    var rows1414 = new Ext.form.NumberField({ "disabled": true, "autoHeight": true, "fieldLabel": "Rows", "name": "rows", "listeners": { "render": Lino.quicktip_renderer("Rows","(about.Models.rows) ") }, "anchor": "-20" });
    var main_1_panel1415 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_disp1411, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_disp1412, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": docstring_disp1413, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": rows1414, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var about_FieldsByModel_grid1424 = new Lino.about.FieldsByModel.GridPanel({ "flex": 62, "listeners": { "render": Lino.quicktip_renderer("Fields","(about.about.FieldsByModel) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.about.FieldsByModel.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1425 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1415, about_FieldsByModel_grid1424 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1425;
    this.before_row_edit = function(record) {
      about_FieldsByModel_grid1424.on_master_changed();
    }
    Lino.about.Models.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.projects.Projects.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 29,
  initComponent : function() {
    var name1279 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("name","(projects.Projects.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var type1280 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Project Type", "name": "type", "pageSize": 20, "emptyText": "Select a Project Type...", "listeners": { "render": Lino.quicktip_renderer("Project Type","(projects.Projects.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/projects/Projects/type", "method": "GET" }) }) });
    var user1281 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(projects.Projects.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/projects/Projects/user", "method": "GET" }) }) });
    var main_1_panel1282 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1279, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1280, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1281, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var started1286 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "started", "name": "started", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("started","(projects.Projects.started) ") }, "anchor": "-20" });
    var stopped1287 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "stopped", "name": "stopped", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("stopped","(projects.Projects.stopped) ") }, "anchor": "-20" });
    var main_2_panel1288 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": started1286, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": stopped1287, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var text1291 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("text","(projects.Projects.text) ") }, "fieldLabel": "text", "name": "text", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var main_panel1292 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 45, "hideCheckBoxLabels": true, "items": [ main_1_panel1282, main_2_panel1288, { "items": text1291, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1292;
    this.before_row_edit = function(record) {
    }
    Lino.projects.Projects.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 35,
  initComponent : function() {
    var summary1010 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Summary", "name": "summary", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Summary","(cal.Tasks.summary) ") }, "anchor": "-20" });
    var user1011 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(cal.Tasks.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var project1012 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.projects.Projects.detail,Lino.projects.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(cal.Tasks.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_2_panel1013 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1011, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1012, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1016 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary1010, "anchor": "-20", "labelAlign": "top" }, main_2_panel1013 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1016;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Tasks.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 40,
  initComponent : function() {
    var event921 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Event", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.OneEvent.detail,Lino.cal.OneEvent.insert)}, "emptyText": "Select a Event...", "listeners": { "render": Lino.quicktip_renderer("Event","(cal.Guests.event) ") }, "selectOnFocus": true, "hiddenName": "eventHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/event", "method": "GET" }) }), "name": "event" });
    var partner922 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "emptyText": "Select a Partner...", "listeners": { "render": Lino.quicktip_renderer("Partner","(cal.Guests.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }), "name": "partner" });
    var role923 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Role", "name": "role", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.GuestRoles.detail,Lino.cal.GuestRoles.insert)}, "emptyText": "Select a Guest Role...", "listeners": { "render": Lino.quicktip_renderer("Role","(cal.Guests.role) ") }, "selectOnFocus": true, "hiddenName": "roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/role", "method": "GET" }) }) });
    var main_panel924 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": event921, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner922, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": role923, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel924;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Guests.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.UploadTypes.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 16,
  initComponent : function() {
    var name548 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(uploads.UploadTypes.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_et549 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(uploads.UploadTypes.name_et) ") }, "anchor": "-20" });
    var main_1_panel550 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name548, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et549, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var upload_area553 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Upload Area", "allowBlank": false, "hiddenName": "upload_areaHidden", "listeners": { "render": Lino.quicktip_renderer("Upload Area","(uploads.UploadTypes.upload_area) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.uploads.UploadAreas, "name": "upload_area" });
    var main_panel554 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 108, "autoScroll": false, "items": [ main_1_panel550, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": upload_area553, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel554;
    this.before_row_edit = function(record) {
    }
    Lino.uploads.UploadTypes.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 19,
  initComponent : function() {
    var overview_disp677 = new Ext.form.DisplayField({ "disabled": true, "flex": 20, "listeners": { "render": Lino.quicktip_renderer(null,"(contacts.Companies.overview) ") }, "name": "overview", "value": "<br/>", "always_enabled": true });
    var prefix678 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name prefix", "name": "prefix", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Name prefix","(contacts.Companies.prefix) ") }, "anchor": "-20" });
    var name679 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Companies.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var general2_1_panel680 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix678, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name679, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type683 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Organization type", "name": "type", "pageSize": 20, "emptyText": "Select a Organization type...", "listeners": { "render": Lino.quicktip_renderer("Organization type","(contacts.Companies.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var vat_id684 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "VAT id", "name": "vat_id", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("VAT id","(contacts.Companies.vat_id) ") }, "anchor": "-20" });
    var general2_2_panel685 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type683, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id684, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var url688 = new Lino.URLField({ "autoHeight": true, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("URL","(contacts.Companies.url) ") }, "anchor": "-20" });
    var general2_panel689 = new Ext.Panel({ "flex": 40, "autoHeight": true, "layout": "form", "items": [ general2_1_panel680, general2_2_panel685, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url688, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 36, "border": false, "labelAlign": "top" });
    var email691 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Companies.email) ") }, "anchor": "-20" });
    var phone692 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Phone", "name": "phone", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Phone","(contacts.Companies.phone) ") }, "anchor": "-20" });
    var gsm693 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("GSM","(contacts.Companies.gsm) ") }, "anchor": "-20" });
    var fax694 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Fax","(contacts.Companies.fax) ") }, "anchor": "-20" });
    var general3_panel695 = new Ext.Panel({ "flex": 40, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email691, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone692, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm693, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax694, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var general_1_panel700 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ overview_disp677, general2_panel689, general3_panel695 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var contacts_RolesByCompany_grid705 = new Lino.contacts.RolesByCompany.GridPanel({ "flex": 55, "listeners": { "render": Lino.quicktip_renderer("Contact persons","(contacts.contacts.RolesByCompany) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.grid) ], "preview_limit": 15, "master_panel": this });
    var general_panel706 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel700, contacts_RolesByCompany_grid705 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var addresses_AddressesByPartner_grid707 = new Lino.addresses.AddressesByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Addresses","(addresses.addresses.AddressesByPartner) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.addresses.AddressesByPartner.grid) ] });
    var remarks708 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remarks","(contacts.Companies.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var sepa_AccountsByPartner_grid709 = new Lino.sepa.AccountsByPartner.GridPanel({ "flex": 64, "listeners": { "render": Lino.quicktip_renderer("Accounts","(sepa.sepa.AccountsByPartner) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.sepa.AccountsByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var contact_2_panel710 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ { "items": remarks708, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 35 }, sepa_AccountsByPartner_grid709 ], "region": "center", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 72, "border": false, "frame": false, "labelAlign": "top" });
    var contact_panel712 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Contact", "hideCheckBoxLabels": true, "items": [ addresses_AddressesByPartner_grid707, contact_2_panel710 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var notes_NotesByCompany_grid764 = new Lino.notes.NotesByCompany.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Notes", "tools": [ Lino.show_in_own_window_button(Lino.notes.NotesByCompany.grid) ], "preview_limit": 15, "master_panel": this });
    var id765 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Companies.id) ") }, "anchor": "-20" });
    var language766 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(contacts.Companies.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "et", "Estonian" ] ], "name": "language" });
    var misc_1_panel767 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id765, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language766, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var created770 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "listeners": { "render": Lino.quicktip_renderer("Created","(contacts.Companies.created) ") }, "value": "<br>", "anchor": "-20" });
    var modified771 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "listeners": { "render": Lino.quicktip_renderer("Modified","(contacts.Companies.modified) ") }, "value": "<br>", "anchor": "-20" });
    var misc_2_panel772 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created770, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified771, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var reception_AppointmentsByPartner_grid775 = new Lino.reception.AppointmentsByPartner.GridPanel({ "flex": 71, "listeners": { "render": Lino.quicktip_renderer("Appointments","(reception.reception.AppointmentsByPartner) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.reception.AppointmentsByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var misc_panel776 = new Ext.Panel({ "layout": "vbox", "title": "Miscellaneous", "items": [ misc_1_panel767, misc_2_panel772, reception_AppointmentsByPartner_grid775 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel777 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel706, contact_panel712, notes_NotesByCompany_grid764, misc_panel776 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel777;
    this.before_row_edit = function(record) {
      contacts_RolesByCompany_grid705.on_master_changed();
      addresses_AddressesByPartner_grid707.on_master_changed();
      sepa_AccountsByPartner_grid709.on_master_changed();
      notes_NotesByCompany_grid764.on_master_changed();
      reception_AppointmentsByPartner_grid775.on_master_changed();
    }
    Lino.contacts.Companies.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
  }
});


Lino.contacts.Partners.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 22,
  initComponent : function() {
    var overview_disp241 = new Ext.form.DisplayField({ "disabled": true, "flex": 25, "listeners": { "render": Lino.quicktip_renderer(null,"(contacts.Partners.overview) ") }, "name": "overview", "value": "<br/>", "always_enabled": true });
    var id242 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Partners.id) ") }, "anchor": "-20" });
    var language243 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(contacts.Partners.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "et", "Estonian" ] ], "name": "language" });
    var general2_1_panel244 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id242, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language243, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var url247 = new Lino.URLField({ "autoHeight": true, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("URL","(contacts.Partners.url) ") }, "anchor": "-20" });
    var general2_panel248 = new Ext.Panel({ "flex": 25, "autoHeight": true, "layout": "form", "items": [ general2_1_panel244, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url247, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 36, "border": false, "labelAlign": "top" });
    var email250 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Partners.email) ") }, "anchor": "-20" });
    var phone251 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Phone", "name": "phone", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Phone","(contacts.Partners.phone) ") }, "anchor": "-20" });
    var gsm252 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("GSM","(contacts.Partners.gsm) ") }, "anchor": "-20" });
    var fax253 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Fax","(contacts.Partners.fax) ") }, "anchor": "-20" });
    var general3_panel254 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email250, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone251, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm252, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax253, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var general_1_panel259 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ overview_disp241, general2_panel248, general3_panel254 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var reception_AppointmentsByPartner_grid264 = new Lino.reception.AppointmentsByPartner.GridPanel({ "flex": 55, "listeners": { "render": Lino.quicktip_renderer("Appointments","(reception.reception.AppointmentsByPartner) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.reception.AppointmentsByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var general_panel265 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel259, reception_AppointmentsByPartner_grid264 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var country266 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Country","(contacts.Partners.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }) });
    var region267 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "County", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("County","(contacts.Partners.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }) });
    var city268 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "City", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("City","(contacts.Partners.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }) });
    var zip_code269 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Zip code", "name": "zip_code", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Zip code","(contacts.Partners.zip_code) ") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var address_box_1_panel270 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country266, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region267, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city268, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code269, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr1275 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line before street</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Address line before street","(contacts.Partners.addr1) Address line before street") }, "anchor": "-20" });
    var street_prefix276 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street prefix</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Street prefix","(contacts.Partners.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "anchor": "-20" });
    var street277 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Street","(contacts.Partners.street) Name of street, without house number.") }, "anchor": "-20" });
    var street_no278 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("No.","(contacts.Partners.street_no) House number.") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var street_box279 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Box","(contacts.Partners.street_box) Text to print after street nuber on the same line.") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var address_box_3_panel280 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix276, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street277, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no278, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box279, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2285 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line after street</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Address line after street","(contacts.Partners.addr2) Address line to print below street line.") }, "anchor": "-20" });
    var address_box_panel286 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 243, "hideCheckBoxLabels": true, "items": [ address_box_1_panel270, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1275, "anchor": "-20", "labelAlign": "top" }, address_box_3_panel280, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2285, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var remarks289 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remarks","(contacts.Partners.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var sepa_AccountsByPartner_grid294 = new Lino.sepa.AccountsByPartner.GridPanel({ "flex": 64, "listeners": { "render": Lino.quicktip_renderer("Accounts","(sepa.sepa.AccountsByPartner) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.sepa.AccountsByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var contact_2_panel295 = new Ext.Panel({ "flex": 55, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": remarks289, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 35 }, sepa_AccountsByPartner_grid294 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var contact_panel297 = new Ext.Panel({ "layout": "vbox", "title": "Contact", "items": [ address_box_panel286, contact_2_panel295 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var is_person298 = new Ext.form.Checkbox({ "boxLabel": "is Person (<a href=\"javascript:Lino.show_mti_child('is_person',Lino.contacts.Persons.detail)\">show</a>)", "autoHeight": true, "hideLabel": true, "name": "is_person", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("is Person","(contacts.Partners.is_person) Whether this Partner is a Person.") }, "anchor": "-20" });
    var is_company299 = new Ext.form.Checkbox({ "boxLabel": "is Company (<a href=\"javascript:Lino.show_mti_child('is_company',Lino.contacts.Companies.detail)\">show</a>)", "autoHeight": true, "hideLabel": true, "name": "is_company", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("is Company","(contacts.Partners.is_company) Whether this Partner is a Company.") }, "anchor": "-20" });
    var is_household300 = new Ext.form.Checkbox({ "boxLabel": "is Household (<a href=\"javascript:Lino.show_mti_child('is_household',Lino.households.Households.detail)\">show</a>)", "autoHeight": true, "hideLabel": true, "name": "is_household", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("is Household","(contacts.Partners.is_household) Whether this Partner is a Household.") }, "anchor": "-20" });
    var created301 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "listeners": { "render": Lino.quicktip_renderer("Created","(contacts.Partners.created) ") }, "value": "<br>", "anchor": "-20" });
    var modified302 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "listeners": { "render": Lino.quicktip_renderer("Modified","(contacts.Partners.modified) ") }, "value": "<br>", "anchor": "-20" });
    var misc_1_panel303 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_person298, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_company299, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_household300, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created301, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified302, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var changes_ChangesByMaster_grid317 = new Lino.changes.ChangesByMaster.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Changes","(changes.changes.ChangesByMaster) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.changes.ChangesByMaster.grid) ], "preview_limit": 15, "master_panel": this });
    var misc_panel318 = new Ext.Panel({ "layout": "vbox", "title": "Miscellaneous", "items": [ misc_1_panel303, changes_ChangesByMaster_grid317 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel319 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel265, contact_panel297, misc_panel318 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel319;
    this.before_row_edit = function(record) {
      reception_AppointmentsByPartner_grid264.on_master_changed();
      region267.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city268.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city268.setContextValue('region', record ? record.data['regionHidden'] : undefined);
      sepa_AccountsByPartner_grid294.on_master_changed();
      changes_ChangesByMaster_grid317.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country266.on('change',Lino.chooser_handler(region267,'country'));
      country266.on('change',Lino.chooser_handler(city268,'country'));
      region267.on('change',Lino.chooser_handler(city268,'region'));
      Lino.contacts.Partners.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Partners.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    city268.on("change", function(){ this.save() }, this);
    zip_code269.on("change", function(){ this.save() }, this);
  }
});


Lino.contacts.Partners.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 22,
  initComponent : function() {
    var name320 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Partners.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language321 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(contacts.Partners.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "et", "Estonian" ] ], "name": "language" });
    var email322 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Partners.email) ") }, "anchor": "-20" });
    var main_2_panel323 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language321, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email322, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel326 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name320, "anchor": "-20", "labelAlign": "top" }, main_2_panel323 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel326;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Partners.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.Uploads.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 17,
  initComponent : function() {
    var file522 = Lino.file_field_handler(this,{ "autoHeight": true, "fieldLabel": "File", "name": "file", "maxLength": 100, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("File","(uploads.Uploads.file) ") }, "anchor": "-20" });
    var user523 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(uploads.Uploads.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel524 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file522, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user523, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var upload_area527 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Upload Area", "allowBlank": false, "hiddenName": "upload_areaHidden", "listeners": { "render": Lino.quicktip_renderer("Upload Area","(uploads.Uploads.upload_area) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.uploads.UploadAreas, "name": "upload_area" });
    var type528 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Upload Type", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.uploads.UploadTypes.detail,Lino.uploads.UploadTypes.insert)}, "emptyText": "Select a Upload Type...", "listeners": { "render": Lino.quicktip_renderer("Upload Type","(uploads.Uploads.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var description529 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Description", "name": "description", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Description","(uploads.Uploads.description) ") }, "anchor": "-20" });
    var main_2_panel530 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": upload_area527, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type528, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": description529, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var owner_disp534 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Controlled by", "anchor": "-20", "name": "owner" });
    var main_panel535 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 126, "autoScroll": false, "items": [ main_1_panel524, main_2_panel530, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp534, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel535;
    this.before_row_edit = function(record) {
      type528.setContextValue('upload_area', record ? record.data['upload_areaHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      upload_area527.on('change',Lino.chooser_handler(type528,'upload_area'));
      Lino.uploads.Uploads.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.uploads.Uploads.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.NoteTypes.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 28,
  initComponent : function() {
    var name1243 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(notes.NoteTypes.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_et1244 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(notes.NoteTypes.name_et) ") }, "anchor": "-20" });
    var main_1_panel1245 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1243, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1244, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var build_method1248 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Build method", "name": "build_method", "hiddenName": "build_methodHidden", "listeners": { "render": Lino.quicktip_renderer("Build method","(notes.NoteTypes.build_method) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.BuildMethods) });
    var main_panel1249 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 117, "autoScroll": false, "items": [ main_1_panel1245, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method1248, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1249;
    this.before_row_edit = function(record) {
    }
    Lino.notes.NoteTypes.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.SiteConfigs.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 4,
  initComponent : function() {
    var default_build_method115 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Default build method", "name": "default_build_method", "hiddenName": "default_build_methodHidden", "listeners": { "render": Lino.quicktip_renderer("Default build method","(system.SiteConfigs.default_build_method) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.BuildMethods) });
    var main_panel116 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "items": default_build_method115, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel116;
    this.before_row_edit = function(record) {
    }
    Lino.system.SiteConfigs.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Rooms.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 36,
  initComponent : function() {
    var id791 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.Rooms.id) ") }, "anchor": "-20" });
    var name792 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(cal.Rooms.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_et793 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(cal.Rooms.name_et) ") }, "anchor": "-20" });
    var main_1_panel794 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id791, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name792, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et793, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_EventsByRoom_grid957 = new Lino.cal.EventsByRoom.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Events","(cal.cal.EventsByRoom) ") }, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByRoom.grid) ] });
    var main_panel958 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel794, cal_EventsByRoom_grid957 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel958;
    this.before_row_edit = function(record) {
      cal_EventsByRoom_grid957.on_master_changed();
    }
    Lino.cal.Rooms.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contenttypes.ContentTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 3,
  initComponent : function() {
    var id92 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contenttypes.ContentTypes.id) ") }, "anchor": "-20" });
    var name93 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("name","(contenttypes.ContentTypes.name) ") }, "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var app_label94 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "app label", "name": "app_label", "listeners": { "render": Lino.quicktip_renderer("app label","(contenttypes.ContentTypes.app_label) ") }, "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var model95 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "python model class name", "name": "model", "listeners": { "render": Lino.quicktip_renderer("python model class name","(contenttypes.ContentTypes.model) ") }, "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var base_classes_disp96 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Base classes", "name": "base_classes", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Base classes","(contenttypes.ContentTypes.base_classes) ") }, "anchor": "-20" });
    var main_1_panel97 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id92, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name93, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_label94, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": model95, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": base_classes_disp96, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 216, "border": false, "frame": false, "labelAlign": "top" });
    var HelpTextsByModel_grid109 = new Lino.contenttypes.HelpTextsByModel.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Help Texts","(contenttypes.contenttypes.HelpTextsByModel) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.contenttypes.HelpTextsByModel.grid) ] });
    var StaleControllablesByModel_grid113 = new Lino.contenttypes.StaleControllablesByModel.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Stale Controllables","(contenttypes.contenttypes.StaleControllablesByModel) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.contenttypes.StaleControllablesByModel.grid) ] });
    var main_panel114 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "hideCheckBoxLabels": true, "items": [ main_1_panel97, HelpTextsByModel_grid109, StaleControllablesByModel_grid113 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel114;
    this.before_row_edit = function(record) {
      HelpTextsByModel_grid109.on_master_changed();
      StaleControllablesByModel_grid113.on_master_changed();
    }
    Lino.contenttypes.ContentTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.Notes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 26,
  initComponent : function() {
    var date730 = new Lino.DateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date","(notes.Notes.date) ") }, "anchor": "-20" });
    var time731 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "Time", "name": "time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Time","(notes.Notes.time) ") }, "anchor": "-20" });
    var event_type732 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Event Type (Form)", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.EventTypes.detail,Lino.notes.EventTypes.insert)}, "emptyText": "Select a Event Type...", "listeners": { "render": Lino.quicktip_renderer("Event Type (Form)","(notes.Notes.event_type) ") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/event_type", "method": "GET" }) }) });
    var type733 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Note Type (Content)", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.notes.NoteTypes.detail,Lino.notes.NoteTypes.insert)}, "emptyText": "Select a Note Type...", "listeners": { "render": Lino.quicktip_renderer("Note Type (Content)","(notes.Notes.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/type", "method": "GET" }) }) });
    var main_1_panel734 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 180, "hideCheckBoxLabels": true, "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date730, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": time731, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type732, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type733, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var subject739 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Subject", "name": "subject", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Subject","(notes.Notes.subject) ") }, "anchor": "-20" });
    var project740 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.projects.Projects.detail,Lino.projects.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(notes.Notes.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/project", "method": "GET" }) }) });
    var main_2_panel741 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject739, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project740, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var company744 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Recipient (Organization)", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "companyHidden", "listeners": { "render": Lino.quicktip_renderer("Recipient (Organization)","(notes.Notes.company) ") }, "selectOnFocus": true, "emptyText": "Select a Organisation...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/company", "method": "GET" }) }) });
    var contact_person745 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Recipient (Person)", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "contact_personHidden", "listeners": { "render": Lino.quicktip_renderer("Recipient (Person)","(notes.Notes.contact_person) ") }, "selectOnFocus": true, "emptyText": "Select a Person...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/contact_person", "method": "GET" }) }) });
    var contact_role746 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "represented as", "name": "contact_role", "pageSize": 20, "emptyText": "Select a Function...", "listeners": { "render": Lino.quicktip_renderer("represented as","(notes.Notes.contact_role) ") }, "selectOnFocus": true, "hiddenName": "contact_roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/contact_role", "method": "GET" }) }) });
    var main_3_panel747 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 225, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company744, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person745, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_role746, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var id751 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(notes.Notes.id) ") }, "anchor": "-20" });
    var user752 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(notes.Notes.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/Notes/user", "method": "GET" }) }) });
    var language753 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Language", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(notes.Notes.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "et", "Estonian" ] ], "name": "language" });
    var build_time754 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "build time", "name": "build_time", "listeners": { "render": Lino.quicktip_renderer("build time","(notes.Notes.build_time) ") }, "value": "<br>", "anchor": "-20" });
    var main_4_panel755 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id751, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user752, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language753, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_time754, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var body760 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 33, "containing_panel": this, "name": "body", "title": "Body" });
    var outbox_MailsByController_grid761 = new Lino.outbox.MailsByController.GridPanel({ "flex": 66, "listeners": { "render": Lino.quicktip_renderer("Outgoing Mails","(outbox.outbox.MailsByController) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ], "preview_limit": 15, "master_panel": this });
    var main_5_panel762 = new Ext.Panel({ "flex": 55, "border": false, "layout": "hbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ body760, outbox_MailsByController_grid761 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel763 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel734, main_2_panel741, main_3_panel747, main_4_panel755, main_5_panel762 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel763;
    this.before_row_edit = function(record) {
      contact_person745.setContextValue('company', record ? record.data['companyHidden'] : undefined);
      body760.refresh();
      outbox_MailsByController_grid761.on_master_changed();
    }
    this.onRender = function(ct, position) {
      company744.on('change',Lino.chooser_handler(contact_person745,'company'));
      Lino.notes.Notes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.notes.Notes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.UploadsByController.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 17,
  initComponent : function() {
    var file1404 = Lino.file_field_handler(this,{ "autoHeight": true, "fieldLabel": "File", "name": "file", "maxLength": 100, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("File","(uploads.UploadsByController.file) ") }, "anchor": "-20" });
    var type1405 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Upload Type", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.uploads.UploadTypes.detail,Lino.uploads.UploadTypes.insert)}, "emptyText": "Select a Upload Type...", "listeners": { "render": Lino.quicktip_renderer("Upload Type","(uploads.UploadsByController.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/UploadsByController/type", "method": "GET" }) }) });
    var description1406 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Description", "name": "description", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Description","(uploads.UploadsByController.description) ") }, "anchor": "-20" });
    var main_panel1407 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 108, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": file1404, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1405, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": description1406, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1407;
    this.before_row_edit = function(record) {
      type1405.setContextValue('upload_area', record ? record.data['upload_areaHidden'] : undefined);
    }
    Lino.uploads.UploadsByController.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.Report.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var body_htmlbox1431 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "body", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer(null,"(lino.Report.body) ") } });
    var main_panel1432 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ body_htmlbox1431 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1432;
    this.before_row_edit = function(record) {
      body_htmlbox1431.refresh();
    }
    Lino.lino.Report.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 20,
  initComponent : function() {
    var overview_disp603 = new Ext.form.DisplayField({ "disabled": true, "flex": 20, "listeners": { "render": Lino.quicktip_renderer(null,"(contacts.Persons.overview) ") }, "name": "overview", "value": "<br/>", "always_enabled": true });
    var title604 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Title</span>", "name": "title", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Title","(contacts.Persons.title) Text to print before allocation and name as part of the first address line.") }, "anchor": "-20" });
    var first_name605 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">First name</span>", "name": "first_name", "listeners": { "render": Lino.quicktip_renderer("First name","(contacts.Persons.first_name) First or given name.") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var middle_name606 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Middle name</span>", "name": "middle_name", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Middle name","(contacts.Persons.middle_name) Space-separated list of all middle names.") }, "anchor": "-20" });
    var general2_1_panel607 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title604, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name605, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": middle_name606, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var last_name611 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Last name</span>", "name": "last_name", "listeners": { "render": Lino.quicktip_renderer("Last name","(contacts.Persons.last_name) Last name (family name).") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var gender612 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Gender", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Gender","(contacts.Persons.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var birth_date613 = new Lino.IncompleteDateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Birth date</span>", "name": "birth_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Birth date","(contacts.Persons.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".") }, "anchor": "-20" });
    var age_disp614 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Age", "name": "age", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Age","(contacts.Persons.age) ") }, "anchor": "-20" });
    var general2_3_panel615 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender612, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date613, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": age_disp614, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var id619 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Persons.id) ") }, "anchor": "-20" });
    var language620 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(contacts.Persons.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "et", "Estonian" ] ], "name": "language" });
    var general2_4_panel621 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id619, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language620, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var general2_panel624 = new Ext.Panel({ "flex": 40, "autoHeight": true, "layout": "form", "items": [ general2_1_panel607, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name611, "anchor": "-20", "labelAlign": "top" }, general2_3_panel615, general2_4_panel621 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var email626 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Persons.email) ") }, "anchor": "-20" });
    var phone627 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Phone", "name": "phone", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Phone","(contacts.Persons.phone) ") }, "anchor": "-20" });
    var gsm628 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("GSM","(contacts.Persons.gsm) ") }, "anchor": "-20" });
    var fax629 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Fax","(contacts.Persons.fax) ") }, "anchor": "-20" });
    var general3_panel630 = new Ext.Panel({ "flex": 40, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email626, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone627, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm628, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax629, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var general_1_panel635 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ overview_disp603, general2_panel624, general3_panel630 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var contacts_RolesByPerson_grid640 = new Lino.contacts.RolesByPerson.GridPanel({ "flex": 22, "listeners": { "render": Lino.quicktip_renderer("Contact for","(contacts.contacts.RolesByPerson) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByPerson.grid) ], "preview_limit": 15, "master_panel": this });
    var MembersByPerson_htmlbox641 = new Lino.HtmlBoxPanel({ "flex": 44, "layout": "fit", "name": "MembersByPerson", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Household memberships", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Household memberships","(contacts.Persons.MembersByPerson) ") }, "bodyStyle": "overflow-x:hidden;", "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByPerson.grid) ] });
    var LinksByHuman_htmlbox642 = new Lino.HtmlBoxPanel({ "flex": 33, "layout": "fit", "name": "LinksByHuman", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Human Links", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Human Links","(contacts.Persons.LinksByHuman) ") }, "bodyStyle": "overflow-x:hidden;", "tools": [ Lino.show_in_own_window_button(Lino.humanlinks.LinksByHuman.grid) ] });
    var general_2_panel643 = new Ext.Panel({ "flex": 45, "border": false, "layout": "hbox", "labelWidth": 198, "hideCheckBoxLabels": true, "items": [ contacts_RolesByPerson_grid640, MembersByPerson_htmlbox641, LinksByHuman_htmlbox642 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel644 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel635, general_2_panel643 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var addresses_AddressesByPartner_grid650 = new Lino.addresses.AddressesByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Addresses","(addresses.addresses.AddressesByPartner) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.addresses.AddressesByPartner.grid) ] });
    var remarks651 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remarks","(contacts.Persons.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var sepa_AccountsByPartner_grid652 = new Lino.sepa.AccountsByPartner.GridPanel({ "flex": 64, "listeners": { "render": Lino.quicktip_renderer("Accounts","(sepa.sepa.AccountsByPartner) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.sepa.AccountsByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var contact_2_panel653 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ { "items": remarks651, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 35 }, sepa_AccountsByPartner_grid652 ], "region": "center", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 72, "border": false, "frame": false, "labelAlign": "top" });
    var contact_panel655 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Contact", "hideCheckBoxLabels": true, "items": [ addresses_AddressesByPartner_grid650, contact_2_panel653 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var url656 = new Lino.URLField({ "autoHeight": true, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("URL","(contacts.Persons.url) ") }, "anchor": "-20" });
    var created657 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "listeners": { "render": Lino.quicktip_renderer("Created","(contacts.Persons.created) ") }, "value": "<br>", "anchor": "-20" });
    var modified658 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "listeners": { "render": Lino.quicktip_renderer("Modified","(contacts.Persons.modified) ") }, "value": "<br>", "anchor": "-20" });
    var misc_2_panel659 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created657, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified658, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var reception_AppointmentsByPartner_grid662 = new Lino.reception.AppointmentsByPartner.GridPanel({ "flex": 71, "listeners": { "render": Lino.quicktip_renderer("Appointments","(reception.reception.AppointmentsByPartner) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.reception.AppointmentsByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var misc_panel663 = new Ext.Panel({ "layout": "vbox", "title": "Miscellaneous", "items": [ { "items": url656, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, misc_2_panel659, reception_AppointmentsByPartner_grid662 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "labelWidth": 36, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel665 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel644, contact_panel655, misc_panel663 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel665;
    this.before_row_edit = function(record) {
      contacts_RolesByPerson_grid640.on_master_changed();
      MembersByPerson_htmlbox641.refresh();
      LinksByHuman_htmlbox642.refresh();
      addresses_AddressesByPartner_grid650.on_master_changed();
      sepa_AccountsByPartner_grid652.on_master_changed();
      reception_AppointmentsByPartner_grid662.on_master_changed();
    }
    Lino.contacts.Persons.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
  }
});


Lino.cal.Events.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 44,
  initComponent : function() {
    var event_type846 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Event Type", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail,Lino.cal.EventTypes.insert)}, "emptyText": "Select a Event Type...", "listeners": { "render": Lino.quicktip_renderer("Event Type","(cal.Events.event_type) ") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/event_type", "method": "GET" }) }) });
    var summary847 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Summary", "name": "summary", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Summary","(cal.Events.summary) ") }, "anchor": "-20" });
    var user848 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Responsible user", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Responsible user","(cal.Events.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }) });
    var assigned_to849 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Assigned to", "name": "assigned_to", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "assigned_toHidden", "listeners": { "render": Lino.quicktip_renderer("Assigned to","(cal.Events.assigned_to) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/assigned_to", "method": "GET" }) }) });
    var main_1_panel850 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type846, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary847, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user848, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": assigned_to849, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var start_date855 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Start date", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start date","(cal.Events.start_date) ") }, "anchor": "-20" });
    var start_time856 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "Start time", "name": "start_time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start time","(cal.Events.start_time) ") }, "anchor": "-20" });
    var start_panel857 = new Ext.Panel({ "flex": 38, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 61, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date855, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time856, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var end_date860 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "End Date", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("End Date","(cal.Events.end_date) ") }, "anchor": "-20" });
    var end_time861 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "End Time", "name": "end_time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("End Time","(cal.Events.end_time) ") }, "anchor": "-20" });
    var end_panel862 = new Ext.Panel({ "flex": 38, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 61, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date860, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time861, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var state865 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "State", "allowBlank": false, "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("State","(cal.Events.state) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.EventStates, "name": "state" });
    var main_2_panel866 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 54, "hideCheckBoxLabels": true, "items": [ start_panel857, end_panel862, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state865, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var room868 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Room", "name": "room", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Rooms.detail,Lino.cal.Rooms.insert)}, "emptyText": "Select a Room...", "listeners": { "render": Lino.quicktip_renderer("Room","(cal.Events.room) ") }, "selectOnFocus": true, "hiddenName": "roomHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/room", "method": "GET" }) }) });
    var priority869 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Priority", "name": "priority", "pageSize": 20, "emptyText": "Select a Priority...", "listeners": { "render": Lino.quicktip_renderer("Priority","(cal.Events.priority) ") }, "selectOnFocus": true, "hiddenName": "priorityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/priority", "method": "GET" }) }) });
    var access_class870 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Access Class</span>", "name": "access_class", "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Access Class","(cal.Events.access_class) Whether this is private, public or between.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var transparent871 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "transparent", "listeners": { "render": Lino.quicktip_renderer("Transparent","(cal.Events.transparent) Indicates that this Event shouldn't prevent other Events at the same time.") }, "boxLabel": "Transparent", "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel872 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": room868, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": priority869, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class870, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": transparent871, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var owner_disp877 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Controlled by", "anchor": "-20", "name": "owner" });
    var created878 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "listeners": { "render": Lino.quicktip_renderer("Created","(cal.Events.created) ") }, "value": "<br>", "anchor": "-20" });
    var modified879 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "listeners": { "render": Lino.quicktip_renderer("Modified","(cal.Events.modified) ") }, "value": "<br>", "anchor": "-20" });
    var main_4_panel880 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp877, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created878, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified879, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description884 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(cal.Events.description) ") }, "fieldLabel": "Description", "name": "description", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var GuestsByEvent_grid928 = new Lino.cal.GuestsByEvent.GridPanel({ "flex": 35, "listeners": { "render": Lino.quicktip_renderer("Participants","(cal.cal.GuestsByEvent) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.GuestsByEvent.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel929 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ main_1_panel850, main_2_panel866, main_3_panel872, main_4_panel880, { "items": description884, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 35 }, GuestsByEvent_grid928 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel929;
    this.before_row_edit = function(record) {
      GuestsByEvent_grid928.on_master_changed();
    }
    Lino.cal.Events.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Events.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 44,
  initComponent : function() {
    var event_type931 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Event Type", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail,Lino.cal.EventTypes.insert)}, "emptyText": "Select a Event Type...", "listeners": { "render": Lino.quicktip_renderer("Event Type","(cal.Events.event_type) ") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/event_type", "method": "GET" }) }) });
    var summary932 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Summary", "name": "summary", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Summary","(cal.Events.summary) ") }, "anchor": "-20" });
    var main_1_panel933 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type931, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary932, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var start_date936 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Start date", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start date","(cal.Events.start_date) ") }, "anchor": "-20" });
    var start_time937 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "Start time", "name": "start_time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start time","(cal.Events.start_time) ") }, "anchor": "-20" });
    var start_panel938 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 61, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date936, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time937, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var end_date941 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "End Date", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("End Date","(cal.Events.end_date) ") }, "anchor": "-20" });
    var end_time942 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "End Time", "name": "end_time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("End Time","(cal.Events.end_time) ") }, "anchor": "-20" });
    var end_panel943 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 61, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date941, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time942, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var main_2_panel946 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ start_panel938, end_panel943 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "anchor": "-20", "labelAlign": "top" });
    var room947 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Room", "name": "room", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Rooms.detail,Lino.cal.Rooms.insert)}, "emptyText": "Select a Room...", "listeners": { "render": Lino.quicktip_renderer("Room","(cal.Events.room) ") }, "selectOnFocus": true, "hiddenName": "roomHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/room", "method": "GET" }) }) });
    var priority948 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Priority", "name": "priority", "pageSize": 20, "emptyText": "Select a Priority...", "listeners": { "render": Lino.quicktip_renderer("Priority","(cal.Events.priority) ") }, "selectOnFocus": true, "hiddenName": "priorityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/priority", "method": "GET" }) }) });
    var access_class949 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Access Class</span>", "name": "access_class", "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Access Class","(cal.Events.access_class) Whether this is private, public or between.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var transparent950 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "transparent", "listeners": { "render": Lino.quicktip_renderer("Transparent","(cal.Events.transparent) Indicates that this Event shouldn't prevent other Events at the same time.") }, "boxLabel": "Transparent", "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel951 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": room947, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": priority948, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class949, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": transparent950, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel956 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel933, main_2_panel946, main_3_panel951 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel956;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Events.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.Mails.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 13,
  initComponent : function() {
    var project363 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.projects.Projects.detail,Lino.projects.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(outbox.Mails.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var subject364 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Subject", "name": "subject", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Subject","(outbox.Mails.subject) ") }, "anchor": "-20" });
    var body365 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 71, "containing_panel": this, "name": "body", "title": "Body" });
    var main_panel366 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": project363, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": subject364, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, body365 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel366;
    this.before_row_edit = function(record) {
      body365.refresh();
    }
    Lino.outbox.Mails.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.About.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var server_status_disp1434 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Server status", "name": "server_status", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Server status","(about.About.server_status) ") }, "anchor": "-20" });
    var main_panel1435 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "html": "<div class=\"htmlText\"><span><a href=\"http://www.lino-framework.org\" target=\"_blank\">Lino</a> 1.6.14, <a href=\"http://www.djangoproject.com\" target=\"_blank\">Django</a> 1.6.7, <a href=\"http://www.python.org/\" target=\"_blank\">Python</a> 2.7.4, <a href=\"http://babel.edgewall.org/\" target=\"_blank\">Babel</a> 1.3, <a href=\"http://jinja.pocoo.org/\" target=\"_blank\">Jinja</a> 2.7.2, <a href=\"http://sphinx-doc.org/\" target=\"_blank\">Sphinx</a> 1.3a0, <a href=\"http://labix.org/python-dateutil\" target=\"_blank\">python-dateutil</a> 2.1, <a href=\"http://pypi.python.org/pypi/odfpy\" target=\"_blank\">OdfPy</a> ODFPY/0.9.6, <a href=\"http://docutils.sourceforge.net/\" target=\"_blank\">docutils</a> 0.11, <a href=\"https://fedorahosted.org/suds/\" target=\"_blank\">suds</a> 0.4, <a href=\"http://pyyaml.org/\" target=\"_blank\">PyYaml</a> 3.10, <a href=\"http://appyframework.org/pod.html\" target=\"_blank\">Appy</a> 0.9.0 (2014/06/23 22:15), <a href=\"http://www.sencha.com\" target=\"_blank\">ExtJS</a> <a href=\"#\" onclick=\"alert('ExtJS client version is ' + Ext.version);\" title=\"Click to see ExtJS client version\">(version)</a>, <a href=\"http://www.famfamfam.com/lab/icons/silk/\" target=\"_blank\">Silk Icons</a> 1.3, <a href=\"http://getbootstrap.com\" target=\"_blank\">Bootstrap</a> 3.x</span><p>Server uptime : <b>Monday, December 8, 2014 at 05:55:06.164240</b></p><p>Source timestamps:</p><ul><li>lino : <b>Monday, December 8, 2014 at 05:52:48.191267</b></li><li>django : <b>Monday, October 27, 2014 at 16:34:33.459643</b></li><li>atelier : <b>Friday, August 15, 2014 at 04:18:10.726150</b></li></ul></div>", "xtype": "label" }, { "items": server_status_disp1434, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1435;
    this.before_row_edit = function(record) {
    }
    Lino.about.About.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.Users.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 7,
  initComponent : function() {
    var username40 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Username</span>", "name": "username", "listeners": { "render": Lino.quicktip_renderer("Username","(users.Users.username) Required. Must be unique.") }, "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var profile41 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">User Profile</span>", "name": "profile", "hiddenName": "profileHidden", "listeners": { "render": Lino.quicktip_renderer("User Profile","(users.Users.profile) Users with an empty `profile` field are considered inactive and cannot log in.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.users.UserProfiles) });
    var partner42 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "hiddenName": "partnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(users.Users.partner) ") }, "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var box1_1_panel43 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username40, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile41, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner42, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name47 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "First name", "name": "first_name", "maxLength": 30, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("First name","(users.Users.first_name) ") }, "anchor": "-20" });
    var last_name48 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Last name", "name": "last_name", "maxLength": 30, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Last name","(users.Users.last_name) ") }, "anchor": "-20" });
    var initials49 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Initials", "name": "initials", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Initials","(users.Users.initials) ") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var box1_2_panel50 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name47, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name48, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": initials49, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email54 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "e-mail address", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("e-mail address","(users.Users.email) ") }, "anchor": "-20" });
    var language55 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Language", "name": "language", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(users.Users.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "et", "Estonian" ] ] });
    var box1_3_panel56 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email54, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language55, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var id59 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(users.Users.id) ") }, "anchor": "-20" });
    var created60 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "listeners": { "render": Lino.quicktip_renderer("Created","(users.Users.created) ") }, "value": "<br>", "anchor": "-20" });
    var modified61 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "listeners": { "render": Lino.quicktip_renderer("Modified","(users.Users.modified) ") }, "value": "<br>", "anchor": "-20" });
    var box1_4_panel62 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id59, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created60, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified61, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box1_panel66 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ box1_1_panel43, box1_2_panel50, box1_3_panel56, box1_4_panel62 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var remarks67 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remarks","(users.Users.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var AuthoritiesGiven_grid70 = new Lino.users.AuthoritiesGiven.GridPanel({ "flex": 33, "hide_top_toolbar": true, "containing_panel": this, "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Authorities given","(users.users.AuthoritiesGiven) ") }, "tools": [ Lino.show_in_own_window_button(Lino.users.AuthoritiesGiven.grid) ], "hideHeaders": true });
    var main_2_panel71 = new Ext.Panel({ "flex": 55, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": remarks67, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 66 }, AuthoritiesGiven_grid70 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel73 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ box1_panel66, main_2_panel71 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel73;
    this.before_row_edit = function(record) {
      AuthoritiesGiven_grid70.on_master_changed();
    }
    Lino.users.Users.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    partner42.on("change", function(){ this.save() }, this);
  }
});


Lino.users.Users.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 7,
  initComponent : function() {
    var username74 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Username</span>", "name": "username", "listeners": { "render": Lino.quicktip_renderer("Username","(users.Users.username) Required. Must be unique.") }, "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var email75 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "e-mail address", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("e-mail address","(users.Users.email) ") }, "anchor": "-20" });
    var main_1_panel76 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username74, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email75, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name79 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "First name", "name": "first_name", "maxLength": 30, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("First name","(users.Users.first_name) ") }, "anchor": "-20" });
    var last_name80 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Last name", "name": "last_name", "maxLength": 30, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Last name","(users.Users.last_name) ") }, "anchor": "-20" });
    var main_2_panel81 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name79, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name80, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var partner84 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "hiddenName": "partnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(users.Users.partner) ") }, "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var language85 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Language", "name": "language", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(users.Users.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "et", "Estonian" ] ] });
    var profile86 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">User Profile</span>", "name": "profile", "hiddenName": "profileHidden", "listeners": { "render": Lino.quicktip_renderer("User Profile","(users.Users.profile) Users with an empty `profile` field are considered inactive and cannot log in.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.users.UserProfiles) });
    var main_4_panel87 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 47, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language85, "labelAlign": "top" }, { "flex": 52, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile86, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel90 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ main_1_panel76, main_2_panel81, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner84, "anchor": "-20", "labelAlign": "top" }, main_4_panel87 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel90;
    this.before_row_edit = function(record) {
    }
    Lino.users.Users.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.TextFieldTemplates.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 5,
  initComponent : function() {
    var id118 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(system.TextFieldTemplates.id) ") }, "anchor": "-20" });
    var name119 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(system.TextFieldTemplates.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user120 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(system.TextFieldTemplates.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/user", "method": "GET" }) }) });
    var main_1_panel121 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id118, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name119, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user120, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 108, "border": false, "frame": false, "labelAlign": "top" });
    var description125 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(system.TextFieldTemplates.description) ") }, "fieldLabel": "Description", "name": "description", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var text126 = new Lino.RichTextPanel({ "flex": 5, "split": true, "containing_panel": this, "selectOnFocus": true, "region": "south", "title": "Template Text", "name": "text" });
    var main_panel127 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ main_1_panel121, { "flex": 5, "layout": "form", "xtype": "panel", "items": description125, "region": "center", "labelAlign": "top", "split": true }, text126 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel127;
    this.before_row_edit = function(record) {
      text126.refresh();
    }
    Lino.system.TextFieldTemplates.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.excerpts.Excerpts.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 12,
  initComponent : function() {
    var id428 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(excerpts.Excerpts.id) ") }, "anchor": "-20" });
    var excerpt_type429 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Excerpt Type", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.excerpts.ExcerptTypes.detail,Lino.excerpts.ExcerptTypes.insert)}, "emptyText": "Select a Excerpt Type...", "listeners": { "render": Lino.quicktip_renderer("Excerpt Type","(excerpts.Excerpts.excerpt_type) ") }, "selectOnFocus": true, "hiddenName": "excerpt_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/excerpt_type", "method": "GET" }) }), "name": "excerpt_type" });
    var project430 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.projects.Projects.detail,Lino.projects.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(excerpts.Excerpts.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/project", "method": "GET" }) }) });
    var main_1_panel431 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id428, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": excerpt_type429, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project430, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user435 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(excerpts.Excerpts.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/user", "method": "GET" }) }) });
    var build_method436 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Build method", "allowBlank": false, "hiddenName": "build_methodHidden", "listeners": { "render": Lino.quicktip_renderer("Build method","(excerpts.Excerpts.build_method) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.BuildMethods, "name": "build_method" });
    var main_2_panel437 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user435, "labelAlign": "top" }, { "flex": 67, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method436, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var company440 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Recipient (Organization)", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "companyHidden", "listeners": { "render": Lino.quicktip_renderer("Recipient (Organization)","(excerpts.Excerpts.company) ") }, "selectOnFocus": true, "emptyText": "Select a Organisation...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/company", "method": "GET" }) }) });
    var contact_person441 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Recipient (Person)", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "contact_personHidden", "listeners": { "render": Lino.quicktip_renderer("Recipient (Person)","(excerpts.Excerpts.contact_person) ") }, "selectOnFocus": true, "emptyText": "Select a Person...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/contact_person", "method": "GET" }) }) });
    var language442 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Language", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(excerpts.Excerpts.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "et", "Estonian" ] ], "name": "language" });
    var main_3_panel443 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 225, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company440, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person441, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language442, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var owner_disp447 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Controlled by", "anchor": "-20", "name": "owner" });
    var build_time448 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "build time", "name": "build_time", "listeners": { "render": Lino.quicktip_renderer("build time","(excerpts.Excerpts.build_time) ") }, "value": "<br>", "anchor": "-20" });
    var main_4_panel449 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp447, "labelAlign": "top" }, { "flex": 61, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_time448, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var outbox_MailsByController_grid463 = new Lino.outbox.MailsByController.GridPanel({ "flex": 55, "listeners": { "render": Lino.quicktip_renderer("Outgoing Mails","(outbox.outbox.MailsByController) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel464 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel431, main_2_panel437, main_3_panel443, main_4_panel449, outbox_MailsByController_grid463 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel464;
    this.before_row_edit = function(record) {
      excerpt_type429.setContextValue('owner', record ? record.data['owner'] : undefined);
      contact_person441.setContextValue('company', record ? record.data['companyHidden'] : undefined);
      outbox_MailsByController_grid463.on_master_changed();
    }
    this.onRender = function(ct, position) {
      owner_disp447.on('change',Lino.chooser_handler(excerpt_type429,'owner'));
      company440.on('change',Lino.chooser_handler(contact_person441,'company'));
      Lino.excerpts.Excerpts.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.excerpts.Excerpts.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.changes.Changes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 6,
  disable_editing: true,
  initComponent : function() {
    var time134 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "time", "name": "time", "value": "<br>", "listeners": { "render": Lino.quicktip_renderer("time","(changes.Changes.time) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user135 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "User", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "emptyText": "Select a User...", "listeners": { "render": Lino.quicktip_renderer("User","(changes.Changes.user) ") }, "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/user", "method": "GET" }) }), "name": "user" });
    var type136 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Change Type", "allowBlank": false, "hiddenName": "typeHidden", "listeners": { "render": Lino.quicktip_renderer("Change Type","(changes.Changes.type) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.ChangeTypes, "name": "type" });
    var master_disp137 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Master", "anchor": "-20", "name": "master" });
    var object_disp138 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Object", "anchor": "-20", "name": "object" });
    var id139 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(changes.Changes.id) ") }, "anchor": "-20" });
    var main_1_panel140 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": time134, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user135, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type136, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": master_disp137, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": object_disp138, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id139, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var diff147 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Changes","(changes.Changes.diff) ") }, "fieldLabel": "Changes", "name": "diff", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var main_panel148 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ main_1_panel140, { "items": diff147, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel148;
    this.before_row_edit = function(record) {
    }
    Lino.changes.Changes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Calendars.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 43,
  initComponent : function() {
    var name976 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(cal.Calendars.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_et977 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(cal.Calendars.name_et) ") }, "anchor": "-20" });
    var main_1_panel978 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name976, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et977, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var color981 = new Ext.form.NumberField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "color", "name": "color", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("color","(cal.Calendars.color) ") }, "anchor": "-20" });
    var main_panel982 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 54, "autoScroll": false, "items": [ main_1_panel978, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": color981, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel982;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Calendars.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Calendars.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 43,
  initComponent : function() {
    var name959 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(cal.Calendars.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_et960 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(cal.Calendars.name_et) ") }, "anchor": "-20" });
    var color961 = new Ext.form.NumberField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "color", "name": "color", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("color","(cal.Calendars.color) ") }, "anchor": "-20" });
    var id962 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.Calendars.id) ") }, "anchor": "-20" });
    var main_1_panel963 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name959, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et960, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": color961, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id962, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description968 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 63, "containing_panel": this, "name": "description", "title": "Description" });
    var SubscriptionsByCalendar_grid973 = new Lino.cal.SubscriptionsByCalendar.GridPanel({ "flex": 36, "listeners": { "render": Lino.quicktip_renderer("Subscriptions","(cal.cal.SubscriptionsByCalendar) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.SubscriptionsByCalendar.grid) ], "preview_limit": 15, "master_panel": this });
    var main_2_panel974 = new Ext.Panel({ "flex": 83, "border": false, "layout": "hbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ description968, SubscriptionsByCalendar_grid973 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel975 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel963, main_2_panel974 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel975;
    this.before_row_edit = function(record) {
      description968.refresh();
      SubscriptionsByCalendar_grid973.on_master_changed();
    }
    Lino.cal.Calendars.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.humanlinks.Links.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 31,
  initComponent : function() {
    var parent1294 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Parent", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "emptyText": "Select a Person...", "listeners": { "render": Lino.quicktip_renderer("Parent","(humanlinks.Links.parent) ") }, "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/humanlinks/Links/parent", "method": "GET" }) }), "name": "parent" });
    var child1295 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Child", "name": "child", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "childHidden", "listeners": { "render": Lino.quicktip_renderer("Child","(humanlinks.Links.child) ") }, "selectOnFocus": true, "emptyText": "Select a Person...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/humanlinks/Links/child", "method": "GET" }) }) });
    var type1296 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Parency type", "allowBlank": false, "hiddenName": "typeHidden", "listeners": { "render": Lino.quicktip_renderer("Parency type","(humanlinks.Links.type) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.humanlinks.LinkTypes, "name": "type" });
    var main_panel1297 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 117, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent1294, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": child1295, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1296, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1297;
    this.before_row_edit = function(record) {
    }
    Lino.humanlinks.Links.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.UploadTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 16,
  initComponent : function() {
    var id498 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(uploads.UploadTypes.id) ") }, "anchor": "-20" });
    var upload_area499 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Upload Area", "allowBlank": false, "hiddenName": "upload_areaHidden", "listeners": { "render": Lino.quicktip_renderer("Upload Area","(uploads.UploadTypes.upload_area) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.uploads.UploadAreas, "name": "upload_area" });
    var wanted500 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "wanted", "listeners": { "render": Lino.quicktip_renderer("Wanted","(uploads.UploadTypes.wanted) Add a (+) button when there is no upload of this type.") }, "boxLabel": "Wanted", "selectOnFocus": true, "anchor": "-20" });
    var max_number501 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Max. number</span>", "name": "max_number", "value": -1, "listeners": { "render": Lino.quicktip_renderer("Max. number","(uploads.UploadTypes.max_number) No need to upload more uploads than N of this type.\n-1 means no limit.") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel502 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id498, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": upload_area499, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": wanted500, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": max_number501, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var name507 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(uploads.UploadTypes.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_et508 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(uploads.UploadTypes.name_et) ") }, "anchor": "-20" });
    var main_2_panel509 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name507, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et508, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var uploads_UploadsByType_grid546 = new Lino.uploads.UploadsByType.GridPanel({ "flex": 71, "listeners": { "render": Lino.quicktip_renderer("Uploads","(uploads.uploads.UploadsByType) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByType.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel547 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel502, main_2_panel509, uploads_UploadsByType_grid546 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel547;
    this.before_row_edit = function(record) {
      uploads_UploadsByType_grid546.on_master_changed();
    }
    Lino.uploads.UploadTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 35,
  initComponent : function() {
    var start_date984 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Start date", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start date","(cal.Tasks.start_date) ") }, "anchor": "-20" });
    var due_date985 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Due date", "name": "due_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Due date","(cal.Tasks.due_date) ") }, "anchor": "-20" });
    var id986 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.Tasks.id) ") }, "anchor": "-20" });
    var workflow_buttons_disp987 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Workflow", "name": "workflow_buttons", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Workflow","(cal.Tasks.workflow_buttons) ") }, "anchor": "-20" });
    var main_1_panel988 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date984, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": due_date985, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id986, "labelAlign": "top" }, { "flex": 49, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp987, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var summary993 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Summary", "name": "summary", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Summary","(cal.Tasks.summary) ") }, "anchor": "-20" });
    var user994 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(cal.Tasks.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var project995 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.projects.Projects.detail,Lino.projects.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(cal.Tasks.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_3_panel996 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user994, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project995, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var owner_disp999 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Controlled by", "anchor": "-20", "name": "owner" });
    var created1000 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "listeners": { "render": Lino.quicktip_renderer("Created","(cal.Tasks.created) ") }, "value": "<br>", "anchor": "-20" });
    var modified1001 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "listeners": { "render": Lino.quicktip_renderer("Modified","(cal.Tasks.modified) ") }, "value": "<br>", "anchor": "-20" });
    var main_4_panel1002 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp999, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1000, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1001, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description1006 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(cal.Tasks.description) ") }, "fieldLabel": "Description", "name": "description", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var main_panel1007 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ main_1_panel988, { "items": summary993, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, main_3_panel996, main_4_panel1002, { "items": description1006, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 45 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1007;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Tasks.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.EventTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 27,
  initComponent : function() {
    var id1251 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(notes.EventTypes.id) ") }, "anchor": "-20" });
    var name1252 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(notes.EventTypes.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_et1253 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(notes.EventTypes.name_et) ") }, "anchor": "-20" });
    var main_1_panel1254 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1251, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1252, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1253, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 153, "border": false, "frame": false, "labelAlign": "top" });
    var remark1258 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remark","(notes.EventTypes.remark) ") }, "fieldLabel": "Remark", "name": "remark", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var notes_NotesByEventType_grid1276 = new Lino.notes.NotesByEventType.GridPanel({ "flex": 6, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Notes","(notes.notes.NotesByEventType) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.notes.NotesByEventType.grid) ] });
    var main_panel1277 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 63, "hideCheckBoxLabels": true, "items": [ main_1_panel1254, { "flex": 3, "layout": "form", "xtype": "panel", "items": remark1258, "region": "center", "labelAlign": "top", "split": true }, notes_NotesByEventType_grid1276 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1277;
    this.before_row_edit = function(record) {
      notes_NotesByEventType_grid1276.on_master_changed();
    }
    Lino.notes.EventTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.EventTypes.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 38,
  initComponent : function() {
    var name1107 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(cal.EventTypes.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_et1108 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(cal.EventTypes.name_et) ") }, "anchor": "-20" });
    var main_1_panel1109 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1107, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1108, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var event_label1112 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Event label", "name": "event_label", "value": "Appointment", "listeners": { "render": Lino.quicktip_renderer("Event label","(cal.EventTypes.event_label) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var event_label_et1113 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Event label (et)", "name": "event_label_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Event label (et)","(cal.EventTypes.event_label_et) ") }, "anchor": "-20" });
    var main_2_panel1114 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label1112, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label_et1113, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1117 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1109, main_2_panel1114 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1117;
    this.before_row_edit = function(record) {
    }
    Lino.cal.EventTypes.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.addresses.Addresses.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 24,
  initComponent : function() {
    var country585 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Country","(addresses.Addresses.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/addresses/Addresses/country", "method": "GET" }) }) });
    var city586 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "City", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("City","(addresses.Addresses.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/addresses/Addresses/city", "method": "GET" }) }) });
    var main_1_panel587 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country585, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city586, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street590 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Street","(addresses.Addresses.street) Name of street, without house number.") }, "anchor": "-20" });
    var street_no591 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("No.","(addresses.Addresses.street_no) House number.") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var street_box592 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Box","(addresses.Addresses.street_box) Text to print after street nuber on the same line.") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel593 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street590, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no591, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box592, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var address_type597 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Address type", "name": "address_type", "hiddenName": "address_typeHidden", "listeners": { "render": Lino.quicktip_renderer("Address type","(addresses.Addresses.address_type) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.addresses.AddressTypes) });
    var remark598 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Remark", "name": "remark", "maxLength": 50, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Remark","(addresses.Addresses.remark) ") }, "anchor": "-20" });
    var main_3_panel599 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": address_type597, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": remark598, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel602 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel587, main_2_panel593, main_3_panel599 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel602;
    this.before_row_edit = function(record) {
      city586.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city586.setContextValue('region', record ? record.data['regionHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      country585.on('change',Lino.chooser_handler(city586,'country'));
      Lino.addresses.Addresses.InsertFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.addresses.Addresses.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Countries.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 9,
  initComponent : function() {
    var isocode162 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">ISO code</span>", "name": "isocode", "boxMinWidth": Lino.chars2width(4), "listeners": { "render": Lino.quicktip_renderer("ISO code","(countries.Countries.isocode)         The two-letter code for this country as defined by ISO 3166-1.\n        For countries that no longer exist it may be a 4-letter code.") }, "maxLength": 4, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name163 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(countries.Countries.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_et164 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(countries.Countries.name_et) ") }, "anchor": "-20" });
    var short_code165 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Short code</span>", "name": "short_code", "boxMinWidth": Lino.chars2width(4), "listeners": { "render": Lino.quicktip_renderer("Short code","(countries.Countries.short_code) A short abbreviation for regional usage. Obsolete.") }, "maxLength": 4, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel166 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": isocode162, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name163, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et164, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": short_code165, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var countries_PlacesByCountry_grid333 = new Lino.countries.PlacesByCountry.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Places","(countries.countries.PlacesByCountry) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.countries.PlacesByCountry.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel334 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel166, countries_PlacesByCountry_grid333 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel334;
    this.before_row_edit = function(record) {
      countries_PlacesByCountry_grid333.on_master_changed();
    }
    Lino.countries.Countries.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 19,
  initComponent : function() {
    var name778 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Companies.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language779 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(contacts.Companies.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "et", "Estonian" ] ], "name": "language" });
    var email780 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Companies.email) ") }, "anchor": "-20" });
    var main_2_panel781 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language779, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email780, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type784 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Organization type", "name": "type", "pageSize": 20, "emptyText": "Select a Organization type...", "listeners": { "render": Lino.quicktip_renderer("Organization type","(contacts.Companies.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var id785 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Companies.id) ") }, "anchor": "-20" });
    var main_3_panel786 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type784, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id785, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel789 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name778, "anchor": "-20", "labelAlign": "top" }, main_2_panel781, main_3_panel786 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel789;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Companies.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Places.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 10,
  initComponent : function() {
    var name178 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(countries.Places.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_et179 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(countries.Places.name_et) ") }, "anchor": "-20" });
    var country180 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Country", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Country","(countries.Places.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Places/country", "method": "GET" }) }), "name": "country" });
    var main_1_panel181 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name178, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et179, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country180, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var type185 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Place Type", "name": "type", "hiddenName": "typeHidden", "listeners": { "render": Lino.quicktip_renderer("Place Type","(countries.Places.type) ") }, "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Places/type", "method": "GET" }) }) });
    var parent186 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Part of</span>", "name": "parent", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Part of","(countries.Places.parent) The superordinate geographic place         of which this place is a part.") }, "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Places/parent", "method": "GET" }) }) });
    var zip_code187 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "zip code", "name": "zip_code", "boxMinWidth": Lino.chars2width(8), "listeners": { "render": Lino.quicktip_renderer("zip code","(countries.Places.zip_code) ") }, "maxLength": 8, "selectOnFocus": true, "anchor": "-20" });
    var id188 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(countries.Places.id) ") }, "anchor": "-20" });
    var main_2_panel189 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type185, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent186, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code187, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id188, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var PlacesByPlace_grid330 = new Lino.countries.PlacesByPlace.GridPanel({ "flex": 41, "listeners": { "render": Lino.quicktip_renderer("Subdivisions","(countries.countries.PlacesByPlace) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.countries.PlacesByPlace.grid) ], "preview_limit": 15, "master_panel": this });
    var contacts_PartnersByCity_grid331 = new Lino.contacts.PartnersByCity.GridPanel({ "flex": 41, "listeners": { "render": Lino.quicktip_renderer("Partners","(contacts.contacts.PartnersByCity) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.PartnersByCity.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel332 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel181, main_2_panel189, PlacesByPlace_grid330, contacts_PartnersByCity_grid331 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel332;
    this.before_row_edit = function(record) {
      type185.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      PlacesByPlace_grid330.on_master_changed();
      contacts_PartnersByCity_grid331.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country180.on('change',Lino.chooser_handler(type185,'country'));
      Lino.countries.Places.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.countries.Places.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 40,
  initComponent : function() {
    var event906 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Event", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.OneEvent.detail,Lino.cal.OneEvent.insert)}, "emptyText": "Select a Event...", "listeners": { "render": Lino.quicktip_renderer("Event","(cal.Guests.event) ") }, "selectOnFocus": true, "hiddenName": "eventHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/event", "method": "GET" }) }), "name": "event" });
    var partner907 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "emptyText": "Select a Partner...", "listeners": { "render": Lino.quicktip_renderer("Partner","(cal.Guests.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }), "name": "partner" });
    var role908 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Role", "name": "role", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.GuestRoles.detail,Lino.cal.GuestRoles.insert)}, "emptyText": "Select a Guest Role...", "listeners": { "render": Lino.quicktip_renderer("Role","(cal.Guests.role) ") }, "selectOnFocus": true, "hiddenName": "roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/role", "method": "GET" }) }) });
    var main_1_panel909 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event906, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner907, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": role908, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var state913 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "State", "allowBlank": false, "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("State","(cal.Guests.state) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.GuestStates, "name": "state" });
    var remark914 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Remark", "name": "remark", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Remark","(cal.Guests.remark) ") }, "anchor": "-20" });
    var workflow_buttons_disp915 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Workflow", "name": "workflow_buttons", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Workflow","(cal.Guests.workflow_buttons) ") }, "anchor": "-20" });
    var main_2_panel916 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state913, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": remark914, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp915, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel920 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel909, main_2_panel916 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel920;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Guests.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.notes.NoteTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 28,
  initComponent : function() {
    var id1206 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(notes.NoteTypes.id) ") }, "anchor": "-20" });
    var name1207 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(notes.NoteTypes.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_et1208 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(notes.NoteTypes.name_et) ") }, "anchor": "-20" });
    var main_1_panel1209 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1206, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1207, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1208, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var build_method1213 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Build method", "name": "build_method", "hiddenName": "build_methodHidden", "listeners": { "render": Lino.quicktip_renderer("Build method","(notes.NoteTypes.build_method) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.BuildMethods) });
    var template1214 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Template", "name": "template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Template","(notes.NoteTypes.template) ") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NoteTypes/template", "method": "GET" }) }), "anchor": "-20" });
    var email_template1215 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Email template</span>", "name": "email_template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Email template","(notes.NoteTypes.email_template) The name of the file to be used as template when creating an email from a mailable of this type.") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/notes/NoteTypes/email_template", "method": "GET" }) }), "anchor": "-20" });
    var attach_to_email1216 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "attach_to_email", "listeners": { "render": Lino.quicktip_renderer("Attach to email","(notes.NoteTypes.attach_to_email) Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "boxLabel": "Attach to email", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel1217 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method1213, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template1214, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template1215, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email1216, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark1222 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remark","(notes.NoteTypes.remark) ") }, "fieldLabel": "Remark", "name": "remark", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var notes_NotesByType_grid1240 = new Lino.notes.NotesByType.GridPanel({ "flex": 41, "listeners": { "render": Lino.quicktip_renderer("Notes","(notes.notes.NotesByType) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.notes.NotesByType.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1241 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 63, "hideCheckBoxLabels": true, "items": [ main_1_panel1209, main_2_panel1217, { "items": remark1222, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 41 }, notes_NotesByType_grid1240 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1241;
    this.before_row_edit = function(record) {
      template1214.setContextValue('build_method', record ? record.data['build_methodHidden'] : undefined);
      notes_NotesByType_grid1240.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method1213.on('change',Lino.chooser_handler(template1214,'build_method'));
      Lino.notes.NoteTypes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.notes.NoteTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.addresses.Addresses.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 24,
  initComponent : function() {
    var country556 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Country","(addresses.Addresses.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/addresses/Addresses/country", "method": "GET" }) }) });
    var city557 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "City", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("City","(addresses.Addresses.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/addresses/Addresses/city", "method": "GET" }) }) });
    var zip_code558 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Zip code", "name": "zip_code", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Zip code","(addresses.Addresses.zip_code) ") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel559 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country556, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city557, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code558, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr1563 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line before street</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Address line before street","(addresses.Addresses.addr1) Address line before street") }, "anchor": "-20" });
    var street564 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Street","(addresses.Addresses.street) Name of street, without house number.") }, "anchor": "-20" });
    var street_no565 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("No.","(addresses.Addresses.street_no) House number.") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var street_box566 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Box","(addresses.Addresses.street_box) Text to print after street nuber on the same line.") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel567 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street564, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no565, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box566, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2571 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line after street</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Address line after street","(addresses.Addresses.addr2) Address line to print below street line.") }, "anchor": "-20" });
    var address_type572 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Address type", "name": "address_type", "hiddenName": "address_typeHidden", "listeners": { "render": Lino.quicktip_renderer("Address type","(addresses.Addresses.address_type) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.addresses.AddressTypes) });
    var remark573 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Remark", "name": "remark", "maxLength": 50, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Remark","(addresses.Addresses.remark) ") }, "anchor": "-20" });
    var main_5_panel574 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": address_type572, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": remark573, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var data_source577 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Data source", "name": "data_source", "hiddenName": "data_sourceHidden", "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Data source","(addresses.Addresses.data_source) ") }, "anchor": "-20", "store": Lino.addresses.DataSources });
    var partner578 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "emptyText": "Select a Partner...", "listeners": { "render": Lino.quicktip_renderer("Partner","(addresses.Addresses.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/addresses/Addresses/partner", "method": "GET" }) }), "name": "partner" });
    var main_6_panel579 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": data_source577, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner578, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel582 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 243, "autoScroll": false, "items": [ main_1_panel559, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1563, "anchor": "-20", "labelAlign": "top" }, main_3_panel567, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2571, "anchor": "-20", "labelAlign": "top" }, main_5_panel574, main_6_panel579 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel582;
    this.before_row_edit = function(record) {
      city557.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city557.setContextValue('region', record ? record.data['regionHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      country556.on('change',Lino.chooser_handler(city557,'country'));
      Lino.addresses.Addresses.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.addresses.Addresses.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    city557.on("change", function(){ this.save() }, this);
    zip_code558.on("change", function(){ this.save() }, this);
  }
});


Lino.cal.RecurrentEvents.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 37,
  initComponent : function() {
    var name1191 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(cal.RecurrentEvents.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_et1192 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(cal.RecurrentEvents.name_et) ") }, "anchor": "-20" });
    var main_1_panel1193 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1191, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1192, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var start_date1196 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Start date", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start date","(cal.RecurrentEvents.start_date) ") }, "anchor": "-20" });
    var end_date1197 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "End Date", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("End Date","(cal.RecurrentEvents.end_date) ") }, "anchor": "-20" });
    var every_unit1198 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Recurrency", "allowBlank": false, "hiddenName": "every_unitHidden", "listeners": { "render": Lino.quicktip_renderer("Recurrency","(cal.RecurrentEvents.every_unit) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.Recurrencies, "name": "every_unit" });
    var event_type1199 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Event Type", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail,Lino.cal.EventTypes.insert)}, "emptyText": "Select a Event Type...", "listeners": { "render": Lino.quicktip_renderer("Event Type","(cal.RecurrentEvents.event_type) ") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/RecurrentEvents/event_type", "method": "GET" }) }) });
    var main_2_panel1200 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1196, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1197, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": every_unit1198, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type1199, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1205 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1193, main_2_panel1200 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1205;
    this.before_row_edit = function(record) {
    }
    Lino.cal.RecurrentEvents.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.GuestRoles.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 42,
  initComponent : function() {
    var id1030 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.GuestRoles.id) ") }, "anchor": "-20" });
    var name1031 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(cal.GuestRoles.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_et1032 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(cal.GuestRoles.name_et) ") }, "anchor": "-20" });
    var main_1_panel1033 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1030, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1031, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1032, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_GuestsByRole_grid1048 = new Lino.cal.GuestsByRole.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Participants","(cal.cal.GuestsByRole) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.GuestsByRole.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1049 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1033, cal_GuestsByRole_grid1048 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1049;
    this.before_row_edit = function(record) {
      cal_GuestsByRole_grid1048.on_master_changed();
    }
    Lino.cal.GuestRoles.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.TextFieldTemplates.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 5,
  initComponent : function() {
    var name129 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(system.TextFieldTemplates.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user130 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(system.TextFieldTemplates.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/user", "method": "GET" }) }) });
    var main_panel131 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 108, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name129, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": user130, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel131;
    this.before_row_edit = function(record) {
    }
    Lino.system.TextFieldTemplates.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.EventTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 38,
  initComponent : function() {
    var name1050 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(cal.EventTypes.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_et1051 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(cal.EventTypes.name_et) ") }, "anchor": "-20" });
    var main_1_panel1052 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1050, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1051, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var event_label1055 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Event label", "name": "event_label", "value": "Appointment", "listeners": { "render": Lino.quicktip_renderer("Event label","(cal.EventTypes.event_label) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var event_label_et1056 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Event label (et)", "name": "event_label_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Event label (et)","(cal.EventTypes.event_label_et) ") }, "anchor": "-20" });
    var main_2_panel1057 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label1055, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label_et1056, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var start_date1060 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Start date", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start date","(cal.EventTypes.start_date) ") }, "anchor": "-20" });
    var id1061 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.EventTypes.id) ") }, "anchor": "-20" });
    var main_3_panel1062 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 72, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1060, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1061, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var email_template1065 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Email template</span>", "name": "email_template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Email template","(cal.EventTypes.email_template) The name of the file to be used as template when creating an email from a mailable of this type.") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventTypes/email_template", "method": "GET" }) }), "anchor": "-20" });
    var attach_to_email1066 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "attach_to_email", "listeners": { "render": Lino.quicktip_renderer("Attach to email","(cal.EventTypes.attach_to_email) Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "boxLabel": "Attach to email", "selectOnFocus": true, "anchor": "-20" });
    var main_4_panel1067 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template1065, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email1066, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var is_appointment1070 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": true, "name": "is_appointment", "listeners": { "render": Lino.quicktip_renderer("Event is an appointment","(cal.EventTypes.is_appointment) ") }, "boxLabel": "Event is an appointment", "selectOnFocus": true, "anchor": "-20" });
    var all_rooms1071 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "all_rooms", "listeners": { "render": Lino.quicktip_renderer("Locks all rooms","(cal.EventTypes.all_rooms) ") }, "boxLabel": "Locks all rooms", "selectOnFocus": true, "anchor": "-20" });
    var locks_user1072 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "locks_user", "listeners": { "render": Lino.quicktip_renderer("Locks the user","(cal.EventTypes.locks_user) Whether events of this type make the user unavailable for other locking events at the same time.") }, "boxLabel": "Locks the user", "selectOnFocus": true, "anchor": "-20" });
    var max_conflicting1073 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Simultaneous events</span>", "name": "max_conflicting", "value": 1, "listeners": { "render": Lino.quicktip_renderer("Simultaneous events","(cal.EventTypes.max_conflicting) How many conflicting events should be tolerated.") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_5_panel1074 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_appointment1070, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": all_rooms1071, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": locks_user1072, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": max_conflicting1073, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var EventsByType_grid1105 = new Lino.cal.EventsByType.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Events","(cal.cal.EventsByType) ") }, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByType.grid) ] });
    var main_panel1106 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1052, main_2_panel1057, main_3_panel1062, main_4_panel1067, main_5_panel1074, EventsByType_grid1105 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1106;
    this.before_row_edit = function(record) {
      EventsByType_grid1105.on_master_changed();
    }
    Lino.cal.EventTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Households.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 33,
  initComponent : function() {
    var type1331 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Household Type", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.households.Types.detail,Lino.households.Types.insert)}, "emptyText": "Select a Household Type...", "listeners": { "render": Lino.quicktip_renderer("Household Type","(households.Households.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/type", "method": "GET" }) }) });
    var name1332 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Name","(households.Households.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language1333 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(households.Households.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "et", "Estonian" ] ], "name": "language" });
    var id1334 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(households.Households.id) ") }, "anchor": "-20" });
    var main_1_panel1335 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1331, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1332, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1333, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1334, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var country1340 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Country","(households.Households.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/country", "method": "GET" }) }) });
    var region1341 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "County", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("County","(households.Households.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/region", "method": "GET" }) }) });
    var box3_1_panel1342 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1340, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region1341, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city1345 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "City", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("City","(households.Households.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/city", "method": "GET" }) }) });
    var zip_code1346 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Zip code", "name": "zip_code", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Zip code","(households.Households.zip_code) ") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var box3_2_panel1347 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city1345, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code1346, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix1350 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street prefix</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Street prefix","(households.Households.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "anchor": "-20" });
    var street1351 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Street","(households.Households.street) Name of street, without house number.") }, "anchor": "-20" });
    var street_no1352 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("No.","(households.Households.street_no) House number.") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var street_box1353 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Box","(households.Households.street_box) Text to print after street nuber on the same line.") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var box3_3_panel1354 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix1350, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street1351, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no1352, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box1353, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr21359 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line after street</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Address line after street","(households.Households.addr2) Address line to print below street line.") }, "anchor": "-20" });
    var box3_panel1360 = new Ext.Panel({ "flex": 62, "autoHeight": true, "layout": "form", "items": [ box3_1_panel1342, box3_2_panel1347, box3_3_panel1354, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr21359, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 234, "border": false, "labelAlign": "top" });
    var phone1362 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Phone", "name": "phone", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Phone","(households.Households.phone) ") }, "anchor": "-20" });
    var gsm1363 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("GSM","(households.Households.gsm) ") }, "anchor": "-20" });
    var email1364 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail","(households.Households.email) ") }, "anchor": "-20" });
    var url1365 = new Lino.URLField({ "autoHeight": true, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("URL","(households.Households.url) ") }, "anchor": "-20" });
    var box4_panel1366 = new Ext.Panel({ "flex": 37, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone1362, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm1363, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1364, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url1365, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var address_box_panel1371 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box3_panel1360, box4_panel1366 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks1372 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remarks","(households.Households.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var households_MembersByHousehold_grid1380 = new Lino.households.MembersByHousehold.GridPanel({ "flex": 57, "listeners": { "render": Lino.quicktip_renderer("Household Members","(households.households.MembersByHousehold) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByHousehold.grid) ], "preview_limit": 15, "master_panel": this });
    var bottom_box_panel1381 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": remarks1372, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 42 }, households_MembersByHousehold_grid1380 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel1383 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1335, address_box_panel1371, bottom_box_panel1381 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1383;
    this.before_row_edit = function(record) {
      region1341.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city1345.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city1345.setContextValue('region', record ? record.data['regionHidden'] : undefined);
      households_MembersByHousehold_grid1380.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country1340.on('change',Lino.chooser_handler(region1341,'country'));
      country1340.on('change',Lino.chooser_handler(city1345,'country'));
      region1341.on('change',Lino.chooser_handler(city1345,'region'));
      Lino.households.Households.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.households.Households.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    city1345.on("change", function(){ this.save() }, this);
    zip_code1346.on("change", function(){ this.save() }, this);
  }
});


Lino.cal.RecurrentEvents.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 37,
  initComponent : function() {
    var name1118 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(cal.RecurrentEvents.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_et1119 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(cal.RecurrentEvents.name_et) ") }, "anchor": "-20" });
    var main_1_panel1120 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1118, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1119, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var id1123 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.RecurrentEvents.id) ") }, "anchor": "-20" });
    var user1124 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(cal.RecurrentEvents.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/RecurrentEvents/user", "method": "GET" }) }) });
    var event_type1125 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Event Type", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail,Lino.cal.EventTypes.insert)}, "emptyText": "Select a Event Type...", "listeners": { "render": Lino.quicktip_renderer("Event Type","(cal.RecurrentEvents.event_type) ") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/RecurrentEvents/event_type", "method": "GET" }) }) });
    var main_2_panel1126 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1123, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1124, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type1125, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var start_date1130 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Start date", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start date","(cal.RecurrentEvents.start_date) ") }, "anchor": "-20" });
    var start_time1131 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "Start time", "name": "start_time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start time","(cal.RecurrentEvents.start_time) ") }, "anchor": "-20" });
    var end_date1132 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "End Date", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("End Date","(cal.RecurrentEvents.end_date) ") }, "anchor": "-20" });
    var end_time1133 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "End Time", "name": "end_time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("End Time","(cal.RecurrentEvents.end_time) ") }, "anchor": "-20" });
    var main_3_panel1134 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1130, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time1131, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1132, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time1133, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var every_unit1139 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Recurrency", "allowBlank": false, "hiddenName": "every_unitHidden", "listeners": { "render": Lino.quicktip_renderer("Recurrency","(cal.RecurrentEvents.every_unit) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.Recurrencies, "name": "every_unit" });
    var every1140 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "Repeat every", "name": "every", "value": 0, "listeners": { "render": Lino.quicktip_renderer("Repeat every","(cal.RecurrentEvents.every) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var max_events1141 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "Number of events", "name": "max_events", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Number of events","(cal.RecurrentEvents.max_events) ") }, "anchor": "-20" });
    var main_4_panel1142 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": every_unit1139, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": every1140, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": max_events1141, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var monday1146 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "monday", "listeners": { "render": Lino.quicktip_renderer("Monday","(cal.RecurrentEvents.monday) ") }, "boxLabel": "Monday", "selectOnFocus": true, "anchor": "-20" });
    var tuesday1147 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "tuesday", "listeners": { "render": Lino.quicktip_renderer("Tuesday","(cal.RecurrentEvents.tuesday) ") }, "boxLabel": "Tuesday", "selectOnFocus": true, "anchor": "-20" });
    var wednesday1148 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "wednesday", "listeners": { "render": Lino.quicktip_renderer("Wednesday","(cal.RecurrentEvents.wednesday) ") }, "boxLabel": "Wednesday", "selectOnFocus": true, "anchor": "-20" });
    var thursday1149 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "thursday", "listeners": { "render": Lino.quicktip_renderer("Thursday","(cal.RecurrentEvents.thursday) ") }, "boxLabel": "Thursday", "selectOnFocus": true, "anchor": "-20" });
    var friday1150 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "friday", "listeners": { "render": Lino.quicktip_renderer("Friday","(cal.RecurrentEvents.friday) ") }, "boxLabel": "Friday", "selectOnFocus": true, "anchor": "-20" });
    var saturday1151 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "saturday", "listeners": { "render": Lino.quicktip_renderer("Saturday","(cal.RecurrentEvents.saturday) ") }, "boxLabel": "Saturday", "selectOnFocus": true, "anchor": "-20" });
    var sunday1152 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "sunday", "listeners": { "render": Lino.quicktip_renderer("Sunday","(cal.RecurrentEvents.sunday) ") }, "boxLabel": "Sunday", "selectOnFocus": true, "anchor": "-20" });
    var main_5_panel1153 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": monday1146, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": tuesday1147, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": wednesday1148, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": thursday1149, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": friday1150, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": saturday1151, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sunday1152, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description1161 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 33, "containing_panel": this, "name": "description", "title": "Description" });
    var cal_EventsByController_grid1188 = new Lino.cal.EventsByController.GridPanel({ "flex": 66, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Events","(cal.cal.EventsByController) ") }, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByController.grid) ] });
    var main_6_panel1189 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ description1161, cal_EventsByController_grid1188 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel1190 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1120, main_2_panel1126, main_3_panel1134, main_4_panel1142, main_5_panel1153, main_6_panel1189 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1190;
    this.before_row_edit = function(record) {
      description1161.refresh();
      cal_EventsByController_grid1188.on_master_changed();
    }
    Lino.cal.RecurrentEvents.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pages.Pages.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 46,
  initComponent : function() {
    var ref1386 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Reference", "name": "ref", "maxLength": 40, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Reference","(pages.Pages.ref) ") }, "anchor": "-20" });
    var parent1387 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Parent", "name": "parent", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pages.Pages.detail,Lino.pages.Pages.insert)}, "emptyText": "Select a Node...", "listeners": { "render": Lino.quicktip_renderer("Parent","(pages.Pages.parent) ") }, "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pages/Pages/parent", "method": "GET" }) }) });
    var seqno1388 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "Seq.No.", "name": "seqno", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Seq.No.","(pages.Pages.seqno) ") }, "anchor": "-20" });
    var main_1_panel1389 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1386, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent1387, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": seqno1388, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var title1393 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Title", "name": "title", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Title","(pages.Pages.title) ") }, "anchor": "-20" });
    var title_et1394 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Title (et)", "name": "title_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Title (et)","(pages.Pages.title_et) ") }, "anchor": "-20" });
    var main_2_panel1395 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title1393, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title_et1394, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var body1398 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Body","(pages.Pages.body) ") }, "fieldLabel": "Body", "name": "body", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var body_et1399 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Body (et)","(pages.Pages.body_et) ") }, "fieldLabel": "Body (et)", "name": "body_et", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var main_3_panel1400 = new Ext.Panel({ "flex": 71, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "items": body1398, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 50 }, { "items": body_et1399, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 50 } ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel1403 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1389, main_2_panel1395, main_3_panel1400 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1403;
    this.before_row_edit = function(record) {
    }
    Lino.pages.Pages.DetailFormPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Users.change_password = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.Users.change_password_ActionFormPanel({});
});
Lino.contacts.Persons.create_household = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Persons.create_household_ActionFormPanel({});
});
Lino.cal.GuestStates.wf1 = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Guests.wf1_ActionFormPanel({});
});
Lino.cal.GuestStates.wf2 = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Guests.wf2_ActionFormPanel({});
});
Lino.cal.Guests.checkin = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Guests.checkin_ActionFormPanel({});
});

// js_render_GridPanel_class contenttypes.ContentTypes
Lino.contenttypes.ContentTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contenttypes/ContentTypes",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/contenttypes/ContentTypes','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/contenttypes/ContentTypes','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "content types",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 5,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "app_label" }, { "name": "model" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 3,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.contenttypes.ContentTypes.detail;
    this.ls_insert_handler = Lino.contenttypes.ContentTypes.insert;
    var ww = this.containing_window;
    var id1437 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1438 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var app_label1439 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var model1440 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(contenttypes.ContentTypes.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1437, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "name", "editable": true, "tooltip": "(contenttypes.ContentTypes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name1438, "dataIndex": "name" }, { "colIndex": 2, "sortable": true, "header": "app label", "editable": true, "tooltip": "(contenttypes.ContentTypes.app_label) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": app_label1439, "dataIndex": "app_label" }, { "colIndex": 3, "sortable": true, "header": "python model class name", "editable": true, "tooltip": "(contenttypes.ContentTypes.model) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": model1440, "dataIndex": "model" } ];
    Lino.contenttypes.ContentTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contenttypes.ContentTypes.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/ContentTypes", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.ContentTypes.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/ContentTypes", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.ContentTypes.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/ContentTypes", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.contenttypes.ContentTypes.insertPanel = Ext.extend(Lino.contenttypes.ContentTypes.DetailFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/contenttypes/ContentTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contenttypes.ContentTypes.detail;
    this.ls_insert_handler = Lino.contenttypes.ContentTypes.insert;
    Lino.contenttypes.ContentTypes.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contenttypes.ContentTypes.insert = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contenttypes.ContentTypes.insertPanel(p);
});
Lino.contenttypes.ContentTypes.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/ContentTypes", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.ContentTypes.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/ContentTypes", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.ContentTypes.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/ContentTypes", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.contenttypes.ContentTypes.detailPanel = Ext.extend(Lino.contenttypes.ContentTypes.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  ls_url: "/contenttypes/ContentTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contenttypes.ContentTypes.detail;
    this.ls_insert_handler = Lino.contenttypes.ContentTypes.insert;
    Lino.contenttypes.ContentTypes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contenttypes.ContentTypes.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contenttypes.ContentTypes.detailPanel(p);
});
Lino.contenttypes.ContentTypes.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/ContentTypes", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.ContentTypes.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contenttypes.ContentTypes.GridPanel(p);
});
Lino.contenttypes.ContentTypes.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/ContentTypes", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class contenttypes.HelpTexts
Lino.contenttypes.HelpTexts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contenttypes/HelpTexts",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/contenttypes/HelpTexts','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/contenttypes/HelpTexts','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Help Texts",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "name": "field" }, { "name": "verbose_name" }, { "name": "help_text" }, { "type": "int", "name": "id" }, { "name": "content_type" }, 'content_typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 2,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var field1442 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contenttypes/HelpTexts/field", "method": "GET" }) }) });
    var verbose_name1443 = new Ext.form.TextField({ "disabled": true, "maxLength": 200 });
    var help_text1444 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var id1445 = new Ext.form.NumberField({ "selectOnFocus": true });
    var content_type1446 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contenttypes/HelpTexts/content_type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a content type..." });
    this.before_row_edit = function(record) {
      field1442.setContextValue('content_type', record ? record.data['content_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      content_type1446.on('change',Lino.chooser_handler(field1442,'content_type'));
      Lino.contenttypes.HelpTexts.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Field", "editable": true, "tooltip": "(contenttypes.HelpTexts.field) The name of the field.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": field1442, "dataIndex": "field" }, { "header": "Verbose name", "colIndex": 1, "sortable": false, "dataIndex": "verbose_name", "width": Lino.chars2width(22), "editable": false, "tooltip": "(contenttypes.HelpTexts.verbose_name) " }, { "colIndex": 2, "sortable": false, "header": "HelpText", "editable": true, "tooltip": "(contenttypes.HelpTexts.help_text) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "editor": help_text1444, "dataIndex": "help_text" }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(contenttypes.HelpTexts.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1445, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Model", "editable": true, "tooltip": "(contenttypes.HelpTexts.content_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('content_typeHidden','Lino.contenttypes.ContentTypes.detail'), "dataIndex": "content_type", "editor": content_type1446 } ];
    Lino.contenttypes.HelpTexts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contenttypes.HelpTexts.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/HelpTexts", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.HelpTexts.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/HelpTexts", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.HelpTexts.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/HelpTexts", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.HelpTexts.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/HelpTexts", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.HelpTexts.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/HelpTexts", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.HelpTexts.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/HelpTexts", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.HelpTexts.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contenttypes.HelpTexts.GridPanel(p);
});

// js_render_GridPanel_class system.SiteConfigs
Lino.system.SiteConfigs.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/system/SiteConfigs",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/system/SiteConfigs','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/system/SiteConfigs','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "do_build", "menu_item_text": "Rebuild site cache", "panel_btn_handler": Lino.row_action_handler('do_build','GET',null), "text": "Rebuild site cache", "overflowText": "Rebuild site cache", "auto_save": true } ],
  cell_edit : true,
  title : "Site configurations",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 16,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "default_build_method" }, 'default_build_methodHidden', { "type": "int", "name": "next_partner_id" }, { "name": "site_company" }, 'site_companyHidden', { "name": "default_event_type" }, 'default_event_typeHidden', { "name": "site_calendar" }, 'site_calendarHidden', { "type": "int", "name": "max_auto_events" }, { "name": "prompt_calendar" }, 'prompt_calendarHidden', { "name": "system_note_type" }, 'system_note_typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 4,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.system.SiteConfigs.detail;
    var ww = this.containing_window;
    var id1448 = new Ext.form.NumberField({ "selectOnFocus": true });
    var default_build_method1449 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.BuildMethods) });
    var next_partner_id1450 = new Ext.form.NumberField({ "selectOnFocus": true, "value": 100 });
    var site_company1451 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/site_company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Organisation..." });
    var default_event_type1452 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/default_event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Event Type..." });
    var site_calendar1453 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/site_calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    var max_auto_events1454 = new Ext.form.NumberField({ "selectOnFocus": true, "value": 72 });
    var prompt_calendar1455 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/prompt_calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Event Type..." });
    var system_note_type1456 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/system_note_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Event Type..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.SiteConfigs.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1448, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Default build method", "editable": true, "tooltip": "(system.SiteConfigs.default_build_method) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": default_build_method1449, "dataIndex": "default_build_method" }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.SiteConfigs.next_partner_id) The next automatic id for any new partner.", "filter": { "type": "numeric" }, "header": "Next partner id", "editor": next_partner_id1450, "width": Lino.chars2width(6), "dataIndex": "next_partner_id" }), { "colIndex": 3, "sortable": true, "header": "Site owner", "editable": true, "tooltip": "(system.SiteConfigs.site_company) The organisation who runs this site.\n        This is used e.g. as sender in documents.\n        Or, newly created partners inherit the country of the site owner.\n        ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('site_companyHidden','Lino.contacts.Companies.detail'), "dataIndex": "site_company", "editor": site_company1451 }, { "colIndex": 4, "sortable": true, "header": "Default Event Type", "editable": true, "tooltip": "(system.SiteConfigs.default_event_type) The default type of events on this site.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('default_event_typeHidden','Lino.cal.EventTypes.detail'), "dataIndex": "default_event_type", "editor": default_event_type1452 }, { "colIndex": 5, "sortable": true, "header": "Site Calendar", "editable": true, "tooltip": "(system.SiteConfigs.site_calendar) The default calendar of this site.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('site_calendarHidden','Lino.cal.Calendars.detail'), "dataIndex": "site_calendar", "editor": site_calendar1453 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.SiteConfigs.max_auto_events) Maximum number of automatic events to be generated.", "filter": { "type": "numeric" }, "header": "Max automatic events", "editor": max_auto_events1454, "width": Lino.chars2width(6), "dataIndex": "max_auto_events" }), { "colIndex": 7, "sortable": true, "header": "Default type for prompt events", "editable": true, "tooltip": "(system.SiteConfigs.prompt_calendar) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('prompt_calendarHidden','Lino.cal.EventTypes.detail'), "dataIndex": "prompt_calendar", "editor": prompt_calendar1455 }, { "colIndex": 8, "sortable": true, "header": "Default system note type", "editable": true, "tooltip": "(system.SiteConfigs.system_note_type) Note Type used by system notes.\nIf this is empty, then system notes won't create any entry to the Notes table.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('system_note_typeHidden','Lino.notes.EventTypes.detail'), "dataIndex": "system_note_type", "editor": system_note_type1456 } ];
    Lino.system.SiteConfigs.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.system.SiteConfigs.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/SiteConfigs", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.SiteConfigs.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/SiteConfigs", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.SiteConfigs.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/SiteConfigs", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.SiteConfigs.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/SiteConfigs", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.SiteConfigs.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/SiteConfigs", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.SiteConfigs.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/SiteConfigs", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.system.SiteConfigs.detailPanel = Ext.extend(Lino.system.SiteConfigs.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "do_build", "menu_item_text": "Rebuild site cache", "panel_btn_handler": Lino.row_action_handler('do_build','GET',null), "text": "Rebuild site cache", "overflowText": "Rebuild site cache", "auto_save": true } ],
  ls_url: "/system/SiteConfigs",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.SiteConfigs.detail;
    Lino.system.SiteConfigs.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.system.SiteConfigs.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.system.SiteConfigs.detailPanel(p);
});
Lino.system.SiteConfigs.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.system.SiteConfigs.GridPanel(p);
});
Lino.system.SiteConfigs.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/SiteConfigs", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.SiteConfigs.do_build = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/SiteConfigs", "GET", pk, "do_build", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class system.TextFieldTemplates
Lino.system.TextFieldTemplates.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/system/TextFieldTemplates",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/system/TextFieldTemplates','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/system/TextFieldTemplates','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Text Field Templates",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 5,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "name" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 5,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.system.TextFieldTemplates.detail;
    this.ls_insert_handler = Lino.system.TextFieldTemplates.insert;
    var ww = this.containing_window;
    var id1458 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1459 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var name1460 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.TextFieldTemplates.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1458, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Author", "editable": true, "tooltip": "(system.TextFieldTemplates.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "dataIndex": "user", "editor": user1459 }, { "colIndex": 2, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(system.TextFieldTemplates.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name1460, "dataIndex": "name" } ];
    Lino.system.TextFieldTemplates.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.system.TextFieldTemplates.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/TextFieldTemplates", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.TextFieldTemplates.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/TextFieldTemplates", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.TextFieldTemplates.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/TextFieldTemplates", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.system.TextFieldTemplates.insertPanel = Ext.extend(Lino.system.TextFieldTemplates.InsertFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/system/TextFieldTemplates",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.TextFieldTemplates.detail;
    this.ls_insert_handler = Lino.system.TextFieldTemplates.insert;
    Lino.system.TextFieldTemplates.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.system.TextFieldTemplates.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.system.TextFieldTemplates.insertPanel(p);
});
Lino.system.TextFieldTemplates.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/TextFieldTemplates", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.TextFieldTemplates.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/TextFieldTemplates", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.TextFieldTemplates.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/TextFieldTemplates", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.system.TextFieldTemplates.detailPanel = Ext.extend(Lino.system.TextFieldTemplates.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  ls_url: "/system/TextFieldTemplates",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.TextFieldTemplates.detail;
    this.ls_insert_handler = Lino.system.TextFieldTemplates.insert;
    Lino.system.TextFieldTemplates.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.system.TextFieldTemplates.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.system.TextFieldTemplates.detailPanel(p);
});
Lino.system.TextFieldTemplates.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/TextFieldTemplates", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.TextFieldTemplates.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.system.TextFieldTemplates.GridPanel(p);
});
Lino.system.TextFieldTemplates.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/TextFieldTemplates", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class changes.Changes
Lino.changes.Changes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "emptyText": "No data to display." },
  ls_url : "/changes/Changes",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/changes/Changes','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/changes/Changes','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true } ],
  cell_edit : true,
  title : "Changes",
  page_length : 20,
  stripeRows : true,
  disable_editing : true,
  disabled_actions_index : 16,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "time" }, { "name": "type" }, 'typeHidden', { "name": "user" }, 'userHidden', { "name": "object_type" }, 'object_typeHidden', { "name": "object_id" }, 'object_idHidden', { "name": "master_type" }, 'master_typeHidden', { "name": "master_id" }, 'master_idHidden', { "name": "object" }, { "name": "master" }, { "name": "disabled_actions" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 6,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.changes.Changes.detail;
    var ww = this.containing_window;
    var id1462 = new Ext.form.NumberField({ "selectOnFocus": true });
    var time1463 = new Ext.form.DisplayField({ "selectOnFocus": true, "allowBlank": false, "value": "<br>" });
    var type1464 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.lino.ChangeTypes });
    var user1465 = new Lino.RemoteComboFieldElement({ "preferred_width": 15, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/user", "method": "GET" }) }), "emptyText": "Select a User..." });
    var object_type1466 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/object_type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a content type..." });
    var object_id1467 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/object_id", "method": "GET" }) }) });
    var master_type1468 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/master_type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a content type..." });
    var master_id1469 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/changes/Changes/master_id", "method": "GET" }) }) });
    var object_disp1470 = new Ext.form.DisplayField({ "disabled": true });
    var master_disp1471 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(changes.Changes.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1462, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "width": Lino.chars2width(17), "editable": true, "tooltip": "(changes.Changes.time) ", "header": "time", "editor": time1463, "dataIndex": "time" }, { "colIndex": 2, "sortable": true, "header": "Change Type", "editable": true, "tooltip": "(changes.Changes.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(16), "editor": type1464, "dataIndex": "type" }, { "colIndex": 3, "sortable": true, "header": "User", "editable": true, "tooltip": "(changes.Changes.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "dataIndex": "user", "editor": user1465 }, { "colIndex": 4, "sortable": true, "header": "Object type", "editable": true, "tooltip": "(changes.Changes.object_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('object_typeHidden','Lino.contenttypes.ContentTypes.detail'), "dataIndex": "object_type", "editor": object_type1466 }, { "colIndex": 5, "sortable": true, "header": "object id", "editable": true, "tooltip": "(changes.Changes.object_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": object_id1467, "dataIndex": "object_id" }, { "colIndex": 6, "sortable": true, "header": "Master type", "editable": true, "tooltip": "(changes.Changes.master_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('master_typeHidden','Lino.contenttypes.ContentTypes.detail'), "dataIndex": "master_type", "editor": master_type1468 }, { "colIndex": 7, "sortable": true, "header": "master id", "editable": true, "tooltip": "(changes.Changes.master_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": master_id1469, "dataIndex": "master_id" }, { "header": "Object", "colIndex": 8, "sortable": false, "dataIndex": "object", "width": Lino.chars2width(11), "editable": false, "tooltip": "(changes.Changes.object) " }, { "header": "Master", "colIndex": 9, "sortable": false, "dataIndex": "master", "width": Lino.chars2width(11), "editable": false, "tooltip": "(changes.Changes.master) " } ];
    Lino.changes.Changes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.changes.Changes.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/changes/Changes", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.changes.Changes.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/changes/Changes", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.changes.Changes.detailPanel = Ext.extend(Lino.changes.Changes.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [  ],
  ls_url: "/changes/Changes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.changes.Changes.detail;
    Lino.changes.Changes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.changes.Changes.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.changes.Changes.detailPanel(p);
});
Lino.changes.Changes.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.changes.Changes.ParamsPanel({});
  return new Lino.changes.Changes.GridPanel(p);
});

// js_render_GridPanel_class users.Users
Lino.users.Users.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/Users",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/users/Users','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/users/Users','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true }, { "itemId": "change_password", "menu_item_text": "Change password", "panel_btn_handler": Lino.param_action_handler(Lino.users.Users.change_password), "text": "Change password", "overflowText": "Change password", "auto_save": true } ],
  cell_edit : true,
  title : "Users",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 21,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "first_name" }, { "name": "last_name" }, { "type": "int", "name": "id" }, { "name": "modified" }, { "name": "created" }, { "name": "password" }, { "name": "initials" }, { "name": "email" }, { "name": "remarks" }, { "name": "language" }, 'languageHidden', { "name": "partner" }, 'partnerHidden', { "name": "access_class" }, 'access_classHidden', { "name": "event_type" }, 'event_typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 7,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    var ww = this.containing_window;
    var username1473 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile1474 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.users.UserProfiles) });
    var first_name1475 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var last_name1476 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var id1477 = new Ext.form.NumberField({ "selectOnFocus": true });
    var modified1478 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created1479 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var password1480 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 128 });
    var initials1481 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var email1482 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var remarks1483 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var language1484 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "et", "Estonian" ] ] });
    var partner1485 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var access_class1486 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.AccessClasses });
    var event_type1487 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Event Type..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Username", "editable": true, "tooltip": "(users.Users.username) Required. Must be unique.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": username1473, "dataIndex": "username" }, { "colIndex": 1, "sortable": true, "header": "User Profile", "editable": true, "tooltip": "(users.Users.profile) Users with an empty `profile` field are considered inactive and cannot log in.", "filter": { "type": "string" }, "width": Lino.chars2width(23), "editor": profile1474, "dataIndex": "profile" }, { "colIndex": 2, "sortable": true, "header": "First name", "editable": true, "tooltip": "(users.Users.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": first_name1475, "dataIndex": "first_name" }, { "colIndex": 3, "sortable": true, "header": "Last name", "editable": true, "tooltip": "(users.Users.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": last_name1476, "dataIndex": "last_name" }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.Users.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1477, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(users.Users.modified) ", "header": "Modified", "dataIndex": "modified", "hidden": true }, { "colIndex": 6, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(users.Users.created) ", "header": "Created", "dataIndex": "created", "hidden": true }, { "colIndex": 7, "sortable": true, "header": "Password", "editable": true, "tooltip": "(users.Users.password) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": password1480, "hidden": true, "dataIndex": "password" }, { "colIndex": 8, "sortable": true, "header": "Initials", "editable": true, "tooltip": "(users.Users.initials) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": initials1481, "hidden": true, "dataIndex": "initials" }, { "colIndex": 9, "sortable": true, "header": "e-mail address", "editable": true, "tooltip": "(users.Users.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": email1482, "hidden": true, "dataIndex": "email" }, { "colIndex": 10, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(users.Users.remarks) ", "filter": { "type": "string" }, "header": "Remarks", "editor": remarks1483, "hidden": true, "dataIndex": "remarks" }, { "colIndex": 11, "sortable": true, "header": "Language", "editable": true, "tooltip": "(users.Users.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": language1484, "hidden": true, "dataIndex": "language" }, { "colIndex": 12, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(users.Users.partner) ", "filter": { "type": "string" }, "header": "Partner", "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "dataIndex": "partner", "hidden": true, "editor": partner1485 }, { "colIndex": 13, "sortable": true, "header": "Default access class", "editable": true, "tooltip": "(users.Users.access_class) The default access class for your calendar events and tasks.", "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": access_class1486, "hidden": true, "dataIndex": "access_class" }, { "colIndex": 14, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(users.Users.event_type) The default event type for your calendar events.", "filter": { "type": "string" }, "header": "Default Event Type", "renderer": Lino.fk_renderer('event_typeHidden','Lino.cal.EventTypes.detail'), "dataIndex": "event_type", "hidden": true, "editor": event_type1487 } ];
    Lino.users.Users.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Users.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Users", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Users.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Users", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Users.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Users", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.users.Users.insertPanel = Ext.extend(Lino.users.Users.InsertFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/users/Users",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.Users.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Users.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.Users.insertPanel(p);
});
Lino.users.Users.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Users", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Users.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Users", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Users.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Users", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.users.Users.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true }, { "itemId": "change_password", "menu_item_text": "Change password", "panel_btn_handler": Lino.param_action_handler(Lino.users.Users.change_password), "text": "Change password", "overflowText": "Change password", "auto_save": true } ],
  ls_url: "/users/Users",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.Users.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Users.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.users.Users.detailPanel(p);
});
Lino.users.Users.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Users", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Users.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.users.Users.GridPanel(p);
});
Lino.users.Users.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Users", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Users.update_reminders = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Users", "GET", pk, "update_reminders", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class users.MySettings
Lino.users.MySettings.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/MySettings",
  ls_bbar_actions : [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true }, { "itemId": "change_password", "menu_item_text": "Change password", "panel_btn_handler": Lino.param_action_handler(Lino.users.Users.change_password), "text": "Change password", "overflowText": "Change password", "auto_save": true } ],
  cell_edit : true,
  title : "Users",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 21,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "first_name" }, { "name": "last_name" }, { "type": "int", "name": "id" }, { "name": "modified" }, { "name": "created" }, { "name": "password" }, { "name": "initials" }, { "name": "email" }, { "name": "remarks" }, { "name": "language" }, 'languageHidden', { "name": "partner" }, 'partnerHidden', { "name": "access_class" }, 'access_classHidden', { "name": "event_type" }, 'event_typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 7,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    var ww = this.containing_window;
    var username1489 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile1490 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.users.UserProfiles) });
    var first_name1491 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var last_name1492 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var id1493 = new Ext.form.NumberField({ "selectOnFocus": true });
    var modified1494 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created1495 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var password1496 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 128 });
    var initials1497 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var email1498 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var remarks1499 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var language1500 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "et", "Estonian" ] ] });
    var partner1501 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var access_class1502 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.AccessClasses });
    var event_type1503 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Event Type..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Username", "editable": true, "tooltip": "(users.MySettings.username) Required. Must be unique.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": username1489, "dataIndex": "username" }, { "colIndex": 1, "sortable": true, "header": "User Profile", "editable": true, "tooltip": "(users.MySettings.profile) Users with an empty `profile` field are considered inactive and cannot log in.", "filter": { "type": "string" }, "width": Lino.chars2width(23), "editor": profile1490, "dataIndex": "profile" }, { "colIndex": 2, "sortable": true, "header": "First name", "editable": true, "tooltip": "(users.MySettings.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": first_name1491, "dataIndex": "first_name" }, { "colIndex": 3, "sortable": true, "header": "Last name", "editable": true, "tooltip": "(users.MySettings.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": last_name1492, "dataIndex": "last_name" }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.MySettings.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1493, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(users.MySettings.modified) ", "header": "Modified", "dataIndex": "modified", "hidden": true }, { "colIndex": 6, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(users.MySettings.created) ", "header": "Created", "dataIndex": "created", "hidden": true }, { "colIndex": 7, "sortable": true, "header": "Password", "editable": true, "tooltip": "(users.MySettings.password) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": password1496, "hidden": true, "dataIndex": "password" }, { "colIndex": 8, "sortable": true, "header": "Initials", "editable": true, "tooltip": "(users.MySettings.initials) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": initials1497, "hidden": true, "dataIndex": "initials" }, { "colIndex": 9, "sortable": true, "header": "e-mail address", "editable": true, "tooltip": "(users.MySettings.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": email1498, "hidden": true, "dataIndex": "email" }, { "colIndex": 10, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(users.MySettings.remarks) ", "filter": { "type": "string" }, "header": "Remarks", "editor": remarks1499, "hidden": true, "dataIndex": "remarks" }, { "colIndex": 11, "sortable": true, "header": "Language", "editable": true, "tooltip": "(users.MySettings.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": language1500, "hidden": true, "dataIndex": "language" }, { "colIndex": 12, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(users.MySettings.partner) ", "filter": { "type": "string" }, "header": "Partner", "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "dataIndex": "partner", "hidden": true, "editor": partner1501 }, { "colIndex": 13, "sortable": true, "header": "Default access class", "editable": true, "tooltip": "(users.MySettings.access_class) The default access class for your calendar events and tasks.", "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": access_class1502, "hidden": true, "dataIndex": "access_class" }, { "colIndex": 14, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(users.MySettings.event_type) The default event type for your calendar events.", "filter": { "type": "string" }, "header": "Default Event Type", "renderer": Lino.fk_renderer('event_typeHidden','Lino.cal.EventTypes.detail'), "dataIndex": "event_type", "hidden": true, "editor": event_type1503 } ];
    Lino.users.MySettings.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.MySettings.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.MySettings.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.MySettings.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.MySettings.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.MySettings.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Users",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true }, { "itemId": "change_password", "menu_item_text": "Change password", "panel_btn_handler": Lino.param_action_handler(Lino.users.Users.change_password), "text": "Change password", "overflowText": "Change password", "auto_save": true } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});

Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Users",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true }, { "itemId": "change_password", "menu_item_text": "Change password", "panel_btn_handler": Lino.param_action_handler(Lino.users.Users.change_password), "text": "Change password", "overflowText": "Change password", "auto_save": true } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});
Lino.users.MySettings.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.MySettings.update_reminders = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "update_reminders", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class users.UsersOverview
Lino.users.UsersOverview.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/UsersOverview",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/users/UsersOverview','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/users/UsersOverview','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true }, { "itemId": "change_password", "menu_item_text": "Change password", "panel_btn_handler": Lino.param_action_handler(Lino.users.Users.change_password), "text": "Change password", "overflowText": "Change password", "auto_save": true } ],
  cell_edit : true,
  title : "Users",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "language" }, 'languageHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 7,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.UsersOverview.detail;
    this.ls_insert_handler = Lino.users.UsersOverview.insert;
    var ww = this.containing_window;
    var username36 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile37 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.users.UserProfiles) });
    var language38 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "et", "Estonian" ] ] });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Username", "editable": true, "tooltip": "(users.UsersOverview.username) Required. Must be unique.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": username36, "dataIndex": "username" }, { "colIndex": 1, "sortable": true, "header": "User Profile", "editable": true, "tooltip": "(users.UsersOverview.profile) Users with an empty `profile` field are considered inactive and cannot log in.", "filter": { "type": "string" }, "width": Lino.chars2width(23), "editor": profile37, "dataIndex": "profile" }, { "colIndex": 2, "sortable": true, "header": "Language", "editable": true, "tooltip": "(users.UsersOverview.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": language38, "dataIndex": "language" } ];
    Lino.users.UsersOverview.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.UsersOverview.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/UsersOverview", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.UsersOverview.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/UsersOverview", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.UsersOverview.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/UsersOverview", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.users.UsersOverview.insertPanel = Ext.extend(Lino.users.Users.InsertFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/users/UsersOverview",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.UsersOverview.detail;
    this.ls_insert_handler = Lino.users.UsersOverview.insert;
    Lino.users.UsersOverview.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.users.UsersOverview.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.UsersOverview.insertPanel(p);
});
Lino.users.UsersOverview.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/UsersOverview", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.UsersOverview.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/UsersOverview", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.UsersOverview.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/UsersOverview", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.users.UsersOverview.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true }, { "itemId": "change_password", "menu_item_text": "Change password", "panel_btn_handler": Lino.param_action_handler(Lino.users.Users.change_password), "text": "Change password", "overflowText": "Change password", "auto_save": true } ],
  ls_url: "/users/UsersOverview",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.UsersOverview.detail;
    this.ls_insert_handler = Lino.users.UsersOverview.insert;
    Lino.users.UsersOverview.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.UsersOverview.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.users.UsersOverview.detailPanel(p);
});
Lino.users.UsersOverview.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/UsersOverview", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.UsersOverview.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.users.UsersOverview.GridPanel(p);
});
Lino.users.UsersOverview.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/UsersOverview", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.UsersOverview.update_reminders = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/UsersOverview", "GET", pk, "update_reminders", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class users.Authorities
Lino.users.Authorities.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/Authorities",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/users/Authorities','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/users/Authorities','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Authorities",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "authorized" }, 'authorizedHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 8,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id1505 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1506 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Authorities/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var authorized1507 = new Lino.RemoteComboFieldElement({ "preferred_width": 15, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Authorities/authorized", "method": "GET" }) }), "emptyText": "Select a User..." });
    this.before_row_edit = function(record) {
      authorized1507.setContextValue('user', record ? record.data['userHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      user1506.on('change',Lino.chooser_handler(authorized1507,'user'));
      Lino.users.Authorities.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.Authorities.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1505, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Author", "editable": true, "tooltip": "(users.Authorities.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "dataIndex": "user", "editor": user1506 }, { "colIndex": 2, "sortable": true, "header": "User", "editable": true, "tooltip": "(users.Authorities.authorized) The user who gets authority to act in your name.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('authorizedHidden','Lino.users.Users.detail'), "dataIndex": "authorized", "editor": authorized1507 } ];
    Lino.users.Authorities.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Authorities.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Authorities", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Authorities.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Authorities", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Authorities.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Authorities", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Authorities.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Authorities", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Authorities.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Authorities", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Authorities.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Authorities", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Authorities.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.users.Authorities.GridPanel(p);
});

// js_render_GridPanel_class countries.Countries
Lino.countries.Countries.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/countries/Countries",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/countries/Countries','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/countries/Countries','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Countries",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "name": "name" }, { "name": "name_et" }, { "name": "isocode" }, { "name": "short_code" }, { "name": "iso3" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 9,
  ls_id_property : "isocode",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    var ww = this.containing_window;
    var name1509 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_et1510 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var isocode1511 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "allowBlank": false, "maxLength": 4 });
    var short_code1512 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    var iso31513 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "maxLength": 3 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(countries.Countries.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name1509, "dataIndex": "name" }, { "colIndex": 1, "sortable": true, "header": "Designation (et)", "editable": true, "tooltip": "(countries.Countries.name_et) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_et1510, "dataIndex": "name_et" }, { "colIndex": 2, "sortable": true, "header": "ISO code", "editable": true, "tooltip": "(countries.Countries.isocode)         The two-letter code for this country as defined by ISO 3166-1.\n        For countries that no longer exist it may be a 4-letter code.", "filter": { "type": "string" }, "width": Lino.chars2width(6), "editor": isocode1511, "dataIndex": "isocode" }, { "colIndex": 3, "sortable": true, "header": "Short code", "editable": true, "tooltip": "(countries.Countries.short_code) A short abbreviation for regional usage. Obsolete.", "filter": { "type": "string" }, "width": Lino.chars2width(6), "editor": short_code1512, "hidden": true, "dataIndex": "short_code" }, { "colIndex": 4, "sortable": true, "header": "ISO-3 code", "editable": true, "tooltip": "(countries.Countries.iso3) The three-letter code for this country as defined by ISO 3166-1.", "filter": { "type": "string" }, "width": Lino.chars2width(5), "editor": iso31513, "hidden": true, "dataIndex": "iso3" } ];
    Lino.countries.Countries.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Countries.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Countries.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.countries.Countries.insertPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/countries/Countries",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    Lino.countries.Countries.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.insert = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Countries.insertPanel(p);
});
Lino.countries.Countries.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Countries.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Countries.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.countries.Countries.detailPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  ls_url: "/countries/Countries",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    Lino.countries.Countries.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.detailPanel(p);
});
Lino.countries.Countries.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Countries.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.GridPanel(p);
});
Lino.countries.Countries.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class countries.Places
Lino.countries.Places.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/countries/Places",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/countries/Places','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/countries/Places','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Places",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 11,
  ls_store_fields : [ { "name": "country" }, 'countryHidden', { "name": "name" }, { "name": "name_et" }, { "name": "type" }, 'typeHidden', { "name": "zip_code" }, { "name": "parent" }, 'parentHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 9,
  ls_grid_configs : [  ],
  content_type : 10,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Places.detail;
    this.ls_insert_handler = Lino.countries.Places.insert;
    var ww = this.containing_window;
    var country1515 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Places/country", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Country..." });
    var name1516 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_et1517 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type1518 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Places/type", "method": "GET" }) }) });
    var zip_code1519 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "maxLength": 8 });
    var parent1520 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Places/parent", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var id1521 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      type1518.setContextValue('country', record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country1515.on('change',Lino.chooser_handler(type1518,'country'));
      Lino.countries.Places.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Country", "editable": true, "tooltip": "(countries.Places.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "dataIndex": "country", "editor": country1515 }, { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(countries.Places.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name1516, "dataIndex": "name" }, { "colIndex": 2, "sortable": true, "header": "Designation (et)", "editable": true, "tooltip": "(countries.Places.name_et) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_et1517, "dataIndex": "name_et" }, { "colIndex": 3, "sortable": true, "header": "Place Type", "editable": true, "tooltip": "(countries.Places.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": type1518, "dataIndex": "type" }, { "colIndex": 4, "sortable": true, "header": "zip code", "editable": true, "tooltip": "(countries.Places.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(10), "editor": zip_code1519, "dataIndex": "zip_code" }, { "colIndex": 5, "sortable": true, "header": "Part of", "editable": true, "tooltip": "(countries.Places.parent) The superordinate geographic place         of which this place is a part.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('parentHidden','Lino.countries.Places.detail'), "dataIndex": "parent", "editor": parent1520 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(countries.Places.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1521, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.countries.Places.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Places.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Places", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Places.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Places", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Places.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Places", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.countries.Places.insertPanel = Ext.extend(Lino.countries.Places.DetailFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/countries/Places",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Places.detail;
    this.ls_insert_handler = Lino.countries.Places.insert;
    Lino.countries.Places.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Places.insert = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Places.insertPanel(p);
});
Lino.countries.Places.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Places", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Places.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Places", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Places.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Places", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.countries.Places.detailPanel = Ext.extend(Lino.countries.Places.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  ls_url: "/countries/Places",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Places.detail;
    this.ls_insert_handler = Lino.countries.Places.insert;
    Lino.countries.Places.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Places.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Places.detailPanel(p);
});
Lino.countries.Places.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Places", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Places.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Places.GridPanel(p);
});
Lino.countries.Places.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Places", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class outbox.Recipients
Lino.outbox.Recipients.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/outbox/Recipients",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/outbox/Recipients','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/outbox/Recipients','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Recipients",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 10,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "mail" }, 'mailHidden', { "name": "partner" }, 'partnerHidden', { "name": "type" }, 'typeHidden', { "name": "address" }, { "name": "name" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 14,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id1523 = new Ext.form.NumberField({ "selectOnFocus": true });
    var mail1524 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Recipients/mail", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Outgoing Mail..." });
    var partner1525 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Recipients/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var type1526 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.outbox.RecipientTypes });
    var address1527 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var name1528 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(outbox.Recipients.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1523, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Outgoing Mail", "editable": true, "tooltip": "(outbox.Recipients.mail) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('mailHidden','Lino.outbox.Mails.detail'), "dataIndex": "mail", "editor": mail1524 }, { "colIndex": 2, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(outbox.Recipients.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "dataIndex": "partner", "editor": partner1525 }, { "colIndex": 3, "sortable": true, "header": "Recipient Type", "editable": true, "tooltip": "(outbox.Recipients.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(8), "editor": type1526, "dataIndex": "type" }, { "colIndex": 4, "sortable": true, "header": "Address", "editable": true, "tooltip": "(outbox.Recipients.address) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": address1527, "dataIndex": "address" }, { "colIndex": 5, "sortable": true, "header": "Name", "editable": true, "tooltip": "(outbox.Recipients.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name1528, "dataIndex": "name" } ];
    Lino.outbox.Recipients.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.Recipients.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/outbox/Recipients", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.outbox.Recipients.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/outbox/Recipients", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.outbox.Recipients.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/outbox/Recipients", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.outbox.Recipients.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/outbox/Recipients", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.outbox.Recipients.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/outbox/Recipients", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.outbox.Recipients.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/outbox/Recipients", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.outbox.Recipients.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.Recipients.GridPanel(p);
});

// js_render_GridPanel_class outbox.Mails
Lino.outbox.Mails.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/outbox/Mails",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/outbox/Mails','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/outbox/Mails','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Edit Print Template", "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Edit Print Template", "overflowText": "Edit Print Template", "auto_save": true }, { "itemId": "send_mail", "menu_item_text": "Send email", "tooltip": "Send email", "panel_btn_handler": Lino.row_action_handler('send_mail','GET',null), "iconCls": "x-tbar-email_go", "overflowText": "Send email", "auto_save": true } ],
  cell_edit : true,
  title : "Outgoing Mails",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 16,
  ls_store_fields : [ { "name": "sent" }, { "name": "recipients" }, { "name": "subject" }, { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "project" }, 'projectHidden', { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "owner" }, { "name": "body" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 13,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.Mails.detail;
    this.ls_insert_handler = Lino.outbox.Mails.insert;
    var ww = this.containing_window;
    var sent1530 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var recipients_htmlbox1531 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "recipients", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Recipients", "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden;" });
    var subject1532 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1533 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1534 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var project1535 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var owner_type1536 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id1537 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/owner_id", "method": "GET" }) }) });
    var date1538 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var owner_disp1539 = new Ext.form.DisplayField({ "disabled": true });
    var body1540 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Body" });
    this.before_row_edit = function(record) {
      recipients_htmlbox1531.refresh();
      body1540.refresh();
    };
    this.ls_columns = [ { "header": "sent", "colIndex": 0, "sortable": true, "dataIndex": "sent", "width": Lino.chars2width(17), "editable": false, "tooltip": "(outbox.Mails.sent) " }, { "header": "Recipients", "colIndex": 1, "sortable": false, "dataIndex": "recipients", "width": Lino.chars2width(31), "editable": false, "tooltip": "(outbox.Mails.recipients) " }, { "colIndex": 2, "sortable": true, "header": "Subject", "editable": true, "tooltip": "(outbox.Mails.subject) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": subject1532, "dataIndex": "subject" }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(outbox.Mails.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1533, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(outbox.Mails.user) ", "filter": { "type": "string" }, "header": "Sender", "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "dataIndex": "user", "hidden": true, "editor": user1534 }, { "colIndex": 5, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(outbox.Mails.project) ", "filter": { "type": "string" }, "header": "Project", "renderer": Lino.fk_renderer('projectHidden','Lino.projects.Projects.detail'), "dataIndex": "project", "hidden": true, "editor": project1535 }, { "colIndex": 6, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(outbox.Mails.owner_type) ", "filter": { "type": "string" }, "header": "Controlled by (type)", "renderer": Lino.fk_renderer('owner_typeHidden','Lino.contenttypes.ContentTypes.detail'), "dataIndex": "owner_type", "hidden": true, "editor": owner_type1536 }, { "colIndex": 7, "sortable": true, "header": "Controlled by (object)", "editable": true, "tooltip": "(outbox.Mails.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": owner_id1537, "hidden": true, "dataIndex": "owner_id" }, { "colIndex": 8, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(outbox.Mails.date) \n        The official date to be printed on the document.\n        ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "editor": date1538, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "date" }, { "colIndex": 9, "sortable": false, "width": Lino.chars2width(11), "editable": false, "tooltip": "(outbox.Mails.owner) ", "header": "Controlled by", "dataIndex": "owner", "hidden": true }, { "colIndex": 10, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(outbox.Mails.body) ", "filter": { "type": "string" }, "header": "body", "editor": body1540, "hidden": true, "dataIndex": "body" } ];
    Lino.outbox.Mails.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.Mails.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/outbox/Mails", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.outbox.Mails.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/outbox/Mails", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.outbox.Mails.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/outbox/Mails", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.outbox.Mails.insertPanel = Ext.extend(Lino.outbox.Mails.InsertFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/outbox/Mails",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.Mails.detail;
    this.ls_insert_handler = Lino.outbox.Mails.insert;
    Lino.outbox.Mails.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.Mails.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(20) }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.outbox.Mails.insertPanel(p);
});
Lino.outbox.Mails.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/outbox/Mails", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.outbox.Mails.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/outbox/Mails", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.outbox.Mails.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/outbox/Mails", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.outbox.Mails.detailPanel = Ext.extend(Lino.outbox.Mails.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Edit Print Template", "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Edit Print Template", "overflowText": "Edit Print Template", "auto_save": true }, { "itemId": "send_mail", "menu_item_text": "Send email", "tooltip": "Send email", "panel_btn_handler": Lino.row_action_handler('send_mail','GET',null), "iconCls": "x-tbar-email_go", "overflowText": "Send email", "auto_save": true } ],
  ls_url: "/outbox/Mails",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.Mails.detail;
    this.ls_insert_handler = Lino.outbox.Mails.insert;
    Lino.outbox.Mails.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.Mails.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.Mails.detailPanel(p);
});
Lino.outbox.Mails.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/outbox/Mails", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.outbox.Mails.do_print = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/outbox/Mails", "GET", pk, "do_print", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.outbox.Mails.edit_template = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/outbox/Mails", "GET", pk, "edit_template", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.outbox.Mails.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.Mails.GridPanel(p);
});
Lino.outbox.Mails.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/outbox/Mails", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.outbox.Mails.send_mail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/outbox/Mails", "GET", pk, "send_mail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class outbox.Attachments
Lino.outbox.Attachments.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/outbox/Attachments",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/outbox/Attachments','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/outbox/Attachments','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Attachments",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 9,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "mail" }, 'mailHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 15,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id1542 = new Ext.form.NumberField({ "selectOnFocus": true });
    var owner_type1543 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Attachments/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id1544 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Attachments/owner_id", "method": "GET" }) }) });
    var mail1545 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Attachments/mail", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Outgoing Mail..." });
    var owner_disp1546 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(outbox.Attachments.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1542, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Controlled by (type)", "editable": true, "tooltip": "(outbox.Attachments.owner_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('owner_typeHidden','Lino.contenttypes.ContentTypes.detail'), "dataIndex": "owner_type", "editor": owner_type1543 }, { "colIndex": 2, "sortable": true, "header": "Controlled by (object)", "editable": true, "tooltip": "(outbox.Attachments.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": owner_id1544, "dataIndex": "owner_id" }, { "colIndex": 3, "sortable": true, "header": "Outgoing Mail", "editable": true, "tooltip": "(outbox.Attachments.mail) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('mailHidden','Lino.outbox.Mails.detail'), "dataIndex": "mail", "editor": mail1545 }, { "header": "Controlled by", "colIndex": 4, "sortable": false, "dataIndex": "owner", "width": Lino.chars2width(11), "editable": false, "tooltip": "(outbox.Attachments.owner) " } ];
    Lino.outbox.Attachments.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.Attachments.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/outbox/Attachments", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.outbox.Attachments.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/outbox/Attachments", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.outbox.Attachments.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/outbox/Attachments", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.outbox.Attachments.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/outbox/Attachments", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.outbox.Attachments.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/outbox/Attachments", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.outbox.Attachments.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/outbox/Attachments", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.outbox.Attachments.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.outbox.Attachments.GridPanel(p);
});

// js_render_GridPanel_class excerpts.ExcerptTypes
Lino.excerpts.ExcerptTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/excerpts/ExcerptTypes",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/excerpts/ExcerptTypes','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/excerpts/ExcerptTypes','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Excerpt Types",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 19,
  ls_store_fields : [ { "name": "content_type" }, 'content_typeHidden', { "type": "boolean", "name": "primary" }, { "type": "boolean", "name": "certifying" }, { "name": "name" }, { "name": "name_et" }, { "name": "build_method" }, 'build_methodHidden', { "name": "template" }, { "type": "int", "name": "id" }, { "type": "boolean", "name": "attach_to_email" }, { "name": "email_template" }, { "name": "remark" }, { "name": "body_template" }, { "type": "boolean", "name": "backward_compat" }, { "type": "boolean", "name": "print_recipient" }, { "type": "boolean", "name": "print_directly" }, { "name": "shortcut" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 9,
  ls_grid_configs : [  ],
  content_type : 11,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.excerpts.ExcerptTypes.detail;
    this.ls_insert_handler = Lino.excerpts.ExcerptTypes.insert;
    var ww = this.containing_window;
    var content_type1548 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/ExcerptTypes/content_type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a content type..." });
    var primary1549 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var certifying1550 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var name1551 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_et1552 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var build_method1553 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.BuildMethods) });
    var template1554 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/ExcerptTypes/template", "method": "GET" }) }) });
    var id1555 = new Ext.form.NumberField({ "selectOnFocus": true });
    var attach_to_email1556 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var email_template1557 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/ExcerptTypes/email_template", "method": "GET" }) }) });
    var remark1558 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var body_template1559 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/ExcerptTypes/body_template", "method": "GET" }) }) });
    var backward_compat1560 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var print_recipient1561 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": true });
    var print_directly1562 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": true });
    var shortcut1563 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(1), "maxLength": 1 });
    this.before_row_edit = function(record) {
      template1554.setContextValue('build_method', record ? record.data['build_methodHidden'] : undefined);
      template1554.setContextValue('content_type', record ? record.data['content_typeHidden'] : undefined);
      email_template1557.setContextValue('content_type', record ? record.data['content_typeHidden'] : undefined);
      body_template1559.setContextValue('content_type', record ? record.data['content_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      build_method1553.on('change',Lino.chooser_handler(template1554,'build_method'));
      content_type1548.on('change',Lino.chooser_handler(template1554,'content_type'));
      content_type1548.on('change',Lino.chooser_handler(email_template1557,'content_type'));
      content_type1548.on('change',Lino.chooser_handler(body_template1559,'content_type'));
      Lino.excerpts.ExcerptTypes.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Model", "editable": true, "tooltip": "(excerpts.ExcerptTypes.content_type) The model that can issue printouts of this type.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('content_typeHidden','Lino.contenttypes.ContentTypes.detail'), "dataIndex": "content_type", "editor": content_type1548 }, { "colIndex": 1, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(excerpts.ExcerptTypes.primary) There's at most one primary type per model.         Enabling this field will automatically make the other         types non-primary.", "filter": { "type": "boolean" }, "header": "Primary", "dataIndex": "primary" }, { "colIndex": 2, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(excerpts.ExcerptTypes.certifying) Whether an excerpt of this type is a unique printout.", "filter": { "type": "boolean" }, "header": "Certifying", "dataIndex": "certifying" }, { "colIndex": 3, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(excerpts.ExcerptTypes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name1551, "dataIndex": "name" }, { "colIndex": 4, "sortable": true, "header": "Designation (et)", "editable": true, "tooltip": "(excerpts.ExcerptTypes.name_et) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_et1552, "dataIndex": "name_et" }, { "colIndex": 5, "sortable": true, "header": "Build method", "editable": true, "tooltip": "(excerpts.ExcerptTypes.build_method) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": build_method1553, "dataIndex": "build_method" }, { "colIndex": 6, "sortable": true, "header": "Template", "editable": true, "tooltip": "(excerpts.ExcerptTypes.template) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": template1554, "dataIndex": "template" }, new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "format": "0", "editable": true, "tooltip": "(excerpts.ExcerptTypes.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1555, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 8, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(excerpts.ExcerptTypes.attach_to_email) Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n", "filter": { "type": "boolean" }, "header": "Attach to email", "dataIndex": "attach_to_email", "hidden": true }, { "colIndex": 9, "sortable": true, "header": "Email template", "editable": true, "tooltip": "(excerpts.ExcerptTypes.email_template) The name of the file to be used as template when creating an email from a mailable of this type.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": email_template1557, "hidden": true, "dataIndex": "email_template" }, { "colIndex": 10, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(excerpts.ExcerptTypes.remark) ", "filter": { "type": "string" }, "header": "Remark", "editor": remark1558, "hidden": true, "dataIndex": "remark" }, { "colIndex": 11, "sortable": true, "header": "Body template", "editable": true, "tooltip": "(excerpts.ExcerptTypes.body_template) The body template to be used when         rendering a printable of this type. This is a list of files         with extension `.body.html`.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": body_template1559, "hidden": true, "dataIndex": "body_template" }, { "colIndex": 12, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(excerpts.ExcerptTypes.backward_compat) Check this to have `this` in template context point to owner instead of excerpt.", "filter": { "type": "boolean" }, "header": "Backward compatible", "dataIndex": "backward_compat", "hidden": true }, { "colIndex": 13, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(excerpts.ExcerptTypes.print_recipient) Whether to print a recipient field in document.", "filter": { "type": "boolean" }, "header": "Print recipient", "dataIndex": "print_recipient", "hidden": true }, { "colIndex": 14, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(excerpts.ExcerptTypes.print_directly) ", "filter": { "type": "boolean" }, "header": "Print directly", "dataIndex": "print_directly", "hidden": true }, { "colIndex": 15, "sortable": true, "header": "Excerpt shortcut", "editable": true, "tooltip": "(excerpts.ExcerptTypes.shortcut) ", "filter": { "type": "string" }, "width": Lino.chars2width(5), "editor": shortcut1563, "hidden": true, "dataIndex": "shortcut" } ];
    Lino.excerpts.ExcerptTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.excerpts.ExcerptTypes.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/ExcerptTypes", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.excerpts.ExcerptTypes.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/ExcerptTypes", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.excerpts.ExcerptTypes.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/ExcerptTypes", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.excerpts.ExcerptTypes.insertPanel = Ext.extend(Lino.excerpts.ExcerptTypes.InsertFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/excerpts/ExcerptTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.excerpts.ExcerptTypes.detail;
    this.ls_insert_handler = Lino.excerpts.ExcerptTypes.insert;
    Lino.excerpts.ExcerptTypes.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.excerpts.ExcerptTypes.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.excerpts.ExcerptTypes.insertPanel(p);
});
Lino.excerpts.ExcerptTypes.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/ExcerptTypes", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.excerpts.ExcerptTypes.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/ExcerptTypes", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.excerpts.ExcerptTypes.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/ExcerptTypes", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.excerpts.ExcerptTypes.detailPanel = Ext.extend(Lino.excerpts.ExcerptTypes.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  ls_url: "/excerpts/ExcerptTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.excerpts.ExcerptTypes.detail;
    this.ls_insert_handler = Lino.excerpts.ExcerptTypes.insert;
    Lino.excerpts.ExcerptTypes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.excerpts.ExcerptTypes.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.excerpts.ExcerptTypes.detailPanel(p);
});
Lino.excerpts.ExcerptTypes.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/ExcerptTypes", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.excerpts.ExcerptTypes.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.excerpts.ExcerptTypes.GridPanel(p);
});
Lino.excerpts.ExcerptTypes.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/ExcerptTypes", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class excerpts.Excerpts
Lino.excerpts.Excerpts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/excerpts/Excerpts",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/excerpts/Excerpts','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/excerpts/Excerpts','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Clear cache", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Edit Print Template", "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Edit Print Template", "overflowText": "Edit Print Template", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "Create email", "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "Create email", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "Create posting", "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET',null), "iconCls": "x-tbar-script_add", "overflowText": "Create posting", "auto_save": true } ],
  cell_edit : true,
  title : "Excerpts",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 24,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "build_time" }, { "name": "owner" }, { "name": "excerpt_type" }, 'excerpt_typeHidden', { "name": "user" }, 'userHidden', { "name": "project" }, 'projectHidden', { "name": "company" }, 'companyHidden', { "name": "contact_person" }, 'contact_personHidden', { "name": "language" }, 'languageHidden', { "name": "build_method" }, 'build_methodHidden', { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "contact_role" }, 'contact_roleHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 12,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.excerpts.Excerpts.detail;
    var ww = this.containing_window;
    var id1565 = new Ext.form.NumberField({ "selectOnFocus": true });
    var build_time1566 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var owner_disp1567 = new Ext.form.DisplayField({ "disabled": true });
    var excerpt_type1568 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/excerpt_type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Excerpt Type..." });
    var user1569 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var project1570 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var company1571 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Organisation..." });
    var contact_person1572 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/contact_person", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Person..." });
    var language1573 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "English" ], [ "et", "Estonian" ] ] });
    var build_method1574 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.lino.BuildMethods });
    var owner_type1575 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id1576 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/owner_id", "method": "GET" }) }) });
    var contact_role1577 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/contact_role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Function..." });
    this.before_row_edit = function(record) {
      excerpt_type1568.setContextValue('owner', record ? record.data['owner'] : undefined);
      contact_person1572.setContextValue('company', record ? record.data['companyHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_disp1567.on('change',Lino.chooser_handler(excerpt_type1568,'owner'));
      company1571.on('change',Lino.chooser_handler(contact_person1572,'company'));
      Lino.excerpts.Excerpts.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(excerpts.Excerpts.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1565, "width": Lino.chars2width(6), "dataIndex": "id" }), { "header": "build time", "colIndex": 1, "sortable": true, "dataIndex": "build_time", "width": Lino.chars2width(17), "editable": false, "tooltip": "(excerpts.Excerpts.build_time) " }, { "header": "Controlled by", "colIndex": 2, "sortable": false, "dataIndex": "owner", "width": Lino.chars2width(11), "editable": false, "tooltip": "(excerpts.Excerpts.owner) " }, { "colIndex": 3, "sortable": true, "header": "Excerpt Type", "editable": true, "tooltip": "(excerpts.Excerpts.excerpt_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('excerpt_typeHidden','Lino.excerpts.ExcerptTypes.detail'), "dataIndex": "excerpt_type", "editor": excerpt_type1568 }, { "colIndex": 4, "sortable": true, "header": "Author", "editable": true, "tooltip": "(excerpts.Excerpts.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "dataIndex": "user", "editor": user1569 }, { "colIndex": 5, "sortable": true, "header": "Project", "editable": true, "tooltip": "(excerpts.Excerpts.project) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.projects.Projects.detail'), "dataIndex": "project", "editor": project1570 }, { "colIndex": 6, "sortable": true, "header": "Recipient (Organization)", "editable": true, "tooltip": "(excerpts.Excerpts.company) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('companyHidden','Lino.contacts.Companies.detail'), "dataIndex": "company", "editor": company1571 }, { "colIndex": 7, "sortable": true, "header": "Recipient (Person)", "editable": true, "tooltip": "(excerpts.Excerpts.contact_person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('contact_personHidden','Lino.contacts.Persons.detail'), "dataIndex": "contact_person", "editor": contact_person1572 }, { "colIndex": 8, "sortable": true, "header": "Language", "editable": true, "tooltip": "(excerpts.Excerpts.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": language1573, "dataIndex": "language" }, { "colIndex": 9, "sortable": true, "header": "Build method", "editable": true, "tooltip": "(excerpts.Excerpts.build_method) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": build_method1574, "hidden": true, "dataIndex": "build_method" }, { "colIndex": 10, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(excerpts.Excerpts.owner_type) ", "filter": { "type": "string" }, "header": "Controlled by (type)", "renderer": Lino.fk_renderer('owner_typeHidden','Lino.contenttypes.ContentTypes.detail'), "dataIndex": "owner_type", "hidden": true, "editor": owner_type1575 }, { "colIndex": 11, "sortable": true, "header": "Controlled by (object)", "editable": true, "tooltip": "(excerpts.Excerpts.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": owner_id1576, "hidden": true, "dataIndex": "owner_id" }, { "colIndex": 12, "sortable": true, "header": "represented as", "editable": true, "tooltip": "(excerpts.Excerpts.contact_role) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": contact_role1577, "hidden": true, "dataIndex": "contact_role" } ];
    Lino.excerpts.Excerpts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.excerpts.Excerpts.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/Excerpts", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.excerpts.Excerpts.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/Excerpts", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.excerpts.Excerpts.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/Excerpts", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.excerpts.Excerpts.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/Excerpts", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.excerpts.Excerpts.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/Excerpts", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.excerpts.Excerpts.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/Excerpts", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.excerpts.Excerpts.duplicate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/Excerpts", "GET", pk, "duplicate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.excerpts.Excerpts.detailPanel = Ext.extend(Lino.excerpts.Excerpts.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Clear cache", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Edit Print Template", "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Edit Print Template", "overflowText": "Edit Print Template", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "Create email", "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "Create email", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "Create posting", "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET',null), "iconCls": "x-tbar-script_add", "overflowText": "Create posting", "auto_save": true } ],
  ls_url: "/excerpts/Excerpts",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.excerpts.Excerpts.detail;
    Lino.excerpts.Excerpts.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.excerpts.Excerpts.detail = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(80), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(20) }, function(){
  var p = { "is_main_window": true };
  return new Lino.excerpts.Excerpts.detailPanel(p);
});
Lino.excerpts.Excerpts.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/Excerpts", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.excerpts.Excerpts.do_print = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/Excerpts", "POST", pk, "do_print", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.excerpts.Excerpts.do_clear_cache = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/Excerpts", "GET", pk, "do_clear_cache", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.excerpts.Excerpts.edit_template = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/Excerpts", "GET", pk, "edit_template", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.excerpts.Excerpts.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.excerpts.Excerpts.ParamsPanel({});
  return new Lino.excerpts.Excerpts.GridPanel(p);
});
Lino.excerpts.Excerpts.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/Excerpts", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.excerpts.Excerpts.create_mail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/Excerpts", "GET", pk, "create_mail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.excerpts.Excerpts.create_postings = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/Excerpts", "GET", pk, "create_postings", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class excerpts.ExcerptsByX
Lino.excerpts.ExcerptsByX.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "No data to display." },
  ls_url : "/excerpts/ExcerptsByX",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/excerpts/ExcerptsByX','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/excerpts/ExcerptsByX','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Clear cache", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Edit Print Template", "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Edit Print Template", "overflowText": "Edit Print Template", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "Create posting", "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET',null), "iconCls": "x-tbar-script_add", "overflowText": "Create posting", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "Create email", "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "Create email", "auto_save": true } ],
  cell_edit : true,
  title : "Excerpts",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 24,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "build_time" }, { "name": "owner" }, { "name": "excerpt_type" }, 'excerpt_typeHidden', { "name": "user" }, 'userHidden', { "name": "project" }, 'projectHidden', { "name": "company" }, 'companyHidden', { "name": "contact_person" }, 'contact_personHidden', { "name": "language" }, 'languageHidden', { "name": "build_method" }, 'build_methodHidden', { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "contact_role" }, 'contact_roleHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 12,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.excerpts.ExcerptsByX.detail;
    var ww = this.containing_window;
    var id1579 = new Ext.form.NumberField({ "selectOnFocus": true });
    var build_time1580 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var owner_disp1581 = new Ext.form.DisplayField({ "disabled": true });
    var excerpt_type1582 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/ExcerptsByX/excerpt_type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Excerpt Type..." });
    var user1583 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/ExcerptsByX/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var project1584 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/ExcerptsByX/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var company1585 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/ExcerptsByX/company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Organisation..." });
    var contact_person1586 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/ExcerptsByX/contact_person", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Person..." });
    var language1587 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "English" ], [ "et", "Estonian" ] ] });
    var build_method1588 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.lino.BuildMethods });
    var owner_type1589 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/ExcerptsByX/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id1590 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/ExcerptsByX/owner_id", "method": "GET" }) }) });
    var contact_role1591 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/ExcerptsByX/contact_role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Function..." });
    this.before_row_edit = function(record) {
      excerpt_type1582.setContextValue('owner', record ? record.data['owner'] : undefined);
      contact_person1586.setContextValue('company', record ? record.data['companyHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_disp1581.on('change',Lino.chooser_handler(excerpt_type1582,'owner'));
      company1585.on('change',Lino.chooser_handler(contact_person1586,'company'));
      Lino.excerpts.ExcerptsByX.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(excerpts.ExcerptsByX.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1579, "width": Lino.chars2width(6), "dataIndex": "id" }), { "header": "build time", "colIndex": 1, "sortable": true, "dataIndex": "build_time", "width": Lino.chars2width(17), "editable": false, "tooltip": "(excerpts.ExcerptsByX.build_time) " }, { "header": "Controlled by", "colIndex": 2, "sortable": false, "dataIndex": "owner", "width": Lino.chars2width(11), "editable": false, "tooltip": "(excerpts.ExcerptsByX.owner) " }, { "colIndex": 3, "sortable": true, "header": "Excerpt Type", "editable": true, "tooltip": "(excerpts.ExcerptsByX.excerpt_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('excerpt_typeHidden','Lino.excerpts.ExcerptTypes.detail'), "dataIndex": "excerpt_type", "editor": excerpt_type1582 }, { "colIndex": 4, "sortable": true, "header": "Author", "editable": true, "tooltip": "(excerpts.ExcerptsByX.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "dataIndex": "user", "editor": user1583 }, { "colIndex": 5, "sortable": true, "header": "Project", "editable": true, "tooltip": "(excerpts.ExcerptsByX.project) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.projects.Projects.detail'), "dataIndex": "project", "editor": project1584 }, { "colIndex": 6, "sortable": true, "header": "Recipient (Organization)", "editable": true, "tooltip": "(excerpts.ExcerptsByX.company) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('companyHidden','Lino.contacts.Companies.detail'), "dataIndex": "company", "editor": company1585 }, { "colIndex": 7, "sortable": true, "header": "Recipient (Person)", "editable": true, "tooltip": "(excerpts.ExcerptsByX.contact_person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('contact_personHidden','Lino.contacts.Persons.detail'), "dataIndex": "contact_person", "editor": contact_person1586 }, { "colIndex": 8, "sortable": true, "header": "Language", "editable": true, "tooltip": "(excerpts.ExcerptsByX.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": language1587, "dataIndex": "language" }, { "colIndex": 9, "sortable": true, "header": "Build method", "editable": true, "tooltip": "(excerpts.ExcerptsByX.build_method) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": build_method1588, "hidden": true, "dataIndex": "build_method" }, { "colIndex": 10, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(excerpts.ExcerptsByX.owner_type) ", "filter": { "type": "string" }, "header": "Controlled by (type)", "renderer": Lino.fk_renderer('owner_typeHidden','Lino.contenttypes.ContentTypes.detail'), "dataIndex": "owner_type", "hidden": true, "editor": owner_type1589 }, { "colIndex": 11, "sortable": true, "header": "Controlled by (object)", "editable": true, "tooltip": "(excerpts.ExcerptsByX.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": owner_id1590, "hidden": true, "dataIndex": "owner_id" }, { "colIndex": 12, "sortable": true, "header": "represented as", "editable": true, "tooltip": "(excerpts.ExcerptsByX.contact_role) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": contact_role1591, "hidden": true, "dataIndex": "contact_role" } ];
    Lino.excerpts.ExcerptsByX.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.excerpts.ExcerptsByX.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/ExcerptsByX", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.excerpts.ExcerptsByX.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/ExcerptsByX", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.excerpts.ExcerptsByX.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/ExcerptsByX", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.excerpts.ExcerptsByX.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/ExcerptsByX", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.excerpts.ExcerptsByX.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/ExcerptsByX", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.excerpts.ExcerptsByX.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/ExcerptsByX", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.excerpts.ExcerptsByX.duplicate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/ExcerptsByX", "GET", pk, "duplicate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.excerpts.ExcerptsByX.detailPanel = Ext.extend(Lino.excerpts.Excerpts.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Clear cache", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Edit Print Template", "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Edit Print Template", "overflowText": "Edit Print Template", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "Create posting", "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET',null), "iconCls": "x-tbar-script_add", "overflowText": "Create posting", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "Create email", "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "Create email", "auto_save": true } ],
  ls_url: "/excerpts/ExcerptsByX",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.excerpts.ExcerptsByX.detail;
    Lino.excerpts.ExcerptsByX.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.excerpts.ExcerptsByX.detail = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(80), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(20) }, function(){
  var p = { "is_main_window": true };
  return new Lino.excerpts.ExcerptsByX.detailPanel(p);
});
Lino.excerpts.ExcerptsByX.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/ExcerptsByX", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.excerpts.ExcerptsByX.do_print = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/ExcerptsByX", "POST", pk, "do_print", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.excerpts.ExcerptsByX.do_clear_cache = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/ExcerptsByX", "GET", pk, "do_clear_cache", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.excerpts.ExcerptsByX.edit_template = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/ExcerptsByX", "GET", pk, "edit_template", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.excerpts.ExcerptsByX.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.excerpts.Excerpts.ParamsPanel({});
  return new Lino.excerpts.ExcerptsByX.GridPanel(p);
});
Lino.excerpts.ExcerptsByX.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/ExcerptsByX", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.excerpts.ExcerptsByX.create_postings = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/ExcerptsByX", "GET", pk, "create_postings", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.excerpts.ExcerptsByX.create_mail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/excerpts/ExcerptsByX", "GET", pk, "create_mail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class uploads.UploadTypes
Lino.uploads.UploadTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/uploads/UploadTypes",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/uploads/UploadTypes','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/uploads/UploadTypes','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Upload Types",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 8,
  ls_store_fields : [ { "name": "upload_area" }, 'upload_areaHidden', { "name": "name" }, { "name": "name_et" }, { "type": "int", "name": "id" }, { "type": "int", "name": "max_number" }, { "type": "boolean", "name": "wanted" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 16,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.UploadTypes.detail;
    this.ls_insert_handler = Lino.uploads.UploadTypes.insert;
    var ww = this.containing_window;
    var upload_area1593 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.uploads.UploadAreas });
    var name1594 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_et1595 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1596 = new Ext.form.NumberField({ "selectOnFocus": true });
    var max_number1597 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": -1 });
    var wanted1598 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Upload Area", "editable": true, "tooltip": "(uploads.UploadTypes.upload_area) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": upload_area1593, "dataIndex": "upload_area" }, { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(uploads.UploadTypes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name1594, "dataIndex": "name" }, { "colIndex": 2, "sortable": true, "header": "Designation (et)", "editable": true, "tooltip": "(uploads.UploadTypes.name_et) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_et1595, "dataIndex": "name_et" }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(uploads.UploadTypes.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1596, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(uploads.UploadTypes.max_number) No need to upload more uploads than N of this type.\n-1 means no limit.", "filter": { "type": "numeric" }, "header": "Max. number", "editor": max_number1597, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "max_number" }), { "colIndex": 5, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(uploads.UploadTypes.wanted) Add a (+) button when there is no upload of this type.", "filter": { "type": "boolean" }, "header": "Wanted", "dataIndex": "wanted", "hidden": true } ];
    Lino.uploads.UploadTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.UploadTypes.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/uploads/UploadTypes", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.uploads.UploadTypes.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/uploads/UploadTypes", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.uploads.UploadTypes.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/uploads/UploadTypes", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.uploads.UploadTypes.insertPanel = Ext.extend(Lino.uploads.UploadTypes.InsertFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/uploads/UploadTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.UploadTypes.detail;
    this.ls_insert_handler = Lino.uploads.UploadTypes.insert;
    Lino.uploads.UploadTypes.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.UploadTypes.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.uploads.UploadTypes.insertPanel(p);
});
Lino.uploads.UploadTypes.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/uploads/UploadTypes", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.uploads.UploadTypes.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/uploads/UploadTypes", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.uploads.UploadTypes.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/uploads/UploadTypes", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.uploads.UploadTypes.detailPanel = Ext.extend(Lino.uploads.UploadTypes.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  ls_url: "/uploads/UploadTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.UploadTypes.detail;
    this.ls_insert_handler = Lino.uploads.UploadTypes.insert;
    Lino.uploads.UploadTypes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.UploadTypes.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.UploadTypes.detailPanel(p);
});
Lino.uploads.UploadTypes.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/uploads/UploadTypes", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.uploads.UploadTypes.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.UploadTypes.GridPanel(p);
});
Lino.uploads.UploadTypes.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/uploads/UploadTypes", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class uploads.Uploads
Lino.uploads.Uploads.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/uploads/Uploads",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/uploads/Uploads','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/uploads/Uploads','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Uploads",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 16,
  ls_store_fields : [ { "name": "file" }, { "name": "type" }, 'typeHidden', { "name": "user" }, 'userHidden', { "name": "owner" }, { "name": "description" }, { "type": "int", "name": "id" }, { "name": "mimetype" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "upload_area" }, 'upload_areaHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 17,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.Uploads.detail;
    this.ls_insert_handler = Lino.uploads.Uploads.insert;
    var ww = this.containing_window;
    var file1600 = Lino.file_field_handler(this,{ "selectOnFocus": true, "maxLength": 100 });
    var type1601 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Upload Type..." });
    var user1602 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var owner_disp1603 = new Ext.form.DisplayField({ "disabled": true });
    var description1604 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1605 = new Ext.form.NumberField({ "selectOnFocus": true });
    var mimetype1606 = new Ext.form.TextField({ "disabled": true, "maxLength": 64 });
    var owner_type1607 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id1608 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/owner_id", "method": "GET" }) }) });
    var upload_area1609 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.uploads.UploadAreas });
    this.before_row_edit = function(record) {
      type1601.setContextValue('upload_area', record ? record.data['upload_areaHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      upload_area1609.on('change',Lino.chooser_handler(type1601,'upload_area'));
      Lino.uploads.Uploads.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "File", "editable": true, "tooltip": "(uploads.Uploads.file) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": file1600, "dataIndex": "file" }, { "colIndex": 1, "sortable": true, "header": "Upload Type", "editable": true, "tooltip": "(uploads.Uploads.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('typeHidden','Lino.uploads.UploadTypes.detail'), "dataIndex": "type", "editor": type1601 }, { "colIndex": 2, "sortable": true, "header": "Author", "editable": true, "tooltip": "(uploads.Uploads.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "dataIndex": "user", "editor": user1602 }, { "header": "Controlled by", "colIndex": 3, "sortable": false, "dataIndex": "owner", "width": Lino.chars2width(11), "editable": false, "tooltip": "(uploads.Uploads.owner) " }, { "colIndex": 4, "sortable": true, "header": "Description", "editable": true, "tooltip": "(uploads.Uploads.description) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": description1604, "dataIndex": "description" }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(uploads.Uploads.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1605, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "MIME type", "editable": false, "tooltip": "(uploads.Uploads.mimetype) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "mimetype", "hidden": true }, { "colIndex": 7, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(uploads.Uploads.owner_type) ", "filter": { "type": "string" }, "header": "Controlled by (type)", "renderer": Lino.fk_renderer('owner_typeHidden','Lino.contenttypes.ContentTypes.detail'), "dataIndex": "owner_type", "hidden": true, "editor": owner_type1607 }, { "colIndex": 8, "sortable": true, "header": "Controlled by (object)", "editable": true, "tooltip": "(uploads.Uploads.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": owner_id1608, "hidden": true, "dataIndex": "owner_id" }, { "colIndex": 9, "sortable": true, "header": "Upload Area", "editable": true, "tooltip": "(uploads.Uploads.upload_area) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": upload_area1609, "hidden": true, "dataIndex": "upload_area" } ];
    Lino.uploads.Uploads.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.Uploads.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/uploads/Uploads", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.uploads.Uploads.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/uploads/Uploads", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.uploads.Uploads.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/uploads/Uploads", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.uploads.Uploads.insertPanel = Ext.extend(Lino.uploads.Uploads.InsertFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/uploads/Uploads",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.Uploads.detail;
    this.ls_insert_handler = Lino.uploads.Uploads.insert;
    Lino.uploads.Uploads.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.Uploads.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.uploads.Uploads.insertPanel(p);
});
Lino.uploads.Uploads.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/uploads/Uploads", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.uploads.Uploads.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/uploads/Uploads", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.uploads.Uploads.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/uploads/Uploads", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.uploads.Uploads.detailPanel = Ext.extend(Lino.uploads.Uploads.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  ls_url: "/uploads/Uploads",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.Uploads.detail;
    this.ls_insert_handler = Lino.uploads.Uploads.insert;
    Lino.uploads.Uploads.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.Uploads.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.Uploads.detailPanel(p);
});
Lino.uploads.Uploads.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/uploads/Uploads", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.uploads.Uploads.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.Uploads.GridPanel(p);
});
Lino.uploads.Uploads.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/uploads/Uploads", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class uploads.AreaUploads
Lino.uploads.AreaUploads.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/uploads/AreaUploads",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/uploads/AreaUploads','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/uploads/AreaUploads','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Uploads",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 16,
  ls_store_fields : [ { "name": "file" }, { "name": "type" }, 'typeHidden', { "name": "user" }, 'userHidden', { "name": "owner" }, { "name": "description" }, { "type": "int", "name": "id" }, { "name": "mimetype" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "upload_area" }, 'upload_areaHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 17,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.AreaUploads.detail;
    this.ls_insert_handler = Lino.uploads.AreaUploads.insert;
    var ww = this.containing_window;
    var file1611 = Lino.file_field_handler(this,{ "selectOnFocus": true, "maxLength": 100 });
    var type1612 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/AreaUploads/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Upload Type..." });
    var user1613 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/AreaUploads/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var owner_disp1614 = new Ext.form.DisplayField({ "disabled": true });
    var description1615 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1616 = new Ext.form.NumberField({ "selectOnFocus": true });
    var mimetype1617 = new Ext.form.TextField({ "disabled": true, "maxLength": 64 });
    var owner_type1618 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/AreaUploads/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id1619 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/AreaUploads/owner_id", "method": "GET" }) }) });
    var upload_area1620 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.uploads.UploadAreas });
    this.before_row_edit = function(record) {
      type1612.setContextValue('upload_area', record ? record.data['upload_areaHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      upload_area1620.on('change',Lino.chooser_handler(type1612,'upload_area'));
      Lino.uploads.AreaUploads.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "File", "editable": true, "tooltip": "(uploads.AreaUploads.file) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": file1611, "dataIndex": "file" }, { "colIndex": 1, "sortable": true, "header": "Upload Type", "editable": true, "tooltip": "(uploads.AreaUploads.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('typeHidden','Lino.uploads.UploadTypes.detail'), "dataIndex": "type", "editor": type1612 }, { "colIndex": 2, "sortable": true, "header": "Author", "editable": true, "tooltip": "(uploads.AreaUploads.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "dataIndex": "user", "editor": user1613 }, { "header": "Controlled by", "colIndex": 3, "sortable": false, "dataIndex": "owner", "width": Lino.chars2width(11), "editable": false, "tooltip": "(uploads.AreaUploads.owner) " }, { "colIndex": 4, "sortable": true, "header": "Description", "editable": true, "tooltip": "(uploads.AreaUploads.description) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": description1615, "dataIndex": "description" }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(uploads.AreaUploads.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1616, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "MIME type", "editable": false, "tooltip": "(uploads.AreaUploads.mimetype) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "mimetype", "hidden": true }, { "colIndex": 7, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(uploads.AreaUploads.owner_type) ", "filter": { "type": "string" }, "header": "Controlled by (type)", "renderer": Lino.fk_renderer('owner_typeHidden','Lino.contenttypes.ContentTypes.detail'), "dataIndex": "owner_type", "hidden": true, "editor": owner_type1618 }, { "colIndex": 8, "sortable": true, "header": "Controlled by (object)", "editable": true, "tooltip": "(uploads.AreaUploads.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": owner_id1619, "hidden": true, "dataIndex": "owner_id" }, { "colIndex": 9, "sortable": true, "header": "Upload Area", "editable": true, "tooltip": "(uploads.AreaUploads.upload_area) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": upload_area1620, "hidden": true, "dataIndex": "upload_area" } ];
    Lino.uploads.AreaUploads.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.AreaUploads.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/uploads/AreaUploads", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.uploads.AreaUploads.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/uploads/AreaUploads", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.uploads.AreaUploads.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/uploads/AreaUploads", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.uploads.AreaUploads.insertPanel = Ext.extend(Lino.uploads.Uploads.InsertFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/uploads/AreaUploads",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.AreaUploads.detail;
    this.ls_insert_handler = Lino.uploads.AreaUploads.insert;
    Lino.uploads.AreaUploads.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.AreaUploads.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.uploads.AreaUploads.insertPanel(p);
});
Lino.uploads.AreaUploads.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/uploads/AreaUploads", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.uploads.AreaUploads.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/uploads/AreaUploads", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.uploads.AreaUploads.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/uploads/AreaUploads", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.uploads.AreaUploads.detailPanel = Ext.extend(Lino.uploads.Uploads.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  ls_url: "/uploads/AreaUploads",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.AreaUploads.detail;
    this.ls_insert_handler = Lino.uploads.AreaUploads.insert;
    Lino.uploads.AreaUploads.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.AreaUploads.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.AreaUploads.detailPanel(p);
});
Lino.uploads.AreaUploads.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/uploads/AreaUploads", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.uploads.AreaUploads.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.uploads.AreaUploads.GridPanel(p);
});
Lino.uploads.AreaUploads.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/uploads/AreaUploads", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class contacts.CompanyTypes
Lino.contacts.CompanyTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/CompanyTypes",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/contacts/CompanyTypes','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/contacts/CompanyTypes','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Organization types",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "name": "name" }, { "name": "name_et" }, { "type": "int", "name": "id" }, { "name": "abbr" }, { "name": "abbr_et" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 23,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var name1622 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_et1623 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1624 = new Ext.form.NumberField({ "selectOnFocus": true });
    var abbr1625 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var abbr_et1626 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(contacts.CompanyTypes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name1622, "dataIndex": "name" }, { "colIndex": 1, "sortable": true, "header": "Designation (et)", "editable": true, "tooltip": "(contacts.CompanyTypes.name_et) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_et1623, "dataIndex": "name_et" }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.CompanyTypes.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1624, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 3, "sortable": true, "header": "Abbreviation", "editable": true, "tooltip": "(contacts.CompanyTypes.abbr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": abbr1625, "hidden": true, "dataIndex": "abbr" }, { "colIndex": 4, "sortable": true, "header": "Abbreviation (et)", "editable": true, "tooltip": "(contacts.CompanyTypes.abbr_et) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": abbr_et1626, "hidden": true, "dataIndex": "abbr_et" } ];
    Lino.contacts.CompanyTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.CompanyTypes.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/CompanyTypes", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.CompanyTypes.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/CompanyTypes", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.CompanyTypes.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/CompanyTypes", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.CompanyTypes.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/CompanyTypes", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.CompanyTypes.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/CompanyTypes", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.CompanyTypes.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/CompanyTypes", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.CompanyTypes.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.CompanyTypes.GridPanel(p);
});

// js_render_GridPanel_class contacts.Partners
Lino.contacts.Partners.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Partners",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/contacts/Partners','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "print_labels", "menu_item_text": "Labels", "tooltip": "Generate mailing labels for these recipients", "panel_btn_handler": Lino.list_action_handler('/contacts/Partners','print_labels','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-pdf", "overflowText": "Labels", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/contacts/Partners','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Partners",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 28,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "modified" }, { "name": "created" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "zip_code" }, { "name": "region" }, 'regionHidden', { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "name": "iban" }, { "name": "bic" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 26,
  ls_grid_configs : [  ],
  content_type : 22,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    var ww = this.containing_window;
    var name1628 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email1629 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var modified1630 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created1631 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country1632 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Country..." });
    var city1633 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var zip_code1634 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var region1635 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var addr11636 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix1637 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street1638 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no1639 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box1640 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr21641 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language1642 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "English" ], [ "et", "Estonian" ] ] });
    var url1643 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone1644 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm1645 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax1646 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks1647 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var iban1648 = new Lino.UppercaseTextField({ "selectOnFocus": true, "maxLength": 34 });
    var bic1649 = new Lino.UppercaseTextField({ "selectOnFocus": true, "maxLength": 11 });
    var id1650 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city1633.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city1633.setContextValue('region', record ? record.data['regionHidden'] : undefined);
      region1635.setContextValue('country', record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country1632.on('change',Lino.chooser_handler(city1633,'country'));
      region1635.on('change',Lino.chooser_handler(city1633,'region'));
      country1632.on('change',Lino.chooser_handler(region1635,'country'));
      Lino.contacts.Partners.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.Partners.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name1628, "dataIndex": "name" }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.Partners.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": email1629, "dataIndex": "email" }, { "colIndex": 2, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(contacts.Partners.modified) ", "header": "Modified", "dataIndex": "modified", "hidden": true }, { "colIndex": 3, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(contacts.Partners.created) ", "header": "Created", "dataIndex": "created", "hidden": true }, { "colIndex": 4, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Partners.country) ", "filter": { "type": "string" }, "header": "Country", "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "dataIndex": "country", "hidden": true, "editor": country1632 }, { "colIndex": 5, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Partners.city) ", "filter": { "type": "string" }, "header": "City", "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Places.detail'), "dataIndex": "city", "hidden": true, "editor": city1633 }, { "colIndex": 6, "sortable": true, "header": "Zip code", "editable": true, "tooltip": "(contacts.Partners.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": zip_code1634, "hidden": true, "dataIndex": "zip_code" }, { "colIndex": 7, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Partners.region) ", "filter": { "type": "string" }, "header": "County", "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Places.detail'), "dataIndex": "region", "hidden": true, "editor": region1635 }, { "colIndex": 8, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "(contacts.Partners.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": addr11636, "hidden": true, "dataIndex": "addr1" }, { "colIndex": 9, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "(contacts.Partners.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": street_prefix1637, "hidden": true, "dataIndex": "street_prefix" }, { "colIndex": 10, "sortable": true, "header": "Street", "editable": true, "tooltip": "(contacts.Partners.street) Name of street, without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": street1638, "hidden": true, "dataIndex": "street" }, { "colIndex": 11, "sortable": true, "header": "No.", "editable": true, "tooltip": "(contacts.Partners.street_no) House number.", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": street_no1639, "hidden": true, "dataIndex": "street_no" }, { "colIndex": 12, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.Partners.street_box) Text to print after street nuber on the same line.", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": street_box1640, "hidden": true, "dataIndex": "street_box" }, { "colIndex": 13, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "(contacts.Partners.addr2) Address line to print below street line.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": addr21641, "hidden": true, "dataIndex": "addr2" }, { "colIndex": 14, "sortable": true, "header": "Language", "editable": true, "tooltip": "(contacts.Partners.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": language1642, "hidden": true, "dataIndex": "language" }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.Partners.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": url1643, "hidden": true, "dataIndex": "url" }, { "colIndex": 16, "sortable": true, "header": "Phone", "editable": true, "tooltip": "(contacts.Partners.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": phone1644, "hidden": true, "dataIndex": "phone" }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.Partners.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": gsm1645, "hidden": true, "dataIndex": "gsm" }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.Partners.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": fax1646, "hidden": true, "dataIndex": "fax" }, { "colIndex": 19, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(contacts.Partners.remarks) ", "filter": { "type": "string" }, "header": "Remarks", "editor": remarks1647, "hidden": true, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": true, "width": Lino.chars2width(22), "editable": true, "tooltip": "(contacts.Partners.iban) ", "filter": { "type": "string" }, "header": "IBAN", "renderer": Lino.iban_renderer, "hidden": true, "editor": iban1648, "dataIndex": "iban" }, { "colIndex": 21, "sortable": true, "header": "BIC", "editable": true, "tooltip": "(contacts.Partners.bic) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": bic1649, "hidden": true, "dataIndex": "bic" }, new Lino.NullNumberColumn({ "colIndex": 22, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.Partners.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1650, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.Partners.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Partners.print_labels = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "print_labels", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Partners.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Partners.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.contacts.Partners.insertPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/contacts/Partners",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    Lino.contacts.Partners.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Partners.insertPanel(p);
});
Lino.contacts.Partners.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Partners.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Partners.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.contacts.Partners.detailPanel = Ext.extend(Lino.contacts.Partners.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  ls_url: "/contacts/Partners",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    Lino.contacts.Partners.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Partners.detailPanel(p);
});
Lino.contacts.Partners.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Partners.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Partners.GridPanel(p);
});
Lino.contacts.Partners.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class contacts.RoleTypes
Lino.contacts.RoleTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/RoleTypes",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/contacts/RoleTypes','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/contacts/RoleTypes','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Functions",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 4,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_et" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 18,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id1652 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1653 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_et1654 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.RoleTypes.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1652, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(contacts.RoleTypes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name1653, "dataIndex": "name" }, { "colIndex": 2, "sortable": true, "header": "Designation (et)", "editable": true, "tooltip": "(contacts.RoleTypes.name_et) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_et1654, "dataIndex": "name_et" } ];
    Lino.contacts.RoleTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.RoleTypes.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/RoleTypes", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.RoleTypes.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/RoleTypes", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.RoleTypes.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/RoleTypes", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.RoleTypes.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/RoleTypes", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.RoleTypes.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/RoleTypes", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.RoleTypes.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/RoleTypes", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.RoleTypes.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.RoleTypes.GridPanel(p);
});

// js_render_GridPanel_class contacts.Roles
Lino.contacts.Roles.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Roles",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/contacts/Roles','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/contacts/Roles','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Contact Persons",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 8,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "type" }, 'typeHidden', { "name": "person" }, 'personHidden', { "name": "company" }, 'companyHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 21,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id1656 = new Ext.form.NumberField({ "selectOnFocus": true });
    var type1657 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Roles/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Function..." });
    var person1658 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Roles/person", "method": "GET" }) }), "emptyText": "Select a Person..." });
    var company1659 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Roles/company", "method": "GET" }) }), "emptyText": "Select a Organisation..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.Roles.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1656, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Contact Role", "editable": true, "tooltip": "(contacts.Roles.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": type1657, "dataIndex": "type" }, { "colIndex": 2, "sortable": true, "header": "Person", "editable": true, "tooltip": "(contacts.Roles.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('personHidden','Lino.contacts.Persons.detail'), "dataIndex": "person", "editor": person1658 }, { "colIndex": 3, "sortable": true, "header": "Organisation", "editable": true, "tooltip": "(contacts.Roles.company) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('companyHidden','Lino.contacts.Companies.detail'), "dataIndex": "company", "editor": company1659 } ];
    Lino.contacts.Roles.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Roles.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Roles", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Roles.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Roles", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Roles.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Roles", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Roles.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Roles", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Roles.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Roles", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Roles.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Roles", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Roles.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Roles.GridPanel(p);
});

// js_render_GridPanel_class addresses.Addresses
Lino.addresses.Addresses.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/addresses/Addresses",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/addresses/Addresses','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/addresses/Addresses','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Addresses",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 24,
  ls_store_fields : [ { "name": "partner" }, 'partnerHidden', { "name": "address_type" }, 'address_typeHidden', { "name": "remark" }, { "name": "address_column" }, { "type": "boolean", "name": "primary" }, { "name": "data_source" }, 'data_sourceHidden', { "type": "int", "name": "id" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "zip_code" }, { "name": "region" }, 'regionHidden', { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 9,
  ls_grid_configs : [  ],
  content_type : 24,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.addresses.Addresses.detail;
    this.ls_insert_handler = Lino.addresses.Addresses.insert;
    var ww = this.containing_window;
    var partner1661 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/addresses/Addresses/partner", "method": "GET" }) }), "emptyText": "Select a Partner..." });
    var address_type1662 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.addresses.AddressTypes) });
    var remark1663 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 50 });
    var address_column_disp1664 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var primary1665 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var data_source1666 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "store": Lino.addresses.DataSources });
    var id1667 = new Ext.form.NumberField({ "selectOnFocus": true });
    var country1668 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/addresses/Addresses/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Country..." });
    var city1669 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/addresses/Addresses/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var zip_code1670 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var region1671 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/addresses/Addresses/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var addr11672 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix1673 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street1674 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no1675 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box1676 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr21677 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
      city1669.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city1669.setContextValue('region', record ? record.data['regionHidden'] : undefined);
      region1671.setContextValue('country', record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country1668.on('change',Lino.chooser_handler(city1669,'country'));
      region1671.on('change',Lino.chooser_handler(city1669,'region'));
      country1668.on('change',Lino.chooser_handler(region1671,'country'));
      Lino.addresses.Addresses.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(addresses.Addresses.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "dataIndex": "partner", "editor": partner1661 }, { "colIndex": 1, "sortable": true, "header": "Address type", "editable": true, "tooltip": "(addresses.Addresses.address_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": address_type1662, "dataIndex": "address_type" }, { "colIndex": 2, "sortable": true, "header": "Remark", "editable": true, "tooltip": "(addresses.Addresses.remark) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": remark1663, "dataIndex": "remark" }, { "header": "Address", "colIndex": 3, "sortable": false, "dataIndex": "address_column", "width": Lino.chars2width(31), "editable": false, "tooltip": "(addresses.Addresses.address_column) " }, { "colIndex": 4, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(addresses.Addresses.primary) Checking this field will automatically uncheck any previous primary addresses and update the partner's address data fields.", "filter": { "type": "boolean" }, "header": "Primary", "dataIndex": "primary" }, { "colIndex": 5, "sortable": true, "width": Lino.chars2width(20), "editable": false, "tooltip": "(addresses.Addresses.data_source) ", "filter": { "type": "string" }, "header": "Data source", "dataIndex": "data_source" }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(addresses.Addresses.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1667, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 7, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(addresses.Addresses.country) ", "filter": { "type": "string" }, "header": "Country", "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "dataIndex": "country", "hidden": true, "editor": country1668 }, { "colIndex": 8, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(addresses.Addresses.city) ", "filter": { "type": "string" }, "header": "City", "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Places.detail'), "dataIndex": "city", "hidden": true, "editor": city1669 }, { "colIndex": 9, "sortable": true, "header": "Zip code", "editable": true, "tooltip": "(addresses.Addresses.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": zip_code1670, "hidden": true, "dataIndex": "zip_code" }, { "colIndex": 10, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(addresses.Addresses.region) ", "filter": { "type": "string" }, "header": "County", "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Places.detail'), "dataIndex": "region", "hidden": true, "editor": region1671 }, { "colIndex": 11, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "(addresses.Addresses.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": addr11672, "hidden": true, "dataIndex": "addr1" }, { "colIndex": 12, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "(addresses.Addresses.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": street_prefix1673, "hidden": true, "dataIndex": "street_prefix" }, { "colIndex": 13, "sortable": true, "header": "Street", "editable": true, "tooltip": "(addresses.Addresses.street) Name of street, without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": street1674, "hidden": true, "dataIndex": "street" }, { "colIndex": 14, "sortable": true, "header": "No.", "editable": true, "tooltip": "(addresses.Addresses.street_no) House number.", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": street_no1675, "hidden": true, "dataIndex": "street_no" }, { "colIndex": 15, "sortable": true, "header": "Box", "editable": true, "tooltip": "(addresses.Addresses.street_box) Text to print after street nuber on the same line.", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": street_box1676, "hidden": true, "dataIndex": "street_box" }, { "colIndex": 16, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "(addresses.Addresses.addr2) Address line to print below street line.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": addr21677, "hidden": true, "dataIndex": "addr2" } ];
    Lino.addresses.Addresses.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.addresses.Addresses.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/addresses/Addresses", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.addresses.Addresses.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/addresses/Addresses", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.addresses.Addresses.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/addresses/Addresses", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.addresses.Addresses.insertPanel = Ext.extend(Lino.addresses.Addresses.InsertFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/addresses/Addresses",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.addresses.Addresses.detail;
    this.ls_insert_handler = Lino.addresses.Addresses.insert;
    Lino.addresses.Addresses.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.addresses.Addresses.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.addresses.Addresses.insertPanel(p);
});
Lino.addresses.Addresses.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/addresses/Addresses", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.addresses.Addresses.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/addresses/Addresses", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.addresses.Addresses.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/addresses/Addresses", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.addresses.Addresses.detailPanel = Ext.extend(Lino.addresses.Addresses.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  ls_url: "/addresses/Addresses",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.addresses.Addresses.detail;
    this.ls_insert_handler = Lino.addresses.Addresses.insert;
    Lino.addresses.Addresses.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.addresses.Addresses.detail = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true };
  return new Lino.addresses.Addresses.detailPanel(p);
});
Lino.addresses.Addresses.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/addresses/Addresses", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.addresses.Addresses.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.addresses.Addresses.GridPanel(p);
});
Lino.addresses.Addresses.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/addresses/Addresses", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class contacts.Persons
Lino.contacts.Persons.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Persons",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/contacts/Persons','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "print_labels", "menu_item_text": "Labels", "tooltip": "Generate mailing labels for these recipients", "panel_btn_handler": Lino.list_action_handler('/contacts/Persons','print_labels','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-pdf", "overflowText": "Labels", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/contacts/Persons','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Persons",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 37,
  ls_store_fields : [ { "name": "name_column" }, { "name": "address_column" }, { "name": "email" }, { "name": "phone" }, { "name": "gsm" }, { "type": "int", "name": "id" }, { "name": "language" }, 'languageHidden', { "name": "modified" }, { "name": "created" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "zip_code" }, { "name": "region" }, 'regionHidden', { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "name" }, { "name": "url" }, { "name": "fax" }, { "name": "remarks" }, { "name": "iban" }, { "name": "bic" }, { "name": "first_name" }, { "name": "middle_name" }, { "name": "last_name" }, { "name": "gender" }, 'genderHidden', { "name": "birth_date" }, { "name": "title" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 22,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    var ww = this.containing_window;
    var name_column_disp1679 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var address_column_disp1680 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var email1681 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone1682 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm1683 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1684 = new Ext.form.NumberField({ "selectOnFocus": true });
    var language1685 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "English" ], [ "et", "Estonian" ] ] });
    var modified1686 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created1687 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country1688 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Country..." });
    var city1689 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var zip_code1690 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var region1691 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var addr11692 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix1693 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street1694 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no1695 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box1696 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr21697 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name1698 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var url1699 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var fax1700 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks1701 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var iban1702 = new Lino.UppercaseTextField({ "selectOnFocus": true, "maxLength": 34 });
    var bic1703 = new Lino.UppercaseTextField({ "selectOnFocus": true, "maxLength": 11 });
    var first_name1704 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var middle_name1705 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var last_name1706 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var gender1707 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.Genders) });
    var birth_date1708 = new Lino.IncompleteDateField({ "selectOnFocus": true });
    var title1709 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
      city1689.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city1689.setContextValue('region', record ? record.data['regionHidden'] : undefined);
      region1691.setContextValue('country', record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country1688.on('change',Lino.chooser_handler(city1689,'country'));
      region1691.on('change',Lino.chooser_handler(city1689,'region'));
      country1688.on('change',Lino.chooser_handler(region1691,'country'));
      Lino.contacts.Persons.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "header": "Name", "colIndex": 0, "sortable": false, "dataIndex": "name_column", "width": Lino.chars2width(21), "editable": false, "tooltip": "(contacts.Persons.name_column) " }, { "header": "Address", "colIndex": 1, "sortable": false, "dataIndex": "address_column", "width": Lino.chars2width(31), "editable": false, "tooltip": "(contacts.Persons.address_column) " }, { "colIndex": 2, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.Persons.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": email1681, "dataIndex": "email" }, { "colIndex": 3, "sortable": true, "header": "Phone", "editable": true, "tooltip": "(contacts.Persons.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": phone1682, "dataIndex": "phone" }, { "colIndex": 4, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.Persons.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": gsm1683, "dataIndex": "gsm" }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.Persons.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1684, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Language", "editable": true, "tooltip": "(contacts.Persons.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": language1685, "dataIndex": "language" }, { "colIndex": 7, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(contacts.Persons.modified) ", "header": "Modified", "dataIndex": "modified", "hidden": true }, { "colIndex": 8, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(contacts.Persons.created) ", "header": "Created", "dataIndex": "created", "hidden": true }, { "colIndex": 9, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Persons.country) ", "filter": { "type": "string" }, "header": "Country", "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "dataIndex": "country", "hidden": true, "editor": country1688 }, { "colIndex": 10, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Persons.city) ", "filter": { "type": "string" }, "header": "City", "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Places.detail'), "dataIndex": "city", "hidden": true, "editor": city1689 }, { "colIndex": 11, "sortable": true, "header": "Zip code", "editable": true, "tooltip": "(contacts.Persons.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": zip_code1690, "hidden": true, "dataIndex": "zip_code" }, { "colIndex": 12, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Persons.region) ", "filter": { "type": "string" }, "header": "County", "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Places.detail'), "dataIndex": "region", "hidden": true, "editor": region1691 }, { "colIndex": 13, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "(contacts.Persons.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": addr11692, "hidden": true, "dataIndex": "addr1" }, { "colIndex": 14, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "(contacts.Persons.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": street_prefix1693, "hidden": true, "dataIndex": "street_prefix" }, { "colIndex": 15, "sortable": true, "header": "Street", "editable": true, "tooltip": "(contacts.Persons.street) Name of street, without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": street1694, "hidden": true, "dataIndex": "street" }, { "colIndex": 16, "sortable": true, "header": "No.", "editable": true, "tooltip": "(contacts.Persons.street_no) House number.", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": street_no1695, "hidden": true, "dataIndex": "street_no" }, { "colIndex": 17, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.Persons.street_box) Text to print after street nuber on the same line.", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": street_box1696, "hidden": true, "dataIndex": "street_box" }, { "colIndex": 18, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "(contacts.Persons.addr2) Address line to print below street line.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": addr21697, "hidden": true, "dataIndex": "addr2" }, { "colIndex": 19, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.Persons.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name1698, "hidden": true, "dataIndex": "name" }, { "colIndex": 20, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.Persons.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": url1699, "hidden": true, "dataIndex": "url" }, { "colIndex": 21, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.Persons.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": fax1700, "hidden": true, "dataIndex": "fax" }, { "colIndex": 22, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(contacts.Persons.remarks) ", "filter": { "type": "string" }, "header": "Remarks", "editor": remarks1701, "hidden": true, "dataIndex": "remarks" }, { "colIndex": 23, "sortable": true, "width": Lino.chars2width(22), "editable": true, "tooltip": "(contacts.Persons.iban) ", "filter": { "type": "string" }, "header": "IBAN", "renderer": Lino.iban_renderer, "hidden": true, "editor": iban1702, "dataIndex": "iban" }, { "colIndex": 24, "sortable": true, "header": "BIC", "editable": true, "tooltip": "(contacts.Persons.bic) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": bic1703, "hidden": true, "dataIndex": "bic" }, { "colIndex": 25, "sortable": true, "header": "First name", "editable": true, "tooltip": "(contacts.Persons.first_name) First or given name.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": first_name1704, "hidden": true, "dataIndex": "first_name" }, { "colIndex": 26, "sortable": true, "header": "Middle name", "editable": true, "tooltip": "(contacts.Persons.middle_name) Space-separated list of all middle names.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": middle_name1705, "hidden": true, "dataIndex": "middle_name" }, { "colIndex": 27, "sortable": true, "header": "Last name", "editable": true, "tooltip": "(contacts.Persons.last_name) Last name (family name).", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": last_name1706, "hidden": true, "dataIndex": "last_name" }, { "colIndex": 28, "sortable": true, "header": "Gender", "editable": true, "tooltip": "(contacts.Persons.gender) ", "filter": { "type": "string" }, "width": Lino.chars2width(10), "editor": gender1707, "hidden": true, "dataIndex": "gender" }, { "colIndex": 29, "sortable": true, "header": "Birth date", "editable": true, "tooltip": "(contacts.Persons.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".", "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": birth_date1708, "hidden": true, "dataIndex": "birth_date" }, { "colIndex": 30, "sortable": true, "header": "Title", "editable": true, "tooltip": "(contacts.Persons.title) Text to print before allocation and name as part of the first address line.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": title1709, "hidden": true, "dataIndex": "title" } ];
    Lino.contacts.Persons.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Persons.print_labels = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "print_labels", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Persons.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Persons.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.contacts.Persons.insertPanel = Ext.extend(Lino.contacts.Persons.InsertFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/contacts/Persons",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    Lino.contacts.Persons.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Persons.insertPanel(p);
});
Lino.contacts.Persons.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Persons.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Persons.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.contacts.Persons.detailPanel = Ext.extend(Lino.contacts.Persons.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  ls_url: "/contacts/Persons",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    Lino.contacts.Persons.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Persons.detailPanel(p);
});
Lino.contacts.Persons.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Persons.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Persons.GridPanel(p);
});
Lino.contacts.Persons.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class contacts.Companies
Lino.contacts.Companies.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Companies",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/contacts/Companies','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "print_labels", "menu_item_text": "Labels", "tooltip": "Generate mailing labels for these recipients", "panel_btn_handler": Lino.list_action_handler('/contacts/Companies','print_labels','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-pdf", "overflowText": "Labels", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/contacts/Companies','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Organisations",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 34,
  ls_store_fields : [ { "name": "name_column" }, { "name": "address_column" }, { "name": "email" }, { "name": "phone" }, { "name": "gsm" }, { "type": "int", "name": "id" }, { "name": "language" }, 'languageHidden', { "name": "modified" }, { "name": "created" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "zip_code" }, { "name": "region" }, 'regionHidden', { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "name" }, { "name": "url" }, { "name": "fax" }, { "name": "remarks" }, { "name": "iban" }, { "name": "bic" }, { "name": "prefix" }, { "name": "type" }, 'typeHidden', { "name": "vat_id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 22,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    var ww = this.containing_window;
    var name_column_disp1711 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var address_column_disp1712 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var email1713 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone1714 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm1715 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1716 = new Ext.form.NumberField({ "selectOnFocus": true });
    var language1717 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "English" ], [ "et", "Estonian" ] ] });
    var modified1718 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created1719 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country1720 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Country..." });
    var city1721 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var zip_code1722 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var region1723 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var addr11724 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix1725 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street1726 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no1727 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box1728 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr21729 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name1730 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var url1731 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var fax1732 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks1733 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var iban1734 = new Lino.UppercaseTextField({ "selectOnFocus": true, "maxLength": 34 });
    var bic1735 = new Lino.UppercaseTextField({ "selectOnFocus": true, "maxLength": 11 });
    var prefix1736 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type1737 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Organization type..." });
    var vat_id1738 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
      city1721.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city1721.setContextValue('region', record ? record.data['regionHidden'] : undefined);
      region1723.setContextValue('country', record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country1720.on('change',Lino.chooser_handler(city1721,'country'));
      region1723.on('change',Lino.chooser_handler(city1721,'region'));
      country1720.on('change',Lino.chooser_handler(region1723,'country'));
      Lino.contacts.Companies.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "header": "Name", "colIndex": 0, "sortable": false, "dataIndex": "name_column", "width": Lino.chars2width(21), "editable": false, "tooltip": "(contacts.Companies.name_column) " }, { "header": "Address", "colIndex": 1, "sortable": false, "dataIndex": "address_column", "width": Lino.chars2width(31), "editable": false, "tooltip": "(contacts.Companies.address_column) " }, { "colIndex": 2, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.Companies.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": email1713, "dataIndex": "email" }, { "colIndex": 3, "sortable": true, "header": "Phone", "editable": true, "tooltip": "(contacts.Companies.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": phone1714, "dataIndex": "phone" }, { "colIndex": 4, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.Companies.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": gsm1715, "dataIndex": "gsm" }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.Companies.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1716, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Language", "editable": true, "tooltip": "(contacts.Companies.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": language1717, "dataIndex": "language" }, { "colIndex": 7, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(contacts.Companies.modified) ", "header": "Modified", "dataIndex": "modified", "hidden": true }, { "colIndex": 8, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(contacts.Companies.created) ", "header": "Created", "dataIndex": "created", "hidden": true }, { "colIndex": 9, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Companies.country) ", "filter": { "type": "string" }, "header": "Country", "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "dataIndex": "country", "hidden": true, "editor": country1720 }, { "colIndex": 10, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Companies.city) ", "filter": { "type": "string" }, "header": "City", "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Places.detail'), "dataIndex": "city", "hidden": true, "editor": city1721 }, { "colIndex": 11, "sortable": true, "header": "Zip code", "editable": true, "tooltip": "(contacts.Companies.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": zip_code1722, "hidden": true, "dataIndex": "zip_code" }, { "colIndex": 12, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Companies.region) ", "filter": { "type": "string" }, "header": "County", "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Places.detail'), "dataIndex": "region", "hidden": true, "editor": region1723 }, { "colIndex": 13, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "(contacts.Companies.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": addr11724, "hidden": true, "dataIndex": "addr1" }, { "colIndex": 14, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "(contacts.Companies.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": street_prefix1725, "hidden": true, "dataIndex": "street_prefix" }, { "colIndex": 15, "sortable": true, "header": "Street", "editable": true, "tooltip": "(contacts.Companies.street) Name of street, without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": street1726, "hidden": true, "dataIndex": "street" }, { "colIndex": 16, "sortable": true, "header": "No.", "editable": true, "tooltip": "(contacts.Companies.street_no) House number.", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": street_no1727, "hidden": true, "dataIndex": "street_no" }, { "colIndex": 17, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.Companies.street_box) Text to print after street nuber on the same line.", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": street_box1728, "hidden": true, "dataIndex": "street_box" }, { "colIndex": 18, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "(contacts.Companies.addr2) Address line to print below street line.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": addr21729, "hidden": true, "dataIndex": "addr2" }, { "colIndex": 19, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.Companies.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name1730, "hidden": true, "dataIndex": "name" }, { "colIndex": 20, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.Companies.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": url1731, "hidden": true, "dataIndex": "url" }, { "colIndex": 21, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.Companies.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": fax1732, "hidden": true, "dataIndex": "fax" }, { "colIndex": 22, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(contacts.Companies.remarks) ", "filter": { "type": "string" }, "header": "Remarks", "editor": remarks1733, "hidden": true, "dataIndex": "remarks" }, { "colIndex": 23, "sortable": true, "width": Lino.chars2width(22), "editable": true, "tooltip": "(contacts.Companies.iban) ", "filter": { "type": "string" }, "header": "IBAN", "renderer": Lino.iban_renderer, "hidden": true, "editor": iban1734, "dataIndex": "iban" }, { "colIndex": 24, "sortable": true, "header": "BIC", "editable": true, "tooltip": "(contacts.Companies.bic) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": bic1735, "hidden": true, "dataIndex": "bic" }, { "colIndex": 25, "sortable": true, "header": "Name prefix", "editable": true, "tooltip": "(contacts.Companies.prefix) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": prefix1736, "hidden": true, "dataIndex": "prefix" }, { "colIndex": 26, "sortable": true, "header": "Organization type", "editable": true, "tooltip": "(contacts.Companies.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": type1737, "hidden": true, "dataIndex": "type" }, { "colIndex": 27, "sortable": true, "header": "VAT id", "editable": true, "tooltip": "(contacts.Companies.vat_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": vat_id1738, "hidden": true, "dataIndex": "vat_id" } ];
    Lino.contacts.Companies.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Companies.print_labels = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "print_labels", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Companies.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Companies.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.contacts.Companies.insertPanel = Ext.extend(Lino.contacts.Companies.InsertFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/contacts/Companies",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    Lino.contacts.Companies.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Companies.insertPanel(p);
});
Lino.contacts.Companies.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Companies.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Companies.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.contacts.Companies.detailPanel = Ext.extend(Lino.contacts.Companies.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  ls_url: "/contacts/Companies",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    Lino.contacts.Companies.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Companies.detailPanel(p);
});
Lino.contacts.Companies.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Companies.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Companies.GridPanel(p);
});
Lino.contacts.Companies.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.RemoteCalendars
Lino.cal.RemoteCalendars.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/RemoteCalendars",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/RemoteCalendars','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/RemoteCalendars','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Up", "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-arrow_up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-arrow_down", "overflowText": "Down", "auto_save": true } ],
  cell_edit : true,
  title : "Remote Calendars",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 9,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "type": "int", "name": "seqno" }, { "name": "type" }, 'typeHidden', { "name": "url_template" }, { "name": "username" }, { "name": "password" }, { "type": "boolean", "name": "readonly" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 41,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id1740 = new Ext.form.NumberField({ "selectOnFocus": true });
    var seqno1741 = new Ext.form.NumberField({ "selectOnFocus": true });
    var type1742 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "local", "Local Calendar" ], [ "google", "Google Calendar" ] ], "allowBlank": false, "value": "local" });
    var url_template1743 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var username1744 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var password1745 = new Ext.form.TextField({ "selectOnFocus": true, "inputType": "password", "maxLength": 200 });
    var readonly1746 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.RemoteCalendars.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1740, "width": Lino.chars2width(6), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.RemoteCalendars.seqno) ", "filter": { "type": "numeric" }, "header": "Seq.No.", "editor": seqno1741, "width": Lino.chars2width(6), "dataIndex": "seqno" }), { "colIndex": 2, "sortable": true, "header": "Type", "editable": true, "tooltip": "(cal.RemoteCalendars.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": type1742, "dataIndex": "type" }, { "colIndex": 3, "sortable": true, "header": "URL template", "editable": true, "tooltip": "(cal.RemoteCalendars.url_template) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": url_template1743, "dataIndex": "url_template" }, { "colIndex": 4, "sortable": true, "header": "Username", "editable": true, "tooltip": "(cal.RemoteCalendars.username) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": username1744, "dataIndex": "username" }, { "colIndex": 5, "sortable": true, "header": "Password", "editable": true, "tooltip": "(cal.RemoteCalendars.password) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": password1745, "dataIndex": "password" }, { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.RemoteCalendars.readonly) ", "filter": { "type": "boolean" }, "header": "read-only", "dataIndex": "readonly" } ];
    Lino.cal.RemoteCalendars.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.RemoteCalendars.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RemoteCalendars", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.RemoteCalendars.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RemoteCalendars", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.RemoteCalendars.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RemoteCalendars", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.RemoteCalendars.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RemoteCalendars", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.RemoteCalendars.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RemoteCalendars", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.RemoteCalendars.duplicate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RemoteCalendars", "GET", pk, "duplicate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.RemoteCalendars.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RemoteCalendars", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.RemoteCalendars.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.RemoteCalendars.GridPanel(p);
});
Lino.cal.RemoteCalendars.move_up = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RemoteCalendars", "GET", pk, "move_up", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.RemoteCalendars.move_down = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RemoteCalendars", "GET", pk, "move_down", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.Rooms
Lino.cal.Rooms.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/Rooms",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/Rooms','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/Rooms','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Rooms",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 4,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_et" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 36,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Rooms.detail;
    this.ls_insert_handler = Lino.cal.Rooms.insert;
    var ww = this.containing_window;
    var id1748 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1749 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_et1750 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Rooms.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1748, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(cal.Rooms.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name1749, "dataIndex": "name" }, { "colIndex": 2, "sortable": true, "header": "Designation (et)", "editable": true, "tooltip": "(cal.Rooms.name_et) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_et1750, "dataIndex": "name_et" } ];
    Lino.cal.Rooms.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Rooms.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Rooms", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Rooms.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Rooms", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Rooms.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Rooms", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.Rooms.insertPanel = Ext.extend(Lino.cal.Rooms.DetailFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/cal/Rooms",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Rooms.detail;
    this.ls_insert_handler = Lino.cal.Rooms.insert;
    Lino.cal.Rooms.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Rooms.insert = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Rooms.insertPanel(p);
});
Lino.cal.Rooms.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Rooms", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Rooms.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Rooms", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Rooms.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Rooms", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.Rooms.detailPanel = Ext.extend(Lino.cal.Rooms.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  ls_url: "/cal/Rooms",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Rooms.detail;
    this.ls_insert_handler = Lino.cal.Rooms.insert;
    Lino.cal.Rooms.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Rooms.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Rooms.detailPanel(p);
});
Lino.cal.Rooms.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Rooms", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Rooms.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Rooms.GridPanel(p);
});
Lino.cal.Rooms.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Rooms", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.Priorities
Lino.cal.Priorities.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/Priorities",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/Priorities','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/Priorities','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Priorities",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 5,
  ls_store_fields : [ { "name": "name" }, { "name": "name_et" }, { "type": "int", "name": "id" }, { "name": "ref" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 39,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var name1752 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_et1753 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1754 = new Ext.form.NumberField({ "selectOnFocus": true });
    var ref1755 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": "1" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(cal.Priorities.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name1752, "dataIndex": "name" }, { "colIndex": 1, "sortable": true, "header": "Designation (et)", "editable": true, "tooltip": "(cal.Priorities.name_et) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_et1753, "dataIndex": "name_et" }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Priorities.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1754, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 3, "sortable": true, "header": "ref", "editable": true, "tooltip": "(cal.Priorities.ref) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": ref1755, "hidden": true, "dataIndex": "ref" } ];
    Lino.cal.Priorities.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Priorities.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Priorities", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Priorities.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Priorities", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Priorities.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Priorities", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Priorities.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Priorities", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Priorities.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Priorities", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Priorities.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Priorities", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Priorities.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Priorities.GridPanel(p);
});

// js_render_GridPanel_class cal.Calendars
Lino.cal.Calendars.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/Calendars",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/Calendars','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/Calendars','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Calendars",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 5,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_et" }, { "type": "int", "name": "color" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 43,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Calendars.detail;
    this.ls_insert_handler = Lino.cal.Calendars.insert;
    var ww = this.containing_window;
    var id1757 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1758 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_et1759 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var color1760 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Calendars.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1757, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(cal.Calendars.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name1758, "dataIndex": "name" }, { "colIndex": 2, "sortable": true, "header": "Designation (et)", "editable": true, "tooltip": "(cal.Calendars.name_et) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_et1759, "dataIndex": "name_et" }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Calendars.color) ", "filter": { "type": "numeric" }, "header": "color", "editor": color1760, "width": Lino.chars2width(6), "dataIndex": "color" }) ];
    Lino.cal.Calendars.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Calendars.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Calendars", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Calendars.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Calendars", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Calendars.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Calendars", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.Calendars.insertPanel = Ext.extend(Lino.cal.Calendars.InsertFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/cal/Calendars",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Calendars.detail;
    this.ls_insert_handler = Lino.cal.Calendars.insert;
    Lino.cal.Calendars.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Calendars.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Calendars.insertPanel(p);
});
Lino.cal.Calendars.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Calendars", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Calendars.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Calendars", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Calendars.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Calendars", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.Calendars.detailPanel = Ext.extend(Lino.cal.Calendars.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  ls_url: "/cal/Calendars",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Calendars.detail;
    this.ls_insert_handler = Lino.cal.Calendars.insert;
    Lino.cal.Calendars.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Calendars.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Calendars.detailPanel(p);
});
Lino.cal.Calendars.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Calendars", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Calendars.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Calendars.GridPanel(p);
});
Lino.cal.Calendars.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Calendars", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.Subscriptions
Lino.cal.Subscriptions.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/Subscriptions",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/Subscriptions','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/Subscriptions','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Subscriptions",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "calendar" }, 'calendarHidden', { "type": "boolean", "name": "is_hidden" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 45,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id1762 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1763 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Subscriptions/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var calendar1764 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Subscriptions/calendar", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Calendar..." });
    var is_hidden1765 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Subscriptions.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1762, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Author", "editable": true, "tooltip": "(cal.Subscriptions.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "dataIndex": "user", "editor": user1763 }, { "colIndex": 2, "sortable": true, "header": "Calendar", "editable": true, "tooltip": "(cal.Subscriptions.calendar) The calendar you want to subscribe to.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.Calendars.detail'), "dataIndex": "calendar", "editor": calendar1764 }, { "colIndex": 3, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.Subscriptions.is_hidden) Whether this subscription should \"\n        \"initially be displayed as a hidden calendar.", "filter": { "type": "boolean" }, "header": "hidden", "dataIndex": "is_hidden" } ];
    Lino.cal.Subscriptions.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Subscriptions.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Subscriptions", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Subscriptions.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Subscriptions", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Subscriptions.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Subscriptions", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Subscriptions.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Subscriptions", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Subscriptions.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Subscriptions", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Subscriptions.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Subscriptions", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Subscriptions.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Subscriptions.GridPanel(p);
});

// js_render_GridPanel_class cal.Tasks
Lino.cal.Tasks.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/Tasks",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/Tasks','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/Tasks','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Tasks",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 26,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "modified" }, { "name": "created" }, { "name": "project" }, 'projectHidden', { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "start_time" }, { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "date", "name": "due_date", "dateFormat": "d.m.Y" }, { "name": "due_time" }, { "type": "int", "name": "percent" }, { "name": "state" }, 'stateHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 35,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Tasks.detail;
    this.ls_insert_handler = Lino.cal.Tasks.insert;
    var ww = this.containing_window;
    var start_date1767 = new Lino.DateField({ "selectOnFocus": true });
    var summary1768 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp1769 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id1770 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1771 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var modified1772 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created1773 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var project1774 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var owner_type1775 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id1776 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/owner_id", "method": "GET" }) }) });
    var start_time1777 = new Lino.TimeField({ "selectOnFocus": true });
    var access_class1778 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var sequence1779 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type1780 = new Ext.form.NumberField({ "disabled": true });
    var due_date1781 = new Lino.DateField({ "selectOnFocus": true });
    var due_time1782 = new Lino.TimeField({ "selectOnFocus": true });
    var percent1783 = new Ext.form.NumberField({ "selectOnFocus": true });
    var state1784 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.TaskStates });
    var owner_disp1785 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.Tasks.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Start date", "editor": start_date1767, "width": Lino.chars2width(14), "dataIndex": "start_date" }, { "colIndex": 1, "sortable": true, "header": "Summary", "editable": true, "tooltip": "(cal.Tasks.summary) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": summary1768, "dataIndex": "summary" }, { "header": "Workflow", "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "width": Lino.chars2width(31), "editable": false, "tooltip": "(cal.Tasks.workflow_buttons) " }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Tasks.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1770, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.Tasks.user) ", "filter": { "type": "string" }, "header": "Author", "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "dataIndex": "user", "hidden": true, "editor": user1771 }, { "colIndex": 5, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.Tasks.modified) ", "header": "Modified", "dataIndex": "modified", "hidden": true }, { "colIndex": 6, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.Tasks.created) ", "header": "Created", "dataIndex": "created", "hidden": true }, { "colIndex": 7, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.Tasks.project) ", "filter": { "type": "string" }, "header": "Project", "renderer": Lino.fk_renderer('projectHidden','Lino.projects.Projects.detail'), "dataIndex": "project", "hidden": true, "editor": project1774 }, { "colIndex": 8, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.Tasks.owner_type) ", "filter": { "type": "string" }, "header": "Controlled by (type)", "renderer": Lino.fk_renderer('owner_typeHidden','Lino.contenttypes.ContentTypes.detail'), "dataIndex": "owner_type", "hidden": true, "editor": owner_type1775 }, { "colIndex": 9, "sortable": true, "header": "Controlled by (object)", "editable": true, "tooltip": "(cal.Tasks.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": owner_id1776, "hidden": true, "dataIndex": "owner_id" }, { "colIndex": 10, "sortable": true, "header": "Start time", "editable": true, "tooltip": "(cal.Tasks.start_time) ", "width": Lino.chars2width(9), "editor": start_time1777, "hidden": true, "dataIndex": "start_time" }, { "colIndex": 11, "sortable": true, "header": "Access Class", "editable": true, "tooltip": "(cal.Tasks.access_class) Whether this is private, public or between.", "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": access_class1778, "hidden": true, "dataIndex": "access_class" }, new Lino.NullNumberColumn({ "colIndex": 12, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Tasks.sequence) ", "filter": { "type": "numeric" }, "header": "Revision", "editor": sequence1779, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "sequence" }), new Lino.NullNumberColumn({ "colIndex": 13, "sortable": true, "format": "0", "editable": false, "tooltip": "(cal.Tasks.auto_type) ", "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 14, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.Tasks.due_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Due date", "editor": due_date1781, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "due_date" }, { "colIndex": 15, "sortable": true, "header": "Due time", "editable": true, "tooltip": "(cal.Tasks.due_time) ", "width": Lino.chars2width(9), "editor": due_time1782, "hidden": true, "dataIndex": "due_time" }, new Lino.NullNumberColumn({ "colIndex": 16, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Tasks.percent) ", "filter": { "type": "numeric" }, "header": "Duration value", "editor": percent1783, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "percent" }), { "colIndex": 17, "sortable": true, "header": "State", "editable": true, "tooltip": "(cal.Tasks.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": state1784, "hidden": true, "dataIndex": "state" }, { "colIndex": 18, "sortable": false, "width": Lino.chars2width(11), "editable": false, "tooltip": "(cal.Tasks.owner) ", "header": "Controlled by", "dataIndex": "owner", "hidden": true } ];
    Lino.cal.Tasks.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Tasks.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Tasks", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Tasks.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Tasks", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Tasks.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Tasks", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.Tasks.insertPanel = Ext.extend(Lino.cal.Tasks.InsertFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  params_panel_hidden: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/cal/Tasks",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Tasks.detail;
    this.ls_insert_handler = Lino.cal.Tasks.insert;
    Lino.cal.Tasks.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Tasks.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Tasks.insertPanel(p);
});
Lino.cal.Tasks.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Tasks", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Tasks.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Tasks", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Tasks.wf1 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Tasks", "GET", pk, "wf1", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Tasks.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Tasks", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Tasks.wf2 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Tasks", "GET", pk, "wf2", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Tasks.wf3 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Tasks", "GET", pk, "wf3", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.Tasks.detailPanel = Ext.extend(Lino.cal.Tasks.DetailFormPanel,{
  empty_title: "Detail",
  params_panel_hidden: true,
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  ls_url: "/cal/Tasks",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Tasks.detail;
    this.ls_insert_handler = Lino.cal.Tasks.insert;
    Lino.cal.Tasks.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Tasks.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Tasks.detailPanel(p);
});
Lino.cal.Tasks.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Tasks", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Tasks.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Tasks.ParamsPanel({});
  return new Lino.cal.Tasks.GridPanel(p);
});
Lino.cal.Tasks.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Tasks", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.MyTasks
Lino.cal.MyTasks.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/MyTasks",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/MyTasks','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/MyTasks','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "My tasks",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "summary" }, { "name": "workflow_buttons" }, { "name": "project" }, 'projectHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 35,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyTasks.detail;
    this.ls_insert_handler = Lino.cal.MyTasks.insert;
    var ww = this.containing_window;
    var start_date1787 = new Lino.DateField({ "selectOnFocus": true });
    var summary1788 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp1789 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var project1790 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyTasks/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.MyTasks.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Start date", "editor": start_date1787, "width": Lino.chars2width(14), "dataIndex": "start_date" }, { "colIndex": 1, "sortable": true, "header": "Summary", "editable": true, "tooltip": "(cal.MyTasks.summary) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": summary1788, "dataIndex": "summary" }, { "header": "Workflow", "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "width": Lino.chars2width(31), "editable": false, "tooltip": "(cal.MyTasks.workflow_buttons) " }, { "colIndex": 3, "sortable": true, "header": "Project", "editable": true, "tooltip": "(cal.MyTasks.project) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('projectHidden','Lino.projects.Projects.detail'), "dataIndex": "project", "editor": project1790 } ];
    Lino.cal.MyTasks.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyTasks.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyTasks.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyTasks.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.MyTasks.insertPanel = Ext.extend(Lino.cal.Tasks.InsertFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  params_panel_hidden: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/cal/MyTasks",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyTasks.detail;
    this.ls_insert_handler = Lino.cal.MyTasks.insert;
    Lino.cal.MyTasks.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyTasks.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyTasks.insertPanel(p);
});
Lino.cal.MyTasks.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyTasks.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyTasks.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyTasks.wf1 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "wf1", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyTasks.wf2 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "wf2", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyTasks.wf3 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "wf3", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.MyTasks.detailPanel = Ext.extend(Lino.cal.Tasks.DetailFormPanel,{
  empty_title: "Detail",
  params_panel_hidden: true,
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  ls_url: "/cal/MyTasks",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyTasks.detail;
    this.ls_insert_handler = Lino.cal.MyTasks.insert;
    Lino.cal.MyTasks.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyTasks.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyTasks.detailPanel(p);
});
Lino.cal.MyTasks.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyTasks.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Tasks.ParamsPanel({});
  return new Lino.cal.MyTasks.GridPanel(p);
});
Lino.cal.MyTasks.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.GuestRoles
Lino.cal.GuestRoles.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/GuestRoles",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/GuestRoles','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/GuestRoles','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Guest Roles",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 4,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_et" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 42,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.GuestRoles.detail;
    this.ls_insert_handler = Lino.cal.GuestRoles.insert;
    var ww = this.containing_window;
    var id1792 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1793 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_et1794 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.GuestRoles.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1792, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(cal.GuestRoles.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name1793, "dataIndex": "name" }, { "colIndex": 2, "sortable": true, "header": "Designation (et)", "editable": true, "tooltip": "(cal.GuestRoles.name_et) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_et1794, "dataIndex": "name_et" } ];
    Lino.cal.GuestRoles.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.GuestRoles.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestRoles", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.GuestRoles.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestRoles", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.GuestRoles.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestRoles", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.GuestRoles.insertPanel = Ext.extend(Lino.cal.GuestRoles.DetailFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/cal/GuestRoles",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.GuestRoles.detail;
    this.ls_insert_handler = Lino.cal.GuestRoles.insert;
    Lino.cal.GuestRoles.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.GuestRoles.insert = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.GuestRoles.insertPanel(p);
});
Lino.cal.GuestRoles.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestRoles", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.GuestRoles.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestRoles", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.GuestRoles.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestRoles", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.GuestRoles.detailPanel = Ext.extend(Lino.cal.GuestRoles.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  ls_url: "/cal/GuestRoles",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.GuestRoles.detail;
    this.ls_insert_handler = Lino.cal.GuestRoles.insert;
    Lino.cal.GuestRoles.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.GuestRoles.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.GuestRoles.detailPanel(p);
});
Lino.cal.GuestRoles.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestRoles", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.GuestRoles.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.GuestRoles.GridPanel(p);
});
Lino.cal.GuestRoles.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestRoles", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.Guests
Lino.cal.Guests.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/Guests",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/Guests','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/Guests','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "checkin", "menu_item_text": "Checkin", "tooltip": "Mark this visitor as arrived", "panel_btn_handler": Lino.param_action_handler(Lino.cal.Guests.checkin), "text": "Checkin", "overflowText": "Checkin", "auto_save": true }, { "itemId": "receive", "menu_item_text": "Receive", "tooltip": "Visitor was received by agent", "panel_btn_handler": Lino.row_action_handler('receive','GET',null), "text": "Receive", "overflowText": "Receive", "auto_save": true }, { "itemId": "checkout", "menu_item_text": "Checkout", "tooltip": "Visitor left the centre", "panel_btn_handler": Lino.row_action_handler('checkout','GET',null), "text": "Checkout", "overflowText": "Checkout", "auto_save": true } ],
  cell_edit : true,
  title : "Participants",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 15,
  ls_store_fields : [ { "name": "partner" }, 'partnerHidden', { "name": "role" }, 'roleHidden', { "name": "workflow_buttons" }, { "name": "remark" }, { "name": "event" }, 'eventHidden', { "type": "int", "name": "id" }, { "name": "state" }, 'stateHidden', { "name": "waiting_since" }, { "name": "busy_since" }, { "name": "gone_since" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 8,
  ls_grid_configs : [  ],
  content_type : 40,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Guests.detail;
    this.ls_insert_handler = Lino.cal.Guests.insert;
    var ww = this.containing_window;
    var partner1796 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }), "emptyText": "Select a Partner..." });
    var role1797 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Guest Role..." });
    var workflow_buttons_disp1798 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var remark1799 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var event1800 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/event", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Event..." });
    var id1801 = new Ext.form.NumberField({ "selectOnFocus": true });
    var state1802 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.GuestStates });
    var waiting_since1803 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var busy_since1804 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var gone_since1805 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(cal.Guests.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "dataIndex": "partner", "editor": partner1796 }, { "colIndex": 1, "sortable": true, "header": "Role", "editable": true, "tooltip": "(cal.Guests.role) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('roleHidden','Lino.cal.GuestRoles.detail'), "dataIndex": "role", "editor": role1797 }, { "header": "Workflow", "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "width": Lino.chars2width(31), "editable": false, "tooltip": "(cal.Guests.workflow_buttons) " }, { "colIndex": 3, "sortable": true, "header": "Remark", "editable": true, "tooltip": "(cal.Guests.remark) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": remark1799, "dataIndex": "remark" }, { "colIndex": 4, "sortable": true, "header": "Event", "editable": true, "tooltip": "(cal.Guests.event) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('eventHidden','Lino.cal.OneEvent.detail'), "dataIndex": "event", "editor": event1800 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Guests.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1801, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "State", "editable": true, "tooltip": "(cal.Guests.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": state1802, "hidden": true, "dataIndex": "state" }, { "colIndex": 7, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.Guests.waiting_since) Time when the visitor arrived (checked in).", "header": "Waiting since", "dataIndex": "waiting_since", "hidden": true }, { "colIndex": 8, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.Guests.busy_since) Time when the visitor was received by agent.", "header": "Waiting until", "dataIndex": "busy_since", "hidden": true }, { "colIndex": 9, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.Guests.gone_since) Time when the visitor left (checked out).", "header": "Present until", "dataIndex": "gone_since", "hidden": true } ];
    Lino.cal.Guests.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Guests.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Guests", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Guests.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Guests", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Guests.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Guests", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.Guests.insertPanel = Ext.extend(Lino.cal.Guests.InsertFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/cal/Guests",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Guests.detail;
    this.ls_insert_handler = Lino.cal.Guests.insert;
    Lino.cal.Guests.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Guests.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Guests.insertPanel(p);
});
Lino.cal.Guests.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Guests", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Guests.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Guests", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Guests.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Guests", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Guests.wf3 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Guests", "GET", pk, "wf3", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Guests.wf4 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Guests", "GET", pk, "wf4", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Guests.wf5 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Guests", "GET", pk, "wf5", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Guests.wf6 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Guests", "GET", pk, "wf6", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.Guests.detailPanel = Ext.extend(Lino.cal.Guests.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "checkin", "menu_item_text": "Checkin", "tooltip": "Mark this visitor as arrived", "panel_btn_handler": Lino.param_action_handler(Lino.cal.Guests.checkin), "text": "Checkin", "overflowText": "Checkin", "auto_save": true }, { "itemId": "receive", "menu_item_text": "Receive", "tooltip": "Visitor was received by agent", "panel_btn_handler": Lino.row_action_handler('receive','GET',null), "text": "Receive", "overflowText": "Receive", "auto_save": true }, { "itemId": "checkout", "menu_item_text": "Checkout", "tooltip": "Visitor left the centre", "panel_btn_handler": Lino.row_action_handler('checkout','GET',null), "text": "Checkout", "overflowText": "Checkout", "auto_save": true } ],
  ls_url: "/cal/Guests",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Guests.detail;
    this.ls_insert_handler = Lino.cal.Guests.insert;
    Lino.cal.Guests.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Guests.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Guests.detailPanel(p);
});
Lino.cal.Guests.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Guests", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Guests.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Guests.ParamsPanel({});
  return new Lino.cal.Guests.GridPanel(p);
});
Lino.cal.Guests.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Guests", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Guests.receive = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Guests", "GET", pk, "receive", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Guests.checkout = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Guests", "GET", pk, "checkout", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.MyPresences
Lino.cal.MyPresences.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/MyPresences",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/MyPresences','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/MyPresences','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "checkin", "menu_item_text": "Checkin", "tooltip": "Mark this visitor as arrived", "panel_btn_handler": Lino.param_action_handler(Lino.cal.Guests.checkin), "text": "Checkin", "overflowText": "Checkin", "auto_save": true }, { "itemId": "receive", "menu_item_text": "Receive", "tooltip": "Visitor was received by agent", "panel_btn_handler": Lino.row_action_handler('receive','GET',null), "text": "Receive", "overflowText": "Receive", "auto_save": true }, { "itemId": "checkout", "menu_item_text": "Checkout", "tooltip": "Visitor left the centre", "panel_btn_handler": Lino.row_action_handler('checkout','GET',null), "text": "Checkout", "overflowText": "Checkout", "auto_save": true } ],
  cell_edit : true,
  title : "My presences",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 18,
  ls_store_fields : [ { "type": "date", "name": "event__start_date", "dateFormat": "d.m.Y" }, { "name": "event__start_time" }, { "name": "event_summary" }, { "name": "role" }, 'roleHidden', { "name": "workflow_buttons" }, { "name": "remark" }, { "type": "int", "name": "id" }, { "name": "event" }, 'eventHidden', { "name": "partner" }, 'partnerHidden', { "name": "state" }, 'stateHidden', { "name": "waiting_since" }, { "name": "busy_since" }, { "name": "gone_since" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 40,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyPresences.detail;
    this.ls_insert_handler = Lino.cal.MyPresences.insert;
    var ww = this.containing_window;
    var event__start_date1807 = new Lino.DateField({ "disabled": true });
    var event__start_time1808 = new Lino.TimeField({ "disabled": true });
    var event_summary_disp1809 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var role1810 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyPresences/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Guest Role..." });
    var workflow_buttons_disp1811 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var remark1812 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1813 = new Ext.form.NumberField({ "selectOnFocus": true });
    var event1814 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyPresences/event", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Event..." });
    var partner1815 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyPresences/partner", "method": "GET" }) }), "emptyText": "Select a Partner..." });
    var state1816 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.GuestStates });
    var waiting_since1817 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var busy_since1818 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var gone_since1819 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": false, "tooltip": "(cal.MyPresences.event__start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Start date", "dataIndex": "event__start_date", "width": Lino.chars2width(14) }, { "header": "Start time", "colIndex": 1, "sortable": true, "dataIndex": "event__start_time", "width": Lino.chars2width(9), "editable": false, "tooltip": "(cal.MyPresences.event__start_time) " }, { "header": "Event", "colIndex": 2, "sortable": false, "dataIndex": "event_summary", "width": Lino.chars2width(31), "editable": false, "tooltip": "(cal.MyPresences.event_summary) " }, { "colIndex": 3, "sortable": true, "header": "Role", "editable": true, "tooltip": "(cal.MyPresences.role) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('roleHidden','Lino.cal.GuestRoles.detail'), "dataIndex": "role", "editor": role1810 }, { "header": "Workflow", "colIndex": 4, "sortable": false, "dataIndex": "workflow_buttons", "width": Lino.chars2width(31), "editable": false, "tooltip": "(cal.MyPresences.workflow_buttons) " }, { "colIndex": 5, "sortable": true, "header": "Remark", "editable": true, "tooltip": "(cal.MyPresences.remark) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": remark1812, "dataIndex": "remark" }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.MyPresences.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1813, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 7, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.MyPresences.event) ", "filter": { "type": "string" }, "header": "Event", "renderer": Lino.fk_renderer('eventHidden','Lino.cal.OneEvent.detail'), "dataIndex": "event", "hidden": true, "editor": event1814 }, { "colIndex": 8, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.MyPresences.partner) ", "filter": { "type": "string" }, "header": "Partner", "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "dataIndex": "partner", "hidden": true, "editor": partner1815 }, { "colIndex": 9, "sortable": true, "header": "State", "editable": true, "tooltip": "(cal.MyPresences.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": state1816, "hidden": true, "dataIndex": "state" }, { "colIndex": 10, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.MyPresences.waiting_since) Time when the visitor arrived (checked in).", "header": "Waiting since", "dataIndex": "waiting_since", "hidden": true }, { "colIndex": 11, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.MyPresences.busy_since) Time when the visitor was received by agent.", "header": "Waiting until", "dataIndex": "busy_since", "hidden": true }, { "colIndex": 12, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.MyPresences.gone_since) Time when the visitor left (checked out).", "header": "Present until", "dataIndex": "gone_since", "hidden": true } ];
    Lino.cal.MyPresences.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyPresences.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPresences.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPresences.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.MyPresences.insertPanel = Ext.extend(Lino.cal.Guests.InsertFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  params_panel_hidden: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/cal/MyPresences",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyPresences.detail;
    this.ls_insert_handler = Lino.cal.MyPresences.insert;
    Lino.cal.MyPresences.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyPresences.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyPresences.insertPanel(p);
});
Lino.cal.MyPresences.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPresences.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPresences.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPresences.wf3 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "wf3", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPresences.wf4 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "wf4", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPresences.wf5 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "wf5", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPresences.wf6 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "wf6", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.MyPresences.detailPanel = Ext.extend(Lino.cal.Guests.DetailFormPanel,{
  empty_title: "Detail",
  params_panel_hidden: true,
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "checkin", "menu_item_text": "Checkin", "tooltip": "Mark this visitor as arrived", "panel_btn_handler": Lino.param_action_handler(Lino.cal.Guests.checkin), "text": "Checkin", "overflowText": "Checkin", "auto_save": true }, { "itemId": "receive", "menu_item_text": "Receive", "tooltip": "Visitor was received by agent", "panel_btn_handler": Lino.row_action_handler('receive','GET',null), "text": "Receive", "overflowText": "Receive", "auto_save": true }, { "itemId": "checkout", "menu_item_text": "Checkout", "tooltip": "Visitor left the centre", "panel_btn_handler": Lino.row_action_handler('checkout','GET',null), "text": "Checkout", "overflowText": "Checkout", "auto_save": true } ],
  ls_url: "/cal/MyPresences",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyPresences.detail;
    this.ls_insert_handler = Lino.cal.MyPresences.insert;
    Lino.cal.MyPresences.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyPresences.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyPresences.detailPanel(p);
});
Lino.cal.MyPresences.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPresences.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Guests.ParamsPanel({});
  return new Lino.cal.MyPresences.GridPanel(p);
});
Lino.cal.MyPresences.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPresences.receive = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "receive", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPresences.checkout = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "checkout", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.MyPendingPresences
Lino.cal.MyPendingPresences.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/MyPendingPresences",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/MyPendingPresences','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/MyPendingPresences','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "checkin", "menu_item_text": "Checkin", "tooltip": "Mark this visitor as arrived", "panel_btn_handler": Lino.param_action_handler(Lino.cal.Guests.checkin), "text": "Checkin", "overflowText": "Checkin", "auto_save": true }, { "itemId": "receive", "menu_item_text": "Receive", "tooltip": "Visitor was received by agent", "panel_btn_handler": Lino.row_action_handler('receive','GET',null), "text": "Receive", "overflowText": "Receive", "auto_save": true }, { "itemId": "checkout", "menu_item_text": "Checkout", "tooltip": "Visitor left the centre", "panel_btn_handler": Lino.row_action_handler('checkout','GET',null), "text": "Checkout", "overflowText": "Checkout", "auto_save": true } ],
  cell_edit : true,
  title : "My pending invitations",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "name": "event__when_text" }, { "name": "role" }, 'roleHidden', { "name": "workflow_buttons" }, { "name": "remark" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 40,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyPendingPresences.detail;
    this.ls_insert_handler = Lino.cal.MyPendingPresences.insert;
    var ww = this.containing_window;
    var event__when_text_disp1821 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var role1822 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyPendingPresences/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Guest Role..." });
    var workflow_buttons_disp1823 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var remark1824 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "header": "When", "colIndex": 0, "sortable": false, "dataIndex": "event__when_text", "width": Lino.chars2width(31), "editable": false, "tooltip": "(cal.MyPendingPresences.event__when_text) " }, { "colIndex": 1, "sortable": true, "header": "Role", "editable": true, "tooltip": "(cal.MyPendingPresences.role) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('roleHidden','Lino.cal.GuestRoles.detail'), "dataIndex": "role", "editor": role1822 }, { "header": "Workflow", "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "width": Lino.chars2width(31), "editable": false, "tooltip": "(cal.MyPendingPresences.workflow_buttons) " }, { "colIndex": 3, "sortable": true, "header": "Remark", "editable": true, "tooltip": "(cal.MyPendingPresences.remark) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": remark1824, "dataIndex": "remark" } ];
    Lino.cal.MyPendingPresences.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyPendingPresences.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPendingPresences.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPendingPresences.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.MyPendingPresences.insertPanel = Ext.extend(Lino.cal.Guests.InsertFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  params_panel_hidden: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/cal/MyPendingPresences",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyPendingPresences.detail;
    this.ls_insert_handler = Lino.cal.MyPendingPresences.insert;
    Lino.cal.MyPendingPresences.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyPendingPresences.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyPendingPresences.insertPanel(p);
});
Lino.cal.MyPendingPresences.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPendingPresences.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPendingPresences.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPendingPresences.wf3 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "wf3", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPendingPresences.wf4 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "wf4", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPendingPresences.wf5 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "wf5", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPendingPresences.wf6 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "wf6", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.MyPendingPresences.detailPanel = Ext.extend(Lino.cal.Guests.DetailFormPanel,{
  empty_title: "Detail",
  params_panel_hidden: true,
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "checkin", "menu_item_text": "Checkin", "tooltip": "Mark this visitor as arrived", "panel_btn_handler": Lino.param_action_handler(Lino.cal.Guests.checkin), "text": "Checkin", "overflowText": "Checkin", "auto_save": true }, { "itemId": "receive", "menu_item_text": "Receive", "tooltip": "Visitor was received by agent", "panel_btn_handler": Lino.row_action_handler('receive','GET',null), "text": "Receive", "overflowText": "Receive", "auto_save": true }, { "itemId": "checkout", "menu_item_text": "Checkout", "tooltip": "Visitor left the centre", "panel_btn_handler": Lino.row_action_handler('checkout','GET',null), "text": "Checkout", "overflowText": "Checkout", "auto_save": true } ],
  ls_url: "/cal/MyPendingPresences",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyPendingPresences.detail;
    this.ls_insert_handler = Lino.cal.MyPendingPresences.insert;
    Lino.cal.MyPendingPresences.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyPendingPresences.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyPendingPresences.detailPanel(p);
});
Lino.cal.MyPendingPresences.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPendingPresences.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Guests.ParamsPanel({});
  return new Lino.cal.MyPendingPresences.GridPanel(p);
});
Lino.cal.MyPendingPresences.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPendingPresences.receive = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "receive", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPendingPresences.checkout = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "checkout", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.MyGuests
Lino.cal.MyGuests.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/MyGuests",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/MyGuests','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/MyGuests','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "checkin", "menu_item_text": "Checkin", "tooltip": "Mark this visitor as arrived", "panel_btn_handler": Lino.param_action_handler(Lino.cal.Guests.checkin), "text": "Checkin", "overflowText": "Checkin", "auto_save": true }, { "itemId": "receive", "menu_item_text": "Receive", "tooltip": "Visitor was received by agent", "panel_btn_handler": Lino.row_action_handler('receive','GET',null), "text": "Receive", "overflowText": "Receive", "auto_save": true }, { "itemId": "checkout", "menu_item_text": "Checkout", "tooltip": "Visitor left the centre", "panel_btn_handler": Lino.row_action_handler('checkout','GET',null), "text": "Checkout", "overflowText": "Checkout", "auto_save": true } ],
  cell_edit : true,
  title : "My guests",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 18,
  ls_store_fields : [ { "type": "date", "name": "event__start_date", "dateFormat": "d.m.Y" }, { "name": "event__start_time" }, { "name": "event_summary" }, { "name": "role" }, 'roleHidden', { "name": "workflow_buttons" }, { "name": "remark" }, { "type": "int", "name": "id" }, { "name": "event" }, 'eventHidden', { "name": "partner" }, 'partnerHidden', { "name": "state" }, 'stateHidden', { "name": "waiting_since" }, { "name": "busy_since" }, { "name": "gone_since" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 40,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyGuests.detail;
    this.ls_insert_handler = Lino.cal.MyGuests.insert;
    var ww = this.containing_window;
    var event__start_date1826 = new Lino.DateField({ "disabled": true });
    var event__start_time1827 = new Lino.TimeField({ "disabled": true });
    var event_summary_disp1828 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var role1829 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyGuests/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Guest Role..." });
    var workflow_buttons_disp1830 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var remark1831 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1832 = new Ext.form.NumberField({ "selectOnFocus": true });
    var event1833 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyGuests/event", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Event..." });
    var partner1834 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyGuests/partner", "method": "GET" }) }), "emptyText": "Select a Partner..." });
    var state1835 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.GuestStates });
    var waiting_since1836 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var busy_since1837 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var gone_since1838 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": false, "tooltip": "(cal.MyGuests.event__start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Start date", "dataIndex": "event__start_date", "width": Lino.chars2width(14) }, { "header": "Start time", "colIndex": 1, "sortable": true, "dataIndex": "event__start_time", "width": Lino.chars2width(9), "editable": false, "tooltip": "(cal.MyGuests.event__start_time) " }, { "header": "Event", "colIndex": 2, "sortable": false, "dataIndex": "event_summary", "width": Lino.chars2width(31), "editable": false, "tooltip": "(cal.MyGuests.event_summary) " }, { "colIndex": 3, "sortable": true, "header": "Role", "editable": true, "tooltip": "(cal.MyGuests.role) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('roleHidden','Lino.cal.GuestRoles.detail'), "dataIndex": "role", "editor": role1829 }, { "header": "Workflow", "colIndex": 4, "sortable": false, "dataIndex": "workflow_buttons", "width": Lino.chars2width(31), "editable": false, "tooltip": "(cal.MyGuests.workflow_buttons) " }, { "colIndex": 5, "sortable": true, "header": "Remark", "editable": true, "tooltip": "(cal.MyGuests.remark) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": remark1831, "dataIndex": "remark" }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.MyGuests.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1832, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 7, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.MyGuests.event) ", "filter": { "type": "string" }, "header": "Event", "renderer": Lino.fk_renderer('eventHidden','Lino.cal.OneEvent.detail'), "dataIndex": "event", "hidden": true, "editor": event1833 }, { "colIndex": 8, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.MyGuests.partner) ", "filter": { "type": "string" }, "header": "Partner", "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "dataIndex": "partner", "hidden": true, "editor": partner1834 }, { "colIndex": 9, "sortable": true, "header": "State", "editable": true, "tooltip": "(cal.MyGuests.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": state1835, "hidden": true, "dataIndex": "state" }, { "colIndex": 10, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.MyGuests.waiting_since) Time when the visitor arrived (checked in).", "header": "Waiting since", "dataIndex": "waiting_since", "hidden": true }, { "colIndex": 11, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.MyGuests.busy_since) Time when the visitor was received by agent.", "header": "Waiting until", "dataIndex": "busy_since", "hidden": true }, { "colIndex": 12, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.MyGuests.gone_since) Time when the visitor left (checked out).", "header": "Present until", "dataIndex": "gone_since", "hidden": true } ];
    Lino.cal.MyGuests.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyGuests.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyGuests.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyGuests.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.MyGuests.insertPanel = Ext.extend(Lino.cal.Guests.InsertFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/cal/MyGuests",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyGuests.detail;
    this.ls_insert_handler = Lino.cal.MyGuests.insert;
    Lino.cal.MyGuests.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyGuests.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyGuests.insertPanel(p);
});
Lino.cal.MyGuests.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyGuests.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyGuests.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyGuests.wf3 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "wf3", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyGuests.wf4 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "wf4", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyGuests.wf5 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "wf5", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyGuests.wf6 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "wf6", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.MyGuests.detailPanel = Ext.extend(Lino.cal.Guests.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "checkin", "menu_item_text": "Checkin", "tooltip": "Mark this visitor as arrived", "panel_btn_handler": Lino.param_action_handler(Lino.cal.Guests.checkin), "text": "Checkin", "overflowText": "Checkin", "auto_save": true }, { "itemId": "receive", "menu_item_text": "Receive", "tooltip": "Visitor was received by agent", "panel_btn_handler": Lino.row_action_handler('receive','GET',null), "text": "Receive", "overflowText": "Receive", "auto_save": true }, { "itemId": "checkout", "menu_item_text": "Checkout", "tooltip": "Visitor left the centre", "panel_btn_handler": Lino.row_action_handler('checkout','GET',null), "text": "Checkout", "overflowText": "Checkout", "auto_save": true } ],
  ls_url: "/cal/MyGuests",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyGuests.detail;
    this.ls_insert_handler = Lino.cal.MyGuests.insert;
    Lino.cal.MyGuests.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyGuests.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyGuests.detailPanel(p);
});
Lino.cal.MyGuests.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyGuests.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Guests.ParamsPanel({});
  return new Lino.cal.MyGuests.GridPanel(p);
});
Lino.cal.MyGuests.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyGuests.receive = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "receive", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyGuests.checkout = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "checkout", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.EventTypes
Lino.cal.EventTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/EventTypes",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/EventTypes','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/EventTypes','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Up", "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-arrow_up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-arrow_down", "overflowText": "Down", "auto_save": true } ],
  cell_edit : true,
  title : "Event Types",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 14,
  ls_store_fields : [ { "name": "name" }, { "name": "name_et" }, { "type": "int", "name": "id" }, { "type": "int", "name": "seqno" }, { "type": "boolean", "name": "attach_to_email" }, { "name": "email_template" }, { "type": "boolean", "name": "is_appointment" }, { "type": "boolean", "name": "all_rooms" }, { "type": "boolean", "name": "locks_user" }, { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "event_label" }, { "name": "event_label_et" }, { "type": "int", "name": "max_conflicting" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 38,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventTypes.detail;
    this.ls_insert_handler = Lino.cal.EventTypes.insert;
    var ww = this.containing_window;
    var name1840 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_et1841 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1842 = new Ext.form.NumberField({ "selectOnFocus": true });
    var seqno1843 = new Ext.form.NumberField({ "selectOnFocus": true });
    var attach_to_email1844 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var email_template1845 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventTypes/email_template", "method": "GET" }) }) });
    var is_appointment1846 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": true });
    var all_rooms1847 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var locks_user1848 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var start_date1849 = new Lino.DateField({ "selectOnFocus": true });
    var event_label1850 = new Ext.form.TextField({ "selectOnFocus": true, "value": "Appointment", "maxLength": 200 });
    var event_label_et1851 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var max_conflicting1852 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 1 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(cal.EventTypes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name1840, "dataIndex": "name" }, { "colIndex": 1, "sortable": true, "header": "Designation (et)", "editable": true, "tooltip": "(cal.EventTypes.name_et) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_et1841, "dataIndex": "name_et" }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.EventTypes.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1842, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.EventTypes.seqno) ", "filter": { "type": "numeric" }, "header": "Seq.No.", "editor": seqno1843, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "seqno" }), { "colIndex": 4, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.EventTypes.attach_to_email) Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n", "filter": { "type": "boolean" }, "header": "Attach to email", "dataIndex": "attach_to_email", "hidden": true }, { "colIndex": 5, "sortable": true, "header": "Email template", "editable": true, "tooltip": "(cal.EventTypes.email_template) The name of the file to be used as template when creating an email from a mailable of this type.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": email_template1845, "hidden": true, "dataIndex": "email_template" }, { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.EventTypes.is_appointment) ", "filter": { "type": "boolean" }, "header": "Event is an appointment", "dataIndex": "is_appointment", "hidden": true }, { "colIndex": 7, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.EventTypes.all_rooms) ", "filter": { "type": "boolean" }, "header": "Locks all rooms", "dataIndex": "all_rooms", "hidden": true }, { "colIndex": 8, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.EventTypes.locks_user) Whether events of this type make the user unavailable for other locking events at the same time.", "filter": { "type": "boolean" }, "header": "Locks the user", "dataIndex": "locks_user", "hidden": true }, { "colIndex": 9, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.EventTypes.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Start date", "editor": start_date1849, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "start_date" }, { "colIndex": 10, "sortable": true, "header": "Event label", "editable": true, "tooltip": "(cal.EventTypes.event_label) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": event_label1850, "hidden": true, "dataIndex": "event_label" }, { "colIndex": 11, "sortable": true, "header": "Event label (et)", "editable": true, "tooltip": "(cal.EventTypes.event_label_et) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": event_label_et1851, "hidden": true, "dataIndex": "event_label_et" }, new Lino.NullNumberColumn({ "colIndex": 12, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.EventTypes.max_conflicting) How many conflicting events should be tolerated.", "filter": { "type": "numeric" }, "header": "Simultaneous events", "editor": max_conflicting1852, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "max_conflicting" }) ];
    Lino.cal.EventTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventTypes.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventTypes", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventTypes.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventTypes", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventTypes.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventTypes", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.EventTypes.insertPanel = Ext.extend(Lino.cal.EventTypes.InsertFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/cal/EventTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventTypes.detail;
    this.ls_insert_handler = Lino.cal.EventTypes.insert;
    Lino.cal.EventTypes.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventTypes.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.EventTypes.insertPanel(p);
});
Lino.cal.EventTypes.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventTypes", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventTypes.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventTypes", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventTypes.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventTypes", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventTypes.duplicate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventTypes", "GET", pk, "duplicate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.EventTypes.detailPanel = Ext.extend(Lino.cal.EventTypes.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Up", "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-arrow_up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-arrow_down", "overflowText": "Down", "auto_save": true } ],
  ls_url: "/cal/EventTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventTypes.detail;
    this.ls_insert_handler = Lino.cal.EventTypes.insert;
    Lino.cal.EventTypes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventTypes.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.EventTypes.detailPanel(p);
});
Lino.cal.EventTypes.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventTypes", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventTypes.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.EventTypes.GridPanel(p);
});
Lino.cal.EventTypes.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventTypes", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventTypes.move_up = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventTypes", "GET", pk, "move_up", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventTypes.move_down = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventTypes", "GET", pk, "move_down", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.RecurrentEvents
Lino.cal.RecurrentEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "No data to display." },
  ls_url : "/cal/RecurrentEvents",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/RecurrentEvents','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/RecurrentEvents','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "do_update_events", "menu_item_text": "Update Events", "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('do_update_events','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true } ],
  cell_edit : true,
  title : "Recurrent Events",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 23,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "name" }, { "name": "name_et" }, { "name": "every_unit" }, 'every_unitHidden', { "name": "event_type" }, 'event_typeHidden', { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "start_time" }, { "name": "end_time" }, { "type": "int", "name": "every" }, { "type": "boolean", "name": "monday" }, { "type": "boolean", "name": "tuesday" }, { "type": "boolean", "name": "wednesday" }, { "type": "boolean", "name": "thursday" }, { "type": "boolean", "name": "friday" }, { "type": "boolean", "name": "saturday" }, { "type": "boolean", "name": "sunday" }, { "type": "int", "name": "max_events" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 8,
  ls_grid_configs : [  ],
  content_type : 37,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.RecurrentEvents.detail;
    this.ls_insert_handler = Lino.cal.RecurrentEvents.insert;
    var ww = this.containing_window;
    var start_date1854 = new Lino.DateField({ "selectOnFocus": true });
    var end_date1855 = new Lino.DateField({ "selectOnFocus": true });
    var name1856 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_et1857 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var every_unit1858 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.Recurrencies });
    var event_type1859 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/RecurrentEvents/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Event Type..." });
    var id1860 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1861 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/RecurrentEvents/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var start_time1862 = new Lino.TimeField({ "selectOnFocus": true });
    var end_time1863 = new Lino.TimeField({ "selectOnFocus": true });
    var every1864 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var monday1865 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var tuesday1866 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var wednesday1867 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var thursday1868 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var friday1869 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var saturday1870 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var sunday1871 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var max_events1872 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.RecurrentEvents.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Start date", "editor": start_date1854, "width": Lino.chars2width(14), "dataIndex": "start_date" }, { "colIndex": 1, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.RecurrentEvents.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "End Date", "editor": end_date1855, "width": Lino.chars2width(14), "dataIndex": "end_date" }, { "colIndex": 2, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(cal.RecurrentEvents.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name1856, "dataIndex": "name" }, { "colIndex": 3, "sortable": true, "header": "Designation (et)", "editable": true, "tooltip": "(cal.RecurrentEvents.name_et) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_et1857, "dataIndex": "name_et" }, { "colIndex": 4, "sortable": true, "header": "Recurrency", "editable": true, "tooltip": "(cal.RecurrentEvents.every_unit) ", "filter": { "type": "string" }, "width": Lino.chars2width(15), "editor": every_unit1858, "dataIndex": "every_unit" }, { "colIndex": 5, "sortable": true, "header": "Event Type", "editable": true, "tooltip": "(cal.RecurrentEvents.event_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('event_typeHidden','Lino.cal.EventTypes.detail'), "dataIndex": "event_type", "editor": event_type1859 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.RecurrentEvents.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1860, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 7, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.RecurrentEvents.user) ", "filter": { "type": "string" }, "header": "Author", "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "dataIndex": "user", "hidden": true, "editor": user1861 }, { "colIndex": 8, "sortable": true, "header": "Start time", "editable": true, "tooltip": "(cal.RecurrentEvents.start_time) ", "width": Lino.chars2width(9), "editor": start_time1862, "hidden": true, "dataIndex": "start_time" }, { "colIndex": 9, "sortable": true, "header": "End Time", "editable": true, "tooltip": "(cal.RecurrentEvents.end_time) ", "width": Lino.chars2width(9), "editor": end_time1863, "hidden": true, "dataIndex": "end_time" }, new Lino.NullNumberColumn({ "colIndex": 10, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.RecurrentEvents.every) ", "filter": { "type": "numeric" }, "header": "Repeat every", "editor": every1864, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "every" }), { "colIndex": 11, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.RecurrentEvents.monday) ", "filter": { "type": "boolean" }, "header": "Monday", "dataIndex": "monday", "hidden": true }, { "colIndex": 12, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.RecurrentEvents.tuesday) ", "filter": { "type": "boolean" }, "header": "Tuesday", "dataIndex": "tuesday", "hidden": true }, { "colIndex": 13, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.RecurrentEvents.wednesday) ", "filter": { "type": "boolean" }, "header": "Wednesday", "dataIndex": "wednesday", "hidden": true }, { "colIndex": 14, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.RecurrentEvents.thursday) ", "filter": { "type": "boolean" }, "header": "Thursday", "dataIndex": "thursday", "hidden": true }, { "colIndex": 15, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.RecurrentEvents.friday) ", "filter": { "type": "boolean" }, "header": "Friday", "dataIndex": "friday", "hidden": true }, { "colIndex": 16, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.RecurrentEvents.saturday) ", "filter": { "type": "boolean" }, "header": "Saturday", "dataIndex": "saturday", "hidden": true }, { "colIndex": 17, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.RecurrentEvents.sunday) ", "filter": { "type": "boolean" }, "header": "Sunday", "dataIndex": "sunday", "hidden": true }, new Lino.NullNumberColumn({ "colIndex": 18, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.RecurrentEvents.max_events) ", "filter": { "type": "numeric" }, "header": "Number of events", "editor": max_events1872, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "max_events" }) ];
    Lino.cal.RecurrentEvents.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.RecurrentEvents.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RecurrentEvents", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.RecurrentEvents.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RecurrentEvents", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.RecurrentEvents.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RecurrentEvents", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.RecurrentEvents.insertPanel = Ext.extend(Lino.cal.RecurrentEvents.InsertFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/cal/RecurrentEvents",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.RecurrentEvents.detail;
    this.ls_insert_handler = Lino.cal.RecurrentEvents.insert;
    Lino.cal.RecurrentEvents.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.RecurrentEvents.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(80), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.RecurrentEvents.insertPanel(p);
});
Lino.cal.RecurrentEvents.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RecurrentEvents", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.RecurrentEvents.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RecurrentEvents", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.RecurrentEvents.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RecurrentEvents", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.RecurrentEvents.detailPanel = Ext.extend(Lino.cal.RecurrentEvents.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "do_update_events", "menu_item_text": "Update Events", "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('do_update_events','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true } ],
  ls_url: "/cal/RecurrentEvents",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.RecurrentEvents.detail;
    this.ls_insert_handler = Lino.cal.RecurrentEvents.insert;
    Lino.cal.RecurrentEvents.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.RecurrentEvents.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.RecurrentEvents.detailPanel(p);
});
Lino.cal.RecurrentEvents.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RecurrentEvents", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.RecurrentEvents.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.RecurrentEvents.GridPanel(p);
});
Lino.cal.RecurrentEvents.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RecurrentEvents", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.RecurrentEvents.do_update_events = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RecurrentEvents", "GET", pk, "do_update_events", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.Events
Lino.cal.Events.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/Events",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/Events','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/Events','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Clear cache", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Edit Print Template", "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Edit Print Template", "overflowText": "Edit Print Template", "auto_save": true }, { "itemId": "show_today", "menu_item_text": "Today", "tooltip": "Show all calendar events of the same day.", "panel_btn_handler": Lino.row_action_handler('show_today','GET',null), "iconCls": "x-tbar-calendar", "overflowText": "Today", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "Create email", "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "Create email", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "Create posting", "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET',null), "iconCls": "x-tbar-script_add", "overflowText": "Create posting", "auto_save": true }, { "itemId": "do_update_guests", "menu_item_text": "Update Guests", "tooltip": "Update Guests", "panel_btn_handler": Lino.row_action_handler('do_update_guests','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Guests", "auto_save": true }, { "itemId": "take", "menu_item_text": "Take", "tooltip": "Take responsibility for this event.", "panel_btn_handler": Lino.row_action_handler('take','GET',null), "iconCls": "x-tbar-flag_green", "overflowText": "Take", "auto_save": true }, { "itemId": "move_next", "menu_item_text": "Move down", "tooltip": "Move down", "panel_btn_handler": Lino.row_action_handler('move_next','GET',null), "iconCls": "x-tbar-date_next", "overflowText": "Move down", "auto_save": true } ],
  cell_edit : true,
  title : "Events",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 37,
  ls_store_fields : [ { "name": "when_text" }, { "name": "user" }, 'userHidden', { "name": "summary" }, { "name": "event_type" }, 'event_typeHidden', { "type": "int", "name": "id" }, { "name": "modified" }, { "name": "created" }, { "name": "project" }, 'projectHidden', { "name": "build_time" }, { "name": "build_method" }, 'build_methodHidden', { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "room" }, 'roomHidden', { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 44,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Events.detail;
    this.ls_insert_handler = Lino.cal.Events.insert;
    var ww = this.containing_window;
    var when_text_disp1874 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var user1875 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var summary1876 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var event_type1877 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Event Type..." });
    var id1878 = new Ext.form.NumberField({ "selectOnFocus": true });
    var modified1879 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created1880 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var project1881 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var build_time1882 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_method1883 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.lino.BuildMethods });
    var owner_type1884 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id1885 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/owner_id", "method": "GET" }) }) });
    var start_date1886 = new Lino.DateField({ "selectOnFocus": true });
    var start_time1887 = new Lino.TimeField({ "selectOnFocus": true });
    var end_date1888 = new Lino.DateField({ "selectOnFocus": true });
    var end_time1889 = new Lino.TimeField({ "selectOnFocus": true });
    var access_class1890 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var sequence1891 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type1892 = new Ext.form.NumberField({ "disabled": true });
    var transparent1893 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var room1894 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/room", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Room..." });
    var priority1895 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Priority..." });
    var state1896 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var assigned_to1897 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var owner_disp1898 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "header": "When", "colIndex": 0, "sortable": false, "dataIndex": "when_text", "width": Lino.chars2width(21), "editable": false, "tooltip": "(cal.Events.when_text) " }, { "colIndex": 1, "sortable": true, "header": "Responsible user", "editable": true, "tooltip": "(cal.Events.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "dataIndex": "user", "editor": user1875 }, { "colIndex": 2, "sortable": true, "header": "Summary", "editable": true, "tooltip": "(cal.Events.summary) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": summary1876, "dataIndex": "summary" }, { "colIndex": 3, "sortable": true, "header": "Event Type", "editable": true, "tooltip": "(cal.Events.event_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('event_typeHidden','Lino.cal.EventTypes.detail'), "dataIndex": "event_type", "editor": event_type1877 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Events.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1878, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.Events.modified) ", "header": "Modified", "dataIndex": "modified", "hidden": true }, { "colIndex": 6, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.Events.created) ", "header": "Created", "dataIndex": "created", "hidden": true }, { "colIndex": 7, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.Events.project) ", "filter": { "type": "string" }, "header": "Project", "renderer": Lino.fk_renderer('projectHidden','Lino.projects.Projects.detail'), "dataIndex": "project", "hidden": true, "editor": project1881 }, { "colIndex": 8, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.Events.build_time) ", "header": "build time", "dataIndex": "build_time", "hidden": true }, { "colIndex": 9, "sortable": true, "header": "Build method", "editable": true, "tooltip": "(cal.Events.build_method) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": build_method1883, "hidden": true, "dataIndex": "build_method" }, { "colIndex": 10, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.Events.owner_type) ", "filter": { "type": "string" }, "header": "Controlled by (type)", "renderer": Lino.fk_renderer('owner_typeHidden','Lino.contenttypes.ContentTypes.detail'), "dataIndex": "owner_type", "hidden": true, "editor": owner_type1884 }, { "colIndex": 11, "sortable": true, "header": "Controlled by (object)", "editable": true, "tooltip": "(cal.Events.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": owner_id1885, "hidden": true, "dataIndex": "owner_id" }, { "colIndex": 12, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.Events.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Start date", "editor": start_date1886, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "start_date" }, { "colIndex": 13, "sortable": true, "header": "Start time", "editable": true, "tooltip": "(cal.Events.start_time) ", "width": Lino.chars2width(9), "editor": start_time1887, "hidden": true, "dataIndex": "start_time" }, { "colIndex": 14, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.Events.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "End Date", "editor": end_date1888, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "end_date" }, { "colIndex": 15, "sortable": true, "header": "End Time", "editable": true, "tooltip": "(cal.Events.end_time) ", "width": Lino.chars2width(9), "editor": end_time1889, "hidden": true, "dataIndex": "end_time" }, { "colIndex": 16, "sortable": true, "header": "Access Class", "editable": true, "tooltip": "(cal.Events.access_class) Whether this is private, public or between.", "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": access_class1890, "hidden": true, "dataIndex": "access_class" }, new Lino.NullNumberColumn({ "colIndex": 17, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Events.sequence) ", "filter": { "type": "numeric" }, "header": "Revision", "editor": sequence1891, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "sequence" }), new Lino.NullNumberColumn({ "colIndex": 18, "sortable": true, "format": "0", "editable": false, "tooltip": "(cal.Events.auto_type) ", "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 19, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.Events.transparent) Indicates that this Event shouldn't prevent other Events at the same time.", "filter": { "type": "boolean" }, "header": "Transparent", "dataIndex": "transparent", "hidden": true }, { "colIndex": 20, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.Events.room) ", "filter": { "type": "string" }, "header": "Room", "renderer": Lino.fk_renderer('roomHidden','Lino.cal.Rooms.detail'), "dataIndex": "room", "hidden": true, "editor": room1894 }, { "colIndex": 21, "sortable": true, "header": "Priority", "editable": true, "tooltip": "(cal.Events.priority) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": priority1895, "hidden": true, "dataIndex": "priority" }, { "colIndex": 22, "sortable": true, "header": "State", "editable": true, "tooltip": "(cal.Events.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(14), "editor": state1896, "hidden": true, "dataIndex": "state" }, { "colIndex": 23, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.Events.assigned_to) ", "filter": { "type": "string" }, "header": "Assigned to", "renderer": Lino.fk_renderer('assigned_toHidden','Lino.users.Users.detail'), "dataIndex": "assigned_to", "hidden": true, "editor": assigned_to1897 }, { "colIndex": 24, "sortable": false, "width": Lino.chars2width(11), "editable": false, "tooltip": "(cal.Events.owner) ", "header": "Controlled by", "dataIndex": "owner", "hidden": true } ];
    Lino.cal.Events.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Events.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Events.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Events.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.Events.insertPanel = Ext.extend(Lino.cal.Events.InsertFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  params_panel_hidden: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/cal/Events",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Events.detail;
    this.ls_insert_handler = Lino.cal.Events.insert;
    Lino.cal.Events.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Events.insert = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Events.insertPanel(p);
});
Lino.cal.Events.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Events.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Events.wf1 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "wf1", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Events.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Events.duplicate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "duplicate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Events.wf2 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "wf2", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Events.wf3 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "wf3", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Events.wf4 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "wf4", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.Events.detailPanel = Ext.extend(Lino.cal.Events.DetailFormPanel,{
  empty_title: "Detail",
  params_panel_hidden: true,
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Clear cache", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Edit Print Template", "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Edit Print Template", "overflowText": "Edit Print Template", "auto_save": true }, { "itemId": "show_today", "menu_item_text": "Today", "tooltip": "Show all calendar events of the same day.", "panel_btn_handler": Lino.row_action_handler('show_today','GET',null), "iconCls": "x-tbar-calendar", "overflowText": "Today", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "Create email", "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "Create email", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "Create posting", "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET',null), "iconCls": "x-tbar-script_add", "overflowText": "Create posting", "auto_save": true }, { "itemId": "do_update_guests", "menu_item_text": "Update Guests", "tooltip": "Update Guests", "panel_btn_handler": Lino.row_action_handler('do_update_guests','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Guests", "auto_save": true }, { "itemId": "take", "menu_item_text": "Take", "tooltip": "Take responsibility for this event.", "panel_btn_handler": Lino.row_action_handler('take','GET',null), "iconCls": "x-tbar-flag_green", "overflowText": "Take", "auto_save": true }, { "itemId": "move_next", "menu_item_text": "Move down", "tooltip": "Move down", "panel_btn_handler": Lino.row_action_handler('move_next','GET',null), "iconCls": "x-tbar-date_next", "overflowText": "Move down", "auto_save": true } ],
  ls_url: "/cal/Events",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Events.detail;
    this.ls_insert_handler = Lino.cal.Events.insert;
    Lino.cal.Events.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Events.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Events.detailPanel(p);
});
Lino.cal.Events.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Events.do_print = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "POST", pk, "do_print", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Events.do_clear_cache = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "do_clear_cache", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Events.edit_template = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "edit_template", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Events.show_today = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "show_today", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Events.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Events.ParamsPanel({});
  return new Lino.cal.Events.GridPanel(p);
});
Lino.cal.Events.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Events.create_mail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "create_mail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Events.create_postings = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "create_postings", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Events.do_update_guests = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "do_update_guests", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Events.take = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "take", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Events.move_next = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "move_next", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.EventsByDay
Lino.cal.EventsByDay.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "No data to display." },
  ls_url : "/cal/EventsByDay",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/EventsByDay','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/EventsByDay','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Clear cache", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Edit Print Template", "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Edit Print Template", "overflowText": "Edit Print Template", "auto_save": true }, { "itemId": "show_today", "menu_item_text": "Today", "tooltip": "Show all calendar events of the same day.", "panel_btn_handler": Lino.row_action_handler('show_today','GET',null), "iconCls": "x-tbar-calendar", "overflowText": "Today", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "Create posting", "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET',null), "iconCls": "x-tbar-script_add", "overflowText": "Create posting", "auto_save": true }, { "itemId": "do_update_guests", "menu_item_text": "Update Guests", "tooltip": "Update Guests", "panel_btn_handler": Lino.row_action_handler('do_update_guests','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Guests", "auto_save": true }, { "itemId": "take", "menu_item_text": "Take", "tooltip": "Take responsibility for this event.", "panel_btn_handler": Lino.row_action_handler('take','GET',null), "iconCls": "x-tbar-flag_green", "overflowText": "Take", "auto_save": true }, { "itemId": "move_next", "menu_item_text": "Move down", "tooltip": "Move down", "panel_btn_handler": Lino.row_action_handler('move_next','GET',null), "iconCls": "x-tbar-date_next", "overflowText": "Move down", "auto_save": true }, { "itemId": "create_mail", "menu_item_text": "Create email", "tooltip": "Create an email from this", "panel_btn_handler": Lino.row_action_handler('create_mail','GET',null), "iconCls": "x-tbar-email_add", "overflowText": "Create email", "auto_save": true } ],
  cell_edit : true,
  title : "Appointments today",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 37,
  ls_store_fields : [ { "name": "room" }, 'roomHidden', { "name": "summary" }, { "name": "owner" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "modified" }, { "name": "created" }, { "name": "project" }, 'projectHidden', { "name": "build_time" }, { "name": "build_method" }, 'build_methodHidden', { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "name": "event_type" }, 'event_typeHidden', { "type": "boolean", "name": "transparent" }, { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 44,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsByDay.detail;
    this.ls_insert_handler = Lino.cal.EventsByDay.insert;
    var ww = this.containing_window;
    var room1900 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByDay/room", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Room..." });
    var summary1901 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var owner_disp1902 = new Ext.form.DisplayField({ "disabled": true });
    var workflow_buttons_disp1903 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id1904 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1905 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByDay/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var modified1906 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created1907 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var project1908 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByDay/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var build_time1909 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_method1910 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.lino.BuildMethods });
    var owner_type1911 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByDay/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id1912 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByDay/owner_id", "method": "GET" }) }) });
    var start_date1913 = new Lino.DateField({ "selectOnFocus": true });
    var start_time1914 = new Lino.TimeField({ "selectOnFocus": true });
    var end_date1915 = new Lino.DateField({ "selectOnFocus": true });
    var end_time1916 = new Lino.TimeField({ "selectOnFocus": true });
    var access_class1917 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var sequence1918 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type1919 = new Ext.form.NumberField({ "disabled": true });
    var event_type1920 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByDay/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Event Type..." });
    var transparent1921 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var priority1922 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByDay/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Priority..." });
    var state1923 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var assigned_to1924 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByDay/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Room", "editable": true, "tooltip": "(cal.EventsByDay.room) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('roomHidden','Lino.cal.Rooms.detail'), "dataIndex": "room", "editor": room1900 }, { "colIndex": 1, "sortable": true, "header": "Summary", "editable": true, "tooltip": "(cal.EventsByDay.summary) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": summary1901, "dataIndex": "summary" }, { "header": "Controlled by", "colIndex": 2, "sortable": false, "dataIndex": "owner", "width": Lino.chars2width(11), "editable": false, "tooltip": "(cal.EventsByDay.owner) " }, { "header": "Workflow", "colIndex": 3, "sortable": false, "dataIndex": "workflow_buttons", "width": Lino.chars2width(31), "editable": false, "tooltip": "(cal.EventsByDay.workflow_buttons) " }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.EventsByDay.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1904, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.EventsByDay.user) ", "filter": { "type": "string" }, "header": "Responsible user", "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "dataIndex": "user", "hidden": true, "editor": user1905 }, { "colIndex": 6, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.EventsByDay.modified) ", "header": "Modified", "dataIndex": "modified", "hidden": true }, { "colIndex": 7, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.EventsByDay.created) ", "header": "Created", "dataIndex": "created", "hidden": true }, { "colIndex": 8, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.EventsByDay.project) ", "filter": { "type": "string" }, "header": "Project", "renderer": Lino.fk_renderer('projectHidden','Lino.projects.Projects.detail'), "dataIndex": "project", "hidden": true, "editor": project1908 }, { "colIndex": 9, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.EventsByDay.build_time) ", "header": "build time", "dataIndex": "build_time", "hidden": true }, { "colIndex": 10, "sortable": true, "header": "Build method", "editable": true, "tooltip": "(cal.EventsByDay.build_method) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": build_method1910, "hidden": true, "dataIndex": "build_method" }, { "colIndex": 11, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.EventsByDay.owner_type) ", "filter": { "type": "string" }, "header": "Controlled by (type)", "renderer": Lino.fk_renderer('owner_typeHidden','Lino.contenttypes.ContentTypes.detail'), "dataIndex": "owner_type", "hidden": true, "editor": owner_type1911 }, { "colIndex": 12, "sortable": true, "header": "Controlled by (object)", "editable": true, "tooltip": "(cal.EventsByDay.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": owner_id1912, "hidden": true, "dataIndex": "owner_id" }, { "colIndex": 13, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.EventsByDay.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Start date", "editor": start_date1913, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "start_date" }, { "colIndex": 14, "sortable": true, "header": "Start time", "editable": true, "tooltip": "(cal.EventsByDay.start_time) ", "width": Lino.chars2width(9), "editor": start_time1914, "hidden": true, "dataIndex": "start_time" }, { "colIndex": 15, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.EventsByDay.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "End Date", "editor": end_date1915, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "end_date" }, { "colIndex": 16, "sortable": true, "header": "End Time", "editable": true, "tooltip": "(cal.EventsByDay.end_time) ", "width": Lino.chars2width(9), "editor": end_time1916, "hidden": true, "dataIndex": "end_time" }, { "colIndex": 17, "sortable": true, "header": "Access Class", "editable": true, "tooltip": "(cal.EventsByDay.access_class) Whether this is private, public or between.", "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": access_class1917, "hidden": true, "dataIndex": "access_class" }, new Lino.NullNumberColumn({ "colIndex": 18, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.EventsByDay.sequence) ", "filter": { "type": "numeric" }, "header": "Revision", "editor": sequence1918, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "sequence" }), new Lino.NullNumberColumn({ "colIndex": 19, "sortable": true, "format": "0", "editable": false, "tooltip": "(cal.EventsByDay.auto_type) ", "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 20, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.EventsByDay.event_type) ", "filter": { "type": "string" }, "header": "Event Type", "renderer": Lino.fk_renderer('event_typeHidden','Lino.cal.EventTypes.detail'), "dataIndex": "event_type", "hidden": true, "editor": event_type1920 }, { "colIndex": 21, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.EventsByDay.transparent) Indicates that this Event shouldn't prevent other Events at the same time.", "filter": { "type": "boolean" }, "header": "Transparent", "dataIndex": "transparent", "hidden": true }, { "colIndex": 22, "sortable": true, "header": "Priority", "editable": true, "tooltip": "(cal.EventsByDay.priority) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": priority1922, "hidden": true, "dataIndex": "priority" }, { "colIndex": 23, "sortable": true, "header": "State", "editable": true, "tooltip": "(cal.EventsByDay.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(14), "editor": state1923, "hidden": true, "dataIndex": "state" }, { "colIndex": 24, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.EventsByDay.assigned_to) ", "filter": { "type": "string" }, "header": "Assigned to", "renderer": Lino.fk_renderer('assigned_toHidden','Lino.users.Users.detail'), "dataIndex": "assigned_to", "hidden": true, "editor": assigned_to1924 } ];
    Lino.cal.EventsByDay.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsByDay.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.submit_detail = function(rp, pk, params) { 
  v