#!/usr/bin/env python
# -*- coding: UTF-8 -*-
"""
This is a Python dump created using Lino 1.6.14, Django 1.6.7, Python 2.7.4, Babel 1.3, Jinja 2.7.2, Sphinx 1.3a0, python-dateutil 2.1, OdfPy ODFPY/0.9.6, docutils 0.11, suds 0.4, PyYaml 3.10, Appy 0.9.0 (2014/06/23 22:15).

"""
from __future__ import unicode_literals

import logging
logger = logging.getLogger('lino.management.commands.dump2py')
import os

SOURCE_VERSION = '0.1'

from decimal import Decimal
from datetime import datetime as dt
from datetime import time,date
from django.conf import settings
from django.contrib.contenttypes.models import ContentType
from lino.utils.dpy import create_mti_child
from lino.utils.dpy import DpyLoader
from lino.core.dbutils import resolve_model
        
def new_content_type_id(m):
    if m is None: return m
    ct = ContentType.objects.get_for_model(m)
    if ct is None: return None
    return ct.pk
    

def bv2kw(fieldname, values):
    """
    Needed if `Site.languages` changed between dumpdata and loaddata
    """
    return settings.SITE.babelkw(fieldname, en=values[0],de=values[1],fr=values[2],et=values[3])
    
accounts_Account = resolve_model("accounts.Account")
accounts_Chart = resolve_model("accounts.Chart")
accounts_Group = resolve_model("accounts.Group")
addresses_Address = resolve_model("addresses.Address")
blogs_Entry = resolve_model("blogs.Entry")
blogs_EntryType = resolve_model("blogs.EntryType")
cal_Calendar = resolve_model("cal.Calendar")
cal_Event = resolve_model("cal.Event")
cal_EventType = resolve_model("cal.EventType")
cal_Guest = resolve_model("cal.Guest")
cal_GuestRole = resolve_model("cal.GuestRole")
cal_Priority = resolve_model("cal.Priority")
cal_RecurrentEvent = resolve_model("cal.RecurrentEvent")
cal_RemoteCalendar = resolve_model("cal.RemoteCalendar")
cal_Room = resolve_model("cal.Room")
cal_Subscription = resolve_model("cal.Subscription")
cal_Task = resolve_model("cal.Task")
contacts_Company = resolve_model("contacts.Company")
contacts_CompanyType = resolve_model("contacts.CompanyType")
contacts_Partner = resolve_model("contacts.Partner")
contacts_Person = resolve_model("contacts.Person")
contacts_Role = resolve_model("contacts.Role")
contacts_RoleType = resolve_model("contacts.RoleType")
contenttypes_HelpText = resolve_model("contenttypes.HelpText")
countries_Country = resolve_model("countries.Country")
countries_Place = resolve_model("countries.Place")
excerpts_Excerpt = resolve_model("excerpts.Excerpt")
excerpts_ExcerptType = resolve_model("excerpts.ExcerptType")
finan_BankStatement = resolve_model("finan.BankStatement")
finan_BankStatementItem = resolve_model("finan.BankStatementItem")
finan_JournalEntry = resolve_model("finan.JournalEntry")
finan_JournalEntryItem = resolve_model("finan.JournalEntryItem")
finan_PaymentOrder = resolve_model("finan.PaymentOrder")
finan_PaymentOrderItem = resolve_model("finan.PaymentOrderItem")
households_Household = resolve_model("households.Household")
households_Member = resolve_model("households.Member")
households_Type = resolve_model("households.Type")
humanlinks_Link = resolve_model("humanlinks.Link")
ledger_AccountInvoice = resolve_model("ledger.AccountInvoice")
ledger_InvoiceItem = resolve_model("ledger.InvoiceItem")
ledger_Journal = resolve_model("ledger.Journal")
ledger_Movement = resolve_model("ledger.Movement")
ledger_Voucher = resolve_model("ledger.Voucher")
lists_List = resolve_model("lists.List")
lists_ListType = resolve_model("lists.ListType")
lists_Member = resolve_model("lists.Member")
outbox_Attachment = resolve_model("outbox.Attachment")
outbox_Mail = resolve_model("outbox.Mail")
outbox_Recipient = resolve_model("outbox.Recipient")
products_Product = resolve_model("products.Product")
products_ProductCat = resolve_model("products.ProductCat")
properties_PropChoice = resolve_model("properties.PropChoice")
properties_PropGroup = resolve_model("properties.PropGroup")
properties_PropType = resolve_model("properties.PropType")
properties_Property = resolve_model("properties.Property")
sales_Invoice = resolve_model("sales.Invoice")
sales_InvoiceItem = resolve_model("sales.InvoiceItem")
sales_InvoicingMode = resolve_model("sales.InvoicingMode")
sales_ShippingMode = resolve_model("sales.ShippingMode")
sepa_Account = resolve_model("sepa.Account")
system_SiteConfig = resolve_model("system.SiteConfig")
system_TextFieldTemplate = resolve_model("system.TextFieldTemplate")
tickets_Dependency = resolve_model("tickets.Dependency")
tickets_Milestone = resolve_model("tickets.Milestone")
tickets_Project = resolve_model("tickets.Project")
tickets_ProjectType = resolve_model("tickets.ProjectType")
tickets_Session = resolve_model("tickets.Session")
tickets_SessionType = resolve_model("tickets.SessionType")
tickets_Ticket = resolve_model("tickets.Ticket")
tickets_Vote = resolve_model("tickets.Vote")
uploads_Upload = resolve_model("uploads.Upload")
uploads_UploadType = resolve_model("uploads.UploadType")
users_Authority = resolve_model("users.Authority")
users_User = resolve_model("users.User")
vat_PaymentTerm = resolve_model("vat.PaymentTerm")


def create_accounts_chart(id, name):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    return accounts_Chart(**kw)

def create_accounts_group(id, name, chart_id, ref, account_type):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(chart_id=chart_id)
    kw.update(ref=ref)
    kw.update(account_type=account_type)
    return accounts_Group(**kw)

def create_accounts_account(id, seqno, name, chart_id, group_id, ref, type, sales_allowed, purchases_allowed, wages_allowed, clearings_allowed, clearable):
    kw = dict()
    kw.update(id=id)
    kw.update(seqno=seqno)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(chart_id=chart_id)
    kw.update(group_id=group_id)
    kw.update(ref=ref)
    kw.update(type=type)
    kw.update(sales_allowed=sales_allowed)
    kw.update(purchases_allowed=purchases_allowed)
    kw.update(wages_allowed=wages_allowed)
    kw.update(clearings_allowed=clearings_allowed)
    kw.update(clearable=clearable)
    return accounts_Account(**kw)

def create_blogs_entrytype(id, build_method, template, name, important, remark):
    kw = dict()
    kw.update(id=id)
    kw.update(build_method=build_method)
    kw.update(template=template)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(important=important)
    kw.update(remark=remark)
    return blogs_EntryType(**kw)

def create_cal_calendar(id, name, description, color):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(description=description)
    kw.update(color=color)
    return cal_Calendar(**kw)

def create_cal_eventtype(id, seqno, name, attach_to_email, email_template, description, is_appointment, all_rooms, locks_user, start_date, event_label, max_conflicting):
    kw = dict()
    kw.update(id=id)
    kw.update(seqno=seqno)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(attach_to_email=attach_to_email)
    kw.update(email_template=email_template)
    kw.update(description=description)
    kw.update(is_appointment=is_appointment)
    kw.update(all_rooms=all_rooms)
    kw.update(locks_user=locks_user)
    kw.update(start_date=start_date)
    if event_label is not None: kw.update(bv2kw('event_label',event_label))
    kw.update(max_conflicting=max_conflicting)
    return cal_EventType(**kw)

def create_cal_guestrole(id, name):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    return cal_GuestRole(**kw)

def create_cal_priority(id, name, ref):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(ref=ref)
    return cal_Priority(**kw)

def create_cal_remotecalendar(id, seqno, type, url_template, username, password, readonly):
    kw = dict()
    kw.update(id=id)
    kw.update(seqno=seqno)
    kw.update(type=type)
    kw.update(url_template=url_template)
    kw.update(username=username)
    kw.update(password=password)
    kw.update(readonly=readonly)
    return cal_RemoteCalendar(**kw)

def create_cal_room(id, name):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    return cal_Room(**kw)

def create_contacts_companytype(id, name, abbr):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    if abbr is not None: kw.update(bv2kw('abbr',abbr))
    return contacts_CompanyType(**kw)

def create_contacts_roletype(id, name):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    return contacts_RoleType(**kw)

def create_contenttypes_helptext(id, content_type_id, field, help_text):
    kw = dict()
    kw.update(id=id)
    content_type_id = new_content_type_id(content_type_id)
    kw.update(content_type_id=content_type_id)
    kw.update(field=field)
    kw.update(help_text=help_text)
    return contenttypes_HelpText(**kw)

def create_countries_country(name, isocode, short_code, iso3):
    kw = dict()
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(isocode=isocode)
    kw.update(short_code=short_code)
    kw.update(iso3=iso3)
    return countries_Country(**kw)

def create_countries_place(id, name, country_id, zip_code, type, parent_id):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(country_id=country_id)
    kw.update(zip_code=zip_code)
    kw.update(type=type)
    kw.update(parent_id=parent_id)
    return countries_Place(**kw)

def create_excerpts_excerpttype(id, build_method, template, name, attach_to_email, email_template, certifying, remark, body_template, content_type_id, primary, backward_compat, print_recipient, print_directly, shortcut):
    kw = dict()
    kw.update(id=id)
    kw.update(build_method=build_method)
    kw.update(template=template)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(attach_to_email=attach_to_email)
    kw.update(email_template=email_template)
    kw.update(certifying=certifying)
    kw.update(remark=remark)
    kw.update(body_template=body_template)
    content_type_id = new_content_type_id(content_type_id)
    kw.update(content_type_id=content_type_id)
    kw.update(primary=primary)
    kw.update(backward_compat=backward_compat)
    kw.update(print_recipient=print_recipient)
    kw.update(print_directly=print_directly)
    kw.update(shortcut=shortcut)
    return excerpts_ExcerptType(**kw)

def create_households_type(id, name):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    return households_Type(**kw)

def create_ledger_journal(id, seqno, build_method, template, name, ref, trade_type, voucher_type, force_sequence, chart_id, account_id, printed_name, dc):
    kw = dict()
    kw.update(id=id)
    kw.update(seqno=seqno)
    kw.update(build_method=build_method)
    kw.update(template=template)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(ref=ref)
    kw.update(trade_type=trade_type)
    kw.update(voucher_type=voucher_type)
    kw.update(force_sequence=force_sequence)
    kw.update(chart_id=chart_id)
    kw.update(account_id=account_id)
    if printed_name is not None: kw.update(bv2kw('printed_name',printed_name))
    kw.update(dc=dc)
    return ledger_Journal(**kw)

def create_lists_listtype(id, name):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    return lists_ListType(**kw)

def create_lists_list(id, name, ref, list_type_id, remarks):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(ref=ref)
    kw.update(list_type_id=list_type_id)
    kw.update(remarks=remarks)
    return lists_List(**kw)

def create_products_productcat(id, name, description):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(description=description)
    return products_ProductCat(**kw)

def create_products_product(id, name, description, cat_id, vat_class, sales_account_id, sales_price, purchases_account_id):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    if description is not None: kw.update(bv2kw('description',description))
    kw.update(cat_id=cat_id)
    kw.update(vat_class=vat_class)
    kw.update(sales_account_id=sales_account_id)
    if sales_price is not None: sales_price = Decimal(sales_price)
    kw.update(sales_price=sales_price)
    kw.update(purchases_account_id=purchases_account_id)
    return products_Product(**kw)

def create_properties_propgroup(id, name):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    return properties_PropGroup(**kw)

def create_properties_proptype(id, name, choicelist, default_value, limit_to_choices, multiple_choices):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(choicelist=choicelist)
    kw.update(default_value=default_value)
    kw.update(limit_to_choices=limit_to_choices)
    kw.update(multiple_choices=multiple_choices)
    return properties_PropType(**kw)

def create_properties_propchoice(id, type_id, value, text):
    kw = dict()
    kw.update(id=id)
    kw.update(type_id=type_id)
    kw.update(value=value)
    if text is not None: kw.update(bv2kw('text',text))
    return properties_PropChoice(**kw)

def create_properties_property(id, name, group_id, type_id):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(group_id=group_id)
    kw.update(type_id=type_id)
    return properties_Property(**kw)

def create_sales_invoicingmode(id, build_method, template, name, price, advance_days):
    kw = dict()
    kw.update(id=id)
    kw.update(build_method=build_method)
    kw.update(template=template)
    if name is not None: kw.update(bv2kw('name',name))
    if price is not None: price = Decimal(price)
    kw.update(price=price)
    kw.update(advance_days=advance_days)
    return sales_InvoicingMode(**kw)

def create_sales_shippingmode(id, name, price):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    if price is not None: price = Decimal(price)
    kw.update(price=price)
    return sales_ShippingMode(**kw)

def create_tickets_projecttype(id, build_method, template, name):
    kw = dict()
    kw.update(id=id)
    kw.update(build_method=build_method)
    kw.update(template=template)
    if name is not None: kw.update(bv2kw('name',name))
    return tickets_ProjectType(**kw)

def create_tickets_sessiontype(id, name):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    return tickets_SessionType(**kw)

def create_uploads_uploadtype(id, name, upload_area, max_number, wanted):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(upload_area=upload_area)
    kw.update(max_number=max_number)
    kw.update(wanted=wanted)
    return uploads_UploadType(**kw)

def create_vat_paymentterm(id, name, days, months, end_of_month):
    kw = dict()
    kw.update(id=id)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(days=days)
    kw.update(months=months)
    kw.update(end_of_month=end_of_month)
    return vat_PaymentTerm(**kw)

def create_contacts_partner(id, modified, created, country_id, city_id, zip_code, region_id, addr1, street_prefix, street, street_no, street_box, addr2, name, language, email, url, phone, gsm, fax, remarks, isikukood, vat_regime, payment_term_id, iban, bic, invoice_recipient_id):
    kw = dict()
    kw.update(id=id)
    kw.update(modified=modified)
    kw.update(created=created)
    kw.update(country_id=country_id)
    kw.update(city_id=city_id)
    kw.update(zip_code=zip_code)
    kw.update(region_id=region_id)
    kw.update(addr1=addr1)
    kw.update(street_prefix=street_prefix)
    kw.update(street=street)
    kw.update(street_no=street_no)
    kw.update(street_box=street_box)
    kw.update(addr2=addr2)
    kw.update(name=name)
    kw.update(language=language)
    kw.update(email=email)
    kw.update(url=url)
    kw.update(phone=phone)
    kw.update(gsm=gsm)
    kw.update(fax=fax)
    kw.update(remarks=remarks)
    kw.update(isikukood=isikukood)
    kw.update(vat_regime=vat_regime)
    kw.update(payment_term_id=payment_term_id)
    kw.update(iban=iban)
    kw.update(bic=bic)
    kw.update(invoice_recipient_id=invoice_recipient_id)
    return contacts_Partner(**kw)

def create_addresses_address(id, country_id, city_id, zip_code, region_id, addr1, street_prefix, street, street_no, street_box, addr2, data_source, address_type, partner_id, remark, primary):
    kw = dict()
    kw.update(id=id)
    kw.update(country_id=country_id)
    kw.update(city_id=city_id)
    kw.update(zip_code=zip_code)
    kw.update(region_id=region_id)
    kw.update(addr1=addr1)
    kw.update(street_prefix=street_prefix)
    kw.update(street=street)
    kw.update(street_no=street_no)
    kw.update(street_box=street_box)
    kw.update(addr2=addr2)
    kw.update(data_source=data_source)
    kw.update(address_type=address_type)
    kw.update(partner_id=partner_id)
    kw.update(remark=remark)
    kw.update(primary=primary)
    return addresses_Address(**kw)

def create_contacts_company(partner_ptr_id, prefix, type_id, vat_id):
    return create_mti_child(contacts_Partner,partner_ptr_id,contacts_Company,prefix=prefix,type_id=type_id,vat_id=vat_id)
def create_contacts_person(partner_ptr_id, first_name, middle_name, last_name, gender, birth_date, title):
    return create_mti_child(contacts_Partner,partner_ptr_id,contacts_Person,first_name=first_name,middle_name=middle_name,last_name=last_name,gender=gender,birth_date=birth_date,title=title)
def create_contacts_role(id, type_id, person_id, company_id):
    kw = dict()
    kw.update(id=id)
    kw.update(type_id=type_id)
    kw.update(person_id=person_id)
    kw.update(company_id=company_id)
    return contacts_Role(**kw)

def create_households_household(partner_ptr_id, prefix, type_id):
    return create_mti_child(contacts_Partner,partner_ptr_id,households_Household,prefix=prefix,type_id=type_id)
def create_households_member(id, start_date, end_date, role, person_id, household_id, primary):
    kw = dict()
    kw.update(id=id)
    kw.update(start_date=start_date)
    kw.update(end_date=end_date)
    kw.update(role=role)
    kw.update(person_id=person_id)
    kw.update(household_id=household_id)
    kw.update(primary=primary)
    return households_Member(**kw)

def create_humanlinks_link(id, type, parent_id, child_id):
    kw = dict()
    kw.update(id=id)
    kw.update(type=type)
    kw.update(parent_id=parent_id)
    kw.update(child_id=child_id)
    return humanlinks_Link(**kw)

def create_lists_member(id, seqno, list_id, partner_id, remark):
    kw = dict()
    kw.update(id=id)
    kw.update(seqno=seqno)
    kw.update(list_id=list_id)
    kw.update(partner_id=partner_id)
    kw.update(remark=remark)
    return lists_Member(**kw)

def create_sepa_account(id, iban, bic, partner_id, remark, primary):
    kw = dict()
    kw.update(id=id)
    kw.update(iban=iban)
    kw.update(bic=bic)
    kw.update(partner_id=partner_id)
    kw.update(remark=remark)
    kw.update(primary=primary)
    return sepa_Account(**kw)

def create_system_siteconfig(id, default_build_method, next_partner_id, site_company_id, default_event_type_id, site_calendar_id, max_auto_events, clients_account_id, sales_vat_account_id, sales_account_id, suppliers_account_id, purchases_vat_account_id, purchases_account_id, wages_account_id, clearings_account_id):
    kw = dict()
    kw.update(id=id)
    kw.update(default_build_method=default_build_method)
    kw.update(next_partner_id=next_partner_id)
    kw.update(site_company_id=site_company_id)
    kw.update(default_event_type_id=default_event_type_id)
    kw.update(site_calendar_id=site_calendar_id)
    kw.update(max_auto_events=max_auto_events)
    kw.update(clients_account_id=clients_account_id)
    kw.update(sales_vat_account_id=sales_vat_account_id)
    kw.update(sales_account_id=sales_account_id)
    kw.update(suppliers_account_id=suppliers_account_id)
    kw.update(purchases_vat_account_id=purchases_vat_account_id)
    kw.update(purchases_account_id=purchases_account_id)
    kw.update(wages_account_id=wages_account_id)
    kw.update(clearings_account_id=clearings_account_id)
    return system_SiteConfig(**kw)

def create_users_user(id, modified, created, username, password, profile, initials, first_name, last_name, email, remarks, language, partner_id, access_class, event_type_id):
    kw = dict()
    kw.update(id=id)
    kw.update(modified=modified)
    kw.update(created=created)
    kw.update(username=username)
    kw.update(password=password)
    kw.update(profile=profile)
    kw.update(initials=initials)
    kw.update(first_name=first_name)
    kw.update(last_name=last_name)
    kw.update(email=email)
    kw.update(remarks=remarks)
    kw.update(language=language)
    kw.update(partner_id=partner_id)
    kw.update(access_class=access_class)
    kw.update(event_type_id=event_type_id)
    return users_User(**kw)

def create_cal_recurrentevent(id, user_id, name, start_date, start_time, end_date, end_time, every_unit, every, monday, tuesday, wednesday, thursday, friday, saturday, sunday, max_events, event_type_id, description):
    kw = dict()
    kw.update(id=id)
    kw.update(user_id=user_id)
    if name is not None: kw.update(bv2kw('name',name))
    kw.update(start_date=start_date)
    kw.update(start_time=start_time)
    kw.update(end_date=end_date)
    kw.update(end_time=end_time)
    kw.update(every_unit=every_unit)
    kw.update(every=every)
    kw.update(monday=monday)
    kw.update(tuesday=tuesday)
    kw.update(wednesday=wednesday)
    kw.update(thursday=thursday)
    kw.update(friday=friday)
    kw.update(saturday=saturday)
    kw.update(sunday=sunday)
    kw.update(max_events=max_events)
    kw.update(event_type_id=event_type_id)
    kw.update(description=description)
    return cal_RecurrentEvent(**kw)

def create_cal_subscription(id, user_id, calendar_id, is_hidden):
    kw = dict()
    kw.update(id=id)
    kw.update(user_id=user_id)
    kw.update(calendar_id=calendar_id)
    kw.update(is_hidden=is_hidden)
    return cal_Subscription(**kw)

def create_ledger_voucher(id, user_id, date, journal_id, year, number, narration):
    kw = dict()
    kw.update(id=id)
    kw.update(user_id=user_id)
    kw.update(date=date)
    kw.update(journal_id=journal_id)
    kw.update(year=year)
    kw.update(number=number)
    kw.update(narration=narration)
    return ledger_Voucher(**kw)

def create_finan_bankstatement(voucher_ptr_id, state, balance1, balance2):
    return create_mti_child(ledger_Voucher,voucher_ptr_id,finan_BankStatement,voucher_ptr_id=voucher_ptr_id,state=state,balance1=balance1,balance2=balance2)
def create_finan_bankstatementitem(id, seqno, match, title, amount, dc, remark, account_id, partner_id, voucher_id, date):
    kw = dict()
    kw.update(id=id)
    kw.update(seqno=seqno)
    kw.update(match=match)
    kw.update(title=title)
    if amount is not None: amount = Decimal(amount)
    kw.update(amount=amount)
    kw.update(dc=dc)
    kw.update(remark=remark)
    kw.update(account_id=account_id)
    kw.update(partner_id=partner_id)
    kw.update(voucher_id=voucher_id)
    kw.update(date=date)
    return finan_BankStatementItem(**kw)

def create_finan_journalentry(voucher_ptr_id, state):
    return create_mti_child(ledger_Voucher,voucher_ptr_id,finan_JournalEntry,voucher_ptr_id=voucher_ptr_id,state=state)
def create_finan_journalentryitem(id, seqno, match, title, amount, dc, remark, account_id, partner_id, voucher_id, date):
    kw = dict()
    kw.update(id=id)
    kw.update(seqno=seqno)
    kw.update(match=match)
    kw.update(title=title)
    if amount is not None: amount = Decimal(amount)
    kw.update(amount=amount)
    kw.update(dc=dc)
    kw.update(remark=remark)
    kw.update(account_id=account_id)
    kw.update(partner_id=partner_id)
    kw.update(voucher_id=voucher_id)
    kw.update(date=date)
    return finan_JournalEntryItem(**kw)

def create_finan_paymentorder(voucher_ptr_id, state, total, execution_date):
    return create_mti_child(ledger_Voucher,voucher_ptr_id,finan_PaymentOrder,voucher_ptr_id=voucher_ptr_id,state=state,total=total,execution_date=execution_date)
def create_finan_paymentorderitem(id, seqno, match, title, amount, dc, remark, account_id, partner_id, voucher_id):
    kw = dict()
    kw.update(id=id)
    kw.update(seqno=seqno)
    kw.update(match=match)
    kw.update(title=title)
    if amount is not None: amount = Decimal(amount)
    kw.update(amount=amount)
    kw.update(dc=dc)
    kw.update(remark=remark)
    kw.update(account_id=account_id)
    kw.update(partner_id=partner_id)
    kw.update(voucher_id=voucher_id)
    return finan_PaymentOrderItem(**kw)

def create_ledger_accountinvoice(voucher_ptr_id, total_incl, total_base, total_vat, partner_id, vat_regime, payment_term_id, match, your_ref, due_date, state):
    return create_mti_child(ledger_Voucher,voucher_ptr_id,ledger_AccountInvoice,total_incl=total_incl,total_base=total_base,total_vat=total_vat,partner_id=partner_id,vat_regime=vat_regime,payment_term_id=payment_term_id,match=match,your_ref=your_ref,due_date=due_date,state=state)
def create_ledger_invoiceitem(id, seqno, total_incl, total_base, total_vat, vat_class, title, voucher_id, account_id):
    kw = dict()
    kw.update(id=id)
    kw.update(seqno=seqno)
    if total_incl is not None: total_incl = Decimal(total_incl)
    kw.update(total_incl=total_incl)
    if total_base is not None: total_base = Decimal(total_base)
    kw.update(total_base=total_base)
    if total_vat is not None: total_vat = Decimal(total_vat)
    kw.update(total_vat=total_vat)
    kw.update(vat_class=vat_class)
    kw.update(title=title)
    kw.update(voucher_id=voucher_id)
    kw.update(account_id=account_id)
    return ledger_InvoiceItem(**kw)

def create_ledger_movement(id, voucher_id, seqno, account_id, partner_id, amount, dc, match, satisfied):
    kw = dict()
    kw.update(id=id)
    kw.update(voucher_id=voucher_id)
    kw.update(seqno=seqno)
    kw.update(account_id=account_id)
    kw.update(partner_id=partner_id)
    if amount is not None: amount = Decimal(amount)
    kw.update(amount=amount)
    kw.update(dc=dc)
    kw.update(match=match)
    kw.update(satisfied=satisfied)
    return ledger_Movement(**kw)

def create_system_textfieldtemplate(id, user_id, name, description, text):
    kw = dict()
    kw.update(id=id)
    kw.update(user_id=user_id)
    kw.update(name=name)
    kw.update(description=description)
    kw.update(text=text)
    return system_TextFieldTemplate(**kw)

def create_tickets_project(id, user_id, ref, name, parent_id, type_id, description, srcref_url_template, changeset_url_template):
    kw = dict()
    kw.update(id=id)
    kw.update(user_id=user_id)
    kw.update(ref=ref)
    kw.update(name=name)
    kw.update(parent_id=parent_id)
    kw.update(type_id=type_id)
    kw.update(description=description)
    kw.update(srcref_url_template=srcref_url_template)
    kw.update(changeset_url_template=changeset_url_template)
    return tickets_Project(**kw)

def create_cal_event(id, user_id, modified, created, project_id, build_time, build_method, owner_type_id, owner_id, start_date, start_time, end_date, end_time, summary, description, access_class, sequence, auto_type, event_type_id, transparent, room_id, priority_id, state, assigned_to_id):
    kw = dict()
    kw.update(id=id)
    kw.update(user_id=user_id)
    kw.update(modified=modified)
    kw.update(created=created)
    kw.update(project_id=project_id)
    kw.update(build_time=build_time)
    kw.update(build_method=build_method)
    owner_type_id = new_content_type_id(owner_type_id)
    kw.update(owner_type_id=owner_type_id)
    kw.update(owner_id=owner_id)
    kw.update(start_date=start_date)
    kw.update(start_time=start_time)
    kw.update(end_date=end_date)
    kw.update(end_time=end_time)
    kw.update(summary=summary)
    kw.update(description=description)
    kw.update(access_class=access_class)
    kw.update(sequence=sequence)
    kw.update(auto_type=auto_type)
    kw.update(event_type_id=event_type_id)
    kw.update(transparent=transparent)
    kw.update(room_id=room_id)
    kw.update(priority_id=priority_id)
    kw.update(state=state)
    kw.update(assigned_to_id=assigned_to_id)
    return cal_Event(**kw)

def create_cal_guest(id, event_id, partner_id, role_id, state, remark):
    kw = dict()
    kw.update(id=id)
    kw.update(event_id=event_id)
    kw.update(partner_id=partner_id)
    kw.update(role_id=role_id)
    kw.update(state=state)
    kw.update(remark=remark)
    return cal_Guest(**kw)

def create_cal_task(id, user_id, modified, created, project_id, owner_type_id, owner_id, start_date, start_time, summary, description, access_class, sequence, auto_type, due_date, due_time, percent, state):
    kw = dict()
    kw.update(id=id)
    kw.update(user_id=user_id)
    kw.update(modified=modified)
    kw.update(created=created)
    kw.update(project_id=project_id)
    owner_type_id = new_content_type_id(owner_type_id)
    kw.update(owner_type_id=owner_type_id)
    kw.update(owner_id=owner_id)
    kw.update(start_date=start_date)
    kw.update(start_time=start_time)
    kw.update(summary=summary)
    kw.update(description=description)
    kw.update(access_class=access_class)
    kw.update(sequence=sequence)
    kw.update(auto_type=auto_type)
    kw.update(due_date=due_date)
    kw.update(due_time=due_time)
    kw.update(percent=percent)
    kw.update(state=state)
    return cal_Task(**kw)

def create_excerpts_excerpt(id, user_id, project_id, build_time, build_method, owner_type_id, owner_id, company_id, contact_person_id, contact_role_id, excerpt_type_id, language):
    kw = dict()
    kw.update(id=id)
    kw.update(user_id=user_id)
    kw.update(project_id=project_id)
    kw.update(build_time=build_time)
    kw.update(build_method=build_method)
    owner_type_id = new_content_type_id(owner_type_id)
    kw.update(owner_type_id=owner_type_id)
    kw.update(owner_id=owner_id)
    kw.update(company_id=company_id)
    kw.update(contact_person_id=contact_person_id)
    kw.update(contact_role_id=contact_role_id)
    kw.update(excerpt_type_id=excerpt_type_id)
    kw.update(language=language)
    return excerpts_Excerpt(**kw)

def create_outbox_mail(id, user_id, project_id, owner_type_id, owner_id, date, subject, body, sent):
    kw = dict()
    kw.update(id=id)
    kw.update(user_id=user_id)
    kw.update(project_id=project_id)
    owner_type_id = new_content_type_id(owner_type_id)
    kw.update(owner_type_id=owner_type_id)
    kw.update(owner_id=owner_id)
    kw.update(date=date)
    kw.update(subject=subject)
    kw.update(body=body)
    kw.update(sent=sent)
    return outbox_Mail(**kw)

def create_outbox_attachment(id, owner_type_id, owner_id, mail_id):
    kw = dict()
    kw.update(id=id)
    owner_type_id = new_content_type_id(owner_type_id)
    kw.update(owner_type_id=owner_type_id)
    kw.update(owner_id=owner_id)
    kw.update(mail_id=mail_id)
    return outbox_Attachment(**kw)

def create_outbox_recipient(id, mail_id, partner_id, type, address, name):
    kw = dict()
    kw.update(id=id)
    kw.update(mail_id=mail_id)
    kw.update(partner_id=partner_id)
    kw.update(type=type)
    kw.update(address=address)
    kw.update(name=name)
    return outbox_Recipient(**kw)

def create_sales_invoice(voucher_ptr_id, total_incl, total_base, total_vat, partner_id, vat_regime, payment_term_id, match, printed_by_id, language, your_ref, shipping_mode_id, subject, intro, discount, due_date, state):
    return create_mti_child(ledger_Voucher,voucher_ptr_id,sales_Invoice,voucher_ptr_id=voucher_ptr_id,total_incl=total_incl,total_base=total_base,total_vat=total_vat,partner_id=partner_id,vat_regime=vat_regime,payment_term_id=payment_term_id,match=match,printed_by_id=printed_by_id,language=language,your_ref=your_ref,shipping_mode_id=shipping_mode_id,subject=subject,intro=intro,discount=discount,due_date=due_date,state=state)
def create_sales_invoiceitem(id, seqno, total_incl, total_base, total_vat, vat_class, unit_price, qty, title, product_id, description, discount, voucher_id, invoiceable_type_id, invoiceable_id):
    kw = dict()
    kw.update(id=id)
    kw.update(seqno=seqno)
    if total_incl is not None: total_incl = Decimal(total_incl)
    kw.update(total_incl=total_incl)
    if total_base is not None: total_base = Decimal(total_base)
    kw.update(total_base=total_base)
    if total_vat is not None: total_vat = Decimal(total_vat)
    kw.update(total_vat=total_vat)
    kw.update(vat_class=vat_class)
    if unit_price is not None: unit_price = Decimal(unit_price)
    kw.update(unit_price=unit_price)
    kw.update(qty=qty)
    kw.update(title=title)
    kw.update(product_id=product_id)
    kw.update(description=description)
    if discount is not None: discount = Decimal(discount)
    kw.update(discount=discount)
    kw.update(voucher_id=voucher_id)
    invoiceable_type_id = new_content_type_id(invoiceable_type_id)
    kw.update(invoiceable_type_id=invoiceable_type_id)
    kw.update(invoiceable_id=invoiceable_id)
    return sales_InvoiceItem(**kw)

def create_tickets_milestone(id, ref, project_id, expected, reached):
    kw = dict()
    kw.update(id=id)
    kw.update(ref=ref)
    kw.update(project_id=project_id)
    kw.update(expected=expected)
    kw.update(reached=reached)
    return tickets_Milestone(**kw)

def create_tickets_ticket(id, user_id, modified, created, reported_for_id, fixed_for_id, assigned_to_id, project_id, summary, state, closed, description):
    kw = dict()
    kw.update(id=id)
    kw.update(user_id=user_id)
    kw.update(modified=modified)
    kw.update(created=created)
    kw.update(reported_for_id=reported_for_id)
    kw.update(fixed_for_id=fixed_for_id)
    kw.update(assigned_to_id=assigned_to_id)
    kw.update(project_id=project_id)
    kw.update(summary=summary)
    kw.update(state=state)
    kw.update(closed=closed)
    kw.update(description=description)
    return tickets_Ticket(**kw)

def create_blogs_entry(id, user_id, modified, created, build_time, build_method, owner_type_id, owner_id, language, type_id, title, body, ticket_id):
    kw = dict()
    kw.update(id=id)
    kw.update(user_id=user_id)
    kw.update(modified=modified)
    kw.update(created=created)
    kw.update(build_time=build_time)
    kw.update(build_method=build_method)
    owner_type_id = new_content_type_id(owner_type_id)
    kw.update(owner_type_id=owner_type_id)
    kw.update(owner_id=owner_id)
    kw.update(language=language)
    kw.update(type_id=type_id)
    kw.update(title=title)
    kw.update(body=body)
    kw.update(ticket_id=ticket_id)
    return blogs_Entry(**kw)

def create_tickets_dependency(id, parent_id, child_id, dependency_type):
    kw = dict()
    kw.update(id=id)
    kw.update(parent_id=parent_id)
    kw.update(child_id=child_id)
    kw.update(dependency_type=dependency_type)
    return tickets_Dependency(**kw)

def create_tickets_session(id, user_id, ticket_id, summary, description, date, start_time, end_time, break_time, time, is_private):
    kw = dict()
    kw.update(id=id)
    kw.update(user_id=user_id)
    kw.update(ticket_id=ticket_id)
    kw.update(summary=summary)
    kw.update(description=description)
    kw.update(date=date)
    kw.update(start_time=start_time)
    kw.update(end_time=end_time)
    kw.update(break_time=break_time)
    kw.update(time=time)
    kw.update(is_private=is_private)
    return tickets_Session(**kw)

def create_tickets_vote(id, ticket_id, partner_id, remark):
    kw = dict()
    kw.update(id=id)
    kw.update(ticket_id=ticket_id)
    kw.update(partner_id=partner_id)
    kw.update(remark=remark)
    return tickets_Vote(**kw)

def create_uploads_upload(id, user_id, file, mimetype, owner_type_id, owner_id, upload_area, type_id, description):
    kw = dict()
    kw.update(id=id)
    kw.update(user_id=user_id)
    kw.update(file=file)
    kw.update(mimetype=mimetype)
    owner_type_id = new_content_type_id(owner_type_id)
    kw.update(owner_type_id=owner_type_id)
    kw.update(owner_id=owner_id)
    kw.update(upload_area=upload_area)
    kw.update(type_id=type_id)
    kw.update(description=description)
    return uploads_Upload(**kw)

def create_users_authority(id, user_id, authorized_id):
    kw = dict()
    kw.update(id=id)
    kw.update(user_id=user_id)
    kw.update(authorized_id=authorized_id)
    return users_Authority(**kw)




def main():
    loader = DpyLoader(globals())
    from django.core.management import call_command
    # call_command('initdb', interactive=False)
    call_command('initdb')
    os.chdir(os.path.dirname(__file__))
    loader.initialize()

    execfile("accounts_chart.py")
    execfile("accounts_group.py")
    execfile("accounts_account.py")
    execfile("blogs_entrytype.py")
    execfile("cal_calendar.py")
    execfile("cal_eventtype.py")
    execfile("cal_guestrole.py")
    execfile("cal_priority.py")
    execfile("cal_remotecalendar.py")
    execfile("cal_room.py")
    execfile("contacts_companytype.py")
    execfile("contacts_roletype.py")
    execfile("contenttypes_helptext.py")
    execfile("countries_country.py")
    execfile("countries_place.py")
    execfile("excerpts_excerpttype.py")
    execfile("households_type.py")
    execfile("ledger_journal.py")
    execfile("lists_listtype.py")
    execfile("lists_list.py")
    execfile("products_productcat.py")
    execfile("products_product.py")
    execfile("properties_propgroup.py")
    execfile("properties_proptype.py")
    execfile("properties_propchoice.py")
    execfile("properties_property.py")
    execfile("sales_invoicingmode.py")
    execfile("sales_shippingmode.py")
    execfile("tickets_projecttype.py")
    execfile("tickets_sessiontype.py")
    execfile("uploads_uploadtype.py")
    execfile("vat_paymentterm.py")
    execfile("contacts_partner.py")
    execfile("addresses_address.py")
    execfile("contacts_company.py")
    execfile("contacts_person.py")
    execfile("contacts_role.py")
    execfile("households_household.py")
    execfile("households_member.py")
    execfile("humanlinks_link.py")
    execfile("lists_member.py")
    execfile("sepa_account.py")
    execfile("system_siteconfig.py")
    execfile("users_user.py")
    execfile("cal_recurrentevent.py")
    execfile("cal_subscription.py")
    execfile("ledger_voucher.py")
    execfile("finan_bankstatement.py")
    execfile("finan_bankstatementitem.py")
    execfile("finan_journalentry.py")
    execfile("finan_journalentryitem.py")
    execfile("finan_paymentorder.py")
    execfile("finan_paymentorderitem.py")
    execfile("ledger_accountinvoice.py")
    execfile("ledger_invoiceitem.py")
    execfile("ledger_movement.py")
    execfile("system_textfieldtemplate.py")
    execfile("tickets_project.py")
    execfile("cal_event.py")
    execfile("cal_guest.py")
    execfile("cal_task.py")
    execfile("excerpts_excerpt.py")
    execfile("outbox_mail.py")
    execfile("outbox_attachment.py")
    execfile("outbox_recipient.py")
    execfile("sales_invoice.py")
    execfile("sales_invoiceitem.py")
    execfile("tickets_milestone.py")
    execfile("tickets_ticket.py")
    execfile("blogs_entry.py")
    execfile("tickets_dependency.py")
    execfile("tickets_session.py")
    execfile("tickets_vote.py")
    execfile("uploads_upload.py")
    execfile("users_authority.py")
    loader.finalize()

if __name__ == '__main__':
    main()
