/*
 Copyright 2009-2014 Luc Saffre
 License: BSD (see file COPYING for details)
*/

// lino.js --- generated Mon Dec 15 04:46:53 2014 by Lino version 1.6.16.
Ext.BLANK_IMAGE_URL = '/media/extjs/resources/images/default/s.gif';
LANGUAGE_CHOICES = [ [ "en", "Englisch" ], [ "de", "Deutsch" ] ];
MEDIA_URL = "/media";

// hack to add a toCamel function, inspired by
// http://jamesroberts.name/blog/2010/02/22/string-functions-for-javascript-trim-to-camel-case-to-dashed-and-to-underscore/
String.prototype.toCamel = function(){
  //~ return this.replace(/(\-[a-z])/g, function($1){return $1.toUpperCase().replace('-','');});
  //~ return this;
  return this.replace(/([A-Z])([A-Z]+)/g, function(match,p1,p2,offset,string){
      //~ console.log("20131005 got ",arguments);
      return p1 + p2.toLowerCase();});
};



/* MonthPickerPlugin: thanks to keypoint @ sencha forum
   http://www.sencha.com/forum/showthread.php?74002-3.x-Ext.ux.MonthMenu&p=356860#post356860
*/
Ext.namespace('Ext.ux'); 

Ext.ux.MonthPickerPlugin = function() { 
    var picker; 
    var oldDateDefaults; 

    this.init = function(pk) { 
        picker = pk; 
        picker.onTriggerClick = picker.onTriggerClick.createSequence(onClick); 
        picker.getValue = picker.getValue.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
        picker.beforeBlur = picker.beforeBlur.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
    }; 

    function setDefaultMonthDay() { 
        oldDateDefaults = Date.defaults.d; 
        Date.defaults.d = 1; 
        return true; 
    } 

    function restoreDefaultMonthDay(ret) { 
        Date.defaults.d = oldDateDefaults; 
        return ret; 
    } 

    function onClick(e, el, opt) { 
        var p = picker.menu.picker; 
        p.activeDate = p.activeDate.getFirstDateOfMonth(); 
        if (p.value) { 
            p.value = p.value.getFirstDateOfMonth(); 
        } 

        p.showMonthPicker(); 
         
        if (!p.disabled) { 
            p.monthPicker.stopFx(); 
            p.monthPicker.show(); 

            p.mun(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mun(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
            p.onMonthClick = p.onMonthClick.createSequence(pickerClick); 
            p.onMonthDblClick = p.onMonthDblClick.createSequence(pickerDblclick); 
            p.mon(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mon(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
        } 
    } 

    function pickerClick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.is('button.x-date-mp-cancel')) { 
            picker.menu.hide(); 
        } else if(el.is('button.x-date-mp-ok')) { 
            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 

    function pickerDblclick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.parent() 
            && (el.parent().is('td.x-date-mp-month') 
            || el.parent().is('td.x-date-mp-year'))) { 

            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 
}; 

Ext.preg('monthPickerPlugin', Ext.ux.MonthPickerPlugin);  


/**
JC Watsons solution (adapted to ExtJS 3.3.1 by LS) is elegant and simple:
`A "fix" for unchecked checkbox submission  behaviour
<http://www.sencha.com/forum/showthread.php?28449>`_

Added special handling for checkbox inputs. 
ExtJS defines disabled checkboxes `readonly`, not `disabled` as for other inputs.

*/
Ext.lib.Ajax.serializeForm = function(form) {
    //~ console.log('20120203 linolib.js serializeForm',form);
    var fElements = form.elements || (document.forms[form] || Ext.getDom(form)).elements, 
        hasSubmit = false, 
        encoder = encodeURIComponent, 
        name, 
        data = '', 
        type, 
        hasValue;

    Ext.each(fElements, function(element){
        name = element.name;
        type = element.type;

        if (!element.disabled && name && !(type == 'checkbox' && element.readonly)) {
            if (/select-(one|multiple)/i.test(type)) {
                Ext.each(element.options, function(opt){
                    if (opt.selected) {
                        hasValue = opt.hasAttribute ? opt.hasAttribute('value') : opt.getAttributeNode('value').specified;
                        data += String.format("{0}={1}&", encoder(name), encoder(hasValue ? opt.value : opt.text));
                    }
                });
            } else if (!(/file|undefined|reset|button/i.test(type))) {
                //~ if (!(/radio|checkbox/i.test(type) && !element.checked) && !(type == 'submit' && hasSubmit)) {
                if (!(type == 'submit' && hasSubmit)) {
                    if (type == 'checkbox') {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&');
                        data += encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&';
                    } else {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + encoder(element.value) + '&');
                        data += encoder(name) + '=' + encoder(element.value) + '&';
                    }
                    hasSubmit = /submit/i.test(type);
                }
            }
        //~ } else {
            //~ console.log(name,type,element.readonly);
        }
    });
    return data.substr(0, data.length - 1);
};



/*
Set a long timeout of fifteen minutes. 
See /blog/2012/0307
*/
Ext.Ajax.timeout = 15 * 60 * 1000; 

/*
 * Thanks to 
 * `huuze <http://stackoverflow.com/users/10040/huuuze>`_ for the question
 * and to 
 * `chrisv <http://stackoverflow.com/users/683808/chrisv>`_
 * for the answer on
 * http://stackoverflow.com/questions/3764589/how-do-i-include-django-1-2s-csrf-token-in-a-javascript-generated-html-form/5485616#5485616
 * 
 * */
 
Ext.Ajax.on('beforerequest', function (conn, options) {
   if (!(/^http:.*/.test(options.url) || /^https:.*/.test(options.url))) {
     if (typeof(options.headers) == "undefined") {
       options.headers = {'X-CSRFToken': Ext.util.Cookies.get('csrftoken')};
     } else {
       options.headers.extend({'X-CSRFToken': Ext.util.Cookies.get('csrftoken')});
     }                        
   }
}, this);


/*
My fix for the "Cannot set QuickTips dismissDelay to 0" bug,
see http://www.sencha.com/forum/showthread.php?183515 
*/
Ext.override(Ext.QuickTip,{
  showAt : function(xy){
        var t = this.activeTarget;
        //~ console.log("20120224 QuickTip.showAt",this.title,this.dismissDelay,t.dismissDelay);
        if(t){
            if(!this.rendered){
                this.render(Ext.getBody());
                this.activeTarget = t;
            }
            if(t.width){
                this.setWidth(t.width);
                this.body.setWidth(this.adjustBodyWidth(t.width - this.getFrameWidth()));
                this.measureWidth = false;
            } else{
                this.measureWidth = true;
            }
            this.setTitle(t.title || '');
            this.body.update(t.text);
            this.autoHide = t.autoHide;
            // bugfix by Luc 20120226
            if (t.dismissDelay != undefined) this.dismissDelay = t.dismissDelay;
            //~ this.dismissDelay = t.dismissDelay || this.dismissDelay;
            if(this.lastCls){
                this.el.removeClass(this.lastCls);
                delete this.lastCls;
            }
            if(t.cls){
                this.el.addClass(t.cls);
                this.lastCls = t.cls;
            }
            if(this.anchor){
                this.constrainPosition = false;
            }else if(t.align){ 
                xy = this.el.getAlignToXY(t.el, t.align);
                this.constrainPosition = false;
            }else{
                this.constrainPosition = true;
            }
        }
        Ext.QuickTip.superclass.showAt.call(this, xy);
    }
});

/*
Another hack. See /docs/blog/2012/0228
*/
Ext.Element.addMethods(
    function() {
        var VISIBILITY      = "visibility",
            DISPLAY         = "display",
            HIDDEN          = "hidden",
            NONE            = "none",
            XMASKED         = "x-masked",
            XMASKEDRELATIVE = "x-masked-relative",
            data            = Ext.Element.data;

        return {
            
            mask : function(msg, msgCls) {
                var me  = this,
                    dom = me.dom,
                    dh  = Ext.DomHelper,
                    EXTELMASKMSG = "ext-el-mask-msg",
                    el,
                    mask;
                // removed the following lines. See /docs/blog/2012/0228
                //~ if (!(/^body/i.test(dom.tagName) && me.getStyle('position') == 'static')) {
                    //~ console.log(20120228,dom.tagName,me);
                    //~ me.addClass(XMASKEDRELATIVE); 
                //~ }
                if (el = data(dom, 'maskMsg')) {
                    el.remove();
                }
                if (el = data(dom, 'mask')) {
                    el.remove();
                }

                mask = dh.append(dom, {cls : "ext-el-mask"}, true);
                data(dom, 'mask', mask);

                me.addClass(XMASKED);
                mask.setDisplayed(true);
                
                if (typeof msg == 'string') {
                    var mm = dh.append(dom, {cls : EXTELMASKMSG, cn:{tag:'div'}}, true);
                    data(dom, 'maskMsg', mm);
                    mm.dom.className = msgCls ? EXTELMASKMSG + " " + msgCls : EXTELMASKMSG;
                    mm.dom.firstChild.innerHTML = msg;
                    mm.setDisplayed(true);
                    mm.center(me);
                }
                
                
                if (Ext.isIE && !(Ext.isIE7 && Ext.isStrict) && me.getStyle('height') == 'auto') {
                    mask.setSize(undefined, me.getHeight());
                }
                
                return mask;
            }

            
        };
    }()
);



Ext.namespace('Lino');
    
    

//~ Lino.subst_user_field = new Ext.form.ComboBox({});
//~ Lino.subst_user = null;
Lino.insert_subst_user = function(p){
    //~ console.log('20120714 insert_subst_user',Lino.subst_user,p);
    //~ if (Lino.subst_user_field.getValue()) {
    if (p.su) return;
    if (Lino.subst_user) {
        //~ p.su = Lino.subst_user_field.getValue();
        p.su = Lino.subst_user;
    //~ } else {
        //~ delete p.su;
    }
    //~ console.log('20120714 insert_subst_user -->',Lino.subst_user,p);
}

Lino.login_window = null;

Lino.autorefresh = function() {
  if (Lino.current_window == null) {
      Lino.viewport.refresh();
      Lino.autorefresh.defer(10000);
  }
}

Lino.show_login_window = function(on_login) {
  //~ console.log('20121103 show_login_window',arguments);
  //~ var current_window = Lino.current_window;
  if (Lino.login_window == null) {
    
      function do_login() { 
            Lino.viewport.loadMask.show()
            login_panel.getForm().submit({ 
                method:'POST', 
                waitTitle:'Connecting', 
                waitMsg:'Sending data...',
                success:function(){ 
                  Lino.login_window.hide();
                  Lino.handle_home_button();
                  Lino.viewport.loadMask.hide();
                  if (typeof on_login == 'string') {
                      Lino.load_url(on_login);
                  } 
                },
                failure: function(form,action) { 
                  Lino.on_submit_failure(form, action);
                  Lino.viewport.loadMask.hide()
                }
            }); 
      };
    
      var login_button = new Ext.Button({ 
        text:"Anmelden",
        formBind: true,	 
        // Function that fires when user clicks the button 
        handler: do_login});
    
      var login_panel = new Ext.FormPanel({ 
        //~ inspired by http://www.sencha.com/learn/a-basic-login/
        autoHeight:true,
        labelWidth:90,
        url:'/auth', 
        frame:true, 
        defaultType:'textfield',
        monitorValid:true,
        items:[{ 
            fieldLabel:"Benutzername", 
            id: 'username',
            name:'username', 
            autoHeight:true,
            allowBlank:false 
        },{ 
            fieldLabel:"Passwort", 
            name:'password', 
            inputType:'password', 
            autoHeight:true,
            allowBlank:false 
        }],        
        buttons:[ login_button ]});
        
      Lino.login_window = new Ext.Window({
          layout:'fit',
          defaultButton: 'username',
          width:300,
          title:"Anmelden", 
          autoHeight:true,
          modal: true,
          closeAction: "hide",
          keys: {
            key: Ext.EventObject.ENTER,
            fn: function() { do_login()}
          },
          items: [login_panel] });
  };
  Lino.login_window.show();
};

Lino.logout = function(id,name) {
    Lino.call_ajax_action(
        Lino.viewport, 'GET', 
        '/auth',
        {}, 'logout', undefined, undefined,
        function(){Lino.reload();})
}

Lino.set_subst_user = function(id, name) {
    //~ console.log(20130723,'Lino.set_subst_user',id,name,Lino.current_window,Lino.viewport);
    Lino.subst_user = id;
    if (Lino.current_window) 
        Lino.current_window.main_item.set_base_param("su",id);
    if (Lino.viewport) 
        Lino.permalink_handler(Lino.current_window)();
}



//~ Lino.select_subst_user = function(cmp,rec,value){
    //~ Lino.subst_user=value;
    //~ console.log(20120713,rec);
//~ }
    
Lino.current_window = null;
Lino.window_history = Array();
    
Lino.chars2width = function(cols) {  return cols * 9; }
Lino.rows2height = function(cols) {  return cols * 20; }



Lino.MainPanel = {
  is_home_page : false,
  setting_param_values : false,
  config_containing_window : function(wincfg) { }
  ,init_containing_window : function(win) { }
  ,is_loading : function() { 
      if (!this.rendered) return true;
      //~ return (Ext.select('.x-loading-msg').elements.length > 0);
      return true; 
    } 
  ,do_when_clean : function(auto_save,todo) { todo() }
  ,get_master_params : function() {
    var p = {}
    p['mt'] = this.content_type; 
    rec = this.get_current_record()
    if (rec) {
      if (rec.phantom) {
          p['mk'] = undefined; 
      }else{
          p['mk'] = rec.id; 
      }
    } else {
      p['mk'] = undefined;
    }
    //~ console.log('get_master_params returns',p,'using record',rec);
    return p;
  }
  ,get_permalink : function() {
    var p = Ext.apply({}, this.get_base_params());
    delete p.fmt;
    Ext.apply(p, this.get_permalink_params());
    
    if (this.toggle_params_panel_btn) {
        p.sp = this.toggle_params_panel_btn.pressed;
        //~ if (this.toggle_params_panel_btn.pressed == this.params_panel_hidden) {
          //~ p.sp = true;
        //~ }
    }
    
    //~ Lino.insert_subst_user(p);
     //~ p.fmt = 'html';
    //~ console.log('get_permalink',p,this.get_permalink_params());
    if (this.is_home_page)
        //~ var url = '';
        var url = '/';
    else 
        var url = this.get_permalink_url();
    if (p.su == null) 
        delete p.su;
    if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
    return url;
  }
  ,get_record_url : function(record_id) {
      var url = '/api' + this.ls_url
      //~ var url = this.containing_window.config.url_data; // ls_url;
      url += '/' + (record_id === undefined ? '-99999' : String(record_id));
      //~ if (record_id !== undefined) url += '/' + String(record_id);
      //~ url += '/' + String(record_id);
      return url;
  }
  ,get_permalink_url : function() {
      return '/api' + this.ls_url;
  }
  ,get_permalink_params : function() {
      //~ return {an:'grid'};
      var p = {};
      if (this.action_name)
          p.an = this.action_name;
      this.add_param_values(p,false)
      return p;
  }
  /*

  Lino.MainPanel.set_status() : the status can have the following keys:

  - field_values
  - param_values
  - base_params
  - record_id
  - active_tab
  - data_record
  - show_params_panel
  - current_page

   */
  ,set_status : function(status, requesting_panel) {}
  ,get_status : function() { return {}}
  ,refresh : function() {}
  ,get_base_params : function() {  // Lino.MainPanel
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,add_params_panel : function (tbar) {
      if (this.params_panel) {
        //~  20130923b
        //~ this.params_panel.autoHeight = true; // 20130924
        var t = this;
        var update = function() {
            var p = t.params_panel;
            //~ console.log("update", p.getSize().height,p.forceLayout,p.autoHeight);
            var w = t.get_containing_window();
            Lino.do_when_visible(w, function() {
                //~ p.doLayout(true); // doLayout(shallow, force)
                w.doLayout(true); // doLayout(shallow, force)
                //~ t.params_panel.on('afterlayout',update,t,{single:true});
            });
        };
        Lino.do_when_visible(this.params_panel, update);
        this.params_panel.on('show',update);
        this.params_panel.on('hide',update);
        //~ this.params_panel.on('bodyresize',update);
        this.params_panel.on('afterlayout',update);
        //~ this.params_panel.on('afterlayout',update,this,{single:true});
        //~ this.params_panel.on('bodyresize',update,this,{single:true});
        //~ this.params_panel.on('resize',update,this,{single:true});
        //~ this.params_panel.on('render',update,this,{single:true});
        
        // this.params_panel.on('render',
        //~ this.params_panel.on('afterlayout',update,this,{single:true,delay:200});
        //~ this.params_panel.on('bodyresize',update,this,{single:true,delay:200});
        this.toggle_params_panel_btn = new Ext.Button({ scope:this, 
          //~ text: "$_("[parameters]")", // gear
          iconCls: 'x-tbar-parameters',
          tooltip:"Parameter-Panel ein- bzw. ausblenden",
          enableToggle: true,
          //~ pressed: ! this.params_panel.hidden,
          pressed: ! this.params_panel_hidden,
          toggleHandler: function(btn,state) { 
            //~ console.log("20120210 add_params_panel",state,this.params_panel);
            if (state) {
                this.params_panel.show();
            } else {
                this.params_panel.hide();
            }
            //~ this.params_panel.on('afterlayout',update,this,{single:true});
            //~ t.get_containing_window().doLayout();
            //~ this.params_panel.on('afterlayout',function() {
                //~ console.log("20130918 afterlayout");
                //~ t.get_containing_window().doLayout(); // doLayout(shallow, force)
            //~ },this,{single:true});
          }
        }); 
        tbar = tbar.concat([this.toggle_params_panel_btn]);
        var refresh = function() {
            if (!t.setting_param_values) {
                t._force_dirty = true; 
                t.refresh();
            }
        }
        Ext.each(this.params_panel.fields,function(f) {
          //~ f.on('valid',function() {t.refresh()});
          if (f instanceof Ext.form.Checkbox) {
              f.on('check',refresh);
          } else if (f instanceof Ext.DatePicker) {
              f.on('select',refresh);
          } else if (f instanceof Ext.form.TriggerField) {
              f.on('select',refresh);
              //~ f.on('change',refresh);
              //~ f.on('valid',refresh);
          } else {
              if (! f.on) 
                  console.log("20121010 no method 'on'",f);
              else
                  f.on('change',refresh);
            }
          });
      }
      return tbar;
  }
  ,add_param_values : function (p,force_dirty) {
    if (this.params_panel) {
      /* 
      * 20120918 add param_values to the request string 
      * *only if the params_form is dirty*.
      * Otherwise Actor.default_params() would never be used.
      *
      * 20121023 But IntegClients.params_default has non-empty default values. 
      * Users must have the possibility to make them empty.
      * 
      * 20130605 : added `force_dirty` parameter because Checkbox fields don't 
      * mark their form as dirty when check is fired.
      * 
      * 20130721 : `force_dirty` not as a parameter but as 
      * `this._force_dirty` because
      * 
      * 20130915 : both _force_dirty and force_dirty parameter are needed.
      * 
      */
      if (force_dirty || this._force_dirty || this.params_panel.form.isDirty()) {
      //~ if (this._force_dirty || this.params_panel.form.isDirty()) {
        p.pv = this.get_param_values();
        //~ console.log("20130923 form is dirty (",force_dirty,this._force_dirty,this.params_panel.form.isDirty(),")");
        //~ console.log("20130923 form is dirty",p);
      }else{
        //~ console.log("20130923 form not dirty:",this.params_panel.form);
        if (this.status_param_values) 
          p.pv = Lino.fields2array(
            this.params_panel.fields,this.status_param_values);
      }
      //~ if (!this.params_panel.form.isDirty()) return;
      //~ p.pv = this.get_param_values();
      //~ console.log("20120203 add_param_values added pv",p.pv,"to",p);
    }
  },
  get_param_values : function() { // similar to get_field_values()
      return Lino.fields2array(this.params_panel.fields);
  },
  set_param_values : function(pv) {
    if (this.params_panel) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_param_values = pv;
      //~ this.params_panel.form.suspendEvents(false);
      this.setting_param_values = true;
      if (pv) { 
          this.params_panel.form.my_loadRecord(pv);
      } else { 
        this.params_panel.form.reset(); 
      }
      this.setting_param_values = false;
      this._force_dirty = false; 
      //~ this.params_panel.form.resumeEvents();
    }
  }
};




Lino.Viewport = Ext.extend(Ext.Viewport, Lino.MainPanel);
Lino.Viewport = Ext.extend(Lino.Viewport, {
  layout : "fit"
  ,is_home_page : true
  ,initComponent : function(){
    Lino.Viewport.superclass.initComponent.call(this);
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.el,{msg:"Bitte warten..."});
      //~ console.log("20121118 Lino.viewport.loadMask",this.loadMask);
    },this);
  }
  ,refresh : function() {
      var caller = this;
      // console.log("20140829 Lino.Viewport.refresh()");
      if (caller.loadMask) caller.loadMask.show();
      var success = function(response) {
        if (caller.loadMask) caller.loadMask.hide();
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          //~ console.log('Lino.do_action()',action.name,'result is',result);
          if (result.html) {
              var cmp = Ext.getCmp('dashboard');
              // cmp.removeAll(true);  // 20140829
              cmp.update(result.html, true);
          }
          if (result.message) {
              if (result.alert) {
                  //~ Ext.MessageBox.alert('Alert',result.alert_msg);
                  Ext.MessageBox.alert('Alert',result.message);
              } else {
                  Lino.notify(result.message);
              }
          }
          
          if (result.notify_msg) Lino.notify(result.notify_msg);
          if (result.js_code) { 
            var jsr = result.js_code(caller);
            //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
          };
        }
      };
      var action = {
        url : '/api/main_html',
        waitMsg: "Bitte warten...",
        failure: Lino.ajax_error_handler(caller),
        success: success,
        method: 'GET',
        params: {}
      };
      Lino.insert_subst_user(action.params);
      Ext.Ajax.request(action);
    
  }
});




Lino.open_window = function(win, st, requesting_panel) {
  // console.log("20140831 Lino.open_window()", win, win.el.getBox());
  var cw = Lino.current_window;
  if (cw) {
    // console.log("20140829 Lino.open_window() save current status",
    //             cw.main_item.get_status());
    Lino.window_history.push({
      window:cw,
      status:cw.main_item.get_status()
    });
  }
  Lino.current_window = win;
  //~ if (st.su) 
      //~ Lino.subst_user_field.setValue(st.su);
  win.main_item.set_status(st, requesting_panel);
  // win.toFront();
  win.show();
};

Lino.load_url = function(url) {
    //~ foo.bar.baz = 2; 
    //~ console.log("20121120 Lino.load_url()");
    //~ Lino.body_loadMask.show();
    Lino.viewport.loadMask.show();
    //~ location.replace(url);
    document.location = url;
}

Lino.close_window = function(status_update, norestore) {
  // norestore is used when called by handle_action_result() who 
  // will call set_status itself later
  var cw = Lino.current_window;
  var ww = Lino.window_history.pop();
  var retval = cw.main_item.requesting_panel;
  // console.log(
  //     "20140917 Lino.close_window() going to close", cw.title,
  //     "previous is", ww, 
  //     "norestore is", norestore,
  //     "retval is", retval);
  if (ww) {
    //~ if (status_update) Ext.apply(ww.status,status_update);
    if(!norestore) {
        if (status_update) status_update(ww);
        ww.window.main_item.set_status(ww.status);
    }
    Lino.current_window = ww.window;
  } else {
      Lino.current_window = null;
      // new since 20140829:
      if(!norestore) { Lino.viewport.refresh(); }
  }
  if (cw) cw.hide_really();
  return retval;
};

Lino.kill_current_window = function() {
  // console.log("20140418 Lino.kill_current_window()");
  var cw = Lino.current_window;
  Lino.current_window = null;
  if (cw) cw.hide_really();
};

Lino.reload = function() {
    // First close all windows to ensure all changes are saved
    Lino.close_all_windows();

    // Then reload current view
    var url =  "/"

    var p = {};
    Lino.insert_subst_user(p)
    if (Ext.urlEncode(p))
        url = url + "?" + Ext.urlEncode(p);

    Lino.load_url(url);
}

Lino.handle_home_button = function() {
  if (Lino.window_history.length == 0)
      Lino.reload();
  else
      Lino.close_all_windows();
}

Lino.close_all_windows = function() {
    while (Lino.window_history.length > 0) {
        Lino.close_window();
    }
}

Lino.calling_window = function() {
    if (Lino.window_history.length) 
        return Lino.window_history[Lino.window_history.length-1];
}

//~ Lino.WindowAction = function(mainItemClass,windowConfig,mainConfig,ppf) {
Lino.WindowAction = function(windowConfig,main_item_fn) {
    //~ if(!mainConfig) mainConfig = {};
    //~ mainConfig.is_main_window = true;
    this.windowConfig = windowConfig;
    this.main_item_fn = main_item_fn;
    //~ if (ppf) mainConfig.params_panel.fields = ppf;
    //~ this.mainConfig = mainConfig;
    //~ this.mainItemClass = mainItemClass;
};

Lino.WindowAction = Ext.extend(Lino.WindowAction,{
    window : null,
    //~ mainItemClass: null,
    get_window : function() {
      //~ if(mainConfig) Ext.apply(this.mainConfig,mainConfig);
      // if (this.window == null || this.window.isDestroyed)  { // 20140829
      // if (this.window == null || this.window.getBox().width == 0)  { // 20140829
      if (this.window == null)  {
      // if (true)  {
          //~ this.windowConfig.main_item = new this.mainItemClass(this.mainConfig);
          this.windowConfig.main_item = this.main_item_fn();
          this.window = new Lino.Window(this.windowConfig);
      }
      return this.window;
    },
    run : function(requesting_panel, status) {
      // console.log('20140829 window_action.run()', this)
      Lino.open_window(this.get_window(), status, requesting_panel);
    }
  
});


Lino.PanelMixin = {
  get_containing_window : function (){
      if (this.containing_window) return this.containing_window;
      return this.containing_panel.get_containing_window();
  }
  ,set_window_title : function(title) {
    //~ this.setTitle(title);
    var cw = this.get_containing_window();

    //~ if (cw) {
    //~ if (cw && cw.closable) {
    if (cw && !cw.main_item.hide_window_title) {
      //~ console.log('20111202 set_window_title(',title,') for',this.containing_window);
      //~ if (! this.containing_window.rendered) console.log("WARNING: not rendered!");
      cw.setTitle(title);
    //~ } else {
      //~ document.title = title;
    }
    //~ else console.log('20111202 not set_window_title(',title,') for',this);
  }
  
};


// Lino.status_bar = new Ext.ux.StatusBar({defaultText:'Lino version 1.6.16.'});




Lino.edit_tinymce_text = function(panel, options) {
  // `panel` is the RichTextPanel
  //~ console.log(20111220,panel);
  //~ var rec = panel.get_current_record();
  var rec = panel.containing_panel.get_current_record();
  var value = rec ? rec.data[panel.editor.name] : '';
  var saving = false;
  var todo_after_save = false;
  var discard_changes = false;
  
  
  function save() {
    //~ if (todo_after_save) {alert('tried to save again'); return; }
    if (saving) {alert('tried to save again'); return; }
    //~ var url = panel.containing_window.main_item.get_record_url(rec.id);
    var url = panel.containing_panel.get_record_url(rec.id);
    var params = Ext.apply({}, panel.containing_panel.get_base_params());
    params[panel.editor.name] = editor.getValue();
    //~ params.su = Lino.subst_user;
    //~ Lino.insert_subst_user(params);
    var a = { 
      params: params, 
      method: 'PUT',
      url: url,
      failure: function() {
          //~ if (editor.ed.getContainer()) 
          editor.ed.setProgressState(0);
          todo_after_save = false;
          saving = false;
          console.log('tinymce.save() failed. sorry.',arguments);
        },
      success: function() {
        saving = false;
        //~ if (editor.ed.getContainer()) 
        editor.ed.setProgressState(0);
        rec.data[panel.editor.name] = editor.getValue();
        if(todo_after_save) {
            var fn = todo_after_save;
            todo_after_save = false;
            fn();
        }
        //~ panel.containing_window.set_current_record(rec);
        panel.refresh();
      }
    };
    //~ if (editor.ed.getContainer()) 
    editor.ed.setProgressState(1); // Show progress
    saving = true;
    //~ console.log(a);
    Ext.Ajax.request(a);
  };
  function save_callback() {
      save();
      //~ save(function(){editor.ed.setDirty(false);})
      /* return true have the save button disabled.  
      That's not perfect because the PUT is asynchronous 
      and the response is not yet known.
      */
      return true;
  }
  //~ var actions = [
    //~ {text:"Save",handler:save}
  //~ ]; 
  //~ console.log(20110610,panel.editor.disabled);
  var settings = {};
  Ext.apply(settings,{
        readonly: panel.editor.disabled,
        //~ language: "de",
        plugins : "save,emotions,spellchecker,advhr,insertdatetime,preview,table,searchreplace,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "save,cancel,|,bold,italic,underline,|,justifyleft,justifycenter,justifyright,fontselect,fontsizeselect,formatselect,|,search,replace",
        theme_advanced_buttons2 : "cut,copy,paste,template,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,link,unlink,anchor,image,|,code,preview,|,forecolor,backcolor",
        theme_advanced_buttons3 : "insertdate,inserttime,|,spellchecker,advhr,,removeformat,|,sub,sup,|,charmap,emotions,|,tablecontrols",      
        theme_advanced_resizing : false,
        convert_urls : false,
        save_onsavecallback : save_callback,
        save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
  });
  Ext.apply(settings,options);
  var editor = new Ext.ux.TinyMCE({
      value : value,
      tinymceSettings: settings
    });
  var win = new Ext.Window({
    title: rec.title, 
    //~ bbar: actions,
    layout: 'fit',
    items: editor,
    width: 600, 
    height:500,
    minWidth: 100,
		minHeight: 100,
    modal: true,
    resizable: true,
    maximizable: true,
    //~ maximized: true,
    //~ closeAction: "close"
    closeAction: "hide"
    //~ hideMode: "offsets",
    //~ constrainHeader: true,
    //~ bodyStyle: 'padding: 10px'
  });

  //~ win.on('beforeclose',function() {
  win.on('beforehide',function() {
    if (todo_after_save) return false;
    if (discard_changes) return true;
    if (editor.isDirty()) {
        //~ var ok = false;
        //~ var allowClose = true;
        var config = {title:"Bestätigung"};
        config.buttons = Ext.MessageBox.YESNOCANCEL;
        config.msg = "Änderungen im Text speichern?";
        config.modal = true;
        config.fn = function(buttonId,text,opt) {
          //~ console.log('do_when_clean',buttonId)
          if (buttonId == "yes") {
              /* we cancel this close, but save()'s onSuccess will call again.*/
              //~ allowClose = false;
              todo_after_save = function(){win.hide();}
              editor.ed.execCommand('mceSave');
              //~ editor.ed.save(function(){win.close();});
          } else if (buttonId == "no") { 
              discard_changes = true;
              win.hide()
          //~ } else if (buttonId == "cancel") { 
            //~ ok = true;
              //~ allowClose = false;
          //~ } else { 
            //~ console.log('unknwon buttonId:',buttonId);
          }
        }
        Ext.MessageBox.show(config);
        return false;
        //~ return allowClose;
    }
  });
  win.show();
}







/* 
  Originally copied from Ext JS Library 3.3.1
  Modifications by Luc Saffre : 
  - rendering of phantom records
  - fire afteredit event
  - react on dblclcik, not on single click

 */
Lino.CheckColumn = Ext.extend(Ext.grid.Column, {

    processEvent : function(name, e, grid, rowIndex, colIndex){
        //~ console.log('20110713 Lino.CheckColumn.processEvent',name)
        if (name == 'click') {
        //~ if (name == 'mousedown') {
        //~ if (name == 'dblclick') {
            return this.toggleValue(grid, rowIndex, colIndex);
        } else {
            return Ext.grid.ActionColumn.superclass.processEvent.apply(this, arguments);
        }
    },
    
    toggleValue : function (grid,rowIndex,colIndex) {
        var record = grid.store.getAt(rowIndex);
        var dataIndex = grid.colModel.getDataIndex(colIndex);
        // 20120514
        //~ if(record.data.disabled_fields && record.data.disabled_fields[dataIndex]) {
          //~ Lino.notify("Dieses Feld ist deaktiviert");
          //~ return false;
        //~ }
      
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("This field is disabled.");
            //~ return false;
        //~ }
        var startValue = record.data[dataIndex];
        var value = !startValue;
        //~ record.set(this.dataIndex, value);
        var e = {
            grid: grid,
            record: record,
            field: dataIndex,
            originalValue: startValue,
            value: value,
            row: rowIndex,
            column: colIndex,
            cancel: false
        };
        if(grid.fireEvent("beforeedit", e) !== false && !e.cancel){
        //~ if(grid.fireEvent("validateedit", e) !== false && !e.cancel){
            record.set(dataIndex, value);
            delete e.cancel;
            grid.fireEvent("afteredit", e);
        }
        return false; // Cancel event propagation
    },

    renderer : function(v, p, record){
        if (record.phantom) return '';
        p.css += ' x-grid3-check-col-td'; 
        return String.format('<div class="x-grid3-check-col{0}">&#160;</div>', v ? '-on' : '');
    }

    // Deprecate use as a plugin. Remove in 4.0
    // init: Ext.emptyFn
});

// register ptype. Deprecate. Remove in 4.0
// Ext.preg('checkcolumn', Lino.CheckColumn);

// backwards compat. Remove in 4.0
// Ext.grid.CheckColumn = Lino.CheckColumn;

// register Column xtype
Ext.grid.Column.types.checkcolumn = Lino.CheckColumn;


/* 20110725 : 
Lino.on_tab_activate is necessary 
in contacts.Person.2.dtl 
(but don't ask me why...)
*/
Lino.on_tab_activate = function(item) {
  //~ console.log('activate',item); 
  if (item.rendered && item.doLayout) item.doLayout();
  //~ if (item.rendered) item.doLayout();
}

Lino.TimeField = Ext.extend(Ext.form.TimeField,{
  format: 'H:i',
  increment: 15
  });
Lino.DateField = Ext.extend(Ext.form.DateField,{
  //~ boxMinWidth: Lino.chars2width(15), // 20131005 changed from 11 to 15
  format: 'd.m.Y',
  altFormats: 'd/m/Y|Y-m-d'
  });
Lino.DatePickerField = Ext.extend(Ext.DatePicker,{
  //~ boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  //~ altFormats: 'd/m/Y|Y-m-d'
  formatDate : function(date){
      //~ console.log("20121203 formatDate",this.name,date);
      return Ext.isDate(date) ? date.dateFormat(this.format) : date;
  }
  });
Lino.DateTimeField = Ext.extend(Ext.ux.form.DateTime,{
  dateFormat: 'd.m.Y',
  timeFormat: 'H:i'
  //~ ,hiddenFormat: 'd.m.Y H:i'
  });
Lino.URLField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  //~ triggerClass : 'x-form-world-trigger',
  vtype: 'url',
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    window.open(this.getValue(),'_blank');
  }
});
Lino.IncompleteDateField = Ext.extend(Ext.form.TextField,{
  //~ regex: /^-?\d+-[01]\d-[0123]\d$/,
  //~ regex: /^[0123]\d\.[01]\d\.-?\d+$/,
  maxLength: 10,
  boxMinWidth: Lino.chars2width(10),
  regex: /^[0123]?\d\.[01]?\d\.-?\d+$/,
  regexText: 'Datum im Format JJJJ-MM-TT eingeben (Nullen für unbekannte Teile)'
  });


//~ Lino.make_dropzone = function(cmp) {
    //~ cmp.on('render', function(ct, position){
      //~ ct.el.on({
        //~ dragenter:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ return true;
        //~ }
        //~ ,dragover:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ event.stopEvent();
          //~ return true;
        //~ }
        //~ ,drop:{
          //~ scope:this
          //~ ,fn:function(event){
            //~ event.stopEvent();
            //~ console.log(20110516);
            //~ var files = event.browserEvent.dataTransfer.files;
            //~ if(files === undefined){
              //~ return true;
            //~ }
            //~ var len = files.length;
            //~ while(--len >= 0){
              //~ console.log(files[len]);
              //~ // this.processDragAndDropFileUpload(files[len]);
            //~ }
          //~ }
        //~ }
      //~ });
    //~ });
//~ };

//~ Lino.FileUploadField = Ext.ux.form.FileUploadField;

Lino.FileUploadField = Ext.extend(Ext.ux.form.FileUploadField,{
    unused_onRender : function(ct, position){
      Lino.FileUploadField.superclass.onRender.call(this, ct, position);
      this.el.on({
        dragenter:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          return true;
        }
        ,dragover:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          event.stopEvent();
          return true;
        }
        ,drop:{
          scope:this
          ,fn:function(event){
            event.stopEvent();
            //~ console.log(20110516);
            var files = event.browserEvent.dataTransfer.files;
            if(files === undefined){
              return true;
            }
            var len = files.length;
            while(--len >= 0){
              console.log(files[len]);
              //~ this.processDragAndDropFileUpload(files[len]);
            }
          }
        }
      });
    }
});

Lino.FileField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  editable: false,
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    if (this.getValue()) window.open(MEDIA_URL + '/'+this.getValue(),'_blank');
  }
});

Lino.file_field_handler = function(panel,config) {
  if (panel.action_name == 'insert') {
      panel.has_file_upload = true;


      // config.value = '<br/><br/>';

      var f = new Lino.FileUploadField(config);
      //~ Lino.make_dropzone(f);
      return f;
      //~ return new Ext.ux.form.FileUploadField(config);
      //~ return new Lino.FileField(config);
      
  } else {
      //~ return new Lino.URLField(config);
      return new Lino.FileField(config);
  }
}

Lino.VBorderPanel = Ext.extend(Ext.Panel,{
    constructor : function(config) {
      config.layout = 'border';
      delete config.layoutConfig;
      Lino.VBorderPanel.superclass.constructor.call(this,config);
      for(var i=0; i < this.items.length;i++) {
        var item = this.items.get(i);
        if (this.isVertical(item) && item.collapsible) {
          item.on('collapse',this.onBodyResize,this);
          item.on('expand',this.onBodyResize,this);
        }
      }
    },
    isVertical : function(item) {
       return (item.region == 'north' || item.region == 'south' || item.region == 'center');
    },
    onBodyResize: function(w, h){
        //~ console.log('VBorderPanel.onBodyResize',this.title)
      if (this.isVisible()) { // to avoid "Uncaught TypeError: Cannot call method 'getHeight' of undefined."
        var sumflex = 0;
        var availableHeight = this.getInnerHeight();
        var me = this;
        this.items.each(function(item){
          if (me.isVertical(item)) {
              if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  if (item.rendered) availableHeight -= item.getHeight();
              } else {
                  sumflex += item.flex;
              }
          } 
          
        });
        //~ for(var i=0; i < this.items.length;i++) {
          //~ var item = this.items.get(i);
          //~ // if (this.isVertical(item) && item.getResizeEl()) {
          //~ if (this.isVertical(item)) {
              //~ if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  //~ // item.syncSize()
                  //~ // item.doLayout()
                  //~ // if (item.region == "north") console.log('region north',item.getHeight(),item.id, item);
                  //~ // if (item.getHeight() == 0) console.log(20100921,'both flex and getHeight() are 0!');
                  //~ availableHeight -= item.getHeight();
              //~ } else {
                  //~ sumflex += item.flex;
                  //~ // console.log(item.flex);
              //~ }
          //~ } 
          //~ // else console.log('non-vertical item in VBoderPanel:',item)
        //~ }
        var hunit = availableHeight / sumflex;
        //~ console.log('sumflex=',sumflex,'hunit=',hunit, 'availableHeight=',availableHeight);
        for(var i=0; i < this.items.length;i++) {
          var item = this.items.get(i);
          if (this.isVertical(item)) {
              if (item.flex != 0 && ! item.collapsed) {
                  item.setHeight(hunit * item.flex);
                  //~ console.log(item.region,' : height set to',item.getHeight());
              }
          }
          //~ else console.log('non-vertical item in VBoderPanel:',item)
        }
      }
      Lino.VBorderPanel.superclass.onBodyResize.call(this, w, h);
    }
});


/*
  modifications to the standard behaviour of a CellSelectionModel:
  
*/
Ext.override(Ext.grid.CellSelectionModel, {
//~ var dummy = {

    handleKeyDown : function(e){
        /* removed because F2 wouldn't pass
        if(!e.isNavKeyPress()){
            return;
        }
        */
        //~ console.log('handleKeyDown',e)
        var k = e.getKey(),
            g = this.grid,
            s = this.selection,
            sm = this,
            walk = function(row, col, step){
                return g.walkCells(
                    row,
                    col,
                    step,
                    g.isEditor && g.editing ? sm.acceptsNav : sm.isSelectable, 
                    sm
                );
            },
            cell, newCell, r, c, ae;

        switch(k){
            case e.ESC:
            case e.PAGE_UP:
            case e.PAGE_DOWN:
                break;
            default:
                // e.stopEvent(); // removed because Browser keys like Alt-Home, Ctrl-R wouldn't work
                break;
        }

        if(!s){
            cell = walk(0, 0, 1); 
            if(cell){
                this.select(cell[0], cell[1]);
            }
            return;
        }

        cell = s.cell;  
        r = cell[0];    
        c = cell[1];    
        
        switch(k){
            case e.TAB:
                if(e.shiftKey){
                    newCell = walk(r, c - 1, -1);
                }else{
                    newCell = walk(r, c + 1, 1);
                }
                break;
            case e.HOME:
                if (! (g.isEditor && g.editing)) {
                  if (!e.hasModifier()){
                      newCell = [r, 0];
                      //~ console.log('home',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
                      if (activePage > 1) {
                          e.stopEvent();
                          t.moveFirst();
                          return;
                      }
                      newCell = [0, c];
                      break;
                  }
                }
            case e.END:
                if (! (g.isEditor && g.editing)) {
                  c = g.colModel.getColumnCount()-1;
                  if (!e.hasModifier()) {
                      newCell = [r, c];
                      //~ console.log('end',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var d = t.getPageData();
                      if (d.activePage < d.pages) {
                          e.stopEvent();
                          var self = this;
                          t.on('change',function(tb,pageData) {
                              var r = g.store.getCount()-2;
                              self.select(r, c);
                              //~ console.log('change',r,c);
                          },this,{single:true});
                          t.moveLast();
                          return;
                      } else {
                          newCell = [g.store.getCount()-1, c];
                          //~ console.log('ctrl-end',newCell);
                          break;
                      }
                  }
                }
            case e.DOWN:
                newCell = walk(r + 1, c, 1);
                break;
            case e.UP:
                newCell = walk(r - 1, c, -1);
                break;
            case e.RIGHT:
                newCell = walk(r, c + 1, 1);
                break;
            case e.LEFT:
                newCell = walk(r, c - 1, -1);
                break;
            case e.F2:
                if (!e.hasModifier()) {
                    if (g.isEditor && !g.editing) {
                        g.startEditing(r, c);
                        e.stopEvent();
                        return;
                    }
                    break;
                }
            case e.INSERT:
                if (!e.hasModifier()) {
                    if (g.ls_insert_handler && !g.editing) {
                        e.stopEvent();
                        Lino.show_insert(g);
                        return;
                    }
                    break;
                }
            // case e.DELETE:
            //     if (!e.hasModifier()) {
            //         if (!g.editing) {
            //             e.stopEvent();
            //             Lino.delete_selected(g);
            //             return;
            //         }
            //         break;
            //     }

            case e.ENTER:
                e.stopEvent();
                g.onCellDblClick(r,c);
                break;

            default:
                g.handle_key_event(e);
                
        }
        

        if(newCell){
          e.stopEvent();
          r = newCell[0];
          c = newCell[1];
          this.select(r, c); 
          if(g.isEditor && g.editing){ 
            ae = g.activeEditor;
            if(ae && ae.field.triggerBlur){
                ae.field.triggerBlur();
            }
            g.startEditing(r, c);
          }
        //~ } else if (g.isEditor && !g.editing && e.charCode) {
        //~ // } else if (!e.isSpecialKey() && g.isEditor && !g.editing) {
            //~ g.set_start_value(String.fromCharCode(e.charCode));
            //~ // g.set_start_value(String.fromCharCode(k));
            //~ // g.set_start_value(e.charCode);
            //~ g.startEditing(r, c);
            //~ // e.stopEvent();
            //~ return;
        // } else {
          // console.log('20120513',e,g);
        }
        
    }


//~ };
});

 

function PseudoConsole() {
    this.log = function() {};
};
if (typeof(console) == 'undefined') console = new PseudoConsole();

Lino.notify = function(msg) {
  if (msg == undefined) msg = ''; else console.log(msg);
  
    if (msg == undefined) return;
    // Lino.alert(msg);
  
};

Lino.alert = function(msg) {
  Ext.MessageBox.alert('Notify',msg);
};


//~ Lino.show_about = function() {
  //~ new Ext.Window({
    //~ width: 400, height: 400,
    //~ title: "About",
    //~ html: '<a href="http://www.extjs.com" target="_blank">ExtJS</a> version ' + Ext.version
  //~ }).show();
//~ };

function obj2str(o) {
  if (typeof o != 'object') return String(o);
  var s = '';
  for (var p in o) {
    s += p + ': ' + obj2str(o[p]) + '\n';
  }
  return s;
}

Lino.on_store_exception = function (store,type,action,options,response,arg) {
  //~ throw response;
  console.log("on_store_exception: store=",store,
    "type=",type,
    "action=",action,
    "options=",options,
    "response=",response,
    "arg=",arg);
  if (arg) { console.log(arg.stack)};
};

//~ Lino.on_submit_success = function(form, action) {
   //~ Lino.notify(action.result.message);
   //~ this.close();
//~ };

Lino.on_submit_failure = function(form, action) {
    //~ Lino.notify();
  // action may be undefined
    switch (action.failureType) {
        case Ext.form.Action.CLIENT_INVALID:
            Ext.Msg.alert('Client-side failure', 'Form fields may not be submitted with invalid values');
            break;
        case Ext.form.Action.CONNECT_FAILURE:
            Ext.Msg.alert('Connection failure', 'Ajax communication failed');
            break;
        case Ext.form.Action.SERVER_INVALID:
            Ext.Msg.alert('Server-side failure', action.result.message);
   }
};



/*
Lino.save_wc_handler = function(ww) {
  return function(event,toolEl,panel,tc) {
    var pos = panel.getPosition();
    var size = panel.getSize();
    wc = ww.get_window_config();
    Ext.applyIf(wc,{ 
      x:pos[0],y:pos[1],height:size.height,width:size.width,
      maximized:panel.maximized});
    Lino.do_action(ww,{url:'/window_configs/'+ww.config.permalink_name,params:wc,method:'POST'});
  }
};

*/

Lino.show_in_own_window_button = function(handler) {
  return {
    qtip: "Dieses Panel in eigenem Fenster öffnen", 
    id: "up",
    handler: function(event,toolEl,panel, tc) {
      //~ console.log('20111206 report_window_button',panel,handler);
      handler.run(null,{base_params:panel.containing_panel.get_master_params()});
    }
  }
}

Lino.action_handler = function (panel, on_success, on_confirm) {
  return function (response) {
      if (!panel) { 
          if (Lino.current_window) 
              panel = Lino.current_window.main_item;
          else panel = Lino.viewport;
      }
      
    if (panel.loadMask) panel.loadMask.hide(); // 20120211
    if (!response.responseText) return ;
    var result = Ext.decode(response.responseText);
    Lino.handle_action_result(panel, result, on_success, on_confirm);
  }
};

Lino.handle_action_result = function (panel, result, on_success, on_confirm) {

    // console.log('20141127 Lino.handle_action_result()', result);
    
    // if (panel instanceof Lino.GridPanel) {
    //     gridmode = true;
    // } else {
    //     gridmode = false;
    // }

    //~ if (result.goto_record) {
        //~ var js = "Lino." + result.goto_record[0] + '.detail.run';
        //~ var h = eval(js);
        //~ h(panel,{record_id:result.goto_record[1]});
    //~ }
    
    if (result.xcallback) {
        //~ var config = {title:"Bestätigung"};
        var config = {title:result.xcallback.title};
        //~ config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        var p = {};
        Lino.insert_subst_user(p);
        config.buttons = result.xcallback.buttons;
        config.msg = result.message;
        config.fn = function(buttonId, text, opt) {
          panel.loadMask.show(); 
          //~ Lino.insert_subst_user(p);
          Ext.Ajax.request({
            method: 'GET',
            url: '/callbacks/'
                  + result.xcallback.id + '/' + buttonId,
            params: p,
            success: Lino.action_handler(panel, on_success, on_confirm)
          });
        }
        Ext.MessageBox.show(config);
        return;
    }

    // `record_id` and/or `data_record` both mean "display the detail
    // of this record". 
    
    if(result.detail_handler_name) {
        // TODO: make sure that result.detail_handler_name is secure
        var detail_handler = eval("Lino." + result.detail_handler_name);
    }
    var ns = {};  // new status
    if (result.close_window) {
        
        if(result.record_id || result.data_record) {
            var ww = Lino.calling_window();
            if (ww && ww.window.main_item instanceof Lino.FormPanel) {
                if (ww.window.main_item.ls_detail_handler == detail_handler) {
                    ns.record_id = result.record_id;
                    ns.data_record = result.data_record;
                    console.log("20140630 use new status.");
                }
            }
        }

        // Subsequent processing expects that `panel` is "the current
        // panel". Since we close the window, `panel` should now point
        // to the previous window. Note the case of an insert window
        // that has been invoked by double-clicking on the phantom row
        // of a slave table in a detail window. In that case we want
        // `panel` to become the grid panel of the slave table who
        // called the insert window, not the master's detail form
        // panel.  When the insert window has been called by an action
        // link (e.g. generated using ar.insert_button), then
        // Lino.close_window can return `undefined`.

        panel = Lino.close_window(function(st) {Ext.apply(st, ns)}); 
        if (!panel) 
            panel = Lino.current_window.main_item;

    }

    if(result.record_id || result.data_record) {
        if (! (ns.record_id || ns.data_record)) {
          if (panel instanceof Lino.FormPanel 
              && panel.ls_detail_handler == detail_handler) 
            {
              // console.log("20140630 use panel.set_status().");
              panel.set_status({
                  record_id: result.record_id,
                  data_record: result.data_record});
          } else {
              // console.log("20140630 run detail_handler.");
              detail_handler.run(null, {
                  record_id: result.record_id,
                  data_record: result.data_record,
                  base_params: panel.get_base_params()});
          }

          // if (panel instanceof Lino.FormPanel 
          //     && panel.ls_url == result.actor_url) {
          //     // console.log("20140506 case 2 it's a FormPanel:", panel);
          //     panel.set_status({
          //         record_id: result.record_id,
          //         data_record: result.data_record});
          // } else if (panel.ls_detail_handler 
          //            && panel.ls_url == result.actor_url) {
          //     // console.log("20140506 case 4");
          //     panel.ls_detail_handler.run(null, {
          //         record_id: result.record_id,
          //         data_record: result.data_record,
          //         base_params: panel.get_base_params()});
          // } else {
          //     result.refresh_all = true;
          //     console.log("20140604 case 6", result.actor_url);
          // }
        }
    }

    // `eval_js` must get handled after `close_window` because it
    // might ask to open a new window (and we don't want to close that
    // new window).  It must execute *before* any MessageBox,
    // otherwise the box would get hidden by a window that opens
    // afterwards.

    if (result.eval_js) {
        //~ console.log(20120618,result.eval_js);
        eval(result.eval_js);
    }
    
    if (on_success && result.success) {
        // console.log("20140430 handle_action_result calls on_success", 
        //             on_success);
        on_success(result);
    }
    
    if (result.info_message) {
        console.log(result.info_message);
    }
    
    if (result.warning_message) {
        if (!result.alert) result.alert = "Warnung";
        Ext.MessageBox.alert(result.alert, result.warning_message);
    }
    
    if (result.message) {
        //~ if (result.alert && ! gridmode) {
        if (result.alert) { // 20120628b 
            //~ Ext.MessageBox.alert('Alert',result.alert_msg);
            if (result.alert === true) result.alert = "Alarm";
            Ext.MessageBox.alert(result.alert, result.message);
        } else {
            Lino.notify(result.message);
        }
    }

    if(result.record_deleted && panel.ls_detail_handler == detail_handler) {
        panel.after_delete();
    }
    
    if (result.refresh_all) {
        var cw = Lino.current_window;
        // var cw = panel.get_containing_window();
        if (cw) {
            // console.log("20140917 refresh_all calls refresh on", cw.main_item);
            cw.main_item.refresh();
        }
        // else console.log("20140917 cannot refresh_all because ",
        //                  "there is no current_window");
    } else {
        if (result.refresh) {
            // console.log("20140917 Gonna call panel.refresh()", panel);
            panel.refresh();
        }
    }if (result.open_url) {
        //~ console.log(20111126,result.open_url);
        //~ if (!result.message)
            //~ Lino.notify('Open new window <a href="'+result.open_url+'" target="_blank">'+result.open_url+'</a>');
        window.open(result.open_url,'foo',"");
        //~ document.location = result.open_url;
    }
};

// obsolete but still used for deleting records.
Lino.do_action = function(caller,action) { 
  action.success = function(response) {
    if (caller.loadMask) caller.loadMask.hide();
    //~ console.log('Lino.do_action()',action,'action success',response);
    if (action.after_success) {
        //~ console.log('Lino.do_action() calling after_success');
        action.after_success();
    }
    if (response.responseText) {
      var result = Ext.decode(response.responseText);
      //~ console.log('Lino.do_action()',action.name,'result is',result);
      if (result.message) {
          if (result.alert) {
              //~ Ext.MessageBox.alert('Alert',result.alert_msg);
              Ext.MessageBox.alert('Alert',result.message);
          } else {
              Lino.notify(result.message);
          }
      }
      
      //~ if (result.alert_msg) Ext.MessageBox.alert('Alert',result.alert_msg);
      //~ if (result.message) Lino.notify(result.message);
      if (result.notify_msg) Lino.notify(result.notify_msg);
      if (result.js_code) { 
        //~ console.log('Lino.do_action()',action,'gonna call js_code in',result);
        var jsr = result.js_code(caller);
        //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
        if (action.after_js_code) {
          //~ console.log('Lino.do_action()',action,'gonna call after_js_code');
          action.after_js_code(jsr);
          //~ console.log('Lino.do_action()',action,'returned from after_js_code');
        //~ } else {
          //~ console.log('Lino.do_action()',action,' : after_js_code is false');
        }
      };
    }
  };
  Ext.applyIf(action,{
    waitMsg: "Bitte warten...",
    failure: Lino.ajax_error_handler(caller),
    params: {}
  });
  //~ action.params.su = Lino.subst_user;
  Lino.insert_subst_user(action.params);
  
  Ext.Ajax.request(action);
};

//~ Lino.gup = function( name )
//~ {
  //~ // Thanks to http://www.netlobo.com/url_query_string_javascript.html
  //~ name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
  //~ var regexS = "[\\?&]"+name+"=([^&#]*)";
  //~ var regex = new RegExp( regexS );
  //~ var results = regex.exec( window.location.href );
  //~ if( results == null )
    //~ return "";
  //~ else
    //~ return results[1];
//~ };

//~ Lino.refresh_handler = function (ww) {
  //~ return function() { 
      //~ console.log('refresh',ww);
      //~ ww.main_item.doLayout(false,true);
      //~ ww.main_item.syncSize();
  //~ }
//~ };

//~ Lino.tools_close_handler = function (ww) {
  //~ return function() { 
      //~ ww.close();
  //~ }
//~ };
Lino.permalink_handler = function (ww) {
  return function() { 
    //~ document.location = ww.main_item.get_permalink();
    //~ console.log('20130723 Lino.permalink_handler',ww);
    
    /* Uncaught TypeError: Cannot read property 'main_item' of null  */
    if (ww) {
        var url = ww.main_item.get_permalink();
    } else {
        var url = Lino.viewport.get_permalink();
    }
    Lino.load_url(url);
  }
};
//~ Lino.run_permalink = function() {
  //~ var plink = Lino.gup('permalink');
  //~ if(plink) { eval('Lino.'+plink); }
//~ }


Lino.ajax_error_handler = function(panel) {
  return function(response,options) {
    console.log('Ajax failure:', response, options);
    if (panel.loadMask) panel.loadMask.hide();
    if (response.responseText) {
      var lines = response.responseText.split('\n');
      if (lines.length > 10) {
          line = lines.splice(5, lines.length-10, "(...)");
      }
      //~ console.log(20131005, response.statusText.toCamel());
      Ext.MessageBox.alert(
        response.statusText.toCamel(),
        lines.join('<br/>')
        //~ response.responseText.replace(/\n/g,'<br/>'))
      )
    } else {
      Ext.MessageBox.alert('Action failed',
        'Lino server did not respond to Ajax request');
    }
  }
}
// Ext.Ajax.on('requestexception',Lino.ajax_error_handler)
 


Ext.QuickTips.init();

/* setting QuickTips dismissDelay to 0 */
// Apply a set of config properties to the singleton
//~ Ext.apply(Ext.QuickTips.getQuickTip(), {
//~ Ext.apply(Ext.ToolTip, {
    //~ dismissDelay: 0
    //~ autoHide: false,
    //~ closable: true,
    //~ maxWidth: 200,
    //~ minWidth: 100,
    //~ showDelay: 50      // Show 50ms after entering target
    //~ ,trackMouse: true
//~ });


//~ Ext.apply(Ext.QuickTip, {
    //~ dismissDelay: 0,
//~ });
  
Lino.quicktip_renderer = function(title,body) {
  return function(c) {
    //~ if (c instanceof Ext.Panel) var t = c.bwrap; else // 20130129
    if (c instanceof Ext.Panel) var t = c.header; else // 20130129
    var t = c.getEl();
    //~ console.log(20130129,t,title,body);
    //~ t.dismissDelay = 0;
    Ext.QuickTips.register({
      target: t,
      //~ cls: 'lino-quicktip-classical',
      dismissDelay: 0,
      //~ autoHide: false,
      showDelay: 50,      // Show 50ms after entering target
      //~ title: title,
      text: body
    });
  }
};


  
Lino.help_text_editor = function() {
  //~ var bp = {
      //~ mk:this.content_type,
      //~ mt:1
    //~ };
    //~ console.log(20120202,bp);
  //~ Lino.lino.ContentTypes.detail({},{base_params:bp});
  //~ Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
  Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
}

// Path to the blank image should point to a valid location on your server
//~ Ext.BLANK_IMAGE_URL = MEDIA_URL + '/extjs/resources/images/default/s.gif'; 


// used as Ext.grid.Column.renderer for id columns in order to hide the special id value -99999
Lino.id_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  return value;
}

Lino.raw_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  return value;
}

Lino.text_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return "not implemented"; 
  return value;
}

Lino.NullNumberColumn = Ext.extend(Ext.grid.Column, {
    align : 'right', 
    format : '0,00/i', 
    renderer : function(value, metaData, record, rowIndex, colIndex, store) {
        //~ console.log(20130128,"NullNumberColumn.renderer",value);
        if (value === null) return '';
        return Ext.util.Format.number(value, this.format);
    }
});


Lino.link_button = function(url) {
    // return '<a href="' + url + '"><img src="/media/lino/extjs/images/xsite/link.png" alt="link_button"></a>'
    return '<a href="' + url + '" style="text-decoration:none;">&#10138;</a>'
}

Lino.fk_renderer = function(fkname,handlername) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    //~ if (record.phantom) return '';
    if (value) {
        return Lino.link_button('javascript:'+handlername + '.run(null,{record_id:\'' + String(record.data[fkname]) + '\'})")') + value;
        // until 20140822 (clickable foreign keys):
        // var s = '<a href="javascript:' ;
        // s += handlername + '.run(null,{record_id:\'' + String(record.data[fkname]) + '\'})">';
        // s += value + '</a>';
        // return s
    }
    return '';
  }
};

Lino.lfk_renderer = function(panel,fkname) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  var handlername = 'console.log';
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '({},{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

//~ Lino.gfk_renderer = function() {
  //~ return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ if (record.phantom) return '';
    //~ console.log('Lino.gfk_renderer',value,colIndex,record,metaData,store);
    //~ return value;
  //~ }
//~ };


Lino.build_buttons = function(panel,actions) {
  //~ console.log("20121006 Lino.build_buttons",actions);
  if (actions) {
    var buttons = Array(actions.length);
    var cmenu = Array(actions.length);
    var keyhandlers = {};
    for (var i=0; i < actions.length; i++) { 
      var a = actions[i];
      if (a.menu) a.menu = Lino.build_buttons(panel,a.menu).bbar;
      buttons[i] = a;
      cmenu[i] = {
            text : a.menu_item_text,
            iconCls : a.iconCls,
            menu : a.menu
          };
      if (a.panel_btn_handler) {
          var h = a.panel_btn_handler.createCallback(panel);
          if (a.auto_save == true) {
              h = panel.do_when_clean.createDelegate(panel,[true,h]);
          } else if (a.auto_save == null) {
              h = panel.do_when_clean.createDelegate(panel,[false,h]);
          } else if (a.auto_save == false) {
              // h = h;
          } else {
              console.log("20120703 unhandled auto_save value",a)
          }
          buttons[i].handler = h;
          cmenu[i].handler = h;
          if (a.keycode) {
              keyhandlers[a.keycode] = h;
          }
          //~ if (buttons[i].xtype == 'splitbutton') {
              //~ cmenu[i].menu = a.menu;
          //~ } else {
              //~ cmenu[i].handler = h;
          //~ }
      } else {
          console.log("action without panel_btn_handler",a)
          // cmenu[i].handler = a.handler;
      }
    }
    return {
        bbar:buttons, 
        cmenu:new Ext.menu.Menu(cmenu),
        keyhandlers: keyhandlers
    };
  }
}

Lino.do_when_visible = function(cmp,todo) {
  //~ if (cmp.el && cmp.el.dom) 
  if (cmp.isVisible()) { 
    // 'visible' means 'rendered and not hidden'
    //~ console.log(cmp.title,'-> cmp is visible now');
    todo(); 
  //~ } else {
      //~ cmp.on('resize',todo,cmp,{single:true});
  //~ }
  //~ if (false) { // 20120213
  } else { 
    //~ console.log('Lino.do_when_visible() must defer because not isVisible()',todo,cmp);
    if (cmp.rendered) {
      //~ console.log(cmp,'-> cmp is rendered but not visible: and now?');
      //~ console.log(cmp.title,'-> cmp is rendered but not visible: try again in a moment...');
      //~ var fn = function() {Lino.do_when_visible(cmp,todo)};
      //~ fn.defer(100);
      
      Lino.do_when_visible.defer(50,this,[cmp,todo]);
      //~ Lino.do_when_visible.defer(100,this,[cmp,todo]);
      
    } else {
      //~ console.log(cmp.title,'-> after render');
      cmp.on('afterrender',todo,cmp,{single:true});
    }
  }
  
};    

/*
*/
Lino.do_on_current_record = function(panel, fn, phantom_fn) {
  // console.log('20140930 do_on_current_record', arguments);
  var rec = panel.get_current_record();
  if (rec == undefined) {
    Lino.notify("There's no selected record.");
    return;
  }
  // 20120307 A VirtualTable with a Detail (lino.Models) has only "phantom" records.
  if (rec.phantom) {
    //~ if (!panel.editable) { console.log("20120312 not editable:",panel)}
    if (phantom_fn) {
      phantom_fn(panel);
    } else {
      Lino.notify("Aktion nicht verfügbar auf dem Phantom-Record.");
    }
    return;
  }
  return fn(rec);
};


Lino.call_ajax_action = function(
    panel, method, url, p, actionName, step, on_confirm, on_success) {
  p.an = actionName;
  if (!panel || !panel.isVisible()) {
  //~ if (true) { // 20131026 : workflow_actions of a newly created record detail executed but did't refresh the screen because their requesting panel was the insert (not the detail) formpanel.
      if (Lino.current_window) 
          panel = Lino.current_window.main_item;
      else panel = Lino.viewport;
  }
  Ext.apply(p, panel.get_base_params());

  if (panel.get_selected) {
      var selected_recs = panel.get_selected();
      //~ console.log("20130831",selected_recs);
      var rs = Array(selected_recs.length);
      for(var i=0; i < selected_recs.length;i++) {
          rs[i] = selected_recs[i].data.id;
      };
      p.sr = rs;
  }
  
  // console.log("20140516 Lino.call_ajax_action", p, actionName, step);
  
  if (panel.loadMask) panel.loadMask.show(); 
    
  Ext.Ajax.request({
    method: method
    ,url: url
    ,params: p
    ,success: Lino.action_handler(panel, on_success, on_confirm)
    ,failure: Lino.ajax_error_handler(panel)
  });
};




Lino.row_action_handler = function(actionName, hm, pp) {
  var p = {};
  var fn = function(panel, btn, step) {
      // console.log('20140930 row_action_handler');
      if (pp) { p = pp(panel); if (! p) return; }
      
      if (!panel || panel.get_current_record == undefined) { // AFTER_20130725
        // console.log('20140930 row_action_handler 2', panel);
        panel = Ext.getCmp(panel);
        if (panel == undefined) {
          Lino.notify("Invalid panel spec.");
          return;
        }
      }
      
      Lino.do_on_current_record(panel, function(rec) {
          //~ console.log(panel);
          panel.add_param_values(p, true);
          Lino.call_ajax_action(
              panel, hm, panel.get_record_url(rec.id), 
              p, actionName, step, fn);
      });
  };
  return fn;
};

Lino.list_action_handler = function(ls_url,actionName,hm,pp) {
  var p = {};
  var url = '/api' + ls_url
  var fn = function(panel,btn,step) {
      //~ console.log("20121210 Lino.list_action_handler",arguments);
      if (pp) { p = pp(panel);  if (! p) return; }
      if (panel)  // may be undefined when called e.g. from quicklink
          panel.add_param_values(p,true);
      Lino.call_ajax_action(panel, hm,url, p, actionName, step, fn);
  };
  return fn;
};

Lino.param_action_handler = function(window_action) { // 20121012
  var fn = function(panel,btn,step) {
    Lino.do_on_current_record(panel,function(rec) {
      window_action.run(panel.getId(),{}); 
    });
  };
  return fn;
};


Lino.run_row_action = function(
    requesting_panel, url, meth, pk, actionName, params, preprocessor) {
  //~ var panel = action.get_window().main_item;
    console.log("20140930 Lino.run_row_action", params);
  url = '/api' + url  + '/' + pk;
  var panel = Ext.getCmp(requesting_panel);
  if (!params) params = {};
  if (preprocessor) {
      var p = preprocessor(); 
      Ext.apply(params, p);
  }
  var fn = function(panel, btn, step) {
    Lino.call_ajax_action(panel, meth, url, params, actionName, step, fn);
  }
  fn(panel, null, null);
}

Lino.put = function(requesting_panel, pk, data) {
    var panel = Ext.getCmp(requesting_panel);
    //~ var panel = null; // 20131026
    var p = {};
    p.an = 'put'; // SubmitDetail.action_name

    Ext.apply(p,data);
    var req = {
        params:p
        ,waitMsg: 'Saving your data...'
        ,scope: panel
        ,success: Lino.action_handler( panel, function(result) { 
            panel.refresh();
        })
        ,failure: Lino.ajax_error_handler(panel)
    };
    req.method = 'PUT';
    req.url = '/api' + panel.ls_url + '/' + pk;
    if (panel.loadMask) panel.loadMask.show(); 
    Ext.Ajax.request(req);
}



Lino.show_detail = function(panel, btn) {
  Lino.do_on_current_record(panel, 
    function(rec) {
      //~ panel.loadMask.show();
      Lino.run_detail_handler(panel, rec.id);
    },
    Lino.show_insert
  );
};

Lino.run_detail_handler = function(panel,pk) {
  var bp = panel.get_base_params();
  panel.add_param_values(bp); // 20120918
  var status = {
    record_id:pk,
    base_params:bp
  }
  //~ console.log("20120918 Lino.show_detail",status);
  panel.ls_detail_handler.run(null,status);
}

Lino.show_fk_detail = function(combo,detail_action,insert_action) {
    //~ console.log("Lino.show_fk_detail",combo,handler);
    pk = combo.getValue();
    if (pk) {
        detail_action.run(null,{record_id: pk})
      } else {
        insert_action.run(null,{record_id:-99999});
        //~ Lino.notify("Cannot show detail for empty foreign key.");
      }
};

Lino.show_insert = function(panel,btn) {
  var bp = panel.get_base_params();
  //~ console.log('20120125 Lino.show_insert',bp)
  //~ panel.ls_insert_handler.run(null,{record_id:-99999,base_params:bp});
  panel.ls_insert_handler.run(panel.getId(),{record_id:-99999,base_params:bp});
};



if (Ext.ux.grid !== undefined) {
    Lino.GridFilters = Ext.extend(Ext.ux.grid.GridFilters,{
      encode:true,
      local:false
    });
} else {
    Lino.GridFilters = function() {}; // dummy
    Ext.override(Lino.GridFilters,{
      init : function() {}
    });
};



Lino.FieldBoxMixin = {
  before_init : function(config,params) {
    if (params) Ext.apply(config,params);
    var actions = Lino.build_buttons(this, config.ls_bbar_actions);
    if (actions) config.bbar = actions.bbar;
  },
  //~ constructor : function(ww,config,params){
    //~ this.containing_window = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  do_when_clean : function(auto_save,todo) { todo() },
  //~ format_data : function(html) { return '<div class="htmlText">' + html + '</div>' },
  format_data : function(html) { return html },
  get_base_params : function() {
    // needed for insert action
    var p = Ext.apply({}, this.base_params);
    Lino.insert_subst_user(p);
    return p;
  },
  set_base_params : function(p) {
    this.base_params = Ext.apply({},p);
    //~ if (p.param_values) this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  },
  set_base_param : function(k,v) {
    this.base_params[k] = v;
  }
};



Lino.HtmlBoxPanel = Ext.extend(Ext.Panel, Lino.PanelMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel, Lino.FieldBoxMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel, {
  disabled_in_insert_window : true,
  constructor : function(config,params) {
    this.before_init(config,params);
    Lino.HtmlBoxPanel.superclass.constructor.call(this, config);
  },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.constructor.call(this, ww,config,params);
  //~ },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  //~ disable : function() { var tb = this.getBottomToolbar(); if(tb) tb.disable()},
  //~ enable : function() { var tb = this.getBottomToolbar(); if(tb) tb.enable()},
  onRender : function(ct, position){
    Lino.HtmlBoxPanel.superclass.onRender.call(this, ct, position);
    //~ console.log(20111125,this.containing_window);
    if (this.containing_panel) {
      this.containing_panel.on('enable',this.enable,this);
      this.containing_panel.on('disable',this.disable,this);
    }
    this.el.on({
      dragenter:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        return true;
      }
      ,dragover:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        event.stopEvent();
        return true;
      }
      ,drop:{
        scope:this
        ,fn:function(event){
          event.stopEvent();
          //~ console.log(20110516);
          var files = event.browserEvent.dataTransfer.files;
          if(files === undefined){
            return true;
          }
          var len = files.length;
          while(--len >= 0){
            console.log(files[len]);
            //~ this.processDragAndDropFileUpload(files[len]);
          }
          Lino.show_insert(this);
        }
      }
    });
  },
  refresh : function(unused) { 
      // this.containing_panel.refresh();
      this.refresh_with_after();
  },
  /* HtmlBoxPanel */
  refresh_with_after : function(after) {
      // var todo = this.containing_panel.refresh();
      var box = this.items.get(0);
      var todo = function() {
        if (this.disabled) { return; }
        this.set_base_params(this.containing_panel.get_master_params());

        var el = box.getEl();
        if (el) {
            var record = this.containing_panel.get_current_record();
            var newcontent = record ? 
                this.format_data(record.data[this.name]) : '';
            // console.log('20140917 HtmlBox.refresh()',
            //             this.name, record.data.LinksByHuman);
            el.update(newcontent, true);
        // } else {
        //     console.log('20140502 cannot HtmlBox.refresh()',this.name);
        }
      };

      Lino.do_when_visible(box, todo.createDelegate(this));
  }
});
//~ Ext.override(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);



Lino.RichTextPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,Lino.FieldBoxMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,{
    
  //~ initComponent : function(){
    //~ Lino.RichTextPanel.superclass.initComponent.call(this);
  //~ },
  constructor : function(config,params) {
    //~ console.log('Lino.RichTextPanel.initComponent',this);
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + String(rec.id) + "/" + config.name;
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + config.name;
    var t = this;
    var tinymce_options = {
        theme : "advanced",
        content_css: '/media/lino/extjs/lino.css',
        language: 'en',
        //~ template_external_list_url : url,
        theme_advanced_toolbar_location : "top",
        theme_advanced_toolbar_align : "left",
        theme_advanced_statusbar_location : "bottom",
        template_popup_width : 700,
        template_popup_height : 500,
        template_replace_values : { 
            data_field : function(element){ 
                //~ console.log(20110722,fieldName,t.containing_window.get_current_record()); 
                var fieldName = element.innerHTML;
                element.innerHTML = t.containing_panel.get_current_record().data[fieldName];
            } 
        }
      };
      
    var editorConfig = {
      tinymceSettings: {
        plugins : "noneditable,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "bold,italic,underline,|,justifyleft,justifycenter,justifyright,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,removeformat,template",
        theme_advanced_buttons2 : "",
        theme_advanced_buttons3 : "", // ,|,sub,sup,|,charmap",      
        theme_advanced_resizing : false
        //~ save_onsavecallback : save_callback,
        //~ save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
        
    }};
    Ext.apply(editorConfig.tinymceSettings,tinymce_options);
    //~ editorConfig.name = config.action_name;
    editorConfig.name = config.name;
    delete config.name;
    //~ config.title = config.label;
    //~ delete config.label;
    this.before_init(config,params);
    
    this.editor = new Ext.ux.TinyMCE(editorConfig);
    var t = this;
    config.tools = [{
                      qtip: "Text in eigenem Fenster bearbeiten", 
                      id: "up",
                      handler: function(){
                        if(t.editor.isDirty()) {
                            var record = t.containing_panel.get_current_record();
                            record.data[t.editor.name] = t.editor.getValue();
                        }
                        Lino.edit_tinymce_text(t, tinymce_options)
                      }
                    }];
    
    config.items = this.editor;
    config.layout = "fit";
    Lino.RichTextPanel.superclass.constructor.call(this, config);
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  /* RichTextPanel */
  refresh_with_after : function(after) {
    var record = this.containing_panel.get_current_record();
    // console.log('20140504 RichTextPanel.refresh()',
    //             this.title,record.title, record);
    var todo = function() {
      if (record) {
        var url = '/templates' 
              + this.containing_panel.ls_url + "/" 
              + String(record.id) + "/" + this.editor.name;
        //~ console.log('RichTextPanel.refresh()',url);
        if (this.editor.ed) this.editor.ed.settings.template_external_list_url = url;
        this.set_base_params(this.containing_panel.get_master_params());
        //~ var v = record ? this.format_data(record.data[this.editor.name]) : ''
        var v = this.format_data(record.data[this.editor.name])
        this.editor.setValue(v);
      } else {
        this.editor.setValue('(no data)');
      }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
//~ Ext.override(Lino.RichTextPanel,Lino.FieldBoxMixin);



Lino.ActionFormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel, Lino.PanelMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel, Lino.FieldBoxMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel, {
  //~ layout:'fit'
  //~ ,autoHeight: true
  //~ ,frame: true
  window_title : "Action Parameters",
  constructor : function(config){
    config.bbar = [
        {text: 'OK', handler: this.on_ok, scope: this},
        {text: 'Cancel', handler: this.on_cancel, scope: this}
    ];
    Lino.ActionFormPanel.superclass.constructor.call(this, config);
  }
  //~ ,initComponent : function(){
    //~ Lino.ActionFormPanel.superclass.initComponent.call(this);
  //~ }
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
    var panel = this.requesting_panel;
    // var panel = this.get_containing_window().main_item;
    // console.log("20131004 on_ok",this,panel,arguments);
    var actionName = this.action_name;
    var pk = this.record_id;
    if (pk == undefined && this.base_params) { pk = this.base_params.mk; }
    if (pk == undefined && panel) {
        pk = panel.get_current_record().id;
    }
    if (pk == undefined) {
        Lino.alert("Sorry, dialog action without base_params.mk");
        return;
    }
    var self = this;
    // function on_success() { self.get_containing_window().close(); };
    // see 20131004 and 20140430
    var url = '/api';
    if (panel) 
        url += panel.ls_url;
    else 
        url += this.ls_url;
    url += '/' + pk;
    // prepare possible recursive call
    var fn = function(panel, btn, step) {
      var p = {};
      self.add_field_values(p)
      Lino.call_ajax_action(
          panel, 'GET', url, p, actionName, step, fn); //  , on_success);
    }
    fn(panel, null, null);
    
    
  }
  /* ActionFormPanel*/
  ,set_status : function(status, rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 ActionFormPanel.set_status()',status,rp,this.requesting_panel);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_field_values(status.field_values);
    if (status.base_params) this.set_base_params(status.base_params);
    this.record_id = status.record_id;
  }
  
  ,before_row_edit : function(record) {}
  ,add_field_values : function (p) { // similar to add_param_values()
      //~ 20121023 
      if (this.form.isDirty()) {
        p.fv = this.get_field_values();
      }else{
        if (this.status_field_values) 
          p.fv = Lino.fields2array(this.fields,this.status_field_values);
      }
      //~ if (!this.form.isDirty()) return;
      //~ p.$ext_requests.URL_PARAM_FIELD_VALUES = this.get_field_values();
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
  }
  ,get_field_values : function() {
      return Lino.fields2array(this.fields);
  }
  ,set_field_values : function(pv) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_field_values = pv;
      if (pv) {
          this.form.my_loadRecord(pv);
          var record = { data: pv };
          this.before_row_edit(record);
      } else {
          this.form.reset(); 
          this.before_row_edit();
      }
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.title = this.window_title;
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok }
      ]
      
      if (!wincfg.defaultButton) this.getForm().items.each(function(f){
          if(f.isFormField){ 
              wincfg.defaultButton = f;
              return false;
          }
      });

  }
});

    
Lino.fields2array = function(fields,values) {
    //~ console.log('20130605 fields2array gonna loop on', fields,values);
    var pv = Array(fields.length);
    for(var i=0; i < fields.length;i++) {
        var f = fields[i]
        if (values) 
          var v = values[f.name];
        else 
          var v = f.getValue();
        if (f.formatDate) {
            pv[i] = f.formatDate(v); 
        } else {
            pv[i] = v; // f.getValue(); 
        }
    }
    return pv;
}


Lino.FormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.FormPanel = Ext.extend(Lino.FormPanel,Lino.PanelMixin);
Lino.FormPanel = Ext.extend(Lino.FormPanel,{
  params_panel_hidden : false,
  save_action_name : null, 
  //~ base_params : {},
  //~ trackResetOnLoad : true,
  //~ query_params : {},
  //~ 20110119b quick_search_text : '',
  constructor : function(config,params){
    if (params) Ext.apply(config,params);
    this.base_params = {};
    //~ ww.config.base_params.query = ''; // 20111018
    //~ console.log(config);
    //~ console.log('FormPanel.constructor() 1',config)
    //~ Ext.applyIf(config,{base_params:{}});
    //~ console.log('FormPanel.constructor() 2',config)
      
    config.trackResetOnLoad = true;
    
    Lino.FormPanel.superclass.constructor.call(this, config);
      
    //~ this.set_base_param('$URL_PARAM_FILTER',null); // 20111018
    //~ this.set_base_param('$URL_PARAM_FILTER',''); // 20111018
      
  },
  initComponent : function(){
    
    this.containing_panel = this;

    //~ console.log("20111201 containing_window",this.containing_window,this);


    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    if (actions) {
        this.bbar = actions.bbar;
    //~ } else {
        //~ this.bbar = [];
    }
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ var config = this;
    
    //~ if (this.containing_window instanceof Lino.DetailWrapper) {
    
    //~ console.log('20120121 initComponent', this.action_name);
    //~ if (this.action_name == 'detail' | this.action_name == 'show') {
    //~ if (this.action_name != 'insert') {
    if (! this.hide_top_toolbar) {
      this.tbar = [];
      // 20111015    
      if (! this.hide_navigator) {
        this.record_selector = new Lino.RemoteComboFieldElement({
          store: new Lino.ComplexRemoteComboStore({
            //~ baseParams: this.containing_window.config.base_params,
            baseParams: this.get_base_params(),
            //~ value: this.containing_window.config.base_params.query,
            proxy: new Ext.data.HttpProxy({
              url: '/choices' + this.ls_url,
              method:'GET'
            })
          }),
          pageSize:25,
          listeners: { 
            scope:this, 
            select:function(combo,record,index) {
              //~ console.log('jumpto_select',arguments);
              this.goto_record_id(record.id);
            }
          },
          emptyText: "Gehe zu Datensatz"
        })
        this.tbar = this.tbar.concat([this.record_selector]);
        
        this.tbar = this.tbar.concat([
          this.first = new Ext.Toolbar.Button({
              tooltip:"Erster",disabled:true,
              handler:this.moveFirst,scope:this,iconCls:'x-tbar-page-first'}),
          this.prev = new Ext.Toolbar.Button({
              tooltip:"Voriger",disabled:true,
              handler:this.movePrev,scope:this,iconCls:'x-tbar-page-prev'}),
          this.next = new Ext.Toolbar.Button({
              tooltip:"Nächster",disabled:true,
              handler:this.moveNext,scope:this,iconCls:'x-tbar-page-next'}),
          this.last = new Ext.Toolbar.Button({
              tooltip:"Letzter",disabled:true,
              handler:this.moveLast,scope:this,iconCls:'x-tbar-page-last'})
        ]);
      }
      this.tbar = this.add_params_panel(this.tbar);
      
      //~ console.log(20101117,this.containing_window.refresh);
      this.tbar = this.tbar.concat([
        {
          //~ text:'Refresh',
          handler:function(){ this.do_when_clean(false,this.refresh.createDelegate(this)) },
          iconCls: 'x-tbar-loading',
          tooltip:"Datensatz neu laden",
          scope:this}
      ]);
          
      if (this.bbar) { // since 20121016
        if (this.tbar) {
            this.tbar = this.tbar.concat(['-']) ;
        } else {
          this.tbar = [];
        }
        this.tbar = this.tbar.concat(this.bbar) ;
        this.bbar = undefined;
      }
    
      this.tbar = this.tbar.concat([
          '->',
          this.displayItem = new Ext.Toolbar.TextItem({})
      ]);
          
    }
    //~ if (this.content_type && this.action_name != 'insert') {
      //~ this.bbar = this.bbar.concat([
        //~ '->',
        //~ { text: "[$_('Help Text Editor')]",
          //~ handler: Lino.help_text_editor,
          //~ qtip: "$_('Edit help texts for fields on this model.')",
          //~ scope: this}
      //~ ])
    //~ }
    //~ this.before_row_edit = config.before_row_edit.createDelegate(this);
      
    //~ if (this.master_panel) {
        //~ this.set_base_params(this.master_panel.get_master_params());
    //~ }
      
    Lino.FormPanel.superclass.initComponent.call(this);

    // this.on('show',
    //         function(){ this.init_focus();}, 
    //         this);
    
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.bwrap,{msg:"Bitte warten..."});
    },this);
    
    
    if (this.action_name == 'insert') {
      this.cascade(function(cmp){
        // console.log('20110613 cascade',cmp);
        if (cmp.disabled_in_insert_window) {
            //~ cmp.disable();
            cmp.hide();
        }
      });
      
    }
    
  },
  
  unused_init_focus : function(){ 
    // set focus to the first field
    console.log("20140205 Lino.FormPanel.init_focus");
    // Lino.FormPanel.superclass.focus.call(this);
    this.getForm().items.each(function(f){
        if(f.isFormField && f.rendered){ 
            f.focus();
            console.log("20140205 focus", f);
            return false;
        }
    });
  },

  /* FormPanel */
  get_status : function(){
      var st = {
        base_params: this.get_base_params(),
        // data_record : this.get_current_record()
        }
      st.record_id = this.get_current_record().id;
      // 20140917 : get_status must not store the whole data_record
      // because that would prevent the form to actually reload
      // when set_status is called after a child window closed.
      
      var tp = this.items.get(0);
      if (tp instanceof Ext.TabPanel) {
        st.active_tab = tp.getActiveTab();
      }
      st.param_values = this.status_param_values;
      return st;
  },

  /* FormPanel */
  set_status : function(status, rp){
    this.requesting_panel = Ext.getCmp(rp);
    // console.log('20140917 FormPanel.set_status()', status);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_param_values(status.param_values);
    if (status.base_params) this.set_base_params(status.base_params);
    var tp = this.items.get(0);
    if (tp instanceof Ext.TabPanel) {
      if (status.active_tab) {
        //~ console.log('20111201 active_tab',this.active_tab,this.items.get(0));
        //~ tp.activeTab = status.active_tab;
        tp.setActiveTab(status.active_tab);
        //~ this.main_item.items.get(0).activate(status.active_tab);
      } else {
        if (! status.data_record) {  // 20141206
            tp.setActiveTab(0);
        }
      }
    }
    
    if (status.data_record) {
      /* defer because set_window_title() didn't work otherwise */
      // 20140421 removed defer for bughunting to simplify side effects
      // this.set_current_record.createDelegate(
      //     this, [status.data_record]).defer(100);
      this.set_current_record(status.data_record);
      //~ return;
    } else if (status.record_id != undefined) { 
      /* possible values include 0 and null, 0 being a valid record id, 
      null the equivalent of undefined
      */
      this.load_record_id(status.record_id);
    } else {
      this.set_current_record(undefined);
    }
    // this.init_focus()
  }
  ,get_base_params : function() {  /* FormPanel */
    // needed for insert_action
    var p = Ext.apply({}, this.base_params);
    Lino.insert_subst_user(p);
    return p;
  }
  ,set_base_params : function(p) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    delete p['query'] // 20120725
    Ext.apply(this.base_params,p);
    if (this.record_selector) {
        var store = this.record_selector.getStore();
        for (k in p) store.setBaseParam(k,p[k]);
        delete this.record_selector.lastQuery;
        //~ console.log("20120725 record_selector.setBaseParam",p)
    }
  }
  ,clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  }
  ,set_base_param : function(k,v) {
    this.base_params[k] = v;
  }
  ,after_delete : function() {
    if (this.current_record.navinfo.next)
      this.moveNext();
    else if (this.current_record.navinfo.prev)
      this.movePrev();
    else 
      this.abandon();
  }
  ,moveFirst : function() {this.goto_record_id(
      this.current_record.navinfo.first)}
  ,movePrev : function() {this.goto_record_id(
      this.current_record.navinfo.prev)}
  ,moveNext : function() {this.goto_record_id(
      this.current_record.navinfo.next)}
  ,moveLast : function() {this.goto_record_id(
      this.current_record.navinfo.last)}
  
  ,refresh : function(unused) { 
      this.refresh_with_after();
  }
  /* FormPanel */
  ,refresh_with_after : function(after) { 
    // console.log('20140917 Lino.FormPanel.refresh_with_after()',this);
    if (this.current_record) {
        this.load_record_id(this.current_record.id, after);
    } else {
        this.set_current_record(undefined, after);
    }
  }
  
  ,do_when_clean : function(auto_save, todo) {
    var this_ = this;
    if (this.form.isDirty()) {
        // console.log('20140421 do_when_clean : form is dirty')
        if (auto_save) {
            this_.save(todo);
        } else {
          //~ console.log('20111217 do_when_clean() form is dirty',this.form);
          var config = {title:"Bestätigung"};
          config.buttons = Ext.MessageBox.YESNOCANCEL;
          config.msg = "Änderungen in diesem Datensatz speichern?";
          config.fn = function(buttonId,text,opt) {
            //~ console.log('do_when_clean',buttonId)
            if (buttonId == "yes") {
                //~ Lino.submit_detail(this_,undefined,todo);
                //~ this_.containing_window.save(todo);
                this_.save(todo);
            } else if (buttonId == "no") { 
              todo();
            }
          }
        }
        Ext.MessageBox.show(config);
    }else{
      // console.log('20140421 do_when_clean : now!')
      todo();
    }
  }
  
  ,goto_record_id : function(record_id) {
    // console.log('20140917 Lino.FormPanel.goto_record_id()',record_id);
    //~ var this_ = this;
    //~ this.do_when_clean(function() { this_.load_record_id(record_id) }
    this.do_when_clean(
        true, this.load_record_id.createDelegate(this, [record_id]));
  }
  
  ,load_record_id : function(record_id, after) {
    var this_ = this;
    var p = Ext.apply({}, this.get_base_params());
    if (this.action_name)
        p.an = this.action_name;
    p.rp = this.getId();
    p.fmt = 'json';
    this.add_param_values(p);
    if (this.loadMask) this.loadMask.show();
    Ext.Ajax.request({ 
      waitMsg: 'Loading record...',
      method: 'GET',
      params: p,
      scope: this,
      url: this.get_record_url(record_id),
      success: function(response) {   
        // todo: convert to Lino.action_handler.... but result 
        if (this.loadMask) this.loadMask.hide();
        if (response.responseText) {
          var rec = Ext.decode(response.responseText);
          // console.log('20140917 load_record_id success', rec);
          this.set_param_values(rec.param_values);
          this.set_current_record(rec, after);
        }
      },
      failure: Lino.ajax_error_handler(this)
    });
  }

  ,abandon : function () {
    Ext.MessageBox.alert('Note',
      "Keine weiteren Datensätze zu sehen. Detail-Fenster wird geschlossen.");
    Lino.close_window();
  }
  
  ,set_current_record : function(record, after) {
    if (this.record_selector) {
        this.record_selector.clearValue();
        // e.g. InsertWrapper FormPanel doesn't have a record_selector
    }
    this.current_record = record;
    if (record) {
      this.enable();
      this.form.my_loadRecord(record.data);
      this.set_window_title(record.title);
      //~ this.getBottomToolbar().enable();
      var da = record.data.disabled_actions;
      if (da) {
          //~ console.log('20120528 disabled_actions =',da,this.getBottomToolbar());
          //~ 20121016 this.getBottomToolbar().items.each(function(item,index,length){
          var tb = this.getTopToolbar();
          if (tb) tb.items.each(function(item,index,length){
              //~ console.log('20120528 ',item.itemId,'-->',da[item.itemId]);
              if (da[item.itemId]) item.disable(); else item.enable();
          });
      };
      if (this.disable_editing | record.data.disable_editing) {
          //~ console.log("20120202 disable_editing",record.title);
          this.form.items.each(function(cmp){
            if (!cmp.always_enabled) cmp.disable();
          },this);
      } else {
          this.form.items.each(function(cmp){
            //~ console.log("20120202",cmp);
            if (record.data.disabled_fields[cmp.name]) cmp.disable();
            else cmp.enable();
          },this);
        
          //~ if (record.data.disabled_fields) {
              //~ for (i = 0; i < record.data.disabled_fields.length; i++) {
                  //~ var flds = this.find('name',record.data.disabled_fields[i]);
                  //~ if (flds.length == 1) { 
                    //~ flds[0].disable(); 
                  //~ }
              //~ }
          //~ }
      };
      if (this.first) {
        if (record.navinfo  && ! this.hide_navigator) {
          this.first.setDisabled(!record.navinfo.first);
          this.prev.setDisabled(!record.navinfo.prev);
          this.next.setDisabled(!record.navinfo.next);
          this.last.setDisabled(!record.navinfo.last);
          this.displayItem.setText(record.navinfo.message);
        } else {
          this.first.setDisabled(true);
          this.prev.setDisabled(true);
          this.next.setDisabled(true);
          this.last.setDisabled(true);
        }
      }
    } else {
      if (this.form.rendered) 
        this.form.reset(); /* FileUploadField would fail when resetting a non-rendered form */
      //~ this.disable();
      //~ this.getBottomToolbar().disable();
      this.form.items.each(function(cmp){
        cmp.disable();
      },this);
      this.set_window_title(this.empty_title);
      //~ this.containing_window.window.setTitle(this.empty_title);
      if (!this.hide_navigator) {
        this.first.disable();
        this.prev.disable();
        this.next.disable();
        this.last.disable();
      }
    }
    // console.log('20140917 gonna call before_row_edit', record);
    this.before_row_edit(record);
    // console.log('20140917 gonna call after', after);
    if (after) after();
  },
  
  /* FormPanel */
  before_row_edit : function(record) {},
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.refresh();
  },
  
  get_selected : function() { return [ this.current_record ] },
  get_current_record : function() {  
    //~ console.log(20100714,this.current_record);
    return this.current_record 
  },
  
  get_permalink_url : function() {
      var rec = this.get_current_record();
      if (rec && ! rec.phantom && rec.id != -99998)
          return '/api' 
              + this.ls_url + '/' + rec.id;
      return '/api' + this.ls_url;
    
  },
  add_param_tab : function(p) {
    var main = this.items.get(0);
    if (main.activeTab) {
      var tab = main.items.indexOf(main.activeTab);
      //~ console.log('main.activeTab',tab,main.activeTab);
      if (tab) p.tab = tab;
    }
  },
  get_permalink_params : function() {
    var p = {};
    //~ var p = {an:'detail'};
    if (this.action_name)
        p.an = this.action_name;
    this.add_param_tab(p)
    this.add_param_values(p)
    return p;
  }
  
  ,validate_form : function() {  // not used. see actions.ValidateForm
      // var ov = {};
      // this.form.items.each(function(f){
      //     ov[f.name] = f.originalValue
      // });

      // console.log('20140509 FormPanel.validate_form', ov);
      // var after = function() { 
      //     this.form.items.each(function(f){
      //         f.originalValue = ov[f.name];
      //     });
      // }
      // this.save2(null, 'validate', after);
      this.save2(null, 'validate');
  }

  /* Lino.FormPanel */
  ,save : function(after) {
    var action_name = this.save_action_name;
    if (!action_name) 
        action_name = this.action_name;
    // console.log('20140503 FormPanel.save', action_name);
    this.save2(after, action_name);
  }

  ,save2 : function(after, action_name) {
    var rec = this.get_current_record();
    if (!rec) { 
        Lino.notify("Sorry, no current record."); 
        return; 
    }
    var panel = this;
    if (this.has_file_upload) this.form.fileUpload = true;
    //~ console.log('FormPanel.save()',rec);
    this.loadMask.show();
    var p = {};
    Ext.apply(p, this.get_base_params());
    p.rp = this.getId();
    p.an = action_name;
    this.add_param_tab(p)
    var submit_config = {
        params: p, 
        scope: this,
        success: function(form, action) {
          this.loadMask.hide();
          Lino.notify(action.result.message);
          Lino.handle_action_result(this, action.result, after);
        },
        failure: function(form,action) { 
          this.loadMask.hide();
          Lino.on_submit_failure(form, action);
        },
        clientValidation: true
    };
    if (rec.phantom) {  // it's a new record
      Ext.apply(submit_config, {
        url: '/api' + this.ls_url,
        method: 'POST'
      });
    } else {  // submit on existing row
      Ext.apply(submit_config, {
        url: '/api' 
              + this.ls_url + '/' + rec.id,
        method: 'PUT'
      })
    }
    this.form.submit(submit_config);
  }
  
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
      // console.log("20140424");
      // this.save(null, true, this.save_action_name);
      this.save();
  }
  ,config_containing_window : function(wincfg) { 

      // Note that defaultButton means: which component should receive
      // focus when Window is focussed.  If no defaultButton set,
      // specify the first form field.

      if (!wincfg.defaultButton) this.getForm().items.each(function(f){
          if(f.isFormField){ 
              wincfg.defaultButton = f;
              // console.log("20140205 defaultButton", f);
              return false;
          }
      });

      wincfg.keys = [
          {
              key: Ext.EventObject.ENTER,
              scope:this,
              fn: function(k, e) {
                  if(e.target.type === 'textarea' && !e.ctrlKey) {
                      return true;
                  }
                  this.on_ok();
              }
          },
          { key: Ext.EventObject.ESCAPE, fn: this.on_cancel, scope:this }
          // ,{ key: 's', ctrl: true, 
          //    stopEvent: true,
          //    fn: this.on_ctrl_s, scope:this }
      ]
  }
  
});



Lino.getRowClass = function(record, rowIndex, rowParams, store) {
    //~ console.log(20130816,record);
    //~ return 'x-grid3-row-green';
    //~ return record.data.row_class + ' auto-height';
    return record.data.row_class;
  //~ if (true) {
      //~ return 'x-grid3-row-red';
  //~ }
  //~ if (record.phantom) {
    //~ console.log(20101009,record);
    //~ rowParams.bodyStyle = "color:red;background-color:blue";
    //~ return 'lino-phantom-row';
    //~ }
  //~ console.log('20101009 not a phantom:',record);
  //~ return '';
}

//~ FOO = 0;



Lino.GridStore = Ext.extend(Ext.data.ArrayStore,{ 
  autoLoad: false
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
    if (!options) options = {};
    if (!options.params) options.params = {};
    options.params.fmt = 'json';
    options.params.rp = this.grid_panel.getId();
    Lino.insert_subst_user(options.params); // since 20121016
      
    var start = this.grid_panel.start_at_bottom ? -1 : 0;
    if (this.grid_panel.hide_top_toolbar) {
        //~ console.log("20120206 GridStore.load() toolbar is hidden");
        options.params.start = start;
        if (this.grid_panel.preview_limit) {
          options.params.limit = this.grid_panel.preview_limit;
        }
    } else {
        var ps = this.grid_panel.calculatePageSize();
        if (!ps) {
          // console.log("GridStore.load() failed to calculate pagesize");
          return false;
        } 
        options.params.limit = ps;
      
        this.grid_panel.getTopToolbar().pageSize =  ps;
        if (options.params.start == undefined)
            // if (start != -1) 
            //     start = this.grid_panel.getTopToolbar().cursor
            options.params.start = start;
      
        // console.log("20141108 GridStore.load() ", options.params);
    }
      
    this.grid_panel.add_param_values(options.params);
    //~ Lino.insert_subst_user(options.params);
    //~ console.log("20120814 GridStore.load()",options.params,this.baseParams);
    return Lino.GridStore.superclass.load.call(this, options);
  }
  // ,insert : function(index, records) {
  //   return Ext.data.Store.prototype.insert.call(this, index, records)
    // return Lino.GridStore.superclass.insert.call(this, index, records);
  // }
});

Lino.get_current_grid_config = function(panel) {
    return panel.get_current_grid_config();
}


// Like the default value for GridView.cellTpl but adds a class "lino-auto-height"
Lino.auto_height_cell_template = new Ext.Template(
'<td class="x-grid3-col x-grid3-cell x-grid3-td-{id} {css}" style="{style}" tabIndex="0" {cellAttr}>',
    '<div class="lino-auto-height x-grid3-cell-inner x-grid3-col-{id}" unselectable="on" {attr}>{value}</div>',
'</td>'
);

Lino.GridPanel = Ext.extend(Ext.grid.EditorGridPanel, Lino.MainPanel);
Lino.GridPanel = Ext.extend(Lino.GridPanel, Lino.PanelMixin);
Lino.GridPanel = Ext.extend(Lino.GridPanel, {
  quick_search_text : '',
  start_at_bottom : false,
  is_searching : false,
  disabled_in_insert_window : true,
  clicksToEdit:2,
  enableColLock: false,
  autoHeight: false,
  params_panel_hidden : false,
  preview_limit : undefined, 
  //~ loadMask: true,
  //~ viewConfig: {
          //~ getRowClass: Lino.getRowClass,
          //~ emptyText:"$_('No data to display.')"
        //~ },
        
        
  loadMask: {msg:"Bitte warten..."},
  
  constructor : function(config){

    config.plugins = [new Lino.GridFilters()];
    
    
    Lino.GridPanel.superclass.constructor.call(this,config);
    
    //~ if (this.containing_window) {
        //~ console.log("20111206 install refresh");
        //~ this.containing_window.on('show',this.refresh,this);
    //~ }
    
  },
  
  init_containing_window : function(win) { 
    //~ console.log("20111206 install refresh");
    //~ win.on('show',this.refresh,this);
  }

  ,handle_key_event : function(e) { 
    // console.log("20140514 handle_key_event", e, this.keyhandlers);
    var h = this.keyhandlers[e.keyCode];
    if (h) {
      h(this);
      e.stopEvent();
    }
  }
  
  ,initComponent : function(){
    
    /* 
    Problem 20111206:
    When a GridPanel is the main item of the window, then it doesn't 
    have it's own header but uses the window's header bar.
    We must do this in initComponent because e.g. in beforerender 
    it's already to late: a header element has been created because 
    there was a title.
    But Lino.Window adds itself as `this.containing_window` 
    only after the GridPanel has been initialized.
    Workaround is to generate a line "params.containing_window = true;" 
    in the handler function.
    */ 
    if (this.is_main_window) {
        //~ console.log(20111206, 'delete title',this.title,'from',this);
        this.tools = undefined;  
        this.title = undefined;  /* simply deleting it 
          isn't enough because that would only 
          unhide the title defined in some base class. */
    } 
    //~ else console.log(20111206, 'dont delete title',this.title,'from',this);
    
    /* e.g. when slave gridwindow called from a permalink */
    //~ if (this.base_params) Ext.apply(bp,this.base_params);  
    
    var proxy = new Ext.data.HttpProxy({ 
      // 20120814 
      url: '/api' + this.ls_url
      ,method: "GET"
      //~ ,url: ADMIN_URL + '/restful' + this.ls_url
      //~ ,restful: true 
      //~ ,listeners: {load:on_proxy_load} 
      //~ ,listeners: {write:on_proxy_write} 
    });
    //~ config.store = new Ext.data.JsonStore({ 
    //~ this.store = new Ext.data.ArrayStore({ 
    this.store = new Lino.GridStore({ 
      grid_panel: this
      ,listeners: { exception: Lino.on_store_exception }
      ,remoteSort: true
      ,totalProperty: "count"
      ,root: "rows"
      //~ ,id: "id" 
      ,proxy: proxy
      //~ autoLoad: this.containing_window ? true : false
      ,idIndex: this.pk_index
      //~ ,baseParams: bp
      ,fields: this.ls_store_fields
      ,idProperty: this.ls_id_property 
      // 20120814
      //~ ,writer : new Ext.data.JsonWriter({
        //~ writeAllFields: false
        //~ ,listful: true
      //~ })
      //~ ,restful : true
    });
      
    //~ console.log('config.pk_index',config.pk_index,config.store),
    delete this.ls_store_fields;
      
    var this_ = this;
    //~ var grid = this;
    this.store.on('load', function() {
        //~ console.log('20120814 GridStore.on(load)',this_.store);
        this_.set_param_values(this_.store.reader.arrayData.param_values);
        //~ this_.set_status(this_.store.reader.arrayData.status);
        //~ 20120918
        this.getView().getRowClass = Lino.getRowClass;
        
        if (this_.store.reader.arrayData.no_data_text) {
            //~ this.viewConfig.emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().refresh();
        }
        if (this_.containing_window)
            this_.set_window_title(this_.store.reader.arrayData.title);
            //~ this_.containing_window.setTitle(this_.store.reader.arrayData.title);
        if (!this.is_searching) { // disabled 20121025: quick_search_field may not lose focus
          this.is_searching = false;
          if (this_.selModel.getSelectedCell){
              if (this_.getStore().getCount()) // there may be no data
                  this_.selModel.select(0,0); 
          } else {
              this_.selModel.selectFirstRow();
              this_.getView().focusEl.focus();
          }
        } 
        //~ else console.log("is_searching -> no focussing");
        //~ var t = this.getTopToolbar();
        //~ var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
        //~ this.quick_search_field.focus(); // 20121024
      }, this
    );
    var actions = Lino.build_buttons(this, this.ls_bbar_actions);
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar, this.cmenu = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ this.cmenu = new Ext.menu.Menu({items: config.bbar});
    delete this.ls_bbar_actions
    if (actions) {
        this.cmenu = actions.cmenu;
        this.keyhandlers = actions.keyhandlers;
    }
    
    if (!this.hide_top_toolbar) {  
      var tbar = [ 
        this.quick_search_field = new Ext.form.TextField({ 
          //~ fieldLabel: "Search"
          listeners: { 
            scope:this_
            //~ ,change:this_.search_change
            
            ,render: Lino.quicktip_renderer("Schnellsuche","Hier Text eingeben für Schnellsuche.")
            
            //~ ,keypress: this.search_keypress 
            ,blur: function() { this.is_searching = false}
          }
          ,validator:function(value) { return this_.search_validate(value) }
          //~ ,tooltip: "Enter a quick search text, then press TAB"
          //~ value: text
          //~ scope:this, 
          //~ ,enableKeyEvents: true
          //~ listeners: { keypress: this.search_keypress }, 
          //~ id: "seachString" 
      })];
      tbar = this.add_params_panel(tbar);
      var menu = [];
      var set_gc = function(index) {
        return function() {
          //~ console.log('set_gc() 20100812');
          this.getColumnModel().setConfig(
              this.apply_grid_config(index,this.ls_grid_configs,this.ls_columns));
        }
      }
      for (var i = 0; i < this.ls_grid_configs.length;i++) {
        var gc = this.ls_grid_configs[i];
        menu.push({text:gc.label,handler:set_gc(i),scope:this})
      }
      if(menu.length > 1) {
        tbar = tbar.concat([
          { text:"Ansicht",
            menu: menu,
            tooltip:"Andere Ansicht auswählen"
          }
        ]);
      }
      
      if (actions) {
        tbar = tbar.concat(actions.bbar);
          //~ this.bbar = actions.bbar;
      }
      
      this.tbar = new Ext.PagingToolbar({ 
        store: this.store, 
        prependButtons: true, 
        //~ pageSize: this.page_length, 
        pageSize: 1, 
        displayInfo: true, 
        beforePageText: "Seite",
        afterPageText: "von {0}",
        displayMsg: "Zeilen {0} bis {1} von {2}",
        firstText: "Erste Seite",
        lastText: "Letzte Seite",
        prevText: "Vorige Seite",
        nextText: "Nächste Seite",
        items: tbar
      });
    }
      
    if (this.cell_edit) {
      this.selModel = new Ext.grid.CellSelectionModel()
      this.get_selected = function() {
        //~ console.log(this.getSelectionModel().selection);
        if (this.selModel.selection)
            return [ this.selModel.selection.record ];
        return [this.store.getAt(0)];
      };
      this.get_current_record = function() { 
        if (this.getSelectionModel().selection) 
          return this.selModel.selection.record;
        return this.store.getAt(0);
      };
    } else { 
      this.selModel = new Ext.grid.RowSelectionModel() 
      this.get_selected = function() {
        var sels = this.selModel.getSelections();
        if (sels.length == 0) sels = [this.store.getAt(0)];
        return sels
      };
      this.get_current_record = function() { 
        var rec = this.selModel.getSelected();
        if (rec == undefined) rec = this.store.getAt(0);
        return rec
      };
    };
    this.columns  = this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns);
    
    Lino.GridPanel.superclass.initComponent.call(this);
    
    this.on('resize', function(){
      //~ console.log("20120213 resize",arguments)
      this.refresh();
      },this);
    this.on('viewready', function(){
      //~ console.log("20120213 resize",arguments);
      this.view_is_ready = true;
      this.refresh(); // removed 20130911
      },this);
    this.on('afteredit', this.on_afteredit); // 20120814
    this.on('beforeedit', this.on_beforeedit);
    this.on('beforeedit',function(e) { this.before_row_edit(e.record)},this);
    if (this.cell_edit) {
        this.on('cellcontextmenu', Lino.cell_context_menu, this);
    } else {
        this.on('rowcontextmenu', Lino.row_context_menu, this);
    }
    //~ this.on('contextmenu', Lino.grid_context_menu, this);
    
    delete this.cell_edit;
    
  },
  
  //~ onResize : function(){
      //~ console.log("20120206 GridPanel.onResize",arguments);
      //~ Lino.GridPanel.superclass.onResize.apply(this, arguments);
      //~ this.refresh();
  //~ },
  
  
  get_status : function(){
    var st = { base_params : this.get_base_params()};
    if (!this.hide_top_toolbar) {
        st.current_page = this.getTopToolbar().current;
    }
    st.param_values = this.status_param_values;
    //~ console.log("20120213 GridPanel.get_status",st);
    return st;
  },
  
  /* 
  Lino.GridPanel.set_status() 
  */
  set_status : function(status, rp){
    this.requesting_panel = Ext.getCmp(rp);
    // console.log("20140527 GridPanel.set_status", status);
    this.clear_base_params();
    if (status == undefined) status = {base_params:{}};
    this.set_param_values(status.param_values);
    if (status.base_params) { 
      this.set_base_params(status.base_params);
    }
    if (status.show_params_panel != undefined) {
        if (this.toggle_params_panel_btn) {
            //~ this.toggle_params_panel_btn.toggle(status.show_params_panel=='true');
            this.toggle_params_panel_btn.toggle(status.show_params_panel);
        }
    }
    if (!this.hide_top_toolbar) {
      //~ console.log("20120213 GridPanel.getTopToolbar().changePage",
          //~ status.current_page || 1);
      this.getTopToolbar().changePage(status.current_page || 1);
    }
    //~ this.fireEvent('resize');
    //~ this.refresh.defer(100,this); 
    //~ this.onResize.defer(100,this); 
    //~ this.refresh(); 
    //~ this.doLayout(); 
    //~ this.onResize(); 
    //~ this.store.load();
  },
  
  refresh : function(unused) { 
    this.refresh_with_after();
  },
  /* GridPanel */
  refresh_with_after : function(after) { 
    // console.log('20140504 Lino.GridPanel.refresh '+ this.store.proxy.url);
    //~ var bp = { fmt:'json' }
    if (! this.view_is_ready) return;
    
    if (this.containing_panel) {
        //~ Ext.apply(p,this.master_panel.get_master_params());
        //~ Ext.apply(options.params,this.containing_panel.get_master_params());
        this.set_base_params(this.containing_panel.get_master_params());
        // 20130911
        if (!this.store.baseParams.mk) {  
            return;
        }
    }
    
    //~ console.log('20130911 Lino.GridPanel.refresh_with_after',this.containing_panel.get_master_params());
    
    var options = {};
    if (after) {
        options.callback = function(r,options,success) {if(success) after()}
    }
      
    //~ if (!this.rendered) {
        //~ console.log("20120206 GridPanel.refresh() must wait until rendered",options);
        //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
        //~ return;
    //~ }
    
    this.store.load(options);
  },
  
  /* pageSize depends on grid height (Trying to remove scrollbar)
  Thanks to 
  - Christophe Badoit on http://www.sencha.com/forum/showthread.php?82647
  - http://www.sencha.com/forum/archive/index.php/t-37231.html
  */
  calculatePageSize : function(second_attempt) {
    //~ if (!this.rendered) { 
    if (!this.view_is_ready) { 
      //~ console.log('Cannot calculatePageSize() : not rendered');
      return false; }
    //~ if (!this.isVisible()) { 
      //~ console.log('calculatePageSize : not visible');
      //~ return false; }
      
    //~ console.log('getFrameHeight() is',this.getFrameHeight());
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('mainBody.getHeight() is',this.getView().mainBody.getHeight());
    //~ console.log('getInnerHeight() is',this.getInnerHeight());
    //~ console.log('getHeight() is',this.getHeight());
    //~ console.log('el.getHeight() is',this.getEl().getHeight());
    //~ console.log('getGridEl().getHeight() is',this.getGridEl().getHeight());
    //~ console.log('getOuterSize().height is',this.getOuterSize().height);
    //~ console.log('getBox().height is',this.getBox().height);
    //~ console.log('getResizeEl.getHeight() is',this.getResizeEl().getHeight());
    //~ console.log('getLayoutTarget().getHeight() is',this.getLayoutTarget().getHeight());
      
    //~ var rowHeight = 52; // experimental value
    var row = this.view.getRow(0);
    if (row) {
      //~ console.log('20120213 yes');
      var rowHeight = Ext.get(row).getHeight();
    } else {
        //~ var rowHeight = this.getFrameHeight();
        //~ var rowHeight = 10; // reasonably smallest approximative value
        //~ There is no data yet. Construct a fake row and get its height
        var Element = Ext.Element;
        var gv = this.view;
        var fakeBody = new Element(Element.fly(gv.scroller).child('div.x-grid3-body'));
        var rowTemplate = gv.templates.row;
        var cellTemplate = gv.templates.cell;
        var tstyle  = 'width:' + gv.getGridInnerWidth() + 'px;';
        var cells = cellTemplate.apply({value:'&#160;'});
        var markup = rowTemplate.apply({
                tstyle: tstyle,
                cols  : 1,
                cells : cells,
                alt   : ''
            });        
        fakeBody.dom.innerHTML = gv.templates.body.apply({rows: markup});
        var row = fakeBody.dom.childNodes[0];
        var rowHeight = Ext.get(row).getHeight();
    }
    //~ console.log('rowHeight is ',rowHeight,this,caller);
    //~ this.getView().syncScroll();
    //~ this.getView().initTemplates();
    var height = this.getView().scroller.getHeight();
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('getInnerHeight() - getFrameHeight() is',
      //~ this.getInnerHeight(), '-',
      //~ this.getFrameHeight(), '=',
      //~ this.getInnerHeight() - this.getFrameHeight());
    //~ var height = this.getView().mainBody.getHeight();
    //~ var height = this.getView().mainWrap.getHeight();
    //~ var height = this.getView().resizeMarker.getHeight();
    //~ this.syncSize();
    //~ var height = this.getInnerHeight() - this.getFrameHeight();
    //~ var height = this.getHeight() - this.getFrameHeight();
    height -= Ext.getScrollBarWidth(); // leave room for a possible horizontal scrollbar... 
    //~ height -= this.getView().scrollOffset;
    var ps = Math.floor(height / rowHeight);
    //~ console.log('20130816 calculatePageSize():',height,'/',rowHeight,'->',ps);
    ps -= 1; // leave room for a possible phantom row
    //~ return (ps > 1 ? ps : false);
    if (ps > 1) return ps;
    //~ console.log('calculatePageSize() found less than 1 row:',height,'/',rowHeight,'->',ps);
    //~ foo.bar = baz; // 20120213
    return 5; // preview_limit
    //~ if (second_attempt) {
        //~ console.log('calculatePageSize() abandons after second attempt:',
          //~ height,'/',rowHeight,'->',ps);
      //~ return 5;
    //~ }
    //~ return this.calculatePageSize.defer(500,this,[true]);
  },
  
  onCellDblClick : function(grid, row, col){
      //~ console.log("20120307 onCellDblClick",this,grid, row, col);
      if (this.ls_detail_handler) {
          //~ Lino.notify('show detail');
          Lino.show_detail(this);
          return false;
      }else{
        //~ console.log('startEditing');
        this.startEditing(row,col);
      }
  }
  ,get_base_params : function() {  /* Lino.GridPanel */
    var p = Ext.apply({}, this.store.baseParams);
    Lino.insert_subst_user(p);
    return p;
  },
  set_base_params : function(p) {
    //~ console.log('20130911 GridPanel.set_base_params',p)
    for (k in p) this.store.setBaseParam(k,p[k]);
    //~ this.store.baseParams = p;
    if (this.quick_search_field)
      this.quick_search_field.setValue(p.query || "");
    //~ if (p.param_values) 
        //~ this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.store.baseParams = {};
      Lino.insert_subst_user(this.store.baseParams);
  },
  set_base_param : function(k,v) {
    this.store.setBaseParam(k,v);
  },
  
  //~ get_permalink_params : function() {
    //~ var p = {};
    //~ return p;
  //~ },
  
  before_row_edit : function(record) {},
    
  //~ search_keypress : function(){
    //~ console.log("2012124 search_keypress",arguments);
  //~ },
  search_validate : function(value) {
    if (value == this.quick_search_text) return true;
    this.is_searching = true;
    //~ console.log('search_validate',value)
    this.quick_search_text = value;
    this.set_base_param('query',value); 
    //~ this.getTopToolbar().changePage(1);
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
    return true;
  },
  
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
  },
  
  apply_grid_config : function(index,grid_configs,rpt_columns) {
    //~ var rpt_columns = this.ls_columns;
    var gc = grid_configs[index];    
    //~ console.log('apply_grid_config() 20100812',name,gc);
    this.gc_name = index;
    if (gc == undefined) {
      return rpt_columns;
      //~ config.columns = config.ls_columns;
      //~ return;
    } 
    //~ delete config.ls_filters
    
    //~ console.log(20100805,config.ls_columns);
    var columns = Array(gc.columns.length);
    for (var j = 0; j < rpt_columns.length;j++) {
      var col = rpt_columns[j];
      for (var i = 0; i < gc.columns.length; i++) {
        if (col.dataIndex == gc.ci[i]) {
          col.width = gc.cw[i];
          col.hidden = gc.ch[i];
          columns[i] = col;
          break;
        }
      }
    }
    
    //~ var columns = Array(rpt_columns.length);
    //~ for (var i = 0; i < rpt_columns.length; i++) {
      //~ columns[i] = rpt_columns[gc.columns[i]];
      //~ columns[i].width = gc.widths[i];
    //~ }
    
    //~ if (gc.hidden_cols) {
      //~ for (var i = 0; i < gc.hidden_cols.length; i++) {
        //~ var hc = gc.hidden_cols[i];
        //~ for (var j = 0; j < columns.length;j++) {
          //~ var col = columns[j];
          //~ if (col.dataIndex == hc) {
            //~ col.hidden = true;
            //~ break
          //~ }
        //~ }
      //~ }
    //~ }
    if (gc.filters) {
      //~ console.log(20100811,'config.ls_filters',config.ls_filters);
      //~ console.log(20100811,'config.ls_grid_config.filters',config.ls_grid_config.filters);
      for (var i = 0; i < gc.filters.length; i++) {
        var fv = gc.filters[i];
        for (var j = 0; j < columns.length;j++) {
          var col = columns[j];
          if (col.dataIndex == fv.field) {
            //~ console.log(20100811, f,' == ',fv);
            if (fv.type == 'string') {
              col.filter.value = fv.value;
              //~ if (fv.comparison !== undefined) f.comparison = fv.comparison;
            } else {
              //~ console.log(20100811, fv);
              col.filter.value = {};
              col.filter.value[fv.comparison] = fv.value;
            }
            break;
          }
        };
      }
    }
    
    return columns;
    //~ config.columns = cols;
    //~ delete config.ls_columns
  },
  
  get_current_grid_config : function () {
    var cm = this.getColumnModel();
    var widths = Array(cm.config.length);
    var hiddens = Array(cm.config.length);
    //~ var hiddens = Array(cm.config.length);
    var columns = Array(cm.config.length);
    //~ var columns = Array(cm.config.length);
    //~ var hidden_cols = [];
    //~ var filters = this.filters.getFilterValues();
    var p = this.filters.buildQuery(this.filters.getFilterData())
    for (var i = 0; i < cm.config.length; i++) {
      var col = cm.config[i];
      columns[i] = col.dataIndex;
      //~ hiddens[i] = col.hidden;
      widths[i] = col.width;
      hiddens[i] = col.hidden;
      //~ if (col.hidden) hidden_cols.push(col.dataIndex);
    }
    //~ p['hidden_cols'] = hidden_cols;
    p.cw = widths;
    p.ch = hiddens;
    p.ci = columns;
    //~ p['widths'] = widths;
    //~ p['hiddens'] = hiddens;
    //~ p['columns'] = columns;
    p['name'] = this.gc_name;
    //~ var gc = this.ls_grid_configs[this.gc_name];
    //~ if (gc !== undefined) 
        //~ p['label'] = gc.label
    //~ console.log('20100810 save_grid_config',p);
    return p;
  },
  
  unused_manage_grid_configs : function() {
    var data = [];
    for (k in this.ls_grid_configs) {
      var v = this.ls_grid_configs[k];
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i)
    }
    if (this.ls_grid_configs[this.gc_name] == undefined) {
      var v = this.get_current_grid_config();
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i);
    }
    //~ console.log(20100811, data);
    var main = new Ext.grid.GridPanel({
      store: new Ext.data.ArrayStore({
        idIndex:0,
        fields:['name','columns','hidden_cols','filters'],
        autoDestroy:true,
        data: data}),
      //~ autoHeight:true,
      selModel: new Ext.grid.RowSelectionModel(),
      listeners: { 
        rowdblclick: function(grid,rowIndex,e) {
          console.log('row doubleclicked',grid, rowIndex,e);
        },
        rowclick: function(grid,rowIndex,e) {
          console.log('row clicked',grid, rowIndex,e);
        }
      },
      columns: [ 
        {dataIndex:'name',header:'Name'}, 
        {dataIndex:'columns',header:'columns'}, 
        {dataIndex:'hidden_cols',header:'hidden columns'}, 
        {dataIndex:'filters',header:'filters'} 
      ]
    });
    var win = new Ext.Window({title:'GridConfigs Manager',layout:'fit',items:main,height:200});
    win.show();
  },
  
  unused_edit_grid_config : function(name) {
    gc = this.ls_grid_configs[name];
    var win = new Ext.Window({
      title:'Edit Grid Config',layout:'vbox', 
      //~ layoutConfig:'stretch'
      items:[
        {xtype:'text', value: gc.name},
        {xtype:'text', value: gc.columns},
        {xtype:'text', value: gc.hidden_cols},
        {xtype:'text', value: gc.filters}
      ]
    });
    win.show();
  },
  
  unused_save_grid_config : function () {
    //~ console.log('TODO: save_grid_config',this);
    //~ p.column_widths = Ext.pluck(this.colModel.columns,'width');
    var a = { 
      params:this.get_current_grid_config(), 
      method:'PUT',
      url:'/grid_config' + this.ls_url,
      success: Lino.action_handler(this),
      scope: this,
      failure: Lino.ajax_error_handler(this)
    };
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(a);
    //~ Lino.do_action(this,a);
  },
  
  on_beforeedit : function(e) {
    //~ console.log('20130128 GridPanel.on_beforeedit()',e,e.record.data.disable_editing);
    if(this.disable_editing | e.record.data.disable_editing) {
      e.cancel = true;
      Lino.notify("Dieser Datensatz ist deaktiviert");
      return;
    }
    if(e.record.data.disabled_fields && e.record.data.disabled_fields[e.field]) {
      e.cancel = true;
      Lino.notify("Dieses Feld ist deaktiviert");
      return;
    }
    //~ if (e.record.data.disabled_fields) {
      //~ for (i in e.record.data.disabled_fields) {
        //~ if(e.record.data.disabled_fields[i] == e.field) {
          //~ e.cancel = true;
          //~ Lino.notify(String.format('Field "{0}" is disabled for this record',e.field));
          //~ return
        //~ }
      //~ }
    //~ }
  },
  save_grid_data : function() {
      //~ console.log("20120814 save_grid_data");
      this.getStore().commitChanges();
  },
  on_afteredit : function(e) {
    /*
    e.grid - The grid that fired the event
    e.record - The record being edited
    e.field - The field name being edited
    e.value - The value being set
    e.originalValue - The original value for the field, before the edit.
    e.row - The grid row index
    e.column - The grid column index
    */
    var p = {};
    // console.log('20140403 afteredit: ',e.record);
    //~ console.log('20101130 value: ',e.value);
    //~ var p = e.record.getChanges();
    //~ console.log('20101130 getChanges: ',e.record.getChanges());
    //~ this.before_row_edit(e.record);

    for(k in e.record.getChanges()) {
        var v = e.record.get(k);
    //~ for(k in e.record.modified) {
        //~ console.log('20101130',k,'=',v);
        //~ var cm = e.grid.getColumnModel();
        //~ var di = cm.getDataIndex(k);
        var f = e.record.fields.get(k);
        //~ console.log('20101130 f = ',f);
        //~ var v = e.record.get(di);
        if (f.type.type == 'date') {
            p[k] = Ext.util.Format.date(v, f.dateFormat);
        }else{
            p[k] = v;
            var v = e.record.get(k+'Hidden');
            if (v !== undefined) {
              p[k+'Hidden'] = v;
            }
        }
    }
    // add value used by ForeignKeyStoreField CHOICES_HIDDEN_SUFFIX
    // not sure whether this is still needed:
    p[e.field+'Hidden'] = e.value;
    //~ p.su = Lino.subst_user;
    Lino.insert_subst_user(p);
    // this one is needed so that this field can serve as choice context:
    e.record.data[e.field+'Hidden'] = e.value;
    // p[pk] = e.record.data[pk];
    // console.log("grid_afteredit:",e.field,'=',e.value);
    Ext.apply(p, this.get_base_params()); // needed for POST, ignored for PUT
    //~ Ext.apply(p,this.containing_window.config.base_params);
    //~ 20121109 p['$ext_requests.URL_PARAM_ACTION_NAME'] = 'grid';
    var self = this;
    var req = {
        params:p,
        waitMsg: 'Saving your data...',
        success: Lino.action_handler( this, function(result) {
          // console.log("20140728 afteredit.success got ", result);
          //~ if (result.data_record) {
          if (result.refresh_all) {
              var cw = self.get_containing_window();
              if (cw) {
                  cw.main_item.refresh();
              }
              else console.log("20120123 cannot refresh_all",self);
          } else if (result.rows) {
              //~ self.getStore().loadData(result,true);
              var r = self.getStore().reader.readRecords(result);
              if (e.record.phantom) {
                  // console.log("20140728 gonna call Store.insert()", self.getStore(), e.row, r.records);
                  self.getStore().insert(e.row, r.records);
              }else{
                  // console.log("20140728 afteredit.success doUpdate", r.records[0]);
                  self.getStore().doUpdate(r.records[0]);
              }
              self.getStore().rejectChanges(); 
              /* 
              get rid of the red triangles without saving the record again
              */
              //~ self.getStore().commitChanges(); // get rid of the red triangles
          } else {
              self.getStore().commitChanges(); // get rid of the red triangles
              self.getStore().reload();        // reload our datastore.
          }
          }),
        scope: this,
        failure: Lino.ajax_error_handler(this)
    };
    if (e.record.phantom) {
      req.params.an = 'grid_post'; // CreateRow.action_name
      Ext.apply(req,{
        method: 'POST',
        url: '/api' + this.ls_url
      });
    } else {
      req.params.an = 'grid_put'; // SaveRow.action_name
      Ext.apply(req,{
        method: 'PUT',
        url: '/api' + this.ls_url + '/' + e.record.id
      });
    }
    //~ console.log('20110406 on_afteredit',req);
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(req);
  },

  afterRender : function() {
    Lino.GridPanel.superclass.afterRender.call(this);
    // this.getView().mainBody.focus();
    // console.log(20100114,this.getView().getRows());
    // if (this.getView().getRows().length > 0) {
    //  this.getView().focusRow(1);
    // }
    //~ this.my_load_mask = new Ext.LoadMask(this.getEl(), {
        //~ msg:'$_("Please wait...")',
        //~ store:this.store});
      
    var tbar = this.getTopToolbar();
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    // tbar.on('change',function() {this.getSelectionModel().selectFirstRow();this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    this.nav = new Ext.KeyNav(this.getEl(),{
      pageUp: function() {tbar.movePrevious(); },
      pageDown: function() {tbar.moveNext(); },
      home: function() {tbar.moveFirst(); },
      end: function() {tbar.moveLast(); },
      scope: this
    });

  },
  after_delete : function() {
    //~ console.log('Lino.GridPanel.after_delete');
    this.refresh();
  },
  add_row_listener : function(fn,scope) {
    this.getSelectionModel().addListener('rowselect',fn,scope);
  },
  postEditValue : function(value, originalValue, r, field){
    value = Lino.GridPanel.superclass.postEditValue.call(this,value,originalValue,r,field);
    //~ console.log('GridPanel.postEdit()',value, originalValue, r, field);
    return value;
  },
  
  set_start_value : function(v) {
      this.start_value = v;
  },
  preEditValue : function(r, field){
      if (this.start_value) {
        var v = this.start_value;
        delete this.start_value;
        this.activeEditor.selectOnFocus = false;
        return v;
      }
      var value = r.data[field];
      return this.autoEncode && Ext.isString(value) ? Ext.util.Format.htmlDecode(value) : value;
  },
  
  on_master_changed : function() {
    //~ if (! this.enabled) return;
    //~ cmp = this;
    //~ console.log('20130911 Lino.GridPanel.on_master_changed()',this.title,this.rendered);
    if (! this.rendered) return; // 20120213
    var todo = function() {
      if (this.disabled) return;
      //~ if (this.disabled) return;
      //~ if (this.enabled) {
          //~ var src = caller.config.url_data + "/" + record.id + ".jpg"
          //~ console.log(20111125, this.containing_window);
          //~ for (k in p) this.getStore().setBaseParam(k,p[k]);
          //~ console.log('Lino.GridPanel.on_master_changed()',this.title,p);
          this.refresh();
          //~ this.set_base_params(this.master_panel.get_master_params());
          //~ this.getStore().load(); 
      //~ }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  },
  load_record_id : function(record_id,after) {
      Lino.run_detail_handler(this,record_id)
  }
  
});
  

//~ Lino.MainPanelMixin = {
  //~ tbar_items : function() {
      //~ return ;
  //~ }
//~ };

//~ Ext.override(Lino.GridPanel,Lino.MainPanelMixin);
//~ Ext.override(Lino.FormPanel,Lino.MainPanelMixin);

//~ Lino.grid_context_menu = function(e) {
  //~ console.log('contextmenu',arguments);
//~ }

Lino.row_context_menu = function(grid,row,col,e) {
  console.log('20130927 rowcontextmenu',grid,row,col,e,grid.store.reader.arrayData.rows[row]);
}

Lino.cell_context_menu = function(grid,row,col,e) {
  //~ console.log('20120531 cellcontextmenu',grid,row,col,e,grid.store.reader.arrayData.rows[row]);
  e.stopEvent();
  //~ grid.getView().focusCell(row,col);
  grid.getSelectionModel().select(row,col);
  //~ console.log(grid.store.getAt(row));
  //~ grid.getView().focusRow(row);
  //~ return;
  if(!grid.cmenu.el){grid.cmenu.render(); }
  //~ if(e.record.data.disabled_fields) {
  
  var da = grid.store.reader.arrayData.rows[row][grid.disabled_actions_index];
  if (da) {
      this.cmenu.cascade(function(item){ 
        //~ console.log(20120531, item.itemId, da[item.itemId]);
        if (da[item.itemId]) item.disable(); else item.enable();
      });
  };
  
  var xy = e.getXY();
  xy[1] -= grid.cmenu.el.getHeight();
  grid.cmenu.showAt(xy);
}


Lino.chooser_handler = function(combo,name) {
  return function(cmp,newValue,oldValue) {
    //~ console.log('Lino.chooser_handler()',cmp,oldValue,newValue);
    combo.setContextValue(name,newValue);
  }
};



Lino.ComboBox = Ext.extend(Ext.form.ComboBox,{
  forceSelection: "yes but select on tab",
  // forceSelection: true,
  triggerAction: 'all',
  minListWidth:280, // 20131022
  autoSelect: false,
  selectOnFocus: true, // select any existing text in the field immediately on focus.
  submitValue: true,
  displayField: 'text', // 'text', 
  valueField: 'value', // 'value',
  
  //~ initComponent : Ext.form.ComboBox.prototype.initComponent.createSequence(function() {
  initComponent : function(){
      this.contextParams = {};
      //~ Ext.form.ComboBox.initComponent(this);
      Lino.ComboBox.superclass.initComponent.call(this);
  },
  setValue : function(v,record_data){
      /*
      Based on feature request developed in http://extjs.net/forum/showthread.php?t=75751
      */
      /* `record_data` is used to get the text corresponding to this value */
      //~ if(this.name == 'city') 
      //~ console.log('20120203', this.name,'.setValue(', v ,') this=', this,'record_data=',record_data);
      var text = v;
      if(this.valueField){
        if(v == null || v == '') { 
            //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,'no lookup needed, value is empty');
            //~ v = undefined;
            v = '';
            //~ text = '';
        } else if (Ext.isDefined(record_data)) {
          text = record_data[this.name];
          //~ if (this.name == 'birth_country') 
            //~ console.log(this.name,'.setValue',v,'got text ',text,' from record ',record);
        } else {
          // if(this.mode == 'remote' && !Ext.isDefined(this.store.totalLength)){
          if(this.mode == 'remote' && ( this.lastQuery === null || (!Ext.isDefined(this.store.totalLength)))){
              //~ if (this.name == 'birth_country') console.log(this.name,'.setValue',v,'store not yet loaded');
              this.store.on('load', this.setValue.createDelegate(this, arguments), null, {single: true});
              if(this.store.lastOptions === null || this.lastQuery === null){
                  var params;
                  if(this.valueParam){
                      params = {};
                      params[this.valueParam] = v;
                  }else{
                      var q = this.allQuery;
                      this.lastQuery = q;
                      this.store.setBaseParam(this.queryParam, q);
                      params = this.getParams(q);
                  }
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : call load() with params ',params);
                  this.store.load({params: params});
              //~ }else{
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : but store is loading',this.store.lastOptions);
              }
              return;
          //~ }else{
              //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,' : store is loaded, lastQuery is "',this.lastQuery,'"');
          }
          var r = this.findRecord(this.valueField, v);
          if(r){
              text = r.data[this.displayField];
          }else if(this.valueNotFoundText !== undefined){
              text = this.valueNotFoundText;
          }
        }
      }
      this.lastSelectionText = text;
      //~ this.lastSelectionText = v;
      if(this.hiddenField){
          //~ this.hiddenField.originalValue = v;
          this.hiddenField.value = v;
      }
      Ext.form.ComboBox.superclass.setValue.call(this, text);
      this.value = v; // needed for grid.afteredit
  },
  
  getParams : function(q){
    // p = Ext.form.ComboBox.superclass.getParams.call(this, q);
    // causes "Ext.form.ComboBox.superclass.getParams is undefined"
    var p = {};
    if(this.pageSize){
        p['start'] = 0;
        p['limit'] = this.pageSize;
    }
    // now my code:
    if(this.contextParams) Ext.apply(p, this.contextParams);
    return p;
  },
  setContextValue : function(name,value) {
    //~ console.log('setContextValue',this,this.name,':',name,'=',value);
    //~ if (this.contextValues === undefined) {
        //~ this.contextValues = Array(); // this.contextParams.length);
    //~ }
    if (this.contextParams[name] != value) {
      //~ console.log('setContextValue 1',this.contextParams);
      this.contextParams[name] = value;
      this.lastQuery = null;
      //~ console.log('setContextValue 2',this.contextParams);
    }
  }
});

Lino.ChoicesFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'local'
});


Lino.SimpleRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  // forceSelection: true,  20140206 why was this here?
  constructor: function(config){
      Lino.SimpleRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value' ], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.ComplexRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  constructor: function(config){
      Lino.ComplexRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value','text'], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.RemoteComboFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'remote',
  //~ forceSelection:false,
  minChars: 2, // default 4 is too much
  queryDelay: 300, // default 500 is maybe slow
  queryParam: 'query', 
  //~ typeAhead: true,
  //~ selectOnFocus: true, // select any existing text in the field immediately on focus.
  resizable: true
  ,initList : function() {
      Lino.RemoteComboFieldElement.superclass.initList.call(this);
      if (this.pageTb) {
          
          var me = this;
          this.pageTb.on("beforechange", function(toolbar, o){
              if(me.contextParams)
                  Ext.apply(o, me.contextParams);
          });
          
          //~ 
          //~ var btn = ls_buttons
          //~ this.pageTb.items = this.pageTb.items.concat([btn]);
          //~ console.log("20131022 pageTb.items is", this.pageTb.items)
      }
  }
});

/*
Thanks to Animal for posting the basic idea:
http://www.sencha.com/forum/showthread.php?15842-2.0-SOLVED-Combobox-twintrigger-clear&p=76130&viewfull=1#post76130

*/
Lino.TwinCombo = Ext.extend(Lino.RemoteComboFieldElement,{
    trigger2Class : 'x-form-search-trigger',
    //~ trigger2Class : 'x-tbar-detail',
    initComponent : function() {
        //~ Lino.TwinCombo.superclass.initComponent.call(this);
        Lino.ComboBox.prototype.initComponent.call(this);
        Ext.form.TwinTriggerField.prototype.initComponent.call(this);
    },
    onTrigger2Click : function() {
        //~ console.log('onTrigger2Click',this,arguments);
    }
  });
//~ Lino.TwinCombo.prototype.initComponent = Ext.form.TwinTriggerField.prototype.initComponent;
Lino.TwinCombo.prototype.getTrigger = Ext.form.TwinTriggerField.prototype.getTrigger;
Lino.TwinCombo.prototype.getOuterSize = Ext.form.TwinTriggerField.prototype.getOuterSize;
Lino.TwinCombo.prototype.initTrigger = Ext.form.TwinTriggerField.prototype.initTrigger;
Lino.TwinCombo.prototype.onTrigger1Click = Ext.form.ComboBox.prototype.onTriggerClick;
//~ Lino.TwinCombo.prototype.onTrigger2Click = function() {
    //~ console.log('onTrigger2Click',arguments);
//~ };



Lino.SimpleRemoteComboFieldElement = Ext.extend(Lino.RemoteComboFieldElement,{
  displayField: 'value', 
  valueField: null,
  forceSelection: false
});




Lino.Window = Ext.extend(Ext.Window,{
  //~ layout: "fit", 
  closeAction : 'hide',
  renderTo: 'main_area', 
  constrain: true,
  maximized: true,
  draggable: false,
  width: 700,
  height: 500,
  maximizable: false,
  constructor : function (config) {
    if (config.main_item.params_panel) {
        config.layout = 'border';
        config.main_item.region = 'center';
        config.main_item.params_panel.region = 'north';
        //~ config.main_item.params_panel.autoHeight = false; // 20130924
        config.main_item.params_panel.hidden = config.main_item.params_panel_hidden;
        config.items = [config.main_item.params_panel, config.main_item];
        //~ 20130923b
    } else {
        config.layout = 'fit';
        config.items = config.main_item;
    }
    this.main_item = config.main_item; 
    
    delete config.main_item;
    //~ delete config.params_item;
    
    //~ this.main_item = config.items.get(0);
    this.main_item.containing_window = this;
    
    //~ console.log('20120110 Lino.Window.constructor() 1');
    //~ if (Lino.current_window) { // all windows except the top are closable
    if (this.main_item.hide_window_title) { 
      config.closable = false;
      config.frame = false;
      config.shadow = false;
      //~ config.border = true;
      //~ config.title = undefined;
      //~ config.tools = null;
      delete config.title;
      delete config.tools;
    } else {
      config.title = this.main_item.empty_title;
      config.closable = true;
      config.tools = [ 
        { qtip: 'permalink', handler: Lino.permalink_handler(this), id: "pin" }
      ];
      if (this.main_item.content_type && this.main_item.action_name != 'insert') {
        config.tools = [ {
          handler: Lino.help_text_editor,
          qtip: "Hilfetexte der Eingabefelder dieser Tabelle bearbeiten",
          scope: this.main_item,
          id: "gear"
        }].concat(config.tools);
      }
        
    //~ { qtip: '', handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: this.config.qtip, handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: 'Call doLayout() on main Container.', handler: Lino.refresh_handler(this), id: "refresh" },
    //~ if (this.main_item.params_panel) {
        //~ config.tools = config.tools.concat([ 
          //~ { qtip: 'Show/hide parameter panel', handler: this.toggle_params_panel, id: "gear", scope:this } 
        //~ ]);
    //~ }
    //~ if (config.closable !== false) {
      // if undefined, will take default behaviour
      //~ config.tools = config.tools.concat([ 
        //~ { qtip: 'close', handler: this.hide, id: "close", scope:this } 
      //~ ]);
    }
    
    this.main_item.config_containing_window(config);
    
    //~ console.log('20120110 Lino.Window.constructor() 2');
    Lino.Window.superclass.constructor.call(this,config);
    
    //~ console.log('20120110 Lino.Window.constructor() 3');
    
  },
  initComponent : function() {
    this.main_item.init_containing_window(this);
    Lino.Window.superclass.initComponent.call(this);
  
  },
  hide : function() { 
      this.main_item.do_when_clean(false,function() { 
        Lino.close_window(); });
  },
  hide_really : function() { 
    Lino.Window.superclass.hide.call(this);
  },
  onRender : function(ct, position){
    // console.log('20140829 Lino.Window.onRender() 1');
    Lino.Window.superclass.onRender.call(this, ct, position);
    var main_area = Ext.getCmp('main_area')
    //~ console.log('20120110 Lino.Window.onRender() 2');
  
    this.on('show', function(win) {
        // console.log('20140829 Lino.Window.on(show) : add resize handler');
        main_area.on('resize', win.onWindowResize, win);
    });
    this.on('hide', function(win) {
        // console.log('20140829 Lino.Window.on(hide) : remove resize handler');
        main_area.un('resize', win.onWindowResize, win);
    });
    // console.log('20140829 Lino.Window.onRender() 3');
  }
});


Ext.override(Ext.form.BasicForm,{
    my_loadRecord : function(values){
    //~ loadRecord : function(record){
        /* Same as ExtJS's loadRecord() (setValues()), except that we 
        forward also the record to field.setValue() so that Lino.Combobox 
        can use it. 
        */
        //~ console.log('20120918 my_loadRecord',values)
        if(Ext.isArray(values)){ 
            for(var i = 0, len = values.length; i < len; i++){
                var v = values[i];
                var f = this.findField(v.id);
                if(f){
                    f.setValue(v.value,values);
                    if(this.trackResetOnLoad){
                        f.originalValue = f.getValue();
                    }
                }
            }
        }else{ 
            var field, id;
            for(id in values){
                if(!Ext.isFunction(values[id]) && (field = this.findField(id))){
                    field.setValue(values[id],values);
                    if(this.trackResetOnLoad){
                        field.originalValue = field.getValue();
                        //~ if (field.hiddenField) {
                          //~ field.hiddenField.originalValue = field.hiddenField.value;
                        //~ }
                    }
                }
            }
        }
        return this;
    }
});




function initializeFooBarDropZone(cmp) {
    //~ console.log('initializeFooBarDropZone',cmp);
    cmp.dropTarget = new Ext.dd.DropTarget(cmp.bwrap, {
      //~ ddGroup     : 'gridDDGroup',
      notifyEnter : function(ddSource, e, data) {
        console.log('notifyEnter',ddSource,e,data);
        //Add some flare to invite drop.
        cmp.body.stopFx();
        cmp.body.highlight();
      },
      notifyDrop  : function(ddSource, e, data){
        console.log('notifyDrop',ddSource,e,data);
        // Reference the record (single selection) for readability
        //~ var selectedRecord = ddSource.dragData.selections[0];


        // Load the record into the form
        //~ formPanel.getForm().my_loadRecord(selectedRecord);


        // Delete record from the grid.  not really required.
        //~ ddSource.grid.store.remove(selectedRecord);

        return(true);
      }
    })
}



Lino.show_mti_child = function(fieldname,detail_handler) {
  //~ console.log('show_mti_child',this);
  //~ console.log('show_mti_child',panel.find("main_area"));
  rec = Lino.current_window.main_item.get_current_record();
  //~ rec = panel.get_current_record();
  if (rec) {
    //~ console.log('show_mti_child',Lino.current_window,rec);
    if (rec.phantom) {
      Lino.notify('Not allowed on phantom record.');
    }else if (rec.data[fieldname]) {
      //~ console.log('show_mti_child',rec.id);
      //~ detail_handler(Lino.current_window.main_item,{},{record_id:rec.id});
      detail_handler.run(null,{record_id:rec.id});
      //~ window.open(urlroot + '/' + rec.id);
      //~ document.location = urlroot + '/' + rec.id;
      //~ window.open(urlroot + '/' + rec.id,'_blank');
    } else {
      Lino.alert("Kann MTI-Kind nicht anzeigen wenn Checkbox abgeschlatet ist.");
    }
  } else {
    Lino.notify('No current record.');
  }
};


/*
captureEvents utility by Aaron Conran
<http://www.sencha.com/learn/grid-faq/>

Ext.onReady(function(){
    var grid = new Ext.grid.GridPanel({
        ... 
    });
    captureEvents(grid);
});
*/
function captureEvents(observable) {
    Ext.util.Observable.capture(
        observable,
        function(eventName) {
            console.info(eventName);
        },
        this
    );		
}

// settings.SITE.get_plugin_snippets()



Lino.main_menu = [ { "menu": { "items": [ { "text": "Personen", "handler": function() {Lino.contacts.Persons.grid.run(null)} }, { "text": "Organisationen", "handler": function() {Lino.contacts.Companies.grid.run(null)} }, { "text": "Partner", "handler": function() {Lino.contacts.Partners.grid.run(null)} } ] }, "text": "Kontakte" }, { "menu": { "items": [ { "text": "Meine Termine", "listeners": { "render": Lino.quicktip_renderer("Foo","Alle meine Termine") }, "handler": function() {Lino.cal.MyEvents.grid.run(null)} }, { "text": "Meine Aufgaben", "listeners": { "render": Lino.quicktip_renderer("Foo","Alle meine Aufgaben") }, "handler": function() {Lino.cal.MyTasks.grid.run(null)} }, { "text": "Meine G\u00e4ste", "handler": function() {Lino.cal.MyGuests.grid.run(null)} }, { "text": "Meine Anwesenheiten", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows all my presences in calendar events, independently of their state.") }, "handler": function() {Lino.cal.MyPresences.grid.run(null)} } ] }, "text": "Kalender" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "Stale Controllables", "handler": function() {Lino.contenttypes.StaleControllables.grid.run(null)} } ] }, "text": "System" } ] }, "text": "Berichte" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "Hilfetexte", "handler": function() {Lino.contenttypes.HelpTexts.grid.run(null)} }, { "text": "Site-Parameter", "iconCls": "x-tbar-application_form", "handler": function() {Lino.system.SiteConfigs.detail.run(null,{ "record_id": 1 })} }, { "text": "Benutzer", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows the list of all users on this site.") }, "handler": function() {Lino.users.Users.grid.run(null)} } ] }, "text": "System" }, { "menu": { "items": [ { "text": "Meine Einf\u00fcgetexte", "handler": function() {Lino.system.MyTextFieldTemplates.grid.run(null)} } ] }, "text": "B\u00fcro" }, { "menu": { "items": [ { "text": "L\u00e4nder", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    A country is a geographic entity considered a \"nation\".\n    ") }, "handler": function() {Lino.countries.Countries.grid.run(null)} }, { "text": "Orte", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    The table of known geographical places.\n    A geographical place can be a city, a town, a suburb,\n    a province, a lake... any named geographic entity,\n    except for countries because these have their own table.\n    ") }, "handler": function() {Lino.countries.Places.grid.run(null)} } ] }, "text": "Orte" }, { "menu": { "items": [ { "text": "Organisationsarten", "handler": function() {Lino.contacts.CompanyTypes.grid.run(null)} }, { "text": "Funktionen", "handler": function() {Lino.contacts.RoleTypes.grid.run(null)} } ] }, "text": "Kontakte" }, { "menu": { "items": [ { "text": "Kalenderliste", "handler": function() {Lino.cal.Calendars.grid.run(null)} }, { "text": "R\u00e4ume", "listeners": { "render": Lino.quicktip_renderer("Foo","List of rooms where calendar events can happen.") }, "handler": function() {Lino.cal.Rooms.grid.run(null)} }, { "text": "Priorit\u00e4ten", "listeners": { "render": Lino.quicktip_renderer("Foo","List of possible priorities of calendar events.") }, "handler": function() {Lino.cal.Priorities.grid.run(null)} }, { "text": "Periodische Termine", "handler": function() {Lino.cal.RecurrentEvents.grid.run(null)} }, { "text": "Gastrollen", "listeners": { "render": Lino.quicktip_renderer("Foo","The role of a guest expresses what the partner is going to do there.") }, "handler": function() {Lino.cal.GuestRoles.grid.run(null)} }, { "text": "Ereignisarten", "listeners": { "render": Lino.quicktip_renderer("Foo","The list of Event Types defined on this system.\n    An EventType is a list of events which have certain things in common,\n    especially they are displayed in the same colour in the calendar panel") }, "handler": function() {Lino.cal.EventTypes.grid.run(null)} }, { "text": "Externe Kalender", "handler": function() {Lino.cal.RemoteCalendars.grid.run(null)} } ] }, "text": "Kalender" } ] }, "text": "Konfigurierung" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "Datenbankmodelle", "handler": function() {Lino.contenttypes.ContentTypes.grid.run(null)} }, { "text": "Vollmachten", "handler": function() {Lino.users.Authorities.grid.run(null)} }, { "text": "Benutzergruppen", "handler": function() {Lino.users.UserGroups.grid.run(null)} }, { "text": "Benutzer-Levels", "handler": function() {Lino.users.UserLevels.grid.run(null)} }, { "text": "Benutzerprofile", "handler": function() {Lino.users.UserProfiles.grid.run(null)} } ] }, "text": "System" }, { "menu": { "items": [ { "text": "Einf\u00fcgetexte", "handler": function() {Lino.system.TextFieldTemplates.grid.run(null)} } ] }, "text": "B\u00fcro" }, { "menu": { "items": [ { "text": "Kontaktpersonen", "handler": function() {Lino.contacts.Roles.grid.run(null)} } ] }, "text": "Kontakte" }, { "menu": { "items": [ { "text": "Aufgaben", "listeners": { "render": Lino.quicktip_renderer("Foo","A calendar task is something you need to do.\n    ") }, "handler": function() {Lino.cal.Tasks.grid.run(null)} }, { "text": "Teilnehmer", "listeners": { "render": Lino.quicktip_renderer("Foo","A guest is a partner invited to an event. ") }, "handler": function() {Lino.cal.Guests.grid.run(null)} }, { "text": "Abonnements", "handler": function() {Lino.cal.Subscriptions.grid.run(null)} }, { "text": "Termin-Zust\u00e4nde", "listeners": { "render": Lino.quicktip_renderer("Foo","The possible states of a calendar event.") }, "handler": function() {Lino.cal.EventStates.grid.run(null)} }, { "text": "Gast-Zust\u00e4nde", "handler": function() {Lino.cal.GuestStates.grid.run(null)} }, { "text": "Aufgaben-Zust\u00e4nde", "handler": function() {Lino.cal.TaskStates.grid.run(null)} } ] }, "text": "Kalender" } ] }, "text": "Explorer" }, { "menu": { "items": [ { "text": "Info", "listeners": { "render": Lino.quicktip_renderer("Foo","Zeigt Informationen \u00fcber diese Site an.") }, "handler": function() {Lino.about.About.show.run(null,{ "record_id": -99998 })} } ] }, "text": "Site" }, { "text": "Startseite", "handler": function() {Lino.handle_home_button()} } ];
Ext.namespace('Lino.contenttypes.ContentTypes')
Ext.namespace('Lino.contenttypes.HelpTexts')
Ext.namespace('Lino.system.SiteConfigs')
Ext.namespace('Lino.system.TextFieldTemplates')
Ext.namespace('Lino.users.Users')
Ext.namespace('Lino.users.MySettings')
Ext.namespace('Lino.users.UsersOverview')
Ext.namespace('Lino.users.Authorities')
Ext.namespace('Lino.countries.Countries')
Ext.namespace('Lino.countries.Places')
Ext.namespace('Lino.contacts.CompanyTypes')
Ext.namespace('Lino.contacts.Partners')
Ext.namespace('Lino.contacts.Persons')
Ext.namespace('Lino.contacts.Companies')
Ext.namespace('Lino.contacts.RoleTypes')
Ext.namespace('Lino.contacts.Roles')
Ext.namespace('Lino.cal.RemoteCalendars')
Ext.namespace('Lino.cal.Rooms')
Ext.namespace('Lino.cal.Priorities')
Ext.namespace('Lino.cal.Calendars')
Ext.namespace('Lino.cal.Subscriptions')
Ext.namespace('Lino.cal.Tasks')
Ext.namespace('Lino.cal.MyTasks')
Ext.namespace('Lino.cal.GuestRoles')
Ext.namespace('Lino.cal.Guests')
Ext.namespace('Lino.cal.MyPresences')
Ext.namespace('Lino.cal.MyPendingPresences')
Ext.namespace('Lino.cal.MyGuests')
Ext.namespace('Lino.cal.EventTypes')
Ext.namespace('Lino.cal.RecurrentEvents')
Ext.namespace('Lino.cal.Events')
Ext.namespace('Lino.cal.EventsByDay')
Ext.namespace('Lino.cal.OneEvent')
Ext.namespace('Lino.cal.MyEvents')
Ext.namespace('Lino.cal.MyAssignedEvents')
Ext.namespace('Lino.sessions.SessionTable')
Ext.namespace('Lino.system.MyTextFieldTemplates')
Ext.namespace('Lino.users.AuthoritiesGiven')
Ext.namespace('Lino.users.AuthoritiesTaken')
Ext.namespace('Lino.countries.PlacesByPlace')
Ext.namespace('Lino.countries.PlacesByCountry')
Ext.namespace('Lino.contacts.PartnersByCity')
Ext.namespace('Lino.contacts.PartnersByCountry')
Ext.namespace('Lino.contacts.RolesByCompany')
Ext.namespace('Lino.contacts.RolesByPerson')
Ext.namespace('Lino.cal.SubscriptionsByUser')
Ext.namespace('Lino.cal.SubscriptionsByCalendar')
Ext.namespace('Lino.cal.TasksByUser')
Ext.namespace('Lino.cal.GuestsByEvent')
Ext.namespace('Lino.cal.GuestsByRole')
Ext.namespace('Lino.cal.GuestsByPartner')
Ext.namespace('Lino.cal.EventsByType')
Ext.namespace('Lino.cal.EventsByRoom')
Ext.namespace('Lino.contenttypes.HelpTextsByModel')
Ext.namespace('Lino.cal.EventsByController')
Ext.namespace('Lino.cal.TasksByController')
Ext.namespace('Lino.about.Models')
Ext.namespace('Lino.about.FieldsByModel')
Ext.namespace('Lino.about.Inspector')
Ext.namespace('Lino.about.SourceFiles')
Ext.namespace('Lino.contenttypes.StaleControllables')
Ext.namespace('Lino.contenttypes.StaleControllablesByModel')
Ext.namespace('Lino.about.About')
Ext.namespace('Lino.lino.BuildMethods')
Ext.namespace('Lino.cal.EventEvents')
Ext.namespace('Lino.cal.EventStates')
Ext.namespace('Lino.system.PeriodEvents')
Ext.namespace('Lino.cal.AccessClasses')
Ext.namespace('Lino.users.UserProfiles')
Ext.namespace('Lino.cal.Weekdays')
Ext.namespace('Lino.cal.TaskStates')
Ext.namespace('Lino.cal.DurationUnits')
Ext.namespace('Lino.system.YesNo')
Ext.namespace('Lino.cal.Recurrencies')
Ext.namespace('Lino.system.Genders')
Ext.namespace('Lino.users.UserLevels')
Ext.namespace('Lino.users.UserGroups')
Ext.namespace('Lino.countries.PlaceTypes')
Ext.namespace('Lino.cal.GuestStates')

// ChoiceLists: 
Lino.lino.BuildMethods = [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appydoc", "AppyDocBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ];
Lino.cal.EventEvents = [ [ "10", "Okay" ], [ "20", "Pending" ] ];
Lino.cal.EventStates = [ [ "10", "Vorgeschlagen" ], [ "20", "Entwurf" ], [ "50", "Stattgefunden" ], [ "70", "Storniert" ], [ "75", "Omitted" ] ];
Lino.system.PeriodEvents = [ [ "10", "Begonnen" ], [ "20", "Active" ], [ "30", "Beendet" ] ];
Lino.cal.AccessClasses = [ [ "10", "Privat" ], [ "20", "halb \u00f6ffentlich (\"Besch\u00e4ftigt\")" ], [ "30", "\u00d6ffentlich" ] ];
Lino.users.UserProfiles = [ [ "000", "000 (Anonym)" ], [ "100", "100 (Benutzer)" ], [ "900", "900 (Verwalter)" ] ];
Lino.cal.Weekdays = [ [ "1", "Montag" ], [ "2", "Dienstag" ], [ "3", "Mittwoch" ], [ "4", "Donnerstag" ], [ "5", "Freitag" ], [ "6", "Samstag" ], [ "7", "Sonntag" ] ];
Lino.cal.TaskStates = [ [ "10", "Zu tun" ], [ "20", "Begonnen" ], [ "30", "Erledigt" ], [ "50", "Storniert" ] ];
Lino.cal.DurationUnits = [ [ "s", "Sekunden" ], [ "m", "Minuten" ], [ "h", "Stunden" ], [ "D", "Tage" ], [ "W", "Wochen" ], [ "M", "Monate" ], [ "Y", "Jahre" ] ];
Lino.system.YesNo = [ [ "y", "Ja" ], [ "n", "Nein" ] ];
Lino.cal.Recurrencies = [ [ "O", "einmalig" ], [ "D", "t\u00e4glich" ], [ "W", "w\u00f6chentlich" ], [ "M", "monatlich" ], [ "Y", "j\u00e4hrlich" ], [ "P", "pro Wochentag" ] ];
Lino.system.Genders = [ [ "M", "M\u00e4nnlich" ], [ "F", "Weiblich" ] ];
Lino.users.UserLevels = [ [ "10", "Gast" ], [ "30", "Benutzer" ], [ "40", "Manager" ], [ "50", "Verwalter" ] ];
Lino.users.UserGroups = [ [ "office", "office (B\u00fcro)" ] ];
Lino.countries.PlaceTypes = [ [ "10", "Bundesland" ], [ "11", "Division" ], [ "12", "Region" ], [ "13", "Gemeinschaft" ], [ "14", "Territorium" ], [ "20", "Regierungsbezirk" ], [ "21", "Provinz" ], [ "22", "Grafschaft" ], [ "23", "Unterregion" ], [ "24", "Departement" ], [ "25", "Arrondissement" ], [ "26", "Pr\u00e4fektur" ], [ "27", "Distrikt" ], [ "28", "Sektor" ], [ "50", "Stadt" ], [ "51", "Kleinstadt" ], [ "52", "Gemeinde" ], [ "54", "Pfarre" ], [ "55", "Stadtteil" ], [ "56", "Viertel" ], [ "61", "Ortschaft" ], [ "62", "Kleine Ortschaft" ], [ "70", "Dorf" ] ];
Lino.cal.GuestStates = [ [ "10", "Eingeladen" ] ];

Lino.cal.Tasks.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var start_date695 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","(cal.Tasks.start_date) Start date of observed period") }, "value": null, "anchor": "-20" });
    var end_date696 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","(cal.Tasks.end_date) End date of observed period") }, "value": null, "anchor": "-20" });
    var user697 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Verwaltet durch</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Verwaltet durch","(cal.Tasks.user) Only rows managed by this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var state698 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand</span>", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","(cal.Tasks.state) Only rows having this state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.TaskStates) });
    var main_1_panel699 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date695, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date696, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user697, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state698, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    this.items = [ main_1_panel699 ];
    this.fields = [ start_date695, end_date696, user697, state698 ];
    Lino.cal.Tasks.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  labelWidth: 72,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var start_date575 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","(cal.Guests.start_date) Start date of observed period") }, "value": null, "anchor": "-20" });
    var end_date576 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","(cal.Guests.end_date) End date of observed period") }, "value": null, "anchor": "-20" });
    var user577 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Verantwortlicher</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Verantwortlicher","(cal.Guests.user) Only rows managed by this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/user", "method": "GET" }) }) });
    var event_state578 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand Termin</span>", "name": "event_state", "hiddenName": "event_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand Termin","(cal.Guests.event_state) Only rows having this event state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.EventStates) });
    var guest_state579 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand Gast</span>", "name": "guest_state", "hiddenName": "guest_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand Gast","(cal.Guests.guest_state) Only rows having this guest state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.GuestStates) });
    var main_1_panel580 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date575, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date576, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user577, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_state578, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": guest_state579, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var partner586 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "hiddenName": "partnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(cal.Guests.partner) ") }, "selectOnFocus": true, "emptyText": "Partner ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }) });
    this.items = [ main_1_panel580, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner586, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ start_date575, end_date576, user577, event_state578, guest_state579, partner586 ];
    Lino.cal.Guests.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Events.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var start_date511 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Periode vom</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Periode vom","(cal.Events.start_date) Start date of observed period") }, "value": null, "anchor": "-20" });
    var end_date512 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">bis</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("bis","(cal.Events.end_date) End date of observed period") }, "value": null, "anchor": "-20" });
    var observed_event513 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Observed event", "name": "observed_event", "hiddenName": "observed_eventHidden", "listeners": { "render": Lino.quicktip_renderer("Observed event","(cal.Events.observed_event) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.EventEvents) });
    var state514 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zustand</span>", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","(cal.Events.state) Only rows having this state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.EventStates) });
    var main_1_panel515 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date511, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date512, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event513, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state514, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var user520 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Verwaltet durch</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Verwaltet durch","(cal.Events.user) Only rows managed by this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }) });
    var assigned_to521 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zugewiesen zu</span>", "name": "assigned_to", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "assigned_toHidden", "listeners": { "render": Lino.quicktip_renderer("Zugewiesen zu","(cal.Events.assigned_to) Only events assigned to this user.") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/assigned_to", "method": "GET" }) }) });
    var event_type522 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Ereignisart", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail,Lino.cal.EventTypes.insert)}, "emptyText": "Ereignisart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Ereignisart","(cal.Events.event_type) ") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/event_type", "method": "GET" }) }) });
    var room523 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Raum", "name": "room", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Rooms.detail,Lino.cal.Rooms.insert)}, "emptyText": "Raum ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Raum","(cal.Events.room) ") }, "selectOnFocus": true, "hiddenName": "roomHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/room", "method": "GET" }) }) });
    var show_appointments524 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Termine", "name": "show_appointments", "hiddenName": "show_appointmentsHidden", "listeners": { "render": Lino.quicktip_renderer("Termine","(cal.Events.show_appointments) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.system.YesNo) });
    var main_2_panel525 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user520, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": assigned_to521, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type522, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": room523, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_appointments524, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 144, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel515, main_2_panel525 ];
    this.fields = [ start_date511, end_date512, observed_event513, state514, user520, assigned_to521, event_type522, room523, show_appointments524 ];
    Lino.cal.Events.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.about.Inspector.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 153,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'hbox',
  autoHeight: true,
  initComponent : function() {
    var inspected60 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Inspected object", "name": "inspected", "maxLength": 100, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Inspected object","(about.Inspector.inspected) ") }, "anchor": "-20" });
    var show_callables61 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "show_callables", "listeners": { "render": Lino.quicktip_renderer("show callables","(about.Inspector.show_callables) ") }, "boxLabel": "show callables", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "flex": 67, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inspected60, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_callables61, "labelAlign": "top" } ];
    this.fields = [ inspected60, show_callables61 ];
    Lino.about.Inspector.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.users.Users.change_password_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 171,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'change_password',
  ls_url: "/users/Users",
  window_title: "Passwort \u00e4ndern",
  before_row_edit : function(record) {
  },
  autoHeight: true,
  initComponent : function() {
    this.current1 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Current password", "name": "current", "inputType": "password", "listeners": { "render": Lino.quicktip_renderer("Current password","(<ChangePassword change_password (u'Change password')>.current) ") }, "maxLength": null, "selectOnFocus": true, "anchor": "-20" });
    this.new12 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "New password", "name": "new1", "inputType": "password", "listeners": { "render": Lino.quicktip_renderer("New password","(<ChangePassword change_password (u'Change password')>.new1) ") }, "maxLength": null, "selectOnFocus": true, "anchor": "-20" });
    this.new23 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "New password again", "name": "new2", "inputType": "password", "listeners": { "render": Lino.quicktip_renderer("New password again","(<ChangePassword change_password (u'Change password')>.new2) ") }, "maxLength": null, "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.current1, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.new12, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.new23, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ this.current1, this.new12, this.new23 ];
    Lino.users.Users.change_password_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.TextFieldTemplates.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 5,
  initComponent : function() {
    var id182 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(system.TextFieldTemplates.id) ") }, "anchor": "-20" });
    var name183 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(system.TextFieldTemplates.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user184 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(system.TextFieldTemplates.user) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/user", "method": "GET" }) }) });
    var main_1_panel185 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id182, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name183, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user184, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 108, "border": false, "frame": false, "labelAlign": "top" });
    var description189 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Beschreibung","(system.TextFieldTemplates.description) ") }, "fieldLabel": "Beschreibung", "name": "description", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var text190 = new Lino.RichTextPanel({ "flex": 5, "split": true, "containing_panel": this, "selectOnFocus": true, "region": "south", "title": "Vorlagentext", "name": "text" });
    var main_panel191 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ main_1_panel185, { "flex": 5, "layout": "form", "xtype": "panel", "items": description189, "region": "center", "labelAlign": "top", "split": true }, text190 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel191;
    this.before_row_edit = function(record) {
      text190.refresh();
    }
    Lino.system.TextFieldTemplates.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 12,
  initComponent : function() {
    var first_name399 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Vorname</span>", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Vorname","(contacts.Persons.first_name) First or given name.") }, "anchor": "-20" });
    var last_name400 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Familienname</span>", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Familienname","(contacts.Persons.last_name) Last name (family name).") }, "anchor": "-20" });
    var main_1_panel401 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name399, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name400, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gender404 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(contacts.Persons.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.system.Genders) });
    var language405 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(contacts.Persons.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "de", "Deutsch" ] ], "name": "language" });
    var main_2_panel406 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender404, "labelAlign": "top" }, { "flex": 68, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language405, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel409 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel401, main_2_panel406 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel409;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Persons.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.SiteConfigs.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 4,
  initComponent : function() {
    var default_build_method179 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Standard-Konstruktionsmethode", "name": "default_build_method", "hiddenName": "default_build_methodHidden", "listeners": { "render": Lino.quicktip_renderer("Standard-Konstruktionsmethode","(system.SiteConfigs.default_build_method) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.BuildMethods) });
    var main_panel180 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "labelWidth": 270, "hideCheckBoxLabels": true, "items": [ { "items": default_build_method179, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel180;
    this.before_row_edit = function(record) {
    }
    Lino.system.SiteConfigs.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Events.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 25,
  initComponent : function() {
    var event_type532 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Ereignisart", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail,Lino.cal.EventTypes.insert)}, "emptyText": "Ereignisart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Ereignisart","(cal.Events.event_type) ") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/event_type", "method": "GET" }) }) });
    var summary533 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Kurzbeschreibung", "name": "summary", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Kurzbeschreibung","(cal.Events.summary) ") }, "anchor": "-20" });
    var user534 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Verantwortlicher", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Verantwortlicher","(cal.Events.user) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }) });
    var assigned_to535 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Zugewiesen zu", "name": "assigned_to", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "assigned_toHidden", "listeners": { "render": Lino.quicktip_renderer("Zugewiesen zu","(cal.Events.assigned_to) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/assigned_to", "method": "GET" }) }) });
    var main_1_panel536 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type532, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary533, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user534, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": assigned_to535, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var start_date541 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Beginnt am", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beginnt am","(cal.Events.start_date) ") }, "anchor": "-20" });
    var start_time542 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "Beginnt um", "name": "start_time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beginnt um","(cal.Events.start_time) ") }, "anchor": "-20" });
    var start_panel543 = new Ext.Panel({ "flex": 38, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 61, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date541, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time542, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var end_date546 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Endet am", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Endet am","(cal.Events.end_date) ") }, "anchor": "-20" });
    var end_time547 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "Endet um", "name": "end_time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Endet um","(cal.Events.end_time) ") }, "anchor": "-20" });
    var end_panel548 = new Ext.Panel({ "flex": 38, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 61, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date546, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time547, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var state551 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Zustand", "allowBlank": false, "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","(cal.Events.state) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.EventStates, "name": "state" });
    var main_2_panel552 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ start_panel543, end_panel548, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state551, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var room554 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Raum", "name": "room", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Rooms.detail,Lino.cal.Rooms.insert)}, "emptyText": "Raum ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Raum","(cal.Events.room) ") }, "selectOnFocus": true, "hiddenName": "roomHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/room", "method": "GET" }) }) });
    var priority555 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Priorit\u00e4t", "name": "priority", "pageSize": 20, "emptyText": "Priorit\u00e4t ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Priorit\u00e4t","(cal.Events.priority) ") }, "selectOnFocus": true, "hiddenName": "priorityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/priority", "method": "GET" }) }) });
    var access_class556 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zugriffsklasse</span>", "name": "access_class", "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Zugriffsklasse","(cal.Events.access_class) Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var transparent557 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "transparent", "listeners": { "render": Lino.quicktip_renderer("nicht blockierend","(cal.Events.transparent) Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.") }, "boxLabel": "nicht blockierend", "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel558 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 162, "hideCheckBoxLabels": true, "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": room554, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": priority555, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class556, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": transparent557, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var owner_disp563 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var created564 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Erstellt", "name": "created", "listeners": { "render": Lino.quicktip_renderer("Erstellt","(cal.Events.created) ") }, "value": "<br>", "anchor": "-20" });
    var modified565 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Bearbeitet", "name": "modified", "listeners": { "render": Lino.quicktip_renderer("Bearbeitet","(cal.Events.modified) ") }, "value": "<br>", "anchor": "-20" });
    var main_4_panel566 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp563, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created564, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified565, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description570 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Beschreibung","(cal.Events.description) ") }, "fieldLabel": "Beschreibung", "name": "description", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var GuestsByEvent_grid611 = new Lino.cal.GuestsByEvent.GridPanel({ "flex": 35, "listeners": { "render": Lino.quicktip_renderer("Teilnehmer","(cal.cal.GuestsByEvent) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.GuestsByEvent.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel612 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ main_1_panel536, main_2_panel552, main_3_panel558, main_4_panel566, { "items": description570, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 35 }, GuestsByEvent_grid611 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel612;
    this.before_row_edit = function(record) {
      GuestsByEvent_grid611.on_master_changed();
    }
    Lino.cal.Events.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Events.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 25,
  initComponent : function() {
    var event_type614 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Ereignisart", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail,Lino.cal.EventTypes.insert)}, "emptyText": "Ereignisart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Ereignisart","(cal.Events.event_type) ") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/event_type", "method": "GET" }) }) });
    var summary615 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Kurzbeschreibung", "name": "summary", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Kurzbeschreibung","(cal.Events.summary) ") }, "anchor": "-20" });
    var main_1_panel616 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type614, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary615, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var start_date619 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Beginnt am", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beginnt am","(cal.Events.start_date) ") }, "anchor": "-20" });
    var start_time620 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "Beginnt um", "name": "start_time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beginnt um","(cal.Events.start_time) ") }, "anchor": "-20" });
    var start_panel621 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 61, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date619, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time620, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var end_date624 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Endet am", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Endet am","(cal.Events.end_date) ") }, "anchor": "-20" });
    var end_time625 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "Endet um", "name": "end_time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Endet um","(cal.Events.end_time) ") }, "anchor": "-20" });
    var end_panel626 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 61, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date624, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time625, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var main_2_panel629 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ start_panel621, end_panel626 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "anchor": "-20", "labelAlign": "top" });
    var room630 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Raum", "name": "room", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Rooms.detail,Lino.cal.Rooms.insert)}, "emptyText": "Raum ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Raum","(cal.Events.room) ") }, "selectOnFocus": true, "hiddenName": "roomHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/room", "method": "GET" }) }) });
    var priority631 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Priorit\u00e4t", "name": "priority", "pageSize": 20, "emptyText": "Priorit\u00e4t ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Priorit\u00e4t","(cal.Events.priority) ") }, "selectOnFocus": true, "hiddenName": "priorityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/priority", "method": "GET" }) }) });
    var access_class632 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Zugriffsklasse</span>", "name": "access_class", "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Zugriffsklasse","(cal.Events.access_class) Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var transparent633 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "transparent", "listeners": { "render": Lino.quicktip_renderer("nicht blockierend","(cal.Events.transparent) Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.") }, "boxLabel": "nicht blockierend", "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel634 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": room630, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": priority631, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class632, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": transparent633, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel639 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel616, main_2_panel629, main_3_panel634 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel639;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Events.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Countries.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 8,
  initComponent : function() {
    var isocode198 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">ISO-Code</span>", "name": "isocode", "boxMinWidth": Lino.chars2width(4), "listeners": { "render": Lino.quicktip_renderer("ISO-Code","(countries.Countries.isocode)         The two-letter code for this country as defined by ISO 3166-1.\n        For countries that no longer exist it may be a 4-letter code.") }, "maxLength": 4, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name199 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(countries.Countries.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de200 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(countries.Countries.name_de) ") }, "anchor": "-20" });
    var short_code201 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Short code</span>", "name": "short_code", "boxMinWidth": Lino.chars2width(4), "listeners": { "render": Lino.quicktip_renderer("Short code","(countries.Countries.short_code) A short abbreviation for regional usage. Obsolete.") }, "maxLength": 4, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel202 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": isocode198, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name199, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de200, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": short_code201, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var countries_PlacesByCountry_grid338 = new Lino.countries.PlacesByCountry.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Orte","(countries.countries.PlacesByCountry) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.countries.PlacesByCountry.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel339 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel202, countries_PlacesByCountry_grid338 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel339;
    this.before_row_edit = function(record) {
      countries_PlacesByCountry_grid338.on_master_changed();
    }
    Lino.countries.Countries.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Places.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 9,
  initComponent : function() {
    var name214 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(countries.Places.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de215 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(countries.Places.name_de) ") }, "anchor": "-20" });
    var country216 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Land", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Land","(countries.Places.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Places/country", "method": "GET" }) }), "name": "country" });
    var main_1_panel217 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name214, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de215, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country216, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var type221 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Ortsart", "name": "type", "hiddenName": "typeHidden", "listeners": { "render": Lino.quicktip_renderer("Ortsart","(countries.Places.type) ") }, "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Places/type", "method": "GET" }) }) });
    var parent222 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Teil von</span>", "name": "parent", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Teil von","(countries.Places.parent) The superordinate geographic place         of which this place is a part.") }, "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Places/parent", "method": "GET" }) }) });
    var zip_code223 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "zip code", "name": "zip_code", "boxMinWidth": Lino.chars2width(8), "listeners": { "render": Lino.quicktip_renderer("zip code","(countries.Places.zip_code) ") }, "maxLength": 8, "selectOnFocus": true, "anchor": "-20" });
    var id224 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(countries.Places.id) ") }, "anchor": "-20" });
    var main_2_panel225 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type221, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent222, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code223, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id224, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var PlacesByPlace_grid335 = new Lino.countries.PlacesByPlace.GridPanel({ "flex": 41, "listeners": { "render": Lino.quicktip_renderer("Unterteilungen","(countries.countries.PlacesByPlace) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.countries.PlacesByPlace.grid) ], "preview_limit": 15, "master_panel": this });
    var contacts_PartnersByCity_grid336 = new Lino.contacts.PartnersByCity.GridPanel({ "flex": 41, "listeners": { "render": Lino.quicktip_renderer("Partner","(contacts.contacts.PartnersByCity) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.PartnersByCity.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel337 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel217, main_2_panel225, PlacesByPlace_grid335, contacts_PartnersByCity_grid336 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel337;
    this.before_row_edit = function(record) {
      type221.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      PlacesByPlace_grid335.on_master_changed();
      contacts_PartnersByCity_grid336.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country216.on('change',Lino.chooser_handler(type221,'country'));
      Lino.countries.Places.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.countries.Places.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 11,
  initComponent : function() {
    var prefix410 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name prefix", "name": "prefix", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Name prefix","(contacts.Companies.prefix) ") }, "anchor": "-20" });
    var name411 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Companies.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var type412 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Organisationsart", "name": "type", "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Organisationsart","(contacts.Companies.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var name_box_panel413 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix410, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name411, "labelAlign": "top" }, { "flex": 49, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type412, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var country417 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Land","(contacts.Companies.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/country", "method": "GET" }) }) });
    var region418 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Regierungsbezirk", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Regierungsbezirk","(contacts.Companies.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/region", "method": "GET" }) }) });
    var city419 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "Stadt", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Stadt","(contacts.Companies.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/city", "method": "GET" }) }) });
    var zip_code420 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Postleitzahl", "name": "zip_code", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Postleitzahl","(contacts.Companies.zip_code) ") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var address_box_2_panel421 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country417, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region418, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city419, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code420, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr1426 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile vor Stra\u00dfe</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Adresszeile vor Stra\u00dfe","(contacts.Companies.addr1) Adresszeile vor Stra\u00dfe") }, "anchor": "-20" });
    var street_prefix427 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","(contacts.Companies.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "anchor": "-20" });
    var street428 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","(contacts.Companies.street) Name der Stra\u00dfe, ohne Hausnummer") }, "anchor": "-20" });
    var street_no429 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Nr.","(contacts.Companies.street_no) Hausnummer") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var street_box430 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Box","(contacts.Companies.street_box) Text to print after street nuber on the same line.") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var address_box_4_panel431 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix427, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street428, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no429, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box430, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2436 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","(contacts.Companies.addr2) Adresszeile nach Stra\u00dfe") }, "anchor": "-20" });
    var address_box_panel437 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "layout": "form", "title": "Adresse", "items": [ name_box_panel413, address_box_2_panel421, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1426, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel431, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2436, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var id440 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Companies.id) ") }, "anchor": "-20" });
    var language441 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(contacts.Companies.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "de", "Deutsch" ] ], "name": "language" });
    var info_box_panel442 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id440, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language441, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email445 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Companies.email) ") }, "anchor": "-20" });
    var url446 = new Lino.URLField({ "autoHeight": true, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("URL","(contacts.Companies.url) ") }, "anchor": "-20" });
    var phone447 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Telefon", "name": "phone", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Telefon","(contacts.Companies.phone) ") }, "anchor": "-20" });
    var gsm448 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("GSM","(contacts.Companies.gsm) ") }, "anchor": "-20" });
    var fax449 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Fax","(contacts.Companies.fax) ") }, "anchor": "-20" });
    var contact_box_5_panel450 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm448, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax449, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel453 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "layout": "form", "title": "Kontakt", "items": [ info_box_panel442, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email445, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url446, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone447, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel450 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var main_1_panel457 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ address_box_panel437, contact_box_panel453 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks458 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkungen","(contacts.Companies.remarks) ") }, "fieldLabel": "Bemerkungen", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var contacts_RolesByCompany_grid463 = new Lino.contacts.RolesByCompany.GridPanel({ "flex": 42, "listeners": { "render": Lino.quicktip_renderer("Kontaktpersonen","(contacts.contacts.RolesByCompany) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.grid) ], "preview_limit": 15, "master_panel": this });
    var bottom_box_1_panel464 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": remarks458, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 57 }, contacts_RolesByCompany_grid463 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel466 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel457, bottom_box_1_panel464 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel466;
    this.before_row_edit = function(record) {
      region418.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city419.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city419.setContextValue('region', record ? record.data['regionHidden'] : undefined);
      contacts_RolesByCompany_grid463.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country417.on('change',Lino.chooser_handler(region418,'country'));
      country417.on('change',Lino.chooser_handler(city419,'country'));
      region418.on('change',Lino.chooser_handler(city419,'region'));
      Lino.contacts.Companies.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Companies.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    city419.on("change", function(){ this.save() }, this);
    zip_code420.on("change", function(){ this.save() }, this);
  }
});


Lino.system.TextFieldTemplates.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 5,
  initComponent : function() {
    var name193 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(system.TextFieldTemplates.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user194 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(system.TextFieldTemplates.user) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/user", "method": "GET" }) }) });
    var main_panel195 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 108, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name193, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": user194, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel195;
    this.before_row_edit = function(record) {
    }
    Lino.system.TextFieldTemplates.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.EventTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 19,
  initComponent : function() {
    var name722 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(cal.EventTypes.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de723 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(cal.EventTypes.name_de) ") }, "anchor": "-20" });
    var main_1_panel724 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name722, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de723, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var event_label727 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung Termin", "name": "event_label", "value": "Termin", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung Termin","(cal.EventTypes.event_label) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var event_label_de728 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung Termin (de)", "name": "event_label_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung Termin (de)","(cal.EventTypes.event_label_de) ") }, "anchor": "-20" });
    var main_2_panel729 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label727, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label_de728, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var start_date732 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Beginnt am", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beginnt am","(cal.EventTypes.start_date) ") }, "anchor": "-20" });
    var id733 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.EventTypes.id) ") }, "anchor": "-20" });
    var main_3_panel734 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 72, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date732, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id733, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var is_appointment737 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": true, "name": "is_appointment", "listeners": { "render": Lino.quicktip_renderer("Event is an appointment","(cal.EventTypes.is_appointment) ") }, "boxLabel": "Event is an appointment", "selectOnFocus": true, "anchor": "-20" });
    var all_rooms738 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "all_rooms", "listeners": { "render": Lino.quicktip_renderer("Locks all rooms","(cal.EventTypes.all_rooms) ") }, "boxLabel": "Locks all rooms", "selectOnFocus": true, "anchor": "-20" });
    var locks_user739 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "locks_user", "listeners": { "render": Lino.quicktip_renderer("Locks the user","(cal.EventTypes.locks_user) Whether events of this type make the user unavailable for other locking events at the same time.") }, "boxLabel": "Locks the user", "selectOnFocus": true, "anchor": "-20" });
    var max_conflicting740 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Simultaneous events</span>", "name": "max_conflicting", "value": 1, "listeners": { "render": Lino.quicktip_renderer("Simultaneous events","(cal.EventTypes.max_conflicting) How many conflicting events should be tolerated.") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_5_panel741 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_appointment737, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": all_rooms738, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": locks_user739, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": max_conflicting740, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var EventsByType_grid771 = new Lino.cal.EventsByType.GridPanel({ "flex": 55, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Termine","(cal.cal.EventsByType) ") }, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByType.grid) ] });
    var main_panel772 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel724, main_2_panel729, main_3_panel734, main_5_panel741, EventsByType_grid771 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel772;
    this.before_row_edit = function(record) {
      EventsByType_grid771.on_master_changed();
    }
    Lino.cal.EventTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Rooms.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 17,
  initComponent : function() {
    var id480 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.Rooms.id) ") }, "anchor": "-20" });
    var name481 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(cal.Rooms.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de482 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(cal.Rooms.name_de) ") }, "anchor": "-20" });
    var main_1_panel483 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id480, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name481, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de482, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_EventsByRoom_grid640 = new Lino.cal.EventsByRoom.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Termine","(cal.cal.EventsByRoom) ") }, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByRoom.grid) ] });
    var main_panel641 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel483, cal_EventsByRoom_grid640 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel641;
    this.before_row_edit = function(record) {
      cal_EventsByRoom_grid640.on_master_changed();
    }
    Lino.cal.Rooms.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 11,
  initComponent : function() {
    var name467 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Companies.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language468 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(contacts.Companies.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "de", "Deutsch" ] ], "name": "language" });
    var email469 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Companies.email) ") }, "anchor": "-20" });
    var main_2_panel470 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language468, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email469, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type473 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Organisationsart", "name": "type", "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Organisationsart","(contacts.Companies.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var id474 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Companies.id) ") }, "anchor": "-20" });
    var main_3_panel475 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type473, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id474, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel478 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name467, "anchor": "-20", "labelAlign": "top" }, main_2_panel470, main_3_panel475 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel478;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Companies.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Calendars.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 24,
  initComponent : function() {
    var name642 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(cal.Calendars.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de643 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(cal.Calendars.name_de) ") }, "anchor": "-20" });
    var color644 = new Ext.form.NumberField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "Farbe", "name": "color", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Farbe","(cal.Calendars.color) ") }, "anchor": "-20" });
    var id645 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.Calendars.id) ") }, "anchor": "-20" });
    var main_1_panel646 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name642, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de643, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": color644, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id645, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description651 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 63, "containing_panel": this, "name": "description", "title": "Beschreibung" });
    var SubscriptionsByCalendar_grid656 = new Lino.cal.SubscriptionsByCalendar.GridPanel({ "flex": 36, "listeners": { "render": Lino.quicktip_renderer("Abonnements","(cal.cal.SubscriptionsByCalendar) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.SubscriptionsByCalendar.grid) ], "preview_limit": 15, "master_panel": this });
    var main_2_panel657 = new Ext.Panel({ "flex": 83, "border": false, "layout": "hbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ description651, SubscriptionsByCalendar_grid656 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel658 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel646, main_2_panel657 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel658;
    this.before_row_edit = function(record) {
      description651.refresh();
      SubscriptionsByCalendar_grid656.on_master_changed();
    }
    Lino.cal.Calendars.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 21,
  initComponent : function() {
    var event589 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Termin", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.OneEvent.detail,Lino.cal.OneEvent.insert)}, "emptyText": "Termin ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Termin","(cal.Guests.event) ") }, "selectOnFocus": true, "hiddenName": "eventHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/event", "method": "GET" }) }), "name": "event" });
    var partner590 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "emptyText": "Partner ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Partner","(cal.Guests.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }), "name": "partner" });
    var role591 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Rolle", "name": "role", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.GuestRoles.detail,Lino.cal.GuestRoles.insert)}, "emptyText": "Gastrolle ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Rolle","(cal.Guests.role) ") }, "selectOnFocus": true, "hiddenName": "roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/role", "method": "GET" }) }) });
    var main_1_panel592 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event589, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner590, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": role591, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var state596 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Zustand", "allowBlank": false, "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("Zustand","(cal.Guests.state) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.GuestStates, "name": "state" });
    var remark597 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bemerkung", "name": "remark", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bemerkung","(cal.Guests.remark) ") }, "anchor": "-20" });
    var workflow_buttons_disp598 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Arbeitsablauf","(cal.Guests.workflow_buttons) ") }, "anchor": "-20" });
    var main_2_panel599 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state596, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": remark597, "labelAlign": "top" }, { "flex": 49, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp598, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel603 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel592, main_2_panel599 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel603;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Guests.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Calendars.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 24,
  initComponent : function() {
    var name659 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(cal.Calendars.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de660 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(cal.Calendars.name_de) ") }, "anchor": "-20" });
    var main_1_panel661 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name659, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de660, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var color664 = new Ext.form.NumberField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "Farbe", "name": "color", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Farbe","(cal.Calendars.color) ") }, "anchor": "-20" });
    var main_panel665 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 54, "autoScroll": false, "items": [ main_1_panel661, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": color664, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel665;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Calendars.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 16,
  initComponent : function() {
    var start_date667 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Beginnt am", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beginnt am","(cal.Tasks.start_date) ") }, "anchor": "-20" });
    var due_date668 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Zahlungsziel", "name": "due_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Zahlungsziel","(cal.Tasks.due_date) ") }, "anchor": "-20" });
    var id669 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.Tasks.id) ") }, "anchor": "-20" });
    var workflow_buttons_disp670 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Arbeitsablauf", "name": "workflow_buttons", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Arbeitsablauf","(cal.Tasks.workflow_buttons) ") }, "anchor": "-20" });
    var main_1_panel671 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date667, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": due_date668, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id669, "labelAlign": "top" }, { "flex": 49, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp670, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var summary676 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Kurzbeschreibung", "name": "summary", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Kurzbeschreibung","(cal.Tasks.summary) ") }, "anchor": "-20" });
    var user677 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(cal.Tasks.user) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var owner_disp678 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Verkn\u00fcpft mit", "anchor": "-20", "name": "owner" });
    var created679 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Erstellt", "name": "created", "listeners": { "render": Lino.quicktip_renderer("Erstellt","(cal.Tasks.created) ") }, "value": "<br>", "anchor": "-20" });
    var modified680 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Bearbeitet", "name": "modified", "listeners": { "render": Lino.quicktip_renderer("Bearbeitet","(cal.Tasks.modified) ") }, "value": "<br>", "anchor": "-20" });
    var main_4_panel681 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp678, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created679, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified680, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description685 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Beschreibung","(cal.Tasks.description) ") }, "fieldLabel": "Beschreibung", "name": "description", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var main_panel686 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ main_1_panel671, { "items": summary676, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": user677, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, main_4_panel681, { "items": description685, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 45 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel686;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Tasks.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 16,
  initComponent : function() {
    var summary690 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Kurzbeschreibung", "name": "summary", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Kurzbeschreibung","(cal.Tasks.summary) ") }, "anchor": "-20" });
    var user691 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(cal.Tasks.user) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var main_panel692 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 153, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary690, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": user691, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel692;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Tasks.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.RecurrentEvents.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 18,
  initComponent : function() {
    var name856 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(cal.RecurrentEvents.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de857 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(cal.RecurrentEvents.name_de) ") }, "anchor": "-20" });
    var main_1_panel858 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name856, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de857, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var start_date861 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Beginnt am", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beginnt am","(cal.RecurrentEvents.start_date) ") }, "anchor": "-20" });
    var end_date862 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Endet am", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Endet am","(cal.RecurrentEvents.end_date) ") }, "anchor": "-20" });
    var every_unit863 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Wiederholung", "allowBlank": false, "hiddenName": "every_unitHidden", "listeners": { "render": Lino.quicktip_renderer("Wiederholung","(cal.RecurrentEvents.every_unit) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.Recurrencies, "name": "every_unit" });
    var event_type864 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Ereignisart", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail,Lino.cal.EventTypes.insert)}, "emptyText": "Ereignisart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Ereignisart","(cal.RecurrentEvents.event_type) ") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/RecurrentEvents/event_type", "method": "GET" }) }) });
    var main_2_panel865 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date861, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date862, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": every_unit863, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type864, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel870 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel858, main_2_panel865 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel870;
    this.before_row_edit = function(record) {
    }
    Lino.cal.RecurrentEvents.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 14,
  initComponent : function() {
    var name273 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Partners.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var country274 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Land","(contacts.Partners.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }) });
    var region275 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Regierungsbezirk", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Regierungsbezirk","(contacts.Partners.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }) });
    var city276 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "Stadt", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Stadt","(contacts.Partners.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }) });
    var zip_code277 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Postleitzahl", "name": "zip_code", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Postleitzahl","(contacts.Partners.zip_code) ") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var address_box_2_panel278 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country274, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region275, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city276, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code277, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr1283 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile vor Stra\u00dfe</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Adresszeile vor Stra\u00dfe","(contacts.Partners.addr1) Adresszeile vor Stra\u00dfe") }, "anchor": "-20" });
    var street_prefix284 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","(contacts.Partners.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "anchor": "-20" });
    var street285 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","(contacts.Partners.street) Name der Stra\u00dfe, ohne Hausnummer") }, "anchor": "-20" });
    var street_no286 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Nr.","(contacts.Partners.street_no) Hausnummer") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var street_box287 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Box","(contacts.Partners.street_box) Text to print after street nuber on the same line.") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var address_box_4_panel288 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix284, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street285, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no286, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box287, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2293 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","(contacts.Partners.addr2) Adresszeile nach Stra\u00dfe") }, "anchor": "-20" });
    var address_box_panel294 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "layout": "form", "title": "Adresse", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name273, "anchor": "-20", "labelAlign": "top" }, address_box_2_panel278, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1283, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel288, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2293, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var id298 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Partners.id) ") }, "anchor": "-20" });
    var language299 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(contacts.Partners.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "de", "Deutsch" ] ], "name": "language" });
    var info_box_panel300 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id298, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language299, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email303 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Partners.email) ") }, "anchor": "-20" });
    var url304 = new Lino.URLField({ "autoHeight": true, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("URL","(contacts.Partners.url) ") }, "anchor": "-20" });
    var phone305 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Telefon", "name": "phone", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Telefon","(contacts.Partners.phone) ") }, "anchor": "-20" });
    var gsm306 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("GSM","(contacts.Partners.gsm) ") }, "anchor": "-20" });
    var fax307 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Fax","(contacts.Partners.fax) ") }, "anchor": "-20" });
    var contact_box_5_panel308 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm306, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax307, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel311 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "layout": "form", "title": "Kontakt", "items": [ info_box_panel300, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email303, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url304, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone305, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel308 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var main_1_panel315 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ address_box_panel294, contact_box_panel311 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks316 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkungen","(contacts.Partners.remarks) ") }, "fieldLabel": "Bemerkungen", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var is_person317 = new Ext.form.Checkbox({ "boxLabel": "ist eine Person (<a href=\"javascript:Lino.show_mti_child('is_person',Lino.contacts.Persons.detail)\">zeigen</a>)", "autoHeight": true, "hideLabel": true, "name": "is_person", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ist eine Person","(contacts.Partners.is_person) Ob dieser Partner auch eine Person ist.") }, "anchor": "-20" });
    var is_company318 = new Ext.form.Checkbox({ "boxLabel": "ist eine Organisation (<a href=\"javascript:Lino.show_mti_child('is_company',Lino.contacts.Companies.detail)\">zeigen</a>)", "autoHeight": true, "hideLabel": true, "name": "is_company", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ist eine Organisation","(contacts.Partners.is_company) Ob dieser Partner auch eine Organisation ist.") }, "anchor": "-20" });
    var bottom_box_2_panel319 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 198, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_person317, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_company318, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var bottom_box_panel322 = new Ext.Panel({ "flex": 54, "layout": "vbox", "items": [ { "items": remarks316, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 }, bottom_box_2_panel319 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel324 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel315, bottom_box_panel322 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel324;
    this.before_row_edit = function(record) {
      region275.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city276.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city276.setContextValue('region', record ? record.data['regionHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      country274.on('change',Lino.chooser_handler(region275,'country'));
      country274.on('change',Lino.chooser_handler(city276,'country'));
      region275.on('change',Lino.chooser_handler(city276,'region'));
      Lino.contacts.Partners.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Partners.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    city276.on("change", function(){ this.save() }, this);
    zip_code277.on("change", function(){ this.save() }, this);
  }
});


Lino.cal.RecurrentEvents.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 18,
  initComponent : function() {
    var name784 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(cal.RecurrentEvents.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de785 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(cal.RecurrentEvents.name_de) ") }, "anchor": "-20" });
    var main_1_panel786 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name784, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de785, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var id789 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.RecurrentEvents.id) ") }, "anchor": "-20" });
    var user790 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Autor", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Autor","(cal.RecurrentEvents.user) ") }, "selectOnFocus": true, "emptyText": "Benutzer ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/RecurrentEvents/user", "method": "GET" }) }) });
    var event_type791 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Ereignisart", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail,Lino.cal.EventTypes.insert)}, "emptyText": "Ereignisart ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Ereignisart","(cal.RecurrentEvents.event_type) ") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/RecurrentEvents/event_type", "method": "GET" }) }) });
    var main_2_panel792 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id789, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user790, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type791, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var start_date796 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Beginnt am", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beginnt am","(cal.RecurrentEvents.start_date) ") }, "anchor": "-20" });
    var start_time797 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "Beginnt um", "name": "start_time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Beginnt um","(cal.RecurrentEvents.start_time) ") }, "anchor": "-20" });
    var end_date798 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Endet am", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Endet am","(cal.RecurrentEvents.end_date) ") }, "anchor": "-20" });
    var end_time799 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "Endet um", "name": "end_time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Endet um","(cal.RecurrentEvents.end_time) ") }, "anchor": "-20" });
    var main_3_panel800 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date796, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time797, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date798, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time799, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var every_unit805 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Wiederholung", "allowBlank": false, "hiddenName": "every_unitHidden", "listeners": { "render": Lino.quicktip_renderer("Wiederholung","(cal.RecurrentEvents.every_unit) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.Recurrencies, "name": "every_unit" });
    var every806 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "... alle", "name": "every", "value": 0, "listeners": { "render": Lino.quicktip_renderer("... alle","(cal.RecurrentEvents.every) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var max_events807 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "Anzahl Termine", "name": "max_events", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Anzahl Termine","(cal.RecurrentEvents.max_events) ") }, "anchor": "-20" });
    var main_4_panel808 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": every_unit805, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": every806, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": max_events807, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var monday812 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "monday", "listeners": { "render": Lino.quicktip_renderer("Montag","(cal.RecurrentEvents.monday) ") }, "boxLabel": "Montag", "selectOnFocus": true, "anchor": "-20" });
    var tuesday813 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "tuesday", "listeners": { "render": Lino.quicktip_renderer("Dienstag","(cal.RecurrentEvents.tuesday) ") }, "boxLabel": "Dienstag", "selectOnFocus": true, "anchor": "-20" });
    var wednesday814 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "wednesday", "listeners": { "render": Lino.quicktip_renderer("Mittwoch","(cal.RecurrentEvents.wednesday) ") }, "boxLabel": "Mittwoch", "selectOnFocus": true, "anchor": "-20" });
    var thursday815 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "thursday", "listeners": { "render": Lino.quicktip_renderer("Donnerstag","(cal.RecurrentEvents.thursday) ") }, "boxLabel": "Donnerstag", "selectOnFocus": true, "anchor": "-20" });
    var friday816 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "friday", "listeners": { "render": Lino.quicktip_renderer("Freitag","(cal.RecurrentEvents.friday) ") }, "boxLabel": "Freitag", "selectOnFocus": true, "anchor": "-20" });
    var saturday817 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "saturday", "listeners": { "render": Lino.quicktip_renderer("Samstag","(cal.RecurrentEvents.saturday) ") }, "boxLabel": "Samstag", "selectOnFocus": true, "anchor": "-20" });
    var sunday818 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "sunday", "listeners": { "render": Lino.quicktip_renderer("Sonntag","(cal.RecurrentEvents.sunday) ") }, "boxLabel": "Sonntag", "selectOnFocus": true, "anchor": "-20" });
    var main_5_panel819 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": monday812, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": tuesday813, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": wednesday814, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": thursday815, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": friday816, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": saturday817, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sunday818, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description827 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 33, "containing_panel": this, "name": "description", "title": "Beschreibung" });
    var cal_EventsByController_grid853 = new Lino.cal.EventsByController.GridPanel({ "flex": 66, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Termine","(cal.cal.EventsByController) ") }, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByController.grid) ] });
    var main_6_panel854 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ description827, cal_EventsByController_grid853 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel855 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel786, main_2_panel792, main_3_panel800, main_4_panel808, main_5_panel819, main_6_panel854 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel855;
    this.before_row_edit = function(record) {
      description827.refresh();
      cal_EventsByController_grid853.on_master_changed();
    }
    Lino.cal.RecurrentEvents.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.GuestRoles.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 23,
  initComponent : function() {
    var id705 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.GuestRoles.id) ") }, "anchor": "-20" });
    var name706 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(cal.GuestRoles.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de707 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(cal.GuestRoles.name_de) ") }, "anchor": "-20" });
    var main_1_panel708 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id705, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name706, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de707, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_GuestsByRole_grid720 = new Lino.cal.GuestsByRole.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Teilnehmer","(cal.cal.GuestsByRole) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.GuestsByRole.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel721 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel708, cal_GuestsByRole_grid720 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel721;
    this.before_row_edit = function(record) {
      cal_GuestsByRole_grid720.on_master_changed();
    }
    Lino.cal.GuestRoles.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.Users.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 6,
  initComponent : function() {
    var username8 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Benutzername</span>", "name": "username", "listeners": { "render": Lino.quicktip_renderer("Username","(users.Users.username) Required. Must be unique.") }, "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var profile9 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Benutzerprofil</span>", "name": "profile", "hiddenName": "profileHidden", "listeners": { "render": Lino.quicktip_renderer("User Profile","(users.Users.profile) Users with an empty `profile` field are considered inactive and cannot log in.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.users.UserProfiles) });
    var partner10 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "hiddenName": "partnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(users.Users.partner) ") }, "selectOnFocus": true, "emptyText": "Partner ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var box1_1_panel11 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username8, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile9, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner10, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name15 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 30, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("First name","(users.Users.first_name) ") }, "anchor": "-20" });
    var last_name16 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 30, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Last name","(users.Users.last_name) ") }, "anchor": "-20" });
    var initials17 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Initialien", "name": "initials", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Initials","(users.Users.initials) ") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var box1_2_panel18 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name15, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name16, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": initials17, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email22 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "e-mail address", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("e-mail address","(users.Users.email) ") }, "anchor": "-20" });
    var language23 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Sprache", "name": "language", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(users.Users.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "de", "Deutsch" ] ] });
    var box1_3_panel24 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email22, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language23, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var id27 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(users.Users.id) ") }, "anchor": "-20" });
    var created28 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Erstellt", "name": "created", "listeners": { "render": Lino.quicktip_renderer("Created","(users.Users.created) ") }, "value": "<br>", "anchor": "-20" });
    var modified29 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Bearbeitet", "name": "modified", "listeners": { "render": Lino.quicktip_renderer("Modified","(users.Users.modified) ") }, "value": "<br>", "anchor": "-20" });
    var box1_4_panel30 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id27, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created28, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified29, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box1_panel34 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ box1_1_panel11, box1_2_panel18, box1_3_panel24, box1_4_panel30 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var remarks35 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remarks","(users.Users.remarks) ") }, "fieldLabel": "Bemerkungen", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var AuthoritiesGiven_grid38 = new Lino.users.AuthoritiesGiven.GridPanel({ "flex": 33, "hide_top_toolbar": true, "containing_panel": this, "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Authorities given","(users.users.AuthoritiesGiven) ") }, "tools": [ Lino.show_in_own_window_button(Lino.users.AuthoritiesGiven.grid) ], "hideHeaders": true });
    var main_2_panel39 = new Ext.Panel({ "flex": 55, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": remarks35, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 66 }, AuthoritiesGiven_grid38 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel41 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ box1_panel34, main_2_panel39 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel41;
    this.before_row_edit = function(record) {
      AuthoritiesGiven_grid38.on_master_changed();
    }
    Lino.users.Users.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    partner10.on("change", function(){ this.save() }, this);
  }
});


Lino.contacts.Partners.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 14,
  initComponent : function() {
    var name325 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Partners.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language326 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(contacts.Partners.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "de", "Deutsch" ] ], "name": "language" });
    var email327 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Partners.email) ") }, "anchor": "-20" });
    var main_2_panel328 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language326, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email327, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel331 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name325, "anchor": "-20", "labelAlign": "top" }, main_2_panel328 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel331;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Partners.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.Users.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 6,
  initComponent : function() {
    var username42 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Benutzername</span>", "name": "username", "listeners": { "render": Lino.quicktip_renderer("Username","(users.Users.username) Required. Must be unique.") }, "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var email43 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "e-mail address", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("e-mail address","(users.Users.email) ") }, "anchor": "-20" });
    var main_1_panel44 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username42, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email43, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name47 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Vorname", "name": "first_name", "maxLength": 30, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("First name","(users.Users.first_name) ") }, "anchor": "-20" });
    var last_name48 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Familienname", "name": "last_name", "maxLength": 30, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Last name","(users.Users.last_name) ") }, "anchor": "-20" });
    var main_2_panel49 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name47, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name48, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var partner52 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "hiddenName": "partnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(users.Users.partner) ") }, "selectOnFocus": true, "emptyText": "Partner ausw\u00e4hlen...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var language53 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Sprache", "name": "language", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(users.Users.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "de", "Deutsch" ] ] });
    var profile54 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Benutzerprofil</span>", "name": "profile", "hiddenName": "profileHidden", "listeners": { "render": Lino.quicktip_renderer("User Profile","(users.Users.profile) Users with an empty `profile` field are considered inactive and cannot log in.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.users.UserProfiles) });
    var main_4_panel55 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 47, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language53, "labelAlign": "top" }, { "flex": 52, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile54, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel58 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ main_1_panel44, main_2_panel49, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner52, "anchor": "-20", "labelAlign": "top" }, main_4_panel55 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel58;
    this.before_row_edit = function(record) {
    }
    Lino.users.Users.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.About.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var server_status_disp66 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Server-Status", "name": "server_status", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Server status","(about.About.server_status) ") }, "anchor": "-20" });
    var main_panel67 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "html": "<div class=\"htmlText\"><span>This is <b>yet another Lino site</b> using <a href=\"http://www.lino-framework.org\" target=\"_blank\">Lino</a> 1.6.16, <a href=\"http://www.djangoproject.com\" target=\"_blank\">Django</a> 1.6.7, <a href=\"http://www.python.org/\" target=\"_blank\">Python</a> 2.7.4, <a href=\"http://babel.edgewall.org/\" target=\"_blank\">Babel</a> 1.3, <a href=\"http://jinja.pocoo.org/\" target=\"_blank\">Jinja</a> 2.7.2, <a href=\"http://sphinx-doc.org/\" target=\"_blank\">Sphinx</a> 1.3a0, <a href=\"http://labix.org/python-dateutil\" target=\"_blank\">python-dateutil</a> 2.1, <a href=\"http://pypi.python.org/pypi/odfpy\" target=\"_blank\">OdfPy</a> ODFPY/0.9.6, <a href=\"http://docutils.sourceforge.net/\" target=\"_blank\">docutils</a> 0.11, <a href=\"https://fedorahosted.org/suds/\" target=\"_blank\">suds</a> 0.4, <a href=\"http://pyyaml.org/\" target=\"_blank\">PyYaml</a> 3.10, <a href=\"http://appyframework.org/pod.html\" target=\"_blank\">Appy</a> 0.9.0 (2014/06/23 22:15), <a href=\"http://www.sencha.com\" target=\"_blank\">ExtJS</a> <a href=\"#\" onclick=\"alert('ExtJS client version is ' + Ext.version);\" title=\"Click to see ExtJS client version\">(version)</a>, <a href=\"http://www.famfamfam.com/lab/icons/silk/\" target=\"_blank\">Silk Icons</a> 1.3, <a href=\"http://getbootstrap.com\" target=\"_blank\">Bootstrap</a> 3.x</span><p>Server uptime : <b>Monday, December 15, 2014 at 04:46:19.766531</b></p><p>Source timestamps:</p><ul><li>lino : <b>Monday, December 15, 2014 at 04:43:31.108115</b></li><li>atelier : <b>Monday, December 8, 2014 at 18:49:36.429204</b></li><li>django : <b>Monday, October 27, 2014 at 16:34:33.459643</b></li></ul></div>", "xtype": "label" }, { "items": server_status_disp66, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel67;
    this.before_row_edit = function(record) {
    }
    Lino.about.About.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.Models.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var app_disp871 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "app_label", "name": "app", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("app_label","(about.Models.app) ") }, "anchor": "-20" });
    var name_disp872 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "name", "name": "name", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("name","(about.Models.name) ") }, "anchor": "-20" });
    var docstring_disp873 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "docstring", "name": "docstring", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("docstring","(about.Models.docstring) ") }, "anchor": "-20" });
    var rows874 = new Ext.form.NumberField({ "disabled": true, "autoHeight": true, "fieldLabel": "Zeilen", "name": "rows", "listeners": { "render": Lino.quicktip_renderer("Zeilen","(about.Models.rows) ") }, "anchor": "-20" });
    var main_1_panel875 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_disp871, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_disp872, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": docstring_disp873, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": rows874, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var about_FieldsByModel_grid884 = new Lino.about.FieldsByModel.GridPanel({ "flex": 62, "listeners": { "render": Lino.quicktip_renderer("Felder","(about.about.FieldsByModel) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.about.FieldsByModel.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel885 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel875, about_FieldsByModel_grid884 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel885;
    this.before_row_edit = function(record) {
      about_FieldsByModel_grid884.on_master_changed();
    }
    Lino.about.Models.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 12,
  initComponent : function() {
    var last_name340 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Familienname</span>", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Familienname","(contacts.Persons.last_name) Last name (family name).") }, "anchor": "-20" });
    var first_name341 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Vorname</span>", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Vorname","(contacts.Persons.first_name) First or given name.") }, "anchor": "-20" });
    var gender342 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Geschlecht", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Geschlecht","(contacts.Persons.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.system.Genders) });
    var title343 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Anrede</span>", "name": "title", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Anrede","(contacts.Persons.title) Text to print before allocation and name as part of the first address line.") }, "anchor": "-20" });
    var name_box_panel344 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name340, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name341, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender342, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title343, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var country349 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Land", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Land ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Land","(contacts.Persons.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/country", "method": "GET" }) }) });
    var region350 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Regierungsbezirk", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Regierungsbezirk","(contacts.Persons.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/region", "method": "GET" }) }) });
    var city351 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "Stadt", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Ort ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Stadt","(contacts.Persons.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/city", "method": "GET" }) }) });
    var zip_code352 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Postleitzahl", "name": "zip_code", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Postleitzahl","(contacts.Persons.zip_code) ") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var address_box_2_panel353 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country349, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region350, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city351, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code352, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr1358 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile vor Stra\u00dfe</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Adresszeile vor Stra\u00dfe","(contacts.Persons.addr1) Adresszeile vor Stra\u00dfe") }, "anchor": "-20" });
    var street_prefix359 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Pr\u00e4fix Stra\u00dfe</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Pr\u00e4fix Stra\u00dfe","(contacts.Persons.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "anchor": "-20" });
    var street360 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Stra\u00dfe</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Stra\u00dfe","(contacts.Persons.street) Name der Stra\u00dfe, ohne Hausnummer") }, "anchor": "-20" });
    var street_no361 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Nr.</span>", "name": "street_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Nr.","(contacts.Persons.street_no) Hausnummer") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var street_box362 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Box","(contacts.Persons.street_box) Text to print after street nuber on the same line.") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var address_box_4_panel363 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix359, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street360, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no361, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box362, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2368 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Adresszeile nach Stra\u00dfe</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Adresszeile nach Stra\u00dfe","(contacts.Persons.addr2) Adresszeile nach Stra\u00dfe") }, "anchor": "-20" });
    var address_box_panel369 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "layout": "form", "title": "Adresse", "items": [ name_box_panel344, address_box_2_panel353, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1358, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel363, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2368, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var id372 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Persons.id) ") }, "anchor": "-20" });
    var language373 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Sprache</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Sprache","(contacts.Persons.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "Englisch" ], [ "de", "Deutsch" ] ], "name": "language" });
    var info_box_panel374 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id372, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language373, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email377 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Persons.email) ") }, "anchor": "-20" });
    var url378 = new Lino.URLField({ "autoHeight": true, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("URL","(contacts.Persons.url) ") }, "anchor": "-20" });
    var phone379 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Telefon", "name": "phone", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Telefon","(contacts.Persons.phone) ") }, "anchor": "-20" });
    var gsm380 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("GSM","(contacts.Persons.gsm) ") }, "anchor": "-20" });
    var fax381 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Fax","(contacts.Persons.fax) ") }, "anchor": "-20" });
    var contact_box_5_panel382 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm380, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax381, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel385 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "layout": "form", "title": "Kontakt", "items": [ info_box_panel374, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email377, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url378, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone379, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel382 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var main_1_panel389 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ address_box_panel369, contact_box_panel385 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks390 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Bemerkungen","(contacts.Persons.remarks) ") }, "fieldLabel": "Bemerkungen", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var contacts_RolesByPerson_grid395 = new Lino.contacts.RolesByPerson.GridPanel({ "flex": 42, "listeners": { "render": Lino.quicktip_renderer("Kontaktperson f\u00fcr","(contacts.contacts.RolesByPerson) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByPerson.grid) ], "preview_limit": 15, "master_panel": this });
    var bottom_box_panel396 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": remarks390, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 57 }, contacts_RolesByPerson_grid395 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel398 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel389, bottom_box_panel396 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel398;
    this.before_row_edit = function(record) {
      region350.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city351.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city351.setContextValue('region', record ? record.data['regionHidden'] : undefined);
      contacts_RolesByPerson_grid395.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country349.on('change',Lino.chooser_handler(region350,'country'));
      country349.on('change',Lino.chooser_handler(city351,'country'));
      region350.on('change',Lino.chooser_handler(city351,'region'));
      Lino.contacts.Persons.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Persons.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    city351.on("change", function(){ this.save() }, this);
    zip_code352.on("change", function(){ this.save() }, this);
  }
});


Lino.contenttypes.ContentTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 3,
  initComponent : function() {
    var id156 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contenttypes.ContentTypes.id) ") }, "anchor": "-20" });
    var name157 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("name","(contenttypes.ContentTypes.name) ") }, "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var app_label158 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "app label", "name": "app_label", "listeners": { "render": Lino.quicktip_renderer("app label","(contenttypes.ContentTypes.app_label) ") }, "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var model159 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "python model class name", "name": "model", "listeners": { "render": Lino.quicktip_renderer("python model class name","(contenttypes.ContentTypes.model) ") }, "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var base_classes_disp160 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Base classes", "name": "base_classes", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Base classes","(contenttypes.ContentTypes.base_classes) ") }, "anchor": "-20" });
    var main_1_panel161 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id156, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name157, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_label158, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": model159, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": base_classes_disp160, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 216, "border": false, "frame": false, "labelAlign": "top" });
    var HelpTextsByModel_grid173 = new Lino.contenttypes.HelpTextsByModel.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Hilfetexte","(contenttypes.contenttypes.HelpTextsByModel) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.contenttypes.HelpTextsByModel.grid) ] });
    var StaleControllablesByModel_grid177 = new Lino.contenttypes.StaleControllablesByModel.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Stale Controllables","(contenttypes.contenttypes.StaleControllablesByModel) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.contenttypes.StaleControllablesByModel.grid) ] });
    var main_panel178 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "hideCheckBoxLabels": true, "items": [ main_1_panel161, HelpTextsByModel_grid173, StaleControllablesByModel_grid177 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel178;
    this.before_row_edit = function(record) {
      HelpTextsByModel_grid173.on_master_changed();
      StaleControllablesByModel_grid177.on_master_changed();
    }
    Lino.contenttypes.ContentTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.EventTypes.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 19,
  initComponent : function() {
    var name773 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung","(cal.EventTypes.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de774 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung (de)","(cal.EventTypes.name_de) ") }, "anchor": "-20" });
    var main_1_panel775 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name773, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de774, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var event_label778 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung Termin", "name": "event_label", "value": "Termin", "listeners": { "render": Lino.quicktip_renderer("Bezeichnung Termin","(cal.EventTypes.event_label) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var event_label_de779 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Bezeichnung Termin (de)", "name": "event_label_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Bezeichnung Termin (de)","(cal.EventTypes.event_label_de) ") }, "anchor": "-20" });
    var main_2_panel780 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label778, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label_de779, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 216, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel783 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel775, main_2_panel780 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel783;
    this.before_row_edit = function(record) {
    }
    Lino.cal.EventTypes.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 21,
  initComponent : function() {
    var event604 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Termin", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.OneEvent.detail,Lino.cal.OneEvent.insert)}, "emptyText": "Termin ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Termin","(cal.Guests.event) ") }, "selectOnFocus": true, "hiddenName": "eventHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/event", "method": "GET" }) }), "name": "event" });
    var partner605 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "emptyText": "Partner ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Partner","(cal.Guests.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }), "name": "partner" });
    var role606 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Rolle", "name": "role", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.GuestRoles.detail,Lino.cal.GuestRoles.insert)}, "emptyText": "Gastrolle ausw\u00e4hlen...", "listeners": { "render": Lino.quicktip_renderer("Rolle","(cal.Guests.role) ") }, "selectOnFocus": true, "hiddenName": "roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/role", "method": "GET" }) }) });
    var main_panel607 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": event604, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner605, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": role606, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel607;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Guests.InsertFormPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Users.change_password = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.Users.change_password_ActionFormPanel({});
});

// js_render_GridPanel_class contenttypes.ContentTypes
Lino.contenttypes.ContentTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contenttypes/ContentTypes",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/contenttypes/ContentTypes','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/contenttypes/ContentTypes','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Datenbankmodelle",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 5,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "app_label" }, { "name": "model" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 3,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.contenttypes.ContentTypes.detail;
    this.ls_insert_handler = Lino.contenttypes.ContentTypes.insert;
    var ww = this.containing_window;
    var id886 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name887 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var app_label888 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var model889 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(contenttypes.ContentTypes.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id886, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "name", "editable": true, "tooltip": "(contenttypes.ContentTypes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name887, "dataIndex": "name" }, { "colIndex": 2, "sortable": true, "header": "app label", "editable": true, "tooltip": "(contenttypes.ContentTypes.app_label) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": app_label888, "dataIndex": "app_label" }, { "colIndex": 3, "sortable": true, "header": "python model class name", "editable": true, "tooltip": "(contenttypes.ContentTypes.model) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": model889, "dataIndex": "model" } ];
    Lino.contenttypes.ContentTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contenttypes.ContentTypes.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/ContentTypes", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.ContentTypes.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/ContentTypes", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.ContentTypes.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/ContentTypes", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.contenttypes.ContentTypes.insertPanel = Ext.extend(Lino.contenttypes.ContentTypes.DetailFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/contenttypes/ContentTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contenttypes.ContentTypes.detail;
    this.ls_insert_handler = Lino.contenttypes.ContentTypes.insert;
    Lino.contenttypes.ContentTypes.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contenttypes.ContentTypes.insert = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contenttypes.ContentTypes.insertPanel(p);
});
Lino.contenttypes.ContentTypes.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/ContentTypes", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.ContentTypes.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/ContentTypes", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.ContentTypes.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/ContentTypes", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.contenttypes.ContentTypes.detailPanel = Ext.extend(Lino.contenttypes.ContentTypes.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  ls_url: "/contenttypes/ContentTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contenttypes.ContentTypes.detail;
    this.ls_insert_handler = Lino.contenttypes.ContentTypes.insert;
    Lino.contenttypes.ContentTypes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contenttypes.ContentTypes.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contenttypes.ContentTypes.detailPanel(p);
});
Lino.contenttypes.ContentTypes.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/ContentTypes", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.ContentTypes.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contenttypes.ContentTypes.GridPanel(p);
});
Lino.contenttypes.ContentTypes.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/ContentTypes", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class contenttypes.HelpTexts
Lino.contenttypes.HelpTexts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contenttypes/HelpTexts",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/contenttypes/HelpTexts','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/contenttypes/HelpTexts','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Hilfetexte",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "name": "field" }, { "name": "verbose_name" }, { "name": "help_text" }, { "type": "int", "name": "id" }, { "name": "content_type" }, 'content_typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 2,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var field891 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contenttypes/HelpTexts/field", "method": "GET" }) }) });
    var verbose_name892 = new Ext.form.TextField({ "disabled": true, "maxLength": 200 });
    var help_text893 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var id894 = new Ext.form.NumberField({ "selectOnFocus": true });
    var content_type895 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contenttypes/HelpTexts/content_type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Datenbankmodell ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
      field891.setContextValue('content_type', record ? record.data['content_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      content_type895.on('change',Lino.chooser_handler(field891,'content_type'));
      Lino.contenttypes.HelpTexts.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Feld", "editable": true, "tooltip": "(contenttypes.HelpTexts.field) The name of the field.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": field891, "dataIndex": "field" }, { "header": "Feldbezeichnung", "colIndex": 1, "sortable": false, "dataIndex": "verbose_name", "width": Lino.chars2width(22), "editable": false, "tooltip": "(contenttypes.HelpTexts.verbose_name) " }, { "colIndex": 2, "sortable": false, "header": "Hilfetext", "editable": true, "tooltip": "(contenttypes.HelpTexts.help_text) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "editor": help_text893, "dataIndex": "help_text" }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(contenttypes.HelpTexts.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id894, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Modell", "editable": true, "tooltip": "(contenttypes.HelpTexts.content_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('content_typeHidden','Lino.contenttypes.ContentTypes.detail'), "dataIndex": "content_type", "editor": content_type895 } ];
    Lino.contenttypes.HelpTexts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contenttypes.HelpTexts.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/HelpTexts", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.HelpTexts.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/HelpTexts", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.HelpTexts.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/HelpTexts", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.HelpTexts.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/HelpTexts", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.HelpTexts.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/HelpTexts", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.HelpTexts.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/HelpTexts", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.HelpTexts.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contenttypes.HelpTexts.GridPanel(p);
});

// js_render_GridPanel_class system.SiteConfigs
Lino.system.SiteConfigs.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/system/SiteConfigs",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/system/SiteConfigs','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/system/SiteConfigs','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "do_build", "menu_item_text": "Site-Cache rekonstruieren", "panel_btn_handler": Lino.row_action_handler('do_build','GET',null), "text": "Site-Cache rekonstruieren", "overflowText": "Site-Cache rekonstruieren", "auto_save": true } ],
  cell_edit : true,
  title : "Site-Konfigurations",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 12,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "default_build_method" }, 'default_build_methodHidden', { "type": "int", "name": "next_partner_id" }, { "name": "site_company" }, 'site_companyHidden', { "name": "default_event_type" }, 'default_event_typeHidden', { "name": "site_calendar" }, 'site_calendarHidden', { "type": "int", "name": "max_auto_events" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 4,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.system.SiteConfigs.detail;
    var ww = this.containing_window;
    var id897 = new Ext.form.NumberField({ "selectOnFocus": true });
    var default_build_method898 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.BuildMethods) });
    var next_partner_id899 = new Ext.form.NumberField({ "selectOnFocus": true, "value": 100 });
    var site_company900 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/site_company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisation ausw\u00e4hlen..." });
    var default_event_type901 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/default_event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ereignisart ausw\u00e4hlen..." });
    var site_calendar902 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/site_calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    var max_auto_events903 = new Ext.form.NumberField({ "selectOnFocus": true, "value": 72 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.SiteConfigs.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id897, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Standard-Konstruktionsmethode", "editable": true, "tooltip": "(system.SiteConfigs.default_build_method) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": default_build_method898, "dataIndex": "default_build_method" }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.SiteConfigs.next_partner_id) N\u00e4chste Partnernummer", "filter": { "type": "numeric" }, "header": "N\u00e4chste Partnernummer", "editor": next_partner_id899, "width": Lino.chars2width(6), "dataIndex": "next_partner_id" }), { "colIndex": 3, "sortable": true, "header": "Site-Besitzer", "editable": true, "tooltip": "(system.SiteConfigs.site_company) The organisation who runs this site.\n        This is used e.g. as sender in documents.\n        Or, newly created partners inherit the country of the site owner.\n        ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('site_companyHidden','Lino.contacts.Companies.detail'), "dataIndex": "site_company", "editor": site_company900 }, { "colIndex": 4, "sortable": true, "header": "Default Event Type", "editable": true, "tooltip": "(system.SiteConfigs.default_event_type) The default type of events on this site.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('default_event_typeHidden','Lino.cal.EventTypes.detail'), "dataIndex": "default_event_type", "editor": default_event_type901 }, { "colIndex": 5, "sortable": true, "header": "Site Calendar", "editable": true, "tooltip": "(system.SiteConfigs.site_calendar) The default calendar of this site.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('site_calendarHidden','Lino.cal.Calendars.detail'), "dataIndex": "site_calendar", "editor": site_calendar902 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.SiteConfigs.max_auto_events) Maximum number of automatic events to be generated.", "filter": { "type": "numeric" }, "header": "Max automatic events", "editor": max_auto_events903, "width": Lino.chars2width(6), "dataIndex": "max_auto_events" }) ];
    Lino.system.SiteConfigs.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.system.SiteConfigs.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/SiteConfigs", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.SiteConfigs.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/SiteConfigs", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.SiteConfigs.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/SiteConfigs", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.SiteConfigs.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/SiteConfigs", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.SiteConfigs.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/SiteConfigs", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.SiteConfigs.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/SiteConfigs", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.system.SiteConfigs.detailPanel = Ext.extend(Lino.system.SiteConfigs.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "do_build", "menu_item_text": "Site-Cache rekonstruieren", "panel_btn_handler": Lino.row_action_handler('do_build','GET',null), "text": "Site-Cache rekonstruieren", "overflowText": "Site-Cache rekonstruieren", "auto_save": true } ],
  ls_url: "/system/SiteConfigs",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.SiteConfigs.detail;
    Lino.system.SiteConfigs.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.system.SiteConfigs.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.system.SiteConfigs.detailPanel(p);
});
Lino.system.SiteConfigs.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.system.SiteConfigs.GridPanel(p);
});
Lino.system.SiteConfigs.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/SiteConfigs", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.SiteConfigs.do_build = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/SiteConfigs", "GET", pk, "do_build", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class system.TextFieldTemplates
Lino.system.TextFieldTemplates.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/system/TextFieldTemplates",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/system/TextFieldTemplates','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/system/TextFieldTemplates','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Einf\u00fcgetexte",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 5,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "name" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 5,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.system.TextFieldTemplates.detail;
    this.ls_insert_handler = Lino.system.TextFieldTemplates.insert;
    var ww = this.containing_window;
    var id905 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user906 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var name907 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.TextFieldTemplates.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id905, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "tooltip": "(system.TextFieldTemplates.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "dataIndex": "user", "editor": user906 }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(system.TextFieldTemplates.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name907, "dataIndex": "name" } ];
    Lino.system.TextFieldTemplates.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.system.TextFieldTemplates.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/TextFieldTemplates", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.TextFieldTemplates.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/TextFieldTemplates", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.TextFieldTemplates.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/TextFieldTemplates", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.system.TextFieldTemplates.insertPanel = Ext.extend(Lino.system.TextFieldTemplates.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/system/TextFieldTemplates",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.TextFieldTemplates.detail;
    this.ls_insert_handler = Lino.system.TextFieldTemplates.insert;
    Lino.system.TextFieldTemplates.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.system.TextFieldTemplates.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.system.TextFieldTemplates.insertPanel(p);
});
Lino.system.TextFieldTemplates.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/TextFieldTemplates", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.TextFieldTemplates.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/TextFieldTemplates", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.TextFieldTemplates.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/TextFieldTemplates", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.system.TextFieldTemplates.detailPanel = Ext.extend(Lino.system.TextFieldTemplates.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  ls_url: "/system/TextFieldTemplates",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.TextFieldTemplates.detail;
    this.ls_insert_handler = Lino.system.TextFieldTemplates.insert;
    Lino.system.TextFieldTemplates.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.system.TextFieldTemplates.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.system.TextFieldTemplates.detailPanel(p);
});
Lino.system.TextFieldTemplates.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/TextFieldTemplates", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.TextFieldTemplates.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.system.TextFieldTemplates.GridPanel(p);
});
Lino.system.TextFieldTemplates.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/TextFieldTemplates", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class users.Users
Lino.users.Users.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/users/Users",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/users/Users','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/users/Users','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Termine aktualisieren", "tooltip": "Termine aktualisieren", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Termine aktualisieren", "auto_save": true }, { "itemId": "change_password", "menu_item_text": "Passwort \u00e4ndern", "panel_btn_handler": Lino.param_action_handler(Lino.users.Users.change_password), "text": "Passwort \u00e4ndern", "overflowText": "Passwort \u00e4ndern", "auto_save": true } ],
  cell_edit : true,
  title : "Benutzer",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 21,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "first_name" }, { "name": "last_name" }, { "type": "int", "name": "id" }, { "name": "modified" }, { "name": "created" }, { "name": "password" }, { "name": "initials" }, { "name": "email" }, { "name": "remarks" }, { "name": "language" }, 'languageHidden', { "name": "partner" }, 'partnerHidden', { "name": "access_class" }, 'access_classHidden', { "name": "event_type" }, 'event_typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 6,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    var ww = this.containing_window;
    var username69 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile70 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.users.UserProfiles) });
    var first_name71 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var last_name72 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var id73 = new Ext.form.NumberField({ "selectOnFocus": true });
    var modified74 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created75 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var password76 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 128 });
    var initials77 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var email78 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var remarks79 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var language80 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "Englisch" ], [ "de", "Deutsch" ] ] });
    var partner81 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var access_class82 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.AccessClasses });
    var event_type83 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ereignisart ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Benutzername", "editable": true, "tooltip": "(users.Users.username) Required. Must be unique.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": username69, "dataIndex": "username" }, { "colIndex": 1, "sortable": true, "header": "Benutzerprofil", "editable": true, "tooltip": "(users.Users.profile) Users with an empty `profile` field are considered inactive and cannot log in.", "filter": { "type": "string" }, "width": Lino.chars2width(23), "editor": profile70, "dataIndex": "profile" }, { "colIndex": 2, "sortable": true, "header": "Vorname", "editable": true, "tooltip": "(users.Users.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": first_name71, "dataIndex": "first_name" }, { "colIndex": 3, "sortable": true, "header": "Familienname", "editable": true, "tooltip": "(users.Users.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": last_name72, "dataIndex": "last_name" }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.Users.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id73, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(users.Users.modified) ", "header": "Bearbeitet", "dataIndex": "modified", "hidden": true }, { "colIndex": 6, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(users.Users.created) ", "header": "Erstellt", "dataIndex": "created", "hidden": true }, { "colIndex": 7, "sortable": true, "header": "Passwort", "editable": true, "tooltip": "(users.Users.password) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": password76, "hidden": true, "dataIndex": "password" }, { "colIndex": 8, "sortable": true, "header": "Initialien", "editable": true, "tooltip": "(users.Users.initials) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": initials77, "hidden": true, "dataIndex": "initials" }, { "colIndex": 9, "sortable": true, "header": "e-mail address", "editable": true, "tooltip": "(users.Users.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": email78, "hidden": true, "dataIndex": "email" }, { "colIndex": 10, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(users.Users.remarks) ", "filter": { "type": "string" }, "header": "Bemerkungen", "editor": remarks79, "hidden": true, "dataIndex": "remarks" }, { "colIndex": 11, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(users.Users.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": language80, "hidden": true, "dataIndex": "language" }, { "colIndex": 12, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(users.Users.partner) ", "filter": { "type": "string" }, "header": "Partner", "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "dataIndex": "partner", "hidden": true, "editor": partner81 }, { "colIndex": 13, "sortable": true, "header": "Standardm\u00e4\u00dfige Zugriffsklasse", "editable": true, "tooltip": "(users.Users.access_class) Die standardm\u00e4\u00dfige Zugriffsklasse f\u00fcr Ihre Termine und Aufgaben", "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": access_class82, "hidden": true, "dataIndex": "access_class" }, { "colIndex": 14, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(users.Users.event_type) The default event type for your calendar events.", "filter": { "type": "string" }, "header": "Default Event Type", "renderer": Lino.fk_renderer('event_typeHidden','Lino.cal.EventTypes.detail'), "dataIndex": "event_type", "hidden": true, "editor": event_type83 } ];
    Lino.users.Users.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Users.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Users", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Users.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Users", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Users.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Users", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.users.Users.insertPanel = Ext.extend(Lino.users.Users.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/users/Users",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.Users.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Users.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.Users.insertPanel(p);
});
Lino.users.Users.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Users", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Users.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Users", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Users.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Users", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.users.Users.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Termine aktualisieren", "tooltip": "Termine aktualisieren", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Termine aktualisieren", "auto_save": true }, { "itemId": "change_password", "menu_item_text": "Passwort \u00e4ndern", "panel_btn_handler": Lino.param_action_handler(Lino.users.Users.change_password), "text": "Passwort \u00e4ndern", "overflowText": "Passwort \u00e4ndern", "auto_save": true } ],
  ls_url: "/users/Users",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.Users.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Users.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.users.Users.detailPanel(p);
});
Lino.users.Users.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Users", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Users.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.users.Users.GridPanel(p);
});
Lino.users.Users.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Users", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Users.update_reminders = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Users", "GET", pk, "update_reminders", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class users.MySettings
Lino.users.MySettings.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/users/MySettings",
  ls_bbar_actions : [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Termine aktualisieren", "tooltip": "Termine aktualisieren", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Termine aktualisieren", "auto_save": true }, { "itemId": "change_password", "menu_item_text": "Passwort \u00e4ndern", "panel_btn_handler": Lino.param_action_handler(Lino.users.Users.change_password), "text": "Passwort \u00e4ndern", "overflowText": "Passwort \u00e4ndern", "auto_save": true } ],
  cell_edit : true,
  title : "Benutzer",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 21,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "first_name" }, { "name": "last_name" }, { "type": "int", "name": "id" }, { "name": "modified" }, { "name": "created" }, { "name": "password" }, { "name": "initials" }, { "name": "email" }, { "name": "remarks" }, { "name": "language" }, 'languageHidden', { "name": "partner" }, 'partnerHidden', { "name": "access_class" }, 'access_classHidden', { "name": "event_type" }, 'event_typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 6,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    var ww = this.containing_window;
    var username85 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile86 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.users.UserProfiles) });
    var first_name87 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var last_name88 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var id89 = new Ext.form.NumberField({ "selectOnFocus": true });
    var modified90 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created91 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var password92 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 128 });
    var initials93 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var email94 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var remarks95 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var language96 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "Englisch" ], [ "de", "Deutsch" ] ] });
    var partner97 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Partner ausw\u00e4hlen..." });
    var access_class98 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.AccessClasses });
    var event_type99 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ereignisart ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Benutzername", "editable": true, "tooltip": "(users.MySettings.username) Required. Must be unique.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": username85, "dataIndex": "username" }, { "colIndex": 1, "sortable": true, "header": "Benutzerprofil", "editable": true, "tooltip": "(users.MySettings.profile) Users with an empty `profile` field are considered inactive and cannot log in.", "filter": { "type": "string" }, "width": Lino.chars2width(23), "editor": profile86, "dataIndex": "profile" }, { "colIndex": 2, "sortable": true, "header": "Vorname", "editable": true, "tooltip": "(users.MySettings.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": first_name87, "dataIndex": "first_name" }, { "colIndex": 3, "sortable": true, "header": "Familienname", "editable": true, "tooltip": "(users.MySettings.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": last_name88, "dataIndex": "last_name" }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.MySettings.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id89, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(users.MySettings.modified) ", "header": "Bearbeitet", "dataIndex": "modified", "hidden": true }, { "colIndex": 6, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(users.MySettings.created) ", "header": "Erstellt", "dataIndex": "created", "hidden": true }, { "colIndex": 7, "sortable": true, "header": "Passwort", "editable": true, "tooltip": "(users.MySettings.password) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": password92, "hidden": true, "dataIndex": "password" }, { "colIndex": 8, "sortable": true, "header": "Initialien", "editable": true, "tooltip": "(users.MySettings.initials) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": initials93, "hidden": true, "dataIndex": "initials" }, { "colIndex": 9, "sortable": true, "header": "e-mail address", "editable": true, "tooltip": "(users.MySettings.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": email94, "hidden": true, "dataIndex": "email" }, { "colIndex": 10, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(users.MySettings.remarks) ", "filter": { "type": "string" }, "header": "Bemerkungen", "editor": remarks95, "hidden": true, "dataIndex": "remarks" }, { "colIndex": 11, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(users.MySettings.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": language96, "hidden": true, "dataIndex": "language" }, { "colIndex": 12, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(users.MySettings.partner) ", "filter": { "type": "string" }, "header": "Partner", "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "dataIndex": "partner", "hidden": true, "editor": partner97 }, { "colIndex": 13, "sortable": true, "header": "Standardm\u00e4\u00dfige Zugriffsklasse", "editable": true, "tooltip": "(users.MySettings.access_class) Die standardm\u00e4\u00dfige Zugriffsklasse f\u00fcr Ihre Termine und Aufgaben", "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": access_class98, "hidden": true, "dataIndex": "access_class" }, { "colIndex": 14, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(users.MySettings.event_type) The default event type for your calendar events.", "filter": { "type": "string" }, "header": "Default Event Type", "renderer": Lino.fk_renderer('event_typeHidden','Lino.cal.EventTypes.detail'), "dataIndex": "event_type", "hidden": true, "editor": event_type99 } ];
    Lino.users.MySettings.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.MySettings.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.MySettings.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.MySettings.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.MySettings.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.MySettings.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Benutzer",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Termine aktualisieren", "tooltip": "Termine aktualisieren", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Termine aktualisieren", "auto_save": true }, { "itemId": "change_password", "menu_item_text": "Passwort \u00e4ndern", "panel_btn_handler": Lino.param_action_handler(Lino.users.Users.change_password), "text": "Passwort \u00e4ndern", "overflowText": "Passwort \u00e4ndern", "auto_save": true } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});

Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Benutzer",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Termine aktualisieren", "tooltip": "Termine aktualisieren", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Termine aktualisieren", "auto_save": true }, { "itemId": "change_password", "menu_item_text": "Passwort \u00e4ndern", "panel_btn_handler": Lino.param_action_handler(Lino.users.Users.change_password), "text": "Passwort \u00e4ndern", "overflowText": "Passwort \u00e4ndern", "auto_save": true } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});
Lino.users.MySettings.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.MySettings.update_reminders = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "update_reminders", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class users.UsersOverview
Lino.users.UsersOverview.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/users/UsersOverview",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/users/UsersOverview','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/users/UsersOverview','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Termine aktualisieren", "tooltip": "Termine aktualisieren", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Termine aktualisieren", "auto_save": true }, { "itemId": "change_password", "menu_item_text": "Passwort \u00e4ndern", "panel_btn_handler": Lino.param_action_handler(Lino.users.Users.change_password), "text": "Passwort \u00e4ndern", "overflowText": "Passwort \u00e4ndern", "auto_save": true } ],
  cell_edit : true,
  title : "Benutzer",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "language" }, 'languageHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 6,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.UsersOverview.detail;
    this.ls_insert_handler = Lino.users.UsersOverview.insert;
    var ww = this.containing_window;
    var username101 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile102 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.users.UserProfiles) });
    var language103 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "Englisch" ], [ "de", "Deutsch" ] ] });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Benutzername", "editable": true, "tooltip": "(users.UsersOverview.username) Required. Must be unique.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": username101, "dataIndex": "username" }, { "colIndex": 1, "sortable": true, "header": "Benutzerprofil", "editable": true, "tooltip": "(users.UsersOverview.profile) Users with an empty `profile` field are considered inactive and cannot log in.", "filter": { "type": "string" }, "width": Lino.chars2width(23), "editor": profile102, "dataIndex": "profile" }, { "colIndex": 2, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(users.UsersOverview.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": language103, "dataIndex": "language" } ];
    Lino.users.UsersOverview.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.UsersOverview.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/UsersOverview", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.UsersOverview.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/UsersOverview", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.UsersOverview.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/UsersOverview", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.users.UsersOverview.insertPanel = Ext.extend(Lino.users.Users.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/users/UsersOverview",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.UsersOverview.detail;
    this.ls_insert_handler = Lino.users.UsersOverview.insert;
    Lino.users.UsersOverview.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.users.UsersOverview.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.UsersOverview.insertPanel(p);
});
Lino.users.UsersOverview.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/UsersOverview", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.UsersOverview.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/UsersOverview", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.UsersOverview.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/UsersOverview", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.users.UsersOverview.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Termine aktualisieren", "tooltip": "Termine aktualisieren", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Termine aktualisieren", "auto_save": true }, { "itemId": "change_password", "menu_item_text": "Passwort \u00e4ndern", "panel_btn_handler": Lino.param_action_handler(Lino.users.Users.change_password), "text": "Passwort \u00e4ndern", "overflowText": "Passwort \u00e4ndern", "auto_save": true } ],
  ls_url: "/users/UsersOverview",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.UsersOverview.detail;
    this.ls_insert_handler = Lino.users.UsersOverview.insert;
    Lino.users.UsersOverview.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.UsersOverview.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.users.UsersOverview.detailPanel(p);
});
Lino.users.UsersOverview.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/UsersOverview", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.UsersOverview.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.users.UsersOverview.GridPanel(p);
});
Lino.users.UsersOverview.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/UsersOverview", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.UsersOverview.update_reminders = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/UsersOverview", "GET", pk, "update_reminders", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class users.Authorities
Lino.users.Authorities.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/users/Authorities",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/users/Authorities','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/users/Authorities','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Vollmachten",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "authorized" }, 'authorizedHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 7,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id105 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user106 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Authorities/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var authorized107 = new Lino.RemoteComboFieldElement({ "preferred_width": 15, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Authorities/authorized", "method": "GET" }) }), "emptyText": "Benutzer ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
      authorized107.setContextValue('user', record ? record.data['userHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      user106.on('change',Lino.chooser_handler(authorized107,'user'));
      Lino.users.Authorities.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.Authorities.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id105, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "tooltip": "(users.Authorities.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "dataIndex": "user", "editor": user106 }, { "colIndex": 2, "sortable": true, "header": "Benutzer", "editable": true, "tooltip": "(users.Authorities.authorized) The user who gets authority to act in your name.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('authorizedHidden','Lino.users.Users.detail'), "dataIndex": "authorized", "editor": authorized107 } ];
    Lino.users.Authorities.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Authorities.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Authorities", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Authorities.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Authorities", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Authorities.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Authorities", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Authorities.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Authorities", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Authorities.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Authorities", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Authorities.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Authorities", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Authorities.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.users.Authorities.GridPanel(p);
});

// js_render_GridPanel_class countries.Countries
Lino.countries.Countries.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/countries/Countries",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/countries/Countries','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/countries/Countries','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "L\u00e4nder",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "name": "isocode" }, { "name": "short_code" }, { "name": "iso3" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 8,
  ls_id_property : "isocode",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    var ww = this.containing_window;
    var name909 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de910 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var isocode911 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "allowBlank": false, "maxLength": 4 });
    var short_code912 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    var iso3913 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "maxLength": 3 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(countries.Countries.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name909, "dataIndex": "name" }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (de)", "editable": true, "tooltip": "(countries.Countries.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_de910, "dataIndex": "name_de" }, { "colIndex": 2, "sortable": true, "header": "ISO-Code", "editable": true, "tooltip": "(countries.Countries.isocode)         The two-letter code for this country as defined by ISO 3166-1.\n        For countries that no longer exist it may be a 4-letter code.", "filter": { "type": "string" }, "width": Lino.chars2width(6), "editor": isocode911, "dataIndex": "isocode" }, { "colIndex": 3, "sortable": true, "header": "Short code", "editable": true, "tooltip": "(countries.Countries.short_code) A short abbreviation for regional usage. Obsolete.", "filter": { "type": "string" }, "width": Lino.chars2width(6), "editor": short_code912, "hidden": true, "dataIndex": "short_code" }, { "colIndex": 4, "sortable": true, "header": "ISO3-Code", "editable": true, "tooltip": "(countries.Countries.iso3) The three-letter code for this country as defined by ISO 3166-1.", "filter": { "type": "string" }, "width": Lino.chars2width(5), "editor": iso3913, "hidden": true, "dataIndex": "iso3" } ];
    Lino.countries.Countries.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Countries.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Countries.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.countries.Countries.insertPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/countries/Countries",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    Lino.countries.Countries.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.insert = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Countries.insertPanel(p);
});
Lino.countries.Countries.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Countries.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Countries.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.countries.Countries.detailPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  ls_url: "/countries/Countries",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    Lino.countries.Countries.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.detailPanel(p);
});
Lino.countries.Countries.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Countries.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.GridPanel(p);
});
Lino.countries.Countries.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class countries.Places
Lino.countries.Places.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/countries/Places",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/countries/Places','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/countries/Places','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Orte",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 11,
  ls_store_fields : [ { "name": "country" }, 'countryHidden', { "name": "name" }, { "name": "name_de" }, { "name": "type" }, 'typeHidden', { "name": "zip_code" }, { "name": "parent" }, 'parentHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 9,
  ls_grid_configs : [  ],
  content_type : 9,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Places.detail;
    this.ls_insert_handler = Lino.countries.Places.insert;
    var ww = this.containing_window;
    var country915 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Places/country", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var name916 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de917 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type918 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Places/type", "method": "GET" }) }) });
    var zip_code919 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "maxLength": 8 });
    var parent920 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Places/parent", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var id921 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      type918.setContextValue('country', record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country915.on('change',Lino.chooser_handler(type918,'country'));
      Lino.countries.Places.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Land", "editable": true, "tooltip": "(countries.Places.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "dataIndex": "country", "editor": country915 }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(countries.Places.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name916, "dataIndex": "name" }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (de)", "editable": true, "tooltip": "(countries.Places.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_de917, "dataIndex": "name_de" }, { "colIndex": 3, "sortable": true, "header": "Ortsart", "editable": true, "tooltip": "(countries.Places.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": type918, "dataIndex": "type" }, { "colIndex": 4, "sortable": true, "header": "zip code", "editable": true, "tooltip": "(countries.Places.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(10), "editor": zip_code919, "dataIndex": "zip_code" }, { "colIndex": 5, "sortable": true, "header": "Teil von", "editable": true, "tooltip": "(countries.Places.parent) The superordinate geographic place         of which this place is a part.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('parentHidden','Lino.countries.Places.detail'), "dataIndex": "parent", "editor": parent920 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(countries.Places.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id921, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.countries.Places.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Places.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Places", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Places.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Places", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Places.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Places", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.countries.Places.insertPanel = Ext.extend(Lino.countries.Places.DetailFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/countries/Places",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Places.detail;
    this.ls_insert_handler = Lino.countries.Places.insert;
    Lino.countries.Places.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Places.insert = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Places.insertPanel(p);
});
Lino.countries.Places.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Places", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Places.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Places", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Places.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Places", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.countries.Places.detailPanel = Ext.extend(Lino.countries.Places.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  ls_url: "/countries/Places",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Places.detail;
    this.ls_insert_handler = Lino.countries.Places.insert;
    Lino.countries.Places.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Places.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Places.detailPanel(p);
});
Lino.countries.Places.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Places", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Places.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Places.GridPanel(p);
});
Lino.countries.Places.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Places", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class contacts.CompanyTypes
Lino.contacts.CompanyTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/CompanyTypes",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/contacts/CompanyTypes','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/contacts/CompanyTypes','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Organisationsarten",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "type": "int", "name": "id" }, { "name": "abbr" }, { "name": "abbr_de" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 15,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var name923 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de924 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id925 = new Ext.form.NumberField({ "selectOnFocus": true });
    var abbr926 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var abbr_de927 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(contacts.CompanyTypes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name923, "dataIndex": "name" }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (de)", "editable": true, "tooltip": "(contacts.CompanyTypes.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_de924, "dataIndex": "name_de" }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.CompanyTypes.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id925, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 3, "sortable": true, "header": "Abk\u00fcrzung", "editable": true, "tooltip": "(contacts.CompanyTypes.abbr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": abbr926, "hidden": true, "dataIndex": "abbr" }, { "colIndex": 4, "sortable": true, "header": "Abk\u00fcrzung (de)", "editable": true, "tooltip": "(contacts.CompanyTypes.abbr_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": abbr_de927, "hidden": true, "dataIndex": "abbr_de" } ];
    Lino.contacts.CompanyTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.CompanyTypes.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/CompanyTypes", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.CompanyTypes.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/CompanyTypes", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.CompanyTypes.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/CompanyTypes", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.CompanyTypes.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/CompanyTypes", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.CompanyTypes.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/CompanyTypes", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.CompanyTypes.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/CompanyTypes", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.CompanyTypes.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.CompanyTypes.GridPanel(p);
});

// js_render_GridPanel_class contacts.Partners
Lino.contacts.Partners.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/Partners",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/contacts/Partners','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "print_labels", "menu_item_text": "Etiketten", "tooltip": "Generate mailing labels for these recipients", "panel_btn_handler": Lino.list_action_handler('/contacts/Partners','print_labels','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-pdf", "overflowText": "Etiketten", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/contacts/Partners','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Partner",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 24,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "zip_code" }, { "name": "region" }, 'regionHidden', { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 22,
  ls_grid_configs : [  ],
  content_type : 14,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    var ww = this.containing_window;
    var name929 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email930 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var country931 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city932 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code933 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var region934 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var addr1935 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix936 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street937 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no938 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box939 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr2940 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language941 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "Englisch" ], [ "de", "Deutsch" ] ] });
    var url942 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone943 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm944 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax945 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks946 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var id947 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city932.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city932.setContextValue('region', record ? record.data['regionHidden'] : undefined);
      region934.setContextValue('country', record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country931.on('change',Lino.chooser_handler(city932,'country'));
      region934.on('change',Lino.chooser_handler(city932,'region'));
      country931.on('change',Lino.chooser_handler(region934,'country'));
      Lino.contacts.Partners.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.Partners.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name929, "dataIndex": "name" }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.Partners.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": email930, "dataIndex": "email" }, { "colIndex": 2, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Partners.country) ", "filter": { "type": "string" }, "header": "Land", "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "dataIndex": "country", "hidden": true, "editor": country931 }, { "colIndex": 3, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Partners.city) ", "filter": { "type": "string" }, "header": "Stadt", "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Places.detail'), "dataIndex": "city", "hidden": true, "editor": city932 }, { "colIndex": 4, "sortable": true, "header": "Postleitzahl", "editable": true, "tooltip": "(contacts.Partners.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": zip_code933, "hidden": true, "dataIndex": "zip_code" }, { "colIndex": 5, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Partners.region) ", "filter": { "type": "string" }, "header": "Regierungsbezirk", "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Places.detail'), "dataIndex": "region", "hidden": true, "editor": region934 }, { "colIndex": 6, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "(contacts.Partners.addr1) Adresszeile vor Stra\u00dfe", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": addr1935, "hidden": true, "dataIndex": "addr1" }, { "colIndex": 7, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "(contacts.Partners.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": street_prefix936, "hidden": true, "dataIndex": "street_prefix" }, { "colIndex": 8, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "(contacts.Partners.street) Name der Stra\u00dfe, ohne Hausnummer", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": street937, "hidden": true, "dataIndex": "street" }, { "colIndex": 9, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "(contacts.Partners.street_no) Hausnummer", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": street_no938, "hidden": true, "dataIndex": "street_no" }, { "colIndex": 10, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.Partners.street_box) Text to print after street nuber on the same line.", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": street_box939, "hidden": true, "dataIndex": "street_box" }, { "colIndex": 11, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "(contacts.Partners.addr2) Adresszeile nach Stra\u00dfe", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": addr2940, "hidden": true, "dataIndex": "addr2" }, { "colIndex": 12, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(contacts.Partners.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": language941, "hidden": true, "dataIndex": "language" }, { "colIndex": 13, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.Partners.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": url942, "hidden": true, "dataIndex": "url" }, { "colIndex": 14, "sortable": true, "header": "Telefon", "editable": true, "tooltip": "(contacts.Partners.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": phone943, "hidden": true, "dataIndex": "phone" }, { "colIndex": 15, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.Partners.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": gsm944, "hidden": true, "dataIndex": "gsm" }, { "colIndex": 16, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.Partners.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": fax945, "hidden": true, "dataIndex": "fax" }, { "colIndex": 17, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(contacts.Partners.remarks) ", "filter": { "type": "string" }, "header": "Bemerkungen", "editor": remarks946, "hidden": true, "dataIndex": "remarks" }, new Lino.NullNumberColumn({ "colIndex": 18, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.Partners.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id947, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.Partners.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Partners.print_labels = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "print_labels", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Partners.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Partners.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.contacts.Partners.insertPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/contacts/Partners",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    Lino.contacts.Partners.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Partners.insertPanel(p);
});
Lino.contacts.Partners.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Partners.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Partners.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.contacts.Partners.detailPanel = Ext.extend(Lino.contacts.Partners.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  ls_url: "/contacts/Partners",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    Lino.contacts.Partners.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Partners.detailPanel(p);
});
Lino.contacts.Partners.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Partners.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Partners.GridPanel(p);
});
Lino.contacts.Partners.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class contacts.Persons
Lino.contacts.Persons.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/Persons",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/contacts/Persons','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "print_labels", "menu_item_text": "Etiketten", "tooltip": "Generate mailing labels for these recipients", "panel_btn_handler": Lino.list_action_handler('/contacts/Persons','print_labels','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-pdf", "overflowText": "Etiketten", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/contacts/Persons','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Personen",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 33,
  ls_store_fields : [ { "name": "name_column" }, { "name": "address_column" }, { "name": "email" }, { "name": "phone" }, { "name": "gsm" }, { "type": "int", "name": "id" }, { "name": "language" }, 'languageHidden', { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "zip_code" }, { "name": "region" }, 'regionHidden', { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "name" }, { "name": "url" }, { "name": "fax" }, { "name": "remarks" }, { "name": "first_name" }, { "name": "middle_name" }, { "name": "last_name" }, { "name": "gender" }, 'genderHidden', { "name": "birth_date" }, { "name": "title" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 14,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    var ww = this.containing_window;
    var name_column_disp949 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var address_column_disp950 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var email951 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone952 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm953 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id954 = new Ext.form.NumberField({ "selectOnFocus": true });
    var language955 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "Englisch" ], [ "de", "Deutsch" ] ] });
    var country956 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city957 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code958 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var region959 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var addr1960 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix961 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street962 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no963 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box964 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr2965 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name966 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var url967 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var fax968 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks969 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var first_name970 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var middle_name971 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var last_name972 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gender973 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.system.Genders) });
    var birth_date974 = new Lino.IncompleteDateField({ "selectOnFocus": true });
    var title975 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
      city957.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city957.setContextValue('region', record ? record.data['regionHidden'] : undefined);
      region959.setContextValue('country', record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country956.on('change',Lino.chooser_handler(city957,'country'));
      region959.on('change',Lino.chooser_handler(city957,'region'));
      country956.on('change',Lino.chooser_handler(region959,'country'));
      Lino.contacts.Persons.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "header": "Name", "colIndex": 0, "sortable": false, "dataIndex": "name_column", "width": Lino.chars2width(21), "editable": false, "tooltip": "(contacts.Persons.name_column) " }, { "header": "Adresse", "colIndex": 1, "sortable": false, "dataIndex": "address_column", "width": Lino.chars2width(31), "editable": false, "tooltip": "(contacts.Persons.address_column) " }, { "colIndex": 2, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.Persons.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": email951, "dataIndex": "email" }, { "colIndex": 3, "sortable": true, "header": "Telefon", "editable": true, "tooltip": "(contacts.Persons.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": phone952, "dataIndex": "phone" }, { "colIndex": 4, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.Persons.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": gsm953, "dataIndex": "gsm" }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.Persons.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id954, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(contacts.Persons.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": language955, "dataIndex": "language" }, { "colIndex": 7, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Persons.country) ", "filter": { "type": "string" }, "header": "Land", "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "dataIndex": "country", "hidden": true, "editor": country956 }, { "colIndex": 8, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Persons.city) ", "filter": { "type": "string" }, "header": "Stadt", "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Places.detail'), "dataIndex": "city", "hidden": true, "editor": city957 }, { "colIndex": 9, "sortable": true, "header": "Postleitzahl", "editable": true, "tooltip": "(contacts.Persons.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": zip_code958, "hidden": true, "dataIndex": "zip_code" }, { "colIndex": 10, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Persons.region) ", "filter": { "type": "string" }, "header": "Regierungsbezirk", "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Places.detail'), "dataIndex": "region", "hidden": true, "editor": region959 }, { "colIndex": 11, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "(contacts.Persons.addr1) Adresszeile vor Stra\u00dfe", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": addr1960, "hidden": true, "dataIndex": "addr1" }, { "colIndex": 12, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "(contacts.Persons.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": street_prefix961, "hidden": true, "dataIndex": "street_prefix" }, { "colIndex": 13, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "(contacts.Persons.street) Name der Stra\u00dfe, ohne Hausnummer", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": street962, "hidden": true, "dataIndex": "street" }, { "colIndex": 14, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "(contacts.Persons.street_no) Hausnummer", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": street_no963, "hidden": true, "dataIndex": "street_no" }, { "colIndex": 15, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.Persons.street_box) Text to print after street nuber on the same line.", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": street_box964, "hidden": true, "dataIndex": "street_box" }, { "colIndex": 16, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "(contacts.Persons.addr2) Adresszeile nach Stra\u00dfe", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": addr2965, "hidden": true, "dataIndex": "addr2" }, { "colIndex": 17, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.Persons.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name966, "hidden": true, "dataIndex": "name" }, { "colIndex": 18, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.Persons.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": url967, "hidden": true, "dataIndex": "url" }, { "colIndex": 19, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.Persons.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": fax968, "hidden": true, "dataIndex": "fax" }, { "colIndex": 20, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(contacts.Persons.remarks) ", "filter": { "type": "string" }, "header": "Bemerkungen", "editor": remarks969, "hidden": true, "dataIndex": "remarks" }, { "colIndex": 21, "sortable": true, "header": "Vorname", "editable": true, "tooltip": "(contacts.Persons.first_name) First or given name.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": first_name970, "hidden": true, "dataIndex": "first_name" }, { "colIndex": 22, "sortable": true, "header": "Zwischenname", "editable": true, "tooltip": "(contacts.Persons.middle_name) Space-separated list of all middle names.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": middle_name971, "hidden": true, "dataIndex": "middle_name" }, { "colIndex": 23, "sortable": true, "header": "Familienname", "editable": true, "tooltip": "(contacts.Persons.last_name) Last name (family name).", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": last_name972, "hidden": true, "dataIndex": "last_name" }, { "colIndex": 24, "sortable": true, "header": "Geschlecht", "editable": true, "tooltip": "(contacts.Persons.gender) ", "filter": { "type": "string" }, "width": Lino.chars2width(10), "editor": gender973, "hidden": true, "dataIndex": "gender" }, { "colIndex": 25, "sortable": true, "header": "Geburtsdatum", "editable": true, "tooltip": "(contacts.Persons.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".", "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": birth_date974, "hidden": true, "dataIndex": "birth_date" }, { "colIndex": 26, "sortable": true, "header": "Anrede", "editable": true, "tooltip": "(contacts.Persons.title) Text to print before allocation and name as part of the first address line.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": title975, "hidden": true, "dataIndex": "title" } ];
    Lino.contacts.Persons.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Persons.print_labels = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "print_labels", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Persons.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Persons.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.contacts.Persons.insertPanel = Ext.extend(Lino.contacts.Persons.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/contacts/Persons",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    Lino.contacts.Persons.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Persons.insertPanel(p);
});
Lino.contacts.Persons.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Persons.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Persons.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.contacts.Persons.detailPanel = Ext.extend(Lino.contacts.Persons.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  ls_url: "/contacts/Persons",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    Lino.contacts.Persons.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Persons.detailPanel(p);
});
Lino.contacts.Persons.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Persons.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Persons.GridPanel(p);
});
Lino.contacts.Persons.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class contacts.Companies
Lino.contacts.Companies.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/Companies",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/contacts/Companies','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "print_labels", "menu_item_text": "Etiketten", "tooltip": "Generate mailing labels for these recipients", "panel_btn_handler": Lino.list_action_handler('/contacts/Companies','print_labels','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-pdf", "overflowText": "Etiketten", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/contacts/Companies','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Organisationen",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 29,
  ls_store_fields : [ { "name": "name_column" }, { "name": "address_column" }, { "name": "email" }, { "name": "phone" }, { "name": "gsm" }, { "type": "int", "name": "id" }, { "name": "language" }, 'languageHidden', { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "zip_code" }, { "name": "region" }, 'regionHidden', { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "name" }, { "name": "url" }, { "name": "fax" }, { "name": "remarks" }, { "name": "prefix" }, { "name": "type" }, 'typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 14,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    var ww = this.containing_window;
    var name_column_disp977 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var address_column_disp978 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var email979 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone980 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm981 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id982 = new Ext.form.NumberField({ "selectOnFocus": true });
    var language983 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "Englisch" ], [ "de", "Deutsch" ] ] });
    var country984 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var city985 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var zip_code986 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var region987 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var addr1988 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix989 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street990 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no991 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box992 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr2993 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name994 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var url995 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var fax996 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks997 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var prefix998 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type999 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Organisationsart ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
      city985.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city985.setContextValue('region', record ? record.data['regionHidden'] : undefined);
      region987.setContextValue('country', record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country984.on('change',Lino.chooser_handler(city985,'country'));
      region987.on('change',Lino.chooser_handler(city985,'region'));
      country984.on('change',Lino.chooser_handler(region987,'country'));
      Lino.contacts.Companies.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "header": "Name", "colIndex": 0, "sortable": false, "dataIndex": "name_column", "width": Lino.chars2width(21), "editable": false, "tooltip": "(contacts.Companies.name_column) " }, { "header": "Adresse", "colIndex": 1, "sortable": false, "dataIndex": "address_column", "width": Lino.chars2width(31), "editable": false, "tooltip": "(contacts.Companies.address_column) " }, { "colIndex": 2, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.Companies.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": email979, "dataIndex": "email" }, { "colIndex": 3, "sortable": true, "header": "Telefon", "editable": true, "tooltip": "(contacts.Companies.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": phone980, "dataIndex": "phone" }, { "colIndex": 4, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.Companies.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": gsm981, "dataIndex": "gsm" }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.Companies.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id982, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(contacts.Companies.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": language983, "dataIndex": "language" }, { "colIndex": 7, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Companies.country) ", "filter": { "type": "string" }, "header": "Land", "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "dataIndex": "country", "hidden": true, "editor": country984 }, { "colIndex": 8, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Companies.city) ", "filter": { "type": "string" }, "header": "Stadt", "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Places.detail'), "dataIndex": "city", "hidden": true, "editor": city985 }, { "colIndex": 9, "sortable": true, "header": "Postleitzahl", "editable": true, "tooltip": "(contacts.Companies.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": zip_code986, "hidden": true, "dataIndex": "zip_code" }, { "colIndex": 10, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Companies.region) ", "filter": { "type": "string" }, "header": "Regierungsbezirk", "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Places.detail'), "dataIndex": "region", "hidden": true, "editor": region987 }, { "colIndex": 11, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "(contacts.Companies.addr1) Adresszeile vor Stra\u00dfe", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": addr1988, "hidden": true, "dataIndex": "addr1" }, { "colIndex": 12, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "(contacts.Companies.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": street_prefix989, "hidden": true, "dataIndex": "street_prefix" }, { "colIndex": 13, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "(contacts.Companies.street) Name der Stra\u00dfe, ohne Hausnummer", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": street990, "hidden": true, "dataIndex": "street" }, { "colIndex": 14, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "(contacts.Companies.street_no) Hausnummer", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": street_no991, "hidden": true, "dataIndex": "street_no" }, { "colIndex": 15, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.Companies.street_box) Text to print after street nuber on the same line.", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": street_box992, "hidden": true, "dataIndex": "street_box" }, { "colIndex": 16, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "(contacts.Companies.addr2) Adresszeile nach Stra\u00dfe", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": addr2993, "hidden": true, "dataIndex": "addr2" }, { "colIndex": 17, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.Companies.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name994, "hidden": true, "dataIndex": "name" }, { "colIndex": 18, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.Companies.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": url995, "hidden": true, "dataIndex": "url" }, { "colIndex": 19, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.Companies.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": fax996, "hidden": true, "dataIndex": "fax" }, { "colIndex": 20, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(contacts.Companies.remarks) ", "filter": { "type": "string" }, "header": "Bemerkungen", "editor": remarks997, "hidden": true, "dataIndex": "remarks" }, { "colIndex": 21, "sortable": true, "header": "Name prefix", "editable": true, "tooltip": "(contacts.Companies.prefix) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": prefix998, "hidden": true, "dataIndex": "prefix" }, { "colIndex": 22, "sortable": true, "header": "Organisationsart", "editable": true, "tooltip": "(contacts.Companies.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": type999, "hidden": true, "dataIndex": "type" } ];
    Lino.contacts.Companies.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Companies.print_labels = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "print_labels", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Companies.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Companies.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.contacts.Companies.insertPanel = Ext.extend(Lino.contacts.Companies.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/contacts/Companies",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    Lino.contacts.Companies.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Companies.insertPanel(p);
});
Lino.contacts.Companies.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Companies.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Companies.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.contacts.Companies.detailPanel = Ext.extend(Lino.contacts.Companies.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  ls_url: "/contacts/Companies",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    Lino.contacts.Companies.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Companies.detailPanel(p);
});
Lino.contacts.Companies.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Companies.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Companies.GridPanel(p);
});
Lino.contacts.Companies.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class contacts.RoleTypes
Lino.contacts.RoleTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/RoleTypes",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/contacts/RoleTypes','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/contacts/RoleTypes','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Funktionen",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 4,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 10,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id1001 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1002 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1003 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.RoleTypes.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1001, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(contacts.RoleTypes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name1002, "dataIndex": "name" }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (de)", "editable": true, "tooltip": "(contacts.RoleTypes.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_de1003, "dataIndex": "name_de" } ];
    Lino.contacts.RoleTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.RoleTypes.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/RoleTypes", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.RoleTypes.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/RoleTypes", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.RoleTypes.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/RoleTypes", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.RoleTypes.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/RoleTypes", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.RoleTypes.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/RoleTypes", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.RoleTypes.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/RoleTypes", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.RoleTypes.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.RoleTypes.GridPanel(p);
});

// js_render_GridPanel_class contacts.Roles
Lino.contacts.Roles.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/Roles",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/contacts/Roles','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/contacts/Roles','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Kontaktpersonen",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 8,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "type" }, 'typeHidden', { "name": "person" }, 'personHidden', { "name": "company" }, 'companyHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 13,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id1005 = new Ext.form.NumberField({ "selectOnFocus": true });
    var type1006 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Roles/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Funktion ausw\u00e4hlen..." });
    var person1007 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Roles/person", "method": "GET" }) }), "emptyText": "Person ausw\u00e4hlen..." });
    var company1008 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Roles/company", "method": "GET" }) }), "emptyText": "Organisation ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.Roles.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1005, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Funktion", "editable": true, "tooltip": "(contacts.Roles.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": type1006, "dataIndex": "type" }, { "colIndex": 2, "sortable": true, "header": "Person", "editable": true, "tooltip": "(contacts.Roles.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('personHidden','Lino.contacts.Persons.detail'), "dataIndex": "person", "editor": person1007 }, { "colIndex": 3, "sortable": true, "header": "Organisation", "editable": true, "tooltip": "(contacts.Roles.company) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('companyHidden','Lino.contacts.Companies.detail'), "dataIndex": "company", "editor": company1008 } ];
    Lino.contacts.Roles.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Roles.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Roles", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Roles.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Roles", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Roles.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Roles", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Roles.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Roles", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Roles.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Roles", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Roles.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Roles", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Roles.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Roles.GridPanel(p);
});

// js_render_GridPanel_class cal.RemoteCalendars
Lino.cal.RemoteCalendars.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/RemoteCalendars",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/RemoteCalendars','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/RemoteCalendars','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Rauf", "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-arrow_up", "overflowText": "Rauf", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Runter", "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-arrow_down", "overflowText": "Runter", "auto_save": true } ],
  cell_edit : true,
  title : "Externe Kalender",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 9,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "type": "int", "name": "seqno" }, { "name": "type" }, 'typeHidden', { "name": "url_template" }, { "name": "username" }, { "name": "password" }, { "type": "boolean", "name": "readonly" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 22,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id1010 = new Ext.form.NumberField({ "selectOnFocus": true });
    var seqno1011 = new Ext.form.NumberField({ "selectOnFocus": true });
    var type1012 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "local", "Local Calendar" ], [ "google", "Google Calendar" ] ], "allowBlank": false, "value": "local" });
    var url_template1013 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var username1014 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var password1015 = new Ext.form.TextField({ "selectOnFocus": true, "inputType": "password", "maxLength": 200 });
    var readonly1016 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.RemoteCalendars.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1010, "width": Lino.chars2width(6), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.RemoteCalendars.seqno) ", "filter": { "type": "numeric" }, "header": "Seq.-Nr.", "editor": seqno1011, "width": Lino.chars2width(6), "dataIndex": "seqno" }), { "colIndex": 2, "sortable": true, "header": "Art", "editable": true, "tooltip": "(cal.RemoteCalendars.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": type1012, "dataIndex": "type" }, { "colIndex": 3, "sortable": true, "header": "URL-Vorlage", "editable": true, "tooltip": "(cal.RemoteCalendars.url_template) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": url_template1013, "dataIndex": "url_template" }, { "colIndex": 4, "sortable": true, "header": "Benutzername", "editable": true, "tooltip": "(cal.RemoteCalendars.username) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": username1014, "dataIndex": "username" }, { "colIndex": 5, "sortable": true, "header": "Passwort", "editable": true, "tooltip": "(cal.RemoteCalendars.password) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": password1015, "dataIndex": "password" }, { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.RemoteCalendars.readonly) ", "filter": { "type": "boolean" }, "header": "schreibgesch\u00fctzt", "dataIndex": "readonly" } ];
    Lino.cal.RemoteCalendars.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.RemoteCalendars.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RemoteCalendars", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.RemoteCalendars.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RemoteCalendars", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.RemoteCalendars.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RemoteCalendars", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.RemoteCalendars.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RemoteCalendars", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.RemoteCalendars.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RemoteCalendars", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.RemoteCalendars.duplicate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RemoteCalendars", "GET", pk, "duplicate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.RemoteCalendars.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RemoteCalendars", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.RemoteCalendars.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.RemoteCalendars.GridPanel(p);
});
Lino.cal.RemoteCalendars.move_up = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RemoteCalendars", "GET", pk, "move_up", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.RemoteCalendars.move_down = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RemoteCalendars", "GET", pk, "move_down", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.Rooms
Lino.cal.Rooms.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/Rooms",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/Rooms','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/Rooms','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "R\u00e4ume",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 4,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 17,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Rooms.detail;
    this.ls_insert_handler = Lino.cal.Rooms.insert;
    var ww = this.containing_window;
    var id1018 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1019 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1020 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Rooms.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1018, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(cal.Rooms.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name1019, "dataIndex": "name" }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (de)", "editable": true, "tooltip": "(cal.Rooms.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_de1020, "dataIndex": "name_de" } ];
    Lino.cal.Rooms.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Rooms.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Rooms", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Rooms.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Rooms", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Rooms.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Rooms", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.Rooms.insertPanel = Ext.extend(Lino.cal.Rooms.DetailFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/cal/Rooms",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Rooms.detail;
    this.ls_insert_handler = Lino.cal.Rooms.insert;
    Lino.cal.Rooms.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Rooms.insert = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Rooms.insertPanel(p);
});
Lino.cal.Rooms.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Rooms", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Rooms.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Rooms", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Rooms.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Rooms", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.Rooms.detailPanel = Ext.extend(Lino.cal.Rooms.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  ls_url: "/cal/Rooms",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Rooms.detail;
    this.ls_insert_handler = Lino.cal.Rooms.insert;
    Lino.cal.Rooms.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Rooms.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Rooms.detailPanel(p);
});
Lino.cal.Rooms.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Rooms", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Rooms.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Rooms.GridPanel(p);
});
Lino.cal.Rooms.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Rooms", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.Priorities
Lino.cal.Priorities.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/Priorities",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/Priorities','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/Priorities','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Priorit\u00e4ten",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 5,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "type": "int", "name": "id" }, { "name": "ref" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 20,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var name1022 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1023 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1024 = new Ext.form.NumberField({ "selectOnFocus": true });
    var ref1025 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": "1" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(cal.Priorities.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name1022, "dataIndex": "name" }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (de)", "editable": true, "tooltip": "(cal.Priorities.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_de1023, "dataIndex": "name_de" }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Priorities.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1024, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 3, "sortable": true, "header": "ref", "editable": true, "tooltip": "(cal.Priorities.ref) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": ref1025, "hidden": true, "dataIndex": "ref" } ];
    Lino.cal.Priorities.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Priorities.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Priorities", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Priorities.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Priorities", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Priorities.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Priorities", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Priorities.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Priorities", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Priorities.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Priorities", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Priorities.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Priorities", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Priorities.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Priorities.GridPanel(p);
});

// js_render_GridPanel_class cal.Calendars
Lino.cal.Calendars.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/Calendars",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/Calendars','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/Calendars','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Kalenderliste",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 5,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "type": "int", "name": "color" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 24,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Calendars.detail;
    this.ls_insert_handler = Lino.cal.Calendars.insert;
    var ww = this.containing_window;
    var id1027 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1028 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1029 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var color1030 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Calendars.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1027, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(cal.Calendars.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name1028, "dataIndex": "name" }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (de)", "editable": true, "tooltip": "(cal.Calendars.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_de1029, "dataIndex": "name_de" }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Calendars.color) ", "filter": { "type": "numeric" }, "header": "Farbe", "editor": color1030, "width": Lino.chars2width(6), "dataIndex": "color" }) ];
    Lino.cal.Calendars.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Calendars.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Calendars", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Calendars.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Calendars", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Calendars.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Calendars", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.Calendars.insertPanel = Ext.extend(Lino.cal.Calendars.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/cal/Calendars",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Calendars.detail;
    this.ls_insert_handler = Lino.cal.Calendars.insert;
    Lino.cal.Calendars.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Calendars.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Calendars.insertPanel(p);
});
Lino.cal.Calendars.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Calendars", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Calendars.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Calendars", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Calendars.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Calendars", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.Calendars.detailPanel = Ext.extend(Lino.cal.Calendars.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  ls_url: "/cal/Calendars",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Calendars.detail;
    this.ls_insert_handler = Lino.cal.Calendars.insert;
    Lino.cal.Calendars.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Calendars.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Calendars.detailPanel(p);
});
Lino.cal.Calendars.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Calendars", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Calendars.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Calendars.GridPanel(p);
});
Lino.cal.Calendars.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Calendars", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.Subscriptions
Lino.cal.Subscriptions.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/Subscriptions",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/Subscriptions','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/Subscriptions','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Abonnements",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "calendar" }, 'calendarHidden', { "type": "boolean", "name": "is_hidden" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 26,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id1032 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1033 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Subscriptions/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var calendar1034 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Subscriptions/calendar", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    var is_hidden1035 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Subscriptions.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1032, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "tooltip": "(cal.Subscriptions.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "dataIndex": "user", "editor": user1033 }, { "colIndex": 2, "sortable": true, "header": "Kalender", "editable": true, "tooltip": "(cal.Subscriptions.calendar) The calendar you want to subscribe to.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.Calendars.detail'), "dataIndex": "calendar", "editor": calendar1034 }, { "colIndex": 3, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.Subscriptions.is_hidden) Whether this subscription should \"\n        \"initially be displayed as a hidden calendar.", "filter": { "type": "boolean" }, "header": "versteckt", "dataIndex": "is_hidden" } ];
    Lino.cal.Subscriptions.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Subscriptions.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Subscriptions", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Subscriptions.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Subscriptions", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Subscriptions.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Subscriptions", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Subscriptions.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Subscriptions", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Subscriptions.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Subscriptions", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Subscriptions.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Subscriptions", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Subscriptions.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Subscriptions.GridPanel(p);
});

// js_render_GridPanel_class cal.Tasks
Lino.cal.Tasks.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/Tasks",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/Tasks','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/Tasks','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Aufgaben",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 24,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "modified" }, { "name": "created" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "start_time" }, { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "date", "name": "due_date", "dateFormat": "d.m.Y" }, { "name": "due_time" }, { "type": "int", "name": "percent" }, { "name": "state" }, 'stateHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 16,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Tasks.detail;
    this.ls_insert_handler = Lino.cal.Tasks.insert;
    var ww = this.containing_window;
    var start_date1037 = new Lino.DateField({ "selectOnFocus": true });
    var summary1038 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp1039 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id1040 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1041 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var modified1042 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created1043 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var owner_type1044 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Datenbankmodell ausw\u00e4hlen..." });
    var owner_id1045 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/owner_id", "method": "GET" }) }) });
    var start_time1046 = new Lino.TimeField({ "selectOnFocus": true });
    var access_class1047 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var sequence1048 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type1049 = new Ext.form.NumberField({ "disabled": true });
    var due_date1050 = new Lino.DateField({ "selectOnFocus": true });
    var due_time1051 = new Lino.TimeField({ "selectOnFocus": true });
    var percent1052 = new Ext.form.NumberField({ "selectOnFocus": true });
    var state1053 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.TaskStates });
    var owner_disp1054 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.Tasks.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "editor": start_date1037, "width": Lino.chars2width(14), "dataIndex": "start_date" }, { "colIndex": 1, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "tooltip": "(cal.Tasks.summary) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": summary1038, "dataIndex": "summary" }, { "header": "Arbeitsablauf", "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "width": Lino.chars2width(31), "editable": false, "tooltip": "(cal.Tasks.workflow_buttons) " }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Tasks.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1040, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.Tasks.user) ", "filter": { "type": "string" }, "header": "Autor", "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "dataIndex": "user", "hidden": true, "editor": user1041 }, { "colIndex": 5, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.Tasks.modified) ", "header": "Bearbeitet", "dataIndex": "modified", "hidden": true }, { "colIndex": 6, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.Tasks.created) ", "header": "Erstellt", "dataIndex": "created", "hidden": true }, { "colIndex": 7, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.Tasks.owner_type) ", "filter": { "type": "string" }, "header": "Verkn\u00fcpft mit (Modell)", "renderer": Lino.fk_renderer('owner_typeHidden','Lino.contenttypes.ContentTypes.detail'), "dataIndex": "owner_type", "hidden": true, "editor": owner_type1044 }, { "colIndex": 8, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "tooltip": "(cal.Tasks.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": owner_id1045, "hidden": true, "dataIndex": "owner_id" }, { "colIndex": 9, "sortable": true, "header": "Beginnt um", "editable": true, "tooltip": "(cal.Tasks.start_time) ", "width": Lino.chars2width(9), "editor": start_time1046, "hidden": true, "dataIndex": "start_time" }, { "colIndex": 10, "sortable": true, "header": "Zugriffsklasse", "editable": true, "tooltip": "(cal.Tasks.access_class) Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist", "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": access_class1047, "hidden": true, "dataIndex": "access_class" }, new Lino.NullNumberColumn({ "colIndex": 11, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Tasks.sequence) ", "filter": { "type": "numeric" }, "header": "Revisionsnummer", "editor": sequence1048, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "sequence" }), new Lino.NullNumberColumn({ "colIndex": 12, "sortable": true, "format": "0", "editable": false, "tooltip": "(cal.Tasks.auto_type) ", "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 13, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.Tasks.due_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Zahlungsziel", "editor": due_date1050, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "due_date" }, { "colIndex": 14, "sortable": true, "header": "F\u00e4llig um", "editable": true, "tooltip": "(cal.Tasks.due_time) ", "width": Lino.chars2width(9), "editor": due_time1051, "hidden": true, "dataIndex": "due_time" }, new Lino.NullNumberColumn({ "colIndex": 15, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Tasks.percent) ", "filter": { "type": "numeric" }, "header": "Dauer (Anzahl)", "editor": percent1052, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "percent" }), { "colIndex": 16, "sortable": true, "header": "Zustand", "editable": true, "tooltip": "(cal.Tasks.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": state1053, "hidden": true, "dataIndex": "state" }, { "colIndex": 17, "sortable": false, "width": Lino.chars2width(11), "editable": false, "tooltip": "(cal.Tasks.owner) ", "header": "Verkn\u00fcpft mit", "dataIndex": "owner", "hidden": true } ];
    Lino.cal.Tasks.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Tasks.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Tasks", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Tasks.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Tasks", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Tasks.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Tasks", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.Tasks.insertPanel = Ext.extend(Lino.cal.Tasks.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  params_panel_hidden: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/cal/Tasks",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Tasks.detail;
    this.ls_insert_handler = Lino.cal.Tasks.insert;
    Lino.cal.Tasks.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Tasks.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Tasks.insertPanel(p);
});
Lino.cal.Tasks.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Tasks", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Tasks.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Tasks", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Tasks.wf1 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Tasks", "GET", pk, "wf1", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Tasks.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Tasks", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Tasks.wf2 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Tasks", "GET", pk, "wf2", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Tasks.wf3 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Tasks", "GET", pk, "wf3", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.Tasks.detailPanel = Ext.extend(Lino.cal.Tasks.DetailFormPanel,{
  empty_title: "Detail",
  params_panel_hidden: true,
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  ls_url: "/cal/Tasks",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Tasks.detail;
    this.ls_insert_handler = Lino.cal.Tasks.insert;
    Lino.cal.Tasks.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Tasks.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Tasks.detailPanel(p);
});
Lino.cal.Tasks.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Tasks", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Tasks.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Tasks.ParamsPanel({});
  return new Lino.cal.Tasks.GridPanel(p);
});
Lino.cal.Tasks.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Tasks", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.MyTasks
Lino.cal.MyTasks.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/MyTasks",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/MyTasks','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/MyTasks','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Meine Aufgaben",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 5,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 16,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyTasks.detail;
    this.ls_insert_handler = Lino.cal.MyTasks.insert;
    var ww = this.containing_window;
    var start_date1056 = new Lino.DateField({ "selectOnFocus": true });
    var summary1057 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp1058 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.MyTasks.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "editor": start_date1056, "width": Lino.chars2width(14), "dataIndex": "start_date" }, { "colIndex": 1, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "tooltip": "(cal.MyTasks.summary) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": summary1057, "dataIndex": "summary" }, { "header": "Arbeitsablauf", "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "width": Lino.chars2width(31), "editable": false, "tooltip": "(cal.MyTasks.workflow_buttons) " } ];
    Lino.cal.MyTasks.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyTasks.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyTasks.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyTasks.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.MyTasks.insertPanel = Ext.extend(Lino.cal.Tasks.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  params_panel_hidden: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/cal/MyTasks",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyTasks.detail;
    this.ls_insert_handler = Lino.cal.MyTasks.insert;
    Lino.cal.MyTasks.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyTasks.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyTasks.insertPanel(p);
});
Lino.cal.MyTasks.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyTasks.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyTasks.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyTasks.wf1 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "wf1", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyTasks.wf2 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "wf2", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyTasks.wf3 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "wf3", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.MyTasks.detailPanel = Ext.extend(Lino.cal.Tasks.DetailFormPanel,{
  empty_title: "Detail",
  params_panel_hidden: true,
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  ls_url: "/cal/MyTasks",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyTasks.detail;
    this.ls_insert_handler = Lino.cal.MyTasks.insert;
    Lino.cal.MyTasks.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyTasks.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyTasks.detailPanel(p);
});
Lino.cal.MyTasks.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyTasks.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Tasks.ParamsPanel({});
  return new Lino.cal.MyTasks.GridPanel(p);
});
Lino.cal.MyTasks.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyTasks", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.GuestRoles
Lino.cal.GuestRoles.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/GuestRoles",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/GuestRoles','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/GuestRoles','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Gastrollen",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 4,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 23,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.GuestRoles.detail;
    this.ls_insert_handler = Lino.cal.GuestRoles.insert;
    var ww = this.containing_window;
    var id1060 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1061 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1062 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.GuestRoles.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1060, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(cal.GuestRoles.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name1061, "dataIndex": "name" }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung (de)", "editable": true, "tooltip": "(cal.GuestRoles.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_de1062, "dataIndex": "name_de" } ];
    Lino.cal.GuestRoles.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.GuestRoles.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestRoles", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.GuestRoles.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestRoles", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.GuestRoles.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestRoles", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.GuestRoles.insertPanel = Ext.extend(Lino.cal.GuestRoles.DetailFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/cal/GuestRoles",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.GuestRoles.detail;
    this.ls_insert_handler = Lino.cal.GuestRoles.insert;
    Lino.cal.GuestRoles.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.GuestRoles.insert = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.GuestRoles.insertPanel(p);
});
Lino.cal.GuestRoles.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestRoles", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.GuestRoles.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestRoles", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.GuestRoles.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestRoles", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.GuestRoles.detailPanel = Ext.extend(Lino.cal.GuestRoles.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  ls_url: "/cal/GuestRoles",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.GuestRoles.detail;
    this.ls_insert_handler = Lino.cal.GuestRoles.insert;
    Lino.cal.GuestRoles.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.GuestRoles.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.GuestRoles.detailPanel(p);
});
Lino.cal.GuestRoles.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestRoles", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.GuestRoles.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.GuestRoles.GridPanel(p);
});
Lino.cal.GuestRoles.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestRoles", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.Guests
Lino.cal.Guests.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/Guests",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/Guests','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/Guests','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Teilnehmer",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 12,
  ls_store_fields : [ { "name": "partner" }, 'partnerHidden', { "name": "role" }, 'roleHidden', { "name": "workflow_buttons" }, { "name": "remark" }, { "name": "event" }, 'eventHidden', { "type": "int", "name": "id" }, { "name": "state" }, 'stateHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 8,
  ls_grid_configs : [  ],
  content_type : 21,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Guests.detail;
    this.ls_insert_handler = Lino.cal.Guests.insert;
    var ww = this.containing_window;
    var partner1064 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }), "emptyText": "Partner ausw\u00e4hlen..." });
    var role1065 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Gastrolle ausw\u00e4hlen..." });
    var workflow_buttons_disp1066 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var remark1067 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var event1068 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/event", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Termin ausw\u00e4hlen..." });
    var id1069 = new Ext.form.NumberField({ "selectOnFocus": true });
    var state1070 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.GuestStates });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(cal.Guests.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "dataIndex": "partner", "editor": partner1064 }, { "colIndex": 1, "sortable": true, "header": "Rolle", "editable": true, "tooltip": "(cal.Guests.role) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('roleHidden','Lino.cal.GuestRoles.detail'), "dataIndex": "role", "editor": role1065 }, { "header": "Arbeitsablauf", "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "width": Lino.chars2width(31), "editable": false, "tooltip": "(cal.Guests.workflow_buttons) " }, { "colIndex": 3, "sortable": true, "header": "Bemerkung", "editable": true, "tooltip": "(cal.Guests.remark) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": remark1067, "dataIndex": "remark" }, { "colIndex": 4, "sortable": true, "header": "Termin", "editable": true, "tooltip": "(cal.Guests.event) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('eventHidden','Lino.cal.OneEvent.detail'), "dataIndex": "event", "editor": event1068 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Guests.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1069, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Zustand", "editable": true, "tooltip": "(cal.Guests.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": state1070, "hidden": true, "dataIndex": "state" } ];
    Lino.cal.Guests.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Guests.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Guests", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Guests.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Guests", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Guests.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Guests", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.Guests.insertPanel = Ext.extend(Lino.cal.Guests.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/cal/Guests",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Guests.detail;
    this.ls_insert_handler = Lino.cal.Guests.insert;
    Lino.cal.Guests.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Guests.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Guests.insertPanel(p);
});
Lino.cal.Guests.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Guests", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Guests.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Guests", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Guests.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Guests", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.Guests.detailPanel = Ext.extend(Lino.cal.Guests.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  ls_url: "/cal/Guests",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Guests.detail;
    this.ls_insert_handler = Lino.cal.Guests.insert;
    Lino.cal.Guests.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Guests.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Guests.detailPanel(p);
});
Lino.cal.Guests.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Guests", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Guests.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Guests.ParamsPanel({});
  return new Lino.cal.Guests.GridPanel(p);
});
Lino.cal.Guests.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Guests", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.MyPresences
Lino.cal.MyPresences.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/MyPresences",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/MyPresences','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/MyPresences','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Meine Anwesenheiten",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 15,
  ls_store_fields : [ { "type": "date", "name": "event__start_date", "dateFormat": "d.m.Y" }, { "name": "event__start_time" }, { "name": "event_summary" }, { "name": "role" }, 'roleHidden', { "name": "workflow_buttons" }, { "name": "remark" }, { "type": "int", "name": "id" }, { "name": "event" }, 'eventHidden', { "name": "partner" }, 'partnerHidden', { "name": "state" }, 'stateHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 21,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyPresences.detail;
    this.ls_insert_handler = Lino.cal.MyPresences.insert;
    var ww = this.containing_window;
    var event__start_date1072 = new Lino.DateField({ "disabled": true });
    var event__start_time1073 = new Lino.TimeField({ "disabled": true });
    var event_summary_disp1074 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var role1075 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyPresences/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Gastrolle ausw\u00e4hlen..." });
    var workflow_buttons_disp1076 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var remark1077 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1078 = new Ext.form.NumberField({ "selectOnFocus": true });
    var event1079 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyPresences/event", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Termin ausw\u00e4hlen..." });
    var partner1080 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyPresences/partner", "method": "GET" }) }), "emptyText": "Partner ausw\u00e4hlen..." });
    var state1081 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.GuestStates });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": false, "tooltip": "(cal.MyPresences.event__start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "dataIndex": "event__start_date", "width": Lino.chars2width(14) }, { "header": "Beginnt um", "colIndex": 1, "sortable": true, "dataIndex": "event__start_time", "width": Lino.chars2width(9), "editable": false, "tooltip": "(cal.MyPresences.event__start_time) " }, { "header": "Termin", "colIndex": 2, "sortable": false, "dataIndex": "event_summary", "width": Lino.chars2width(31), "editable": false, "tooltip": "(cal.MyPresences.event_summary) " }, { "colIndex": 3, "sortable": true, "header": "Rolle", "editable": true, "tooltip": "(cal.MyPresences.role) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('roleHidden','Lino.cal.GuestRoles.detail'), "dataIndex": "role", "editor": role1075 }, { "header": "Arbeitsablauf", "colIndex": 4, "sortable": false, "dataIndex": "workflow_buttons", "width": Lino.chars2width(31), "editable": false, "tooltip": "(cal.MyPresences.workflow_buttons) " }, { "colIndex": 5, "sortable": true, "header": "Bemerkung", "editable": true, "tooltip": "(cal.MyPresences.remark) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": remark1077, "dataIndex": "remark" }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.MyPresences.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1078, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 7, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.MyPresences.event) ", "filter": { "type": "string" }, "header": "Termin", "renderer": Lino.fk_renderer('eventHidden','Lino.cal.OneEvent.detail'), "dataIndex": "event", "hidden": true, "editor": event1079 }, { "colIndex": 8, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.MyPresences.partner) ", "filter": { "type": "string" }, "header": "Partner", "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "dataIndex": "partner", "hidden": true, "editor": partner1080 }, { "colIndex": 9, "sortable": true, "header": "Zustand", "editable": true, "tooltip": "(cal.MyPresences.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": state1081, "hidden": true, "dataIndex": "state" } ];
    Lino.cal.MyPresences.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyPresences.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPresences.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPresences.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.MyPresences.insertPanel = Ext.extend(Lino.cal.Guests.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  params_panel_hidden: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/cal/MyPresences",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyPresences.detail;
    this.ls_insert_handler = Lino.cal.MyPresences.insert;
    Lino.cal.MyPresences.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyPresences.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyPresences.insertPanel(p);
});
Lino.cal.MyPresences.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPresences.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPresences.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.MyPresences.detailPanel = Ext.extend(Lino.cal.Guests.DetailFormPanel,{
  empty_title: "Detail",
  params_panel_hidden: true,
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  ls_url: "/cal/MyPresences",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyPresences.detail;
    this.ls_insert_handler = Lino.cal.MyPresences.insert;
    Lino.cal.MyPresences.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyPresences.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyPresences.detailPanel(p);
});
Lino.cal.MyPresences.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPresences.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Guests.ParamsPanel({});
  return new Lino.cal.MyPresences.GridPanel(p);
});
Lino.cal.MyPresences.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPresences", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.MyPendingPresences
Lino.cal.MyPendingPresences.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/MyPendingPresences",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/MyPendingPresences','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/MyPendingPresences','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "My pending invitations",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "name": "event__when_text" }, { "name": "role" }, 'roleHidden', { "name": "workflow_buttons" }, { "name": "remark" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 21,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyPendingPresences.detail;
    this.ls_insert_handler = Lino.cal.MyPendingPresences.insert;
    var ww = this.containing_window;
    var event__when_text_disp1083 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var role1084 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyPendingPresences/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Gastrolle ausw\u00e4hlen..." });
    var workflow_buttons_disp1085 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var remark1086 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "header": "Wann", "colIndex": 0, "sortable": false, "dataIndex": "event__when_text", "width": Lino.chars2width(31), "editable": false, "tooltip": "(cal.MyPendingPresences.event__when_text) " }, { "colIndex": 1, "sortable": true, "header": "Rolle", "editable": true, "tooltip": "(cal.MyPendingPresences.role) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('roleHidden','Lino.cal.GuestRoles.detail'), "dataIndex": "role", "editor": role1084 }, { "header": "Arbeitsablauf", "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "width": Lino.chars2width(31), "editable": false, "tooltip": "(cal.MyPendingPresences.workflow_buttons) " }, { "colIndex": 3, "sortable": true, "header": "Bemerkung", "editable": true, "tooltip": "(cal.MyPendingPresences.remark) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": remark1086, "dataIndex": "remark" } ];
    Lino.cal.MyPendingPresences.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyPendingPresences.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPendingPresences.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPendingPresences.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.MyPendingPresences.insertPanel = Ext.extend(Lino.cal.Guests.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  params_panel_hidden: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/cal/MyPendingPresences",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyPendingPresences.detail;
    this.ls_insert_handler = Lino.cal.MyPendingPresences.insert;
    Lino.cal.MyPendingPresences.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyPendingPresences.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyPendingPresences.insertPanel(p);
});
Lino.cal.MyPendingPresences.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPendingPresences.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPendingPresences.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.MyPendingPresences.detailPanel = Ext.extend(Lino.cal.Guests.DetailFormPanel,{
  empty_title: "Detail",
  params_panel_hidden: true,
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  ls_url: "/cal/MyPendingPresences",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyPendingPresences.detail;
    this.ls_insert_handler = Lino.cal.MyPendingPresences.insert;
    Lino.cal.MyPendingPresences.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyPendingPresences.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyPendingPresences.detailPanel(p);
});
Lino.cal.MyPendingPresences.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyPendingPresences.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Guests.ParamsPanel({});
  return new Lino.cal.MyPendingPresences.GridPanel(p);
});
Lino.cal.MyPendingPresences.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyPendingPresences", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.MyGuests
Lino.cal.MyGuests.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/MyGuests",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/MyGuests','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/MyGuests','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Meine G\u00e4ste",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 15,
  ls_store_fields : [ { "type": "date", "name": "event__start_date", "dateFormat": "d.m.Y" }, { "name": "event__start_time" }, { "name": "event_summary" }, { "name": "role" }, 'roleHidden', { "name": "workflow_buttons" }, { "name": "remark" }, { "type": "int", "name": "id" }, { "name": "event" }, 'eventHidden', { "name": "partner" }, 'partnerHidden', { "name": "state" }, 'stateHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 21,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyGuests.detail;
    this.ls_insert_handler = Lino.cal.MyGuests.insert;
    var ww = this.containing_window;
    var event__start_date1088 = new Lino.DateField({ "disabled": true });
    var event__start_time1089 = new Lino.TimeField({ "disabled": true });
    var event_summary_disp1090 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var role1091 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyGuests/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Gastrolle ausw\u00e4hlen..." });
    var workflow_buttons_disp1092 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var remark1093 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1094 = new Ext.form.NumberField({ "selectOnFocus": true });
    var event1095 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyGuests/event", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Termin ausw\u00e4hlen..." });
    var partner1096 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyGuests/partner", "method": "GET" }) }), "emptyText": "Partner ausw\u00e4hlen..." });
    var state1097 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.GuestStates });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": false, "tooltip": "(cal.MyGuests.event__start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "dataIndex": "event__start_date", "width": Lino.chars2width(14) }, { "header": "Beginnt um", "colIndex": 1, "sortable": true, "dataIndex": "event__start_time", "width": Lino.chars2width(9), "editable": false, "tooltip": "(cal.MyGuests.event__start_time) " }, { "header": "Termin", "colIndex": 2, "sortable": false, "dataIndex": "event_summary", "width": Lino.chars2width(31), "editable": false, "tooltip": "(cal.MyGuests.event_summary) " }, { "colIndex": 3, "sortable": true, "header": "Rolle", "editable": true, "tooltip": "(cal.MyGuests.role) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('roleHidden','Lino.cal.GuestRoles.detail'), "dataIndex": "role", "editor": role1091 }, { "header": "Arbeitsablauf", "colIndex": 4, "sortable": false, "dataIndex": "workflow_buttons", "width": Lino.chars2width(31), "editable": false, "tooltip": "(cal.MyGuests.workflow_buttons) " }, { "colIndex": 5, "sortable": true, "header": "Bemerkung", "editable": true, "tooltip": "(cal.MyGuests.remark) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": remark1093, "dataIndex": "remark" }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.MyGuests.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1094, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 7, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.MyGuests.event) ", "filter": { "type": "string" }, "header": "Termin", "renderer": Lino.fk_renderer('eventHidden','Lino.cal.OneEvent.detail'), "dataIndex": "event", "hidden": true, "editor": event1095 }, { "colIndex": 8, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.MyGuests.partner) ", "filter": { "type": "string" }, "header": "Partner", "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "dataIndex": "partner", "hidden": true, "editor": partner1096 }, { "colIndex": 9, "sortable": true, "header": "Zustand", "editable": true, "tooltip": "(cal.MyGuests.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": state1097, "hidden": true, "dataIndex": "state" } ];
    Lino.cal.MyGuests.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyGuests.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyGuests.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyGuests.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.MyGuests.insertPanel = Ext.extend(Lino.cal.Guests.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/cal/MyGuests",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyGuests.detail;
    this.ls_insert_handler = Lino.cal.MyGuests.insert;
    Lino.cal.MyGuests.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyGuests.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyGuests.insertPanel(p);
});
Lino.cal.MyGuests.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyGuests.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyGuests.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.MyGuests.detailPanel = Ext.extend(Lino.cal.Guests.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  ls_url: "/cal/MyGuests",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyGuests.detail;
    this.ls_insert_handler = Lino.cal.MyGuests.insert;
    Lino.cal.MyGuests.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyGuests.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyGuests.detailPanel(p);
});
Lino.cal.MyGuests.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyGuests.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Guests.ParamsPanel({});
  return new Lino.cal.MyGuests.GridPanel(p);
});
Lino.cal.MyGuests.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyGuests", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.EventTypes
Lino.cal.EventTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/EventTypes",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/EventTypes','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/EventTypes','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Rauf", "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-arrow_up", "overflowText": "Rauf", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Runter", "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-arrow_down", "overflowText": "Runter", "auto_save": true } ],
  cell_edit : true,
  title : "Ereignisarten",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 12,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "type": "int", "name": "id" }, { "type": "int", "name": "seqno" }, { "type": "boolean", "name": "is_appointment" }, { "type": "boolean", "name": "all_rooms" }, { "type": "boolean", "name": "locks_user" }, { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "event_label" }, { "name": "event_label_de" }, { "type": "int", "name": "max_conflicting" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 19,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventTypes.detail;
    this.ls_insert_handler = Lino.cal.EventTypes.insert;
    var ww = this.containing_window;
    var name1099 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1100 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1101 = new Ext.form.NumberField({ "selectOnFocus": true });
    var seqno1102 = new Ext.form.NumberField({ "selectOnFocus": true });
    var is_appointment1103 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": true });
    var all_rooms1104 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var locks_user1105 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var start_date1106 = new Lino.DateField({ "selectOnFocus": true });
    var event_label1107 = new Ext.form.TextField({ "selectOnFocus": true, "value": "Termin", "maxLength": 200 });
    var event_label_de1108 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var max_conflicting1109 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 1 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(cal.EventTypes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name1099, "dataIndex": "name" }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (de)", "editable": true, "tooltip": "(cal.EventTypes.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_de1100, "dataIndex": "name_de" }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.EventTypes.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1101, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.EventTypes.seqno) ", "filter": { "type": "numeric" }, "header": "Seq.-Nr.", "editor": seqno1102, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "seqno" }), { "colIndex": 4, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.EventTypes.is_appointment) ", "filter": { "type": "boolean" }, "header": "Event is an appointment", "dataIndex": "is_appointment", "hidden": true }, { "colIndex": 5, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.EventTypes.all_rooms) ", "filter": { "type": "boolean" }, "header": "Locks all rooms", "dataIndex": "all_rooms", "hidden": true }, { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.EventTypes.locks_user) Whether events of this type make the user unavailable for other locking events at the same time.", "filter": { "type": "boolean" }, "header": "Locks the user", "dataIndex": "locks_user", "hidden": true }, { "colIndex": 7, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.EventTypes.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "editor": start_date1106, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "start_date" }, { "colIndex": 8, "sortable": true, "header": "Bezeichnung Termin", "editable": true, "tooltip": "(cal.EventTypes.event_label) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": event_label1107, "hidden": true, "dataIndex": "event_label" }, { "colIndex": 9, "sortable": true, "header": "Bezeichnung Termin (de)", "editable": true, "tooltip": "(cal.EventTypes.event_label_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": event_label_de1108, "hidden": true, "dataIndex": "event_label_de" }, new Lino.NullNumberColumn({ "colIndex": 10, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.EventTypes.max_conflicting) How many conflicting events should be tolerated.", "filter": { "type": "numeric" }, "header": "Simultaneous events", "editor": max_conflicting1109, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "max_conflicting" }) ];
    Lino.cal.EventTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventTypes.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventTypes", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventTypes.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventTypes", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventTypes.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventTypes", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.EventTypes.insertPanel = Ext.extend(Lino.cal.EventTypes.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/cal/EventTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventTypes.detail;
    this.ls_insert_handler = Lino.cal.EventTypes.insert;
    Lino.cal.EventTypes.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventTypes.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.EventTypes.insertPanel(p);
});
Lino.cal.EventTypes.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventTypes", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventTypes.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventTypes", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventTypes.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventTypes", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventTypes.duplicate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventTypes", "GET", pk, "duplicate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.EventTypes.detailPanel = Ext.extend(Lino.cal.EventTypes.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Rauf", "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-arrow_up", "overflowText": "Rauf", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Runter", "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-arrow_down", "overflowText": "Runter", "auto_save": true } ],
  ls_url: "/cal/EventTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventTypes.detail;
    this.ls_insert_handler = Lino.cal.EventTypes.insert;
    Lino.cal.EventTypes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventTypes.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.EventTypes.detailPanel(p);
});
Lino.cal.EventTypes.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventTypes", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventTypes.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.EventTypes.GridPanel(p);
});
Lino.cal.EventTypes.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventTypes", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventTypes.move_up = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventTypes", "GET", pk, "move_up", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventTypes.move_down = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventTypes", "GET", pk, "move_down", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.RecurrentEvents
Lino.cal.RecurrentEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/RecurrentEvents",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/RecurrentEvents','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/RecurrentEvents','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_update_events", "menu_item_text": "Termine aktualisieren", "tooltip": "Termine aktualisieren", "panel_btn_handler": Lino.row_action_handler('do_update_events','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Termine aktualisieren", "auto_save": true } ],
  cell_edit : true,
  title : "Periodische Termine",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 23,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "name" }, { "name": "name_de" }, { "name": "every_unit" }, 'every_unitHidden', { "name": "event_type" }, 'event_typeHidden', { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "start_time" }, { "name": "end_time" }, { "type": "int", "name": "every" }, { "type": "boolean", "name": "monday" }, { "type": "boolean", "name": "tuesday" }, { "type": "boolean", "name": "wednesday" }, { "type": "boolean", "name": "thursday" }, { "type": "boolean", "name": "friday" }, { "type": "boolean", "name": "saturday" }, { "type": "boolean", "name": "sunday" }, { "type": "int", "name": "max_events" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 8,
  ls_grid_configs : [  ],
  content_type : 18,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.RecurrentEvents.detail;
    this.ls_insert_handler = Lino.cal.RecurrentEvents.insert;
    var ww = this.containing_window;
    var start_date1111 = new Lino.DateField({ "selectOnFocus": true });
    var end_date1112 = new Lino.DateField({ "selectOnFocus": true });
    var name1113 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1114 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var every_unit1115 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.Recurrencies });
    var event_type1116 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/RecurrentEvents/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ereignisart ausw\u00e4hlen..." });
    var id1117 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1118 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/RecurrentEvents/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var start_time1119 = new Lino.TimeField({ "selectOnFocus": true });
    var end_time1120 = new Lino.TimeField({ "selectOnFocus": true });
    var every1121 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var monday1122 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var tuesday1123 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var wednesday1124 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var thursday1125 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var friday1126 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var saturday1127 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var sunday1128 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var max_events1129 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.RecurrentEvents.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "editor": start_date1111, "width": Lino.chars2width(14), "dataIndex": "start_date" }, { "colIndex": 1, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.RecurrentEvents.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Endet am", "editor": end_date1112, "width": Lino.chars2width(14), "dataIndex": "end_date" }, { "colIndex": 2, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(cal.RecurrentEvents.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name1113, "dataIndex": "name" }, { "colIndex": 3, "sortable": true, "header": "Bezeichnung (de)", "editable": true, "tooltip": "(cal.RecurrentEvents.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_de1114, "dataIndex": "name_de" }, { "colIndex": 4, "sortable": true, "header": "Wiederholung", "editable": true, "tooltip": "(cal.RecurrentEvents.every_unit) ", "filter": { "type": "string" }, "width": Lino.chars2width(15), "editor": every_unit1115, "dataIndex": "every_unit" }, { "colIndex": 5, "sortable": true, "header": "Ereignisart", "editable": true, "tooltip": "(cal.RecurrentEvents.event_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('event_typeHidden','Lino.cal.EventTypes.detail'), "dataIndex": "event_type", "editor": event_type1116 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.RecurrentEvents.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1117, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 7, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.RecurrentEvents.user) ", "filter": { "type": "string" }, "header": "Autor", "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "dataIndex": "user", "hidden": true, "editor": user1118 }, { "colIndex": 8, "sortable": true, "header": "Beginnt um", "editable": true, "tooltip": "(cal.RecurrentEvents.start_time) ", "width": Lino.chars2width(9), "editor": start_time1119, "hidden": true, "dataIndex": "start_time" }, { "colIndex": 9, "sortable": true, "header": "Endet um", "editable": true, "tooltip": "(cal.RecurrentEvents.end_time) ", "width": Lino.chars2width(9), "editor": end_time1120, "hidden": true, "dataIndex": "end_time" }, new Lino.NullNumberColumn({ "colIndex": 10, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.RecurrentEvents.every) ", "filter": { "type": "numeric" }, "header": "... alle", "editor": every1121, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "every" }), { "colIndex": 11, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.RecurrentEvents.monday) ", "filter": { "type": "boolean" }, "header": "Montag", "dataIndex": "monday", "hidden": true }, { "colIndex": 12, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.RecurrentEvents.tuesday) ", "filter": { "type": "boolean" }, "header": "Dienstag", "dataIndex": "tuesday", "hidden": true }, { "colIndex": 13, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.RecurrentEvents.wednesday) ", "filter": { "type": "boolean" }, "header": "Mittwoch", "dataIndex": "wednesday", "hidden": true }, { "colIndex": 14, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.RecurrentEvents.thursday) ", "filter": { "type": "boolean" }, "header": "Donnerstag", "dataIndex": "thursday", "hidden": true }, { "colIndex": 15, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.RecurrentEvents.friday) ", "filter": { "type": "boolean" }, "header": "Freitag", "dataIndex": "friday", "hidden": true }, { "colIndex": 16, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.RecurrentEvents.saturday) ", "filter": { "type": "boolean" }, "header": "Samstag", "dataIndex": "saturday", "hidden": true }, { "colIndex": 17, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.RecurrentEvents.sunday) ", "filter": { "type": "boolean" }, "header": "Sonntag", "dataIndex": "sunday", "hidden": true }, new Lino.NullNumberColumn({ "colIndex": 18, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.RecurrentEvents.max_events) ", "filter": { "type": "numeric" }, "header": "Anzahl Termine", "editor": max_events1129, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "max_events" }) ];
    Lino.cal.RecurrentEvents.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.RecurrentEvents.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RecurrentEvents", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.RecurrentEvents.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RecurrentEvents", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.RecurrentEvents.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RecurrentEvents", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.RecurrentEvents.insertPanel = Ext.extend(Lino.cal.RecurrentEvents.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/cal/RecurrentEvents",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.RecurrentEvents.detail;
    this.ls_insert_handler = Lino.cal.RecurrentEvents.insert;
    Lino.cal.RecurrentEvents.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.RecurrentEvents.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(80), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.RecurrentEvents.insertPanel(p);
});
Lino.cal.RecurrentEvents.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RecurrentEvents", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.RecurrentEvents.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RecurrentEvents", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.RecurrentEvents.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RecurrentEvents", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.RecurrentEvents.detailPanel = Ext.extend(Lino.cal.RecurrentEvents.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_update_events", "menu_item_text": "Termine aktualisieren", "tooltip": "Termine aktualisieren", "panel_btn_handler": Lino.row_action_handler('do_update_events','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Termine aktualisieren", "auto_save": true } ],
  ls_url: "/cal/RecurrentEvents",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.RecurrentEvents.detail;
    this.ls_insert_handler = Lino.cal.RecurrentEvents.insert;
    Lino.cal.RecurrentEvents.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.RecurrentEvents.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.RecurrentEvents.detailPanel(p);
});
Lino.cal.RecurrentEvents.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RecurrentEvents", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.RecurrentEvents.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.RecurrentEvents.GridPanel(p);
});
Lino.cal.RecurrentEvents.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RecurrentEvents", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.RecurrentEvents.do_update_events = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/RecurrentEvents", "GET", pk, "do_update_events", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.Events
Lino.cal.Events.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/Events",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/Events','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/Events','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Vorlage bearbeiten", "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Vorlage bearbeiten", "overflowText": "Vorlage bearbeiten", "auto_save": true }, { "itemId": "show_today", "menu_item_text": "Heute", "tooltip": "Show all calendar events of the same day.", "panel_btn_handler": Lino.row_action_handler('show_today','GET',null), "iconCls": "x-tbar-calendar", "overflowText": "Heute", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET',null), "iconCls": "x-tbar-script_add", "overflowText": "per Post", "auto_save": true }, { "itemId": "do_update_guests", "menu_item_text": "Update Guests", "tooltip": "Update Guests", "panel_btn_handler": Lino.row_action_handler('do_update_guests','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Guests", "auto_save": true }, { "itemId": "take", "menu_item_text": "Annehmen", "tooltip": "Verantwortung f\u00fcr diesen Termin \u00fcbernehmen.", "panel_btn_handler": Lino.row_action_handler('take','GET',null), "iconCls": "x-tbar-flag_green", "overflowText": "Annehmen", "auto_save": true }, { "itemId": "move_next", "menu_item_text": "Nach unten", "tooltip": "Nach unten", "panel_btn_handler": Lino.row_action_handler('move_next','GET',null), "iconCls": "x-tbar-date_next", "overflowText": "Nach unten", "auto_save": true } ],
  cell_edit : true,
  title : "Termine",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 35,
  ls_store_fields : [ { "name": "when_text" }, { "name": "user" }, 'userHidden', { "name": "summary" }, { "name": "event_type" }, 'event_typeHidden', { "type": "int", "name": "id" }, { "name": "modified" }, { "name": "created" }, { "name": "build_time" }, { "name": "build_method" }, 'build_methodHidden', { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "room" }, 'roomHidden', { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 25,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Events.detail;
    this.ls_insert_handler = Lino.cal.Events.insert;
    var ww = this.containing_window;
    var when_text_disp1131 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var user1132 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var summary1133 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var event_type1134 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ereignisart ausw\u00e4hlen..." });
    var id1135 = new Ext.form.NumberField({ "selectOnFocus": true });
    var modified1136 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created1137 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_time1138 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_method1139 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.lino.BuildMethods });
    var owner_type1140 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Datenbankmodell ausw\u00e4hlen..." });
    var owner_id1141 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/owner_id", "method": "GET" }) }) });
    var start_date1142 = new Lino.DateField({ "selectOnFocus": true });
    var start_time1143 = new Lino.TimeField({ "selectOnFocus": true });
    var end_date1144 = new Lino.DateField({ "selectOnFocus": true });
    var end_time1145 = new Lino.TimeField({ "selectOnFocus": true });
    var access_class1146 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var sequence1147 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type1148 = new Ext.form.NumberField({ "disabled": true });
    var transparent1149 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var room1150 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/room", "method": "GET" }) }), "pageSize": 20, "emptyText": "Raum ausw\u00e4hlen..." });
    var priority1151 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Priorit\u00e4t ausw\u00e4hlen..." });
    var state1152 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var assigned_to1153 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var owner_disp1154 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "header": "Wann", "colIndex": 0, "sortable": false, "dataIndex": "when_text", "width": Lino.chars2width(21), "editable": false, "tooltip": "(cal.Events.when_text) " }, { "colIndex": 1, "sortable": true, "header": "Verantwortlicher", "editable": true, "tooltip": "(cal.Events.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "dataIndex": "user", "editor": user1132 }, { "colIndex": 2, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "tooltip": "(cal.Events.summary) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": summary1133, "dataIndex": "summary" }, { "colIndex": 3, "sortable": true, "header": "Ereignisart", "editable": true, "tooltip": "(cal.Events.event_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('event_typeHidden','Lino.cal.EventTypes.detail'), "dataIndex": "event_type", "editor": event_type1134 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Events.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1135, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.Events.modified) ", "header": "Bearbeitet", "dataIndex": "modified", "hidden": true }, { "colIndex": 6, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.Events.created) ", "header": "Erstellt", "dataIndex": "created", "hidden": true }, { "colIndex": 7, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.Events.build_time) ", "header": "Druckdatum", "dataIndex": "build_time", "hidden": true }, { "colIndex": 8, "sortable": true, "header": "Konstruktionsmethode", "editable": true, "tooltip": "(cal.Events.build_method) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": build_method1139, "hidden": true, "dataIndex": "build_method" }, { "colIndex": 9, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.Events.owner_type) ", "filter": { "type": "string" }, "header": "Verkn\u00fcpft mit (Modell)", "renderer": Lino.fk_renderer('owner_typeHidden','Lino.contenttypes.ContentTypes.detail'), "dataIndex": "owner_type", "hidden": true, "editor": owner_type1140 }, { "colIndex": 10, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "tooltip": "(cal.Events.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": owner_id1141, "hidden": true, "dataIndex": "owner_id" }, { "colIndex": 11, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.Events.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "editor": start_date1142, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "start_date" }, { "colIndex": 12, "sortable": true, "header": "Beginnt um", "editable": true, "tooltip": "(cal.Events.start_time) ", "width": Lino.chars2width(9), "editor": start_time1143, "hidden": true, "dataIndex": "start_time" }, { "colIndex": 13, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.Events.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Endet am", "editor": end_date1144, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "end_date" }, { "colIndex": 14, "sortable": true, "header": "Endet um", "editable": true, "tooltip": "(cal.Events.end_time) ", "width": Lino.chars2width(9), "editor": end_time1145, "hidden": true, "dataIndex": "end_time" }, { "colIndex": 15, "sortable": true, "header": "Zugriffsklasse", "editable": true, "tooltip": "(cal.Events.access_class) Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist", "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": access_class1146, "hidden": true, "dataIndex": "access_class" }, new Lino.NullNumberColumn({ "colIndex": 16, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.Events.sequence) ", "filter": { "type": "numeric" }, "header": "Revisionsnummer", "editor": sequence1147, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "sequence" }), new Lino.NullNumberColumn({ "colIndex": 17, "sortable": true, "format": "0", "editable": false, "tooltip": "(cal.Events.auto_type) ", "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 18, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.Events.transparent) Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.", "filter": { "type": "boolean" }, "header": "nicht blockierend", "dataIndex": "transparent", "hidden": true }, { "colIndex": 19, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.Events.room) ", "filter": { "type": "string" }, "header": "Raum", "renderer": Lino.fk_renderer('roomHidden','Lino.cal.Rooms.detail'), "dataIndex": "room", "hidden": true, "editor": room1150 }, { "colIndex": 20, "sortable": true, "header": "Priorit\u00e4t", "editable": true, "tooltip": "(cal.Events.priority) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": priority1151, "hidden": true, "dataIndex": "priority" }, { "colIndex": 21, "sortable": true, "header": "Zustand", "editable": true, "tooltip": "(cal.Events.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(14), "editor": state1152, "hidden": true, "dataIndex": "state" }, { "colIndex": 22, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.Events.assigned_to) ", "filter": { "type": "string" }, "header": "Zugewiesen zu", "renderer": Lino.fk_renderer('assigned_toHidden','Lino.users.Users.detail'), "dataIndex": "assigned_to", "hidden": true, "editor": assigned_to1153 }, { "colIndex": 23, "sortable": false, "width": Lino.chars2width(11), "editable": false, "tooltip": "(cal.Events.owner) ", "header": "Verkn\u00fcpft mit", "dataIndex": "owner", "hidden": true } ];
    Lino.cal.Events.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Events.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Events.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Events.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.Events.insertPanel = Ext.extend(Lino.cal.Events.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  params_panel_hidden: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/cal/Events",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Events.detail;
    this.ls_insert_handler = Lino.cal.Events.insert;
    Lino.cal.Events.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Events.insert = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Events.insertPanel(p);
});
Lino.cal.Events.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Events.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Events.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Events.duplicate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "duplicate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.Events.detailPanel = Ext.extend(Lino.cal.Events.DetailFormPanel,{
  empty_title: "Detail",
  params_panel_hidden: true,
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Vorlage bearbeiten", "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Vorlage bearbeiten", "overflowText": "Vorlage bearbeiten", "auto_save": true }, { "itemId": "show_today", "menu_item_text": "Heute", "tooltip": "Show all calendar events of the same day.", "panel_btn_handler": Lino.row_action_handler('show_today','GET',null), "iconCls": "x-tbar-calendar", "overflowText": "Heute", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET',null), "iconCls": "x-tbar-script_add", "overflowText": "per Post", "auto_save": true }, { "itemId": "do_update_guests", "menu_item_text": "Update Guests", "tooltip": "Update Guests", "panel_btn_handler": Lino.row_action_handler('do_update_guests','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Guests", "auto_save": true }, { "itemId": "take", "menu_item_text": "Annehmen", "tooltip": "Verantwortung f\u00fcr diesen Termin \u00fcbernehmen.", "panel_btn_handler": Lino.row_action_handler('take','GET',null), "iconCls": "x-tbar-flag_green", "overflowText": "Annehmen", "auto_save": true }, { "itemId": "move_next", "menu_item_text": "Nach unten", "tooltip": "Nach unten", "panel_btn_handler": Lino.row_action_handler('move_next','GET',null), "iconCls": "x-tbar-date_next", "overflowText": "Nach unten", "auto_save": true } ],
  ls_url: "/cal/Events",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Events.detail;
    this.ls_insert_handler = Lino.cal.Events.insert;
    Lino.cal.Events.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Events.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.Events.detailPanel(p);
});
Lino.cal.Events.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Events.do_print = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "POST", pk, "do_print", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Events.do_clear_cache = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "do_clear_cache", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Events.edit_template = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "edit_template", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Events.show_today = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "show_today", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Events.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Events.ParamsPanel({});
  return new Lino.cal.Events.GridPanel(p);
});
Lino.cal.Events.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Events.create_postings = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "create_postings", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Events.do_update_guests = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "do_update_guests", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Events.take = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "take", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.Events.move_next = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/Events", "GET", pk, "move_next", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.EventsByDay
Lino.cal.EventsByDay.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/EventsByDay",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/EventsByDay','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/EventsByDay','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Vorlage bearbeiten", "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Vorlage bearbeiten", "overflowText": "Vorlage bearbeiten", "auto_save": true }, { "itemId": "show_today", "menu_item_text": "Heute", "tooltip": "Show all calendar events of the same day.", "panel_btn_handler": Lino.row_action_handler('show_today','GET',null), "iconCls": "x-tbar-calendar", "overflowText": "Heute", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET',null), "iconCls": "x-tbar-script_add", "overflowText": "per Post", "auto_save": true }, { "itemId": "do_update_guests", "menu_item_text": "Update Guests", "tooltip": "Update Guests", "panel_btn_handler": Lino.row_action_handler('do_update_guests','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Guests", "auto_save": true }, { "itemId": "take", "menu_item_text": "Annehmen", "tooltip": "Verantwortung f\u00fcr diesen Termin \u00fcbernehmen.", "panel_btn_handler": Lino.row_action_handler('take','GET',null), "iconCls": "x-tbar-flag_green", "overflowText": "Annehmen", "auto_save": true }, { "itemId": "move_next", "menu_item_text": "Nach unten", "tooltip": "Nach unten", "panel_btn_handler": Lino.row_action_handler('move_next','GET',null), "iconCls": "x-tbar-date_next", "overflowText": "Nach unten", "auto_save": true } ],
  cell_edit : true,
  title : "Termine heute",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 35,
  ls_store_fields : [ { "name": "room" }, 'roomHidden', { "name": "summary" }, { "name": "owner" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "modified" }, { "name": "created" }, { "name": "build_time" }, { "name": "build_method" }, 'build_methodHidden', { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "name": "event_type" }, 'event_typeHidden', { "type": "boolean", "name": "transparent" }, { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 25,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsByDay.detail;
    this.ls_insert_handler = Lino.cal.EventsByDay.insert;
    var ww = this.containing_window;
    var room1156 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByDay/room", "method": "GET" }) }), "pageSize": 20, "emptyText": "Raum ausw\u00e4hlen..." });
    var summary1157 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var owner_disp1158 = new Ext.form.DisplayField({ "disabled": true });
    var workflow_buttons_disp1159 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id1160 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1161 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByDay/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var modified1162 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created1163 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_time1164 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_method1165 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.lino.BuildMethods });
    var owner_type1166 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByDay/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Datenbankmodell ausw\u00e4hlen..." });
    var owner_id1167 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByDay/owner_id", "method": "GET" }) }) });
    var start_date1168 = new Lino.DateField({ "selectOnFocus": true });
    var start_time1169 = new Lino.TimeField({ "selectOnFocus": true });
    var end_date1170 = new Lino.DateField({ "selectOnFocus": true });
    var end_time1171 = new Lino.TimeField({ "selectOnFocus": true });
    var access_class1172 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var sequence1173 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type1174 = new Ext.form.NumberField({ "disabled": true });
    var event_type1175 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByDay/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ereignisart ausw\u00e4hlen..." });
    var transparent1176 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var priority1177 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByDay/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Priorit\u00e4t ausw\u00e4hlen..." });
    var state1178 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var assigned_to1179 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByDay/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Raum", "editable": true, "tooltip": "(cal.EventsByDay.room) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('roomHidden','Lino.cal.Rooms.detail'), "dataIndex": "room", "editor": room1156 }, { "colIndex": 1, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "tooltip": "(cal.EventsByDay.summary) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": summary1157, "dataIndex": "summary" }, { "header": "Verkn\u00fcpft mit", "colIndex": 2, "sortable": false, "dataIndex": "owner", "width": Lino.chars2width(11), "editable": false, "tooltip": "(cal.EventsByDay.owner) " }, { "header": "Arbeitsablauf", "colIndex": 3, "sortable": false, "dataIndex": "workflow_buttons", "width": Lino.chars2width(31), "editable": false, "tooltip": "(cal.EventsByDay.workflow_buttons) " }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.EventsByDay.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1160, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.EventsByDay.user) ", "filter": { "type": "string" }, "header": "Verantwortlicher", "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "dataIndex": "user", "hidden": true, "editor": user1161 }, { "colIndex": 6, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.EventsByDay.modified) ", "header": "Bearbeitet", "dataIndex": "modified", "hidden": true }, { "colIndex": 7, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.EventsByDay.created) ", "header": "Erstellt", "dataIndex": "created", "hidden": true }, { "colIndex": 8, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.EventsByDay.build_time) ", "header": "Druckdatum", "dataIndex": "build_time", "hidden": true }, { "colIndex": 9, "sortable": true, "header": "Konstruktionsmethode", "editable": true, "tooltip": "(cal.EventsByDay.build_method) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": build_method1165, "hidden": true, "dataIndex": "build_method" }, { "colIndex": 10, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.EventsByDay.owner_type) ", "filter": { "type": "string" }, "header": "Verkn\u00fcpft mit (Modell)", "renderer": Lino.fk_renderer('owner_typeHidden','Lino.contenttypes.ContentTypes.detail'), "dataIndex": "owner_type", "hidden": true, "editor": owner_type1166 }, { "colIndex": 11, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "tooltip": "(cal.EventsByDay.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": owner_id1167, "hidden": true, "dataIndex": "owner_id" }, { "colIndex": 12, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.EventsByDay.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "editor": start_date1168, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "start_date" }, { "colIndex": 13, "sortable": true, "header": "Beginnt um", "editable": true, "tooltip": "(cal.EventsByDay.start_time) ", "width": Lino.chars2width(9), "editor": start_time1169, "hidden": true, "dataIndex": "start_time" }, { "colIndex": 14, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.EventsByDay.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Endet am", "editor": end_date1170, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "end_date" }, { "colIndex": 15, "sortable": true, "header": "Endet um", "editable": true, "tooltip": "(cal.EventsByDay.end_time) ", "width": Lino.chars2width(9), "editor": end_time1171, "hidden": true, "dataIndex": "end_time" }, { "colIndex": 16, "sortable": true, "header": "Zugriffsklasse", "editable": true, "tooltip": "(cal.EventsByDay.access_class) Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist", "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": access_class1172, "hidden": true, "dataIndex": "access_class" }, new Lino.NullNumberColumn({ "colIndex": 17, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.EventsByDay.sequence) ", "filter": { "type": "numeric" }, "header": "Revisionsnummer", "editor": sequence1173, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "sequence" }), new Lino.NullNumberColumn({ "colIndex": 18, "sortable": true, "format": "0", "editable": false, "tooltip": "(cal.EventsByDay.auto_type) ", "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 19, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.EventsByDay.event_type) ", "filter": { "type": "string" }, "header": "Ereignisart", "renderer": Lino.fk_renderer('event_typeHidden','Lino.cal.EventTypes.detail'), "dataIndex": "event_type", "hidden": true, "editor": event_type1175 }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.EventsByDay.transparent) Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.", "filter": { "type": "boolean" }, "header": "nicht blockierend", "dataIndex": "transparent", "hidden": true }, { "colIndex": 21, "sortable": true, "header": "Priorit\u00e4t", "editable": true, "tooltip": "(cal.EventsByDay.priority) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": priority1177, "hidden": true, "dataIndex": "priority" }, { "colIndex": 22, "sortable": true, "header": "Zustand", "editable": true, "tooltip": "(cal.EventsByDay.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(14), "editor": state1178, "hidden": true, "dataIndex": "state" }, { "colIndex": 23, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.EventsByDay.assigned_to) ", "filter": { "type": "string" }, "header": "Zugewiesen zu", "renderer": Lino.fk_renderer('assigned_toHidden','Lino.users.Users.detail'), "dataIndex": "assigned_to", "hidden": true, "editor": assigned_to1179 } ];
    Lino.cal.EventsByDay.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsByDay.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.EventsByDay.insertPanel = Ext.extend(Lino.cal.Events.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/cal/EventsByDay",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsByDay.detail;
    this.ls_insert_handler = Lino.cal.EventsByDay.insert;
    Lino.cal.EventsByDay.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsByDay.insert = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.EventsByDay.insertPanel(p);
});
Lino.cal.EventsByDay.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.duplicate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "duplicate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.EventsByDay.detailPanel = Ext.extend(Lino.cal.Events.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Vorlage bearbeiten", "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Vorlage bearbeiten", "overflowText": "Vorlage bearbeiten", "auto_save": true }, { "itemId": "show_today", "menu_item_text": "Heute", "tooltip": "Show all calendar events of the same day.", "panel_btn_handler": Lino.row_action_handler('show_today','GET',null), "iconCls": "x-tbar-calendar", "overflowText": "Heute", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET',null), "iconCls": "x-tbar-script_add", "overflowText": "per Post", "auto_save": true }, { "itemId": "do_update_guests", "menu_item_text": "Update Guests", "tooltip": "Update Guests", "panel_btn_handler": Lino.row_action_handler('do_update_guests','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Guests", "auto_save": true }, { "itemId": "take", "menu_item_text": "Annehmen", "tooltip": "Verantwortung f\u00fcr diesen Termin \u00fcbernehmen.", "panel_btn_handler": Lino.row_action_handler('take','GET',null), "iconCls": "x-tbar-flag_green", "overflowText": "Annehmen", "auto_save": true }, { "itemId": "move_next", "menu_item_text": "Nach unten", "tooltip": "Nach unten", "panel_btn_handler": Lino.row_action_handler('move_next','GET',null), "iconCls": "x-tbar-date_next", "overflowText": "Nach unten", "auto_save": true } ],
  ls_url: "/cal/EventsByDay",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsByDay.detail;
    this.ls_insert_handler = Lino.cal.EventsByDay.insert;
    Lino.cal.EventsByDay.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsByDay.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.EventsByDay.detailPanel(p);
});
Lino.cal.EventsByDay.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.do_print = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "POST", pk, "do_print", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.do_clear_cache = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "do_clear_cache", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.edit_template = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "edit_template", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.show_today = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "show_today", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Events.ParamsPanel({});
  return new Lino.cal.EventsByDay.GridPanel(p);
});
Lino.cal.EventsByDay.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.create_postings = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "create_postings", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.do_update_guests = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "do_update_guests", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.take = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "take", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByDay.move_next = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByDay", "GET", pk, "move_next", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.OneEvent
Lino.cal.OneEvent.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/OneEvent",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/OneEvent','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/OneEvent','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Drucken", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Vorlage bearbeiten", "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Vorlage bearbeiten", "overflowText": "Vorlage bearbeiten", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "show_today", "menu_item_text": "Heute", "tooltip": "Show all calendar events of the same day.", "panel_btn_handler": Lino.row_action_handler('show_today','GET',null), "iconCls": "x-tbar-calendar", "overflowText": "Heute", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET',null), "iconCls": "x-tbar-script_add", "overflowText": "per Post", "auto_save": true }, { "itemId": "do_update_guests", "menu_item_text": "Update Guests", "tooltip": "Update Guests", "panel_btn_handler": Lino.row_action_handler('do_update_guests','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Guests", "auto_save": true }, { "itemId": "move_next", "menu_item_text": "Nach unten", "tooltip": "Nach unten", "panel_btn_handler": Lino.row_action_handler('move_next','GET',null), "iconCls": "x-tbar-date_next", "overflowText": "Nach unten", "auto_save": true }, { "itemId": "take", "menu_item_text": "Annehmen", "tooltip": "Verantwortung f\u00fcr diesen Termin \u00fcbernehmen.", "panel_btn_handler": Lino.row_action_handler('take','GET',null), "iconCls": "x-tbar-flag_green", "overflowText": "Annehmen", "auto_save": true } ],
  cell_edit : true,
  title : "Termine",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 35,
  ls_store_fields : [ { "name": "when_text" }, { "name": "user" }, 'userHidden', { "name": "summary" }, { "name": "event_type" }, 'event_typeHidden', { "type": "int", "name": "id" }, { "name": "modified" }, { "name": "created" }, { "name": "build_time" }, { "name": "build_method" }, 'build_methodHidden', { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "room" }, 'roomHidden', { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 25,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.OneEvent.detail;
    this.ls_insert_handler = Lino.cal.OneEvent.insert;
    var ww = this.containing_window;
    var when_text_disp1181 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var user1182 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/OneEvent/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var summary1183 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var event_type1184 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/OneEvent/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ereignisart ausw\u00e4hlen..." });
    var id1185 = new Ext.form.NumberField({ "selectOnFocus": true });
    var modified1186 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created1187 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_time1188 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_method1189 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.lino.BuildMethods });
    var owner_type1190 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/OneEvent/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Datenbankmodell ausw\u00e4hlen..." });
    var owner_id1191 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/OneEvent/owner_id", "method": "GET" }) }) });
    var start_date1192 = new Lino.DateField({ "selectOnFocus": true });
    var start_time1193 = new Lino.TimeField({ "selectOnFocus": true });
    var end_date1194 = new Lino.DateField({ "selectOnFocus": true });
    var end_time1195 = new Lino.TimeField({ "selectOnFocus": true });
    var access_class1196 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var sequence1197 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type1198 = new Ext.form.NumberField({ "disabled": true });
    var transparent1199 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var room1200 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/OneEvent/room", "method": "GET" }) }), "pageSize": 20, "emptyText": "Raum ausw\u00e4hlen..." });
    var priority1201 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/OneEvent/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Priorit\u00e4t ausw\u00e4hlen..." });
    var state1202 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var assigned_to1203 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/OneEvent/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var owner_disp1204 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "header": "Wann", "colIndex": 0, "sortable": false, "dataIndex": "when_text", "width": Lino.chars2width(21), "editable": false, "tooltip": "(cal.OneEvent.when_text) " }, { "colIndex": 1, "sortable": true, "header": "Verantwortlicher", "editable": true, "tooltip": "(cal.OneEvent.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "dataIndex": "user", "editor": user1182 }, { "colIndex": 2, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "tooltip": "(cal.OneEvent.summary) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": summary1183, "dataIndex": "summary" }, { "colIndex": 3, "sortable": true, "header": "Ereignisart", "editable": true, "tooltip": "(cal.OneEvent.event_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('event_typeHidden','Lino.cal.EventTypes.detail'), "dataIndex": "event_type", "editor": event_type1184 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.OneEvent.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1185, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.OneEvent.modified) ", "header": "Bearbeitet", "dataIndex": "modified", "hidden": true }, { "colIndex": 6, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.OneEvent.created) ", "header": "Erstellt", "dataIndex": "created", "hidden": true }, { "colIndex": 7, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.OneEvent.build_time) ", "header": "Druckdatum", "dataIndex": "build_time", "hidden": true }, { "colIndex": 8, "sortable": true, "header": "Konstruktionsmethode", "editable": true, "tooltip": "(cal.OneEvent.build_method) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": build_method1189, "hidden": true, "dataIndex": "build_method" }, { "colIndex": 9, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.OneEvent.owner_type) ", "filter": { "type": "string" }, "header": "Verkn\u00fcpft mit (Modell)", "renderer": Lino.fk_renderer('owner_typeHidden','Lino.contenttypes.ContentTypes.detail'), "dataIndex": "owner_type", "hidden": true, "editor": owner_type1190 }, { "colIndex": 10, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "tooltip": "(cal.OneEvent.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": owner_id1191, "hidden": true, "dataIndex": "owner_id" }, { "colIndex": 11, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.OneEvent.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "editor": start_date1192, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "start_date" }, { "colIndex": 12, "sortable": true, "header": "Beginnt um", "editable": true, "tooltip": "(cal.OneEvent.start_time) ", "width": Lino.chars2width(9), "editor": start_time1193, "hidden": true, "dataIndex": "start_time" }, { "colIndex": 13, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.OneEvent.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Endet am", "editor": end_date1194, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "end_date" }, { "colIndex": 14, "sortable": true, "header": "Endet um", "editable": true, "tooltip": "(cal.OneEvent.end_time) ", "width": Lino.chars2width(9), "editor": end_time1195, "hidden": true, "dataIndex": "end_time" }, { "colIndex": 15, "sortable": true, "header": "Zugriffsklasse", "editable": true, "tooltip": "(cal.OneEvent.access_class) Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist", "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": access_class1196, "hidden": true, "dataIndex": "access_class" }, new Lino.NullNumberColumn({ "colIndex": 16, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.OneEvent.sequence) ", "filter": { "type": "numeric" }, "header": "Revisionsnummer", "editor": sequence1197, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "sequence" }), new Lino.NullNumberColumn({ "colIndex": 17, "sortable": true, "format": "0", "editable": false, "tooltip": "(cal.OneEvent.auto_type) ", "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 18, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.OneEvent.transparent) Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.", "filter": { "type": "boolean" }, "header": "nicht blockierend", "dataIndex": "transparent", "hidden": true }, { "colIndex": 19, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.OneEvent.room) ", "filter": { "type": "string" }, "header": "Raum", "renderer": Lino.fk_renderer('roomHidden','Lino.cal.Rooms.detail'), "dataIndex": "room", "hidden": true, "editor": room1200 }, { "colIndex": 20, "sortable": true, "header": "Priorit\u00e4t", "editable": true, "tooltip": "(cal.OneEvent.priority) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": priority1201, "hidden": true, "dataIndex": "priority" }, { "colIndex": 21, "sortable": true, "header": "Zustand", "editable": true, "tooltip": "(cal.OneEvent.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(14), "editor": state1202, "hidden": true, "dataIndex": "state" }, { "colIndex": 22, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.OneEvent.assigned_to) ", "filter": { "type": "string" }, "header": "Zugewiesen zu", "renderer": Lino.fk_renderer('assigned_toHidden','Lino.users.Users.detail'), "dataIndex": "assigned_to", "hidden": true, "editor": assigned_to1203 }, { "colIndex": 23, "sortable": false, "width": Lino.chars2width(11), "editable": false, "tooltip": "(cal.OneEvent.owner) ", "header": "Verkn\u00fcpft mit", "dataIndex": "owner", "hidden": true } ];
    Lino.cal.OneEvent.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.OneEvent.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.OneEvent.insertPanel = Ext.extend(Lino.cal.Events.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  params_panel_hidden: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/cal/OneEvent",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.OneEvent.detail;
    this.ls_insert_handler = Lino.cal.OneEvent.insert;
    Lino.cal.OneEvent.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.OneEvent.insert = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.OneEvent.insertPanel(p);
});
Lino.cal.OneEvent.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.duplicate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "duplicate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.OneEvent.detailPanel = Ext.extend(Lino.cal.Events.DetailFormPanel,{
  empty_title: "Detail",
  params_panel_hidden: true,
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Drucken", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Vorlage bearbeiten", "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Vorlage bearbeiten", "overflowText": "Vorlage bearbeiten", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "show_today", "menu_item_text": "Heute", "tooltip": "Show all calendar events of the same day.", "panel_btn_handler": Lino.row_action_handler('show_today','GET',null), "iconCls": "x-tbar-calendar", "overflowText": "Heute", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET',null), "iconCls": "x-tbar-script_add", "overflowText": "per Post", "auto_save": true }, { "itemId": "do_update_guests", "menu_item_text": "Update Guests", "tooltip": "Update Guests", "panel_btn_handler": Lino.row_action_handler('do_update_guests','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Guests", "auto_save": true }, { "itemId": "move_next", "menu_item_text": "Nach unten", "tooltip": "Nach unten", "panel_btn_handler": Lino.row_action_handler('move_next','GET',null), "iconCls": "x-tbar-date_next", "overflowText": "Nach unten", "auto_save": true }, { "itemId": "take", "menu_item_text": "Annehmen", "tooltip": "Verantwortung f\u00fcr diesen Termin \u00fcbernehmen.", "panel_btn_handler": Lino.row_action_handler('take','GET',null), "iconCls": "x-tbar-flag_green", "overflowText": "Annehmen", "auto_save": true } ],
  ls_url: "/cal/OneEvent",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.OneEvent.detail;
    this.ls_insert_handler = Lino.cal.OneEvent.insert;
    Lino.cal.OneEvent.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.OneEvent.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.OneEvent.detailPanel(p);
});
Lino.cal.OneEvent.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.do_print = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "POST", pk, "do_print", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.edit_template = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "edit_template", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.do_clear_cache = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "do_clear_cache", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.show_today = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "show_today", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Events.ParamsPanel({});
  return new Lino.cal.OneEvent.GridPanel(p);
});
Lino.cal.OneEvent.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.create_postings = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "create_postings", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.do_update_guests = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "do_update_guests", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.move_next = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "move_next", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.OneEvent.take = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/OneEvent", "GET", pk, "take", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.MyEvents
Lino.cal.MyEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/MyEvents",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/MyEvents','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/MyEvents','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Vorlage bearbeiten", "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Vorlage bearbeiten", "overflowText": "Vorlage bearbeiten", "auto_save": true }, { "itemId": "show_today", "menu_item_text": "Heute", "tooltip": "Show all calendar events of the same day.", "panel_btn_handler": Lino.row_action_handler('show_today','GET',null), "iconCls": "x-tbar-calendar", "overflowText": "Heute", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET',null), "iconCls": "x-tbar-script_add", "overflowText": "per Post", "auto_save": true }, { "itemId": "do_update_guests", "menu_item_text": "Update Guests", "tooltip": "Update Guests", "panel_btn_handler": Lino.row_action_handler('do_update_guests','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Guests", "auto_save": true }, { "itemId": "take", "menu_item_text": "Annehmen", "tooltip": "Verantwortung f\u00fcr diesen Termin \u00fcbernehmen.", "panel_btn_handler": Lino.row_action_handler('take','GET',null), "iconCls": "x-tbar-flag_green", "overflowText": "Annehmen", "auto_save": true }, { "itemId": "move_next", "menu_item_text": "Nach unten", "tooltip": "Nach unten", "panel_btn_handler": Lino.row_action_handler('move_next','GET',null), "iconCls": "x-tbar-date_next", "overflowText": "Nach unten", "auto_save": true } ],
  cell_edit : true,
  title : "Meine Termine",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 36,
  ls_store_fields : [ { "name": "when_text" }, { "name": "summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "modified" }, { "name": "created" }, { "name": "build_time" }, { "name": "build_method" }, 'build_methodHidden', { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "name": "event_type" }, 'event_typeHidden', { "type": "boolean", "name": "transparent" }, { "name": "room" }, 'roomHidden', { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 25,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEvents.detail;
    this.ls_insert_handler = Lino.cal.MyEvents.insert;
    var ww = this.containing_window;
    var when_text_disp1206 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var summary1207 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp1208 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id1209 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1210 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var modified1211 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created1212 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_time1213 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_method1214 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.lino.BuildMethods });
    var owner_type1215 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Datenbankmodell ausw\u00e4hlen..." });
    var owner_id1216 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/owner_id", "method": "GET" }) }) });
    var start_date1217 = new Lino.DateField({ "selectOnFocus": true });
    var start_time1218 = new Lino.TimeField({ "selectOnFocus": true });
    var end_date1219 = new Lino.DateField({ "selectOnFocus": true });
    var end_time1220 = new Lino.TimeField({ "selectOnFocus": true });
    var access_class1221 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var sequence1222 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type1223 = new Ext.form.NumberField({ "disabled": true });
    var event_type1224 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ereignisart ausw\u00e4hlen..." });
    var transparent1225 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var room1226 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/room", "method": "GET" }) }), "pageSize": 20, "emptyText": "Raum ausw\u00e4hlen..." });
    var priority1227 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Priorit\u00e4t ausw\u00e4hlen..." });
    var state1228 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var assigned_to1229 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var owner_disp1230 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "header": "Wann", "colIndex": 0, "sortable": false, "dataIndex": "when_text", "width": Lino.chars2width(31), "editable": false, "tooltip": "(cal.MyEvents.when_text) " }, { "colIndex": 1, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "tooltip": "(cal.MyEvents.summary) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": summary1207, "dataIndex": "summary" }, { "header": "Arbeitsablauf", "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "width": Lino.chars2width(31), "editable": false, "tooltip": "(cal.MyEvents.workflow_buttons) " }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.MyEvents.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1209, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.MyEvents.user) ", "filter": { "type": "string" }, "header": "Verantwortlicher", "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "dataIndex": "user", "hidden": true, "editor": user1210 }, { "colIndex": 5, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.MyEvents.modified) ", "header": "Bearbeitet", "dataIndex": "modified", "hidden": true }, { "colIndex": 6, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.MyEvents.created) ", "header": "Erstellt", "dataIndex": "created", "hidden": true }, { "colIndex": 7, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.MyEvents.build_time) ", "header": "Druckdatum", "dataIndex": "build_time", "hidden": true }, { "colIndex": 8, "sortable": true, "header": "Konstruktionsmethode", "editable": true, "tooltip": "(cal.MyEvents.build_method) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": build_method1214, "hidden": true, "dataIndex": "build_method" }, { "colIndex": 9, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.MyEvents.owner_type) ", "filter": { "type": "string" }, "header": "Verkn\u00fcpft mit (Modell)", "renderer": Lino.fk_renderer('owner_typeHidden','Lino.contenttypes.ContentTypes.detail'), "dataIndex": "owner_type", "hidden": true, "editor": owner_type1215 }, { "colIndex": 10, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "tooltip": "(cal.MyEvents.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": owner_id1216, "hidden": true, "dataIndex": "owner_id" }, { "colIndex": 11, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.MyEvents.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "editor": start_date1217, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "start_date" }, { "colIndex": 12, "sortable": true, "header": "Beginnt um", "editable": true, "tooltip": "(cal.MyEvents.start_time) ", "width": Lino.chars2width(9), "editor": start_time1218, "hidden": true, "dataIndex": "start_time" }, { "colIndex": 13, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.MyEvents.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Endet am", "editor": end_date1219, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "end_date" }, { "colIndex": 14, "sortable": true, "header": "Endet um", "editable": true, "tooltip": "(cal.MyEvents.end_time) ", "width": Lino.chars2width(9), "editor": end_time1220, "hidden": true, "dataIndex": "end_time" }, { "colIndex": 15, "sortable": true, "header": "Zugriffsklasse", "editable": true, "tooltip": "(cal.MyEvents.access_class) Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist", "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": access_class1221, "hidden": true, "dataIndex": "access_class" }, new Lino.NullNumberColumn({ "colIndex": 16, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.MyEvents.sequence) ", "filter": { "type": "numeric" }, "header": "Revisionsnummer", "editor": sequence1222, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "sequence" }), new Lino.NullNumberColumn({ "colIndex": 17, "sortable": true, "format": "0", "editable": false, "tooltip": "(cal.MyEvents.auto_type) ", "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 18, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.MyEvents.event_type) ", "filter": { "type": "string" }, "header": "Ereignisart", "renderer": Lino.fk_renderer('event_typeHidden','Lino.cal.EventTypes.detail'), "dataIndex": "event_type", "hidden": true, "editor": event_type1224 }, { "colIndex": 19, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.MyEvents.transparent) Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.", "filter": { "type": "boolean" }, "header": "nicht blockierend", "dataIndex": "transparent", "hidden": true }, { "colIndex": 20, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.MyEvents.room) ", "filter": { "type": "string" }, "header": "Raum", "renderer": Lino.fk_renderer('roomHidden','Lino.cal.Rooms.detail'), "dataIndex": "room", "hidden": true, "editor": room1226 }, { "colIndex": 21, "sortable": true, "header": "Priorit\u00e4t", "editable": true, "tooltip": "(cal.MyEvents.priority) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": priority1227, "hidden": true, "dataIndex": "priority" }, { "colIndex": 22, "sortable": true, "header": "Zustand", "editable": true, "tooltip": "(cal.MyEvents.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(14), "editor": state1228, "hidden": true, "dataIndex": "state" }, { "colIndex": 23, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.MyEvents.assigned_to) ", "filter": { "type": "string" }, "header": "Zugewiesen zu", "renderer": Lino.fk_renderer('assigned_toHidden','Lino.users.Users.detail'), "dataIndex": "assigned_to", "hidden": true, "editor": assigned_to1229 }, { "colIndex": 24, "sortable": false, "width": Lino.chars2width(11), "editable": false, "tooltip": "(cal.MyEvents.owner) ", "header": "Verkn\u00fcpft mit", "dataIndex": "owner", "hidden": true } ];
    Lino.cal.MyEvents.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEvents.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.MyEvents.insertPanel = Ext.extend(Lino.cal.Events.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  params_panel_hidden: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/cal/MyEvents",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEvents.detail;
    this.ls_insert_handler = Lino.cal.MyEvents.insert;
    Lino.cal.MyEvents.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEvents.insert = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyEvents.insertPanel(p);
});
Lino.cal.MyEvents.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.duplicate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "duplicate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.MyEvents.detailPanel = Ext.extend(Lino.cal.Events.DetailFormPanel,{
  empty_title: "Detail",
  params_panel_hidden: true,
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Vorlage bearbeiten", "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Vorlage bearbeiten", "overflowText": "Vorlage bearbeiten", "auto_save": true }, { "itemId": "show_today", "menu_item_text": "Heute", "tooltip": "Show all calendar events of the same day.", "panel_btn_handler": Lino.row_action_handler('show_today','GET',null), "iconCls": "x-tbar-calendar", "overflowText": "Heute", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET',null), "iconCls": "x-tbar-script_add", "overflowText": "per Post", "auto_save": true }, { "itemId": "do_update_guests", "menu_item_text": "Update Guests", "tooltip": "Update Guests", "panel_btn_handler": Lino.row_action_handler('do_update_guests','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Guests", "auto_save": true }, { "itemId": "take", "menu_item_text": "Annehmen", "tooltip": "Verantwortung f\u00fcr diesen Termin \u00fcbernehmen.", "panel_btn_handler": Lino.row_action_handler('take','GET',null), "iconCls": "x-tbar-flag_green", "overflowText": "Annehmen", "auto_save": true }, { "itemId": "move_next", "menu_item_text": "Nach unten", "tooltip": "Nach unten", "panel_btn_handler": Lino.row_action_handler('move_next','GET',null), "iconCls": "x-tbar-date_next", "overflowText": "Nach unten", "auto_save": true } ],
  ls_url: "/cal/MyEvents",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEvents.detail;
    this.ls_insert_handler = Lino.cal.MyEvents.insert;
    Lino.cal.MyEvents.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEvents.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyEvents.detailPanel(p);
});
Lino.cal.MyEvents.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.do_print = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "POST", pk, "do_print", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.do_clear_cache = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "do_clear_cache", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.edit_template = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "edit_template", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.show_today = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "show_today", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Events.ParamsPanel({});
  return new Lino.cal.MyEvents.GridPanel(p);
});
Lino.cal.MyEvents.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.create_postings = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "create_postings", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.do_update_guests = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "do_update_guests", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.take = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "take", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyEvents.move_next = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyEvents", "GET", pk, "move_next", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.MyAssignedEvents
Lino.cal.MyAssignedEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/MyAssignedEvents",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/MyAssignedEvents','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/MyAssignedEvents','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Vorlage bearbeiten", "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Vorlage bearbeiten", "overflowText": "Vorlage bearbeiten", "auto_save": true }, { "itemId": "show_today", "menu_item_text": "Heute", "tooltip": "Show all calendar events of the same day.", "panel_btn_handler": Lino.row_action_handler('show_today','GET',null), "iconCls": "x-tbar-calendar", "overflowText": "Heute", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET',null), "iconCls": "x-tbar-script_add", "overflowText": "per Post", "auto_save": true }, { "itemId": "do_update_guests", "menu_item_text": "Update Guests", "tooltip": "Update Guests", "panel_btn_handler": Lino.row_action_handler('do_update_guests','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Guests", "auto_save": true }, { "itemId": "take", "menu_item_text": "Annehmen", "tooltip": "Verantwortung f\u00fcr diesen Termin \u00fcbernehmen.", "panel_btn_handler": Lino.row_action_handler('take','GET',null), "iconCls": "x-tbar-flag_green", "overflowText": "Annehmen", "auto_save": true }, { "itemId": "move_next", "menu_item_text": "Nach unten", "tooltip": "Nach unten", "panel_btn_handler": Lino.row_action_handler('move_next','GET',null), "iconCls": "x-tbar-date_next", "overflowText": "Nach unten", "auto_save": true } ],
  cell_edit : true,
  title : "Events assigned to me",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 36,
  ls_store_fields : [ { "name": "when_text" }, { "name": "summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "modified" }, { "name": "created" }, { "name": "build_time" }, { "name": "build_method" }, 'build_methodHidden', { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "name": "event_type" }, 'event_typeHidden', { "type": "boolean", "name": "transparent" }, { "name": "room" }, 'roomHidden', { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 25,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyAssignedEvents.detail;
    this.ls_insert_handler = Lino.cal.MyAssignedEvents.insert;
    var ww = this.containing_window;
    var when_text_disp1232 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var summary1233 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp1234 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id1235 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1236 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyAssignedEvents/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var modified1237 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created1238 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_time1239 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_method1240 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.lino.BuildMethods });
    var owner_type1241 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyAssignedEvents/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Datenbankmodell ausw\u00e4hlen..." });
    var owner_id1242 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyAssignedEvents/owner_id", "method": "GET" }) }) });
    var start_date1243 = new Lino.DateField({ "selectOnFocus": true });
    var start_time1244 = new Lino.TimeField({ "selectOnFocus": true });
    var end_date1245 = new Lino.DateField({ "selectOnFocus": true });
    var end_time1246 = new Lino.TimeField({ "selectOnFocus": true });
    var access_class1247 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var sequence1248 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type1249 = new Ext.form.NumberField({ "disabled": true });
    var event_type1250 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyAssignedEvents/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ereignisart ausw\u00e4hlen..." });
    var transparent1251 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var room1252 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyAssignedEvents/room", "method": "GET" }) }), "pageSize": 20, "emptyText": "Raum ausw\u00e4hlen..." });
    var priority1253 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyAssignedEvents/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Priorit\u00e4t ausw\u00e4hlen..." });
    var state1254 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var assigned_to1255 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyAssignedEvents/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var owner_disp1256 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "header": "Wann", "colIndex": 0, "sortable": false, "dataIndex": "when_text", "width": Lino.chars2width(31), "editable": false, "tooltip": "(cal.MyAssignedEvents.when_text) " }, { "colIndex": 1, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "tooltip": "(cal.MyAssignedEvents.summary) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": summary1233, "dataIndex": "summary" }, { "header": "Arbeitsablauf", "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "width": Lino.chars2width(31), "editable": false, "tooltip": "(cal.MyAssignedEvents.workflow_buttons) " }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.MyAssignedEvents.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1235, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.MyAssignedEvents.user) ", "filter": { "type": "string" }, "header": "Verantwortlicher", "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "dataIndex": "user", "hidden": true, "editor": user1236 }, { "colIndex": 5, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.MyAssignedEvents.modified) ", "header": "Bearbeitet", "dataIndex": "modified", "hidden": true }, { "colIndex": 6, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.MyAssignedEvents.created) ", "header": "Erstellt", "dataIndex": "created", "hidden": true }, { "colIndex": 7, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.MyAssignedEvents.build_time) ", "header": "Druckdatum", "dataIndex": "build_time", "hidden": true }, { "colIndex": 8, "sortable": true, "header": "Konstruktionsmethode", "editable": true, "tooltip": "(cal.MyAssignedEvents.build_method) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": build_method1240, "hidden": true, "dataIndex": "build_method" }, { "colIndex": 9, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.MyAssignedEvents.owner_type) ", "filter": { "type": "string" }, "header": "Verkn\u00fcpft mit (Modell)", "renderer": Lino.fk_renderer('owner_typeHidden','Lino.contenttypes.ContentTypes.detail'), "dataIndex": "owner_type", "hidden": true, "editor": owner_type1241 }, { "colIndex": 10, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "tooltip": "(cal.MyAssignedEvents.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": owner_id1242, "hidden": true, "dataIndex": "owner_id" }, { "colIndex": 11, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.MyAssignedEvents.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "editor": start_date1243, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "start_date" }, { "colIndex": 12, "sortable": true, "header": "Beginnt um", "editable": true, "tooltip": "(cal.MyAssignedEvents.start_time) ", "width": Lino.chars2width(9), "editor": start_time1244, "hidden": true, "dataIndex": "start_time" }, { "colIndex": 13, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.MyAssignedEvents.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Endet am", "editor": end_date1245, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "end_date" }, { "colIndex": 14, "sortable": true, "header": "Endet um", "editable": true, "tooltip": "(cal.MyAssignedEvents.end_time) ", "width": Lino.chars2width(9), "editor": end_time1246, "hidden": true, "dataIndex": "end_time" }, { "colIndex": 15, "sortable": true, "header": "Zugriffsklasse", "editable": true, "tooltip": "(cal.MyAssignedEvents.access_class) Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist", "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": access_class1247, "hidden": true, "dataIndex": "access_class" }, new Lino.NullNumberColumn({ "colIndex": 16, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.MyAssignedEvents.sequence) ", "filter": { "type": "numeric" }, "header": "Revisionsnummer", "editor": sequence1248, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "sequence" }), new Lino.NullNumberColumn({ "colIndex": 17, "sortable": true, "format": "0", "editable": false, "tooltip": "(cal.MyAssignedEvents.auto_type) ", "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 18, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.MyAssignedEvents.event_type) ", "filter": { "type": "string" }, "header": "Ereignisart", "renderer": Lino.fk_renderer('event_typeHidden','Lino.cal.EventTypes.detail'), "dataIndex": "event_type", "hidden": true, "editor": event_type1250 }, { "colIndex": 19, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.MyAssignedEvents.transparent) Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.", "filter": { "type": "boolean" }, "header": "nicht blockierend", "dataIndex": "transparent", "hidden": true }, { "colIndex": 20, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.MyAssignedEvents.room) ", "filter": { "type": "string" }, "header": "Raum", "renderer": Lino.fk_renderer('roomHidden','Lino.cal.Rooms.detail'), "dataIndex": "room", "hidden": true, "editor": room1252 }, { "colIndex": 21, "sortable": true, "header": "Priorit\u00e4t", "editable": true, "tooltip": "(cal.MyAssignedEvents.priority) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": priority1253, "hidden": true, "dataIndex": "priority" }, { "colIndex": 22, "sortable": true, "header": "Zustand", "editable": true, "tooltip": "(cal.MyAssignedEvents.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(14), "editor": state1254, "hidden": true, "dataIndex": "state" }, { "colIndex": 23, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.MyAssignedEvents.assigned_to) ", "filter": { "type": "string" }, "header": "Zugewiesen zu", "renderer": Lino.fk_renderer('assigned_toHidden','Lino.users.Users.detail'), "dataIndex": "assigned_to", "hidden": true, "editor": assigned_to1255 }, { "colIndex": 24, "sortable": false, "width": Lino.chars2width(11), "editable": false, "tooltip": "(cal.MyAssignedEvents.owner) ", "header": "Verkn\u00fcpft mit", "dataIndex": "owner", "hidden": true } ];
    Lino.cal.MyAssignedEvents.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyAssignedEvents.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.MyAssignedEvents.insertPanel = Ext.extend(Lino.cal.Events.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  params_panel_hidden: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/cal/MyAssignedEvents",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyAssignedEvents.detail;
    this.ls_insert_handler = Lino.cal.MyAssignedEvents.insert;
    Lino.cal.MyAssignedEvents.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyAssignedEvents.insert = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.MyAssignedEvents.insertPanel(p);
});
Lino.cal.MyAssignedEvents.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.duplicate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "duplicate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.MyAssignedEvents.detailPanel = Ext.extend(Lino.cal.Events.DetailFormPanel,{
  empty_title: "Detail",
  params_panel_hidden: true,
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Vorlage bearbeiten", "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Vorlage bearbeiten", "overflowText": "Vorlage bearbeiten", "auto_save": true }, { "itemId": "show_today", "menu_item_text": "Heute", "tooltip": "Show all calendar events of the same day.", "panel_btn_handler": Lino.row_action_handler('show_today','GET',null), "iconCls": "x-tbar-calendar", "overflowText": "Heute", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET',null), "iconCls": "x-tbar-script_add", "overflowText": "per Post", "auto_save": true }, { "itemId": "do_update_guests", "menu_item_text": "Update Guests", "tooltip": "Update Guests", "panel_btn_handler": Lino.row_action_handler('do_update_guests','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Guests", "auto_save": true }, { "itemId": "take", "menu_item_text": "Annehmen", "tooltip": "Verantwortung f\u00fcr diesen Termin \u00fcbernehmen.", "panel_btn_handler": Lino.row_action_handler('take','GET',null), "iconCls": "x-tbar-flag_green", "overflowText": "Annehmen", "auto_save": true }, { "itemId": "move_next", "menu_item_text": "Nach unten", "tooltip": "Nach unten", "panel_btn_handler": Lino.row_action_handler('move_next','GET',null), "iconCls": "x-tbar-date_next", "overflowText": "Nach unten", "auto_save": true } ],
  ls_url: "/cal/MyAssignedEvents",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyAssignedEvents.detail;
    this.ls_insert_handler = Lino.cal.MyAssignedEvents.insert;
    Lino.cal.MyAssignedEvents.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyAssignedEvents.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.MyAssignedEvents.detailPanel(p);
});
Lino.cal.MyAssignedEvents.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.do_print = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "POST", pk, "do_print", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.do_clear_cache = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "do_clear_cache", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.edit_template = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "edit_template", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.show_today = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "show_today", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Events.ParamsPanel({});
  return new Lino.cal.MyAssignedEvents.GridPanel(p);
});
Lino.cal.MyAssignedEvents.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.create_postings = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "create_postings", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.do_update_guests = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "do_update_guests", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.take = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "take", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.MyAssignedEvents.move_next = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/MyAssignedEvents", "GET", pk, "move_next", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class sessions.SessionTable
Lino.sessions.SessionTable.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/sessions/SessionTable",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/sessions/SessionTable','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/sessions/SessionTable','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Sitzungen",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 4,
  ls_store_fields : [ { "name": "session_key" }, { "name": "session_data" }, { "name": "expire_date" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 1,
  ls_id_property : "session_key",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var session_key1258 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 40 });
    var session_data1259 = new Ext.form.TextArea({ "selectOnFocus": true, "allowBlank": false, "growMax": 2000 });
    var expire_date1260 = new Ext.form.DisplayField({ "selectOnFocus": true, "allowBlank": false, "value": "<br>" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Sitzungs-ID", "editable": true, "tooltip": "(sessions.SessionTable.session_key) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": session_key1258, "dataIndex": "session_key" }, { "colIndex": 1, "sortable": false, "header": "Sitzungsdaten", "editable": true, "tooltip": "(sessions.SessionTable.session_data) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "editor": session_data1259, "dataIndex": "session_data" }, { "colIndex": 2, "sortable": true, "width": Lino.chars2width(17), "editable": true, "tooltip": "(sessions.SessionTable.expire_date) ", "header": "Verfallsdatum", "editor": expire_date1260, "dataIndex": "expire_date" } ];
    Lino.sessions.SessionTable.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sessions.SessionTable.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/sessions/SessionTable", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.sessions.SessionTable.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/sessions/SessionTable", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.sessions.SessionTable.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/sessions/SessionTable", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.sessions.SessionTable.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/sessions/SessionTable", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.sessions.SessionTable.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/sessions/SessionTable", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.sessions.SessionTable.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/sessions/SessionTable", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.sessions.SessionTable.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.sessions.SessionTable.GridPanel(p);
});

// js_render_GridPanel_class system.MyTextFieldTemplates
Lino.system.MyTextFieldTemplates.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/system/MyTextFieldTemplates",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/system/MyTextFieldTemplates','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/system/MyTextFieldTemplates','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Meine Einf\u00fcgetexte",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 3,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 5,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.system.MyTextFieldTemplates.detail;
    this.ls_insert_handler = Lino.system.MyTextFieldTemplates.insert;
    var ww = this.containing_window;
    var id1262 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1263 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.MyTextFieldTemplates.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1262, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(system.MyTextFieldTemplates.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name1263, "dataIndex": "name" } ];
    Lino.system.MyTextFieldTemplates.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.system.MyTextFieldTemplates.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/MyTextFieldTemplates", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.MyTextFieldTemplates.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/MyTextFieldTemplates", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.MyTextFieldTemplates.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/MyTextFieldTemplates", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.system.MyTextFieldTemplates.insertPanel = Ext.extend(Lino.system.TextFieldTemplates.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/system/MyTextFieldTemplates",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.MyTextFieldTemplates.detail;
    this.ls_insert_handler = Lino.system.MyTextFieldTemplates.insert;
    Lino.system.MyTextFieldTemplates.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.system.MyTextFieldTemplates.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.system.MyTextFieldTemplates.insertPanel(p);
});
Lino.system.MyTextFieldTemplates.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/MyTextFieldTemplates", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.MyTextFieldTemplates.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/MyTextFieldTemplates", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.MyTextFieldTemplates.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/MyTextFieldTemplates", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.system.MyTextFieldTemplates.detailPanel = Ext.extend(Lino.system.TextFieldTemplates.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  ls_url: "/system/MyTextFieldTemplates",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.MyTextFieldTemplates.detail;
    this.ls_insert_handler = Lino.system.MyTextFieldTemplates.insert;
    Lino.system.MyTextFieldTemplates.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.system.MyTextFieldTemplates.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.system.MyTextFieldTemplates.detailPanel(p);
});
Lino.system.MyTextFieldTemplates.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/MyTextFieldTemplates", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.MyTextFieldTemplates.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.system.MyTextFieldTemplates.GridPanel(p);
});
Lino.system.MyTextFieldTemplates.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/MyTextFieldTemplates", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class users.AuthoritiesGiven
Lino.users.AuthoritiesGiven.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/users/AuthoritiesGiven",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/users/AuthoritiesGiven','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/users/AuthoritiesGiven','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Erteilte Vollmachten",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 4,
  ls_store_fields : [ { "name": "authorized" }, 'authorizedHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 7,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var authorized36 = new Lino.RemoteComboFieldElement({ "preferred_width": 15, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/AuthoritiesGiven/authorized", "method": "GET" }) }), "emptyText": "Benutzer ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
      var bp = this.get_base_params();
      authorized36.setContextValue('mk',bp['mk']);
      authorized36.setContextValue('mt',bp['mt']);
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Benutzer", "editable": true, "tooltip": "(users.AuthoritiesGiven.authorized) The user who gets authority to act in your name.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('authorizedHidden','Lino.users.Users.detail'), "dataIndex": "authorized", "editor": authorized36 } ];
    Lino.users.AuthoritiesGiven.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.AuthoritiesGiven.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/AuthoritiesGiven", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.AuthoritiesGiven.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/AuthoritiesGiven", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.AuthoritiesGiven.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/AuthoritiesGiven", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.AuthoritiesGiven.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/AuthoritiesGiven", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.AuthoritiesGiven.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/AuthoritiesGiven", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.AuthoritiesGiven.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/AuthoritiesGiven", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.AuthoritiesGiven.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.users.AuthoritiesGiven.GridPanel(p);
});

// js_render_GridPanel_class users.AuthoritiesTaken
Lino.users.AuthoritiesTaken.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/users/AuthoritiesTaken",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/users/AuthoritiesTaken','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/users/AuthoritiesTaken','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Erhaltene Vollmachten",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 4,
  ls_store_fields : [ { "name": "user" }, 'userHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 7,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var user109 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/AuthoritiesTaken/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Autor", "editable": true, "tooltip": "(users.AuthoritiesTaken.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "dataIndex": "user", "editor": user109 } ];
    Lino.users.AuthoritiesTaken.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.AuthoritiesTaken.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/AuthoritiesTaken", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.AuthoritiesTaken.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/AuthoritiesTaken", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.AuthoritiesTaken.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/AuthoritiesTaken", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.AuthoritiesTaken.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/AuthoritiesTaken", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.AuthoritiesTaken.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/AuthoritiesTaken", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.AuthoritiesTaken.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/AuthoritiesTaken", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.AuthoritiesTaken.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.users.AuthoritiesTaken.GridPanel(p);
});

// js_render_GridPanel_class countries.PlacesByPlace
Lino.countries.PlacesByPlace.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/countries/PlacesByPlace",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/countries/PlacesByPlace','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/countries/PlacesByPlace','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Unterteilungen",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 9,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "name": "type" }, 'typeHidden', { "name": "zip_code" }, { "type": "int", "name": "id" }, { "name": "country" }, 'countryHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 9,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.PlacesByPlace.detail;
    this.ls_insert_handler = Lino.countries.PlacesByPlace.insert;
    var ww = this.containing_window;
    var name230 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de231 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type232 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/PlacesByPlace/type", "method": "GET" }) }) });
    var zip_code233 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "maxLength": 8 });
    var id234 = new Ext.form.NumberField({ "selectOnFocus": true });
    var country235 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/PlacesByPlace/country", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
      type232.setContextValue('country', record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country235.on('change',Lino.chooser_handler(type232,'country'));
      Lino.countries.PlacesByPlace.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(countries.PlacesByPlace.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name230, "dataIndex": "name" }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (de)", "editable": true, "tooltip": "(countries.PlacesByPlace.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_de231, "dataIndex": "name_de" }, { "colIndex": 2, "sortable": true, "header": "Ortsart", "editable": true, "tooltip": "(countries.PlacesByPlace.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": type232, "dataIndex": "type" }, { "colIndex": 3, "sortable": true, "header": "zip code", "editable": true, "tooltip": "(countries.PlacesByPlace.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(10), "editor": zip_code233, "dataIndex": "zip_code" }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(countries.PlacesByPlace.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id234, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(countries.PlacesByPlace.country) ", "filter": { "type": "string" }, "header": "Land", "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "dataIndex": "country", "hidden": true, "editor": country235 } ];
    Lino.countries.PlacesByPlace.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.PlacesByPlace.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/PlacesByPlace", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.PlacesByPlace.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/PlacesByPlace", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.PlacesByPlace.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/PlacesByPlace", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.countries.PlacesByPlace.insertPanel = Ext.extend(Lino.countries.Places.DetailFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/countries/PlacesByPlace",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.PlacesByPlace.detail;
    this.ls_insert_handler = Lino.countries.PlacesByPlace.insert;
    Lino.countries.PlacesByPlace.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.PlacesByPlace.insert = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.PlacesByPlace.insertPanel(p);
});
Lino.countries.PlacesByPlace.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/PlacesByPlace", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.PlacesByPlace.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/PlacesByPlace", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.PlacesByPlace.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/PlacesByPlace", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.countries.PlacesByPlace.detailPanel = Ext.extend(Lino.countries.Places.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  ls_url: "/countries/PlacesByPlace",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.PlacesByPlace.detail;
    this.ls_insert_handler = Lino.countries.PlacesByPlace.insert;
    Lino.countries.PlacesByPlace.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.PlacesByPlace.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.countries.PlacesByPlace.detailPanel(p);
});
Lino.countries.PlacesByPlace.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/PlacesByPlace", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.PlacesByPlace.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.countries.PlacesByPlace.GridPanel(p);
});
Lino.countries.PlacesByPlace.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/PlacesByPlace", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class countries.PlacesByCountry
Lino.countries.PlacesByCountry.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/countries/PlacesByCountry",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/countries/PlacesByCountry','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/countries/PlacesByCountry','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Orte",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 9,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "name": "type" }, 'typeHidden', { "name": "zip_code" }, { "type": "int", "name": "id" }, { "name": "parent" }, 'parentHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 9,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.PlacesByCountry.detail;
    this.ls_insert_handler = Lino.countries.PlacesByCountry.insert;
    var ww = this.containing_window;
    var name207 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de208 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type209 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/PlacesByCountry/type", "method": "GET" }) }) });
    var zip_code210 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "maxLength": 8 });
    var id211 = new Ext.form.NumberField({ "selectOnFocus": true });
    var parent212 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/PlacesByCountry/parent", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
      var bp = this.get_base_params();
      type209.setContextValue('mk',bp['mk']);
      type209.setContextValue('mt',bp['mt']);
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Bezeichnung", "editable": true, "tooltip": "(countries.PlacesByCountry.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name207, "dataIndex": "name" }, { "colIndex": 1, "sortable": true, "header": "Bezeichnung (de)", "editable": true, "tooltip": "(countries.PlacesByCountry.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_de208, "dataIndex": "name_de" }, { "colIndex": 2, "sortable": true, "header": "Ortsart", "editable": true, "tooltip": "(countries.PlacesByCountry.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": type209, "dataIndex": "type" }, { "colIndex": 3, "sortable": true, "header": "zip code", "editable": true, "tooltip": "(countries.PlacesByCountry.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(10), "editor": zip_code210, "dataIndex": "zip_code" }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(countries.PlacesByCountry.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id211, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(countries.PlacesByCountry.parent) The superordinate geographic place         of which this place is a part.", "filter": { "type": "string" }, "header": "Teil von", "renderer": Lino.fk_renderer('parentHidden','Lino.countries.Places.detail'), "dataIndex": "parent", "hidden": true, "editor": parent212 } ];
    Lino.countries.PlacesByCountry.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.PlacesByCountry.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/PlacesByCountry", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.PlacesByCountry.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/PlacesByCountry", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.PlacesByCountry.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/PlacesByCountry", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.countries.PlacesByCountry.insertPanel = Ext.extend(Lino.countries.Places.DetailFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/countries/PlacesByCountry",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.PlacesByCountry.detail;
    this.ls_insert_handler = Lino.countries.PlacesByCountry.insert;
    Lino.countries.PlacesByCountry.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.PlacesByCountry.insert = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.PlacesByCountry.insertPanel(p);
});
Lino.countries.PlacesByCountry.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/PlacesByCountry", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.PlacesByCountry.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/PlacesByCountry", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.PlacesByCountry.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/PlacesByCountry", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.countries.PlacesByCountry.detailPanel = Ext.extend(Lino.countries.Places.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  ls_url: "/countries/PlacesByCountry",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.PlacesByCountry.detail;
    this.ls_insert_handler = Lino.countries.PlacesByCountry.insert;
    Lino.countries.PlacesByCountry.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.PlacesByCountry.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.countries.PlacesByCountry.detailPanel(p);
});
Lino.countries.PlacesByCountry.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/PlacesByCountry", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.PlacesByCountry.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.countries.PlacesByCountry.GridPanel(p);
});
Lino.countries.PlacesByCountry.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/PlacesByCountry", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class contacts.PartnersByCity
Lino.contacts.PartnersByCity.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/PartnersByCity",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/contacts/PartnersByCity','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "print_labels", "menu_item_text": "Etiketten", "tooltip": "Generate mailing labels for these recipients", "panel_btn_handler": Lino.list_action_handler('/contacts/PartnersByCity','print_labels','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-pdf", "overflowText": "Etiketten", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/contacts/PartnersByCity','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Partner",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 22,
  ls_store_fields : [ { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "name" }, { "name": "language" }, 'languageHidden', { "type": "int", "name": "id" }, { "name": "country" }, 'countryHidden', { "name": "zip_code" }, { "name": "region" }, 'regionHidden', { "name": "addr1" }, { "name": "street_prefix" }, { "name": "email" }, { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 14,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.PartnersByCity.detail;
    this.ls_insert_handler = Lino.contacts.PartnersByCity.insert;
    var ww = this.containing_window;
    var street254 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no255 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box256 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr2257 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name258 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var language259 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "Englisch" ], [ "de", "Deutsch" ] ] });
    var id260 = new Ext.form.NumberField({ "selectOnFocus": true });
    var country261 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/PartnersByCity/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Land ausw\u00e4hlen..." });
    var zip_code262 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var region263 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/PartnersByCity/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var addr1264 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix265 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var email266 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var url267 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone268 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm269 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax270 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks271 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
      region263.setContextValue('country', record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country261.on('change',Lino.chooser_handler(region263,'country'));
      Lino.contacts.PartnersByCity.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "(contacts.PartnersByCity.street) Name der Stra\u00dfe, ohne Hausnummer", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": street254, "dataIndex": "street" }, { "colIndex": 1, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "(contacts.PartnersByCity.street_no) Hausnummer", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": street_no255, "dataIndex": "street_no" }, { "colIndex": 2, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.PartnersByCity.street_box) Text to print after street nuber on the same line.", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": street_box256, "dataIndex": "street_box" }, { "colIndex": 3, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "(contacts.PartnersByCity.addr2) Adresszeile nach Stra\u00dfe", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": addr2257, "dataIndex": "addr2" }, { "colIndex": 4, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.PartnersByCity.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name258, "dataIndex": "name" }, { "colIndex": 5, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(contacts.PartnersByCity.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": language259, "dataIndex": "language" }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.PartnersByCity.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id260, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 7, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.PartnersByCity.country) ", "filter": { "type": "string" }, "header": "Land", "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "dataIndex": "country", "hidden": true, "editor": country261 }, { "colIndex": 8, "sortable": true, "header": "Postleitzahl", "editable": true, "tooltip": "(contacts.PartnersByCity.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": zip_code262, "hidden": true, "dataIndex": "zip_code" }, { "colIndex": 9, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.PartnersByCity.region) ", "filter": { "type": "string" }, "header": "Regierungsbezirk", "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Places.detail'), "dataIndex": "region", "hidden": true, "editor": region263 }, { "colIndex": 10, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "(contacts.PartnersByCity.addr1) Adresszeile vor Stra\u00dfe", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": addr1264, "hidden": true, "dataIndex": "addr1" }, { "colIndex": 11, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "(contacts.PartnersByCity.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": street_prefix265, "hidden": true, "dataIndex": "street_prefix" }, { "colIndex": 12, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.PartnersByCity.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": email266, "hidden": true, "dataIndex": "email" }, { "colIndex": 13, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.PartnersByCity.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": url267, "hidden": true, "dataIndex": "url" }, { "colIndex": 14, "sortable": true, "header": "Telefon", "editable": true, "tooltip": "(contacts.PartnersByCity.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": phone268, "hidden": true, "dataIndex": "phone" }, { "colIndex": 15, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.PartnersByCity.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": gsm269, "hidden": true, "dataIndex": "gsm" }, { "colIndex": 16, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.PartnersByCity.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": fax270, "hidden": true, "dataIndex": "fax" }, { "colIndex": 17, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(contacts.PartnersByCity.remarks) ", "filter": { "type": "string" }, "header": "Bemerkungen", "editor": remarks271, "hidden": true, "dataIndex": "remarks" } ];
    Lino.contacts.PartnersByCity.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.PartnersByCity.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/PartnersByCity", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.PartnersByCity.print_labels = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/PartnersByCity", "GET", pk, "print_labels", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.PartnersByCity.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/PartnersByCity", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.PartnersByCity.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/PartnersByCity", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.contacts.PartnersByCity.insertPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/contacts/PartnersByCity",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.PartnersByCity.detail;
    this.ls_insert_handler = Lino.contacts.PartnersByCity.insert;
    Lino.contacts.PartnersByCity.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.PartnersByCity.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.PartnersByCity.insertPanel(p);
});
Lino.contacts.PartnersByCity.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/PartnersByCity", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.PartnersByCity.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/PartnersByCity", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.PartnersByCity.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/PartnersByCity", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.contacts.PartnersByCity.detailPanel = Ext.extend(Lino.contacts.Partners.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  ls_url: "/contacts/PartnersByCity",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.PartnersByCity.detail;
    this.ls_insert_handler = Lino.contacts.PartnersByCity.insert;
    Lino.contacts.PartnersByCity.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.PartnersByCity.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.PartnersByCity.detailPanel(p);
});
Lino.contacts.PartnersByCity.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/PartnersByCity", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.PartnersByCity.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.PartnersByCity.GridPanel(p);
});
Lino.contacts.PartnersByCity.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/PartnersByCity", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class contacts.PartnersByCountry
Lino.contacts.PartnersByCountry.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/PartnersByCountry",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/contacts/PartnersByCountry','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "print_labels", "menu_item_text": "Etiketten", "tooltip": "Generate mailing labels for these recipients", "panel_btn_handler": Lino.list_action_handler('/contacts/PartnersByCountry','print_labels','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-pdf", "overflowText": "Etiketten", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/contacts/PartnersByCountry','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Partner",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 22,
  ls_store_fields : [ { "name": "city" }, 'cityHidden', { "name": "street" }, { "name": "street_no" }, { "name": "name" }, { "name": "language" }, 'languageHidden', { "type": "int", "name": "id" }, { "name": "zip_code" }, { "name": "region" }, 'regionHidden', { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "email" }, { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 14,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.PartnersByCountry.detail;
    this.ls_insert_handler = Lino.contacts.PartnersByCountry.insert;
    var ww = this.containing_window;
    var city1265 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/PartnersByCountry/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var street1266 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no1267 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var name1268 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var language1269 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "Englisch" ], [ "de", "Deutsch" ] ] });
    var id1270 = new Ext.form.NumberField({ "selectOnFocus": true });
    var zip_code1271 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var region1272 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/PartnersByCountry/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ort ausw\u00e4hlen..." });
    var addr11273 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix1274 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_box1275 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr21276 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var email1277 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var url1278 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone1279 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm1280 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax1281 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks1282 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
      var bp = this.get_base_params();
      city1265.setContextValue('mk',bp['mk']);
      city1265.setContextValue('mt',bp['mt']);
      city1265.setContextValue('region', record ? record.data['regionHidden'] : undefined);
      var bp = this.get_base_params();
      region1272.setContextValue('mk',bp['mk']);
      region1272.setContextValue('mt',bp['mt']);
    };
    this.onRender = function(ct, position) {
      region1272.on('change',Lino.chooser_handler(city1265,'region'));
      Lino.contacts.PartnersByCountry.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Stadt", "editable": true, "tooltip": "(contacts.PartnersByCountry.city) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Places.detail'), "dataIndex": "city", "editor": city1265 }, { "colIndex": 1, "sortable": true, "header": "Stra\u00dfe", "editable": true, "tooltip": "(contacts.PartnersByCountry.street) Name der Stra\u00dfe, ohne Hausnummer", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": street1266, "dataIndex": "street" }, { "colIndex": 2, "sortable": true, "header": "Nr.", "editable": true, "tooltip": "(contacts.PartnersByCountry.street_no) Hausnummer", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": street_no1267, "dataIndex": "street_no" }, { "colIndex": 3, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.PartnersByCountry.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name1268, "dataIndex": "name" }, { "colIndex": 4, "sortable": true, "header": "Sprache", "editable": true, "tooltip": "(contacts.PartnersByCountry.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": language1269, "dataIndex": "language" }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.PartnersByCountry.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1270, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Postleitzahl", "editable": true, "tooltip": "(contacts.PartnersByCountry.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": zip_code1271, "hidden": true, "dataIndex": "zip_code" }, { "colIndex": 7, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.PartnersByCountry.region) ", "filter": { "type": "string" }, "header": "Regierungsbezirk", "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Places.detail'), "dataIndex": "region", "hidden": true, "editor": region1272 }, { "colIndex": 8, "sortable": true, "header": "Adresszeile vor Stra\u00dfe", "editable": true, "tooltip": "(contacts.PartnersByCountry.addr1) Adresszeile vor Stra\u00dfe", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": addr11273, "hidden": true, "dataIndex": "addr1" }, { "colIndex": 9, "sortable": true, "header": "Pr\u00e4fix Stra\u00dfe", "editable": true, "tooltip": "(contacts.PartnersByCountry.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": street_prefix1274, "hidden": true, "dataIndex": "street_prefix" }, { "colIndex": 10, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.PartnersByCountry.street_box) Text to print after street nuber on the same line.", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": street_box1275, "hidden": true, "dataIndex": "street_box" }, { "colIndex": 11, "sortable": true, "header": "Adresszeile nach Stra\u00dfe", "editable": true, "tooltip": "(contacts.PartnersByCountry.addr2) Adresszeile nach Stra\u00dfe", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": addr21276, "hidden": true, "dataIndex": "addr2" }, { "colIndex": 12, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.PartnersByCountry.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": email1277, "hidden": true, "dataIndex": "email" }, { "colIndex": 13, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.PartnersByCountry.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": url1278, "hidden": true, "dataIndex": "url" }, { "colIndex": 14, "sortable": true, "header": "Telefon", "editable": true, "tooltip": "(contacts.PartnersByCountry.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": phone1279, "hidden": true, "dataIndex": "phone" }, { "colIndex": 15, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.PartnersByCountry.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": gsm1280, "hidden": true, "dataIndex": "gsm" }, { "colIndex": 16, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.PartnersByCountry.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": fax1281, "hidden": true, "dataIndex": "fax" }, { "colIndex": 17, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(contacts.PartnersByCountry.remarks) ", "filter": { "type": "string" }, "header": "Bemerkungen", "editor": remarks1282, "hidden": true, "dataIndex": "remarks" } ];
    Lino.contacts.PartnersByCountry.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.PartnersByCountry.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/PartnersByCountry", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.PartnersByCountry.print_labels = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/PartnersByCountry", "GET", pk, "print_labels", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.PartnersByCountry.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/PartnersByCountry", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.PartnersByCountry.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/PartnersByCountry", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.contacts.PartnersByCountry.insertPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/contacts/PartnersByCountry",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.PartnersByCountry.detail;
    this.ls_insert_handler = Lino.contacts.PartnersByCountry.insert;
    Lino.contacts.PartnersByCountry.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.PartnersByCountry.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.PartnersByCountry.insertPanel(p);
});
Lino.contacts.PartnersByCountry.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/PartnersByCountry", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.PartnersByCountry.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/PartnersByCountry", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.PartnersByCountry.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/PartnersByCountry", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.contacts.PartnersByCountry.detailPanel = Ext.extend(Lino.contacts.Partners.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  ls_url: "/contacts/PartnersByCountry",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.PartnersByCountry.detail;
    this.ls_insert_handler = Lino.contacts.PartnersByCountry.insert;
    Lino.contacts.PartnersByCountry.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.PartnersByCountry.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.PartnersByCountry.detailPanel(p);
});
Lino.contacts.PartnersByCountry.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/PartnersByCountry", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.PartnersByCountry.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.PartnersByCountry.GridPanel(p);
});
Lino.contacts.PartnersByCountry.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/PartnersByCountry", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class contacts.RolesByCompany
Lino.contacts.RolesByCompany.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/RolesByCompany",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/contacts/RolesByCompany','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/contacts/RolesByCompany','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Kontaktpersonen",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "name": "person" }, 'personHidden', { "name": "type" }, 'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 13,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var person459 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/RolesByCompany/person", "method": "GET" }) }), "emptyText": "Person ausw\u00e4hlen..." });
    var type460 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/RolesByCompany/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Funktion ausw\u00e4hlen..." });
    var id461 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Person", "editable": true, "tooltip": "(contacts.RolesByCompany.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('personHidden','Lino.contacts.Persons.detail'), "dataIndex": "person", "editor": person459 }, { "colIndex": 1, "sortable": true, "header": "Funktion", "editable": true, "tooltip": "(contacts.RolesByCompany.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": type460, "dataIndex": "type" }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.RolesByCompany.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id461, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.RolesByCompany.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.RolesByCompany.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/RolesByCompany", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.RolesByCompany.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/RolesByCompany", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.RolesByCompany.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/RolesByCompany", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.RolesByCompany.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/RolesByCompany", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.RolesByCompany.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/RolesByCompany", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.RolesByCompany.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/RolesByCompany", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.RolesByCompany.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.RolesByCompany.GridPanel(p);
});

// js_render_GridPanel_class contacts.RolesByPerson
Lino.contacts.RolesByPerson.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contacts/RolesByPerson",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/contacts/RolesByPerson','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/contacts/RolesByPerson','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Kontaktperson f\u00fcr",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "name": "company" }, 'companyHidden', { "name": "type" }, 'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 13,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var company391 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/RolesByPerson/company", "method": "GET" }) }), "emptyText": "Organisation ausw\u00e4hlen..." });
    var type392 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/RolesByPerson/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Funktion ausw\u00e4hlen..." });
    var id393 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Organisation", "editable": true, "tooltip": "(contacts.RolesByPerson.company) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('companyHidden','Lino.contacts.Companies.detail'), "dataIndex": "company", "editor": company391 }, { "colIndex": 1, "sortable": true, "header": "Funktion", "editable": true, "tooltip": "(contacts.RolesByPerson.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": type392, "dataIndex": "type" }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.RolesByPerson.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id393, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.RolesByPerson.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.RolesByPerson.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/RolesByPerson", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.RolesByPerson.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/RolesByPerson", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.RolesByPerson.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/RolesByPerson", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.RolesByPerson.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/RolesByPerson", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.RolesByPerson.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/RolesByPerson", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.RolesByPerson.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/RolesByPerson", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.RolesByPerson.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.RolesByPerson.GridPanel(p);
});

// js_render_GridPanel_class cal.SubscriptionsByUser
Lino.cal.SubscriptionsByUser.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/SubscriptionsByUser",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/SubscriptionsByUser','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/SubscriptionsByUser','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Abonnements",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 5,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "calendar" }, 'calendarHidden', { "type": "boolean", "name": "is_hidden" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 26,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id1284 = new Ext.form.NumberField({ "selectOnFocus": true });
    var calendar1285 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/SubscriptionsByUser/calendar", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Kalender ausw\u00e4hlen..." });
    var is_hidden1286 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.SubscriptionsByUser.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1284, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Kalender", "editable": true, "tooltip": "(cal.SubscriptionsByUser.calendar) The calendar you want to subscribe to.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.Calendars.detail'), "dataIndex": "calendar", "editor": calendar1285 }, { "colIndex": 2, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.SubscriptionsByUser.is_hidden) Whether this subscription should \"\n        \"initially be displayed as a hidden calendar.", "filter": { "type": "boolean" }, "header": "versteckt", "dataIndex": "is_hidden" } ];
    Lino.cal.SubscriptionsByUser.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.SubscriptionsByUser.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/SubscriptionsByUser", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.SubscriptionsByUser.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/SubscriptionsByUser", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.SubscriptionsByUser.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/SubscriptionsByUser", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.SubscriptionsByUser.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/SubscriptionsByUser", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.SubscriptionsByUser.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/SubscriptionsByUser", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.SubscriptionsByUser.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/SubscriptionsByUser", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.SubscriptionsByUser.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.SubscriptionsByUser.GridPanel(p);
});

// js_render_GridPanel_class cal.SubscriptionsByCalendar
Lino.cal.SubscriptionsByCalendar.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/SubscriptionsByCalendar",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/SubscriptionsByCalendar','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/SubscriptionsByCalendar','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Abonnements",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 5,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "type": "boolean", "name": "is_hidden" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 26,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id652 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user653 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/SubscriptionsByCalendar/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var is_hidden654 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.SubscriptionsByCalendar.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id652, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Autor", "editable": true, "tooltip": "(cal.SubscriptionsByCalendar.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "dataIndex": "user", "editor": user653 }, { "colIndex": 2, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.SubscriptionsByCalendar.is_hidden) Whether this subscription should \"\n        \"initially be displayed as a hidden calendar.", "filter": { "type": "boolean" }, "header": "versteckt", "dataIndex": "is_hidden" } ];
    Lino.cal.SubscriptionsByCalendar.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.SubscriptionsByCalendar.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/SubscriptionsByCalendar", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.SubscriptionsByCalendar.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/SubscriptionsByCalendar", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.SubscriptionsByCalendar.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/SubscriptionsByCalendar", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.SubscriptionsByCalendar.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/SubscriptionsByCalendar", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.SubscriptionsByCalendar.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/SubscriptionsByCalendar", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.SubscriptionsByCalendar.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/SubscriptionsByCalendar", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.SubscriptionsByCalendar.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.SubscriptionsByCalendar.GridPanel(p);
});

// js_render_GridPanel_class cal.TasksByUser
Lino.cal.TasksByUser.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/TasksByUser",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/TasksByUser','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/TasksByUser','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Aufgaben",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 22,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "modified" }, { "name": "created" }, { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "name": "start_time" }, { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "date", "name": "due_date", "dateFormat": "d.m.Y" }, { "name": "due_time" }, { "type": "int", "name": "percent" }, { "name": "state" }, 'stateHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 16,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.TasksByUser.detail;
    this.ls_insert_handler = Lino.cal.TasksByUser.insert;
    var ww = this.containing_window;
    var start_date1288 = new Lino.DateField({ "selectOnFocus": true });
    var summary1289 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp1290 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id1291 = new Ext.form.NumberField({ "selectOnFocus": true });
    var modified1292 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created1293 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var owner_type1294 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/TasksByUser/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Datenbankmodell ausw\u00e4hlen..." });
    var owner_id1295 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/TasksByUser/owner_id", "method": "GET" }) }) });
    var start_time1296 = new Lino.TimeField({ "selectOnFocus": true });
    var access_class1297 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var sequence1298 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type1299 = new Ext.form.NumberField({ "disabled": true });
    var due_date1300 = new Lino.DateField({ "selectOnFocus": true });
    var due_time1301 = new Lino.TimeField({ "selectOnFocus": true });
    var percent1302 = new Ext.form.NumberField({ "selectOnFocus": true });
    var state1303 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.TaskStates });
    var owner_disp1304 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.TasksByUser.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "editor": start_date1288, "width": Lino.chars2width(14), "dataIndex": "start_date" }, { "colIndex": 1, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "tooltip": "(cal.TasksByUser.summary) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": summary1289, "dataIndex": "summary" }, { "header": "Arbeitsablauf", "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "width": Lino.chars2width(31), "editable": false, "tooltip": "(cal.TasksByUser.workflow_buttons) " }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.TasksByUser.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1291, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.TasksByUser.modified) ", "header": "Bearbeitet", "dataIndex": "modified", "hidden": true }, { "colIndex": 5, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.TasksByUser.created) ", "header": "Erstellt", "dataIndex": "created", "hidden": true }, { "colIndex": 6, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.TasksByUser.owner_type) ", "filter": { "type": "string" }, "header": "Verkn\u00fcpft mit (Modell)", "renderer": Lino.fk_renderer('owner_typeHidden','Lino.contenttypes.ContentTypes.detail'), "dataIndex": "owner_type", "hidden": true, "editor": owner_type1294 }, { "colIndex": 7, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "tooltip": "(cal.TasksByUser.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": owner_id1295, "hidden": true, "dataIndex": "owner_id" }, { "colIndex": 8, "sortable": true, "header": "Beginnt um", "editable": true, "tooltip": "(cal.TasksByUser.start_time) ", "width": Lino.chars2width(9), "editor": start_time1296, "hidden": true, "dataIndex": "start_time" }, { "colIndex": 9, "sortable": true, "header": "Zugriffsklasse", "editable": true, "tooltip": "(cal.TasksByUser.access_class) Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist", "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": access_class1297, "hidden": true, "dataIndex": "access_class" }, new Lino.NullNumberColumn({ "colIndex": 10, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.TasksByUser.sequence) ", "filter": { "type": "numeric" }, "header": "Revisionsnummer", "editor": sequence1298, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "sequence" }), new Lino.NullNumberColumn({ "colIndex": 11, "sortable": true, "format": "0", "editable": false, "tooltip": "(cal.TasksByUser.auto_type) ", "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 12, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.TasksByUser.due_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Zahlungsziel", "editor": due_date1300, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "due_date" }, { "colIndex": 13, "sortable": true, "header": "F\u00e4llig um", "editable": true, "tooltip": "(cal.TasksByUser.due_time) ", "width": Lino.chars2width(9), "editor": due_time1301, "hidden": true, "dataIndex": "due_time" }, new Lino.NullNumberColumn({ "colIndex": 14, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.TasksByUser.percent) ", "filter": { "type": "numeric" }, "header": "Dauer (Anzahl)", "editor": percent1302, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "percent" }), { "colIndex": 15, "sortable": true, "header": "Zustand", "editable": true, "tooltip": "(cal.TasksByUser.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": state1303, "hidden": true, "dataIndex": "state" }, { "colIndex": 16, "sortable": false, "width": Lino.chars2width(11), "editable": false, "tooltip": "(cal.TasksByUser.owner) ", "header": "Verkn\u00fcpft mit", "dataIndex": "owner", "hidden": true } ];
    Lino.cal.TasksByUser.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.TasksByUser.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/TasksByUser", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.TasksByUser.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/TasksByUser", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.TasksByUser.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/TasksByUser", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.TasksByUser.insertPanel = Ext.extend(Lino.cal.Tasks.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  params_panel_hidden: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/cal/TasksByUser",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.TasksByUser.detail;
    this.ls_insert_handler = Lino.cal.TasksByUser.insert;
    Lino.cal.TasksByUser.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.TasksByUser.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.TasksByUser.insertPanel(p);
});
Lino.cal.TasksByUser.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/TasksByUser", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.TasksByUser.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/TasksByUser", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.TasksByUser.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/TasksByUser", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.TasksByUser.wf1 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/TasksByUser", "GET", pk, "wf1", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.TasksByUser.wf2 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/TasksByUser", "GET", pk, "wf2", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.TasksByUser.wf3 = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/TasksByUser", "GET", pk, "wf3", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.TasksByUser.detailPanel = Ext.extend(Lino.cal.Tasks.DetailFormPanel,{
  empty_title: "Detail",
  params_panel_hidden: true,
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  ls_url: "/cal/TasksByUser",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.TasksByUser.detail;
    this.ls_insert_handler = Lino.cal.TasksByUser.insert;
    Lino.cal.TasksByUser.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.TasksByUser.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.TasksByUser.detailPanel(p);
});
Lino.cal.TasksByUser.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/TasksByUser", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.TasksByUser.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Tasks.ParamsPanel({});
  return new Lino.cal.TasksByUser.GridPanel(p);
});
Lino.cal.TasksByUser.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/TasksByUser", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.GuestsByEvent
Lino.cal.GuestsByEvent.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/GuestsByEvent",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/GuestsByEvent','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/GuestsByEvent','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Teilnehmer",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "name": "partner" }, 'partnerHidden', { "name": "role" }, 'roleHidden', { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 21,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.GuestsByEvent.detail;
    this.ls_insert_handler = Lino.cal.GuestsByEvent.insert;
    var ww = this.containing_window;
    var partner571 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestsByEvent/partner", "method": "GET" }) }), "emptyText": "Partner ausw\u00e4hlen..." });
    var role572 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestsByEvent/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Gastrolle ausw\u00e4hlen..." });
    var workflow_buttons_disp573 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(cal.GuestsByEvent.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "dataIndex": "partner", "editor": partner571 }, { "colIndex": 1, "sortable": true, "header": "Rolle", "editable": true, "tooltip": "(cal.GuestsByEvent.role) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('roleHidden','Lino.cal.GuestRoles.detail'), "dataIndex": "role", "editor": role572 }, { "header": "Arbeitsablauf", "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "width": Lino.chars2width(31), "editable": false, "tooltip": "(cal.GuestsByEvent.workflow_buttons) " } ];
    Lino.cal.GuestsByEvent.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.GuestsByEvent.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestsByEvent", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.GuestsByEvent.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestsByEvent", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.GuestsByEvent.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestsByEvent", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.GuestsByEvent.insertPanel = Ext.extend(Lino.cal.Guests.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/cal/GuestsByEvent",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.GuestsByEvent.detail;
    this.ls_insert_handler = Lino.cal.GuestsByEvent.insert;
    Lino.cal.GuestsByEvent.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.GuestsByEvent.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.GuestsByEvent.insertPanel(p);
});
Lino.cal.GuestsByEvent.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestsByEvent", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.GuestsByEvent.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestsByEvent", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.GuestsByEvent.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestsByEvent", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.GuestsByEvent.detailPanel = Ext.extend(Lino.cal.Guests.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  ls_url: "/cal/GuestsByEvent",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.GuestsByEvent.detail;
    this.ls_insert_handler = Lino.cal.GuestsByEvent.insert;
    Lino.cal.GuestsByEvent.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.GuestsByEvent.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.GuestsByEvent.detailPanel(p);
});
Lino.cal.GuestsByEvent.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestsByEvent", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.GuestsByEvent.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Guests.ParamsPanel({});
  return new Lino.cal.GuestsByEvent.GridPanel(p);
});
Lino.cal.GuestsByEvent.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestsByEvent", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.GuestsByRole
Lino.cal.GuestsByRole.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/GuestsByRole",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/GuestsByRole','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/GuestsByRole','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Teilnehmer",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 12,
  ls_store_fields : [ { "name": "partner" }, 'partnerHidden', { "name": "role" }, 'roleHidden', { "name": "workflow_buttons" }, { "name": "remark" }, { "name": "event" }, 'eventHidden', { "type": "int", "name": "id" }, { "name": "state" }, 'stateHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 8,
  ls_grid_configs : [  ],
  content_type : 21,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.GuestsByRole.detail;
    this.ls_insert_handler = Lino.cal.GuestsByRole.insert;
    var ww = this.containing_window;
    var partner712 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestsByRole/partner", "method": "GET" }) }), "emptyText": "Partner ausw\u00e4hlen..." });
    var role713 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestsByRole/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Gastrolle ausw\u00e4hlen..." });
    var workflow_buttons_disp714 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var remark715 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var event716 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestsByRole/event", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Termin ausw\u00e4hlen..." });
    var id717 = new Ext.form.NumberField({ "selectOnFocus": true });
    var state718 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.GuestStates });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(cal.GuestsByRole.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "dataIndex": "partner", "editor": partner712 }, { "colIndex": 1, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.GuestsByRole.role) ", "filter": { "type": "string" }, "header": "Rolle", "renderer": Lino.fk_renderer('roleHidden','Lino.cal.GuestRoles.detail'), "dataIndex": "role", "hidden": true, "editor": role713 }, { "header": "Arbeitsablauf", "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "width": Lino.chars2width(31), "editable": false, "tooltip": "(cal.GuestsByRole.workflow_buttons) " }, { "colIndex": 3, "sortable": true, "header": "Bemerkung", "editable": true, "tooltip": "(cal.GuestsByRole.remark) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": remark715, "dataIndex": "remark" }, { "colIndex": 4, "sortable": true, "header": "Termin", "editable": true, "tooltip": "(cal.GuestsByRole.event) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('eventHidden','Lino.cal.OneEvent.detail'), "dataIndex": "event", "editor": event716 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.GuestsByRole.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id717, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Zustand", "editable": true, "tooltip": "(cal.GuestsByRole.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": state718, "hidden": true, "dataIndex": "state" } ];
    Lino.cal.GuestsByRole.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.GuestsByRole.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestsByRole", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.GuestsByRole.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestsByRole", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.GuestsByRole.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestsByRole", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.GuestsByRole.insertPanel = Ext.extend(Lino.cal.Guests.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/cal/GuestsByRole",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.GuestsByRole.detail;
    this.ls_insert_handler = Lino.cal.GuestsByRole.insert;
    Lino.cal.GuestsByRole.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.GuestsByRole.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.GuestsByRole.insertPanel(p);
});
Lino.cal.GuestsByRole.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestsByRole", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.GuestsByRole.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestsByRole", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.GuestsByRole.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestsByRole", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.GuestsByRole.detailPanel = Ext.extend(Lino.cal.Guests.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  ls_url: "/cal/GuestsByRole",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.GuestsByRole.detail;
    this.ls_insert_handler = Lino.cal.GuestsByRole.insert;
    Lino.cal.GuestsByRole.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.GuestsByRole.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.GuestsByRole.detailPanel(p);
});
Lino.cal.GuestsByRole.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestsByRole", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.GuestsByRole.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Guests.ParamsPanel({});
  return new Lino.cal.GuestsByRole.GridPanel(p);
});
Lino.cal.GuestsByRole.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestsByRole", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.GuestsByPartner
Lino.cal.GuestsByPartner.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/GuestsByPartner",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/GuestsByPartner','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/GuestsByPartner','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Anwesenheiten",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 4,
  ls_store_fields : [ { "name": "event__when_text" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 21,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.GuestsByPartner.detail;
    this.ls_insert_handler = Lino.cal.GuestsByPartner.insert;
    var ww = this.containing_window;
    var event__when_text_disp1306 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var workflow_buttons_disp1307 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "header": "Wann", "colIndex": 0, "sortable": false, "dataIndex": "event__when_text", "width": Lino.chars2width(31), "editable": false, "tooltip": "(cal.GuestsByPartner.event__when_text) " }, { "header": "Arbeitsablauf", "colIndex": 1, "sortable": false, "dataIndex": "workflow_buttons", "width": Lino.chars2width(31), "editable": false, "tooltip": "(cal.GuestsByPartner.workflow_buttons) " } ];
    Lino.cal.GuestsByPartner.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.GuestsByPartner.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestsByPartner", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.GuestsByPartner.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestsByPartner", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.GuestsByPartner.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestsByPartner", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.GuestsByPartner.insertPanel = Ext.extend(Lino.cal.Guests.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/cal/GuestsByPartner",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.GuestsByPartner.detail;
    this.ls_insert_handler = Lino.cal.GuestsByPartner.insert;
    Lino.cal.GuestsByPartner.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.GuestsByPartner.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.GuestsByPartner.insertPanel(p);
});
Lino.cal.GuestsByPartner.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestsByPartner", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.GuestsByPartner.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestsByPartner", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.GuestsByPartner.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestsByPartner", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.GuestsByPartner.detailPanel = Ext.extend(Lino.cal.Guests.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  ls_url: "/cal/GuestsByPartner",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.GuestsByPartner.detail;
    this.ls_insert_handler = Lino.cal.GuestsByPartner.insert;
    Lino.cal.GuestsByPartner.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.GuestsByPartner.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.GuestsByPartner.detailPanel(p);
});
Lino.cal.GuestsByPartner.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestsByPartner", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.GuestsByPartner.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Guests.ParamsPanel({});
  return new Lino.cal.GuestsByPartner.GridPanel(p);
});
Lino.cal.GuestsByPartner.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/GuestsByPartner", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.EventsByType
Lino.cal.EventsByType.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/EventsByType",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/EventsByType','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/EventsByType','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Vorlage bearbeiten", "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Vorlage bearbeiten", "overflowText": "Vorlage bearbeiten", "auto_save": true }, { "itemId": "show_today", "menu_item_text": "Heute", "tooltip": "Show all calendar events of the same day.", "panel_btn_handler": Lino.row_action_handler('show_today','GET',null), "iconCls": "x-tbar-calendar", "overflowText": "Heute", "auto_save": true }, { "itemId": "do_update_guests", "menu_item_text": "Update Guests", "tooltip": "Update Guests", "panel_btn_handler": Lino.row_action_handler('do_update_guests','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Guests", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET',null), "iconCls": "x-tbar-script_add", "overflowText": "per Post", "auto_save": true }, { "itemId": "take", "menu_item_text": "Annehmen", "tooltip": "Verantwortung f\u00fcr diesen Termin \u00fcbernehmen.", "panel_btn_handler": Lino.row_action_handler('take','GET',null), "iconCls": "x-tbar-flag_green", "overflowText": "Annehmen", "auto_save": true }, { "itemId": "move_next", "menu_item_text": "Nach unten", "tooltip": "Nach unten", "panel_btn_handler": Lino.row_action_handler('move_next','GET',null), "iconCls": "x-tbar-date_next", "overflowText": "Nach unten", "auto_save": true } ],
  cell_edit : true,
  title : "Termine",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 35,
  ls_store_fields : [ { "name": "when_text" }, { "name": "user" }, 'userHidden', { "name": "summary" }, { "name": "event_type" }, 'event_typeHidden', { "type": "int", "name": "id" }, { "name": "modified" }, { "name": "created" }, { "name": "build_time" }, { "name": "build_method" }, 'build_methodHidden', { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "room" }, 'roomHidden', { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 25,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsByType.detail;
    this.ls_insert_handler = Lino.cal.EventsByType.insert;
    var ww = this.containing_window;
    var when_text_disp746 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var user747 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByType/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var summary748 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var event_type749 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByType/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ereignisart ausw\u00e4hlen..." });
    var id750 = new Ext.form.NumberField({ "selectOnFocus": true });
    var modified751 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created752 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_time753 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_method754 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.lino.BuildMethods });
    var owner_type755 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByType/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Datenbankmodell ausw\u00e4hlen..." });
    var owner_id756 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByType/owner_id", "method": "GET" }) }) });
    var start_date757 = new Lino.DateField({ "selectOnFocus": true });
    var start_time758 = new Lino.TimeField({ "selectOnFocus": true });
    var end_date759 = new Lino.DateField({ "selectOnFocus": true });
    var end_time760 = new Lino.TimeField({ "selectOnFocus": true });
    var access_class761 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var sequence762 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type763 = new Ext.form.NumberField({ "disabled": true });
    var transparent764 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var room765 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByType/room", "method": "GET" }) }), "pageSize": 20, "emptyText": "Raum ausw\u00e4hlen..." });
    var priority766 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByType/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Priorit\u00e4t ausw\u00e4hlen..." });
    var state767 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var assigned_to768 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByType/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var owner_disp769 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "header": "Wann", "colIndex": 0, "sortable": false, "dataIndex": "when_text", "width": Lino.chars2width(21), "editable": false, "tooltip": "(cal.EventsByType.when_text) " }, { "colIndex": 1, "sortable": true, "header": "Verantwortlicher", "editable": true, "tooltip": "(cal.EventsByType.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "dataIndex": "user", "editor": user747 }, { "colIndex": 2, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "tooltip": "(cal.EventsByType.summary) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": summary748, "dataIndex": "summary" }, { "colIndex": 3, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.EventsByType.event_type) ", "filter": { "type": "string" }, "header": "Ereignisart", "renderer": Lino.fk_renderer('event_typeHidden','Lino.cal.EventTypes.detail'), "dataIndex": "event_type", "hidden": true, "editor": event_type749 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.EventsByType.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id750, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.EventsByType.modified) ", "header": "Bearbeitet", "dataIndex": "modified", "hidden": true }, { "colIndex": 6, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.EventsByType.created) ", "header": "Erstellt", "dataIndex": "created", "hidden": true }, { "colIndex": 7, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.EventsByType.build_time) ", "header": "Druckdatum", "dataIndex": "build_time", "hidden": true }, { "colIndex": 8, "sortable": true, "header": "Konstruktionsmethode", "editable": true, "tooltip": "(cal.EventsByType.build_method) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": build_method754, "hidden": true, "dataIndex": "build_method" }, { "colIndex": 9, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.EventsByType.owner_type) ", "filter": { "type": "string" }, "header": "Verkn\u00fcpft mit (Modell)", "renderer": Lino.fk_renderer('owner_typeHidden','Lino.contenttypes.ContentTypes.detail'), "dataIndex": "owner_type", "hidden": true, "editor": owner_type755 }, { "colIndex": 10, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "tooltip": "(cal.EventsByType.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": owner_id756, "hidden": true, "dataIndex": "owner_id" }, { "colIndex": 11, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.EventsByType.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "editor": start_date757, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "start_date" }, { "colIndex": 12, "sortable": true, "header": "Beginnt um", "editable": true, "tooltip": "(cal.EventsByType.start_time) ", "width": Lino.chars2width(9), "editor": start_time758, "hidden": true, "dataIndex": "start_time" }, { "colIndex": 13, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.EventsByType.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Endet am", "editor": end_date759, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "end_date" }, { "colIndex": 14, "sortable": true, "header": "Endet um", "editable": true, "tooltip": "(cal.EventsByType.end_time) ", "width": Lino.chars2width(9), "editor": end_time760, "hidden": true, "dataIndex": "end_time" }, { "colIndex": 15, "sortable": true, "header": "Zugriffsklasse", "editable": true, "tooltip": "(cal.EventsByType.access_class) Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist", "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": access_class761, "hidden": true, "dataIndex": "access_class" }, new Lino.NullNumberColumn({ "colIndex": 16, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.EventsByType.sequence) ", "filter": { "type": "numeric" }, "header": "Revisionsnummer", "editor": sequence762, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "sequence" }), new Lino.NullNumberColumn({ "colIndex": 17, "sortable": true, "format": "0", "editable": false, "tooltip": "(cal.EventsByType.auto_type) ", "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 18, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.EventsByType.transparent) Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.", "filter": { "type": "boolean" }, "header": "nicht blockierend", "dataIndex": "transparent", "hidden": true }, { "colIndex": 19, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.EventsByType.room) ", "filter": { "type": "string" }, "header": "Raum", "renderer": Lino.fk_renderer('roomHidden','Lino.cal.Rooms.detail'), "dataIndex": "room", "hidden": true, "editor": room765 }, { "colIndex": 20, "sortable": true, "header": "Priorit\u00e4t", "editable": true, "tooltip": "(cal.EventsByType.priority) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": priority766, "hidden": true, "dataIndex": "priority" }, { "colIndex": 21, "sortable": true, "header": "Zustand", "editable": true, "tooltip": "(cal.EventsByType.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(14), "editor": state767, "hidden": true, "dataIndex": "state" }, { "colIndex": 22, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.EventsByType.assigned_to) ", "filter": { "type": "string" }, "header": "Zugewiesen zu", "renderer": Lino.fk_renderer('assigned_toHidden','Lino.users.Users.detail'), "dataIndex": "assigned_to", "hidden": true, "editor": assigned_to768 }, { "colIndex": 23, "sortable": false, "width": Lino.chars2width(11), "editable": false, "tooltip": "(cal.EventsByType.owner) ", "header": "Verkn\u00fcpft mit", "dataIndex": "owner", "hidden": true } ];
    Lino.cal.EventsByType.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsByType.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByType", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByType.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByType", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByType.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByType", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.EventsByType.insertPanel = Ext.extend(Lino.cal.Events.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  params_panel_hidden: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/cal/EventsByType",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsByType.detail;
    this.ls_insert_handler = Lino.cal.EventsByType.insert;
    Lino.cal.EventsByType.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsByType.insert = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.EventsByType.insertPanel(p);
});
Lino.cal.EventsByType.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByType", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByType.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByType", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByType.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByType", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByType.duplicate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByType", "GET", pk, "duplicate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.EventsByType.detailPanel = Ext.extend(Lino.cal.Events.DetailFormPanel,{
  empty_title: "Detail",
  params_panel_hidden: true,
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Vorlage bearbeiten", "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Vorlage bearbeiten", "overflowText": "Vorlage bearbeiten", "auto_save": true }, { "itemId": "show_today", "menu_item_text": "Heute", "tooltip": "Show all calendar events of the same day.", "panel_btn_handler": Lino.row_action_handler('show_today','GET',null), "iconCls": "x-tbar-calendar", "overflowText": "Heute", "auto_save": true }, { "itemId": "do_update_guests", "menu_item_text": "Update Guests", "tooltip": "Update Guests", "panel_btn_handler": Lino.row_action_handler('do_update_guests','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Guests", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET',null), "iconCls": "x-tbar-script_add", "overflowText": "per Post", "auto_save": true }, { "itemId": "take", "menu_item_text": "Annehmen", "tooltip": "Verantwortung f\u00fcr diesen Termin \u00fcbernehmen.", "panel_btn_handler": Lino.row_action_handler('take','GET',null), "iconCls": "x-tbar-flag_green", "overflowText": "Annehmen", "auto_save": true }, { "itemId": "move_next", "menu_item_text": "Nach unten", "tooltip": "Nach unten", "panel_btn_handler": Lino.row_action_handler('move_next','GET',null), "iconCls": "x-tbar-date_next", "overflowText": "Nach unten", "auto_save": true } ],
  ls_url: "/cal/EventsByType",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsByType.detail;
    this.ls_insert_handler = Lino.cal.EventsByType.insert;
    Lino.cal.EventsByType.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsByType.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.EventsByType.detailPanel(p);
});
Lino.cal.EventsByType.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByType", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByType.do_print = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByType", "POST", pk, "do_print", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByType.do_clear_cache = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByType", "GET", pk, "do_clear_cache", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByType.edit_template = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByType", "GET", pk, "edit_template", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByType.show_today = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByType", "GET", pk, "show_today", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByType.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Events.ParamsPanel({});
  return new Lino.cal.EventsByType.GridPanel(p);
});
Lino.cal.EventsByType.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByType", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByType.do_update_guests = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByType", "GET", pk, "do_update_guests", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByType.create_postings = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByType", "GET", pk, "create_postings", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByType.take = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByType", "GET", pk, "take", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByType.move_next = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByType", "GET", pk, "move_next", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.EventsByRoom
Lino.cal.EventsByRoom.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/EventsByRoom",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/EventsByRoom','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/EventsByRoom','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Drucken", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Vorlage bearbeiten", "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Vorlage bearbeiten", "overflowText": "Vorlage bearbeiten", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "show_today", "menu_item_text": "Heute", "tooltip": "Show all calendar events of the same day.", "panel_btn_handler": Lino.row_action_handler('show_today','GET',null), "iconCls": "x-tbar-calendar", "overflowText": "Heute", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET',null), "iconCls": "x-tbar-script_add", "overflowText": "per Post", "auto_save": true }, { "itemId": "do_update_guests", "menu_item_text": "Update Guests", "tooltip": "Update Guests", "panel_btn_handler": Lino.row_action_handler('do_update_guests','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Guests", "auto_save": true }, { "itemId": "move_next", "menu_item_text": "Nach unten", "tooltip": "Nach unten", "panel_btn_handler": Lino.row_action_handler('move_next','GET',null), "iconCls": "x-tbar-date_next", "overflowText": "Nach unten", "auto_save": true }, { "itemId": "take", "menu_item_text": "Annehmen", "tooltip": "Verantwortung f\u00fcr diesen Termin \u00fcbernehmen.", "panel_btn_handler": Lino.row_action_handler('take','GET',null), "iconCls": "x-tbar-flag_green", "overflowText": "Annehmen", "auto_save": true } ],
  cell_edit : true,
  title : "Termine",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 33,
  ls_store_fields : [ { "name": "when_text" }, { "name": "user" }, 'userHidden', { "name": "summary" }, { "name": "event_type" }, 'event_typeHidden', { "type": "int", "name": "id" }, { "name": "modified" }, { "name": "created" }, { "name": "build_time" }, { "name": "build_method" }, 'build_methodHidden', { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 25,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsByRoom.detail;
    this.ls_insert_handler = Lino.cal.EventsByRoom.insert;
    var ww = this.containing_window;
    var when_text_disp487 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var user488 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByRoom/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var summary489 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var event_type490 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByRoom/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ereignisart ausw\u00e4hlen..." });
    var id491 = new Ext.form.NumberField({ "selectOnFocus": true });
    var modified492 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created493 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_time494 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_method495 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.lino.BuildMethods });
    var owner_type496 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByRoom/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Datenbankmodell ausw\u00e4hlen..." });
    var owner_id497 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByRoom/owner_id", "method": "GET" }) }) });
    var start_date498 = new Lino.DateField({ "selectOnFocus": true });
    var start_time499 = new Lino.TimeField({ "selectOnFocus": true });
    var end_date500 = new Lino.DateField({ "selectOnFocus": true });
    var end_time501 = new Lino.TimeField({ "selectOnFocus": true });
    var access_class502 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var sequence503 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type504 = new Ext.form.NumberField({ "disabled": true });
    var transparent505 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var priority506 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByRoom/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Priorit\u00e4t ausw\u00e4hlen..." });
    var state507 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var assigned_to508 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByRoom/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var owner_disp509 = new Ext.form.DisplayField({ "disabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "header": "Wann", "colIndex": 0, "sortable": false, "dataIndex": "when_text", "width": Lino.chars2width(21), "editable": false, "tooltip": "(cal.EventsByRoom.when_text) " }, { "colIndex": 1, "sortable": true, "header": "Verantwortlicher", "editable": true, "tooltip": "(cal.EventsByRoom.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "dataIndex": "user", "editor": user488 }, { "colIndex": 2, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "tooltip": "(cal.EventsByRoom.summary) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": summary489, "dataIndex": "summary" }, { "colIndex": 3, "sortable": true, "header": "Ereignisart", "editable": true, "tooltip": "(cal.EventsByRoom.event_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('event_typeHidden','Lino.cal.EventTypes.detail'), "dataIndex": "event_type", "editor": event_type490 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.EventsByRoom.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id491, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.EventsByRoom.modified) ", "header": "Bearbeitet", "dataIndex": "modified", "hidden": true }, { "colIndex": 6, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.EventsByRoom.created) ", "header": "Erstellt", "dataIndex": "created", "hidden": true }, { "colIndex": 7, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.EventsByRoom.build_time) ", "header": "Druckdatum", "dataIndex": "build_time", "hidden": true }, { "colIndex": 8, "sortable": true, "header": "Konstruktionsmethode", "editable": true, "tooltip": "(cal.EventsByRoom.build_method) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": build_method495, "hidden": true, "dataIndex": "build_method" }, { "colIndex": 9, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.EventsByRoom.owner_type) ", "filter": { "type": "string" }, "header": "Verkn\u00fcpft mit (Modell)", "renderer": Lino.fk_renderer('owner_typeHidden','Lino.contenttypes.ContentTypes.detail'), "dataIndex": "owner_type", "hidden": true, "editor": owner_type496 }, { "colIndex": 10, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "tooltip": "(cal.EventsByRoom.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": owner_id497, "hidden": true, "dataIndex": "owner_id" }, { "colIndex": 11, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.EventsByRoom.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "editor": start_date498, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "start_date" }, { "colIndex": 12, "sortable": true, "header": "Beginnt um", "editable": true, "tooltip": "(cal.EventsByRoom.start_time) ", "width": Lino.chars2width(9), "editor": start_time499, "hidden": true, "dataIndex": "start_time" }, { "colIndex": 13, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.EventsByRoom.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Endet am", "editor": end_date500, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "end_date" }, { "colIndex": 14, "sortable": true, "header": "Endet um", "editable": true, "tooltip": "(cal.EventsByRoom.end_time) ", "width": Lino.chars2width(9), "editor": end_time501, "hidden": true, "dataIndex": "end_time" }, { "colIndex": 15, "sortable": true, "header": "Zugriffsklasse", "editable": true, "tooltip": "(cal.EventsByRoom.access_class) Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist", "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": access_class502, "hidden": true, "dataIndex": "access_class" }, new Lino.NullNumberColumn({ "colIndex": 16, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.EventsByRoom.sequence) ", "filter": { "type": "numeric" }, "header": "Revisionsnummer", "editor": sequence503, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "sequence" }), new Lino.NullNumberColumn({ "colIndex": 17, "sortable": true, "format": "0", "editable": false, "tooltip": "(cal.EventsByRoom.auto_type) ", "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 18, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.EventsByRoom.transparent) Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.", "filter": { "type": "boolean" }, "header": "nicht blockierend", "dataIndex": "transparent", "hidden": true }, { "colIndex": 19, "sortable": true, "header": "Priorit\u00e4t", "editable": true, "tooltip": "(cal.EventsByRoom.priority) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": priority506, "hidden": true, "dataIndex": "priority" }, { "colIndex": 20, "sortable": true, "header": "Zustand", "editable": true, "tooltip": "(cal.EventsByRoom.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(14), "editor": state507, "hidden": true, "dataIndex": "state" }, { "colIndex": 21, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.EventsByRoom.assigned_to) ", "filter": { "type": "string" }, "header": "Zugewiesen zu", "renderer": Lino.fk_renderer('assigned_toHidden','Lino.users.Users.detail'), "dataIndex": "assigned_to", "hidden": true, "editor": assigned_to508 }, { "colIndex": 22, "sortable": false, "width": Lino.chars2width(11), "editable": false, "tooltip": "(cal.EventsByRoom.owner) ", "header": "Verkn\u00fcpft mit", "dataIndex": "owner", "hidden": true } ];
    Lino.cal.EventsByRoom.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsByRoom.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByRoom", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByRoom.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByRoom", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByRoom.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByRoom", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.EventsByRoom.insertPanel = Ext.extend(Lino.cal.Events.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  params_panel_hidden: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/cal/EventsByRoom",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsByRoom.detail;
    this.ls_insert_handler = Lino.cal.EventsByRoom.insert;
    Lino.cal.EventsByRoom.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsByRoom.insert = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.EventsByRoom.insertPanel(p);
});
Lino.cal.EventsByRoom.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByRoom", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByRoom.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByRoom", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByRoom.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByRoom", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByRoom.duplicate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByRoom", "GET", pk, "duplicate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.EventsByRoom.detailPanel = Ext.extend(Lino.cal.Events.DetailFormPanel,{
  empty_title: "Detail",
  params_panel_hidden: true,
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Drucken", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Vorlage bearbeiten", "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Vorlage bearbeiten", "overflowText": "Vorlage bearbeiten", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "show_today", "menu_item_text": "Heute", "tooltip": "Show all calendar events of the same day.", "panel_btn_handler": Lino.row_action_handler('show_today','GET',null), "iconCls": "x-tbar-calendar", "overflowText": "Heute", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET',null), "iconCls": "x-tbar-script_add", "overflowText": "per Post", "auto_save": true }, { "itemId": "do_update_guests", "menu_item_text": "Update Guests", "tooltip": "Update Guests", "panel_btn_handler": Lino.row_action_handler('do_update_guests','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Guests", "auto_save": true }, { "itemId": "move_next", "menu_item_text": "Nach unten", "tooltip": "Nach unten", "panel_btn_handler": Lino.row_action_handler('move_next','GET',null), "iconCls": "x-tbar-date_next", "overflowText": "Nach unten", "auto_save": true }, { "itemId": "take", "menu_item_text": "Annehmen", "tooltip": "Verantwortung f\u00fcr diesen Termin \u00fcbernehmen.", "panel_btn_handler": Lino.row_action_handler('take','GET',null), "iconCls": "x-tbar-flag_green", "overflowText": "Annehmen", "auto_save": true } ],
  ls_url: "/cal/EventsByRoom",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsByRoom.detail;
    this.ls_insert_handler = Lino.cal.EventsByRoom.insert;
    Lino.cal.EventsByRoom.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsByRoom.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.EventsByRoom.detailPanel(p);
});
Lino.cal.EventsByRoom.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByRoom", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByRoom.do_print = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByRoom", "POST", pk, "do_print", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByRoom.edit_template = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByRoom", "GET", pk, "edit_template", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByRoom.do_clear_cache = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByRoom", "GET", pk, "do_clear_cache", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByRoom.show_today = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByRoom", "GET", pk, "show_today", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByRoom.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Events.ParamsPanel({});
  return new Lino.cal.EventsByRoom.GridPanel(p);
});
Lino.cal.EventsByRoom.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByRoom", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByRoom.create_postings = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByRoom", "GET", pk, "create_postings", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByRoom.do_update_guests = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByRoom", "GET", pk, "do_update_guests", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByRoom.move_next = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByRoom", "GET", pk, "move_next", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByRoom.take = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByRoom", "GET", pk, "take", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class contenttypes.HelpTextsByModel
Lino.contenttypes.HelpTextsByModel.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/contenttypes/HelpTextsByModel",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/contenttypes/HelpTextsByModel','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/contenttypes/HelpTextsByModel','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Hilfetexte",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "name": "field" }, { "name": "verbose_name" }, { "name": "help_text" }, { "type": "int", "name": "id" }, { "name": "content_type" }, 'content_typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 2,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var field167 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contenttypes/HelpTextsByModel/field", "method": "GET" }) }) });
    var verbose_name168 = new Ext.form.TextField({ "disabled": true, "maxLength": 200 });
    var help_text169 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var id170 = new Ext.form.NumberField({ "selectOnFocus": true });
    var content_type171 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contenttypes/HelpTextsByModel/content_type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Datenbankmodell ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
      var bp = this.get_base_params();
      field167.setContextValue('mk',bp['mk']);
      field167.setContextValue('mt',bp['mt']);
    };
    this.onRender = function(ct, position) {
      content_type171.on('change',Lino.chooser_handler(field167,'content_type'));
      Lino.contenttypes.HelpTextsByModel.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Feld", "editable": true, "tooltip": "(contenttypes.HelpTextsByModel.field) The name of the field.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": field167, "dataIndex": "field" }, { "header": "Feldbezeichnung", "colIndex": 1, "sortable": false, "dataIndex": "verbose_name", "width": Lino.chars2width(22), "editable": false, "tooltip": "(contenttypes.HelpTextsByModel.verbose_name) " }, { "colIndex": 2, "sortable": false, "header": "Hilfetext", "editable": true, "tooltip": "(contenttypes.HelpTextsByModel.help_text) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "editor": help_text169, "dataIndex": "help_text" }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(contenttypes.HelpTextsByModel.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id170, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contenttypes.HelpTextsByModel.content_type) ", "filter": { "type": "string" }, "header": "Modell", "renderer": Lino.fk_renderer('content_typeHidden','Lino.contenttypes.ContentTypes.detail'), "dataIndex": "content_type", "hidden": true, "editor": content_type171 } ];
    Lino.contenttypes.HelpTextsByModel.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contenttypes.HelpTextsByModel.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/HelpTextsByModel", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.HelpTextsByModel.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/HelpTextsByModel", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.HelpTextsByModel.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/HelpTextsByModel", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.HelpTextsByModel.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/HelpTextsByModel", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.HelpTextsByModel.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/HelpTextsByModel", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.HelpTextsByModel.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/HelpTextsByModel", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.HelpTextsByModel.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contenttypes.HelpTextsByModel.GridPanel(p);
});

// js_render_GridPanel_class cal.EventsByController
Lino.cal.EventsByController.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/EventsByController",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/EventsByController','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/EventsByController','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Vorlage bearbeiten", "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Vorlage bearbeiten", "overflowText": "Vorlage bearbeiten", "auto_save": true }, { "itemId": "show_today", "menu_item_text": "Heute", "tooltip": "Show all calendar events of the same day.", "panel_btn_handler": Lino.row_action_handler('show_today','GET',null), "iconCls": "x-tbar-calendar", "overflowText": "Heute", "auto_save": true }, { "itemId": "do_update_guests", "menu_item_text": "Update Guests", "tooltip": "Update Guests", "panel_btn_handler": Lino.row_action_handler('do_update_guests','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Guests", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET',null), "iconCls": "x-tbar-script_add", "overflowText": "per Post", "auto_save": true }, { "itemId": "take", "menu_item_text": "Annehmen", "tooltip": "Verantwortung f\u00fcr diesen Termin \u00fcbernehmen.", "panel_btn_handler": Lino.row_action_handler('take','GET',null), "iconCls": "x-tbar-flag_green", "overflowText": "Annehmen", "auto_save": true }, { "itemId": "move_next", "menu_item_text": "Nach unten", "tooltip": "Nach unten", "panel_btn_handler": Lino.row_action_handler('move_next','GET',null), "iconCls": "x-tbar-date_next", "overflowText": "Nach unten", "auto_save": true } ],
  cell_edit : true,
  title : "Termine",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 35,
  ls_store_fields : [ { "name": "when_text" }, { "name": "summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "modified" }, { "name": "created" }, { "name": "build_time" }, { "name": "build_method" }, 'build_methodHidden', { "name": "owner_type" }, 'owner_typeHidden', { "name": "owner_id" }, 'owner_idHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "access_class" }, 'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "name": "event_type" }, 'event_typeHidden', { "type": "boolean", "name": "transparent" }, { "name": "room" }, 'roomHidden', { "name": "priority" }, 'priorityHidden', { "name": "state" }, 'stateHidden', { "name": "assigned_to" }, 'assigned_toHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 25,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsByController.detail;
    this.ls_insert_handler = Lino.cal.EventsByController.insert;
    var ww = this.containing_window;
    var when_text_disp828 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var summary829 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp830 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id831 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user832 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByController/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    var modified833 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created834 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_time835 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var build_method836 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.lino.BuildMethods });
    var owner_type837 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByController/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Datenbankmodell ausw\u00e4hlen..." });
    var owner_id838 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByController/owner_id", "method": "GET" }) }) });
    var start_date839 = new Lino.DateField({ "selectOnFocus": true });
    var start_time840 = new Lino.TimeField({ "selectOnFocus": true });
    var end_date841 = new Lino.DateField({ "selectOnFocus": true });
    var end_time842 = new Lino.TimeField({ "selectOnFocus": true });
    var access_class843 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var sequence844 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var auto_type845 = new Ext.form.NumberField({ "disabled": true });
    var event_type846 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByController/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Ereignisart ausw\u00e4hlen..." });
    var transparent847 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var room848 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByController/room", "method": "GET" }) }), "pageSize": 20, "emptyText": "Raum ausw\u00e4hlen..." });
    var priority849 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByController/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Priorit\u00e4t ausw\u00e4hlen..." });
    var state850 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.EventStates });
    var assigned_to851 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByController/assigned_to", "method": "GET" }) }), "pageSize": 20, "emptyText": "Benutzer ausw\u00e4hlen..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "header": "Wann", "colIndex": 0, "sortable": false, "dataIndex": "when_text", "width": Lino.chars2width(31), "editable": false, "tooltip": "(cal.EventsByController.when_text) " }, { "colIndex": 1, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "tooltip": "(cal.EventsByController.summary) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": summary829, "dataIndex": "summary" }, { "header": "Arbeitsablauf", "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "width": Lino.chars2width(31), "editable": false, "tooltip": "(cal.EventsByController.workflow_buttons) " }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.EventsByController.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id831, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.EventsByController.user) ", "filter": { "type": "string" }, "header": "Verantwortlicher", "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "dataIndex": "user", "hidden": true, "editor": user832 }, { "colIndex": 5, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.EventsByController.modified) ", "header": "Bearbeitet", "dataIndex": "modified", "hidden": true }, { "colIndex": 6, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.EventsByController.created) ", "header": "Erstellt", "dataIndex": "created", "hidden": true }, { "colIndex": 7, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(cal.EventsByController.build_time) ", "header": "Druckdatum", "dataIndex": "build_time", "hidden": true }, { "colIndex": 8, "sortable": true, "header": "Konstruktionsmethode", "editable": true, "tooltip": "(cal.EventsByController.build_method) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": build_method836, "hidden": true, "dataIndex": "build_method" }, { "colIndex": 9, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.EventsByController.owner_type) ", "filter": { "type": "string" }, "header": "Verkn\u00fcpft mit (Modell)", "renderer": Lino.fk_renderer('owner_typeHidden','Lino.contenttypes.ContentTypes.detail'), "dataIndex": "owner_type", "hidden": true, "editor": owner_type837 }, { "colIndex": 10, "sortable": true, "header": "Verkn\u00fcpft mit (Objekt)", "editable": true, "tooltip": "(cal.EventsByController.owner_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": owner_id838, "hidden": true, "dataIndex": "owner_id" }, { "colIndex": 11, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.EventsByController.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "editor": start_date839, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "start_date" }, { "colIndex": 12, "sortable": true, "header": "Beginnt um", "editable": true, "tooltip": "(cal.EventsByController.start_time) ", "width": Lino.chars2width(9), "editor": start_time840, "hidden": true, "dataIndex": "start_time" }, { "colIndex": 13, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.EventsByController.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Endet am", "editor": end_date841, "hidden": true, "width": Lino.chars2width(14), "dataIndex": "end_date" }, { "colIndex": 14, "sortable": true, "header": "Endet um", "editable": true, "tooltip": "(cal.EventsByController.end_time) ", "width": Lino.chars2width(9), "editor": end_time842, "hidden": true, "dataIndex": "end_time" }, { "colIndex": 15, "sortable": true, "header": "Zugriffsklasse", "editable": true, "tooltip": "(cal.EventsByController.access_class) Ob dieser Termin  privat, \u00f6ffentlich oder halb \u00f6ffentlich ist", "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": access_class843, "hidden": true, "dataIndex": "access_class" }, new Lino.NullNumberColumn({ "colIndex": 16, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.EventsByController.sequence) ", "filter": { "type": "numeric" }, "header": "Revisionsnummer", "editor": sequence844, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "sequence" }), new Lino.NullNumberColumn({ "colIndex": 17, "sortable": true, "format": "0", "editable": false, "tooltip": "(cal.EventsByController.auto_type) ", "filter": { "type": "numeric" }, "header": "auto type", "dataIndex": "auto_type", "hidden": true, "width": Lino.chars2width(6) }), { "colIndex": 18, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.EventsByController.event_type) ", "filter": { "type": "string" }, "header": "Ereignisart", "renderer": Lino.fk_renderer('event_typeHidden','Lino.cal.EventTypes.detail'), "dataIndex": "event_type", "hidden": true, "editor": event_type846 }, { "colIndex": 19, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(cal.EventsByController.transparent) Dieser Termin l\u00e4sst auch andere Termine zur gleichen Zeit zu.", "filter": { "type": "boolean" }, "header": "nicht blockierend", "dataIndex": "transparent", "hidden": true }, { "colIndex": 20, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.EventsByController.room) ", "filter": { "type": "string" }, "header": "Raum", "renderer": Lino.fk_renderer('roomHidden','Lino.cal.Rooms.detail'), "dataIndex": "room", "hidden": true, "editor": room848 }, { "colIndex": 21, "sortable": true, "header": "Priorit\u00e4t", "editable": true, "tooltip": "(cal.EventsByController.priority) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": priority849, "hidden": true, "dataIndex": "priority" }, { "colIndex": 22, "sortable": true, "header": "Zustand", "editable": true, "tooltip": "(cal.EventsByController.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(14), "editor": state850, "hidden": true, "dataIndex": "state" }, { "colIndex": 23, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(cal.EventsByController.assigned_to) ", "filter": { "type": "string" }, "header": "Zugewiesen zu", "renderer": Lino.fk_renderer('assigned_toHidden','Lino.users.Users.detail'), "dataIndex": "assigned_to", "hidden": true, "editor": assigned_to851 } ];
    Lino.cal.EventsByController.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsByController.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByController", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByController.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByController", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByController.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByController", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.EventsByController.insertPanel = Ext.extend(Lino.cal.Events.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  params_panel_hidden: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/cal/EventsByController",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsByController.detail;
    this.ls_insert_handler = Lino.cal.EventsByController.insert;
    Lino.cal.EventsByController.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsByController.insert = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.EventsByController.insertPanel(p);
});
Lino.cal.EventsByController.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByController", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByController.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByController", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByController.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByController", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByController.duplicate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByController", "GET", pk, "duplicate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.EventsByController.detailPanel = Ext.extend(Lino.cal.Events.DetailFormPanel,{
  empty_title: "Detail",
  params_panel_hidden: true,
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Speichern", "tooltip": "\u00c4nderungen in diesem Formular speichern", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Speichern", "auto_save": false }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplizieren", "tooltip": "Duplizieren", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplizieren", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Drucken", "tooltip": "Drucken", "panel_btn_handler": Lino.row_action_handler('do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Drucken", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Cache l\u00f6schen", "tooltip": "Cache l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Cache l\u00f6schen", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Vorlage bearbeiten", "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Vorlage bearbeiten", "overflowText": "Vorlage bearbeiten", "auto_save": true }, { "itemId": "show_today", "menu_item_text": "Heute", "tooltip": "Show all calendar events of the same day.", "panel_btn_handler": Lino.row_action_handler('show_today','GET',null), "iconCls": "x-tbar-calendar", "overflowText": "Heute", "auto_save": true }, { "itemId": "do_update_guests", "menu_item_text": "Update Guests", "tooltip": "Update Guests", "panel_btn_handler": Lino.row_action_handler('do_update_guests','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Guests", "auto_save": true }, { "itemId": "create_postings", "menu_item_text": "per Post", "tooltip": "Create classical mail postings from this", "panel_btn_handler": Lino.row_action_handler('create_postings','GET',null), "iconCls": "x-tbar-script_add", "overflowText": "per Post", "auto_save": true }, { "itemId": "take", "menu_item_text": "Annehmen", "tooltip": "Verantwortung f\u00fcr diesen Termin \u00fcbernehmen.", "panel_btn_handler": Lino.row_action_handler('take','GET',null), "iconCls": "x-tbar-flag_green", "overflowText": "Annehmen", "auto_save": true }, { "itemId": "move_next", "menu_item_text": "Nach unten", "tooltip": "Nach unten", "panel_btn_handler": Lino.row_action_handler('move_next','GET',null), "iconCls": "x-tbar-date_next", "overflowText": "Nach unten", "auto_save": true } ],
  ls_url: "/cal/EventsByController",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsByController.detail;
    this.ls_insert_handler = Lino.cal.EventsByController.insert;
    Lino.cal.EventsByController.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsByController.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.cal.EventsByController.detailPanel(p);
});
Lino.cal.EventsByController.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByController", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByController.do_print = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByController", "POST", pk, "do_print", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByController.do_clear_cache = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByController", "GET", pk, "do_clear_cache", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByController.edit_template = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByController", "GET", pk, "edit_template", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByController.show_today = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByController", "GET", pk, "show_today", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByController.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.cal.Events.ParamsPanel({});
  return new Lino.cal.EventsByController.GridPanel(p);
});
Lino.cal.EventsByController.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByController", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByController.do_update_guests = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByController", "GET", pk, "do_update_guests", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByController.create_postings = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByController", "GET", pk, "create_postings", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByController.take = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByController", "GET", pk, "take", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.EventsByController.move_next = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/EventsByController", "GET", pk, "move_next", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class cal.TasksByController
Lino.cal.TasksByController.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "Keine Daten anzuzeigen." },
  ls_url : "/cal/TasksByController",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/cal/TasksByController','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/cal/TasksByController','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "Neu", "tooltip": "Neuen Datensatz erstellen", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "Neu", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Detail-Fenster auf diesem Datensatz \u00f6ffnen", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "L\u00f6schen", "tooltip": "Diesen Datensatz l\u00f6schen", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "L\u00f6schen", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Aufgaben",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  disabled_actions_index : 5,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 16,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.TasksByController.detail;
    this.ls_insert_handler = Lino.cal.TasksByController.insert;
    var ww = this.containing_window;
    var start_date1309 = new Lino.DateField({ "selectOnFocus": true });
    var summary1310 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp1311 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id1312 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(cal.TasksByController.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Beginnt am", "editor": start_date1309, "width": Lino.chars2width(14), "dataIndex": "start_date" }, { "colIndex": 1, "sortable": true, "header": "Kurzbeschreibung", "editable": true, "tooltip": "(cal.TasksByController.summary) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": summary1310, "dataIndex": "summary" }, { "header": "Arbeitsablauf", "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "width": Lino.chars2width(31), "editable": false, "tooltip": "(cal.TasksByController.workflow_buttons) " }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(cal.TasksByController.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id1312, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.cal.TasksByController.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.TasksByController.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/TasksByController", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.TasksByController.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/TasksByController", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.TasksByController.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/TasksByController", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.cal.TasksByController.insertPanel = Ext.extend(Lino.cal.Tasks.InsertFormPanel,{
  empty_title: "Neu",
  hide_navigator: true,
  params_panel_hidden: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Erstellen", "tooltip": "Datensatz erstellen und dann im Detail-Fenster \u00f6ffnen", "panel_btn_handler": function(panel){panel.save()}, "text": "Erstellen", "overflowText": "Erstellen", "auto_save": false } ],
  ls_url: "/cal/TasksByController",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.TasksByController.detail;
    this.ls_insert_handler = Lino.cal.TasksByController.insert;
    Lino.cal.TasksByController.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.TasksByController.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.TasksByController.insertPanel(p);
});
Lino.cal.TasksByController.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/cal/TasksByController", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.cal.TasksByController.grid_post = function(rp, pk, params) 