/*
 Copyright 2009-2014 Luc Saffre
 License: BSD (see file COPYING for details)
*/

// lino.js --- generated Tue Jan  6 04:02:50 2015 by Lino version 1.6.16.
Ext.BLANK_IMAGE_URL = '/media/extjs/resources/images/default/s.gif';
LANGUAGE_CHOICES = [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ] ];
MEDIA_URL = "/media";

// hack to add a toCamel function, inspired by
// http://jamesroberts.name/blog/2010/02/22/string-functions-for-javascript-trim-to-camel-case-to-dashed-and-to-underscore/
String.prototype.toCamel = function(){
  //~ return this.replace(/(\-[a-z])/g, function($1){return $1.toUpperCase().replace('-','');});
  //~ return this;
  return this.replace(/([A-Z])([A-Z]+)/g, function(match,p1,p2,offset,string){
      //~ console.log("20131005 got ",arguments);
      return p1 + p2.toLowerCase();});
};



/* MonthPickerPlugin: thanks to keypoint @ sencha forum
   http://www.sencha.com/forum/showthread.php?74002-3.x-Ext.ux.MonthMenu&p=356860#post356860
*/
Ext.namespace('Ext.ux'); 

Ext.ux.MonthPickerPlugin = function() { 
    var picker; 
    var oldDateDefaults; 

    this.init = function(pk) { 
        picker = pk; 
        picker.onTriggerClick = picker.onTriggerClick.createSequence(onClick); 
        picker.getValue = picker.getValue.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
        picker.beforeBlur = picker.beforeBlur.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
    }; 

    function setDefaultMonthDay() { 
        oldDateDefaults = Date.defaults.d; 
        Date.defaults.d = 1; 
        return true; 
    } 

    function restoreDefaultMonthDay(ret) { 
        Date.defaults.d = oldDateDefaults; 
        return ret; 
    } 

    function onClick(e, el, opt) { 
        var p = picker.menu.picker; 
        p.activeDate = p.activeDate.getFirstDateOfMonth(); 
        if (p.value) { 
            p.value = p.value.getFirstDateOfMonth(); 
        } 

        p.showMonthPicker(); 
         
        if (!p.disabled) { 
            p.monthPicker.stopFx(); 
            p.monthPicker.show(); 

            p.mun(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mun(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
            p.onMonthClick = p.onMonthClick.createSequence(pickerClick); 
            p.onMonthDblClick = p.onMonthDblClick.createSequence(pickerDblclick); 
            p.mon(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mon(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
        } 
    } 

    function pickerClick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.is('button.x-date-mp-cancel')) { 
            picker.menu.hide(); 
        } else if(el.is('button.x-date-mp-ok')) { 
            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 

    function pickerDblclick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.parent() 
            && (el.parent().is('td.x-date-mp-month') 
            || el.parent().is('td.x-date-mp-year'))) { 

            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 
}; 

Ext.preg('monthPickerPlugin', Ext.ux.MonthPickerPlugin);  


/**
JC Watsons solution (adapted to ExtJS 3.3.1 by LS) is elegant and simple:
`A "fix" for unchecked checkbox submission  behaviour
<http://www.sencha.com/forum/showthread.php?28449>`_

Added special handling for checkbox inputs. 
ExtJS defines disabled checkboxes `readonly`, not `disabled` as for other inputs.

*/
Ext.lib.Ajax.serializeForm = function(form) {
    //~ console.log('20120203 linolib.js serializeForm',form);
    var fElements = form.elements || (document.forms[form] || Ext.getDom(form)).elements, 
        hasSubmit = false, 
        encoder = encodeURIComponent, 
        name, 
        data = '', 
        type, 
        hasValue;

    Ext.each(fElements, function(element){
        name = element.name;
        type = element.type;

        if (!element.disabled && name && !(type == 'checkbox' && element.readonly)) {
            if (/select-(one|multiple)/i.test(type)) {
                Ext.each(element.options, function(opt){
                    if (opt.selected) {
                        hasValue = opt.hasAttribute ? opt.hasAttribute('value') : opt.getAttributeNode('value').specified;
                        data += String.format("{0}={1}&", encoder(name), encoder(hasValue ? opt.value : opt.text));
                    }
                });
            } else if (!(/file|undefined|reset|button/i.test(type))) {
                //~ if (!(/radio|checkbox/i.test(type) && !element.checked) && !(type == 'submit' && hasSubmit)) {
                if (!(type == 'submit' && hasSubmit)) {
                    if (type == 'checkbox') {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&');
                        data += encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&';
                    } else {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + encoder(element.value) + '&');
                        data += encoder(name) + '=' + encoder(element.value) + '&';
                    }
                    hasSubmit = /submit/i.test(type);
                }
            }
        //~ } else {
            //~ console.log(name,type,element.readonly);
        }
    });
    return data.substr(0, data.length - 1);
};



/*
Set a long timeout of fifteen minutes. 
See /blog/2012/0307
*/
Ext.Ajax.timeout = 15 * 60 * 1000; 

/*
 * Thanks to 
 * `huuze <http://stackoverflow.com/users/10040/huuuze>`_ for the question
 * and to 
 * `chrisv <http://stackoverflow.com/users/683808/chrisv>`_
 * for the answer on
 * http://stackoverflow.com/questions/3764589/how-do-i-include-django-1-2s-csrf-token-in-a-javascript-generated-html-form/5485616#5485616
 * 
 * */
 
Ext.Ajax.on('beforerequest', function (conn, options) {
   if (!(/^http:.*/.test(options.url) || /^https:.*/.test(options.url))) {
     if (typeof(options.headers) == "undefined") {
       options.headers = {'X-CSRFToken': Ext.util.Cookies.get('csrftoken')};
     } else {
       options.headers.extend({'X-CSRFToken': Ext.util.Cookies.get('csrftoken')});
     }                        
   }
}, this);


/*
My fix for the "Cannot set QuickTips dismissDelay to 0" bug,
see http://www.sencha.com/forum/showthread.php?183515 
*/
Ext.override(Ext.QuickTip,{
  showAt : function(xy){
        var t = this.activeTarget;
        //~ console.log("20120224 QuickTip.showAt",this.title,this.dismissDelay,t.dismissDelay);
        if(t){
            if(!this.rendered){
                this.render(Ext.getBody());
                this.activeTarget = t;
            }
            if(t.width){
                this.setWidth(t.width);
                this.body.setWidth(this.adjustBodyWidth(t.width - this.getFrameWidth()));
                this.measureWidth = false;
            } else{
                this.measureWidth = true;
            }
            this.setTitle(t.title || '');
            this.body.update(t.text);
            this.autoHide = t.autoHide;
            // bugfix by Luc 20120226
            if (t.dismissDelay != undefined) this.dismissDelay = t.dismissDelay;
            //~ this.dismissDelay = t.dismissDelay || this.dismissDelay;
            if(this.lastCls){
                this.el.removeClass(this.lastCls);
                delete this.lastCls;
            }
            if(t.cls){
                this.el.addClass(t.cls);
                this.lastCls = t.cls;
            }
            if(this.anchor){
                this.constrainPosition = false;
            }else if(t.align){ 
                xy = this.el.getAlignToXY(t.el, t.align);
                this.constrainPosition = false;
            }else{
                this.constrainPosition = true;
            }
        }
        Ext.QuickTip.superclass.showAt.call(this, xy);
    }
});

/*
Another hack. See /docs/blog/2012/0228
*/
Ext.Element.addMethods(
    function() {
        var VISIBILITY      = "visibility",
            DISPLAY         = "display",
            HIDDEN          = "hidden",
            NONE            = "none",
            XMASKED         = "x-masked",
            XMASKEDRELATIVE = "x-masked-relative",
            data            = Ext.Element.data;

        return {
            
            mask : function(msg, msgCls) {
                var me  = this,
                    dom = me.dom,
                    dh  = Ext.DomHelper,
                    EXTELMASKMSG = "ext-el-mask-msg",
                    el,
                    mask;
                // removed the following lines. See /docs/blog/2012/0228
                //~ if (!(/^body/i.test(dom.tagName) && me.getStyle('position') == 'static')) {
                    //~ console.log(20120228,dom.tagName,me);
                    //~ me.addClass(XMASKEDRELATIVE); 
                //~ }
                if (el = data(dom, 'maskMsg')) {
                    el.remove();
                }
                if (el = data(dom, 'mask')) {
                    el.remove();
                }

                mask = dh.append(dom, {cls : "ext-el-mask"}, true);
                data(dom, 'mask', mask);

                me.addClass(XMASKED);
                mask.setDisplayed(true);
                
                if (typeof msg == 'string') {
                    var mm = dh.append(dom, {cls : EXTELMASKMSG, cn:{tag:'div'}}, true);
                    data(dom, 'maskMsg', mm);
                    mm.dom.className = msgCls ? EXTELMASKMSG + " " + msgCls : EXTELMASKMSG;
                    mm.dom.firstChild.innerHTML = msg;
                    mm.setDisplayed(true);
                    mm.center(me);
                }
                
                
                if (Ext.isIE && !(Ext.isIE7 && Ext.isStrict) && me.getStyle('height') == 'auto') {
                    mask.setSize(undefined, me.getHeight());
                }
                
                return mask;
            }

            
        };
    }()
);



Ext.namespace('Lino');
    
    

//~ Lino.subst_user_field = new Ext.form.ComboBox({});
//~ Lino.subst_user = null;
Lino.insert_subst_user = function(p){
    //~ console.log('20120714 insert_subst_user',Lino.subst_user,p);
    //~ if (Lino.subst_user_field.getValue()) {
    if (p.su) return;
    if (Lino.subst_user) {
        //~ p.su = Lino.subst_user_field.getValue();
        p.su = Lino.subst_user;
    //~ } else {
        //~ delete p.su;
    }
    //~ console.log('20120714 insert_subst_user -->',Lino.subst_user,p);
}

Lino.login_window = null;

Lino.autorefresh = function() {
  if (Lino.current_window == null) {
      Lino.viewport.refresh();
      Lino.autorefresh.defer(10000);
  }
}

Lino.show_login_window = function(on_login) {
  //~ console.log('20121103 show_login_window',arguments);
  //~ var current_window = Lino.current_window;
  if (Lino.login_window == null) {
    
      function do_login() { 
            Lino.viewport.loadMask.show()
            login_panel.getForm().submit({ 
                method:'POST', 
                waitTitle:'Connecting', 
                waitMsg:'Sending data...',
                success:function(){ 
                  Lino.login_window.hide();
                  Lino.handle_home_button();
                  Lino.viewport.loadMask.hide();
                  if (typeof on_login == 'string') {
                      Lino.load_url(on_login);
                  } 
                },
                failure: function(form,action) { 
                  Lino.on_submit_failure(form, action);
                  Lino.viewport.loadMask.hide()
                }
            }); 
      };
    
      var login_button = new Ext.Button({ 
        text:"Log in",
        formBind: true,	 
        // Function that fires when user clicks the button 
        handler: do_login});
    
      var login_panel = new Ext.FormPanel({ 
        //~ inspired by http://www.sencha.com/learn/a-basic-login/
        autoHeight:true,
        labelWidth:90,
        url:'/auth', 
        frame:true, 
        defaultType:'textfield',
        monitorValid:true,
        items:[{ 
            fieldLabel:"Username", 
            id: 'username',
            name:'username', 
            autoHeight:true,
            allowBlank:false 
        },{ 
            fieldLabel:"Password", 
            name:'password', 
            inputType:'password', 
            autoHeight:true,
            allowBlank:false 
        }],        
        buttons:[ login_button ]});
        
      Lino.login_window = new Ext.Window({
          layout:'fit',
          defaultButton: 'username',
          width:300,
          title:"Log in", 
          autoHeight:true,
          modal: true,
          closeAction: "hide",
          keys: {
            key: Ext.EventObject.ENTER,
            fn: function() { do_login()}
          },
          items: [login_panel] });
  };
  Lino.login_window.show();
};

Lino.logout = function(id,name) {
    Lino.call_ajax_action(
        Lino.viewport, 'GET', 
        '/auth',
        {}, 'logout', undefined, undefined,
        function(){Lino.reload();})
}

Lino.set_subst_user = function(id, name) {
    //~ console.log(20130723,'Lino.set_subst_user',id,name,Lino.current_window,Lino.viewport);
    Lino.subst_user = id;
    if (Lino.current_window) 
        Lino.current_window.main_item.set_base_param("su",id);
    if (Lino.viewport) 
        Lino.permalink_handler(Lino.current_window)();
}



//~ Lino.select_subst_user = function(cmp,rec,value){
    //~ Lino.subst_user=value;
    //~ console.log(20120713,rec);
//~ }
    
Lino.current_window = null;
Lino.window_history = Array();
    
Lino.chars2width = function(cols) {  return cols * 9; }
Lino.rows2height = function(cols) {  return cols * 20; }



Lino.MainPanel = {
  is_home_page : false,
  setting_param_values : false,
  config_containing_window : function(wincfg) { }
  ,init_containing_window : function(win) { }
  ,is_loading : function() { 
      if (!this.rendered) return true;
      //~ return (Ext.select('.x-loading-msg').elements.length > 0);
      return true; 
    } 
  ,do_when_clean : function(auto_save,todo) { todo() }
  ,get_master_params : function() {
    var p = {}
    p['mt'] = this.content_type; 
    rec = this.get_current_record()
    if (rec) {
      if (rec.phantom) {
          p['mk'] = undefined; 
      }else{
          p['mk'] = rec.id; 
      }
    } else {
      p['mk'] = undefined;
    }
    //~ console.log('get_master_params returns',p,'using record',rec);
    return p;
  }
  ,get_permalink : function() {
    var p = Ext.apply({}, this.get_base_params());
    delete p.fmt;
    Ext.apply(p, this.get_permalink_params());
    
    if (this.toggle_params_panel_btn) {
        p.sp = this.toggle_params_panel_btn.pressed;
        //~ if (this.toggle_params_panel_btn.pressed == this.params_panel_hidden) {
          //~ p.sp = true;
        //~ }
    }
    
    //~ Lino.insert_subst_user(p);
     //~ p.fmt = 'html';
    //~ console.log('get_permalink',p,this.get_permalink_params());
    if (this.is_home_page)
        //~ var url = '';
        var url = '/';
    else 
        var url = this.get_permalink_url();
    if (p.su == null) 
        delete p.su;
    if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
    return url;
  }
  ,get_record_url : function(record_id) {
      var url = '/api' + this.ls_url
      //~ var url = this.containing_window.config.url_data; // ls_url;
      url += '/' + (record_id === undefined ? '-99999' : String(record_id));
      //~ if (record_id !== undefined) url += '/' + String(record_id);
      //~ url += '/' + String(record_id);
      return url;
  }
  ,get_permalink_url : function() {
      return '/api' + this.ls_url;
  }
  ,get_permalink_params : function() {
      //~ return {an:'grid'};
      var p = {};
      if (this.action_name)
          p.an = this.action_name;
      this.add_param_values(p,false)
      return p;
  }
  /*

  Lino.MainPanel.set_status() : the status can have the following keys:

  - field_values
  - param_values
  - base_params
  - record_id
  - active_tab
  - data_record
  - show_params_panel
  - current_page

   */
  ,set_status : function(status, requesting_panel) {}
  ,get_status : function() { return {}}
  ,refresh : function() {}
  ,get_base_params : function() {  // Lino.MainPanel
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,add_params_panel : function (tbar) {
      if (this.params_panel) {
        //~  20130923b
        //~ this.params_panel.autoHeight = true; // 20130924
        var t = this;
        var update = function() {
            var p = t.params_panel;
            //~ console.log("update", p.getSize().height,p.forceLayout,p.autoHeight);
            var w = t.get_containing_window();
            Lino.do_when_visible(w, function() {
                //~ p.doLayout(true); // doLayout(shallow, force)
                w.doLayout(true); // doLayout(shallow, force)
                //~ t.params_panel.on('afterlayout',update,t,{single:true});
            });
        };
        Lino.do_when_visible(this.params_panel, update);
        this.params_panel.on('show',update);
        this.params_panel.on('hide',update);
        //~ this.params_panel.on('bodyresize',update);
        this.params_panel.on('afterlayout',update);
        //~ this.params_panel.on('afterlayout',update,this,{single:true});
        //~ this.params_panel.on('bodyresize',update,this,{single:true});
        //~ this.params_panel.on('resize',update,this,{single:true});
        //~ this.params_panel.on('render',update,this,{single:true});
        
        // this.params_panel.on('render',
        //~ this.params_panel.on('afterlayout',update,this,{single:true,delay:200});
        //~ this.params_panel.on('bodyresize',update,this,{single:true,delay:200});
        this.toggle_params_panel_btn = new Ext.Button({ scope:this, 
          //~ text: "$_("[parameters]")", // gear
          iconCls: 'x-tbar-parameters',
          tooltip:"Show or hide the table parameters panel",
          enableToggle: true,
          //~ pressed: ! this.params_panel.hidden,
          pressed: ! this.params_panel_hidden,
          toggleHandler: function(btn,state) { 
            //~ console.log("20120210 add_params_panel",state,this.params_panel);
            if (state) {
                this.params_panel.show();
            } else {
                this.params_panel.hide();
            }
            //~ this.params_panel.on('afterlayout',update,this,{single:true});
            //~ t.get_containing_window().doLayout();
            //~ this.params_panel.on('afterlayout',function() {
                //~ console.log("20130918 afterlayout");
                //~ t.get_containing_window().doLayout(); // doLayout(shallow, force)
            //~ },this,{single:true});
          }
        }); 
        tbar = tbar.concat([this.toggle_params_panel_btn]);
        var refresh = function() {
            if (!t.setting_param_values) {
                t._force_dirty = true; 
                t.refresh();
            }
        }
        Ext.each(this.params_panel.fields,function(f) {
          //~ f.on('valid',function() {t.refresh()});
          if (f instanceof Ext.form.Checkbox) {
              f.on('check',refresh);
          } else if (f instanceof Ext.DatePicker) {
              f.on('select',refresh);
          } else if (f instanceof Ext.form.TriggerField) {
              f.on('select',refresh);
              //~ f.on('change',refresh);
              //~ f.on('valid',refresh);
          } else {
              if (! f.on) 
                  console.log("20121010 no method 'on'",f);
              else
                  f.on('change',refresh);
            }
          });
      }
      return tbar;
  }
  ,add_param_values : function (p,force_dirty) {
    if (this.params_panel) {
      /* 
      * 20120918 add param_values to the request string 
      * *only if the params_form is dirty*.
      * Otherwise Actor.default_params() would never be used.
      *
      * 20121023 But IntegClients.params_default has non-empty default values. 
      * Users must have the possibility to make them empty.
      * 
      * 20130605 : added `force_dirty` parameter because Checkbox fields don't 
      * mark their form as dirty when check is fired.
      * 
      * 20130721 : `force_dirty` not as a parameter but as 
      * `this._force_dirty` because
      * 
      * 20130915 : both _force_dirty and force_dirty parameter are needed.
      * 
      */
      if (force_dirty || this._force_dirty || this.params_panel.form.isDirty()) {
      //~ if (this._force_dirty || this.params_panel.form.isDirty()) {
        p.pv = this.get_param_values();
        //~ console.log("20130923 form is dirty (",force_dirty,this._force_dirty,this.params_panel.form.isDirty(),")");
        //~ console.log("20130923 form is dirty",p);
      }else{
        //~ console.log("20130923 form not dirty:",this.params_panel.form);
        if (this.status_param_values) 
          p.pv = Lino.fields2array(
            this.params_panel.fields,this.status_param_values);
      }
      //~ if (!this.params_panel.form.isDirty()) return;
      //~ p.pv = this.get_param_values();
      //~ console.log("20120203 add_param_values added pv",p.pv,"to",p);
    }
  },
  get_param_values : function() { // similar to get_field_values()
      return Lino.fields2array(this.params_panel.fields);
  },
  set_param_values : function(pv) {
    if (this.params_panel) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_param_values = pv;
      //~ this.params_panel.form.suspendEvents(false);
      this.setting_param_values = true;
      if (pv) { 
          this.params_panel.form.my_loadRecord(pv);
      } else { 
        this.params_panel.form.reset(); 
      }
      this.setting_param_values = false;
      this._force_dirty = false; 
      //~ this.params_panel.form.resumeEvents();
    }
  }
};




Lino.Viewport = Ext.extend(Ext.Viewport, Lino.MainPanel);
Lino.Viewport = Ext.extend(Lino.Viewport, {
  layout : "fit"
  ,is_home_page : true
  ,initComponent : function(){
    Lino.Viewport.superclass.initComponent.call(this);
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.el,{msg:"Please wait..."});
      //~ console.log("20121118 Lino.viewport.loadMask",this.loadMask);
    },this);
  }
  ,refresh : function() {
      var caller = this;
      // console.log("20140829 Lino.Viewport.refresh()");
      if (caller.loadMask) caller.loadMask.show();
      var success = function(response) {
        if (caller.loadMask) caller.loadMask.hide();
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          //~ console.log('Lino.do_action()',action.name,'result is',result);
          if (result.html) {
              var cmp = Ext.getCmp('dashboard');
              // cmp.removeAll(true);  // 20140829
              cmp.update(result.html, true);
          }
          if (result.message) {
              if (result.alert) {
                  //~ Ext.MessageBox.alert('Alert',result.alert_msg);
                  Ext.MessageBox.alert('Alert',result.message);
              } else {
                  Lino.notify(result.message);
              }
          }
          
          if (result.notify_msg) Lino.notify(result.notify_msg);
          if (result.js_code) { 
            var jsr = result.js_code(caller);
            //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
          };
        }
      };
      var action = {
        url : '/api/main_html',
        waitMsg: "Please wait...",
        failure: Lino.ajax_error_handler(caller),
        success: success,
        method: 'GET',
        params: {}
      };
      Lino.insert_subst_user(action.params);
      Ext.Ajax.request(action);
    
  }
});




Lino.open_window = function(win, st, requesting_panel) {
  // console.log("20140831 Lino.open_window()", win, win.el.getBox());
  var cw = Lino.current_window;
  if (cw) {
    // console.log("20140829 Lino.open_window() save current status",
    //             cw.main_item.get_status());
    Lino.window_history.push({
      window:cw,
      status:cw.main_item.get_status()
    });
  }
  Lino.current_window = win;
  //~ if (st.su) 
      //~ Lino.subst_user_field.setValue(st.su);
  win.main_item.set_status(st, requesting_panel);
  // win.toFront();
  win.show();
};

Lino.load_url = function(url) {
    //~ foo.bar.baz = 2; 
    //~ console.log("20121120 Lino.load_url()");
    //~ Lino.body_loadMask.show();
    Lino.viewport.loadMask.show();
    //~ location.replace(url);
    document.location = url;
}

Lino.close_window = function(status_update, norestore) {
  // norestore is used when called by handle_action_result() who 
  // will call set_status itself later
  var cw = Lino.current_window;
  var ww = Lino.window_history.pop();
  var retval = cw.main_item.requesting_panel;
  // console.log(
  //     "20140917 Lino.close_window() going to close", cw.title,
  //     "previous is", ww, 
  //     "norestore is", norestore,
  //     "retval is", retval);
  if (ww) {
    //~ if (status_update) Ext.apply(ww.status,status_update);
    if(!norestore) {
        if (status_update) status_update(ww);
        ww.window.main_item.set_status(ww.status);
    }
    Lino.current_window = ww.window;
  } else {
      Lino.current_window = null;
      // new since 20140829:
      if(!norestore) { Lino.viewport.refresh(); }
  }
  if (cw) cw.hide_really();
  return retval;
};

Lino.kill_current_window = function() {
  // console.log("20140418 Lino.kill_current_window()");
  var cw = Lino.current_window;
  Lino.current_window = null;
  if (cw) cw.hide_really();
};

Lino.reload = function() {
    // First close all windows to ensure all changes are saved
    Lino.close_all_windows();

    // Then reload current view
    var url =  "/"

    var p = {};
    Lino.insert_subst_user(p)
    if (Ext.urlEncode(p))
        url = url + "?" + Ext.urlEncode(p);

    Lino.load_url(url);
}

Lino.handle_home_button = function() {
  if (Lino.window_history.length == 0)
      Lino.reload();
  else
      Lino.close_all_windows();
}

Lino.close_all_windows = function() {
    while (Lino.window_history.length > 0) {
        Lino.close_window();
    }
}

Lino.calling_window = function() {
    if (Lino.window_history.length) 
        return Lino.window_history[Lino.window_history.length-1];
}

//~ Lino.WindowAction = function(mainItemClass,windowConfig,mainConfig,ppf) {
Lino.WindowAction = function(windowConfig,main_item_fn) {
    //~ if(!mainConfig) mainConfig = {};
    //~ mainConfig.is_main_window = true;
    this.windowConfig = windowConfig;
    this.main_item_fn = main_item_fn;
    //~ if (ppf) mainConfig.params_panel.fields = ppf;
    //~ this.mainConfig = mainConfig;
    //~ this.mainItemClass = mainItemClass;
};

Lino.WindowAction = Ext.extend(Lino.WindowAction,{
    window : null,
    //~ mainItemClass: null,
    get_window : function() {
      //~ if(mainConfig) Ext.apply(this.mainConfig,mainConfig);
      // if (this.window == null || this.window.isDestroyed)  { // 20140829
      // if (this.window == null || this.window.getBox().width == 0)  { // 20140829
      if (this.window == null)  {
      // if (true)  {
          //~ this.windowConfig.main_item = new this.mainItemClass(this.mainConfig);
          this.windowConfig.main_item = this.main_item_fn();
          this.window = new Lino.Window(this.windowConfig);
      }
      return this.window;
    },
    run : function(requesting_panel, status) {
      // console.log('20140829 window_action.run()', this)
      Lino.open_window(this.get_window(), status, requesting_panel);
    }
  
});


Lino.PanelMixin = {
  get_containing_window : function (){
      if (this.containing_window) return this.containing_window;
      return this.containing_panel.get_containing_window();
  }
  ,set_window_title : function(title) {
    //~ this.setTitle(title);
    var cw = this.get_containing_window();

    //~ if (cw) {
    //~ if (cw && cw.closable) {
    if (cw && !cw.main_item.hide_window_title) {
      //~ console.log('20111202 set_window_title(',title,') for',this.containing_window);
      //~ if (! this.containing_window.rendered) console.log("WARNING: not rendered!");
      cw.setTitle(title);
    //~ } else {
      //~ document.title = title;
    }
    //~ else console.log('20111202 not set_window_title(',title,') for',this);
  }
  
};


// Lino.status_bar = new Ext.ux.StatusBar({defaultText:'Lino version 1.6.16.'});




Lino.edit_tinymce_text = function(panel, options) {
  // `panel` is the RichTextPanel
  //~ console.log(20111220,panel);
  //~ var rec = panel.get_current_record();
  var rec = panel.containing_panel.get_current_record();
  var value = rec ? rec.data[panel.editor.name] : '';
  var saving = false;
  var todo_after_save = false;
  var discard_changes = false;
  
  
  function save() {
    //~ if (todo_after_save) {alert('tried to save again'); return; }
    if (saving) {alert('tried to save again'); return; }
    //~ var url = panel.containing_window.main_item.get_record_url(rec.id);
    var url = panel.containing_panel.get_record_url(rec.id);
    var params = Ext.apply({}, panel.containing_panel.get_base_params());
    params[panel.editor.name] = editor.getValue();
    //~ params.su = Lino.subst_user;
    //~ Lino.insert_subst_user(params);
    var a = { 
      params: params, 
      method: 'PUT',
      url: url,
      failure: function() {
          //~ if (editor.ed.getContainer()) 
          editor.ed.setProgressState(0);
          todo_after_save = false;
          saving = false;
          console.log('tinymce.save() failed. sorry.',arguments);
        },
      success: function() {
        saving = false;
        //~ if (editor.ed.getContainer()) 
        editor.ed.setProgressState(0);
        rec.data[panel.editor.name] = editor.getValue();
        if(todo_after_save) {
            var fn = todo_after_save;
            todo_after_save = false;
            fn();
        }
        //~ panel.containing_window.set_current_record(rec);
        panel.refresh();
      }
    };
    //~ if (editor.ed.getContainer()) 
    editor.ed.setProgressState(1); // Show progress
    saving = true;
    //~ console.log(a);
    Ext.Ajax.request(a);
  };
  function save_callback() {
      save();
      //~ save(function(){editor.ed.setDirty(false);})
      /* return true have the save button disabled.  
      That's not perfect because the PUT is asynchronous 
      and the response is not yet known.
      */
      return true;
  }
  //~ var actions = [
    //~ {text:"Save",handler:save}
  //~ ]; 
  //~ console.log(20110610,panel.editor.disabled);
  var settings = {};
  Ext.apply(settings,{
        readonly: panel.editor.disabled,
        //~ language: "de",
        plugins : "save,emotions,spellchecker,advhr,insertdatetime,preview,table,searchreplace,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "save,cancel,|,bold,italic,underline,|,justifyleft,justifycenter,justifyright,fontselect,fontsizeselect,formatselect,|,search,replace",
        theme_advanced_buttons2 : "cut,copy,paste,template,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,link,unlink,anchor,image,|,code,preview,|,forecolor,backcolor",
        theme_advanced_buttons3 : "insertdate,inserttime,|,spellchecker,advhr,,removeformat,|,sub,sup,|,charmap,emotions,|,tablecontrols",      
        theme_advanced_resizing : false,
        convert_urls : false,
        save_onsavecallback : save_callback,
        save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
  });
  Ext.apply(settings,options);
  var editor = new Ext.ux.TinyMCE({
      value : value,
      tinymceSettings: settings
    });
  var win = new Ext.Window({
    title: rec.title, 
    //~ bbar: actions,
    layout: 'fit',
    items: editor,
    width: 600, 
    height:500,
    minWidth: 100,
		minHeight: 100,
    modal: true,
    resizable: true,
    maximizable: true,
    //~ maximized: true,
    //~ closeAction: "close"
    closeAction: "hide"
    //~ hideMode: "offsets",
    //~ constrainHeader: true,
    //~ bodyStyle: 'padding: 10px'
  });

  //~ win.on('beforeclose',function() {
  win.on('beforehide',function() {
    if (todo_after_save) return false;
    if (discard_changes) return true;
    if (editor.isDirty()) {
        //~ var ok = false;
        //~ var allowClose = true;
        var config = {title:"Confirmation"};
        config.buttons = Ext.MessageBox.YESNOCANCEL;
        config.msg = "Save changes to text ?";
        config.modal = true;
        config.fn = function(buttonId,text,opt) {
          //~ console.log('do_when_clean',buttonId)
          if (buttonId == "yes") {
              /* we cancel this close, but save()'s onSuccess will call again.*/
              //~ allowClose = false;
              todo_after_save = function(){win.hide();}
              editor.ed.execCommand('mceSave');
              //~ editor.ed.save(function(){win.close();});
          } else if (buttonId == "no") { 
              discard_changes = true;
              win.hide()
          //~ } else if (buttonId == "cancel") { 
            //~ ok = true;
              //~ allowClose = false;
          //~ } else { 
            //~ console.log('unknwon buttonId:',buttonId);
          }
        }
        Ext.MessageBox.show(config);
        return false;
        //~ return allowClose;
    }
  });
  win.show();
}







/* 
  Originally copied from Ext JS Library 3.3.1
  Modifications by Luc Saffre : 
  - rendering of phantom records
  - fire afteredit event
  - react on dblclcik, not on single click

 */
Lino.CheckColumn = Ext.extend(Ext.grid.Column, {

    processEvent : function(name, e, grid, rowIndex, colIndex){
        //~ console.log('20110713 Lino.CheckColumn.processEvent',name)
        if (name == 'click') {
        //~ if (name == 'mousedown') {
        //~ if (name == 'dblclick') {
            return this.toggleValue(grid, rowIndex, colIndex);
        } else {
            return Ext.grid.ActionColumn.superclass.processEvent.apply(this, arguments);
        }
    },
    
    toggleValue : function (grid,rowIndex,colIndex) {
        var record = grid.store.getAt(rowIndex);
        var dataIndex = grid.colModel.getDataIndex(colIndex);
        // 20120514
        //~ if(record.data.disabled_fields && record.data.disabled_fields[dataIndex]) {
          //~ Lino.notify("This field is disabled");
          //~ return false;
        //~ }
      
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("This field is disabled.");
            //~ return false;
        //~ }
        var startValue = record.data[dataIndex];
        var value = !startValue;
        //~ record.set(this.dataIndex, value);
        var e = {
            grid: grid,
            record: record,
            field: dataIndex,
            originalValue: startValue,
            value: value,
            row: rowIndex,
            column: colIndex,
            cancel: false
        };
        if(grid.fireEvent("beforeedit", e) !== false && !e.cancel){
        //~ if(grid.fireEvent("validateedit", e) !== false && !e.cancel){
            record.set(dataIndex, value);
            delete e.cancel;
            grid.fireEvent("afteredit", e);
        }
        return false; // Cancel event propagation
    },

    renderer : function(v, p, record){
        if (record.phantom) return '';
        p.css += ' x-grid3-check-col-td'; 
        return String.format('<div class="x-grid3-check-col{0}">&#160;</div>', v ? '-on' : '');
    }

    // Deprecate use as a plugin. Remove in 4.0
    // init: Ext.emptyFn
});

// register ptype. Deprecate. Remove in 4.0
// Ext.preg('checkcolumn', Lino.CheckColumn);

// backwards compat. Remove in 4.0
// Ext.grid.CheckColumn = Lino.CheckColumn;

// register Column xtype
Ext.grid.Column.types.checkcolumn = Lino.CheckColumn;


/* 20110725 : 
Lino.on_tab_activate is necessary 
in contacts.Person.2.dtl 
(but don't ask me why...)
*/
Lino.on_tab_activate = function(item) {
  //~ console.log('activate',item); 
  if (item.rendered && item.doLayout) item.doLayout();
  //~ if (item.rendered) item.doLayout();
}

Lino.TimeField = Ext.extend(Ext.form.TimeField,{
  format: 'H:i',
  increment: 15
  });
Lino.DateField = Ext.extend(Ext.form.DateField,{
  //~ boxMinWidth: Lino.chars2width(15), // 20131005 changed from 11 to 15
  format: 'd.m.Y',
  altFormats: 'd/m/Y|Y-m-d'
  });
Lino.DatePickerField = Ext.extend(Ext.DatePicker,{
  //~ boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  //~ altFormats: 'd/m/Y|Y-m-d'
  formatDate : function(date){
      //~ console.log("20121203 formatDate",this.name,date);
      return Ext.isDate(date) ? date.dateFormat(this.format) : date;
  }
  });
Lino.DateTimeField = Ext.extend(Ext.ux.form.DateTime,{
  dateFormat: 'd.m.Y',
  timeFormat: 'H:i'
  //~ ,hiddenFormat: 'd.m.Y H:i'
  });
Lino.URLField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  //~ triggerClass : 'x-form-world-trigger',
  vtype: 'url',
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    window.open(this.getValue(),'_blank');
  }
});
Lino.IncompleteDateField = Ext.extend(Ext.form.TextField,{
  //~ regex: /^-?\d+-[01]\d-[0123]\d$/,
  //~ regex: /^[0123]\d\.[01]\d\.-?\d+$/,
  maxLength: 10,
  boxMinWidth: Lino.chars2width(10),
  regex: /^[0123]?\d\.[01]?\d\.-?\d+$/,
  regexText: 'Enter a date in format YYYY-MM-DD (use zeroes for unknown parts).'
  });


//~ Lino.make_dropzone = function(cmp) {
    //~ cmp.on('render', function(ct, position){
      //~ ct.el.on({
        //~ dragenter:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ return true;
        //~ }
        //~ ,dragover:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ event.stopEvent();
          //~ return true;
        //~ }
        //~ ,drop:{
          //~ scope:this
          //~ ,fn:function(event){
            //~ event.stopEvent();
            //~ console.log(20110516);
            //~ var files = event.browserEvent.dataTransfer.files;
            //~ if(files === undefined){
              //~ return true;
            //~ }
            //~ var len = files.length;
            //~ while(--len >= 0){
              //~ console.log(files[len]);
              //~ // this.processDragAndDropFileUpload(files[len]);
            //~ }
          //~ }
        //~ }
      //~ });
    //~ });
//~ };

//~ Lino.FileUploadField = Ext.ux.form.FileUploadField;

Lino.FileUploadField = Ext.extend(Ext.ux.form.FileUploadField,{
    unused_onRender : function(ct, position){
      Lino.FileUploadField.superclass.onRender.call(this, ct, position);
      this.el.on({
        dragenter:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          return true;
        }
        ,dragover:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          event.stopEvent();
          return true;
        }
        ,drop:{
          scope:this
          ,fn:function(event){
            event.stopEvent();
            //~ console.log(20110516);
            var files = event.browserEvent.dataTransfer.files;
            if(files === undefined){
              return true;
            }
            var len = files.length;
            while(--len >= 0){
              console.log(files[len]);
              //~ this.processDragAndDropFileUpload(files[len]);
            }
          }
        }
      });
    }
});

Lino.FileField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  editable: false,
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    if (this.getValue()) window.open(MEDIA_URL + '/'+this.getValue(),'_blank');
  }
});

Lino.file_field_handler = function(panel,config) {
  if (panel.action_name == 'insert') {
      panel.has_file_upload = true;


      // config.value = '<br/><br/>';

      var f = new Lino.FileUploadField(config);
      //~ Lino.make_dropzone(f);
      return f;
      //~ return new Ext.ux.form.FileUploadField(config);
      //~ return new Lino.FileField(config);
      
  } else {
      //~ return new Lino.URLField(config);
      return new Lino.FileField(config);
  }
}

Lino.VBorderPanel = Ext.extend(Ext.Panel,{
    constructor : function(config) {
      config.layout = 'border';
      delete config.layoutConfig;
      Lino.VBorderPanel.superclass.constructor.call(this,config);
      for(var i=0; i < this.items.length;i++) {
        var item = this.items.get(i);
        if (this.isVertical(item) && item.collapsible) {
          item.on('collapse',this.onBodyResize,this);
          item.on('expand',this.onBodyResize,this);
        }
      }
    },
    isVertical : function(item) {
       return (item.region == 'north' || item.region == 'south' || item.region == 'center');
    },
    onBodyResize: function(w, h){
        //~ console.log('VBorderPanel.onBodyResize',this.title)
      if (this.isVisible()) { // to avoid "Uncaught TypeError: Cannot call method 'getHeight' of undefined."
        var sumflex = 0;
        var availableHeight = this.getInnerHeight();
        var me = this;
        this.items.each(function(item){
          if (me.isVertical(item)) {
              if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  if (item.rendered) availableHeight -= item.getHeight();
              } else {
                  sumflex += item.flex;
              }
          } 
          
        });
        //~ for(var i=0; i < this.items.length;i++) {
          //~ var item = this.items.get(i);
          //~ // if (this.isVertical(item) && item.getResizeEl()) {
          //~ if (this.isVertical(item)) {
              //~ if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  //~ // item.syncSize()
                  //~ // item.doLayout()
                  //~ // if (item.region == "north") console.log('region north',item.getHeight(),item.id, item);
                  //~ // if (item.getHeight() == 0) console.log(20100921,'both flex and getHeight() are 0!');
                  //~ availableHeight -= item.getHeight();
              //~ } else {
                  //~ sumflex += item.flex;
                  //~ // console.log(item.flex);
              //~ }
          //~ } 
          //~ // else console.log('non-vertical item in VBoderPanel:',item)
        //~ }
        var hunit = availableHeight / sumflex;
        //~ console.log('sumflex=',sumflex,'hunit=',hunit, 'availableHeight=',availableHeight);
        for(var i=0; i < this.items.length;i++) {
          var item = this.items.get(i);
          if (this.isVertical(item)) {
              if (item.flex != 0 && ! item.collapsed) {
                  item.setHeight(hunit * item.flex);
                  //~ console.log(item.region,' : height set to',item.getHeight());
              }
          }
          //~ else console.log('non-vertical item in VBoderPanel:',item)
        }
      }
      Lino.VBorderPanel.superclass.onBodyResize.call(this, w, h);
    }
});


/*
  modifications to the standard behaviour of a CellSelectionModel:
  
*/
Ext.override(Ext.grid.CellSelectionModel, {
//~ var dummy = {

    handleKeyDown : function(e){
        /* removed because F2 wouldn't pass
        if(!e.isNavKeyPress()){
            return;
        }
        */
        //~ console.log('handleKeyDown',e)
        var k = e.getKey(),
            g = this.grid,
            s = this.selection,
            sm = this,
            walk = function(row, col, step){
                return g.walkCells(
                    row,
                    col,
                    step,
                    g.isEditor && g.editing ? sm.acceptsNav : sm.isSelectable, 
                    sm
                );
            },
            cell, newCell, r, c, ae;

        switch(k){
            case e.ESC:
            case e.PAGE_UP:
            case e.PAGE_DOWN:
                break;
            default:
                // e.stopEvent(); // removed because Browser keys like Alt-Home, Ctrl-R wouldn't work
                break;
        }

        if(!s){
            cell = walk(0, 0, 1); 
            if(cell){
                this.select(cell[0], cell[1]);
            }
            return;
        }

        cell = s.cell;  
        r = cell[0];    
        c = cell[1];    
        
        switch(k){
            case e.TAB:
                if(e.shiftKey){
                    newCell = walk(r, c - 1, -1);
                }else{
                    newCell = walk(r, c + 1, 1);
                }
                break;
            case e.HOME:
                if (! (g.isEditor && g.editing)) {
                  if (!e.hasModifier()){
                      newCell = [r, 0];
                      //~ console.log('home',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
                      if (activePage > 1) {
                          e.stopEvent();
                          t.moveFirst();
                          return;
                      }
                      newCell = [0, c];
                      break;
                  }
                }
            case e.END:
                if (! (g.isEditor && g.editing)) {
                  c = g.colModel.getColumnCount()-1;
                  if (!e.hasModifier()) {
                      newCell = [r, c];
                      //~ console.log('end',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var d = t.getPageData();
                      if (d.activePage < d.pages) {
                          e.stopEvent();
                          var self = this;
                          t.on('change',function(tb,pageData) {
                              var r = g.store.getCount()-2;
                              self.select(r, c);
                              //~ console.log('change',r,c);
                          },this,{single:true});
                          t.moveLast();
                          return;
                      } else {
                          newCell = [g.store.getCount()-1, c];
                          //~ console.log('ctrl-end',newCell);
                          break;
                      }
                  }
                }
            case e.DOWN:
                newCell = walk(r + 1, c, 1);
                break;
            case e.UP:
                newCell = walk(r - 1, c, -1);
                break;
            case e.RIGHT:
                newCell = walk(r, c + 1, 1);
                break;
            case e.LEFT:
                newCell = walk(r, c - 1, -1);
                break;
            case e.F2:
                if (!e.hasModifier()) {
                    if (g.isEditor && !g.editing) {
                        g.startEditing(r, c);
                        e.stopEvent();
                        return;
                    }
                    break;
                }
            case e.INSERT:
                if (!e.hasModifier()) {
                    if (g.ls_insert_handler && !g.editing) {
                        e.stopEvent();
                        Lino.show_insert(g);
                        return;
                    }
                    break;
                }
            // case e.DELETE:
            //     if (!e.hasModifier()) {
            //         if (!g.editing) {
            //             e.stopEvent();
            //             Lino.delete_selected(g);
            //             return;
            //         }
            //         break;
            //     }

            case e.ENTER:
                e.stopEvent();
                g.onCellDblClick(r,c);
                break;

            default:
                g.handle_key_event(e);
                
        }
        

        if(newCell){
          e.stopEvent();
          r = newCell[0];
          c = newCell[1];
          this.select(r, c); 
          if(g.isEditor && g.editing){ 
            ae = g.activeEditor;
            if(ae && ae.field.triggerBlur){
                ae.field.triggerBlur();
            }
            g.startEditing(r, c);
          }
        //~ } else if (g.isEditor && !g.editing && e.charCode) {
        //~ // } else if (!e.isSpecialKey() && g.isEditor && !g.editing) {
            //~ g.set_start_value(String.fromCharCode(e.charCode));
            //~ // g.set_start_value(String.fromCharCode(k));
            //~ // g.set_start_value(e.charCode);
            //~ g.startEditing(r, c);
            //~ // e.stopEvent();
            //~ return;
        // } else {
          // console.log('20120513',e,g);
        }
        
    }


//~ };
});

 

function PseudoConsole() {
    this.log = function() {};
};
if (typeof(console) == 'undefined') console = new PseudoConsole();

Lino.notify = function(msg) {
  if (msg == undefined) msg = ''; else console.log(msg);
  
    if (msg == undefined) return;
    // Lino.alert(msg);
  
};

Lino.alert = function(msg) {
  Ext.MessageBox.alert('Notify',msg);
};


//~ Lino.show_about = function() {
  //~ new Ext.Window({
    //~ width: 400, height: 400,
    //~ title: "About",
    //~ html: '<a href="http://www.extjs.com" target="_blank">ExtJS</a> version ' + Ext.version
  //~ }).show();
//~ };

function obj2str(o) {
  if (typeof o != 'object') return String(o);
  var s = '';
  for (var p in o) {
    s += p + ': ' + obj2str(o[p]) + '\n';
  }
  return s;
}

Lino.on_store_exception = function (store,type,action,options,response,arg) {
  //~ throw response;
  console.log("on_store_exception: store=",store,
    "type=",type,
    "action=",action,
    "options=",options,
    "response=",response,
    "arg=",arg);
  if (arg) { console.log(arg.stack)};
};

//~ Lino.on_submit_success = function(form, action) {
   //~ Lino.notify(action.result.message);
   //~ this.close();
//~ };

Lino.on_submit_failure = function(form, action) {
    //~ Lino.notify();
  // action may be undefined
    switch (action.failureType) {
        case Ext.form.Action.CLIENT_INVALID:
            Ext.Msg.alert('Client-side failure', 'Form fields may not be submitted with invalid values');
            break;
        case Ext.form.Action.CONNECT_FAILURE:
            Ext.Msg.alert('Connection failure', 'Ajax communication failed');
            break;
        case Ext.form.Action.SERVER_INVALID:
            Ext.Msg.alert('Server-side failure', action.result.message);
   }
};



/*
Lino.save_wc_handler = function(ww) {
  return function(event,toolEl,panel,tc) {
    var pos = panel.getPosition();
    var size = panel.getSize();
    wc = ww.get_window_config();
    Ext.applyIf(wc,{ 
      x:pos[0],y:pos[1],height:size.height,width:size.width,
      maximized:panel.maximized});
    Lino.do_action(ww,{url:'/window_configs/'+ww.config.permalink_name,params:wc,method:'POST'});
  }
};

*/

Lino.show_in_own_window_button = function(handler) {
  return {
    qtip: "Show this panel in own window", 
    id: "up",
    handler: function(event,toolEl,panel, tc) {
      //~ console.log('20111206 report_window_button',panel,handler);
      handler.run(null,{base_params:panel.containing_panel.get_master_params()});
    }
  }
}

Lino.action_handler = function (panel, on_success, on_confirm) {
  return function (response) {
      if (!panel) { 
          if (Lino.current_window) 
              panel = Lino.current_window.main_item;
          else panel = Lino.viewport;
      }
      
    if (panel.loadMask) panel.loadMask.hide(); // 20120211
    if (!response.responseText) return ;
    var result = Ext.decode(response.responseText);
    Lino.handle_action_result(panel, result, on_success, on_confirm);
  }
};

Lino.handle_action_result = function (panel, result, on_success, on_confirm) {

    // console.log('20141127 Lino.handle_action_result()', result);
    
    // if (panel instanceof Lino.GridPanel) {
    //     gridmode = true;
    // } else {
    //     gridmode = false;
    // }

    //~ if (result.goto_record) {
        //~ var js = "Lino." + result.goto_record[0] + '.detail.run';
        //~ var h = eval(js);
        //~ h(panel,{record_id:result.goto_record[1]});
    //~ }
    
    if (result.xcallback) {
        //~ var config = {title:"Confirmation"};
        var config = {title:result.xcallback.title};
        //~ config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        var p = {};
        Lino.insert_subst_user(p);
        config.buttons = result.xcallback.buttons;
        config.msg = result.message;
        config.fn = function(buttonId, text, opt) {
          panel.loadMask.show(); 
          //~ Lino.insert_subst_user(p);
          Ext.Ajax.request({
            method: 'GET',
            url: '/callbacks/'
                  + result.xcallback.id + '/' + buttonId,
            params: p,
            success: Lino.action_handler(panel, on_success, on_confirm)
          });
        }
        Ext.MessageBox.show(config);
        return;
    }

    // `record_id` and/or `data_record` both mean "display the detail
    // of this record". 
    
    if(result.detail_handler_name) {
        // TODO: make sure that result.detail_handler_name is secure
        var detail_handler = eval("Lino." + result.detail_handler_name);
    }
    var ns = {};  // new status
    if (result.close_window) {
        
        if(result.record_id || result.data_record) {
            var ww = Lino.calling_window();
            if (ww && ww.window.main_item instanceof Lino.FormPanel) {
                if (ww.window.main_item.ls_detail_handler == detail_handler) {
                    ns.record_id = result.record_id;
                    ns.data_record = result.data_record;
                    console.log("20140630 use new status.");
                }
            }
        }

        // Subsequent processing expects that `panel` is "the current
        // panel". Since we close the window, `panel` should now point
        // to the previous window. Note the case of an insert window
        // that has been invoked by double-clicking on the phantom row
        // of a slave table in a detail window. In that case we want
        // `panel` to become the grid panel of the slave table who
        // called the insert window, not the master's detail form
        // panel.  When the insert window has been called by an action
        // link (e.g. generated using ar.insert_button), then
        // Lino.close_window can return `undefined`.

        panel = Lino.close_window(function(st) {Ext.apply(st, ns)}); 
        if (!panel) 
            panel = Lino.current_window.main_item;

    }

    if(result.record_id || result.data_record) {
        if (! (ns.record_id || ns.data_record)) {
          if (panel instanceof Lino.FormPanel 
              && panel.ls_detail_handler == detail_handler) 
            {
              // console.log("20140630 use panel.set_status().");
              panel.set_status({
                  record_id: result.record_id,
                  data_record: result.data_record});
          } else {
              // console.log("20140630 run detail_handler.");
              detail_handler.run(null, {
                  record_id: result.record_id,
                  data_record: result.data_record,
                  base_params: panel.get_base_params()});
          }

          // if (panel instanceof Lino.FormPanel 
          //     && panel.ls_url == result.actor_url) {
          //     // console.log("20140506 case 2 it's a FormPanel:", panel);
          //     panel.set_status({
          //         record_id: result.record_id,
          //         data_record: result.data_record});
          // } else if (panel.ls_detail_handler 
          //            && panel.ls_url == result.actor_url) {
          //     // console.log("20140506 case 4");
          //     panel.ls_detail_handler.run(null, {
          //         record_id: result.record_id,
          //         data_record: result.data_record,
          //         base_params: panel.get_base_params()});
          // } else {
          //     result.refresh_all = true;
          //     console.log("20140604 case 6", result.actor_url);
          // }
        }
    }

    // `eval_js` must get handled after `close_window` because it
    // might ask to open a new window (and we don't want to close that
    // new window).  It must execute *before* any MessageBox,
    // otherwise the box would get hidden by a window that opens
    // afterwards.

    if (result.eval_js) {
        //~ console.log(20120618,result.eval_js);
        eval(result.eval_js);
    }
    
    if (on_success && result.success) {
        // console.log("20140430 handle_action_result calls on_success", 
        //             on_success);
        on_success(result);
    }
    
    if (result.info_message) {
        console.log(result.info_message);
    }
    
    if (result.warning_message) {
        if (!result.alert) result.alert = "Warning";
        Ext.MessageBox.alert(result.alert, result.warning_message);
    }
    
    if (result.message) {
        //~ if (result.alert && ! gridmode) {
        if (result.alert) { // 20120628b 
            //~ Ext.MessageBox.alert('Alert',result.alert_msg);
            if (result.alert === true) result.alert = "Alert";
            Ext.MessageBox.alert(result.alert, result.message);
        } else {
            Lino.notify(result.message);
        }
    }

    if(result.record_deleted && panel.ls_detail_handler == detail_handler) {
        panel.after_delete();
    }
    
    if (result.refresh_all) {
        var cw = Lino.current_window;
        // var cw = panel.get_containing_window();
        if (cw) {
            // console.log("20140917 refresh_all calls refresh on", cw.main_item);
            cw.main_item.refresh();
        }
        // else console.log("20140917 cannot refresh_all because ",
        //                  "there is no current_window");
    } else {
        if (result.refresh) {
            // console.log("20140917 Gonna call panel.refresh()", panel);
            panel.refresh();
        }
    }if (result.open_url) {
        //~ console.log(20111126,result.open_url);
        //~ if (!result.message)
            //~ Lino.notify('Open new window <a href="'+result.open_url+'" target="_blank">'+result.open_url+'</a>');
        window.open(result.open_url,'foo',"");
        //~ document.location = result.open_url;
    }
};

// obsolete but still used for deleting records.
Lino.do_action = function(caller,action) { 
  action.success = function(response) {
    if (caller.loadMask) caller.loadMask.hide();
    //~ console.log('Lino.do_action()',action,'action success',response);
    if (action.after_success) {
        //~ console.log('Lino.do_action() calling after_success');
        action.after_success();
    }
    if (response.responseText) {
      var result = Ext.decode(response.responseText);
      //~ console.log('Lino.do_action()',action.name,'result is',result);
      if (result.message) {
          if (result.alert) {
              //~ Ext.MessageBox.alert('Alert',result.alert_msg);
              Ext.MessageBox.alert('Alert',result.message);
          } else {
              Lino.notify(result.message);
          }
      }
      
      //~ if (result.alert_msg) Ext.MessageBox.alert('Alert',result.alert_msg);
      //~ if (result.message) Lino.notify(result.message);
      if (result.notify_msg) Lino.notify(result.notify_msg);
      if (result.js_code) { 
        //~ console.log('Lino.do_action()',action,'gonna call js_code in',result);
        var jsr = result.js_code(caller);
        //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
        if (action.after_js_code) {
          //~ console.log('Lino.do_action()',action,'gonna call after_js_code');
          action.after_js_code(jsr);
          //~ console.log('Lino.do_action()',action,'returned from after_js_code');
        //~ } else {
          //~ console.log('Lino.do_action()',action,' : after_js_code is false');
        }
      };
    }
  };
  Ext.applyIf(action,{
    waitMsg: "Please wait...",
    failure: Lino.ajax_error_handler(caller),
    params: {}
  });
  //~ action.params.su = Lino.subst_user;
  Lino.insert_subst_user(action.params);
  
  Ext.Ajax.request(action);
};

//~ Lino.gup = function( name )
//~ {
  //~ // Thanks to http://www.netlobo.com/url_query_string_javascript.html
  //~ name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
  //~ var regexS = "[\\?&]"+name+"=([^&#]*)";
  //~ var regex = new RegExp( regexS );
  //~ var results = regex.exec( window.location.href );
  //~ if( results == null )
    //~ return "";
  //~ else
    //~ return results[1];
//~ };

//~ Lino.refresh_handler = function (ww) {
  //~ return function() { 
      //~ console.log('refresh',ww);
      //~ ww.main_item.doLayout(false,true);
      //~ ww.main_item.syncSize();
  //~ }
//~ };

//~ Lino.tools_close_handler = function (ww) {
  //~ return function() { 
      //~ ww.close();
  //~ }
//~ };
Lino.permalink_handler = function (ww) {
  return function() { 
    //~ document.location = ww.main_item.get_permalink();
    //~ console.log('20130723 Lino.permalink_handler',ww);
    
    /* Uncaught TypeError: Cannot read property 'main_item' of null  */
    if (ww) {
        var url = ww.main_item.get_permalink();
    } else {
        var url = Lino.viewport.get_permalink();
    }
    Lino.load_url(url);
  }
};
//~ Lino.run_permalink = function() {
  //~ var plink = Lino.gup('permalink');
  //~ if(plink) { eval('Lino.'+plink); }
//~ }


Lino.ajax_error_handler = function(panel) {
  return function(response,options) {
    console.log('Ajax failure:', response, options);
    if (panel.loadMask) panel.loadMask.hide();
    if (response.responseText) {
      var lines = response.responseText.split('\n');
      if (lines.length > 10) {
          line = lines.splice(5, lines.length-10, "(...)");
      }
      //~ console.log(20131005, response.statusText.toCamel());
      Ext.MessageBox.alert(
        response.statusText.toCamel(),
        lines.join('<br/>')
        //~ response.responseText.replace(/\n/g,'<br/>'))
      )
    } else {
      Ext.MessageBox.alert('Action failed',
        'Lino server did not respond to Ajax request');
    }
  }
}
// Ext.Ajax.on('requestexception',Lino.ajax_error_handler)
 


Ext.QuickTips.init();

/* setting QuickTips dismissDelay to 0 */
// Apply a set of config properties to the singleton
//~ Ext.apply(Ext.QuickTips.getQuickTip(), {
//~ Ext.apply(Ext.ToolTip, {
    //~ dismissDelay: 0
    //~ autoHide: false,
    //~ closable: true,
    //~ maxWidth: 200,
    //~ minWidth: 100,
    //~ showDelay: 50      // Show 50ms after entering target
    //~ ,trackMouse: true
//~ });


//~ Ext.apply(Ext.QuickTip, {
    //~ dismissDelay: 0,
//~ });
  
Lino.quicktip_renderer = function(title,body) {
  return function(c) {
    //~ if (c instanceof Ext.Panel) var t = c.bwrap; else // 20130129
    if (c instanceof Ext.Panel) var t = c.header; else // 20130129
    var t = c.getEl();
    //~ console.log(20130129,t,title,body);
    //~ t.dismissDelay = 0;
    Ext.QuickTips.register({
      target: t,
      //~ cls: 'lino-quicktip-classical',
      dismissDelay: 0,
      //~ autoHide: false,
      showDelay: 50,      // Show 50ms after entering target
      //~ title: title,
      text: body
    });
  }
};


  
Lino.help_text_editor = function() {
  //~ var bp = {
      //~ mk:this.content_type,
      //~ mt:1
    //~ };
    //~ console.log(20120202,bp);
  //~ Lino.lino.ContentTypes.detail({},{base_params:bp});
  //~ Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
  Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
}

// Path to the blank image should point to a valid location on your server
//~ Ext.BLANK_IMAGE_URL = MEDIA_URL + '/extjs/resources/images/default/s.gif'; 


// used as Ext.grid.Column.renderer for id columns in order to hide the special id value -99999
Lino.id_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  return value;
}

Lino.raw_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  return value;
}

Lino.text_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return "not implemented"; 
  return value;
}

Lino.NullNumberColumn = Ext.extend(Ext.grid.Column, {
    align : 'right', 
    format : '0,00/i', 
    renderer : function(value, metaData, record, rowIndex, colIndex, store) {
        //~ console.log(20130128,"NullNumberColumn.renderer",value);
        if (value === null) return '';
        return Ext.util.Format.number(value, this.format);
    }
});


Lino.link_button = function(url) {
    // return '<a href="' + url + '"><img src="/media/lino/extjs/images/xsite/link.png" alt="link_button"></a>'
    return '<a href="' + url + '" style="text-decoration:none;">&#10138;</a>'
}

Lino.fk_renderer = function(fkname,handlername) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    //~ if (record.phantom) return '';
    if (value) {
        return Lino.link_button('javascript:'+handlername + '.run(null,{record_id:\'' + String(record.data[fkname]) + '\'})")') + value;
        // until 20140822 (clickable foreign keys):
        // var s = '<a href="javascript:' ;
        // s += handlername + '.run(null,{record_id:\'' + String(record.data[fkname]) + '\'})">';
        // s += value + '</a>';
        // return s
    }
    return '';
  }
};

Lino.lfk_renderer = function(panel,fkname) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  var handlername = 'console.log';
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '({},{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

//~ Lino.gfk_renderer = function() {
  //~ return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ if (record.phantom) return '';
    //~ console.log('Lino.gfk_renderer',value,colIndex,record,metaData,store);
    //~ return value;
  //~ }
//~ };


Lino.build_buttons = function(panel,actions) {
  //~ console.log("20121006 Lino.build_buttons",actions);
  if (actions) {
    var buttons = Array(actions.length);
    var cmenu = Array(actions.length);
    var keyhandlers = {};
    for (var i=0; i < actions.length; i++) { 
      var a = actions[i];
      if (a.menu) a.menu = Lino.build_buttons(panel,a.menu).bbar;
      buttons[i] = a;
      cmenu[i] = {
            text : a.menu_item_text,
            iconCls : a.iconCls,
            menu : a.menu
          };
      if (a.panel_btn_handler) {
          var h = a.panel_btn_handler.createCallback(panel);
          if (a.auto_save == true) {
              h = panel.do_when_clean.createDelegate(panel,[true,h]);
          } else if (a.auto_save == null) {
              h = panel.do_when_clean.createDelegate(panel,[false,h]);
          } else if (a.auto_save == false) {
              // h = h;
          } else {
              console.log("20120703 unhandled auto_save value",a)
          }
          buttons[i].handler = h;
          cmenu[i].handler = h;
          if (a.keycode) {
              keyhandlers[a.keycode] = h;
          }
          //~ if (buttons[i].xtype == 'splitbutton') {
              //~ cmenu[i].menu = a.menu;
          //~ } else {
              //~ cmenu[i].handler = h;
          //~ }
      } else {
          console.log("action without panel_btn_handler",a)
          // cmenu[i].handler = a.handler;
      }
    }
    return {
        bbar:buttons, 
        cmenu:new Ext.menu.Menu(cmenu),
        keyhandlers: keyhandlers
    };
  }
}

Lino.do_when_visible = function(cmp,todo) {
  //~ if (cmp.el && cmp.el.dom) 
  if (cmp.isVisible()) { 
    // 'visible' means 'rendered and not hidden'
    //~ console.log(cmp.title,'-> cmp is visible now');
    todo(); 
  //~ } else {
      //~ cmp.on('resize',todo,cmp,{single:true});
  //~ }
  //~ if (false) { // 20120213
  } else { 
    //~ console.log('Lino.do_when_visible() must defer because not isVisible()',todo,cmp);
    if (cmp.rendered) {
      //~ console.log(cmp,'-> cmp is rendered but not visible: and now?');
      //~ console.log(cmp.title,'-> cmp is rendered but not visible: try again in a moment...');
      //~ var fn = function() {Lino.do_when_visible(cmp,todo)};
      //~ fn.defer(100);
      
      Lino.do_when_visible.defer(50,this,[cmp,todo]);
      //~ Lino.do_when_visible.defer(100,this,[cmp,todo]);
      
    } else {
      //~ console.log(cmp.title,'-> after render');
      cmp.on('afterrender',todo,cmp,{single:true});
    }
  }
  
};    

/*
*/
Lino.do_on_current_record = function(panel, fn, phantom_fn) {
  // console.log('20140930 do_on_current_record', arguments);
  var rec = panel.get_current_record();
  if (rec == undefined) {
    Lino.notify("There's no selected record.");
    return;
  }
  // 20120307 A VirtualTable with a Detail (lino.Models) has only "phantom" records.
  if (rec.phantom) {
    //~ if (!panel.editable) { console.log("20120312 not editable:",panel)}
    if (phantom_fn) {
      phantom_fn(panel);
    } else {
      Lino.notify("Action not available on phantom record.");
    }
    return;
  }
  return fn(rec);
};


Lino.call_ajax_action = function(
    panel, method, url, p, actionName, step, on_confirm, on_success) {
  p.an = actionName;
  if (!panel || !panel.isVisible()) {
  //~ if (true) { // 20131026 : workflow_actions of a newly created record detail executed but did't refresh the screen because their requesting panel was the insert (not the detail) formpanel.
      if (Lino.current_window) 
          panel = Lino.current_window.main_item;
      else panel = Lino.viewport;
  }
  Ext.apply(p, panel.get_base_params());

  if (panel.get_selected) {
      var selected_recs = panel.get_selected();
      //~ console.log("20130831",selected_recs);
      var rs = Array(selected_recs.length);
      for(var i=0; i < selected_recs.length;i++) {
          rs[i] = selected_recs[i].data.id;
      };
      p.sr = rs;
  }
  
  // console.log("20140516 Lino.call_ajax_action", p, actionName, step);
  
  if (panel.loadMask) panel.loadMask.show(); 
    
  Ext.Ajax.request({
    method: method
    ,url: url
    ,params: p
    ,success: Lino.action_handler(panel, on_success, on_confirm)
    ,failure: Lino.ajax_error_handler(panel)
  });
};




Lino.row_action_handler = function(actionName, hm, pp) {
  var p = {};
  var fn = function(panel, btn, step) {
      // console.log('20140930 row_action_handler');
      if (pp) { p = pp(panel); if (! p) return; }
      
      if (!panel || panel.get_current_record == undefined) { // AFTER_20130725
        // console.log('20140930 row_action_handler 2', panel);
        panel = Ext.getCmp(panel);
        if (panel == undefined) {
          Lino.notify("Invalid panel spec.");
          return;
        }
      }
      
      Lino.do_on_current_record(panel, function(rec) {
          //~ console.log(panel);
          panel.add_param_values(p, true);
          Lino.call_ajax_action(
              panel, hm, panel.get_record_url(rec.id), 
              p, actionName, step, fn);
      });
  };
  return fn;
};

Lino.list_action_handler = function(ls_url,actionName,hm,pp) {
  var p = {};
  var url = '/api' + ls_url
  var fn = function(panel,btn,step) {
      //~ console.log("20121210 Lino.list_action_handler",arguments);
      if (pp) { p = pp(panel);  if (! p) return; }
      if (panel)  // may be undefined when called e.g. from quicklink
          panel.add_param_values(p,true);
      Lino.call_ajax_action(panel, hm,url, p, actionName, step, fn);
  };
  return fn;
};

Lino.param_action_handler = function(window_action) { // 20121012
  var fn = function(panel,btn,step) {
    Lino.do_on_current_record(panel,function(rec) {
      window_action.run(panel.getId(),{}); 
    });
  };
  return fn;
};


Lino.run_row_action = function(
    requesting_panel, url, meth, pk, actionName, params, preprocessor) {
  //~ var panel = action.get_window().main_item;
    console.log("20140930 Lino.run_row_action", params);
  url = '/api' + url  + '/' + pk;
  var panel = Ext.getCmp(requesting_panel);
  if (!params) params = {};
  if (preprocessor) {
      var p = preprocessor(); 
      Ext.apply(params, p);
  }
  var fn = function(panel, btn, step) {
    Lino.call_ajax_action(panel, meth, url, params, actionName, step, fn);
  }
  fn(panel, null, null);
}

Lino.put = function(requesting_panel, pk, data) {
    var panel = Ext.getCmp(requesting_panel);
    //~ var panel = null; // 20131026
    var p = {};
    p.an = 'put'; // SubmitDetail.action_name

    Ext.apply(p,data);
    var req = {
        params:p
        ,waitMsg: 'Saving your data...'
        ,scope: panel
        ,success: Lino.action_handler( panel, function(result) { 
            panel.refresh();
        })
        ,failure: Lino.ajax_error_handler(panel)
    };
    req.method = 'PUT';
    req.url = '/api' + panel.ls_url + '/' + pk;
    if (panel.loadMask) panel.loadMask.show(); 
    Ext.Ajax.request(req);
}



Lino.show_detail = function(panel, btn) {
  Lino.do_on_current_record(panel, 
    function(rec) {
      //~ panel.loadMask.show();
      Lino.run_detail_handler(panel, rec.id);
    },
    Lino.show_insert
  );
};

Lino.run_detail_handler = function(panel,pk) {
  var bp = panel.get_base_params();
  panel.add_param_values(bp); // 20120918
  var status = {
    record_id:pk,
    base_params:bp
  }
  //~ console.log("20120918 Lino.show_detail",status);
  panel.ls_detail_handler.run(null,status);
}

Lino.show_fk_detail = function(combo,detail_action,insert_action) {
    //~ console.log("Lino.show_fk_detail",combo,handler);
    pk = combo.getValue();
    if (pk) {
        detail_action.run(null,{record_id: pk})
      } else {
        insert_action.run(null,{record_id:-99999});
        //~ Lino.notify("Cannot show detail for empty foreign key.");
      }
};

Lino.show_insert = function(panel,btn) {
  var bp = panel.get_base_params();
  //~ console.log('20120125 Lino.show_insert',bp)
  //~ panel.ls_insert_handler.run(null,{record_id:-99999,base_params:bp});
  panel.ls_insert_handler.run(panel.getId(),{record_id:-99999,base_params:bp});
};



if (Ext.ux.grid !== undefined) {
    Lino.GridFilters = Ext.extend(Ext.ux.grid.GridFilters,{
      encode:true,
      local:false
    });
} else {
    Lino.GridFilters = function() {}; // dummy
    Ext.override(Lino.GridFilters,{
      init : function() {}
    });
};



Lino.FieldBoxMixin = {
  before_init : function(config,params) {
    if (params) Ext.apply(config,params);
    var actions = Lino.build_buttons(this, config.ls_bbar_actions);
    if (actions) config.bbar = actions.bbar;
  },
  //~ constructor : function(ww,config,params){
    //~ this.containing_window = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  do_when_clean : function(auto_save,todo) { todo() },
  //~ format_data : function(html) { return '<div class="htmlText">' + html + '</div>' },
  format_data : function(html) { return html },
  get_base_params : function() {
    // needed for insert action
    var p = Ext.apply({}, this.base_params);
    Lino.insert_subst_user(p);
    return p;
  },
  set_base_params : function(p) {
    this.base_params = Ext.apply({},p);
    //~ if (p.param_values) this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  },
  set_base_param : function(k,v) {
    this.base_params[k] = v;
  }
};



Lino.HtmlBoxPanel = Ext.extend(Ext.Panel, Lino.PanelMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel, Lino.FieldBoxMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel, {
  disabled_in_insert_window : true,
  constructor : function(config,params) {
    this.before_init(config,params);
    Lino.HtmlBoxPanel.superclass.constructor.call(this, config);
  },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.constructor.call(this, ww,config,params);
  //~ },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  //~ disable : function() { var tb = this.getBottomToolbar(); if(tb) tb.disable()},
  //~ enable : function() { var tb = this.getBottomToolbar(); if(tb) tb.enable()},
  onRender : function(ct, position){
    Lino.HtmlBoxPanel.superclass.onRender.call(this, ct, position);
    //~ console.log(20111125,this.containing_window);
    if (this.containing_panel) {
      this.containing_panel.on('enable',this.enable,this);
      this.containing_panel.on('disable',this.disable,this);
    }
    this.el.on({
      dragenter:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        return true;
      }
      ,dragover:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        event.stopEvent();
        return true;
      }
      ,drop:{
        scope:this
        ,fn:function(event){
          event.stopEvent();
          //~ console.log(20110516);
          var files = event.browserEvent.dataTransfer.files;
          if(files === undefined){
            return true;
          }
          var len = files.length;
          while(--len >= 0){
            console.log(files[len]);
            //~ this.processDragAndDropFileUpload(files[len]);
          }
          Lino.show_insert(this);
        }
      }
    });
  },
  refresh : function(unused) { 
      // this.containing_panel.refresh();
      this.refresh_with_after();
  },
  /* HtmlBoxPanel */
  refresh_with_after : function(after) {
      // var todo = this.containing_panel.refresh();
      var box = this.items.get(0);
      var todo = function() {
        if (this.disabled) { return; }
        this.set_base_params(this.containing_panel.get_master_params());

        var el = box.getEl();
        if (el) {
            var record = this.containing_panel.get_current_record();
            var newcontent = record ? 
                this.format_data(record.data[this.name]) : '';
            // console.log('20140917 HtmlBox.refresh()',
            //             this.name, record.data.LinksByHuman);
            el.update(newcontent, true);
        // } else {
        //     console.log('20140502 cannot HtmlBox.refresh()',this.name);
        }
      };

      Lino.do_when_visible(box, todo.createDelegate(this));
  }
});
//~ Ext.override(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);



Lino.RichTextPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,Lino.FieldBoxMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,{
    
  //~ initComponent : function(){
    //~ Lino.RichTextPanel.superclass.initComponent.call(this);
  //~ },
  constructor : function(config,params) {
    //~ console.log('Lino.RichTextPanel.initComponent',this);
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + String(rec.id) + "/" + config.name;
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + config.name;
    var t = this;
    var tinymce_options = {
        theme : "advanced",
        content_css: '/media/lino/extjs/lino.css',
        language: 'en',
        //~ template_external_list_url : url,
        theme_advanced_toolbar_location : "top",
        theme_advanced_toolbar_align : "left",
        theme_advanced_statusbar_location : "bottom",
        template_popup_width : 700,
        template_popup_height : 500,
        template_replace_values : { 
            data_field : function(element){ 
                //~ console.log(20110722,fieldName,t.containing_window.get_current_record()); 
                var fieldName = element.innerHTML;
                element.innerHTML = t.containing_panel.get_current_record().data[fieldName];
            } 
        }
      };
      
    var editorConfig = {
      tinymceSettings: {
        plugins : "noneditable,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "bold,italic,underline,|,justifyleft,justifycenter,justifyright,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,removeformat,template",
        theme_advanced_buttons2 : "",
        theme_advanced_buttons3 : "", // ,|,sub,sup,|,charmap",      
        theme_advanced_resizing : false
        //~ save_onsavecallback : save_callback,
        //~ save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
        
    }};
    Ext.apply(editorConfig.tinymceSettings,tinymce_options);
    //~ editorConfig.name = config.action_name;
    editorConfig.name = config.name;
    delete config.name;
    //~ config.title = config.label;
    //~ delete config.label;
    this.before_init(config,params);
    
    this.editor = new Ext.ux.TinyMCE(editorConfig);
    var t = this;
    config.tools = [{
                      qtip: "Edit text in own window", 
                      id: "up",
                      handler: function(){
                        if(t.editor.isDirty()) {
                            var record = t.containing_panel.get_current_record();
                            record.data[t.editor.name] = t.editor.getValue();
                        }
                        Lino.edit_tinymce_text(t, tinymce_options)
                      }
                    }];
    
    config.items = this.editor;
    config.layout = "fit";
    Lino.RichTextPanel.superclass.constructor.call(this, config);
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  /* RichTextPanel */
  refresh_with_after : function(after) {
    var record = this.containing_panel.get_current_record();
    // console.log('20140504 RichTextPanel.refresh()',
    //             this.title,record.title, record);
    var todo = function() {
      if (record) {
        var url = '/templates' 
              + this.containing_panel.ls_url + "/" 
              + String(record.id) + "/" + this.editor.name;
        //~ console.log('RichTextPanel.refresh()',url);
        if (this.editor.ed) this.editor.ed.settings.template_external_list_url = url;
        this.set_base_params(this.containing_panel.get_master_params());
        //~ var v = record ? this.format_data(record.data[this.editor.name]) : ''
        var v = this.format_data(record.data[this.editor.name])
        this.editor.setValue(v);
      } else {
        this.editor.setValue('(no data)');
      }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
//~ Ext.override(Lino.RichTextPanel,Lino.FieldBoxMixin);



Lino.ActionFormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel, Lino.PanelMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel, Lino.FieldBoxMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel, {
  //~ layout:'fit'
  //~ ,autoHeight: true
  //~ ,frame: true
  window_title : "Action Parameters",
  constructor : function(config){
    config.bbar = [
        {text: 'OK', handler: this.on_ok, scope: this},
        {text: 'Cancel', handler: this.on_cancel, scope: this}
    ];
    Lino.ActionFormPanel.superclass.constructor.call(this, config);
  }
  //~ ,initComponent : function(){
    //~ Lino.ActionFormPanel.superclass.initComponent.call(this);
  //~ }
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
    var panel = this.requesting_panel;
    // var panel = this.get_containing_window().main_item;
    // console.log("20131004 on_ok",this,panel,arguments);
    var actionName = this.action_name;
    var pk = this.record_id;
    if (pk == undefined && this.base_params) { pk = this.base_params.mk; }
    if (pk == undefined && panel) {
        pk = panel.get_current_record().id;
    }
    if (pk == undefined) {
        Lino.alert("Sorry, dialog action without base_params.mk");
        return;
    }
    var self = this;
    // function on_success() { self.get_containing_window().close(); };
    // see 20131004 and 20140430
    var url = '/api';
    if (panel) 
        url += panel.ls_url;
    else 
        url += this.ls_url;
    url += '/' + pk;
    // prepare possible recursive call
    var fn = function(panel, btn, step) {
      var p = {};
      self.add_field_values(p)
      Lino.call_ajax_action(
          panel, 'GET', url, p, actionName, step, fn); //  , on_success);
    }
    fn(panel, null, null);
    
    
  }
  /* ActionFormPanel*/
  ,set_status : function(status, rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 ActionFormPanel.set_status()',status,rp,this.requesting_panel);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_field_values(status.field_values);
    if (status.base_params) this.set_base_params(status.base_params);
    this.record_id = status.record_id;
  }
  
  ,before_row_edit : function(record) {}
  ,add_field_values : function (p) { // similar to add_param_values()
      //~ 20121023 
      if (this.form.isDirty()) {
        p.fv = this.get_field_values();
      }else{
        if (this.status_field_values) 
          p.fv = Lino.fields2array(this.fields,this.status_field_values);
      }
      //~ if (!this.form.isDirty()) return;
      //~ p.$ext_requests.URL_PARAM_FIELD_VALUES = this.get_field_values();
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
  }
  ,get_field_values : function() {
      return Lino.fields2array(this.fields);
  }
  ,set_field_values : function(pv) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_field_values = pv;
      if (pv) {
          this.form.my_loadRecord(pv);
          var record = { data: pv };
          this.before_row_edit(record);
      } else {
          this.form.reset(); 
          this.before_row_edit();
      }
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.title = this.window_title;
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok }
      ]
      
      if (!wincfg.defaultButton) this.getForm().items.each(function(f){
          if(f.isFormField){ 
              wincfg.defaultButton = f;
              return false;
          }
      });

  }
});

    
Lino.fields2array = function(fields,values) {
    //~ console.log('20130605 fields2array gonna loop on', fields,values);
    var pv = Array(fields.length);
    for(var i=0; i < fields.length;i++) {
        var f = fields[i]
        if (values) 
          var v = values[f.name];
        else 
          var v = f.getValue();
        if (f.formatDate) {
            pv[i] = f.formatDate(v); 
        } else {
            pv[i] = v; // f.getValue(); 
        }
    }
    return pv;
}


Lino.FormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.FormPanel = Ext.extend(Lino.FormPanel,Lino.PanelMixin);
Lino.FormPanel = Ext.extend(Lino.FormPanel,{
  params_panel_hidden : false,
  save_action_name : null, 
  //~ base_params : {},
  //~ trackResetOnLoad : true,
  //~ query_params : {},
  //~ 20110119b quick_search_text : '',
  constructor : function(config,params){
    if (params) Ext.apply(config,params);
    this.base_params = {};
    //~ ww.config.base_params.query = ''; // 20111018
    //~ console.log(config);
    //~ console.log('FormPanel.constructor() 1',config)
    //~ Ext.applyIf(config,{base_params:{}});
    //~ console.log('FormPanel.constructor() 2',config)
      
    config.trackResetOnLoad = true;
    
    Lino.FormPanel.superclass.constructor.call(this, config);
      
    //~ this.set_base_param('$URL_PARAM_FILTER',null); // 20111018
    //~ this.set_base_param('$URL_PARAM_FILTER',''); // 20111018
      
  },
  initComponent : function(){
    
    this.containing_panel = this;

    //~ console.log("20111201 containing_window",this.containing_window,this);


    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    if (actions) {
        this.bbar = actions.bbar;
    //~ } else {
        //~ this.bbar = [];
    }
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ var config = this;
    
    //~ if (this.containing_window instanceof Lino.DetailWrapper) {
    
    //~ console.log('20120121 initComponent', this.action_name);
    //~ if (this.action_name == 'detail' | this.action_name == 'show') {
    //~ if (this.action_name != 'insert') {
    if (! this.hide_top_toolbar) {
      this.tbar = [];
      // 20111015    
      if (! this.hide_navigator) {
        this.record_selector = new Lino.RemoteComboFieldElement({
          store: new Lino.ComplexRemoteComboStore({
            //~ baseParams: this.containing_window.config.base_params,
            baseParams: this.get_base_params(),
            //~ value: this.containing_window.config.base_params.query,
            proxy: new Ext.data.HttpProxy({
              url: '/choices' + this.ls_url,
              method:'GET'
            })
          }),
          pageSize:25,
          listeners: { 
            scope:this, 
            select:function(combo,record,index) {
              //~ console.log('jumpto_select',arguments);
              this.goto_record_id(record.id);
            }
          },
          emptyText: "Go to record"
        })
        this.tbar = this.tbar.concat([this.record_selector]);
        
        this.tbar = this.tbar.concat([
          this.first = new Ext.Toolbar.Button({
              tooltip:"First",disabled:true,
              handler:this.moveFirst,scope:this,iconCls:'x-tbar-page-first'}),
          this.prev = new Ext.Toolbar.Button({
              tooltip:"Previous",disabled:true,
              handler:this.movePrev,scope:this,iconCls:'x-tbar-page-prev'}),
          this.next = new Ext.Toolbar.Button({
              tooltip:"Next",disabled:true,
              handler:this.moveNext,scope:this,iconCls:'x-tbar-page-next'}),
          this.last = new Ext.Toolbar.Button({
              tooltip:"Last",disabled:true,
              handler:this.moveLast,scope:this,iconCls:'x-tbar-page-last'})
        ]);
      }
      this.tbar = this.add_params_panel(this.tbar);
      
      //~ console.log(20101117,this.containing_window.refresh);
      this.tbar = this.tbar.concat([
        {
          //~ text:'Refresh',
          handler:function(){ this.do_when_clean(false,this.refresh.createDelegate(this)) },
          iconCls: 'x-tbar-loading',
          tooltip:"Reload current record",
          scope:this}
      ]);
          
      if (this.bbar) { // since 20121016
        if (this.tbar) {
            this.tbar = this.tbar.concat(['-']) ;
        } else {
          this.tbar = [];
        }
        this.tbar = this.tbar.concat(this.bbar) ;
        this.bbar = undefined;
      }
    
      this.tbar = this.tbar.concat([
          '->',
          this.displayItem = new Ext.Toolbar.TextItem({})
      ]);
          
    }
    //~ if (this.content_type && this.action_name != 'insert') {
      //~ this.bbar = this.bbar.concat([
        //~ '->',
        //~ { text: "[$_('Help Text Editor')]",
          //~ handler: Lino.help_text_editor,
          //~ qtip: "$_('Edit help texts for fields on this model.')",
          //~ scope: this}
      //~ ])
    //~ }
    //~ this.before_row_edit = config.before_row_edit.createDelegate(this);
      
    //~ if (this.master_panel) {
        //~ this.set_base_params(this.master_panel.get_master_params());
    //~ }
      
    Lino.FormPanel.superclass.initComponent.call(this);

    // this.on('show',
    //         function(){ this.init_focus();}, 
    //         this);
    
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.bwrap,{msg:"Please wait..."});
    },this);
    
    
    if (this.action_name == 'insert') {
      this.cascade(function(cmp){
        // console.log('20110613 cascade',cmp);
        if (cmp.disabled_in_insert_window) {
            //~ cmp.disable();
            cmp.hide();
        }
      });
      
    }
    
  },
  
  unused_init_focus : function(){ 
    // set focus to the first field
    console.log("20140205 Lino.FormPanel.init_focus");
    // Lino.FormPanel.superclass.focus.call(this);
    this.getForm().items.each(function(f){
        if(f.isFormField && f.rendered){ 
            f.focus();
            console.log("20140205 focus", f);
            return false;
        }
    });
  },

  /* FormPanel */
  get_status : function(){
      var st = {
        base_params: this.get_base_params(),
        // data_record : this.get_current_record()
        }
      st.record_id = this.get_current_record().id;
      // 20140917 : get_status must not store the whole data_record
      // because that would prevent the form to actually reload
      // when set_status is called after a child window closed.
      
      var tp = this.items.get(0);
      if (tp instanceof Ext.TabPanel) {
        st.active_tab = tp.getActiveTab();
      }
      st.param_values = this.status_param_values;
      return st;
  },

  /* FormPanel */
  set_status : function(status, rp){
    this.requesting_panel = Ext.getCmp(rp);
    // console.log('20140917 FormPanel.set_status()', status);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_param_values(status.param_values);
    if (status.base_params) this.set_base_params(status.base_params);
    var tp = this.items.get(0);
    if (tp instanceof Ext.TabPanel) {
      if (status.active_tab) {
        //~ console.log('20111201 active_tab',this.active_tab,this.items.get(0));
        //~ tp.activeTab = status.active_tab;
        tp.setActiveTab(status.active_tab);
        //~ this.main_item.items.get(0).activate(status.active_tab);
      } else {
        if (! status.data_record) {  // 20141206
            tp.setActiveTab(0);
        }
      }
    }
    
    if (status.data_record) {
      /* defer because set_window_title() didn't work otherwise */
      // 20140421 removed defer for bughunting to simplify side effects
      // this.set_current_record.createDelegate(
      //     this, [status.data_record]).defer(100);
      this.set_current_record(status.data_record);
      //~ return;
    } else if (status.record_id != undefined) { 
      /* possible values include 0 and null, 0 being a valid record id, 
      null the equivalent of undefined
      */
      this.load_record_id(status.record_id);
    } else {
      this.set_current_record(undefined);
    }
    // this.init_focus()
  }
  ,get_base_params : function() {  /* FormPanel */
    // needed for insert_action
    var p = Ext.apply({}, this.base_params);
    Lino.insert_subst_user(p);
    return p;
  }
  ,set_base_params : function(p) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    delete p['query'] // 20120725
    Ext.apply(this.base_params,p);
    if (this.record_selector) {
        var store = this.record_selector.getStore();
        for (k in p) store.setBaseParam(k,p[k]);
        delete this.record_selector.lastQuery;
        //~ console.log("20120725 record_selector.setBaseParam",p)
    }
  }
  ,clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  }
  ,set_base_param : function(k,v) {
    this.base_params[k] = v;
  }
  ,after_delete : function() {
    if (this.current_record.navinfo.next)
      this.moveNext();
    else if (this.current_record.navinfo.prev)
      this.movePrev();
    else 
      this.abandon();
  }
  ,moveFirst : function() {this.goto_record_id(
      this.current_record.navinfo.first)}
  ,movePrev : function() {this.goto_record_id(
      this.current_record.navinfo.prev)}
  ,moveNext : function() {this.goto_record_id(
      this.current_record.navinfo.next)}
  ,moveLast : function() {this.goto_record_id(
      this.current_record.navinfo.last)}
  
  ,refresh : function(unused) { 
      this.refresh_with_after();
  }
  /* FormPanel */
  ,refresh_with_after : function(after) { 
    // console.log('20140917 Lino.FormPanel.refresh_with_after()',this);
    if (this.current_record) {
        this.load_record_id(this.current_record.id, after);
    } else {
        this.set_current_record(undefined, after);
    }
  }
  
  ,do_when_clean : function(auto_save, todo) {
    var this_ = this;
    if (this.form.isDirty()) {
        // console.log('20140421 do_when_clean : form is dirty')
        if (auto_save) {
            this_.save(todo);
        } else {
          //~ console.log('20111217 do_when_clean() form is dirty',this.form);
          var config = {title:"Confirmation"};
          config.buttons = Ext.MessageBox.YESNOCANCEL;
          config.msg = "Save changes to current record ?";
          config.fn = function(buttonId,text,opt) {
            //~ console.log('do_when_clean',buttonId)
            if (buttonId == "yes") {
                //~ Lino.submit_detail(this_,undefined,todo);
                //~ this_.containing_window.save(todo);
                this_.save(todo);
            } else if (buttonId == "no") { 
              todo();
            }
          }
        }
        Ext.MessageBox.show(config);
    }else{
      // console.log('20140421 do_when_clean : now!')
      todo();
    }
  }
  
  ,goto_record_id : function(record_id) {
    // console.log('20140917 Lino.FormPanel.goto_record_id()',record_id);
    //~ var this_ = this;
    //~ this.do_when_clean(function() { this_.load_record_id(record_id) }
    this.do_when_clean(
        true, this.load_record_id.createDelegate(this, [record_id]));
  }
  
  ,load_record_id : function(record_id, after) {
    var this_ = this;
    var p = Ext.apply({}, this.get_base_params());
    if (this.action_name)
        p.an = this.action_name;
    p.rp = this.getId();
    p.fmt = 'json';
    this.add_param_values(p);
    if (this.loadMask) this.loadMask.show();
    Ext.Ajax.request({ 
      waitMsg: 'Loading record...',
      method: 'GET',
      params: p,
      scope: this,
      url: this.get_record_url(record_id),
      success: function(response) {   
        // todo: convert to Lino.action_handler.... but result 
        if (this.loadMask) this.loadMask.hide();
        if (response.responseText) {
          var rec = Ext.decode(response.responseText);
          // console.log('20140917 load_record_id success', rec);
          this.set_param_values(rec.param_values);
          this.set_current_record(rec, after);
        }
      },
      failure: Lino.ajax_error_handler(this)
    });
  }

  ,abandon : function () {
    Ext.MessageBox.alert('Note',
      "No more records to display. Detail window has been closed.");
    Lino.close_window();
  }
  
  ,set_current_record : function(record, after) {
    if (this.record_selector) {
        this.record_selector.clearValue();
        // e.g. InsertWrapper FormPanel doesn't have a record_selector
    }
    this.current_record = record;
    if (record) {
      this.enable();
      this.form.my_loadRecord(record.data);
      this.set_window_title(record.title);
      //~ this.getBottomToolbar().enable();
      var da = record.data.disabled_actions;
      if (da) {
          //~ console.log('20120528 disabled_actions =',da,this.getBottomToolbar());
          //~ 20121016 this.getBottomToolbar().items.each(function(item,index,length){
          var tb = this.getTopToolbar();
          if (tb) tb.items.each(function(item,index,length){
              //~ console.log('20120528 ',item.itemId,'-->',da[item.itemId]);
              if (da[item.itemId]) item.disable(); else item.enable();
          });
      };
      if (this.disable_editing | record.data.disable_editing) {
          //~ console.log("20120202 disable_editing",record.title);
          this.form.items.each(function(cmp){
            if (!cmp.always_enabled) cmp.disable();
          },this);
      } else {
          this.form.items.each(function(cmp){
            //~ console.log("20120202",cmp);
            if (record.data.disabled_fields[cmp.name]) cmp.disable();
            else cmp.enable();
          },this);
        
          //~ if (record.data.disabled_fields) {
              //~ for (i = 0; i < record.data.disabled_fields.length; i++) {
                  //~ var flds = this.find('name',record.data.disabled_fields[i]);
                  //~ if (flds.length == 1) { 
                    //~ flds[0].disable(); 
                  //~ }
              //~ }
          //~ }
      };
      if (this.first) {
        if (record.navinfo  && ! this.hide_navigator) {
          this.first.setDisabled(!record.navinfo.first);
          this.prev.setDisabled(!record.navinfo.prev);
          this.next.setDisabled(!record.navinfo.next);
          this.last.setDisabled(!record.navinfo.last);
          this.displayItem.setText(record.navinfo.message);
        } else {
          this.first.setDisabled(true);
          this.prev.setDisabled(true);
          this.next.setDisabled(true);
          this.last.setDisabled(true);
        }
      }
    } else {
      if (this.form.rendered) 
        this.form.reset(); /* FileUploadField would fail when resetting a non-rendered form */
      //~ this.disable();
      //~ this.getBottomToolbar().disable();
      this.form.items.each(function(cmp){
        cmp.disable();
      },this);
      this.set_window_title(this.empty_title);
      //~ this.containing_window.window.setTitle(this.empty_title);
      if (!this.hide_navigator) {
        this.first.disable();
        this.prev.disable();
        this.next.disable();
        this.last.disable();
      }
    }
    // console.log('20140917 gonna call before_row_edit', record);
    this.before_row_edit(record);
    // console.log('20140917 gonna call after', after);
    if (after) after();
  },
  
  /* FormPanel */
  before_row_edit : function(record) {},
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.refresh();
  },
  
  get_selected : function() { return [ this.current_record ] },
  get_current_record : function() {  
    //~ console.log(20100714,this.current_record);
    return this.current_record 
  },
  
  get_permalink_url : function() {
      var rec = this.get_current_record();
      if (rec && ! rec.phantom && rec.id != -99998)
          return '/api' 
              + this.ls_url + '/' + rec.id;
      return '/api' + this.ls_url;
    
  },
  add_param_tab : function(p) {
    var main = this.items.get(0);
    if (main.activeTab) {
      var tab = main.items.indexOf(main.activeTab);
      //~ console.log('main.activeTab',tab,main.activeTab);
      if (tab) p.tab = tab;
    }
  },
  get_permalink_params : function() {
    var p = {};
    //~ var p = {an:'detail'};
    if (this.action_name)
        p.an = this.action_name;
    this.add_param_tab(p)
    this.add_param_values(p)
    return p;
  }
  
  ,validate_form : function() {  // not used. see actions.ValidateForm
      // var ov = {};
      // this.form.items.each(function(f){
      //     ov[f.name] = f.originalValue
      // });

      // console.log('20140509 FormPanel.validate_form', ov);
      // var after = function() { 
      //     this.form.items.each(function(f){
      //         f.originalValue = ov[f.name];
      //     });
      // }
      // this.save2(null, 'validate', after);
      this.save2(null, 'validate');
  }

  /* Lino.FormPanel */
  ,save : function(after) {
    var action_name = this.save_action_name;
    if (!action_name) 
        action_name = this.action_name;
    // console.log('20140503 FormPanel.save', action_name);
    this.save2(after, action_name);
  }

  ,save2 : function(after, action_name) {
    var rec = this.get_current_record();
    if (!rec) { 
        Lino.notify("Sorry, no current record."); 
        return; 
    }
    var panel = this;
    if (this.has_file_upload) this.form.fileUpload = true;
    //~ console.log('FormPanel.save()',rec);
    this.loadMask.show();
    var p = {};
    Ext.apply(p, this.get_base_params());
    p.rp = this.getId();
    p.an = action_name;
    this.add_param_tab(p)
    var submit_config = {
        params: p, 
        scope: this,
        success: function(form, action) {
          this.loadMask.hide();
          Lino.notify(action.result.message);
          Lino.handle_action_result(this, action.result, after);
        },
        failure: function(form,action) { 
          this.loadMask.hide();
          Lino.on_submit_failure(form, action);
        },
        clientValidation: true
    };
    if (rec.phantom) {  // it's a new record
      Ext.apply(submit_config, {
        url: '/api' + this.ls_url,
        method: 'POST'
      });
    } else {  // submit on existing row
      Ext.apply(submit_config, {
        url: '/api' 
              + this.ls_url + '/' + rec.id,
        method: 'PUT'
      })
    }
    this.form.submit(submit_config);
  }
  
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
      // console.log("20140424");
      // this.save(null, true, this.save_action_name);
      this.save();
  }
  ,config_containing_window : function(wincfg) { 

      // Note that defaultButton means: which component should receive
      // focus when Window is focussed.  If no defaultButton set,
      // specify the first form field.

      if (!wincfg.defaultButton) this.getForm().items.each(function(f){
          if(f.isFormField){ 
              wincfg.defaultButton = f;
              // console.log("20140205 defaultButton", f);
              return false;
          }
      });

      wincfg.keys = [
          {
              key: Ext.EventObject.ENTER,
              scope:this,
              fn: function(k, e) {
                  if(e.target.type === 'textarea' && !e.ctrlKey) {
                      return true;
                  }
                  this.on_ok();
              }
          },
          { key: Ext.EventObject.ESCAPE, fn: this.on_cancel, scope:this }
          // ,{ key: 's', ctrl: true, 
          //    stopEvent: true,
          //    fn: this.on_ctrl_s, scope:this }
      ]
  }
  
});



Lino.getRowClass = function(record, rowIndex, rowParams, store) {
    //~ console.log(20130816,record);
    //~ return 'x-grid3-row-green';
    //~ return record.data.row_class + ' auto-height';
    return record.data.row_class;
  //~ if (true) {
      //~ return 'x-grid3-row-red';
  //~ }
  //~ if (record.phantom) {
    //~ console.log(20101009,record);
    //~ rowParams.bodyStyle = "color:red;background-color:blue";
    //~ return 'lino-phantom-row';
    //~ }
  //~ console.log('20101009 not a phantom:',record);
  //~ return '';
}

//~ FOO = 0;



Lino.GridStore = Ext.extend(Ext.data.ArrayStore,{ 
  autoLoad: false
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
    if (!options) options = {};
    if (!options.params) options.params = {};
    options.params.fmt = 'json';
    options.params.rp = this.grid_panel.getId();
    Lino.insert_subst_user(options.params); // since 20121016
      
    var start = this.grid_panel.start_at_bottom ? -1 : 0;
    if (this.grid_panel.hide_top_toolbar) {
        //~ console.log("20120206 GridStore.load() toolbar is hidden");
        options.params.start = start;
        if (this.grid_panel.preview_limit) {
          options.params.limit = this.grid_panel.preview_limit;
        }
    } else {
        var ps = this.grid_panel.calculatePageSize();
        if (!ps) {
          // console.log("GridStore.load() failed to calculate pagesize");
          return false;
        } 
        options.params.limit = ps;
      
        this.grid_panel.getTopToolbar().pageSize =  ps;
        if (options.params.start == undefined)
            // if (start != -1) 
            //     start = this.grid_panel.getTopToolbar().cursor
            options.params.start = start;
      
        // console.log("20141108 GridStore.load() ", options.params);
    }
      
    this.grid_panel.add_param_values(options.params);
    //~ Lino.insert_subst_user(options.params);
    //~ console.log("20120814 GridStore.load()",options.params,this.baseParams);
    return Lino.GridStore.superclass.load.call(this, options);
  }
  // ,insert : function(index, records) {
  //   return Ext.data.Store.prototype.insert.call(this, index, records)
    // return Lino.GridStore.superclass.insert.call(this, index, records);
  // }
});

Lino.get_current_grid_config = function(panel) {
    return panel.get_current_grid_config();
}


// Like the default value for GridView.cellTpl but adds a class "lino-auto-height"
Lino.auto_height_cell_template = new Ext.Template(
'<td class="x-grid3-col x-grid3-cell x-grid3-td-{id} {css}" style="{style}" tabIndex="0" {cellAttr}>',
    '<div class="lino-auto-height x-grid3-cell-inner x-grid3-col-{id}" unselectable="on" {attr}>{value}</div>',
'</td>'
);

Lino.GridPanel = Ext.extend(Ext.grid.EditorGridPanel, Lino.MainPanel);
Lino.GridPanel = Ext.extend(Lino.GridPanel, Lino.PanelMixin);
Lino.GridPanel = Ext.extend(Lino.GridPanel, {
  quick_search_text : '',
  start_at_bottom : false,
  is_searching : false,
  disabled_in_insert_window : true,
  clicksToEdit:2,
  enableColLock: false,
  autoHeight: false,
  params_panel_hidden : false,
  preview_limit : undefined, 
  //~ loadMask: true,
  //~ viewConfig: {
          //~ getRowClass: Lino.getRowClass,
          //~ emptyText:"$_('No data to display.')"
        //~ },
        
        
  loadMask: {msg:"Please wait..."},
  
  constructor : function(config){

    config.plugins = [new Lino.GridFilters()];
    
    
    Lino.GridPanel.superclass.constructor.call(this,config);
    
    //~ if (this.containing_window) {
        //~ console.log("20111206 install refresh");
        //~ this.containing_window.on('show',this.refresh,this);
    //~ }
    
  },
  
  init_containing_window : function(win) { 
    //~ console.log("20111206 install refresh");
    //~ win.on('show',this.refresh,this);
  }

  ,handle_key_event : function(e) { 
    // console.log("20140514 handle_key_event", e, this.keyhandlers);
    var h = this.keyhandlers[e.keyCode];
    if (h) {
      h(this);
      e.stopEvent();
    }
  }
  
  ,initComponent : function(){
    
    /* 
    Problem 20111206:
    When a GridPanel is the main item of the window, then it doesn't 
    have it's own header but uses the window's header bar.
    We must do this in initComponent because e.g. in beforerender 
    it's already to late: a header element has been created because 
    there was a title.
    But Lino.Window adds itself as `this.containing_window` 
    only after the GridPanel has been initialized.
    Workaround is to generate a line "params.containing_window = true;" 
    in the handler function.
    */ 
    if (this.is_main_window) {
        //~ console.log(20111206, 'delete title',this.title,'from',this);
        this.tools = undefined;  
        this.title = undefined;  /* simply deleting it 
          isn't enough because that would only 
          unhide the title defined in some base class. */
    } 
    //~ else console.log(20111206, 'dont delete title',this.title,'from',this);
    
    /* e.g. when slave gridwindow called from a permalink */
    //~ if (this.base_params) Ext.apply(bp,this.base_params);  
    
    var proxy = new Ext.data.HttpProxy({ 
      // 20120814 
      url: '/api' + this.ls_url
      ,method: "GET"
      //~ ,url: ADMIN_URL + '/restful' + this.ls_url
      //~ ,restful: true 
      //~ ,listeners: {load:on_proxy_load} 
      //~ ,listeners: {write:on_proxy_write} 
    });
    //~ config.store = new Ext.data.JsonStore({ 
    //~ this.store = new Ext.data.ArrayStore({ 
    this.store = new Lino.GridStore({ 
      grid_panel: this
      ,listeners: { exception: Lino.on_store_exception }
      ,remoteSort: true
      ,totalProperty: "count"
      ,root: "rows"
      //~ ,id: "id" 
      ,proxy: proxy
      //~ autoLoad: this.containing_window ? true : false
      ,idIndex: this.pk_index
      //~ ,baseParams: bp
      ,fields: this.ls_store_fields
      ,idProperty: this.ls_id_property 
      // 20120814
      //~ ,writer : new Ext.data.JsonWriter({
        //~ writeAllFields: false
        //~ ,listful: true
      //~ })
      //~ ,restful : true
    });
      
    //~ console.log('config.pk_index',config.pk_index,config.store),
    delete this.ls_store_fields;
      
    var this_ = this;
    //~ var grid = this;
    this.store.on('load', function() {
        //~ console.log('20120814 GridStore.on(load)',this_.store);
        this_.set_param_values(this_.store.reader.arrayData.param_values);
        //~ this_.set_status(this_.store.reader.arrayData.status);
        //~ 20120918
        this.getView().getRowClass = Lino.getRowClass;
        
        if (this_.store.reader.arrayData.no_data_text) {
            //~ this.viewConfig.emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().refresh();
        }
        if (this_.containing_window)
            this_.set_window_title(this_.store.reader.arrayData.title);
            //~ this_.containing_window.setTitle(this_.store.reader.arrayData.title);
        if (!this.is_searching) { // disabled 20121025: quick_search_field may not lose focus
          this.is_searching = false;
          if (this_.selModel.getSelectedCell){
              if (this_.getStore().getCount()) // there may be no data
                  this_.selModel.select(0,0); 
          } else {
              this_.selModel.selectFirstRow();
              this_.getView().focusEl.focus();
          }
        } 
        //~ else console.log("is_searching -> no focussing");
        //~ var t = this.getTopToolbar();
        //~ var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
        //~ this.quick_search_field.focus(); // 20121024
      }, this
    );
    var actions = Lino.build_buttons(this, this.ls_bbar_actions);
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar, this.cmenu = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ this.cmenu = new Ext.menu.Menu({items: config.bbar});
    delete this.ls_bbar_actions
    if (actions) {
        this.cmenu = actions.cmenu;
        this.keyhandlers = actions.keyhandlers;
    }
    
    if (!this.hide_top_toolbar) {  
      var tbar = [ 
        this.quick_search_field = new Ext.form.TextField({ 
          //~ fieldLabel: "Search"
          listeners: { 
            scope:this_
            //~ ,change:this_.search_change
            
            ,render: Lino.quicktip_renderer("Quick Search","Enter a text to use as quick search filter")
            
            //~ ,keypress: this.search_keypress 
            ,blur: function() { this.is_searching = false}
          }
          ,validator:function(value) { return this_.search_validate(value) }
          //~ ,tooltip: "Enter a quick search text, then press TAB"
          //~ value: text
          //~ scope:this, 
          //~ ,enableKeyEvents: true
          //~ listeners: { keypress: this.search_keypress }, 
          //~ id: "seachString" 
      })];
      tbar = this.add_params_panel(tbar);
      var menu = [];
      var set_gc = function(index) {
        return function() {
          //~ console.log('set_gc() 20100812');
          this.getColumnModel().setConfig(
              this.apply_grid_config(index,this.ls_grid_configs,this.ls_columns));
        }
      }
      for (var i = 0; i < this.ls_grid_configs.length;i++) {
        var gc = this.ls_grid_configs[i];
        menu.push({text:gc.label,handler:set_gc(i),scope:this})
      }
      if(menu.length > 1) {
        tbar = tbar.concat([
          { text:"View",
            menu: menu,
            tooltip:"Select another view of this report"
          }
        ]);
      }
      
      if (actions) {
        tbar = tbar.concat(actions.bbar);
          //~ this.bbar = actions.bbar;
      }
      
      this.tbar = new Ext.PagingToolbar({ 
        store: this.store, 
        prependButtons: true, 
        //~ pageSize: this.page_length, 
        pageSize: 1, 
        displayInfo: true, 
        beforePageText: "Page",
        afterPageText: "of {0}",
        displayMsg: "Displaying {0} - {1} of {2}",
        firstText: "First page",
        lastText: "Last page",
        prevText: "Previous page",
        nextText: "Next page",
        items: tbar
      });
    }
      
    if (this.cell_edit) {
      this.selModel = new Ext.grid.CellSelectionModel()
      this.get_selected = function() {
        //~ console.log(this.getSelectionModel().selection);
        if (this.selModel.selection)
            return [ this.selModel.selection.record ];
        return [this.store.getAt(0)];
      };
      this.get_current_record = function() { 
        if (this.getSelectionModel().selection) 
          return this.selModel.selection.record;
        return this.store.getAt(0);
      };
    } else { 
      this.selModel = new Ext.grid.RowSelectionModel() 
      this.get_selected = function() {
        var sels = this.selModel.getSelections();
        if (sels.length == 0) sels = [this.store.getAt(0)];
        return sels
      };
      this.get_current_record = function() { 
        var rec = this.selModel.getSelected();
        if (rec == undefined) rec = this.store.getAt(0);
        return rec
      };
    };
    this.columns  = this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns);
    
    Lino.GridPanel.superclass.initComponent.call(this);
    
    this.on('resize', function(){
      //~ console.log("20120213 resize",arguments)
      this.refresh();
      },this);
    this.on('viewready', function(){
      //~ console.log("20120213 resize",arguments);
      this.view_is_ready = true;
      this.refresh(); // removed 20130911
      },this);
    this.on('afteredit', this.on_afteredit); // 20120814
    this.on('beforeedit', this.on_beforeedit);
    this.on('beforeedit',function(e) { this.before_row_edit(e.record)},this);
    if (this.cell_edit) {
        this.on('cellcontextmenu', Lino.cell_context_menu, this);
    } else {
        this.on('rowcontextmenu', Lino.row_context_menu, this);
    }
    //~ this.on('contextmenu', Lino.grid_context_menu, this);
    
    delete this.cell_edit;
    
  },
  
  //~ onResize : function(){
      //~ console.log("20120206 GridPanel.onResize",arguments);
      //~ Lino.GridPanel.superclass.onResize.apply(this, arguments);
      //~ this.refresh();
  //~ },
  
  
  get_status : function(){
    var st = { base_params : this.get_base_params()};
    if (!this.hide_top_toolbar) {
        st.current_page = this.getTopToolbar().current;
    }
    st.param_values = this.status_param_values;
    //~ console.log("20120213 GridPanel.get_status",st);
    return st;
  },
  
  /* 
  Lino.GridPanel.set_status() 
  */
  set_status : function(status, rp){
    this.requesting_panel = Ext.getCmp(rp);
    // console.log("20140527 GridPanel.set_status", status);
    this.clear_base_params();
    if (status == undefined) status = {base_params:{}};
    this.set_param_values(status.param_values);
    if (status.base_params) { 
      this.set_base_params(status.base_params);
    }
    if (status.show_params_panel != undefined) {
        if (this.toggle_params_panel_btn) {
            //~ this.toggle_params_panel_btn.toggle(status.show_params_panel=='true');
            this.toggle_params_panel_btn.toggle(status.show_params_panel);
        }
    }
    if (!this.hide_top_toolbar) {
      //~ console.log("20120213 GridPanel.getTopToolbar().changePage",
          //~ status.current_page || 1);
      this.getTopToolbar().changePage(status.current_page || 1);
    }
    //~ this.fireEvent('resize');
    //~ this.refresh.defer(100,this); 
    //~ this.onResize.defer(100,this); 
    //~ this.refresh(); 
    //~ this.doLayout(); 
    //~ this.onResize(); 
    //~ this.store.load();
  },
  
  refresh : function(unused) { 
    this.refresh_with_after();
  },
  /* GridPanel */
  refresh_with_after : function(after) { 
    // console.log('20140504 Lino.GridPanel.refresh '+ this.store.proxy.url);
    //~ var bp = { fmt:'json' }
    if (! this.view_is_ready) return;
    
    if (this.containing_panel) {
        //~ Ext.apply(p,this.master_panel.get_master_params());
        //~ Ext.apply(options.params,this.containing_panel.get_master_params());
        this.set_base_params(this.containing_panel.get_master_params());
        // 20130911
        if (!this.store.baseParams.mk) {  
            return;
        }
    }
    
    //~ console.log('20130911 Lino.GridPanel.refresh_with_after',this.containing_panel.get_master_params());
    
    var options = {};
    if (after) {
        options.callback = function(r,options,success) {if(success) after()}
    }
      
    //~ if (!this.rendered) {
        //~ console.log("20120206 GridPanel.refresh() must wait until rendered",options);
        //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
        //~ return;
    //~ }
    
    this.store.load(options);
  },
  
  /* pageSize depends on grid height (Trying to remove scrollbar)
  Thanks to 
  - Christophe Badoit on http://www.sencha.com/forum/showthread.php?82647
  - http://www.sencha.com/forum/archive/index.php/t-37231.html
  */
  calculatePageSize : function(second_attempt) {
    //~ if (!this.rendered) { 
    if (!this.view_is_ready) { 
      //~ console.log('Cannot calculatePageSize() : not rendered');
      return false; }
    //~ if (!this.isVisible()) { 
      //~ console.log('calculatePageSize : not visible');
      //~ return false; }
      
    //~ console.log('getFrameHeight() is',this.getFrameHeight());
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('mainBody.getHeight() is',this.getView().mainBody.getHeight());
    //~ console.log('getInnerHeight() is',this.getInnerHeight());
    //~ console.log('getHeight() is',this.getHeight());
    //~ console.log('el.getHeight() is',this.getEl().getHeight());
    //~ console.log('getGridEl().getHeight() is',this.getGridEl().getHeight());
    //~ console.log('getOuterSize().height is',this.getOuterSize().height);
    //~ console.log('getBox().height is',this.getBox().height);
    //~ console.log('getResizeEl.getHeight() is',this.getResizeEl().getHeight());
    //~ console.log('getLayoutTarget().getHeight() is',this.getLayoutTarget().getHeight());
      
    //~ var rowHeight = 52; // experimental value
    var row = this.view.getRow(0);
    if (row) {
      //~ console.log('20120213 yes');
      var rowHeight = Ext.get(row).getHeight();
    } else {
        //~ var rowHeight = this.getFrameHeight();
        //~ var rowHeight = 10; // reasonably smallest approximative value
        //~ There is no data yet. Construct a fake row and get its height
        var Element = Ext.Element;
        var gv = this.view;
        var fakeBody = new Element(Element.fly(gv.scroller).child('div.x-grid3-body'));
        var rowTemplate = gv.templates.row;
        var cellTemplate = gv.templates.cell;
        var tstyle  = 'width:' + gv.getGridInnerWidth() + 'px;';
        var cells = cellTemplate.apply({value:'&#160;'});
        var markup = rowTemplate.apply({
                tstyle: tstyle,
                cols  : 1,
                cells : cells,
                alt   : ''
            });        
        fakeBody.dom.innerHTML = gv.templates.body.apply({rows: markup});
        var row = fakeBody.dom.childNodes[0];
        var rowHeight = Ext.get(row).getHeight();
    }
    //~ console.log('rowHeight is ',rowHeight,this,caller);
    //~ this.getView().syncScroll();
    //~ this.getView().initTemplates();
    var height = this.getView().scroller.getHeight();
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('getInnerHeight() - getFrameHeight() is',
      //~ this.getInnerHeight(), '-',
      //~ this.getFrameHeight(), '=',
      //~ this.getInnerHeight() - this.getFrameHeight());
    //~ var height = this.getView().mainBody.getHeight();
    //~ var height = this.getView().mainWrap.getHeight();
    //~ var height = this.getView().resizeMarker.getHeight();
    //~ this.syncSize();
    //~ var height = this.getInnerHeight() - this.getFrameHeight();
    //~ var height = this.getHeight() - this.getFrameHeight();
    height -= Ext.getScrollBarWidth(); // leave room for a possible horizontal scrollbar... 
    //~ height -= this.getView().scrollOffset;
    var ps = Math.floor(height / rowHeight);
    //~ console.log('20130816 calculatePageSize():',height,'/',rowHeight,'->',ps);
    ps -= 1; // leave room for a possible phantom row
    //~ return (ps > 1 ? ps : false);
    if (ps > 1) return ps;
    //~ console.log('calculatePageSize() found less than 1 row:',height,'/',rowHeight,'->',ps);
    //~ foo.bar = baz; // 20120213
    return 5; // preview_limit
    //~ if (second_attempt) {
        //~ console.log('calculatePageSize() abandons after second attempt:',
          //~ height,'/',rowHeight,'->',ps);
      //~ return 5;
    //~ }
    //~ return this.calculatePageSize.defer(500,this,[true]);
  },
  
  onCellDblClick : function(grid, row, col){
      //~ console.log("20120307 onCellDblClick",this,grid, row, col);
      if (this.ls_detail_handler) {
          //~ Lino.notify('show detail');
          Lino.show_detail(this);
          return false;
      }else{
        //~ console.log('startEditing');
        this.startEditing(row,col);
      }
  }
  ,get_base_params : function() {  /* Lino.GridPanel */
    var p = Ext.apply({}, this.store.baseParams);
    Lino.insert_subst_user(p);
    return p;
  },
  set_base_params : function(p) {
    //~ console.log('20130911 GridPanel.set_base_params',p)
    for (k in p) this.store.setBaseParam(k,p[k]);
    //~ this.store.baseParams = p;
    if (this.quick_search_field)
      this.quick_search_field.setValue(p.query || "");
    //~ if (p.param_values) 
        //~ this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.store.baseParams = {};
      Lino.insert_subst_user(this.store.baseParams);
  },
  set_base_param : function(k,v) {
    this.store.setBaseParam(k,v);
  },
  
  //~ get_permalink_params : function() {
    //~ var p = {};
    //~ return p;
  //~ },
  
  before_row_edit : function(record) {},
    
  //~ search_keypress : function(){
    //~ console.log("2012124 search_keypress",arguments);
  //~ },
  search_validate : function(value) {
    if (value == this.quick_search_text) return true;
    this.is_searching = true;
    //~ console.log('search_validate',value)
    this.quick_search_text = value;
    this.set_base_param('query',value); 
    //~ this.getTopToolbar().changePage(1);
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
    return true;
  },
  
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
  },
  
  apply_grid_config : function(index,grid_configs,rpt_columns) {
    //~ var rpt_columns = this.ls_columns;
    var gc = grid_configs[index];    
    //~ console.log('apply_grid_config() 20100812',name,gc);
    this.gc_name = index;
    if (gc == undefined) {
      return rpt_columns;
      //~ config.columns = config.ls_columns;
      //~ return;
    } 
    //~ delete config.ls_filters
    
    //~ console.log(20100805,config.ls_columns);
    var columns = Array(gc.columns.length);
    for (var j = 0; j < rpt_columns.length;j++) {
      var col = rpt_columns[j];
      for (var i = 0; i < gc.columns.length; i++) {
        if (col.dataIndex == gc.ci[i]) {
          col.width = gc.cw[i];
          col.hidden = gc.ch[i];
          columns[i] = col;
          break;
        }
      }
    }
    
    //~ var columns = Array(rpt_columns.length);
    //~ for (var i = 0; i < rpt_columns.length; i++) {
      //~ columns[i] = rpt_columns[gc.columns[i]];
      //~ columns[i].width = gc.widths[i];
    //~ }
    
    //~ if (gc.hidden_cols) {
      //~ for (var i = 0; i < gc.hidden_cols.length; i++) {
        //~ var hc = gc.hidden_cols[i];
        //~ for (var j = 0; j < columns.length;j++) {
          //~ var col = columns[j];
          //~ if (col.dataIndex == hc) {
            //~ col.hidden = true;
            //~ break
          //~ }
        //~ }
      //~ }
    //~ }
    if (gc.filters) {
      //~ console.log(20100811,'config.ls_filters',config.ls_filters);
      //~ console.log(20100811,'config.ls_grid_config.filters',config.ls_grid_config.filters);
      for (var i = 0; i < gc.filters.length; i++) {
        var fv = gc.filters[i];
        for (var j = 0; j < columns.length;j++) {
          var col = columns[j];
          if (col.dataIndex == fv.field) {
            //~ console.log(20100811, f,' == ',fv);
            if (fv.type == 'string') {
              col.filter.value = fv.value;
              //~ if (fv.comparison !== undefined) f.comparison = fv.comparison;
            } else {
              //~ console.log(20100811, fv);
              col.filter.value = {};
              col.filter.value[fv.comparison] = fv.value;
            }
            break;
          }
        };
      }
    }
    
    return columns;
    //~ config.columns = cols;
    //~ delete config.ls_columns
  },
  
  get_current_grid_config : function () {
    var cm = this.getColumnModel();
    var widths = Array(cm.config.length);
    var hiddens = Array(cm.config.length);
    //~ var hiddens = Array(cm.config.length);
    var columns = Array(cm.config.length);
    //~ var columns = Array(cm.config.length);
    //~ var hidden_cols = [];
    //~ var filters = this.filters.getFilterValues();
    var p = this.filters.buildQuery(this.filters.getFilterData())
    for (var i = 0; i < cm.config.length; i++) {
      var col = cm.config[i];
      columns[i] = col.dataIndex;
      //~ hiddens[i] = col.hidden;
      widths[i] = col.width;
      hiddens[i] = col.hidden;
      //~ if (col.hidden) hidden_cols.push(col.dataIndex);
    }
    //~ p['hidden_cols'] = hidden_cols;
    p.cw = widths;
    p.ch = hiddens;
    p.ci = columns;
    //~ p['widths'] = widths;
    //~ p['hiddens'] = hiddens;
    //~ p['columns'] = columns;
    p['name'] = this.gc_name;
    //~ var gc = this.ls_grid_configs[this.gc_name];
    //~ if (gc !== undefined) 
        //~ p['label'] = gc.label
    //~ console.log('20100810 save_grid_config',p);
    return p;
  },
  
  unused_manage_grid_configs : function() {
    var data = [];
    for (k in this.ls_grid_configs) {
      var v = this.ls_grid_configs[k];
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i)
    }
    if (this.ls_grid_configs[this.gc_name] == undefined) {
      var v = this.get_current_grid_config();
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i);
    }
    //~ console.log(20100811, data);
    var main = new Ext.grid.GridPanel({
      store: new Ext.data.ArrayStore({
        idIndex:0,
        fields:['name','columns','hidden_cols','filters'],
        autoDestroy:true,
        data: data}),
      //~ autoHeight:true,
      selModel: new Ext.grid.RowSelectionModel(),
      listeners: { 
        rowdblclick: function(grid,rowIndex,e) {
          console.log('row doubleclicked',grid, rowIndex,e);
        },
        rowclick: function(grid,rowIndex,e) {
          console.log('row clicked',grid, rowIndex,e);
        }
      },
      columns: [ 
        {dataIndex:'name',header:'Name'}, 
        {dataIndex:'columns',header:'columns'}, 
        {dataIndex:'hidden_cols',header:'hidden columns'}, 
        {dataIndex:'filters',header:'filters'} 
      ]
    });
    var win = new Ext.Window({title:'GridConfigs Manager',layout:'fit',items:main,height:200});
    win.show();
  },
  
  unused_edit_grid_config : function(name) {
    gc = this.ls_grid_configs[name];
    var win = new Ext.Window({
      title:'Edit Grid Config',layout:'vbox', 
      //~ layoutConfig:'stretch'
      items:[
        {xtype:'text', value: gc.name},
        {xtype:'text', value: gc.columns},
        {xtype:'text', value: gc.hidden_cols},
        {xtype:'text', value: gc.filters}
      ]
    });
    win.show();
  },
  
  unused_save_grid_config : function () {
    //~ console.log('TODO: save_grid_config',this);
    //~ p.column_widths = Ext.pluck(this.colModel.columns,'width');
    var a = { 
      params:this.get_current_grid_config(), 
      method:'PUT',
      url:'/grid_config' + this.ls_url,
      success: Lino.action_handler(this),
      scope: this,
      failure: Lino.ajax_error_handler(this)
    };
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(a);
    //~ Lino.do_action(this,a);
  },
  
  on_beforeedit : function(e) {
    //~ console.log('20130128 GridPanel.on_beforeedit()',e,e.record.data.disable_editing);
    if(this.disable_editing | e.record.data.disable_editing) {
      e.cancel = true;
      Lino.notify("This record is disabled");
      return;
    }
    if(e.record.data.disabled_fields && e.record.data.disabled_fields[e.field]) {
      e.cancel = true;
      Lino.notify("This field is disabled");
      return;
    }
    //~ if (e.record.data.disabled_fields) {
      //~ for (i in e.record.data.disabled_fields) {
        //~ if(e.record.data.disabled_fields[i] == e.field) {
          //~ e.cancel = true;
          //~ Lino.notify(String.format('Field "{0}" is disabled for this record',e.field));
          //~ return
        //~ }
      //~ }
    //~ }
  },
  save_grid_data : function() {
      //~ console.log("20120814 save_grid_data");
      this.getStore().commitChanges();
  },
  on_afteredit : function(e) {
    /*
    e.grid - The grid that fired the event
    e.record - The record being edited
    e.field - The field name being edited
    e.value - The value being set
    e.originalValue - The original value for the field, before the edit.
    e.row - The grid row index
    e.column - The grid column index
    */
    var p = {};
    // console.log('20140403 afteredit: ',e.record);
    //~ console.log('20101130 value: ',e.value);
    //~ var p = e.record.getChanges();
    //~ console.log('20101130 getChanges: ',e.record.getChanges());
    //~ this.before_row_edit(e.record);

    for(k in e.record.getChanges()) {
        var v = e.record.get(k);
    //~ for(k in e.record.modified) {
        //~ console.log('20101130',k,'=',v);
        //~ var cm = e.grid.getColumnModel();
        //~ var di = cm.getDataIndex(k);
        var f = e.record.fields.get(k);
        //~ console.log('20101130 f = ',f);
        //~ var v = e.record.get(di);
        if (f.type.type == 'date') {
            p[k] = Ext.util.Format.date(v, f.dateFormat);
        }else{
            p[k] = v;
            var v = e.record.get(k+'Hidden');
            if (v !== undefined) {
              p[k+'Hidden'] = v;
            }
        }
    }
    // add value used by ForeignKeyStoreField CHOICES_HIDDEN_SUFFIX
    // not sure whether this is still needed:
    p[e.field+'Hidden'] = e.value;
    //~ p.su = Lino.subst_user;
    Lino.insert_subst_user(p);
    // this one is needed so that this field can serve as choice context:
    e.record.data[e.field+'Hidden'] = e.value;
    // p[pk] = e.record.data[pk];
    // console.log("grid_afteredit:",e.field,'=',e.value);
    Ext.apply(p, this.get_base_params()); // needed for POST, ignored for PUT
    //~ Ext.apply(p,this.containing_window.config.base_params);
    //~ 20121109 p['$ext_requests.URL_PARAM_ACTION_NAME'] = 'grid';
    var self = this;
    var req = {
        params:p,
        waitMsg: 'Saving your data...',
        success: Lino.action_handler( this, function(result) {
          // console.log("20140728 afteredit.success got ", result);
          //~ if (result.data_record) {
          if (result.refresh_all) {
              var cw = self.get_containing_window();
              if (cw) {
                  cw.main_item.refresh();
              }
              else console.log("20120123 cannot refresh_all",self);
          } else if (result.rows) {
              //~ self.getStore().loadData(result,true);
              var r = self.getStore().reader.readRecords(result);
              if (e.record.phantom) {
                  // console.log("20140728 gonna call Store.insert()", self.getStore(), e.row, r.records);
                  self.getStore().insert(e.row, r.records);
              }else{
                  // console.log("20140728 afteredit.success doUpdate", r.records[0]);
                  self.getStore().doUpdate(r.records[0]);
              }
              self.getStore().rejectChanges(); 
              /* 
              get rid of the red triangles without saving the record again
              */
              //~ self.getStore().commitChanges(); // get rid of the red triangles
          } else {
              self.getStore().commitChanges(); // get rid of the red triangles
              self.getStore().reload();        // reload our datastore.
          }
          }),
        scope: this,
        failure: Lino.ajax_error_handler(this)
    };
    if (e.record.phantom) {
      req.params.an = 'grid_post'; // CreateRow.action_name
      Ext.apply(req,{
        method: 'POST',
        url: '/api' + this.ls_url
      });
    } else {
      req.params.an = 'grid_put'; // SaveRow.action_name
      Ext.apply(req,{
        method: 'PUT',
        url: '/api' + this.ls_url + '/' + e.record.id
      });
    }
    //~ console.log('20110406 on_afteredit',req);
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(req);
  },

  afterRender : function() {
    Lino.GridPanel.superclass.afterRender.call(this);
    // this.getView().mainBody.focus();
    // console.log(20100114,this.getView().getRows());
    // if (this.getView().getRows().length > 0) {
    //  this.getView().focusRow(1);
    // }
    //~ this.my_load_mask = new Ext.LoadMask(this.getEl(), {
        //~ msg:'$_("Please wait...")',
        //~ store:this.store});
      
    var tbar = this.getTopToolbar();
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    // tbar.on('change',function() {this.getSelectionModel().selectFirstRow();this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    this.nav = new Ext.KeyNav(this.getEl(),{
      pageUp: function() {tbar.movePrevious(); },
      pageDown: function() {tbar.moveNext(); },
      home: function() {tbar.moveFirst(); },
      end: function() {tbar.moveLast(); },
      scope: this
    });

  },
  after_delete : function() {
    //~ console.log('Lino.GridPanel.after_delete');
    this.refresh();
  },
  add_row_listener : function(fn,scope) {
    this.getSelectionModel().addListener('rowselect',fn,scope);
  },
  postEditValue : function(value, originalValue, r, field){
    value = Lino.GridPanel.superclass.postEditValue.call(this,value,originalValue,r,field);
    //~ console.log('GridPanel.postEdit()',value, originalValue, r, field);
    return value;
  },
  
  set_start_value : function(v) {
      this.start_value = v;
  },
  preEditValue : function(r, field){
      if (this.start_value) {
        var v = this.start_value;
        delete this.start_value;
        this.activeEditor.selectOnFocus = false;
        return v;
      }
      var value = r.data[field];
      return this.autoEncode && Ext.isString(value) ? Ext.util.Format.htmlDecode(value) : value;
  },
  
  on_master_changed : function() {
    //~ if (! this.enabled) return;
    //~ cmp = this;
    //~ console.log('20130911 Lino.GridPanel.on_master_changed()',this.title,this.rendered);
    if (! this.rendered) return; // 20120213
    var todo = function() {
      if (this.disabled) return;
      //~ if (this.disabled) return;
      //~ if (this.enabled) {
          //~ var src = caller.config.url_data + "/" + record.id + ".jpg"
          //~ console.log(20111125, this.containing_window);
          //~ for (k in p) this.getStore().setBaseParam(k,p[k]);
          //~ console.log('Lino.GridPanel.on_master_changed()',this.title,p);
          this.refresh();
          //~ this.set_base_params(this.master_panel.get_master_params());
          //~ this.getStore().load(); 
      //~ }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  },
  load_record_id : function(record_id,after) {
      Lino.run_detail_handler(this,record_id)
  }
  
});
  

//~ Lino.MainPanelMixin = {
  //~ tbar_items : function() {
      //~ return ;
  //~ }
//~ };

//~ Ext.override(Lino.GridPanel,Lino.MainPanelMixin);
//~ Ext.override(Lino.FormPanel,Lino.MainPanelMixin);

//~ Lino.grid_context_menu = function(e) {
  //~ console.log('contextmenu',arguments);
//~ }

Lino.row_context_menu = function(grid,row,col,e) {
  console.log('20130927 rowcontextmenu',grid,row,col,e,grid.store.reader.arrayData.rows[row]);
}

Lino.cell_context_menu = function(grid,row,col,e) {
  //~ console.log('20120531 cellcontextmenu',grid,row,col,e,grid.store.reader.arrayData.rows[row]);
  e.stopEvent();
  //~ grid.getView().focusCell(row,col);
  grid.getSelectionModel().select(row,col);
  //~ console.log(grid.store.getAt(row));
  //~ grid.getView().focusRow(row);
  //~ return;
  if(!grid.cmenu.el){grid.cmenu.render(); }
  //~ if(e.record.data.disabled_fields) {
  
  var da = grid.store.reader.arrayData.rows[row][grid.disabled_actions_index];
  if (da) {
      this.cmenu.cascade(function(item){ 
        //~ console.log(20120531, item.itemId, da[item.itemId]);
        if (da[item.itemId]) item.disable(); else item.enable();
      });
  };
  
  var xy = e.getXY();
  xy[1] -= grid.cmenu.el.getHeight();
  grid.cmenu.showAt(xy);
}


Lino.chooser_handler = function(combo,name) {
  return function(cmp,newValue,oldValue) {
    //~ console.log('Lino.chooser_handler()',cmp,oldValue,newValue);
    combo.setContextValue(name,newValue);
  }
};



Lino.ComboBox = Ext.extend(Ext.form.ComboBox,{
  forceSelection: "yes but select on tab",
  // forceSelection: true,
  triggerAction: 'all',
  minListWidth:280, // 20131022
  autoSelect: false,
  selectOnFocus: true, // select any existing text in the field immediately on focus.
  submitValue: true,
  displayField: 'text', // 'text', 
  valueField: 'value', // 'value',
  
  //~ initComponent : Ext.form.ComboBox.prototype.initComponent.createSequence(function() {
  initComponent : function(){
      this.contextParams = {};
      //~ Ext.form.ComboBox.initComponent(this);
      Lino.ComboBox.superclass.initComponent.call(this);
  },
  setValue : function(v,record_data){
      /*
      Based on feature request developed in http://extjs.net/forum/showthread.php?t=75751
      */
      /* `record_data` is used to get the text corresponding to this value */
      //~ if(this.name == 'city') 
      //~ console.log('20120203', this.name,'.setValue(', v ,') this=', this,'record_data=',record_data);
      var text = v;
      if(this.valueField){
        if(v == null || v == '') { 
            //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,'no lookup needed, value is empty');
            //~ v = undefined;
            v = '';
            //~ text = '';
        } else if (Ext.isDefined(record_data)) {
          text = record_data[this.name];
          //~ if (this.name == 'birth_country') 
            //~ console.log(this.name,'.setValue',v,'got text ',text,' from record ',record);
        } else {
          // if(this.mode == 'remote' && !Ext.isDefined(this.store.totalLength)){
          if(this.mode == 'remote' && ( this.lastQuery === null || (!Ext.isDefined(this.store.totalLength)))){
              //~ if (this.name == 'birth_country') console.log(this.name,'.setValue',v,'store not yet loaded');
              this.store.on('load', this.setValue.createDelegate(this, arguments), null, {single: true});
              if(this.store.lastOptions === null || this.lastQuery === null){
                  var params;
                  if(this.valueParam){
                      params = {};
                      params[this.valueParam] = v;
                  }else{
                      var q = this.allQuery;
                      this.lastQuery = q;
                      this.store.setBaseParam(this.queryParam, q);
                      params = this.getParams(q);
                  }
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : call load() with params ',params);
                  this.store.load({params: params});
              //~ }else{
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : but store is loading',this.store.lastOptions);
              }
              return;
          //~ }else{
              //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,' : store is loaded, lastQuery is "',this.lastQuery,'"');
          }
          var r = this.findRecord(this.valueField, v);
          if(r){
              text = r.data[this.displayField];
          }else if(this.valueNotFoundText !== undefined){
              text = this.valueNotFoundText;
          }
        }
      }
      this.lastSelectionText = text;
      //~ this.lastSelectionText = v;
      if(this.hiddenField){
          //~ this.hiddenField.originalValue = v;
          this.hiddenField.value = v;
      }
      Ext.form.ComboBox.superclass.setValue.call(this, text);
      this.value = v; // needed for grid.afteredit
  },
  
  getParams : function(q){
    // p = Ext.form.ComboBox.superclass.getParams.call(this, q);
    // causes "Ext.form.ComboBox.superclass.getParams is undefined"
    var p = {};
    if(this.pageSize){
        p['start'] = 0;
        p['limit'] = this.pageSize;
    }
    // now my code:
    if(this.contextParams) Ext.apply(p, this.contextParams);
    return p;
  },
  setContextValue : function(name,value) {
    //~ console.log('setContextValue',this,this.name,':',name,'=',value);
    //~ if (this.contextValues === undefined) {
        //~ this.contextValues = Array(); // this.contextParams.length);
    //~ }
    if (this.contextParams[name] != value) {
      //~ console.log('setContextValue 1',this.contextParams);
      this.contextParams[name] = value;
      this.lastQuery = null;
      //~ console.log('setContextValue 2',this.contextParams);
    }
  }
});

Lino.ChoicesFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'local'
});


Lino.SimpleRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  // forceSelection: true,  20140206 why was this here?
  constructor: function(config){
      Lino.SimpleRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value' ], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.ComplexRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  constructor: function(config){
      Lino.ComplexRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value','text'], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.RemoteComboFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'remote',
  //~ forceSelection:false,
  minChars: 2, // default 4 is too much
  queryDelay: 300, // default 500 is maybe slow
  queryParam: 'query', 
  //~ typeAhead: true,
  //~ selectOnFocus: true, // select any existing text in the field immediately on focus.
  resizable: true
  ,initList : function() {
      Lino.RemoteComboFieldElement.superclass.initList.call(this);
      if (this.pageTb) {
          
          var me = this;
          this.pageTb.on("beforechange", function(toolbar, o){
              if(me.contextParams)
                  Ext.apply(o, me.contextParams);
          });
          
          //~ 
          //~ var btn = ls_buttons
          //~ this.pageTb.items = this.pageTb.items.concat([btn]);
          //~ console.log("20131022 pageTb.items is", this.pageTb.items)
      }
  }
});

/*
Thanks to Animal for posting the basic idea:
http://www.sencha.com/forum/showthread.php?15842-2.0-SOLVED-Combobox-twintrigger-clear&p=76130&viewfull=1#post76130

*/
Lino.TwinCombo = Ext.extend(Lino.RemoteComboFieldElement,{
    trigger2Class : 'x-form-search-trigger',
    //~ trigger2Class : 'x-tbar-detail',
    initComponent : function() {
        //~ Lino.TwinCombo.superclass.initComponent.call(this);
        Lino.ComboBox.prototype.initComponent.call(this);
        Ext.form.TwinTriggerField.prototype.initComponent.call(this);
    },
    onTrigger2Click : function() {
        //~ console.log('onTrigger2Click',this,arguments);
    }
  });
//~ Lino.TwinCombo.prototype.initComponent = Ext.form.TwinTriggerField.prototype.initComponent;
Lino.TwinCombo.prototype.getTrigger = Ext.form.TwinTriggerField.prototype.getTrigger;
Lino.TwinCombo.prototype.getOuterSize = Ext.form.TwinTriggerField.prototype.getOuterSize;
Lino.TwinCombo.prototype.initTrigger = Ext.form.TwinTriggerField.prototype.initTrigger;
Lino.TwinCombo.prototype.onTrigger1Click = Ext.form.ComboBox.prototype.onTriggerClick;
//~ Lino.TwinCombo.prototype.onTrigger2Click = function() {
    //~ console.log('onTrigger2Click',arguments);
//~ };



Lino.SimpleRemoteComboFieldElement = Ext.extend(Lino.RemoteComboFieldElement,{
  displayField: 'value', 
  valueField: null,
  forceSelection: false
});




Lino.Window = Ext.extend(Ext.Window,{
  //~ layout: "fit", 
  closeAction : 'hide',
  renderTo: 'main_area', 
  constrain: true,
  maximized: true,
  draggable: false,
  width: 700,
  height: 500,
  maximizable: false,
  constructor : function (config) {
    if (config.main_item.params_panel) {
        config.layout = 'border';
        config.main_item.region = 'center';
        config.main_item.params_panel.region = 'north';
        //~ config.main_item.params_panel.autoHeight = false; // 20130924
        config.main_item.params_panel.hidden = config.main_item.params_panel_hidden;
        config.items = [config.main_item.params_panel, config.main_item];
        //~ 20130923b
    } else {
        config.layout = 'fit';
        config.items = config.main_item;
    }
    this.main_item = config.main_item; 
    
    delete config.main_item;
    //~ delete config.params_item;
    
    //~ this.main_item = config.items.get(0);
    this.main_item.containing_window = this;
    
    //~ console.log('20120110 Lino.Window.constructor() 1');
    //~ if (Lino.current_window) { // all windows except the top are closable
    if (this.main_item.hide_window_title) { 
      config.closable = false;
      config.frame = false;
      config.shadow = false;
      //~ config.border = true;
      //~ config.title = undefined;
      //~ config.tools = null;
      delete config.title;
      delete config.tools;
    } else {
      config.title = this.main_item.empty_title;
      config.closable = true;
      config.tools = [ 
        { qtip: 'permalink', handler: Lino.permalink_handler(this), id: "pin" }
      ];
      if (this.main_item.content_type && this.main_item.action_name != 'insert') {
        config.tools = [ {
          handler: Lino.help_text_editor,
          qtip: "Edit help texts for fields on this model.",
          scope: this.main_item,
          id: "gear"
        }].concat(config.tools);
      }
        
    //~ { qtip: '', handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: this.config.qtip, handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: 'Call doLayout() on main Container.', handler: Lino.refresh_handler(this), id: "refresh" },
    //~ if (this.main_item.params_panel) {
        //~ config.tools = config.tools.concat([ 
          //~ { qtip: 'Show/hide parameter panel', handler: this.toggle_params_panel, id: "gear", scope:this } 
        //~ ]);
    //~ }
    //~ if (config.closable !== false) {
      // if undefined, will take default behaviour
      //~ config.tools = config.tools.concat([ 
        //~ { qtip: 'close', handler: this.hide, id: "close", scope:this } 
      //~ ]);
    }
    
    this.main_item.config_containing_window(config);
    
    //~ console.log('20120110 Lino.Window.constructor() 2');
    Lino.Window.superclass.constructor.call(this,config);
    
    //~ console.log('20120110 Lino.Window.constructor() 3');
    
  },
  initComponent : function() {
    this.main_item.init_containing_window(this);
    Lino.Window.superclass.initComponent.call(this);
  
  },
  hide : function() { 
      this.main_item.do_when_clean(false,function() { 
        Lino.close_window(); });
  },
  hide_really : function() { 
    Lino.Window.superclass.hide.call(this);
  },
  onRender : function(ct, position){
    // console.log('20140829 Lino.Window.onRender() 1');
    Lino.Window.superclass.onRender.call(this, ct, position);
    var main_area = Ext.getCmp('main_area')
    //~ console.log('20120110 Lino.Window.onRender() 2');
  
    this.on('show', function(win) {
        // console.log('20140829 Lino.Window.on(show) : add resize handler');
        main_area.on('resize', win.onWindowResize, win);
    });
    this.on('hide', function(win) {
        // console.log('20140829 Lino.Window.on(hide) : remove resize handler');
        main_area.un('resize', win.onWindowResize, win);
    });
    // console.log('20140829 Lino.Window.onRender() 3');
  }
});


Ext.override(Ext.form.BasicForm,{
    my_loadRecord : function(values){
    //~ loadRecord : function(record){
        /* Same as ExtJS's loadRecord() (setValues()), except that we 
        forward also the record to field.setValue() so that Lino.Combobox 
        can use it. 
        */
        //~ console.log('20120918 my_loadRecord',values)
        if(Ext.isArray(values)){ 
            for(var i = 0, len = values.length; i < len; i++){
                var v = values[i];
                var f = this.findField(v.id);
                if(f){
                    f.setValue(v.value,values);
                    if(this.trackResetOnLoad){
                        f.originalValue = f.getValue();
                    }
                }
            }
        }else{ 
            var field, id;
            for(id in values){
                if(!Ext.isFunction(values[id]) && (field = this.findField(id))){
                    field.setValue(values[id],values);
                    if(this.trackResetOnLoad){
                        field.originalValue = field.getValue();
                        //~ if (field.hiddenField) {
                          //~ field.hiddenField.originalValue = field.hiddenField.value;
                        //~ }
                    }
                }
            }
        }
        return this;
    }
});




function initializeFooBarDropZone(cmp) {
    //~ console.log('initializeFooBarDropZone',cmp);
    cmp.dropTarget = new Ext.dd.DropTarget(cmp.bwrap, {
      //~ ddGroup     : 'gridDDGroup',
      notifyEnter : function(ddSource, e, data) {
        console.log('notifyEnter',ddSource,e,data);
        //Add some flare to invite drop.
        cmp.body.stopFx();
        cmp.body.highlight();
      },
      notifyDrop  : function(ddSource, e, data){
        console.log('notifyDrop',ddSource,e,data);
        // Reference the record (single selection) for readability
        //~ var selectedRecord = ddSource.dragData.selections[0];


        // Load the record into the form
        //~ formPanel.getForm().my_loadRecord(selectedRecord);


        // Delete record from the grid.  not really required.
        //~ ddSource.grid.store.remove(selectedRecord);

        return(true);
      }
    })
}



Lino.show_mti_child = function(fieldname,detail_handler) {
  //~ console.log('show_mti_child',this);
  //~ console.log('show_mti_child',panel.find("main_area"));
  rec = Lino.current_window.main_item.get_current_record();
  //~ rec = panel.get_current_record();
  if (rec) {
    //~ console.log('show_mti_child',Lino.current_window,rec);
    if (rec.phantom) {
      Lino.notify('Not allowed on phantom record.');
    }else if (rec.data[fieldname]) {
      //~ console.log('show_mti_child',rec.id);
      //~ detail_handler(Lino.current_window.main_item,{},{record_id:rec.id});
      detail_handler.run(null,{record_id:rec.id});
      //~ window.open(urlroot + '/' + rec.id);
      //~ document.location = urlroot + '/' + rec.id;
      //~ window.open(urlroot + '/' + rec.id,'_blank');
    } else {
      Lino.alert("Cannot show MTI child if checkbox is off.");
    }
  } else {
    Lino.notify('No current record.');
  }
};


/*
captureEvents utility by Aaron Conran
<http://www.sencha.com/learn/grid-faq/>

Ext.onReady(function(){
    var grid = new Ext.grid.GridPanel({
        ... 
    });
    captureEvents(grid);
});
*/
function captureEvents(observable) {
    Ext.util.Observable.capture(
        observable,
        function(eventName) {
            console.info(eventName);
        },
        this
    );		
}

// settings.SITE.get_plugin_snippets()




// from lino.modlib.iban:iban/uppercasetextfield.js

Lino.UppercaseTextField = Ext.extend(Ext.form.TextField,{
  style: 'text-transform:uppercase;',
  listeners:{
    change: function(field, newValue, oldValue){
      // console.log("20140403 UppercaseTextField",newValue, newValue.toUpperCase());
      field.setRawValue(newValue.toUpperCase());
    }
  }
});


Lino.iban_renderer = function(
    value, metaData, record, rowIndex, colIndex, store) 
{
    var reg = new RegExp(".{4}", "g");
    if(value) {
        return value.replace(reg, function (a) { return a + ' '; });
    }
    return value;
}




// from lino.modlib.extensible (media_name=extensible, media_root=/home/luc/snapshots/extensible-1.0.1):snippets/extensible.js

/*
  This is the `extensible.js` snippet. 
  Used in lino.modlib.extensible.App.site_js_snippets
*/

/*
Mappings towards lino.modlib.extensible.models.PanelCalendars
*/
// Sset SS = Ssite.modules.extensible.PanelCalendars.get_handle(Sui).store
Ext.ensible.cal.CalendarMappings = {
    CalendarId:   {name:'ID',       mapping: 'id', type: 'int'},
    Title:        {name:'CalTitle', mapping: 'summary', type: 'string'},
    Description:  {name:'Desc',     mapping: 'description', type: 'string'},
    ColorId:      {name:'Color',    mapping: 'color', type: 'int'},
    IsHidden:     {name:'Hidden',   mapping: 'is_hidden', type: 'boolean'},    
};
Ext.ensible.cal.CalendarRecord.reconfigure();  


/*
Mappings towards lino.modlib.extensible.models.PanelEvents 
*/
// Sset SS = Ssite.modules.extensible.PanelEvents.get_handle(Sui).store
Ext.ensible.cal.EventMappings = {
    EventId:     {name: 'ID',        mapping: 'id', type:'int'},
    CalendarId:  {name: 'CalID',     mapping: 'calendarHidden', type: 'int'},
    Title:       {name: 'EvtTitle',  mapping: 'summary'},
    StartDate:   {name: 'StartDt',   mapping: 'start_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s" },
    EndDate:     {name: 'EndDt',     mapping: 'end_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s"},
    RRule:       {name: 'RecurRule', mapping: 'rsetHidden'},
    Location:    {name: 'Location',  mapping: 'placeHidden'},
    Notes:       {name: 'Desc',      mapping: 'description'},
    Url:         {name: 'LinkUrl',   mapping: 'url'},
    IsAllDay:    {name: 'AllDay',    mapping: 'all_day', type: 'boolean'},
    Reminder:    {name: 'Reminder',  mapping: 'reminder'}
    
};
Ext.ensible.cal.EventRecord.reconfigure();


//~ Lino.on_eventclick = 
    
Lino.on_editdetails = 

Lino.format_time = function(dt) {
    return dt.getHours() + ':' + dt.getMinutes();
}
    
Lino.on_eventdelete = function() {
  //~ console.log("Lino.on_eventdelete",arguments);
};

Lino.on_eventadd  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventadd ",arguments);
  return false;
}
    
Lino.on_eventresize  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventresize ",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    
Lino.on_eventupdate  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventupdate",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    

//~ Lino.eventStore = new Ext.ensible.cal.EventStore({ 
//~ Lino.eventStore = new Ext.data.ArrayStore({ 
Lino.unused_eventStore = new Ext.data.JsonStore({ 
  listeners: { exception: Lino.on_store_exception }
  ,url: '/restful/extensible/PanelEvents'
  ,restful : true
  ,proxy: new Ext.data.HttpProxy({ 
      url: '/restful/extensible/PanelEvents', 
      disableCaching: false // no need for cache busting when loading via Ajax
      //~ disableCaching:true,
  })
  ,fields: Ext.ensible.cal.EventRecord.prototype.fields.getRange()
  ,totalProperty: "count"
  ,root: "rows"
  ,idProperty: Ext.ensible.cal.EventMappings.EventId.mapping
  ,writer : new Ext.data.JsonWriter({
    writeAllFields: false
  })
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
      if (!options) options = {};
      if (!options.params) options.params = {};
      //~ options.params.$ext_requests.URL_PARAM_TEAM_VIEW = Lino.calendar_app.team_view_button.pressed;
      
      var view = this.cal_panel.getActiveView();
      var bounds = view.getViewBounds();
      //~ var p = {sd:'05.02.2012',ed:'11.02.2012'};
      //~ var p = {};
      options.params[view.dateParamStart] = bounds.start.format(view.dateParamFormat);
      options.params[view.dateParamEnd] = bounds.end.format(view.dateParamFormat);
      Lino.insert_subst_user(options.params);
      //~ Ext.apply(options.params,p)
      //~ console.log('20120710 eventStore.load()',this.baseParams,options);
    
    return Ext.data.JsonStore.prototype.load.call(this,options);
  }
});


Lino.CalendarCfg = {
    dateParamFormat: 'd.m.Y',
    dateParamStart:'sd',
    dateParamEnd:'ed'
};
//~ 20120704 Lino.CalendarPanel = Ext.extend(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
//~ Lino.CalendarPanel = Ext.extend(Lino.CalendarPanel,{
Ext.override(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
Ext.override(Ext.ensible.cal.CalendarPanel,{
  //~ empty_title : "\$ui.get_actor('cal.Panel').report.label",
  empty_title : "Calendar"
  ,activeItem: 1 // 0: day, 1: week
  ,ls_url: '/extensible/CalendarPanel'
  //~ ,disableCaching:true
  //~ ,eventStore: Lino.eventStore
  //~ ,calendarStore: Lino.calendarStore
  //~ ,initComponent : function(){
    //~ Ext.ensible.cal.CalendarPanel.superclass.initComponent.call(this);
    //~ this.eventStore.on('load',function(){
      //~ console.log("20130808",Lino.eventStore);
      //~ if (this.eventStore.reader.jsonData) {
        //~ console.log("20130808 b",this.eventStore.reader.jsonData.title);
        //~ this.set_window_title(this.eventStore.reader.jsonData.title);
      //~ }
    //~ },this);
  //~ }
  ,listeners: { 
    editdetails: function(cp,rec,el) {
      //~ console.log("Lino.on_editdetails",arguments);
      if (rec.data.ID)
          Lino.extensible.PanelEvents.detail.run(null,{
              record_id:rec.data.ID,
              base_params:this.app_instance.event_store.baseParams});
      return false;
    }
    ,eventclick: function(cp,rec,el) {
      //~ console.log("Lino.on_eventclick",arguments);
      //~ Lino.cal.Events.detail_action.run({record_id:rec.data.ID});
      Lino.extensible.PanelEvents.detail.run(null,{
            record_id:rec.data.ID,
                base_params:this.app_instance.event_store.baseParams});
      return false;
    }
    //~ ,eventadd: Lino.on_eventadd
    //~ ,eventdelete: Lino.on_eventdelete
    //~ ,eventresize: Lino.on_eventresize
    ,afterrender : function(config) {
      // console.log("20140402 CalendarPanel.afterrender");
      this.app_instance.calendar_store.cal_panel = this;
      // 20140402 this.app_instance.calendar_store.load();
      //~ console.log("20120704 afterrender calls eventStore.load()",p);
      this.app_instance.event_store.cal_panel = this;
      //~ Lino.eventStore.load({params:p});
      //~ 20130905 removed: this.app_instance.event_store.load();
      //~ Lino.CalendarPanel.superclass.constructor.call(this, config);
      //~ console.log(20120118, config,this);
    }
    }
  ,enableEditDetails: false
  //~ ,monthViewCfg: Lino.CalendarCfg
  //~ ,weekViewCfg: Lino.CalendarCfg
  //~ ,multiDayViewCfg: Lino.CalendarCfg
  //~ ,multiWeekViewCfg: Lino.CalendarCfg
  //~ ,dayViewCfg: Lino.CalendarCfg
  //~ ,initComponent : function() {
    //~ // this.on('eventadd',Lino.on_eventadd);
    //~ Lino.CalendarPanel.superclass.initComponent.call(this);
  //~ }
});




Lino.CalendarAppPanel = Ext.extend(Ext.Panel,Lino.MainPanel);
Lino.CalendarAppPanel = Ext.extend(Lino.CalendarAppPanel,Lino.PanelMixin);
Lino.CalendarAppPanel = Ext.extend(Lino.CalendarAppPanel,{
  app_instance : null
  //~ empty_title : "\$ui.get_actor('cal.Panel').report.label",
  ,empty_title : "Calendar"
  ,ls_url: '/extensible/CalendarPanel'
  ,set_status : function(status,rp) { 
      // console.log('20140402 CalendarAppPanel.set_status()', status);
      this.requesting_panel = Ext.getCmp(rp);
      this.clear_base_params();
      if (status == undefined) status = {};
      //~ if (status.param_values) 
      //~ this.set_field_values(status.field_values);
      if (status.base_params) this.set_base_params(status.base_params);
      this.refresh();
      }
  ,refresh : function() {
      //~ this.app_instance.event_store.reload(); 20130905
      this.app_instance.calendar_store.load();  // added 20140402
      this.app_instance.event_store.load();
  }
  ,layout: 'fit'
  ,get_base_params : function() {
    // console.log('20140402 getbase_params has', this.base_params);
    var p = Ext.apply({}, this.base_params);
    Lino.insert_subst_user(p);
    // console.log('20140402 getbase_params returns', p);
    return p;
  }
  ,set_base_params : function(p) {
    this.base_params = Ext.apply(this.app_instance.event_store.baseParams,p);
    this.app_instance.event_store.baseParams = this.base_params;
    // console.log('20140402 this.base_params is', this.base_params);
  }
  ,clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  }
  ,set_base_param : function(k,v) {
      if (!this.base_params) this.base_params = {};
      this.base_params[k] = v;
  }
});

Lino.CalendarApp = function() { return {
  team_view_button : null 
  ,get_main_panel : function() {
      var cap = null;
      this.event_store = new Ext.data.JsonStore({ 
          listeners: { exception: Lino.on_store_exception }
          ,url: '/restful/extensible/PanelEvents'
          ,restful : true
          ,proxy: new Ext.data.HttpProxy({ 
              url: '/restful/extensible/PanelEvents', 
              disableCaching: false // no need for cache busting when loading via Ajax
              //~ disableCaching:true,
          })
          ,fields: Ext.ensible.cal.EventRecord.prototype.fields.getRange()
          ,totalProperty: "count"
          ,root: "rows"
          ,idProperty: Ext.ensible.cal.EventMappings.EventId.mapping
          ,writer : new Ext.data.JsonWriter({
            writeAllFields: false
          })
          ,load: function(options) {
            //~ foo.bar = baz; // 20120213
              if (!options) options = {};
              if (!options.params) options.params = {};
              //~ options.params.$ext_requests.URL_PARAM_TEAM_VIEW = Lino.calendar_app.team_view_button.pressed;
              
              var view = this.cal_panel.getActiveView();
              var bounds = view.getViewBounds();
              //~ var p = {sd:'05.02.2012',ed:'11.02.2012'};
              //~ var p = {};
              options.params[view.dateParamStart] = bounds.start.format(view.dateParamFormat);
              options.params[view.dateParamEnd] = bounds.end.format(view.dateParamFormat);
              Lino.insert_subst_user(options.params);
              Ext.apply(options.params, cap.get_base_params());
              //~ this.cal_panel.base_params.su.toString();
              //~ if (this.cal_panel) {
                  // Ext.apply(options.params,this.cal_panel.base_params);
              //~ }
              //~ Ext.apply(options.params,p)
              //~ console.log('20130905 eventStore.load()',this.cal_panel,this.baseParams,options.params);
            
            return Ext.data.JsonStore.prototype.load.call(this,options);
          }
      });

      //~ Lino.calendarStore
      this.calendar_store = new Ext.data.JsonStore({ 
          listeners: { exception: Lino.on_store_exception }
          ,restful : true
          ,proxy: new Ext.data.HttpProxy({ 
              url: '/restful/extensible/PanelCalendars?fmt=json', 
              disableCaching: false // no need for cache busting when loading via Ajax
              //~ restful : true
              //~ method: "GET"
          })
          //~ ,autoLoad: true
          //~ ,remoteSort: true
          //~ ,baseParams: bp
          ,totalProperty: "count"
          ,root: "rows"
          ,fields: Ext.ensible.cal.CalendarRecord.prototype.fields.getRange()
          ,idProperty: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
          //~ ,idIndex: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
          ,load: function(options) {
              // new since 20140402 add substitute user when calling
              // calendars
              if (!options) options = {};
              if (!options.params) options.params = {};
              // Lino.insert_subst_user(options.params);
              Ext.apply(options.params, cap.get_base_params());
              // console.log("20140402 calendar_store.load", options.params, 
              //             this.cal_panel, cap.get_base_params());
            return Ext.data.JsonStore.prototype.load.call(this,options);
          }
      });
      
      cap = new Lino.CalendarAppPanel({ 
          app_instance: this, 
          items : 
        //~ [{
          //~ id: 'app-header',
          //~ region: 'north',
          //~ height: 35,
          //~ border: false,
          // contentEl: 'app-header-content'
        //~ },
      {
          id: 'app-center',
          title: '...', // will be updated to the current view's date range
          region: 'center',
          layout: 'border',
          listeners: {
              'afterrender': function(){
                  Ext.getCmp('app-center').header.addClass('app-center-header');
              }
          },
          items: [{
              id:'app-west',
              region: 'west',
              width: 176,
              border: false,
              items: [{
                  xtype: 'datepicker',
                  id: 'app-nav-picker',
                  cls: 'ext-cal-nav-picker',
                  listeners: {
                      'select': {
                          fn: function(dp, dt){
                              // console.log("20131017",dp);
                              //~ Lino.calendarPanel.setStartDate(dt);
                              //~ cap.setStartDate(dt);
                              Ext.getCmp('app-calendar').setStartDate(dt);
                          },
                          //~ scope: this
                      }
                  }
              //~ },{ 
                //~ layout:'fit',
                //~ items: [
                  //~ new Ext.form.Checkbox({
                    //~ boxLabel:"$_('Team view')",
                    //~ hideLabel:true
                    //~ listeners: { click: }
                  //~ })
                //~ ]
              //~ },{ 
                //~ layout:'form',
                //~ items: [
                  //~ this.team_view_button = new Ext.Button({
                    //~ text:"Team view",
                    //~ enableToggle:true,
                    //~ pressed:false,
                    //~ toggleHandler: function(btn,state) { 
                      //~ // console.log('20120716 teamView.toggle()');
                      //~ this.event_store.setBaseParam('tv',state);
                      //~ this.event_store.load();
                      //~ // Lino.eventStore.load({params:{$ext_requests.URL_PARAM_TEAM_VIEW:state}});
                      //~ // console.log("team view",state);
                    //~ }
                  //~ })
                //~ ]
              },{
                  xtype: 'extensible.calendarlist',
                  store: this.calendar_store,
                  border: false,
                  width: 175
              }]
          },{
              xtype: 'extensible.calendarpanel', // Ext.ensible.cal.CalendarPanel
              eventStore: this.event_store,
              app_instance: this,
              calendarStore: this.calendar_store,
              border: false,
              id:'app-calendar',
              region: 'center',
              //~ activeItem: 3, // month view
              
              // Any generic view options that should be applied to all sub views:
              viewConfig: {
                  // Lino.CalendarCfg
                  dateParamFormat: 'd.m.Y',
                  dateParamStart:'sd',
                  dateParamEnd:'ed',
                
                  //enableFx: false,
                  //ddIncrement: 10, //only applies to DayView and subclasses, but convenient to put it here
                  viewStartHour: 9, // 8
                  viewEndHour: 18 // 18
                  //minEventDisplayMinutes: 15
              },
              
              // View options specific to a certain view (if the same options exist in viewConfig
              // they will be overridden by the view-specific config):
              monthViewCfg: {
                  showHeader: true,
                  showWeekLinks: true,
                  showWeekNumbers: true,
                  eventBodyMarkup: ['{Title}',
                    //~ '<tpl if="url">',
                        //~ '<a href="{url}">XX</a>',
                    //~ '</tpl>',
                    '<tpl if="_isReminder">',
                        '<i class="ext-cal-ic ext-cal-ic-rem">&#160;</i>',
                    '</tpl>',
                    '<tpl if="_isRecurring">',
                        '<i class="ext-cal-ic ext-cal-ic-rcr">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanLeft">',
                        '<i class="ext-cal-spl">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanRight">',
                        '<i class="ext-cal-spr">&#160;</i>',
                    '</tpl>'
                ].join('')
              },
              
              multiWeekViewCfg: {
                  //weekCount: 3
              },
              
              // Some optional CalendarPanel configs to experiment with:
              //readOnly: true,
              //showDayView: false,
              //showMultiDayView: true,
              //showWeekView: false,
              //showMultiWeekView: false,
              //showMonthView: false,
              //showNavBar: false,
              //showTodayText: false,
              //showTime: false,
              //editModal: true,
              //enableEditDetails: false,
              //title: 'My Calendar', // the header of the calendar, could be a subtitle for the app
              
              // Once this component inits it will set a reference to itself as an application
              // member property for easy reference in other functions within App.
              //~ initComponent: function() {
                  //~ Lino.calendarPanel = this;
                  //~ this.constructor.prototype.initComponent.apply(this, arguments);
              //~ },
              
              listeners: {
                  //~ 'eventclick': {
                      //~ fn: function(vw, rec, el){
                          //~ this.clearMsg();
                      //~ },
                      //~ scope: this
                  //~ },
                  'eventover': function(vw, rec, el){
                      //console.log('Entered evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]', view='+ vw.id +', el='+el.id);
                  },
                  'eventout': function(vw, rec, el){
                      //console.log('Leaving evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]+', view='+ vw.id +', el='+el.id);
                  },
                  'eventadd': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was added');
                      },
                      scope: this
                  },
                  'eventupdate': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(cp, rec){
                          //this.eventStore.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'eventcancel': {
                      fn: function(cp, rec){
                          // edit canceled
                      },
                      scope: this
                  },
                  'viewchange': {
                      fn: function(p, vw, dateInfo){
                          if(this.editWin){
                              this.editWin.hide();
                          };
                          if(dateInfo !== null){
                              // will be null when switching to the event edit form so ignore
                              Ext.getCmp('app-nav-picker').setValue(dateInfo.activeDate);
                              this.updateTitle(dateInfo.viewStart, dateInfo.viewEnd);
                          }
                          
                      },
                      scope: this
                  },
                  'dayclick': {
                      fn: function(vw, dt, ad, el){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'rangeselect': {
                      fn: function(vw, dates, onComplete){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'eventmove': {
                      fn: function(vw, rec){
                          rec.commit();
                          var time = rec.data[Ext.ensible.cal.EventMappings.IsAllDay.name] ? '' : ' \\a\\t g:i a';
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was moved to '+
                              rec.data[Ext.ensible.cal.EventMappings.StartDate.name].format('F jS'+time));
                      },
                      scope: this
                  },
                  'eventresize': {
                      fn: function(vw, rec){
                          rec.commit();
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(win, rec){
                          this.event_store.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'initdrag': {
                      fn: function(vw){
                          if(this.editWin && this.editWin.isVisible()){
                              this.editWin.hide();
                          }
                      },
                      scope: this
                  }
              }
          }]
        }
        //~ ]
        
      });
      
      this.event_store.on('load',function(){
        //~ console.log("20130905 on event_store load",this.event_store.reader.jsonData);
        if (this.event_store.reader.jsonData) {
          //~ console.log("20130808 b",this.event_store.reader.jsonData.title);
          //~ console.log("20130808 c",this);
          cap.set_window_title(this.event_store.reader.jsonData.title);
        }
      },this);
      
      //~ cap.app_instance = this;
      return cap;
      
  }
  ,updateTitle: function(startDt, endDt){
      var p = Ext.getCmp('app-center');
      
      if(startDt.clearTime().getTime() == endDt.clearTime().getTime()){
          p.setTitle(startDt.format('F j, Y'));
      }
      else if(startDt.getFullYear() == endDt.getFullYear()){
          if(startDt.getMonth() == endDt.getMonth()){
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('j, Y'));
          }
          else{
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('F j, Y'));
          }
      }
      else{
          p.setTitle(startDt.format('F j, Y') + ' - ' + endDt.format('F j, Y'));
      }
  }
  // This is an application-specific way to communicate CalendarPanel event messages back to the user.
  // This could be replaced with a function to do "toast" style messages, growl messages, etc. This will
  // vary based on application requirements, which is why it's not baked into the CalendarPanel.
  ,showMsg: function(msg){
      Lino.notify(msg);
      //~ Ext.fly('app-msg').update(msg).removeClass('x-hidden');
  }
  
  ,clearMsg: function(){
      Lino.notify('');
      //~ Ext.fly('app-msg').update('').addClass('x-hidden');
  }
}
};

Lino.main_menu = [ { "menu": { "items": [ { "text": "Persons", "handler": function() {Lino.contacts.Persons.grid.run(null)} }, { "text": "Organizations", "handler": function() {Lino.contacts.Companies.grid.run(null)} }, { "text": "Partners", "handler": function() {Lino.contacts.Partners.grid.run(null)} }, { "text": "Households", "handler": function() {Lino.households.Households.grid.run(null)} }, { "text": "Partner Lists", "handler": function() {Lino.lists.Lists.grid.run(null)} } ] }, "text": "Contacts" }, { "menu": { "items": [ { "text": "Products", "handler": function() {Lino.products.Products.grid.run(null)} }, { "text": "Product Categories", "handler": function() {Lino.products.ProductCats.grid.run(null)} } ] }, "text": "Products" }, { "menu": { "items": [ { "text": "Sales invoices (S)", "handler": function() {Lino.sales.InvoicesByJournal.grid.run(null,{ "param_values": { "yearHidden": null, "stateHidden": null, "journal": "Sales invoices (S)", "journalHidden": 1, "state": null, "year": null }, "base_params": { "mt": 33, "mk": 1 } })} }, { "text": "Invoices to create", "listeners": { "render": Lino.quicktip_renderer("Foo","Table of all partners who should receive an invoice.") }, "handler": function() {Lino.sales.InvoicesToCreate.grid.run(null)} } ] }, "text": "Sales" }, { "menu": { "items": [ { "text": "Purchase invoices (P)", "handler": function() {Lino.ledger.InvoicesByJournal.grid.run(null,{ "param_values": { "pjournalHidden": null, "pyear": null, "ppartner": null, "ppartnerHidden": null, "pyearHidden": null, "pjournal": null }, "base_params": { "mt": 33, "mk": 2 } })} }, { "text": "Payment Orders (PO)", "handler": function() {Lino.finan.PaymentOrdersByJournal.grid.run(null,{ "param_values": { "pjournalHidden": null, "pyearHidden": null, "pjournal": null, "pyear": null }, "base_params": { "mt": 33, "mk": 4 } })} } ] }, "text": "Purchases" }, { "menu": { "items": [ { "text": "Bestbank (B)", "handler": function() {Lino.finan.BankStatementsByJournal.grid.run(null,{ "param_values": { "pjournalHidden": null, "pyearHidden": null, "pjournal": null, "pyear": null }, "base_params": { "mt": 33, "mk": 3 } })} }, { "text": "Cash (C)", "handler": function() {Lino.finan.BankStatementsByJournal.grid.run(null,{ "param_values": { "pjournalHidden": null, "pyearHidden": null, "pjournal": null, "pyear": null }, "base_params": { "mt": 33, "mk": 5 } })} }, { "text": "Miscellaneous Journal Entries (M)", "handler": function() {Lino.finan.JournalEntriesByJournal.grid.run(null,{ "param_values": { "pjournalHidden": null, "pyearHidden": null, "pjournal": null, "pyear": null }, "base_params": { "mt": 33, "mk": 6 } })} } ] }, "text": "Financial" }, { "menu": { "items": [ { "text": "My Blog Entries", "handler": function() {Lino.blogs.MyEntries.grid.run(null)} } ] }, "text": "Blog" }, { "menu": { "items": [ { "text": "My Projects", "handler": function() {Lino.tickets.MyProjects.grid.run(null)} }, { "text": "My Tickets", "handler": function() {Lino.tickets.MyTickets.grid.run(null)} }, { "text": "My Sessions", "handler": function() {Lino.tickets.MySessions.grid.run(null)} }, { "text": "My sessions by date", "handler": function() {Lino.tickets.MySessionsByDate.grid.run(null)} } ] }, "text": "Tickets" }, { "menu": { "items": [ { "text": "My Uploads", "handler": function() {Lino.uploads.MyUploads.grid.run(null)} }, { "text": "My Outbox", "handler": function() {Lino.outbox.MyOutbox.grid.run(null)} }, { "text": "My Excerpts", "handler": function() {Lino.excerpts.MyExcerpts.grid.run(null)} } ] }, "text": "Office" }, { "menu": { "items": [ { "text": "Calendar", "iconCls": "x-tbar-calendar", "handler": function() {Lino.extensible.CalendarPanel.grid.run(null)}, "listeners": { "render": Lino.quicktip_renderer("Foo","Displays your events in a \"calendar view\"     with the possibility to switch between daily, weekly, monthly view.") } }, { "text": "My events", "listeners": { "render": Lino.quicktip_renderer("Foo","Table of all my calendar events.") }, "handler": function() {Lino.cal.MyEvents.grid.run(null)} }, { "text": "My tasks", "listeners": { "render": Lino.quicktip_renderer("Foo","Table of all my tasks.") }, "handler": function() {Lino.cal.MyTasks.grid.run(null)} }, { "text": "My guests", "handler": function() {Lino.cal.MyGuests.grid.run(null)} }, { "text": "My presences", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows all my presences in calendar events, independently of their state.") }, "handler": function() {Lino.cal.MyPresences.grid.run(null)} } ] }, "text": "Calendar" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "Stale Controllables", "handler": function() {Lino.contenttypes.StaleControllables.grid.run(null)} } ] }, "text": "System" }, { "menu": { "items": [ { "text": "Debtors", "listeners": { "render": Lino.quicktip_renderer("Foo","List of partners (usually clients)     who are in debt towards us.") }, "handler": function() {Lino.ledger.Debtors.grid.run(null)} }, { "text": "Creditors", "listeners": { "render": Lino.quicktip_renderer("Foo","List of partners (usually suppliers)     who are giving credit to us.") }, "handler": function() {Lino.ledger.Creditors.grid.run(null)} } ] }, "text": "Accounting" } ] }, "text": "Reports" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "Help Texts", "handler": function() {Lino.contenttypes.HelpTexts.grid.run(null)} }, { "text": "Site Parameters", "iconCls": "x-tbar-application_form", "handler": function() {Lino.system.SiteConfigs.detail.run(null,{ "record_id": 1 })} }, { "text": "Users", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows the list of all users on this site.") }, "handler": function() {Lino.users.Users.grid.run(null)} } ] }, "text": "System" }, { "menu": { "items": [ { "text": "My Text Field Templates", "handler": function() {Lino.system.MyTextFieldTemplates.grid.run(null)} }, { "text": "Upload Types", "handler": function() {Lino.uploads.UploadTypes.grid.run(null)} }, { "text": "Excerpt Types", "handler": function() {Lino.excerpts.ExcerptTypes.grid.run(null)} } ] }, "text": "Office" }, { "menu": { "items": [ { "text": "Countries", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    A country is a geographic entity considered a \"nation\".\n    ") }, "handler": function() {Lino.countries.Countries.grid.run(null)} }, { "text": "Places", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    The table of known geographical places.\n    A geographical place can be a city, a town, a suburb,\n    a province, a lake... any named geographic entity,\n    except for countries because these have their own table.\n    ") }, "handler": function() {Lino.countries.Places.grid.run(null)} } ] }, "text": "Places" }, { "menu": { "items": [ { "text": "Property Groups", "handler": function() {Lino.properties.PropGroups.grid.run(null)} }, { "text": "Property Types", "handler": function() {Lino.properties.PropTypes.grid.run(null)} } ] }, "text": "Properties" }, { "menu": { "items": [ { "text": "Organization types", "handler": function() {Lino.contacts.CompanyTypes.grid.run(null)} }, { "text": "Functions", "handler": function() {Lino.contacts.RoleTypes.grid.run(null)} }, { "text": "Household Types", "handler": function() {Lino.households.Types.grid.run(null)} }, { "text": "List Types", "handler": function() {Lino.lists.ListTypes.grid.run(null)} } ] }, "text": "Contacts" }, { "menu": { "items": [ { "text": "Account Charts", "handler": function() {Lino.accounts.Charts.grid.run(null)} }, { "text": "Account Groups", "handler": function() {Lino.accounts.Groups.grid.run(null)} }, { "text": "Accounts", "handler": function() {Lino.accounts.Accounts.grid.run(null)} }, { "text": "Journals", "handler": function() {Lino.ledger.Journals.grid.run(null)} } ] }, "text": "Accounting" }, { "menu": { "items": [ { "text": "Payment Terms", "handler": function() {Lino.vat.PaymentTerms.grid.run(null)} }, { "text": "VAT rates", "handler": function() {Lino.vat.VatRates.grid.run(null)} } ] }, "text": "VAT" }, { "menu": { "items": [ { "text": "Shipping Modes", "handler": function() {Lino.sales.ShippingModes.grid.run(null)} } ] }, "text": "Sales" }, { "menu": { "items": [ { "text": "Blog Entry Types", "handler": function() {Lino.blogs.EntryTypes.grid.run(null)} } ] }, "text": "Blog" }, { "menu": { "items": [ { "text": "Project Types", "handler": function() {Lino.tickets.ProjectTypes.grid.run(null)} }, { "text": "Session Types", "handler": function() {Lino.tickets.SessionTypes.grid.run(null)} } ] }, "text": "Tickets" }, { "menu": { "items": [ { "text": "Calendars", "handler": function() {Lino.cal.Calendars.grid.run(null)} }, { "text": "Rooms", "listeners": { "render": Lino.quicktip_renderer("Foo","List of rooms where calendar events can happen.") }, "handler": function() {Lino.cal.Rooms.grid.run(null)} }, { "text": "Priorities", "listeners": { "render": Lino.quicktip_renderer("Foo","List of possible priorities of calendar events.") }, "handler": function() {Lino.cal.Priorities.grid.run(null)} }, { "text": "Recurrent Events", "handler": function() {Lino.cal.RecurrentEvents.grid.run(null)} }, { "text": "Guest Roles", "listeners": { "render": Lino.quicktip_renderer("Foo","The role of a guest expresses what the partner is going to do there.") }, "handler": function() {Lino.cal.GuestRoles.grid.run(null)} }, { "text": "Event Types", "listeners": { "render": Lino.quicktip_renderer("Foo","The list of Event Types defined on this system.\n    An EventType is a list of events which have certain things in common,\n    especially they are displayed in the same colour in the calendar panel") }, "handler": function() {Lino.cal.EventTypes.grid.run(null)} }, { "text": "Remote Calendars", "handler": function() {Lino.cal.RemoteCalendars.grid.run(null)} } ] }, "text": "Calendar" } ] }, "text": "Configure" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "content types", "handler": function() {Lino.contenttypes.ContentTypes.grid.run(null)} }, { "text": "Authorities", "handler": function() {Lino.users.Authorities.grid.run(null)} }, { "text": "User Groups", "handler": function() {Lino.users.UserGroups.grid.run(null)} }, { "text": "User Levels", "handler": function() {Lino.users.UserLevels.grid.run(null)} }, { "text": "User Profiles", "handler": function() {Lino.users.UserProfiles.grid.run(null)} } ] }, "text": "System" }, { "menu": { "items": [ { "text": "Text Field Templates", "handler": function() {Lino.system.TextFieldTemplates.grid.run(null)} }, { "text": "Uploads", "handler": function() {Lino.uploads.Uploads.grid.run(null)} }, { "text": "Upload Areas", "handler": function() {Lino.uploads.UploadAreas.grid.run(null)} }, { "text": "Outgoing Mails", "handler": function() {Lino.outbox.Mails.grid.run(null)} }, { "text": "Attachments", "handler": function() {Lino.outbox.Attachments.grid.run(null)} }, { "text": "Excerpts", "handler": function() {Lino.excerpts.Excerpts.grid.run(null)} } ] }, "text": "Office" }, { "menu": { "items": [ { "text": "Properties", "handler": function() {Lino.properties.Properties.grid.run(null)} } ] }, "text": "Properties" }, { "menu": { "items": [ { "text": "Contact Persons", "handler": function() {Lino.contacts.Roles.grid.run(null)} }, { "text": "Roles", "handler": function() {Lino.households.MemberRoles.grid.run(null)} }, { "text": "Household Members", "handler": function() {Lino.households.Members.grid.run(null)} }, { "text": "List memberships", "handler": function() {Lino.lists.Members.grid.run(null)} }, { "text": "Address types", "handler": function() {Lino.addresses.AddressTypes.grid.run(null)} }, { "text": "Addresses", "handler": function() {Lino.addresses.Addresses.grid.run(null)} }, { "text": "Personal Links", "handler": function() {Lino.humanlinks.Links.grid.run(null)} }, { "text": "Parency types", "handler": function() {Lino.humanlinks.LinkTypes.grid.run(null)} } ] }, "text": "Contacts" }, { "menu": { "items": [ { "text": "Invoices", "handler": function() {Lino.ledger.Invoices.grid.run(null)} }, { "text": "Vouchers", "handler": function() {Lino.ledger.Vouchers.grid.run(null)} }, { "text": "VoucherTypes", "handler": function() {Lino.ledger.VoucherTypes.grid.run(null)} }, { "text": "Movements", "handler": function() {Lino.ledger.Movements.grid.run(null)} }, { "text": "Fiscal Years", "handler": function() {Lino.ledger.FiscalYears.grid.run(null)} } ] }, "text": "Accounting" }, { "menu": { "items": [ { "text": "VatRegimes", "listeners": { "render": Lino.quicktip_renderer("Foo","Determines how the VAT is being handled,         i.e. whether and how it is to be paid.") }, "handler": function() {Lino.vat.VatRegimes.grid.run(null)} }, { "text": "TradeTypes", "listeners": { "render": Lino.quicktip_renderer("Foo","The type of trade: usually either `sales` or `purchases`.") }, "handler": function() {Lino.vat.TradeTypes.grid.run(null)} }, { "text": "VatClasses", "handler": function() {Lino.vat.VatClasses.grid.run(null)} } ] }, "text": "VAT" }, { "menu": { "items": [ { "text": "Accounts", "handler": function() {Lino.sepa.Accounts.grid.run(null)} } ] }, "text": "SEPA" }, { "menu": { "items": [ { "text": "Bank Statements", "handler": function() {Lino.finan.BankStatements.grid.run(null)} }, { "text": "Journal Entries", "handler": function() {Lino.finan.JournalEntries.grid.run(null)} }, { "text": "Payment Orders", "handler": function() {Lino.finan.PaymentOrders.grid.run(null)} } ] }, "text": "Financial" }, { "menu": { "items": [ { "text": "Blog Entries", "handler": function() {Lino.blogs.Entries.grid.run(null)} } ] }, "text": "Blog" }, { "menu": { "items": [ { "text": "Projects", "handler": function() {Lino.tickets.Projects.grid.run(null)} }, { "text": "Tickets", "handler": function() {Lino.tickets.Tickets.grid.run(null)} }, { "text": "Sessions", "handler": function() {Lino.tickets.Sessions.grid.run(null)} }, { "text": "Milestones", "handler": function() {Lino.tickets.Milestones.grid.run(null)} }, { "text": "Dependencies", "handler": function() {Lino.tickets.Dependencies.grid.run(null)} }, { "text": "Votes", "handler": function() {Lino.tickets.Votes.grid.run(null)} } ] }, "text": "Tickets" }, { "menu": { "items": [ { "text": "Tasks", "listeners": { "render": Lino.quicktip_renderer("Foo","A calendar task is something you need to do.\n    ") }, "handler": function() {Lino.cal.Tasks.grid.run(null)} }, { "text": "Participants", "listeners": { "render": Lino.quicktip_renderer("Foo","A guest is a partner invited to an event. ") }, "handler": function() {Lino.cal.Guests.grid.run(null)} }, { "text": "Subscriptions", "handler": function() {Lino.cal.Subscriptions.grid.run(null)} }, { "text": "Event states", "listeners": { "render": Lino.quicktip_renderer("Foo","The possible states of a calendar event.") }, "handler": function() {Lino.cal.EventStates.grid.run(null)} }, { "text": "Guest states", "handler": function() {Lino.cal.GuestStates.grid.run(null)} }, { "text": "Task states", "handler": function() {Lino.cal.TaskStates.grid.run(null)} } ] }, "text": "Calendar" } ] }, "text": "Explorer" }, { "menu": { "items": [ { "text": "About", "listeners": { "render": Lino.quicktip_renderer("Foo","Show information about this site.") }, "handler": function() {Lino.about.About.show.run(null,{ "record_id": -99998 })} } ] }, "text": "Site" }, { "text": "Home", "handler": function() {Lino.handle_home_button()} } ];
Ext.namespace('Lino.contenttypes.ContentTypes')
Ext.namespace('Lino.contenttypes.HelpTexts')
Ext.namespace('Lino.system.SiteConfigs')
Ext.namespace('Lino.system.TextFieldTemplates')
Ext.namespace('Lino.users.Users')
Ext.namespace('Lino.users.MySettings')
Ext.namespace('Lino.users.UsersOverview')
Ext.namespace('Lino.users.Authorities')
Ext.namespace('Lino.countries.Countries')
Ext.namespace('Lino.countries.Places')
Ext.namespace('Lino.properties.PropGroups')
Ext.namespace('Lino.properties.PropTypes')
Ext.namespace('Lino.properties.Properties')
Ext.namespace('Lino.properties.PropChoices')
Ext.namespace('Lino.contacts.CompanyTypes')
Ext.namespace('Lino.contacts.Partners')
Ext.namespace('Lino.contacts.RoleTypes')
Ext.namespace('Lino.contacts.Roles')
Ext.namespace('Lino.addresses.Addresses')
Ext.namespace('Lino.contacts.Persons')
Ext.namespace('Lino.contacts.Companies')
Ext.namespace('Lino.households.Types')
Ext.namespace('Lino.households.Households')
Ext.namespace('Lino.households.Members')
Ext.namespace('Lino.lists.ListTypes')
Ext.namespace('Lino.lists.Lists')
Ext.namespace('Lino.lists.Members')
Ext.namespace('Lino.humanlinks.Links')
Ext.namespace('Lino.accounts.Charts')
Ext.namespace('Lino.accounts.Groups')
Ext.namespace('Lino.accounts.Accounts')
Ext.namespace('Lino.vat.VatRates')
Ext.namespace('Lino.vat.PaymentTerms')
Ext.namespace('Lino.products.ProductCats')
Ext.namespace('Lino.products.Products')
Ext.namespace('Lino.ledger.Journals')
Ext.namespace('Lino.ledger.Vouchers')
Ext.namespace('Lino.ledger.Movements')
Ext.namespace('Lino.ledger.Invoices')
Ext.namespace('Lino.sepa.Accounts')
Ext.namespace('Lino.finan.JournalEntries')
Ext.namespace('Lino.finan.PaymentOrders')
Ext.namespace('Lino.finan.BankStatements')
Ext.namespace('Lino.sales.ShippingModes')
Ext.namespace('Lino.sales.Invoices')
Ext.namespace('Lino.sales.DocumentsToSign')
Ext.namespace('Lino.sales.InvoicingModes')
Ext.namespace('Lino.blogs.EntryTypes')
Ext.namespace('Lino.blogs.Entries')
Ext.namespace('Lino.tickets.ProjectTypes')
Ext.namespace('Lino.tickets.SessionTypes')
Ext.namespace('Lino.tickets.Projects')
Ext.namespace('Lino.tickets.Votes')
Ext.namespace('Lino.tickets.Milestones')
Ext.namespace('Lino.tickets.Tickets')
Ext.namespace('Lino.tickets.UnassignedTickets')
Ext.namespace('Lino.tickets.RecentTickets')
Ext.namespace('Lino.tickets.Dependencies')
Ext.namespace('Lino.tickets.Sessions')
Ext.namespace('Lino.uploads.UploadTypes')
Ext.namespace('Lino.uploads.Uploads')
Ext.namespace('Lino.uploads.AreaUploads')
Ext.namespace('Lino.cal.RemoteCalendars')
Ext.namespace('Lino.cal.Rooms')
Ext.namespace('Lino.cal.Priorities')
Ext.namespace('Lino.cal.Calendars')
Ext.namespace('Lino.cal.Subscriptions')
Ext.namespace('Lino.cal.Tasks')
Ext.namespace('Lino.cal.MyTasks')
Ext.namespace('Lino.cal.GuestRoles')
Ext.namespace('Lino.cal.Guests')
Ext.namespace('Lino.cal.MyPresences')
Ext.namespace('Lino.cal.MyPendingPresences')
Ext.namespace('Lino.cal.MyGuests')
Ext.namespace('Lino.outbox.Recipients')
Ext.namespace('Lino.outbox.Mails')
Ext.namespace('Lino.outbox.Attachments')
Ext.namespace('Lino.cal.EventTypes')
Ext.namespace('Lino.cal.RecurrentEvents')
Ext.namespace('Lino.cal.Events')
Ext.namespace('Lino.cal.EventsByDay')
Ext.namespace('Lino.cal.OneEvent')
Ext.namespace('Lino.cal.MyEvents')
Ext.namespace('Lino.cal.MyAssignedEvents')
Ext.namespace('Lino.extensible.PanelCalendars')
Ext.namespace('Lino.extensible.PanelEvents')
Ext.namespace('Lino.excerpts.ExcerptTypes')
Ext.namespace('Lino.excerpts.Excerpts')
Ext.namespace('Lino.excerpts.ExcerptsByX')
Ext.namespace('Lino.sales.InvoiceItemTable')
Ext.namespace('Lino.ledger.InvoiceItemTable')
Ext.namespace('Lino.finan.JournalEntryItemTable')
Ext.namespace('Lino.finan.BankStatementItemTable')
Ext.namespace('Lino.finan.PaymentOrderItemTable')
Ext.namespace('Lino.sessions.SessionTable')
Ext.namespace('Lino.system.MyTextFieldTemplates')
Ext.namespace('Lino.users.AuthoritiesGiven')
Ext.namespace('Lino.users.AuthoritiesTaken')
Ext.namespace('Lino.countries.PlacesByPlace')
Ext.namespace('Lino.countries.PlacesByCountry')
Ext.namespace('Lino.properties.PropsByGroup')
Ext.namespace('Lino.properties.PropsByType')
Ext.namespace('Lino.properties.ChoicesByType')
Ext.namespace('Lino.contacts.PartnersByCity')
Ext.namespace('Lino.contacts.PartnersByCountry')
Ext.namespace('Lino.contacts.RolesByCompany')
Ext.namespace('Lino.contacts.RolesByPerson')
Ext.namespace('Lino.addresses.AddressesByPartner')
Ext.namespace('Lino.households.HouseholdsByType')
Ext.namespace('Lino.households.MembersByHousehold')
Ext.namespace('Lino.households.SiblingsByPerson')
Ext.namespace('Lino.households.MembersByPerson')
Ext.namespace('Lino.lists.MembersByList')
Ext.namespace('Lino.lists.MembersByPartner')
Ext.namespace('Lino.humanlinks.LinksByHuman')
Ext.namespace('Lino.accounts.GroupsByChart')
Ext.namespace('Lino.accounts.AccountsByGroup')
Ext.namespace('Lino.products.ProductsByCategory')
Ext.namespace('Lino.ledger.MovementsByVoucher')
Ext.namespace('Lino.ledger.MovementsByPartner')
Ext.namespace('Lino.ledger.MovementsByAccount')
Ext.namespace('Lino.ledger.InvoicesByJournal')
Ext.namespace('Lino.ledger.ItemsByInvoice')
Ext.namespace('Lino.sepa.AccountsByPartner')
Ext.namespace('Lino.finan.PaymentOrdersByJournal')
Ext.namespace('Lino.finan.JournalEntriesByJournal')
Ext.namespace('Lino.finan.BankStatementsByJournal')
Ext.namespace('Lino.finan.ItemsByJournalEntry')
Ext.namespace('Lino.finan.ItemsByBankStatement')
Ext.namespace('Lino.finan.ItemsByPaymentOrder')
Ext.namespace('Lino.sales.ItemsByInvoicePrint')
Ext.namespace('Lino.sales.InvoiceItemsByProduct')
Ext.namespace('Lino.sales.InvoicesByJournal')
Ext.namespace('Lino.sales.InvoicesByPartner')
Ext.namespace('Lino.sales.ItemsByInvoice')
Ext.namespace('Lino.blogs.MyEntries')
Ext.namespace('Lino.blogs.EntriesByType')
Ext.namespace('Lino.tickets.ProjectsByProject')
Ext.namespace('Lino.tickets.VotesByTicket')
Ext.namespace('Lino.tickets.VotesByPartner')
Ext.namespace('Lino.tickets.MilestonesByProject')
Ext.namespace('Lino.tickets.TicketsByProject')
Ext.namespace('Lino.tickets.TicketsFixed')
Ext.namespace('Lino.tickets.TicketsReported')
Ext.namespace('Lino.tickets.ChildrenByTicket')
Ext.namespace('Lino.tickets.ParentsByTicket')
Ext.namespace('Lino.tickets.SessionsByTicket')
Ext.namespace('Lino.tickets.MySessions')
Ext.namespace('Lino.tickets.MySessionsByDate')
Ext.namespace('Lino.tickets.EntriesByTicket')
Ext.namespace('Lino.tickets.EntriesBySession')
Ext.namespace('Lino.tickets.MyProjects')
Ext.namespace('Lino.tickets.MyTickets')
Ext.namespace('Lino.uploads.UploadsByType')
Ext.namespace('Lino.uploads.MyUploads')
Ext.namespace('Lino.cal.SubscriptionsByUser')
Ext.namespace('Lino.cal.SubscriptionsByCalendar')
Ext.namespace('Lino.cal.TasksByUser')
Ext.namespace('Lino.cal.TasksByProject')
Ext.namespace('Lino.cal.GuestsByEvent')
Ext.namespace('Lino.cal.GuestsByRole')
Ext.namespace('Lino.cal.GuestsByPartner')
Ext.namespace('Lino.outbox.RecipientsByMail')
Ext.namespace('Lino.outbox.MyOutbox')
Ext.namespace('Lino.outbox.MailsByUser')
Ext.namespace('Lino.outbox.MailsByProject')
Ext.namespace('Lino.outbox.SentByPartner')
Ext.namespace('Lino.outbox.AttachmentsByMail')
Ext.namespace('Lino.cal.EventsByType')
Ext.namespace('Lino.cal.EventsByRoom')
Ext.namespace('Lino.cal.EventsByProject')
Ext.namespace('Lino.excerpts.MyExcerpts')
Ext.namespace('Lino.excerpts.ExcerptsByType')
Ext.namespace('Lino.excerpts.ExcerptsByProject')
Ext.namespace('Lino.contenttypes.HelpTextsByModel')
Ext.namespace('Lino.sales.InvoicingsByInvoiceable')
Ext.namespace('Lino.uploads.UploadsByController')
Ext.namespace('Lino.cal.TasksByController')
Ext.namespace('Lino.outbox.MailsByController')
Ext.namespace('Lino.outbox.AttachmentsByController')
Ext.namespace('Lino.cal.EventsByController')
Ext.namespace('Lino.excerpts.ExcerptsByOwner')
Ext.namespace('Lino.blogs.EntriesByController')
Ext.namespace('Lino.about.Models')
Ext.namespace('Lino.about.FieldsByModel')
Ext.namespace('Lino.about.Inspector')
Ext.namespace('Lino.about.DetailLayouts')
Ext.namespace('Lino.about.SourceFiles')
Ext.namespace('Lino.contenttypes.StaleControllables')
Ext.namespace('Lino.contenttypes.StaleControllablesByModel')
Ext.namespace('Lino.ledger.VouchersByPartner')
Ext.namespace('Lino.ledger.ExpectedMovements')
Ext.namespace('Lino.ledger.DebtsByAccount')
Ext.namespace('Lino.ledger.DebtsByPartner')
Ext.namespace('Lino.ledger.GeneralAccountsBalance')
Ext.namespace('Lino.ledger.PartnerAccountsBalance')
Ext.namespace('Lino.ledger.ClientAccountsBalance')
Ext.namespace('Lino.ledger.SupplierAccountsBalance')
Ext.namespace('Lino.ledger.Debtors')
Ext.namespace('Lino.ledger.Creditors')
Ext.namespace('Lino.finan.SuggestionsByVoucher')
Ext.namespace('Lino.finan.SuggestionsByJournalEntry')
Ext.namespace('Lino.finan.SuggestionsByPaymentOrder')
Ext.namespace('Lino.finan.SuggestionsByBankStatement')
Ext.namespace('Lino.sales.InvoicesToCreate')
Ext.namespace('Lino.sales.InvoiceablesByPartner')
Ext.namespace('Lino.about.About')
Ext.namespace('Lino.ledger.Situation')
Ext.namespace('Lino.ledger.ActivityReport')
Ext.namespace('Lino.extensible.CalendarPanel')
Ext.namespace('Lino.tickets.DependencyTypes')
Ext.namespace('Lino.vat.VatClasses')
Ext.namespace('Lino.vat.TradeTypes')
Ext.namespace('Lino.cal.DurationUnits')
Ext.namespace('Lino.uploads.UploadAreas')
Ext.namespace('Lino.cal.TaskStates')
Ext.namespace('Lino.addresses.DataSources')
Ext.namespace('Lino.users.UserLevels')
Ext.namespace('Lino.cal.Weekdays')
Ext.namespace('Lino.ledger.InvoiceStates')
Ext.namespace('Lino.ledger.FiscalYears')
Ext.namespace('Lino.outbox.RecipientTypes')
Ext.namespace('Lino.excerpts.Shortcuts')
Ext.namespace('Lino.system.PeriodEvents')
Ext.namespace('Lino.cal.EventStates')
Ext.namespace('Lino.accounts.AccountTypes')
Ext.namespace('Lino.cal.Recurrencies')
Ext.namespace('Lino.system.Genders')
Ext.namespace('Lino.properties.HowWell')
Ext.namespace('Lino.lino.BuildMethods')
Ext.namespace('Lino.cal.EventEvents')
Ext.namespace('Lino.households.MemberRoles')
Ext.namespace('Lino.cal.GuestStates')
Ext.namespace('Lino.properties.DoYouLike')
Ext.namespace('Lino.vat.VatRegimes')
Ext.namespace('Lino.addresses.AddressTypes')
Ext.namespace('Lino.users.UserGroups')
Ext.namespace('Lino.ledger.VoucherTypes')
Ext.namespace('Lino.finan.VoucherStates')
Ext.namespace('Lino.humanlinks.LinkTypes')
Ext.namespace('Lino.tickets.TicketEvents')
Ext.namespace('Lino.cal.AccessClasses')
Ext.namespace('Lino.users.UserProfiles')
Ext.namespace('Lino.system.YesNo')
Ext.namespace('Lino.sales.InvoiceStates')
Ext.namespace('Lino.countries.PlaceTypes')
Ext.namespace('Lino.tickets.TicketStates')

// ChoiceLists: 
Lino.tickets.DependencyTypes = [ [ "10", "Duplicate" ], [ "20", "Callback" ], [ "30", "Requires" ] ];
Lino.vat.VatClasses = [ [ "0", "Exempt" ], [ "1", "Reduced" ], [ "2", "Normal" ] ];
Lino.vat.TradeTypes = [ [ "S", "Sales" ], [ "P", "Purchases" ], [ "W", "Wages" ], [ "C", "Clearings" ] ];
Lino.cal.DurationUnits = [ [ "s", "seconds" ], [ "m", "minutes" ], [ "h", "hours" ], [ "D", "days" ], [ "W", "weeks" ], [ "M", "months" ], [ "Y", "years" ] ];
Lino.uploads.UploadAreas = [ [ "90", "Uploads" ] ];
Lino.cal.TaskStates = [ [ "10", "To do" ], [ "20", "Started" ], [ "30", "Done" ], [ "50", "Cancelled" ] ];
Lino.addresses.DataSources = [ [ "01", "Manually entered" ], [ "02", "Read from eID" ] ];
Lino.users.UserLevels = [ [ "10", "Guest" ], [ "30", "User" ], [ "40", "Manager" ], [ "50", "Administrator" ] ];
Lino.cal.Weekdays = [ [ "1", "Monday" ], [ "2", "Tuesday" ], [ "3", "Wednesday" ], [ "4", "Thursday" ], [ "5", "Friday" ], [ "6", "Saturday" ], [ "7", "Sunday" ] ];
Lino.ledger.InvoiceStates = [ [ "10", "Draft" ], [ "20", "Registered" ], [ "40", "Paid" ] ];
Lino.ledger.FiscalYears = [ [ "11", "2011" ], [ "12", "2012" ], [ "13", "2013" ], [ "14", "2014" ], [ "15", "2015" ], [ "16", "2016" ], [ "17", "2017" ], [ "18", "2018" ], [ "19", "2019" ] ];
Lino.outbox.RecipientTypes = [ [ "to", "to" ], [ "cc", "cc" ], [ "bcc", "bcc" ] ];
Lino.excerpts.Shortcuts = [  ];
Lino.system.PeriodEvents = [ [ "10", "Started" ], [ "20", "Active" ], [ "30", "Ended" ] ];
Lino.cal.EventStates = [ [ "10", "Suggested" ], [ "20", "Draft" ], [ "50", "Took place" ], [ "70", "Cancelled" ], [ "75", "Omitted" ], [ "40", "Published" ] ];
Lino.accounts.AccountTypes = [ [ "A", "Assets" ], [ "L", "Liabilities" ], [ "I", "Incomes" ], [ "E", "Expenses" ], [ "C", "Capital" ], [ "B", "Bank accounts" ] ];
Lino.cal.Recurrencies = [ [ "O", "once" ], [ "D", "daily" ], [ "W", "weekly" ], [ "M", "monthly" ], [ "Y", "yearly" ], [ "P", "per weekday" ] ];
Lino.system.Genders = [ [ "M", "Male" ], [ "F", "Female" ] ];
Lino.properties.HowWell = [ [ "0", "not at all" ], [ "1", "a bit" ], [ "2", "moderate" ], [ "3", "quite well" ], [ "4", "very well" ] ];
Lino.lino.BuildMethods = [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appydoc", "AppyDocBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ];
Lino.cal.EventEvents = [ [ "10", "Okay" ], [ "20", "Pending" ] ];
Lino.households.MemberRoles = [ [ "01", "Head of household" ], [ "02", "Spouse" ], [ "03", "Partner" ], [ "04", "Cohabitant" ], [ "05", "Child" ], [ "07", "Adopted child" ], [ "06", "Relative" ] ];
Lino.cal.GuestStates = [ [ "10", "Invited" ], [ "20", "Accepted" ], [ "30", "Rejected" ], [ "40", "Present" ], [ "50", "Absent" ], [ "60", "Excused" ] ];
Lino.properties.DoYouLike = [ [ "0", "certainly not" ], [ "1", "rather not" ], [ "2", "normally" ], [ "3", "quite much" ], [ "4", "very much" ] ];
Lino.vat.VatRegimes = [ [ "10", "Private person" ], [ "20", "Subject to VAT" ], [ "25", "Co-contractor" ], [ "30", "Intra-community" ], [ "40", "Outside EU" ], [ "50", "Exempt" ] ];
Lino.addresses.AddressTypes = [ [ "01", "Official address" ], [ "02", "Unverified address" ], [ "03", "Declared address" ], [ "04", "Reference address" ] ];
Lino.users.UserGroups = [ [ "office", "office (Office)" ], [ "accounts", "accounts (Accounting)" ] ];
Lino.ledger.VoucherTypes = [ [ "ledger.AccountInvoice", "Invoice (ledger.AccountInvoice)" ], [ "finan.JournalEntry", "Journal Entry (finan.JournalEntry)" ], [ "finan.PaymentOrder", "Payment Order (finan.PaymentOrder)" ], [ "finan.BankStatement", "Bank Statement (finan.BankStatement)" ], [ "sales.Invoice", "Invoice (sales.Invoice)" ] ];
Lino.finan.VoucherStates = [ [ "10", "Draft" ], [ "20", "Registered" ] ];
Lino.humanlinks.LinkTypes = [ [ "01", "Son (Daughter)" ], [ "02", "Adopted son (Adopted daughter)" ], [ "03", "Grandson (Granddaughter)" ], [ "05", "Husband (Wife)" ], [ "06", "Friend (Friend)" ], [ "07", "Partner (Partner)" ], [ "08", "Stepson (Stepdaughter)" ], [ "10", "Brother (Sister)" ], [ "11", "Cousin (Cousin)" ], [ "12", "Nephew (Niece)" ], [ "80", "Relative (Relative)" ], [ "90", "Other (Other)" ] ];
Lino.tickets.TicketEvents = [ [ "10", "Opened" ], [ "20", "Closed" ] ];
Lino.cal.AccessClasses = [ [ "10", "Private" ], [ "20", "Show busy" ], [ "30", "Public" ] ];
Lino.users.UserProfiles = [ [ "000", "000 (Anonymous)" ], [ "100", "100 (User)" ], [ "900", "900 (Administrator)" ] ];
Lino.system.YesNo = [ [ "y", "Yes" ], [ "n", "No" ] ];
Lino.sales.InvoiceStates = [ [ "10", "Draft" ], [ "20", "Registered" ], [ "30", "Signed" ], [ "40", "Sent" ], [ "50", "Paid" ] ];
Lino.countries.PlaceTypes = [ [ "10", "Member State" ], [ "11", "Division" ], [ "12", "Region" ], [ "13", "Community" ], [ "14", "Territory" ], [ "20", "County" ], [ "21", "Province" ], [ "22", "Shire" ], [ "23", "Subregion" ], [ "24", "Department" ], [ "25", "Arrondissement" ], [ "26", "Prefecture" ], [ "27", "District" ], [ "28", "Sector" ], [ "50", "City" ], [ "51", "Town" ], [ "52", "Municipality" ], [ "54", "Parish" ], [ "55", "Township" ], [ "56", "Quarter" ], [ "61", "Borough" ], [ "62", "Small borough" ], [ "70", "Village" ] ];
Lino.tickets.TicketStates = [ [ "10", "Accepted" ], [ "20", "Working" ], [ "30", "Waiting" ], [ "40", "Fixed" ], [ "50", "Tested" ], [ "60", "Closed" ], [ "90", "Cancelled" ] ];

Lino.ledger.Creditors.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  labelWidth: 117,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var today2347 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Situation on</span>", "name": "today", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Situation on","(ledger.Creditors.today) Date of observation") }, "anchor": "-20" });
    this.items = [ { "items": today2347, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ today2347 ];
    Lino.ledger.Creditors.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.ExpectedMovements.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 99,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'hbox',
  autoHeight: true,
  initComponent : function() {
    var trade_type2339 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Trade Type", "name": "trade_type", "hiddenName": "trade_typeHidden", "listeners": { "render": Lino.quicktip_renderer("Trade Type","(ledger.ExpectedMovements.trade_type) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.vat.TradeTypes) });
    var date_until2340 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Date until", "name": "date_until", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date until","(ledger.ExpectedMovements.date_until) ") }, "anchor": "-20" });
    this.items = [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": trade_type2339, "labelAlign": "top" }, { "flex": 52, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_until2340, "labelAlign": "top" } ];
    this.fields = [ trade_type2339, date_until2340 ];
    Lino.ledger.ExpectedMovements.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Events.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var start_date1722 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Period from</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Period from","(cal.Events.start_date) Start date of observed period") }, "value": null, "anchor": "-20" });
    var end_date1723 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">until</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("until","(cal.Events.end_date) End date of observed period") }, "value": null, "anchor": "-20" });
    var observed_event1724 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Observed event", "name": "observed_event", "hiddenName": "observed_eventHidden", "listeners": { "render": Lino.quicktip_renderer("Observed event","(cal.Events.observed_event) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.EventEvents) });
    var state1725 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">State</span>", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("State","(cal.Events.state) Only rows having this state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.EventStates) });
    var main_1_panel1726 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1722, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1723, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event1724, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state1725, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var user1731 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Managed by</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Managed by","(cal.Events.user) Only rows managed by this user.") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }) });
    var assigned_to1732 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Assigned to</span>", "name": "assigned_to", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "assigned_toHidden", "listeners": { "render": Lino.quicktip_renderer("Assigned to","(cal.Events.assigned_to) Only events assigned to this user.") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/assigned_to", "method": "GET" }) }) });
    var project1733 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail,Lino.tickets.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(cal.Events.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }) });
    var event_type1734 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Event Type", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail,Lino.cal.EventTypes.insert)}, "emptyText": "Select a Event Type...", "listeners": { "render": Lino.quicktip_renderer("Event Type","(cal.Events.event_type) ") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/event_type", "method": "GET" }) }) });
    var room1735 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Room", "name": "room", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Rooms.detail,Lino.cal.Rooms.insert)}, "emptyText": "Select a Room...", "listeners": { "render": Lino.quicktip_renderer("Room","(cal.Events.room) ") }, "selectOnFocus": true, "hiddenName": "roomHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/room", "method": "GET" }) }) });
    var show_appointments1736 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Appointments", "name": "show_appointments", "hiddenName": "show_appointmentsHidden", "listeners": { "render": Lino.quicktip_renderer("Appointments","(cal.Events.show_appointments) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.system.YesNo) });
    var main_2_panel1737 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1731, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": assigned_to1732, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1733, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type1734, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": room1735, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_appointments1736, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel1726, main_2_panel1737 ];
    this.fields = [ start_date1722, end_date1723, observed_event1724, state1725, user1731, assigned_to1732, project1733, event_type1734, room1735, show_appointments1736 ];
    Lino.cal.Events.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.Tickets.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 135,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'hbox',
  autoHeight: true,
  initComponent : function() {
    var user1483 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">User</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("User","(tickets.Tickets.user) Only rows authored by this user.") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/user", "method": "GET" }) }) });
    var project1484 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail,Lino.tickets.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(tickets.Tickets.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/project", "method": "GET" }) }) });
    var state1485 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">State</span>", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("State","(tickets.Tickets.state) Only rows having this state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.tickets.TicketStates) });
    var start_date1486 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Period from</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Period from","(tickets.Tickets.start_date) Start date of observed period") }, "value": null, "anchor": "-20" });
    var end_date1487 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">until</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("until","(tickets.Tickets.end_date) End date of observed period") }, "value": null, "anchor": "-20" });
    var observed_event1488 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Observed event", "name": "observed_event", "hiddenName": "observed_eventHidden", "listeners": { "render": Lino.quicktip_renderer("Observed event","(tickets.Tickets.observed_event) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.tickets.TicketEvents) });
    this.items = [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1483, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1484, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state1485, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1486, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1487, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event1488, "labelAlign": "top" } ];
    this.fields = [ user1483, project1484, state1485, start_date1486, end_date1487, observed_event1488 ];
    Lino.tickets.Tickets.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.about.Inspector.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 153,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'hbox',
  autoHeight: true,
  initComponent : function() {
    var inspected2334 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Inspected object", "name": "inspected", "maxLength": 100, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Inspected object","(about.Inspector.inspected) ") }, "anchor": "-20" });
    var show_callables2335 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "show_callables", "listeners": { "render": Lino.quicktip_renderer("show callables","(about.Inspector.show_callables) ") }, "boxLabel": "show callables", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "flex": 67, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inspected2334, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_callables2335, "labelAlign": "top" } ];
    this.fields = [ inspected2334, show_callables2335 ];
    Lino.about.Inspector.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.excerpts.Excerpts.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var start_date2222 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Period from</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Period from","(excerpts.Excerpts.start_date) Start date of observed period") }, "value": null, "anchor": "-20" });
    var end_date2223 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">until</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("until","(excerpts.Excerpts.end_date) End date of observed period") }, "value": null, "anchor": "-20" });
    var pcertifying2224 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Certifying excerpts", "name": "pcertifying", "hiddenName": "pcertifyingHidden", "listeners": { "render": Lino.quicktip_renderer("Certifying excerpts","(excerpts.Excerpts.pcertifying) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.system.YesNo) });
    var main_1_panel2225 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2222, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date2223, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pcertifying2224, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 180, "border": false, "anchor": "-20", "labelAlign": "top" });
    var puser2229 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "User", "name": "puser", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "puserHidden", "listeners": { "render": Lino.quicktip_renderer("User","(excerpts.Excerpts.puser) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/puser", "method": "GET" }) }) });
    var pexcerpt_type2230 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Excerpt Type", "name": "pexcerpt_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.excerpts.ExcerptTypes.detail,Lino.excerpts.ExcerptTypes.insert)}, "emptyText": "Select a Excerpt Type...", "listeners": { "render": Lino.quicktip_renderer("Excerpt Type","(excerpts.Excerpts.pexcerpt_type) ") }, "selectOnFocus": true, "hiddenName": "pexcerpt_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/pexcerpt_type", "method": "GET" }) }) });
    var main_2_panel2231 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": puser2229, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pexcerpt_type2230, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel2225, main_2_panel2231 ];
    this.fields = [ start_date2222, end_date2223, pcertifying2224, puser2229, pexcerpt_type2230 ];
    Lino.excerpts.Excerpts.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Movements.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var start_date184 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Period from</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Period from","(ledger.Movements.start_date) Start date of observed period") }, "value": null, "anchor": "-20" });
    var end_date185 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">until</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("until","(ledger.Movements.end_date) End date of observed period") }, "value": null, "anchor": "-20" });
    var cleared186 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Show cleared movements", "name": "cleared", "hiddenName": "clearedHidden", "listeners": { "render": Lino.quicktip_renderer("Show cleared movements","(ledger.Movements.cleared) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.system.YesNo) });
    var main_1_panel187 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date184, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date185, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cleared186, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 207, "border": false, "anchor": "-20", "labelAlign": "top" });
    var pjournal191 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Journal", "name": "pjournal", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail,Lino.ledger.Journals.insert)}, "emptyText": "Select a Journal...", "listeners": { "render": Lino.quicktip_renderer("Journal","(ledger.Movements.pjournal) ") }, "selectOnFocus": true, "hiddenName": "pjournalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Movements/pjournal", "method": "GET" }) }) });
    var pyear192 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "pyear", "hiddenName": "pyearHidden", "listeners": { "render": Lino.quicktip_renderer("Fiscal Year","(ledger.Movements.pyear) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var ppartner193 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "ppartner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "hiddenName": "ppartnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(ledger.Movements.ppartner) ") }, "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Movements/ppartner", "method": "GET" }) }) });
    var paccount194 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Account", "name": "paccount", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.accounts.Accounts.detail,Lino.accounts.Accounts.insert)}, "emptyText": "Select a Account...", "listeners": { "render": Lino.quicktip_renderer("Account","(ledger.Movements.paccount) ") }, "selectOnFocus": true, "hiddenName": "paccountHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Movements/paccount", "method": "GET" }) }) });
    var main_2_panel195 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pjournal191, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pyear192, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ppartner193, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": paccount194, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel187, main_2_panel195 ];
    this.fields = [ start_date184, end_date185, cleared186, pjournal191, pyear192, ppartner193, paccount194 ];
    Lino.ledger.Movements.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var start_date1788 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Period from</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Period from","(cal.Guests.start_date) Start date of observed period") }, "value": null, "anchor": "-20" });
    var end_date1789 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">until</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("until","(cal.Guests.end_date) End date of observed period") }, "value": null, "anchor": "-20" });
    var user1790 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Responsible user</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Responsible user","(cal.Guests.user) Only rows managed by this user.") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/user", "method": "GET" }) }) });
    var event_state1791 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Event state</span>", "name": "event_state", "hiddenName": "event_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Event state","(cal.Guests.event_state) Only rows having this event state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.EventStates) });
    var guest_state1792 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Guest state</span>", "name": "guest_state", "hiddenName": "guest_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Guest state","(cal.Guests.guest_state) Only rows having this guest state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.GuestStates) });
    var main_1_panel1793 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1788, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1789, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1790, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_state1791, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": guest_state1792, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var project1799 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail,Lino.tickets.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(cal.Guests.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/project", "method": "GET" }) }) });
    var partner1800 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "hiddenName": "partnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(cal.Guests.partner) ") }, "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }) });
    var main_2_panel1801 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1799, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1800, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel1793, main_2_panel1801 ];
    this.fields = [ start_date1788, end_date1789, user1790, event_state1791, guest_state1792, project1799, partner1800 ];
    Lino.cal.Guests.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.finan.JournalEntries.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 108,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'hbox',
  autoHeight: true,
  initComponent : function() {
    var pjournal302 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Journal", "name": "pjournal", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail,Lino.ledger.Journals.insert)}, "emptyText": "Select a Journal...", "listeners": { "render": Lino.quicktip_renderer("Journal","(finan.JournalEntries.pjournal) ") }, "selectOnFocus": true, "hiddenName": "pjournalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/JournalEntries/pjournal", "method": "GET" }) }) });
    var pyear303 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "pyear", "hiddenName": "pyearHidden", "listeners": { "render": Lino.quicktip_renderer("Fiscal Year","(finan.JournalEntries.pyear) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    this.items = [ { "flex": 74, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pjournal302, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pyear303, "labelAlign": "top" } ];
    this.fields = [ pjournal302, pyear303 ];
    Lino.finan.JournalEntries.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.sales.Invoices.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 108,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'hbox',
  autoHeight: true,
  initComponent : function() {
    var journal108 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Journal", "name": "journal", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail,Lino.ledger.Journals.insert)}, "emptyText": "Select a Journal...", "listeners": { "render": Lino.quicktip_renderer("Journal","(sales.Invoices.journal) ") }, "selectOnFocus": true, "hiddenName": "journalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/journal", "method": "GET" }) }) });
    var state109 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "State", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("State","(sales.Invoices.state) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.sales.InvoiceStates) });
    var year110 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "year", "hiddenName": "yearHidden", "listeners": { "render": Lino.quicktip_renderer("Fiscal Year","(sales.Invoices.year) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    this.items = [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": journal108, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state109, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": year110, "labelAlign": "top" } ];
    this.fields = [ journal108, state109, year110 ];
    Lino.sales.Invoices.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Invoices.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 108,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'hbox',
  autoHeight: true,
  initComponent : function() {
    var pjournal230 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Journal", "name": "pjournal", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail,Lino.ledger.Journals.insert)}, "emptyText": "Select a Journal...", "listeners": { "render": Lino.quicktip_renderer("Journal","(ledger.Invoices.pjournal) ") }, "selectOnFocus": true, "hiddenName": "pjournalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/pjournal", "method": "GET" }) }) });
    var pyear231 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "pyear", "hiddenName": "pyearHidden", "listeners": { "render": Lino.quicktip_renderer("Fiscal Year","(ledger.Invoices.pyear) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var ppartner232 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "ppartner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "hiddenName": "ppartnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(ledger.Invoices.ppartner) ") }, "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/ppartner", "method": "GET" }) }) });
    this.items = [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pjournal230, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pyear231, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ppartner232, "labelAlign": "top" } ];
    this.fields = [ pjournal230, pyear231, ppartner232 ];
    Lino.ledger.Invoices.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var start_date1925 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Period from</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Period from","(cal.Tasks.start_date) Start date of observed period") }, "value": null, "anchor": "-20" });
    var end_date1926 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">until</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("until","(cal.Tasks.end_date) End date of observed period") }, "value": null, "anchor": "-20" });
    var user1927 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Managed by</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Managed by","(cal.Tasks.user) Only rows managed by this user.") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var state1928 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">State</span>", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("State","(cal.Tasks.state) Only rows having this state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.TaskStates) });
    var project1929 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail,Lino.tickets.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(cal.Tasks.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_1_panel1930 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1925, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1926, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1927, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state1928, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1929, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    this.items = [ main_1_panel1930 ];
    this.fields = [ start_date1925, end_date1926, user1927, state1928, project1929 ];
    Lino.cal.Tasks.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Debtors.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  labelWidth: 117,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var today2344 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Situation on</span>", "name": "today", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Situation on","(ledger.Debtors.today) Date of observation") }, "anchor": "-20" });
    this.items = [ { "items": today2344, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ today2344 ];
    Lino.ledger.Debtors.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.MySessionsByDate.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  labelWidth: 45,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var today2309 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Date", "name": "today", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date","(tickets.MySessionsByDate.today) ") }, "anchor": "-20" });
    this.items = [ { "items": today2309, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ today2309 ];
    Lino.tickets.MySessionsByDate.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.wf2_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 270,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'wf2',
  ls_url: "/cal/Guests",
  window_title: "Reject",
  before_row_edit : function(record) {
  },
  initComponent : function() {
    this.notify_subject22 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Summary", "name": "notify_subject", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Summary","(<RejectInvitation wf2 (u'Reject')>.notify_subject) ") }, "anchor": "-20" });
    this.notify_body23 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(<RejectInvitation wf2 (u'Reject')>.notify_body) ") }, "fieldLabel": "Description", "name": "notify_body", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    this.notify_silent24 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "notify_silent", "listeners": { "render": Lino.quicktip_renderer("Don't send email notification","(<RejectInvitation wf2 (u'Reject')>.notify_silent) ") }, "boxLabel": "Don't send email notification", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": this.notify_subject22, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": this.notify_body23, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": this.notify_silent24, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ this.notify_subject22, this.notify_body23, this.notify_silent24 ];
    Lino.cal.Guests.wf2_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.Users.change_password_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 171,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'change_password',
  ls_url: "/users/Users",
  window_title: "Change password",
  before_row_edit : function(record) {
  },
  autoHeight: true,
  initComponent : function() {
    this.current1 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Current password", "name": "current", "inputType": "password", "listeners": { "render": Lino.quicktip_renderer("Current password","(<ChangePassword change_password (u'Change password')>.current) ") }, "maxLength": null, "selectOnFocus": true, "anchor": "-20" });
    this.new12 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "New password", "name": "new1", "inputType": "password", "listeners": { "render": Lino.quicktip_renderer("New password","(<ChangePassword change_password (u'Change password')>.new1) ") }, "maxLength": null, "selectOnFocus": true, "anchor": "-20" });
    this.new23 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "New password again", "name": "new2", "inputType": "password", "listeners": { "render": Lino.quicktip_renderer("New password again","(<ChangePassword change_password (u'Change password')>.new2) ") }, "maxLength": null, "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.current1, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.new12, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.new23, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ this.current1, this.new12, this.new23 ];
    Lino.users.Users.change_password_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.create_household_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 162,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'create_household',
  ls_url: "/contacts/Persons",
  window_title: "Create Household",
  before_row_edit : function(record) {
  },
  autoHeight: true,
  initComponent : function() {
    this.partner8 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "partnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(<CreateHousehold create_household (u'Create Household')>.partner) ") }, "selectOnFocus": true, "emptyText": "Select a Person...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/contacts/Persons/create_household/partner", "method": "GET" }) }) });
    this.type9 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Household Type", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.households.Types.detail,Lino.households.Types.insert)}, "emptyText": "Select a Household Type...", "listeners": { "render": Lino.quicktip_renderer("Household Type","(<CreateHousehold create_household (u'Create Household')>.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/contacts/Persons/create_household/type", "method": "GET" }) }), "name": "type" });
    this.head10 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Head of household", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "emptyText": "Select a Person...", "listeners": { "render": Lino.quicktip_renderer("Head of household","(<CreateHousehold create_household (u'Create Household')>.head) ") }, "selectOnFocus": true, "hiddenName": "headHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/contacts/Persons/create_household/head", "method": "GET" }) }), "name": "head" });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.partner8, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.type9, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": this.head10, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ this.partner8, this.type9, this.head10 ];
    Lino.contacts.Persons.create_household_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.wf1_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  border: false,
  layout: "vbox",
  labelWidth: 270,
  hideCheckBoxLabels: true,
  frame: true,
  layoutConfig: { "align": "stretch" },
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'wf1',
  ls_url: "/cal/Guests",
  window_title: "Accept",
  before_row_edit : function(record) {
  },
  initComponent : function() {
    this.notify_subject15 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Summary", "name": "notify_subject", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Summary","(<AcceptInvitation wf1 (u'Accept')>.notify_subject) ") }, "anchor": "-20" });
    this.notify_body16 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(<AcceptInvitation wf1 (u'Accept')>.notify_body) ") }, "fieldLabel": "Description", "name": "notify_body", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    this.notify_silent17 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "notify_silent", "listeners": { "render": Lino.quicktip_renderer("Don't send email notification","(<AcceptInvitation wf1 (u'Accept')>.notify_silent) ") }, "boxLabel": "Don't send email notification", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "items": this.notify_subject15, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": this.notify_body16, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 }, { "items": this.notify_silent17, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ this.notify_subject15, this.notify_body16, this.notify_silent17 ];
    Lino.cal.Guests.wf1_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.UploadTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 61,
  initComponent : function() {
    var id1620 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(uploads.UploadTypes.id) ") }, "anchor": "-20" });
    var upload_area1621 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Upload Area", "allowBlank": false, "hiddenName": "upload_areaHidden", "listeners": { "render": Lino.quicktip_renderer("Upload Area","(uploads.UploadTypes.upload_area) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.uploads.UploadAreas, "name": "upload_area" });
    var wanted1622 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "wanted", "listeners": { "render": Lino.quicktip_renderer("Wanted","(uploads.UploadTypes.wanted) Add a (+) button when there is no upload of this type.") }, "boxLabel": "Wanted", "selectOnFocus": true, "anchor": "-20" });
    var max_number1623 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Max. number</span>", "name": "max_number", "value": -1, "listeners": { "render": Lino.quicktip_renderer("Max. number","(uploads.UploadTypes.max_number) No need to upload more uploads than N of this type.\n-1 means no limit.") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel1624 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1620, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": upload_area1621, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": wanted1622, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": max_number1623, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var name1629 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(uploads.UploadTypes.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1630 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(uploads.UploadTypes.name_de) ") }, "anchor": "-20" });
    var name_fr1631 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(uploads.UploadTypes.name_fr) ") }, "anchor": "-20" });
    var name_et1632 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(uploads.UploadTypes.name_et) ") }, "anchor": "-20" });
    var main_2_panel1633 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1629, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1630, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1631, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1632, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var uploads_UploadsByType_grid1672 = new Lino.uploads.UploadsByType.GridPanel({ "flex": 71, "listeners": { "render": Lino.quicktip_renderer("Uploads","(uploads.uploads.UploadsByType) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByType.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1673 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1624, main_2_panel1633, uploads_UploadsByType_grid1672 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1673;
    this.before_row_edit = function(record) {
      uploads_UploadsByType_grid1672.on_master_changed();
    }
    Lino.uploads.UploadTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.Uploads.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 62,
  initComponent : function() {
    var file1648 = Lino.file_field_handler(this,{ "autoHeight": true, "fieldLabel": "File", "name": "file", "maxLength": 100, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("File","(uploads.Uploads.file) ") }, "anchor": "-20" });
    var user1649 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(uploads.Uploads.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel1650 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file1648, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1649, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var upload_area1653 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Upload Area", "allowBlank": false, "hiddenName": "upload_areaHidden", "listeners": { "render": Lino.quicktip_renderer("Upload Area","(uploads.Uploads.upload_area) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.uploads.UploadAreas, "name": "upload_area" });
    var type1654 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Upload Type", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.uploads.UploadTypes.detail,Lino.uploads.UploadTypes.insert)}, "emptyText": "Select a Upload Type...", "listeners": { "render": Lino.quicktip_renderer("Upload Type","(uploads.Uploads.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var description1655 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Description", "name": "description", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Description","(uploads.Uploads.description) ") }, "anchor": "-20" });
    var main_2_panel1656 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": upload_area1653, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1654, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": description1655, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var owner_disp1660 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Controlled by", "anchor": "-20", "name": "owner" });
    var main_panel1661 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 126, "autoScroll": false, "items": [ main_1_panel1650, main_2_panel1656, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp1660, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1661;
    this.before_row_edit = function(record) {
      type1654.setContextValue('upload_area', record ? record.data['upload_areaHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      upload_area1653.on('change',Lino.chooser_handler(type1654,'upload_area'));
      Lino.uploads.Uploads.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.uploads.Uploads.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.About.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var server_status_disp2351 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Server status", "name": "server_status", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Server status","(about.About.server_status) ") }, "anchor": "-20" });
    var main_panel2352 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "html": "<div class=\"htmlText\"><span>This is <a href=\"http://lino-framework.org/examples/presto/\" target=\"_blank\">Lino Presto</a> 0.1 using <a href=\"http://www.lino-framework.org\" target=\"_blank\">Lino</a> 1.6.16, <a href=\"http://www.djangoproject.com\" target=\"_blank\">Django</a> 1.6.7, <a href=\"http://www.python.org/\" target=\"_blank\">Python</a> 2.7.4, <a href=\"http://babel.edgewall.org/\" target=\"_blank\">Babel</a> 1.3, <a href=\"http://jinja.pocoo.org/\" target=\"_blank\">Jinja</a> 2.7.3, <a href=\"http://sphinx-doc.org/\" target=\"_blank\">Sphinx</a> 1.3b3, <a href=\"http://labix.org/python-dateutil\" target=\"_blank\">python-dateutil</a> 2.1, <a href=\"http://pypi.python.org/pypi/odfpy\" target=\"_blank\">OdfPy</a> ODFPY/0.9.6, <a href=\"http://docutils.sourceforge.net/\" target=\"_blank\">docutils</a> 0.11, <a href=\"https://fedorahosted.org/suds/\" target=\"_blank\">suds</a> 0.4, <a href=\"http://pyyaml.org/\" target=\"_blank\">PyYaml</a> 3.10, <a href=\"http://appyframework.org/pod.html\" target=\"_blank\">Appy</a> 0.9.0 (2014/06/23 22:15), <a href=\"http://www.sencha.com\" target=\"_blank\">ExtJS</a> <a href=\"#\" onclick=\"alert('ExtJS client version is ' + Ext.version);\" title=\"Click to see ExtJS client version\">(version)</a>, <a href=\"http://www.famfamfam.com/lab/icons/silk/\" target=\"_blank\">Silk Icons</a> 1.3, <a href=\"http://getbootstrap.com\" target=\"_blank\">Bootstrap</a> 3.x, <a href=\"http://ext.ensible.com/products/calendar/\" target=\"_blank\">Ext.ensible adapter</a> <a href=\"#\" onclick=\"alert('Extensible Calendar version is '             + Ext.ensible.version);\" title=\"Click to see Extensible Calendar version\">(version)</a></span><p>Server uptime : <b>Tuesday, January 6, 2015 at 04:02:11.190697</b></p><p>Source timestamps:</p><ul><li>lino : <b>Tuesday, January 6, 2015 at 03:50:06.880755</b></li><li>atelier : <b>Wednesday, December 31, 2014 at 10:07:12.701056</b></li><li>django : <b>Monday, October 27, 2014 at 16:34:33.459643</b></li></ul></div>", "xtype": "label" }, { "items": server_status_disp2351, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2352;
    this.before_row_edit = function(record) {
    }
    Lino.about.About.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.Milestones.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 58,
  initComponent : function() {
    var project1614 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail,Lino.tickets.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(tickets.Milestones.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Milestones/project", "method": "GET" }) }) });
    var ref1615 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Reference", "name": "ref", "maxLength": 40, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Reference","(tickets.Milestones.ref) ") }, "anchor": "-20" });
    var main_1_panel1616 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1614, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1615, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var main_panel1619 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "hideCheckBoxLabels": true, "items": [ main_1_panel1616 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1619;
    this.before_row_edit = function(record) {
    }
    Lino.tickets.Milestones.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Types.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 22,
  initComponent : function() {
    var name955 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(households.Types.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de956 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(households.Types.name_de) ") }, "anchor": "-20" });
    var name_fr957 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(households.Types.name_fr) ") }, "anchor": "-20" });
    var name_et958 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(households.Types.name_et) ") }, "anchor": "-20" });
    var main_1_panel959 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name955, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de956, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr957, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et958, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var HouseholdsByType_grid1046 = new Lino.households.HouseholdsByType.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Households","(households.households.HouseholdsByType) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.HouseholdsByType.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1047 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel959, HouseholdsByType_grid1046 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1047;
    this.before_row_edit = function(record) {
      HouseholdsByType_grid1046.on_master_changed();
    }
    Lino.households.Types.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Journals.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 33,
  initComponent : function() {
    var ref1351 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "ref", "name": "ref", "maxLength": 20, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ref","(ledger.Journals.ref) ") }, "anchor": "-20" });
    var name1352 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(ledger.Journals.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1353 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(ledger.Journals.name_de) ") }, "anchor": "-20" });
    var name_fr1354 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(ledger.Journals.name_fr) ") }, "anchor": "-20" });
    var name_et1355 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(ledger.Journals.name_et) ") }, "anchor": "-20" });
    var main_1_panel1356 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1351, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1352, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1353, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1354, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1355, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var trade_type1362 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Trade Type", "name": "trade_type", "hiddenName": "trade_typeHidden", "listeners": { "render": Lino.quicktip_renderer("Trade Type","(ledger.Journals.trade_type) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.vat.TradeTypes) });
    var voucher_type1363 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "voucher type", "allowBlank": false, "hiddenName": "voucher_typeHidden", "listeners": { "render": Lino.quicktip_renderer("voucher type","(ledger.Journals.voucher_type) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.ledger.VoucherTypes, "name": "voucher_type" });
    var main_panel1364 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 117, "autoScroll": false, "items": [ main_1_panel1356, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": trade_type1362, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": voucher_type1363, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1364;
    this.before_row_edit = function(record) {
    }
    Lino.ledger.Journals.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Rooms.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 64,
  initComponent : function() {
    var id1686 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.Rooms.id) ") }, "anchor": "-20" });
    var name1687 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(cal.Rooms.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1688 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(cal.Rooms.name_de) ") }, "anchor": "-20" });
    var name_fr1689 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(cal.Rooms.name_fr) ") }, "anchor": "-20" });
    var name_et1690 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(cal.Rooms.name_et) ") }, "anchor": "-20" });
    var main_1_panel1691 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1686, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1687, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1688, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1689, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1690, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_EventsByRoom_grid1856 = new Lino.cal.EventsByRoom.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Events","(cal.cal.EventsByRoom) ") }, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByRoom.grid) ] });
    var main_panel1857 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1691, cal_EventsByRoom_grid1856 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1857;
    this.before_row_edit = function(record) {
      cal_EventsByRoom_grid1856.on_master_changed();
    }
    Lino.cal.Rooms.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.Sessions.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 57,
  initComponent : function() {
    var date1542 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date","(tickets.Sessions.date) ") }, "anchor": "-20" });
    var start_time1543 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "Start time", "name": "start_time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start time","(tickets.Sessions.start_time) ") }, "anchor": "-20" });
    var end_time1544 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "End Time", "name": "end_time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("End Time","(tickets.Sessions.end_time) ") }, "anchor": "-20" });
    var break_time1545 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "Break Time", "name": "break_time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Break Time","(tickets.Sessions.break_time) ") }, "anchor": "-20" });
    var ticket1546 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Ticket", "name": "ticket", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Tickets.detail,Lino.tickets.Tickets.insert)}, "emptyText": "Select a Ticket...", "listeners": { "render": Lino.quicktip_renderer("Ticket","(tickets.Sessions.ticket) ") }, "selectOnFocus": true, "hiddenName": "ticketHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Sessions/ticket", "method": "GET" }) }) });
    var main_1_panel1547 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date1542, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time1543, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time1544, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": break_time1545, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ticket1546, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user1553 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(tickets.Sessions.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Sessions/user", "method": "GET" }) }) });
    var id1554 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(tickets.Sessions.id) ") }, "anchor": "-20" });
    var main_2_panel1555 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 63, "hideCheckBoxLabels": true, "items": [ { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1553, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1554, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description1558 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(tickets.Sessions.description) ") }, "fieldLabel": "Description", "name": "description", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var main_panel1559 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ main_1_panel1547, main_2_panel1555, { "items": description1558, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1559;
    this.before_row_edit = function(record) {
    }
    Lino.tickets.Sessions.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.GuestRoles.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 70,
  initComponent : function() {
    var id1937 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.GuestRoles.id) ") }, "anchor": "-20" });
    var name1938 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(cal.GuestRoles.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1939 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(cal.GuestRoles.name_de) ") }, "anchor": "-20" });
    var name_fr1940 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(cal.GuestRoles.name_fr) ") }, "anchor": "-20" });
    var name_et1941 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(cal.GuestRoles.name_et) ") }, "anchor": "-20" });
    var main_1_panel1942 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1937, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1938, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1939, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1940, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1941, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_GuestsByRole_grid1956 = new Lino.cal.GuestsByRole.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Participants","(cal.cal.GuestsByRole) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.GuestsByRole.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1957 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1942, cal_GuestsByRole_grid1956 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1957;
    this.before_row_edit = function(record) {
      cal_GuestsByRole_grid1956.on_master_changed();
    }
    Lino.cal.GuestRoles.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.RecurrentEvents.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 65,
  initComponent : function() {
    var name2153 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(cal.RecurrentEvents.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de2154 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(cal.RecurrentEvents.name_de) ") }, "anchor": "-20" });
    var name_fr2155 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(cal.RecurrentEvents.name_fr) ") }, "anchor": "-20" });
    var name_et2156 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(cal.RecurrentEvents.name_et) ") }, "anchor": "-20" });
    var main_1_panel2157 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2153, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de2154, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2155, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et2156, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var start_date2162 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Start date", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start date","(cal.RecurrentEvents.start_date) ") }, "anchor": "-20" });
    var end_date2163 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "End Date", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("End Date","(cal.RecurrentEvents.end_date) ") }, "anchor": "-20" });
    var every_unit2164 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Recurrency", "allowBlank": false, "hiddenName": "every_unitHidden", "listeners": { "render": Lino.quicktip_renderer("Recurrency","(cal.RecurrentEvents.every_unit) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.Recurrencies, "name": "every_unit" });
    var event_type2165 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Event Type", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail,Lino.cal.EventTypes.insert)}, "emptyText": "Select a Event Type...", "listeners": { "render": Lino.quicktip_renderer("Event Type","(cal.RecurrentEvents.event_type) ") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/RecurrentEvents/event_type", "method": "GET" }) }) });
    var main_2_panel2166 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2162, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date2163, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": every_unit2164, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type2165, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel2171 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel2157, main_2_panel2166 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2171;
    this.before_row_edit = function(record) {
    }
    Lino.cal.RecurrentEvents.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.lists.Lists.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 25,
  initComponent : function() {
    var ref1048 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Reference", "name": "ref", "maxLength": 40, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Reference","(lists.Lists.ref) ") }, "anchor": "-20" });
    var list_type1049 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "List Type", "name": "list_type", "pageSize": 20, "emptyText": "Select a List Type...", "listeners": { "render": Lino.quicktip_renderer("List Type","(lists.Lists.list_type) ") }, "selectOnFocus": true, "hiddenName": "list_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/lists/Lists/list_type", "method": "GET" }) }) });
    var id1050 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(lists.Lists.id) ") }, "anchor": "-20" });
    var main_1_panel1051 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1048, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": list_type1049, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1050, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var name1055 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(lists.Lists.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1056 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(lists.Lists.name_de) ") }, "anchor": "-20" });
    var name_fr1057 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(lists.Lists.name_fr) ") }, "anchor": "-20" });
    var name_et1058 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(lists.Lists.name_et) ") }, "anchor": "-20" });
    var main_2_panel1059 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1055, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1056, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1057, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1058, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks1064 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remarks","(lists.Lists.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var MembersByList_grid1069 = new Lino.lists.MembersByList.GridPanel({ "flex": 41, "listeners": { "render": Lino.quicktip_renderer("List memberships","(lists.lists.MembersByList) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.lists.MembersByList.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1070 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ main_1_panel1051, main_2_panel1059, { "items": remarks1064, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 41 }, MembersByList_grid1069 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1070;
    this.before_row_edit = function(record) {
      MembersByList_grid1069.on_master_changed();
    }
    Lino.lists.Lists.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.blogs.Entries.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 51,
  initComponent : function() {
    var title1408 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Heading", "name": "title", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Heading","(blogs.Entries.title) ") }, "anchor": "-20" });
    var type1409 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Blog Entry Type", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.blogs.EntryTypes.detail,Lino.blogs.EntryTypes.insert)}, "emptyText": "Select a Blog Entry Type...", "listeners": { "render": Lino.quicktip_renderer("Blog Entry Type","(blogs.Entries.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/Entries/type", "method": "GET" }) }) });
    var user1410 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(blogs.Entries.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/Entries/user", "method": "GET" }) }) });
    var id1411 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(blogs.Entries.id) ") }, "anchor": "-20" });
    var main_1_panel1412 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title1408, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1409, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1410, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1411, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var language1417 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Language", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(blogs.Entries.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ] ], "name": "language" });
    var created1418 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "listeners": { "render": Lino.quicktip_renderer("Created","(blogs.Entries.created) ") }, "value": "<br>", "anchor": "-20" });
    var modified1419 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "listeners": { "render": Lino.quicktip_renderer("Modified","(blogs.Entries.modified) ") }, "value": "<br>", "anchor": "-20" });
    var owner_disp1420 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Controlled by", "anchor": "-20", "name": "owner" });
    var build_time1421 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "build time", "name": "build_time", "listeners": { "render": Lino.quicktip_renderer("build time","(blogs.Entries.build_time) ") }, "value": "<br>", "anchor": "-20" });
    var main_2_panel1422 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language1417, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1418, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1419, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp1420, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_time1421, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var body1428 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 71, "containing_panel": this, "name": "body", "title": "Body" });
    var main_panel1429 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel1412, main_2_panel1422, body1428 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1429;
    this.before_row_edit = function(record) {
      body1428.refresh();
    }
    Lino.blogs.Entries.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 63,
  initComponent : function() {
    var start_date1891 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Start date", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start date","(cal.Tasks.start_date) ") }, "anchor": "-20" });
    var due_date1892 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Due date", "name": "due_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Due date","(cal.Tasks.due_date) ") }, "anchor": "-20" });
    var id1893 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.Tasks.id) ") }, "anchor": "-20" });
    var workflow_buttons_disp1894 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Workflow", "name": "workflow_buttons", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Workflow","(cal.Tasks.workflow_buttons) ") }, "anchor": "-20" });
    var main_1_panel1895 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1891, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": due_date1892, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1893, "labelAlign": "top" }, { "flex": 49, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp1894, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var summary1900 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Summary", "name": "summary", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Summary","(cal.Tasks.summary) ") }, "anchor": "-20" });
    var user1901 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(cal.Tasks.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var project1902 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail,Lino.tickets.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(cal.Tasks.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_3_panel1903 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1901, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1902, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var owner_disp1906 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Controlled by", "anchor": "-20", "name": "owner" });
    var created1907 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "listeners": { "render": Lino.quicktip_renderer("Created","(cal.Tasks.created) ") }, "value": "<br>", "anchor": "-20" });
    var modified1908 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "listeners": { "render": Lino.quicktip_renderer("Modified","(cal.Tasks.modified) ") }, "value": "<br>", "anchor": "-20" });
    var main_4_panel1909 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp1906, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1907, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1908, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description1913 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(cal.Tasks.description) ") }, "fieldLabel": "Description", "name": "description", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var main_panel1914 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ main_1_panel1895, { "items": summary1900, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, main_3_panel1903, main_4_panel1909, { "items": description1913, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 45 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1914;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Tasks.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.Tickets.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 60,
  initComponent : function() {
    var summary1564 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Summary</span>", "name": "summary", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Summary","(tickets.Tickets.summary) Short summary of the problem.") }, "anchor": "-20" });
    var project1565 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail,Lino.tickets.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(tickets.Tickets.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/project", "method": "GET" }) }) });
    var main_panel1566 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary1564, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1565, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1566;
    this.before_row_edit = function(record) {
    }
    Lino.tickets.Tickets.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Households.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 21,
  initComponent : function() {
    var type993 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Household Type", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.households.Types.detail,Lino.households.Types.insert)}, "emptyText": "Select a Household Type...", "listeners": { "render": Lino.quicktip_renderer("Household Type","(households.Households.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/type", "method": "GET" }) }) });
    var name994 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Name","(households.Households.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language995 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(households.Households.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ] ], "name": "language" });
    var id996 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(households.Households.id) ") }, "anchor": "-20" });
    var main_1_panel997 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type993, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name994, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language995, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id996, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var country1002 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Country","(households.Households.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/country", "method": "GET" }) }) });
    var region1003 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "County", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("County","(households.Households.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/region", "method": "GET" }) }) });
    var box3_1_panel1004 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country1002, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region1003, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city1007 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "City", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("City","(households.Households.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/city", "method": "GET" }) }) });
    var zip_code1008 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Zip code", "name": "zip_code", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Zip code","(households.Households.zip_code) ") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var box3_2_panel1009 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city1007, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code1008, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix1012 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street prefix</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Street prefix","(households.Households.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "anchor": "-20" });
    var street1013 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Street","(households.Households.street) Name of street, without house number.") }, "anchor": "-20" });
    var street_no1014 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("No.","(households.Households.street_no) House number.") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var street_box1015 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Box","(households.Households.street_box) Text to print after street nuber on the same line.") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var box3_3_panel1016 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix1012, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street1013, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no1014, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box1015, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr21021 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line after street</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Address line after street","(households.Households.addr2) Address line to print below street line.") }, "anchor": "-20" });
    var box3_panel1022 = new Ext.Panel({ "flex": 62, "autoHeight": true, "layout": "form", "items": [ box3_1_panel1004, box3_2_panel1009, box3_3_panel1016, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr21021, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 234, "border": false, "labelAlign": "top" });
    var phone1024 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Phone", "name": "phone", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Phone","(households.Households.phone) ") }, "anchor": "-20" });
    var gsm1025 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("GSM","(households.Households.gsm) ") }, "anchor": "-20" });
    var email1026 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail","(households.Households.email) ") }, "anchor": "-20" });
    var url1027 = new Lino.URLField({ "autoHeight": true, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("URL","(households.Households.url) ") }, "anchor": "-20" });
    var box4_panel1028 = new Ext.Panel({ "flex": 37, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone1024, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm1025, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email1026, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url1027, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var address_box_panel1033 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box3_panel1022, box4_panel1028 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks1034 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remarks","(households.Households.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var households_MembersByHousehold_grid1042 = new Lino.households.MembersByHousehold.GridPanel({ "flex": 57, "listeners": { "render": Lino.quicktip_renderer("Household Members","(households.households.MembersByHousehold) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByHousehold.grid) ], "preview_limit": 15, "master_panel": this });
    var bottom_box_panel1043 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": remarks1034, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 42 }, households_MembersByHousehold_grid1042 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel1045 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel997, address_box_panel1033, bottom_box_panel1043 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1045;
    this.before_row_edit = function(record) {
      region1003.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city1007.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city1007.setContextValue('region', record ? record.data['regionHidden'] : undefined);
      households_MembersByHousehold_grid1042.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country1002.on('change',Lino.chooser_handler(region1003,'country'));
      country1002.on('change',Lino.chooser_handler(city1007,'country'));
      region1003.on('change',Lino.chooser_handler(city1007,'region'));
      Lino.households.Households.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.households.Households.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    city1007.on("change", function(){ this.save() }, this);
    zip_code1008.on("change", function(){ this.save() }, this);
  }
});


Lino.accounts.Groups.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 31,
  initComponent : function() {
    var name1199 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(accounts.Groups.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1200 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(accounts.Groups.name_de) ") }, "anchor": "-20" });
    var name_fr1201 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(accounts.Groups.name_fr) ") }, "anchor": "-20" });
    var name_et1202 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(accounts.Groups.name_et) ") }, "anchor": "-20" });
    var main_1_panel1203 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1199, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1200, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1201, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1202, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var account_type1208 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Account Type", "name": "account_type", "hiddenName": "account_typeHidden", "listeners": { "render": Lino.quicktip_renderer("Account Type","(accounts.Groups.account_type) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.accounts.AccountTypes) });
    var ref1209 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "ref", "name": "ref", "maxLength": 20, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ref","(accounts.Groups.ref) ") }, "anchor": "-20" });
    var main_2_panel1210 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": account_type1208, "labelAlign": "top" }, { "flex": 56, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1209, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1213 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1203, main_2_panel1210 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1213;
    this.before_row_edit = function(record) {
    }
    Lino.accounts.Groups.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.Users.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 6,
  initComponent : function() {
    var username33 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Username</span>", "name": "username", "listeners": { "render": Lino.quicktip_renderer("Username","(users.Users.username) Required. Must be unique.") }, "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var profile34 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">User Profile</span>", "name": "profile", "hiddenName": "profileHidden", "listeners": { "render": Lino.quicktip_renderer("User Profile","(users.Users.profile) Users with an empty `profile` field are considered inactive and cannot log in.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.users.UserProfiles) });
    var partner35 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "hiddenName": "partnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(users.Users.partner) ") }, "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var box1_1_panel36 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username33, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile34, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner35, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name40 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "First name", "name": "first_name", "maxLength": 30, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("First name","(users.Users.first_name) ") }, "anchor": "-20" });
    var last_name41 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Last name", "name": "last_name", "maxLength": 30, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Last name","(users.Users.last_name) ") }, "anchor": "-20" });
    var initials42 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Initials", "name": "initials", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Initials","(users.Users.initials) ") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var box1_2_panel43 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name40, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name41, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": initials42, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email47 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "e-mail address", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("e-mail address","(users.Users.email) ") }, "anchor": "-20" });
    var language48 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Language", "name": "language", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(users.Users.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ] ] });
    var box1_3_panel49 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email47, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language48, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var id52 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(users.Users.id) ") }, "anchor": "-20" });
    var created53 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "listeners": { "render": Lino.quicktip_renderer("Created","(users.Users.created) ") }, "value": "<br>", "anchor": "-20" });
    var modified54 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "listeners": { "render": Lino.quicktip_renderer("Modified","(users.Users.modified) ") }, "value": "<br>", "anchor": "-20" });
    var box1_4_panel55 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id52, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created53, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified54, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box1_panel59 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ box1_1_panel36, box1_2_panel43, box1_3_panel49, box1_4_panel55 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var remarks60 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remarks","(users.Users.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var AuthoritiesGiven_grid63 = new Lino.users.AuthoritiesGiven.GridPanel({ "flex": 33, "hide_top_toolbar": true, "containing_panel": this, "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Authorities given","(users.users.AuthoritiesGiven) ") }, "tools": [ Lino.show_in_own_window_button(Lino.users.AuthoritiesGiven.grid) ], "hideHeaders": true });
    var main_2_panel64 = new Ext.Panel({ "flex": 55, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": remarks60, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 66 }, AuthoritiesGiven_grid63 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel66 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ box1_panel59, main_2_panel64 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel66;
    this.before_row_edit = function(record) {
      AuthoritiesGiven_grid63.on_master_changed();
    }
    Lino.users.Users.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    partner35.on("change", function(){ this.save() }, this);
  }
});


Lino.contacts.Persons.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 16,
  initComponent : function() {
    var overview_disp815 = new Ext.form.DisplayField({ "disabled": true, "flex": 20, "listeners": { "render": Lino.quicktip_renderer(null,"(contacts.Persons.overview) ") }, "name": "overview", "value": "<br/>", "always_enabled": true });
    var title816 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Title</span>", "name": "title", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Title","(contacts.Persons.title) Text to print before allocation and name as part of the first address line.") }, "anchor": "-20" });
    var first_name817 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">First name</span>", "name": "first_name", "listeners": { "render": Lino.quicktip_renderer("First name","(contacts.Persons.first_name) First or given name.") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var middle_name818 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Middle name</span>", "name": "middle_name", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Middle name","(contacts.Persons.middle_name) Space-separated list of all middle names.") }, "anchor": "-20" });
    var general2_1_panel819 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title816, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name817, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": middle_name818, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var last_name823 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Last name</span>", "name": "last_name", "listeners": { "render": Lino.quicktip_renderer("Last name","(contacts.Persons.last_name) Last name (family name).") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var gender824 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Gender", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Gender","(contacts.Persons.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.system.Genders) });
    var birth_date825 = new Lino.IncompleteDateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Birth date</span>", "name": "birth_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Birth date","(contacts.Persons.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".") }, "anchor": "-20" });
    var age_disp826 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Age", "name": "age", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Age","(contacts.Persons.age) ") }, "anchor": "-20" });
    var general2_3_panel827 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender824, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date825, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": age_disp826, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var id831 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Persons.id) ") }, "anchor": "-20" });
    var language832 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(contacts.Persons.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ] ], "name": "language" });
    var general2_4_panel833 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id831, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language832, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var general2_panel836 = new Ext.Panel({ "flex": 40, "autoHeight": true, "layout": "form", "items": [ general2_1_panel819, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name823, "anchor": "-20", "labelAlign": "top" }, general2_3_panel827, general2_4_panel833 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var email838 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Persons.email) ") }, "anchor": "-20" });
    var phone839 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Phone", "name": "phone", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Phone","(contacts.Persons.phone) ") }, "anchor": "-20" });
    var gsm840 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("GSM","(contacts.Persons.gsm) ") }, "anchor": "-20" });
    var fax841 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Fax","(contacts.Persons.fax) ") }, "anchor": "-20" });
    var general3_panel842 = new Ext.Panel({ "flex": 40, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email838, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone839, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm840, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax841, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var general_1_panel847 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ overview_disp815, general2_panel836, general3_panel842 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var contacts_RolesByPerson_grid852 = new Lino.contacts.RolesByPerson.GridPanel({ "flex": 22, "listeners": { "render": Lino.quicktip_renderer("Contact for","(contacts.contacts.RolesByPerson) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByPerson.grid) ], "preview_limit": 15, "master_panel": this });
    var MembersByPerson_htmlbox853 = new Lino.HtmlBoxPanel({ "flex": 44, "layout": "fit", "name": "MembersByPerson", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Household memberships", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Household memberships","(contacts.Persons.MembersByPerson) ") }, "bodyStyle": "overflow-x:hidden;", "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByPerson.grid) ] });
    var LinksByHuman_htmlbox854 = new Lino.HtmlBoxPanel({ "flex": 33, "layout": "fit", "name": "LinksByHuman", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Human Links", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Human Links","(contacts.Persons.LinksByHuman) ") }, "bodyStyle": "overflow-x:hidden;", "tools": [ Lino.show_in_own_window_button(Lino.humanlinks.LinksByHuman.grid) ] });
    var general_2_panel855 = new Ext.Panel({ "flex": 45, "border": false, "layout": "hbox", "labelWidth": 198, "hideCheckBoxLabels": true, "items": [ contacts_RolesByPerson_grid852, MembersByPerson_htmlbox853, LinksByHuman_htmlbox854 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel856 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel847, general_2_panel855 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var lists_MembersByPartner_grid860 = new Lino.lists.MembersByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("List memberships","(lists.lists.MembersByPartner) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.lists.MembersByPartner.grid) ] });
    var remarks861 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remarks","(contacts.Persons.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var sepa_AccountsByPartner_grid862 = new Lino.sepa.AccountsByPartner.GridPanel({ "flex": 64, "listeners": { "render": Lino.quicktip_renderer("Accounts","(sepa.sepa.AccountsByPartner) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.sepa.AccountsByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var contact_2_panel863 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ { "items": remarks861, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 35 }, sepa_AccountsByPartner_grid862 ], "region": "center", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 72, "border": false, "frame": false, "labelAlign": "top" });
    var contact_panel865 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Contact", "hideCheckBoxLabels": true, "items": [ lists_MembersByPartner_grid860, contact_2_panel863 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var tickets_VotesByPartner_grid866 = new Lino.tickets.VotesByPartner.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Votes", "tools": [ Lino.show_in_own_window_button(Lino.tickets.VotesByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var url867 = new Lino.URLField({ "autoHeight": true, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("URL","(contacts.Persons.url) ") }, "anchor": "-20" });
    var created868 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "listeners": { "render": Lino.quicktip_renderer("Created","(contacts.Persons.created) ") }, "value": "<br>", "anchor": "-20" });
    var modified869 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "listeners": { "render": Lino.quicktip_renderer("Modified","(contacts.Persons.modified) ") }, "value": "<br>", "anchor": "-20" });
    var misc_2_panel870 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created868, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified869, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var misc_panel873 = new Ext.Panel({ "autoHeight": true, "layout": "form", "title": "Miscellaneous", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url867, "anchor": "-20", "labelAlign": "top" }, misc_2_panel870 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "labelWidth": 36, "border": false, "labelAlign": "top" });
    var VouchersByPartner_htmlbox875 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "VouchersByPartner", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "north", "title": "VAT vouchers", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("VAT vouchers","(contacts.Persons.VouchersByPartner) ") }, "bodyStyle": "overflow-x:hidden;", "split": true, "tools": [ Lino.show_in_own_window_button(Lino.ledger.VouchersByPartner.grid) ] });
    var ledger_MovementsByPartner_grid876 = new Lino.ledger.MovementsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Movements","(ledger.ledger.MovementsByPartner) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.ledger.MovementsByPartner.grid) ] });
    var ledger_panel877 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 117, "title": "Accounting", "hideCheckBoxLabels": true, "items": [ VouchersByPartner_htmlbox875, ledger_MovementsByPartner_grid876 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel878 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel856, contact_panel865, tickets_VotesByPartner_grid866, misc_panel873, ledger_panel877 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel878;
    this.before_row_edit = function(record) {
      contacts_RolesByPerson_grid852.on_master_changed();
      MembersByPerson_htmlbox853.refresh();
      LinksByHuman_htmlbox854.refresh();
      lists_MembersByPartner_grid860.on_master_changed();
      sepa_AccountsByPartner_grid862.on_master_changed();
      tickets_VotesByPartner_grid866.on_master_changed();
      VouchersByPartner_htmlbox875.refresh();
      ledger_MovementsByPartner_grid876.on_master_changed();
    }
    Lino.contacts.Persons.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
  }
});


Lino.addresses.Addresses.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 26,
  initComponent : function() {
    var country768 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Country","(addresses.Addresses.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/addresses/Addresses/country", "method": "GET" }) }) });
    var city769 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "City", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("City","(addresses.Addresses.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/addresses/Addresses/city", "method": "GET" }) }) });
    var zip_code770 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Zip code", "name": "zip_code", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Zip code","(addresses.Addresses.zip_code) ") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel771 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country768, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city769, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code770, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr1775 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line before street</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Address line before street","(addresses.Addresses.addr1) Address line before street") }, "anchor": "-20" });
    var street776 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Street","(addresses.Addresses.street) Name of street, without house number.") }, "anchor": "-20" });
    var street_no777 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("No.","(addresses.Addresses.street_no) House number.") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var street_box778 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Box","(addresses.Addresses.street_box) Text to print after street nuber on the same line.") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel779 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street776, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no777, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box778, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2783 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line after street</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Address line after street","(addresses.Addresses.addr2) Address line to print below street line.") }, "anchor": "-20" });
    var address_type784 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Address type", "name": "address_type", "hiddenName": "address_typeHidden", "listeners": { "render": Lino.quicktip_renderer("Address type","(addresses.Addresses.address_type) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.addresses.AddressTypes) });
    var remark785 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Remark", "name": "remark", "maxLength": 50, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Remark","(addresses.Addresses.remark) ") }, "anchor": "-20" });
    var main_5_panel786 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": address_type784, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": remark785, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var data_source789 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Data source", "name": "data_source", "hiddenName": "data_sourceHidden", "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Data source","(addresses.Addresses.data_source) ") }, "anchor": "-20", "store": Lino.addresses.DataSources });
    var partner790 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "emptyText": "Select a Partner...", "listeners": { "render": Lino.quicktip_renderer("Partner","(addresses.Addresses.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/addresses/Addresses/partner", "method": "GET" }) }), "name": "partner" });
    var main_6_panel791 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": data_source789, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner790, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel794 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 243, "autoScroll": false, "items": [ main_1_panel771, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1775, "anchor": "-20", "labelAlign": "top" }, main_3_panel779, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2783, "anchor": "-20", "labelAlign": "top" }, main_5_panel786, main_6_panel791 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel794;
    this.before_row_edit = function(record) {
      city769.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city769.setContextValue('region', record ? record.data['regionHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      country768.on('change',Lino.chooser_handler(city769,'country'));
      Lino.addresses.Addresses.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.addresses.Addresses.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    city769.on("change", function(){ this.save() }, this);
    zip_code770.on("change", function(){ this.save() }, this);
  }
});


Lino.tickets.Projects.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 55,
  initComponent : function() {
    var ref1433 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Reference", "name": "ref", "maxLength": 40, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Reference","(tickets.Projects.ref) ") }, "anchor": "-20" });
    var name1434 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Name","(tickets.Projects.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var parent1435 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Parent", "name": "parent", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail,Lino.tickets.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Parent","(tickets.Projects.parent) ") }, "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Projects/parent", "method": "GET" }) }) });
    var general_1_panel1436 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1433, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1434, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent1435, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var type1440 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Project Type", "name": "type", "pageSize": 20, "emptyText": "Select a Project Type...", "listeners": { "render": Lino.quicktip_renderer("Project Type","(tickets.Projects.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Projects/type", "method": "GET" }) }) });
    var user1441 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(tickets.Projects.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Projects/user", "method": "GET" }) }) });
    var general_2_panel1442 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1440, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1441, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description1445 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(tickets.Projects.description) ") }, "fieldLabel": "Description", "name": "description", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var ProjectsByProject_grid1571 = new Lino.tickets.ProjectsByProject.GridPanel({ "flex": 66, "listeners": { "render": Lino.quicktip_renderer("Sub-projects","(tickets.tickets.ProjectsByProject) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.tickets.ProjectsByProject.grid) ], "preview_limit": 15, "master_panel": this });
    var general_3_panel1572 = new Ext.Panel({ "flex": 71, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": description1445, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 33 }, ProjectsByProject_grid1571 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel1574 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel1436, general_2_panel1442, general_3_panel1572 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var TicketsByProject_grid1575 = new Lino.tickets.TicketsByProject.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Tickets", "tools": [ Lino.show_in_own_window_button(Lino.tickets.TicketsByProject.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1576 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1574, TicketsByProject_grid1575 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1576;
    this.before_row_edit = function(record) {
      ProjectsByProject_grid1571.on_master_changed();
      TicketsByProject_grid1575.on_master_changed();
    }
    Lino.tickets.Projects.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Events.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 72,
  initComponent : function() {
    var event_type1830 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Event Type", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail,Lino.cal.EventTypes.insert)}, "emptyText": "Select a Event Type...", "listeners": { "render": Lino.quicktip_renderer("Event Type","(cal.Events.event_type) ") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/event_type", "method": "GET" }) }) });
    var summary1831 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Summary", "name": "summary", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Summary","(cal.Events.summary) ") }, "anchor": "-20" });
    var main_1_panel1832 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type1830, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary1831, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var start_date1835 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Start date", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start date","(cal.Events.start_date) ") }, "anchor": "-20" });
    var start_time1836 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "Start time", "name": "start_time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start time","(cal.Events.start_time) ") }, "anchor": "-20" });
    var start_panel1837 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 61, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1835, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time1836, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var end_date1840 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "End Date", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("End Date","(cal.Events.end_date) ") }, "anchor": "-20" });
    var end_time1841 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "End Time", "name": "end_time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("End Time","(cal.Events.end_time) ") }, "anchor": "-20" });
    var end_panel1842 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 61, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1840, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time1841, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var main_2_panel1845 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ start_panel1837, end_panel1842 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "anchor": "-20", "labelAlign": "top" });
    var room1846 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Room", "name": "room", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Rooms.detail,Lino.cal.Rooms.insert)}, "emptyText": "Select a Room...", "listeners": { "render": Lino.quicktip_renderer("Room","(cal.Events.room) ") }, "selectOnFocus": true, "hiddenName": "roomHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/room", "method": "GET" }) }) });
    var priority1847 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Priority", "name": "priority", "pageSize": 20, "emptyText": "Select a Priority...", "listeners": { "render": Lino.quicktip_renderer("Priority","(cal.Events.priority) ") }, "selectOnFocus": true, "hiddenName": "priorityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/priority", "method": "GET" }) }) });
    var access_class1848 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Access Class</span>", "name": "access_class", "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Access Class","(cal.Events.access_class) Whether this is private, public or between.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var transparent1849 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "transparent", "listeners": { "render": Lino.quicktip_renderer("Transparent","(cal.Events.transparent) Indicates that this Event shouldn't prevent other Events at the same time.") }, "boxLabel": "Transparent", "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel1850 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": room1846, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": priority1847, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class1848, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": transparent1849, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1855 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1832, main_2_panel1845, main_3_panel1850 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1855;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Events.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.Mails.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 74,
  initComponent : function() {
    var project1986 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail,Lino.tickets.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(outbox.Mails.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var subject1987 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Subject", "name": "subject", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Subject","(outbox.Mails.subject) ") }, "anchor": "-20" });
    var body1988 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 71, "containing_panel": this, "name": "body", "title": "Body" });
    var main_panel1989 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": project1986, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": subject1987, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, body1988 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1989;
    this.before_row_edit = function(record) {
      body1988.refresh();
    }
    Lino.outbox.Mails.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.EventTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 66,
  initComponent : function() {
    var name1992 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(cal.EventTypes.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1993 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(cal.EventTypes.name_de) ") }, "anchor": "-20" });
    var name_fr1994 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(cal.EventTypes.name_fr) ") }, "anchor": "-20" });
    var name_et1995 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(cal.EventTypes.name_et) ") }, "anchor": "-20" });
    var main_1_panel1996 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1992, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1993, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1994, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1995, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var event_label2001 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Event label", "name": "event_label", "value": "Appointment", "listeners": { "render": Lino.quicktip_renderer("Event label","(cal.EventTypes.event_label) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var event_label_de2002 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Event label (de)", "name": "event_label_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Event label (de)","(cal.EventTypes.event_label_de) ") }, "anchor": "-20" });
    var event_label_fr2003 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Event label (fr)", "name": "event_label_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Event label (fr)","(cal.EventTypes.event_label_fr) ") }, "anchor": "-20" });
    var event_label_et2004 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Event label (et)", "name": "event_label_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Event label (et)","(cal.EventTypes.event_label_et) ") }, "anchor": "-20" });
    var main_2_panel2005 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label2001, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label_de2002, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label_fr2003, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label_et2004, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var start_date2010 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Start date", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start date","(cal.EventTypes.start_date) ") }, "anchor": "-20" });
    var id2011 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.EventTypes.id) ") }, "anchor": "-20" });
    var main_3_panel2012 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 72, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2010, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2011, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var email_template2015 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Email template</span>", "name": "email_template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Email template","(cal.EventTypes.email_template) The name of the file to be used as template when creating an email from a mailable of this type.") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventTypes/email_template", "method": "GET" }) }), "anchor": "-20" });
    var attach_to_email2016 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "attach_to_email", "listeners": { "render": Lino.quicktip_renderer("Attach to email","(cal.EventTypes.attach_to_email) Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "boxLabel": "Attach to email", "selectOnFocus": true, "anchor": "-20" });
    var main_4_panel2017 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template2015, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email2016, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var is_appointment2020 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": true, "name": "is_appointment", "listeners": { "render": Lino.quicktip_renderer("Event is an appointment","(cal.EventTypes.is_appointment) ") }, "boxLabel": "Event is an appointment", "selectOnFocus": true, "anchor": "-20" });
    var all_rooms2021 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "all_rooms", "listeners": { "render": Lino.quicktip_renderer("Locks all rooms","(cal.EventTypes.all_rooms) ") }, "boxLabel": "Locks all rooms", "selectOnFocus": true, "anchor": "-20" });
    var locks_user2022 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "locks_user", "listeners": { "render": Lino.quicktip_renderer("Locks the user","(cal.EventTypes.locks_user) Whether events of this type make the user unavailable for other locking events at the same time.") }, "boxLabel": "Locks the user", "selectOnFocus": true, "anchor": "-20" });
    var max_conflicting2023 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Simultaneous events</span>", "name": "max_conflicting", "value": 1, "listeners": { "render": Lino.quicktip_renderer("Simultaneous events","(cal.EventTypes.max_conflicting) How many conflicting events should be tolerated.") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_5_panel2024 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_appointment2020, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": all_rooms2021, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": locks_user2022, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": max_conflicting2023, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var EventsByType_grid2055 = new Lino.cal.EventsByType.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Events","(cal.cal.EventsByType) ") }, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByType.grid) ] });
    var main_panel2056 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1996, main_2_panel2005, main_3_panel2012, main_4_panel2017, main_5_panel2024, EventsByType_grid2055 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2056;
    this.before_row_edit = function(record) {
      EventsByType_grid2055.on_master_changed();
    }
    Lino.cal.EventTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.Users.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 6,
  initComponent : function() {
    var username67 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Username</span>", "name": "username", "listeners": { "render": Lino.quicktip_renderer("Username","(users.Users.username) Required. Must be unique.") }, "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var email68 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "e-mail address", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("e-mail address","(users.Users.email) ") }, "anchor": "-20" });
    var main_1_panel69 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username67, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email68, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name72 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "First name", "name": "first_name", "maxLength": 30, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("First name","(users.Users.first_name) ") }, "anchor": "-20" });
    var last_name73 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Last name", "name": "last_name", "maxLength": 30, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Last name","(users.Users.last_name) ") }, "anchor": "-20" });
    var main_2_panel74 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name72, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name73, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var partner77 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "hiddenName": "partnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(users.Users.partner) ") }, "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var language78 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Language", "name": "language", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(users.Users.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ] ] });
    var profile79 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">User Profile</span>", "name": "profile", "hiddenName": "profileHidden", "listeners": { "render": Lino.quicktip_renderer("User Profile","(users.Users.profile) Users with an empty `profile` field are considered inactive and cannot log in.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.users.UserProfiles) });
    var main_4_panel80 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 47, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language78, "labelAlign": "top" }, { "flex": 52, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile79, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel83 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ main_1_panel69, main_2_panel74, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner77, "anchor": "-20", "labelAlign": "top" }, main_4_panel80 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel83;
    this.before_row_edit = function(record) {
    }
    Lino.users.Users.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.sales.Invoices.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 49,
  initComponent : function() {
    var partner204 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "emptyText": "Select a Partner...", "listeners": { "render": Lino.quicktip_renderer("Partner","(sales.Invoices.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/partner", "method": "GET" }) }), "name": "partner" });
    var date205 = new Lino.DateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date","(sales.Invoices.date) ") }, "anchor": "-20" });
    var main_1_panel206 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 60, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner204, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date205, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var subject209 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Subject line", "name": "subject", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Subject line","(sales.Invoices.subject) ") }, "anchor": "-20" });
    var main_panel210 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 117, "autoScroll": false, "items": [ main_1_panel206, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject209, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel210;
    this.before_row_edit = function(record) {
    }
    Lino.sales.Invoices.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.RecurrentEvents.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 65,
  initComponent : function() {
    var name2076 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(cal.RecurrentEvents.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de2077 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(cal.RecurrentEvents.name_de) ") }, "anchor": "-20" });
    var name_fr2078 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(cal.RecurrentEvents.name_fr) ") }, "anchor": "-20" });
    var name_et2079 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(cal.RecurrentEvents.name_et) ") }, "anchor": "-20" });
    var main_1_panel2080 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2076, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de2077, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2078, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et2079, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var id2085 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.RecurrentEvents.id) ") }, "anchor": "-20" });
    var user2086 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(cal.RecurrentEvents.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/RecurrentEvents/user", "method": "GET" }) }) });
    var event_type2087 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Event Type", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail,Lino.cal.EventTypes.insert)}, "emptyText": "Select a Event Type...", "listeners": { "render": Lino.quicktip_renderer("Event Type","(cal.RecurrentEvents.event_type) ") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/RecurrentEvents/event_type", "method": "GET" }) }) });
    var main_2_panel2088 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2085, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2086, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type2087, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var start_date2092 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Start date", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start date","(cal.RecurrentEvents.start_date) ") }, "anchor": "-20" });
    var start_time2093 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "Start time", "name": "start_time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start time","(cal.RecurrentEvents.start_time) ") }, "anchor": "-20" });
    var end_date2094 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "End Date", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("End Date","(cal.RecurrentEvents.end_date) ") }, "anchor": "-20" });
    var end_time2095 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "End Time", "name": "end_time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("End Time","(cal.RecurrentEvents.end_time) ") }, "anchor": "-20" });
    var main_3_panel2096 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date2092, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time2093, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date2094, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time2095, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var every_unit2101 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Recurrency", "allowBlank": false, "hiddenName": "every_unitHidden", "listeners": { "render": Lino.quicktip_renderer("Recurrency","(cal.RecurrentEvents.every_unit) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.Recurrencies, "name": "every_unit" });
    var every2102 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "Repeat every", "name": "every", "value": 0, "listeners": { "render": Lino.quicktip_renderer("Repeat every","(cal.RecurrentEvents.every) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var max_events2103 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "Number of events", "name": "max_events", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Number of events","(cal.RecurrentEvents.max_events) ") }, "anchor": "-20" });
    var main_4_panel2104 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": every_unit2101, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": every2102, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": max_events2103, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var monday2108 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "monday", "listeners": { "render": Lino.quicktip_renderer("Monday","(cal.RecurrentEvents.monday) ") }, "boxLabel": "Monday", "selectOnFocus": true, "anchor": "-20" });
    var tuesday2109 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "tuesday", "listeners": { "render": Lino.quicktip_renderer("Tuesday","(cal.RecurrentEvents.tuesday) ") }, "boxLabel": "Tuesday", "selectOnFocus": true, "anchor": "-20" });
    var wednesday2110 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "wednesday", "listeners": { "render": Lino.quicktip_renderer("Wednesday","(cal.RecurrentEvents.wednesday) ") }, "boxLabel": "Wednesday", "selectOnFocus": true, "anchor": "-20" });
    var thursday2111 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "thursday", "listeners": { "render": Lino.quicktip_renderer("Thursday","(cal.RecurrentEvents.thursday) ") }, "boxLabel": "Thursday", "selectOnFocus": true, "anchor": "-20" });
    var friday2112 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "friday", "listeners": { "render": Lino.quicktip_renderer("Friday","(cal.RecurrentEvents.friday) ") }, "boxLabel": "Friday", "selectOnFocus": true, "anchor": "-20" });
    var saturday2113 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "saturday", "listeners": { "render": Lino.quicktip_renderer("Saturday","(cal.RecurrentEvents.saturday) ") }, "boxLabel": "Saturday", "selectOnFocus": true, "anchor": "-20" });
    var sunday2114 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "sunday", "listeners": { "render": Lino.quicktip_renderer("Sunday","(cal.RecurrentEvents.sunday) ") }, "boxLabel": "Sunday", "selectOnFocus": true, "anchor": "-20" });
    var main_5_panel2115 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": monday2108, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": tuesday2109, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": wednesday2110, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": thursday2111, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": friday2112, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": saturday2113, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sunday2114, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description2123 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 33, "containing_panel": this, "name": "description", "title": "Description" });
    var cal_EventsByController_grid2150 = new Lino.cal.EventsByController.GridPanel({ "flex": 66, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Events","(cal.cal.EventsByController) ") }, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByController.grid) ] });
    var main_6_panel2151 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ description2123, cal_EventsByController_grid2150 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel2152 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel2080, main_2_panel2088, main_3_panel2096, main_4_panel2104, main_5_panel2115, main_6_panel2151 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2152;
    this.before_row_edit = function(record) {
      description2123.refresh();
      cal_EventsByController_grid2150.on_master_changed();
    }
    Lino.cal.RecurrentEvents.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.Mails.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 74,
  initComponent : function() {
    var subject1958 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Subject", "name": "subject", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Subject","(outbox.Mails.subject) ") }, "anchor": "-20" });
    var project1959 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail,Lino.tickets.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(outbox.Mails.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var date1960 = new Lino.DateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Date</span>", "name": "date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date","(outbox.Mails.date) \n        The official date to be printed on the document.\n        ") }, "anchor": "-20" });
    var main_1_panel1961 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject1958, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1959, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date1960, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user1965 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Sender", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Sender","(outbox.Mails.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/user", "method": "GET" }) }) });
    var sent1966 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "sent", "name": "sent", "listeners": { "render": Lino.quicktip_renderer("sent","(outbox.Mails.sent) ") }, "value": "<br>", "anchor": "-20" });
    var id1967 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(outbox.Mails.id) ") }, "anchor": "-20" });
    var owner_disp1968 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Controlled by", "anchor": "-20", "name": "owner" });
    var main_2_panel1969 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1965, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent1966, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1967, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp1968, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var RecipientsByMail_grid1980 = new Lino.outbox.RecipientsByMail.GridPanel({ "flex": 55, "listeners": { "render": Lino.quicktip_renderer("Recipients","(outbox.outbox.RecipientsByMail) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.RecipientsByMail.grid) ], "preview_limit": 15, "master_panel": this });
    var AttachmentsByMail_htmlbox1981 = new Lino.HtmlBoxPanel({ "flex": 22, "layout": "fit", "name": "AttachmentsByMail", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Attachments", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Attachments","(outbox.Mails.AttachmentsByMail) ") }, "bodyStyle": "overflow-x:hidden;", "tools": [ Lino.show_in_own_window_button(Lino.outbox.AttachmentsByMail.grid) ] });
    var UploadsByController_htmlbox1982 = new Lino.HtmlBoxPanel({ "flex": 22, "layout": "fit", "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Uploads","(outbox.Mails.UploadsByController) ") }, "bodyStyle": "overflow-x:hidden;", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var main_3_panel1983 = new Ext.Panel({ "flex": 29, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ RecipientsByMail_grid1980, AttachmentsByMail_htmlbox1981, UploadsByController_htmlbox1982 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var body1984 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 58, "containing_panel": this, "name": "body", "title": "Body" });
    var main_panel1985 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel1961, main_2_panel1969, main_3_panel1983, body1984 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1985;
    this.before_row_edit = function(record) {
      RecipientsByMail_grid1980.on_master_changed();
      AttachmentsByMail_htmlbox1981.refresh();
      UploadsByController_htmlbox1982.refresh();
      body1984.refresh();
    }
    Lino.outbox.Mails.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Charts.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 32,
  initComponent : function() {
    var id1096 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(accounts.Charts.id) ") }, "anchor": "-20" });
    var name1097 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(accounts.Charts.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1098 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(accounts.Charts.name_de) ") }, "anchor": "-20" });
    var name_fr1099 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(accounts.Charts.name_fr) ") }, "anchor": "-20" });
    var name_et1100 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(accounts.Charts.name_et) ") }, "anchor": "-20" });
    var main_1_panel1101 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1096, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1097, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1098, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1099, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1100, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var GroupsByChart_grid1214 = new Lino.accounts.GroupsByChart.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Account Groups","(accounts.accounts.GroupsByChart) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.accounts.GroupsByChart.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1215 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1101, GroupsByChart_grid1214 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1215;
    this.before_row_edit = function(record) {
      GroupsByChart_grid1214.on_master_changed();
    }
    Lino.accounts.Charts.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.Milestones.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 58,
  initComponent : function() {
    var project1577 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail,Lino.tickets.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(tickets.Milestones.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Milestones/project", "method": "GET" }) }) });
    var ref1578 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Reference", "name": "ref", "maxLength": 40, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Reference","(tickets.Milestones.ref) ") }, "anchor": "-20" });
    var expected1579 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Expected for", "name": "expected", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Expected for","(tickets.Milestones.expected) ") }, "anchor": "-20" });
    var reached1580 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Reached", "name": "reached", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Reached","(tickets.Milestones.reached) ") }, "anchor": "-20" });
    var id1581 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(tickets.Milestones.id) ") }, "anchor": "-20" });
    var main_1_panel1582 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1577, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1578, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": expected1579, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": reached1580, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1581, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var TicketsFixed_grid1599 = new Lino.tickets.TicketsFixed.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("Tickets Fixed","(tickets.tickets.TicketsFixed) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.tickets.TicketsFixed.grid) ], "preview_limit": 15, "master_panel": this });
    var TicketsReported_grid1611 = new Lino.tickets.TicketsReported.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("Tickets Reported","(tickets.tickets.TicketsReported) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.tickets.TicketsReported.grid) ], "preview_limit": 15, "master_panel": this });
    var main_2_panel1612 = new Ext.Panel({ "flex": 83, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ TicketsFixed_grid1599, TicketsReported_grid1611 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel1613 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1582, main_2_panel1612 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1613;
    this.before_row_edit = function(record) {
      TicketsFixed_grid1599.on_master_changed();
      TicketsReported_grid1611.on_master_changed();
    }
    Lino.tickets.Milestones.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.sales.Invoices.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 49,
  initComponent : function() {
    var date115 = new Lino.DateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date","(sales.Invoices.date) ") }, "anchor": "-20" });
    var partner116 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "emptyText": "Select a Partner...", "listeners": { "render": Lino.quicktip_renderer("Partner","(sales.Invoices.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/partner", "method": "GET" }) }), "name": "partner" });
    var vat_regime117 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "VAT Regime", "allowBlank": false, "hiddenName": "vat_regimeHidden", "listeners": { "render": Lino.quicktip_renderer("VAT Regime","(sales.Invoices.vat_regime) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.vat.VatRegimes, "name": "vat_regime" });
    var invoice_header_1_panel118 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date115, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner116, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_regime117, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var subject122 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Subject line", "name": "subject", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Subject line","(sales.Invoices.subject) ") }, "anchor": "-20" });
    var your_ref123 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Your reference", "name": "your_ref", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Your reference","(sales.Invoices.your_ref) ") }, "anchor": "-20" });
    var invoice_header_2_panel124 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject122, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": your_ref123, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var payment_term127 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Payment Term", "name": "payment_term", "pageSize": 20, "emptyText": "Select a Payment Term...", "listeners": { "render": Lino.quicktip_renderer("Payment Term","(sales.Invoices.payment_term) ") }, "selectOnFocus": true, "hiddenName": "payment_termHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/payment_term", "method": "GET" }) }) });
    var due_date128 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Date of payment", "name": "due_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date of payment","(sales.Invoices.due_date) ") }, "anchor": "-20" });
    var invoice_header_3_panel129 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": payment_term127, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": due_date128, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 144, "border": false, "anchor": "-20", "labelAlign": "top" });
    var shipping_mode132 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Shipping Mode", "name": "shipping_mode", "pageSize": 20, "emptyText": "Select a Shipping Mode...", "listeners": { "render": Lino.quicktip_renderer("Shipping Mode","(sales.Invoices.shipping_mode) ") }, "selectOnFocus": true, "hiddenName": "shipping_modeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/shipping_mode", "method": "GET" }) }) });
    var invoice_header_panel133 = new Ext.form.FieldSet({ "flex": 75, "autoHeight": true, "layout": "form", "title": "Header", "items": [ invoice_header_1_panel118, invoice_header_2_panel124, invoice_header_3_panel129, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": shipping_mode132, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "labelAlign": "top" });
    var total_base135 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "Total excl. VAT", "name": "total_base", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Total excl. VAT","(sales.Invoices.total_base) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var total_vat136 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "VAT", "name": "total_vat", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("VAT","(sales.Invoices.total_vat) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var total_incl137 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "Total incl. VAT", "name": "total_incl", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Total incl. VAT","(sales.Invoices.total_incl) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var workflow_buttons_disp138 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Workflow", "name": "workflow_buttons", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Workflow","(sales.Invoices.workflow_buttons) ") }, "anchor": "-20" });
    var totals_panel139 = new Ext.form.FieldSet({ "flex": 25, "autoHeight": true, "layout": "form", "title": "Totals", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_base135, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_vat136, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_incl137, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp138, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 144, "border": false, "labelAlign": "top" });
    var general_1_panel144 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ invoice_header_panel133, totals_panel139 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ItemsByInvoice_grid156 = new Lino.sales.ItemsByInvoice.GridPanel({ "flex": 45, "listeners": { "render": Lino.quicktip_renderer("Voucher items","(sales.sales.ItemsByInvoice) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.sales.ItemsByInvoice.grid) ], "preview_limit": 15, "master_panel": this });
    var general_panel157 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel144, ItemsByInvoice_grid156 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var id158 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(sales.Invoices.id) ") }, "anchor": "-20" });
    var user159 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(sales.Invoices.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/user", "method": "GET" }) }) });
    var language160 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Language", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(sales.Invoices.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ] ], "name": "language" });
    var more_1_panel161 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id158, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user159, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language160, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var intro165 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Introductive Text","(sales.Invoices.intro) ") }, "fieldLabel": "Introductive Text", "name": "intro", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var more_panel166 = new Ext.Panel({ "layout": "vbox", "title": "More", "items": [ more_1_panel161, { "items": intro165, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "labelWidth": 162, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var journal168 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Journal", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail,Lino.ledger.Journals.insert)}, "emptyText": "Select a Journal...", "listeners": { "render": Lino.quicktip_renderer("Journal","(sales.Invoices.journal) ") }, "selectOnFocus": true, "hiddenName": "journalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/journal", "method": "GET" }) }), "name": "journal" });
    var year169 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "year", "hiddenName": "yearHidden", "listeners": { "render": Lino.quicktip_renderer("Fiscal Year","(sales.Invoices.year) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var number170 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "number", "name": "number", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("number","(sales.Invoices.number) ") }, "anchor": "-20" });
    var narration171 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Narration", "name": "narration", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Narration","(sales.Invoices.narration) ") }, "anchor": "-20" });
    var ledger_1_panel172 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": journal168, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": year169, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": number170, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": narration171, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ledger_MovementsByVoucher_grid201 = new Lino.ledger.MovementsByVoucher.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Movements","(ledger.ledger.MovementsByVoucher) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.ledger.MovementsByVoucher.grid) ], "preview_limit": 15, "master_panel": this });
    var ledger_panel202 = new Ext.Panel({ "layout": "vbox", "title": "Ledger", "items": [ ledger_1_panel172, ledger_MovementsByVoucher_grid201 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel203 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel157, more_panel166, ledger_panel202 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel203;
    this.before_row_edit = function(record) {
      ItemsByInvoice_grid156.on_master_changed();
      ledger_MovementsByVoucher_grid201.on_master_changed();
    }
    Lino.sales.Invoices.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Charts.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 32,
  initComponent : function() {
    var name1216 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(accounts.Charts.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1217 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(accounts.Charts.name_de) ") }, "anchor": "-20" });
    var name_fr1218 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(accounts.Charts.name_fr) ") }, "anchor": "-20" });
    var name_et1219 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(accounts.Charts.name_et) ") }, "anchor": "-20" });
    var main_1_panel1220 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1216, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1217, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1218, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1219, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var main_panel1225 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "hideCheckBoxLabels": true, "items": [ main_1_panel1220 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1225;
    this.before_row_edit = function(record) {
    }
    Lino.accounts.Charts.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Groups.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 31,
  initComponent : function() {
    var ref1115 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "ref", "name": "ref", "maxLength": 20, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ref","(accounts.Groups.ref) ") }, "anchor": "-20" });
    var name1116 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(accounts.Groups.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1117 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(accounts.Groups.name_de) ") }, "anchor": "-20" });
    var name_fr1118 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(accounts.Groups.name_fr) ") }, "anchor": "-20" });
    var name_et1119 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(accounts.Groups.name_et) ") }, "anchor": "-20" });
    var main_1_panel1120 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1115, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1116, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1117, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1118, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1119, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var account_type1126 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Account Type", "name": "account_type", "hiddenName": "account_typeHidden", "listeners": { "render": Lino.quicktip_renderer("Account Type","(accounts.Groups.account_type) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.accounts.AccountTypes) });
    var id1127 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(accounts.Groups.id) ") }, "anchor": "-20" });
    var main_2_panel1128 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 76, "autoHeight": true, "layout": "form", "xtype": "panel", "items": account_type1126, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1127, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var AccountsByGroup_grid1197 = new Lino.accounts.AccountsByGroup.GridPanel({ "flex": 71, "listeners": { "render": Lino.quicktip_renderer("Accounts","(accounts.accounts.AccountsByGroup) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.accounts.AccountsByGroup.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1198 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1120, main_2_panel1128, AccountsByGroup_grid1197 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1198;
    this.before_row_edit = function(record) {
      AccountsByGroup_grid1197.on_master_changed();
    }
    Lino.accounts.Groups.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.SiteConfigs.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 4,
  initComponent : function() {
    var site_company473 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Site owner</span>", "name": "site_company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "site_companyHidden", "listeners": { "render": Lino.quicktip_renderer("Site owner","(system.SiteConfigs.site_company) The organisation who runs this site.\n        This is used e.g. as sender in documents.\n        Or, newly created partners inherit the country of the site owner.\n        ") }, "selectOnFocus": true, "emptyText": "Select a Organization...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/site_company", "method": "GET" }) }) });
    var next_partner_id474 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Next partner id</span>", "name": "next_partner_id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Next partner id","(system.SiteConfigs.next_partner_id) The next automatic id for any new partner.") }, "value": 100, "anchor": "-20" });
    var main_1_panel475 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": site_company473, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": next_partner_id474, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 144, "border": false, "anchor": "-20", "labelAlign": "top" });
    var default_build_method478 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Default build method", "name": "default_build_method", "hiddenName": "default_build_methodHidden", "listeners": { "render": Lino.quicktip_renderer("Default build method","(system.SiteConfigs.default_build_method) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.BuildMethods) });
    var clients_account479 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Clients account", "name": "clients_account", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.accounts.Accounts.detail,Lino.accounts.Accounts.insert)}, "emptyText": "Select a Account...", "listeners": { "render": Lino.quicktip_renderer("Clients account","(system.SiteConfigs.clients_account) ") }, "selectOnFocus": true, "hiddenName": "clients_accountHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/clients_account", "method": "GET" }) }) });
    var sales_account480 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Sales Base account", "name": "sales_account", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.accounts.Accounts.detail,Lino.accounts.Accounts.insert)}, "emptyText": "Select a Account...", "listeners": { "render": Lino.quicktip_renderer("Sales Base account","(system.SiteConfigs.sales_account) ") }, "selectOnFocus": true, "hiddenName": "sales_accountHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/sales_account", "method": "GET" }) }) });
    var sales_vat_account481 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Sales VAT account", "name": "sales_vat_account", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.accounts.Accounts.detail,Lino.accounts.Accounts.insert)}, "emptyText": "Select a Account...", "listeners": { "render": Lino.quicktip_renderer("Sales VAT account","(system.SiteConfigs.sales_vat_account) ") }, "selectOnFocus": true, "hiddenName": "sales_vat_accountHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/sales_vat_account", "method": "GET" }) }) });
    var main_3_panel482 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": clients_account479, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sales_account480, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sales_vat_account481, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 171, "border": false, "anchor": "-20", "labelAlign": "top" });
    var suppliers_account486 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Suppliers account", "name": "suppliers_account", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.accounts.Accounts.detail,Lino.accounts.Accounts.insert)}, "emptyText": "Select a Account...", "listeners": { "render": Lino.quicktip_renderer("Suppliers account","(system.SiteConfigs.suppliers_account) ") }, "selectOnFocus": true, "hiddenName": "suppliers_accountHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/suppliers_account", "method": "GET" }) }) });
    var purchases_account487 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Purchases Base account", "name": "purchases_account", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.accounts.Accounts.detail,Lino.accounts.Accounts.insert)}, "emptyText": "Select a Account...", "listeners": { "render": Lino.quicktip_renderer("Purchases Base account","(system.SiteConfigs.purchases_account) ") }, "selectOnFocus": true, "hiddenName": "purchases_accountHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/purchases_account", "method": "GET" }) }) });
    var purchases_vat_account488 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Purchases VAT account", "name": "purchases_vat_account", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.accounts.Accounts.detail,Lino.accounts.Accounts.insert)}, "emptyText": "Select a Account...", "listeners": { "render": Lino.quicktip_renderer("Purchases VAT account","(system.SiteConfigs.purchases_vat_account) ") }, "selectOnFocus": true, "hiddenName": "purchases_vat_accountHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/purchases_vat_account", "method": "GET" }) }) });
    var main_4_panel489 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": suppliers_account486, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": purchases_account487, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": purchases_vat_account488, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 207, "border": false, "anchor": "-20", "labelAlign": "top" });
    var wages_account493 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Wages account", "name": "wages_account", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.accounts.Accounts.detail,Lino.accounts.Accounts.insert)}, "emptyText": "Select a Account...", "listeners": { "render": Lino.quicktip_renderer("Wages account","(system.SiteConfigs.wages_account) ") }, "selectOnFocus": true, "hiddenName": "wages_accountHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/wages_account", "method": "GET" }) }) });
    var clearings_account494 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Clearings account", "name": "clearings_account", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.accounts.Accounts.detail,Lino.accounts.Accounts.insert)}, "emptyText": "Select a Account...", "listeners": { "render": Lino.quicktip_renderer("Clearings account","(system.SiteConfigs.clearings_account) ") }, "selectOnFocus": true, "hiddenName": "clearings_accountHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/clearings_account", "method": "GET" }) }) });
    var main_5_panel495 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": wages_account493, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": clearings_account494, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var max_auto_events498 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Max automatic events</span>", "name": "max_auto_events", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Max automatic events","(system.SiteConfigs.max_auto_events) Maximum number of automatic events to be generated.") }, "value": 72, "anchor": "-20" });
    var default_event_type499 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Default Event Type</span>", "name": "default_event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail,Lino.cal.EventTypes.insert)}, "emptyText": "Select a Event Type...", "listeners": { "render": Lino.quicktip_renderer("Default Event Type","(system.SiteConfigs.default_event_type) The default type of events on this site.") }, "selectOnFocus": true, "hiddenName": "default_event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/default_event_type", "method": "GET" }) }) });
    var site_calendar500 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Site Calendar</span>", "name": "site_calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Calendars.detail,Lino.cal.Calendars.insert)}, "emptyText": "Select a Calendar...", "listeners": { "render": Lino.quicktip_renderer("Site Calendar","(system.SiteConfigs.site_calendar) The default calendar of this site.") }, "selectOnFocus": true, "hiddenName": "site_calendarHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/site_calendar", "method": "GET" }) }) });
    var main_6_panel501 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": max_auto_events498, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": default_event_type499, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": site_calendar500, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 189, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel505 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 189, "autoScroll": false, "items": [ main_1_panel475, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": default_build_method478, "anchor": "-20", "labelAlign": "top" }, main_3_panel482, main_4_panel489, main_5_panel495, main_6_panel501 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel505;
    this.before_row_edit = function(record) {
    }
    Lino.system.SiteConfigs.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 15,
  initComponent : function() {
    var name942 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Companies.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language943 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(contacts.Companies.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ] ], "name": "language" });
    var email944 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Companies.email) ") }, "anchor": "-20" });
    var main_2_panel945 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language943, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email944, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type948 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Organization type", "name": "type", "pageSize": 20, "emptyText": "Select a Organization type...", "listeners": { "render": Lino.quicktip_renderer("Organization type","(contacts.Companies.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var id949 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Companies.id) ") }, "anchor": "-20" });
    var main_3_panel950 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type948, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id949, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel953 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name942, "anchor": "-20", "labelAlign": "top" }, main_2_panel945, main_3_panel950 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel953;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Companies.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Accounts.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 30,
  initComponent : function() {
    var ref1180 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "ref", "name": "ref", "maxLength": 20, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ref","(accounts.Accounts.ref) ") }, "anchor": "-20" });
    var group1181 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Account Group", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.accounts.Groups.detail,Lino.accounts.Groups.insert)}, "emptyText": "Select a Account Group...", "listeners": { "render": Lino.quicktip_renderer("Account Group","(accounts.Accounts.group) ") }, "selectOnFocus": true, "hiddenName": "groupHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Accounts/group", "method": "GET" }) }), "name": "group" });
    var type1182 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Account Type", "allowBlank": false, "hiddenName": "typeHidden", "listeners": { "render": Lino.quicktip_renderer("Account Type","(accounts.Accounts.type) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.accounts.AccountTypes, "name": "type" });
    var main_1_panel1183 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1180, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": group1181, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1182, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var name1187 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(accounts.Accounts.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1188 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(accounts.Accounts.name_de) ") }, "anchor": "-20" });
    var name_fr1189 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(accounts.Accounts.name_fr) ") }, "anchor": "-20" });
    var name_et1190 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(accounts.Accounts.name_et) ") }, "anchor": "-20" });
    var main_2_panel1191 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1187, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1188, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1189, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1190, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1196 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1183, main_2_panel1191 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1196;
    this.before_row_edit = function(record) {
    }
    Lino.accounts.Accounts.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.excerpts.Excerpts.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 78,
  initComponent : function() {
    var excerpt_type2272 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Excerpt Type", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.excerpts.ExcerptTypes.detail,Lino.excerpts.ExcerptTypes.insert)}, "emptyText": "Select a Excerpt Type...", "listeners": { "render": Lino.quicktip_renderer("Excerpt Type","(excerpts.Excerpts.excerpt_type) ") }, "selectOnFocus": true, "hiddenName": "excerpt_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/excerpt_type", "method": "GET" }) }), "name": "excerpt_type" });
    var project2273 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail,Lino.tickets.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(excerpts.Excerpts.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/project", "method": "GET" }) }) });
    var main_1_panel2274 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": excerpt_type2272, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project2273, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var company2277 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Recipient (Organization)", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "companyHidden", "listeners": { "render": Lino.quicktip_renderer("Recipient (Organization)","(excerpts.Excerpts.company) ") }, "selectOnFocus": true, "emptyText": "Select a Organization...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/company", "method": "GET" }) }) });
    var contact_person2278 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Recipient (Person)", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "contact_personHidden", "listeners": { "render": Lino.quicktip_renderer("Recipient (Person)","(excerpts.Excerpts.contact_person) ") }, "selectOnFocus": true, "emptyText": "Select a Person...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/contact_person", "method": "GET" }) }) });
    var main_2_panel2279 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company2277, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person2278, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 225, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel2282 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel2274, main_2_panel2279 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2282;
    this.before_row_edit = function(record) {
      excerpt_type2272.setContextValue('owner', record ? record.data['owner'] : undefined);
      contact_person2278.setContextValue('company', record ? record.data['companyHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      company2277.on('change',Lino.chooser_handler(contact_person2278,'company'));
      Lino.excerpts.Excerpts.InsertFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.excerpts.Excerpts.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Accounts.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 30,
  initComponent : function() {
    var ref1146 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "ref", "name": "ref", "maxLength": 20, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ref","(accounts.Accounts.ref) ") }, "anchor": "-20" });
    var name1147 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(accounts.Accounts.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1148 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(accounts.Accounts.name_de) ") }, "anchor": "-20" });
    var name_fr1149 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(accounts.Accounts.name_fr) ") }, "anchor": "-20" });
    var name_et1150 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(accounts.Accounts.name_et) ") }, "anchor": "-20" });
    var id1151 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(accounts.Accounts.id) ") }, "anchor": "-20" });
    var main_1_panel1152 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1146, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1147, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1148, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1149, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1150, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1151, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var seqno1159 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "Seq.No.", "name": "seqno", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Seq.No.","(accounts.Accounts.seqno) ") }, "anchor": "-20" });
    var chart1160 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Account Chart", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.accounts.Charts.detail,Lino.accounts.Charts.insert)}, "emptyText": "Select a Account Chart...", "listeners": { "render": Lino.quicktip_renderer("Account Chart","(accounts.Accounts.chart) ") }, "selectOnFocus": true, "hiddenName": "chartHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Accounts/chart", "method": "GET" }) }), "name": "chart" });
    var group1161 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Account Group", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.accounts.Groups.detail,Lino.accounts.Groups.insert)}, "emptyText": "Select a Account Group...", "listeners": { "render": Lino.quicktip_renderer("Account Group","(accounts.Accounts.group) ") }, "selectOnFocus": true, "hiddenName": "groupHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Accounts/group", "method": "GET" }) }), "name": "group" });
    var type1162 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Account Type", "allowBlank": false, "hiddenName": "typeHidden", "listeners": { "render": Lino.quicktip_renderer("Account Type","(accounts.Accounts.type) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.accounts.AccountTypes, "name": "type" });
    var clearable1163 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "clearable", "listeners": { "render": Lino.quicktip_renderer("Clearable","(accounts.Accounts.clearable) ") }, "boxLabel": "Clearable", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel1164 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": seqno1159, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": chart1160, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": group1161, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1162, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": clearable1163, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ledger_MovementsByAccount_grid1178 = new Lino.ledger.MovementsByAccount.GridPanel({ "flex": 71, "listeners": { "render": Lino.quicktip_renderer("Movements","(ledger.ledger.MovementsByAccount) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.ledger.MovementsByAccount.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1179 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1152, main_2_panel1164, ledger_MovementsByAccount_grid1178 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1179;
    this.before_row_edit = function(record) {
      ledger_MovementsByAccount_grid1178.on_master_changed();
    }
    Lino.accounts.Accounts.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.finan.PaymentOrders.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 46,
  initComponent : function() {
    var date307 = new Lino.DateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date","(finan.PaymentOrders.date) ") }, "anchor": "-20" });
    var user308 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(finan.PaymentOrders.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/PaymentOrders/user", "method": "GET" }) }) });
    var narration309 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Narration", "name": "narration", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Narration","(finan.PaymentOrders.narration) ") }, "anchor": "-20" });
    var total310 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "Total", "name": "total", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Total","(finan.PaymentOrders.total) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var execution_date311 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Execution date", "name": "execution_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Execution date","(finan.PaymentOrders.execution_date) ") }, "anchor": "-20" });
    var workflow_buttons_disp312 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Workflow", "name": "workflow_buttons", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Workflow","(finan.PaymentOrders.workflow_buttons) ") }, "anchor": "-20" });
    var general_1_panel313 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date307, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user308, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": narration309, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": total310, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": execution_date311, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp312, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var finan_ItemsByPaymentOrder_grid326 = new Lino.finan.ItemsByPaymentOrder.GridPanel({ "flex": 62, "listeners": { "render": Lino.quicktip_renderer("Items","(finan.finan.ItemsByPaymentOrder) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.finan.ItemsByPaymentOrder.grid) ], "preview_limit": 15, "master_panel": this });
    var general_panel327 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel313, finan_ItemsByPaymentOrder_grid326 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var id328 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(finan.PaymentOrders.id) ") }, "anchor": "-20" });
    var journal329 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Journal", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail,Lino.ledger.Journals.insert)}, "emptyText": "Select a Journal...", "listeners": { "render": Lino.quicktip_renderer("Journal","(finan.PaymentOrders.journal) ") }, "selectOnFocus": true, "hiddenName": "journalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/PaymentOrders/journal", "method": "GET" }) }), "name": "journal" });
    var year330 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "year", "hiddenName": "yearHidden", "listeners": { "render": Lino.quicktip_renderer("Fiscal Year","(finan.PaymentOrders.year) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var number331 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "number", "name": "number", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("number","(finan.PaymentOrders.number) ") }, "anchor": "-20" });
    var ledger_1_panel332 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id328, "labelAlign": "top" }, { "flex": 54, "autoHeight": true, "layout": "form", "xtype": "panel", "items": journal329, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": year330, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": number331, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ledger_MovementsByVoucher_grid337 = new Lino.ledger.MovementsByVoucher.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Movements","(ledger.ledger.MovementsByVoucher) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.ledger.MovementsByVoucher.grid) ], "preview_limit": 15, "master_panel": this });
    var ledger_panel338 = new Ext.Panel({ "layout": "vbox", "title": "Ledger", "items": [ ledger_1_panel332, ledger_MovementsByVoucher_grid337 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel339 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel327, ledger_panel338 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel339;
    this.before_row_edit = function(record) {
      finan_ItemsByPaymentOrder_grid326.on_master_changed();
      ledger_MovementsByVoucher_grid337.on_master_changed();
    }
    Lino.finan.PaymentOrders.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.finan.JournalEntries.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 45,
  initComponent : function() {
    var date414 = new Lino.DateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date","(finan.JournalEntries.date) ") }, "anchor": "-20" });
    var user415 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(finan.JournalEntries.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/JournalEntries/user", "method": "GET" }) }) });
    var narration416 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Narration", "name": "narration", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Narration","(finan.JournalEntries.narration) ") }, "anchor": "-20" });
    var workflow_buttons_disp417 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Workflow", "name": "workflow_buttons", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Workflow","(finan.JournalEntries.workflow_buttons) ") }, "anchor": "-20" });
    var general_1_panel418 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date414, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user415, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": narration416, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp417, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var finan_ItemsByJournalEntry_grid436 = new Lino.finan.ItemsByJournalEntry.GridPanel({ "flex": 62, "listeners": { "render": Lino.quicktip_renderer("Items","(finan.finan.ItemsByJournalEntry) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.finan.ItemsByJournalEntry.grid) ], "preview_limit": 15, "master_panel": this });
    var general_panel437 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel418, finan_ItemsByJournalEntry_grid436 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var id438 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(finan.JournalEntries.id) ") }, "anchor": "-20" });
    var journal439 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Journal", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail,Lino.ledger.Journals.insert)}, "emptyText": "Select a Journal...", "listeners": { "render": Lino.quicktip_renderer("Journal","(finan.JournalEntries.journal) ") }, "selectOnFocus": true, "hiddenName": "journalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/JournalEntries/journal", "method": "GET" }) }), "name": "journal" });
    var year440 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "year", "hiddenName": "yearHidden", "listeners": { "render": Lino.quicktip_renderer("Fiscal Year","(finan.JournalEntries.year) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var number441 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "number", "name": "number", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("number","(finan.JournalEntries.number) ") }, "anchor": "-20" });
    var ledger_1_panel442 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id438, "labelAlign": "top" }, { "flex": 54, "autoHeight": true, "layout": "form", "xtype": "panel", "items": journal439, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": year440, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": number441, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ledger_MovementsByVoucher_grid447 = new Lino.ledger.MovementsByVoucher.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Movements","(ledger.ledger.MovementsByVoucher) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.ledger.MovementsByVoucher.grid) ], "preview_limit": 15, "master_panel": this });
    var ledger_panel448 = new Ext.Panel({ "layout": "vbox", "title": "Ledger", "items": [ ledger_1_panel442, ledger_MovementsByVoucher_grid447 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel449 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel437, ledger_panel448 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel449;
    this.before_row_edit = function(record) {
      finan_ItemsByJournalEntry_grid436.on_master_changed();
      ledger_MovementsByVoucher_grid447.on_master_changed();
    }
    Lino.finan.JournalEntries.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.excerpts.ExcerptTypes.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 77,
  initComponent : function() {
    var name2285 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(excerpts.ExcerptTypes.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de2286 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(excerpts.ExcerptTypes.name_de) ") }, "anchor": "-20" });
    var name_fr2287 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(excerpts.ExcerptTypes.name_fr) ") }, "anchor": "-20" });
    var name_et2288 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(excerpts.ExcerptTypes.name_et) ") }, "anchor": "-20" });
    var main_1_panel2289 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2285, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de2286, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2287, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et2288, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var content_type2294 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Model</span>", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contenttypes.ContentTypes.detail,Lino.contenttypes.ContentTypes.insert)}, "emptyText": "Select a content type...", "listeners": { "render": Lino.quicktip_renderer("Model","(excerpts.ExcerptTypes.content_type) The model that can issue printouts of this type.") }, "selectOnFocus": true, "hiddenName": "content_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/ExcerptTypes/content_type", "method": "GET" }) }), "name": "content_type" });
    var primary2295 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "primary", "listeners": { "render": Lino.quicktip_renderer("Primary","(excerpts.ExcerptTypes.primary) There's at most one primary type per model.         Enabling this field will automatically make the other         types non-primary.") }, "boxLabel": "Primary", "selectOnFocus": true, "anchor": "-20" });
    var certifying2296 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "certifying", "listeners": { "render": Lino.quicktip_renderer("Certifying","(excerpts.ExcerptTypes.certifying) Whether an excerpt of this type is a unique printout.") }, "boxLabel": "Certifying", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel2297 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": content_type2294, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": primary2295, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": certifying2296, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var build_method2301 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Build method", "name": "build_method", "hiddenName": "build_methodHidden", "listeners": { "render": Lino.quicktip_renderer("Build method","(excerpts.ExcerptTypes.build_method) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.BuildMethods) });
    var template2302 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Template", "name": "template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Template","(excerpts.ExcerptTypes.template) ") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/ExcerptTypes/template", "method": "GET" }) }), "anchor": "-20" });
    var body_template2303 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Body template</span>", "name": "body_template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Body template","(excerpts.ExcerptTypes.body_template) The body template to be used when         rendering a printable of this type. This is a list of files         with extension `.body.html`.") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/ExcerptTypes/body_template", "method": "GET" }) }), "anchor": "-20" });
    var main_3_panel2304 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method2301, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template2302, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": body_template2303, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel2308 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel2289, main_2_panel2297, main_3_panel2304 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2308;
    this.before_row_edit = function(record) {
      template2302.setContextValue('build_method', record ? record.data['build_methodHidden'] : undefined);
      template2302.setContextValue('content_type', record ? record.data['content_typeHidden'] : undefined);
      body_template2303.setContextValue('content_type', record ? record.data['content_typeHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      build_method2301.on('change',Lino.chooser_handler(template2302,'build_method'));
      content_type2294.on('change',Lino.chooser_handler(template2302,'content_type'));
      content_type2294.on('change',Lino.chooser_handler(body_template2303,'content_type'));
      Lino.excerpts.ExcerptTypes.InsertFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.excerpts.ExcerptTypes.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.finan.JournalEntries.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 45,
  initComponent : function() {
    var date340 = new Lino.DateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date","(finan.JournalEntries.date) ") }, "anchor": "-20" });
    var user341 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(finan.JournalEntries.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/JournalEntries/user", "method": "GET" }) }) });
    var main_1_panel342 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date340, "labelAlign": "top" }, { "flex": 60, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user341, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var narration345 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Narration", "name": "narration", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Narration","(finan.JournalEntries.narration) ") }, "anchor": "-20" });
    var main_panel346 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 90, "autoScroll": false, "items": [ main_1_panel342, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": narration345, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel346;
    this.before_row_edit = function(record) {
    }
    Lino.finan.JournalEntries.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 63,
  initComponent : function() {
    var summary1917 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Summary", "name": "summary", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Summary","(cal.Tasks.summary) ") }, "anchor": "-20" });
    var user1918 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(cal.Tasks.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var project1919 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail,Lino.tickets.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(cal.Tasks.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_2_panel1920 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1918, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1919, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1923 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary1917, "anchor": "-20", "labelAlign": "top" }, main_2_panel1920 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1923;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Tasks.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.excerpts.ExcerptTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 77,
  initComponent : function() {
    var id2172 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(excerpts.ExcerptTypes.id) ") }, "anchor": "-20" });
    var name2173 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(excerpts.ExcerptTypes.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de2174 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(excerpts.ExcerptTypes.name_de) ") }, "anchor": "-20" });
    var name_fr2175 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(excerpts.ExcerptTypes.name_fr) ") }, "anchor": "-20" });
    var name_et2176 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(excerpts.ExcerptTypes.name_et) ") }, "anchor": "-20" });
    var main_1_panel2177 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2172, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2173, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de2174, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2175, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et2176, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var content_type2183 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Model</span>", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contenttypes.ContentTypes.detail,Lino.contenttypes.ContentTypes.insert)}, "emptyText": "Select a content type...", "listeners": { "render": Lino.quicktip_renderer("Model","(excerpts.ExcerptTypes.content_type) The model that can issue printouts of this type.") }, "selectOnFocus": true, "hiddenName": "content_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/ExcerptTypes/content_type", "method": "GET" }) }), "name": "content_type" });
    var build_method2184 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Build method", "name": "build_method", "hiddenName": "build_methodHidden", "listeners": { "render": Lino.quicktip_renderer("Build method","(excerpts.ExcerptTypes.build_method) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.BuildMethods) });
    var template2185 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Template", "name": "template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Template","(excerpts.ExcerptTypes.template) ") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/ExcerptTypes/template", "method": "GET" }) }), "anchor": "-20" });
    var body_template2186 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Body template</span>", "name": "body_template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Body template","(excerpts.ExcerptTypes.body_template) The body template to be used when         rendering a printable of this type. This is a list of files         with extension `.body.html`.") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/ExcerptTypes/body_template", "method": "GET" }) }), "anchor": "-20" });
    var email_template2187 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Email template</span>", "name": "email_template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Email template","(excerpts.ExcerptTypes.email_template) The name of the file to be used as template when creating an email from a mailable of this type.") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/ExcerptTypes/email_template", "method": "GET" }) }), "anchor": "-20" });
    var shortcut2188 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Excerpt shortcut", "name": "shortcut", "boxMinWidth": Lino.chars2width(1), "listeners": { "render": Lino.quicktip_renderer("Excerpt shortcut","(excerpts.ExcerptTypes.shortcut) ") }, "maxLength": 1, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel2189 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": content_type2183, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method2184, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template2185, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": body_template2186, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template2187, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": shortcut2188, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var primary2196 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "primary", "listeners": { "render": Lino.quicktip_renderer("Primary","(excerpts.ExcerptTypes.primary) There's at most one primary type per model.         Enabling this field will automatically make the other         types non-primary.") }, "boxLabel": "Primary", "selectOnFocus": true, "anchor": "-20" });
    var print_directly2197 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": true, "name": "print_directly", "listeners": { "render": Lino.quicktip_renderer("Print directly","(excerpts.ExcerptTypes.print_directly) ") }, "boxLabel": "Print directly", "selectOnFocus": true, "anchor": "-20" });
    var certifying2198 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "certifying", "listeners": { "render": Lino.quicktip_renderer("Certifying","(excerpts.ExcerptTypes.certifying) Whether an excerpt of this type is a unique printout.") }, "boxLabel": "Certifying", "selectOnFocus": true, "anchor": "-20" });
    var print_recipient2199 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": true, "name": "print_recipient", "listeners": { "render": Lino.quicktip_renderer("Print recipient","(excerpts.ExcerptTypes.print_recipient) Whether to print a recipient field in document.") }, "boxLabel": "Print recipient", "selectOnFocus": true, "anchor": "-20" });
    var backward_compat2200 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "backward_compat", "listeners": { "render": Lino.quicktip_renderer("Backward compatible","(excerpts.ExcerptTypes.backward_compat) Check this to have `this` in template context point to owner instead of excerpt.") }, "boxLabel": "Backward compatible", "selectOnFocus": true, "anchor": "-20" });
    var attach_to_email2201 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "attach_to_email", "listeners": { "render": Lino.quicktip_renderer("Attach to email","(excerpts.ExcerptTypes.attach_to_email) Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "boxLabel": "Attach to email", "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel2202 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 180, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": primary2196, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": print_directly2197, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": certifying2198, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": print_recipient2199, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": backward_compat2200, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email2201, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var excerpts_ExcerptsByType_grid2283 = new Lino.excerpts.ExcerptsByType.GridPanel({ "flex": 62, "listeners": { "render": Lino.quicktip_renderer("Excerpts","(excerpts.excerpts.ExcerptsByType) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.excerpts.ExcerptsByType.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel2284 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel2177, main_2_panel2189, main_3_panel2202, excerpts_ExcerptsByType_grid2283 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2284;
    this.before_row_edit = function(record) {
      template2185.setContextValue('build_method', record ? record.data['build_methodHidden'] : undefined);
      template2185.setContextValue('content_type', record ? record.data['content_typeHidden'] : undefined);
      body_template2186.setContextValue('content_type', record ? record.data['content_typeHidden'] : undefined);
      email_template2187.setContextValue('content_type', record ? record.data['content_typeHidden'] : undefined);
      excerpts_ExcerptsByType_grid2283.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method2184.on('change',Lino.chooser_handler(template2185,'build_method'));
      content_type2183.on('change',Lino.chooser_handler(template2185,'content_type'));
      content_type2183.on('change',Lino.chooser_handler(body_template2186,'content_type'));
      content_type2183.on('change',Lino.chooser_handler(email_template2187,'content_type'));
      Lino.excerpts.ExcerptTypes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.excerpts.ExcerptTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.products.ProductCats.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 28,
  initComponent : function() {
    var id1226 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(products.ProductCats.id) ") }, "anchor": "-20" });
    var name1227 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(products.ProductCats.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1228 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(products.ProductCats.name_de) ") }, "anchor": "-20" });
    var name_fr1229 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(products.ProductCats.name_fr) ") }, "anchor": "-20" });
    var name_et1230 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(products.ProductCats.name_et) ") }, "anchor": "-20" });
    var main_1_panel1231 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1226, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1227, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1228, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1229, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1230, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 153, "border": false, "frame": false, "labelAlign": "top" });
    var description1237 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("description","(products.ProductCats.description) ") }, "fieldLabel": "description", "name": "description", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var ProductsByCategory_grid1307 = new Lino.products.ProductsByCategory.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Products","(products.products.ProductsByCategory) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.products.ProductsByCategory.grid) ] });
    var main_panel1308 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ main_1_panel1231, { "flex": 5, "layout": "form", "xtype": "panel", "items": description1237, "region": "center", "labelAlign": "top", "split": true }, ProductsByCategory_grid1307 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1308;
    this.before_row_edit = function(record) {
      ProductsByCategory_grid1307.on_master_changed();
    }
    Lino.products.ProductCats.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.blogs.EntryTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 52,
  initComponent : function() {
    var id1378 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(blogs.EntryTypes.id) ") }, "anchor": "-20" });
    var name1379 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(blogs.EntryTypes.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1380 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(blogs.EntryTypes.name_de) ") }, "anchor": "-20" });
    var name_fr1381 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(blogs.EntryTypes.name_fr) ") }, "anchor": "-20" });
    var name_et1382 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(blogs.EntryTypes.name_et) ") }, "anchor": "-20" });
    var main_1_panel1383 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1378, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1379, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1380, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1381, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1382, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var build_method1389 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Build method", "name": "build_method", "hiddenName": "build_methodHidden", "listeners": { "render": Lino.quicktip_renderer("Build method","(blogs.EntryTypes.build_method) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.BuildMethods) });
    var template1390 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Template", "name": "template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Template","(blogs.EntryTypes.template) ") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/EntryTypes/template", "method": "GET" }) }), "anchor": "-20" });
    var main_2_panel1391 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 67, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method1389, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template1390, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark1394 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remark","(blogs.EntryTypes.remark) ") }, "fieldLabel": "Remark", "name": "remark", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var blogs_EntriesByType_grid1430 = new Lino.blogs.EntriesByType.GridPanel({ "flex": 41, "listeners": { "render": Lino.quicktip_renderer("Blog Entries","(blogs.blogs.EntriesByType) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.blogs.EntriesByType.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1431 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 63, "hideCheckBoxLabels": true, "items": [ main_1_panel1383, main_2_panel1391, { "items": remark1394, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 41 }, blogs_EntriesByType_grid1430 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1431;
    this.before_row_edit = function(record) {
      template1390.setContextValue('build_method', record ? record.data['build_methodHidden'] : undefined);
      blogs_EntriesByType_grid1430.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method1389.on('change',Lino.chooser_handler(template1390,'build_method'));
      Lino.blogs.EntryTypes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.blogs.EntryTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.products.Products.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 29,
  initComponent : function() {
    var id1249 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(products.Products.id) ") }, "anchor": "-20" });
    var cat1250 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Category", "name": "cat", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.products.ProductCats.detail,Lino.products.ProductCats.insert)}, "emptyText": "Select a Product Category...", "listeners": { "render": Lino.quicktip_renderer("Category","(products.Products.cat) ") }, "selectOnFocus": true, "hiddenName": "catHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/products/Products/cat", "method": "GET" }) }) });
    var sales_price1251 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "Sales price", "name": "sales_price", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Sales price","(products.Products.sales_price) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var vat_class1252 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "VAT Class", "name": "vat_class", "hiddenName": "vat_classHidden", "listeners": { "render": Lino.quicktip_renderer("VAT Class","(products.Products.vat_class) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.vat.VatClasses) });
    var general_1_panel1253 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1249, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cat1250, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sales_price1251, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_class1252, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var name1258 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(products.Products.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1259 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(products.Products.name_de) ") }, "anchor": "-20" });
    var name_fr1260 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(products.Products.name_fr) ") }, "anchor": "-20" });
    var name_et1261 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(products.Products.name_et) ") }, "anchor": "-20" });
    var general_2_panel1262 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1258, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1259, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1260, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1261, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description1267 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Long description","(products.Products.description) ") }, "fieldLabel": "Long description", "name": "description", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var description_de1268 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Long description (de)","(products.Products.description_de) ") }, "fieldLabel": "Long description (de)", "name": "description_de", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var description_fr1269 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Long description (fr)","(products.Products.description_fr) ") }, "fieldLabel": "Long description (fr)", "name": "description_fr", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var description_et1270 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Long description (et)","(products.Products.description_et) ") }, "fieldLabel": "Long description (et)", "name": "description_et", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var general_3_panel1271 = new Ext.Panel({ "flex": 71, "border": false, "layout": "hbox", "labelWidth": 198, "hideCheckBoxLabels": true, "items": [ { "items": description1267, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 25 }, { "items": description_de1268, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 25 }, { "items": description_fr1269, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 25 }, { "items": description_et1270, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 25 } ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel1276 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel1253, general_2_panel1262, general_3_panel1271 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var sales_InvoiceItemsByProduct_grid1288 = new Lino.sales.InvoiceItemsByProduct.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Sales", "tools": [ Lino.show_in_own_window_button(Lino.sales.InvoiceItemsByProduct.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1289 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1276, sales_InvoiceItemsByProduct_grid1288 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1289;
    this.before_row_edit = function(record) {
      sales_InvoiceItemsByProduct_grid1288.on_master_changed();
    }
    Lino.products.Products.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.Models.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var app_disp2319 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "app_label", "name": "app", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("app_label","(about.Models.app) ") }, "anchor": "-20" });
    var name_disp2320 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "name", "name": "name", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("name","(about.Models.name) ") }, "anchor": "-20" });
    var docstring_disp2321 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "docstring", "name": "docstring", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("docstring","(about.Models.docstring) ") }, "anchor": "-20" });
    var rows2322 = new Ext.form.NumberField({ "disabled": true, "autoHeight": true, "fieldLabel": "Rows", "name": "rows", "listeners": { "render": Lino.quicktip_renderer("Rows","(about.Models.rows) ") }, "anchor": "-20" });
    var main_1_panel2323 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_disp2319, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_disp2320, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": docstring_disp2321, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": rows2322, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var about_FieldsByModel_grid2332 = new Lino.about.FieldsByModel.GridPanel({ "flex": 62, "listeners": { "render": Lino.quicktip_renderer("Fields","(about.about.FieldsByModel) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.about.FieldsByModel.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel2333 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel2323, about_FieldsByModel_grid2332 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2333;
    this.before_row_edit = function(record) {
      about_FieldsByModel_grid2332.on_master_changed();
    }
    Lino.about.Models.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.products.Products.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 29,
  initComponent : function() {
    var cat1290 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Category", "name": "cat", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.products.ProductCats.detail,Lino.products.ProductCats.insert)}, "emptyText": "Select a Product Category...", "listeners": { "render": Lino.quicktip_renderer("Category","(products.Products.cat) ") }, "selectOnFocus": true, "hiddenName": "catHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/products/Products/cat", "method": "GET" }) }) });
    var sales_price1291 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "Sales price", "name": "sales_price", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Sales price","(products.Products.sales_price) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var vat_class1292 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "VAT Class", "name": "vat_class", "hiddenName": "vat_classHidden", "listeners": { "render": Lino.quicktip_renderer("VAT Class","(products.Products.vat_class) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.vat.VatClasses) });
    var main_1_panel1293 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 47, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cat1290, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sales_price1291, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_class1292, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var name1297 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(products.Products.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1298 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(products.Products.name_de) ") }, "anchor": "-20" });
    var name_fr1299 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(products.Products.name_fr) ") }, "anchor": "-20" });
    var name_et1300 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(products.Products.name_et) ") }, "anchor": "-20" });
    var main_2_panel1301 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1297, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1298, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1299, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1300, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1306 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1293, main_2_panel1301 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1306;
    this.before_row_edit = function(record) {
    }
    Lino.products.Products.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 16,
  initComponent : function() {
    var first_name879 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">First name</span>", "name": "first_name", "listeners": { "render": Lino.quicktip_renderer("First name","(contacts.Persons.first_name) First or given name.") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var last_name880 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Last name</span>", "name": "last_name", "listeners": { "render": Lino.quicktip_renderer("Last name","(contacts.Persons.last_name) Last name (family name).") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_1_panel881 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name879, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name880, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gender884 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Gender", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Gender","(contacts.Persons.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.system.Genders) });
    var language885 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(contacts.Persons.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ] ], "name": "language" });
    var main_2_panel886 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender884, "labelAlign": "top" }, { "flex": 68, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language885, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel889 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel881, main_2_panel886 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel889;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Persons.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.TextFieldTemplates.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 5,
  initComponent : function() {
    var id507 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(system.TextFieldTemplates.id) ") }, "anchor": "-20" });
    var name508 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(system.TextFieldTemplates.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user509 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(system.TextFieldTemplates.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/user", "method": "GET" }) }) });
    var main_1_panel510 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id507, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name508, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user509, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 108, "border": false, "frame": false, "labelAlign": "top" });
    var description514 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(system.TextFieldTemplates.description) ") }, "fieldLabel": "Description", "name": "description", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var text515 = new Lino.RichTextPanel({ "flex": 5, "split": true, "containing_panel": this, "selectOnFocus": true, "region": "south", "title": "Template Text", "name": "text" });
    var main_panel516 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ main_1_panel510, { "flex": 5, "layout": "form", "xtype": "panel", "items": description514, "region": "center", "labelAlign": "top", "split": true }, text515 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel516;
    this.before_row_edit = function(record) {
      text515.refresh();
    }
    Lino.system.TextFieldTemplates.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.humanlinks.Links.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 27,
  initComponent : function() {
    var parent1089 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Parent", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "emptyText": "Select a Person...", "listeners": { "render": Lino.quicktip_renderer("Parent","(humanlinks.Links.parent) ") }, "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/humanlinks/Links/parent", "method": "GET" }) }), "name": "parent" });
    var child1090 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Child", "name": "child", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "childHidden", "listeners": { "render": Lino.quicktip_renderer("Child","(humanlinks.Links.child) ") }, "selectOnFocus": true, "emptyText": "Select a Person...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/humanlinks/Links/child", "method": "GET" }) }) });
    var type1091 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Parency type", "allowBlank": false, "hiddenName": "typeHidden", "listeners": { "render": Lino.quicktip_renderer("Parency type","(humanlinks.Links.type) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.humanlinks.LinkTypes, "name": "type" });
    var main_panel1092 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 117, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent1089, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": child1090, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1091, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1092;
    this.before_row_edit = function(record) {
    }
    Lino.humanlinks.Links.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Invoices.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 35,
  initComponent : function() {
    var journal1367 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Journal", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail,Lino.ledger.Journals.insert)}, "emptyText": "Select a Journal...", "listeners": { "render": Lino.quicktip_renderer("Journal","(ledger.Invoices.journal) ") }, "selectOnFocus": true, "hiddenName": "journalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/journal", "method": "GET" }) }), "name": "journal" });
    var partner1368 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "emptyText": "Select a Partner...", "listeners": { "render": Lino.quicktip_renderer("Partner","(ledger.Invoices.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/partner", "method": "GET" }) }), "name": "partner" });
    var main_1_panel1369 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": journal1367, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1368, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var date1372 = new Lino.DateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date","(ledger.Invoices.date) ") }, "anchor": "-20" });
    var total_incl1373 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "Total incl. VAT", "name": "total_incl", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Total incl. VAT","(ledger.Invoices.total_incl) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var main_2_panel1374 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 52, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date1372, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_incl1373, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 144, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1377 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1369, main_2_panel1374 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1377;
    this.before_row_edit = function(record) {
    }
    Lino.ledger.Invoices.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.TextFieldTemplates.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 5,
  initComponent : function() {
    var name518 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(system.TextFieldTemplates.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user519 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(system.TextFieldTemplates.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/user", "method": "GET" }) }) });
    var main_panel520 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 108, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name518, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": user519, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel520;
    this.before_row_edit = function(record) {
    }
    Lino.system.TextFieldTemplates.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.InvoicesByJournal.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 35,
  initComponent : function() {
    var partner284 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "emptyText": "Select a Partner...", "listeners": { "render": Lino.quicktip_renderer("Partner","(ledger.InvoicesByJournal.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/InvoicesByJournal/partner", "method": "GET" }) }), "name": "partner" });
    var date285 = new Lino.DateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date","(ledger.InvoicesByJournal.date) ") }, "anchor": "-20" });
    var total_incl286 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "Total incl. VAT", "name": "total_incl", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Total incl. VAT","(ledger.InvoicesByJournal.total_incl) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var main_2_panel287 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 52, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date285, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_incl286, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 144, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel290 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner284, "anchor": "-20", "labelAlign": "top" }, main_2_panel287 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel290;
    this.before_row_edit = function(record) {
    }
    Lino.ledger.InvoicesByJournal.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Events.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 72,
  initComponent : function() {
    var event_type1745 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Event Type", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail,Lino.cal.EventTypes.insert)}, "emptyText": "Select a Event Type...", "listeners": { "render": Lino.quicktip_renderer("Event Type","(cal.Events.event_type) ") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/event_type", "method": "GET" }) }) });
    var summary1746 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Summary", "name": "summary", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Summary","(cal.Events.summary) ") }, "anchor": "-20" });
    var user1747 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Responsible user", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Responsible user","(cal.Events.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }) });
    var assigned_to1748 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Assigned to", "name": "assigned_to", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "assigned_toHidden", "listeners": { "render": Lino.quicktip_renderer("Assigned to","(cal.Events.assigned_to) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/assigned_to", "method": "GET" }) }) });
    var main_1_panel1749 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type1745, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary1746, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1747, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": assigned_to1748, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var start_date1754 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Start date", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start date","(cal.Events.start_date) ") }, "anchor": "-20" });
    var start_time1755 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "Start time", "name": "start_time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start time","(cal.Events.start_time) ") }, "anchor": "-20" });
    var start_panel1756 = new Ext.Panel({ "flex": 38, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 61, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1754, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time1755, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var end_date1759 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "End Date", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("End Date","(cal.Events.end_date) ") }, "anchor": "-20" });
    var end_time1760 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "End Time", "name": "end_time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("End Time","(cal.Events.end_time) ") }, "anchor": "-20" });
    var end_panel1761 = new Ext.Panel({ "flex": 38, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 61, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1759, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time1760, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var state1764 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "State", "allowBlank": false, "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("State","(cal.Events.state) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.EventStates, "name": "state" });
    var main_2_panel1765 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 54, "hideCheckBoxLabels": true, "items": [ start_panel1756, end_panel1761, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state1764, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var room1767 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Room", "name": "room", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Rooms.detail,Lino.cal.Rooms.insert)}, "emptyText": "Select a Room...", "listeners": { "render": Lino.quicktip_renderer("Room","(cal.Events.room) ") }, "selectOnFocus": true, "hiddenName": "roomHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/room", "method": "GET" }) }) });
    var priority1768 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Priority", "name": "priority", "pageSize": 20, "emptyText": "Select a Priority...", "listeners": { "render": Lino.quicktip_renderer("Priority","(cal.Events.priority) ") }, "selectOnFocus": true, "hiddenName": "priorityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/priority", "method": "GET" }) }) });
    var access_class1769 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Access Class</span>", "name": "access_class", "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Access Class","(cal.Events.access_class) Whether this is private, public or between.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var transparent1770 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "transparent", "listeners": { "render": Lino.quicktip_renderer("Transparent","(cal.Events.transparent) Indicates that this Event shouldn't prevent other Events at the same time.") }, "boxLabel": "Transparent", "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel1771 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": room1767, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": priority1768, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class1769, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": transparent1770, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var owner_disp1776 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Controlled by", "anchor": "-20", "name": "owner" });
    var created1777 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "listeners": { "render": Lino.quicktip_renderer("Created","(cal.Events.created) ") }, "value": "<br>", "anchor": "-20" });
    var modified1778 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "listeners": { "render": Lino.quicktip_renderer("Modified","(cal.Events.modified) ") }, "value": "<br>", "anchor": "-20" });
    var main_4_panel1779 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp1776, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1777, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1778, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description1783 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(cal.Events.description) ") }, "fieldLabel": "Description", "name": "description", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var GuestsByEvent_grid1827 = new Lino.cal.GuestsByEvent.GridPanel({ "flex": 35, "listeners": { "render": Lino.quicktip_renderer("Participants","(cal.cal.GuestsByEvent) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.GuestsByEvent.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1828 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ main_1_panel1749, main_2_panel1765, main_3_panel1771, main_4_panel1779, { "items": description1783, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 35 }, GuestsByEvent_grid1827 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1828;
    this.before_row_edit = function(record) {
      GuestsByEvent_grid1827.on_master_changed();
    }
    Lino.cal.Events.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.Tickets.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 60,
  initComponent : function() {
    var summary1496 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Summary</span>", "name": "summary", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Summary","(tickets.Tickets.summary) Short summary of the problem.") }, "anchor": "-20" });
    var assigned_to1497 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">User</span>", "name": "assigned_to", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "assigned_toHidden", "listeners": { "render": Lino.quicktip_renderer("User","(tickets.Tickets.assigned_to) The user who works on this ticket.") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/assigned_to", "method": "GET" }) }) });
    var project1498 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail,Lino.tickets.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(tickets.Tickets.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/project", "method": "GET" }) }) });
    var reported_for1499 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Reported for</span>", "name": "reported_for", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Milestones.detail,Lino.tickets.Milestones.insert)}, "emptyText": "Select a Milestone...", "listeners": { "render": Lino.quicktip_renderer("Reported for","(tickets.Tickets.reported_for) Milestone for which this ticket has been reported.") }, "selectOnFocus": true, "hiddenName": "reported_forHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/reported_for", "method": "GET" }) }) });
    var id1500 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(tickets.Tickets.id) ") }, "anchor": "-20" });
    var main_1_panel1501 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary1496, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": assigned_to1497, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1498, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": reported_for1499, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1500, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user1507 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(tickets.Tickets.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/user", "method": "GET" }) }) });
    var created1508 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "listeners": { "render": Lino.quicktip_renderer("Created","(tickets.Tickets.created) ") }, "value": "<br>", "anchor": "-20" });
    var modified1509 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "listeners": { "render": Lino.quicktip_renderer("Modified","(tickets.Tickets.modified) ") }, "value": "<br>", "anchor": "-20" });
    var state1510 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "State", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("State","(tickets.Tickets.state) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.tickets.TicketStates) });
    var workflow_buttons_disp1511 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Workflow", "name": "workflow_buttons", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Workflow","(tickets.Tickets.workflow_buttons) ") }, "anchor": "-20" });
    var fixed_for1512 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Fixed for</span>", "name": "fixed_for", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Milestones.detail,Lino.tickets.Milestones.insert)}, "emptyText": "Select a Milestone...", "listeners": { "render": Lino.quicktip_renderer("Fixed for","(tickets.Tickets.fixed_for) The milestone for which this ticket has been fixed.") }, "selectOnFocus": true, "hiddenName": "fixed_forHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/fixed_for", "method": "GET" }) }) });
    var main_2_panel1513 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1507, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1508, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1509, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state1510, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp1511, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fixed_for1512, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description1520 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(tickets.Tickets.description) ") }, "fieldLabel": "Description", "name": "description", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var ParentsByTicket_grid1525 = new Lino.tickets.ParentsByTicket.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("Dependencies","(tickets.tickets.ParentsByTicket) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.tickets.ParentsByTicket.grid) ], "preview_limit": 15, "master_panel": this });
    var ChildrenByTicket_grid1530 = new Lino.tickets.ChildrenByTicket.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("Dependencies","(tickets.tickets.ChildrenByTicket) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.tickets.ChildrenByTicket.grid) ], "preview_limit": 15, "master_panel": this });
    var main_4_panel1531 = new Ext.Panel({ "flex": 26, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ ParentsByTicket_grid1525, ChildrenByTicket_grid1530 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var SessionsByTicket_grid1561 = new Lino.tickets.SessionsByTicket.GridPanel({ "flex": 26, "listeners": { "render": Lino.quicktip_renderer("Sessions","(tickets.tickets.SessionsByTicket) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.tickets.SessionsByTicket.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1562 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ main_1_panel1501, main_2_panel1513, { "items": description1520, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 26 }, main_4_panel1531, SessionsByTicket_grid1561 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1562;
    this.before_row_edit = function(record) {
      reported_for1499.setContextValue('project', record ? record.data['projectHidden'] : undefined);
      fixed_for1512.setContextValue('project', record ? record.data['projectHidden'] : undefined);
      ParentsByTicket_grid1525.on_master_changed();
      ChildrenByTicket_grid1530.on_master_changed();
      SessionsByTicket_grid1561.on_master_changed();
    }
    this.onRender = function(ct, position) {
      project1498.on('change',Lino.chooser_handler(reported_for1499,'project'));
      project1498.on('change',Lino.chooser_handler(fixed_for1512,'project'));
      Lino.tickets.Tickets.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.tickets.Tickets.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Journals.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 33,
  initComponent : function() {
    var ref1310 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "ref", "name": "ref", "maxLength": 20, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ref","(ledger.Journals.ref) ") }, "anchor": "-20" });
    var trade_type1311 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Trade Type", "name": "trade_type", "hiddenName": "trade_typeHidden", "listeners": { "render": Lino.quicktip_renderer("Trade Type","(ledger.Journals.trade_type) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.vat.TradeTypes) });
    var seqno1312 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "Seq.No.", "name": "seqno", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Seq.No.","(ledger.Journals.seqno) ") }, "anchor": "-20" });
    var id1313 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(ledger.Journals.id) ") }, "anchor": "-20" });
    var voucher_type1314 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "voucher type", "allowBlank": false, "hiddenName": "voucher_typeHidden", "listeners": { "render": Lino.quicktip_renderer("voucher type","(ledger.Journals.voucher_type) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.ledger.VoucherTypes, "name": "voucher_type" });
    var main_1_panel1315 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1310, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": trade_type1311, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": seqno1312, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1313, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": voucher_type1314, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var force_sequence1321 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "force_sequence", "listeners": { "render": Lino.quicktip_renderer("Force chronological sequence","(ledger.Journals.force_sequence) ") }, "boxLabel": "Force chronological sequence", "selectOnFocus": true, "anchor": "-20" });
    var account1322 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Account", "name": "account", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.accounts.Accounts.detail,Lino.accounts.Accounts.insert)}, "emptyText": "Select a Account...", "listeners": { "render": Lino.quicktip_renderer("Account","(ledger.Journals.account) ") }, "selectOnFocus": true, "hiddenName": "accountHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Journals/account", "method": "GET" }) }) });
    var dc1323 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": null, "name": "dc", "listeners": { "render": Lino.quicktip_renderer("dc","(ledger.Journals.dc) Debit (checked) or Credit (not checked)") }, "boxLabel": "dc", "selectOnFocus": true, "anchor": "-20" });
    var build_method1324 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Build method", "name": "build_method", "hiddenName": "build_methodHidden", "listeners": { "render": Lino.quicktip_renderer("Build method","(ledger.Journals.build_method) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.BuildMethods) });
    var template1325 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Template", "name": "template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Template","(ledger.Journals.template) ") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Journals/template", "method": "GET" }) }), "anchor": "-20" });
    var main_2_panel1326 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": force_sequence1321, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": account1322, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": dc1323, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method1324, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template1325, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 261, "border": false, "anchor": "-20", "labelAlign": "top" });
    var name1332 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(ledger.Journals.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1333 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(ledger.Journals.name_de) ") }, "anchor": "-20" });
    var name_fr1334 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(ledger.Journals.name_fr) ") }, "anchor": "-20" });
    var name_et1335 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(ledger.Journals.name_et) ") }, "anchor": "-20" });
    var main_3_panel1336 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1332, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1333, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1334, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1335, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var printed_name1341 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "printed name", "name": "printed_name", "maxLength": 100, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("printed name","(ledger.Journals.printed_name) ") }, "anchor": "-20" });
    var printed_name_de1342 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "printed name (de)", "name": "printed_name_de", "maxLength": 100, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("printed name (de)","(ledger.Journals.printed_name_de) ") }, "anchor": "-20" });
    var printed_name_fr1343 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "printed name (fr)", "name": "printed_name_fr", "maxLength": 100, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("printed name (fr)","(ledger.Journals.printed_name_fr) ") }, "anchor": "-20" });
    var printed_name_et1344 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "printed name (et)", "name": "printed_name_et", "maxLength": 100, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("printed name (et)","(ledger.Journals.printed_name_et) ") }, "anchor": "-20" });
    var main_4_panel1345 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": printed_name1341, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": printed_name_de1342, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": printed_name_fr1343, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": printed_name_et1344, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1350 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1315, main_2_panel1326, main_3_panel1336, main_4_panel1345 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1350;
    this.before_row_edit = function(record) {
      account1322.setContextValue('chart', record ? record.data['chartHidden'] : undefined);
      template1325.setContextValue('build_method', record ? record.data['build_methodHidden'] : undefined);
      template1325.setContextValue('voucher_type', record ? record.data['voucher_typeHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      build_method1324.on('change',Lino.chooser_handler(template1325,'build_method'));
      voucher_type1314.on('change',Lino.chooser_handler(template1325,'voucher_type'));
      Lino.ledger.Journals.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.ledger.Journals.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Countries.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 8,
  initComponent : function() {
    var isocode523 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">ISO code</span>", "name": "isocode", "boxMinWidth": Lino.chars2width(4), "listeners": { "render": Lino.quicktip_renderer("ISO code","(countries.Countries.isocode)         The two-letter code for this country as defined by ISO 3166-1.\n        For countries that no longer exist it may be a 4-letter code.") }, "maxLength": 4, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name524 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(countries.Countries.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de525 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(countries.Countries.name_de) ") }, "anchor": "-20" });
    var name_fr526 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(countries.Countries.name_fr) ") }, "anchor": "-20" });
    var name_et527 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(countries.Countries.name_et) ") }, "anchor": "-20" });
    var short_code528 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Short code</span>", "name": "short_code", "boxMinWidth": Lino.chars2width(4), "listeners": { "render": Lino.quicktip_renderer("Short code","(countries.Countries.short_code) A short abbreviation for regional usage. Obsolete.") }, "maxLength": 4, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel529 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": isocode523, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name524, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de525, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr526, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et527, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": short_code528, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var countries_PlacesByCountry_grid714 = new Lino.countries.PlacesByCountry.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Places","(countries.countries.PlacesByCountry) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.countries.PlacesByCountry.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel715 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel529, countries_PlacesByCountry_grid714 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel715;
    this.before_row_edit = function(record) {
      countries_PlacesByCountry_grid714.on_master_changed();
    }
    Lino.countries.Countries.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 68,
  initComponent : function() {
    var event1820 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Event", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.OneEvent.detail,Lino.cal.OneEvent.insert)}, "emptyText": "Select a Event...", "listeners": { "render": Lino.quicktip_renderer("Event","(cal.Guests.event) ") }, "selectOnFocus": true, "hiddenName": "eventHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/event", "method": "GET" }) }), "name": "event" });
    var partner1821 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "emptyText": "Select a Partner...", "listeners": { "render": Lino.quicktip_renderer("Partner","(cal.Guests.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }), "name": "partner" });
    var role1822 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Role", "name": "role", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.GuestRoles.detail,Lino.cal.GuestRoles.insert)}, "emptyText": "Select a Guest Role...", "listeners": { "render": Lino.quicktip_renderer("Role","(cal.Guests.role) ") }, "selectOnFocus": true, "hiddenName": "roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/role", "method": "GET" }) }) });
    var main_panel1823 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": event1820, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1821, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": role1822, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1823;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Guests.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Places.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 9,
  initComponent : function() {
    var name545 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(countries.Places.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de546 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(countries.Places.name_de) ") }, "anchor": "-20" });
    var name_fr547 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(countries.Places.name_fr) ") }, "anchor": "-20" });
    var name_et548 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(countries.Places.name_et) ") }, "anchor": "-20" });
    var country549 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Country", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Country","(countries.Places.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Places/country", "method": "GET" }) }), "name": "country" });
    var main_1_panel550 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name545, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de546, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr547, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et548, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country549, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var type556 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Place Type", "name": "type", "hiddenName": "typeHidden", "listeners": { "render": Lino.quicktip_renderer("Place Type","(countries.Places.type) ") }, "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Places/type", "method": "GET" }) }) });
    var parent557 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Part of</span>", "name": "parent", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Part of","(countries.Places.parent) The superordinate geographic place         of which this place is a part.") }, "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Places/parent", "method": "GET" }) }) });
    var zip_code558 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "zip code", "name": "zip_code", "boxMinWidth": Lino.chars2width(8), "listeners": { "render": Lino.quicktip_renderer("zip code","(countries.Places.zip_code) ") }, "maxLength": 8, "selectOnFocus": true, "anchor": "-20" });
    var id559 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(countries.Places.id) ") }, "anchor": "-20" });
    var main_2_panel560 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type556, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent557, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code558, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id559, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var PlacesByPlace_grid711 = new Lino.countries.PlacesByPlace.GridPanel({ "flex": 41, "listeners": { "render": Lino.quicktip_renderer("Subdivisions","(countries.countries.PlacesByPlace) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.countries.PlacesByPlace.grid) ], "preview_limit": 15, "master_panel": this });
    var contacts_PartnersByCity_grid712 = new Lino.contacts.PartnersByCity.GridPanel({ "flex": 41, "listeners": { "render": Lino.quicktip_renderer("Partners","(contacts.contacts.PartnersByCity) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.PartnersByCity.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel713 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel550, main_2_panel560, PlacesByPlace_grid711, contacts_PartnersByCity_grid712 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel713;
    this.before_row_edit = function(record) {
      type556.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      PlacesByPlace_grid711.on_master_changed();
      contacts_PartnersByCity_grid712.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country549.on('change',Lino.chooser_handler(type556,'country'));
      Lino.countries.Places.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.countries.Places.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 68,
  initComponent : function() {
    var event1805 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Event", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.OneEvent.detail,Lino.cal.OneEvent.insert)}, "emptyText": "Select a Event...", "listeners": { "render": Lino.quicktip_renderer("Event","(cal.Guests.event) ") }, "selectOnFocus": true, "hiddenName": "eventHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/event", "method": "GET" }) }), "name": "event" });
    var partner1806 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "emptyText": "Select a Partner...", "listeners": { "render": Lino.quicktip_renderer("Partner","(cal.Guests.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }), "name": "partner" });
    var role1807 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Role", "name": "role", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.GuestRoles.detail,Lino.cal.GuestRoles.insert)}, "emptyText": "Select a Guest Role...", "listeners": { "render": Lino.quicktip_renderer("Role","(cal.Guests.role) ") }, "selectOnFocus": true, "hiddenName": "roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/role", "method": "GET" }) }) });
    var main_1_panel1808 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event1805, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1806, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": role1807, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var state1812 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "State", "allowBlank": false, "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("State","(cal.Guests.state) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.GuestStates, "name": "state" });
    var remark1813 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Remark", "name": "remark", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Remark","(cal.Guests.remark) ") }, "anchor": "-20" });
    var workflow_buttons_disp1814 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Workflow", "name": "workflow_buttons", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Workflow","(cal.Guests.workflow_buttons) ") }, "anchor": "-20" });
    var main_2_panel1815 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state1812, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": remark1813, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp1814, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1819 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1808, main_2_panel1815 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1819;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Guests.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.excerpts.Excerpts.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 78,
  initComponent : function() {
    var id2235 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(excerpts.Excerpts.id) ") }, "anchor": "-20" });
    var excerpt_type2236 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Excerpt Type", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.excerpts.ExcerptTypes.detail,Lino.excerpts.ExcerptTypes.insert)}, "emptyText": "Select a Excerpt Type...", "listeners": { "render": Lino.quicktip_renderer("Excerpt Type","(excerpts.Excerpts.excerpt_type) ") }, "selectOnFocus": true, "hiddenName": "excerpt_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/excerpt_type", "method": "GET" }) }), "name": "excerpt_type" });
    var project2237 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail,Lino.tickets.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(excerpts.Excerpts.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/project", "method": "GET" }) }) });
    var main_1_panel2238 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id2235, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": excerpt_type2236, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project2237, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user2242 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(excerpts.Excerpts.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/user", "method": "GET" }) }) });
    var build_method2243 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Build method", "allowBlank": false, "hiddenName": "build_methodHidden", "listeners": { "render": Lino.quicktip_renderer("Build method","(excerpts.Excerpts.build_method) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.BuildMethods, "name": "build_method" });
    var main_2_panel2244 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user2242, "labelAlign": "top" }, { "flex": 67, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method2243, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var company2247 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Recipient (Organization)", "name": "company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "companyHidden", "listeners": { "render": Lino.quicktip_renderer("Recipient (Organization)","(excerpts.Excerpts.company) ") }, "selectOnFocus": true, "emptyText": "Select a Organization...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/company", "method": "GET" }) }) });
    var contact_person2248 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Recipient (Person)", "name": "contact_person", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Persons.detail,Lino.contacts.Persons.insert)}, "hiddenName": "contact_personHidden", "listeners": { "render": Lino.quicktip_renderer("Recipient (Person)","(excerpts.Excerpts.contact_person) ") }, "selectOnFocus": true, "emptyText": "Select a Person...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/excerpts/Excerpts/contact_person", "method": "GET" }) }) });
    var language2249 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Language", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(excerpts.Excerpts.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ] ], "name": "language" });
    var main_3_panel2250 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 225, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": company2247, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": contact_person2248, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language2249, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var owner_disp2254 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Controlled by", "anchor": "-20", "name": "owner" });
    var build_time2255 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "build time", "name": "build_time", "listeners": { "render": Lino.quicktip_renderer("build time","(excerpts.Excerpts.build_time) ") }, "value": "<br>", "anchor": "-20" });
    var main_4_panel2256 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp2254, "labelAlign": "top" }, { "flex": 61, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_time2255, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var outbox_MailsByController_grid2270 = new Lino.outbox.MailsByController.GridPanel({ "flex": 55, "listeners": { "render": Lino.quicktip_renderer("Outgoing Mails","(outbox.outbox.MailsByController) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel2271 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel2238, main_2_panel2244, main_3_panel2250, main_4_panel2256, outbox_MailsByController_grid2270 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2271;
    this.before_row_edit = function(record) {
      excerpt_type2236.setContextValue('owner', record ? record.data['owner'] : undefined);
      contact_person2248.setContextValue('company', record ? record.data['companyHidden'] : undefined);
      outbox_MailsByController_grid2270.on_master_changed();
    }
    this.onRender = function(ct, position) {
      owner_disp2254.on('change',Lino.chooser_handler(excerpt_type2236,'owner'));
      company2247.on('change',Lino.chooser_handler(contact_person2248,'company'));
      Lino.excerpts.Excerpts.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.excerpts.Excerpts.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropGroups.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 11,
  initComponent : function() {
    var id716 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(properties.PropGroups.id) ") }, "anchor": "-20" });
    var name717 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(properties.PropGroups.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de718 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(properties.PropGroups.name_de) ") }, "anchor": "-20" });
    var name_fr719 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(properties.PropGroups.name_fr) ") }, "anchor": "-20" });
    var name_et720 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(properties.PropGroups.name_et) ") }, "anchor": "-20" });
    var main_1_panel721 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id716, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name717, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de718, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr719, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et720, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var PropsByGroup_grid734 = new Lino.properties.PropsByGroup.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Properties","(properties.properties.PropsByGroup) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.properties.PropsByGroup.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel735 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel721, PropsByGroup_grid734 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel735;
    this.before_row_edit = function(record) {
      PropsByGroup_grid734.on_master_changed();
    }
    Lino.properties.PropGroups.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 12,
  initComponent : function() {
    var id736 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(properties.PropTypes.id) ") }, "anchor": "-20" });
    var name737 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(properties.PropTypes.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de738 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(properties.PropTypes.name_de) ") }, "anchor": "-20" });
    var name_fr739 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(properties.PropTypes.name_fr) ") }, "anchor": "-20" });
    var name_et740 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(properties.PropTypes.name_et) ") }, "anchor": "-20" });
    var choicelist741 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Choices List", "name": "choicelist", "hiddenName": "choicelistHidden", "listeners": { "render": Lino.quicktip_renderer("Choices List","(properties.PropTypes.choicelist) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "countries.PlaceTypes", "PlaceTypes" ], [ "lino.BuildMethods", "BuildMethods" ], [ "properties.DoYouLike", "DoYouLike" ], [ "properties.HowWell", "HowWell" ], [ "system.Genders", "Genders" ], [ "system.PeriodEvents", "Observed events" ], [ "system.YesNo", "Yes or no" ], [ "users.UserGroups", "User Groups" ], [ "users.UserLevels", "User Levels" ], [ "users.UserProfiles", "User Profiles" ] ] });
    var default_value742 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "default value", "name": "default_value", "hiddenName": "default_valueHidden", "listeners": { "render": Lino.quicktip_renderer("default value","(properties.PropTypes.default_value) ") }, "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropTypes/default_value", "method": "GET" }) }) });
    var main_1_panel743 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 4, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id736, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name737, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de738, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr739, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et740, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": choicelist741, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": default_value742, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 153, "border": false, "frame": false, "labelAlign": "top" });
    var ChoicesByType_grid758 = new Lino.properties.ChoicesByType.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Property Choices","(properties.properties.ChoicesByType) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.properties.ChoicesByType.grid) ] });
    var PropsByType_grid766 = new Lino.properties.PropsByType.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Properties","(properties.properties.PropsByType) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.properties.PropsByType.grid) ] });
    var main_panel767 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "hideCheckBoxLabels": true, "items": [ main_1_panel743, ChoicesByType_grid758, PropsByType_grid766 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel767;
    this.before_row_edit = function(record) {
      default_value742.setContextValue('choicelist', record ? record.data['choicelistHidden'] : undefined);
      ChoicesByType_grid758.on_master_changed();
      PropsByType_grid766.on_master_changed();
    }
    this.onRender = function(ct, position) {
      choicelist741.on('change',Lino.chooser_handler(default_value742,'choicelist'));
      Lino.properties.PropTypes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.properties.PropTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.addresses.Addresses.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 26,
  initComponent : function() {
    var country797 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Country","(addresses.Addresses.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/addresses/Addresses/country", "method": "GET" }) }) });
    var city798 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "City", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("City","(addresses.Addresses.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/addresses/Addresses/city", "method": "GET" }) }) });
    var main_1_panel799 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country797, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city798, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street802 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Street","(addresses.Addresses.street) Name of street, without house number.") }, "anchor": "-20" });
    var street_no803 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("No.","(addresses.Addresses.street_no) House number.") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var street_box804 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Box","(addresses.Addresses.street_box) Text to print after street nuber on the same line.") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel805 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street802, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no803, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box804, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var address_type809 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Address type", "name": "address_type", "hiddenName": "address_typeHidden", "listeners": { "render": Lino.quicktip_renderer("Address type","(addresses.Addresses.address_type) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.addresses.AddressTypes) });
    var remark810 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Remark", "name": "remark", "maxLength": 50, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Remark","(addresses.Addresses.remark) ") }, "anchor": "-20" });
    var main_3_panel811 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": address_type809, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": remark810, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel814 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel799, main_2_panel805, main_3_panel811 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel814;
    this.before_row_edit = function(record) {
      city798.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city798.setContextValue('region', record ? record.data['regionHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      country797.on('change',Lino.chooser_handler(city798,'country'));
      Lino.addresses.Addresses.InsertFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.addresses.Addresses.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contenttypes.ContentTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 3,
  initComponent : function() {
    var id450 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contenttypes.ContentTypes.id) ") }, "anchor": "-20" });
    var name451 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("name","(contenttypes.ContentTypes.name) ") }, "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var app_label452 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "app label", "name": "app_label", "listeners": { "render": Lino.quicktip_renderer("app label","(contenttypes.ContentTypes.app_label) ") }, "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var model453 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "python model class name", "name": "model", "listeners": { "render": Lino.quicktip_renderer("python model class name","(contenttypes.ContentTypes.model) ") }, "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var base_classes_disp454 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Base classes", "name": "base_classes", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Base classes","(contenttypes.ContentTypes.base_classes) ") }, "anchor": "-20" });
    var main_1_panel455 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id450, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name451, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_label452, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": model453, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": base_classes_disp454, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 216, "border": false, "frame": false, "labelAlign": "top" });
    var HelpTextsByModel_grid467 = new Lino.contenttypes.HelpTextsByModel.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Help Texts","(contenttypes.contenttypes.HelpTextsByModel) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.contenttypes.HelpTextsByModel.grid) ] });
    var StaleControllablesByModel_grid471 = new Lino.contenttypes.StaleControllablesByModel.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Stale Controllables","(contenttypes.contenttypes.StaleControllablesByModel) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.contenttypes.StaleControllablesByModel.grid) ] });
    var main_panel472 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "hideCheckBoxLabels": true, "items": [ main_1_panel455, HelpTextsByModel_grid467, StaleControllablesByModel_grid471 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel472;
    this.before_row_edit = function(record) {
      HelpTextsByModel_grid467.on_master_changed();
      StaleControllablesByModel_grid471.on_master_changed();
    }
    Lino.contenttypes.ContentTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 15,
  initComponent : function() {
    var overview_disp890 = new Ext.form.DisplayField({ "disabled": true, "flex": 20, "listeners": { "render": Lino.quicktip_renderer(null,"(contacts.Companies.overview) ") }, "name": "overview", "value": "<br/>", "always_enabled": true });
    var prefix891 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name prefix", "name": "prefix", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Name prefix","(contacts.Companies.prefix) ") }, "anchor": "-20" });
    var name892 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Companies.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var general2_1_panel893 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix891, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name892, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type896 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Organization type", "name": "type", "pageSize": 20, "emptyText": "Select a Organization type...", "listeners": { "render": Lino.quicktip_renderer("Organization type","(contacts.Companies.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var vat_id897 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "VAT id", "name": "vat_id", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("VAT id","(contacts.Companies.vat_id) ") }, "anchor": "-20" });
    var general2_2_panel898 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type896, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id897, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var url901 = new Lino.URLField({ "autoHeight": true, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("URL","(contacts.Companies.url) ") }, "anchor": "-20" });
    var general2_panel902 = new Ext.Panel({ "flex": 40, "autoHeight": true, "layout": "form", "items": [ general2_1_panel893, general2_2_panel898, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url901, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 36, "border": false, "labelAlign": "top" });
    var email904 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Companies.email) ") }, "anchor": "-20" });
    var phone905 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Phone", "name": "phone", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Phone","(contacts.Companies.phone) ") }, "anchor": "-20" });
    var gsm906 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("GSM","(contacts.Companies.gsm) ") }, "anchor": "-20" });
    var fax907 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Fax","(contacts.Companies.fax) ") }, "anchor": "-20" });
    var general3_panel908 = new Ext.Panel({ "flex": 40, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email904, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone905, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm906, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax907, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var general_1_panel913 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ overview_disp890, general2_panel902, general3_panel908 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var contacts_RolesByCompany_grid918 = new Lino.contacts.RolesByCompany.GridPanel({ "flex": 55, "listeners": { "render": Lino.quicktip_renderer("Contact persons","(contacts.contacts.RolesByCompany) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.grid) ], "preview_limit": 15, "master_panel": this });
    var general_panel919 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel913, contacts_RolesByCompany_grid918 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var lists_MembersByPartner_grid920 = new Lino.lists.MembersByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("List memberships","(lists.lists.MembersByPartner) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.lists.MembersByPartner.grid) ] });
    var remarks921 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remarks","(contacts.Companies.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var sepa_AccountsByPartner_grid922 = new Lino.sepa.AccountsByPartner.GridPanel({ "flex": 64, "listeners": { "render": Lino.quicktip_renderer("Accounts","(sepa.sepa.AccountsByPartner) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.sepa.AccountsByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var contact_2_panel923 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ { "items": remarks921, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 35 }, sepa_AccountsByPartner_grid922 ], "region": "center", "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 72, "border": false, "frame": false, "labelAlign": "top" });
    var contact_panel925 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Contact", "hideCheckBoxLabels": true, "items": [ lists_MembersByPartner_grid920, contact_2_panel923 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var tickets_VotesByPartner_grid926 = new Lino.tickets.VotesByPartner.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Votes", "tools": [ Lino.show_in_own_window_button(Lino.tickets.VotesByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var id927 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Companies.id) ") }, "anchor": "-20" });
    var language928 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(contacts.Companies.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ] ], "name": "language" });
    var misc_1_panel929 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id927, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language928, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var created932 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "listeners": { "render": Lino.quicktip_renderer("Created","(contacts.Companies.created) ") }, "value": "<br>", "anchor": "-20" });
    var modified933 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "listeners": { "render": Lino.quicktip_renderer("Modified","(contacts.Companies.modified) ") }, "value": "<br>", "anchor": "-20" });
    var misc_2_panel934 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created932, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified933, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var misc_panel937 = new Ext.Panel({ "autoHeight": true, "layout": "form", "title": "Miscellaneous", "items": [ misc_1_panel929, misc_2_panel934 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "labelAlign": "top" });
    var VouchersByPartner_htmlbox938 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "VouchersByPartner", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "north", "title": "VAT vouchers", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("VAT vouchers","(contacts.Companies.VouchersByPartner) ") }, "bodyStyle": "overflow-x:hidden;", "split": true, "tools": [ Lino.show_in_own_window_button(Lino.ledger.VouchersByPartner.grid) ] });
    var ledger_MovementsByPartner_grid939 = new Lino.ledger.MovementsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Movements","(ledger.ledger.MovementsByPartner) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.ledger.MovementsByPartner.grid) ] });
    var ledger_panel940 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 117, "title": "Accounting", "hideCheckBoxLabels": true, "items": [ VouchersByPartner_htmlbox938, ledger_MovementsByPartner_grid939 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel941 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel919, contact_panel925, tickets_VotesByPartner_grid926, misc_panel937, ledger_panel940 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel941;
    this.before_row_edit = function(record) {
      contacts_RolesByCompany_grid918.on_master_changed();
      lists_MembersByPartner_grid920.on_master_changed();
      sepa_AccountsByPartner_grid922.on_master_changed();
      tickets_VotesByPartner_grid926.on_master_changed();
      VouchersByPartner_htmlbox938.refresh();
      ledger_MovementsByPartner_grid939.on_master_changed();
    }
    Lino.contacts.Companies.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
  }
});


Lino.cal.Calendars.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 71,
  initComponent : function() {
    var name1858 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(cal.Calendars.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1859 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(cal.Calendars.name_de) ") }, "anchor": "-20" });
    var name_fr1860 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(cal.Calendars.name_fr) ") }, "anchor": "-20" });
    var name_et1861 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(cal.Calendars.name_et) ") }, "anchor": "-20" });
    var color1862 = new Ext.form.NumberField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "color", "name": "color", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("color","(cal.Calendars.color) ") }, "anchor": "-20" });
    var id1863 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.Calendars.id) ") }, "anchor": "-20" });
    var main_1_panel1864 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1858, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1859, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1860, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1861, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": color1862, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1863, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description1871 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 63, "containing_panel": this, "name": "description", "title": "Description" });
    var SubscriptionsByCalendar_grid1876 = new Lino.cal.SubscriptionsByCalendar.GridPanel({ "flex": 36, "listeners": { "render": Lino.quicktip_renderer("Subscriptions","(cal.cal.SubscriptionsByCalendar) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.SubscriptionsByCalendar.grid) ], "preview_limit": 15, "master_panel": this });
    var main_2_panel1877 = new Ext.Panel({ "flex": 83, "border": false, "layout": "hbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ description1871, SubscriptionsByCalendar_grid1876 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel1878 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1864, main_2_panel1877 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1878;
    this.before_row_edit = function(record) {
      description1871.refresh();
      SubscriptionsByCalendar_grid1876.on_master_changed();
    }
    Lino.cal.Calendars.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.UploadsByController.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 62,
  initComponent : function() {
    var file2312 = Lino.file_field_handler(this,{ "autoHeight": true, "fieldLabel": "File", "name": "file", "maxLength": 100, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("File","(uploads.UploadsByController.file) ") }, "anchor": "-20" });
    var type2313 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Upload Type", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.uploads.UploadTypes.detail,Lino.uploads.UploadTypes.insert)}, "emptyText": "Select a Upload Type...", "listeners": { "render": Lino.quicktip_renderer("Upload Type","(uploads.UploadsByController.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/UploadsByController/type", "method": "GET" }) }) });
    var description2314 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Description", "name": "description", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Description","(uploads.UploadsByController.description) ") }, "anchor": "-20" });
    var main_panel2315 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 108, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": file2312, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": type2313, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": description2314, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2315;
    this.before_row_edit = function(record) {
      type2313.setContextValue('upload_area', record ? record.data['upload_areaHidden'] : undefined);
    }
    Lino.uploads.UploadsByController.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 18,
  initComponent : function() {
    var name701 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Partners.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language702 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(contacts.Partners.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ] ], "name": "language" });
    var email703 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Partners.email) ") }, "anchor": "-20" });
    var main_2_panel704 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language702, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email703, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel707 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name701, "anchor": "-20", "labelAlign": "top" }, main_2_panel704 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel707;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Partners.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.Uploads.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 62,
  initComponent : function() {
    var type1663 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Upload Type", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.uploads.UploadTypes.detail,Lino.uploads.UploadTypes.insert)}, "emptyText": "Select a Upload Type...", "listeners": { "render": Lino.quicktip_renderer("Upload Type","(uploads.Uploads.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var description1664 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Description", "name": "description", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Description","(uploads.Uploads.description) ") }, "anchor": "-20" });
    var file1665 = Lino.file_field_handler(this,{ "autoHeight": true, "fieldLabel": "File", "name": "file", "maxLength": 100, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("File","(uploads.Uploads.file) ") }, "anchor": "-20" });
    var user1666 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(uploads.Uploads.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_panel1667 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 108, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1663, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": description1664, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": file1665, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1666, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1667;
    this.before_row_edit = function(record) {
      type1663.setContextValue('upload_area', record ? record.data['upload_areaHidden'] : undefined);
    }
    Lino.uploads.Uploads.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Calendars.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 71,
  initComponent : function() {
    var name1879 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(cal.Calendars.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1880 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(cal.Calendars.name_de) ") }, "anchor": "-20" });
    var name_fr1881 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(cal.Calendars.name_fr) ") }, "anchor": "-20" });
    var name_et1882 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(cal.Calendars.name_et) ") }, "anchor": "-20" });
    var main_1_panel1883 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1879, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1880, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1881, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1882, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var color1888 = new Ext.form.NumberField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "color", "name": "color", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("color","(cal.Calendars.color) ") }, "anchor": "-20" });
    var main_panel1889 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 54, "autoScroll": false, "items": [ main_1_panel1883, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": color1888, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1889;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Calendars.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.finan.BankStatements.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 43,
  initComponent : function() {
    var date396 = new Lino.DateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date","(finan.BankStatements.date) ") }, "anchor": "-20" });
    var user397 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(finan.BankStatements.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/BankStatements/user", "method": "GET" }) }) });
    var main_1_panel398 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date396, "labelAlign": "top" }, { "flex": 60, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user397, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var balance1401 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "Old balance", "name": "balance1", "decimalSeparator": ",", "value": 0, "listeners": { "render": Lino.quicktip_renderer("Old balance","(finan.BankStatements.balance1) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var balance2402 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "New balance", "name": "balance2", "decimalSeparator": ",", "value": 0, "listeners": { "render": Lino.quicktip_renderer("New balance","(finan.BankStatements.balance2) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_panel403 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 108, "autoScroll": false, "items": [ main_1_panel398, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": balance1401, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": balance2402, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel403;
    this.before_row_edit = function(record) {
    }
    Lino.finan.BankStatements.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 18,
  initComponent : function() {
    var overview_disp622 = new Ext.form.DisplayField({ "disabled": true, "flex": 25, "listeners": { "render": Lino.quicktip_renderer(null,"(contacts.Partners.overview) ") }, "name": "overview", "value": "<br/>", "always_enabled": true });
    var id623 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Partners.id) ") }, "anchor": "-20" });
    var language624 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(contacts.Partners.language) Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ] ], "name": "language" });
    var general2_1_panel625 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id623, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language624, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var url628 = new Lino.URLField({ "autoHeight": true, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("URL","(contacts.Partners.url) ") }, "anchor": "-20" });
    var general2_panel629 = new Ext.Panel({ "flex": 25, "autoHeight": true, "layout": "form", "items": [ general2_1_panel625, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url628, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 36, "border": false, "labelAlign": "top" });
    var email631 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Partners.email) ") }, "anchor": "-20" });
    var phone632 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Phone", "name": "phone", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Phone","(contacts.Partners.phone) ") }, "anchor": "-20" });
    var gsm633 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("GSM","(contacts.Partners.gsm) ") }, "anchor": "-20" });
    var fax634 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Fax","(contacts.Partners.fax) ") }, "anchor": "-20" });
    var general3_panel635 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email631, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone632, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm633, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax634, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var general_1_panel640 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "title": "General", "items": [ overview_disp622, general2_panel629, general3_panel635 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "labelWidth": 0, "border": false, "labelAlign": "top" });
    var country641 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Country","(contacts.Partners.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }) });
    var region642 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "County", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("County","(contacts.Partners.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }) });
    var city643 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "City", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Places.detail,Lino.countries.Places.insert)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("City","(contacts.Partners.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }) });
    var zip_code644 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Zip code", "name": "zip_code", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Zip code","(contacts.Partners.zip_code) ") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var address_box_1_panel645 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country641, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region642, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city643, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code644, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr1650 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line before street</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Address line before street","(contacts.Partners.addr1) Address line before street") }, "anchor": "-20" });
    var street_prefix651 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street prefix</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Street prefix","(contacts.Partners.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "anchor": "-20" });
    var street652 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Street","(contacts.Partners.street) Name of street, without house number.") }, "anchor": "-20" });
    var street_no653 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("No.","(contacts.Partners.street_no) House number.") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var street_box654 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Box","(contacts.Partners.street_box) Text to print after street nuber on the same line.") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var address_box_3_panel655 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix651, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street652, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no653, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box654, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2660 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line after street</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Address line after street","(contacts.Partners.addr2) Address line to print below street line.") }, "anchor": "-20" });
    var address_box_panel661 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 243, "hideCheckBoxLabels": true, "items": [ address_box_1_panel645, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1650, "anchor": "-20", "labelAlign": "top" }, address_box_3_panel655, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2660, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var remarks664 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remarks","(contacts.Partners.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var sepa_AccountsByPartner_grid669 = new Lino.sepa.AccountsByPartner.GridPanel({ "flex": 64, "listeners": { "render": Lino.quicktip_renderer("Accounts","(sepa.sepa.AccountsByPartner) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.sepa.AccountsByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var contact_2_panel670 = new Ext.Panel({ "flex": 55, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": remarks664, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 35 }, sepa_AccountsByPartner_grid669 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var contact_panel672 = new Ext.Panel({ "layout": "vbox", "title": "Contact", "items": [ address_box_panel661, contact_2_panel670 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var tickets_VotesByPartner_grid677 = new Lino.tickets.VotesByPartner.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Votes", "tools": [ Lino.show_in_own_window_button(Lino.tickets.VotesByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var is_person678 = new Ext.form.Checkbox({ "boxLabel": "is Person (<a href=\"javascript:Lino.show_mti_child('is_person',Lino.contacts.Persons.detail)\">show</a>)", "autoHeight": true, "hideLabel": true, "name": "is_person", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("is Person","(contacts.Partners.is_person) Whether this Partner is a Person.") }, "anchor": "-20" });
    var is_company679 = new Ext.form.Checkbox({ "boxLabel": "is Company (<a href=\"javascript:Lino.show_mti_child('is_company',Lino.contacts.Companies.detail)\">show</a>)", "autoHeight": true, "hideLabel": true, "name": "is_company", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("is Company","(contacts.Partners.is_company) Whether this Partner is a Company.") }, "anchor": "-20" });
    var is_household680 = new Ext.form.Checkbox({ "boxLabel": "is Household (<a href=\"javascript:Lino.show_mti_child('is_household',Lino.households.Households.detail)\">show</a>)", "autoHeight": true, "hideLabel": true, "name": "is_household", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("is Household","(contacts.Partners.is_household) Whether this Partner is a Household.") }, "anchor": "-20" });
    var created681 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "listeners": { "render": Lino.quicktip_renderer("Created","(contacts.Partners.created) ") }, "value": "<br>", "anchor": "-20" });
    var modified682 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "listeners": { "render": Lino.quicktip_renderer("Modified","(contacts.Partners.modified) ") }, "value": "<br>", "anchor": "-20" });
    var misc_1_panel683 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "title": "Miscellaneous", "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_person678, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_company679, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_household680, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created681, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified682, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "labelWidth": 117, "border": false, "labelAlign": "top" });
    var VouchersByPartner_htmlbox689 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "VouchersByPartner", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "north", "title": "VAT vouchers", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("VAT vouchers","(contacts.Partners.VouchersByPartner) ") }, "bodyStyle": "overflow-x:hidden;", "split": true, "tools": [ Lino.show_in_own_window_button(Lino.ledger.VouchersByPartner.grid) ] });
    var ledger_MovementsByPartner_grid698 = new Lino.ledger.MovementsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Movements","(ledger.ledger.MovementsByPartner) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.ledger.MovementsByPartner.grid) ] });
    var ledger_panel699 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "labelWidth": 117, "title": "Accounting", "hideCheckBoxLabels": true, "items": [ VouchersByPartner_htmlbox689, ledger_MovementsByPartner_grid698 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel700 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_1_panel640, contact_panel672, tickets_VotesByPartner_grid677, misc_1_panel683, ledger_panel699 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel700;
    this.before_row_edit = function(record) {
      region642.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city643.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city643.setContextValue('region', record ? record.data['regionHidden'] : undefined);
      sepa_AccountsByPartner_grid669.on_master_changed();
      tickets_VotesByPartner_grid677.on_master_changed();
      VouchersByPartner_htmlbox689.refresh();
      ledger_MovementsByPartner_grid698.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country641.on('change',Lino.chooser_handler(region642,'country'));
      country641.on('change',Lino.chooser_handler(city643,'country'));
      region642.on('change',Lino.chooser_handler(city643,'region'));
      Lino.contacts.Partners.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Partners.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    city643.on("change", function(){ this.save() }, this);
    zip_code644.on("change", function(){ this.save() }, this);
  }
});


Lino.uploads.UploadTypes.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 61,
  initComponent : function() {
    var name1674 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(uploads.UploadTypes.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1675 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(uploads.UploadTypes.name_de) ") }, "anchor": "-20" });
    var name_fr1676 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(uploads.UploadTypes.name_fr) ") }, "anchor": "-20" });
    var name_et1677 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(uploads.UploadTypes.name_et) ") }, "anchor": "-20" });
    var main_1_panel1678 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1674, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1675, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1676, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1677, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var upload_area1683 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Upload Area", "allowBlank": false, "hiddenName": "upload_areaHidden", "listeners": { "render": Lino.quicktip_renderer("Upload Area","(uploads.UploadTypes.upload_area) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.uploads.UploadAreas, "name": "upload_area" });
    var main_panel1684 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 108, "autoScroll": false, "items": [ main_1_panel1678, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": upload_area1683, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1684;
    this.before_row_edit = function(record) {
    }
    Lino.uploads.UploadTypes.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.EventTypes.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 66,
  initComponent : function() {
    var name2057 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(cal.EventTypes.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de2058 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(cal.EventTypes.name_de) ") }, "anchor": "-20" });
    var name_fr2059 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(cal.EventTypes.name_fr) ") }, "anchor": "-20" });
    var name_et2060 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(cal.EventTypes.name_et) ") }, "anchor": "-20" });
    var main_1_panel2061 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name2057, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de2058, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr2059, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et2060, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var event_label2066 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Event label", "name": "event_label", "value": "Appointment", "listeners": { "render": Lino.quicktip_renderer("Event label","(cal.EventTypes.event_label) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var event_label_de2067 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Event label (de)", "name": "event_label_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Event label (de)","(cal.EventTypes.event_label_de) ") }, "anchor": "-20" });
    var event_label_fr2068 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Event label (fr)", "name": "event_label_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Event label (fr)","(cal.EventTypes.event_label_fr) ") }, "anchor": "-20" });
    var event_label_et2069 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Event label (et)", "name": "event_label_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Event label (et)","(cal.EventTypes.event_label_et) ") }, "anchor": "-20" });
    var main_2_panel2070 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label2066, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label_de2067, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label_fr2068, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label_et2069, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel2075 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel2061, main_2_panel2070 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel2075;
    this.before_row_edit = function(record) {
    }
    Lino.cal.EventTypes.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Invoices.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 35,
  initComponent : function() {
    var id237 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(ledger.Invoices.id) ") }, "anchor": "-20" });
    var date238 = new Lino.DateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date","(ledger.Invoices.date) ") }, "anchor": "-20" });
    var partner239 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "emptyText": "Select a Partner...", "listeners": { "render": Lino.quicktip_renderer("Partner","(ledger.Invoices.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/partner", "method": "GET" }) }), "name": "partner" });
    var user240 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(ledger.Invoices.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/user", "method": "GET" }) }) });
    var general_1_panel241 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id237, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date238, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner239, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user240, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var due_date246 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Due date", "name": "due_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Due date","(ledger.Invoices.due_date) ") }, "anchor": "-20" });
    var your_ref247 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Your reference", "name": "your_ref", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Your reference","(ledger.Invoices.your_ref) ") }, "anchor": "-20" });
    var vat_regime248 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "VAT Regime", "allowBlank": false, "hiddenName": "vat_regimeHidden", "listeners": { "render": Lino.quicktip_renderer("VAT Regime","(ledger.Invoices.vat_regime) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.vat.VatRegimes, "name": "vat_regime" });
    var general_2_panel249 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": due_date246, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": your_ref247, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_regime248, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var ItemsByInvoice_grid260 = new Lino.ledger.ItemsByInvoice.GridPanel({ "flex": 75, "listeners": { "render": Lino.quicktip_renderer("Voucher items","(ledger.ledger.ItemsByInvoice) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.ledger.ItemsByInvoice.grid) ], "preview_limit": 15, "master_panel": this });
    var total_base261 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "Total excl. VAT", "name": "total_base", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Total excl. VAT","(ledger.Invoices.total_base) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var total_vat262 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "VAT", "name": "total_vat", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("VAT","(ledger.Invoices.total_vat) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var total_incl263 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "Total incl. VAT", "name": "total_incl", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Total incl. VAT","(ledger.Invoices.total_incl) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var workflow_buttons_disp264 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Workflow", "name": "workflow_buttons", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Workflow","(ledger.Invoices.workflow_buttons) ") }, "anchor": "-20" });
    var totals_panel265 = new Ext.Panel({ "flex": 25, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_base261, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_vat262, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_incl263, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp264, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 144, "border": false, "labelAlign": "top" });
    var general_3_panel270 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ ItemsByInvoice_grid260, totals_panel265 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "anchor": "-20", "labelAlign": "top" });
    var general_panel271 = new Ext.Panel({ "autoHeight": true, "layout": "form", "title": "General", "items": [ general_1_panel241, general_2_panel249, general_3_panel270 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "labelAlign": "top" });
    var journal272 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Journal", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail,Lino.ledger.Journals.insert)}, "emptyText": "Select a Journal...", "listeners": { "render": Lino.quicktip_renderer("Journal","(ledger.Invoices.journal) ") }, "selectOnFocus": true, "hiddenName": "journalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/journal", "method": "GET" }) }), "name": "journal" });
    var year273 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "year", "hiddenName": "yearHidden", "listeners": { "render": Lino.quicktip_renderer("Fiscal Year","(ledger.Invoices.year) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var number274 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "number", "name": "number", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("number","(ledger.Invoices.number) ") }, "anchor": "-20" });
    var narration275 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Narration", "name": "narration", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Narration","(ledger.Invoices.narration) ") }, "anchor": "-20" });
    var ledger_1_panel276 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": journal272, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": year273, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": number274, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": narration275, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var MovementsByVoucher_grid281 = new Lino.ledger.MovementsByVoucher.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Movements","(ledger.ledger.MovementsByVoucher) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.ledger.MovementsByVoucher.grid) ], "preview_limit": 15, "master_panel": this });
    var ledger_panel282 = new Ext.Panel({ "layout": "vbox", "title": "Ledger", "items": [ ledger_1_panel276, MovementsByVoucher_grid281 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel283 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel271, ledger_panel282 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel283;
    this.before_row_edit = function(record) {
      ItemsByInvoice_grid260.on_master_changed();
      MovementsByVoucher_grid281.on_master_changed();
    }
    Lino.ledger.Invoices.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.finan.BankStatements.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 43,
  initComponent : function() {
    var date358 = new Lino.DateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date","(finan.BankStatements.date) ") }, "anchor": "-20" });
    var balance1359 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "Old balance", "name": "balance1", "decimalSeparator": ",", "value": 0, "listeners": { "render": Lino.quicktip_renderer("Old balance","(finan.BankStatements.balance1) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var balance2360 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "New balance", "name": "balance2", "decimalSeparator": ",", "value": 0, "listeners": { "render": Lino.quicktip_renderer("New balance","(finan.BankStatements.balance2) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user361 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(finan.BankStatements.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/BankStatements/user", "method": "GET" }) }) });
    var workflow_buttons_disp362 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Workflow", "name": "workflow_buttons", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Workflow","(finan.BankStatements.workflow_buttons) ") }, "anchor": "-20" });
    var general_1_panel363 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date358, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": balance1359, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": balance2360, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user361, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp362, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var finan_ItemsByBankStatement_grid382 = new Lino.finan.ItemsByBankStatement.GridPanel({ "flex": 62, "listeners": { "render": Lino.quicktip_renderer("Items","(finan.finan.ItemsByBankStatement) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.finan.ItemsByBankStatement.grid) ], "preview_limit": 15, "master_panel": this });
    var general_panel383 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel363, finan_ItemsByBankStatement_grid382 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var id384 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(finan.BankStatements.id) ") }, "anchor": "-20" });
    var journal385 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Journal", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail,Lino.ledger.Journals.insert)}, "emptyText": "Select a Journal...", "listeners": { "render": Lino.quicktip_renderer("Journal","(finan.BankStatements.journal) ") }, "selectOnFocus": true, "hiddenName": "journalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/BankStatements/journal", "method": "GET" }) }), "name": "journal" });
    var year386 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "year", "hiddenName": "yearHidden", "listeners": { "render": Lino.quicktip_renderer("Fiscal Year","(finan.BankStatements.year) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var number387 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "number", "name": "number", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("number","(finan.BankStatements.number) ") }, "anchor": "-20" });
    var ledger_1_panel388 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id384, "labelAlign": "top" }, { "flex": 54, "autoHeight": true, "layout": "form", "xtype": "panel", "items": journal385, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": year386, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": number387, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ledger_MovementsByVoucher_grid393 = new Lino.ledger.MovementsByVoucher.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Movements","(ledger.ledger.MovementsByVoucher) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.ledger.MovementsByVoucher.grid) ], "preview_limit": 15, "master_panel": this });
    var ledger_panel394 = new Ext.Panel({ "layout": "vbox", "title": "Ledger", "items": [ ledger_1_panel388, ledger_MovementsByVoucher_grid393 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel395 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel383, ledger_panel394 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel395;
    this.before_row_edit = function(record) {
      finan_ItemsByBankStatement_grid382.on_master_changed();
      ledger_MovementsByVoucher_grid393.on_master_changed();
    }
    Lino.finan.BankStatements.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.lists.Lists.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 25,
  initComponent : function() {
    var ref1072 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Reference", "name": "ref", "maxLength": 40, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Reference","(lists.Lists.ref) ") }, "anchor": "-20" });
    var list_type1073 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "List Type", "name": "list_type", "pageSize": 20, "emptyText": "Select a List Type...", "listeners": { "render": Lino.quicktip_renderer("List Type","(lists.Lists.list_type) ") }, "selectOnFocus": true, "hiddenName": "list_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/lists/Lists/list_type", "method": "GET" }) }) });
    var main_1_panel1074 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1072, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": list_type1073, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var name1077 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(lists.Lists.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1078 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(lists.Lists.name_de) ") }, "anchor": "-20" });
    var name_fr1079 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(lists.Lists.name_fr) ") }, "anchor": "-20" });
    var name_et1080 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (et)", "name": "name_et", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (et)","(lists.Lists.name_et) ") }, "anchor": "-20" });
    var main_2_panel1081 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1077, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1078, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1079, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_et1080, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks1086 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remarks","(lists.Lists.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var main_panel1087 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ main_1_panel1074, main_2_panel1081, { "items": remarks1086, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1087;
    this.before_row_edit = function(record) {
    }
    Lino.lists.Lists.InsertFormPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Users.change_password = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.Users.change_password_ActionFormPanel({});
});
Lino.contacts.Persons.create_household = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Persons.create_household_ActionFormPanel({});
});
Lino.cal.GuestStates.wf1 = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Guests.wf1_ActionFormPanel({});
});
Lino.cal.GuestStates.wf2 = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(15) }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.cal.Guests.wf2_ActionFormPanel({});
});

// js_render_GridPanel_class contenttypes.ContentTypes
Lino.contenttypes.ContentTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contenttypes/ContentTypes",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/contenttypes/ContentTypes','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/contenttypes/ContentTypes','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contenttypes/ContentTypes','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contenttypes/ContentTypes','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/contenttypes/ContentTypes','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "content types",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 5,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "app_label" }, { "name": "model" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 3,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.contenttypes.ContentTypes.detail;
    this.ls_insert_handler = Lino.contenttypes.ContentTypes.insert;
    var ww = this.containing_window;
    var id2354 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2355 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var app_label2356 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var model2357 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(contenttypes.ContentTypes.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id2354, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "name", "editable": true, "tooltip": "(contenttypes.ContentTypes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name2355, "dataIndex": "name" }, { "colIndex": 2, "sortable": true, "header": "app label", "editable": true, "tooltip": "(contenttypes.ContentTypes.app_label) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": app_label2356, "dataIndex": "app_label" }, { "colIndex": 3, "sortable": true, "header": "python model class name", "editable": true, "tooltip": "(contenttypes.ContentTypes.model) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": model2357, "dataIndex": "model" } ];
    Lino.contenttypes.ContentTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contenttypes.ContentTypes.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/ContentTypes", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.ContentTypes.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/ContentTypes", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.ContentTypes.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/ContentTypes", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.ContentTypes.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/ContentTypes", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.ContentTypes.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/ContentTypes", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.contenttypes.ContentTypes.insertPanel = Ext.extend(Lino.contenttypes.ContentTypes.DetailFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/contenttypes/ContentTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contenttypes.ContentTypes.detail;
    this.ls_insert_handler = Lino.contenttypes.ContentTypes.insert;
    Lino.contenttypes.ContentTypes.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contenttypes.ContentTypes.insert = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contenttypes.ContentTypes.insertPanel(p);
});
Lino.contenttypes.ContentTypes.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/ContentTypes", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.ContentTypes.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/ContentTypes", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.ContentTypes.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/ContentTypes", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.contenttypes.ContentTypes.detailPanel = Ext.extend(Lino.contenttypes.ContentTypes.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  ls_url: "/contenttypes/ContentTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contenttypes.ContentTypes.detail;
    this.ls_insert_handler = Lino.contenttypes.ContentTypes.insert;
    Lino.contenttypes.ContentTypes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contenttypes.ContentTypes.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contenttypes.ContentTypes.detailPanel(p);
});
Lino.contenttypes.ContentTypes.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/ContentTypes", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.ContentTypes.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contenttypes.ContentTypes.GridPanel(p);
});
Lino.contenttypes.ContentTypes.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/ContentTypes", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class contenttypes.HelpTexts
Lino.contenttypes.HelpTexts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contenttypes/HelpTexts",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/contenttypes/HelpTexts','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/contenttypes/HelpTexts','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contenttypes/HelpTexts','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contenttypes/HelpTexts','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/contenttypes/HelpTexts','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Help Texts",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "name": "field" }, { "name": "verbose_name" }, { "name": "help_text" }, { "type": "int", "name": "id" }, { "name": "content_type" }, 'content_typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 2,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var field2359 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contenttypes/HelpTexts/field", "method": "GET" }) }) });
    var verbose_name2360 = new Ext.form.TextField({ "disabled": true, "maxLength": 200 });
    var help_text2361 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var id2362 = new Ext.form.NumberField({ "selectOnFocus": true });
    var content_type2363 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contenttypes/HelpTexts/content_type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a content type..." });
    this.before_row_edit = function(record) {
      field2359.setContextValue('content_type', record ? record.data['content_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      content_type2363.on('change',Lino.chooser_handler(field2359,'content_type'));
      Lino.contenttypes.HelpTexts.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Field", "editable": true, "tooltip": "(contenttypes.HelpTexts.field) The name of the field.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": field2359, "dataIndex": "field" }, { "header": "Verbose name", "colIndex": 1, "sortable": false, "dataIndex": "verbose_name", "width": Lino.chars2width(22), "editable": false, "tooltip": "(contenttypes.HelpTexts.verbose_name) " }, { "colIndex": 2, "sortable": false, "header": "HelpText", "editable": true, "tooltip": "(contenttypes.HelpTexts.help_text) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "editor": help_text2361, "dataIndex": "help_text" }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(contenttypes.HelpTexts.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id2362, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Model", "editable": true, "tooltip": "(contenttypes.HelpTexts.content_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('content_typeHidden','Lino.contenttypes.ContentTypes.detail'), "dataIndex": "content_type", "editor": content_type2363 } ];
    Lino.contenttypes.HelpTexts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contenttypes.HelpTexts.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/HelpTexts", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.HelpTexts.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/HelpTexts", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.HelpTexts.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/HelpTexts", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.HelpTexts.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/HelpTexts", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.HelpTexts.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/HelpTexts", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.HelpTexts.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/HelpTexts", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.HelpTexts.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/HelpTexts", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.HelpTexts.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contenttypes/HelpTexts", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contenttypes.HelpTexts.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contenttypes.HelpTexts.GridPanel(p);
});

// js_render_GridPanel_class system.SiteConfigs
Lino.system.SiteConfigs.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/system/SiteConfigs",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/system/SiteConfigs','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/system/SiteConfigs','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/SiteConfigs','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/SiteConfigs','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/system/SiteConfigs','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "do_build", "menu_item_text": "Rebuild site cache", "panel_btn_handler": Lino.row_action_handler('do_build','GET',null), "text": "Rebuild site cache", "overflowText": "Rebuild site cache", "auto_save": true } ],
  cell_edit : true,
  title : "Site configurations",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 28,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "default_build_method" }, 'default_build_methodHidden', { "type": "int", "name": "next_partner_id" }, { "name": "site_company" }, 'site_companyHidden', { "name": "default_event_type" }, 'default_event_typeHidden', { "name": "site_calendar" }, 'site_calendarHidden', { "type": "int", "name": "max_auto_events" }, { "name": "clients_account" }, 'clients_accountHidden', { "name": "sales_vat_account" }, 'sales_vat_accountHidden', { "name": "sales_account" }, 'sales_accountHidden', { "name": "suppliers_account" }, 'suppliers_accountHidden', { "name": "purchases_vat_account" }, 'purchases_vat_accountHidden', { "name": "purchases_account" }, 'purchases_accountHidden', { "name": "wages_account" }, 'wages_accountHidden', { "name": "clearings_account" }, 'clearings_accountHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 4,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.system.SiteConfigs.detail;
    var ww = this.containing_window;
    var id2365 = new Ext.form.NumberField({ "selectOnFocus": true });
    var default_build_method2366 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.BuildMethods) });
    var next_partner_id2367 = new Ext.form.NumberField({ "selectOnFocus": true, "value": 100 });
    var site_company2368 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/site_company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Organization..." });
    var default_event_type2369 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/default_event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Event Type..." });
    var site_calendar2370 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/site_calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    var max_auto_events2371 = new Ext.form.NumberField({ "selectOnFocus": true, "value": 72 });
    var clients_account2372 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/clients_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var sales_vat_account2373 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/sales_vat_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var sales_account2374 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/sales_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var suppliers_account2375 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/suppliers_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var purchases_vat_account2376 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/purchases_vat_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var purchases_account2377 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/purchases_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var wages_account2378 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/wages_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var clearings_account2379 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/clearings_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.SiteConfigs.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id2365, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Default build method", "editable": true, "tooltip": "(system.SiteConfigs.default_build_method) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": default_build_method2366, "dataIndex": "default_build_method" }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.SiteConfigs.next_partner_id) The next automatic id for any new partner.", "filter": { "type": "numeric" }, "header": "Next partner id", "editor": next_partner_id2367, "width": Lino.chars2width(6), "dataIndex": "next_partner_id" }), { "colIndex": 3, "sortable": true, "header": "Site owner", "editable": true, "tooltip": "(system.SiteConfigs.site_company) The organisation who runs this site.\n        This is used e.g. as sender in documents.\n        Or, newly created partners inherit the country of the site owner.\n        ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('site_companyHidden','Lino.contacts.Companies.detail'), "dataIndex": "site_company", "editor": site_company2368 }, { "colIndex": 4, "sortable": true, "header": "Default Event Type", "editable": true, "tooltip": "(system.SiteConfigs.default_event_type) The default type of events on this site.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('default_event_typeHidden','Lino.cal.EventTypes.detail'), "dataIndex": "default_event_type", "editor": default_event_type2369 }, { "colIndex": 5, "sortable": true, "header": "Site Calendar", "editable": true, "tooltip": "(system.SiteConfigs.site_calendar) The default calendar of this site.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('site_calendarHidden','Lino.cal.Calendars.detail'), "dataIndex": "site_calendar", "editor": site_calendar2370 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.SiteConfigs.max_auto_events) Maximum number of automatic events to be generated.", "filter": { "type": "numeric" }, "header": "Max automatic events", "editor": max_auto_events2371, "width": Lino.chars2width(6), "dataIndex": "max_auto_events" }), { "colIndex": 7, "sortable": true, "header": "Clients account", "editable": true, "tooltip": "(system.SiteConfigs.clients_account) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('clients_accountHidden','Lino.accounts.Accounts.detail'), "dataIndex": "clients_account", "editor": clients_account2372 }, { "colIndex": 8, "sortable": true, "header": "Sales VAT account", "editable": true, "tooltip": "(system.SiteConfigs.sales_vat_account) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('sales_vat_accountHidden','Lino.accounts.Accounts.detail'), "dataIndex": "sales_vat_account", "editor": sales_vat_account2373 }, { "colIndex": 9, "sortable": true, "header": "Sales Base account", "editable": true, "tooltip": "(system.SiteConfigs.sales_account) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('sales_accountHidden','Lino.accounts.Accounts.detail'), "dataIndex": "sales_account", "editor": sales_account2374 }, { "colIndex": 10, "sortable": true, "header": "Suppliers account", "editable": true, "tooltip": "(system.SiteConfigs.suppliers_account) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('suppliers_accountHidden','Lino.accounts.Accounts.detail'), "dataIndex": "suppliers_account", "editor": suppliers_account2375 }, { "colIndex": 11, "sortable": true, "header": "Purchases VAT account", "editable": true, "tooltip": "(system.SiteConfigs.purchases_vat_account) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('purchases_vat_accountHidden','Lino.accounts.Accounts.detail'), "dataIndex": "purchases_vat_account", "editor": purchases_vat_account2376 }, { "colIndex": 12, "sortable": true, "header": "Purchases Base account", "editable": true, "tooltip": "(system.SiteConfigs.purchases_account) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('purchases_accountHidden','Lino.accounts.Accounts.detail'), "dataIndex": "purchases_account", "editor": purchases_account2377 }, { "colIndex": 13, "sortable": true, "header": "Wages account", "editable": true, "tooltip": "(system.SiteConfigs.wages_account) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('wages_accountHidden','Lino.accounts.Accounts.detail'), "dataIndex": "wages_account", "editor": wages_account2378 }, { "colIndex": 14, "sortable": true, "header": "Clearings account", "editable": true, "tooltip": "(system.SiteConfigs.clearings_account) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('clearings_accountHidden','Lino.accounts.Accounts.detail'), "dataIndex": "clearings_account", "editor": clearings_account2379 } ];
    Lino.system.SiteConfigs.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.system.SiteConfigs.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/SiteConfigs", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.SiteConfigs.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/SiteConfigs", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.SiteConfigs.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/SiteConfigs", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.SiteConfigs.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/SiteConfigs", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.SiteConfigs.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/SiteConfigs", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.SiteConfigs.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/SiteConfigs", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.SiteConfigs.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/SiteConfigs", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.SiteConfigs.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/SiteConfigs", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.system.SiteConfigs.detailPanel = Ext.extend(Lino.system.SiteConfigs.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "do_build", "menu_item_text": "Rebuild site cache", "panel_btn_handler": Lino.row_action_handler('do_build','GET',null), "text": "Rebuild site cache", "overflowText": "Rebuild site cache", "auto_save": true } ],
  ls_url: "/system/SiteConfigs",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.SiteConfigs.detail;
    Lino.system.SiteConfigs.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.system.SiteConfigs.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.system.SiteConfigs.detailPanel(p);
});
Lino.system.SiteConfigs.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.system.SiteConfigs.GridPanel(p);
});
Lino.system.SiteConfigs.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/SiteConfigs", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.SiteConfigs.do_build = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/SiteConfigs", "GET", pk, "do_build", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class system.TextFieldTemplates
Lino.system.TextFieldTemplates.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/system/TextFieldTemplates",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/system/TextFieldTemplates','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/system/TextFieldTemplates','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/TextFieldTemplates','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/TextFieldTemplates','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/system/TextFieldTemplates','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Text Field Templates",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 5,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "name" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 5,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.system.TextFieldTemplates.detail;
    this.ls_insert_handler = Lino.system.TextFieldTemplates.insert;
    var ww = this.containing_window;
    var id2381 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user2382 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var name2383 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.TextFieldTemplates.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id2381, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Author", "editable": true, "tooltip": "(system.TextFieldTemplates.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "dataIndex": "user", "editor": user2382 }, { "colIndex": 2, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(system.TextFieldTemplates.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name2383, "dataIndex": "name" } ];
    Lino.system.TextFieldTemplates.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.system.TextFieldTemplates.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/TextFieldTemplates", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.TextFieldTemplates.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/TextFieldTemplates", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.TextFieldTemplates.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/TextFieldTemplates", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.TextFieldTemplates.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/TextFieldTemplates", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.TextFieldTemplates.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/TextFieldTemplates", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.system.TextFieldTemplates.insertPanel = Ext.extend(Lino.system.TextFieldTemplates.InsertFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/system/TextFieldTemplates",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.TextFieldTemplates.detail;
    this.ls_insert_handler = Lino.system.TextFieldTemplates.insert;
    Lino.system.TextFieldTemplates.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.system.TextFieldTemplates.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.system.TextFieldTemplates.insertPanel(p);
});
Lino.system.TextFieldTemplates.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/TextFieldTemplates", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.TextFieldTemplates.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/TextFieldTemplates", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.TextFieldTemplates.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/TextFieldTemplates", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.system.TextFieldTemplates.detailPanel = Ext.extend(Lino.system.TextFieldTemplates.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  ls_url: "/system/TextFieldTemplates",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.TextFieldTemplates.detail;
    this.ls_insert_handler = Lino.system.TextFieldTemplates.insert;
    Lino.system.TextFieldTemplates.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.system.TextFieldTemplates.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.system.TextFieldTemplates.detailPanel(p);
});
Lino.system.TextFieldTemplates.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/TextFieldTemplates", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.system.TextFieldTemplates.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.system.TextFieldTemplates.GridPanel(p);
});
Lino.system.TextFieldTemplates.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/system/TextFieldTemplates", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class users.Users
Lino.users.Users.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/Users",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/users/Users','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/users/Users','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Users','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Users','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/users/Users','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true }, { "itemId": "change_password", "menu_item_text": "Change password", "panel_btn_handler": Lino.param_action_handler(Lino.users.Users.change_password), "text": "Change password", "overflowText": "Change password", "auto_save": true } ],
  cell_edit : true,
  title : "Users",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 21,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "first_name" }, { "name": "last_name" }, { "type": "int", "name": "id" }, { "name": "modified" }, { "name": "created" }, { "name": "password" }, { "name": "initials" }, { "name": "email" }, { "name": "remarks" }, { "name": "language" }, 'languageHidden', { "name": "partner" }, 'partnerHidden', { "name": "access_class" }, 'access_classHidden', { "name": "event_type" }, 'event_typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 6,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    var ww = this.containing_window;
    var username2385 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile2386 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.users.UserProfiles) });
    var first_name2387 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var last_name2388 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var id2389 = new Ext.form.NumberField({ "selectOnFocus": true });
    var modified2390 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created2391 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var password2392 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 128 });
    var initials2393 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var email2394 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var remarks2395 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var language2396 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ] ] });
    var partner2397 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var access_class2398 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.AccessClasses });
    var event_type2399 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Event Type..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Username", "editable": true, "tooltip": "(users.Users.username) Required. Must be unique.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": username2385, "dataIndex": "username" }, { "colIndex": 1, "sortable": true, "header": "User Profile", "editable": true, "tooltip": "(users.Users.profile) Users with an empty `profile` field are considered inactive and cannot log in.", "filter": { "type": "string" }, "width": Lino.chars2width(23), "editor": profile2386, "dataIndex": "profile" }, { "colIndex": 2, "sortable": true, "header": "First name", "editable": true, "tooltip": "(users.Users.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": first_name2387, "dataIndex": "first_name" }, { "colIndex": 3, "sortable": true, "header": "Last name", "editable": true, "tooltip": "(users.Users.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": last_name2388, "dataIndex": "last_name" }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.Users.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id2389, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(users.Users.modified) ", "header": "Modified", "dataIndex": "modified", "hidden": true }, { "colIndex": 6, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(users.Users.created) ", "header": "Created", "dataIndex": "created", "hidden": true }, { "colIndex": 7, "sortable": true, "header": "Password", "editable": true, "tooltip": "(users.Users.password) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": password2392, "hidden": true, "dataIndex": "password" }, { "colIndex": 8, "sortable": true, "header": "Initials", "editable": true, "tooltip": "(users.Users.initials) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": initials2393, "hidden": true, "dataIndex": "initials" }, { "colIndex": 9, "sortable": true, "header": "e-mail address", "editable": true, "tooltip": "(users.Users.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": email2394, "hidden": true, "dataIndex": "email" }, { "colIndex": 10, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(users.Users.remarks) ", "filter": { "type": "string" }, "header": "Remarks", "editor": remarks2395, "hidden": true, "dataIndex": "remarks" }, { "colIndex": 11, "sortable": true, "header": "Language", "editable": true, "tooltip": "(users.Users.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": language2396, "hidden": true, "dataIndex": "language" }, { "colIndex": 12, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(users.Users.partner) ", "filter": { "type": "string" }, "header": "Partner", "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "dataIndex": "partner", "hidden": true, "editor": partner2397 }, { "colIndex": 13, "sortable": true, "header": "Default access class", "editable": true, "tooltip": "(users.Users.access_class) The default access class for your calendar events and tasks.", "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": access_class2398, "hidden": true, "dataIndex": "access_class" }, { "colIndex": 14, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(users.Users.event_type) The default event type for your calendar events.", "filter": { "type": "string" }, "header": "Default Event Type", "renderer": Lino.fk_renderer('event_typeHidden','Lino.cal.EventTypes.detail'), "dataIndex": "event_type", "hidden": true, "editor": event_type2399 } ];
    Lino.users.Users.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Users.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Users", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Users.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Users", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Users.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Users", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Users.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Users", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Users.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Users", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.users.Users.insertPanel = Ext.extend(Lino.users.Users.InsertFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/users/Users",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.Users.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Users.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.Users.insertPanel(p);
});
Lino.users.Users.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Users", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Users.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Users", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Users.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Users", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.users.Users.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true }, { "itemId": "change_password", "menu_item_text": "Change password", "panel_btn_handler": Lino.param_action_handler(Lino.users.Users.change_password), "text": "Change password", "overflowText": "Change password", "auto_save": true } ],
  ls_url: "/users/Users",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.Users.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Users.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.users.Users.detailPanel(p);
});
Lino.users.Users.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Users", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Users.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.users.Users.GridPanel(p);
});
Lino.users.Users.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Users", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Users.update_reminders = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Users", "GET", pk, "update_reminders", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class users.MySettings
Lino.users.MySettings.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/MySettings",
  ls_bbar_actions : [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true }, { "itemId": "change_password", "menu_item_text": "Change password", "panel_btn_handler": Lino.param_action_handler(Lino.users.Users.change_password), "text": "Change password", "overflowText": "Change password", "auto_save": true } ],
  cell_edit : true,
  title : "Users",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 21,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "first_name" }, { "name": "last_name" }, { "type": "int", "name": "id" }, { "name": "modified" }, { "name": "created" }, { "name": "password" }, { "name": "initials" }, { "name": "email" }, { "name": "remarks" }, { "name": "language" }, 'languageHidden', { "name": "partner" }, 'partnerHidden', { "name": "access_class" }, 'access_classHidden', { "name": "event_type" }, 'event_typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 6,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    var ww = this.containing_window;
    var username2401 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile2402 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.users.UserProfiles) });
    var first_name2403 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var last_name2404 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var id2405 = new Ext.form.NumberField({ "selectOnFocus": true });
    var modified2406 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created2407 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var password2408 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 128 });
    var initials2409 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var email2410 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var remarks2411 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var language2412 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ] ] });
    var partner2413 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var access_class2414 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.AccessClasses });
    var event_type2415 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Event Type..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Username", "editable": true, "tooltip": "(users.MySettings.username) Required. Must be unique.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": username2401, "dataIndex": "username" }, { "colIndex": 1, "sortable": true, "header": "User Profile", "editable": true, "tooltip": "(users.MySettings.profile) Users with an empty `profile` field are considered inactive and cannot log in.", "filter": { "type": "string" }, "width": Lino.chars2width(23), "editor": profile2402, "dataIndex": "profile" }, { "colIndex": 2, "sortable": true, "header": "First name", "editable": true, "tooltip": "(users.MySettings.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": first_name2403, "dataIndex": "first_name" }, { "colIndex": 3, "sortable": true, "header": "Last name", "editable": true, "tooltip": "(users.MySettings.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": last_name2404, "dataIndex": "last_name" }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.MySettings.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id2405, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(users.MySettings.modified) ", "header": "Modified", "dataIndex": "modified", "hidden": true }, { "colIndex": 6, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(users.MySettings.created) ", "header": "Created", "dataIndex": "created", "hidden": true }, { "colIndex": 7, "sortable": true, "header": "Password", "editable": true, "tooltip": "(users.MySettings.password) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": password2408, "hidden": true, "dataIndex": "password" }, { "colIndex": 8, "sortable": true, "header": "Initials", "editable": true, "tooltip": "(users.MySettings.initials) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": initials2409, "hidden": true, "dataIndex": "initials" }, { "colIndex": 9, "sortable": true, "header": "e-mail address", "editable": true, "tooltip": "(users.MySettings.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": email2410, "hidden": true, "dataIndex": "email" }, { "colIndex": 10, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(users.MySettings.remarks) ", "filter": { "type": "string" }, "header": "Remarks", "editor": remarks2411, "hidden": true, "dataIndex": "remarks" }, { "colIndex": 11, "sortable": true, "header": "Language", "editable": true, "tooltip": "(users.MySettings.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": language2412, "hidden": true, "dataIndex": "language" }, { "colIndex": 12, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(users.MySettings.partner) ", "filter": { "type": "string" }, "header": "Partner", "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "dataIndex": "partner", "hidden": true, "editor": partner2413 }, { "colIndex": 13, "sortable": true, "header": "Default access class", "editable": true, "tooltip": "(users.MySettings.access_class) The default access class for your calendar events and tasks.", "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": access_class2414, "hidden": true, "dataIndex": "access_class" }, { "colIndex": 14, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(users.MySettings.event_type) The default event type for your calendar events.", "filter": { "type": "string" }, "header": "Default Event Type", "renderer": Lino.fk_renderer('event_typeHidden','Lino.cal.EventTypes.detail'), "dataIndex": "event_type", "hidden": true, "editor": event_type2415 } ];
    Lino.users.MySettings.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.MySettings.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.MySettings.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.MySettings.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.MySettings.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.MySettings.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.MySettings.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.MySettings.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Users",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true }, { "itemId": "change_password", "menu_item_text": "Change password", "panel_btn_handler": Lino.param_action_handler(Lino.users.Users.change_password), "text": "Change password", "overflowText": "Change password", "auto_save": true } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});

Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Users",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true }, { "itemId": "change_password", "menu_item_text": "Change password", "panel_btn_handler": Lino.param_action_handler(Lino.users.Users.change_password), "text": "Change password", "overflowText": "Change password", "auto_save": true } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});
Lino.users.MySettings.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.MySettings.update_reminders = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/MySettings", "GET", pk, "update_reminders", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class users.UsersOverview
Lino.users.UsersOverview.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/UsersOverview",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/users/UsersOverview','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/users/UsersOverview','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/UsersOverview','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/UsersOverview','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/users/UsersOverview','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true }, { "itemId": "change_password", "menu_item_text": "Change password", "panel_btn_handler": Lino.param_action_handler(Lino.users.Users.change_password), "text": "Change password", "overflowText": "Change password", "auto_save": true } ],
  cell_edit : true,
  title : "Users",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "language" }, 'languageHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 6,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.UsersOverview.detail;
    this.ls_insert_handler = Lino.users.UsersOverview.insert;
    var ww = this.containing_window;
    var username29 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile30 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.users.UserProfiles) });
    var language31 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ] ] });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Username", "editable": true, "tooltip": "(users.UsersOverview.username) Required. Must be unique.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": username29, "dataIndex": "username" }, { "colIndex": 1, "sortable": true, "header": "User Profile", "editable": true, "tooltip": "(users.UsersOverview.profile) Users with an empty `profile` field are considered inactive and cannot log in.", "filter": { "type": "string" }, "width": Lino.chars2width(23), "editor": profile30, "dataIndex": "profile" }, { "colIndex": 2, "sortable": true, "header": "Language", "editable": true, "tooltip": "(users.UsersOverview.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": language31, "dataIndex": "language" } ];
    Lino.users.UsersOverview.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.UsersOverview.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/UsersOverview", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.UsersOverview.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/UsersOverview", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.UsersOverview.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/UsersOverview", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.UsersOverview.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/UsersOverview", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.UsersOverview.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/UsersOverview", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.users.UsersOverview.insertPanel = Ext.extend(Lino.users.Users.InsertFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/users/UsersOverview",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.UsersOverview.detail;
    this.ls_insert_handler = Lino.users.UsersOverview.insert;
    Lino.users.UsersOverview.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.users.UsersOverview.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.UsersOverview.insertPanel(p);
});
Lino.users.UsersOverview.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/UsersOverview", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.UsersOverview.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/UsersOverview", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.UsersOverview.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/UsersOverview", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.users.UsersOverview.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true }, { "itemId": "change_password", "menu_item_text": "Change password", "panel_btn_handler": Lino.param_action_handler(Lino.users.Users.change_password), "text": "Change password", "overflowText": "Change password", "auto_save": true } ],
  ls_url: "/users/UsersOverview",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.UsersOverview.detail;
    this.ls_insert_handler = Lino.users.UsersOverview.insert;
    Lino.users.UsersOverview.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.UsersOverview.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.users.UsersOverview.detailPanel(p);
});
Lino.users.UsersOverview.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/UsersOverview", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.UsersOverview.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.users.UsersOverview.GridPanel(p);
});
Lino.users.UsersOverview.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/UsersOverview", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.UsersOverview.update_reminders = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/UsersOverview", "GET", pk, "update_reminders", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class users.Authorities
Lino.users.Authorities.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/Authorities",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/users/Authorities','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/users/Authorities','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Authorities','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Authorities','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/users/Authorities','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Authorities",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "authorized" }, 'authorizedHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 7,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id2417 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user2418 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Authorities/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var authorized2419 = new Lino.RemoteComboFieldElement({ "preferred_width": 15, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Authorities/authorized", "method": "GET" }) }), "emptyText": "Select a User..." });
    this.before_row_edit = function(record) {
      authorized2419.setContextValue('user', record ? record.data['userHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      user2418.on('change',Lino.chooser_handler(authorized2419,'user'));
      Lino.users.Authorities.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.Authorities.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id2417, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Author", "editable": true, "tooltip": "(users.Authorities.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "dataIndex": "user", "editor": user2418 }, { "colIndex": 2, "sortable": true, "header": "User", "editable": true, "tooltip": "(users.Authorities.authorized) The user who gets authority to act in your name.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('authorizedHidden','Lino.users.Users.detail'), "dataIndex": "authorized", "editor": authorized2419 } ];
    Lino.users.Authorities.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Authorities.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Authorities", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Authorities.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Authorities", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Authorities.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Authorities", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Authorities.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Authorities", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Authorities.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Authorities", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Authorities.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Authorities", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Authorities.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Authorities", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Authorities.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/users/Authorities", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.users.Authorities.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.users.Authorities.GridPanel(p);
});

// js_render_GridPanel_class countries.Countries
Lino.countries.Countries.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/countries/Countries",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/countries/Countries','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/countries/Countries','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/countries/Countries','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/countries/Countries','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/countries/Countries','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Countries",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 8,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "isocode" }, { "name": "short_code" }, { "name": "iso3" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 8,
  ls_id_property : "isocode",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    var ww = this.containing_window;
    var name2421 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de2422 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr2423 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2424 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var isocode2425 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "allowBlank": false, "maxLength": 4 });
    var short_code2426 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    var iso32427 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "maxLength": 3 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(countries.Countries.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name2421, "dataIndex": "name" }, { "colIndex": 1, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(countries.Countries.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_de2422, "dataIndex": "name_de" }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(countries.Countries.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_fr2423, "dataIndex": "name_fr" }, { "colIndex": 3, "sortable": true, "header": "Designation (et)", "editable": true, "tooltip": "(countries.Countries.name_et) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_et2424, "dataIndex": "name_et" }, { "colIndex": 4, "sortable": true, "header": "ISO code", "editable": true, "tooltip": "(countries.Countries.isocode)         The two-letter code for this country as defined by ISO 3166-1.\n        For countries that no longer exist it may be a 4-letter code.", "filter": { "type": "string" }, "width": Lino.chars2width(6), "editor": isocode2425, "dataIndex": "isocode" }, { "colIndex": 5, "sortable": true, "header": "Short code", "editable": true, "tooltip": "(countries.Countries.short_code) A short abbreviation for regional usage. Obsolete.", "filter": { "type": "string" }, "width": Lino.chars2width(6), "editor": short_code2426, "hidden": true, "dataIndex": "short_code" }, { "colIndex": 6, "sortable": true, "header": "ISO-3 code", "editable": true, "tooltip": "(countries.Countries.iso3) The three-letter code for this country as defined by ISO 3166-1.", "filter": { "type": "string" }, "width": Lino.chars2width(5), "editor": iso32427, "hidden": true, "dataIndex": "iso3" } ];
    Lino.countries.Countries.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Countries.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Countries.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Countries.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Countries.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.countries.Countries.insertPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/countries/Countries",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    Lino.countries.Countries.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.insert = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Countries.insertPanel(p);
});
Lino.countries.Countries.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Countries.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Countries.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.countries.Countries.detailPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  ls_url: "/countries/Countries",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    Lino.countries.Countries.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.detailPanel(p);
});
Lino.countries.Countries.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Countries.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.GridPanel(p);
});
Lino.countries.Countries.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Countries", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class countries.Places
Lino.countries.Places.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/countries/Places",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/countries/Places','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/countries/Places','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/countries/Places','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/countries/Places','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/countries/Places','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Places",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 13,
  ls_store_fields : [ { "name": "country" }, 'countryHidden', { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "type" }, 'typeHidden', { "name": "zip_code" }, { "name": "parent" }, 'parentHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 11,
  ls_grid_configs : [  ],
  content_type : 9,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Places.detail;
    this.ls_insert_handler = Lino.countries.Places.insert;
    var ww = this.containing_window;
    var country2429 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Places/country", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Country..." });
    var name2430 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de2431 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr2432 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2433 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type2434 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Places/type", "method": "GET" }) }) });
    var zip_code2435 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "maxLength": 8 });
    var parent2436 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Places/parent", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var id2437 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      type2434.setContextValue('country', record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country2429.on('change',Lino.chooser_handler(type2434,'country'));
      Lino.countries.Places.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Country", "editable": true, "tooltip": "(countries.Places.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "dataIndex": "country", "editor": country2429 }, { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(countries.Places.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name2430, "dataIndex": "name" }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(countries.Places.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_de2431, "dataIndex": "name_de" }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(countries.Places.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_fr2432, "dataIndex": "name_fr" }, { "colIndex": 4, "sortable": true, "header": "Designation (et)", "editable": true, "tooltip": "(countries.Places.name_et) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_et2433, "dataIndex": "name_et" }, { "colIndex": 5, "sortable": true, "header": "Place Type", "editable": true, "tooltip": "(countries.Places.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": type2434, "dataIndex": "type" }, { "colIndex": 6, "sortable": true, "header": "zip code", "editable": true, "tooltip": "(countries.Places.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(10), "editor": zip_code2435, "dataIndex": "zip_code" }, { "colIndex": 7, "sortable": true, "header": "Part of", "editable": true, "tooltip": "(countries.Places.parent) The superordinate geographic place         of which this place is a part.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('parentHidden','Lino.countries.Places.detail'), "dataIndex": "parent", "editor": parent2436 }, new Lino.NullNumberColumn({ "colIndex": 8, "sortable": true, "format": "0", "editable": true, "tooltip": "(countries.Places.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id2437, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.countries.Places.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Places.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Places", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Places.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Places", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Places.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Places", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Places.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Places", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Places.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Places", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.countries.Places.insertPanel = Ext.extend(Lino.countries.Places.DetailFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/countries/Places",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Places.detail;
    this.ls_insert_handler = Lino.countries.Places.insert;
    Lino.countries.Places.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Places.insert = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Places.insertPanel(p);
});
Lino.countries.Places.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Places", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Places.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Places", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Places.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Places", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.countries.Places.detailPanel = Ext.extend(Lino.countries.Places.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  ls_url: "/countries/Places",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Places.detail;
    this.ls_insert_handler = Lino.countries.Places.insert;
    Lino.countries.Places.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Places.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Places.detailPanel(p);
});
Lino.countries.Places.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Places", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.countries.Places.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Places.GridPanel(p);
});
Lino.countries.Places.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/countries/Places", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class properties.PropGroups
Lino.properties.PropGroups.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/properties/PropGroups",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/properties/PropGroups','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/properties/PropGroups','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/properties/PropGroups','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/properties/PropGroups','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/properties/PropGroups','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Property Groups",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 11,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropGroups.detail;
    this.ls_insert_handler = Lino.properties.PropGroups.insert;
    var ww = this.containing_window;
    var id2439 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2440 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de2441 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr2442 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2443 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(properties.PropGroups.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id2439, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(properties.PropGroups.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name2440, "dataIndex": "name" }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(properties.PropGroups.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_de2441, "dataIndex": "name_de" }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(properties.PropGroups.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_fr2442, "dataIndex": "name_fr" }, { "colIndex": 4, "sortable": true, "header": "Designation (et)", "editable": true, "tooltip": "(properties.PropGroups.name_et) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_et2443, "dataIndex": "name_et" } ];
    Lino.properties.PropGroups.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropGroups.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropGroups", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.PropGroups.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropGroups", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.PropGroups.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropGroups", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.PropGroups.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropGroups", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.PropGroups.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropGroups", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.properties.PropGroups.insertPanel = Ext.extend(Lino.properties.PropGroups.DetailFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/properties/PropGroups",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropGroups.detail;
    this.ls_insert_handler = Lino.properties.PropGroups.insert;
    Lino.properties.PropGroups.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropGroups.insert = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.properties.PropGroups.insertPanel(p);
});
Lino.properties.PropGroups.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropGroups", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.PropGroups.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropGroups", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.PropGroups.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropGroups", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.properties.PropGroups.detailPanel = Ext.extend(Lino.properties.PropGroups.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  ls_url: "/properties/PropGroups",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropGroups.detail;
    this.ls_insert_handler = Lino.properties.PropGroups.insert;
    Lino.properties.PropGroups.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropGroups.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropGroups.detailPanel(p);
});
Lino.properties.PropGroups.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropGroups", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.PropGroups.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropGroups.GridPanel(p);
});
Lino.properties.PropGroups.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropGroups", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class properties.PropTypes
Lino.properties.PropTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/properties/PropTypes",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/properties/PropTypes','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/properties/PropTypes','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/properties/PropTypes','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/properties/PropTypes','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/properties/PropTypes','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Property Types",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 12,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "choicelist" }, 'choicelistHidden', { "name": "default_value" }, 'default_valueHidden', { "type": "boolean", "name": "limit_to_choices" }, { "type": "boolean", "name": "multiple_choices" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 12,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropTypes.detail;
    this.ls_insert_handler = Lino.properties.PropTypes.insert;
    var ww = this.containing_window;
    var id2445 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2446 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de2447 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr2448 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2449 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var choicelist2450 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "countries.PlaceTypes", "PlaceTypes" ], [ "lino.BuildMethods", "BuildMethods" ], [ "properties.DoYouLike", "DoYouLike" ], [ "properties.HowWell", "HowWell" ], [ "system.Genders", "Genders" ], [ "system.PeriodEvents", "Observed events" ], [ "system.YesNo", "Yes or no" ], [ "users.UserGroups", "User Groups" ], [ "users.UserLevels", "User Levels" ], [ "users.UserProfiles", "User Profiles" ] ] });
    var default_value2451 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropTypes/default_value", "method": "GET" }) }) });
    var limit_to_choices2452 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var multiple_choices2453 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
      default_value2451.setContextValue('choicelist', record ? record.data['choicelistHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      choicelist2450.on('change',Lino.chooser_handler(default_value2451,'choicelist'));
      Lino.properties.PropTypes.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(properties.PropTypes.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id2445, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(properties.PropTypes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name2446, "dataIndex": "name" }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(properties.PropTypes.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_de2447, "dataIndex": "name_de" }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(properties.PropTypes.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_fr2448, "dataIndex": "name_fr" }, { "colIndex": 4, "sortable": true, "header": "Designation (et)", "editable": true, "tooltip": "(properties.PropTypes.name_et) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_et2449, "dataIndex": "name_et" }, { "colIndex": 5, "sortable": true, "header": "Choices List", "editable": true, "tooltip": "(properties.PropTypes.choicelist) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": choicelist2450, "dataIndex": "choicelist" }, { "colIndex": 6, "sortable": true, "header": "default value", "editable": true, "tooltip": "(properties.PropTypes.default_value) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": default_value2451, "dataIndex": "default_value" }, { "colIndex": 7, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(properties.PropTypes.limit_to_choices) ", "filter": { "type": "boolean" }, "header": "Limit to choices", "dataIndex": "limit_to_choices" }, { "colIndex": 8, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(properties.PropTypes.multiple_choices) ", "filter": { "type": "boolean" }, "header": "Multiple choices", "dataIndex": "multiple_choices" } ];
    Lino.properties.PropTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropTypes.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropTypes", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.PropTypes.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropTypes", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.PropTypes.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropTypes", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.PropTypes.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropTypes", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.PropTypes.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropTypes", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.properties.PropTypes.insertPanel = Ext.extend(Lino.properties.PropTypes.DetailFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/properties/PropTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropTypes.detail;
    this.ls_insert_handler = Lino.properties.PropTypes.insert;
    Lino.properties.PropTypes.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropTypes.insert = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.properties.PropTypes.insertPanel(p);
});
Lino.properties.PropTypes.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropTypes", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.PropTypes.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropTypes", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.PropTypes.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropTypes", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.properties.PropTypes.detailPanel = Ext.extend(Lino.properties.PropTypes.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  ls_url: "/properties/PropTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropTypes.detail;
    this.ls_insert_handler = Lino.properties.PropTypes.insert;
    Lino.properties.PropTypes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropTypes.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropTypes.detailPanel(p);
});
Lino.properties.PropTypes.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropTypes", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.PropTypes.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropTypes.GridPanel(p);
});
Lino.properties.PropTypes.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropTypes", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class properties.Properties
Lino.properties.Properties.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/properties/Properties",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/properties/Properties','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/properties/Properties','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/properties/Properties','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/properties/Properties','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/properties/Properties','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Properties",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 10,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "group" }, 'groupHidden', { "name": "type" }, 'typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 10,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id2455 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2456 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de2457 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr2458 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2459 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var group2460 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/Properties/group", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Property Group..." });
    var type2461 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/Properties/type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Property Type..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(properties.Properties.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id2455, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(properties.Properties.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name2456, "dataIndex": "name" }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(properties.Properties.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_de2457, "dataIndex": "name_de" }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(properties.Properties.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_fr2458, "dataIndex": "name_fr" }, { "colIndex": 4, "sortable": true, "header": "Designation (et)", "editable": true, "tooltip": "(properties.Properties.name_et) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_et2459, "dataIndex": "name_et" }, { "colIndex": 5, "sortable": true, "header": "Property Group", "editable": true, "tooltip": "(properties.Properties.group) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('groupHidden','Lino.properties.PropGroups.detail'), "dataIndex": "group", "editor": group2460 }, { "colIndex": 6, "sortable": true, "header": "Property Type", "editable": true, "tooltip": "(properties.Properties.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('typeHidden','Lino.properties.PropTypes.detail'), "dataIndex": "type", "editor": type2461 } ];
    Lino.properties.Properties.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.Properties.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/Properties", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.Properties.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/Properties", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.Properties.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/Properties", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.Properties.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/Properties", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.Properties.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/Properties", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.Properties.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/Properties", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.Properties.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/Properties", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.Properties.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/Properties", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.Properties.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.properties.Properties.GridPanel(p);
});

// js_render_GridPanel_class properties.PropChoices
Lino.properties.PropChoices.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/properties/PropChoices",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/properties/PropChoices','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/properties/PropChoices','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/properties/PropChoices','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/properties/PropChoices','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/properties/PropChoices','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Property Choices",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 9,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "type" }, 'typeHidden', { "name": "value" }, { "name": "text" }, { "name": "text_de" }, { "name": "text_fr" }, { "name": "text_et" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 13,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id2463 = new Ext.form.NumberField({ "selectOnFocus": true });
    var type2464 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropChoices/type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Property Type..." });
    var value2465 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var text2466 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_de2467 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_fr2468 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_et2469 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(properties.PropChoices.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id2463, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Property Type", "editable": true, "tooltip": "(properties.PropChoices.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('typeHidden','Lino.properties.PropTypes.detail'), "dataIndex": "type", "editor": type2464 }, { "colIndex": 2, "sortable": true, "header": "Value", "editable": true, "tooltip": "(properties.PropChoices.value) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": value2465, "dataIndex": "value" }, { "colIndex": 3, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(properties.PropChoices.text) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": text2466, "dataIndex": "text" }, { "colIndex": 4, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(properties.PropChoices.text_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": text_de2467, "dataIndex": "text_de" }, { "colIndex": 5, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(properties.PropChoices.text_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": text_fr2468, "dataIndex": "text_fr" }, { "colIndex": 6, "sortable": true, "header": "Designation (et)", "editable": true, "tooltip": "(properties.PropChoices.text_et) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": text_et2469, "dataIndex": "text_et" } ];
    Lino.properties.PropChoices.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropChoices.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropChoices", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.PropChoices.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropChoices", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.PropChoices.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropChoices", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.PropChoices.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropChoices", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.PropChoices.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropChoices", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.PropChoices.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropChoices", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.PropChoices.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropChoices", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.PropChoices.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/properties/PropChoices", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.properties.PropChoices.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropChoices.GridPanel(p);
});

// js_render_GridPanel_class contacts.CompanyTypes
Lino.contacts.CompanyTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/CompanyTypes",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/contacts/CompanyTypes','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/contacts/CompanyTypes','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/CompanyTypes','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/CompanyTypes','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/contacts/CompanyTypes','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Organization types",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 10,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "name_et" }, { "type": "int", "name": "id" }, { "name": "abbr" }, { "name": "abbr_de" }, { "name": "abbr_fr" }, { "name": "abbr_et" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 19,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var name2471 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de2472 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr2473 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2474 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id2475 = new Ext.form.NumberField({ "selectOnFocus": true });
    var abbr2476 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var abbr_de2477 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var abbr_fr2478 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var abbr_et2479 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(contacts.CompanyTypes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name2471, "dataIndex": "name" }, { "colIndex": 1, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(contacts.CompanyTypes.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_de2472, "dataIndex": "name_de" }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(contacts.CompanyTypes.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_fr2473, "dataIndex": "name_fr" }, { "colIndex": 3, "sortable": true, "header": "Designation (et)", "editable": true, "tooltip": "(contacts.CompanyTypes.name_et) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_et2474, "dataIndex": "name_et" }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.CompanyTypes.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id2475, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Abbreviation", "editable": true, "tooltip": "(contacts.CompanyTypes.abbr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": abbr2476, "hidden": true, "dataIndex": "abbr" }, { "colIndex": 6, "sortable": true, "header": "Abbreviation (de)", "editable": true, "tooltip": "(contacts.CompanyTypes.abbr_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": abbr_de2477, "hidden": true, "dataIndex": "abbr_de" }, { "colIndex": 7, "sortable": true, "header": "Abbreviation (fr)", "editable": true, "tooltip": "(contacts.CompanyTypes.abbr_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": abbr_fr2478, "hidden": true, "dataIndex": "abbr_fr" }, { "colIndex": 8, "sortable": true, "header": "Abbreviation (et)", "editable": true, "tooltip": "(contacts.CompanyTypes.abbr_et) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": abbr_et2479, "hidden": true, "dataIndex": "abbr_et" } ];
    Lino.contacts.CompanyTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.CompanyTypes.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/CompanyTypes", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.CompanyTypes.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/CompanyTypes", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.CompanyTypes.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/CompanyTypes", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.CompanyTypes.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/CompanyTypes", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.CompanyTypes.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/CompanyTypes", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.CompanyTypes.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/CompanyTypes", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.CompanyTypes.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/CompanyTypes", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.CompanyTypes.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/CompanyTypes", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.CompanyTypes.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.CompanyTypes.GridPanel(p);
});

// js_render_GridPanel_class contacts.Partners
Lino.contacts.Partners.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Partners",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/contacts/Partners','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/contacts/Partners','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/Partners','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/Partners','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true }, { "itemId": "print_labels", "menu_item_text": "Labels", "tooltip": "Generate mailing labels for these recipients", "panel_btn_handler": Lino.list_action_handler('/contacts/Partners','print_labels','GET',Lino.get_current_grid_config), "text": "Labels", "overflowText": "Labels", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/contacts/Partners','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "create_invoice", "menu_item_text": "Create invoice", "tooltip": "Create invoice from invoiceables for this partner", "panel_btn_handler": Lino.row_action_handler('create_invoice','GET',null), "iconCls": "x-tbar-money", "overflowText": "Create invoice", "auto_save": true }, { "itemId": "due", "menu_item_text": "Debts", "tooltip": "Debts", "panel_btn_handler": Lino.row_action_handler('due','GET',null), "iconCls": "x-tbar-book_link", "overflowText": "Debts", "auto_save": true }, { "itemId": "show_invoiceables", "menu_item_text": "Invoices to create", "tooltip": "List of invoiceable items for this partner", "panel_btn_handler": Lino.row_action_handler('show_invoiceables','GET',null), "iconCls": "x-tbar-basket", "overflowText": "Invoices to create", "auto_save": true } ],
  cell_edit : true,
  title : "Partners",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 35,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "modified" }, { "name": "created" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "zip_code" }, { "name": "region" }, 'regionHidden', { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "name": "isikukood" }, { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "payment_term" }, 'payment_termHidden', { "name": "iban" }, { "name": "bic" }, { "name": "invoice_recipient" }, 'invoice_recipientHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 33,
  ls_grid_configs : [  ],
  content_type : 18,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    var ww = this.containing_window;
    var name2481 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email2482 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var modified2483 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created2484 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country2485 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Country..." });
    var city2486 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var zip_code2487 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var region2488 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var addr12489 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix2490 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street2491 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no2492 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box2493 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr22494 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language2495 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ] ] });
    var url2496 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone2497 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm2498 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax2499 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks2500 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var isikukood2501 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var vat_regime2502 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var payment_term2503 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Payment Term..." });
    var iban2504 = new Lino.UppercaseTextField({ "selectOnFocus": true, "maxLength": 34 });
    var bic2505 = new Lino.UppercaseTextField({ "selectOnFocus": true, "maxLength": 11 });
    var invoice_recipient2506 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/invoice_recipient", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var id2507 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city2486.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city2486.setContextValue('region', record ? record.data['regionHidden'] : undefined);
      region2488.setContextValue('country', record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country2485.on('change',Lino.chooser_handler(city2486,'country'));
      region2488.on('change',Lino.chooser_handler(city2486,'region'));
      country2485.on('change',Lino.chooser_handler(region2488,'country'));
      Lino.contacts.Partners.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.Partners.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name2481, "dataIndex": "name" }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.Partners.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": email2482, "dataIndex": "email" }, { "colIndex": 2, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(contacts.Partners.modified) ", "header": "Modified", "dataIndex": "modified", "hidden": true }, { "colIndex": 3, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(contacts.Partners.created) ", "header": "Created", "dataIndex": "created", "hidden": true }, { "colIndex": 4, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Partners.country) ", "filter": { "type": "string" }, "header": "Country", "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "dataIndex": "country", "hidden": true, "editor": country2485 }, { "colIndex": 5, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Partners.city) ", "filter": { "type": "string" }, "header": "City", "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Places.detail'), "dataIndex": "city", "hidden": true, "editor": city2486 }, { "colIndex": 6, "sortable": true, "header": "Zip code", "editable": true, "tooltip": "(contacts.Partners.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": zip_code2487, "hidden": true, "dataIndex": "zip_code" }, { "colIndex": 7, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Partners.region) ", "filter": { "type": "string" }, "header": "County", "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Places.detail'), "dataIndex": "region", "hidden": true, "editor": region2488 }, { "colIndex": 8, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "(contacts.Partners.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": addr12489, "hidden": true, "dataIndex": "addr1" }, { "colIndex": 9, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "(contacts.Partners.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": street_prefix2490, "hidden": true, "dataIndex": "street_prefix" }, { "colIndex": 10, "sortable": true, "header": "Street", "editable": true, "tooltip": "(contacts.Partners.street) Name of street, without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": street2491, "hidden": true, "dataIndex": "street" }, { "colIndex": 11, "sortable": true, "header": "No.", "editable": true, "tooltip": "(contacts.Partners.street_no) House number.", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": street_no2492, "hidden": true, "dataIndex": "street_no" }, { "colIndex": 12, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.Partners.street_box) Text to print after street nuber on the same line.", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": street_box2493, "hidden": true, "dataIndex": "street_box" }, { "colIndex": 13, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "(contacts.Partners.addr2) Address line to print below street line.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": addr22494, "hidden": true, "dataIndex": "addr2" }, { "colIndex": 14, "sortable": true, "header": "Language", "editable": true, "tooltip": "(contacts.Partners.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": language2495, "hidden": true, "dataIndex": "language" }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.Partners.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": url2496, "hidden": true, "dataIndex": "url" }, { "colIndex": 16, "sortable": true, "header": "Phone", "editable": true, "tooltip": "(contacts.Partners.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": phone2497, "hidden": true, "dataIndex": "phone" }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.Partners.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": gsm2498, "hidden": true, "dataIndex": "gsm" }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.Partners.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": fax2499, "hidden": true, "dataIndex": "fax" }, { "colIndex": 19, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(contacts.Partners.remarks) ", "filter": { "type": "string" }, "header": "Remarks", "editor": remarks2500, "hidden": true, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": true, "header": "isikukood", "editable": true, "tooltip": "(contacts.Partners.isikukood) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": isikukood2501, "hidden": true, "dataIndex": "isikukood" }, { "colIndex": 21, "sortable": true, "header": "VAT Regime", "editable": true, "tooltip": "(contacts.Partners.vat_regime) The default VAT regime for         sales and purchases of this partner.", "filter": { "type": "string" }, "width": Lino.chars2width(19), "editor": vat_regime2502, "hidden": true, "dataIndex": "vat_regime" }, { "colIndex": 22, "sortable": true, "header": "Payment Term", "editable": true, "tooltip": "(contacts.Partners.payment_term) The default payment term for sales invoices to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": payment_term2503, "hidden": true, "dataIndex": "payment_term" }, { "colIndex": 23, "sortable": true, "width": Lino.chars2width(22), "editable": true, "tooltip": "(contacts.Partners.iban) ", "filter": { "type": "string" }, "header": "IBAN", "renderer": Lino.iban_renderer, "hidden": true, "editor": iban2504, "dataIndex": "iban" }, { "colIndex": 24, "sortable": true, "header": "BIC", "editable": true, "tooltip": "(contacts.Partners.bic) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": bic2505, "hidden": true, "dataIndex": "bic" }, { "colIndex": 25, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Partners.invoice_recipient) ", "filter": { "type": "string" }, "header": "Invoicing address", "renderer": Lino.fk_renderer('invoice_recipientHidden','Lino.contacts.Partners.detail'), "dataIndex": "invoice_recipient", "hidden": true, "editor": invoice_recipient2506 }, new Lino.NullNumberColumn({ "colIndex": 26, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.Partners.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id2507, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.Partners.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Partners.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Partners.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Partners.print_labels = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "print_labels", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Partners.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Partners.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.contacts.Partners.insertPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/contacts/Partners",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    Lino.contacts.Partners.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Partners.insertPanel(p);
});
Lino.contacts.Partners.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Partners.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Partners.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.contacts.Partners.detailPanel = Ext.extend(Lino.contacts.Partners.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "create_invoice", "menu_item_text": "Create invoice", "tooltip": "Create invoice from invoiceables for this partner", "panel_btn_handler": Lino.row_action_handler('create_invoice','GET',null), "iconCls": "x-tbar-money", "overflowText": "Create invoice", "auto_save": true }, { "itemId": "due", "menu_item_text": "Debts", "tooltip": "Debts", "panel_btn_handler": Lino.row_action_handler('due','GET',null), "iconCls": "x-tbar-book_link", "overflowText": "Debts", "auto_save": true }, { "itemId": "show_invoiceables", "menu_item_text": "Invoices to create", "tooltip": "List of invoiceable items for this partner", "panel_btn_handler": Lino.row_action_handler('show_invoiceables','GET',null), "iconCls": "x-tbar-basket", "overflowText": "Invoices to create", "auto_save": true } ],
  ls_url: "/contacts/Partners",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    Lino.contacts.Partners.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Partners.detailPanel(p);
});
Lino.contacts.Partners.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Partners.create_invoice = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "create_invoice", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Partners.due = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "due", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Partners.show_invoiceables = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "show_invoiceables", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Partners.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Partners.GridPanel(p);
});
Lino.contacts.Partners.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Partners", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class contacts.RoleTypes
Lino.contacts.RoleTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/RoleTypes",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/contacts/RoleTypes','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/contacts/RoleTypes','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/RoleTypes','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/RoleTypes','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/contacts/RoleTypes','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Functions",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 14,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id2509 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2510 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de2511 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr2512 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2513 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.RoleTypes.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id2509, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(contacts.RoleTypes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name2510, "dataIndex": "name" }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(contacts.RoleTypes.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_de2511, "dataIndex": "name_de" }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(contacts.RoleTypes.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_fr2512, "dataIndex": "name_fr" }, { "colIndex": 4, "sortable": true, "header": "Designation (et)", "editable": true, "tooltip": "(contacts.RoleTypes.name_et) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_et2513, "dataIndex": "name_et" } ];
    Lino.contacts.RoleTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.RoleTypes.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/RoleTypes", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.RoleTypes.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/RoleTypes", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.RoleTypes.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/RoleTypes", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.RoleTypes.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/RoleTypes", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.RoleTypes.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/RoleTypes", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.RoleTypes.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/RoleTypes", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.RoleTypes.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/RoleTypes", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.RoleTypes.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/RoleTypes", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.RoleTypes.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.RoleTypes.GridPanel(p);
});

// js_render_GridPanel_class contacts.Roles
Lino.contacts.Roles.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Roles",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/contacts/Roles','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/contacts/Roles','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/Roles','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/Roles','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/contacts/Roles','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Contact Persons",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 8,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "type" }, 'typeHidden', { "name": "person" }, 'personHidden', { "name": "company" }, 'companyHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 17,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id2515 = new Ext.form.NumberField({ "selectOnFocus": true });
    var type2516 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Roles/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Function..." });
    var person2517 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Roles/person", "method": "GET" }) }), "emptyText": "Select a Person..." });
    var company2518 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Roles/company", "method": "GET" }) }), "emptyText": "Select a Organization..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.Roles.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id2515, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Contact Role", "editable": true, "tooltip": "(contacts.Roles.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": type2516, "dataIndex": "type" }, { "colIndex": 2, "sortable": true, "header": "Person", "editable": true, "tooltip": "(contacts.Roles.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('personHidden','Lino.contacts.Persons.detail'), "dataIndex": "person", "editor": person2517 }, { "colIndex": 3, "sortable": true, "header": "Organization", "editable": true, "tooltip": "(contacts.Roles.company) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('companyHidden','Lino.contacts.Companies.detail'), "dataIndex": "company", "editor": company2518 } ];
    Lino.contacts.Roles.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Roles.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Roles", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Roles.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Roles", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Roles.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Roles", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Roles.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Roles", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Roles.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Roles", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Roles.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Roles", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Roles.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Roles", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Roles.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Roles", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Roles.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Roles.GridPanel(p);
});

// js_render_GridPanel_class addresses.Addresses
Lino.addresses.Addresses.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/addresses/Addresses",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/addresses/Addresses','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/addresses/Addresses','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/addresses/Addresses','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/addresses/Addresses','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/addresses/Addresses','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Addresses",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 24,
  ls_store_fields : [ { "name": "partner" }, 'partnerHidden', { "name": "address_type" }, 'address_typeHidden', { "name": "remark" }, { "name": "address_column" }, { "type": "boolean", "name": "primary" }, { "name": "data_source" }, 'data_sourceHidden', { "type": "int", "name": "id" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "zip_code" }, { "name": "region" }, 'regionHidden', { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 9,
  ls_grid_configs : [  ],
  content_type : 26,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.addresses.Addresses.detail;
    this.ls_insert_handler = Lino.addresses.Addresses.insert;
    var ww = this.containing_window;
    var partner2520 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/addresses/Addresses/partner", "method": "GET" }) }), "emptyText": "Select a Partner..." });
    var address_type2521 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.addresses.AddressTypes) });
    var remark2522 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 50 });
    var address_column_disp2523 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var primary2524 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var data_source2525 = new Lino.ChoicesFieldElement({ "disabled": true, "forceSelection": true, "store": Lino.addresses.DataSources });
    var id2526 = new Ext.form.NumberField({ "selectOnFocus": true });
    var country2527 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/addresses/Addresses/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Country..." });
    var city2528 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/addresses/Addresses/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var zip_code2529 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var region2530 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/addresses/Addresses/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var addr12531 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix2532 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street2533 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no2534 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box2535 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr22536 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
      city2528.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city2528.setContextValue('region', record ? record.data['regionHidden'] : undefined);
      region2530.setContextValue('country', record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country2527.on('change',Lino.chooser_handler(city2528,'country'));
      region2530.on('change',Lino.chooser_handler(city2528,'region'));
      country2527.on('change',Lino.chooser_handler(region2530,'country'));
      Lino.addresses.Addresses.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(addresses.Addresses.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "dataIndex": "partner", "editor": partner2520 }, { "colIndex": 1, "sortable": true, "header": "Address type", "editable": true, "tooltip": "(addresses.Addresses.address_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": address_type2521, "dataIndex": "address_type" }, { "colIndex": 2, "sortable": true, "header": "Remark", "editable": true, "tooltip": "(addresses.Addresses.remark) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": remark2522, "dataIndex": "remark" }, { "header": "Address", "colIndex": 3, "sortable": false, "dataIndex": "address_column", "width": Lino.chars2width(31), "editable": false, "tooltip": "(addresses.Addresses.address_column) " }, { "colIndex": 4, "sortable": false, "xtype": "checkcolumn", "width": Lino.chars2width(11), "editable": true, "tooltip": "(addresses.Addresses.primary) Checking this field will automatically uncheck any previous primary addresses and update the partner's address data fields.", "filter": { "type": "boolean" }, "header": "Primary", "dataIndex": "primary" }, { "colIndex": 5, "sortable": true, "width": Lino.chars2width(20), "editable": false, "tooltip": "(addresses.Addresses.data_source) ", "filter": { "type": "string" }, "header": "Data source", "dataIndex": "data_source" }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(addresses.Addresses.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id2526, "hidden": true, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 7, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(addresses.Addresses.country) ", "filter": { "type": "string" }, "header": "Country", "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "dataIndex": "country", "hidden": true, "editor": country2527 }, { "colIndex": 8, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(addresses.Addresses.city) ", "filter": { "type": "string" }, "header": "City", "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Places.detail'), "dataIndex": "city", "hidden": true, "editor": city2528 }, { "colIndex": 9, "sortable": true, "header": "Zip code", "editable": true, "tooltip": "(addresses.Addresses.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": zip_code2529, "hidden": true, "dataIndex": "zip_code" }, { "colIndex": 10, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(addresses.Addresses.region) ", "filter": { "type": "string" }, "header": "County", "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Places.detail'), "dataIndex": "region", "hidden": true, "editor": region2530 }, { "colIndex": 11, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "(addresses.Addresses.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": addr12531, "hidden": true, "dataIndex": "addr1" }, { "colIndex": 12, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "(addresses.Addresses.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": street_prefix2532, "hidden": true, "dataIndex": "street_prefix" }, { "colIndex": 13, "sortable": true, "header": "Street", "editable": true, "tooltip": "(addresses.Addresses.street) Name of street, without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": street2533, "hidden": true, "dataIndex": "street" }, { "colIndex": 14, "sortable": true, "header": "No.", "editable": true, "tooltip": "(addresses.Addresses.street_no) House number.", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": street_no2534, "hidden": true, "dataIndex": "street_no" }, { "colIndex": 15, "sortable": true, "header": "Box", "editable": true, "tooltip": "(addresses.Addresses.street_box) Text to print after street nuber on the same line.", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": street_box2535, "hidden": true, "dataIndex": "street_box" }, { "colIndex": 16, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "(addresses.Addresses.addr2) Address line to print below street line.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": addr22536, "hidden": true, "dataIndex": "addr2" } ];
    Lino.addresses.Addresses.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.addresses.Addresses.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/addresses/Addresses", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.addresses.Addresses.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/addresses/Addresses", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.addresses.Addresses.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/addresses/Addresses", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.addresses.Addresses.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/addresses/Addresses", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.addresses.Addresses.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/addresses/Addresses", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.addresses.Addresses.insertPanel = Ext.extend(Lino.addresses.Addresses.InsertFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/addresses/Addresses",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.addresses.Addresses.detail;
    this.ls_insert_handler = Lino.addresses.Addresses.insert;
    Lino.addresses.Addresses.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.addresses.Addresses.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.addresses.Addresses.insertPanel(p);
});
Lino.addresses.Addresses.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/addresses/Addresses", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.addresses.Addresses.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/addresses/Addresses", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.addresses.Addresses.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/addresses/Addresses", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.addresses.Addresses.detailPanel = Ext.extend(Lino.addresses.Addresses.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  ls_url: "/addresses/Addresses",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.addresses.Addresses.detail;
    this.ls_insert_handler = Lino.addresses.Addresses.insert;
    Lino.addresses.Addresses.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.addresses.Addresses.detail = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true };
  return new Lino.addresses.Addresses.detailPanel(p);
});
Lino.addresses.Addresses.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/addresses/Addresses", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.addresses.Addresses.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.addresses.Addresses.GridPanel(p);
});
Lino.addresses.Addresses.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/addresses/Addresses", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class contacts.Persons
Lino.contacts.Persons.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Persons",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/contacts/Persons','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/contacts/Persons','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/Persons','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/Persons','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true }, { "itemId": "print_labels", "menu_item_text": "Labels", "tooltip": "Generate mailing labels for these recipients", "panel_btn_handler": Lino.list_action_handler('/contacts/Persons','print_labels','GET',Lino.get_current_grid_config), "text": "Labels", "overflowText": "Labels", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/contacts/Persons','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "create_invoice", "menu_item_text": "Create invoice", "tooltip": "Create invoice from invoiceables for this partner", "panel_btn_handler": Lino.row_action_handler('create_invoice','GET',null), "iconCls": "x-tbar-money", "overflowText": "Create invoice", "auto_save": true }, { "itemId": "due", "menu_item_text": "Debts", "tooltip": "Debts", "panel_btn_handler": Lino.row_action_handler('due','GET',null), "iconCls": "x-tbar-book_link", "overflowText": "Debts", "auto_save": true }, { "itemId": "show_invoiceables", "menu_item_text": "Invoices to create", "tooltip": "List of invoiceable items for this partner", "panel_btn_handler": Lino.row_action_handler('show_invoiceables','GET',null), "iconCls": "x-tbar-basket", "overflowText": "Invoices to create", "auto_save": true } ],
  cell_edit : true,
  title : "Persons",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 44,
  ls_store_fields : [ { "name": "name_column" }, { "name": "address_column" }, { "name": "email" }, { "name": "phone" }, { "name": "gsm" }, { "type": "int", "name": "id" }, { "name": "language" }, 'languageHidden', { "name": "modified" }, { "name": "created" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "zip_code" }, { "name": "region" }, 'regionHidden', { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "name" }, { "name": "url" }, { "name": "fax" }, { "name": "remarks" }, { "name": "isikukood" }, { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "payment_term" }, 'payment_termHidden', { "name": "iban" }, { "name": "bic" }, { "name": "invoice_recipient" }, 'invoice_recipientHidden', { "name": "first_name" }, { "name": "middle_name" }, { "name": "last_name" }, { "name": "gender" }, 'genderHidden', { "name": "birth_date" }, { "name": "title" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 18,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    var ww = this.containing_window;
    var name_column_disp2538 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var address_column_disp2539 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var email2540 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone2541 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm2542 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id2543 = new Ext.form.NumberField({ "selectOnFocus": true });
    var language2544 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ] ] });
    var modified2545 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created2546 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country2547 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Country..." });
    var city2548 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var zip_code2549 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var region2550 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var addr12551 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix2552 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street2553 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no2554 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box2555 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr22556 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name2557 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var url2558 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var fax2559 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks2560 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var isikukood2561 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var vat_regime2562 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var payment_term2563 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Payment Term..." });
    var iban2564 = new Lino.UppercaseTextField({ "selectOnFocus": true, "maxLength": 34 });
    var bic2565 = new Lino.UppercaseTextField({ "selectOnFocus": true, "maxLength": 11 });
    var invoice_recipient2566 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/invoice_recipient", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var first_name2567 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var middle_name2568 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var last_name2569 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var gender2570 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.system.Genders) });
    var birth_date2571 = new Lino.IncompleteDateField({ "selectOnFocus": true });
    var title2572 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
      city2548.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city2548.setContextValue('region', record ? record.data['regionHidden'] : undefined);
      region2550.setContextValue('country', record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country2547.on('change',Lino.chooser_handler(city2548,'country'));
      region2550.on('change',Lino.chooser_handler(city2548,'region'));
      country2547.on('change',Lino.chooser_handler(region2550,'country'));
      Lino.contacts.Persons.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "header": "Name", "colIndex": 0, "sortable": false, "dataIndex": "name_column", "width": Lino.chars2width(21), "editable": false, "tooltip": "(contacts.Persons.name_column) " }, { "header": "Address", "colIndex": 1, "sortable": false, "dataIndex": "address_column", "width": Lino.chars2width(31), "editable": false, "tooltip": "(contacts.Persons.address_column) " }, { "colIndex": 2, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.Persons.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": email2540, "dataIndex": "email" }, { "colIndex": 3, "sortable": true, "header": "Phone", "editable": true, "tooltip": "(contacts.Persons.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": phone2541, "dataIndex": "phone" }, { "colIndex": 4, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.Persons.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": gsm2542, "dataIndex": "gsm" }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.Persons.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id2543, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Language", "editable": true, "tooltip": "(contacts.Persons.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": language2544, "dataIndex": "language" }, { "colIndex": 7, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(contacts.Persons.modified) ", "header": "Modified", "dataIndex": "modified", "hidden": true }, { "colIndex": 8, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(contacts.Persons.created) ", "header": "Created", "dataIndex": "created", "hidden": true }, { "colIndex": 9, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Persons.country) ", "filter": { "type": "string" }, "header": "Country", "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "dataIndex": "country", "hidden": true, "editor": country2547 }, { "colIndex": 10, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Persons.city) ", "filter": { "type": "string" }, "header": "City", "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Places.detail'), "dataIndex": "city", "hidden": true, "editor": city2548 }, { "colIndex": 11, "sortable": true, "header": "Zip code", "editable": true, "tooltip": "(contacts.Persons.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": zip_code2549, "hidden": true, "dataIndex": "zip_code" }, { "colIndex": 12, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Persons.region) ", "filter": { "type": "string" }, "header": "County", "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Places.detail'), "dataIndex": "region", "hidden": true, "editor": region2550 }, { "colIndex": 13, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "(contacts.Persons.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": addr12551, "hidden": true, "dataIndex": "addr1" }, { "colIndex": 14, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "(contacts.Persons.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": street_prefix2552, "hidden": true, "dataIndex": "street_prefix" }, { "colIndex": 15, "sortable": true, "header": "Street", "editable": true, "tooltip": "(contacts.Persons.street) Name of street, without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": street2553, "hidden": true, "dataIndex": "street" }, { "colIndex": 16, "sortable": true, "header": "No.", "editable": true, "tooltip": "(contacts.Persons.street_no) House number.", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": street_no2554, "hidden": true, "dataIndex": "street_no" }, { "colIndex": 17, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.Persons.street_box) Text to print after street nuber on the same line.", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": street_box2555, "hidden": true, "dataIndex": "street_box" }, { "colIndex": 18, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "(contacts.Persons.addr2) Address line to print below street line.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": addr22556, "hidden": true, "dataIndex": "addr2" }, { "colIndex": 19, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.Persons.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name2557, "hidden": true, "dataIndex": "name" }, { "colIndex": 20, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.Persons.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": url2558, "hidden": true, "dataIndex": "url" }, { "colIndex": 21, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.Persons.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": fax2559, "hidden": true, "dataIndex": "fax" }, { "colIndex": 22, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(contacts.Persons.remarks) ", "filter": { "type": "string" }, "header": "Remarks", "editor": remarks2560, "hidden": true, "dataIndex": "remarks" }, { "colIndex": 23, "sortable": true, "header": "isikukood", "editable": true, "tooltip": "(contacts.Persons.isikukood) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": isikukood2561, "hidden": true, "dataIndex": "isikukood" }, { "colIndex": 24, "sortable": true, "header": "VAT Regime", "editable": true, "tooltip": "(contacts.Persons.vat_regime) The default VAT regime for         sales and purchases of this partner.", "filter": { "type": "string" }, "width": Lino.chars2width(19), "editor": vat_regime2562, "hidden": true, "dataIndex": "vat_regime" }, { "colIndex": 25, "sortable": true, "header": "Payment Term", "editable": true, "tooltip": "(contacts.Persons.payment_term) The default payment term for sales invoices to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": payment_term2563, "hidden": true, "dataIndex": "payment_term" }, { "colIndex": 26, "sortable": true, "width": Lino.chars2width(22), "editable": true, "tooltip": "(contacts.Persons.iban) ", "filter": { "type": "string" }, "header": "IBAN", "renderer": Lino.iban_renderer, "hidden": true, "editor": iban2564, "dataIndex": "iban" }, { "colIndex": 27, "sortable": true, "header": "BIC", "editable": true, "tooltip": "(contacts.Persons.bic) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": bic2565, "hidden": true, "dataIndex": "bic" }, { "colIndex": 28, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Persons.invoice_recipient) ", "filter": { "type": "string" }, "header": "Invoicing address", "renderer": Lino.fk_renderer('invoice_recipientHidden','Lino.contacts.Partners.detail'), "dataIndex": "invoice_recipient", "hidden": true, "editor": invoice_recipient2566 }, { "colIndex": 29, "sortable": true, "header": "First name", "editable": true, "tooltip": "(contacts.Persons.first_name) First or given name.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": first_name2567, "hidden": true, "dataIndex": "first_name" }, { "colIndex": 30, "sortable": true, "header": "Middle name", "editable": true, "tooltip": "(contacts.Persons.middle_name) Space-separated list of all middle names.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": middle_name2568, "hidden": true, "dataIndex": "middle_name" }, { "colIndex": 31, "sortable": true, "header": "Last name", "editable": true, "tooltip": "(contacts.Persons.last_name) Last name (family name).", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": last_name2569, "hidden": true, "dataIndex": "last_name" }, { "colIndex": 32, "sortable": true, "header": "Gender", "editable": true, "tooltip": "(contacts.Persons.gender) ", "filter": { "type": "string" }, "width": Lino.chars2width(10), "editor": gender2570, "hidden": true, "dataIndex": "gender" }, { "colIndex": 33, "sortable": true, "header": "Birth date", "editable": true, "tooltip": "(contacts.Persons.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".", "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": birth_date2571, "hidden": true, "dataIndex": "birth_date" }, { "colIndex": 34, "sortable": true, "header": "Title", "editable": true, "tooltip": "(contacts.Persons.title) Text to print before allocation and name as part of the first address line.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": title2572, "hidden": true, "dataIndex": "title" } ];
    Lino.contacts.Persons.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Persons.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Persons.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Persons.print_labels = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "print_labels", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Persons.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Persons.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.contacts.Persons.insertPanel = Ext.extend(Lino.contacts.Persons.InsertFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/contacts/Persons",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    Lino.contacts.Persons.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Persons.insertPanel(p);
});
Lino.contacts.Persons.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Persons.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Persons.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.contacts.Persons.detailPanel = Ext.extend(Lino.contacts.Persons.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "create_invoice", "menu_item_text": "Create invoice", "tooltip": "Create invoice from invoiceables for this partner", "panel_btn_handler": Lino.row_action_handler('create_invoice','GET',null), "iconCls": "x-tbar-money", "overflowText": "Create invoice", "auto_save": true }, { "itemId": "due", "menu_item_text": "Debts", "tooltip": "Debts", "panel_btn_handler": Lino.row_action_handler('due','GET',null), "iconCls": "x-tbar-book_link", "overflowText": "Debts", "auto_save": true }, { "itemId": "show_invoiceables", "menu_item_text": "Invoices to create", "tooltip": "List of invoiceable items for this partner", "panel_btn_handler": Lino.row_action_handler('show_invoiceables','GET',null), "iconCls": "x-tbar-basket", "overflowText": "Invoices to create", "auto_save": true } ],
  ls_url: "/contacts/Persons",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    Lino.contacts.Persons.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Persons.detailPanel(p);
});
Lino.contacts.Persons.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Persons.create_invoice = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "create_invoice", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Persons.due = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "due", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Persons.show_invoiceables = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "show_invoiceables", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Persons.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Persons.GridPanel(p);
});
Lino.contacts.Persons.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Persons", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class contacts.Companies
Lino.contacts.Companies.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Companies",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/contacts/Companies','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/contacts/Companies','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/Companies','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/Companies','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true }, { "itemId": "print_labels", "menu_item_text": "Labels", "tooltip": "Generate mailing labels for these recipients", "panel_btn_handler": Lino.list_action_handler('/contacts/Companies','print_labels','GET',Lino.get_current_grid_config), "text": "Labels", "overflowText": "Labels", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/contacts/Companies','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "create_invoice", "menu_item_text": "Create invoice", "tooltip": "Create invoice from invoiceables for this partner", "panel_btn_handler": Lino.row_action_handler('create_invoice','GET',null), "iconCls": "x-tbar-money", "overflowText": "Create invoice", "auto_save": true }, { "itemId": "due", "menu_item_text": "Debts", "tooltip": "Debts", "panel_btn_handler": Lino.row_action_handler('due','GET',null), "iconCls": "x-tbar-book_link", "overflowText": "Debts", "auto_save": true }, { "itemId": "show_invoiceables", "menu_item_text": "Invoices to create", "tooltip": "List of invoiceable items for this partner", "panel_btn_handler": Lino.row_action_handler('show_invoiceables','GET',null), "iconCls": "x-tbar-basket", "overflowText": "Invoices to create", "auto_save": true } ],
  cell_edit : true,
  title : "Organizations",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 41,
  ls_store_fields : [ { "name": "name_column" }, { "name": "address_column" }, { "name": "email" }, { "name": "phone" }, { "name": "gsm" }, { "type": "int", "name": "id" }, { "name": "language" }, 'languageHidden', { "name": "modified" }, { "name": "created" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "zip_code" }, { "name": "region" }, 'regionHidden', { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "name" }, { "name": "url" }, { "name": "fax" }, { "name": "remarks" }, { "name": "isikukood" }, { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "payment_term" }, 'payment_termHidden', { "name": "iban" }, { "name": "bic" }, { "name": "invoice_recipient" }, 'invoice_recipientHidden', { "name": "prefix" }, { "name": "type" }, 'typeHidden', { "name": "vat_id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 18,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    var ww = this.containing_window;
    var name_column_disp2574 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var address_column_disp2575 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var email2576 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone2577 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm2578 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id2579 = new Ext.form.NumberField({ "selectOnFocus": true });
    var language2580 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ], [ "et", "Estonian" ] ] });
    var modified2581 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created2582 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country2583 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Country..." });
    var city2584 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var zip_code2585 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var region2586 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var addr12587 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix2588 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street2589 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no2590 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box2591 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr22592 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name2593 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var url2594 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var fax2595 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks2596 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var isikukood2597 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var vat_regime2598 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var payment_term2599 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Payment Term..." });
    var iban2600 = new Lino.UppercaseTextField({ "selectOnFocus": true, "maxLength": 34 });
    var bic2601 = new Lino.UppercaseTextField({ "selectOnFocus": true, "maxLength": 11 });
    var invoice_recipient2602 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/invoice_recipient", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var prefix2603 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type2604 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Organization type..." });
    var vat_id2605 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
      city2584.setContextValue('country', record ? record.data['countryHidden'] : undefined);
      city2584.setContextValue('region', record ? record.data['regionHidden'] : undefined);
      region2586.setContextValue('country', record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country2583.on('change',Lino.chooser_handler(city2584,'country'));
      region2586.on('change',Lino.chooser_handler(city2584,'region'));
      country2583.on('change',Lino.chooser_handler(region2586,'country'));
      Lino.contacts.Companies.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "header": "Name", "colIndex": 0, "sortable": false, "dataIndex": "name_column", "width": Lino.chars2width(21), "editable": false, "tooltip": "(contacts.Companies.name_column) " }, { "header": "Address", "colIndex": 1, "sortable": false, "dataIndex": "address_column", "width": Lino.chars2width(31), "editable": false, "tooltip": "(contacts.Companies.address_column) " }, { "colIndex": 2, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.Companies.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": email2576, "dataIndex": "email" }, { "colIndex": 3, "sortable": true, "header": "Phone", "editable": true, "tooltip": "(contacts.Companies.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": phone2577, "dataIndex": "phone" }, { "colIndex": 4, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.Companies.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": gsm2578, "dataIndex": "gsm" }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.Companies.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id2579, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Language", "editable": true, "tooltip": "(contacts.Companies.language) Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": Lino.chars2width(11), "editor": language2580, "dataIndex": "language" }, { "colIndex": 7, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(contacts.Companies.modified) ", "header": "Modified", "dataIndex": "modified", "hidden": true }, { "colIndex": 8, "sortable": true, "width": Lino.chars2width(17), "editable": false, "tooltip": "(contacts.Companies.created) ", "header": "Created", "dataIndex": "created", "hidden": true }, { "colIndex": 9, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Companies.country) ", "filter": { "type": "string" }, "header": "Country", "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "dataIndex": "country", "hidden": true, "editor": country2583 }, { "colIndex": 10, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Companies.city) ", "filter": { "type": "string" }, "header": "City", "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Places.detail'), "dataIndex": "city", "hidden": true, "editor": city2584 }, { "colIndex": 11, "sortable": true, "header": "Zip code", "editable": true, "tooltip": "(contacts.Companies.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": zip_code2585, "hidden": true, "dataIndex": "zip_code" }, { "colIndex": 12, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Companies.region) ", "filter": { "type": "string" }, "header": "County", "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Places.detail'), "dataIndex": "region", "hidden": true, "editor": region2586 }, { "colIndex": 13, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "(contacts.Companies.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": addr12587, "hidden": true, "dataIndex": "addr1" }, { "colIndex": 14, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "(contacts.Companies.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": street_prefix2588, "hidden": true, "dataIndex": "street_prefix" }, { "colIndex": 15, "sortable": true, "header": "Street", "editable": true, "tooltip": "(contacts.Companies.street) Name of street, without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": street2589, "hidden": true, "dataIndex": "street" }, { "colIndex": 16, "sortable": true, "header": "No.", "editable": true, "tooltip": "(contacts.Companies.street_no) House number.", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": street_no2590, "hidden": true, "dataIndex": "street_no" }, { "colIndex": 17, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.Companies.street_box) Text to print after street nuber on the same line.", "filter": { "type": "string" }, "width": Lino.chars2width(12), "editor": street_box2591, "hidden": true, "dataIndex": "street_box" }, { "colIndex": 18, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "(contacts.Companies.addr2) Address line to print below street line.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": addr22592, "hidden": true, "dataIndex": "addr2" }, { "colIndex": 19, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.Companies.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name2593, "hidden": true, "dataIndex": "name" }, { "colIndex": 20, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.Companies.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": url2594, "hidden": true, "dataIndex": "url" }, { "colIndex": 21, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.Companies.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": fax2595, "hidden": true, "dataIndex": "fax" }, { "colIndex": 22, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(contacts.Companies.remarks) ", "filter": { "type": "string" }, "header": "Remarks", "editor": remarks2596, "hidden": true, "dataIndex": "remarks" }, { "colIndex": 23, "sortable": true, "header": "isikukood", "editable": true, "tooltip": "(contacts.Companies.isikukood) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": isikukood2597, "hidden": true, "dataIndex": "isikukood" }, { "colIndex": 24, "sortable": true, "header": "VAT Regime", "editable": true, "tooltip": "(contacts.Companies.vat_regime) The default VAT regime for         sales and purchases of this partner.", "filter": { "type": "string" }, "width": Lino.chars2width(19), "editor": vat_regime2598, "hidden": true, "dataIndex": "vat_regime" }, { "colIndex": 25, "sortable": true, "header": "Payment Term", "editable": true, "tooltip": "(contacts.Companies.payment_term) The default payment term for sales invoices to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": payment_term2599, "hidden": true, "dataIndex": "payment_term" }, { "colIndex": 26, "sortable": true, "width": Lino.chars2width(22), "editable": true, "tooltip": "(contacts.Companies.iban) ", "filter": { "type": "string" }, "header": "IBAN", "renderer": Lino.iban_renderer, "hidden": true, "editor": iban2600, "dataIndex": "iban" }, { "colIndex": 27, "sortable": true, "header": "BIC", "editable": true, "tooltip": "(contacts.Companies.bic) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "editor": bic2601, "hidden": true, "dataIndex": "bic" }, { "colIndex": 28, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Companies.invoice_recipient) ", "filter": { "type": "string" }, "header": "Invoicing address", "renderer": Lino.fk_renderer('invoice_recipientHidden','Lino.contacts.Partners.detail'), "dataIndex": "invoice_recipient", "hidden": true, "editor": invoice_recipient2602 }, { "colIndex": 29, "sortable": true, "header": "Name prefix", "editable": true, "tooltip": "(contacts.Companies.prefix) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": prefix2603, "hidden": true, "dataIndex": "prefix" }, { "colIndex": 30, "sortable": true, "header": "Organization type", "editable": true, "tooltip": "(contacts.Companies.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "editor": type2604, "hidden": true, "dataIndex": "type" }, { "colIndex": 31, "sortable": true, "header": "VAT id", "editable": true, "tooltip": "(contacts.Companies.vat_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": vat_id2605, "hidden": true, "dataIndex": "vat_id" } ];
    Lino.contacts.Companies.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Companies.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Companies.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Companies.print_labels = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "print_labels", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Companies.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Companies.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.contacts.Companies.insertPanel = Ext.extend(Lino.contacts.Companies.InsertFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/contacts/Companies",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    Lino.contacts.Companies.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Companies.insertPanel(p);
});
Lino.contacts.Companies.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Companies.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Companies.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.contacts.Companies.detailPanel = Ext.extend(Lino.contacts.Companies.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "create_invoice", "menu_item_text": "Create invoice", "tooltip": "Create invoice from invoiceables for this partner", "panel_btn_handler": Lino.row_action_handler('create_invoice','GET',null), "iconCls": "x-tbar-money", "overflowText": "Create invoice", "auto_save": true }, { "itemId": "due", "menu_item_text": "Debts", "tooltip": "Debts", "panel_btn_handler": Lino.row_action_handler('due','GET',null), "iconCls": "x-tbar-book_link", "overflowText": "Debts", "auto_save": true }, { "itemId": "show_invoiceables", "menu_item_text": "Invoices to create", "tooltip": "List of invoiceable items for this partner", "panel_btn_handler": Lino.row_action_handler('show_invoiceables','GET',null), "iconCls": "x-tbar-basket", "overflowText": "Invoices to create", "auto_save": true } ],
  ls_url: "/contacts/Companies",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    Lino.contacts.Companies.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Companies.detailPanel(p);
});
Lino.contacts.Companies.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Companies.create_invoice = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "create_invoice", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Companies.due = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "due", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Companies.show_invoiceables = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "show_invoiceables", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.contacts.Companies.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Companies.GridPanel(p);
});
Lino.contacts.Companies.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/contacts/Companies", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class households.Types
Lino.households.Types.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/households/Types",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/households/Types','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/households/Types','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/households/Types','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/households/Types','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/households/Types','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  cell_edit : true,
  title : "Household Types",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "name_et" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 22,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Types.detail;
    this.ls_insert_handler = Lino.households.Types.insert;
    var ww = this.containing_window;
    var id2607 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2608 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de2609 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr2610 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_et2611 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(households.Types.id) ", "filter": { "type": "numeric" }, "header": "ID", "editor": id2607, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(households.Types.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name2608, "dataIndex": "name" }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(households.Types.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_de2609, "dataIndex": "name_de" }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(households.Types.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_fr2610, "dataIndex": "name_fr" }, { "colIndex": 4, "sortable": true, "header": "Designation (et)", "editable": true, "tooltip": "(households.Types.name_et) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "editor": name_et2611, "dataIndex": "name_et" } ];
    Lino.households.Types.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Types.show_as_html = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/households/Types", "GET", pk, "show_as_html", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.households.Types.as_pdf = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/households/Types", "GET", pk, "as_pdf", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.households.Types.as_pdf_p = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/households/Types", "GET", pk, "as_pdf_p", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.households.Types.export_excel = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/households/Types", "GET", pk, "export_excel", params, Lino.get_current_grid_config);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.households.Types.submit_detail = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/households/Types", "GET", pk, "submit_detail", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.households.Types.insertPanel = Ext.extend(Lino.households.Types.DetailFormPanel,{
  empty_title: "New",
  hide_navigator: true,
  save_action_name: "submit_insert",
  ls_bbar_actions: [ { "itemId": "submit_insert", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save()}, "text": "Create", "overflowText": "Create", "auto_save": false } ],
  ls_url: "/households/Types",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Types.detail;
    this.ls_insert_handler = Lino.households.Types.insert;
    Lino.households.Types.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Types.insert = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.households.Types.insertPanel(p);
});
Lino.households.Types.grid_put = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/households/Types", "GET", pk, "grid_put", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.households.Types.grid_post = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/households/Types", "GET", pk, "grid_post", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.households.Types.submit_insert = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/households/Types", "GET", pk, "submit_insert", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

Lino.households.Types.detailPanel = Ext.extend(Lino.households.Types.DetailFormPanel,{
  empty_title: "Detail",
  save_action_name: "submit_detail",
  ls_bbar_actions: [ { "itemId": "submit_detail", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save()}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false } ],
  ls_url: "/households/Types",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Types.detail;
    this.ls_insert_handler = Lino.households.Types.insert;
    Lino.households.Types.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Types.detail = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.households.Types.detailPanel(p);
});
Lino.households.Types.delete_selected = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/households/Types", "GET", pk, "delete_selected", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};
Lino.households.Types.grid = new Lino.WindowAction({  }, function(){
  var p = { "is_main_window": true };
  return new Lino.households.Types.GridPanel(p);
});
Lino.households.Types.validate = function(rp, pk, params) { 
  var h = function() { 
    Lino.run_row_action(rp, "/households/Types", "GET", pk, "validate", params, null);
  };
  var panel = Ext.getCmp(rp);
  if(panel) panel.do_when_clean(true, h); else h();
};

// js_render_GridPanel_class households.Households
Lino.households.Households.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/households/Households",
  ls_bbar_actions : [ { "itemId": "show_as_html", "menu_item_text": "HTML", "tooltip": "Show this table in Bootstrap3 interface", "panel_btn_handler": Lino.list_action_handler('/households/Households','show_as_html','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-html", "overflowText": "HTML", "auto_save": true }, { "panel_btn_handler": Lino.list_action_handler('/households/Households','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/households/Households','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/households/Households','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true }, { "itemId": "print_labels", "menu_item_text": "Labels", "tooltip": "Generate mailing labels for these recipients", "panel_btn_handler": Lino.list_action_handler('/households/Households','print_labels','GET',Lino.get_current_grid_config), "text": "Labels", "overflowText": "Labels", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "export_excel", "menu_item_text": "Export to .xls", "tooltip": "Export this table as an .xls document", "panel_btn_handler": Lino.list_action_handler('/households/Households','export_excel','GET',Lino.get_current_grid_config), "iconCls": "x-tbar-csv", "overflowText": "Export to .xls", "auto_save": true }, { "itemId": "insert", "menu_item_text": "New", "tooltip": "Insert a new record", "panel_btn_handler": Lino.show_insert, "iconCls": "x-tbar-add", "overflowText": "New", "keycode": 44, "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "delete_selected", "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.row_action_handler('delete_selected','GET',null), "iconCls": "x-tbar-delete", "overflowText": "Delete", "keycode": 46, "auto_save": false }, { "itemId": "create_invoice", "menu_item_text": "Create invoice", "tooltip": "Create invoice from invoiceables for this partner", "panel_btn_handler": Lino.row_action_handler('create_invoice','GET',null), "iconCls": "x-tbar-money", "overflowText": "Create invoice", "auto_save": true }, { "itemId": "due", "menu_item_text": "Debts", "tooltip": "Debts", "panel_btn_handler": Lino.row_action_handler('due','GET',null), "iconCls": "x-tbar-book_link", "overflowText": "Debts", "auto_save": true }, { "itemId": "show_invoiceables", "menu_item_text": "Invoices to create", "tooltip": "List of invoiceable items for this partner", "panel_btn_handler": Lino.row_action_handler('show_invoiceables','GET',null), "iconCls": "x-tbar-basket", "overflowText": "Invoices to create", "auto_save": true } ],
  cell_edit : true,
  title : "Households",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 38,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "modified" }, { "name": "created" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "zip_code" }, { "name": "region" }, 'regionHidden', { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "name": "isikukood" }, { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "payment_term" }, 'payment_termHidden', { "name": "iban" }, { "name": "bic" }, { "name": "invoice_recipient" }, 'invoice_recipientHidden', { "name": "prefix" }, { "name": "type" }, 'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 36,
  ls_grid_configs : [  ],
  content_type : 18,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Households.detail;
    this.ls_insert_handler = Lino.households.Households.insert;
    var ww = this.containing_window;
    var name2613 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email2614 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var modified2615 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var created2616 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var country2617 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Country..." });
    var city2618 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var zip_code2619 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var region2620 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var addr12621 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix2622 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street2623 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no2624 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box2625 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr22626 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language2627 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ], [ "et", "Esto