/*
 Copyright 2009-2013 Luc Saffre
 This file is part of the Lino project.
 Lino is free software; you can redistribute it and/or modify 
 it under the terms of the GNU Lesser General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.
 Lino is distributed in the hope that it will be useful, 
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 GNU Lesser General Public License for more details.
 You should have received a copy of the GNU Lesser General Public License
 along with Lino; if not, see <http://www.gnu.org/licenses/>.
*/

// lino.js --- generated Sat Dec  7 22:13:27 2013 by Lino version 1.6.13.
Ext.BLANK_IMAGE_URL = '/media/extjs/resources/images/default/s.gif';
LANGUAGE_CHOICES = [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ];
MEDIA_URL = "/media";

// hack to add a toCamel function, inspired by
// http://jamesroberts.name/blog/2010/02/22/string-functions-for-javascript-trim-to-camel-case-to-dashed-and-to-underscore/
String.prototype.toCamel = function(){
  //~ return this.replace(/(\-[a-z])/g, function($1){return $1.toUpperCase().replace('-','');});
  //~ return this;
  return this.replace(/([A-Z])([A-Z]+)/g, function(match,p1,p2,offset,string){
      //~ console.log("20131005 got ",arguments);
      return p1 + p2.toLowerCase();});
};



/* MonthPickerPlugin: thanks to keypoint @ sencha forum
   http://www.sencha.com/forum/showthread.php?74002-3.x-Ext.ux.MonthMenu&p=356860#post356860
*/
Ext.namespace('Ext.ux'); 

Ext.ux.MonthPickerPlugin = function() { 
    var picker; 
    var oldDateDefaults; 

    this.init = function(pk) { 
        picker = pk; 
        picker.onTriggerClick = picker.onTriggerClick.createSequence(onClick); 
        picker.getValue = picker.getValue.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
        picker.beforeBlur = picker.beforeBlur.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
    }; 

    function setDefaultMonthDay() { 
        oldDateDefaults = Date.defaults.d; 
        Date.defaults.d = 1; 
        return true; 
    } 

    function restoreDefaultMonthDay(ret) { 
        Date.defaults.d = oldDateDefaults; 
        return ret; 
    } 

    function onClick(e, el, opt) { 
        var p = picker.menu.picker; 
        p.activeDate = p.activeDate.getFirstDateOfMonth(); 
        if (p.value) { 
            p.value = p.value.getFirstDateOfMonth(); 
        } 

        p.showMonthPicker(); 
         
        if (!p.disabled) { 
            p.monthPicker.stopFx(); 
            p.monthPicker.show(); 

            p.mun(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mun(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
            p.onMonthClick = p.onMonthClick.createSequence(pickerClick); 
            p.onMonthDblClick = p.onMonthDblClick.createSequence(pickerDblclick); 
            p.mon(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mon(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
        } 
    } 

    function pickerClick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.is('button.x-date-mp-cancel')) { 
            picker.menu.hide(); 
        } else if(el.is('button.x-date-mp-ok')) { 
            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 

    function pickerDblclick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.parent() 
            && (el.parent().is('td.x-date-mp-month') 
            || el.parent().is('td.x-date-mp-year'))) { 

            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 
}; 

Ext.preg('monthPickerPlugin', Ext.ux.MonthPickerPlugin);  

//~ /* 
  //~ http://www.diloc.de/blog/2008/03/05/how-to-submit-ext-forms-the-right-way/
//~ */
//~ /**
 //~ * This submit action is basically the same as the normal submit action,
 //~ * only that it uses the fields getSubmitValue() to compose the values to submit,
 //~ * instead of looping over the input-tags in the form-tag of the form.
 //~ *
 //~ * To use it, just use the OOSubmit-plugin on either a FormPanel or a BasicForm,
 //~ * or explicitly call form.doAction('oosubmit');
 //~ *
 //~ * @param {Object} form
 //~ * @param {Object} options
 //~ */
//~ Ext.ux.OOSubmitAction = function(form, options){
    //~ Ext.ux.OOSubmitAction.superclass.constructor.call(this, form, options);
//~ };

//~ Ext.extend(Ext.ux.OOSubmitAction, Ext.form.Action.Submit, {
    //~ /**
    //~ * @cfg {boolean} clientValidation Determines whether a Form's fields are validated
    //~ * in a final call to {@link Ext.form.BasicForm#isValid isValid} prior to submission.
    //~ * Pass <tt>false</tt> in the Form's submit options to prevent this. If not defined, pre-submission field validation
    //~ * is performed.
    //~ */
    //~ type : 'oosubmit',

    //~ // private
    //~ /**
     //~ * This is nearly a copy of the original submit action run method
     //~ */
    //~ run : function(){
        //~ var o = this.options;
        //~ var method = this.getMethod();
        //~ var isPost = method == 'POST';

        //~ var params = this.options.params || {};
        //~ if (isPost) Ext.applyIf(params, this.form.baseParams);

        //~ //now add the form parameters
        //~ this.form.items.each(function(field)
        //~ {
            //~ if (!field.disabled)
            //~ {
                //~ //check if the form item provides a specialized getSubmitValue() and use that if available
                //~ if (typeof field.getSubmitValue == "function")
                    //~ params[field.getName()] = field.getSubmitValue();
                //~ else
                    //~ params[field.getName()] = field.getValue();
            //~ }
        //~ });

        //~ //convert params to get style if we are not post
        //~ if (!isPost) params=Ext.urlEncode(params);

        //~ if(o.clientValidation === false || this.form.isValid()){
            //~ Ext.Ajax.request(Ext.apply(this.createCallback(o), {
                //~ url:this.getUrl(!isPost),
                //~ method: method,
                //~ params:params, //add our values
                //~ isUpload: this.form.fileUpload
            //~ }));

        //~ }else if (o.clientValidation !== false){ // client validation failed
            //~ this.failureType = Ext.form.Action.CLIENT_INVALID;
            //~ this.form.afterAction(this, false);
        //~ }
    //~ },

//~ });
//~ //add our action to the registry of known actions
//~ Ext.form.Action.ACTION_TYPES['oosubmit'] = Ext.ux.OOSubmitAction;




/**
JC Watsons solution (adapted to ExtJS 3.3.1 by LS) is elegant and simple:
`A "fix" for unchecked checkbox submission  behaviour
<http://www.sencha.com/forum/showthread.php?28449>`_

Added special handling for checkbox inputs. 
ExtJS defines disabled checkboxes `readonly`, not `disabled` as for other inputs.

*/
Ext.lib.Ajax.serializeForm = function(form) {
    //~ console.log('20120203 linolib.js serializeForm',form);
    var fElements = form.elements || (document.forms[form] || Ext.getDom(form)).elements, 
        hasSubmit = false, 
        encoder = encodeURIComponent, 
        name, 
        data = '', 
        type, 
        hasValue;

    Ext.each(fElements, function(element){
        name = element.name;
        type = element.type;

        if (!element.disabled && name && !(type == 'checkbox' && element.readonly)) {
            if (/select-(one|multiple)/i.test(type)) {
                Ext.each(element.options, function(opt){
                    if (opt.selected) {
                        hasValue = opt.hasAttribute ? opt.hasAttribute('value') : opt.getAttributeNode('value').specified;
                        data += String.format("{0}={1}&", encoder(name), encoder(hasValue ? opt.value : opt.text));
                    }
                });
            } else if (!(/file|undefined|reset|button/i.test(type))) {
                //~ if (!(/radio|checkbox/i.test(type) && !element.checked) && !(type == 'submit' && hasSubmit)) {
                if (!(type == 'submit' && hasSubmit)) {
                    if (type == 'checkbox') {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&');
                        data += encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&';
                    } else {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + encoder(element.value) + '&');
                        data += encoder(name) + '=' + encoder(element.value) + '&';
                    }
                    hasSubmit = /submit/i.test(type);
                }
            }
        //~ } else {
            //~ console.log(name,type,element.readonly);
        }
    });
    return data.substr(0, data.length - 1);
};



/*
Set a long timeout of fifteen minutes. 
See /blog/2012/0307
*/
Ext.Ajax.timeout = 15 * 60 * 1000; 

/*
 * Thanks to 
 * `huuze <http://stackoverflow.com/users/10040/huuuze>`_ for the question
 * and to 
 * `chrisv <http://stackoverflow.com/users/683808/chrisv>`_
 * for the answer on
 * http://stackoverflow.com/questions/3764589/how-do-i-include-django-1-2s-csrf-token-in-a-javascript-generated-html-form/5485616#5485616
 * 
 * */
 
Ext.Ajax.on('beforerequest', function (conn, options) {
   if (!(/^http:.*/.test(options.url) || /^https:.*/.test(options.url))) {
     if (typeof(options.headers) == "undefined") {
       options.headers = {'X-CSRFToken': Ext.util.Cookies.get('csrftoken')};
     } else {
       options.headers.extend({'X-CSRFToken': Ext.util.Cookies.get('csrftoken')});
     }                        
   }
}, this);


/*
My fix for the "Cannot set QuickTips dismissDelay to 0" bug,
see http://www.sencha.com/forum/showthread.php?183515 
*/
Ext.override(Ext.QuickTip,{
  showAt : function(xy){
        var t = this.activeTarget;
        //~ console.log("20120224 QuickTip.showAt",this.title,this.dismissDelay,t.dismissDelay);
        if(t){
            if(!this.rendered){
                this.render(Ext.getBody());
                this.activeTarget = t;
            }
            if(t.width){
                this.setWidth(t.width);
                this.body.setWidth(this.adjustBodyWidth(t.width - this.getFrameWidth()));
                this.measureWidth = false;
            } else{
                this.measureWidth = true;
            }
            this.setTitle(t.title || '');
            this.body.update(t.text);
            this.autoHide = t.autoHide;
            // bugfix by Luc 20120226
            if (t.dismissDelay != undefined) this.dismissDelay = t.dismissDelay;
            //~ this.dismissDelay = t.dismissDelay || this.dismissDelay;
            if(this.lastCls){
                this.el.removeClass(this.lastCls);
                delete this.lastCls;
            }
            if(t.cls){
                this.el.addClass(t.cls);
                this.lastCls = t.cls;
            }
            if(this.anchor){
                this.constrainPosition = false;
            }else if(t.align){ 
                xy = this.el.getAlignToXY(t.el, t.align);
                this.constrainPosition = false;
            }else{
                this.constrainPosition = true;
            }
        }
        Ext.QuickTip.superclass.showAt.call(this, xy);
    }
});

/*
Another hack. See /docs/blog/2012/0228
*/
Ext.Element.addMethods(
    function() {
        var VISIBILITY      = "visibility",
            DISPLAY         = "display",
            HIDDEN          = "hidden",
            NONE            = "none",
            XMASKED         = "x-masked",
            XMASKEDRELATIVE = "x-masked-relative",
            data            = Ext.Element.data;

        return {
            
            mask : function(msg, msgCls) {
                var me  = this,
                    dom = me.dom,
                    dh  = Ext.DomHelper,
                    EXTELMASKMSG = "ext-el-mask-msg",
                    el,
                    mask;
                // removed the following lines. See /docs/blog/2012/0228
                //~ if (!(/^body/i.test(dom.tagName) && me.getStyle('position') == 'static')) {
                    //~ console.log(20120228,dom.tagName,me);
                    //~ me.addClass(XMASKEDRELATIVE); 
                //~ }
                if (el = data(dom, 'maskMsg')) {
                    el.remove();
                }
                if (el = data(dom, 'mask')) {
                    el.remove();
                }

                mask = dh.append(dom, {cls : "ext-el-mask"}, true);
                data(dom, 'mask', mask);

                me.addClass(XMASKED);
                mask.setDisplayed(true);
                
                if (typeof msg == 'string') {
                    var mm = dh.append(dom, {cls : EXTELMASKMSG, cn:{tag:'div'}}, true);
                    data(dom, 'maskMsg', mm);
                    mm.dom.className = msgCls ? EXTELMASKMSG + " " + msgCls : EXTELMASKMSG;
                    mm.dom.firstChild.innerHTML = msg;
                    mm.setDisplayed(true);
                    mm.center(me);
                }
                
                
                if (Ext.isIE && !(Ext.isIE7 && Ext.isStrict) && me.getStyle('height') == 'auto') {
                    mask.setSize(undefined, me.getHeight());
                }
                
                return mask;
            }

            
        };
    }()
);



Ext.namespace('Lino');
    
    

//~ Lino.subst_user_field = new Ext.form.ComboBox({});
//~ Lino.subst_user = null;
Lino.insert_subst_user = function(p){
    //~ console.log('20120714 insert_subst_user',Lino.subst_user,p);
    //~ if (Lino.subst_user_field.getValue()) {
    if (p.su) return;
    if (Lino.subst_user) {
        //~ p.su = Lino.subst_user_field.getValue();
        p.su = Lino.subst_user;
    //~ } else {
        //~ delete p.su;
    }
    //~ console.log('20120714 insert_subst_user -->',Lino.subst_user,p);
}

Lino.login_window = null;


Lino.show_login_window = function(on_login) {
  //~ console.log('20121103 show_login_window',arguments);
  //~ var current_window = Lino.current_window;
  if (Lino.login_window == null) {
    
      function do_login() { 
            //~ alert("20130923 do_login() started");
            Lino.viewport.loadMask.show()
            //~ Lino.body_loadMask.show()
            login_panel.getForm().submit({ 
                method:'POST', 
                waitTitle:'Connecting', 
                waitMsg:'Sending data...',
                success:function(){ 
                  //~ console.log('20130923 logged in',arguments);
                  //~ alert("20130923 do_login() success");
                  Lino.login_window.hide();
                  Lino.close_all_windows();
                  Lino.viewport.loadMask.hide();
                  if (typeof on_login == 'string') {
                      //~ console.log("20130829 on_login",on_login);
                      //~ alert("20130923 on_login gonna load_url");
                      Lino.load_url(on_login);
                      //~ eval(on_login);
                  } 
                  //~ else Lino.load_url(/);
                  //~ Lino.body_loadMask.hide();
                },
                failure: function(form,action) { 
                  //~ this.loadMask.hide();
                  //~ alert("20130923 do_login() failure");
                  Lino.on_submit_failure(form,action);
                  Lino.viewport.loadMask.hide()
                  //~ Lino.body_loadMask.hide()
                  //~ if (Lino.current_window) Lino.current_window.main_item.loadMask.hide()
                }
                //~ failure:function(form, action){ 
                    //~ alert_msg
                    //~ if(action.failureType == 'server'){ 
                        //~ obj = Ext.util.JSON.decode(action.response.responseText); 
                        //~ Ext.Msg.alert('Login Failed!', obj.errors.reason); 
                    //~ }else{ 
                        //~ Ext.Msg.alert('Warning!', 'Authentication server is unreachable : ' + action.response.responseText); 
                    //~ } 
                    //~ Lino.login_panel.getForm().reset(); 
                //~ } 
            }); 
      };
    
      var login_button = new Ext.Button({ 
        text:"Log in",
        formBind: true,	 
        // Function that fires when user clicks the button 
        handler: do_login});
    
      var login_panel = new Ext.FormPanel({ 
        //~ inspired by http://www.sencha.com/learn/a-basic-login/
        autoHeight:true,
        labelWidth:90,
        url:'/auth', 
        frame:true, 
        defaultType:'textfield',
        monitorValid:true,
        items:[{ 
            fieldLabel:"Username", 
            id: 'username',
            name:'username', 
            autoHeight:true,
            allowBlank:false 
        },{ 
            fieldLabel:"Password", 
            name:'password', 
            inputType:'password', 
            autoHeight:true,
            allowBlank:false 
        }],        
        buttons:[ login_button ]});
        
      Lino.login_window = new Ext.Window({
          layout:'fit',
          defaultButton: 'username',
          width:300,
          title:"Log in", 
          autoHeight:true,
          modal: true,
          closeAction: "hide",
          keys: {
            key: Ext.EventObject.ENTER,
            fn: function() { do_login()}
          },
          //~ defaultButton: login_button,
          //~ height:'auto',
          //~ closable: false,
          //~ resizable: false,
          //~ plain: true,
          //~ border: false,
          items: [login_panel] });
  };
  Lino.login_window.show();
};

Lino.logout = function(id,name) {
    //~ console.log('20121104 gonna log out',arguments);
    //~ Lino.do_action
    Lino.call_ajax_action(Lino.viewport,'GET',
        '/auth',{},'logout',undefined,undefined,function(){
        //~ console.log('20121104 logged out',arguments);
        //~ Lino.login_window.hide();
        Lino.close_all_windows();
    })
}

Lino.set_subst_user = function(id,name) {
    //~ console.log(20130723,'Lino.set_subst_user',id,name,Lino.current_window,Lino.viewport);
    Lino.subst_user = id;
//~ 
    if (Lino.current_window) 
        Lino.current_window.main_item.set_base_param("su",id);
    if (Lino.viewport) 
        Lino.permalink_handler(Lino.current_window)();
}



//~ Lino.select_subst_user = function(cmp,rec,value){
    //~ Lino.subst_user=value;
    //~ console.log(20120713,rec);
//~ }
    
Lino.current_window = null;
Lino.window_history = Array();
    
Lino.chars2width = function(cols) {  return cols * 9; }
Lino.rows2height = function(cols) {  return cols * 20; }



Lino.MainPanel = {
  is_home_page : false,
  setting_param_values : false,
  config_containing_window : function(wincfg) { }
  ,init_containing_window : function(win) { }
  ,is_loading : function() { 
      if (!this.rendered) return true;
      //~ return (Ext.select('.x-loading-msg').elements.length > 0);
      return true; 
    } 
  ,do_when_clean : function(auto_save,todo) { todo() }
  ,get_master_params : function() {
    var p = {}
    p['mt'] = this.content_type; 
    rec = this.get_current_record()
    if (rec) {
      if (rec.phantom) {
          p['mk'] = undefined; 
      }else{
          p['mk'] = rec.id; 
      }
    } else {
      p['mk'] = undefined;
    }
    //~ console.log('get_master_params returns',p,'using record',rec);
    return p;
  }
  ,get_permalink : function() {
    //~ var p = this.main_item.get_base_params() || {};
    var p = Ext.apply({},this.get_base_params());
    delete p.fmt;
    //~ if (p.fmt) delete p.fmt;
    Ext.apply(p,this.get_permalink_params());
    
    if (this.toggle_params_panel_btn) {
        p.sp = this.toggle_params_panel_btn.pressed;
        //~ if (this.toggle_params_panel_btn.pressed == this.params_panel_hidden) {
          //~ p.sp = true;
        //~ }
    }
    
    //~ Lino.insert_subst_user(p);
     //~ p.fmt = 'html';
    //~ console.log('get_permalink',p,this.get_permalink_params());
    if (this.is_home_page)
        //~ var url = '';
        var url = '/';
    else 
        var url = this.get_permalink_url();
    if (p.su == null) 
        delete p.su;
    if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
    return url;
  }
  ,get_record_url : function(record_id) {
      var url = '/api' + this.ls_url
      //~ var url = this.containing_window.config.url_data; // ls_url;
      url += '/' + (record_id === undefined ? '-99999' : String(record_id));
      //~ if (record_id !== undefined) url += '/' + String(record_id);
      //~ url += '/' + String(record_id);
      return url;
  }
  ,get_permalink_url : function() {
      return '/api' + this.ls_url;
  }
  ,get_permalink_params : function() {
      //~ return {an:'grid'};
      var p = {};
      if (this.action_name)
          p.an = this.action_name;
      this.add_param_values(p,false)
      return p;
  }
  ,set_status : function(status) {}
  ,get_status : function() { return {}}
  ,refresh : function() {}
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,add_params_panel : function (tbar) {
      if (this.params_panel) {
        //~  20130923b
        //~ this.params_panel.autoHeight = true; // 20130924
        var t = this;
        var update = function() {
            var p = t.params_panel;
            //~ console.log("update", p.getSize().height,p.forceLayout,p.autoHeight);
            var w = t.get_containing_window();
            Lino.do_when_visible(w, function() {
                //~ p.doLayout(true); // doLayout(shallow, force)
                w.doLayout(true); // doLayout(shallow, force)
                //~ t.params_panel.on('afterlayout',update,t,{single:true});
            });
        };
        Lino.do_when_visible(this.params_panel, update);
        this.params_panel.on('show',update);
        this.params_panel.on('hide',update);
        //~ this.params_panel.on('bodyresize',update);
        this.params_panel.on('afterlayout',update);
        //~ this.params_panel.on('afterlayout',update,this,{single:true});
        //~ this.params_panel.on('bodyresize',update,this,{single:true});
        //~ this.params_panel.on('resize',update,this,{single:true});
        //~ this.params_panel.on('render',update,this,{single:true});
        
        // this.params_panel.on('render',
        //~ this.params_panel.on('afterlayout',update,this,{single:true,delay:200});
        //~ this.params_panel.on('bodyresize',update,this,{single:true,delay:200});
        this.toggle_params_panel_btn = new Ext.Button({ scope:this, 
          //~ text: "$_("[parameters]")", // gear
          iconCls: 'x-tbar-parameters',
          tooltip:"Show or hide the table parameters panel",
          enableToggle: true,
          //~ pressed: ! this.params_panel.hidden,
          pressed: ! this.params_panel_hidden,
          toggleHandler: function(btn,state) { 
            //~ console.log("20120210 add_params_panel",state,this.params_panel);
            if (state) {
                this.params_panel.show();
            } else {
                this.params_panel.hide();
            }
            //~ this.params_panel.on('afterlayout',update,this,{single:true});
            //~ t.get_containing_window().doLayout();
            //~ this.params_panel.on('afterlayout',function() {
                //~ console.log("20130918 afterlayout");
                //~ t.get_containing_window().doLayout(); // doLayout(shallow, force)
            //~ },this,{single:true});
          }
        }); 
        tbar = tbar.concat([this.toggle_params_panel_btn]);
        var refresh = function() {
            if (!t.setting_param_values) {
                t._force_dirty = true; 
                t.refresh();
            }
        }
        Ext.each(this.params_panel.fields,function(f) {
          //~ f.on('valid',function() {t.refresh()});
          if (f instanceof Ext.form.Checkbox) {
              f.on('check',refresh);
          } else if (f instanceof Ext.DatePicker) {
              f.on('select',refresh);
          } else if (f instanceof Ext.form.TriggerField) {
              f.on('select',refresh);
              //~ f.on('change',refresh);
              //~ f.on('valid',refresh);
          } else {
              if (! f.on) 
                  console.log("20121010 no method 'on'",f);
              else
                  f.on('change',refresh);
            }
          });
      }
      return tbar;
  }
  ,add_param_values : function (p,force_dirty) {
    if (this.params_panel) {
      /* 
      * 20120918 add param_values to the request string 
      * *only if the params_form is dirty*.
      * Otherwise Actor.default_params() would never be used.
      *
      * 20121023 But IntegClients.params_default has non-empty default values. 
      * Users must have the possibility to make them empty.
      * 
      * 20130605 : added `force_dirty` parameter because Checkbox fields don't 
      * mark their form as dirty when check is fired.
      * 
      * 20130721 : `force_dirty` not as a parameter but as 
      * `this._force_dirty` because
      * 
      * 20130915 : both _force_dirty and force_dirty parameter are needed.
      * 
      */
      if (force_dirty || this._force_dirty || this.params_panel.form.isDirty()) {
      //~ if (this._force_dirty || this.params_panel.form.isDirty()) {
        p.pv = this.get_param_values();
        //~ console.log("20130923 form is dirty (",force_dirty,this._force_dirty,this.params_panel.form.isDirty(),")");
        //~ console.log("20130923 form is dirty",p);
      }else{
        //~ console.log("20130923 form not dirty:",this.params_panel.form);
        if (this.status_param_values) 
          p.pv = Lino.fields2array(
            this.params_panel.fields,this.status_param_values);
      }
      //~ if (!this.params_panel.form.isDirty()) return;
      //~ p.pv = this.get_param_values();
      //~ console.log("20120203 add_param_values added pv",p.pv,"to",p);
    }
  },
  get_param_values : function() { // similar to get_field_values()
      return Lino.fields2array(this.params_panel.fields);
  },
  set_param_values : function(pv) {
    if (this.params_panel) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_param_values = pv;
      //~ this.params_panel.form.suspendEvents(false);
      this.setting_param_values = true;
      if (pv) { 
          this.params_panel.form.my_loadRecord(pv);
      } else { 
        this.params_panel.form.reset(); 
      }
      this.setting_param_values = false;
      this._force_dirty = false; 
      //~ this.params_panel.form.resumeEvents();
    }
  }
};




Lino.Viewport = Ext.extend(Ext.Viewport,Lino.MainPanel);
Lino.Viewport = Ext.extend(Lino.Viewport,{
  layout : "fit"
  ,is_home_page : true
  ,initComponent : function(){
    Lino.Viewport.superclass.initComponent.call(this);
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.el,{msg:"Please wait..."});
      //~ console.log("20121118 Lino.viewport.loadMask",this.loadMask);
    },this);
  }
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,refresh : function() {
      var caller = this;
      //~ console.log("20121120 Lino.Viewport.refresh()");
      if (caller.loadMask) caller.loadMask.show();
      var success = function(response) {
        if (caller.loadMask) caller.loadMask.hide();
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          //~ console.log('Lino.do_action()',action.name,'result is',result);
          if (result.html) {
              Ext.getCmp('main_area').update(result.html);
          }
          if (result.message) {
              if (result.alert) {
                  //~ Ext.MessageBox.alert('Alert',result.alert_msg);
                  Ext.MessageBox.alert('Alert',result.message);
              } else {
                  Lino.notify(result.message);
              }
          }
          
          if (result.notify_msg) Lino.notify(result.notify_msg);
          if (result.js_code) { 
            var jsr = result.js_code(caller);
            //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
          };
        }
      };
      var action = {
        url : '/api/main_html',
        waitMsg: "Please wait...",
        failure: Lino.ajax_error_handler(caller),
        success: success,
        method: 'GET',
        params: {}
      };
      Lino.insert_subst_user(action.params);
      Ext.Ajax.request(action);
    
  }
});




Lino.open_window = function(win,st,requesting_panel) {
  //~ console.log("20120918 Lino.open_window()",win,st);
  var cw = Lino.current_window;
  if (cw) {
    //~ console.log("20120918 Lino.open_window() save current status",cw.main_item.get_status());
    Lino.window_history.push({
      window:cw,
      status:cw.main_item.get_status()
    });
  }
  Lino.current_window = win;
  //~ if (st.su) 
      //~ Lino.subst_user_field.setValue(st.su);
  win.main_item.set_status(st,requesting_panel);
  win.show();
};

Lino.load_url = function(url) {
    //~ foo.bar.baz = 2; 
    //~ console.log("20121120 Lino.load_url()");
    //~ Lino.body_loadMask.show();
    Lino.viewport.loadMask.show();
    //~ location.replace(url);
    document.location = url;
}

Lino.close_window = function(status_update) {
  var cw = Lino.current_window;
  var ww = Lino.window_history.pop();
  if (ww) {
    //~ if (status_update) Ext.apply(ww.status,status_update);
    if (status_update) status_update(ww);
    ww.window.main_item.set_status(ww.status);
    Lino.current_window = ww.window;
  } else {
    Lino.current_window = null;
  }
  if (cw) cw.hide_really();
};

Lino.close_all_windows = function() {
  if (Lino.window_history.length == 0) {
      //~ Lino.viewport.refresh();
      var url =  "/"
      //~ console.log("20121120 Lino.close_all_windows() : no window_history");
      //~ if (ADMIN_URL) 
      var p = {};
      Lino.insert_subst_user(p)
      if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
      Lino.load_url(url);
  } else {
    //~ console.log("20121120 Lino.close_all_windows() with window_history");
    while (Lino.window_history.length > 0) {
      Lino.close_window();
      //~ Lino.window_history.pop().hide_really();
    }
  }
  //~ Lino.current_window = null;
  //~ Lino.close_window();
  //~ var ww = 
}

Lino.kill_current_window = function() {
  var cw = Lino.current_window;
  Lino.current_window = null;
  if (cw) cw.hide_really();
};

Lino.calling_window = function() {
    if (Lino.window_history.length) return Lino.window_history[Lino.window_history.length-1];
}

//~ Lino.WindowAction = function(mainItemClass,windowConfig,mainConfig,ppf) {
Lino.WindowAction = function(windowConfig,main_item_fn) {
    //~ if(!mainConfig) mainConfig = {};
    //~ mainConfig.is_main_window = true;
    this.windowConfig = windowConfig;
    this.main_item_fn = main_item_fn;
    //~ if (ppf) mainConfig.params_panel.fields = ppf;
    //~ this.mainConfig = mainConfig;
    //~ this.mainItemClass = mainItemClass;
};

Lino.WindowAction = Ext.extend(Lino.WindowAction,{
    window : null,
    //~ mainItemClass: null,
    get_window : function() {
      //~ if(mainConfig) Ext.apply(this.mainConfig,mainConfig);
      if (this.window == null)  {
          //~ this.windowConfig.main_item = new this.mainItemClass(this.mainConfig);
          this.windowConfig.main_item = this.main_item_fn();
          this.window = new Lino.Window(this.windowConfig);
      }
      return this.window;
    },
    run : function(requesting_panel,status) {
      //~ console.log('20120625 window_action.run()',this)
      Lino.open_window(this.get_window(),status,requesting_panel);
    }
  
});


Lino.PanelMixin = {
  get_containing_window : function (){
      if (this.containing_window) return this.containing_window;
      return this.containing_panel.get_containing_window();
  }
  ,set_window_title : function(title) {
    //~ this.setTitle(title);
    var cw = this.get_containing_window();

    //~ if (cw) {
    //~ if (cw && cw.closable) {
    if (cw && !cw.main_item.hide_window_title) {
      //~ console.log('20111202 set_window_title(',title,') for',this.containing_window);
      //~ if (! this.containing_window.rendered) console.log("WARNING: not rendered!");
      cw.setTitle(title);
    //~ } else {
      //~ document.title = title;
    }
    //~ else console.log('20111202 not set_window_title(',title,') for',this);
  }
  
};


// Lino.status_bar = new Ext.ux.StatusBar({defaultText:'Lino version 1.6.13.'});
Lino.status_bar = new Ext.ux.StatusBar({
    autoClear: 10000, // 10 seconds
    defaultText:'Lino Presto 0.1.'
    });



Lino.edit_tinymce_text = function(panel,options) {
  // `panel` is the RichTextPanel
  //~ console.log(20111220,panel);
  //~ var rec = panel.get_current_record();
  var rec = panel.containing_panel.get_current_record();
  var value = rec ? rec.data[panel.editor.name] : '';
  var saving = false;
  var todo_after_save = false;
  var discard_changes = false;
  
  
  function save() {
    //~ if (todo_after_save) {alert('tried to save again'); return; }
    if (saving) {alert('tried to save again'); return; }
    //~ var url = panel.containing_window.main_item.get_record_url(rec.id);
    var url = panel.containing_panel.get_record_url(rec.id);
    var params = Ext.apply({},panel.containing_panel.get_base_params());
    params[panel.editor.name] = editor.getValue();
    //~ params.su = Lino.subst_user;
    //~ Lino.insert_subst_user(params);
    var a = { 
      params: params, 
      method: 'PUT',
      url: url,
      failure: function() {
          //~ if (editor.ed.getContainer()) 
          editor.ed.setProgressState(0);
          todo_after_save = false;
          saving = false;
          console.log('tinymce.save() failed. sorry.',arguments);
        },
      success: function() {
        saving = false;
        //~ if (editor.ed.getContainer()) 
        editor.ed.setProgressState(0);
        rec.data[panel.editor.name] = editor.getValue();
        if(todo_after_save) {
            var fn = todo_after_save;
            todo_after_save = false;
            fn();
        }
        //~ panel.containing_window.set_current_record(rec);
        panel.refresh();
      }
    };
    //~ if (editor.ed.getContainer()) 
    editor.ed.setProgressState(1); // Show progress
    saving = true;
    //~ console.log(a);
    Ext.Ajax.request(a);
  };
  function save_callback() {
      save();
      //~ save(function(){editor.ed.setDirty(false);})
      /* return true have the save button disabled.  
      That's not perfect because the PUT is asynchronous 
      and the response is not yet known.
      */
      return true;
  }
  //~ var actions = [
    //~ {text:"Save",handler:save}
  //~ ]; 
  //~ console.log(20110610,panel.editor.disabled);
  var settings = {};
  Ext.apply(settings,{
        readonly: panel.editor.disabled,
        //~ language: "de",
        plugins : "save,emotions,spellchecker,advhr,insertdatetime,preview,table,searchreplace,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "save,cancel,|,bold,italic,underline,|,justifyleft,justifycenter,justifyright,fontselect,fontsizeselect,formatselect,|,search,replace",
        theme_advanced_buttons2 : "cut,copy,paste,template,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,link,unlink,anchor,image,|,code,preview,|,forecolor,backcolor",
        theme_advanced_buttons3 : "insertdate,inserttime,|,spellchecker,advhr,,removeformat,|,sub,sup,|,charmap,emotions,|,tablecontrols",      
        theme_advanced_resizing : false,
        convert_urls : false,
        save_onsavecallback : save_callback,
        save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
  });
  Ext.apply(settings,options);
  var editor = new Ext.ux.TinyMCE({
      value : value,
      tinymceSettings: settings
    });
  var win = new Ext.Window({
    title: rec.title, 
    //~ bbar: actions,
    layout: 'fit',
    items: editor,
    width: 600, 
    height:500,
    minWidth: 100,
		minHeight: 100,
    modal: true,
    resizable: true,
    maximizable: true,
    //~ maximized: true,
    //~ closeAction: "close"
    closeAction: "hide"
    //~ hideMode: "offsets",
    //~ constrainHeader: true,
    //~ bodyStyle: 'padding: 10px'
  });

  //~ win.on('beforeclose',function() {
  win.on('beforehide',function() {
    if (todo_after_save) return false;
    if (discard_changes) return true;
    if (editor.isDirty()) {
        //~ var ok = false;
        //~ var allowClose = true;
        var config = {title:"Confirmation"};
        config.buttons = Ext.MessageBox.YESNOCANCEL;
        config.msg = "Save changes to text ?";
        config.modal = true;
        config.fn = function(buttonId,text,opt) {
          //~ console.log('do_when_clean',buttonId)
          if (buttonId == "yes") {
              /* we cancel this close, but save()'s onSuccess will call again.*/
              //~ allowClose = false;
              todo_after_save = function(){win.hide();}
              editor.ed.execCommand('mceSave');
              //~ editor.ed.save(function(){win.close();});
          } else if (buttonId == "no") { 
              discard_changes = true;
              win.hide()
          //~ } else if (buttonId == "cancel") { 
            //~ ok = true;
              //~ allowClose = false;
          //~ } else { 
            //~ console.log('unknwon buttonId:',buttonId);
          }
        }
        Ext.MessageBox.show(config);
        return false;
        //~ return allowClose;
    }
  });
  win.show();
}







/* 
  Originally copied from Ext JS Library 3.3.1
  Modifications by Luc Saffre : 
  - rendering of phantom records
  - fire afteredit event
  - react on dblclcik, not on single click

 */
Lino.CheckColumn = Ext.extend(Ext.grid.Column, {

    processEvent : function(name, e, grid, rowIndex, colIndex){
        //~ console.log('20110713 Lino.CheckColumn.processEvent',name)
        if (name == 'click') {
        //~ if (name == 'mousedown') {
        //~ if (name == 'dblclick') {
            return this.toggleValue(grid, rowIndex, colIndex);
        } else {
            return Ext.grid.ActionColumn.superclass.processEvent.apply(this, arguments);
        }
    },
    
    toggleValue : function (grid,rowIndex,colIndex) {
        var record = grid.store.getAt(rowIndex);
        var dataIndex = grid.colModel.getDataIndex(colIndex);
        // 20120514
        //~ if(record.data.disabled_fields && record.data.disabled_fields[dataIndex]) {
          //~ Lino.notify("This field is disabled");
          //~ return false;
        //~ }
      
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("This field is disabled.");
            //~ return false;
        //~ }
        var startValue = record.data[dataIndex];
        var value = !startValue;
        //~ record.set(this.dataIndex, value);
        var e = {
            grid: grid,
            record: record,
            field: dataIndex,
            originalValue: startValue,
            value: value,
            row: rowIndex,
            column: colIndex,
            cancel: false
        };
        if(grid.fireEvent("beforeedit", e) !== false && !e.cancel){
        //~ if(grid.fireEvent("validateedit", e) !== false && !e.cancel){
            record.set(dataIndex, value);
            delete e.cancel;
            grid.fireEvent("afteredit", e);
        }
        return false; // Cancel event propagation
    },

    renderer : function(v, p, record){
        if (record.phantom) return '';
        p.css += ' x-grid3-check-col-td'; 
        return String.format('<div class="x-grid3-check-col{0}">&#160;</div>', v ? '-on' : '');
    }

    // Deprecate use as a plugin. Remove in 4.0
    // init: Ext.emptyFn
});

// register ptype. Deprecate. Remove in 4.0
// Ext.preg('checkcolumn', Lino.CheckColumn);

// backwards compat. Remove in 4.0
// Ext.grid.CheckColumn = Lino.CheckColumn;

// register Column xtype
Ext.grid.Column.types.checkcolumn = Lino.CheckColumn;


/* 20110725 : 
Lino.on_tab_activate is necessary 
in contacts.Person.2.dtl 
(but don't ask me why...)
*/
Lino.on_tab_activate = function(item) {
  //~ console.log('activate',item); 
  if (item.rendered && item.doLayout) item.doLayout();
  //~ if (item.rendered) item.doLayout();
}

Lino.TimeField = Ext.extend(Ext.form.TimeField,{
  format: 'H:i',
  increment: 15
  });
Lino.DateField = Ext.extend(Ext.form.DateField,{
  //~ boxMinWidth: Lino.chars2width(15), // 20131005 changed from 11 to 15
  format: 'd.m.Y',
  altFormats: 'd/m/Y|Y-m-d'
  });
Lino.DatePickerField = Ext.extend(Ext.DatePicker,{
  //~ boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  //~ altFormats: 'd/m/Y|Y-m-d'
  formatDate : function(date){
      //~ console.log("20121203 formatDate",this.name,date);
      return Ext.isDate(date) ? date.dateFormat(this.format) : date;
  }
  });
Lino.DateTimeField = Ext.extend(Ext.ux.form.DateTime,{
  dateFormat: 'd.m.Y',
  timeFormat: 'H:i'
  //~ ,hiddenFormat: 'd.m.Y H:i'
  });
Lino.URLField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  //~ triggerClass : 'x-form-world-trigger',
  vtype: 'url',
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    window.open(this.getValue(),'_blank');
  }
});
Lino.IncompleteDateField = Ext.extend(Ext.form.TextField,{
  //~ regex: /^-?\d+-[01]\d-[0123]\d$/,
  //~ regex: /^[0123]\d\.[01]\d\.-?\d+$/,
  maxLength: 10,
  boxMinWidth: Lino.chars2width(10),
  regex: /^[0123]?\d\.[01]?\d\.-?\d+$/,
  regexText: 'Enter a date in format YYYY-MM-DD (use zeroes for unknown parts).'
  });


//~ Lino.make_dropzone = function(cmp) {
    //~ cmp.on('render', function(ct, position){
      //~ ct.el.on({
        //~ dragenter:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ return true;
        //~ }
        //~ ,dragover:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ event.stopEvent();
          //~ return true;
        //~ }
        //~ ,drop:{
          //~ scope:this
          //~ ,fn:function(event){
            //~ event.stopEvent();
            //~ console.log(20110516);
            //~ var files = event.browserEvent.dataTransfer.files;
            //~ if(files === undefined){
              //~ return true;
            //~ }
            //~ var len = files.length;
            //~ while(--len >= 0){
              //~ console.log(files[len]);
              //~ // this.processDragAndDropFileUpload(files[len]);
            //~ }
          //~ }
        //~ }
      //~ });
    //~ });
//~ };

//~ Lino.FileUploadField = Ext.ux.form.FileUploadField;

Lino.FileUploadField = Ext.extend(Ext.ux.form.FileUploadField,{
    onRender : function(ct, position){
      Lino.FileUploadField.superclass.onRender.call(this, ct, position);
      this.el.on({
        dragenter:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          return true;
        }
        ,dragover:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          event.stopEvent();
          return true;
        }
        ,drop:{
          scope:this
          ,fn:function(event){
            event.stopEvent();
            //~ console.log(20110516);
            var files = event.browserEvent.dataTransfer.files;
            if(files === undefined){
              return true;
            }
            var len = files.length;
            while(--len >= 0){
              console.log(files[len]);
              //~ this.processDragAndDropFileUpload(files[len]);
            }
          }
        }
      });
    }
});

Lino.FileField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  editable: false,
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    if (this.getValue()) window.open(MEDIA_URL + '/'+this.getValue(),'_blank');
  }
});

Lino.file_field_handler = function(panel,config) {
  //~ if (instanceof Lino.DetailWrapper) {
  if (panel.action_name == 'insert') {
  //~ if (panel.get_current_record().phantom) {
      panel.has_file_upload = true;

      var f = new Lino.FileUploadField(config);
      //~ Lino.make_dropzone(f);
      return f;
      //~ return new Ext.ux.form.FileUploadField(config);
      //~ return new Lino.FileField(config);
      
  } else {
      //~ return new Lino.URLField(config);
      return new Lino.FileField(config);
  }
}

Lino.VBorderPanel = Ext.extend(Ext.Panel,{
    constructor : function(config) {
      config.layout = 'border';
      delete config.layoutConfig;
      Lino.VBorderPanel.superclass.constructor.call(this,config);
      for(var i=0; i < this.items.length;i++) {
        var item = this.items.get(i);
        if (this.isVertical(item) && item.collapsible) {
          item.on('collapse',this.onBodyResize,this);
          item.on('expand',this.onBodyResize,this);
        }
      }
    },
    isVertical : function(item) {
       return (item.region == 'north' || item.region == 'south' || item.region == 'center');
    },
    onBodyResize: function(w, h){
        //~ console.log('VBorderPanel.onBodyResize',this.title)
      if (this.isVisible()) { // to avoid "Uncaught TypeError: Cannot call method 'getHeight' of undefined."
        var sumflex = 0;
        var availableHeight = this.getInnerHeight();
        var me = this;
        this.items.each(function(item){
          if (me.isVertical(item)) {
              if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  if (item.rendered) availableHeight -= item.getHeight();
              } else {
                  sumflex += item.flex;
              }
          } 
          
        });
        //~ for(var i=0; i < this.items.length;i++) {
          //~ var item = this.items.get(i);
          //~ // if (this.isVertical(item) && item.getResizeEl()) {
          //~ if (this.isVertical(item)) {
              //~ if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  //~ // item.syncSize()
                  //~ // item.doLayout()
                  //~ // if (item.region == "north") console.log('region north',item.getHeight(),item.id, item);
                  //~ // if (item.getHeight() == 0) console.log(20100921,'both flex and getHeight() are 0!');
                  //~ availableHeight -= item.getHeight();
              //~ } else {
                  //~ sumflex += item.flex;
                  //~ // console.log(item.flex);
              //~ }
          //~ } 
          //~ // else console.log('non-vertical item in VBoderPanel:',item)
        //~ }
        var hunit = availableHeight / sumflex;
        //~ console.log('sumflex=',sumflex,'hunit=',hunit, 'availableHeight=',availableHeight);
        for(var i=0; i < this.items.length;i++) {
          var item = this.items.get(i);
          if (this.isVertical(item)) {
              if (item.flex != 0 && ! item.collapsed) {
                  item.setHeight(hunit * item.flex);
                  //~ console.log(item.region,' : height set to',item.getHeight());
              }
          }
          //~ else console.log('non-vertical item in VBoderPanel:',item)
        }
      }
      Lino.VBorderPanel.superclass.onBodyResize.call(this, w, h);
    }
});


/*
  modifications to the standard behaviour of a CellSelectionModel:
  
*/
Ext.override(Ext.grid.CellSelectionModel, {
//~ var dummy = {

    handleKeyDown : function(e){
        /* removed because F2 wouldn't pass
        if(!e.isNavKeyPress()){
            return;
        }
        */
        //~ console.log('handleKeyDown',e)
        var k = e.getKey(),
            g = this.grid,
            s = this.selection,
            sm = this,
            walk = function(row, col, step){
                return g.walkCells(
                    row,
                    col,
                    step,
                    g.isEditor && g.editing ? sm.acceptsNav : sm.isSelectable, 
                    sm
                );
            },
            cell, newCell, r, c, ae;

        switch(k){
            case e.ESC:
            case e.PAGE_UP:
            case e.PAGE_DOWN:
                break;
            default:
                // e.stopEvent(); // removed because Browser keys like Alt-Home, Ctrl-R wouldn't work
                break;
        }

        if(!s){
            cell = walk(0, 0, 1); 
            if(cell){
                this.select(cell[0], cell[1]);
            }
            return;
        }

        cell = s.cell;  
        r = cell[0];    
        c = cell[1];    
        
        switch(k){
            case e.TAB:
                if(e.shiftKey){
                    newCell = walk(r, c - 1, -1);
                }else{
                    newCell = walk(r, c + 1, 1);
                }
                break;
            case e.HOME:
                if (! (g.isEditor && g.editing)) {
                  if (!e.hasModifier()){
                      newCell = [r, 0];
                      //~ console.log('home',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
                      if (activePage > 1) {
                          e.stopEvent();
                          t.moveFirst();
                          return;
                      }
                      newCell = [0, c];
                      break;
                  }
                }
            case e.END:
                if (! (g.isEditor && g.editing)) {
                  c = g.colModel.getColumnCount()-1;
                  if (!e.hasModifier()) {
                      newCell = [r, c];
                      //~ console.log('end',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var d = t.getPageData();
                      if (d.activePage < d.pages) {
                          e.stopEvent();
                          var self = this;
                          t.on('change',function(tb,pageData) {
                              var r = g.store.getCount()-2;
                              self.select(r, c);
                              //~ console.log('change',r,c);
                          },this,{single:true});
                          t.moveLast();
                          return;
                      } else {
                          newCell = [g.store.getCount()-1, c];
                          //~ console.log('ctrl-end',newCell);
                          break;
                      }
                  }
                }
            case e.DOWN:
                newCell = walk(r + 1, c, 1);
                break;
            case e.UP:
                newCell = walk(r - 1, c, -1);
                break;
            case e.RIGHT:
                newCell = walk(r, c + 1, 1);
                break;
            case e.LEFT:
                newCell = walk(r, c - 1, -1);
                break;
            case e.F2:
                if (!e.hasModifier()) {
                    if (g.isEditor && !g.editing) {
                        g.startEditing(r, c);
                        e.stopEvent();
                        return;
                    }
                    break;
                }
            case e.INSERT:
                if (!e.hasModifier()) {
                    if (g.ls_insert_handler && !g.editing) {
                        e.stopEvent();
                        Lino.show_insert(g);
                        return;
                    }
                    break;
                }
            case e.DELETE:
                if (!e.hasModifier()) {
                    if (!g.editing) {
                        e.stopEvent();
                        Lino.delete_selected(g);
                        return;
                    }
                    break;
                }
            case e.ENTER:
                e.stopEvent();
                g.onCellDblClick(r,c);
                break;
                
        }
        

        if(newCell){
          e.stopEvent();
          r = newCell[0];
          c = newCell[1];
          this.select(r, c); 
          if(g.isEditor && g.editing){ 
            ae = g.activeEditor;
            if(ae && ae.field.triggerBlur){
                ae.field.triggerBlur();
            }
            g.startEditing(r, c);
          }
        //~ } else if (g.isEditor && !g.editing && e.charCode) {
        //~ // } else if (!e.isSpecialKey() && g.isEditor && !g.editing) {
            //~ g.set_start_value(String.fromCharCode(e.charCode));
            //~ // g.set_start_value(String.fromCharCode(k));
            //~ // g.set_start_value(e.charCode);
            //~ g.startEditing(r, c);
            //~ // e.stopEvent();
            //~ return;
        // } else {
          // console.log('20120513',e,g);
        }
        
    }


//~ };
});

 

function PseudoConsole() {
    this.log = function() {};
};
if (typeof(console) == 'undefined') console = new PseudoConsole();

Lino.notify = function(msg) {
  if (msg == undefined) msg = ''; else console.log(msg);
  //~ Ext.getCmp('konsole').update(msg);
  Lino.status_bar.setStatus({
    text: msg,
    iconCls: 'ok-icon',
    clear: true // auto-clear after a set interval
  });
  //~ Ext.getCmp('konsole').setTitle(msg.replace(/\n/g,'<br/>'));
  //~ Ext.getCmp('konsole').update(msg.replace(/\n/g,'<br/>'));
};
Lino.alert = function(msg) {
  //~ if (msg == undefined) msg = ''; else console.log(msg);
  Ext.MessageBox.alert('Notify',msg);
};


//~ Lino.show_about = function() {
  //~ new Ext.Window({
    //~ width: 400, height: 400,
    //~ title: "About",
    //~ html: '<a href="http://www.extjs.com" target="_blank">ExtJS</a> version ' + Ext.version
  //~ }).show();
//~ };

function obj2str(o) {
  if (typeof o != 'object') return String(o);
  var s = '';
  for (var p in o) {
    s += p + ': ' + obj2str(o[p]) + '\n';
  }
  return s;
}

Lino.on_store_exception = function (store,type,action,options,response,arg) {
  //~ throw response;
  console.log("on_store_exception: store=",store,
    "type=",type,
    "action=",action,
    "options=",options,
    "response=",response,
    "arg=",arg);
  if (arg) { console.log(arg.stack)};
};

//~ Lino.on_submit_success = function(form, action) {
   //~ Lino.notify(action.result.message);
   //~ this.close();
//~ };

Lino.on_submit_failure = function(form, action) {
    //~ Lino.notify();
  // action may be undefined
    switch (action.failureType) {
        case Ext.form.Action.CLIENT_INVALID:
            Ext.Msg.alert('Client-side failure', 'Form fields may not be submitted with invalid values');
            break;
        case Ext.form.Action.CONNECT_FAILURE:
            Ext.Msg.alert('Connection failure', 'Ajax communication failed');
            break;
        case Ext.form.Action.SERVER_INVALID:
            Ext.Msg.alert('Server-side failure', action.result.message);
   }
};



/*
Lino.save_wc_handler = function(ww) {
  return function(event,toolEl,panel,tc) {
    var pos = panel.getPosition();
    var size = panel.getSize();
    wc = ww.get_window_config();
    Ext.applyIf(wc,{ 
      x:pos[0],y:pos[1],height:size.height,width:size.width,
      maximized:panel.maximized});
    Lino.do_action(ww,{url:'/window_configs/'+ww.config.permalink_name,params:wc,method:'POST'});
  }
};

*/

Lino.show_in_own_window_button = function(handler) {
  return {
    qtip: "Show this panel in own window", 
    id: "up",
    handler: function(event,toolEl,panel, tc) {
      //~ console.log('20111206 report_window_button',panel,handler);
      handler.run(null,{base_params:panel.containing_panel.get_master_params()});
    }
  }
}




Lino.delete_selected = function(panel) {
  //~ console.log("Lino.delete_selected",panel);
  var recs1 = panel.get_selected();
  var recs = [];
  for ( var i=0; i < recs1.length; i++ ) { if (! recs1[i].phantom) recs.push(recs1[i]); }
  if (recs.length == 0) {
    Lino.notify("Please select at least one record.");
    return;
  };
  if (recs.length == 1) {
      if (recs[0].disable_delete) {
        Lino.alert(recs[0].disable_delete);
        return;
      }
  };
  //~ console.log(recs);
  Ext.MessageBox.show({
    title: "Confirmation",
    msg: String.format("Delete {0} rows. Are you sure?",String(recs.length)),
    //~ msg: "Delete " + String(recs.length) + " rows. Are you sure?",
    //~ buttons: Ext.MessageBox.YESNOCANCEL,
    buttons: Ext.MessageBox.YESNO,
    fn: function(btn) {
      if (btn == 'yes') {
        for ( var i=0; i < recs.length; i++ ) {
          Lino.do_action(panel,{
              method:'DELETE',
              url:  '/api' + panel.ls_url + '/' + recs[i].id,
              after_success: panel.after_delete.createDelegate(panel)
          })
        }
        //~ caller.after_delete();
      }
      else Lino.notify("Dann eben nicht.");
    }
  });
};

Lino.action_handler = function (panel,on_success,on_confirm) {
  return function (response) {
      
      // 20131026
      if (!panel) { 
          if (Lino.current_window) 
              panel = Lino.current_window.main_item;
          else panel = Lino.viewport;
      }
      
    //~ console.log(20120608,panel);
    if (panel instanceof Lino.GridPanel) {
        //~ gridmode = false;
        gridmode = true;
        //~ console.log('20120608 yes');
    } else {
        gridmode = false;
        //~ console.log('20120608 no');
    }
    if (panel.loadMask) panel.loadMask.hide(); // 20120211
    if (!response.responseText) return ;
    var result = Ext.decode(response.responseText);
    //~ console.log('Lino.action_handler()','result is',result,'on_confirm is',on_confirm);
    
    if (result.eval_js) {
        //~ console.log(20120618,result.eval_js);
        eval(result.eval_js);
    }
    
    //~ if (result.goto_record) {
        //~ var js = "Lino." + result.goto_record[0] + '.detail.run';
        //~ var h = eval(js);
        //~ h(panel,{record_id:result.goto_record[1]});
    //~ }
    
    if (result.xcallback) {
        //~ var config = {title:"Confirmation"};
        var config = {title:result.xcallback.title};
        //~ config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        config.buttons = result.xcallback.buttons;
        config.msg = result.message;
        config.fn = function(buttonId,text,opt) {
          panel.loadMask.show(); 
          //~ Lino.insert_subst_user(p);
          Ext.Ajax.request({
            method: 'GET',
            url: '/callbacks/'+result.xcallback.id + '/' + buttonId,
            //~ params: {bi: buttonId},
            success: Lino.action_handler(panel,on_success,on_confirm)
          });
          //~ Lino.call_ajax_action(panel,'GET',)
        }
        Ext.MessageBox.show(config);
        return;
    }
    
    if (on_success && result.success) on_success(result);
    
    //~ if (on_confirm && result.confirm_message) {
        //~ var config = {title:"Confirmation"};
        //~ // config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        //~ config.msg = result.confirm_message;
        //~ config.fn = function(buttonId,text,opt) {
          //~ if (buttonId == "yes") {
              //~ on_confirm(panel,undefined,result.step);
          //~ }
        //~ }
        //~ Ext.MessageBox.show(config);
        //~ return;
    //~ }
    //~ if (result.dialog_fn) {
        //~ console.log('20120928 TODO',result.dialog_fn);
    //~ }
    if (result.data_record && ! gridmode) {
        //~ not used
        panel.set_status({data_record:result.data_record});
    }  else if (result.new_status && ! gridmode) {
        //~ not used
        //~ console.log('20120607 new_status');
        panel.set_status(result.new_status);
    } else if (result.goto_record_id != undefined && ! gridmode) {
        //~ Uncaught TypeError: Cannot call method 'run' of undefined 
        panel.load_record_id(result.goto_record_id);
    } 
    
    if (result.info_message) {
        console.log(result.info_message);
    }
    
    if (result.warning_message) {
        if (!result.alert) result.alert = "Warning";
        Ext.MessageBox.alert(result.alert,result.warning_message);
    }
    
    if (result.message) {
        //~ if (result.alert && ! gridmode) {
        if (result.alert) { // 20120628b 
            //~ Ext.MessageBox.alert('Alert',result.alert_msg);
            if (result.alert === true) result.alert = "Alert";
            Ext.MessageBox.alert(result.alert,result.message);
        } else {
            Lino.notify(result.message);
        }
    }
     
    if (result.close_window) {
        Lino.close_window();
    }
    
    if (result.refresh_all) {
        var cw = panel.get_containing_window();
        //~ console.log("20120123 refresh_all");
        if (cw) {
          cw.main_item.refresh();
        }
        else console.log("20131026 cannot refresh_all because ",panel,"has no get_containing_window");
    } else {
        console.log("20131026 b gonna refresh",panel);
        if (result.refresh) panel.refresh();
    }
    
    if (result.open_url) {
        //~ console.log(20111126,result.open_url);
        //~ if (!result.message)
            //~ Lino.notify('Open new window <a href="'+result.open_url+'" target="_blank">'+result.open_url+'</a>');
        window.open(result.open_url,'foo',"");
        //~ document.location = result.open_url;
    }
  }
};

Lino.do_action = function(caller,action) { // obsolete but still used for deleting records.
  action.success = function(response) {
    if (caller.loadMask) caller.loadMask.hide();
    //~ console.log('Lino.do_action()',action,'action success',response);
    if (action.after_success) {
        //~ console.log('Lino.do_action() calling after_success');
        action.after_success();
    }
    if (response.responseText) {
      var result = Ext.decode(response.responseText);
      //~ console.log('Lino.do_action()',action.name,'result is',result);
      if (result.message) {
          if (result.alert) {
              //~ Ext.MessageBox.alert('Alert',result.alert_msg);
              Ext.MessageBox.alert('Alert',result.message);
          } else {
              Lino.notify(result.message);
          }
      }
      
      //~ if (result.alert_msg) Ext.MessageBox.alert('Alert',result.alert_msg);
      //~ if (result.message) Lino.notify(result.message);
      if (result.notify_msg) Lino.notify(result.notify_msg);
      if (result.js_code) { 
        //~ console.log('Lino.do_action()',action,'gonna call js_code in',result);
        var jsr = result.js_code(caller);
        //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
        if (action.after_js_code) {
          //~ console.log('Lino.do_action()',action,'gonna call after_js_code');
          action.after_js_code(jsr);
          //~ console.log('Lino.do_action()',action,'returned from after_js_code');
        //~ } else {
          //~ console.log('Lino.do_action()',action,' : after_js_code is false');
        }
      };
    }
  };
  Ext.applyIf(action,{
    waitMsg: "Please wait...",
    failure: Lino.ajax_error_handler(caller),
    params: {}
  });
  //~ action.params.su = Lino.subst_user;
  Lino.insert_subst_user(action.params);
  
  Ext.Ajax.request(action);
};

//~ Lino.gup = function( name )
//~ {
  //~ // Thanks to http://www.netlobo.com/url_query_string_javascript.html
  //~ name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
  //~ var regexS = "[\\?&]"+name+"=([^&#]*)";
  //~ var regex = new RegExp( regexS );
  //~ var results = regex.exec( window.location.href );
  //~ if( results == null )
    //~ return "";
  //~ else
    //~ return results[1];
//~ };

//~ Lino.refresh_handler = function (ww) {
  //~ return function() { 
      //~ console.log('refresh',ww);
      //~ ww.main_item.doLayout(false,true);
      //~ ww.main_item.syncSize();
  //~ }
//~ };

//~ Lino.tools_close_handler = function (ww) {
  //~ return function() { 
      //~ ww.close();
  //~ }
//~ };
Lino.permalink_handler = function (ww) {
  return function() { 
    //~ document.location = ww.main_item.get_permalink();
    //~ console.log('20130723 Lino.permalink_handler',ww);
    
    /* Uncaught TypeError: Cannot read property 'main_item' of null  */
    if (ww) {
        var url = ww.main_item.get_permalink();
    } else {
        var url = Lino.viewport.get_permalink();
    }
    Lino.load_url(url);
  }
};
//~ Lino.run_permalink = function() {
  //~ var plink = Lino.gup('permalink');
  //~ if(plink) { eval('Lino.'+plink); }
//~ }


Lino.ajax_error_handler = function(panel) {
  return function(response,options) {
    console.log('Ajax failure:',response,options);
    if (panel.loadMask) panel.loadMask.hide();
    if (response.responseText) {
      var lines = response.responseText.split('\n');
      if (lines.length > 10) {
          line = lines.splice(5,lines.length-10,"(...)");
      }
      //~ console.log(20131005, response.statusText.toCamel());
      Ext.MessageBox.alert(
        response.statusText.toCamel(),
        lines.join('<br/>')
        //~ response.responseText.replace(/\n/g,'<br/>'))
      )
    } else {
      Ext.MessageBox.alert('Action failed',
        'Lino server did not respond to Ajax request');
    }
  }
}
// Ext.Ajax.on('requestexception',Lino.ajax_error_handler)
 


Ext.QuickTips.init();

/* setting QuickTips dismissDelay to 0 */
// Apply a set of config properties to the singleton
//~ Ext.apply(Ext.QuickTips.getQuickTip(), {
//~ Ext.apply(Ext.ToolTip, {
    //~ dismissDelay: 0
    //~ autoHide: false,
    //~ closable: true,
    //~ maxWidth: 200,
    //~ minWidth: 100,
    //~ showDelay: 50      // Show 50ms after entering target
    //~ ,trackMouse: true
//~ });


//~ Ext.apply(Ext.QuickTip, {
    //~ dismissDelay: 0,
//~ });
  
Lino.quicktip_renderer = function(title,body) {
  return function(c) {
    //~ if (c instanceof Ext.Panel) var t = c.bwrap; else // 20130129
    if (c instanceof Ext.Panel) var t = c.header; else // 20130129
    var t = c.getEl();
    //~ console.log(20130129,t,title,body);
    //~ t.dismissDelay = 0;
    Ext.QuickTips.register({
      target: t,
      //~ cls: 'lino-quicktip-classical',
      dismissDelay: 0,
      //~ autoHide: false,
      showDelay: 50,      // Show 50ms after entering target
      //~ title: title,
      text: body
    });
  }
};


  
Lino.help_text_editor = function() {
  //~ var bp = {
      //~ mk:this.content_type,
      //~ mt:1
    //~ };
    //~ console.log(20120202,bp);
  //~ Lino.lino.ContentTypes.detail({},{base_params:bp});
  //~ Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
  Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
}

// Path to the blank image should point to a valid location on your server
//~ Ext.BLANK_IMAGE_URL = MEDIA_URL + '/extjs/resources/images/default/s.gif'; 


// used as Ext.grid.Column.renderer for id columns in order to hide the special id value -99999
Lino.id_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  return value;
}

Lino.raw_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  return value;
}

Lino.text_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return "not implemented"; 
  return value;
}

Lino.NullNumberColumn = Ext.extend(Ext.grid.Column, {
    align : 'right', 
    format : '0,00/i', 
    renderer : function(value, metaData, record, rowIndex, colIndex, store) {
        //~ console.log(20130128,"NullNumberColumn.renderer",value);
        if (value === null) return '';
        return Ext.util.Format.number(value, this.format);
    }
});

//~ Lino.NullNumberColumn = Ext.extend(Ext.grid.NumberColumn, {
    //~ align : 'right', 
    //~ constructor: function(cfg){
        //~ Ext.grid.NumberColumn.superclass.constructor.call(this, cfg);
        //~ var t = this;
        //~ this.renderer = function(value, metaData, record, rowIndex, colIndex, store) {
          //~ console.log(20130128,"NullNumberColumn.renderer",value);
          //~ if (value === null) return '';
          //~ return Ext.util.Format.number(value, t.format);
      //~ };
    //~ }
//~ });




//~ Lino.cell_button_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return '<input type="button" onclick="alert(value)" value=" ? ">' ;
//~ }


//~ Lino.default_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  //~ return value;
//~ }

Lino.fk_renderer = function(fkname,handlername) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    //~ if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '.run(null,{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

Lino.lfk_renderer = function(panel,fkname) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  var handlername = 'console.log';
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '({},{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

//~ Lino.gfk_renderer = function() {
  //~ return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ if (record.phantom) return '';
    //~ console.log('Lino.gfk_renderer',value,colIndex,record,metaData,store);
    //~ return value;
  //~ }
//~ };


Lino.build_buttons = function(panel,actions) {
  //~ console.log("20121006 Lino.build_buttons",actions);
  if (actions) {
    var buttons = Array(actions.length);
    var cmenu = Array(actions.length);
    for (var i=0; i < actions.length; i++) { 
      var a = actions[i];
      //~ buttons[i] = new Ext.Toolbar.Button(a);
      if (a.menu) a.menu = Lino.build_buttons(panel,a.menu).bbar;
      buttons[i] = a;
      cmenu[i] = {
            text : a.menu_item_text,
            iconCls : a.iconCls,
            menu : a.menu
          };
      if (a.panel_btn_handler) {
          var h = a.panel_btn_handler.createCallback(panel);
          if (a.auto_save == true) {
              h = panel.do_when_clean.createDelegate(panel,[true,h]);
          } else if (a.auto_save == null) {
              h = panel.do_when_clean.createDelegate(panel,[false,h]);
          } else if (a.auto_save == false) {
              // h = h;
          } else {
              console.log("20120703 unhandled auto_save value",a)
          }
          buttons[i].handler = h;
          cmenu[i].handler = h;
          //~ if (buttons[i].xtype == 'splitbutton') {
              //~ cmenu[i].menu = a.menu;
          //~ } else {
              //~ cmenu[i].handler = h;
          //~ }
      } else {
          cmenu[i].handler = a.handler;
      }
    }
    return {bbar:buttons, cmenu:new Ext.menu.Menu(cmenu)};
  }
}

Lino.do_when_visible = function(cmp,todo) {
  //~ if (cmp.el && cmp.el.dom) 
  if (cmp.isVisible()) { 
    // 'visible' means 'rendered and not hidden'
    //~ console.log(cmp.title,'-> cmp is visible now');
    todo(); 
  //~ } else {
      //~ cmp.on('resize',todo,cmp,{single:true});
  //~ }
  //~ if (false) { // 20120213
  } else { 
    //~ console.log('Lino.do_when_visible() must defer because not isVisible()',todo,cmp);
    if (cmp.rendered) {
      //~ console.log(cmp,'-> cmp is rendered but not visible: and now?');
      //~ console.log(cmp.title,'-> cmp is rendered but not visible: try again in a moment...');
      //~ var fn = function() {Lino.do_when_visible(cmp,todo)};
      //~ fn.defer(100);
      
      Lino.do_when_visible.defer(50,this,[cmp,todo]);
      //~ Lino.do_when_visible.defer(100,this,[cmp,todo]);
      
    } else {
      //~ console.log(cmp.title,'-> after render');
      cmp.on('afterrender',todo,cmp,{single:true});
    }
  }
  
};    

/*
*/
Lino.do_on_current_record = function(panel,fn,phantom_fn) {
  var rec = panel.get_current_record();
  if (rec == undefined) {
    Lino.notify("There's no selected record.");
    return;
  }
  // 20120307 A VirtualTable with a Detail (lino.Models) has only "phantom" records.
  if (rec.phantom) {
    //~ if (!panel.editable) { console.log("20120312 not editable:",panel)}
    if (phantom_fn) {
      phantom_fn(panel);
    } else {
      Lino.notify("Action not available on phantom record.");
    }
    return;
  }
  return fn(rec);
};






Lino.call_ajax_action = function(panel,method,url,p,actionName,step,on_confirm,on_success) {
  p.an = actionName;
  if (!panel || !panel.isVisible()) {
  //~ if (true) { // 20131026 : workflow_actions of a newly created record detail executed but did't refresh the screen because their requesting panel was the insert (not the detail) formpanel.
      if (Lino.current_window) 
          panel = Lino.current_window.main_item;
      else panel = Lino.viewport;
  }
  //~ console.log("20130809 Lino.call_ajax_action",panel);
  Ext.apply(p,panel.get_base_params());
  
  if (panel.get_selected) {
      var selected_recs = panel.get_selected();
      //~ console.log("20130831",selected_recs);
      var rs = Array(selected_recs.length);
      for(var i=0; i < selected_recs.length;i++) {
          rs[i] = selected_recs[i].data.id;
      };
      p.sr = rs;
  }
  
  if (panel.loadMask) panel.loadMask.show(); 
  //~ p.$ext_requests.URL_PARAM_SUBST_USER = Lino.subst_user;
  //~ Lino.insert_subst_user(p);
    
  //~ if (step) p['$ext_requests.URL_PARAM_ACTION_STEP'] = step;
  //~ if (pp) pp(p); // "parameter processor" : first used for read beid card
  Ext.Ajax.request({
    method: method
    ,url: url
    ,params: p
    ,success: Lino.action_handler(panel,on_success,on_confirm)
    ,failure: Lino.ajax_error_handler(panel)
  });
};




Lino.row_action_handler = function(actionName,hm,pp) {
  var p = {};
  var fn = function(panel,btn,step) {
      if (pp) { p = pp(panel); if (! p) return; }
      
      if (panel.get_current_record == undefined) { // AFTER_20130725
        panel = Ext.getCmp(panel);
        if (panel == undefined) {
          Lino.notify("Invalid panel spec.");
          return;
        }
      }
      
      Lino.do_on_current_record(panel,function(rec) {
          //~ console.log(panel);
          //~ 20120723 Lino.call_ajax_action(panel,rec.id,actionName,step,fn);
          panel.add_param_values(p,true); // 20130915
          Lino.call_ajax_action(panel,hm,panel.get_record_url(rec.id),p,actionName,step,fn);
          //~ Lino.call_ajax_action(null,hm,panel.get_record_url(rec.id),p,actionName,step,fn);
          // 20131026 tried to not forward panel to ajax call 
      });
  };
  return fn;
};

Lino.list_action_handler = function(ls_url,actionName,hm,pp) {
  var p = {};
  var url = '/api' + ls_url
  var fn = function(panel,btn,step) {
      //~ console.log("20121210 Lino.list_action_handler",arguments);
      //~ var url = ADMIN_URL + '/api' + panel.ls_url
      if (pp) { p = pp(panel);  if (! p) return; }
      panel.add_param_values(p,true); // 20130915
      Lino.call_ajax_action(panel,hm,url,p,actionName,step,fn);
  };
  return fn;
};

Lino.param_action_handler = function(window_action) { // 20121012
  var fn = function(panel,btn,step) {
    Lino.do_on_current_record(panel,function(rec) {
      //~ console.log(panel);
      //~ 20120723 Lino.call_ajax_action(panel,rec.id,actionName,step,fn);
      window_action.run(panel.getId(),{}); 
    });
  };
  return fn;
};


//~ 20130726 Lino.run_row_action = function(requesting_panel,url,pk,actionName,pp) {
Lino.run_row_action = function(requesting_panel,url,meth,pk,actionName,preprocessor) {
  //~ var panel = action.get_window().main_item;
  url = '/api' + url  + '/' + pk;
  var panel = Ext.getCmp(requesting_panel);
  if (preprocessor) var p = preprocessor(); else var p = {};
  var fn = function(panel,btn,step) {
    //~ 20120723 Lino.call_ajax_action(panel,pk,actionName,step,fn);
    //~ 20130726 Lino.call_ajax_action(panel,'GET',url,p,actionName,step,fn);
    Lino.call_ajax_action(panel,meth,url,p,actionName,step,fn);
  }
  fn(panel,null,null);
}

Lino.put = function(requesting_panel,pk,data) {
    var panel = Ext.getCmp(requesting_panel);
    //~ var panel = null; // 20131026
    var p = {};
    p.an = 'put'; // SubmitDetail.action_name
    Ext.apply(p,data);
    var req = {
        params:p
        ,waitMsg: 'Saving your data...'
        ,scope: panel
        ,success: Lino.action_handler( panel, function(result) { 
            panel.refresh();
        })
        ,failure: Lino.ajax_error_handler(panel)
    };
    req.method = 'PUT';
    req.url = '/api' + panel.ls_url + '/' + pk;
    if (panel.loadMask) panel.loadMask.show(); 
    Ext.Ajax.request(req);
}



Lino.show_detail = function(panel,btn) {
  Lino.do_on_current_record(panel, 
    function(rec) {
      //~ panel.loadMask.show();
      Lino.run_detail_handler(panel,rec.id);
    },
    Lino.show_insert
  );
};

Lino.run_detail_handler = function(panel,pk) {
  var bp = panel.get_base_params();
  //~ var bp = {};
  panel.add_param_values(bp); // 20120918
  var status = {
    record_id:pk,
    base_params:bp
    //~ param_values: pv.$ext_requests.URL_PARAM_PARAM_VALUES
  }
  //~ console.log("20120918 Lino.show_detail",status);
  panel.ls_detail_handler.run(null,status);
  //~ panel.loadMask.hide();
  //~ panel.containing_window.window.hideMask();
  //~ panel.el.unmask();
}

Lino.show_fk_detail = function(combo,detail_action,insert_action) {
    //~ console.log("Lino.show_fk_detail",combo,handler);
    pk = combo.getValue();
    if (pk) {
        detail_action.run(null,{record_id: pk})
      } else {
        insert_action.run();
        //~ Lino.notify("Cannot show detail for empty foreign key.");
      }
};

Lino.show_insert = function(panel,btn) {
  var bp = panel.get_base_params();
  //~ console.log('20120125 Lino.show_insert',bp)
  //~ panel.ls_insert_handler.run(null,{record_id:-99999,base_params:bp});
  panel.ls_insert_handler.run(panel.getId(),{record_id:-99999,base_params:bp});
};

//~ Lino.show_insert_duplicate = function(panel,btn) {
  //~ Lino.do_on_current_record(panel,
    //~ function(rec) {
      //~ var newRec = {};
      //~ Ext.apply(newRec,rec);
      //~ newRec.id = -99999;
      //~ panel.ls_insert_handler.run(null,{data_record:rec});
    //~ });
//~ };

//~ Lino.update_row_handler = function(action_name) {
  //~ return function(panel,btn) {
    //~ Lino.notify("Sorry, " + action_name + " is not implemented.");
  //~ }
//~ };




if (Ext.ux.grid !== undefined) {
    Lino.GridFilters = Ext.extend(Ext.ux.grid.GridFilters,{
      encode:true,
      local:false
    });
} else {
    Lino.GridFilters = function() {}; // dummy
    Ext.override(Lino.GridFilters,{
      init : function() {}
    });
};



//~ Lino.ButtonField = Ext.extend(Ext.form.TextField,{
//~ Lino.ButtonField = Ext.extend(Ext.form.Field,{
    //~ editable : false,
    //~ constructor : function(ww,config,params){
      //~ this.containing_window = ww;
      //~ if (params) Ext.apply(config,params);
      //~ Lino.ButtonField.superclass.constructor.call(this, config);
    //~ },
    //~ setButtons : function(buttons){
      //~ console.log('setButtons',buttons);
    //~ },
    //~ onRender : function(ct, position){
        //~ if(!this.el){
            //~ this.panel = new Ext.Container({items:[
              //~ {xtype:'button',text:'upload'},
              //~ {xtype:'button',text:'show'},
              //~ {xtype:'button',text:'edit'}
            //~ ]});
            //~ this.panel.ownerCt = this;
            //~ this.el = this.panel.getEl();

        //~ }
        //~ Lino.ButtonField.superclass.onRender.call(this, ct, position);
    //~ },

  
//~ });

Lino.FieldBoxMixin = {
  before_init : function(config,params) {
    if (params) Ext.apply(config,params);
    var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    if (actions) config.bbar = actions.bbar;
  },
  //~ constructor : function(ww,config,params){
    //~ this.containing_window = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  do_when_clean : function(auto_save,todo) { todo() },
  //~ format_data : function(html) { return '<div class="htmlText">' + html + '</div>' },
  format_data : function(html) { return html },
  get_base_params : function() {
    // needed for insert action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
  },
  set_base_params : function(p) {
    this.base_params = Ext.apply({},p);
    //~ if (p.param_values) this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  },
  set_base_param : function(k,v) {
    this.base_params[k] = v;
  }
};



Lino.HtmlBoxPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,{
  disabled_in_insert_window : true,
  constructor : function(config,params) {
    this.before_init(config,params);
    Lino.HtmlBoxPanel.superclass.constructor.call(this, config);
  },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.constructor.call(this, ww,config,params);
  //~ },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  //~ disable : function() { var tb = this.getBottomToolbar(); if(tb) tb.disable()},
  //~ enable : function() { var tb = this.getBottomToolbar(); if(tb) tb.enable()},
  onRender : function(ct, position){
    Lino.HtmlBoxPanel.superclass.onRender.call(this, ct, position);
    //~ console.log(20111125,this.containing_window);
    if (this.containing_panel) {
      this.containing_panel.on('enable',this.enable,this);
      this.containing_panel.on('disable',this.disable,this);
    }
    this.el.on({
      dragenter:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        return true;
      }
      ,dragover:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        event.stopEvent();
        return true;
      }
      ,drop:{
        scope:this
        ,fn:function(event){
          event.stopEvent();
          //~ console.log(20110516);
          var files = event.browserEvent.dataTransfer.files;
          if(files === undefined){
            return true;
          }
          var len = files.length;
          while(--len >= 0){
            console.log(files[len]);
            //~ this.processDragAndDropFileUpload(files[len]);
          }
          Lino.show_insert(this);
        }
      }
    });
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    //~ if (this.master_panel) {
      var record = this.containing_panel.get_current_record();
      //~ console.log('HtmlBox.refresh()',this.title,record,record.title);
      var box = this.items.get(0);
      var todo = function() {
        if (this.disabled) return;
        //~ this.set_base_params(this.containing_window.get_base_params());
        this.set_base_params(this.containing_panel.get_master_params());
        var el = box.getEl();
        if (el) {
          el.update(record ? this.format_data(record.data[this.name]) : '');
          //~ console.log('20130723 HtmlBox.refresh()',this.name);
        //~ } else {
          //~ console.log('HtmlBox.refresh() failed for',this.name);
        }
      };
      Lino.do_when_visible(box,todo.createDelegate(this));
    //~ }
  }
});
//~ Ext.override(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);



Lino.RichTextPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,Lino.FieldBoxMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,{
    
  //~ initComponent : function(){
    //~ Lino.RichTextPanel.superclass.initComponent.call(this);
  //~ },
  constructor : function(config,params) {
    //~ console.log('Lino.RichTextPanel.initComponent',this);
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + String(rec.id) + "/" + config.name;
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + config.name;
    var t = this;
    var tinymce_options = {
        theme : "advanced",
        content_css: '/media/lino/extjs/lino.css',
        language: 'en',
        //~ template_external_list_url : url,
        theme_advanced_toolbar_location : "top",
        theme_advanced_toolbar_align : "left",
        theme_advanced_statusbar_location : "bottom",
        template_popup_width : 700,
        template_popup_height : 500,
        template_replace_values : { 
            data_field : function(element){ 
                //~ console.log(20110722,fieldName,t.containing_window.get_current_record()); 
                var fieldName = element.innerHTML;
                element.innerHTML = t.containing_panel.get_current_record().data[fieldName];
            } 
        }
      };
      
    var editorConfig = {
      tinymceSettings: {
        plugins : "noneditable,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "bold,italic,underline,|,justifyleft,justifycenter,justifyright,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,removeformat,template",
        theme_advanced_buttons2 : "",
        theme_advanced_buttons3 : "", // ,|,sub,sup,|,charmap",      
        theme_advanced_resizing : false
        //~ save_onsavecallback : save_callback,
        //~ save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
        
    }};
    Ext.apply(editorConfig.tinymceSettings,tinymce_options);
    //~ editorConfig.name = config.action_name;
    editorConfig.name = config.name;
    delete config.name;
    //~ config.title = config.label;
    //~ delete config.label;
    this.before_init(config,params);
    
    this.editor = new Ext.ux.TinyMCE(editorConfig);
    var t = this;
    config.tools = [{
                      qtip: "Edit text in own window", 
                      id: "up",
                      handler: function(){
                        if(t.editor.isDirty()) {
                            var record = t.containing_panel.get_current_record();
                            record.data[t.editor.name] = t.editor.getValue();
                        }
                        Lino.edit_tinymce_text(t,tinymce_options)
                      }
                    }];
    
    config.items = this.editor;
    config.layout = "fit";
    Lino.RichTextPanel.superclass.constructor.call(this, config);
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    var record = this.containing_panel.get_current_record();
    //~ console.log('RichTextPanel.refresh()',this.title,record.title,record);
    var todo = function() {
      //~ this.set_base_params(this.containing_window.get_base_params());
      if (record) {
        var url = '/templates' + this.containing_panel.ls_url + "/" 
            + String(record.id) + "/" + this.editor.name;
        //~ console.log('RichTextPanel.refresh()',url);
        if (this.editor.ed) this.editor.ed.settings.template_external_list_url = url;
        this.set_base_params(this.containing_panel.get_master_params());
        //~ var v = record ? this.format_data(record.data[this.editor.name]) : ''
        var v = this.format_data(record.data[this.editor.name])
        this.editor.setValue(v);
      } else {
        this.editor.setValue('(no data)');
      }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
//~ Ext.override(Lino.RichTextPanel,Lino.FieldBoxMixin);



Lino.ActionFormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,Lino.PanelMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,Lino.FieldBoxMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  //~ layout:'fit'
  //~ ,autoHeight: true
  //~ ,frame: true
  window_title: "Action Parameters",
  constructor : function(config){
    config.bbar = [
        {text:'OK',handler:this.on_ok,scope:this},
        {text:'Cancel',handler:this.on_cancel,scope:this}
    ];
    //~ config.items = config.params_panel;
    Lino.ActionFormPanel.superclass.constructor.call(this, config);
  }
  //~ ,initComponent : function(){
    //~ Lino.ActionFormPanel.superclass.initComponent.call(this);
  //~ }
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
    //~ var rp = this.requesting_panel;
    var panel = this.requesting_panel;
    //~ console.log("20131004 on_ok",this,panel,arguments);
    //~ if (panel == undefined) {
        //~ Lino.alert("Sorry, dialog actions don't work without a requesting_panel");
        //~ return;
    //~ }
    //~ var rec = panel.get_current_record();
    var actionName = this.action_name;
    var pk = this.base_params.mk;
    if (pk == undefined && panel) {
        pk = panel.get_current_record().id;
    }
    if (pk == undefined) {
        Lino.alert("Sorry, dialog action without base_params.mk");
        return;
    }
    var self = this;
    function on_success() { self.get_containing_window().close(); };
    // 20131004
    //~ var url = '/api' + this.ls_url + '/' + pk;
    var url = '/api' + panel.ls_url + '/' + pk;
    var fn = function(panel,btn,step) {
      var p = {};
      self.add_field_values(p)
      //~ Lino.call_ajax_action(panel,'GET',panel.get_record_url(rec.id),p,actionName,step,fn,on_success);
      Lino.call_ajax_action(panel,'GET',url,p,actionName,step,fn,on_success);
    }
    fn(panel,null,null);
    
    
  }
  ,set_status : function(status,rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 ActionFormPanel.set_status()',status,rp,this.requesting_panel);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_field_values(status.field_values);
    if (status.base_params) this.set_base_params(status.base_params);
  }
  
  ,add_field_values : function (p) { // similar to add_param_values()
      //~ 20121023 
      if (this.form.isDirty()) {
        p.fv = this.get_field_values();
      }else{
        if (this.status_field_values) 
          p.fv = Lino.fields2array(this.fields,this.status_field_values);
      }
      //~ if (!this.form.isDirty()) return;
      //~ p.$ext_requests.URL_PARAM_FIELD_VALUES = this.get_field_values();
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
  }
  ,get_field_values : function() {
      return Lino.fields2array(this.fields);
  }
  ,set_field_values : function(pv) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_field_values = pv;
      if (pv) this.form.my_loadRecord(pv);
      else this.form.reset(); 
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.title = this.window_title;
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok }
      ]
  }
});

//~ Lino.add_blank = function(oa) {
    //~ return [].concat(oa)
    //~ return 
    //~ }
    
Lino.fields2array = function(fields,values) {
    //~ console.log('20130605 fields2array gonna loop on', fields,values);
    var pv = Array(fields.length);
    for(var i=0; i < fields.length;i++) {
        var f = fields[i]
        if (values) 
          var v = values[f.name];
        else 
          var v = f.getValue();
        if (f.formatDate) {
            pv[i] = f.formatDate(v); 
        } else {
            pv[i] = v; // f.getValue(); 
        }
    }
    return pv;
}


Lino.FormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.FormPanel = Ext.extend(Lino.FormPanel,Lino.PanelMixin);
Lino.FormPanel = Ext.extend(Lino.FormPanel,{
  params_panel_hidden : false,
  //~ base_params : {},
  //~ trackResetOnLoad : true,
  //~ query_params : {},
  //~ 20110119b quick_search_text : '',
  constructor : function(config,params){
    if (params) Ext.apply(config,params);
    this.base_params = {};
    //~ ww.config.base_params.query = ''; // 20111018
    //~ console.log(config);
    //~ console.log('FormPanel.constructor() 1',config)
    //~ Ext.applyIf(config,{base_params:{}});
    //~ console.log('FormPanel.constructor() 2',config)
      
    config.trackResetOnLoad = true;
    
    Lino.FormPanel.superclass.constructor.call(this, config);
      
    //~ this.set_base_param('$URL_PARAM_FILTER',null); // 20111018
    //~ this.set_base_param('$URL_PARAM_FILTER',''); // 20111018
      
  },
  initComponent : function(){
    
    //~ console.log("20111201 containing_window",this.containing_window,this);
    
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    if (actions) {
        this.bbar = actions.bbar;
    //~ } else {
        //~ this.bbar = [];
    }
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ var config = this;
    
    //~ if (this.containing_window instanceof Lino.DetailWrapper) {
    
    //~ console.log('20120121 initComponent', this.action_name);
    //~ if (this.action_name == 'detail' | this.action_name == 'show') {
    //~ if (this.action_name != 'insert') {
    if (! this.hide_top_toolbar) {
      this.tbar = [];
      // 20111015    
      if (! this.hide_navigator) {
        this.record_selector = new Lino.RemoteComboFieldElement({
          store: new Lino.ComplexRemoteComboStore({
            //~ baseParams: this.containing_window.config.base_params,
            baseParams: this.get_base_params(),
            //~ value: this.containing_window.config.base_params.query,
            proxy: new Ext.data.HttpProxy({
              url: '/choices' + this.ls_url,
              method:'GET'
            })
          }),
          pageSize:25,
          listeners: { 
            scope:this, 
            select:function(combo,record,index) {
              //~ console.log('jumpto_select',arguments);
              this.goto_record_id(record.id);
            }
          },
          emptyText: "Go to record"
        })
        this.tbar = this.tbar.concat([this.record_selector]);
        
        this.tbar = this.tbar.concat([
          this.first = new Ext.Toolbar.Button({
            tooltip:"First",disabled:true,handler:this.moveFirst,scope:this,iconCls:'x-tbar-page-first'}),
          this.prev = new Ext.Toolbar.Button({
            tooltip:"Previous",disabled:true,handler:this.movePrev,scope:this,iconCls:'x-tbar-page-prev'}),
          this.next = new Ext.Toolbar.Button({
            tooltip:"Next",disabled:true,handler:this.moveNext,scope:this,iconCls:'x-tbar-page-next'}),
          this.last = new Ext.Toolbar.Button({
            tooltip:"Last",disabled:true,handler:this.moveLast,scope:this,iconCls:'x-tbar-page-last'})
        ]);
      }
      this.tbar = this.add_params_panel(this.tbar);
      
      //~ console.log(20101117,this.containing_window.refresh);
      this.tbar = this.tbar.concat([
        {
          //~ text:'Refresh',
          handler:function(){ this.do_when_clean(true,this.refresh.createDelegate(this)) },
          iconCls: 'x-tbar-loading',
          tooltip:"Reload current record",
          scope:this}
      ]);
          
      if (this.bbar) { // since 20121016
        if (this.tbar) {
            this.tbar = this.tbar.concat(['-']) ;
        } else {
          this.tbar = [];
        }
        this.tbar = this.tbar.concat(this.bbar) ;
        this.bbar = undefined;
      }
    
      this.tbar = this.tbar.concat([
          '->',
          this.displayItem = new Ext.Toolbar.TextItem({})
      ]);
          
    }
    //~ if (this.content_type && this.action_name != 'insert') {
      //~ this.bbar = this.bbar.concat([
        //~ '->',
        //~ { text: "[$_('Help Text Editor')]",
          //~ handler: Lino.help_text_editor,
          //~ qtip: "$_('Edit help texts for fields on this model.')",
          //~ scope: this}
      //~ ])
    //~ }
    //~ this.before_row_edit = config.before_row_edit.createDelegate(this);
      
    //~ if (this.master_panel) {
        //~ this.set_base_params(this.master_panel.get_master_params());
    //~ }
      
    Lino.FormPanel.superclass.initComponent.call(this);
    
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.bwrap,{msg:"Please wait..."});
    },this);
    
    
    //~ var this_ = this;
    //~ this.cascade(function(cmp){
      //~ // var active_field = false;
      //~ for (i = 0; i < this_.active_fields.length; i++) {
        //~ if (cmp.name == this_.active_fields[i]) {
            //~ // active_field = true; break;
            //~ cmp.on("change",function() {this_.save()});
        //~ }
      //~ };
      //~ if (active_field) {
      // if (cmp instanceof Lino.GridPanel) {
          //~ cmp.on("change",function() {this_.save()});
      //~ }
    //~ });
    
    if (this.action_name == 'insert') {
      this.cascade(function(cmp){
        // console.log('20110613 cascade',cmp);
        if (cmp.disabled_in_insert_window) {
            //~ cmp.disable();
            cmp.hide();
        }
      });
      
    }
    
  },
  
  unused_is_loading : function() { 
    if (this.current_record == null) {
        //~ console.log("20130515 current_record is null");
        return true; 
    }
    
    if (! this.loadMask) return true; // not even rendered: 
    if (! this.loadMask.el) return true; // not even rendered: 
    // thanks to Marco Pegoraro http://movableapp.com/2011/09/sencha-touch-loadmask-isvisible/
    var loading = (this.loadMask.el.select('.x-loading-msg').elements.length > 0);
    //~ console.log('20130515 GridPanel.is_loading() returns',loading);
    return loading;

    
    var loading = false;
    this.cascade(function(cmp){
        if (cmp instanceof Lino.GridPanel && cmp.is_loading()) {
            //~ console.log(20130515, cmp.title,'is loading');
            loading = true;
            return false;
        }
      });
    return loading;
    //~ var a = this.findByType(Lino.GridPanel);
    //~ for (i=0;i<a.length;i++) {
        //~ if (a[i].is_loading()) return true;
    //~ }
    //~ return false;
  },
  
  get_status : function(){
      var st = {
        base_params: this.get_base_params(),
        data_record : this.get_current_record()
        }
      var tp = this.items.get(0);
      if (tp instanceof Ext.TabPanel) {
        st.active_tab = tp.getActiveTab();
      }
      st.param_values = this.status_param_values;
      return st;
  },
  /* FormPanel */
  set_status : function(status,rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 FormPanel.set_status()',status);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_param_values(status.param_values);
    if (status.base_params) this.set_base_params(status.base_params);
    var tp = this.items.get(0);
    if (tp instanceof Ext.TabPanel) {
      if (status.active_tab) {
        //~ console.log('20111201 active_tab',this.active_tab,this.items.get(0));
        //~ tp.activeTab = status.active_tab;
        tp.setActiveTab(status.active_tab);
        //~ this.main_item.items.get(0).activate(status.active_tab);
      } else {
        tp.setActiveTab(0);
      }
      }
    
    if (status.data_record) {
      //~ console.log('20111201 Lino.FormPanel with data_record',this.data_record.title,this.containing_window);
      //~ this.main_item.on_master_changed.defer(2000,this.main_item,[status.data_record]);
      //~ Lino.do_when_visible(this.main_item,function(){this.on_master_changed(status.data_record)});
      //~ this.main_item.on('afterrender',function(){
      //~   this.main_item.on_master_changed(status.data_record)},this,{single:true});
      /* must defer because because set_window_title() didn't work otherwise */
      this.set_current_record.createDelegate(this,[status.data_record]).defer(100);
      //~ this.set_current_record(this.data_record);
      //~ return;
    } else if (status.record_id != undefined) { 
      /* possible values include 0 and null, 0 being a valid record id, 
      null the equivalent of undefined
      */
      //~ this.main_item.goto_record_id(this.status.record_id);
      this.load_record_id(status.record_id);
    } else {
      this.set_current_record(undefined);
    }
  },
    
  get_base_params : function() {
    // needed for insert_action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
    //~ return this.base_params;
  },
  set_base_params : function(p) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    delete p['query'] // 20120725
    Ext.apply(this.base_params,p);
    if (this.record_selector) {
        var store = this.record_selector.getStore();
        for (k in p) store.setBaseParam(k,p[k]);
        delete this.record_selector.lastQuery;
        //~ console.log("20120725 record_selector.setBaseParam",p)
    }
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
        
      //~ if (this.record_selector) {
          //~ var store = this.record_selector.getStore();
          //~ for (k in store.baseParams) store.setBaseParam(k,undefined);
          //~ delete this.record_selector.lastQuery;
          //~ console.log("20120725 record_selector.getBaseParams() -->",store.baseParams)
      //~ }
  },
  set_base_param : function(k,v) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    this.base_params[k] = v;
    //~ if (this.record_selector) {
        //~ this.record_selector.getStore().setBaseParam(k,v);
        //~ delete this.record_selector.lastQuery;
    //~ }
  },
  
  after_delete : function() {
    if (this.current_record.navinfo.next)
      this.moveNext();
    else if (this.current_record.navinfo.prev)
      this.movePrev();
    else 
      this.abandon();
  },
  moveFirst : function() {this.goto_record_id(this.current_record.navinfo.first)},
  movePrev : function() {this.goto_record_id(this.current_record.navinfo.prev)},
  moveNext : function() {this.goto_record_id(this.current_record.navinfo.next)},
  moveLast : function() {this.goto_record_id(this.current_record.navinfo.last)},
  
  
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ console.log('20120121 Lino.FormPanel.refresh()',this);
    if (this.current_record) {
        this.load_record_id(this.current_record.id,after);
    } else {
        this.set_current_record(undefined,after);
    }
  },
  
  do_when_clean : function(auto_save,todo) {
    var this_ = this;
    if (this.form.isDirty()) {
        if (auto_save) {
            this_.save(todo);
        } else {
          //~ console.log('20111217 do_when_clean() form is dirty',this.form);
          var config = {title:"Confirmation"};
          config.buttons = Ext.MessageBox.YESNOCANCEL;
          config.msg = "Save changes to current record ?";
          config.fn = function(buttonId,text,opt) {
            //~ console.log('do_when_clean',buttonId)
            if (buttonId == "yes") {
                //~ Lino.submit_detail(this_,undefined,todo);
                //~ this_.containing_window.save(todo);
                this_.save(todo);
            } else if (buttonId == "no") { 
              todo();
            }
          }
        }
        Ext.MessageBox.show(config);
    }else{
      //~ console.log('do_when_clean : now!')
      todo();
    }
  },
  
  goto_record_id : function(record_id) {
    //~ console.log('20110701 Lino.FormPanel.goto_record_id()',record_id);
    //~ var this_ = this;
    //~ this.do_when_clean(function() { this_.load_record_id(record_id) }
    this.do_when_clean(true,this.load_record_id.createDelegate(this,[record_id]));
  },
  
  load_record_id : function(record_id,after) {
    var this_ = this;
    //~ var p = { fmt: this.containing_window.config.action_name};
    //~ var p = Ext.apply({},this.containing_window.config.base_params);
    var p = Ext.apply({},this.get_base_params());
    //~ Lino.insert_subst_user(p);
    //~ console.log('20110713 action_name=',this.containing_window.config.action_name,
      //~ 'base_params=',this.containing_window.config.base_params);
    if (this.action_name)
        p.an = this.action_name;
    //~ p.an = this.action_name;
    //~ p.an = this.containing_window.config.action_name;
    //~ p.fmt = 'json';
    //~ p.fmt = '$ext_requests.URL_FORMAT_JSON';
    p.rp = this.getId();
    //~ p.$ext_requests.URL_PARAM_SUBST_USER = Lino.subst_user;
    p.fmt = 'json';
    //~ 20110119b p['$URL_PARAM_FILTER'] = this.quick_search_text;
    //~ Ext.apply(p,this.query_params);
    this.add_param_values(p);
    //~ console.log('20121120 FormPanel.load_record_id',record_id,p);
    if (this.loadMask) this.loadMask.show();
    Ext.Ajax.request({ 
      waitMsg: 'Loading record...',
      method: 'GET',
      params: p,
      scope: this,
      url: this.get_record_url(record_id),
      success: function(response) {   
        // todo: convert to Lino.action_handler.... but result 
        if (this.loadMask) this.loadMask.hide();
        if (response.responseText) {
          var rec = Ext.decode(response.responseText);
          //~ console.log('20120918 goto_record_id success',rec);
          this.set_param_values(rec.param_values);
          this.set_current_record(rec,after);
        }
      },
      failure: Lino.ajax_error_handler(this)
    });
  },

  abandon : function () {
    Ext.MessageBox.alert('Note',
      "No more records to display. Detail window has been closed.");
    Lino.close_window();
    //~ if (this.containing_window) {
        //~ this.containing_window.hide();
    //~ }
  },
  
  set_current_record : function(record,after) {
    //~ console.log('20120722 Lino.FormPanel.set_current_record',record.title,record);
    if (this.record_selector) {
        this.record_selector.clearValue();
        // e.g. InsertWrapper FormPanel doesn't have a record_selector
    }
    this.current_record = record;
    //~ if (record) 
        //~ console.log('Lino.FormPanel.set_current_record',record.title,record);
    //~ else
        //~ console.log('Lino.FormPanel.set_current_record',record);
    //~ this.config.main_panel.form.load(record);    
    if (record) {
      this.enable();
      this.form.my_loadRecord(record.data);
      this.set_window_title(record.title);
      //~ this.getBottomToolbar().enable();
      var da = record.data.disabled_actions;
      if (da) {
          //~ console.log('20120528 disabled_actions =',da,this.getBottomToolbar());
          //~ 20121016 this.getBottomToolbar().items.each(function(item,index,length){
          var tb = this.getTopToolbar();
          if (tb) tb.items.each(function(item,index,length){
              //~ console.log('20120528 ',item.itemId,'-->',da[item.itemId]);
              if (da[item.itemId]) item.disable(); else item.enable();
          });
      };
      if (this.disable_editing | record.data.disable_editing) {
          //~ console.log("20120202 disable_editing",record.title);
          this.form.items.each(function(cmp){
            if (!cmp.always_enabled) cmp.disable();
          },this);
      } else {
          this.form.items.each(function(cmp){
            //~ console.log("20120202",cmp);
            if (record.data.disabled_fields[cmp.name]) cmp.disable();
            else cmp.enable();
          },this);
        
          //~ if (record.data.disabled_fields) {
              //~ for (i = 0; i < record.data.disabled_fields.length; i++) {
                  //~ var flds = this.find('name',record.data.disabled_fields[i]);
                  //~ if (flds.length == 1) { 
                    //~ flds[0].disable(); 
                  //~ }
              //~ }
          //~ }
      };
      if (this.first) {
        if (record.navinfo  && ! this.hide_navigator) {
          this.first.setDisabled(!record.navinfo.first);
          this.prev.setDisabled(!record.navinfo.prev);
          this.next.setDisabled(!record.navinfo.next);
          this.last.setDisabled(!record.navinfo.last);
          this.displayItem.setText(record.navinfo.message);
        } else {
          this.first.setDisabled(true);
          this.prev.setDisabled(true);
          this.next.setDisabled(true);
          this.last.setDisabled(true);
        }
      }
    } else {
      if (this.form.rendered) 
        this.form.reset(); /* FileUploadField would fail when resetting a non-rendered form */
      //~ this.disable();
      //~ this.getBottomToolbar().disable();
      this.form.items.each(function(cmp){
        cmp.disable();
      },this);
      this.set_window_title(this.empty_title);
      //~ this.containing_window.window.setTitle(this.empty_title);
      if (!this.hide_navigator) {
        this.first.disable();
        this.prev.disable();
        this.next.disable();
        this.last.disable();
      }
    }
    //~ console.log('20100531 Lino.DetailMixin.on_load_master_record',this.main_form);
    this.before_row_edit(record);
    if (after) after();
  },
  
  before_row_edit : function(record) {},
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.refresh();
  },
  
  get_selected : function() { return [ this.current_record ] },
  get_current_record : function() {  
    //~ console.log(20100714,this.current_record);
    return this.current_record 
  },
  
  get_permalink_url : function() {
      var rec = this.get_current_record();
      if (rec && ! rec.phantom && rec.id != -99998)
          return '/api' + this.ls_url + '/' + rec.id;
      return '/api' + this.ls_url;
    
  },
  get_permalink_params : function() {
    var p = {};
    //~ var p = {an:'detail'};
    if (this.action_name)
        p.an = this.action_name;
    //~ var p = {an:this.action_name};
    var main = this.items.get(0);
    if (main.activeTab) {
      var tab = main.items.indexOf(main.activeTab);
      //~ console.log('main.activeTab',tab,main.activeTab);
      if (tab) p.tab = tab;
    }
    this.add_param_values(p)
    return p;
  },
  
  /* 
  Lino.FormPanel.save() 
  */
  save : function(after,switch_to_detail,action_name) {
    //~ var panel = this;
    //~ console.log('20121120 FormPanel.save');
    this.loadMask.show();
    var rec = this.get_current_record();
    if (this.has_file_upload) this.form.fileUpload = true;
    //~ console.log('FormPanel.save()',rec);
    if (!action_name) action_name = this.action_name;
    if (rec) {
      var p = {};
      Ext.apply(p,this.get_base_params());
      p.rp = this.getId();
      //~ if (this.action_name) 
          //~ p.$ext_requests.URL_PARAM_ACTION_NAME = this.action_name;
      p.an = action_name;
      if (rec.phantom) {
        //~ if (this.action_name != 'insert') 
            //~ console.log("Warning: phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: '/api' + this.ls_url,
          method: 'POST',
          params: p, 
          scope: this,
          success: function(form, action) {
            this.loadMask.hide();
            Lino.notify(action.result.message);
            /***
            Close this window, but update the status of the 
            calling window.
            If the calling window is a detail on the same table,
            then it should skip to the new record. But only then.
            A successful response usually has a data_record,
            except if it is a fileupload form where some mysterious 
            decoding problems (20120209) force us to return a record_id 
            which will lead to an additional GET.
            ***/
            var url = this.ls_url;
            var ww = Lino.calling_window();
            if (ww && ww.window.main_item instanceof Lino.FormPanel 
                   && ww.window.main_item.ls_url == this.ls_url) {
                //~ console.log("20120217 case 1");
                ww.status.record_id = action.result.record_id;
                ww.status.data_record = action.result.data_record;
                Lino.close_window();
            } else if (this.ls_detail_handler && switch_to_detail) {
                //~ console.log("20120217 case 2");
                Lino.kill_current_window();
                this.ls_detail_handler.run(null,{
                    record_id:action.result.record_id,
                    data_record: action.result.data_record,
                    base_params:this.get_base_params()
                });
            } else {
                //~ console.log("20120217 case 3");
                Lino.close_window();
            }
            //~ Lino.close_window(function(ww){
                //~ if (ww.window.main_item instanceof Lino.FormPanel 
                    //~ && ww.window.main_item.ls_url == url) {
                  //~ ww.status.record_id = action.result.record_id,
                  //~ ww.status.data_record = action.result.data_record
                //~ }
            //~ });
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action);
          },
          clientValidation: true
        })
      } else {
        //~ if (this.action_name != 'detail') 
            //~ console.log("Warning: non-phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: '/api' + this.ls_url + '/' + rec.id,
          method: 'PUT',
          //~ headers: { 'HTTP_X_REQUESTED_WITH' : 'XMLHttpRequest'},
          scope: this,
          params: p, 
          success: function(form, action) {
            //~ panel.form.setValues(rec.data);
            //~ 20110701 panel.form.my_loadRecord(rec);
            this.loadMask.hide();
            Lino.notify(action.result.message);
            if (action.result.data_record)
                this.set_current_record(action.result.data_record,after);
            else
                console.log("Warning: no data_record in response to FormPanel.PUT")
            //~ this.refresh_with_after(after);
            //~ if (after) after(); else panel.refresh();
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action)},
          clientValidation: true
        })
      }
    } else Lino.notify("Sorry, no current record.");
  }
  
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
      this.save(null,true);
      //~ var rec = this.get_current_record();
      //~ if (rec && rec.phantom)
          //~ this.do_when_clean(true,function() { Lino.close_window(); });
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok, scope:this }
        ,{ key: Ext.EventObject.ESCAPE, fn: this.on_cancel, scope:this }
      ]
  }
  
  
  /* not used (no longer possible without .dtl files)
  , edit_detail_config : function () {
    var active_tab = {};
    var main = this.items.get(0);
    if (main.getActiveTab !== undefined) {
      var tabitem = main.getActiveTab();
      Ext.apply(active_tab,{$ext_requests.URL_PARAM_TAB : main.items.indexOf(tabitem)});
    }
    var editor = new Ext.form.TextArea();
    var close = function() { win.close(); }
    var _this = this;
    var save = function() { 
      //~ console.log(20110609,arguments); 
      var params = {desc: editor.getValue()};
      Ext.apply(params,active_tab);
      var a = { 
        params: params, 
        method: 'PUT',
        url: ADMIN_URL + '/detail_config' + _this.ls_url,
        failure : Lino.ajax_error_handler(this),
        success: Lino.action_handler( _this, function(result) {
          //~ console.log('detail_config/save success',result);
          win.close();
          document.location = _this.get_permalink();
        })
      };
      //~ console.log('detail_config/save sent',a);
      _this.loadMask.show(); // 20120211
      Ext.Ajax.request(a);
    }
    var save_btn = new Ext.Button({text:'Save',handler:save,disabled:true});
    var win = new Ext.Window({title:'Detail Layout',
      items:editor, layout:'fit',
      width:500,height:500,
      bbar:[{text:'Cancel',handler:close},save_btn]});
    var a = { 
      params:active_tab, 
      method:'GET',
      url:ADMIN_URL+'/detail_config'+_this.ls_url,
      success : function(response) {
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          if (result.success) {
            editor.setValue(result.desc);
            save_btn.enable();
          }
        }
      }
    };
    Ext.Ajax.request(a);
    win.show();
  }
  */
});



Lino.getRowClass = function(record, rowIndex, rowParams, store) {
    //~ console.log(20130816,record);
    //~ return 'x-grid3-row-green';
    //~ return record.data.row_class + ' auto-height';
    return record.data.row_class;
  //~ if (true) {
      //~ return 'x-grid3-row-red';
  //~ }
  //~ if (record.phantom) {
    //~ console.log(20101009,record);
    //~ rowParams.bodyStyle = "color:red;background-color:blue";
    //~ return 'lino-phantom-row';
    //~ }
  //~ console.log('20101009 not a phantom:',record);
  //~ return '';
}

//~ FOO = 0;



Lino.GridStore = Ext.extend(Ext.data.ArrayStore,{ 
  autoLoad: false
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
    if (!options) options = {};
    if (!options.params) options.params = {};
    options.params.fmt = 'json';
    options.params.rp = this.grid_panel.getId();
    Lino.insert_subst_user(options.params); // since 20121016
      
    if (this.grid_panel.hide_top_toolbar) {
        //~ console.log("20120206 GridStore.load() toolbar is hidden");
        options.params.start = 0;
        if (this.grid_panel.preview_limit) {
          options.params.limit = this.grid_panel.preview_limit;
        }
    } else {
        var ps = this.grid_panel.calculatePageSize();
        if (!ps) {
            //~ this.gridpanel.on('render',this.load())
          //~ console.log("20120814 GridStore.load() failed to calculate pagesize");
          return false;
            //~ params.$URL_PARAM_LIMIT = 1;
            //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
            //~ return;
        } 
        options.params.limit = ps;
      
        //~ options.params.start = this.grid_panel.getTopToolbar().cursor;
        //~ if (this.grid_panel.getTopToolbar().pageSize !=  ps) {
          //~ console.log("20120206 abort load because toolbar says pagesize",
            //~ this.grid_panel.getTopToolbar().pageSize,
            //~ "while actual pagesize is",ps);
            //~ return;
        //~ }
        
        this.grid_panel.getTopToolbar().pageSize =  ps;
        if (options.params.start == undefined)
            options.params.start = this.grid_panel.getTopToolbar().cursor;
      
    }
      
    this.grid_panel.add_param_values(options.params);
    //~ Lino.insert_subst_user(options.params);
    //~ console.log("20120814 GridStore.load()",options.params,this.baseParams);
    //~ if (FOO > 0) {
        //~ foo.bar = baz;
    //~ } else FOO += 1;
    return Lino.GridStore.superclass.load.call(this,options);
  }
});

Lino.get_current_grid_config = function(panel) {
    return panel.get_current_grid_config();
}


// Like the default value for GridView.cellTpl but adds a class "lino-auto-height"
Lino.auto_height_cell_template = new Ext.Template(
'<td class="x-grid3-col x-grid3-cell x-grid3-td-{id} {css}" style="{style}" tabIndex="0" {cellAttr}>',
    '<div class="lino-auto-height x-grid3-cell-inner x-grid3-col-{id}" unselectable="on" {attr}>{value}</div>',
'</td>'
);

Lino.GridPanel = Ext.extend(Ext.grid.EditorGridPanel,Lino.MainPanel);
Lino.GridPanel = Ext.extend(Lino.GridPanel,Lino.PanelMixin);
Lino.GridPanel = Ext.extend(Lino.GridPanel,{
  quick_search_text : '',
  is_searching : false,
  disabled_in_insert_window : true,
  clicksToEdit:2,
  enableColLock: false,
  autoHeight: false,
  params_panel_hidden : false,
  preview_limit : undefined, 
  //~ loadMask: true,
  //~ viewConfig: {
          //~ getRowClass: Lino.getRowClass,
          //~ emptyText:"$_('No data to display.')"
        //~ },
        
        
  loadMask: {msg:"Please wait..."},
  
  constructor : function(config){

    config.plugins = [new Lino.GridFilters()];
    
    
    Lino.GridPanel.superclass.constructor.call(this,config);
    
    //~ if (this.containing_window) {
        //~ console.log("20111206 install refresh");
        //~ this.containing_window.on('show',this.refresh,this);
    //~ }
    
  },
  
  unused_is_loading : function() { 
    if (! this.loadMask.el) return true; // not even rendered: 
    // thanks to Marco Pegoraro http://movableapp.com/2011/09/sencha-touch-loadmask-isvisible/
    var loading = (this.loadMask.el.select('.x-loading-msg').elements.length > 0);
    //~ console.log('20130515 GridPanel.is_loading() returns',loading);
    return loading;
    //~ return this.store.getCount() > 0; 
    //~ return (this.loadMask.el.select('.x-loading-msg').elements.length)
    //~ return !this.viewReady; 
    //~ return this.loadMask.isVisible(); 
    //~ return !this.loadMask.disabled; 
  },
  
  unused_config_containing_window : function(wincfg) { 
      //~ temporarily remove save_grid_config button (see /blog(2012/1107)
      if (wincfg.tools != undefined) 
        wincfg.tools = [
          //~ {handler:this.save_grid_data,
            //~ qtip:"$_("Save Grid Data")",
            //~ scope:this, id:"save_data"}, // 20120814
          {handler:this.save_grid_config,
            qtip:"Save Grid Configuration",
            scope:this, id:"save"}
        ].concat(wincfg.tools);
      //~ wincfg.listeners = { show: ... };
  },
  init_containing_window : function(win) { 
    //~ console.log("20111206 install refresh");
    //~ win.on('show',this.refresh,this);
  },
  
  initComponent : function(){
    
    /* 
    Problem 20111206:
    When a GridPanel is the main item of the window, then it doesn't 
    have it's own header but uses the window's header bar.
    We must do this in initComponent because e.g. in beforerender 
    it's already to late: a header element has been created because 
    there was a title.
    But Lino.Window adds itself as `this.containing_window` 
    only after the GridPanel has been initialized.
    Workaround is to generate a line "params.containing_window = true;" 
    in the handler function.
    */ 
    //~ if (this.containing_window) {
    if (this.is_main_window) {
        //~ console.log(20111206, 'delete title',this.title,'from',this);
        //~ delete this.title;
        this.tools = undefined;  
        this.title = undefined;  /* simply deleting it 
          isn't enough because that would only 
          unhide the title defined in some base class. */
    } 
    //~ else console.log(20111206, 'dont delete title',this.title,'from',this);
    
    /* e.g. when slave gridwindow called from a permalink */
    //~ if (this.base_params) Ext.apply(bp,this.base_params);  
    //~ bp['fmt'] = 'json';
    
    //~ function on_proxy_write( proxy, action,data, response,rs,options) {
      //~ console.log('20120814 on_proxy_write',action,data,response)
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
    //~ }
    //~ function on_proxy_load( proxy, transactionObject, callbackOptions ) {
      //~ console.log('on_proxy_load',transactionObject)
    //~ }
    var proxy = new Ext.data.HttpProxy({ 
      // 20120814 
      url: '/api' + this.ls_url
      ,method: "GET"
      //~ ,url: ADMIN_URL + '/restful' + this.ls_url
      //~ ,restful: true 
      //~ ,listeners: {load:on_proxy_load} 
      //~ ,listeners: {write:on_proxy_write} 
    });
    //~ config.store = new Ext.data.JsonStore({ 
    //~ this.store = new Ext.data.ArrayStore({ 
    this.store = new Lino.GridStore({ 
      grid_panel: this
      ,listeners: { exception: Lino.on_store_exception }
      ,remoteSort: true
      ,totalProperty: "count"
      ,root: "rows"
      //~ ,id: "id" 
      ,proxy: proxy
      //~ autoLoad: this.containing_window ? true : false
      ,idIndex: this.pk_index
      //~ ,baseParams: bp
      ,fields: this.ls_store_fields
      ,idProperty: this.ls_id_property 
      // 20120814
      //~ ,writer : new Ext.data.JsonWriter({
        //~ writeAllFields: false
        //~ ,listful: true
      //~ })
      //~ ,restful : true
    });
      
    //~ console.log('config.pk_index',config.pk_index,config.store),
    delete this.ls_store_fields;
      
    var this_ = this;
    //~ var grid = this;
    this.store.on('load', function() {
        //~ console.log('20120814 GridStore.on(load)',this_.store);
        //~ var da = this_.store.reader.arrayData.disabled_actions;
        //~ if (da) {
            //~ this.cmenu.cascade(function(item){ 
              //~ console.log(20120531, item.itemId, da[item.itemId]);
              //~ if (da[item.itemId]) item.disable(); else item.enable();
            //~ });
        //~ };
        this_.set_param_values(this_.store.reader.arrayData.param_values);
        //~ this_.set_status(this_.store.reader.arrayData.status);
        //~ 20120918
        this.getView().getRowClass = Lino.getRowClass;
        
        if (this_.store.reader.arrayData.no_data_text) {
            //~ this.viewConfig.emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().refresh();
        }
        if (this_.containing_window)
            this_.set_window_title(this_.store.reader.arrayData.title);
            //~ this_.containing_window.setTitle(this_.store.reader.arrayData.title);
        if (!this.is_searching) { // disabled 20121025: quick_search_field may not lose focus
          this.is_searching = false;
          if (this_.selModel.getSelectedCell){
              if (this_.getStore().getCount()) // there may be no data
                  this_.selModel.select(0,0); 
          } else {
              this_.selModel.selectFirstRow();
              this_.getView().focusEl.focus();
          }
        } 
        //~ else console.log("is_searching -> no focussing");
        //~ var t = this.getTopToolbar();
        //~ var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
        //~ this.quick_search_field.focus(); // 20121024
      }, this
    );
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar, this.cmenu = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ this.cmenu = new Ext.menu.Menu({items: config.bbar});
    delete this.ls_bbar_actions
    if (actions) {
        this.cmenu = actions.cmenu;
    }
    
    if (!this.hide_top_toolbar) {  
      var tbar = [ 
        this.quick_search_field = new Ext.form.TextField({ 
          //~ fieldLabel: "Search"
          listeners: { 
            scope:this_
            //~ ,change:this_.search_change
            
            ,render: Lino.quicktip_renderer("Quick Search","Enter a text to use as quick search filter")
            
            //~ ,keypress: this.search_keypress 
            ,blur: function() { this.is_searching = false}
          }
          ,validator:function(value) { return this_.search_validate(value) }
          //~ ,tooltip: "Enter a quick search text, then press TAB"
          //~ value: text
          //~ scope:this, 
          //~ ,enableKeyEvents: true
          //~ listeners: { keypress: this.search_keypress }, 
          //~ id: "seachString" 
      })];
      tbar = this.add_params_panel(tbar);
      tbar = tbar.concat([
        { scope:this, 
          //~ text: "[csv]", 
          tooltip: "Export this table to a .csv file", 
          iconCls: 'x-tbar-csv',
          handler: function() { 
            //~ 20130116 var p = Ext.apply({},this.get_base_params());
            //~ 20130116 p.fmt = 'csv';
            //~ url += "?" + Ext.urlEncode(p);
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            p.fmt = "csv";
            this.add_param_values(p,true);
            
            window.open('/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } },
        //~ { scope:this, 
          //~ text: "[html]", 
          //~ handler: function() { 
            //~ var p = this.get_current_grid_config();
            //~ Ext.apply(p,this.get_base_params());
            //~ p.$ext_requests.URL_PARAM_FORMAT = "$ext_requests.URL_FORMAT_PRINTER";
            //~ this.add_param_values(p);
            //~ window.open(ADMIN_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          //~ } },
        { scope:this, 
          //~ text: "[html]", 
          tooltip: "Show this table in plain html", 
          iconCls: 'x-tbar-html',
          handler: function() { 
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            //~ since 20121226 p.$ext_requests.URL_PARAM_FORMAT = "$ext_requests.URL_FORMAT_PLAIN";
            this.add_param_values(p,true);
            //~ since 20121226 window.open(ADMIN_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
            window.open('/plain'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } }
        
      ]);
    
    
      var menu = [];
      var set_gc = function(index) {
        return function() {
          //~ console.log('set_gc() 20100812');
          this.getColumnModel().setConfig(
              this.apply_grid_config(index,this.ls_grid_configs,this.ls_columns));
        }
      }
      for (var i = 0; i < this.ls_grid_configs.length;i++) {
        var gc = this.ls_grid_configs[i];
        menu.push({text:gc.label,handler:set_gc(i),scope:this})
      }
      if(menu.length > 1) {
        tbar = tbar.concat([
          { text:"View",
            menu: menu,
            tooltip:"Select another view of this report"
          }
        ]);
      }
      
      if (actions) {
        tbar = tbar.concat(actions.bbar);
          //~ this.bbar = actions.bbar;
      }
      
      this.tbar = new Ext.PagingToolbar({ 
        store: this.store, 
        prependButtons: true, 
        //~ pageSize: this.page_length, 
        pageSize: 1, 
        displayInfo: true, 
        beforePageText: "Page",
        afterPageText: "of {0}",
        displayMsg: "Displaying {0} - {1} of {2}",
        firstText: "First page",
        lastText: "Last page",
        prevText: "Previous page",
        nextText: "Next page",
        items: tbar
      });
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ var ps = this.calculatePageSize();
          //~ if (ps && ps != this.getTopToolbar().pageSize) {
              //~ // console.log('20120203 resize : pageSize',this.getTopToolbar().pageSize,'->',ps);
              //~ // this.getTopToolbar().pageSize =  ps;
              //~ cmp.refresh();
              //~ // this.getTopToolbar().doRefresh();
          //~ }
        //~ }, this);
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ cmp.getTopToolbar().pageSize = this.calculatePageSize(aw,ah,rw,rh) || 10;
          //~ cmp.refresh();
        //~ }, this, {delay:500});
    }
    
    //~ delete this.page_length
    
    
      
    if (this.cell_edit) {
      this.selModel = new Ext.grid.CellSelectionModel()
      this.get_selected = function() {
        //~ console.log(this.getSelectionModel().selection);
        if (this.selModel.selection)
            return [ this.selModel.selection.record ];
        return [this.store.getAt(0)];
      };
      this.get_current_record = function() { 
        if (this.getSelectionModel().selection) 
          return this.selModel.selection.record;
        return this.store.getAt(0);
      };
    } else { 
      this.selModel = new Ext.grid.RowSelectionModel() 
      this.get_selected = function() {
        var sels = this.selModel.getSelections();
        if (sels.length == 0) sels = [this.store.getAt(0)];
        return sels
        //~ var sels = this.getSelectionModel().getSelections();
        //~ return Ext.pluck(sels,'id');
      };
      this.get_current_record = function() { 
        var rec = this.selModel.getSelected();
        if (rec == undefined) rec = this.store.getAt(0);
        return rec
      };
    };
    this.columns  = this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns);
    
    //~ var grid = this;
    //~ this.colModel = new Ext.grid.ColumnModel({
      //~ columns: this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns),
      //~ isCellEditable: function(col, row) {
        //~ var record = grid.store.getAt(row);
        //~ console.log('20120514',col,record); // dataIndex
        //~ var dataIndex = grid.colModel.getDataIndex(col);
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("$_("This field is disabled")");
            //~ return false;
        //~ }
        //~ return Ext.grid.ColumnModel.prototype.isCellEditable.call(this, col, row);
      //~ }
    //~ });    
    
    
    Lino.GridPanel.superclass.initComponent.call(this);
    
    //~ if (this.containing_window) 
        //~ this.on('afterlayout', this.refresh, this);
        //~ this.on('afterrender', this.refresh,this);
    //~ else
        //~ this.on('show', this.refresh,this);
    //~ this.on('afterlayout', function() {
      //~ if (this.id == "ext-comp-1157") 
        //~ console.log("20120213 afterlayout",this); 
      //~ // this.refresh();
      //~ },this);
    //~ this.on('afterrender', this.refresh);
    //~ this.on('resize', this.refresh,this,{delay:500});
    //~ this.on('resize', function(){console.log("20120213 resize",arguments)},this);
    this.on('resize', function(){
      //~ console.log("20120213 resize",arguments)
      this.refresh();
      },this);
    this.on('viewready', function(){
      //~ console.log("20120213 resize",arguments);
      this.view_is_ready = true;
      this.refresh(); // removed 20130911
      },this);
    this.on('afteredit', this.on_afteredit); // 20120814
    //~ this.on('afteredit', this.new_on_afteredit);
    this.on('beforeedit', this.on_beforeedit);
    this.on('beforeedit',function(e) { this.before_row_edit(e.record)},this);
    if (this.cell_edit) {
        this.on('cellcontextmenu', Lino.cell_context_menu, this);
    } else {
        this.on('rowcontextmenu', Lino.row_context_menu, this);
    }
    //~ this.on('contextmenu', Lino.grid_context_menu, this);
    
    
    //~ if (this.id == "ext-comp-1157") captureEvents(this);    
    
    delete this.cell_edit;
    
  },
  
  //~ onResize : function(){
      //~ console.log("20120206 GridPanel.onResize",arguments);
      //~ Lino.GridPanel.superclass.onResize.apply(this, arguments);
      //~ this.refresh();
  //~ },
  
  
  get_status : function(){
    var st = { base_params : this.get_base_params()};
    if (!this.hide_top_toolbar) {
        st.current_page = this.getTopToolbar().current;
    }
    st.param_values = this.status_param_values;
    //~ console.log("20120213 GridPanel.get_status",st);
    return st;
  },
  
  /* 
  Lino.GridPanel.set_status() 
  */
  set_status : function(status){
    //~ console.log("20130605 GridPanel.set_status",status);
    this.clear_base_params();
    if (status == undefined) status = {};
    this.set_param_values(status.param_values);
    if (status.base_params) { 
      this.set_base_params(status.base_params);
    }
    if (status.show_params_panel != undefined) {
        if (this.toggle_params_panel_btn) {
            //~ this.toggle_params_panel_btn.toggle(status.show_params_panel=='true');
            this.toggle_params_panel_btn.toggle(status.show_params_panel);
        }
    }
    if (!this.hide_top_toolbar) {
      //~ console.log("20120213 GridPanel.getTopToolbar().changePage",
          //~ status.current_page || 1);
      this.getTopToolbar().changePage(status.current_page || 1);
    }
    //~ this.fireEvent('resize');
    //~ this.refresh.defer(100,this); 
    //~ this.onResize.defer(100,this); 
    //~ this.refresh(); 
    //~ this.doLayout(); 
    //~ this.onResize(); 
    //~ this.store.load();
  },
  
  refresh : function(unused) { 
    this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ Lino.notify('Lino.GridPanel.refresh '+this.store.proxy.url);
    //~ var bp = { fmt:'json' }
    if (! this.view_is_ready) return;
    
    if (this.containing_panel) {
        //~ Ext.apply(p,this.master_panel.get_master_params());
        //~ Ext.apply(options.params,this.containing_panel.get_master_params());
        this.set_base_params(this.containing_panel.get_master_params());
        // 20130911
        if (!this.store.baseParams.mk) {  
            return;
        }
    }
    
    
    //~ console.log('20130911 Lino.GridPanel.refresh_with_after',this.containing_panel.get_master_params());
    
    var options = {};
    if (after) {
        options.callback = function(r,options,success) {if(success) after()}
    }
      
    //~ if (!this.rendered) {
        //~ console.log("20120206 GridPanel.refresh() must wait until rendered",options);
        //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
        //~ return;
    //~ }
    
    this.store.load(options);
  },
  
  /* pageSize depends on grid height (Trying to remove scrollbar)
  Thanks to 
  - Christophe Badoit on http://www.sencha.com/forum/showthread.php?82647
  - http://www.sencha.com/forum/archive/index.php/t-37231.html
  */
  calculatePageSize : function(second_attempt) {
    //~ if (!this.rendered) { 
    if (!this.view_is_ready) { 
      //~ console.log('Cannot calculatePageSize() : not rendered');
      return false; }
    //~ if (!this.isVisible()) { 
      //~ console.log('calculatePageSize : not visible');
      //~ return false; }
      
    //~ console.log('getFrameHeight() is',this.getFrameHeight());
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('mainBody.getHeight() is',this.getView().mainBody.getHeight());
    //~ console.log('getInnerHeight() is',this.getInnerHeight());
    //~ console.log('getHeight() is',this.getHeight());
    //~ console.log('el.getHeight() is',this.getEl().getHeight());
    //~ console.log('getGridEl().getHeight() is',this.getGridEl().getHeight());
    //~ console.log('getOuterSize().height is',this.getOuterSize().height);
    //~ console.log('getBox().height is',this.getBox().height);
    //~ console.log('getResizeEl.getHeight() is',this.getResizeEl().getHeight());
    //~ console.log('getLayoutTarget().getHeight() is',this.getLayoutTarget().getHeight());
      
    //~ var rowHeight = 52; // experimental value
    var row = this.view.getRow(0);
    if (row) {
      //~ console.log('20120213 yes');
      var rowHeight = Ext.get(row).getHeight();
    } else {
        //~ var rowHeight = this.getFrameHeight();
        //~ var rowHeight = 10; // reasonably smallest approximative value
        //~ There is no data yet. Construct a fake row and get its height
        var Element = Ext.Element;
        var gv = this.view;
        var fakeBody = new Element(Element.fly(gv.scroller).child('div.x-grid3-body'));
        var rowTemplate = gv.templates.row;
        var cellTemplate = gv.templates.cell;
        var tstyle  = 'width:' + gv.getGridInnerWidth() + 'px;';
        var cells = cellTemplate.apply({value:'&#160;'});
        var markup = rowTemplate.apply({
                tstyle: tstyle,
                cols  : 1,
                cells : cells,
                alt   : ''
            });        
        fakeBody.dom.innerHTML = gv.templates.body.apply({rows: markup});
        var row = fakeBody.dom.childNodes[0];
        var rowHeight = Ext.get(row).getHeight();
    }
    //~ console.log('rowHeight is ',rowHeight,this,caller);
    //~ this.getView().syncScroll();
    //~ this.getView().initTemplates();
    var height = this.getView().scroller.getHeight();
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('getInnerHeight() - getFrameHeight() is',
      //~ this.getInnerHeight(), '-',
      //~ this.getFrameHeight(), '=',
      //~ this.getInnerHeight() - this.getFrameHeight());
    //~ var height = this.getView().mainBody.getHeight();
    //~ var height = this.getView().mainWrap.getHeight();
    //~ var height = this.getView().resizeMarker.getHeight();
    //~ this.syncSize();
    //~ var height = this.getInnerHeight() - this.getFrameHeight();
    //~ var height = this.getHeight() - this.getFrameHeight();
    height -= Ext.getScrollBarWidth(); // leave room for a possible horizontal scrollbar... 
    //~ height -= this.getView().scrollOffset;
    var ps = Math.floor(height / rowHeight);
    //~ console.log('20130816 calculatePageSize():',height,'/',rowHeight,'->',ps);
    ps -= 1; // leave room for a possible phantom row
    //~ return (ps > 1 ? ps : false);
    if (ps > 1) return ps;
    //~ console.log('calculatePageSize() found less than 1 row:',height,'/',rowHeight,'->',ps);
    //~ foo.bar = baz; // 20120213
    return 5; // preview_limit
    //~ if (second_attempt) {
        //~ console.log('calculatePageSize() abandons after second attempt:',
          //~ height,'/',rowHeight,'->',ps);
      //~ return 5;
    //~ }
    //~ return this.calculatePageSize.defer(500,this,[true]);
  },
  
  onCellDblClick : function(grid, row, col){
      //~ console.log("20120307 onCellDblClick",this,grid, row, col);
      if (this.ls_detail_handler) {
          //~ Lino.notify('show detail');
          Lino.show_detail(this);
          return false;
      }else{
        //~ console.log('startEditing');
        this.startEditing(row,col);
      }
  },
  
  get_base_params : function() {
    //~ return this.containing_window.config.base_params;
    //~ console.log(20120717,this.store.baseParams);
    var p = Ext.apply({},this.store.baseParams);
    Lino.insert_subst_user(p);
    //~ console.log("20120717 GRidPanel.get_base_params() returns",p);
    return p;
    //~ return this.store.baseParams;
  },
  set_base_params : function(p) {
    //~ console.log('20130911 GridPanel.set_base_params',p)
    for (k in p) this.store.setBaseParam(k,p[k]);
    //~ this.store.baseParams = p;
    if (p.query) 
        this.quick_search_field.setValue(p.query);
    //~ if (p.param_values) 
        //~ this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.store.baseParams = {};
      Lino.insert_subst_user(this.store.baseParams);
  },
  set_base_param : function(k,v) {
    this.store.setBaseParam(k,v);
  },
  
  //~ get_permalink_params : function() {
    //~ var p = {};
    //~ return p;
  //~ },
  
  before_row_edit : function(record) {},
    
  //~ search_keypress : function(){
    //~ console.log("2012124 search_keypress",arguments);
  //~ },
  search_validate : function(value) {
    if (value == this.quick_search_text) return true;
    this.is_searching = true;
    //~ console.log('search_validate',value)
    this.quick_search_text = value;
    this.set_base_param('query',value); 
    //~ this.getTopToolbar().changePage(1);
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
    return true;
  },
  
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
  },
  
  apply_grid_config : function(index,grid_configs,rpt_columns) {
    //~ var rpt_columns = this.ls_columns;
    var gc = grid_configs[index];    
    //~ console.log('apply_grid_config() 20100812',name,gc);
    this.gc_name = index;
    if (gc == undefined) {
      return rpt_columns;
      //~ config.columns = config.ls_columns;
      //~ return;
    } 
    //~ delete config.ls_filters
    
    //~ console.log(20100805,config.ls_columns);
    var columns = Array(gc.columns.length);
    for (var j = 0; j < rpt_columns.length;j++) {
      var col = rpt_columns[j];
      for (var i = 0; i < gc.columns.length; i++) {
        if (col.dataIndex == gc.ci[i]) {
          col.width = gc.cw[i];
          col.hidden = gc.ch[i];
          columns[i] = col;
          break;
        }
      }
    }
    
    //~ var columns = Array(rpt_columns.length);
    //~ for (var i = 0; i < rpt_columns.length; i++) {
      //~ columns[i] = rpt_columns[gc.columns[i]];
      //~ columns[i].width = gc.widths[i];
    //~ }
    
    //~ if (gc.hidden_cols) {
      //~ for (var i = 0; i < gc.hidden_cols.length; i++) {
        //~ var hc = gc.hidden_cols[i];
        //~ for (var j = 0; j < columns.length;j++) {
          //~ var col = columns[j];
          //~ if (col.dataIndex == hc) {
            //~ col.hidden = true;
            //~ break
          //~ }
        //~ }
      //~ }
    //~ }
    if (gc.filters) {
      //~ console.log(20100811,'config.ls_filters',config.ls_filters);
      //~ console.log(20100811,'config.ls_grid_config.filters',config.ls_grid_config.filters);
      for (var i = 0; i < gc.filters.length; i++) {
        var fv = gc.filters[i];
        for (var j = 0; j < columns.length;j++) {
          var col = columns[j];
          if (col.dataIndex == fv.field) {
            //~ console.log(20100811, f,' == ',fv);
            if (fv.type == 'string') {
              col.filter.value = fv.value;
              //~ if (fv.comparison !== undefined) f.comparison = fv.comparison;
            } else {
              //~ console.log(20100811, fv);
              col.filter.value = {};
              col.filter.value[fv.comparison] = fv.value;
            }
            break;
          }
        };
      }
    }
    
    return columns;
    //~ config.columns = cols;
    //~ delete config.ls_columns
  },
  
  get_current_grid_config : function () {
    var cm = this.getColumnModel();
    var widths = Array(cm.config.length);
    var hiddens = Array(cm.config.length);
    //~ var hiddens = Array(cm.config.length);
    var columns = Array(cm.config.length);
    //~ var columns = Array(cm.config.length);
    //~ var hidden_cols = [];
    //~ var filters = this.filters.getFilterValues();
    var p = this.filters.buildQuery(this.filters.getFilterData())
    for (var i = 0; i < cm.config.length; i++) {
      var col = cm.config[i];
      columns[i] = col.dataIndex;
      //~ hiddens[i] = col.hidden;
      widths[i] = col.width;
      hiddens[i] = col.hidden;
      //~ if (col.hidden) hidden_cols.push(col.dataIndex);
    }
    //~ p['hidden_cols'] = hidden_cols;
    p.cw = widths;
    p.ch = hiddens;
    p.ci = columns;
    //~ p['widths'] = widths;
    //~ p['hiddens'] = hiddens;
    //~ p['columns'] = columns;
    p['name'] = this.gc_name;
    //~ var gc = this.ls_grid_configs[this.gc_name];
    //~ if (gc !== undefined) 
        //~ p['label'] = gc.label
    //~ console.log('20100810 save_grid_config',p);
    return p;
  },
  
  unused_manage_grid_configs : function() {
    var data = [];
    for (k in this.ls_grid_configs) {
      var v = this.ls_grid_configs[k];
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i)
    }
    if (this.ls_grid_configs[this.gc_name] == undefined) {
      var v = this.get_current_grid_config();
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i);
    }
    //~ console.log(20100811, data);
    var main = new Ext.grid.GridPanel({
      store: new Ext.data.ArrayStore({
        idIndex:0,
        fields:['name','columns','hidden_cols','filters'],
        autoDestroy:true,
        data: data}),
      //~ autoHeight:true,
      selModel: new Ext.grid.RowSelectionModel(),
      listeners: { 
        rowdblclick: function(grid,rowIndex,e) {
          console.log('row doubleclicked',grid, rowIndex,e);
        },
        rowclick: function(grid,rowIndex,e) {
          console.log('row clicked',grid, rowIndex,e);
        }
      },
      columns: [ 
        {dataIndex:'name',header:'Name'}, 
        {dataIndex:'columns',header:'columns'}, 
        {dataIndex:'hidden_cols',header:'hidden columns'}, 
        {dataIndex:'filters',header:'filters'} 
      ]
    });
    var win = new Ext.Window({title:'GridConfigs Manager',layout:'fit',items:main,height:200});
    win.show();
  },
  
  unused_edit_grid_config : function(name) {
    gc = this.ls_grid_configs[name];
    var win = new Ext.Window({
      title:'Edit Grid Config',layout:'vbox', 
      //~ layoutConfig:'stretch'
      items:[
        {xtype:'text', value: gc.name},
        {xtype:'text', value: gc.columns},
        {xtype:'text', value: gc.hidden_cols},
        {xtype:'text', value: gc.filters}
      ]
    });
    win.show();
  },
  
  save_grid_config : function () {
    //~ console.log('TODO: save_grid_config',this);
    //~ p.column_widths = Ext.pluck(this.colModel.columns,'width');
    var a = { 
      params:this.get_current_grid_config(), 
      method:'PUT',
      url:'/grid_config' + this.ls_url,
      success: Lino.action_handler(this),
      scope: this,
      failure: Lino.ajax_error_handler(this)
    };
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(a);
    //~ Lino.do_action(this,a);
  },
  
  on_beforeedit : function(e) {
    //~ console.log('20130128 GridPanel.on_beforeedit()',e,e.record.data.disable_editing);
    if(this.disable_editing | e.record.data.disable_editing) {
      e.cancel = true;
      Lino.notify("This record is disabled");
      return;
    }
    if(e.record.data.disabled_fields && e.record.data.disabled_fields[e.field]) {
      e.cancel = true;
      Lino.notify("This field is disabled");
      return;
    }
    //~ if (e.record.data.disabled_fields) {
      //~ for (i in e.record.data.disabled_fields) {
        //~ if(e.record.data.disabled_fields[i] == e.field) {
          //~ e.cancel = true;
          //~ Lino.notify(String.format('Field "{0}" is disabled for this record',e.field));
          //~ return
        //~ }
      //~ }
    //~ }
  },
  save_grid_data : function() {
      //~ console.log("20120814 save_grid_data");
      this.getStore().commitChanges();
  },
  new_on_afteredit : function(e) {
      //~ this.getStore().commitChanges();
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
      console.log("20120814 new_on_afteredit",e);
  },
  on_afteredit : function(e) {
    /*
    e.grid - The grid that fired the event
    e.record - The record being edited
    e.field - The field name being edited
    e.value - The value being set
    e.originalValue - The original value for the field, before the edit.
    e.row - The grid row index
    e.column - The grid column index
    */
    var p = {};
    //~ console.log('20101130 modified: ',e.record.modified);
    //~ console.log('20101130 value: ',e.value);
    //~ var p = e.record.getChanges();
    //~ console.log('20101130 getChanges: ',e.record.getChanges());
    //~ this.before_row_edit(e.record);
    for(k in e.record.getChanges()) {
        var v = e.record.get(k);
    //~ for(k in e.record.modified) {
        //~ console.log('20101130',k,'=',v);
        //~ var cm = e.grid.getColumnModel();
        //~ var di = cm.getDataIndex(k);
        var f = e.record.fields.get(k);
        //~ console.log('20101130 f = ',f);
        //~ var v = e.record.get(di);
        if (f.type.type == 'date') {
            p[k] = Ext.util.Format.date(v, f.dateFormat);
        }else{
            p[k] = v;
            var v = e.record.get(k+'Hidden');
            if (v !== undefined) {
              p[k+'Hidden'] = v;
            }
        }
        //~ var i = cm.findColumnIndex(k);
        //~ var r = cm.getRenderer(i);
        //~ var editor = cm.getCellEditor(i,e.row);
        //~ var col = e.grid.getColumnModel().getColumnById(k);
        //~ console.log('20101130 r = ',r(v));
        //~ var f = e.record.fields[k];
        //~ console.log('20101130 f = ',f);
        //~ console.log('20101130 editor = ',editor);
        //~ p[k] = f.getValue();
        //~ p[k] = r(v);
    }
    //~ console.log('20101130 p:',p);
    //~ var cm = e.grid.getColumnModel();
    //~ var di = cm.getDataIndex(e.column);
    //~ var f = e.record.fields.get(di);
    //~ console.log('20101130 f = ',f);
    //~ if (f.type.type == 'date') e.record.set(di,Ext.util.Format.date(e.value, f.dateFormat));
    
    
    //~ var p = e.record.data;
    
    // var p = {};
    //~ p['grid_afteredit_colname'] = e.field;
    //~ p[e.field] = e.value;
    //~ console.log('20100723 GridPanel.on_afteredit()',e);
    // add value used by ForeignKeyStoreField CHOICES_HIDDEN_SUFFIX
    // not sure whether this is still needed:
    p[e.field+'Hidden'] = e.value;
    //~ p.su = Lino.subst_user;
    Lino.insert_subst_user(p);
    // this one is needed so that this field can serve as choice context:
    e.record.data[e.field+'Hidden'] = e.value;
    // p[pk] = e.record.data[pk];
    // console.log("grid_afteredit:",e.field,'=',e.value);
    Ext.apply(p,this.get_base_params()); // needed for POST, ignored for PUT
    //~ Ext.apply(p,this.containing_window.config.base_params);
    //~ 20121109 p['$ext_requests.URL_PARAM_ACTION_NAME'] = 'grid';
    var self = this;
    var req = {
        params:p,
        waitMsg: 'Saving your data...',
        success: Lino.action_handler( this, function(result) {
          //~ if (result.data_record) {
          if (result.refresh_all) {
              var cw = self.get_containing_window();
              if (cw) {
                  cw.main_item.refresh();
              }
              else console.log("20120123 cannot refresh_all",self);
          } else if (result.rows) {
              //~ self.getStore().loadData(result,true);
              var r = self.getStore().reader.readRecords(result);
              if (e.record.phantom) {
                  //~ console.log("20120816 afteredit.success POST",r);
                  self.getStore().insert(e.row,r.records);
              }else{
                  //~ console.log("20120816 afteredit.success PUT",r);
                  self.getStore().doUpdate(r.records[0]);
              }
              self.getStore().rejectChanges(); /* 
              get rid of the red triangles without saving the record again
              */
              //~ self.getStore().commitChanges(); // get rid of the red triangles
          } else {
              self.getStore().commitChanges(); // get rid of the red triangles
              self.getStore().reload();        // reload our datastore.
          }
          }),
        scope: this,
        failure: Lino.ajax_error_handler(this)
    };
    if (e.record.phantom) {
      req.params.an = 'post'; // SubmitInsert.action_name
      Ext.apply(req,{
        method: 'POST',
        url: '/api' + this.ls_url
      });
    } else {
      req.params.an = 'put'; // SubmitDetail.action_name
      Ext.apply(req,{
        method: 'PUT',
        url: '/api' + this.ls_url + '/' + e.record.id
      });
    }
    //~ console.log('20110406 on_afteredit',req);
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(req);
  },

  afterRender : function() {
    Lino.GridPanel.superclass.afterRender.call(this);
    // this.getView().mainBody.focus();
    // console.log(20100114,this.getView().getRows());
    // if (this.getView().getRows().length > 0) {
    //  this.getView().focusRow(1);
    // }
    //~ this.my_load_mask = new Ext.LoadMask(this.getEl(), {
        //~ msg:'$_("Please wait...")',
        //~ store:this.store});
      
    var tbar = this.getTopToolbar();
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    // tbar.on('change',function() {this.getSelectionModel().selectFirstRow();this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    this.nav = new Ext.KeyNav(this.getEl(),{
      pageUp: function() {tbar.movePrevious(); },
      pageDown: function() {tbar.moveNext(); },
      home: function() {tbar.moveFirst(); },
      end: function() {tbar.moveLast(); },
      scope: this
    });
  },
  after_delete : function() {
    //~ console.log('Lino.GridPanel.after_delete');
    this.refresh();
  },
  add_row_listener : function(fn,scope) {
    this.getSelectionModel().addListener('rowselect',fn,scope);
  },
  postEditValue : function(value, originalValue, r, field){
    value = Lino.GridPanel.superclass.postEditValue.call(this,value,originalValue,r,field);
    //~ console.log('GridPanel.postEdit()',value, originalValue, r, field);
    return value;
  },
  
  set_start_value : function(v) {
      this.start_value = v;
  },
  preEditValue : function(r, field){
      if (this.start_value) {
        var v = this.start_value;
        delete this.start_value;
        this.activeEditor.selectOnFocus = false;
        return v;
      }
      var value = r.data[field];
      return this.autoEncode && Ext.isString(value) ? Ext.util.Format.htmlDecode(value) : value;
  },
  
  on_master_changed : function() {
    //~ if (! this.enabled) return;
    //~ cmp = this;
    //~ console.log('20130911 Lino.GridPanel.on_master_changed()',this.title,this.rendered);
    if (! this.rendered) return; // 20120213
    var todo = function() {
      if (this.disabled) return;
      //~ if (this.disabled) return;
      //~ if (this.enabled) {
          //~ var src = caller.config.url_data + "/" + record.id + ".jpg"
          //~ console.log(20111125, this.containing_window);
          //~ for (k in p) this.getStore().setBaseParam(k,p[k]);
          //~ console.log('Lino.GridPanel.on_master_changed()',this.title,p);
          this.refresh();
          //~ this.set_base_params(this.master_panel.get_master_params());
          //~ this.getStore().load(); 
      //~ }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  },
  load_record_id : function(record_id,after) {
      Lino.run_detail_handler(this,record_id)
  }
  
});
  

//~ Lino.MainPanelMixin = {
  //~ tbar_items : function() {
      //~ return ;
  //~ }
//~ };

//~ Ext.override(Lino.GridPanel,Lino.MainPanelMixin);
//~ Ext.override(Lino.FormPanel,Lino.MainPanelMixin);

//~ Lino.grid_context_menu = function(e) {
  //~ console.log('contextmenu',arguments);
//~ }

Lino.row_context_menu = function(grid,row,col,e) {
  console.log('20130927 rowcontextmenu',grid,row,col,e,grid.store.reader.arrayData.rows[row]);
}

Lino.cell_context_menu = function(grid,row,col,e) {
  //~ console.log('20120531 cellcontextmenu',grid,row,col,e,grid.store.reader.arrayData.rows[row]);
  e.stopEvent();
  //~ grid.getView().focusCell(row,col);
  grid.getSelectionModel().select(row,col);
  //~ console.log(grid.store.getAt(row));
  //~ grid.getView().focusRow(row);
  //~ return;
  if(!grid.cmenu.el){grid.cmenu.render(); }
  //~ if(e.record.data.disabled_fields) {
  
  var da = grid.store.reader.arrayData.rows[row][grid.disabled_actions_index];
  if (da) {
      this.cmenu.cascade(function(item){ 
        //~ console.log(20120531, item.itemId, da[item.itemId]);
        if (da[item.itemId]) item.disable(); else item.enable();
      });
  };
  
  var xy = e.getXY();
  xy[1] -= grid.cmenu.el.getHeight();
  grid.cmenu.showAt(xy);
}


//~ Lino.load_main_menu = function() {
  //~ Ext.Ajax.request({
    //~ waitMsg: 'Loading main menu...',
    //~ method: 'GET',
    //~ url: '/menu',
    //~ success: Lino.on_load_menu,
    //~ failure: Lino.ajax_error_handler
  //~ });
//~ };



//~ Lino.SlavePlugin = function(caller) {
  //~ this.caller = caller;
//~ };

Lino.chooser_handler = function(combo,name) {
  return function(cmp,newValue,oldValue) {
    //~ console.log('Lino.chooser_handler()',cmp,oldValue,newValue);
    combo.setContextValue(name,newValue);
  }
};



Lino.ComboBox = Ext.extend(Ext.form.ComboBox,{
  forceSelection: true,
  triggerAction: 'all',
  minListWidth:280, // 20131022
  autoSelect: false,
  selectOnFocus: true, // select any existing text in the field immediately on focus.
  submitValue: true,
  displayField: 'text', // 'text', 
  valueField: 'value', // 'value',
  
  //~ initComponent : Ext.form.ComboBox.prototype.initComponent.createSequence(function() {
  initComponent : function(){
      this.contextParams = {};
      //~ Ext.form.ComboBox.initComponent(this);
      Lino.ComboBox.superclass.initComponent.call(this);
  },
  setValue : function(v,record_data){
      /*
      Based on feature request developed in http://extjs.net/forum/showthread.php?t=75751
      */
      /* `record_data` is used to get the text corresponding to this value */
      //~ if(this.name == 'city') 
      //~ console.log('20120203', this.name,'.setValue(', v ,') this=', this,'record_data=',record_data);
      var text = v;
      if(this.valueField){
        if(v == null || v == '') { 
            //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,'no lookup needed, value is empty');
            //~ v = undefined;
            v = '';
            //~ text = '';
        } else if (Ext.isDefined(record_data)) {
          text = record_data[this.name];
          //~ if (this.name == 'birth_country') 
            //~ console.log(this.name,'.setValue',v,'got text ',text,' from record ',record);
        } else {
          // if(this.mode == 'remote' && !Ext.isDefined(this.store.totalLength)){
          if(this.mode == 'remote' && ( this.lastQuery === null || (!Ext.isDefined(this.store.totalLength)))){
              //~ if (this.name == 'birth_country') console.log(this.name,'.setValue',v,'store not yet loaded');
              this.store.on('load', this.setValue.createDelegate(this, arguments), null, {single: true});
              if(this.store.lastOptions === null || this.lastQuery === null){
                  var params;
                  if(this.valueParam){
                      params = {};
                      params[this.valueParam] = v;
                  }else{
                      var q = this.allQuery;
                      this.lastQuery = q;
                      this.store.setBaseParam(this.queryParam, q);
                      params = this.getParams(q);
                  }
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : call load() with params ',params);
                  this.store.load({params: params});
              //~ }else{
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : but store is loading',this.store.lastOptions);
              }
              return;
          //~ }else{
              //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,' : store is loaded, lastQuery is "',this.lastQuery,'"');
          }
          var r = this.findRecord(this.valueField, v);
          if(r){
              text = r.data[this.displayField];
          }else if(this.valueNotFoundText !== undefined){
              text = this.valueNotFoundText;
          }
        }
      }
      this.lastSelectionText = text;
      //~ this.lastSelectionText = v;
      if(this.hiddenField){
          //~ this.hiddenField.originalValue = v;
          this.hiddenField.value = v;
      }
      Ext.form.ComboBox.superclass.setValue.call(this, text);
      this.value = v; // needed for grid.afteredit
  },
  
  getParams : function(q){
    // p = Ext.form.ComboBox.superclass.getParams.call(this, q);
    // causes "Ext.form.ComboBox.superclass.getParams is undefined"
    var p = {};
    //p[this.queryParam] = q;
    if(this.pageSize){
        //~ p.start = 0;
        //~ p.limit = this.pageSize;
        p['start'] = 0;
        p['limit'] = this.pageSize;
    }
    // now my code:
    if(this.contextParams) Ext.apply(p,this.contextParams);
    //~ if(this.contextParams && this.contextValues) {
      //~ for(i = 0; i <= this.contextParams.length; i++)
        //~ p[this.contextParams[i]] = this.contextValues[i];
    //~ }
    return p;
  },
  setContextValue : function(name,value) {
    //~ console.log('setContextValue',this,this.name,':',name,'=',value);
    //~ if (this.contextValues === undefined) {
        //~ this.contextValues = Array(); // this.contextParams.length);
    //~ }
    if (this.contextParams[name] != value) {
      //~ console.log('setContextValue 1',this.contextParams);
      this.contextParams[name] = value;
      this.lastQuery = null;
      //~ console.log('setContextValue 2',this.contextParams);
    }
  }
});

Lino.ChoicesFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'local'
});


Lino.SimpleRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  forceSelection: true,
  constructor: function(config){
      Lino.SimpleRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value' ], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.ComplexRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  constructor: function(config){
      Lino.ComplexRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value','text'], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.RemoteComboFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'remote',
  //~ forceSelection:false,
  minChars: 2, // default 4 is too much
  queryDelay: 300, // default 500 is maybe slow
  queryParam: 'query', 
  //~ typeAhead: true,
  //~ selectOnFocus: true, // select any existing text in the field immediately on focus.
  resizable: true
  ,initList : function() {
      Lino.RemoteComboFieldElement.superclass.initList.call(this);
      if (this.pageTb) {
          
          var me = this;
          this.pageTb.on("beforechange", function(toolbar, o){
              if(me.contextParams)
                  Ext.apply(o, me.contextParams);
          });
          
          //~ 
          //~ var btn = ls_buttons
          //~ this.pageTb.items = this.pageTb.items.concat([btn]);
          //~ console.log("20131022 pageTb.items is", this.pageTb.items)
      }
  }
});

/*
Thanks to Animal for posting the basic idea:
http://www.sencha.com/forum/showthread.php?15842-2.0-SOLVED-Combobox-twintrigger-clear&p=76130&viewfull=1#post76130

*/
Lino.TwinCombo = Ext.extend(Lino.RemoteComboFieldElement,{
    trigger2Class : 'x-form-search-trigger',
    //~ trigger2Class : 'x-tbar-detail',
    initComponent : function() {
        //~ Lino.TwinCombo.superclass.initComponent.call(this);
        Lino.ComboBox.prototype.initComponent.call(this);
        Ext.form.TwinTriggerField.prototype.initComponent.call(this);
    },
    onTrigger2Click : function() {
        //~ console.log('onTrigger2Click',this,arguments);
    }
  });
//~ Lino.TwinCombo.prototype.initComponent = Ext.form.TwinTriggerField.prototype.initComponent;
Lino.TwinCombo.prototype.getTrigger = Ext.form.TwinTriggerField.prototype.getTrigger;
Lino.TwinCombo.prototype.getOuterSize = Ext.form.TwinTriggerField.prototype.getOuterSize;
Lino.TwinCombo.prototype.initTrigger = Ext.form.TwinTriggerField.prototype.initTrigger;
Lino.TwinCombo.prototype.onTrigger1Click = Ext.form.ComboBox.prototype.onTriggerClick;
//~ Lino.TwinCombo.prototype.onTrigger2Click = function() {
    //~ console.log('onTrigger2Click',arguments);
//~ };



Lino.SimpleRemoteComboFieldElement = Ext.extend(Lino.RemoteComboFieldElement,{
  displayField: 'value', 
  valueField: null,
  forceSelection: false
});




Lino.Window = Ext.extend(Ext.Window,{
  //~ layout: "fit", 
  closeAction : 'hide',
  renderTo: 'main_area', 
  constrain: true,
  maximized: true,
  draggable: false,
  width: 700,
  height: 500,
  maximizable: false,
  constructor : function (config) {
    if (config.main_item.params_panel) {
        config.layout = 'border';
        config.main_item.region = 'center';
        config.main_item.params_panel.region = 'north';
        //~ config.main_item.params_panel.autoHeight = false; // 20130924
        config.main_item.params_panel.hidden = config.main_item.params_panel_hidden;
        config.items = [config.main_item.params_panel, config.main_item];
        //~ 20130923b
    } else {
        config.layout = 'fit';
        config.items = config.main_item;
    }
    this.main_item = config.main_item; 
    
    delete config.main_item;
    //~ delete config.params_item;
    
    //~ this.main_item = config.items.get(0);
    this.main_item.containing_window = this;
    
    //~ console.log('20120110 Lino.Window.constructor() 1');
    //~ if (Lino.current_window) { // all windows except the top are closable
    if (this.main_item.hide_window_title) { 
      config.closable = false;
      config.frame = false;
      config.shadow = false;
      //~ config.border = true;
      //~ config.title = undefined;
      //~ config.tools = null;
      delete config.title;
      delete config.tools;
    } else {
      config.title = this.main_item.empty_title;
      config.closable = true;
      config.tools = [ 
        { qtip: 'permalink', handler: Lino.permalink_handler(this), id: "pin" }
      ];
      if (this.main_item.content_type && this.main_item.action_name != 'insert') {
        config.tools = [ {
          handler: Lino.help_text_editor,
          qtip: "Edit help texts for fields on this model.",
          scope: this.main_item,
          id: "gear"
        }].concat(config.tools);
      }
        
    //~ { qtip: '', handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: this.config.qtip, handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: 'Call doLayout() on main Container.', handler: Lino.refresh_handler(this), id: "refresh" },
    //~ if (this.main_item.params_panel) {
        //~ config.tools = config.tools.concat([ 
          //~ { qtip: 'Show/hide parameter panel', handler: this.toggle_params_panel, id: "gear", scope:this } 
        //~ ]);
    //~ }
    //~ if (config.closable !== false) {
      // if undefined, will take default behaviour
      //~ config.tools = config.tools.concat([ 
        //~ { qtip: 'close', handler: this.hide, id: "close", scope:this } 
      //~ ]);
    }
    
    this.main_item.config_containing_window(config);
    
    //~ console.log('20120110 Lino.Window.constructor() 2');
    Lino.Window.superclass.constructor.call(this,config);
    
    //~ console.log('20120110 Lino.Window.constructor() 3');
    
  },
  initComponent : function() {
    this.main_item.init_containing_window(this);
    Lino.Window.superclass.initComponent.call(this);
  
  },
  hide : function() { 
      this.main_item.do_when_clean(false,function() { 
        Lino.close_window(); });
  },
  hide_really : function() { 
    Lino.Window.superclass.hide.call(this);
  },
  onRender : function(ct, position){
    //~ console.log('20120110 Lino.Window.onRender() 1');
    Lino.Window.superclass.onRender.call(this, ct, position);
    var main_area = Ext.getCmp('main_area')
    //~ console.log('20120110 Lino.Window.onRender() 2');
  
    this.on('show', function(win) {
        //~ console.log('20120110 Lino.Window.on show 1');
        main_area.on('resize', win.onWindowResize, win);
    });
    this.on('hide', function(win) {
        main_area.un('resize', win.onWindowResize, win);
    });
    //~ console.log('20120110 Lino.Window.onRender() 3');
  }
});


Lino.unused_ParamWindow = Ext.extend(Lino.Window,{
  //~ layout: "border", 
  constructor : function (config) {
    Lino.ParamWindow.superclass.constructor.call(this,config);
    this.main_item = config.items; // `items` must be a single component
    config.layout = 'border';
    this.main_item.region = 'center';
    config.params.region = 'north';
    config.items = [config.params, config.items];
    //~ delete config.params;
  }
});




(function(){
    var ns = Ext.ns('Ext.ux.plugins');

    /**
     * @class Ext.ux.plugins.DefaultButton
     * @extends Object
     *
     * Plugin for Button that will click() the button if the user presses ENTER while
     * a component in the button's form has focus.
     *
     * @author Stephen Friedrich
     * @date 09-DEC-2009
     * @version 0.1
     *
     */
    ns.DefaultButton =  Ext.extend(Object, {
        init: function(button) {
            button.on('afterRender', setupKeyListener, button);
        }
    });

    function setupKeyListener() {
        var formPanel = this.findParentByType('form');
        new Ext.KeyMap(formPanel.el, {
            key: Ext.EventObject.ENTER,
            shift: false,
            alt: false,
            fn: function(keyCode, e){
                if(e.target.type === 'textarea' && !e.ctrlKey) {
                    return true;
                }

                this.el.select('button').item(0).dom.click();
                return false;
            },
            scope: this
        });
    }

    Ext.ComponentMgr.registerPlugin('defaultButton', ns.DefaultButton);

})(); 

Ext.override(Ext.form.BasicForm,{
    my_loadRecord : function(values){
    //~ loadRecord : function(record){
        /* Same as ExtJS's loadRecord() (setValues()), except that we 
        forward also the record to field.setValue() so that Lino.Combobox 
        can use it. 
        */
        //~ console.log('20120918 my_loadRecord',values)
        if(Ext.isArray(values)){ 
            for(var i = 0, len = values.length; i < len; i++){
                var v = values[i];
                var f = this.findField(v.id);
                if(f){
                    f.setValue(v.value,values);
                    if(this.trackResetOnLoad){
                        f.originalValue = f.getValue();
                    }
                }
            }
        }else{ 
            var field, id;
            for(id in values){
                if(!Ext.isFunction(values[id]) && (field = this.findField(id))){
                    field.setValue(values[id],values);
                    if(this.trackResetOnLoad){
                        field.originalValue = field.getValue();
                        //~ if (field.hiddenField) {
                          //~ field.hiddenField.originalValue = field.hiddenField.value;
                        //~ }
                    }
                }
            }
        }
        return this;
    }
});




function initializeFooBarDropZone(cmp) {
    //~ console.log('initializeFooBarDropZone',cmp);
    cmp.dropTarget = new Ext.dd.DropTarget(cmp.bwrap, {
      //~ ddGroup     : 'gridDDGroup',
      notifyEnter : function(ddSource, e, data) {
        console.log('notifyEnter',ddSource,e,data);
        //Add some flare to invite drop.
        cmp.body.stopFx();
        cmp.body.highlight();
      },
      notifyDrop  : function(ddSource, e, data){
        console.log('notifyDrop',ddSource,e,data);
        // Reference the record (single selection) for readability
        //~ var selectedRecord = ddSource.dragData.selections[0];


        // Load the record into the form
        //~ formPanel.getForm().my_loadRecord(selectedRecord);


        // Delete record from the grid.  not really required.
        //~ ddSource.grid.store.remove(selectedRecord);

        return(true);
      }
    })
}



Lino.show_mti_child = function(fieldname,detail_handler) {
  //~ console.log('show_mti_child',this);
  //~ console.log('show_mti_child',panel.find("main_area"));
  rec = Lino.current_window.main_item.get_current_record();
  //~ rec = panel.get_current_record();
  if (rec) {
    //~ console.log('show_mti_child',Lino.current_window,rec);
    if (rec.phantom) {
      Lino.notify('Not allowed on phantom record.');
    }else if (rec.data[fieldname]) {
      //~ console.log('show_mti_child',rec.id);
      //~ detail_handler(Lino.current_window.main_item,{},{record_id:rec.id});
      detail_handler.run(null,{record_id:rec.id});
      //~ window.open(urlroot + '/' + rec.id);
      //~ document.location = urlroot + '/' + rec.id;
      //~ window.open(urlroot + '/' + rec.id,'_blank');
    } else {
      Lino.alert("Cannot show MTI child if checkbox is off.");
    }
  } else {
    Lino.notify('No current record.');
  }
};






/*
Mappings towards lino.apps.extensible.models.PanelCalendars
*/
// Sset SS = Ssite.modules.extensible.PanelCalendars.get_handle(Sui).store
Ext.ensible.cal.CalendarMappings = {
    CalendarId:   {name:'ID',       mapping: 'id', type: 'int'},
    Title:        {name:'CalTitle', mapping: 'summary', type: 'string'},
    Description:  {name:'Desc',     mapping: 'description', type: 'string'},
    ColorId:      {name:'Color',    mapping: 'color', type: 'int'},
    IsHidden:     {name:'Hidden',   mapping: 'is_hidden', type: 'boolean'},    
};
Ext.ensible.cal.CalendarRecord.reconfigure();  


/*
Mappings towards lino.apps.extensible.models.PanelEvents 
*/
// Sset SS = Ssite.modules.extensible.PanelEvents.get_handle(Sui).store
Ext.ensible.cal.EventMappings = {
    EventId:     {name: 'ID',        mapping: 'id', type:'int'},
    CalendarId:  {name: 'CalID',     mapping: 'calendarHidden', type: 'int'},
    Title:       {name: 'EvtTitle',  mapping: 'summary'},
    StartDate:   {name: 'StartDt',   mapping: 'start_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s" },
    EndDate:     {name: 'EndDt',     mapping: 'end_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s"},
    RRule:       {name: 'RecurRule', mapping: 'rsetHidden'},
    Location:    {name: 'Location',  mapping: 'placeHidden'},
    Notes:       {name: 'Desc',      mapping: 'description'},
    Url:         {name: 'LinkUrl',   mapping: 'url'},
    IsAllDay:    {name: 'AllDay',    mapping: 'all_day', type: 'boolean'},
    Reminder:    {name: 'Reminder',  mapping: 'reminder'}
    
};
Ext.ensible.cal.EventRecord.reconfigure();


//~ Lino.on_eventclick = 
    
Lino.on_editdetails = 

Lino.format_time = function(dt) {
    return dt.getHours() + ':' + dt.getMinutes();
}
    
Lino.on_eventdelete = function() {
  //~ console.log("Lino.on_eventdelete",arguments);
};

Lino.on_eventadd  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventadd ",arguments);
  return false;
}
    
Lino.on_eventresize  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventresize ",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    
Lino.on_eventupdate  = function(cp,rec,el) {
  //~ console.log("Lino.on_eventupdate",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    

//~ Lino.eventStore = new Ext.ensible.cal.EventStore({ 
//~ Lino.eventStore = new Ext.data.ArrayStore({ 
Lino.unused_eventStore = new Ext.data.JsonStore({ 
  listeners: { exception: Lino.on_store_exception }
  ,url: '/restful/cal/PanelEvents'
  ,restful : true
  ,proxy: new Ext.data.HttpProxy({ 
      //~ url: '/restful/cal/PanelEvents', 
      url: '/restful/cal/PanelEvents', 
      disableCaching: false // no need for cache busting when loading via Ajax
      //~ disableCaching:true,
  })
  ,fields: Ext.ensible.cal.EventRecord.prototype.fields.getRange()
  ,totalProperty: "count"
  ,root: "rows"
  ,idProperty: Ext.ensible.cal.EventMappings.EventId.mapping
  ,writer : new Ext.data.JsonWriter({
    writeAllFields: false
  })
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
      if (!options) options = {};
      if (!options.params) options.params = {};
      //~ options.params.$ext_requests.URL_PARAM_TEAM_VIEW = Lino.calendar_app.team_view_button.pressed;
      
      var view = this.cal_panel.getActiveView();
      var bounds = view.getViewBounds();
      //~ var p = {sd:'05.02.2012',ed:'11.02.2012'};
      //~ var p = {};
      options.params[view.dateParamStart] = bounds.start.format(view.dateParamFormat);
      options.params[view.dateParamEnd] = bounds.end.format(view.dateParamFormat);
      Lino.insert_subst_user(options.params);
      //~ Ext.apply(options.params,p)
      //~ console.log('20120710 eventStore.load()',this.baseParams,options);
    
    return Ext.data.JsonStore.prototype.load.call(this,options);
  }
});

//~ Lino.eventStore.on('load', function() {
//~ });


    //~ Lino.subst_user = id;


//~ Lino.calendarStore = new Ext.data.ArrayStore({ 
Lino.unused_calendarStore = new Ext.data.JsonStore({ 
      listeners: { exception: Lino.on_store_exception }
      ,restful : true
      ,proxy: new Ext.data.HttpProxy({ 
          //~ url: '/restful/cal/PanelCalendars?fmt=json', 
          url: '/restful/cal/PanelCalendars?fmt=%7B%7Bext_requests.URL_FORMAT_JSON%7D%7D', 
          disableCaching: false // no need for cache busting when loading via Ajax
          //~ restful : true
          //~ method: "GET"
      })
      //~ ,autoLoad: true
      //~ ,remoteSort: true
      //~ ,baseParams: bp
      ,totalProperty: "count"
      ,root: "rows"
      ,fields: Ext.ensible.cal.CalendarRecord.prototype.fields.getRange()
      ,idProperty: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
      //~ ,idIndex: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
    });


Lino.CalendarCfg = {
    dateParamFormat: 'd.m.Y',
    dateParamStart:'sd',
    dateParamEnd:'ed'
};
//~ 20120704 Lino.CalendarPanel = Ext.extend(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
//~ Lino.CalendarPanel = Ext.extend(Lino.CalendarPanel,{
Ext.override(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
Ext.override(Ext.ensible.cal.CalendarPanel,{
  //~ empty_title : "\$ui.get_actor('cal.Panel').report.label",
  empty_title : "Calendar"
  ,activeItem: 1 // 0: day, 1: week
  ,ls_url: '/cal/CalendarPanel'
  //~ ,disableCaching:true
  //~ ,eventStore: Lino.eventStore
  //~ ,calendarStore: Lino.calendarStore
  //~ ,initComponent : function(){
    //~ Ext.ensible.cal.CalendarPanel.superclass.initComponent.call(this);
    //~ this.eventStore.on('load',function(){
      //~ console.log("20130808",Lino.eventStore);
      //~ if (this.eventStore.reader.jsonData) {
        //~ console.log("20130808 b",this.eventStore.reader.jsonData.title);
        //~ this.set_window_title(this.eventStore.reader.jsonData.title);
      //~ }
    //~ },this);
  //~ }
  ,listeners: { 
    editdetails: function(cp,rec,el) {
      //~ console.log("Lino.on_editdetails",arguments);
      if (rec.data.ID)
          Lino.cal.PanelEvents.detail.run(null,{
              record_id:rec.data.ID,
              base_params:this.app_instance.event_store.baseParams});
      return false;
    }
    ,eventclick: function(cp,rec,el) {
      //~ console.log("Lino.on_eventclick",arguments);
      //~ Lino.cal.Events.detail_action.run({record_id:rec.data.ID});
      Lino.cal.PanelEvents.detail.run(null,{
            record_id:rec.data.ID,
                base_params:this.app_instance.event_store.baseParams});
      return false;
    }
    //~ ,eventadd: Lino.on_eventadd
    //~ ,eventdelete: Lino.on_eventdelete
    //~ ,eventresize: Lino.on_eventresize
    ,afterrender : function(config) {
      //~ console.log("20120704 afterrender");
      this.app_instance.calendar_store.load();
      //~ console.log("20120704 afterrender calls eventStore.load()",p);
      this.app_instance.event_store.cal_panel = this;
      //~ Lino.eventStore.load({params:p});
      //~ 20130905 removed: this.app_instance.event_store.load();
      //~ Lino.CalendarPanel.superclass.constructor.call(this, config);
      //~ console.log(20120118, config,this);
    }
    }
  ,enableEditDetails: false
  //~ ,monthViewCfg: Lino.CalendarCfg
  //~ ,weekViewCfg: Lino.CalendarCfg
  //~ ,multiDayViewCfg: Lino.CalendarCfg
  //~ ,multiWeekViewCfg: Lino.CalendarCfg
  //~ ,dayViewCfg: Lino.CalendarCfg
  //~ ,initComponent : function() {
    //~ // this.on('eventadd',Lino.on_eventadd);
    //~ Lino.CalendarPanel.superclass.initComponent.call(this);
  //~ }
});




Lino.CalendarAppPanel = Ext.extend(Ext.Panel,Lino.MainPanel);
Lino.CalendarAppPanel = Ext.extend(Lino.CalendarAppPanel,Lino.PanelMixin);
Lino.CalendarAppPanel = Ext.extend(Lino.CalendarAppPanel,{
  app_instance : null
  //~ empty_title : "\$ui.get_actor('cal.Panel').report.label",
  ,empty_title : "Calendar"
  ,ls_url: '/cal/CalendarPanel'
  ,set_status : function(status,rp) { 
      this.requesting_panel = Ext.getCmp(rp);
      //~ console.log('20120918 CalendarAppPanel.set_status()',status,rp,this.requesting_panel);
      this.clear_base_params();
      if (status == undefined) status = {};
      //~ if (status.param_values) 
      //~ this.set_field_values(status.field_values);
      if (status.base_params) this.set_base_params(status.base_params);
      this.refresh();
      }
  ,refresh : function() {
      //~ this.app_instance.event_store.reload(); 20130905
      this.app_instance.event_store.load();
  }
  ,layout: 'fit'
  ,get_base_params : function() {
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
  }
  ,set_base_params : function(p) {
    this.base_params = Ext.apply(this.app_instance.event_store.baseParams,p);
    this.app_instance.event_store.baseParams = this.base_params;
  }
  ,clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  }
  ,set_base_param : function(k,v) {
      if (!this.base_params) this.base_params = {};
      this.base_params[k] = v;
  }
});

Lino.CalendarApp = function() { return {
  team_view_button : null 
  ,get_main_panel : function() {
      var cap = null;
      this.event_store = new Ext.data.JsonStore({ 
          listeners: { exception: Lino.on_store_exception }
          ,url: '/restful/cal/PanelEvents'
          ,restful : true
          ,proxy: new Ext.data.HttpProxy({ 
              url: '/restful/cal/PanelEvents', 
              disableCaching: false // no need for cache busting when loading via Ajax
              //~ disableCaching:true,
          })
          ,fields: Ext.ensible.cal.EventRecord.prototype.fields.getRange()
          ,totalProperty: "count"
          ,root: "rows"
          ,idProperty: Ext.ensible.cal.EventMappings.EventId.mapping
          ,writer : new Ext.data.JsonWriter({
            writeAllFields: false
          })
          ,load: function(options) {
            //~ foo.bar = baz; // 20120213
              if (!options) options = {};
              if (!options.params) options.params = {};
              //~ options.params.$ext_requests.URL_PARAM_TEAM_VIEW = Lino.calendar_app.team_view_button.pressed;
              
              var view = this.cal_panel.getActiveView();
              var bounds = view.getViewBounds();
              //~ var p = {sd:'05.02.2012',ed:'11.02.2012'};
              //~ var p = {};
              options.params[view.dateParamStart] = bounds.start.format(view.dateParamFormat);
              options.params[view.dateParamEnd] = bounds.end.format(view.dateParamFormat);
              Lino.insert_subst_user(options.params);
              //~ this.cal_panel.base_params.su.toString();
              //~ if (this.cal_panel) {
                  Ext.apply(options.params,this.cal_panel.base_params);
              //~ }
              //~ Ext.apply(options.params,p)
              //~ console.log('20130905 eventStore.load()',this.cal_panel,this.baseParams,options.params);
            
            return Ext.data.JsonStore.prototype.load.call(this,options);
          }
      });

      //~ Lino.calendarStore
      this.calendar_store = new Ext.data.JsonStore({ 
          listeners: { exception: Lino.on_store_exception }
          ,restful : true
          ,proxy: new Ext.data.HttpProxy({ 
              //~ url: '/restful/cal/PanelCalendars?fmt=json', 
              url: '/restful/cal/PanelCalendars?fmt=%7B%7Bext_requests.URL_FORMAT_JSON%7D%7D', 
              disableCaching: false // no need for cache busting when loading via Ajax
              //~ restful : true
              //~ method: "GET"
          })
          //~ ,autoLoad: true
          //~ ,remoteSort: true
          //~ ,baseParams: bp
          ,totalProperty: "count"
          ,root: "rows"
          ,fields: Ext.ensible.cal.CalendarRecord.prototype.fields.getRange()
          ,idProperty: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
          //~ ,idIndex: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
      });
      
      cap = new Lino.CalendarAppPanel({ 
          app_instance: this, 
          items : 
        //~ [{
          //~ id: 'app-header',
          //~ region: 'north',
          //~ height: 35,
          //~ border: false,
          // contentEl: 'app-header-content'
        //~ },
      {
          id: 'app-center',
          title: '...', // will be updated to the current view's date range
          region: 'center',
          layout: 'border',
          listeners: {
              'afterrender': function(){
                  Ext.getCmp('app-center').header.addClass('app-center-header');
              }
          },
          items: [{
              id:'app-west',
              region: 'west',
              width: 176,
              border: false,
              items: [{
                  xtype: 'datepicker',
                  id: 'app-nav-picker',
                  cls: 'ext-cal-nav-picker',
                  listeners: {
                      'select': {
                          fn: function(dp, dt){
                              console.log(20131017,dp);
                              //~ Lino.calendarPanel.setStartDate(dt);
                              //~ cap.setStartDate(dt);
                              Ext.getCmp('app-calendar').setStartDate(dt);
                          },
                          //~ scope: this
                      }
                  }
              //~ },{ 
                //~ layout:'fit',
                //~ items: [
                  //~ new Ext.form.Checkbox({
                    //~ boxLabel:"$_('Team view')",
                    //~ hideLabel:true
                    //~ listeners: { click: }
                  //~ })
                //~ ]
              //~ },{ 
                //~ layout:'form',
                //~ items: [
                  //~ this.team_view_button = new Ext.Button({
                    //~ text:"Team view",
                    //~ enableToggle:true,
                    //~ pressed:false,
                    //~ toggleHandler: function(btn,state) { 
                      //~ // console.log('20120716 teamView.toggle()');
                      //~ this.event_store.setBaseParam('tv',state);
                      //~ this.event_store.load();
                      //~ // Lino.eventStore.load({params:{$ext_requests.URL_PARAM_TEAM_VIEW:state}});
                      //~ // console.log("team view",state);
                    //~ }
                  //~ })
                //~ ]
              },{
                  xtype: 'extensible.calendarlist',
                  store: this.calendar_store,
                  border: false,
                  width: 175
              }]
          },{
              xtype: 'extensible.calendarpanel', // Ext.ensible.cal.CalendarPanel
              eventStore: this.event_store,
              app_instance: this,
              calendarStore: this.calendar_store,
              border: false,
              id:'app-calendar',
              region: 'center',
              //~ activeItem: 3, // month view
              
              // Any generic view options that should be applied to all sub views:
              viewConfig: {
                  // Lino.CalendarCfg
                  dateParamFormat: 'd.m.Y',
                  dateParamStart:'sd',
                  dateParamEnd:'ed',
                
                  //enableFx: false,
                  //ddIncrement: 10, //only applies to DayView and subclasses, but convenient to put it here
                  viewStartHour: 8, // 8
                  viewEndHour: 18 // 18
                  //minEventDisplayMinutes: 15
              },
              
              // View options specific to a certain view (if the same options exist in viewConfig
              // they will be overridden by the view-specific config):
              monthViewCfg: {
                  showHeader: true,
                  showWeekLinks: true,
                  showWeekNumbers: true,
                  eventBodyMarkup: ['{Title}',
                    //~ '<tpl if="url">',
                        //~ '<a href="{url}">XX</a>',
                    //~ '</tpl>',
                    '<tpl if="_isReminder">',
                        '<i class="ext-cal-ic ext-cal-ic-rem">&#160;</i>',
                    '</tpl>',
                    '<tpl if="_isRecurring">',
                        '<i class="ext-cal-ic ext-cal-ic-rcr">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanLeft">',
                        '<i class="ext-cal-spl">&#160;</i>',
                    '</tpl>',
                    '<tpl if="spanRight">',
                        '<i class="ext-cal-spr">&#160;</i>',
                    '</tpl>'
                ].join('')
              },
              
              multiWeekViewCfg: {
                  //weekCount: 3
              },
              
              // Some optional CalendarPanel configs to experiment with:
              //readOnly: true,
              //showDayView: false,
              //showMultiDayView: true,
              //showWeekView: false,
              //showMultiWeekView: false,
              //showMonthView: false,
              //showNavBar: false,
              //showTodayText: false,
              //showTime: false,
              //editModal: true,
              //enableEditDetails: false,
              //title: 'My Calendar', // the header of the calendar, could be a subtitle for the app
              
              // Once this component inits it will set a reference to itself as an application
              // member property for easy reference in other functions within App.
              //~ initComponent: function() {
                  //~ Lino.calendarPanel = this;
                  //~ this.constructor.prototype.initComponent.apply(this, arguments);
              //~ },
              
              listeners: {
                  //~ 'eventclick': {
                      //~ fn: function(vw, rec, el){
                          //~ this.clearMsg();
                      //~ },
                      //~ scope: this
                  //~ },
                  'eventover': function(vw, rec, el){
                      //console.log('Entered evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]', view='+ vw.id +', el='+el.id);
                  },
                  'eventout': function(vw, rec, el){
                      //console.log('Leaving evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]+', view='+ vw.id +', el='+el.id);
                  },
                  'eventadd': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was added');
                      },
                      scope: this
                  },
                  'eventupdate': {
                      fn: function(cp, rec){
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(cp, rec){
                          //this.eventStore.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'eventcancel': {
                      fn: function(cp, rec){
                          // edit canceled
                      },
                      scope: this
                  },
                  'viewchange': {
                      fn: function(p, vw, dateInfo){
                          if(this.editWin){
                              this.editWin.hide();
                          };
                          if(dateInfo !== null){
                              // will be null when switching to the event edit form so ignore
                              Ext.getCmp('app-nav-picker').setValue(dateInfo.activeDate);
                              this.updateTitle(dateInfo.viewStart, dateInfo.viewEnd);
                          }
                          
                      },
                      scope: this
                  },
                  'dayclick': {
                      fn: function(vw, dt, ad, el){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'rangeselect': {
                      fn: function(vw, dates, onComplete){
                          this.clearMsg();
                      },
                      scope: this
                  },
                  'eventmove': {
                      fn: function(vw, rec){
                          rec.commit();
                          var time = rec.data[Ext.ensible.cal.EventMappings.IsAllDay.name] ? '' : ' \\a\\t g:i a';
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was moved to '+
                              rec.data[Ext.ensible.cal.EventMappings.StartDate.name].format('F jS'+time));
                      },
                      scope: this
                  },
                  'eventresize': {
                      fn: function(vw, rec){
                          rec.commit();
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                      },
                      scope: this
                  },
                  'eventdelete': {
                      fn: function(win, rec){
                          this.event_store.remove(rec);
                          this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                      },
                      scope: this
                  },
                  'initdrag': {
                      fn: function(vw){
                          if(this.editWin && this.editWin.isVisible()){
                              this.editWin.hide();
                          }
                      },
                      scope: this
                  }
              }
          }]
        }
        //~ ]
        
      });
      
      this.event_store.on('load',function(){
        //~ console.log("20130905 on event_store load",this.event_store.reader.jsonData);
        if (this.event_store.reader.jsonData) {
          //~ console.log("20130808 b",this.event_store.reader.jsonData.title);
          //~ console.log("20130808 c",this);
          cap.set_window_title(this.event_store.reader.jsonData.title);
        }
      },this);
      
      //~ cap.app_instance = this;
      return cap;
      
  }
  ,updateTitle: function(startDt, endDt){
      var p = Ext.getCmp('app-center');
      
      if(startDt.clearTime().getTime() == endDt.clearTime().getTime()){
          p.setTitle(startDt.format('F j, Y'));
      }
      else if(startDt.getFullYear() == endDt.getFullYear()){
          if(startDt.getMonth() == endDt.getMonth()){
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('j, Y'));
          }
          else{
              p.setTitle(startDt.format('F j') + ' - ' + endDt.format('F j, Y'));
          }
      }
      else{
          p.setTitle(startDt.format('F j, Y') + ' - ' + endDt.format('F j, Y'));
      }
  }
  // This is an application-specific way to communicate CalendarPanel event messages back to the user.
  // This could be replaced with a function to do "toast" style messages, growl messages, etc. This will
  // vary based on application requirements, which is why it's not baked into the CalendarPanel.
  ,showMsg: function(msg){
      Lino.notify(msg);
      //~ Ext.fly('app-msg').update(msg).removeClass('x-hidden');
  }
  
  ,clearMsg: function(){
      Lino.notify('');
      //~ Ext.fly('app-msg').update('').addClass('x-hidden');
  }
}
};




/*
captureEvents utility by Aaron Conran
<http://www.sencha.com/learn/grid-faq/>

Ext.onReady(function(){
    var grid = new Ext.grid.GridPanel({
        ... 
    });
    captureEvents(grid);
});
*/
function captureEvents(observable) {
    Ext.util.Observable.capture(
        observable,
        function(eventName) {
            console.info(eventName);
        },
        this
    );		
}

// settings.SITE.get_plugin_snippets()



Lino.main_menu = [ { "menu": { "items": [ { "text": "Persons", "handler": function() {Lino.contacts.Persons.grid.run(null)} }, { "text": "Companies", "handler": function() {Lino.contacts.Companies.grid.run(null)} }, { "text": "Partners", "handler": function() {Lino.contacts.Partners.grid.run(null)} }, { "text": "Households", "handler": function() {Lino.households.Households.grid.run(null)} } ] }, "text": "Contacts" }, { "menu": { "items": [ { "text": "Products", "handler": function() {Lino.products.Products.grid.run(null)} }, { "text": "Product Categories", "handler": function() {Lino.products.ProductCats.grid.run(null)} } ] }, "text": "Products" }, { "menu": { "items": [ { "text": "Invoices to create", "listeners": { "render": Lino.quicktip_renderer("Foo","Table of all partners who should receive an invoice.") }, "handler": function() {Lino.sales.InvoicesToCreate.grid.run(null)} } ] }, "text": "Sales" }, { "menu": { "items": [ { "text": "My Blog Entries", "handler": function() {Lino.blogs.MyEntries.grid.run(null)} } ] }, "text": "Blog" }, { "menu": { "items": [ { "text": "My Projects", "handler": function() {Lino.tickets.MyProjects.grid.run(null)} }, { "text": "My Tickets", "handler": function() {Lino.tickets.MyOpenTickets.grid.run(null)} }, { "text": "My Tickets", "handler": function() {Lino.tickets.MyTickets.grid.run(null)} }, { "text": "My Sessions", "handler": function() {Lino.tickets.MySessions.grid.run(null)} }, { "text": "My sessions by date", "handler": function() {Lino.tickets.MySessionsByDate.grid.run(null)} } ] }, "text": "Tickets" }, { "menu": { "items": [ { "text": "My events", "listeners": { "render": Lino.quicktip_renderer("Foo","Table of all my calendar events.") }, "handler": function() {Lino.cal.MyEvents.grid.run(null)} }, { "text": "My tasks", "listeners": { "render": Lino.quicktip_renderer("Foo","Table of all my tasks.") }, "handler": function() {Lino.cal.MyTasks.grid.run(null)} }, { "text": "My guests", "handler": function() {Lino.cal.MyGuests.grid.run(null)} }, { "text": "My presences", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows all my presences in calendar events, independently of their state.") }, "handler": function() {Lino.cal.MyPresences.grid.run(null)} }, { "text": "Calendar", "iconCls": "x-tbar-calendar", "handler": function() {Lino.extensible.CalendarPanel.grid.run(null)}, "listeners": { "render": Lino.quicktip_renderer("Foo","Displays your events in a \"calendar view\"     with the possibility to switch between daily, weekly, monthly view.") } } ] }, "text": "Calendar" }, { "menu": { "items": [ { "text": "My Outbox", "handler": function() {Lino.outbox.MyOutbox.grid.run(null)} } ] }, "text": "Office" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "My Text Field Templates", "handler": function() {Lino.system.MyTextFieldTemplates.grid.run(null)} }, { "text": "Upload Types", "handler": function() {Lino.uploads.UploadTypes.grid.run(null)} } ] }, "text": "Office" }, { "menu": { "items": [ { "text": "Site Parameters", "iconCls": "x-tbar-application_form", "handler": function() {Lino.system.SiteConfigs.detail.run(null,{ "record_id": 1 })} }, { "text": "Users", "listeners": { "render": Lino.quicktip_renderer("Foo","Shows the list of all users on this site.") }, "handler": function() {Lino.users.Users.grid.run(null)} }, { "text": "Teams", "handler": function() {Lino.users.Teams.grid.run(null)} }, { "text": "content types", "handler": function() {Lino.system.ContentTypes.grid.run(null)} }, { "text": "Help Texts", "handler": function() {Lino.system.HelpTexts.grid.run(null)} } ] }, "text": "System" }, { "menu": { "items": [ { "text": "Countries", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    A country is a geographic entity considered a \"nation\".\n    ") }, "handler": function() {Lino.countries.Countries.grid.run(null)} }, { "text": "Places", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    The table of known geographical places.\n    A geographical place can be a city, a town, a suburb, \n    a province, a lake... any named geographic entity,\n    except for countries because these have their own table.\n    ") }, "handler": function() {Lino.countries.Cities.grid.run(null)} }, { "text": "company types", "handler": function() {Lino.contacts.CompanyTypes.grid.run(null)} }, { "text": "Functions", "handler": function() {Lino.contacts.RoleTypes.grid.run(null)} } ] }, "text": "Contacts" }, { "menu": { "items": [ { "text": "Property Groups", "handler": function() {Lino.properties.PropGroups.grid.run(null)} }, { "text": "Property Types", "handler": function() {Lino.properties.PropTypes.grid.run(null)} } ] }, "text": "Properties" }, { "menu": { "items": [ { "text": "Household Roles", "handler": function() {Lino.households.Roles.grid.run(null)} }, { "text": "Household Types", "handler": function() {Lino.households.Types.grid.run(null)} } ] }, "text": "Households" }, { "menu": { "items": [ { "text": "Account Charts", "handler": function() {Lino.accounts.Charts.grid.run(null)} }, { "text": "Account Groups", "handler": function() {Lino.accounts.Groups.grid.run(null)} }, { "text": "Accounts", "handler": function() {Lino.accounts.Accounts.grid.run(null)} }, { "text": "Journals", "handler": function() {Lino.ledger.Journals.grid.run(null)} } ] }, "text": "Accounting" }, { "menu": { "items": [ { "text": "Invoicing Modes", "handler": function() {Lino.sales.InvoicingModes.grid.run(null)} }, { "text": "Shipping Modes", "handler": function() {Lino.sales.ShippingModes.grid.run(null)} }, { "text": "Payment Terms", "handler": function() {Lino.sales.PaymentTerms.grid.run(null)} } ] }, "text": "Sales" }, { "menu": { "items": [ { "text": "Blog Entry Types", "handler": function() {Lino.blogs.EntryTypes.grid.run(null)} } ] }, "text": "Blog" }, { "menu": { "items": [ { "text": "Project Types", "handler": function() {Lino.tickets.ProjectTypes.grid.run(null)} }, { "text": "Session Types", "handler": function() {Lino.tickets.SessionTypes.grid.run(null)} } ] }, "text": "Tickets" }, { "menu": { "items": [ { "text": "Calendars", "handler": function() {Lino.cal.Calendars.grid.run(null)} }, { "text": "Rooms", "listeners": { "render": Lino.quicktip_renderer("Foo","List of rooms where calendar events can happen.") }, "handler": function() {Lino.cal.Rooms.grid.run(null)} }, { "text": "Priorities", "listeners": { "render": Lino.quicktip_renderer("Foo","List of possible priorities of calendar events.") }, "handler": function() {Lino.cal.Priorities.grid.run(null)} }, { "text": "Recurrent Events", "handler": function() {Lino.cal.RecurrentEvents.grid.run(null)} }, { "text": "Guest Roles", "listeners": { "render": Lino.quicktip_renderer("Foo","The role of a guest expresses what the \n    partner is going to do there.") }, "handler": function() {Lino.cal.GuestRoles.grid.run(null)} }, { "text": "Event Types", "listeners": { "render": Lino.quicktip_renderer("Foo","The list of Event Types defined on this system.\n    An EventType is a list of events which have certain things in common,\n    especially they are displayed in the same colour in the calendar panel") }, "handler": function() {Lino.cal.EventTypes.grid.run(null)} }, { "text": "Remote Calendars", "handler": function() {Lino.cal.RemoteCalendars.grid.run(null)} } ] }, "text": "Calendar" } ] }, "text": "Configure" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "Text Field Templates", "handler": function() {Lino.system.TextFieldTemplates.grid.run(null)} }, { "text": "Uploads", "handler": function() {Lino.uploads.Uploads.grid.run(null)} }, { "text": "Outgoing Mails", "handler": function() {Lino.outbox.Mails.grid.run(null)} }, { "text": "Attachments", "handler": function() {Lino.outbox.Attachments.grid.run(null)} } ] }, "text": "Office" }, { "menu": { "items": [ { "text": "Authorities", "handler": function() {Lino.users.Authorities.grid.run(null)} }, { "text": "User Groups", "handler": function() {Lino.lino.UserGroups.grid.run(null)} }, { "text": "User Levels", "handler": function() {Lino.lino.UserLevels.grid.run(null)} }, { "text": "User Profiles", "handler": function() {Lino.lino.UserProfiles.grid.run(null)} } ] }, "text": "System" }, { "menu": { "items": [ { "text": "Contact Persons", "handler": function() {Lino.contacts.Roles.grid.run(null)} } ] }, "text": "Contacts" }, { "menu": { "items": [ { "text": "Household Members", "handler": function() {Lino.households.Members.grid.run(null)} } ] }, "text": "Households" }, { "menu": { "items": [ { "text": "Invoices", "handler": function() {Lino.ledger.Invoices.grid.run(null)} }, { "text": "Vouchers", "handler": function() {Lino.ledger.Vouchers.grid.run(null)} }, { "text": "VoucherTypes", "handler": function() {Lino.ledger.VoucherTypes.grid.run(null)} }, { "text": "Movements", "handler": function() {Lino.ledger.Movements.grid.run(null)} }, { "text": "Fiscal Years", "handler": function() {Lino.ledger.FiscalYears.grid.run(null)} } ] }, "text": "Accounting" }, { "menu": { "items": [ { "text": "VatRegimes", "listeners": { "render": Lino.quicktip_renderer("Foo","Determines how the VAT is being handled, i.e. whether and how it is to be paid.") }, "handler": function() {Lino.vat.VatRegimes.grid.run(null)} }, { "text": "TradeTypes", "listeners": { "render": Lino.quicktip_renderer("Foo","The type of trade: usually either `sales` or `purchases`.") }, "handler": function() {Lino.vat.TradeTypes.grid.run(null)} }, { "text": "VatClasses", "handler": function() {Lino.vat.VatClasses.grid.run(null)} } ] }, "text": "VAT" }, { "menu": { "items": [ { "text": "Blog Entries", "handler": function() {Lino.blogs.Entries.grid.run(null)} } ] }, "text": "Blog" }, { "menu": { "items": [ { "text": "Projects", "handler": function() {Lino.tickets.Projects.grid.run(null)} }, { "text": "Tickets", "handler": function() {Lino.tickets.Tickets.grid.run(null)} }, { "text": "Sessions", "handler": function() {Lino.tickets.Sessions.grid.run(null)} }, { "text": "Milestones", "handler": function() {Lino.tickets.Milestones.grid.run(null)} } ] }, "text": "Tickets" }, { "menu": { "items": [ { "text": "Tasks", "listeners": { "render": Lino.quicktip_renderer("Foo","A calendar task is something you need to do.\n    ") }, "handler": function() {Lino.cal.Tasks.grid.run(null)} }, { "text": "Guests", "listeners": { "render": Lino.quicktip_renderer("Foo","A guest is a partner invited to an event.\n    ") }, "handler": function() {Lino.cal.Guests.grid.run(null)} }, { "text": "Subscriptions", "handler": function() {Lino.cal.Subscriptions.grid.run(null)} }, { "text": "Event states", "listeners": { "render": Lino.quicktip_renderer("Foo","The possible states of a calendar event.") }, "handler": function() {Lino.cal.EventStates.grid.run(null)} }, { "text": "Guest states", "handler": function() {Lino.cal.GuestStates.grid.run(null)} }, { "text": "Task states", "handler": function() {Lino.cal.TaskStates.grid.run(null)} } ] }, "text": "Calendar" } ] }, "text": "Explorer" }, { "menu": { "items": [ { "text": "About", "listeners": { "render": Lino.quicktip_renderer("Foo","Show information about this site.") }, "handler": function() {Lino.about.About.show.run(null,{ "record_id": -99998 })} } ] }, "text": "Site" }, { "text": "Home", "handler": function() {Lino.close_all_windows()} } ];
Ext.namespace('Lino.system.SiteConfigs')
Ext.namespace('Lino.system.ContentTypes')
Ext.namespace('Lino.system.HelpTexts')
Ext.namespace('Lino.system.TextFieldTemplates')
Ext.namespace('Lino.users.Users')
Ext.namespace('Lino.users.MySettings')
Ext.namespace('Lino.users.UsersOverview')
Ext.namespace('Lino.users.Teams')
Ext.namespace('Lino.users.Memberships')
Ext.namespace('Lino.users.Authorities')
Ext.namespace('Lino.countries.Countries')
Ext.namespace('Lino.countries.Cities')
Ext.namespace('Lino.properties.PropGroups')
Ext.namespace('Lino.properties.PropTypes')
Ext.namespace('Lino.properties.Properties')
Ext.namespace('Lino.properties.PropChoices')
Ext.namespace('Lino.contacts.CompanyTypes')
Ext.namespace('Lino.contacts.Partners')
Ext.namespace('Lino.contacts.Persons')
Ext.namespace('Lino.contacts.Companies')
Ext.namespace('Lino.contacts.RoleTypes')
Ext.namespace('Lino.contacts.Roles')
Ext.namespace('Lino.households.Types')
Ext.namespace('Lino.households.Households')
Ext.namespace('Lino.households.Roles')
Ext.namespace('Lino.households.Members')
Ext.namespace('Lino.accounts.Charts')
Ext.namespace('Lino.accounts.Groups')
Ext.namespace('Lino.accounts.Accounts')
Ext.namespace('Lino.products.ProductCats')
Ext.namespace('Lino.products.Products')
Ext.namespace('Lino.ledger.Journals')
Ext.namespace('Lino.ledger.Vouchers')
Ext.namespace('Lino.ledger.Movements')
Ext.namespace('Lino.ledger.Invoices')
Ext.namespace('Lino.sales.PaymentTerms')
Ext.namespace('Lino.sales.InvoicingModes')
Ext.namespace('Lino.sales.ShippingModes')
Ext.namespace('Lino.sales.Invoices')
Ext.namespace('Lino.sales.DocumentsToSign')
Ext.namespace('Lino.blogs.EntryTypes')
Ext.namespace('Lino.blogs.Entries')
Ext.namespace('Lino.tickets.ProjectTypes')
Ext.namespace('Lino.tickets.SessionTypes')
Ext.namespace('Lino.tickets.Projects')
Ext.namespace('Lino.tickets.Milestones')
Ext.namespace('Lino.tickets.Tickets')
Ext.namespace('Lino.tickets.UnassignedTickets')
Ext.namespace('Lino.tickets.Sessions')
Ext.namespace('Lino.cal.RemoteCalendars')
Ext.namespace('Lino.cal.Rooms')
Ext.namespace('Lino.cal.Priorities')
Ext.namespace('Lino.cal.Calendars')
Ext.namespace('Lino.cal.Subscriptions')
Ext.namespace('Lino.cal.Tasks')
Ext.namespace('Lino.cal.MyTasks')
Ext.namespace('Lino.outbox.Recipients')
Ext.namespace('Lino.outbox.Mails')
Ext.namespace('Lino.outbox.Attachments')
Ext.namespace('Lino.cal.GuestRoles')
Ext.namespace('Lino.cal.Guests')
Ext.namespace('Lino.cal.MyPresences')
Ext.namespace('Lino.cal.MyPendingPresences')
Ext.namespace('Lino.cal.MyGuests')
Ext.namespace('Lino.cal.EventTypes')
Ext.namespace('Lino.cal.RecurrentEvents')
Ext.namespace('Lino.cal.Events')
Ext.namespace('Lino.cal.OneEvent')
Ext.namespace('Lino.cal.MyEvents')
Ext.namespace('Lino.cal.MyAssignedEvents')
Ext.namespace('Lino.uploads.UploadTypes')
Ext.namespace('Lino.uploads.Uploads')
Ext.namespace('Lino.extensible.PanelCalendars')
Ext.namespace('Lino.extensible.PanelEvents')
Ext.namespace('Lino.sales.SalesRuleTable')
Ext.namespace('Lino.sales.InvoiceItemTable')
Ext.namespace('Lino.sessions.SessionTable')
Ext.namespace('Lino.ledger.InvoiceItemTable')
Ext.namespace('Lino.system.MyTextFieldTemplates')
Ext.namespace('Lino.users.MembershipsByUser')
Ext.namespace('Lino.users.AuthoritiesGiven')
Ext.namespace('Lino.users.AuthoritiesTaken')
Ext.namespace('Lino.countries.CitiesByCity')
Ext.namespace('Lino.countries.CitiesByCountry')
Ext.namespace('Lino.properties.PropsByGroup')
Ext.namespace('Lino.properties.PropsByType')
Ext.namespace('Lino.properties.ChoicesByType')
Ext.namespace('Lino.contacts.PartnersByCity')
Ext.namespace('Lino.contacts.PartnersByCountry')
Ext.namespace('Lino.contacts.RolesByCompany')
Ext.namespace('Lino.contacts.RolesByPerson')
Ext.namespace('Lino.households.HouseholdsByType')
Ext.namespace('Lino.households.MembersByHousehold')
Ext.namespace('Lino.households.MembersByPerson')
Ext.namespace('Lino.households.MembersByRole')
Ext.namespace('Lino.accounts.GroupsByChart')
Ext.namespace('Lino.accounts.AccountsByGroup')
Ext.namespace('Lino.products.ProductsByCategory')
Ext.namespace('Lino.ledger.MovementsByVoucher')
Ext.namespace('Lino.ledger.MovementsByPartner')
Ext.namespace('Lino.ledger.MovementsByAccount')
Ext.namespace('Lino.ledger.InvoicesByJournal')
Ext.namespace('Lino.ledger.InvoicesByPartner')
Ext.namespace('Lino.ledger.ItemsByInvoice')
Ext.namespace('Lino.sales.ItemsByInvoicePrint')
Ext.namespace('Lino.sales.InvoiceItemsByProduct')
Ext.namespace('Lino.sales.InvoicesByJournal')
Ext.namespace('Lino.sales.InvoicesByPartner')
Ext.namespace('Lino.sales.ItemsByInvoice')
Ext.namespace('Lino.blogs.MyEntries')
Ext.namespace('Lino.blogs.EntriesByType')
Ext.namespace('Lino.tickets.ProjectsByProject')
Ext.namespace('Lino.tickets.ProjectsByPartner')
Ext.namespace('Lino.tickets.MilestonesByProject')
Ext.namespace('Lino.tickets.TicketsByProject')
Ext.namespace('Lino.tickets.TicketsByPartner')
Ext.namespace('Lino.tickets.TicketsFixed')
Ext.namespace('Lino.tickets.TicketsReported')
Ext.namespace('Lino.tickets.SessionsByTicket')
Ext.namespace('Lino.tickets.SessionsByProject')
Ext.namespace('Lino.tickets.MySessions')
Ext.namespace('Lino.tickets.MySessionsByDate')
Ext.namespace('Lino.tickets.EntriesByTicket')
Ext.namespace('Lino.tickets.EntriesBySession')
Ext.namespace('Lino.tickets.MyProjects')
Ext.namespace('Lino.tickets.MyTickets')
Ext.namespace('Lino.tickets.MyOpenTickets')
Ext.namespace('Lino.cal.SubscriptionsByUser')
Ext.namespace('Lino.cal.TasksByUser')
Ext.namespace('Lino.cal.TasksByProject')
Ext.namespace('Lino.outbox.RecipientsByMail')
Ext.namespace('Lino.outbox.MyOutbox')
Ext.namespace('Lino.outbox.MailsByUser')
Ext.namespace('Lino.outbox.MailsByProject')
Ext.namespace('Lino.outbox.SentByPartner')
Ext.namespace('Lino.outbox.AttachmentsByMail')
Ext.namespace('Lino.cal.GuestsByEvent')
Ext.namespace('Lino.cal.GuestsByRole')
Ext.namespace('Lino.cal.GuestsByPartner')
Ext.namespace('Lino.cal.EventsByType')
Ext.namespace('Lino.cal.EventsByRoom')
Ext.namespace('Lino.cal.EventsByProject')
Ext.namespace('Lino.uploads.MyUploads')
Ext.namespace('Lino.uploads.UploadsByController')
Ext.namespace('Lino.sales.InvoicingsByInvoiceable')
Ext.namespace('Lino.system.HelpTextsByModel')
Ext.namespace('Lino.cal.TasksByController')
Ext.namespace('Lino.outbox.MailsByController')
Ext.namespace('Lino.outbox.AttachmentsByController')
Ext.namespace('Lino.cal.EventsByController')
Ext.namespace('Lino.blogs.EntriesByController')
Ext.namespace('Lino.about.Models')
Ext.namespace('Lino.about.FieldsByModel')
Ext.namespace('Lino.about.Inspector')
Ext.namespace('Lino.about.SourceFiles')
Ext.namespace('Lino.ledger.ExpectedMovements')
Ext.namespace('Lino.ledger.DebtsByAccount')
Ext.namespace('Lino.ledger.DebtsByPartner')
Ext.namespace('Lino.ledger.GeneralAccountsBalance')
Ext.namespace('Lino.ledger.PartnerAccountsBalance')
Ext.namespace('Lino.ledger.ClientAccountsBalance')
Ext.namespace('Lino.ledger.SupplierAccountsBalance')
Ext.namespace('Lino.sales.InvoicesToCreate')
Ext.namespace('Lino.sales.InvoiceablesByPartner')
Ext.namespace('Lino.lino.Report')
Ext.namespace('Lino.about.About')
Ext.namespace('Lino.system.Home')
Ext.namespace('Lino.ledger.ActivityReport')
Ext.namespace('Lino.extensible.CalendarPanel')
Ext.namespace('Lino.vat.VatClasses')
Ext.namespace('Lino.vat.TradeTypes')
Ext.namespace('Lino.cal.DurationUnits')
Ext.namespace('Lino.cal.TaskStates')
Ext.namespace('Lino.cal.Weekdays')
Ext.namespace('Lino.ledger.InvoiceStates')
Ext.namespace('Lino.accounts.AccountTypes')
Ext.namespace('Lino.lino.UserLevels')
Ext.namespace('Lino.lino.YesNo')
Ext.namespace('Lino.cal.EventStates')
Ext.namespace('Lino.ledger.FiscalYears')
Ext.namespace('Lino.cal.Recurrencies')
Ext.namespace('Lino.properties.HowWell')
Ext.namespace('Lino.outbox.RecipientType')
Ext.namespace('Lino.cal.EventEvents')
Ext.namespace('Lino.cal.GuestStates')
Ext.namespace('Lino.countries.CityTypes')
Ext.namespace('Lino.properties.DoYouLike')
Ext.namespace('Lino.vat.VatRegimes')
Ext.namespace('Lino.ledger.VoucherTypes')
Ext.namespace('Lino.lino.UserGroups')
Ext.namespace('Lino.cal.AccessClasses')
Ext.namespace('Lino.lino.Genders')
Ext.namespace('Lino.lino.UserProfiles')
Ext.namespace('Lino.sales.InvoiceStates')
Ext.namespace('Lino.tickets.TicketStates')

// ChoiceLists: 
Lino.vat.VatClasses = [ [ "0", "Exempt" ], [ "1", "Reduced" ], [ "2", "Normal" ] ];
Lino.vat.TradeTypes = [ [ "S", "Sales" ], [ "P", "Purchases" ], [ "W", "Wages" ] ];
Lino.cal.DurationUnits = [ [ "s", "seconds" ], [ "m", "minutes" ], [ "h", "hours" ], [ "D", "days" ], [ "W", "weeks" ], [ "M", "months" ], [ "Y", "years" ] ];
Lino.cal.TaskStates = [ [ "10", "To do" ], [ "20", "Started" ], [ "30", "Done" ], [ "50", "Cancelled" ] ];
Lino.cal.Weekdays = [ [ "1", "Monday" ], [ "2", "Tuesday" ], [ "3", "Wednesday" ], [ "4", "Thursday" ], [ "5", "Friday" ], [ "6", "Saturday" ], [ "7", "Sunday" ] ];
Lino.ledger.InvoiceStates = [ [ "10", "Draft" ], [ "20", "Registered" ], [ "40", "Paid" ] ];
Lino.accounts.AccountTypes = [ [ "A", "Assets" ], [ "L", "Liabilities" ], [ "I", "Incomes" ], [ "E", "Expenses" ], [ "C", "Capital" ], [ "B", "Bank accounts" ] ];
Lino.lino.UserLevels = [ [ "10", "Guest" ], [ "30", "User" ], [ "40", "Manager" ], [ "50", "Administrator" ] ];
Lino.lino.YesNo = [ [ "y", "Yes" ], [ "n", "No" ] ];
Lino.cal.EventStates = [ [ "10", "Suggested" ], [ "20", "Draft" ], [ "50", "Took place" ], [ "70", "Cancelled" ] ];
Lino.ledger.FiscalYears = [ [ "11", "2011" ], [ "12", "2012" ], [ "13", "2013" ], [ "14", "2014" ], [ "15", "2015" ], [ "16", "2016" ], [ "17", "2017" ] ];
Lino.cal.Recurrencies = [ [ "O", "once" ], [ "D", "daily" ], [ "W", "weekly" ], [ "M", "monthly" ], [ "Y", "yearly" ], [ "P", "per weekday" ] ];
Lino.properties.HowWell = [ [ "0", "not at all" ], [ "1", "a bit" ], [ "2", "moderate" ], [ "3", "quite well" ], [ "4", "very well" ] ];
Lino.outbox.RecipientType = [ [ "to", "to" ], [ "cc", "cc" ], [ "bcc", "bcc" ] ];
Lino.cal.EventEvents = [ [ "10", "Okay" ], [ "20", "Pending" ] ];
Lino.cal.GuestStates = [ [ "10", "Invited" ] ];
Lino.countries.CityTypes = [ [ "10", "Member State" ], [ "11", "Division" ], [ "12", "Region" ], [ "13", "Community" ], [ "14", "Territory" ], [ "20", "County" ], [ "21", "Province" ], [ "22", "Shire" ], [ "23", "Subregion" ], [ "24", "Department" ], [ "25", "Arrondissement" ], [ "26", "Prefecture" ], [ "27", "District" ], [ "28", "Sector" ], [ "50", "City" ], [ "51", "Town" ], [ "52", "Municipality" ], [ "54", "Parish" ], [ "55", "Township" ], [ "56", "Quarter" ], [ "61", "Borough" ], [ "62", "Small borough" ], [ "70", "Village" ] ];
Lino.properties.DoYouLike = [ [ "0", "certainly not" ], [ "1", "rather not" ], [ "2", "normally" ], [ "3", "quite much" ], [ "4", "very much" ] ];
Lino.vat.VatRegimes = [ [ "10", "Private person" ], [ "20", "Subject to VAT" ], [ "25", "Co-contractor" ], [ "30", "Intra-community" ], [ "40", "Outside EU" ], [ "50", "Exempt" ] ];
Lino.ledger.VoucherTypes = [ [ "ledger.AccountInvoice", "Invoice (ledger.AccountInvoice)" ], [ "sales.Invoice", "Invoice (sales.Invoice)" ] ];
Lino.lino.UserGroups = [ [ "office", "office (Office)" ], [ "accounts", "accounts (Accounting)" ] ];
Lino.cal.AccessClasses = [ [ "10", "Private" ], [ "20", "Show busy" ], [ "30", "Public" ] ];
Lino.lino.Genders = [ [ "M", "Male" ], [ "F", "Female" ] ];
Lino.lino.UserProfiles = [ [ "000", "000 (Anonymous)" ], [ "100", "100 (User)" ], [ "900", "900 (Administrator)" ] ];
Lino.sales.InvoiceStates = [ [ "10", "Draft" ], [ "20", "Registered" ], [ "30", "Signed" ], [ "40", "Sent" ], [ "50", "Paid" ] ];
Lino.tickets.TicketStates = [ [ "10", "Accepted" ], [ "20", "Working" ], [ "30", "Waiting" ], [ "40", "Fixed" ], [ "50", "Tested" ], [ "60", "Closed" ], [ "90", "Cancelled" ] ];

Lino.cal.Guests.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var start_date1449 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Period from</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Period from","(cal.Guests.start_date) Start date of observed period") }, "anchor": "-20" });
    var end_date1450 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">until</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("until","(cal.Guests.end_date) End date of observed period") }, "anchor": "-20" });
    var user1451 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Responsible user</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Responsible user","(cal.Guests.user) Only rows managed by this user.") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/user", "method": "GET" }) }) });
    var event_state1452 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Event state</span>", "name": "event_state", "hiddenName": "event_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Event state","(cal.Guests.event_state) Only rows having this event state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.EventStates) });
    var guest_state1453 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Guest state</span>", "name": "guest_state", "hiddenName": "guest_stateHidden", "listeners": { "render": Lino.quicktip_renderer("Guest state","(cal.Guests.guest_state) Only rows having this guest state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.GuestStates) });
    var main_1_panel1454 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1449, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1450, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1451, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_state1452, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": guest_state1453, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var project1460 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail,Lino.tickets.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(cal.Guests.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/project", "method": "GET" }) }) });
    var partner1461 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "hiddenName": "partnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(cal.Guests.partner) ") }, "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }) });
    var main_2_panel1462 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1460, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1461, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel1454, main_2_panel1462 ];
    this.fields = [ start_date1449, end_date1450, user1451, event_state1452, guest_state1453, project1460, partner1461 ];
    Lino.cal.Guests.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.sales.Invoices.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 108,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'hbox',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var journal375 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Journal", "name": "journal", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail,Lino.ledger.Journals.insert)}, "emptyText": "Select a Journal...", "listeners": { "render": Lino.quicktip_renderer("Journal","(sales.Invoices.journal) ") }, "selectOnFocus": true, "hiddenName": "journalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/journal", "method": "GET" }) }) });
    var year376 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "year", "hiddenName": "yearHidden", "listeners": { "render": Lino.quicktip_renderer("Fiscal Year","(sales.Invoices.year) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    this.items = [ { "flex": 74, "autoHeight": true, "layout": "form", "xtype": "panel", "items": journal375, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": year376, "labelAlign": "top" } ];
    this.fields = [ journal375, year376 ];
    Lino.sales.Invoices.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var start_date73 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Period from</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Period from","(cal.Tasks.start_date) Start date of observed period") }, "anchor": "-20" });
    var end_date74 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">until</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("until","(cal.Tasks.end_date) End date of observed period") }, "anchor": "-20" });
    var user75 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Managed by</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Managed by","(cal.Tasks.user) Only rows managed by this user.") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var state76 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">State</span>", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("State","(cal.Tasks.state) Only rows having this state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.TaskStates) });
    var project77 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail,Lino.tickets.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(cal.Tasks.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_1_panel78 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date73, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date74, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user75, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state76, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project77, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    this.items = [ main_1_panel78 ];
    this.fields = [ start_date73, end_date74, user75, state76, project77 ];
    Lino.cal.Tasks.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.MySessionsByDate.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  labelWidth: 45,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var today1810 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Date", "name": "today", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date","(tickets.MySessionsByDate.today) ") }, "anchor": "-20" });
    this.items = [ { "items": today1810, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ today1810 ];
    Lino.tickets.MySessionsByDate.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Invoices.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 108,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'hbox',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var pjournal1194 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Journal", "name": "pjournal", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail,Lino.ledger.Journals.insert)}, "emptyText": "Select a Journal...", "listeners": { "render": Lino.quicktip_renderer("Journal","(ledger.Invoices.pjournal) ") }, "selectOnFocus": true, "hiddenName": "pjournalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/pjournal", "method": "GET" }) }) });
    var pyear1195 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "pyear", "hiddenName": "pyearHidden", "listeners": { "render": Lino.quicktip_renderer("Fiscal Year","(ledger.Invoices.pyear) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var ppartner1196 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "ppartner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "hiddenName": "ppartnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(ledger.Invoices.ppartner) ") }, "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/ppartner", "method": "GET" }) }) });
    this.items = [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pjournal1194, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pyear1195, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ppartner1196, "labelAlign": "top" } ];
    this.fields = [ pjournal1194, pyear1195, ppartner1196 ];
    Lino.ledger.Invoices.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Movements.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var start_date452 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Period from</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Period from","(ledger.Movements.start_date) Start date of observed period") }, "anchor": "-20" });
    var end_date453 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">until</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("until","(ledger.Movements.end_date) End date of observed period") }, "anchor": "-20" });
    var cleared454 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Show cleared movements", "name": "cleared", "hiddenName": "clearedHidden", "listeners": { "render": Lino.quicktip_renderer("Show cleared movements","(ledger.Movements.cleared) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.YesNo) });
    var main_1_panel455 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date452, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date453, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cleared454, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 207, "border": false, "anchor": "-20", "labelAlign": "top" });
    var pjournal459 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Journal", "name": "pjournal", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail,Lino.ledger.Journals.insert)}, "emptyText": "Select a Journal...", "listeners": { "render": Lino.quicktip_renderer("Journal","(ledger.Movements.pjournal) ") }, "selectOnFocus": true, "hiddenName": "pjournalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Movements/pjournal", "method": "GET" }) }) });
    var pyear460 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "pyear", "hiddenName": "pyearHidden", "listeners": { "render": Lino.quicktip_renderer("Fiscal Year","(ledger.Movements.pyear) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var ppartner461 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "ppartner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "hiddenName": "ppartnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(ledger.Movements.ppartner) ") }, "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Movements/ppartner", "method": "GET" }) }) });
    var paccount462 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Account", "name": "paccount", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.accounts.Accounts.detail,Lino.accounts.Accounts.insert)}, "emptyText": "Select a Account...", "listeners": { "render": Lino.quicktip_renderer("Account","(ledger.Movements.paccount) ") }, "selectOnFocus": true, "hiddenName": "paccountHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Movements/paccount", "method": "GET" }) }) });
    var main_2_panel463 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pjournal459, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pyear460, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ppartner461, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": paccount462, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel455, main_2_panel463 ];
    this.fields = [ start_date452, end_date453, cleared454, pjournal459, pyear460, ppartner461, paccount462 ];
    Lino.ledger.Movements.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.ExpectedMovements.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 99,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'hbox',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var trade_type1833 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Trade Type", "name": "trade_type", "hiddenName": "trade_typeHidden", "listeners": { "render": Lino.quicktip_renderer("Trade Type","(ledger.ExpectedMovements.trade_type) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.vat.TradeTypes) });
    var date_until1834 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Date until", "name": "date_until", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date until","(ledger.ExpectedMovements.date_until) ") }, "anchor": "-20" });
    this.items = [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": trade_type1833, "labelAlign": "top" }, { "flex": 52, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date_until1834, "labelAlign": "top" } ];
    this.fields = [ trade_type1833, date_until1834 ];
    Lino.ledger.ExpectedMovements.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.TicketsByProject.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  border: false,
  labelWidth: 45,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var today1282 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Date", "name": "today", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date","(tickets.TicketsByProject.today) ") }, "anchor": "-20" });
    this.items = [ { "items": today1282, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ];
    this.fields = [ today1282 ];
    Lino.tickets.TicketsByProject.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Events.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'form',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var start_date1385 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Period from</span>", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Period from","(cal.Events.start_date) Start date of observed period") }, "anchor": "-20" });
    var end_date1386 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">until</span>", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("until","(cal.Events.end_date) End date of observed period") }, "anchor": "-20" });
    var observed_event1387 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Observed event", "name": "observed_event", "hiddenName": "observed_eventHidden", "listeners": { "render": Lino.quicktip_renderer("Observed event","(cal.Events.observed_event) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.EventEvents) });
    var state1388 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">State</span>", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("State","(cal.Events.state) Only rows having this state.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.EventStates) });
    var main_1_panel1389 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1385, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1386, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": observed_event1387, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state1388, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var user1394 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Managed by</span>", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Managed by","(cal.Events.user) Only rows managed by this user.") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }) });
    var assigned_to1395 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Assigned to</span>", "name": "assigned_to", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "assigned_toHidden", "listeners": { "render": Lino.quicktip_renderer("Assigned to","(cal.Events.assigned_to) Only events assigned to this user.") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/assigned_to", "method": "GET" }) }) });
    var project1396 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail,Lino.tickets.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(cal.Events.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }) });
    var event_type1397 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Event Type", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail,Lino.cal.EventTypes.insert)}, "emptyText": "Select a Event Type...", "listeners": { "render": Lino.quicktip_renderer("Event Type","(cal.Events.event_type) ") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/event_type", "method": "GET" }) }) });
    var show_appointments1398 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Appointments", "name": "show_appointments", "hiddenName": "show_appointmentsHidden", "listeners": { "render": Lino.quicktip_renderer("Appointments","(cal.Events.show_appointments) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.YesNo) });
    var main_2_panel1399 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1394, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": assigned_to1395, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1396, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type1397, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_appointments1398, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    this.items = [ main_1_panel1389, main_2_panel1399 ];
    this.fields = [ start_date1385, end_date1386, observed_event1387, state1388, user1394, assigned_to1395, project1396, event_type1397, show_appointments1398 ];
    Lino.cal.Events.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.about.Inspector.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 153,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  layout: 'hbox',
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var inspected1828 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Inspected object", "name": "inspected", "maxLength": 100, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Inspected object","(about.Inspector.inspected) ") }, "anchor": "-20" });
    var show_callables1829 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "show_callables", "listeners": { "render": Lino.quicktip_renderer("show callables","(about.Inspector.show_callables) ") }, "boxLabel": "show callables", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "flex": 67, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inspected1828, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_callables1829, "labelAlign": "top" } ];
    this.fields = [ inspected1828, show_callables1829 ];
    Lino.about.Inspector.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Groups.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 34,
  initComponent : function() {
    var containing_panel = this;
    var ref986 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "ref", "name": "ref", "maxLength": 20, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ref","(accounts.Groups.ref) ") }, "anchor": "-20" });
    var name987 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(accounts.Groups.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de988 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(accounts.Groups.name_de) ") }, "anchor": "-20" });
    var name_fr989 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(accounts.Groups.name_fr) ") }, "anchor": "-20" });
    var main_1_panel990 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref986, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name987, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de988, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr989, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var account_type995 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Account Type", "name": "account_type", "hiddenName": "account_typeHidden", "listeners": { "render": Lino.quicktip_renderer("Account Type","(accounts.Groups.account_type) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.accounts.AccountTypes) });
    var id996 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(accounts.Groups.id) ") }, "anchor": "-20" });
    var main_2_panel997 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 76, "autoHeight": true, "layout": "form", "xtype": "panel", "items": account_type995, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id996, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var AccountsByGroup_grid1028 = new Lino.accounts.AccountsByGroup.GridPanel({ "flex": 71, "listeners": { "render": Lino.quicktip_renderer("Accounts","(accounts.accounts.AccountsByGroup) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.accounts.AccountsByGroup.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1029 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel990, main_2_panel997, AccountsByGroup_grid1028 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1029;
    this.before_row_edit = function(record) {
      AccountsByGroup_grid1028.on_master_changed();
    }
    Lino.accounts.Groups.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Events.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 66,
  initComponent : function() {
    var containing_panel = this;
    var event_type1406 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Event Type", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail,Lino.cal.EventTypes.insert)}, "emptyText": "Select a Event Type...", "listeners": { "render": Lino.quicktip_renderer("Event Type","(cal.Events.event_type) ") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/event_type", "method": "GET" }) }) });
    var summary1407 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Summary", "name": "summary", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Summary","(cal.Events.summary) ") }, "anchor": "-20" });
    var user1408 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Responsible user", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Responsible user","(cal.Events.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }) });
    var assigned_to1409 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Assigned to", "name": "assigned_to", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "assigned_toHidden", "listeners": { "render": Lino.quicktip_renderer("Assigned to","(cal.Events.assigned_to) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/assigned_to", "method": "GET" }) }) });
    var main_1_panel1410 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type1406, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary1407, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1408, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": assigned_to1409, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var start_date1415 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Start date", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start date","(cal.Events.start_date) ") }, "anchor": "-20" });
    var start_time1416 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "Start time", "name": "start_time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start time","(cal.Events.start_time) ") }, "anchor": "-20" });
    var start_panel1417 = new Ext.Panel({ "flex": 38, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 61, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1415, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time1416, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var end_date1420 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "End Date", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("End Date","(cal.Events.end_date) ") }, "anchor": "-20" });
    var end_time1421 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "End Time", "name": "end_time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("End Time","(cal.Events.end_time) ") }, "anchor": "-20" });
    var end_panel1422 = new Ext.Panel({ "flex": 38, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 61, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1420, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time1421, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var state1425 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "State", "allowBlank": false, "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("State","(cal.Events.state) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.EventStates, "name": "state" });
    var main_2_panel1426 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 54, "hideCheckBoxLabels": true, "items": [ start_panel1417, end_panel1422, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state1425, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var room1428 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Room", "name": "room", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Rooms.detail,Lino.cal.Rooms.insert)}, "emptyText": "Select a Room...", "listeners": { "render": Lino.quicktip_renderer("Room","(cal.Events.room) ") }, "selectOnFocus": true, "hiddenName": "roomHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/room", "method": "GET" }) }) });
    var priority1429 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Priority", "name": "priority", "pageSize": 20, "emptyText": "Select a Priority...", "listeners": { "render": Lino.quicktip_renderer("Priority","(cal.Events.priority) ") }, "selectOnFocus": true, "hiddenName": "priorityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/priority", "method": "GET" }) }) });
    var access_class1430 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Access Class</span>", "name": "access_class", "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Access Class","(cal.Events.access_class) Whether this is private, public or between.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var transparent1431 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "transparent", "listeners": { "render": Lino.quicktip_renderer("Transparent","(cal.Events.transparent) Indicates that this Event shouldn't prevent other Events at the same time.") }, "boxLabel": "Transparent", "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel1432 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": room1428, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": priority1429, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class1430, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": transparent1431, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var owner_disp1437 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Controlled by", "anchor": "-20", "name": "owner" });
    var created1438 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "listeners": { "render": Lino.quicktip_renderer("Created","(cal.Events.created) ") }, "value": "<br>", "anchor": "-20" });
    var modified1439 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "listeners": { "render": Lino.quicktip_renderer("Modified","(cal.Events.modified) ") }, "value": "<br>", "anchor": "-20" });
    var main_4_panel1440 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp1437, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1438, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1439, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description1444 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 35, "containing_panel": this, "name": "description", "title": "Description" });
    var GuestsByEvent_grid1534 = new Lino.cal.GuestsByEvent.GridPanel({ "flex": 36, "listeners": { "render": Lino.quicktip_renderer("Guests","(cal.cal.GuestsByEvent) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.GuestsByEvent.grid) ], "preview_limit": 15, "master_panel": this });
    var outbox_MailsByController_grid1535 = new Lino.outbox.MailsByController.GridPanel({ "flex": 63, "listeners": { "render": Lino.quicktip_renderer("Outgoing Mails","(outbox.outbox.MailsByController) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ], "preview_limit": 15, "master_panel": this });
    var main_6_panel1536 = new Ext.Panel({ "flex": 35, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ GuestsByEvent_grid1534, outbox_MailsByController_grid1535 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel1537 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel1410, main_2_panel1426, main_3_panel1432, main_4_panel1440, description1444, main_6_panel1536 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1537;
    this.before_row_edit = function(record) {
      description1444.refresh();
      GuestsByEvent_grid1534.on_master_changed();
      outbox_MailsByController_grid1535.on_master_changed();
    }
    Lino.cal.Events.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.EventTypes.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 60,
  initComponent : function() {
    var containing_panel = this;
    var name1680 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(cal.EventTypes.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1681 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(cal.EventTypes.name_de) ") }, "anchor": "-20" });
    var name_fr1682 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(cal.EventTypes.name_fr) ") }, "anchor": "-20" });
    var main_1_panel1683 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1680, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1681, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1682, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var event_label1687 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Event label", "name": "event_label", "value": "Appointment", "listeners": { "render": Lino.quicktip_renderer("Event label","(cal.EventTypes.event_label) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var event_label_de1688 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Event label (de)", "name": "event_label_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Event label (de)","(cal.EventTypes.event_label_de) ") }, "anchor": "-20" });
    var event_label_fr1689 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Event label (fr)", "name": "event_label_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Event label (fr)","(cal.EventTypes.event_label_fr) ") }, "anchor": "-20" });
    var main_2_panel1690 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label1687, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label_de1688, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label_fr1689, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1694 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1683, main_2_panel1690 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1694;
    this.before_row_edit = function(record) {
    }
    Lino.cal.EventTypes.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 62,
  initComponent : function() {
    var containing_panel = this;
    var event1527 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Event", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.OneEvent.detail,Lino.cal.OneEvent.insert)}, "emptyText": "Select a Event...", "listeners": { "render": Lino.quicktip_renderer("Event","(cal.Guests.event) ") }, "selectOnFocus": true, "hiddenName": "eventHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/event", "method": "GET" }) }), "name": "event" });
    var partner1528 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "emptyText": "Select a Partner...", "listeners": { "render": Lino.quicktip_renderer("Partner","(cal.Guests.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }), "name": "partner" });
    var role1529 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Role", "name": "role", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.GuestRoles.detail,Lino.cal.GuestRoles.insert)}, "emptyText": "Select a Guest Role...", "listeners": { "render": Lino.quicktip_renderer("Role","(cal.Guests.role) ") }, "selectOnFocus": true, "hiddenName": "roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/role", "method": "GET" }) }) });
    var main_panel1530 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": event1527, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1528, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": role1529, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1530;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Guests.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.sales.Invoices.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 44,
  initComponent : function() {
    var containing_panel = this;
    var partner472 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "emptyText": "Select a Partner...", "listeners": { "render": Lino.quicktip_renderer("Partner","(sales.Invoices.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/partner", "method": "GET" }) }), "name": "partner" });
    var date473 = new Lino.DateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date","(sales.Invoices.date) ") }, "anchor": "-20" });
    var main_1_panel474 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 60, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner472, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date473, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var subject477 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Subject line", "name": "subject", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Subject line","(sales.Invoices.subject) ") }, "anchor": "-20" });
    var main_panel478 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 117, "autoScroll": false, "items": [ main_1_panel474, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject477, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel478;
    this.before_row_edit = function(record) {
    }
    Lino.sales.Invoices.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 57,
  initComponent : function() {
    var containing_panel = this;
    var start_date85 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Start date", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start date","(cal.Tasks.start_date) ") }, "anchor": "-20" });
    var due_date86 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Due date", "name": "due_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Due date","(cal.Tasks.due_date) ") }, "anchor": "-20" });
    var id87 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.Tasks.id) ") }, "anchor": "-20" });
    var workflow_buttons_disp88 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Workflow", "name": "workflow_buttons", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Workflow","(cal.Tasks.workflow_buttons) ") }, "anchor": "-20" });
    var main_1_panel89 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date85, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": due_date86, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id87, "labelAlign": "top" }, { "flex": 49, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp88, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var summary94 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Summary", "name": "summary", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Summary","(cal.Tasks.summary) ") }, "anchor": "-20" });
    var user95 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(cal.Tasks.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var project96 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail,Lino.tickets.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(cal.Tasks.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_3_panel97 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user95, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project96, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var owner_disp100 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Controlled by", "anchor": "-20", "name": "owner" });
    var created101 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "listeners": { "render": Lino.quicktip_renderer("Created","(cal.Tasks.created) ") }, "value": "<br>", "anchor": "-20" });
    var modified102 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "listeners": { "render": Lino.quicktip_renderer("Modified","(cal.Tasks.modified) ") }, "value": "<br>", "anchor": "-20" });
    var main_4_panel103 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp100, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created101, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified102, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description107 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 45, "containing_panel": this, "name": "description", "title": "Description" });
    var main_panel108 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ main_1_panel89, { "items": summary94, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, main_3_panel97, main_4_panel103, description107 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel108;
    this.before_row_edit = function(record) {
      description107.refresh();
    }
    Lino.cal.Tasks.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.Users.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 12,
  initComponent : function() {
    var containing_panel = this;
    var username5 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Username</span>", "name": "username", "listeners": { "render": Lino.quicktip_renderer("Username","(users.Users.username) Required. Must be unique.") }, "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var profile6 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">User Profile</span>", "name": "profile", "hiddenName": "profileHidden", "listeners": { "render": Lino.quicktip_renderer("User Profile","(users.Users.profile) Users with an empty `profile` field are considered inactive and cannot log in.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var partner7 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "hiddenName": "partnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(users.Users.partner) ") }, "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var box1_1_panel8 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username5, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile6, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner7, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name12 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "First name", "name": "first_name", "maxLength": 30, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("First name","(users.Users.first_name) ") }, "anchor": "-20" });
    var last_name13 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Last name", "name": "last_name", "maxLength": 30, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Last name","(users.Users.last_name) ") }, "anchor": "-20" });
    var initials14 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Initials", "name": "initials", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Initials","(users.Users.initials) ") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var box1_2_panel15 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name12, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name13, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": initials14, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email19 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "e-mail address", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("e-mail address","(users.Users.email) ") }, "anchor": "-20" });
    var language20 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Language", "name": "language", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(users.Users.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ] });
    var box1_3_panel21 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email19, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language20, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var id24 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(users.Users.id) ") }, "anchor": "-20" });
    var created25 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "listeners": { "render": Lino.quicktip_renderer("Created","(users.Users.created) ") }, "value": "<br>", "anchor": "-20" });
    var modified26 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "listeners": { "render": Lino.quicktip_renderer("Modified","(users.Users.modified) ") }, "value": "<br>", "anchor": "-20" });
    var box1_4_panel27 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id24, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created25, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified26, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box1_panel31 = new Ext.Panel({ "flex": 66, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ box1_1_panel8, box1_2_panel15, box1_3_panel21, box1_4_panel27 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var MembershipsByUser_grid34 = new Lino.users.MembershipsByUser.GridPanel({ "flex": 33, "hide_top_toolbar": true, "containing_panel": this, "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("My Memberships","(users.users.MembershipsByUser) ") }, "tools": [ Lino.show_in_own_window_button(Lino.users.MembershipsByUser.grid) ], "hideHeaders": true });
    var general_1_panel35 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box1_panel31, MembershipsByUser_grid34 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks36 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remarks","(users.Users.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var AuthoritiesGiven_grid39 = new Lino.users.AuthoritiesGiven.GridPanel({ "flex": 33, "hide_top_toolbar": true, "containing_panel": this, "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Authorities given","(users.users.AuthoritiesGiven) ") }, "tools": [ Lino.show_in_own_window_button(Lino.users.AuthoritiesGiven.grid) ], "hideHeaders": true });
    var general_2_panel40 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": remarks36, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 66 }, AuthoritiesGiven_grid39 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel42 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel35, general_2_panel40 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var event_type43 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Default Event Type</span>", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail,Lino.cal.EventTypes.insert)}, "emptyText": "Select a Event Type...", "listeners": { "render": Lino.quicktip_renderer("Default Event Type","(users.Users.event_type) The default event type for your calendar events.") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/event_type", "method": "GET" }) }) });
    var access_class44 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Default access class</span>", "allowBlank": false, "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Default access class","(users.Users.access_class) The default access class for your calendar events and tasks.") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.AccessClasses, "name": "access_class" });
    var cal_left_1_panel45 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type43, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class44, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_SubscriptionsByUser_grid52 = new Lino.cal.SubscriptionsByUser.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Subscriptions","(cal.cal.SubscriptionsByUser) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.SubscriptionsByUser.grid) ], "preview_limit": 15, "master_panel": this });
    var cal_left_panel53 = new Ext.Panel({ "flex": 33, "border": false, "layout": "vbox", "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ cal_left_1_panel45, cal_SubscriptionsByUser_grid52 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": true, "labelAlign": "top" });
    var cal_TasksByUser_grid118 = new Lino.cal.TasksByUser.GridPanel({ "flex": 66, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Tasks","(cal.cal.TasksByUser) ") }, "tools": [ Lino.show_in_own_window_button(Lino.cal.TasksByUser.grid) ] });
    var cal_1_panel119 = new Ext.Panel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "layout": "hbox", "title": "Calendar", "hideCheckBoxLabels": true, "items": [ cal_left_panel53, cal_TasksByUser_grid118 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel120 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel42, cal_1_panel119 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel120;
    this.before_row_edit = function(record) {
      MembershipsByUser_grid34.on_master_changed();
      AuthoritiesGiven_grid39.on_master_changed();
      cal_SubscriptionsByUser_grid52.on_master_changed();
      cal_TasksByUser_grid118.on_master_changed();
    }
    Lino.users.Users.DetailFormPanel.superclass.initComponent.call(this);
    // active_fields:
    partner7.on("change",function(){this.save()},this);
  }
});


Lino.contacts.Partners.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 25,
  initComponent : function() {
    var containing_panel = this;
    var name290 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Partners.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var country291 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Country","(contacts.Partners.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }) });
    var region292 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail,Lino.countries.Cities.insert)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Region","(contacts.Partners.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }) });
    var city293 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail,Lino.countries.Cities.insert)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Place","(contacts.Partners.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }) });
    var zip_code294 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Zip code", "name": "zip_code", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Zip code","(contacts.Partners.zip_code) ") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var address_box_2_panel295 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country291, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region292, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city293, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code294, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr1300 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line before street</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Address line before street","(contacts.Partners.addr1) Address line before street") }, "anchor": "-20" });
    var street_prefix301 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street prefix</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Street prefix","(contacts.Partners.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "anchor": "-20" });
    var street302 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Street","(contacts.Partners.street) Name of street. Without house number.") }, "anchor": "-20" });
    var street_no303 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("No.","(contacts.Partners.street_no) House number") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var street_box304 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Box","(contacts.Partners.street_box) Text to print after :attr:`steet_no` on the same line") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var address_box_4_panel305 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix301, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street302, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no303, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box304, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2310 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line after street</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Address line after street","(contacts.Partners.addr2) Address line to print below street line") }, "anchor": "-20" });
    var address_box_panel311 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "layout": "form", "title": "Address", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name290, "anchor": "-20", "labelAlign": "top" }, address_box_2_panel295, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1300, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel305, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2310, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 243, "border": false, "labelAlign": "top" });
    var id315 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Partners.id) ") }, "anchor": "-20" });
    var language316 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Language", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(contacts.Partners.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var info_box_panel317 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id315, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language316, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email320 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Partners.email) ") }, "anchor": "-20" });
    var url321 = new Lino.URLField({ "autoHeight": true, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("URL","(contacts.Partners.url) ") }, "anchor": "-20" });
    var phone322 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Phone", "name": "phone", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Phone","(contacts.Partners.phone) ") }, "anchor": "-20" });
    var gsm323 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("GSM","(contacts.Partners.gsm) ") }, "anchor": "-20" });
    var fax324 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Fax","(contacts.Partners.fax) ") }, "anchor": "-20" });
    var contact_box_5_panel325 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm323, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax324, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel328 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "layout": "form", "title": "Contact", "items": [ info_box_panel317, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email320, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url321, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone322, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel325 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var general_1_panel332 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ address_box_panel311, contact_box_panel328 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks333 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remarks","(contacts.Partners.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var is_person334 = new Ext.form.Checkbox({ "boxLabel": "is Person (<a href=\"javascript:Lino.show_mti_child('is_person',Lino.contacts.Persons.detail)\">show</a>)", "autoHeight": true, "hideLabel": true, "name": "is_person", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("is Person","(contacts.Partners.is_person) Whether this Partner is a Person.") }, "anchor": "-20" });
    var is_company335 = new Ext.form.Checkbox({ "boxLabel": "is Company (<a href=\"javascript:Lino.show_mti_child('is_company',Lino.contacts.Companies.detail)\">show</a>)", "autoHeight": true, "hideLabel": true, "name": "is_company", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("is Company","(contacts.Partners.is_company) Whether this Partner is a Company.") }, "anchor": "-20" });
    var bottom_box_2_panel336 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_person334, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_company335, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var bottom_box_panel339 = new Ext.Panel({ "flex": 54, "layout": "vbox", "items": [ { "items": remarks333, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 }, bottom_box_2_panel336 ], "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var general_panel341 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel332, bottom_box_panel339 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var invoicing_address342 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Invoicing address", "name": "invoicing_address", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "hiddenName": "invoicing_addressHidden", "listeners": { "render": Lino.quicktip_renderer("Invoicing address","(contacts.Partners.invoicing_address) ") }, "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/invoicing_address", "method": "GET" }) }) });
    var vat_regime343 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">VAT Regime</span>", "name": "vat_regime", "hiddenName": "vat_regimeHidden", "listeners": { "render": Lino.quicktip_renderer("VAT Regime","(contacts.Partners.vat_regime) The default VAT regime for sales to this customer.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var imode344 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Invoicing Mode", "name": "imode", "pageSize": 20, "emptyText": "Select a Invoicing Mode...", "listeners": { "render": Lino.quicktip_renderer("Invoicing Mode","(contacts.Partners.imode) ") }, "selectOnFocus": true, "hiddenName": "imodeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/imode", "method": "GET" }) }) });
    var payment_term345 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Payment Term</span>", "name": "payment_term", "pageSize": 20, "emptyText": "Select a Payment Term...", "listeners": { "render": Lino.quicktip_renderer("Payment Term","(contacts.Partners.payment_term) The default payment term for sales invoices to this customer.") }, "selectOnFocus": true, "hiddenName": "payment_termHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/payment_term", "method": "GET" }) }) });
    var sales_1_panel346 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 162, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invoicing_address342, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_regime343, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": imode344, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": payment_term345, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var sales_InvoicesByPartner_grid480 = new Lino.sales.InvoicesByPartner.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Invoices","(sales.sales.InvoicesByPartner) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.sales.InvoicesByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var sales_panel481 = new Ext.Panel({ "layout": "vbox", "title": "Sales", "items": [ sales_1_panel346, sales_InvoicesByPartner_grid480 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var tickets_TicketsByPartner_grid612 = new Lino.tickets.TicketsByPartner.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Tickets", "tools": [ Lino.show_in_own_window_button(Lino.tickets.TicketsByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel613 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel341, sales_panel481, tickets_TicketsByPartner_grid612 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel613;
    this.before_row_edit = function(record) {
      region292.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city293.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city293.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      sales_InvoicesByPartner_grid480.on_master_changed();
      tickets_TicketsByPartner_grid612.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country291.on('change',Lino.chooser_handler(region292,'country'));
      country291.on('change',Lino.chooser_handler(city293,'country'));
      region292.on('change',Lino.chooser_handler(city293,'region'));
      Lino.contacts.Partners.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Partners.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.Milestones.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 53,
  initComponent : function() {
    var containing_panel = this;
    var project1346 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail,Lino.tickets.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(tickets.Milestones.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Milestones/project", "method": "GET" }) }) });
    var ref1347 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Reference", "name": "ref", "maxLength": 40, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Reference","(tickets.Milestones.ref) ") }, "anchor": "-20" });
    var main_1_panel1348 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1346, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1347, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var main_panel1351 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "hideCheckBoxLabels": true, "items": [ main_1_panel1348 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1351;
    this.before_row_edit = function(record) {
    }
    Lino.tickets.Milestones.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Roles.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 28,
  initComponent : function() {
    var containing_panel = this;
    var name953 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(households.Roles.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de954 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(households.Roles.name_de) ") }, "anchor": "-20" });
    var name_fr955 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(households.Roles.name_fr) ") }, "anchor": "-20" });
    var name_giving956 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "name_giving", "listeners": { "render": Lino.quicktip_renderer("name-giving","(households.Roles.name_giving) When the `name` field of a Household is empty, \nits value is computed by joining the `Last Name` \nof all name-giving members with a dash (\"-\").\n      ") }, "boxLabel": "name-giving", "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel957 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name953, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de954, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr955, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_giving956, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var MembersByRole_grid968 = new Lino.households.MembersByRole.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Household Members","(households.households.MembersByRole) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByRole.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel969 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel957, MembersByRole_grid968 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel969;
    this.before_row_edit = function(record) {
      MembersByRole_grid968.on_master_changed();
    }
    Lino.households.Roles.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.ContentTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 3,
  initComponent : function() {
    var containing_panel = this;
    var id161 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(system.ContentTypes.id) ") }, "anchor": "-20" });
    var name162 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("name","(system.ContentTypes.name) ") }, "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var app_label163 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "app label", "name": "app_label", "listeners": { "render": Lino.quicktip_renderer("app label","(system.ContentTypes.app_label) ") }, "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var model164 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "python model class name", "name": "model", "listeners": { "render": Lino.quicktip_renderer("python model class name","(system.ContentTypes.model) ") }, "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var base_classes_disp165 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Base classes", "name": "base_classes", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Base classes","(system.ContentTypes.base_classes) ") }, "anchor": "-20" });
    var main_1_panel166 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id161, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name162, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_label163, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": model164, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": base_classes_disp165, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var system_HelpTextsByModel_grid178 = new Lino.system.HelpTextsByModel.GridPanel({ "flex": 62, "listeners": { "render": Lino.quicktip_renderer("Help Texts","(system.system.HelpTextsByModel) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.system.HelpTextsByModel.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel179 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel166, system_HelpTextsByModel_grid178 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel179;
    this.before_row_edit = function(record) {
      system_HelpTextsByModel_grid178.on_master_changed();
    }
    Lino.system.ContentTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Events.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 66,
  initComponent : function() {
    var containing_panel = this;
    var event_type1538 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Event Type", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail,Lino.cal.EventTypes.insert)}, "emptyText": "Select a Event Type...", "listeners": { "render": Lino.quicktip_renderer("Event Type","(cal.Events.event_type) ") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/event_type", "method": "GET" }) }) });
    var summary1539 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Summary", "name": "summary", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Summary","(cal.Events.summary) ") }, "anchor": "-20" });
    var main_1_panel1540 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type1538, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary1539, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var start_date1543 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Start date", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start date","(cal.Events.start_date) ") }, "anchor": "-20" });
    var start_time1544 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "Start time", "name": "start_time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start time","(cal.Events.start_time) ") }, "anchor": "-20" });
    var start_panel1545 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 61, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1543, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time1544, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var end_date1548 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "End Date", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("End Date","(cal.Events.end_date) ") }, "anchor": "-20" });
    var end_time1549 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "End Time", "name": "end_time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("End Time","(cal.Events.end_time) ") }, "anchor": "-20" });
    var end_panel1550 = new Ext.Panel({ "flex": 50, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 61, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1548, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time1549, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var main_2_panel1553 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ start_panel1545, end_panel1550 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "anchor": "-20", "labelAlign": "top" });
    var room1554 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Room", "name": "room", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.Rooms.detail,Lino.cal.Rooms.insert)}, "emptyText": "Select a Room...", "listeners": { "render": Lino.quicktip_renderer("Room","(cal.Events.room) ") }, "selectOnFocus": true, "hiddenName": "roomHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/room", "method": "GET" }) }) });
    var priority1555 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Priority", "name": "priority", "pageSize": 20, "emptyText": "Select a Priority...", "listeners": { "render": Lino.quicktip_renderer("Priority","(cal.Events.priority) ") }, "selectOnFocus": true, "hiddenName": "priorityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/priority", "method": "GET" }) }) });
    var access_class1556 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Access Class</span>", "name": "access_class", "hiddenName": "access_classHidden", "listeners": { "render": Lino.quicktip_renderer("Access Class","(cal.Events.access_class) Whether this is private, public or between.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.AccessClasses) });
    var transparent1557 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "transparent", "listeners": { "render": Lino.quicktip_renderer("Transparent","(cal.Events.transparent) Indicates that this Event shouldn't prevent other Events at the same time.") }, "boxLabel": "Transparent", "selectOnFocus": true, "anchor": "-20" });
    var main_3_panel1558 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": room1554, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": priority1555, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class1556, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": transparent1557, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1563 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1540, main_2_panel1553, main_3_panel1558 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1563;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Events.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.SiteConfigs.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 8,
  initComponent : function() {
    var containing_panel = this;
    var site_company139 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">The company that runs this site</span>", "name": "site_company", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Companies.detail,Lino.contacts.Companies.insert)}, "hiddenName": "site_companyHidden", "listeners": { "render": Lino.quicktip_renderer("The company that runs this site","(system.SiteConfigs.site_company) The Company to be used as sender in documents.") }, "selectOnFocus": true, "emptyText": "Select a Company...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/site_company", "method": "GET" }) }) });
    var next_partner_id140 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Next partner id</span>", "name": "next_partner_id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Next partner id","(system.SiteConfigs.next_partner_id) The next automatic id for any new partner.") }, "value": 100, "anchor": "-20" });
    var main_1_panel141 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": site_company139, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": next_partner_id140, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 288, "border": false, "anchor": "-20", "labelAlign": "top" });
    var default_build_method144 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Default build method", "name": "default_build_method", "value": "appyodt", "hiddenName": "default_build_methodHidden", "listeners": { "render": Lino.quicktip_renderer("Default build method","(system.SiteConfigs.default_build_method) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var clients_account145 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Clients account", "name": "clients_account", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.accounts.Accounts.detail,Lino.accounts.Accounts.insert)}, "emptyText": "Select a Account...", "listeners": { "render": Lino.quicktip_renderer("Clients account","(system.SiteConfigs.clients_account) ") }, "selectOnFocus": true, "hiddenName": "clients_accountHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/clients_account", "method": "GET" }) }) });
    var sales_account146 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Sales Base account", "name": "sales_account", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.accounts.Accounts.detail,Lino.accounts.Accounts.insert)}, "emptyText": "Select a Account...", "listeners": { "render": Lino.quicktip_renderer("Sales Base account","(system.SiteConfigs.sales_account) ") }, "selectOnFocus": true, "hiddenName": "sales_accountHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/sales_account", "method": "GET" }) }) });
    var sales_vat_account147 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Sales VAT account", "name": "sales_vat_account", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.accounts.Accounts.detail,Lino.accounts.Accounts.insert)}, "emptyText": "Select a Account...", "listeners": { "render": Lino.quicktip_renderer("Sales VAT account","(system.SiteConfigs.sales_vat_account) ") }, "selectOnFocus": true, "hiddenName": "sales_vat_accountHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/sales_vat_account", "method": "GET" }) }) });
    var main_3_panel148 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": clients_account145, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sales_account146, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sales_vat_account147, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 171, "border": false, "anchor": "-20", "labelAlign": "top" });
    var suppliers_account152 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Suppliers account", "name": "suppliers_account", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.accounts.Accounts.detail,Lino.accounts.Accounts.insert)}, "emptyText": "Select a Account...", "listeners": { "render": Lino.quicktip_renderer("Suppliers account","(system.SiteConfigs.suppliers_account) ") }, "selectOnFocus": true, "hiddenName": "suppliers_accountHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/suppliers_account", "method": "GET" }) }) });
    var purchases_account153 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Purchases Base account", "name": "purchases_account", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.accounts.Accounts.detail,Lino.accounts.Accounts.insert)}, "emptyText": "Select a Account...", "listeners": { "render": Lino.quicktip_renderer("Purchases Base account","(system.SiteConfigs.purchases_account) ") }, "selectOnFocus": true, "hiddenName": "purchases_accountHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/purchases_account", "method": "GET" }) }) });
    var purchases_vat_account154 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Purchases VAT account", "name": "purchases_vat_account", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.accounts.Accounts.detail,Lino.accounts.Accounts.insert)}, "emptyText": "Select a Account...", "listeners": { "render": Lino.quicktip_renderer("Purchases VAT account","(system.SiteConfigs.purchases_vat_account) ") }, "selectOnFocus": true, "hiddenName": "purchases_vat_accountHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/purchases_vat_account", "method": "GET" }) }) });
    var main_4_panel155 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": suppliers_account152, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": purchases_account153, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": purchases_vat_account154, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 207, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel159 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 189, "autoScroll": false, "items": [ main_1_panel141, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": default_build_method144, "anchor": "-20", "labelAlign": "top" }, main_3_panel148, main_4_panel155 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel159;
    this.before_row_edit = function(record) {
    }
    Lino.system.SiteConfigs.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.Uploads.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 56,
  initComponent : function() {
    var containing_panel = this;
    var file1781 = Lino.file_field_handler(this,{ "autoHeight": true, "fieldLabel": "File", "name": "file", "listeners": { "render": Lino.quicktip_renderer("File","(uploads.Uploads.file) ") }, "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user1782 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(uploads.Uploads.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel1783 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file1781, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1782, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type1786 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Upload Type", "name": "type", "pageSize": 20, "emptyText": "Select a Upload Type...", "listeners": { "render": Lino.quicktip_renderer("Upload Type","(uploads.Uploads.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var description1787 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Description", "name": "description", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Description","(uploads.Uploads.description) ") }, "anchor": "-20" });
    var main_2_panel1788 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1786, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": description1787, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var modified1791 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "listeners": { "render": Lino.quicktip_renderer("Modified","(uploads.Uploads.modified) ") }, "value": "<br>", "anchor": "-20" });
    var created1792 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "listeners": { "render": Lino.quicktip_renderer("Created","(uploads.Uploads.created) ") }, "value": "<br>", "anchor": "-20" });
    var owner_disp1793 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Controlled by", "anchor": "-20", "name": "owner" });
    var main_3_panel1794 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified1791, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created1792, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp1793, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1798 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1783, main_2_panel1788, main_3_panel1794 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1798;
    this.before_row_edit = function(record) {
    }
    Lino.uploads.Uploads.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 22,
  initComponent : function() {
    var containing_panel = this;
    var prefix764 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "prefix", "name": "prefix", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("prefix","(contacts.Companies.prefix) ") }, "anchor": "-20" });
    var name765 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Companies.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_box_panel766 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix764, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name765, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var country769 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Country","(contacts.Companies.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/country", "method": "GET" }) }) });
    var region770 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail,Lino.countries.Cities.insert)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Region","(contacts.Companies.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/region", "method": "GET" }) }) });
    var city771 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail,Lino.countries.Cities.insert)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Place","(contacts.Companies.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/city", "method": "GET" }) }) });
    var zip_code772 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Zip code", "name": "zip_code", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Zip code","(contacts.Companies.zip_code) ") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var address_box_2_panel773 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country769, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region770, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city771, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code772, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr1778 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line before street</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Address line before street","(contacts.Companies.addr1) Address line before street") }, "anchor": "-20" });
    var street_prefix779 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street prefix</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Street prefix","(contacts.Companies.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "anchor": "-20" });
    var street780 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Street","(contacts.Companies.street) Name of street. Without house number.") }, "anchor": "-20" });
    var street_no781 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("No.","(contacts.Companies.street_no) House number") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var street_box782 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Box","(contacts.Companies.street_box) Text to print after :attr:`steet_no` on the same line") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var address_box_4_panel783 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix779, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street780, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no781, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box782, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2788 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line after street</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Address line after street","(contacts.Companies.addr2) Address line to print below street line") }, "anchor": "-20" });
    var address_box_panel789 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "layout": "form", "title": "Address", "items": [ name_box_panel766, address_box_2_panel773, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1778, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel783, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2788, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 243, "border": false, "labelAlign": "top" });
    var id792 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Companies.id) ") }, "anchor": "-20" });
    var language793 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Language", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(contacts.Companies.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var info_box_panel794 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id792, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language793, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email797 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Companies.email) ") }, "anchor": "-20" });
    var url798 = new Lino.URLField({ "autoHeight": true, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("URL","(contacts.Companies.url) ") }, "anchor": "-20" });
    var phone799 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Phone", "name": "phone", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Phone","(contacts.Companies.phone) ") }, "anchor": "-20" });
    var gsm800 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("GSM","(contacts.Companies.gsm) ") }, "anchor": "-20" });
    var fax801 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Fax","(contacts.Companies.fax) ") }, "anchor": "-20" });
    var contact_box_5_panel802 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm800, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax801, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel805 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "layout": "form", "title": "Contact", "items": [ info_box_panel794, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email797, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url798, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone799, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel802 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var general_1_panel809 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ address_box_panel789, contact_box_panel805 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var type810 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Company type", "name": "type", "pageSize": 20, "emptyText": "Select a company type...", "listeners": { "render": Lino.quicktip_renderer("Company type","(contacts.Companies.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var vat_id811 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "VAT id", "name": "vat_id", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("VAT id","(contacts.Companies.vat_id) ") }, "anchor": "-20" });
    var bottom_box_1_panel812 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type810, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id811, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks815 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remarks","(contacts.Companies.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var contacts_RolesByCompany_grid820 = new Lino.contacts.RolesByCompany.GridPanel({ "flex": 42, "listeners": { "render": Lino.quicktip_renderer("Contact persons","(contacts.contacts.RolesByCompany) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.grid) ], "preview_limit": 15, "master_panel": this });
    var bottom_box_2_panel821 = new Ext.Panel({ "flex": 83, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": remarks815, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 57 }, contacts_RolesByCompany_grid820 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var bottom_box_panel823 = new Ext.Panel({ "flex": 54, "border": false, "layout": "vbox", "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ bottom_box_1_panel812, bottom_box_2_panel821 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": true, "labelAlign": "top" });
    var general_panel824 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel809, bottom_box_panel823 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var invoicing_address825 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Invoicing address", "name": "invoicing_address", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "hiddenName": "invoicing_addressHidden", "listeners": { "render": Lino.quicktip_renderer("Invoicing address","(contacts.Companies.invoicing_address) ") }, "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/invoicing_address", "method": "GET" }) }) });
    var vat_regime826 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">VAT Regime</span>", "name": "vat_regime", "hiddenName": "vat_regimeHidden", "listeners": { "render": Lino.quicktip_renderer("VAT Regime","(contacts.Companies.vat_regime) The default VAT regime for sales to this customer.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var imode827 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Invoicing Mode", "name": "imode", "pageSize": 20, "emptyText": "Select a Invoicing Mode...", "listeners": { "render": Lino.quicktip_renderer("Invoicing Mode","(contacts.Companies.imode) ") }, "selectOnFocus": true, "hiddenName": "imodeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/imode", "method": "GET" }) }) });
    var payment_term828 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Payment Term</span>", "name": "payment_term", "pageSize": 20, "emptyText": "Select a Payment Term...", "listeners": { "render": Lino.quicktip_renderer("Payment Term","(contacts.Companies.payment_term) The default payment term for sales invoices to this customer.") }, "selectOnFocus": true, "hiddenName": "payment_termHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/payment_term", "method": "GET" }) }) });
    var sales_1_panel829 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 162, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invoicing_address825, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_regime826, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": imode827, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": payment_term828, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var sales_InvoicesByPartner_grid834 = new Lino.sales.InvoicesByPartner.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Invoices","(sales.sales.InvoicesByPartner) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.sales.InvoicesByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var sales_panel835 = new Ext.Panel({ "layout": "vbox", "title": "Sales", "items": [ sales_1_panel829, sales_InvoicesByPartner_grid834 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var tickets_TicketsByPartner_grid836 = new Lino.tickets.TicketsByPartner.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Tickets", "tools": [ Lino.show_in_own_window_button(Lino.tickets.TicketsByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel837 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel824, sales_panel835, tickets_TicketsByPartner_grid836 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel837;
    this.before_row_edit = function(record) {
      region770.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city771.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city771.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByCompany_grid820.on_master_changed();
      sales_InvoicesByPartner_grid834.on_master_changed();
      tickets_TicketsByPartner_grid836.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country769.on('change',Lino.chooser_handler(region770,'country'));
      country769.on('change',Lino.chooser_handler(city771,'country'));
      region770.on('change',Lino.chooser_handler(city771,'region'));
      Lino.contacts.Companies.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Companies.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Invoices.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 38,
  initComponent : function() {
    var containing_panel = this;
    var id1138 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(ledger.Invoices.id) ") }, "anchor": "-20" });
    var date1139 = new Lino.DateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date","(ledger.Invoices.date) ") }, "anchor": "-20" });
    var partner1140 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "emptyText": "Select a Partner...", "listeners": { "render": Lino.quicktip_renderer("Partner","(ledger.Invoices.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/partner", "method": "GET" }) }), "name": "partner" });
    var user1141 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(ledger.Invoices.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/user", "method": "GET" }) }) });
    var general_1_panel1142 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1138, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date1139, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1140, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1141, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var due_date1147 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Due date", "name": "due_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Due date","(ledger.Invoices.due_date) ") }, "anchor": "-20" });
    var your_ref1148 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Your reference", "name": "your_ref", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Your reference","(ledger.Invoices.your_ref) ") }, "anchor": "-20" });
    var vat_regime1149 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "VAT Regime", "allowBlank": false, "hiddenName": "vat_regimeHidden", "listeners": { "render": Lino.quicktip_renderer("VAT Regime","(ledger.Invoices.vat_regime) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.vat.VatRegimes, "name": "vat_regime" });
    var general_2_panel1150 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": due_date1147, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": your_ref1148, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_regime1149, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var ItemsByInvoice_grid1162 = new Lino.ledger.ItemsByInvoice.GridPanel({ "flex": 75, "listeners": { "render": Lino.quicktip_renderer("Voucher items","(ledger.ledger.ItemsByInvoice) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.ledger.ItemsByInvoice.grid) ], "preview_limit": 15, "master_panel": this });
    var total_base1163 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "Total excl. VAT", "name": "total_base", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Total excl. VAT","(ledger.Invoices.total_base) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var total_vat1164 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "VAT", "name": "total_vat", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("VAT","(ledger.Invoices.total_vat) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var total_incl1165 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "Total incl. VAT", "name": "total_incl", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Total incl. VAT","(ledger.Invoices.total_incl) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var workflow_buttons_disp1166 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Workflow", "name": "workflow_buttons", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Workflow","(ledger.Invoices.workflow_buttons) ") }, "anchor": "-20" });
    var totals_panel1167 = new Ext.Panel({ "flex": 25, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_base1163, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_vat1164, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_incl1165, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp1166, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 144, "border": false, "labelAlign": "top" });
    var general_3_panel1172 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ ItemsByInvoice_grid1162, totals_panel1167 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "anchor": "-20", "labelAlign": "top" });
    var general_panel1173 = new Ext.Panel({ "autoHeight": true, "layout": "form", "title": "General", "items": [ general_1_panel1142, general_2_panel1150, general_3_panel1172 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "labelAlign": "top" });
    var journal1174 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Journal", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail,Lino.ledger.Journals.insert)}, "emptyText": "Select a Journal...", "listeners": { "render": Lino.quicktip_renderer("Journal","(ledger.Invoices.journal) ") }, "selectOnFocus": true, "hiddenName": "journalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/journal", "method": "GET" }) }), "name": "journal" });
    var year1175 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "year", "hiddenName": "yearHidden", "listeners": { "render": Lino.quicktip_renderer("Fiscal Year","(ledger.Invoices.year) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var number1176 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "number", "name": "number", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("number","(ledger.Invoices.number) ") }, "anchor": "-20" });
    var narration1177 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Narration", "name": "narration", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Narration","(ledger.Invoices.narration) ") }, "anchor": "-20" });
    var ledger_1_panel1178 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": journal1174, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": year1175, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": number1176, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": narration1177, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var MovementsByVoucher_grid1183 = new Lino.ledger.MovementsByVoucher.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Movements","(ledger.ledger.MovementsByVoucher) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.ledger.MovementsByVoucher.grid) ], "preview_limit": 15, "master_panel": this });
    var ledger_panel1184 = new Ext.Panel({ "layout": "vbox", "title": "Ledger", "items": [ ledger_1_panel1178, MovementsByVoucher_grid1183 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel1185 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1173, ledger_panel1184 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1185;
    this.before_row_edit = function(record) {
      ItemsByInvoice_grid1162.on_master_changed();
      MovementsByVoucher_grid1183.on_master_changed();
    }
    Lino.ledger.Invoices.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 19,
  initComponent : function() {
    var containing_panel = this;
    var id646 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(properties.PropTypes.id) ") }, "anchor": "-20" });
    var name647 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(properties.PropTypes.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de648 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(properties.PropTypes.name_de) ") }, "anchor": "-20" });
    var name_fr649 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(properties.PropTypes.name_fr) ") }, "anchor": "-20" });
    var choicelist650 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Choices List", "name": "choicelist", "hiddenName": "choicelistHidden", "listeners": { "render": Lino.quicktip_renderer("Choices List","(properties.PropTypes.choicelist) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "countries.CityTypes", "CityTypes" ], [ "lino.Genders", "Genders" ], [ "lino.UserGroups", "User Groups" ], [ "lino.UserLevels", "User Levels" ], [ "lino.UserProfiles", "User Profiles" ], [ "lino.YesNo", "Yes or no" ], [ "properties.DoYouLike", "DoYouLike" ], [ "properties.HowWell", "HowWell" ] ] });
    var default_value651 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "default value", "name": "default_value", "hiddenName": "default_valueHidden", "listeners": { "render": Lino.quicktip_renderer("default value","(properties.PropTypes.default_value) ") }, "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropTypes/default_value", "method": "GET" }) }) });
    var main_1_panel652 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id646, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name647, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de648, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr649, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": choicelist650, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": default_value651, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 153, "border": false, "frame": false, "labelAlign": "top" });
    var ChoicesByType_grid665 = new Lino.properties.ChoicesByType.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Property Choices","(properties.properties.ChoicesByType) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.properties.ChoicesByType.grid) ] });
    var PropsByType_grid672 = new Lino.properties.PropsByType.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Properties","(properties.properties.PropsByType) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.properties.PropsByType.grid) ] });
    var main_panel673 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "hideCheckBoxLabels": true, "items": [ main_1_panel652, ChoicesByType_grid665, PropsByType_grid672 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel673;
    this.before_row_edit = function(record) {
      default_value651.setContextValue('choicelist',record ? record.data['choicelistHidden'] : undefined);
      ChoicesByType_grid665.on_master_changed();
      PropsByType_grid672.on_master_changed();
    }
    this.onRender = function(ct, position) {
      choicelist650.on('change',Lino.chooser_handler(default_value651,'choicelist'));
      Lino.properties.PropTypes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.properties.PropTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Charts.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 35,
  initComponent : function() {
    var containing_panel = this;
    var id970 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(accounts.Charts.id) ") }, "anchor": "-20" });
    var name971 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(accounts.Charts.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de972 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(accounts.Charts.name_de) ") }, "anchor": "-20" });
    var name_fr973 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(accounts.Charts.name_fr) ") }, "anchor": "-20" });
    var main_1_panel974 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id970, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name971, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de972, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr973, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var GroupsByChart_grid1030 = new Lino.accounts.GroupsByChart.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Account Groups","(accounts.accounts.GroupsByChart) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.accounts.GroupsByChart.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1031 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel974, GroupsByChart_grid1030 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1031;
    this.before_row_edit = function(record) {
      GroupsByChart_grid1030.on_master_changed();
    }
    Lino.accounts.Charts.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.Milestones.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 53,
  initComponent : function() {
    var containing_panel = this;
    var project1309 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail,Lino.tickets.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(tickets.Milestones.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Milestones/project", "method": "GET" }) }) });
    var ref1310 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Reference", "name": "ref", "maxLength": 40, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Reference","(tickets.Milestones.ref) ") }, "anchor": "-20" });
    var expected1311 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Expected for", "name": "expected", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Expected for","(tickets.Milestones.expected) ") }, "anchor": "-20" });
    var reached1312 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Reached", "name": "reached", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Reached","(tickets.Milestones.reached) ") }, "anchor": "-20" });
    var id1313 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(tickets.Milestones.id) ") }, "anchor": "-20" });
    var main_1_panel1314 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1309, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1310, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": expected1311, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": reached1312, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1313, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var TicketsFixed_grid1331 = new Lino.tickets.TicketsFixed.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("Tickets Fixed","(tickets.tickets.TicketsFixed) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.tickets.TicketsFixed.grid) ], "preview_limit": 15, "master_panel": this });
    var TicketsReported_grid1343 = new Lino.tickets.TicketsReported.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("Tickets Reported","(tickets.tickets.TicketsReported) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.tickets.TicketsReported.grid) ], "preview_limit": 15, "master_panel": this });
    var main_2_panel1344 = new Ext.Panel({ "flex": 83, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ TicketsFixed_grid1331, TicketsReported_grid1343 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel1345 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1314, main_2_panel1344 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1345;
    this.before_row_edit = function(record) {
      TicketsFixed_grid1331.on_master_changed();
      TicketsReported_grid1343.on_master_changed();
    }
    Lino.tickets.Milestones.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 23,
  initComponent : function() {
    var containing_panel = this;
    var first_name753 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "First name", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("First name","(contacts.Persons.first_name) ") }, "anchor": "-20" });
    var last_name754 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Last name", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Last name","(contacts.Persons.last_name) ") }, "anchor": "-20" });
    var main_1_panel755 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name753, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name754, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gender758 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Gender", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Gender","(contacts.Persons.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var language759 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Language", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(contacts.Persons.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var main_2_panel760 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender758, "labelAlign": "top" }, { "flex": 68, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language759, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel763 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel755, main_2_panel760 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel763;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Persons.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 23,
  initComponent : function() {
    var containing_panel = this;
    var last_name674 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Last name", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Last name","(contacts.Persons.last_name) ") }, "anchor": "-20" });
    var first_name675 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "First name", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("First name","(contacts.Persons.first_name) ") }, "anchor": "-20" });
    var name_box_1_panel676 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name674, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name675, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gender679 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Gender", "name": "gender", "hiddenName": "genderHidden", "listeners": { "render": Lino.quicktip_renderer("Gender","(contacts.Persons.gender) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.Genders) });
    var title680 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Title</span>", "name": "title", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Title","(contacts.Persons.title) Text to print before first_name as part of the first address line.") }, "anchor": "-20" });
    var birth_date681 = new Lino.IncompleteDateField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Birth date</span>", "name": "birth_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Birth date","(contacts.Persons.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".") }, "anchor": "-20" });
    var name_box_2_panel682 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender679, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title680, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date681, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var name_box_panel686 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ name_box_1_panel676, name_box_2_panel682 ], "frame": true, "bodyBorder": false, "anchor": "-20", "labelAlign": "top" });
    var country687 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Country","(contacts.Persons.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/country", "method": "GET" }) }) });
    var region688 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail,Lino.countries.Cities.insert)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Region","(contacts.Persons.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/region", "method": "GET" }) }) });
    var city689 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail,Lino.countries.Cities.insert)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Place","(contacts.Persons.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/city", "method": "GET" }) }) });
    var zip_code690 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Zip code", "name": "zip_code", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Zip code","(contacts.Persons.zip_code) ") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var address_box_2_panel691 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country687, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region688, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city689, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code690, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr1696 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line before street</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Address line before street","(contacts.Persons.addr1) Address line before street") }, "anchor": "-20" });
    var street_prefix697 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street prefix</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Street prefix","(contacts.Persons.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "anchor": "-20" });
    var street698 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Street","(contacts.Persons.street) Name of street. Without house number.") }, "anchor": "-20" });
    var street_no699 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("No.","(contacts.Persons.street_no) House number") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var street_box700 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Box","(contacts.Persons.street_box) Text to print after :attr:`steet_no` on the same line") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var address_box_4_panel701 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix697, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street698, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no699, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box700, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2706 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line after street</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Address line after street","(contacts.Persons.addr2) Address line to print below street line") }, "anchor": "-20" });
    var address_box_panel707 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "layout": "form", "title": "Address", "items": [ name_box_panel686, address_box_2_panel691, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1696, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel701, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2706, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 243, "border": false, "labelAlign": "top" });
    var id710 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Persons.id) ") }, "anchor": "-20" });
    var language711 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Language", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(contacts.Persons.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var info_box_1_panel712 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id710, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language711, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var age_disp715 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Age", "name": "age", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Age","(contacts.Persons.age) ") }, "anchor": "-20" });
    var info_box_panel716 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ info_box_1_panel712, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": age_disp715, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email718 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Persons.email) ") }, "anchor": "-20" });
    var url719 = new Lino.URLField({ "autoHeight": true, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("URL","(contacts.Persons.url) ") }, "anchor": "-20" });
    var phone720 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Phone", "name": "phone", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Phone","(contacts.Persons.phone) ") }, "anchor": "-20" });
    var gsm721 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("GSM","(contacts.Persons.gsm) ") }, "anchor": "-20" });
    var fax722 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Fax", "name": "fax", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Fax","(contacts.Persons.fax) ") }, "anchor": "-20" });
    var contact_box_5_panel723 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm721, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax722, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel726 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "layout": "form", "title": "Contact", "items": [ info_box_panel716, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email718, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url719, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone720, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel723 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var general_1_panel730 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ address_box_panel707, contact_box_panel726 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks731 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remarks","(contacts.Persons.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var contacts_RolesByPerson_grid736 = new Lino.contacts.RolesByPerson.GridPanel({ "flex": 42, "listeners": { "render": Lino.quicktip_renderer("Contact for","(contacts.contacts.RolesByPerson) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByPerson.grid) ], "preview_limit": 15, "master_panel": this });
    var bottom_box_panel737 = new Ext.Panel({ "flex": 38, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": remarks731, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 57 }, contacts_RolesByPerson_grid736 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel739 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel730, bottom_box_panel737 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var invoicing_address740 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Invoicing address", "name": "invoicing_address", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "hiddenName": "invoicing_addressHidden", "listeners": { "render": Lino.quicktip_renderer("Invoicing address","(contacts.Persons.invoicing_address) ") }, "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/invoicing_address", "method": "GET" }) }) });
    var vat_regime741 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">VAT Regime</span>", "name": "vat_regime", "hiddenName": "vat_regimeHidden", "listeners": { "render": Lino.quicktip_renderer("VAT Regime","(contacts.Persons.vat_regime) The default VAT regime for sales to this customer.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var imode742 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Invoicing Mode", "name": "imode", "pageSize": 20, "emptyText": "Select a Invoicing Mode...", "listeners": { "render": Lino.quicktip_renderer("Invoicing Mode","(contacts.Persons.imode) ") }, "selectOnFocus": true, "hiddenName": "imodeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/imode", "method": "GET" }) }) });
    var payment_term743 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Payment Term</span>", "name": "payment_term", "pageSize": 20, "emptyText": "Select a Payment Term...", "listeners": { "render": Lino.quicktip_renderer("Payment Term","(contacts.Persons.payment_term) The default payment term for sales invoices to this customer.") }, "selectOnFocus": true, "hiddenName": "payment_termHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/payment_term", "method": "GET" }) }) });
    var sales_1_panel744 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 162, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invoicing_address740, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_regime741, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": imode742, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": payment_term743, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var sales_InvoicesByPartner_grid749 = new Lino.sales.InvoicesByPartner.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Invoices","(sales.sales.InvoicesByPartner) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.sales.InvoicesByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var sales_panel750 = new Ext.Panel({ "layout": "vbox", "title": "Sales", "items": [ sales_1_panel744, sales_InvoicesByPartner_grid749 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var tickets_TicketsByPartner_grid751 = new Lino.tickets.TicketsByPartner.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Tickets", "tools": [ Lino.show_in_own_window_button(Lino.tickets.TicketsByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel752 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel739, sales_panel750, tickets_TicketsByPartner_grid751 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel752;
    this.before_row_edit = function(record) {
      region688.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city689.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city689.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      contacts_RolesByPerson_grid736.on_master_changed();
      sales_InvoicesByPartner_grid749.on_master_changed();
      tickets_TicketsByPartner_grid751.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country687.on('change',Lino.chooser_handler(region688,'country'));
      country687.on('change',Lino.chooser_handler(city689,'country'));
      region688.on('change',Lino.chooser_handler(city689,'region'));
      Lino.contacts.Persons.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Persons.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Invoices.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 38,
  initComponent : function() {
    var containing_panel = this;
    var partner1186 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "emptyText": "Select a Partner...", "listeners": { "render": Lino.quicktip_renderer("Partner","(ledger.Invoices.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/partner", "method": "GET" }) }), "name": "partner" });
    var date1187 = new Lino.DateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date","(ledger.Invoices.date) ") }, "anchor": "-20" });
    var total_incl1188 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "Total incl. VAT", "name": "total_incl", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Total incl. VAT","(ledger.Invoices.total_incl) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var main_2_panel1189 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 52, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date1187, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_incl1188, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 144, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1192 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1186, "anchor": "-20", "labelAlign": "top" }, main_2_panel1189 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1192;
    this.before_row_edit = function(record) {
    }
    Lino.ledger.Invoices.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.products.ProductCats.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 31,
  initComponent : function() {
    var containing_panel = this;
    var id1032 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(products.ProductCats.id) ") }, "anchor": "-20" });
    var name1033 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(products.ProductCats.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1034 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(products.ProductCats.name_de) ") }, "anchor": "-20" });
    var name_fr1035 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(products.ProductCats.name_fr) ") }, "anchor": "-20" });
    var main_1_panel1036 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1032, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1033, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1034, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1035, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 153, "border": false, "frame": false, "labelAlign": "top" });
    var description1041 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("description","(products.ProductCats.description) ") }, "fieldLabel": "description", "name": "description", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var ProductsByCategory_grid1084 = new Lino.products.ProductsByCategory.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "preview_limit": 15, "master_panel": this, "listeners": { "render": Lino.quicktip_renderer("Products","(products.products.ProductsByCategory) ") }, "split": true, "tools": [ Lino.show_in_own_window_button(Lino.products.ProductsByCategory.grid) ] });
    var main_panel1085 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ main_1_panel1036, { "flex": 5, "layout": "form", "xtype": "panel", "items": description1041, "region": "center", "labelAlign": "top", "split": true }, ProductsByCategory_grid1084 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1085;
    this.before_row_edit = function(record) {
      ProductsByCategory_grid1084.on_master_changed();
    }
    Lino.products.ProductCats.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.Models.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var app_disp1813 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "app_label", "name": "app", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("app_label","(about.Models.app) ") }, "anchor": "-20" });
    var name_disp1814 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "name", "name": "name", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("name","(about.Models.name) ") }, "anchor": "-20" });
    var docstring_disp1815 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "docstring", "name": "docstring", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("docstring","(about.Models.docstring) ") }, "anchor": "-20" });
    var rows1816 = new Ext.form.NumberField({ "disabled": true, "autoHeight": true, "fieldLabel": "Rows", "name": "rows", "listeners": { "render": Lino.quicktip_renderer("Rows","(about.Models.rows) ") }, "anchor": "-20" });
    var main_1_panel1817 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_disp1813, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_disp1814, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": docstring_disp1815, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": rows1816, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var about_FieldsByModel_grid1826 = new Lino.about.FieldsByModel.GridPanel({ "flex": 62, "listeners": { "render": Lino.quicktip_renderer("Fields","(about.about.FieldsByModel) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.about.FieldsByModel.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1827 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1817, about_FieldsByModel_grid1826 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1827;
    this.before_row_edit = function(record) {
      about_FieldsByModel_grid1826.on_master_changed();
    }
    Lino.about.Models.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.Projects.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 51,
  initComponent : function() {
    var containing_panel = this;
    var ref1231 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Reference", "name": "ref", "maxLength": 40, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Reference","(tickets.Projects.ref) ") }, "anchor": "-20" });
    var name1232 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Name","(tickets.Projects.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var parent1233 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Parent", "name": "parent", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail,Lino.tickets.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Parent","(tickets.Projects.parent) ") }, "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Projects/parent", "method": "GET" }) }) });
    var general_1_panel1234 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1231, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1232, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent1233, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var type1238 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Project Type", "name": "type", "pageSize": 20, "emptyText": "Select a Project Type...", "listeners": { "render": Lino.quicktip_renderer("Project Type","(tickets.Projects.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Projects/type", "method": "GET" }) }) });
    var user1239 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(tickets.Projects.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Projects/user", "method": "GET" }) }) });
    var general_2_panel1240 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1238, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1239, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description1243 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(tickets.Projects.description) ") }, "fieldLabel": "Description", "name": "description", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var ProjectsByProject_grid1301 = new Lino.tickets.ProjectsByProject.GridPanel({ "flex": 66, "listeners": { "render": Lino.quicktip_renderer("Sub-projects","(tickets.tickets.ProjectsByProject) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.tickets.ProjectsByProject.grid) ], "preview_limit": 15, "master_panel": this });
    var general_3_panel1302 = new Ext.Panel({ "flex": 71, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "items": description1243, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 33 }, ProjectsByProject_grid1301 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel1304 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel1234, general_2_panel1240, general_3_panel1302 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var TicketsByProject_grid1305 = new Lino.tickets.TicketsByProject.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("Tickets","(tickets.tickets.TicketsByProject) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.tickets.TicketsByProject.grid) ], "preview_limit": 15, "master_panel": this });
    var SessionsByProject_grid1306 = new Lino.tickets.SessionsByProject.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("Sessions","(tickets.tickets.SessionsByProject) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.tickets.SessionsByProject.grid) ], "preview_limit": 15, "master_panel": this });
    var tickets_1_panel1307 = new Ext.Panel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "layout": "hbox", "title": "Tickets", "hideCheckBoxLabels": true, "items": [ TicketsByProject_grid1305, SessionsByProject_grid1306 ], "frame": false, "layoutConfig": { "align": "stretch" }, "labelAlign": "top" });
    var main_panel1308 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1304, tickets_1_panel1307 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1308;
    this.before_row_edit = function(record) {
      ProjectsByProject_grid1301.on_master_changed();
      TicketsByProject_grid1305.on_master_changed();
      SessionsByProject_grid1306.on_master_changed();
    }
    Lino.tickets.Projects.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.Uploads.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 56,
  initComponent : function() {
    var containing_panel = this;
    var file1799 = Lino.file_field_handler(this,{ "autoHeight": true, "fieldLabel": "File", "name": "file", "listeners": { "render": Lino.quicktip_renderer("File","(uploads.Uploads.file) ") }, "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user1800 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(uploads.Uploads.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel1801 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file1799, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1800, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type1804 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Upload Type", "name": "type", "pageSize": 20, "emptyText": "Select a Upload Type...", "listeners": { "render": Lino.quicktip_renderer("Upload Type","(uploads.Uploads.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var description1805 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Description", "name": "description", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Description","(uploads.Uploads.description) ") }, "anchor": "-20" });
    var main_2_panel1806 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1804, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": description1805, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1809 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1801, main_2_panel1806 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1809;
    this.before_row_edit = function(record) {
    }
    Lino.uploads.Uploads.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.TextFieldTemplates.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 10,
  initComponent : function() {
    var containing_panel = this;
    var id180 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(system.TextFieldTemplates.id) ") }, "anchor": "-20" });
    var name181 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(system.TextFieldTemplates.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user182 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(system.TextFieldTemplates.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/user", "method": "GET" }) }) });
    var team183 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Team</span>", "name": "team", "pageSize": 20, "emptyText": "Select a Team...", "listeners": { "render": Lino.quicktip_renderer("Team","(system.TextFieldTemplates.team) If not empty, then this template is reserved to members of this team.") }, "selectOnFocus": true, "hiddenName": "teamHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/team", "method": "GET" }) }) });
    var main_1_panel184 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id180, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name181, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user182, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": team183, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 108, "border": false, "frame": false, "labelAlign": "top" });
    var description189 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(system.TextFieldTemplates.description) ") }, "fieldLabel": "Description", "name": "description", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var text190 = new Lino.RichTextPanel({ "flex": 5, "split": true, "containing_panel": this, "selectOnFocus": true, "region": "south", "title": "Template Text", "name": "text" });
    var main_panel191 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ main_1_panel184, { "flex": 5, "layout": "form", "xtype": "panel", "items": description189, "region": "center", "labelAlign": "top", "split": true }, text190 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel191;
    this.before_row_edit = function(record) {
      text190.refresh();
    }
    Lino.system.TextFieldTemplates.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Journals.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 36,
  initComponent : function() {
    var containing_panel = this;
    var ref1087 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "ref", "name": "ref", "maxLength": 20, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ref","(ledger.Journals.ref) ") }, "anchor": "-20" });
    var trade_type1088 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Trade Type", "name": "trade_type", "hiddenName": "trade_typeHidden", "listeners": { "render": Lino.quicktip_renderer("Trade Type","(ledger.Journals.trade_type) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.vat.TradeTypes) });
    var seqno1089 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "Seq.No.", "name": "seqno", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Seq.No.","(ledger.Journals.seqno) ") }, "anchor": "-20" });
    var id1090 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(ledger.Journals.id) ") }, "anchor": "-20" });
    var voucher_type1091 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "voucher type", "allowBlank": false, "hiddenName": "voucher_typeHidden", "listeners": { "render": Lino.quicktip_renderer("voucher type","(ledger.Journals.voucher_type) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.ledger.VoucherTypes, "name": "voucher_type" });
    var main_1_panel1092 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1087, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": trade_type1088, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": seqno1089, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1090, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": voucher_type1091, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var force_sequence1098 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "force_sequence", "listeners": { "render": Lino.quicktip_renderer("Force chronological sequence","(ledger.Journals.force_sequence) ") }, "boxLabel": "Force chronological sequence", "selectOnFocus": true, "anchor": "-20" });
    var account1099 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Account", "name": "account", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.accounts.Accounts.detail,Lino.accounts.Accounts.insert)}, "emptyText": "Select a Account...", "listeners": { "render": Lino.quicktip_renderer("Account","(ledger.Journals.account) ") }, "selectOnFocus": true, "hiddenName": "accountHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Journals/account", "method": "GET" }) }) });
    var dc1100 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": null, "name": "dc", "listeners": { "render": Lino.quicktip_renderer("dc","(ledger.Journals.dc) Debit (checked) or Credit (not checked)") }, "boxLabel": "dc", "selectOnFocus": true, "anchor": "-20" });
    var build_method1101 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Build method", "name": "build_method", "hiddenName": "build_methodHidden", "listeners": { "render": Lino.quicktip_renderer("Build method","(ledger.Journals.build_method) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template1102 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Template", "name": "template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Template","(ledger.Journals.template) ") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Journals/template", "method": "GET" }) }), "anchor": "-20" });
    var main_2_panel1103 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": force_sequence1098, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": account1099, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": dc1100, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method1101, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template1102, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 261, "border": false, "anchor": "-20", "labelAlign": "top" });
    var name1109 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(ledger.Journals.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1110 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(ledger.Journals.name_de) ") }, "anchor": "-20" });
    var name_fr1111 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(ledger.Journals.name_fr) ") }, "anchor": "-20" });
    var main_3_panel1112 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1109, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1110, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1111, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var printed_name1116 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "printed name", "name": "printed_name", "maxLength": 100, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("printed name","(ledger.Journals.printed_name) ") }, "anchor": "-20" });
    var printed_name_de1117 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "printed name (de)", "name": "printed_name_de", "maxLength": 100, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("printed name (de)","(ledger.Journals.printed_name_de) ") }, "anchor": "-20" });
    var printed_name_fr1118 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "printed name (fr)", "name": "printed_name_fr", "maxLength": 100, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("printed name (fr)","(ledger.Journals.printed_name_fr) ") }, "anchor": "-20" });
    var main_4_panel1119 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": printed_name1116, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": printed_name_de1117, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": printed_name_fr1118, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1123 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1092, main_2_panel1103, main_3_panel1112, main_4_panel1119 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1123;
    this.before_row_edit = function(record) {
      account1099.setContextValue('chart',record ? record.data['chartHidden'] : undefined);
      template1102.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      template1102.setContextValue('voucher_type',record ? record.data['voucher_typeHidden'] : undefined);
    }
    this.onRender = function(ct, position) {
      build_method1101.on('change',Lino.chooser_handler(template1102,'build_method'));
      voucher_type1091.on('change',Lino.chooser_handler(template1102,'voucher_type'));
      Lino.ledger.Journals.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.ledger.Journals.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.Home.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var quick_links_htmlbox1844 = new Lino.HtmlBoxPanel({ "flex": 1, "layout": "fit", "name": "quick_links", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "north", "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer(null,"(system.Home.quick_links) ") }, "split": true });
    var welcome_htmlbox1845 = new Lino.HtmlBoxPanel({ "flex": 3, "layout": "fit", "name": "welcome", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "center", "title": "Welcome", "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Welcome","(system.Home.welcome) ") }, "split": true });
    var main_panel1846 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ quick_links_htmlbox1844, welcome_htmlbox1845 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1846;
    this.before_row_edit = function(record) {
      quick_links_htmlbox1844.refresh();
      welcome_htmlbox1845.refresh();
    }
    Lino.system.Home.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.Report.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var body_htmlbox1838 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "body", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "bodyStyle": "overflow-x:hidden;", "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer(null,"(lino.Report.body) ") } });
    var main_panel1839 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ body_htmlbox1838 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1839;
    this.before_row_edit = function(record) {
      body_htmlbox1838.refresh();
    }
    Lino.lino.Report.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.Users.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 12,
  initComponent : function() {
    var containing_panel = this;
    var username121 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Username</span>", "name": "username", "listeners": { "render": Lino.quicktip_renderer("Username","(users.Users.username) Required. Must be unique.") }, "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var email122 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "e-mail address", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("e-mail address","(users.Users.email) ") }, "anchor": "-20" });
    var main_1_panel123 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username121, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email122, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name126 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "First name", "name": "first_name", "maxLength": 30, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("First name","(users.Users.first_name) ") }, "anchor": "-20" });
    var last_name127 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Last name", "name": "last_name", "maxLength": 30, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Last name","(users.Users.last_name) ") }, "anchor": "-20" });
    var main_2_panel128 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name126, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name127, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var partner131 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "hiddenName": "partnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(users.Users.partner) ") }, "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var language132 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Language", "name": "language", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(users.Users.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ] });
    var profile133 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">User Profile</span>", "name": "profile", "hiddenName": "profileHidden", "listeners": { "render": Lino.quicktip_renderer("User Profile","(users.Users.profile) Users with an empty `profile` field are considered inactive and cannot log in.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var main_4_panel134 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 47, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language132, "labelAlign": "top" }, { "flex": 52, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile133, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel137 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ main_1_panel123, main_2_panel128, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner131, "anchor": "-20", "labelAlign": "top" }, main_4_panel134 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel137;
    this.before_row_edit = function(record) {
    }
    Lino.users.Users.InsertFormPanel.superclass.initComponent.call(this);
    // active_fields:
    partner131.on("change",function(){this.save()},this);
  }
});


Lino.contacts.Partners.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 25,
  initComponent : function() {
    var containing_panel = this;
    var name614 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Partners.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language615 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Language", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(contacts.Partners.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var email616 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Partners.email) ") }, "anchor": "-20" });
    var main_2_panel617 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language615, "labelAlign": "top" }, { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email616, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel620 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name614, "anchor": "-20", "labelAlign": "top" }, main_2_panel617 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel620;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Partners.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.Tickets.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 54,
  initComponent : function() {
    var containing_panel = this;
    var summary605 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Summary</span>", "name": "summary", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Summary","(tickets.Tickets.summary) Short summary of the problem.") }, "anchor": "-20" });
    var partner606 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Partner</span>", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "hiddenName": "partnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(tickets.Tickets.partner) The partner who reported this ticket.") }, "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/partner", "method": "GET" }) }) });
    var project607 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail,Lino.tickets.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(tickets.Tickets.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/project", "method": "GET" }) }) });
    var main_panel608 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary605, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner606, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": project607, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel608;
    this.before_row_edit = function(record) {
    }
    Lino.tickets.Tickets.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Households.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 29,
  initComponent : function() {
    var containing_panel = this;
    var type887 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Household Type", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.households.Types.detail,Lino.households.Types.insert)}, "emptyText": "Select a Household Type...", "listeners": { "render": Lino.quicktip_renderer("Household Type","(households.Households.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/type", "method": "GET" }) }) });
    var name888 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Name","(households.Households.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language889 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Language", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(households.Households.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var id890 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(households.Households.id) ") }, "anchor": "-20" });
    var intro_box_1_panel891 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type887, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name888, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language889, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id890, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var country896 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Country","(households.Households.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/country", "method": "GET" }) }) });
    var region897 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Region", "name": "region", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail,Lino.countries.Cities.insert)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Region","(households.Households.region) ") }, "selectOnFocus": true, "hiddenName": "regionHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/region", "method": "GET" }) }) });
    var box3_1_panel898 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country896, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region897, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var city901 = new Lino.TwinCombo({ "autoHeight": true, "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail,Lino.countries.Cities.insert)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Place","(households.Households.city) ") }, "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/city", "method": "GET" }) }) });
    var zip_code902 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Zip code", "name": "zip_code", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Zip code","(households.Households.zip_code) ") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var box3_2_panel903 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city901, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code902, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var street_prefix906 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street prefix</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Street prefix","(households.Households.street_prefix) Text to print before name of street, but to ignore for sorting.") }, "anchor": "-20" });
    var street907 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Street","(households.Households.street) Name of street. Without house number.") }, "anchor": "-20" });
    var street_no908 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("No.","(households.Households.street_no) House number") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var street_box909 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "boxMinWidth": Lino.chars2width(10), "listeners": { "render": Lino.quicktip_renderer("Box","(households.Households.street_box) Text to print after :attr:`steet_no` on the same line") }, "maxLength": 10, "selectOnFocus": true, "anchor": "-20" });
    var box3_3_panel910 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix906, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street907, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no908, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box909, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2915 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line after street</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Address line after street","(households.Households.addr2) Address line to print below street line") }, "anchor": "-20" });
    var box3_panel916 = new Ext.Panel({ "flex": 62, "autoHeight": true, "layout": "form", "items": [ box3_1_panel898, box3_2_panel903, box3_3_panel910, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2915, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 234, "border": false, "labelAlign": "top" });
    var email918 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail","(households.Households.email) ") }, "anchor": "-20" });
    var url919 = new Lino.URLField({ "autoHeight": true, "fieldLabel": "URL", "name": "url", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("URL","(households.Households.url) ") }, "anchor": "-20" });
    var phone920 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Phone", "name": "phone", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Phone","(households.Households.phone) ") }, "anchor": "-20" });
    var gsm921 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "GSM", "name": "gsm", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("GSM","(households.Households.gsm) ") }, "anchor": "-20" });
    var box4_panel922 = new Ext.Panel({ "flex": 37, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email918, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url919, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone920, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm921, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var address_box_panel927 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box3_panel916, box4_panel922 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks928 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remarks","(households.Households.remarks) ") }, "fieldLabel": "Remarks", "name": "remarks", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var households_MembersByHousehold_grid935 = new Lino.households.MembersByHousehold.GridPanel({ "flex": 54, "listeners": { "render": Lino.quicktip_renderer("Household Members","(households.households.MembersByHousehold) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.MembersByHousehold.grid) ], "preview_limit": 15, "master_panel": this });
    var bottom_box_panel936 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": remarks928, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 45 }, households_MembersByHousehold_grid935 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel938 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ intro_box_1_panel891, address_box_panel927, bottom_box_panel936 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var invoicing_address939 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Invoicing address", "name": "invoicing_address", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "hiddenName": "invoicing_addressHidden", "listeners": { "render": Lino.quicktip_renderer("Invoicing address","(households.Households.invoicing_address) ") }, "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/invoicing_address", "method": "GET" }) }) });
    var vat_regime940 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">VAT Regime</span>", "name": "vat_regime", "hiddenName": "vat_regimeHidden", "listeners": { "render": Lino.quicktip_renderer("VAT Regime","(households.Households.vat_regime) The default VAT regime for sales to this customer.") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var imode941 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Invoicing Mode", "name": "imode", "pageSize": 20, "emptyText": "Select a Invoicing Mode...", "listeners": { "render": Lino.quicktip_renderer("Invoicing Mode","(households.Households.imode) ") }, "selectOnFocus": true, "hiddenName": "imodeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/imode", "method": "GET" }) }) });
    var payment_term942 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Payment Term</span>", "name": "payment_term", "pageSize": 20, "emptyText": "Select a Payment Term...", "listeners": { "render": Lino.quicktip_renderer("Payment Term","(households.Households.payment_term) The default payment term for sales invoices to this customer.") }, "selectOnFocus": true, "hiddenName": "payment_termHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/payment_term", "method": "GET" }) }) });
    var sales_1_panel943 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 162, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": invoicing_address939, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_regime940, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": imode941, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": payment_term942, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var sales_InvoicesByPartner_grid948 = new Lino.sales.InvoicesByPartner.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Invoices","(sales.sales.InvoicesByPartner) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.sales.InvoicesByPartner.grid) ], "preview_limit": 15, "master_panel": this });
    var sales_panel949 = new Ext.Panel({ "layout": "vbox", "title": "Sales", "items": [ sales_1_panel943, sales_InvoicesByPartner_grid948 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel950 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel938, sales_panel949 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel950;
    this.before_row_edit = function(record) {
      region897.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city901.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city901.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      households_MembersByHousehold_grid935.on_master_changed();
      sales_InvoicesByPartner_grid948.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country896.on('change',Lino.chooser_handler(region897,'country'));
      country896.on('change',Lino.chooser_handler(city901,'country'));
      region897.on('change',Lino.chooser_handler(city901,'region'));
      Lino.households.Households.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.households.Households.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.products.Products.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 32,
  initComponent : function() {
    var containing_panel = this;
    var id1052 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(products.Products.id) ") }, "anchor": "-20" });
    var cat1053 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Category", "name": "cat", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.products.ProductCats.detail,Lino.products.ProductCats.insert)}, "emptyText": "Select a Product Category...", "listeners": { "render": Lino.quicktip_renderer("Category","(products.Products.cat) ") }, "selectOnFocus": true, "hiddenName": "catHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/products/Products/cat", "method": "GET" }) }) });
    var sales_price1054 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "Sales price", "name": "sales_price", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Sales price","(products.Products.sales_price) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var vat_class1055 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "VAT Class", "name": "vat_class", "hiddenName": "vat_classHidden", "listeners": { "render": Lino.quicktip_renderer("VAT Class","(products.Products.vat_class) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.vat.VatClasses) });
    var general_1_panel1056 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1052, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cat1053, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sales_price1054, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_class1055, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var name1061 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(products.Products.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1062 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(products.Products.name_de) ") }, "anchor": "-20" });
    var name_fr1063 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(products.Products.name_fr) ") }, "anchor": "-20" });
    var general_2_panel1064 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1061, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1062, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1063, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description1068 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Long description","(products.Products.description) ") }, "fieldLabel": "Long description", "name": "description", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var general_panel1069 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel1056, general_2_panel1064, { "items": description1068, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "labelWidth": 153, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var sales_InvoiceItemsByProduct_grid1082 = new Lino.sales.InvoiceItemsByProduct.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "hide_top_toolbar": true, "containing_panel": this, "title": "Sales", "tools": [ Lino.show_in_own_window_button(Lino.sales.InvoiceItemsByProduct.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1083 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel1069, sales_InvoiceItemsByProduct_grid1082 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel1083;
    this.before_row_edit = function(record) {
      sales_InvoiceItemsByProduct_grid1082.on_master_changed();
    }
    Lino.products.Products.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.GuestRoles.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 64,
  initComponent : function() {
    var containing_panel = this;
    var id1589 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.GuestRoles.id) ") }, "anchor": "-20" });
    var name1590 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(cal.GuestRoles.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1591 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(cal.GuestRoles.name_de) ") }, "anchor": "-20" });
    var name_fr1592 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(cal.GuestRoles.name_fr) ") }, "anchor": "-20" });
    var main_1_panel1593 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1589, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1590, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1591, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1592, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var build_method1598 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Build method", "name": "build_method", "hiddenName": "build_methodHidden", "listeners": { "render": Lino.quicktip_renderer("Build method","(cal.GuestRoles.build_method) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template1599 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Template", "name": "template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Template","(cal.GuestRoles.template) ") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestRoles/template", "method": "GET" }) }), "anchor": "-20" });
    var email_template1600 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Email template</span>", "name": "email_template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Email template","(cal.GuestRoles.email_template) The name of the file to be used as \ntemplate when creating an email from a mailable of this type.") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestRoles/email_template", "method": "GET" }) }), "anchor": "-20" });
    var attach_to_email1601 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "attach_to_email", "listeners": { "render": Lino.quicktip_renderer("Attach to email","(cal.GuestRoles.attach_to_email) Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "boxLabel": "Attach to email", "selectOnFocus": true, "anchor": "-20" });
    var main_2_panel1602 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method1598, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template1599, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template1600, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email1601, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_GuestsByRole_grid1616 = new Lino.cal.GuestsByRole.GridPanel({ "flex": 71, "listeners": { "render": Lino.quicktip_renderer("Guests","(cal.cal.GuestsByRole) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.cal.GuestsByRole.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1617 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1593, main_2_panel1602, cal_GuestsByRole_grid1616 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1617;
    this.before_row_edit = function(record) {
      template1599.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      cal_GuestsByRole_grid1616.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method1598.on('change',Lino.chooser_handler(template1599,'build_method'));
      Lino.cal.GuestRoles.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.cal.GuestRoles.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Journals.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 36,
  initComponent : function() {
    var containing_panel = this;
    var ref1124 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "ref", "name": "ref", "maxLength": 20, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ref","(ledger.Journals.ref) ") }, "anchor": "-20" });
    var name1125 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(ledger.Journals.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1126 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(ledger.Journals.name_de) ") }, "anchor": "-20" });
    var name_fr1127 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(ledger.Journals.name_fr) ") }, "anchor": "-20" });
    var main_1_panel1128 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1124, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1125, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1126, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1127, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var trade_type1133 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Trade Type", "name": "trade_type", "hiddenName": "trade_typeHidden", "listeners": { "render": Lino.quicktip_renderer("Trade Type","(ledger.Journals.trade_type) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.vat.TradeTypes) });
    var voucher_type1134 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "voucher type", "allowBlank": false, "hiddenName": "voucher_typeHidden", "listeners": { "render": Lino.quicktip_renderer("voucher type","(ledger.Journals.voucher_type) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.ledger.VoucherTypes, "name": "voucher_type" });
    var main_panel1135 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 117, "autoScroll": false, "items": [ main_1_panel1128, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": trade_type1133, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": voucher_type1134, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1135;
    this.before_row_edit = function(record) {
    }
    Lino.ledger.Journals.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Guests.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 62,
  initComponent : function() {
    var containing_panel = this;
    var event1466 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Event", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.OneEvent.detail,Lino.cal.OneEvent.insert)}, "emptyText": "Select a Event...", "listeners": { "render": Lino.quicktip_renderer("Event","(cal.Guests.event) ") }, "selectOnFocus": true, "hiddenName": "eventHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/event", "method": "GET" }) }), "name": "event" });
    var partner1467 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "emptyText": "Select a Partner...", "listeners": { "render": Lino.quicktip_renderer("Partner","(cal.Guests.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }), "name": "partner" });
    var role1468 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Role", "name": "role", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.GuestRoles.detail,Lino.cal.GuestRoles.insert)}, "emptyText": "Select a Guest Role...", "listeners": { "render": Lino.quicktip_renderer("Role","(cal.Guests.role) ") }, "selectOnFocus": true, "hiddenName": "roleHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/role", "method": "GET" }) }) });
    var main_1_panel1469 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event1466, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner1467, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": role1468, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var state1473 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "State", "allowBlank": false, "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("State","(cal.Guests.state) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.cal.GuestStates, "name": "state" });
    var remark1474 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Remark", "name": "remark", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Remark","(cal.Guests.remark) ") }, "anchor": "-20" });
    var workflow_buttons_disp1475 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Workflow", "name": "workflow_buttons", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Workflow","(cal.Guests.workflow_buttons) ") }, "anchor": "-20" });
    var main_2_panel1476 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state1473, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": remark1474, "labelAlign": "top" }, { "flex": 49, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp1475, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var outbox_MailsByController_grid1525 = new Lino.outbox.MailsByController.GridPanel({ "flex": 55, "listeners": { "render": Lino.quicktip_renderer("Outgoing Mails","(outbox.outbox.MailsByController) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1526 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1469, main_2_panel1476, outbox_MailsByController_grid1525 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1526;
    this.before_row_edit = function(record) {
      outbox_MailsByController_grid1525.on_master_changed();
    }
    Lino.cal.Guests.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Countries.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 15,
  initComponent : function() {
    var containing_panel = this;
    var isocode201 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">ISO code</span>", "name": "isocode", "boxMinWidth": Lino.chars2width(4), "listeners": { "render": Lino.quicktip_renderer("ISO code","(countries.Countries.isocode)         The two-letter code for this country as defined by ISO 3166-1. \n        For countries that no longer exist it may be a 4-letter code.") }, "maxLength": 4, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name202 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(countries.Countries.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de203 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(countries.Countries.name_de) ") }, "anchor": "-20" });
    var name_fr204 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(countries.Countries.name_fr) ") }, "anchor": "-20" });
    var short_code205 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Short code</span>", "name": "short_code", "boxMinWidth": Lino.chars2width(4), "listeners": { "render": Lino.quicktip_renderer("Short code","(countries.Countries.short_code) A short abbreviation for regional usage. Obsolete.") }, "maxLength": 4, "selectOnFocus": true, "anchor": "-20" });
    var main_1_panel206 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": isocode201, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name202, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de203, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr204, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": short_code205, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var countries_CitiesByCountry_grid627 = new Lino.countries.CitiesByCountry.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Places","(countries.countries.CitiesByCountry) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.countries.CitiesByCountry.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel628 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel206, countries_CitiesByCountry_grid627 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel628;
    this.before_row_edit = function(record) {
      countries_CitiesByCountry_grid627.on_master_changed();
    }
    Lino.countries.Countries.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Cities.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 16,
  initComponent : function() {
    var containing_panel = this;
    var name220 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(countries.Cities.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de221 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(countries.Cities.name_de) ") }, "anchor": "-20" });
    var name_fr222 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(countries.Cities.name_fr) ") }, "anchor": "-20" });
    var country223 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Country", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail,Lino.countries.Countries.insert)}, "emptyText": "Select a Country...", "listeners": { "render": Lino.quicktip_renderer("Country","(countries.Cities.country) ") }, "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/country", "method": "GET" }) }), "name": "country" });
    var main_1_panel224 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name220, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de221, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr222, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country223, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var type229 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Place Type", "name": "type", "hiddenName": "typeHidden", "listeners": { "render": Lino.quicktip_renderer("Place Type","(countries.Cities.type) ") }, "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/type", "method": "GET" }) }) });
    var parent230 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Part of</span>", "name": "parent", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail,Lino.countries.Cities.insert)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Part of","(countries.Cities.parent) The superordinate geographic place of which this place is a part.") }, "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/parent", "method": "GET" }) }) });
    var zip_code231 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "zip code", "name": "zip_code", "boxMinWidth": Lino.chars2width(8), "listeners": { "render": Lino.quicktip_renderer("zip code","(countries.Cities.zip_code) ") }, "maxLength": 8, "selectOnFocus": true, "anchor": "-20" });
    var id232 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(countries.Cities.id) ") }, "anchor": "-20" });
    var main_2_panel233 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type229, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent230, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code231, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id232, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var CitiesByCity_grid624 = new Lino.countries.CitiesByCity.GridPanel({ "flex": 41, "listeners": { "render": Lino.quicktip_renderer("Subdivisions","(countries.countries.CitiesByCity) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.countries.CitiesByCity.grid) ], "preview_limit": 15, "master_panel": this });
    var contacts_PartnersByCity_grid625 = new Lino.contacts.PartnersByCity.GridPanel({ "flex": 41, "listeners": { "render": Lino.quicktip_renderer("Partners","(contacts.contacts.PartnersByCity) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.contacts.PartnersByCity.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel626 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel224, main_2_panel233, CitiesByCity_grid624, contacts_PartnersByCity_grid625 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel626;
    this.before_row_edit = function(record) {
      type229.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      CitiesByCity_grid624.on_master_changed();
      contacts_PartnersByCity_grid625.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country223.on('change',Lino.chooser_handler(type229,'country'));
      Lino.countries.Cities.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.countries.Cities.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropGroups.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 18,
  initComponent : function() {
    var containing_panel = this;
    var id629 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(properties.PropGroups.id) ") }, "anchor": "-20" });
    var name630 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(properties.PropGroups.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de631 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(properties.PropGroups.name_de) ") }, "anchor": "-20" });
    var name_fr632 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(properties.PropGroups.name_fr) ") }, "anchor": "-20" });
    var main_1_panel633 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id629, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name630, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de631, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr632, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var PropsByGroup_grid644 = new Lino.properties.PropsByGroup.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Properties","(properties.properties.PropsByGroup) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.properties.PropsByGroup.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel645 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel633, PropsByGroup_grid644 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel645;
    this.before_row_edit = function(record) {
      PropsByGroup_grid644.on_master_changed();
    }
    Lino.properties.PropGroups.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.RecurrentEvents.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 59,
  initComponent : function() {
    var containing_panel = this;
    var name1768 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(cal.RecurrentEvents.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1769 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(cal.RecurrentEvents.name_de) ") }, "anchor": "-20" });
    var name_fr1770 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(cal.RecurrentEvents.name_fr) ") }, "anchor": "-20" });
    var main_1_panel1771 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1768, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1769, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1770, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var user1775 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(cal.RecurrentEvents.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/RecurrentEvents/user", "method": "GET" }) }) });
    var event_type1776 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Event Type", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail,Lino.cal.EventTypes.insert)}, "emptyText": "Select a Event Type...", "listeners": { "render": Lino.quicktip_renderer("Event Type","(cal.RecurrentEvents.event_type) ") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/RecurrentEvents/event_type", "method": "GET" }) }) });
    var main_2_panel1777 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1775, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type1776, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1780 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1771, main_2_panel1777 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1780;
    this.before_row_edit = function(record) {
    }
    Lino.cal.RecurrentEvents.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.RecurrentEvents.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 59,
  initComponent : function() {
    var containing_panel = this;
    var id1695 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.RecurrentEvents.id) ") }, "anchor": "-20" });
    var user1696 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(cal.RecurrentEvents.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/RecurrentEvents/user", "method": "GET" }) }) });
    var event_type1697 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Event Type", "name": "event_type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail,Lino.cal.EventTypes.insert)}, "emptyText": "Select a Event Type...", "listeners": { "render": Lino.quicktip_renderer("Event Type","(cal.RecurrentEvents.event_type) ") }, "selectOnFocus": true, "hiddenName": "event_typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/RecurrentEvents/event_type", "method": "GET" }) }) });
    var name1698 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(cal.RecurrentEvents.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1699 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(cal.RecurrentEvents.name_de) ") }, "anchor": "-20" });
    var name_fr1700 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(cal.RecurrentEvents.name_fr) ") }, "anchor": "-20" });
    var main_1_panel1701 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 4, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1695, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1696, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_type1697, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1698, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1699, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1700, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var start_date1708 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Start date", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start date","(cal.RecurrentEvents.start_date) ") }, "anchor": "-20" });
    var start_time1709 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "Start time", "name": "start_time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start time","(cal.RecurrentEvents.start_time) ") }, "anchor": "-20" });
    var end_date1710 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "End Date", "name": "end_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("End Date","(cal.RecurrentEvents.end_date) ") }, "anchor": "-20" });
    var end_time1711 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "End Time", "name": "end_time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("End Time","(cal.RecurrentEvents.end_time) ") }, "anchor": "-20" });
    var main_2_panel1712 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1708, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time1709, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date1710, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time1711, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var max_events1717 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "Number of events", "name": "max_events", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Number of events","(cal.RecurrentEvents.max_events) ") }, "anchor": "-20" });
    var every_unit1718 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Recurrency", "name": "every_unit", "hiddenName": "every_unitHidden", "listeners": { "render": Lino.quicktip_renderer("Recurrency","(cal.RecurrentEvents.every_unit) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.cal.Recurrencies) });
    var every1719 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "Repeat every", "name": "every", "value": 0, "listeners": { "render": Lino.quicktip_renderer("Repeat every","(cal.RecurrentEvents.every) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_3_panel1720 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": max_events1717, "labelAlign": "top" }, { "flex": 58, "autoHeight": true, "layout": "form", "xtype": "panel", "items": every_unit1718, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": every1719, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var monday1724 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "monday", "listeners": { "render": Lino.quicktip_renderer("Monday","(cal.RecurrentEvents.monday) ") }, "boxLabel": "Monday", "selectOnFocus": true, "anchor": "-20" });
    var tuesday1725 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "tuesday", "listeners": { "render": Lino.quicktip_renderer("Tuesday","(cal.RecurrentEvents.tuesday) ") }, "boxLabel": "Tuesday", "selectOnFocus": true, "anchor": "-20" });
    var wednesday1726 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "wednesday", "listeners": { "render": Lino.quicktip_renderer("Wednesday","(cal.RecurrentEvents.wednesday) ") }, "boxLabel": "Wednesday", "selectOnFocus": true, "anchor": "-20" });
    var thursday1727 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "thursday", "listeners": { "render": Lino.quicktip_renderer("Thursday","(cal.RecurrentEvents.thursday) ") }, "boxLabel": "Thursday", "selectOnFocus": true, "anchor": "-20" });
    var friday1728 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "friday", "listeners": { "render": Lino.quicktip_renderer("Friday","(cal.RecurrentEvents.friday) ") }, "boxLabel": "Friday", "selectOnFocus": true, "anchor": "-20" });
    var saturday1729 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "saturday", "listeners": { "render": Lino.quicktip_renderer("Saturday","(cal.RecurrentEvents.saturday) ") }, "boxLabel": "Saturday", "selectOnFocus": true, "anchor": "-20" });
    var sunday1730 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "sunday", "listeners": { "render": Lino.quicktip_renderer("Sunday","(cal.RecurrentEvents.sunday) ") }, "boxLabel": "Sunday", "selectOnFocus": true, "anchor": "-20" });
    var main_4_panel1731 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": monday1724, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": tuesday1725, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": wednesday1726, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": thursday1727, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": friday1728, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": saturday1729, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sunday1730, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description1739 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 33, "containing_panel": this, "name": "description", "title": "Description" });
    var cal_EventsByController_grid1765 = new Lino.cal.EventsByController.GridPanel({ "flex": 66, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Events","(cal.cal.EventsByController) ") }, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByController.grid) ] });
    var main_5_panel1766 = new Ext.Panel({ "flex": 55, "border": false, "layout": "hbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ description1739, cal_EventsByController_grid1765 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel1767 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1701, main_2_panel1712, main_3_panel1720, main_4_panel1731, main_5_panel1766 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1767;
    this.before_row_edit = function(record) {
      description1739.refresh();
      cal_EventsByController_grid1765.on_master_changed();
    }
    Lino.cal.RecurrentEvents.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 22,
  initComponent : function() {
    var containing_panel = this;
    var name838 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Name", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Name","(contacts.Companies.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language839 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Language", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(contacts.Companies.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var email840 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "E-Mail", "name": "email", "maxLength": 75, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("E-Mail","(contacts.Companies.email) ") }, "anchor": "-20" });
    var main_2_panel841 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language839, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email840, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type844 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Company type", "name": "type", "pageSize": 20, "emptyText": "Select a company type...", "listeners": { "render": Lino.quicktip_renderer("Company type","(contacts.Companies.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var id845 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(contacts.Companies.id) ") }, "anchor": "-20" });
    var main_3_panel846 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type844, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id845, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel849 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name838, "anchor": "-20", "labelAlign": "top" }, main_2_panel841, main_3_panel846 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel849;
    this.before_row_edit = function(record) {
    }
    Lino.contacts.Companies.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.Tickets.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 54,
  initComponent : function() {
    var containing_panel = this;
    var summary493 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Summary</span>", "name": "summary", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Summary","(tickets.Tickets.summary) Short summary of the problem.") }, "anchor": "-20" });
    var partner494 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Partner</span>", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "hiddenName": "partnerHidden", "listeners": { "render": Lino.quicktip_renderer("Partner","(tickets.Tickets.partner) The partner who reported this ticket.") }, "selectOnFocus": true, "emptyText": "Select a Partner...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/partner", "method": "GET" }) }) });
    var project495 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail,Lino.tickets.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(tickets.Tickets.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/project", "method": "GET" }) }) });
    var reported496 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Reported for</span>", "name": "reported", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Milestones.detail,Lino.tickets.Milestones.insert)}, "emptyText": "Select a Milestone...", "listeners": { "render": Lino.quicktip_renderer("Reported for","(tickets.Tickets.reported) Milestone for which this ticket has been reported.") }, "selectOnFocus": true, "hiddenName": "reportedHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/reported", "method": "GET" }) }) });
    var id497 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(tickets.Tickets.id) ") }, "anchor": "-20" });
    var main_1_panel498 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary493, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner494, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project495, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": reported496, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id497, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user504 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(tickets.Tickets.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/user", "method": "GET" }) }) });
    var created505 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "listeners": { "render": Lino.quicktip_renderer("Created","(tickets.Tickets.created) ") }, "value": "<br>", "anchor": "-20" });
    var modified506 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "listeners": { "render": Lino.quicktip_renderer("Modified","(tickets.Tickets.modified) ") }, "value": "<br>", "anchor": "-20" });
    var state507 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "State", "name": "state", "hiddenName": "stateHidden", "listeners": { "render": Lino.quicktip_renderer("State","(tickets.Tickets.state) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.tickets.TicketStates) });
    var workflow_buttons_disp508 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Workflow", "name": "workflow_buttons", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Workflow","(tickets.Tickets.workflow_buttons) ") }, "anchor": "-20" });
    var fixed509 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Fixed for</span>", "name": "fixed", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Milestones.detail,Lino.tickets.Milestones.insert)}, "emptyText": "Select a Milestone...", "listeners": { "render": Lino.quicktip_renderer("Fixed for","(tickets.Tickets.fixed) The milestone for which this ticket has been fixed.") }, "selectOnFocus": true, "hiddenName": "fixedHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/fixed", "method": "GET" }) }) });
    var main_2_panel510 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user504, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created505, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified506, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state507, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp508, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fixed509, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description517 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(tickets.Tickets.description) ") }, "fieldLabel": "Description", "name": "description", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var SessionsByTicket_grid587 = new Lino.tickets.SessionsByTicket.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("Sessions","(tickets.tickets.SessionsByTicket) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.tickets.SessionsByTicket.grid) ], "preview_limit": 15, "master_panel": this });
    var EntriesByTicket_grid601 = new Lino.tickets.EntriesByTicket.GridPanel({ "flex": 50, "listeners": { "render": Lino.quicktip_renderer("Blog Entries","(tickets.tickets.EntriesByTicket) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.tickets.EntriesByTicket.grid) ], "preview_limit": 15, "master_panel": this });
    var main_4_panel602 = new Ext.Panel({ "flex": 35, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ SessionsByTicket_grid587, EntriesByTicket_grid601 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel603 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ main_1_panel498, main_2_panel510, { "items": description517, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 35 }, main_4_panel602 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel603;
    this.before_row_edit = function(record) {
      reported496.setContextValue('project',record ? record.data['projectHidden'] : undefined);
      fixed509.setContextValue('project',record ? record.data['projectHidden'] : undefined);
      SessionsByTicket_grid587.on_master_changed();
      EntriesByTicket_grid601.on_master_changed();
    }
    this.onRender = function(ct, position) {
      project495.on('change',Lino.chooser_handler(reported496,'project'));
      project495.on('change',Lino.chooser_handler(fixed509,'project'));
      Lino.tickets.Tickets.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.tickets.Tickets.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Calendars.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 65,
  initComponent : function() {
    var containing_panel = this;
    var name1566 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(cal.Calendars.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1567 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(cal.Calendars.name_de) ") }, "anchor": "-20" });
    var name_fr1568 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(cal.Calendars.name_fr) ") }, "anchor": "-20" });
    var color1569 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "color", "name": "color", "value": 1, "listeners": { "render": Lino.quicktip_renderer("color","(cal.Calendars.color) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id1570 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.Calendars.id) ") }, "anchor": "-20" });
    var main_1_panel1571 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1566, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1567, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1568, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": color1569, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1570, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description1577 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 83, "containing_panel": this, "name": "description", "title": "Description" });
    var main_panel1578 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel1571, description1577 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1578;
    this.before_row_edit = function(record) {
      description1577.refresh();
    }
    Lino.cal.Calendars.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.blogs.EntryTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 48,
  initComponent : function() {
    var containing_panel = this;
    var id1201 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(blogs.EntryTypes.id) ") }, "anchor": "-20" });
    var name1202 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(blogs.EntryTypes.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1203 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(blogs.EntryTypes.name_de) ") }, "anchor": "-20" });
    var name_fr1204 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(blogs.EntryTypes.name_fr) ") }, "anchor": "-20" });
    var main_1_panel1205 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1201, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1202, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1203, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1204, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var build_method1210 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Build method", "name": "build_method", "hiddenName": "build_methodHidden", "listeners": { "render": Lino.quicktip_renderer("Build method","(blogs.EntryTypes.build_method) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template1211 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Template", "name": "template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Template","(blogs.EntryTypes.template) ") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/EntryTypes/template", "method": "GET" }) }), "anchor": "-20" });
    var main_2_panel1212 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method1210, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template1211, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remark1215 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Remark","(blogs.EntryTypes.remark) ") }, "fieldLabel": "Remark", "name": "remark", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var blogs_EntriesByType_grid1228 = new Lino.blogs.EntriesByType.GridPanel({ "flex": 41, "listeners": { "render": Lino.quicktip_renderer("Blog Entries","(blogs.blogs.EntriesByType) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.blogs.EntriesByType.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel1229 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 63, "hideCheckBoxLabels": true, "items": [ main_1_panel1205, main_2_panel1212, { "items": remark1215, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 41 }, blogs_EntriesByType_grid1228 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1229;
    this.before_row_edit = function(record) {
      template1211.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      blogs_EntriesByType_grid1228.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method1210.on('change',Lino.chooser_handler(template1211,'build_method'));
      Lino.blogs.EntryTypes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.blogs.EntryTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Rooms.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 58,
  initComponent : function() {
    var containing_panel = this;
    var id1352 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.Rooms.id) ") }, "anchor": "-20" });
    var name1353 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(cal.Rooms.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1354 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(cal.Rooms.name_de) ") }, "anchor": "-20" });
    var name_fr1355 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(cal.Rooms.name_fr) ") }, "anchor": "-20" });
    var main_1_panel1356 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1352, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1353, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1354, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1355, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var cal_EventsByRoom_grid1564 = new Lino.cal.EventsByRoom.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Events","(cal.cal.EventsByRoom) ") }, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByRoom.grid) ] });
    var main_panel1565 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1356, cal_EventsByRoom_grid1564 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1565;
    this.before_row_edit = function(record) {
      cal_EventsByRoom_grid1564.on_master_changed();
    }
    Lino.cal.Rooms.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.Mails.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 68,
  initComponent : function() {
    var containing_panel = this;
    var project1519 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail,Lino.tickets.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(outbox.Mails.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var subject1520 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Subject", "name": "subject", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Subject","(outbox.Mails.subject) ") }, "anchor": "-20" });
    var body1521 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 71, "containing_panel": this, "name": "body", "title": "Body" });
    var main_panel1522 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": project1519, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, { "items": subject1520, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, body1521 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1522;
    this.before_row_edit = function(record) {
      body1521.refresh();
    }
    Lino.outbox.Mails.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.About.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var server_status_disp1841 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Server status", "name": "server_status", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Server status","(about.About.server_status) ") }, "anchor": "-20" });
    var main_panel1842 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "html": "<div class=\"htmlText\"><span>This is <a href=\"http://www.lino-framework.org/autodoc/lino.projects.presto\" target=\"_blank\">Lino Presto</a> 0.1 using <a href=\"http://www.lino-framework.org\" target=\"_blank\">Lino</a> 1.6.13, <a href=\"http://north.lino-framework.org\" target=\"_blank\">North</a> 0.1.7, <a href=\"http://site.lino-framework.org\" target=\"_blank\">djangosite</a> 0.1.8, <a href=\"http://www.djangoproject.com\" target=\"_blank\">Django</a> 1.5.1, <a href=\"http://www.python.org/\" target=\"_blank\">Python</a> 2.7.3, <a href=\"http://babel.edgewall.org/\" target=\"_blank\">Babel</a> 1.3, <a href=\"http://jinja.pocoo.org/\" target=\"_blank\">Jinja</a> 2.7.1, <a href=\"http://sphinx-doc.org/\" target=\"_blank\">Sphinx</a> 1.2b3, <a href=\"http://labix.org/python-dateutil\" target=\"_blank\">python-dateutil</a> 2.1, <a href=\"http://pypi.python.org/pypi/odfpy\" target=\"_blank\">OdfPy</a> ODFPY/0.9.6, <a href=\"http://docutils.sourceforge.net/\" target=\"_blank\">docutils</a> 0.11, <a href=\"https://fedorahosted.org/suds/\" target=\"_blank\">suds</a> 0.4, <a href=\"http://pyyaml.org/\" target=\"_blank\">PyYaml</a> 3.10, <a href=\"http://appyframework.org/pod.html\" target=\"_blank\">Appy</a> 0.8.3 (2013/02/22 15:29), <a href=\"http://www.sencha.com\" target=\"_blank\">ExtJS</a> <a href=\"#\" onclick=\"alert('ExtJS client version is ' + Ext.version);\" title=\"Click to see ExtJS client version\">(version)</a>, <a href=\"http://ext.ensible.com/products/calendar/\" target=\"_blank\">Extensible</a> <a href=\"#\" onclick=\"alert('Extensible Calendar version is ' + Ext.ensible.version);\" title=\"Click to see Extensible Calendar version\">(version)</a>, <a href=\"http://www.famfamfam.com/lab/icons/silk/\" target=\"_blank\">Silk Icons</a> 1.3</span><p>Server uptime : <b>Saturday, December 7, 2013 at 22:13:25.966390</b></p><p>Source timestamps:</p><ul><li>lino : <b>Saturday, December 7, 2013 at 22:08:44.009274</b></li><li>djangosite : <b>Saturday, December 7, 2013 at 21:19:08.153322</b></li><li>north : <b>Thursday, December 5, 2013 at 18:04:18.528108</b></li><li>atelier : <b>Monday, November 25, 2013 at 13:49:33.557230</b></li><li>django : <b>Wednesday, October 16, 2013 at 16:22:34.417122</b></li></ul></div>", "xtype": "label" }, { "items": server_status_disp1841, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1842;
    this.before_row_edit = function(record) {
    }
    Lino.about.About.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.blogs.Entries.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 47,
  initComponent : function() {
    var containing_panel = this;
    var title562 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Heading", "name": "title", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Heading","(blogs.Entries.title) ") }, "anchor": "-20" });
    var type563 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Blog Entry Type", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.blogs.EntryTypes.detail,Lino.blogs.EntryTypes.insert)}, "emptyText": "Select a Blog Entry Type...", "listeners": { "render": Lino.quicktip_renderer("Blog Entry Type","(blogs.Entries.type) ") }, "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/Entries/type", "method": "GET" }) }) });
    var user564 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(blogs.Entries.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/Entries/user", "method": "GET" }) }) });
    var id565 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(blogs.Entries.id) ") }, "anchor": "-20" });
    var main_1_panel566 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title562, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type563, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user564, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id565, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var language571 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Language", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(blogs.Entries.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var created572 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Created", "name": "created", "listeners": { "render": Lino.quicktip_renderer("Created","(blogs.Entries.created) ") }, "value": "<br>", "anchor": "-20" });
    var modified573 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Modified", "name": "modified", "listeners": { "render": Lino.quicktip_renderer("Modified","(blogs.Entries.modified) ") }, "value": "<br>", "anchor": "-20" });
    var owner_disp574 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Controlled by", "anchor": "-20", "name": "owner" });
    var build_time575 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "build time", "name": "build_time", "listeners": { "render": Lino.quicktip_renderer("build time","(blogs.Entries.build_time) ") }, "value": "<br>", "anchor": "-20" });
    var main_2_panel576 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language571, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created572, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified573, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp574, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_time575, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var body582 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 71, "containing_panel": this, "name": "body", "title": "Body" });
    var main_panel583 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel566, main_2_panel576, body582 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel583;
    this.before_row_edit = function(record) {
      body582.refresh();
    }
    Lino.blogs.Entries.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Accounts.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 33,
  initComponent : function() {
    var containing_panel = this;
    var ref1013 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "ref", "name": "ref", "maxLength": 20, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ref","(accounts.Accounts.ref) ") }, "anchor": "-20" });
    var name1014 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(accounts.Accounts.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1015 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(accounts.Accounts.name_de) ") }, "anchor": "-20" });
    var name_fr1016 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(accounts.Accounts.name_fr) ") }, "anchor": "-20" });
    var main_1_panel1017 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref1013, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1014, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1015, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1016, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var group1022 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Account Group", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.accounts.Groups.detail,Lino.accounts.Groups.insert)}, "emptyText": "Select a Account Group...", "listeners": { "render": Lino.quicktip_renderer("Account Group","(accounts.Accounts.group) ") }, "selectOnFocus": true, "hiddenName": "groupHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Accounts/group", "method": "GET" }) }), "name": "group" });
    var type1023 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Account Type", "allowBlank": false, "hiddenName": "typeHidden", "listeners": { "render": Lino.quicktip_renderer("Account Type","(accounts.Accounts.type) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.accounts.AccountTypes, "name": "type" });
    var main_2_panel1024 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 55, "autoHeight": true, "layout": "form", "xtype": "panel", "items": group1022, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type1023, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel1027 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel1017, main_2_panel1024 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1027;
    this.before_row_edit = function(record) {
    }
    Lino.accounts.Accounts.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Calendars.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 65,
  initComponent : function() {
    var containing_panel = this;
    var name1579 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(cal.Calendars.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1580 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(cal.Calendars.name_de) ") }, "anchor": "-20" });
    var name_fr1581 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(cal.Calendars.name_fr) ") }, "anchor": "-20" });
    var main_1_panel1582 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1579, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1580, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1581, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var color1586 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "color", "name": "color", "value": 1, "listeners": { "render": Lino.quicktip_renderer("color","(cal.Calendars.color) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var main_panel1587 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 54, "autoScroll": false, "items": [ main_1_panel1582, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": color1586, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1587;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Calendars.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.households.Types.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 30,
  initComponent : function() {
    var containing_panel = this;
    var name851 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(households.Types.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de852 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(households.Types.name_de) ") }, "anchor": "-20" });
    var name_fr853 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(households.Types.name_fr) ") }, "anchor": "-20" });
    var main_1_panel854 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name851, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de852, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr853, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var HouseholdsByType_grid951 = new Lino.households.HouseholdsByType.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Households","(households.households.HouseholdsByType) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.households.HouseholdsByType.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel952 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel854, HouseholdsByType_grid951 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel952;
    this.before_row_edit = function(record) {
      HouseholdsByType_grid951.on_master_changed();
    }
    Lino.households.Types.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.Mails.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 68,
  initComponent : function() {
    var containing_panel = this;
    var subject1491 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Subject", "name": "subject", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Subject","(outbox.Mails.subject) ") }, "anchor": "-20" });
    var project1492 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail,Lino.tickets.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(outbox.Mails.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var date1493 = new Lino.DateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Date</span>", "name": "date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date","(outbox.Mails.date) \n        The official date to be printed on the document.\n        ") }, "anchor": "-20" });
    var main_1_panel1494 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject1491, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project1492, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date1493, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user1498 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Sender", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Sender","(outbox.Mails.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/user", "method": "GET" }) }) });
    var sent1499 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "sent", "name": "sent", "listeners": { "render": Lino.quicktip_renderer("sent","(outbox.Mails.sent) ") }, "value": "<br>", "anchor": "-20" });
    var id1500 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(outbox.Mails.id) ") }, "anchor": "-20" });
    var owner_disp1501 = new Ext.form.DisplayField({ "disabled": true, "autoHeight": true, "fieldLabel": "Controlled by", "anchor": "-20", "name": "owner" });
    var main_2_panel1502 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 126, "hideCheckBoxLabels": true, "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user1498, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent1499, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1500, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp1501, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var RecipientsByMail_grid1513 = new Lino.outbox.RecipientsByMail.GridPanel({ "flex": 55, "listeners": { "render": Lino.quicktip_renderer("Recipients","(outbox.outbox.RecipientsByMail) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.outbox.RecipientsByMail.grid) ], "preview_limit": 15, "master_panel": this });
    var AttachmentsByMail_htmlbox1514 = new Lino.HtmlBoxPanel({ "flex": 22, "layout": "fit", "name": "AttachmentsByMail", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Attachments", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Attachments","(outbox.Mails.AttachmentsByMail) ") }, "bodyStyle": "overflow-x:hidden;", "tools": [ Lino.show_in_own_window_button(Lino.outbox.AttachmentsByMail.grid) ] });
    var UploadsByController_htmlbox1515 = new Lino.HtmlBoxPanel({ "flex": 22, "ls_bbar_actions": [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "listeners": { "render": Lino.quicktip_renderer("Uploads","(outbox.Mails.UploadsByController) ") }, "bodyStyle": "overflow-x:hidden;", "ls_insert_handler": Lino.uploads.UploadsByController.insert, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.grid) ] });
    var main_3_panel1516 = new Ext.Panel({ "flex": 29, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ RecipientsByMail_grid1513, AttachmentsByMail_htmlbox1514, UploadsByController_htmlbox1515 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var body1517 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 58, "containing_panel": this, "name": "body", "title": "Body" });
    var main_panel1518 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel1494, main_2_panel1502, main_3_panel1516, body1517 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1518;
    this.before_row_edit = function(record) {
      RecipientsByMail_grid1513.on_master_changed();
      AttachmentsByMail_htmlbox1514.refresh();
      UploadsByController_htmlbox1515.refresh();
      body1517.refresh();
    }
    Lino.outbox.Mails.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.system.TextFieldTemplates.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 10,
  initComponent : function() {
    var containing_panel = this;
    var name193 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(system.TextFieldTemplates.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user194 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(system.TextFieldTemplates.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/user", "method": "GET" }) }) });
    var team195 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Team</span>", "name": "team", "pageSize": 20, "emptyText": "Select a Team...", "listeners": { "render": Lino.quicktip_renderer("Team","(system.TextFieldTemplates.team) If not empty, then this template is reserved to members of this team.") }, "selectOnFocus": true, "hiddenName": "teamHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/team", "method": "GET" }) }) });
    var main_2_panel196 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user194, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": team195, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel199 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 108, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name193, "anchor": "-20", "labelAlign": "top" }, main_2_panel196 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel199;
    this.before_row_edit = function(record) {
    }
    Lino.system.TextFieldTemplates.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.EventTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 60,
  initComponent : function() {
    var containing_panel = this;
    var name1618 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation", "name": "name", "listeners": { "render": Lino.quicktip_renderer("Designation","(cal.EventTypes.name) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de1619 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (de)", "name": "name_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (de)","(cal.EventTypes.name_de) ") }, "anchor": "-20" });
    var name_fr1620 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Designation (fr)", "name": "name_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Designation (fr)","(cal.EventTypes.name_fr) ") }, "anchor": "-20" });
    var main_1_panel1621 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name1618, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de1619, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr1620, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var event_label1625 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Event label", "name": "event_label", "value": "Appointment", "listeners": { "render": Lino.quicktip_renderer("Event label","(cal.EventTypes.event_label) ") }, "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var event_label_de1626 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Event label (de)", "name": "event_label_de", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Event label (de)","(cal.EventTypes.event_label_de) ") }, "anchor": "-20" });
    var event_label_fr1627 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Event label (fr)", "name": "event_label_fr", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Event label (fr)","(cal.EventTypes.event_label_fr) ") }, "anchor": "-20" });
    var main_2_panel1628 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label1625, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label_de1626, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": event_label_fr1627, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var start_date1632 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Start date", "name": "start_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start date","(cal.EventTypes.start_date) ") }, "anchor": "-20" });
    var id1633 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(cal.EventTypes.id) ") }, "anchor": "-20" });
    var main_3_panel1634 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 72, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date1632, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id1633, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var build_method1637 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Build method", "name": "build_method", "hiddenName": "build_methodHidden", "listeners": { "render": Lino.quicktip_renderer("Build method","(cal.EventTypes.build_method) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template1638 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Template", "name": "template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Template","(cal.EventTypes.template) ") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventTypes/template", "method": "GET" }) }), "anchor": "-20" });
    var email_template1639 = new Lino.SimpleRemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Email template</span>", "name": "email_template", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Email template","(cal.EventTypes.email_template) The name of the file to be used as \ntemplate when creating an email from a mailable of this type.") }, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventTypes/email_template", "method": "GET" }) }), "anchor": "-20" });
    var attach_to_email1640 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "attach_to_email", "listeners": { "render": Lino.quicktip_renderer("Attach to email","(cal.EventTypes.attach_to_email) Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "boxLabel": "Attach to email", "selectOnFocus": true, "anchor": "-20" });
    var main_4_panel1641 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 144, "hideCheckBoxLabels": true, "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method1637, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template1638, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template1639, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email1640, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var is_appointment1646 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": true, "name": "is_appointment", "listeners": { "render": Lino.quicktip_renderer("Event is an appointment","(cal.EventTypes.is_appointment) ") }, "boxLabel": "Event is an appointment", "selectOnFocus": true, "anchor": "-20" });
    var all_rooms1647 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "all_rooms", "listeners": { "render": Lino.quicktip_renderer("Locks all rooms","(cal.EventTypes.all_rooms) ") }, "boxLabel": "Locks all rooms", "selectOnFocus": true, "anchor": "-20" });
    var locks_user1648 = new Ext.form.Checkbox({ "autoHeight": true, "hideLabel": true, "checked": false, "name": "locks_user", "listeners": { "render": Lino.quicktip_renderer("Locks the user","(cal.EventTypes.locks_user) Lino won't not accept more than one locking event per user at the same time.") }, "boxLabel": "Locks the user", "selectOnFocus": true, "anchor": "-20" });
    var main_5_panel1649 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_appointment1646, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": all_rooms1647, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": locks_user1648, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var EventsByType_grid1678 = new Lino.cal.EventsByType.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "params_panel_hidden": true, "master_panel": this, "preview_limit": 15, "listeners": { "render": Lino.quicktip_renderer("Events","(cal.cal.EventsByType) ") }, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByType.grid) ] });
    var main_panel1679 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel1621, main_2_panel1628, main_3_panel1634, main_4_panel1641, main_5_panel1649, EventsByType_grid1678 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel1679;
    this.before_row_edit = function(record) {
      template1638.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      EventsByType_grid1678.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method1637.on('change',Lino.chooser_handler(template1638,'build_method'));
      Lino.cal.EventTypes.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.cal.EventTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 57,
  initComponent : function() {
    var containing_panel = this;
    var summary110 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Summary", "name": "summary", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Summary","(cal.Tasks.summary) ") }, "anchor": "-20" });
    var user111 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(cal.Tasks.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var project112 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail,Lino.tickets.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(cal.Tasks.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_2_panel113 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user111, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project112, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel116 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary110, "anchor": "-20", "labelAlign": "top" }, main_2_panel113 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel116;
    this.before_row_edit = function(record) {
    }
    Lino.cal.Tasks.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.Sessions.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 52,
  initComponent : function() {
    var containing_panel = this;
    var date530 = new Lino.DateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date","(tickets.Sessions.date) ") }, "anchor": "-20" });
    var start_time531 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "Start time", "name": "start_time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Start time","(tickets.Sessions.start_time) ") }, "anchor": "-20" });
    var end_time532 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "End Time", "name": "end_time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("End Time","(tickets.Sessions.end_time) ") }, "anchor": "-20" });
    var break_time533 = new Lino.TimeField({ "autoHeight": true, "fieldLabel": "Break Time", "name": "break_time", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Break Time","(tickets.Sessions.break_time) ") }, "anchor": "-20" });
    var project534 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail,Lino.tickets.Projects.insert)}, "emptyText": "Select a Project...", "listeners": { "render": Lino.quicktip_renderer("Project","(tickets.Sessions.project) ") }, "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Sessions/project", "method": "GET" }) }) });
    var ticket535 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Ticket", "name": "ticket", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Tickets.detail,Lino.tickets.Tickets.insert)}, "emptyText": "Select a Ticket...", "listeners": { "render": Lino.quicktip_renderer("Ticket","(tickets.Sessions.ticket) ") }, "selectOnFocus": true, "hiddenName": "ticketHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Sessions/ticket", "method": "GET" }) }) });
    var main_1_panel536 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date530, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time531, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time532, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": break_time533, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project534, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ticket535, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var user543 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(tickets.Sessions.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Sessions/user", "method": "GET" }) }) });
    var id544 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(tickets.Sessions.id) ") }, "anchor": "-20" });
    var main_2_panel545 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 63, "hideCheckBoxLabels": true, "items": [ { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user543, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id544, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description548 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Description","(tickets.Sessions.description) ") }, "fieldLabel": "Description", "name": "description", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var EntriesBySession_grid584 = new Lino.tickets.EntriesBySession.GridPanel({ "flex": 41, "listeners": { "render": Lino.quicktip_renderer("Blog Entries","(tickets.tickets.EntriesBySession) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.tickets.EntriesBySession.grid) ], "preview_limit": 15, "master_panel": this });
    var main_panel585 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ main_1_panel536, main_2_panel545, { "items": description548, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 41 }, EntriesBySession_grid584 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel585;
    this.before_row_edit = function(record) {
      EntriesBySession_grid584.on_master_changed();
    }
    Lino.tickets.Sessions.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.sales.Invoices.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 44,
  initComponent : function() {
    var containing_panel = this;
    var date380 = new Lino.DateField({ "autoHeight": true, "allowBlank": false, "fieldLabel": "Date", "name": "date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date","(sales.Invoices.date) ") }, "anchor": "-20" });
    var partner381 = new Lino.TwinCombo({ "preferred_width": 20, "autoHeight": true, "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.Partners.detail,Lino.contacts.Partners.insert)}, "emptyText": "Select a Partner...", "listeners": { "render": Lino.quicktip_renderer("Partner","(sales.Invoices.partner) ") }, "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/partner", "method": "GET" }) }), "name": "partner" });
    var vat_regime382 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "VAT Regime", "allowBlank": false, "hiddenName": "vat_regimeHidden", "listeners": { "render": Lino.quicktip_renderer("VAT Regime","(sales.Invoices.vat_regime) ") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.vat.VatRegimes, "name": "vat_regime" });
    var invoice_header_1_panel383 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date380, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner381, "labelAlign": "top" }, { "flex": 35, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_regime382, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var subject387 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Subject line", "name": "subject", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Subject line","(sales.Invoices.subject) ") }, "anchor": "-20" });
    var your_ref388 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Your reference", "name": "your_ref", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Your reference","(sales.Invoices.your_ref) ") }, "anchor": "-20" });
    var invoice_header_2_panel389 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject387, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": your_ref388, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var payment_term392 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Payment Term", "name": "payment_term", "pageSize": 20, "emptyText": "Select a Payment Term...", "listeners": { "render": Lino.quicktip_renderer("Payment Term","(sales.Invoices.payment_term) ") }, "selectOnFocus": true, "hiddenName": "payment_termHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/payment_term", "method": "GET" }) }) });
    var due_date393 = new Lino.DateField({ "autoHeight": true, "fieldLabel": "Date of payment", "name": "due_date", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Date of payment","(sales.Invoices.due_date) ") }, "anchor": "-20" });
    var invoice_header_3_panel394 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": payment_term392, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": due_date393, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 144, "border": false, "anchor": "-20", "labelAlign": "top" });
    var imode397 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Invoicing Mode", "name": "imode", "pageSize": 20, "emptyText": "Select a Invoicing Mode...", "listeners": { "render": Lino.quicktip_renderer("Invoicing Mode","(sales.Invoices.imode) ") }, "selectOnFocus": true, "hiddenName": "imodeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/imode", "method": "GET" }) }) });
    var shipping_mode398 = new Lino.RemoteComboFieldElement({ "autoHeight": true, "fieldLabel": "Shipping Mode", "name": "shipping_mode", "pageSize": 20, "emptyText": "Select a Shipping Mode...", "listeners": { "render": Lino.quicktip_renderer("Shipping Mode","(sales.Invoices.shipping_mode) ") }, "selectOnFocus": true, "hiddenName": "shipping_modeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/shipping_mode", "method": "GET" }) }) });
    var invoice_header_4_panel399 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": imode397, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": shipping_mode398, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var invoice_header_panel402 = new Ext.form.FieldSet({ "flex": 75, "autoHeight": true, "layout": "form", "title": "Header", "items": [ invoice_header_1_panel383, invoice_header_2_panel389, invoice_header_3_panel394, invoice_header_4_panel399 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var total_base403 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "Total excl. VAT", "name": "total_base", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Total excl. VAT","(sales.Invoices.total_base) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var total_vat404 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "VAT", "name": "total_vat", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("VAT","(sales.Invoices.total_vat) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var total_incl405 = new Ext.form.NumberField({ "autoHeight": true, "decimalPrecision": 2, "fieldLabel": "Total incl. VAT", "name": "total_incl", "decimalSeparator": ",", "listeners": { "render": Lino.quicktip_renderer("Total incl. VAT","(sales.Invoices.total_incl) ") }, "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var workflow_buttons_disp406 = new Ext.form.DisplayField({ "autoHeight": true, "fieldLabel": "Workflow", "name": "workflow_buttons", "value": "<br/>", "always_enabled": true, "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Workflow","(sales.Invoices.workflow_buttons) ") }, "anchor": "-20" });
    var totals_panel407 = new Ext.form.FieldSet({ "flex": 25, "autoHeight": true, "layout": "form", "title": "Totals", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_base403, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_vat404, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_incl405, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp406, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 144, "border": false, "labelAlign": "top" });
    var general_1_panel412 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ invoice_header_panel402, totals_panel407 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ItemsByInvoice_grid424 = new Lino.sales.ItemsByInvoice.GridPanel({ "flex": 45, "listeners": { "render": Lino.quicktip_renderer("Voucher items","(sales.sales.ItemsByInvoice) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.sales.ItemsByInvoice.grid) ], "preview_limit": 15, "master_panel": this });
    var general_panel425 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel412, ItemsByInvoice_grid424 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var id426 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "ID", "name": "id", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("ID","(sales.Invoices.id) ") }, "anchor": "-20" });
    var user427 = new Lino.TwinCombo({ "preferred_width": 15, "autoHeight": true, "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail,Lino.users.Users.insert)}, "hiddenName": "userHidden", "listeners": { "render": Lino.quicktip_renderer("Author","(sales.Invoices.user) ") }, "selectOnFocus": true, "emptyText": "Select a User...", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/user", "method": "GET" }) }) });
    var language428 = new Lino.ChoicesFieldElement({ "autoHeight": true, "fieldLabel": "Language", "allowBlank": false, "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","(sales.Invoices.language) ") }, "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var more_1_panel429 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 81, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id426, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user427, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language428, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var intro433 = new Ext.form.TextArea({ "listeners": { "render": Lino.quicktip_renderer("Introductive Text","(sales.Invoices.intro) ") }, "fieldLabel": "Introductive Text", "name": "intro", "growMax": 2000, "selectOnFocus": true, "anchor": "-20 -10" });
    var more_panel434 = new Ext.Panel({ "layout": "vbox", "title": "More", "items": [ more_1_panel429, { "items": intro433, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "labelWidth": 162, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var journal436 = new Lino.TwinCombo({ "autoHeight": true, "fieldLabel": "Journal", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail,Lino.ledger.Journals.insert)}, "emptyText": "Select a Journal...", "listeners": { "render": Lino.quicktip_renderer("Journal","(sales.Invoices.journal) ") }, "selectOnFocus": true, "hiddenName": "journalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/journal", "method": "GET" }) }), "name": "journal" });
    var year437 = new Lino.ChoicesFieldElement({ "autoHeight": true, "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "year", "hiddenName": "yearHidden", "listeners": { "render": Lino.quicktip_renderer("Fiscal Year","(sales.Invoices.year) ") }, "selectOnFocus": true, "anchor": "-20", "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var number438 = new Ext.form.NumberField({ "autoHeight": true, "fieldLabel": "number", "name": "number", "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("number","(sales.Invoices.number) ") }, "anchor": "-20" });
    var narration439 = new Ext.form.TextField({ "autoHeight": true, "fieldLabel": "Narration", "name": "narration", "maxLength": 200, "selectOnFocus": true, "listeners": { "render": Lino.quicktip_renderer("Narration","(sales.Invoices.narration) ") }, "anchor": "-20" });
    var ledger_1_panel440 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": journal436, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": year437, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": number438, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": narration439, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ledger_MovementsByVoucher_grid469 = new Lino.ledger.MovementsByVoucher.GridPanel({ "flex": 83, "listeners": { "render": Lino.quicktip_renderer("Movements","(ledger.ledger.MovementsByVoucher) ") }, "hide_top_toolbar": true, "containing_panel": this, "tools": [ Lino.show_in_own_window_button(Lino.ledger.MovementsByVoucher.grid) ], "preview_limit": 15, "master_panel": this });
    var ledger_panel470 = new Ext.Panel({ "layout": "vbox", "title": "Ledger", "items": [ ledger_1_panel440, ledger_MovementsByVoucher_grid469 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel471 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel425, more_panel434, ledger_panel470 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel471;
    this.before_row_edit = function(record) {
      ItemsByInvoice_grid424.on_master_changed();
      ledger_MovementsByVoucher_grid469.on_master_changed();
    }
    Lino.sales.Invoices.DetailFormPanel.superclass.initComponent.call(this);
  }
});


// js_render_GridPanel_class system.SiteConfigs
Lino.system.SiteConfigs.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/system/SiteConfigs",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/system/SiteConfigs','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/SiteConfigs','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/SiteConfigs','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": "do_build", "menu_item_text": "Rebuild site cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('do_build','GET',null), "text": "Rebuild site cache", "overflowText": "Rebuild site cache", "auto_save": true } ],
  cell_edit : true,
  title : "site configs",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 25,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "default_build_method" }, 'default_build_methodHidden', { "type": "int", "name": "next_partner_id" }, { "name": "site_company" }, 'site_companyHidden', { "name": "default_event_type" }, 'default_event_typeHidden', { "name": "site_calendar" }, 'site_calendarHidden', { "type": "int", "name": "max_auto_events" }, { "type": "date", "name": "farest_future", "dateFormat": "d.m.Y" }, { "name": "clients_account" }, 'clients_accountHidden', { "name": "sales_vat_account" }, 'sales_vat_accountHidden', { "name": "sales_account" }, 'sales_accountHidden', { "name": "suppliers_account" }, 'suppliers_accountHidden', { "name": "purchases_vat_account" }, 'purchases_vat_accountHidden', { "name": "purchases_account" }, 'purchases_accountHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 8,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.system.SiteConfigs.detail;
    var ww = this.containing_window;
    var id1847 = new Ext.form.NumberField({ "selectOnFocus": true });
    var default_build_method1848 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "value": "appyodt" });
    var next_partner_id1849 = new Ext.form.NumberField({ "selectOnFocus": true, "value": 100 });
    var site_company1850 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/site_company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Company..." });
    var default_event_type1851 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/default_event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Event Type..." });
    var site_calendar1852 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/site_calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    var max_auto_events1853 = new Ext.form.NumberField({ "selectOnFocus": true, "value": 72 });
    var farest_future1854 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "value": "07.12.2018" });
    var clients_account1855 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/clients_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var sales_vat_account1856 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/sales_vat_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var sales_account1857 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/sales_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var suppliers_account1858 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/suppliers_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var purchases_vat_account1859 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/purchases_vat_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var purchases_account1860 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/SiteConfigs/purchases_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.SiteConfigs.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1847, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Default build method", "editable": true, "tooltip": "(system.SiteConfigs.default_build_method) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "default_build_method", "editor": default_build_method1848 }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.SiteConfigs.next_partner_id) The next automatic id for any new partner.", "filter": { "type": "numeric" }, "header": "Next partner id", "dataIndex": "next_partner_id", "width": Lino.chars2width(6), "editor": next_partner_id1849 }), { "colIndex": 3, "sortable": true, "header": "The company that runs this site", "editable": true, "tooltip": "(system.SiteConfigs.site_company) The Company to be used as sender in documents.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('site_companyHidden','Lino.contacts.Companies.detail'), "editor": site_company1850, "dataIndex": "site_company" }, { "colIndex": 4, "sortable": true, "header": "Default Event Type", "editable": true, "tooltip": "(system.SiteConfigs.default_event_type) The default type of events on this site.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('default_event_typeHidden','Lino.cal.EventTypes.detail'), "editor": default_event_type1851, "dataIndex": "default_event_type" }, { "colIndex": 5, "sortable": true, "header": "Site Calendar", "editable": true, "tooltip": "(system.SiteConfigs.site_calendar) The default calendar of this site.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('site_calendarHidden','Lino.cal.Calendars.detail'), "editor": site_calendar1852, "dataIndex": "site_calendar" }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.SiteConfigs.max_auto_events) Maximum number of automatic events to be generated.", "filter": { "type": "numeric" }, "header": "Max automatic events", "dataIndex": "max_auto_events", "width": Lino.chars2width(6), "editor": max_auto_events1853 }), { "colIndex": 7, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(system.SiteConfigs.farest_future) Don't generate automatic events past that date.", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Farest future", "dataIndex": "farest_future", "width": Lino.chars2width(14), "editor": farest_future1854 }, { "colIndex": 8, "sortable": true, "header": "Clients account", "editable": true, "tooltip": "(system.SiteConfigs.clients_account) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('clients_accountHidden','Lino.accounts.Accounts.detail'), "editor": clients_account1855, "dataIndex": "clients_account" }, { "colIndex": 9, "sortable": true, "header": "Sales VAT account", "editable": true, "tooltip": "(system.SiteConfigs.sales_vat_account) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('sales_vat_accountHidden','Lino.accounts.Accounts.detail'), "editor": sales_vat_account1856, "dataIndex": "sales_vat_account" }, { "colIndex": 10, "sortable": true, "header": "Sales Base account", "editable": true, "tooltip": "(system.SiteConfigs.sales_account) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('sales_accountHidden','Lino.accounts.Accounts.detail'), "editor": sales_account1857, "dataIndex": "sales_account" }, { "colIndex": 11, "sortable": true, "header": "Suppliers account", "editable": true, "tooltip": "(system.SiteConfigs.suppliers_account) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('suppliers_accountHidden','Lino.accounts.Accounts.detail'), "editor": suppliers_account1858, "dataIndex": "suppliers_account" }, { "colIndex": 12, "sortable": true, "header": "Purchases VAT account", "editable": true, "tooltip": "(system.SiteConfigs.purchases_vat_account) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('purchases_vat_accountHidden','Lino.accounts.Accounts.detail'), "editor": purchases_vat_account1859, "dataIndex": "purchases_vat_account" }, { "colIndex": 13, "sortable": true, "header": "Purchases Base account", "editable": true, "tooltip": "(system.SiteConfigs.purchases_account) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('purchases_accountHidden','Lino.accounts.Accounts.detail'), "editor": purchases_account1860, "dataIndex": "purchases_account" } ];
    Lino.system.SiteConfigs.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.system.SiteConfigs.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/SiteConfigs","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.system.SiteConfigs.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/SiteConfigs","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.system.SiteConfigs.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/SiteConfigs","GET",pk,"put",null);
};
Lino.system.SiteConfigs.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/SiteConfigs","GET",pk,"post",null);
};

Lino.system.SiteConfigs.detailPanel = Ext.extend(Lino.system.SiteConfigs.DetailFormPanel,{
  empty_title: "Detail site configs",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "do_build", "menu_item_text": "Rebuild site cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('do_build','GET',null), "text": "Rebuild site cache", "overflowText": "Rebuild site cache", "auto_save": true } ],
  ls_url: "/system/SiteConfigs",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.SiteConfigs.detail;
    Lino.system.SiteConfigs.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.system.SiteConfigs.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.system.SiteConfigs.detailPanel(p);
});
Lino.system.SiteConfigs.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.system.SiteConfigs.GridPanel(p);
});
Lino.system.SiteConfigs.do_build = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/SiteConfigs","GET",pk,"do_build",null);
};

// js_render_GridPanel_class system.ContentTypes
Lino.system.ContentTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/system/ContentTypes",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/system/ContentTypes','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/ContentTypes','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/ContentTypes','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "content types",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 5,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "app_label" }, { "name": "model" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 3,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.system.ContentTypes.detail;
    this.ls_insert_handler = Lino.system.ContentTypes.insert;
    var ww = this.containing_window;
    var id1862 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1863 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var app_label1864 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var model1865 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.ContentTypes.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1862, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "name", "editable": true, "tooltip": "(system.ContentTypes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1863 }, { "colIndex": 2, "sortable": true, "header": "app label", "editable": true, "tooltip": "(system.ContentTypes.app_label) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "app_label", "editor": app_label1864 }, { "colIndex": 3, "sortable": true, "header": "python model class name", "editable": true, "tooltip": "(system.ContentTypes.model) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "model", "editor": model1865 } ];
    Lino.system.ContentTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.system.ContentTypes.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/ContentTypes","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.system.ContentTypes.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/ContentTypes","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.system.ContentTypes.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/ContentTypes","GET",pk,"put",null);
};
Lino.system.ContentTypes.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/ContentTypes","GET",pk,"post",null);
};

Lino.system.ContentTypes.insertPanel = Ext.extend(Lino.system.ContentTypes.DetailFormPanel,{
  empty_title: "New content types",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/system/ContentTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.ContentTypes.detail;
    this.ls_insert_handler = Lino.system.ContentTypes.insert;
    Lino.system.ContentTypes.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.system.ContentTypes.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.system.ContentTypes.insertPanel(p);
});
Lino.system.ContentTypes.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/ContentTypes","GET",pk,"poststay",null);
};

Lino.system.ContentTypes.detailPanel = Ext.extend(Lino.system.ContentTypes.DetailFormPanel,{
  empty_title: "Detail content types",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/system/ContentTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.ContentTypes.detail;
    this.ls_insert_handler = Lino.system.ContentTypes.insert;
    Lino.system.ContentTypes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.system.ContentTypes.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.system.ContentTypes.detailPanel(p);
});
Lino.system.ContentTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.system.ContentTypes.GridPanel(p);
});

// js_render_GridPanel_class system.HelpTexts
Lino.system.HelpTexts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/system/HelpTexts",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/system/HelpTexts','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/HelpTexts','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/HelpTexts','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Help Texts",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "name": "field" }, { "name": "verbose_name" }, { "name": "help_text" }, { "type": "int", "name": "id" }, { "name": "content_type" }, 'content_typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 9,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var field1867 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/HelpTexts/field", "method": "GET" }) }) });
    var verbose_name1868 = new Ext.form.TextField({ "disabled": true, "maxLength": 200 });
    var help_text1869 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var id1870 = new Ext.form.NumberField({ "selectOnFocus": true });
    var content_type1871 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/HelpTexts/content_type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a content type..." });
    this.before_row_edit = function(record) {
      field1867.setContextValue('content_type',record ? record.data['content_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      content_type1871.on('change',Lino.chooser_handler(field1867,'content_type'));
      Lino.system.HelpTexts.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Field", "editable": true, "tooltip": "(system.HelpTexts.field) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "field", "editor": field1867 }, { "width": Lino.chars2width(22), "colIndex": 1, "sortable": false, "dataIndex": "verbose_name", "header": "Verbose name", "editable": false, "tooltip": "(system.HelpTexts.verbose_name) " }, { "colIndex": 2, "sortable": false, "header": "HelpText", "editable": true, "tooltip": "(system.HelpTexts.help_text) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": help_text1869, "dataIndex": "help_text" }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.HelpTexts.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1870, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Model", "editable": true, "tooltip": "(system.HelpTexts.content_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('content_typeHidden','Lino.system.ContentTypes.detail'), "editor": content_type1871, "dataIndex": "content_type" } ];
    Lino.system.HelpTexts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.system.HelpTexts.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/HelpTexts","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.system.HelpTexts.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/HelpTexts","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.system.HelpTexts.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/HelpTexts","GET",pk,"put",null);
};
Lino.system.HelpTexts.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/HelpTexts","GET",pk,"post",null);
};
Lino.system.HelpTexts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.system.HelpTexts.GridPanel(p);
});

// js_render_GridPanel_class system.TextFieldTemplates
Lino.system.TextFieldTemplates.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/system/TextFieldTemplates",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/system/TextFieldTemplates','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/TextFieldTemplates','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/system/TextFieldTemplates','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Text Field Templates",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "name" }, { "name": "team" }, 'teamHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 10,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.system.TextFieldTemplates.detail;
    this.ls_insert_handler = Lino.system.TextFieldTemplates.insert;
    var ww = this.containing_window;
    var id1873 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1874 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var name1875 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var team1876 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/system/TextFieldTemplates/team", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Team..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(system.TextFieldTemplates.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1873, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Author", "editable": true, "tooltip": "(system.TextFieldTemplates.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1874, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(system.TextFieldTemplates.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1875 }, { "colIndex": 3, "sortable": true, "header": "Team", "editable": true, "tooltip": "(system.TextFieldTemplates.team) If not empty, then this template is reserved to members of this team.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "team", "editor": team1876 } ];
    Lino.system.TextFieldTemplates.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.system.TextFieldTemplates.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/TextFieldTemplates","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.system.TextFieldTemplates.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/TextFieldTemplates","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.system.TextFieldTemplates.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/TextFieldTemplates","GET",pk,"put",null);
};
Lino.system.TextFieldTemplates.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/TextFieldTemplates","GET",pk,"post",null);
};

Lino.system.TextFieldTemplates.insertPanel = Ext.extend(Lino.system.TextFieldTemplates.InsertFormPanel,{
  empty_title: "New Text Field Templates",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/system/TextFieldTemplates",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.TextFieldTemplates.detail;
    this.ls_insert_handler = Lino.system.TextFieldTemplates.insert;
    Lino.system.TextFieldTemplates.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.system.TextFieldTemplates.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.system.TextFieldTemplates.insertPanel(p);
});
Lino.system.TextFieldTemplates.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/system/TextFieldTemplates","GET",pk,"poststay",null);
};

Lino.system.TextFieldTemplates.detailPanel = Ext.extend(Lino.system.TextFieldTemplates.DetailFormPanel,{
  empty_title: "Detail Text Field Templates",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/system/TextFieldTemplates",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.system.TextFieldTemplates.detail;
    this.ls_insert_handler = Lino.system.TextFieldTemplates.insert;
    Lino.system.TextFieldTemplates.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.system.TextFieldTemplates.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.system.TextFieldTemplates.detailPanel(p);
});
Lino.system.TextFieldTemplates.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.system.TextFieldTemplates.GridPanel(p);
});

// js_render_GridPanel_class users.Users
Lino.users.Users.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/Users",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/users/Users','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Users','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Users','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "must_save": true, "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true } ],
  cell_edit : true,
  title : "Users",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 21,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "first_name" }, { "name": "last_name" }, { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "password" }, { "name": "initials" }, { "name": "email" }, { "name": "remarks" }, { "name": "language" }, 'languageHidden', { "name": "partner" }, 'partnerHidden', { "name": "access_class" }, 'access_classHidden', { "name": "event_type" }, 'event_typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 12,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    var ww = this.containing_window;
    var username1878 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile1879 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var first_name1880 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var last_name1881 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var id1882 = new Ext.form.NumberField({ "selectOnFocus": true });
    var created1883 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified1884 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var password1885 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 128 });
    var initials1886 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var email1887 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var remarks1888 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var language1889 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ] });
    var partner1890 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var access_class1891 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.AccessClasses });
    var event_type1892 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Event Type..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Username", "editable": true, "tooltip": "(users.Users.username) Required. Must be unique.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "username", "editor": username1878 }, { "colIndex": 1, "sortable": true, "header": "User Profile", "editable": true, "tooltip": "(users.Users.profile) Users with an empty `profile` field are considered inactive and cannot log in.", "filter": { "type": "string" }, "width": Lino.chars2width(23), "dataIndex": "profile", "editor": profile1879 }, { "colIndex": 2, "sortable": true, "header": "First name", "editable": true, "tooltip": "(users.Users.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name1880 }, { "colIndex": 3, "sortable": true, "header": "Last name", "editable": true, "tooltip": "(users.Users.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name1881 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.Users.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "hidden": true, "editor": id1882, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Created", "editable": false, "tooltip": "(users.Users.created) ", "width": Lino.chars2width(17), "dataIndex": "created", "hidden": true }, { "colIndex": 6, "sortable": true, "header": "Modified", "editable": false, "tooltip": "(users.Users.modified) ", "width": Lino.chars2width(17), "dataIndex": "modified", "hidden": true }, { "colIndex": 7, "sortable": true, "header": "Password", "editable": true, "tooltip": "(users.Users.password) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "password", "hidden": true, "editor": password1885 }, { "colIndex": 8, "sortable": true, "header": "Initials", "editable": true, "tooltip": "(users.Users.initials) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "initials", "hidden": true, "editor": initials1886 }, { "colIndex": 9, "sortable": true, "header": "e-mail address", "editable": true, "tooltip": "(users.Users.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "hidden": true, "editor": email1887 }, { "colIndex": 10, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(users.Users.remarks) ", "filter": { "type": "string" }, "header": "Remarks", "renderer": Lino.text_renderer, "hidden": true, "editor": remarks1888, "dataIndex": "remarks" }, { "colIndex": 11, "sortable": true, "header": "Language", "editable": true, "tooltip": "(users.Users.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "hidden": true, "editor": language1889 }, { "colIndex": 12, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(users.Users.partner) ", "filter": { "type": "string" }, "header": "Partner", "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "hidden": true, "editor": partner1890, "dataIndex": "partner" }, { "colIndex": 13, "sortable": true, "header": "Default access class", "editable": true, "tooltip": "(users.Users.access_class) The default access class for your calendar events and tasks.", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "access_class", "hidden": true, "editor": access_class1891 }, { "colIndex": 14, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(users.Users.event_type) The default event type for your calendar events.", "filter": { "type": "string" }, "header": "Default Event Type", "renderer": Lino.fk_renderer('event_typeHidden','Lino.cal.EventTypes.detail'), "hidden": true, "editor": event_type1892, "dataIndex": "event_type" } ];
    Lino.users.Users.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Users.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Users","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.users.Users.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Users","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.users.Users.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Users","GET",pk,"put",null);
};
Lino.users.Users.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Users","GET",pk,"post",null);
};

Lino.users.Users.insertPanel = Ext.extend(Lino.users.Users.InsertFormPanel,{
  empty_title: "New Users",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/users/Users",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.Users.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Users.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.Users.insertPanel(p);
});
Lino.users.Users.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Users","GET",pk,"poststay",null);
};

Lino.users.Users.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Detail Users",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "must_save": true, "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true } ],
  ls_url: "/users/Users",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.Users.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Users.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Users.detailPanel(p);
});
Lino.users.Users.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Users.GridPanel(p);
});
Lino.users.Users.update_reminders = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Users","GET",pk,"update_reminders",null);
};

// js_render_GridPanel_class users.MySettings
Lino.users.MySettings.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/MySettings",
  ls_bbar_actions : [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "must_save": true, "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true } ],
  cell_edit : true,
  title : "Users",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 21,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "first_name" }, { "name": "last_name" }, { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "password" }, { "name": "initials" }, { "name": "email" }, { "name": "remarks" }, { "name": "language" }, 'languageHidden', { "name": "partner" }, 'partnerHidden', { "name": "access_class" }, 'access_classHidden', { "name": "event_type" }, 'event_typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 12,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    var ww = this.containing_window;
    var username1894 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile1895 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var first_name1896 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var last_name1897 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var id1898 = new Ext.form.NumberField({ "selectOnFocus": true });
    var created1899 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified1900 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var password1901 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 128 });
    var initials1902 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var email1903 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var remarks1904 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var language1905 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ] });
    var partner1906 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var access_class1907 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.cal.AccessClasses });
    var event_type1908 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MySettings/event_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Event Type..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Username", "editable": true, "tooltip": "(users.MySettings.username) Required. Must be unique.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "username", "editor": username1894 }, { "colIndex": 1, "sortable": true, "header": "User Profile", "editable": true, "tooltip": "(users.MySettings.profile) Users with an empty `profile` field are considered inactive and cannot log in.", "filter": { "type": "string" }, "width": Lino.chars2width(23), "dataIndex": "profile", "editor": profile1895 }, { "colIndex": 2, "sortable": true, "header": "First name", "editable": true, "tooltip": "(users.MySettings.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "editor": first_name1896 }, { "colIndex": 3, "sortable": true, "header": "Last name", "editable": true, "tooltip": "(users.MySettings.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "editor": last_name1897 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.MySettings.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "hidden": true, "editor": id1898, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Created", "editable": false, "tooltip": "(users.MySettings.created) ", "width": Lino.chars2width(17), "dataIndex": "created", "hidden": true }, { "colIndex": 6, "sortable": true, "header": "Modified", "editable": false, "tooltip": "(users.MySettings.modified) ", "width": Lino.chars2width(17), "dataIndex": "modified", "hidden": true }, { "colIndex": 7, "sortable": true, "header": "Password", "editable": true, "tooltip": "(users.MySettings.password) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "password", "hidden": true, "editor": password1901 }, { "colIndex": 8, "sortable": true, "header": "Initials", "editable": true, "tooltip": "(users.MySettings.initials) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "initials", "hidden": true, "editor": initials1902 }, { "colIndex": 9, "sortable": true, "header": "e-mail address", "editable": true, "tooltip": "(users.MySettings.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "hidden": true, "editor": email1903 }, { "colIndex": 10, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(users.MySettings.remarks) ", "filter": { "type": "string" }, "header": "Remarks", "renderer": Lino.text_renderer, "hidden": true, "editor": remarks1904, "dataIndex": "remarks" }, { "colIndex": 11, "sortable": true, "header": "Language", "editable": true, "tooltip": "(users.MySettings.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "hidden": true, "editor": language1905 }, { "colIndex": 12, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(users.MySettings.partner) ", "filter": { "type": "string" }, "header": "Partner", "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "hidden": true, "editor": partner1906, "dataIndex": "partner" }, { "colIndex": 13, "sortable": true, "header": "Default access class", "editable": true, "tooltip": "(users.MySettings.access_class) The default access class for your calendar events and tasks.", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "access_class", "hidden": true, "editor": access_class1907 }, { "colIndex": 14, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(users.MySettings.event_type) The default event type for your calendar events.", "filter": { "type": "string" }, "header": "Default Event Type", "renderer": Lino.fk_renderer('event_typeHidden','Lino.cal.EventTypes.detail'), "hidden": true, "editor": event_type1908, "dataIndex": "event_type" } ];
    Lino.users.MySettings.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MySettings","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.users.MySettings.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MySettings","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.users.MySettings.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MySettings","GET",pk,"put",null);
};
Lino.users.MySettings.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MySettings","GET",pk,"post",null);
};

Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Users",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "must_save": true, "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});

Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Users",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "must_save": true, "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});
Lino.users.MySettings.update_reminders = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/MySettings","GET",pk,"update_reminders",null);
};

// js_render_GridPanel_class users.UsersOverview
Lino.users.UsersOverview.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/UsersOverview",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/users/UsersOverview','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/UsersOverview','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/UsersOverview','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "must_save": true, "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true } ],
  cell_edit : true,
  title : "Users",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "language" }, 'languageHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 12,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.UsersOverview.detail;
    this.ls_insert_handler = Lino.users.UsersOverview.insert;
    var ww = this.containing_window;
    var username1 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile2 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.UserProfiles) });
    var language3 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ] });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Username", "editable": true, "tooltip": "(users.UsersOverview.username) Required. Must be unique.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "username", "editor": username1 }, { "colIndex": 1, "sortable": true, "header": "User Profile", "editable": true, "tooltip": "(users.UsersOverview.profile) Users with an empty `profile` field are considered inactive and cannot log in.", "filter": { "type": "string" }, "width": Lino.chars2width(23), "dataIndex": "profile", "editor": profile2 }, { "colIndex": 2, "sortable": true, "header": "Language", "editable": true, "tooltip": "(users.UsersOverview.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "editor": language3 } ];
    Lino.users.UsersOverview.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.UsersOverview.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/UsersOverview","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.users.UsersOverview.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/UsersOverview","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.users.UsersOverview.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/UsersOverview","GET",pk,"put",null);
};
Lino.users.UsersOverview.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/UsersOverview","GET",pk,"post",null);
};

Lino.users.UsersOverview.insertPanel = Ext.extend(Lino.users.Users.InsertFormPanel,{
  empty_title: "New Users",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/users/UsersOverview",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.UsersOverview.detail;
    this.ls_insert_handler = Lino.users.UsersOverview.insert;
    Lino.users.UsersOverview.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.users.UsersOverview.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.UsersOverview.insertPanel(p);
});
Lino.users.UsersOverview.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/UsersOverview","GET",pk,"poststay",null);
};

Lino.users.UsersOverview.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Detail Users",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "update_reminders", "menu_item_text": "Update Events", "must_save": true, "tooltip": "Update Events", "panel_btn_handler": Lino.row_action_handler('update_reminders','GET',null), "iconCls": "x-tbar-lightning", "overflowText": "Update Events", "auto_save": true } ],
  ls_url: "/users/UsersOverview",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.UsersOverview.detail;
    this.ls_insert_handler = Lino.users.UsersOverview.insert;
    Lino.users.UsersOverview.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.UsersOverview.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.UsersOverview.detailPanel(p);
});
Lino.users.UsersOverview.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.UsersOverview.GridPanel(p);
});
Lino.users.UsersOverview.update_reminders = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/UsersOverview","GET",pk,"update_reminders",null);
};

// js_render_GridPanel_class users.Teams
Lino.users.Teams.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/Teams",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/users/Teams','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Teams','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Teams','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Teams",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 5,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 14,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id1910 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1911 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1912 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1913 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.Teams.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1910, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(users.Teams.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1911 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(users.Teams.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de1912 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(users.Teams.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1913 } ];
    Lino.users.Teams.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Teams.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Teams","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.users.Teams.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Teams","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.users.Teams.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Teams","GET",pk,"put",null);
};
Lino.users.Teams.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Teams","GET",pk,"post",null);
};
Lino.users.Teams.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Teams.GridPanel(p);
});

// js_render_GridPanel_class users.Memberships
Lino.users.Memberships.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/Memberships",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/users/Memberships','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Memberships','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Memberships','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Memberships",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "team" }, 'teamHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 11,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id1915 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1916 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Memberships/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var team1917 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Memberships/team", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Team..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.Memberships.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1915, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Author", "editable": true, "tooltip": "(users.Memberships.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1916, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "Team", "editable": true, "tooltip": "(users.Memberships.team) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "team", "editor": team1917 } ];
    Lino.users.Memberships.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Memberships.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Memberships","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.users.Memberships.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Memberships","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.users.Memberships.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Memberships","GET",pk,"put",null);
};
Lino.users.Memberships.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Memberships","GET",pk,"post",null);
};
Lino.users.Memberships.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Memberships.GridPanel(p);
});

// js_render_GridPanel_class users.Authorities
Lino.users.Authorities.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/Authorities",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/users/Authorities','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Authorities','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/users/Authorities','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Authorities",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "authorized" }, 'authorizedHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 13,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id1919 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1920 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Authorities/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var authorized1921 = new Lino.RemoteComboFieldElement({ "preferred_width": 15, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Authorities/authorized", "method": "GET" }) }), "emptyText": "Select a User..." });
    this.before_row_edit = function(record) {
      authorized1921.setContextValue('user',record ? record.data['userHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      user1920.on('change',Lino.chooser_handler(authorized1921,'user'));
      Lino.users.Authorities.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(users.Authorities.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1919, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Author", "editable": true, "tooltip": "(users.Authorities.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1920, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "User", "editable": true, "tooltip": "(users.Authorities.authorized) The user who gets authority to act in your name.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('authorizedHidden','Lino.users.Users.detail'), "editor": authorized1921, "dataIndex": "authorized" } ];
    Lino.users.Authorities.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Authorities.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Authorities","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.users.Authorities.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Authorities","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.users.Authorities.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Authorities","GET",pk,"put",null);
};
Lino.users.Authorities.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/users/Authorities","GET",pk,"post",null);
};
Lino.users.Authorities.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Authorities.GridPanel(p);
});

// js_render_GridPanel_class countries.Countries
Lino.countries.Countries.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/countries/Countries",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/countries/Countries','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/countries/Countries','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/countries/Countries','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Countries",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 7,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "isocode" }, { "name": "short_code" }, { "name": "iso3" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 15,
  ls_id_property : "isocode",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    var ww = this.containing_window;
    var name1923 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1924 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1925 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var isocode1926 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "allowBlank": false, "maxLength": 4 });
    var short_code1927 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    var iso31928 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "maxLength": 3 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(countries.Countries.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1923 }, { "colIndex": 1, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(countries.Countries.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de1924 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(countries.Countries.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1925 }, { "colIndex": 3, "sortable": true, "header": "ISO code", "editable": true, "tooltip": "(countries.Countries.isocode)         The two-letter code for this country as defined by ISO 3166-1. \n        For countries that no longer exist it may be a 4-letter code.", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "isocode", "editor": isocode1926 }, { "colIndex": 4, "sortable": true, "header": "Short code", "editable": true, "tooltip": "(countries.Countries.short_code) A short abbreviation for regional usage. Obsolete.", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "short_code", "hidden": true, "editor": short_code1927 }, { "colIndex": 5, "sortable": true, "header": "ISO-3 code", "editable": true, "tooltip": "(countries.Countries.iso3) The three-letter code for this country as defined by ISO 3166-1.", "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "iso3", "hidden": true, "editor": iso31928 } ];
    Lino.countries.Countries.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Countries","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.countries.Countries.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Countries","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.countries.Countries.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Countries","GET",pk,"put",null);
};
Lino.countries.Countries.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Countries","GET",pk,"post",null);
};

Lino.countries.Countries.insertPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "New Countries",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/countries/Countries",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    Lino.countries.Countries.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Countries.insertPanel(p);
});
Lino.countries.Countries.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Countries","GET",pk,"poststay",null);
};

Lino.countries.Countries.detailPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "Detail Countries",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/countries/Countries",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    Lino.countries.Countries.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.detailPanel(p);
});
Lino.countries.Countries.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.GridPanel(p);
});

// js_render_GridPanel_class countries.Cities
Lino.countries.Cities.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/countries/Cities",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/countries/Cities','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/countries/Cities','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/countries/Cities','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Places",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 12,
  ls_store_fields : [ { "name": "country" }, 'countryHidden', { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "type" }, 'typeHidden', { "name": "zip_code" }, { "type": "int", "name": "id" }, { "name": "parent" }, 'parentHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 8,
  ls_grid_configs : [  ],
  content_type : 16,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Cities.detail;
    this.ls_insert_handler = Lino.countries.Cities.insert;
    var ww = this.containing_window;
    var country1930 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/country", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Country..." });
    var name1931 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1932 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1933 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type1934 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/type", "method": "GET" }) }) });
    var zip_code1935 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "maxLength": 8 });
    var id1936 = new Ext.form.NumberField({ "selectOnFocus": true });
    var parent1937 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/parent", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    this.before_row_edit = function(record) {
      type1934.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country1930.on('change',Lino.chooser_handler(type1934,'country'));
      Lino.countries.Cities.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Country", "editable": true, "tooltip": "(countries.Cities.country) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country1930, "dataIndex": "country" }, { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(countries.Cities.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1931 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(countries.Cities.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de1932 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(countries.Cities.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1933 }, { "colIndex": 4, "sortable": true, "header": "Place Type", "editable": true, "tooltip": "(countries.Cities.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "type", "editor": type1934 }, { "colIndex": 5, "sortable": true, "header": "zip code", "editable": true, "tooltip": "(countries.Cities.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "zip_code", "editor": zip_code1935 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(countries.Cities.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "hidden": true, "editor": id1936, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 7, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(countries.Cities.parent) The superordinate geographic place of which this place is a part.", "filter": { "type": "string" }, "header": "Part of", "renderer": Lino.fk_renderer('parentHidden','Lino.countries.Cities.detail'), "hidden": true, "editor": parent1937, "dataIndex": "parent" } ];
    Lino.countries.Cities.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Cities.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Cities","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.countries.Cities.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Cities","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.countries.Cities.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Cities","GET",pk,"put",null);
};
Lino.countries.Cities.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Cities","GET",pk,"post",null);
};

Lino.countries.Cities.insertPanel = Ext.extend(Lino.countries.Cities.DetailFormPanel,{
  empty_title: "New Places",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/countries/Cities",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Cities.detail;
    this.ls_insert_handler = Lino.countries.Cities.insert;
    Lino.countries.Cities.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Cities.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Cities.insertPanel(p);
});
Lino.countries.Cities.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/countries/Cities","GET",pk,"poststay",null);
};

Lino.countries.Cities.detailPanel = Ext.extend(Lino.countries.Cities.DetailFormPanel,{
  empty_title: "Detail Places",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/countries/Cities",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Cities.detail;
    this.ls_insert_handler = Lino.countries.Cities.insert;
    Lino.countries.Cities.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Cities.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Cities.detailPanel(p);
});
Lino.countries.Cities.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Cities.GridPanel(p);
});

// js_render_GridPanel_class properties.PropGroups
Lino.properties.PropGroups.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/properties/PropGroups",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/properties/PropGroups','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/properties/PropGroups','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/properties/PropGroups','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Property Groups",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 5,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 18,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropGroups.detail;
    this.ls_insert_handler = Lino.properties.PropGroups.insert;
    var ww = this.containing_window;
    var id1939 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1940 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1941 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1942 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(properties.PropGroups.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1939, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(properties.PropGroups.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1940 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(properties.PropGroups.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de1941 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(properties.PropGroups.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1942 } ];
    Lino.properties.PropGroups.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropGroups.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/PropGroups","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.properties.PropGroups.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/PropGroups","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.properties.PropGroups.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/PropGroups","GET",pk,"put",null);
};
Lino.properties.PropGroups.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/PropGroups","GET",pk,"post",null);
};

Lino.properties.PropGroups.insertPanel = Ext.extend(Lino.properties.PropGroups.DetailFormPanel,{
  empty_title: "New Property Groups",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/properties/PropGroups",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropGroups.detail;
    this.ls_insert_handler = Lino.properties.PropGroups.insert;
    Lino.properties.PropGroups.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropGroups.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.properties.PropGroups.insertPanel(p);
});
Lino.properties.PropGroups.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/PropGroups","GET",pk,"poststay",null);
};

Lino.properties.PropGroups.detailPanel = Ext.extend(Lino.properties.PropGroups.DetailFormPanel,{
  empty_title: "Detail Property Groups",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/properties/PropGroups",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropGroups.detail;
    this.ls_insert_handler = Lino.properties.PropGroups.insert;
    Lino.properties.PropGroups.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropGroups.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropGroups.detailPanel(p);
});
Lino.properties.PropGroups.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropGroups.GridPanel(p);
});

// js_render_GridPanel_class properties.PropTypes
Lino.properties.PropTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/properties/PropTypes",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/properties/PropTypes','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/properties/PropTypes','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/properties/PropTypes','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Property Types",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 11,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "choicelist" }, 'choicelistHidden', { "name": "default_value" }, 'default_valueHidden', { "type": "boolean", "name": "limit_to_choices" }, { "type": "boolean", "name": "multiple_choices" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 19,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropTypes.detail;
    this.ls_insert_handler = Lino.properties.PropTypes.insert;
    var ww = this.containing_window;
    var id1944 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1945 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1946 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1947 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var choicelist1948 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "countries.CityTypes", "CityTypes" ], [ "lino.Genders", "Genders" ], [ "lino.UserGroups", "User Groups" ], [ "lino.UserLevels", "User Levels" ], [ "lino.UserProfiles", "User Profiles" ], [ "lino.YesNo", "Yes or no" ], [ "properties.DoYouLike", "DoYouLike" ], [ "properties.HowWell", "HowWell" ] ] });
    var default_value1949 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropTypes/default_value", "method": "GET" }) }) });
    var limit_to_choices1950 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var multiple_choices1951 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
      default_value1949.setContextValue('choicelist',record ? record.data['choicelistHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      choicelist1948.on('change',Lino.chooser_handler(default_value1949,'choicelist'));
      Lino.properties.PropTypes.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(properties.PropTypes.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1944, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(properties.PropTypes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1945 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(properties.PropTypes.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de1946 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(properties.PropTypes.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1947 }, { "colIndex": 4, "sortable": true, "header": "Choices List", "editable": true, "tooltip": "(properties.PropTypes.choicelist) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "choicelist", "editor": choicelist1948 }, { "colIndex": 5, "sortable": true, "header": "default value", "editable": true, "tooltip": "(properties.PropTypes.default_value) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "default_value", "editor": default_value1949 }, { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "Limit to choices", "editable": true, "tooltip": "(properties.PropTypes.limit_to_choices) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "limit_to_choices" }, { "colIndex": 7, "sortable": false, "xtype": "checkcolumn", "header": "Multiple choices", "editable": true, "tooltip": "(properties.PropTypes.multiple_choices) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "multiple_choices" } ];
    Lino.properties.PropTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropTypes.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/PropTypes","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.properties.PropTypes.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/PropTypes","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.properties.PropTypes.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/PropTypes","GET",pk,"put",null);
};
Lino.properties.PropTypes.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/PropTypes","GET",pk,"post",null);
};

Lino.properties.PropTypes.insertPanel = Ext.extend(Lino.properties.PropTypes.DetailFormPanel,{
  empty_title: "New Property Types",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/properties/PropTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropTypes.detail;
    this.ls_insert_handler = Lino.properties.PropTypes.insert;
    Lino.properties.PropTypes.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropTypes.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.properties.PropTypes.insertPanel(p);
});
Lino.properties.PropTypes.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/PropTypes","GET",pk,"poststay",null);
};

Lino.properties.PropTypes.detailPanel = Ext.extend(Lino.properties.PropTypes.DetailFormPanel,{
  empty_title: "Detail Property Types",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/properties/PropTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropTypes.detail;
    this.ls_insert_handler = Lino.properties.PropTypes.insert;
    Lino.properties.PropTypes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropTypes.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropTypes.detailPanel(p);
});
Lino.properties.PropTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropTypes.GridPanel(p);
});

// js_render_GridPanel_class properties.Properties
Lino.properties.Properties.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/properties/Properties",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/properties/Properties','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/properties/Properties','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/properties/Properties','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Properties",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 9,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "group" }, 'groupHidden', { "name": "type" }, 'typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 17,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id1953 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1954 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1955 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1956 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var group1957 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/Properties/group", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Property Group..." });
    var type1958 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/Properties/type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Property Type..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(properties.Properties.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1953, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(properties.Properties.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1954 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(properties.Properties.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de1955 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(properties.Properties.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1956 }, { "colIndex": 4, "sortable": true, "header": "Property Group", "editable": true, "tooltip": "(properties.Properties.group) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('groupHidden','Lino.properties.PropGroups.detail'), "editor": group1957, "dataIndex": "group" }, { "colIndex": 5, "sortable": true, "header": "Property Type", "editable": true, "tooltip": "(properties.Properties.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('typeHidden','Lino.properties.PropTypes.detail'), "editor": type1958, "dataIndex": "type" } ];
    Lino.properties.Properties.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.Properties.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/Properties","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.properties.Properties.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/Properties","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.properties.Properties.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/Properties","GET",pk,"put",null);
};
Lino.properties.Properties.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/Properties","GET",pk,"post",null);
};
Lino.properties.Properties.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.Properties.GridPanel(p);
});

// js_render_GridPanel_class properties.PropChoices
Lino.properties.PropChoices.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/properties/PropChoices",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/properties/PropChoices','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/properties/PropChoices','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/properties/PropChoices','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Property Choices",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 8,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "type" }, 'typeHidden', { "name": "value" }, { "name": "text" }, { "name": "text_de" }, { "name": "text_fr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 20,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id1960 = new Ext.form.NumberField({ "selectOnFocus": true });
    var type1961 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropChoices/type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Property Type..." });
    var value1962 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var text1963 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_de1964 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_fr1965 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(properties.PropChoices.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1960, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Property Type", "editable": true, "tooltip": "(properties.PropChoices.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('typeHidden','Lino.properties.PropTypes.detail'), "editor": type1961, "dataIndex": "type" }, { "colIndex": 2, "sortable": true, "header": "Value", "editable": true, "tooltip": "(properties.PropChoices.value) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "value", "editor": value1962 }, { "colIndex": 3, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(properties.PropChoices.text) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text", "editor": text1963 }, { "colIndex": 4, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(properties.PropChoices.text_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text_de", "editor": text_de1964 }, { "colIndex": 5, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(properties.PropChoices.text_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "text_fr", "editor": text_fr1965 } ];
    Lino.properties.PropChoices.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropChoices.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/PropChoices","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.properties.PropChoices.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/PropChoices","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.properties.PropChoices.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/PropChoices","GET",pk,"put",null);
};
Lino.properties.PropChoices.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/properties/PropChoices","GET",pk,"post",null);
};
Lino.properties.PropChoices.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.properties.PropChoices.GridPanel(p);
});

// js_render_GridPanel_class contacts.CompanyTypes
Lino.contacts.CompanyTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/CompanyTypes",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/contacts/CompanyTypes','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/CompanyTypes','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/CompanyTypes','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "company types",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 8,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "type": "int", "name": "id" }, { "name": "abbr" }, { "name": "abbr_de" }, { "name": "abbr_fr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 26,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var name1967 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1968 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1969 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1970 = new Ext.form.NumberField({ "selectOnFocus": true });
    var abbr1971 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var abbr_de1972 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var abbr_fr1973 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(contacts.CompanyTypes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1967 }, { "colIndex": 1, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(contacts.CompanyTypes.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de1968 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(contacts.CompanyTypes.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr1969 }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.CompanyTypes.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "hidden": true, "editor": id1970, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Abbreviation", "editable": true, "tooltip": "(contacts.CompanyTypes.abbr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "abbr", "hidden": true, "editor": abbr1971 }, { "colIndex": 5, "sortable": true, "header": "Abbreviation (de)", "editable": true, "tooltip": "(contacts.CompanyTypes.abbr_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "abbr_de", "hidden": true, "editor": abbr_de1972 }, { "colIndex": 6, "sortable": true, "header": "Abbreviation (fr)", "editable": true, "tooltip": "(contacts.CompanyTypes.abbr_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "abbr_fr", "hidden": true, "editor": abbr_fr1973 } ];
    Lino.contacts.CompanyTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.CompanyTypes.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/CompanyTypes","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.contacts.CompanyTypes.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/CompanyTypes","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.contacts.CompanyTypes.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/CompanyTypes","GET",pk,"put",null);
};
Lino.contacts.CompanyTypes.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/CompanyTypes","GET",pk,"post",null);
};
Lino.contacts.CompanyTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.CompanyTypes.GridPanel(p);
});

// js_render_GridPanel_class contacts.Partners
Lino.contacts.Partners.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Partners",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/contacts/Partners','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/Partners','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/Partners','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true }, { "itemId": "print_labels", "menu_item_text": "Labels", "must_save": true, "tooltip": "Generate mailing labels for these recipients", "panel_btn_handler": Lino.list_action_handler('/contacts/Partners','print_labels','GET',Lino.get_current_grid_config), "text": "Labels", "overflowText": "Labels", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "create_invoice", "menu_item_text": "Create invoice", "must_save": true, "tooltip": "Create invoice for this partner using invoiceable items", "panel_btn_handler": Lino.row_action_handler('create_invoice','GET',null), "iconCls": "x-tbar-money", "overflowText": "Create invoice", "auto_save": true }, { "itemId": "due", "menu_item_text": "Debts", "must_save": true, "tooltip": "Debts", "panel_btn_handler": Lino.row_action_handler('due','GET',null), "iconCls": "x-tbar-book_link", "overflowText": "Debts", "auto_save": true }, { "itemId": "show_invoiceables", "menu_item_text": "Invoices to create", "must_save": true, "tooltip": "List of invoiceable items for this partner", "panel_btn_handler": Lino.row_action_handler('show_invoiceables','GET',null), "iconCls": "x-tbar-basket", "overflowText": "Invoices to create", "auto_save": true } ],
  cell_edit : true,
  title : "Partners",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 34,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "name": "invoicing_address" }, 'invoicing_addressHidden', { "name": "payment_term" }, 'payment_termHidden', { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "imode" }, 'imodeHidden', { "name": "national_id_et" }, { "name": "bank_account1" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 32,
  ls_grid_configs : [  ],
  content_type : 25,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    var ww = this.containing_window;
    var name1975 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email1976 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var country1977 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Country..." });
    var city1978 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var region1979 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var zip_code1980 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr11981 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix1982 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street1983 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no1984 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box1985 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr21986 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language1987 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ] });
    var url1988 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone1989 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm1990 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax1991 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks1992 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var invoicing_address1993 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/invoicing_address", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var payment_term1994 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Payment Term..." });
    var vat_regime1995 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var imode1996 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Invoicing Mode..." });
    var national_id_et1997 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var bank_account11998 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var id1999 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city1978.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1978.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region1979.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country1977.on('change',Lino.chooser_handler(city1978,'country'));
      region1979.on('change',Lino.chooser_handler(city1978,'region'));
      country1977.on('change',Lino.chooser_handler(region1979,'country'));
      Lino.contacts.Partners.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.Partners.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name1975 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.Partners.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email1976 }, { "colIndex": 2, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Partners.country) ", "filter": { "type": "string" }, "header": "Country", "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "hidden": true, "editor": country1977, "dataIndex": "country" }, { "colIndex": 3, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Partners.city) ", "filter": { "type": "string" }, "header": "Place", "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail'), "hidden": true, "editor": city1978, "dataIndex": "city" }, { "colIndex": 4, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Partners.region) ", "filter": { "type": "string" }, "header": "Region", "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail'), "hidden": true, "editor": region1979, "dataIndex": "region" }, { "colIndex": 5, "sortable": true, "header": "Zip code", "editable": true, "tooltip": "(contacts.Partners.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "hidden": true, "editor": zip_code1980 }, { "colIndex": 6, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "(contacts.Partners.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "hidden": true, "editor": addr11981 }, { "colIndex": 7, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "(contacts.Partners.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "hidden": true, "editor": street_prefix1982 }, { "colIndex": 8, "sortable": true, "header": "Street", "editable": true, "tooltip": "(contacts.Partners.street) Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "hidden": true, "editor": street1983 }, { "colIndex": 9, "sortable": true, "header": "No.", "editable": true, "tooltip": "(contacts.Partners.street_no) House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "hidden": true, "editor": street_no1984 }, { "colIndex": 10, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.Partners.street_box) Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "hidden": true, "editor": street_box1985 }, { "colIndex": 11, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "(contacts.Partners.addr2) Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "hidden": true, "editor": addr21986 }, { "colIndex": 12, "sortable": true, "header": "Language", "editable": true, "tooltip": "(contacts.Partners.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "hidden": true, "editor": language1987 }, { "colIndex": 13, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.Partners.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "hidden": true, "editor": url1988 }, { "colIndex": 14, "sortable": true, "header": "Phone", "editable": true, "tooltip": "(contacts.Partners.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "hidden": true, "editor": phone1989 }, { "colIndex": 15, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.Partners.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "hidden": true, "editor": gsm1990 }, { "colIndex": 16, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.Partners.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "hidden": true, "editor": fax1991 }, { "colIndex": 17, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(contacts.Partners.remarks) ", "filter": { "type": "string" }, "header": "Remarks", "renderer": Lino.text_renderer, "hidden": true, "editor": remarks1992, "dataIndex": "remarks" }, { "colIndex": 18, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Partners.invoicing_address) ", "filter": { "type": "string" }, "header": "Invoicing address", "renderer": Lino.fk_renderer('invoicing_addressHidden','Lino.contacts.Partners.detail'), "hidden": true, "editor": invoicing_address1993, "dataIndex": "invoicing_address" }, { "colIndex": 19, "sortable": true, "header": "Payment Term", "editable": true, "tooltip": "(contacts.Partners.payment_term) The default payment term for sales invoices to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "payment_term", "hidden": true, "editor": payment_term1994 }, { "colIndex": 20, "sortable": true, "header": "VAT Regime", "editable": true, "tooltip": "(contacts.Partners.vat_regime) The default VAT regime for sales to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "vat_regime", "hidden": true, "editor": vat_regime1995 }, { "colIndex": 21, "sortable": true, "header": "Invoicing Mode", "editable": true, "tooltip": "(contacts.Partners.imode) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "imode", "hidden": true, "editor": imode1996 }, { "colIndex": 22, "sortable": true, "header": "National ID", "editable": true, "tooltip": "(contacts.Partners.national_id_et) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "national_id_et", "hidden": true, "editor": national_id_et1997 }, { "colIndex": 23, "sortable": true, "header": "Bank account", "editable": true, "tooltip": "(contacts.Partners.bank_account1) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account11998 }, new Lino.NullNumberColumn({ "colIndex": 24, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.Partners.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1999, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.Partners.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Partners","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.contacts.Partners.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Partners","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.contacts.Partners.print_labels = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Partners","GET",pk,"print_labels",Lino.get_current_grid_config);
};
Lino.contacts.Partners.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Partners","GET",pk,"put",null);
};
Lino.contacts.Partners.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Partners","GET",pk,"post",null);
};

Lino.contacts.Partners.insertPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "New Partners",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/contacts/Partners",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    Lino.contacts.Partners.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Partners.insertPanel(p);
});
Lino.contacts.Partners.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Partners","GET",pk,"poststay",null);
};

Lino.contacts.Partners.detailPanel = Ext.extend(Lino.contacts.Partners.DetailFormPanel,{
  empty_title: "Detail Partners",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "create_invoice", "menu_item_text": "Create invoice", "must_save": true, "tooltip": "Create invoice for this partner using invoiceable items", "panel_btn_handler": Lino.row_action_handler('create_invoice','GET',null), "iconCls": "x-tbar-money", "overflowText": "Create invoice", "auto_save": true }, { "itemId": "due", "menu_item_text": "Debts", "must_save": true, "tooltip": "Debts", "panel_btn_handler": Lino.row_action_handler('due','GET',null), "iconCls": "x-tbar-book_link", "overflowText": "Debts", "auto_save": true }, { "itemId": "show_invoiceables", "menu_item_text": "Invoices to create", "must_save": true, "tooltip": "List of invoiceable items for this partner", "panel_btn_handler": Lino.row_action_handler('show_invoiceables','GET',null), "iconCls": "x-tbar-basket", "overflowText": "Invoices to create", "auto_save": true } ],
  ls_url: "/contacts/Partners",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail;
    this.ls_insert_handler = Lino.contacts.Partners.insert;
    Lino.contacts.Partners.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Partners.detailPanel(p);
});
Lino.contacts.Partners.create_invoice = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Partners","GET",pk,"create_invoice",null);
};
Lino.contacts.Partners.due = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Partners","GET",pk,"due",null);
};
Lino.contacts.Partners.show_invoiceables = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Partners","GET",pk,"show_invoiceables",null);
};
Lino.contacts.Partners.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Partners.GridPanel(p);
});

// js_render_GridPanel_class contacts.Persons
Lino.contacts.Persons.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Persons",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/contacts/Persons','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/Persons','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/Persons','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true }, { "itemId": "print_labels", "menu_item_text": "Labels", "must_save": true, "tooltip": "Generate mailing labels for these recipients", "panel_btn_handler": Lino.list_action_handler('/contacts/Persons','print_labels','GET',Lino.get_current_grid_config), "text": "Labels", "overflowText": "Labels", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "create_invoice", "menu_item_text": "Create invoice", "must_save": true, "tooltip": "Create invoice for this partner using invoiceable items", "panel_btn_handler": Lino.row_action_handler('create_invoice','GET',null), "iconCls": "x-tbar-money", "overflowText": "Create invoice", "auto_save": true }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Edit Print Template", "must_save": true, "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Edit Print Template", "overflowText": "Edit Print Template", "auto_save": true }, { "itemId": "due", "menu_item_text": "Debts", "must_save": true, "tooltip": "Debts", "panel_btn_handler": Lino.row_action_handler('due','GET',null), "iconCls": "x-tbar-book_link", "overflowText": "Debts", "auto_save": true }, { "itemId": "show_invoiceables", "menu_item_text": "Invoices to create", "must_save": true, "tooltip": "List of invoiceable items for this partner", "panel_btn_handler": Lino.row_action_handler('show_invoiceables','GET',null), "iconCls": "x-tbar-basket", "overflowText": "Invoices to create", "auto_save": true } ],
  cell_edit : true,
  title : "Persons",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 44,
  ls_store_fields : [ { "name": "name_column" }, { "name": "address_column" }, { "name": "email" }, { "name": "phone" }, { "name": "gsm" }, { "type": "int", "name": "id" }, { "name": "language" }, 'languageHidden', { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "name" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "url" }, { "name": "fax" }, { "name": "remarks" }, { "name": "invoicing_address" }, 'invoicing_addressHidden', { "name": "payment_term" }, 'payment_termHidden', { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "imode" }, 'imodeHidden', { "name": "national_id_et" }, { "name": "bank_account1" }, { "name": "created" }, { "name": "modified" }, { "name": "first_name" }, { "name": "last_name" }, { "name": "gender" }, 'genderHidden', { "name": "birth_date" }, { "name": "title" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 25,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    var ww = this.containing_window;
    var name_column_disp2001 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var address_column_disp2002 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var email2003 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone2004 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm2005 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id2006 = new Ext.form.NumberField({ "selectOnFocus": true });
    var language2007 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ] });
    var country2008 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Country..." });
    var city2009 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var region2010 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var zip_code2011 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var name2012 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var addr12013 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix2014 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street2015 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no2016 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box2017 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr22018 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var url2019 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var fax2020 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks2021 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var invoicing_address2022 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/invoicing_address", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var payment_term2023 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Payment Term..." });
    var vat_regime2024 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var imode2025 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Invoicing Mode..." });
    var national_id_et2026 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var bank_account12027 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var created2028 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2029 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var first_name2030 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var last_name2031 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gender2032 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.lino.Genders) });
    var birth_date2033 = new Lino.IncompleteDateField({ "selectOnFocus": true });
    var title2034 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
      city2009.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2009.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region2010.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country2008.on('change',Lino.chooser_handler(city2009,'country'));
      region2010.on('change',Lino.chooser_handler(city2009,'region'));
      country2008.on('change',Lino.chooser_handler(region2010,'country'));
      Lino.contacts.Persons.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "name_column", "header": "Name", "editable": false, "tooltip": "(contacts.Persons.name_column) " }, { "width": Lino.chars2width(31), "colIndex": 1, "sortable": false, "dataIndex": "address_column", "header": "Address", "editable": false, "tooltip": "(contacts.Persons.address_column) " }, { "colIndex": 2, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.Persons.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email2003 }, { "colIndex": 3, "sortable": true, "header": "Phone", "editable": true, "tooltip": "(contacts.Persons.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "phone", "editor": phone2004 }, { "colIndex": 4, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.Persons.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "gsm", "editor": gsm2005 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.Persons.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2006, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Language", "editable": true, "tooltip": "(contacts.Persons.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "language", "editor": language2007 }, { "colIndex": 7, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Persons.country) ", "filter": { "type": "string" }, "header": "Country", "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "hidden": true, "editor": country2008, "dataIndex": "country" }, { "colIndex": 8, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Persons.city) ", "filter": { "type": "string" }, "header": "Place", "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail'), "hidden": true, "editor": city2009, "dataIndex": "city" }, { "colIndex": 9, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Persons.region) ", "filter": { "type": "string" }, "header": "Region", "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail'), "hidden": true, "editor": region2010, "dataIndex": "region" }, { "colIndex": 10, "sortable": true, "header": "Zip code", "editable": true, "tooltip": "(contacts.Persons.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "hidden": true, "editor": zip_code2011 }, { "colIndex": 11, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.Persons.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "hidden": true, "editor": name2012 }, { "colIndex": 12, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "(contacts.Persons.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "hidden": true, "editor": addr12013 }, { "colIndex": 13, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "(contacts.Persons.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "hidden": true, "editor": street_prefix2014 }, { "colIndex": 14, "sortable": true, "header": "Street", "editable": true, "tooltip": "(contacts.Persons.street) Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "hidden": true, "editor": street2015 }, { "colIndex": 15, "sortable": true, "header": "No.", "editable": true, "tooltip": "(contacts.Persons.street_no) House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "hidden": true, "editor": street_no2016 }, { "colIndex": 16, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.Persons.street_box) Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "hidden": true, "editor": street_box2017 }, { "colIndex": 17, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "(contacts.Persons.addr2) Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "hidden": true, "editor": addr22018 }, { "colIndex": 18, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.Persons.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "hidden": true, "editor": url2019 }, { "colIndex": 19, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.Persons.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "hidden": true, "editor": fax2020 }, { "colIndex": 20, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(contacts.Persons.remarks) ", "filter": { "type": "string" }, "header": "Remarks", "renderer": Lino.text_renderer, "hidden": true, "editor": remarks2021, "dataIndex": "remarks" }, { "colIndex": 21, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Persons.invoicing_address) ", "filter": { "type": "string" }, "header": "Invoicing address", "renderer": Lino.fk_renderer('invoicing_addressHidden','Lino.contacts.Partners.detail'), "hidden": true, "editor": invoicing_address2022, "dataIndex": "invoicing_address" }, { "colIndex": 22, "sortable": true, "header": "Payment Term", "editable": true, "tooltip": "(contacts.Persons.payment_term) The default payment term for sales invoices to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "payment_term", "hidden": true, "editor": payment_term2023 }, { "colIndex": 23, "sortable": true, "header": "VAT Regime", "editable": true, "tooltip": "(contacts.Persons.vat_regime) The default VAT regime for sales to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "vat_regime", "hidden": true, "editor": vat_regime2024 }, { "colIndex": 24, "sortable": true, "header": "Invoicing Mode", "editable": true, "tooltip": "(contacts.Persons.imode) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "imode", "hidden": true, "editor": imode2025 }, { "colIndex": 25, "sortable": true, "header": "National ID", "editable": true, "tooltip": "(contacts.Persons.national_id_et) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "national_id_et", "hidden": true, "editor": national_id_et2026 }, { "colIndex": 26, "sortable": true, "header": "Bank account", "editable": true, "tooltip": "(contacts.Persons.bank_account1) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account12027 }, { "colIndex": 27, "sortable": true, "header": "Created", "editable": false, "tooltip": "(contacts.Persons.created) ", "width": Lino.chars2width(17), "dataIndex": "created", "hidden": true }, { "colIndex": 28, "sortable": true, "header": "Modified", "editable": false, "tooltip": "(contacts.Persons.modified) ", "width": Lino.chars2width(17), "dataIndex": "modified", "hidden": true }, { "colIndex": 29, "sortable": true, "header": "First name", "editable": true, "tooltip": "(contacts.Persons.first_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "first_name", "hidden": true, "editor": first_name2030 }, { "colIndex": 30, "sortable": true, "header": "Last name", "editable": true, "tooltip": "(contacts.Persons.last_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "last_name", "hidden": true, "editor": last_name2031 }, { "colIndex": 31, "sortable": true, "header": "Gender", "editable": true, "tooltip": "(contacts.Persons.gender) ", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "gender", "hidden": true, "editor": gender2032 }, { "colIndex": 32, "sortable": true, "header": "Birth date", "editable": true, "tooltip": "(contacts.Persons.birth_date) Uncomplete dates are allowed, e.g. \n\"00.00.1980\" means \"some day in 1980\", \n\"00.07.1980\" means \"in July 1980\"\nor \"23.07.0000\" means \"on a 23th of July\".", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "birth_date", "hidden": true, "editor": birth_date2033 }, { "colIndex": 33, "sortable": true, "header": "Title", "editable": true, "tooltip": "(contacts.Persons.title) Text to print before first_name as part of the first address line.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "title", "hidden": true, "editor": title2034 } ];
    Lino.contacts.Persons.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Persons","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.contacts.Persons.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Persons","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.contacts.Persons.print_labels = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Persons","GET",pk,"print_labels",Lino.get_current_grid_config);
};
Lino.contacts.Persons.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Persons","GET",pk,"put",null);
};
Lino.contacts.Persons.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Persons","GET",pk,"post",null);
};

Lino.contacts.Persons.insertPanel = Ext.extend(Lino.contacts.Persons.InsertFormPanel,{
  empty_title: "New Persons",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/contacts/Persons",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    Lino.contacts.Persons.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Persons.insertPanel(p);
});
Lino.contacts.Persons.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Persons","GET",pk,"poststay",null);
};

Lino.contacts.Persons.detailPanel = Ext.extend(Lino.contacts.Persons.DetailFormPanel,{
  empty_title: "Detail Persons",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "create_invoice", "menu_item_text": "Create invoice", "must_save": true, "tooltip": "Create invoice for this partner using invoiceable items", "panel_btn_handler": Lino.row_action_handler('create_invoice','GET',null), "iconCls": "x-tbar-money", "overflowText": "Create invoice", "auto_save": true }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "edit_template", "menu_item_text": "Edit Print Template", "must_save": true, "panel_btn_handler": Lino.row_action_handler('edit_template','GET',null), "text": "Edit Print Template", "overflowText": "Edit Print Template", "auto_save": true }, { "itemId": "due", "menu_item_text": "Debts", "must_save": true, "tooltip": "Debts", "panel_btn_handler": Lino.row_action_handler('due','GET',null), "iconCls": "x-tbar-book_link", "overflowText": "Debts", "auto_save": true }, { "itemId": "show_invoiceables", "menu_item_text": "Invoices to create", "must_save": true, "tooltip": "List of invoiceable items for this partner", "panel_btn_handler": Lino.row_action_handler('show_invoiceables','GET',null), "iconCls": "x-tbar-basket", "overflowText": "Invoices to create", "auto_save": true } ],
  ls_url: "/contacts/Persons",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail;
    this.ls_insert_handler = Lino.contacts.Persons.insert;
    Lino.contacts.Persons.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Persons.detailPanel(p);
});
Lino.contacts.Persons.create_invoice = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Persons","GET",pk,"create_invoice",null);
};
Lino.contacts.Persons.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Persons","GET",pk,"do_print",null);
};
Lino.contacts.Persons.edit_template = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Persons","GET",pk,"edit_template",null);
};
Lino.contacts.Persons.due = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Persons","GET",pk,"due",null);
};
Lino.contacts.Persons.show_invoiceables = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Persons","GET",pk,"show_invoiceables",null);
};
Lino.contacts.Persons.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Persons.GridPanel(p);
});

// js_render_GridPanel_class contacts.Companies
Lino.contacts.Companies.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Companies",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/contacts/Companies','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/Companies','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/Companies','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true }, { "itemId": "print_labels", "menu_item_text": "Labels", "must_save": true, "tooltip": "Generate mailing labels for these recipients", "panel_btn_handler": Lino.list_action_handler('/contacts/Companies','print_labels','GET',Lino.get_current_grid_config), "text": "Labels", "overflowText": "Labels", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "create_invoice", "menu_item_text": "Create invoice", "must_save": true, "tooltip": "Create invoice for this partner using invoiceable items", "panel_btn_handler": Lino.row_action_handler('create_invoice','GET',null), "iconCls": "x-tbar-money", "overflowText": "Create invoice", "auto_save": true }, { "itemId": "due", "menu_item_text": "Debts", "must_save": true, "tooltip": "Debts", "panel_btn_handler": Lino.row_action_handler('due','GET',null), "iconCls": "x-tbar-book_link", "overflowText": "Debts", "auto_save": true }, { "itemId": "show_invoiceables", "menu_item_text": "Invoices to create", "must_save": true, "tooltip": "List of invoiceable items for this partner", "panel_btn_handler": Lino.row_action_handler('show_invoiceables','GET',null), "iconCls": "x-tbar-basket", "overflowText": "Invoices to create", "auto_save": true } ],
  cell_edit : true,
  title : "Companies",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 40,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "name": "invoicing_address" }, 'invoicing_addressHidden', { "name": "payment_term" }, 'payment_termHidden', { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "imode" }, 'imodeHidden', { "name": "national_id_et" }, { "name": "bank_account1" }, { "name": "created" }, { "name": "modified" }, { "name": "prefix" }, { "name": "vat_id" }, { "name": "type" }, 'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 38,
  ls_grid_configs : [  ],
  content_type : 25,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    var ww = this.containing_window;
    var name2036 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email2037 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var country2038 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Country..." });
    var city2039 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var region2040 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var zip_code2041 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr12042 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix2043 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street2044 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no2045 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box2046 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr22047 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language2048 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ] });
    var url2049 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone2050 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm2051 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax2052 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks2053 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var invoicing_address2054 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/invoicing_address", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var payment_term2055 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Payment Term..." });
    var vat_regime2056 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var imode2057 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Invoicing Mode..." });
    var national_id_et2058 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var bank_account12059 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var created2060 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2061 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var prefix2062 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var vat_id2063 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type2064 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a company type..." });
    var id2065 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city2039.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2039.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region2040.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country2038.on('change',Lino.chooser_handler(city2039,'country'));
      region2040.on('change',Lino.chooser_handler(city2039,'region'));
      country2038.on('change',Lino.chooser_handler(region2040,'country'));
      Lino.contacts.Companies.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "tooltip": "(contacts.Companies.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2036 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(contacts.Companies.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email2037 }, { "colIndex": 2, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Companies.country) ", "filter": { "type": "string" }, "header": "Country", "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "hidden": true, "editor": country2038, "dataIndex": "country" }, { "colIndex": 3, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Companies.city) ", "filter": { "type": "string" }, "header": "Place", "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail'), "hidden": true, "editor": city2039, "dataIndex": "city" }, { "colIndex": 4, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Companies.region) ", "filter": { "type": "string" }, "header": "Region", "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail'), "hidden": true, "editor": region2040, "dataIndex": "region" }, { "colIndex": 5, "sortable": true, "header": "Zip code", "editable": true, "tooltip": "(contacts.Companies.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "hidden": true, "editor": zip_code2041 }, { "colIndex": 6, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "(contacts.Companies.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "hidden": true, "editor": addr12042 }, { "colIndex": 7, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "(contacts.Companies.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "hidden": true, "editor": street_prefix2043 }, { "colIndex": 8, "sortable": true, "header": "Street", "editable": true, "tooltip": "(contacts.Companies.street) Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "hidden": true, "editor": street2044 }, { "colIndex": 9, "sortable": true, "header": "No.", "editable": true, "tooltip": "(contacts.Companies.street_no) House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "hidden": true, "editor": street_no2045 }, { "colIndex": 10, "sortable": true, "header": "Box", "editable": true, "tooltip": "(contacts.Companies.street_box) Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "hidden": true, "editor": street_box2046 }, { "colIndex": 11, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "(contacts.Companies.addr2) Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "hidden": true, "editor": addr22047 }, { "colIndex": 12, "sortable": true, "header": "Language", "editable": true, "tooltip": "(contacts.Companies.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "hidden": true, "editor": language2048 }, { "colIndex": 13, "sortable": true, "header": "URL", "editable": true, "tooltip": "(contacts.Companies.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "hidden": true, "editor": url2049 }, { "colIndex": 14, "sortable": true, "header": "Phone", "editable": true, "tooltip": "(contacts.Companies.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "hidden": true, "editor": phone2050 }, { "colIndex": 15, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(contacts.Companies.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "hidden": true, "editor": gsm2051 }, { "colIndex": 16, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(contacts.Companies.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "hidden": true, "editor": fax2052 }, { "colIndex": 17, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(contacts.Companies.remarks) ", "filter": { "type": "string" }, "header": "Remarks", "renderer": Lino.text_renderer, "hidden": true, "editor": remarks2053, "dataIndex": "remarks" }, { "colIndex": 18, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(contacts.Companies.invoicing_address) ", "filter": { "type": "string" }, "header": "Invoicing address", "renderer": Lino.fk_renderer('invoicing_addressHidden','Lino.contacts.Partners.detail'), "hidden": true, "editor": invoicing_address2054, "dataIndex": "invoicing_address" }, { "colIndex": 19, "sortable": true, "header": "Payment Term", "editable": true, "tooltip": "(contacts.Companies.payment_term) The default payment term for sales invoices to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "payment_term", "hidden": true, "editor": payment_term2055 }, { "colIndex": 20, "sortable": true, "header": "VAT Regime", "editable": true, "tooltip": "(contacts.Companies.vat_regime) The default VAT regime for sales to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "vat_regime", "hidden": true, "editor": vat_regime2056 }, { "colIndex": 21, "sortable": true, "header": "Invoicing Mode", "editable": true, "tooltip": "(contacts.Companies.imode) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "imode", "hidden": true, "editor": imode2057 }, { "colIndex": 22, "sortable": true, "header": "National ID", "editable": true, "tooltip": "(contacts.Companies.national_id_et) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "national_id_et", "hidden": true, "editor": national_id_et2058 }, { "colIndex": 23, "sortable": true, "header": "Bank account", "editable": true, "tooltip": "(contacts.Companies.bank_account1) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account12059 }, { "colIndex": 24, "sortable": true, "header": "Created", "editable": false, "tooltip": "(contacts.Companies.created) ", "width": Lino.chars2width(17), "dataIndex": "created", "hidden": true }, { "colIndex": 25, "sortable": true, "header": "Modified", "editable": false, "tooltip": "(contacts.Companies.modified) ", "width": Lino.chars2width(17), "dataIndex": "modified", "hidden": true }, { "colIndex": 26, "sortable": true, "header": "prefix", "editable": true, "tooltip": "(contacts.Companies.prefix) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "prefix", "hidden": true, "editor": prefix2062 }, { "colIndex": 27, "sortable": true, "header": "VAT id", "editable": true, "tooltip": "(contacts.Companies.vat_id) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "vat_id", "hidden": true, "editor": vat_id2063 }, { "colIndex": 28, "sortable": true, "header": "Company type", "editable": true, "tooltip": "(contacts.Companies.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "hidden": true, "editor": type2064 }, new Lino.NullNumberColumn({ "colIndex": 29, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.Companies.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2065, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.contacts.Companies.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Companies","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.contacts.Companies.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Companies","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.contacts.Companies.print_labels = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Companies","GET",pk,"print_labels",Lino.get_current_grid_config);
};
Lino.contacts.Companies.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Companies","GET",pk,"put",null);
};
Lino.contacts.Companies.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Companies","GET",pk,"post",null);
};

Lino.contacts.Companies.insertPanel = Ext.extend(Lino.contacts.Companies.InsertFormPanel,{
  empty_title: "New Companies",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/contacts/Companies",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    Lino.contacts.Companies.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.contacts.Companies.insertPanel(p);
});
Lino.contacts.Companies.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Companies","GET",pk,"poststay",null);
};

Lino.contacts.Companies.detailPanel = Ext.extend(Lino.contacts.Companies.DetailFormPanel,{
  empty_title: "Detail Companies",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "create_invoice", "menu_item_text": "Create invoice", "must_save": true, "tooltip": "Create invoice for this partner using invoiceable items", "panel_btn_handler": Lino.row_action_handler('create_invoice','GET',null), "iconCls": "x-tbar-money", "overflowText": "Create invoice", "auto_save": true }, { "itemId": "due", "menu_item_text": "Debts", "must_save": true, "tooltip": "Debts", "panel_btn_handler": Lino.row_action_handler('due','GET',null), "iconCls": "x-tbar-book_link", "overflowText": "Debts", "auto_save": true }, { "itemId": "show_invoiceables", "menu_item_text": "Invoices to create", "must_save": true, "tooltip": "List of invoiceable items for this partner", "panel_btn_handler": Lino.row_action_handler('show_invoiceables','GET',null), "iconCls": "x-tbar-basket", "overflowText": "Invoices to create", "auto_save": true } ],
  ls_url: "/contacts/Companies",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail;
    this.ls_insert_handler = Lino.contacts.Companies.insert;
    Lino.contacts.Companies.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Companies.detailPanel(p);
});
Lino.contacts.Companies.create_invoice = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Companies","GET",pk,"create_invoice",null);
};
Lino.contacts.Companies.due = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Companies","GET",pk,"due",null);
};
Lino.contacts.Companies.show_invoiceables = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Companies","GET",pk,"show_invoiceables",null);
};
Lino.contacts.Companies.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Companies.GridPanel(p);
});

// js_render_GridPanel_class contacts.RoleTypes
Lino.contacts.RoleTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/RoleTypes",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/contacts/RoleTypes','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/RoleTypes','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/RoleTypes','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Functions",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 5,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 21,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id2067 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2068 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de2069 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr2070 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.RoleTypes.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2067, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(contacts.RoleTypes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2068 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(contacts.RoleTypes.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de2069 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(contacts.RoleTypes.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2070 } ];
    Lino.contacts.RoleTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.RoleTypes.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RoleTypes","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.contacts.RoleTypes.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RoleTypes","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.contacts.RoleTypes.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RoleTypes","GET",pk,"put",null);
};
Lino.contacts.RoleTypes.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/RoleTypes","GET",pk,"post",null);
};
Lino.contacts.RoleTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.RoleTypes.GridPanel(p);
});

// js_render_GridPanel_class contacts.Roles
Lino.contacts.Roles.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Roles",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/contacts/Roles','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/Roles','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/contacts/Roles','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Contact Persons",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 8,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "type" }, 'typeHidden', { "name": "person" }, 'personHidden', { "name": "company" }, 'companyHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 24,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id2072 = new Ext.form.NumberField({ "selectOnFocus": true });
    var type2073 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Roles/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Function..." });
    var person2074 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Roles/person", "method": "GET" }) }), "emptyText": "Select a Person..." });
    var company2075 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Roles/company", "method": "GET" }) }), "emptyText": "Select a Company..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(contacts.Roles.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2072, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Contact Role", "editable": true, "tooltip": "(contacts.Roles.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "type", "editor": type2073 }, { "colIndex": 2, "sortable": true, "header": "Person", "editable": true, "tooltip": "(contacts.Roles.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('personHidden','Lino.contacts.Persons.detail'), "editor": person2074, "dataIndex": "person" }, { "colIndex": 3, "sortable": true, "header": "Company", "editable": true, "tooltip": "(contacts.Roles.company) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('companyHidden','Lino.contacts.Companies.detail'), "editor": company2075, "dataIndex": "company" } ];
    Lino.contacts.Roles.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Roles.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Roles","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.contacts.Roles.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Roles","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.contacts.Roles.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Roles","GET",pk,"put",null);
};
Lino.contacts.Roles.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/contacts/Roles","GET",pk,"post",null);
};
Lino.contacts.Roles.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.contacts.Roles.GridPanel(p);
});

// js_render_GridPanel_class households.Types
Lino.households.Types.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/households/Types",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/households/Types','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/households/Types','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/households/Types','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Household Types",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 5,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 30,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Types.detail;
    this.ls_insert_handler = Lino.households.Types.insert;
    var ww = this.containing_window;
    var id2077 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2078 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de2079 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr2080 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(households.Types.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2077, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(households.Types.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2078 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(households.Types.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de2079 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(households.Types.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2080 } ];
    Lino.households.Types.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Types.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Types","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.households.Types.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Types","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.households.Types.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Types","GET",pk,"put",null);
};
Lino.households.Types.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Types","GET",pk,"post",null);
};

Lino.households.Types.insertPanel = Ext.extend(Lino.households.Types.DetailFormPanel,{
  empty_title: "New Household Types",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/households/Types",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Types.detail;
    this.ls_insert_handler = Lino.households.Types.insert;
    Lino.households.Types.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Types.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.households.Types.insertPanel(p);
});
Lino.households.Types.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Types","GET",pk,"poststay",null);
};

Lino.households.Types.detailPanel = Ext.extend(Lino.households.Types.DetailFormPanel,{
  empty_title: "Detail Household Types",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/households/Types",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Types.detail;
    this.ls_insert_handler = Lino.households.Types.insert;
    Lino.households.Types.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Types.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Types.detailPanel(p);
});
Lino.households.Types.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Types.GridPanel(p);
});

// js_render_GridPanel_class households.Households
Lino.households.Households.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/households/Households",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/households/Households','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/households/Households','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/households/Households','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true }, { "itemId": "print_labels", "menu_item_text": "Labels", "must_save": true, "tooltip": "Generate mailing labels for these recipients", "panel_btn_handler": Lino.list_action_handler('/households/Households','print_labels','GET',Lino.get_current_grid_config), "text": "Labels", "overflowText": "Labels", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "create_invoice", "menu_item_text": "Create invoice", "must_save": true, "tooltip": "Create invoice for this partner using invoiceable items", "panel_btn_handler": Lino.row_action_handler('create_invoice','GET',null), "iconCls": "x-tbar-money", "overflowText": "Create invoice", "auto_save": true }, { "itemId": "due", "menu_item_text": "Debts", "must_save": true, "tooltip": "Debts", "panel_btn_handler": Lino.row_action_handler('due','GET',null), "iconCls": "x-tbar-book_link", "overflowText": "Debts", "auto_save": true }, { "itemId": "show_invoiceables", "menu_item_text": "Invoices to create", "must_save": true, "tooltip": "List of invoiceable items for this partner", "panel_btn_handler": Lino.row_action_handler('show_invoiceables','GET',null), "iconCls": "x-tbar-basket", "overflowText": "Invoices to create", "auto_save": true } ],
  cell_edit : true,
  title : "Households",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 39,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "name": "invoicing_address" }, 'invoicing_addressHidden', { "name": "payment_term" }, 'payment_termHidden', { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "imode" }, 'imodeHidden', { "name": "national_id_et" }, { "name": "bank_account1" }, { "name": "created" }, { "name": "modified" }, { "name": "prefix" }, { "name": "type" }, 'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 37,
  ls_grid_configs : [  ],
  content_type : 25,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Households.detail;
    this.ls_insert_handler = Lino.households.Households.insert;
    var ww = this.containing_window;
    var name2082 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email2083 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var country2084 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Country..." });
    var city2085 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var region2086 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var zip_code2087 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr12088 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix2089 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street2090 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no2091 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box2092 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr22093 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language2094 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ] });
    var url2095 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone2096 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm2097 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax2098 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks2099 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var invoicing_address2100 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/invoicing_address", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var payment_term2101 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Payment Term..." });
    var vat_regime2102 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.vat.VatRegimes) });
    var imode2103 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Invoicing Mode..." });
    var national_id_et2104 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var bank_account12105 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var created2106 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified2107 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var prefix2108 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type2109 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Households/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Household Type..." });
    var id2110 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city2085.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city2085.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region2086.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country2084.on('change',Lino.chooser_handler(city2085,'country'));
      region2086.on('change',Lino.chooser_handler(city2085,'region'));
      country2084.on('change',Lino.chooser_handler(region2086,'country'));
      Lino.households.Households.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "tooltip": "(households.Households.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2082 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "tooltip": "(households.Households.email) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "email", "editor": email2083 }, { "colIndex": 2, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(households.Households.country) ", "filter": { "type": "string" }, "header": "Country", "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "hidden": true, "editor": country2084, "dataIndex": "country" }, { "colIndex": 3, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(households.Households.city) ", "filter": { "type": "string" }, "header": "Place", "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail'), "hidden": true, "editor": city2085, "dataIndex": "city" }, { "colIndex": 4, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(households.Households.region) ", "filter": { "type": "string" }, "header": "Region", "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail'), "hidden": true, "editor": region2086, "dataIndex": "region" }, { "colIndex": 5, "sortable": true, "header": "Zip code", "editable": true, "tooltip": "(households.Households.zip_code) ", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "zip_code", "hidden": true, "editor": zip_code2087 }, { "colIndex": 6, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "(households.Households.addr1) Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr1", "hidden": true, "editor": addr12088 }, { "colIndex": 7, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "(households.Households.street_prefix) Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street_prefix", "hidden": true, "editor": street_prefix2089 }, { "colIndex": 8, "sortable": true, "header": "Street", "editable": true, "tooltip": "(households.Households.street) Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "street", "hidden": true, "editor": street2090 }, { "colIndex": 9, "sortable": true, "header": "No.", "editable": true, "tooltip": "(households.Households.street_no) House number", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_no", "hidden": true, "editor": street_no2091 }, { "colIndex": 10, "sortable": true, "header": "Box", "editable": true, "tooltip": "(households.Households.street_box) Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "street_box", "hidden": true, "editor": street_box2092 }, { "colIndex": 11, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "(households.Households.addr2) Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "addr2", "hidden": true, "editor": addr22093 }, { "colIndex": 12, "sortable": true, "header": "Language", "editable": true, "tooltip": "(households.Households.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "hidden": true, "editor": language2094 }, { "colIndex": 13, "sortable": true, "header": "URL", "editable": true, "tooltip": "(households.Households.url) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "url", "hidden": true, "editor": url2095 }, { "colIndex": 14, "sortable": true, "header": "Phone", "editable": true, "tooltip": "(households.Households.phone) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "phone", "hidden": true, "editor": phone2096 }, { "colIndex": 15, "sortable": true, "header": "GSM", "editable": true, "tooltip": "(households.Households.gsm) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "gsm", "hidden": true, "editor": gsm2097 }, { "colIndex": 16, "sortable": true, "header": "Fax", "editable": true, "tooltip": "(households.Households.fax) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "fax", "hidden": true, "editor": fax2098 }, { "colIndex": 17, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(households.Households.remarks) ", "filter": { "type": "string" }, "header": "Remarks", "renderer": Lino.text_renderer, "hidden": true, "editor": remarks2099, "dataIndex": "remarks" }, { "colIndex": 18, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(households.Households.invoicing_address) ", "filter": { "type": "string" }, "header": "Invoicing address", "renderer": Lino.fk_renderer('invoicing_addressHidden','Lino.contacts.Partners.detail'), "hidden": true, "editor": invoicing_address2100, "dataIndex": "invoicing_address" }, { "colIndex": 19, "sortable": true, "header": "Payment Term", "editable": true, "tooltip": "(households.Households.payment_term) The default payment term for sales invoices to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "payment_term", "hidden": true, "editor": payment_term2101 }, { "colIndex": 20, "sortable": true, "header": "VAT Regime", "editable": true, "tooltip": "(households.Households.vat_regime) The default VAT regime for sales to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "vat_regime", "hidden": true, "editor": vat_regime2102 }, { "colIndex": 21, "sortable": true, "header": "Invoicing Mode", "editable": true, "tooltip": "(households.Households.imode) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "imode", "hidden": true, "editor": imode2103 }, { "colIndex": 22, "sortable": true, "header": "National ID", "editable": true, "tooltip": "(households.Households.national_id_et) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "national_id_et", "hidden": true, "editor": national_id_et2104 }, { "colIndex": 23, "sortable": true, "header": "Bank account", "editable": true, "tooltip": "(households.Households.bank_account1) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "bank_account1", "hidden": true, "editor": bank_account12105 }, { "colIndex": 24, "sortable": true, "header": "Created", "editable": false, "tooltip": "(households.Households.created) ", "width": Lino.chars2width(17), "dataIndex": "created", "hidden": true }, { "colIndex": 25, "sortable": true, "header": "Modified", "editable": false, "tooltip": "(households.Households.modified) ", "width": Lino.chars2width(17), "dataIndex": "modified", "hidden": true }, { "colIndex": 26, "sortable": true, "header": "prefix", "editable": true, "tooltip": "(households.Households.prefix) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "prefix", "hidden": true, "editor": prefix2108 }, { "colIndex": 27, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(households.Households.type) ", "filter": { "type": "string" }, "header": "Household Type", "renderer": Lino.fk_renderer('typeHidden','Lino.households.Types.detail'), "hidden": true, "editor": type2109, "dataIndex": "type" }, new Lino.NullNumberColumn({ "colIndex": 28, "sortable": true, "format": "0", "editable": true, "tooltip": "(households.Households.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2110, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.households.Households.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Households.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Households","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.households.Households.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Households","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.households.Households.print_labels = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Households","GET",pk,"print_labels",Lino.get_current_grid_config);
};
Lino.households.Households.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Households","GET",pk,"put",null);
};
Lino.households.Households.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Households","GET",pk,"post",null);
};

Lino.households.Households.insertPanel = Ext.extend(Lino.contacts.Partners.InsertFormPanel,{
  empty_title: "New Households",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/households/Households",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Households.detail;
    this.ls_insert_handler = Lino.households.Households.insert;
    Lino.households.Households.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Households.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.households.Households.insertPanel(p);
});
Lino.households.Households.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Households","GET",pk,"poststay",null);
};

Lino.households.Households.detailPanel = Ext.extend(Lino.households.Households.DetailFormPanel,{
  empty_title: "Detail Households",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "create_invoice", "menu_item_text": "Create invoice", "must_save": true, "tooltip": "Create invoice for this partner using invoiceable items", "panel_btn_handler": Lino.row_action_handler('create_invoice','GET',null), "iconCls": "x-tbar-money", "overflowText": "Create invoice", "auto_save": true }, { "itemId": "due", "menu_item_text": "Debts", "must_save": true, "tooltip": "Debts", "panel_btn_handler": Lino.row_action_handler('due','GET',null), "iconCls": "x-tbar-book_link", "overflowText": "Debts", "auto_save": true }, { "itemId": "show_invoiceables", "menu_item_text": "Invoices to create", "must_save": true, "tooltip": "List of invoiceable items for this partner", "panel_btn_handler": Lino.row_action_handler('show_invoiceables','GET',null), "iconCls": "x-tbar-basket", "overflowText": "Invoices to create", "auto_save": true } ],
  ls_url: "/households/Households",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Households.detail;
    this.ls_insert_handler = Lino.households.Households.insert;
    Lino.households.Households.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Households.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Households.detailPanel(p);
});
Lino.households.Households.create_invoice = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Households","GET",pk,"create_invoice",null);
};
Lino.households.Households.due = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Households","GET",pk,"due",null);
};
Lino.households.Households.show_invoiceables = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Households","GET",pk,"show_invoiceables",null);
};
Lino.households.Households.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Households.GridPanel(p);
});

// js_render_GridPanel_class households.Roles
Lino.households.Roles.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/households/Roles",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/households/Roles','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/households/Roles','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/households/Roles','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Household Roles",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "type": "boolean", "name": "name_giving" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 28,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Roles.detail;
    this.ls_insert_handler = Lino.households.Roles.insert;
    var ww = this.containing_window;
    var id2112 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2113 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de2114 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr2115 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_giving2116 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(households.Roles.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2112, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(households.Roles.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2113 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(households.Roles.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de2114 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(households.Roles.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2115 }, { "colIndex": 4, "sortable": false, "xtype": "checkcolumn", "header": "name-giving", "editable": true, "tooltip": "(households.Roles.name_giving) When the `name` field of a Household is empty, \nits value is computed by joining the `Last Name` \nof all name-giving members with a dash (\"-\").\n      ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "name_giving" } ];
    Lino.households.Roles.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Roles.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Roles","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.households.Roles.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Roles","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.households.Roles.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Roles","GET",pk,"put",null);
};
Lino.households.Roles.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Roles","GET",pk,"post",null);
};

Lino.households.Roles.insertPanel = Ext.extend(Lino.households.Roles.DetailFormPanel,{
  empty_title: "New Household Roles",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/households/Roles",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Roles.detail;
    this.ls_insert_handler = Lino.households.Roles.insert;
    Lino.households.Roles.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Roles.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.households.Roles.insertPanel(p);
});
Lino.households.Roles.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Roles","GET",pk,"poststay",null);
};

Lino.households.Roles.detailPanel = Ext.extend(Lino.households.Roles.DetailFormPanel,{
  empty_title: "Detail Household Roles",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/households/Roles",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.households.Roles.detail;
    this.ls_insert_handler = Lino.households.Roles.insert;
    Lino.households.Roles.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Roles.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Roles.detailPanel(p);
});
Lino.households.Roles.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Roles.GridPanel(p);
});

// js_render_GridPanel_class households.Members
Lino.households.Members.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/households/Members",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/households/Members','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/households/Members','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/households/Members','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Household Members",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 10,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "role" }, 'roleHidden', { "name": "household" }, 'householdHidden', { "name": "person" }, 'personHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 27,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id2118 = new Ext.form.NumberField({ "selectOnFocus": true });
    var role2119 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Members/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Household Role..." });
    var household2120 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Members/household", "method": "GET" }) }), "emptyText": "Select a Household..." });
    var person2121 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/households/Members/person", "method": "GET" }) }), "emptyText": "Select a Person..." });
    var start_date2122 = new Lino.DateField({ "selectOnFocus": true });
    var end_date2123 = new Lino.DateField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(households.Members.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2118, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Household Role", "editable": true, "tooltip": "(households.Members.role) The Role of this Person in this Household.\nList of choices is configured in `Configure --> Households --> Roles`.\n", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('roleHidden','Lino.households.Roles.detail'), "editor": role2119, "dataIndex": "role" }, { "colIndex": 2, "sortable": true, "header": "Household", "editable": true, "tooltip": "(households.Members.household) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('householdHidden','Lino.households.Households.detail'), "editor": household2120, "dataIndex": "household" }, { "colIndex": 3, "sortable": true, "header": "Person", "editable": true, "tooltip": "(households.Members.person) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('personHidden','Lino.contacts.Persons.detail'), "editor": person2121, "dataIndex": "person" }, { "colIndex": 4, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(households.Members.start_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "From", "dataIndex": "start_date", "width": Lino.chars2width(14), "editor": start_date2122 }, { "colIndex": 5, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(households.Members.end_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Until", "dataIndex": "end_date", "width": Lino.chars2width(14), "editor": end_date2123 } ];
    Lino.households.Members.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.households.Members.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Members","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.households.Members.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Members","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.households.Members.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Members","GET",pk,"put",null);
};
Lino.households.Members.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/households/Members","GET",pk,"post",null);
};
Lino.households.Members.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.households.Members.GridPanel(p);
});

// js_render_GridPanel_class accounts.Charts
Lino.accounts.Charts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/accounts/Charts",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/accounts/Charts','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/accounts/Charts','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/accounts/Charts','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Account Charts",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 5,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 35,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Charts.detail;
    this.ls_insert_handler = Lino.accounts.Charts.insert;
    var ww = this.containing_window;
    var id2125 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2126 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de2127 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr2128 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(accounts.Charts.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2125, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(accounts.Charts.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2126 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(accounts.Charts.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de2127 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(accounts.Charts.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2128 } ];
    Lino.accounts.Charts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Charts.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Charts","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.accounts.Charts.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Charts","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.accounts.Charts.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Charts","GET",pk,"put",null);
};
Lino.accounts.Charts.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Charts","GET",pk,"post",null);
};

Lino.accounts.Charts.insertPanel = Ext.extend(Lino.accounts.Charts.DetailFormPanel,{
  empty_title: "New Account Charts",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/accounts/Charts",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Charts.detail;
    this.ls_insert_handler = Lino.accounts.Charts.insert;
    Lino.accounts.Charts.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Charts.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.accounts.Charts.insertPanel(p);
});
Lino.accounts.Charts.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Charts","GET",pk,"poststay",null);
};

Lino.accounts.Charts.detailPanel = Ext.extend(Lino.accounts.Charts.DetailFormPanel,{
  empty_title: "Detail Account Charts",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/accounts/Charts",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Charts.detail;
    this.ls_insert_handler = Lino.accounts.Charts.insert;
    Lino.accounts.Charts.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Charts.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Charts.detailPanel(p);
});
Lino.accounts.Charts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Charts.GridPanel(p);
});

// js_render_GridPanel_class accounts.Groups
Lino.accounts.Groups.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/accounts/Groups",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/accounts/Groups','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/accounts/Groups','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/accounts/Groups','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Account Groups",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 10,
  ls_store_fields : [ { "name": "chart" }, 'chartHidden', { "name": "ref" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "account_type" }, 'account_typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 8,
  ls_grid_configs : [  ],
  content_type : 34,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Groups.detail;
    this.ls_insert_handler = Lino.accounts.Groups.insert;
    var ww = this.containing_window;
    var chart2130 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Groups/chart", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account Chart..." });
    var ref2131 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var name2132 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de2133 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr2134 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var account_type2135 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.accounts.AccountTypes) });
    var id2136 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Account Chart", "editable": true, "tooltip": "(accounts.Groups.chart) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('chartHidden','Lino.accounts.Charts.detail'), "editor": chart2130, "dataIndex": "chart" }, { "colIndex": 1, "sortable": true, "header": "ref", "editable": true, "tooltip": "(accounts.Groups.ref) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ref", "editor": ref2131 }, { "colIndex": 2, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(accounts.Groups.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2132 }, { "colIndex": 3, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(accounts.Groups.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de2133 }, { "colIndex": 4, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(accounts.Groups.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2134 }, { "colIndex": 5, "sortable": true, "header": "Account Type", "editable": true, "tooltip": "(accounts.Groups.account_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(17), "dataIndex": "account_type", "editor": account_type2135 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(accounts.Groups.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "hidden": true, "editor": id2136, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.accounts.Groups.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Groups.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Groups","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.accounts.Groups.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Groups","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.accounts.Groups.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Groups","GET",pk,"put",null);
};
Lino.accounts.Groups.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Groups","GET",pk,"post",null);
};

Lino.accounts.Groups.insertPanel = Ext.extend(Lino.accounts.Groups.DetailFormPanel,{
  empty_title: "New Account Groups",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/accounts/Groups",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Groups.detail;
    this.ls_insert_handler = Lino.accounts.Groups.insert;
    Lino.accounts.Groups.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Groups.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.accounts.Groups.insertPanel(p);
});
Lino.accounts.Groups.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Groups","GET",pk,"poststay",null);
};

Lino.accounts.Groups.detailPanel = Ext.extend(Lino.accounts.Groups.DetailFormPanel,{
  empty_title: "Detail Account Groups",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/accounts/Groups",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Groups.detail;
    this.ls_insert_handler = Lino.accounts.Groups.insert;
    Lino.accounts.Groups.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Groups.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Groups.detailPanel(p);
});
Lino.accounts.Groups.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Groups.GridPanel(p);
});

// js_render_GridPanel_class accounts.Accounts
Lino.accounts.Accounts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/accounts/Accounts",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/accounts/Accounts','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/accounts/Accounts','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/accounts/Accounts','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "due", "menu_item_text": "Debts", "must_save": true, "tooltip": "Debts", "panel_btn_handler": Lino.row_action_handler('due','GET',null), "iconCls": "x-tbar-book_link", "overflowText": "Debts", "auto_save": true }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-arrow_up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-arrow_down", "overflowText": "Down", "auto_save": true } ],
  cell_edit : true,
  title : "Accounts",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 17,
  ls_store_fields : [ { "name": "ref" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "group" }, 'groupHidden', { "type": "int", "name": "id" }, { "type": "int", "name": "seqno" }, { "name": "chart" }, 'chartHidden', { "name": "type" }, 'typeHidden', { "type": "boolean", "name": "sales_allowed" }, { "type": "boolean", "name": "purchases_allowed" }, { "type": "boolean", "name": "wages_allowed" }, { "type": "boolean", "name": "clearable" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 33,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Accounts.detail;
    this.ls_insert_handler = Lino.accounts.Accounts.insert;
    var ww = this.containing_window;
    var ref2138 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var name2139 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de2140 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr2141 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var group2142 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Accounts/group", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account Group..." });
    var id2143 = new Ext.form.NumberField({ "selectOnFocus": true });
    var seqno2144 = new Ext.form.NumberField({ "selectOnFocus": true });
    var chart2145 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Accounts/chart", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account Chart..." });
    var type2146 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.accounts.AccountTypes });
    var sales_allowed2147 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": true });
    var purchases_allowed2148 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": true });
    var wages_allowed2149 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": true });
    var clearable2150 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ref", "editable": true, "tooltip": "(accounts.Accounts.ref) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "ref", "editor": ref2138 }, { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(accounts.Accounts.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2139 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(accounts.Accounts.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de2140 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(accounts.Accounts.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2141 }, { "colIndex": 4, "sortable": true, "header": "Account Group", "editable": true, "tooltip": "(accounts.Accounts.group) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('groupHidden','Lino.accounts.Groups.detail'), "editor": group2142, "dataIndex": "group" }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(accounts.Accounts.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "hidden": true, "editor": id2143, "width": Lino.chars2width(6), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(accounts.Accounts.seqno) ", "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "hidden": true, "width": Lino.chars2width(6), "editor": seqno2144 }), { "colIndex": 7, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(accounts.Accounts.chart) ", "filter": { "type": "string" }, "header": "Account Chart", "renderer": Lino.fk_renderer('chartHidden','Lino.accounts.Charts.detail'), "hidden": true, "editor": chart2145, "dataIndex": "chart" }, { "colIndex": 8, "sortable": true, "header": "Account Type", "editable": true, "tooltip": "(accounts.Accounts.type) ", "filter": { "type": "string" }, "width": Lino.chars2width(17), "dataIndex": "type", "hidden": true, "editor": type2146 }, { "colIndex": 9, "sortable": false, "xtype": "checkcolumn", "header": "Sales", "editable": true, "tooltip": "(accounts.Accounts.sales_allowed) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "sales_allowed", "hidden": true }, { "colIndex": 10, "sortable": false, "xtype": "checkcolumn", "header": "Purchases", "editable": true, "tooltip": "(accounts.Accounts.purchases_allowed) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "purchases_allowed", "hidden": true }, { "colIndex": 11, "sortable": false, "xtype": "checkcolumn", "header": "Wages", "editable": true, "tooltip": "(accounts.Accounts.wages_allowed) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "wages_allowed", "hidden": true }, { "colIndex": 12, "sortable": false, "xtype": "checkcolumn", "header": "Clearable", "editable": true, "tooltip": "(accounts.Accounts.clearable) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "clearable", "hidden": true } ];
    Lino.accounts.Accounts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Accounts.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Accounts","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.accounts.Accounts.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Accounts","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.accounts.Accounts.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Accounts","GET",pk,"put",null);
};
Lino.accounts.Accounts.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Accounts","GET",pk,"post",null);
};

Lino.accounts.Accounts.insertPanel = Ext.extend(Lino.accounts.Accounts.DetailFormPanel,{
  empty_title: "New Accounts",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/accounts/Accounts",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Accounts.detail;
    this.ls_insert_handler = Lino.accounts.Accounts.insert;
    Lino.accounts.Accounts.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Accounts.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.accounts.Accounts.insertPanel(p);
});
Lino.accounts.Accounts.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Accounts","GET",pk,"poststay",null);
};
Lino.accounts.Accounts.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Accounts","GET",pk,"duplicate",null);
};

Lino.accounts.Accounts.detailPanel = Ext.extend(Lino.accounts.Accounts.DetailFormPanel,{
  empty_title: "Detail Accounts",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "due", "menu_item_text": "Debts", "must_save": true, "tooltip": "Debts", "panel_btn_handler": Lino.row_action_handler('due','GET',null), "iconCls": "x-tbar-book_link", "overflowText": "Debts", "auto_save": true }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-arrow_up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-arrow_down", "overflowText": "Down", "auto_save": true } ],
  ls_url: "/accounts/Accounts",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Accounts.detail;
    this.ls_insert_handler = Lino.accounts.Accounts.insert;
    Lino.accounts.Accounts.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Accounts.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Accounts.detailPanel(p);
});
Lino.accounts.Accounts.due = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Accounts","GET",pk,"due",null);
};
Lino.accounts.Accounts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Accounts.GridPanel(p);
});
Lino.accounts.Accounts.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Accounts","GET",pk,"move_up",null);
};
Lino.accounts.Accounts.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/accounts/Accounts","GET",pk,"move_down",null);
};

// js_render_GridPanel_class products.ProductCats
Lino.products.ProductCats.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/products/ProductCats",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/products/ProductCats','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/products/ProductCats','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/products/ProductCats','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Product Categories",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "description" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.products.ProductCats.detail;
    this.ls_insert_handler = Lino.products.ProductCats.insert;
    var ww = this.containing_window;
    var id2152 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2153 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de2154 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr2155 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var description2156 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(products.ProductCats.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2152, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(products.ProductCats.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2153 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(products.ProductCats.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de2154 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(products.ProductCats.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2155 }, { "colIndex": 4, "sortable": false, "header": "description", "editable": true, "tooltip": "(products.ProductCats.description) ", "filter": { "type": "string" }, "width": Lino.chars2width(61), "renderer": Lino.text_renderer, "editor": description2156, "dataIndex": "description" } ];
    Lino.products.ProductCats.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.products.ProductCats.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/ProductCats","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.products.ProductCats.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/ProductCats","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.products.ProductCats.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/ProductCats","GET",pk,"put",null);
};
Lino.products.ProductCats.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/ProductCats","GET",pk,"post",null);
};

Lino.products.ProductCats.insertPanel = Ext.extend(Lino.products.ProductCats.DetailFormPanel,{
  empty_title: "New Product Categories",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/products/ProductCats",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.products.ProductCats.detail;
    this.ls_insert_handler = Lino.products.ProductCats.insert;
    Lino.products.ProductCats.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.products.ProductCats.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.products.ProductCats.insertPanel(p);
});
Lino.products.ProductCats.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/ProductCats","GET",pk,"poststay",null);
};

Lino.products.ProductCats.detailPanel = Ext.extend(Lino.products.ProductCats.DetailFormPanel,{
  empty_title: "Detail Product Categories",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/products/ProductCats",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.products.ProductCats.detail;
    this.ls_insert_handler = Lino.products.ProductCats.insert;
    Lino.products.ProductCats.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.products.ProductCats.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.products.ProductCats.detailPanel(p);
});
Lino.products.ProductCats.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.products.ProductCats.GridPanel(p);
});

// js_render_GridPanel_class products.Products
Lino.products.Products.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/products/Products",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/products/Products','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/products/Products','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/products/Products','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Products",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 14,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "cat" }, 'catHidden', { "name": "vat_class" }, 'vat_classHidden', { "name": "sales_price" }, { "name": "sales_account" }, 'sales_accountHidden', { "name": "purchases_account" }, 'purchases_accountHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 32,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.products.Products.detail;
    this.ls_insert_handler = Lino.products.Products.insert;
    var ww = this.containing_window;
    var id2158 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2159 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de2160 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr2161 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var cat2162 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/products/Products/cat", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Product Category..." });
    var vat_class2163 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.vat.VatClasses) });
    var sales_price2164 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var sales_account2165 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/products/Products/sales_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var purchases_account2166 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/products/Products/purchases_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(products.Products.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2158, "width": Lino.chars2width(4), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(products.Products.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2159 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(products.Products.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de2160 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(products.Products.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2161 }, { "colIndex": 4, "sortable": true, "header": "Category", "editable": true, "tooltip": "(products.Products.cat) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('catHidden','Lino.products.ProductCats.detail'), "editor": cat2162, "dataIndex": "cat" }, { "colIndex": 5, "sortable": true, "header": "VAT Class", "editable": true, "tooltip": "(products.Products.vat_class) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "vat_class", "editor": vat_class2163 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "header": "Sales price", "editable": true, "tooltip": "(products.Products.sales_price) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(7), "dataIndex": "sales_price", "editor": sales_price2164 }), { "colIndex": 7, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(products.Products.sales_account) ", "filter": { "type": "string" }, "header": "Sales Base account", "renderer": Lino.fk_renderer('sales_accountHidden','Lino.accounts.Accounts.detail'), "hidden": true, "editor": sales_account2165, "dataIndex": "sales_account" }, { "colIndex": 8, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(products.Products.purchases_account) ", "filter": { "type": "string" }, "header": "Purchases Base account", "renderer": Lino.fk_renderer('purchases_accountHidden','Lino.accounts.Accounts.detail'), "hidden": true, "editor": purchases_account2166, "dataIndex": "purchases_account" } ];
    Lino.products.Products.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.products.Products.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/Products","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.products.Products.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/Products","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.products.Products.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/Products","GET",pk,"put",null);
};
Lino.products.Products.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/Products","GET",pk,"post",null);
};

Lino.products.Products.insertPanel = Ext.extend(Lino.products.Products.DetailFormPanel,{
  empty_title: "New Products",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/products/Products",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.products.Products.detail;
    this.ls_insert_handler = Lino.products.Products.insert;
    Lino.products.Products.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.products.Products.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.products.Products.insertPanel(p);
});
Lino.products.Products.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/products/Products","GET",pk,"poststay",null);
};

Lino.products.Products.detailPanel = Ext.extend(Lino.products.Products.DetailFormPanel,{
  empty_title: "Detail Products",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/products/Products",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.products.Products.detail;
    this.ls_insert_handler = Lino.products.Products.insert;
    Lino.products.Products.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.products.Products.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.products.Products.detailPanel(p);
});
Lino.products.Products.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.products.Products.GridPanel(p);
});

// js_render_GridPanel_class ledger.Journals
Lino.ledger.Journals.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/ledger/Journals",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/ledger/Journals','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/Journals','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/Journals','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-arrow_up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-arrow_down", "overflowText": "Down", "auto_save": true } ],
  cell_edit : true,
  title : "Journals",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 23,
  ls_store_fields : [ { "name": "ref" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "trade_type" }, 'trade_typeHidden', { "name": "voucher_type" }, 'voucher_typeHidden', { "type": "boolean", "name": "force_sequence" }, { "name": "build_method" }, 'build_methodHidden', { "name": "template" }, { "name": "chart" }, 'chartHidden', { "name": "account" }, 'accountHidden', { "name": "printed_name" }, { "name": "printed_name_de" }, { "name": "printed_name_fr" }, { "type": "boolean", "name": "dc" }, { "type": "int", "name": "seqno" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 21,
  ls_grid_configs : [  ],
  content_type : 36,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Journals.detail;
    this.ls_insert_handler = Lino.ledger.Journals.insert;
    var ww = this.containing_window;
    var ref2168 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var name2169 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de2170 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr2171 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var trade_type2172 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.vat.TradeTypes) });
    var voucher_type2173 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.ledger.VoucherTypes });
    var force_sequence2174 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var build_method2175 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template2176 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Journals/template", "method": "GET" }) }) });
    var chart2177 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Journals/chart", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account Chart..." });
    var account2178 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Journals/account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var printed_name2179 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var printed_name_de2180 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var printed_name_fr2181 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var dc2182 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": null });
    var seqno2183 = new Ext.form.NumberField({ "selectOnFocus": true });
    var id2184 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      template2176.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      template2176.setContextValue('voucher_type',record ? record.data['voucher_typeHidden'] : undefined);
      account2178.setContextValue('chart',record ? record.data['chartHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      build_method2175.on('change',Lino.chooser_handler(template2176,'build_method'));
      voucher_type2173.on('change',Lino.chooser_handler(template2176,'voucher_type'));
      chart2177.on('change',Lino.chooser_handler(account2178,'chart'));
      Lino.ledger.Journals.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ref", "editable": true, "tooltip": "(ledger.Journals.ref) ", "filter": { "type": "string" }, "width": Lino.chars2width(6), "dataIndex": "ref", "editor": ref2168 }, { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(ledger.Journals.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2169 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(ledger.Journals.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de2170 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(ledger.Journals.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2171 }, { "colIndex": 4, "sortable": true, "header": "Trade Type", "editable": true, "tooltip": "(ledger.Journals.trade_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "trade_type", "editor": trade_type2172 }, { "colIndex": 5, "sortable": true, "header": "voucher type", "editable": true, "tooltip": "(ledger.Journals.voucher_type) ", "filter": { "type": "string" }, "width": Lino.chars2width(35), "dataIndex": "voucher_type", "editor": voucher_type2173 }, { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "Force chronological sequence", "editable": true, "tooltip": "(ledger.Journals.force_sequence) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "force_sequence" }, { "colIndex": 7, "sortable": true, "header": "Build method", "editable": true, "tooltip": "(ledger.Journals.build_method) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "build_method", "hidden": true, "editor": build_method2175 }, { "colIndex": 8, "sortable": true, "header": "Template", "editable": true, "tooltip": "(ledger.Journals.template) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "template", "hidden": true, "editor": template2176 }, { "colIndex": 9, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(ledger.Journals.chart) ", "filter": { "type": "string" }, "header": "Account Chart", "renderer": Lino.fk_renderer('chartHidden','Lino.accounts.Charts.detail'), "hidden": true, "editor": chart2177, "dataIndex": "chart" }, { "colIndex": 10, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(ledger.Journals.account) ", "filter": { "type": "string" }, "header": "Account", "renderer": Lino.fk_renderer('accountHidden','Lino.accounts.Accounts.detail'), "hidden": true, "editor": account2178, "dataIndex": "account" }, { "colIndex": 11, "sortable": true, "header": "printed name", "editable": true, "tooltip": "(ledger.Journals.printed_name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "printed_name", "hidden": true, "editor": printed_name2179 }, { "colIndex": 12, "sortable": true, "header": "printed name (de)", "editable": true, "tooltip": "(ledger.Journals.printed_name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "printed_name_de", "hidden": true, "editor": printed_name_de2180 }, { "colIndex": 13, "sortable": true, "header": "printed name (fr)", "editable": true, "tooltip": "(ledger.Journals.printed_name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "printed_name_fr", "hidden": true, "editor": printed_name_fr2181 }, { "colIndex": 14, "sortable": false, "xtype": "checkcolumn", "header": "dc", "editable": true, "tooltip": "(ledger.Journals.dc) Debit (checked) or Credit (not checked)", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "dc", "hidden": true }, new Lino.NullNumberColumn({ "colIndex": 15, "sortable": true, "format": "0", "editable": true, "tooltip": "(ledger.Journals.seqno) ", "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "width": Lino.chars2width(6), "editor": seqno2183 }), new Lino.NullNumberColumn({ "colIndex": 16, "sortable": true, "format": "0", "editable": true, "tooltip": "(ledger.Journals.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2184, "width": Lino.chars2width(6), "dataIndex": "id" }) ];
    Lino.ledger.Journals.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Journals.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Journals","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.ledger.Journals.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Journals","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.ledger.Journals.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Journals","GET",pk,"put",null);
};
Lino.ledger.Journals.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Journals","GET",pk,"post",null);
};

Lino.ledger.Journals.insertPanel = Ext.extend(Lino.ledger.Journals.InsertFormPanel,{
  empty_title: "New Journals",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/ledger/Journals",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Journals.detail;
    this.ls_insert_handler = Lino.ledger.Journals.insert;
    Lino.ledger.Journals.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Journals.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.ledger.Journals.insertPanel(p);
});
Lino.ledger.Journals.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Journals","GET",pk,"poststay",null);
};
Lino.ledger.Journals.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Journals","GET",pk,"duplicate",null);
};

Lino.ledger.Journals.detailPanel = Ext.extend(Lino.ledger.Journals.DetailFormPanel,{
  empty_title: "Detail Journals",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "move_up", "menu_item_text": "Up", "must_save": true, "tooltip": "Move this row one row upwards", "panel_btn_handler": Lino.row_action_handler('move_up','GET',null), "iconCls": "x-tbar-arrow_up", "overflowText": "Up", "auto_save": true }, { "itemId": "move_down", "menu_item_text": "Down", "must_save": true, "tooltip": "Move this row one row downwards", "panel_btn_handler": Lino.row_action_handler('move_down','GET',null), "iconCls": "x-tbar-arrow_down", "overflowText": "Down", "auto_save": true } ],
  ls_url: "/ledger/Journals",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Journals.detail;
    this.ls_insert_handler = Lino.ledger.Journals.insert;
    Lino.ledger.Journals.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Journals.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.Journals.detailPanel(p);
});
Lino.ledger.Journals.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.Journals.GridPanel(p);
});
Lino.ledger.Journals.move_up = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Journals","GET",pk,"move_up",null);
};
Lino.ledger.Journals.move_down = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Journals","GET",pk,"move_down",null);
};

// js_render_GridPanel_class ledger.Vouchers
Lino.ledger.Vouchers.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "emptyText": "No data to display." },
  ls_url : "/ledger/Vouchers",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/ledger/Vouchers','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/Vouchers','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/Vouchers','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" } ],
  cell_edit : true,
  title : "Vouchers",
  page_length : 20,
  stripeRows : true,
  disable_editing : true,
  disabled_actions_index : 10,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "type": "int", "name": "number" }, { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "journal" }, 'journalHidden', { "name": "year" }, 'yearHidden', { "name": "narration" }, { "name": "disabled_actions" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 39,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var date2186 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var number2187 = new Ext.form.NumberField({ "selectOnFocus": true });
    var id2188 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user2189 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Vouchers/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var journal2190 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Vouchers/journal", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Journal..." });
    var year2191 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var narration2192 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(ledger.Vouchers.date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "date", "width": Lino.chars2width(14), "editor": date2186 }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "format": "0", "editable": true, "tooltip": "(ledger.Vouchers.number) ", "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(6), "editor": number2187 }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(ledger.Vouchers.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "hidden": true, "editor": id2188, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 3, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(ledger.Vouchers.user) ", "filter": { "type": "string" }, "header": "Author", "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "hidden": true, "editor": user2189, "dataIndex": "user" }, { "colIndex": 4, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(ledger.Vouchers.journal) ", "filter": { "type": "string" }, "header": "Journal", "renderer": Lino.fk_renderer('journalHidden','Lino.ledger.Journals.detail'), "hidden": true, "editor": journal2190, "dataIndex": "journal" }, { "colIndex": 5, "sortable": true, "header": "Fiscal Year", "editable": true, "tooltip": "(ledger.Vouchers.year) ", "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "year", "hidden": true, "editor": year2191 }, { "colIndex": 6, "sortable": true, "header": "Narration", "editable": true, "tooltip": "(ledger.Vouchers.narration) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "narration", "hidden": true, "editor": narration2192 } ];
    Lino.ledger.Vouchers.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Vouchers.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Vouchers","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.ledger.Vouchers.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Vouchers","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.ledger.Vouchers.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.Vouchers.GridPanel(p);
});

// js_render_GridPanel_class ledger.Movements
Lino.ledger.Movements.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "emptyText": "No data to display." },
  ls_url : "/ledger/Movements",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/ledger/Movements','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/Movements','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/Movements','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" } ],
  cell_edit : true,
  title : "Movements",
  page_length : 20,
  stripeRows : true,
  disable_editing : true,
  disabled_actions_index : 15,
  ls_store_fields : [ { "name": "voucher_link" }, { "name": "account" }, 'accountHidden', { "name": "debit" }, { "name": "credit" }, { "type": "int", "name": "id" }, { "name": "voucher" }, 'voucherHidden', { "type": "int", "name": "seqno" }, { "name": "partner" }, 'partnerHidden', { "name": "amount" }, { "type": "boolean", "name": "dc" }, { "name": "match" }, { "type": "boolean", "name": "satisfied" }, { "name": "disabled_actions" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 40,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var voucher_link_disp2194 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var account2195 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Movements/account", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account..." });
    var debit2196 = new Ext.form.NumberField({ "disabled": true, "decimalPrecision": 2, "decimalSeparator": "," });
    var credit2197 = new Ext.form.NumberField({ "disabled": true, "decimalPrecision": 2, "decimalSeparator": "," });
    var id2198 = new Ext.form.NumberField({ "selectOnFocus": true });
    var voucher2199 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Movements/voucher", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Voucher..." });
    var seqno2200 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false });
    var partner2201 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 20, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Movements/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var amount2202 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalSeparator": ",", "decimalPrecision": 2, "allowBlank": false, "value": 0 });
    var dc2203 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": null });
    var match2204 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Movements/match", "method": "GET" }) }) });
    var satisfied2205 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
      match2204.setContextValue('partner',record ? record.data['partnerHidden'] : undefined);
      match2204.setContextValue('account',record ? record.data['accountHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      partner2201.on('change',Lino.chooser_handler(match2204,'partner'));
      account2195.on('change',Lino.chooser_handler(match2204,'account'));
      Lino.ledger.Movements.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(31), "colIndex": 0, "sortable": false, "dataIndex": "voucher_link", "header": "Voucher", "editable": false, "tooltip": "(ledger.Movements.voucher_link) " }, { "colIndex": 1, "sortable": true, "header": "Account", "editable": true, "tooltip": "(ledger.Movements.account) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('accountHidden','Lino.accounts.Accounts.detail'), "editor": account2195, "dataIndex": "account" }, new Lino.NullNumberColumn({ "width": Lino.chars2width(13), "colIndex": 2, "sortable": false, "dataIndex": "debit", "header": "Debit", "editable": false, "tooltip": "(ledger.Movements.debit) " }), new Lino.NullNumberColumn({ "width": Lino.chars2width(13), "colIndex": 3, "sortable": false, "dataIndex": "credit", "header": "Credit", "editable": false, "tooltip": "(ledger.Movements.credit) " }), new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(ledger.Movements.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "hidden": true, "editor": id2198, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Voucher", "editable": true, "tooltip": "(ledger.Movements.voucher) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "voucher", "hidden": true, "editor": voucher2199 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "tooltip": "(ledger.Movements.seqno) ", "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "hidden": true, "width": Lino.chars2width(6), "editor": seqno2200 }), { "colIndex": 7, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(ledger.Movements.partner) ", "filter": { "type": "string" }, "header": "Partner", "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "hidden": true, "editor": partner2201, "dataIndex": "partner" }, new Lino.NullNumberColumn({ "colIndex": 8, "sortable": true, "header": "amount", "editable": true, "tooltip": "(ledger.Movements.amount) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "amount", "hidden": true, "editor": amount2202 }), { "colIndex": 9, "sortable": false, "xtype": "checkcolumn", "header": "dc", "editable": true, "tooltip": "(ledger.Movements.dc) Debit (checked) or Credit (not checked)", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "dc", "hidden": true }, { "colIndex": 10, "sortable": true, "header": "Match", "editable": true, "tooltip": "(ledger.Movements.match) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "match", "hidden": true, "editor": match2204 }, { "colIndex": 11, "sortable": false, "xtype": "checkcolumn", "header": "Satisfied", "editable": true, "tooltip": "(ledger.Movements.satisfied) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "satisfied", "hidden": true } ];
    Lino.ledger.Movements.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Movements.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Movements","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.ledger.Movements.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Movements","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.ledger.Movements.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.ledger.Movements.ParamsPanel({});
  return new Lino.ledger.Movements.GridPanel(p);
});

// js_render_GridPanel_class ledger.Invoices
Lino.ledger.Invoices.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/ledger/Invoices",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/ledger/Invoices','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/Invoices','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/ledger/Invoices','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Invoices",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 23,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "type": "int", "name": "id" }, { "type": "int", "name": "number" }, { "name": "partner" }, 'partnerHidden', { "name": "total_incl" }, { "name": "user" }, 'userHidden', { "name": "journal" }, 'journalHidden', { "name": "year" }, 'yearHidden', { "name": "narration" }, { "name": "total_base" }, { "name": "total_vat" }, { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "match" }, { "name": "your_ref" }, { "type": "date", "name": "due_date", "dateFormat": "d.m.Y" }, { "name": "state" }, 'stateHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 1,
  ls_grid_configs : [  ],
  content_type : 39,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Invoices.detail;
    this.ls_insert_handler = Lino.ledger.Invoices.insert;
    var ww = this.containing_window;
    var date2207 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var id2208 = new Ext.form.NumberField({ "selectOnFocus": true });
    var number2209 = new Ext.form.NumberField({ "selectOnFocus": true });
    var partner2210 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/partner", "method": "GET" }) }), "emptyText": "Select a Partner..." });
    var total_incl2211 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var user2212 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var journal2213 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/journal", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Journal..." });
    var year2214 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var narration2215 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var total_base2216 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat2217 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var vat_regime2218 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.vat.VatRegimes });
    var match2219 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/match", "method": "GET" }) }) });
    var your_ref2220 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var due_date2221 = new Lino.DateField({ "selectOnFocus": true });
    var state2222 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.ledger.InvoiceStates });
    this.before_row_edit = function(record) {
      match2219.setContextValue('partner',record ? record.data['partnerHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      partner2210.on('change',Lino.chooser_handler(match2219,'partner'));
      Lino.ledger.Invoices.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(ledger.Invoices.date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "date", "width": Lino.chars2width(14), "editor": date2207 }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "format": "0", "editable": true, "tooltip": "(ledger.Invoices.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2208, "width": Lino.chars2width(6), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "tooltip": "(ledger.Invoices.number) ", "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(6), "editor": number2209 }), { "colIndex": 3, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(ledger.Invoices.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2210, "dataIndex": "partner" }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "header": "Total incl. VAT", "editable": true, "tooltip": "(ledger.Invoices.total_incl) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_incl", "editor": total_incl2211 }), { "colIndex": 5, "sortable": true, "header": "Author", "editable": true, "tooltip": "(ledger.Invoices.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2212, "dataIndex": "user" }, { "colIndex": 6, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(ledger.Invoices.journal) ", "filter": { "type": "string" }, "header": "Journal", "renderer": Lino.fk_renderer('journalHidden','Lino.ledger.Journals.detail'), "hidden": true, "editor": journal2213, "dataIndex": "journal" }, { "colIndex": 7, "sortable": true, "header": "Fiscal Year", "editable": true, "tooltip": "(ledger.Invoices.year) ", "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "year", "hidden": true, "editor": year2214 }, { "colIndex": 8, "sortable": true, "header": "Narration", "editable": true, "tooltip": "(ledger.Invoices.narration) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "narration", "hidden": true, "editor": narration2215 }, new Lino.NullNumberColumn({ "colIndex": 9, "sortable": true, "header": "Total excl. VAT", "editable": true, "tooltip": "(ledger.Invoices.total_base) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_base", "hidden": true, "editor": total_base2216 }), new Lino.NullNumberColumn({ "colIndex": 10, "sortable": true, "header": "VAT", "editable": true, "tooltip": "(ledger.Invoices.total_vat) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_vat", "hidden": true, "editor": total_vat2217 }), { "colIndex": 11, "sortable": true, "header": "VAT Regime", "editable": true, "tooltip": "(ledger.Invoices.vat_regime) ", "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "vat_regime", "hidden": true, "editor": vat_regime2218 }, { "colIndex": 12, "sortable": true, "header": "Match", "editable": true, "tooltip": "(ledger.Invoices.match) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "match", "hidden": true, "editor": match2219 }, { "colIndex": 13, "sortable": true, "header": "Your reference", "editable": true, "tooltip": "(ledger.Invoices.your_ref) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "your_ref", "hidden": true, "editor": your_ref2220 }, { "colIndex": 14, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(ledger.Invoices.due_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Due date", "dataIndex": "due_date", "hidden": true, "width": Lino.chars2width(14), "editor": due_date2221 }, { "colIndex": 15, "sortable": true, "header": "State", "editable": true, "tooltip": "(ledger.Invoices.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(14), "dataIndex": "state", "hidden": true, "editor": state2222 } ];
    Lino.ledger.Invoices.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Invoices.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Invoices","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.ledger.Invoices.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Invoices","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.ledger.Invoices.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Invoices","GET",pk,"put",null);
};
Lino.ledger.Invoices.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Invoices","GET",pk,"post",null);
};

Lino.ledger.Invoices.insertPanel = Ext.extend(Lino.ledger.Invoices.InsertFormPanel,{
  empty_title: "New Invoices",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/ledger/Invoices",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Invoices.detail;
    this.ls_insert_handler = Lino.ledger.Invoices.insert;
    Lino.ledger.Invoices.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Invoices.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.ledger.Invoices.insertPanel(p);
});
Lino.ledger.Invoices.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Invoices","GET",pk,"wf1",null);
};
Lino.ledger.Invoices.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Invoices","GET",pk,"poststay",null);
};
Lino.ledger.Invoices.wf2 = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Invoices","GET",pk,"wf2",null);
};

Lino.ledger.Invoices.detailPanel = Ext.extend(Lino.ledger.Invoices.DetailFormPanel,{
  empty_title: "Detail Invoices",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/ledger/Invoices",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Invoices.detail;
    this.ls_insert_handler = Lino.ledger.Invoices.insert;
    Lino.ledger.Invoices.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Invoices.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.Invoices.detailPanel(p);
});
Lino.ledger.Invoices.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.ledger.Invoices.ParamsPanel({});
  return new Lino.ledger.Invoices.GridPanel(p);
});

// js_render_GridPanel_class sales.PaymentTerms
Lino.sales.PaymentTerms.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/sales/PaymentTerms",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/sales/PaymentTerms','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/PaymentTerms','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/PaymentTerms','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Payment Terms",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 8,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "type": "int", "name": "days" }, { "type": "int", "name": "months" }, { "type": "boolean", "name": "end_of_month" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 45,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id2224 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2225 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de2226 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr2227 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var days2228 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var months2229 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var end_of_month2230 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(sales.PaymentTerms.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2224, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(sales.PaymentTerms.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2225 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(sales.PaymentTerms.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de2226 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(sales.PaymentTerms.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2227 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "tooltip": "(sales.PaymentTerms.days) ", "filter": { "type": "numeric" }, "header": "days", "dataIndex": "days", "width": Lino.chars2width(6), "editor": days2228 }), new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "tooltip": "(sales.PaymentTerms.months) ", "filter": { "type": "numeric" }, "header": "months", "dataIndex": "months", "width": Lino.chars2width(6), "editor": months2229 }), { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "end of month", "editable": true, "tooltip": "(sales.PaymentTerms.end_of_month) ", "filter": { "type": "boolean" }, "width": Lino.chars2width(11), "dataIndex": "end_of_month" } ];
    Lino.sales.PaymentTerms.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.PaymentTerms.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/PaymentTerms","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.sales.PaymentTerms.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/PaymentTerms","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.sales.PaymentTerms.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/PaymentTerms","GET",pk,"put",null);
};
Lino.sales.PaymentTerms.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/PaymentTerms","GET",pk,"post",null);
};
Lino.sales.PaymentTerms.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.PaymentTerms.GridPanel(p);
});

// js_render_GridPanel_class sales.InvoicingModes
Lino.sales.InvoicingModes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/sales/InvoicingModes",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/sales/InvoicingModes','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/InvoicingModes','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/InvoicingModes','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Invoicing Modes",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 10,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "build_method" }, 'build_methodHidden', { "name": "template" }, { "name": "price" }, { "type": "int", "name": "advance_days" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 41,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id2232 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2233 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de2234 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr2235 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var build_method2236 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template2237 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoicingModes/template", "method": "GET" }) }) });
    var price2238 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var advance_days2239 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    this.before_row_edit = function(record) {
      template2237.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      build_method2236.on('change',Lino.chooser_handler(template2237,'build_method'));
      Lino.sales.InvoicingModes.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(sales.InvoicingModes.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2232, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(sales.InvoicingModes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2233 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(sales.InvoicingModes.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de2234 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(sales.InvoicingModes.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2235 }, { "colIndex": 4, "sortable": true, "header": "Build method", "editable": true, "tooltip": "(sales.InvoicingModes.build_method) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "build_method", "editor": build_method2236 }, { "colIndex": 5, "sortable": true, "header": "Template", "editable": true, "tooltip": "(sales.InvoicingModes.template) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "template", "editor": template2237 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "header": "price", "editable": true, "tooltip": "(sales.InvoicingModes.price) Additional fee charged when using this invoicing mode.", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "price", "editor": price2238 }), new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "format": "0", "editable": true, "tooltip": "(sales.InvoicingModes.advance_days) \nHow many days in advance invoices should be posted so that the customer\nhas a chance to pay them in time.", "filter": { "type": "numeric" }, "header": "advance days", "dataIndex": "advance_days", "width": Lino.chars2width(6), "editor": advance_days2239 }) ];
    Lino.sales.InvoicingModes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.InvoicingModes.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoicingModes","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.sales.InvoicingModes.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoicingModes","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.sales.InvoicingModes.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoicingModes","GET",pk,"put",null);
};
Lino.sales.InvoicingModes.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoicingModes","GET",pk,"post",null);
};
Lino.sales.InvoicingModes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.InvoicingModes.GridPanel(p);
});

// js_render_GridPanel_class sales.ShippingModes
Lino.sales.ShippingModes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/sales/ShippingModes",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/sales/ShippingModes','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/ShippingModes','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/ShippingModes','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Shipping Modes",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 6,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "price" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 46,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    var ww = this.containing_window;
    var id2241 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name2242 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de2243 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr2244 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var price2245 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(sales.ShippingModes.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2241, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(sales.ShippingModes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2242 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(sales.ShippingModes.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de2243 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(sales.ShippingModes.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2244 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "header": "price", "editable": true, "tooltip": "(sales.ShippingModes.price) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "price", "editor": price2245 }) ];
    Lino.sales.ShippingModes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.ShippingModes.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/ShippingModes","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.sales.ShippingModes.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/ShippingModes","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.sales.ShippingModes.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/ShippingModes","GET",pk,"put",null);
};
Lino.sales.ShippingModes.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/ShippingModes","GET",pk,"post",null);
};
Lino.sales.ShippingModes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.ShippingModes.GridPanel(p);
});

// js_render_GridPanel_class sales.Invoices
Lino.sales.Invoices.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/sales/Invoices",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/sales/Invoices','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/Invoices','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/Invoices','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.list_action_handler('/sales/Invoices','do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Clear cache", "auto_save": true } ],
  cell_edit : true,
  title : "Invoices",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 35,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "partner" }, 'partnerHidden', { "name": "total_incl" }, { "name": "user" }, 'userHidden', { "name": "journal" }, 'journalHidden', { "name": "year" }, 'yearHidden', { "type": "int", "name": "number" }, { "name": "narration" }, { "name": "build_time" }, { "name": "total_base" }, { "name": "total_vat" }, { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "match" }, { "name": "language" }, 'languageHidden', { "name": "your_ref" }, { "name": "imode" }, 'imodeHidden', { "name": "shipping_mode" }, 'shipping_modeHidden', { "name": "payment_term" }, 'payment_termHidden', { "name": "subject" }, { "name": "intro" }, { "name": "discount" }, { "type": "date", "name": "due_date", "dateFormat": "d.m.Y" }, { "name": "state" }, 'stateHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 39,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.Invoices.detail;
    this.ls_insert_handler = Lino.sales.Invoices.insert;
    var ww = this.containing_window;
    var id2247 = new Ext.form.NumberField({ "selectOnFocus": true });
    var date2248 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var partner2249 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/partner", "method": "GET" }) }), "emptyText": "Select a Partner..." });
    var total_incl2250 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var user2251 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "preferred_width": 15, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var journal2252 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/journal", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Journal..." });
    var year2253 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [['','<br>']].concat(Lino.ledger.FiscalYears) });
    var number2254 = new Ext.form.NumberField({ "selectOnFocus": true });
    var narration2255 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var build_time2256 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var total_base2257 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat2258 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var vat_regime2259 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.vat.VatRegimes });
    var match2260 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/match", "method": "GET" }) }) });
    var language2261 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ] });
    var your_ref2262 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var imode2263 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Invoicing Mode..." });
    var shipping_mode2264 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/shipping_mode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Shipping Mode..." });
    var payment_term2265 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Payment Term..." });
    var subject2266 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var intro2267 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var discount2268 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var due_date2269 = new Lino.DateField({ "selectOnFocus": true });
    var state2270 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.sales.InvoiceStates });
    this.before_row_edit = function(record) {
      match2260.setContextValue('partner',record ? record.data['partnerHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      partner2249.on('change',Lino.chooser_handler(match2260,'partner'));
      Lino.sales.Invoices.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(sales.Invoices.id) ", "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id2247, "width": Lino.chars2width(6), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(sales.Invoices.date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "date", "width": Lino.chars2width(14), "editor": date2248 }, { "colIndex": 2, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(sales.Invoices.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2249, "dataIndex": "partner" }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "header": "Total incl. VAT", "editable": true, "tooltip": "(sales.Invoices.total_incl) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_incl", "editor": total_incl2250 }), { "colIndex": 4, "sortable": true, "header": "Author", "editable": true, "tooltip": "(sales.Invoices.user) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user2251, "dataIndex": "user" }, { "colIndex": 5, "sortable": true, "width": Lino.chars2width(21), "editable": true, "tooltip": "(sales.Invoices.journal) ", "filter": { "type": "string" }, "header": "Journal", "renderer": Lino.fk_renderer('journalHidden','Lino.ledger.Journals.detail'), "hidden": true, "editor": journal2252, "dataIndex": "journal" }, { "colIndex": 6, "sortable": true, "header": "Fiscal Year", "editable": true, "tooltip": "(sales.Invoices.year) ", "filter": { "type": "string" }, "width": Lino.chars2width(8), "dataIndex": "year", "hidden": true, "editor": year2253 }, new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "format": "0", "editable": true, "tooltip": "(sales.Invoices.number) ", "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "hidden": true, "width": Lino.chars2width(6), "editor": number2254 }), { "colIndex": 8, "sortable": true, "header": "Narration", "editable": true, "tooltip": "(sales.Invoices.narration) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "narration", "hidden": true, "editor": narration2255 }, { "colIndex": 9, "sortable": true, "header": "build time", "editable": false, "tooltip": "(sales.Invoices.build_time) ", "width": Lino.chars2width(17), "dataIndex": "build_time", "hidden": true }, new Lino.NullNumberColumn({ "colIndex": 10, "sortable": true, "header": "Total excl. VAT", "editable": true, "tooltip": "(sales.Invoices.total_base) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_base", "hidden": true, "editor": total_base2257 }), new Lino.NullNumberColumn({ "colIndex": 11, "sortable": true, "header": "VAT", "editable": true, "tooltip": "(sales.Invoices.total_vat) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_vat", "hidden": true, "editor": total_vat2258 }), { "colIndex": 12, "sortable": true, "header": "VAT Regime", "editable": true, "tooltip": "(sales.Invoices.vat_regime) ", "filter": { "type": "string" }, "width": Lino.chars2width(19), "dataIndex": "vat_regime", "hidden": true, "editor": vat_regime2259 }, { "colIndex": 13, "sortable": true, "header": "Match", "editable": true, "tooltip": "(sales.Invoices.match) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "match", "hidden": true, "editor": match2260 }, { "colIndex": 14, "sortable": true, "header": "Language", "editable": true, "tooltip": "(sales.Invoices.language) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "language", "hidden": true, "editor": language2261 }, { "colIndex": 15, "sortable": true, "header": "Your reference", "editable": true, "tooltip": "(sales.Invoices.your_ref) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "your_ref", "hidden": true, "editor": your_ref2262 }, { "colIndex": 16, "sortable": true, "header": "Invoicing Mode", "editable": true, "tooltip": "(sales.Invoices.imode) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "imode", "hidden": true, "editor": imode2263 }, { "colIndex": 17, "sortable": true, "header": "Shipping Mode", "editable": true, "tooltip": "(sales.Invoices.shipping_mode) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "shipping_mode", "hidden": true, "editor": shipping_mode2264 }, { "colIndex": 18, "sortable": true, "header": "Payment Term", "editable": true, "tooltip": "(sales.Invoices.payment_term) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "payment_term", "hidden": true, "editor": payment_term2265 }, { "colIndex": 19, "sortable": true, "header": "Subject line", "editable": true, "tooltip": "(sales.Invoices.subject) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "subject", "hidden": true, "editor": subject2266 }, { "colIndex": 20, "sortable": false, "width": Lino.chars2width(61), "editable": true, "tooltip": "(sales.Invoices.intro) ", "filter": { "type": "string" }, "header": "Introductive Text", "renderer": Lino.text_renderer, "hidden": true, "editor": intro2267, "dataIndex": "intro" }, new Lino.NullNumberColumn({ "colIndex": 21, "sortable": true, "header": "Discount", "editable": true, "tooltip": "(sales.Invoices.discount) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(8), "dataIndex": "discount", "hidden": true, "editor": discount2268 }), { "colIndex": 22, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(sales.Invoices.due_date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date of payment", "dataIndex": "due_date", "hidden": true, "width": Lino.chars2width(14), "editor": due_date2269 }, { "colIndex": 23, "sortable": true, "header": "State", "editable": true, "tooltip": "(sales.Invoices.state) ", "filter": { "type": "string" }, "width": Lino.chars2width(14), "dataIndex": "state", "hidden": true, "editor": state2270 } ];
    Lino.sales.Invoices.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.Invoices.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/Invoices","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.sales.Invoices.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/Invoices","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.sales.Invoices.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/Invoices","GET",pk,"put",null);
};
Lino.sales.Invoices.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/Invoices","GET",pk,"post",null);
};

Lino.sales.Invoices.insertPanel = Ext.extend(Lino.sales.Invoices.InsertFormPanel,{
  empty_title: "New Invoices",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/sales/Invoices",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.Invoices.detail;
    this.ls_insert_handler = Lino.sales.Invoices.insert;
    Lino.sales.Invoices.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.Invoices.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.sales.Invoices.insertPanel(p);
});
Lino.sales.Invoices.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/Invoices","GET",pk,"wf1",null);
};
Lino.sales.Invoices.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/Invoices","GET",pk,"poststay",null);
};
Lino.sales.Invoices.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/Invoices","GET",pk,"duplicate",null);
};
Lino.sales.Invoices.wf2 = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/Invoices","GET",pk,"wf2",null);
};

Lino.sales.Invoices.detailPanel = Ext.extend(Lino.sales.Invoices.DetailFormPanel,{
  empty_title: "Detail Invoices",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.list_action_handler('/sales/Invoices','do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Clear cache", "auto_save": true } ],
  ls_url: "/sales/Invoices",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.Invoices.detail;
    this.ls_insert_handler = Lino.sales.Invoices.insert;
    Lino.sales.Invoices.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.Invoices.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.Invoices.detailPanel(p);
});
Lino.sales.Invoices.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/Invoices","POST",pk,"do_print",null);
};
Lino.sales.Invoices.do_clear_cache = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/Invoices","GET",pk,"do_clear_cache",null);
};
Lino.sales.Invoices.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.sales.Invoices.ParamsPanel({});
  return new Lino.sales.Invoices.GridPanel(p);
});

// js_render_GridPanel_class sales.DocumentsToSign
Lino.sales.DocumentsToSign.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/sales/DocumentsToSign",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/sales/DocumentsToSign','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/DocumentsToSign','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/sales/DocumentsToSign','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.list_action_handler('/sales/DocumentsToSign','do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Clear cache", "auto_save": true } ],
  cell_edit : true,
  title : "Invoices",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 12,
  ls_store_fields : [ { "type": "int", "name": "number" }, { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "partner" }, 'partnerHidden', { "name": "imode" }, 'imodeHidden', { "name": "subject" }, { "name": "total_incl" }, { "name": "total_base" }, { "name": "total_vat" }, { "name": "voucher_ptr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 10,
  ls_grid_configs : [  ],
  content_type : 44,
  ls_id_property : "voucher_ptr",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.DocumentsToSign.detail;
    this.ls_insert_handler = Lino.sales.DocumentsToSign.insert;
    var ww = this.containing_window;
    var number2272 = new Ext.form.NumberField({ "selectOnFocus": true });
    var date2273 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var partner2274 = new Lino.RemoteComboFieldElement({ "preferred_width": 20, "allowBlank": false, "pageSize": 20, "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/DocumentsToSign/partner", "method": "GET" }) }), "emptyText": "Select a Partner..." });
    var imode2275 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/DocumentsToSign/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Invoicing Mode..." });
    var subject2276 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var total_incl2277 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_base2278 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat2279 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "tooltip": "(sales.DocumentsToSign.number) ", "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(5), "editor": number2272 }), { "colIndex": 1, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "tooltip": "(sales.DocumentsToSign.date) ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "date", "width": Lino.chars2width(14), "editor": date2273 }, { "colIndex": 2, "sortable": true, "header": "Partner", "editable": true, "tooltip": "(sales.DocumentsToSign.partner) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.Partners.detail'), "editor": partner2274, "dataIndex": "partner" }, { "colIndex": 3, "sortable": true, "header": "Invoicing Mode", "editable": true, "tooltip": "(sales.DocumentsToSign.imode) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "imode", "editor": imode2275 }, { "colIndex": 4, "sortable": true, "header": "Subject line", "editable": true, "tooltip": "(sales.DocumentsToSign.subject) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "subject", "editor": subject2276 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "header": "Total incl. VAT", "editable": true, "tooltip": "(sales.DocumentsToSign.total_incl) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_incl", "editor": total_incl2277 }), new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "header": "Total excl. VAT", "editable": true, "tooltip": "(sales.DocumentsToSign.total_base) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_base", "editor": total_base2278 }), new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "header": "VAT", "editable": true, "tooltip": "(sales.DocumentsToSign.total_vat) ", "filter": { "type": "numeric" }, "width": Lino.chars2width(13), "dataIndex": "total_vat", "editor": total_vat2279 }) ];
    Lino.sales.DocumentsToSign.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.DocumentsToSign.as_pdf = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/DocumentsToSign","GET",pk,"as_pdf",Lino.get_current_grid_config);
};
Lino.sales.DocumentsToSign.as_pdf_p = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/DocumentsToSign","GET",pk,"as_pdf_p",Lino.get_current_grid_config);
};
Lino.sales.DocumentsToSign.put = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/DocumentsToSign","GET",pk,"put",null);
};
Lino.sales.DocumentsToSign.post = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/DocumentsToSign","GET",pk,"post",null);
};

Lino.sales.DocumentsToSign.insertPanel = Ext.extend(Lino.sales.Invoices.InsertFormPanel,{
  empty_title: "New Invoices",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/sales/DocumentsToSign",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.DocumentsToSign.detail;
    this.ls_insert_handler = Lino.sales.DocumentsToSign.insert;
    Lino.sales.DocumentsToSign.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.DocumentsToSign.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.sales.DocumentsToSign.insertPanel(p);
});
Lino.sales.DocumentsToSign.wf1 = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/DocumentsToSign","GET",pk,"wf1",null);
};
Lino.sales.DocumentsToSign.poststay = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/DocumentsToSign","GET",pk,"poststay",null);
};
Lino.sales.DocumentsToSign.duplicate = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/DocumentsToSign","GET",pk,"duplicate",null);
};
Lino.sales.DocumentsToSign.wf2 = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/DocumentsToSign","GET",pk,"wf2",null);
};

Lino.sales.DocumentsToSign.detailPanel = Ext.extend(Lino.sales.Invoices.DetailFormPanel,{
  empty_title: "Detail Invoices",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-disk", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET',null), "iconCls": "x-tbar-arrow_divide", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.list_action_handler('/sales/DocumentsToSign','do_print','POST',null), "iconCls": "x-tbar-printer", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET',null), "iconCls": "x-tbar-printer_delete", "overflowText": "Clear cache", "auto_save": true } ],
  ls_url: "/sales/DocumentsToSign",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.DocumentsToSign.detail;
    this.ls_insert_handler = Lino.sales.DocumentsToSign.insert;
    Lino.sales.DocumentsToSign.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.DocumentsToSign.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.DocumentsToSign.detailPanel(p);
});
Lino.sales.DocumentsToSign.do_print = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/DocumentsToSign","POST",pk,"do_print",null);
};
Lino.sales.DocumentsToSign.do_clear_cache = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/DocumentsToSign","GET",pk,"do_clear_cache",null);
};
Lino.sales.DocumentsToSign.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.sales.Invoices.ParamsPanel({});
  return new Lino.sales.DocumentsToSign.GridPanel(p);
});

// js_render_GridPanel_class blogs.EntryTypes
Lino.blogs.EntryTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/blogs/EntryTypes",
  ls_bbar_actions : [ { "panel_btn_handler": Lino.list_action_handler('/blogs/EntryTypes','as_pdf','GET',Lino.get_current_grid_config), "xtype": "splitbutton", "text": null, "menu": [ { "itemId": "as_pdf", "menu_item_text": "Table (landscape)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/blogs/EntryTypes','as_pdf','GET',Lino.get_current_grid_config), "text": "Table (landscape)", "overflowText": "Table (landscape)", "auto_save": true }, { "itemId": "as_pdf_p", "menu_item_text": "Table (portrait)", "must_save": true, "tooltip": "Show this table as a pdf document", "panel_btn_handler": Lino.list_action_handler('/blogs/EntryTypes','as_pdf_p','GET',Lino.get_current_grid_config), "text": "Table (portrait)", "overflowText": "Table (portrait)", "auto_save": true } ], "iconCls": "x-tbar-pdf", "menu_item_text": "Table (landscape)" }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-add", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-application_form", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  cell_edit : true,
  title : "Blog Entry Types",
  page_length : 20,
  stripeRows : true,
  disabled_actions_index : 10,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "build_method" }, 'build_methodHidden', { "name": "template" }, { "type": "int", "name": "id" }, { "type": "boolean", "name": "important" }, { "name": "remark" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 48,
  ls_id_property : "id",
  gc_name : 0,
  initComponent : function() {
    this.ls_detail_handler = Lino.blogs.EntryTypes.detail;
    this.ls_insert_handler = Lino.blogs.EntryTypes.insert;
    var ww = this.containing_window;
    var name2281 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de2282 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr2283 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var build_method2284 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template2285 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/EntryTypes/template", "method": "GET" }) }) });
    var id2286 = new Ext.form.NumberField({ "selectOnFocus": true });
    var important2287 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var remark2288 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
      template2285.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      build_method2284.on('change',Lino.chooser_handler(template2285,'build_method'));
      Lino.blogs.EntryTypes.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "tooltip": "(blogs.EntryTypes.name) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name", "editor": name2281 }, { "colIndex": 1, "sortable": true, "header": "Designation (de)", "editable": true, "tooltip": "(blogs.EntryTypes.name_de) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_de", "editor": name_de2282 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "tooltip": "(blogs.EntryTypes.name_fr) ", "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "name_fr", "editor": name_fr2283 }, { "colIndex": 3, "sortable": true, "header": "Build method", "editable": true, "tooltip": "(blogs.EntryTypes.build_method) ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "build_method", "editor": build_method2284 }, { "colIndex": 4, "sortable": true, "header": "Template", "editable": true, "tooltip": "(blogs.EntryTypes.template) ", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "template", "editor": template2285 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editab