/*
 Copyright 2009-2013 Luc Saffre
 This file is part of the Lino project.
 Lino is free software; you can redistribute it and/or modify 
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.
 Lino is distributed in the hope that it will be useful, 
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 GNU General Public License for more details.
 You should have received a copy of the GNU General Public License
 along with Lino; if not, see <http://www.gnu.org/licenses/>.
*/

// lino.js --- generated Thu Apr 18 13:18:46 2013 by Lino version 1.6.4.
Ext.BLANK_IMAGE_URL = '/media/extjs/resources/images/default/s.gif';
LANGUAGE_CHOICES = [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ];
MEDIA_URL = "/media";

/* MonthPickerPlugin: thanks to keypoint @ sencha forum
   http://www.sencha.com/forum/showthread.php?74002-3.x-Ext.ux.MonthMenu&p=356860#post356860
*/
Ext.namespace('Ext.ux'); 

Ext.ux.MonthPickerPlugin = function() { 
    var picker; 
    var oldDateDefaults; 

    this.init = function(pk) { 
        picker = pk; 
        picker.onTriggerClick = picker.onTriggerClick.createSequence(onClick); 
        picker.getValue = picker.getValue.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
        picker.beforeBlur = picker.beforeBlur.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
    }; 

    function setDefaultMonthDay() { 
        oldDateDefaults = Date.defaults.d; 
        Date.defaults.d = 1; 
        return true; 
    } 

    function restoreDefaultMonthDay(ret) { 
        Date.defaults.d = oldDateDefaults; 
        return ret; 
    } 

    function onClick(e, el, opt) { 
        var p = picker.menu.picker; 
        p.activeDate = p.activeDate.getFirstDateOfMonth(); 
        if (p.value) { 
            p.value = p.value.getFirstDateOfMonth(); 
        } 

        p.showMonthPicker(); 
         
        if (!p.disabled) { 
            p.monthPicker.stopFx(); 
            p.monthPicker.show(); 

            p.mun(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mun(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
            p.onMonthClick = p.onMonthClick.createSequence(pickerClick); 
            p.onMonthDblClick = p.onMonthDblClick.createSequence(pickerDblclick); 
            p.mon(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mon(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
        } 
    } 

    function pickerClick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.is('button.x-date-mp-cancel')) { 
            picker.menu.hide(); 
        } else if(el.is('button.x-date-mp-ok')) { 
            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 

    function pickerDblclick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.parent() 
            && (el.parent().is('td.x-date-mp-month') 
            || el.parent().is('td.x-date-mp-year'))) { 

            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 
}; 

Ext.preg('monthPickerPlugin', Ext.ux.MonthPickerPlugin);  

//~ /* 
  //~ http://www.diloc.de/blog/2008/03/05/how-to-submit-ext-forms-the-right-way/
//~ */
//~ /**
 //~ * This submit action is basically the same as the normal submit action,
 //~ * only that it uses the fields getSubmitValue() to compose the values to submit,
 //~ * instead of looping over the input-tags in the form-tag of the form.
 //~ *
 //~ * To use it, just use the OOSubmit-plugin on either a FormPanel or a BasicForm,
 //~ * or explicitly call form.doAction('oosubmit');
 //~ *
 //~ * @param {Object} form
 //~ * @param {Object} options
 //~ */
//~ Ext.ux.OOSubmitAction = function(form, options){
    //~ Ext.ux.OOSubmitAction.superclass.constructor.call(this, form, options);
//~ };

//~ Ext.extend(Ext.ux.OOSubmitAction, Ext.form.Action.Submit, {
    //~ /**
    //~ * @cfg {boolean} clientValidation Determines whether a Form's fields are validated
    //~ * in a final call to {@link Ext.form.BasicForm#isValid isValid} prior to submission.
    //~ * Pass <tt>false</tt> in the Form's submit options to prevent this. If not defined, pre-submission field validation
    //~ * is performed.
    //~ */
    //~ type : 'oosubmit',

    //~ // private
    //~ /**
     //~ * This is nearly a copy of the original submit action run method
     //~ */
    //~ run : function(){
        //~ var o = this.options;
        //~ var method = this.getMethod();
        //~ var isPost = method == 'POST';

        //~ var params = this.options.params || {};
        //~ if (isPost) Ext.applyIf(params, this.form.baseParams);

        //~ //now add the form parameters
        //~ this.form.items.each(function(field)
        //~ {
            //~ if (!field.disabled)
            //~ {
                //~ //check if the form item provides a specialized getSubmitValue() and use that if available
                //~ if (typeof field.getSubmitValue == "function")
                    //~ params[field.getName()] = field.getSubmitValue();
                //~ else
                    //~ params[field.getName()] = field.getValue();
            //~ }
        //~ });

        //~ //convert params to get style if we are not post
        //~ if (!isPost) params=Ext.urlEncode(params);

        //~ if(o.clientValidation === false || this.form.isValid()){
            //~ Ext.Ajax.request(Ext.apply(this.createCallback(o), {
                //~ url:this.getUrl(!isPost),
                //~ method: method,
                //~ params:params, //add our values
                //~ isUpload: this.form.fileUpload
            //~ }));

        //~ }else if (o.clientValidation !== false){ // client validation failed
            //~ this.failureType = Ext.form.Action.CLIENT_INVALID;
            //~ this.form.afterAction(this, false);
        //~ }
    //~ },

//~ });
//~ //add our action to the registry of known actions
//~ Ext.form.Action.ACTION_TYPES['oosubmit'] = Ext.ux.OOSubmitAction;




/**
JC Watsons solution (adapted to ExtJS 3.3.1 by LS) is elegant and simple:
`A "fix" for unchecked checkbox submission  behaviour
<http://www.sencha.com/forum/showthread.php?28449>`_

Added special handling for checkbox inputs. 
ExtJS defines disabled checkboxes `readonly`, not `disabled` as for other inputs.

*/
Ext.lib.Ajax.serializeForm = function(form) {
    //~ console.log('20120203 linolib.js serializeForm',form);
    var fElements = form.elements || (document.forms[form] || Ext.getDom(form)).elements, 
        hasSubmit = false, 
        encoder = encodeURIComponent, 
        name, 
        data = '', 
        type, 
        hasValue;

    Ext.each(fElements, function(element){
        name = element.name;
        type = element.type;

        if (!element.disabled && name && !(type == 'checkbox' && element.readonly)) {
            if (/select-(one|multiple)/i.test(type)) {
                Ext.each(element.options, function(opt){
                    if (opt.selected) {
                        hasValue = opt.hasAttribute ? opt.hasAttribute('value') : opt.getAttributeNode('value').specified;
                        data += String.format("{0}={1}&", encoder(name), encoder(hasValue ? opt.value : opt.text));
                    }
                });
            } else if (!(/file|undefined|reset|button/i.test(type))) {
                //~ if (!(/radio|checkbox/i.test(type) && !element.checked) && !(type == 'submit' && hasSubmit)) {
                if (!(type == 'submit' && hasSubmit)) {
                    if (type == 'checkbox') {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&');
                        data += encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&';
                    } else {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + encoder(element.value) + '&');
                        data += encoder(name) + '=' + encoder(element.value) + '&';
                    }
                    hasSubmit = /submit/i.test(type);
                }
            }
        //~ } else {
            //~ console.log(name,type,element.readonly);
        }
    });
    return data.substr(0, data.length - 1);
};



/*
Set a long timeout of fifteen minutes. 
See /blog/2012/0307
*/
Ext.Ajax.timeout = 15 * 60 * 1000; 


/*
My fix for the "Cannot set QuickTips dismissDelay to 0" bug,
see http://www.sencha.com/forum/showthread.php?183515 
*/
Ext.override(Ext.QuickTip,{
  showAt : function(xy){
        var t = this.activeTarget;
        //~ console.log("20120224 QuickTip.showAt",this.title,this.dismissDelay,t.dismissDelay);
        if(t){
            if(!this.rendered){
                this.render(Ext.getBody());
                this.activeTarget = t;
            }
            if(t.width){
                this.setWidth(t.width);
                this.body.setWidth(this.adjustBodyWidth(t.width - this.getFrameWidth()));
                this.measureWidth = false;
            } else{
                this.measureWidth = true;
            }
            this.setTitle(t.title || '');
            this.body.update(t.text);
            this.autoHide = t.autoHide;
            // bugfix by Luc 20120226
            if (t.dismissDelay != undefined) this.dismissDelay = t.dismissDelay;
            //~ this.dismissDelay = t.dismissDelay || this.dismissDelay;
            if(this.lastCls){
                this.el.removeClass(this.lastCls);
                delete this.lastCls;
            }
            if(t.cls){
                this.el.addClass(t.cls);
                this.lastCls = t.cls;
            }
            if(this.anchor){
                this.constrainPosition = false;
            }else if(t.align){ 
                xy = this.el.getAlignToXY(t.el, t.align);
                this.constrainPosition = false;
            }else{
                this.constrainPosition = true;
            }
        }
        Ext.QuickTip.superclass.showAt.call(this, xy);
    }
});

/*
Another hack. See /docs/blog/2012/0228
*/
Ext.Element.addMethods(
    function() {
        var VISIBILITY      = "visibility",
            DISPLAY         = "display",
            HIDDEN          = "hidden",
            NONE            = "none",
            XMASKED         = "x-masked",
            XMASKEDRELATIVE = "x-masked-relative",
            data            = Ext.Element.data;

        return {
            
            mask : function(msg, msgCls) {
                var me  = this,
                    dom = me.dom,
                    dh  = Ext.DomHelper,
                    EXTELMASKMSG = "ext-el-mask-msg",
                    el,
                    mask;
                // removed the following lines. See /docs/blog/2012/0228
                //~ if (!(/^body/i.test(dom.tagName) && me.getStyle('position') == 'static')) {
                    //~ console.log(20120228,dom.tagName,me);
                    //~ me.addClass(XMASKEDRELATIVE); 
                //~ }
                if (el = data(dom, 'maskMsg')) {
                    el.remove();
                }
                if (el = data(dom, 'mask')) {
                    el.remove();
                }

                mask = dh.append(dom, {cls : "ext-el-mask"}, true);
                data(dom, 'mask', mask);

                me.addClass(XMASKED);
                mask.setDisplayed(true);
                
                if (typeof msg == 'string') {
                    var mm = dh.append(dom, {cls : EXTELMASKMSG, cn:{tag:'div'}}, true);
                    data(dom, 'maskMsg', mm);
                    mm.dom.className = msgCls ? EXTELMASKMSG + " " + msgCls : EXTELMASKMSG;
                    mm.dom.firstChild.innerHTML = msg;
                    mm.setDisplayed(true);
                    mm.center(me);
                }
                
                
                if (Ext.isIE && !(Ext.isIE7 && Ext.isStrict) && me.getStyle('height') == 'auto') {
                    mask.setSize(undefined, me.getHeight());
                }
                
                return mask;
            }

            
        };
    }()
);



Ext.namespace('Lino');
    
    

//~ Lino.subst_user_field = new Ext.form.ComboBox({});
//~ Lino.subst_user = null;
Lino.insert_subst_user = function(p){
    //~ console.log('20120714 insert_subst_user',Lino.subst_user,p);
    //~ if (Lino.subst_user_field.getValue()) {
    if (p.su) return;
    if (Lino.subst_user) {
        //~ p.su = Lino.subst_user_field.getValue();
        p.su = Lino.subst_user;
    //~ } else {
        //~ delete p.su;
    }
    //~ console.log('20120714 insert_subst_user -->',Lino.subst_user,p);
}

Lino.login_window = null;


Lino.show_login_window = function() {
  //~ console.log('20121103 show_login_window',arguments);
  //~ var current_window = Lino.current_window;
  if (Lino.login_window == null) {
    
      function do_login() { 
            Lino.viewport.loadMask.show()
            //~ Lino.body_loadMask.show()
            login_panel.getForm().submit({ 
                method:'POST', 
                waitTitle:'Connecting', 
                waitMsg:'Sending data...',
                success:function(){ 
                  //~ console.log('20121104 logged in',arguments);
                  Lino.login_window.hide();
                  Lino.close_all_windows();
                  Lino.viewport.loadMask.hide()
                  //~ Lino.body_loadMask.hide()
                },
                failure: function(form,action) { 
                  //~ this.loadMask.hide();
                  Lino.on_submit_failure(form,action);
                  Lino.viewport.loadMask.hide()
                  //~ Lino.body_loadMask.hide()
                  //~ if (Lino.current_window) Lino.current_window.main_item.loadMask.hide()
                }
                //~ failure:function(form, action){ 
                    //~ alert_msg
                    //~ if(action.failureType == 'server'){ 
                        //~ obj = Ext.util.JSON.decode(action.response.responseText); 
                        //~ Ext.Msg.alert('Login Failed!', obj.errors.reason); 
                    //~ }else{ 
                        //~ Ext.Msg.alert('Warning!', 'Authentication server is unreachable : ' + action.response.responseText); 
                    //~ } 
                    //~ Lino.login_panel.getForm().reset(); 
                //~ } 
            }); 
      };
    
      var login_button = new Ext.Button({ 
        text:"Log in",
        formBind: true,	 
        // Function that fires when user clicks the button 
        handler: do_login});
    
      var login_panel = new Ext.FormPanel({ 
        //~ inspired by http://www.sencha.com/learn/a-basic-login/
        autoHeight:true,
        labelWidth:90,
        url:'/auth', 
        frame:true, 
        defaultType:'textfield',
        monitorValid:true,
        items:[{ 
            fieldLabel:"Username", 
            id: 'username',
            name:'username', 
            autoHeight:true,
            allowBlank:false 
        },{ 
            fieldLabel:"Password", 
            name:'password', 
            inputType:'password', 
            autoHeight:true,
            allowBlank:false 
        }],        
        buttons:[ login_button ]});
        
      Lino.login_window = new Ext.Window({
          layout:'fit',
          defaultButton: 'username',
          width:300,
          title:"Log in", 
          autoHeight:true,
          modal: true,
          closeAction: "hide",
          keys: {
            key: Ext.EventObject.ENTER,
            fn: function() { do_login()}
          },
          //~ defaultButton: login_button,
          //~ height:'auto',
          //~ closable: false,
          //~ resizable: false,
          //~ plain: true,
          //~ border: false,
          items: [login_panel] });
  };
  Lino.login_window.show();
};

Lino.logout = function(id,name) {
    //~ console.log('20121104 gonna log out',arguments);
    //~ Lino.do_action
    Lino.call_ajax_action(Lino.viewport,'GET','/auth',{},'logout',undefined,undefined,function(){
        //~ console.log('20121104 logged out',arguments);
        //~ Lino.login_window.hide();
        Lino.close_all_windows();
    })
}

Lino.set_subst_user = function(id,name) {
    //~ console.log(20120714,'Lino.set_subst_user',id,name);
    Lino.subst_user = id;

    if (Lino.current_window) 
        Lino.current_window.main_item.set_base_param("su",id);
    if (Lino.viewport) Lino.permalink_handler(Lino.current_window)();
}



//~ Lino.select_subst_user = function(cmp,rec,value){
    //~ Lino.subst_user=value;
    //~ console.log(20120713,rec);
//~ }
    
Lino.current_window = null;
Lino.window_history = Array();
    
Lino.chars2width = function(cols) {  return cols * 9; }
Lino.rows2height = function(cols) {  return cols * 20; }



Lino.Viewport = Ext.extend(Ext.Viewport,{
  layout:"fit"
  ,initComponent : function(){
    Lino.Viewport.superclass.initComponent.call(this);
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.el,{msg:"Please wait..."});
      //~ console.log("20121118 Lino.viewport.loadMask",this.loadMask);
    },this);
  }
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,refresh : function() {
      var caller = this;
      console.log("20121120 Lino.Viewport.refresh()");
      if (caller.loadMask) caller.loadMask.show();
      var success = function(response) {
        if (caller.loadMask) caller.loadMask.hide();
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          //~ console.log('Lino.do_action()',action.name,'result is',result);
          if (result.html) {
              Ext.getCmp('main_area').update(result.html);
          }
          if (result.message) {
              if (result.alert) {
                  //~ Ext.MessageBox.alert('Alert',result.alert_msg);
                  Ext.MessageBox.alert('Alert',result.message);
              } else {
                  Lino.notify(result.message);
              }
          }
          
          if (result.notify_msg) Lino.notify(result.notify_msg);
          if (result.js_code) { 
            var jsr = result.js_code(caller);
            //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
          };
        }
      };
      var action = {
        url : '/api/main_html',
        waitMsg: "Please wait...",
        failure: Lino.ajax_error_handler(caller),
        success: success,
        method: 'GET',
        params: {}
      };
      Lino.insert_subst_user(action.params);
      Ext.Ajax.request(action);
    
  }
});


Lino.open_window = function(win,st,requesting_panel) {
  //~ console.log("20120918 Lino.open_window()",win,st);
  var cw = Lino.current_window;
  if (cw) {
    //~ console.log("20120918 Lino.open_window() save current status",cw.main_item.get_status());
    Lino.window_history.push({
      window:cw,
      status:cw.main_item.get_status()
    });
  }
  Lino.current_window = win;
  //~ if (st.su) 
      //~ Lino.subst_user_field.setValue(st.su);
  win.main_item.set_status(st,requesting_panel);
  win.show();
};

Lino.load_url = function(url) {
    //~ foo.bar.baz = 2; 
    //~ console.log("20121120 Lino.load_url()");
    //~ Lino.body_loadMask.show();
    Lino.viewport.loadMask.show();
    //~ location.replace(url);
    document.location = url;
}

Lino.close_window = function(status_update) {
  var cw = Lino.current_window;
  var ww = Lino.window_history.pop();
  if (ww) {
    //~ if (status_update) Ext.apply(ww.status,status_update);
    if (status_update) status_update(ww);
    ww.window.main_item.set_status(ww.status);
    Lino.current_window = ww.window;
  } else {
    Lino.current_window = null;
  }
  if (cw) cw.hide_really();
};

Lino.close_all_windows = function() {
  if (Lino.window_history.length == 0) {
      //~ Lino.viewport.refresh();
      var url =  "/"
      //~ console.log("20121120 Lino.close_all_windows() : no window_history");
      //~ if (ADMIN_URL) 
      var p = {};
      Lino.insert_subst_user(p)
      if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
      Lino.load_url(url);
  } else {
    //~ console.log("20121120 Lino.close_all_windows() with window_history");
    while (Lino.window_history.length > 0) {
      Lino.close_window();
      //~ Lino.window_history.pop().hide_really();
    }
  }
  //~ Lino.current_window = null;
  //~ Lino.close_window();
  //~ var ww = 
}

Lino.kill_current_window = function() {
  var cw = Lino.current_window;
  Lino.current_window = null;
  if (cw) cw.hide_really();
};

Lino.calling_window = function() {
    if (Lino.window_history.length) return Lino.window_history[Lino.window_history.length-1];
}

//~ Lino.WindowAction = function(mainItemClass,windowConfig,mainConfig,ppf) {
Lino.WindowAction = function(windowConfig,main_item_fn) {
    //~ if(!mainConfig) mainConfig = {};
    //~ mainConfig.is_main_window = true;
    this.windowConfig = windowConfig;
    this.main_item_fn = main_item_fn;
    //~ if (ppf) mainConfig.params_panel.fields = ppf;
    //~ this.mainConfig = mainConfig;
    //~ this.mainItemClass = mainItemClass;
};

Lino.WindowAction = Ext.extend(Lino.WindowAction,{
    window : null,
    //~ mainItemClass: null,
    get_window : function() {
      //~ if(mainConfig) Ext.apply(this.mainConfig,mainConfig);
      if (this.window == null)  {
          //~ this.windowConfig.main_item = new this.mainItemClass(this.mainConfig);
          this.windowConfig.main_item = this.main_item_fn();
          this.window = new Lino.Window(this.windowConfig);
      }
      return this.window;
    },
    run : function(requesting_panel,status) {
      //~ console.log('20120625 window_action.run()',this)
      Lino.open_window(this.get_window(),status,requesting_panel);
    }
  
});


Lino.PanelMixin = {
  get_containing_window : function (){
      if (this.containing_window) return this.containing_window;
      return this.containing_panel.get_containing_window();
  }
  ,set_window_title : function(title) {
    //~ this.setTitle(title);
    var cw = this.get_containing_window();

    //~ if (cw) {
    //~ if (cw && cw.closable) {
    if (cw && !cw.main_item.hide_window_title) {
      //~ console.log('20111202 set_window_title(',title,') for',this.containing_window);
      //~ if (! this.containing_window.rendered) console.log("WARNING: not rendered!");
      cw.setTitle(title);
    //~ } else {
      //~ document.title = title;
    }
    //~ else console.log('20111202 not set_window_title(',title,') for',this);
  }
  
};


Lino.status_bar = new Ext.ux.StatusBar({defaultText:'Lino version 1.6.4.'});



Lino.edit_tinymce_text = function(panel,options) {
  // `panel` is the RichTextPanel
  //~ console.log(20111220,panel);
  //~ var rec = panel.get_current_record();
  var rec = panel.containing_panel.get_current_record();
  var value = rec ? rec.data[panel.editor.name] : '';
  var saving = false;
  var todo_after_save = false;
  var discard_changes = false;
  
  
  function save() {
    //~ if (todo_after_save) {alert('tried to save again'); return; }
    if (saving) {alert('tried to save again'); return; }
    //~ var url = panel.containing_window.main_item.get_record_url(rec.id);
    var url = panel.containing_panel.get_record_url(rec.id);
    var params = Ext.apply({},panel.containing_panel.get_base_params());
    params[panel.editor.name] = editor.getValue();
    //~ params.su = Lino.subst_user;
    //~ Lino.insert_subst_user(params);
    var a = { 
      params: params, 
      method: 'PUT',
      url: url,
      failure: function() {
          //~ if (editor.ed.getContainer()) 
          editor.ed.setProgressState(0);
          todo_after_save = false;
          saving = false;
          console.log('tinymce.save() failed. sorry.',arguments);
        },
      success: function() {
        saving = false;
        //~ if (editor.ed.getContainer()) 
        editor.ed.setProgressState(0);
        rec.data[panel.editor.name] = editor.getValue();
        if(todo_after_save) {
            var fn = todo_after_save;
            todo_after_save = false;
            fn();
        }
        //~ panel.containing_window.set_current_record(rec);
        panel.refresh();
      }
    };
    //~ if (editor.ed.getContainer()) 
    editor.ed.setProgressState(1); // Show progress
    saving = true;
    //~ console.log(a);
    Ext.Ajax.request(a);
  };
  function save_callback() {
      save();
      //~ save(function(){editor.ed.setDirty(false);})
      /* return true have the save button disabled.  
      That's not perfect because the PUT is asynchronous 
      and the response is not yet known.
      */
      return true;
  }
  //~ var actions = [
    //~ {text:"Save",handler:save}
  //~ ]; 
  //~ console.log(20110610,panel.editor.disabled);
  var settings = {};
  Ext.apply(settings,{
        readonly: panel.editor.disabled,
        //~ language: "de",
        plugins : "save,emotions,spellchecker,advhr,insertdatetime,preview,table,searchreplace,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "save,cancel,|,bold,italic,underline,|,justifyleft,justifycenter,justifyright,fontselect,fontsizeselect,formatselect,|,search,replace",
        theme_advanced_buttons2 : "cut,copy,paste,template,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,link,unlink,anchor,image,|,code,preview,|,forecolor,backcolor",
        theme_advanced_buttons3 : "insertdate,inserttime,|,spellchecker,advhr,,removeformat,|,sub,sup,|,charmap,emotions,|,tablecontrols",      
        theme_advanced_resizing : false,
        convert_urls : false,
        save_onsavecallback : save_callback,
        save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
  });
  Ext.apply(settings,options);
  var editor = new Ext.ux.TinyMCE({
      value : value,
      tinymceSettings: settings
    });
  var win = new Ext.Window({
    title: rec.title, 
    //~ bbar: actions,
    layout: 'fit',
    items: editor,
    width: 600, 
    height:500,
    minWidth: 100,
		minHeight: 100,
    modal: true,
    resizable: true,
    maximizable: true,
    //~ maximized: true,
    //~ closeAction: "close"
    closeAction: "hide"
    //~ hideMode: "offsets",
    //~ constrainHeader: true,
    //~ bodyStyle: 'padding: 10px'
  });

  //~ win.on('beforeclose',function() {
  win.on('beforehide',function() {
    if (todo_after_save) return false;
    if (discard_changes) return true;
    if (editor.isDirty()) {
        //~ var ok = false;
        //~ var allowClose = true;
        var config = {title:"Confirmation"};
        config.buttons = Ext.MessageBox.YESNOCANCEL;
        config.msg = "Save changes to text ?";
        config.modal = true;
        config.fn = function(buttonId,text,opt) {
          //~ console.log('do_when_clean',buttonId)
          if (buttonId == "yes") {
              /* we cancel this close, but save()'s onSuccess will call again.*/
              //~ allowClose = false;
              todo_after_save = function(){win.hide();}
              editor.ed.execCommand('mceSave');
              //~ editor.ed.save(function(){win.close();});
          } else if (buttonId == "no") { 
              discard_changes = true;
              win.hide()
          //~ } else if (buttonId == "cancel") { 
            //~ ok = true;
              //~ allowClose = false;
          //~ } else { 
            //~ console.log('unknwon buttonId:',buttonId);
          }
        }
        Ext.MessageBox.show(config);
        return false;
        //~ return allowClose;
    }
  });
  win.show();
}







/* 
  Originally copied from Ext JS Library 3.3.1
  Modifications by Luc Saffre : 
  - rendering of phantom records
  - fire afteredit event
  - react on dblclcik, not on single click

 */
Lino.CheckColumn = Ext.extend(Ext.grid.Column, {

    processEvent : function(name, e, grid, rowIndex, colIndex){
        //~ console.log('20110713 Lino.CheckColumn.processEvent',name)
        if (name == 'click') {
        //~ if (name == 'mousedown') {
        //~ if (name == 'dblclick') {
            return this.toggleValue(grid, rowIndex, colIndex);
        } else {
            return Ext.grid.ActionColumn.superclass.processEvent.apply(this, arguments);
        }
    },
    
    toggleValue : function (grid,rowIndex,colIndex) {
        var record = grid.store.getAt(rowIndex);
        var dataIndex = grid.colModel.getDataIndex(colIndex);
        // 20120514
        //~ if(record.data.disabled_fields && record.data.disabled_fields[dataIndex]) {
          //~ Lino.notify("This field is disabled");
          //~ return false;
        //~ }
      
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("This field is disabled.");
            //~ return false;
        //~ }
        var startValue = record.data[dataIndex];
        var value = !startValue;
        //~ record.set(this.dataIndex, value);
        var e = {
            grid: grid,
            record: record,
            field: dataIndex,
            originalValue: startValue,
            value: value,
            row: rowIndex,
            column: colIndex,
            cancel: false
        };
        if(grid.fireEvent("beforeedit", e) !== false && !e.cancel){
        //~ if(grid.fireEvent("validateedit", e) !== false && !e.cancel){
            record.set(dataIndex, value);
            delete e.cancel;
            grid.fireEvent("afteredit", e);
        }
        return false; // Cancel event propagation
    },

    renderer : function(v, p, record){
        if (record.phantom) return '';
        p.css += ' x-grid3-check-col-td'; 
        return String.format('<div class="x-grid3-check-col{0}">&#160;</div>', v ? '-on' : '');
    }

    // Deprecate use as a plugin. Remove in 4.0
    // init: Ext.emptyFn
});

// register ptype. Deprecate. Remove in 4.0
// Ext.preg('checkcolumn', Lino.CheckColumn);

// backwards compat. Remove in 4.0
// Ext.grid.CheckColumn = Lino.CheckColumn;

// register Column xtype
Ext.grid.Column.types.checkcolumn = Lino.CheckColumn;


/* 20110725 : 
Lino.on_tab_activate is necessary 
in contacts.Person.2.dtl 
(but don't ask me why...)
*/
Lino.on_tab_activate = function(item) {
  //~ console.log('activate',item); 
  if (item.rendered && item.doLayout) item.doLayout();
  //~ if (item.rendered) item.doLayout();
}

Lino.TimeField = Ext.extend(Ext.form.TimeField,{
  format: 'H:i',
  increment: 15
  });
Lino.DateField = Ext.extend(Ext.form.DateField,{
  boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  altFormats: 'd/m/Y|Y-m-d'
  });
Lino.DatePickerField = Ext.extend(Ext.DatePicker,{
  //~ boxMinWidth: Lino.chars2width(11),
  format: 'd.m.Y',
  //~ altFormats: 'd/m/Y|Y-m-d'
  formatDate : function(date){
      console.log("20121203 formatDate",this.name,date);
      return Ext.isDate(date) ? date.dateFormat(this.format) : date;
  }
  });
Lino.DateTimeField = Ext.extend(Ext.ux.form.DateTime,{
  dateFormat: 'd.m.Y',
  timeFormat: 'H:i',
  //~ hiddenFormat: 'd.m.Y H:i'
  });
Lino.URLField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  //~ triggerClass : 'x-form-world-trigger',
  vtype: 'url',
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    window.open(this.getValue(),'_blank');
  }
});
Lino.IncompleteDateField = Ext.extend(Ext.form.TextField,{
  //~ regex: /^-?\d+-[01]\d-[0123]\d$/,
  //~ regex: /^[0123]\d\.[01]\d\.-?\d+$/,
  maxLength: 10,
  boxMinWidth: Lino.chars2width(10),
  regex: /^[0123]?\d\.[01]?\d\.-?\d+$/,
  regexText: 'Enter a date in format YYYY-MM-DD (use zeroes for unknown parts).'
  });


//~ Lino.make_dropzone = function(cmp) {
    //~ cmp.on('render', function(ct, position){
      //~ ct.el.on({
        //~ dragenter:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ return true;
        //~ }
        //~ ,dragover:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ event.stopEvent();
          //~ return true;
        //~ }
        //~ ,drop:{
          //~ scope:this
          //~ ,fn:function(event){
            //~ event.stopEvent();
            //~ console.log(20110516);
            //~ var files = event.browserEvent.dataTransfer.files;
            //~ if(files === undefined){
              //~ return true;
            //~ }
            //~ var len = files.length;
            //~ while(--len >= 0){
              //~ console.log(files[len]);
              //~ // this.processDragAndDropFileUpload(files[len]);
            //~ }
          //~ }
        //~ }
      //~ });
    //~ });
//~ };

//~ Lino.FileUploadField = Ext.ux.form.FileUploadField;

Lino.FileUploadField = Ext.extend(Ext.ux.form.FileUploadField,{
    onRender : function(ct, position){
      Lino.FileUploadField.superclass.onRender.call(this, ct, position);
      this.el.on({
        dragenter:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          return true;
        }
        ,dragover:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          event.stopEvent();
          return true;
        }
        ,drop:{
          scope:this
          ,fn:function(event){
            event.stopEvent();
            //~ console.log(20110516);
            var files = event.browserEvent.dataTransfer.files;
            if(files === undefined){
              return true;
            }
            var len = files.length;
            while(--len >= 0){
              console.log(files[len]);
              //~ this.processDragAndDropFileUpload(files[len]);
            }
          }
        }
      });
    }
});

Lino.FileField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  editable: false,
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    if (this.getValue()) window.open(MEDIA_URL + '/'+this.getValue(),'_blank');
  }
});

Lino.file_field_handler = function(panel,config) {
  //~ if (instanceof Lino.DetailWrapper) {
  if (panel.action_name == 'insert') {
  //~ if (panel.get_current_record().phantom) {
      panel.has_file_upload = true;

      var f = new Lino.FileUploadField(config);
      //~ Lino.make_dropzone(f);
      return f;
      //~ return new Ext.ux.form.FileUploadField(config);
      //~ return new Lino.FileField(config);
      
  } else {
      //~ return new Lino.URLField(config);
      return new Lino.FileField(config);
  }
}

Lino.VBorderPanel = Ext.extend(Ext.Panel,{
    constructor : function(config) {
      config.layout = 'border';
      delete config.layoutConfig;
      Lino.VBorderPanel.superclass.constructor.call(this,config);
      for(var i=0; i < this.items.length;i++) {
        var item = this.items.get(i);
        if (this.isVertical(item) && item.collapsible) {
          item.on('collapse',this.onBodyResize,this);
          item.on('expand',this.onBodyResize,this);
        }
      }
    },
    isVertical : function(item) {
       return (item.region == 'north' || item.region == 'south' || item.region == 'center');
    },
    onBodyResize: function(w, h){
        //~ console.log('VBorderPanel.onBodyResize',this.title)
      if (this.isVisible()) { // to avoid "Uncaught TypeError: Cannot call method 'getHeight' of undefined."
        var sumflex = 0;
        var availableHeight = this.getInnerHeight();
        var me = this;
        this.items.each(function(item){
          if (me.isVertical(item)) {
              if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  if (item.rendered) availableHeight -= item.getHeight();
              } else {
                  sumflex += item.flex;
              }
          } 
          
        });
        //~ for(var i=0; i < this.items.length;i++) {
          //~ var item = this.items.get(i);
          //~ // if (this.isVertical(item) && item.getResizeEl()) {
          //~ if (this.isVertical(item)) {
              //~ if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  //~ // item.syncSize()
                  //~ // item.doLayout()
                  //~ // if (item.region == "north") console.log('region north',item.getHeight(),item.id, item);
                  //~ // if (item.getHeight() == 0) console.log(20100921,'both flex and getHeight() are 0!');
                  //~ availableHeight -= item.getHeight();
              //~ } else {
                  //~ sumflex += item.flex;
                  //~ // console.log(item.flex);
              //~ }
          //~ } 
          //~ // else console.log('non-vertical item in VBoderPanel:',item)
        //~ }
        var hunit = availableHeight / sumflex;
        //~ console.log('sumflex=',sumflex,'hunit=',hunit, 'availableHeight=',availableHeight);
        for(var i=0; i < this.items.length;i++) {
          var item = this.items.get(i);
          if (this.isVertical(item)) {
              if (item.flex != 0 && ! item.collapsed) {
                  item.setHeight(hunit * item.flex);
                  //~ console.log(item.region,' : height set to',item.getHeight());
              }
          }
          //~ else console.log('non-vertical item in VBoderPanel:',item)
        }
      }
      Lino.VBorderPanel.superclass.onBodyResize.call(this, w, h);
    }
});


/*
  modifications to the standard behaviour of a CellSelectionModel:
  
*/
Ext.override(Ext.grid.CellSelectionModel, {
//~ var dummy = {

    handleKeyDown : function(e){
        /* removed because F2 wouldn't pass
        if(!e.isNavKeyPress()){
            return;
        }
        */
        //~ console.log('handleKeyDown',e)
        var k = e.getKey(),
            g = this.grid,
            s = this.selection,
            sm = this,
            walk = function(row, col, step){
                return g.walkCells(
                    row,
                    col,
                    step,
                    g.isEditor && g.editing ? sm.acceptsNav : sm.isSelectable, 
                    sm
                );
            },
            cell, newCell, r, c, ae;

        switch(k){
            case e.ESC:
            case e.PAGE_UP:
            case e.PAGE_DOWN:
                break;
            default:
                // e.stopEvent(); // removed because Browser keys like Alt-Home, Ctrl-R wouldn't work
                break;
        }

        if(!s){
            cell = walk(0, 0, 1); 
            if(cell){
                this.select(cell[0], cell[1]);
            }
            return;
        }

        cell = s.cell;  
        r = cell[0];    
        c = cell[1];    
        
        switch(k){
            case e.TAB:
                if(e.shiftKey){
                    newCell = walk(r, c - 1, -1);
                }else{
                    newCell = walk(r, c + 1, 1);
                }
                break;
            case e.HOME:
                if (! (g.isEditor && g.editing)) {
                  if (!e.hasModifier()){
                      newCell = [r, 0];
                      //~ console.log('home',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
                      if (activePage > 1) {
                          e.stopEvent();
                          t.moveFirst();
                          return;
                      }
                      newCell = [0, c];
                      break;
                  }
                }
            case e.END:
                if (! (g.isEditor && g.editing)) {
                  c = g.colModel.getColumnCount()-1;
                  if (!e.hasModifier()) {
                      newCell = [r, c];
                      //~ console.log('end',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var d = t.getPageData();
                      if (d.activePage < d.pages) {
                          e.stopEvent();
                          var self = this;
                          t.on('change',function(tb,pageData) {
                              var r = g.store.getCount()-2;
                              self.select(r, c);
                              //~ console.log('change',r,c);
                          },this,{single:true});
                          t.moveLast();
                          return;
                      } else {
                          newCell = [g.store.getCount()-1, c];
                          //~ console.log('ctrl-end',newCell);
                          break;
                      }
                  }
                }
            case e.DOWN:
                newCell = walk(r + 1, c, 1);
                break;
            case e.UP:
                newCell = walk(r - 1, c, -1);
                break;
            case e.RIGHT:
                newCell = walk(r, c + 1, 1);
                break;
            case e.LEFT:
                newCell = walk(r, c - 1, -1);
                break;
            case e.F2:
                if (!e.hasModifier()) {
                    if (g.isEditor && !g.editing) {
                        g.startEditing(r, c);
                        e.stopEvent();
                        return;
                    }
                    break;
                }
            case e.INSERT:
                if (!e.hasModifier()) {
                    if (g.ls_insert_handler && !g.editing) {
                        e.stopEvent();
                        Lino.show_insert(g);
                        return;
                    }
                    break;
                }
            case e.DELETE:
                if (!e.hasModifier()) {
                    if (!g.editing) {
                        e.stopEvent();
                        Lino.delete_selected(g);
                        return;
                    }
                    break;
                }
            case e.ENTER:
                e.stopEvent();
                g.onCellDblClick(r,c);
                break;
                
        }
        

        if(newCell){
          e.stopEvent();
          r = newCell[0];
          c = newCell[1];
          this.select(r, c); 
          if(g.isEditor && g.editing){ 
            ae = g.activeEditor;
            if(ae && ae.field.triggerBlur){
                ae.field.triggerBlur();
            }
            g.startEditing(r, c);
          }
        //~ } else if (g.isEditor && !g.editing && e.charCode) {
        //~ // } else if (!e.isSpecialKey() && g.isEditor && !g.editing) {
            //~ g.set_start_value(String.fromCharCode(e.charCode));
            //~ // g.set_start_value(String.fromCharCode(k));
            //~ // g.set_start_value(e.charCode);
            //~ g.startEditing(r, c);
            //~ // e.stopEvent();
            //~ return;
        // } else {
          // console.log('20120513',e,g);
        }
        
    }


//~ };
});

 

function PseudoConsole() {
    this.log = function() {};
};
if (typeof(console) == 'undefined') console = new PseudoConsole();

Lino.notify = function(msg) {
  if (msg == undefined) msg = ''; else console.log(msg);
  //~ Ext.getCmp('konsole').update(msg);
  Lino.status_bar.setStatus({
    text: msg,
    iconCls: 'ok-icon',
    clear: true // auto-clear after a set interval
  });
  //~ Ext.getCmp('konsole').setTitle(msg.replace(/\n/g,'<br/>'));
  //~ Ext.getCmp('konsole').update(msg.replace(/\n/g,'<br/>'));
};
Lino.alert = function(msg) {
  //~ if (msg == undefined) msg = ''; else console.log(msg);
  Ext.MessageBox.alert('Notify',msg);
};


//~ Lino.show_about = function() {
  //~ new Ext.Window({
    //~ width: 400, height: 400,
    //~ title: "About",
    //~ html: '<a href="http://www.extjs.com" target="_blank">ExtJS</a> version ' + Ext.version
  //~ }).show();
//~ };

function obj2str(o) {
  if (typeof o != 'object') return String(o);
  var s = '';
  for (var p in o) {
    s += p + ': ' + obj2str(o[p]) + '\n';
  }
  return s;
}

Lino.on_store_exception = function (store,type,action,options,response,arg) {
  //~ throw response;
  console.log("on_store_exception: store=",store,
    "type=",type,
    "action=",action,
    "options=",options,
    "response=",response,
    "arg=",arg);
  if (arg) { console.log(arg.stack)};
};

//~ Lino.on_submit_success = function(form, action) {
   //~ Lino.notify(action.result.message);
   //~ this.close();
//~ };

Lino.on_submit_failure = function(form, action) {
    //~ Lino.notify();
  // action may be undefined
    switch (action.failureType) {
        case Ext.form.Action.CLIENT_INVALID:
            Ext.Msg.alert('Client-side failure', 'Form fields may not be submitted with invalid values');
            break;
        case Ext.form.Action.CONNECT_FAILURE:
            Ext.Msg.alert('Connection failure', 'Ajax communication failed');
            break;
        case Ext.form.Action.SERVER_INVALID:
            Ext.Msg.alert('Server-side failure', action.result.message);
   }
};



/*
Lino.save_wc_handler = function(ww) {
  return function(event,toolEl,panel,tc) {
    var pos = panel.getPosition();
    var size = panel.getSize();
    wc = ww.get_window_config();
    Ext.applyIf(wc,{ 
      x:pos[0],y:pos[1],height:size.height,width:size.width,
      maximized:panel.maximized});
    Lino.do_action(ww,{url:'/window_configs/'+ww.config.permalink_name,params:wc,method:'POST'});
  }
};

*/

Lino.show_in_own_window_button = function(handler) {
  return {
    qtip: "Show this panel in own window", 
    id: "up",
    handler: function(event,toolEl,panel, tc) {
      //~ console.log('20111206 report_window_button',panel,handler);
      //~ var bp = ww.get_master_params();
      //~ panel.containing_window = ww; // for HtmlBox. see blog/2010/1022
      //~ handler(panel,{base_params:bp});
      //~ handler(panel,{base_params:panel.get_master_params()});
      handler.run(null,{base_params:panel.containing_panel.get_master_params()});
      //~ handler(panel,{master_panel:panel.containing_window.main_item});
    }
  }
}




Lino.delete_selected = function(panel) {
  //~ console.log("Lino.delete_selected",panel);
  var recs1 = panel.get_selected();
  var recs = [];
  for ( var i=0; i < recs1.length; i++ ) { if (! recs1[i].phantom) recs.push(recs1[i]); }
  if (recs.length == 0) {
    Lino.notify("Please select at least one record.");
    return;
  };
  if (recs.length == 1) {
      if (recs[0].disable_delete) {
        Lino.alert(recs[0].disable_delete);
        return;
      }
  };
  //~ console.log(recs);
  Ext.MessageBox.show({
    title: "Confirmation",
    msg: String.format("Delete {0} rows. Are you sure?",String(recs.length)),
    //~ msg: "Delete " + String(recs.length) + " rows. Are you sure?",
    //~ buttons: Ext.MessageBox.YESNOCANCEL,
    buttons: Ext.MessageBox.YESNO,
    fn: function(btn) {
      if (btn == 'yes') {
        for ( var i=0; i < recs.length; i++ ) {
          Lino.do_action(panel,{
              method:'DELETE',
              url:  '/api' + panel.ls_url + '/' + recs[i].id,
              after_success: panel.after_delete.createDelegate(panel)
          })
        }
        //~ caller.after_delete();
      }
      else Lino.notify("Dann eben nicht.");
    }
  });
};

Lino.action_handler = function (panel,on_success,on_confirm) {
  return function (response) {
    //~ console.log(20120608,panel);
    if (panel instanceof Lino.GridPanel) {
        //~ gridmode = false;
        gridmode = true;
        //~ console.log('20120608 yes');
    } else {
        gridmode = false;
        //~ console.log('20120608 no');
    }
    panel.loadMask.hide(); // 20120211
    if (!response.responseText) return ;
    var result = Ext.decode(response.responseText);
    //~ console.log('Lino.action_handler()','result is',result,'on_confirm is',on_confirm);
    
    if (result.eval_js) {
        //~ console.log(20120618,result.eval_js);
        eval(result.eval_js);
    }
    
    if (result.xcallback) {
        //~ var config = {title:"Confirmation"};
        var config = {title:result.xcallback.title};
        //~ config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        config.buttons = result.xcallback.buttons;
        config.msg = result.message;
        config.fn = function(buttonId,text,opt) {
          panel.loadMask.show(); 
          //~ Lino.insert_subst_user(p);
          Ext.Ajax.request({
            method: 'GET',
            url: '/callbacks/'+result.xcallback.id + '/' + buttonId,
            //~ params: {bi: buttonId},
            success: Lino.action_handler(panel,on_success,on_confirm)
          });
          //~ Lino.call_ajax_action(panel,'GET',)
        }
        Ext.MessageBox.show(config);
        return;
    }
    
    if (on_success && result.success) on_success(result);
    
    //~ if (on_confirm && result.confirm_message) {
        //~ var config = {title:"Confirmation"};
        //~ // config.buttons = Ext.MessageBox.YESNOCANCEL;
        //~ config.buttons = Ext.MessageBox.YESNO;
        //~ config.msg = result.confirm_message;
        //~ config.fn = function(buttonId,text,opt) {
          //~ if (buttonId == "yes") {
              //~ on_confirm(panel,undefined,result.step);
          //~ }
        //~ }
        //~ Ext.MessageBox.show(config);
        //~ return;
    //~ }
    //~ if (result.dialog_fn) {
        //~ console.log('20120928 TODO',result.dialog_fn);
    //~ }
    if (result.message) {
        //~ if (result.alert && ! gridmode) {
        if (result.alert) { // 20120628b 
            //~ Ext.MessageBox.alert('Alert',result.alert_msg);
            if (result.alert === true) result.alert = "Alert";
            Ext.MessageBox.alert(result.alert,result.message);
        } else {
            Lino.notify(result.message);
        }
    }
    // 
    if (result.data_record && ! gridmode) {
        //~ not used
        panel.set_status({data_record:result.data_record});
    }
    else if (result.new_status && ! gridmode) {
        //~ not used
        //~ console.log('20120607 new_status');
        panel.set_status(result.new_status);
    }
    else if (result.goto_record_id != undefined && ! gridmode) {
        //~ console.log('20120607 new_status');
        panel.load_record_id(result.goto_record_id);
    }
    else if (result.refresh_all) {
        var cw = panel.get_containing_window();
        //~ console.log("20120123 refresh_all");
        if (cw) {
          cw.main_item.refresh();
        }
        else console.log("20120123 cannot refresh_all",panel);
    } else {
        //~ console.log("20121212 b gonna refresh",panel);
        if (result.refresh) panel.refresh();
    }
    
    if (result.open_url) {
        //~ console.log(20111126,result.open_url);
        //~ if (!result.message)
            //~ Lino.notify('Open new window <a href="'+result.open_url+'" target="_blank">'+result.open_url+'</a>');
        window.open(result.open_url,'foo',"");
        //~ document.location = result.open_url;
    }
  }
};

Lino.do_action = function(caller,action) {
  action.success = function(response) {
    if (caller.loadMask) caller.loadMask.hide();
    //~ console.log('Lino.do_action()',action,'action success',response);
    if (action.after_success) {
        //~ console.log('Lino.do_action() calling after_success');
        action.after_success();
    }
    if (response.responseText) {
      var result = Ext.decode(response.responseText);
      //~ console.log('Lino.do_action()',action.name,'result is',result);
      if (result.message) {
          if (result.alert) {
              //~ Ext.MessageBox.alert('Alert',result.alert_msg);
              Ext.MessageBox.alert('Alert',result.message);
          } else {
              Lino.notify(result.message);
          }
      }
      
      //~ if (result.alert_msg) Ext.MessageBox.alert('Alert',result.alert_msg);
      //~ if (result.message) Lino.notify(result.message);
      if (result.notify_msg) Lino.notify(result.notify_msg);
      if (result.js_code) { 
        //~ console.log('Lino.do_action()',action,'gonna call js_code in',result);
        var jsr = result.js_code(caller);
        //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
        if (action.after_js_code) {
          //~ console.log('Lino.do_action()',action,'gonna call after_js_code');
          action.after_js_code(jsr);
          //~ console.log('Lino.do_action()',action,'returned from after_js_code');
        //~ } else {
          //~ console.log('Lino.do_action()',action,' : after_js_code is false');
        }
      };
    }
  };
  Ext.applyIf(action,{
    waitMsg: "Please wait...",
    failure: Lino.ajax_error_handler(caller),
    params: {}
  });
  //~ action.params.su = Lino.subst_user;
  Lino.insert_subst_user(action.params);
  
  Ext.Ajax.request(action);
};

//~ Lino.gup = function( name )
//~ {
  //~ // Thanks to http://www.netlobo.com/url_query_string_javascript.html
  //~ name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
  //~ var regexS = "[\\?&]"+name+"=([^&#]*)";
  //~ var regex = new RegExp( regexS );
  //~ var results = regex.exec( window.location.href );
  //~ if( results == null )
    //~ return "";
  //~ else
    //~ return results[1];
//~ };

//~ Lino.refresh_handler = function (ww) {
  //~ return function() { 
      //~ console.log('refresh',ww);
      //~ ww.main_item.doLayout(false,true);
      //~ ww.main_item.syncSize();
  //~ }
//~ };

//~ Lino.tools_close_handler = function (ww) {
  //~ return function() { 
      //~ ww.close();
  //~ }
//~ };
Lino.permalink_handler = function (ww) {
  return function() { 
    //~ console.log(20100923,ww.get_permalink());
    //~ document.location = ww.main_item.get_permalink();
    Lino.load_url(ww.main_item.get_permalink());
    //~ console.log(20120715, ww.main_item.get_permalink());
    //~ document.location = "?permalink=" + ww.get_permalink();
    //~ document.location = "?permalink=" + ww.config.permalink_name +'()';
  }
};
//~ Lino.run_permalink = function() {
  //~ var plink = Lino.gup('permalink');
  //~ if(plink) { eval('Lino.'+plink); }
//~ }

Lino.MainPanel = {
  is_home_page : false,
  setting_param_values : false,
  config_containing_window : function(wincfg) { }
  ,init_containing_window : function(win) { }
  ,is_loading : function() { return true; } // overridden by subclasses
  ,do_when_clean : function(auto_save,todo) { todo() }
  ,get_master_params : function() {
    var p = {}
    p['mt'] = this.content_type; 
    rec = this.get_current_record()
    if (rec) {
      if (rec.phantom) {
          p['mk'] = undefined; 
      }else{
          p['mk'] = rec.id; 
      }
    } else {
      p['mk'] = undefined;
    }
    //~ console.log('get_master_params returns',p,'using record',rec);
    return p;
  }
  ,get_permalink : function() {
    //~ var p = this.main_item.get_base_params() || {};
    var p = Ext.apply({},this.get_base_params());
    delete p.fmt;
    //~ if (p.fmt) delete p.fmt;
    Ext.apply(p,this.get_permalink_params());
    //~ Lino.insert_subst_user(p);
     //~ p.fmt = 'html';
    //~ console.log('get_permalink',p,this.get_permalink_params());
    if (this.is_home_page)
        //~ var url = '';
        var url = '/';
    else 
        var url = this.get_permalink_url();
    if (p.su == null) 
        delete p.su;
    if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
    return url;
  }
  ,get_record_url : function(record_id) {
      var url = '/api' + this.ls_url
      //~ var url = this.containing_window.config.url_data; // ls_url;
      url += '/' + (record_id === undefined ? '-99999' : String(record_id));
      //~ if (record_id !== undefined) url += '/' + String(record_id);
      //~ url += '/' + String(record_id);
      return url;
  }
  ,get_permalink_url : function() {
      return '/api' + this.ls_url;
  }
  ,get_permalink_params : function() {
      //~ return {an:'grid'};
      var p = {};
      if (this.action_name)
          p.an = this.action_name;
      this.add_param_values(p)
      return p;
  }
  ,set_status : function(status) {}
  ,get_status : function() { return {}}
  ,refresh : function() {}
  ,get_base_params : function() { 
    var p = {};
    Lino.insert_subst_user(p);
    return p;
  }
  ,add_params_panel : function (tbar) {
      if (this.params_panel) {
        tbar = tbar.concat([{ scope:this, 
          //~ text: "$_("[parameters]")", // gear
          iconCls: 'x-tbar-parameters',
          tooltip:"Show or hide the table parameters panel",
          enableToggle: true,
          //~ pressed: ! this.params_panel.hidden,
          pressed: ! this.params_panel_hidden,
          toggleHandler: function(btn,state) { 
            //~ if (this.params_panel.isVisible()) 
                //~ this.params_panel.hide();
            //~ else
                //~ this.params_panel.show();
            //~ console.log("20120210 add_params_panel",state,this.params_panel);
            if (state) {
              this.params_panel.show();
              this.params_panel.doLayout();
            } else this.params_panel.hide();
            this.get_containing_window().doLayout();
          }
        }]);
        var t = this;
        var refresh = function() {if (!t.setting_param_values) t.refresh();}
        Ext.each(this.params_panel.fields,function(f) {
          //~ f.on('valid',function() {t.refresh()});
          if (f instanceof Ext.form.Checkbox) {
              f.on('check',refresh);
          } else if (f instanceof Ext.DatePicker) {
              f.on('select',refresh);
          } else if (f instanceof Ext.form.TriggerField) {
              f.on('select',refresh);
              //~ f.on('change',refresh);
              //~ f.on('valid',refresh);
          } else {
              if (! f.on) 
                  console.log("20121010 no method 'on'",f);
              else
                  f.on('change',refresh);
            }
          });
      }
      return tbar;
  }
  ,add_param_values : function (p) {
    if (this.params_panel) {
      /* 
      20120918 add param_values to the request string 
      *only if the params_form is dirty*.
      Otherwise Actor.default_params() would never be used.
      
      20121023 But IntegClients.params_default has non-empty default values. 
      Users must have the possibility to make them empty.
      */
      if (this.params_panel.form.isDirty()) {
        p.pv = this.get_param_values();
      }else{
        if (this.status_param_values) 
          p.pv = Lino.fields2array(
            this.params_panel.fields,this.status_param_values);
      }
      //~ if (!this.params_panel.form.isDirty()) return;
      //~ p.pv = this.get_param_values();
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
    }
  },
  get_param_values : function() { // similar to get_field_values()
      return Lino.fields2array(this.params_panel.fields);
  },
  set_param_values : function(pv) {
    if (this.params_panel) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_param_values = pv;
      //~ this.params_panel.form.suspendEvents(false);
      this.setting_param_values = true;
      if (pv) { 
          this.params_panel.form.my_loadRecord(pv);
      } else { 
        this.params_panel.form.reset(); 
      }
      this.setting_param_values = false;
      //~ this.params_panel.form.resumeEvents();
    }
  }
};


Lino.ajax_error_handler = function(panel) {
  return function(response,options) {
    console.log('Ajax failure:',response,options);
    if (panel.loadMask) panel.loadMask.hide();
    if (response.responseText) {
      var lines = response.responseText.split('\n');
      if (lines.length > 10) {
          line = lines.splice(5,lines.length-10,"(...)");
      }
      Ext.MessageBox.alert(
        response.statusText,
        lines.join('<br/>')
        //~ response.responseText.replace(/\n/g,'<br/>'))
      )
    } else {
      Ext.MessageBox.alert('Action failed',
        'Lino server did not respond to Ajax request');
    }
  }
}
// Ext.Ajax.on('requestexception',Lino.ajax_error_handler)
 


Ext.QuickTips.init();

/* setting QuickTips dismissDelay to 0 */
// Apply a set of config properties to the singleton
//~ Ext.apply(Ext.QuickTips.getQuickTip(), {
//~ Ext.apply(Ext.ToolTip, {
    //~ dismissDelay: 0
    //~ autoHide: false,
    //~ closable: true,
    //~ maxWidth: 200,
    //~ minWidth: 100,
    //~ showDelay: 50      // Show 50ms after entering target
    //~ ,trackMouse: true
//~ });


//~ Ext.apply(Ext.QuickTip, {
    //~ dismissDelay: 0,
//~ });
  
Lino.quicktip_renderer = function(title,body) {
  return function(c) {
    //~ if (c instanceof Ext.Panel) var t = c.bwrap; else // 20130129
    if (c instanceof Ext.Panel) var t = c.header; else // 20130129
    var t = c.getEl();
    //~ console.log(20130129,t,title,body);
    //~ t.dismissDelay = 0;
    Ext.QuickTips.register({
      target: t,
      //~ cls: 'lino-quicktip-classical',
      dismissDelay: 0,
      //~ autoHide: false,
      showDelay: 50,      // Show 50ms after entering target
      //~ title: title,
      text: body
    });
  }
};


  
Lino.help_text_editor = function() {
  //~ var bp = {
      //~ mk:this.content_type,
      //~ mt:1
    //~ };
    //~ console.log(20120202,bp);
  //~ Lino.lino.ContentTypes.detail({},{base_params:bp});
  //~ Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
  Lino.lino.ContentTypes.detail.run(null,{record_id:this.content_type});
}

// Path to the blank image should point to a valid location on your server
//~ Ext.BLANK_IMAGE_URL = MEDIA_URL + '/extjs/resources/images/default/s.gif'; 


// used as Ext.grid.Column.renderer for id columns in order to hide the special id value -99999
Lino.id_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  return value;
}

Lino.raw_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  return value;
}

Lino.text_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return "not implemented"; 
  return value;
}

Lino.NullNumberColumn = Ext.extend(Ext.grid.Column, {
    align : 'right', 
    format : '0,00/i', 
    renderer : function(value, metaData, record, rowIndex, colIndex, store) {
        //~ console.log(20130128,"NullNumberColumn.renderer",value);
        if (value === null) return '';
        return Ext.util.Format.number(value, this.format);
    }
});

//~ Lino.NullNumberColumn = Ext.extend(Ext.grid.NumberColumn, {
    //~ align : 'right', 
    //~ constructor: function(cfg){
        //~ Ext.grid.NumberColumn.superclass.constructor.call(this, cfg);
        //~ var t = this;
        //~ this.renderer = function(value, metaData, record, rowIndex, colIndex, store) {
          //~ console.log(20130128,"NullNumberColumn.renderer",value);
          //~ if (value === null) return '';
          //~ return Ext.util.Format.number(value, t.format);
      //~ };
    //~ }
//~ });




//~ Lino.cell_button_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return '<input type="button" onclick="alert(value)" value=" ? ">' ;
//~ }


//~ Lino.default_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  //~ return value;
//~ }

Lino.fk_renderer = function(fkname,handlername) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    //~ if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '.run(null,{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

Lino.lfk_renderer = function(panel,fkname) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  var handlername = 'console.log';
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '({},{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

//~ Lino.gfk_renderer = function() {
  //~ return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ if (record.phantom) return '';
    //~ console.log('Lino.gfk_renderer',value,colIndex,record,metaData,store);
    //~ return value;
  //~ }
//~ };


Lino.build_buttons = function(panel,actions) {
  //~ console.log("20121006 Lino.build_buttons",actions);
  if (actions) {
    var buttons = Array(actions.length);
    var cmenu = Array(actions.length);
    for (var i=0; i < actions.length; i++) { 
      buttons[i] = new Ext.Toolbar.Button(actions[i]);
      cmenu[i] = actions[i]
      cmenu[i].text = actions[i].menu_item_text;
      if (actions[i].panel_btn_handler) {
          var h = actions[i].panel_btn_handler.createCallback(panel,buttons[i]);
          //~ if (actions[i].must_save) {
          if (actions[i].auto_save == true) {
              buttons[i].on('click',panel.do_when_clean.createDelegate(panel,[true,h]));
          } else if (actions[i].auto_save == null) {
              buttons[i].on('click',panel.do_when_clean.createDelegate(panel,[false,h]));
          } else if (actions[i].auto_save == false) {
              buttons[i].on('click',h);
          } else {
              console.log("20120703 unhandled auto_save value",actions[i])
          }
          cmenu[i].handler = actions[i].panel_btn_handler.createCallback(panel,cmenu[i]);
      }
    }
    return {bbar:buttons, cmenu:new Ext.menu.Menu(cmenu)};
  }
}

Lino.do_when_visible = function(cmp,todo) {
  //~ if (cmp.el && cmp.el.dom) 
  if (cmp.isVisible()) { 
    // 'visible' means 'rendered and not hidden'
    //~ console.log(cmp.title,'-> cmp is visible now');
    todo(); 
  //~ } else {
      //~ cmp.on('resize',todo,cmp,{single:true});
  //~ }
  //~ if (false) { // 20120213
  } else { 
    //~ console.log('Lino.do_when_visible() must defer because not isVisible()',todo,cmp);
    if (cmp.rendered) {
      //~ console.log(cmp,'-> cmp is rendered but not visible: and now?');
      //~ console.log(cmp.title,'-> cmp is rendered but not visible: try again in a moment...');
      //~ var fn = function() {Lino.do_when_visible(cmp,todo)};
      //~ fn.defer(100);
      
      Lino.do_when_visible.defer(50,this,[cmp,todo]);
      //~ Lino.do_when_visible.defer(100,this,[cmp,todo]);
      
    } else {
      //~ console.log(cmp.title,'-> after render');
      cmp.on('afterrender',todo,cmp,{single:true});
    }
  }
  
};    

/*
*/
Lino.do_on_current_record = function(panel,fn,phantom_fn) {
  var rec = panel.get_current_record();
  if (rec == undefined) {
    Lino.notify("There's no selected record.");
    return;
  }
  // 20120307 A VirtualTable with a Detail (lino.Models) has only "phantom" records.
  if (rec.phantom) {
    //~ if (!panel.editable) { console.log("20120312 not editable:",panel)}
    if (phantom_fn) {
      phantom_fn(panel);
    } else {
      Lino.notify("Action not available on phantom record.");
    }
    return;
  }
  return fn(rec);
};






Lino.call_ajax_action = function(panel,method,url,p,actionName,step,on_confirm,on_success) {
  p.an = actionName;
  if (!panel) panel = Lino.viewport;
  Ext.apply(p,panel.get_base_params());
  //~ console.log("20121212 Lino.call_ajax_action",panel);
  panel.loadMask.show(); 
  //~ p.$ext_requests.URL_PARAM_SUBST_USER = Lino.subst_user;
  //~ Lino.insert_subst_user(p);
    
  //~ if (step) p['$ext_requests.URL_PARAM_ACTION_STEP'] = step;
  //~ if (pp) pp(p); // "parameter processor" : first used for read beid card
  Ext.Ajax.request({
    method: method,
    url: url,
    params: p,
    success: Lino.action_handler(panel,on_success,on_confirm)
  });
};

Lino.row_action_handler = function(actionName,hm,pp) {
  var p = {};
  var fn = function(panel,btn,step) {
      if (pp) { p = pp(); if (! p) return; }
      Lino.do_on_current_record(panel,function(rec) {
          //~ console.log(panel);
          //~ 20120723 Lino.call_ajax_action(panel,rec.id,actionName,step,fn);
          Lino.call_ajax_action(panel,hm,panel.get_record_url(rec.id),p,actionName,step,fn);
      });
  };
  return fn;
};

Lino.list_action_handler = function(ls_url,actionName,hm,pp) {
  var p = {};
  var url = '/api' + ls_url
  var fn = function(panel,btn,step) {
      //~ console.log("20121210 Lino.list_action_handler",arguments);
      //~ var url = ADMIN_URL + '/api' + panel.ls_url
      if (pp) { p = pp();  if (! p) return; }
      Lino.call_ajax_action(panel,hm,url,p,actionName,step,fn);
  };
  return fn;
};

Lino.param_action_handler = function(window_action) { // 20121012
  var fn = function(panel,btn,step) {
    Lino.do_on_current_record(panel,function(rec) {
      //~ console.log(panel);
      //~ 20120723 Lino.call_ajax_action(panel,rec.id,actionName,step,fn);
      window_action.run(panel.getId(),{}); 
    });
  };
  return fn;
};


Lino.run_row_action = function(requesting_panel,url,pk,actionName,pp) {
  //~ var panel = action.get_window().main_item;
  url = '/api' + url  + '/' + pk;
  var panel = Ext.getCmp(requesting_panel);
  if (pp) var p = pp(); else var p = {};
  var fn = function(panel,btn,step) {
    //~ 20120723 Lino.call_ajax_action(panel,pk,actionName,step,fn);
    Lino.call_ajax_action(panel,'GET',url,p,actionName,step,fn);
  }
  fn(panel,null,null);
}



Lino.show_detail = function(panel,btn) {
  Lino.do_on_current_record(panel, 
    function(rec) {
      //~ panel.loadMask.show();
      var bp = panel.get_base_params();
      //~ var bp = {};
      panel.add_param_values(bp); // 20120918
      var status = {
        record_id:rec.id,
        base_params:bp
        //~ param_values: pv.$ext_requests.URL_PARAM_PARAM_VALUES
      }
      //~ console.log("20120918 Lino.show_detail",status);
      panel.ls_detail_handler.run(null,status);
      //~ panel.loadMask.hide();
      //~ panel.containing_window.window.hideMask();
      //~ panel.el.unmask();
    },
    Lino.show_insert
  );
};

Lino.show_fk_detail = function(combo,detail_action) {
    //~ console.log("Lino.show_fk_detail",combo,handler);
    pk = combo.getValue();
    if (pk) {
        detail_action.run(null,{record_id: pk})
      } else {
        Lino.notify("Cannot show detail for empty foreign key.");
      }
};

Lino.show_insert = function(panel,btn) {
  var bp = panel.get_base_params();
  //~ console.log('20120125 Lino.show_insert',bp)
  //~ panel.ls_insert_handler.run(null,{record_id:-99999,base_params:bp});
  panel.ls_insert_handler.run(panel.getId(),{record_id:-99999,base_params:bp});
};

Lino.show_insert_duplicate = function(panel,btn) {
  Lino.do_on_current_record(panel,
    function(rec) {
      var newRec = {};
      Ext.apply(newRec,rec);
      newRec.id = -99999;
      panel.ls_insert_handler.run(null,{data_record:rec});
    });
};

//~ Lino.update_row_handler = function(action_name) {
  //~ return function(panel,btn) {
    //~ Lino.notify("Sorry, " + action_name + " is not implemented.");
  //~ }
//~ };




if (Ext.ux.grid !== undefined) {
    Lino.GridFilters = Ext.extend(Ext.ux.grid.GridFilters,{
      encode:true,
      local:false
    });
} else {
    Lino.GridFilters = function() {}; // dummy
    Ext.override(Lino.GridFilters,{
      init : function() {}
    });
};



//~ Lino.ButtonField = Ext.extend(Ext.form.TextField,{
//~ Lino.ButtonField = Ext.extend(Ext.form.Field,{
    //~ editable : false,
    //~ constructor : function(ww,config,params){
      //~ this.containing_window = ww;
      //~ if (params) Ext.apply(config,params);
      //~ Lino.ButtonField.superclass.constructor.call(this, config);
    //~ },
    //~ setButtons : function(buttons){
      //~ console.log('setButtons',buttons);
    //~ },
    //~ onRender : function(ct, position){
        //~ if(!this.el){
            //~ this.panel = new Ext.Container({items:[
              //~ {xtype:'button',text:'upload'},
              //~ {xtype:'button',text:'show'},
              //~ {xtype:'button',text:'edit'}
            //~ ]});
            //~ this.panel.ownerCt = this;
            //~ this.el = this.panel.getEl();

        //~ }
        //~ Lino.ButtonField.superclass.onRender.call(this, ct, position);
    //~ },

  
//~ });

Lino.FieldBoxMixin = {
  before_init : function(config,params) {
    if (params) Ext.apply(config,params);
    var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    if (actions) config.bbar = actions.bbar;
  },
  //~ constructor : function(ww,config,params){
    //~ this.containing_window = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  do_when_clean : function(auto_save,todo) { todo() },
  //~ format_data : function(html) { return '<div class="htmlText">' + html + '</div>' },
  format_data : function(html) { return html },
  get_base_params : function() {
    // needed for insert action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
  },
  set_base_params : function(p) {
    this.base_params = Ext.apply({},p);
    //~ if (p.param_values) this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
  },
  set_base_param : function(k,v) {
    this.base_params[k] = v;
  }
};



Lino.HtmlBoxPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,{
  disabled_in_insert_window : true,
  constructor : function(config,params) {
    this.before_init(config,params);
    Lino.HtmlBoxPanel.superclass.constructor.call(this, config);
  },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.constructor.call(this, ww,config,params);
  //~ },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  //~ disable : function() { var tb = this.getBottomToolbar(); if(tb) tb.disable()},
  //~ enable : function() { var tb = this.getBottomToolbar(); if(tb) tb.enable()},
  onRender : function(ct, position){
    Lino.HtmlBoxPanel.superclass.onRender.call(this, ct, position);
    //~ console.log(20111125,this.containing_window);
    if (this.containing_panel) {
      this.containing_panel.on('enable',this.enable,this);
      this.containing_panel.on('disable',this.disable,this);
    }
    this.el.on({
      dragenter:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        return true;
      }
      ,dragover:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        event.stopEvent();
        return true;
      }
      ,drop:{
        scope:this
        ,fn:function(event){
          event.stopEvent();
          //~ console.log(20110516);
          var files = event.browserEvent.dataTransfer.files;
          if(files === undefined){
            return true;
          }
          var len = files.length;
          while(--len >= 0){
            console.log(files[len]);
            //~ this.processDragAndDropFileUpload(files[len]);
          }
          Lino.show_insert(this);
        }
      }
    });
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    //~ if (this.master_panel) {
      var record = this.containing_panel.get_current_record();
      //~ console.log('HtmlBox.refresh()',this.title,record,record.title);
      var box = this.items.get(0);
      var todo = function() {
        if (this.disabled) return;
        //~ this.set_base_params(this.containing_window.get_base_params());
        this.set_base_params(this.containing_panel.get_master_params());
        var el = box.getEl();
        if (el) {
          el.update(record ? this.format_data(record.data[this.name]) : '');
          //~ console.log('HtmlBox.refresh()',this.name);
        //~ } else {
          //~ console.log('HtmlBox.refresh() failed for',this.name);
        }
      };
      Lino.do_when_visible(box,todo.createDelegate(this));
    //~ }
  }
});
//~ Ext.override(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);



Lino.RichTextPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,Lino.FieldBoxMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,{
    
  //~ initComponent : function(){
    //~ Lino.RichTextPanel.superclass.initComponent.call(this);
  //~ },
  constructor : function(config,params) {
    //~ console.log('Lino.RichTextPanel.initComponent',this);
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + String(rec.id) + "/" + config.name;
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + config.name;
    var t = this;
    var tinymce_options = {
        theme : "advanced",
        content_css: '/media/lino/extjs/lino.css',
        language: 'en',
        //~ template_external_list_url : url,
        theme_advanced_toolbar_location : "top",
        theme_advanced_toolbar_align : "left",
        theme_advanced_statusbar_location : "bottom",
        template_popup_width : 700,
        template_popup_height : 500,
        template_replace_values : { 
            data_field : function(element){ 
                //~ console.log(20110722,fieldName,t.containing_window.get_current_record()); 
                var fieldName = element.innerHTML;
                element.innerHTML = t.containing_panel.get_current_record().data[fieldName];
            } 
        }
      };
      
    var editorConfig = {
      tinymceSettings: {
        plugins : "noneditable,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "bold,italic,underline,|,justifyleft,justifycenter,justifyright,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,removeformat,template",
        theme_advanced_buttons2 : "",
        theme_advanced_buttons3 : "", // ,|,sub,sup,|,charmap",      
        theme_advanced_resizing : false
        //~ save_onsavecallback : save_callback,
        //~ save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
        
    }};
    Ext.apply(editorConfig.tinymceSettings,tinymce_options);
    //~ editorConfig.name = config.action_name;
    editorConfig.name = config.name;
    delete config.name;
    //~ config.title = config.label;
    //~ delete config.label;
    this.before_init(config,params);
    
    this.editor = new Ext.ux.TinyMCE(editorConfig);
    var t = this;
    config.tools = [{
                      qtip: "Edit text in own window", 
                      id: "up",
                      handler: function(){
                        if(t.editor.isDirty()) {
                            var record = t.containing_panel.get_current_record();
                            record.data[t.editor.name] = t.editor.getValue();
                        }
                        Lino.edit_tinymce_text(t,tinymce_options)
                      }
                    }];
    
    config.items = this.editor;
    config.layout = "fit";
    Lino.RichTextPanel.superclass.constructor.call(this, config);
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    var record = this.containing_panel.get_current_record();
    //~ console.log('RichTextPanel.refresh()',this.title,record.title,record);
    var todo = function() {
      //~ this.set_base_params(this.containing_window.get_base_params());
      if (record) {
        var url = '/templates' + this.containing_panel.ls_url + "/" 
            + String(record.id) + "/" + this.editor.name;
        //~ console.log('RichTextPanel.refresh()',url);
        if (this.editor.ed) this.editor.ed.settings.template_external_list_url = url;
        this.set_base_params(this.containing_panel.get_master_params());
        //~ var v = record ? this.format_data(record.data[this.editor.name]) : ''
        var v = this.format_data(record.data[this.editor.name])
        this.editor.setValue(v);
      } else {
        this.editor.setValue('(no data)');
      }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
//~ Ext.override(Lino.RichTextPanel,Lino.FieldBoxMixin);



Lino.ActionFormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,Lino.PanelMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,Lino.FieldBoxMixin);
Lino.ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  //~ layout:'fit'
  //~ ,autoHeight: true
  //~ ,frame: true
  window_title: "Action Parameters",
  constructor : function(config){
    config.bbar = [
        {text:'OK',handler:this.on_ok,scope:this},
        {text:'Cancel',handler:this.on_cancel,scope:this}
    ];
    //~ config.items = config.params_panel;
    Lino.ActionFormPanel.superclass.constructor.call(this, config);
  }
  //~ ,initComponent : function(){
    //~ Lino.ActionFormPanel.superclass.initComponent.call(this);
  //~ }
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
    //~ var rp = this.requesting_panel;
    //~ console.log("on_ok",this.requesting_panel,arguments);
    //~ Lino.row_action_handler()
    var panel = this.requesting_panel;
    var actionName = this.action_name;
    var rec = panel.get_current_record();
    var self = this;
    function on_success() { self.get_containing_window().close(); };
    var fn = function(panel,btn,step) {
      var p = {};
      self.add_field_values(p)
      Lino.call_ajax_action(panel,'GET',panel.get_record_url(rec.id),p,actionName,step,fn,on_success);
    }
    fn(panel,null,null);
    
    
  }
  ,set_status : function(status,rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 ActionFormPanel.set_status()',status,rp,this.requesting_panel);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_field_values(status.field_values);
    if (status.base_params) this.set_base_params(status.base_params);
  }
  
  ,add_field_values : function (p) { // similar to add_param_values()
      //~ 20121023 
      if (this.form.isDirty()) {
        p.fv = this.get_field_values();
      }else{
        if (this.status_field_values) 
          p.fv = Lino.fields2array(this.fields,this.status_field_values);
      }
      //~ if (!this.form.isDirty()) return;
      //~ p.$ext_requests.URL_PARAM_FIELD_VALUES = this.get_field_values();
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
  }
  ,get_field_values : function() {
      return Lino.fields2array(this.fields);
  }
  ,set_field_values : function(pv) {
      //~ console.log('20120203 MainPanel.set_param_values', pv);
      this.status_field_values = pv;
      if (pv) this.form.my_loadRecord(pv);
      else this.form.reset(); 
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.title = this.window_title;
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok }
      ]
  }
});

Lino.fields2array = function(fields,values) {
    //~ console.log('20120116 gonna loop on', fields);
    var pv = Array(fields.length);
    for(var i=0; i < fields.length;i++) {
        var f = fields[i]
        if (values) 
          var v = values[f.name];
        else 
          var v = f.getValue();
        if (f.formatDate) {
            pv[i] = f.formatDate(v); 
        } else {
            pv[i] = v; // f.getValue(); 
        }
    }
    return pv;
}


Lino.FormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.FormPanel = Ext.extend(Lino.FormPanel,Lino.PanelMixin);
Lino.FormPanel = Ext.extend(Lino.FormPanel,{
  params_panel_hidden : false,
  //~ base_params : {},
  //~ trackResetOnLoad : true,
  //~ query_params : {},
  //~ 20110119b quick_search_text : '',
  constructor : function(config,params){
    if (params) Ext.apply(config,params);
    this.base_params = {};
    //~ ww.config.base_params.query = ''; // 20111018
    //~ console.log(config);
    //~ console.log('FormPanel.constructor() 1',config)
    //~ Ext.applyIf(config,{base_params:{}});
    //~ console.log('FormPanel.constructor() 2',config)
      
    config.trackResetOnLoad = true;
    
    Lino.FormPanel.superclass.constructor.call(this, config);
      
    //~ this.set_base_param('$URL_PARAM_FILTER',null); // 20111018
    //~ this.set_base_param('$URL_PARAM_FILTER',''); // 20111018
      
  },
  initComponent : function(){
    
    //~ console.log("20111201 containing_window",this.containing_window,this);
    
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    if (actions) {
        this.bbar = actions.bbar;
    //~ } else {
        //~ this.bbar = [];
    }
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ var config = this;
    
    //~ if (this.containing_window instanceof Lino.DetailWrapper) {
    
    //~ console.log('20120121 initComponent', this.action_name);
    //~ if (this.action_name == 'detail' | this.action_name == 'show') {
    //~ if (this.action_name != 'insert') {
    if (! this.hide_top_toolbar) {
      this.tbar = [];
      // 20111015    
      if (! this.hide_navigator) {
        this.record_selector = new Lino.RemoteComboFieldElement({
          store: new Lino.ComplexRemoteComboStore({
            //~ baseParams: this.containing_window.config.base_params,
            baseParams: this.get_base_params(),
            //~ value: this.containing_window.config.base_params.query,
            proxy: new Ext.data.HttpProxy({
              url: '/choices' + this.ls_url,
              method:'GET'
            })
          }),
          pageSize:25,
          listeners: { 
            scope:this, 
            select:function(combo,record,index) {
              //~ console.log('jumpto_select',arguments);
              this.goto_record_id(record.id);
            }
          },
          emptyText: "Go to record"
        })
        this.tbar = this.tbar.concat([this.record_selector]);
        
        this.tbar = this.tbar.concat([
          this.first = new Ext.Toolbar.Button({
            tooltip:"First",disabled:true,handler:this.moveFirst,scope:this,iconCls:'x-tbar-page-first'}),
          this.prev = new Ext.Toolbar.Button({
            tooltip:"Previous",disabled:true,handler:this.movePrev,scope:this,iconCls:'x-tbar-page-prev'}),
          this.next = new Ext.Toolbar.Button({
            tooltip:"Next",disabled:true,handler:this.moveNext,scope:this,iconCls:'x-tbar-page-next'}),
          this.last = new Ext.Toolbar.Button({
            tooltip:"Last",disabled:true,handler:this.moveLast,scope:this,iconCls:'x-tbar-page-last'})
        ]);
      }
      this.tbar = this.add_params_panel(this.tbar);
      
      //~ console.log(20101117,this.containing_window.refresh);
      this.tbar = this.tbar.concat([
        {
          //~ text:'Refresh',
          handler:function(){ this.do_when_clean(true,this.refresh.createDelegate(this)) },
          iconCls: 'x-tbar-loading',
          tooltip:"Reload current record",
          scope:this}
      ]);
          
      if (this.bbar) { // since 20121016
        if (this.tbar) {
            this.tbar = this.tbar.concat(['-']) ;
        } else {
          this.tbar = [];
        }
        this.tbar = this.tbar.concat(this.bbar) ;
        this.bbar = undefined;
      }
    
      this.tbar = this.tbar.concat([
          '->',
          this.displayItem = new Ext.Toolbar.TextItem({})
      ]);
          
    }
    //~ if (this.content_type && this.action_name != 'insert') {
      //~ this.bbar = this.bbar.concat([
        //~ '->',
        //~ { text: "[$_('Help Text Editor')]",
          //~ handler: Lino.help_text_editor,
          //~ qtip: "$_('Edit help texts for fields on this model.')",
          //~ scope: this}
      //~ ])
    //~ }
    //~ this.before_row_edit = config.before_row_edit.createDelegate(this);
      
    //~ if (this.master_panel) {
        //~ this.set_base_params(this.master_panel.get_master_params());
    //~ }
      
    Lino.FormPanel.superclass.initComponent.call(this);
    
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.bwrap,{msg:"Please wait..."});
    },this);
    
    
    //~ var this_ = this;
    //~ this.cascade(function(cmp){
      //~ // var active_field = false;
      //~ for (i = 0; i < this_.active_fields.length; i++) {
        //~ if (cmp.name == this_.active_fields[i]) {
            //~ // active_field = true; break;
            //~ cmp.on("change",function() {this_.save()});
        //~ }
      //~ };
      //~ if (active_field) {
      // if (cmp instanceof Lino.GridPanel) {
          //~ cmp.on("change",function() {this_.save()});
      //~ }
    //~ });
    
    if (this.action_name == 'insert') {
      this.cascade(function(cmp){
        // console.log('20110613 cascade',cmp);
        if (cmp.disabled_in_insert_window) {
            //~ cmp.disable();
            cmp.hide();
        }
      });
      
    }
    
  },
  
  is_loading : function() { 
    if (this.current_record == null) return true; 
    var loading = false;
    this.cascade(function(cmp){
        if (cmp instanceof Lino.GridPanel && cmp.is_loading()) {
            //~ console.log(cmp.title,'is loading');
            loading = true;
            return false;
        }
      });
    return loading;
    //~ var a = this.findByType(Lino.GridPanel);
    //~ for (i=0;i<a.length;i++) {
        //~ if (a[i].is_loading()) return true;
    //~ }
    //~ return false;
  },
  
  get_status : function(){
      var st = {
        base_params: this.get_base_params(),
        data_record : this.get_current_record()
        }
      var tp = this.items.get(0);
      if (tp instanceof Ext.TabPanel) {
        st.active_tab = tp.getActiveTab();
      }
      st.param_values = this.status_param_values;
      return st;
  },
  set_status : function(status,rp){
    this.requesting_panel = Ext.getCmp(rp);
    //~ console.log('20120918 FormPanel.set_status()',status);
    this.clear_base_params();
    if (status == undefined) status = {};
    //~ if (status.param_values) 
    this.set_param_values(status.param_values);
    if (status.base_params) this.set_base_params(status.base_params);
    var tp = this.items.get(0);
    if (tp instanceof Ext.TabPanel) {
      if (status.active_tab) {
        //~ console.log('20111201 active_tab',this.active_tab,this.items.get(0));
        //~ tp.activeTab = status.active_tab;
        tp.setActiveTab(status.active_tab);
        //~ this.main_item.items.get(0).activate(status.active_tab);
      } else {
        tp.setActiveTab(0);
      }
      }
    
    if (status.data_record) {
      //~ console.log('20111201 Lino.FormPanel with data_record',this.data_record.title,this.containing_window);
      //~ this.main_item.on_master_changed.defer(2000,this.main_item,[status.data_record]);
      //~ Lino.do_when_visible(this.main_item,function(){this.on_master_changed(status.data_record)});
      //~ this.main_item.on('afterrender',function(){
      //~   this.main_item.on_master_changed(status.data_record)},this,{single:true});
      /* must defer because because set_window_title() didn't work otherwise */
      this.set_current_record.createDelegate(this,[status.data_record]).defer(100);
      //~ this.set_current_record(this.data_record);
      //~ return;
    } else if (status.record_id != undefined) { 
      /* possible values include 0 and null, 0 being a valid record id, 
      null the equivalent of undefined
      */
      //~ this.main_item.goto_record_id(this.status.record_id);
      this.load_record_id(status.record_id);
    } else {
      this.set_current_record(undefined);
    }
  },
    
  get_base_params : function() {
    // needed for insert_action
    var p = Ext.apply({},this.base_params);
    Lino.insert_subst_user(p);
    return p;
    //~ return this.base_params;
  },
  set_base_params : function(p) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    delete p['query'] // 20120725
    Ext.apply(this.base_params,p);
    if (this.record_selector) {
        var store = this.record_selector.getStore();
        for (k in p) store.setBaseParam(k,p[k]);
        delete this.record_selector.lastQuery;
        //~ console.log("20120725 record_selector.setBaseParam",p)
    }
  },
  clear_base_params : function() {
      this.base_params = {};
      Lino.insert_subst_user(this.base_params);
        
      //~ if (this.record_selector) {
          //~ var store = this.record_selector.getStore();
          //~ for (k in store.baseParams) store.setBaseParam(k,undefined);
          //~ delete this.record_selector.lastQuery;
          //~ console.log("20120725 record_selector.getBaseParams() -->",store.baseParams)
      //~ }
  },
  set_base_param : function(k,v) {
    //~ this.base_params = Ext.apply({},this.base_params); // make sure it is an instance variable
    this.base_params[k] = v;
    //~ if (this.record_selector) {
        //~ this.record_selector.getStore().setBaseParam(k,v);
        //~ delete this.record_selector.lastQuery;
    //~ }
  },
  
  after_delete : function() {
    if (this.current_record.navinfo.next)
      this.moveNext();
    else if (this.current_record.navinfo.prev)
      this.movePrev();
    else 
      this.abandon();
  },
  moveFirst : function() {this.goto_record_id(this.current_record.navinfo.first)},
  movePrev : function() {this.goto_record_id(this.current_record.navinfo.prev)},
  moveNext : function() {this.goto_record_id(this.current_record.navinfo.next)},
  moveLast : function() {this.goto_record_id(this.current_record.navinfo.last)},
  
  
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ console.log('20120121 Lino.FormPanel.refresh()',this);
    if (this.current_record) {
        this.load_record_id(this.current_record.id,after);
    } else {
        this.set_current_record(undefined,after);
    }
  },
  
  do_when_clean : function(auto_save,todo) {
    var this_ = this;
    if (this.form.isDirty()) {
        if (auto_save) {
            this_.save(todo);
        } else {
          //~ console.log('20111217 do_when_clean() form is dirty',this.form);
          var config = {title:"Confirmation"};
          config.buttons = Ext.MessageBox.YESNOCANCEL;
          config.msg = "Save changes to current record ?";
          config.fn = function(buttonId,text,opt) {
            //~ console.log('do_when_clean',buttonId)
            if (buttonId == "yes") {
                //~ Lino.submit_detail(this_,undefined,todo);
                //~ this_.containing_window.save(todo);
                this_.save(todo);
            } else if (buttonId == "no") { 
              todo();
            }
          }
        }
        Ext.MessageBox.show(config);
    }else{
      //~ console.log('do_when_clean : now!')
      todo();
    }
  },
  
  goto_record_id : function(record_id) {
    //~ console.log('20110701 Lino.FormPanel.goto_record_id()',record_id);
    //~ var this_ = this;
    //~ this.do_when_clean(function() { this_.load_record_id(record_id) }
    this.do_when_clean(true,this.load_record_id.createDelegate(this,[record_id]));
  },
  
  load_record_id : function(record_id,after) {
    var this_ = this;
    //~ var p = { fmt: this.containing_window.config.action_name};
    //~ var p = Ext.apply({},this.containing_window.config.base_params);
    var p = Ext.apply({},this.get_base_params());
    //~ Lino.insert_subst_user(p);
    //~ console.log('20110713 action_name=',this.containing_window.config.action_name,
      //~ 'base_params=',this.containing_window.config.base_params);
    if (this.action_name)
        p.an = this.action_name;
    //~ p.an = this.action_name;
    //~ p.an = this.containing_window.config.action_name;
    //~ p.fmt = 'json';
    //~ p.fmt = '$ext_requests.URL_FORMAT_JSON';
    p.rp = this.getId();
    //~ p.$ext_requests.URL_PARAM_SUBST_USER = Lino.subst_user;
    p.fmt = 'json';
    //~ 20110119b p['$URL_PARAM_FILTER'] = this.quick_search_text;
    //~ Ext.apply(p,this.query_params);
    this.add_param_values(p);
    //~ console.log('20121120 FormPanel.load_record_id',record_id,p);
    if (this.loadMask) this.loadMask.show();
    Ext.Ajax.request({ 
      waitMsg: 'Loading record...',
      method: 'GET',
      params: p,
      scope: this,
      url: this.get_record_url(record_id),
      success: function(response) {   
        // todo: convert to Lino.action_handler.... but result 
        if (this.loadMask) this.loadMask.hide();
        if (response.responseText) {
          var rec = Ext.decode(response.responseText);
          //~ console.log('20120918 goto_record_id success',rec);
          this.set_param_values(rec.param_values);
          this.set_current_record(rec,after);
        }
      },
      failure: Lino.ajax_error_handler(this)
    });
  },

  abandon : function () {
    Ext.MessageBox.alert('Note',
      "No more records to display. Detail window has been closed.");
    Lino.close_window();
    //~ if (this.containing_window) {
        //~ this.containing_window.hide();
    //~ }
  },
  
  set_current_record : function(record,after) {
    //~ console.log('20120722 Lino.FormPanel.set_current_record',record.title,record);
    if (this.record_selector) {
        this.record_selector.clearValue();
        // e.g. InsertWrapper FormPanel doesn't have a record_selector
    }
    this.current_record = record;
    //~ if (record) 
        //~ console.log('Lino.FormPanel.set_current_record',record.title,record);
    //~ else
        //~ console.log('Lino.FormPanel.set_current_record',record);
    //~ this.config.main_panel.form.load(record);    
    if (record) {
      this.enable();
      this.form.my_loadRecord(record.data);
      this.set_window_title(record.title);
      //~ this.getBottomToolbar().enable();
      var da = record.data.disabled_actions;
      if (da) {
          //~ console.log('20120528 disabled_actions =',da,this.getBottomToolbar());
          //~ 20121016 this.getBottomToolbar().items.each(function(item,index,length){
          var tb = this.getTopToolbar();
          if (tb) tb.items.each(function(item,index,length){
              //~ console.log('20120528 ',item.itemId,'-->',da[item.itemId]);
              if (da[item.itemId]) item.disable(); else item.enable();
          });
      };
      if (this.disable_editing | record.data.disable_editing) {
          //~ console.log("20120202 disable_editing",record.title);
          this.form.items.each(function(cmp){
            if (!cmp.always_enabled) cmp.disable();
          },this);
      } else {
          this.form.items.each(function(cmp){
            //~ console.log("20120202",cmp);
            if (record.data.disabled_fields[cmp.name]) cmp.disable();
            else cmp.enable();
          },this);
        
          //~ if (record.data.disabled_fields) {
              //~ for (i = 0; i < record.data.disabled_fields.length; i++) {
                  //~ var flds = this.find('name',record.data.disabled_fields[i]);
                  //~ if (flds.length == 1) { 
                    //~ flds[0].disable(); 
                  //~ }
              //~ }
          //~ }
      };
      
      if (record.navinfo && ! this.hide_top_toolbar && ! this.hide_navigator) {
        //~ if (record.navinfo.recno == 0) {
            //~ this.first.setDisabled(true);
            //~ this.prev.setDisabled(true);
            //~ this.next.setDisabled(true);
            //~ this.last.setDisabled(true);
        //~ } else {
            this.first.setDisabled(!record.navinfo.first);
            this.prev.setDisabled(!record.navinfo.prev);
            this.next.setDisabled(!record.navinfo.next);
            this.last.setDisabled(!record.navinfo.last);
        //~ }
        this.displayItem.setText(record.navinfo.message);
      }
    } else {
      if (this.form.rendered) 
        this.form.reset(); /* FileUploadField would fail when resetting a non-rendered form */
      //~ this.disable();
      //~ this.getBottomToolbar().disable();
      this.form.items.each(function(cmp){
        cmp.disable();
      },this);
      this.set_window_title(this.empty_title);
      //~ this.containing_window.window.setTitle(this.empty_title);
      if (!this.hide_navigator) {
        this.first.disable();
        this.prev.disable();
        this.next.disable();
        this.last.disable();
      }
    }
    //~ console.log('20100531 Lino.DetailMixin.on_load_master_record',this.main_form);
    this.before_row_edit(record);
    if (after) after();
  },
  
  before_row_edit : function(record) {},
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.refresh();
  },
  
  get_selected : function() { return [ this.current_record ] },
  get_current_record : function() {  
    //~ console.log(20100714,this.current_record);
    return this.current_record 
  },
  
  get_permalink_url : function() {
      var rec = this.get_current_record();
      if (rec && ! rec.phantom && rec.id != -99998)
          return '/api' + this.ls_url + '/' + rec.id;
      return '/api' + this.ls_url;
    
  },
  get_permalink_params : function() {
    var p = {};
    //~ var p = {an:'detail'};
    if (this.action_name)
        p.an = this.action_name;
    //~ var p = {an:this.action_name};
    var main = this.items.get(0);
    if (main.activeTab) {
      var tab = main.items.indexOf(main.activeTab);
      //~ console.log('main.activeTab',tab,main.activeTab);
      if (tab) p.tab = tab;
    }
    this.add_param_values(p)
    return p;
  },
  
  /* 
  Lino.FormPanel.save() 
  */
  save : function(after,switch_to_detail,action_name) {
    //~ var panel = this;
    //~ console.log('20121120 FormPanel.save');
    this.loadMask.show();
    var rec = this.get_current_record();
    if (this.has_file_upload) this.form.fileUpload = true;
    //~ console.log('FormPanel.save()',rec);
    if (!action_name) action_name = this.action_name;
    if (rec) {
      var p = {};
      Ext.apply(p,this.get_base_params());
      p.rp = this.getId();
      //~ if (this.action_name) 
          //~ p.$ext_requests.URL_PARAM_ACTION_NAME = this.action_name;
      p.an = action_name;
      if (rec.phantom) {
        //~ if (this.action_name != 'insert') 
            //~ console.log("Warning: phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: '/api' + this.ls_url,
          method: 'POST',
          params: p, 
          scope: this,
          success: function(form, action) {
            this.loadMask.hide();
            Lino.notify(action.result.message);
            /***
            Close this window, but update the status of the 
            calling window.
            If the calling window is a detail on the same table,
            then it should skip to the new record. But only then.
            A successful response usually has a data_record,
            except if it is a fileupload form where some mysterious 
            decoding problems (20120209) force us to return a record_id 
            which will lead to an additional GET.
            ***/
            var url = this.ls_url;
            var ww = Lino.calling_window();
            if (ww && ww.window.main_item instanceof Lino.FormPanel 
                   && ww.window.main_item.ls_url == this.ls_url) {
                //~ console.log("20120217 case 1");
                ww.status.record_id = action.result.record_id;
                ww.status.data_record = action.result.data_record;
                Lino.close_window();
            } else if (this.ls_detail_handler && switch_to_detail) {
                //~ console.log("20120217 case 2");
                Lino.kill_current_window();
                this.ls_detail_handler.run(null,{
                    record_id:action.result.record_id,
                    data_record: action.result.data_record,
                    base_params:this.get_base_params()
                });
            } else {
                //~ console.log("20120217 case 3");
                Lino.close_window();
            }
            //~ Lino.close_window(function(ww){
                //~ if (ww.window.main_item instanceof Lino.FormPanel 
                    //~ && ww.window.main_item.ls_url == url) {
                  //~ ww.status.record_id = action.result.record_id,
                  //~ ww.status.data_record = action.result.data_record
                //~ }
            //~ });
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action);
          },
          clientValidation: true
        })
      } else {
        //~ if (this.action_name != 'detail') 
            //~ console.log("Warning: non-phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: '/api' + this.ls_url + '/' + rec.id,
          method: 'PUT',
          //~ headers: { 'HTTP_X_REQUESTED_WITH' : 'XMLHttpRequest'},
          scope: this,
          params: p, 
          success: function(form, action) {
            //~ panel.form.setValues(rec.data);
            //~ 20110701 panel.form.my_loadRecord(rec);
            this.loadMask.hide();
            Lino.notify(action.result.message);
            if (action.result.data_record)
                this.set_current_record(action.result.data_record,after);
            else
                console.log("Warning: no data_record in response to FormPanel.PUT")
            //~ this.refresh_with_after(after);
            //~ if (after) after(); else panel.refresh();
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action)},
          clientValidation: true
        })
      }
    } else Lino.notify("Sorry, no current record.");
  }
  
  ,on_cancel : function() { 
    this.get_containing_window().close();
  }
  ,on_ok : function() { 
      this.save(null,true);
      //~ var rec = this.get_current_record();
      //~ if (rec && rec.phantom)
          //~ this.do_when_clean(true,function() { Lino.close_window(); });
  }
  ,config_containing_window : function(wincfg) { 
      wincfg.keys = [
        { key: Ext.EventObject.ENTER, fn: this.on_ok, scope:this }
        ,{ key: Ext.EventObject.ESCAPE, fn: this.on_cancel, scope:this }
      ]
  }
  
  
  /* not used (no longer possible without .dtl files)
  , edit_detail_config : function () {
    var active_tab = {};
    var main = this.items.get(0);
    if (main.getActiveTab !== undefined) {
      var tabitem = main.getActiveTab();
      Ext.apply(active_tab,{$ext_requests.URL_PARAM_TAB : main.items.indexOf(tabitem)});
    }
    var editor = new Ext.form.TextArea();
    var close = function() { win.close(); }
    var _this = this;
    var save = function() { 
      //~ console.log(20110609,arguments); 
      var params = {desc: editor.getValue()};
      Ext.apply(params,active_tab);
      var a = { 
        params: params, 
        method: 'PUT',
        url: ADMIN_URL + '/detail_config' + _this.ls_url,
        failure : Lino.ajax_error_handler(this),
        success: Lino.action_handler( _this, function(result) {
          //~ console.log('detail_config/save success',result);
          win.close();
          document.location = _this.get_permalink();
        })
      };
      //~ console.log('detail_config/save sent',a);
      _this.loadMask.show(); // 20120211
      Ext.Ajax.request(a);
    }
    var save_btn = new Ext.Button({text:'Save',handler:save,disabled:true});
    var win = new Ext.Window({title:'Detail Layout',
      items:editor, layout:'fit',
      width:500,height:500,
      bbar:[{text:'Cancel',handler:close},save_btn]});
    var a = { 
      params:active_tab, 
      method:'GET',
      url:ADMIN_URL+'/detail_config'+_this.ls_url,
      success : function(response) {
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          if (result.success) {
            editor.setValue(result.desc);
            save_btn.enable();
          }
        }
      }
    };
    Ext.Ajax.request(a);
    win.show();
  }
  */
});


Lino.getRowClass = function(record, rowIndex, rowParams, store) {
  if (record.phantom) {
    //~ console.log(20101009,record);
    //~ rowParams.bodyStyle = "color:red;background-color:blue";
    return 'lino-phantom-row';
    }
  //~ console.log('20101009 not a phantom:',record);
  return '';
}

//~ FOO = 0;



Lino.GridStore = Ext.extend(Ext.data.ArrayStore,{ 
  autoLoad: false
  ,load: function(options) {
    //~ foo.bar = baz; // 20120213
    if (!options) options = {};
    if (!options.params) options.params = {};
    options.params.fmt = 'json';
    options.params.rp = this.grid_panel.getId();
    Lino.insert_subst_user(options.params); // since 20121016
      
    
    if (this.grid_panel.hide_top_toolbar) {
        //~ console.log("20120206 GridStore.load() toolbar is hidden");
        options.params.start = 0;
        if (this.grid_panel.preview_limit) {
          options.params.limit = this.grid_panel.preview_limit;
        }
    } else {
        var ps = this.grid_panel.calculatePageSize();
        if (!ps) {
            //~ this.gridpanel.on('render',this.load())
          //~ console.log("20120814 GridStore.load() failed to calculate pagesize");
          return false;
            //~ params.$URL_PARAM_LIMIT = 1;
            //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
            //~ return;
        } 
        options.params.limit = ps;
      
        //~ options.params.start = this.grid_panel.getTopToolbar().cursor;
        //~ if (this.grid_panel.getTopToolbar().pageSize !=  ps) {
          //~ console.log("20120206 abort load because toolbar says pagesize",
            //~ this.grid_panel.getTopToolbar().pageSize,
            //~ "while actual pagesize is",ps);
            //~ return;
        //~ }
        
        this.grid_panel.getTopToolbar().pageSize =  ps;
        if (options.params.start == undefined)
            options.params.start = this.grid_panel.getTopToolbar().cursor;
      
    }
      
    this.grid_panel.add_param_values(options.params);
    //~ Lino.insert_subst_user(options.params);
    //~ console.log("20120814 GridStore.load()",options.params,this.baseParams);
    //~ if (FOO > 0) {
        //~ foo.bar = baz;
    //~ } else FOO += 1;
    return Lino.GridStore.superclass.load.call(this,options);
  }
});

    
Lino.GridPanel = Ext.extend(Ext.grid.EditorGridPanel,Lino.MainPanel);
Lino.GridPanel = Ext.extend(Lino.GridPanel,Lino.PanelMixin);
Lino.GridPanel = Ext.extend(Lino.GridPanel,{
  quick_search_text : '',
  is_searching : false,
  disabled_in_insert_window : true,
  clicksToEdit:2,
  enableColLock: false,
  autoHeight: false,
  params_panel_hidden : false,
  preview_limit : undefined, 
  //~ loadMask: true,
  //~ viewConfig: {
          //~ getRowClass: Lino.getRowClass,
          //~ emptyText:"$_('No data to display.')"
        //~ },
  loadMask: {msg:"Please wait..."},
  
  constructor : function(config){

    config.plugins = [new Lino.GridFilters()];
    
    
    Lino.GridPanel.superclass.constructor.call(this,config);
    
    //~ if (this.containing_window) {
        //~ console.log("20111206 install refresh");
        //~ this.containing_window.on('show',this.refresh,this);
    //~ }
    
  },
  
  is_loading : function() { 
    //~ return this.store.getCount() > 0; 
    return !this.loadMask.disabled; 
  },
  
  unused_config_containing_window : function(wincfg) { 
      //~ temporarily remove save_grid_config button (see /blog(2012/1107)
      if (wincfg.tools != undefined) 
        wincfg.tools = [
          //~ {handler:this.save_grid_data,
            //~ qtip:"$_("Save Grid Data")",
            //~ scope:this, id:"save_data"}, // 20120814
          {handler:this.save_grid_config,
            qtip:"Save Grid Configuration",
            scope:this, id:"save"}
        ].concat(wincfg.tools);
      //~ wincfg.listeners = { show: ... };
  },
  init_containing_window : function(win) { 
    //~ console.log("20111206 install refresh");
    //~ win.on('show',this.refresh,this);
  },
  
  initComponent : function(){
    
    /* 
    Problem 20111206:
    When a GridPanel is the main item of the window, then it doesn't 
    have it's own header but uses the window's header bar.
    We must do this in initComponent because e.g. in beforerender 
    it's already to late: a header element has been created because 
    there was a title.
    But Lino.Window adds itself as `this.containing_window` 
    only after the GridPanel has been initialized.
    Workaround is to generate a line "params.containing_window = true;" 
    in the handler function.
    */ 
    //~ if (this.containing_window) {
    if (this.is_main_window) {
        //~ console.log(20111206, 'delete title',this.title,'from',this);
        //~ delete this.title;
        this.tools = undefined;  
        this.title = undefined;  /* simply deleting it 
          isn't enough because that would only 
          unhide the title defined in some base class. */
    } 
    //~ else console.log(20111206, 'dont delete title',this.title,'from',this);
    
    /* e.g. when slave gridwindow called from a permalink */
    //~ if (this.base_params) Ext.apply(bp,this.base_params);  
    //~ bp['fmt'] = 'json';
    
    //~ function on_proxy_write( proxy, action,data, response,rs,options) {
      //~ console.log('20120814 on_proxy_write',action,data,response)
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
    //~ }
    //~ function on_proxy_load( proxy, transactionObject, callbackOptions ) {
      //~ console.log('on_proxy_load',transactionObject)
    //~ }
    var proxy = new Ext.data.HttpProxy({ 
      // 20120814 
      url: '/api' + this.ls_url
      ,method: "GET"
      //~ ,url: ADMIN_URL + '/restful' + this.ls_url
      //~ ,restful: true 
      //~ ,listeners: {load:on_proxy_load} 
      //~ ,listeners: {write:on_proxy_write} 
    });
    //~ config.store = new Ext.data.JsonStore({ 
    //~ this.store = new Ext.data.ArrayStore({ 
    this.store = new Lino.GridStore({ 
      grid_panel: this
      ,listeners: { exception: Lino.on_store_exception }
      ,remoteSort: true
      ,totalProperty: "count"
      ,root: "rows"
      //~ ,id: "id" 
      ,proxy: proxy
      //~ autoLoad: this.containing_window ? true : false
      ,idIndex: this.pk_index
      //~ ,baseParams: bp
      ,fields: this.ls_store_fields
      ,idProperty: this.ls_id_property 
      // 20120814
      //~ ,writer : new Ext.data.JsonWriter({
        //~ writeAllFields: false
        //~ ,listful: true
      //~ })
      //~ ,restful : true
    });
      
    //~ console.log('config.pk_index',config.pk_index,config.store),
    delete this.ls_store_fields;
      
    var this_ = this;
    //~ var grid = this;
    this.store.on('load', function() {
        //~ console.log('20120814 GridStore.on(load)',this_.store);
        //~ var da = this_.store.reader.arrayData.disabled_actions;
        //~ if (da) {
            //~ this.cmenu.cascade(function(item){ 
              //~ console.log(20120531, item.itemId, da[item.itemId]);
              //~ if (da[item.itemId]) item.disable(); else item.enable();
            //~ });
        //~ };
        this_.set_param_values(this_.store.reader.arrayData.param_values);
        //~ this_.set_status(this_.store.reader.arrayData.status);
        //~ 20120918
        if (this_.store.reader.arrayData.no_data_text) {
            //~ this.viewConfig.emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().emptyText = this_.store.reader.arrayData.no_data_text;
            this.getView().refresh();
        }
        if (this_.containing_window)
            this_.set_window_title(this_.store.reader.arrayData.title);
            //~ this_.containing_window.setTitle(this_.store.reader.arrayData.title);
        if (!this.is_searching) { // disabled 20121025: quick_search_field may not lose focus
          this.is_searching = false;
          if (this_.selModel.getSelectedCell){
              if (this_.getStore().getCount()) // there may be no data
                  this_.selModel.select(0,0); 
          } else {
              this_.selModel.selectFirstRow();
              this_.getView().focusEl.focus();
          }
        } 
        //~ else console.log("is_searching -> no focussing");
        //~ var t = this.getTopToolbar();
        //~ var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
        //~ this.quick_search_field.focus(); // 20121024
      }, this
    );
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar, this.cmenu = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ this.cmenu = new Ext.menu.Menu({items: config.bbar});
    delete this.ls_bbar_actions
    if (actions) {
        this.cmenu = actions.cmenu;
    }
    
    if (!this.hide_top_toolbar) {  
      var tbar = [ 
        this.quick_search_field = new Ext.form.TextField({ 
          //~ fieldLabel: "Search"
          listeners: { 
            scope:this_
            //~ ,change:this_.search_change
            
            ,render: Lino.quicktip_renderer("Quick Search","Enter a text to use as quick search filter")
            
            //~ ,keypress: this.search_keypress 
            ,blur: function() { this.is_searching = false}
          }
          ,validator:function(value) { return this_.search_validate(value) }
          //~ ,tooltip: "Enter a quick search text, then press TAB"
          //~ value: text
          //~ scope:this, 
          //~ ,enableKeyEvents: true
          //~ listeners: { keypress: this.search_keypress }, 
          //~ id: "seachString" 
      })];
      tbar = this.add_params_panel(tbar);
      tbar = tbar.concat([
        { scope:this, 
          //~ text: "[csv]", 
          tooltip: "Export this table to a .csv file", 
          iconCls: 'x-tbar-csv',
          handler: function() { 
            //~ 20130116 var p = Ext.apply({},this.get_base_params());
            //~ 20130116 p.fmt = 'csv';
            //~ url += "?" + Ext.urlEncode(p);
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            p.fmt = "csv";
            this.add_param_values(p);
            
            window.open('/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } },
        //~ { scope:this, 
          //~ text: "[html]", 
          //~ handler: function() { 
            //~ var p = this.get_current_grid_config();
            //~ Ext.apply(p,this.get_base_params());
            //~ p.$ext_requests.URL_PARAM_FORMAT = "$ext_requests.URL_FORMAT_PRINTER";
            //~ this.add_param_values(p);
            //~ window.open(ADMIN_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          //~ } },
        { scope:this, 
          //~ text: "[html]", 
          tooltip: "Show this table in plain html", 
          iconCls: 'x-tbar-html',
          handler: function() { 
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            //~ since 20121226 p.$ext_requests.URL_PARAM_FORMAT = "$ext_requests.URL_FORMAT_PLAIN";
            this.add_param_values(p);
            //~ since 20121226 window.open(ADMIN_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
            window.open('/plain'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } },
        { scope:this, 
          //~ text: "[pdf]", 
          tooltip: "Show this table as a pdf document", 
          iconCls: 'x-tbar-pdf',
          handler: function() { 
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            p.fmt = "pdf";
            this.add_param_values(p);
            window.open('/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } }
      ]);
    
    
      var menu = [];
      var set_gc = function(index) {
        return function() {
          //~ console.log('set_gc() 20100812');
          this.getColumnModel().setConfig(
              this.apply_grid_config(index,this.ls_grid_configs,this.ls_columns));
        }
      }
      for (var i = 0; i < this.ls_grid_configs.length;i++) {
        var gc = this.ls_grid_configs[i];
        menu.push({text:gc.label,handler:set_gc(i),scope:this})
      }
      if(menu.length > 1) {
        tbar = tbar.concat([
          { text:"View",
            menu: menu,
            tooltip:"Select another view of this report"
          }
        ]);
      }
      
      if (actions) {
        tbar = tbar.concat(actions.bbar);
          //~ this.bbar = actions.bbar;
      }
      
      this.tbar = new Ext.PagingToolbar({ 
        store: this.store, 
        prependButtons: true, 
        //~ pageSize: this.page_length, 
        pageSize: 1, 
        displayInfo: true, 
        beforePageText: "Page",
        afterPageText: "of {0}",
        displayMsg: "Displaying {0} - {1} of {2}",
        firstText: "First page",
        lastText: "Last page",
        prevText: "Previous page",
        nextText: "Next page",
        items: tbar
      });
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ var ps = this.calculatePageSize();
          //~ if (ps && ps != this.getTopToolbar().pageSize) {
              //~ // console.log('20120203 resize : pageSize',this.getTopToolbar().pageSize,'->',ps);
              //~ // this.getTopToolbar().pageSize =  ps;
              //~ cmp.refresh();
              //~ // this.getTopToolbar().doRefresh();
          //~ }
        //~ }, this);
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ cmp.getTopToolbar().pageSize = this.calculatePageSize(aw,ah,rw,rh) || 10;
          //~ cmp.refresh();
        //~ }, this, {delay:500});
    }
    
    //~ delete this.page_length
    
    
      
    if (this.ls_quick_edit) {
      this.selModel = new Ext.grid.CellSelectionModel()
      this.get_selected = function() {
        //~ console.log(this.getSelectionModel().selection);
        if (this.selModel.selection)
            return [ this.selModel.selection.record ];
        return [this.store.getAt(0)];
      };
      this.get_current_record = function() { 
        if (this.getSelectionModel().selection) 
          return this.selModel.selection.record;
        return this.store.getAt(0);
      };
    } else { 
      this.selModel = new Ext.grid.RowSelectionModel() 
      this.get_selected = function() {
        var sels = this.selModel.getSelections();
        if (sels.length == 0) sels = [this.store.getAt(0)];
        return sels
        //~ var sels = this.getSelectionModel().getSelections();
        //~ return Ext.pluck(sels,'id');
      };
      this.get_current_record = function() { 
        var rec = this.selModel.getSelected();
        if (rec == undefined) rec = this.store.getAt(0);
        return rec
      };
    };
    delete this.ls_quick_edit;
    
    this.columns  = this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns);
    
    //~ var grid = this;
    //~ this.colModel = new Ext.grid.ColumnModel({
      //~ columns: this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns),
      //~ isCellEditable: function(col, row) {
        //~ var record = grid.store.getAt(row);
        //~ console.log('20120514',col,record); // dataIndex
        //~ var dataIndex = grid.colModel.getDataIndex(col);
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("$_("This field is disabled")");
            //~ return false;
        //~ }
        //~ return Ext.grid.ColumnModel.prototype.isCellEditable.call(this, col, row);
      //~ }
    //~ });    
    
    
    Lino.GridPanel.superclass.initComponent.call(this);
    
    //~ if (this.containing_window) 
        //~ this.on('afterlayout', this.refresh, this);
        //~ this.on('afterrender', this.refresh,this);
    //~ else
        //~ this.on('show', this.refresh,this);
    //~ this.on('afterlayout', function() {
      //~ if (this.id == "ext-comp-1157") 
        //~ console.log("20120213 afterlayout",this); 
      //~ // this.refresh();
      //~ },this);
    //~ this.on('afterrender', this.refresh);
    //~ this.on('resize', this.refresh,this,{delay:500});
    //~ this.on('resize', function(){console.log("20120213 resize",arguments)},this);
    this.on('resize', function(){
      //~ console.log("20120213 resize",arguments)
      this.refresh();
      },this);
    this.on('viewready', function(){
      //~ console.log("20120213 resize",arguments);
      this.view_is_ready = true;
      this.refresh();
      },this);
    this.on('afteredit', this.on_afteredit); // 20120814
    //~ this.on('afteredit', this.new_on_afteredit);
    this.on('beforeedit', this.on_beforeedit);
    this.on('beforeedit',function(e) { this.before_row_edit(e.record)},this);
    this.on('cellcontextmenu', Lino.cell_context_menu, this);
    //~ this.on('contextmenu', Lino.grid_context_menu, this);
    
    
    //~ if (this.id == "ext-comp-1157") captureEvents(this);    
    
  },
  
  //~ onResize : function(){
      //~ console.log("20120206 GridPanel.onResize",arguments);
      //~ Lino.GridPanel.superclass.onResize.apply(this, arguments);
      //~ this.refresh();
  //~ },
  
  
  get_status : function(){
    var st = { base_params : this.get_base_params()};
    if (!this.hide_top_toolbar) {
        st.current_page = this.getTopToolbar().current;
    }
    st.param_values = this.status_param_values;
    //~ console.log("20120213 GridPanel.get_status",st);
    return st;
  },
  
  /* 
  Lino.GridPanel.set_status() 
  */
  set_status : function(status){
    //~ console.log("20120918 GridPanel.set_status",status);
    this.clear_base_params();
    if (status == undefined) status = {};
    this.set_param_values(status.param_values);
    if (status.base_params) { 
      this.set_base_params(status.base_params);
    }
    if (!this.hide_top_toolbar) {
      //~ console.log("20120213 GridPanel.getTopToolbar().changePage",
          //~ status.current_page || 1);
      this.getTopToolbar().changePage(status.current_page || 1);
    }
    //~ this.fireEvent('resize');
    //~ this.refresh.defer(100,this); 
    //~ this.onResize.defer(100,this); 
    //~ this.refresh(); 
    //~ this.doLayout(); 
    //~ this.onResize(); 
    //~ this.store.load();
  },
  
  refresh : function(unused) { 
    this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ Lino.notify('20120204 Lino.GridPanel.refresh');
    //~ Lino.notify('Lino.GridPanel.refresh '+this.store.proxy.url);
    //~ var bp = { fmt:'json' }
    if (this.containing_panel) {
        //~ Ext.apply(p,this.master_panel.get_master_params());
        //~ Ext.apply(options.params,this.containing_panel.get_master_params());
        this.set_base_params(this.containing_panel.get_master_params());
    }
    
    if (! this.view_is_ready) return;
    
    var options = {};
    if (after) {
        options.callback = function(r,options,success) {if(success) after()}
    }
      
    //~ if (!this.rendered) {
        //~ console.log("20120206 GridPanel.refresh() must wait until rendered",options);
        //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
        //~ return;
    //~ }
    
    this.store.load(options);
  },
  
  /* pageSize depends on grid height (Trying to remove scrollbar)
  Thanks to 
  - Christophe Badoit on http://www.sencha.com/forum/showthread.php?82647
  - http://www.sencha.com/forum/archive/index.php/t-37231.html
  */
  calculatePageSize : function(second_attempt) {
    //~ if (!this.rendered) { 
    if (!this.view_is_ready) { 
      //~ console.log('Cannot calculatePageSize() : not rendered');
      return false; }
    //~ if (!this.isVisible()) { 
      //~ console.log('calculatePageSize : not visible');
      //~ return false; }
      
    //~ console.log('getFrameHeight() is',this.getFrameHeight());
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('mainBody.getHeight() is',this.getView().mainBody.getHeight());
    //~ console.log('getInnerHeight() is',this.getInnerHeight());
    //~ console.log('getHeight() is',this.getHeight());
    //~ console.log('el.getHeight() is',this.getEl().getHeight());
    //~ console.log('getGridEl().getHeight() is',this.getGridEl().getHeight());
    //~ console.log('getOuterSize().height is',this.getOuterSize().height);
    //~ console.log('getBox().height is',this.getBox().height);
    //~ console.log('getResizeEl.getHeight() is',this.getResizeEl().getHeight());
    //~ console.log('getLayoutTarget().getHeight() is',this.getLayoutTarget().getHeight());
      
    var rowHeight = this.getFrameHeight();
    //~ var rowHeight = 52; // experimental value
    var row = this.view.getRow(0);
    if (row) {
      //~ console.log('20120213 yes');
      rowHeight = Ext.get(row).getHeight();
    }
    //~ console.log('rowHeight is ',rowHeight,this,caller);
    //~ this.getView().syncScroll();
    //~ this.getView().initTemplates();
    var height = this.getView().scroller.getHeight();
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('getInnerHeight() - getFrameHeight() is',
      //~ this.getInnerHeight(), '-',
      //~ this.getFrameHeight(), '=',
      //~ this.getInnerHeight() - this.getFrameHeight());
    //~ var height = this.getView().mainBody.getHeight();
    //~ var height = this.getView().mainWrap.getHeight();
    //~ var height = this.getView().resizeMarker.getHeight();
    //~ this.syncSize();
    //~ var height = this.getInnerHeight() - this.getFrameHeight();
    //~ var height = this.getHeight() - this.getFrameHeight();
    height -= Ext.getScrollBarWidth(); // leave room for a possible horizontal scrollbar... 
    //~ height -= this.getView().scrollOffset;
    var ps = Math.floor(height / rowHeight);
    //~ console.log('20120203 calculatePageSize():',height,'/',rowHeight,'->',ps);
    ps -= 1; // leave room for a possible phantom row
    //~ return (ps > 1 ? ps : false);
    if (ps > 1) return ps;
    //~ console.log('calculatePageSize() found less than 1 row:',height,'/',rowHeight,'->',ps);
    //~ foo.bar = baz; // 20120213
    return 5; // preview_limit
    //~ if (second_attempt) {
        //~ console.log('calculatePageSize() abandons after second attempt:',
          //~ height,'/',rowHeight,'->',ps);
      //~ return 5;
    //~ }
    //~ return this.calculatePageSize.defer(500,this,[true]);
  },
  
  onCellDblClick : function(grid, row, col){
      //~ console.log("20120307 onCellDblClick",this,grid, row, col);
      if (this.ls_detail_handler) {
          //~ Lino.notify('show detail');
          Lino.show_detail(this);
          return false;
      }else{
        //~ console.log('startEditing');
        this.startEditing(row,col);
      }
  },
  
  get_base_params : function() {
    //~ return this.containing_window.config.base_params;
    //~ console.log(20120717,this.store.baseParams);
    var p = Ext.apply({},this.store.baseParams);
    Lino.insert_subst_user(p);
    //~ console.log("20120717 GRidPanel.get_base_params() returns",p);
    return p;
    //~ return this.store.baseParams;
  },
  set_base_params : function(p) {
    //~ console.log('GridPanel.set_base_params',p)
    for (k in p) this.store.setBaseParam(k,p[k]);
    //~ this.store.baseParams = p;
    if (p.query) 
        this.quick_search_field.setValue(p.query);
    //~ if (p.param_values) 
        //~ this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.store.baseParams = {};
      Lino.insert_subst_user(this.store.baseParams);
  },
  set_base_param : function(k,v) {
    this.store.setBaseParam(k,v);
  },
  
  //~ get_permalink_params : function() {
    //~ var p = {};
    //~ return p;
  //~ },
  
  before_row_edit : function(record) {},
    
  //~ search_keypress : function(){
    //~ console.log("2012124 search_keypress",arguments);
  //~ },
  search_validate : function(value) {
    if (value == this.quick_search_text) return true;
    this.is_searching = true;
    //~ console.log('search_validate',value)
    this.quick_search_text = value;
    this.set_base_param('query',value); 
    //~ this.getTopToolbar().changePage(1);
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
    return true;
  },
  
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
  },
  
  apply_grid_config : function(index,grid_configs,rpt_columns) {
    //~ var rpt_columns = this.ls_columns;
    var gc = grid_configs[index];    
    //~ console.log('apply_grid_config() 20100812',name,gc);
    this.gc_name = index;
    if (gc == undefined) {
      return rpt_columns;
      //~ config.columns = config.ls_columns;
      //~ return;
    } 
    //~ delete config.ls_filters
    
    //~ console.log(20100805,config.ls_columns);
    var columns = Array(gc.columns.length);
    for (var j = 0; j < rpt_columns.length;j++) {
      var col = rpt_columns[j];
      for (var i = 0; i < gc.columns.length; i++) {
        if (col.dataIndex == gc.ci[i]) {
          col.width = gc.cw[i];
          col.hidden = gc.ch[i];
          columns[i] = col;
          break;
        }
      }
    }
    
    //~ var columns = Array(rpt_columns.length);
    //~ for (var i = 0; i < rpt_columns.length; i++) {
      //~ columns[i] = rpt_columns[gc.columns[i]];
      //~ columns[i].width = gc.widths[i];
    //~ }
    
    //~ if (gc.hidden_cols) {
      //~ for (var i = 0; i < gc.hidden_cols.length; i++) {
        //~ var hc = gc.hidden_cols[i];
        //~ for (var j = 0; j < columns.length;j++) {
          //~ var col = columns[j];
          //~ if (col.dataIndex == hc) {
            //~ col.hidden = true;
            //~ break
          //~ }
        //~ }
      //~ }
    //~ }
    if (gc.filters) {
      //~ console.log(20100811,'config.ls_filters',config.ls_filters);
      //~ console.log(20100811,'config.ls_grid_config.filters',config.ls_grid_config.filters);
      for (var i = 0; i < gc.filters.length; i++) {
        var fv = gc.filters[i];
        for (var j = 0; j < columns.length;j++) {
          var col = columns[j];
          if (col.dataIndex == fv.field) {
            //~ console.log(20100811, f,' == ',fv);
            if (fv.type == 'string') {
              col.filter.value = fv.value;
              //~ if (fv.comparison !== undefined) f.comparison = fv.comparison;
            } else {
              //~ console.log(20100811, fv);
              col.filter.value = {};
              col.filter.value[fv.comparison] = fv.value;
            }
            break;
          }
        };
      }
    }
    
    return columns;
    //~ config.columns = cols;
    //~ delete config.ls_columns
  },
  
  get_current_grid_config : function () {
    var cm = this.getColumnModel();
    var widths = Array(cm.config.length);
    var hiddens = Array(cm.config.length);
    //~ var hiddens = Array(cm.config.length);
    var columns = Array(cm.config.length);
    //~ var columns = Array(cm.config.length);
    //~ var hidden_cols = [];
    //~ var filters = this.filters.getFilterValues();
    var p = this.filters.buildQuery(this.filters.getFilterData())
    for (var i = 0; i < cm.config.length; i++) {
      var col = cm.config[i];
      columns[i] = col.dataIndex;
      //~ hiddens[i] = col.hidden;
      widths[i] = col.width;
      hiddens[i] = col.hidden;
      //~ if (col.hidden) hidden_cols.push(col.dataIndex);
    }
    //~ p['hidden_cols'] = hidden_cols;
    p.cw = widths;
    p.ch = hiddens;
    p.ci = columns;
    //~ p['widths'] = widths;
    //~ p['hiddens'] = hiddens;
    //~ p['columns'] = columns;
    p['name'] = this.gc_name;
    //~ var gc = this.ls_grid_configs[this.gc_name];
    //~ if (gc !== undefined) 
        //~ p['label'] = gc.label
    //~ console.log('20100810 save_grid_config',p);
    return p;
  },
  
  unused_manage_grid_configs : function() {
    var data = [];
    for (k in this.ls_grid_configs) {
      var v = this.ls_grid_configs[k];
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i)
    }
    if (this.ls_grid_configs[this.gc_name] == undefined) {
      var v = this.get_current_grid_config();
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i);
    }
    //~ console.log(20100811, data);
    var main = new Ext.grid.GridPanel({
      store: new Ext.data.ArrayStore({
        idIndex:0,
        fields:['name','columns','hidden_cols','filters'],
        autoDestroy:true,
        data: data}),
      //~ autoHeight:true,
      selModel: new Ext.grid.RowSelectionModel(),
      listeners: { 
        rowdblclick: function(grid,rowIndex,e) {
          console.log('row doubleclicked',grid, rowIndex,e);
        },
        rowclick: function(grid,rowIndex,e) {
          console.log('row clicked',grid, rowIndex,e);
        }
      },
      columns: [ 
        {dataIndex:'name',header:'Name'}, 
        {dataIndex:'columns',header:'columns'}, 
        {dataIndex:'hidden_cols',header:'hidden columns'}, 
        {dataIndex:'filters',header:'filters'} 
      ]
    });
    var win = new Ext.Window({title:'GridConfigs Manager',layout:'fit',items:main,height:200});
    win.show();
  },
  
  unused_edit_grid_config : function(name) {
    gc = this.ls_grid_configs[name];
    var win = new Ext.Window({
      title:'Edit Grid Config',layout:'vbox', 
      //~ layoutConfig:'stretch'
      items:[
        {xtype:'text', value: gc.name},
        {xtype:'text', value: gc.columns},
        {xtype:'text', value: gc.hidden_cols},
        {xtype:'text', value: gc.filters}
      ]
    });
    win.show();
  },
  
  save_grid_config : function () {
    //~ console.log('TODO: save_grid_config',this);
    //~ p.column_widths = Ext.pluck(this.colModel.columns,'width');
    var a = { 
      params:this.get_current_grid_config(), 
      method:'PUT',
      url:'/grid_config' + this.ls_url,
      success: Lino.action_handler(this),
      scope: this,
      failure: Lino.ajax_error_handler(this)
    };
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(a);
    //~ Lino.do_action(this,a);
  },
  
  on_beforeedit : function(e) {
    //~ console.log('20130128 GridPanel.on_beforeedit()',e,e.record.data.disable_editing);
    if(this.disable_editing | e.record.data.disable_editing) {
      e.cancel = true;
      Lino.notify("This record is disabled");
      return;
    }
    if(e.record.data.disabled_fields && e.record.data.disabled_fields[e.field]) {
      e.cancel = true;
      Lino.notify("This field is disabled");
      return;
    }
    //~ if (e.record.data.disabled_fields) {
      //~ for (i in e.record.data.disabled_fields) {
        //~ if(e.record.data.disabled_fields[i] == e.field) {
          //~ e.cancel = true;
          //~ Lino.notify(String.format('Field "{0}" is disabled for this record',e.field));
          //~ return
        //~ }
      //~ }
    //~ }
  },
  save_grid_data : function() {
      //~ console.log("20120814 save_grid_data");
      this.getStore().commitChanges();
  },
  new_on_afteredit : function(e) {
      //~ this.getStore().commitChanges();
      //~ this.getStore().doUpdate();
      //~ this.getStore().loadData(data);
      console.log("20120814 new_on_afteredit",e);
  },
  on_afteredit : function(e) {
    /*
    e.grid - The grid that fired the event
    e.record - The record being edited
    e.field - The field name being edited
    e.value - The value being set
    e.originalValue - The original value for the field, before the edit.
    e.row - The grid row index
    e.column - The grid column index
    */
    var p = {};
    //~ console.log('20101130 modified: ',e.record.modified);
    //~ console.log('20101130 value: ',e.value);
    //~ var p = e.record.getChanges();
    //~ console.log('20101130 getChanges: ',e.record.getChanges());
    //~ this.before_row_edit(e.record);
    for(k in e.record.getChanges()) {
        var v = e.record.get(k);
    //~ for(k in e.record.modified) {
        //~ console.log('20101130',k,'=',v);
        //~ var cm = e.grid.getColumnModel();
        //~ var di = cm.getDataIndex(k);
        var f = e.record.fields.get(k);
        //~ console.log('20101130 f = ',f);
        //~ var v = e.record.get(di);
        if (f.type.type == 'date') {
            p[k] = Ext.util.Format.date(v, f.dateFormat);
        }else{
            p[k] = v;
            var v = e.record.get(k+'Hidden');
            if (v !== undefined) {
              p[k+'Hidden'] = v;
            }
        }
        //~ var i = cm.findColumnIndex(k);
        //~ var r = cm.getRenderer(i);
        //~ var editor = cm.getCellEditor(i,e.row);
        //~ var col = e.grid.getColumnModel().getColumnById(k);
        //~ console.log('20101130 r = ',r(v));
        //~ var f = e.record.fields[k];
        //~ console.log('20101130 f = ',f);
        //~ console.log('20101130 editor = ',editor);
        //~ p[k] = f.getValue();
        //~ p[k] = r(v);
    }
    //~ console.log('20101130 p:',p);
    //~ var cm = e.grid.getColumnModel();
    //~ var di = cm.getDataIndex(e.column);
    //~ var f = e.record.fields.get(di);
    //~ console.log('20101130 f = ',f);
    //~ if (f.type.type == 'date') e.record.set(di,Ext.util.Format.date(e.value, f.dateFormat));
    
    
    //~ var p = e.record.data;
    
    // var p = {};
    //~ p['grid_afteredit_colname'] = e.field;
    //~ p[e.field] = e.value;
    //~ console.log('20100723 GridPanel.on_afteredit()',e);
    // add value used by ForeignKeyStoreField CHOICES_HIDDEN_SUFFIX
    // not sure whether this is still needed:
    p[e.field+'Hidden'] = e.value;
    //~ p.su = Lino.subst_user;
    Lino.insert_subst_user(p);
    // this one is needed so that this field can serve as choice context:
    e.record.data[e.field+'Hidden'] = e.value;
    // p[pk] = e.record.data[pk];
    // console.log("grid_afteredit:",e.field,'=',e.value);
    Ext.apply(p,this.get_base_params()); // needed for POST, ignored for PUT
    //~ Ext.apply(p,this.containing_window.config.base_params);
    //~ 20121109 p['$ext_requests.URL_PARAM_ACTION_NAME'] = 'grid';
    var self = this;
    var req = {
        params:p,
        waitMsg: 'Saving your data...',
        success: Lino.action_handler( this, function(result) {
          //~ if (result.data_record) {
          if (result.refresh_all) {
              var cw = self.get_containing_window();
              if (cw) {
                  cw.main_item.refresh();
              }
              else console.log("20120123 cannot refresh_all",self);
          } else if (result.rows) {
              //~ self.getStore().loadData(result,true);
              var r = self.getStore().reader.readRecords(result);
              if (e.record.phantom) {
                  //~ console.log("20120816 afteredit.success POST",r);
                  self.getStore().insert(e.row,r.records);
              }else{
                  //~ console.log("20120816 afteredit.success PUT",r);
                  self.getStore().doUpdate(r.records[0]);
              }
              self.getStore().rejectChanges(); /* 
              get rid of the red triangles without saving the record again
              */
              //~ self.getStore().commitChanges(); // get rid of the red triangles
          } else {
              self.getStore().commitChanges(); // get rid of the red triangles
              self.getStore().reload();        // reload our datastore.
          }
          }),
        scope: this,
        failure: Lino.ajax_error_handler(this)
    };
    if (e.record.phantom) {
      req.params.an = 'post'; // SubmitInsert.action_name
      Ext.apply(req,{
        method: 'POST',
        url: '/api' + this.ls_url
      });
    } else {
      req.params.an = 'put'; // SubmitDetail.action_name
      Ext.apply(req,{
        method: 'PUT',
        url: '/api' + this.ls_url + '/' + e.record.id
      });
    }
    //~ console.log('20110406 on_afteredit',req);
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(req);
  },

  afterRender : function() {
    Lino.GridPanel.superclass.afterRender.call(this);
    // this.getView().mainBody.focus();
    // console.log(20100114,this.getView().getRows());
    // if (this.getView().getRows().length > 0) {
    //  this.getView().focusRow(1);
    // }
    //~ this.my_load_mask = new Ext.LoadMask(this.getEl(), {
        //~ msg:'$_("Please wait...")',
        //~ store:this.store});
      
    var tbar = this.getTopToolbar();
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    // tbar.on('change',function() {this.getSelectionModel().selectFirstRow();this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    this.nav = new Ext.KeyNav(this.getEl(),{
      pageUp: function() {tbar.movePrevious(); },
      pageDown: function() {tbar.moveNext(); },
      home: function() {tbar.moveFirst(); },
      end: function() {tbar.moveLast(); },
      scope: this
    });
  },
  after_delete : function() {
    //~ console.log('Lino.GridPanel.after_delete');
    this.refresh();
  },
  add_row_listener : function(fn,scope) {
    this.getSelectionModel().addListener('rowselect',fn,scope);
  },
  postEditValue : function(value, originalValue, r, field){
    value = Lino.GridPanel.superclass.postEditValue.call(this,value,originalValue,r,field);
    //~ console.log('GridPanel.postEdit()',value, originalValue, r, field);
    return value;
  },
  
  set_start_value : function(v) {
      this.start_value = v;
  },
  preEditValue : function(r, field){
      if (this.start_value) {
        var v = this.start_value;
        delete this.start_value;
        this.activeEditor.selectOnFocus = false;
        return v;
      }
      var value = r.data[field];
      return this.autoEncode && Ext.isString(value) ? Ext.util.Format.htmlDecode(value) : value;
  },
  
  on_master_changed : function() {
    //~ if (! this.enabled) return;
    //~ cmp = this;
    //~ console.log('Lino.GridPanel.on_master_changed()',this.title);
    if (! this.rendered) return; // 20120213
    var todo = function() {
      if (this.disabled) return;
      //~ if (this.disabled) return;
      //~ if (this.enabled) {
          //~ var src = caller.config.url_data + "/" + record.id + ".jpg"
          //~ console.log(20111125, this.containing_window);
          //~ for (k in p) this.getStore().setBaseParam(k,p[k]);
          //~ console.log('Lino.GridPanel.on_master_changed()',this.title,p);
          this.refresh();
          //~ this.set_base_params(this.master_panel.get_master_params());
          //~ this.getStore().load(); 
      //~ }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
  

//~ Lino.MainPanelMixin = {
  //~ tbar_items : function() {
      //~ return ;
  //~ }
//~ };

//~ Ext.override(Lino.GridPanel,Lino.MainPanelMixin);
//~ Ext.override(Lino.FormPanel,Lino.MainPanelMixin);

//~ Lino.grid_context_menu = function(e) {
  //~ console.log('contextmenu',arguments);
//~ }

Lino.cell_context_menu = function(grid,row,col,e) {
  //~ console.log('20120531 cellcontextmenu',grid,row,col,e,grid.store.reader.arrayData.rows[row]);
  e.stopEvent();
  //~ grid.getView().focusCell(row,col);
  grid.getSelectionModel().select(row,col);
  //~ console.log(grid.store.getAt(row));
  //~ grid.getView().focusRow(row);
  //~ return;
  if(!grid.cmenu.el){grid.cmenu.render(); }
  //~ if(e.record.data.disabled_fields) {
  
  var da = grid.store.reader.arrayData.rows[row][grid.disabled_actions_index];
  if (da) {
      this.cmenu.cascade(function(item){ 
        //~ console.log(20120531, item.itemId, da[item.itemId]);
        if (da[item.itemId]) item.disable(); else item.enable();
      });
  };
  
  var xy = e.getXY();
  xy[1] -= grid.cmenu.el.getHeight();
  grid.cmenu.showAt(xy);
}


//~ Lino.load_main_menu = function() {
  //~ Ext.Ajax.request({
    //~ waitMsg: 'Loading main menu...',
    //~ method: 'GET',
    //~ url: '/menu',
    //~ success: Lino.on_load_menu,
    //~ failure: Lino.ajax_error_handler
  //~ });
//~ };



//~ Lino.SlavePlugin = function(caller) {
  //~ this.caller = caller;
//~ };

Lino.chooser_handler = function(combo,name) {
  return function(cmp,newValue,oldValue) {
    //~ console.log('Lino.chooser_handler()',cmp,oldValue,newValue);
    combo.setContextValue(name,newValue);
  }
};



Lino.ComboBox = Ext.extend(Ext.form.ComboBox,{
  forceSelection: true,
  triggerAction: 'all',
  minListWidth:230,
  autoSelect: false,
  selectOnFocus: true, // select any existing text in the field immediately on focus.
  submitValue: true,
  displayField: 'text', // 'text', 
  valueField: 'value', // 'value',
  
  //~ initComponent : Ext.form.ComboBox.prototype.initComponent.createSequence(function() {
  initComponent : function(){
      this.contextParams = {};
      //~ Ext.form.ComboBox.initComponent(this);
      Lino.ComboBox.superclass.initComponent.call(this);
  },
  setValue : function(v,record_data){
      /*
      Based on feature request developed in http://extjs.net/forum/showthread.php?t=75751
      */
      /* `record_data` is used to get the text corresponding to this value */
      //~ if(this.name == 'city') 
      //~ console.log('20120203', this.name,'.setValue(', v ,') this=', this,'record_data=',record_data);
      var text = v;
      if(this.valueField){
        if(v == null || v == '') { 
            //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,'no lookup needed, value is empty');
            //~ v = undefined;
            v = '';
            //~ text = '';
        } else if (Ext.isDefined(record_data)) {
          text = record_data[this.name];
          //~ if (this.name == 'birth_country') 
            //~ console.log(this.name,'.setValue',v,'got text ',text,' from record ',record);
        } else {
          // if(this.mode == 'remote' && !Ext.isDefined(this.store.totalLength)){
          if(this.mode == 'remote' && ( this.lastQuery === null || (!Ext.isDefined(this.store.totalLength)))){
              //~ if (this.name == 'birth_country') console.log(this.name,'.setValue',v,'store not yet loaded');
              this.store.on('load', this.setValue.createDelegate(this, arguments), null, {single: true});
              if(this.store.lastOptions === null || this.lastQuery === null){
                  var params;
                  if(this.valueParam){
                      params = {};
                      params[this.valueParam] = v;
                  }else{
                      var q = this.allQuery;
                      this.lastQuery = q;
                      this.store.setBaseParam(this.queryParam, q);
                      params = this.getParams(q);
                  }
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : call load() with params ',params);
                  this.store.load({params: params});
              //~ }else{
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : but store is loading',this.store.lastOptions);
              }
              return;
          //~ }else{
              //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,' : store is loaded, lastQuery is "',this.lastQuery,'"');
          }
          var r = this.findRecord(this.valueField, v);
          if(r){
              text = r.data[this.displayField];
          }else if(this.valueNotFoundText !== undefined){
              text = this.valueNotFoundText;
          }
        }
      }
      this.lastSelectionText = text;
      //~ this.lastSelectionText = v;
      if(this.hiddenField){
          //~ this.hiddenField.originalValue = v;
          this.hiddenField.value = v;
      }
      Ext.form.ComboBox.superclass.setValue.call(this, text);
      this.value = v; // needed for grid.afteredit
  },
  
  getParams : function(q){
    // p = Ext.form.ComboBox.superclass.getParams.call(this, q);
    // causes "Ext.form.ComboBox.superclass.getParams is undefined"
    var p = {};
    //p[this.queryParam] = q;
    if(this.pageSize){
        //~ p.start = 0;
        //~ p.limit = this.pageSize;
        p['start'] = 0;
        p['limit'] = this.pageSize;
    }
    // now my code:
    if(this.contextParams) Ext.apply(p,this.contextParams);
    //~ if(this.contextParams && this.contextValues) {
      //~ for(i = 0; i <= this.contextParams.length; i++)
        //~ p[this.contextParams[i]] = this.contextValues[i];
    //~ }
    return p;
  },
  setContextValue : function(name,value) {
    //~ console.log('setContextValue',this,this.name,':',name,'=',value);
    //~ if (this.contextValues === undefined) {
        //~ this.contextValues = Array(); // this.contextParams.length);
    //~ }
    if (this.contextParams[name] != value) {
      //~ console.log('setContextValue 1',this.contextParams);
      this.contextParams[name] = value;
      this.lastQuery = null;
      //~ console.log('setContextValue 2',this.contextParams);
    }
  }
});

Lino.ChoicesFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'local'
});


Lino.SimpleRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  forceSelection: true,
  constructor: function(config){
      Lino.SimpleRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value' ], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.ComplexRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  constructor: function(config){
      Lino.ComplexRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value','text'], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.RemoteComboFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'remote',
  //~ forceSelection:false,
  minChars: 2, // default 4 is too much
  queryDelay: 300, // default 500 is maybe slow
  queryParam: 'query', 
  //~ typeAhead: true,
  //~ selectOnFocus: true, // select any existing text in the field immediately on focus.
  resizable: true
});

/*
Thanks to Animal for posting the basic idea:
http://www.sencha.com/forum/showthread.php?15842-2.0-SOLVED-Combobox-twintrigger-clear&p=76130&viewfull=1#post76130

*/
Lino.TwinCombo = Ext.extend(Lino.RemoteComboFieldElement,{
    trigger2Class : 'x-form-search-trigger',
    //~ trigger2Class : 'x-tbar-detail',
    initComponent : function() {
        //~ Lino.TwinCombo.superclass.initComponent.call(this);
        Lino.ComboBox.prototype.initComponent.call(this);
        Ext.form.TwinTriggerField.prototype.initComponent.call(this);
    },
    onTrigger2Click : function() {
        //~ console.log('onTrigger2Click',this,arguments);
    }
  });
//~ Lino.TwinCombo.prototype.initComponent = Ext.form.TwinTriggerField.prototype.initComponent;
Lino.TwinCombo.prototype.getTrigger = Ext.form.TwinTriggerField.prototype.getTrigger;
Lino.TwinCombo.prototype.getOuterSize = Ext.form.TwinTriggerField.prototype.getOuterSize;
Lino.TwinCombo.prototype.initTrigger = Ext.form.TwinTriggerField.prototype.initTrigger;
Lino.TwinCombo.prototype.onTrigger1Click = Ext.form.ComboBox.prototype.onTriggerClick;
//~ Lino.TwinCombo.prototype.onTrigger2Click = function() {
    //~ console.log('onTrigger2Click',arguments);
//~ };



Lino.SimpleRemoteComboFieldElement = Ext.extend(Lino.RemoteComboFieldElement,{
  displayField: 'value', 
  valueField: null,
  forceSelection: false
});




Lino.Window = Ext.extend(Ext.Window,{
  //~ layout: "fit", 
  closeAction : 'hide',
  renderTo: 'main_area', 
  constrain: true,
  maximized: true,
  draggable: false,
  width: 700,
  height: 500,
  maximizable: false,
  constructor : function (config) {
    if (config.main_item.params_panel) {
        config.layout = 'border';
        config.main_item.region = 'center';
        config.main_item.params_panel.region = 'north';
        config.main_item.params_panel.hidden = config.main_item.params_panel_hidden;
        config.items = [config.main_item.params_panel, config.main_item];
    } else {
        config.layout = 'fit';
        config.items = config.main_item;
    }
    this.main_item = config.main_item; 
    
    delete config.main_item;
    //~ delete config.params_item;
    
    //~ this.main_item = config.items.get(0);
    this.main_item.containing_window = this;
    
    //~ console.log('20120110 Lino.Window.constructor() 1');
    //~ if (Lino.current_window) { // all windows except the top are closable
    if (this.main_item.hide_window_title) { 
      config.closable = false;
      config.frame = false;
      config.shadow = false;
      //~ config.border = true;
      //~ config.title = undefined;
      //~ config.tools = null;
      delete config.title;
      delete config.tools;
    } else {
      config.title = this.main_item.empty_title;
      config.closable = true;
      config.tools = [ 
        { qtip: 'permalink', handler: Lino.permalink_handler(this), id: "pin" }
      ];
      if (this.main_item.content_type && this.main_item.action_name != 'insert') {
        config.tools = [ {
          handler: Lino.help_text_editor,
          qtip: "Edit help texts for fields on this model.",
          scope: this.main_item,
          id: "gear"
        }].concat(config.tools);
      }
        
    //~ { qtip: '', handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: this.config.qtip, handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: 'Call doLayout() on main Container.', handler: Lino.refresh_handler(this), id: "refresh" },
    //~ if (this.main_item.params_panel) {
        //~ config.tools = config.tools.concat([ 
          //~ { qtip: 'Show/hide parameter panel', handler: this.toggle_params_panel, id: "gear", scope:this } 
        //~ ]);
    //~ }
    //~ if (config.closable !== false) {
      // if undefined, will take default behaviour
      //~ config.tools = config.tools.concat([ 
        //~ { qtip: 'close', handler: this.hide, id: "close", scope:this } 
      //~ ]);
    }
    
    this.main_item.config_containing_window(config);
    
    //~ console.log('20120110 Lino.Window.constructor() 2');
    Lino.Window.superclass.constructor.call(this,config);
    
    //~ console.log('20120110 Lino.Window.constructor() 3');
    
  },
  initComponent : function() {
    this.main_item.init_containing_window(this);
    Lino.Window.superclass.initComponent.call(this);
  
  },
  hide : function() { 
      this.main_item.do_when_clean(false,function() { 
        Lino.close_window(); });
  },
  hide_really : function() { 
    Lino.Window.superclass.hide.call(this);
  },
  onRender : function(ct, position){
    //~ console.log('20120110 Lino.Window.onRender() 1');
    Lino.Window.superclass.onRender.call(this, ct, position);
    var main_area = Ext.getCmp('main_area')
    //~ console.log('20120110 Lino.Window.onRender() 2');
  
    this.on('show', function(win) {
        //~ console.log('20120110 Lino.Window.on show 1');
        main_area.on('resize', win.onWindowResize, win);
    });
    this.on('hide', function(win) {
        main_area.un('resize', win.onWindowResize, win);
    });
    //~ console.log('20120110 Lino.Window.onRender() 3');
  }
});


Lino.unused_ParamWindow = Ext.extend(Lino.Window,{
  //~ layout: "border", 
  constructor : function (config) {
    Lino.ParamWindow.superclass.constructor.call(this,config);
    this.main_item = config.items; // `items` must be a single component
    config.layout = 'border';
    this.main_item.region = 'center';
    config.params.region = 'north';
    config.items = [config.params, config.items];
    //~ delete config.params;
  }
});




(function(){
    var ns = Ext.ns('Ext.ux.plugins');

    /**
     * @class Ext.ux.plugins.DefaultButton
     * @extends Object
     *
     * Plugin for Button that will click() the button if the user presses ENTER while
     * a component in the button's form has focus.
     *
     * @author Stephen Friedrich
     * @date 09-DEC-2009
     * @version 0.1
     *
     */
    ns.DefaultButton =  Ext.extend(Object, {
        init: function(button) {
            button.on('afterRender', setupKeyListener, button);
        }
    });

    function setupKeyListener() {
        var formPanel = this.findParentByType('form');
        new Ext.KeyMap(formPanel.el, {
            key: Ext.EventObject.ENTER,
            shift: false,
            alt: false,
            fn: function(keyCode, e){
                if(e.target.type === 'textarea' && !e.ctrlKey) {
                    return true;
                }

                this.el.select('button').item(0).dom.click();
                return false;
            },
            scope: this
        });
    }

    Ext.ComponentMgr.registerPlugin('defaultButton', ns.DefaultButton);

})(); 

Ext.override(Ext.form.BasicForm,{
    my_loadRecord : function(values){
    //~ loadRecord : function(record){
        /* Same as ExtJS's loadRecord() (setValues()), except that we 
        forward also the record to field.setValue() so that Lino.Combobox 
        can use it. 
        */
        //~ console.log('20120918 my_loadRecord',values)
        if(Ext.isArray(values)){ 
            for(var i = 0, len = values.length; i < len; i++){
                var v = values[i];
                var f = this.findField(v.id);
                if(f){
                    f.setValue(v.value,values);
                    if(this.trackResetOnLoad){
                        f.originalValue = f.getValue();
                    }
                }
            }
        }else{ 
            var field, id;
            for(id in values){
                if(!Ext.isFunction(values[id]) && (field = this.findField(id))){
                    field.setValue(values[id],values);
                    if(this.trackResetOnLoad){
                        field.originalValue = field.getValue();
                        //~ if (field.hiddenField) {
                          //~ field.hiddenField.originalValue = field.hiddenField.value;
                        //~ }
                    }
                }
            }
        }
        return this;
    }
});




function initializeFooBarDropZone(cmp) {
    //~ console.log('initializeFooBarDropZone',cmp);
    cmp.dropTarget = new Ext.dd.DropTarget(cmp.bwrap, {
      //~ ddGroup     : 'gridDDGroup',
      notifyEnter : function(ddSource, e, data) {
        console.log('notifyEnter',ddSource,e,data);
        //Add some flare to invite drop.
        cmp.body.stopFx();
        cmp.body.highlight();
      },
      notifyDrop  : function(ddSource, e, data){
        console.log('notifyDrop',ddSource,e,data);
        // Reference the record (single selection) for readability
        //~ var selectedRecord = ddSource.dragData.selections[0];


        // Load the record into the form
        //~ formPanel.getForm().my_loadRecord(selectedRecord);


        // Delete record from the grid.  not really required.
        //~ ddSource.grid.store.remove(selectedRecord);

        return(true);
      }
    })
}



Lino.show_mti_child = function(fieldname,detail_handler) {
  //~ console.log('show_mti_child',this);
  //~ console.log('show_mti_child',panel.find("main_area"));
  rec = Lino.current_window.main_item.get_current_record();
  //~ rec = panel.get_current_record();
  if (rec) {
    //~ console.log('show_mti_child',Lino.current_window,rec);
    if (rec.phantom) {
      Lino.notify('Not allowed on phantom record.');
    }else if (rec.data[fieldname]) {
      //~ console.log('show_mti_child',rec.id);
      //~ detail_handler(Lino.current_window.main_item,{},{record_id:rec.id});
      detail_handler.run(null,{record_id:rec.id});
      //~ window.open(urlroot + '/' + rec.id);
      //~ document.location = urlroot + '/' + rec.id;
      //~ window.open(urlroot + '/' + rec.id,'_blank');
    } else {
      Lino.alert("Cannot show MTI child if checkbox is off.");
    }
  } else {
    Lino.notify('No current record.');
  }
};





/*
captureEvents utility by Aaron Conran
<http://www.sencha.com/learn/grid-faq/>

Ext.onReady(function(){
    var grid = new Ext.grid.GridPanel({
        ... 
    });
    captureEvents(grid);
});
*/
function captureEvents(observable) {
    Ext.util.Observable.capture(
        observable,
        function(eventName) {
            console.info(eventName);
        },
        this
    );		
}
 






Lino.main_menu = [ { "menu": { "items": [ { "text": "Persons", "handler": function() {Lino.partners.Persons.grid.run(null)} }, { "text": "Organisations", "handler": function() {Lino.partners.Organisations.grid.run(null)} }, { "text": "Partners", "handler": function() {Lino.partners.Partners.grid.run(null)} } ] }, "text": "Partners" }, { "menu": { "items": [ { "text": "Products", "handler": function() {Lino.products.Products.grid.run(null)} }, { "text": "Product Categories", "handler": function() {Lino.products.ProductCats.grid.run(null)} } ] }, "text": "Products" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "My Text Field Templates", "handler": function() {Lino.ui.MyTextFieldTemplates.grid.run(null)} }, { "text": "Nodes", "handler": function() {Lino.pages.Pages.grid.run(null)} } ] }, "text": "Office" }, { "menu": { "items": [ { "text": "Site Parameters", "handler": function() {Lino.ui.SiteConfigs.detail.run(null,{ "record_id": 1 })} }, { "text": "Users", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    Shows the list of all users on this site.\n    \n    A User is somebody who can log into the application.\n    \n    ") }, "handler": function() {Lino.users.Users.grid.run(null)} }, { "text": "Teams", "handler": function() {Lino.users.Teams.grid.run(null)} }, { "text": "content types", "handler": function() {Lino.ui.ContentTypes.grid.run(null)} }, { "text": "Help Texts", "handler": function() {Lino.ui.HelpTexts.grid.run(null)} } ] }, "text": "System" }, { "menu": { "items": [ { "text": "Countries", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    A country is a geographic entity considered a \"nation\".\n    ") }, "handler": function() {Lino.countries.Countries.grid.run(null)} }, { "text": "Places", "listeners": { "render": Lino.quicktip_renderer("Foo","\n    The table of known geographical places.\n    A geographical place can be a city, a town, a suburb, \n    a province, a lake... any named geographic entity,\n    except for countries because these have their own table.\n    ") }, "handler": function() {Lino.countries.Cities.grid.run(null)} }, { "text": "Languages", "handler": function() {Lino.countries.Languages.grid.run(null)} } ] }, "text": "Contacts" }, { "menu": { "items": [ { "text": "Organisation types", "handler": function() {Lino.partners.OrganisationTypes.grid.run(null)} }, { "text": "Roles", "handler": function() {Lino.partners.Roles.grid.run(null)} } ] }, "text": "Partners" }, { "menu": { "items": [ { "text": "Account Charts", "handler": function() {Lino.accounts.Charts.grid.run(null)} }, { "text": "Account Groups", "handler": function() {Lino.accounts.Groups.grid.run(null)} }, { "text": "Accounts", "handler": function() {Lino.accounts.Accounts.grid.run(null)} }, { "text": "Journals", "handler": function() {Lino.ledger.Journals.grid.run(null)} } ] }, "text": "Accounting" }, { "menu": { "items": [ { "text": "Invoicing Modes", "handler": function() {Lino.sales.InvoicingModes.grid.run(null)} }, { "text": "Shipping Modes", "handler": function() {Lino.sales.ShippingModes.grid.run(null)} }, { "text": "Payment Terms", "handler": function() {Lino.sales.PaymentTerms.grid.run(null)} } ] }, "text": "Sales" } ] }, "text": "Configure" }, { "menu": { "items": [ { "text": "Text Field Templates", "handler": function() {Lino.ui.TextFieldTemplates.grid.run(null)} }, { "menu": { "items": [ { "text": "Authorities", "handler": function() {Lino.users.Authorities.grid.run(null)} }, { "text": "User Groups", "handler": function() {Lino.lino.UserGroups.grid.run(null)} }, { "text": "User Levels", "handler": function() {Lino.lino.UserLevels.grid.run(null)} }, { "text": "User Profiles", "handler": function() {Lino.lino.UserProfiles.grid.run(null)} } ] }, "text": "System" }, { "text": "Contact Persons", "handler": function() {Lino.partners.Contacts.grid.run(null)} }, { "menu": { "items": [ { "text": "AccountTypes", "handler": function() {Lino.accounts.AccountTypes.grid.run(null)} }, { "text": "Invoices", "handler": function() {Lino.ledger.Invoices.grid.run(null)} }, { "text": "Vouchers", "handler": function() {Lino.ledger.Vouchers.grid.run(null)} }, { "text": "VoucherTypes", "handler": function() {Lino.ledger.VoucherTypes.grid.run(null)} }, { "text": "Movements", "handler": function() {Lino.ledger.Movements.grid.run(null)} }, { "text": "Fiscal Years", "handler": function() {Lino.ledger.FiscalYears.grid.run(null)} } ] }, "text": "Accounting" }, { "menu": { "items": [ { "text": "VatRegimes", "handler": function() {Lino.vat.VatRegimes.grid.run(null)} }, { "text": "TradeTypes", "handler": function() {Lino.vat.TradeTypes.grid.run(null)} }, { "text": "VatClasses", "handler": function() {Lino.vat.VatClasses.grid.run(null)} }, { "text": "VAT declarations", "handler": function() {Lino.declarations.Declarations.grid.run(null)} } ] }, "text": "VAT" } ] }, "text": "Explorer" }, { "menu": { "items": [ { "text": "About", "listeners": { "render": Lino.quicktip_renderer("Foo","Show information about this site.") }, "handler": function() {Lino.about.About.show.run(null,{ "record_id": -99998 })} } ] }, "text": "Site" }, { "text": "Home", "handler": function() {Lino.close_all_windows()} } ];
Ext.namespace('Lino.ui.SiteConfigs')
Ext.namespace('Lino.ui.ContentTypes')
Ext.namespace('Lino.ui.HelpTexts')
Ext.namespace('Lino.ui.TextFieldTemplates')
Ext.namespace('Lino.users.Users')
Ext.namespace('Lino.users.MySettings')
Ext.namespace('Lino.users.UsersOverview')
Ext.namespace('Lino.users.Teams')
Ext.namespace('Lino.users.Memberships')
Ext.namespace('Lino.users.Authorities')
Ext.namespace('Lino.countries.Languages')
Ext.namespace('Lino.countries.Countries')
Ext.namespace('Lino.countries.Cities')
Ext.namespace('Lino.partners.OrganisationTypes')
Ext.namespace('Lino.partners.Partners')
Ext.namespace('Lino.partners.Persons')
Ext.namespace('Lino.partners.Organisations')
Ext.namespace('Lino.partners.Roles')
Ext.namespace('Lino.partners.Contacts')
Ext.namespace('Lino.products.ProductCats')
Ext.namespace('Lino.products.Products')
Ext.namespace('Lino.accounts.Charts')
Ext.namespace('Lino.accounts.Groups')
Ext.namespace('Lino.accounts.Accounts')
Ext.namespace('Lino.ledger.Journals')
Ext.namespace('Lino.ledger.Vouchers')
Ext.namespace('Lino.ledger.Movements')
Ext.namespace('Lino.ledger.Invoices')
Ext.namespace('Lino.declarations.Declarations')
Ext.namespace('Lino.sales.PaymentTerms')
Ext.namespace('Lino.sales.InvoicingModes')
Ext.namespace('Lino.sales.ShippingModes')
Ext.namespace('Lino.sales.Invoices')
Ext.namespace('Lino.sales.DocumentsToSign')
Ext.namespace('Lino.finan.BankStatements')
Ext.namespace('Lino.finan.DocItems')
Ext.namespace('Lino.pages.Pages')
Ext.namespace('Lino.ledger.InvoiceItemTable')
Ext.namespace('Lino.sales.SalesRuleTable')
Ext.namespace('Lino.sales.ProductDocItemTable')
Ext.namespace('Lino.sales.InvoiceItemTable')
Ext.namespace('Lino.ui.MyTextFieldTemplates')
Ext.namespace('Lino.users.MembershipsByUser')
Ext.namespace('Lino.users.AuthoritiesGiven')
Ext.namespace('Lino.users.AuthoritiesTaken')
Ext.namespace('Lino.countries.CitiesByCity')
Ext.namespace('Lino.countries.CitiesByCountry')
Ext.namespace('Lino.partners.PersonsByCity')
Ext.namespace('Lino.partners.PersonsByCountry')
Ext.namespace('Lino.partners.OrganisationsByCity')
Ext.namespace('Lino.partners.OrganisationsByCountry')
Ext.namespace('Lino.partners.ContactsByOrganisation')
Ext.namespace('Lino.partners.ContactsByPerson')
Ext.namespace('Lino.products.ProductsByCategory')
Ext.namespace('Lino.accounts.GroupsByChart')
Ext.namespace('Lino.accounts.AccountsByGroup')
Ext.namespace('Lino.ledger.MovementsByVoucher')
Ext.namespace('Lino.ledger.MovementsByPartner')
Ext.namespace('Lino.ledger.InvoicesByJournal')
Ext.namespace('Lino.ledger.InvoicesByPartner')
Ext.namespace('Lino.ledger.ItemsByInvoice')
Ext.namespace('Lino.declarations.VouchersByDeclaration')
Ext.namespace('Lino.declarations.DeclarationsByJournal')
Ext.namespace('Lino.sales.InvoicesByJournal')
Ext.namespace('Lino.sales.ItemsByInvoice')
Ext.namespace('Lino.sales.InvoiceItemsByProduct')
Ext.namespace('Lino.sales.InvoicesByPartner')
Ext.namespace('Lino.finan.BankStatementsByJournal')
Ext.namespace('Lino.finan.ItemsByStatement')
Ext.namespace('Lino.ui.HelpTextsByModel')
Ext.namespace('Lino.about.Models')
Ext.namespace('Lino.about.FieldsByModel')
Ext.namespace('Lino.about.Inspector')
Ext.namespace('Lino.about.SourceFiles')
Ext.namespace('Lino.ui.Home')
Ext.namespace('Lino.about.About')
Ext.namespace('Lino.finan.VoucherStates')
Ext.namespace('Lino.declarations.DeclarationStates')
Ext.namespace('Lino.lino.Genders')
Ext.namespace('Lino.vat.TradeTypes')
Ext.namespace('Lino.countries.CityTypes')
Ext.namespace('Lino.sales.InvoiceStates')
Ext.namespace('Lino.accounts.AccountTypes')
Ext.namespace('Lino.vat.VatRegimes')
Ext.namespace('Lino.lino.UserProfiles')
Ext.namespace('Lino.vat.VatClasses')
Ext.namespace('Lino.declarations.DeclarationFields')
Ext.namespace('Lino.declarations.DeclarationPeriods')
Ext.namespace('Lino.ledger.VoucherTypes')
Ext.namespace('Lino.ledger.InvoiceStates')
Ext.namespace('Lino.ledger.FiscalYears')
Ext.namespace('Lino.lino.UserGroups')
Ext.namespace('Lino.lino.UserLevels')

// ChoiceLists: 
Lino.finan.VoucherStates = [ [ "10", "Draft" ], [ "20", "Registered" ] ];
Lino.declarations.DeclarationStates = [ [ "00", "Draft" ], [ "10", "Registered" ], [ "20", "Submitted" ] ];
Lino.lino.Genders = [ [ "M", "Male" ], [ "F", "Female" ] ];
Lino.vat.TradeTypes = [ [ "S", "Sales" ], [ "P", "Purchases" ] ];
Lino.countries.CityTypes = [ [ "10", "Member State" ], [ "11", "Division" ], [ "12", "Region" ], [ "13", "Community" ], [ "14", "Territory" ], [ "20", "County" ], [ "21", "Province" ], [ "22", "Shire" ], [ "23", "Subregion" ], [ "24", "Department" ], [ "25", "Arrondissement" ], [ "26", "Prefecture" ], [ "27", "District" ], [ "28", "Sector" ], [ "50", "City" ], [ "51", "Town" ], [ "52", "Municipality" ], [ "54", "Parish" ], [ "55", "Township" ], [ "56", "Quarter" ], [ "61", "Borough" ], [ "62", "Small borough" ], [ "70", "Village" ] ];
Lino.sales.InvoiceStates = [ [ "10", "Draft" ], [ "20", "Registered" ], [ "30", "Signed" ], [ "40", "Sent" ], [ "50", "Paid" ] ];
Lino.accounts.AccountTypes = [ [ "A", "Assets" ], [ "L", "Liabilities" ], [ "I", "Incomes" ], [ "E", "Expenses" ], [ "C", "Capital" ], [ "B", "Bank accounts" ] ];
Lino.vat.VatRegimes = [ [ "10", "Private person" ], [ "20", "Subject to VAT" ], [ "25", "Co-contractor" ], [ "30", "Intra-community" ], [ "40", "Outside EU" ], [ "50", "Exempt" ] ];
Lino.lino.UserProfiles = [ [ "000", "000 (Anonymous)" ], [ "100", "100 (User)" ], [ "900", "900 (Administrator)" ] ];
Lino.vat.VatClasses = [ [ "0", "Exempt" ], [ "1", "Reduced" ], [ "2", "Normal" ] ];
Lino.declarations.DeclarationFields = [ [ "00", "Sales base" ], [ "10", "Sales VAT" ], [ "20", "Purchases base" ], [ "30", "Purchases VAT" ], [ "80", "Investments" ], [ "81", "Ware" ], [ "82", "Services" ] ];
Lino.declarations.DeclarationPeriods = [ [ "01", "January" ], [ "02", "February" ], [ "03", "March" ], [ "04", "April" ], [ "05", "May" ], [ "06", "June" ], [ "07", "July" ], [ "08", "August" ], [ "09", "September" ], [ "10", "October" ], [ "11", "November" ], [ "12", "December" ] ];
Lino.ledger.VoucherTypes = [ [ "ledger.AccountInvoice", "Invoice (lino.modlib.ledger.models.AccountInvoice)" ], [ "declarations.Declaration", "VAT declaration (lino.modlib.declarations.models.Declaration)" ], [ "sales.Invoice", "Invoice (lino.modlib.sales.models.Invoice)" ], [ "finan.BankStatement", "bank statement (lino.modlib.finan.models.BankStatement)" ] ];
Lino.ledger.InvoiceStates = [ [ "10", "Draft" ], [ "20", "Registered" ], [ "40", "Paid" ] ];
Lino.ledger.FiscalYears = [ [ "13", "2013" ], [ "14", "2014" ], [ "15", "2015" ], [ "16", "2016" ], [ "17", "2017" ] ];
Lino.lino.UserGroups = [ [ "office", "office (Office)" ], [ "accounting", "accounting (Accounting)" ] ];
Lino.lino.UserLevels = [ [ "10", "Guest" ], [ "20", "Secretary" ], [ "30", "User" ], [ "40", "Manager" ], [ "50", "Administrator" ], [ "90", "Expert" ] ];

Lino.about.Inspector.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  layout: "hbox",
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 153,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var inspected906 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100, "fieldLabel": "Inspected object", "anchor": "-20", "name": "inspected" });
    var show_callables907 = new Ext.form.Checkbox({ "boxLabel": "show callables", "hideLabel": true, "checked": false, "name": "show_callables", "selectOnFocus": true, "anchor": "-20" });
    this.items = [ { "flex": 67, "autoHeight": true, "layout": "form", "xtype": "panel", "items": inspected906, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": show_callables907, "labelAlign": "top" } ];
    this.fields = [ inspected906, show_callables907 ];
    Lino.about.Inspector.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.sales.Invoices.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  layout: "hbox",
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 108,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var journal541 = new Lino.TwinCombo({ "fieldLabel": "Journal", "name": "journal", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail)}, "emptyText": "Select a Journal...", "selectOnFocus": true, "hiddenName": "journalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/journal", "method": "GET" }) }) });
    var year542 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "year", "selectOnFocus": true, "anchor": "-20", "store": Lino.ledger.FiscalYears, "hiddenName": "yearHidden" });
    this.items = [ { "flex": 74, "autoHeight": true, "layout": "form", "xtype": "panel", "items": journal541, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": year542, "labelAlign": "top" } ];
    this.fields = [ journal541, year542 ];
    Lino.sales.Invoices.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.finan.BankStatements.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  layout: "hbox",
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 108,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var pjournal869 = new Lino.TwinCombo({ "fieldLabel": "Journal", "name": "pjournal", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail)}, "emptyText": "Select a Journal...", "selectOnFocus": true, "hiddenName": "pjournalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/BankStatements/pjournal", "method": "GET" }) }) });
    var pyear870 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "pyear", "selectOnFocus": true, "anchor": "-20", "store": Lino.ledger.FiscalYears, "hiddenName": "pyearHidden" });
    this.items = [ { "flex": 74, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pjournal869, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pyear870, "labelAlign": "top" } ];
    this.fields = [ pjournal869, pyear870 ];
    Lino.finan.BankStatements.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Invoices.ParamsPanel = Ext.extend(Ext.form.FormPanel,{
  autoHeight: true,
  layout: "hbox",
  frame: true,
  layoutConfig: { "align": "stretchmax" },
  hideCheckBoxLabels: true,
  autoScroll: false,
  labelWidth: 108,
  border: false,
  bodyBorder: false,
  labelAlign: "top",
  initComponent : function() {
    var containing_panel = this;
    var pjournal116 = new Lino.TwinCombo({ "fieldLabel": "Journal", "name": "pjournal", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail)}, "emptyText": "Select a Journal...", "selectOnFocus": true, "hiddenName": "pjournalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/pjournal", "method": "GET" }) }) });
    var pyear117 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "pyear", "selectOnFocus": true, "anchor": "-20", "store": Lino.ledger.FiscalYears, "hiddenName": "pyearHidden" });
    var ppartner118 = new Lino.TwinCombo({ "fieldLabel": "Partner", "name": "ppartner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.partners.Partners.detail)}, "emptyText": "Select a Partner...", "selectOnFocus": true, "hiddenName": "ppartnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/ppartner", "method": "GET" }) }) });
    this.items = [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pjournal116, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": pyear117, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ppartner118, "labelAlign": "top" } ];
    this.fields = [ pjournal116, pyear117, ppartner118 ];
    Lino.ledger.Invoices.ParamsPanel.superclass.initComponent.call(this);
  }
});


Lino.partners.Organisations.merge_row_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 72,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'merge_row',
  window_title: "Merge",
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var merge_to6 = new Lino.TwinCombo({ "fieldLabel": "into...", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.partners.Organisations.detail)}, "emptyText": "Select a Organisation...", "selectOnFocus": true, "hiddenName": "merge_toHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/partners/Organisations/merge_row/merge_to", "method": "GET" }) }), "name": "merge_to" });
    var reason7 = new Ext.form.TextField({ "fieldLabel": "Reason", "name": "reason", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": merge_to6, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": reason7, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ merge_to6, reason7 ];
    Lino.partners.Organisations.merge_row_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.partners.Persons.merge_row_ActionFormPanel = Ext.extend(Lino.ActionFormPanel,{
  autoScroll: false,
  autoHeight: true,
  border: false,
  layout: "form",
  labelWidth: 72,
  hideCheckBoxLabels: true,
  frame: true,
  bodyBorder: false,
  labelAlign: "top",
  action_name: 'merge_row',
  window_title: "Merge",
  autoHeight: true,
  initComponent : function() {
    var containing_panel = this;
    var merge_to1 = new Lino.TwinCombo({ "fieldLabel": "into...", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.partners.Persons.detail)}, "emptyText": "Select a Person...", "selectOnFocus": true, "hiddenName": "merge_toHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/apchoices/partners/Persons/merge_row/merge_to", "method": "GET" }) }), "name": "merge_to" });
    var reason2 = new Ext.form.TextField({ "fieldLabel": "Reason", "name": "reason", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    this.items = [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": merge_to1, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": reason2, "anchor": "-20", "labelAlign": "top" } ];
    this.fields = [ merge_to1, reason2 ];
    Lino.partners.Persons.merge_row_ActionFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ui.Home.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var quick_links_htmlbox911 = new Lino.HtmlBoxPanel({ "flex": 1, "layout": "fit", "name": "quick_links", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "north", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden", "split": true });
    var welcome_htmlbox912 = new Lino.HtmlBoxPanel({ "flex": 5, "layout": "fit", "name": "welcome", "containing_panel": this, "items": new Ext.BoxComponent({autoScroll:true}), "region": "center", "title": "Welcome", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden", "split": true });
    var main_panel913 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ quick_links_htmlbox911, welcome_htmlbox912 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel913;
    this.before_row_edit = function(record) {
      quick_links_htmlbox911.refresh();
      welcome_htmlbox912.refresh();
    }
    Lino.ui.Home.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.products.Products.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 24,
  initComponent : function() {
    var containing_panel = this;
    var id656 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var cat657 = new Lino.TwinCombo({ "fieldLabel": "Category", "name": "cat", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.products.ProductCats.detail)}, "emptyText": "Select a Product Category...", "selectOnFocus": true, "hiddenName": "catHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/products/Products/cat", "method": "GET" }) }) });
    var price658 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Price", "name": "price", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var vatExempt659 = new Ext.form.Checkbox({ "boxLabel": "VAT exempt", "hideLabel": true, "checked": false, "name": "vatExempt", "selectOnFocus": true, "anchor": "-20" });
    var general_1_panel660 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id656, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": cat657, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": price658, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vatExempt659, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var name665 = new Ext.form.TextField({ "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de666 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Designation (de)", "anchor": "-20", "name": "name_de" });
    var name_fr667 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Designation (fr)", "anchor": "-20", "name": "name_fr" });
    var general_2_panel668 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name665, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de666, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr667, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var description672 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Long description", "anchor": "-20 -10", "growMax": 2000, "name": "description" });
    var general_panel673 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel660, general_2_panel668, { "items": description672, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "labelWidth": 153, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var sales_InvoiceItemsByProduct_grid686 = new Lino.sales.InvoiceItemsByProduct.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "viewConfig": { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "No data to display." }, "hide_top_toolbar": true, "containing_panel": this, "title": "Sales", "tools": [ Lino.show_in_own_window_button(Lino.sales.InvoiceItemsByProduct.grid) ], "master_panel": this });
    var main_panel687 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel673, sales_InvoiceItemsByProduct_grid686 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel687;
    this.before_row_edit = function(record) {
      sales_InvoiceItemsByProduct_grid686.on_master_changed();
    }
    Lino.products.Products.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Journals.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 28,
  initComponent : function() {
    var containing_panel = this;
    var seqno739 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "Seq.No.", "anchor": "-20", "name": "seqno" });
    var id740 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var trade_type741 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Trade Type", "name": "trade_type", "selectOnFocus": true, "anchor": "-20", "store": Lino.vat.TradeTypes, "hiddenName": "trade_typeHidden" });
    var voucher_type742 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "voucher type", "allowBlank": false, "hiddenName": "voucher_typeHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.ledger.VoucherTypes, "name": "voucher_type" });
    var main_1_panel743 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": seqno739, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id740, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": trade_type741, "labelAlign": "top" }, { "flex": 74, "autoHeight": true, "layout": "form", "xtype": "panel", "items": voucher_type742, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var force_sequence748 = new Ext.form.Checkbox({ "boxLabel": "force sequence", "hideLabel": true, "checked": false, "name": "force_sequence", "selectOnFocus": true, "anchor": "-20" });
    var account749 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Account", "name": "account", "pageSize": 20, "emptyText": "Select a Account...", "selectOnFocus": true, "hiddenName": "accountHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Journals/account", "method": "GET" }) }) });
    var main_2_panel750 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": force_sequence748, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": account749, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var name753 = new Ext.form.TextField({ "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de754 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Designation (de)", "anchor": "-20", "name": "name_de" });
    var name_fr755 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Designation (fr)", "anchor": "-20", "name": "name_fr" });
    var main_3_panel756 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name753, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de754, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr755, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var printed_name760 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100, "fieldLabel": "printed name", "anchor": "-20", "name": "printed_name" });
    var printed_name_de761 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100, "fieldLabel": "printed name (de)", "anchor": "-20", "name": "printed_name_de" });
    var printed_name_fr762 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100, "fieldLabel": "printed name (fr)", "anchor": "-20", "name": "printed_name_fr" });
    var main_4_panel763 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": printed_name760, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": printed_name_de761, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": printed_name_fr762, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel767 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel743, main_2_panel750, main_3_panel756, main_4_panel763 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel767;
    this.before_row_edit = function(record) {
      account749.setContextValue('chart',record ? record.data['chartHidden'] : undefined);
    }
    Lino.ledger.Journals.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.declarations.Declarations.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 33,
  initComponent : function() {
    var containing_panel = this;
    var date780 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "Date", "anchor": "-20", "name": "date" });
    var year781 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "year", "selectOnFocus": true, "anchor": "-20", "store": Lino.ledger.FiscalYears, "hiddenName": "yearHidden" });
    var period782 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "VAT Period", "allowBlank": false, "hiddenName": "periodHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.declarations.DeclarationPeriods, "name": "period" });
    var user783 = new Lino.TwinCombo({ "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Select a User...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/declarations/Declarations/user", "method": "GET" }) }) });
    var workflow_buttons_disp784 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Workflow", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel785 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date780, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": year781, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": period782, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user783, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp784, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var sales_base791 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Sales base", "name": "sales_base", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var sales_vat792 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Sales VAT", "name": "sales_vat", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var fields_1_panel793 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sales_base791, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sales_vat792, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var purchases_base796 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Purchases base", "name": "purchases_base", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var purchases_vat797 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Purchases VAT", "name": "purchases_vat", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var fields_2_panel798 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": purchases_base796, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": purchases_vat797, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var purchases_investments801 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Investments", "name": "purchases_investments", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var purchases_ware802 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Ware", "name": "purchases_ware", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var purchases_services803 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Services", "name": "purchases_services", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var fields_3_panel804 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": purchases_investments801, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": purchases_ware802, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": purchases_services803, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 108, "border": false, "anchor": "-20", "labelAlign": "top" });
    var fields_panel808 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ fields_1_panel793, fields_2_panel798, fields_3_panel804 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var VouchersByDeclaration_grid817 = new Lino.declarations.VouchersByDeclaration.GridPanel({ "flex": 45, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.declarations.VouchersByDeclaration.grid) ], "master_panel": this });
    var main_panel818 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel785, fields_panel808, VouchersByDeclaration_grid817 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel818;
    this.before_row_edit = function(record) {
      VouchersByDeclaration_grid817.on_master_changed();
    }
    Lino.declarations.Declarations.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.Models.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var app_disp891 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "app_label", "name": "app", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var name_disp892 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "name", "name": "name", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var docstring_disp893 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "docstring", "name": "docstring", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var rows894 = new Ext.form.NumberField({ "disabled": true, "fieldLabel": "Rows", "anchor": "-20", "name": "rows" });
    var main_1_panel895 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_disp891, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_disp892, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": docstring_disp893, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": rows894, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var about_FieldsByModel_grid904 = new Lino.about.FieldsByModel.GridPanel({ "flex": 62, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.about.FieldsByModel.grid) ], "master_panel": this });
    var main_panel905 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel895, about_FieldsByModel_grid904 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel905;
    this.before_row_edit = function(record) {
      about_FieldsByModel_grid904.on_master_changed();
    }
    Lino.about.Models.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.partners.Persons.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 19,
  initComponent : function() {
    var containing_panel = this;
    var last_name41 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Last name", "anchor": "-20", "name": "last_name" });
    var first_name42 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "First name", "anchor": "-20", "name": "first_name" });
    var gender43 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Gender", "name": "gender", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.Genders, "hiddenName": "genderHidden" });
    var title44 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Title", "anchor": "-20", "name": "title" });
    var name_box_panel45 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name41, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name42, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender43, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title44, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var country50 = new Lino.TwinCombo({ "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Select a Country...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/Persons/country", "method": "GET" }) }) });
    var city52 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/Persons/city", "method": "GET" }) }) });
    var zip_code53 = new Ext.form.TextField({ "fieldLabel": "Zip code", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_2_panel54 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country50, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city52, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code53, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr158 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Address line before street","Address line before street") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line before street</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_prefix59 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Street prefix","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street prefix</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street60 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Street","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no61 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("No.","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box62 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_4_panel63 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix59, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street60, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no61, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box62, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr268 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Address line after street","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line after street</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var address_box_panel69 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "layout": "form", "title": "Address", "items": [ name_box_panel45, address_box_2_panel54, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr158, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel63, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr268, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 243, "border": false, "labelAlign": "top" });
    var id72 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language73 = new Lino.ChoicesFieldElement({ "fieldLabel": "Language", "allowBlank": false, "value": "en", "hiddenName": "languageHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var info_box_panel74 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id72, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language73, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email77 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-Mail", "anchor": "-20", "name": "email" });
    var url78 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone79 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Phone", "anchor": "-20", "name": "phone" });
    var gsm80 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var fax81 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Fax", "anchor": "-20", "name": "fax" });
    var contact_box_5_panel82 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm80, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax81, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel85 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "layout": "form", "title": "Contact", "items": [ info_box_panel74, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email77, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url78, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone79, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel82 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var general_1_panel89 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ address_box_panel69, contact_box_panel85 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks90 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarks", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var partners_ContactsByPerson_grid95 = new Lino.partners.ContactsByPerson.GridPanel({ "flex": 42, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.partners.ContactsByPerson.grid) ], "master_panel": this });
    var bottom_box_panel96 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": remarks90, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 57 }, partners_ContactsByPerson_grid95 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var general_panel98 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel89, bottom_box_panel96 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var ledger_InvoicesByPartner_grid186 = new Lino.ledger.InvoicesByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.ledger.InvoicesByPartner.grid) ] });
    var ledger_MovementsByPartner_grid193 = new Lino.ledger.MovementsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.ledger.MovementsByPartner.grid) ] });
    var ledger_panel194 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Accounting", "hideCheckBoxLabels": true, "items": [ ledger_InvoicesByPartner_grid186, ledger_MovementsByPartner_grid193 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel195 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel98, ledger_panel194 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel195;
    this.before_row_edit = function(record) {
      city52.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city52.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      partners_ContactsByPerson_grid95.on_master_changed();
      ledger_InvoicesByPartner_grid186.on_master_changed();
      ledger_MovementsByPartner_grid193.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country50.on('change',Lino.chooser_handler(city52,'country'));
      Lino.partners.Persons.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.partners.Persons.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.partners.Partners.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 22,
  initComponent : function() {
    var containing_panel = this;
    var id493 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name494 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var general_1_panel495 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id493, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name494, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 45, "border": false, "anchor": "-20", "labelAlign": "top" });
    var partner_disp498 = new Ext.form.DisplayField({ "fieldLabel": "Organisation", "name": "partner", "selectOnFocus": true, "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var partner_disp499 = new Ext.form.DisplayField({ "fieldLabel": "Person", "name": "partner", "selectOnFocus": true, "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var general_2_panel500 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner_disp498, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner_disp499, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var general_panel503 = new Ext.Panel({ "autoHeight": true, "layout": "form", "title": "General", "items": [ general_1_panel495, general_2_panel500 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "labelAlign": "top" });
    var ledger_InvoicesByPartner_grid504 = new Lino.ledger.InvoicesByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.ledger.InvoicesByPartner.grid) ] });
    var ledger_MovementsByPartner_grid505 = new Lino.ledger.MovementsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.ledger.MovementsByPartner.grid) ] });
    var ledger_panel506 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Accounting", "hideCheckBoxLabels": true, "items": [ ledger_InvoicesByPartner_grid504, ledger_MovementsByPartner_grid505 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var payment_term507 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Payment Term</span>", "name": "payment_term", "pageSize": 20, "emptyText": "Select a Payment Term...", "listeners": { "render": Lino.quicktip_renderer("Payment Term","The default payment term for sales invoices to this customer.") }, "selectOnFocus": true, "hiddenName": "payment_termHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/Partners/payment_term", "method": "GET" }) }) });
    var vat_regime508 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">VAT Regime</span>", "name": "vat_regime", "hiddenName": "vat_regimeHidden", "listeners": { "render": Lino.quicktip_renderer("VAT Regime","The default VAT regime for sales to this customer.") }, "selectOnFocus": true, "anchor": "-20", "store": Lino.vat.VatRegimes });
    var item_vat509 = new Ext.form.Checkbox({ "boxLabel": "item vat", "listeners": { "render": Lino.quicktip_renderer("item vat","The default item VAT setting for sales to this customer.") }, "hideLabel": true, "checked": false, "name": "item_vat", "selectOnFocus": true, "anchor": "-20" });
    var imode510 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Invoicing Mode", "name": "imode", "pageSize": 20, "emptyText": "Select a Invoicing Mode...", "selectOnFocus": true, "hiddenName": "imodeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/Partners/imode", "method": "GET" }) }) });
    var sales_1_panel511 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 135, "hideCheckBoxLabels": true, "items": [ { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": payment_term507, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_regime508, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": item_vat509, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": imode510, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var sales_InvoicesByPartner_grid624 = new Lino.sales.InvoicesByPartner.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.sales.InvoicesByPartner.grid) ], "master_panel": this });
    var sales_panel625 = new Ext.Panel({ "layout": "vbox", "title": "Sales", "items": [ sales_1_panel511, sales_InvoicesByPartner_grid624 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel626 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel503, ledger_panel506, sales_panel625 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel626;
    this.before_row_edit = function(record) {
      ledger_InvoicesByPartner_grid504.on_master_changed();
      ledger_MovementsByPartner_grid505.on_master_changed();
      sales_InvoicesByPartner_grid624.on_master_changed();
    }
    Lino.partners.Partners.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Countries.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 14,
  initComponent : function() {
    var containing_panel = this;
    var isocode302 = new Ext.form.TextField({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">ISO code</span>", "name": "isocode", "boxMinWidth": Lino.chars2width(4), "listeners": { "render": Lino.quicktip_renderer("ISO code","        The two-letter code for this country as defined by ISO 3166-1. \n        For countries that no longer exist it may be a 4-letter code.") }, "maxLength": 4, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name303 = new Ext.form.TextField({ "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de304 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Designation (de)", "anchor": "-20", "name": "name_de" });
    var name_fr305 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Designation (fr)", "anchor": "-20", "name": "name_fr" });
    var short_code306 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Short code","A short abbreviation for regional usage. Obsolete.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Short code</span>", "name": "short_code", "maxLength": 4, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "anchor": "-20" });
    var main_1_panel307 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": isocode302, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name303, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de304, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr305, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": short_code306, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var countries_CitiesByCountry_grid491 = new Lino.countries.CitiesByCountry.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.countries.CitiesByCountry.grid) ], "master_panel": this });
    var main_panel492 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel307, countries_CitiesByCountry_grid491 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel492;
    this.before_row_edit = function(record) {
      countries_CitiesByCountry_grid491.on_master_changed();
    }
    Lino.countries.Countries.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Cities.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 16,
  initComponent : function() {
    var containing_panel = this;
    var name321 = new Ext.form.TextField({ "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de322 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Designation (de)", "anchor": "-20", "name": "name_de" });
    var name_fr323 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Designation (fr)", "anchor": "-20", "name": "name_fr" });
    var country324 = new Lino.TwinCombo({ "fieldLabel": "Country", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Select a Country...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/country", "method": "GET" }) }), "name": "country" });
    var main_1_panel325 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name321, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de322, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr323, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country324, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var type330 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Place Type", "name": "type", "selectOnFocus": true, "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/type", "method": "GET" }) }), "hiddenName": "typeHidden" });
    var parent331 = new Lino.TwinCombo({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Part of</span>", "name": "parent", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "listeners": { "render": Lino.quicktip_renderer("Part of","The superordinate geographic place of which this place is a part.") }, "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/parent", "method": "GET" }) }) });
    var zip_code332 = new Ext.form.TextField({ "fieldLabel": "zip code", "name": "zip_code", "maxLength": 8, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "anchor": "-20" });
    var id333 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_2_panel334 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type330, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent331, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code332, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id333, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var CitiesByCity_grid486 = new Lino.countries.CitiesByCity.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.countries.CitiesByCity.grid) ], "master_panel": this });
    var partners_PersonsByCity_grid487 = new Lino.partners.PersonsByCity.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.partners.PersonsByCity.grid) ], "master_panel": this });
    var partners_OrganisationsByCity_grid488 = new Lino.partners.OrganisationsByCity.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.partners.OrganisationsByCity.grid) ], "master_panel": this });
    var main_4_panel489 = new Ext.Panel({ "flex": 41, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ partners_PersonsByCity_grid487, partners_OrganisationsByCity_grid488 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel490 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel325, main_2_panel334, CitiesByCity_grid486, main_4_panel489 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel490;
    this.before_row_edit = function(record) {
      type330.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      CitiesByCity_grid486.on_master_changed();
      partners_PersonsByCity_grid487.on_master_changed();
      partners_OrganisationsByCity_grid488.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country324.on('change',Lino.chooser_handler(type330,'country'));
      Lino.countries.Cities.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.countries.Cities.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ui.ContentTypes.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 5,
  initComponent : function() {
    var containing_panel = this;
    var id212 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name213 = new Ext.form.TextField({ "fieldLabel": "name", "name": "name", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var app_label214 = new Ext.form.TextField({ "fieldLabel": "app label", "name": "app_label", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var model215 = new Ext.form.TextField({ "fieldLabel": "python model class name", "name": "model", "maxLength": 100, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var base_classes_disp216 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Base classes", "name": "base_classes", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_1_panel217 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 216, "hideCheckBoxLabels": true, "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id212, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name213, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_label214, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": model215, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": base_classes_disp216, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ui_HelpTextsByModel_grid229 = new Lino.ui.HelpTextsByModel.GridPanel({ "flex": 62, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.ui.HelpTextsByModel.grid) ], "master_panel": this });
    var main_panel230 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel217, ui_HelpTextsByModel_grid229 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel230;
    this.before_row_edit = function(record) {
      ui_HelpTextsByModel_grid229.on_master_changed();
    }
    Lino.ui.ContentTypes.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Invoices.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 30,
  initComponent : function() {
    var containing_panel = this;
    var id123 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var date124 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "Date", "anchor": "-20", "name": "date" });
    var partner125 = new Lino.TwinCombo({ "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.partners.Partners.detail)}, "emptyText": "Select a Partner...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/partner", "method": "GET" }) }), "name": "partner" });
    var user126 = new Lino.TwinCombo({ "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Select a User...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/user", "method": "GET" }) }) });
    var general_1_panel127 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id123, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date124, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner125, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user126, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var due_date132 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Due date", "anchor": "-20", "name": "due_date" });
    var your_ref133 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Your reference", "anchor": "-20", "name": "your_ref" });
    var vat_regime134 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "VAT Regime", "name": "vat_regime", "selectOnFocus": true, "anchor": "-20", "store": Lino.vat.VatRegimes, "hiddenName": "vat_regimeHidden" });
    var item_vat135 = new Ext.form.Checkbox({ "boxLabel": "Prices include VAT", "listeners": { "render": Lino.quicktip_renderer("Prices include VAT","Whether prices includes VAT or not.") }, "hideLabel": true, "checked": false, "name": "item_vat", "selectOnFocus": true, "anchor": "-20" });
    var general_2_panel136 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": due_date132, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": your_ref133, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_regime134, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": item_vat135, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 171, "border": false, "anchor": "-20", "labelAlign": "top" });
    var ItemsByInvoice_grid149 = new Lino.ledger.ItemsByInvoice.GridPanel({ "flex": 75, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.ledger.ItemsByInvoice.grid) ], "master_panel": this });
    var total_base150 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Total excl. VAT", "name": "total_base", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var total_vat151 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "VAT", "name": "total_vat", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var total_incl152 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Total incl. VAT", "name": "total_incl", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var workflow_buttons_disp153 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Workflow", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var totals_panel154 = new Ext.Panel({ "flex": 25, "autoHeight": true, "layout": "form", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_base150, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_vat151, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_incl152, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp153, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 144, "border": false, "labelAlign": "top" });
    var general_3_panel159 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ ItemsByInvoice_grid149, totals_panel154 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "anchor": "-20", "labelAlign": "top" });
    var general_panel160 = new Ext.Panel({ "autoHeight": true, "layout": "form", "title": "General", "items": [ general_1_panel127, general_2_panel136, general_3_panel159 ], "frame": true, "bodyBorder": false, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "labelAlign": "top" });
    var journal161 = new Lino.TwinCombo({ "fieldLabel": "Journal", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail)}, "emptyText": "Select a Journal...", "selectOnFocus": true, "hiddenName": "journalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/journal", "method": "GET" }) }), "name": "journal" });
    var year162 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "year", "selectOnFocus": true, "anchor": "-20", "store": Lino.ledger.FiscalYears, "hiddenName": "yearHidden" });
    var number163 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "number", "anchor": "-20", "name": "number" });
    var narration164 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Narration", "anchor": "-20", "name": "narration" });
    var ledger_1_panel165 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": journal161, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": year162, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": number163, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": narration164, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var MovementsByVoucher_grid175 = new Lino.ledger.MovementsByVoucher.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.ledger.MovementsByVoucher.grid) ], "master_panel": this });
    var ledger_panel176 = new Ext.Panel({ "layout": "vbox", "title": "Ledger", "items": [ ledger_1_panel165, MovementsByVoucher_grid175 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel177 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel160, ledger_panel176 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel177;
    this.before_row_edit = function(record) {
      ItemsByInvoice_grid149.on_master_changed();
      MovementsByVoucher_grid175.on_master_changed();
    }
    Lino.ledger.Invoices.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.declarations.Declarations.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 33,
  initComponent : function() {
    var containing_panel = this;
    var date819 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "Date", "anchor": "-20", "name": "date" });
    var year820 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "year", "selectOnFocus": true, "anchor": "-20", "store": Lino.ledger.FiscalYears, "hiddenName": "yearHidden" });
    var period821 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "VAT Period", "allowBlank": false, "hiddenName": "periodHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.declarations.DeclarationPeriods, "name": "period" });
    var main_panel822 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 108, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": date819, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": year820, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": period821, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel822;
    this.before_row_edit = function(record) {
    }
    Lino.declarations.Declarations.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.partners.Partners.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 22,
  initComponent : function() {
    var containing_panel = this;
    var name627 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var partner_disp628 = new Ext.form.DisplayField({ "fieldLabel": "Organisation", "name": "partner", "selectOnFocus": true, "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var partner_disp629 = new Ext.form.DisplayField({ "fieldLabel": "Person", "name": "partner", "selectOnFocus": true, "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_2_panel630 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner_disp628, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner_disp629, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel633 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name627, "anchor": "-20", "labelAlign": "top" }, main_2_panel630 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel633;
    this.before_row_edit = function(record) {
    }
    Lino.partners.Partners.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.partners.Persons.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 19,
  initComponent : function() {
    var containing_panel = this;
    var title196 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Title", "anchor": "-20", "name": "title" });
    var first_name197 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "First name", "anchor": "-20", "name": "first_name" });
    var last_name198 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Last name", "anchor": "-20", "name": "last_name" });
    var main_1_panel199 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title196, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name197, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name198, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var gender203 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Gender", "name": "gender", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.Genders, "hiddenName": "genderHidden" });
    var language204 = new Lino.ChoicesFieldElement({ "fieldLabel": "Language", "allowBlank": false, "value": "en", "hiddenName": "languageHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var main_2_panel205 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender203, "labelAlign": "top" }, { "flex": 68, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language204, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel208 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel199, main_2_panel205 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel208;
    this.before_row_edit = function(record) {
    }
    Lino.partners.Persons.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ui.SiteConfigs.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 1,
  initComponent : function() {
    var containing_panel = this;
    var default_build_method209 = new Lino.ChoicesFieldElement({ "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "fieldLabel": "Default build method", "name": "default_build_method", "selectOnFocus": true, "anchor": "-20", "value": "appyodt", "hiddenName": "default_build_methodHidden" });
    var main_panel210 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "labelWidth": 189, "hideCheckBoxLabels": true, "items": [ { "items": default_build_method209, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel210;
    this.before_row_edit = function(record) {
    }
    Lino.ui.SiteConfigs.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.finan.BankStatements.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 41,
  initComponent : function() {
    var containing_panel = this;
    var date862 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "Date", "anchor": "-20", "name": "date" });
    var balance1863 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Old balance", "name": "balance1", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var balance2864 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "New balance", "name": "balance2", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var main_panel865 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 108, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": date862, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": balance1863, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": balance2864, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel865;
    this.before_row_edit = function(record) {
    }
    Lino.finan.BankStatements.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ui.TextFieldTemplates.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 3,
  initComponent : function() {
    var containing_panel = this;
    var name244 = new Ext.form.TextField({ "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user245 = new Lino.TwinCombo({ "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Select a User...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/TextFieldTemplates/user", "method": "GET" }) }) });
    var team246 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Team</span>", "name": "team", "pageSize": 20, "emptyText": "Select a Team...", "listeners": { "render": Lino.quicktip_renderer("Team","If not empty, then this template is reserved to members of this team.") }, "selectOnFocus": true, "hiddenName": "teamHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/TextFieldTemplates/team", "method": "GET" }) }) });
    var main_2_panel247 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user245, "labelAlign": "top" }, { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": team246, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 63, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel250 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 108, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name244, "anchor": "-20", "labelAlign": "top" }, main_2_panel247 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel250;
    this.before_row_edit = function(record) {
    }
    Lino.ui.TextFieldTemplates.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.Users.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 11,
  initComponent : function() {
    var containing_panel = this;
    var username252 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Username","\n        Required. Must be unique. \n        ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Username</span>", "name": "username", "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var id253 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var profile254 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "User Profile", "name": "profile", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.UserProfiles, "hiddenName": "profileHidden" });
    var box1_1_panel255 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username252, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id253, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile254, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name259 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30, "fieldLabel": "First name", "anchor": "-20", "name": "first_name" });
    var last_name260 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30, "fieldLabel": "Last name", "anchor": "-20", "name": "last_name" });
    var box1_2_panel261 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name259, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name260, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email264 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "e-mail address", "anchor": "-20", "name": "email" });
    var language265 = new Lino.ChoicesFieldElement({ "fieldLabel": "Language", "allowBlank": false, "selectOnFocus": true, "hiddenName": "languageHidden", "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var box1_3_panel266 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 51, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email264, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language265, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var created269 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Created", "anchor": "-20", "value": "<br>", "name": "created" });
    var modified270 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Modified", "anchor": "-20", "value": "<br>", "name": "modified" });
    var box1_4_panel271 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created269, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified270, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var box1_panel274 = new Ext.Panel({ "flex": 66, "autoHeight": true, "border": false, "layout": "form", "hideCheckBoxLabels": true, "items": [ box1_1_panel255, box1_2_panel261, box1_3_panel266, box1_4_panel271 ], "frame": true, "autoScroll": false, "bodyBorder": false, "labelAlign": "top" });
    var MembershipsByUser_grid277 = new Lino.users.MembershipsByUser.GridPanel({ "flex": 33, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.users.MembershipsByUser.grid) ], "master_panel": this });
    var main_1_panel278 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ box1_panel274, MembershipsByUser_grid277 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks279 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarks", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var AuthoritiesGiven_grid282 = new Lino.users.AuthoritiesGiven.GridPanel({ "flex": 33, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.users.AuthoritiesGiven.grid) ], "master_panel": this });
    var main_2_panel283 = new Ext.Panel({ "flex": 50, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": remarks279, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 66 }, AuthoritiesGiven_grid282 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var main_panel285 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel278, main_2_panel283 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel285;
    this.before_row_edit = function(record) {
      MembershipsByUser_grid277.on_master_changed();
      AuthoritiesGiven_grid282.on_master_changed();
    }
    Lino.users.Users.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.pages.Pages.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 43,
  initComponent : function() {
    var containing_panel = this;
    var ref874 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40, "fieldLabel": "Reference", "anchor": "-20", "name": "ref" });
    var parent875 = new Lino.TwinCombo({ "fieldLabel": "Parent", "name": "parent", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.pages.Pages.detail)}, "emptyText": "Select a Node...", "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pages/Pages/parent", "method": "GET" }) }) });
    var seqno876 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "Seq.No.", "anchor": "-20", "name": "seqno" });
    var main_1_panel877 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 90, "hideCheckBoxLabels": true, "items": [ { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref874, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent875, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": seqno876, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var title881 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Title", "anchor": "-20", "name": "title" });
    var title_de882 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Title (de)", "anchor": "-20", "name": "title_de" });
    var title_fr883 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Title (fr)", "anchor": "-20", "name": "title_fr" });
    var main_2_panel884 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 99, "hideCheckBoxLabels": true, "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title881, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title_de882, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title_fr883, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var body888 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Body", "anchor": "-20 -10", "growMax": 2000, "name": "body" });
    var main_panel889 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 45, "hideCheckBoxLabels": true, "items": [ main_1_panel877, main_2_panel884, { "items": body888, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 71 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel889;
    this.before_row_edit = function(record) {
    }
    Lino.pages.Pages.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.products.ProductCats.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 23,
  initComponent : function() {
    var containing_panel = this;
    var id635 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name636 = new Ext.form.TextField({ "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de637 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Designation (de)", "anchor": "-20", "name": "name_de" });
    var name_fr638 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Designation (fr)", "anchor": "-20", "name": "name_fr" });
    var main_1_panel639 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id635, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name636, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de637, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr638, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 153, "border": false, "frame": false, "labelAlign": "top" });
    var description644 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "description", "anchor": "-20 -10", "growMax": 2000, "name": "description" });
    var ProductsByCategory_grid688 = new Lino.products.ProductsByCategory.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.products.ProductsByCategory.grid) ] });
    var main_panel689 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ main_1_panel639, { "flex": 5, "layout": "form", "xtype": "panel", "items": description644, "region": "center", "labelAlign": "top", "split": true }, ProductsByCategory_grid688 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel689;
    this.before_row_edit = function(record) {
      ProductsByCategory_grid688.on_master_changed();
    }
    Lino.products.ProductCats.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ui.TextFieldTemplates.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 3,
  initComponent : function() {
    var containing_panel = this;
    var id231 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name232 = new Ext.form.TextField({ "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var user233 = new Lino.TwinCombo({ "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Select a User...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/TextFieldTemplates/user", "method": "GET" }) }) });
    var team234 = new Lino.RemoteComboFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Team</span>", "name": "team", "pageSize": 20, "emptyText": "Select a Team...", "listeners": { "render": Lino.quicktip_renderer("Team","If not empty, then this template is reserved to members of this team.") }, "selectOnFocus": true, "hiddenName": "teamHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/TextFieldTemplates/team", "method": "GET" }) }) });
    var main_1_panel235 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id231, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name232, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user233, "labelAlign": "top" }, { "flex": 32, "autoHeight": true, "layout": "form", "xtype": "panel", "items": team234, "labelAlign": "top" } ], "region": "north", "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "split": true, "autoScroll": false, "labelWidth": 108, "border": false, "frame": false, "labelAlign": "top" });
    var description240 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Description", "anchor": "-20 -10", "growMax": 2000, "name": "description" });
    var text241 = new Lino.RichTextPanel({ "flex": 5, "split": true, "containing_panel": this, "selectOnFocus": true, "region": "south", "title": "Template Text", "name": "text" });
    var main_panel242 = new Lino.VBorderPanel({ "autoScroll": false, "border": false, "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ main_1_panel235, { "flex": 5, "layout": "form", "xtype": "panel", "items": description240, "region": "center", "labelAlign": "top", "split": true }, text241 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel242;
    this.before_row_edit = function(record) {
      text241.refresh();
    }
    Lino.ui.TextFieldTemplates.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.about.About.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  disable_editing: true,
  initComponent : function() {
    var containing_panel = this;
    var main_panel915 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "fit", "hideCheckBoxLabels": true, "items": [ { "html": "<div class=\"htmlText\"><p><a href=\"http://www.python.org/\" target=\"_blank\">Python</a> 2.7.3, <a href=\"http://www.djangoproject.com\" target=\"_blank\">Django</a> 1.5.1, <a href=\"http://site.lino-framework.org\" target=\"_blank\">djangosite</a> 0.1.1, <a href=\"http://babel.edgewall.org/\" target=\"_blank\">Babel</a> 0.9.6, <a href=\"http://north.lino-framework.org\" target=\"_blank\">North</a> 0.1.1, <a href=\"http://www.lino-framework.org\" target=\"_blank\">Lino</a> 1.6.4, <a href=\"http://jinja.pocoo.org/\" target=\"_blank\">Jinja</a> 2.6, <a href=\"http://sphinx-doc.org/\" target=\"_blank\">Sphinx</a> 1.2b1, <a href=\"http://labix.org/python-dateutil\" target=\"_blank\">python-dateutil</a> 2.1, <a href=\"http://pypi.python.org/pypi/odfpy\" target=\"_blank\">OdfPy</a> ODFPY/0.9.6, <a href=\"http://docutils.sourceforge.net/\" target=\"_blank\">docutils</a> 0.10, <a href=\"https://fedorahosted.org/suds/\" target=\"_blank\">suds</a> 0.4, <a href=\"http://pyyaml.org/\" target=\"_blank\">PyYaml</a> 3.10, <a href=\"http://appyframework.org/pod.html\" target=\"_blank\">Appy</a> 0.8.3 (2013/02/22 15:29)</p><ul><li>Server uptime : <b>Thursday, April 18, 2013 at 13:18:45.621708</b></li><li>Source timestamp (lino) : <b>Thursday, April 18, 2013 at 13:18:44.530004</b></li></ul></div>", "xtype": "label" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel915;
    this.before_row_edit = function(record) {
    }
    Lino.about.About.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.partners.Organisations.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 18,
  initComponent : function() {
    var containing_panel = this;
    var name470 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var language471 = new Lino.ChoicesFieldElement({ "fieldLabel": "Language", "allowBlank": false, "value": "en", "hiddenName": "languageHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var email472 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-Mail", "anchor": "-20", "name": "email" });
    var main_2_panel473 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language471, "labelAlign": "top" }, { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email472, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var type476 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Organisation type", "name": "type", "pageSize": 20, "emptyText": "Select a Organisation type...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/Organisations/type", "method": "GET" }) }) });
    var id477 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_3_panel478 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type476, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id477, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 162, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel481 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 45, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name470, "anchor": "-20", "labelAlign": "top" }, main_2_panel473, main_3_panel478 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel481;
    this.before_row_edit = function(record) {
    }
    Lino.partners.Organisations.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.sales.Invoices.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 38,
  initComponent : function() {
    var containing_panel = this;
    var date546 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "Date", "anchor": "-20", "name": "date" });
    var partner547 = new Lino.TwinCombo({ "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.partners.Partners.detail)}, "emptyText": "Select a Partner...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/partner", "method": "GET" }) }), "name": "partner" });
    var vat_regime548 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "VAT Regime", "name": "vat_regime", "selectOnFocus": true, "anchor": "-20", "store": Lino.vat.VatRegimes, "hiddenName": "vat_regimeHidden" });
    var invoice_header_1_panel549 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date546, "labelAlign": "top" }, { "flex": 43, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner547, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_regime548, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var subject553 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Subject line", "anchor": "-20", "name": "subject" });
    var your_ref554 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Your reference", "anchor": "-20", "name": "your_ref" });
    var invoice_header_2_panel555 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject553, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": your_ref554, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var payment_term558 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Payment Term", "name": "payment_term", "pageSize": 20, "emptyText": "Select a Payment Term...", "selectOnFocus": true, "hiddenName": "payment_termHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/payment_term", "method": "GET" }) }) });
    var due_date559 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date of payment", "anchor": "-20", "name": "due_date" });
    var invoice_header_3_panel560 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": payment_term558, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": due_date559, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 144, "border": false, "anchor": "-20", "labelAlign": "top" });
    var imode563 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Invoicing Mode", "name": "imode", "pageSize": 20, "emptyText": "Select a Invoicing Mode...", "selectOnFocus": true, "hiddenName": "imodeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/imode", "method": "GET" }) }) });
    var shipping_mode564 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Shipping Mode", "name": "shipping_mode", "pageSize": 20, "emptyText": "Select a Shipping Mode...", "selectOnFocus": true, "hiddenName": "shipping_modeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/shipping_mode", "method": "GET" }) }) });
    var invoice_header_4_panel565 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": imode563, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": shipping_mode564, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var invoice_header_panel568 = new Ext.form.FieldSet({ "flex": 75, "autoHeight": true, "layout": "form", "title": "Header", "items": [ invoice_header_1_panel549, invoice_header_2_panel555, invoice_header_3_panel560, invoice_header_4_panel565 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var total_base569 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Total excl. VAT", "name": "total_base", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var total_vat570 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "VAT", "name": "total_vat", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var total_incl571 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Total incl. VAT", "name": "total_incl", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var workflow_buttons_disp572 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Workflow", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var totals_panel573 = new Ext.form.FieldSet({ "flex": 25, "autoHeight": true, "layout": "form", "title": "Totals", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_base569, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_vat570, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_incl571, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp572, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 144, "border": false, "labelAlign": "top" });
    var general_1_panel578 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ invoice_header_panel568, totals_panel573 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ItemsByInvoice_grid590 = new Lino.sales.ItemsByInvoice.GridPanel({ "flex": 45, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.sales.ItemsByInvoice.grid) ], "master_panel": this });
    var general_panel591 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel578, ItemsByInvoice_grid590 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var id592 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var user593 = new Lino.TwinCombo({ "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Select a User...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/user", "method": "GET" }) }) });
    var language594 = new Lino.ChoicesFieldElement({ "fieldLabel": "Language", "allowBlank": false, "value": "en", "hiddenName": "languageHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var item_vat595 = new Ext.form.Checkbox({ "boxLabel": "Prices include VAT", "listeners": { "render": Lino.quicktip_renderer("Prices include VAT","Whether prices includes VAT or not.") }, "hideLabel": true, "checked": false, "name": "item_vat", "selectOnFocus": true, "anchor": "-20" });
    var more_1_panel596 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 171, "hideCheckBoxLabels": true, "items": [ { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id592, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user593, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language594, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": item_vat595, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var intro601 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Introductive Text", "anchor": "-20 -10", "growMax": 2000, "name": "intro" });
    var more_panel602 = new Ext.Panel({ "layout": "vbox", "title": "More", "items": [ more_1_panel596, { "items": intro601, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 } ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "labelWidth": 162, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var journal604 = new Lino.TwinCombo({ "fieldLabel": "Journal", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail)}, "emptyText": "Select a Journal...", "selectOnFocus": true, "hiddenName": "journalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/journal", "method": "GET" }) }), "name": "journal" });
    var year605 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "year", "selectOnFocus": true, "anchor": "-20", "store": Lino.ledger.FiscalYears, "hiddenName": "yearHidden" });
    var number606 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "number", "anchor": "-20", "name": "number" });
    var narration607 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Narration", "anchor": "-20", "name": "narration" });
    var ledger_1_panel608 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": journal604, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": year605, "labelAlign": "top" }, { "flex": 9, "autoHeight": true, "layout": "form", "xtype": "panel", "items": number606, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": narration607, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var ledger_MovementsByVoucher_grid613 = new Lino.ledger.MovementsByVoucher.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.ledger.MovementsByVoucher.grid) ], "master_panel": this });
    var ledger_panel614 = new Ext.Panel({ "layout": "vbox", "title": "Ledger", "items": [ ledger_1_panel608, ledger_MovementsByVoucher_grid613 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var main_panel615 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel591, more_panel602, ledger_panel614 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel615;
    this.before_row_edit = function(record) {
      ItemsByInvoice_grid590.on_master_changed();
      ledger_MovementsByVoucher_grid613.on_master_changed();
    }
    Lino.sales.Invoices.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.Users.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 11,
  initComponent : function() {
    var containing_panel = this;
    var username286 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Username","\n        Required. Must be unique. \n        ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Username</span>", "name": "username", "maxLength": 30, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var email287 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "e-mail address", "anchor": "-20", "name": "email" });
    var main_1_panel288 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username286, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email287, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 135, "border": false, "anchor": "-20", "labelAlign": "top" });
    var first_name291 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30, "fieldLabel": "First name", "anchor": "-20", "name": "first_name" });
    var last_name292 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30, "fieldLabel": "Last name", "anchor": "-20", "name": "last_name" });
    var main_2_panel293 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name291, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name292, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 99, "border": false, "anchor": "-20", "labelAlign": "top" });
    var language296 = new Lino.ChoicesFieldElement({ "fieldLabel": "Language", "allowBlank": false, "selectOnFocus": true, "hiddenName": "languageHidden", "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var profile297 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "User Profile", "name": "profile", "selectOnFocus": true, "anchor": "-20", "store": Lino.lino.UserProfiles, "hiddenName": "profileHidden" });
    var main_4_panel298 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 47, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language296, "labelAlign": "top" }, { "flex": 52, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile297, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 117, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel301 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "autoScroll": false, "items": [ main_1_panel288, main_2_panel293, main_4_panel298 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel301;
    this.before_row_edit = function(record) {
    }
    Lino.users.Users.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.sales.Invoices.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 38,
  initComponent : function() {
    var containing_panel = this;
    var partner616 = new Lino.TwinCombo({ "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.partners.Partners.detail)}, "emptyText": "Select a Partner...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/partner", "method": "GET" }) }), "name": "partner" });
    var date617 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "Date", "anchor": "-20", "name": "date" });
    var main_1_panel618 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 71, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner616, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date617, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 72, "border": false, "anchor": "-20", "labelAlign": "top" });
    var subject621 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Subject line", "anchor": "-20", "name": "subject" });
    var main_panel622 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 117, "autoScroll": false, "items": [ main_1_panel618, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject621, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel622;
    this.before_row_edit = function(record) {
    }
    Lino.sales.Invoices.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Invoices.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 30,
  initComponent : function() {
    var containing_panel = this;
    var partner178 = new Lino.TwinCombo({ "fieldLabel": "Partner", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.partners.Partners.detail)}, "emptyText": "Select a Partner...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/partner", "method": "GET" }) }), "name": "partner" });
    var date179 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "Date", "anchor": "-20", "name": "date" });
    var total_incl180 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Total incl. VAT", "name": "total_incl", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var main_2_panel181 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date179, "labelAlign": "top" }, { "flex": 60, "autoHeight": true, "layout": "form", "xtype": "panel", "items": total_incl180, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 144, "border": false, "anchor": "-20", "labelAlign": "top" });
    var main_panel184 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 72, "autoScroll": false, "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner178, "anchor": "-20", "labelAlign": "top" }, main_2_panel181 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel184;
    this.before_row_edit = function(record) {
    }
    Lino.ledger.Invoices.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Groups.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 26,
  initComponent : function() {
    var containing_panel = this;
    var ref708 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20, "fieldLabel": "ref", "anchor": "-20", "name": "ref" });
    var name709 = new Ext.form.TextField({ "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de710 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Designation (de)", "anchor": "-20", "name": "name_de" });
    var name_fr711 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Designation (fr)", "anchor": "-20", "name": "name_fr" });
    var main_1_panel712 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ref708, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name709, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de710, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr711, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var account_type717 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Account Type", "name": "account_type", "selectOnFocus": true, "anchor": "-20", "store": Lino.accounts.AccountTypes, "hiddenName": "account_typeHidden" });
    var id718 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var main_2_panel719 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 117, "hideCheckBoxLabels": true, "items": [ { "flex": 76, "autoHeight": true, "layout": "form", "xtype": "panel", "items": account_type717, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id718, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var help_text722 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 41, "containing_panel": this, "name": "help_text", "title": "Introduction" });
    var AccountsByGroup_grid735 = new Lino.accounts.AccountsByGroup.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.accounts.AccountsByGroup.grid) ], "master_panel": this });
    var main_panel736 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "labelWidth": 0, "hideCheckBoxLabels": true, "items": [ main_1_panel712, main_2_panel719, help_text722, AccountsByGroup_grid735 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel736;
    this.before_row_edit = function(record) {
      help_text722.refresh();
      AccountsByGroup_grid735.on_master_changed();
    }
    Lino.accounts.Groups.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.partners.Organisations.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 18,
  initComponent : function() {
    var containing_panel = this;
    var name413 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var country414 = new Lino.TwinCombo({ "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail)}, "emptyText": "Select a Country...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/Organisations/country", "method": "GET" }) }) });
    var city416 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "Place", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail)}, "emptyText": "Select a Place...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/Organisations/city", "method": "GET" }) }) });
    var zip_code417 = new Ext.form.TextField({ "fieldLabel": "Zip code", "name": "zip_code", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_2_panel418 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country414, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city416, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code417, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr1422 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Address line before street","Address line before street") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line before street</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_prefix423 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Street prefix","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street prefix</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street424 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Street","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var street_no425 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("No.","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var street_box426 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "anchor": "-20" });
    var address_box_4_panel427 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix423, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street424, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no425, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box426, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 126, "border": false, "anchor": "-20", "labelAlign": "top" });
    var addr2432 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Address line after street","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line after street</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "-20" });
    var address_box_panel433 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "layout": "form", "title": "Address", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name413, "anchor": "-20", "labelAlign": "top" }, address_box_2_panel418, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1422, "anchor": "-20", "labelAlign": "top" }, address_box_4_panel427, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2432, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 243, "border": false, "labelAlign": "top" });
    var id437 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var language438 = new Lino.ChoicesFieldElement({ "fieldLabel": "Language", "allowBlank": false, "value": "en", "hiddenName": "languageHidden", "selectOnFocus": true, "anchor": "-20", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var info_box_panel439 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id437, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language438, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 81, "border": false, "anchor": "-20", "labelAlign": "top" });
    var email442 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-Mail", "anchor": "-20", "name": "email" });
    var url443 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "-20", "name": "url" });
    var phone444 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Phone", "anchor": "-20", "name": "phone" });
    var gsm445 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "-20", "name": "gsm" });
    var fax446 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Fax", "anchor": "-20", "name": "fax" });
    var contact_box_5_panel447 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm445, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax446, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 36, "border": false, "anchor": "-20", "labelAlign": "top" });
    var contact_box_panel450 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "layout": "form", "title": "Contact", "items": [ info_box_panel439, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email442, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url443, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone444, "anchor": "-20", "labelAlign": "top" }, contact_box_5_panel447 ], "frame": true, "bodyBorder": false, "autoScroll": false, "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    var general_1_panel454 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "hideCheckBoxLabels": true, "items": [ address_box_panel433, contact_box_panel450 ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var type455 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Organisation type", "name": "type", "pageSize": 20, "emptyText": "Select a Organisation type...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/Organisations/type", "method": "GET" }) }) });
    var vat_id456 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "VAT id", "anchor": "-20", "name": "vat_id" });
    var bottom_box_1_panel457 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 162, "hideCheckBoxLabels": true, "items": [ { "flex": 62, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type455, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id456, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var remarks460 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarks", "anchor": "-20 -10", "growMax": 2000, "name": "remarks" });
    var partners_ContactsByOrganisation_grid461 = new Lino.partners.ContactsByOrganisation.GridPanel({ "flex": 42, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "forceFit": true, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.partners.ContactsByOrganisation.grid) ], "master_panel": this });
    var bottom_box_2_panel462 = new Ext.Panel({ "flex": 83, "border": false, "layout": "hbox", "labelWidth": 72, "hideCheckBoxLabels": true, "items": [ { "items": remarks460, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 57 }, partners_ContactsByOrganisation_grid461 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": false, "labelAlign": "top" });
    var bottom_box_panel464 = new Ext.Panel({ "flex": 54, "border": false, "layout": "vbox", "bodyBorder": false, "hideCheckBoxLabels": true, "items": [ bottom_box_1_panel457, bottom_box_2_panel462 ], "autoScroll": false, "layoutConfig": { "align": "stretch" }, "frame": true, "labelAlign": "top" });
    var general_panel465 = new Ext.Panel({ "layout": "vbox", "title": "General", "items": [ general_1_panel454, bottom_box_panel464 ], "frame": true, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "listeners": { "activate": Lino.on_tab_activate }, "autoScroll": false, "border": false, "bodyBorder": false, "labelAlign": "top" });
    var ledger_InvoicesByPartner_grid466 = new Lino.ledger.InvoicesByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "north", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.ledger.InvoicesByPartner.grid) ] });
    var ledger_MovementsByPartner_grid467 = new Lino.ledger.MovementsByPartner.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.ledger.MovementsByPartner.grid) ] });
    var ledger_panel468 = new Lino.VBorderPanel({ "autoScroll": false, "listeners": { "activate": Lino.on_tab_activate }, "border": false, "title": "Accounting", "hideCheckBoxLabels": true, "items": [ ledger_InvoicesByPartner_grid466, ledger_MovementsByPartner_grid467 ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    var main_panel469 = new Ext.TabPanel({ "hideCheckBoxLabels": true, "border": false, "split": true, "autoScroll": false, "items": [ general_panel465, ledger_panel468 ], "activeTab": 0, "bodyBorder": false, "frame": true, "labelAlign": "top" });
    this.items = main_panel469;
    this.before_row_edit = function(record) {
      city416.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city416.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      partners_ContactsByOrganisation_grid461.on_master_changed();
      ledger_InvoicesByPartner_grid466.on_master_changed();
      ledger_MovementsByPartner_grid467.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country414.on('change',Lino.chooser_handler(city416,'country'));
      Lino.partners.Organisations.DetailFormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.partners.Organisations.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Journals.InsertFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  autoHeight: true,
  content_type: 28,
  initComponent : function() {
    var containing_panel = this;
    var name768 = new Ext.form.TextField({ "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de769 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Designation (de)", "anchor": "-20", "name": "name_de" });
    var name_fr770 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Designation (fr)", "anchor": "-20", "name": "name_fr" });
    var main_1_panel771 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name768, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de769, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr770, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "autoScroll": false, "labelWidth": 153, "border": false, "anchor": "-20", "labelAlign": "top" });
    var trade_type775 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Trade Type", "name": "trade_type", "selectOnFocus": true, "anchor": "-20", "store": Lino.vat.TradeTypes, "hiddenName": "trade_typeHidden" });
    var voucher_type776 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "voucher type", "allowBlank": false, "hiddenName": "voucher_typeHidden", "selectOnFocus": true, "anchor": "-20", "store": Lino.ledger.VoucherTypes, "name": "voucher_type" });
    var main_panel777 = new Ext.Panel({ "hideCheckBoxLabels": true, "autoHeight": true, "border": false, "layout": "form", "labelWidth": 117, "autoScroll": false, "items": [ main_1_panel771, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": trade_type775, "anchor": "-20", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": voucher_type776, "anchor": "-20", "labelAlign": "top" } ], "frame": true, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel777;
    this.before_row_edit = function(record) {
    }
    Lino.ledger.Journals.InsertFormPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Charts.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 27,
  initComponent : function() {
    var containing_panel = this;
    var id691 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var name692 = new Ext.form.TextField({ "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "-20", "allowBlank": false });
    var name_de693 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Designation (de)", "anchor": "-20", "name": "name_de" });
    var name_fr694 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Designation (fr)", "anchor": "-20", "name": "name_fr" });
    var main_1_panel695 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 153, "hideCheckBoxLabels": true, "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id691, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name692, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de693, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr694, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var GroupsByChart_grid737 = new Lino.accounts.GroupsByChart.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.accounts.GroupsByChart.grid) ], "master_panel": this });
    var main_panel738 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel695, GroupsByChart_grid737 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel738;
    this.before_row_edit = function(record) {
      GroupsByChart_grid737.on_master_changed();
    }
    Lino.accounts.Charts.DetailFormPanel.superclass.initComponent.call(this);
  }
});


Lino.finan.BankStatements.DetailFormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 41,
  initComponent : function() {
    var containing_panel = this;
    var date826 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "Date", "anchor": "-20", "name": "date" });
    var narration827 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Narration", "anchor": "-20", "name": "narration" });
    var balance1828 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "Old balance", "name": "balance1", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var balance2829 = new Ext.form.NumberField({ "decimalPrecision": 2, "fieldLabel": "New balance", "name": "balance2", "decimalSeparator": ",", "selectOnFocus": true, "anchor": "-20", "allowBlank": true });
    var main_1_panel830 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date826, "labelAlign": "top" }, { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": narration827, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": balance1828, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": balance2829, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var journal835 = new Lino.TwinCombo({ "fieldLabel": "Journal", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.ledger.Journals.detail)}, "emptyText": "Select a Journal...", "selectOnFocus": true, "hiddenName": "journalHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/BankStatements/journal", "method": "GET" }) }), "name": "journal" });
    var year836 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Fiscal Year", "name": "year", "selectOnFocus": true, "anchor": "-20", "store": Lino.ledger.FiscalYears, "hiddenName": "yearHidden" });
    var number837 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "number", "anchor": "-20", "name": "number" });
    var user838 = new Lino.TwinCombo({ "fieldLabel": "Author", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail)}, "emptyText": "Select a User...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "-20", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/BankStatements/user", "method": "GET" }) }) });
    var id839 = new Ext.form.NumberField({ "selectOnFocus": true, "fieldLabel": "ID", "anchor": "-20", "name": "id" });
    var workflow_buttons_disp840 = new Ext.form.DisplayField({ "disabled": true, "fieldLabel": "Workflow", "name": "workflow_buttons", "anchor": "-20", "value": "<br/>", "always_enabled": true });
    var main_2_panel841 = new Ext.Panel({ "autoScroll": false, "autoHeight": true, "border": false, "layout": "hbox", "labelWidth": 108, "hideCheckBoxLabels": true, "items": [ { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": journal835, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": year836, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": number837, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user838, "labelAlign": "top" }, { "flex": 6, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id839, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": workflow_buttons_disp840, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "labelAlign": "top" });
    var finan_ItemsByStatement_grid860 = new Lino.finan.ItemsByStatement.GridPanel({ "flex": 55, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.finan.ItemsByStatement.grid) ], "master_panel": this });
    var main_panel861 = new Ext.Panel({ "autoScroll": false, "border": false, "layout": "vbox", "hideCheckBoxLabels": true, "items": [ main_1_panel830, main_2_panel841, finan_ItemsByStatement_grid860 ], "frame": true, "layoutConfig": { "align": "stretch" }, "bodyBorder": false, "labelAlign": "top" });
    this.items = main_panel861;
    this.before_row_edit = function(record) {
      finan_ItemsByStatement_grid860.on_master_changed();
    }
    Lino.finan.BankStatements.DetailFormPanel.superclass.initComponent.call(this);
  }
});

Lino.partners.Persons.merge_row = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.partners.Persons.merge_row_ActionFormPanel({});
});
Lino.partners.Organisations.merge_row = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(50), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.partners.Organisations.merge_row_ActionFormPanel({});
});

// js_render_GridPanel_class ui.SiteConfigs
Lino.ui.SiteConfigs.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/ui/SiteConfigs",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": "do_build", "menu_item_text": "Rebuild site cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('do_build','GET'), "text": "Rebuild site cache", "overflowText": "Rebuild site cache", "auto_save": true } ],
  title : "site configs",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "default_build_method" }, 'default_build_methodHidden', { "type": "int", "name": "next_partner_id" }, { "name": "site_partner" }, 'site_partnerHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 1,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.SiteConfigs.detail;
    var ww = this.containing_window;
    var id916 = new Ext.form.NumberField({ "selectOnFocus": true });
    var default_build_method917 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "value": "appyodt" });
    var next_partner_id918 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 100 });
    var site_partner919 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/SiteConfigs/site_partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Organisation..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id916, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Default build method", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "default_build_method", "editor": default_build_method917 }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "The next automatic id for Person or Organisation", "dataIndex": "next_partner_id", "width": Lino.chars2width(5), "editor": next_partner_id918 }), { "colIndex": 3, "sortable": true, "header": "The partner that runs this site", "editable": true, "tooltip": "The partner to be used as sender in documents.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('site_partnerHidden','Lino.partners.Organisations.detail'), "editor": site_partner919, "dataIndex": "site_partner" } ];
    Lino.ui.SiteConfigs.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.ui.SiteConfigs.detailPanel = Ext.extend(Lino.ui.SiteConfigs.DetailFormPanel,{
  empty_title: "Detail site configs",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "do_build", "menu_item_text": "Rebuild site cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('do_build','GET'), "text": "Rebuild site cache", "overflowText": "Rebuild site cache", "auto_save": true } ],
  ls_url: "/ui/SiteConfigs",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.SiteConfigs.detail;
    Lino.ui.SiteConfigs.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.ui.SiteConfigs.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.ui.SiteConfigs.detailPanel(p);
});
Lino.ui.SiteConfigs.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.ui.SiteConfigs.GridPanel(p);
});

// js_render_GridPanel_class ui.ContentTypes
Lino.ui.ContentTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/ui/ContentTypes",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "content types",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "app_label" }, { "name": "model" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 5,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.ContentTypes.detail;
    this.ls_insert_handler = Lino.ui.ContentTypes.insert;
    var ww = this.containing_window;
    var id921 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name922 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var app_label923 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var model924 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id921, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "editor": name922 }, { "colIndex": 2, "sortable": true, "header": "app label", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "app_label", "editor": app_label923 }, { "colIndex": 3, "sortable": true, "header": "python model class name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "model", "editor": model924 } ];
    Lino.ui.ContentTypes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.ui.ContentTypes.insertPanel = Ext.extend(Lino.ui.ContentTypes.DetailFormPanel,{
  empty_title: "New content types",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/ui/ContentTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.ContentTypes.detail;
    this.ls_insert_handler = Lino.ui.ContentTypes.insert;
    Lino.ui.ContentTypes.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.ui.ContentTypes.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.ui.ContentTypes.insertPanel(p);
});

Lino.ui.ContentTypes.detailPanel = Ext.extend(Lino.ui.ContentTypes.DetailFormPanel,{
  empty_title: "Detail content types",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/ui/ContentTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.ContentTypes.detail;
    this.ls_insert_handler = Lino.ui.ContentTypes.insert;
    Lino.ui.ContentTypes.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.ui.ContentTypes.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ui.ContentTypes.detailPanel(p);
});
Lino.ui.ContentTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ui.ContentTypes.GridPanel(p);
});

// js_render_GridPanel_class ui.HelpTexts
Lino.ui.HelpTexts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/ui/HelpTexts",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Help Texts",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "field" }, { "name": "verbose_name" }, { "name": "help_text" }, { "type": "int", "name": "id" }, { "name": "content_type" }, 'content_typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 2,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    var ww = this.containing_window;
    var field926 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/HelpTexts/field", "method": "GET" }) }) });
    var verbose_name927 = new Ext.form.TextField({ "disabled": true, "maxLength": 200 });
    var help_text928 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var id929 = new Ext.form.NumberField({ "selectOnFocus": true });
    var content_type930 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/HelpTexts/content_type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a content type..." });
    this.before_row_edit = function(record) {
      field926.setContextValue('content_type',record ? record.data['content_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      content_type930.on('change',Lino.chooser_handler(field926,'content_type'));
      Lino.ui.HelpTexts.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Field", "editable": true, "tooltip": "The name of the field.", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "field", "editor": field926 }, { "width": Lino.chars2width(21), "colIndex": 1, "sortable": false, "dataIndex": "verbose_name", "header": "Verbose name", "editable": false }, { "colIndex": 2, "sortable": false, "header": "HelpText", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "editor": help_text928, "dataIndex": "help_text" }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id929, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Model", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('content_typeHidden','Lino.ui.ContentTypes.detail'), "editor": content_type930, "dataIndex": "content_type" } ];
    Lino.ui.HelpTexts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ui.HelpTexts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ui.HelpTexts.GridPanel(p);
});

// js_render_GridPanel_class ui.TextFieldTemplates
Lino.ui.TextFieldTemplates.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/ui/TextFieldTemplates",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Text Field Templates",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "name" }, { "name": "description" }, { "name": "team" }, 'teamHidden', { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 3,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.TextFieldTemplates.detail;
    this.ls_insert_handler = Lino.ui.TextFieldTemplates.insert;
    var ww = this.containing_window;
    var id932 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user933 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/TextFieldTemplates/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var name934 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var description935 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var team936 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/TextFieldTemplates/team", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Team..." });
    var text937 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Template Text" });
    this.before_row_edit = function(record) {
      text937.refresh();
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id932, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user933, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "editor": name934 }, { "colIndex": 3, "sortable": false, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "editor": description935, "dataIndex": "description" }, { "colIndex": 4, "sortable": true, "header": "Team", "editable": true, "tooltip": "If not empty, then this template is reserved to members of this team.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "team", "editor": team936 }, { "colIndex": 5, "sortable": false, "header": "text", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "editor": text937, "dataIndex": "text" } ];
    Lino.ui.TextFieldTemplates.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.ui.TextFieldTemplates.insertPanel = Ext.extend(Lino.ui.TextFieldTemplates.InsertFormPanel,{
  empty_title: "New Text Field Templates",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/ui/TextFieldTemplates",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.TextFieldTemplates.detail;
    this.ls_insert_handler = Lino.ui.TextFieldTemplates.insert;
    Lino.ui.TextFieldTemplates.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.ui.TextFieldTemplates.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.ui.TextFieldTemplates.insertPanel(p);
});

Lino.ui.TextFieldTemplates.detailPanel = Ext.extend(Lino.ui.TextFieldTemplates.DetailFormPanel,{
  empty_title: "Detail Text Field Templates",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/ui/TextFieldTemplates",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.TextFieldTemplates.detail;
    this.ls_insert_handler = Lino.ui.TextFieldTemplates.insert;
    Lino.ui.TextFieldTemplates.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.ui.TextFieldTemplates.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ui.TextFieldTemplates.detailPanel(p);
});
Lino.ui.TextFieldTemplates.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ui.TextFieldTemplates.GridPanel(p);
});

// js_render_GridPanel_class users.Users
Lino.users.Users.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/Users",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Users",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "first_name" }, { "name": "last_name" }, { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "password" }, { "name": "email" }, { "name": "remarks" }, { "name": "language" }, 'languageHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 11,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 14,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    var ww = this.containing_window;
    var username939 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile940 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.lino.UserProfiles });
    var first_name941 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var last_name942 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var id943 = new Ext.form.NumberField({ "selectOnFocus": true });
    var created944 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified945 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var password946 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 128 });
    var email947 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var remarks948 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var language949 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ] });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Username", "editable": true, "tooltip": "\n        Required. Must be unique. \n        ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "username", "editor": username939 }, { "colIndex": 1, "sortable": true, "header": "User Profile", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "profile", "editor": profile940 }, { "colIndex": 2, "sortable": true, "header": "First name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "first_name", "editor": first_name941 }, { "colIndex": 3, "sortable": true, "header": "Last name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "last_name", "editor": last_name942 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id943, "width": Lino.chars2width(5), "dataIndex": "id" }), { "width": Lino.chars2width(16), "colIndex": 5, "sortable": true, "dataIndex": "created", "header": "Created", "editable": false }, { "width": Lino.chars2width(16), "colIndex": 6, "sortable": true, "dataIndex": "modified", "header": "Modified", "editable": false }, { "colIndex": 7, "sortable": true, "header": "Password", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "password", "hidden": true, "editor": password946 }, { "colIndex": 8, "sortable": true, "header": "e-mail address", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "email", "editor": email947 }, { "colIndex": 9, "sortable": false, "header": "Remarks", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": true, "editor": remarks948, "dataIndex": "remarks" }, { "colIndex": 10, "sortable": true, "header": "Language", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "editor": language949 } ];
    Lino.users.Users.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.users.Users.insertPanel = Ext.extend(Lino.users.Users.InsertFormPanel,{
  empty_title: "New Users",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/users/Users",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.Users.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Users.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.Users.insertPanel(p);
});

Lino.users.Users.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Detail Users",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/users/Users",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.Users.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Users.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Users.detailPanel(p);
});
Lino.users.Users.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Users.GridPanel(p);
});

// js_render_GridPanel_class users.MySettings
Lino.users.MySettings.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/MySettings",
  ls_bbar_actions : [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false } ],
  title : "Users",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "first_name" }, { "name": "last_name" }, { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "password" }, { "name": "email" }, { "name": "remarks" }, { "name": "language" }, 'languageHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 11,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 14,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    var ww = this.containing_window;
    var username951 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile952 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.lino.UserProfiles });
    var first_name953 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var last_name954 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var id955 = new Ext.form.NumberField({ "selectOnFocus": true });
    var created956 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var modified957 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var password958 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 128 });
    var email959 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var remarks960 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var language961 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ] });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Username", "editable": true, "tooltip": "\n        Required. Must be unique. \n        ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "username", "editor": username951 }, { "colIndex": 1, "sortable": true, "header": "User Profile", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "profile", "editor": profile952 }, { "colIndex": 2, "sortable": true, "header": "First name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "first_name", "editor": first_name953 }, { "colIndex": 3, "sortable": true, "header": "Last name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "last_name", "editor": last_name954 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id955, "width": Lino.chars2width(5), "dataIndex": "id" }), { "width": Lino.chars2width(16), "colIndex": 5, "sortable": true, "dataIndex": "created", "header": "Created", "editable": false }, { "width": Lino.chars2width(16), "colIndex": 6, "sortable": true, "dataIndex": "modified", "header": "Modified", "editable": false }, { "colIndex": 7, "sortable": true, "header": "Password", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "password", "hidden": true, "editor": password958 }, { "colIndex": 8, "sortable": true, "header": "e-mail address", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "email", "editor": email959 }, { "colIndex": 9, "sortable": false, "header": "Remarks", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "hidden": true, "editor": remarks960, "dataIndex": "remarks" }, { "colIndex": 10, "sortable": true, "header": "Language", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "editor": language961 } ];
    Lino.users.MySettings.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Users",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});

Lino.users.MySettings.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Users",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false } ],
  ls_url: "/users/MySettings",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.MySettings.detail;
    this.ls_insert_handler = Lino.users.Users.insert;
    Lino.users.MySettings.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MySettings.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.MySettings.detailPanel(p);
});

// js_render_GridPanel_class users.UsersOverview
Lino.users.UsersOverview.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/UsersOverview",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Users",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" }, 'profileHidden', { "name": "language" }, 'languageHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 11,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.UsersOverview.detail;
    this.ls_insert_handler = Lino.users.UsersOverview.insert;
    var ww = this.containing_window;
    var username963 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile964 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.lino.UserProfiles });
    var language965 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ] });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Username", "editable": true, "tooltip": "\n        Required. Must be unique. \n        ", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "username", "editor": username963 }, { "colIndex": 1, "sortable": true, "header": "User Profile", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(22), "dataIndex": "profile", "editor": profile964 }, { "colIndex": 2, "sortable": true, "header": "Language", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "editor": language965 } ];
    Lino.users.UsersOverview.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.users.UsersOverview.insertPanel = Ext.extend(Lino.users.Users.InsertFormPanel,{
  empty_title: "New Users",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/users/UsersOverview",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.UsersOverview.detail;
    this.ls_insert_handler = Lino.users.UsersOverview.insert;
    Lino.users.UsersOverview.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.users.UsersOverview.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.users.UsersOverview.insertPanel(p);
});

Lino.users.UsersOverview.detailPanel = Ext.extend(Lino.users.Users.DetailFormPanel,{
  empty_title: "Detail Users",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/users/UsersOverview",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.UsersOverview.detail;
    this.ls_insert_handler = Lino.users.UsersOverview.insert;
    Lino.users.UsersOverview.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.users.UsersOverview.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.UsersOverview.detailPanel(p);
});
Lino.users.UsersOverview.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.UsersOverview.GridPanel(p);
});

// js_render_GridPanel_class users.Teams
Lino.users.Teams.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/Teams",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Teams",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 13,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    var ww = this.containing_window;
    var id967 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name968 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de969 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr970 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id967, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "editor": name968 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_de", "editor": name_de969 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "editor": name_fr970 } ];
    Lino.users.Teams.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Teams.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Teams.GridPanel(p);
});

// js_render_GridPanel_class users.Memberships
Lino.users.Memberships.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/Memberships",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Memberships",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "team" }, 'teamHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 10,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var id972 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user973 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Memberships/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var team974 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Memberships/team", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Team..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id972, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user973, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "Team", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "team", "editor": team974 } ];
    Lino.users.Memberships.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Memberships.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Memberships.GridPanel(p);
});

// js_render_GridPanel_class users.Authorities
Lino.users.Authorities.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/Authorities",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Authorities",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "authorized" }, 'authorizedHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 12,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var id976 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user977 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Authorities/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var authorized978 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Authorities/authorized", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a User..." });
    this.before_row_edit = function(record) {
      authorized978.setContextValue('user',record ? record.data['userHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      user977.on('change',Lino.chooser_handler(authorized978,'user'));
      Lino.users.Authorities.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id976, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user977, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "User", "editable": true, "tooltip": "The user who gets authority to act in your name.", "filter": { "type": "string" }, "width": Lino.chars2width(15), "renderer": Lino.fk_renderer('authorizedHidden','Lino.users.Users.detail'), "editor": authorized978, "dataIndex": "authorized" } ];
    Lino.users.Authorities.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Authorities.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.Authorities.GridPanel(p);
});

// js_render_GridPanel_class countries.Languages
Lino.countries.Languages.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/countries/Languages",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Languages",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "id" }, { "name": "iso2" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 15,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var name980 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de981 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr982 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id983 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "allowBlank": false, "maxLength": 3 });
    var iso2984 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(2), "maxLength": 2 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "editor": name980 }, { "colIndex": 1, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_de", "editor": name_de981 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "editor": name_fr982 }, { "colIndex": 3, "sortable": true, "header": "id", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(4), "dataIndex": "id", "editor": id983 }, { "colIndex": 4, "sortable": true, "header": "iso2", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(4), "dataIndex": "iso2", "editor": iso2984 } ];
    Lino.countries.Languages.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Languages.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Languages.GridPanel(p);
});

// js_render_GridPanel_class countries.Countries
Lino.countries.Countries.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/countries/Countries",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Countries",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "isocode" }, { "name": "short_code" }, { "name": "iso3" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 14,
  ls_id_property : "isocode",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    var ww = this.containing_window;
    var name986 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de987 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr988 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var isocode989 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "allowBlank": false, "maxLength": 4 });
    var short_code990 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(4), "maxLength": 4 });
    var iso3991 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(3), "maxLength": 3 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "editor": name986 }, { "colIndex": 1, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_de", "editor": name_de987 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "editor": name_fr988 }, { "colIndex": 3, "sortable": true, "header": "ISO code", "editable": true, "tooltip": "        The two-letter code for this country as defined by ISO 3166-1. \n        For countries that no longer exist it may be a 4-letter code.", "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "isocode", "editor": isocode989 }, { "colIndex": 4, "sortable": true, "header": "Short code", "editable": true, "tooltip": "A short abbreviation for regional usage. Obsolete.", "filter": { "type": "string" }, "width": Lino.chars2width(5), "dataIndex": "short_code", "editor": short_code990 }, { "colIndex": 5, "sortable": true, "header": "ISO-3 code", "editable": true, "tooltip": "The three-letter code for this country as defined by ISO 3166-1.", "filter": { "type": "string" }, "width": Lino.chars2width(4), "dataIndex": "iso3", "editor": iso3991 } ];
    Lino.countries.Countries.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Countries.insertPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "New Countries",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/countries/Countries",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    Lino.countries.Countries.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Countries.insertPanel(p);
});

Lino.countries.Countries.detailPanel = Ext.extend(Lino.countries.Countries.DetailFormPanel,{
  empty_title: "Detail Countries",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/countries/Countries",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail;
    this.ls_insert_handler = Lino.countries.Countries.insert;
    Lino.countries.Countries.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.detailPanel(p);
});
Lino.countries.Countries.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Countries.GridPanel(p);
});

// js_render_GridPanel_class countries.Cities
Lino.countries.Cities.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/countries/Cities",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Places",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "country" }, 'countryHidden', { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "type" }, 'typeHidden', { "name": "zip_code" }, { "type": "int", "name": "id" }, { "name": "parent" }, 'parentHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 8,
  ls_grid_configs : [  ],
  content_type : 16,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 12,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Cities.detail;
    this.ls_insert_handler = Lino.countries.Cities.insert;
    var ww = this.containing_window;
    var country993 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/country", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Country..." });
    var name994 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de995 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr996 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type997 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/type", "method": "GET" }) }) });
    var zip_code998 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "maxLength": 8 });
    var id999 = new Ext.form.NumberField({ "selectOnFocus": true });
    var parent1000 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/parent", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    this.before_row_edit = function(record) {
      type997.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country993.on('change',Lino.chooser_handler(type997,'country'));
      Lino.countries.Cities.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Country", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country993, "dataIndex": "country" }, { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "editor": name994 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_de", "editor": name_de995 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "editor": name_fr996 }, { "colIndex": 4, "sortable": true, "header": "Place Type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "type", "editor": type997 }, { "colIndex": 5, "sortable": true, "header": "zip code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(9), "dataIndex": "zip_code", "editor": zip_code998 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id999, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 7, "sortable": true, "header": "Part of", "editable": true, "tooltip": "The superordinate geographic place of which this place is a part.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('parentHidden','Lino.countries.Cities.detail'), "editor": parent1000, "dataIndex": "parent" } ];
    Lino.countries.Cities.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Cities.insertPanel = Ext.extend(Lino.countries.Cities.DetailFormPanel,{
  empty_title: "New Places",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/countries/Cities",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Cities.detail;
    this.ls_insert_handler = Lino.countries.Cities.insert;
    Lino.countries.Cities.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Cities.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.Cities.insertPanel(p);
});

Lino.countries.Cities.detailPanel = Ext.extend(Lino.countries.Cities.DetailFormPanel,{
  empty_title: "Detail Places",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/countries/Cities",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Cities.detail;
    this.ls_insert_handler = Lino.countries.Cities.insert;
    Lino.countries.Cities.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Cities.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Cities.detailPanel(p);
});
Lino.countries.Cities.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.Cities.GridPanel(p);
});

// js_render_GridPanel_class partners.OrganisationTypes
Lino.partners.OrganisationTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/partners/OrganisationTypes",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Organisation types",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "type": "int", "name": "id" }, { "name": "abbr" }, { "name": "abbr_de" }, { "name": "abbr_fr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 17,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var name1002 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1003 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1004 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1005 = new Ext.form.NumberField({ "selectOnFocus": true });
    var abbr1006 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var abbr_de1007 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var abbr_fr1008 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "editor": name1002 }, { "colIndex": 1, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_de", "editor": name_de1003 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "editor": name_fr1004 }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1005, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Abbreviation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "abbr", "editor": abbr1006 }, { "colIndex": 5, "sortable": true, "header": "Abbreviation (de)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "abbr_de", "editor": abbr_de1007 }, { "colIndex": 6, "sortable": true, "header": "Abbreviation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "abbr_fr", "editor": abbr_fr1008 } ];
    Lino.partners.OrganisationTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.partners.OrganisationTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.partners.OrganisationTypes.GridPanel(p);
});

// js_render_GridPanel_class partners.Partners
Lino.partners.Partners.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/partners/Partners",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Partners",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "payment_term" }, 'payment_termHidden', { "name": "vat_regime" }, 'vat_regimeHidden', { "type": "boolean", "name": "item_vat" }, { "name": "imode" }, 'imodeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 22,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 10,
  initComponent : function() {
    this.ls_detail_handler = Lino.partners.Partners.detail;
    this.ls_insert_handler = Lino.partners.Partners.insert;
    var ww = this.containing_window;
    var id1010 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1011 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var payment_term1012 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/Partners/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Payment Term..." });
    var vat_regime1013 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.vat.VatRegimes });
    var item_vat1014 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var imode1015 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/Partners/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Invoicing Mode..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1010, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "editor": name1011 }, { "colIndex": 2, "sortable": true, "header": "Payment Term", "editable": true, "tooltip": "The default payment term for sales invoices to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "payment_term", "editor": payment_term1012 }, { "colIndex": 3, "sortable": true, "header": "VAT Regime", "editable": true, "tooltip": "The default VAT regime for sales to this customer.", "filter": { "type": "string" }, "width": Lino.chars2width(18), "dataIndex": "vat_regime", "editor": vat_regime1013 }, { "colIndex": 4, "sortable": false, "xtype": "checkcolumn", "header": "item vat", "editable": true, "tooltip": "The default item VAT setting for sales to this customer.", "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "item_vat" }, { "colIndex": 5, "sortable": true, "header": "Invoicing Mode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "imode", "editor": imode1015 } ];
    Lino.partners.Partners.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.partners.Partners.insertPanel = Ext.extend(Lino.partners.Partners.InsertFormPanel,{
  empty_title: "New Partners",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/partners/Partners",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.partners.Partners.detail;
    this.ls_insert_handler = Lino.partners.Partners.insert;
    Lino.partners.Partners.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.partners.Partners.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.partners.Partners.insertPanel(p);
});

Lino.partners.Partners.detailPanel = Ext.extend(Lino.partners.Partners.DetailFormPanel,{
  empty_title: "Detail Partners",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/partners/Partners",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.partners.Partners.detail;
    this.ls_insert_handler = Lino.partners.Partners.insert;
    Lino.partners.Partners.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.partners.Partners.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.partners.Partners.detailPanel(p);
});
Lino.partners.Partners.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.partners.Partners.GridPanel(p);
});

// js_render_GridPanel_class partners.Persons
Lino.partners.Persons.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/partners/Persons",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "merge_row", "menu_item_text": "Merge", "tooltip": "Merge this object into another object of same class.", "panel_btn_handler": Lino.param_action_handler(Lino.partners.Persons.merge_row), "text": "Merge", "overflowText": "Merge", "auto_save": true } ],
  title : "Persons",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name_column" }, { "name": "address_column" }, { "name": "email" }, { "name": "phone" }, { "name": "gsm" }, { "type": "int", "name": "id" }, { "name": "language" }, 'languageHidden', { "name": "first_name" }, { "name": "last_name" }, { "name": "gender" }, 'genderHidden', { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "url" }, { "name": "fax" }, { "name": "remarks" }, { "name": "title" }, { "name": "partner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 19,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 31,
  initComponent : function() {
    this.ls_detail_handler = Lino.partners.Persons.detail;
    this.ls_insert_handler = Lino.partners.Persons.insert;
    var ww = this.containing_window;
    var name_column_disp15 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var address_column_disp16 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var email17 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone18 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm19 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id20 = new Ext.form.NumberField({ "selectOnFocus": true });
    var language21 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "allowBlank": false, "value": "en" });
    var first_name22 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var last_name23 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gender24 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.lino.Genders });
    var country25 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/Persons/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Country..." });
    var city26 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/Persons/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var region27 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/Persons/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var zip_code28 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr129 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix30 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street31 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no32 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box33 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr234 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var url35 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var fax36 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks37 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var title38 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var partner39 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/Persons/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    this.before_row_edit = function(record) {
      city26.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city26.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region27.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country25.on('change',Lino.chooser_handler(city26,'country'));
      region27.on('change',Lino.chooser_handler(city26,'region'));
      country25.on('change',Lino.chooser_handler(region27,'country'));
      Lino.partners.Persons.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": Lino.chars2width(20), "colIndex": 0, "sortable": false, "dataIndex": "name_column", "header": "Name", "editable": false }, { "width": Lino.chars2width(30), "colIndex": 1, "sortable": false, "dataIndex": "address_column", "header": "Address", "editable": false }, { "colIndex": 2, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "email", "editor": email17 }, { "colIndex": 3, "sortable": true, "header": "Phone", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "phone", "editor": phone18 }, { "colIndex": 4, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "gsm", "editor": gsm19 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id20, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Language", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "language", "editor": language21 }, { "colIndex": 7, "sortable": true, "header": "First name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "first_name", "editor": first_name22 }, { "colIndex": 8, "sortable": true, "header": "Last name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "last_name", "editor": last_name23 }, { "colIndex": 9, "sortable": true, "header": "Gender", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(9), "dataIndex": "gender", "editor": gender24 }, { "colIndex": 10, "sortable": true, "header": "Country", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country25, "dataIndex": "country" }, { "colIndex": 11, "sortable": true, "header": "Place", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail'), "editor": city26, "dataIndex": "city" }, { "colIndex": 12, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail'), "hidden": true, "editor": region27, "dataIndex": "region" }, { "colIndex": 13, "sortable": true, "header": "Zip code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "zip_code", "editor": zip_code28 }, { "colIndex": 14, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "addr1", "editor": addr129 }, { "colIndex": 15, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "street_prefix", "editor": street_prefix30 }, { "colIndex": 16, "sortable": true, "header": "Street", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "street", "editor": street31 }, { "colIndex": 17, "sortable": true, "header": "No.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "street_no", "editor": street_no32 }, { "colIndex": 18, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "street_box", "editor": street_box33 }, { "colIndex": 19, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "addr2", "editor": addr234 }, { "colIndex": 20, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "url", "editor": url35 }, { "colIndex": 21, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "fax", "editor": fax36 }, { "colIndex": 22, "sortable": false, "header": "Remarks", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "editor": remarks37, "dataIndex": "remarks" }, { "colIndex": 23, "sortable": true, "header": "Title", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "title", "editor": title38 }, { "colIndex": 24, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('partnerHidden','Lino.partners.Partners.detail'), "editor": partner39, "dataIndex": "partner" } ];
    Lino.partners.Persons.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.partners.Persons.insertPanel = Ext.extend(Lino.partners.Persons.InsertFormPanel,{
  empty_title: "New Persons",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/partners/Persons",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.partners.Persons.detail;
    this.ls_insert_handler = Lino.partners.Persons.insert;
    Lino.partners.Persons.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.partners.Persons.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.partners.Persons.insertPanel(p);
});

Lino.partners.Persons.detailPanel = Ext.extend(Lino.partners.Persons.DetailFormPanel,{
  empty_title: "Detail Persons",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "merge_row", "menu_item_text": "Merge", "tooltip": "Merge this object into another object of same class.", "panel_btn_handler": Lino.param_action_handler(Lino.partners.Persons.merge_row), "text": "Merge", "overflowText": "Merge", "auto_save": true } ],
  ls_url: "/partners/Persons",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.partners.Persons.detail;
    this.ls_insert_handler = Lino.partners.Persons.insert;
    Lino.partners.Persons.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.partners.Persons.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.partners.Persons.detailPanel(p);
});
Lino.partners.Persons.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.partners.Persons.GridPanel(p);
});

// js_render_GridPanel_class partners.Organisations
Lino.partners.Organisations.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/partners/Organisations",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "merge_row", "menu_item_text": "Merge", "tooltip": "Merge this object into another object of same class.", "panel_btn_handler": Lino.param_action_handler(Lino.partners.Organisations.merge_row), "text": "Merge", "overflowText": "Merge", "auto_save": true } ],
  title : "Organisations",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "country" }, 'countryHidden', { "name": "city" }, 'cityHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "language" }, 'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "name": "partner" }, { "name": "prefix" }, { "name": "vat_id" }, { "name": "type" }, 'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 27,
  ls_grid_configs : [  ],
  content_type : 18,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 29,
  initComponent : function() {
    this.ls_detail_handler = Lino.partners.Organisations.detail;
    this.ls_insert_handler = Lino.partners.Organisations.insert;
    var ww = this.containing_window;
    var name1017 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email1018 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var country1019 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/Organisations/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Country..." });
    var city1020 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/Organisations/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var region1021 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/Organisations/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var zip_code1022 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr11023 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix1024 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street1025 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no1026 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box1027 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr21028 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language1029 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "allowBlank": false, "value": "en" });
    var url1030 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone1031 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm1032 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax1033 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks1034 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var partner1035 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/Organisations/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var prefix1036 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var vat_id1037 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type1038 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/Organisations/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Organisation type..." });
    var id1039 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      city1020.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      city1020.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      region1021.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country1019.on('change',Lino.chooser_handler(city1020,'country'));
      region1021.on('change',Lino.chooser_handler(city1020,'region'));
      country1019.on('change',Lino.chooser_handler(region1021,'country'));
      Lino.partners.Organisations.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "editor": name1017 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "email", "editor": email1018 }, { "colIndex": 2, "sortable": true, "header": "Country", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country1019, "dataIndex": "country" }, { "colIndex": 3, "sortable": true, "header": "Place", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail'), "editor": city1020, "dataIndex": "city" }, { "colIndex": 4, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail'), "hidden": true, "editor": region1021, "dataIndex": "region" }, { "colIndex": 5, "sortable": true, "header": "Zip code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "zip_code", "editor": zip_code1022 }, { "colIndex": 6, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "addr1", "editor": addr11023 }, { "colIndex": 7, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "street_prefix", "editor": street_prefix1024 }, { "colIndex": 8, "sortable": true, "header": "Street", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "street", "editor": street1025 }, { "colIndex": 9, "sortable": true, "header": "No.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "street_no", "editor": street_no1026 }, { "colIndex": 10, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "street_box", "editor": street_box1027 }, { "colIndex": 11, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "addr2", "editor": addr21028 }, { "colIndex": 12, "sortable": true, "header": "Language", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "editor": language1029 }, { "colIndex": 13, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "url", "editor": url1030 }, { "colIndex": 14, "sortable": true, "header": "Phone", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "phone", "editor": phone1031 }, { "colIndex": 15, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "gsm", "editor": gsm1032 }, { "colIndex": 16, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "fax", "editor": fax1033 }, { "colIndex": 17, "sortable": false, "header": "Remarks", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "editor": remarks1034, "dataIndex": "remarks" }, { "colIndex": 18, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('partnerHidden','Lino.partners.Partners.detail'), "editor": partner1035, "dataIndex": "partner" }, { "colIndex": 19, "sortable": true, "header": "prefix", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "prefix", "editor": prefix1036 }, { "colIndex": 20, "sortable": true, "header": "VAT id", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "vat_id", "editor": vat_id1037 }, { "colIndex": 21, "sortable": true, "header": "Organisation type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "type", "editor": type1038 }, new Lino.NullNumberColumn({ "colIndex": 22, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1039, "width": Lino.chars2width(5), "dataIndex": "id" }) ];
    Lino.partners.Organisations.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.partners.Organisations.insertPanel = Ext.extend(Lino.partners.Organisations.InsertFormPanel,{
  empty_title: "New Organisations",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/partners/Organisations",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.partners.Organisations.detail;
    this.ls_insert_handler = Lino.partners.Organisations.insert;
    Lino.partners.Organisations.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.partners.Organisations.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.partners.Organisations.insertPanel(p);
});

Lino.partners.Organisations.detailPanel = Ext.extend(Lino.partners.Organisations.DetailFormPanel,{
  empty_title: "Detail Organisations",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "merge_row", "menu_item_text": "Merge", "tooltip": "Merge this object into another object of same class.", "panel_btn_handler": Lino.param_action_handler(Lino.partners.Organisations.merge_row), "text": "Merge", "overflowText": "Merge", "auto_save": true } ],
  ls_url: "/partners/Organisations",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.partners.Organisations.detail;
    this.ls_insert_handler = Lino.partners.Organisations.insert;
    Lino.partners.Organisations.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.partners.Organisations.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.partners.Organisations.detailPanel(p);
});
Lino.partners.Organisations.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.partners.Organisations.GridPanel(p);
});

// js_render_GridPanel_class partners.Roles
Lino.partners.Roles.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/partners/Roles",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Roles",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 21,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    var ww = this.containing_window;
    var id1041 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1042 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1043 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1044 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1041, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "editor": name1042 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_de", "editor": name_de1043 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "editor": name_fr1044 } ];
    Lino.partners.Roles.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.partners.Roles.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.partners.Roles.GridPanel(p);
});

// js_render_GridPanel_class partners.Contacts
Lino.partners.Contacts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/partners/Contacts",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Contact Persons",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "role" }, 'roleHidden', { "name": "person" }, 'personHidden', { "name": "organisation" }, 'organisationHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 20,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var id1046 = new Ext.form.NumberField({ "selectOnFocus": true });
    var role1047 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/Contacts/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Contact Person..." });
    var person1048 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/Contacts/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Person..." });
    var organisation1049 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/Contacts/organisation", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Organisation..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1046, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Contact Person", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "role", "editor": role1047 }, { "colIndex": 2, "sortable": true, "header": "Person", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('personHidden','Lino.partners.Persons.detail'), "editor": person1048, "dataIndex": "person" }, { "colIndex": 3, "sortable": true, "header": "Organisation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('organisationHidden','Lino.partners.Organisations.detail'), "editor": organisation1049, "dataIndex": "organisation" } ];
    Lino.partners.Contacts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.partners.Contacts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.partners.Contacts.GridPanel(p);
});

// js_render_GridPanel_class products.ProductCats
Lino.products.ProductCats.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/products/ProductCats",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Product Categories",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "description" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 23,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    this.ls_detail_handler = Lino.products.ProductCats.detail;
    this.ls_insert_handler = Lino.products.ProductCats.insert;
    var ww = this.containing_window;
    var id1051 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1052 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1053 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1054 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var description1055 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1051, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "editor": name1052 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_de", "editor": name_de1053 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "editor": name_fr1054 }, { "colIndex": 4, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "editor": description1055, "dataIndex": "description" } ];
    Lino.products.ProductCats.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.products.ProductCats.insertPanel = Ext.extend(Lino.products.ProductCats.DetailFormPanel,{
  empty_title: "New Product Categories",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/products/ProductCats",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.products.ProductCats.detail;
    this.ls_insert_handler = Lino.products.ProductCats.insert;
    Lino.products.ProductCats.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.products.ProductCats.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.products.ProductCats.insertPanel(p);
});

Lino.products.ProductCats.detailPanel = Ext.extend(Lino.products.ProductCats.DetailFormPanel,{
  empty_title: "Detail Product Categories",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/products/ProductCats",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.products.ProductCats.detail;
    this.ls_insert_handler = Lino.products.ProductCats.insert;
    Lino.products.ProductCats.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.products.ProductCats.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.products.ProductCats.detailPanel(p);
});
Lino.products.ProductCats.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.products.ProductCats.GridPanel(p);
});

// js_render_GridPanel_class products.Products
Lino.products.Products.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/products/Products",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Products",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "cat" }, 'catHidden', { "type": "boolean", "name": "vatExempt" }, { "name": "price" }, { "name": "description" }, { "name": "sales_account" }, 'sales_accountHidden', { "name": "purchases_account" }, 'purchases_accountHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 24,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 14,
  initComponent : function() {
    this.ls_detail_handler = Lino.products.Products.detail;
    this.ls_insert_handler = Lino.products.Products.insert;
    var ww = this.containing_window;
    var id1057 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1058 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1059 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1060 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var cat1061 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/products/Products/cat", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Product Category..." });
    var vatExempt1062 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var price1063 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var description1064 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var sales_account1065 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/products/Products/sales_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var purchases_account1066 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/products/Products/purchases_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1057, "width": Lino.chars2width(3), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "editor": name1058 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_de", "editor": name_de1059 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "editor": name_fr1060 }, { "colIndex": 4, "sortable": true, "header": "Category", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('catHidden','Lino.products.ProductCats.detail'), "editor": cat1061, "dataIndex": "cat" }, { "colIndex": 5, "sortable": false, "xtype": "checkcolumn", "header": "VAT exempt", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "vatExempt" }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "header": "Price", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(6), "dataIndex": "price", "editor": price1063 }), { "colIndex": 7, "sortable": false, "header": "Long description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "editor": description1064, "dataIndex": "description" }, { "colIndex": 8, "sortable": true, "header": "Sales account", "editable": true, "tooltip": "The account to move when this product is used in a sales invoice.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "sales_account", "editor": sales_account1065 }, { "colIndex": 9, "sortable": true, "header": "Purchases account", "editable": true, "tooltip": "The account to move when this product is used in a purchases invoice.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "purchases_account", "editor": purchases_account1066 } ];
    Lino.products.Products.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.products.Products.insertPanel = Ext.extend(Lino.products.Products.DetailFormPanel,{
  empty_title: "New Products",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/products/Products",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.products.Products.detail;
    this.ls_insert_handler = Lino.products.Products.insert;
    Lino.products.Products.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.products.Products.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.products.Products.insertPanel(p);
});

Lino.products.Products.detailPanel = Ext.extend(Lino.products.Products.DetailFormPanel,{
  empty_title: "Detail Products",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/products/Products",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.products.Products.detail;
    this.ls_insert_handler = Lino.products.Products.insert;
    Lino.products.Products.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.products.Products.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.products.Products.detailPanel(p);
});
Lino.products.Products.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.products.Products.GridPanel(p);
});

// js_render_GridPanel_class accounts.Charts
Lino.accounts.Charts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/accounts/Charts",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Account Charts",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 27,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Charts.detail;
    this.ls_insert_handler = Lino.accounts.Charts.insert;
    var ww = this.containing_window;
    var id1068 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1069 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1070 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1071 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1068, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "editor": name1069 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_de", "editor": name_de1070 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "editor": name_fr1071 } ];
    Lino.accounts.Charts.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Charts.insertPanel = Ext.extend(Lino.accounts.Charts.DetailFormPanel,{
  empty_title: "New Account Charts",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/accounts/Charts",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Charts.detail;
    this.ls_insert_handler = Lino.accounts.Charts.insert;
    Lino.accounts.Charts.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Charts.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.accounts.Charts.insertPanel(p);
});

Lino.accounts.Charts.detailPanel = Ext.extend(Lino.accounts.Charts.DetailFormPanel,{
  empty_title: "Detail Account Charts",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/accounts/Charts",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Charts.detail;
    this.ls_insert_handler = Lino.accounts.Charts.insert;
    Lino.accounts.Charts.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Charts.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Charts.detailPanel(p);
});
Lino.accounts.Charts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Charts.GridPanel(p);
});

// js_render_GridPanel_class accounts.Groups
Lino.accounts.Groups.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/accounts/Groups",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Account Groups",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "chart" }, 'chartHidden', { "name": "ref" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "account_type" }, 'account_typeHidden', { "type": "int", "name": "id" }, { "name": "help_text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 8,
  ls_grid_configs : [  ],
  content_type : 26,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Groups.detail;
    this.ls_insert_handler = Lino.accounts.Groups.insert;
    var ww = this.containing_window;
    var chart1073 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Groups/chart", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account Chart..." });
    var ref1074 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var name1075 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1076 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1077 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var account_type1078 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.accounts.AccountTypes });
    var id1079 = new Ext.form.NumberField({ "selectOnFocus": true });
    var help_text1080 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Introduction" });
    this.before_row_edit = function(record) {
      help_text1080.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Account Chart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('chartHidden','Lino.accounts.Charts.detail'), "editor": chart1073, "dataIndex": "chart" }, { "colIndex": 1, "sortable": true, "header": "ref", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "ref", "editor": ref1074 }, { "colIndex": 2, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "editor": name1075 }, { "colIndex": 3, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_de", "editor": name_de1076 }, { "colIndex": 4, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "editor": name_fr1077 }, { "colIndex": 5, "sortable": true, "header": "Account Type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "account_type", "editor": account_type1078 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1079, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 7, "sortable": false, "header": "help_text", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "editor": help_text1080, "dataIndex": "help_text" } ];
    Lino.accounts.Groups.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.Groups.insertPanel = Ext.extend(Lino.accounts.Groups.DetailFormPanel,{
  empty_title: "New Account Groups",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/accounts/Groups",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Groups.detail;
    this.ls_insert_handler = Lino.accounts.Groups.insert;
    Lino.accounts.Groups.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Groups.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.accounts.Groups.insertPanel(p);
});

Lino.accounts.Groups.detailPanel = Ext.extend(Lino.accounts.Groups.DetailFormPanel,{
  empty_title: "Detail Account Groups",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/accounts/Groups",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.Groups.detail;
    this.ls_insert_handler = Lino.accounts.Groups.insert;
    Lino.accounts.Groups.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Groups.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Groups.detailPanel(p);
});
Lino.accounts.Groups.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Groups.GridPanel(p);
});

// js_render_GridPanel_class accounts.Accounts
Lino.accounts.Accounts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/accounts/Accounts",
  ls_bbar_actions : [ { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Accounts",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "ref" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "group" }, 'groupHidden', { "type": "int", "name": "id" }, { "type": "int", "name": "seqno" }, { "name": "chart" }, 'chartHidden', { "name": "type" }, 'typeHidden', { "name": "help_text" }, { "type": "boolean", "name": "sales_allowed" }, { "type": "boolean", "name": "purchases_allowed" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 25,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 16,
  initComponent : function() {
    var ww = this.containing_window;
    var ref1082 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var name1083 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1084 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1085 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var group1086 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Accounts/group", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account Group..." });
    var id1087 = new Ext.form.NumberField({ "selectOnFocus": true });
    var seqno1088 = new Ext.form.NumberField({ "selectOnFocus": true });
    var chart1089 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/Accounts/chart", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account Chart..." });
    var type1090 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.accounts.AccountTypes });
    var help_text1091 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Introduction" });
    var sales_allowed1092 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var purchases_allowed1093 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
      help_text1091.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ref", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "ref", "editor": ref1082 }, { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "editor": name1083 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_de", "editor": name_de1084 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "editor": name_fr1085 }, { "colIndex": 4, "sortable": true, "header": "Account Group", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('groupHidden','Lino.accounts.Groups.detail'), "editor": group1086, "dataIndex": "group" }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1087, "width": Lino.chars2width(5), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "width": Lino.chars2width(5), "editor": seqno1088 }), { "colIndex": 7, "sortable": true, "header": "Account Chart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('chartHidden','Lino.accounts.Charts.detail'), "editor": chart1089, "dataIndex": "chart" }, { "colIndex": 8, "sortable": true, "header": "Account Type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "type", "editor": type1090 }, { "colIndex": 9, "sortable": false, "header": "help_text", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "editor": help_text1091, "dataIndex": "help_text" }, { "colIndex": 10, "sortable": false, "xtype": "checkcolumn", "header": "Sales", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "sales_allowed" }, { "colIndex": 11, "sortable": false, "xtype": "checkcolumn", "header": "Purchases", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "purchases_allowed" } ];
    Lino.accounts.Accounts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.Accounts.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.Accounts.GridPanel(p);
});

// js_render_GridPanel_class ledger.Journals
Lino.ledger.Journals.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/ledger/Journals",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Journals",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "seqno" }, { "type": "int", "name": "id" }, { "name": "trade_type" }, 'trade_typeHidden', { "name": "voucher_type" }, 'voucher_typeHidden', { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "type": "boolean", "name": "force_sequence" }, { "name": "ref" }, { "name": "chart" }, 'chartHidden', { "name": "account" }, 'accountHidden', { "name": "printed_name" }, { "name": "printed_name_de" }, { "name": "printed_name_fr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 1,
  ls_grid_configs : [  ],
  content_type : 28,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 19,
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Journals.detail;
    this.ls_insert_handler = Lino.ledger.Journals.insert;
    var ww = this.containing_window;
    var seqno1095 = new Ext.form.NumberField({ "selectOnFocus": true });
    var id1096 = new Ext.form.NumberField({ "selectOnFocus": true });
    var trade_type1097 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.vat.TradeTypes });
    var voucher_type1098 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.ledger.VoucherTypes });
    var name1099 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1100 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1101 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var force_sequence1102 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var ref1103 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var chart1104 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Journals/chart", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account Chart..." });
    var account1105 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Journals/account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var printed_name1106 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var printed_name_de1107 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    var printed_name_fr1108 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 100 });
    this.before_row_edit = function(record) {
      account1105.setContextValue('chart',record ? record.data['chartHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      chart1104.on('change',Lino.chooser_handler(account1105,'chart'));
      Lino.ledger.Journals.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "width": Lino.chars2width(5), "editor": seqno1095 }), new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1096, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 2, "sortable": true, "header": "Trade Type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "trade_type", "editor": trade_type1097 }, { "colIndex": 3, "sortable": true, "header": "voucher type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(64), "dataIndex": "voucher_type", "editor": voucher_type1098 }, { "colIndex": 4, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "editor": name1099 }, { "colIndex": 5, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_de", "editor": name_de1100 }, { "colIndex": 6, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "editor": name_fr1101 }, { "colIndex": 7, "sortable": false, "xtype": "checkcolumn", "header": "force sequence", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "force_sequence" }, { "colIndex": 8, "sortable": true, "header": "ref", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "ref", "editor": ref1103 }, { "colIndex": 9, "sortable": true, "header": "Account Chart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('chartHidden','Lino.accounts.Charts.detail'), "editor": chart1104, "dataIndex": "chart" }, { "colIndex": 10, "sortable": true, "header": "Account", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "account", "editor": account1105 }, { "colIndex": 11, "sortable": true, "header": "printed name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "printed_name", "editor": printed_name1106 }, { "colIndex": 12, "sortable": true, "header": "printed name (de)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "printed_name_de", "editor": printed_name_de1107 }, { "colIndex": 13, "sortable": true, "header": "printed name (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "printed_name_fr", "editor": printed_name_fr1108 } ];
    Lino.ledger.Journals.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Journals.insertPanel = Ext.extend(Lino.ledger.Journals.InsertFormPanel,{
  empty_title: "New Journals",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/ledger/Journals",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Journals.detail;
    this.ls_insert_handler = Lino.ledger.Journals.insert;
    Lino.ledger.Journals.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Journals.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.ledger.Journals.insertPanel(p);
});

Lino.ledger.Journals.detailPanel = Ext.extend(Lino.ledger.Journals.DetailFormPanel,{
  empty_title: "Detail Journals",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/ledger/Journals",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Journals.detail;
    this.ls_insert_handler = Lino.ledger.Journals.insert;
    Lino.ledger.Journals.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Journals.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.Journals.detailPanel(p);
});
Lino.ledger.Journals.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.Journals.GridPanel(p);
});

// js_render_GridPanel_class ledger.Vouchers
Lino.ledger.Vouchers.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "emptyText": "No data to display." },
  ls_url : "/ledger/Vouchers",
  ls_bbar_actions : [  ],
  title : "Vouchers",
  page_length : 20,
  stripeRows : true,
  disable_editing : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "type": "int", "name": "number" }, { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "journal" }, 'journalHidden', { "name": "year" }, 'yearHidden', { "name": "narration" }, { "name": "declared_in" }, 'declared_inHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 13,
  initComponent : function() {
    var ww = this.containing_window;
    var date1110 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var number1111 = new Ext.form.NumberField({ "selectOnFocus": true });
    var id1112 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user1113 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Vouchers/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var journal1114 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Vouchers/journal", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Journal..." });
    var year1115 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.ledger.FiscalYears });
    var narration1116 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var declared_in1117 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Vouchers/declared_in", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a VAT declaration..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "editor": date1110, "width": Lino.chars2width(8), "dataIndex": "date" }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(5), "editor": number1111 }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1112, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 3, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1113, "dataIndex": "user" }, { "colIndex": 4, "sortable": true, "header": "Journal", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('journalHidden','Lino.ledger.Journals.detail'), "editor": journal1114, "dataIndex": "journal" }, { "colIndex": 5, "sortable": true, "header": "Fiscal Year", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(7), "dataIndex": "year", "editor": year1115 }, { "colIndex": 6, "sortable": true, "header": "Narration", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "narration", "editor": narration1116 }, { "colIndex": 7, "sortable": true, "header": "VAT declaration", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('declared_inHidden','Lino.declarations.Declarations.detail'), "editor": declared_in1117, "dataIndex": "declared_in" } ];
    Lino.ledger.Vouchers.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Vouchers.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.Vouchers.GridPanel(p);
});

// js_render_GridPanel_class ledger.Movements
Lino.ledger.Movements.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "emptyText": "No data to display." },
  ls_url : "/ledger/Movements",
  ls_bbar_actions : [ { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true } ],
  title : "Movements",
  page_length : 20,
  stripeRows : true,
  disable_editing : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "voucher_link" }, { "name": "account" }, 'accountHidden', { "name": "debit" }, { "name": "credit" }, { "type": "int", "name": "id" }, { "type": "int", "name": "seqno" }, { "name": "voucher" }, 'voucherHidden', { "name": "partner" }, 'partnerHidden', { "name": "amount" }, { "type": "boolean", "name": "dc" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 32,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 14,
  initComponent : function() {
    var ww = this.containing_window;
    var voucher_link_disp1119 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var account1120 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Movements/account", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account..." });
    var debit1121 = new Ext.form.NumberField({ "disabled": true, "decimalPrecision": 2, "decimalSeparator": "," });
    var credit1122 = new Ext.form.NumberField({ "disabled": true, "decimalPrecision": 2, "decimalSeparator": "," });
    var id1123 = new Ext.form.NumberField({ "selectOnFocus": true });
    var seqno1124 = new Ext.form.NumberField({ "selectOnFocus": true });
    var voucher1125 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Movements/voucher", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Voucher..." });
    var partner1126 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Movements/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var amount1127 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalSeparator": ",", "decimalPrecision": 2, "allowBlank": false, "value": 0 });
    var dc1128 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(30), "colIndex": 0, "sortable": false, "dataIndex": "voucher_link", "header": "Voucher", "editable": false }, { "colIndex": 1, "sortable": true, "header": "Account", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "account", "editor": account1120 }, new Lino.NullNumberColumn({ "width": Lino.chars2width(12), "colIndex": 2, "sortable": false, "dataIndex": "debit", "header": "Debit", "editable": false }), new Lino.NullNumberColumn({ "width": Lino.chars2width(12), "colIndex": 3, "sortable": false, "dataIndex": "credit", "header": "Credit", "editable": false }), new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1123, "width": Lino.chars2width(5), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "width": Lino.chars2width(5), "editor": seqno1124 }), { "colIndex": 6, "sortable": true, "header": "Voucher", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "voucher", "editor": voucher1125 }, { "colIndex": 7, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('partnerHidden','Lino.partners.Partners.detail'), "editor": partner1126, "dataIndex": "partner" }, new Lino.NullNumberColumn({ "colIndex": 8, "sortable": true, "header": "amount", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "amount", "editor": amount1127 }), { "colIndex": 9, "sortable": false, "xtype": "checkcolumn", "header": "dc", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "dc" } ];
    Lino.ledger.Movements.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Movements.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.Movements.GridPanel(p);
});

// js_render_GridPanel_class ledger.Invoices
Lino.ledger.Invoices.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/ledger/Invoices",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Invoices",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "type": "int", "name": "id" }, { "type": "int", "name": "number" }, { "name": "partner" }, 'partnerHidden', { "name": "total_incl" }, { "name": "user" }, 'userHidden', { "name": "journal" }, 'journalHidden', { "name": "year" }, 'yearHidden', { "name": "narration" }, { "name": "declared_in" }, 'declared_inHidden', { "name": "total_base" }, { "name": "total_vat" }, { "type": "boolean", "name": "item_vat" }, { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "your_ref" }, { "type": "date", "name": "due_date", "dateFormat": "d.m.Y" }, { "name": "state" }, 'stateHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 1,
  ls_grid_configs : [  ],
  content_type : 30,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 25,
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Invoices.detail;
    this.ls_insert_handler = Lino.ledger.Invoices.insert;
    var ww = this.containing_window;
    var date1130 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var id1131 = new Ext.form.NumberField({ "selectOnFocus": true });
    var number1132 = new Ext.form.NumberField({ "selectOnFocus": true });
    var partner1133 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/partner", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Partner..." });
    var total_incl1134 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var user1135 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var journal1136 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/journal", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Journal..." });
    var year1137 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.ledger.FiscalYears });
    var narration1138 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var declared_in1139 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/Invoices/declared_in", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a VAT declaration..." });
    var total_base1140 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat1141 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var item_vat1142 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var vat_regime1143 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.vat.VatRegimes });
    var your_ref1144 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var due_date1145 = new Lino.DateField({ "selectOnFocus": true });
    var state1146 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.ledger.InvoiceStates });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "editor": date1130, "width": Lino.chars2width(8), "dataIndex": "date" }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1131, "width": Lino.chars2width(5), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(5), "editor": number1132 }), { "colIndex": 3, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('partnerHidden','Lino.partners.Partners.detail'), "editor": partner1133, "dataIndex": "partner" }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "header": "Total incl. VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_incl", "editor": total_incl1134 }), { "colIndex": 5, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1135, "dataIndex": "user" }, { "colIndex": 6, "sortable": true, "header": "Journal", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('journalHidden','Lino.ledger.Journals.detail'), "editor": journal1136, "dataIndex": "journal" }, { "colIndex": 7, "sortable": true, "header": "Fiscal Year", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(7), "dataIndex": "year", "editor": year1137 }, { "colIndex": 8, "sortable": true, "header": "Narration", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "narration", "editor": narration1138 }, { "colIndex": 9, "sortable": true, "header": "VAT declaration", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('declared_inHidden','Lino.declarations.Declarations.detail'), "editor": declared_in1139, "dataIndex": "declared_in" }, new Lino.NullNumberColumn({ "colIndex": 10, "sortable": true, "header": "Total excl. VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_base", "editor": total_base1140 }), new Lino.NullNumberColumn({ "colIndex": 11, "sortable": true, "header": "VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_vat", "editor": total_vat1141 }), { "colIndex": 12, "sortable": false, "xtype": "checkcolumn", "header": "Prices include VAT", "editable": true, "tooltip": "Whether prices includes VAT or not.", "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "item_vat" }, { "colIndex": 13, "sortable": true, "header": "VAT Regime", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(18), "dataIndex": "vat_regime", "editor": vat_regime1143 }, { "colIndex": 14, "sortable": true, "header": "Your reference", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "your_ref", "editor": your_ref1144 }, { "colIndex": 15, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Due date", "editor": due_date1145, "width": Lino.chars2width(8), "dataIndex": "due_date" }, { "colIndex": 16, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "state", "editor": state1146 } ];
    Lino.ledger.Invoices.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.Invoices.insertPanel = Ext.extend(Lino.ledger.Invoices.InsertFormPanel,{
  empty_title: "New Invoices",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/ledger/Invoices",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Invoices.detail;
    this.ls_insert_handler = Lino.ledger.Invoices.insert;
    Lino.ledger.Invoices.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Invoices.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.ledger.Invoices.insertPanel(p);
});

Lino.ledger.Invoices.detailPanel = Ext.extend(Lino.ledger.Invoices.DetailFormPanel,{
  empty_title: "Detail Invoices",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/ledger/Invoices",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.Invoices.detail;
    this.ls_insert_handler = Lino.ledger.Invoices.insert;
    Lino.ledger.Invoices.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.Invoices.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.Invoices.detailPanel(p);
});
Lino.ledger.Invoices.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.ledger.Invoices.ParamsPanel({});
  return new Lino.ledger.Invoices.GridPanel(p);
});
Lino.ledger.Invoices.deregister_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Invoices",pk,"deregister_action");
};
Lino.ledger.Invoices.register_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/Invoices",pk,"register_action");
};

// js_render_GridPanel_class declarations.Declarations
Lino.declarations.Declarations.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/declarations/Declarations",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "VAT declarations",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "year" }, 'yearHidden', { "name": "period" }, 'periodHidden', { "name": "workflow_buttons" }, { "name": "user" }, 'userHidden', { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "journal" }, 'journalHidden', { "type": "int", "name": "number" }, { "name": "narration" }, { "name": "declared_in" }, 'declared_inHidden', { "name": "sales_base" }, { "name": "sales_vat" }, { "name": "purchases_base" }, { "name": "purchases_vat" }, { "name": "purchases_investments" }, { "name": "purchases_ware" }, { "name": "purchases_services" }, { "name": "state" }, 'stateHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 23,
  ls_grid_configs : [  ],
  content_type : 33,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 25,
  initComponent : function() {
    this.ls_detail_handler = Lino.declarations.Declarations.detail;
    this.ls_insert_handler = Lino.declarations.Declarations.insert;
    var ww = this.containing_window;
    var year1148 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.ledger.FiscalYears });
    var period1149 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.declarations.DeclarationPeriods });
    var workflow_buttons_disp1150 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var user1151 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/declarations/Declarations/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var date1152 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var journal1153 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/declarations/Declarations/journal", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Journal..." });
    var number1154 = new Ext.form.NumberField({ "selectOnFocus": true });
    var narration1155 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var declared_in1156 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/declarations/Declarations/declared_in", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a VAT declaration..." });
    var sales_base1157 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": false, "decimalSeparator": "," });
    var sales_vat1158 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": false, "decimalSeparator": "," });
    var purchases_base1159 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": false, "decimalSeparator": "," });
    var purchases_vat1160 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": false, "decimalSeparator": "," });
    var purchases_investments1161 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": false, "decimalSeparator": "," });
    var purchases_ware1162 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": false, "decimalSeparator": "," });
    var purchases_services1163 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": false, "decimalSeparator": "," });
    var state1164 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.declarations.DeclarationStates });
    var id1165 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Fiscal Year", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(7), "dataIndex": "year", "editor": year1148 }, { "colIndex": 1, "sortable": true, "header": "VAT Period", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "period", "editor": period1149 }, { "width": Lino.chars2width(30), "colIndex": 2, "sortable": false, "dataIndex": "workflow_buttons", "header": "Workflow", "editable": false }, { "colIndex": 3, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1151, "dataIndex": "user" }, { "colIndex": 4, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "editor": date1152, "width": Lino.chars2width(8), "dataIndex": "date" }, { "colIndex": 5, "sortable": true, "header": "Journal", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('journalHidden','Lino.ledger.Journals.detail'), "editor": journal1153, "dataIndex": "journal" }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(5), "editor": number1154 }), { "colIndex": 7, "sortable": true, "header": "Narration", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "narration", "editor": narration1155 }, { "colIndex": 8, "sortable": true, "header": "VAT declaration", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('declared_inHidden','Lino.declarations.Declarations.detail'), "editor": declared_in1156, "dataIndex": "declared_in" }, new Lino.NullNumberColumn({ "colIndex": 9, "sortable": true, "header": "Sales base", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "sales_base", "editor": sales_base1157 }), new Lino.NullNumberColumn({ "colIndex": 10, "sortable": true, "header": "Sales VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "sales_vat", "editor": sales_vat1158 }), new Lino.NullNumberColumn({ "colIndex": 11, "sortable": true, "header": "Purchases base", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "purchases_base", "editor": purchases_base1159 }), new Lino.NullNumberColumn({ "colIndex": 12, "sortable": true, "header": "Purchases VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "purchases_vat", "editor": purchases_vat1160 }), new Lino.NullNumberColumn({ "colIndex": 13, "sortable": true, "header": "Investments", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "purchases_investments", "editor": purchases_investments1161 }), new Lino.NullNumberColumn({ "colIndex": 14, "sortable": true, "header": "Ware", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "purchases_ware", "editor": purchases_ware1162 }), new Lino.NullNumberColumn({ "colIndex": 15, "sortable": true, "header": "Services", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "purchases_services", "editor": purchases_services1163 }), { "colIndex": 16, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "state", "editor": state1164 }, new Lino.NullNumberColumn({ "colIndex": 17, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1165, "width": Lino.chars2width(5), "dataIndex": "id" }) ];
    Lino.declarations.Declarations.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.declarations.Declarations.insertPanel = Ext.extend(Lino.declarations.Declarations.InsertFormPanel,{
  empty_title: "New VAT declarations",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/declarations/Declarations",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.declarations.Declarations.detail;
    this.ls_insert_handler = Lino.declarations.Declarations.insert;
    Lino.declarations.Declarations.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.declarations.Declarations.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.declarations.Declarations.insertPanel(p);
});

Lino.declarations.Declarations.detailPanel = Ext.extend(Lino.declarations.Declarations.DetailFormPanel,{
  empty_title: "Detail VAT declarations",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/declarations/Declarations",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.declarations.Declarations.detail;
    this.ls_insert_handler = Lino.declarations.Declarations.insert;
    Lino.declarations.Declarations.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.declarations.Declarations.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.declarations.Declarations.detailPanel(p);
});
Lino.declarations.Declarations.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.declarations.Declarations.GridPanel(p);
});

// js_render_GridPanel_class sales.PaymentTerms
Lino.sales.PaymentTerms.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/sales/PaymentTerms",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Payment Terms",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "type": "int", "name": "days" }, { "type": "int", "name": "months" }, { "type": "boolean", "name": "end_of_month" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 39,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var id1167 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1168 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1169 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1170 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var days1171 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var months1172 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    var end_of_month1173 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1167, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "editor": name1168 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_de", "editor": name_de1169 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "editor": name_fr1170 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "days", "dataIndex": "days", "width": Lino.chars2width(5), "editor": days1171 }), new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "months", "dataIndex": "months", "width": Lino.chars2width(5), "editor": months1172 }), { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "end of month", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "end_of_month" } ];
    Lino.sales.PaymentTerms.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.PaymentTerms.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.PaymentTerms.GridPanel(p);
});

// js_render_GridPanel_class sales.InvoicingModes
Lino.sales.InvoicingModes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/sales/InvoicingModes",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Invoicing Modes",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "build_method" }, 'build_methodHidden', { "name": "template" }, { "name": "price" }, { "type": "int", "name": "advance_days" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 34,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 10,
  initComponent : function() {
    var ww = this.containing_window;
    var id1175 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1176 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1177 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1178 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var build_method1179 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template1180 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoicingModes/template", "method": "GET" }) }) });
    var price1181 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var advance_days1182 = new Ext.form.NumberField({ "selectOnFocus": true, "allowBlank": false, "value": 0 });
    this.before_row_edit = function(record) {
      template1180.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      build_method1179.on('change',Lino.chooser_handler(template1180,'build_method'));
      Lino.sales.InvoicingModes.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1175, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "editor": name1176 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_de", "editor": name_de1177 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "editor": name_fr1178 }, { "colIndex": 4, "sortable": true, "header": "Build method", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "build_method", "editor": build_method1179 }, { "colIndex": 5, "sortable": true, "header": "Template", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "template", "editor": template1180 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "header": "price", "editable": true, "tooltip": "Additional fee charged when using this invoicing mode.", "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "price", "editor": price1181 }), new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "format": "0", "editable": true, "tooltip": "\nHow many days in advance invoices should be posted so that the customer\nhas a chance to pay them in time.", "filter": { "type": "numeric" }, "header": "advance days", "dataIndex": "advance_days", "width": Lino.chars2width(5), "editor": advance_days1182 }) ];
    Lino.sales.InvoicingModes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.InvoicingModes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.InvoicingModes.GridPanel(p);
});

// js_render_GridPanel_class sales.ShippingModes
Lino.sales.ShippingModes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/sales/ShippingModes",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Shipping Modes",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "price" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 40,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var id1184 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1185 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1186 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1187 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var price1188 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1184, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "editor": name1185 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_de", "editor": name_de1186 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "editor": name_fr1187 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "header": "price", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "price", "editor": price1188 }) ];
    Lino.sales.ShippingModes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.ShippingModes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.ShippingModes.GridPanel(p);
});

// js_render_GridPanel_class sales.Invoices
Lino.sales.Invoices.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/sales/Invoices",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Clear cache", "auto_save": true } ],
  title : "Invoices",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "partner" }, 'partnerHidden', { "name": "total_incl" }, { "name": "user" }, 'userHidden', { "name": "journal" }, 'journalHidden', { "name": "year" }, 'yearHidden', { "type": "int", "name": "number" }, { "name": "narration" }, { "name": "declared_in" }, 'declared_inHidden', { "name": "build_time" }, { "name": "total_base" }, { "name": "total_vat" }, { "type": "boolean", "name": "item_vat" }, { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "language" }, 'languageHidden', { "name": "your_ref" }, { "name": "imode" }, 'imodeHidden', { "name": "shipping_mode" }, 'shipping_modeHidden', { "name": "payment_term" }, 'payment_termHidden', { "name": "subject" }, { "name": "intro" }, { "name": "discount" }, { "type": "date", "name": "due_date", "dateFormat": "d.m.Y" }, { "name": "state" }, 'stateHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 38,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 37,
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.Invoices.detail;
    this.ls_insert_handler = Lino.sales.Invoices.insert;
    var ww = this.containing_window;
    var id1190 = new Ext.form.NumberField({ "selectOnFocus": true });
    var date1191 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var partner1192 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/partner", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Partner..." });
    var total_incl1193 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var user1194 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var journal1195 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/journal", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Journal..." });
    var year1196 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.ledger.FiscalYears });
    var number1197 = new Ext.form.NumberField({ "selectOnFocus": true });
    var narration1198 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var declared_in1199 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/declared_in", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a VAT declaration..." });
    var build_time1200 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var total_base1201 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat1202 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var item_vat1203 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var vat_regime1204 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.vat.VatRegimes });
    var language1205 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "allowBlank": false, "value": "en" });
    var your_ref1206 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var imode1207 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Invoicing Mode..." });
    var shipping_mode1208 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/shipping_mode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Shipping Mode..." });
    var payment_term1209 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/Invoices/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Payment Term..." });
    var subject1210 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var intro1211 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var discount1212 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var due_date1213 = new Lino.DateField({ "selectOnFocus": true });
    var state1214 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.sales.InvoiceStates });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1190, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "editor": date1191, "width": Lino.chars2width(8), "dataIndex": "date" }, { "colIndex": 2, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('partnerHidden','Lino.partners.Partners.detail'), "editor": partner1192, "dataIndex": "partner" }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "header": "Total incl. VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_incl", "editor": total_incl1193 }), { "colIndex": 4, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1194, "dataIndex": "user" }, { "colIndex": 5, "sortable": true, "header": "Journal", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('journalHidden','Lino.ledger.Journals.detail'), "editor": journal1195, "dataIndex": "journal" }, { "colIndex": 6, "sortable": true, "header": "Fiscal Year", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(7), "dataIndex": "year", "editor": year1196 }, new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(5), "editor": number1197 }), { "colIndex": 8, "sortable": true, "header": "Narration", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "narration", "editor": narration1198 }, { "colIndex": 9, "sortable": true, "header": "VAT declaration", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('declared_inHidden','Lino.declarations.Declarations.detail'), "editor": declared_in1199, "dataIndex": "declared_in" }, { "width": Lino.chars2width(16), "colIndex": 10, "sortable": true, "dataIndex": "build_time", "header": "build time", "editable": false }, new Lino.NullNumberColumn({ "colIndex": 11, "sortable": true, "header": "Total excl. VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_base", "editor": total_base1201 }), new Lino.NullNumberColumn({ "colIndex": 12, "sortable": true, "header": "VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_vat", "editor": total_vat1202 }), { "colIndex": 13, "sortable": false, "xtype": "checkcolumn", "header": "Prices include VAT", "editable": true, "tooltip": "Whether prices includes VAT or not.", "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "item_vat" }, { "colIndex": 14, "sortable": true, "header": "VAT Regime", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(18), "dataIndex": "vat_regime", "editor": vat_regime1204 }, { "colIndex": 15, "sortable": true, "header": "Language", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "editor": language1205 }, { "colIndex": 16, "sortable": true, "header": "Your reference", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "your_ref", "editor": your_ref1206 }, { "colIndex": 17, "sortable": true, "header": "Invoicing Mode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "imode", "editor": imode1207 }, { "colIndex": 18, "sortable": true, "header": "Shipping Mode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "shipping_mode", "editor": shipping_mode1208 }, { "colIndex": 19, "sortable": true, "header": "Payment Term", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "payment_term", "editor": payment_term1209 }, { "colIndex": 20, "sortable": true, "header": "Subject line", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "subject", "editor": subject1210 }, { "colIndex": 21, "sortable": false, "header": "Introductive Text", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "editor": intro1211, "dataIndex": "intro" }, new Lino.NullNumberColumn({ "colIndex": 22, "sortable": true, "header": "Discount", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(7), "dataIndex": "discount", "editor": discount1212 }), { "colIndex": 23, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date of payment", "editor": due_date1213, "width": Lino.chars2width(8), "dataIndex": "due_date" }, { "colIndex": 24, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "state", "editor": state1214 } ];
    Lino.sales.Invoices.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.sales.Invoices.insertPanel = Ext.extend(Lino.sales.Invoices.InsertFormPanel,{
  empty_title: "New Invoices",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/sales/Invoices",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.Invoices.detail;
    this.ls_insert_handler = Lino.sales.Invoices.insert;
    Lino.sales.Invoices.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.Invoices.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.sales.Invoices.insertPanel(p);
});

Lino.sales.Invoices.detailPanel = Ext.extend(Lino.sales.Invoices.DetailFormPanel,{
  empty_title: "Detail Invoices",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Clear cache", "auto_save": true } ],
  ls_url: "/sales/Invoices",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.Invoices.detail;
    this.ls_insert_handler = Lino.sales.Invoices.insert;
    Lino.sales.Invoices.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.Invoices.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.Invoices.detailPanel(p);
});
Lino.sales.Invoices.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.sales.Invoices.ParamsPanel({});
  return new Lino.sales.Invoices.GridPanel(p);
});
Lino.sales.Invoices.deregister_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/Invoices",pk,"deregister_action");
};
Lino.sales.Invoices.register_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/Invoices",pk,"register_action");
};

// js_render_GridPanel_class sales.DocumentsToSign
Lino.sales.DocumentsToSign.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/sales/DocumentsToSign",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Clear cache", "auto_save": true } ],
  title : "Invoices",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "number" }, { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "partner" }, 'partnerHidden', { "name": "imode" }, 'imodeHidden', { "name": "subject" }, { "name": "total_incl" }, { "name": "total_base" }, { "name": "total_vat" }, { "name": "voucher_ptr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 10,
  ls_grid_configs : [  ],
  content_type : 38,
  ls_id_property : "voucher_ptr",
  gc_name : 0,
  disabled_actions_index : 12,
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.DocumentsToSign.detail;
    this.ls_insert_handler = Lino.sales.DocumentsToSign.insert;
    var ww = this.containing_window;
    var number1216 = new Ext.form.NumberField({ "selectOnFocus": true });
    var date1217 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var partner1218 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/DocumentsToSign/partner", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Partner..." });
    var imode1219 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/DocumentsToSign/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Invoicing Mode..." });
    var subject1220 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var total_incl1221 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_base1222 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat1223 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(4), "editor": number1216 }), { "colIndex": 1, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "editor": date1217, "width": Lino.chars2width(8), "dataIndex": "date" }, { "colIndex": 2, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "renderer": Lino.fk_renderer('partnerHidden','Lino.partners.Partners.detail'), "editor": partner1218, "dataIndex": "partner" }, { "colIndex": 3, "sortable": true, "header": "Invoicing Mode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "imode", "editor": imode1219 }, { "colIndex": 4, "sortable": true, "header": "Subject line", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "subject", "editor": subject1220 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "header": "Total incl. VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_incl", "editor": total_incl1221 }), new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "header": "Total excl. VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_base", "editor": total_base1222 }), new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "header": "VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_vat", "editor": total_vat1223 }) ];
    Lino.sales.DocumentsToSign.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.sales.DocumentsToSign.insertPanel = Ext.extend(Lino.sales.Invoices.InsertFormPanel,{
  empty_title: "New Invoices",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/sales/DocumentsToSign",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.DocumentsToSign.detail;
    this.ls_insert_handler = Lino.sales.DocumentsToSign.insert;
    Lino.sales.DocumentsToSign.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.DocumentsToSign.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.sales.DocumentsToSign.insertPanel(p);
});

Lino.sales.DocumentsToSign.detailPanel = Ext.extend(Lino.sales.Invoices.DetailFormPanel,{
  empty_title: "Detail Invoices",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Clear cache", "auto_save": true } ],
  ls_url: "/sales/DocumentsToSign",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.DocumentsToSign.detail;
    this.ls_insert_handler = Lino.sales.DocumentsToSign.insert;
    Lino.sales.DocumentsToSign.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.DocumentsToSign.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.DocumentsToSign.detailPanel(p);
});
Lino.sales.DocumentsToSign.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.sales.Invoices.ParamsPanel({});
  return new Lino.sales.DocumentsToSign.GridPanel(p);
});
Lino.sales.DocumentsToSign.deregister_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/DocumentsToSign",pk,"deregister_action");
};
Lino.sales.DocumentsToSign.register_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/DocumentsToSign",pk,"register_action");
};

// js_render_GridPanel_class finan.BankStatements
Lino.finan.BankStatements.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/finan/BankStatements",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "bank statements",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "type": "int", "name": "id" }, { "type": "int", "name": "number" }, { "name": "balance1" }, { "name": "balance2" }, { "name": "user" }, 'userHidden', { "name": "journal" }, 'journalHidden', { "name": "year" }, 'yearHidden', { "name": "narration" }, { "name": "declared_in" }, 'declared_inHidden', { "name": "state" }, 'stateHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 1,
  ls_grid_configs : [  ],
  content_type : 41,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 17,
  initComponent : function() {
    this.ls_detail_handler = Lino.finan.BankStatements.detail;
    this.ls_insert_handler = Lino.finan.BankStatements.insert;
    var ww = this.containing_window;
    var date1225 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var id1226 = new Ext.form.NumberField({ "selectOnFocus": true });
    var number1227 = new Ext.form.NumberField({ "selectOnFocus": true });
    var balance11228 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var balance21229 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var user1230 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/BankStatements/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var journal1231 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/BankStatements/journal", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Journal..." });
    var year1232 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.ledger.FiscalYears });
    var narration1233 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var declared_in1234 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/BankStatements/declared_in", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a VAT declaration..." });
    var state1235 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.finan.VoucherStates });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "editor": date1225, "width": Lino.chars2width(8), "dataIndex": "date" }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1226, "width": Lino.chars2width(5), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(5), "editor": number1227 }), new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "header": "Old balance", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "balance1", "editor": balance11228 }), new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "header": "New balance", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "balance2", "editor": balance21229 }), { "colIndex": 5, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1230, "dataIndex": "user" }, { "colIndex": 6, "sortable": true, "header": "Journal", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('journalHidden','Lino.ledger.Journals.detail'), "editor": journal1231, "dataIndex": "journal" }, { "colIndex": 7, "sortable": true, "header": "Fiscal Year", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(7), "dataIndex": "year", "editor": year1232 }, { "colIndex": 8, "sortable": true, "header": "Narration", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "narration", "editor": narration1233 }, { "colIndex": 9, "sortable": true, "header": "VAT declaration", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('declared_inHidden','Lino.declarations.Declarations.detail'), "editor": declared_in1234, "dataIndex": "declared_in" }, { "colIndex": 10, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "state", "editor": state1235 } ];
    Lino.finan.BankStatements.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.finan.BankStatements.insertPanel = Ext.extend(Lino.finan.BankStatements.InsertFormPanel,{
  empty_title: "New bank statements",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/finan/BankStatements",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.finan.BankStatements.detail;
    this.ls_insert_handler = Lino.finan.BankStatements.insert;
    Lino.finan.BankStatements.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.finan.BankStatements.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.finan.BankStatements.insertPanel(p);
});

Lino.finan.BankStatements.detailPanel = Ext.extend(Lino.finan.BankStatements.DetailFormPanel,{
  empty_title: "Detail bank statements",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/finan/BankStatements",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.finan.BankStatements.detail;
    this.ls_insert_handler = Lino.finan.BankStatements.insert;
    Lino.finan.BankStatements.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.finan.BankStatements.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.finan.BankStatements.detailPanel(p);
});
Lino.finan.BankStatements.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.finan.BankStatements.ParamsPanel({});
  return new Lino.finan.BankStatements.GridPanel(p);
});
Lino.finan.BankStatements.deregister_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/finan/BankStatements",pk,"deregister_action");
};
Lino.finan.BankStatements.register_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/finan/BankStatements",pk,"register_action");
};

// js_render_GridPanel_class finan.DocItems
Lino.finan.DocItems.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/finan/DocItems",
  ls_bbar_actions : [ { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "doc items",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "account" }, 'accountHidden', { "name": "partner" }, 'partnerHidden', { "name": "remark" }, { "name": "debit" }, { "name": "credit" }, { "type": "int", "name": "seqno" }, { "type": "int", "name": "id" }, { "name": "title" }, { "name": "voucher" }, 'voucherHidden', { "name": "amount" }, { "type": "boolean", "name": "dc" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 9,
  ls_grid_configs : [  ],
  content_type : 42,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 16,
  initComponent : function() {
    var ww = this.containing_window;
    var date1237 = new Lino.DateField({ "selectOnFocus": true });
    var account1238 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/DocItems/account", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account..." });
    var partner1239 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/DocItems/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var remark1240 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var debit1241 = new Ext.form.NumberField({ "disabled": true, "decimalPrecision": 2, "decimalSeparator": "," });
    var credit1242 = new Ext.form.NumberField({ "disabled": true, "decimalPrecision": 2, "decimalSeparator": "," });
    var seqno1243 = new Ext.form.NumberField({ "selectOnFocus": true });
    var id1244 = new Ext.form.NumberField({ "selectOnFocus": true });
    var title1245 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var voucher1246 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/DocItems/voucher", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a bank statement..." });
    var amount1247 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalSeparator": ",", "decimalPrecision": 2, "allowBlank": false, "value": 0 });
    var dc1248 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "date", "editor": date1237, "width": Lino.chars2width(8), "dataIndex": "date" }, { "colIndex": 1, "sortable": true, "header": "Account", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "account", "editor": account1238 }, { "colIndex": 2, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('partnerHidden','Lino.partners.Partners.detail'), "editor": partner1239, "dataIndex": "partner" }, { "colIndex": 3, "sortable": true, "header": "remark", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "remark", "editor": remark1240 }, new Lino.NullNumberColumn({ "width": Lino.chars2width(12), "colIndex": 4, "sortable": false, "dataIndex": "debit", "header": "Income", "editable": false }), new Lino.NullNumberColumn({ "width": Lino.chars2width(12), "colIndex": 5, "sortable": false, "dataIndex": "credit", "header": "Expense", "editable": false }), new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "width": Lino.chars2width(5), "editor": seqno1243 }), new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1244, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 8, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "title", "editor": title1245 }, { "colIndex": 9, "sortable": true, "header": "bank statement", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('voucherHidden','Lino.finan.BankStatements.detail'), "editor": voucher1246, "dataIndex": "voucher" }, new Lino.NullNumberColumn({ "colIndex": 10, "sortable": true, "header": "amount", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "amount", "editor": amount1247 }), { "colIndex": 11, "sortable": false, "xtype": "checkcolumn", "header": "dc", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "dc" } ];
    Lino.finan.DocItems.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.finan.DocItems.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.finan.DocItems.GridPanel(p);
});

// js_render_GridPanel_class pages.Pages
Lino.pages.Pages.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/pages/Pages",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Nodes",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "ref" }, { "name": "title" }, { "name": "title_de" }, { "name": "title_fr" }, { "type": "int", "name": "id" }, { "type": "int", "name": "seqno" }, { "name": "parent" }, 'parentHidden', { "name": "body" }, { "type": "boolean", "name": "raw_html" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 43,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    this.ls_detail_handler = Lino.pages.Pages.detail;
    this.ls_insert_handler = Lino.pages.Pages.insert;
    var ww = this.containing_window;
    var ref1250 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 40 });
    var title1251 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var title_de1252 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var title_fr1253 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1254 = new Ext.form.NumberField({ "selectOnFocus": true });
    var seqno1255 = new Ext.form.NumberField({ "selectOnFocus": true });
    var parent1256 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/pages/Pages/parent", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Node..." });
    var body1257 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var raw_html1258 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Reference", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "ref", "editor": ref1250 }, { "colIndex": 1, "sortable": true, "header": "Title", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "title", "editor": title1251 }, { "colIndex": 2, "sortable": true, "header": "Title (de)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "title_de", "editor": title_de1252 }, { "colIndex": 3, "sortable": true, "header": "Title (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "title_fr", "editor": title_fr1253 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1254, "width": Lino.chars2width(5), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "width": Lino.chars2width(5), "editor": seqno1255 }), { "colIndex": 6, "sortable": true, "header": "Parent", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('parentHidden','Lino.pages.Pages.detail'), "editor": parent1256, "dataIndex": "parent" }, { "colIndex": 7, "sortable": false, "header": "Body", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "editor": body1257, "dataIndex": "body" }, { "colIndex": 8, "sortable": false, "xtype": "checkcolumn", "header": "raw html", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "raw_html" } ];
    Lino.pages.Pages.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.pages.Pages.insertPanel = Ext.extend(Lino.pages.Pages.DetailFormPanel,{
  empty_title: "New Nodes",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/pages/Pages",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.pages.Pages.detail;
    this.ls_insert_handler = Lino.pages.Pages.insert;
    Lino.pages.Pages.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.pages.Pages.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.pages.Pages.insertPanel(p);
});

Lino.pages.Pages.detailPanel = Ext.extend(Lino.pages.Pages.DetailFormPanel,{
  empty_title: "Detail Nodes",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/pages/Pages",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.pages.Pages.detail;
    this.ls_insert_handler = Lino.pages.Pages.insert;
    Lino.pages.Pages.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.pages.Pages.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pages.Pages.detailPanel(p);
});
Lino.pages.Pages.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.pages.Pages.GridPanel(p);
});

// js_render_GridPanel_class ledger.InvoiceItemTable
Lino.ledger.InvoiceItemTable.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/ledger/InvoiceItemTable",
  ls_bbar_actions : [ { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Voucher items",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "type": "int", "name": "seqno" }, { "name": "total_incl" }, { "name": "total_base" }, { "name": "total_vat" }, { "name": "vat_class" }, 'vat_classHidden', { "name": "title" }, { "name": "voucher" }, 'voucherHidden', { "name": "account" }, 'accountHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 29,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 13,
  initComponent : function() {
    var ww = this.containing_window;
    var id1260 = new Ext.form.NumberField({ "selectOnFocus": true });
    var seqno1261 = new Ext.form.NumberField({ "selectOnFocus": true });
    var total_incl1262 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_base1263 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat1264 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var vat_class1265 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.vat.VatClasses });
    var title1266 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var voucher1267 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/InvoiceItemTable/voucher", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Invoice..." });
    var account1268 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/InvoiceItemTable/account", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account..." });
    this.before_row_edit = function(record) {
      account1268.setContextValue('voucher',record ? record.data['voucherHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      voucher1267.on('change',Lino.chooser_handler(account1268,'voucher'));
      Lino.ledger.InvoiceItemTable.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1260, "width": Lino.chars2width(5), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "width": Lino.chars2width(5), "editor": seqno1261 }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "header": "Total incl. VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_incl", "editor": total_incl1262 }), new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "header": "Total excl. VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_base", "editor": total_base1263 }), new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "header": "VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_vat", "editor": total_vat1264 }), { "colIndex": 5, "sortable": true, "header": "VAT Class", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "vat_class", "editor": vat_class1265 }, { "colIndex": 6, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "title", "editor": title1266 }, { "colIndex": 7, "sortable": true, "header": "Invoice", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('voucherHidden','Lino.ledger.Invoices.detail'), "editor": voucher1267, "dataIndex": "voucher" }, { "colIndex": 8, "sortable": true, "header": "Account", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "account", "editor": account1268 } ];
    Lino.ledger.InvoiceItemTable.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.InvoiceItemTable.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.InvoiceItemTable.GridPanel(p);
});

// js_render_GridPanel_class sales.SalesRuleTable
Lino.sales.SalesRuleTable.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/sales/SalesRuleTable",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Sales Rules",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "imode" }, 'imodeHidden', { "name": "shipping_mode" }, 'shipping_modeHidden', { "name": "payment_term" }, 'payment_termHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 37,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var id1270 = new Ext.form.NumberField({ "selectOnFocus": true });
    var imode1271 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/SalesRuleTable/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Invoicing Mode..." });
    var shipping_mode1272 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/SalesRuleTable/shipping_mode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Shipping Mode..." });
    var payment_term1273 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/SalesRuleTable/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Payment Term..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1270, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Invoicing Mode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "imode", "editor": imode1271 }, { "colIndex": 2, "sortable": true, "header": "Shipping Mode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "shipping_mode", "editor": shipping_mode1272 }, { "colIndex": 3, "sortable": true, "header": "Payment Term", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "payment_term", "editor": payment_term1273 } ];
    Lino.sales.SalesRuleTable.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.SalesRuleTable.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.SalesRuleTable.GridPanel(p);
});

// js_render_GridPanel_class sales.ProductDocItemTable
Lino.sales.ProductDocItemTable.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/sales/ProductDocItemTable",
  ls_bbar_actions : [ { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Voucher items",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "type": "int", "name": "seqno" }, { "name": "total_incl" }, { "name": "total_base" }, { "name": "total_vat" }, { "name": "vat_class" }, 'vat_classHidden', { "name": "unit_price" }, { "name": "qty" }, { "name": "title" }, { "name": "product" }, 'productHidden', { "name": "description" }, { "name": "discount" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 36,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    var ww = this.containing_window;
    var id1275 = new Ext.form.NumberField({ "selectOnFocus": true });
    var seqno1276 = new Ext.form.NumberField({ "selectOnFocus": true });
    var total_incl1277 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_base1278 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat1279 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var vat_class1280 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.vat.VatClasses });
    var unit_price1281 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var qty1282 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(6), "maxLength": 6 });
    var title1283 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var product1284 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/ProductDocItemTable/product", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Product..." });
    var description1285 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var discount1286 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1275, "width": Lino.chars2width(5), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "width": Lino.chars2width(5), "editor": seqno1276 }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "header": "Total incl. VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_incl", "editor": total_incl1277 }), new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "header": "Total excl. VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_base", "editor": total_base1278 }), new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "header": "VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_vat", "editor": total_vat1279 }), { "colIndex": 5, "sortable": true, "header": "VAT Class", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "vat_class", "editor": vat_class1280 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "header": "Unit price", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "unit_price", "editor": unit_price1281 }), { "colIndex": 7, "sortable": true, "format": "", "align": "right", "editable": true, "filter": { "type": "string" }, "header": "Quantity", "dataIndex": "qty", "width": Lino.chars2width(7), "editor": qty1282 }, { "colIndex": 8, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "title", "editor": title1283 }, { "colIndex": 9, "sortable": true, "header": "Product", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('productHidden','Lino.products.Products.detail'), "editor": product1284, "dataIndex": "product" }, { "colIndex": 10, "sortable": false, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "editor": description1285, "dataIndex": "description" }, new Lino.NullNumberColumn({ "colIndex": 11, "sortable": true, "header": "Discount", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(7), "dataIndex": "discount", "editor": discount1286 }) ];
    Lino.sales.ProductDocItemTable.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.ProductDocItemTable.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.ProductDocItemTable.GridPanel(p);
});

// js_render_GridPanel_class sales.InvoiceItemTable
Lino.sales.InvoiceItemTable.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/sales/InvoiceItemTable",
  ls_bbar_actions : [ { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Voucher items",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "type": "int", "name": "seqno" }, { "name": "total_incl" }, { "name": "total_base" }, { "name": "total_vat" }, { "name": "vat_class" }, 'vat_classHidden', { "name": "unit_price" }, { "name": "qty" }, { "name": "title" }, { "name": "product" }, 'productHidden', { "name": "description" }, { "name": "discount" }, { "name": "voucher" }, 'voucherHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 35,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 17,
  initComponent : function() {
    var ww = this.containing_window;
    var id1288 = new Ext.form.NumberField({ "selectOnFocus": true });
    var seqno1289 = new Ext.form.NumberField({ "selectOnFocus": true });
    var total_incl1290 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_base1291 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat1292 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var vat_class1293 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.vat.VatClasses });
    var unit_price1294 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var qty1295 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(6), "maxLength": 6 });
    var title1296 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var product1297 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoiceItemTable/product", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Product..." });
    var description1298 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var discount1299 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var voucher1300 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoiceItemTable/voucher", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Invoice..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1288, "width": Lino.chars2width(5), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "width": Lino.chars2width(5), "editor": seqno1289 }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "header": "Total incl. VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_incl", "editor": total_incl1290 }), new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "header": "Total excl. VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_base", "editor": total_base1291 }), new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "header": "VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_vat", "editor": total_vat1292 }), { "colIndex": 5, "sortable": true, "header": "VAT Class", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "vat_class", "editor": vat_class1293 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "header": "Unit price", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "unit_price", "editor": unit_price1294 }), { "colIndex": 7, "sortable": true, "format": "", "align": "right", "editable": true, "filter": { "type": "string" }, "header": "Quantity", "dataIndex": "qty", "width": Lino.chars2width(7), "editor": qty1295 }, { "colIndex": 8, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "title", "editor": title1296 }, { "colIndex": 9, "sortable": true, "header": "Product", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('productHidden','Lino.products.Products.detail'), "editor": product1297, "dataIndex": "product" }, { "colIndex": 10, "sortable": false, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "editor": description1298, "dataIndex": "description" }, new Lino.NullNumberColumn({ "colIndex": 11, "sortable": true, "header": "Discount", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(7), "dataIndex": "discount", "editor": discount1299 }), { "colIndex": 12, "sortable": true, "header": "Invoice", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('voucherHidden','Lino.sales.Invoices.detail'), "editor": voucher1300, "dataIndex": "voucher" } ];
    Lino.sales.InvoiceItemTable.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.InvoiceItemTable.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.InvoiceItemTable.GridPanel(p);
});

// js_render_GridPanel_class ui.MyTextFieldTemplates
Lino.ui.MyTextFieldTemplates.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/ui/MyTextFieldTemplates",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "My Text Field Templates",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "description" }, { "name": "team" }, 'teamHidden', { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 3,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.MyTextFieldTemplates.detail;
    this.ls_insert_handler = Lino.ui.MyTextFieldTemplates.insert;
    var ww = this.containing_window;
    var id1302 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name1303 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var description1304 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var team1305 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/MyTextFieldTemplates/team", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Team..." });
    var text1306 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Template Text" });
    this.before_row_edit = function(record) {
      text1306.refresh();
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1302, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "editor": name1303 }, { "colIndex": 2, "sortable": false, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "editor": description1304, "dataIndex": "description" }, { "colIndex": 3, "sortable": true, "header": "Team", "editable": true, "tooltip": "If not empty, then this template is reserved to members of this team.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "team", "editor": team1305 }, { "colIndex": 4, "sortable": false, "header": "text", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "editor": text1306, "dataIndex": "text" } ];
    Lino.ui.MyTextFieldTemplates.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.ui.MyTextFieldTemplates.insertPanel = Ext.extend(Lino.ui.TextFieldTemplates.InsertFormPanel,{
  empty_title: "New My Text Field Templates",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/ui/MyTextFieldTemplates",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.MyTextFieldTemplates.detail;
    this.ls_insert_handler = Lino.ui.MyTextFieldTemplates.insert;
    Lino.ui.MyTextFieldTemplates.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.ui.MyTextFieldTemplates.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.ui.MyTextFieldTemplates.insertPanel(p);
});

Lino.ui.MyTextFieldTemplates.detailPanel = Ext.extend(Lino.ui.TextFieldTemplates.DetailFormPanel,{
  empty_title: "Detail My Text Field Templates",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/ui/MyTextFieldTemplates",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.MyTextFieldTemplates.detail;
    this.ls_insert_handler = Lino.ui.MyTextFieldTemplates.insert;
    Lino.ui.MyTextFieldTemplates.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.ui.MyTextFieldTemplates.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ui.MyTextFieldTemplates.detailPanel(p);
});
Lino.ui.MyTextFieldTemplates.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ui.MyTextFieldTemplates.GridPanel(p);
});

// js_render_GridPanel_class users.MembershipsByUser
Lino.users.MembershipsByUser.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/MembershipsByUser",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "My Memberships",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "team" }, 'teamHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 10,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var team275 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/MembershipsByUser/team", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Team..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Team", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "team", "editor": team275 } ];
    Lino.users.MembershipsByUser.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.MembershipsByUser.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.MembershipsByUser.GridPanel(p);
});

// js_render_GridPanel_class users.AuthoritiesGiven
Lino.users.AuthoritiesGiven.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/AuthoritiesGiven",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Authorities given",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "authorized" }, 'authorizedHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 12,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var authorized280 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/AuthoritiesGiven/authorized", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a User..." });
    this.before_row_edit = function(record) {
      var bp = this.get_base_params();
      authorized280.setContextValue('mk',bp['mk']);
      authorized280.setContextValue('mt',bp['mt']);
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "User", "editable": true, "tooltip": "The user who gets authority to act in your name.", "filter": { "type": "string" }, "width": Lino.chars2width(15), "renderer": Lino.fk_renderer('authorizedHidden','Lino.users.Users.detail'), "editor": authorized280, "dataIndex": "authorized" } ];
    Lino.users.AuthoritiesGiven.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.AuthoritiesGiven.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.AuthoritiesGiven.GridPanel(p);
});

// js_render_GridPanel_class users.AuthoritiesTaken
Lino.users.AuthoritiesTaken.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/AuthoritiesTaken",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Authorities taken",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "user" }, 'userHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 12,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var user1308 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/AuthoritiesTaken/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1308, "dataIndex": "user" } ];
    Lino.users.AuthoritiesTaken.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.users.AuthoritiesTaken.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.users.AuthoritiesTaken.GridPanel(p);
});

// js_render_GridPanel_class countries.CitiesByCity
Lino.countries.CitiesByCity.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/countries/CitiesByCity",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Subdivisions",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "type" }, 'typeHidden', { "name": "zip_code" }, { "type": "int", "name": "id" }, { "name": "country" }, 'countryHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 16,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 10,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.CitiesByCity.detail;
    this.ls_insert_handler = Lino.countries.CitiesByCity.insert;
    var ww = this.containing_window;
    var name339 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de340 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr341 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type342 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/CitiesByCity/type", "method": "GET" }) }) });
    var zip_code343 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "maxLength": 8 });
    var id344 = new Ext.form.NumberField({ "selectOnFocus": true });
    var country345 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/CitiesByCity/country", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Country..." });
    this.before_row_edit = function(record) {
      type342.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country345.on('change',Lino.chooser_handler(type342,'country'));
      Lino.countries.CitiesByCity.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "editor": name339 }, { "colIndex": 1, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_de", "editor": name_de340 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "editor": name_fr341 }, { "colIndex": 3, "sortable": true, "header": "Place Type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "type", "editor": type342 }, { "colIndex": 4, "sortable": true, "header": "zip code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(9), "dataIndex": "zip_code", "editor": zip_code343 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id344, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Country", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country345, "dataIndex": "country" } ];
    Lino.countries.CitiesByCity.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.CitiesByCity.insertPanel = Ext.extend(Lino.countries.Cities.DetailFormPanel,{
  empty_title: "New Subdivisions",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/countries/CitiesByCity",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.CitiesByCity.detail;
    this.ls_insert_handler = Lino.countries.CitiesByCity.insert;
    Lino.countries.CitiesByCity.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.CitiesByCity.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.CitiesByCity.insertPanel(p);
});

Lino.countries.CitiesByCity.detailPanel = Ext.extend(Lino.countries.Cities.DetailFormPanel,{
  empty_title: "Detail Subdivisions",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/countries/CitiesByCity",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.CitiesByCity.detail;
    this.ls_insert_handler = Lino.countries.CitiesByCity.insert;
    Lino.countries.CitiesByCity.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.CitiesByCity.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.CitiesByCity.detailPanel(p);
});
Lino.countries.CitiesByCity.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.CitiesByCity.GridPanel(p);
});

// js_render_GridPanel_class countries.CitiesByCountry
Lino.countries.CitiesByCountry.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/countries/CitiesByCountry",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Places",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "type" }, 'typeHidden', { "name": "zip_code" }, { "type": "int", "name": "id" }, { "name": "parent" }, 'parentHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 16,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 10,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.CitiesByCountry.detail;
    this.ls_insert_handler = Lino.countries.CitiesByCountry.insert;
    var ww = this.containing_window;
    var name313 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de314 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr315 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type316 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/CitiesByCountry/type", "method": "GET" }) }) });
    var zip_code317 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(8), "maxLength": 8 });
    var id318 = new Ext.form.NumberField({ "selectOnFocus": true });
    var parent319 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/CitiesByCountry/parent", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    this.before_row_edit = function(record) {
      var bp = this.get_base_params();
      type316.setContextValue('mk',bp['mk']);
      type316.setContextValue('mt',bp['mt']);
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "editor": name313 }, { "colIndex": 1, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_de", "editor": name_de314 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "editor": name_fr315 }, { "colIndex": 3, "sortable": true, "header": "Place Type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "type", "editor": type316 }, { "colIndex": 4, "sortable": true, "header": "zip code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(9), "dataIndex": "zip_code", "editor": zip_code317 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id318, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Part of", "editable": true, "tooltip": "The superordinate geographic place of which this place is a part.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('parentHidden','Lino.countries.Cities.detail'), "editor": parent319, "dataIndex": "parent" } ];
    Lino.countries.CitiesByCountry.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.CitiesByCountry.insertPanel = Ext.extend(Lino.countries.Cities.DetailFormPanel,{
  empty_title: "New Places",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/countries/CitiesByCountry",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.CitiesByCountry.detail;
    this.ls_insert_handler = Lino.countries.CitiesByCountry.insert;
    Lino.countries.CitiesByCountry.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.CitiesByCountry.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.countries.CitiesByCountry.insertPanel(p);
});

Lino.countries.CitiesByCountry.detailPanel = Ext.extend(Lino.countries.Cities.DetailFormPanel,{
  empty_title: "Detail Places",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/countries/CitiesByCountry",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.CitiesByCountry.detail;
    this.ls_insert_handler = Lino.countries.CitiesByCountry.insert;
    Lino.countries.CitiesByCountry.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.CitiesByCountry.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.CitiesByCountry.detailPanel(p);
});
Lino.countries.CitiesByCountry.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.CitiesByCountry.GridPanel(p);
});

// js_render_GridPanel_class partners.PersonsByCity
Lino.partners.PersonsByCity.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/partners/PersonsByCity",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "merge_row", "menu_item_text": "Merge", "tooltip": "Merge this object into another object of same class.", "panel_btn_handler": Lino.param_action_handler(Lino.partners.Persons.merge_row), "text": "Merge", "overflowText": "Merge", "auto_save": true } ],
  title : "Persons",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "last_name" }, { "name": "first_name" }, { "name": "language" }, 'languageHidden', { "type": "int", "name": "id" }, { "name": "gender" }, 'genderHidden', { "name": "country" }, 'countryHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "email" }, { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "name": "title" }, { "name": "partner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 8,
  ls_grid_configs : [  ],
  content_type : 19,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 27,
  initComponent : function() {
    this.ls_detail_handler = Lino.partners.PersonsByCity.detail;
    this.ls_insert_handler = Lino.partners.PersonsByCity.insert;
    var ww = this.containing_window;
    var street366 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no367 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box368 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr2369 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var last_name370 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var first_name371 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language372 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "allowBlank": false, "value": "en" });
    var id373 = new Ext.form.NumberField({ "selectOnFocus": true });
    var gender374 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.lino.Genders });
    var country375 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/PersonsByCity/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Country..." });
    var region376 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/PersonsByCity/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var zip_code377 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr1378 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix379 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var email380 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var url381 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone382 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm383 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax384 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks385 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var title386 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var partner387 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/PersonsByCity/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    this.before_row_edit = function(record) {
      region376.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country375.on('change',Lino.chooser_handler(region376,'country'));
      Lino.partners.PersonsByCity.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Street", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "street", "editor": street366 }, { "colIndex": 1, "sortable": true, "header": "No.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "street_no", "editor": street_no367 }, { "colIndex": 2, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "street_box", "editor": street_box368 }, { "colIndex": 3, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "addr2", "editor": addr2369 }, { "colIndex": 4, "sortable": true, "header": "Last name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "last_name", "editor": last_name370 }, { "colIndex": 5, "sortable": true, "header": "First name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "first_name", "editor": first_name371 }, { "colIndex": 6, "sortable": true, "header": "Language", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "editor": language372 }, new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id373, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 8, "sortable": true, "header": "Gender", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(9), "dataIndex": "gender", "editor": gender374 }, { "colIndex": 9, "sortable": true, "header": "Country", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country375, "dataIndex": "country" }, { "colIndex": 10, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail'), "hidden": true, "editor": region376, "dataIndex": "region" }, { "colIndex": 11, "sortable": true, "header": "Zip code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "zip_code", "editor": zip_code377 }, { "colIndex": 12, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "addr1", "editor": addr1378 }, { "colIndex": 13, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "street_prefix", "editor": street_prefix379 }, { "colIndex": 14, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "email", "editor": email380 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "url", "editor": url381 }, { "colIndex": 16, "sortable": true, "header": "Phone", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "phone", "editor": phone382 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "gsm", "editor": gsm383 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "fax", "editor": fax384 }, { "colIndex": 19, "sortable": false, "header": "Remarks", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "editor": remarks385, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": true, "header": "Title", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "title", "editor": title386 }, { "colIndex": 21, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('partnerHidden','Lino.partners.Partners.detail'), "editor": partner387, "dataIndex": "partner" } ];
    Lino.partners.PersonsByCity.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.partners.PersonsByCity.insertPanel = Ext.extend(Lino.partners.Persons.InsertFormPanel,{
  empty_title: "New Persons",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/partners/PersonsByCity",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.partners.PersonsByCity.detail;
    this.ls_insert_handler = Lino.partners.PersonsByCity.insert;
    Lino.partners.PersonsByCity.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.partners.PersonsByCity.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.partners.PersonsByCity.insertPanel(p);
});

Lino.partners.PersonsByCity.detailPanel = Ext.extend(Lino.partners.Persons.DetailFormPanel,{
  empty_title: "Detail Persons",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "merge_row", "menu_item_text": "Merge", "tooltip": "Merge this object into another object of same class.", "panel_btn_handler": Lino.param_action_handler(Lino.partners.Persons.merge_row), "text": "Merge", "overflowText": "Merge", "auto_save": true } ],
  ls_url: "/partners/PersonsByCity",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.partners.PersonsByCity.detail;
    this.ls_insert_handler = Lino.partners.PersonsByCity.insert;
    Lino.partners.PersonsByCity.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.partners.PersonsByCity.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.partners.PersonsByCity.detailPanel(p);
});
Lino.partners.PersonsByCity.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.partners.PersonsByCity.GridPanel(p);
});

// js_render_GridPanel_class partners.PersonsByCountry
Lino.partners.PersonsByCountry.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/partners/PersonsByCountry",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "merge_row", "menu_item_text": "Merge", "tooltip": "Merge this object into another object of same class.", "panel_btn_handler": Lino.param_action_handler(Lino.partners.Persons.merge_row), "text": "Merge", "overflowText": "Merge", "auto_save": true } ],
  title : "Persons",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "city" }, 'cityHidden', { "name": "street" }, { "name": "street_no" }, { "name": "last_name" }, { "name": "first_name" }, { "name": "language" }, 'languageHidden', { "type": "int", "name": "id" }, { "name": "gender" }, 'genderHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "email" }, { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "name": "title" }, { "name": "partner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 8,
  ls_grid_configs : [  ],
  content_type : 19,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 27,
  initComponent : function() {
    this.ls_detail_handler = Lino.partners.PersonsByCountry.detail;
    this.ls_insert_handler = Lino.partners.PersonsByCountry.insert;
    var ww = this.containing_window;
    var city1310 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/PersonsByCountry/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var street1311 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no1312 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var last_name1313 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var first_name1314 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language1315 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "allowBlank": false, "value": "en" });
    var id1316 = new Ext.form.NumberField({ "selectOnFocus": true });
    var gender1317 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.lino.Genders });
    var region1318 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/PersonsByCountry/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var zip_code1319 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr11320 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix1321 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_box1322 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr21323 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var email1324 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var url1325 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone1326 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm1327 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax1328 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks1329 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var title1330 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var partner1331 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/PersonsByCountry/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    this.before_row_edit = function(record) {
      var bp = this.get_base_params();
      city1310.setContextValue('mk',bp['mk']);
      city1310.setContextValue('mt',bp['mt']);
      city1310.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      var bp = this.get_base_params();
      region1318.setContextValue('mk',bp['mk']);
      region1318.setContextValue('mt',bp['mt']);
    };
    this.onRender = function(ct, position) {
      region1318.on('change',Lino.chooser_handler(city1310,'region'));
      Lino.partners.PersonsByCountry.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Place", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail'), "editor": city1310, "dataIndex": "city" }, { "colIndex": 1, "sortable": true, "header": "Street", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "street", "editor": street1311 }, { "colIndex": 2, "sortable": true, "header": "No.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "street_no", "editor": street_no1312 }, { "colIndex": 3, "sortable": true, "header": "Last name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "last_name", "editor": last_name1313 }, { "colIndex": 4, "sortable": true, "header": "First name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "first_name", "editor": first_name1314 }, { "colIndex": 5, "sortable": true, "header": "Language", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "editor": language1315 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1316, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 7, "sortable": true, "header": "Gender", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(9), "dataIndex": "gender", "editor": gender1317 }, { "colIndex": 8, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail'), "hidden": true, "editor": region1318, "dataIndex": "region" }, { "colIndex": 9, "sortable": true, "header": "Zip code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "zip_code", "editor": zip_code1319 }, { "colIndex": 10, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "addr1", "editor": addr11320 }, { "colIndex": 11, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "street_prefix", "editor": street_prefix1321 }, { "colIndex": 12, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "street_box", "editor": street_box1322 }, { "colIndex": 13, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "addr2", "editor": addr21323 }, { "colIndex": 14, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "email", "editor": email1324 }, { "colIndex": 15, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "url", "editor": url1325 }, { "colIndex": 16, "sortable": true, "header": "Phone", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "phone", "editor": phone1326 }, { "colIndex": 17, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "gsm", "editor": gsm1327 }, { "colIndex": 18, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "fax", "editor": fax1328 }, { "colIndex": 19, "sortable": false, "header": "Remarks", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "editor": remarks1329, "dataIndex": "remarks" }, { "colIndex": 20, "sortable": true, "header": "Title", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "title", "editor": title1330 }, { "colIndex": 21, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('partnerHidden','Lino.partners.Partners.detail'), "editor": partner1331, "dataIndex": "partner" } ];
    Lino.partners.PersonsByCountry.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.partners.PersonsByCountry.insertPanel = Ext.extend(Lino.partners.Persons.InsertFormPanel,{
  empty_title: "New Persons",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/partners/PersonsByCountry",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.partners.PersonsByCountry.detail;
    this.ls_insert_handler = Lino.partners.PersonsByCountry.insert;
    Lino.partners.PersonsByCountry.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.partners.PersonsByCountry.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.partners.PersonsByCountry.insertPanel(p);
});

Lino.partners.PersonsByCountry.detailPanel = Ext.extend(Lino.partners.Persons.DetailFormPanel,{
  empty_title: "Detail Persons",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "merge_row", "menu_item_text": "Merge", "tooltip": "Merge this object into another object of same class.", "panel_btn_handler": Lino.param_action_handler(Lino.partners.Persons.merge_row), "text": "Merge", "overflowText": "Merge", "auto_save": true } ],
  ls_url: "/partners/PersonsByCountry",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.partners.PersonsByCountry.detail;
    this.ls_insert_handler = Lino.partners.PersonsByCountry.insert;
    Lino.partners.PersonsByCountry.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.partners.PersonsByCountry.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.partners.PersonsByCountry.detailPanel(p);
});
Lino.partners.PersonsByCountry.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.partners.PersonsByCountry.GridPanel(p);
});

// js_render_GridPanel_class partners.OrganisationsByCity
Lino.partners.OrganisationsByCity.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/partners/OrganisationsByCity",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "merge_row", "menu_item_text": "Merge", "tooltip": "Merge this object into another object of same class.", "panel_btn_handler": Lino.param_action_handler(Lino.partners.Organisations.merge_row), "text": "Merge", "overflowText": "Merge", "auto_save": true } ],
  title : "Organisations",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "name" }, { "name": "language" }, 'languageHidden', { "type": "int", "name": "id" }, { "name": "country" }, 'countryHidden', { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "email" }, { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "name": "partner" }, { "name": "prefix" }, { "name": "vat_id" }, { "name": "type" }, 'typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 18,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 27,
  initComponent : function() {
    this.ls_detail_handler = Lino.partners.OrganisationsByCity.detail;
    this.ls_insert_handler = Lino.partners.OrganisationsByCity.insert;
    var ww = this.containing_window;
    var street390 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no391 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var street_box392 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr2393 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name394 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var language395 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "allowBlank": false, "value": "en" });
    var id396 = new Ext.form.NumberField({ "selectOnFocus": true });
    var country397 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/OrganisationsByCity/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Country..." });
    var region398 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/OrganisationsByCity/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var zip_code399 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr1400 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix401 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var email402 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var url403 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone404 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm405 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax406 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks407 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var partner408 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/OrganisationsByCity/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var prefix409 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var vat_id410 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type411 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/OrganisationsByCity/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Organisation type..." });
    this.before_row_edit = function(record) {
      region398.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country397.on('change',Lino.chooser_handler(region398,'country'));
      Lino.partners.OrganisationsByCity.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Street", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "street", "editor": street390 }, { "colIndex": 1, "sortable": true, "header": "No.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "street_no", "editor": street_no391 }, { "colIndex": 2, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "street_box", "editor": street_box392 }, { "colIndex": 3, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "addr2", "editor": addr2393 }, { "colIndex": 4, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "editor": name394 }, { "colIndex": 5, "sortable": true, "header": "Language", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "editor": language395 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id396, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 7, "sortable": true, "header": "Country", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail'), "editor": country397, "dataIndex": "country" }, { "colIndex": 8, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail'), "hidden": true, "editor": region398, "dataIndex": "region" }, { "colIndex": 9, "sortable": true, "header": "Zip code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "zip_code", "editor": zip_code399 }, { "colIndex": 10, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "addr1", "editor": addr1400 }, { "colIndex": 11, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "street_prefix", "editor": street_prefix401 }, { "colIndex": 12, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "email", "editor": email402 }, { "colIndex": 13, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "url", "editor": url403 }, { "colIndex": 14, "sortable": true, "header": "Phone", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "phone", "editor": phone404 }, { "colIndex": 15, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "gsm", "editor": gsm405 }, { "colIndex": 16, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "fax", "editor": fax406 }, { "colIndex": 17, "sortable": false, "header": "Remarks", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "editor": remarks407, "dataIndex": "remarks" }, { "colIndex": 18, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('partnerHidden','Lino.partners.Partners.detail'), "editor": partner408, "dataIndex": "partner" }, { "colIndex": 19, "sortable": true, "header": "prefix", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "prefix", "editor": prefix409 }, { "colIndex": 20, "sortable": true, "header": "VAT id", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "vat_id", "editor": vat_id410 }, { "colIndex": 21, "sortable": true, "header": "Organisation type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "type", "editor": type411 } ];
    Lino.partners.OrganisationsByCity.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.partners.OrganisationsByCity.insertPanel = Ext.extend(Lino.partners.Organisations.InsertFormPanel,{
  empty_title: "New Organisations",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/partners/OrganisationsByCity",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.partners.OrganisationsByCity.detail;
    this.ls_insert_handler = Lino.partners.OrganisationsByCity.insert;
    Lino.partners.OrganisationsByCity.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.partners.OrganisationsByCity.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.partners.OrganisationsByCity.insertPanel(p);
});

Lino.partners.OrganisationsByCity.detailPanel = Ext.extend(Lino.partners.Organisations.DetailFormPanel,{
  empty_title: "Detail Organisations",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "merge_row", "menu_item_text": "Merge", "tooltip": "Merge this object into another object of same class.", "panel_btn_handler": Lino.param_action_handler(Lino.partners.Organisations.merge_row), "text": "Merge", "overflowText": "Merge", "auto_save": true } ],
  ls_url: "/partners/OrganisationsByCity",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.partners.OrganisationsByCity.detail;
    this.ls_insert_handler = Lino.partners.OrganisationsByCity.insert;
    Lino.partners.OrganisationsByCity.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.partners.OrganisationsByCity.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.partners.OrganisationsByCity.detailPanel(p);
});
Lino.partners.OrganisationsByCity.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.partners.OrganisationsByCity.GridPanel(p);
});

// js_render_GridPanel_class partners.OrganisationsByCountry
Lino.partners.OrganisationsByCountry.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/partners/OrganisationsByCountry",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "merge_row", "menu_item_text": "Merge", "tooltip": "Merge this object into another object of same class.", "panel_btn_handler": Lino.param_action_handler(Lino.partners.Organisations.merge_row), "text": "Merge", "overflowText": "Merge", "auto_save": true } ],
  title : "Organisations",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "city" }, 'cityHidden', { "name": "street" }, { "name": "street_no" }, { "name": "name" }, { "name": "language" }, 'languageHidden', { "type": "int", "name": "id" }, { "name": "region" }, 'regionHidden', { "name": "zip_code" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "email" }, { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "name": "partner" }, { "name": "prefix" }, { "name": "vat_id" }, { "name": "type" }, 'typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 18,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 27,
  initComponent : function() {
    this.ls_detail_handler = Lino.partners.OrganisationsByCountry.detail;
    this.ls_insert_handler = Lino.partners.OrganisationsByCountry.insert;
    var ww = this.containing_window;
    var city1333 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/OrganisationsByCountry/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var street1334 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no1335 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var name1336 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var language1337 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "allowBlank": false, "value": "en" });
    var id1338 = new Ext.form.NumberField({ "selectOnFocus": true });
    var region1339 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/OrganisationsByCountry/region", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var zip_code1340 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr11341 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix1342 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_box1343 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(10), "maxLength": 10 });
    var addr21344 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var email1345 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var url1346 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone1347 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm1348 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax1349 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks1350 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var partner1351 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/OrganisationsByCountry/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var prefix1352 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var vat_id1353 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type1354 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/OrganisationsByCountry/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Organisation type..." });
    this.before_row_edit = function(record) {
      var bp = this.get_base_params();
      city1333.setContextValue('mk',bp['mk']);
      city1333.setContextValue('mt',bp['mt']);
      city1333.setContextValue('region',record ? record.data['regionHidden'] : undefined);
      var bp = this.get_base_params();
      region1339.setContextValue('mk',bp['mk']);
      region1339.setContextValue('mt',bp['mt']);
    };
    this.onRender = function(ct, position) {
      region1339.on('change',Lino.chooser_handler(city1333,'region'));
      Lino.partners.OrganisationsByCountry.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Place", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail'), "editor": city1333, "dataIndex": "city" }, { "colIndex": 1, "sortable": true, "header": "Street", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "street", "editor": street1334 }, { "colIndex": 2, "sortable": true, "header": "No.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "street_no", "editor": street_no1335 }, { "colIndex": 3, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "editor": name1336 }, { "colIndex": 4, "sortable": true, "header": "Language", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "editor": language1337 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1338, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 6, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('regionHidden','Lino.countries.Cities.detail'), "hidden": true, "editor": region1339, "dataIndex": "region" }, { "colIndex": 7, "sortable": true, "header": "Zip code", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "zip_code", "editor": zip_code1340 }, { "colIndex": 8, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "addr1", "editor": addr11341 }, { "colIndex": 9, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "street_prefix", "editor": street_prefix1342 }, { "colIndex": 10, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": Lino.chars2width(11), "dataIndex": "street_box", "editor": street_box1343 }, { "colIndex": 11, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "addr2", "editor": addr21344 }, { "colIndex": 12, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "email", "editor": email1345 }, { "colIndex": 13, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "url", "editor": url1346 }, { "colIndex": 14, "sortable": true, "header": "Phone", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "phone", "editor": phone1347 }, { "colIndex": 15, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "gsm", "editor": gsm1348 }, { "colIndex": 16, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "fax", "editor": fax1349 }, { "colIndex": 17, "sortable": false, "header": "Remarks", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "editor": remarks1350, "dataIndex": "remarks" }, { "colIndex": 18, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('partnerHidden','Lino.partners.Partners.detail'), "editor": partner1351, "dataIndex": "partner" }, { "colIndex": 19, "sortable": true, "header": "prefix", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "prefix", "editor": prefix1352 }, { "colIndex": 20, "sortable": true, "header": "VAT id", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "vat_id", "editor": vat_id1353 }, { "colIndex": 21, "sortable": true, "header": "Organisation type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "type", "editor": type1354 } ];
    Lino.partners.OrganisationsByCountry.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.partners.OrganisationsByCountry.insertPanel = Ext.extend(Lino.partners.Organisations.InsertFormPanel,{
  empty_title: "New Organisations",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/partners/OrganisationsByCountry",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.partners.OrganisationsByCountry.detail;
    this.ls_insert_handler = Lino.partners.OrganisationsByCountry.insert;
    Lino.partners.OrganisationsByCountry.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.partners.OrganisationsByCountry.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.partners.OrganisationsByCountry.insertPanel(p);
});

Lino.partners.OrganisationsByCountry.detailPanel = Ext.extend(Lino.partners.Organisations.DetailFormPanel,{
  empty_title: "Detail Organisations",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "merge_row", "menu_item_text": "Merge", "tooltip": "Merge this object into another object of same class.", "panel_btn_handler": Lino.param_action_handler(Lino.partners.Organisations.merge_row), "text": "Merge", "overflowText": "Merge", "auto_save": true } ],
  ls_url: "/partners/OrganisationsByCountry",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.partners.OrganisationsByCountry.detail;
    this.ls_insert_handler = Lino.partners.OrganisationsByCountry.insert;
    Lino.partners.OrganisationsByCountry.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.partners.OrganisationsByCountry.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.partners.OrganisationsByCountry.detailPanel(p);
});
Lino.partners.OrganisationsByCountry.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.partners.OrganisationsByCountry.GridPanel(p);
});

// js_render_GridPanel_class partners.ContactsByOrganisation
Lino.partners.ContactsByOrganisation.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/partners/ContactsByOrganisation",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Contact persons",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "person" }, 'personHidden', { "name": "role" }, 'roleHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 20,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var person11 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/ContactsByOrganisation/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Person..." });
    var role12 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/ContactsByOrganisation/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Contact Person..." });
    var id13 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Person", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('personHidden','Lino.partners.Persons.detail'), "editor": person11, "dataIndex": "person" }, { "colIndex": 1, "sortable": true, "header": "Contact Person", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "role", "editor": role12 }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "hidden": true, "editor": id13, "width": Lino.chars2width(5), "dataIndex": "id" }) ];
    Lino.partners.ContactsByOrganisation.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.partners.ContactsByOrganisation.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.partners.ContactsByOrganisation.GridPanel(p);
});

// js_render_GridPanel_class partners.ContactsByPerson
Lino.partners.ContactsByPerson.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/partners/ContactsByPerson",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Contact for",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "organisation" }, 'organisationHidden', { "name": "role" }, 'roleHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 20,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var organisation91 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/ContactsByPerson/organisation", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Organisation..." });
    var role92 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/partners/ContactsByPerson/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Contact Person..." });
    var id93 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Organisation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('organisationHidden','Lino.partners.Organisations.detail'), "editor": organisation91, "dataIndex": "organisation" }, { "colIndex": 1, "sortable": true, "header": "Contact Person", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "role", "editor": role92 }, new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "hidden": true, "editor": id93, "width": Lino.chars2width(5), "dataIndex": "id" }) ];
    Lino.partners.ContactsByPerson.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.partners.ContactsByPerson.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.partners.ContactsByPerson.GridPanel(p);
});

// js_render_GridPanel_class products.ProductsByCategory
Lino.products.ProductsByCategory.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/products/ProductsByCategory",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Products",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "cat" }, 'catHidden', { "type": "boolean", "name": "vatExempt" }, { "name": "price" }, { "name": "description" }, { "name": "sales_account" }, 'sales_accountHidden', { "name": "purchases_account" }, 'purchases_accountHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 24,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 14,
  initComponent : function() {
    this.ls_detail_handler = Lino.products.ProductsByCategory.detail;
    this.ls_insert_handler = Lino.products.ProductsByCategory.insert;
    var ww = this.containing_window;
    var id645 = new Ext.form.NumberField({ "selectOnFocus": true });
    var name646 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de647 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr648 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var cat649 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/products/ProductsByCategory/cat", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Product Category..." });
    var vatExempt650 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var price651 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var description652 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var sales_account653 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/products/ProductsByCategory/sales_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    var purchases_account654 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/products/ProductsByCategory/purchases_account", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Account..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id645, "width": Lino.chars2width(3), "dataIndex": "id" }), { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "editor": name646 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_de", "editor": name_de647 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "editor": name_fr648 }, { "colIndex": 4, "sortable": true, "header": "Category", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('catHidden','Lino.products.ProductCats.detail'), "editor": cat649, "dataIndex": "cat" }, { "colIndex": 5, "sortable": false, "xtype": "checkcolumn", "header": "VAT exempt", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "vatExempt" }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "header": "Price", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(6), "dataIndex": "price", "editor": price651 }), { "colIndex": 7, "sortable": false, "header": "Long description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "editor": description652, "dataIndex": "description" }, { "colIndex": 8, "sortable": true, "header": "Sales account", "editable": true, "tooltip": "The account to move when this product is used in a sales invoice.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "sales_account", "editor": sales_account653 }, { "colIndex": 9, "sortable": true, "header": "Purchases account", "editable": true, "tooltip": "The account to move when this product is used in a purchases invoice.", "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "purchases_account", "editor": purchases_account654 } ];
    Lino.products.ProductsByCategory.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.products.ProductsByCategory.insertPanel = Ext.extend(Lino.products.Products.DetailFormPanel,{
  empty_title: "New Products",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/products/ProductsByCategory",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.products.ProductsByCategory.detail;
    this.ls_insert_handler = Lino.products.ProductsByCategory.insert;
    Lino.products.ProductsByCategory.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.products.ProductsByCategory.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.products.ProductsByCategory.insertPanel(p);
});

Lino.products.ProductsByCategory.detailPanel = Ext.extend(Lino.products.Products.DetailFormPanel,{
  empty_title: "Detail Products",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/products/ProductsByCategory",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.products.ProductsByCategory.detail;
    this.ls_insert_handler = Lino.products.ProductsByCategory.insert;
    Lino.products.ProductsByCategory.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.products.ProductsByCategory.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.products.ProductsByCategory.detailPanel(p);
});
Lino.products.ProductsByCategory.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.products.ProductsByCategory.GridPanel(p);
});

// js_render_GridPanel_class accounts.GroupsByChart
Lino.accounts.GroupsByChart.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/accounts/GroupsByChart",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Account Groups",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "ref" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "account_type" }, 'account_typeHidden', { "type": "int", "name": "id" }, { "name": "help_text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 26,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.GroupsByChart.detail;
    this.ls_insert_handler = Lino.accounts.GroupsByChart.insert;
    var ww = this.containing_window;
    var ref700 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var name701 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de702 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr703 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var account_type704 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.accounts.AccountTypes });
    var id705 = new Ext.form.NumberField({ "selectOnFocus": true });
    var help_text706 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Introduction" });
    this.before_row_edit = function(record) {
      help_text706.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ref", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "ref", "editor": ref700 }, { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "editor": name701 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_de", "editor": name_de702 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "editor": name_fr703 }, { "colIndex": 4, "sortable": true, "header": "Account Type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "account_type", "editor": account_type704 }, new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id705, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 6, "sortable": false, "header": "help_text", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "editor": help_text706, "dataIndex": "help_text" } ];
    Lino.accounts.GroupsByChart.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.accounts.GroupsByChart.insertPanel = Ext.extend(Lino.accounts.Groups.DetailFormPanel,{
  empty_title: "New Account Groups",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/accounts/GroupsByChart",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.GroupsByChart.detail;
    this.ls_insert_handler = Lino.accounts.GroupsByChart.insert;
    Lino.accounts.GroupsByChart.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.GroupsByChart.insert = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.accounts.GroupsByChart.insertPanel(p);
});

Lino.accounts.GroupsByChart.detailPanel = Ext.extend(Lino.accounts.Groups.DetailFormPanel,{
  empty_title: "Detail Account Groups",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/accounts/GroupsByChart",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.accounts.GroupsByChart.detail;
    this.ls_insert_handler = Lino.accounts.GroupsByChart.insert;
    Lino.accounts.GroupsByChart.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.GroupsByChart.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.GroupsByChart.detailPanel(p);
});
Lino.accounts.GroupsByChart.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.GroupsByChart.GridPanel(p);
});

// js_render_GridPanel_class accounts.AccountsByGroup
Lino.accounts.AccountsByGroup.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/accounts/AccountsByGroup",
  ls_bbar_actions : [ { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Accounts",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "ref" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "type": "int", "name": "id" }, { "type": "int", "name": "seqno" }, { "name": "chart" }, 'chartHidden', { "name": "type" }, 'typeHidden', { "name": "help_text" }, { "type": "boolean", "name": "sales_allowed" }, { "type": "boolean", "name": "purchases_allowed" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 25,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 14,
  initComponent : function() {
    var ww = this.containing_window;
    var ref723 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 20 });
    var name724 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de725 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr726 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id727 = new Ext.form.NumberField({ "selectOnFocus": true });
    var seqno728 = new Ext.form.NumberField({ "selectOnFocus": true });
    var chart729 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/accounts/AccountsByGroup/chart", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account Chart..." });
    var type730 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.accounts.AccountTypes });
    var help_text731 = new Lino.RichTextPanel({ "selectOnFocus": true, "containing_panel": this, "title": "Introduction" });
    var sales_allowed732 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var purchases_allowed733 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
      help_text731.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ref", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "ref", "editor": ref723 }, { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name", "editor": name724 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_de", "editor": name_de725 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "name_fr", "editor": name_fr726 }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id727, "width": Lino.chars2width(5), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "width": Lino.chars2width(5), "editor": seqno728 }), { "colIndex": 6, "sortable": true, "header": "Account Chart", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('chartHidden','Lino.accounts.Charts.detail'), "editor": chart729, "dataIndex": "chart" }, { "colIndex": 7, "sortable": true, "header": "Account Type", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(16), "dataIndex": "type", "editor": type730 }, { "colIndex": 8, "sortable": false, "header": "help_text", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "editor": help_text731, "dataIndex": "help_text" }, { "colIndex": 9, "sortable": false, "xtype": "checkcolumn", "header": "Sales", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "sales_allowed" }, { "colIndex": 10, "sortable": false, "xtype": "checkcolumn", "header": "Purchases", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "purchases_allowed" } ];
    Lino.accounts.AccountsByGroup.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.AccountsByGroup.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.AccountsByGroup.GridPanel(p);
});

// js_render_GridPanel_class ledger.MovementsByVoucher
Lino.ledger.MovementsByVoucher.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/ledger/MovementsByVoucher",
  ls_bbar_actions : [ { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Movements",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "seqno" }, { "name": "account" }, 'accountHidden', { "name": "debit" }, { "name": "credit" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 32,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    var ww = this.containing_window;
    var seqno170 = new Ext.form.NumberField({ "selectOnFocus": true });
    var account171 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/MovementsByVoucher/account", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account..." });
    var debit172 = new Ext.form.NumberField({ "disabled": true, "decimalPrecision": 2, "decimalSeparator": "," });
    var credit173 = new Ext.form.NumberField({ "disabled": true, "decimalPrecision": 2, "decimalSeparator": "," });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "width": Lino.chars2width(5), "editor": seqno170 }), { "colIndex": 1, "sortable": true, "header": "Account", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "account", "editor": account171 }, new Lino.NullNumberColumn({ "width": Lino.chars2width(12), "colIndex": 2, "sortable": false, "dataIndex": "debit", "header": "Debit", "editable": false }), new Lino.NullNumberColumn({ "width": Lino.chars2width(12), "colIndex": 3, "sortable": false, "dataIndex": "credit", "header": "Credit", "editable": false }) ];
    Lino.ledger.MovementsByVoucher.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.MovementsByVoucher.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.MovementsByVoucher.GridPanel(p);
});

// js_render_GridPanel_class ledger.MovementsByPartner
Lino.ledger.MovementsByPartner.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/ledger/MovementsByPartner",
  ls_bbar_actions : [ { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Movements",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "voucher__date", "dateFormat": "d.m.Y" }, { "name": "voucher_link" }, { "name": "debit" }, { "name": "credit" }, { "name": "account" }, 'accountHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 32,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var voucher__date187 = new Lino.DateField({ "disabled": true });
    var voucher_link_disp188 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var debit189 = new Ext.form.NumberField({ "disabled": true, "decimalPrecision": 2, "decimalSeparator": "," });
    var credit190 = new Ext.form.NumberField({ "disabled": true, "decimalPrecision": 2, "decimalSeparator": "," });
    var account191 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/MovementsByPartner/account", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": false, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "voucher__date", "width": Lino.chars2width(8) }, { "width": Lino.chars2width(30), "colIndex": 1, "sortable": false, "dataIndex": "voucher_link", "header": "Voucher", "editable": false }, new Lino.NullNumberColumn({ "width": Lino.chars2width(12), "colIndex": 2, "sortable": false, "dataIndex": "debit", "header": "Debit", "editable": false }), new Lino.NullNumberColumn({ "width": Lino.chars2width(12), "colIndex": 3, "sortable": false, "dataIndex": "credit", "header": "Credit", "editable": false }), { "colIndex": 4, "sortable": true, "header": "Account", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "account", "editor": account191 } ];
    Lino.ledger.MovementsByPartner.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.MovementsByPartner.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.MovementsByPartner.GridPanel(p);
});

// js_render_GridPanel_class ledger.InvoicesByJournal
Lino.ledger.InvoicesByJournal.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/ledger/InvoicesByJournal",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Invoices",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "number" }, { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "due_date", "dateFormat": "d.m.Y" }, { "name": "partner" }, 'partnerHidden', { "name": "total_incl" }, { "name": "total_base" }, { "name": "total_vat" }, { "name": "user" }, 'userHidden', { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "year" }, 'yearHidden', { "name": "narration" }, { "name": "declared_in" }, 'declared_inHidden', { "type": "boolean", "name": "item_vat" }, { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "your_ref" }, { "name": "state" }, 'stateHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 11,
  ls_grid_configs : [  ],
  content_type : 30,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 24,
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.InvoicesByJournal.detail;
    this.ls_insert_handler = Lino.ledger.InvoicesByJournal.insert;
    var ww = this.containing_window;
    var number1356 = new Ext.form.NumberField({ "selectOnFocus": true });
    var date1357 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var due_date1358 = new Lino.DateField({ "selectOnFocus": true });
    var partner1359 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/InvoicesByJournal/partner", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Partner..." });
    var total_incl1360 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_base1361 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat1362 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var user1363 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/InvoicesByJournal/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var workflow_buttons_disp1364 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var id1365 = new Ext.form.NumberField({ "selectOnFocus": true });
    var year1366 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.ledger.FiscalYears });
    var narration1367 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var declared_in1368 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/InvoicesByJournal/declared_in", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a VAT declaration..." });
    var item_vat1369 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var vat_regime1370 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.vat.VatRegimes });
    var your_ref1371 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var state1372 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.ledger.InvoiceStates });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(5), "editor": number1356 }), { "colIndex": 1, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "editor": date1357, "width": Lino.chars2width(8), "dataIndex": "date" }, { "colIndex": 2, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Due date", "editor": due_date1358, "width": Lino.chars2width(8), "dataIndex": "due_date" }, { "colIndex": 3, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('partnerHidden','Lino.partners.Partners.detail'), "editor": partner1359, "dataIndex": "partner" }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "header": "Total incl. VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_incl", "editor": total_incl1360 }), new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "header": "Total excl. VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_base", "editor": total_base1361 }), new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "header": "VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_vat", "editor": total_vat1362 }), { "colIndex": 7, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1363, "dataIndex": "user" }, { "width": Lino.chars2width(30), "colIndex": 8, "sortable": false, "dataIndex": "workflow_buttons", "header": "Workflow", "editable": false }, new Lino.NullNumberColumn({ "colIndex": 9, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1365, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 10, "sortable": true, "header": "Fiscal Year", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(7), "dataIndex": "year", "editor": year1366 }, { "colIndex": 11, "sortable": true, "header": "Narration", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "narration", "editor": narration1367 }, { "colIndex": 12, "sortable": true, "header": "VAT declaration", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('declared_inHidden','Lino.declarations.Declarations.detail'), "editor": declared_in1368, "dataIndex": "declared_in" }, { "colIndex": 13, "sortable": false, "xtype": "checkcolumn", "header": "Prices include VAT", "editable": true, "tooltip": "Whether prices includes VAT or not.", "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "item_vat" }, { "colIndex": 14, "sortable": true, "header": "VAT Regime", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(18), "dataIndex": "vat_regime", "editor": vat_regime1370 }, { "colIndex": 15, "sortable": true, "header": "Your reference", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "your_ref", "editor": your_ref1371 }, { "colIndex": 16, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "state", "editor": state1372 } ];
    Lino.ledger.InvoicesByJournal.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.InvoicesByJournal.insertPanel = Ext.extend(Lino.ledger.Invoices.InsertFormPanel,{
  empty_title: "New Invoices",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/ledger/InvoicesByJournal",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.InvoicesByJournal.detail;
    this.ls_insert_handler = Lino.ledger.InvoicesByJournal.insert;
    Lino.ledger.InvoicesByJournal.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.InvoicesByJournal.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.ledger.InvoicesByJournal.insertPanel(p);
});

Lino.ledger.InvoicesByJournal.detailPanel = Ext.extend(Lino.ledger.Invoices.DetailFormPanel,{
  empty_title: "Detail Invoices",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/ledger/InvoicesByJournal",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.InvoicesByJournal.detail;
    this.ls_insert_handler = Lino.ledger.InvoicesByJournal.insert;
    Lino.ledger.InvoicesByJournal.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.InvoicesByJournal.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.InvoicesByJournal.detailPanel(p);
});
Lino.ledger.InvoicesByJournal.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.ledger.Invoices.ParamsPanel({});
  return new Lino.ledger.InvoicesByJournal.GridPanel(p);
});
Lino.ledger.InvoicesByJournal.deregister_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/InvoicesByJournal",pk,"deregister_action");
};
Lino.ledger.InvoicesByJournal.register_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/InvoicesByJournal",pk,"register_action");
};

// js_render_GridPanel_class ledger.InvoicesByPartner
Lino.ledger.InvoicesByPartner.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/ledger/InvoicesByPartner",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Unregistered invoices",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "total_incl" }, { "name": "total_base" }, { "name": "total_vat" }, { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "journal" }, 'journalHidden', { "name": "year" }, 'yearHidden', { "type": "int", "name": "number" }, { "name": "narration" }, { "name": "declared_in" }, 'declared_inHidden', { "type": "boolean", "name": "item_vat" }, { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "your_ref" }, { "type": "date", "name": "due_date", "dateFormat": "d.m.Y" }, { "name": "state" }, 'stateHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 30,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 23,
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.InvoicesByPartner.detail;
    this.ls_insert_handler = Lino.ledger.InvoicesByPartner.insert;
    var ww = this.containing_window;
    var date99 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var total_incl100 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_base101 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat102 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var id103 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user104 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/InvoicesByPartner/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var journal105 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/InvoicesByPartner/journal", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Journal..." });
    var year106 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.ledger.FiscalYears });
    var number107 = new Ext.form.NumberField({ "selectOnFocus": true });
    var narration108 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var declared_in109 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/InvoicesByPartner/declared_in", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a VAT declaration..." });
    var item_vat110 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var vat_regime111 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.vat.VatRegimes });
    var your_ref112 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var due_date113 = new Lino.DateField({ "selectOnFocus": true });
    var state114 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.ledger.InvoiceStates });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "editor": date99, "width": Lino.chars2width(8), "dataIndex": "date" }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "header": "Total incl. VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_incl", "editor": total_incl100 }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "header": "Total excl. VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_base", "editor": total_base101 }), new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "header": "VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_vat", "editor": total_vat102 }), new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id103, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user104, "dataIndex": "user" }, { "colIndex": 6, "sortable": true, "header": "Journal", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('journalHidden','Lino.ledger.Journals.detail'), "editor": journal105, "dataIndex": "journal" }, { "colIndex": 7, "sortable": true, "header": "Fiscal Year", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(7), "dataIndex": "year", "editor": year106 }, new Lino.NullNumberColumn({ "colIndex": 8, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(5), "editor": number107 }), { "colIndex": 9, "sortable": true, "header": "Narration", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "narration", "editor": narration108 }, { "colIndex": 10, "sortable": true, "header": "VAT declaration", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('declared_inHidden','Lino.declarations.Declarations.detail'), "editor": declared_in109, "dataIndex": "declared_in" }, { "colIndex": 11, "sortable": false, "xtype": "checkcolumn", "header": "Prices include VAT", "editable": true, "tooltip": "Whether prices includes VAT or not.", "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "item_vat" }, { "colIndex": 12, "sortable": true, "header": "VAT Regime", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(18), "dataIndex": "vat_regime", "editor": vat_regime111 }, { "colIndex": 13, "sortable": true, "header": "Your reference", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "your_ref", "editor": your_ref112 }, { "colIndex": 14, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Due date", "editor": due_date113, "width": Lino.chars2width(8), "dataIndex": "due_date" }, { "colIndex": 15, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "state", "editor": state114 } ];
    Lino.ledger.InvoicesByPartner.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.ledger.InvoicesByPartner.insertPanel = Ext.extend(Lino.ledger.Invoices.InsertFormPanel,{
  empty_title: "New Unregistered invoices",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/ledger/InvoicesByPartner",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.InvoicesByPartner.detail;
    this.ls_insert_handler = Lino.ledger.InvoicesByPartner.insert;
    Lino.ledger.InvoicesByPartner.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.InvoicesByPartner.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.ledger.InvoicesByPartner.insertPanel(p);
});

Lino.ledger.InvoicesByPartner.detailPanel = Ext.extend(Lino.ledger.Invoices.DetailFormPanel,{
  empty_title: "Detail Unregistered invoices",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/ledger/InvoicesByPartner",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.ledger.InvoicesByPartner.detail;
    this.ls_insert_handler = Lino.ledger.InvoicesByPartner.insert;
    Lino.ledger.InvoicesByPartner.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.InvoicesByPartner.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.InvoicesByPartner.detailPanel(p);
});
Lino.ledger.InvoicesByPartner.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.ledger.Invoices.ParamsPanel({});
  return new Lino.ledger.InvoicesByPartner.GridPanel(p);
});
Lino.ledger.InvoicesByPartner.deregister_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/InvoicesByPartner",pk,"deregister_action");
};
Lino.ledger.InvoicesByPartner.register_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/ledger/InvoicesByPartner",pk,"register_action");
};

// js_render_GridPanel_class ledger.ItemsByInvoice
Lino.ledger.ItemsByInvoice.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/ledger/ItemsByInvoice",
  ls_bbar_actions : [ { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Voucher items",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "account" }, 'accountHidden', { "name": "title" }, { "name": "vat_class" }, 'vat_classHidden', { "name": "total_base" }, { "name": "total_vat" }, { "name": "total_incl" }, { "type": "int", "name": "seqno" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 9,
  ls_grid_configs : [  ],
  content_type : 29,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    var ww = this.containing_window;
    var account141 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ledger/ItemsByInvoice/account", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account..." });
    var title142 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var vat_class143 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.vat.VatClasses });
    var total_base144 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat145 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_incl146 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var seqno147 = new Ext.form.NumberField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      var bp = this.get_base_params();
      account141.setContextValue('mk',bp['mk']);
      account141.setContextValue('mt',bp['mt']);
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Account", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "account", "editor": account141 }, { "colIndex": 1, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "title", "editor": title142 }, { "colIndex": 2, "sortable": true, "header": "VAT Class", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "vat_class", "editor": vat_class143 }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "header": "Total excl. VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_base", "editor": total_base144 }), new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "header": "VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_vat", "editor": total_vat145 }), new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "header": "Total incl. VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_incl", "editor": total_incl146 }), new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "width": Lino.chars2width(5), "editor": seqno147 }) ];
    Lino.ledger.ItemsByInvoice.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.ItemsByInvoice.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.ItemsByInvoice.GridPanel(p);
});

// js_render_GridPanel_class declarations.VouchersByDeclaration
Lino.declarations.VouchersByDeclaration.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "emptyText": "No data to display." },
  ls_url : "/declarations/VouchersByDeclaration",
  ls_bbar_actions : [  ],
  title : "Vouchers",
  page_length : 20,
  stripeRows : true,
  disable_editing : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "type": "int", "name": "number" }, { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "journal" }, 'journalHidden', { "name": "year" }, 'yearHidden', { "name": "narration" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    var ww = this.containing_window;
    var date809 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var number810 = new Ext.form.NumberField({ "selectOnFocus": true });
    var id811 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user812 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/declarations/VouchersByDeclaration/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var journal813 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/declarations/VouchersByDeclaration/journal", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Journal..." });
    var year814 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.ledger.FiscalYears });
    var narration815 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "editor": date809, "width": Lino.chars2width(8), "dataIndex": "date" }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(5), "editor": number810 }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id811, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 3, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user812, "dataIndex": "user" }, { "colIndex": 4, "sortable": true, "header": "Journal", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('journalHidden','Lino.ledger.Journals.detail'), "editor": journal813, "dataIndex": "journal" }, { "colIndex": 5, "sortable": true, "header": "Fiscal Year", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(7), "dataIndex": "year", "editor": year814 }, { "colIndex": 6, "sortable": true, "header": "Narration", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "narration", "editor": narration815 } ];
    Lino.declarations.VouchersByDeclaration.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.declarations.VouchersByDeclaration.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.declarations.VouchersByDeclaration.GridPanel(p);
});

// js_render_GridPanel_class declarations.DeclarationsByJournal
Lino.declarations.DeclarationsByJournal.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/declarations/DeclarationsByJournal",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "VAT declarations",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "number" }, { "name": "period" }, 'periodHidden', { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "user" }, 'userHidden', { "type": "int", "name": "id" }, { "name": "year" }, 'yearHidden', { "name": "narration" }, { "name": "declared_in" }, 'declared_inHidden', { "name": "state" }, 'stateHidden', { "name": "sales_base" }, { "name": "sales_vat" }, { "name": "purchases_base" }, { "name": "purchases_vat" }, { "name": "purchases_investments" }, { "name": "purchases_ware" }, { "name": "purchases_services" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 33,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 22,
  initComponent : function() {
    this.ls_detail_handler = Lino.declarations.DeclarationsByJournal.detail;
    this.ls_insert_handler = Lino.declarations.DeclarationsByJournal.insert;
    var ww = this.containing_window;
    var number1374 = new Ext.form.NumberField({ "selectOnFocus": true });
    var period1375 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.declarations.DeclarationPeriods });
    var date1376 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var user1377 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/declarations/DeclarationsByJournal/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var id1378 = new Ext.form.NumberField({ "selectOnFocus": true });
    var year1379 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.ledger.FiscalYears });
    var narration1380 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var declared_in1381 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/declarations/DeclarationsByJournal/declared_in", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a VAT declaration..." });
    var state1382 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.declarations.DeclarationStates });
    var sales_base1383 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": false, "decimalSeparator": "," });
    var sales_vat1384 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": false, "decimalSeparator": "," });
    var purchases_base1385 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": false, "decimalSeparator": "," });
    var purchases_vat1386 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": false, "decimalSeparator": "," });
    var purchases_investments1387 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": false, "decimalSeparator": "," });
    var purchases_ware1388 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": false, "decimalSeparator": "," });
    var purchases_services1389 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": false, "decimalSeparator": "," });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(5), "editor": number1374 }), { "colIndex": 1, "sortable": true, "header": "VAT Period", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(12), "dataIndex": "period", "editor": period1375 }, { "colIndex": 2, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "editor": date1376, "width": Lino.chars2width(8), "dataIndex": "date" }, { "colIndex": 3, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1377, "dataIndex": "user" }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1378, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Fiscal Year", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(7), "dataIndex": "year", "editor": year1379 }, { "colIndex": 6, "sortable": true, "header": "Narration", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "narration", "editor": narration1380 }, { "colIndex": 7, "sortable": true, "header": "VAT declaration", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('declared_inHidden','Lino.declarations.Declarations.detail'), "editor": declared_in1381, "dataIndex": "declared_in" }, { "colIndex": 8, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "state", "editor": state1382 }, new Lino.NullNumberColumn({ "colIndex": 9, "sortable": true, "header": "Sales base", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "sales_base", "editor": sales_base1383 }), new Lino.NullNumberColumn({ "colIndex": 10, "sortable": true, "header": "Sales VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "sales_vat", "editor": sales_vat1384 }), new Lino.NullNumberColumn({ "colIndex": 11, "sortable": true, "header": "Purchases base", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "purchases_base", "editor": purchases_base1385 }), new Lino.NullNumberColumn({ "colIndex": 12, "sortable": true, "header": "Purchases VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "purchases_vat", "editor": purchases_vat1386 }), new Lino.NullNumberColumn({ "colIndex": 13, "sortable": true, "header": "Investments", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "purchases_investments", "editor": purchases_investments1387 }), new Lino.NullNumberColumn({ "colIndex": 14, "sortable": true, "header": "Ware", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "purchases_ware", "editor": purchases_ware1388 }), new Lino.NullNumberColumn({ "colIndex": 15, "sortable": true, "header": "Services", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "purchases_services", "editor": purchases_services1389 }) ];
    Lino.declarations.DeclarationsByJournal.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.declarations.DeclarationsByJournal.insertPanel = Ext.extend(Lino.declarations.Declarations.InsertFormPanel,{
  empty_title: "New VAT declarations",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/declarations/DeclarationsByJournal",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.declarations.DeclarationsByJournal.detail;
    this.ls_insert_handler = Lino.declarations.DeclarationsByJournal.insert;
    Lino.declarations.DeclarationsByJournal.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.declarations.DeclarationsByJournal.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.declarations.DeclarationsByJournal.insertPanel(p);
});

Lino.declarations.DeclarationsByJournal.detailPanel = Ext.extend(Lino.declarations.Declarations.DetailFormPanel,{
  empty_title: "Detail VAT declarations",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/declarations/DeclarationsByJournal",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.declarations.DeclarationsByJournal.detail;
    this.ls_insert_handler = Lino.declarations.DeclarationsByJournal.insert;
    Lino.declarations.DeclarationsByJournal.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.declarations.DeclarationsByJournal.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.declarations.DeclarationsByJournal.detailPanel(p);
});
Lino.declarations.DeclarationsByJournal.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.declarations.DeclarationsByJournal.GridPanel(p);
});

// js_render_GridPanel_class sales.InvoicesByJournal
Lino.sales.InvoicesByJournal.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/sales/InvoicesByJournal",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Clear cache", "auto_save": true } ],
  title : "Invoices",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "number" }, { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "due_date", "dateFormat": "d.m.Y" }, { "name": "partner" }, 'partnerHidden', { "name": "total_incl" }, { "name": "subject" }, { "name": "total_base" }, { "name": "total_vat" }, { "name": "user" }, 'userHidden', { "type": "int", "name": "id" }, { "name": "year" }, 'yearHidden', { "name": "narration" }, { "name": "declared_in" }, 'declared_inHidden', { "name": "build_time" }, { "type": "boolean", "name": "item_vat" }, { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "language" }, 'languageHidden', { "name": "your_ref" }, { "name": "imode" }, 'imodeHidden', { "name": "shipping_mode" }, 'shipping_modeHidden', { "name": "payment_term" }, 'payment_termHidden', { "name": "intro" }, { "name": "discount" }, { "name": "state" }, 'stateHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 11,
  ls_grid_configs : [  ],
  content_type : 38,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 35,
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.InvoicesByJournal.detail;
    this.ls_insert_handler = Lino.sales.InvoicesByJournal.insert;
    var ww = this.containing_window;
    var number1391 = new Ext.form.NumberField({ "selectOnFocus": true });
    var date1392 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var due_date1393 = new Lino.DateField({ "selectOnFocus": true });
    var partner1394 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoicesByJournal/partner", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Partner..." });
    var total_incl1395 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var subject1396 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var total_base1397 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat1398 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var user1399 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoicesByJournal/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var id1400 = new Ext.form.NumberField({ "selectOnFocus": true });
    var year1401 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.ledger.FiscalYears });
    var narration1402 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var declared_in1403 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoicesByJournal/declared_in", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a VAT declaration..." });
    var build_time1404 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var item_vat1405 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var vat_regime1406 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.vat.VatRegimes });
    var language1407 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "allowBlank": false, "value": "en" });
    var your_ref1408 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var imode1409 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoicesByJournal/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Invoicing Mode..." });
    var shipping_mode1410 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoicesByJournal/shipping_mode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Shipping Mode..." });
    var payment_term1411 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoicesByJournal/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Payment Term..." });
    var intro1412 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var discount1413 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var state1414 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.sales.InvoiceStates });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(5), "editor": number1391 }), { "colIndex": 1, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "editor": date1392, "width": Lino.chars2width(8), "dataIndex": "date" }, { "colIndex": 2, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date of payment", "editor": due_date1393, "width": Lino.chars2width(8), "dataIndex": "due_date" }, { "colIndex": 3, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('partnerHidden','Lino.partners.Partners.detail'), "editor": partner1394, "dataIndex": "partner" }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "header": "Total incl. VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_incl", "editor": total_incl1395 }), { "colIndex": 5, "sortable": true, "header": "Subject line", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "subject", "editor": subject1396 }, new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "header": "Total excl. VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_base", "editor": total_base1397 }), new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "header": "VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_vat", "editor": total_vat1398 }), { "colIndex": 8, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1399, "dataIndex": "user" }, new Lino.NullNumberColumn({ "colIndex": 9, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1400, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 10, "sortable": true, "header": "Fiscal Year", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(7), "dataIndex": "year", "editor": year1401 }, { "colIndex": 11, "sortable": true, "header": "Narration", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "narration", "editor": narration1402 }, { "colIndex": 12, "sortable": true, "header": "VAT declaration", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('declared_inHidden','Lino.declarations.Declarations.detail'), "editor": declared_in1403, "dataIndex": "declared_in" }, { "width": Lino.chars2width(16), "colIndex": 13, "sortable": true, "dataIndex": "build_time", "header": "build time", "editable": false }, { "colIndex": 14, "sortable": false, "xtype": "checkcolumn", "header": "Prices include VAT", "editable": true, "tooltip": "Whether prices includes VAT or not.", "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "item_vat" }, { "colIndex": 15, "sortable": true, "header": "VAT Regime", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(18), "dataIndex": "vat_regime", "editor": vat_regime1406 }, { "colIndex": 16, "sortable": true, "header": "Language", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "editor": language1407 }, { "colIndex": 17, "sortable": true, "header": "Your reference", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "your_ref", "editor": your_ref1408 }, { "colIndex": 18, "sortable": true, "header": "Invoicing Mode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "imode", "editor": imode1409 }, { "colIndex": 19, "sortable": true, "header": "Shipping Mode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "shipping_mode", "editor": shipping_mode1410 }, { "colIndex": 20, "sortable": true, "header": "Payment Term", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "payment_term", "editor": payment_term1411 }, { "colIndex": 21, "sortable": false, "header": "Introductive Text", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "editor": intro1412, "dataIndex": "intro" }, new Lino.NullNumberColumn({ "colIndex": 22, "sortable": true, "header": "Discount", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(7), "dataIndex": "discount", "editor": discount1413 }), { "colIndex": 23, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "state", "editor": state1414 } ];
    Lino.sales.InvoicesByJournal.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.sales.InvoicesByJournal.insertPanel = Ext.extend(Lino.sales.Invoices.InsertFormPanel,{
  empty_title: "New Invoices",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/sales/InvoicesByJournal",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.InvoicesByJournal.detail;
    this.ls_insert_handler = Lino.sales.InvoicesByJournal.insert;
    Lino.sales.InvoicesByJournal.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.InvoicesByJournal.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.sales.InvoicesByJournal.insertPanel(p);
});

Lino.sales.InvoicesByJournal.detailPanel = Ext.extend(Lino.sales.Invoices.DetailFormPanel,{
  empty_title: "Detail Invoices",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Clear cache", "auto_save": true } ],
  ls_url: "/sales/InvoicesByJournal",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.InvoicesByJournal.detail;
    this.ls_insert_handler = Lino.sales.InvoicesByJournal.insert;
    Lino.sales.InvoicesByJournal.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.InvoicesByJournal.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.InvoicesByJournal.detailPanel(p);
});
Lino.sales.InvoicesByJournal.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.sales.Invoices.ParamsPanel({});
  return new Lino.sales.InvoicesByJournal.GridPanel(p);
});
Lino.sales.InvoicesByJournal.deregister_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoicesByJournal",pk,"deregister_action");
};
Lino.sales.InvoicesByJournal.register_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoicesByJournal",pk,"register_action");
};

// js_render_GridPanel_class sales.ItemsByInvoice
Lino.sales.ItemsByInvoice.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/sales/ItemsByInvoice",
  ls_bbar_actions : [ { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Voucher items",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "seqno" }, { "name": "product" }, 'productHidden', { "name": "title" }, { "name": "description" }, { "name": "discount" }, { "name": "unit_price" }, { "name": "qty" }, { "name": "total_incl" }, { "name": "total_base" }, { "name": "total_vat" }, { "name": "productdocitem_ptr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 11,
  ls_grid_configs : [  ],
  content_type : 35,
  ls_id_property : "productdocitem_ptr",
  gc_name : 0,
  disabled_actions_index : 13,
  initComponent : function() {
    var ww = this.containing_window;
    var seqno579 = new Ext.form.NumberField({ "selectOnFocus": true });
    var product580 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/ItemsByInvoice/product", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Product..." });
    var title581 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var description582 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var discount583 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var unit_price584 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var qty585 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(6), "maxLength": 6 });
    var total_incl586 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_base587 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat588 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "hidden": true, "width": Lino.chars2width(3), "editor": seqno579 }), { "colIndex": 1, "sortable": true, "header": "Product", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('productHidden','Lino.products.Products.detail'), "editor": product580, "dataIndex": "product" }, { "colIndex": 2, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "title", "editor": title581 }, { "colIndex": 3, "sortable": false, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.text_renderer, "hidden": true, "editor": description582, "dataIndex": "description" }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "header": "Discount", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(7), "dataIndex": "discount", "editor": discount583 }), new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "header": "Unit price", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "unit_price", "editor": unit_price584 }), { "colIndex": 6, "sortable": true, "format": "", "align": "right", "editable": true, "filter": { "type": "string" }, "header": "Quantity", "dataIndex": "qty", "width": Lino.chars2width(7), "editor": qty585 }, new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "header": "Total incl. VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_incl", "editor": total_incl586 }), new Lino.NullNumberColumn({ "colIndex": 8, "sortable": true, "header": "Total excl. VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_base", "hidden": true, "editor": total_base587 }), new Lino.NullNumberColumn({ "colIndex": 9, "sortable": true, "header": "VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_vat", "hidden": true, "editor": total_vat588 }) ];
    Lino.sales.ItemsByInvoice.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.ItemsByInvoice.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.ItemsByInvoice.GridPanel(p);
});

// js_render_GridPanel_class sales.InvoiceItemsByProduct
Lino.sales.InvoiceItemsByProduct.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/sales/InvoiceItemsByProduct",
  ls_bbar_actions : [ { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Voucher items",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "seqno" }, { "name": "product" }, 'productHidden', { "name": "title" }, { "name": "description" }, { "name": "discount" }, { "name": "unit_price" }, { "name": "qty" }, { "name": "total_incl" }, { "name": "total_base" }, { "name": "total_vat" }, { "name": "productdocitem_ptr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 11,
  ls_grid_configs : [  ],
  content_type : 35,
  ls_id_property : "productdocitem_ptr",
  gc_name : 0,
  disabled_actions_index : 13,
  initComponent : function() {
    var ww = this.containing_window;
    var seqno675 = new Ext.form.NumberField({ "selectOnFocus": true });
    var product676 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoiceItemsByProduct/product", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Product..." });
    var title677 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var description678 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var discount679 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var unit_price680 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var qty681 = new Ext.form.TextField({ "selectOnFocus": true, "boxMinWidth": Lino.chars2width(6), "maxLength": 6 });
    var total_incl682 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_base683 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat684 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ new Lino.NullNumberColumn({ "colIndex": 0, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "hidden": true, "width": Lino.chars2width(3), "editor": seqno675 }), { "colIndex": 1, "sortable": true, "header": "Product", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('productHidden','Lino.products.Products.detail'), "editor": product676, "dataIndex": "product" }, { "colIndex": 2, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "title", "editor": title677 }, { "colIndex": 3, "sortable": false, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.text_renderer, "hidden": true, "editor": description678, "dataIndex": "description" }, new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "header": "Discount", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(7), "dataIndex": "discount", "editor": discount679 }), new Lino.NullNumberColumn({ "colIndex": 5, "sortable": true, "header": "Unit price", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "unit_price", "editor": unit_price680 }), { "colIndex": 6, "sortable": true, "format": "", "align": "right", "editable": true, "filter": { "type": "string" }, "header": "Quantity", "dataIndex": "qty", "width": Lino.chars2width(7), "editor": qty681 }, new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "header": "Total incl. VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_incl", "editor": total_incl682 }), new Lino.NullNumberColumn({ "colIndex": 8, "sortable": true, "header": "Total excl. VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_base", "hidden": true, "editor": total_base683 }), new Lino.NullNumberColumn({ "colIndex": 9, "sortable": true, "header": "VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_vat", "hidden": true, "editor": total_vat684 }) ];
    Lino.sales.InvoiceItemsByProduct.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.InvoiceItemsByProduct.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.InvoiceItemsByProduct.GridPanel(p);
});

// js_render_GridPanel_class sales.InvoicesByPartner
Lino.sales.InvoicesByPartner.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/sales/InvoicesByPartner",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Clear cache", "auto_save": true } ],
  title : "Invoices",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "total_incl" }, { "name": "total_base" }, { "name": "total_vat" }, { "type": "int", "name": "id" }, { "name": "user" }, 'userHidden', { "name": "journal" }, 'journalHidden', { "name": "year" }, 'yearHidden', { "type": "int", "name": "number" }, { "name": "narration" }, { "name": "declared_in" }, 'declared_inHidden', { "name": "build_time" }, { "type": "boolean", "name": "item_vat" }, { "name": "vat_regime" }, 'vat_regimeHidden', { "name": "language" }, 'languageHidden', { "name": "your_ref" }, { "name": "imode" }, 'imodeHidden', { "name": "shipping_mode" }, 'shipping_modeHidden', { "name": "payment_term" }, 'payment_termHidden', { "name": "subject" }, { "name": "intro" }, { "name": "discount" }, { "type": "date", "name": "due_date", "dateFormat": "d.m.Y" }, { "name": "state" }, 'stateHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 38,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 35,
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.InvoicesByPartner.detail;
    this.ls_insert_handler = Lino.sales.InvoicesByPartner.insert;
    var ww = this.containing_window;
    var date516 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var total_incl517 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_base518 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var total_vat519 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var id520 = new Ext.form.NumberField({ "selectOnFocus": true });
    var user521 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoicesByPartner/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var journal522 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoicesByPartner/journal", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Journal..." });
    var year523 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.ledger.FiscalYears });
    var number524 = new Ext.form.NumberField({ "selectOnFocus": true });
    var narration525 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var declared_in526 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoicesByPartner/declared_in", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a VAT declaration..." });
    var build_time527 = new Ext.form.DisplayField({ "disabled": true, "value": "<br>" });
    var item_vat528 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var vat_regime529 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.vat.VatRegimes });
    var language530 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "allowBlank": false, "value": "en" });
    var your_ref531 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var imode532 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoicesByPartner/imode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Invoicing Mode..." });
    var shipping_mode533 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoicesByPartner/shipping_mode", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Shipping Mode..." });
    var payment_term534 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/sales/InvoicesByPartner/payment_term", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Payment Term..." });
    var subject535 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var intro536 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var discount537 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var due_date538 = new Lino.DateField({ "selectOnFocus": true });
    var state539 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.sales.InvoiceStates });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "editor": date516, "width": Lino.chars2width(8), "dataIndex": "date" }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "header": "Total incl. VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_incl", "editor": total_incl517 }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "header": "Total excl. VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_base", "editor": total_base518 }), new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "header": "VAT", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "total_vat", "editor": total_vat519 }), new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id520, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 5, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user521, "dataIndex": "user" }, { "colIndex": 6, "sortable": true, "header": "Journal", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('journalHidden','Lino.ledger.Journals.detail'), "editor": journal522, "dataIndex": "journal" }, { "colIndex": 7, "sortable": true, "header": "Fiscal Year", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(7), "dataIndex": "year", "editor": year523 }, new Lino.NullNumberColumn({ "colIndex": 8, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(5), "editor": number524 }), { "colIndex": 9, "sortable": true, "header": "Narration", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "narration", "editor": narration525 }, { "colIndex": 10, "sortable": true, "header": "VAT declaration", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('declared_inHidden','Lino.declarations.Declarations.detail'), "editor": declared_in526, "dataIndex": "declared_in" }, { "width": Lino.chars2width(16), "colIndex": 11, "sortable": true, "dataIndex": "build_time", "header": "build time", "editable": false }, { "colIndex": 12, "sortable": false, "xtype": "checkcolumn", "header": "Prices include VAT", "editable": true, "tooltip": "Whether prices includes VAT or not.", "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "item_vat" }, { "colIndex": 13, "sortable": true, "header": "VAT Regime", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(18), "dataIndex": "vat_regime", "editor": vat_regime529 }, { "colIndex": 14, "sortable": true, "header": "Language", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "language", "editor": language530 }, { "colIndex": 15, "sortable": true, "header": "Your reference", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "your_ref", "editor": your_ref531 }, { "colIndex": 16, "sortable": true, "header": "Invoicing Mode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "imode", "editor": imode532 }, { "colIndex": 17, "sortable": true, "header": "Shipping Mode", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "shipping_mode", "editor": shipping_mode533 }, { "colIndex": 18, "sortable": true, "header": "Payment Term", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "payment_term", "editor": payment_term534 }, { "colIndex": 19, "sortable": true, "header": "Subject line", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "subject", "editor": subject535 }, { "colIndex": 20, "sortable": false, "header": "Introductive Text", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "editor": intro536, "dataIndex": "intro" }, new Lino.NullNumberColumn({ "colIndex": 21, "sortable": true, "header": "Discount", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(7), "dataIndex": "discount", "editor": discount537 }), { "colIndex": 22, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date of payment", "editor": due_date538, "width": Lino.chars2width(8), "dataIndex": "due_date" }, { "colIndex": 23, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "state", "editor": state539 } ];
    Lino.sales.InvoicesByPartner.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.sales.InvoicesByPartner.insertPanel = Ext.extend(Lino.sales.Invoices.InsertFormPanel,{
  empty_title: "New Invoices",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/sales/InvoicesByPartner",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.InvoicesByPartner.detail;
    this.ls_insert_handler = Lino.sales.InvoicesByPartner.insert;
    Lino.sales.InvoicesByPartner.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.InvoicesByPartner.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.sales.InvoicesByPartner.insertPanel(p);
});

Lino.sales.InvoicesByPartner.detailPanel = Ext.extend(Lino.sales.Invoices.DetailFormPanel,{
  empty_title: "Detail Invoices",
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false }, { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Print", "auto_save": true }, { "itemId": "do_clear_cache", "menu_item_text": "Clear cache", "must_save": true, "tooltip": "Clear cache", "panel_btn_handler": Lino.row_action_handler('do_clear_cache','GET'), "iconCls": "x-tbar-clearcache", "overflowText": "Clear cache", "auto_save": true } ],
  ls_url: "/sales/InvoicesByPartner",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.sales.InvoicesByPartner.detail;
    this.ls_insert_handler = Lino.sales.InvoicesByPartner.insert;
    Lino.sales.InvoicesByPartner.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.InvoicesByPartner.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.InvoicesByPartner.detailPanel(p);
});
Lino.sales.InvoicesByPartner.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.sales.Invoices.ParamsPanel({});
  return new Lino.sales.InvoicesByPartner.GridPanel(p);
});
Lino.sales.InvoicesByPartner.deregister_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoicesByPartner",pk,"deregister_action");
};
Lino.sales.InvoicesByPartner.register_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/sales/InvoicesByPartner",pk,"register_action");
};

// js_render_GridPanel_class finan.BankStatementsByJournal
Lino.finan.BankStatementsByJournal.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/finan/BankStatementsByJournal",
  ls_bbar_actions : [ { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "bank statements",
  page_length : 20,
  params_panel_hidden : true,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "type": "int", "name": "id" }, { "type": "int", "name": "number" }, { "name": "balance1" }, { "name": "balance2" }, { "name": "user" }, 'userHidden', { "name": "year" }, 'yearHidden', { "name": "narration" }, { "name": "declared_in" }, 'declared_inHidden', { "name": "state" }, 'stateHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 1,
  ls_grid_configs : [  ],
  content_type : 41,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    this.ls_detail_handler = Lino.finan.BankStatementsByJournal.detail;
    this.ls_insert_handler = Lino.finan.BankStatementsByJournal.insert;
    var ww = this.containing_window;
    var date1416 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var id1417 = new Ext.form.NumberField({ "selectOnFocus": true });
    var number1418 = new Ext.form.NumberField({ "selectOnFocus": true });
    var balance11419 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var balance21420 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalPrecision": 2, "allowBlank": true, "decimalSeparator": "," });
    var user1421 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/BankStatementsByJournal/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var year1422 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": Lino.ledger.FiscalYears });
    var narration1423 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var declared_in1424 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/BankStatementsByJournal/declared_in", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a VAT declaration..." });
    var state1425 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "allowBlank": false, "store": Lino.finan.VoucherStates });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "editor": date1416, "width": Lino.chars2width(8), "dataIndex": "date" }, new Lino.NullNumberColumn({ "colIndex": 1, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id1417, "width": Lino.chars2width(5), "dataIndex": "id" }), new Lino.NullNumberColumn({ "colIndex": 2, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "number", "dataIndex": "number", "width": Lino.chars2width(5), "editor": number1418 }), new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "header": "Old balance", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "balance1", "editor": balance11419 }), new Lino.NullNumberColumn({ "colIndex": 4, "sortable": true, "header": "New balance", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "balance2", "editor": balance21420 }), { "colIndex": 5, "sortable": true, "header": "Author", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(15), "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail'), "editor": user1421, "dataIndex": "user" }, { "colIndex": 6, "sortable": true, "header": "Fiscal Year", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(7), "dataIndex": "year", "editor": year1422 }, { "colIndex": 7, "sortable": true, "header": "Narration", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "narration", "editor": narration1423 }, { "colIndex": 8, "sortable": true, "header": "VAT declaration", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('declared_inHidden','Lino.declarations.Declarations.detail'), "editor": declared_in1424, "dataIndex": "declared_in" }, { "colIndex": 9, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(13), "dataIndex": "state", "editor": state1425 } ];
    Lino.finan.BankStatementsByJournal.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.finan.BankStatementsByJournal.insertPanel = Ext.extend(Lino.finan.BankStatements.InsertFormPanel,{
  empty_title: "New bank statements",
  hide_navigator: true,
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "post", "menu_item_text": "Create", "tooltip": "Create the record and open a detail window on it", "panel_btn_handler": function(panel){panel.save(null,true,'post')}, "text": "Create", "overflowText": "Create", "auto_save": false }, { "itemId": "poststay", "menu_item_text": "Create without detail", "tooltip": "Don't open a detail window on the new record", "panel_btn_handler": function(panel){panel.save(null,false,'poststay')}, "text": "Create without detail", "overflowText": "Create without detail", "auto_save": false } ],
  ls_url: "/finan/BankStatementsByJournal",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.finan.BankStatementsByJournal.detail;
    this.ls_insert_handler = Lino.finan.BankStatementsByJournal.insert;
    Lino.finan.BankStatementsByJournal.insertPanel.superclass.initComponent.call(this);
  }
});

Lino.finan.BankStatementsByJournal.insert = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(40), "autoHeight": true, "maximizable": true, "modal": true, "maximized": false },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.finan.BankStatementsByJournal.insertPanel(p);
});

Lino.finan.BankStatementsByJournal.detailPanel = Ext.extend(Lino.finan.BankStatements.DetailFormPanel,{
  empty_title: "Detail bank statements",
  params_panel_hidden: true,
  ls_bbar_actions: [ { "itemId": "put", "menu_item_text": "Save", "tooltip": "Save changes in this form", "panel_btn_handler": function(panel){panel.save(null,false,'put')}, "iconCls": "x-tbar-save", "overflowText": "Save", "auto_save": false }, { "itemId": "insert", "menu_item_text": "New", "must_save": true, "tooltip": "Insert a new record", "panel_btn_handler": function(panel){Lino.show_insert(panel)}, "iconCls": "x-tbar-new", "overflowText": "New", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  ls_url: "/finan/BankStatementsByJournal",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.finan.BankStatementsByJournal.detail;
    this.ls_insert_handler = Lino.finan.BankStatementsByJournal.insert;
    Lino.finan.BankStatementsByJournal.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.finan.BankStatementsByJournal.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.finan.BankStatementsByJournal.detailPanel(p);
});
Lino.finan.BankStatementsByJournal.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.finan.BankStatements.ParamsPanel({});
  return new Lino.finan.BankStatementsByJournal.GridPanel(p);
});
Lino.finan.BankStatementsByJournal.deregister_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/finan/BankStatementsByJournal",pk,"deregister_action");
};
Lino.finan.BankStatementsByJournal.register_action = function(rp,pk) { 
  Lino.run_row_action(rp,"/finan/BankStatementsByJournal",pk,"register_action");
};

// js_render_GridPanel_class finan.ItemsByStatement
Lino.finan.ItemsByStatement.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/finan/ItemsByStatement",
  ls_bbar_actions : [ { "itemId": "duplicate", "menu_item_text": "Duplicate", "must_save": true, "tooltip": "Duplicate", "panel_btn_handler": Lino.row_action_handler('duplicate','GET'), "iconCls": "x-tbar-duplicate", "overflowText": "Duplicate", "auto_save": true }, { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "doc items",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "account" }, 'accountHidden', { "name": "partner" }, 'partnerHidden', { "name": "remark" }, { "name": "debit" }, { "name": "credit" }, { "type": "int", "name": "seqno" }, { "type": "int", "name": "id" }, { "name": "title" }, { "name": "amount" }, { "type": "boolean", "name": "dc" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 9,
  ls_grid_configs : [  ],
  content_type : 42,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 14,
  initComponent : function() {
    var ww = this.containing_window;
    var date848 = new Lino.DateField({ "selectOnFocus": true });
    var account849 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/ItemsByStatement/account", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Account..." });
    var partner850 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/finan/ItemsByStatement/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var remark851 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var debit852 = new Ext.form.NumberField({ "disabled": true, "decimalPrecision": 2, "decimalSeparator": "," });
    var credit853 = new Ext.form.NumberField({ "disabled": true, "decimalPrecision": 2, "decimalSeparator": "," });
    var seqno854 = new Ext.form.NumberField({ "selectOnFocus": true });
    var id855 = new Ext.form.NumberField({ "selectOnFocus": true });
    var title856 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var amount857 = new Ext.form.NumberField({ "selectOnFocus": true, "decimalSeparator": ",", "decimalPrecision": 2, "allowBlank": false, "value": 0 });
    var dc858 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "date", "editor": date848, "width": Lino.chars2width(8), "dataIndex": "date" }, { "colIndex": 1, "sortable": true, "header": "Account", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "dataIndex": "account", "editor": account849 }, { "colIndex": 2, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('partnerHidden','Lino.partners.Partners.detail'), "editor": partner850, "dataIndex": "partner" }, { "colIndex": 3, "sortable": true, "header": "remark", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "remark", "editor": remark851 }, new Lino.NullNumberColumn({ "width": Lino.chars2width(12), "colIndex": 4, "sortable": false, "dataIndex": "debit", "header": "Income", "editable": false }), new Lino.NullNumberColumn({ "width": Lino.chars2width(12), "colIndex": 5, "sortable": false, "dataIndex": "credit", "header": "Expense", "editable": false }), new Lino.NullNumberColumn({ "colIndex": 6, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "Seq.No.", "dataIndex": "seqno", "width": Lino.chars2width(5), "editor": seqno854 }), new Lino.NullNumberColumn({ "colIndex": 7, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id855, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 8, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(21), "dataIndex": "title", "editor": title856 }, new Lino.NullNumberColumn({ "colIndex": 9, "sortable": true, "header": "amount", "editable": true, "filter": { "type": "numeric" }, "width": Lino.chars2width(12), "dataIndex": "amount", "editor": amount857 }), { "colIndex": 10, "sortable": false, "xtype": "checkcolumn", "header": "dc", "editable": true, "filter": { "type": "boolean" }, "width": Lino.chars2width(10), "dataIndex": "dc" } ];
    Lino.finan.ItemsByStatement.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.finan.ItemsByStatement.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.finan.ItemsByStatement.GridPanel(p);
});

// js_render_GridPanel_class ui.HelpTextsByModel
Lino.ui.HelpTextsByModel.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/ui/HelpTextsByModel",
  ls_bbar_actions : [ { "itemId": null, "menu_item_text": "Delete", "tooltip": "Delete this record", "panel_btn_handler": Lino.delete_selected, "iconCls": "x-tbar-delete", "overflowText": "Delete", "auto_save": false } ],
  title : "Help Texts",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "field" }, { "name": "verbose_name" }, { "name": "help_text" }, { "type": "int", "name": "id" }, { "name": "content_type" }, 'content_typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 2,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    var ww = this.containing_window;
    var field223 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/HelpTextsByModel/field", "method": "GET" }) }) });
    var verbose_name224 = new Ext.form.TextField({ "disabled": true, "maxLength": 200 });
    var help_text225 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var id226 = new Ext.form.NumberField({ "selectOnFocus": true });
    var content_type227 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/ui/HelpTextsByModel/content_type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a content type..." });
    this.before_row_edit = function(record) {
      var bp = this.get_base_params();
      field223.setContextValue('mk',bp['mk']);
      field223.setContextValue('mt',bp['mt']);
    };
    this.onRender = function(ct, position) {
      content_type227.on('change',Lino.chooser_handler(field223,'content_type'));
      Lino.ui.HelpTextsByModel.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Field", "editable": true, "tooltip": "The name of the field.", "filter": { "type": "string" }, "width": Lino.chars2width(10), "dataIndex": "field", "editor": field223 }, { "width": Lino.chars2width(21), "colIndex": 1, "sortable": false, "dataIndex": "verbose_name", "header": "Verbose name", "editable": false }, { "colIndex": 2, "sortable": false, "header": "HelpText", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(60), "renderer": Lino.text_renderer, "editor": help_text225, "dataIndex": "help_text" }, new Lino.NullNumberColumn({ "colIndex": 3, "sortable": true, "format": "0", "editable": true, "filter": { "type": "numeric" }, "header": "ID", "renderer": Lino.id_renderer, "editor": id226, "width": Lino.chars2width(5), "dataIndex": "id" }), { "colIndex": 4, "sortable": true, "header": "Model", "editable": true, "filter": { "type": "string" }, "width": Lino.chars2width(20), "renderer": Lino.fk_renderer('content_typeHidden','Lino.ui.ContentTypes.detail'), "editor": content_type227, "dataIndex": "content_type" } ];
    Lino.ui.HelpTextsByModel.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ui.HelpTextsByModel.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ui.HelpTextsByModel.GridPanel(p);
});

// js_render_GridPanel_class about.Models
Lino.about.Models.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/about/Models",
  ls_bbar_actions : [ { "itemId": "detail", "menu_item_text": "Detail", "tooltip": "Open a detail window on this record", "panel_btn_handler": Lino.show_detail, "iconCls": "x-tbar-detail", "overflowText": "Detail", "auto_save": true } ],
  title : "Models",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "app" }, { "name": "name" }, { "name": "docstring" }, { "name": "rows" }, { "name": "detail_action" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "No data to display." },
  disable_editing : true,
  disabled_actions_index : 6,
  initComponent : function() {
    this.ls_detail_handler = Lino.about.Models.detail;
    var ww = this.containing_window;
    var app_disp1427 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var name_disp1428 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var docstring_disp1429 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var rows1430 = new Ext.form.NumberField({ "disabled": true });
    var detail_action_disp1431 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(30), "colIndex": 0, "sortable": false, "dataIndex": "app", "header": "app_label", "editable": false }, { "width": Lino.chars2width(30), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false }, { "width": Lino.chars2width(30), "colIndex": 2, "sortable": false, "dataIndex": "docstring", "header": "docstring", "editable": false }, new Lino.NullNumberColumn({ "header": "Rows", "colIndex": 3, "sortable": false, "dataIndex": "rows", "format": "0", "editable": false, "width": Lino.chars2width(5) }), { "width": Lino.chars2width(30), "colIndex": 4, "sortable": false, "dataIndex": "detail_action", "header": "detail_action", "editable": false } ];
    Lino.about.Models.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.about.Models.detailPanel = Ext.extend(Lino.about.Models.DetailFormPanel,{
  empty_title: "Detail Models",
  ls_bbar_actions: [  ],
  ls_url: "/about/Models",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.about.Models.detail;
    Lino.about.Models.detailPanel.superclass.initComponent.call(this);
  }
});

Lino.about.Models.detail = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.about.Models.detailPanel(p);
});
Lino.about.Models.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.about.Models.GridPanel(p);
});

// js_render_GridPanel_class about.FieldsByModel
Lino.about.FieldsByModel.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/about/FieldsByModel",
  ls_bbar_actions : [  ],
  title : "Fields",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "verbose_name" }, { "name": "help_text_column" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "No data to display." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var name_disp900 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var verbose_name_disp901 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var help_text_column_disp902 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(30), "colIndex": 0, "sortable": false, "dataIndex": "name", "header": "name", "editable": false }, { "width": Lino.chars2width(30), "colIndex": 1, "sortable": false, "dataIndex": "verbose_name", "header": "verbose name", "editable": false }, { "width": Lino.chars2width(30), "colIndex": 2, "sortable": false, "dataIndex": "help_text_column", "header": "help text", "editable": false } ];
    Lino.about.FieldsByModel.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.about.FieldsByModel.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.about.FieldsByModel.GridPanel(p);
});

// js_render_GridPanel_class about.Inspector
Lino.about.Inspector.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/about/Inspector",
  ls_bbar_actions : [  ],
  title : "Inspector",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "i_name" }, { "name": "i_type" }, { "name": "i_value" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "No data to display." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var i_name_disp1433 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var i_type_disp1434 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    var i_value_disp1435 = new Ext.form.DisplayField({ "disabled": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(30), "colIndex": 0, "sortable": false, "dataIndex": "i_name", "header": "Name", "editable": false }, { "width": Lino.chars2width(30), "colIndex": 1, "sortable": false, "dataIndex": "i_type", "header": "Type", "editable": false }, { "width": Lino.chars2width(30), "colIndex": 2, "sortable": false, "dataIndex": "i_value", "header": "Value", "editable": false } ];
    Lino.about.Inspector.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.about.Inspector.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  p.params_panel = new Lino.about.Inspector.ParamsPanel({});
  return new Lino.about.Inspector.GridPanel(p);
});

// js_render_GridPanel_class about.SourceFiles
Lino.about.SourceFiles.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/about/SourceFiles",
  ls_bbar_actions : [  ],
  title : "Source files",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "module_name" }, { "type": "int", "name": "code_lines" }, { "type": "int", "name": "doc_lines" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "No data to display." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var module_name1437 = new Ext.form.TextField({ "disabled": true, "maxLength": null });
    var code_lines1438 = new Ext.form.NumberField({ "disabled": true });
    var doc_lines1439 = new Ext.form.NumberField({ "disabled": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(4), "colIndex": 0, "sortable": false, "dataIndex": "module_name", "header": "module name", "editable": false }, new Lino.NullNumberColumn({ "header": "Code", "colIndex": 1, "sortable": false, "dataIndex": "code_lines", "format": "0", "editable": false, "width": Lino.chars2width(5) }), new Lino.NullNumberColumn({ "header": "doc", "colIndex": 2, "sortable": false, "dataIndex": "doc_lines", "format": "0", "editable": false, "width": Lino.chars2width(5) }) ];
    Lino.about.SourceFiles.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.about.SourceFiles.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.about.SourceFiles.GridPanel(p);
});

Lino.ui.Home.showPanel = Ext.extend(Lino.ui.Home.DetailFormPanel,{
  empty_title: "Home",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Print", "auto_save": true } ],
  ls_url: "/ui/Home",
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.Home.show;
    Lino.ui.Home.showPanel.superclass.initComponent.call(this);
  }
});

Lino.ui.Home.show = new Lino.WindowAction({  },function(){
  var p = { "hide_window_title": true, "hide_top_toolbar": true, "is_main_window": true };
  return new Lino.ui.Home.showPanel(p);
});

Lino.ui.Home.showPanel = Ext.extend(Lino.ui.Home.DetailFormPanel,{
  empty_title: "Home",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Print", "auto_save": true } ],
  ls_url: "/ui/Home",
  initComponent : function() {
    this.ls_detail_handler = Lino.ui.Home.show;
    Lino.ui.Home.showPanel.superclass.initComponent.call(this);
  }
});

Lino.ui.Home.show = new Lino.WindowAction({  },function(){
  var p = { "hide_window_title": true, "hide_top_toolbar": true, "is_main_window": true };
  return new Lino.ui.Home.showPanel(p);
});

Lino.about.About.showPanel = Ext.extend(Lino.about.About.DetailFormPanel,{
  empty_title: "About",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Print", "auto_save": true } ],
  ls_url: "/about/About",
  initComponent : function() {
    this.ls_detail_handler = Lino.about.About.show;
    Lino.about.About.showPanel.superclass.initComponent.call(this);
  }
});

Lino.about.About.show = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(20) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.about.About.showPanel(p);
});

Lino.about.About.showPanel = Ext.extend(Lino.about.About.DetailFormPanel,{
  empty_title: "About",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "do_print", "menu_item_text": "Print", "must_save": true, "tooltip": "Print", "panel_btn_handler": Lino.row_action_handler('do_print','GET'), "iconCls": "x-tbar-print", "overflowText": "Print", "auto_save": true } ],
  ls_url: "/about/About",
  initComponent : function() {
    this.ls_detail_handler = Lino.about.About.show;
    Lino.about.About.showPanel.superclass.initComponent.call(this);
  }
});

Lino.about.About.show = new Lino.WindowAction({ "draggable": true, "width": Lino.chars2width(60), "maximizable": true, "modal": true, "maximized": false, "height": Lino.rows2height(20) },function(){
  var p = { "is_main_window": true, "hide_top_toolbar": true };
  return new Lino.about.About.showPanel(p);
});

// js_render_GridPanel_class finan.VoucherStates
Lino.finan.VoucherStates.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/finan/VoucherStates",
  ls_bbar_actions : [  ],
  title : "States",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "No data to display." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value1441 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name1442 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text1443 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "value", "editable": false }, { "width": Lino.chars2width(21), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false }, { "width": Lino.chars2width(21), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "text", "editable": false } ];
    Lino.finan.VoucherStates.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.finan.VoucherStates.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.finan.VoucherStates.GridPanel(p);
});

// js_render_GridPanel_class declarations.DeclarationStates
Lino.declarations.DeclarationStates.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/declarations/DeclarationStates",
  ls_bbar_actions : [  ],
  title : "States",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "No data to display." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value1445 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name1446 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text1447 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "value", "editable": false }, { "width": Lino.chars2width(21), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false }, { "width": Lino.chars2width(21), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "text", "editable": false } ];
    Lino.declarations.DeclarationStates.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.declarations.DeclarationStates.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.declarations.DeclarationStates.GridPanel(p);
});

// js_render_GridPanel_class lino.Genders
Lino.lino.Genders.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/lino/Genders",
  ls_bbar_actions : [  ],
  title : "Genders",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "No data to display." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value1449 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name1450 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text1451 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "value", "editable": false }, { "width": Lino.chars2width(21), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false }, { "width": Lino.chars2width(21), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "text", "editable": false } ];
    Lino.lino.Genders.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.Genders.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.Genders.GridPanel(p);
});

// js_render_GridPanel_class vat.TradeTypes
Lino.vat.TradeTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/vat/TradeTypes",
  ls_bbar_actions : [  ],
  title : "TradeTypes",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "No data to display." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value1453 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name1454 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text1455 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "value", "editable": false }, { "width": Lino.chars2width(21), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false }, { "width": Lino.chars2width(21), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "text", "editable": false } ];
    Lino.vat.TradeTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.vat.TradeTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.vat.TradeTypes.GridPanel(p);
});

// js_render_GridPanel_class countries.CityTypes
Lino.countries.CityTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/countries/CityTypes",
  ls_bbar_actions : [  ],
  title : "CityTypes",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "No data to display." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value1457 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name1458 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text1459 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "value", "editable": false }, { "width": Lino.chars2width(21), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false }, { "width": Lino.chars2width(21), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "text", "editable": false } ];
    Lino.countries.CityTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.CityTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.countries.CityTypes.GridPanel(p);
});

// js_render_GridPanel_class sales.InvoiceStates
Lino.sales.InvoiceStates.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/sales/InvoiceStates",
  ls_bbar_actions : [  ],
  title : "States",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "No data to display." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value1461 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name1462 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text1463 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "value", "editable": false }, { "width": Lino.chars2width(21), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false }, { "width": Lino.chars2width(21), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "text", "editable": false } ];
    Lino.sales.InvoiceStates.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.sales.InvoiceStates.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.sales.InvoiceStates.GridPanel(p);
});

// js_render_GridPanel_class accounts.AccountTypes
Lino.accounts.AccountTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/accounts/AccountTypes",
  ls_bbar_actions : [  ],
  title : "AccountTypes",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "No data to display." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value1465 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name1466 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text1467 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "value", "editable": false }, { "width": Lino.chars2width(21), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false }, { "width": Lino.chars2width(21), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "text", "editable": false } ];
    Lino.accounts.AccountTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.accounts.AccountTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.accounts.AccountTypes.GridPanel(p);
});

// js_render_GridPanel_class vat.VatRegimes
Lino.vat.VatRegimes.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/vat/VatRegimes",
  ls_bbar_actions : [  ],
  title : "VatRegimes",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "No data to display." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value1469 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name1470 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text1471 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "value", "editable": false }, { "width": Lino.chars2width(21), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false }, { "width": Lino.chars2width(21), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "text", "editable": false } ];
    Lino.vat.VatRegimes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.vat.VatRegimes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.vat.VatRegimes.GridPanel(p);
});

// js_render_GridPanel_class lino.UserProfiles
Lino.lino.UserProfiles.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/lino/UserProfiles",
  ls_bbar_actions : [  ],
  title : "User Profiles",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "No data to display." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value1473 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name1474 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text1475 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "value", "editable": false }, { "width": Lino.chars2width(21), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false }, { "width": Lino.chars2width(21), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "text", "editable": false } ];
    Lino.lino.UserProfiles.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.UserProfiles.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.UserProfiles.GridPanel(p);
});

// js_render_GridPanel_class vat.VatClasses
Lino.vat.VatClasses.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/vat/VatClasses",
  ls_bbar_actions : [  ],
  title : "VatClasses",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "No data to display." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value1477 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name1478 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text1479 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "value", "editable": false }, { "width": Lino.chars2width(21), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false }, { "width": Lino.chars2width(21), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "text", "editable": false } ];
    Lino.vat.VatClasses.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.vat.VatClasses.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.vat.VatClasses.GridPanel(p);
});

// js_render_GridPanel_class declarations.DeclarationFields
Lino.declarations.DeclarationFields.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/declarations/DeclarationFields",
  ls_bbar_actions : [  ],
  title : "DeclarationFields",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "No data to display." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value1481 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name1482 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text1483 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "value", "editable": false }, { "width": Lino.chars2width(21), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false }, { "width": Lino.chars2width(21), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "text", "editable": false } ];
    Lino.declarations.DeclarationFields.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.declarations.DeclarationFields.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.declarations.DeclarationFields.GridPanel(p);
});

// js_render_GridPanel_class declarations.DeclarationPeriods
Lino.declarations.DeclarationPeriods.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/declarations/DeclarationPeriods",
  ls_bbar_actions : [  ],
  title : "VAT Periods",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "No data to display." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value1485 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name1486 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text1487 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "value", "editable": false }, { "width": Lino.chars2width(21), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false }, { "width": Lino.chars2width(21), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "text", "editable": false } ];
    Lino.declarations.DeclarationPeriods.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.declarations.DeclarationPeriods.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.declarations.DeclarationPeriods.GridPanel(p);
});

// js_render_GridPanel_class ledger.VoucherTypes
Lino.ledger.VoucherTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/ledger/VoucherTypes",
  ls_bbar_actions : [  ],
  title : "VoucherTypes",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "No data to display." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value1489 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name1490 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text1491 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "value", "editable": false }, { "width": Lino.chars2width(21), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false }, { "width": Lino.chars2width(21), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "text", "editable": false } ];
    Lino.ledger.VoucherTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.VoucherTypes.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.VoucherTypes.GridPanel(p);
});

// js_render_GridPanel_class ledger.InvoiceStates
Lino.ledger.InvoiceStates.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/ledger/InvoiceStates",
  ls_bbar_actions : [  ],
  title : "States",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "No data to display." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value1493 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name1494 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text1495 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "value", "editable": false }, { "width": Lino.chars2width(21), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false }, { "width": Lino.chars2width(21), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "text", "editable": false } ];
    Lino.ledger.InvoiceStates.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.InvoiceStates.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.InvoiceStates.GridPanel(p);
});

// js_render_GridPanel_class ledger.FiscalYears
Lino.ledger.FiscalYears.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/ledger/FiscalYears",
  ls_bbar_actions : [  ],
  title : "Fiscal Years",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "No data to display." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value1497 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name1498 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text1499 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "value", "editable": false }, { "width": Lino.chars2width(21), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false }, { "width": Lino.chars2width(21), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "text", "editable": false } ];
    Lino.ledger.FiscalYears.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.ledger.FiscalYears.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.ledger.FiscalYears.GridPanel(p);
});

// js_render_GridPanel_class lino.UserGroups
Lino.lino.UserGroups.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/lino/UserGroups",
  ls_bbar_actions : [  ],
  title : "User Groups",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "No data to display." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value1501 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name1502 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text1503 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "value", "editable": false }, { "width": Lino.chars2width(21), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false }, { "width": Lino.chars2width(21), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "text", "editable": false } ];
    Lino.lino.UserGroups.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.UserGroups.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.UserGroups.GridPanel(p);
});

// js_render_GridPanel_class lino.UserLevels
Lino.lino.UserLevels.GridPanel = Ext.extend(Lino.GridPanel,{
  ls_url : "/lino/UserLevels",
  ls_bbar_actions : [  ],
  title : "User Levels",
  page_length : 20,
  gc_name : 0,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "name" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" } ],
  ls_grid_configs : [  ],
  viewConfig : { "emptyText": "No data to display." },
  disable_editing : true,
  disabled_actions_index : 4,
  initComponent : function() {
    var ww = this.containing_window;
    var value1505 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var name1506 = new Ext.form.TextField({ "disabled": true, "maxLength": 20 });
    var text1507 = new Ext.form.TextField({ "disabled": true, "maxLength": 50 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": Lino.chars2width(21), "colIndex": 0, "sortable": false, "dataIndex": "value", "header": "value", "editable": false }, { "width": Lino.chars2width(21), "colIndex": 1, "sortable": false, "dataIndex": "name", "header": "name", "editable": false }, { "width": Lino.chars2width(21), "colIndex": 2, "sortable": false, "dataIndex": "text", "header": "text", "editable": false } ];
    Lino.lino.UserLevels.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.UserLevels.grid = new Lino.WindowAction({  },function(){
  var p = { "is_main_window": true };
  return new Lino.lino.UserLevels.GridPanel(p);
});
