/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.Socket;
import java.sql.SQLException;
import org.postgresql.core.Encoding;
import org.postgresql.core.PGBindException;
import org.postgresql.core.VisibleBufferedInputStream;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class PGStream {
    private final String host;
    private final int port;
    private Socket connection;
    private VisibleBufferedInputStream pg_input;
    private OutputStream pg_output;
    private byte[] streamBuffer;
    private Encoding encoding;
    private Writer encodingWriter;

    public PGStream(String host, int port) throws IOException {
        this.host = host;
        this.port = port;
        this.changeSocket(new Socket(host, port));
        this.setEncoding(Encoding.getJVMEncoding("US-ASCII"));
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public Socket getSocket() {
        return this.connection;
    }

    public boolean hasMessagePending() throws IOException {
        return this.pg_input.available() > 0 || this.connection.getInputStream().available() > 0;
    }

    public void changeSocket(Socket socket) throws IOException {
        this.connection = socket;
        this.connection.setTcpNoDelay(true);
        this.pg_input = new VisibleBufferedInputStream(this.connection.getInputStream(), 8192);
        this.pg_output = new BufferedOutputStream(this.connection.getOutputStream(), 8192);
        if (this.encoding != null) {
            this.setEncoding(this.encoding);
        }
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Encoding encoding) throws IOException {
        if (this.encodingWriter != null) {
            this.encodingWriter.close();
        }
        this.encoding = encoding;
        FilterOutputStream interceptor = new FilterOutputStream(this.pg_output){

            public void flush() throws IOException {
            }

            public void close() throws IOException {
                super.flush();
            }
        };
        this.encodingWriter = encoding.getEncodingWriter(interceptor);
    }

    public Writer getEncodingWriter() throws IOException {
        if (this.encodingWriter == null) {
            throw new IOException("No encoding has been set on this connection");
        }
        return this.encodingWriter;
    }

    public void SendChar(int val) throws IOException {
        this.pg_output.write((byte)val);
    }

    public void SendInteger4(int val) throws IOException {
        this.SendChar(val >> 24 & 0xFF);
        this.SendChar(val >> 16 & 0xFF);
        this.SendChar(val >> 8 & 0xFF);
        this.SendChar(val & 0xFF);
    }

    public void SendInteger2(int val) throws IOException {
        if (val < Short.MIN_VALUE || val > Short.MAX_VALUE) {
            throw new IOException("Tried to send an out-of-range integer as a 2-byte value: " + val);
        }
        this.SendChar(val >> 8 & 0xFF);
        this.SendChar(val & 0xFF);
    }

    public void Send(byte[] buf) throws IOException {
        this.pg_output.write(buf);
    }

    public void Send(byte[] buf, int siz) throws IOException {
        this.Send(buf, 0, siz);
    }

    public void Send(byte[] buf, int off, int siz) throws IOException {
        this.pg_output.write(buf, off, buf.length - off < siz ? buf.length - off : siz);
        if (buf.length - off < siz) {
            int i = buf.length - off;
            while (i < siz) {
                this.pg_output.write(0);
                ++i;
            }
        }
    }

    public int ReceiveChar() throws IOException {
        int c = this.pg_input.read();
        if (c < 0) {
            throw new EOFException();
        }
        return c;
    }

    public int ReceiveIntegerR(int siz) throws IOException {
        if (!this.pg_input.ensureBytes(siz)) {
            throw new EOFException();
        }
        int n = 0;
        int i = 0;
        while (i < siz) {
            int b = this.pg_input.readRaw() & 0xFF;
            n = b | n << 8;
            ++i;
        }
        switch (siz) {
            case 1: {
                return (byte)n;
            }
            case 2: {
                return (short)n;
            }
        }
        return n;
    }

    public String ReceiveString(int len) throws IOException {
        if (!this.pg_input.ensureBytes(len)) {
            throw new EOFException();
        }
        String res = this.encoding.decode(this.pg_input.getBuffer(), this.pg_input.getIndex(), len);
        this.pg_input.skip(len);
        return res;
    }

    public String ReceiveString() throws IOException {
        int len = this.pg_input.scanCStringLength();
        String res = this.encoding.decode(this.pg_input.getBuffer(), this.pg_input.getIndex(), len - 1);
        this.pg_input.skip(len);
        return res;
    }

    public byte[][] ReceiveTupleV3() throws IOException, OutOfMemoryError {
        this.ReceiveIntegerR(4);
        int l_nf = this.ReceiveIntegerR(2);
        byte[][] answer = new byte[l_nf][];
        OutOfMemoryError oom = null;
        int i = 0;
        while (i < l_nf) {
            int l_size = this.ReceiveIntegerR(4);
            if (l_size != -1) {
                try {
                    answer[i] = new byte[l_size];
                    this.Receive(answer[i], 0, l_size);
                }
                catch (OutOfMemoryError oome) {
                    oom = oome;
                    this.Skip(l_size);
                }
            }
            ++i;
        }
        if (oom != null) {
            throw oom;
        }
        return answer;
    }

    public byte[][] ReceiveTupleV2(int nf, boolean bin) throws IOException, OutOfMemoryError {
        int bim = (nf + 7) / 8;
        byte[] bitmask = this.Receive(bim);
        byte[][] answer = new byte[nf][];
        int whichbit = 128;
        int whichbyte = 0;
        OutOfMemoryError oom = null;
        int i = 0;
        while (i < nf) {
            boolean isNull;
            boolean bl = isNull = (bitmask[whichbyte] & whichbit) == 0;
            if ((whichbit >>= 1) == 0) {
                ++whichbyte;
                whichbit = 128;
            }
            if (!isNull) {
                int len = this.ReceiveIntegerR(4);
                if (!bin) {
                    len -= 4;
                }
                if (len < 0) {
                    len = 0;
                }
                try {
                    answer[i] = new byte[len];
                    this.Receive(answer[i], 0, len);
                }
                catch (OutOfMemoryError oome) {
                    oom = oome;
                    this.Skip(len);
                }
            }
            ++i;
        }
        if (oom != null) {
            throw oom;
        }
        return answer;
    }

    public byte[] Receive(int siz) throws IOException {
        byte[] answer = new byte[siz];
        this.Receive(answer, 0, siz);
        return answer;
    }

    public void Receive(byte[] buf, int off, int siz) throws IOException {
        int s = 0;
        while (s < siz) {
            int w = this.pg_input.read(buf, off + s, siz - s);
            if (w < 0) {
                throw new EOFException();
            }
            s += w;
        }
    }

    public void Skip(int size) throws IOException {
        long s = 0L;
        while (s < (long)size) {
            s += this.pg_input.skip((long)size - s);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void SendStream(InputStream inStream, int remaining) throws IOException {
        expectedLength = remaining;
        if (this.streamBuffer == null) {
            this.streamBuffer = new byte[8192];
        }
        while (remaining > 0) {
            block6: {
                count = remaining > this.streamBuffer.length ? this.streamBuffer.length : remaining;
                try {
                    readCount = inStream.read(this.streamBuffer, 0, count);
                    if (readCount < 0) {
                        throw new EOFException(GT.tr("Premature end of input stream, expected {0} bytes, but only read {1}.", new Object[]{new Integer(expectedLength), new Integer(expectedLength - remaining)}));
                    }
                    break block6;
                }
                catch (IOException ioe) {
                    ** while (remaining > 0)
                }
lbl-1000:
                // 1 sources

                {
                    this.Send(this.streamBuffer, count);
                    v0 = count = (remaining -= count) > this.streamBuffer.length ? this.streamBuffer.length : remaining;
                    continue;
                }
lbl16:
                // 1 sources

                throw new PGBindException(ioe);
            }
            this.Send(this.streamBuffer, readCount);
            remaining -= readCount;
        }
    }

    public void flush() throws IOException {
        if (this.encodingWriter != null) {
            this.encodingWriter.flush();
        }
        this.pg_output.flush();
    }

    public void ReceiveEOF() throws SQLException, IOException {
        int c = this.pg_input.read();
        if (c < 0) {
            return;
        }
        throw new PSQLException(GT.tr("Expected an EOF from server, got: {0}", new Integer(c)), PSQLState.COMMUNICATION_ERROR);
    }

    public void close() throws IOException {
        if (this.encodingWriter != null) {
            this.encodingWriter.close();
        }
        this.pg_output.close();
        this.pg_input.close();
        this.connection.close();
    }
}

