/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.util.ArrayList;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.core.DropNotNullConstraintChange;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.SQLiteDatabase;
import liquibase.database.structure.Index;
import liquibase.statement.AbstractSqlStatement;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.ReorganizeTableStatement;
import liquibase.statement.core.SetNullableStatement;
import liquibase.statement.core.UpdateStatement;
import liquibase.util.StringUtils;

public class AddNotNullConstraintChange
extends AbstractChange {
    private String schemaName;
    private String tableName;
    private String columnName;
    private String defaultNullValue;
    private String columnDataType;

    public AddNotNullConstraintChange() {
        super("addNotNullConstraint", "Add Not-Null Constraint", 1);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = StringUtils.trimToNull(schemaName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getDefaultNullValue() {
        return this.defaultNullValue;
    }

    public void setDefaultNullValue(String defaultNullValue) {
        this.defaultNullValue = defaultNullValue;
    }

    public String getColumnDataType() {
        return this.columnDataType;
    }

    public void setColumnDataType(String columnDataType) {
        this.columnDataType = columnDataType;
    }

    public SqlStatement[] generateStatements(Database database) {
        String schemaName;
        ArrayList<AbstractSqlStatement> statements = new ArrayList<AbstractSqlStatement>();
        String string = schemaName = this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName();
        if (this.defaultNullValue != null) {
            statements.add(new UpdateStatement(schemaName, this.getTableName()).addNewColumnValue(this.getColumnName(), this.getDefaultNullValue()).setWhereClause(this.getColumnName() + " IS NULL"));
        }
        statements.add(new SetNullableStatement(schemaName, this.getTableName(), this.getColumnName(), this.getColumnDataType(), false));
        if (database instanceof DB2Database) {
            statements.add(new ReorganizeTableStatement(schemaName, this.getTableName()));
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    private SqlStatement[] generateStatementsForSQLiteDatabase(Database database) {
        String schemaName;
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>();
        String string = schemaName = this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName();
        if (this.defaultNullValue != null) {
            statements.add(new UpdateStatement(schemaName, this.getTableName()).addNewColumnValue(this.getColumnName(), this.getDefaultNullValue()).setWhereClause(this.getColumnName() + " IS NULL"));
        }
        SQLiteDatabase.AlterTableVisitor rename_alter_visitor = new SQLiteDatabase.AlterTableVisitor(){

            public ColumnConfig[] getColumnsToAdd() {
                return new ColumnConfig[0];
            }

            public boolean copyThisColumn(ColumnConfig column) {
                return true;
            }

            public boolean createThisColumn(ColumnConfig column) {
                if (column.getName().equals(AddNotNullConstraintChange.this.getColumnName())) {
                    column.getConstraints().setNullable(false);
                }
                return true;
            }

            public boolean createThisIndex(Index index) {
                return true;
            }
        };
        try {
            statements.addAll(SQLiteDatabase.getAlterTableStatements(rename_alter_visitor, database, this.getSchemaName(), this.getTableName()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    protected Change[] createInverses() {
        DropNotNullConstraintChange inverse = new DropNotNullConstraintChange();
        inverse.setColumnName(this.getColumnName());
        inverse.setSchemaName(this.getSchemaName());
        inverse.setTableName(this.getTableName());
        inverse.setColumnDataType(this.getColumnDataType());
        return new Change[]{inverse};
    }

    public String getConfirmationMessage() {
        return "Null constraint has been added to " + this.getTableName() + "." + this.getColumnName();
    }
}

