/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v3;

import java.io.IOException;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import org.postgresql.core.Field;
import org.postgresql.core.Logger;
import org.postgresql.core.Notification;
import org.postgresql.core.PGBindException;
import org.postgresql.core.PGStream;
import org.postgresql.core.ParameterList;
import org.postgresql.core.Parser;
import org.postgresql.core.Query;
import org.postgresql.core.QueryExecutor;
import org.postgresql.core.ResultCursor;
import org.postgresql.core.ResultHandler;
import org.postgresql.core.Utils;
import org.postgresql.core.v3.CompositeQuery;
import org.postgresql.core.v3.Portal;
import org.postgresql.core.v3.ProtocolConnectionImpl;
import org.postgresql.core.v3.SimpleParameterList;
import org.postgresql.core.v3.SimpleQuery;
import org.postgresql.core.v3.V3ParameterList;
import org.postgresql.core.v3.V3Query;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.PSQLWarning;
import org.postgresql.util.ServerErrorMessage;

public class QueryExecutorImpl
implements QueryExecutor {
    private static final int MAX_BUFFERED_QUERIES = 256;
    private final HashMap parsedQueryMap = new HashMap();
    private final ReferenceQueue parsedQueryCleanupQueue = new ReferenceQueue();
    private final HashMap openPortalMap = new HashMap();
    private final ReferenceQueue openPortalCleanupQueue = new ReferenceQueue();
    private final ArrayList pendingParseQueue = new ArrayList();
    private final ArrayList pendingBindQueue = new ArrayList();
    private final ArrayList pendingExecuteQueue = new ArrayList();
    private final ArrayList pendingDescribeStatementQueue = new ArrayList();
    private long nextUniqueID = 1L;
    private final ProtocolConnectionImpl protoConnection;
    private final PGStream pgStream;
    private final Logger logger;
    private final boolean allowEncodingChanges;
    private final SimpleQuery beginTransactionQuery = new SimpleQuery(new String[]{"BEGIN"});
    private static final SimpleQuery EMPTY_QUERY = new SimpleQuery(new String[]{""});

    public QueryExecutorImpl(ProtocolConnectionImpl protoConnection, PGStream pgStream, Properties info, Logger logger) {
        this.protoConnection = protoConnection;
        this.pgStream = pgStream;
        this.logger = logger;
        this.allowEncodingChanges = info.getProperty("allowEncodingChanges") != null ? Boolean.valueOf(info.getProperty("allowEncodingChanges")) : false;
    }

    public Query createSimpleQuery(String sql) {
        return this.parseQuery(sql, false);
    }

    public Query createParameterizedQuery(String sql) {
        return this.parseQuery(sql, true);
    }

    private Query parseQuery(String query, boolean withParameters) {
        ArrayList<String[]> statementList = new ArrayList<String[]>();
        ArrayList<String> fragmentList = new ArrayList<String>(15);
        int fragmentStart = 0;
        int inParen = 0;
        boolean standardConformingStrings = this.protoConnection.getStandardConformingStrings();
        char[] aChars = query.toCharArray();
        int i = 0;
        while (i < aChars.length) {
            switch (aChars[i]) {
                case '\'': {
                    i = Parser.parseSingleQuotes(aChars, i, standardConformingStrings);
                    break;
                }
                case '\"': {
                    i = Parser.parseDoubleQuotes(aChars, i);
                    break;
                }
                case '-': {
                    i = Parser.parseLineComment(aChars, i);
                    break;
                }
                case '/': {
                    i = Parser.parseBlockComment(aChars, i);
                    break;
                }
                case '$': {
                    i = Parser.parseDollarQuotes(aChars, i);
                    break;
                }
                case '(': {
                    ++inParen;
                    break;
                }
                case ')': {
                    --inParen;
                    break;
                }
                case '?': {
                    if (!withParameters) break;
                    fragmentList.add(query.substring(fragmentStart, i));
                    fragmentStart = i + 1;
                    break;
                }
                case ';': {
                    if (inParen != 0) break;
                    fragmentList.add(query.substring(fragmentStart, i));
                    fragmentStart = i + 1;
                    if (fragmentList.size() > 1 || ((String)fragmentList.get(0)).trim().length() > 0) {
                        statementList.add(fragmentList.toArray(new String[fragmentList.size()]));
                    }
                    fragmentList.clear();
                    break;
                }
            }
            ++i;
        }
        fragmentList.add(query.substring(fragmentStart));
        if (fragmentList.size() > 1 || ((String)fragmentList.get(0)).trim().length() > 0) {
            statementList.add(fragmentList.toArray(new String[fragmentList.size()]));
        }
        if (statementList.isEmpty()) {
            return EMPTY_QUERY;
        }
        if (statementList.size() == 1) {
            return new SimpleQuery((String[])statementList.get(0));
        }
        SimpleQuery[] subqueries = new SimpleQuery[statementList.size()];
        int[] offsets = new int[statementList.size()];
        int offset = 0;
        int i2 = 0;
        while (i2 < statementList.size()) {
            String[] fragments = (String[])statementList.get(i2);
            offsets[i2] = offset;
            subqueries[i2] = new SimpleQuery(fragments);
            offset += fragments.length - 1;
            ++i2;
        }
        return new CompositeQuery(subqueries, offsets);
    }

    public synchronized void execute(Query query, ParameterList parameters, ResultHandler handler, int maxRows, int fetchSize, int flags) throws SQLException {
        boolean describeOnly;
        if (this.logger.logDebug()) {
            this.logger.debug("simple execute, handler=" + handler + ", maxRows=" + maxRows + ", fetchSize=" + fetchSize + ", flags=" + flags);
        }
        if (parameters == null) {
            parameters = SimpleQuery.NO_PARAMETERS;
        }
        boolean bl = describeOnly = (0x20 & flags) != 0;
        if (!describeOnly) {
            ((V3ParameterList)parameters).checkAllParametersSet();
        }
        try {
            try {
                handler = this.sendQueryPreamble(handler, flags);
                this.sendQuery((V3Query)query, (V3ParameterList)parameters, maxRows, fetchSize, flags);
                this.sendSync();
                this.processResults(handler, flags);
            }
            catch (PGBindException se) {
                this.sendSync();
                this.processResults(handler, flags);
                handler.handleError(new PSQLException(GT.tr("Unable to bind parameter values for statement."), PSQLState.INVALID_PARAMETER_VALUE, (Throwable)se.getIOException()));
            }
        }
        catch (IOException e) {
            this.protoConnection.close();
            handler.handleError(new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)e));
        }
        handler.handleCompletion();
    }

    public synchronized void execute(Query[] queries, ParameterList[] parameterLists, ResultHandler handler, int maxRows, int fetchSize, int flags) throws SQLException {
        boolean describeOnly;
        if (this.logger.logDebug()) {
            this.logger.debug("batch execute " + queries.length + " queries, handler=" + handler + ", maxRows=" + maxRows + ", fetchSize=" + fetchSize + ", flags=" + flags);
        }
        boolean bl = describeOnly = (0x20 & flags) != 0;
        if (!describeOnly) {
            int i = 0;
            while (i < parameterLists.length) {
                if (parameterLists[i] != null) {
                    ((V3ParameterList)parameterLists[i]).checkAllParametersSet();
                }
                ++i;
            }
        }
        try {
            int queryCount = 0;
            handler = this.sendQueryPreamble(handler, flags);
            ErrorTrackingResultHandler trackingHandler = new ErrorTrackingResultHandler(handler);
            int i = 0;
            while (i < queries.length) {
                if (++queryCount >= 256) {
                    this.sendSync();
                    this.processResults(trackingHandler, flags);
                    if (trackingHandler.hasErrors()) break;
                    queryCount = 0;
                }
                V3Query query = (V3Query)queries[i];
                V3ParameterList parameters = (V3ParameterList)parameterLists[i];
                if (parameters == null) {
                    parameters = SimpleQuery.NO_PARAMETERS;
                }
                this.sendQuery(query, parameters, maxRows, fetchSize, flags);
                ++i;
            }
            if (!trackingHandler.hasErrors()) {
                this.sendSync();
                this.processResults(handler, flags);
            }
        }
        catch (IOException e) {
            this.protoConnection.close();
            handler.handleError(new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)e));
        }
        handler.handleCompletion();
    }

    private ResultHandler sendQueryPreamble(final ResultHandler delegateHandler, int flags) throws IOException {
        this.processDeadParsedQueries();
        this.processDeadPortals();
        if ((flags & 0x10) != 0 || this.protoConnection.getTransactionState() != 0) {
            return delegateHandler;
        }
        this.sendOneQuery(this.beginTransactionQuery, SimpleQuery.NO_PARAMETERS, 0, 0, 2);
        return new ResultHandler(){
            private boolean sawBegin = false;

            public void handleResultRows(Query fromQuery, Field[] fields, Vector tuples, ResultCursor cursor) {
                if (this.sawBegin) {
                    delegateHandler.handleResultRows(fromQuery, fields, tuples, cursor);
                }
            }

            public void handleCommandStatus(String status, int updateCount, long insertOID) {
                if (!this.sawBegin) {
                    this.sawBegin = true;
                    if (!status.equals("BEGIN")) {
                        this.handleError(new PSQLException(GT.tr("Expected command status BEGIN, got {0}.", status), PSQLState.PROTOCOL_VIOLATION));
                    }
                } else {
                    delegateHandler.handleCommandStatus(status, updateCount, insertOID);
                }
            }

            public void handleWarning(SQLWarning warning) {
                delegateHandler.handleWarning(warning);
            }

            public void handleError(SQLException error) {
                delegateHandler.handleError(error);
            }

            public void handleCompletion() throws SQLException {
                delegateHandler.handleCompletion();
            }
        };
    }

    public synchronized byte[] fastpathCall(int fnid, ParameterList parameters, boolean suppressBegin) throws SQLException {
        if (this.protoConnection.getTransactionState() == 0 && !suppressBegin) {
            if (this.logger.logDebug()) {
                this.logger.debug("Issuing BEGIN before fastpath call.");
            }
            ResultHandler handler = new ResultHandler(){
                private boolean sawBegin = false;
                private SQLException sqle = null;

                public void handleResultRows(Query fromQuery, Field[] fields, Vector tuples, ResultCursor cursor) {
                }

                public void handleCommandStatus(String status, int updateCount, long insertOID) {
                    if (!this.sawBegin) {
                        if (!status.equals("BEGIN")) {
                            this.handleError(new PSQLException(GT.tr("Expected command status BEGIN, got {0}.", status), PSQLState.PROTOCOL_VIOLATION));
                        }
                        this.sawBegin = true;
                    } else {
                        this.handleError(new PSQLException(GT.tr("Unexpected command status: {0}.", status), PSQLState.PROTOCOL_VIOLATION));
                    }
                }

                public void handleWarning(SQLWarning warning) {
                    this.handleError(warning);
                }

                public void handleError(SQLException error) {
                    if (this.sqle == null) {
                        this.sqle = error;
                    } else {
                        this.sqle.setNextException(error);
                    }
                }

                public void handleCompletion() throws SQLException {
                    if (this.sqle != null) {
                        throw this.sqle;
                    }
                }
            };
            try {
                this.sendOneQuery(this.beginTransactionQuery, SimpleQuery.NO_PARAMETERS, 0, 0, 2);
                this.sendSync();
                this.processResults(handler, 0);
            }
            catch (IOException ioe) {
                throw new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)ioe);
            }
        }
        try {
            this.sendFastpathCall(fnid, (SimpleParameterList)parameters);
            return this.receiveFastpathResult();
        }
        catch (IOException ioe) {
            this.protoConnection.close();
            throw new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)ioe);
        }
    }

    public ParameterList createFastpathParameters(int count) {
        return new SimpleParameterList(count);
    }

    private void sendFastpathCall(int fnid, SimpleParameterList params) throws SQLException, IOException {
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> FunctionCall(" + fnid + ", " + params.getParameterCount() + " params)");
        }
        int paramCount = params.getParameterCount();
        int encodedSize = 0;
        int i = 1;
        while (i <= paramCount) {
            encodedSize = params.isNull(i) ? (encodedSize += 4) : (encodedSize += 4 + params.getV3Length(i));
            ++i;
        }
        this.pgStream.SendChar(70);
        this.pgStream.SendInteger4(10 + 2 * paramCount + 2 + encodedSize + 2);
        this.pgStream.SendInteger4(fnid);
        this.pgStream.SendInteger2(paramCount);
        i = 1;
        while (i <= paramCount) {
            this.pgStream.SendInteger2(params.isBinary(i) ? 1 : 0);
            ++i;
        }
        this.pgStream.SendInteger2(paramCount);
        i = 1;
        while (i <= paramCount) {
            if (params.isNull(i)) {
                this.pgStream.SendInteger4(-1);
            } else {
                this.pgStream.SendInteger4(params.getV3Length(i));
                params.writeV3Value(i, this.pgStream);
            }
            ++i;
        }
        this.pgStream.SendInteger2(1);
        this.pgStream.flush();
    }

    /*
     * Exception decompiling
     */
    public synchronized void processNotifies() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private byte[] receiveFastpathResult() throws IOException, SQLException {
        boolean endQuery = false;
        SQLException error = null;
        byte[] returnValue = null;
        block7: while (!endQuery) {
            int c = this.pgStream.ReceiveChar();
            switch (c) {
                case 65: {
                    this.receiveAsyncNotify();
                    break;
                }
                case 69: {
                    SQLException newError = this.receiveErrorResponse();
                    if (error == null) {
                        error = newError;
                        break;
                    }
                    error.setNextException(newError);
                    break;
                }
                case 78: {
                    SQLWarning warning = this.receiveNoticeResponse();
                    this.protoConnection.addWarning(warning);
                    break;
                }
                case 90: {
                    this.receiveRFQ();
                    endQuery = true;
                    break;
                }
                case 86: {
                    this.pgStream.ReceiveIntegerR(4);
                    int valueLen = this.pgStream.ReceiveIntegerR(4);
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE FunctionCallResponse(" + valueLen + " bytes)");
                    }
                    if (valueLen == -1) continue block7;
                    byte[] buf = new byte[valueLen];
                    this.pgStream.Receive(buf, 0, valueLen);
                    returnValue = buf;
                    break;
                }
                default: {
                    throw new PSQLException(GT.tr("Unknown Response Type {0}.", new Character((char)c)), PSQLState.CONNECTION_FAILURE);
                }
            }
        }
        if (error != null) {
            throw error;
        }
        return returnValue;
    }

    private void sendQuery(V3Query query, V3ParameterList parameters, int maxRows, int fetchSize, int flags) throws IOException, SQLException {
        SimpleQuery[] subqueries = query.getSubqueries();
        SimpleParameterList[] subparams = parameters.getSubparams();
        if (subqueries == null) {
            this.sendOneQuery((SimpleQuery)query, (SimpleParameterList)parameters, maxRows, fetchSize, flags);
        } else {
            int i = 0;
            while (i < subqueries.length) {
                SimpleParameterList subparam = SimpleQuery.NO_PARAMETERS;
                if (subparams != null) {
                    subparam = subparams[i];
                }
                this.sendOneQuery(subqueries[i], subparam, maxRows, fetchSize, flags);
                ++i;
            }
        }
    }

    private void sendSync() throws IOException {
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> Sync");
        }
        this.pgStream.SendChar(83);
        this.pgStream.SendInteger4(4);
        this.pgStream.flush();
    }

    private void sendParse(SimpleQuery query, SimpleParameterList params, boolean oneShot) throws IOException {
        int[] typeOIDs = params.getTypeOIDs();
        if (query.isPreparedFor(typeOIDs)) {
            return;
        }
        query.unprepare();
        this.processDeadParsedQueries();
        String statementName = null;
        if (!oneShot) {
            statementName = "S_" + this.nextUniqueID++;
            query.setStatementName(statementName);
            query.setStatementTypes((int[])typeOIDs.clone());
        }
        byte[] encodedStatementName = query.getEncodedStatementName();
        String[] fragments = query.getFragments();
        if (this.logger.logDebug()) {
            StringBuffer sbuf = new StringBuffer(" FE=> Parse(stmt=" + statementName + ",query=\"");
            int i = 0;
            while (i < fragments.length) {
                if (i > 0) {
                    sbuf.append("$" + i);
                }
                sbuf.append(fragments[i]);
                ++i;
            }
            sbuf.append("\",oids={");
            i = 1;
            while (i <= params.getParameterCount()) {
                if (i != 1) {
                    sbuf.append(",");
                }
                sbuf.append("" + params.getTypeOID(i));
                ++i;
            }
            sbuf.append("})");
            this.logger.debug(sbuf.toString());
        }
        byte[][] parts = new byte[fragments.length * 2 - 1][];
        int j = 0;
        int encodedSize = 0;
        int i = 0;
        while (i < fragments.length) {
            if (i != 0) {
                parts[j] = Utils.encodeUTF8("$" + i);
                encodedSize += parts[j].length;
                ++j;
            }
            parts[j] = Utils.encodeUTF8(fragments[i]);
            encodedSize += parts[j].length;
            ++j;
            ++i;
        }
        encodedSize = 4 + (encodedStatementName == null ? 0 : encodedStatementName.length) + 1 + encodedSize + 1 + 2 + 4 * params.getParameterCount();
        this.pgStream.SendChar(80);
        this.pgStream.SendInteger4(encodedSize);
        if (encodedStatementName != null) {
            this.pgStream.Send(encodedStatementName);
        }
        this.pgStream.SendChar(0);
        i = 0;
        while (i < parts.length) {
            this.pgStream.Send(parts[i]);
            ++i;
        }
        this.pgStream.SendChar(0);
        this.pgStream.SendInteger2(params.getParameterCount());
        i = 1;
        while (i <= params.getParameterCount()) {
            this.pgStream.SendInteger4(params.getTypeOID(i));
            ++i;
        }
        this.pendingParseQueue.add(new Object[]{query, query.getStatementName()});
    }

    private void sendBind(SimpleQuery query, SimpleParameterList params, Portal portal) throws IOException {
        byte[] encodedPortalName;
        String statementName = query.getStatementName();
        byte[] encodedStatementName = query.getEncodedStatementName();
        byte[] byArray = encodedPortalName = portal == null ? null : portal.getEncodedPortalName();
        if (this.logger.logDebug()) {
            StringBuffer sbuf = new StringBuffer(" FE=> Bind(stmt=" + statementName + ",portal=" + portal);
            int i = 1;
            while (i <= params.getParameterCount()) {
                sbuf.append(",$" + i + "=<" + params.toString(i) + ">");
                ++i;
            }
            sbuf.append(")");
            this.logger.debug(sbuf.toString());
        }
        long encodedSize = 0L;
        int i = 1;
        while (i <= params.getParameterCount()) {
            encodedSize = params.isNull(i) ? (encodedSize += 4L) : (encodedSize += 4L + (long)params.getV3Length(i));
            ++i;
        }
        encodedSize = (long)(4 + (encodedPortalName == null ? 0 : encodedPortalName.length) + 1 + (encodedStatementName == null ? 0 : encodedStatementName.length) + 1 + 2 + params.getParameterCount() * 2 + 2) + encodedSize + 2L;
        if (encodedSize > 0x3FFFFFFFL) {
            throw new PGBindException(new IOException(GT.tr("Bind message length {0} too long.  This can be caused by very large or incorrect length specifications on InputStream parameters.", new Long(encodedSize))));
        }
        this.pgStream.SendChar(66);
        this.pgStream.SendInteger4((int)encodedSize);
        if (encodedPortalName != null) {
            this.pgStream.Send(encodedPortalName);
        }
        this.pgStream.SendChar(0);
        if (encodedStatementName != null) {
            this.pgStream.Send(encodedStatementName);
        }
        this.pgStream.SendChar(0);
        this.pgStream.SendInteger2(params.getParameterCount());
        i = 1;
        while (i <= params.getParameterCount()) {
            this.pgStream.SendInteger2(params.isBinary(i) ? 1 : 0);
            ++i;
        }
        this.pgStream.SendInteger2(params.getParameterCount());
        PGBindException bindException = null;
        int i2 = 1;
        while (i2 <= params.getParameterCount()) {
            if (params.isNull(i2)) {
                this.pgStream.SendInteger4(-1);
            } else {
                this.pgStream.SendInteger4(params.getV3Length(i2));
                try {
                    params.writeV3Value(i2, this.pgStream);
                }
                catch (PGBindException be) {
                    bindException = be;
                }
            }
            ++i2;
        }
        this.pgStream.SendInteger2(0);
        this.pendingBindQueue.add(portal);
        if (bindException != null) {
            throw bindException;
        }
    }

    private void sendDescribePortal(Portal portal) throws IOException {
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> Describe(portal=" + portal + ")");
        }
        byte[] encodedPortalName = portal == null ? null : portal.getEncodedPortalName();
        int encodedSize = 5 + (encodedPortalName == null ? 0 : encodedPortalName.length) + 1;
        this.pgStream.SendChar(68);
        this.pgStream.SendInteger4(encodedSize);
        this.pgStream.SendChar(80);
        if (encodedPortalName != null) {
            this.pgStream.Send(encodedPortalName);
        }
        this.pgStream.SendChar(0);
    }

    private void sendDescribeStatement(SimpleQuery query, SimpleParameterList params, boolean describeOnly) throws IOException {
        byte[] encodedStatementName;
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> Describe(statement=" + query.getStatementName() + ")");
        }
        int encodedSize = 5 + ((encodedStatementName = query.getEncodedStatementName()) == null ? 0 : encodedStatementName.length) + 1;
        this.pgStream.SendChar(68);
        this.pgStream.SendInteger4(encodedSize);
        this.pgStream.SendChar(83);
        if (encodedStatementName != null) {
            this.pgStream.Send(encodedStatementName);
        }
        this.pgStream.SendChar(0);
        this.pendingDescribeStatementQueue.add(new Object[]{query, params, new Boolean(describeOnly)});
    }

    private void sendExecute(Query query, Portal portal, int limit) throws IOException {
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> Execute(portal=" + portal + ",limit=" + limit + ")");
        }
        byte[] encodedPortalName = portal == null ? null : portal.getEncodedPortalName();
        int encodedSize = encodedPortalName == null ? 0 : encodedPortalName.length;
        this.pgStream.SendChar(69);
        this.pgStream.SendInteger4(5 + encodedSize + 4);
        if (encodedPortalName != null) {
            this.pgStream.Send(encodedPortalName);
        }
        this.pgStream.SendChar(0);
        this.pgStream.SendInteger4(limit);
        this.pendingExecuteQueue.add(new Object[]{query, portal});
    }

    private void sendClosePortal(String portalName) throws IOException {
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> ClosePortal(" + portalName + ")");
        }
        byte[] encodedPortalName = portalName == null ? null : Utils.encodeUTF8(portalName);
        int encodedSize = encodedPortalName == null ? 0 : encodedPortalName.length;
        this.pgStream.SendChar(67);
        this.pgStream.SendInteger4(6 + encodedSize);
        this.pgStream.SendChar(80);
        if (encodedPortalName != null) {
            this.pgStream.Send(encodedPortalName);
        }
        this.pgStream.SendChar(0);
    }

    private void sendCloseStatement(String statementName) throws IOException {
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> CloseStatement(" + statementName + ")");
        }
        byte[] encodedStatementName = Utils.encodeUTF8(statementName);
        this.pgStream.SendChar(67);
        this.pgStream.SendInteger4(5 + encodedStatementName.length + 1);
        this.pgStream.SendChar(83);
        this.pgStream.Send(encodedStatementName);
        this.pgStream.SendChar(0);
    }

    private void sendOneQuery(SimpleQuery query, SimpleParameterList params, int maxRows, int fetchSize, int flags) throws IOException {
        boolean describeStatement;
        boolean noResults = (flags & 4) != 0;
        boolean noMeta = (flags & 2) != 0;
        boolean describeOnly = (flags & 0x20) != 0;
        boolean usePortal = (flags & 8) != 0 && !noResults && !noMeta && fetchSize > 0 && !describeOnly;
        boolean oneShot = (flags & 1) != 0 && !usePortal;
        boolean bl = describeStatement = describeOnly || params.hasUnresolvedTypes() && !oneShot;
        int rows = noResults ? 1 : (!usePortal ? maxRows : (maxRows != 0 && fetchSize > maxRows ? maxRows : fetchSize));
        this.sendParse(query, params, oneShot);
        if (describeStatement) {
            this.sendDescribeStatement(query, params, describeOnly);
            if (describeOnly) {
                return;
            }
        }
        Portal portal = null;
        if (usePortal) {
            String portalName = "C_" + this.nextUniqueID++;
            portal = new Portal(query, portalName);
        }
        this.sendBind(query, params, portal);
        if (!noMeta && !describeStatement) {
            this.sendDescribePortal(portal);
        }
        this.sendExecute(query, portal, rows);
    }

    private void registerParsedQuery(SimpleQuery query, String statementName) {
        if (statementName == null) {
            return;
        }
        PhantomReference<SimpleQuery> cleanupRef = new PhantomReference<SimpleQuery>(query, this.parsedQueryCleanupQueue);
        this.parsedQueryMap.put(cleanupRef, statementName);
        query.setCleanupRef(cleanupRef);
    }

    private void processDeadParsedQueries() throws IOException {
        PhantomReference deadQuery;
        while ((deadQuery = (PhantomReference)this.parsedQueryCleanupQueue.poll()) != null) {
            String statementName = (String)this.parsedQueryMap.remove(deadQuery);
            this.sendCloseStatement(statementName);
            deadQuery.clear();
        }
    }

    private void registerOpenPortal(Portal portal) {
        if (portal == null) {
            return;
        }
        String portalName = portal.getPortalName();
        PhantomReference<Portal> cleanupRef = new PhantomReference<Portal>(portal, this.openPortalCleanupQueue);
        this.openPortalMap.put(cleanupRef, portalName);
        portal.setCleanupRef(cleanupRef);
    }

    private void processDeadPortals() throws IOException {
        PhantomReference deadPortal;
        while ((deadPortal = (PhantomReference)this.openPortalCleanupQueue.poll()) != null) {
            String portalName = (String)this.openPortalMap.remove(deadPortal);
            this.sendClosePortal(portalName);
            deadPortal.clear();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void processResults(ResultHandler handler, int flags) throws IOException {
        noResults = (flags & 4) != 0;
        fields = null;
        tuples = null;
        endQuery = false;
        doneAfterRowDescNoData = false;
        parseIndex = 0;
        describeIndex = 0;
        bindIndex = 0;
        executeIndex = 0;
        block20: while (!endQuery) {
            c = this.pgStream.ReceiveChar();
            switch (c) {
                case 65: {
                    this.receiveAsyncNotify();
                    break;
                }
                case 49: {
                    this.pgStream.ReceiveIntegerR(4);
                    parsedQueryAndStatement = (Object[])this.pendingParseQueue.get(parseIndex++);
                    parsedQuery = (SimpleQuery)parsedQueryAndStatement[0];
                    parsedStatementName = (String)parsedQueryAndStatement[1];
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE ParseComplete [" + parsedStatementName + "]");
                    }
                    this.registerParsedQuery(parsedQuery, parsedStatementName);
                    break;
                }
                case 116: {
                    this.pgStream.ReceiveIntegerR(4);
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE ParameterDescription");
                    }
                    describeData = (Object[])this.pendingDescribeStatementQueue.get(describeIndex);
                    query = (SimpleQuery)describeData[0];
                    params = (SimpleParameterList)describeData[1];
                    describeOnly = (Boolean)describeData[2];
                    numParams = this.pgStream.ReceiveIntegerR(2);
                    i = 1;
                    while (i <= numParams) {
                        typeOid = this.pgStream.ReceiveIntegerR(4);
                        params.setResolvedType(i, typeOid);
                        ++i;
                    }
                    query.setStatementTypes((int[])params.getTypeOIDs().clone());
                    if (describeOnly) {
                        doneAfterRowDescNoData = true;
                        break;
                    }
                    ++describeIndex;
                    break;
                }
                case 50: {
                    this.pgStream.ReceiveIntegerR(4);
                    boundPortal = (Portal)this.pendingBindQueue.get(bindIndex++);
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE BindComplete [" + boundPortal + "]");
                    }
                    this.registerOpenPortal(boundPortal);
                    break;
                }
                case 51: {
                    this.pgStream.ReceiveIntegerR(4);
                    if (!this.logger.logDebug()) continue block20;
                    this.logger.debug(" <=BE CloseComplete");
                    break;
                }
                case 110: {
                    this.pgStream.ReceiveIntegerR(4);
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE NoData");
                    }
                    if (!doneAfterRowDescNoData) continue block20;
                    describeData = (Object[])this.pendingDescribeStatementQueue.get(describeIndex++);
                    currentQuery = (Query)describeData[0];
                    if (fields == null && tuples == null) continue block20;
                    handler.handleResultRows(currentQuery, fields, tuples, null);
                    fields = null;
                    tuples = null;
                    break;
                }
                case 115: {
                    this.pgStream.ReceiveIntegerR(4);
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE PortalSuspended");
                    }
                    executeData = (Object[])this.pendingExecuteQueue.get(executeIndex++);
                    currentQuery = (Query)executeData[0];
                    currentPortal = (Portal)executeData[1];
                    handler.handleResultRows(currentQuery, fields, tuples, currentPortal);
                    fields = null;
                    tuples = null;
                    break;
                }
                case 67: {
                    status = this.receiveCommandStatus();
                    doneAfterRowDescNoData = false;
                    executeData = (Object[])this.pendingExecuteQueue.get(executeIndex++);
                    currentQuery = (Query)executeData[0];
                    currentPortal = (Portal)executeData[1];
                    if (fields != null || tuples != null) {
                        handler.handleResultRows(currentQuery, fields, tuples, null);
                        fields = null;
                        tuples = null;
                    } else {
                        this.interpretCommandStatus(status, handler);
                    }
                    if (currentPortal == null) continue block20;
                    currentPortal.close();
                    break;
                }
                case 68: {
                    tuple = null;
                    try {
                        tuple = this.pgStream.ReceiveTupleV3();
                    }
                    catch (OutOfMemoryError oome) {
                        if (noResults) ** GOTO lbl110
                        handler.handleError(new PSQLException(GT.tr("Ran out of memory retrieving query results."), PSQLState.OUT_OF_MEMORY, (Throwable)oome));
                    }
lbl110:
                    // 3 sources

                    if (!noResults) {
                        if (tuples == null) {
                            tuples = new Vector<E>();
                        }
                        tuples.addElement(tuple);
                    }
                    if (!this.logger.logDebug()) continue block20;
                    this.logger.debug(" <=BE DataRow");
                    break;
                }
                case 69: {
                    error = this.receiveErrorResponse();
                    handler.handleError(error);
                    break;
                }
                case 73: {
                    this.pgStream.ReceiveIntegerR(4);
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE EmptyQuery");
                    }
                    executeData = (Object[])this.pendingExecuteQueue.get(executeIndex++);
                    (Query)executeData[0];
                    currentPortal = (Portal)executeData[1];
                    handler.handleCommandStatus("EMPTY", 0, 0L);
                    if (currentPortal == null) continue block20;
                    currentPortal.close();
                    break;
                }
                case 78: {
                    warning = this.receiveNoticeResponse();
                    handler.handleWarning(warning);
                    break;
                }
                case 83: {
                    this.pgStream.ReceiveIntegerR(4);
                    name = this.pgStream.ReceiveString();
                    value = this.pgStream.ReceiveString();
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE ParameterStatus(" + name + " = " + value + ")");
                    }
                    if (name.equals("client_encoding") && !value.equalsIgnoreCase("UNICODE") && !this.allowEncodingChanges) {
                        this.protoConnection.close();
                        handler.handleError(new PSQLException(GT.tr("The server''s client_encoding parameter was changed to {0}. The JDBC driver requires client_encoding to be UNICODE for correct operation.", value), PSQLState.CONNECTION_FAILURE));
                        endQuery = true;
                    }
                    if (name.equals("DateStyle") && !value.startsWith("ISO,")) {
                        this.protoConnection.close();
                        handler.handleError(new PSQLException(GT.tr("The server''s DateStyle parameter was changed to {0}. The JDBC driver requires DateStyle to begin with ISO for correct operation.", value), PSQLState.CONNECTION_FAILURE));
                        endQuery = true;
                    }
                    if (!name.equals("standard_conforming_strings")) continue block20;
                    if (value.equals("on")) {
                        this.protoConnection.setStandardConformingStrings(true);
                        break;
                    }
                    if (value.equals("off")) {
                        this.protoConnection.setStandardConformingStrings(false);
                        break;
                    }
                    this.protoConnection.close();
                    handler.handleError(new PSQLException(GT.tr("The server''s standard_conforming_strings parameter was reported as {0}. The JDBC driver expected on or off.", value), PSQLState.CONNECTION_FAILURE));
                    endQuery = true;
                    break;
                }
                case 84: {
                    fields = this.receiveFields();
                    tuples = new Vector<byte[][]>();
                    if (!doneAfterRowDescNoData) continue block20;
                    describeData = (Object[])this.pendingDescribeStatementQueue.get(describeIndex++);
                    currentQuery = (Query)describeData[0];
                    if (fields == null && tuples == null) continue block20;
                    handler.handleResultRows(currentQuery, fields, tuples, null);
                    fields = null;
                    tuples = null;
                    break;
                }
                case 90: {
                    this.receiveRFQ();
                    endQuery = true;
                    while (parseIndex < this.pendingParseQueue.size()) {
                        failedQueryAndStatement = (Object[])this.pendingParseQueue.get(parseIndex++);
                        failedQuery = (SimpleQuery)failedQueryAndStatement[0];
                        failedQuery.unprepare();
                    }
                    this.pendingParseQueue.clear();
                    this.pendingDescribeStatementQueue.clear();
                    this.pendingBindQueue.clear();
                    this.pendingExecuteQueue.clear();
                    break;
                }
                case 71: 
                case 72: 
                case 99: 
                case 100: {
                    l_len = this.pgStream.ReceiveIntegerR(4);
                    this.pgStream.Receive(l_len);
                    handler.handleError(new PSQLException(GT.tr("The driver currently does not support COPY operations."), PSQLState.NOT_IMPLEMENTED));
                    break;
                }
                default: {
                    throw new IOException("Unexpected packet type: " + c);
                }
            }
        }
    }

    public synchronized void fetch(ResultCursor cursor, ResultHandler handler, int fetchSize) throws SQLException {
        final Portal portal = (Portal)cursor;
        final ResultHandler delegateHandler = handler;
        handler = new ResultHandler(){

            public void handleResultRows(Query fromQuery, Field[] fields, Vector tuples, ResultCursor cursor) {
                delegateHandler.handleResultRows(fromQuery, fields, tuples, cursor);
            }

            public void handleCommandStatus(String status, int updateCount, long insertOID) {
                this.handleResultRows(portal.getQuery(), null, new Vector(), null);
            }

            public void handleWarning(SQLWarning warning) {
                delegateHandler.handleWarning(warning);
            }

            public void handleError(SQLException error) {
                delegateHandler.handleError(error);
            }

            public void handleCompletion() throws SQLException {
                delegateHandler.handleCompletion();
            }
        };
        try {
            this.processDeadParsedQueries();
            this.processDeadPortals();
            this.sendExecute(portal.getQuery(), portal, fetchSize);
            this.sendSync();
            this.processResults(handler, 0);
        }
        catch (IOException e) {
            this.protoConnection.close();
            handler.handleError(new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)e));
        }
        handler.handleCompletion();
    }

    private Field[] receiveFields() throws IOException {
        this.pgStream.ReceiveIntegerR(4);
        int size = this.pgStream.ReceiveIntegerR(2);
        Field[] fields = new Field[size];
        if (this.logger.logDebug()) {
            this.logger.debug(" <=BE RowDescription(" + size + ")");
        }
        int i = 0;
        while (i < fields.length) {
            String columnLabel = this.pgStream.ReceiveString();
            int tableOid = this.pgStream.ReceiveIntegerR(4);
            short positionInTable = (short)this.pgStream.ReceiveIntegerR(2);
            int typeOid = this.pgStream.ReceiveIntegerR(4);
            int typeLength = this.pgStream.ReceiveIntegerR(2);
            int typeModifier = this.pgStream.ReceiveIntegerR(4);
            int formatType = this.pgStream.ReceiveIntegerR(2);
            fields[i] = new Field(columnLabel, null, typeOid, typeLength, typeModifier, tableOid, positionInTable);
            fields[i].setFormat(formatType);
            ++i;
        }
        return fields;
    }

    private void receiveAsyncNotify() throws IOException {
        this.pgStream.ReceiveIntegerR(4);
        int pid = this.pgStream.ReceiveIntegerR(4);
        String msg = this.pgStream.ReceiveString();
        String param = this.pgStream.ReceiveString();
        this.protoConnection.addNotification(new Notification(msg, pid, param));
        if (this.logger.logDebug()) {
            this.logger.debug(" <=BE AsyncNotify(" + pid + "," + msg + "," + param + ")");
        }
    }

    private SQLException receiveErrorResponse() throws IOException {
        int elen = this.pgStream.ReceiveIntegerR(4);
        String totalMessage = this.pgStream.ReceiveString(elen - 4);
        ServerErrorMessage errorMsg = new ServerErrorMessage(totalMessage, this.logger.getLogLevel());
        if (this.logger.logDebug()) {
            this.logger.debug(" <=BE ErrorMessage(" + errorMsg.toString() + ")");
        }
        return new PSQLException(errorMsg);
    }

    private SQLWarning receiveNoticeResponse() throws IOException {
        int nlen = this.pgStream.ReceiveIntegerR(4);
        ServerErrorMessage warnMsg = new ServerErrorMessage(this.pgStream.ReceiveString(nlen - 4), this.logger.getLogLevel());
        if (this.logger.logDebug()) {
            this.logger.debug(" <=BE NoticeResponse(" + warnMsg.toString() + ")");
        }
        return new PSQLWarning(warnMsg);
    }

    private String receiveCommandStatus() throws IOException {
        int l_len = this.pgStream.ReceiveIntegerR(4);
        String status = this.pgStream.ReceiveString(l_len - 5);
        this.pgStream.Receive(1);
        if (this.logger.logDebug()) {
            this.logger.debug(" <=BE CommandStatus(" + status + ")");
        }
        return status;
    }

    private void interpretCommandStatus(String status, ResultHandler handler) {
        int update_count = 0;
        long insert_oid = 0L;
        if (status.startsWith("INSERT") || status.startsWith("UPDATE") || status.startsWith("DELETE") || status.startsWith("MOVE")) {
            try {
                update_count = Integer.parseInt(status.substring(1 + status.lastIndexOf(32)));
                if (status.startsWith("INSERT")) {
                    insert_oid = Long.parseLong(status.substring(1 + status.indexOf(32), status.lastIndexOf(32)));
                }
            }
            catch (NumberFormatException numberFormatException) {
                handler.handleError(new PSQLException(GT.tr("Unable to interpret the update count in command completion tag: {0}.", status), PSQLState.CONNECTION_FAILURE));
                return;
            }
        }
        handler.handleCommandStatus(status, update_count, insert_oid);
    }

    private void receiveRFQ() throws IOException {
        if (this.pgStream.ReceiveIntegerR(4) != 5) {
            throw new IOException("unexpected length of ReadyForQuery message");
        }
        char tStatus = (char)this.pgStream.ReceiveChar();
        if (this.logger.logDebug()) {
            this.logger.debug(" <=BE ReadyForQuery(" + tStatus + ")");
        }
        switch (tStatus) {
            case 'I': {
                this.protoConnection.setTransactionState(0);
                break;
            }
            case 'T': {
                this.protoConnection.setTransactionState(1);
                break;
            }
            case 'E': {
                this.protoConnection.setTransactionState(2);
                break;
            }
            default: {
                throw new IOException("unexpected transaction state in ReadyForQuery message: " + tStatus);
            }
        }
    }

    private static class ErrorTrackingResultHandler
    implements ResultHandler {
        private final ResultHandler delegateHandler;
        private boolean sawError = false;

        ErrorTrackingResultHandler(ResultHandler delegateHandler) {
            this.delegateHandler = delegateHandler;
        }

        public void handleResultRows(Query fromQuery, Field[] fields, Vector tuples, ResultCursor cursor) {
            this.delegateHandler.handleResultRows(fromQuery, fields, tuples, cursor);
        }

        public void handleCommandStatus(String status, int updateCount, long insertOID) {
            this.delegateHandler.handleCommandStatus(status, updateCount, insertOID);
        }

        public void handleWarning(SQLWarning warning) {
            this.delegateHandler.handleWarning(warning);
        }

        public void handleError(SQLException error) {
            this.sawError = true;
            this.delegateHandler.handleError(error);
        }

        public void handleCompletion() throws SQLException {
            this.delegateHandler.handleCompletion();
        }

        boolean hasErrors() {
            return this.sawError;
        }
    }
}

