/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import liquibase.change.AbstractChange;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AddAutoIncrementStatement;
import liquibase.statement.core.AddDefaultValueStatement;
import liquibase.statement.core.CreateSequenceStatement;
import liquibase.statement.core.SetNullableStatement;
import liquibase.util.StringUtils;

public class AddAutoIncrementChange
extends AbstractChange {
    private String schemaName;
    private String tableName;
    private String columnName;
    private String columnDataType;

    public AddAutoIncrementChange() {
        super("addAutoIncrement", "Set Column as Auto-Increment", 1);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = StringUtils.trimToNull(schemaName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getColumnDataType() {
        return this.columnDataType;
    }

    public void setColumnDataType(String columnDataType) {
        this.columnDataType = columnDataType;
    }

    public SqlStatement[] generateStatements(Database database) {
        if (database instanceof PostgresDatabase) {
            String sequenceName = (this.getTableName() + "_" + this.getColumnName() + "_seq").toLowerCase();
            return new SqlStatement[]{new CreateSequenceStatement(this.schemaName, sequenceName), new SetNullableStatement(this.schemaName, this.getTableName(), this.getColumnName(), null, false), new AddDefaultValueStatement(this.schemaName, this.getTableName(), this.getColumnName(), this.getColumnDataType(), new DatabaseFunction("NEXTVAL('" + sequenceName + "')"))};
        }
        return new SqlStatement[]{new AddAutoIncrementStatement(this.getSchemaName(), this.getTableName(), this.getColumnName(), this.getColumnDataType())};
    }

    public String getConfirmationMessage() {
        return "Auto-increment added to " + this.getTableName() + "." + this.getColumnName();
    }
}

