/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import liquibase.database.AbstractDatabase;
import liquibase.database.DatabaseConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.ExecutorService;
import liquibase.statement.core.GetViewDefinitionStatement;
import liquibase.statement.core.RawSqlStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InformixDatabase
extends AbstractDatabase {
    private static final String PRODUCT_NAME = "Informix Dynamic Server";
    private static final String INTERVAL_FIELD_QUALIFIER = "HOUR TO FRACTION(5)";
    private static final String DATETIME_FIELD_QUALIFIER = "YEAR TO FRACTION(5)";
    private Set<String> systemTablesAndViews = new HashSet<String>();
    private static final Pattern CREATE_VIEW_AS_PATTERN = Pattern.compile("^CREATE\\s+.*?VIEW\\s+.*?AS\\s+", 34);

    public InformixDatabase() {
        this.systemTablesAndViews.add("systables");
        this.systemTablesAndViews.add("syscolumns");
        this.systemTablesAndViews.add("sysindices");
        this.systemTablesAndViews.add("systabauth");
        this.systemTablesAndViews.add("syscolauth");
        this.systemTablesAndViews.add("sysviews");
        this.systemTablesAndViews.add("sysusers");
        this.systemTablesAndViews.add("sysdepend");
        this.systemTablesAndViews.add("syssynonyms");
        this.systemTablesAndViews.add("syssyntable");
        this.systemTablesAndViews.add("sysconstraints");
        this.systemTablesAndViews.add("sysreferences");
        this.systemTablesAndViews.add("syschecks");
        this.systemTablesAndViews.add("sysdefaults");
        this.systemTablesAndViews.add("syscoldepend");
        this.systemTablesAndViews.add("sysprocedures");
        this.systemTablesAndViews.add("sysprocbody");
        this.systemTablesAndViews.add("sysprocplan");
        this.systemTablesAndViews.add("sysprocauth");
        this.systemTablesAndViews.add("sysblobs");
        this.systemTablesAndViews.add("sysopclstr");
        this.systemTablesAndViews.add("systriggers");
        this.systemTablesAndViews.add("systrigbody");
        this.systemTablesAndViews.add("sysdistrib");
        this.systemTablesAndViews.add("sysfragments");
        this.systemTablesAndViews.add("sysobjstate");
        this.systemTablesAndViews.add("sysviolations");
        this.systemTablesAndViews.add("sysfragauth");
        this.systemTablesAndViews.add("sysroleauth");
        this.systemTablesAndViews.add("sysxtdtypes");
        this.systemTablesAndViews.add("sysattrtypes");
        this.systemTablesAndViews.add("sysxtddesc");
        this.systemTablesAndViews.add("sysinherits");
        this.systemTablesAndViews.add("syscolattribs");
        this.systemTablesAndViews.add("syslogmap");
        this.systemTablesAndViews.add("syscasts");
        this.systemTablesAndViews.add("sysxtdtypeauth");
        this.systemTablesAndViews.add("sysroutinelangs");
        this.systemTablesAndViews.add("syslangauth");
        this.systemTablesAndViews.add("sysams");
        this.systemTablesAndViews.add("systabamdata");
        this.systemTablesAndViews.add("sysopclasses");
        this.systemTablesAndViews.add("syserrors");
        this.systemTablesAndViews.add("systraceclasses");
        this.systemTablesAndViews.add("systracemsgs");
        this.systemTablesAndViews.add("sysaggregates");
        this.systemTablesAndViews.add("syssequences");
        this.systemTablesAndViews.add("sysdirectives");
        this.systemTablesAndViews.add("sysxasourcetypes");
        this.systemTablesAndViews.add("sysxadatasources");
        this.systemTablesAndViews.add("sysseclabelcomponents");
        this.systemTablesAndViews.add("sysseclabelcomponentelements");
        this.systemTablesAndViews.add("syssecpolicies");
        this.systemTablesAndViews.add("syssecpolicycomponents");
        this.systemTablesAndViews.add("syssecpolicyexemptions");
        this.systemTablesAndViews.add("sysseclabels");
        this.systemTablesAndViews.add("sysseclabelnames");
        this.systemTablesAndViews.add("sysseclabelauth");
        this.systemTablesAndViews.add("syssurrogateauth");
        this.systemTablesAndViews.add("sysproccolumns");
        this.systemTablesAndViews.add("sysdomains");
        this.systemTablesAndViews.add("sysindexes");
    }

    @Override
    protected Set<String> getSystemTablesAndViews() {
        return this.systemTablesAndViews;
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public void setConnection(DatabaseConnection connection) {
        super.setConnection(connection);
        try {
            ExecutorService.getInstance().getExecutor(this).execute(new RawSqlStatement("EXECUTE PROCEDURE IFX_ALLOW_NEWLINE('T');"));
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException("Could not allow newline characters in quoted strings with IFX_ALLOW_NEWLINE", e);
        }
    }

    @Override
    public String getCurrentDateTimeFunction() {
        if (this.currentDateTimeFunction != null) {
            return this.currentDateTimeFunction;
        }
        return "CURRENT YEAR TO FRACTION(5)";
    }

    @Override
    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:informix-sqli")) {
            return "com.informix.jdbc.IfxDriver";
        }
        return null;
    }

    @Override
    public String getTypeName() {
        return "informix";
    }

    @Override
    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return PRODUCT_NAME.equals(conn.getDatabaseProductName());
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    @Override
    public boolean supportsTablespaces() {
        return true;
    }

    @Override
    public String getViewDefinition(String schemaName, String viewName) throws DatabaseException {
        List<Map> retList = ExecutorService.getInstance().getExecutor(this).queryForList(new GetViewDefinitionStatement(schemaName, viewName));
        StringBuilder sb = new StringBuilder();
        for (Map rowMap : retList) {
            String s = (String)rowMap.get("VIEWTEXT");
            sb.append(s);
        }
        return CREATE_VIEW_AS_PATTERN.matcher(sb.toString()).replaceFirst("");
    }

    @Override
    public String getAutoIncrementClause() {
        return "";
    }

    @Override
    public String getDateLiteral(String isoDate) {
        if (this.isTimeOnly(isoDate)) {
            return "INTERVAL (" + super.getDateLiteral(isoDate).replaceAll("'", "") + ") " + INTERVAL_FIELD_QUALIFIER;
        }
        if (this.isDateOnly(isoDate)) {
            return super.getDateLiteral(isoDate);
        }
        return "DATETIME (" + super.getDateLiteral(isoDate).replaceAll("'", "") + ") " + DATETIME_FIELD_QUALIFIER;
    }

    @Override
    public boolean supportsRestrictForeignKeys() {
        return false;
    }

    @Override
    public boolean supportsSchemas() {
        return false;
    }
}

