/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import java.util.HashSet;
import java.util.Set;
import liquibase.database.AbstractDatabase;
import liquibase.database.DatabaseConnection;
import liquibase.exception.DatabaseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSSQLDatabase
extends AbstractDatabase {
    public static final String PRODUCT_NAME = "Microsoft SQL Server";
    protected Set<String> systemTablesAndViews = new HashSet<String>();

    @Override
    public String getTypeName() {
        return "mssql";
    }

    public MSSQLDatabase() {
        this.systemTablesAndViews.add("syscolumns");
        this.systemTablesAndViews.add("syscomments");
        this.systemTablesAndViews.add("sysdepends");
        this.systemTablesAndViews.add("sysfilegroups");
        this.systemTablesAndViews.add("sysfiles");
        this.systemTablesAndViews.add("sysfiles1");
        this.systemTablesAndViews.add("sysforeignkeys");
        this.systemTablesAndViews.add("sysfulltextcatalogs");
        this.systemTablesAndViews.add("sysfulltextnotify");
        this.systemTablesAndViews.add("sysindexes");
        this.systemTablesAndViews.add("sysindexkeys");
        this.systemTablesAndViews.add("sysmembers");
        this.systemTablesAndViews.add("sysobjects");
        this.systemTablesAndViews.add("syspermissions");
        this.systemTablesAndViews.add("sysproperties");
        this.systemTablesAndViews.add("sysprotects");
        this.systemTablesAndViews.add("sysreferences");
        this.systemTablesAndViews.add("systypes");
        this.systemTablesAndViews.add("sysusers");
        this.systemTablesAndViews.add("syssegments");
        this.systemTablesAndViews.add("sysconstraints");
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public Set<String> getSystemTablesAndViews() {
        return this.systemTablesAndViews;
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    @Override
    public boolean supportsSequences() {
        return false;
    }

    @Override
    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        String databaseProductName = conn.getDatabaseProductName();
        return PRODUCT_NAME.equalsIgnoreCase(databaseProductName) || "SQLOLEDB".equalsIgnoreCase(databaseProductName);
    }

    @Override
    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:sqlserver")) {
            return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        }
        if (url.startsWith("jdbc:jtds:sqlserver")) {
            return "net.sourceforge.jtds.jdbc.Driver";
        }
        return null;
    }

    @Override
    public String getCurrentDateTimeFunction() {
        if (this.currentDateTimeFunction != null) {
            return this.currentDateTimeFunction;
        }
        return "GETDATE()";
    }

    @Override
    public String getAutoIncrementClause() {
        return "IDENTITY";
    }

    @Override
    protected String getDefaultDatabaseSchemaName() throws DatabaseException {
        return null;
    }

    @Override
    public String getDefaultCatalogName() throws DatabaseException {
        return this.getConnection().getCatalog();
    }

    @Override
    public String getConcatSql(String ... values) {
        StringBuffer returnString = new StringBuffer();
        for (String value : values) {
            returnString.append(value).append(" + ");
        }
        return returnString.toString().replaceFirst(" \\+ $", "");
    }

    @Override
    public String escapeIndexName(String schemaName, String indexName) {
        return super.escapeIndexName(null, indexName);
    }

    @Override
    public boolean supportsTablespaces() {
        return true;
    }

    @Override
    public boolean isSystemTable(String catalogName, String schemaName, String tableName) {
        return super.isSystemTable(catalogName, schemaName, tableName) || schemaName.equals("sys");
    }

    @Override
    public boolean isSystemView(String catalogName, String schemaName, String viewName) {
        return super.isSystemView(catalogName, schemaName, viewName) || schemaName.equals("sys");
    }

    public String generateDefaultConstraintName(String tableName, String columnName) {
        return "DF_" + tableName + "_" + columnName;
    }

    @Override
    public String escapeDatabaseObject(String objectName) {
        return "[" + objectName + "]";
    }

    @Override
    public String convertRequestedSchemaToCatalog(String requestedSchema) throws DatabaseException {
        return this.getDefaultCatalogName();
    }

    @Override
    public String convertRequestedSchemaToSchema(String requestedSchema) throws DatabaseException {
        if (requestedSchema == null) {
            requestedSchema = this.getDefaultDatabaseSchemaName();
        }
        if (requestedSchema == null) {
            return "dbo";
        }
        return requestedSchema;
    }

    @Override
    public String getDateLiteral(String isoDate) {
        return super.getDateLiteral(isoDate).replace(' ', 'T');
    }

    @Override
    public boolean supportsRestrictForeignKeys() {
        return false;
    }

    @Override
    public String getDefaultSchemaName() {
        String defaultSchemaName = super.getDefaultSchemaName();
        if (defaultSchemaName == null) {
            return "dbo";
        }
        return defaultSchemaName;
    }
}

