/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.structure;

import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Table;
import liquibase.database.structure.View;
import liquibase.util.SqlUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Column
implements DatabaseObject,
Comparable<Column> {
    private Table table;
    private View view;
    private String name;
    private int dataType;
    private int columnSize;
    private int decimalDigits;
    private LengthSemantics lengthSemantics;
    private Boolean nullable;
    private String typeName;
    private Object defaultValue;
    private boolean autoIncrement = false;
    private boolean primaryKey = false;
    private boolean unique = false;
    private boolean initPrecision = true;
    private boolean certainDataType = true;
    private String remarks;
    private String tablespace;

    public Table getTable() {
        return this.table;
    }

    @Override
    public DatabaseObject[] getContainingObjects() {
        return new DatabaseObject[]{this.getTable()};
    }

    public Column setTable(Table table) {
        this.table = table;
        return this;
    }

    public View getView() {
        return this.view;
    }

    public Column setView(View view) {
        this.view = view;
        return this;
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public Column setTablespace(String tablespace) {
        this.tablespace = tablespace;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Column setName(String name) {
        this.name = name;
        return this;
    }

    public int getDataType() {
        return this.dataType;
    }

    public Column setDataType(int dataType) {
        this.dataType = dataType;
        return this;
    }

    public int getColumnSize() {
        return this.columnSize;
    }

    public Column setColumnSize(int columnSize) {
        this.columnSize = columnSize;
        return this;
    }

    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    public Column setDecimalDigits(int decimalDigits) {
        this.decimalDigits = decimalDigits;
        return this;
    }

    public Boolean isNullable() {
        return this.nullable;
    }

    public Column setNullable(Boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Column setTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Column setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public String toString() {
        String tableOrViewName = this.table == null ? this.view.getName() : this.table.getName();
        return tableOrViewName + "." + this.getName();
    }

    @Override
    public int compareTo(Column o) {
        try {
            int returnValue = 0;
            if (this.getTable() != null && o.getTable() == null) {
                return 1;
            }
            if (this.getTable() == null && o.getTable() != null) {
                return -1;
            }
            returnValue = this.getTable() == null && o.getTable() == null ? this.getView().compareTo(o.getView()) : this.getTable().compareTo(o.getTable());
            if (returnValue == 0) {
                returnValue = this.getName().compareTo(o.getName());
            }
            return returnValue;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        try {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Column column = (Column)o;
            return this.name.equalsIgnoreCase(column.name) && !(this.table == null ? column.table != null : !this.table.equals(column.table)) && !(this.view == null ? column.view != null : !this.view.equals(column.view));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        try {
            int result = this.table != null ? this.table.hashCode() : 0;
            result = 31 * result + (this.view != null ? this.view.hashCode() : 0);
            result = 31 * result + this.name.toUpperCase().hashCode();
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isNumeric() {
        return SqlUtil.isNumeric(this.getDataType());
    }

    public boolean isUnique() {
        return this.unique;
    }

    public Column setUnique(boolean unique) {
        this.unique = unique;
        return this;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public Column setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
        return this;
    }

    public boolean isDataTypeDifferent(Column otherColumn) {
        if (!this.isCertainDataType() || !otherColumn.isCertainDataType()) {
            return false;
        }
        return this.getDataType() != otherColumn.getDataType() || this.getColumnSize() != otherColumn.getColumnSize() || this.getDecimalDigits() != otherColumn.getDecimalDigits() || this.getLengthSemantics() != otherColumn.getLengthSemantics();
    }

    public boolean isNullabilityDifferent(Column otherColumn) {
        if (this.isNullable() == null && otherColumn.isNullable() == null) {
            return false;
        }
        if (this.isNullable() == null && otherColumn.isNullable() != null) {
            return true;
        }
        if (this.isNullable() != null && otherColumn.isNullable() == null) {
            return true;
        }
        return !this.isNullable().equals(otherColumn.isNullable());
    }

    public boolean isDifferent(Column otherColumn) {
        return this.isDataTypeDifferent(otherColumn) || this.isNullabilityDifferent(otherColumn);
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public Column setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
        return this;
    }

    public boolean isCertainDataType() {
        return this.certainDataType;
    }

    public Column setCertainDataType(boolean certainDataType) {
        this.certainDataType = certainDataType;
        return this;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public Column setRemarks(String remarks) {
        this.remarks = remarks;
        return this;
    }

    public boolean isInitPrecision() {
        return this.initPrecision;
    }

    public void setInitPrecision(boolean initPrecision) {
        this.initPrecision = initPrecision;
    }

    public LengthSemantics getLengthSemantics() {
        return this.lengthSemantics;
    }

    public Column setLengthSemantics(LengthSemantics lengthSemantics) {
        this.lengthSemantics = lengthSemantics;
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LengthSemantics {
        CHAR,
        BYTE;

    }
}

