/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.structure.DatabaseObject;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.core.FindForeignKeyConstraintsStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindForeignKeyConstraintsGeneratorMSSQL
extends AbstractSqlGenerator<FindForeignKeyConstraintsStatement> {
    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public boolean supports(FindForeignKeyConstraintsStatement statement, Database database) {
        return database instanceof MSSQLDatabase;
    }

    @Override
    public ValidationErrors validate(FindForeignKeyConstraintsStatement findForeignKeyConstraintsStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("baseTableName", findForeignKeyConstraintsStatement.getBaseTableName());
        return validationErrors;
    }

    @Override
    public Sql[] generateSql(FindForeignKeyConstraintsStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT TOP 1");
        sb.append("OBJECT_NAME(f.parent_object_id) AS ").append("TABLE_NAME").append(", ");
        sb.append("COL_NAME(fc.parent_object_id, fc.parent_column_id) AS ").append("COLUMN_NAME").append(", ");
        sb.append("OBJECT_NAME (f.referenced_object_id) AS ").append("REFERENCED_TABLE_NAME").append(", ");
        sb.append("COL_NAME(fc.referenced_object_id, fc.referenced_column_id) AS ").append("REFERENCED_COLUMN_NAME").append(",");
        sb.append("f.name AS ").append("CONSTRAINT_NAME").append(" ");
        sb.append("FROM sys.foreign_keys AS f ");
        sb.append("INNER JOIN sys.foreign_key_columns AS fc ");
        sb.append("ON f.OBJECT_ID = fc.constraint_object_id ");
        sb.append("WHERE OBJECT_NAME(f.parent_object_id) = '").append(statement.getBaseTableName()).append("'");
        return new Sql[]{new UnparsedSql(sb.toString(), new DatabaseObject[0])};
    }
}

