/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import liquibase.change.AbstractChange;
import liquibase.change.CheckSum;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.DbmsTargetedChange;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.exception.DatabaseException;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.util.StringUtils;

public abstract class AbstractSQLChange
extends AbstractChange
implements DbmsTargetedChange {
    private boolean stripComments;
    private boolean splitStatements;
    private String endDelimiter;
    private String sql;
    private String dbms;

    protected AbstractSQLChange() {
        this.setStripComments(null);
        this.setSplitStatements(null);
    }

    @DatabaseChangeProperty(since="3.0", exampleValue="h2, oracle")
    public String getDbms() {
        return this.dbms;
    }

    public void setDbms(String dbms) {
        this.dbms = dbms;
    }

    public boolean supports(Database database) {
        return true;
    }

    @DatabaseChangeProperty(description="Set to true to remove any comments in the SQL before executing, otherwise false. Defaults to false if not set")
    public Boolean isStripComments() {
        return this.stripComments;
    }

    public void setStripComments(Boolean stripComments) {
        this.stripComments = stripComments == null ? false : stripComments;
    }

    @DatabaseChangeProperty(description="Set to false to not have liquibase split statements on ;'s and GO's. Defaults to true if not set")
    public Boolean isSplitStatements() {
        return this.splitStatements;
    }

    public void setSplitStatements(Boolean splitStatements) {
        this.splitStatements = splitStatements == null ? true : splitStatements;
    }

    @DatabaseChangeProperty(serializationType=LiquibaseSerializable.SerializationType.DIRECT_VALUE)
    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = StringUtils.trimToNull(sql);
    }

    @DatabaseChangeProperty(description="Delimiter to apply to the end of the statement. Defaults to ';', may be set to ''.", exampleValue="\\nGO")
    public String getEndDelimiter() {
        return this.endDelimiter;
    }

    public void setEndDelimiter(String endDelimiter) {
        this.endDelimiter = endDelimiter;
    }

    public CheckSum generateCheckSum() {
        String sql = this.getSql();
        if (sql == null) {
            sql = "";
        }
        return CheckSum.compute(this.getEndDelimiter() + ":" + this.isSplitStatements() + ":" + this.isStripComments() + ":" + this.prepareSqlForChecksum(sql));
    }

    public SqlStatement[] generateStatements(Database database) {
        ArrayList<RawSqlStatement> returnStatements = new ArrayList<RawSqlStatement>();
        if (StringUtils.trimToNull(this.getSql()) == null) {
            return new SqlStatement[0];
        }
        String processedSQL = this.normalizeLineEndings(this.sql);
        for (String statement : StringUtils.processMutliLineSQL(processedSQL, this.isStripComments(), this.isSplitStatements(), this.getEndDelimiter())) {
            if (database instanceof MSSQLDatabase) {
                statement = statement.replaceAll("\n", "\r\n");
            }
            String escapedStatement = statement;
            try {
                if (database.getConnection() != null) {
                    escapedStatement = database.getConnection().nativeSQL(statement);
                }
            }
            catch (DatabaseException e) {
                escapedStatement = statement;
            }
            returnStatements.add(new RawSqlStatement(escapedStatement, this.getEndDelimiter()));
        }
        return returnStatements.toArray(new SqlStatement[returnStatements.size()]);
    }

    protected String normalizeLineEndings(String string) {
        return string.replaceAll("\r\n", "\n").replaceAll("\r", "\n");
    }

    protected String prepareSqlForChecksum(String string) {
        string = string.trim();
        string = string.replace("\r\n", "\n").replace("\r", "\n");
        string = string.replaceAll("\\s*\\n\\s*", " ");
        string = string.replaceAll("\\s+", " ");
        return string;
    }
}

