/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import liquibase.change.AbstractChange;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.DropForeignKeyConstraintChange;
import liquibase.database.Database;
import liquibase.diff.compare.DatabaseObjectComparatorFactory;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.FindForeignKeyConstraintsStatement;
import liquibase.structure.core.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DatabaseChange(name="dropAllForeignKeyConstraints", description="Drops all foreign key constraints for a table", priority=1, appliesTo={"table"})
public class DropAllForeignKeyConstraintsChange
extends AbstractChange {
    private String baseTableCatalogName;
    private String baseTableSchemaName;
    private String baseTableName;

    @DatabaseChangeProperty(mustEqualExisting="table.catalog", description="Name of the table containing columns constrained by foreign keys", since="3.0")
    public String getBaseTableCatalogName() {
        return this.baseTableCatalogName;
    }

    public void setBaseTableCatalogName(String baseTableCatalogName) {
        this.baseTableCatalogName = baseTableCatalogName;
    }

    @DatabaseChangeProperty(mustEqualExisting="table.schema")
    public String getBaseTableSchemaName() {
        return this.baseTableSchemaName;
    }

    public void setBaseTableSchemaName(String baseTableSchemaName) {
        this.baseTableSchemaName = baseTableSchemaName;
    }

    @DatabaseChangeProperty(mustEqualExisting="table", requiredForDatabase={"all"})
    public String getBaseTableName() {
        return this.baseTableName;
    }

    public void setBaseTableName(String baseTableName) {
        this.baseTableName = baseTableName;
    }

    @Override
    public SqlStatement[] generateStatements(Database database) {
        ArrayList<SqlStatement> sqlStatements = new ArrayList<SqlStatement>();
        List<DropForeignKeyConstraintChange> childDropChanges = this.generateChildren(database);
        if (childDropChanges != null) {
            for (DropForeignKeyConstraintChange change : childDropChanges) {
                sqlStatements.addAll(Arrays.asList(change.generateStatements(database)));
            }
        }
        return sqlStatements.toArray(new SqlStatement[sqlStatements.size()]);
    }

    @Override
    public String getConfirmationMessage() {
        return "Foreign keys on base table " + this.getBaseTableName() + " dropped";
    }

    private List<DropForeignKeyConstraintChange> generateChildren(Database database) {
        ArrayList<DropForeignKeyConstraintChange> childDropChanges = new ArrayList<DropForeignKeyConstraintChange>();
        Executor executor = ExecutorService.getInstance().getExecutor(database);
        FindForeignKeyConstraintsStatement sql = new FindForeignKeyConstraintsStatement(this.getBaseTableCatalogName(), this.getBaseTableSchemaName(), this.getBaseTableName());
        try {
            List<Map> results = executor.queryForList(sql);
            HashSet<String> handledConstraints = new HashSet<String>();
            if (results != null && results.size() > 0) {
                for (Map result : results) {
                    String baseTableName = (String)result.get("TABLE_NAME");
                    String constraintName = (String)result.get("CONSTRAINT_NAME");
                    if (DatabaseObjectComparatorFactory.getInstance().isSameObject(new Table().setName(this.getBaseTableName()), new Table().setName(baseTableName), database)) {
                        if (handledConstraints.contains(constraintName)) continue;
                        DropForeignKeyConstraintChange dropForeignKeyConstraintChange = new DropForeignKeyConstraintChange();
                        dropForeignKeyConstraintChange.setBaseTableSchemaName(this.getBaseTableSchemaName());
                        dropForeignKeyConstraintChange.setBaseTableName(baseTableName);
                        dropForeignKeyConstraintChange.setConstraintName(constraintName);
                        childDropChanges.add(dropForeignKeyConstraintChange);
                        handledConstraints.add(constraintName);
                        continue;
                    }
                    throw new IllegalStateException("Expected to return only foreign keys for base table name: " + this.getBaseTableName() + " and got results for table: " + baseTableName);
                }
            }
            return childDropChanges;
        }
        catch (DatabaseException e) {
            throw new UnexpectedLiquibaseException("Failed to find foreign keys for table: " + this.getBaseTableName(), e);
        }
    }

    @Override
    public boolean generateStatementsVolatile(Database database) {
        return true;
    }
}

