/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog.filter;

import java.util.List;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;

public class ShouldRunChangeSetFilter
implements ChangeSetFilter {
    public List<RanChangeSet> ranChangeSets;
    private Database database;

    public ShouldRunChangeSetFilter(Database database) throws DatabaseException {
        this.database = database;
        this.ranChangeSets = database.getRanChangeSetList();
    }

    public boolean accepts(ChangeSet changeSet) {
        for (RanChangeSet ranChangeSet : this.ranChangeSets) {
            if (!ranChangeSet.getId().equals(changeSet.getId()) || !ranChangeSet.getAuthor().equals(changeSet.getAuthor()) || !this.isPathEquals(changeSet, ranChangeSet)) continue;
            if (changeSet.shouldAlwaysRun()) {
                return true;
            }
            return changeSet.shouldRunOnChange() && !changeSet.generateCheckSum().equals(ranChangeSet.getLastCheckSum());
        }
        return true;
    }

    private boolean isPathEquals(ChangeSet changeSet, RanChangeSet ranChangeSet) {
        if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
            return ranChangeSet.getChangeLog().equalsIgnoreCase(changeSet.getFilePath());
        }
        return ranChangeSet.getChangeLog().equalsIgnoreCase(changeSet.getFilePath());
    }
}

