/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.core.UnsupportedDatabase;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.logging.LogFactory;
import liquibase.servicelocator.ServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseFactory {
    private static DatabaseFactory instance;
    private Map<String, SortedSet<Database>> implementedDatabases = new HashMap<String, SortedSet<Database>>();

    protected DatabaseFactory() {
        try {
            Class<Database>[] classes;
            for (Class<Database> clazz : classes = ServiceLocator.getInstance().findClasses(Database.class)) {
                this.register(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static DatabaseFactory getInstance() {
        if (instance == null) {
            instance = new DatabaseFactory();
        }
        return instance;
    }

    public static void reset() {
        instance = new DatabaseFactory();
    }

    public List<Database> getImplementedDatabases() {
        ArrayList<Database> returnList = new ArrayList<Database>();
        for (SortedSet<Database> set : this.implementedDatabases.values()) {
            returnList.add((Database)set.iterator().next());
        }
        return returnList;
    }

    public void register(Database database) {
        if (!this.implementedDatabases.containsKey(database.getShortName())) {
            this.implementedDatabases.put(database.getShortName(), new TreeSet<Database>((SortedSet<Database>)new TreeSet<Database>(new DatabaseComparator())));
        }
        this.implementedDatabases.get(database.getShortName()).add(database);
    }

    public Database findCorrectDatabaseImplementation(DatabaseConnection connection) throws DatabaseException {
        Database returnDatabase;
        TreeSet<Database> foundDatabases = new TreeSet<Database>(new DatabaseComparator());
        for (Database implementedDatabase : this.getImplementedDatabases()) {
            if (!implementedDatabase.isCorrectDatabaseImplementation(connection)) continue;
            foundDatabases.add(implementedDatabase);
        }
        if (foundDatabases.size() == 0) {
            LogFactory.getLogger().warning("Unknown database: " + connection.getDatabaseProductName());
            UnsupportedDatabase unsupportedDB = new UnsupportedDatabase();
            unsupportedDB.setConnection(connection);
            return unsupportedDB;
        }
        try {
            returnDatabase = (Database)((Database)foundDatabases.iterator().next()).getClass().newInstance();
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
        returnDatabase.setConnection(connection);
        return returnDatabase;
    }

    public String findDefaultDriver(String url) {
        for (Database database : this.getImplementedDatabases()) {
            String defaultDriver = database.getDefaultDriver(url);
            if (defaultDriver == null) continue;
            return defaultDriver;
        }
        return null;
    }

    public void clearRegistry() {
        this.implementedDatabases.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DatabaseComparator
    implements Comparator<Database> {
        private DatabaseComparator() {
        }

        @Override
        public int compare(Database o1, Database o2) {
            return -1 * new Integer(o1.getPriority()).compareTo(o2.getPriority());
        }
    }
}

