/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff.compare;

import java.util.Iterator;
import java.util.SortedSet;
import liquibase.database.Database;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.compare.DatabaseObjectComparator;
import liquibase.structure.DatabaseObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseObjectComparatorChain {
    private Iterator<DatabaseObjectComparator> comparators;

    public DatabaseObjectComparatorChain(SortedSet<DatabaseObjectComparator> comparators) {
        if (comparators != null) {
            this.comparators = comparators.iterator();
        }
    }

    public boolean isSameObject(DatabaseObject object1, DatabaseObject object2, Database accordingTo) {
        if (object1 == null && object2 == null) {
            return true;
        }
        if (object1 == null && object2 != null) {
            return false;
        }
        if (object1 != null && object2 == null) {
            return false;
        }
        if (this.comparators == null) {
            return true;
        }
        if (!this.comparators.hasNext()) {
            return true;
        }
        return this.comparators.next().isSameObject(object1, object2, accordingTo, this);
    }

    public ObjectDifferences findDifferences(DatabaseObject object1, DatabaseObject object2, Database accordingTo) {
        if (object1 == null && object2 == null) {
            return new ObjectDifferences();
        }
        if (object1 == null && object2 != null) {
            return new ObjectDifferences().addDifference("Reference value was null", "this", null, null);
        }
        if (object1 != null && object2 == null) {
            return new ObjectDifferences().addDifference("Compared value was null", "this", null, null);
        }
        if (this.comparators == null) {
            return new ObjectDifferences();
        }
        if (!this.comparators.hasNext()) {
            return new ObjectDifferences();
        }
        return this.comparators.next().findDifferences(object1, object2, accordingTo, this);
    }
}

