/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff.core;

import java.util.Set;
import liquibase.CatalogAndSchema;
import liquibase.database.Database;
import liquibase.diff.DiffGenerator;
import liquibase.diff.DiffResult;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.StringDiff;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.compare.DatabaseObjectComparatorFactory;
import liquibase.exception.DatabaseException;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.JdbcDatabaseSnapshot;
import liquibase.structure.DatabaseObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardDiffGenerator
implements DiffGenerator {
    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public boolean supports(Database referenceDatabase, Database comparisonDatabase) {
        return true;
    }

    @Override
    public DiffResult compare(DatabaseSnapshot referenceSnapshot, DatabaseSnapshot comparisonSnapshot, CompareControl compareControl) throws DatabaseException {
        if (comparisonSnapshot == null) {
            comparisonSnapshot = new JdbcDatabaseSnapshot(referenceSnapshot.getDatabase());
        }
        DiffResult diffResult = new DiffResult(referenceSnapshot, comparisonSnapshot, compareControl);
        this.checkVersionInfo(referenceSnapshot, comparisonSnapshot, diffResult);
        Set<Class<? extends DatabaseObject>> typesToCompare = compareControl.getComparedTypes();
        typesToCompare.retainAll(referenceSnapshot.getSnapshotControl().getTypesToInclude());
        typesToCompare.retainAll(comparisonSnapshot.getSnapshotControl().getTypesToInclude());
        for (Class<? extends DatabaseObject> typeToCompare : typesToCompare) {
            this.compareObjectType(typeToCompare, referenceSnapshot, comparisonSnapshot, diffResult);
        }
        return diffResult;
    }

    protected void checkVersionInfo(DatabaseSnapshot referenceSnapshot, DatabaseSnapshot comparisonSnapshot, DiffResult diffResult) throws DatabaseException {
        if (comparisonSnapshot != null && comparisonSnapshot.getDatabase() != null) {
            diffResult.setProductNameDiff(new StringDiff(referenceSnapshot.getDatabase().getDatabaseProductName(), comparisonSnapshot.getDatabase().getDatabaseProductName()));
            diffResult.setProductVersionDiff(new StringDiff(referenceSnapshot.getDatabase().getDatabaseProductVersion(), comparisonSnapshot.getDatabase().getDatabaseProductVersion()));
        }
    }

    protected <T extends DatabaseObject> void compareObjectType(Class<T> type, DatabaseSnapshot referenceSnapshot, DatabaseSnapshot comparisonSnapshot, DiffResult diffResult) {
        for (CompareControl.SchemaComparison schemaComparison : diffResult.getCompareControl().getSchemaComparisons()) {
            CatalogAndSchema referenceSchema = referenceSnapshot.getDatabase().correctSchema(schemaComparison.getReferenceSchema());
            CatalogAndSchema comparisonSchema = null;
            if (comparisonSnapshot.getDatabase() != null) {
                comparisonSchema = comparisonSnapshot.getDatabase().correctSchema(schemaComparison.getComparisonSchema());
            }
            for (DatabaseObject referenceObject : referenceSnapshot.get(type)) {
                DatabaseObject comparisonObject = comparisonSnapshot.get(referenceObject);
                if (comparisonObject == null) {
                    diffResult.addMissingObject(referenceObject);
                    continue;
                }
                ObjectDifferences differences = DatabaseObjectComparatorFactory.getInstance().findDifferences(referenceObject, comparisonObject, comparisonSnapshot.getDatabase());
                if (!differences.hasDifferences()) continue;
                diffResult.addChangedObject(referenceObject, differences);
            }
            for (DatabaseObject comparisonObject : comparisonSnapshot.get(type)) {
                if (referenceSnapshot.get(comparisonObject) != null) continue;
                diffResult.addUnexpectedObject(comparisonObject);
            }
        }
    }
}

