/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff.output.changelog;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.diff.DiffResult;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGenerator;
import liquibase.diff.output.changelog.ChangeGeneratorFactory;
import liquibase.diff.output.changelog.ChangedObjectChangeGenerator;
import liquibase.diff.output.changelog.MissingObjectChangeGenerator;
import liquibase.diff.output.changelog.UnexpectedObjectChangeGenerator;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.logging.LogFactory;
import liquibase.serializer.ChangeLogSerializer;
import liquibase.serializer.ChangeLogSerializerFactory;
import liquibase.serializer.core.xml.XMLChangeLogSerializer;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffToChangeLog {
    private String idRoot = String.valueOf(new Date().getTime());
    private int changeNumber = 1;
    private String changeSetContext;
    private String changeSetAuthor;
    private DiffResult diffResult;
    private DiffOutputControl diffOutputControl;
    private static Set<Class> loggedOrderFor = new HashSet<Class>();

    public DiffToChangeLog(DiffResult diffResult, DiffOutputControl diffOutputControl) {
        this.diffResult = diffResult;
        this.diffOutputControl = diffOutputControl;
    }

    public void setChangeSetContext(String changeSetContext) {
        this.changeSetContext = changeSetContext;
    }

    public void print(String changeLogFile) throws ParserConfigurationException, IOException, DatabaseException {
        ChangeLogSerializer changeLogSerializer = ChangeLogSerializerFactory.getInstance().getSerializer(changeLogFile);
        this.print(changeLogFile, changeLogSerializer);
    }

    public void print(PrintStream out) throws ParserConfigurationException, IOException, DatabaseException {
        this.print(out, (ChangeLogSerializer)new XMLChangeLogSerializer());
    }

    public void print(String changeLogFile, ChangeLogSerializer changeLogSerializer) throws ParserConfigurationException, IOException, DatabaseException {
        File file = new File(changeLogFile);
        if (!file.exists()) {
            LogFactory.getLogger().info(file + " does not exist, creating");
            FileOutputStream stream = new FileOutputStream(file);
            this.print(new PrintStream(stream), changeLogSerializer);
            stream.close();
        } else {
            String line;
            LogFactory.getLogger().info(file + " exists, appending");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.print(new PrintStream(out), changeLogSerializer);
            String xml = new String(out.toByteArray());
            xml = xml.replaceFirst("(?ms).*<databaseChangeLog[^>]*>", "");
            xml = xml.replaceFirst("</databaseChangeLog>", "");
            xml = xml.trim();
            if ("".equals(xml)) {
                LogFactory.getLogger().info("No changes found, nothing to do");
                return;
            }
            String lineSeparator = System.getProperty("line.separator");
            BufferedReader fileReader = new BufferedReader(new FileReader(file));
            long offset = 0L;
            while ((line = fileReader.readLine()) != null) {
                int index = line.indexOf("</databaseChangeLog>");
                if (index >= 0) {
                    offset += (long)index;
                    continue;
                }
                offset += (long)line.getBytes().length;
                offset += (long)lineSeparator.getBytes().length;
            }
            fileReader.close();
            fileReader = new BufferedReader(new FileReader(file));
            fileReader.skip(offset);
            fileReader.close();
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.seek(offset);
            randomAccessFile.writeBytes("    ");
            randomAccessFile.write(xml.getBytes());
            randomAccessFile.writeBytes(lineSeparator);
            randomAccessFile.writeBytes("</databaseChangeLog>" + lineSeparator);
            randomAccessFile.close();
        }
    }

    public void print(PrintStream out, ChangeLogSerializer changeLogSerializer) throws ParserConfigurationException, IOException, DatabaseException {
        List<ChangeSet> changeSets = this.generateChangeSets();
        changeLogSerializer.write(changeSets, out);
        out.flush();
    }

    public List<ChangeSet> generateChangeSets() {
        Change[] changes;
        ObjectQuotingStrategy quotingStrategy;
        ChangeGeneratorFactory changeGeneratorFactory = ChangeGeneratorFactory.getInstance();
        ArrayList<ChangeSet> changeSets = new ArrayList<ChangeSet>();
        List<Class<? extends DatabaseObject>> types = this.getOrderedOutputTypes(MissingObjectChangeGenerator.class);
        for (Class<? extends DatabaseObject> type : types) {
            quotingStrategy = ObjectQuotingStrategy.QUOTE_ALL_OBJECTS;
            for (DatabaseObject databaseObject : this.diffResult.getMissingObjects(type)) {
                if (databaseObject == null) continue;
                changes = changeGeneratorFactory.fixMissing(databaseObject, this.diffOutputControl, this.diffResult.getReferenceSnapshot().getDatabase(), this.diffResult.getComparisonSnapshot().getDatabase());
                if (this.diffResult.getReferenceSnapshot().getDatabase().isLiquibaseObject(databaseObject) || this.diffResult.getReferenceSnapshot().getDatabase().isSystemObject(databaseObject)) continue;
                this.addToChangeSets(changes, changeSets, quotingStrategy);
            }
        }
        types = this.getOrderedOutputTypes(UnexpectedObjectChangeGenerator.class);
        for (Class<? extends DatabaseObject> type : types) {
            quotingStrategy = ObjectQuotingStrategy.QUOTE_ALL_OBJECTS;
            for (DatabaseObject databaseObject : this.diffResult.getUnexpectedObjects(type)) {
                changes = changeGeneratorFactory.fixUnexpected(databaseObject, this.diffOutputControl, this.diffResult.getReferenceSnapshot().getDatabase(), this.diffResult.getComparisonSnapshot().getDatabase());
                if (this.diffResult.getComparisonSnapshot().getDatabase().isLiquibaseObject(databaseObject) || this.diffResult.getComparisonSnapshot().getDatabase().isSystemObject(databaseObject)) continue;
                this.addToChangeSets(changes, changeSets, quotingStrategy);
            }
        }
        types = this.getOrderedOutputTypes(ChangedObjectChangeGenerator.class);
        for (Class<? extends DatabaseObject> type : types) {
            quotingStrategy = ObjectQuotingStrategy.QUOTE_ALL_OBJECTS;
            for (Map.Entry entry : this.diffResult.getChangedObjects(type).entrySet()) {
                changes = changeGeneratorFactory.fixChanged((DatabaseObject)entry.getKey(), (ObjectDifferences)entry.getValue(), this.diffOutputControl, this.diffResult.getReferenceSnapshot().getDatabase(), this.diffResult.getComparisonSnapshot().getDatabase());
                if (this.diffResult.getReferenceSnapshot().getDatabase().isLiquibaseObject((DatabaseObject)entry.getKey()) || this.diffResult.getReferenceSnapshot().getDatabase().isSystemObject((DatabaseObject)entry.getKey())) continue;
                this.addToChangeSets(changes, changeSets, quotingStrategy);
            }
        }
        return changeSets;
    }

    private List<Class<? extends DatabaseObject>> getOrderedOutputTypes(Class<? extends ChangeGenerator> generatorType) {
        Database comparisonDatabase = this.diffResult.getComparisonSnapshot().getDatabase();
        DependencyGraph graph = new DependencyGraph();
        for (Class<? extends DatabaseObject> type : this.diffResult.getReferenceSnapshot().getSnapshotControl().getTypesToInclude()) {
            graph.addType(type);
        }
        List<Class<? extends DatabaseObject>> types = graph.sort(comparisonDatabase, generatorType);
        if (!loggedOrderFor.contains(generatorType)) {
            String log = generatorType.getSimpleName() + " type order: ";
            for (Class<? extends DatabaseObject> type : types) {
                log = log + "    " + type.getName();
            }
            LogFactory.getLogger().debug(log);
            loggedOrderFor.add(generatorType);
        }
        return types;
    }

    private void addToChangeSets(Change[] changes, List<ChangeSet> changeSets, ObjectQuotingStrategy quotingStrategy) {
        if (changes != null) {
            for (Change change : changes) {
                changeSets.add(this.generateChangeSet(change, quotingStrategy));
            }
        }
    }

    protected ChangeSet generateChangeSet(Change change, ObjectQuotingStrategy quotingStrategy) {
        ChangeSet changeSet = new ChangeSet(this.generateId(), this.getChangeSetAuthor(), false, false, null, this.changeSetContext, null, quotingStrategy, null);
        changeSet.addChange(change);
        return changeSet;
    }

    protected String getChangeSetAuthor() {
        if (this.changeSetAuthor != null) {
            return this.changeSetAuthor;
        }
        String author = System.getProperty("user.name");
        if (StringUtils.trimToNull(author) == null) {
            return "diff-generated";
        }
        return author + " (generated)";
    }

    public void setChangeSetAuthor(String changeSetAuthor) {
        this.changeSetAuthor = changeSetAuthor;
    }

    public void setIdRoot(String idRoot) {
        this.idRoot = idRoot;
    }

    protected String generateId() {
        return this.idRoot + "-" + this.changeNumber++;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DependencyGraph {
        private Map<Class<? extends DatabaseObject>, Node> allNodes = new HashMap<Class<? extends DatabaseObject>, Node>();

        private DependencyGraph() {
        }

        private void addType(Class<? extends DatabaseObject> type) {
            this.allNodes.put(type, new Node(type));
        }

        public List<Class<? extends DatabaseObject>> sort(Database database, Class<? extends ChangeGenerator> generatorType) {
            ChangeGeneratorFactory changeGeneratorFactory = ChangeGeneratorFactory.getInstance();
            for (Class<? extends DatabaseObject> type : this.allNodes.keySet()) {
                for (Class clazz : changeGeneratorFactory.runBeforeTypes(type, database, generatorType)) {
                    this.getNode(type).addEdge(this.getNode(clazz));
                }
                for (Class clazz : changeGeneratorFactory.runAfterTypes(type, database, generatorType)) {
                    this.getNode(clazz).addEdge(this.getNode(type));
                }
            }
            ArrayList<Node> L = new ArrayList<Node>();
            HashSet<Node> S = new HashSet<Node>();
            for (Node node : this.allNodes.values()) {
                if (node.inEdges.size() != 0) continue;
                S.add(node);
            }
            while (!S.isEmpty()) {
                Node n = (Node)S.iterator().next();
                S.remove(n);
                L.add(n);
                Iterator<Edge> iterator = n.outEdges.iterator();
                while (iterator.hasNext()) {
                    Edge e = iterator.next();
                    Node m = e.to;
                    iterator.remove();
                    m.inEdges.remove(e);
                    if (!m.inEdges.isEmpty()) continue;
                    S.add(m);
                }
            }
            for (Node node : this.allNodes.values()) {
                if (node.inEdges.isEmpty()) continue;
                String message = "Could not resolve " + generatorType.getSimpleName() + " dependencies due to dependency cycle. Dependencies: \n";
                for (Node node2 : this.allNodes.values()) {
                    TreeSet<String> fromTypes = new TreeSet<String>();
                    TreeSet<String> toTypes = new TreeSet<String>();
                    for (Edge edge : node2.inEdges) {
                        fromTypes.add(edge.from.type.getSimpleName());
                    }
                    for (Edge edge : node2.outEdges) {
                        toTypes.add(edge.to.type.getSimpleName());
                    }
                    String from = StringUtils.join(fromTypes, ",");
                    String to = StringUtils.join(toTypes, ",");
                    message = message + "    [" + from + "] -> " + node2.type.getSimpleName() + " -> [" + to + "]\n";
                }
                throw new UnexpectedLiquibaseException(message);
            }
            ArrayList<Class<? extends DatabaseObject>> returnList = new ArrayList<Class<? extends DatabaseObject>>();
            for (Node node : L) {
                returnList.add(node.type);
            }
            return returnList;
        }

        private Node getNode(Class<? extends DatabaseObject> type) {
            Node node = this.allNodes.get(type);
            if (node == null) {
                node = new Node(type);
            }
            return node;
        }

        static class Edge {
            public final Node from;
            public final Node to;

            public Edge(Node from, Node to) {
                this.from = from;
                this.to = to;
            }

            public boolean equals(Object obj) {
                Edge e = (Edge)obj;
                return e.from == this.from && e.to == this.to;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class Node {
            public final Class<? extends DatabaseObject> type;
            public final HashSet<Edge> inEdges;
            public final HashSet<Edge> outEdges;

            public Node(Class<? extends DatabaseObject> type) {
                this.type = type;
                this.inEdges = new HashSet();
                this.outEdges = new HashSet();
            }

            public Node addEdge(Node node) {
                Edge e = new Edge(this, node);
                this.outEdges.add(e);
                node.inEdges.add(e);
                return this;
            }

            public String toString() {
                return this.type.getName();
            }
        }
    }
}

