/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff.output.changelog.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.core.InsertDataChange;
import liquibase.change.core.LoadDataChange;
import liquibase.change.core.LoadDataColumnConfig;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.diff.output.changelog.MissingObjectChangeGenerator;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Data;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.Index;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Table;
import liquibase.util.ISODateFormat;
import liquibase.util.JdbcUtils;
import liquibase.util.csv.CSVWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MissingDataChangeGenerator
implements MissingObjectChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (Data.class.isAssignableFrom(objectType)) {
            return 1;
        }
        return -1;
    }

    @Override
    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return new Class[]{Table.class};
    }

    @Override
    public Class<? extends DatabaseObject>[] runBeforeTypes() {
        return new Class[]{PrimaryKey.class, ForeignKey.class, Index.class};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Change[] fixMissing(DatabaseObject missingObject, DiffOutputControl outputControl, Database referenceDatabase, Database comparisionDatabase, ChangeGeneratorChain chain) {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            Data data = (Data)missingObject;
            Table table = data.getTable();
            if (referenceDatabase.isLiquibaseObject(table)) {
                Change[] changeArray = null;
                return changeArray;
            }
            String sql = "SELECT * FROM " + referenceDatabase.escapeTableName(table.getSchema().getCatalogName(), table.getSchema().getName(), table.getName());
            stmt = ((JdbcConnection)referenceDatabase.getConnection()).createStatement(1003, 1007);
            stmt.setFetchSize(1000);
            rs = stmt.executeQuery(sql);
            ArrayList<String> columnNames = new ArrayList<String>();
            for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                columnNames.add(rs.getMetaData().getColumnName(i + 1));
            }
            String dataDir = outputControl.getDataDir();
            if (dataDir != null) {
                int i;
                File parentDir;
                String fileName = table.getName().toLowerCase() + ".csv";
                if (dataDir != null) {
                    fileName = dataDir + "/" + fileName;
                }
                if (!(parentDir = new File(dataDir)).exists()) {
                    parentDir.mkdirs();
                }
                if (!parentDir.isDirectory()) {
                    throw new RuntimeException(parentDir + " is not a directory");
                }
                CSVWriter outputFile = new CSVWriter(new BufferedWriter(new FileWriter(fileName)));
                String[] dataTypes = new String[columnNames.size()];
                String[] line = new String[columnNames.size()];
                for (i = 0; i < columnNames.size(); ++i) {
                    line[i] = (String)columnNames.get(i);
                }
                outputFile.writeNext(line);
                while (true) {
                    if (rs.next()) {
                        line = new String[columnNames.size()];
                    } else {
                        outputFile.flush();
                        outputFile.close();
                        LoadDataChange change = new LoadDataChange();
                        change.setFile(fileName);
                        change.setEncoding("UTF-8");
                        if (outputControl.isIncludeCatalog()) {
                            change.setCatalogName(table.getSchema().getCatalogName());
                        }
                        if (outputControl.isIncludeSchema()) {
                            change.setSchemaName(table.getSchema().getName());
                        }
                        change.setTableName(table.getName());
                        int i2 = 0;
                        while (true) {
                            if (i2 >= columnNames.size()) {
                                Change[] changeArray = new Change[]{change};
                                return changeArray;
                            }
                            String colName = (String)columnNames.get(i2);
                            LoadDataColumnConfig columnConfig = new LoadDataColumnConfig();
                            columnConfig.setHeader(colName);
                            columnConfig.setName(colName);
                            columnConfig.setType(dataTypes[i2]);
                            change.addColumn(columnConfig);
                            ++i2;
                        }
                    }
                    for (i = 0; i < columnNames.size(); ++i) {
                        Object value = JdbcUtils.getResultSetValue(rs, i + 1);
                        if (dataTypes[i] == null && value != null) {
                            dataTypes[i] = value instanceof Number ? "NUMERIC" : (value instanceof Boolean ? "BOOLEAN" : (value instanceof Date ? "DATE" : "STRING"));
                        }
                        line[i] = value == null ? "NULL" : (value instanceof Date ? new ISODateFormat().format((Date)value) : value.toString());
                    }
                    outputFile.writeNext(line);
                }
            }
            ArrayList<InsertDataChange> changes = new ArrayList<InsertDataChange>();
            while (true) {
                InsertDataChange change;
                if (rs.next()) {
                    change = new InsertDataChange();
                    if (outputControl.isIncludeCatalog()) {
                        change.setCatalogName(table.getSchema().getCatalogName());
                    }
                    if (outputControl.isIncludeSchema()) {
                        change.setSchemaName(table.getSchema().getName());
                    }
                    change.setTableName(table.getName());
                } else {
                    Change[] changeArray = changes.toArray(new Change[changes.size()]);
                    return changeArray;
                }
                for (int i = 0; i < columnNames.size(); ++i) {
                    ColumnConfig column = new ColumnConfig();
                    column.setName((String)columnNames.get(i));
                    Object value = JdbcUtils.getResultSetValue(rs, i + 1);
                    if (value == null) {
                        column.setValue(null);
                    } else if (value instanceof Number) {
                        column.setValueNumeric((Number)value);
                    } else if (value instanceof Boolean) {
                        column.setValueBoolean((Boolean)value);
                    } else if (value instanceof Date) {
                        column.setValueDate((Date)value);
                    } else {
                        column.setValue(value.toString().replace("\\", "\\\\"));
                    }
                    change.addColumn(column);
                }
                changes.add(change);
            }
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ignore) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ignore) {}
            }
        }
    }
}

