/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.ant;

import java.util.ArrayList;
import java.util.List;
import liquibase.CatalogAndSchema;
import liquibase.Liquibase;
import liquibase.integration.ant.BaseLiquibaseTask;
import liquibase.util.StringUtils;
import org.apache.tools.ant.BuildException;

public class DropAllTask
extends BaseLiquibaseTask {
    private String schemas;
    private String catalog;

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getSchemas() {
        return this.schemas;
    }

    public void setSchemas(String schemas) {
        this.schemas = schemas;
    }

    public void executeWithLiquibaseClassloader() throws BuildException {
        if (!this.shouldRun()) {
            return;
        }
        Liquibase liquibase = null;
        try {
            liquibase = this.createLiquibase();
            if (StringUtils.trimToNull(this.schemas) != null) {
                List<String> schemaNames = StringUtils.splitAndTrim(this.schemas, ",");
                ArrayList<CatalogAndSchema> schemas = new ArrayList<CatalogAndSchema>();
                for (String name : schemaNames) {
                    schemas.add(new CatalogAndSchema(this.catalog, name));
                }
                liquibase.dropAll(schemas.toArray(new CatalogAndSchema[schemas.size()]));
            } else {
                liquibase.dropAll();
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            this.closeDatabase(liquibase);
        }
    }
}

