/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.servlet;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.logging.LogFactory;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.util.NetUtil;
import liquibase.util.StringUtils;

public class LiquibaseServletListener
implements ServletContextListener {
    private static final String JAVA_COMP_ENV = "java:comp/env";
    private static final String LIQUIBASE_CHANGELOG = "liquibase.changelog";
    private static final String LIQUIBASE_CONTEXTS = "liquibase.contexts";
    private static final String LIQUIBASE_DATASOURCE = "liquibase.datasource";
    private static final String LIQUIBASE_HOST_EXCLUDES = "liquibase.host.excludes";
    private static final String LIQUIBASE_HOST_INCLUDES = "liquibase.host.includes";
    private static final String LIQUIBASE_ONERROR_FAIL = "liquibase.onerror.fail";
    private static final String LIQUIBASE_PARAMETER = "liquibase.parameter";
    private static final String LIQUIBASE_SCHEMA_DEFAULT = "liquibase.schema.default";
    private String changeLogFile;
    private String dataSourceName;
    private String contexts;
    private String defaultSchema;
    private String hostName;

    public String getChangeLogFile() {
        return this.changeLogFile;
    }

    public void setContexts(String ctxt) {
        this.contexts = ctxt;
    }

    public String getContexts() {
        return this.contexts;
    }

    public void setChangeLogFile(String changeLogFile) {
        this.changeLogFile = changeLogFile;
    }

    public String getDataSource() {
        return this.dataSourceName;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDataSource(String dataSource) {
        this.dataSourceName = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        try {
            this.hostName = NetUtil.getLocalHost().getHostName();
        }
        catch (Exception e) {
            servletContext.log("Cannot find hostname: " + e.getMessage());
            return;
        }
        InitialContext ic = null;
        String failOnError = null;
        try {
            ic = new InitialContext();
            failOnError = this.getValue(LIQUIBASE_ONERROR_FAIL, servletContext, ic);
            if (this.checkPreconditions(servletContext, ic)) {
                this.executeUpdate(servletContext, ic);
            }
        }
        catch (Exception e) {
            if (!"false".equals(failOnError)) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (ic != null) {
                try {
                    ic.close();
                }
                catch (NamingException e) {}
            }
        }
    }

    private boolean checkPreconditions(ServletContext servletContext, InitialContext ic) {
        String shouldRunProperty = this.getValue("liquibase.should.run", servletContext, ic);
        if (shouldRunProperty != null && !Boolean.valueOf(shouldRunProperty).booleanValue()) {
            LogFactory.getLogger().info("Liquibase did not run on " + this.hostName + " because '" + "liquibase.should.run" + "' system property was set to false");
            return false;
        }
        String machineIncludes = this.getValue(LIQUIBASE_HOST_INCLUDES, servletContext, ic);
        String machineExcludes = this.getValue(LIQUIBASE_HOST_EXCLUDES, servletContext, ic);
        boolean shouldRun = false;
        if (machineIncludes == null && machineExcludes == null) {
            shouldRun = true;
        } else if (machineIncludes != null) {
            for (String machine : machineIncludes.split(",")) {
                if (!this.hostName.equalsIgnoreCase(machine = machine.trim())) continue;
                shouldRun = true;
            }
        } else if (machineExcludes != null) {
            shouldRun = true;
            for (String machine : machineExcludes.split(",")) {
                if (!this.hostName.equalsIgnoreCase(machine = machine.trim())) continue;
                shouldRun = false;
            }
        }
        if (shouldRunProperty != null && Boolean.valueOf(shouldRunProperty).booleanValue()) {
            shouldRun = true;
            servletContext.log("ignoring liquibase.host.includes and liquibase.host.excludes, since liquibase.should.run=true");
        }
        if (!shouldRun) {
            servletContext.log("LiquibaseServletListener did not run due to liquibase.host.includes and/or liquibase.host.excludes");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeUpdate(ServletContext servletContext, InitialContext ic) throws NamingException, SQLException, LiquibaseException {
        this.setDataSource(this.getValue(LIQUIBASE_DATASOURCE, servletContext, ic));
        if (this.getDataSource() == null) {
            throw new RuntimeException("Cannot run Liquibase, liquibase.datasource is not set");
        }
        this.setChangeLogFile(this.getValue(LIQUIBASE_CHANGELOG, servletContext, ic));
        if (this.getChangeLogFile() == null) {
            throw new RuntimeException("Cannot run Liquibase, liquibase.changelog is not set");
        }
        this.setContexts(this.getValue(LIQUIBASE_CONTEXTS, servletContext, ic));
        this.defaultSchema = StringUtils.trimToNull(this.getValue(LIQUIBASE_SCHEMA_DEFAULT, servletContext, ic));
        Connection connection = null;
        try {
            DataSource dataSource = (DataSource)ic.lookup(this.dataSourceName);
            connection = dataSource.getConnection();
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            ClassLoaderResourceAccessor threadClFO = new ClassLoaderResourceAccessor(contextClassLoader);
            ClassLoaderResourceAccessor clFO = new ClassLoaderResourceAccessor();
            FileSystemResourceAccessor fsFO = new FileSystemResourceAccessor();
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation(new JdbcConnection(connection));
            database.setDefaultSchemaName(this.getDefaultSchema());
            Liquibase liquibase = new Liquibase(this.getChangeLogFile(), (ResourceAccessor)new CompositeResourceAccessor(clFO, fsFO, threadClFO), database);
            Enumeration initParameters = servletContext.getInitParameterNames();
            while (initParameters.hasMoreElements()) {
                String name = ((String)initParameters.nextElement()).trim();
                if (!name.startsWith("liquibase.parameter.")) continue;
                liquibase.setChangeLogParameter(name.substring(LIQUIBASE_PARAMETER.length()), this.getValue(name, servletContext, ic));
            }
            liquibase.update(this.getContexts());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public String getValue(String key, ServletContext servletContext, InitialContext initialContext) {
        try {
            Context envCtx = (Context)initialContext.lookup(JAVA_COMP_ENV);
            String valueFromJndi = (String)envCtx.lookup(key);
            return valueFromJndi;
        }
        catch (NamingException e) {
            String valueFromServletContext = servletContext.getInitParameter(key);
            if (valueFromServletContext != null) {
                return valueFromServletContext;
            }
            return System.getProperty(key);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }
}

