/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.UnknownChangelogFormatException;
import liquibase.parser.ChangeLogParser;
import liquibase.resource.ResourceAccessor;
import liquibase.servicelocator.ServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeLogParserFactory {
    private static ChangeLogParserFactory instance;
    private List<ChangeLogParser> parsers;
    private Comparator<ChangeLogParser> changelogParserComparator = new Comparator<ChangeLogParser>(){

        @Override
        public int compare(ChangeLogParser o1, ChangeLogParser o2) {
            return Integer.valueOf(o2.getPriority()).compareTo(o1.getPriority());
        }
    };

    public static void reset() {
        instance = new ChangeLogParserFactory();
    }

    public static ChangeLogParserFactory getInstance() {
        if (instance == null) {
            instance = new ChangeLogParserFactory();
        }
        return instance;
    }

    private ChangeLogParserFactory() {
        this.parsers = new ArrayList<ChangeLogParser>();
        try {
            Class<ChangeLogParser>[] classes;
            for (Class<ChangeLogParser> clazz : classes = ServiceLocator.getInstance().findClasses(ChangeLogParser.class)) {
                this.register(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    public List<ChangeLogParser> getParsers() {
        return this.parsers;
    }

    public ChangeLogParser getParser(String fileNameOrExtension, ResourceAccessor resourceAccessor) throws LiquibaseException {
        for (ChangeLogParser parser : this.parsers) {
            if (!parser.supports(fileNameOrExtension, resourceAccessor)) continue;
            return parser;
        }
        throw new UnknownChangelogFormatException("Cannot find parser that supports " + fileNameOrExtension);
    }

    public void register(ChangeLogParser changeLogParser) {
        this.parsers.add(changeLogParser);
        Collections.sort(this.parsers, this.changelogParserComparator);
    }

    public void unregister(ChangeLogParser changeLogParser) {
        this.parsers.remove(changeLogParser);
    }
}

