/*
 * Decompiled with CFR 0.152.
 */
package liquibase.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.nio.charset.Charset;

public class UtfBomAwareReader
extends Reader {
    private static final byte _0xBF = -65;
    private static final byte _0x00 = 0;
    private static final byte _0xBB = -69;
    private static final byte _0xFF = -1;
    private static final byte _0xFE = -2;
    private static final byte _0xEF = -17;
    private PushbackInputStream pis;
    private InputStreamReader is = null;
    private String defaultCharsetName;

    public UtfBomAwareReader(InputStream in) {
        this.pis = new PushbackInputStream(in, 4);
        this.defaultCharsetName = Charset.defaultCharset().name();
    }

    public UtfBomAwareReader(InputStream in, String defaultCharsetName) {
        this.pis = new PushbackInputStream(in, 4);
        if (defaultCharsetName == null) {
            throw new NullPointerException("defaultCharsetName");
        }
        this.defaultCharsetName = defaultCharsetName;
    }

    public String getDefaultEncoding() {
        return this.defaultCharsetName;
    }

    public String getEncoding() {
        if (this.is == null) {
            try {
                this.init();
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to determine encoding", e);
            }
        }
        return this.is.getEncoding();
    }

    protected void init() throws IOException {
        int unread;
        String charsetName;
        byte[] bom = new byte[4];
        int n = this.pis.read(bom, 0, bom.length);
        if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
            charsetName = "UTF-8";
            unread = n - 3;
        } else if (bom[0] == -2 && bom[1] == -1) {
            charsetName = "UTF-16BE";
            unread = n - 2;
        } else if (bom[0] == -1 && bom[1] == -2) {
            if (n == 4 && bom[2] == 0 && bom[3] == 0) {
                charsetName = "UTF-32LE";
                unread = 0;
            } else {
                charsetName = "UTF-16LE";
                unread = n - 2;
            }
        } else if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1) {
            charsetName = "UTF-32BE";
            unread = 4;
        } else {
            charsetName = this.defaultCharsetName;
            unread = n;
        }
        if (unread > 0) {
            this.pis.unread(bom, n - unread, unread);
        } else if (unread < -1) {
            this.pis.unread(bom, 0, 0);
        }
        this.is = charsetName == null ? new InputStreamReader(this.pis) : new InputStreamReader((InputStream)this.pis, charsetName);
    }

    public void close() throws IOException {
        if (this.is == null) {
            this.init();
        }
        this.is.close();
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.is == null) {
            this.init();
        }
        return this.is.read(cbuf, off, len);
    }
}

