/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot.jvm;

import java.sql.ResultSet;
import java.sql.SQLException;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.diff.compare.DatabaseObjectComparatorFactory;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.jvm.JdbcSnapshotGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;

public class CatalogSnapshotGenerator
extends JdbcSnapshotGenerator {
    public CatalogSnapshotGenerator() {
        super(Catalog.class);
    }

    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!(example instanceof Catalog)) {
            throw new UnexpectedLiquibaseException("Unexpected example type: " + example.getClass().getName());
        }
        Database database = snapshot.getDatabase();
        ResultSet catalogs = null;
        Catalog match = null;
        String catalogName = example.getName();
        if (catalogName == null && database.supportsCatalogs()) {
            catalogName = database.getDefaultCatalogName();
        }
        example = new Catalog(catalogName);
        try {
            catalogs = ((AbstractJdbcDatabase)database).jdbcCallsCatalogsSchemas() ? ((JdbcConnection)database.getConnection()).getMetaData().getSchemas() : ((JdbcConnection)database.getConnection()).getMetaData().getCatalogs();
            while (catalogs.next()) {
                Catalog catalog = ((AbstractJdbcDatabase)database).jdbcCallsCatalogsSchemas() ? new Catalog(catalogs.getString("TABLE_SCHEM")) : new Catalog(catalogs.getString("TABLE_CAT"));
                if (!DatabaseObjectComparatorFactory.getInstance().isSameObject(catalog, example, database)) continue;
                if (match == null) {
                    match = catalog;
                    continue;
                }
                throw new InvalidExampleException("Found multiple catalogs matching " + example.getName());
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            if (catalogs != null) {
                try {
                    catalogs.close();
                }
                catch (SQLException ignore) {}
            }
        }
        return match;
    }

    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
    }
}

