/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot.jvm;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Scanner;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.database.core.FirebirdDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.logging.LogFactory;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.JdbcDatabaseSnapshot;
import liquibase.snapshot.jvm.JdbcSnapshotGenerator;
import liquibase.statement.DatabaseFunction;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.DataType;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.structure.core.View;
import liquibase.util.StringUtils;

public class ColumnSnapshotGenerator
extends JdbcSnapshotGenerator {
    public ColumnSnapshotGenerator() {
        super(Column.class, new Class[]{Table.class, View.class});
    }

    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        Database database = snapshot.getDatabase();
        Relation relation = ((Column)example).getRelation();
        Schema schema = relation.getSchema();
        List<JdbcDatabaseSnapshot.CachedRow> columnMetadataRs = null;
        try {
            JdbcDatabaseSnapshot.CachingDatabaseMetaData databaseMetaData = ((JdbcDatabaseSnapshot)snapshot).getMetaData();
            columnMetadataRs = databaseMetaData.getColumns(((AbstractJdbcDatabase)database).getJdbcCatalogName(schema), ((AbstractJdbcDatabase)database).getJdbcSchemaName(schema), relation.getName(), example.getName());
            if (columnMetadataRs.size() > 0) {
                JdbcDatabaseSnapshot.CachedRow data = columnMetadataRs.get(0);
                return this.readColumn(data, relation, database);
            }
            return null;
        }
        catch (Exception e) {
            throw new DatabaseException(e);
        }
    }

    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getSnapshotControl().shouldInclude(Column.class)) {
            return;
        }
        if (foundObject instanceof Relation) {
            Database database = snapshot.getDatabase();
            Relation relation = (Relation)foundObject;
            List<JdbcDatabaseSnapshot.CachedRow> allColumnsMetadataRs = null;
            try {
                JdbcDatabaseSnapshot.CachingDatabaseMetaData databaseMetaData = ((JdbcDatabaseSnapshot)snapshot).getMetaData();
                Schema schema = relation.getSchema();
                allColumnsMetadataRs = databaseMetaData.getColumns(((AbstractJdbcDatabase)database).getJdbcCatalogName(schema), ((AbstractJdbcDatabase)database).getJdbcSchemaName(schema), relation.getName(), null);
                for (JdbcDatabaseSnapshot.CachedRow row : allColumnsMetadataRs) {
                    Column exampleColumn = new Column().setRelation(relation).setName(row.getString("COLUMN_NAME"));
                    relation.getColumns().add(exampleColumn);
                }
            }
            catch (Exception e) {
                throw new DatabaseException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Column readColumn(JdbcDatabaseSnapshot.CachedRow columnMetadataResultSet, Relation table, Database database) throws SQLException, DatabaseException {
        String rawTableName = (String)columnMetadataResultSet.get("TABLE_NAME");
        String rawColumnName = (String)columnMetadataResultSet.get("COLUMN_NAME");
        String rawSchemaName = StringUtils.trimToNull((String)columnMetadataResultSet.get("TABLE_SCHEM"));
        String rawCatalogName = StringUtils.trimToNull((String)columnMetadataResultSet.get("TABLE_CAT"));
        String remarks = StringUtils.trimToNull((String)columnMetadataResultSet.get("REMARKS"));
        if (remarks != null) {
            remarks = remarks.replace("''", "'");
        }
        Column column = new Column();
        column.setName(rawColumnName);
        column.setRelation(table);
        column.setRemarks(remarks);
        int nullable = columnMetadataResultSet.getInt("NULLABLE");
        if (nullable == 0) {
            column.setNullable(false);
        } else if (nullable == 1) {
            column.setNullable(true);
        } else if (nullable == 2) {
            LogFactory.getLogger().info("Unknown nullable state for column " + column.toString() + ". Assuming nullable");
            column.setNullable(true);
        }
        if (table instanceof Table) {
            if (columnMetadataResultSet.containsColumn("IS_AUTOINCREMENT")) {
                String isAutoincrement = (String)columnMetadataResultSet.get("IS_AUTOINCREMENT");
                if ((isAutoincrement = StringUtils.trimToNull(isAutoincrement)) == null) {
                    column.setAutoIncrementInformation(null);
                } else if (isAutoincrement.equals("YES")) {
                    column.setAutoIncrementInformation(new Column.AutoIncrementInformation());
                } else if (isAutoincrement.equals("NO")) {
                    column.setAutoIncrementInformation(null);
                } else {
                    if (!isAutoincrement.equals("")) throw new UnexpectedLiquibaseException("Unknown is_autoincrement value: '" + isAutoincrement + "'");
                    LogFactory.getLogger().info("Unknown auto increment state for column " + column.toString() + ". Assuming not auto increment");
                    column.setAutoIncrementInformation(null);
                }
            } else {
                String selectStatement = "select " + database.escapeColumnName(rawCatalogName, rawSchemaName, rawTableName, rawColumnName) + " from " + database.escapeTableName(rawCatalogName, rawSchemaName, rawTableName) + " where 0=1";
                LogFactory.getLogger().debug("Checking " + rawTableName + "." + rawCatalogName + " for auto-increment with SQL: '" + selectStatement + "'");
                Connection underlyingConnection = ((JdbcConnection)database.getConnection()).getUnderlyingConnection();
                Statement statement = underlyingConnection.createStatement();
                ResultSet columnSelectRS = statement.executeQuery(selectStatement);
                try {
                    if (columnSelectRS.getMetaData().isAutoIncrement(1)) {
                        column.setAutoIncrementInformation(new Column.AutoIncrementInformation());
                    } else {
                        column.setAutoIncrementInformation(null);
                    }
                }
                finally {
                    try {
                        statement.close();
                    }
                    catch (SQLException ignore) {}
                    columnSelectRS.close();
                }
            }
        }
        DataType type = this.readDataType(columnMetadataResultSet, column, database);
        column.setType(type);
        column.setDefaultValue(this.readDefaultValue(columnMetadataResultSet, column, database));
        return column;
    }

    protected DataType readDataType(JdbcDatabaseSnapshot.CachedRow columnMetadataResultSet, Column column, Database database) throws SQLException {
        String columnTypeName = (String)columnMetadataResultSet.get("TYPE_NAME");
        if (database instanceof FirebirdDatabase) {
            if (columnTypeName.equals("BLOB SUB_TYPE 0")) {
                columnTypeName = "BLOB";
            }
            if (columnTypeName.equals("BLOB SUB_TYPE 1")) {
                columnTypeName = "CLOB";
            }
        }
        DataType.ColumnSizeUnit columnSizeUnit = DataType.ColumnSizeUnit.BYTE;
        int dataType = columnMetadataResultSet.getInt("DATA_TYPE");
        Integer columnSize = columnMetadataResultSet.getInt("COLUMN_SIZE");
        if (database.dataTypeIsNotModifiable(columnTypeName)) {
            columnSize = null;
        } else if (database instanceof OracleDatabase && columnTypeName.equals("NVARCHAR2")) {
            columnSize = columnSize / 2;
            columnSizeUnit = DataType.ColumnSizeUnit.CHAR;
        }
        Integer decimalDigits = columnMetadataResultSet.getInt("DECIMAL_DIGITS");
        if (decimalDigits != null && decimalDigits.equals(0)) {
            decimalDigits = null;
        }
        Integer radix = columnMetadataResultSet.getInt("NUM_PREC_RADIX");
        Integer characterOctetLength = columnMetadataResultSet.getInt("CHAR_OCTET_LENGTH");
        DataType type = new DataType(columnTypeName);
        type.setDataTypeId(dataType);
        type.setColumnSize(columnSize);
        type.setDecimalDigits(decimalDigits);
        type.setRadix(radix);
        type.setCharacterOctetLength(characterOctetLength);
        type.setColumnSizeUnit(columnSizeUnit);
        return type;
    }

    protected Object readDefaultValue(JdbcDatabaseSnapshot.CachedRow columnMetadataResultSet, Column columnInfo, Database database) throws SQLException, DatabaseException {
        Object val;
        Object defaultValue;
        if (database instanceof MSSQLDatabase && (defaultValue = columnMetadataResultSet.get("COLUMN_DEF")) != null && defaultValue instanceof String) {
            Object newValue = null;
            if (defaultValue.equals("(NULL)")) {
                newValue = null;
            }
            columnMetadataResultSet.set("COLUMN_DEF", newValue);
        }
        if (!((val = columnMetadataResultSet.get("COLUMN_DEF")) instanceof String)) {
            return val;
        }
        String stringVal = (String)val;
        if (stringVal.isEmpty()) {
            return null;
        }
        if (stringVal.startsWith("'") && stringVal.endsWith("'")) {
            stringVal = stringVal.substring(1, stringVal.length() - 1);
        } else if (stringVal.startsWith("(") && stringVal.endsWith(")")) {
            return new DatabaseFunction(stringVal.substring(1, stringVal.length() - 1));
        }
        int type = columnInfo.getType().getDataTypeId();
        String typeName = columnInfo.getType().getTypeName();
        Scanner scanner = new Scanner(stringVal.trim());
        try {
            if (type == 2003) {
                return new DatabaseFunction(stringVal);
            }
            if (type == -5 && scanner.hasNextBigInteger()) {
                return scanner.nextBigInteger();
            }
            if (type == -2) {
                return new DatabaseFunction(stringVal.trim());
            }
            if (type == -7) {
                if (stringVal.startsWith("b'")) {
                    stringVal = stringVal.replaceFirst("b'", "").replaceFirst("'$", "");
                }
                stringVal = stringVal.trim();
                if (scanner.hasNextBoolean()) {
                    return scanner.nextBoolean();
                }
                return new Integer(stringVal);
            }
            if (type == 2004) {
                return new DatabaseFunction(stringVal);
            }
            if (type == 16 && scanner.hasNextBoolean()) {
                return scanner.nextBoolean();
            }
            if (type == 1) {
                return stringVal;
            }
            if (type == 70) {
                return new DatabaseFunction(stringVal);
            }
            if (type == 91) {
                return new Date(this.getDateFormat(database).parse(stringVal.trim()).getTime());
            }
            if (type == 3 && scanner.hasNextBigDecimal()) {
                return scanner.nextBigDecimal();
            }
            if (type == 2001) {
                return new DatabaseFunction(stringVal);
            }
            if (type == 8 && scanner.hasNextDouble()) {
                return scanner.nextDouble();
            }
            if (type == 6 && scanner.hasNextFloat()) {
                return Float.valueOf(scanner.nextFloat());
            }
            if (type == 4 && scanner.hasNextInt()) {
                return scanner.nextInt();
            }
            if (type == 2000) {
                return new DatabaseFunction(stringVal);
            }
            if (type == -16) {
                return stringVal;
            }
            if (type == -4) {
                return new DatabaseFunction(stringVal);
            }
            if (type == -1) {
                return stringVal;
            }
            if (type == -15) {
                return stringVal;
            }
            if (type == 2011) {
                return stringVal;
            }
            if (type == 0) {
                return null;
            }
            if (type == 2 && scanner.hasNextBigDecimal()) {
                return scanner.nextBigDecimal();
            }
            if (type == -9) {
                return stringVal;
            }
            if (type == 1111) {
                return new DatabaseFunction(stringVal);
            }
            if (type == 7) {
                return new BigDecimal(stringVal.trim());
            }
            if (type == 2006) {
                return new DatabaseFunction(stringVal);
            }
            if (type == -8) {
                return new DatabaseFunction(stringVal);
            }
            if (type == 5 && scanner.hasNextInt()) {
                return scanner.nextInt();
            }
            if (type == 2009) {
                return new DatabaseFunction(stringVal);
            }
            if (type == 2002) {
                return new DatabaseFunction(stringVal);
            }
            if (type == 92) {
                return new Time(this.getTimeFormat(database).parse(stringVal).getTime());
            }
            if (type == 93) {
                return new Timestamp(this.getDateTimeFormat(database).parse(stringVal).getTime());
            }
            if (type == -6 && scanner.hasNextInt()) {
                return scanner.nextInt();
            }
            if (type == -3) {
                return new DatabaseFunction(stringVal);
            }
            if (type == 12) {
                return stringVal;
            }
            LogFactory.getLogger().info("Unknown default value: value '" + stringVal + "' type " + typeName + " (" + type + "), assuming it is a function");
            return new DatabaseFunction(stringVal);
        }
        catch (ParseException e) {
            return new DatabaseFunction(stringVal);
        }
    }

    protected DateFormat getDateFormat(Database database) {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    protected DateFormat getTimeFormat(Database database) {
        return new SimpleDateFormat("HH:mm:SS");
    }

    protected DateFormat getDateTimeFormat(Database database) {
        if (database instanceof MySQLDatabase) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:SS");
        }
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    }
}

