/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot.jvm;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import liquibase.CatalogAndSchema;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.exception.DatabaseException;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.JdbcDatabaseSnapshot;
import liquibase.snapshot.jvm.JdbcSnapshotGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.ForeignKeyConstraintType;
import liquibase.structure.core.Index;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;

public class ForeignKeySnapshotGenerator
extends JdbcSnapshotGenerator {
    public ForeignKeySnapshotGenerator() {
        super(ForeignKey.class, new Class[]{Table.class});
    }

    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getSnapshotControl().shouldInclude(ForeignKey.class)) {
            return;
        }
        if (foundObject instanceof Table) {
            Table table = (Table)foundObject;
            Database database = snapshot.getDatabase();
            Schema schema = table.getSchema();
            HashSet<String> seenFks = new HashSet<String>();
            List<JdbcDatabaseSnapshot.CachedRow> importedKeyMetadataResultSet = null;
            try {
                importedKeyMetadataResultSet = ((JdbcDatabaseSnapshot)snapshot).getMetaData().getImportedKeys(((AbstractJdbcDatabase)database).getJdbcCatalogName(schema), ((AbstractJdbcDatabase)database).getJdbcSchemaName(schema), database.correctObjectName(table.getName(), Table.class));
                for (JdbcDatabaseSnapshot.CachedRow row : importedKeyMetadataResultSet) {
                    ForeignKey fk = new ForeignKey().setName(row.getString("FK_NAME")).setForeignKeyTable(table);
                    if (!seenFks.add(fk.getName())) continue;
                    table.getOutgoingForeignKeys().add(fk);
                }
            }
            catch (Exception e) {
                throw new DatabaseException(e);
            }
            seenFks = new HashSet();
            List<JdbcDatabaseSnapshot.CachedRow> exportedKeyMetadataResultSet = null;
            try {
                exportedKeyMetadataResultSet = ((JdbcDatabaseSnapshot)snapshot).getMetaData().getExportedKeys(((AbstractJdbcDatabase)database).getJdbcCatalogName(schema), ((AbstractJdbcDatabase)database).getJdbcSchemaName(schema), database.correctObjectName(table.getName(), Table.class));
                for (JdbcDatabaseSnapshot.CachedRow row : exportedKeyMetadataResultSet) {
                    Table fktable = (Table)new Table().setName(row.getString("FKTABLE_NAME")).setSchema(new Schema(row.getString("FKTABLE_CAT"), row.getString("FKTABLE_SCHEM")));
                    ForeignKey fk = new ForeignKey().setName(row.getString("FK_NAME")).setForeignKeyTable(fktable);
                    if (!seenFks.add(fk.getName())) continue;
                    table.getIncomingForeignKeys().add(fk);
                }
            }
            catch (Exception e) {
                throw new DatabaseException(e);
            }
        }
    }

    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        Database database = snapshot.getDatabase();
        List<JdbcDatabaseSnapshot.CachedRow> importedKeyMetadataResultSet = null;
        try {
            Table fkTable = ((ForeignKey)example).getForeignKeyTable();
            String searchCatalog = ((AbstractJdbcDatabase)database).getJdbcCatalogName(fkTable.getSchema());
            String searchSchema = ((AbstractJdbcDatabase)database).getJdbcSchemaName(fkTable.getSchema());
            String searchTableName = database.correctObjectName(fkTable.getName(), Table.class);
            importedKeyMetadataResultSet = ((JdbcDatabaseSnapshot)snapshot).getMetaData().getImportedKeys(searchCatalog, searchSchema, searchTableName);
            ForeignKey foreignKey = null;
            for (JdbcDatabaseSnapshot.CachedRow row : importedKeyMetadataResultSet) {
                String fk_name = this.cleanNameFromDatabase(row.getString("FK_NAME"), database);
                if (!fk_name.equals(example.getName())) continue;
                if (foreignKey == null) {
                    foreignKey = new ForeignKey();
                }
                foreignKey.setName(fk_name);
                String fkTableCatalog = this.cleanNameFromDatabase(row.getString("FKTABLE_CAT"), database);
                String fkTableSchema = this.cleanNameFromDatabase(row.getString("FKTABLE_SCHEM"), database);
                String fkTableName = this.cleanNameFromDatabase(row.getString("FKTABLE_NAME"), database);
                Table foreignKeyTable = new Table().setName(fkTableName);
                foreignKeyTable.setSchema(new Schema(new Catalog(fkTableCatalog), fkTableSchema));
                foreignKey.setForeignKeyTable(foreignKeyTable);
                foreignKey.addForeignKeyColumn(this.cleanNameFromDatabase(row.getString("FKCOLUMN_NAME"), database));
                CatalogAndSchema pkTableSchema = ((AbstractJdbcDatabase)database).getSchemaFromJdbcInfo(row.getString("PKTABLE_CAT"), row.getString("PKTABLE_SCHEM"));
                Table tempPkTable = (Table)new Table().setName(row.getString("PKTABLE_NAME")).setSchema(new Schema(pkTableSchema.getCatalogName(), pkTableSchema.getSchemaName()));
                foreignKey.setPrimaryKeyTable(tempPkTable);
                foreignKey.addPrimaryKeyColumn(this.cleanNameFromDatabase(row.getString("PKCOLUMN_NAME"), database));
                ForeignKeyConstraintType updateRule = this.convertToForeignKeyConstraintType(row.getInt("UPDATE_RULE"), database);
                foreignKey.setUpdateRule(updateRule);
                ForeignKeyConstraintType deleteRule = this.convertToForeignKeyConstraintType(row.getInt("DELETE_RULE"), database);
                foreignKey.setDeleteRule(deleteRule);
                short deferrability = row.getShort("DEFERRABILITY");
                if (deferrability == 0 || deferrability == 7) {
                    foreignKey.setDeferrable(false);
                    foreignKey.setInitiallyDeferred(false);
                } else if (deferrability == 5) {
                    foreignKey.setDeferrable(true);
                    foreignKey.setInitiallyDeferred(true);
                } else if (deferrability == 6) {
                    foreignKey.setDeferrable(true);
                    foreignKey.setInitiallyDeferred(false);
                } else {
                    throw new RuntimeException("Unknown deferrability result: " + deferrability);
                }
                if (database.createsIndexesForForeignKeys()) {
                    Index exampleIndex = new Index().setTable(foreignKey.getForeignKeyTable());
                    exampleIndex.getColumns().addAll(Arrays.asList(foreignKey.getForeignKeyColumns().split("\\s*,\\s*")));
                    foreignKey.setBackingIndex(exampleIndex);
                }
                return foreignKey;
            }
            return foreignKey;
        }
        catch (Exception e) {
            throw new DatabaseException(e);
        }
    }

    protected ForeignKeyConstraintType convertToForeignKeyConstraintType(Integer jdbcType, Database database) throws DatabaseException {
        if (jdbcType == null) {
            return ForeignKeyConstraintType.importedKeyRestrict;
        }
        if (database instanceof MSSQLDatabase) {
            if (jdbcType == 0) {
                return ForeignKeyConstraintType.importedKeyCascade;
            }
            if (jdbcType == 1) {
                return ForeignKeyConstraintType.importedKeyNoAction;
            }
            if (jdbcType == 2) {
                return ForeignKeyConstraintType.importedKeySetNull;
            }
            throw new DatabaseException("Unknown constraint type: " + jdbcType);
        }
        if (jdbcType == 0) {
            return ForeignKeyConstraintType.importedKeyCascade;
        }
        if (jdbcType == 3) {
            return ForeignKeyConstraintType.importedKeyNoAction;
        }
        if (jdbcType == 1) {
            return ForeignKeyConstraintType.importedKeyRestrict;
        }
        if (jdbcType == 4) {
            return ForeignKeyConstraintType.importedKeySetDefault;
        }
        if (jdbcType == 2) {
            return ForeignKeyConstraintType.importedKeySetNull;
        }
        throw new DatabaseException("Unknown constraint type: " + jdbcType);
    }
}

