/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot.jvm;

import java.util.List;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.FirebirdDatabase;
import liquibase.database.core.H2Database;
import liquibase.database.core.HsqlDatabase;
import liquibase.database.core.InformixDatabase;
import liquibase.database.core.MaxDBDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.ExecutorService;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.jvm.JdbcSnapshotGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Sequence;

public class SequenceSnapshotGenerator
extends JdbcSnapshotGenerator {
    public SequenceSnapshotGenerator() {
        super(Sequence.class, new Class[]{Schema.class});
    }

    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getDatabase().supportsSequences()) {
            return;
        }
        if (foundObject instanceof Schema) {
            List sequenceNames;
            Schema schema = (Schema)foundObject;
            Database database = snapshot.getDatabase();
            if (!database.supportsSequences()) {
                this.updateListeners("Sequences not supported for " + database.toString() + " ...");
            }
            if ((sequenceNames = ExecutorService.getInstance().getExecutor(database).queryForList((SqlStatement)new RawSqlStatement(this.getSelectSequenceSql(schema, database)), String.class)) != null) {
                for (String sequenceName : sequenceNames) {
                    schema.addDatabaseObject(new Sequence().setName(this.cleanNameFromDatabase(sequenceName, database)).setSchema(schema));
                }
            }
        }
    }

    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException {
        Database database = snapshot.getDatabase();
        if (!database.supportsSequences()) {
            return null;
        }
        List sequenceNames = ExecutorService.getInstance().getExecutor(database).queryForList((SqlStatement)new RawSqlStatement(this.getSelectSequenceSql(example.getSchema(), database)), String.class);
        for (String name : sequenceNames) {
            name = this.cleanNameFromDatabase(name, database);
            if ((!database.isCaseSensitive() || !name.equals(example.getName())) && (database.isCaseSensitive() || !name.equalsIgnoreCase(example.getName()))) continue;
            Sequence seq = new Sequence();
            seq.setName(name);
            seq.setSchema(example.getSchema());
            return seq;
        }
        return null;
    }

    protected String getSelectSequenceSql(Schema schema, Database database) {
        if (database instanceof DB2Database) {
            return "SELECT SEQNAME AS SEQUENCE_NAME FROM SYSCAT.SEQUENCES WHERE SEQTYPE='S' AND SEQSCHEMA = '" + schema.getCatalogName() + "'";
        }
        if (database instanceof DerbyDatabase) {
            return "SELECT   seq.SEQUENCENAME AS SEQUENCE_NAME FROM   SYS.SYSSEQUENCES seq,   SYS.SYSSCHEMAS sch WHERE   sch.SCHEMANAME = '" + schema.getName() + "' AND " + "  sch.SCHEMAID = seq.SCHEMAID";
        }
        if (database instanceof FirebirdDatabase) {
            return "SELECT RDB$GENERATOR_NAME FROM RDB$GENERATORS WHERE RDB$SYSTEM_FLAG IS NULL OR RDB$SYSTEM_FLAG = 0";
        }
        if (database instanceof H2Database) {
            return "SELECT SEQUENCE_NAME FROM INFORMATION_SCHEMA.SEQUENCES WHERE SEQUENCE_SCHEMA = '" + schema.getName() + "' AND IS_GENERATED=FALSE";
        }
        if (database instanceof HsqlDatabase) {
            return "SELECT SEQUENCE_NAME FROM INFORMATION_SCHEMA.SYSTEM_SEQUENCES WHERE SEQUENCE_SCHEMA = '" + schema.getName() + "'";
        }
        if (database instanceof InformixDatabase) {
            return "SELECT tabname FROM systables t, syssequences s WHERE s.tabid = t.tabid AND t.owner = '" + schema.getName() + "'";
        }
        if (database instanceof MaxDBDatabase) {
            return "SELECT SEQUENCE_NAME FROM DOMAIN.SEQUENCES WHERE OWNER = '" + schema.getName() + "'";
        }
        if (database instanceof OracleDatabase) {
            return "SELECT SEQUENCE_NAME FROM ALL_SEQUENCES WHERE SEQUENCE_OWNER = '" + schema.getCatalogName() + "'";
        }
        if (database instanceof PostgresDatabase) {
            return "SELECT relname AS SEQUENCE_NAME FROM pg_class, pg_namespace WHERE relkind='S' AND pg_class.relnamespace = pg_namespace.oid AND nspname = '" + schema.getName() + "' " + "AND 'nextval(''" + (schema == null ? "" : schema + ".") + "'||relname||'''::regclass)' not in (select adsrc from pg_attrdef where adsrc is not null) " + "AND 'nextval(''" + (schema == null ? "" : schema + ".") + "\"'||relname||'\"''::regclass)' not in (select adsrc from pg_attrdef where adsrc is not null) " + "AND 'nextval('''||relname||'''::regclass)' not in (select adsrc from pg_attrdef where adsrc is not null)" + "AND 'nextval(''\"'||relname||'\"''::regclass)' not in (select adsrc from pg_attrdef where adsrc is not null)";
        }
        throw new UnexpectedLiquibaseException("Don't know how to query for sequences on " + database);
    }
}

