/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot.jvm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.FirebirdDatabase;
import liquibase.database.core.HsqlDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.ExecutorService;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.jvm.JdbcSnapshotGenerator;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.structure.core.UniqueConstraint;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueConstraintSnapshotGenerator
extends JdbcSnapshotGenerator {
    public UniqueConstraintSnapshotGenerator() {
        super(UniqueConstraint.class, new Class[]{Table.class});
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        Database database = snapshot.getDatabase();
        UniqueConstraint exampleConstraint = (UniqueConstraint)example;
        Table table = exampleConstraint.getTable();
        List<Map> metadata = this.listColumns(exampleConstraint, database);
        if (metadata.size() == 0) {
            return null;
        }
        UniqueConstraint constraint = new UniqueConstraint();
        constraint.setTable(table);
        constraint.setName(example.getName());
        for (Map col : metadata) {
            constraint.getColumns().add((String)col.get("COLUMN_NAME"));
        }
        return constraint;
    }

    @Override
    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getSnapshotControl().shouldInclude(UniqueConstraint.class)) {
            return;
        }
        if (foundObject instanceof Table) {
            Table table = (Table)foundObject;
            Database database = snapshot.getDatabase();
            Schema schema = table.getSchema();
            List<Map> metadata = this.listConstraints(table, database, schema);
            HashSet<String> seenConstraints = new HashSet<String>();
            for (Map constraint : metadata) {
                UniqueConstraint uq = new UniqueConstraint().setName(this.cleanNameFromDatabase((String)constraint.get("CONSTRAINT_NAME"), database)).setTable(table);
                if (!seenConstraints.add(uq.getName())) continue;
                table.getUniqueConstraints().add(uq);
            }
        }
    }

    protected List<Map> listConstraints(Table table, Database database, Schema schema) throws DatabaseException {
        String sql = null;
        sql = database instanceof MySQLDatabase || database instanceof HsqlDatabase ? "select CONSTRAINT_NAME from information_schema.table_constraints where constraint_schema='" + database.correctObjectName(schema.getCatalogName(), Catalog.class) + "' " + "and constraint_type='UNIQUE' " + "and table_name='" + database.correctObjectName(table.getName(), Table.class) + "'" : (database instanceof PostgresDatabase ? "select CONSTRAINT_NAME from information_schema.table_constraints where constraint_catalog='" + database.correctObjectName(schema.getCatalogName(), Catalog.class) + "' " + "and constraint_schema='" + database.correctObjectName(schema.getSchema().getName(), Schema.class) + "' " + "and constraint_type='UNIQUE' " + "and table_name='" + database.correctObjectName(table.getName(), Table.class) + "'" : (database instanceof MSSQLDatabase ? "select Constraint_Name from information_schema.table_constraints where constraint_type = 'Unique' and constraint_schema='" + database.correctObjectName(schema.getName(), Schema.class) + "' " + "and table_name='" + database.correctObjectName(table.getName(), Table.class) + "'" : (database instanceof OracleDatabase ? "select uc.constraint_name, uc.table_name,uc.status,uc.deferrable,uc.deferred,ui.tablespace_name from all_constraints uc, all_cons_columns ucc, all_indexes ui where uc.constraint_type='U' and uc.index_name = ui.index_name and uc.constraint_name = ucc.constraint_name and uc.table_name = '" + database.correctObjectName(table.getName(), Table.class) + "' " + "and uc.owner = '" + database.correctObjectName(schema.getCatalogName(), Catalog.class) + "' " + "and ui.table_owner = '" + database.correctObjectName(schema.getCatalogName(), Catalog.class) + "' " + "and ucc.owner = '" + database.correctObjectName(schema.getCatalogName(), Catalog.class) + "'" : (database instanceof DB2Database ? "select distinct k.constname as constraint_name from syscat.keycoluse k, syscat.tabconst t where k.constname = t.constname and t.tabname = '" + database.correctObjectName(table.getName(), Table.class) + "' " + "and t.tabschema = '" + database.correctObjectName(schema.getCatalogName(), Catalog.class) + "' " + "and t.type='U'" : (database instanceof FirebirdDatabase ? "SELECT RDB$INDICES.RDB$INDEX_NAME AS CONSTRAINT_NAME FROM RDB$INDICES LEFT JOIN RDB$RELATION_CONSTRAINTS ON RDB$RELATION_CONSTRAINTS.RDB$INDEX_NAME = RDB$INDICES.RDB$INDEX_NAME WHERE RDB$INDICES.RDB$RELATION_NAME='" + database.correctObjectName(table.getName(), Table.class) + "' " + "AND RDB$INDICES.RDB$UNIQUE_FLAG IS NOT NULL " + "AND RDB$RELATION_CONSTRAINTS.RDB$CONSTRAINT_TYPE != 'PRIMARY KEY' " + "AND NOT(RDB$INDICES.RDB$INDEX_NAME LIKE 'RDB$%')" : (database instanceof DerbyDatabase ? "select c.constraintname as CONSTRAINT_NAME from sys.systables t, sys.sysconstraints c, sys.sysschemas s where t.tablename = '" + database.correctObjectName(table.getName(), Table.class) + "' " + "and s.schemaname='" + database.correctObjectName(schema.getCatalogName(), Catalog.class) + "' " + "and t.tableid = c.tableid " + "and t.schemaid=s.schemaid " + "and c.type = 'U'" : "select CONSTRAINT_NAME, CONSTRAINT_TYPE from information_schema.constraints where constraint_schema='" + database.correctObjectName(schema.getName(), Schema.class) + "' " + "and constraint_catalog='" + database.correctObjectName(schema.getCatalogName(), Catalog.class) + "' " + "and constraint_type='UNIQUE' " + "and table_name='" + database.correctObjectName(table.getName(), Table.class) + "'"))))));
        return ExecutorService.getInstance().getExecutor(database).queryForList(new RawSqlStatement(sql));
    }

    protected List<Map> listColumns(UniqueConstraint example, Database database) throws DatabaseException {
        Table table = example.getTable();
        Schema schema = table.getSchema();
        String name = example.getName();
        String sql = null;
        if (database instanceof MySQLDatabase || database instanceof HsqlDatabase) {
            sql = "select const.CONSTRAINT_NAME, COLUMN_NAME from information_schema.table_constraints const join information_schema.key_column_usage col on const.constraint_schema=col.constraint_schema and const.table_name=col.table_name and const.constraint_name=col.constraint_name where const.constraint_schema='" + database.correctObjectName(schema.getCatalogName(), Catalog.class) + "' " + "and const.table_name='" + database.correctObjectName(example.getTable().getName(), Table.class) + "' " + "and const.constraint_name='" + database.correctObjectName(name, UniqueConstraint.class) + "'" + "order by ordinal_position";
        } else if (database instanceof PostgresDatabase) {
            sql = "select const.CONSTRAINT_NAME, COLUMN_NAME from information_schema.table_constraints const join information_schema.key_column_usage col on const.constraint_schema=col.constraint_schema and const.table_name=col.table_name and const.constraint_name=col.constraint_name where const.constraint_catalog='" + database.correctObjectName(schema.getCatalogName(), Catalog.class) + "' " + "and const.constraint_schema='" + database.correctObjectName(schema.getSchema().getName(), Schema.class) + "' " + "and const.table_name='" + database.correctObjectName(example.getTable().getName(), Table.class) + "' " + "and const.constraint_name='" + database.correctObjectName(name, UniqueConstraint.class) + "'" + "order by ordinal_position";
        } else if (database instanceof MSSQLDatabase) {
            sql = "select TC.Constraint_Name as CONSTRAINT_NAME, CC.Column_Name as COLUMN_NAME from information_schema.table_constraints TC inner join information_schema.constraint_column_usage CC on TC.Constraint_Name = CC.Constraint_Name where TC.constraint_schema='" + database.correctObjectName(schema.getCatalogName(), Catalog.class) + "' " + "and TC.table_name='" + database.correctObjectName(example.getTable().getName(), Table.class) + "' " + "and TC.Constraint_Name='" + database.correctObjectName(name, UniqueConstraint.class) + "'" + "order by TC.Constraint_Name";
        } else if (database instanceof OracleDatabase) {
            sql = "select ucc.column_name from all_cons_columns ucc where ucc.constraint_name='" + database.correctObjectName(name, UniqueConstraint.class) + "' and ucc.owner='" + database.correctObjectName(schema.getCatalogName(), Catalog.class) + "' order by ucc.position";
        } else if (database instanceof DB2Database) {
            sql = "select k.colname as column_name from syscat.keycoluse k, syscat.tabconst t where k.constname = t.constname and t.type='U' and k.constname='" + database.correctObjectName(name, UniqueConstraint.class) + "' " + "order by colseq";
        } else {
            if (database instanceof DerbyDatabase) {
                sql = "SELECT cg.descriptor as descriptor, t.tablename FROM sys.sysconglomerates cg JOIN sys.syskeys k ON cg.conglomerateid = k.conglomerateid JOIN sys.sysconstraints c ON c.constraintid = k.constraintid JOIN sys.systables t ON c.tableid = t.tableid WHERE c.constraintname='" + database.correctObjectName(name, UniqueConstraint.class) + "'";
                List<Map> rows = ExecutorService.getInstance().getExecutor(database).queryForList(new RawSqlStatement(sql));
                ArrayList<Map> returnList = new ArrayList<Map>();
                if (rows.size() == 0) {
                    return returnList;
                }
                if (rows.size() > 1) {
                    throw new UnexpectedLiquibaseException("Got multiple rows back querying unique constraints");
                }
                Map rowData = rows.get(0);
                String descriptor = rowData.get("DESCRIPTOR").toString();
                descriptor = descriptor.replaceFirst(".*\\(", "").replaceFirst("\\).*", "");
                for (String columnNumber : StringUtils.splitAndTrim(descriptor, ",")) {
                    String columnName = (String)ExecutorService.getInstance().getExecutor(database).queryForObject(new RawSqlStatement("select c.columnname from sys.syscolumns c join sys.systables t on t.tableid=c.referenceid where t.tablename='" + rowData.get("TABLENAME") + "' and c.columnnumber=" + columnNumber), String.class);
                    HashMap<String, String> row = new HashMap<String, String>();
                    row.put("COLUMN_NAME", columnName);
                    returnList.add(row);
                }
                return returnList;
            }
            if (database instanceof FirebirdDatabase) {
                sql = "SELECT RDB$INDEX_SEGMENTS.RDB$FIELD_NAME AS column_name FROM RDB$INDEX_SEGMENTS LEFT JOIN RDB$INDICES ON RDB$INDICES.RDB$INDEX_NAME = RDB$INDEX_SEGMENTS.RDB$INDEX_NAME WHERE UPPER(RDB$INDICES.RDB$INDEX_NAME)='" + database.correctObjectName(name, UniqueConstraint.class) + "' " + "ORDER BY RDB$INDEX_SEGMENTS.RDB$FIELD_POSITION";
            } else {
                String catalogName = database.correctObjectName(schema.getCatalogName(), Catalog.class);
                String schemaName = database.correctObjectName(schema.getName(), Schema.class);
                String constraintName = database.correctObjectName(name, UniqueConstraint.class);
                String tableName = database.correctObjectName(table.getName(), Table.class);
                sql = "select CONSTRAINT_NAME, COLUMN_LIST as COLUMN_NAME from information_schema.constraints where constraint_type='UNIQUE' ";
                if (catalogName != null) {
                    sql = sql + "and constraint_catalog='" + catalogName + "' ";
                }
                if (schemaName != null) {
                    sql = sql + "and constraint_schema='" + schemaName + "' ";
                }
                if (tableName != null) {
                    sql = sql + "and table_name='" + tableName + "' ";
                }
                if (constraintName != null) {
                    sql = sql + "and constraint_name='" + constraintName + "'";
                }
            }
        }
        return ExecutorService.getInstance().getExecutor(database).queryForList(new RawSqlStatement(sql));
    }
}

