/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator;

import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.servicelocator.PrioritizedService;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.statement.SqlStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface SqlGenerator<StatementType extends SqlStatement>
extends PrioritizedService {
    public static final int PRIORITY_DEFAULT = 1;
    public static final int PRIORITY_DATABASE = 5;

    @Override
    public int getPriority();

    public boolean supports(StatementType var1, Database var2);

    public boolean generateStatementsIsVolatile(Database var1);

    public boolean generateRollbackStatementsIsVolatile(Database var1);

    public ValidationErrors validate(StatementType var1, Database var2, SqlGeneratorChain var3);

    public Warnings warn(StatementType var1, Database var2, SqlGeneratorChain var3);

    public Sql[] generateSql(StatementType var1, Database var2, SqlGeneratorChain var3);
}

