/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import liquibase.database.Database;
import liquibase.database.core.InformixDatabase;
import liquibase.database.core.SybaseDatabase;
import liquibase.datatype.DataTypeFactory;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.sqlgenerator.core.CreateDatabaseChangeLogTableGeneratorInformix;
import liquibase.statement.NotNullConstraint;
import liquibase.statement.core.CreateDatabaseChangeLogTableStatement;
import liquibase.statement.core.CreateTableStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateDatabaseChangeLogTableGenerator
extends AbstractSqlGenerator<CreateDatabaseChangeLogTableStatement> {
    @Override
    public boolean supports(CreateDatabaseChangeLogTableStatement statement, Database database) {
        return !(database instanceof SybaseDatabase);
    }

    @Override
    public ValidationErrors validate(CreateDatabaseChangeLogTableStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        return new ValidationErrors();
    }

    @Override
    public Sql[] generateSql(CreateDatabaseChangeLogTableStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        if (database instanceof InformixDatabase) {
            return new CreateDatabaseChangeLogTableGeneratorInformix().generateSql(statement, database, sqlGeneratorChain);
        }
        CreateTableStatement createTableStatement = new CreateTableStatement(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName(), database.getDatabaseChangeLogTableName()).setTablespace(database.getLiquibaseTablespaceName()).addPrimaryKeyColumn("ID", DataTypeFactory.getInstance().fromDescription("VARCHAR(" + this.getIdColumnSize() + ")"), null, null, null, new NotNullConstraint()).addPrimaryKeyColumn("AUTHOR", DataTypeFactory.getInstance().fromDescription("VARCHAR(" + this.getAuthorColumnSize() + ")"), null, null, null, new NotNullConstraint()).addPrimaryKeyColumn("FILENAME", DataTypeFactory.getInstance().fromDescription("VARCHAR(" + this.getFilenameColumnSize() + ")"), null, null, null, new NotNullConstraint()).addColumn("DATEEXECUTED", DataTypeFactory.getInstance().fromDescription("datetime"), null, new NotNullConstraint()).addColumn("ORDEREXECUTED", DataTypeFactory.getInstance().fromDescription("INT"), (Object)new NotNullConstraint()).addColumn("EXECTYPE", DataTypeFactory.getInstance().fromDescription("VARCHAR(10)"), (Object)new NotNullConstraint()).addColumn("MD5SUM", DataTypeFactory.getInstance().fromDescription("VARCHAR(35)")).addColumn("DESCRIPTION", DataTypeFactory.getInstance().fromDescription("VARCHAR(255)")).addColumn("COMMENTS", DataTypeFactory.getInstance().fromDescription("VARCHAR(255)")).addColumn("TAG", DataTypeFactory.getInstance().fromDescription("VARCHAR(255)")).addColumn("LIQUIBASE", DataTypeFactory.getInstance().fromDescription("VARCHAR(20)"));
        return SqlGeneratorFactory.getInstance().generateSql(createTableStatement, database);
    }

    protected String getIdColumnSize() {
        return "63";
    }

    protected String getAuthorColumnSize() {
        return "63";
    }

    protected String getFilenameColumnSize() {
        return "200";
    }
}

