/*
 * Decompiled with CFR 0.152.
 */
package liquibase.structure;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDatabaseObject
implements DatabaseObject {
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private UUID snapshotId;

    @Override
    public String getObjectTypeName() {
        return StringUtils.lowerCaseFirst(this.getClass().getSimpleName());
    }

    @Override
    public UUID getSnapshotId() {
        return this.snapshotId;
    }

    @Override
    public void setSnapshotId(UUID snapshotId) {
        if (snapshotId == null) {
            throw new UnexpectedLiquibaseException("Must be a non null uuid");
        }
        if (this.snapshotId != null) {
            throw new UnexpectedLiquibaseException("snapshotId already set");
        }
        this.snapshotId = snapshotId;
    }

    @Override
    public boolean snapshotByDefault() {
        return true;
    }

    public int compareTo(Object o) {
        return this.getName().compareTo(((AbstractDatabaseObject)o).getName());
    }

    @Override
    public Set<String> getAttributes() {
        return this.attributes.keySet();
    }

    @Override
    public <T> T getAttribute(String attribute, Class<T> type) {
        return (T)this.attributes.get(attribute);
    }

    @Override
    public DatabaseObject setAttribute(String attribute, Object value) {
        if (value == null) {
            this.attributes.remove(attribute);
        } else {
            this.attributes.put(attribute, value);
        }
        return this;
    }
}

