var StylishReporter, chalk, err_sign, happy_sign, is_win, reporter, table, warn_sign;

chalk = require('chalk');

table = require('text-table');

is_win = process.platform === 'win32';

warn_sign = "" + (is_win ? '' : '⚠');

err_sign = "" + (is_win ? '' : '✖');

happy_sign = "" + (is_win ? '' : '✔');

reporter = function(filename, results) {
  var errs, ret, warns;
  if (filename == null) {
    filename = '';
  }
  if (results == null) {
    results = [];
  }
  errs = 0;
  warns = 0;
  ret = '';
  if (filename) {
    ret = '\n' + chalk.underline(filename) + '\n';
  }
  ret += table(results.map(function(result) {
    var context, level, lineNumber, message;
    level = result.level, lineNumber = result.lineNumber, message = result.message, context = result.context;
    if (level === 'error') {
      errs++;
    }
    if (level === 'warn') {
      warns++;
    }
    return ['', chalk.gray(level === 'error' ? err_sign : warn_sign), chalk.gray('line ' + lineNumber), chalk.blue(message), chalk.gray(context || '')];
  }));
  ret += '\n\n';
  if (warns > 0) {
    ret += chalk.yellow("" + warn_sign + " " + warns + " warning" + (warns === 1 ? '' : 's'));
    if (errs > 0) {
      ret += '\n';
    }
  }
  if (errs > 0) {
    ret += chalk.red("" + err_sign + " " + errs + " error" + (errs === 1 ? '' : 's'));
  }
  if (errs === 0 && warns === 0) {
    ret += chalk.green("" + happy_sign + " No problems");
    ret = '\n' + ret.trim();
  }
  return console.log(ret + '\n');
};

module.exports = StylishReporter = (function() {
  StylishReporter.reporter = reporter;

  function StylishReporter(error_report) {
    this.error_report = error_report;
  }

  StylishReporter.prototype.publish = function() {
    var filename, results, _ref, _results;
    _ref = this.error_report.paths;
    _results = [];
    for (filename in _ref) {
      results = _ref[filename];
      _results.push(StylishReporter.reporter(filename, results));
    }
    return _results;
  };

  return StylishReporter;

})();
