'use strict';


var Type = require('../type');


var _hasOwnProperty = Object.prototype.hasOwnProperty;


function resolveYamlSet(state) {
  var key, object = state.result;

  for (key in object) {
    if (_hasOwnProperty.call(object, key)) {
      if (null !== object[key]) {
        return false;
      }
    }
  }

  return true;
}


module.exports = new Type('tag:yaml.org,2002:set', {
  loadKind: 'mapping',
  loadResolver: resolveYamlSet
});
