var Stream = require('stream');

module.exports = function () {
    var out = new Stream;
    out.writable = true;
    var buffered = '';
    
    out.write = function (buf) {
        var s = buffered + String(buf);
        var lines = s.split('\n');
        for (var i = 0; i < lines.length - 1; i++) {
            console.log(lines[i]);
        }
        buffered = lines[i];
    };
    
    out.destroy = function () {
        out.writable = false;
        out.emit('close');
    };
    
    out.end = function (msg) {
        if (msg !== undefined) out.write(msg);
        if (buffered) console.log(buffered);
        out.writable = false;
        out.emit('close');
    };
    
    return out;
};
