(function() {
  var Reporter,
    __slice = [].slice;

  module.exports = Reporter = (function() {
    function Reporter(errorReport, options) {
      var colorize;
      this.errorReport = errorReport;
      if (options == null) {
        options = {};
      }
      colorize = options.colorize, this.quiet = options.quiet;
      if (colorize == null) {
        colorize = true;
      }
      this.colorize = colorize && process.stdout.isTTY;
      this.ok = '✓';
      this.warn = '⚡';
      this.err = '✗';
    }

    Reporter.prototype.stylize = function() {
      var map, message, styles;
      message = arguments[0], styles = 2 <= arguments.length ? __slice.call(arguments, 1) : [];
      if (!this.colorize) {
        return message;
      }
      map = {
        bold: [1, 22],
        yellow: [33, 39],
        green: [32, 39],
        red: [31, 39]
      };
      return styles.reduce(function(m, s) {
        return "\u001b[" + map[s][0] + "m" + m + "\u001b[" + map[s][1] + "m";
      }, message);
    };

    Reporter.prototype.publish = function() {
      var errors, path, paths, report;
      paths = this.errorReport.paths;
      report = "";
      for (path in paths) {
        errors = paths[path];
        report += this.reportPath(path, errors);
      }
      report += this.reportSummary(this.errorReport.getSummary());
      report += "";
      if (!this.quiet || this.errorReport.hasError()) {
        this.print(report);
      }
      return this;
    };

    Reporter.prototype.reportSummary = function(s) {
      var e, err, file, msg, p, start, w, warn;
      start = s.errorCount > 0 ? "" + this.err + " " + (this.stylize("Lint!", 'red', 'bold')) : s.warningCount > 0 ? "" + this.warn + " " + (this.stylize("Warning!", 'yellow', 'bold')) : "" + this.ok + " " + (this.stylize("Ok!", 'green', 'bold'));
      e = s.errorCount;
      w = s.warningCount;
      p = s.pathCount;
      err = this.plural('error', e);
      warn = this.plural('warning', w);
      file = this.plural('file', p);
      msg = "" + start + " » " + e + " " + err + " and " + w + " " + warn + " in " + p + " " + file;
      return "\n" + this.stylize(msg) + "\n";
    };

    Reporter.prototype.reportPath = function(path, errors) {
      var color, e, hasError, hasWarning, lineEnd, o, output, overall, pathReport, _i, _len, _ref;
      _ref = (hasError = this.errorReport.pathHasError(path)) ? [this.err, 'red'] : (hasWarning = this.errorReport.pathHasWarning(path)) ? [this.warn, 'yellow'] : [this.ok, 'green'], overall = _ref[0], color = _ref[1];
      pathReport = "";
      if (!this.quiet || hasError) {
        pathReport += "  " + overall + " " + (this.stylize(path, color, 'bold')) + "\n";
      }
      for (_i = 0, _len = errors.length; _i < _len; _i++) {
        e = errors[_i];
        if (this.quiet && e.level !== 'error') {
          continue;
        }
        o = e.level === 'error' ? this.err : this.warn;
        lineEnd = "";
        if (e.lineNumberEnd != null) {
          lineEnd = "-" + e.lineNumberEnd;
        }
        output = "#" + e.lineNumber + lineEnd;
        pathReport += "     " + ("" + o + " " + (this.stylize(output, color)) + ": " + e.message + ".");
        if (e.context) {
          pathReport += " " + e.context + ".";
        }
        pathReport += "\n";
      }
      return pathReport;
    };

    Reporter.prototype.print = function(message) {
      return console.log(message);
    };

    Reporter.prototype.plural = function(str, count) {
      if (count === 1) {
        return str;
      } else {
        return "" + str + "s";
      }
    };

    return Reporter;

  })();

}).call(this);
