# List2d
# author: Ondrej Sika, http://ondrejsika.com

def list2d(x, y, default=None):
    return [[default for xxx in range(x)] for xxx in range(y)]

class List2d:
    def __init__(self, *args):
        if len(args) == 1:
            self.load(*args)
        else:
            self.create(*args)

    def load(self, data):
        self.data = data

    def create(self, x, y, default=None):
        self.data = list2d(x, y, default)
    
    def list(self):
        return self.data

    def row(self, n):
        return self.data[n]

    def col(self, n):
        return [x[n] for x in self.data]

    def get(self, x, y):
        return self.data[x][y]

    def set(self, x, y, val):
        self.data[x][y] = val

    def reverse(self):
        data = list2d(len(self.data[0]), len(self.data))
        for y in range(len(self.data)):
            for x in range(len(self.data[0])):
                data[x][y] = self.data[y][x]
        self.data = data

    def duplicate(self):
        return List2d(self.data)

    def __unicode__(self):
        return u"<List2d %s>"%list(self.data)

    def __repr__(self):
        return self.__unicode__()

    def __str__(self):
        return self.__unicode__()
