import sys
import os
import random
import re
import copy
from operator import itemgetter
#----------------------------------------#
class test():
    def __init__(self):
        self.readme = {}
        self.readme['random_LSD_Generator'] = '''
            random_LSD_Generator(SI,EI,SL)
            (SI,EI)   is the range of keys
            SL is the values list to select 
            >>> import list_Style_Dict as lsd
            te = lsd.test()
            LSD = te.random_LSD_Generator(1,101,[1000,2000,3000,4000,5000])
            >>> LSD
            {1: 4000, 2: 3000, 3: 1000, 4: 1000, 5: 1000, 6: 4000, 7: 1000, 8: 2000, 9: 3000, 10: 5000, 11: 1000, 12: 2000, 13: 3000, 14: 4000, 15: 2000, 16: 4000, 17: 3000, 18: 3000, 19: 2000, 20: 1000, 21: 2000, 22: 4000, 23: 4000, 24: 5000, 25: 5000, 26: 1000, 27: 5000, 28: 2000, 29: 4000, 30: 5000, 31: 5000, 32: 1000, 33: 2000, 34: 4000, 35: 4000, 36: 2000, 37: 2000, 38: 4000, 39: 5000, 40: 4000, 41: 5000, 42: 4000, 43: 5000, 44: 5000, 45: 5000, 46: 3000, 47: 1000, 48: 3000, 49: 1000, 50: 2000, 51: 3000, 52: 5000, 53: 4000, 54: 3000, 55: 3000, 56: 4000, 57: 1000, 58: 2000, 59: 1000, 60: 3000, 61: 3000, 62: 5000, 63: 4000, 64: 2000, 65: 5000, 66: 4000, 67: 5000, 68: 4000, 69: 3000, 70: 2000, 71: 2000, 72: 3000, 73: 3000, 74: 4000, 75: 1000, 76: 5000, 77: 4000, 78: 1000, 79: 5000, 80: 4000, 81: 1000, 82: 5000, 83: 3000, 84: 3000, 85: 5000, 86: 1000, 87: 3000, 88: 5000, 89: 3000, 90: 5000, 91: 1000, 92: 5000, 93: 3000, 94: 3000, 95: 4000, 96: 4000, 97: 3000, 98: 5000, 99: 1000, 100: 4000, 101: 4000}
            >>> 
            '''
        self.readme['random_Numindex_Dict_Generator'] = '''
            random_Numindex_Dict_Generator(SI,EI,SL,size)
            (SI,EI)   is the range to select a key
            size    si the len of the dict 
            SL is the values list to select 
            >>> import list_Style_Dict as lsd
            te = lsd.test()
            NiD = te.random_Numindex_Dict_Generator(30,80,[1000,2000,3000,4000,5000],12)
            >>> NiD
            {64: 5000, 65: 3000, 67: 1000, 68: 4000, 37: 1000, 40: 5000, 48: 2000, 52: 4000, 53: 2000, 55: 2000, 60: 1000, 62: 3000}
            >>> 
            '''
        self.readme['random_List_Generator'] = '''
            random_List_Generator(size,SL)
            size    si the len of the list 
            SL is the values list to select 
            >>> import list_Style_Dict as lsd
            te = lsd.test()
            L = te.random_List_Generator(20,[1000,2000,3000,4000,5000])
            >>> L
            [3000, 4000, 3000, 4000, 4000, 5000, 4000, 3000, 1000, 4000, 1000, 2000, 2000, 1000, 4000, 1000, 5000, 1000, 1000, 1000]
            >>> 
            '''
        self.readme['random_Tuple_Generator'] = '''
            random_Tuple_Generator(size,SL)
            size    si the len of the tuple 
            SL is the values list to select 
            >>> import list_Style_Dict as lsd
            te = lsd.test()
            T = te.random_Tuple_Generator(20,[1000,2000,3000,4000,5000])
            >>> T
            (4000, 3000, 4000, 1000, 5000, 1000, 4000, 1000, 4000, 1000, 3000, 1000, 1000, 3000, 4000, 1000, 1000, 4000, 5000, 2000)
            >>> 
            '''
        self.readme['random_LSD_tuple_List_Generator'] = '''
            random_LSD_tuple_List_Generator(SI,EI,SL)
            (SI,EI)   is the range of a tuple list elements [0]
            SL is the values list to select a tuple list element [1]
            >>> import list_Style_Dict as lsd
            te = lsd.test()
            >>> LSD_TL = te.random_LSD_tuple_List_Generator(0,20,[1000,2000,3000,4000,5000])
            >>> LSD_TL
            [(0, 3000), (1, 4000), (2, 5000), (3, 1000), (4, 4000), (5, 5000), (6, 3000), (7, 3000), (8, 1000), (9, 1000), (10, 4000), (11, 5000), (12, 5000), (13, 2000), (14, 2000), (15, 3000), (16, 1000), (17, 5000), (18, 4000), (19, 5000), (20, 1000)]
            >>> 
            >>> 
            '''
        self.readme['random_Tuple_List_Generator'] = '''
            random_Tuple_List_Generator(SI,EI,SL,size)
            (SI,EI)   is the range to select a tuple list element [0]
            size    si the len of the tuple list 
            SL is the values list to select a tuple list element [1]
            >>> import list_Style_Dict as lsd
            te = lsd.test()
            >>> TL = te.random_Tuple_List_Generator(30,80,[1000,2000,3000,4000,5000],12)
            >>> TL
            [(64, 3000), (36, 3000), (71, 2000), (72, 3000), (31, 2000), (76, 2000), (80, 5000), (49, 3000), (54, 4000), (59, 2000), (30, 1000), (63, 1000)]
            >>> 
            '''
    def __dir__(self):
        return(['random_List_Generator','random_LSD_tuple_List_Generator','random_LSD_Generator','random_Numindex_Dict_Generator','random_Tuple_Generator','random_Tuple_List_Generator'])
    def random_LSD_Generator(self,SI,EI,SL):
        LSD = {}
        for i in range(SI,EI+1):
            LSD[i] = random.choice(SL)
        return(LSD)
    def random_Numindex_Dict_Generator(self,SI,EI,SL,size):
        numindex_D = {}
        L = [i for i in range(SI,EI+1)]
        L_len = EI + 1 - SI
        if(L_len < size):
            print('(EI - SI +1)   must  >=  size')
            return(numindex_D)
        count = 0
        while(count < size):
            index = random.randrange(0,L_len)
            value = random.choice(SL)
            numindex_D[L[index]] = value
            L.pop(index)
            count = count + 1
            L_len = L.__len__()
        return(numindex_D)
    def random_List_Generator(self,size,SL):
        L = []
        for i in range(0,size):
            L.append(random.choice(SL))
        return(L)
    def random_Tuple_Generator(self,size,SL):
        return(tuple(self.random_List_Generator(size,SL)))
    def random_LSD_tuple_List_Generator(self,SI,EI,SL):
        LSD = self.random_LSD_Generator(SI,EI,SL)
        TL = []
        for each in LSD:
            TL.append((each,LSD[each]))
        return(TL)
    def random_Tuple_List_Generator(self,SI,EI,SL,size):
        numindex_D = self.random_Numindex_Dict_Generator(SI,EI,SL,size)
        TL = []
        for each in numindex_D:
            TL.append((each,numindex_D[each]))
        return(TL)

#----------------------------------------#
class funcs():
    def __init__(self):
        self.readme = {}
        self.readme['is_LSD'] = '''
            to judge id a dict is a LSD dict;
            if the dict is a LSD dict ,return the start index;
            else return None;
            
            >>> import list_Style_Dict as lsd
            >>> f = lsd.funcs()
            >>> D = {1:11,2:22,3:33}         
            >>> f.is_LSD(D)                
            1
            >>> D = {-1:11,0:22,1:33}
            >>> f.is_LSD(D)        
            -1
            >>> D = {0:11,1:22,5:33}
            >>> f.is_LSD(D)       
            >>> 
            '''
        self.readme['D_To_LSD'] = '''
            if a dict is a LSD , return a new dict which is a copy(but NOT deepcopy) of the original dict,
            the new dict whose start_Index equal the start_Index in paras if it is explicitly given,
            if the start_Index in paras is NOT explicitly given,the new dict whose start_Index equal the start_Index of the LSD;
            if a dict is NOT a LSD return None.
            D_To_LSD(D,start_Index=None)
            >>> import list_Style_Dict as lsd
            >>> f = lsd.funcs()
            >>> D = {1:11,2:22,3:33}
            >>> new_D = f.D_To_LSD(D)
            >>> new_D
            {1: 11, 2: 22, 3: 33}
            >>> new_D = f.D_To_LSD(D,5)
            >>> new_D
            {5: 11, 6: 22, 7: 33}
            >>> D
            {1: 11, 2: 22, 3: 33}
            >>> D = {1:11,2:22,8:33}   
            >>> new_D = f.D_To_LSD(D,5)
            >>> new_D
            >>> 
            '''
        self.readme['LT_To_LSD'] = '''
            convert a list or a tuple to a LSD,
            if the start_Index in paras is explicitly given,the new dict whose start_Index equals the start_Index in paras
            if the start_Index in paras is NOT explicitly given, the new dict whose start_Index equals 0;
            >>> import list_Style_Dict as lsd
            >>> f = lsd.funcs()    
            >>> L = [1,2,3]                  
            >>> new_D = f.D_To_LSD(L,5)
            >>> new_D
            {5: 1, 6: 2, 7: 3}
            >>> T = (44,55,66)
            >>> new_D = f.LT_To_LSD(T)  
            >>> new_D
            {0: 44, 1: 55, 2: 66}
            >>> 
            '''
        self.readme['LSD_To_L'] = '''
            LSD_To_L(LSD)
            >>> import list_Style_Dict as lsd
            >>> te = lsd.test()
            >>> LSD = te.random_LSD_Generator(0,99,[1000,2000,3000,4000,5000])
            >>> LSD
            {0: 1000, 1: 5000, 2: 1000, 3: 3000, 4: 4000, 5: 5000, 6: 4000, 7: 5000, 8: 1000, 9: 5000, 10: 4000, 11: 3000, 12: 4000, 13: 1000, 14: 1000, 15: 1000, 16: 4000, 17: 3000, 18: 4000, 19: 1000, 20: 3000, 21: 5000, 22: 5000, 23: 5000, 24: 5000, 25: 5000, 26: 3000, 27: 4000, 28: 5000, 29: 4000, 30: 3000, 31: 2000, 32: 1000, 33: 3000, 34: 2000, 35: 2000, 36: 3000, 37: 2000, 38: 2000, 39: 2000, 40: 4000, 41: 3000, 42: 1000, 43: 1000, 44: 5000, 45: 3000, 46: 3000, 47: 2000, 48: 2000, 49: 2000, 50: 2000, 51: 4000, 52: 1000, 53: 5000, 54: 1000, 55: 2000, 56: 2000, 57: 4000, 58: 4000, 59: 1000, 60: 3000, 61: 3000, 62: 1000, 63: 4000, 64: 1000, 65: 1000, 66: 2000, 67: 2000, 68: 5000, 69: 2000, 70: 3000, 71: 5000, 72: 5000, 73: 1000, 74: 3000, 75: 2000, 76: 3000, 77: 1000, 78: 5000, 79: 4000, 80: 1000, 81: 3000, 82: 4000, 83: 3000, 84: 4000, 85: 2000, 86: 2000, 87: 3000, 88: 4000, 89: 3000, 90: 4000, 91: 5000, 92: 1000, 93: 5000, 94: 2000, 95: 5000, 96: 5000, 97: 4000, 98: 5000, 99: 1000}
            >>> f.LSD_To_L(LSD)
            [1000, 5000, 1000, 3000, 4000, 5000, 4000, 5000, 1000, 5000, 4000, 3000, 4000, 1000, 1000, 1000, 4000, 3000, 4000, 1000, 3000, 5000, 5000, 5000, 5000, 5000, 3000, 4000, 5000, 4000, 3000, 2000, 1000, 3000, 2000, 2000, 3000, 2000, 2000, 2000, 4000, 3000, 1000, 1000, 5000, 3000, 3000, 2000, 2000, 2000, 2000, 4000, 1000, 5000, 1000, 2000, 2000, 4000, 4000, 1000, 3000, 3000, 1000, 4000, 1000, 1000, 2000, 2000, 5000, 2000, 3000, 5000, 5000, 1000, 3000, 2000, 3000, 1000, 5000, 4000, 1000, 3000, 4000, 3000, 4000, 2000, 2000, 3000, 4000, 3000, 4000, 5000, 1000, 5000, 2000, 5000, 5000, 4000, 5000, 1000]
            >>> 
            '''
        self.readme['LSD_To_T'] = '''
            LSD_To_T(LSD)
            >>> import list_Style_Dict as lsd
            >>> te = lsd.test()
            >>> LSD = te.random_LSD_Generator(0,99,[1000,2000,3000,4000,5000])
            >>> LSD
            {0: 1000, 1: 5000, 2: 1000, 3: 3000, 4: 4000, 5: 5000, 6: 4000, 7: 5000, 8: 1000, 9: 5000, 10: 4000, 11: 3000, 12: 4000, 13: 1000, 14: 1000, 15: 1000, 16: 4000, 17: 3000, 18: 4000, 19: 1000, 20: 3000, 21: 5000, 22: 5000, 23: 5000, 24: 5000, 25: 5000, 26: 3000, 27: 4000, 28: 5000, 29: 4000, 30: 3000, 31: 2000, 32: 1000, 33: 3000, 34: 2000, 35: 2000, 36: 3000, 37: 2000, 38: 2000, 39: 2000, 40: 4000, 41: 3000, 42: 1000, 43: 1000, 44: 5000, 45: 3000, 46: 3000, 47: 2000, 48: 2000, 49: 2000, 50: 2000, 51: 4000, 52: 1000, 53: 5000, 54: 1000, 55: 2000, 56: 2000, 57: 4000, 58: 4000, 59: 1000, 60: 3000, 61: 3000, 62: 1000, 63: 4000, 64: 1000, 65: 1000, 66: 2000, 67: 2000, 68: 5000, 69: 2000, 70: 3000, 71: 5000, 72: 5000, 73: 1000, 74: 3000, 75: 2000, 76: 3000, 77: 1000, 78: 5000, 79: 4000, 80: 1000, 81: 3000, 82: 4000, 83: 3000, 84: 4000, 85: 2000, 86: 2000, 87: 3000, 88: 4000, 89: 3000, 90: 4000, 91: 5000, 92: 1000, 93: 5000, 94: 2000, 95: 5000, 96: 5000, 97: 4000, 98: 5000, 99: 1000}
            >>> f.LSD_To_T(LSD)
            (1000, 5000, 1000, 3000, 4000, 5000, 4000, 5000, 1000, 5000, 4000, 3000, 4000, 1000, 1000, 1000, 4000, 3000, 4000, 1000, 3000, 5000, 5000, 5000, 5000, 5000, 3000, 4000, 5000, 4000, 3000, 2000, 1000, 3000, 2000, 2000, 3000, 2000, 2000, 2000, 4000, 3000, 1000, 1000, 5000, 3000, 3000, 2000, 2000, 2000, 2000, 4000, 1000, 5000, 1000, 2000, 2000, 4000, 4000, 1000, 3000, 3000, 1000, 4000, 1000, 1000, 2000, 2000, 5000, 2000, 3000, 5000, 5000, 1000, 3000, 2000, 3000, 1000, 5000, 4000, 1000, 3000, 4000, 3000, 4000, 2000, 2000, 3000, 4000, 3000, 4000, 5000, 1000, 5000, 2000, 5000, 5000, 4000, 5000, 1000)
            >>> 
            '''
        self.readme['LSD_To_Tuple_List'] = '''
            LSD_To_Tuple_List(LSD)
            >>> import list_Style_Dict as lsd
            >>> f=lsd.funcs()
            >>> D = {4:'a',5:'g',6:'x',7:'@'}
            >>> TL = f.LSD_To_Tuple_List(D)
            >>> TL
            [(4, 'a'), (5, 'g'), (6, 'x'), (7, '@')]
            >>> 
            '''
        self.readme['LSD_From_Tuple_List'] = '''
            >>> import list_Style_Dict as lsd
            >>> f=lsd.funcs()
            >>> TL=[(4, 'a'), (5, 'g'), (6, 'x'), (7, '@')]
            >>> LSD = f.LSD_From_Tuple_List(TL)
            >>> LSD
            {4: 'a', 5: 'g', 6: 'x', 7: '@'}
            >>> 
            '''
        self.readme['get_All_Continuous_Slices_Via_Value'] = '''
            get_All_Continuous_Slices_Via_Value(LSD,value)
            >>> import list_Style_Dict as lsd
            LSD = { 1:100,2:22,3:100,4:100,5:55,6:66,7:77,8:100,9:100,10:100}
            f = lsd.funcs()
            f.get_All_Continuous_Slices_Via_Value(LSD,100)
            >>> LSD = { 1:100,2:22,3:100,4:100,5:55,6:66,7:77,8:100,9:100,10:100}
            >>> f = lsd.funcs()
            >>> f.get_All_Continuous_Slices_Via_Value(LSD,100)
            {1: {1: 1}, 2: {1: 3, 2: 4}, 3: {1: 8, 2: 9, 3: 10}}
            >>> 
            '''
        self.readme['get_First_Continuous_Slices_Via_Value'] = '''
            get_First_Continuous_Slices_Via_Value(LSD,value)
            >>> import list_Style_Dict as lsd
            LSD = { 1:100,2:22,3:100,4:100,5:55,6:66,7:77,8:100,9:100,10:100}
            f = lsd.funcs()
            f.get_First_Continuous_Slices_Via_Value(LSD,100)
            >>> LSD = { 1:100,2:22,3:100,4:100,5:55,6:66,7:77,8:100,9:100,10:100}
            >>> f = lsd.funcs()
            >>> f.get_First_Continuous_Slices_Via_Value(LSD,100)
            {1: {1: 1}}
            >>> 
            '''
        self.readme['get_Last_Continuous_Slices_Via_Value'] = '''
            get_Last_Continuous_Slices_Via_Value(LSD,value)
            >>> import list_Style_Dict as lsd
            LSD = { 1:100,2:22,3:100,4:100,5:55,6:66,7:77,8:100,9:100,10:100}
            f = lsd.funcs()
            f.get_Last_Continuous_Slices_Via_Value(LSD,100)
            >>> LSD = { 1:100,2:22,3:100,4:100,5:55,6:66,7:77,8:100,9:100,10:100}
            >>> f = lsd.funcs()
            >>> f.get_Last_Continuous_Slices_Via_Value(LSD,100)
            {1: 8, 2: 9, 3: 10}
            >>> 
            '''
        self.readme['concat_LSD'] = '''
            >>> import list_Style_Dict as lsd
            >>> te = lsd.test()
            >>> LSD1 = te.random_LSD_Generator(0,20,[1000,2000,3000,4000,5000])
            >>> LSD2 = te.random_LSD_Generator(10,30,[1000,2000,3000,4000,5000]) 
            >>> LSD1
            {0: 4000, 1: 2000, 2: 3000, 3: 2000, 4: 4000, 5: 2000, 6: 2000, 7: 4000, 8: 3000, 9: 1000, 10: 3000, 11: 5000, 12: 1000, 13: 1000, 14: 4000, 15: 5000, 16: 5000, 17: 1000, 18: 5000, 19: 1000, 20: 3000}
            >>> LSD2
            {10: 1000, 11: 4000, 12: 3000, 13: 4000, 14: 5000, 15: 4000, 16: 4000, 17: 1000, 18: 2000, 19: 4000, 20: 5000, 21: 4000, 22: 2000, 23: 4000, 24: 4000, 25: 5000, 26: 5000, 27: 2000, 28: 2000, 29: 5000, 30: 5000}
            >>> f.concat_LSD(LSD1,LSD2)
            {0: 4000, 1: 2000, 2: 3000, 3: 2000, 4: 4000, 5: 2000, 6: 2000, 7: 4000, 8: 3000, 9: 1000, 10: 3000, 11: 5000, 12: 1000, 13: 1000, 14: 4000, 15: 5000, 16: 5000, 17: 1000, 18: 5000, 19: 1000, 20: 3000, 21: 1000, 22: 4000, 23: 3000, 24: 4000, 25: 5000, 26: 4000, 27: 4000, 28: 1000, 29: 2000, 30: 4000, 31: 5000, 32: 4000, 33: 2000, 34: 4000, 35: 4000, 36: 5000, 37: 5000, 38: 2000, 39: 2000, 40: 5000, 41: 5000}
            >>> f.concat_LSD(LSD2,LSD1)
            {10: 1000, 11: 4000, 12: 3000, 13: 4000, 14: 5000, 15: 4000, 16: 4000, 17: 1000, 18: 2000, 19: 4000, 20: 5000, 21: 4000, 22: 2000, 23: 4000, 24: 4000, 25: 5000, 26: 5000, 27: 2000, 28: 2000, 29: 5000, 30: 5000, 31: 4000, 32: 2000, 33: 3000, 34: 2000, 35: 4000, 36: 2000, 37: 2000, 38: 4000, 39: 3000, 40: 1000, 41: 3000, 42: 5000, 43: 1000, 44: 1000, 45: 4000, 46: 5000, 47: 5000, 48: 1000, 49: 5000, 50: 1000, 51: 3000}
            >>> LSD1
            {0: 4000, 1: 2000, 2: 3000, 3: 2000, 4: 4000, 5: 2000, 6: 2000, 7: 4000, 8: 3000, 9: 1000, 10: 3000, 11: 5000, 12: 1000, 13: 1000, 14: 4000, 15: 5000, 16: 5000, 17: 1000, 18: 5000, 19: 1000, 20: 3000}
            >>> LSD2
            {10: 1000, 11: 4000, 12: 3000, 13: 4000, 14: 5000, 15: 4000, 16: 4000, 17: 1000, 18: 2000, 19: 4000, 20: 5000, 21: 4000, 22: 2000, 23: 4000, 24: 4000, 25: 5000, 26: 5000, 27: 2000, 28: 2000, 29: 5000, 30: 5000}
            >>> 
            >>> D
            {32: 5000, 70: 1000, 40: 3000, 41: 1000, 42: 5000, 43: 3000, 46: 4000, 47: 4000, 80: 5000, 51: 4000, 78: 5000, 79: 2000}
            >>> 
            >>> f.concat_LSD(LSD1,D)
            >>> 
            >>> f.concat_LSD(D,LSD2) 
            >>> 
            >>> f.concat_LSD(LSD1,{})
            {0: 4000, 1: 2000, 2: 3000, 3: 2000, 4: 4000, 5: 2000, 6: 2000, 7: 4000, 8: 3000, 9: 1000, 10: 3000, 11: 5000, 12: 1000, 13: 1000, 14: 4000, 15: 5000, 16: 5000, 17: 1000, 18: 5000, 19: 1000, 20: 3000}
            >>> 
            >>> f.concat_LSD({},LSD2)
            {10: 1000, 11: 4000, 12: 3000, 13: 4000, 14: 5000, 15: 4000, 16: 4000, 17: 1000, 18: 2000, 19: 4000, 20: 5000, 21: 4000, 22: 2000, 23: 4000, 24: 4000, 25: 5000, 26: 5000, 27: 2000, 28: 2000, 29: 5000, 30: 5000}
            >>> 
            '''
    def __dir__(self):
        return(['concat_LSD','get_All_Continuous_Slices_Via_Value','get_First_Continuous_Slices_Via_Value','get_Last_Continuous_Slices_Via_Value','is_LSD','D_To_LSD','LSD_From_Tuple_List','LSD_To_L','LSD_To_T','LSD_To_Tuple_List','LT_To_LSD'])
    def is_LSD(self,D):
        index_Set = set({})
        if(D == {}):
            return(D)
        for each in D:
            if(type(each)==type(0)):
                index_Set.add(each)
            else:
                return(None)
        start_Index=min(index_Set)
        D_len = D.__len__()
        end_Boundary = start_Index + D_len        
        for i in range(start_Index,end_Boundary):
            if(i in D):
                pass
            else:
                return(None)
        return(start_Index)
    def D_To_LSD(self,D,start_Index=None):
        start_Index_D = self.is_LSD(D)
        if(start_Index==None):
            if(start_Index_D==None):
                return(None)
            else:
                return(D.copy())
        else:
            if(start_Index_D==None):
                return(None)
            else:
                LSD = {}
                D_len = D.__len__()
                end_Boundary_D = start_Index_D + D_len
                start_Index_Diff = start_Index - start_Index_D
                for i in range(start_Index_D,end_Boundary_D):
                    index_LSD = i + start_Index_Diff
                    LSD[index_LSD] = D[i] 
        return(LSD)
    def LT_To_LSD(self,LT,start_Index=0):
        LSD = {}
        LT_Len = LT.__len__()
        end_Boundary = start_Index + LT_Len
        for i in range(start_Index,end_Boundary):
            LSD[i] = LT[i - start_Index]
        return(LSD)
    def LSD_To_L(self,LSD):
        start_Index = self.is_LSD(LSD)
        L = []
        if(start_Index == None):
            return(None)
        else:
            LSD_len = LSD.__len__()
            end_Boundary = start_Index + LSD_len
            for i in range(start_Index,end_Boundary):
                L.append(LSD[i])
        return(L)
    def LSD_To_T(self,LSD):
        L = self.LSD_To_L(LSD)
        if(L == None):
            return(None)
        else:
            return(tuple(L))
    def LSD_To_Tuple_List(self,LSD):
        tl = []
        start_Index = self.is_LSD(LSD)
        if(start_Index == None):
            return(None)
        else:
            LSD_len = LSD.__len__()
            end_Boundary = start_Index + LSD_len
            for i in range(start_Index,end_Boundary):
                tl.append((i,LSD[i]))
        return(tl)
    def LSD_From_Tuple_List(self,TL):
        LSD = {}
        for each in TL:
            LSD[each[0]] = each[1]
        if(type(self.is_LSD(LSD)) == type(0)):
            return(LSD)
        else:
            return(None)
    def concat_LSD(self,LSD1,LSD2):
        start_Index_LSD1 = self.is_LSD(LSD1)
        start_Index_LSD2 = self.is_LSD(LSD2)
        if((LSD1 == {})&(LSD2 == {})):
            return({})
        elif(LSD1 == {}):
            if(not(start_Index_LSD2 == None)):
                return(LSD2.copy())
            else:
                return(None)
        elif(LSD2 == {}):
            if(not(start_Index_LSD1 == None)):
                return(LSD1.copy())
            else:
                return(None)
        elif((not(start_Index_LSD1 == None) )& (not(start_Index_LSD2 == None))):
            concated_LSD = LSD1.copy()
            LSD1_len = LSD1.__len__()
            LSD2_len = LSD2.__len__()
            old_End_Boundary = start_Index_LSD1 + LSD1_len 
            new_End_Boundary = old_End_Boundary + LSD2_len 
            index_Diff = old_End_Boundary - start_Index_LSD2
            for i in range(old_End_Boundary,new_End_Boundary):
                concated_LSD[i] = LSD2[i - index_Diff]
            return(concated_LSD)
        else:
            return(None)
    def get_First_Continuous_Slices_Via_Value(self,LSD,value):
        start_Index = self.is_LSD(LSD)
        if(start_Index == None):
            return({})
        else:
            LSD_len = LSD.__len__()
            end_Boundary = start_Index + LSD_len
            end_Index = end_Boundary - 1
            one_Slice = {}
            one_Slice_Seq = 1
            first = None
            for i in range(start_Index,end_Boundary):
                if(first == None):
                    if(LSD[i] == value):
                        first = "NOT"
                        one_Slice[one_Slice_Seq] = i
                        one_Slice_Seq = one_Slice_Seq + 1
                    else:
                        pass
                else:
                    if(LSD[i] == value):
                        one_Slice[one_Slice_Seq] = i
                        one_Slice_Seq = one_Slice_Seq + 1
                    else:
                        break
        return(one_Slice)
    def get_Last_Continuous_Slices_Via_Value(self,LSD,value):
        start_Index = self.is_LSD(LSD)
        if(start_Index == None):
            return({})
        else:
            LSD_len = LSD.__len__()
            end_Boundary = start_Index + LSD_len
            end_Index = end_Boundary - 1
            one_Slice = {}
            one_Slice_Seq = 1
            first = None
            for i in range(end_Index,start_Index-1,-1):
                if(first == None):
                    if(LSD[i] == value):
                        first = "NOT"
                        one_Slice[-one_Slice_Seq] = i
                        one_Slice_Seq = one_Slice_Seq + 1
                    else:
                        pass
                else:
                    if(LSD[i] == value):
                        one_Slice[-one_Slice_Seq] = i
                        one_Slice_Seq = one_Slice_Seq + 1
                    else:
                        break
        one_Slice_Len = one_Slice.__len__()
        for each in one_Slice:
            one_Slice[each+one_Slice_Len+1] = one_Slice[each]
            del one_Slice[each]
        return(one_Slice)
    def get_All_Continuous_Slices_Via_Value(self,LSD,value):
        start_Index = self.is_LSD(LSD)
        slices_Dict = {}
        slices_Dict_Seq = 1
        if(start_Index == None):
            return({})
        else:
            LSD_len = LSD.__len__()
            end_Boundary = start_Index + LSD_len
            end_Index = end_Boundary - 1
            one_Slice = {}
            one_Slice_Seq = 1
            first = None
            still_In_Sub = False
            for i in range(start_Index,end_Boundary):
                if(first == None):
                    if(LSD[i] == value):
                        first = "NOT"
                        one_Slice[one_Slice_Seq] = i
                        one_Slice_Seq = one_Slice_Seq + 1
                        still_In_Sub = True
                    else:
                        pass
                else:
                    if(still_In_Sub == True):
                        if(LSD[i] == value):
                            one_Slice[one_Slice_Seq] = i
                            one_Slice_Seq = one_Slice_Seq + 1
                        else:
                            slices_Dict[slices_Dict_Seq] = one_Slice
                            slices_Dict_Seq = slices_Dict_Seq + 1
                            one_Slice = {}
                            one_Slice_Seq = 1
                            still_In_Sub = False
                    else:
                        if(LSD[i] == value):
                            still_In_Sub = True
                            one_Slice[one_Slice_Seq] = i
                            one_Slice_Seq = one_Slice_Seq + 1
                        else:
                            pass
            if(one_Slice == {}):
                pass
            else:
                slices_Dict[slices_Dict_Seq] = one_Slice
        return(slices_Dict)

#----------------------------------------#
class listStyleDict(funcs):
    def __init__(self,start_Index=1,DLT=None):
        if(DLT==None):
            self.LSD = {}
        elif((type(DLT)==type([]))|(type(DLT)==type(()))):
            self.LSD = self.LT_To_LSD(DLT,start_Index)
            if(self.LSD==None):
                self.LSD = {}
        elif(type(DLT)==type({})):
            self.LSD = self.D_To_LSD(DLT,start_Index)
            if(self.LSD==None):
                self.LSD = {}
        else:
            self.LSD = {}
        self.start_Index = start_Index
        self.readme = {}
        self.readme['__init__'] = '''
            __init__(start_Index=1,DLT=None)
            start_Index is the first numeric index of the LSD
            DLT is a list  or a tuple  or a LSD dict
            self.LSD is a copy (but NOT deepcopy) of the DLT
            >>> import list_Style_Dict as lsd
            >>> LSD = lsd.listStyleDict()
            >>> LSD.LSD
            {}
            >>> LSD.start_Index
            1
            >>> LSD = lsd.listStyleDict(5)
            >>> LSD.LSD
            {}
            >>> LSD.start_Index           
            5
            >>> LSD = lsd.listStyleDict(0,['a','b','c'])
            >>> LSD.LSD
            {0: 'a', 1: 'b', 2: 'c'}
            >>> LSD.start_Index
            0
            >>> LSD = lsd.listStyleDict(1,['a','b','c'])
            >>> LSD.LSD
            {1: 'a', 2: 'b', 3: 'c'}
            >>> LSD.start_Index
            1
            >>> LSD = lsd.listStyleDict(-1,['a','b','c'])
            >>> LSD.LSD
            {0: 'b', 1: 'c', -1: 'a'}
            >>> LSD.start_Index
            -1
            >>> LSD = lsd.listStyleDict(10,('a','b','c'))
            >>> LSD.LSD
            {10: 'a', 11: 'b', 12: 'c'}
            >>> LSD.start_Index
            10
            >>> LSD = lsd.listStyleDict(10,())           
            >>> LSD.LSD
            {}
            >>> LSD.start_Index               
            10
            >>> LSD = lsd.listStyleDict(10,{1:11,2:22,3:33})
            >>> LSD.LSD
            {10: 11, 11: 22, 12: 33}
            >>> LSD.start_Index
            10
            >>> LSD = lsd.listStyleDict(10,{1:11,2:22,5:33})
            >>> LSD.LSD
            {}
            >>> LSD.start_Index
            10
            '''
        self.readme['__getitem__'] = '''
            >>> import list_Style_Dict as lsd
            >>> T
            (1000, 3000, 5000, 2000, 5000, 2000, 2000, 2000, 1000, 2000, 1000, 3000, 1000, 4000, 4000, 2000, 3000, 1000, 1000, 5000)
            >>> myLSD = lsd.listStyleDict(start_Index=0,DLT=T)
            >>> myLSD.LSD
            {0: 1000, 1: 3000, 2: 5000, 3: 2000, 4: 5000, 5: 2000, 6: 2000, 7: 2000, 8: 1000, 9: 2000, 10: 1000, 11: 3000, 12: 1000, 13: 4000, 14: 4000, 15: 2000, 16: 3000, 17: 1000, 18: 1000, 19: 5000}
            >>> myLSD.start_Index
            0
            >>> 
            >>> for i in range(myLSD.start_Index,myLSD.start_Index+myLSD.LSD.__len__()):
            ...     print(myLSD[i])
            1000
            3000
            5000
            2000
            5000
            2000
            2000
            2000
            1000
            2000
            1000
            3000
            1000
            4000
            4000
            2000
            3000
            1000
            1000
            5000
            >>> myLSD.LSD[2000]
            Traceback (most recent call last):
              File "<stdin>", line 1, in <module>
            KeyError: 2000
            '''
        self.readme['__setitem__'] = '''
            can only set the "exsits" elements
            >>> myLSD.LSD[0]
            1000
            >>> myLSD[0]=1111
            >>> myLSD[0]
            1111
            >>> myLSD.LSD
            {0: 1111, 1: 1000, 2: 1000, 3: 3000, 4: 4000, 5: 3000, 6: 2000, 7: 1000, 8: 5000, 9: 4000, 10: 2000, 11: 5000, 12: 5000, 13: 4000, 14: 3000, 15: 4000, 16: 1000, 17: 2000, 18: 4000, 19: 2000}
            >>> 
            >>> myLSD[20]=111111111
            >>> myLSD.LSD
            {0: 1111, 1: 1000, 2: 1000, 3: 3000, 4: 4000, 5: 3000, 6: 2000, 7: 1000, 8: 5000, 9: 4000, 10: 2000, 11: 5000, 12: 5000, 13: 4000, 14: 3000, 15: 4000, 16: 1000, 17: 2000, 18: 4000, 19: 2000}
            >>> myLSD.start_Index
            -1
            >>> 
            '''
        self.readme['__str__'] = '''
            >>> import list_Style_Dict as lsd
            >>> myLSD = lsd.listStyleDict(start_Index=0,DLT={0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000})
            >>> myLSD.LSD
            {0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000}
            >>> myLSD.start_Index
            0
            >>> print(myLSD)
            start_Index:0 {0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000}
            >>> 
            '''
        self.readme['__repr__'] = '''
            >>> import list_Style_Dict as lsd
            >>> myLSD = lsd.listStyleDict(start_Index=0,DLT={0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000})
            >>> myLSD.LSD
            {0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000}
            >>> myLSD.start_Index 
            0
            >>> myLSD
            {0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000}
            '''
        self.readme['prepend'] = '''
            >>> myLSD.LSD
            {0: 1111, 1: 1000, 2: 1000, 3: 3000, 4: 4000, 5: 3000, 6: 2000, 7: 1000, 8: 5000, 9: 4000, 10: 2000, 11: 5000, 12: 5000, 13: 4000, 14: 3000, 15: 4000, 16: 1000, 17: 2000, 18: 4000, 19: 2000}
            >>> 
            >>> myLSD.prepend(800)
            >>> myLSD.LSD
            {0: 1111, 1: 1000, 2: 1000, 3: 3000, 4: 4000, 5: 3000, 6: 2000, 7: 1000, 8: 5000, 9: 4000, 10: 2000, 11: 5000, 12: 5000, 13: 4000, 14: 3000, 15: 4000, 16: 1000, 17: 2000, 18: 4000, 19: 2000, -1: 800}
            >>> myLSD[-1]
            800
            >>>
            '''
        self.readme['prepend_LSD'] = '''
            >>> import list_Style_Dict as lsd
            >>> L = te.random_List_Generator(10,[1000,2000,3000,4000,5000])
            >>> L
            [5000, 1000, 4000, 5000, 2000, 1000, 3000, 3000, 5000, 5000]
            >>> myLSD = lsd.listStyleDict(start_Index=0,DLT=L)
            >>> myLSD.LSD
            {0: 5000, 1: 1000, 2: 4000, 3: 5000, 4: 2000, 5: 1000, 6: 3000, 7: 3000, 8: 5000, 9: 5000}
            >>> myLSD.start_Index
            0
            >>> 
            >>> te = lsd.test()
            >>> LSD = te.random_LSD_Generator(0,10,[1000,2000,3000,4000,5000])
            >>> LSD
            {0: 3000, 1: 5000, 2: 2000, 3: 1000, 4: 1000, 5: 4000, 6: 2000, 7: 4000, 8: 3000, 9: 3000, 10: 1000}
            >>> 
            >>> myLSD.prepend_LSD(LSD)
            >>> myLSD
            {0: 5000, 1: 1000, 2: 4000, 3: 5000, 4: 2000, 5: 1000, 6: 3000, 7: 3000, 8: 5000, 9: 5000, -1: 1000, -11: 3000, -10: 5000, -9: 2000, -8: 1000, -7: 1000, -6: 4000, -5: 2000, -4: 4000, -3: 3000, -2: 3000}
            >>> 
            '''
        self.readme['append'] = '''
            >>> myLSD.LSD
            {0: 1000, 1: 3000, 2: 1000, 3: 5000, 4: 3000, 5: 2000, 6: 4000, 7: 2000, 8: 5000, 9: 3000}
            >>> myLSD.append(88)
            >>> myLSD.LSD
            {0: 1000, 1: 3000, 2: 1000, 3: 5000, 4: 3000, 5: 2000, 6: 4000, 7: 2000, 8: 5000, 9: 3000, 10: 88}
            >>> myLSD.start_Index
            0
            >>> 
            '''
        self.readme['append_LSD'] = '''
            >>> myLSD.LSD
            {0: 5000, 1: 3000, 2: 2000, 3: 1000, 4: 1000, 5: 1000, 6: 2000, 7: 2000, 8: 5000, 9: 3000, -1: 2000, -11: 4000, -10: 4000, -9: 1000, -8: 3000, -7: 3000, -6: 4000, -5: 4000, -4: 3000, -3: 1000, -2: 5000}
            >>> te = lsd.test()
            >>> LSD = te.random_LSD_Generator(0,10,[1000,2000,3000,4000,5000])
            >>> LSD
            {0: 5000, 1: 4000, 2: 2000, 3: 5000, 4: 2000, 5: 4000, 6: 5000, 7: 4000, 8: 1000, 9: 1000, 10: 2000}
            >>> myLSD.append_LSD(LSD)
            >>> myLSD.LSD      
            {0: 5000, 1: 3000, 2: 2000, 3: 1000, 4: 1000, 5: 1000, 6: 2000, 7: 2000, 8: 5000, 9: 3000, 10: 5000, 11: 4000, 12: 2000, 13: 5000, 14: 2000, 15: 4000, 16: 5000, 17: 4000, 18: 1000, 19: 1000, 20: 2000, -2: 5000, -11: 4000, -10: 4000, -9: 1000, -8: 3000, -7: 3000, -6: 4000, -5: 4000, -4: 3000, -3: 1000, -1: 2000}
            >>> 
            '''
        self.readme['clear'] = '''
            >>> myLSD.LSD
            {0: 5000, 1: 3000, 2: 2000, 3: 1000, 4: 1000, 5: 1000, 6: 2000, 7: 2000, 8: 5000, 9: 3000, 10: 5000, 11: 4000, 12: 2000, 13: 5000, 14: 2000, 15: 4000, 16: 5000, 17: 4000, 18: 1000, 19: 1000, 20: 2000, -2: 5000, -11: 4000, -10: 4000, -9: 1000, -8: 3000, -7: 3000, -6: 4000, -5: 4000, -4: 3000, -3: 1000, -1: 2000}
            >>> myLSD.LSD.clear()
            >>> myLSD.LSD
            {}
            >>> myLSD.start_Index
            1
            '''
        self.readme['copy'] = '''
            >>> myLSD.LSD
            {0: 5000, 1: 3000, 2: 2000, 3: 1000, 4: 1000, 5: 1000, 6: 2000, 7: 2000, 8: 5000, 9: 3000, -2: 5000, -11: 4000, -10: 4000, -9: 1000, -8: 3000, -7: 3000, -6: 4000, -5: 4000, -4: 3000, -3: 1000, -1: 2000}
            >>> myLSD.copy()
            {0: 5000, 1: 3000, 2: 2000, 3: 1000, 4: 1000, 5: 1000, 6: 2000, 7: 2000, 8: 5000, 9: 3000, -1: 2000, -11: 4000, -10: 4000, -9: 1000, -8: 3000, -7: 3000, -6: 4000, -5: 4000, -4: 3000, -3: 1000, -2: 5000}
            '''
        self.readme['deepcopy'] = '''
            >>> myLSD.LSD   
            {0: 5000, 1: 3000, 2: 2000, 3: 1000, 4: 1000, 5: 1000, 6: 2000, 7: 2000, 8: 5000, 9: 3000, -2: 5000, -11: 4000, -10: 4000, -9: 1000, -8: 3000, -7: 3000, -6: 4000, -5: 4000, -4: 3000, -3: 1000, -1: 2000}
            >>> myLSD.deepcopy()
            {0: 5000, 1: 3000, 2: 2000, 3: 1000, 4: 1000, 5: 1000, 6: 2000, 7: 2000, 8: 5000, 9: 3000, -1: 2000, -11: 4000, -10: 4000, -9: 1000, -8: 3000, -7: 3000, -6: 4000, -5: 4000, -4: 3000, -3: 1000, -2: 5000}
            >>> 
            '''
        self.readme['insert'] = '''
            >>> myLSD.LSD      
            {0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000}
            >>> myLSD.start_Index 
            0
            >>> myLSD.insert(-2,-2)       
            >>> myLSD.LSD              
            {0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000}
            >>> myLSD.start_Index
            0
            >>> myLSD.insert(11,11)
            >>> myLSD.LSD          
            {0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000}
            >>> myLSD.start_Index  
            0
            >>> 
            >>> myLSD.insert(-1,-1)
            >>> myLSD.LSD          
            {0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000, -1: -1}
            >>> myLSD.start_Index  
            -1
            >>> myLSD.insert(10,10)
            >>> myLSD.LSD          
            {0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000, 10: 10, -1: -1}
            >>> myLSD.start_Index  
            -1
            >>> myLSD.insert(5,5555)
            >>> myLSD.LSD           
            {0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 5555, 6: 3000, 7: 1000, 8: 5000, 9: 5000, 10: 2000, 11: 10, -1: -1}
            >>> myLSD.start_Index   
            -1
            >>> myLSD.insert(13,13)  
            >>> myLSD.LSD          
            {0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 5555, 6: 3000, 7: 1000, 8: 5000, 9: 5000, 10: 2000, 11: 10, -1: -1}
            >>> myLSD.start_Index  
            -1
            >>> 
            '''
        self.readme['insert_LSD'] = '''
            >>> import list_Style_Dict as lsd
            >>> myLSD = lsd.listStyleDict()
            >>> 
            >>> LSD = {0: 3000, 1: 3000, 2: 1000, 3: 4000, 4: 5000, 5: 4000, 6: 1000, 7: 2000, 8: 3000, 9: 5000, 10: 2000}  
            >>> myLSD.LSD={0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000}  
            >>> myLSD.start_Index = 0
            >>> myLSD.insert_LSD(-12,LSD)
            >>> myLSD.LSD
            {0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000}
            >>> myLSD.start_Index
            0
            >>> 
            >>> LSD = {0: 3000, 1: 3000, 2: 1000, 3: 4000, 4: 5000, 5: 4000, 6: 1000, 7: 2000, 8: 3000, 9: 5000, 10: 2000}  
            >>> myLSD.LSD={0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000}  
            >>> myLSD.start_Index = 0
            >>> myLSD.insert_LSD(-11,LSD)
            >>> myLSD.LSD
            {0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000, -1: 2000, -11: 3000, -10: 3000, -9: 1000, -8: 4000, -7: 5000, -6: 4000, -5: 1000, -4: 2000, -3: 3000, -2: 5000}
            >>> myLSD.start_Index
            -11
            >>> 
            
            >>> LSD = {0: 3000, 1: 3000, 2: 1000, 3: 4000, 4: 5000, 5: 4000, 6: 1000, 7: 2000, 8: 3000, 9: 5000, 10: 2000}  
            >>> myLSD.LSD={0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000}  
            >>> myLSD.start_Index = 0
            >>> myLSD.insert_LSD(-5,LSD)
            >>> myLSD.LSD
            {0: 4000, 1: 1000, 2: 2000, 3: 3000, 4: 5000, 5: 2000, 6: 5000, 7: 4000, 8: 5000, 9: 4000, 10: 3000, 11: 3000, 12: 1000, 13: 5000, 14: 5000, 15: 2000, -2: 4000, -5: 3000, -4: 3000, -3: 1000, -1: 5000}
            >>> myLSD.start_Index
            -5
            >>> 
            
            >>> LSD = {0: 3000, 1: 3000, 2: 1000, 3: 4000, 4: 5000, 5: 4000, 6: 1000, 7: 2000, 8: 3000, 9: 5000, 10: 2000}  
            >>> myLSD.LSD={0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000}  
            >>> myLSD.start_Index = 0
            >>> myLSD.insert_LSD(0,LSD)
            >>> myLSD.LSD
            {0: 3000, 1: 3000, 2: 1000, 3: 4000, 4: 5000, 5: 4000, 6: 1000, 7: 2000, 8: 3000, 9: 5000, 10: 2000, 11: 5000, 12: 4000, 13: 5000, 14: 4000, 15: 3000, 16: 3000, 17: 1000, 18: 5000, 19: 5000, 20: 2000}
            >>> myLSD.start_Index
            0
            >>> 
            >>> LSD = {0: 3000, 1: 3000, 2: 1000, 3: 4000, 4: 5000, 5: 4000, 6: 1000, 7: 2000, 8: 3000, 9: 5000, 10: 2000}  
            >>> myLSD.LSD={0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000}  
            >>> myLSD.start_Index = 0
            >>> myLSD.insert_LSD(5,LSD)
            >>> myLSD.LSD
            {0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 3000, 7: 1000, 8: 4000, 9: 5000, 10: 4000, 11: 1000, 12: 2000, 13: 3000, 14: 5000, 15: 2000, 16: 3000, 17: 1000, 18: 5000, 19: 5000, 20: 2000}
            >>> myLSD.start_Index
            0
            >>> 
            >>> LSD = {0: 3000, 1: 3000, 2: 1000, 3: 4000, 4: 5000, 5: 4000, 6: 1000, 7: 2000, 8: 3000, 9: 5000, 10: 2000}  
            >>> myLSD.LSD={0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000}  
            >>> myLSD.start_Index = 0
            >>> myLSD.insert_LSD(9,LSD)
            >>> myLSD.LSD
            {0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 3000, 10: 3000, 11: 1000, 12: 4000, 13: 5000, 14: 4000, 15: 1000, 16: 2000, 17: 3000, 18: 5000, 19: 2000, 20: 2000}
            >>> myLSD.start_Index
            0
            >>> 
            >>> LSD = {0: 3000, 1: 3000, 2: 1000, 3: 4000, 4: 5000, 5: 4000, 6: 1000, 7: 2000, 8: 3000, 9: 5000, 10: 2000}  
            >>> myLSD.LSD={0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000}  
            >>> myLSD.start_Index = 0
            >>> myLSD.insert_LSD(10,LSD)
            >>> myLSD.LSD
            {0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000, 10: 3000, 11: 3000, 12: 1000, 13: 4000, 14: 5000, 15: 4000, 16: 1000, 17: 2000, 18: 3000, 19: 5000, 20: 2000}
            >>> myLSD.start_Index
            0
            >>> 
            >>> LSD = {0: 3000, 1: 3000, 2: 1000, 3: 4000, 4: 5000, 5: 4000, 6: 1000, 7: 2000, 8: 3000, 9: 5000, 10: 2000}  
            >>> myLSD.LSD={0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000}  
            >>> myLSD.start_Index = 0
            >>> myLSD.insert_LSD(11,LSD)
            >>> myLSD.LSD
            {0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000}
            >>> myLSD.start_Index
            0
            >>> 
            
            >>> myLSD = lsd.listStyleDict(start_Index=4,DLT={0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000})
            >>> LSD = {0: 3000, 1: 3000, 2: 1000, 3: 4000, 4: 5000, 5: 4000, 6: 1000, 7: 2000, 8: 3000, 9: 5000, 10: 2000}    
            >>> myLSD.LSD
            {4: 5000, 5: 4000, 6: 5000, 7: 4000, 8: 3000, 9: 3000, 10: 1000, 11: 5000, 12: 5000, 13: 2000}
            >>> myLSD.start_Index 
            4
            >>> myLSD.insert_LSD(11,LSD)
            >>> myLSD.LSD
            {4: 5000, 5: 4000, 6: 5000, 7: 4000, 8: 3000, 9: 3000, 10: 1000, 11: 3000, 12: 3000, 13: 1000, 14: 4000, 15: 5000, 16: 4000, 17: 1000, 18: 2000, 19: 3000, 20: 5000, 21: 2000, 22: 5000, 23: 5000, 24: 2000}
            >>> myLSD.start_Index
            4
            >>> 
            
            '''
        self.readme['count'] = '''
            >>> import list_Style_Dict as lsd
            >>> myLSD = lsd.listStyleDict(start_Index=4,DLT={0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000})
            >>> myLSD.LSD
            {4: 5000, 5: 4000, 6: 5000, 7: 4000, 8: 3000, 9: 3000, 10: 1000, 11: 5000, 12: 5000, 13: 2000}
            >>> myLSD.start_Index
            4
            >>> myLSD.count(5000)
            4
            >>> myLSD.count(4000)
            2
            >>> myLSD.count(3000)
            2
            >>> myLSD.count(1000)
            1
            >>> myLSD.count(2000)
            1
            >>> 
            '''
        self.readme['extend'] = '''
            >>> import list_Style_Dict as lsd
            >>> myLSD = lsd.listStyleDict(start_Index=4,DLT={0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000})
            >>> LSD = {0: 3000, 1: 3000, 2: 1000, 3: 4000, 4: 5000, 5: 4000, 6: 1000, 7: 2000, 8: 3000, 9: 5000, 10: 2000}    
            >>> myLSD.LSD
            {4: 5000, 5: 4000, 6: 5000, 7: 4000, 8: 3000, 9: 3000, 10: 1000, 11: 5000, 12: 5000, 13: 2000}
            >>> myLSD.start_Index 
            4
            >>> myLSD.extend(LSD)
            >>> myLSD.LSD
            {4: 5000, 5: 4000, 6: 5000, 7: 4000, 8: 3000, 9: 3000, 10: 1000, 11: 5000, 12: 5000, 13: 2000, 14: 3000, 15: 3000, 16: 1000, 17: 4000, 18: 5000, 19: 4000, 20: 1000, 21: 2000, 22: 3000, 23: 5000, 24: 2000}
            >>> myLSD.start_Index
            4
            >>> 
            '''
        self.readme['index'] = '''
            refer to myLSD.help('index.first')
                     myLSD.help('index.last')
                     myLSD.help('index.all')
            for details
            '''
        self.readme['index.first'] = '''
            >>> import list_Style_Dict as lsd
            >>> myLSD = lsd.listStyleDict(start_Index=4,DLT={0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000})
            >>> myLSD.LSD
            {4: 5000, 5: 4000, 6: 5000, 7: 4000, 8: 3000, 9: 3000, 10: 1000, 11: 5000, 12: 5000, 13: 2000}
            >>> myLSD.start_Index 
            4
            >>> myLSD.index.first(5000)
            4
            >>> myLSD.index.first(4000)
            5
            >>> myLSD.index.first(3000)
            8
            >>> myLSD.index.first(2000)
            13
            >>> myLSD.index.first(1000)
            10
            >>> 
            '''
        self.readme['index.last'] = '''
            >>> import list_Style_Dict as lsd
            >>> myLSD = lsd.listStyleDict(start_Index=4,DLT={0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000})
            >>> myLSD.LSD
            {4: 5000, 5: 4000, 6: 5000, 7: 4000, 8: 3000, 9: 3000, 10: 1000, 11: 5000, 12: 5000, 13: 2000}
            >>> myLSD.start_Index 
            4
            >>> myLSD.index.last(5000)
            12
            >>> myLSD.index.last(4000)
            7
            >>> myLSD.index.last(3000)
            9
            >>> myLSD.index.last(2000)
            13
            >>> myLSD.index.last(1000)
            10
            >>> 
            '''
        self.readme['index.all'] = '''
            >>> import list_Style_Dict as lsd
            >>> myLSD = lsd.listStyleDict(start_Index=4,DLT={0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000})
            >>> myLSD.LSD
            {4: 5000, 5: 4000, 6: 5000, 7: 4000, 8: 3000, 9: 3000, 10: 1000, 11: 5000, 12: 5000, 13: 2000}
            >>> myLSD.start_Index 
            4
            >>> myLSD.index.all(5000)
            {1: 4, 2: 6, 3: 11, 4: 12}
            >>> myLSD.index.all(4000)
            {1: 5, 2: 7}
            >>> myLSD.index.all(3000)
            {1: 8, 2: 9}
            >>> myLSD.index.all(2000)
            {1: 13}
            >>> myLSD.index.all(1000)
            {1: 10}
            >>> 
            '''
        self.readme['pop'] = '''
            refer to myLSD.help('pop.default')
                     myLSD.help('pop.index')
                     myLSD.help('pop.indexrange')
                     myLSD.help('pop.value')
            for details
            '''
        self.readme['pop.default'] = '''
            >>> 
            >>> import list_Style_Dict as lsd
            >>> myLSD = lsd.listStyleDict(start_Index=4,DLT={0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000})
            >>> myLSD.LSD
            {4: 5000, 5: 4000, 6: 5000, 7: 4000, 8: 3000, 9: 3000, 10: 1000, 11: 5000, 12: 5000, 13: 2000}
            >>> myLSD.start_Index 
            4
            >>> myLSD.pop.default(6)
            5000
            >>> myLSD.LSD
            {4: 5000, 5: 4000, 6: 4000, 7: 3000, 8: 3000, 9: 1000, 10: 5000, 11: 5000, 12: 2000}
            >>> myLSD.start_Index
            4
            >>> 
            '''
        self.readme['pop.index'] = '''
            >>> 
            >>> import list_Style_Dict as lsd
            >>> myLSD = lsd.listStyleDict(start_Index=4,DLT={0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000})
            >>> myLSD.LSD
            {4: 5000, 5: 4000, 6: 5000, 7: 4000, 8: 3000, 9: 3000, 10: 1000, 11: 5000, 12: 5000, 13: 2000}
            >>> myLSD.start_Index 
            4
            >>> myLSD.pop.index(6)
            5000
            >>> myLSD.LSD
            {4: 5000, 5: 4000, 6: 4000, 7: 3000, 8: 3000, 9: 1000, 10: 5000, 11: 5000, 12: 2000}
            >>> myLSD.start_Index
            4
            >>> 
            '''
        self.readme['pop.indexrange'] = '''
            >>> 
            >>> import list_Style_Dict as lsd
            >>> myLSD = lsd.listStyleDict(start_Index=0,DLT={0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000})
            >>> myLSD.LSD
            {0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000}
            >>> myLSD.start_Index 
            0
            >>> myLSD.pop.indexrange(5,8)
            {1: 3000, 2: 1000, 3: 5000, 4: 5000}
            >>> myLSD.LSD
            {0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 2000}
            >>> myLSD.start_Index
            0
            >>> 
            '''
        self.readme['pop.value'] = '''
            refer to myLSD.help('pop.value.first')
                     myLSD.help('pop.value.last')
                     myLSD.help('pop.value.all')
            for details
            '''
        self.readme['pop.value.first'] = '''
            >>> import list_Style_Dict as lsd
            >>> myLSD = lsd.listStyleDict(start_Index=0,DLT={0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000})
            >>> myLSD.LSD
            {0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000}
            >>> myLSD.start_Index 
            0
            >>> myLSD.pop.value.first(4000)
            4000
            >>> myLSD.LSD
            {0: 5000, 1: 5000, 2: 4000, 3: 3000, 4: 3000, 5: 1000, 6: 5000, 7: 5000, 8: 2000}
            >>> myLSD.start_Index
            0
            >>> 
            '''
        self.readme['pop.value.last'] = '''
            >>> import list_Style_Dict as lsd
            >>> myLSD = lsd.listStyleDict(start_Index=0,DLT={0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000})
            >>> myLSD.LSD
            {0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000}
            >>> myLSD.start_Index 
            0
            >>> myLSD.pop.value.last(5000)
            5000
            >>> myLSD.LSD
            {0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 2000}
            >>> myLSD.start_Index
            0
            >>> 
            '''
        self.readme['pop.value.all'] = '''
            >>> 
            >>> import list_Style_Dict as lsd
            >>> myLSD = lsd.listStyleDict(start_Index=0,DLT={0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000})
            >>> myLSD.LSD
            {0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000}
            >>> myLSD.start_Index 
            0
            >>> myLSD.pop.value.all(5000)
            {1: 5000, 2: 5000, 3: 5000, 4: 5000}
            >>> myLSD.LSD
            {0: 4000, 1: 4000, 2: 3000, 3: 3000, 4: 1000, 5: 2000}
            >>> myLSD.start_Index
            0
            >>> 
            '''
        self.readme['remove'] = '''
            refer to myLSD.help('remove.default')
                     myLSD.help('remove.index')
                     myLSD.help('remove.indexrange')
                     myLSD.help('remove.value')
            for details
            '''
        self.readme['remove.default'] = '''
            >>> import list_Style_Dict as lsd
            >>> myLSD = lsd.listStyleDict(start_Index=0,DLT={0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000})
            >>> myLSD.LSD
            {0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000}
            >>> myLSD.start_Index 
            0
            >>> myLSD.remove.default(1)
            >>> myLSD.LSD
            {0: 5000, 1: 5000, 2: 4000, 3: 3000, 4: 3000, 5: 1000, 6: 5000, 7: 5000, 8: 2000}
            >>> myLSD.start_Index
            0
            >>> 
            '''
        self.readme['remove.index'] = '''
            >>> import list_Style_Dict as lsd
            >>> myLSD = lsd.listStyleDict(start_Index=0,DLT={0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000})
            >>> myLSD.LSD
            {0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000}
            >>> myLSD.start_Index 
            0
            >>> myLSD.remove.index(1)
            >>> myLSD.LSD
            {0: 5000, 1: 5000, 2: 4000, 3: 3000, 4: 3000, 5: 1000, 6: 5000, 7: 5000, 8: 2000}
            >>> myLSD.start_Index
            0
            >>> 
            '''
        self.readme['remove.indexrange'] = '''
            >>> import list_Style_Dict as lsd
            >>> myLSD = lsd.listStyleDict(start_Index=0,DLT={0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000})
            >>> myLSD.LSD
            {0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000}
            >>> myLSD.start_Index 
            0
            >>> myLSD.remove.indexrange(3,6)
            >>> myLSD.LSD
            {0: 5000, 1: 4000, 2: 5000, 3: 5000, 4: 5000, 5: 2000}
            >>> myLSD.start_Index
            0
            '''
        self.readme['remove.value'] = '''
            refer to myLSD.help('remove.value.first')
                     myLSD.help('remove.value.last')
                     myLSD.help('remove.value.all')
            for details
            '''
        self.readme['remove.value.first'] = '''
            >>> import list_Style_Dict as lsd
            >>> myLSD = lsd.listStyleDict(start_Index=0,DLT={0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000})
            >>> myLSD
            start_Index:0 {0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000}
            >>> myLSD.remove.value.first(4000)
            >>> myLSD
            start_Index:0 {0: 5000, 1: 5000, 2: 4000, 3: 3000, 4: 3000, 5: 1000, 6: 5000, 7: 5000, 8: 2000}
            >>> 
            '''
        self.readme['remove.value.last'] = '''
            >>> import list_Style_Dict as lsd
            >>> myLSD = lsd.listStyleDict(start_Index=0,DLT={0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000})
            >>> myLSD
            start_Index:0 {0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000}
            >>> myLSD.remove.value.last(5000)
            >>> myLSD
            start_Index:0 {0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 2000}
            >>> 
            '''
        self.readme['remove.value.all'] = '''
            >>> import list_Style_Dict as lsd
            >>> myLSD = lsd.listStyleDict(start_Index=0,DLT={0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000})
            >>> myLSD
            start_Index:0 {0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000}
            >>> myLSD.remove.value.all(5000)
            >>> myLSD
            start_Index:0 {0: 4000, 1: 4000, 2: 3000, 3: 3000, 4: 1000, 5: 2000}
            >>> 
            '''
        self.readme['reverse'] = '''
            >>> 
            >>> import list_Style_Dict as lsd
            >>> myLSD = lsd.listStyleDict(start_Index=0,DLT={0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000})
            >>> myLSD
            start_Index:0 {0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000}
            >>> myLSD.reverse()
            >>> myLSD
            start_Index:0 {0: 2000, 1: 5000, 2: 5000, 3: 1000, 4: 3000, 5: 3000, 6: 4000, 7: 5000, 8: 4000, 9: 5000}
            >>> 
            '''
        self.readme['sort'] = '''
            >>> 
            >>> import list_Style_Dict as lsd
            >>> myLSD = lsd.listStyleDict(start_Index=0,DLT={0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000})
            >>> myLSD
            start_Index:0 {0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000}
            >>> myLSD.sort()
            myLSD>>> myLSD
            start_Index:0 {0: 1000, 1: 2000, 2: 3000, 3: 3000, 4: 4000, 5: 4000, 6: 5000, 7: 5000, 8: 5000, 9: 5000}
            >>> 
            >>> import list_Style_Dict as lsd
            >>> myLSD = lsd.listStyleDict(start_Index=0,DLT={0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000})
            >>> myLSD
            start_Index:0 {0: 5000, 1: 4000, 2: 5000, 3: 4000, 4: 3000, 5: 3000, 6: 1000, 7: 5000, 8: 5000, 9: 2000}
            >>> myLSD.sort(inverse=True)
            >>> myLSD
            start_Index:0 {0: 5000, 1: 5000, 2: 5000, 3: 5000, 4: 4000, 5: 4000, 6: 3000, 7: 3000, 8: 2000, 9: 1000}
            >>> 
            >>> 
            '''
        self.index = self.index_Ops(self.index_First,self.index_Last,self.index_All)
        self.pop_Via_Value = self.pop_Via_Value_Ops(self.pop_Via_Value_First,self.pop_Via_Value_Last,self.pop_Via_Value_All)
        self.pop = self.pop_Ops(self.pop_Default,self.pop_Via_Index,self.pop_Via_Index_Range,self.pop_Via_Value)
        self.remove_Via_Value = self.remove_Via_Value_Ops(self.remove_Via_Value_First,self.remove_Via_Value_Last,self.remove_Via_Value_All)
        self.remove = self.remove_Ops(self.remove_Default,self.remove_Via_Index,self.remove_Via_Index_Range,self.remove_Via_Value)
    def __dir__(self):
        return(['readme','append','append_LSD','clear','copy','count','deepcopy','extend','index','insert','insert_LSD','pop','prepend','prepend_LSD','remove','reverse','sort'])
    def __str__(self):
        return('start_Index:{0} {1}'.format(self.start_Index,self.LSD.__repr__()))
    def __repr__(self):
        return(self.LSD.__repr__())
    def help(self,funcname):
        print(self.readme[funcname])
    def __getitem__(self,paras):
        if(paras in self.LSD):
            return(self.LSD[paras])
        else:
            return(None)
    def __setitem__(self,paras,value):
        if(paras in self.LSD):
            self.LSD[paras] = value
        else:
            pass
    def prepend(self,value):
        self.start_Index = self.start_Index - 1
        self.LSD[self.start_Index] = value
    def prepend_LSD(self,LSD):
        start_Index_LSD = self.is_LSD(LSD)
        if(not(start_Index_LSD==None)):
            LSD_len = LSD.__len__()
            start_Index = self.start_Index - LSD_len
            index_Diff = start_Index_LSD - start_Index
            for i in range(start_Index,self.start_Index):
                self.LSD[i] = LSD[i+index_Diff]
            self.start_Index = start_Index
        else:
            pass
    def append(self,value):
        LSD_len = self.LSD.__len__()
        end_Boundary = self.start_Index + LSD_len
        self.LSD[end_Boundary] = value
    def append_LSD(self,LSD):
        start_Index_LSD = self.is_LSD(LSD)
        if(not(start_Index_LSD == None)):
            LSD_len = LSD.__len__()
            self_LSD_len = self.LSD.__len__()
            old_Start_Index = self.start_Index
            old_End_Boundary = self.start_Index + self_LSD_len 
            new_End_Boundary = old_End_Boundary + LSD_len 
            index_Diff = start_Index_LSD - old_End_Boundary
            for i in range(old_End_Boundary,new_End_Boundary):
                self.LSD[i] = LSD[i+index_Diff]
        else:
            pass
    def clear(self):
        self.LSD = {}
        self.start_Index = 1
    def copy(self):
        copy_Dict = self.LSD.copy()
        return(copy_Dict)
    def deepcopy(self):
        deep_Copy_Dict = copy.deepcopy(self.LSD)
        return(deep_Copy_Dict)
    def index_First(self,value):
        self_LSD_len = self.LSD.__len__()
        old_Start_Index = self.start_Index
        old_End_Boundary = self.start_Index + self_LSD_len 
        for i in range(old_Start_Index,old_End_Boundary):
            if(self.LSD[i] == value):
                return(i)
        return(None)
    def index_Last(self,value):
        self_LSD_len = self.LSD.__len__()
        old_Start_Index = self.start_Index
        old_End_Index = self.start_Index + self_LSD_len - 1
        for i in range(old_End_Index,old_Start_Index-1,-1):
            if(self.LSD[i] == value):
                return(i)
        return(None)
    def index_All(self,value):
        result = {}
        result_Seq = 1
        self_LSD_len = self.LSD.__len__()
        old_Start_Index = self.start_Index
        old_End_Boundary = self.start_Index + self_LSD_len 
        for i in range(old_Start_Index,old_End_Boundary):
            if(self.LSD[i] == value):
                result[result_Seq] = i
                result_Seq = result_Seq + 1
        return(result)
    class index_Ops:
        def __init__(self,index_First,index_Last,index_All):
            self.first = index_First
            self.last = index_Last
            self.all = index_All
    def insert(self,index,value):
        self_LSD_len = self.LSD.__len__()
        old_End_Boundary = self.start_Index + self_LSD_len
        if(index < ( self.start_Index - 1)):
            pass
        elif(index == (self.start_Index - 1)):
            self.prepend(value)
        elif(index < old_End_Boundary):
            for i in range(old_End_Boundary,index,-1):
                self.LSD[i] = self.LSD[i-1]
            self.LSD[index] = value
        elif(index == old_End_Boundary ):
            self.append(value)
        else:
            pass
    def insert_LSD(self,index,LSD):
        start_Index_LSD = self.is_LSD(LSD)
        LSD_len = LSD.__len__()
        end_Index_LSD = start_Index_LSD + LSD_len - 1
        self_LSD_len = self.LSD.__len__()
        old_Start_Index = self.start_Index
        old_End_Boundary = self.start_Index + self_LSD_len 
        if((old_Start_Index - index) > LSD_len ):
            pass
        elif((old_Start_Index - index) == LSD_len):
            self.prepend_LSD(LSD)
        elif((old_Start_Index - index) > 0 ):
            r_Shift = LSD_len - (old_Start_Index - index)
            new_End_Boundary = old_End_Boundary + r_Shift
            for i in range(new_End_Boundary - 1,old_Start_Index + r_Shift -1,-1):
                self.LSD[i] = self.LSD[i - r_Shift]
            index_Diff = end_Index_LSD - (old_Start_Index + r_Shift -1)
            for i in range(old_Start_Index + r_Shift -1,index - 1,-1):
                self.LSD[i] = LSD[i+index_Diff]
            self.start_Index = index
        elif((old_Start_Index - index) == 0):
            r_Shift = LSD_len
            new_End_Boundary = old_End_Boundary + r_Shift
            for i in range(new_End_Boundary - 1,old_Start_Index + r_Shift -1,-1):
                self.LSD[i] = self.LSD[i - r_Shift]
            for i in range(old_Start_Index + r_Shift -1,index - 1,-1):
                self.LSD[i] = LSD[i]
        elif(index < old_End_Boundary):
            r_Shift = LSD_len 
            new_End_Boundary = old_End_Boundary + r_Shift
            for i in range(new_End_Boundary - 1,index + r_Shift -1,-1):
                self.LSD[i] = self.LSD[i - r_Shift]
            index_Diff = index - start_Index_LSD
            for i in range(index + r_Shift -1,index - 1,-1):
                self.LSD[i] = LSD[i - index_Diff]
        elif(index == old_End_Boundary):
            self.append_LSD(LSD)
        else:
            pass
    def count(self,value):
        count = 0
        self_LSD_len = self.LSD.__len__()
        End_Boundary = self.start_Index + self_LSD_len
        for i in range(self.start_Index,End_Boundary):
            if(self.LSD[i] == value):
                count = count + 1
        return(count)
    def extend(self,LSD):
        start_Index_LSD = self.is_LSD(LSD)
        if(not(start_Index_LSD==None)):
            LSD_len = LSD.__len__()
            self_LSD_len = self.LSD.__len__()
            old_Start_Index = self.start_Index
            old_End_Boundary = self.start_Index + self_LSD_len  
            new_End_Boundary = old_End_Boundary + LSD_len 
            index_Diff = start_Index_LSD - old_End_Boundary
            for i in range(old_End_Boundary,new_End_Boundary):
                self.LSD[i] = LSD[i+index_Diff]
        else:
            pass
    def pop_Default(self,index):
        self_LSD_len = self.LSD.__len__()
        old_Start_Index = self.start_Index
        old_End_Index = self.start_Index + self_LSD_len - 1
        old_End_Boundary = old_End_Index + 1
        if(index < old_Start_Index):
            return(None)
        elif(index > old_End_Index):
            return(None)
        else:
            result = self.LSD[index]
            del self.LSD[index]
            for i in range(index,old_End_Boundary-1):
                self.LSD[i] = self.LSD[i+1]
            del self.LSD[old_End_Index]
        return(result)
    def pop_Via_Index(self,index):
        self_LSD_len = self.LSD.__len__()
        old_Start_Index = self.start_Index
        old_End_Index = self.start_Index + self_LSD_len - 1
        old_End_Boundary = old_End_Index + 1
        if(index < old_Start_Index):
            return(None)
        elif(index > old_End_Index):
            return(None)
        else:
            result = self.LSD[index]
            del self.LSD[index]
            for i in range(index,old_End_Boundary-1):
                self.LSD[i] = self.LSD[i+1]
            del self.LSD[old_End_Index]
        return(result)
    def pop_Via_Index_Range(self,SI,EI):
        self_LSD_len = self.LSD.__len__()
        old_Start_Index = self.start_Index
        old_End_Index = self.start_Index + self_LSD_len - 1
        old_End_Boundary = old_End_Index + 1
        if(SI > EI):
            return(None)
        elif(SI==EI):
            result = {}
            result[1] = self.pop_Via_Index(SI)
            return(result)
        elif((SI < old_Start_Index)| (EI > old_End_Index)):
            return(None)
        else: #  old_Start_Index = < SI < EI < = old_End_Index
              #  [old_Start_Index,SI-1] [SI,EI] [EI+1,old_End_Index]
            result = {}
            for i in range(SI,EI+1):
                result[i-SI+1] = self.LSD[i]
            for i in range(SI,EI+1):
                prev_Index = i+EI+1-SI
                if(prev_Index < old_End_Boundary):
                    self.LSD[i] = self.LSD[i+EI+1-SI]
                else:
                    break
            for i in range(old_End_Index-EI+SI,old_End_Index+1):
                del self.LSD[i]
            return(result)
    def pop_Via_Value_First(self,value):
        index = self.index_First(value)
        if(index == None):
            return(None)
        else:
            return(self.pop_Via_Index(index))
    def pop_Via_Value_Last(self,value):
        index = self.index_Last(value)
        if(index == None):
            return(None)
        else:
            return(self.pop_Via_Index(index))
    def pop_Via_Value_All(self,value):
        result = {}
        indexes_Dict = self.get_First_Continuous_Slices_Via_Value(self.LSD,value)
        indexes_Dict_Len = indexes_Dict.__len__()
        while(indexes_Dict_Len > 0):
            SI = indexes_Dict[1]
            EI = indexes_Dict[indexes_Dict_Len]
            sub_Result = self.pop_Via_Index_Range(SI,EI)
            result = self.concat_LSD(result,sub_Result)
            indexes_Dict = self.get_First_Continuous_Slices_Via_Value(self.LSD,value)
            indexes_Dict_Len = indexes_Dict.__len__()
        return(result)
    class pop_Via_Value_Ops:
        def __init__(self,pop_Via_Value_First,pop_Via_Value_Last,pop_Via_Value_All):
            self.first = pop_Via_Value_First
            self.last = pop_Via_Value_Last
            self.all = pop_Via_Value_All
    class pop_Ops:
        def __init__(self,pop_Default,pop_Via_Index,pop_Via_Index_Range,pop_Via_Value):
            self.default = pop_Default
            self.index = pop_Via_Index
            self.indexrange = pop_Via_Index_Range
            self.value = pop_Via_Value
    def remove_Default(self,index):
        self_LSD_len = self.LSD.__len__()
        old_Start_Index = self.start_Index
        old_End_Index = self.start_Index + self_LSD_len - 1
        old_End_Boundary = old_End_Index + 1
        if(index < old_Start_Index):
            return(None)
        elif(index > old_End_Index):
            return(None)
        else:
            for i in range(index,old_End_Boundary-1):
                self.LSD[i] = self.LSD[i+1]
        del self.LSD[old_End_Index]
    def remove_Via_Index(self,index):
        self_LSD_len = self.LSD.__len__()
        old_Start_Index = self.start_Index
        old_End_Index = self.start_Index + self_LSD_len - 1
        old_End_Boundary = old_End_Index + 1
        if(index < old_Start_Index):
            return(None)
        elif(index > old_End_Index):
            return(None)
        else:
            result = self.LSD[index]
            for i in range(index,old_End_Boundary-1):
                self.LSD[i] = self.LSD[i+1]
        del self.LSD[old_End_Index]
    def remove_Via_Index_Range(self,SI,EI):
        self_LSD_len = self.LSD.__len__()
        old_Start_Index = self.start_Index
        old_End_Index = self.start_Index + self_LSD_len - 1
        old_End_Boundary = old_End_Index + 1
        if(SI > EI):
            pass
        elif(SI==EI):
            self.pop_Via_Index(SI)
        elif((SI < old_Start_Index)| (EI > old_End_Index)):
            pass
        else: #  old_Start_Index = < SI < EI < = old_End_Index
              #  [old_Start_Index,SI-1] [SI,EI] [EI+1,old_End_Index]
            for i in range(SI,EI+1):
                prev_Index = i+EI+1-SI
                if(prev_Index < old_End_Boundary):
                    self.LSD[i] = self.LSD[i+EI+1-SI]
                else:
                    break
            for i in range(old_End_Index-EI+SI,old_End_Index+1):
                del self.LSD[i]
    def remove_Via_Value_First(self,value):
        index = self.index_First(value)
        if(index == None):
            pass
        else:
            self.pop_Via_Index(index)
    def remove_Via_Value_Last(self,value):
        index = self.index_Last(value)
        if(index == None):
            pass
        else:
            self.pop_Via_Index(index)
    def remove_Via_Value_All(self,value):
        indexes_Dict = self.get_First_Continuous_Slices_Via_Value(self.LSD,value)
        indexes_Dict_Len = indexes_Dict.__len__()
        while(indexes_Dict_Len > 0):
            SI = indexes_Dict[1]
            EI = indexes_Dict[indexes_Dict_Len]
            self.pop_Via_Index_Range(SI,EI)
            indexes_Dict = self.get_First_Continuous_Slices_Via_Value(self.LSD,value)
            indexes_Dict_Len = indexes_Dict.__len__()
    class remove_Via_Value_Ops:
        def __init__(self,remove_Via_Value_First,remove_Via_Value_Last,remove_Via_Value_All):
            self.first = remove_Via_Value_First
            self.last = remove_Via_Value_Last
            self.all = remove_Via_Value_All
    class remove_Ops:
        def __init__(self,remove_Default,remove_Via_Index,remove_Via_Index_Range,remove_Via_Value):
            self.default = remove_Default
            self.index = remove_Via_Index
            self.indexrange = remove_Via_Index_Range
            self.value = remove_Via_Value
    def reverse(self):
        self_LSD_len = self.LSD.__len__()
        old_Start_Index = self.start_Index
        old_End_Index = self.start_Index + self_LSD_len - 1
        old_End_Boundary = old_End_Index + 1
        self_LSD_mid = (old_Start_Index + old_End_Index) // 2 
        for i in range(old_Start_Index,self_LSD_mid+1):
            temp = self.LSD[i]
            self.LSD[i] = self.LSD[(old_Start_Index + old_End_Index) - i] 
            self.LSD[(old_Start_Index + old_End_Index) - i] = temp
    def sort(self,inverse=False):
        tuple_List = self.LSD_To_Tuple_List(self.LSD)
        tuple_List = sorted(tuple_List, key=itemgetter(1),reverse=inverse)
        for i in range(self.start_Index,self.start_Index + tuple_List.__len__()):
            self.LSD[i] = tuple_List[i-self.start_Index][1]

