"""Este é o módulo "listasaninhadas.py", que fornece uma função
   chamada print_lol() que imprime listas inteiras, que contenham ou
   não outras listas em seu conteúdo. A impressão pode ser ou não
   indentada, e o nível da indentação pode ser selecionado pelo
   programador."""

def print_lol(lista, indentar=False, seletor=0):
        """Esta função mostra na tela o conteúdo de uma lista, ainda que hajam
           listas aninhadas dentro da mesma, e dentro destas. O parâmetro
           'indentar' faz com que a indentação seja ativada, caso verdadeira,
           e o parâmetro seletor define o nível de indentação, sendo que valores
           negativos representam nenhuma indentação."""
        for item in lista:
                if isinstance(item, list):
                        print_lol(item, indentar, seletor+1)
                else:
                        if indentar:
                                for tabulacao in range(seletor):
                                        print("\t", end='')
                        print(item)
