#!/usr/bin/python
# -*- coding: UTF-8 -*-

# Tuple containing (name, iso-639-1, iso-639-3)
LANGUAGES = (
	(u'Swahili', 'sw', 'swa'),
	(u'Swedish', 'sv', 'swe'),
	(u'Icelandic', 'is', 'isl'),
	(u'Dutch', 'nl', 'nld'),
	(u'Estonian', 'et', 'est'),
	(u'Vietnamese', 'vi', 'vie'),
	(u'Romanian', 'ro', 'ron'),
	(u'Samoan', 'sm', 'smo'),
	(u'Slovenian', 'sl', 'slv'),
	(u'Rhaeto-Romanic', 'rm', 'roh'),
	(u'Hindi', 'hi', 'hin'),
	(u'Somali', 'so', 'som'),
	(u'Russian', 'ru', 'rus'),
	(u'Lingala', 'ln', 'lin'),
	(u'Korean', 'ko', 'kor'),
	(u'Czech', 'cs', 'ces'),
	(u'Danish', 'da', 'dan'),
	(u'Indonesian', 'id', 'ind'),
	(u'Lao', 'lo', 'lao'),
	(u'Hungarian', 'hu', 'hun'),
	(u'Catalan', 'ca', 'cat'),
	(u'Georgian', 'ka', 'kat'),
	(u'Turkish', 'tr', 'tur'),
	(u'French', 'fr', 'fra'),
	(u'Norwegian', 'no', 'nor'),
	(u'Hebrew', 'he', 'heb'),
	(u'Maltese', 'mt', 'mlt'),
	(u'Slovak', 'sk', 'slk'),
	(u'Thai', 'th', 'tha'),
	(u'Afrikaans', 'af', 'afr'),
	(u'Irish', 'ga', 'gle'),
	(u'Kalaallisut', 'kl', 'kal'),
	(u'Zulu', 'zu', 'zul'),
	(u'Tonga', 'to', 'ton'),
	(u'Kongo', 'kg', 'kon'),
	(u'Croatian', 'hr', 'hrv'),
	(u'Finnish', 'fi', 'fin'),
	(u'Uzbek', 'uz', 'uzb'),
	(u'Albanian', 'sq', 'sqi'),
	(u'Basque', 'eu', 'eus'),
	(u'Malaysian', 'ms', 'msa'),
	(u'Bulgarian', 'bg', 'bul'),
	(u'Tswana', 'tn', 'tsn'),
	(u'Greek', 'el', 'ell'),
	(u'Latvian', 'lv', 'lav'),
	(u'English', 'en', 'eng'),
	(u'Serbian', 'sr', 'srp'),
	(u'Oromo', 'om', 'orm'),
	(u'Afar', 'aa', 'aar'),
	(u'Tsonga', 'ts', 'tso'),
	(u'Lithuanian', 'lt', 'lit'),
	(u'Italian', 'it', 'ita'),
	(u'Farsi', 'fa', 'fas'),
	(u'Portuguese', 'pt', 'por'),
	(u'Faeroese', 'fo', 'fao'),
	(u'Belarusian', 'be', 'bel'),
	(u'Chinese', 'zh', 'zho'),
	(u'Gaelic', 'gd', 'gla'),
	(u'German', 'de', 'deu'),
	(u'Ukrainian', 'uk', 'ukr'),
	(u'Japanese', 'ja', 'jpn'),
	(u'Kinyarwanda', 'rw', 'kin'),
	(u'Macedonian', 'mk', 'mkd'),
	(u'Ndebele', 'nd', 'nde'),
	(u'Spanish', 'es', 'spa'),
	(u'Urdu', 'ur', 'urd'),
	(u'Polish', 'pl', 'pol'),
	(u'Arabic', 'ar', 'ara'),
	(u'Venda', 've', 'ven'),
	(u'Xhosa', 'xh', 'xho')
)

DIALECTS = {
	u'Afar' : ((u'aa-ET', 'Ethiopia')),
	u'Afrikaans' : ((u'af-ZA', 'South Africa')),
	u'Albanian' : ((u'sq-AL', 'Albania')),
	u'Arabic':
			((u'ar-TN', 'Tunisia'),
			(u'ar-BH', 'Bahrain'),
			(u'ar-SY', 'Syria'),
			(u'ar-SD', 'Sudan'),
			(u'ar-SA', 'Saudi Arabia'),
			(u'ar-KW', 'Kuwait'),
			(u'ar-OM', 'Oman'),
			(u'ar-MA', 'Morocco'),
			(u'ar-AE', 'United Arab Emirates'),
			(u'ar-EG', 'Egypt'),
			(u'ar-JO', 'Jordan'),
			(u'ar-DZ', 'Algeria'),
			(u'ar-YE', 'Yemen'),
			(u'ar-LY', 'Libya'),
			(u'ar-LB', 'Lebanon'),
			(u'ar-QA', 'Qatar'),
			(u'ar-IQ', 'Iraq')),
	u'Basque' : ((u'eu-PV', 'Basque Country')),
	u'Belarusian' : ((u'be-BY', 'Belarus')),
	u'Bulgarian' : ((u'bg-BG', 'Bulgaria')),
	u'Catalan' : ((u'ca-AD', 'Andorra')),
	u'Chinese':
			((u'zh-CN', 'China'),
			(u'zh-HK', 'Hong Kong'),
			(u'zh-SG', 'Singapore'),
			(u'zh-TW', 'Taiwan')),
	u'Croatian' : ((u'hr-HR', 'Croatia')),
	u'Czech' : ((u'cs-CZ', 'Czech Republic')),
	u'Danish' : ((u'da-DK', 'Denmark')),
	u'Dutch' : ((u'nl-NL', 'Netherlands'), (u'nl-BE', 'Belgium')),
	u'English':
		((u'en-KE', 'Kenya'),
		(u'en-CA', 'Canada'),
		(u'en-GB', 'United Kingdom'),
		(u'en-JM', 'Jamaica'),
		(u'en-US', 'United States'),
		(u'en-NZ', 'New Zealand'),
		(u'en-ZA', 'South Africa'),
		(u'en-IE', 'Ireland'),
		(u'en-TT', 'Trinidad'),
		(u'en-BZ', 'Belize'),
		(u'en-AU', 'Australia')),
	u'Estonian' : ((u'et-EE', 'Estonia')),
	u'Faeroese' : ((u'fo-FO', 'Faroe Islands')),
	u'Farsi' : ((u'fa-IR', 'Iran')),
	u'Finnish':((u'fi-FI', 'Finland')),
	u'French':
		((u'fr-CH', 'Switzerland'),
		(u'fr-CA', 'Canada'),
		(u'fr-CG', 'Congo'),
		(u'fr-LU', 'Luxembourg'),
		(u'fr-BE', 'Belgium'),
		(u'fr-FR', 'France')),
	u'Gaelic' : ((u'gd-UK', 'Scotland')),
	u'Georgian' : ((u'ka-GE', 'Georgia')),
	u'German':
		((u'de-CH', 'Switzerland'),
		(u'de-LI', 'Liechtenstein'),
		(u'de-LU', 'Luxembourg'),
		(u'de-AT', 'Austria'),
		(u'de-DE', 'Germany')),
	u'Greek' : ((u'el-GR', 'Greece')),
	u'Hebrew' : ((u'he-IL', 'Israel')),
	u'Hindi' : ((u'hi-IN', 'India')),
	u'Hungarian' : ((u'hu-HU', 'Hungary')),
	u'Icelandic' : ((u'is-IS', 'Iceland')),
	u'Indonesian' : ((u'id-ID', 'Indonesia')),
	u'Irish' : ((u'ga-IE', 'Ireland')),
	u'Italian' : ((u'it-CH', 'Switzerland'),	(u'it-IT', 'Italy')),
	u'Japanese' : ((u'ja-JA', 'Japan')),
	u'Kalaallisut' : ((u'kl-GL', 'Greenland')),
	u'Kinyarwanda' : ((u'rw-RW', 'Rwanda')),
	u'Kongo' : ((u'kg-CG', 'Congo')),
	u'Korean' : ((u'ko-KP', 'Johab')),
	u'Lao' : ((u'lo-LA', 'Lao')),
	u'Latvian' : ((u'lv-LV', 'Latvia')),
	u'Lingala' : ((u'ln-CG', 'Congo')),
	u'Lithuanian' : ((u'lt-LT', 'Lithuania')),
	u'Macedonian' : ((u'mk-ML', 'Macedonia')),
	u'Malaysian' : ((u'ms-MY', 'Malaysia')),
	u'Maltese' : ((u'mt-MT', 'Malta')),
	u'Ndebele' : ((u'nd-ZW', 'Zimbabwe')),
	u'Norwegian' : ((u'no-NO', 'Nynorsk')),
	u'Oromo' : ((u'om-ET', 'Ethiopia'),	(u'om-KE', 'Kenya')),
	u'Polish' : ((u'pl-PL', 'Poland')),
	u'Portuguese':
		((u'pt-MZ', 'Mozambique'),
		(u'pt-BR', 'Brazil'),
		(u'pt-PT', 'Portugal')),
	u'Rhaeto-Romanic' : ((u'rm-IT', 'Italy')),
	u'Romanian' : ((u'ro-RO', 'Romania'),	(u'ro-MO', 'Republic of Moldova')),
	u'Russian' : ((u'ru-RU', 'Russia')),
	u'Sami' : ((u'sz-FI', 'Sapmi')),
	u'Samoan' : ((u'sm-SM', 'Samoa')),
	u'Serbian' : ((u'sr-RS', 'Serbia')),
	u'Slovak' : ((u'sk-SK', 'Slovakia')),
	u'Slovenian' : ((u'sl-SI', 'Slovenia')),
	u'Somali' : ((u'so-SO', 'Somalia'),	(u'so-KE', 'Kenya')),
	u'Sotho' : ((u'sx-ZA', 'South Africa')),
	u'Spanish':
		((u'es-GT', 'Guatemala'),
		(u'es-NI', 'Nicaragua'),
		(u'es-BO', 'Bolivia'),
		(u'es-SV', 'El Salvador'),
		(u'es-PR', 'Puerto Rico'),
		(u'es-DO', 'Dominican Republic'),
		(u'es-PY', 'Paraguay'),
		(u'es-CR', 'Costa Rica'),
		(u'es-CL', 'Chile'),
		(u'es-CO', 'Colombia'),
		(u'es-PA', 'Panama'),
		(u'es-EC', 'Ecuador'),
		(u'es-ES', 'Spain'),
		(u'es-HN', 'Honduras'),
		(u'es-UY', 'Uruguay'),
		(u'es-PE', 'Peru'),
		(u'es-AR', 'Argentina'),
		(u'es-MX', 'Mexico'),
		(u'es-VE', 'Venezuela')),
	u'Swahili' : ((u'sw-SW', 'Kenya'),	(u'sw-TZ', 'Tanzania')),
	u'Swedish' : ((u'sv-FI', 'Finland'),	(u'sv-SE', 'Sweden')),
	u'Thai' : ((u'th-TH', 'Thailand')),
	u'Tonga' : ((u'to-TO', 'Tonga')),
	u'Tsonga' : ((u'ts-ZA', 'South Africa')),
	u'Tswana' : ((u'tn-BW', 'Botswana')),
	u'Turkish' : ((u'tr-TR', 'Turkey')),
	u'Ukrainian' : ((u'uk-UA', 'Ukraine')),
	u'Urdu' : ((u'ur-PK', 'Pakistan')),
	u'Uzbek' : ((u'uz-UZ', 'Uzbekistan')),
	u'Venda' : ((u've-ZA', 'South Africa')),
	u'Vietnamese' : ((u'vi-VN', 'Vietnam')),
	u'Xhosa' : ((u'xh-ZA', 'South Africa')),
	u'Zulu' : ((u'zu-ZA', 'South Africa'),	(u'zu-ZW', 'Zimbabwe'))
}

def humanize(iso639):
	''' Converts ISO639 language identifier to the corresponding (human readable) language name. '''

	for i, element in enumerate(LANGUAGES):
		if element[1] == iso639 or element[2] == iso639:
			return element[0]
	return None

def iso639_1to3(iso639):
	''' Converts ISO639-1 language identifier to ISO639-3. '''

	for i, element in enumerate(LANGUAGES):
		if element[1] == iso639:
			return element[2]
	return None

def iso639_3to1(iso639):
	''' Converts ISO639-3 language identifier to ISO639-1. '''

	for i, element in enumerate(LANGUAGES):
		if element[2] == iso639:
			return element[1]
	return None
