
/*
 *****************************************************************************
 **       This file was autogenerated from a template  DO NOT EDIT!!!!      **
 **       Changes should be made to the original source (.src) file         **
 **       Produced by conv_template.py                                      **
 *****************************************************************************
 */

#line 1
/* -*- c -*- */

/* Taken and adapted from numpy/core/src/umath/funcs.inc
 * date: 9/11/2012
 * git hash: 75b8119f8145ab08a436ecfd7de868c6c6ba8f6d
 */

/*
 * This file is for the definitions of the non-c99 functions used in ufuncs.
 * All the complex ufuncs are defined here along with a smattering of real and
 * object functions.
 */

#define NPY_NO_DEPRECATED_API NPY_API_VERSION
// #include "npy_pycompat.h"
#include <Python.h>
#include <numpy/npy_common.h>
#include "npy_math.h"

/*
 *****************************************************************************
 **                           COMPLEX FUNCTIONS                             **
 *****************************************************************************
 */


/*
 * Don't pass structures between functions (only pointers) because how
 * structures are passed is compiler dependent and could cause segfaults if
 * umath_ufunc_object.inc is compiled with a different compiler than an
 * extension that makes use of the UFUNC API
 */

#line 42

/*
 * Perform the operation  result := 1 + coef * x * result,
 * with real coefficient `coef`.
 */
#define SERIES_HORNER_TERMf(result, x, coef)                  \
    do {                                                        \
        nc_prodf((result), (x), (result));                    \
        (result)->real *= (coef);                               \
        (result)->imag *= (coef);                               \
        nc_sumf((result), &nc_1f, (result));                \
    } while(0)

/* constants */
npy_cfloat nc_1f = {1., 0.};
npy_cfloat nc_halff = {0.5, 0.};
npy_cfloat nc_if = {0., 1.};
npy_cfloat nc_i2f = {0., 0.5};
/*
 *   npy_cfloat nc_mif = {0.0f, -1.0f};
 *   npy_cfloat nc_pi2f = {NPY_PI_2f., 0.0f};
 */


DL_EXPORT(void)
nc_sumf(npy_cfloat *a, npy_cfloat *b, npy_cfloat *r)
{
    r->real = a->real + b->real;
    r->imag = a->imag + b->imag;
    return;
}

DL_EXPORT(void)
nc_difff(npy_cfloat *a, npy_cfloat *b, npy_cfloat *r)
{
    r->real = a->real - b->real;
    r->imag = a->imag - b->imag;
    return;
}

DL_EXPORT(void)
nc_negf(npy_cfloat *a, npy_cfloat *r)
{
    r->real = -a->real;
    r->imag = -a->imag;
    return;
}

DL_EXPORT(void)
nc_prodf(npy_cfloat *a, npy_cfloat *b, npy_cfloat *r)
{
    npy_float ar=a->real, br=b->real, ai=a->imag, bi=b->imag;
    r->real = ar*br - ai*bi;
    r->imag = ar*bi + ai*br;
    return;
}

DL_EXPORT(void)
nc_quotf(npy_cfloat *a, npy_cfloat *b, npy_cfloat *r)
{

    npy_float ar=a->real, br=b->real, ai=a->imag, bi=b->imag;
    npy_float d = br*br + bi*bi;
    r->real = (ar*br + ai*bi)/d;
    r->imag = (ai*br - ar*bi)/d;
    return;
}

DL_EXPORT(void)
nc_sqrtf(npy_cfloat *x, npy_cfloat *r)
{
    *r = npy_csqrtf(*x);
    return;
}

DL_EXPORT(void)
nc_rintf(npy_cfloat *x, npy_cfloat *r)
{
    r->real = npy_rintf(x->real);
    r->imag = npy_rintf(x->imag);
}

DL_EXPORT(void)
nc_logf(npy_cfloat *x, npy_cfloat *r)
{
    *r = npy_clogf(*x);
    return;
}

DL_EXPORT(void)
nc_log1pf(npy_cfloat *x, npy_cfloat *r)
{
    npy_float l = npy_hypotf(x->real + 1,x->imag);
    r->imag = npy_atan2f(x->imag, x->real + 1);
    r->real = npy_logf(l);
    return;
}

DL_EXPORT(void)
nc_expf(npy_cfloat *x, npy_cfloat *r)
{
    *r = npy_cexpf(*x);
    return;
}

DL_EXPORT(void)
nc_exp2f(npy_cfloat *x, npy_cfloat *r)
{
    npy_cfloat a;
    a.real = x->real*NPY_LOGE2f;
    a.imag = x->imag*NPY_LOGE2f;
    nc_expf(&a, r);
    return;
}

DL_EXPORT(void)
nc_expm1f(npy_cfloat *x, npy_cfloat *r)
{
    npy_float a = npy_expf(x->real);
    r->real = a*npy_cosf(x->imag) - 1.0f;
    r->imag = a*npy_sinf(x->imag);
    return;
}

DL_EXPORT(void)
nc_powf(npy_cfloat *a, npy_cfloat *b, npy_cfloat *r)
{
    npy_intp n;
    npy_float ar = npy_crealf(*a);
    npy_float br = npy_crealf(*b);
    npy_float ai = npy_cimagf(*a);
    npy_float bi = npy_cimagf(*b);

    if (br == 0. && bi == 0.) {
        *r = npy_cpackf(1., 0.);
        return;
    }
    if (ar == 0. && ai == 0.) {
        if (br > 0 && bi == 0) {
            *r = npy_cpackf(0., 0.);
        }
        else {
            /* NB: there are four complex zeros; c0 = (+-0, +-0), so that unlike
             *     for reals, c0**p, with `p` negative is in general
             *     ill-defined.
             *
             *     c0**z with z complex is also ill-defined.
             */
            *r = npy_cpackf(NPY_NAN, NPY_NAN);

            /* Raise invalid */
            ar = NPY_INFINITY;
            ar = ar - ar;
        }
        return;
    }
    if (bi == 0 && (n=(npy_intp)br) == br) {
        if (n == 1) {
            /* unroll: handle inf better */
            *r = npy_cpackf(ar, ai);
            return;
        }
        else if (n == 2) {
            /* unroll: handle inf better */
            nc_prodf(a, a, r);
            return;
        }
        else if (n == 3) {
            /* unroll: handle inf better */
            nc_prodf(a, a, r);
            nc_prodf(a, r, r);
            return;
        }
        else if (n > -100 && n < 100) {
            npy_cfloat p, aa;
            npy_intp mask = 1;
            if (n < 0) n = -n;
            aa = nc_1f;
            p = npy_cpackf(ar, ai);
            while (1) {
                if (n & mask)
                    nc_prodf(&aa,&p,&aa);
                mask <<= 1;
                if (n < mask || mask <= 0) break;
                nc_prodf(&p,&p,&p);
            }
            *r = npy_cpackf(npy_crealf(aa), npy_cimagf(aa));
            if (br < 0) nc_quotf(&nc_1f, r, r);
            return;
        }
    }

    *r = npy_cpowf(*a, *b);
    return;
}


DL_EXPORT(void)
nc_prodif(npy_cfloat *x, npy_cfloat *r)
{
    npy_float xr = x->real;
    r->real = -x->imag;
    r->imag = xr;
    return;
}


DL_EXPORT(void)
nc_acosf(npy_cfloat *x, npy_cfloat *r)
{
    /*
     * return nc_neg(nc_prodi(nc_log(nc_sum(x,nc_prod(nc_i,
     * nc_sqrt(nc_diff(nc_1,nc_prod(x,x))))))));
     */
    nc_prodf(x,x,r);
    nc_difff(&nc_1f, r, r);
    nc_sqrtf(r, r);
    nc_prodif(r, r);
    nc_sumf(x, r, r);
    nc_logf(r, r);
    nc_prodif(r, r);
    nc_negf(r, r);
    return;
}

DL_EXPORT(void)
nc_acoshf(npy_cfloat *x, npy_cfloat *r)
{
    /*
     * return nc_log(nc_sum(x,
     * nc_prod(nc_sqrt(nc_sum(x,nc_1)), nc_sqrt(nc_diff(x,nc_1)))));
     */
    npy_cfloat t;

    nc_sumf(x, &nc_1f, &t);
    nc_sqrtf(&t, &t);
    nc_difff(x, &nc_1f, r);
    nc_sqrtf(r, r);
    nc_prodf(&t, r, r);
    nc_sumf(x, r, r);
    nc_logf(r, r);
    return;
}

DL_EXPORT(void)
nc_asinf(npy_cfloat *x, npy_cfloat *r)
{
    /*
     * return nc_neg(nc_prodi(nc_log(nc_sum(nc_prod(nc_i,x),
     * nc_sqrt(nc_diff(nc_1,nc_prod(x,x)))))));
     */
    if (fabs(x->real) > 1e-3 || fabs(x->imag) > 1e-3) {
        npy_cfloat a, *pa=&a;
        nc_prodf(x, x, r);
        nc_difff(&nc_1f, r, r);
        nc_sqrtf(r, r);
        nc_prodif(x, pa);
        nc_sumf(pa, r, r);
        nc_logf(r, r);
        nc_prodif(r, r);
        nc_negf(r, r);
    }
    else {
        /*
         * Small arguments: series expansion, to avoid loss of precision
         * asin(x) = x [1 + (1/6) x^2 [1 + (9/20) x^2 [1 + ...]]]
         *
         * |x| < 1e-3 => |rel. error| < 1e-18 (f), 1e-24, 1e-36 (l)
         */
        npy_cfloat x2;
        nc_prodf(x, x, &x2);

        *r = nc_1f;
#if 1 >= 3
        SERIES_HORNER_TERMf(r, &x2, 81.0F/110);
        SERIES_HORNER_TERMf(r, &x2, 49.0F/72);
#endif
#if 1 >= 2
        SERIES_HORNER_TERMf(r, &x2, 25.0F/42);
#endif
        SERIES_HORNER_TERMf(r, &x2, 9.0F/20);
        SERIES_HORNER_TERMf(r, &x2, 1.0F/6);
        nc_prodf(r, x, r);
    }
    return;
}


DL_EXPORT(void)
nc_asinhf(npy_cfloat *x, npy_cfloat *r)
{
    /*
     * return nc_log(nc_sum(nc_sqrt(nc_sum(nc_1,nc_prod(x,x))),x));
     */
    if (fabs(x->real) > 1e-3 || fabs(x->imag) > 1e-3) {
        nc_prodf(x, x, r);
        nc_sumf(&nc_1f, r, r);
        nc_sqrtf(r, r);
        nc_sumf(r, x, r);
        nc_logf(r, r);
    }
    else {
        /*
         * Small arguments: series expansion, to avoid loss of precision
         * asinh(x) = x [1 - (1/6) x^2 [1 - (9/20) x^2 [1 - ...]]]
         *
         * |x| < 1e-3 => |rel. error| < 1e-18 (f), 1e-24, 1e-36 (l)
         */
        npy_cfloat x2;
        nc_prodf(x, x, &x2);

        *r = nc_1f;
#if 1 >= 3
        SERIES_HORNER_TERMf(r, &x2, -81.0F/110);
        SERIES_HORNER_TERMf(r, &x2, -49.0F/72);
#endif
#if 1 >= 2
        SERIES_HORNER_TERMf(r, &x2, -25.0F/42);
#endif
        SERIES_HORNER_TERMf(r, &x2, -9.0F/20);
        SERIES_HORNER_TERMf(r, &x2, -1.0F/6);
        nc_prodf(r, x, r);
    }
    return;
}

DL_EXPORT(void)
nc_atanf(npy_cfloat *x, npy_cfloat *r)
{
    /*
     * return nc_prod(nc_i2,nc_log(nc_quot(nc_sum(nc_i,x),nc_diff(nc_i,x))));
     */
    if (fabs(x->real) > 1e-3 || fabs(x->imag) > 1e-3) {
        npy_cfloat a, *pa=&a;
        nc_difff(&nc_if, x, pa);
        nc_sumf(&nc_if, x, r);
        nc_quotf(r, pa, r);
        nc_logf(r,r);
        nc_prodf(&nc_i2f, r, r);
    }
    else {
        /*
         * Small arguments: series expansion, to avoid loss of precision
         * atan(x) = x [1 - (1/3) x^2 [1 - (3/5) x^2 [1 - ...]]]
         *
         * |x| < 1e-3 => |rel. error| < 1e-18 (f), 1e-24, 1e-36 (l)
         */
        npy_cfloat x2;
        nc_prodf(x, x, &x2);

        *r = nc_1f;
#if 1 >= 3
        SERIES_HORNER_TERMf(r, &x2, -9.0F/11);
        SERIES_HORNER_TERMf(r, &x2, -7.0F/9);
#endif
#if 1 >= 2
        SERIES_HORNER_TERMf(r, &x2, -5.0F/7);
#endif
        SERIES_HORNER_TERMf(r, &x2, -3.0F/5);
        SERIES_HORNER_TERMf(r, &x2, -1.0F/3);
        nc_prodf(r, x, r);
    }
    return;
}

DL_EXPORT(void)
nc_atanhf(npy_cfloat *x, npy_cfloat *r)
{
    /*
     * return nc_prod(nc_half,nc_log(nc_quot(nc_sum(nc_1,x),nc_diff(nc_1,x))));
     */
    if (fabs(x->real) > 1e-3 || fabs(x->imag) > 1e-3) {
        npy_cfloat a, *pa=&a;
        nc_difff(&nc_1f, x, r);
        nc_sumf(&nc_1f, x, pa);
        nc_quotf(pa, r, r);
        nc_logf(r, r);
        nc_prodf(&nc_halff, r, r);
    }
    else {
        /*
         * Small arguments: series expansion, to avoid loss of precision
         * atan(x) = x [1 + (1/3) x^2 [1 + (3/5) x^2 [1 + ...]]]
         *
         * |x| < 1e-3 => |rel. error| < 1e-18 (f), 1e-24, 1e-36 (l)
         */
        npy_cfloat x2;
        nc_prodf(x, x, &x2);

        *r = nc_1f;
#if 1 >= 3
        SERIES_HORNER_TERMf(r, &x2, 9.0F/11);
        SERIES_HORNER_TERMf(r, &x2, 7.0F/9);
#endif
#if 1 >= 2
        SERIES_HORNER_TERMf(r, &x2, 5.0F/7);
#endif
        SERIES_HORNER_TERMf(r, &x2, 3.0F/5);
        SERIES_HORNER_TERMf(r, &x2, 1.0F/3);
        nc_prodf(r, x, r);
    }
    return;
}

DL_EXPORT(void)
nc_cosf(npy_cfloat *x, npy_cfloat *r)
{
    npy_float xr=x->real, xi=x->imag;
    r->real = npy_cosf(xr)*npy_coshf(xi);
    r->imag = -npy_sinf(xr)*npy_sinhf(xi);
    return;
}

DL_EXPORT(void)
nc_coshf(npy_cfloat *x, npy_cfloat *r)
{
    npy_float xr=x->real, xi=x->imag;
    r->real = npy_cosf(xi)*npy_coshf(xr);
    r->imag = npy_sinf(xi)*npy_sinhf(xr);
    return;
}

DL_EXPORT(void)
nc_log10f(npy_cfloat *x, npy_cfloat *r)
{
    nc_logf(x, r);
    r->real *= NPY_LOG10Ef;
    r->imag *= NPY_LOG10Ef;
    return;
}

DL_EXPORT(void)
nc_log2f(npy_cfloat *x, npy_cfloat *r)
{
    nc_logf(x, r);
    r->real *= NPY_LOG2Ef;
    r->imag *= NPY_LOG2Ef;
    return;
}

DL_EXPORT(void)
nc_sinf(npy_cfloat *x, npy_cfloat *r)
{
    npy_float xr=x->real, xi=x->imag;
    r->real = npy_sinf(xr)*npy_coshf(xi);
    r->imag = npy_cosf(xr)*npy_sinhf(xi);
    return;
}

/*
npy_cfloat
nc_sinf(npy_cfloat x)
{
    npy_cfloat r;
    npy_float xr=x.real, xi=x.imag;
    r.real = npy_sinf(xr)*npy_coshf(xi);
    r.imag = npy_cosf(xr)*npy_sinhf(xi);
    return r;
}
*/

DL_EXPORT(void)
nc_sinhf(npy_cfloat *x, npy_cfloat *r)
{
    npy_float xr=x->real, xi=x->imag;
    r->real = npy_cosf(xi)*npy_sinhf(xr);
    r->imag = npy_sinf(xi)*npy_coshf(xr);
    return;
}

DL_EXPORT(void)
nc_tanf(npy_cfloat *x, npy_cfloat *r)
{
    npy_float sr,cr,shi,chi;
    npy_float rs,is,rc,ic;
    npy_float d;
    npy_float xr=x->real, xi=x->imag;
    sr = npy_sinf(xr);
    cr = npy_cosf(xr);
    shi = npy_sinhf(xi);
    chi = npy_coshf(xi);
    rs = sr*chi;
    is = cr*shi;
    rc = cr*chi;
    ic = -sr*shi;
    d = rc*rc + ic*ic;
    r->real = (rs*rc+is*ic)/d;
    r->imag = (is*rc-rs*ic)/d;
    return;
}

DL_EXPORT(void)
nc_tanhf(npy_cfloat *x, npy_cfloat *r)
{
    npy_float si,ci,shr,chr;
    npy_float rs,is,rc,ic;
    npy_float d;
    npy_float xr=x->real, xi=x->imag;
    si = npy_sinf(xi);
    ci = npy_cosf(xi);
    shr = npy_sinhf(xr);
    chr = npy_coshf(xr);
    rs = ci*shr;
    is = si*chr;
    rc = ci*chr;
    ic = si*shr;
    d = rc*rc + ic*ic;
    r->real = (rs*rc+is*ic)/d;
    r->imag = (is*rc-rs*ic)/d;
    return;
}

#undef SERIES_HORNER_TERMf

/* *********************************************************************** *
 * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ *
 *     Additions start here to original funcs.inc.src from numpy's umath   *
 * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ *
 * *********************************************************************** */

DL_EXPORT(void)
nc_cabsf(npy_cfloat *x, npy_float *r)
{
    *r = npy_cabsf(*x);
}


#line 42

/*
 * Perform the operation  result := 1 + coef * x * result,
 * with real coefficient `coef`.
 */
#define SERIES_HORNER_TERM(result, x, coef)                  \
    do {                                                        \
        nc_prod((result), (x), (result));                    \
        (result)->real *= (coef);                               \
        (result)->imag *= (coef);                               \
        nc_sum((result), &nc_1, (result));                \
    } while(0)

/* constants */
npy_cdouble nc_1 = {1., 0.};
npy_cdouble nc_half = {0.5, 0.};
npy_cdouble nc_i = {0., 1.};
npy_cdouble nc_i2 = {0., 0.5};
/*
 *   npy_cdouble nc_mi = {0.0, -1.0};
 *   npy_cdouble nc_pi2 = {NPY_PI_2., 0.0};
 */


DL_EXPORT(void)
nc_sum(npy_cdouble *a, npy_cdouble *b, npy_cdouble *r)
{
    r->real = a->real + b->real;
    r->imag = a->imag + b->imag;
    return;
}

DL_EXPORT(void)
nc_diff(npy_cdouble *a, npy_cdouble *b, npy_cdouble *r)
{
    r->real = a->real - b->real;
    r->imag = a->imag - b->imag;
    return;
}

DL_EXPORT(void)
nc_neg(npy_cdouble *a, npy_cdouble *r)
{
    r->real = -a->real;
    r->imag = -a->imag;
    return;
}

DL_EXPORT(void)
nc_prod(npy_cdouble *a, npy_cdouble *b, npy_cdouble *r)
{
    npy_double ar=a->real, br=b->real, ai=a->imag, bi=b->imag;
    r->real = ar*br - ai*bi;
    r->imag = ar*bi + ai*br;
    return;
}

DL_EXPORT(void)
nc_quot(npy_cdouble *a, npy_cdouble *b, npy_cdouble *r)
{

    npy_double ar=a->real, br=b->real, ai=a->imag, bi=b->imag;
    npy_double d = br*br + bi*bi;
    r->real = (ar*br + ai*bi)/d;
    r->imag = (ai*br - ar*bi)/d;
    return;
}

DL_EXPORT(void)
nc_sqrt(npy_cdouble *x, npy_cdouble *r)
{
    *r = npy_csqrt(*x);
    return;
}

DL_EXPORT(void)
nc_rint(npy_cdouble *x, npy_cdouble *r)
{
    r->real = npy_rint(x->real);
    r->imag = npy_rint(x->imag);
}

DL_EXPORT(void)
nc_log(npy_cdouble *x, npy_cdouble *r)
{
    *r = npy_clog(*x);
    return;
}

DL_EXPORT(void)
nc_log1p(npy_cdouble *x, npy_cdouble *r)
{
    npy_double l = npy_hypot(x->real + 1,x->imag);
    r->imag = npy_atan2(x->imag, x->real + 1);
    r->real = npy_log(l);
    return;
}

DL_EXPORT(void)
nc_exp(npy_cdouble *x, npy_cdouble *r)
{
    *r = npy_cexp(*x);
    return;
}

DL_EXPORT(void)
nc_exp2(npy_cdouble *x, npy_cdouble *r)
{
    npy_cdouble a;
    a.real = x->real*NPY_LOGE2;
    a.imag = x->imag*NPY_LOGE2;
    nc_exp(&a, r);
    return;
}

DL_EXPORT(void)
nc_expm1(npy_cdouble *x, npy_cdouble *r)
{
    npy_double a = npy_exp(x->real);
    r->real = a*npy_cos(x->imag) - 1.0;
    r->imag = a*npy_sin(x->imag);
    return;
}

DL_EXPORT(void)
nc_pow(npy_cdouble *a, npy_cdouble *b, npy_cdouble *r)
{
    npy_intp n;
    npy_double ar = npy_creal(*a);
    npy_double br = npy_creal(*b);
    npy_double ai = npy_cimag(*a);
    npy_double bi = npy_cimag(*b);

    if (br == 0. && bi == 0.) {
        *r = npy_cpack(1., 0.);
        return;
    }
    if (ar == 0. && ai == 0.) {
        if (br > 0 && bi == 0) {
            *r = npy_cpack(0., 0.);
        }
        else {
            /* NB: there are four complex zeros; c0 = (+-0, +-0), so that unlike
             *     for reals, c0**p, with `p` negative is in general
             *     ill-defined.
             *
             *     c0**z with z complex is also ill-defined.
             */
            *r = npy_cpack(NPY_NAN, NPY_NAN);

            /* Raise invalid */
            ar = NPY_INFINITY;
            ar = ar - ar;
        }
        return;
    }
    if (bi == 0 && (n=(npy_intp)br) == br) {
        if (n == 1) {
            /* unroll: handle inf better */
            *r = npy_cpack(ar, ai);
            return;
        }
        else if (n == 2) {
            /* unroll: handle inf better */
            nc_prod(a, a, r);
            return;
        }
        else if (n == 3) {
            /* unroll: handle inf better */
            nc_prod(a, a, r);
            nc_prod(a, r, r);
            return;
        }
        else if (n > -100 && n < 100) {
            npy_cdouble p, aa;
            npy_intp mask = 1;
            if (n < 0) n = -n;
            aa = nc_1;
            p = npy_cpack(ar, ai);
            while (1) {
                if (n & mask)
                    nc_prod(&aa,&p,&aa);
                mask <<= 1;
                if (n < mask || mask <= 0) break;
                nc_prod(&p,&p,&p);
            }
            *r = npy_cpack(npy_creal(aa), npy_cimag(aa));
            if (br < 0) nc_quot(&nc_1, r, r);
            return;
        }
    }

    *r = npy_cpow(*a, *b);
    return;
}


DL_EXPORT(void)
nc_prodi(npy_cdouble *x, npy_cdouble *r)
{
    npy_double xr = x->real;
    r->real = -x->imag;
    r->imag = xr;
    return;
}


DL_EXPORT(void)
nc_acos(npy_cdouble *x, npy_cdouble *r)
{
    /*
     * return nc_neg(nc_prodi(nc_log(nc_sum(x,nc_prod(nc_i,
     * nc_sqrt(nc_diff(nc_1,nc_prod(x,x))))))));
     */
    nc_prod(x,x,r);
    nc_diff(&nc_1, r, r);
    nc_sqrt(r, r);
    nc_prodi(r, r);
    nc_sum(x, r, r);
    nc_log(r, r);
    nc_prodi(r, r);
    nc_neg(r, r);
    return;
}

DL_EXPORT(void)
nc_acosh(npy_cdouble *x, npy_cdouble *r)
{
    /*
     * return nc_log(nc_sum(x,
     * nc_prod(nc_sqrt(nc_sum(x,nc_1)), nc_sqrt(nc_diff(x,nc_1)))));
     */
    npy_cdouble t;

    nc_sum(x, &nc_1, &t);
    nc_sqrt(&t, &t);
    nc_diff(x, &nc_1, r);
    nc_sqrt(r, r);
    nc_prod(&t, r, r);
    nc_sum(x, r, r);
    nc_log(r, r);
    return;
}

DL_EXPORT(void)
nc_asin(npy_cdouble *x, npy_cdouble *r)
{
    /*
     * return nc_neg(nc_prodi(nc_log(nc_sum(nc_prod(nc_i,x),
     * nc_sqrt(nc_diff(nc_1,nc_prod(x,x)))))));
     */
    if (fabs(x->real) > 1e-3 || fabs(x->imag) > 1e-3) {
        npy_cdouble a, *pa=&a;
        nc_prod(x, x, r);
        nc_diff(&nc_1, r, r);
        nc_sqrt(r, r);
        nc_prodi(x, pa);
        nc_sum(pa, r, r);
        nc_log(r, r);
        nc_prodi(r, r);
        nc_neg(r, r);
    }
    else {
        /*
         * Small arguments: series expansion, to avoid loss of precision
         * asin(x) = x [1 + (1/6) x^2 [1 + (9/20) x^2 [1 + ...]]]
         *
         * |x| < 1e-3 => |rel. error| < 1e-18 (f), 1e-24, 1e-36 (l)
         */
        npy_cdouble x2;
        nc_prod(x, x, &x2);

        *r = nc_1;
#if 2 >= 3
        SERIES_HORNER_TERM(r, &x2, 81.0/110);
        SERIES_HORNER_TERM(r, &x2, 49.0/72);
#endif
#if 2 >= 2
        SERIES_HORNER_TERM(r, &x2, 25.0/42);
#endif
        SERIES_HORNER_TERM(r, &x2, 9.0/20);
        SERIES_HORNER_TERM(r, &x2, 1.0/6);
        nc_prod(r, x, r);
    }
    return;
}


DL_EXPORT(void)
nc_asinh(npy_cdouble *x, npy_cdouble *r)
{
    /*
     * return nc_log(nc_sum(nc_sqrt(nc_sum(nc_1,nc_prod(x,x))),x));
     */
    if (fabs(x->real) > 1e-3 || fabs(x->imag) > 1e-3) {
        nc_prod(x, x, r);
        nc_sum(&nc_1, r, r);
        nc_sqrt(r, r);
        nc_sum(r, x, r);
        nc_log(r, r);
    }
    else {
        /*
         * Small arguments: series expansion, to avoid loss of precision
         * asinh(x) = x [1 - (1/6) x^2 [1 - (9/20) x^2 [1 - ...]]]
         *
         * |x| < 1e-3 => |rel. error| < 1e-18 (f), 1e-24, 1e-36 (l)
         */
        npy_cdouble x2;
        nc_prod(x, x, &x2);

        *r = nc_1;
#if 2 >= 3
        SERIES_HORNER_TERM(r, &x2, -81.0/110);
        SERIES_HORNER_TERM(r, &x2, -49.0/72);
#endif
#if 2 >= 2
        SERIES_HORNER_TERM(r, &x2, -25.0/42);
#endif
        SERIES_HORNER_TERM(r, &x2, -9.0/20);
        SERIES_HORNER_TERM(r, &x2, -1.0/6);
        nc_prod(r, x, r);
    }
    return;
}

DL_EXPORT(void)
nc_atan(npy_cdouble *x, npy_cdouble *r)
{
    /*
     * return nc_prod(nc_i2,nc_log(nc_quot(nc_sum(nc_i,x),nc_diff(nc_i,x))));
     */
    if (fabs(x->real) > 1e-3 || fabs(x->imag) > 1e-3) {
        npy_cdouble a, *pa=&a;
        nc_diff(&nc_i, x, pa);
        nc_sum(&nc_i, x, r);
        nc_quot(r, pa, r);
        nc_log(r,r);
        nc_prod(&nc_i2, r, r);
    }
    else {
        /*
         * Small arguments: series expansion, to avoid loss of precision
         * atan(x) = x [1 - (1/3) x^2 [1 - (3/5) x^2 [1 - ...]]]
         *
         * |x| < 1e-3 => |rel. error| < 1e-18 (f), 1e-24, 1e-36 (l)
         */
        npy_cdouble x2;
        nc_prod(x, x, &x2);

        *r = nc_1;
#if 2 >= 3
        SERIES_HORNER_TERM(r, &x2, -9.0/11);
        SERIES_HORNER_TERM(r, &x2, -7.0/9);
#endif
#if 2 >= 2
        SERIES_HORNER_TERM(r, &x2, -5.0/7);
#endif
        SERIES_HORNER_TERM(r, &x2, -3.0/5);
        SERIES_HORNER_TERM(r, &x2, -1.0/3);
        nc_prod(r, x, r);
    }
    return;
}

DL_EXPORT(void)
nc_atanh(npy_cdouble *x, npy_cdouble *r)
{
    /*
     * return nc_prod(nc_half,nc_log(nc_quot(nc_sum(nc_1,x),nc_diff(nc_1,x))));
     */
    if (fabs(x->real) > 1e-3 || fabs(x->imag) > 1e-3) {
        npy_cdouble a, *pa=&a;
        nc_diff(&nc_1, x, r);
        nc_sum(&nc_1, x, pa);
        nc_quot(pa, r, r);
        nc_log(r, r);
        nc_prod(&nc_half, r, r);
    }
    else {
        /*
         * Small arguments: series expansion, to avoid loss of precision
         * atan(x) = x [1 + (1/3) x^2 [1 + (3/5) x^2 [1 + ...]]]
         *
         * |x| < 1e-3 => |rel. error| < 1e-18 (f), 1e-24, 1e-36 (l)
         */
        npy_cdouble x2;
        nc_prod(x, x, &x2);

        *r = nc_1;
#if 2 >= 3
        SERIES_HORNER_TERM(r, &x2, 9.0/11);
        SERIES_HORNER_TERM(r, &x2, 7.0/9);
#endif
#if 2 >= 2
        SERIES_HORNER_TERM(r, &x2, 5.0/7);
#endif
        SERIES_HORNER_TERM(r, &x2, 3.0/5);
        SERIES_HORNER_TERM(r, &x2, 1.0/3);
        nc_prod(r, x, r);
    }
    return;
}

DL_EXPORT(void)
nc_cos(npy_cdouble *x, npy_cdouble *r)
{
    npy_double xr=x->real, xi=x->imag;
    r->real = npy_cos(xr)*npy_cosh(xi);
    r->imag = -npy_sin(xr)*npy_sinh(xi);
    return;
}

DL_EXPORT(void)
nc_cosh(npy_cdouble *x, npy_cdouble *r)
{
    npy_double xr=x->real, xi=x->imag;
    r->real = npy_cos(xi)*npy_cosh(xr);
    r->imag = npy_sin(xi)*npy_sinh(xr);
    return;
}

DL_EXPORT(void)
nc_log10(npy_cdouble *x, npy_cdouble *r)
{
    nc_log(x, r);
    r->real *= NPY_LOG10E;
    r->imag *= NPY_LOG10E;
    return;
}

DL_EXPORT(void)
nc_log2(npy_cdouble *x, npy_cdouble *r)
{
    nc_log(x, r);
    r->real *= NPY_LOG2E;
    r->imag *= NPY_LOG2E;
    return;
}

DL_EXPORT(void)
nc_sin(npy_cdouble *x, npy_cdouble *r)
{
    npy_double xr=x->real, xi=x->imag;
    r->real = npy_sin(xr)*npy_cosh(xi);
    r->imag = npy_cos(xr)*npy_sinh(xi);
    return;
}

/*
npy_cdouble
nc_sin(npy_cdouble x)
{
    npy_cdouble r;
    npy_double xr=x.real, xi=x.imag;
    r.real = npy_sin(xr)*npy_cosh(xi);
    r.imag = npy_cos(xr)*npy_sinh(xi);
    return r;
}
*/

DL_EXPORT(void)
nc_sinh(npy_cdouble *x, npy_cdouble *r)
{
    npy_double xr=x->real, xi=x->imag;
    r->real = npy_cos(xi)*npy_sinh(xr);
    r->imag = npy_sin(xi)*npy_cosh(xr);
    return;
}

DL_EXPORT(void)
nc_tan(npy_cdouble *x, npy_cdouble *r)
{
    npy_double sr,cr,shi,chi;
    npy_double rs,is,rc,ic;
    npy_double d;
    npy_double xr=x->real, xi=x->imag;
    sr = npy_sin(xr);
    cr = npy_cos(xr);
    shi = npy_sinh(xi);
    chi = npy_cosh(xi);
    rs = sr*chi;
    is = cr*shi;
    rc = cr*chi;
    ic = -sr*shi;
    d = rc*rc + ic*ic;
    r->real = (rs*rc+is*ic)/d;
    r->imag = (is*rc-rs*ic)/d;
    return;
}

DL_EXPORT(void)
nc_tanh(npy_cdouble *x, npy_cdouble *r)
{
    npy_double si,ci,shr,chr;
    npy_double rs,is,rc,ic;
    npy_double d;
    npy_double xr=x->real, xi=x->imag;
    si = npy_sin(xi);
    ci = npy_cos(xi);
    shr = npy_sinh(xr);
    chr = npy_cosh(xr);
    rs = ci*shr;
    is = si*chr;
    rc = ci*chr;
    ic = si*shr;
    d = rc*rc + ic*ic;
    r->real = (rs*rc+is*ic)/d;
    r->imag = (is*rc-rs*ic)/d;
    return;
}

#undef SERIES_HORNER_TERM

/* *********************************************************************** *
 * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ *
 *     Additions start here to original funcs.inc.src from numpy's umath   *
 * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ *
 * *********************************************************************** */

DL_EXPORT(void)
nc_cabs(npy_cdouble *x, npy_double *r)
{
    *r = npy_cabs(*x);
}


#line 42

/*
 * Perform the operation  result := 1 + coef * x * result,
 * with real coefficient `coef`.
 */
#define SERIES_HORNER_TERMl(result, x, coef)                  \
    do {                                                        \
        nc_prodl((result), (x), (result));                    \
        (result)->real *= (coef);                               \
        (result)->imag *= (coef);                               \
        nc_suml((result), &nc_1l, (result));                \
    } while(0)

/* constants */
npy_clongdouble nc_1l = {1., 0.};
npy_clongdouble nc_halfl = {0.5, 0.};
npy_clongdouble nc_il = {0., 1.};
npy_clongdouble nc_i2l = {0., 0.5};
/*
 *   npy_clongdouble nc_mil = {0.0l, -1.0l};
 *   npy_clongdouble nc_pi2l = {NPY_PI_2l., 0.0l};
 */


DL_EXPORT(void)
nc_suml(npy_clongdouble *a, npy_clongdouble *b, npy_clongdouble *r)
{
    r->real = a->real + b->real;
    r->imag = a->imag + b->imag;
    return;
}

DL_EXPORT(void)
nc_diffl(npy_clongdouble *a, npy_clongdouble *b, npy_clongdouble *r)
{
    r->real = a->real - b->real;
    r->imag = a->imag - b->imag;
    return;
}

DL_EXPORT(void)
nc_negl(npy_clongdouble *a, npy_clongdouble *r)
{
    r->real = -a->real;
    r->imag = -a->imag;
    return;
}

DL_EXPORT(void)
nc_prodl(npy_clongdouble *a, npy_clongdouble *b, npy_clongdouble *r)
{
    npy_longdouble ar=a->real, br=b->real, ai=a->imag, bi=b->imag;
    r->real = ar*br - ai*bi;
    r->imag = ar*bi + ai*br;
    return;
}

DL_EXPORT(void)
nc_quotl(npy_clongdouble *a, npy_clongdouble *b, npy_clongdouble *r)
{

    npy_longdouble ar=a->real, br=b->real, ai=a->imag, bi=b->imag;
    npy_longdouble d = br*br + bi*bi;
    r->real = (ar*br + ai*bi)/d;
    r->imag = (ai*br - ar*bi)/d;
    return;
}

DL_EXPORT(void)
nc_sqrtl(npy_clongdouble *x, npy_clongdouble *r)
{
    *r = npy_csqrtl(*x);
    return;
}

DL_EXPORT(void)
nc_rintl(npy_clongdouble *x, npy_clongdouble *r)
{
    r->real = npy_rintl(x->real);
    r->imag = npy_rintl(x->imag);
}

DL_EXPORT(void)
nc_logl(npy_clongdouble *x, npy_clongdouble *r)
{
    *r = npy_clogl(*x);
    return;
}

DL_EXPORT(void)
nc_log1pl(npy_clongdouble *x, npy_clongdouble *r)
{
    npy_longdouble l = npy_hypotl(x->real + 1,x->imag);
    r->imag = npy_atan2l(x->imag, x->real + 1);
    r->real = npy_logl(l);
    return;
}

DL_EXPORT(void)
nc_expl(npy_clongdouble *x, npy_clongdouble *r)
{
    *r = npy_cexpl(*x);
    return;
}

DL_EXPORT(void)
nc_exp2l(npy_clongdouble *x, npy_clongdouble *r)
{
    npy_clongdouble a;
    a.real = x->real*NPY_LOGE2l;
    a.imag = x->imag*NPY_LOGE2l;
    nc_expl(&a, r);
    return;
}

DL_EXPORT(void)
nc_expm1l(npy_clongdouble *x, npy_clongdouble *r)
{
    npy_longdouble a = npy_expl(x->real);
    r->real = a*npy_cosl(x->imag) - 1.0l;
    r->imag = a*npy_sinl(x->imag);
    return;
}

DL_EXPORT(void)
nc_powl(npy_clongdouble *a, npy_clongdouble *b, npy_clongdouble *r)
{
    npy_intp n;
    npy_longdouble ar = npy_creall(*a);
    npy_longdouble br = npy_creall(*b);
    npy_longdouble ai = npy_cimagl(*a);
    npy_longdouble bi = npy_cimagl(*b);

    if (br == 0. && bi == 0.) {
        *r = npy_cpackl(1., 0.);
        return;
    }
    if (ar == 0. && ai == 0.) {
        if (br > 0 && bi == 0) {
            *r = npy_cpackl(0., 0.);
        }
        else {
            /* NB: there are four complex zeros; c0 = (+-0, +-0), so that unlike
             *     for reals, c0**p, with `p` negative is in general
             *     ill-defined.
             *
             *     c0**z with z complex is also ill-defined.
             */
            *r = npy_cpackl(NPY_NAN, NPY_NAN);

            /* Raise invalid */
            ar = NPY_INFINITY;
            ar = ar - ar;
        }
        return;
    }
    if (bi == 0 && (n=(npy_intp)br) == br) {
        if (n == 1) {
            /* unroll: handle inf better */
            *r = npy_cpackl(ar, ai);
            return;
        }
        else if (n == 2) {
            /* unroll: handle inf better */
            nc_prodl(a, a, r);
            return;
        }
        else if (n == 3) {
            /* unroll: handle inf better */
            nc_prodl(a, a, r);
            nc_prodl(a, r, r);
            return;
        }
        else if (n > -100 && n < 100) {
            npy_clongdouble p, aa;
            npy_intp mask = 1;
            if (n < 0) n = -n;
            aa = nc_1l;
            p = npy_cpackl(ar, ai);
            while (1) {
                if (n & mask)
                    nc_prodl(&aa,&p,&aa);
                mask <<= 1;
                if (n < mask || mask <= 0) break;
                nc_prodl(&p,&p,&p);
            }
            *r = npy_cpackl(npy_creall(aa), npy_cimagl(aa));
            if (br < 0) nc_quotl(&nc_1l, r, r);
            return;
        }
    }

    *r = npy_cpowl(*a, *b);
    return;
}


DL_EXPORT(void)
nc_prodil(npy_clongdouble *x, npy_clongdouble *r)
{
    npy_longdouble xr = x->real;
    r->real = -x->imag;
    r->imag = xr;
    return;
}


DL_EXPORT(void)
nc_acosl(npy_clongdouble *x, npy_clongdouble *r)
{
    /*
     * return nc_neg(nc_prodi(nc_log(nc_sum(x,nc_prod(nc_i,
     * nc_sqrt(nc_diff(nc_1,nc_prod(x,x))))))));
     */
    nc_prodl(x,x,r);
    nc_diffl(&nc_1l, r, r);
    nc_sqrtl(r, r);
    nc_prodil(r, r);
    nc_suml(x, r, r);
    nc_logl(r, r);
    nc_prodil(r, r);
    nc_negl(r, r);
    return;
}

DL_EXPORT(void)
nc_acoshl(npy_clongdouble *x, npy_clongdouble *r)
{
    /*
     * return nc_log(nc_sum(x,
     * nc_prod(nc_sqrt(nc_sum(x,nc_1)), nc_sqrt(nc_diff(x,nc_1)))));
     */
    npy_clongdouble t;

    nc_suml(x, &nc_1l, &t);
    nc_sqrtl(&t, &t);
    nc_diffl(x, &nc_1l, r);
    nc_sqrtl(r, r);
    nc_prodl(&t, r, r);
    nc_suml(x, r, r);
    nc_logl(r, r);
    return;
}

DL_EXPORT(void)
nc_asinl(npy_clongdouble *x, npy_clongdouble *r)
{
    /*
     * return nc_neg(nc_prodi(nc_log(nc_sum(nc_prod(nc_i,x),
     * nc_sqrt(nc_diff(nc_1,nc_prod(x,x)))))));
     */
    if (fabs(x->real) > 1e-3 || fabs(x->imag) > 1e-3) {
        npy_clongdouble a, *pa=&a;
        nc_prodl(x, x, r);
        nc_diffl(&nc_1l, r, r);
        nc_sqrtl(r, r);
        nc_prodil(x, pa);
        nc_suml(pa, r, r);
        nc_logl(r, r);
        nc_prodil(r, r);
        nc_negl(r, r);
    }
    else {
        /*
         * Small arguments: series expansion, to avoid loss of precision
         * asin(x) = x [1 + (1/6) x^2 [1 + (9/20) x^2 [1 + ...]]]
         *
         * |x| < 1e-3 => |rel. error| < 1e-18 (f), 1e-24, 1e-36 (l)
         */
        npy_clongdouble x2;
        nc_prodl(x, x, &x2);

        *r = nc_1l;
#if 4 >= 3
        SERIES_HORNER_TERMl(r, &x2, 81.0L/110);
        SERIES_HORNER_TERMl(r, &x2, 49.0L/72);
#endif
#if 4 >= 2
        SERIES_HORNER_TERMl(r, &x2, 25.0L/42);
#endif
        SERIES_HORNER_TERMl(r, &x2, 9.0L/20);
        SERIES_HORNER_TERMl(r, &x2, 1.0L/6);
        nc_prodl(r, x, r);
    }
    return;
}


DL_EXPORT(void)
nc_asinhl(npy_clongdouble *x, npy_clongdouble *r)
{
    /*
     * return nc_log(nc_sum(nc_sqrt(nc_sum(nc_1,nc_prod(x,x))),x));
     */
    if (fabs(x->real) > 1e-3 || fabs(x->imag) > 1e-3) {
        nc_prodl(x, x, r);
        nc_suml(&nc_1l, r, r);
        nc_sqrtl(r, r);
        nc_suml(r, x, r);
        nc_logl(r, r);
    }
    else {
        /*
         * Small arguments: series expansion, to avoid loss of precision
         * asinh(x) = x [1 - (1/6) x^2 [1 - (9/20) x^2 [1 - ...]]]
         *
         * |x| < 1e-3 => |rel. error| < 1e-18 (f), 1e-24, 1e-36 (l)
         */
        npy_clongdouble x2;
        nc_prodl(x, x, &x2);

        *r = nc_1l;
#if 4 >= 3
        SERIES_HORNER_TERMl(r, &x2, -81.0L/110);
        SERIES_HORNER_TERMl(r, &x2, -49.0L/72);
#endif
#if 4 >= 2
        SERIES_HORNER_TERMl(r, &x2, -25.0L/42);
#endif
        SERIES_HORNER_TERMl(r, &x2, -9.0L/20);
        SERIES_HORNER_TERMl(r, &x2, -1.0L/6);
        nc_prodl(r, x, r);
    }
    return;
}

DL_EXPORT(void)
nc_atanl(npy_clongdouble *x, npy_clongdouble *r)
{
    /*
     * return nc_prod(nc_i2,nc_log(nc_quot(nc_sum(nc_i,x),nc_diff(nc_i,x))));
     */
    if (fabs(x->real) > 1e-3 || fabs(x->imag) > 1e-3) {
        npy_clongdouble a, *pa=&a;
        nc_diffl(&nc_il, x, pa);
        nc_suml(&nc_il, x, r);
        nc_quotl(r, pa, r);
        nc_logl(r,r);
        nc_prodl(&nc_i2l, r, r);
    }
    else {
        /*
         * Small arguments: series expansion, to avoid loss of precision
         * atan(x) = x [1 - (1/3) x^2 [1 - (3/5) x^2 [1 - ...]]]
         *
         * |x| < 1e-3 => |rel. error| < 1e-18 (f), 1e-24, 1e-36 (l)
         */
        npy_clongdouble x2;
        nc_prodl(x, x, &x2);

        *r = nc_1l;
#if 4 >= 3
        SERIES_HORNER_TERMl(r, &x2, -9.0L/11);
        SERIES_HORNER_TERMl(r, &x2, -7.0L/9);
#endif
#if 4 >= 2
        SERIES_HORNER_TERMl(r, &x2, -5.0L/7);
#endif
        SERIES_HORNER_TERMl(r, &x2, -3.0L/5);
        SERIES_HORNER_TERMl(r, &x2, -1.0L/3);
        nc_prodl(r, x, r);
    }
    return;
}

DL_EXPORT(void)
nc_atanhl(npy_clongdouble *x, npy_clongdouble *r)
{
    /*
     * return nc_prod(nc_half,nc_log(nc_quot(nc_sum(nc_1,x),nc_diff(nc_1,x))));
     */
    if (fabs(x->real) > 1e-3 || fabs(x->imag) > 1e-3) {
        npy_clongdouble a, *pa=&a;
        nc_diffl(&nc_1l, x, r);
        nc_suml(&nc_1l, x, pa);
        nc_quotl(pa, r, r);
        nc_logl(r, r);
        nc_prodl(&nc_halfl, r, r);
    }
    else {
        /*
         * Small arguments: series expansion, to avoid loss of precision
         * atan(x) = x [1 + (1/3) x^2 [1 + (3/5) x^2 [1 + ...]]]
         *
         * |x| < 1e-3 => |rel. error| < 1e-18 (f), 1e-24, 1e-36 (l)
         */
        npy_clongdouble x2;
        nc_prodl(x, x, &x2);

        *r = nc_1l;
#if 4 >= 3
        SERIES_HORNER_TERMl(r, &x2, 9.0L/11);
        SERIES_HORNER_TERMl(r, &x2, 7.0L/9);
#endif
#if 4 >= 2
        SERIES_HORNER_TERMl(r, &x2, 5.0L/7);
#endif
        SERIES_HORNER_TERMl(r, &x2, 3.0L/5);
        SERIES_HORNER_TERMl(r, &x2, 1.0L/3);
        nc_prodl(r, x, r);
    }
    return;
}

DL_EXPORT(void)
nc_cosl(npy_clongdouble *x, npy_clongdouble *r)
{
    npy_longdouble xr=x->real, xi=x->imag;
    r->real = npy_cosl(xr)*npy_coshl(xi);
    r->imag = -npy_sinl(xr)*npy_sinhl(xi);
    return;
}

DL_EXPORT(void)
nc_coshl(npy_clongdouble *x, npy_clongdouble *r)
{
    npy_longdouble xr=x->real, xi=x->imag;
    r->real = npy_cosl(xi)*npy_coshl(xr);
    r->imag = npy_sinl(xi)*npy_sinhl(xr);
    return;
}

DL_EXPORT(void)
nc_log10l(npy_clongdouble *x, npy_clongdouble *r)
{
    nc_logl(x, r);
    r->real *= NPY_LOG10El;
    r->imag *= NPY_LOG10El;
    return;
}

DL_EXPORT(void)
nc_log2l(npy_clongdouble *x, npy_clongdouble *r)
{
    nc_logl(x, r);
    r->real *= NPY_LOG2El;
    r->imag *= NPY_LOG2El;
    return;
}

DL_EXPORT(void)
nc_sinl(npy_clongdouble *x, npy_clongdouble *r)
{
    npy_longdouble xr=x->real, xi=x->imag;
    r->real = npy_sinl(xr)*npy_coshl(xi);
    r->imag = npy_cosl(xr)*npy_sinhl(xi);
    return;
}

/*
npy_clongdouble
nc_sinl(npy_clongdouble x)
{
    npy_clongdouble r;
    npy_longdouble xr=x.real, xi=x.imag;
    r.real = npy_sinl(xr)*npy_coshl(xi);
    r.imag = npy_cosl(xr)*npy_sinhl(xi);
    return r;
}
*/

DL_EXPORT(void)
nc_sinhl(npy_clongdouble *x, npy_clongdouble *r)
{
    npy_longdouble xr=x->real, xi=x->imag;
    r->real = npy_cosl(xi)*npy_sinhl(xr);
    r->imag = npy_sinl(xi)*npy_coshl(xr);
    return;
}

DL_EXPORT(void)
nc_tanl(npy_clongdouble *x, npy_clongdouble *r)
{
    npy_longdouble sr,cr,shi,chi;
    npy_longdouble rs,is,rc,ic;
    npy_longdouble d;
    npy_longdouble xr=x->real, xi=x->imag;
    sr = npy_sinl(xr);
    cr = npy_cosl(xr);
    shi = npy_sinhl(xi);
    chi = npy_coshl(xi);
    rs = sr*chi;
    is = cr*shi;
    rc = cr*chi;
    ic = -sr*shi;
    d = rc*rc + ic*ic;
    r->real = (rs*rc+is*ic)/d;
    r->imag = (is*rc-rs*ic)/d;
    return;
}

DL_EXPORT(void)
nc_tanhl(npy_clongdouble *x, npy_clongdouble *r)
{
    npy_longdouble si,ci,shr,chr;
    npy_longdouble rs,is,rc,ic;
    npy_longdouble d;
    npy_longdouble xr=x->real, xi=x->imag;
    si = npy_sinl(xi);
    ci = npy_cosl(xi);
    shr = npy_sinhl(xr);
    chr = npy_coshl(xr);
    rs = ci*shr;
    is = si*chr;
    rc = ci*chr;
    ic = si*shr;
    d = rc*rc + ic*ic;
    r->real = (rs*rc+is*ic)/d;
    r->imag = (is*rc-rs*ic)/d;
    return;
}

#undef SERIES_HORNER_TERMl

/* *********************************************************************** *
 * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ *
 *     Additions start here to original funcs.inc.src from numpy's umath   *
 * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ *
 * *********************************************************************** */

DL_EXPORT(void)
nc_cabsl(npy_clongdouble *x, npy_longdouble *r)
{
    *r = npy_cabsl(*x);
}



