
/*
 *****************************************************************************
 **       This file was autogenerated from a template  DO NOT EDIT!!!!      **
 **       Changes should be made to the original source (.src) file         **
 **       Produced by conv_template.py                                      **
 *****************************************************************************
 */

#line 1
/*
 * Taken from numpy/core/src/npymath/npy_math_complex.c.src
 * date: 9/11/2012
 * git hash: 75b8119f8145ab08a436ecfd7de868c6c6ba8f6d
 */

/*
 * Implement some C99-compatible complex math functions
 *
 * Most of the code is taken from the msun library in FreeBSD (HEAD @ 30th June
 * 2009), under the following license:
 *
 * Copyright (c) 2007 David Schultz <das@FreeBSD.ORG>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include "export.h"
#include "npy_math_common.h"
#include "npy_math_private.h"

/*==========================================================
 * Custom implementation of missing complex C99 functions
 *=========================================================*/

#line 52
#if !HAVE_CABSF
DL_EXPORT(npy_float) npy_cabsf(npy_cfloat z)
{
    return npy_hypotf(npy_crealf(z), npy_cimagf(z));
}
#endif

#if !HAVE_CARGF
DL_EXPORT(npy_float) npy_cargf(npy_cfloat z)
{
    return npy_atan2f(npy_cimagf(z), npy_crealf(z));
}
#endif

#if !HAVE_CEXPF
DL_EXPORT(npy_cfloat) npy_cexpf(npy_cfloat z)
{
    npy_float x, c, s;
    npy_float r, i;
    npy_cfloat ret;

    r = npy_crealf(z);
    i = npy_cimagf(z);

    if (npy_isfinite(r)) {
        x = npy_expf(r);

        c = npy_cosf(i);
        s = npy_sinf(i);

        if (npy_isfinite(i)) {
            ret = npy_cpackf(x * c, x * s);
        } else {
            ret = npy_cpackf(NPY_NAN, npy_copysignf(NPY_NAN, i));
        }

    } else  if (npy_isnan(r)) {
        /* r is nan */
        if (i == 0) {
            ret = npy_cpackf(r, 0);
        } else {
            ret = npy_cpackf(r, npy_copysignf(NPY_NAN, i));
        }
    } else {
        /* r is +- inf */
        if (r > 0) {
            if (i == 0) {
                ret = npy_cpackf(r, i);
            } else if (npy_isfinite(i)) {
                c = npy_cosf(i);
                s = npy_sinf(i);

                ret = npy_cpackf(r * c, r * s);
            } else {
                /* x = +inf, y = +-inf | nan */
                ret = npy_cpackf(r, NPY_NAN);
            }
        } else {
            if (npy_isfinite(i)) {
                x = npy_expf(r);
                c = npy_cosf(i);
                s = npy_sinf(i);

                ret = npy_cpackf(x * c, x * s);
            } else {
                /* x = -inf, y = nan | +i inf */
                ret = npy_cpackf(0, 0);
            }
        }
    }

    return ret;
}
#endif

#if !HAVE_CLOGF
DL_EXPORT(npy_cfloat) npy_clogf(npy_cfloat z)
{
    return npy_cpackf(npy_logf (npy_cabsf (z)), npy_cargf (z));
}
#endif

#if !HAVE_CSQRTF

/* We risk spurious overflow for components >= DBL_MAX / (1 + sqrt(2)). */
#define THRESH  (FLT_MAX / (1 + NPY_SQRT2f))

DL_EXPORT(npy_cfloat) npy_csqrtf(npy_cfloat z)
{
    npy_cfloat result;
    npy_float a, b;
    npy_float t;
    int scale;

    a = npy_crealf(z);
    b = npy_cimagf(z);

    /* Handle special cases. */
    if (a == 0 && b == 0)
        return (npy_cpackf(0, b));
    if (npy_isinf(b))
        return (npy_cpackf(NPY_INFINITY, b));
    if (npy_isnan(a)) {
        t = (b - b) / (b - b);  /* raise invalid if b is not a NaN */
        return (npy_cpackf(a, t));    /* return NaN + NaN i */
    }
    if (npy_isinf(a)) {
        /*
         * csqrt(inf + NaN i)  = inf +  NaN i
         * csqrt(inf + y i)    = inf +  0 i
         * csqrt(-inf + NaN i) = NaN +- inf i
         * csqrt(-inf + y i)   = 0   +  inf i
         */
        if (npy_signbit(a))
            return (npy_cpackf(npy_fabsf(b - b), npy_copysignf(a, b)));
        else
            return (npy_cpackf(a, npy_copysignf(b - b, b)));
    }
    /*
     * The remaining special case (b is NaN) is handled just fine by
     * the normal code path below.
     */

    /* Scale to avoid overflow. */
    if (npy_fabsf(a) >= THRESH || npy_fabsf(b) >= THRESH) {
        a *= 0.25;
        b *= 0.25;
        scale = 1;
    } else {
        scale = 0;
    }

    /* Algorithm 312, CACM vol 10, Oct 1967. */
    if (a >= 0) {
        t = npy_sqrtf((a + npy_hypotf(a, b)) * 0.5);
        result = npy_cpackf(t, b / (2 * t));
    } else {
        t = npy_sqrtf((-a + npy_hypotf(a, b)) * 0.5);
        result = npy_cpackf(npy_fabsf(b) / (2 * t), npy_copysignf(t, b));
    }

    /* Rescale. */
    if (scale)
        return (npy_cpackf(npy_crealf(result) * 2, npy_cimagf(result)));
    else
        return (result);
}
#undef THRESH
#endif

#if !HAVE_CPOWF
DL_EXPORT(npy_cfloat) npy_cpowf (npy_cfloat x, npy_cfloat y)
{
    npy_cfloat b;
    npy_float br, bi, yr, yi;

    yr = npy_crealf(y);
    yi = npy_cimagf(y);
    b = npy_clogf(x);
    br = npy_crealf(b);
    bi = npy_cimagf(b);

    return npy_cexpf(npy_cpackf(br * yr - bi * yi, br * yi + bi * yr));
}
#endif

#if !HAVE_CCOSF
DL_EXPORT(npy_cfloat) npy_ccosf(npy_cfloat z)
{
    npy_float x, y;
    x = npy_crealf(z);
    y = npy_cimagf(z);
    return npy_cpackf(npy_cosf(x) * npy_coshf(y), -(npy_sinf(x) * npy_sinhf(y)));
}
#endif

#if !HAVE_CSINF
DL_EXPORT(npy_cfloat) npy_csinf(npy_cfloat z)
{
    npy_float x, y;
    x = npy_crealf(z);
    y = npy_cimagf(z);
    return npy_cpackf(npy_sinf(x) * npy_coshf(y), npy_cosf(x) * npy_sinhf(y));
}
#endif

#line 52
#if !HAVE_CABS
DL_EXPORT(npy_double) npy_cabs(npy_cdouble z)
{
    return npy_hypot(npy_creal(z), npy_cimag(z));
}
#endif

#if !HAVE_CARG
DL_EXPORT(npy_double) npy_carg(npy_cdouble z)
{
    return npy_atan2(npy_cimag(z), npy_creal(z));
}
#endif

#if !HAVE_CEXP
DL_EXPORT(npy_cdouble) npy_cexp(npy_cdouble z)
{
    npy_double x, c, s;
    npy_double r, i;
    npy_cdouble ret;

    r = npy_creal(z);
    i = npy_cimag(z);

    if (npy_isfinite(r)) {
        x = npy_exp(r);

        c = npy_cos(i);
        s = npy_sin(i);

        if (npy_isfinite(i)) {
            ret = npy_cpack(x * c, x * s);
        } else {
            ret = npy_cpack(NPY_NAN, npy_copysign(NPY_NAN, i));
        }

    } else  if (npy_isnan(r)) {
        /* r is nan */
        if (i == 0) {
            ret = npy_cpack(r, 0);
        } else {
            ret = npy_cpack(r, npy_copysign(NPY_NAN, i));
        }
    } else {
        /* r is +- inf */
        if (r > 0) {
            if (i == 0) {
                ret = npy_cpack(r, i);
            } else if (npy_isfinite(i)) {
                c = npy_cos(i);
                s = npy_sin(i);

                ret = npy_cpack(r * c, r * s);
            } else {
                /* x = +inf, y = +-inf | nan */
                ret = npy_cpack(r, NPY_NAN);
            }
        } else {
            if (npy_isfinite(i)) {
                x = npy_exp(r);
                c = npy_cos(i);
                s = npy_sin(i);

                ret = npy_cpack(x * c, x * s);
            } else {
                /* x = -inf, y = nan | +i inf */
                ret = npy_cpack(0, 0);
            }
        }
    }

    return ret;
}
#endif

#if !HAVE_CLOG
DL_EXPORT(npy_cdouble) npy_clog(npy_cdouble z)
{
    return npy_cpack(npy_log (npy_cabs (z)), npy_carg (z));
}
#endif

#if !HAVE_CSQRT

/* We risk spurious overflow for components >= DBL_MAX / (1 + sqrt(2)). */
#define THRESH  (DBL_MAX / (1 + NPY_SQRT2))

DL_EXPORT(npy_cdouble) npy_csqrt(npy_cdouble z)
{
    npy_cdouble result;
    npy_double a, b;
    npy_double t;
    int scale;

    a = npy_creal(z);
    b = npy_cimag(z);

    /* Handle special cases. */
    if (a == 0 && b == 0)
        return (npy_cpack(0, b));
    if (npy_isinf(b))
        return (npy_cpack(NPY_INFINITY, b));
    if (npy_isnan(a)) {
        t = (b - b) / (b - b);  /* raise invalid if b is not a NaN */
        return (npy_cpack(a, t));    /* return NaN + NaN i */
    }
    if (npy_isinf(a)) {
        /*
         * csqrt(inf + NaN i)  = inf +  NaN i
         * csqrt(inf + y i)    = inf +  0 i
         * csqrt(-inf + NaN i) = NaN +- inf i
         * csqrt(-inf + y i)   = 0   +  inf i
         */
        if (npy_signbit(a))
            return (npy_cpack(npy_fabs(b - b), npy_copysign(a, b)));
        else
            return (npy_cpack(a, npy_copysign(b - b, b)));
    }
    /*
     * The remaining special case (b is NaN) is handled just fine by
     * the normal code path below.
     */

    /* Scale to avoid overflow. */
    if (npy_fabs(a) >= THRESH || npy_fabs(b) >= THRESH) {
        a *= 0.25;
        b *= 0.25;
        scale = 1;
    } else {
        scale = 0;
    }

    /* Algorithm 312, CACM vol 10, Oct 1967. */
    if (a >= 0) {
        t = npy_sqrt((a + npy_hypot(a, b)) * 0.5);
        result = npy_cpack(t, b / (2 * t));
    } else {
        t = npy_sqrt((-a + npy_hypot(a, b)) * 0.5);
        result = npy_cpack(npy_fabs(b) / (2 * t), npy_copysign(t, b));
    }

    /* Rescale. */
    if (scale)
        return (npy_cpack(npy_creal(result) * 2, npy_cimag(result)));
    else
        return (result);
}
#undef THRESH
#endif

#if !HAVE_CPOW
DL_EXPORT(npy_cdouble) npy_cpow (npy_cdouble x, npy_cdouble y)
{
    npy_cdouble b;
    npy_double br, bi, yr, yi;

    yr = npy_creal(y);
    yi = npy_cimag(y);
    b = npy_clog(x);
    br = npy_creal(b);
    bi = npy_cimag(b);

    return npy_cexp(npy_cpack(br * yr - bi * yi, br * yi + bi * yr));
}
#endif

#if !HAVE_CCOS
DL_EXPORT(npy_cdouble) npy_ccos(npy_cdouble z)
{
    npy_double x, y;
    x = npy_creal(z);
    y = npy_cimag(z);
    return npy_cpack(npy_cos(x) * npy_cosh(y), -(npy_sin(x) * npy_sinh(y)));
}
#endif

#if !HAVE_CSIN
DL_EXPORT(npy_cdouble) npy_csin(npy_cdouble z)
{
    npy_double x, y;
    x = npy_creal(z);
    y = npy_cimag(z);
    return npy_cpack(npy_sin(x) * npy_cosh(y), npy_cos(x) * npy_sinh(y));
}
#endif

#line 52
#if !HAVE_CABSL
DL_EXPORT(npy_longdouble) npy_cabsl(npy_clongdouble z)
{
    return npy_hypotl(npy_creall(z), npy_cimagl(z));
}
#endif

#if !HAVE_CARGL
DL_EXPORT(npy_longdouble) npy_cargl(npy_clongdouble z)
{
    return npy_atan2l(npy_cimagl(z), npy_creall(z));
}
#endif

#if !HAVE_CEXPL
DL_EXPORT(npy_clongdouble) npy_cexpl(npy_clongdouble z)
{
    npy_longdouble x, c, s;
    npy_longdouble r, i;
    npy_clongdouble ret;

    r = npy_creall(z);
    i = npy_cimagl(z);

    if (npy_isfinite(r)) {
        x = npy_expl(r);

        c = npy_cosl(i);
        s = npy_sinl(i);

        if (npy_isfinite(i)) {
            ret = npy_cpackl(x * c, x * s);
        } else {
            ret = npy_cpackl(NPY_NAN, npy_copysignl(NPY_NAN, i));
        }

    } else  if (npy_isnan(r)) {
        /* r is nan */
        if (i == 0) {
            ret = npy_cpackl(r, 0);
        } else {
            ret = npy_cpackl(r, npy_copysignl(NPY_NAN, i));
        }
    } else {
        /* r is +- inf */
        if (r > 0) {
            if (i == 0) {
                ret = npy_cpackl(r, i);
            } else if (npy_isfinite(i)) {
                c = npy_cosl(i);
                s = npy_sinl(i);

                ret = npy_cpackl(r * c, r * s);
            } else {
                /* x = +inf, y = +-inf | nan */
                ret = npy_cpackl(r, NPY_NAN);
            }
        } else {
            if (npy_isfinite(i)) {
                x = npy_expl(r);
                c = npy_cosl(i);
                s = npy_sinl(i);

                ret = npy_cpackl(x * c, x * s);
            } else {
                /* x = -inf, y = nan | +i inf */
                ret = npy_cpackl(0, 0);
            }
        }
    }

    return ret;
}
#endif

#if !HAVE_CLOGL
DL_EXPORT(npy_clongdouble) npy_clogl(npy_clongdouble z)
{
    return npy_cpackl(npy_logl (npy_cabsl (z)), npy_cargl (z));
}
#endif

#if !HAVE_CSQRTL

/* We risk spurious overflow for components >= DBL_MAX / (1 + sqrt(2)). */
#define THRESH  (LDBL_MAX / (1 + NPY_SQRT2l))

DL_EXPORT(npy_clongdouble) npy_csqrtl(npy_clongdouble z)
{
    npy_clongdouble result;
    npy_longdouble a, b;
    npy_longdouble t;
    int scale;

    a = npy_creall(z);
    b = npy_cimagl(z);

    /* Handle special cases. */
    if (a == 0 && b == 0)
        return (npy_cpackl(0, b));
    if (npy_isinf(b))
        return (npy_cpackl(NPY_INFINITY, b));
    if (npy_isnan(a)) {
        t = (b - b) / (b - b);  /* raise invalid if b is not a NaN */
        return (npy_cpackl(a, t));    /* return NaN + NaN i */
    }
    if (npy_isinf(a)) {
        /*
         * csqrt(inf + NaN i)  = inf +  NaN i
         * csqrt(inf + y i)    = inf +  0 i
         * csqrt(-inf + NaN i) = NaN +- inf i
         * csqrt(-inf + y i)   = 0   +  inf i
         */
        if (npy_signbit(a))
            return (npy_cpackl(npy_fabsl(b - b), npy_copysignl(a, b)));
        else
            return (npy_cpackl(a, npy_copysignl(b - b, b)));
    }
    /*
     * The remaining special case (b is NaN) is handled just fine by
     * the normal code path below.
     */

    /* Scale to avoid overflow. */
    if (npy_fabsl(a) >= THRESH || npy_fabsl(b) >= THRESH) {
        a *= 0.25;
        b *= 0.25;
        scale = 1;
    } else {
        scale = 0;
    }

    /* Algorithm 312, CACM vol 10, Oct 1967. */
    if (a >= 0) {
        t = npy_sqrtl((a + npy_hypotl(a, b)) * 0.5);
        result = npy_cpackl(t, b / (2 * t));
    } else {
        t = npy_sqrtl((-a + npy_hypotl(a, b)) * 0.5);
        result = npy_cpackl(npy_fabsl(b) / (2 * t), npy_copysignl(t, b));
    }

    /* Rescale. */
    if (scale)
        return (npy_cpackl(npy_creall(result) * 2, npy_cimagl(result)));
    else
        return (result);
}
#undef THRESH
#endif

#if !HAVE_CPOWL
DL_EXPORT(npy_clongdouble) npy_cpowl (npy_clongdouble x, npy_clongdouble y)
{
    npy_clongdouble b;
    npy_longdouble br, bi, yr, yi;

    yr = npy_creall(y);
    yi = npy_cimagl(y);
    b = npy_clogl(x);
    br = npy_creall(b);
    bi = npy_cimagl(b);

    return npy_cexpl(npy_cpackl(br * yr - bi * yi, br * yi + bi * yr));
}
#endif

#if !HAVE_CCOSL
DL_EXPORT(npy_clongdouble) npy_ccosl(npy_clongdouble z)
{
    npy_longdouble x, y;
    x = npy_creall(z);
    y = npy_cimagl(z);
    return npy_cpackl(npy_cosl(x) * npy_coshl(y), -(npy_sinl(x) * npy_sinhl(y)));
}
#endif

#if !HAVE_CSINL
DL_EXPORT(npy_clongdouble) npy_csinl(npy_clongdouble z)
{
    npy_longdouble x, y;
    x = npy_creall(z);
    y = npy_cimagl(z);
    return npy_cpackl(npy_sinl(x) * npy_coshl(y), npy_cosl(x) * npy_sinhl(y));
}
#endif


/*==========================================================
 * Decorate all the functions which are available natively
 *=========================================================*/

#line 249

#line 254
#if HAVE_CABSF
DL_EXPORT(npy_float) npy_cabsf(npy_cfloat z)
{
    __npy_cfloat_to_c99_cast z1 = {z};
    return cabsf(z1.c99_z);
}
#endif

#line 254
#if HAVE_CARGF
DL_EXPORT(npy_float) npy_cargf(npy_cfloat z)
{
    __npy_cfloat_to_c99_cast z1 = {z};
    return cargf(z1.c99_z);
}
#endif


#line 267
#if HAVE_CEXPF
DL_EXPORT(npy_cfloat) npy_cexpf(npy_cfloat z)
{
    __npy_cfloat_to_c99_cast z1 = {z};
    __npy_cfloat_to_c99_cast ret;
    ret.c99_z = cexpf(z1.c99_z);
    return ret.npy_z;
}
#endif

#line 267
#if HAVE_CLOGF
DL_EXPORT(npy_cfloat) npy_clogf(npy_cfloat z)
{
    __npy_cfloat_to_c99_cast z1 = {z};
    __npy_cfloat_to_c99_cast ret;
    ret.c99_z = clogf(z1.c99_z);
    return ret.npy_z;
}
#endif

#line 267
#if HAVE_CSQRTF
DL_EXPORT(npy_cfloat) npy_csqrtf(npy_cfloat z)
{
    __npy_cfloat_to_c99_cast z1 = {z};
    __npy_cfloat_to_c99_cast ret;
    ret.c99_z = csqrtf(z1.c99_z);
    return ret.npy_z;
}
#endif

#line 267
#if HAVE_CCOSF
DL_EXPORT(npy_cfloat) npy_ccosf(npy_cfloat z)
{
    __npy_cfloat_to_c99_cast z1 = {z};
    __npy_cfloat_to_c99_cast ret;
    ret.c99_z = ccosf(z1.c99_z);
    return ret.npy_z;
}
#endif

#line 267
#if HAVE_CSINF
DL_EXPORT(npy_cfloat) npy_csinf(npy_cfloat z)
{
    __npy_cfloat_to_c99_cast z1 = {z};
    __npy_cfloat_to_c99_cast ret;
    ret.c99_z = csinf(z1.c99_z);
    return ret.npy_z;
}
#endif


#line 282
#if HAVE_CPOWF
DL_EXPORT(npy_cfloat) npy_cpowf(npy_cfloat x, npy_cfloat y)
{
    __npy_cfloat_to_c99_cast xcast = {x};
    __npy_cfloat_to_c99_cast ycast = {y};
    __npy_cfloat_to_c99_cast ret;
    ret.c99_z = cpowf(xcast.c99_z, ycast.c99_z);
    return ret.npy_z;
}
#endif



#line 249

#line 254
#if HAVE_CABS
DL_EXPORT(npy_double) npy_cabs(npy_cdouble z)
{
    __npy_cdouble_to_c99_cast z1 = {z};
    return cabs(z1.c99_z);
}
#endif

#line 254
#if HAVE_CARG
DL_EXPORT(npy_double) npy_carg(npy_cdouble z)
{
    __npy_cdouble_to_c99_cast z1 = {z};
    return carg(z1.c99_z);
}
#endif


#line 267
#if HAVE_CEXP
DL_EXPORT(npy_cdouble) npy_cexp(npy_cdouble z)
{
    __npy_cdouble_to_c99_cast z1 = {z};
    __npy_cdouble_to_c99_cast ret;
    ret.c99_z = cexp(z1.c99_z);
    return ret.npy_z;
}
#endif

#line 267
#if HAVE_CLOG
DL_EXPORT(npy_cdouble) npy_clog(npy_cdouble z)
{
    __npy_cdouble_to_c99_cast z1 = {z};
    __npy_cdouble_to_c99_cast ret;
    ret.c99_z = clog(z1.c99_z);
    return ret.npy_z;
}
#endif

#line 267
#if HAVE_CSQRT
DL_EXPORT(npy_cdouble) npy_csqrt(npy_cdouble z)
{
    __npy_cdouble_to_c99_cast z1 = {z};
    __npy_cdouble_to_c99_cast ret;
    ret.c99_z = csqrt(z1.c99_z);
    return ret.npy_z;
}
#endif

#line 267
#if HAVE_CCOS
DL_EXPORT(npy_cdouble) npy_ccos(npy_cdouble z)
{
    __npy_cdouble_to_c99_cast z1 = {z};
    __npy_cdouble_to_c99_cast ret;
    ret.c99_z = ccos(z1.c99_z);
    return ret.npy_z;
}
#endif

#line 267
#if HAVE_CSIN
DL_EXPORT(npy_cdouble) npy_csin(npy_cdouble z)
{
    __npy_cdouble_to_c99_cast z1 = {z};
    __npy_cdouble_to_c99_cast ret;
    ret.c99_z = csin(z1.c99_z);
    return ret.npy_z;
}
#endif


#line 282
#if HAVE_CPOW
DL_EXPORT(npy_cdouble) npy_cpow(npy_cdouble x, npy_cdouble y)
{
    __npy_cdouble_to_c99_cast xcast = {x};
    __npy_cdouble_to_c99_cast ycast = {y};
    __npy_cdouble_to_c99_cast ret;
    ret.c99_z = cpow(xcast.c99_z, ycast.c99_z);
    return ret.npy_z;
}
#endif



#line 249

#line 254
#if HAVE_CABSL
DL_EXPORT(npy_longdouble) npy_cabsl(npy_clongdouble z)
{
    __npy_clongdouble_to_c99_cast z1 = {z};
    return cabsl(z1.c99_z);
}
#endif

#line 254
#if HAVE_CARGL
DL_EXPORT(npy_longdouble) npy_cargl(npy_clongdouble z)
{
    __npy_clongdouble_to_c99_cast z1 = {z};
    return cargl(z1.c99_z);
}
#endif


#line 267
#if HAVE_CEXPL
DL_EXPORT(npy_clongdouble) npy_cexpl(npy_clongdouble z)
{
    __npy_clongdouble_to_c99_cast z1 = {z};
    __npy_clongdouble_to_c99_cast ret;
    ret.c99_z = cexpl(z1.c99_z);
    return ret.npy_z;
}
#endif

#line 267
#if HAVE_CLOGL
DL_EXPORT(npy_clongdouble) npy_clogl(npy_clongdouble z)
{
    __npy_clongdouble_to_c99_cast z1 = {z};
    __npy_clongdouble_to_c99_cast ret;
    ret.c99_z = clogl(z1.c99_z);
    return ret.npy_z;
}
#endif

#line 267
#if HAVE_CSQRTL
DL_EXPORT(npy_clongdouble) npy_csqrtl(npy_clongdouble z)
{
    __npy_clongdouble_to_c99_cast z1 = {z};
    __npy_clongdouble_to_c99_cast ret;
    ret.c99_z = csqrtl(z1.c99_z);
    return ret.npy_z;
}
#endif

#line 267
#if HAVE_CCOSL
DL_EXPORT(npy_clongdouble) npy_ccosl(npy_clongdouble z)
{
    __npy_clongdouble_to_c99_cast z1 = {z};
    __npy_clongdouble_to_c99_cast ret;
    ret.c99_z = ccosl(z1.c99_z);
    return ret.npy_z;
}
#endif

#line 267
#if HAVE_CSINL
DL_EXPORT(npy_clongdouble) npy_csinl(npy_clongdouble z)
{
    __npy_clongdouble_to_c99_cast z1 = {z};
    __npy_clongdouble_to_c99_cast ret;
    ret.c99_z = csinl(z1.c99_z);
    return ret.npy_z;
}
#endif


#line 282
#if HAVE_CPOWL
DL_EXPORT(npy_clongdouble) npy_cpowl(npy_clongdouble x, npy_clongdouble y)
{
    __npy_clongdouble_to_c99_cast xcast = {x};
    __npy_clongdouble_to_c99_cast ycast = {y};
    __npy_clongdouble_to_c99_cast ret;
    ret.c99_z = cpowl(xcast.c99_z, ycast.c99_z);
    return ret.npy_z;
}
#endif




